# Jonathan Lowenhar - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Jonathan Lowenhar.

---

### (00:00:00) Lenny Rachitsky

**English:**
You basically spend all your time working with founders, and through that studying, you create frameworks and training and you use that in your work. I think that's what many, many founders are looking for is how do I avoid pain?

**中文翻译:**
你基本上把所有时间都花在与创始人合作上，通过这些研究，你创建了各种框架和培训，并将其应用到工作中。我认为这正是许许多多创始人所寻找的：我该如何避免痛苦？

---

### (00:00:11) Jonathan Lowenhar

**English:**
To be a founder is a state of being, it's an attitude. To be a CEO is a craft. The more founders who can accept that those are two separate things and they're both equally important to build an ascendant startup, the better all of us will be.

**中文翻译:**
“创始人”是一种生存状态，是一种态度；而“CEO”则是一门手艺（专业技能）。越多的创始人能接受这是两件独立的事情，并且意识到两者对于建立一家蒸蒸日上的初创企业同样重要，我们大家的情况就会越好。

---

### (00:00:26) Lenny Rachitsky

**English:**
I'm kind of tired of talking about founder mode, but it feels like what you're describing is founder mode and manager mode.

**中文翻译:**
我有点厌倦谈论“创始人模式”了，但感觉你描述的正是“创始人模式”和“管理者模式”。

---

### (00:00:30) Jonathan Lowenhar

**English:**
Founder mode gets me angry. That article just got me hot. It really felt like an excuse. We were giving founders a permission to not learn the job. It's not manager mode is bad, it's the greatest CEOs know when to calibrate which one is needed.

**中文翻译:**
“创始人模式”让我很生气。那篇文章（保罗·格雷厄姆的文章）让我火大。它感觉就像是一个借口。我们是在给创始人不学习这项工作的许可。并不是说“管理者模式”不好，而是最伟大的 CEO 知道何时去调整和校准到底需要哪种模式。

---

### (00:00:46) Lenny Rachitsky

**English:**
Something you talk about, there's these two phases to a startup journey and most people focus on the first phase.

**中文翻译:**
你谈到过，初创企业的旅程有两个阶段，而大多数人只关注第一阶段。

---

### (00:00:51) Jonathan Lowenhar

**English:**
Phase one is build something people want to buy. Phase two, the one we don't talk about is now you have to build a company around that thing people want to buy. Building a company is always the same. I don't care if it's MedTech or fintech or hardware or consumer.

**中文翻译:**
第一阶段是做出人们想要购买的东西。第二阶段，也就是我们不常谈论的那个，是现在你必须围绕那个“人们想买的东西”建立一家公司。建立公司的逻辑总是一样的，无论它是医疗科技、金融科技、硬件还是消费品。

---

### (00:01:04) Lenny Rachitsky

**English:**
You've come up with this methodology that you call the Magic Box paradigm that helps founders think about how to lead to a successful exit long-term.

**中文翻译:**
你提出了一套被称为“魔盒范式”（Magic Box paradigm）的方法论，帮助创始人思考如何实现长期的成功退出。

---

### (00:01:11) Jonathan Lowenhar

**English:**
This is a traditional sales process. You build a list of the companies that might want to acquire you, you ping them and you hope you get a deal. Magic Box argues that the best outcomes for early-stage startups don't happen that way. You're never for sale. In fact, you have seduced a buyer. They see the fantasy, they fall in love.

**中文翻译:**
传统的销售过程是这样的：你列出一份可能想收购你的公司名单，联系他们，然后希望达成交易。而“魔盒”理论认为，初创企业最好的结果并非如此。你永远不是“待售”状态。事实上，是你“诱惑”了买家。他们看到了某种幻想，然后坠入爱河。

---

### (00:01:35) Lenny Rachitsky

**English:**
Today, my guest is Jonathan Lowenhar. Jonathan runs a firm called Enjoy The Work, which I've heard amazing things about from so many people over the years. Their firm has a singular mission, to help founders become great CEOs. They do this through a blend of mentoring and advising services, which are rooted in their study of how the best startups operate. They take these lessons and fold them into frameworks and advice and training that they offer their CEOs, their insight, which you'll hear in our conversation, is that most founders don't come into the job knowing how to be a CEO, which includes learning how to do hiring, how to manage financials, figure out growth strategy, road mapping, planning, people management, and so many other skills that nobody teaches a founder.
(00:02:16):
In our conversation, Jonathan shares the most common CEO failure modes that he and his team have seen, the Magic Box paradigm for successfully selling your startup, a bunch of advice for finding and hiring the best talent, a framework for building a repeatable go-to-market motion, why and how you should learn to trust your intuition more as a founder and so much more. We could have gone on for so many more hours. Maybe he'll be back to share more advice. If you're a founder or hope to be a founder one day, this episode is for you. If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. It's the best way to avoid missing feature episodes and it helps the podcast tremendously. With that, I bring you Jonathan Lowenhar. Jonathan, thank you so much for being here. Welcome to the podcast.

**中文翻译:**
今天的嘉宾是 Jonathan Lowenhar。Jonathan 经营着一家名为 Enjoy The Work 的公司，多年来我从很多人那里听到了关于这家公司的赞誉。他们的公司有一个唯一的使命：帮助创始人成为伟大的 CEO。他们通过结合导师辅导和咨询服务来实现这一目标，这些服务根植于他们对顶级初创企业运作方式的研究。他们将这些经验总结成框架、建议和培训提供给 CEO 们。他们的核心洞察（你将在我们的对话中听到）是：大多数创始人上任时并不知道如何当好一名 CEO，这包括学习如何招聘、如何管理财务、制定增长策略、规划路线图、制定计划、人员管理以及许多其他没人教过创始人的技能。
(00:02:16):
在我们的对话中，Jonathan 分享了他和他的团队见过的最常见的 CEO 失败模式、成功出售初创企业的“魔盒范式”、一系列寻找和招聘顶尖人才的建议、建立可重复的市场进入（GTM）机制的框架、为什么以及如何作为创始人学会更多地信任自己的直觉，等等。我们本可以聊上好几个小时。也许他以后还会回来分享更多建议。如果你是创始人或希望有一天成为创始人，这一集就是为你准备的。如果你喜欢这个播客，别忘了在您最喜欢的播客应用或 YouTube 上订阅和关注。这是避免错过未来节目的最好方式，也对播客有巨大的帮助。现在，让我们欢迎 Jonathan Lowenhar。Jonathan，非常感谢你能来。欢迎来到本播客。

---

### (00:03:03) Jonathan Lowenhar

**English:**
Lenny, I am damn excited.

**中文翻译:**
Lenny，我真的非常兴奋。

---

### (00:03:05) Lenny Rachitsky

**English:**
So am I. The reason I'm excited to have you in this podcast is that you basically spend all your time working with founders, and through that studying, what causes them pain, what causes them to fail, what causes them to struggle, and then you take that and you create frameworks and training and you use that in your work with founders, and I think that's what many, many founders are looking for is how do I avoid pain? How do I avoid these things that I'm going to probably run into? To build on that, briefly, can you just help people understand what it is you do, what it is your organization does with founders, how you work with founders?

**中文翻译:**
我也是。我之所以兴奋能请到你，是因为你基本上把所有时间都花在与创始人打交道上，并借此研究是什么让他们痛苦、是什么导致他们失败、是什么让他们挣扎，然后你将这些总结成框架和培训，应用到与创始人的合作中。我认为这正是许多创始人想要的：我该如何避免痛苦？我该如何避开那些我可能会遇到的坑？在此基础上，你能简要帮助大家理解一下你是做什么的，你的组织是如何与创始人合作的吗？

---

### (00:03:38) Jonathan Lowenhar

**English:**
Yeah, thank you. I'll tell a bit of origin story that I think ends up answering that question.

**中文翻译:**
好的，谢谢。我来讲一点背景故事，我想这最终能回答那个问题。

---

### (00:03:43) Lenny Rachitsky

**English:**
Let's do it.

**中文翻译:**
开始吧。

---

### (00:03:45) Jonathan Lowenhar

**English:**
I had run a bunch of different types of companies and they were really different ones. I ran a big division for a public company, then I was a private equity CEO, then I did back-to-back startups. The first one didn't get very far, but we sold it, and the second one got really far. When I left the second one, I was like many founders, grossly unhealthy, 25 pounds overweight, wasn't sleeping enough, all the things. I took a few months to get healthy and then reflect on those parts of my career. One of the things that I noticed at the time was all of those companies, when they got to a good place, when they started to run well, they were all run well in the same way. How could this be? How could public company, private equity, startups, early stage, growth stage, when they were run well, they were all run well the same way?
(00:04:35):
I started to obsess about this question, and what it led me to realize is that every well-run company has a rhythm. It's unmistakable, you can't miss it. You can't not see it. You just spend a couple of days through a spy cam watching a business, you'll see the pattern. How come some startups get there and some don't? How does a founder learn the rhythm? How do they learn how to run a company well? I started to ask investors obsessively, and I asked them, Lenny, I asked them all three questions, same three over and over and over again.
(00:05:14):
First question was, well, describe to me your ideal founder. What's a great founder? The answers universally were the same. Investors would use words that meant grit and tenacity and courage and insight, and I'd say, "Great. Question number two, describe to me a great startup CEO," and they use none of those words. How can that possibly be true? Instead, they describe skills. This is a person who knows how to build stuff and sell stuff and recruit people and raise capital and organize humans and financially plan. Question number three, my final one, well, how does a founder learn those skills while doing the job? I got blank fucking stares, over and over again. It led me down this path that I'm now 10 years into with my colleagues of, well, how do we help founders learn those skills so that their venture investors don't fire them, so that they can actually go build whatever company they want to build and stay in the job for as long as they want to stay in the job? That's origin, that's what got me going.

**中文翻译:**
我曾经经营过许多不同类型的公司，而且它们非常不同。我曾管理过一家上市公司的庞大部门，然后做过私募股权公司的 CEO，接着连续做了两家初创公司。第一家没走多远，但我们把它卖了；第二家走得很远。当我离开第二家公司时，我和许多创始人一样，身体极度不健康，超重 25 磅，睡眠不足，各种毛病。我花了几个月时间恢复健康，然后反思职业生涯的那些阶段。当时我注意到的一件事是，所有这些公司，当它们处于良好状态、开始运作良好时，它们的运作方式竟然是一模一样的。这怎么可能？上市公司、私募股权、初创公司、早期阶段、增长阶段，当它们运作良好时，竟然都是以同样的方式运作的？
(00:04:35):
我开始痴迷于这个问题，这让我意识到：每一家运作良好的公司都有一种“节奏”。它是显而易见的，你不可能错过。你只要通过监控摄像头观察一家企业几天，你就能看到这种模式。为什么有些初创公司能达到那种状态，而有些不能？创始人如何学习这种节奏？他们如何学习如何管理好一家公司？我开始疯狂地询问投资者，Lenny，我一遍又一遍地问他们同样的三个问题。
(00:05:14):
第一个问题是：“请向我描述你理想中的创始人。什么是伟大的创始人？”答案几乎完全一致。投资者会使用代表毅力、韧性、勇气和洞察力的词。我会说：“太好了。第二个问题：请向我描述一个伟大的初创公司 CEO。”结果他们完全没用到前面那些词。这怎么可能呢？相反，他们描述的是“技能”。这是一个知道如何制造产品、销售产品、招聘人才、筹集资金、组织人员和进行财务规划的人。第三个问题，也是最后一个：“那么，创始人如何在工作中学习这些技能呢？”我得到的只有一遍又一遍的、该死的茫然注视。这引导我走上了这条路，我和我的同事们已经在这条路上走了 10 年：我们如何帮助创始人学习这些技能，好让他们的风险投资者不解雇他们，好让他们能真正去建立他们想建立的任何公司，并想干多久就干多久？这就是起源，这就是让我开始的原因。

---

### (00:06:27) Lenny Rachitsky (Ad Segment)

**English:**
This episode is brought to you by Pendo, the only all-in-one product experience platform for any type of application... (Ad content omitted for brevity in this sample, but full translation would follow the same pattern).

**中文翻译:**
本集节目由 Pendo 赞助，这是唯一一款适用于任何类型应用程序的全方位产品体验平台……（广告内容略，实际操作中需完整翻译）。

---

### (00:09:34) Lenny Rachitsky

**English:**
There's obviously this new meme of founder mode. I'm kind of tired of talking about founder mode, but it feels like what you're describing is founder mode and manager mode. You basically have to be good at both. This latter part is almost manager mode. Is that a way to think about it?

**中文翻译:**
显然，现在有一个关于“创始人模式”的新梗。我有点聊腻了，但感觉你描述的正是“创始人模式”和“管理者模式”。你基本上必须两者兼顾。你说的后半部分几乎就是管理者模式。可以这样理解吗？

---

### (00:09:34) Jonathan Lowenhar

**English:**
Yes. Founder mode gets me angry. That article just got me hot. It really felt like an excuse. We were giving founders a permission to not learn the job. If we think about an ascending startup, there's this phase of I have to invent something. I now have to figure out how to get my customer in front of this invention and see if it works, and then I have to build a business model around that to see if there's some repeatable way to attract, win, deploy my customer and thrill them with whatever the solution is. Okay, now I have to go build an enormous amount of demand and then I have to build up an operation that can handle all that demand. Oh, and by the way, at some point, figure out how to turn positive revenues into positive cash flows. The idea that the founder who's writing code by themselves doesn't have to advance their skills to learn how to do all those things, and that in fact what the article even implies is learning how to do those other things is a negative is bananas to me.
(00:10:52):
The things required to launch a company are not the same as grow a company as scale a company as exit a company, and the best startup CEOs learn them all along the way. There are lots of ways to learn them. I'm not suggesting there's only one path, but founder mode was almost an excuse not to. I do think what's unique about a founder that felt perhaps where that article was trying to go is that unlike the professional mercenary CEO that gets dropped in, the founder knows everything about what built this company and they can drop in at the most granular level and play anywhere. They can drop into a product feature, they can drop into a customer conversation or a partner conversation or with a long-time employee that's still in IC and be impactful and then rise back up if they've gone the training and get back into a cockpit to run the company again. That's to me the distinction. It's not manager mode is bad, it's the greatest CEOs know when to calibrate which one is needed.

**中文翻译:**
是的。“创始人模式”让我很生气。那篇文章真的让我火大。它感觉就像是一个借口。我们是在给创始人不学习这项工作的许可。如果我们思考一个处于上升期的初创公司，它有一个阶段是“我必须发明点什么”。然后我必须弄清楚如何让客户看到这个发明并看看它是否奏效，接着我必须围绕它建立一个商业模式，看看是否有某种可重复的方式来吸引、赢得、部署客户，并用解决方案让他们感到兴奋。好，现在我必须去创造巨大的需求，然后建立起一套能处理这些需求的运营体系。哦，顺便说一句，在某个时刻，还得弄清楚如何将正收入转化为正现金流。如果认为那个独自写代码的创始人不需要提升技能去学习如何做这些事，甚至那篇文章还暗示学习做这些事是负面的，这对我来说简直是疯了。
(00:10:52):
创办公司所需的技能，与增长公司、规模化公司、退出公司所需的技能是不一样的，而最好的初创公司 CEO 会一路学习这些技能。有很多方法可以学习，我并不是说只有一条路，但“创始人模式”几乎成了不学习的借口。我确实认为创始人有其独特之处，这也许是那篇文章想要表达的：与空降的职业经理人（雇佣兵 CEO）不同，创始人了解公司建立过程中的一切，他们可以深入到最细微的层面并在任何地方发挥作用。他们可以深入研究一个产品功能，可以参与客户对话或合作伙伴对话，或者与一名资深的个人贡献者（IC）交流并产生影响，如果他们接受过培训，他们还能重新升回到驾驶舱继续管理公司。对我来说，这就是区别。并不是说“管理者模式”不好，而是最伟大的 CEO 知道何时去校准到底需要哪种模式。

---

### (00:12:31) Lenny Rachitsky

**English:**
Something you talk about, there's these two phases to a startup journey and most people focus on the first phase... (Transitioning to failure modes). Can you just share these modes that you've come up with?

**中文翻译:**
你谈到过初创企业旅程的两个阶段……（转向失败模式）。你能分享一下你们总结出的这些模式吗？

---

### (00:12:31) Jonathan Lowenhar

**English:**
We do take a bit of a comical approach to some of this... I think if I would separate failure modes for companies versus CEOs for a minute, the company ones are not quite as comedic, but they are ones we see all the time. One is you chose the wrong market... Second... build something people want to buy... Third one, founder's function. We like to joke that more companies die from suicide than homicide... Then fourth, execution, and execution now leads back to CEO. Okay, so now we have a bunch of playful ones here.
(00:13:57) We have the **robot CEO**, who believes emotion should not ever exist at a startup...
(00:14:56) Second one is a **pleaser CEO**. This is the person who is far more concerned with being liked than running a business...
(00:15:36) Next one is a **perfectionist CEO**. I'd like to say that these are the CEOs with the most beautiful product to be delivered minutes before they file for bankruptcy...
(00:16:15) Next one is the **angry CEO**...
(00:17:09) The next one is the one that drives me particularly crazy, it's the **laissez-faire CEO**, who insanely believes that I can just hire great people and utterly ignore them...
(00:18:49) ...the **ready, fire, aim** CEO. Most CEOs are really bad at planning...
(00:19:42) The **micromanager** one is the opposite of laissez-faire. They believe that no matter how many employees they have, they can do the job better.

**中文翻译:**
我们对其中一些内容采取了有点幽默的处理方式……如果我把公司层面的失败模式和 CEO 层面的分开来看，公司的失败模式没那么搞笑，但很常见。第一是选错了市场……第二是没做出人们想买的东西……第三是创始人功能失调。我们常开玩笑说，死于自杀的公司比死于他杀的更多……第四是执行力，而执行力最终又回到了 CEO 身上。好，现在我们有一些有趣的 CEO 失败模式：
(00:13:57) 我们有**机器人型 CEO**，他认为初创公司不该有情感。我们会教他们一个简单的公式：情感很麻烦，人类有情感，初创公司需要人类，因此初创公司很麻烦。
(00:14:56) 第二种是**讨好型 CEO**。这种人更在乎被喜欢，而不是经营业务。他们不敢告诉别人坏消息，不敢做决策，凡事都想达成共识，而这根本不可能。
(00:15:36) 下一个是**完美主义型 CEO**。我常说，这类 CEO 拥有最漂亮的产品，但往往在申请破产前几分钟才交付。他们太在乎“正确”，导致速度太慢且不敢冒险。
(00:16:15) 下一个是**愤怒型 CEO**……没人想为愤怒的人工作，一旦有更好的去处，员工就会离开。
(00:17:09) 下一个让我特别抓狂的是**放任自流型 CEO**，他疯狂地认为只要雇到优秀的人，就可以完全不管他们。我从未见过哪个优秀的人不需要良好的管理。
(00:18:49) 还有**先开火再瞄准型 CEO**。大多数 CEO 都不擅长规划。他们觉得规划是官僚主义，但缺乏规划会导致公司破产。
(00:19:42) **微观管理型 CEO** 是放任自流型的反面。他们认为无论雇了多少人，自己都能做得更好。这极度不尊重员工，而且会导致员工集体辞职。

---

### (00:22:02) Jonathan Lowenhar (On "Ready, Fire, Aim")

**English:**
I think ready, fire, aim is the most common that we've seen... Better operators means eventually being on a path when more cash comes into the business and out of the business. That doesn't happen by accident. The ready, fire, aim CEO has probably suffered this pain where they took lots and lots of bets... Basic, basic business design and business planning is not some corporate effort. It's some thoughtful exercise that starts with what are we working backwards from? Because in any given time, Lenny, companies are working backwards from one of four things... I am working backwards from an exit. I'm working backwards from a next fundraise. I'm working backwards from profitability or I'm working backwards from winding down.

**中文翻译:**
我认为“先开火再瞄准”是我们见过的最常见的类型。成为更好的运营者意味着最终要走上一条“流入公司的现金多于流出”的道路。这不会偶然发生。这类 CEO 可能经历过这种痛苦：他们做了大量的赌注，结果却一次次昂贵地出错。基础的业务设计和规划并不是某种企业官僚行为，而是一种深思熟虑的练习，从“我们要倒推的目标是什么”开始。因为在任何特定时间，Lenny，公司都在从以下四件事之一进行倒推：倒推实现退出（卖掉公司）、倒推下一轮融资、倒推实现盈利，或者倒推关门清算。

---

### (00:26:36) Lenny Rachitsky (On Magic Box Paradigm)

**English:**
You've come up with this methodology that you call the Magic Box Paradigm... helps founders think about how to lead to a successful exit long-term. Can you talk about what this is?

**中文翻译:**
你提出了这套被称为“魔盒范式”的方法论……帮助创始人思考如何实现长期的成功退出。你能聊聊这是什么吗？

---

### (00:26:46) Jonathan Lowenhar

**English:**
I can, and I want to give credit where it's due. There's a book by this name, it's called Magic Box Paradigm, written by an independent banker named Ezra Roizen... What Magic Box argues, is that the best outcomes for early-stage startups don't happen that way [traditional sales]. You're never for sale. In fact, you have seduced a buyer. There are three stages to Magic Box work. There is **learn the fantasy**, there's **prove the fantasy**, and there's **quantify the fantasy**.

**中文翻译:**
可以，我想先归功于原作者。有一本同名的书叫《魔盒范式》，是由一位名叫 Ezra Roizen 的独立银行家写的。“魔盒”理论认为，初创企业最好的结果不是通过传统的销售流程达成的。你永远不是“待售”状态。事实上，是你“诱惑”了买家。“魔盒”工作有三个阶段：**了解幻想**、**证明幻想**和**量化幻想**。

---

### (00:29:12) Jonathan Lowenhar (The Instagram Example)

**English:**
The classic example of this is Instagram... Lenny, do you remember how much revenue they had when they got acquired by now Meta? I think it was zero. Do you remember the acquisition price? A billion dollars... There was no math Facebook could use, historically speaking, that would justify a billion dollars. It had to be a model on the future. This is Magic Box to a T. They had a fantasy that adding Instagram would expand ad revenue. They figured out some way to prove it... And then their quantification was based on the future.

**中文翻译:**
最经典的例子就是 Instagram。Lenny，你记得它们被现在的 Meta 收购时有多少收入吗？我想是零。你记得收购价格吗？10 亿美元。从历史数据来看，Facebook 没有任何数学模型能证明这 10 亿美元是合理的。它必须是一个基于未来的模型。这就是典型的“魔盒”。他们有一个“幻想”：加入 Instagram 会扩大广告收入。他们找到了某种方法来证明这一点……然后他们的量化是基于未来的。

---

### (00:32:20) Jonathan Lowenhar (The Characters)

**English:**
There are four characters you're going to meet along the path of Magic Box... You're going to meet your **champion**, you're going to meet your **advocates**, you're going to meet your **blockers**, and you're going to meet your **buyer**. You might meet Corp Dev along the way.

**中文翻译:**
在“魔盒”之路上，你会遇到四个角色：你会遇到你的**拥护者（Champion）**，你会遇到你的**支持者（Advocates）**，你会遇到你的**阻碍者（Blockers）**，还有你的**买家（Buyer）**。途中你还可能遇到企业发展部（Corp Dev）。拥护者是爱上你的人；买家是只看数学模型、有权签字的人；支持者是为你加油但不会承担政治风险的人；阻碍者是不能说“行”但能说“不行”的人（如法务、采购）。

---

### (00:39:39) Jonathan Lowenhar (Negotiating with Corp Dev)

**English:**
Founders, repeat after me, I'm talking to you directly now. You'll say to Corp Dev, "You know I'm not alone in this decision. I love what you just said and I'm excited about this opportunity. Once I see it in writing, I can socialize it with advisors, lawyers, co-founders, whoever." But don't negotiate live. You will lose.

**中文翻译:**
创始人，跟我重复一遍，我现在直接对你们说。你要对企业发展部的人说：“你知道这个决定不是我一个人做的。我很喜欢你刚才说的，也对这个机会感到兴奋。一旦我看到书面方案，我就可以把它传达给顾问、律师、联合创始人或其他任何人。”千万不要现场谈判。你会输的。

---

### (00:50:27) Jonathan Lowenhar (On Hiring)

**English:**
We think the CEO has three jobs... One is, make sure everyone knows where we're going. The second one, pick the right people for the team. Third one, give those people the tools they need to win... I think there are three core mistakes that founders make all the time... The first one is, you should hire people who have already done the thing you need to have done next... Second, the notion of does the person in front of you have a history of creating raving fans? ... Third, core values matter a lot.

**中文翻译:**
我们认为 CEO 有三项工作：第一，确保每个人都知道我们要去哪里。第二，为团队挑选合适的人。第三，给这些人获胜所需的工具。我认为创始人常犯三个核心错误：第一，你应该雇佣那些已经做过你下一步需要做的事情的人。第二，看你面前的人是否有“创造狂热粉丝”的历史（即前任老板是否愿意再次雇佣他们）。第三，核心价值观非常重要。文化不是偶然产生的。

---

### (01:03:37) Jonathan Lowenhar (Go-To-Market Framework)

**English:**
We think of it in four pieces. The first piece is **ideal customer profile (ICP)**. Who do we really want to sell to? ... Second bucket, loosely called **marketing**. But within that marketing is also positioning... Next is **demand gen**, which we'll simplify to say, how do we go find the humans we want? ... And then fourth, **sales**. And this is the codification of a playbook.

**中文翻译:**
我们将市场进入（GTM）分为四个部分。第一部分是**理想客户画像（ICP）**：我们到底想卖给谁？第二部分，宽泛地称为**营销（Marketing）**，其中包括定位：我们与竞争对手有什么不同？第三部分是**需求挖掘（Demand Gen）**，简单说就是：我们如何找到我们想要的人？第四部分是**销售（Sales）**，也就是将销售流程编写成“剧本”（Playbook）。

---

### (01:06:35) Jonathan Lowenhar (Brainwriting vs. Brainstorming)

**English:**
Brainwriting is I'm going to expose an idea and I want everyone to now write and weigh in on there... in an async way that no one else can see until it's all combined... What it allows for is the dampening of the founder effect in meetings... and an evening of the playing field between fast processors and slow processors, introverts and extroverts.

**中文翻译:**
“脑写”（Brainwriting）是我抛出一个想法，然后让每个人都写下来并发表意见……以一种异步的方式，在汇总之前谁也看不见谁的。这样做可以减弱会议中的“创始人效应”（即大家不敢反驳老板），并为快速思考者和慢速思考者、内向者和外向者提供一个公平的竞争环境。

---

### (01:15:31) Jonathan Lowenhar (Trusting Intuition)

**English:**
Do you know that little voice when you get really still, the quiet one that says you should marry this person, you should take this job, you should start this company? ... That voice is who you are. It's not your brain. Your brain is a tool... It's a pattern recognition machine. But who you are, if you can watch your brain, you know what you're thinking... That means you're not your brain. It's something else. And that's the little voice, and that little voice is going to be right.

**中文翻译:**
当你真正安静下来时，你听过那个微弱的声音吗？那个安静的声音会告诉你：你应该和这个人结婚，你应该接这份工作，你应该创办这家公司。那个声音才是真正的你。它不是你的大脑。你的大脑只是一个工具，一个模式识别机器。但如果你能观察自己的大脑，知道自己在想什么，那就意味着你不是你的大脑，你是别的东西。那就是那个微弱的声音，而那个声音通常是正确的。

---

### (01:21:04) Jonathan Lowenhar (Founder vs. CEO)

**English:**
To be a founder is a state of being. It's an attitude, it's courage, it's instinct... To be a CEO is a craft. The more founders who can accept that those are two separate things and they're both equally important to build an ascendant startup, the better all of us will be.

**中文翻译:**
成为创始人是一种生存状态。它是一种态度、勇气和本能。而成为 CEO 是一门手艺。越多的创始人能接受这是两件独立的事情，并且意识到两者对于建立一家蒸蒸日上的初创企业同样重要，我们大家的情况就会越好。

---

### (01:27:04) Jonathan Lowenhar (Life Motto)

**English:**
The first one... is that there is only one life... Stop assuming that there are these pretend walls between them or among them... I try and show up the same way, no matter my setting. If you and I were having a beer or a meal, or if I'm sitting with one of my co-founders or clients, it doesn't matter, I show up the same way everywhere.

**中文翻译:**
我的座右铭是：生命只有一次。不要再假设生活、工作和社交之间存在那些虚假的隔墙。无论在什么环境下，我都努力以同样的面貌出现。无论是我和你一起喝啤酒吃饭，还是我和我的联合创始人或客户坐在一起，都没关系，我在任何地方都表现得一模一样。

---

### (01:28:32) Jonathan Lowenhar (The Casino Story)

**English:**
I turned 21... we take a family trip to Las Vegas... I win $35,421.92. For the trip I ended up winning $40,000 that I turned $300 to... which has left me with one of my mantras that I've had for the rest of my life... that is gambling does pay.

**中文翻译:**
我 21 岁那天，我们全家去拉斯维加斯旅行。我赢了 35,421.92 美元。那次旅行我最终用 300 美元赢了 4 万美元。这给我留下了一个伴随终生的信条（虽然有些人会翻白眼）：赌博确实有回报。

---

### (01:32:10) Jonathan Lowenhar (Closing)

**English:**
Who should ping us is very simple. If you're a founder out there, or a CEO out there, and you know in your heart that there's some gap between how you're running the business and how the company's going... we're here to help.

**中文翻译:**
谁应该联系我们？很简单。如果你是一名创始人或 CEO，而你内心深处知道，在你管理业务的方式与公司现状及潜力之间存在差距，我们就是来帮忙的。

---

### (01:34:11) Lenny Rachitsky

**English:**
Thank you so much for listening... See you in the next episode.

**中文翻译:**
非常感谢您的收听……下期节目再见。