# Jonny Miller - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Jonny Miller.

---

### [00:00:00] [Jonny Miller]

**English:**
I have this idea that I call the feather brick dump truck phenomenon, and basically what that means is when we are showing early signs of burnout, our body will give us feedback usually in subtle ways in the beginning. So the feather might be waking up in the morning and feeling a little bit tired, maybe a little bit exhausted. The brick, maybe you ignore that or you don't notice it, and then three or four weeks later, you have a fight with someone or an argument, or you just feel frustrated and terrible and you lose your cool. And then maybe the dump truck is a month later, or even a year later, there's a full-blown health crisis, or you develop type two diabetes or there's a whole range of things, or maybe you get fired. Ideally, you want to notice when it's the feather and then make adjustments or shift then and not have to wait until you experience the full-blown pain of the dump truck, which unfortunately is what happens to a lot of people, especially when they experience burnout for the first time.

**中文翻译:**
我有一个想法，我称之为“羽毛、砖头、自卸卡车”现象。基本上，它的意思是当我们出现职业倦怠（burnout）的早期迹象时，我们的身体通常会在开始时以微妙的方式给我们反馈。“羽毛”可能表现为早上醒来感到有点累，或者有一点疲惫。而“砖头”则是，也许你忽略了那个信号或者没注意到，三四周后，你和某人吵了一架，或者你只是感到沮丧和糟糕，失去了冷静。接着，“自卸卡车”可能是一个月后，甚至一年后，出现了一场全面的健康危机，比如患上二型糖尿病或一系列其他问题，又或者你被解雇了。理想情况下，你希望在还是“羽毛”阶段时就察觉到，然后做出调整或转变，而不是非要等到体验到“自卸卡车”带来的剧烈痛苦，不幸的是，很多人在第一次经历职业倦怠时都会面临这种情况。

---

### [00:01:02] [Lenny]

**English:**
Today, my guest is Jonny Miller. Jonny teaches courses and does one-on-one coaching with tech professionals helping them with something he calls Nervous System Mastery, which is essentially a set of tools and techniques for cultivating calm, upgrading your resilience, and increasing your aliveness. If you can get better at dealing with stressful situations, avoiding burnout and being more confident in meetings and big presentations, it becomes a superpower and a huge advantage in both business and in life. I actually read a post by Jonny about a year ago, and it totally changed the way that I think about nervousness and stress, and I still apply many of his lessons today.

**中文翻译:**
今天的嘉宾是 Jonny Miller。Jonny 教授课程并为科技专业人士提供一对一教练服务，帮助他们掌握他称之为“神经系统掌控力”（Nervous System Mastery）的东西。这本质上是一套用于培养冷静、提升韧性并增加生命活力的工具和技术。如果你能更好地应对压力情境、避免职业倦怠，并在会议和大场面演讲中更加自信，这就会成为一种超级力量，在商业和生活中都是巨大的优势。实际上，大约一年前我读过 Jonny 写的一篇文章，它完全改变了我对紧张和压力的看法，直到今天我仍在应用他的许多教诲。

---

### [00:01:41] [Lenny]

**English:**
In our conversation, we dive deep into Jonny's key insights. We talk about why the best way to stay calm in stressful situations is to focus on the state of your body and not your mind. How to create calm and confidence by changing the state of your body through breath. Jonny shares a bunch of very specific breathing exercises for creating calm and also for creating energy that we actually try out on the podcast. We also get into a bunch of advice for how to tell if you're seeing early signs of burnout, how to release emotional debt that you may be feeling. Also, why feeling the feels gives you a competitive advantage in business. Also, a practice called APE, which reminds you to focus on your awareness, your posture, and your emotions that have started practicing ever since our chat and so much more. If you enjoy this chat, definitely check out Jonny's full course at nsmastery.com/lenny. If you use that URL, you actually get $250 off the course. With that, I bring you Jonny Miller after a short word from our sponsors.

**中文翻译:**
在我们的对话中，我们深入探讨了 Jonny 的核心见解。我们讨论了为什么在压力情况下保持冷静的最佳方法是关注你的身体状态而非心态；如何通过呼吸改变身体状态来创造冷静和自信。Jonny 分享了一系列非常具体的呼吸练习，用于创造冷静以及激发能量，我们甚至在播客中亲身尝试了这些练习。我们还讨论了如何辨别职业倦怠的早期迹象，以及如何释放你可能感受到的“情感债”（emotional debt）。此外，还聊到了为什么“感受情绪”在商业中能给你带来竞争优势。还有一种叫做 APE 的练习，它提醒你关注自己的觉察（Awareness）、姿势（Posture）和情绪（Emotions），自从我们聊过之后我就开始练习这个了，还有很多其他内容。如果你喜欢这次对话，一定要去 nsmastery.com/lenny 查看 Jonny 的完整课程。使用该链接可以享受 250 美元的课程优惠。在听完赞助商的简短介绍后，我们将为您带来 Jonny Miller 的访谈。

---

### [00:02:42] [Lenny]

**English:**
This time of year is prime for career reflection and setting goals for professional growth. I always like to spend this time reflecting on what I accomplished the previous year, what I hope to accomplish the next year, and whether this is the year I look for a new opportunity. That's where today's sponsor Teal comes in. Teal provides you with the tools to run an amazing job search with an AI-powered resume builder, job tracker, cover letter generator, and Chrome extension that integrates with over 40 job boards. Teal is the all-in-one platform. You need to run a more streamlined and efficient job search and stand out in this competitive market. There's a reason nearly 1 million people have trusted Teal to run their job search. If you're thinking of making a change in the year, leverage Teal to grow your career on your own terms. Get started for free at tealhq.com/lenny. That's tealhq.com/lenny.

**中文翻译:**
每年的这个时候都是进行职业反思和设定职业成长目标的黄金时期。我总是喜欢花时间反思前一年的成就，希望在下一年实现的目标，以及今年是否是寻找新机会的一年。这就是今天的赞助商 Teal 大显身手的地方。Teal 为你提供了一套出色的求职工具，包括 AI 驱动的简历生成器、职位追踪器、求职信生成器，以及集成了 40 多个招聘网站的 Chrome 浏览器扩展。Teal 是一个全方位平台，你需要它来运行更精简、更高效的求职流程，并在竞争激烈的市场中脱颖而出。近 100 万人信任 Teal 来管理他们的求职过程是有原因的。如果你正考虑在今年做出改变，请利用 Teal 按照你自己的方式发展职业生涯。在 tealhq.com/lenny 免费开始使用。

---

### [00:03:33] [Lenny]

**English:**
This episode is brought to you by Vanta, helping you streamline your security compliance to accelerate your growth. Thousands of fast-growing companies like Gusto, Comm, Quora, and Modern Treasury trust Vanta to help build, scale, manage and demonstrate their security and compliance programs and get ready for audits in weeks, not months. By offering the most in demand security and privacy frameworks such as SOC 2, ISO 27001, GDPR, HIPAA, and many more. Vanta helps companies obtain the reports they need to accelerate growth, build efficient compliance processes, mitigate risks to their businesses, and build trust with external stakeholders. Over 5,000 fast-growing companies use Vanta to automate up to 90% of the work involved with SOC 2 and these other frameworks. For a limited time Lenny's podcast listeners get $1,000 off Vanta. Go to vanta.com/lenny, that's V-A-N-T-A.com/lenny to learn more and to claim your discounts get started today.

**中文翻译:**
本集节目由 Vanta 为您带来，帮助您简化安全合规流程以加速增长。数千家快速成长的公司，如 Gusto、Comm、Quora 和 Modern Treasury，都信任 Vanta 来帮助构建、扩展、管理和展示其安全合规计划，并在数周而非数月内做好审计准备。通过提供最受青睐的安全和隐私框架，如 SOC 2、ISO 27001、GDPR、HIPAA 等，Vanta 帮助公司获得加速增长所需的报告，建立高效的合规流程，降低业务风险，并与外部利益相关者建立信任。超过 5,000 家快速成长的公司使用 Vanta 自动完成 SOC 2 及其他框架中高达 90% 的工作。在限定时间内，Lenny 播客的听众可以享受 Vanta 1,000 美元的优惠。访问 vanta.com/lenny 了解更多信息并领取折扣，今天就开始吧。

---

### [00:04:34] [Lenny]

**English:**
Jonny, thank you so much for being here. Welcome to the podcast.

**中文翻译:**
Jonny，非常感谢你能来。欢迎来到本播客。

---

### [00:04:37] [Jonny Miller]

**English:**
It's great to be here, Lenny.

**中文翻译:**
很高兴来到这里，Lenny。

---

### [00:04:38] [Lenny]

**English:**
So I read this post that you wrote, I think it was over a year ago at this point. It was called The Operating Manual for Your Nervous System, and first of all, blew my mind when I read it. Second of all, I always think about it when I get nervous or anxious in a situation, it's really stuck with me. And I know that people in the workplace often get nervous and anxious doing all hand presentations, meetings, performance reviews, all the things. So I thought it'd be awesome just to dive into the stuff that you've uncovered about how we can become less nervous and less anxious. Before we get into the meat of it, I'd love to just spend a couple minutes just getting a sense of why you got into this stuff. What actually got you to spend so much of your energy and life force trying to understand how the nervous system works, how to get people to be less nervous and anxious.

**中文翻译:**
我读过你写的一篇文章，我想那是大概一年前的事了。文章题目叫《神经系统操作手册》，首先，读到它时我感到非常震撼。其次，每当我在某种情况下感到紧张或焦虑时，我总会想到它，它真的深深印在了我的脑海里。我知道职场人士在做全员演讲、开会、绩效评估等各种事情时经常会感到紧张和焦虑。所以我想，深入探讨一下你发现的关于如何减轻紧张和焦虑的方法会很棒。在我们进入核心内容之前，我想先花几分钟了解一下你为什么会钻研这些东西。究竟是什么让你投入如此多的精力和生命力去理解神经系统的工作原理，以及如何让人们变得不那么紧张和焦虑？

---

### [00:05:27] [Jonny Miller]

**English:**
My story starts in I kind of have a background in tech. I had a startup, we went through Techstars back in 2012. About five and a half years into that experience, I went through burnout, which is pretty common in the startup world, but that actually wasn't the trigger for me. I find that usually people that get into this type of work, there's some kind of catalyst or some kind of challenging life event. And for me, that was October 23rd, 2017, and my fiance at the time had an anxiety attack and she took her own life. And that completely just destroyed me at the time. And I realized that I'd been so disconnected from my body and my emotions, and it sent me on this five plus year journey to discover all of this inner landscape that I'd been numb from the neck down, and I went into breathwork meditation retreats, did hundreds of breathwork journeys, researched with a breath lab over in Bali, and basically just kind of directed all of my focus and attention onto understanding this inner landscape that I'd been pretty much oblivious to. And since then, I've been working with founders, executives, running courses and teaching what I'm learning and hopefully still researching at the same time as well.

**中文翻译:**
我的故事始于我的科技背景。我曾创办过一家初创公司，并在 2012 年参加了 Techstars 加速器。在那段经历的大约五年半后，我经历了职业倦怠，这在创业界很常见，但这其实并不是我的转折点。我发现，通常从事这类工作的人，背后都有某种催化剂或某种具有挑战性的生活事件。对我来说，那是 2017 年 10 月 23 日，我当时的未婚妻焦虑症发作，她结束了自己的生命。那件事在当时彻底击垮了我。我意识到自己一直与身体和情绪如此脱节，这开启了我长达五年多的旅程，去探索我那颈部以下一直处于麻木状态的内在景观。我参加了呼吸法（breathwork）冥想静修，进行了数百次呼吸之旅，在巴厘岛的一家呼吸实验室进行研究，基本上把我所有的焦点和注意力都转向了理解这个我几乎一直视而不见的内在世界。从那时起，我一直与创始人、高管合作，开设课程并教授我所学到的知识，同时也希望能继续进行研究。

---

### [00:06:52] [Lenny]

**English:**
Wow. And I imagine the thinking was that if your wife had these skills, she would've had another path.

**中文翻译:**
哇。我想你当时在想，如果你当时的未婚妻拥有这些技能，她可能会有另一条路。

---

### [00:07:00] [Jonny Miller]

**English:**
Yeah, that was definitely part of it, yeah. And also just since realizing how many people are struggling with anxiety, depression, all of this kind of constellation of mental health challenges both in the workplace and at home as well. And yeah, it's been a very rewarding journey.

**中文翻译:**
是的，那绝对是原因之一。而且我也意识到，无论是在职场还是在家庭中，有多少人正在与焦虑、抑郁以及这一系列心理健康挑战作斗争。是的，这是一段非常有意义的旅程。

---

### [00:07:19] [Lenny]

**English:**
All right, this episode's already gotten very heavy and I'm sucked in. I'm excited to learn all these things that you've uncovered. So let's just get into the meat of it. Just talk about this kind of general method that you've found for how to help people become less nervous and anxious.

**中文翻译:**
好的，这一集的内容已经变得非常沉重，我已经被深深吸引了。我很期待学习你发现的这些东西。那我们就进入核心部分吧。谈谈你发现的这种帮助人们减轻紧张和焦虑的通用方法。

---

### [00:07:38] [Jonny Miller]

**English:**
So I find this top down, bottom up distinction to be incredibly helpful. Most people when they try to calm down, they use tactical reframes or maybe mindfulness or maybe reframing the situation in a positive light. There's lots of different practices that people use which do have some effect. But in my experience, working with the physiology, using what's known as a bottom up approach, primarily using the breath, although there's also other approaches that you can use, it's just such a rapidly more effective way of shifting your state.
(00:08:11):
And to give a little bit of context and maybe some science as well, we have what's known as afferent and efferent neurons going up and down our body, and there's four times more afferent neurons going from the body to the brain as from the brain to the body. So you can almost imagine there's a super highway of traffic of information going up to the brain and four times less going from the brain to the body. And so by learning how to pull on the levers of our physiology, we can rapidly change our state. And then from there, by changing our state, that impacts the thoughts and feelings that we have. So instead of trying to change the story or trying to fix something or trying to solve something, which is what most people do by default, myself included in the past, if you change your state first, then there's a cascading effect which changes your thoughts and your feelings.

**中文翻译:**
我发现“自上而下”（top down）和“自下而上”（bottom up）的区别非常有帮助。大多数人尝试冷静下来时，会使用战术性的认知重构，或者正念，或者尝试以积极的角度重新审视情况。人们会使用很多不同的练习，这些确实有一定效果。但在我的经验中，通过生理机能工作，使用所谓的“自下而上”的方法——主要是利用呼吸，尽管也有其他方法——是一种能更迅速、更有效地转变状态的方式。
(00:08:11):
为了提供一些背景和科学依据：我们体内有被称为“传入神经元”（afferent neurons）和“传出神经元”（efferent neurons）的神经，它们在身体中上下传递信号。从身体传向大脑的传入神经元数量是从大脑传向身体的传出神经元的四倍。所以你可以想象，有一条通往大脑的信息流量超级高速公路，而从大脑传回身体的信息流量只有其四分之一。因此，通过学习如何拨动生理机能的杠杆，我们可以迅速改变自己的状态。状态改变后，就会影响我们的想法和感受。所以，与其像大多数人（包括过去的我自己）默认做的那样，试图改变“故事”、试图修复或解决某些问题，如果你先改变状态，就会产生连锁反应，从而改变你的想法和感受。

---

### [00:09:06] [Lenny]

**English:**
Okay, amazing. Yeah, and just to share how I felt when I was reading this and try to understand this approach is whenever I get nervous, there's always this like, oh, my body's starting to feel anxious. And then I think of a reason. Oftentimes, I don't know why it gets nervous, why my body's starting to create this feeling of anxiety. And then I often realize I'm just now trying to just explain why it happened, "Oh, I have this big meeting coming up, or I have this podcast episode I'm nervous about, or I'm not going to make a deadline for my newsletter." I often experience this where it's just like, "Oh, something feels nervous." And then, "Okay, here's the explanation." So maybe just along those lines, what else is there that might be helpful for people to think about in this context?

**中文翻译:**
太棒了。是的，分享一下我读到这些内容并尝试理解这种方法时的感受：每当我紧张时，总会有一种“哦，我的身体开始感到焦虑了”的感觉。然后我会想出一个原因。通常情况下，我并不知道为什么会紧张，为什么身体开始产生这种焦虑感。然后我经常意识到，我现在只是在试图解释它为什么发生，“哦，因为我有一个重要的会议要开，或者我有一个让我紧张的播客录制，或者我赶不上时事通讯的截止日期了。”我经常经历这种过程：先是“哦，感觉有点紧张”，然后是“好吧，这是解释”。所以，沿着这个思路，在这个背景下还有什么对人们有帮助的思考方式吗？

---

### [00:09:47] [Jonny Miller]

**English:**
I mean, I think it's helpful to understand the process by which, by changing the way that we breathe, for example, it shifts our physiological state and changes our nervous system. So if you're listening to this, maybe you, Lenny, you can try this as well. If you start breathing into your upper chest and shallow fairly, fairly rapid, maybe even through the mouth, that will then there's a part of your brain called the insular cortex, which is basically constantly spying on the way that we're breathing and it will register that change, it will then send information to activate the endocrine system, which then creates shift in our blood chemistry. The sympathetic nervous system gets activated and that increase in adrenaline and cortisol starts to flood your body. Everyone's probably very familiar with that feeling. And then that will then have a cascading impact on the thoughts that you're having and the way that you feel. And so you just shared, we have a tendency to kind of confabulate or make up stories that match the state that we are in. And so that's kind of what happens when we're breathing in that way. And then you can also consciously change your breath to breathe in a different way, which has the reverse effects, which I can go into, but I'll pause there.

**中文翻译:**
我的意思是，理解这个过程很有帮助：例如，通过改变呼吸方式，它会转变我们的生理状态并改变我们的神经系统。如果你正在听这段音频，也许你，Lenny，也可以尝试一下。如果你开始用上胸部呼吸，而且呼吸浅且相当快，甚至可能用嘴呼吸，那么大脑中一个叫做“岛叶皮层”（insular cortex）的部分——它基本上一直在监视我们的呼吸方式——就会记录下这种变化。然后它会发送信息激活内分泌系统，从而改变我们的血液化学成分。交感神经系统被激活，肾上腺素和皮质醇的增加开始充斥你的身体。大家可能对这种感觉非常熟悉。接着，这会对你的想法和感受产生连锁反应。正如你刚才分享的，我们有一种倾向，会去“虚构”或编造一些与我们所处状态相匹配的故事。当我们以那种方式呼吸时，情况就是这样。然后，你也可以有意识地改变呼吸，以另一种方式呼吸，这会产生相反的效果，我可以深入讲解，但先停在这里。

---

### [00:11:05] [Lenny]

**English:**
Yeah. So I think one of the big actionable takeaways here is that instead of trying to convince yourself, "No, this talk is going to go great, I don't need to worry about how I'm going to look in this meeting." Basically instead of going top down, trying to calm your body through thought, your advice is calm your body first because then your mind will notice, "Hey, I'm actually not as nervous as I thought. Maybe things are going to be okay." Is that right?

**中文翻译:**
是的。所以我认为这里一个重大的可操作点是：与其试图说服自己“不，这次演讲会很顺利，我不需要担心我在会议上的表现”，与其采取“自上而下”的方式试图通过思想来平复身体，你的建议是先平复身体，因为这样你的大脑就会注意到，“嘿，我其实没我想象的那么紧张。也许事情会进展顺利。”对吗？

---

### [00:11:29] [Jonny Miller]

**English:**
Yeah, precisely. And I mean I've used this myself many times before presentations. I gave a TEDx talk a few years ago and I was like my entire body, I was just terrified. And I did in 15 minutes of this breathing practice before and walked on stage almost cool as a cucumber. It's very effective.

**中文翻译:**
是的，正是如此。我的意思是，我自己也在演讲前多次使用过这个方法。几年前我做过一次 TEDx 演讲，当时我整个人都吓坏了。我在上台前做了 15 分钟这种呼吸练习，走上台时几乎泰然自若。这非常有效。

---

### [00:11:47] [Lenny]

**English:**
Sounds too good to be true. But we're going to do some of these exercises for people. Before we get into, why is it that breath specifically so powerful? It feels like such a strange thing to work so well, just this idea of breathing in a different way. You talked a bit about this, I forget what you called it, that kind of watches how you're breathing. But I guess what else can you share about just why is breath so effective in changing our state?

**中文翻译:**
听起来好得令人难以置信。但我们要为听众做一些这样的练习。在我们开始之前，为什么呼吸会如此强大？仅仅是换一种呼吸方式就能起到这么好的效果，这感觉很奇妙。你刚才提到了一点，我忘了你叫它什么了，就是那个监视呼吸方式的东西。我想知道，关于为什么呼吸在改变状态方面如此有效，你还能分享些什么吗？

---

### [00:12:10] [Jonny Miller]

**English:**
Sure. Well, it's one of the few things which happens automatically, but we can also control it consciously. And so what scientists have discovered that when the exhale is twice as long as the inhale, it has a calming effect. And when the inhale is either more intense or twice as long as the exhale, it has an activating effect. So you can kind of think of this as an up or down lever on the nervous system.

**中文翻译:**
当然。呼吸是少数几件既能自动发生，我们又能有意识控制的事情之一。科学家们发现，当呼气的时间是吸气时间的两倍时，它具有镇静作用。而当吸气更剧烈或时间是呼气的两倍时，它具有激活作用。所以你可以把它看作是神经系统的一个“向上”或“向下”的杠杆。

---

### [00:12:36] [Lenny]

**English:**
You also have this really clever way of describing this system. You call it state over story, essentially focusing on the state of your body versus the story you're telling yourself. Is that the way to think about it? And can you just talk about that concept?

**中文翻译:**
你描述这个系统的方式也非常巧妙。你称之为“状态重于故事”（state over story），本质上是关注你的身体状态，而不是你告诉自己的故事。是这样理解吗？你能谈谈这个概念吗？

---

### [00:12:48] [Jonny Miller]

**English:**
Yeah, so it's basically a shorthand for what we've just been talking about, which is most people tend to approach the problem or try to solve things on the level of story. So there's multiple ways you can do that through the breath as we just talked about. You can also defocus your gaze and kind of relax your eyes, and that has a similar effect. It can expand your awareness and kind of bring your awareness to behind you and the sides of you and below you, or you can breathe in these ways which emphasize the exhale. And so when we breathe in a way with say the exhale twice as long as the inhale, that part of the brain, the insular cortex then sends signals to the parasympathetic nervous system, which then has the cascading effect on our endocrine system and calms us down. And what I usually find as well is that the kind of reactive thoughts and feelings that we have when we are in that kind of anxious loop, they can be self-reinforcing. And so if someone has a thought of like, "Oh no, I'm nervous before this important presentation." Then that exacerbates the breathing pattern and then the whole thing just goes into this spiral, which can end up in full-blown panic attacks if there's not an intervention of some sorts.

**中文翻译:**
是的，这基本上就是我们刚才讨论内容的简写，即大多数人倾向于在“故事”层面去处理问题或尝试解决事情。正如我们刚才谈到的，通过呼吸有多种方法可以做到这一点。你也可以让目光失去焦点，放松眼睛，这也有类似的效果。它可以扩展你的觉察，把你的觉察带到你的身后、侧面和下方。或者你可以用强调呼气的方式呼吸。当我们以呼气时间两倍于吸气时间的方式呼吸时，大脑中的岛叶皮层会向副交感神经系统发送信号，进而对我们的内分泌系统产生连锁反应，让我们冷静下来。我通常还发现，当我们处于那种焦虑循环中时，我们产生的反应性想法和感受会自我强化。如果有人产生“噢不，在这次重要演讲前我很紧张”的想法，这会加剧呼吸模式的紊乱，然后整件事就会陷入这种螺旋，如果没有某种干预，最终可能会导致全面的恐慌发作。

---

### [00:13:57] [Lenny]

**English:**
Yeah, that's what I find with my nerves. I hate talking on stage. I get nervous before every podcast. This is not my natural state.

**中文翻译:**
是的，我的紧张感就是这样的。我讨厌在台上讲话。每次录播客前我都会紧张。这并不是我的自然状态。

---

### [00:14:04] [Jonny Miller]

**English:**
Interesting.

**中文翻译:**
有意思。

---

### [00:14:05] [Lenny]

**English:**
Yeah, and I hide it well.

**中文翻译:**
是的，而且我掩饰得很好。

---

### [00:14:07] [Jonny Miller]

**English:**
Is that still the case with podcast today?

**中文翻译:**
今天的播客也是这样吗？

---

### [00:14:09] [Lenny]

**English:**
Absolutely. And it's like different levels of nervousness, but it's always just like, "Oh, there we go." I'm not a performer person. Even I kind of push myself to do this podcast as a way to get better at this, to be honest. So it's still a thing that I think about. And what I find is the nervousness comes from exactly what you described is the nervousness of being nervous. I don't know, there's no reason specifically to be anxious, but I don't know how I'll be once I do the thing. So it's nervous of what it might look like or end up being like. So that's exactly what I ran into.

**中文翻译:**
绝对是。虽然紧张程度不同，但总会感觉“噢，又来了”。我不是那种表演型的人。老实说，我甚至有点强迫自己做这个播客，以此作为让自己变得更擅长这件事的一种方式。所以这仍然是我会考虑的事情。我发现紧张感正源于你所描述的——“对紧张本身的紧张”。我不知道，并没有什么具体的理由要焦虑，但我不知道一旦我开始做这件事，我会表现得怎么样。所以是对“它看起来会是什么样”或“最终会变成什么样”感到紧张。这正是我遇到的情况。

---

### [00:14:41] [Jonny Miller]

**English:**
Yeah. And there's obviously people say mindfulness, meditation, things like that, that can increase the psychological space between stimulus and response. And that is something that obviously does help over the long term, but it's in my opinion, nowhere near as rapid and effective and efficient as just changing the way that you're breathing.

**中文翻译:**
是的。显然人们会提到正念、冥想之类的东西，它们可以增加刺激与反应之间的心理空间。从长远来看，这显然是有帮助的，但在我看来，它的速度、效果和效率远不如直接改变呼吸方式。

---

### [00:15:00] [Lenny]

**English:**
Awesome. So let's get into it. I know you have a couple exercises specifically for this, and then we'll go from there.

**中文翻译:**
太棒了。那我们开始吧。我知道你有几个专门针对这个的练习，然后我们再继续。

---

### [00:15:06] [Jonny Miller]

**English:**
We can stack a few of the exercises and I'll try and keep it to a minute or so. So yeah, if you want to get comfy in your chair and sit up straight, feel your butt on the seat, and I find it helpful to kind of be aware of the space behind you and above you as well, kind of expanding your awareness so that you are aware of the space behind to the sides and above.

**中文翻译:**
我们可以把几个练习叠加在一起，我尽量控制在一分钟左右。所以，如果你想在椅子上坐得舒服点，坐直，感受你的臀部接触座位，我发现意识到你身后和上方的空间也很有帮助，就像扩展你的觉察，让你意识到身后、两侧和上方的空间。

---

### [00:15:29] [Lenny]

**English:**
And should we close your eyes?

**中文翻译:**
我们需要闭上眼睛吗？

---

### [00:15:31] [Jonny Miller]

**English:**
Yeah, and close your eyes down. If you're listening and driving, obviously don't do that. But yeah, closing the eyes down for sure helps. And now we're just going to do simple breath. We're going to inhale in through the nose for four. We're going to hold the breath at the top for four, and we're going to exhale for eight, and then we're going to repeat. So let the breath go and inhaling through the nose. Inhale, 2, 3, 4, hold the breath, 2, 3, 4. And exhale, 8, 2, 3, 4, 5, 6, 7, 8. Inhale, 2, 3, 4, hold the breath, 2, 3, 4, and exhale, 2, 3, 4, 5, 6, 7, 8. And now you can let go of the breath completely and we'll end with one round of humming, which is surprisingly effect of it calming as well. So take a full breath in and humming through the nose all the way to the end of exhale. Let out a sigh if that feels good and open up your eyes.

**中文翻译:**
是的，闭上眼睛。如果你正在边开车边听，显然不要这样做。但是，闭上眼睛确实有帮助。现在我们要进行简单的呼吸。我们要用鼻子吸气，数 4 下。在吸气末端屏住呼吸，数 4 下。然后呼气，数 8 下，接着重复。现在，呼出所有的气，开始用鼻子吸气。吸气，2，3，4。屏息，2，3，4。呼气，8，2，3，4，5，6，7，8。吸气，2，3，4。屏息，2，3，4。呼气，2，3，4，5，6，7，8。现在你可以完全放松呼吸，我们将以一轮哼鸣（humming）结束，这在镇静方面效果惊人。深吸一口气，用鼻子哼鸣，直到呼气结束。如果感觉不错，叹一口气，然后睁开眼睛。

---

### [00:17:01] [Lenny]

**English:**
I feel extremely calm. I should do this every podcast episode before we start.

**中文翻译:**
我感到非常平静。我应该在每集播客开始前都做这个。

---

### [00:17:08] [Jonny Miller]

**English:**
A note on the humming. It also releases nitric oxide, which is a vasodilator, and that helps to create that kind of calming effect and it also reduces eye tension as well. So I'll do it if I've been looking to screen for too long. It's really good for kind of reducing eye fatigue as well.

**中文翻译:**
关于哼鸣的一点说明：它还会释放一氧化氮，这是一种血管扩张剂，有助于产生那种镇静效果，还能减轻眼睛的紧张感。所以如果我盯着屏幕太久，我就会做这个。它对缓解眼睛疲劳也非常有效。

---

### [00:17:24] [Lenny]

**English:**
And there's also a vagus nerve component to it because your body's vibrating, is that true?

**中文翻译:**
而且因为它会让身体产生振动，所以也有迷走神经（vagus nerve）的参与，对吗？

---

### [00:17:28] [Jonny Miller]

**English:**
Yeah, precisely. So it kind of tones or stimulates the vagus nerve, which stimulates the parasympathetic nervous system.

**中文翻译:**
是的，正是如此。它在某种程度上调节或刺激了迷走神经，进而刺激了副交感神经系统。

---

### [00:17:35] [Lenny]

**English:**
What's your advice for doing this? Is this before you go into a big meeting or a presentation? How do you apply this?

**中文翻译:**
你对做这个练习有什么建议？是在参加大型会议或演讲之前吗？你如何应用它？

---

### [00:17:42] [Jonny Miller]

**English:**
I kind of like to share building a toolkit of different practices that are appropriate for different contexts. So something like the 4, 4, 8 breathing, you could do pretty much anywhere without anyone necessarily noticing. Humming is slightly more obvious, but if you're about to jump on a zoom or something, you can totally do it with your eyes closed. Things like expanding your awareness or bringing your awareness down to your feet and your hands, which creates a kind of grounding calming effect that also you can do if you're in a busy room. Maybe you have social anxiety, even orienting and labeling things that you are hearing and feeling, kind of bringing the awareness and attention back into the body that also has an effect. And then there's longer practices for say, non-sleep deep rests, belly breathing, things that you can do if you have 10, 20 minutes and you're at home and you want a downshift.
(00:18:30):
So I like to kind of give people a big toolkit to see what works for them and then cherry-pick which ones are suitable to different situations. And another way that I think about this is, I call it, if this, then breathe. So it's like if I feel overwhelmed, then I do the humming. If I feel anxious, then I do 4, 4, 8 breathing or alternate nostril breathing and kind of having my own little recipe set that I have for different context is really helpful and I work with people to kind of build those toolkits themselves.

**中文翻译:**
我喜欢分享如何建立一个针对不同情境的练习工具箱。比如 4-4-8 呼吸法，你几乎可以在任何地方做，而不会被别人注意到。哼鸣稍微明显一点，但如果你正准备参加 Zoom 会议之类的，你完全可以闭着眼睛做。像扩展觉察，或者把觉察带到你的脚和手，这会产生一种“接地”（grounding）的镇静效果，即使你在一个忙碌的房间里也可以做。如果你有社交焦虑，甚至可以尝试定位并标记你听到的和感觉到的事物，将觉察和注意力带回身体，这也会起作用。还有更长时间的练习，比如非睡眠深度休息（NSDR）、腹式呼吸，如果你在家有 10 到 20 分钟时间，想要“降档”（downshift）放松，就可以做这些。
(00:18:30):
所以我喜欢给人们一个大工具箱，让他们看看哪些对他们有效，然后挑选适合不同情况的练习。我思考这个问题的另一种方式是，我称之为“如果发生这种情况，就这样呼吸”。就像是：如果我感到不知所措，我就哼鸣；如果我感到焦虑，我就做 4-4-8 呼吸或交替鼻孔呼吸。针对不同情境拥有自己的一套小秘方非常有帮助，我也会协助人们建立他们自己的工具箱。

---

### [00:19:03] [Lenny]

**English:**
This sounds like it needs to be a website where people can go with these lists of if this, then that is there a place that we could send people in the show notes and if not, you should make one before we go live.

**中文翻译:**
这听起来需要建立一个网站，让人们可以查看这些“如果……就……”的清单。有没有什么地方我们可以放在节目介绍（show notes）里推荐给听众？如果没有，你应该在节目上线前做一个。

---

### [00:19:13] [Jonny Miller]

**English:**
There is not currently. It's part of the curriculum in the course that I have, but-

**中文翻译:**
目前还没有。这是我课程体系的一部分，但是——

---

### [00:19:17] [Lenny]

**English:**
Okay, great.

**中文翻译:**
好的，太棒了。

---

### [00:19:18] [Jonny Miller]

**English:**
... I can maybe see if I can spin one up as well, but yeah.

**中文翻译:**
……我也许可以看看能不能快速搭建一个，嗯。

---

### [00:19:21] [Lenny]

**English:**
Okay, cool. We'll link to the course if nothing else. Amazing.

**中文翻译:**
好的，酷。如果没有别的，我们就链接到课程。太棒了。

---

### [00:19:23] [Jonny Miller]

**English:**
Okay.

**中文翻译:**
好的。

---

### [00:19:24] [Lenny]

**English:**
Along this line of calming breath exercise, Huberman also has a different version, which I've tried and I'm going to do both now. You breathe in fully and then you breathe in a little bit more. I imagine you've seen that piece of advice?

**中文翻译:**
关于这种镇静呼吸练习，Huberman 也有一个不同的版本，我尝试过，现在我打算两个都做。就是先吸满气，然后再额外吸一点点。我想你应该见过那个建议？

---

### [00:19:37] [Jonny Miller]

**English:**
That's also fantastic. He calls it the physiological sigh, and it's both very effective, especially if you just have five seconds and you just take a full sigh, it's great. I'd also add that the sigh happens naturally as a result of doing these downshifting practices. So if you notice after you do let's say the 4, 4, 8 breathing, at the end, you might naturally just want to let out a sigh, and that's a signal that your body is naturally downshifting. Or if you are with a friend and you feel just comfortable and relaxed, then your body might sigh. And it's something that we do a lot and as you say, you can consciously do it and that will help as well. That's another one of the practices.

**中文翻译:**
那也非常棒。他称之为“生理性叹息”（physiological sigh），它非常有效，特别是如果你只有五秒钟时间，深叹一口气，效果很好。我还想补充一点，叹息通常是做这些“降档”练习后的自然结果。所以如果你注意到在做完比如 4-4-8 呼吸后，最后你可能自然而然地想叹一口气，那是你的身体正在自然降档的信号。或者如果你和朋友在一起，感到很舒服、很放松，你的身体也可能会叹气。这是我们经常做的事情，正如你所说，你可以有意识地去做，这也会有帮助。那是另一种练习。

---

### [00:20:18] [Lenny]

**English:**
Awesome. So link to that. And I think throughout this episode, as you said, we're going to give people a bunch of tools that they can use, and it feels like some are in the moment, "I need to feel calmer right now. Here's a thing you could do." And then there's things you can do ongoing that build... I guess another way to think about it's just make your body more calm as a baseline of practice to work on there.

**中文翻译:**
太棒了。我们会链接到那个。我想在这一集中，正如你所说，我们会给人们提供一堆可以使用的工具，感觉有些是针对当下的，“我现在需要感觉更冷静，这是你可以做的一件事”。还有一些是可以持续做的，用来建立……我想另一种思考方式是，通过练习让你的身体基准状态变得更冷静。

---

### [00:20:38] [Jonny Miller]

**English:**
Yeah, precisely.

**中文翻译:**
是的，正是如此。

---

### [00:20:39] [Lenny]

**English:**
Awesome, okay. I think the other breathing exercise we're going to do is the opposite. Gets you all excited, is that right?

**中文翻译:**
太棒了，好的。我想我们要做的另一个呼吸练习是相反的。是让你兴奋起来的，对吗？

---

### [00:21:45] [Jonny Miller]

**English:**
Yeah, sure. We can do that as well. I call this espresso breath. So this is the opposite. This is very activating. I would only recommend this if you're feeling lethargic or maybe instead of drinking a coffee in the afternoon, you could do this for a minute or so. In the scientific literature, it's bellows breath or breath of fire, and it basically looks like a series of rapid exhales through the nose. I like to keep it through the nose only if you do it through the mouth, it can be very too activating and it can kind of overwhelm people. Obviously, there's the Wim Hof practice that I'm sure many people are familiar with. So this is a more gentle version of... If Wim Hof is like Red Bull, this is kind of like a small coffee.

**中文翻译:**
是的，当然。我们也可以做那个。我称之为“浓缩咖啡呼吸”（espresso breath）。这是相反的，它非常有激活作用。我只建议在你感到无精打采时做，或者下午不想喝咖啡时，可以做一分钟左右。在科学文献中，它被称为“风箱式呼吸”或“火之呼吸”，基本上就是通过鼻子进行一系列快速呼气。我喜欢只通过鼻子进行，因为如果通过嘴进行，可能会激活过度，让人受不了。显然，还有很多人熟悉的 Wim Hof 练习。这是一个更温和的版本……如果 Wim Hof 像是红牛，这个就像是一小杯咖啡。

---

### [00:21:30] [Lenny]

**English:**
I like that. And you call it the espresso breath, espresso breath.

**中文翻译:**
我喜欢这个。你叫它浓缩咖啡呼吸。

---

### [00:21:33] [Jonny Miller]

**English:**
Espresso breath, yeah.

**中文翻译:**
浓缩咖啡呼吸，是的。

---

### [00:21:33] [Lenny]

**English:**
So yeah, that's a good metaphor there.

**中文翻译:**
是的，那是个很好的比喻。

---

### [00:21:35] [Jonny Miller]

**English:**
Yeah, yeah. So yeah, let's do it. So again, kind of sit up straight, and this time you want to be pumping the breath from your lower belly and you pump the breath on the exhale. So I'll demonstrate it briefly. It's like breathe in.
(00:21:56):
Okay. So yeah, take a full breath in and begin.
(00:21:58):
And let go. And full breath in. And sigh on the exhale. I already feel a little bit tingly.

**中文翻译:**
是的。那我们开始吧。再次坐直，这次你要从小腹部泵出气息，并在呼气时发力。我简单演示一下。就像吸气，然后（快速呼气声）。
(00:21:56):
好的。深吸一口气，开始。
(00:21:58):
（快速呼吸练习中）
好了，放松。深吸一口气，呼气时叹气。我已经感觉到一点酥麻感了。

---

### [00:22:25] [Lenny]

**English:**
I'm energized. Let's do this. Go, go, go, go. That was great. Okay, look at that. We're back to where we started with the full circle of energy. That was great.

**中文翻译:**
我充满活力了。开始干吧！冲，冲，冲！太棒了。瞧，我们又回到了能量满满的状态。太棒了。

---

### [00:22:34] [Jonny Miller]

**English:**
Up and down.

**中文翻译:**
起起伏伏。

---

### [00:22:35] [Lenny]

**English:**
And then how long do you recommend doing that one for?

**中文翻译:**
那你建议这个练习做多久？

---

### [00:22:38] [Jonny Miller]

**English:**
So it kind of depends on how activating you find it, but I usually find 30 breaths per round and then take a breath, have a long pause on the exhale, and then if you want to do another round or two.

**中文翻译:**
这取决于你觉得它的激活程度如何，但我通常建议每轮 30 次呼吸，然后吸气，在呼气末端长久停顿，如果你愿意，可以再做一两轮。

---

### [00:22:50] [Lenny]

**English:**
Amazing. And the cases where this might be helpful is maybe you're about to give a big talk, I guess in a talk you both want energy and want calm, so that's kind of complicated.

**中文翻译:**
太棒了。这种方法可能派上用场的情况是，也许你正准备做一个大型演讲。我想在演讲中你既需要能量又需要冷静，所以这有点复杂。

---

### [00:22:59] [Jonny Miller]

**English:**
Especially if you are meetings early in the morning and you haven't quite got going yet, you can do the espresso breath to begin with and that activates you. And then do some of the downshifting practices to kind of ground and stabilize that aliveness.

**中文翻译:**
特别是如果你一大早就有会议，还没进入状态，你可以先做浓缩咖啡呼吸来激活自己。然后再做一些“降档”练习，来稳固和稳定那种活力。

---

### [00:23:12] [Lenny]

**English:**
Are there any other tactical breathing exercises that are worth doing real quick? I know we'll get into some longer practices and deeper stuff, but is there anything else that would be helpful here?

**中文翻译:**
还有其他值得快速尝试的战术性呼吸练习吗？我知道我们会进入一些更长、更深的内容，但这里还有什么有帮助的吗？

---

### [00:23:21] [Jonny Miller]

**English:**
No, I think we've covered the bases. I don't want to overwhelm people too much.

**中文翻译:**
不，我想我们已经涵盖了基本要点。我不想让大家感到负担太重。

---

### [00:23:25] [Lenny]

**English:**
Just as a takeaway, there's these two techniques. One to help you get more calm when you need to be calm in the moment. The other is to get energy. And then I guess are these things that you recommend doing ongoing to build this muscle in your body or are these mostly for you need this now in the moment and it's not worth just doing a few times a day even when you're fine?

**中文翻译:**
总结一下，有两种技术。一种是当你当下需要冷静时帮助你变得更冷静。另一种是获取能量。我想问，你是建议持续做这些练习来锻炼身体的这种“肌肉”，还是说这些主要用于当下的急需，即使在状态良好时每天做几次也不值得？

---

### [00:23:47] [Jonny Miller]

**English:**
Yeah, great question. So I like to recommend both a morning practice, particularly to build the muscle of just doing it and getting used to it. So maybe five minutes in the morning before you start work, before breakfast, something like that. And then you are more likely to remember that you have access to that in the moment because usually the challenge is that when someone is in that flustered state, remembering to do the practice is often the last thing that comes to mind. So by having a deliberate practice for at least 7 to 10 days and so that you get the hang of it, then it feels much more natural to do it when you're feeling. That's kind of like playing the game on hard mode when you are really stressed and anxious, that's when you need it the most, but it's also when you're least likely to remember to do it.

**中文翻译:**
是的，好问题。我喜欢同时推荐晨间练习，特别是为了建立“去做并习惯它”的肌肉记忆。比如早上开始工作前、吃早餐前花五分钟做一下。这样你更有可能在关键时刻想起你可以使用这个工具。因为通常的挑战是，当一个人处于慌乱状态时，想起去做练习往往是最后才想到的事。所以通过至少 7 到 10 天的刻意练习，让你掌握要领，那么当你感到压力时，做这个练习就会感觉自然得多。当你真正感到压力和焦虑时，就像是在玩“困难模式”的游戏，那是你最需要它的时候，但也是你最不可能想起去做它的时候。

---

### [00:24:36] [Lenny]

**English:**
Awesome. So the first exercise to calm you down is essentially breathe in four seconds, hold it for four seconds, breathe out slowly for eight seconds and do that for about 30 seconds, is that right? Or for a minute?

**中文翻译:**
太棒了。所以第一个让你冷静下来的练习本质上是：吸气 4 秒，屏息 4 秒，缓慢呼气 8 秒，持续大约 30 秒，对吗？还是做一分钟？

---

### [00:24:48] [Jonny Miller]

**English:**
Yeah, I'd say for at least a minute or two. We kind of did a shorter version. I'll also add that the important thing is that the exhale is twice as long as the inhale. So if exhaling for eight is too long, you could do 3, 3, 6 or even 2, 2, 4 or even 5, 5, 10 depending on your lung capacity essentially and your CO2 tolerance.

**中文翻译:**
是的，我会说至少做一两分钟。我们刚才做的是简短版。我还想补充一点，关键在于呼气的时间是吸气时间的两倍。所以如果呼气 8 秒太长，你可以做 3-3-6，甚至 2-2-4，或者 5-5-10，这本质上取决于你的肺活量和二氧化碳耐受度。

---

### [00:25:08] [Lenny]

**English:**
Okay, good to know. And then the espresso breath, when you need energy or you just kind of pump air out of your belly through your nose and you do that for how long would you recommend?

**中文翻译:**
好的，了解了。然后是浓缩咖啡呼吸，当你需要能量时，你通过鼻子从小腹泵出空气，你建议做多久？

---

### [00:25:18] [Jonny Miller]

**English:**
Two to three rounds of 30 pumps, yeah.

**中文翻译:**
做两到三轮，每轮 30 次泵气。

---

### [00:25:22] [Lenny]

**English:**
And again, the reason this is effective and powerful is coming back to your original big insight that our state is driven by what our body is doing and our mind often explains what we're feeling based on what our body's doing. So that if you can change the state of your body and become less nervous in your body, your mind will be like, "All right, everything's fine."

**中文翻译:**
再次强调，这之所以有效且强大，是因为回到了你最初的重大见解：我们的状态是由身体的行为驱动的，而我们的大脑通常根据身体的行为来解释我们的感受。因此，如果你能改变身体的状态，让身体不那么紧张，你的大脑就会觉得：“好吧，一切都很好。”

---

### [00:25:45] [Jonny Miller]

**English:**
Yeah. And maybe something that we haven't touched on yet, but I think is important to add in is this idea of interoception or somatic awareness. And the reason I bring it in is because if you do this practice but you're not really aware of your body and how you feel, then it'll be less compelling to you. But if you're kind of tuned into like sensations in your body, what's going on, you're more likely to notice the difference in the shifts.

**中文翻译:**
是的。也许还有一点我们还没触及，但我认为很重要，那就是“内感官”（interoception）或“躯体觉察”（somatic awareness）的概念。我之所以提到它，是因为如果你做这些练习，但你并没有真正意识到你的身体和你的感受，那么它对你的吸引力就会降低。但如果你能感知到身体的感觉，感知到正在发生的事情，你就更有可能注意到状态转变带来的差异。

---

### [00:26:09] [Lenny]

**English:**
Great. So let's get into that. That was something I definitely wanted to touch on here. This awesome acronym to help you with this process of interoception. So talk about what that is and then how to actually go about becoming better at being aware of what your body's doing.

**中文翻译:**
太好了。那我们就聊聊这个。这正是我非常想探讨的内容。这个很棒的缩写词可以帮助你进行内感官的过程。谈谈那是什么，以及如何真正变得更擅长察觉身体的行为。

---

### [00:26:22] [Jonny Miller]

**English:**
Yeah. So it's this idea of interoception, which is known as our sixth sense, and basically it's our ability to sense, track and feel our internal landscape. And I like to use the metaphor of a chef in the same way that you train your flavor palette for kind of sweet, spicy, umami, things like that. You can also train your interoceptive palette and become more aware of the internal sensations, whether that's your breath, whether it's tension, whether it's moods and emotions, whether it's the quality of your awareness, the quality of your thoughts. And the more kind of in tune with that you are, the more likely you are to notice the kind of early warning signs of something like anxiety. Because usually, certainly a panic attack doesn't come out of nowhere. There will be a kind of cascade of subtle things that happen in your body that eventually result in anxiety. And so if you can catch those things early and kind of nip them in the bud and do one of these practices, then you can avoid the kind of 10 out of 10 worst case scenarios.

**中文翻译:**
是的。这就是“内感官”的概念，它被称为我们的第六感，基本上就是我们感知、追踪和感受内在景观的能力。我喜欢用厨师来打比方，就像你训练自己的味觉来分辨甜、辣、鲜等味道一样，你也可以训练你的内感官“调色盘”，变得更敏锐地察觉内在感觉，无论是呼吸、张力、心境和情绪，还是觉察的质量、思想的质量。你越是与之同步，就越有可能注意到焦虑之类的早期预警信号。因为通常情况下，恐慌发作绝不是凭空发生的。身体里会发生一系列微妙的事情，最终导致焦虑。所以，如果你能及早发现这些迹象，将其扼杀在萌芽状态，并进行这些练习之一，你就可以避免那种“10分满分”的最坏情况。

---

### [00:27:25] [Lenny]

**English:**
Okay, awesome. So I know that there's also specific things you recommend people pay attention to, to understand what their body is doing in this process of inter...

**中文翻译:**
好的，太棒了。我知道你还建议人们关注一些具体的事情，以便在这个过程中理解身体的行为……

---

### [00:27:33] [Jonny Miller]

**English:**
Interoception, yeah,

**中文翻译:**
内感官，是的。

---

### [00:27:34] [Lenny]

**English:**
Interra... Okay. What is it?

**中文翻译:**
内感……好吧，怎么读？

---

### [00:27:36] [Jonny Miller]

**English:**
Interoception.

**中文翻译:**
Interoception（内感官）。

---

### [00:27:39] [Lenny]

**English:**
Interoception.

**中文翻译:**
Interoception。

---

### [00:27:39] [Jonny Miller]

**English:**
As opposed to exteroception, which is awareness of all the external stimuli.

**中文翻译:**
与之相对的是“外感官”（exteroception），即对所有外部刺激的觉察。

---

### [00:27:44] [Lenny]

**English:**
Got it. I guess before we even get to that, so you mentioned that it's another sense we have, and I think that's a really important point that I think maybe people didn't catch. So we have these five senses, obviously taste and smell and vision and touch. But you're finding and research showed basically this is another sense people don't really know we have.

**中文翻译:**
明白了。我想在我们深入之前，你提到这是我们的另一种感官，我认为这是一个非常重要的点，可能人们没注意到。我们有五种感官，显然是味觉、嗅觉、视觉、听觉和触觉。但你的发现和研究表明，这基本上是人们并不知道我们拥有的另一种感官。

---

### [00:28:02] [Jonny Miller]

**English:**
Yeah, exactly. And it has been studies quite a lot, especially in the last decade or so. And there's a number of interesting findings from the research that I found. One being that ADHD tends to correlate with low levels of interoception, as does if people have PTSD or trauma. Again, interoception is lowered. And I'd certainly say for myself, for the first 25 years of my life, I was fairly numb from the neck down. I was not very aware to what was happening in my body in real time. I was also reading a book recently called The Hour Between Dog and Wolf, which looked at Wall Street traders and they correlated higher degrees of interception with basically making more money and making better decisions. And I think the thesis was that by tuning into what their body was doing in certain moments, they could pick up on things more intuitive decision making essentially.

**中文翻译:**
是的，没错。特别是在过去十年左右，这方面的研究非常多。我发现研究中有一些有趣的发现。其一是多动症（ADHD）往往与低水平的内感官相关，患有创伤后应激障碍（PTSD）或创伤的人也是如此，他们的内感官能力也会降低。我肯定会说我自己，在我生命的前 25 年里，我颈部以下相当麻木。我不太能实时察觉身体里发生了什么。我最近还在读一本叫《犬狼之间》（The Hour Between Dog and Wolf）的书，书中研究了华尔街交易员，发现更高程度的内感官与赚更多的钱和做出更好的决策相关。我想其论点是，通过感知身体在某些时刻的行为，他们能捕捉到更多信息，本质上是更直觉化的决策。

---

### [00:28:55] [Lenny]

**English:**
So I think there's a specific list of things that you recommend people pay attention to, their posture, their breath, things like that. What is that list and then how do we actually do this better?

**中文翻译:**
所以我认为你有一份建议人们关注的具体清单，比如姿势、呼吸之类的。那份清单是什么？我们如何才能做得更好？

---

### [00:29:06] [Jonny Miller]

**English:**
Yeah. So I simplify this to APE, which basically is an acronym which stands for awareness, posture, and emotion. So to kind of go through each one by one. Awareness is, to give an example, I could narrow my awareness and become really focused and just you kind of tense up and it also is quite activating sometimes or you can relax and expand your awareness and be aware of the space above me, the space behind me, the space below me. And that is generally a calming thing. Posture is fairly self-explanatory. But again, our posture affects how we feel. You're shifting there now. And then emotion, which I include somatic or body-based sensations which arise. So both kind of what is the overall mood and the flavor or the texture that I'm feeling. Like right now, maybe it's excitement, maybe there's some joy. I'm noticing there's some heat in my belly probably from the breathing. Yeah, there's a little bit of tightness in my lower back from working out yesterday. So just sense kind of mapping that landscape of sensation. And for most people it's almost like it's like a [inaudible 00:30:22]. You have those maps of [inaudible 00:30:25] and for a lot of people there's just these big kind blind spots in their body.

**中文翻译:**
是的。我将其简化为 APE，这基本上是一个缩写词，代表觉察（Awareness）、姿势（Posture）和情绪（Emotion）。我来逐一解释。觉察，举个例子，我可以缩小觉察范围，变得非常专注，你会感到紧绷，有时这很有激活作用；或者你可以放松并扩展觉察，意识到我上方的空间、身后的空间、下方的空间。这通常是让人冷静的事情。姿势不言自明。但同样，我们的姿势会影响我们的感受。你现在就在调整姿势。然后是情绪，我将其包含在产生的躯体或基于身体的感觉中。包括整体心境以及我感受到的“风味”或“质感”。比如现在，也许是兴奋，也许有些喜悦。我注意到肚子里有些热，可能是因为刚才的呼吸。是的，因为昨天锻炼，我的下背部有一点紧。所以就是去感知，去描绘那种感觉的景观。对大多数人来说，这就像是一张地图，很多人在身体感知上存在巨大的盲点。

---

### [00:30:30] [Lenny]

**English:**
And the advice here is, so there's this acronym APE and the advice is think about these three things when you're feeling something that you may not, basically something's going on slash just often come back to this. I imagine just whenever you can think of, "Oh, APE: awareness, posture, emotion." Is that how to use this?

**中文翻译:**
这里的建议是，有了 APE 这个缩写词，建议是在你感觉到一些异样时，或者基本上是有事情发生时，或者只是经常回到这个状态。我想就是每当你能想到的时候，就默念“噢，APE：觉察、姿势、情绪”。是这样使用的吗？

---

### [00:30:51] [Jonny Miller]

**English:**
Yeah, exactly. So again, it can be something that you do before you start your day, maybe with a cup of tea. I like to drink tea and just do a body scan essentially and just check each of those three areas. And it's really valuable, particularly if you are having racing thoughts or something doesn't feel quite right. Instead of just tackling the problem on the level of the mind dropping down into the body and bringing that into the picture as well, I find to be really helpful.

**中文翻译:**
是的，没错。同样，这可以是你在开始一天工作前做的事情，比如喝茶的时候。我喜欢喝着茶，基本上做一个全身扫描，检查这三个领域。这非常有价值，特别是当你思绪飞速转动或感觉有些不对劲时。与其只在思想层面解决问题，不如深入到身体中，将其也纳入考量，我发现这非常有帮助。

---

### [00:31:26] [Lenny]

**English:**
Basically, as often as you can. And generally when things are feeling all off, just remember APE, where's my awareness? How's my posture? And then what am I feeling? Am I feeling sad? Am I feeling happy, excited, angry? Things like that. I think you also talk about breath, like you have a list you wrote about this of other things that you might want to pay attention to. Actually finding paying attention to what my breath is doing is really powerful too. So I'm going to try a BAPE version of this or I'm going to try to think about where's my breath coming from, what am I feeling there?

**中文翻译:**
基本上是尽可能频繁地做。通常当感觉一切都不对劲时，就记住 APE：我的觉察在哪里？我的姿势如何？我现在的感受是什么？我是感到悲伤、快乐、兴奋还是愤怒？诸如此类。我想你也谈到了呼吸，你写过一份关于其他可能需要关注的事情的清单。实际上，我发现关注呼吸的行为也非常强大。所以我打算尝试一个“BAPE”版本，或者我会试着思考我的呼吸是从哪里发出的，我在那里感受到了什么？

---

### [00:32:02] [Jonny Miller]

**English:**
Yeah. So the breath and sensations are two other ones that are really helpful. The breath in particular, often people will... There's an idea of email apnea when people are checking their emails, they will, without noticing it, start to hold their breath, which is generally a very activating thing to do. Or as I mentioned earlier, if your breath is through the mouth and shallow and into the upper chest, that will also be very activating versus is your breath through the nose? Is it kind of into the belly and into the sides of the rib cage and does it feel easeful? Basically, breathing without tension is ideal.

**中文翻译:**
是的。呼吸和感觉是另外两个非常有用的关注点。特别是呼吸，人们经常会……有一个概念叫“邮件呼吸暂停症”（email apnea），人们在查邮件时，会不自觉地开始屏住呼吸，这通常是一种非常具有激活作用（产生压力）的行为。或者正如我之前提到的，如果你的呼吸是通过嘴进行的、很浅且只进入上胸部，那也会非常有激活作用。反之，你的呼吸是通过鼻子吗？它是进入腹部和肋骨两侧吗？感觉轻松吗？基本上，没有张力的呼吸是最理想的。

---

### [00:32:39] [Lenny]

**English:**
What I think about using this practice is if I were sitting in a meeting and just not feeling amazingly confident, I just come back to this acronym, BAPE or APE, whichever one you want to choose, just like how am I feeling right now? Oh wow, my whole stomach is clenched. I'm maybe nervous about what might happen or I'm not breathing at all, or my posture is really bad. So I think in a meeting would be really helpful Here, maybe you're about to get on a zoom or an important call or something like that. Maybe a one-on-one. Is there anything else, any other moments that kind of triggers for people of like, "Oh, I should really be aware of what's happening right now. Let me do an APE exercise."

**中文翻译:**
我想到使用这个练习的场景是：如果我正坐在会议中，感觉不太自信，我就回到这个缩写词，BAPE 或 APE，随你选哪个，问问自己：我现在感觉如何？噢哇，我的整个胃部都紧缩着。我可能在为可能发生的事情感到紧张，或者我根本没在呼吸，或者我的姿势非常糟糕。所以我认为在会议中这会非常有帮助。或者当你准备参加 Zoom 会议、重要电话或一对一谈话时。还有什么其他的时刻可以作为人们的触发点，让他们想到“噢，我真的应该觉察一下现在发生了什么，让我做一个 APE 练习”？

---

### [00:33:16] [Jonny Miller]

**English:**
Yeah, well, just to kind of piggyback on what you just said, if you are about to jump on a meeting and you're noticing that your stomach is clenched, that's actually really useful data to be like, "Why is this happening?" Is it your intuition kind of saying that maybe you shouldn't do this deal with someone or maybe something is off and so it's a sign to explore that more. Or it could be that you've been triggered by something or something that someone said and you've only just realized it and then that's again, more information or something that you can reflect on or go into.

**中文翻译:**
是的，顺着你刚才说的，如果你正要参加会议，发现胃部紧缩，这实际上是非常有用的数据，让你思考“为什么会这样？”是你的直觉在告诉你也许不该和某人做这笔交易，或者某些事情不对劲，所以这是一个进一步探索的信号。或者可能是你被某些事情或某人说的话触发了，而你刚刚才意识到，这又是更多的信息，或者是你可以反思或深入探讨的东西。

---

### [00:33:51] [Lenny]

**English:**
Is there anything in your life recently that is an example of this where you're feeling unsure and maybe you realize, "Oh, here's what my body's doing, maybe I should pay more attention to this."

**中文翻译:**
你最近的生活中有什么例子吗？当你感到不确定，然后意识到“噢，这是我身体的反应，也许我应该多关注一下”。

---

### [00:34:03] [Jonny Miller]

**English:**
Actually, last week I did a podcast conversation, so I have a podcast myself, and I got off the call and I remember I felt or got off the podcast and I felt pretty exhausted and I felt like there was this kind of tension in my chest. And again, my breath was kind of all over the place and I realized that I had very much over committed myself for that week. I'd scheduled back to back podcast interviews. The podcast wasn't even the priority for what I'm focusing on in this quarter, so I then made the decision to just push back all my episodes until the summer basically.

**中文翻译:**
实际上，上周我录制了一期播客——我自己也有播客。录完之后，我记得我感到非常疲惫，胸口有一种紧绷感。而且，我的呼吸也变得很乱。我意识到那一周我给自己安排了太多的任务，连续安排了多场播客采访。而播客甚至不是我本季度关注的重点。于是我决定把所有的剧集都推迟到夏天。

---

### [00:34:42] [Lenny]

**English:**
I love that example. I know that feeling very well.

**中文翻译:**
我喜欢这个例子。我非常熟悉那种感觉。

---

### [00:34:46] [Jonny Miller]

**English:**
I'm sure.

**中文翻译:**
我确定。

---

### [00:34:48] [Lenny]

**English:**
When you wrote about this idea of interoception, you connected it to burnout, and I think you talked about how this is one of the best tools to avoid burnout. Is that right? Am I remembering that right? And if so, how do you think about this burnout and avoiding burnout in general, something a lot of people experience?

**中文翻译:**
当你写到内感官这个概念时，你把它和职业倦怠联系在了一起。我想你谈到了这是避免职业倦怠的最佳工具之一。对吗？我记错了吗？如果是这样，你如何看待职业倦怠以及普遍的预防方法？毕竟很多人都在经历这个。

---

### [00:35:08] [Jonny Miller]

**English:**
Yeah, so I have this idea that I call the feather brick dump truck phenomenon. And basically what that means is when we are showing early signs of burnout, our body will give us feedback usually in subtle ways in the beginning. So the feather might be waking up in the morning and feeling a little bit tired, maybe a little bit exhausted. The brick, maybe you ignore that or you don't notice it, and then three or four weeks later you have a fight with someone or an argument or you just feel frustrated and terrible and you lose your cool. And then maybe the dump truck is a month later or even a year later, there's a full-blown health crisis, or you develop type two diabetes or there's a whole range of things, or maybe you get fired. There's a bunch of different things that can happen, but normally depending on how attuned or depending on someone's interoceptive capacity, ideally, you want to notice when it's the feather and then make adjustments or shift then and not have to wait until you experience the full-blown pain of the dump truck, which unfortunately is what happens to a lot of people, especially when they experience burnout for the first time.

**中文翻译:**
是的，我有一个想法，我称之为“羽毛、砖头、自卸卡车”现象。基本上，它的意思是当我们出现职业倦怠的早期迹象时，我们的身体通常会在开始时以微妙的方式给我们反馈。“羽毛”可能表现为早上醒来感到有点累，或者有一点疲惫。“砖头”则是，也许你忽略了那个信号或者没注意到，三四周后，你和某人吵了一架，或者你只是感到沮丧和糟糕，失去了冷静。接着，“自卸卡车”可能是一个月后，甚至一年后，出现了一场全面的健康危机，比如患上二型糖尿病或一系列其他问题，又或者你被解雇了。可能会发生很多不同的事情，但通常取决于一个人的敏感程度或内感官能力。理想情况下，你希望在还是“羽毛”阶段时就察觉到，然后做出调整或转变，而不是非要等到体验到“自卸卡车”带来的剧烈痛苦，不幸的是，很多人在第一次经历职业倦怠时都会面临这种情况。

---

### [00:36:18] [Lenny]

**English:**
This is such an important point and such a good way of thinking about it. It reminds me of Andy Johns and the episode we had there of just how long and willing to the episode there of just how all these little things came up along the way and then eventually just became incredibly unsustainable to live the life that he was living.

**中文翻译:**
这是一个非常重要的观点，也是一种很好的思考方式。这让我想起了 Andy Johns 以及我们做过的那一集，谈到一路上出现了这么多小事，最终让他当时的生活变得完全无法持续。

---

### [00:36:34] [Lenny]

**English:**
This episode is brought to you by Miro. Do you ever feel like your projects aren't as organized as you like them to be or it's way too hard for people on your team to find all of the documents and files and context that they need for their project? Miro helps you streamline your workflows, organize information, and get your whole team on the same page. If you want to see what Miro can do for you, check out my Miro board that the Miro team helped me create, which includes all of my favorite plug and play templates, like a user journey map, my favorite one pager template plus a brainstorming guide. My board also has a place for you to share suggestions for this podcast and also answer a question that I have for you. You can then take my Miro board and easily create your own to see how it feels. Make sure to check out some of my favorite features, like the sticky notes, the inline comments and charts, and also the really cool diagramming tools. Check it out at miro.com/lenny. Your first three Miro boards are free when you sign up today at miro.com/lenny. Find simplicity in your most complex projects with Miro. That's M-I-R-O.com/lenny.

**中文翻译:**
本集节目由 Miro 为您带来。您是否曾觉得项目不如预想的那样井井有条，或者团队成员很难找到项目所需的所有文档、文件和背景信息？Miro 帮助您简化工作流程，组织信息，并让整个团队达成共识。如果您想看看 Miro 能为您做些什么，请查看 Miro 团队帮我创建的 Miro 画板，其中包含了我最喜欢的所有即插即用模板，如用户旅程图、我最喜欢的一页纸模板以及头脑风暴指南。我的画板还有一个地方供您分享对本播客的建议，并回答我向您提出的问题。您可以直接使用我的 Miro 画板并轻松创建您自己的画板来体验。一定要查看我最喜欢的一些功能，如便签、行内评论和图表，以及非常酷的绘图工具。请访问 miro.com/lenny。今天注册即可免费获得前三个 Miro 画板。使用 Miro，在最复杂的项目中寻找简单。

---

### [00:37:40] [Lenny]

**English:**
What are some examples of this feather? So your advice here is just pay attention to these little signs that you're not living a sustainable life right now. What are some examples of these kind of feathery signs of like maybe I need to change something?

**中文翻译:**
“羽毛”的一些例子是什么？所以你的建议是关注这些表明你目前生活方式不可持续的小迹象。这些“羽毛般”的迹象有哪些例子，比如“也许我需要改变一些事情”？

---

### [00:37:55] [Jonny Miller]

**English:**
Yeah, so I'll tie this in with a concept that I call emotional debt, which is basically when our nervous system experiences stress, there's known as a mobilization cycle, and if that cycle isn't completed or we don't get to downshift or relax on the other side, that gets stored in the body as allostatic load, which I call emotional debt. And over time, that creates fragility in the nervous system. And so what that fragility can look like is anything from being impacted by small things in a kind of disproportionate way. So noticing that you are more reactive than normal, maybe you're a little bit more snappy, maybe you get frustrated by little things, maybe your sleep isn't as good, maybe you wake up not feeling fully rested. Maybe relationships are often, especially intimate relationships are usually a place that this shows up or relationships at work. So those are the classic early warning signs. And then as that emotional debt threshold increases in the same way that say with technical debt, if you're building a product in the beginning, it's fine, and in fact it's even necessary in the beginning. It's great that our body can buffer the stress response because it allows us to function. But if we don't pay off that technical debt or emotional debt, then over time it accumulates and it can also come out through health crises, health challenges. It just gets basically progressively worse until that debt is paid off.

**中文翻译:**
是的，我会把这与我称之为“情感债”（emotional debt）的概念联系起来。基本上，当我们的神经系统经历压力时，会有一个所谓的“动员循环”（mobilization cycle）。如果这个循环没有完成，或者我们没有在另一端实现“降档”或放松，压力就会以“稳态负荷”（allostatic load）的形式储存在体内，我称之为情感债。随着时间的推移，这会导致神经系统的脆弱性。这种脆弱性可能表现为：被一些小事以一种不成比例的方式影响。比如，注意到自己比平时更具反应性，也许更容易发火，也许会因为一点小事感到沮丧，也许睡眠质量下降，也许醒来时感觉没有完全休息好。人际关系，尤其是亲密关系，通常是这种迹象显现的地方，或者是工作中的人际关系。这些都是经典的早期预警信号。随着情感债阈值的增加，就像技术债一样，如果你在开始构建产品时，欠点债没关系，事实上在开始阶段甚至是必要的。我们的身体能够缓冲压力反应是很棒的，因为它让我们能够维持功能。但如果我们不偿还那些技术债或情感债，随着时间的推移，它就会累积，并可能通过健康危机、健康挑战表现出来。基本上，在债务偿清之前，情况会逐渐恶化。

---

### [00:39:25] [Lenny]

**English:**
I feel like a lot of people listening are like, "Yes, I know exactly what you mean." How does one notice that you're building emotional debt and then how do you start to release this debt and pay off this debt?

**中文翻译:**
我觉得很多听众都会想，“是的，我完全明白你的意思”。一个人如何察觉到自己正在积累情感债，然后如何开始释放并偿还这些债务？

---

### [00:39:38] [Jonny Miller]

**English:**
What I've seen with some of my founder clients and in the research that we did where we interviewed 260 leaders, what can often happen is that emotional debt will increase and increase and increase until it gets to a point where we are well outside what's known as a window of tolerance. And at that point there's like a crash. It's almost like the fuse switch blows and there's exhaustion. Maybe there's complete inability to get up off the couch. And for some people, people with large nervous system capacity, they can keep going for five years, maybe 10 years, and they can keep building this up, and it becomes normalized to live in a way where you are always on and never really relaxing or coming down. Or one really key sign actually is if you are not able to naturally downshift or down regulate your nervous system at the end of the day without something like wine or CBD or some kind of external substance, that's a sign that you kind of reached a certain threshold of emotional debt.

**中文翻译:**
在我的一些创始人客户以及我们对 260 位领导者进行的研究中，我发现情感债会不断增加，直到达到一个点，使我们远远超出了所谓的“容纳之窗”（window of tolerance）。到那时，就会出现崩溃。就像保险丝烧断了一样，会出现精疲力竭。也许完全无法从沙发上站起来。对于某些神经系统容量大的人来说，他们可以坚持五年，甚至十年，不断积累，以至于这种“始终开启”且从未真正放松或降温的生活方式变得常态化。或者一个非常关键的迹象是：如果你在一天结束时，如果不借助红酒、CBD 或某种外部物质，就无法自然地让神经系统“降档”或下调，那就说明你已经达到了情感债的某个阈值。

---

### [00:41:08] [Lenny]

**English:**
And then how does one start to pay off this debt if you've spent years just working way too hard, you've had a relationship that just isn't working great, I don't know. I imagine most people go to therapy and just talk through all these things and try to work through the challenges. What do you recommend if you're just like, "Man, I feel like I have this, what should I do?"

**中文翻译:**
那么，如果一个人已经花了多年时间拼命工作，或者一段关系一直不太顺，该如何开始偿还这笔债呢？我猜大多数人会去看心理医生，通过交谈来梳理这些事情并尝试解决挑战。如果你觉得“天哪，我觉得我正处于这种状态”，你会推荐什么做法？

---

### [00:41:08] [Jonny Miller]

**English:**
Yeah, well, I mean that's a big question. I'll probably get some pushback for this, but I'm not a big fan of talk therapy alone or at least therapy that doesn't have a somatic or body-based component. And from my understanding of the nervous system and how we store this stress, just talking about things and keeping things on the level of the intellect doesn't actually address the root of the challenge. What we need to do is create a certain sense of safety to kind of go into those buffered emotional responses and feel them all the way through and allow that mobilization reflex to complete.
(00:41:48):
And so to kind of give a personal example, when I was living in Bali, I did several hundred breathwork journeys where you breathe in a certain way to get into an altered state, and then in that place, these memories would arise of these things that happened 5, 10 years ago. And my body, it would either move a certain way or the anger would come through. Sometimes there would be sadness or grief. Often there's a lot of stored emotion that's held in our body that just needs permission to kind of be felt through and be released. And so for me, it was a journey of coming into right relationship with my anger and my grief, and honestly my shame as well, giving myself permission to feel this gunk that had been stored in my pelvis.
(00:42:35):
So I'm not saying you have to go to Bali and do 200 breathwork journeys. That's definitely not... I mean, that's a path. But first it begins with, as I said, cultivating interoception and even being aware that there is this tension, there are these things in your body. Secondly, having the practices of self-regulation so that if these things come up, you don't get overwhelmed. You're able to downshift and ground. And then thirdly, it's the practice of what I call emotional fluidity, which is basically creating the conditions of welcoming the full spectrum of emotions as they arise. And often it's very helpful to have a guide or a somatic practitioner, I like somatic experiencing, hakomi, the two modalities I'm a big fan of. And yeah, that's the journey and a process and it depends how many years you've been operating in a slightly numbed way, and it's different for everyone. But it begins by tuning into and listening to the body and then having honestly curiosity about what is there and just following that curiosity and the body starts to show you what is ready to be seen.

**中文翻译:**
是的，这是一个宏大的问题。我接下来的话可能会引起一些反对，但我并不推崇单纯的谈话疗法，或者至少是不包含“躯体”（somatic）或基于身体成分的疗法。根据我对神经系统以及我们如何储存压力的理解，仅仅谈论事情并将其维持在智力层面，实际上并不能解决挑战的根源。我们需要做的是创造一种安全感，去进入那些被缓冲的情绪反应，完整地感受它们，并让那个“动员反射”完成。
(00:41:48):
举个个人的例子，当我住在巴厘岛时，我进行了数百次呼吸法之旅，通过特定的呼吸方式进入一种意识改变状态。在那个状态下，5 年、10 年前发生的事情的记忆会浮现。我的身体会以某种方式移动，或者愤怒会爆发出来。有时是悲伤或哀恸。通常我们的身体里储存了大量的情绪，它们只需要被允许去完整感受并释放。对我来说，这是一个与我的愤怒、悲伤，坦白说还有羞耻感建立正确关系的过程，允许自己去感受储存在盆腔里的这些“脏东西”。
(00:42:35):
所以我不是说你必须去巴厘岛做 200 次呼吸法之旅。那绝对不是……我的意思是，那只是一条路。但首先，正如我所说，要从培养内感官开始，甚至只是意识到身体里存在这种张力。其次，要有自我调节的练习，这样当这些情绪出现时，你不会被淹没，而是能够降档并稳住自己。第三，是我称之为“情绪流动性”（emotional fluidity）的练习，基本上就是创造条件，欢迎所有情绪在产生时自然流动。通常，有一个引导者或躯体从业者会非常有帮助，我非常推崇“躯体体验疗法”（Somatic Experiencing）和“哈科米疗法”（Hakomi）这两种模式。是的，这是一个旅程和过程，取决于你以轻微麻木的方式运作了多少年，每个人都不同。但它始于调频并倾听身体，然后对内在的东西保持好奇心，顺着这种好奇心，身体就会开始向你展示哪些东西已经准备好被看见了。

---

### [00:43:49] [Lenny]

**English:**
I love that it always comes back to the original place we started which is that the way we feel is a very bottom up body-based system, it's not we feel something and our body gets nervous. It's our body gets nervous, and they're like, "Oh, here's why I'm nervous." And your advice is just focus a lot on helping your body release the stuff that you've built up this debt. And then also just when you're nervous in the moment, focus on getting your body to a state versus trying to convince your mind now everything's going to be okay.

**中文翻译:**
我喜欢这种回归原点的感觉，即我们的感受是一个非常“自下而上”的、基于身体的系统。并不是我们先感觉到什么然后身体变得紧张，而是身体先变得紧张，然后大脑才反应过来，“噢，这就是我紧张的原因”。你的建议是，多花精力帮助身体释放积累的债务。同时，当你当下感到紧张时，专注于让身体进入某种状态，而不是试图说服大脑“现在一切都会好起来的”。

---

### [00:44:17] [Jonny Miller]

**English:**
Exactly.

**中文翻译:**
没错。

---

### [00:44:17] [Lenny]

**English:**
Specifically on the therapy route, just to touch on that, so your advice there is if you were to work with a therapist and you feel a lot of this stuff that we're talking about is focused on a somatic oriented therapy where it's body oriented, not just thinking about it and talking through stuff, it's actually convincing your body, "Here's a way to helping your body release this debt, essentially."

**中文翻译:**
具体到疗法路径，我想补充一点，你的建议是：如果你要找治疗师，并且你觉得我们讨论的这些内容很有共鸣，那么应该专注于以躯体为导向的疗法，即以身体为中心，而不仅仅是思考和交谈。这实际上是在说服你的身体，“这是一种帮助你释放债务的方式”。

---

### [00:44:40] [Jonny Miller]

**English:**
Yeah. I mean, you can understand in precise detail about whatever the challenge was from 5, 10 and 15 years ago, but if you're unable to connect it to the correlating sensations in the body... Usually if say, I don't know, if I was to imagine someone shouted at me yesterday and I think about that, there's usually a correlating kind of sematic sensation. The neuroscientist Damasio calls it a somatic marker. So by tracking the somatic markers and then either on your own just kind of following that sensation and allowing whatever emotion was present at the time to complete that is the way that we kind of slowly pay off that emotional debt by one process at a time.

**中文翻译:**
是的。我的意思是，你可以精确地理解 5 年、10 年或 15 年前的挑战是什么，但如果你无法将其与身体中相关的感觉联系起来……通常，如果我想象昨天有人对我大喊大叫，当我想到这件事时，通常会有一种相关的躯体感觉。神经科学家 Damasio 称之为“躯体标记”（somatic marker）。通过追踪这些躯体标记，然后无论是独自一人还是在引导下，顺着那种感觉，允许当时存在的任何情绪完整地表达出来，这就是我们通过一个接一个的过程慢慢偿还情感债的方式。

---

### [00:45:26] [Lenny]

**English:**
So maybe coming back to this question of say someone is listening and wondering, am I building emotional debt? Am I ignoring things that are these feathers? What are signs and just, I don't know, examples of emotional debt being built up of this trauma, whatever you want to call it, being built up in the body? I don't know, is it just like anytime you feel really nervous, that's emotional debt? Is it anytime you push something down that you are pretty sure you should deal with in the moment, that's emotional debt? What are just some examples of what that feels like and looks like?

**中文翻译:**
所以回到这个问题：如果有听众在想，我是否正在积累情感债？我是否忽略了那些“羽毛”？情感债或创伤（随你怎么称呼）在体内积累的迹象和例子是什么？我不确定，是每次感到非常紧张都算情感债吗？还是每次你压抑了某些你确定当时应该处理的事情，就算情感债？这种感觉和表现有哪些例子？

---

### [00:45:58] [Jonny Miller]

**English:**
Yeah, so it's typically different forms of nervous system dysregulation and that shows up as it could be someone's breathing pattern if they're constantly in this sympathetic or hypervigilant state, if they're always tracking for things, looking for the worst case scenario. Another common one, and this is particularly true in the tech sector, is being very much in the head and living in the thoughts and the mind the entire time. And there's a form of disassociation that happens as a kind of protection mechanism essentially because it's uncomfortable to be with the sensations in the body. And because our society tends to reward people for solving problems and being in their mind, that is a pattern that continues for many, many years or even decades.
(00:46:43):
Other ones are, I think the most obvious one for people is emotional reactivity, where your response to a certain situation is disproportionate to what's happened. So for example, if you said something to me of that doesn't make any sense, and I was like, I freeze maybe... And this is another important point that most people have two versions of reactivity. Some people will freeze, withdraw, shut down and disconnect, and other people will become more aggressive, become bigger and attack and fight back. And knowing which way you tend to orient, for me, it's usually shrink and freeze and shut down, knowing what your pattern is and also knowing what the sensations are when this happens, it's really helpful for you to be like, "Oh, that thing's happening." My priority now is to downshift and kind of find a sense of safety basically in the body and then interact, then make the decision, then have the conversation. Because if you can keep going from that place of reactivity, nothing good happens from that place. No great decisions were made from that place. So again, that's a place where having the interoceptive awareness to know, "Oh, this is what's going on." Being able to then downshift your system, kind of access a sense of, "Oh, I'm okay, actually this isn't so bad." And then moving on from there is a profoundly practical and just useful skill.

**中文翻译:**
是的，这通常表现为不同形式的神经系统失调。它可能表现为呼吸模式——如果一个人一直处于交感神经兴奋或高度警觉的状态，总是在搜寻信息，寻找最坏的情况。另一个常见的表现，特别是在科技行业，就是过度沉溺于思考，整天活在想法和头脑中。这其实是一种作为保护机制的“解离”（disassociation），因为与身体的感觉待在一起是不舒服的。由于我们的社会倾向于奖励那些解决问题和善于思考的人，这种模式往往会持续很多年甚至几十年。
(00:46:43):
其他的表现，我认为对人们来说最明显的是“情绪反应性”（emotional reactivity），即你对某种情况的反应与发生的事情不成比例。例如，如果你对我说“这根本说不通”，而我可能会僵住……这里还有一个重点，大多数人有两种反应模式：有些人会僵住、退缩、关闭并断开连接；而另一些人会变得更具攻击性、变得更强势并反击。了解你倾向于哪种方式——对我来说，通常是退缩、僵住和关闭——了解你的模式以及发生这种情况时的身体感觉，对你非常有帮助，让你能意识到：“噢，那件事正在发生。”我现在首要任务是降档，在身体里找到一种安全感，然后再去互动、做决定或交谈。因为如果你继续从那种反应性的状态出发，不会有什么好结果，也不会做出什么伟大的决定。所以，拥有内感官觉察来知道“噢，这就是正在发生的事”，能够下调你的系统，获得一种“噢，我很好，其实没那么糟”的感觉，然后从那里继续，是一项极其深刻且实用的技能。

---

### [00:48:14] [Lenny]

**English:**
Kind of along these same lines, you wrote somewhere this idea that you have a big competitive advantage if you feel the feels is the way you described it. Does that ring a bell? And if so, what can you share around that, just why this is so powerful, especially in the workplace?

**中文翻译:**
沿着同样的思路，你在某处写过这样一个观点：如果你能“感受那些感受”（feel the feels），你就会拥有巨大的竞争优势。你有印象吗？如果是这样，关于这一点你能分享些什么？为什么这如此强大，特别是在职场中？

---

### [00:48:28] [Jonny Miller]

**English:**
Yeah, so I think I wrote about this in one of the Every essays. I think the title was The Best Decision-Making Is Emotional. And I basically wanted to kind of poke at the phrase, I think I saw someone on Twitter say, "Fact over feelings, like don't let emotions ruin good decision making." And yeah, there's so much that I can say about this. But basically there was a landmark study by this guy, Damasio, this kind of famous neuroscientist, and he studied a patient called Elliot. And Elliot had a tumor in his brain that was removed and it basically meant that he was unable to feel emotions. So his entire emotional capacity was removed. And Elliot went from being a successful married businessman to divorced, broke and unable to choose what he could have for lunch. He was unable to make the most basic life decisions, and it's because he didn't have access to that emotional sense in his brain.
(00:49:22):
And so our brain is like a prediction making machine, and as I mentioned earlier, there's this highway of sensory data that's coming up through the body. And if we don't listen to that when we are making decisions, then we're losing out on a lot of information. And what avoids to happen, I see this in clients that I work with, is if they are avoiding feeling a certain way, let's say, that they don't enjoy feeling conflict or anger, then they will make decisions subconsciously to avoid feeling that way. And it becomes a huge bias and a huge problem because people make decisions because they're afraid of feeling a certain way. And if you are on the other hand able to just welcome and be with whatever emotions would arise on the other side of a decision, you're able to decide clearly instead of being skewed one way or the other.

**中文翻译:**
是的，我想我在 Every 的一篇散文中写过这个。标题好像是《最佳决策是情感化的》。我基本上是想反驳一句话，我记得在 Twitter 上看到有人说：“事实重于感受，不要让情绪毁了好的决策。”关于这一点我有很多想说的。但基本上，著名的神经科学家 Damasio 做过一项里程碑式的研究，他研究了一个叫 Elliot 的病人。Elliot 脑部有个肿瘤被切除了，这基本上意味着他无法感受到情绪。他的整个情绪能力都被移除了。Elliot 从一个成功的已婚商人变成了离婚、破产，甚至无法决定午餐吃什么。他无法做出最基本的生活决策，因为他无法获取大脑中的那种情感感知。
(00:49:22):
所以我们的大脑就像一台预测机器，正如我之前提到的，有一条感官数据的高速公路从身体传上来。如果我们做决定时不听取这些数据，我们就会错失大量信息。我从我的客户身上看到，如果他们逃避某种感受——比方说，他们不喜欢冲突或愤怒的感觉——那么他们会在潜意识里为了避免产生那种感觉而做决定。这变成了一个巨大的偏见和问题，因为人们做决定是因为害怕某种感受。反之，如果你能够欢迎并接纳决定之后可能产生的任何情绪，你就能清晰地做决定，而不是被偏见所左右。

---

### [00:50:16] [Lenny]

**English:**
Easier said than done.

**中文翻译:**
知易行难。

---

### [00:50:18] [Jonny Miller]

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:50:21] [Lenny]

**English:**
Do you find there's ever a downside to being too in touch with what you're feeling? I actually not a feeler of what I'm feeling kind of person. I'm pretty stable, partly because I'm not super in tune with what I'm feeling a lot of times, and maybe this is a huge problem that I need to deal with. But I don't know, it's worked out okay so far. I guess, do you ever find that sometimes it's okay, sometimes you don't need to know exactly every moment anything that's hurting you or causing you pain?

**中文翻译:**
你是否觉得过度关注自己的感受会有副作用？我其实不是那种特别能感知自己情绪的人。我挺稳定的，部分原因是我很多时候对自己的感受并不超级敏感，也许这是一个我需要处理的大问题。但我不知道，目前为止还算顺利。我想问，你是否觉得有时候这样也没关系，有时候你不需要时刻精确地知道什么在伤害你或让你痛苦？

---

### [00:50:49] [Jonny Miller]

**English:**
Yeah, it's a good question. And some people do have a very high interoceptive capacity, and that can be overwhelming. In which case I would recommend focusing on the breathing practices to build that capacity to downshift, so you're able to just function. And there's definitely people who are overwhelmed by the stimuli of day-to-day life being out in traffic, like they're very easily overwhelmed. And for those people working on increasing nervous system capacity to kind of hold that amount of stress, maybe it's through sauna and cold plunge, maybe it's through gentle titration of stresses and then downshifting, that's actually really valuable.
(00:51:28):
I'd also say that the ability to function well, this applies to a lot of high functioning people, which is probably honestly a lot of your audience. It's very helpful in the moment to, let's say something comes up, you want to be able to buffer intense emotions and say, get through the meeting, get through whatever it is. It's a very helpful skill. But if you don't, then give yourself spaciousness afterwards to downshift and allow yourself to feel whatever was brought up by that experience, you are going to be adding to this emotional debt over time. And as I mentioned, some people, it might be a year before there's some kind of breakdown, burnout. Other people, it might be longer. And usually it's more unfortunate in the longer case because it creates a long-term health crisis and then lower amount of money or time is able to repair the damage that's been done, which can be really tragic.

**中文翻译:**
是的，这是个好问题。有些人的内感官能力确实非常强，这可能会让人不堪重负。在这种情况下，我会建议专注于呼吸练习，以建立降档的能力，从而让你能够维持正常功能。确实有些人会被日常生活的刺激（比如交通堵塞）所淹没，他们很容易感到崩溃。对于这些人来说，努力提高神经系统的容量以承受这种压力——也许是通过桑拿和冷水浴，也许是通过压力的温和滴定（titration）然后降档——这实际上非常有价值。
(00:51:28):
我还想说，良好运作的能力适用于很多高功能人士，这可能也是你大部分听众的情况。在当下，比如发生了一些事情，你希望能够缓冲强烈的情绪，顺利完成会议或任何事情，这是一种非常有用的技能。但如果你之后不给自己留出空间来降档，并允许自己去感受那次经历带来的任何情绪，随着时间的推移，你就会增加情感债。正如我提到的，有些人可能一年后才会出现崩溃或职业倦怠，有些人可能更久。通常时间越长越不幸，因为它会导致长期的健康危机，到那时，再多的金钱或时间也难以修复已经造成的损害，这真的很悲剧。

---

### [00:52:24] [Lenny]

**English:**
My chat with Andy Johns is a great example of that happening.

**中文翻译:**
我与 Andy Johns 的谈话就是这种情况发生的一个很好的例子。

---

### [00:52:26] [Jonny Miller]

**English:**
Yeah. And Andy's a superb example, and I love his vulnerability and honesty in what he's been through.

**中文翻译:**
是的。Andy 是一个极佳的例子，我非常欣赏他在讲述自己经历时的那份脆弱和诚实。

---

### [00:52:33] [Lenny]

**English:**
Yeah, I think if you're interested in this topic, definitely watch that episode. Another exercise that you talk a lot about is this idea, it's called NSDR, I think. Talk about that and when that might be useful, how to go about using this tool.

**中文翻译:**
是的，我想如果大家对这个话题感兴趣，一定要看那一集。你经常谈到的另一个练习是 NSDR。谈谈那是什么，什么时候有用，以及如何使用这个工具。

---

### [00:52:49] [Jonny Miller]

**English:**
Yeah, so NSDR was a practice coined by Andrew Huberman, who you mentioned earlier. And it basically, it's a more scientific lens on the practice of yoga nidra, which is an ancient yoga practice. But I am a huge fan of it, and I do it myself most days for 15 to 20 minutes. Basically what it looks like is you lie down, put on an eye mask or a blindfold, and you listen to a guided audio. I've recorded some myself, so I can share these in the show note links.

**中文翻译:**
是的，NSDR 是由你之前提到的 Andrew Huberman 创造的一个术语。它基本上是以更科学的视角来看待“睡眠瑜伽”（yoga nidra），这是一种古老的瑜伽练习。我是它的忠实粉丝，我自己大多数日子都会做 15 到 20 分钟。基本上就是躺下，戴上眼罩或遮光布，听一段引导音频。我自己也录制了一些，我可以在节目介绍链接中分享。

---

### [00:53:16] [Lenny]

**English:**
Your voice would be so good for these, by the way. You found your calling.

**中文翻译:**
顺便说一下，你的声音非常适合做这个。你找到了你的天职。

---

### [00:53:22] [Jonny Miller]

**English:**
Nice, yeah. It's really fun for me to do. But basically what it involves is a guided body scan. So this is also a great way to practice interoception. It's something that I didn't mention earlier was that when there's cortisol present in our body, the cortisol basically acts as a numbing agent, so it's much harder to kind of tune into those sensations. But using this, I think it's a 14-minute guided NSDR practice, you're basically lying down, there's a guided body scan, there's relaxing music in the background. And by the end of it, you feel like you've had a two-hour nap. It feels incredible.
(00:54:00):
And particularly for people who myself tend to get tired in the afternoons, if you space this out, usually between 1 and 3:00 PM for me, that will give you a second wind in the afternoon and it'll mean you won't end the day collapse on the sofa. So I think it's great for improving interoception, it's good for allowing your body to downshift and relax instead of being in that kind of high tone sympathetic state all throughout the day. So it gives your body a break, and it just feels really good. Honestly, it's probably my most played practice of everything that I teach, just people listen to it every day. So I'll share that in the show notes as well.

**中文翻译:**
太好了，是的。做这个对我来说真的很有趣。它基本上包含一个引导式的全身扫描。所以这也是练习内感官的一种极好方式。我之前没提到的一点是，当体内存在皮质醇时，皮质醇基本上起到了麻醉剂的作用，所以很难感知到那些感觉。但通过这个——我想是一个 14 分钟的引导式 NSDR 练习——你基本上就是躺着，有引导式的全身扫描，背景有放松的音乐。结束时，你会感觉像是睡了两个小时的午觉。感觉棒极了。
(00:54:00):
特别是对于像我这样下午容易疲倦的人，如果你安排好时间——对我来说通常在下午 1 点到 3 点之间——这会让你在下午获得“第二次呼吸”（恢复活力），这意味着你不会在一天结束时瘫倒在沙发上。所以我认为它对于提高内感官非常棒，也有助于让身体降档和放松，而不是整天处于那种高张力的交感神经兴奋状态。它让你的身体得到休息，而且感觉真的很好。老实说，在我教的所有内容中，这可能是播放次数最多的练习，人们每天都会听。我也会在节目介绍中分享。

---

### [00:54:41] [Lenny]

**English:**
And I imagine if you feel like you've built this emotional debt, this would be a really good exercise to start to do, is that right?

**中文翻译:**
我想如果你觉得已经积累了情感债，这会是一个非常好的开始练习，对吗？

---

### [00:54:49] [Jonny Miller]

**English:**
Yeah, it is fantastic. I mean, there's some people who struggle with having enough energy to kind of get out of bed and function. But again, I imagine listeners to your show, people that live in Silicon Valley, their challenge is the downshifting without external substances. And so NSDR is a really great way of strengthening that ventral vagal tone, which is our body's capacity to go from on kind of go, go, go to then relaxing. There's a quote from Kevin Kelly that I interviewed recently, and he said, "If you have a great work ethic that needs to be matched with a great rest ethic." And I think that kind of piece of actually training our capacity to downshift after stress is just completely missing from most people's playbooks.

**中文翻译:**
是的，它非常棒。我的意思是，有些人甚至挣扎于没有足够的能量起床和维持功能。但同样，我猜你的听众，那些住在硅谷的人，他们的挑战是在不借助外部物质的情况下实现降档。NSDR 是增强“腹侧迷走神经张力”（ventral vagal tone）的一种极好方式，这种张力就是我们身体从“冲冲冲”状态转入放松状态的能力。我最近采访了 Kevin Kelly，他有一句话：“如果你有极佳的工作伦理，就需要与之匹配的极佳休息伦理。”我认为，这种在压力后训练降档能力的环节，在大多数人的生活准则中是完全缺失的。

---

### [00:55:38] [Lenny]

**English:**
I think with a lot of the sort of advice, if you listen, Tim Ferriss and Huberman and everyone's got this stuff you should be doing every day list and it ends up being so long and there's so many things to do, cold plunge, sauna. What is it that you practice or come back to slash what would you recommend people try to do daily that is most impactful of all this stuff we've talked about?

**中文翻译:**
我想对于很多这类建议，如果你听 Tim Ferriss、Huberman 等人的，每个人都有一份“每天必做清单”，最后清单变得特别长，有太多的事情要做：冷水浴、桑拿。在你谈到的所有这些内容中，你个人会坚持练习或回归的是什么？或者你会推荐人们每天尝试做的、影响力最大的事情是什么？

---

### [00:56:05] [Jonny Miller]

**English:**
First experiment with a bunch of different practices and see which you enjoy and notice how you feel before and then how you feel afterwards. That's kind of the key because once you know that it feels good, you're not going to have to force yourself or motivate yourself to do it. You'll just do it naturally because you know you'll feel great afterwards. I would recommend starting really simple, so starting with the 4, 4, 8 breathing or humming, doing that in the morning for just two minutes, two minutes in the beginning is enough. And I would also recommend listening to the NSDR practice at least once or twice. If you work from home, it's pretty easy after a lunch break, something like that could also be in the evening when you get home as well. Some people use it to help fall asleep.
(00:56:52):
And then the final thing that I would recommend is if you have the resources and you have access, finding a somatic practitioner or somatic therapist is so [inaudible 00:57:03]. I mean, I emerged a completely different human on the other side of the 200 breathwork journeys. I have a different experience of life basically released so much time. Even my voice sounds different. If you listen to the podcast episodes I recorded four or five years ago, my voice is higher pitched. It just sounds different. It has a different resonant quality to it.

**中文翻译:**
首先，尝试一系列不同的练习，看看你喜欢哪一个，并注意做之前和之后的感受。这是关键，因为一旦你知道它感觉很好，你就不用强迫自己或激励自己去做。你会自然而然地去做，因为你知道做完后感觉会很棒。我建议从非常简单的开始，比如 4-4-8 呼吸或哼鸣，早上只做两分钟，开始时两分钟就足够了。我还建议至少听一两次 NSDR 练习。如果你在家工作，午休后做这个很容易，或者晚上回家后也可以。有些人用它来助眠。
(00:56:52):
最后我推荐的是，如果你有资源和途径，找一个躯体从业者或躯体治疗师是非常……我的意思是，在经历了 200 次呼吸法之旅后，我变成了一个完全不同的人。我对生活有了不同的体验，基本上释放了大量的（压抑）。甚至我的声音听起来都不一样了。如果你听我四五年前录制的播客，我的声音音调更高。它听起来就是不一样，有一种不同的共鸣质感。

---

### [00:57:27] [Lenny]

**English:**
Wow. Okay, awesome. So you've kind of summarized, I was going to try to summarize all the advice you've given, but if you were to do the bare minimum next steps based on this advice, try this 4, 4, 8/3, 3, 6/2, 2, 4. Does 2, 2, 4 work too if you just go real fast I guess?

**中文翻译:**
哇。好的，太棒了。你已经总结过了，我本来还想试着总结一下你给出的所有建议。但如果根据这些建议采取最起码的后续步骤，那就是尝试 4-4-8、3-3-6 或 2-2-4。我想如果节奏很快，2-2-4 也可以？

---

### [00:57:28] [Jonny Miller]

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:57:45] [Lenny]

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:57:46] [Jonny Miller]

**English:**
Okay.

**中文翻译:**
好的。

---

### [00:57:46] [Lenny]

**English:**
Okay, perfect. Okay, so do that for a couple mornings. See how that does try this NSDR practice. We'll link to a recording of how to do that and then was there something else you recommended? Oh, somatic worker, basically maybe a therapist, maybe not someone that helps you with your body.

**中文翻译:**
好的，完美。所以坚持做几个早上。看看效果如何，尝试一下 NSDR 练习。我们会链接到如何操作的录音。然后你还推荐了别的吗？噢，躯体工作者，基本上可能是治疗师，也可能不是，就是能帮助你处理身体问题的人。

---

### [00:58:06] [Jonny Miller]

**English:**
Yeah, and I'd add in the eight practice for even 15 seconds before the breathing in the morning and after, just so that you notice the difference. And if you do the NSDR, that is basically a 15-minute interoception practice as well. So you're kind of getting two birds with one stone with that practice.

**中文翻译:**
是的，我还想补充一点，在早上呼吸练习前后，哪怕只花 15 秒做一下 APE 练习，这样你就能注意到差异。如果你做 NSDR，那基本上也是一个 15 分钟的内感官练习。所以那个练习可以说是一石二鸟。

---

### [00:58:24] [Lenny]

**English:**
What's your perspective on meditation? Does that fit into this? Do you find the NSDR replaces the need for meditation?

**中文翻译:**
你对冥想怎么看？它能融入其中吗？你觉得 NSDR 可以取代冥想吗？

---

### [00:58:29] [Jonny Miller]

**English:**
That is a big topic. I am an avid meditator as what I've done many 10 day silent retreats. I was in a dark room for 10 days.

**中文翻译:**
那是一个宏大的话题。我是一个狂热的冥想者，参加过很多次十日禅修。我曾在黑屋子里待过 10 天。

---

### [00:58:40] [Lenny]

**English:**
Wow.

**中文翻译:**
哇。

---

### [00:58:41] [Jonny Miller]

**English:**
With meditation, I think it really depends on what you are training. It's like saying what's your opinion on exercise? Well, are you training mobility or stamina or strength? It's the same with meditation. You could be training loving kindness. You could be training your focus and attention. You could be training spacious awareness. So I'm a big fan of embodied meditation practices. So this is often the classic vipassana body scan is a good example. Again, I mean that's basically interoceptive practice where you are just moving your attention through different parts of your body over and over and over again for days on end.
(00:59:17):
In the case of vipassana retreat, meditation is helpful for the specific skill of increasing the psychological space between a stimulus and your response. So if you have some degree of meditation practice instead of getting wrapped up in a certain emotion or we're even believing a certain thought pattern, there's usually an ability to kind of step back a little bit and see if what it's, so there definitely is a place for meditation. But my viewpoint is that we've kind of over-indexed for mindfulness and meditation in over the last 20 years. There's so many apps, there's so there's much talk about it and we've completely forgotten the body-based approaches. So I'm not saying don't meditate. I think meditation for sure has its place, especially if your goal is more of the traditional waking up and seeing through the nature of the self, that's a different kind of path in my opinion. But if you're looking to function more effectively and be more in tune with your body, then there's a whole different category of practices in this bottom up variety that we've touched on today.

**中文翻译:**
关于冥想，我认为这取决于你在训练什么。就像问“你对运动怎么看？”一样，你是在训练灵活性、耐力还是力量？冥想也是如此。你可能在训练慈悲心，可能在训练专注力和注意力，也可能在训练广阔的觉察。所以我非常推崇“具身冥想”（embodied meditation）练习。经典的内观（Vipassana）全身扫描就是一个很好的例子。再次强调，那本质上就是内感官练习，你只是日复一日地不断将注意力移过身体的不同部位。
(00:59:17):
在内观禅修的情况下，冥想有助于培养一种特定技能，即增加刺激与反应之间的心理空间。如果你有一定的冥想练习，那么当你面对某种情绪或甚至相信某种思维模式时，通常能够退后一步，观察它的本质。所以冥想肯定有其一席之地。但我的观点是，在过去的 20 年里，我们对正念和冥想的关注有点过度了。有那么多的 App，有那么多的讨论，而我们完全忘记了基于身体的方法。所以我不是说不要冥想。我认为冥想肯定有它的位置，特别是如果你的目标是更传统的“觉醒”和看透自我的本质，在我看来那是另一种路径。但如果你是想更有效地运作并与身体更同步，那么今天我们触及的这种“自下而上”的练习属于一个完全不同的类别。

---

### [01:00:27] [Lenny]

**English:**
On the topic of bottom up, I imagine you're a big fan of this book that everyone always talks about, The Body Keeps Score, I think it's called. Would you recommend that book? Is it connected in a large part to the stuff you talk about? What do you think of that book specifically? Because I hear about it all with him.

**中文翻译:**
关于“自下而上”的话题，我猜你一定是那本大家总在谈论的书的粉丝，我想叫《身体从未忘记》（The Body Keeps the Score）。你会推荐那本书吗？它和你谈论的内容有很大关联吗？你具体怎么看那本书？因为我总听人提到它。

---

### [01:00:41] [Jonny Miller]

**English:**
Yeah, it's a good book. It's by Bessal van der Kolk and there's another writer I think Peter Levine says, "The issues are in the tissues." Is basically the concept. And this is the idea that we have these incomplete mobilization reflexes that are stored in our body and often held as tension. It's not strictly true to say that the trauma is in the body. It is actually a cortical map in the brain which kind of tracks these things. But for kind of practical purposes, it looks and feels as if there is stored grief in my right hip or anger in my solar plexus, that's the experience that we have. And the more that you become aware of these sensations and start to develop emotional fluidity essentially, the more that tension is released and the less reactive you become and the more emotional debt you pay off. So I think The Body Keeps The Score, I think a more accurate way would be the body is the scorecard in a way. I think that's kind a slight reframe. And if you're interested in this, the work of Peter Levine, Waking the Tiger is the seminal book on this mobilization reflex stuff that I'm describing.

**中文翻译:**
是的，那是一本好书。作者是 Bessel van der Kolk。还有另一位作家 Peter Levine 说过，“问题就在组织里”（The issues are in the tissues），这基本上就是核心概念。这个观点认为，我们体内储存了这些未完成的动员反射，并通常以张力的形式存在。严格来说，说创伤在身体里并不完全准确。它实际上是大脑中的一个皮层图谱在追踪这些事情。但出于实际目的，我们的体验看起来和感觉起来就像是右髋部储存了悲伤，或者太阳神经丛储存了愤怒。你越是意识到这些感觉并开始培养情绪流动性，张力就越能得到释放，你的反应性就会降低，偿还的情感债就越多。所以关于《身体从未忘记》，我认为更准确的说法应该是“身体是计分卡”。我认为这是一个微小的视角重构。如果你对此感兴趣，Peter Levine 的著作《唤醒老虎》（Waking the Tiger）是关于我所描述的动员反射内容的开山之作。

---

### [01:01:51] [Lenny]

**English:**
I never need that part of it. And basically it's actually kept in the brain, but it comes across as somewhere in the body.

**中文翻译:**
我以前不知道那部分。基本上它实际上保存在大脑中，但表现为身体的某个部位。

---

### [01:01:57] [Jonny Miller]

**English:**
Yeah, exactly.

**中文翻译:**
是的，没错。

---

### [01:01:58] [Lenny]

**English:**
I want to spend a little time on a new segment that we have in this podcast that I call Contrarian Corner. So let's visit Contrarian Corner, I feel like you'll have something interesting here. So the question is there something that you have a very contrarian opinion about, something that you believe that a lot of other people really don't believe?

**中文翻译:**
我想花点时间在我们播客的一个新环节，我称之为“反直觉角落”（Contrarian Corner）。让我们进入这个环节，我觉得你在这里会有一些有趣的观点。问题是：你是否有什么非常反直觉的观点，即你相信但很多其他人并不相信的事情？

---

### [01:02:17] [Jonny Miller]

**English:**
We've already touched on I'm not a big fan of talk based meditation, which will probably get me some comments I would imagine. I'd say the other one that's worth mentioning is I think that we vastly underestimate the impact of burnout, particularly from a bottom line perspective. There was a research report that I did a couple of years ago where we interviewed these leaders and they'd all experienced burnout of some degree. And we said, if you were to estimate how much this costs your startup or business, what would you say? And the median response was a hundred thousand dollars, which I imagine is more than most people would think.
(01:02:57):
And most people aren't actively investing in burnout insurance. Like it's not something that's on many people's radar besides meditation practices and things like that. And I think part of the reason that the cost is higher is because there are these second and third order consequences of talent attrition, of opportunity costs, lost productivity, you lose great leaders, make shitty decisions in the run up to the burnout itself. There's also this idea of emotional contagion, which there's some research from Wharton I believe, and they show that the leader or the CEO has a disproportionate impact or their emotional state has a disproportionate impact on the people in their team. So something I'd like to say is the nervous system of an organization is a reflection of the nervous system of the CEO. And so I think that's just something which I would like to see talked about more.

**中文翻译:**
我们已经触及了一点，即我不太推崇基于谈话的冥想，我想这可能会引来一些评论。我想说的另一个值得一提的观点是：我认为我们大大低估了职业倦怠的影响，特别是从底线（财务）的角度来看。几年前我做过一份研究报告，采访了一些经历过不同程度职业倦怠的领导者。我们问，如果你要估算这给你的初创公司或业务带来了多少损失，你会怎么说？中位数的回答是 10 万美元，我想这比大多数人想象的要多。
(01:02:57):
而且大多数人并没有积极投资于“职业倦怠保险”。除了冥想练习之类的，这并没有进入很多人的视野。我认为成本之所以更高，是因为存在二阶和三阶后果：人才流失、机会成本、生产力损失，你在职业倦怠爆发前会失去优秀的领导者，或者做出糟糕的决定。还有一个“情绪传染”的概念，我想沃顿商学院有一些研究表明，领导者或 CEO 的情绪状态对团队成员有着不成比例的巨大影响。所以我喜欢说：一个组织的神经系统是 CEO 神经系统的反映。我认为这是我希望看到更多讨论的事情。

---

### [01:03:53] [Lenny]

**English:**
Just on this idea of burnout, I don't think you're saying don't work really hard If you want to work really hard, it's that you need to maintain your body and mind and nervous system if you're working insanely hard. If you're working long hours, feel free, but just know there's debt you're building up and you need to be doing things to pay off that debt as you're doing that.

**中文翻译:**
关于职业倦怠这个观点，我想你并不是在说不要努力工作。如果你想努力工作，没问题，但如果你在疯狂工作，你需要维护你的身体、思想和神经系统。如果你要长时间工作，请便，但要意识到你正在积累债务，并且在工作的过程中，你需要做一些事情来偿还这些债务。

---

### [01:04:11] [Jonny Miller]

**English:**
Precisely. It is very much like building technical debt in the early days of a startup. It's worth doing, but just do it intentionally. Know that you're doing that and that. So let's say you work really hard for eight months, you give yourself a month or two off to really downshift. And it's also really worth building that nervous system capacity. It's great to be able to push it really hard and focus and then combine it with that rest ethic as well. So do NSDRs, kind of find a way to downshift so that way of working can be sustainable.

**中文翻译:**
正是如此。这非常像初创公司早期的技术债积累。这值得做，但要刻意为之。知道你正在这样做。比如，你拼命工作了八个月，那就给自己一两个月的时间来真正降档。提高神经系统的容量也非常值得。能够极度努力和专注是很棒的，但要将其与休息伦理结合起来。所以做做 NSDR，找到降档的方法，这样工作方式才能可持续。

---

### [01:04:44] [Lenny]

**English:**
Jonny, we reached our very exciting lightning round. Are you ready?

**中文翻译:**
Jonny，我们进入了非常令人兴奋的闪电问答环节。准备好了吗？

---

### [01:04:48] [Jonny Miller]

**English:**
Let's do it.

**中文翻译:**
开始吧。

---

### [01:04:49] [Lenny]

**English:**
First question, what are two or three books that you've recommended most to other people?

**中文翻译:**
第一个问题，你向别人推荐最多的两三本书是什么？

---

### [01:04:53] [Jonny Miller]

**English:**
I actually had a sense this question was coming and I have the books with me here. The first book is Constellations by David White. This is the book that I've gifted most to friends, I think more than any other book. And he basically has 52 definitions of words like ambition is I think the first word. And his writing, it just blows me away. I open this to a random page, read the definition, and it's probably affected me more than any other book. So that's one that I love. 15 Commitments of Conscious Leadership, which is I imagine has come up before in your podcast. This is by Jim Dethmer and Diana Chapman. They have the Conscious Leadership Group. And this is basically, in my opinion, it's the best leadership book that I've come across and it combines practicality with a lot of great theory. So this is awesome. And then finally, this is a bit out there, but Recapture the Rapture by Jamie Wheal, big fan of Jamie's work, Jamie's writing. This is kind of three books in one. The beginning is addressing the meta-crisis and a lot of the craziness that we're seeing in the world. The second chapter is very related to what we've been talking about, he calls it Hedonic Engineering and it's basically practices for shifting your state of consciousness. And the third is Ethical Cult Building, which I'll leave that there. [inaudible 01:06:22].

**中文翻译:**
我预感到会有这个问题，所以我把书都带来了。第一本是 David White 的《星座》（Constellations）。这是我送给朋友最多的书，我想比任何其他书都多。他基本上给 52 个词下了定义，我想第一个词是“野心”。他的文笔简直让我折服。我随手翻开一页，读一段定义，它对我的影响可能超过了任何其他书。这是我非常喜欢的一本。第二本是《意识领导力的 15 项承诺》（15 Commitments of Conscious Leadership），我想这在你的播客中肯定出现过。作者是 Jim Dethmer 和 Diana Chapman，他们创办了意识领导力小组。在我看来，这是我见过的最好的领导力书籍，它将实用性与大量伟大的理论结合在了一起。所以这很棒。最后，这本有点另类，是 Jamie Wheal 的《重获狂喜》（Recapture the Rapture），我是 Jamie 作品和文笔的忠实粉丝。这有点像三书合一：开头探讨了元危机（meta-crisis）和我们在这个世界上看到的许多疯狂现象；第二章与我们今天谈论的内容密切相关，他称之为“享乐工程”（Hedonic Engineering），基本上是转变意识状态的练习；第三章是“伦理化的邪教建立”，我就点到为止。

---

### [01:06:22] [Lenny]

**English:**
Do you have a favorite recent movie or TV show you really enjoyed?

**中文翻译:**
你最近有什么非常喜欢的电影或电视节目吗？

---

### [01:06:28] [Jonny Miller]

**English:**
My wife and I love animations and we saw Kubo and the Two Strings recently, which was fantastic. Just so, so great. That and also Wolf Walkers, which was an Apple TV series. Yeah, those have been my two favorite movies I've seen recently.

**中文翻译:**
我和妻子都喜欢动画片，我们最近看了《魔弦传说》（Kubo and the Two Strings），非常精彩。简直太棒了。还有《狼行者》（Wolf Walkers），那是 Apple TV 的系列。是的，那是最近我最喜欢的两部电影。

---

### [01:06:46] [Lenny]

**English:**
If you like animated content, check out the Scavengers Reign on HBO. I've mentioned it on this podcast before, but it's incredible. It's a TV show on HBO. So I usually ask, do you have a favorite question you like to ask candidates you're interviewing? But I know you coach people, so to kind of turn this question a little bit around, do you have a favorite question you like to ask executive coaching clients that you work with?

**中文翻译:**
如果你喜欢动画内容，去看看 HBO 的《拾荒者统治》（Scavengers Reign）。我之前在播客里提到过，它非常不可思议。那是 HBO 的一部剧。我通常会问，你面试候选人时最喜欢问什么问题？但我知道你主要做教练工作，所以把这个问题转一下：你最喜欢问你的高管教练客户什么问题？

---

### [01:07:08] [Jonny Miller]

**English:**
I stole this question from a guy Jerry Colonna who's here in Boulder, and the question is amazing. It is so good. It's basically, how are you complicit in creating the conditions that you say you don't want? And so the word complicit there is key because it's not saying in what ways is it your fault, but it's like in what ways were you complicit in creating the conditions for anxiety, for building up emotional debt? And just the question kind of opens up the door to ways in which you are an active participant in creating these challenges in your life. And it's a really rich journal question or a question to explore with a friend, co-founder colleague.

**中文翻译:**
我从博尔德的一位叫 Jerry Colonna 的人那里偷了这个问题，这个问题太棒了。它基本上是：你是如何“共谋”创造了那些你说你并不想要的条件的？这里的“共谋”（complicit）一词是关键，因为它不是在问这在哪些方面是你的错，而是在问：你在哪些方面参与创造了焦虑的条件，或者积累了情感债？这个问题开启了一扇门，让你看到自己是如何积极参与并创造了生活中的这些挑战的。这是一个非常丰富的日记问题，或者是一个可以与朋友、联合创始人或同事探讨的问题。

---

### [01:07:53] [Lenny]

**English:**
I remember him sharing that on the Tim Ferriss podcast many years ago and it stuck with me and I often think of it, but I never am complicit of anything that goes wrong. It's never my fault. He has nothing on me. Just kidding.

**中文翻译:**
我记得他多年前在 Tim Ferriss 的播客上分享过这个，我一直记着，也经常思考。但我从来没有“共谋”过任何出错的事情，那从来不是我的错。他难不倒我。开个玩笑。

---

### [01:08:06] [Jonny Miller]

**English:**
Excellent.

**中文翻译:**
太棒了。

---

### [01:08:08] [Lenny]

**English:**
Do you have a favorite product you've recently discovered that you really like?

**中文翻译:**
你最近有没有发现什么非常喜欢的个人产品？

---

### [01:08:11] [Jonny Miller]

**English:**
One is these blue blocking glasses. These are raw optics, blue blocker glasses. They block out a hundred percent of blue light and they are a lifesaver if I'm ever going out of the house basically after dark, I'll wear these to drive. I'll wear these to even dinners with friends sometimes. And it basically means that I'm able to then sleep well that evening. So that's one.
(01:08:38):
And then the other thing I'll briefly share, this came through the other day, you mentioned the vagus nerve earlier and that device, I have three devices here that are all vagus nerve stimulation devices. This one is called Neuro Sim. This one I believe is Pulsetto, and I think this is a Apollo Strap. I haven't used them that much yet, but they basically work by sending low level electrical stimulation directly to your vagus nerve. So this clips on your ear because the vagus nerve goes through the right side of the neck. Same with Pulsetto. And I'm really curious to compare the effect of these versus say breathwork, humming, the other body-based practices. Obviously, you can do both at the same time, but I am just interested in playing. So I wouldn't recommend them yet, but I think it's interesting that they exist.

**中文翻译:**
一个是这种防蓝光眼镜。这是 Raw Optics 的防蓝光镜。它们能阻挡 100% 的蓝光，如果我天黑后出门，它们简直是救星。我会戴着它们开车，甚至有时戴着它们和朋友吃晚饭。这基本上意味着我当晚能睡个好觉。这是其一。
(01:08:38):
另一件事我简单分享一下，这是前几天刚到的。你之前提到了迷走神经和那个设备，我这里有三个设备，都是迷走神经刺激设备。这个叫 Neuro Sim，这个我想是 Pulsetto，这个是 Apollo Strap。我还没怎么用过，但它们的工作原理基本上是向你的迷走神经发送低水平的电刺激。这个夹在耳朵上，因为迷走神经经过脖子右侧。Pulsetto 也是。我很好奇将这些设备的效果与呼吸法、哼鸣或其他基于身体的练习进行对比。显然，你可以同时进行，但我只是对尝试这些感兴趣。所以我现在还不推荐它们，但我觉得它们的存在很有趣。

---

### [01:09:29] [Lenny]

**English:**
How cool would that be? We just put these things on, we don't have to do anything else. We just get up, slap on our device and life is amazing. Don't have to meditate, don't have to breathe in a different way. I'm going to need to do this while I'm on the podcast just wear all these devices, see how that goes. Awesome. Well, I guess somehow report back to us how these go because that feels really great. Next question, do you have a favorite life motto that you often come back to share with friends, either in work or in life?

**中文翻译:**
那该多酷啊？我们只要戴上这些东西，就不用做别的了。起床，戴上设备，生活就变得美妙。不用冥想，不用换种方式呼吸。我录播客时得试试，把这些设备全戴上，看看效果如何。太棒了。我想请你以后反馈一下效果，因为这听起来很棒。下一个问题：你有没有什么经常向朋友分享的人生格言，无论是在工作中还是生活中？

---

### [01:10:00] [Jonny Miller]

**English:**
State over story would be one which we've touched on.

**中文翻译:**
“状态重于故事”是我们提到过的一个。

---

### [01:10:02] [Lenny]

**English:**
State over story.

**中文翻译:**
状态重于故事。

---

### [01:10:04] [Jonny Miller]

**English:**
And then I think the other one, which I think about often is I like to say, "Make generous assumptions." And by that I mean in any situation, what is the most generous story that I can tell of this person, of this situation? Not kind of naively fabricating something, but usually there's a spectrum of I can assume that they're a bad person and they did this thing out of spite, or maybe they had a bad day, maybe they have a lot of emotional debt. There's there's many stories that can be told. And I usually try to have a practice of telling the most generous story that I can.

**中文翻译:**
另一个我经常思考的是，我喜欢说：“做慷慨的假设。”我的意思是，在任何情况下，关于这个人或这件事，我能讲出的最慷慨的故事是什么？不是天真地捏造事实，而是通常存在一个光谱：我可以假设他们是个坏人，出于恶意做了这件事；或者也许他们今天过得很糟，也许他们背负着沉重的情感债。有很多种故事可以讲。我通常尝试练习去讲述我所能讲出的最慷慨的故事。

---

### [01:10:47] [Lenny]

**English:**
I like that a lot. Another way of describing that is just assume good intentions, which I often think about.

**中文翻译:**
我很喜欢这个。另一种描述方式就是“假设对方是好意”，我也经常思考这一点。

---

### [01:10:54] [Lenny]

**English:**
Final question. You seem extremely calm always, and very centered and stable. What still gets you rilled up and unsettled, and what do you do when that happens?

**中文翻译:**
最后一个问题。你看起来总是非常冷静、专注且稳定。还有什么事情会让你感到愤怒或不安？当那种情况发生时，你会怎么做？

---

### [01:11:07] [Jonny Miller]

**English:**
Well, I was nervous before this podcast, so I did some breathing practices and some stretching and some humming before jumping on here. I still at times notice ways in which I'm conflict avoidant. I've been working on it actively for a while, but there's a part of me that can sometimes avoid conflict. And so I've actually noticed how there's a relationship between that and having a healthy relationship to anger. So basically giving myself permission to express frustration, not at someone, but just allow it to be there. And then from that place set better boundaries with my time with what I'm doing, saying no to certain things. I think that's the practice that's most alive for me right now.

**中文翻译:**
嗯，录这期播客前我也很紧张，所以我在开始前做了一些呼吸练习、拉伸和哼鸣。我有时仍会注意到自己有逃避冲突的倾向。我已经积极处理这个问题一段时间了，但我内心的一部分有时仍会逃避冲突。我实际上注意到，这与建立健康的愤怒关系之间存在某种联系。所以基本上，我允许自己表达沮丧——不是针对某人，而是允许这种情绪存在。然后从那个状态出发，为我的时间和正在做的事情设定更好的界限，对某些事情说“不”。我想这是目前对我来说最有生命力的练习。

---

### [01:11:53] [Lenny]

**English:**
Jonny, you are awesome. Two final questions. Where can folks find you online and explore the things that you offer? I think you teach a course, whatever else you offer, talk about that and then how can listeners be useful to you?

**中文翻译:**
Jonny，你太棒了。最后两个问题。大家可以在哪里找到你并了解你提供的服务？我想你有一门课程，还有其他服务，谈谈这些。以及听众可以如何帮到你？

---

### [01:12:06] [Jonny Miller]

**English:**
Yeah, well, this has been so much fun. I am very active on Twitter or X. My handle is Jonny Miller. It's J-O-N-N-Y-M-1-L-L-E-R. And yeah, if this was interesting or listeners would like to dive deeper, I teach a course. Our next cohort is running in the spring, the end of March. Applications are now open, and the website is nsmastery.com/lenny. I've created a custom page and there's a $250 juicy discount for listeners if they want to sign up.

**中文翻译:**
好的，这真的很有趣。我在 Twitter（现为 X）上非常活跃。我的账号是 Jonny Miller，拼写是 J-O-N-N-Y-M-1-L-L-E-R。是的，如果听众觉得这很有趣或想深入了解，我有一门课程。我们的下一期将在春季（三月底）开课，现在已经开放申请。网站是 nsmastery.com/lenny。我创建了一个专属页面，如果听众想报名，可以享受 250 美元的丰厚折扣。

---

### [01:12:39] [Lenny]

**English:**
I got to sign up for this myself. I didn't know you're going to do that. That's awesome. And NS Mastery stands for Nervous System Mastery.

**中文翻译:**
我自己也得报名。我不知道你会提供这个，太棒了。NS Mastery 代表“神经系统掌控力”。

---

### [01:12:47] [Jonny Miller]

**English:**
Exactly.

**中文翻译:**
没错。

---

### [01:12:48] [Lenny]

**English:**
Amazing. Anything else? And then the second question of how listeners can be useful to you.

**中文翻译:**
太棒了。还有别的吗？还有第二个问题，听众可以如何帮到你？

---

### [01:12:52] [Jonny Miller]

**English:**
Well, firstly, if any of this resonates, I'd love to hear from you on Twitter or email me as well. I can pass over my email and I would just love it if you experiment with this stuff. I love this idea of just being a scientist of life. So if anything that we've talked about resonates or any of the practices you want to try, just go out and try it and see how it feels and then tell me about it. That would be the greatest gift I think.

**中文翻译:**
首先，如果这些内容引起了共鸣，我很想在 Twitter 上听到你的反馈，或者给我发邮件。我可以留下我的邮箱。我非常希望大家能亲自实验这些东西。我喜欢“做生活的科学家”这个想法。所以，如果我们谈论的任何内容引起了共鸣，或者你想尝试任何练习，就去尝试吧，看看感觉如何，然后告诉我。我想那将是最好的礼物。

---

### [01:13:23] [Lenny]

**English:**
And the best way to tell you about it is tweet at you or is there something else?

**中文翻译:**
告诉你最好的方式是在 Twitter 上艾特你，还是有别的方式？

---

### [01:13:26] [Jonny Miller]

**English:**
Tweet at me or my email is jonny@curioushumans.com. So feel free to email me as well.

**中文翻译:**
在 Twitter 上艾特我，或者发邮件到 jonny@curioushumans.com。随时欢迎给我发邮件。

---

### [01:13:32] [Lenny]

**English:**
All right, I'm going to use all these things. Jonny, thank you so much for being here. You're awesome. I am excited for the show notes we're going to have to give people actual tools to use to become less anxious and nervous in their work and life. Thank you again for being here.

**中文翻译:**
好的，我会尝试所有这些方法的。Jonny，非常感谢你能来。你太棒了。我很期待在节目介绍中为人们提供实际的工具，帮助他们在工作和生活中减轻焦虑和紧张。再次感谢你的到来。

---

### [01:13:46] [Jonny Miller]

**English:**
Amazing. Thanks so much, Lenny. This was super fun.

**中文翻译:**
太棒了。非常感谢，Lenny。这超级有趣。

---

### [01:13:48] [Lenny]

**English:**
Same for me. Bye everyone.

**中文翻译:**
我也是。大家再见。

---

### [01:13:51] [Lenny]

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
非常感谢您的收听。如果您觉得本期节目有价值，可以在 Apple Podcasts、Spotify 或您喜欢的播客应用中订阅本节目。此外，请考虑给我们评分或留下评论，这能真正帮助其他听众发现本播客。您可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。