# Josh Miller - 双语对照

以下是 Lenny's Podcast 与 The Browser Company 首席执行官 Josh Miller 访谈的完整中英双语对照文档。

---

### [00:00:00] Josh Miller

**English:**
We want people that show up to our company with some fire in their belly, something that they are out to do. And for each person it's a little bit different. For some people it may be UI Craft details. For other people, it may be achieving double the performance with a quarter of the engineering headcount. Everyone has something, but they show up with this heartfelt intensity. And I think even relative to everything else, I'm going to say, that's it. If you have a team that has heartfelt intensity and is there for a purpose and something to prove, you get it. You give them a very exciting, ambitious product and get out of their way and they will do remarkable work.

**中文翻译:**
我们希望加入公司的人肚子里都憋着一股劲，有某种他们一心想要实现的目标。对每个人来说，这种目标可能略有不同。对某些人来说，可能是 UI 工艺的细节；对另一些人来说，可能是用四分之一的工程师人力实现双倍的性能。每个人都有自己的追求，但他们都带着这种“满腔热忱”（heartfelt intensity）来到这里。我认为，即便相对于其他所有因素，我还是要说，这就是核心。如果你拥有一支充满热忱、目标明确且想要证明某些东西的团队，你就赢了。你只需给他们一个非常令人兴奋、极具野心的产品，然后别挡他们的路，他们就会做出卓越的工作。

---

### [00:00:36] Lenny

**English:**
Welcome to Lenny's podcast, where I interview world-class product leaders and growth experts to learn from their hard one experiences building and growing today's most successful products. Today my guest is Josh Miller. Josh is the CEO and co-founder of a company called The Browser Company, which makes a product called Arc, which has quickly become my default web browser. I fell in love with this product as soon as I started using it and wanted to get a glimpse into how Josh and his team approached the craft of product. There's this cohort of companies like the Browser Company, [inaudible 00:01:09], a few others that are just laser focused on building the best possible user experience, almost above all else. And I wanted to spend some time exploring this trend with Josh. We cover how he thinks about prioritization, team building, storytelling, company values, metrics, shipping, building in public so much more.

**中文翻译:**
欢迎来到 Lenny 的播客。在这里，我会采访世界级的产品领导者和增长专家，学习他们在构建和发展当今最成功产品过程中积累的宝贵经验。今天的嘉宾是 Josh Miller。Josh 是 The Browser Company 的首席执行官兼联合创始人，他们开发了一款名为 Arc 的产品，它迅速成为了我的默认浏览器。我一用上这款产品就爱上了它，所以想深入了解 Josh 和他的团队是如何打磨产品工艺的。现在有一批像 The Browser Company 这样的公司，它们几乎把构建最佳用户体验放在首位。我想和 Josh 一起探讨这一趋势。我们会聊到他如何思考优先级、团队建设、讲故事、公司价值观、指标、发布、公开构建（building in public）等等。

---

**English:**
(00:01:28): Josh is such an earnest, genuine and humble human, and it was such a pleasure getting to learn from him. And, just to be clear, I'm not an investor in the Browser Company and I barely knew anything about the company before I chatted with Josh. So, I'm just a fan. And as a special surprise, Arc is normally invite only. But if you're listening to this now, check the show notes for a special link that'll get you right in to use the browser, if you want to play with it yourself. With that, I bring you Josh Miller after a short word from our select sponsors.

**中文翻译:**
(00:01:28): Josh 是一个非常诚恳、真实且谦逊的人，能向他学习是我的荣幸。另外说明一下，我不是 The Browser Company 的投资者，在和 Josh 聊天之前我对这家公司几乎一无所知。所以，我纯粹是个粉丝。作为一个特别惊喜，Arc 通常是邀请制的，但如果你现在正在收听，请查看节目简介中的特殊链接，它可以让你直接进入并使用这款浏览器。在听完赞助商的简短介绍后，我们将请出 Josh Miller。

---

### [00:02:01] Speaker 3 (Sponsor)

**English:**
This episode is brought to you by Rytr. How much hype have you been hearing about generative AI? So much, but how do you take it from a shiny toy to an actual business tool that helps you do your actual job? Rytr is an enterprise-grade generative AI platform built specifically for the needs of businesses, and already widely deployed at world-class brands like Uber, Spotify, HubSpot and UiPath. With Rytr, you can break through content bottlenecks across your organization from marketing webpages to sales emails, in-product messages to creating high-quality on-brand content at scale. And unlike other AI applications, Rytr's training happens securely on your data and your style and brand guidelines. So you provide specific to your organization.

**中文翻译:**
本集节目由 Rytr 赞助。你听到了多少关于生成式 AI 的炒作？非常多，但你如何将它从一个闪亮的玩具变成一个能帮你完成实际工作的业务工具呢？Rytr 是一个专门为企业需求构建的企业级生成式 AI 平台，已被 Uber、Spotify、HubSpot 和 UiPath 等世界级品牌广泛部署。借助 Rytr，你可以突破组织内的内容瓶颈，从营销网页到销售邮件，从产品内消息到大规模创建高质量、符合品牌调性的内容。与其他 AI 应用不同，Rytr 的训练是基于你的数据、风格和品牌指南安全进行的。因此，你提供的是针对你组织的特定内容。

---

**English:**
(00:02:45): The result is that you get consistent content in your brand voice at scale. Get AI that your people will love. For a limited time. Listeners to Lenny's podcast can get 20% off if they go to rytr.com/lenny. That's rytr.com/lenny. This episode is brought to you by Dovetail, the customer insights platform for teams, that gets you from data to insights fast, no matter the method. There's so much customer data to get through from user interviews to NPS, sales calls, usability tests, support tickets, app reviews. It's a lot. And you know that if you're building something hidden in that data are the insights that will lead you to building better products.

**中文翻译:**
(00:02:45): 结果就是你可以大规模获得符合品牌语调的一致内容。让你的员工爱上 AI。在限定时间内，Lenny 播客的听众访问 rytr.com/lenny 即可享受 20% 的折扣。本集节目还由 Dovetail 赞助，这是一个为团队打造的客户洞察平台，无论采用何种方法，都能让你快速从数据中获得洞察。从用户访谈到 NPS、销售电话、可用性测试、支持工单、应用评论，有太多的客户数据需要处理。你知道，如果你正在构建某些东西，隐藏在这些数据中的洞察将引导你构建更好的产品。

---

**English:**
(00:03:25): And that's where Dovetail can help. Dovetail allows you to quickly analyze customer data from any source and transform it into evidence-based insights that your whole team can access. If you're a product manager who needs insights to motivate your team, a designer validating your next big feature, or a researcher who needs to analyze fast, Dovetail is the collaborative insights platform your whole team can use. Go to dovetailapp.com/lenny to get started today for free. That's dovetailapp.com/lenny.

**中文翻译:**
(00:03:25): 这正是 Dovetail 的用武之地。Dovetail 允许你快速分析来自任何渠道的客户数据，并将其转化为整个团队都可以访问的、基于证据的洞察。如果你是需要洞察来激励团队的产品经理，或是正在验证下一个重大功能的设计师，亦或是需要快速分析的研究员，Dovetail 都是你整个团队可以使用的协作洞察平台。立即访问 dovetailapp.com/lenny 免费开始使用。

---

### [00:03:57] Lenny

**English:**
Josh, welcome to the podcast.

**中文翻译:**
Josh，欢迎来到播客。

---

### [00:03:59] Josh Miller

**English:**
Thank you so much for having me, Lenny.

**中文翻译:**
非常感谢你邀请我，Lenny。

---

### [00:04:00] Lenny

**English:**
It's absolutely my pleasure. You are the CEO and co-founder of The Browser Company, which builds a product called Arc. Can you just talk about what is The Browser Company? What is Arc? And then whatever you can share about just like the scale of Arc at this point. That'd be really interesting to hear.

**中文翻译:**
这是我的荣幸。你是 The Browser Company 的首席执行官兼联合创始人，你们开发了一款名为 Arc 的产品。你能聊聊 The Browser Company 是做什么的吗？Arc 是什么？以及目前 Arc 的规模如何？听听这些会很有趣。

---

### [00:04:15] Josh Miller

**English:**
Sure. I hope you don't mind me doing this. I'm curious, I hear that you may, may or may not use Arc? How would you describe Arc to somebody?

**中文翻译:**
当然可以。希望你不介意我反问一下。我很好奇，听说你可能在使用 Arc？你会如何向别人描述 Arc？

---

### [00:04:25] Lenny

**English:**
The simple explanation is it's just the best web browser that I've used. So, to me it's a browser. I know that you have a bigger vision than that, but that's the way I see it as a layperson who hasn't seen the full vision.

**中文翻译:**
简单的解释就是，它是我用过的最好的网页浏览器。所以对我来说，它就是一个浏览器。我知道你有更宏大的愿景，但作为一个还没看到全貌的普通用户，我就是这么看的。

---

### [00:04:38] Josh Miller

**English:**
Awesome. I think we can go home now. That's great. That's awesome.

**中文翻译:**
太棒了。我想我们可以收工回家了。这评价太好了。

---

### [00:04:39] Lenny

**English:**
There we go.

**中文翻译:**
哈哈，就是这样。

---

### [00:04:39] Josh Miller

**English:**
No. To be totally honest with you and your listeners, we have a really hard time describing Arc, which is something I'm not proud of. But it is, objectively, a replacement for your default web browser. And people who try it seem to really love it, and most people seem to have a hard time using the internet in the old way. So, that may sound like I'm being coy, but we have work shopped many a one-liners and the words have escaped us so far. So, to be honest, it is on our to-do list to get sharper about that.

**中文翻译:**
不，对你和听众说实话，我们其实很难描述 Arc，这并不是什么值得骄傲的事。但客观地说，它是你默认浏览器的替代品。尝试过它的人似乎真的很喜欢它，而且大多数人似乎很难再回到过去那种使用互联网的方式了。所以，这听起来可能像是在卖关子，但我们确实推敲过很多宣传语，却一直没找到最精准的词。老实说，让描述变得更犀利已经在我们的待办事项清单上了。

---

**English:**
(00:05:15): And then in terms of our scale, since we have a lot of product managers listening, I'll give you the PM answer to that question, which is, we really focus on one key metric as it relates to tracking our growth or how we are doing. We call it D5, D7. A lot of other companies call it L5, L7. But the human explanation for that is how many people turn to Arc at least five days a week? That is all we obsess over from a metrics perspective, because for us it captures retention, engagement, and growth in a single metric. You can't game it. Right? So from retention perspective, it's not just opening it accidentally once a week. You need to open a tab on a day in order to count as an active for a day.

**中文翻译:**
(00:05:15): 至于我们的规模，既然有很多产品经理在听，我给出一个“产品经理式”的回答：在追踪增长或表现时，我们只关注一个核心指标。我们称之为 D5/D7（很多公司称之为 L5/L7）。通俗的解释就是：有多少人每周至少有五天会使用 Arc？这是我们在指标方面唯一痴迷的东西，因为它在一个指标中同时捕捉了留存、参与度和增长。你没法作弊，对吧？从留存的角度看，它不只是每周偶然打开一次。你必须在某一天打开一个标签页，才算作当天的活跃用户。

---

**English:**
(00:06:01): But so it tracks retention. It tracks engagement because five days a week is no joke. There are very few apps or pieces of software you actively use five days a week. And then, obviously, it tracks growth, because of we track the count. So that is what we track. And then we also don't obsess over absolute numbers, because if we're successful, if you zoom out and out and out, any point in time will be inconsequential and small. So, what we really look is growth rate week over week. So, relative to last week, what is our growth rate? And for the past eight months or so, we've been growing over 10% every single week. So very, very thrilled with that. Do not think that will continue If anyone is listening. I would be shocked if we continue like that for another eight months. But, yeah. We obsess over how many humans use Arc five out of seven days a week. And we really want that number to grow as fast as possible every single week.

**中文翻译:**
(00:06:01): 所以它追踪留存；它追踪参与度，因为每周用五天可不是开玩笑的，很少有应用或软件能让你每周主动使用五天；显然它也追踪增长，因为我们统计的是人数。这就是我们追踪的内容。此外，我们不痴迷于绝对数字，因为如果我们成功了，当你把时间轴拉得足够长，任何单一时间点的数字都是微不足道的。所以我们真正看的是周环比增长率。相对于上周，我们的增长率是多少？在过去的八个月左右，我们每周的增长率都超过了 10%。我们对此非常兴奋。我不认为这会一直持续下去，如果有人在听的话，如果再持续八个月我会感到震惊。但是，是的，我们痴迷于有多少人每周 7 天里有 5 天使用 Arc，我们希望这个数字每周都能尽可能快地增长。

---

### [00:06:54] Lenny

**English:**
I love that we're already talking about metrics and retention. This is off to a good start.

**中文翻译:**
我喜欢我们已经开始聊指标和留存了。这是一个很好的开始。

---

### [00:06:57] Josh Miller

**English:**
You got to know your audience. Lenny.

**中文翻译:**
你得了解你的听众，Lenny。

---

### [00:06:59] Lenny

**English:**
We're going to talk about just how public you're about everything. But would you be for sharing your retention actual numbers? The D5 and D7 you just mentioned?

**中文翻译:**
我们会聊到你们在所有事情上是多么公开。但你愿意分享实际的留存数据吗？就是你刚才提到的 D5 和 D7？

---

### [00:07:07] Josh Miller

**English:**
Yes. With the asterisk that I didn't prepare for that. So, Rebecca correct me on Twitter after this, if this is wrong. So once again, we don't look at DAU retention. We don't look at weekly active-user retention. We really just look at D5 D7 retention. Depending on the cohort, that's somewhere between low to mid-30s and low 40s. So really, really fantastic. Again, not going to continue. If there is anyone on this call that is going to check this in a year, it will be lower I'm sure. But so far, we're really thrilled with it.

**中文翻译:**
可以，但有个前提是我没提前准备这个数据。如果我说错了，Rebecca 之后可以在 Twitter 上纠正我。再说一次，我们不看 DAU（日活）留存，也不看周活留存，我们只看 D5/D7 留存。根据不同的用户群组（cohort），这个比例大约在 30% 中低段到 40% 低段之间。这真的非常棒。再次强调，这不会一直持续。如果有人一年后再来检查，我确信它会变低。但到目前为止，我们对此非常满意。

---

**English:**
(00:07:37): And most importantly, in the same way, we don't look at absolute gross growth number, we don't look at retention in this moment. We look at, is it improving cohort by cohort? And so, what I think I am most proud of is that, if you go back a year, by all means our retention curve, we were really proud of it. And I think one of the best in our category of software. But, what I'm really proud of is, 12 months later we've been inching it up and up and up, despite getting further away from the earliest most passionate adopters. So, our retention curve's going up and up a little bit, which is-

**中文翻译:**
(00:07:37): 最重要的是，就像我们不看绝对增长总数一样，我们也不只看当下的留存。我们看的是它是否在逐个群组地改进？我最自豪的是，如果你回到一年前，我们的留存曲线已经让我们很骄傲了，我认为是同类软件中最好的之一。但更让我自豪的是，12 个月后，尽管我们接触的用户已经不再是最初那批最狂热的早期采用者，我们的留存曲线仍在一点点往上爬。

---

### [00:08:11] Lenny

**English:**
All right. All right. If you haven't shared that, that'd be cool to share on Twitter someday. I'm a retained user.

**中文翻译:**
好极了。如果你还没分享过，哪天在 Twitter 上分享一下会很酷。我就是一个被留存的用户。

---

### [00:08:15] Josh Miller

**English:**
I'm going to wait and you can share this clip. We'll share this clip.

**中文翻译:**
我会等着你分享这段剪辑。我们会分享这段剪辑的。

---

### [00:08:18] Lenny

**English:**
Okay. Okay. I love it. We're just ready. We got the marketing strategy coming together. So, I told you this ahead of the chat, but the reason I wanted to have you on this podcast, even though, as folks may know, and as I've told you, I try to actually avoid founders and CEOs on this podcast to give other folks a platform who aren't often invited on podcasts. But the reason I wanted to have you on is, I just feel like Arc is a remarkable product. It blew me away the first time I used it. I don't know if you saw it, I tweeted as soon as I signed up? I had to share how awesome it was. I was like-

**中文翻译:**
好，太棒了。我们的营销策略已经成型了。我在聊天前告诉过你，我邀请你来播客的原因是——尽管大家可能知道，我也告诉过你，我其实尽量避免邀请创始人和 CEO，是为了给那些不常被邀请的人提供平台——但我一定要邀请你，是因为我觉得 Arc 是一款非凡的产品。我第一次用它就被震撼了。不知道你看到没，我一注册就发了推特？我必须分享它有多棒。

---

### [00:08:47] Josh Miller

**English:**
Of course I saw it. It made my day.

**中文翻译:**
我当然看到了，那让我开心了一整天。

---

### [00:08:48] Lenny

**English:**
Okay. Okay, great. And, also as an outside observer, it just feels like you're building remarkable culture and team that's really unique. And, so I just want to selfishly learn from how you think about product and team building and all the things that go into it. So yeah.

**中文翻译:**
好，太好了。而且作为一个外部观察者，我觉得你正在建立一种非常独特且卓越的文化和团队。所以我想自私地向你学习，了解你是如何思考产品、团队建设以及其中的方方面面的。

---

### [00:09:03] Josh Miller

**English:**
Thanks for saying that, Lenny. What a cool way to kick off an interview.

**中文翻译:**
谢谢你这么说，Lenny。这个开场白太酷了。

---

### [00:09:06] Lenny

**English:**
Absolutely. First question I have along those lines is, you mentioned at some point that your product building philosophy is a reaction to the traditional Silicon Valley way of building product. I'm curious to hear what led you down that road? Why did you feel like you had to react to it? And then how would you just describe your product building philosophy at The Browser Company?

**中文翻译:**
没问题。我的第一个问题是，你曾在某个地方提到，你的产品构建哲学是对传统硅谷产品构建方式的一种“反作用力”（reaction）。我很想听听是什么让你走上了这条路？为什么你觉得必须反其道而行之？你会如何描述 The Browser Company 的产品构建哲学？

---

### [00:09:27] Josh Miller

**English:**
I'll share this caveat once and never again in this interview. But I want anyone listening to know, I'm someone who doesn't believe there is a single right way to do things. So, what I'm sharing today is truly just what we have found works for us in this moment for what we are doing. But, I remember when I was earlier in my career, I'd listen to podcasts like this and take it as dogma, because there are these people that had done it and I respected what they'd built. So, if any of this sounds like "better than thou," it's not intended to. This is just what we found works for us and what we care about. [inaudible 00:09:59].

**中文翻译:**
在这个访谈中，我只说一次这个免责声明：我不相信做事情只有唯一正确的方法。所以我今天分享的，纯粹是我们发现目前对我们所做的事情有效的方法。我记得职业生涯早期听这类播客时，会把内容当成教条，因为那些人成功过，我尊重他们的成就。所以，如果接下来的话听起来有点“自命不凡”，那绝非本意。这只是我们发现适合自己的方式。

---

**English:**
(00:09:58): Okay. So early in my career started a company also with Hursh, my current co-founder and CTO. We were fortunate enough to have that company acquired or acqui-hired by Facebook and spent a number of years working at Facebook. And remarkable organization, probably the best executing I've ever seen at that period of time. And, by the way, I'd never been a PM before, so I'm not complimenting myself, I was just learning for the first time. But what struck me at Facebook in call it 2014, and I've seen through to this day, is Silicon Valley, at least the most modern version of Silicon Valley, has this obsession with graphs, and has this obsession with numbers and metrics.

**中文翻译:**
(00:09:58): 好的。职业生涯早期，我和现在的联合创始人兼 CTO Hursh 创办了一家公司。我们很幸运，那家公司被 Facebook 收购（或人才收购）了，之后我在 Facebook 工作了几年。那是一个非凡的组织，可能是我见过的那个时期执行力最强的。顺便说一下，我以前从未做过 PM（产品经理），所以我不是在夸自己，我当时只是在学习。但在 2014 年左右的 Facebook，以及直到今天我所看到的，硅谷——至少是现代版的硅谷——对图表、数字和指标有着近乎痴迷的执着。

---

**English:**
(00:10:36): I mean, you saw me in the previous answer, I'm talking about D5, D7. What's a D5, D7? And, it is an incredibly effective way to achieve certain outcomes, to focus on numbers, because it's very quantitative, it's objective. You can see the graph go up or go down, or stay flat depending on what you want. But what we've found is that optimizing for metrics leaves a lot on the table and it misses a lot. And so, what we do at The Browser Company is we talk about optimizing feelings. How do we want to make someone feel on the other end of our software? Do we want to make them feel joy? Do we want to make them feel fast? Do we want to make them feel organized? Do we want to make them feel focused? What is it the feeling we are trying to evoke in whatever we're doing on a specific project, or a specific feature, or a specific piece of storytelling content?

**中文翻译:**
(00:10:36): 我是说，你在我之前的回答中也看到了，我在谈论 D5/D7。什么是 D5/D7？专注于数字确实是实现某些结果的一种极其有效的方式，因为它非常量化、客观。你可以看到图表上升、下降或持平。但我们发现，仅仅为了指标而优化会遗漏很多东西。因此，在 The Browser Company，我们谈论的是“优化感受”（optimizing feelings）。我们想让软件另一端的人有什么感觉？是快乐吗？是觉得快吗？是觉得井井有条吗？还是觉得专注？无论我们在做一个特定项目、功能还是内容，我们试图唤起的是什么样的感受？

---

**English:**
(00:11:31): And I can imagine what's going through the heads of your listeners right now, which is probably a number of things. But among others, that sounds really damn romantic. If they're like, "Okay. You optimizing for feelings." But if you allow me, I would posit that actually this modern way of optimizing for numbers and graphs, especially for what we all do every day, which is make things and put in the world, is what's fairly odd. Because, if you just to yourself daydream about, what are your favorite products or product companies and brands, while it may sound cliche for me, Nike. Nike was one of the first companies that at a very deep level resonate with me as a child. Disney? Disney, same thing. Apple? Before I was a professional in an industry, these were the brands and the products that they made that really made me love something that was ostensibly a commercial product I could buy.

**中文翻译:**
(00:11:31): 我能想象听众现在在想什么，其中之一可能是：“这听起来也太浪漫主义了吧，居然为了感受而优化。”但如果你允许我反驳，我会认为，这种现代的、只为了数字和图表而优化的方式，对于我们每天所做的事情（创造东西并推向世界）来说，才是相当奇怪的。因为，如果你白日梦一下你最喜欢的产品或品牌，对我来说，虽然听起来很老套，但比如 Nike。Nike 是第一批在我孩提时代就产生深度共鸣的公司之一。迪士尼也是一样。还有苹果。在我进入这个行业之前，正是这些品牌和产品让我真正爱上了一些表面上只是我可以买到的商业产品。

---

**English:**
(00:12:29): What do you think Walt Disney was optimizing for when he was crafting Disneyland? What do you think Phil Knight was thinking about when he made that first version of the Nike running shoe? What do you think Steve Jobs was imagining and daydreaming about when thinking about the iPhone or the Macintosh? By all means, numbers are a fantastic way to be honest with yourself about whether or not you are achieving what you aim to do. But at the moment of creation, at the stage as product people, wondering what should we do, and why, and how? We think it's much more important for us to think about the human, the person at the other end, and how we really want to make them feel.

**中文翻译:**
(00:12:29): 你觉得华特·迪士尼在打造迪士尼乐园时是在优化什么？你觉得菲尔·奈特在做第一版 Nike 跑鞋时在想什么？你觉得史蒂夫·乔布斯在构思 iPhone 或 Macintosh 时在憧憬什么？当然，数字是诚实评估你是否达到目标的绝佳方式。但在创作的那一刻，作为产品人，在思考“我们该做什么、为什么做、怎么做”的阶段，我们认为思考另一端的人以及我们想让他们产生什么样的感受，要重要得多。

---

**English:**
(00:13:10): I think one tangible example of that is when I was at Facebook, I joined in the midst of Snapchat's ascendancy. And, there was a lot of feelings about how are we doing, should we be worried? And the way that we would have that conversation would be, how many times per week do people share on Facebook? Do they post something? We even had an acronym OBPS. It's like seared into my memory. What is OBPS? And how is it trending over time? Well, I think we should have been asking, and what we at least would ask at The Browser Company and our way of product development is, "Do we think people feel closer to their friends and family?" Or something of that nature?

**中文翻译:**
(00:13:10): 一个具体的例子是，我在 Facebook 时正值 Snapchat 崛起。当时大家都在讨论：我们表现如何？该担心吗？我们讨论的方式是：人们每周在 Facebook 上分享多少次？他们发帖吗？我们甚至有一个缩写 OBPS（Original Broadcast Posts，原创广播式帖子），这深深印在我的脑海里。OBPS 是什么？随时间变化的趋势如何？但我认为我们本该问的是——至少我们在 The Browser Company 的产品开发方式中会问的是——“我们是否觉得人们感到与朋友和家人的关系更近了？”或者类似的人性化问题。

---

**English:**
(00:13:52): I think that's what Snapchat got so right. They weren't obsessing about something like, "How many people put an image into the composer and hit the plus button. And the number of times per week means success." They were thinking about something much more human and essential. And so, that is what we've [inaudible 00:14:07] The Browser Company. Don't optimize for metrics, don't optimize for graphs. Use that as a way to keep you honest, and use it as a tool in your toolkit. But fundamentally, none of us are here for that. We're there to make people feel something.

**中文翻译:**
(00:13:52): 我认为这就是 Snapchat 做得对的地方。他们没有纠结于“有多少人把图片放进编辑器并点击加号，每周点击多少次意味着成功”。他们在思考更具人性、更本质的东西。这就是我们在 The Browser Company 所做的。不要为了指标而优化，不要为了图表而优化。把它们当作保持诚实的手段，当作工具箱里的工具。但从根本上说，我们来这里不是为了数字，而是为了让人们有所感受。

---

### [00:14:19] Lenny

**English:**
I love that we're already talking about metrics and retention. This is off to a good start.

**中文翻译:**
我喜欢我们已经开始聊指标和留存了。这是一个很好的开始。

---

### [00:14:42] Lenny

**English:**
As you pointed out, I think a lot of the people are listening are like, "I love that. I wish I could do that. I want to optimize for feelings, but then I got to drive the business forward. I got goals to hit. I want to keep people accountable." I'm curious how you operationalize this approach? How do you actually implement this idea? I imagine you still have goals and metrics and you guys, you talked about retention and things like that.

**中文翻译:**
正如你所指出的，我想很多听众会觉得：“我喜欢这个想法，我也希望我能这么做。我想为感受而优化，但我还得推动业务发展，我有目标要达成，我得让大家负责任。”我很好奇你如何将这种方法“落地”（operationalize）？你如何实际执行这个想法？我猜你们肯定还是有目标和指标的，比如你刚才提到的留存率。

---

### [00:14:42] Josh Miller

**English:**
Yeah. Obviously it's difficult to do that in the abstract for another company, and it may not work for every company and every product. But, for example, one of the reasons we found this to be so effective so far is, if you pick the right feeling, it typically tracks pretty closely with the metric you care about. So, for example, we don't have a growth team and we have no semblance of growth projects. However, in many of the new features that we put out into the world, we want people to feel surprise or joy or an emotion like that. Guess what? When people feel that way, they go, "Oh, my God, what was that?" And they start telling their friends and family about it, and they start dropping a screenshot in Slack, et cetera. So, there's one example on the consumer side. I've never built traditional enterprise software selling to CIOs, et cetera. But I can imagine maybe someone in the IT department of a large enterprise wants to feel smart, or wants to feel ahead of the curve or wants to feel secure and ease at what they're doing.

**中文翻译:**
是的。显然，抽象地为另一家公司做这件事很难，而且它可能不适用于每家公司和每个产品。但举个例子，我们发现这之所以有效，是因为如果你选对了“感受”，它通常会与你关心的指标高度契合。例如，我们没有增长团队，也没有任何增长项目。然而，在我们推出的许多新功能中，我们希望人们感到惊喜、愉悦或类似的情绪。猜猜看？当人们有这种感觉时，他们会惊叹：“天哪，那是什么？”然后他们开始告诉亲友，在 Slack 里发截图等等。这是消费端的一个例子。我从未开发过卖给 CIO 的传统企业软件，但我能想象，大企业的 IT 部门人员可能想感到自己很聪明，或者想感到自己走在时代前沿，或者想在工作中感到安全和从容。

---

**English:**
(00:15:54): I think sometimes we just forget that whoever your buyer is, or whatever your business objective, at the end of the day we're a bunch of people in a bunch of rooms at the other side of these screens. And just thinking about that person, it could be a buyer, it could be a customer. But I think the truth is the answer to the question Lenny is, when I was earlier in my career, I was searching for the answers or the way to do things, the right, the wrong, the binary. I think anyone that's been doing this or anything for a while learns that it's all nuanced. It's a spectrum. It depends. Sometimes it works, sometimes it doesn't.

**中文翻译:**
(00:15:54): 我觉得有时我们只是忘了，无论你的买家是谁，无论你的业务目标是什么，归根结底，我们都是屏幕另一端、坐在房间里的一群人。只要去思考那个人——可能是买家，也可能是客户。Lenny，这个问题的真相是，在我职业生涯早期，我一直在寻找答案或做事的方法，寻找对错、非黑即白。我想任何从事这一行一段时间的人都会明白，一切都是微妙的，是一个光谱。这取决于具体情况，有时有效，有时无效。

---

**English:**
(00:16:26): But I think the true answer, Lenny, is just optimizing for metrics so purely is deeply flawed in my opinion. Optimizing for feelings so purely is flawed as well. And it depends on what you are doing, what the project is and a lot of other things. But I think the reason we come out so strongly is, I do think Silicon Valley has tended so far towards optimizing for graphs and metrics, that if we can reel it back in a little bit, at least as just one company, I think that will be good. But the truth is, it's both. We need to use all the tools we can get, but I think hopefully that's one way that people can operationalize.

**中文翻译:**
(00:16:26): 但我认为真正的答案是，Lenny，在我看来，纯粹为了指标而优化是有深度缺陷的；纯粹为了感受而优化同样也有缺陷。这取决于你在做什么、项目是什么以及许多其他因素。但我们之所以态度如此鲜明，是因为我觉得硅谷目前太倾向于优化图表和指标了，如果我们能稍微往回拉一点——至少作为一家公司来说——我认为那是好事。但事实是，两者兼顾。我们需要使用所有能用的工具，但我希望这能成为人们落地的一种方式。

---

### [00:17:05] Lenny

**English:**
I'm curious, just to poke out a little bit, how you actually implement that? So maybe as an example, you recently launched this Peek feature, where you mouse over, I think, a link and it opens up in a little browser that doesn't last. Do you put together a little spec of some sort of, "We're trying to create surprise, and maybe here's a metric we think about it." What's actual day-to-day operational approach to a new feature, in terms of feelings versus metrics?

**中文翻译:**
我很好奇，想深入探究一下，你具体是怎么执行的？举个例子，你们最近推出了 Peek 功能，鼠标悬停在链接上，它会打开一个临时的小窗口。你会写一份类似“我们试图创造惊喜，这里是我们考虑的指标”的规格说明书（spec）吗？在处理新功能时，关于“感受 vs 指标”，实际的日常操作方法是什么？

---

### [00:17:32] Josh Miller

**English:**
Yeah. The truth is I don't think we've operationalized it as formally as we should one day. And we'll probably need to one day. The lucky thing is we are a very tight group of individuals that have now worked together for a long time. So not so formal as there's a PRD at the top of it, we list out the emotions. It's much more, with that project, get Ben in a room and whoever else is working on it and say, "All right. So here's what we're trying to do for people. Here's the problem we're trying to solve or the way we fit in their day. And in that moment people want to feel very light and airy."

**中文翻译:**
(00:17:32): 事实是，我不认为我们已经像未来某天可能需要的那样正式地将其落地了。幸运的是，我们是一个非常紧密的团队，已经合作很久了。所以没有那么正式，不会在 PRD（产品需求文档）顶部列出情绪。更多的是，针对那个项目，把 Ben 和其他相关人员叫进房间说：“好吧，这是我们想为用户做的。这是我们要解决的问题，或者我们要融入他们生活的方式。在那个时刻，人们想要感到非常轻盈和从容。”

---

**English:**
(00:18:05): So, for the Peek feature [inaudible 00:18:07] he's referencing the use cases. You're on Hacker News and you want to probably in pretty quick succession check out five to seven URLs. And you're not really sure which one you're going to spend time on, but you're going to open a bunch of stuff really quickly. And Peek allows you to effortlessly just peek into it, without leaving Hacker News and context switching to this whole new tab and going back and forth. So in that scenario, the conversation was how do we make it feel really airy and effortless to just whoop, pop it up, pop it back down, lightness, airiness, speed, agility. So again, it's not that we have a, "What is the number one feeling and the number two feeling?" It is much more conversational at this stage, but I am actually really excited. Hopefully we got the privilege one day to have such a large team that we have to figure out a way to do it. So, that's an example of how we think about it.

**中文翻译:**
(00:18:05): 比如 Peek 功能，使用场景是：你在看 Hacker News，可能想快速查看 5 到 7 个链接。你不确定要在哪个上面花时间，但你想快速扫一遍。Peek 让你能毫不费力地“偷看”一眼，而不需要离开 Hacker News，也不需要切换到新标签页来回折腾。所以在那种场景下，我们的对话是：我们如何让它感觉非常轻盈、毫不费力，就像“嗖”地一下弹出来，又“嗖”地一下收回去，体现轻盈感、速度和灵活性。所以，并不是说我们有一个“第一感受、第二感受”的清单，现阶段更多是基于对话。但我真的很兴奋，希望有一天我们能有幸发展到团队规模大到必须想出一种正式方法来执行它的程度。这就是我们思考方式的一个例子。

---

### [00:18:57] Lenny

**English:**
It's a good segue to a question I wanted to touch on. So, I asked Scott Belsky what I should ask you. He's a big fan of yours. I don't know if he's an investor? But he's just like, "I love Josh." And asked him, "What should I ask Josh?" And one of his questions was about, you guys ship very quickly. You're shipping meaningful features every Friday. And you also close the loop really well with customers when they come ask for something. You're like, "Hey, here. We did it." What is it that you do, and what can people learn from the way you all operate that allows you to ship quickly?

**中文翻译:**
这正好引出了我想聊的一个问题。我问过 Scott Belsky 该问你什么，他是你的超级粉丝。我不确定他是不是投资者，但他就是说“我爱 Josh”。他问的一个问题是关于你们发布速度非常快。你们每周五都会发布有意义的功能，而且在客户提出需求时，你们能很好地完成闭环，告诉他们：“嘿，看，我们做到了。”你们是怎么做到的？人们能从你们的运作方式中学到什么来提高发布速度？

---

### [00:19:26] Josh Miller

**English:**
Well, first of all, thank you Scott, if you're listening. It's somewhat of an awkward question admittedly, because it's like someone complimenting you about your product. It's always impossible to really take and accept the compliment, because you see all the blemishes. Of course we see all these ways in which we don't ship fast enough and could be doing a better job listening and building with members. But, at risk of sounding a bit cliche, I really think we ship our values. So, we thought a lot about our values as a company. You can read about them online. And I think if you examine those values and then you look at your compliment or Scott's compliment, you can see [inaudible 00:20:05] one-to-one. So the first, and I really think the most important is, we hire people that show up with heartfelt intensity.

**中文翻译:**
(00:19:26): 首先，谢谢 Scott，如果你在听的话。诚然，这是一个有点尴尬的问题，因为这就像别人夸奖你的产品，你很难全盘接受，因为你看到了所有的瑕疵。当然，我们也看到很多地方发布得不够快，或者在倾听和与成员共同构建方面可以做得更好。但是，冒着听起来有点陈词滥调的风险，我真的认为我们“发布的是我们的价值观”。我们对公司价值观思考了很多，你可以在网上读到。如果你审视这些价值观，再看你或 Scott 的赞美，你会发现它们是一一对应的。第一点，也是我认为最重要的一点，就是我们雇佣那些带着“满腔热忱”（heartfelt intensity）来上班的人。

---

**English:**
(00:20:11): And, a lot of companies I think obsess over craft details. They'll be a value like, "We obsess over the details." What we say is, we want people that show up to our company with some fire in their belly, something that they are out to do. And for each person it's a little bit different. For some people it may be UI Craft details, for other people it may be achieving double the performance with a quarter of the engineering head count. Everyone has something, but they show up with this heartfelt intensity. And I think even relative to everything else, I'm going to say, that's it. If you have a team that has heartfelt intensity and is there for a purpose and something to prove, you give them a very exciting, ambitious product and get out of their way and they will do remarkable work. So, showing up with heartfelt intensity.

**中文翻译:**
(00:20:11): 很多公司痴迷于工艺细节，他们的价值观可能是“我们痴迷于细节”。而我们说的是，我们希望人们带着某种“雄心壮志”（fire in their belly）来到公司，有某种他们一心想做成的事。对每个人来说这都不一样：对某些人来说是 UI 工艺细节，对另一些人来说是用四分之一的人力实现双倍性能。每个人都有自己的追求，但他们都带着这种热忱。我认为，相对于其他一切，这就是核心。如果你有一支充满热忱、有目标、想证明自己的团队，你给他们一个令人兴奋、有野心的产品，然后别挡路，他们就会做出卓越的工作。所以，第一条是“满腔热忱”。

---

**English:**
(00:20:54): Our second value is assume you don't know. Assume you don't know. And the value "assume you don't know" is, even if you're a subject matter expert. We have someone in our company that literally built the first version of Chrome and ran it for 16 years. But he more than anyone embodies this beginner's mind of, "I have no idea how this should work or what will happen." And the follow up to that value is, "So we got to get going." It's like dropping in a new city. You just got to walk out the door of your Airbnb turn left and ... Maybe you'll turn right and then you'll hop on the subway, but you just got to get going and see what you find. And so, we have this attitude of, you're showing up with this heartfelt intensity. But you start by saying, "I've no idea what I'm doing. I have no idea what's going to happen." So we've just got to get going. And that biases in a default to action.

**中文翻译:**
(00:20:54): 我们的第二个价值观是“假设你并不知道”（Assume you don't know）。即使你是领域专家也要如此。我们公司有人亲手打造了第一版 Chrome 并管理了 16 年，但他比任何人都更能体现这种“初心”（beginner's mind）——“我不知道这该怎么运作，也不知道会发生什么”。这个价值观的后续是：“所以我们得动起来。”这就像空降到一个新城市，你只需走出 Airbnb 的门，向左转……或者向右转，然后跳上地铁，你只需动起来看看能发现什么。所以我们的态度是：你带着热忱而来，但你开始时会说：“我不知道自己在做什么，也不知道会发生什么。”所以我们必须行动。这让我们倾向于“默认行动”。

---

**English:**
(00:21:44): We have another value of, start by asking, "What could be?", which is pushing ourselves to be as aspirational, ambitious as possible. So the Peek feature that you mentioned, we just didn't want to solve the problem of context switching. We wanted to almost blur the line between native and web software, and make it feel like a sheet of paper. And really pushing ourselves to be as ambitious as we can be, which is the consequence of blowing back around and more deeply motivating the people working on it.

**中文翻译:**
(00:21:44): 我们还有另一个价值观：“先问‘可能是什么？’”（What could be?），也就是推着自己尽可能地去追求抱负和野心。比如你提到的 Peek 功能，我们不只是想解决上下文切换的问题，我们想模糊原生软件和 Web 软件之间的界限，让它感觉像一张纸。真正推着自己去实现最大的野心，这反过来又会更深地激励正在开发它的人。

---

**English:**
(00:22:13): So, I mean, I could keep going. We have a value, "You're doing it for the crew when you got to swarm. When you got to swarm," and we have value of, "make them feel something." But I think what it all adds up to is, a team that has a lot of heart, has a lot of intrinsic motivation and a, "It's the first day of my career. I wonder what's going to happen?" attitude. And I think all of those things add up to a culture which is, "Let's get something out there. Let's see what happens."

**中文翻译:**
(00:22:13): 我还可以继续说下去。我们还有“为了团队而战，必要时全员出击”（swarm）的价值观，以及“让用户有所感受”的价值观。但我认为所有这些加在一起，就是一个充满爱心、充满内在动力、带着“这是我职业生涯第一天，我想知道会发生什么”态度的团队。所有这些构成了我们的文化：“让我们把东西做出来，看看会发生什么。”

---

### [00:22:46] Lenny

**English:**
How did you come up with these? What was the process to come up with company values? Because I know a lot of companies are like, "We should come up with these." How do you do that?

**中文翻译:**
你是怎么想出这些的？制定公司价值观的过程是怎样的？因为我知道很多公司都会说“我们应该制定价值观”，但具体怎么做呢？

---

### [00:22:54] Josh Miller

**English:**
The secret is I hate corporate values. I've never resonated with them. And I'm fortunate, we're fortunate enough, to have a lot of really spectacular, experienced leaders in our corner. And I got hammered to the first year, two years on, "Josh, where are your values? How can your team operate without values?" And I always experienced them on the other end as almost corporate propaganda, these cliche fortune cookie, Panda Express-like, "You should care about the detail." It didn't resonate with me. And the thing that clicked was maybe a year and a half, two years into working, I just kept hearing the same things from the team. And I would do things like a year into someone joining, "How's it going? What's going well? What's not?" And I realized that there are some traits that define our team, extremely organically and naturally. No one told people what our values were.

**中文翻译:**
秘密在于我讨厌“企业价值观”。我从未对它们产生过共鸣。我很幸运，我们很幸运，有很多非常出色、经验丰富的领导者在支持我们。在头一两年里，我一直被追问：“Josh，你的价值观在哪？没有价值观你的团队怎么运作？”而在我看来，那些东西几乎就是企业宣传，像熊猫快餐里的幸运饼干纸条一样陈词滥调，比如“你应该关注细节”。这没法让我产生共鸣。转机出现在工作大约一年半到两年的时候，我不断从团队那里听到同样的话。我会做一些类似入职一年的访谈：“进展如何？哪些好，哪些不好？”我意识到，有一些特质极其有机、自然地定义了我们的团队。没有人告诉大家我们的价值观是什么。

---

**English:**
(00:23:51): Again, because I was this naive, ignorant 31-year-old being like, "Values are a corporate, late-stage capitalism creation," and just very, very hardheaded. And it was really special two years in, hearing from the team why they love The Browser Company, why they think we're doing ... Just the passion there. And then we challenged ourselves to what became a value. Well, if something about the five one-liners on the corporate webpage feels off, start by asking what could be in dream a little bit. And what I realized was, all of the statements people would say about what they loved about The Browser Company, what they thought defined the way we work, they reminded me of how I like to take road trips. I'm a big traveler. I'm a big fan of dropping in somewhere new and just exploring. And so we just had this "Aha!" Moment. Let's, instead of having a corporate landing page with five value titles and subtitles, let's write a manual for how to take a road trip.

**中文翻译:**
(00:23:51): 再次强调，因为当时我还是个天真无知的 31 岁青年，觉得“价值观是企业在资本主义后期搞出来的产物”，非常固执。但在两年后，听到团队分享他们为什么热爱 The Browser Company，以及那种激情，感觉真的很特别。然后我们挑战自己，把这些变成了价值观。如果公司网页上那五句口号感觉不对劲，那就先问问“可能是什么”，做点梦。我意识到，人们描述的关于热爱这家公司、定义我们工作方式的所有话语，都让我想起我喜欢的公路旅行。我热爱旅行，喜欢空降到一个陌生的地方去探索。于是我们有了这个“灵光一现”的时刻：与其做一个写着五条标题和副标题的企业落地页，不如写一本“如何进行公路旅行”的手册。

---

**English:**
(00:24:54): So we wrote an essay called "Notes on Road Trips" that use this semi-biographical, but mostly fictional, story about a person and their father taking a road trip when they're a teenager, to tell the story of how we do things at The Browser Company. And share these values, but in a way that hopefully won't feel so propagandary and feel a little more, you're reading an essay. So I say that, again, not to say there's anything wrong with traditional values. I'm actually sure I'm going to get an earful for a lot of people that coach me and give me advice that I sounded too indignant on this podcast. But I'm pretty proud of that story because it was a great example of assuming you don't know. We were sure that corporate values were not for us. And then very organically without trying it turned out, "Wait! They run through this company in a pretty profound way. We should put some words around it, because it's happening whether or not we like it, or say it is or not."

**中文翻译:**
(00:24:54): 于是我们写了一篇名为《公路旅行笔记》（Notes on Road Trips）的文章，用一个半自传、大半虚构的关于少年和父亲公路旅行的故事，来讲述我们在 The Browser Company 是如何做事并分享这些价值观的。这种方式希望不会让人觉得像是在搞宣传，而更像是在读散文。我说这些并不是说传统价值观有什么错。我确信很多指导我的导师听了这期播客会教训我，说我听起来太愤世嫉俗了。但我对那个故事很自豪，因为它是“假设你并不知道”的一个绝佳例子。我们曾确信企业价值观不适合我们，但结果却非常自然地发现：“等等！这些特质正深刻地贯穿于这家公司。我们应该用文字记录下来，因为无论我们喜不喜欢，无论我们承不承认，它都在发生。”

---

### [00:25:49] Lenny

**English:**
That's awesome. I have the page here and it's quite beautiful. And, pulling to it in the show notes just very briefly and tactically, did you just sit down and start writing this thing and then people gave you feedback? How long did this process take? Just for folks that maybe you want to go down this road?

**中文翻译:**
太棒了。我手头就有那个页面，非常漂亮。我会把它放在节目简介里。简单从战术上问一下，你是直接坐下来开始写，然后大家给你反馈吗？这个过程花了多久？给那些想走这条路的人参考一下。

---

### [00:26:03] Josh Miller

**English:**
Yeah. Warning downside of this process that it takes a lot longer than we thought it would, because we put so much heart into it. So, what it started with was again, in my natural one-year, check-in type conversation, starting to notice these patterns. And then we actually very comprehensively were like, "Okay. Let's sit down and interview everyone at The Browser Company. But no survey. One by one, talking to people, asking questions. And then we pulled out those words. So, actually what's really cool about these values, if my memory serves me, I believe every single one, with the exception of maybe a word or two, was something that someone on our team said. So we interviewed the entire team and then these are meant to be a mirror. The putting it in road trip essay form? That took a long time. That that was a lot of ... Yeah. I don't recommend the way that we did that, but-

**中文翻译:**
(00:26:03): 是的。警告一下，这个过程比我们想象的要长得多，因为我们投入了太多的心血。开始时，还是在我那种自然的一周年访谈中，我开始注意到这些模式。然后我们非常全面地决定：“好吧，让我们坐下来采访 The Browser Company 的每一个人。”不是发问卷，而是一个接一个地聊天、提问。然后我们提取了那些词。这些价值观真正酷的地方在于，如果我没记错的话，除了个别词句，每一条都是我们团队成员亲口说出来的。所以我们采访了整个团队，这些价值观就像是一面镜子。至于把它写成公路旅行散文的形式？那花了很长时间。那需要很多……是的，我不推荐我们那种做法，但是——

---

### [00:27:02] Lenny

**English:**
How long is long?

**中文翻译:**
“很长时间”是多久？

---

### [00:27:03] Josh Miller

**English:**
Probably three months.

**中文翻译:**
大概三个月。

---

### [00:27:06] Lenny

**English:**
Oh. That does not sound that long. Okay.

**中文翻译:**
噢，听起来也没那么长嘛。好吧。

---

### [00:27:07] Josh Miller

**English:**
Yeah. Maybe this goes back to Scott's comment that maybe our bar to how quickly we should ship stuff including values is, it's like I don't know. But, yeah. It felt like a long time. And this was not just me. Just for anyone listening, this was not CEO in a corner writing a missive. This was a team effort. There's a woman Abby on our team that did so much work on this project. The words themselves came from our team. So, it has my name I think somewhere on that webpage, but by no means was this me writing this essay in a corner with the fireplace on, or anything like that.

**中文翻译:**
(00:27:07): 是的。也许这又回到了 Scott 的评论，可能我们对“快速发布”的门槛（包括价值观）定得太高了。但确实感觉过了很久。而且这不只是我一个人的功劳。听众们请注意，这绝不是 CEO 躲在角落里写公文，这是一个团队的努力。我们团队的 Abby 在这个项目上做了大量工作。文字本身来自团队。虽然网页上可能写着我的名字，但这绝不是我一个人坐在壁炉旁写出来的。

---

### [00:28:15] Lenny

**English:**
Okay. Awesome. That was really helpful. As you also saw, I asked on Twitter what to ask you, and I got a ton of questions. People have a lot of questions for how y'all do stuff. The most common question turned out was from Ched Khan who had the most likes of all the questions that people asked you. And it was around hiring, that basically you've been able to convince some of the most amazing people in the world to join The Browser Company. Like you just mentioned, you hired the guy that built Chrome, basically, to work on Arc now. What is it that you do that convinces amazing people to join? Because everyone wants to learn from you and copy you, and do that themselves.

**中文翻译:**
好的，太棒了，这很有帮助。正如你所见，我在 Twitter 上征集了该问你什么，收到了海量问题。大家对你们做事的方式非常好奇。点赞最高的问题来自 Ched Khan，是关于招聘的：你基本上说服了一些世界上最牛的人加入 The Browser Company。就像你刚才提到的，你雇佣了那个打造 Chrome 的人来开发 Arc。你到底做了什么能说服这些牛人加入？因为大家都想向你学习并复制这种成功。

---

### [00:28:15] Josh Miller

**English:**
Thank you for that question and for all the legs. I will admit, this is also a fairly awkward one to ask. I actually just came from an interview with a candidate and they asked me a fairly similar question. And I said, "You know what? You should go ask the people that work here. It's not me. I don't know why they ultimately join." But what I will tell you is, the intentionality, which is another secret, sharing a lot of secrets. This one will probably get me in trouble. I don't care about web browsers. I've never cared about web browsers. I never wanted to build a web browser. If you had told me a decade ago that I'd be working on a desktop first web browser at 32, "I'd say what in my career went horribly wrong?"

**中文翻译:**
(00:28:15): 谢谢这个问题。我承认，这也有点尴尬。我刚面试完一个候选人，他也问了类似的问题。我说：“你知道吗，你应该去问问在这里工作的人。不是因为我，我也不知道他们最终为什么加入。”但我可以告诉你的是“意图性”（intentionality），这是另一个秘密。这个秘密可能会让我惹上麻烦：我并不关心网页浏览器。我从未关心过浏览器，也从未想过要造一个浏览器。如果你十年前告诉我，我 32 岁时会在做一款桌面优先的网页浏览器，我会问：“我的职业生涯到底出了什么大错？”

---

**English:**
(00:29:10): The origin story of this company was Hursch, who I met when I was 20. We started a company together. Lots of mistakes, a lot of successes, a lot of growing pains and figured out who we are. And a decade later we were still friends, we went to each other's weddings. We'd worked in all these different industries and different-stage companies and we just realized, "You know what? There are a lot of ideas that get us really excited. There are a lot of shapes and sizes." But as we were nostalgic for looking back on the decade prior, it was groups of people and moments in time with those people that were our best memories. And so, what Hursch and I decided, long before the company started was, we want to build a company, but we want to build a company where we feel like we can hire whoever we want.

**中文翻译:**
(00:29:10): 这家公司的起源故事是我 20 岁时遇到了 Hursh。我们一起创办了一家公司，犯了很多错，也有很多成功，经历了很多成长的痛苦，最终搞清楚了我们是谁。十年后我们依然是朋友，参加了彼此的婚礼。我们在不同的行业、不同阶段的公司工作过，然后意识到：“你知道吗，有很多想法让我们兴奋，形式各异。”但当我们怀旧地回顾过去十年时，发现最好的回忆总是关于那群人和与他们共度的时光。所以，在公司成立很久之前，我和 Hursh 就决定：我们要开一家公司，但我们要开一家让我们觉得“可以雇佣任何我们想共事的人”的公司。

---

**English:**
(00:30:06): And so, where we went to with a new web browser, let alone a web browser as a new form of computing, which is our true aspiration, to build an internet here. You can look up the internet computer YouTube video on our Browser Company YouTube page. But our ambition's even higher than a web browser. The intention of that is, we just want to go hire our favorite people that we know and don't know and build a team that, we'll never get bored working with this crew, because of how incredible they are and how humble they are. And so, when you think about it like that, I as the CEO as notionally the head of product, I view our product as our team. And I know a lot of companies say that. I actually think they probably all mean it. I don't think anyone's being disingenuous, but we really meet it. It is the genesis of this company.

**中文翻译:**
(00:30:06): 所以，我们选择做一款新浏览器——更不用说将其作为一种新的计算形式，这是我们真正的抱负，即构建一台“互联网计算机”（你可以去我们的 YouTube 频道看那个视频）。我们的野心远不止于浏览器。其初衷是：我们只想去雇佣那些我们认识或不认识的最喜欢的人，组建一支让我们永远不会感到厌倦的团队，因为他们是如此出色且谦逊。所以，如果你这样想，我作为 CEO 和名义上的产品负责人，我把“团队”视为我们的产品。我知道很多公司都这么说，我也相信他们是真心的，但我认为我们是真的做到了。这就是这家公司的起源。

---

**English:**
(00:30:55): It is not a new web browser. It is, let's build the dream team, our dream team. And let's build a way of working that is really fun for us and really speaks to our values. And let's go find people that resonate with that. And that trickles down to everything we do, whether it's our policy about this or the way we do that. I'll give you one example. Our goal of interviews is to convince people not to join The Browser Company. If I have an interview with someone, I don't pitch them and say, "What do you want to ask me? Anything you want? I'll be super honest, most people shouldn't want to work here." So I think it all starts with us viewing our product as the company, as the team, not Arc itself. And then, I think being self-aware, that that's how I think that's how we think.

**中文翻译:**
(00:30:55): 它不是一个新浏览器，它是“让我们组建一支梦之队，我们的梦之队”。让我们建立一种对我们来说非常有趣、且符合我们价值观的工作方式，然后去找那些能产生共鸣的人。这渗透到我们所做的每一件事中，无论是政策还是执行方式。举个例子：我们面试的目标是说服人们“不要”加入 The Browser Company。如果我面试某人，我不会向他们推销，我会说：“你想问我什么？随便问。我会非常诚实，大多数人其实不应该想在这里工作。”所以，一切都始于我们将产品视为公司和团队，而不是 Arc 本身。

---

**English:**
(00:31:43): But again, flying back things that I've heard, we have been fortunate. We've hired a lot of really remarkable people, especially on paper and especially off. I mean, all around. I'll just give a couple examples to share one thing that I've heard. A few recent hires, we hired someone named Darren who, as I mentioned, he co-created the first prototype of Chrome and then ran it for 16 years. I think hundreds if not thousands of people reported to him. He joined the Browser Company as an IC. We just hired a woman named Tara. She was on the original Paper by 53 team, one of my most inspiring products at the beginning of my career. Most recently she was actually, I believe, Senior SVP of product at Vimeo and a senior director of engineering. She joined our engineering team as an IC. We just hired someone named Peter Vidani. When I was 20 building consumer social software, he was the coolest, most impressive person. He was the first designer at Tumblr. Ran the design team at Tumblr for seven years and the most recently was SVP of design at Slack. Joined the team as an IC designer.

**中文翻译:**
(00:31:43): 话说回来，我们确实很幸运，雇佣了很多非常出色的人，无论从简历看还是实际表现看。举几个例子：我们雇了 Darren，他共同创建了 Chrome 的第一个原型并管理了 16 年，曾有成百上千人向他汇报，但他作为 IC（独立贡献者，非管理岗）加入了我们。我们刚雇了 Tara，她是 Paper by 53 创始团队成员，那是我职业生涯早期最受启发的产品之一，她曾是 Vimeo 的高级副总裁和工程总监，现在作为 IC 加入了我们的工程团队。我们还雇了 Peter Vidani，我 20 岁做社交软件时，他就是最酷、最让人印象深刻的人，他是 Tumblr 的第一位设计师，管理了 Tumblr 设计团队七年，最近是 Slack 的设计高级副总裁，现在作为 IC 设计师加入了我们。

---

**English:**
(00:32:48): And though that sounds like I'm bragging, the thing that was really interesting and perplexing to us was, these are people that have made a lot of money, that have had really fancy titles, that have worked on transformative projects. Why are they joining this team? And I think something that people show up to The Browser Company with is, in addition to heartfelt intensity, this aspiration that their work at The Browser Company will come to define their careers. And that's coming from people that have done really remarkable things, by all accounts. And I think more than anything, we've realized that, in order for people like that to join and to show up with that, there are a number of things you have to promise and provide them, that make folks like that gravitate with the intention of doing their work of their career, ranging from an incredible and ambitious aspiration, really empowerment to act on the prompts that they're given on behalf of the team in the way that they see fit, and truly trusting and empowering them.

**中文翻译:**
(00:32:48): 虽然这听起来像是在吹嘘，但真正让我们感兴趣且困惑的是：这些人已经赚了很多钱，拥有显赫的头衔，参与过变革性的项目，为什么他们要加入这个团队？我认为，加入 The Browser Company 的人除了满腔热忱外，还有一种抱负，即他们在 The Browser Company 的工作将定义他们的职业生涯。这可是出自那些已经做过非凡成就的人之口。我们意识到，为了让这样的人加入并带着这种抱负，你必须承诺并提供一些东西：从令人惊叹且雄心勃勃的愿景，到真正的赋权（让他们能以自己认为合适的方式代表团队行动），以及真正的信任。

---

**English:**
(00:33:54): A very kind culture. I think if you've been doing this for a decade plus, your intolerance for bullshit is very, very low. And so, by no means do I think we're perfect. I don't think everyone shows up The Browser Company saying, "If I'm not on the equivalent of the early iPhone team, I'm going to be bummed." But I think generally speaking, Hursh and I, and everyone that was on the early team showed up with this aspiration of making The Browser Company the product. And I think that's carried forward to this tumbleweed of people saying, "[inaudible 00:34:23]. That's where I'm going to finally do the equivalent of building the iPhone." And we all know we probably won't, but there is that, "I want to give it one more shot. I want to go for it." And that just tumbleweeds, I think, at some point.

**中文翻译:**
(00:33:54): 还有一种非常友善的文化。如果你在这个行业干了十年以上，你对“废话和破事”（bullshit）的容忍度会非常低。我绝不认为我们是完美的，也不认为每个加入的人都会说：“如果我不是在做类似早期 iPhone 团队的工作，我就会很失望。”但总的来说，我和 Hursh 以及早期团队的所有人，都带着“把公司本身做成产品”的抱负。这种氛围像滚雪球（tumbleweed）一样吸引了更多人，大家觉得：“这就是我最终能做出类似 iPhone 成就的地方。”虽然我们知道可能做不到，但那种“我想再试一次，我想全力以赴”的劲头，最终形成了这种滚雪球效应。

---

### [00:34:37] Lenny

**English:**
That tumbleweed is, I think a big part of it is, once you get amazing people, more amazing people want to join. So I think that's very much helpful. Something else this resonates a lot with is, just the mission of a company is such a powerful tool for pulling people in, the best people. I've seen that a lot with founders. If they have a meaningful mission, it's so much easier to hire, versus not. And clearly you're really good at sharing that vision and mission. And then you also have a really interesting mission and vision. I think there's also, you're just a charismatic founder and that helps a lot too. And you're a great storyteller.

**中文翻译:**
这种滚雪球效应很大程度上是因为，一旦你有了牛人，更多的牛人就会想加入。这非常有帮助。另一件引起共鸣的事是，公司的使命是吸引顶尖人才的强大工具。我在很多创始人身上都看到了这一点：如果有意义的使命，招聘就会容易得多。显然你非常擅长分享愿景和使命，而且你们的使命本身就很吸引人。我想你也是一个很有魅力的创始人，这也有很大帮助，你是个很棒的讲故事的人。

---

### [00:35:08] Josh Miller

**English:**
Well, the other thing I want to add Lenny is, again putting myself in the listener, I imagine a lot of what I just said probably sounded a little bit ... Could come off, if you don't know me and you don't, as a little bombastic or a little again romantic. Very tactically, I'll give you something that was just who we are, but I think has helped contribute to this tumbleweed. From the very first person we hired, we celebrated them publicly. The fact that they joined. And in a very heartfelt way, telling you about them as a person and what they did. Long before we had anyone that anyone would've heard of before working at The Browser Company, just because it was earnest, we were really proud. Again, if you think of our original mandate as building the companies, the product, when our first designer joins, we want to tell everyone about it. That's a product launch. That is the product launch.

**中文翻译:**
(00:35:08): Lenny，我还想补充一点。站在听众的角度，我刚才说的那些听起来可能有点……如果你不认识我，可能会觉得有点夸张或过于浪漫。从战术上讲，我分享一件体现我们本色的事，它也促成了这种滚雪球效应：从我们雇佣的第一个人开始，我们就会公开庆祝他们的加入。我们会非常真诚地介绍他们这个人以及他们做过的事。早在那些大牛加入之前，我们就这么做了，纯粹是因为诚恳和自豪。再说一次，如果你把“把公司做成产品”作为原始使命，那么当第一位设计师加入时，我们要告诉全世界。那就是一次“产品发布”，那才是真正的产品发布。

---

**English:**
(00:35:57): And then, whenever we ship something, we go out of our way to celebrate the people that worked on it publicly. I think there's a CEO-hero worship sometimes in Silicon Valley. I do very little at the company. Or sorry. I do very little as it relates to the thing people fall in love with Arc. I do a lot for The Browser Company, but I don't make Arc. I didn't make Peek. And again, that's just who we are, which is, "Alexandre. She killed me! Look at how cool this is!" because it's earnest and it's honest to who we are. And then I think it creates this reinforcing cycle of you're someone that's done something incredible, which is, "I'm going to be celebrated. They truly want me here. I'm going to be recognized for the work that I do.

**中文翻译:**
(00:35:57): 此外，每当我们发布东西时，我们都会特意公开表彰参与其中的人。硅谷有时存在“CEO 英雄崇拜”。我在公司做得很少——或者说，对于让人们爱上 Arc 的那些具体功能，我做得很少。我为 The Browser Company 做了很多，但我没做 Arc，我也没做 Peek。我们的风格是：“Alexandre 太牛了！看这个功能多酷！”因为这是真诚的。这创造了一个增强循环：如果你是一个做出了不起成就的人，你会觉得“我会受到赞赏，他们真心希望我在这里，我的工作会得到认可”。

---

**English:**
(00:36:39): It's not going to just accrue to this like CEO figurehead who everyone thinks is some genius visionary. And so again, by no means are we perfect. By no means do I think we get it right all the time. But, because it's such an authentic expression of who we are and what we were trying to do, I think we do little micro implementations like that, that ladder up to that principle I got so excited about but are as simple as someone tweets about some animation. They're like, "Woo! This was fun." Tag Sherry. Sherry made that, Sherry's incredible. And you don't see that that much in Silicon Valley. You see corporate blog posts and the CEOs more than anyone else. That's probably why you don't have CEOs on the podcast, because you don't want ... You know this Lenny. That is why that's your policy. You don't want to hear from the CEOs. They're not the ones building the product. You want to hear from the people actually doing it. That's why I love this podcast.

**中文翻译:**
(00:36:39): 功劳不会只归于那个被大家视为天才愿景家的 CEO 傀儡。当然，我们并不完美，也不敢说每次都做得对。但因为这是我们真实自我的表达，我们会做很多微小的执行，比如有人发推特赞美某个动画，我们会回复：“哇！这很有趣。”然后艾特 Sherry，说“这是 Sherry 做的，她太棒了”。在硅谷你很少见到这种做法，你看到的更多是企业博客和 CEO 的出镜。Lenny，这可能就是你为什么不常请 CEO 上播客的原因，因为你不想听 CEO 吹水，他们不是真正造产品的人，你想听那些实干家分享。这也是我喜欢这个播客的原因。

---

### [00:37:26] Lenny

**English:**
That's right. That's right. Thank you. I'd say just hearing everything you're saying, The Browser Company sounds like an incredible place to work. I could see why people want to go work. It's pretty simple. You touched on being public and sharing everything that's going on. And that's another area I wanted to spend a little time on. You guys are very transparent about what's going on and inside the company. You bring cameras into the board meetings. I watched a half-hour meeting you had with your head of design talking about a project that's behind scheduling. You're trying to figure out how do we get this out the door. You just share actual things you all are doing within the company, publicly. And I'm curious just, why did you start doing that? What have you seen as a good or bad that has come from that? Is there anything you've shared that maybe you regret like "Oh, maybe we shouldn't have put that out there." What's been your experience with that?

**中文翻译:**
没错，谢谢。听了你说的这些，The Browser Company 听起来确实是个很棒的工作场所，我能理解为什么大家想去那里。你提到了公开透明地分享一切，这也是我想聊的。你们对公司内部发生的事情非常透明，甚至把摄像机带进了董事会会议。我看过你和设计负责人讨论一个进度落后项目的半小时会议视频，你们在讨论如何把它发布出去。你们公开分享公司内部的真实运作。我很好奇，你们为什么要这么做？这样做带来了哪些利弊？有没有什么分享后让你后悔的，比如“噢，也许我们不该把那个发出来”？

---

### [00:38:17] Josh Miller

**English:**
Why don't I start with the regret. It's not yet a regret, but the thing that I wonder ... Because this is very much ... I may have hopefully spoken with a lot of earnest passion to some of the questions before. This is one that I would really characterize as a prototype. We really have a prototype-driven culture. And this is one that I'd put high on the list of, "Maybe we'll regret this later." And specifically what I hope is that, I'm uncomfortable putting myself too central in our story. But, naturally, when you're doing storytelling publicly, there's a gravitational pull for the CEO and the founders to be at the center of that. And so, sometimes even this morning, we had our best-performing YouTube video ever. The first one that really broke out of people that already follow us. And it's a reaction video in classic YouTube form to MKBHD talking about our product for the first time.

**中文翻译:**
(00:38:17): 我先从后悔谈起吧。目前还没有后悔，但我确实在思考……因为这很大程度上……我之前回答问题时可能带着很多热忱，但关于这一点，我更愿意将其描述为一个“原型”。我们拥有一种原型驱动的文化，而“公开构建”就在“以后可能会后悔”的清单前列。具体来说，我不喜欢把自己放在故事的中心。但自然而然地，当你公开讲故事时，会有一种引力让 CEO 和创始人成为中心。比如今天早上，我们发布了表现最好的 YouTube 视频，那是第一个真正突破原有粉丝圈的视频。那是一个经典的 YouTube 反应视频，内容是关于 MKBHD（著名科技博主）第一次评价我们的产品。

---

**English:**
(00:39:13): And I honestly watched it right before this again, and I was like, "What the fuck am I doing? What are we doing? Why am I trying to become a YouTuber?" So, to be totally honest, I don't regret anything yet. But I wonder if we could take this too far? So if anyone's listening, if you see us starting to take this too far, especially as it relates to me, we want to hear about it, because that's keeping me up. But I do think the intentions are pure and earnest, which are ... And another thing that defines people that have joined The Browser Company, in addition to wanting to do the work that defines their careers, is I would characterize it as a little bit of hopelessness, maybe feeling jaded, questioning this industry that they've worked on or products that they've worked on and wanting to rediscover. But, at the end of the day, we are a group of idealists, of optimists, wanting to rediscover what we fell in love with when we were kids, whether it's the part of our craft or the potential of technology, the internet and software.

**中文翻译:**
(00:39:13): 我在录这个播客前又看了一遍，心想：“我到底在搞什么鬼？我们在做什么？我为什么要尝试成为一个 YouTuber？”所以，老实说，我目前还没后悔，但我担心我们会走得太远。如果有人在听，如果你发现我们开始做得过火了，特别是涉及到我个人时，请告诉我们，因为这让我夜不能寐。但我认为初衷是纯粹和诚恳的。加入 The Browser Company 的人除了想做定义职业生涯的工作外，还有一种特质：我将其描述为一点点“绝望感”，也许是感到厌倦，质疑他们工作过的行业或产品，并想要重新发现。归根结底，我们是一群理想主义者、乐观主义者，想要重新找回小时候爱上技术、互联网和软件时的那种感觉。

---

**English:**
(00:40:19): And, as part of that, I would view Arc and the Browser Company as an experiment in we can do it. Better is possible. And as we were thinking about better as possible, rediscovering what we love and believe in deep down and trying to express it in the world, one of it related to trust. I remember when I was a teenager using the internet for the first time and early on to college, just the hopefulness of what was possible, and the belief that these people building these tools, they were like heroes to me. Not just the leaders, but the teams, the companies, the brands. And somewhere along the way, I'm not blaming a single company, I'm not even saying that anyone did anything wrong, but culturally ... I was a sociology major. Culturally, we have lost trust in tech companies and in tech brands.

**中文翻译:**
(00:40:19): 作为其中的一部分，我将 Arc 和 The Browser Company 视为一个实验，证明“我们可以做到，更好的产品是可能的”。当我们思考“更好的可能”时，我们在重新发现内心深处的热爱和信仰，并试图将其表达出来，其中之一就与“信任”有关。我记得青少年时期第一次用互联网，以及大学早期，那种对可能性的希望，以及对造工具的人的崇拜，他们对我来说就像英雄。不只是领导者，还有团队、公司和品牌。但在某个时刻——我不怪罪任何一家公司，甚至不认为有人做错了什么，但从文化上讲（我是社会学专业的）——我们失去了对科技公司和科技品牌的信任。

---

**English:**
(00:41:10): And so, building in public showing you our meetings, uncomfortably so, is an act in, "If we were them, why should they trust us? Why should anyone trust us?" We have your most sensitive personal data. We have your most sensitive professional data. Why should you trust us if we've had our trust broken again and again? And I think our hypothesis in this prototype, in this experiment is, we can have the best privacy policy in the world, but at the end of the day, again, it's just people behind the screen. And so, even if I think about ... I haven't done interviews like this, because I worry that if you don't know me, I come off the wrong way.

**中文翻译:**
(00:41:10): 所以，公开构建、展示我们的会议（尽管这让人不适），其实是在问：“如果我们是用户，为什么要信任我们？为什么要信任任何人？”我们掌握着你最敏感的个人数据和职业数据。在信任一次次被打破后，你凭什么信任我们？我们在这个实验中的假设是：我们可以拥有世界上最好的隐私政策，但归根结底，还是屏幕后的人。所以，即使我考虑……我以前没做过这样的访谈，因为我担心如果你不认识我，我会给人留下错误的印象。

---

**English:**
(00:41:51): A lot of people tend to. I've noticed a lot of friends in my life that I know them behind the scenes, but the way that people perceive them publicly here don't know them. They interpret it the other way, because there's not that trust. And so our bet is that if you get to know us, Nash, Dina, me Hursch, and you really feel like you get to know us as person and all of our imperfections, we're average looking, we're average to all that stuff. Then when you see that we're asking for a permission, you might trust it is because we want to make you feel a certain way that's better. And if not ... I'll say someone tweeted something yesterday, who apparently we didn't earn the trust yet and they haven't gone to know us. And their interpretation of what we were doing was the worst possible interpretation you could [inaudible 00:42:40].

**中文翻译:**
(00:41:51): 很多人都会这样。我注意到生活中很多朋友，我私下了解他们，但公众对他们的看法却完全不同，因为缺乏信任。所以我们的赌注是：如果你了解了我们——Nash、Dina、我、Hursh——如果你真的觉得了解了我们这些人以及我们所有的不完美（我们长相平平，各方面都很普通），那么当你看到我们请求权限时，你可能会相信这是因为我们想让你有更好的感受。否则……昨天有人发推特，显然我们还没赢得他的信任，他也不了解我们，他对我们所做事情的解读是你能想到的最糟糕的版本。

---

**English:**
(00:42:53): And at first honestly, I felt a bit of anger, like, "Who was this person on a Thursday just saying we're doing X and Y?" And then I realized, "You know what? I'd have the same feeling because of the experiences I've had with technology in the past five to 10 years." And so, the intention with these the building and public experiments are radical trust building. Not radical transparency, we can't share everything, but radical trust building. You get to know us as humans and I worry that we'll regret that, and that it could potentially turn into, "Oh, they're trying to be internet celebrities that they're so important, they should share everything because ... Thank you, them, for gracing us with their opinions." It's not the intention and it feels worth taking that risk. But that's the intentionality behind it.

**中文翻译:**
(00:42:53): 老实说，起初我有点生气，心想：“这人是谁啊，周四就在这儿瞎猜我们在干嘛？”但随后我意识到：“你知道吗？如果是我，基于过去 5 到 10 年的技术体验，我也会有同样的感觉。”所以，这些公开构建实验的初衷是“激进的信任建立”（radical trust building）。不是激进的透明化（我们不能分享一切），而是激进的信任建立。让你把我们当成活生生的人来了解。我担心我们会后悔，担心这会演变成“噢，他们想当网红，觉得自己很重要，所以要分享一切”。这不是我们的本意，但我觉得值得冒这个险。这就是背后的意图。

---

### [00:43:24] Lenny

**English:**
That is a really interesting insight. It makes a lot of sense for a browser to find that so important, to build that trust.

**中文翻译:**
这是一个非常有趣的见解。对于浏览器来说，建立这种信任确实至关重要。

---

### [00:43:31] Josh Miller

**English:**
I haven't done podcast interviews, I haven't done this. I really like you. I really like the feeling of your conversations, the intentions behind them, the warmth, even your intro music is a friendly jig. So, I mean, it's a great example, where I think it's one of the most wonderful things about the podcasting medium is I've had you in my ear for a year and the people on your show and you feel a sense of trust in you and your intentions here. And your intentions both in this interview, in terms of what you're trying to do for listeners. To some extent your show, and the warmth that you bring to it and the perception I have as a human being ... We've never met. We've maybe DM'd briefly, maybe five messages exchanged. But I feel like I know you and that makes me trust you. And so, in many ways this podcast, at a meta level's an inspiration for it.

**中文翻译:**
我以前没做过播客访谈。我真的很喜欢你，喜欢你谈话的感觉、背后的意图和温暖，甚至你的片头音乐都很友好。这是一个很好的例子，我觉得播客这种媒介最美妙的地方之一就是，你在我耳边响了一年，你节目里的人和你让我感到一种信任。你在这次访谈中的意图，以及你为听众所做的一切，还有你带来的温暖……我们从未见过面，可能只在私信里聊过五句，但我感觉我了解你，这让我信任你。所以，在元层面（meta level）上，这个播客也是我们的灵感来源。

---

### [00:44:23] Lenny

**English:**
I feel the same way in reverse. You made this point about being worried about being two front and center for your company. I have the same exact feeling. Even though my newsletter's called "Lenny's Newsletter," I only named it that because that was the default recommendation when I was signing up for Substack. I didn't want to be this, "I know it all. Come to me. Welcome to my know-it-all place." I really dislike that. And that's why I created this community that lives along the side, where people can help each other, because I'm not going to have all answers. And so, I've had to lead into that. "All right, people." They want a person to help them understand what's going on, learn about ... And in your videos you do a great job highlighting other people. I was watching your board meeting video and it's like, "Here's all team members coming along. Here they come. How are you doing?" So, anyway. All that to say, you're doing a great job finding the balance.

**中文翻译:**
我也有同感。你提到担心自己太过于处于公司的中心，我也有完全一样的感觉。尽管我的通讯叫“Lenny's Newsletter”，但我起这个名字只是因为注册 Substack 时的默认建议。我不想成为那种“我无所不知，快来听我讲课”的人，我很讨厌那样。这就是为什么我建立了一个并行的社区，让大家互相帮助，因为我没有所有答案。所以我必须适应这种角色。人们想要一个人来帮他们理解发生了什么。在你的视频中，你很好地突出了其他人。我看你的董事会视频，看到所有团队成员都参与进来。总之，我想说，你在寻找平衡方面做得很好。

---

### [00:45:14] Josh Miller

**English:**
Oh, thank you. You as well.

**中文翻译:**
噢，谢谢。你也是。

---

### [00:45:15] Lenny

**English:**
I appreciate it. You talked about storytelling, and you mentioned that you have a whole bunch of odd teams at The Browser Company. One of them is a storytelling team. And that actually explains, I think, how you're so good at making these really amazing videos, because making great videos is hard. Can you just talk about some of these odd teams that you have, that probably other companies don't?

**中文翻译:**
谢谢。你谈到了讲故事，并提到 The Browser Company 有一堆“奇怪”的团队，其中一个是“讲故事团队”（storytelling team）。这解释了为什么你们能做出这么棒的视频，因为做视频很难。你能聊聊这些其他公司可能没有的奇怪团队吗？

---

### [00:45:34] Josh Miller

**English:**
One of the other things that, hopefully, you're picking up in this interview, so far, is we are a very prototype-driven culture. It goes back to the "assume you don't know" ethos. We try a lot of experiments, and we try them related to product features related to how we work together, related to the stories we tell. So, this isn't a category of, "I'm not sure it's going to work, but we're trying it," and it seems to be working so far, at least for us. What Lenny's referencing is, we have a handful of teams. I'll pick two just as an examples. We have a membership team and we have a storytelling team. And though you probably recognize or are obviously familiar with those terms, those aren't historically startup orgs, or startup disciplines and teams. And let me tell you about the intention behind both.

**中文翻译:**
(00:45:34): 希望你在访谈中已经察觉到，我们是一个非常“原型驱动”的文化。这回到了“假设你并不知道”的精神。我们做很多实验，涉及产品功能、协作方式以及讲故事的方式。这属于“我不确定是否有效，但我们在尝试”的范畴，目前看来对我们有效。Lenny 提到的是我们的一些团队，我举两个例子：会员团队（membership team）和讲故事团队。虽然这些词你可能熟悉，但它们在历史上并不是典型的初创公司组织架构。让我告诉你这两者背后的意图。

---

**English:**
(00:46:16): Membership. Membership was, when I was at Facebook, the most impressive thing to me about how Facebook built product was their user research team. Shout out to Lowie and Jane. I don't know why you'd be listening to this podcast, but you deeply inspired me when we were at Facebook together. They had the most incredible team of user researchers. And it always felt odd to me. And this isn't Lowie and Jane's fault. Actually, in fact, they suffered from this. That user research almost felt like a service organization, relative to product engineering design. There'd be a PM. The PM would get assigned a researcher and the PM got to decide how to use the researcher, and ask them what to do and ask them questions. But seeing the potential for when you really get to know the people that you are building for, that you're serving, at a really deep way, it is extraordinary. How do you build product any other way?

**中文翻译:**
(00:46:16): 会员团队。我在 Facebook 时，最让我印象深刻的是他们的用户研究团队。向 Lowie 和 Jane 致敬，你们在 Facebook 时深深启发了我。他们有一支不可思议的用户研究团队。但我总觉得奇怪——这不是 Lowie 和 Jane 的错，实际上他们也深受其害——用户研究相对于产品、工程和设计，几乎像是一个“服务部门”。PM 会被分配一个研究员，由 PM 决定如何使用研究员，告诉他们做什么。但当你真正深入了解你所服务的人群时，那种潜力是巨大的。除了这种方式，你还能怎么造产品呢？

---

**English:**
(00:47:09): And so, we took that to the extreme at The Browser Company, which we said, "Let's not think of it as customer support, customer service, customer success, user research. Those are just business terms. Those are just industry terms." At the end of the day, what we're saying is if there is a human being, from the moment they touch our software or our products for the first time, to, if they have it last, we need to have a deep, genuine, ongoing relationship with them.

**中文翻译:**
(00:47:09): 所以在 The Browser Company，我们把这推向了极致。我们说：“别把它想成客户支持、客户服务、客户成功或用户研究。那些只是商业术语。”归根结底，我们说的是：如果有一个人，从他第一次接触我们的软件，到他最后一次使用，我们需要与他建立深厚、真实且持续的关系。

---

**English:**
(00:47:36): And on day one, that may be air quote, "customer success." "How do I use this thing?" On day 37, that might be, "I have a bug. Do you mind helping me fix it?" And on day 58, that may be, "Hey, we're shipping the mobile app soon. What do you want from mobile? What do you want on your phone?" Other companies view that as different orgs and disciplines. We view that as, there are a bunch of people at the other end of this that we are serving from the moment they touch our product the first time. Let's own that relationship full stack and think about it holistically. And so that's the membership team.

**中文翻译:**
(00:47:36): 第一天，这可能是所谓的“客户成功”——“我该怎么用这玩意？”第 37 天，可能是“我遇到了 Bug，能帮我修一下吗？”第 58 天，可能是“嘿，我们要发布移动端了，你想要什么功能？”其他公司把这些视为不同的部门和学科，我们认为：在另一端有一群人，从他们接触产品的那一刻起，我们就在为他们服务。让我们“全栈”地拥有这种关系，并从整体上思考。这就是会员团队。

---

**English:**
(00:48:07): On the storytelling side, very similar, different type of person. Again, we're a humanistic the company. So, the theme here is the people on the company, the people at the other end. So if the membership team takes people from the moment they touch our product for the first time to the last, the storytelling team is about people we don't have the privilege of serving yet. They don't use Arc, they don't know what Arc is. That could be an investor, air quote, "investor relations." That could be members of the press, air quote, "PR." That could be just people out in the world, air quote, "marketing" and one-day sales. But at the end of the day, it's telling our story to people. It's telling our story to people and thinking about that holistically in full stack.

**中文翻译:**
(00:48:07): 讲故事团队也类似，只是人员类型不同。再次强调，我们是一家充满人文关怀的公司。如果会员团队负责那些已经在使用产品的人，讲故事团队则负责那些我们还没有机会服务的人。他们不用 Arc，不知道 Arc 是什么。这可能涉及所谓的“投资者关系”、“公关”、“营销”或未来的“销售”。但归根结底，就是向人们讲述我们的故事，并全栈式地思考这个问题。

---

**English:**
(00:48:47): So that's how we think about teams is, we start with first principles asking, what are we really trying to do here? And what is the most direct way to manifest that, even if it's not how other people do it? In practice, one of the benefits of that is I do think it leads to certain pieces of content. For example, that people go, "Oh, wow! I've never seen that before." But again, I think anyone's capable of this. I think we have an extraordinarily talented storytelling team and membership team, but I really think it's as simple as the intentionality of what is the team? What are their incentives? What are the disciplines on the team? Even hiring a video editor, for example, as a small company. But the video editor, not having make a TikTok account go viral. But think about it more holistically in terms of the people.

**中文翻译:**
(00:48:47): 这就是我们思考团队的方式：从第一性原理出发，问“我们到底想做什么？”，以及“实现这一目标最直接的方式是什么？”，哪怕别人不这么做。在实践中，这样做的好处之一是它能产生一些让人惊叹“哇，我从未见过这种内容”的东西。我认为任何人都能做到这一点。我们有一支非常有才华的讲故事团队和会员团队，但我认为这仅仅关乎“意图性”：团队是什么？他们的激励机制是什么？团队里有哪些学科？比如作为一家小公司雇佣视频编辑，不是为了让 TikTok 账号走红，而是为了更全面地思考人与人的连接。

---

**English:**
(00:49:33): So, again, there's a lot that breaks down. There's a lot that's not going well about it. I have no idea how the scales, the 500 people ... Yeah. So this is not me saying this experiment is ultimately going to be a huge success, or right for everyone or even us at different times. But that was the intentionality of the membership team, the storytelling team and others. And even product management. We don't have PMs at the company. My title at Facebook was Product Manager. I love product management. But, we view it not as a team. We view it as a leader, a role on a project, on an effort.

**中文翻译:**
(00:49:33): 当然，这其中有很多行不通的地方，也有很多进展不顺的地方。我不知道当规模达到 500 人时该怎么办。所以我不是说这个实验一定会大获成功，或者适合所有人。但这就是会员团队、讲故事团队等的初衷。甚至包括产品管理——我们公司没有 PM（产品经理）这个职位。我在 Facebook 的头衔是产品经理，我热爱产品管理。但我们不把它看作一个团队，而是一个领导者，一个项目或一项工作中的角色。

---

**English:**
(00:50:07): And depending on the projects, different types of people should be a PM. So, we have a performance-related project going on where, of course, an infrastructure engineer should be that air quote, "PM." We have a product project, where actually I think someone from membership should be the PM, because ultimately, yes, we're building software product, but it is really about serving our members in a specific way, so we should have someone for membership be a PM. Again, as you can imagine, as is going through the heads of everyone listening, "That must break down in 18 ways?" Oh, it definitely does. And so I'm not promising one day it won't change. But again, continuous through the company is, assume you don't know. Start by asking what could be, and let's just try some things and see what happens.

**中文翻译:**
(00:50:07): 根据项目的不同，不同类型的人应该担任 PM。比如我们有一个性能相关的项目，那么基础设施工程师理所当然应该是那个“PM”。我们有一个产品项目，我认为会员团队的人应该担任 PM，因为归根结底，虽然我们在造软件，但核心是以特定方式服务会员。正如听众所想：“这肯定会在很多方面出问题吧？”噢，绝对会。我不保证以后不会改变。但公司的核心始终是：假设你并不知道，先问可能是什么，然后尝试并观察结果。

---

### [00:50:48] Lenny (Sponsor)

**English:**
Start with what could be. I love that value. This episode is brought to you by Linear. Let's be honest, this sheet tracker that you're using today isn't very helpful. Why is it that always seems to be working against you, instead of working for you? Why does it feel like such a chore to use? Well, Linear is different. It's incredibly fast, beautifully designed, and it comes with powerful workflows that streamline your entire product development process, from issue tracking all the way to managing product roadmaps. Linear's designed for the way modern software teams work. What users love about Linear are the powerful keyboard shortcuts, efficient GitHub integrations, cycles that actually create progress and built-in project updates that keep everyone in sync. In short, it just works. Linear is the default tool of choice among startups and it powers a wide range of large, established companies such as Versel Retool and Cash App. See for yourself why product teams describe using Linear as magical visit linear.app/lenny to try Linear for free with your team and get 25% off when you upgrade. That's linear.app/lenny.

**中文翻译:**
“先问可能是什么”，我喜欢这个价值观。本集节目由 Linear 赞助。老实说，你现在用的那个表格追踪工具并不好用。为什么它总是像在跟你作对，而不是在帮你？为什么用起来像是在做苦力？Linear 则不同。它速度极快，设计精美，并配有强大的工作流，能简化从问题追踪到路线图管理的整个产品开发过程。Linear 是为现代软件团队的工作方式而设计的。用户喜欢它的快捷键、高效的 GitHub 集成、真正推动进度的“周期”（cycles）以及内置的项目更新。简而言之，它就是好用。Linear 是初创公司的首选工具，也为 Vercel、Retool 和 Cash App 等大型成熟公司提供动力。亲自体验一下为什么产品团队称 Linear 为“魔法”，访问 linear.app/lenny 免费试用，升级时可享受 25% 的折扣。

---

### [00:52:00] Lenny

**English:**
So, I was going to ask you actually, you talked about why you don't have PMs. Do you think you'll hire PMs in the future, having a PM background? Do you think you'll get there or do you think you'll try to stick to this? People do the PM role, depending on the project?

**中文翻译:**
我正想问你，你谈到了为什么没有 PM。考虑到你自己的 PM 背景，你觉得未来会雇佣 PM 吗？你觉得最终会走向那一步，还是会坚持这种“根据项目由不同人承担 PM 角色”的模式？

---

### [00:52:12] Josh Miller

**English:**
Yeah. We've increasingly hiring people that at other companies may have a PM title. I'd say we have two to three right now, that could have a PM title at another company. I don't think we will have a pm organization, or a PM role, because again, we believe depending on ... If you unpack the verbs that a PM does, I think those are verbs that anyone that we hire could do. And it really depends on what is the project? And what are we trying to do? I think the thing that will be unwavering is we like to hire mutts. And I haven't yet figured out a term that comes off as more endearing, because it's meant to be very endearing, but ... For example, there's a woman in a company named Rebecca.

**中文翻译:**
(00:52:12): 是的。我们越来越多地雇佣那些在其他公司可能有 PM 头衔的人。目前大概有两三个。我不认为我们会建立一个 PM 组织或 PM 职位，因为我们相信，如果你把 PM 所做的“动词”（工作内容）拆解开来，这些动词是我们雇佣的任何人都能做的。这取决于项目是什么。我认为有一点是不会改变的：我们喜欢雇佣“杂家”（mutts）。我还没想出一个更亲切的词，但这确实是褒义的。比如，我们公司有个叫 Rebecca 的女性。

---

**English:**
(00:52:58): Rebecca was a data scientist we use at Cora. She got her PhD in MIT in I think behavioral psychology or something. I'm probably going to misquote that. But, got some crazy degree at MIT, and then was a software engineer at Stripe. And I'm talking about Rebecca through her resume. There's so much about Rebecca. She plays effectively a PM role right now. She is effectively PMing our effectively our multi-player team. But what was so awesome about meeting Rebecca is her and other people at this company have the mindset of, "I make things, and I will do what I need to do to make what I want to make. Whenever that verb is, whenever that discipline is." And that requires people that are multidisciplinary in practice and multidisciplinary in approach to their work. It's not that we don't hire PMs, but we want to hire people who have a multidisciplinary approach and view things as, "I like to make things. Tell me how I contribute to making it." And sometimes they may play the verbs of a PM and sometimes it may be something else.

**中文翻译:**
(00:52:58): Rebecca 曾是 Quora 的数据科学家，她在 MIT 拿到了行为心理学之类的博士学位，然后在 Stripe 担任软件工程师。我只是在描述她的简历，Rebecca 本人远比这丰富。她现在实际上扮演着 PM 的角色，负责我们的多玩家团队。认识 Rebecca 最棒的一点是，她和公司的其他人都有这样一种心态：“我是创造者，为了做出我想做的东西，我会去做任何需要做的事，无论那个‘动词’是什么，无论属于哪个学科。”这需要实践中和方法论上的跨学科人才。并不是说我们不雇 PM，而是我们想雇那些具有跨学科方法、认为“我喜欢创造东西，告诉我如何贡献力量”的人。有时他们执行 PM 的职能，有时则是别的。

---

### [00:54:07] Lenny

**English:**
This can be a really interesting story to follow. I've seen this journey a few times at different companies. What I find is a lot of times people that are good at other things like engineering or design, for a while, they're like, "Yep. We don't need PMs. I'll do the PM job." And then eventually they're like, "This sucks. I hate doing this stuff. I want to design. Leave me alone. I don't want to sit on a [inaudible 00:54:29] all day. I don't want to be in meetings." So eventually, it turns out, they're like, "Okay. Let's find someone to do this thing that loves it." And so that's one thing that happens.

**中文翻译:**
(00:54:07): 这会是一个很有趣的观察点。我在几家公司都见过这种历程。我发现很多时候，擅长工程或设计的人在一段时间内会觉得：“没错，我们不需要 PM，我能干 PM 的活。”但最终他们会觉得：“这太差劲了，我讨厌干这些杂事，我想搞设计，别烦我，我不想整天开会。”所以最终他们会说：“好吧，找个热爱这件事的人来干吧。”这是经常发生的一种情况。

---

**English:**
(00:54:36): The other thing I find is, I'm sure you've seen this, a lot of people are wary of PMs. They come in and they're like, "Here's what we're doing," and they're just adults process complexity. What I find is those are just bad PMs. If you have an awesome PM, everything just gets better. Everyone's happier, things move faster. So I think companies often get to that stage. And then also there's just career development stuff, eventually as you scale. It's like "What happened to my career path," and they're like, "All right. Well, we got to go on one road or another." It's hard to stay in this hybrid role. But I super respect the first principal's approach of let's just-

**中文翻译:**
(00:54:36): 另一件事是，我相信你也见过，很多人对 PM 存有戒心。PM 进来说“我们要这么做”，然后只是增加了流程复杂度。但我发现那只是因为他们是糟糕的 PM。如果你有一个出色的 PM，一切都会变得更好，大家更开心，进度更快。所以公司最终往往会走到那一步。此外还有职业发展的问题，随着规模扩大，大家会问“我的职业路径是什么？”，然后发现必须选一条路走。很难一直保持这种混合角色。但我非常尊重这种从第一性原理出发的方法。

---

### [00:55:08] Josh Miller

**English:**
And, for what's worth, Lenny. I think you're almost, definitely right. And I think it will almost definitely happen with us. And again, this goes back to the "assume you don't know." The "assume you don't know," is try a prototype and then assume it's not going to work. So, even in my own experience, I remember getting to know Evan from Snapchat just enough to know how he talked about PMs at Snap. And it was, "We're never going to hire PMs at Snap. Everyone's a designer." And, I have no relationship with him anymore, but you can look, there are a lot of PMs at Snapchat.

**中文翻译:**
(00:55:08): Lenny，你说得几乎肯定是对的。这几乎肯定也会发生在我们身上。这又回到了“假设你并不知道”：尝试一个原型，然后假设它可能行不通。在我自己的经验中，我记得 Evan Spiegel（Snapchat 创始人）曾说过：“Snap 永远不会雇佣 PM，每个人都是设计师。”现在你可以去看看，Snapchat 有很多 PM。

---

**English:**
(00:55:37): So I know from my own experience with people that I respect from a product perspective that were indignant, they would never hire PMs, their organizations now have PMs. And that's probably for a really good reason. I would tell say also on our team, if any of our designers are listening, they'll tell you these, whatever you want to call it, "These verbs are taking up a lot of my time, and I do not have as much time to think and dream and design and do user research." And so, we're already feeling it breaking into our company.

**中文翻译:**
(00:55:37): 所以我从那些我尊重的产品人身上学到，即使他们曾愤慨地表示绝不雇 PM，现在的组织里也有了 PM。这可能有很好的理由。我们团队的设计师如果正在听，他们会告诉你：“这些‘动词’占用了我太多时间，我没有足够的时间去思考、构思、设计和做用户研究了。”所以，我们已经感觉到这种压力在渗入公司。

---

**English:**
(00:56:04): I think the intentionality, whatever comes next, whatever it is, is leaders of the project should be picked for the projects, not because they're in a certain org at our company. And, if we ever hire people to do the PM role, we want them to think of themselves as people who make things and have lots of different disciplines and tools in their toolkit, not just the PM discipline. And, of course, even that could be wrong, and maybe in a year we cave. I got it totally wrong. We got it totally wrong. So, we'll see. But I would also, that that of all the things I shared on this podcast so far, this is probably the one I'll come crawling back to your podcast in a couple years, being, "Lenny, you were right. It all blew up!"

**中文翻译:**
(00:56:04): 我认为核心意图是，无论接下来发生什么，项目的领导者应该根据项目本身来挑选，而不是因为他在公司的某个部门。如果我们真的雇人来做 PM，我们希望他们认为自己是“创造者”，工具箱里有很多不同的学科和工具，而不只是 PM 这一门。当然，这也可能是错的，也许一年后我们就妥协了，承认我彻底错了。所以，走着瞧吧。但在我目前分享的所有内容中，这可能是我几年后会爬回你的播客说“Lenny 你是对的，全搞砸了”的那一件事。

---

### [00:56:47] Lenny

**English:**
But it's a fun experiment and Snap is a good example. Stripes another, where they waited a long time to hire their first PMs. And I think it's because their designers or engineers were just incredibly good at that element. And it was also very design-forward or very edge-forward, so they didn't need as much PM skill initially.

**中文翻译:**
但这是一个有趣的实验。Snap 是个好例子，Stripe 也是，他们等了很久才雇第一个 PM。我想是因为他们的设计师或工程师在产品方面极其出色。而且这些公司最初非常以设计或工程为导向，所以早期不需要太多的 PM 技能。

---

### [00:57:03] Josh Miller

**English:**
If I had to predict, I would predict that if we found that we were missing this discipline as a team, I think we would evolve Rebecca's team, which is technically the data team, and do something closer to a technical PM or data plus [inaudible 00:57:19] Again, it's all live, but the thought has even crossed our minds recently, that we may be wrong, and what org might we create if we need folks that have more of a background of [inaudible 00:57:29] like this.

**中文翻译:**
如果要我预测，如果我们发现团队缺失了这一环，我想我们会演化 Rebecca 的团队（目前是数据团队），做一些更接近技术 PM 或“数据+”的事情。这一切都在进行中，最近我们甚至在想，如果我们错了，我们需要什么样的组织架构来容纳这些背景的人。

---

### [00:57:30] Lenny

**English:**
I'm excited for the video of this discussion that might happen. It's also interesting, your PM that you mentioned, Rebecca is very data oriented. And then, the initial discussion we had around focus on feelings and that sort of thing. So, that's cool that you have this really interesting balance of people that are very data focused and then this, "Okay. But let's not obsess with that. What are the feelings we're trying to create?"

**中文翻译:**
我很期待看到关于这个讨论的视频。很有趣的是，你提到的 Rebecca 非常以数据为导向，而我们最初讨论的是关注“感受”。这种在极度关注数据的人和“别痴迷于数据，我们要创造什么感受”之间的平衡非常酷。

---

### [00:57:50] Josh Miller

**English:**
Yeah. Because again, the point of optimizing for feelings is not hire people who make feelings. It's like Rebecca's title is Data Lead. She runs our data team. But, Rebecca's one of the most humanistic people I know. You meet her and you feel the warmth that you feel when you talk to you, and you ask her what she does outside of work. And so, it's not that data doesn't have a role. Actually I'd say, for better or worse, data is part of our practice. It's more about what's that top-level intentionality? What are we trying to do here? But, yeah. We have a lot of people that, data is either a noun they've had in their resume or it's been a part of their practice a lot in the past.

**中文翻译:**
是的。因为再次强调，优化感受并不是要雇佣“制造感受的人”。Rebecca 的头衔是数据负责人，她管理数据团队，但她是我认识的最具人文关怀的人之一。你见到她能感受到那种温暖。所以并不是说数据没有作用，实际上数据是我们实践的一部分。更多的是顶层的意图是什么？我们到底想做什么？我们有很多人的简历里有“数据”这个词，或者过去的工作中大量涉及数据。

---

### [00:58:29] Lenny

**English:**
Awesome. One very tactical question with the storytelling team makes me think about Airbnb's video team. A lot of people are joking internally for years and years that the videos Airbnb put out in the early days accounts for half their market cap, because they're so good. And you're just like, "Oh, my God, I want to go on an Airbnb." They just make you feel so much and they're soul made. So, what is the makeup of your storytelling team? Because I imagine some companies maybe listening, like maybe we should do something like this on our team.

**中文翻译:**
太棒了。关于讲故事团队的一个战术性问题：这让我想起了 Airbnb 的视频团队。多年来内部一直开玩笑说，Airbnb 早期发布的视频贡献了一半的市值，因为它们太棒了，让你觉得“天哪，我想去住 Airbnb”。它们非常有灵魂。那么，你们讲故事团队的构成是怎样的？我想有些听众公司可能会想参考。

---

### [00:58:57] Josh Miller

**English:**
We have a three-person storytelling team. It's run by a woman named Nash. There is a gentleman named Ellis, who is a ... Background, started as a reporter at The Verge. Maybe there was a publication before that. But I met him when he was a reporter at The Verge covering social media. And then he ran marketing strategy for Snapchat for seven years. And then we have a person named Josh Lee, who I actually met as an intern. He was an intern at Facebook as a designer, that an intern for me at the White House when I worked at the White House, and then decided that he was over product design and over design, and totally just jumped and be like, "I'm going to be a filmmaker," and has been making really fascinating indie films for a few years now. And he's our video editor on the team.

**中文翻译:**
(00:58:57): 我们有一支三人的讲故事团队。负责人是 Nash。还有 Ellis，他曾是《The Verge》报道社交媒体的记者，后来在 Snapchat 负责了七年的营销策略。第三位是 Josh Lee，我认识他时他还是实习生，曾在 Facebook 做设计实习生，后来在我工作的白宫实习，之后他决定放弃产品设计，转型做电影制作人，拍了几年独立电影。他是我们团队的视频编辑。

---

**English:**
(00:59:44): And it's so interesting. Nash's background, she had a brief stint at NBC. But again, you get to know her and she writes poems after hours and her dream is to write a fictional book. I mean, anyone that knows Nash, especially [inaudible 01:00:00] is just a force. A force. And the three of them, what's so interesting about them, which also relates to our design team ... One of the things I also found at Facebook is there was a tendency toward homogeneity. As you know, there's a stereotype of a Facebook PM for example, or a Google PM, the contrast between them and the way they work. And one of the things we also have purposely done on the storytelling team and otherwise, let's hire radically different archetypes. Ellis cannot be more different than Nash. Nash cannot be more different than Josh. There's some shared values, there's some shared beliefs, but they're very different.

**中文翻译:**
(00:59:44): 这很有趣。Nash 曾在 NBC 工作过，她下班后写诗，梦想是写小说。了解 Nash 的人都知道她是一股“力量”。他们三个人最有趣的地方在于——这也涉及到我们的设计团队——我在 Facebook 发现的一种倾向是“同质化”。如你所知，Facebook PM 或 Google PM 都有某种刻板印象。而我们在讲故事团队和其他团队中刻意做的是：雇佣完全不同的原型。Ellis 和 Nash 截然不同，Nash 和 Josh 也完全不同。他们有共同的价值观，但个性迥异。

---

**English:**
(01:00:35): Ditto on the design team. Our design team? They are all over the place in terms of who they are, what they've done, their sensibilities, their aspirations. And whether it's the storytelling team or the design team, that can be hard sometimes, just to be honest. It's a lot easier to say, "Hey, we're the Acme Co storytelling team, we're Acme Co design team. We hire designers like this and storytellers that." We hire people all over the place. We have an extremely diverse team, but in all senses of the word. But again, the no PM thing, it's not without flaws. I can see why a lot of large companies over time tend are like, "It's the Facebook way or no way," or "You're not good for here."

**中文翻译:**
(01:00:35): 设计团队也是如此。我们的设计师背景各异，审美和抱负也各不相同。老实说，无论是讲故事团队还是设计团队，这种多样性有时会让管理变得困难。如果说“我们只雇这种类型的设计师”，那会容易得多。但我们雇的人五花八门。我们有一支极其多元化的团队。再说一次，没有 PM 并非没有缺陷，我能理解为什么大公司最终会倾向于“要么按 Facebook 的方式做，要么滚蛋”。

---

### [01:01:14] Lenny

**English:**
Yeah. It's actually I think, exact makeup of Airbnb video team. I forget what they were called. They didn't have a cool name, the storytelling team I think. But it was a videographer, an editor and then their producer, basically.

**中文翻译:**
是的。我想这实际上和 Airbnb 视频团队的构成一模一样。我忘了他们叫什么了，好像没起什么酷名字，大概就是摄像师、剪辑师和制片人。

---

### [01:01:26] Josh Miller

**English:**
Yeah. I mean, I remember going to Airbnb's offices early in my career and seeing the storyboards lining the walls and just being like, "I want to work here." So, I'm actually not familiar with the ... I mean, I'm familiar with Airbnb's videos and brand marketing, fucking fantastic, excuse my language. But, yeah. I remember just walking around that office being like, "Oh, my goodness! Are they making a movie or something? I want to [inaudible 01:01:53] here."

**中文翻译:**
是的。我记得职业生涯早期去 Airbnb 办公室，看到墙上贴满了分镜图（storyboards），当时就想：“我想在这里工作。”我对 Airbnb 的视频和品牌营销非常熟悉，简直太棒了（请原谅我的粗口）。我记得在那个办公室走动时心想：“天哪，他们是在拍电影吗？我也想在这里工作。”

---

### [01:01:54] Lenny

**English:**
Funny you say that. And for folks that want to find that, we'll link to it in show notes. But if you Google "Snow White Airbnb," you'll actually see these storyboards. They basically hired a Pixar storyboard artist to draw out key frames of the journey of a host and a guest. And that became a central element of the strategy of, let's make each of these moments as amazing as possible. And it was based on the movie Snow White. You can read about it.

**中文翻译:**
很有意思。想看的人可以去搜“Snow White Airbnb”，我们会把链接放在简介里。他们雇了一位皮克斯的分镜师，画出了房东和房客旅程的关键帧。这成了他们战略的核心：让每一个时刻都尽可能精彩。它是基于《白雪公主》这部电影的，你可以去读读相关文章。

---

### [01:02:15] Josh Miller

**English:**
For what it's worth, this is a great moment to share. All of the beliefs that I've shared here on behalf of our team, these aren't things that we just originally came up with. They're moments like when I went to Airbnb's office early in my career and saw these Snow White storyboards lining the walls. That had an impact on me. Even the idea that you would think in terms of that moment, you could actually see the lineage to, well, how do you want that person to feel when they open that door for the first time? So, I think it's just a great moment to shout out that we've accumulated a lot of doses of inspiration, like that day at Airbnb, that trickle down to us talking about optimizing for feelings. But that didn't come in a vacuum. That's our expression of what we've seen in the industry. This is building on the backs of so many people and companies that we've been fortunate to see.

**中文翻译:**
(01:02:15): 顺便说一下，这是一个很好的分享时机。我代表团队分享的所有信念，并非凭空产生的。正是像早期去 Airbnb 办公室看到那些分镜图的时刻影响了我。甚至那种从“时刻”出发去思考的方式——你可以看到其中的传承——即“当那个人第一次推开门时，你想让他有什么感觉？”所以，我想大声说出来，我们积累了很多灵感，比如在 Airbnb 的那一天，这些灵感最终汇聚成了我们现在谈论的“为感受而优化”。这并非产生于真空，而是我们对行业所见的表达，是站在许多前辈和公司的肩膀上。

---

### [01:03:03] Lenny

**English:**
And now the trickling is happening from your lessons and experience and your unique approach.

**中文翻译:**
而现在，这种影响正通过你的经验和独特方法传递给他人。

---

### [01:03:07] Josh Miller

**English:**
I hope. There's a documentary that I highly recommend called General Magic. And it's one of the best pieces of media I've seen related to technology industry. And it's really interesting. I think there are two types of people to just be very ... There are people that watch that and view it as, "Wow! What a missed opportunity," or almost like a sad story. And I view it as, "If only we could be so lucky to assemble a group of people like that." And the thing about that documentary, for anyone that hasn't listened to it is, essentially was the iPhone before the iPhone, with the most legendary group of technologists working there. And it totally failed, completely failed by all traditional business definitions.

**中文翻译:**
(01:03:07): 我希望如此。我强烈推荐一部名为《General Magic》的纪录片，这是我看过的关于科技行业最好的作品之一。很有趣，看这部片子的人通常分两类：一类觉得“哇，多么错失的机会”，觉得是个悲剧；而我则觉得“如果我们能有幸召集到那样一群人就好了”。那部纪录片讲的是在 iPhone 出现之前就想做 iPhone 的故事，那里有一群最传奇的技术专家。按传统商业定义，它彻底失败了。

---

**English:**
(01:03:50): But, what stuck with me from the documentary, how proud and nostalgic and passionate those individuals were in reminiscing about their time there. And then, what they all went on to create. And the fact that even today on this podcast, I'm sitting here talking about General Magic. So, I mean, to your point of hopefully Browser Company will have ripple effects. That to me is the ultimate goal, for me personally, at a very emotional level. If we could only be so lucky. That, to me, seems like success in many ways.

**中文翻译:**
(01:03:50): 但让我印象深刻的是，那些人在回忆那段时光时是多么自豪、怀旧且充满激情，以及他们后来创造的一切。甚至今天我还在这个播客里谈论 General Magic。所以，关于你提到的希望 The Browser Company 能产生涟漪效应，那是我个人在情感层面上的终极目标。如果我们能有那样的运气，对我来说，在很多方面就是成功。

---

### [01:04:24] Lenny

**English:**
Yeah. What's cool is you're getting a lot of footage that will be very useful for a future documentary on the history of The Browser Company.

**中文翻译:**
是的。酷的是你现在拍了这么多素材，对未来关于 The Browser Company 历史的纪录片会非常有用。

---

### [01:04:30] Josh Miller

**English:**
[inaudible 01:04:30] I didn't think about it like that, for better or worse.

**中文翻译:**
哈哈，无论好坏，我还没往那方面想过。

---

### [01:04:32] Lenny

**English:**
One last thought, I was going to mention it in terms of the storytelling movie-making elements of Airbnb. Fun fact, there was a period where product managers were actually called producers, because one of the founders was like, "We don't want to manage product, we want to produce beautiful experiences," like a movie producer. And so that was a year and a half maybe of Airbnb's history, where product managers were producers. The problem is, we got a lot of job applicants from Emmy-winning producers and they're like, "oh, I want to work at Airbnb."

**中文翻译:**
最后一个想法，关于 Airbnb 的电影制作元素。一个有趣的事实：有一段时间，Airbnb 的产品经理实际上被称为“制片人”（producers），因为其中一位创始人觉得“我们不想管理产品，我们想制作精美的体验”，就像电影制片人一样。那段时期持续了大约一年半。问题是，我们收到了很多艾美奖获奖制片人的求职申请，他们说：“噢，我想去 Airbnb 工作。”

---

### [01:05:01] Josh Miller

**English:**
I know this podcast is about very tactical advice. So, one tactical piece of advice I'll give is, whether or not you like the idea of the storytelling team or something else, a byproduct of some of these experiments that we've found works really well is when you give something a new name, it sheds a lot of preconceived notions of what the thing should be. We found that even with product. So if you say you're building a browser history feature, then the benefit is everyone knows what you're talking about. And the downside is, everyone knows what you're talking about. And you show up with these preconceived notions of what it has to be. And so, if you go back again to revalue ask what could be ... In many ways the point of calling the team, the storytelling team or the membership team, or not having PMs as an organization ... All of this stuff isn't meant to be novelty for novelty's sake. It's meant to almost be a rhetorical tactic, to make people think truly first principles about what are we trying to do here?

**中文翻译:**
(01:05:01): 我知道这个播客是关于战术建议的。所以我给出一个战术建议：无论你是否喜欢讲故事团队这个想法，这些实验的一个副产品是——当你给某样东西起一个新名字时，它会摆脱很多关于“这东西应该是什么样”的固有观念。在产品上也是如此。如果你说你在做一个“浏览器历史记录”功能，好处是大家都知道你在说什么，坏处也是大家都知道你在说什么，于是你带着固有观念去做了。所以，如果你回到“可能是什么”的价值观……在很多方面，把团队称为讲故事团队或会员团队，或者不设立 PM 职位，这些都不是为了标新立异，而是一种修辞策略，让人们真正从第一性原理出发去思考：我们到底想在这里做什么？

---

**English:**
(01:06:00): And again, if at the end, producers are called PMs, that's fine. But I assume when it was called a producer, a much more intentionality was given to you communicating and talking and discussing, what does a producer do? What's their relationship with design? Because no one knew what the heck a producer was. And so, ultimately, that may have been failure in other ways. But that's one of the things we found tactically to be really helpful is, whether it's a product feature or a team, or whatever, give it a made up name just to really get to the root of what you're trying to do there. Or not borrow too much from wherever you worked before, whatever you've seen, popular media or whatever.

**中文翻译:**
(01:06:00): 再次强调，如果最后“制片人”又改回叫 PM，那也没关系。但我猜当它被称为制片人时，你们在沟通、讨论“制片人是做什么的”、“他们与设计的关系是什么”时会更有意图性，因为没人知道制片人到底是什么。虽然这在其他方面可能是失败的，但我们发现从战术上讲，给产品功能或团队起一个编造的名字，有助于触及事物的本质，而不是从过去的工作经验或大众媒体中生搬硬套。

---

### [01:06:36] Lenny

**English:**
I love that. And it's very undo ... Like, you've got to undo it. It was-

**中文翻译:**
我喜欢这个。这是一种“撤销”……你必须撤销那些固有观念。

---

### [01:06:41] Josh Miller

**English:**
Exactly.

**中文翻译:**
没错。

---

### [01:06:42] Lenny

**English:**
It's a two-way door. And I like just the vision, the value you have of just prototyping things and whatever. It didn't work. Let's go back to what everyone else is doing. You mentioned great product and there was something I definitely wanted to chat a bit about, which is just, there's this group of companies who are just focused on, "Let's just build the most amazing product experience." And I feel like The Browser Company is at the forefront in a lot of this. But it's like you guys, Linear, Raycast is this product, Cron. There's probably a few more and I'd love to actually hear if there's others that I'm not thinking about. That are just obsessed with the user experience and less focused on drive metrics, drive revenue.

**中文翻译:**
(01:06:42): 这是一个“双向门”。我喜欢你们这种原型驱动的价值观：如果行不通，大不了回到大家都在做的方式。你提到了伟大的产品，我确实想聊聊这个：现在有一批公司专注于“打造最惊艳的产品体验”。我觉得 The Browser Company 走在这一趋势的前沿。还有像 Linear、Raycast、Cron 这样的公司。可能还有更多，我很想听听你还知道哪些。这些公司痴迷于用户体验，而不太关注驱动指标或营收。

---

**English:**
(01:07:24): And I'm curious, just where do you think this goes? What's your take on this trend? Why isn't every company thinking this way? Or is this just like, "We don't know if this is a good idea in the end?" So what's your take on this cohort of just like, "We're just going to build the best possible product and hope it all works out,"?

**中文翻译:**
(01:07:24): 我很好奇，你觉得这一趋势会走向何方？你对这种趋势有什么看法？为什么不是每家公司都这么想？或者这只是因为“我们不确定这最终是否是个好主意”？你对这群“只管打造最好的产品，然后希望一切顺利”的公司有什么看法？

---

### [01:07:41] Josh Miller

**English:**
Yeah. Well, I'll say first, I love those products, or many of those products you mentioned. There's some I haven't really used. But, for example, our company runs on Linear, and has run on Linear since day one. So, I'm a big fan of that. So, the way that we think about it is ... So, I actually spent two years at a venture capital firm as an investor, called Thrive Capital. They've invested in Slack and GitHub and a lot of really transformative companies. But I was an investor there. I was a venture capitalist. It even feels weird to say that. And I learned a lot. A lot. A lot. A lot from that experience. It has made me, I think, a better CEO and a better product leader. And one of the things I learned is different ideas, product ideas, business ideas, company ideas come with different attributes and things that will matter to their success.

**中文翻译:**
(01:07:41): 首先，我非常喜欢你提到的那些产品。比如我们公司从第一天起就在用 Linear。关于这一点，我曾在 Thrive Capital 做过两年投资人，他们投资了 Slack、GitHub 等变革性公司。那段经历让我学到了很多，让我成为了更好的 CEO 和产品领导者。我学到的一点是：不同的想法、产品、业务和公司带有不同的属性，决定它们成功的因素也各不相同。

---

**English:**
(01:08:34): And so, when thinking about starting The Browser Company and picking this category of software, Hursch and I were incredibly intentional about what that would mean for what would need to matter for our company. And so, if you think about the web browser category, traditionally ... I'm not saying forward facing, I'm not saying it is what we are doing. But, if you were to look backwards and take The Browser Company out of it, and look at the web browser category, you'd notice a few things. The first is, it's actually one of the most consumer pieces of software out there. People forget that. That's the opportunity to us. If you ask someone in the street, "What's your web browser? What do you think?" They either won't know or they won't care, "[inaudible 01:09:15]. I don't know."

**中文翻译:**
(01:08:34): 所以，在创办 The Browser Company 并选择这个软件类别时，我和 Hursh 非常清楚这对我们公司意味着什么。如果你回顾浏览器这个类别（不看我们正在做的），你会发现几件事：第一，它实际上是现存最“大众消费级”（consumer）的软件之一。人们常忘了这一点，而这正是我们的机会。如果你在街上问一个人：“你的浏览器是什么？你觉得它怎么样？”他们要么不知道，要么不在乎。

---

**English:**
(01:09:16): But what pieces of software do your parents, do your little nieces and nephews and you use? What's at the center of that Venn diagram? Your parents hopefully don't use TikTok and Instagram, or probably don't. Your nieces and nephews, I hope don't have a reason for email at the tender age of 16, or a calendar. And a web browser's one of the few things in the middle. So it's an incredibly universal piece of software consumer, unlike very few other things outside of a smartphone and messaging, and maybe video calling in 2023 and a web browser. So, it's very consumer, very universal.

**中文翻译:**
(01:09:16): 但是，你的父母、你的小侄子侄女和你都在用什么软件？那个韦恩图的中心是什么？你的父母可能不用 TikTok 或 Instagram；你的侄子侄女在 16 岁时可能还不需要频繁用邮件或日历。而浏览器是少数处于中心位置的东西之一。它是一种极其通用的消费级软件，除了智能手机、即时通讯和视频通话，几乎没有别的东西比它更通用了。

---

**English:**
(01:09:52): The second attribute is, it's a commodity. I'm not saying that Arc is a commodity or we want it to be, but objectively web browsers are interchangeable. They all do the same thing. Increasingly, they're literally just carbon copies of the exact same code chromium, with little tweaks, little tweaks around the edges. So, they're all the same. It's a commodity market. And they're unbelievably lucrative. Browsers print cash. There is a reason why they're owned primarily by Google, Apple and Microsoft. They're incredibly high margin, they're incredibly lucrative. Low marginal costs. The cost of revenue is incredibly low, et cetera, et cetera.

**中文翻译:**
(01:09:52): 第二个属性是：它是一种“大宗商品”（commodity）。我不是说 Arc 是商品，但客观上浏览器是可以互换的。它们的功能都一样，而且越来越多地只是 Chromium 核心代码的副本，只在边缘做了一点点调整。这是一个商品化市场。而且它们极其赚钱，简直是印钞机。这就是为什么它们主要由谷歌、苹果和微软拥有的原因。它们利润极高，边际成本极低。

---

**English:**
(01:10:30): So we have a product that everyone in the world uses, where they're all identical, essentially, interchangeable commodities. And if you can get people to use it, you're going to print money. So, the attributes of that business and that product category mean, you have to win on how much do people love your product and feel an emotional connection to it, and choose your brand, your product over the other, almost not rationally, but emotionally. And so, if you tie that back to everything I've said before, bingo! That is what we want to work on. That's what we want. We want to create emotional connection with people. We're creating that emotional connection with as many people as possible and delighting them with surprises and animations, is the way you win. It's not romantic, it is practical. In many ways it's capitalistic. This is how we win this market if you want to think about it that way.

**中文翻译:**
(01:10:30): 所以我们面对的是一个全世界都在用、本质上完全相同且可互换的产品。如果你能让人们使用它，你就能赚大钱。因此，这个业务和产品类别的属性意味着：你必须赢在“人们有多爱你的产品”、“是否与它有情感连接”，以及是否在情感上（而非理性上）选择你的品牌。如果你把这与我之前说的一切联系起来——宾果！这就是我们想做的。我们想与人建立情感连接。通过惊喜和动画让尽可能多的人感到愉悦，这就是获胜的方式。这不浪漫，这很实际。在很多方面，这甚至是资本主义式的：如果你想赢得这个市场，这就是方法。

---

**English:**
(01:11:30): The reason I hesitate to answer your question directly is, I don't think that applies to every category of software. And to be totally honest, I don't know enough about the ticketing space or the calendaring space or the whatever other space to know, honestly, off the cuff, if that approach is good for those industries. As a human being, at the other end, I'm really grateful that they picked some reason to do it, whether or not it is part of their business strategy or not. It's a really wonderful trend as a human at the other end that cares about feelings. But I would say, we actually think about it not as a, "We're focusing on the user experience over revenue or growth." We, in fact, picked a category of software we're focusing on brand and user experience is how you get growth and revenue.

**中文翻译:**
(01:11:30): 我之所以犹豫是否直接回答你的问题，是因为我不认为这适用于每一个软件类别。老实说，我不够了解票务、日历或其他领域，无法断言这种方法是否适合那些行业。作为用户，我很感激他们选择这样做。但我想说，我们并不认为自己是“为了用户体验而放弃营收或增长”，事实上，我们选择了一个“专注于品牌和用户体验正是获取增长和营收手段”的软件类别。

---

**English:**
(01:12:14): And, because we knew that this is who we are, and if we were building cybersecurity software that you sell to government agencies, they are not going to give a shit about rounded edges, or what color the button is, or how surprised you feel with every member update. So, we didn't build cybersecurity software to sell to the government. So, I hope that more people build things at the craft bar of something like Linear, but that's how we think about it, is less of a "this versus that," and more "could we pick something we're going to work on, where that's how you win."

**中文翻译:**
(01:12:14): 因为我们知道自己是谁。如果我们是在做卖给政府机构的网络安全软件，他们根本不会在乎圆角、按钮颜色或更新带来的惊喜。所以我们没去做政府安全软件。我希望更多人能以 Linear 那样的工艺标准来造东西，但我们的想法不是“体验 vs 营收”，而是“我们能否选择一个能靠体验获胜的领域”。

---

### [01:12:48] Lenny

**English:**
I think that's a really powerful insight, that for consumer software especially, and for commoditized consumer software especially, experience is a differentiator. You need to give people a reason to even try it, and then end up sticking with it when there's awesome alternatives. And so, just an obsession with the experience is a really smart strategy. If you get that right, people use it and continue to use it and you win.

**中文翻译:**
这是一个非常强大的洞察：特别是对于消费级软件，尤其是商品化的消费级软件，体验就是差异化因素。你需要给人们一个尝试的理由，并在有其他优秀替代品的情况下让他们留下来。因此，痴迷于体验是一个非常聪明的策略。如果你做对了，人们就会使用并持续使用，你就赢了。

---

### [01:13:13] Josh Miller

**English:**
I've seen this with a lot of ... And COVID is, I'm sure everyone listening, has a lot of the remote-work collaboration tools. A lot of them obsess, to their credit, over really interesting design details and product feature concepts that were imaginative and brought people together in new ways. And then the latency of the video of the audio audio was horrible, because they relied on some third-party API that was significantly worse than Zoom. And so, that's a great example where in that market, that category software, you better nail latency. I think a great example of this ... One of my favorite products these days, but past years is Tuple. It's ostensibly a paired programming tool that just lives in your menu bar. I'm not paired program with anyone. It is the fastest way to talk to someone at your company. And they have an unbelievably simple user experience.

**中文翻译:**
(01:13:13): 我在很多远程协作工具上见过这种情况。很多工具确实痴迷于有趣的设计细节和富有想象力的功能，以新颖的方式把人们聚在一起。但它们的音视频延迟非常糟糕，因为它们依赖于比 Zoom 差得多的第三方 API。这就是一个例子：在那个市场，你最好先搞定延迟。另一个例子是我最近很喜欢的 Tuple。它表面上是一个结对编程工具，但我并不跟人结对编程。它是与同事沟通最快的方式，用户体验极其简单。

---

**English:**
(01:14:00): The designer, based in Lyon, France, is incredible. It's a beautifully designed product. And it is the best audio quality I have ever experienced in a communication tool. Better than Zoom. So, that exact same product with all their craft details, sand latency, not going to do it. But also Tuple wouldn't have beat a lot of the other competitors for me if it wasn't unbelievably beautiful and easy and simple to use as well. So again, I think it's like, what are the attributes you need to win and picking a market that the ones that you want to excel at and work on, are key to that.

**中文翻译:**
(01:14:00): 它的设计师在法国里昂，非常出色。产品设计精美，而且它拥有我用过的通讯工具中最好的音质，比 Zoom 还好。如果同样的产品只有工艺细节而没有低延迟，那是行不通的。但如果 Tuple 不够美观、简单好用，它也无法击败其他竞争对手。所以，关键在于了解获胜所需的属性，并选择一个你擅长的属性正是获胜关键的市场。

---

### [01:14:34] Lenny

**English:**
And also how much better you need to be. Like, if there's a 20% better than Chrome product, people are just going, "That's fine. I don't need to learn something new and everyone's using something else. I'm just going to have all these problems." So, you got to be significantly better. And that's a high bar for consumer products. Final question I wanted to touch on. You talked about the big vision for Arc and The Browser Company. And you mentioned this idea of the internet computer. And this is another question Scott Belsky suggested. By the way, Scott is the CPO of Adobe and just an awesome product-thinker person. And he just wanted to make sure that we touch on this, because I think there's a big idea here that maybe people don't realize. So, if you could just give us a brief overview of, what is just the actual vision and plan for The Browser Company and Arc, long term as a final question?

**中文翻译:**
还有你必须比别人好多少。如果只比 Chrome 好 20%，人们会觉得：“没必要学新东西，反正大家都在用别的。”所以你必须显著地更好，这对消费级产品来说门槛很高。最后一个问题：你谈到了 Arc 和 The Browser Company 的宏大愿景，提到了“互联网计算机”的概念。这是 Scott Belsky（Adobe CPO）建议问的问题。他想确保我们聊到这个，因为这里面有一个大家可能还没意识到的宏大想法。你能简要概述一下 The Browser Company 和 Arc 的长期愿景和计划吗？

---

### [01:15:19] Josh Miller

**English:**
Yeah. So, we call it The Browser Company of New York almost as a misdirection, because as you know from the intro, we view Arc as a replacement for your default web browser, but we're hoping it will be much more. And so, to start at the highest level and bring it down to reality, one of the things that I've done many times in my career already is underestimate pretty foundational changes in how we use technology. I've appreciated them but underestimated them. Great example is mobile. I think me and Hursh's first company would've been much more successful if we really appreciated the tidal wave that was mobile. And I think one of those macro trends we're underestimating right now is the shift to cloud computing. The shift to the internet, which may sound weird because every big public company mentions Microsoft Azure or Amazon Web Services. You hear about cloud, cloud, cloud and cloud. But again, that's this business term.

**中文翻译:**
(01:15:19): 好的。我们叫“纽约浏览器公司”几乎是一种误导，因为如你所知，我们视 Arc 为默认浏览器的替代品，但我们希望它远不止于此。从最高层面来说，我在职业生涯中多次低估了技术使用方式的根本性变革。我欣赏它们但低估了它们。比如移动端，如果我和 Hursh 的第一家公司能真正意识到移动浪潮，会成功得多。我认为我们现在低估的一个宏观趋势是向“云计算”或“互联网”的转移。这听起来可能很奇怪，因为每家大公司都在提 Azure 或 AWS，到处都是“云”。但那只是商业术语。

---

**English:**
(01:16:13): What I mean by the shift to cloud computing is, everything in our technology, in our computing lives is moving to the internet. It has been moving, but it's going to move even more. And what I mean by that is, your applications are almost all today web-based, internet-based applications. And they will all be soon. There's very, very few pieces of truly local-only software or even local-first software left. All of our files are moving to the internet, if they're not all already there. So if you really think about your files today, and again you ignore the word "files," the stuff you need for work in your personal life. They're not sitting on your desktop, they're all URLs. It may be an air quote "PDF," but that PDF is probably out on Dropbox somewhere and you're accessing it as a URL.

**中文翻译:**
(01:16:13): 我所说的向云计算转移，是指我们计算生活中的一切都在向互联网转移。现在的应用几乎全是基于 Web 和互联网的，很快所有应用都会如此。几乎没有真正的纯本地软件或本地优先软件剩下了。我们所有的文件都在向互联网转移。如果你仔细想想你今天的文件（忽略“文件”这个词，指你工作生活所需的东西），它们不在你的桌面上，它们全是 URL。它可能是一个所谓的“PDF”，但那个 PDF 可能在 Dropbox 上，你通过 URL 访问它。

---

**English:**
(01:17:03): Your photos may seem like they're on your iPhone. They're not on your iPhone, they're on some iCloud server somewhere. When you get a new iPhone, they'll be right there. The manifestation of that actually is, if you smash your device that you're listening to this on right now, whether it's a phone or computer, other than being sad that you lost the resale value and there's a chore of replacing it and a cost of replacing it, you would not lose any of your stuff. So, imagine in five years our entire computing lives are not on our devices, on our computers, on our phones. They're out there somewhere. They're out in the internet, they're out in the cloud, which begs the question ... I remember when I was 10 and I got my first computer. It was a see-through iMac. And I wonder ... My son is two. When he's 10, what will his computer be?

**中文翻译:**
(01:17:03): 你的照片看起来在 iPhone 上，其实是在 iCloud 服务器上。当你换新手机时，它们就在那里。这体现为：如果你现在把你听播客的设备砸了，除了损失转售价值和更换成本外，你不会丢失任何东西。想象一下，五年后，我们的整个计算生活都不在设备上，而是在互联网或云端的某个地方。这引出了一个问题：我 10 岁时有了第一台电脑，那是台透明的 iMac。我儿子现在两岁，当他 10 岁时，他的“电脑”会是什么？

---

**English:**
(01:17:52): And I mean computer not in the technical ... Again, going back to words and the words that we use. I don't mean computer in the literal sense of my MacBook Air, but computer in the human sense of, what you need from your computer, your stuff, your applications and tools that people ... Where is that going to be? Where is his computer going to be? I think it's obvious at this point that we're going to have airflow computers everywhere. We already do. My car has CarPlay, my TV is a computer, my laptop is a computer. I think that's going to be even more true in five years, where hardware is commoditizing. And it will commoditize even more. They're becoming empty shells that don't have anything on it. They're just vessels. They're just interfaces to viewing our real computer, which is out there on the internet somewhere. And so, our view is that what we are building at The Browser Company is an internet computer, is a air quote "computer," where the move to the internet and move to the cloud accelerates and continues the tsunami as much as we think it will.

**中文翻译:**
(01:17:52): 我说的“电脑”不是技术意义上的 MacBook Air，而是人性意义上的：你的东西、你的应用和工具。他的电脑会在哪里？显然，未来到处都是电脑。我的车有 CarPlay，电视是电脑，笔记本也是电脑。五年后硬件会更加商品化，变成空壳，只是查看我们“真实电脑”（即互联网上的东西）的容器和接口。所以，我们的观点是，我们在 The Browser Company 构建的是一台“互联网计算机”，随着向互联网和云端的转移加速，它将成为这种趋势的接口。

---

**English:**
(01:18:57): And the way we represent that is, we say we want to be to the web browser, what the iPhone was to the cell phone. Yes. The iPhone replaced your cell phone, but it really was something much more. And so, we want Arc to be the iPhone for the internet, and that yes, it replaces your default browser. But whether or not we call it the internet computer or something else, it really is that interface, this new type of computer. If you play that one step forward, then what we're building today is, we're building our equivalent of multi-touch gestures and the first party-notes app. But, on any new computer, any computer or computing device, the developer platform itself is much more interesting and lucrative and world changing than the first-party computer itself. And so, we have no doubt that in the next decade, if we're successful, if we still exist, Arc as a development platform is going to be much more central to what we're doing, building on top of these internet computers, ours and others than anything else.

**中文翻译:**
(01:18:57): 我们的表达方式是：我们想成为浏览器的“iPhone”。iPhone 替代了手机，但它远不止于手机。我们希望 Arc 成为互联网的 iPhone。无论我们叫它互联网计算机还是别的，它都是那种新类型的接口。往后看一步，我们今天在做的相当于“多点触控手势”和“原生笔记应用”。但在任何新电脑上，开发者平台本身比第一方电脑更有趣、更赚钱、更能改变世界。我们坚信，如果未来十年我们还存在，Arc 作为一个开发者平台将成为核心。

---

**English:**
(01:20:00): So to bring that down from reality. If you think about it, the internet, the web, is really the best development platform out there in many ways. It is accessible on every single device. It doesn't matter who makes it or the shape and size. It is free to access for individuals. You don't need money to access it. It's free for developers. You don't have to pay a license to use it. There's no 30% tax on what you make. And it's democratic. The best frameworks can win. And so, in many ways, if you were to say, "Hey, in this future we want to see, what is the platform that we should be developing on top of, what has the best attributes?" The web has that. And that's why you're seeing today. Why do you think Figma is in the web browser?

**中文翻译:**
(01:20:00): 回到现实。互联网（Web）在很多方面是最好的开发平台。它在任何设备上都可访问，无论品牌或形状。个人访问是免费的，开发者使用也是免费的，不需要支付许可费，也没有 30% 的“苹果税”。它是民主的，最好的框架能胜出。如果你问未来最好的开发平台是什么，Web 具备所有这些属性。这就是为什么 Figma 会在浏览器里。

---

**English:**
(01:20:41): Why do you think Figma's blog post was "Meet us in the Web Browser"? Because as the development platform, developers cross platform in one click. There's no tax. Everyone should want to and wants to make for the web. The challenge, though, is there's an experience gap. Native software feels better for whatever reason. And the problem is the people that control our interfaces to this development platform that is the web, that is the internet, have incentives to keep it from being as good as local software, from truly native, immersive software. Apple? They don't want you making web apps or applications for the web. They want you making them for the Mac and the iPhone so they can taxi you when you do it through the app store. And also surprisingly, Google doesn't want you making stuff, more native and immersive for the air quote "Web," because they want it to be indexed by their search engine.

**中文翻译:**
(01:20:41): 为什么 Figma 的博客标题是“在浏览器中见”？因为作为开发平台，开发者可以一键跨平台，且没有税收。大家都想为 Web 开发。但挑战在于存在“体验差距”，原生软件感觉更好。问题在于，控制 Web 接口的人（巨头们）有动力阻止 Web 变得像原生软件一样好。苹果不希望你做 Web App，他们希望你为 Mac 和 iPhone 做 App，这样他们就能收税。令人惊讶的是，谷歌也不希望你做太原生、太沉浸的 Web 体验，因为他们希望内容能被搜索引擎索引。

---

**English:**
(01:21:37): So, there's a reason that the Chrome extension platform is one of the most underutilized opportunities. They view it as a loss leader. They built chrome extensions just so they could have parity with Firefox. They don't want you making extensions, because you have some immersive extension experience that's not something that you could index in Google. And that's taking away from doing searches. And so, I think we look at this and say, everything is heading to the internet, which means we need interfaces to the internet that are truly more robust than a browser, that are more of a computer. And if we do that, then the most interesting opportunity on top of that is actually the things other people were built on top of this development platform. And if you look at this development platform, which exists today, the worldwide web, the open internet, what is missing is an interface and a set of capabilities and APIs to make web-based experiences as immersive and rich and powerful as native experiences, which require that interface to the internet to provide those.

**中文翻译:**
(01:21:37): 所以 Chrome 扩展平台一直没被充分利用。谷歌把它看作“引流产品”，只是为了和 Firefox 竞争。他们不希望你做沉浸式的扩展，因为那没法被索引，会减少搜索量。我们认为，一切都在流向互联网，这意味着我们需要比浏览器更强大、更像电脑的接口。如果我们做到了，最有趣的机遇就是别人在这个平台上构建的东西。目前的 Web 缺少的是一套能让 Web 体验像原生体验一样丰富、强大的接口和 API。

---

**English:**
(01:22:34): And our interfacers to the internet today are the web browser companies. They have perverse business model incentives as big public companies that have lost the soul of the founders, that they don't want to do that. They don't want to do that. So it doesn't mean we're going to do it. And in fact one of them may win. And I actually think that this is something [inaudible 01:22:51]. We're trying to sell anyone in our vision. We feel fully confident there are going to be many types of internet computers and Arc may or may not be one of them. But we feel very confident that that is the future and the development platform on top of the web and the internet, and these new interfaces will be the most exciting opportunity.

**中文翻译:**
(01:22:34): 今天的互联网接口掌握在浏览器公司手中。作为失去了创始人灵魂的大型上市公司，他们的商业模式激励机制是扭曲的，他们不想这么做。这不代表我们一定能成，也许巨头之一最终会赢。我们不是在向谁推销愿景，但我们坚信未来会有多种“互联网计算机”，Arc 可能是其中之一。我们确信这就是未来，而基于 Web 和新接口的开发平台将是最令人兴奋的机会。

---

### [01:23:09] Lenny

**English:**
My next question was going to be how do we make money with a browser, which people get for free, really well? And now it makes a lot more sense where y'all are going. And so, with that, we have reached our very exciting lightning round. I've got six questions for you. Are you ready?

**中文翻译:**
我本来想问浏览器是免费的，你们怎么赚钱？现在听了你的解释，我明白你们的方向了。那么，我们进入激动人心的闪电问答环节。我有六个问题，准备好了吗？

---

### [01:23:26] Josh Miller

**English:**
Ready.

**中文翻译:**
准备好了。

---

### [01:23:27] Lenny

**English:**
Okay. So, ready? What are two or three books that you recommend most to other people?

**中文翻译:**
好。你最推荐给别人的两三本书是什么？

---

### [01:23:34] Josh Miller

**English:**
Harold and the Purple Crayon, Seeing Is Forgetting the Name of the Thing One Sees, which is a book about Robert Irwin. That's my number one PM book. So, if you're asking from the perspective of the disciplines of people listening, that book is absolutely fantastic. And then God Saved Texas by Lawrence Wright, who's one of my favorite authors, who if you're interested in road trips, politics, food, culture. So, three very different types of books.

**中文翻译:**
《阿罗有枝彩色笔》（Harold and the Purple Crayon）、《看见即忘掉所见之物的名字》（Seeing Is Forgetting the Name of the Thing One Sees，关于艺术家 Robert Irwin 的书，这是我心目中排名第一的 PM 书籍，非常棒）。还有 Lawrence Wright 的《上帝保佑德克萨斯》（God Save Texas），如果你对公路旅行、政治、美食和文化感兴趣的话。三本完全不同类型的书。

---

### [01:23:58] Lenny

**English:**
What's a favorite recent movie or TV show?

**中文翻译:**
最近最喜欢的电影或电视剧？

---

### [01:24:01] Josh Miller

**English:**
The first TV show episode I've cried from in recent memories, episode three of The Last of Us. I thought I was watching a zombie violence thing and I just was sitting there bawling. So that one. And then I've been re-watching all of the Adam Curtis documentaries on YouTube. I'm a huge Adam Curtis fan.

**中文翻译:**
最近唯一让我看哭的剧是《最后生还者》（The Last of Us）第三集。我本以为是在看丧尸暴力片，结果坐在那儿嚎啕大哭。还有我一直在 YouTube 上重看 Adam Curtis 的所有纪录片，我是他的超级粉丝。

---

### [01:24:20] Lenny

**English:**
I have not heard of Adam Curtis. I will have to go check that out.

**中文翻译:**
我没听说过 Adam Curtis，我得去看看。

---

### [01:24:23] Josh Miller

**English:**
Hyper-normalization is my favorite. And I would view his work as less non-fictional documentaries and more video art.

**中文翻译:**
《超正规化》（Hyper-normalization）是我最喜欢的。与其说他的作品是纪实纪录片，不如说是视频艺术。

---

### [01:24:32] Lenny

**English:**
There's been a meme of everyone saying White Lotus is the show to watch. And I feel like it's about to transition to Last of Us. And so we will see how that goes.

**中文翻译:**
之前大家都在刷《白莲花度假村》，我觉得现在要转到《最后生还者》了。

---

### [01:24:40] Josh Miller

**English:**
Can I get it first? Was I the first guest to say it?

**中文翻译:**
我是第一个提到它的嘉宾吗？

---

### [01:24:43] Lenny

**English:**
I think you might be actually. I forget, but I think you might be.

**中文翻译:**
我想你可能是。我忘了，但很有可能。

---

### [01:24:45] Josh Miller

**English:**
All right. Well, I'll say episode three, specifically.

**中文翻译:**
好吧，我特别推荐第三集。

---

### [01:24:47] Lenny

**English:**
Yeah. Yeah. Absolutely. People love that one. But every episode's awesome. Next question. Favorite interview question you like to ask people when you're interviewing them?

**中文翻译:**
是的，大家都爱那一集，不过每一集都很棒。下一个问题：面试时你最喜欢问的问题？

---

### [01:24:56] Josh Miller

**English:**
What would you like to ask me? That seems like a non-answer, but my interviews at Browser Company are all, "Ask me anything," and I find what people ask, and how they follow up, is as revealing about who they are and what they care about than anything I could ask them.

**中文翻译:**
“你想问我什么？”这听起来不像个答案，但我在 The Browser Company 的面试全是“随便问我”。我发现人们问什么以及如何追问，比我问他们任何问题都能更真实地反映他们是谁以及他们在乎什么。

---

### [01:25:12] Lenny

**English:**
What is it that you look for in an answer that tells you, okay, this is a good candidate?

**中文翻译:**
你在他们的回答中寻找什么特质来判断这是一个优秀的候选人？

---

### [01:25:17] Josh Miller

**English:**
Authenticity, probably more than anything else. Do they really believe what they're saying?

**中文翻译:**
真实性（Authenticity），这比什么都重要。他们真的相信自己所说的话吗？

---

### [01:25:21] Lenny

**English:**
Awesome. What are some SASS products that your company uses and loves, other than ... ? I don't know if you consider our SASS, but probably not. So, yeah.

**中文翻译:**
太棒了。你们公司使用并喜爱的 SaaS 产品有哪些？（除了 Arc 之外）

---

### [01:25:29] Josh Miller

**English:**
I want to plug Tuple. I think I'm going to put everything on Tuple, relative to ... We run on Notion, we love Notion, we love Linear. But I'd say the closet hit that I just cannot believe is not a hundred times larger company is Tuple. It is ostensibly a pair programming tool, but don't go in with that mindset. Go in with, "I need to talk to a colleague right now," or "a couple of colleagues right now, to do some work together," and it is absolutely fantastic.

**中文翻译:**
我想安利 Tuple。我们用 Notion，也爱 Notion 和 Linear。但我认为最被低估、简直不敢相信它规模没大一百倍的公司是 Tuple。它表面上是结对编程工具，但别带着那个观念去用。把它当成“我现在需要立刻和一两个同事沟通并一起干活”的工具，它简直太棒了。

---

### [01:25:58] Lenny

**English:**
I love it. I love these products I've never heard of that are super cool. We will link to that. Next question. What's something relatively minor you've changed in how you build product, that has had a significant impact in your team's ability to ship and execute?

**中文翻译:**
我喜欢这种没听说过但超酷的产品。我们会放上链接。下一个问题：在构建产品方面，你做了哪些相对微小但对团队发布和执行能力产生重大影响的改变？

---

### [01:26:11] Josh Miller

**English:**
This past January, a couple months ago, we have started removing me from a lot of the product development process, which seems to be really healthy. So, that has been the big shift this year.

**中文翻译:**
就在今年一月，几个月前，我们开始把我从很多产品开发流程中剔除出去，这看起来非常健康。这是今年最大的转变。

---

### [01:26:22] Lenny

**English:**
That's a big transition. I went through that at Airbnb and it's great. It's great for everyone. Final question. Best pro-tip for using Arc, that people may not be aware of?

**中文翻译:**
这是一个重大的转变。我在 Airbnb 也经历过，这对每个人都好。最后一个问题：关于使用 Arc，大家可能不知道的最佳进阶技巧（pro-tip）？

---

### [01:26:32] Josh Miller

**English:**
Try your best to not think of it as a browser. And have a beginner's mind about how it works and how you might use the internet.

**中文翻译:**
尽你所能不要把它当成一个浏览器。保持“初心”，去重新发现它是如何运作的，以及你该如何使用互联网。

---

### [01:26:40] Lenny

**English:**
Whoa! Big idea.

**中文翻译:**
哇！大格局。

---

### [01:26:42] Josh Miller

**English:**
Yeah. Big takeaway from this conversation, we got to get much better at describing what the heck we built. And why it's good for you. So, I'm not proud of my first or last answer, but it is what it is.

**中文翻译:**
是的。这次谈话的一大收获是：我们必须更擅长描述我们到底造了个什么玩意，以及为什么它对你有好处。虽然我对第一个和最后一个回答不太满意，但事实就是这样。

---

### [01:26:54] Lenny

**English:**
And, actually, I mentioned this in the intro and if you listen to this already, you probably heard it already, but we're going to link ... In the show notes, we'll have a link to actually get into Arc, because right now it's wait-listed and we have this link that will get you straight into Arc. And so go check it out. Josh, you've shown up with heartfelt intensity. I feel like I want to go apply for a job at The Browser Company now. But you're not hiring product managers, so I'm not going to do that. Just kidding. Thank you so much for being here, for being so genuine and insightful and warm. And thank you.

**中文翻译:**
我在开头提到过，Arc 目前是需要排队的，但我们在简介里放了一个可以直接进入 Arc 的链接。去试试吧。Josh，你展现了满腔的热忱。我觉得我现在都想去 The Browser Company 应聘了，但既然你们不招 PM，那就算了（开玩笑）。非常感谢你来到这里，如此真诚、深刻且温暖。谢谢。

---

### [01:27:29] Josh Miller

**English:**
Thank you so much, Lenny. I really enjoyed this.

**中文翻译:**
非常感谢，Lenny。我很享受这次谈话。

---

### [01:27:33] Lenny

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcast, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review, as that really helps other listeners find the podcast. You can find all past episodes, or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
感谢收听。如果你觉得有价值，可以在 Apple Podcast、Spotify 或你喜欢的应用中订阅。也请考虑给我们评分或留下评论，这能帮助更多听众找到我们。你可以在 lennyspodcast.com 找到所有往期节目。下期再见。