# Judd Antin - Lenny's Podcast

---

# Judd Antin - Lenny's Podcast：用户研究的“大清算”与重生

---

## 🎙️ 主持人介绍

**Lenny Rachitsky**
- **身份**: 前 Airbnb 产品负责人，硅谷顶级产品管理专家
- **背景**: 在 Airbnb 工作 7 年，负责 Supply Growth 团队，曾带领团队实现房源量从数十万到数百万的突破。
- **现状**: 运营全球排名第一的产品管理 Newsletter（60万+订阅者）和播客，是产品经理圈最具影响力的人物之一。
- **社交媒体**:
  - Twitter/X: [@lennysan](https://twitter.com/lennysan)
  - LinkedIn: [Lenny Rachitsky](https://www.linkedin.com/in/lennyrachitsky/)
  - Newsletter: [Lenny's Newsletter](https://www.lennysnewsletter.com/)
  - Podcast: [Lenny's Podcast](https://www.lennyspodcast.com/)

---

## 🎤 嘉宾介绍

**Judd Antin**
- **身份**: 全球顶尖用户研究（UXR）领袖，前 Airbnb 研究负责人
- **职业经历**:
  - **Airbnb**: 曾两度担任研究负责人（Head of Research），并担任设计工作室负责人（Head of Design Studio），管理涵盖设计、研究、写作和本地化的多元团队。
  - **Meta (Facebook)**: 早期成员，帮助建立了 Facebook 的用户研究体系。
  - **UC Berkeley**: 拥有信息管理与系统博士学位，目前在伯克利任教。
- **当前身份**: 独立顾问，专注于组织挑战、产品策略、设计研究及危机管理。
- **核心专长**: 用户研究体系搭建、产品策略、设计领导力、跨职能团队整合。
- **社交媒体**:
  - LinkedIn: [Judd Antin](https://www.linkedin.com/in/juddantin/)
  - Medium/Newsletter: [One Big Thought](https://www.onebigthought.com/)
  - 个人网站: [juddantin.com](https://juddantin.com/)

---

## 📝 内容概要

本期节目深入探讨了 Judd Antin 引起行业轰动的文章《用户研究的清算已至》。Judd 指出，过去 15 年的用户研究模式正在“死亡”。他尖锐地提出了“用户中心化表演”（User-Centered Performance）的概念，揭示了许多公司如何将研究作为一种象征性的姿态，而非真正的决策工具。

Judd 提出了一个全新的框架，将研究分为宏观（Macro）、中程（Middle Range）和微观（Micro），并指出目前行业过度沉溺于低效的“中程研究”。他呼吁研究员必须具备商业头脑，关注利润和漏斗指标，并提出了优秀研究员必备的“五大工具”。这不仅是对研究员的警示，也是对产品经理（PM）和设计领导者如何正确使用研究力量的深度指南。

---

## 🏷️ 核心话题

`用户研究(UXR)` `产品策略` `用户中心化表演` `商业影响力` `NPS批判` `团队协作`

---

## 💡 核心论点

### 论点一：警惕“用户中心化表演”（User-Centered Performance）

**核心观点**: 许多公司所谓的“以用户为中心”只是一种象征性的信号，而非为了改变决策。

- **定义**: 为了向同事或高层展示“我们很在乎用户”而进行的研究，通常在决策已经做出后才介入。
- **典型特征**: PM 在产品发布前夕要求研究员“快速验证一下假设”，这本质上是“走过场”（Check the box），而非寻求被证伪。
- **危害**: 这种表演浪费了大量资源，却无法产生真正的业务影响，导致研究职能在裁员潮中首当其冲。

> "User-centered performance refers to customer obsession or user-centered practice that is symbolic rather than focused on learning... It's work we do to signal to each other how customer obsessed we are, not because we want to make a different decision."
> — Judd Antin

### 论点二：研究的三层框架与“中程研究”的陷阱

**核心观点**: 研究员应减少模糊的“中程研究”，转向更有价值的宏观策略和微观优化。

- **宏观研究 (Macro)**: 关注大局、业务战略、未来创新和市场竞争。它直接影响年度计划和公司走向。
- **微观研究 (Micro)**: 关注具体的产品细节、可用性测试、AB 测试结果分析。它能产生直接的、可衡量的业务价值（如：Airbnb 的“百万美元按钮”案例）。
- **中程研究 (Middle Range)**: 处于中间地带，问题不够具体（如“房东对支付的感受”）。这类研究往往很有趣，但难以转化为行动，且最容易触发“事后聪明偏误”（Hindsight Bias）。

### 论点三：研究员必须具备“商业/利润”思维

**核心观点**: 研究员不应只谈同理心，必须学习财务报表和业务指标。

- **打破孤岛**: 研究员应该阅读季度财报、听股东电话会议，理解公司的 OKR 和转化漏斗。
- **寻找交集**: 优秀的研究发生在“用户需求”与“商业利润”的交集点。
- **语言对齐**: 如果研究员不能用 PM 和高层理解的业务语言（如：流失率、客单价、市场份额）进行沟通，其影响力将永远受限。

---

## ✅ 数据验证结果

**验证项 1**: 亨利·福特（Henry Ford）的名言：“如果我问用户想要什么，他们会说想要更快的马。”
- 原文声称: Judd 指出这句名言是伪造的（Apocryphal）。
- 验证结果: ✅ 确认。
- 来源: [Harvard Business Review](https://hbr.org/2011/08/henry-ford-never-said-the-fast) 调查显示，没有任何历史记录证明福特说过这句话，它最早出现在 20 世纪末。
- 可信度: ⭐⭐⭐

**验证项 2**: NPS（净推荐值）的科学性质疑。
- 原文声称: NPS 在测量科学上存在缺陷（0-11量表不科学、精度在7项后下降），CSAT（客户满意度）更有效。
- 验证结果: ✅ 确认。
- 来源: [Journal of Marketing](https://journals.sagepub.com/doi/abs/10.1509/jmkg.71.3.039) 的多项研究表明，NPS 在预测公司增长方面并不优于其他指标，且其计算方式（推荐者减去批评者）损失了大量原始数据信息。
- 可信度: ⭐⭐⭐

**验证项 3**: 用户研究员在 2023-2024 裁员潮中受损严重。
- 原文声称: UXR 是裁员中受打击最严重的职能之一。
- 验证结果: ✅ 确认。
- 来源: [Layoffs.fyi](https://layoffs.fyi/) 及行业观察显示，随着 ZIRP（零利率政策）时代结束，许多公司缩减了被视为“非核心/服务型”的 UXR 团队。
- 可信度: ⭐⭐⭐

---

## 🎯 四维分类评估

### 🟢 高度正确（已验证/权威来源）

**观点 1**: **证伪（Falsify）而非验证（Validate）**。
- 验证依据: 科学方法论的核心（波普尔证伪主义）。真正的研究应寻找“我们哪里错了”，而非寻找支持现有偏见的证据。

**观点 2**: **可用性测试（Micro Research）能带来直接收益**。
- 验证依据: Airbnb 的“修改按钮文字增加百万收入”案例是典型的转化率优化（CRO）实践。

### 🔵 当下可执行（有明确步骤）

**建议 1**: **建立研究员的“五大工具箱”**。
- 可执行性: 高
- 执行方法: 掌握 1. 形成性研究 2. 评估性研究 3. 严谨的问卷设计 4. 应用统计学 5. SQL/数据看板/AI 提示工程。

**建议 2**: **PM 邀请研究员参与决策全过程**。
- 可执行性: 中（取决于组织文化）
- 执行方法: 不要只在最后阶段找研究员，要让他们参与年度计划制定，共同背负业务指标。

### 🟡 理智质疑（需验证）

**存疑点**: **初创公司前 10 名员工是否应该有研究员？**
- 质疑原因: Judd 认为研究员能加速初创公司发展，但现实中大多数初创公司（如 Lenny 提到的 20 家 B2B 独角兽）在早期更倾向于招聘全栈工程师或产品设计师来兼顾研究。

### 🔴 需警惕（可能有问题）

**风险点**: **过度依赖数据而忽视直觉**。
- 风险说明: 虽然 Judd 强调研究的重要性，但他也承认“直觉”在产品开发中的地位。PM 若完全依赖研究报告而不敢做决策，会导致产品平庸化。

---

## 🔑 关键洞察

1. **研究员的成功指标**: 如果团队在没有研究员在场的情况下不敢开决策会议，说明研究员真正建立了影响力。
2. **事后聪明偏误**: 许多中程研究结论被 PM 评价为“我早就知道了”，这往往是因为研究没有提供足够的“意外感”或“证伪性”。
3. **AB 测试的局限**: AB 测试能告诉你“是什么”（结果），但不能告诉你“为什么”。研究员的价值在于解释“为什么”以指导未来的实验。
4. **民主化研究的误区**: 任何人都能和用户聊天，但这不叫研究。缺乏方法论的访谈只会引入更多偏见（垃圾进，垃圾出）。
5. **NPS 的营销骗局**: NPS 是营销界最成功的营销案例，但在学术和测量科学上，它远不如简单的 CSAT 准确。

---

## 🛠️ 提到的工具/资源

**工具 1**: **SQL / Dashboards**
- 说明: 研究员必须能自己查询数据，不依赖数据分析师。

**工具 2**: **Prompt Engineering (AI)**
- 说明: Judd 认为这是现代研究员的“第五大工具”，利用 AI 处理定性数据和生成洞察。

**推荐阅读**:
- **《Thinking, Fast and Slow》** (Daniel Kahneman): 理解系统 1 和系统 2 思维，克服认知偏见。
- **《Everything is Obvious: Once You Know the Answer》** (Duncan Watts): 深度剖析常识陷阱和事后聪明偏误。
- **《Bad Leadership》** (Barbara Kellerman): 从反面学习领导力。
- **《Demon Copperhead》** (Barbara Kingsolver): 普利策奖小说，Judd 推荐用于培养深度同理心。

---

## 📋 行动建议

### 🚀 立即可做（今天）
- [ ] **检查你的研究请求**: 问自己：我是在寻求“验证”还是“证伪”？如果研究结果证明我是错的，我愿意改变决策吗？
- [ ] **阅读财报**: 如果你在大公司，下载最近一季度的财报，找出 3 个核心业务痛点。

### 📅 本周尝试
- [ ] **与研究员对齐指标**: 确保研究员和 PM 共享同一套 OKR，而不是各自为政。
- [ ] **简化问卷**: 考虑将复杂的 NPS 替换为简单的 CSAT 评分。

### 🔍 深入探索
- [ ] **研究“中程研究”的替代方案**: 尝试将模糊的调研转化为具体的“宏观趋势分析”或“微观可用性实验”。

---

## ⭐ 评分

**知识价值**: 9.5/10
- 彻底颠覆了传统 UXR 的定位，对行业现状的批判极其深刻。

**可执行性**: 8.5/10
- 提供了明确的工具清单和框架，但改变组织文化需要时间。

**商业潜力**: 9.0/10
- 强调研究与利润的结合，是提升产品团队 ROI 的核心逻辑。

**投入产出比**: 10/10
- 1 小时的对话涵盖了多年硅谷顶级公司的管理精髓。

**综合评分**: **9.3/10**

---

## 📚 参考来源

- [Lenny's Podcast Official](https://www.lennyspodcast.com/the-user-research-reckoning-is-here-judd-antin-airbnb-meta/)
- [Judd Antin: The User Research Reckoning is Here (Article)](https://www.onebigthought.com/the-user-research-reckoning-is-here/)
- [Judd Antin LinkedIn](https://www.linkedin.com/in/juddantin/)

---
*来源*: Lenny's Podcast
*嘉宾*: Judd Antin
*生成时间*: 2024-05-20 (基于 2024 年初访谈内容分析)