# Judd Antin - 双语对照

This is the complete bilingual transcript of Lenny’s Podcast featuring Judd Antin.

---

### [00:00:00] Judd Antin

**English:**
User-centered performance refers to customer obsession or user-centered practice that is symbolic rather than focused on learning. It's hugely common, I would argue. It's work we do to signal to each other how customer obsessed we are, not because we want to make a different decision. If your listeners are like, "I don't do that." I'm like, "Think about it for a second. This is extremely common." Every time a PM comes to a researcher at the end of a product process and says, "Can you just run a quick user study just to validate our assumptions," that's user-centered performance. It's too late to matter. We got to ship it. What they want is to check the box. One of my big mantras was, "We don't validate, we falsify. We are looking to be wrong." Many PMs, many designers are not in that place. They do not want to be wrong. They're looking to validate, and that's user-centered performance.

**中文翻译:**
“以用户为中心的表演”（User-centered performance）指的是那种象征性的、而非以学习为目的的“客户至上”或“以用户为中心”的实践。我认为这极其普遍。这种工作的目的是向彼此发出信号，展示我们是多么关注客户，而不是因为我们真的想据此做出不同的决策。如果你的听众觉得，“我才不干那种事”，我会说：“再仔细想想，这太常见了。” 每当产品经理（PM）在产品流程结束时去找研究员说，“你能快速做一个用户研究来验证一下我们的假设吗？”，这就是“以用户为中心的表演”。因为这时候已经太晚了，起不到作用，产品必须发布了。他们想要的只是“勾选这个选项”（走个过境）。我的一个重要座右铭是：“我们不验证，我们证伪。我们是在寻找自己错误的地方。” 许多 PM 和设计师还没达到这种境界。他们不想出错，他们只想寻求验证，这就是“以用户为中心的表演”。

---

### [00:00:54] Lenny

**English:**
Today my guest is Judd Antin. Judd helped build the user research practice at Facebook. He was a longtime head of research at Airbnb, and his direct reports have gone on to lead research teams at Figma, Notion, Slack, Robinhood, Duolingo, Faire, and other amazing companies. These days, Judd spends his time consulting, helping companies with organizational challenges, product strategy, design, research, hiring, onboarding, and crisis management. In our conversation, we unpack a conclusion that Judd has come to recently about how the user research field is going through a reckoning and what needs to change both within the user research field and how companies leverage user research going forward.

**中文翻译:**
今天的嘉宾是 Judd Antin。Judd 曾协助建立了 Facebook 的用户研究实践。他曾长期担任 Airbnb 的研究负责人，他的直属下属后来纷纷在 Figma、Notion、Slack、Robinhood、Duolingo、Faire 等优秀公司领导研究团队。如今，Judd 专注于咨询工作，帮助公司解决组织挑战、产品策略、设计、研究、招聘、入职培训以及危机管理。在我们的对话中，我们将拆解 Judd 最近得出的一个结论：用户研究领域正在经历一场“大清算”（reckoning），以及用户研究领域内部以及公司未来如何利用用户研究方面需要做出哪些改变。

---

### [00:01:37] Lenny

**English:**
Judd shares what the user research field has gotten wrong over the last decade, how PMs and designers rely on user research too often, and to answer the wrong questions, where user research will continue to provide significant value, and how to best leverage your researchers, why it's important for researchers to think about the business goals more versus just what the users need, what to look for when you're hiring a user researcher, how PMs can be better partners to researchers, and also a phenomenon that I love that Judd describes and often witnesses, that he calls user-centered performance, where everyone acts like they care about the user, but they're just doing it for show and already know what they want to do. This episode has a lot of spicy takes and will probably upset some people, but Judd is sharing some real talk, here, that I think we all need to hear. With that, I bring you Judd Antin after a short word from our sponsors.

**中文翻译:**
Judd 分享了过去十年用户研究领域犯下的错误；PM 和设计师如何过于频繁地依赖用户研究去回答错误的问题；用户研究将在哪些方面继续提供重大价值；以及如何最好地利用你的研究员。他还谈到了为什么研究员更多地考虑业务目标（而不仅仅是用户需求）至关重要；招聘用户研究员时应看重什么；PM 如何成为研究员更好的合作伙伴；以及一个我非常喜欢的、Judd 描述并经常见证的现象，他称之为“以用户为中心的表演”——即每个人都表现得好像很关心用户，但其实只是在作秀，心里早已有定见。本集有很多犀利的观点，可能会让一些人感到不快，但 Judd 在这里分享的是我认为我们大家都需要听到的“大实话”。在听完赞助商的简短介绍后，让我们欢迎 Judd Antin。

---

### [00:02:27] Lenny (Sponsor Break)

**English:**
This time of year is prime for career reflection and setting goals for professional growth. I always like to spend this time reflecting on what I accomplished the previous year, what I hope to accomplish the next year, and whether this is the year I look for a new opportunity. That's where today's sponsor Teal comes in. Teal provides you with the tools to run an amazing job search with an AI powered resume builder, job tracker, cover letter generator, and Chrome extension that integrates with over 40 job boards, Teal is the all-in-one platform you need to run a more streamlined and efficient job search and stand out in this competitive market. There's a reason nearly one million people have trusted Teal to run their job search. If you're thinking of making a change in the new year, leverage Teal to grow your career on your own terms. Get started for free at tealhq.com/lenny. That's tealhq.com/lenny.

**中文翻译:**
每年的这个时候都是反思职业生涯和设定职业增长目标的黄金时期。我总是喜欢花时间回顾去年取得的成就，展望明年的目标，并思考今年是否是寻找新机会的一年。这就是今天的赞助商 Teal 大显身手的地方。Teal 为你提供了一系列工具，助你开启精彩的求职之旅：包括 AI 驱动的简历构建器、职位追踪器、求职信生成器，以及可与 40 多个招聘网站集成的 Chrome 插件。Teal 是你在这个竞争激烈的市场中脱颖而出、实现更精简高效求职所需的一站式平台。近一百万人信任 Teal 来管理他们的求职过程是有原因的。如果你正考虑在新年做出改变，请利用 Teal 按你自己的方式发展职业生涯。访问 tealhq.com/lenny 免费开始使用。

---

### [00:03:18] Lenny (Sponsor Break)

**English:**
This episode is brought to you by Vanta, helping you streamline your security compliance to accelerate your growth. Thousands of fast-growing companies like Gusto, Calm, Quora, and Modern Treasury trust Vanta to help build scale, manage, and demonstrate their security and compliance programs, and get ready for audits in weeks, not months. By offering the most in-demand security and privacy frameworks such as SOC 2, ISO 27001, GDPR, HIPAA, and many more, Vanta helps companies obtain the reports they need to accelerate growth, build efficient compliance processes, mitigate risks to their businesses, and build trust with external stakeholders. Over 5,000 fast-growing companies use Vanta to automate up to 90% of the work involved with SOC 2 and these other frameworks. For a limited time Lenny's podcast listeners get $1,000 off Vanta. Go to vanta.com/lenny, that's V-A-N-T-A.com/lenny to learn more and to claim your discounts. Get started today. Judd, thank you so much for being here. Welcome to the podcast.

**中文翻译:**
本集节目由 Vanta 为您带来，Vanta 帮助您简化安全合规流程，加速业务增长。数千家快速成长的公司（如 Gusto、Calm、Quora 和 Modern Treasury）信任 Vanta，协助他们构建、扩展、管理和展示其安全合规计划，并在几周而非几个月内做好审计准备。通过提供最热门的安全和隐私框架（如 SOC 2、ISO 27001、GDPR、HIPAA 等），Vanta 帮助公司获得加速增长所需的报告，建立高效的合规流程，降低业务风险，并与外部利益相关者建立信任。超过 5000 家快速成长的公司使用 Vanta 自动完成 SOC 2 及其他框架高达 90% 的工作。在限定时间内，Lenny’s Podcast 的听众可享受 Vanta 1000 美元的优惠。访问 vanta.com/lenny 了解更多信息并领取折扣。今天就开始吧。Judd，非常感谢你能来。欢迎来到本播客。

---

### [00:04:22] Judd Antin

**English:**
Lenny, thanks for having me.

**中文翻译:**
Lenny，谢谢你邀请我。

---

### [00:04:24] Lenny

**English:**
It's my pleasure. So we actually worked together at Airbnb for many years. And as I was preparing for this, I realized how many of the people that you managed went on to do amazing things. So I'm just going to read a list of people that worked for you and what they do now. We had Matt Gallivan, who now leads research at Slack. We have Janna Bray, who leads research at Notion, Celeste Ridlen, who leads research at Robinhood. Rebecca Grey, who leads research at Faire, Hannah Pileggi, who I think was leading research at Duolingo, Louise Beryl, who leads research at Figma, and then Noam, who was leading research at Wealthfront. I think he moved on to something else. What a fricking crazy alumni community and group from this one team that you hired and incubated.

**中文翻译:**
这是我的荣幸。我们实际上在 Airbnb 共事了很多年。在准备这期节目时，我意识到你管理过的很多人后来都取得了惊人的成就。我来读一下曾为你工作过的人员名单以及他们现在的职位：Matt Gallivan，现在领导 Slack 的研究团队；Janna Bray，领导 Notion 的研究团队；Celeste Ridlen，领导 Robinhood 的研究团队；Rebecca Grey，领导 Faire 的研究团队；Hannah Pileggi，我记得她曾领导 Duolingo 的研究；Louise Beryl，领导 Figma 的研究团队；还有 Noam，曾领导 Wealthfront 的研究，我想他现在已经换了工作。你招聘并培养的这支团队，其校友圈和群体简直太疯狂了。

---

### [00:05:11] Judd Antin

**English:**
No, I've never looked at that list, but I'll tell you, I have been so privileged to work with all these amazing humans. I can't take credit for it. They're just outstanding people. And I'm glad the diaspora is out there, because these people, rock stars.

**中文翻译:**
不，我从来没仔细看过那份名单，但我告诉你，能与这些了不起的人共事是我的荣幸。我不能把功劳归于自己，他们本身就是非常优秀的人。我很高兴看到他们散布在各处，因为这些人都是业内的摇滚明星。

---

### [00:05:23] Lenny

**English:**
Okay. The main reason that I wanted to do a podcast episode with you is that you wrote this piece that was titled The User Research Reckoning is Here, which I understand caused quite a stir in the research community and I think adjacent communities. And let me just read one of your takeaways at the top of your post to give people a sense of what it was about. You wrote, "The user research discipline over the last 15 years is dying. The reckoning is here. The discipline can still survive and thrive, but we'd better adapt, and quick." Before we get into the meat of the piece, could you share a bit about just the reaction to this piece and maybe if it was a surprise and what you expected would happen when you put this out?

**中文翻译:**
好的。我想和你录制这期播客的主要原因是，你写了一篇题为《用户研究的大清算已经到来》（The User Research Reckoning is Here）的文章。据我所知，这篇文章在研究界以及相关领域引起了不小的轰动。让我读一下你文章开头的一个核心观点，让大家了解一下内容。你写道：“过去 15 年的用户研究学科正在走向消亡。大清算已经到来。这个学科仍然可以生存并繁荣，但我们最好尽快适应。” 在深入探讨文章实质内容之前，你能分享一下大家对这篇文章的反应吗？这是否让你感到意外？你发布它时预期的结果是什么？

---

### [00:06:06] Judd Antin

**English:**
Yeah, I was definitely surprised. I wrote it because I wanted to start a conversation about something I was thinking about. I didn't really know who would read it. And in the end it turned out a lot of people read it. I learned that using the word reckoning may have been a mistake because it inspires a lot of drama in a conversation that I wanted to be really productive and positive. Overall, I would say, though, that the response was very positive. It seemed to resonate with a lot of people who reached out to me. I spent a lot of time talking to teams, to designers, to researchers, but there were also a ton of critiques.

**中文翻译:**
是的，我确实感到很惊讶。我写这篇文章是因为我想就我一直在思考的一些事情发起一场对话。我当时并不知道谁会读它。结果证明，读它的人非常多。我意识到使用“大清算”（reckoning）这个词可能是一个错误，因为它在我原本希望是富有成效和积极的对话中引发了很多戏剧性的情绪。不过总的来说，反馈是非常积极的。很多联系我的人都表示产生了共鸣。我花了很多时间与团队、设计师和研究员交谈，但也收到了大量的批评。

---

### [00:06:43] Judd Antin

**English:**
I would say some of it was like people thought I was throwing research or researchers under the bus, like, "It's researchers' fault. We're doing it wrong." Which I don't believe at all. And that I wasn't taking responsibility as a research leader or a design leader myself. And the most interesting one I would say was the anti-capitalist crew, because one of my points that we'll talk about is that I think researchers need to be more profit focused. And there are a lot of people out there who, I think they think that's not cool or not research's job, and I'm like, "Well, what are we doing then, if we're not helping businesses succeed?" But that was the most surprising critique, for sure.

**中文翻译:**
我想说，有些批评认为我是在把研究或研究员“推下车”（甩锅），好像在说“这是研究员的错，我们做错了”。我完全不这么认为。还有人认为我作为研究领导者或设计领导者没有承担责任。我觉得最有趣的一类批评来自“反资本主义”阵营，因为我文章中的一个观点（我们稍后会谈到）是：我认为研究员需要更加关注利润。有很多人的想法是，觉得这“不酷”或者不是研究员的工作。我的反应是：“如果我们不帮助企业取得成功，那我们到底在干什么呢？” 但这确实是最令我惊讶的批评。

---

### [00:07:23] Lenny

**English:**
I've worked with some of those people who are just like, "Why are we growing? Why do we focus so much on growth? Why do we need to grow this business?"

**中文翻译:**
我也和那样的人共事过，他们会问：“我们为什么要增长？为什么我们要如此关注增长？我们为什么需要发展这项业务？”

---

### [00:07:29] Judd Antin

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:07:29] Lenny

**English:**
So I get that.

**中文翻译:**
所以我理解。

---

### [00:07:30] Judd Antin

**English:**
Maybe it's the wrong industry for them.

**中文翻译:**
也许这个行业不适合他们。

---

### [00:07:32] Lenny

**English:**
Yeah. I'm not a fan of that. Okay. Let's actually dig into the meat of your message, and the big takeaway, and the conclusion of what you're finding is happening in user research. And I know a lot of this comes from a lot of user researchers have been laid off at a lot of companies. It was one of the hardest hit teams. And so I think a lot of this comes from that. So yeah, so let's just start big and then see where it goes.

**中文翻译:**
是的，我也不太认同那种想法。好，让我们深入探讨你信息的核心内容、主要结论，以及你发现的用户研究领域正在发生的事情。我知道这很大程度上源于许多公司的用户研究员被裁员了，这是受打击最严重的团队之一。所以我认为很多观点都源于此。那么，让我们从宏观层面开始，看看对话会引向何方。

---

### [00:07:53] Judd Antin

**English:**
So yeah, everybody who's paying attention has noticed that there have been a bunch of layoffs. And I think back in the summer I was thinking, "Listen, this seems to be hitting UX and UX research particularly hard. Is there something going on? Is there a bigger picture?" The reason I use the word reckoning is because to me that's like, "Hey, a moment to take stock." And triggered by the fact that a lot of wonderful humans may have lost their jobs, and many more are afraid of losing their jobs. And so if it's a sign, the fact that research has been hit so hard, it's a sign of what? And so the thesis of my article is really, it's a sign that maybe the system is a little more broken than we think and that research is not driving the value or impact that it should or could. And that's for a bunch of reasons, I think. Some of it is stuff that research can do better, and a lot of it is how research is integrated and positioned in companies.

**中文翻译:**
是的，任何关注行业的人都会注意到发生了一连串的裁员。回想去年夏天，我在想：“听着，这似乎对 UX（用户体验）和 UX 研究的打击尤其沉重。是不是发生了什么？有没有更宏观的背景？” 我之所以使用“大清算”这个词，是因为对我来说，这意味着“嘿，是时候盘点一下了”。这由许多优秀的人可能失去工作、更多人担心失去工作这一事实所触发。如果研究领域受到如此沉重的打击是一个信号，那它预示着什么？所以我文章的论点是：这可能是一个信号，表明系统比我们想象的更支离破碎，研究并没有发挥出它应有或能够发挥的价值或影响力。我认为原因有很多，有些是研究本身可以做得更好的地方，很大一部分则是研究在公司中如何被整合和定位的问题。

---

### [00:08:46] Judd Antin

**English:**
And at the root of all that, I think, is that we're just doing too much of what I would consider the wrong type of research. And what I mean by the wrong type of research is I have this framework, and it's in the article, macro, middle range, and micro research, at least three ways to talk about it. And it's pretty simple, the intuition of what those are. So macro research is big picture, strategic, business focused, forward-looking innovation, look at the market, look at competitors, long-term research to understand where the product should go next, stuff like that.

**中文翻译:**
我认为所有这些问题的根源在于，我们做了太多我认定的“错误类型”的研究。我所说的错误类型研究是指——我在文章中提到了一个框架：宏观（macro）、中观（middle range）和微观（micro）研究，至少可以从这三个维度来谈。它们的直观定义很简单。宏观研究是大局观的、战略性的、以业务为中心的、前瞻性的创新，关注市场、竞争对手，以及旨在了解产品下一步走向的长期研究等等。

---

### [00:09:20] Judd Antin

**English:**
And then you have micro research, which a lot of really technical usability falls into this, all the beautiful stuff that researchers do to enable a really high quality, excellent, pixel perfect thing to go out the door, laser-focused research to understand AB test results, stuff like that. And then you have this middle range, which is this blobular place where the research questions are middle altitude and a lot of the core, let's say user understanding questions fall here. And a lot of what research is doing is research in that space. It's, "Let's take a group of people and ask some questions about how they think, feel, behave, how they're using a product or not using a product." And it's just this devastating mix of really interesting to many, including researchers, and not impactful enough for the business. That's the core thesis. Researchers do it because it's interesting, but honestly, and a thing we should talk about, Lenny, is researchers also do it because it's the kind of work we most often get asked to do.

**中文翻译:**
然后是微观研究，很多技术性的可用性测试都属于这一类，包括研究员为了确保高质量、卓越、像素级完美的产品发布所做的所有精细工作，以及针对 A/B 测试结果的精准研究等等。接着是“中观研究”，这是一个模糊的地带，研究问题的维度处于中等高度，很多核心的（比如用户理解类）问题都落在这里。目前大部分研究工作都集中在这个领域。比如，“找一群人，问问他们怎么想、感觉如何、行为模式是什么、如何使用或不使用某个产品”。这是一种毁灭性的结合：对包括研究员在内的许多人来说非常有趣，但对业务的影响力却不够。这就是核心论点。研究员做这些是因为有趣，但老实说，Lenny，我们也应该谈谈：研究员做这些也是因为这是我们最常被要求去做的工作。

---

### [00:10:22] Lenny

**English:**
Yeah. That's exactly what I was thinking. As a PM, that's what I want to get answers to, is like, "How should we think about this one product?" And I totally get this.

**中文翻译:**
是的，我正是这么想的。作为一名 PM，我想要得到答案的正是这些：“我们应该如何看待这一个产品？” 我完全理解这一点。

---

### [00:10:31] Judd Antin

**English:**
Yeah. The questions turn out to be really interesting and there are many cases at many companies where it's super impactful. But the problem with those types of questions is they tend to, they trigger all the worst stuff that researchers experience. So they yield results which are interesting, but sometimes hard to operationalize. They trigger the post hoc bias, really, really, really well where a lot of people can say confidently like, "Oh, that was obvious. We knew that already." And they fulfill this need for us to feel and be customer obsessed, user-centered, without changing anything. So doing too much of that research to me is a symptom of a broken system, and where companies are really different from each other. I heard from so many after this article and they're like, "Well, my company and my industry is like this or not like this."

**中文翻译:**
是的。这些问题确实非常有趣，而且在很多公司的很多案例中，它们非常有影响力。但这类问题的问题在于，它们往往会触发研究员所经历的所有最糟糕的事情。它们产生的结果很有趣，但有时难以转化为实际操作。它们非常容易触发“事后聪明偏见”（post hoc bias），很多人会自信满满地说：“噢，这很明显啊，我们早就知道了。” 它们满足了我们想要表现得“客户至上”、“以用户为中心”的需求，却不需要做出任何改变。对我来说，做太多这类研究是一个系统性问题的症状。各家公司的情况大不相同，文章发布后我收到很多反馈，有人说：“我的公司和行业是这样的”或者“不是这样的”。

---

### [00:11:24] Judd Antin

**English:**
But in tech, we spent the last many years hiring, hiring, hiring researchers, but maybe, I'm sure most of your listeners are familiar with the idea of a ZIRP. Maybe it was a zero interest base phenomenon, where it was okay when the money was easy, to hire researchers, even though we were not setting them up properly. We're were going to set them up to fail. We set them up as a service function. We didn't know what research was for. We didn't know how to really drive impact with it. And that's where the reckoning comes from. It's like that era is over. Research, I think, is more crucial than ever. Good, great researchers are more impactful than ever. But it's in a new space. We're in a new space now.

**中文翻译:**
但在科技行业，过去几年我们一直在不停地招聘研究员。但我相信你的大多数听众都熟悉 ZIRP（零利率政策）这个概念。也许这是一种零利率环境下的现象：当钱来得容易时，招聘研究员没问题，即使我们没有为他们提供合适的架构。我们实际上是在让他们走向失败。我们将他们设定为一种“服务职能”。我们不知道研究的目的是什么，不知道如何真正利用它来产生影响力。这就是“大清算”的由来。那个时代已经结束了。我认为研究比以往任何时候都更关键，优秀的研究员比以往任何时候都更有影响力。但我们现在处于一个全新的环境。

---

### [00:12:05] Lenny

**English:**
I want to make sure people understand this framework. And specifically, how would you best describe the difference between this middle range research and macro research?

**中文翻译:**
我想确保大家理解这个框架。具体来说，你如何描述这种“中观研究”与“宏观研究”之间的区别？

---

### [00:12:16] Judd Antin

**English:**
Middle range research is usually focused on a more specific set of research questions or a constituency. So if macro is like, "Let's understand the overall competitive landscape. Let's do a concept car type project where we really look ahead. Let's get involved with strategic planning," which is a wonderful thing for researchers to do, do TAM studies, other things like that, that stuff lives in the macro space.

**中文翻译:**
中观研究通常集中在一组更具体的研究问题或特定群体上。如果宏观研究是：“让我们了解整体竞争格局。让我们做一个‘概念车’类型的项目，真正展望未来。让我们参与战略规划（这对研究员来说是件大好事），做 TAM（潜在市场总量）研究等”，这些都属于宏观范畴。

---

### [00:12:42] Judd Antin

**English:**
The middle range space is like, what's a good example? "We want to know how Airbnb hosts feel about their payment options." That's a really interesting, reasonable question. And we can go out and do research on that, but it's not that specific. It's not really targeted at a business problem yet. It could be. Maybe that's a result of the research, but it yields these middle range insights in which we've learned things like, "Well, hosts want flexibility about their payment options." I'm making this up. And that's a good example where it's like, "It's not that that's not an interesting set of questions, it's just not quite pointed enough." And it's not framed in the language of the funnel, or the business strategy, or the OKRs. It's not quite enough aligned enough to that. It's too blobular in that middle level and it ends up not driving impact.

**中文翻译:**
中观研究的例子比如：“我们想知道 Airbnb 房东对他们的支付选项有什么感觉。” 这是一个非常有趣且合理的问题。我们可以针对此开展研究，但它不够具体，还没有真正针对某个业务问题。它可能是业务问题的引子，但它产生的这种中观洞察通常是：“房东希望支付选项更有灵活性。”（这是我编的例子）。这是一个很好的例子，说明这类问题并非没趣，只是不够尖锐。它没有用“转化漏斗”、业务策略或 OKR 的语言来表述。它与这些目标的对齐程度不够，在这个中间层级显得太模糊（blobular），最终无法产生影响力。

---

### [00:13:38] Lenny

**English:**
I think it also leads to a lot of the things as you described, people don't like about research. It delays everything. You have to wait for the research to be done to have an answer, to make a clear decision. It also creates this issue that people complain about, that PMs and product teams don't want to just make a decision on their own. They're like, "I will get this additional data point and make sure research tells us this is the right answer instead of just trusting there." God, I guess maybe along those lines, this might be going off a little track, but what's your advice there for, say, product managers or PMs or product teams to not necessarily rely on research for that middle research?

**中文翻译:**
我认为这也会导致你描述的那些人们不喜欢研究的地方：它拖慢了所有事情。你必须等待研究完成才能得到答案，才能做出明确的决定。它还引发了人们抱怨的一个问题：PM 和产品团队不想独立做决定。他们会想：“我要拿到这个额外的数据点，确保研究告诉我们这是正确答案，而不是仅仅相信直觉。” 天哪，沿着这个思路，虽然可能有点跑题，但你对产品经理或产品团队有什么建议，让他们不一定要在这些中观研究上依赖研究员？

---

### [00:14:14] Judd Antin

**English:**
I think the reason why so many PMs ask for those middle range questions is because they haven't really gotten deep with their researcher in a way which can leverage it for maximum impact. So if the question is like, "Hey, Judd, you just pointed out a bunch of problems, can you be more solutions oriented?" Well, the solution is simple but not easy to me. It's that we need to restructure the way we make products in a way which integrates research much more fully. It looks like consistent relationships in which researchers, and the work, and the insights they provide are a part of the process from beginning to end.

**中文翻译:**
我认为这么多 PM 询问中观问题的原因是，他们还没有与研究员建立起能够发挥最大影响力的深度合作。所以，如果问题是：“嘿，Judd，你指出了这么多问题，你能提供一些解决方案吗？” 对我来说，解决方案很简单，但实施起来并不容易。那就是我们需要重构产品制造的方式，使研究能够更充分地整合进来。这表现为一种持续的关系，研究员及其工作和提供的洞察从始至终都是产品流程的一部分。

---

### [00:14:51] Judd Antin

**English:**
And I think, Lenny, you as a PM, that's how you worked. I remember you, I know who you worked with. You worked with great researchers. But honestly, most product processes are not that way. And so that's when research is a service function. It gets called in right at the end. It's reactive in the sense that a researcher in the room listening and participating in the conversation could have a ton of impact on framing exactly the right question that will drive maximum business impact, maximum product improvement at that moment, and then go do it quick, and get back, and we're onto the next. But they weren't there, the relationship wasn't there. They're not engaged in the project from the beginning. And that's the number one root of the problem. As long as research is a service discipline, I think we're going to be stuck in this spot.

**中文翻译:**
Lenny，作为一名 PM，你就是这样工作的。我记得你，我知道你和谁共事过。你和优秀的研究员合作过。但老实说，大多数产品流程并非如此。在那些流程中，研究只是一种服务职能，直到最后才被叫进来。它是被动反应式的。如果研究员在现场倾听并参与讨论，他们本可以对界定那个能产生最大业务影响、最大产品改进的“正确问题”产生巨大影响，然后快速执行并反馈，接着进入下一步。但他们当时不在场，这种关系不存在。他们没有从一开始就参与项目。这是问题的头号根源。只要研究仍然是一门“服务学科”，我认为我们就会一直困在这个境地。

---

### [00:15:37] Lenny

**English:**
When people might be hearing this, on the one hand, it's research has been not as helpful to teams as they thought, and researchers have been spending time on the wrong thing. On the other hand, your advice is integrate research from the beginning, make them more involved throughout. And I think that might confuse people. How should people think about, like, "Research is actually more important? You should integrate them more deeply."

**中文翻译:**
当人们听到这些时，一方面会觉得研究对团队的帮助没有想象中那么大，研究员一直在错误的事情上浪费时间；另一方面，你的建议却是从一开始就整合研究，让他们全程参与。我觉得这可能会让人困惑。人们应该如何理解“研究实际上更重要，你应该更深度地整合他们”这一点？

---

### [00:15:59] Judd Antin

**English:**
There's a vicious cycle that's been happening, is from where I sit, and this is what I hear from many, many researchers and research leaders, which is a lot of companies hired a lot of researchers with great intentions, didn't quite know how to integrate them. And UX research is a newer discipline, so maybe that's not surprising. We're still learning how to use it. "Cool, let's evolve." But a lot of companies hired these people, but they hired them into kind of like a service discipline, very reactive, not in the room, not integrated in the way I said.

**中文翻译:**
据我观察，也据我从许多研究员和研究领导者那里听到的情况，目前存在一个恶性循环：很多公司出于良好的意愿招聘了大量研究员，却不太清楚如何整合他们。UX 研究是一个较新的学科，所以这也许并不奇怪，我们还在学习如何使用它。“酷，让我们进化吧。” 但很多公司招聘了这些人，却把他们放在了类似“服务部门”的位置，非常被动，不在决策现场，也没有按照我所说的方式进行整合。

---

### [00:16:30] Judd Antin

**English:**
And so they had less input on the questions to ask, or they're included, but only at the end. And then they're unable to build those direct relationships, to be there in the room to actually drive the questions and insert insights. Because a good researcher is like the repository of insights you need for growth, but they're not there. They don't participate in the decision. So they end up doing research. They have jobs to do, so they do research that is too reactive, it doesn't matter, and then it's less impactful. Executives conclude that therefore researchers are not as impactful and then they get sidelined or laid off and the cycle continues.

**中文翻译:**
因此，他们对该问什么问题几乎没有发言权，或者即使被纳入流程，也只是在最后阶段。他们无法建立直接的关系，无法在现场推动问题的界定并植入洞察。因为一个优秀的研究员就像是你增长所需的洞察库，但他们不在场，不参与决策。所以他们最终只能做一些研究来完成任务，而这些研究过于被动，无关痛痒，影响力自然较低。高管们由此得出结论：研究员没那么重要。于是他们被边缘化或裁员，循环往复。

---

### [00:17:07] Judd Antin

**English:**
So I think the short circuit is the constant engagement. If you take a great researcher and you insert them consistently in a product process, I feel confident that researcher will drive a product improvement, metrics impact, growth, all the things that you want to see as a PM and a product leader. It's just that's the exception, not the norm these days.

**中文翻译:**
所以我认为打破这个循环的方法是“持续参与”。如果你找来一个优秀的研究员，并让他们持续参与产品流程，我有信心这位研究员能推动产品改进、指标提升、业务增长——也就是你作为 PM 和产品领导者想看到的所有事情。只是在当今，这成了例外，而非核心常态。

---

### [00:17:31] Lenny

**English:**
This may be a hard question to answer, but when people hear, "If you have a great researcher, here's how you approach it." What are signals that your researchers is great versus not great? What are some things people could look for to tell them, like, "Oh, maybe I have the wrong researcher on my team."

**中文翻译:**
这可能是一个很难回答的问题，但当人们听到“如果你有一个优秀的研究员，你应该这样对待他”时，优秀研究员与平庸研究员的信号是什么？人们可以根据哪些迹象判断：“噢，也许我团队里的研究员找错了”？

---

### [00:17:44] Judd Antin

**English:**
The best researchers I think are first of all, multi method. The first iteration of user research was primarily a qualitative discipline. But a strong opinion that I have is that is largely one of those models that needs to evolve. It's not that qualitative user research is no longer important. It's that the best researchers have five tools. I think they have five tools. And those five tools are number one, what we would call formative or generative user experience research. So looking ahead, innovation focused, really open-ended, maybe more ethnographic, "Let's go out into the field and talk to host and guests on Airbnb. Let's see people using our product in the field," stuff like that. So that's formative.

**中文翻译:**
我认为最优秀的研究员首先是“多方法论”的。第一代用户研究主要是一门定性学科。但我持有一个强烈的观点：这在很大程度上是需要进化的模式之一。并不是说定性研究不再重要，而是最优秀的研究员拥有“五件工具”。我认为他们有五件工具：第一，我们称之为“形成性”（formative）或“生成性”（generative）的用户体验研究。它是前瞻性的、专注于创新的、非常开放式的，也许更偏向民族志方法，比如“去实地走访 Airbnb 的房东和房客，观察人们在实际场景中如何使用我们的产品”等等。这就是形成性研究。

---

### [00:18:27] Judd Antin

**English:**
The second type is evaluative, so more like usability testing. The third tool is a basic rigorous survey design. It's the best scaled way to get responses from communities small and large. You can get a lot out of really well crafted surveys. But to do that, you have to have the fourth tool, which is applied statistics, the best research, know a little bit of stats. You can't interact in a world of AB testing without knowing basic statistics.

**中文翻译:**
第二种是“评估性”（evaluative）研究，更像是可用性测试。第三件工具是基础且严谨的问卷调查设计。这是从大大小小的群体中获取反馈的最佳规模化方式。通过精心设计的问卷，你可以获得很多信息。但要做到这一点，你必须拥有第四件工具，即“应用统计学”。最优秀的研究员懂一点统计学。如果不了解基础统计学，你就无法在 A/B 测试的世界里游刃有余。

---

### [00:18:56] Judd Antin

**English:**
And then in the old version of this, the fifth tool was SQL, because I think good researchers need to be able to run their own queries. These days, so much of that is dashboarded, that the fifth tool may now be prompt engineering, which is a thing we could talk about, but I think maybe that's the fifth tool is somewhere, is it technical skills that fall in between querying your own data, understanding it very well in companies that are awash with data and then interacting with generative AI.

**中文翻译:**
在旧版本中，第五件工具是 SQL，因为我认为优秀的研究员需要能够运行自己的查询。如今，很多数据都可视化为仪表盘了，所以第五件工具现在可能是“提示词工程”（prompt engineering）——这是我们可以讨论的话题。但我认为第五件工具可能介于查询自有数据、在数据泛滥的公司中深入理解数据，以及与生成式 AI 交互之间的技术技能。

---

### [00:19:24] Lenny

**English:**
Amazing. That's such a cool list. Okay, so just to playback, formative, generative, innovative skills to think bigger and come up with new ideas, usability.

**中文翻译:**
太棒了。这份清单很酷。好，我复述一下：形成性、生成性、创新技能，用于宏观思考并提出新想法；可用性。

---

### [00:19:35] Judd Antin

**English:**
Yep.

**中文翻译:**
是的。

---

### [00:19:35] Lenny

**English:**
Yeah, usability. How did you describe it? I have a different word, here. Evaluate? Evaluative?

**中文翻译:**
是的，可用性。你刚才怎么描述的？我这里记了另一个词。评估？评估性？

---

### [00:19:41] Judd Antin

**English:**
Evaluative, right.

**中文翻译:**
评估性，没错。

---

### [00:19:41] Lenny

**English:**
Okay.

**中文翻译:**
好的。

---

### [00:19:41] Judd Antin

**English:**
So we're evaluating products and doing more. Really that's the micro level of research.

**中文翻译:**
所以我们在评估产品并做更多工作。这实际上属于微观层面的研究。

---

### [00:19:47] Lenny

**English:**
Survey design, being really rigorous about it, applied statistics, and then SQL/dashboard/prompt engineering.

**中文翻译:**
问卷设计（要非常严谨）、应用统计学，然后是 SQL/仪表盘/提示词工程。

---

### [00:19:53] Judd Antin

**English:**
Right.

**中文翻译:**
对。

---

### [00:19:54] Lenny

**English:**
Maybe just one last question along this thread, also a big question, but any advice for how to evaluate these skills/interview for them? I know this is its own deep topic, but any advice for someone trying to find this person?

**中文翻译:**
沿着这个思路再问最后一个问题，这也是个大问题：关于如何评估这些技能或进行面试，你有什么建议吗？我知道这是一个很深的话题，但对于想要寻找这类人才的人，你有什么建议？

---

### [00:20:05] Judd Antin

**English:**
I've interviewed hundreds or thousands of researchers, and the way I usually approach that is you want a researcher who's got a Swiss army knife, because if all you have is a hammer, then everything looks like a nail. And so if you give in the context of an interview, let's say, a researcher, a pretty juicy, open-ended research question, and you want to see how they handle it, and a good answer is usually multi-method. We're not going to handle it in any one way. We're going to say, "Well, here's a couple of ways we could deal with this. Here's how we could do this in a day, or a week, or a month." We usually don't have a month, but sometimes big research projects go on for that long. "And here are the different sets of methods that we can use."

**中文翻译:**
我面试过成百上千名研究员，我通常的方法是：你需要一个拥有“瑞士军刀”的研究员，因为如果你手里只有锤子，看什么都像钉子。所以在面试中，如果你给研究员一个非常有挑战性、开放式的研究问题，你想看看他们如何处理。一个好的回答通常是多方法的。我们不会只用一种方式处理。我们会说：“嗯，有几种方法可以处理这个问题。这是我们如何在一天、一周或一个月内完成它的方案。”（虽然我们通常没有一个月，但有时大型研究项目确实需要那么久）。“这是我们可以使用的不同方法组合。”

---

### [00:20:44] Judd Antin

**English:**
So see where they go. It's actually pretty simple. Most researchers are deeper in one than the other, and sometimes you can make up for those five tools with the team. So you have experts who are t-shaped, but maybe deeper in one or several of those ways. But when I built a team at Meta and at Airbnb, that was my goal, is individually as researchers build up those tools and then as a team build deep expertise that would fill all the gaps.

**中文翻译:**
看看他们的思路。这其实很简单。大多数研究员在某一方面比另一方面更深入，有时你可以通过团队来弥补这五件工具的缺失。所以你会有“T型人才”，他们在某一个或几个方面钻研得更深。但当我在 Meta 和 Airbnb 组建团队时，我的目标是：让研究员个人建立起这些工具箱，然后作为一个团队建立起能够填补所有空白的深度专业知识。

---

### [00:21:10] Lenny

**English:**
Coming back to the main premise of your post, one of your big takeaways is, "Researchers need to be much more business oriented, thinking about what helps the business versus the user." Which I think to a lot of researchers will feel really weird. Can you just talk about your takeaways there?

**中文翻译:**
回到你文章的主要前提，你的一个重要观点是：“研究员需要更加以业务为导向，思考什么对业务有帮助，而不仅仅是用户需要什么。” 我觉得这对很多研究员来说会感觉很奇怪。你能谈谈你在这方面的感悟吗？

---

### [00:21:25] Judd Antin

**English:**
So much of user experience practice, not just research, but design too, is focused on empathy and very user-centered. This is beautiful. I'm not saying that we should abandon that. I think what I'm saying is there's an overlapping event, where you have the user and profit or the business. And what researchers need to do is be way more explicit about finding that overlap. So one thing, when researchers ask for advice, they're like, "Well, what should I do to be more business or profit focused?" I say something like, "Did you read the last quarterly report, If it's a public company? Did you listen to the shareholder call?" And they're probably like, "No, it's full of a bunch of language I didn't quite get."

**中文翻译:**
用户体验实践（不仅是研究，也包括设计）的很大一部分都集中在共情和以用户为中心上。这很美好，我并不是说我们要放弃这一点。我想说的是，这里存在一个交集，即用户需求与利润或业务的交集。研究员需要做的是更加明确地去寻找那个交集。所以，当研究员向我寻求建议，问“我该怎么做才能更关注业务或利润”时，我会问：“如果是上市公司，你读过上一份季度财报吗？你听过股东电话会议吗？” 他们可能会说：“没，里面全是些我听不太懂的术语。”

---

### [00:22:12] Judd Antin

**English:**
And I'm like, "Yep." So there you go. That's the language you need to learn. Scour your Google Drive folder, your internal folder and look for all of the documents that are about this quarter, or this halves, or next half strategy. What are the OKRs? Understand the metrics and the conversion funnel, know it back and forward, because then what you're doing is you're proposing, if you're in the active conversation, you're saying, 'Cool, I hear you asking that research question. I've identified this is exactly the spot in the funnel where I think we need to do work. There's an opportunity here. Or that competitor is eating our lunch with this group of users. I know that because I read the competitive report and I understand it deeply.'" So those are skills that some researchers have and a lot are building these days, but historically, last 15 years, it hasn't been a thing we've been as focused on, and I think that's an evolution that needs to happen.

**中文翻译:**
我会说：“这就对了。” 这就是你需要学习的语言。去翻翻你的 Google Drive 文件夹或内部文件夹，寻找所有关于本季度、本半年或下半年策略的文档。OKR 是什么？理解指标和转化漏斗，烂熟于心。因为这样当你参与对话时，你就能提议说：“酷，我听到你提了那个研究问题。我发现漏斗中的这个环节正是我们需要发力的地方，这里有个机会。或者，那个竞争对手正在抢走我们这部分用户，我知道这一点是因为我读了竞争报告并有深度理解。” 这些是部分研究员具备、且很多人正在培养的技能。但在过去的 15 年里，这并不是我们关注的重点，我认为这是一个必须发生的进化。

---

### [00:23:06] Lenny

**English:**
I think a lot of PMs listening to this are going to be like, "Hallelujah." This is exactly what I've been trying to convince people of. It's what I've been trying to convince my researchers of, and design often falls into this.

**中文翻译:**
我想很多听这期节目的 PM 都会直呼“哈利路亚”。这正是我一直试图说服大家的事情。这也是我一直试图说服我的研究员的事情，而且设计团队也经常陷入这种误区。

---

### [00:23:17] Judd Antin

**English:**
But Lenny, the opposite is true, too, because you got to take the average PM who lives in that land, all day, every day, and what they do is not in the Venn. I think those are people who are also performing customer centricity and performing user-centeredness a lot, when they're really not interested. And so this is not about researcher. This takes two sides. Fixing this broken system takes everyone, researchers, PMs, designers, everyone at a company, but also the way that organization is structured, and integrating itself in a different way. Everybody's got to come to the table.

**中文翻译:**
但是 Lenny，反过来也成立。因为有些 PM 整天沉浸在业务数据里，他们所做的也不在那个交集（Venn diagram）里。我认为这些人也经常在“表演”以客户为中心、以用户为中心，而实际上他们并不感兴趣。所以这不仅仅关乎研究员。这需要双方的努力。修复这个支离破碎的系统需要每个人——研究员、PM、设计师，公司里的每一个人，同时也需要组织架构的调整和不同的整合方式。每个人都必须参与进来。

---

### [00:23:55] Lenny

**English:**
Such a good point. And you have this actual term that you call user-centered performance, where it's the performance of being user-centered. Can you talk about that and then just what advice you'd give to PMs that, hearing this, are like, "Yes, I love everything you're saying," and then not realizing maybe they're too far in that extreme?

**中文翻译:**
说得太好了。你有一个专门的术语叫“以用户为中心的表演”（user-centered performance），即表演出来的以用户为中心。你能谈谈这个吗？对于那些听了这些话觉得“没错，我完全同意你说的”，却没意识到自己可能走到了另一个极端的 PM，你有什么建议？

---

### [00:24:11] Judd Antin

**English:**
User-centered performance is a term I made up, because it's fun to make up terms. And it refers to customer obsession or a user-centered practice that is symbolic rather than focused on learning. So it's hugely common, I would argue. It's work we do to signal to each other how customer obsessed we are, not because we want to make a different decision. And if your listeners are like, "I don't do that." I'm like, "Think about it for a second." Because this is extremely common. It shows up in explicit ways and implicit ways.

**中文翻译:**
“以用户为中心的表演”是我发明的一个词，因为发明术语很有趣。它指的是那种象征性的、而非以学习为目的的“客户至上”或“以用户为中心”的实践。我认为这极其普遍。这种工作的目的是向彼此发出信号，展示我们是多么关注客户，而不是因为我们真的想据此做出不同的决策。如果你的听众觉得，“我才不干那种事”，我会说：“再仔细想想。” 因为这太常见了，它以显性和隐性的方式存在。

---

### [00:24:52] Judd Antin

**English:**
So explicitly, I would say every time a PM comes to a researcher at the end of a product process and says, "Can you just run a quick user study just to validate our assumptions?" That's user-centered performance. It's too late to matter. That PM is not interested in being wrong at all. It's too late in the game for that. We got to ship it. What they want is to check the box. So any check the box style research is a wild example of user-centered performance.

**中文翻译:**
显性地来说，每当 PM 在产品流程结束时去找研究员说，“你能快速做一个用户研究来验证一下我们的假设吗？”，这就是“以用户为中心的表演”。因为这时候已经太晚了，起不到作用。那位 PM 根本不想被证明是错的，时间点已经不允许了，产品必须发布。他们想要的只是“走个过场”。所以，任何“走过场”式的研究都是“以用户为中心的表演”的典型案例。

---

### [00:25:22] Judd Antin

**English:**
I would argue every researcher has probably had to do executive listening sessions because a lot of PMs, founders, product people, but designers, too, they want to get close to the customer. And so, like, "Can I do some focus groups? I want to be there. I want to ask them questions." This is 97% performance. It's well-intentioned, but it isn't focused on learning. It isn't going to drive better outcomes or more impact.

**中文翻译:**
我认为每个研究员可能都不得不做过“高管倾听会”，因为很多 PM、创始人、产品人，还有设计师，他们都想“贴近客户”。于是会说：“我能做一些焦点小组吗？我想在现场，我想亲自问他们问题。” 这其中 97% 都是表演。虽然初衷是好的，但它并不专注于学习，也不会带来更好的结果或更大的影响力。

---

### [00:25:49] Judd Antin

**English:**
And then there's all these implicit ways that people engage in that kind of user performance, too. A lot of it comes down to cognitive biases, confirmation bias, ego. One of my big mantras was, "We don't validate, we falsify. We are looking to be wrong." That is the mindset you should use when you're approaching insights and research. "I want to be wrong. I want you to do research that shows we were off base in the following ways. Tell me exactly how and why in a way that allows me to fix it quickly." But many PMs, many designers are not in that place. They do not want to be wrong. They're looking to validate. And that's user-centered performance.

**中文翻译:**
此外，人们还会以各种隐性的方式进行这种用户表演。很大程度上归结为认知偏见、确认偏误和自我意识。我的一个重要座右铭是：“我们不验证，我们证伪。我们是在寻找自己错误的地方。” 这才是你在面对洞察和研究时应有的心态。“我想证明自己是错的。我希望你做的研究能显示我们在哪些方面偏离了方向。以一种能让我快速修复的方式，确切地告诉我如何偏离以及为什么。” 但许多 PM 和设计师还没达到这种境界。他们不想出错，他们只想寻求验证。这就是“以用户为中心的表演”。

---

### [00:26:29] Lenny

**English:**
Oh, man. I think a lot of people are hearing this and feeling exposed.

**中文翻译:**
噢，天哪。我想很多人听到这里会觉得被戳穿了。

---

### [00:26:33] Judd Antin

**English:**
Exposed.

**中文翻译:**
被戳穿了。

---

### [00:26:35] Lenny

**English:**
I feel like you're like this Deep Throat person coming from sharing these things people don't want to talk about at the office.

**中文翻译:**
我觉得你就像那个“深喉”（告密者），分享着大家在办公室里避而不谈的事情。

---

### [00:26:35] Judd Antin

**English:**
I know.

**中文翻译:**
我知道。

---

### [00:26:42] Lenny

**English:**
There's this quote in your post I'm going to read. "Product managers love to ask for middle range research that they can use to justify decisions they're reluctant to make on their own. User designers love to ask for middle range research because it fits their model of what proper design process should look like. Executives love to ask for middle range because they don't really understand what research is for, and helps them do performative user-centeredness. In the end, they will decide based on their own opinions."

**中文翻译:**
你文章里有一段话，我要读一下：“产品经理喜欢要求做中观研究，以便用来为他们不愿独立做出的决定辩护。设计师喜欢要求做中观研究，因为这符合他们心目中‘正规设计流程’应有的样子。高管喜欢要求做中观研究，因为他们并不真正理解研究的用途，而这能帮他们完成表演式的‘以用户为中心’。最终，他们还是会根据自己的直觉做决定。”

---

### [00:27:07] Judd Antin

**English:**
There is an important place for intuition in product development, of course. The best designers, researchers, product people develop strong intuition for the product. But you got to understand, intuition is where all of those biases lie. It's where all your blind spots are. And what great insights people do, what great researchers do when you're next to them all the time, is they'll expose you. I don't have to be the Deep Throat, because you have somebody who's professional job is ... Keeping you honest is probably the wrong way to put it, but as somebody whose capabilities are about expanding your horizons, making it so that your intuition is constantly improving, you don't have to rely on it when your intuition and the evidence sort of collide in a way that either affirms or falsifies the product decision you made. Now something really good is happening.

**中文翻译:**
当然，直觉在产品开发中占有重要地位。最优秀的设计师、研究员和产品人都会对产品产生强烈的直觉。但你必须明白，直觉正是所有偏见所在的地方，也是你所有盲点所在的地方。而伟大的洞察者、伟大的研究员，当你一直与他们并肩作战时，他们会揭露你的盲点。我不需要充当“深喉”，因为你身边就有专业人士，他们的工作是……说“让你保持诚实”可能不太准确，但他们的能力在于扩展你的视野，让你的直觉不断进化。当你的直觉与证据发生碰撞，无论是证实还是证伪了你做出的产品决策，你都不必仅仅依赖直觉。这时候，真正有价值的事情就发生了。

---

### [00:28:00] Judd Antin

**English:**
And the other thing that is inherent in that quote is I, at Airbnb, wore many hats over the years. I was head of research two different times. I was head of design for guest products. And my last job was I was head of the design studio, so UX research, UX design, writing, localization, they all reported up to me. So I've seen this from many disciplinary angles in the UX field. And researchers aren't the only ones who are guilty of this. I would say design has a ton of performance. And it comes from the fact that we have figured out user-centered design, this process, or design thinking, which IDEO popularized. Like, "That's what we're supposed to do, right? Bezos told us that we, as PMs, had to be customer obsessed. So that's what we're supposed to do."

**中文翻译:**
那段话里还隐含了另一层意思。我在 Airbnb 工作期间担任过很多职位。我曾两次担任研究负责人，曾担任房客产品设计负责人。我最后一份工作是设计工作室负责人，UX 研究、UX 设计、文案、本地化都向我汇报。所以我从 UX 领域的多个专业角度观察过这种现象。研究员并不是唯一有这种行为的人。我想说，设计领域也有大量的“表演”。这源于我们已经形成了一套“以用户为中心的设计”流程，或者 IDEO 推广的“设计思维”。大家觉得：“这就是我们该做的，对吧？贝佐斯告诉我们，作为 PM 必须客户至上。所以这就是我们该做的。”

---

### [00:28:48] Judd Antin

**English:**
It's a really common and damaging thing when we don't genuinely have that growth learning mindset, and it's easy to sideline researchers. We don't need them in that situation. We've got our guts. Isn't the gut where a great PM, a great founder needs to have that gut? And they do, but they need to be open to the fact that your gut, is limited, and biased, and narrow, and wrong sometimes.

**中文翻译:**
当我们没有真正具备那种“增长学习心态”时，这是一种非常普遍且具有破坏性的现象，而且很容易把研究员边缘化。在那种情况下，我们觉得自己不需要他们，我们有直觉。难道优秀的 PM、优秀的创始人不需要直觉吗？他们确实需要，但他们必须接受一个事实：你的直觉是有局限的、有偏见的、狭隘的，而且有时是错误的。

---

### [00:29:13] Lenny

**English:**
The two sides of this is trust your gut opinion, "I don't need research, I don't need data. I have opinions, and my own experience, and I'm going to use the product, and let's just go with what feels right to me." Versus pure data-driven research driven for designers that are maybe listening for product managers. Do you have any advice for just where to fall on that spectrum and just how to best leverage research to inform that opinion?

**中文翻译:**
这有两个极端：一个是“相信直觉”，即“我不需要研究，不需要数据。我有自己的见解和经验，我会亲自使用产品，就按我觉得对的感觉来”；另一个是纯粹由数据和研究驱动。对于正在听节目的设计师或 PM，你对如何在这个光谱中找到平衡点有什么建议？以及如何最好地利用研究来辅助这些见解？

---

### [00:29:36] Judd Antin

**English:**
Yeah, I taught a class at UC Berkeley this semester on leadership, and we talk about that a lot, because great leaders develop intuition. It's the pattern matching part of experience, where you develop heuristics which allow you to make good judgments even if you can't quite explain where that judgment came from. That's what the gut is. But it's also, like I said, where bias comes from, where all the cognitive biases, there's a list of 151 of them on Wikipedia, I won't name them, but all those thorny things that lead us astray, the behavioral economists and social psychologists study, those live in the gut. And so the advice is when you are looking to check your gut, you have to do that thing. A lot of your listeners have probably read Thinking Fast and Slow, System 1, System 2. Right?

**中文翻译:**
是的，我这学期在加州大学伯克利分校教一门领导力课程，我们经常讨论这个问题。因为伟大的领导者会培养直觉。直觉是经验中“模式匹配”的部分，你通过它建立启发式思维，从而做出正确的判断，即使你无法完全解释判断的来源。这就是直觉。但正如我所说，偏见也源于此。维基百科上列出了 151 种认知偏见，我就不一一列举了，但所有那些误导我们的棘手问题（行为经济学家和社会心理学家研究的对象）都存在于直觉中。所以建议是：当你想要检验你的直觉时，你必须做那件事。你的很多听众可能读过《思考，快与慢》，知道系统 1 和系统 2，对吧？

---

### [00:30:29] Lenny

**English:**
I have it here, right under my laptop, actually, holding up my laptop screen.

**中文翻译:**
我就有一本，就在我笔记本电脑下面垫着呢，正撑着我的屏幕。

---

### [00:30:32] Judd Antin

**English:**
That's so appropriate, Lenny. So the secret is not that sexy. It's System 2. So you engage that slow, methodical process in which you do analytic thinking as a means of checking your gut. Slow in the grand scheme of things. Slow meaning not a split second decision, not like months of analysis. That's not what I mean.

**中文翻译:**
那太合适了，Lenny。所以秘诀其实并不怎么吸引人，那就是“系统 2”。你需要启动那个缓慢、有条理的过程，通过分析性思维来检验你的直觉。这里的“慢”是相对而言的，意思是不要做瞬间的决定，但也不是指长达数月的分析。

---

### [00:30:54] Judd Antin

**English:**
The other thing you can do, and there's really great research on this, is you bring in the wisdom of the crowd. So the wisdom of the crowd is a phrase a lot of people are familiar with, and it works in a specific situation. The wisdom of the crowd works when the people involved with the decision are bringing diverse sources of information and judgment to the table. Obviously, if everybody has the same sources of information, then it doesn't matter how many people are out there. So if you want to check your gut, get a bunch of different guts together, get a bunch of different people in the room who can bring evidence and intuition to bear, and have an open, direct end kind conversation in which we might disagree. You know who's great at that? Researchers.

**中文翻译:**
另一件你可以做的事（对此有非常棒的研究）是引入“群体的智慧”。很多人都熟悉这个词，它在特定情况下非常有效。当参与决策的人能带来多样化的信息源和判断时，群体的智慧就会发挥作用。显然，如果每个人的信息源都一样，那有多少人参与都无所谓。所以，如果你想检验你的直觉，就把一堆不同的“直觉”聚在一起，让一群能提供证据和直觉的人聚在房间里，进行一场公开、直接、允许分歧的对话。你知道谁最擅长引导这种对话吗？研究员。

---

### [00:31:38] Lenny

**English:**
Leading those discussions essentially, and getting a bunch of people's opinions.

**中文翻译:**
本质上是领导这些讨论，并收集众人的意见。

---

### [00:31:41] Judd Antin

**English:**
Yeah, this is the structural solution I'm talking about, Lenny, is like, "I never asked for research teams to have their own separate OKRs." I said two things, "Number one, what's the teams? Shouldn't the PMs, the engineers, the designers and the research, everybody should have the same set of metrics for success because either we're doing it together or we're not." And then I said, "My metric for success is when they won't have that meeting without you." That's my metric for success. If they cannot have that decision making meeting without the researcher there, that means you've developed influence, strong, trusting relationships, you're an active participant in the process, not just somebody who provides input into someone else's process. And that is when researchers can have huge impact.

**中文翻译:**
是的，这就是我所说的结构性解决方案。Lenny，我从不要求研究团队拥有独立的 OKR。我强调两点：第一，团队的目标是什么？PM、工程师、设计师和研究员难道不应该拥有一套共同的成功指标吗？因为我们要么一起成功，要么就不是一个团队。第二，我衡量成功的指标是：“如果他们不带你就不开那个会。” 这就是我的标准。如果他们在没有研究员在场的情况下无法进行决策会议，那就意味着你已经建立了影响力、强大且互信的关系，你是流程中的积极参与者，而不仅仅是为别人的流程提供输入的人。只有这样，研究员才能产生巨大的影响。

---

### [00:32:29] Lenny

**English:**
I think of the PM role in a similar way, even though people won't have these meetings with PMs, because they're often at the center of lot of the stuff, but you want to be a PM that people want on their team. There's a lot of teams that are like, "We don't want and PMs, we don't need product managers. They just get in the way." And I find that that's only the case when the product manager's not great, and not really good at their job, because most great PMs just make everyone's life easier.

**中文翻译:**
我对 PM 角色的看法也类似。虽然人们通常不会在没有 PM 的情况下开会（因为 PM 往往处于核心位置），但你必须成为那种大家“想要”在团队里的 PM。有很多团队会说：“我们不想要 PM，我们不需要产品经理，他们只会碍事。” 我发现，只有当 PM 不够优秀、不擅长工作时才会出现这种情况，因为大多数优秀的 PM 只会让每个人的工作变得更轻松。

---

### [00:32:50] Judd Antin

**English:**
They do. The grease, I-

**中文翻译:**
确实如此。他们是润滑剂，我——

---

### [00:32:51] Lenny

**English:**
The grease.

**中文翻译:**
润滑剂。

---

### [00:32:53] Judd Antin

**English:**
... love it.

**中文翻译:**
……太形象了。

---

### [00:32:54] Lenny

**English:**
You mentioned also, before we started recording, that the biggest challenge for user researchers is in their relationship with their product manager. Can you speak to that and what you've seen there?

**中文翻译:**
在开始录音之前你还提到，用户研究员面临的最大挑战在于他们与产品经理的关系。你能谈谈这一点以及你所观察到的情况吗？

---

### [00:33:04] Judd Antin

**English:**
I'm wary of overgeneralizing, but I can tell you that from my experience and from what I hear, the product research or product insights relationship is one of the most challenged. And I think it comes from the fact that fundamentally, many researchers are just not included in the process that PMs are running. And then, actually, I did some asking around before this podcast, and so I thought, "There are some tropes that researchers have about PMs that are worth PMs knowing, just like four or five of them, the things that researchers know PMs say, which drive us nuts because they're not true."

**中文翻译:**
我不想以偏概全，但根据我的经验和所见所闻，产品研究（或产品洞察）的关系确实是最具挑战性的关系之一。我认为这源于一个根本事实：许多研究员根本没有被纳入 PM 主导的流程中。实际上，在录制这期播客之前，我做了一些调研，我想：“研究员对 PM 有一些刻板印象（tropes），PM 应该了解一下。大概有四五个，就是研究员知道 PM 会说、但却让我们抓狂的话，因为那些话根本不是真的。”

---

### [00:33:51] Judd Antin

**English:**
So the first one is that research just slows us down. Research is too slow. This is bullshit. A great research team can do research in a day, a week, or a month. It just depends on what you want to get out of it, like, "How much detail do you need? How many people do we need to talk to? What is the depth or breadth? Do we need to go to seven different countries to talk about our constituencies in Latin America?" Well, that's not going to happen overnight, but we don't often need that. The other way to look at that is that is it slower to get it wrong and fix it than to take a hot second to do the work to get it right the first time? So that's BS. Good research doesn't slow us down, it speeds us up.

**中文翻译:**
第一个是：“研究只会拖慢我们的进度。研究太慢了。” 这纯属胡扯。一个优秀的研究团队可以在一天、一周或一个月内完成研究。这完全取决于你想得到什么，比如：“你需要多详细的信息？我们需要和多少人交谈？深度和广度如何？我们需要去七个不同的国家讨论我们在拉美的用户群体吗？” 显然，那不可能一夜之间完成，但我们通常不需要那样。另一种看待方式是：是做错了再修复更慢，还是花一点时间在第一次就把它做对更慢？所以那是胡说。好的研究不会拖慢进度，它会加速进度。

---

### [00:34:36] Lenny

**English:**
And also just along those lines, a big part of your premise is you don't need to do as much research as people are doing, like this middle research that a lot of the time is put into.

**中文翻译:**
沿着这个思路，你文章的一个重要前提是：你不需要做像现在人们做的那么多研究，尤其是投入了大量时间的那种“中观研究”。

---

### [00:34:45] Judd Antin

**English:**
Yeah. Research can go super fast. I think especially, so the macro level research, I hope what it is tied to things like annual planning processes. We did a thing at Airbnb several years that we called, it was like Insights 2019, Insights 2020. They were concept car projects. And we spent quite a long time synthesizing the entire year's worth of insights from every place we could get them and then developing with designers and engineers like a concept car for five years in the future. So that's a long process.

**中文翻译:**
是的。研究可以进行得非常快。我认为特别是宏观层面的研究，我希望它能与年度规划流程挂钩。我们在 Airbnb 做了几年类似“洞察 2019”、“洞察 2020”的项目。它们就像是“概念车”项目。我们花了相当长的时间，综合了从各个渠道获得的整整一年的洞察，然后与设计师和工程师一起开发出未来五年的“概念车”。那确实是一个漫长的过程。

---

### [00:35:16] Judd Antin

**English:**
But the micro level, there's so much business value to be derived there, so much business value, and it can go so fast, Lenny, it can go so fast. You can have results in 48 hours on these things. We did a thing at Airbnb. There's a famous story which I'll only tell in the abstract, because I don't want to out anything, but we call it the multimillion dollar button. And basically we did research which revealed that people weren't going down the purchase funnel because they were afraid. The calls to actions on the button was making them afraid that it would initiate a purchase when really it was just taking the next step.

**中文翻译:**
但在微观层面，可以挖掘出巨大的业务价值，而且速度可以非常快，Lenny，真的非常快。你可以在 48 小时内得到结果。我们在 Airbnb 做过一件事，有一个著名的故事（我只抽象地讲一下，不想透露具体细节），我们称之为“价值数百万美元的按钮”。基本上，我们的研究发现，人们之所以没有进入购买漏斗，是因为他们感到害怕。按钮上的行动号召（CTA）让他们担心点击就会启动购买，而实际上那只是进入下一步。

---

### [00:35:58] Judd Antin

**English:**
We changed the text on the button with help from our amazing content design, our UX writing team. We basically changed seven characters and made Airbnb millions of dollars, because what we found out was really simple. It was just like, "Hey, this button feels scary. The CTA on the button feels scary." So that's a great example of how micro ... And that happened in like 48 hours, we would discover that insight, or overnight, basically. And we were like, "Hm, maybe we should test some other CTAs." We did the conversion, we added like 1%, which is really, really hard to do. So that's a quick example of how that type of quick research can drive a huge amount of business value.

**中文翻译:**
在优秀的文案设计和 UX 写作团队的帮助下，我们修改了按钮上的文字。我们基本上只改了七个字符，就为 Airbnb 赚了数百万美元。因为我们发现的问题很简单：“嘿，这个按钮感觉很吓人，上面的 CTA 让人害怕。” 这是一个微观研究的绝佳例子……那个洞察基本上是在 48 小时内，或者说一夜之间发现的。然后我们想：“嗯，也许我们应该测试一些其他的 CTA。” 我们进行了转化测试，提升了大约 1% 的转化率，这在那个量级是非常难做到的。这就是快速研究如何驱动巨大业务价值的一个简单例子。

---

### [00:36:39] Lenny (Sponsor Break)

**English:**
This episode is brought to you by Ahrefs. Many of you already know Ahrefs as one of the top tools for search engine optimization. It's used by thousands of SEOs and companies like IBM, Adidas and eBay. What you may not know is that there's a free version that was made with small website owners in mind. It's called Ahrefs Webmaster Tools. It's free and it can help you bring more traffic to your website. Ahrefs Webmaster Tools will show you keywords that you rank for and backlinks that you can get. It also performs automated site audits to find what issues prevent your website from ranking higher on Google. Every detected issue comes with a detailed explanation and advice on how to fix it. Visit ahrefs.com/awt, set up a free account, connect your website, and start improving it. That's A-H-R-E-F-S.com/A-W-T.

**中文翻译:**
本集节目由 Ahrefs 为您带来。你们中的许多人已经知道 Ahrefs 是顶级的搜索引擎优化（SEO）工具之一，被成千上万的 SEO 专家以及 IBM、阿迪达斯和 eBay 等公司使用。你可能不知道的是，它还有一个专门为小型网站所有者设计的免费版本，叫做 Ahrefs Webmaster Tools。它是免费的，可以帮助你为网站带来更多流量。Ahrefs Webmaster Tools 会显示你排名的关键词以及你可以获得的后向链接。它还会执行自动化的网站审计，找出阻碍你网站在 Google 上排名更高的问题。每个检测到的问题都附有详细的解释和修复建议。访问 ahrefs.com/awt，建立免费账户，连接你的网站并开始优化。

---

### [00:37:29] Lenny

**English:**
So just to make this even clearer, I think this middle research zone is the stuff that does slow people down, I imagine. It's like, "What are the challenges hosts have with payments on Airbnb?" What you're basically saying is, "Spend your time doing the micro stuff like usability research and then the bigger stuff that's part of overall planning. That's part of the planning cycle. It's not like every project you're working on, you need to have a whole research project on."

**中文翻译:**
为了更清晰一点，我想这种“中观研究”区域确实是拖慢大家进度的东西。比如：“房东在 Airbnb 支付方面面临哪些挑战？” 你基本上是在说：“把时间花在微观的事情上（如可用性研究），以及作为整体规划一部分的宏观事情上。那是规划周期的一部分。并不是你做的每一个项目都需要一个完整的研究项目。”

---

### [00:37:55] Judd Antin

**English:**
Exactly. The micro research should be much more common. A lot of researchers think that that's scut work, that usability is something junior researchers do. I completely disagree. I think we need to get back there as an industry and be like, "When you make a product easier to use, when you discover problems with functionality, business metrics we care about will go up." I've seen it happen. But that's not just work for interns and new grads, that's for sure.

**中文翻译:**
没错。微观研究应该变得更加普遍。很多研究员认为那是“打杂”的工作，认为可用性测试是初级研究员才做的。我完全不同意。我认为作为整个行业，我们需要回归初心：“当你让产品变得更好用，当你发现功能上的问题，我们关心的业务指标就会上升。” 我亲眼见过这种情况发生。这绝对不仅仅是实习生和应届生的工作。

---

### [00:38:24] Judd Antin

**English:**
And then the planning process, absolutely. If we're integrated from beginning to end, we can help. And the thing about that middle range, I think you're right. That's the stuff that makes the stereotype that research is slow, and a lot of times it's also because it's just not pointed enough. The researcher can also say in that moment, "I have studied the business plan. I know exactly where, I've seen the metrics trend, I have an idea about exactly where that's going to go." We still need to do that middle range research. The question is valuable, but it's now very pointed and the time is worth it.

**中文翻译:**
至于规划流程，那是肯定的。如果我们能从头到尾整合进来，我们就能提供帮助。关于中观研究，你说得对，正是它造成了“研究很慢”的刻板印象。很多时候也是因为它不够尖锐。研究员在那一刻可以说：“我研究过业务计划，我清楚地知道指标趋势，我对事情的走向有明确的想法。” 我们仍然需要做中观研究，问题本身是有价值的，但现在它变得非常有针对性，花的时间也就值得了。

---

### [00:38:58] Lenny

**English:**
Amazing. Okay, I want to hear the rest of these tropes.

**中文翻译:**
太棒了。好，我想听听剩下的那些刻板印象。

---

### [00:39:01] Judd Antin

**English:**
Okay, research is too slow is the first one. The second one, I can do my own research. Why do I need researchers? And that's true, as product people, I hope you are engaging with customers and listening well. But no offense, garbage in, garbage out. The thing is, anyone can talk to a user. That does not constitute research or insights work because one user can be powerful, but one user can be idiosyncratic. And a researcher knows how to get to the heart of that really quick. They know how to take that conversation, and understand, and situate it in a way which means like, "Sure, democratize research. That's happening. There are tools out there that will let anybody get customer feedback, voice a customer type stuff." But a researcher is there to help you turn garbage into something that's not garbage and avoid the bias that can come from you just reaching out to your cousin's family and then doing whatever they thought you should do to the product. So that's the second trope.

**中文翻译:**
好，“研究太慢”是第一个。第二个是：“我可以自己做研究，为什么需要研究员？” 确实，作为产品人，我希望你们能与客户互动并倾听。但恕我直言，“垃圾进，垃圾出”。问题在于，任何人都可以和用户聊天，但这并不构成研究或洞察工作。因为一个用户可能很有代表性，但也可能非常特殊（idiosyncratic）。研究员知道如何快速抓到核心。他们知道如何引导对话，并将其置于特定背景下理解。这意味着：“当然，研究可以民主化，这正在发生。有很多工具可以让任何人获取客户反馈或‘客户之声’。” 但研究员的作用是帮你把“垃圾”变成有用的信息，并避免那种偏见——比如你只是问了你表哥一家人，然后就根据他们的想法去改产品。这就是第二个刻板印象。

---

### [00:40:08] Judd Antin

**English:**
The third one is AB test everything. And AB tests are great, but one of my most painful things to do is to sit in a room full of PMs and data scientists who have just seen the results of an experiment that flipped a stat sig, and then they're like, "Cool, I was significantly down over this course of time for these users." And then they just start speculating about why that is, because the AB test rarely tells you why it changed in the way it did. And then this endless flywheel of AB testing goes and I'm like, "Hey, you don't have to guess. I know somebody who can get you an answer or at least evidence that addresses the question of why did we see the test result we did in a very short amount of time? Or you could use your customers as Guinea pigs, and throw more experiments at them over and over, and spend a long time on it, and come to the same place in the end."

**中文翻译:**
第三个是：“A/B 测试一切”。A/B 测试很棒，但我最痛苦的事情之一就是和一群 PM 和数据科学家坐在一起，看着一个刚刚达到统计显著性（stat sig）的实验结果，然后他们说：“酷，这段时间这些用户的指标显著下降了。” 接着他们就开始猜测原因，因为 A/B 测试很少能告诉你“为什么”会发生这种变化。然后这种无休止的 A/B 测试飞轮就开始转动，我会说：“嘿，你们不必瞎猜。我认识能给你们答案的人，或者至少能在很短时间内提供证据，解释为什么我们会看到这样的测试结果。或者，你可以继续把客户当成小白鼠，一遍又一遍地给他们做实验，耗费大量时间，最后还是回到原点。”

---

### [00:41:03] Lenny

**English:**
I think a similar critique that PMs often have is AB testing is conclusive scientifically, statistically, user research is just talking to a bunch of people. Why would I trust that? What is your best way to help PMs realize that this is actually very valuable data and you should listen to it? It's not just, you know, a story here and there.

**中文翻译:**
我认为 PM 经常有的一个类似批评是：A/B 测试在科学和统计上是结论性的，而用户研究只是和一群人聊天。我为什么要相信它？你有什么好办法让 PM 意识到这实际上是非常有价值的数据，应该予以倾听？这不仅仅是偶尔听到的几个故事。

---

### [00:41:26] Judd Antin

**English:**
Yeah. No, I think they're both right. AB testing is as close as we can get to making causal claims about products. Research is usually not oriented towards making causal claims or it should not be, but those causal claims rarely tell you how and why things happen. And if you want to not make that mistake again in the future, you need to know how and why. If you want to build a better product in a way that doesn't just answer this narrow question that an AB test answered, you need to know how and why. And so you need both. Beautiful partnerships between data scientists and research and insights people are, I think what we're going to see in that next evolution. And if you set that virtuous cycle up, if you set up the engagement where those people are involved from the beginning, you don't make those mistakes. You get the causal relationship, which is valuable for one reason and the hows and whys, which are valuable for other reasons.

**中文翻译:**
是的，我认为两种观点都有道理。A/B 测试是我们能做出的最接近“因果推断”的产品结论。研究通常不以因果推断为导向（也不应该如此），但因果推断很少能告诉你事情“如何”发生以及“为什么”发生。如果你不想在未来重蹈覆辙，你需要知道原因。如果你想打造更好的产品，而不仅仅是回答 A/B 测试提出的那个狭隘问题，你需要知道原因。所以两者你都需要。我认为在下一次进化中，我们将看到数据科学家与研究/洞察人员之间建立起美妙的伙伴关系。如果你建立了这种良性循环，让这些人从一开始就参与进来，你就不会犯那些错误。你会得到因果关系（这在某方面很有价值），也会得到“如何”和“为什么”（这在另一方面很有价值）。

---

### [00:42:19] Lenny

**English:**
Awesome. Okay. I think there's two more tropes you had.

**中文翻译:**
太棒了。好，我想你还有两个刻板印象要分享。

---

### [00:42:23] Judd Antin

**English:**
One of them is a simple one, which is like everyone loves to quote that it turns out a totally apocryphal Henry Ford quote about, "If I'd asked my users." It turns out to the best of our knowledge, he did not say that. And-

**中文翻译:**
其中一个是关于亨利·福特的。大家都喜欢引用那句完全是杜撰的（apocryphal）名言：“如果我问我的用户（他们想要什么，他们会说想要更快的马）。” 事实证明，据我们所知，他根本没说过那句话。而且——

---

### [00:42:35] Lenny

**English:**
Really? What?

**中文翻译:**
真的吗？什么？

---

### [00:42:36] Judd Antin

**English:**
Yeah, I know. Isn't that sad?

**中文翻译:**
是的，我知道。这难道不令人难过吗？

---

### [00:42:36] Lenny

**English:**
I didn't know that.

**中文翻译:**
我以前不知道。

---

### [00:42:38] Judd Antin

**English:**
I know. Sorry to burst your bubble, Lenny.

**中文翻译:**
我知道。抱歉打破了你的幻想，Lenny。

---

### [00:42:40] Lenny

**English:**
Oh, wow.

**中文翻译:**
噢，哇。

---

### [00:42:41] Judd Antin

**English:**
Who was-

**中文翻译:**
那是谁——

---

### [00:42:41] Lenny

**English:**
Does anyone say anything? I feel like every quote is-

**中文翻译:**
还有人说真话吗？我觉得每一句名言都是——

---

### [00:42:44] Judd Antin

**English:**
Is apocryphal, now? I know.

**中文翻译:**
现在都是杜撰的了？我知道。

---

### [00:42:46] Lenny

**English:**
Yeah. What is reality? Geez, can we? Well, let's just-

**中文翻译:**
是的。什么是真实的？天哪，我们能……好吧，让我们继续——

---

### [00:42:49] Judd Antin

**English:**
Okay, maybe he said that. He certainly believed that. That's what the historians say. But the reason that makes researchers so angry is because that's not research. That's not what researchers do. A researcher who's going to ask customers what they want is a bad researcher. You need a different researcher. I've never done that in my career. No one on my team has ever run a study that's like that. So that just makes researchers mad.

**中文翻译:**
好吧，也许他确实说过，或者他肯定深信不疑，历史学家是这么说的。但让研究员如此愤怒的原因是：那根本不是研究。那不是研究员该做的事。一个跑去问客户“你想要什么”的研究员是个糟糕的研究员，你需要换个人。在我的职业生涯中，我从未做过这种事，我团队里也没人做过那样的研究。所以这种说法只会让研究员生气。

---

### [00:43:16] Judd Antin

**English:**
And then the last one is about post-hoc bias. It's, "We knew this already. That was obvious." And I think a lot about this book, which I would recommend to your listeners. The author is a sociologist at UPenn named Duncan Watts, and the title is Everything is Obvious If You Already Know the Answer. And it's about hindsight bias. He makes the argument that we rely too much on intuition, heuristics, and pattern matching in a way that is inappropriate to our experience. And it's like it leads us astray. It's like a form of self gaslighting. And it happens because we end up selectively remembering things and then constructing narratives around them in a way which makes us feel like we already knew that, when we in fact did not.

**中文翻译:**
最后一个是关于“事后聪明偏见”的。即：“我们早就知道了，这很明显。” 我经常想到一本书，我想向听众推荐。作者是宾夕法尼亚大学的社会学家 Duncan Watts，书名是《常识：如果你已经知道答案，一切都很明显》（Everything is Obvious If You Already Know the Answer）。它是关于“后见之明偏见”的。他认为我们过于依赖直觉、启发式思维和模式匹配，这种方式与我们的实际经验并不相符。这会误导我们，就像一种自我“煤气灯效应”。之所以发生这种情况，是因为我们最终会选择性地记忆事物，然后围绕它们构建叙事，让我们觉得“我早就知道了”，而事实上我们当时并不知道。

---

### [00:44:05] Judd Antin

**English:**
And he talks about this other, one of those cognitive biases called the narrative fallacy, which is the idea that people love to make convenient, simple stories about the past. If I asked you about your career, Lenny, and how you got to be this amazing podcast host, you'd be like, "Well, let me tell you about this series of events." And we do that. It's part of how we make sense of our lives and the information around us, but it would probably be a lie in the sense that we all twist the evidence we have to fit the narrative we want to be true, because it's simple, and lovely, and makes us happy.

**中文翻译:**
他还谈到了另一种认知偏见，叫做“叙事谬误”（narrative fallacy），即人们喜欢为过去编造方便、简单的故事。Lenny，如果我问你的职业生涯，问你是如何成为这么出色的播客主持人的，你会说：“好吧，让我告诉你这一系列事件。” 我们都会这么做，这是我们理解生活和周围信息的方式。但在某种意义上，这可能是一个谎言，因为我们都会扭曲现有的证据，以符合我们希望成真的叙事，因为那样简单、美好，让我们感到快乐。

---

### [00:44:36] Lenny

**English:**
This is going to sound self-serving, but I find I'm the opposite. I'm like, "I have no idea how this all came about. Here's some things that happened, and somehow I ended up here." But maybe I'm being very modest and try to not give myself any credit.

**中文翻译:**
这听起来可能有点自夸，但我发现自己恰恰相反。我会说：“我完全不知道这一切是怎么发生的。这里发生了一些事，然后不知怎么的我就到了现在这个位置。” 但也许我只是表现得很谦虚，不想把功劳归于自己。

---

### [00:44:49] Judd Antin

**English:**
That's beautiful.

**中文翻译:**
那很棒。

---

### [00:44:50] Lenny

**English:**
Thank you for these tropes, by the way. This was fun. I didn't know you were going to do that. So that's a fun, little collection we've got, here.

**中文翻译:**
顺便说一下，谢谢你分享这些刻板印象。这很有趣，我没想到你会准备这个。我们这儿有了一个很有趣的小合集。

---

### [00:44:54] Judd Antin

**English:**
Thanks.

**中文翻译:**
谢谢。

---

### [00:44:56] Lenny

**English:**
I wanted to ask about, there's this tweet by Patrick Collison that I've brought up a couple of times on this podcast, that I think is really interesting. And his tweet is this, "In my opinion, the best product will stem from a very strong mental model of the domain and user. User research can help you get such a model and validate it along the way. But it's important to view the syllogism of UXR as model of user research, to improving your mental model of the user, to what product you should build versus user research tells you what product to build." Does that resonate in any way thoughts on that way of thinking about user research?

**中文翻译:**
我想问一下 Patrick Collison 的一条推文，我在这个播客里提过几次，我觉得很有意思。他的推文是这样的：“在我看来，最好的产品源于对领域和用户非常强大的心智模型（mental model）。用户研究可以帮助你建立这样的模型并在过程中进行验证。但重要的是，要将 UXR（用户研究）的逻辑看作是：通过用户研究模型来改进你对用户的心智模型，进而决定你应该构建什么样的产品，而不是让用户研究直接告诉你该构建什么产品。” 这种思考用户研究的方式是否引起了你的共鸣？

---

### [00:45:34] Judd Antin

**English:**
Yeah, there's a double-edged sword we talk about a lot in the research community, which is about making recommendations for design. So the best research doesn't leave it at that. It tells you, and it's like the what, the so what, and then the then what. But the problem with that is some researchers go too far in the other direction, where they're like, "We ran this study, it yielded these insights, and therefore this is what we should build." And everyone else on the team is like, "Whoa, whoa, whoa. Glad to hear your thoughts on the matter, but there's a lot going on here. Maybe we should talk about it." And that makes perfect sense. That's a failure of communication.

**中文翻译:**
是的，研究界经常讨论一把“双刃剑”，即关于提出设计建议。最优秀的研究不会止步于发现，它会告诉你“是什么”、“那又怎样”以及“接下来该做什么”。但问题在于，有些研究员走得太远了，他们会说：“我们做了这项研究，得出了这些洞察，因此这就是我们应该构建的东西。” 团队里的其他人会反应：“喔，喔，喔。很高兴听到你的想法，但这里情况很复杂，也许我们该商量一下。” 这完全合理，那其实是沟通上的失败。

---

### [00:46:19] Judd Antin

**English:**
And I think that speaks to the thing that Patrick is saying, is like, "Good research can sometimes tell us exactly what the problem is and exactly how to fix it." An example of that is the multimillion dollar button I told you about. But in a lot of the bigger picture questions, especially the macro ones and maybe also the really pointed middle range ones, the point isn't really, "This is exactly what we should do and this is exactly what we should build." It is, "Let us develop a framework which is based on actual evidence, and then together as a team figure out how we want to experiment our way to a successful product."

**中文翻译:**
我认为这正呼应了 Patrick 所说的。好的研究有时确实能确切地告诉我们问题出在哪里以及如何修复，比如我提到的那个价值数百万美元的按钮。但在很多宏观问题上，尤其是宏观研究以及那些非常有针对性的中观研究，重点并不在于“这就是我们必须做的，这就是我们必须构建的”，而在于“让我们建立一个基于实际证据的框架，然后作为一个团队，共同探索如何通过实验走向成功的产品”。

---

### [00:46:53] Lenny

**English:**
To close the loop on this specific thread, what is your advice to teams, researchers to help move out of this reckoning, and to move forward, and help the field, both from a user researcher perspective and also from just a company that maybe laid off a bunch of user researchers or is trying to decide what to do with their researchers?

**中文翻译:**
为了结束这个特定的话题，你对团队和研究员有什么建议，来帮助他们走出这场“大清算”，向前迈进并助力这个领域？无论是从用户研究员的角度，还是从那些可能裁掉了大量研究员或正在纠结如何安置研究员的公司的角度。

---

### [00:47:14] Judd Antin

**English:**
Thank you for asking. I think I said to you earlier, and I feel some pressure as maybe the first conversation that you've had specifically about research on this podcast.

**中文翻译:**
谢谢你的提问。我想我之前跟你说过，作为这档播客中可能是第一次专门讨论研究的嘉宾，我感到有些压力。

---

### [00:47:23] Lenny

**English:**
Yeah, I think so.

**中文翻译:**
是的，我想是的。

---

### [00:47:25] Judd Antin

**English:**
And I want to help. I believe so much in this discipline of research and insights, and I think when I said, "The UX research discipline of the last 15 years is dying," I didn't mean that I think research is dying, far from it. I think that there's a version of it, which we're now moving past and into a new version. We're going through an evolution, as many do. And so the question for me is like, "How can researchers, and the companies, and the other people with whom they work create a new version, a different version, an evolution, which is hugely impactful for the business?"

**中文翻译:**
我想提供帮助。我深信研究和洞察这门学科的价值。当我说“过去 15 年的 UX 研究学科正在消亡”时，我并不是说研究本身要消失了，远非如此。我认为是它的某一个版本正在成为过去，我们正进入一个新版本。我们正在经历一场进化，就像许多事物一样。所以对我来说，问题在于：“研究员、公司以及与他们共事的其他人，如何创造一个对业务产生巨大影响的新版本、一个进化的版本？”

---

### [00:47:57] Judd Antin

**English:**
And so the advice I'd give to researchers about that is develop diverse research skills. Remembering the five or five and a half tool list that I mentioned earlier, really go deep on that business knowledge, so speaking the language of product, and business, and metrics, and understanding exactly how to use your insights like a scalpel, building those strong relationships, which is not a thing that researchers can do by themselves. It requires two-way engagements, and also in a way which allows researchers to do fewer things better.

**中文翻译:**
我对研究员的建议是：培养多样化的研究技能。记住我之前提到的那五件（或五件半）工具清单。真正深入学习业务知识，学会用产品、业务和指标的语言交流，理解如何像手术刀一样精准地使用你的洞察。建立强大的关系，这不仅仅是研究员单方面能做到的，它需要双向的互动。同时，要让研究员能够“少做精做”。

---

### [00:48:30] Judd Antin

**English:**
So most researchers that I know are working on teams where they're like, "I'm the only researcher, and I have seven PMs and 20 designers, and I'm trying to do 10 projects." And no one's going to do a good job that way. So researchers have to learn with their partners about how to say no and focus on the most important things. But that's only half of it, right? That's the research side.

**中文翻译:**
我认识的大多数研究员所在的团队情况是：“我是唯一的研究员，我要对接 7 个 PM 和 20 个设计师，还要同时处理 10 个项目。” 这种方式下没人能把工作做好。所以研究员必须学会与合作伙伴一起拒绝不合理需求，专注于最重要的事情。但这只是问题的一半，对吧？这只是研究员这一侧。

---

### [00:48:51] Judd Antin

**English:**
I have two thoughts about what companies should be doing. The first one, it's a little bit of an aside, but not really. One thing I learned by through the responses to the article was everybody came out of the woodworks from the variety of insights disciplines that are out there. Because I come from a tradition of user experience research or user research, but there are many insights disciplines in many industries, and they all wanted to claim one type of research or another, and say, "Oh, well, we overhear in consumer insights or market research have been doing that well for years." And there are many insights disciplines. And generally I think creating silos is stupid.

**中文翻译:**
关于公司应该做什么，我有两点想法。第一点，这有点像题外话，但其实不是。通过对文章的反馈，我发现各种“洞察学科”的人都冒出来了。虽然我出身于传统的 UX 研究或用户研究，但许多行业都有很多洞察学科，他们都想宣称某种研究归他们管，并说：“噢，我们消费者洞察或市场研究部门多年来一直做得很好。” 洞察学科有很多，但我认为制造“孤岛”是愚蠢的。

---

### [00:49:33] Judd Antin

**English:**
Actually, I'm curious what you think, because here's the number one thing I heard when I joined Airbnb and you were there, is I did it a quick listening tour where I talked to a bunch of product people. And they all said the same thing. They were like, "Listen, we have all these different people throwing insights over the transom. And it's great. We want to hear from the data scientists, from the product specialists, from the customer service people, and the voice of the customer, whatever, all that stuff. But they're all coming over the side and we don't know what to make of it. It's too much."

**中文翻译:**
实际上，我很想听听你的看法。因为当我加入 Airbnb 时（你当时也在），我做了一个快速的“倾听之旅”，和一群产品人聊天。他们都说了同样的话：“听着，我们有这么多不同的人在向我们抛出洞察。这很好，我们想听数据科学家、产品专家、客服人员、‘客户之声’等等所有人的意见。但这些信息从四面八方涌来，我们不知道该怎么处理，信息量太大了。”

---

### [00:50:03] Judd Antin

**English:**
And that, as much as anything, is an argument for companies to stop siloing research disciplines. So when I joined Airbnb, I set out to create an integrated insights function where it's like, "Let's do UX research, let's talk about the market and competitors when we have to. Let's integrate smartly with data science functions. Let's integrate all the stuff we're getting from customer service feedback." We brought over what was then the NPS program and said, "Hey, if we're getting customer feedback there, let's all just use it all to fuel this one insights machine." So that's the first piece of advice I'd give companies.

**中文翻译:**
这有力地证明了公司应该停止将研究学科孤岛化。所以当我加入 Airbnb 时，我着手建立一个整合的洞察职能部门：我们做 UX 研究，必要时讨论市场和竞争对手；与数据科学职能智能整合；整合所有来自客服反馈的信息。我们接管了当时的 NPS（净推荐值）项目并说：“嘿，既然我们在那里收集客户反馈，那就让我们把所有这些都用来驱动这一个‘洞察机器’。” 这是我给公司的第一个建议。

---

### [00:50:38] Judd Antin

**English:**
And the second one, without being a broken record, is to think differently about the broken cycle. So integrate researchers into a unified, lean process. So if the researcher is not there from beginning to end, if there are not strong relationships between product people and design people at every level, engineering people at every level, and somebody who's their insights partner, we're going to fall back into this problem where we're just a service discipline, we're not extracting the maximum value, it comes too late, we don't know what questions to ask, we're ignorant about what research can do. And so creating that integrated, lean process where a researcher is arm in arm from the beginning, is the most important advice I'd give.

**中文翻译:**
第二个建议（虽然有点老生常谈）是：换个角度思考那个破碎的循环。将研究员整合进一个统一、精益的流程中。如果研究员没有从头到尾参与，如果各级产品人员、设计人员、工程人员与他们的洞察伙伴之间没有建立起强大的关系，我们就会重新陷入那个问题：我们只是一门“服务学科”，无法榨取最大价值，研究结果来得太晚，不知道该问什么问题，对研究能做什么一无所知。因此，建立一个研究员从一开始就并肩作战的整合、精益流程，是我能给出的最重要的建议。

---

### [00:51:19] Lenny

**English:**
That last piece may be the answer to this next question, but the question is how can product managers be better partners to user researchers/get more leverage out of user researchers?

**中文翻译:**
最后那一点可能就是下一个问题的答案，但问题是：产品经理如何成为用户研究员更好的合作伙伴，或者说如何从用户研究员那里获得更大的杠杆作用？

---

### [00:51:31] Judd Antin

**English:**
I think that is in many ways the answer, making sure that they are creating a process for the product, for their products, that it integrates user researchers and insights from beginning to end. Also, being willing to partner with the research on the ruthless prioritization. I used to say that, "A full plate for a researcher was probably three things, two big projects and a small project, like a side project. More than that, your researcher is probably not doing a very good job. And a project may take 48 hours. That's okay. But so they need your help to prioritize, they need you to participate. Great PMs will take the time to be with researchers to go into the field, even to travel." Did you ever do that, Lenny?

**中文翻译:**
我认为这在很大程度上就是答案：确保他们为产品建立的流程从始至终都整合了用户研究员和洞察。此外，要愿意与研究员合作进行“无情的优先级排序”。我以前常说：“一个研究员的工作量上限大概是三件事：两个大项目加一个小项目（比如副项）。再多的话，你的研究员可能就做不好了。一个项目可能只需要 48 小时，这没问题。但他们需要你帮忙排优先级，需要你参与。优秀的 PM 会花时间陪研究员去实地考察，甚至一起出差。” Lenny，你以前做过吗？

---

### [00:52:15] Lenny

**English:**
I did. I went with Louise, who introduced, we came up with this, basically told me to chat with you about this topic.

**中文翻译:**
我做过。我和 Louise 一起去的，正是她介绍并建议我就这个话题找你聊聊。

---

### [00:52:23] Judd Antin

**English:**
Thanks, Louise.

**中文翻译:**
谢谢 Louise。

---

### [00:52:24] Lenny

**English:**
Thanks, Louise. We did a whole tour to Paris, our whole team, or the leads of our team went to Paris to do a bunch of focus groups and a bunch of user research behind actual mirrors. I've never done that before that trip, and it was amazing. We learned a ton.

**中文翻译:**
谢谢 Louise。我们整个团队，或者说我们团队的负责人，去巴黎进行了一次完整的考察，在单向镜后面做了很多焦点小组和用户研究。在那次旅行之前我从未做过这种事，感觉太棒了，我们学到了很多。

---

### [00:52:38] Judd Antin

**English:**
Can I tell you a quick story about behind the mirror?

**中文翻译:**
我能讲一个关于单向镜后的小故事吗？

---

### [00:52:40] Lenny

**English:**
Please.

**中文翻译:**
请讲。

---

### [00:52:41] Judd Antin

**English:**
This is back from when I was at Facebook. And there was the high times there, it was like 2012, '13, and newsfeed is really taking off, ads are going into newsfeed. And I was a leader of a team that was working among other things on how to address post quality. Like, "How do we think about what's a good post and how do we get feedback about it?" And so there was a team of engineers that thought, "One thing that you can do on Facebook is hide a post." So they were like, "This is easy. Let's look at the posts that are hidden the most and use that as the signal of what's a good post on Facebook?" Seems reasonable. And something tripped me on this one. And so I did two things.

**中文翻译:**
这是我在 Facebook 时的事。那是 2012、13 年左右的鼎盛时期，信息流（Newsfeed）正飞速发展，广告也开始进入信息流。我当时领导一个团队，工作内容之一是解决帖子质量问题。比如：“我们如何定义什么是好帖子，以及如何获取相关反馈？” 有个工程师团队认为：“在 Facebook 上你可以‘隐藏帖子’。这很简单，让我们看看哪些帖子被隐藏得最多，并以此作为判断 Facebook 上什么是好帖子的信号。” 听起来很合理，但我总觉得哪里不对劲。于是我做了两件事。

---

### [00:53:26] Judd Antin

**English:**
So the first thing I did is I looked at the distribution of hiding by user, and found out that it's power law distributed, like everything on the internet. There are a few people on Facebook who hide a ton, and then most people don't hide at all. And so then what we did was, we call these super hiders, we called them super hiders. And so we said, "Let's find super hiders around the office, and we'll get a super hider in, and we'll do a really traditional user interview." We just wanted to see. So literally the first person who walked in, I remember, because this was a person who had those fingernails that are so long, you don't know how they can do touchscreens, but they did. They were amazing at it. And it was one of those rooms with the glass. And I insisted that the ENG directors, the product people, and they were willing, whatever.

**中文翻译:**
第一件事是，我查看了用户隐藏行为的分布，发现它符合幂律分布（power law），就像互联网上的所有事物一样。Facebook 上有极少数人隐藏了大量帖子，而大多数人根本不隐藏。于是我们把这些人称为“超级隐藏者”（super hiders）。我们说：“让我们在办公室附近找一些超级隐藏者，请一位过来，做一个非常传统的用户访谈。” 我们只想看看情况。我记得进来的第一个人，指甲特别长，你都不知道她怎么用触摸屏，但她用得非常溜。访谈是在那种带单向玻璃的房间里进行的。我坚持让工程总监、产品人员都过来观察，他们也愿意配合。

---

### [00:54:20] Judd Antin

**English:**
So everybody's behind the glass, and I'm there with them, and the excellent researcher is in the room, and they come in, and we're just doing a traditional think aloud study. And so they go, "Hey, can you open up your Facebook app? We would just love to see what your experience is like." So they open up Facebook, and were looking, and they look at the first story, and they hide it. They go to the second story and they hide it. And this went on for a while.

**中文翻译:**
大家都在玻璃后面，我也在那儿。一位优秀的研究员在房间里。访谈开始了，我们做的是传统的“出声思维”（think aloud）研究。研究员说：“嘿，你能打开你的 Facebook App 吗？我们想看看你的使用体验。” 于是她打开 Facebook，我们看着她，她看了第一条动态，隐藏了；看了第二条，又隐藏了。这种情况持续了一会儿。

---

### [00:54:43] Judd Antin

**English:**
And she's definitely using Facebook, but every time she'd finish with a story, she'd hide it. And the people in the back room were starting to chatter. And they're like, "Wait, what? What is happening right now?" And like the good researcher that this person was, they let it continue, and they're like, "Whoa, can you tell me what you're thinking right now?" Come to find out that she was like, "Well, I hid that story because I'd seen it already." The model she was going for was inbox zero, which was sad, because it was infinitely scrolling. She would never get there.

**中文翻译:**
她确实是在用 Facebook，但每看完一条动态，她就会把它隐藏掉。玻璃后面的人开始窃窃私语：“等等，什么情况？现在发生了什么？” 房间里的研究员非常专业，让过程继续下去，然后问：“喔，你能告诉我你现在在想什么吗？” 结果发现，她的想法是：“哦，我隐藏那条动态是因为我已经看过了。” 她追求的是“收件箱清零”（inbox zero）模式。这很悲哀，因为信息流是无限滚动的，她永远也清不了零。

---

### [00:55:16] Judd Antin

**English:**
And the reason I liked that story is because the people in the back room had their minds blown. It was not that we assumed that was common behavior, like this person could have been unique, but it was enough, because those people were there, experiencing the research, that N of one allowed them to burst their own bubble and realize, "Okay, we can't think so naïvely about hides as a signal anymore." And we came up with a better solution.

**中文翻译:**
我之所以喜欢这个故事，是因为玻璃后面那些人的三观被刷新了。并不是说我们假设这是普遍行为（那个人可能是特例），但这就足够了。因为那些决策者在现场亲历了研究，那个 N=1 的案例让他们打破了自己的幻想，意识到：“好吧，我们不能再天真地把‘隐藏’直接当作负面信号了。” 于是我们想出了更好的解决方案。

---

### [00:55:47] Lenny

**English:**
That is an awesome story and such a good example of you don't need statistical significance to get massive insights. One example just gives you a, "Wow, this might be exactly what's happening. Let's go validate that." Versus, like, "We are confident, 100%, this is what happened." I love that. It reminds me actually in the mirror study that I was talking about in Paris, there's a Facebook element to it, too. We were trying to convince hosts how to feel more comfortable accepting guests who are booking instantly. One of our theories was if they were connected on Facebook, they would be more comfortable letting someone book instantly.

**中文翻译:**
这是一个很棒的故事，也是一个极佳的例子，说明你不需要统计显著性也能获得巨大的洞察。一个例子就能让你惊呼：“哇，这可能正是发生的事情，让我们去验证一下。” 而不是说“我们 100% 确定发生了什么”。我喜欢这个。这让我想起我在巴黎提到的那个单向镜研究，里面也有 Facebook 的元素。我们当时试图说服房东，让他们更放心地接受“闪订”（instantly booking）的房客。我们的一个理论是：如果双方在 Facebook 上有联系，房东会更愿意让对方闪订。

---

### [00:56:21] Lenny

**English:**
And we're just like, "Hey, what if you were to connect Facebook and see if they're friends?" And everybody in Paris was very afraid of connecting and giving Facebook any data, way ahead of what the US hosts were feeling.

**中文翻译:**
我们当时想：“嘿，如果你连接 Facebook 看看他们是不是朋友会怎样？” 结果巴黎的每个人都非常害怕连接并向 Facebook 提供任何数据，这种担忧程度远超当时的美国房东。

---

### [00:56:34] Judd Antin

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:56:34] Lenny

**English:**
So it just made it very clear nobody wants to actually give Facebook any data. So it was very anti-Facebook at that point.

**中文翻译:**
所以这非常清楚地表明，没人真的想给 Facebook 任何数据。在那一点上，大家非常抵触 Facebook。

---

### [00:56:40] Judd Antin

**English:**
Yeah, that's so interesting. Germany and France were always our bellwethers for what the rest of the world would be thinking with data privacy concerns.

**中文翻译:**
是的，这很有趣。德国和法国一直是我们的风向标，预示着世界其他地区对数据隐私担忧的走向。

---

### [00:56:49] Lenny

**English:**
Oh, man. Okay, a couple more things. A lot of this started with a lot of layoffs within user research. And I think between the lines, there's a sense of teams don't need as many researchers as they hired during the ZIRP era. I think a question in everyone's mind is just like, "How many researchers do we need? What is a good ratio?" I imagine there's not a simple answer, here, but just what's your general advice to companies of how many researchers is it right?

**中文翻译:**
噢，天哪。好，还有几件事。这一切很大程度上始于用户研究领域的大量裁员。字里行间，人们感觉到团队并不需要像零利率（ZIRP）时代招聘的那么多研究员。我想每个人心中的疑问都是：“我们需要多少研究员？合适的比例是多少？” 我想象这没有一个简单的答案，但你对公司关于“多少研究员才合适”有什么普遍建议？

---

### [00:57:15] Judd Antin

**English:**
This is a thing I've thought a lot about, especially in my role as the head of the design studio, that was my fundamental question. It's like, "You have all these writers, designers, researchers, how do you structure them, how many, and where, and who works on what?" And the organizing principle for me was always relationships. You know you have enough when the people who need to have a concept research partner have them. And I would much rather create pain in that situation than spread someone too thinly.

**中文翻译:**
这是我思考了很多的问题，尤其是在我担任设计工作室负责人期间，这是我的根本问题。比如：“你有这么多文案、设计师、研究员，你如何组织他们？多少人？放在哪？谁负责什么？” 对我来说，组织原则始终是“关系”。当你觉得那些需要研究伙伴的人都已经有了伙伴时，你就知道人够了。在这种情况下，我宁愿让某些部门感到“缺人”的痛苦，也不愿让研究员分身乏术。

---

### [00:58:02] Judd Antin

**English:**
So my advice was always like, "Don't try to create a researcher to cover this entire product space. Pair a researcher up with somebody who's going to involve them in a consistent, engaged process, and let them go to work, and see the impact they're going to have, but protect their time. And then other people are like, "Wait a second, that person's doing great work. I want some of that." And creating that pain for them, because it's a pain of loss, is the number one way to grow headcount. That's how I always approached getting more headcount, was not arguing abstractly for why research is important, but by asking partners who wish they had it, to do the arguing for me.

**中文翻译:**
所以我的建议一直是：“不要试图让一个研究员覆盖整个产品领域。把一个研究员配给一个愿意让他们持续深度参与流程的人，让他们去工作，观察他们产生的影响，但要保护他们的时间。然后其他人会说：‘等一下，那个人做得太棒了，我也想要研究支持。’” 这种让他们感到“缺失”的痛苦，是增加员额（headcount）的头号方法。我争取更多员额的方法从来不是抽象地争论研究为什么重要，而是让那些渴望得到研究支持的合作伙伴替我去争论。

---

### [00:58:42] Judd Antin

**English:**
And so you're right, there isn't a clean answer for like, "Hey, this is the right ratio," because it really depends on the nature of the product. Like, "Is it a early stage product? Is it a late stage product? Are we talking about a startup or a late stage company?" But I would argue there's always room for a researcher. Lenny, I'll tell you, and I used this in a keynote talk I gave lately. You published recently a list of, I think it was about 20 B2B companies and their first 10 employees. Do you remember doing that?

**中文翻译:**
所以你说得对，没有一个明确的答案说“这就是正确的比例”，因为这取决于产品的性质。比如：“是早期产品还是后期产品？是初创公司还是成熟公司？” 但我认为，研究员总有一席之地。Lenny，我告诉你，我在最近的一次主题演讲中用过这个例子：你最近发布了一份名单，列出了大约 20 家 B2B 公司及其前 10 名员工。你记得吗？

---

### [00:58:51] Lenny

**English:**
Absolutely.

**中文翻译:**
当然记得。

---

### [00:58:52] Judd Antin

**English:**
Do you remember how many researchers are anywhere on that list? I'll give you a hint.

**中文翻译:**
你记得那份名单里有多少研究员吗？我给你个提示。

---

### [00:58:57] Lenny

**English:**
Not too many.

**中文翻译:**
不多。

---

### [00:58:57] Judd Antin

**English:**
It's between zero and two. It's one. There's one researcher on that list, anywhere. Anywhere. And that's messed up to me. Now, look, it's just these 20 companies, and each is in their own space, so I'm not going to overgeneralize. But a researcher can drive incredible value no matter what stage a company is at, because a good researcher makes you go faster, not slower, and they drive impact because they answer questions which are impossible to answer in any other way. That's true if you're a startup. It's true if you're a late stage company. Now, if it's your first 10 employees, one researcher is going to go a long way. As you grow, making sure that you're matching up researchers so that they have strong partners in the key parts of the business is the best way to figure out if you have enough.

**中文翻译:**
在 0 到 2 之间，其实只有 1 个。整份名单里只有一个研究员。我觉得这很不合理。当然，这只是那 20 家公司，每家都有自己的领域，我不想以偏概全。但无论公司处于什么阶段，研究员都能创造惊人的价值。因为优秀的研究员会让你跑得更快而非更慢，他们能产生影响力，因为他们回答了那些用其他方式无法回答的问题。初创公司如此，成熟公司亦然。如果是在前 10 名员工里，一个研究员能发挥巨大作用。随着公司的成长，确保将研究员与业务关键部门的强大伙伴匹配起来，是判断人手是否充足的最佳方式。

---

### [00:59:45] Lenny

**English:**
Interesting. So your advice is, as you're starting a company, your pitch is that you'll have a lot more leverage and move faster hiring a researcher versus generally an engineers, but you'd be trading off, essentially. That's what most of the hires end up being.

**中文翻译:**
很有意思。所以你的建议是，在创业初期，你的观点是招聘一名研究员（相比于通常招聘的工程师）会让你拥有更大的杠杆作用并移动得更快，但这本质上是一种权衡。而大多数公司的选择最终都是工程师。

---

### [00:59:58] Judd Antin

**English:**
I am reluctant to overgeneralize, and I would say I know many founders who are in startup mode are like, "I know what I need to build. The problem is that I need people who can help me execute." And I think that's right. And so everything's a trade off. But remember, imagine that you could have that Swiss army knife at your disposal. Maybe you've got an MVP out the door, and you're looking to make your first major iteration, or like many startups, you need to pivot. This is where it's like, "Hey, you don't have to do that alone." We deify startup founders who pivot appropriately, but I think that is what we would might call moral luck, where we deify the ones who got it right, and even though they made exactly the same decisions as the one who got them wrong.

**中文翻译:**
我不想说得太绝对。我知道很多处于创业模式的创始人会说：“我知道我要造什么，问题是我需要能帮我执行的人。” 我认为这没错，凡事都有权衡。但请记住，想象一下你手头有一把“瑞士军刀”。也许你的 MVP（最小可行性产品）已经发布了，你正准备进行第一次重大迭代，或者像许多初创公司一样需要转型（pivot）。这时候，“嘿，你不必孤军奋战”。我们神化那些成功转型的创始人，但我认为这可能被称为“道德运气”——我们神化那些做对了的人，即使他们做出的决策与那些失败的人完全一样。

---

### [01:00:46] Judd Antin

**English:**
And the fact of the matter is, if you have an insights person with you who has that Swiss army knife of tools, you're not in it alone. You don't have to guess. Ultimately, it will still come down to a tough decision that you and founders have to make, but you can have evidence that bears on that decision, which you wouldn't be able to get any other way.

**中文翻译:**
事实是，如果你身边有一个拥有“瑞士军刀”般工具箱的洞察人员，你就不是在孤军奋战。你不需要瞎猜。最终，这仍然取决于你和创始人必须做出的艰难决定，但你可以拥有支撑该决定的证据，而这些证据是你通过其他方式无法获得的。

---

### [01:01:05] Lenny

**English:**
To close out on this, and I have just a couple more questions on this thread, I think one of your big messages to researchers is, "You can be empowered. It's up to you to do the right sort of research and to move your career in the right direction, not become a researcher people don't need." And there's this quote that you have at the top of your post, where a lot of the reaction, or I guess the way you put it is, "I know what you're thinking, they just don't get it. We're so misunderstood. Our plight is to deliver insights that users use to drive business value while we're forgotten, never driving the roadmap, no seat at the table, consistently miscast, only to be laid off in the end." And what I'm hearing from you is like, "You can change that. You can push back on doing research that isn't actually contributing." But let me ask you, what's your lasting, I don't know, advice you would leave researchers with to be successful?

**中文翻译:**
关于这一点，我还有最后几个问题。我认为你传达给研究员的一个重要信息是：“你可以被赋能。做正确的研究并让职业生涯走向正确的方向取决于你自己，而不是成为一个别人不需要的研究员。” 你在文章开头引用了一段话，描述了很多人的反应：“我知道你在想什么，‘他们就是不明白。我们被误解得太深了。我们的困境是提供用户用来驱动业务价值的洞察，而我们却被遗忘，从未主导过路线图，在决策桌上没有一席之地，总是被错放位置，最后只能被裁掉。’” 而我从你这里听到的是：“你可以改变现状。你可以拒绝做那些没有实际贡献的研究。” 但我想问你，你会给研究员留下什么样的、能让他们成功的终极建议？

---

### [01:01:56] Judd Antin

**English:**
Yeah, it's tough to be operating in a broken system, and so I feel that response, where you feel kind of powerless, but I think that's not likely to lead us past this moment to the next evolution of research. So that's where it's like I don't blame any researcher at all for being in the spot they're in. It's been a tough go. However, crying about our lot is not going to get us anywhere. So I think the point of the article for me, and this is advice I give companies all the time when I do consulting with them, is like, "Hey, we can set this up in a different way, which responds to the current environment in a way which will drive a huge amount of impact."

**中文翻译:**
是的，在一个支离破碎的系统中运作确实很难，所以我能理解那种无力感。但我认为这种心态无法带我们度过当下，走向研究的下一次进化。所以我一点也不责怪任何处于这种境地的研究员，这确实不容易。然而，抱怨命运并不能让我们有任何进展。对我来说，这篇文章的重点（也是我咨询时经常给公司的建议）是：“嘿，我们可以用另一种方式来构建这个体系，以应对当前的环境，并产生巨大的影响力。”

---

### [01:02:55] Judd Antin

**English:**
Now, that takes companies making the right choices. It also takes researchers owning up and developing skills, pushing back, understanding what research can have the most value, developing the skills, and the knowledge, and language around the business, becoming more influential, being excellent communicators. It's one of the things I would evaluate the most in hiring, especially research leaders, because I needed them to show and teach by example, is like isn't just rigorous research. It's like if a tree fell in the forest and no one was there to hear it, you need to communicate it effectively, and you need to do it in a way that's appropriate to the audience. Because If I'm talking to you, Lenny, it's different than I'm talking to Brian Chesky at Airbnb. And so I got to be able to give that presentation effectively, and get right to the heart of it, and speak the right language. And so if you're a researcher, it's not hopeless. Actually the discipline, the future is so bright, and we can help it along by continuing to develop these different skills as companies build a model that's more inclusive.

**中文翻译:**
这需要公司做出正确的选择，也需要研究员承担起责任，培养技能，学会拒绝，理解什么样的研究最有价值，掌握业务知识和语言，变得更有影响力，成为卓越的沟通者。这是我在招聘（尤其是招聘研究领导者）时最看重的素质之一，因为我需要他们以身作则。这不仅仅关乎严谨的研究。就像如果森林里有一棵树倒了却没人听到，那它就没发生一样。你需要有效地沟通，并以适合受众的方式进行。因为 Lenny，我跟你说话的方式，和跟 Airbnb 的 Brian Chesky 说话的方式是不同的。我必须能够有效地进行演示，直击核心，并使用正确的语言。所以，如果你是一名研究员，这并非毫无希望。事实上，这个学科的前景非常光明，随着公司建立更具包容性的模型，我们可以通过不断发展这些技能来推动它的进步。

---

### [01:03:38] Lenny

**English:**
Awesome. Okay. I have one just random, tangential question about NPS. You have strong opinions about NPS, and I just wanted to hear your perspective on the value of NPS, your experience with NPS.

**中文翻译:**
太棒了。好，我有一个比较随机的、关于 NPS（净推荐值）的题外话。你对 NPS 有很强烈的看法，我想听听你对 NPS 价值的看法，以及你使用 NPS 的经验。

---

### [01:03:50] Judd Antin

**English:**
Yeah. I do have a strong opinion about NPS. I like to say, "NPS is the best example of the marketing industry marketing itself." And the problem is this threatens many people's livelihoods, because there's an entire industry of consultants and software providers that want you to believe NPS is a useful and accurate metric. The problem is, the consensus in the survey science community is that NPS makes all the mistakes. So it's a garbage in, garbage out problem. So the likelihood to recommend question is bad for a whole variety of reasons. So it's bad because it's a zero to 11 scale. It's bad because it's usually unlabeled. So we label the polls, but that's not the gold standard for research. It's bad because it's 11 items.

**中文翻译:**
是的，我对 NPS 确实有很强烈的看法。我常说：“NPS 是营销行业自我营销的最佳案例。” 问题在于，这威胁到了很多人的生计，因为有一个庞大的顾问和软件供应商行业，他们希望你相信 NPS 是一个有用且准确的指标。但问题是，调查科学界的共识是：NPS 犯了所有的错误。这是一个“垃圾进，垃圾出”的问题。“推荐可能性”这个问题由于各种原因都很糟糕：它是一个 0 到 10（共 11 级）的量表，这很糟糕；它通常没有标签（只有两端有标签），这不符合研究的金标准；它有 11 个选项，这也很糟糕。

---

### [01:04:37] Judd Antin

**English:**
And there's a couple of problems with that. Number one, we find that precision goes down after five items on average, maybe seven. Number two, especially on mobile, if you're taking this survey, what percentage of those options are below the fold? We are not going to get accurate survey data. And so from a survey perspective, it's really bad. There's also this intuition, which is like, "How likely are you to recommend Windows 11 to your friends and family?" I am not a person who goes around recommending operating systems. The question is fundamentally flawed.

**中文翻译:**
这有几个问题。第一，我们发现平均超过 5 个选项（最多 7 个）后，精确度就会下降。第二，特别是在手机上，如果你做这个调查，有多少选项是在首屏以下的？我们根本无法获得准确的调查数据。所以从调查的角度来看，它非常糟糕。还有一个直觉上的问题，比如：“你向亲友推荐 Windows 11 的可能性有多大？” 我不是那种到处推荐操作系统的人。这个问题从根本上就有缺陷。

---

### [01:05:11] Judd Antin

**English:**
The argument is that that question is a good indicator of loyalty, but there's a really simple solution, Lenny. Customer satisfaction, a simple CSAT metric, is better. It has better data properties, it is more precise, it is more correlated to business outcomes. I wanted to prove this. This is something that survey scientists know and marketers don't want you to know. And so we did the work with Mike Murakami, who led survey science at Airbnb, and he's still there, great researcher. And we basically redid all that work to find out if all that stuff was true just for Airbnb. And it is. It's simple. Don't ask NPS, ask customer satisfaction.

**中文翻译:**
人们争辩说这个问题是忠诚度的一个很好的指标，但 Lenny，有一个非常简单的解决方案：客户满意度（CSAT）。一个简单的 CSAT 指标更好，它具有更好的数据属性，更精确，且与业务结果的相关性更高。我想证明这一点。这是调查科学家知道而营销人员不想让你知道的事情。于是我和 Mike Murakami（他当时领导 Airbnb 的调查科学，现在还在那儿，是个伟大的研究员）一起做了研究。我们基本上重新做了所有的工作，看看这些结论在 Airbnb 是否成立。结果确实成立。很简单：别问 NPS，问客户满意度。

---

### [01:05:50] Lenny

**English:**
And the customer satisfaction question, what's the actual question for people to make sure?

**中文翻译:**
那么客户满意度的问题，具体是怎么问的，好让大家确认一下？

---

### [01:05:54] Judd Antin

**English:**
Overall, how satisfied are you with your experience with Airbnb? Or it could be some version of that, which is like, "Overall, how satisfied are you with your experience with customer service when you had a problem?" So there could be a more specific version of that question, but those questions have better properties. And a lot of people say, "Well, hey, everybody's using NPS. So at least it gives me a benchmark because I can compare my NPS to industry NPS." The problem with that is the research shows that NPS is idiosyncratic, so it goes up and downs in ways that we don't understand, and there's a lot of inconsistency in how it's asked, that creates variations in the data, which means it's not apples to apples, so you can't even compare your NPS meaningfully to somebody else's.

**中文翻译:**
“总体而言，你对在 Airbnb 的体验有多满意？” 或者也可以是某个变体，比如：“总体而言，当你遇到问题时，你对客服的体验有多满意？” 可以有更具体的版本，但这些问题的数据属性更好。很多人说：“嘿，大家都在用 NPS，所以它至少给了我一个基准，我可以把我的 NPS 和行业水平对比。” 问题在于，研究表明 NPS 是具有特异性的（idiosyncratic），它的起伏方式我们无法理解，而且提问方式存在大量不一致，这会导致数据偏差。这意味着它不是“苹果对苹果”的比较，你甚至无法将你的 NPS 与别人的进行有意义的对比。

---

### [01:06:37] Lenny

**English:**
I love these hot takes. I'm curious to see who comes out of the woodwork, too, when-

**中文翻译:**
我喜欢这些犀利的观点。我也很好奇当……的时候，会有谁跳出来反驳。

---

### [01:06:41] Judd Antin

**English:**
People are going to be so mad, Lenny.

**中文翻译:**
人们会气疯的，Lenny。

---

### [01:06:42] Lenny

**English:**
I love that. I think, yeah, I've heard this many times and people don't talk about it. Okay. Is there anything else you want to share or leave people with before we get to our very exciting lightning round?

**中文翻译:**
我喜欢这样。是的，我听过很多次这种说法，但大家都不公开谈论。好，在进入我们非常精彩的闪电轮环节之前，你还有什么想分享或留给大家的吗？

---

### [01:06:54] Judd Antin

**English:**
Can I? Yeah, I want to add one thing if I could, because this has come up on your podcast a few times recently, which is about the idea of people doing their own product walkthroughs. So should a PM just rely on their own dog fooding of the product and their own walkthrough to figure out how to fix it? And a couple of times recently this has come up, and I think the consensus seems to be, "Yes, this is a good thing." And I have a contrarian opinion there, too, which is that I think it is really important for everyone to dog food their own products. The problem is related to relying on your intuition about those products, which is the thing most PMs have trouble with is realizing, "You are nothing like the user. You are nothing like them in ways that will bias the way you think about what's good and bad in your product in ways that you can't necessarily recognize. Some things with a product, some problems with a product, you need a pulse to recognize."

**中文翻译:**
我可以吗？是的，我想补充一点。因为最近在你的播客中几次提到过这个话题，即关于人们自己进行产品走查（walkthroughs）。那么，PM 是否应该仅仅依靠自己对产品的“吃狗粮”（dogfooding，内部试用）和走查来决定如何修复它？最近几次提到这个话题时，共识似乎是：“是的，这是一件好事。” 我在这里也有一个相反的观点：我认为每个人试用自己的产品确实非常重要，但问题在于过度依赖对这些产品的直觉。大多数 PM 难以意识到的是：“你一点也不像真实用户。” 你在很多方面与他们完全不同，这会让你在判断产品优劣时产生偏见，而你未必能察觉到。产品的某些特性或问题，你需要通过观察真实用户的反应（pulse）才能识别出来。

---

### [01:07:57] Judd Antin

**English:**
And most good PMs that I know have a pulse and so cool. But a lot of them require context of use, priorities, constraints that you just don't have and you can't imagine purely on the basis of your own usage. So what I think that means is that you should definitely dog food your own product. Doing product walkthroughs to identify lists of potential issues is a great thing to do. Prioritizing that list, figuring out which ones are more or less a problem, and for whom is an area where you should be extremely wary of relying on your own opinion, expertise, or intuition when you are dog fooding your own product.

**中文翻译:**
我认识的大多数优秀 PM 都能把握脉搏，这很好。但很多问题需要特定的使用场景、优先级和约束条件，而这些是你仅仅基于自己的使用无法拥有或想象出来的。所以我的意思是：你绝对应该试用自己的产品，通过走查来列出潜在问题清单是一件很棒的事。但在对清单排优先级、判断哪些问题更严重以及对谁更严重时，你必须极其警惕，不要在试用产品时仅仅依赖自己的观点、专业知识或直觉。

---

### [01:08:39] Lenny

**English:**
Thank you for sharing that. It's definitely come up a bunch on this podcast, so I think that's an important lesson for people to take away. Anything else before we get to our very exciting lightning round?

**中文翻译:**
谢谢你的分享。这个话题确实在播客里出现过很多次，所以我认为这是一个很重要的教训。在进入精彩的闪电轮之前，还有别的吗？

---

### [01:08:49] Judd Antin

**English:**
I appreciate you, Lenny. Thanks for having me on.

**中文翻译:**
我很感激你，Lenny。谢谢你邀请我。

---

### [01:08:51] Lenny

**English:**
I appreciate you, Judd. Well, with that, we've reached our very exciting lightning round. Are you ready?

**中文翻译:**
我也很感激你，Judd。好，现在我们进入了非常精彩的闪电轮。准备好了吗？

---

### [01:08:56] Judd Antin

**English:**
I am ready.

**中文翻译:**
准备好了。

---

### [01:08:57] Lenny

**English:**
What are two or three books that you've recommended most to other people?

**中文翻译:**
你向别人推荐最多的两三本书是什么？

---

### [01:09:02] Judd Antin

**English:**
I recently read a business book by Barbara Kellerman called Bad Leadership. And what I love about it is that we spend a lot of time talking about good leaders, and she really dives into the worst leaders and what makes them bad leaders in a way that I think is really valuable for everybody.

**中文翻译:**
我最近读了一本 Barbara Kellerman 写的商业书，叫《糟糕的领导力》（Bad Leadership）。我喜欢它的原因是，我们花了太多时间讨论优秀的领导者，而她深入研究了最糟糕的领导者以及是什么让他们变得糟糕，我认为这对每个人都非常有价值。

---

### [01:09:19] Judd Antin

**English:**
I'd also recommend, I read a lot of fiction, so two recommendations, there. One, a recent Pulitzer Prize winner, Demon Copperhead by Barbara Kingsolver. It's an outstanding read that also is really sad, and moving, and illustrative, especially if you want to understand rural poverty. And then completely other side of the fiction spectrum, if you're interested in science fiction, which I am, read the Murderbot Diaries, it's about a sarcastic killer robot. And who doesn't love them?

**中文翻译:**
我还想推荐两本小说，我读很多小说。一本是最近的普利策奖得主，Barbara Kingsolver 的《恶魔铜头蛇》（Demon Copperhead）。这是一本杰作，非常悲伤、动人且具有启发性，特别是如果你想了解农村贫困。另一本属于完全不同的类型，如果你对科幻感兴趣（我就很感兴趣），读读《杀手机器人日记》（Murderbot Diaries），讲的是一个爱讽刺的杀手机器人。谁会不喜欢呢？

---

### [01:09:48] Lenny

**English:**
I love these fiction recommendations. I feel like we need more of these on the podcast, so thank you.

**中文翻译:**
我喜欢这些小说推荐。我觉得我们的播客需要更多这类推荐，谢谢。

---

### [01:09:52] Judd Antin

**English:**
Yeah. Everybody goes to business books.

**中文翻译:**
是的，大家总是盯着商业书。

---

### [01:09:53] Lenny

**English:**
Yeah, absolutely. What is a favorite recent movie or TV show that you really enjoyed?

**中文翻译:**
你最近非常喜欢的电影或电视剧是什么？

---

### [01:09:59] Judd Antin

**English:**
We recently watched The Last of Us and it blew our mind. I watched it after I played the video game after long last, if you are a person who plays video games and you haven't played The Last of Us, play it. If you don't know, the show is based on the video game, not the other way around.

**中文翻译:**
我们最近看了《最后生还者》（The Last of Us），简直太震撼了。我是玩完游戏后才看的。如果你玩游戏但还没玩过《最后生还者》，去玩吧。如果你不知道的话，这部剧是根据游戏改编的，而不是相反。

---

### [01:10:14] Lenny

**English:**
Do you have a favorite interview question you like to ask candidates that you're interviewing?

**中文翻译:**
在面试候选人时，你有没有最喜欢的面试问题？

---

### [01:10:19] Judd Antin

**English:**
Think of a topic that you had to explain lately that was the most complex, and then explain it to me like I'm five. And there are a lot of ways to vary that question, but the reason I like it is because I think, and I've asked this question to VP and C-suite candidates in multiple disciplines, and sometimes it's related to a conversation, like I might ask them to explain something complicated about quantum computing, or music theory, or it could be a complex business decision, but I want to see if somebody can break a complex problem down in a really simple way, and give me an intuition for it in a short amount of time. I think that is a differentiator between good and great for many people.

**中文翻译:**
“想一个你最近不得不解释的最复杂的话题，然后像对我这个五岁小孩一样解释给我听。” 这个问题有很多变体，但我喜欢它的原因是，我曾对多个专业的副总裁（VP）和 C 级高管候选人问过这个问题。有时它与对话内容有关，比如我可能会让他们解释量子计算或音乐理论中复杂的东西，或者是一个复杂的业务决策。我想看看对方是否能以非常简单的方式分解复杂问题，并在短时间内让我产生直观的理解。我认为这是区分“优秀”与“卓越”的关键。

---

### [01:11:02] Lenny

**English:**
Do you have a favorite product you recently discovered that you really like?

**中文翻译:**
你最近有没有发现什么非常喜欢的个人心头好产品？

---

### [01:11:06] Judd Antin

**English:**
Yeah, this is a really weird one, but my whole family started indoor rock climbing recently, and there's a challenge you have when you top rope, which is that you're looking up all the time. So they make these glasses, which are called belay glasses, and they have an angled mirror embedded in the lens, so that you can look straight ahead, and the view you see is up towards the person who you're belaying. And I just thought that product is so perfect for that. That's a niche problem and there isn't a better way to solve it.

**中文翻译:**
是的，这个有点奇怪。我们全家最近开始练习室内攀岩。在进行顶绳攀登时有一个挑战，就是你必须一直抬头看。所以有人发明了这种眼镜，叫“保护眼镜”（belay glasses）。镜片里嵌入了一个有角度的镜子，这样你就可以直视前方，而你看到的视野却是向上对着你正在保护的那个人。我觉得这个产品太完美了，它解决了一个小众问题，而且没有更好的替代方案。

---

### [01:11:37] Lenny

**English:**
Do you have a favorite motto that you often come back to, that you share with friends either in work or in life that you find useful?

**中文翻译:**
你有没有经常想起、并会分享给工作或生活中的朋友的座右铭？

---

### [01:11:44] Judd Antin

**English:**
Yeah. This is going to seem like pandering, Lenny, but I don't know if you remember a conversation that you and I had, it must've been eight years ago. I remember where we were sitting. And it was about stoicism. Do you remember this? Anyway, we had this conversation.

**中文翻译:**
是的。这听起来可能有点像在讨好你，Lenny。但我不知道你是否记得大概八年前我们的一次谈话，我还记得我们当时坐在哪儿。那是关于斯多葛主义（stoicism）的。你还记得吗？总之，我们聊过这个。

---

### [01:11:59] Lenny

**English:**
I don't, but I was into stoicism for a while.

**中文翻译:**
我不记得了，但我确实迷过一段时间斯多葛主义。

---

### [01:12:01] Judd Antin

**English:**
I know you were, because we talked about it. And so the motto comes from stoicism, which is basically, "Focus on the things you can control and ignore the rest." And a lot of people think of this as the serenity prayer or the serenity saying, that was a 20th century invention, but Epictetus was writing about this BC, and I think about it all the time. So much of the stress, and pain, and worry that we have in life comes from things we can't control. So I try to let those things go.

**中文翻译:**
我知道你迷过，因为我们聊过。所以这个座右铭来自斯多葛主义，基本上就是：“专注于你能控制的事情，忽略其余的。” 很多人认为这是“宁静祷文”，那是 20 世纪的发明，但爱比克泰德（Epictetus）在公元前就写过这个。我一直在思考它。我们生活中那么多的压力、痛苦和担忧都源于我们无法控制的事情。所以我试着放下那些。

---

### [01:12:34] Lenny

**English:**
Amazing. I learned that lesson from 7 Habits of Highly Effective People, and just the importance of thinking about these circles of you can control, you can influence, and you have no control over, and there's no reason to think about those other things.

**中文翻译:**
太棒了。我是从《高效能人士的七个习惯》中学到这一课的，即思考“控制圈”、“影响圈”和“关注圈”的重要性。对于你无法控制的事情，没有理由去纠结。

---

### [01:12:46] Absolutely.

**English:**
Absolutely.

**中文翻译:**
绝对正确。

---

### [01:12:47] Lenny

**English:**
Judd, this was everything I hoped it would be. We got into some really good stuff. I'm excited to hear how people react. Two final questions, where can folks find you if they want to learn about what you're up to, actually share what you're up to these days, and how people can find you, and then also how can listeners be useful to you?

**中文翻译:**
Judd，这期节目完全达到了我的预期。我们探讨了一些非常棒的内容。我很期待听到大家的反应。最后两个问题：如果大家想了解你的近况，可以在哪里找到你？顺便分享一下你最近在忙什么。以及，听众可以为你提供什么帮助？

---

### [01:13:01] Judd Antin

**English:**
Yeah. Thanks for asking those questions. People can find me at juddantin.com. That's the best way to find out what I'm up to. These days, I'm a consultant. I help people with UX strategy, org design, and crisis management. Somehow I love dealing with other people's dumpster fires, and I've found that I'm constitutionally good at it somehow. So juddantin.com is the place to find out. I also write. I write a medium post that you can find at onebigthought.com. And you'll find a lot of the topics we talked about today, including the original post that started this at onebigthought.com. If there's one thing I could ask your listeners to do is to get next to your researcher. I just think if you build those relationships and involve a researcher and insights person early and often, beautiful things will happen for you and for the business. So that's the thing everyone can do for me.

**中文翻译:**
好的，谢谢提问。大家可以在 juddantin.com 找到我，那是了解我近况的最佳途径。目前我是一名顾问，帮助人们处理 UX 策略、组织设计和危机管理。不知为何，我喜欢处理别人的“烂摊子”（dumpster fires），而且我发现自己天生擅长这个。所以 juddantin.com 是了解我的地方。我也写作，你可以在 onebigthought.com 找到我的 Medium 文章。你会发现很多我们今天讨论的话题，包括引发这次讨论的那篇原文。如果说我有一件事想请听众去做，那就是：贴近你的研究员。我认为如果你建立起这些关系，并尽早、经常地让研究员和洞察人员参与进来，你和业务都会发生美好的事情。这就是大家能为我做的事。

---

### [01:13:56] Lenny

**English:**
I love that. I've always done that. I loved my researchers that I've worked with, many of them reporting to you, and so beautiful takeaway. Judd, thank you so much for being here.

**中文翻译:**
我喜欢这个建议。我一直都是这么做的，我非常喜欢共事过的研究员，他们中很多人曾向你汇报。这是一个非常棒的总结。Judd，非常感谢你能来。

---

### [01:14:07] Judd Antin

**English:**
Lenny, thank you. It's been a pleasure.

**中文翻译:**
Lenny，谢谢你。这是我的荣幸。

---

### [01:14:09] Lenny

**English:**
Bye, everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcast, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review, as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
再见，各位。非常感谢收听。如果你觉得本期节目有价值，可以在 Apple Podcast、Spotify 或你喜欢的播客应用中订阅。此外，请考虑给我们评分或留下评论，这能真正帮助其他听众发现本播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。