# Jules Walter - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Jules Walter.

---

### [00:00:00] Jules Walter

**English:**
If you give me feedback, I'll be like, "Hey, thank you so much. This is super helpful," because people are like, "Oh, he actually likes the feedback." Now, inside my heart might be melting. I'm like, "Oh, I thought I got better at this." You know what I mean?

**中文翻译:**
如果你给我反馈，我会说：“嘿，非常感谢。这非常有帮助。” 因为这样人们会觉得：“噢，他其实挺喜欢反馈的。” 但实际上，我内心可能正在“崩溃”。我会想：“噢，我以为我在这方面已经进步了。” 你懂我意思吧？

---

### [00:00:14] Lenny

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:00:14] Jules Walter

**English:**
But externally, I'm like, "Hey, thank you," and I mean it. I think that's the key that most people don't focus on. And if you get more feedback, then you'll just get better at the things.

**中文翻译:**
但在外表上，我会说：“嘿，谢谢你，” 而且我是真心的。我认为这是大多数人没有关注到的关键。如果你能获得更多反馈，你就能在这些事情上做得更好。

---

### [00:00:26] Lenny

**English:**
Welcome to Lenny's Podcast. I'm Lenny and my goal here is to help you get better at the craft of building and growing products. Today, my guest is Jules Walter. Jules is a product leader at YouTube. Before that, he spent four and a half years at Slack, where he was their first growth PM and then went on to lead their monetization teams and also their mobile team. He's also the co-founder and a board member of the Black Product Managers Network and CodePath, both of which are nonprofits that aim to increase diversity within tech. Jules and I have collaborated on a number of projects over the years, including a killer guest post on building product sense that continues to be one of the most shared and beloved posts in my newsletter.

**中文翻译:**
欢迎来到 Lenny 的播客。我是 Lenny，我的目标是帮助你在打造和增长产品这项手艺上变得更精进。今天的嘉宾是 Jules Walter。Jules 是 YouTube 的产品负责人。在此之前，他在 Slack 工作了四年半，是那里的第一位增长产品经理（Growth PM），随后领导了他们的变现团队和移动团队。他还是 Black Product Managers Network 和 CodePath 的联合创始人及董事会成员，这两个都是旨在增加科技行业多样性的非营利组织。Jules 和我在过去几年里合作过很多项目，包括一篇关于培养“产品感”（Product Sense）的超棒客座文章，那篇文章至今仍是我通讯（Newsletter）中最受欢迎、分享次数最多的文章之一。

---

### [00:01:04] Lenny (Continued)

**English:**
In our conversation, we focus on what skills matter most in advancing a PM's career, and more importantly, all the ways Jules has found to build those skills. We also go deep on mentorship, how to find a mentor, what to look for in a mentor, how to get someone to agree to be a mentor, and a lot more. I super enjoyed this conversation, which I'm sure you can tell. Jules is such a gem of a human. I can't wait for you to hear this episode. With that, I bring you Jules Walter after a short word from our sponsors.

**中文翻译:**
在我们的对话中，我们重点讨论了哪些技能对产品经理的职业晋升最重要，更重要的是，Jules 发现的培养这些技能的所有方法。我们还深入探讨了导师制度（Mentorship）：如何寻找导师、在导师身上寻找什么特质、如何让别人同意担任你的导师等等。我非常享受这次对话，我相信你们也能听出来。Jules 是一个非常优秀的人。我迫不及待想让你们听到这一集。在听完赞助商的简短介绍后，我们将请出 Jules Walter。

---

### [00:01:36] Lenny (Sponsor: Vanta)

**English:**
This episode is brought to you by Vanta, helping you streamline your security compliance to accelerate growth. If your business stores any data in the cloud, then you've likely been asked or you're going to be asked about your SOC 2 compliance. SOC 2 is a way to prove your company's taking proper security measures to protect customer data and builds trust with customers and partners, especially those with serious security requirements. Also, if you want to sell to the enterprise, proving security is essential. SOC 2 can either open the door for bigger and better deals or it can put your business on hold. If you don't have a SOC 2, there's a good chance you won't even get a seat at the table. Beginning a SOC 2 report can be a huge burden, especially for startups. It's time-consuming, tedious, and expensive. Enter Vanta. Over 3000 fast growing companies use Vanta to automate up to 90% of the work involved with SOC 2. Vanta can get you ready for security audits in weeks instead of months, less than a third of the time that it usually takes. For a limited time, Lenny's Podcast listeners get $1,000 off Vanta. Just go to vanta.com/lenny to learn more and to claim your discount. Get started today.

**中文翻译:**
本集节目由 Vanta 赞助，Vanta 帮助你简化安全合规流程以加速增长。如果你的业务在云端存储任何数据，那么你很可能已经被问到或将被问到关于 SOC 2 合规性的问题。SOC 2 是证明你的公司采取了适当安全措施来保护客户数据的一种方式，它能建立客户和合作伙伴的信任，尤其是那些有严格安全要求的客户。此外，如果你想向企业销售产品，证明安全性至关重要。SOC 2 既可以为你打开更大、更好的交易大门，也可能让你的业务停滞不前。如果你没有 SOC 2，你很可能连谈判桌都上不去。开始一份 SOC 2 报告可能是一个巨大的负担，尤其是对初创公司而言。它耗时、繁琐且昂贵。Vanta 应运而生。超过 3000 家快速增长的公司使用 Vanta 来自动化高达 90% 的 SOC 2 相关工作。Vanta 可以在几周内而不是几个月内让你准备好接受安全审计，时间不到通常所需时间的三分之一。在限定时间内，Lenny 播客的听众可以享受 Vanta 1000 美元的优惠。只需访问 vanta.com/lenny 了解更多信息并领取折扣。今天就开始吧。

---

### [00:02:54] Lenny (Sponsor: Notion)

**English:**
This episode is brought to you by Notion. If you haven't heard of Notion, where have you been? I use Notion to coordinate this very podcast, including my content calendar, my sponsors, and prepping guests for launch of each episode. Notion is an all-in-one team collaboration tool that combines note-taking, document sharing, wikis, project management, and much more into one space that's simple, powerful, and beautifully designed. And not only does it allow you to be more efficient in your work life, but you can easily transition to using it in your personal life, which is another feature that truly sets Notion apart. The other day, I started a home project and immediately opened up Notion to help me organize it all. Learn more and get started for free at notion.com/lennyspod. Take the first step towards an organized happy team today, again, at notion.com/lennyspod.

**中文翻译:**
本集节目由 Notion 赞助。如果你还没听说过 Notion，那你这段时间去哪儿了？我用 Notion 来协调这个播客，包括我的内容日历、赞助商，以及为每集节目的发布准备嘉宾资料。Notion 是一款全能的团队协作工具，它将笔记、文档共享、维基（Wikis）、项目管理等功能整合到一个简洁、强大且设计精美的空间中。它不仅能让你在工作中更高效，你还可以轻松地将其过渡到个人生活中使用，这是 Notion 真正与众不同的另一个特点。前几天，我开始了一个家庭项目，立刻打开 Notion 来帮我整理一切。访问 notion.com/lennyspod 了解更多信息并免费开始使用。今天就迈出通往有序、快乐团队的第一步，网址依然是 notion.com/lennyspod。

---

### [00:03:49] Lenny

**English:**
Jules, welcome to the podcast.

**中文翻译:**
Jules，欢迎来到播客。

---

### [00:03:52] Jules Walter

**English:**
Hey, Lenny. Thanks for having me. I'm really excited.

**中文翻译:**
嘿，Lenny。谢谢你邀请我。我非常兴奋。

---

### [00:03:54] Lenny

**English:**
I am even more excited. This chat has been a long time coming. I've been hoping to get you on this podcast ever since this podcast even launched. And then in the meantime, while we've been waiting to schedule it, a number of guests have mentioned how useful you've been to them in their career, and so I'm just really excited to finally have you on.

**中文翻译:**
我比你更兴奋。这次聊天期待已久。自从这个播客启动以来，我就一直希望能邀请你。在等待排期的这段时间里，好几位嘉宾都提到过你在他们的职业生涯中提供了多么大的帮助，所以我真的很激动终于能请到你。

---

### [00:04:11] Jules Walter

**English:**
Yeah, same here.

**中文翻译:**
是的，我也是。

---

### [00:04:12] Lenny

**English:**
Let's just start with a quick overview of your background. Could you share some of the wonderful places you've worked, some of the wonderful projects you've worked on, and then just a bit about what you're working on today?

**中文翻译:**
让我们先简单回顾一下你的背景。你能分享一下你工作过的一些优秀公司、参与过的一些精彩项目，以及你目前正在做的事情吗？

---

### [00:04:25] Jules Walter

**English:**
Yeah, happy to. Some quick background, grew up in Haiti, studied computer science in college, went to business school. My first career was actually not in tech; it was in medical devices. I was a GM for a company based out of France and also overseeing West Africa business for them. After doing that, I moved back to the US, launched my own startup, which didn't work out, and then I moved to the Bay Area roughly eight years ago. In the Bay Area I wanted to become a PM, which was really hard to get into. At first, I joined a startup, series a company, became head of product for them, and then join Slack as the first PM on their growth team. Then from there, help scale the growth team at Slack. When I joined revenue was around 50 million; when I left roughly four years ago was 10x that. And then after Slack I recently joined YouTube Google about two years ago. At Google I'm a product lead at YouTube, where I'm driving a product called Primetime Channels, which actually recently launched in November in the US. And in that product, we're bringing streaming services to YouTube so that users can watch their favorite movies, shows, and sports content.

**中文翻译:**
好的，很乐意分享。简单介绍一下背景：我在海地长大，大学学习计算机科学，后来读了商学院。我的第一份职业其实不在科技行业，而是在医疗器械行业。我曾担任一家法国公司的总经理，并负责他们的西非业务。之后，我回到美国，创办了自己的初创公司，但没成功。大约八年前，我搬到了湾区。在湾区，我想成为一名产品经理（PM），但这很难进入。起初，我加入了一家 A 轮融资的初创公司，担任他们的产品负责人，然后加入 Slack，成为他们增长团队的第一位 PM。之后，我帮助 Slack 扩大了增长团队。我加入时，年营收约为 5000 万美元；大约四年前我离开时，营收增长了 10 倍。离开 Slack 后，我大约在两年前加入了 Google 的 YouTube。在 Google，我是 YouTube 的产品主管，负责一个名为 Primetime Channels 的产品，该产品最近于 11 月在美国上线。在这个产品中，我们将流媒体服务引入 YouTube，让用户可以观看他们喜爱的电影、节目和体育内容。

---

### [00:05:35] Lenny

**English:**
Amazing. The reason that I think we pushed this schedule of this podcast recording out is because you've been working on that product for many months and I'm glad to hear that it's finally launched. How did the launch go?

**中文翻译:**
太棒了。我想我们推迟这次播客录制的原因就是你已经在这个产品上工作了好几个月，很高兴听到它终于上线了。发布情况怎么样？

---

### [00:05:45] Jules Walter

**English:**
So far so good. It's really exciting to take a product from nothing to something.

**中文翻译:**
目前为止一切顺利。把一个产品从无到有做出来真的很令人兴奋。

---

### [00:05:49] Lenny

**English:**
Especially at a company like Google.

**中文翻译:**
尤其是在像 Google 这样的公司。

---

### [00:05:51] Jules Walter

**English:**
Yeah. And then over time we are adding more exciting content onto the product. We just recently announced that we're adding NFL Sunday Ticket in 2023 to primetime channels and also to YouTube TV. It's been a really exciting project.

**中文翻译:**
是的。随着时间的推移，我们正在为产品添加更多精彩内容。我们最近刚宣布，将在 2023 年把 NFL Sunday Ticket（NFL 周日门票）引入 Primetime Channels 和 YouTube TV。这是一个非常令人兴奋的项目。

---

### [00:06:05] Lenny

**English:**
That's awesome. I bet there's a lot of stories there, but I know you can't talk too much about what's happening at Google, so we'll move on. I like the point that you made about joining a startup, like you were trying to get into product management and you joined a startup as their first PM. I think you mentioned that's how you got into the PM path or I guess... Correct me if I'm wrong, but that's an interesting example of one of the paths into product management: joining a startup, getting into product there.

**中文翻译:**
太棒了。我敢打赌那里有很多故事，但我知道你不能透露太多关于 Google 内部的情况，所以我们继续。我很喜欢你提到的关于加入初创公司的观点，比如你想进入产品管理领域，然后加入了一家初创公司担任他们的第一位 PM。我想你提到过这就是你进入 PM 路径的方式……如果我错了请纠正我，但这是进入产品管理路径的一个有趣例子：加入初创公司，在那里开始做产品。

---

### [00:06:27] Jules Walter

**English:**
Not as their first PM, but I joined as one of their first PMs. Yeah.

**中文翻译:**
不是第一位 PM，我是作为他们最早的几位 PM 之一加入的。是的。

---

### [00:06:31] Lenny

**English:**
As one of their first PMs?

**中文翻译:**
最早的几位 PM 之一？

---

### [00:06:32] Jules Walter

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:06:33] Lenny

**English:**
That's something I hear often is just one of the paths to product management is join a startup, start doing product, and then you're a PM. And then you have a PM title on your resume and you can now join other companies. Is that something you found or anything you can take away from that experience?

**中文翻译:**
我经常听到的一种进入产品管理的路径就是：加入一家初创公司，开始做产品工作，然后你就成了 PM。接着你的简历上就有了 PM 的头衔，现在你可以加入其他公司了。这是你的发现吗？或者你从那段经历中有什么收获？

---

### [00:06:46] Jules Walter

**English:**
Yeah. It's really, really hard to get into product and there isn't a really set path to do that. What I've seen is the path that we just talked about, join a startup and then from there go into different companies. And then the other path that is typical is being at a company and then switching product management, especially if you develop domain expertise and there's a need for a PM. So, that's even more frequent. Of course there's also acquisitions that sort of thing, but making that initial transition is really hard.

**中文翻译:**
是的。进入产品领域真的非常非常难，而且没有一个固定的路径。我看到的是我们刚才讨论的那条路：加入初创公司，然后以此为跳板去不同的公司。另一条典型的路径是留在原公司然后转岗到产品管理，特别是如果你培养了领域专业知识且公司需要 PM 的话。这种情况甚至更频繁。当然还有通过收购等方式进入的，但最初的转型确实很难。

---

### [00:07:19] Lenny

**English:**
I didn't realize you were the first growth PM at Slack. That is a big role. How did that work out? How did you become the first growth PM at Slack? Was that the first time you're doing growth? What's the story there?

**中文翻译:**
我之前没意识到你是 Slack 的第一位增长 PM。那是一个很重要的角色。那是怎么实现的？你是如何成为 Slack 第一位增长 PM 的？那是你第一次做增长吗？背后的故事是什么？

---

### [00:07:30] Jules Walter

**English:**
I joined Slack early 2016 and the role that was available at the time was growth. I did not know anything about growth, but I was like, "Hey, this is my way in at such a great company." So, that's what I joined to do. And then what I did there was really take a learning mindset and lean on mentors, and we can talk about that to really learn the practice of growth and applied for Slack.

**中文翻译:**
我在 2016 年初加入 Slack，当时开放的职位是增长。我对增长一无所知，但我当时想：“嘿，这是我进入这么棒的公司的一个机会。” 所以我就去做了。我在那里做的是保持学习的心态，并依靠导师（我们可以稍后详细聊聊这个），去真正学习增长的实践并将其应用到 Slack 中。

---

### [00:08:00] Lenny

**English:**
Cool. We're definitely going to talk about some of those things. Just thinking about that experience and that ride at Slack, what's like maybe the most tangible memory or most, I don't know, interesting story of just riding that rocket ship of Slack growth as one of their early PMs?

**中文翻译:**
太酷了。我们肯定会聊到这些。回想在 Slack 的那段经历和历程，作为早期 PM 之一，在那艘增长火箭上的最深刻记忆或最有趣的故事是什么？

---

### [00:08:14] Jules Walter

**English:**
There's many, many stories. My experience was I got in, didn't know much about growth, and then through mentorship, in particular, one mentor, Bangaly Kaba, sort of learned how to apply growth frameworks to my work. And then when I did that within six months, I was able to ship changes in the new user experience, especially on mobile. That moved the needle by a lot, like double-digit percentages within your [inaudible 00:08:38]. And we're talking about top line metrics like activation. It was just interesting being able to have such impact very quickly at a company, and then the company itself went through all these milestones. I mentioned I joined 50 million, the next thing it's a hundred, and it keep doubling, going through a public offering. So, there's just so many stories that are unique to hyper growth.

**中文翻译:**
有很多很多故事。我的经历是：我刚进去时对增长知之甚少，然后通过导师指导，特别是一位叫 Bangaly Kaba 的导师，学会了如何将增长框架应用到我的工作中。当我这样做之后，在六个月内，我就能发布新用户体验的改动，特别是在移动端。这极大地推动了指标的增长，比如在某些方面实现了两位数的百分比增长。我们谈论的是像“激活”（Activation）这样的核心指标。在一家公司能如此迅速地产生这样的影响力，这非常有趣。然后公司本身也经历了一系列里程碑。我提到我加入时营收是 5000 万，接着是 1 亿，然后不断翻倍，直到上市。所以，有很多属于这种“超速增长”（Hyper growth）阶段的独特故事。

---

### [00:09:01] Lenny

**English:**
You also didn't mention in your background all these kind of extracurricular activities that you have. I've always been impressed with how much time you put into things that are kind of just volunteer projects on the side. Can you talk about some of the stuff that you do outside of your actual day job?

**中文翻译:**
你在背景介绍里没提到你那些“课外活动”。我一直对你在那些业余志愿者项目上投入的时间感到印象深刻。你能聊聊你在本职工作之外做的一些事情吗？

---

### [00:09:15] Jules Walter

**English:**
Outside of my work at YouTube now and also my family and young kids, I'm also involved with two nonprofits that I co-founded. Both of them are actually about improving diversity in tech, which is something I'm really passionate about. The first one is called CodePath and it's improving diversity for software engineers, and the second one is Black PMs focused on product management. With CodePath specifically, what we do is we train over 5,000 students every year at universities, typically the university with strong underrepresented populations, and we help them find internships and jobs at top tech companies. And then with Black PMs, we have a community of over a thousand PMs and aspiring PMs and then we help them find community and also grow their skills. Both of them are nonprofits that I wasn't actually setting out to build them. It's more like I had the need myself or I wish I had those sort of support when I was earlier in my career. And then I started helping folks and then one thing led to the other, especially my co-founders, and then these became big.

**中文翻译:**
除了在 YouTube 的工作以及照顾家庭和年幼的孩子外，我还参与了我共同创立的两个非营利组织。这两个组织实际上都是为了提高科技行业的多样性，这是我非常有激情的事情。第一个叫 CodePath，旨在提高软件工程师的多样性；第二个是 Black PMs，专注于产品管理。具体到 CodePath，我们每年在大学培训超过 5000 名学生，通常是那些少数群体比例较高的大学，帮助他们在顶尖科技公司找到实习和工作。至于 Black PMs，我们有一个由 1000 多名 PM 和有志于成为 PM 的人组成的社区，帮助他们找到归属感并提升技能。这两个非营利组织最初都不是我刻意要建立的。更多是因为我自己有这种需求，或者我希望在职业生涯早期能有这样的支持。于是我开始帮助别人，接着一件事引发了另一件事，特别是在我的联合创始人们的帮助下，这些组织逐渐壮大了。

---

### [00:10:22] Lenny

**English:**
Sounds like a classic startup story, solve your own problem and turns into a larger and larger thing. I think I try to work with Black PMs as much as I can, and I know that you recently had a conference, which is so cool. I don't know, it was a really big conference that you organized. I don't know how you all had time for all that, but anything you can share about this conference and is there another one coming?

**中文翻译:**
听起来像个经典的创业故事：解决自己的问题，然后它变得越来越大。我一直在尽力与 Black PMs 合作，我知道你们最近举办了一个会议，非常酷。那是一个规模很大的会议。我不知道你们是怎么挤出时间做这些的，关于这个会议有什么可以分享的吗？还会有下一届吗？

---

### [00:10:42] Jules Walter

**English:**
Now we have a really good team at Black PMs. The CEO, Brittany Bankston and the team, Benin Saffo and others, have helped put together that amazing conference that I was able to attend. It's amazing that it's hard for underrepresented community to see themselves in podcasts, at conferences, at speakers, that sort of thing. So, it gave that opportunity and it also enables us to realize that you're not alone. Because part of why I created Black PMs with my co-founders is... Actually, I'll tell you the story. I think it was around 2016, I was at a barbecue. I met another Black PM, Maryanna Quigless. I didn't know her and I was like, "Oh, you're a Black PM at Facebook. How many of you are there at the company?" And we're joking and we're like, "Hey, I bet we can list all the Black PMs we know." And we had basically roughly 15 between the two of us and we're like, "Hey, let's bring them all together in a room and to have a community." From there, started helping each other and that grew from 15 to now over a thousand.

**中文翻译:**
现在 Black PMs 有一支非常优秀的团队。CEO Brittany Bankston 和团队成员 Benin Saffo 等人共同筹办了那次精彩的会议。对于少数群体来说，在播客、会议或演讲者中看到和自己相似的人是很困难的。所以这次会议提供了这样的机会，也让我们意识到你并不孤单。我之所以和联合创始人一起创立 Black PMs，部分原因是……实际上，我给你讲个故事。大约在 2016 年，我在参加一个烧烤聚会。我遇到了另一位黑人 PM Maryanna Quigless。我不认识她，我说：“噢，你是 Facebook 的黑人 PM。你们公司有多少黑人 PM？”我们开玩笑说：“嘿，我打赌我们能列出所有我们认识的黑人 PM。”结果我们两个人加起来一共只认识大约 15 个。于是我们说：“嘿，让我们把大家都聚到一个房间里，建立一个社区吧。”从那时起，我们开始互相帮助，规模从 15 人增长到了现在的 1000 多人。

---

### [00:11:45] Lenny

**English:**
Wow. Amazing. It's really inspiring, the work that you do. I don't know how you find time for all this. I love that you found ways to kind of delegate this and have other people run the program now.

**中文翻译:**
哇。太棒了。你所做的工作真的很鼓舞人心。我不知道你怎么能抽出时间做这么多事。我很欣赏你找到了委派工作的方法，现在让其他人来运行这些项目。

---

### [00:11:55] Jules Walter

**English:**
Yeah. Now, I'm mostly on the board of these organizations. We have really solid teams for both Black PMs and CodePath, and the teams are just really amazing.

**中文翻译:**
是的。现在我主要担任这些组织的董事。Black PMs 和 CodePath 都有非常稳固的团队，这些团队真的很棒。

---

### [00:12:03] Lenny

**English:**
This touches on the stuff that I want to spend most of our time on our chat, which is around mentorship and just generally becoming a stronger product manager through all the ways you can become a stronger product manager. You mentioned you had a lot of great mentors. I've heard from other people, you've been a great mentor to them and you've also just been really successful at a number of really world-class companies. What I want to chat about is just, what have you found to be the most important skills to develop as a PM as you advance in your career, and then how to actually build those skills partly with mentorship, partly other ways? Maybe just to start, what have you found to be the most important skills in your career that have most helped you advance in your career and other PMs around you?

**中文翻译:**
这触及了我想在这次聊天中花大部分时间讨论的内容，即关于导师制度（Mentorship），以及如何通过各种途径成为一名更强大的产品经理。你提到过你有很多优秀的导师。我也听别人说过，你也是他们的优秀导师，而且你在多家世界级公司都取得了成功。我想聊聊的是：在你职业生涯晋升的过程中，你发现哪些技能是最重要的？以及如何实际培养这些技能（部分通过导师指导，部分通过其他方式）？也许先从这里开始：在你职业生涯中，你发现哪些技能对你及你身边的 PM 晋升帮助最大？

---

### [00:12:50] Jules Walter

**English:**
In terms of skills, I think of it in terms of two buckets. One are IQ skills, intellectual skills, like what sometimes people call hard skills. And then the other things are the EQ skills, oftentimes called soft skills. What I've seen in my career is that early on, I leaned more into the hard skills, the IQ stuff. That was what was most helpful to me. And then later on, I spent more time getting better at the EQ skills. The reality with PMs is that within each of these buckets, there's so many skills and then you can feel overwhelmed, so my advice is really just start skill by skill. What I did specifically is I joined Slack, I was in ICPM. When you join a new company, especially if you're earlier in the mid-career, you really want to get good at things like execution, IQ skills, execution, product sense, strategy. So, those were critical for me, especially my first year at Slack.

**中文翻译:**
关于技能，我把它们分为两大类。一类是 IQ 技能，即智力技能，也就是人们常说的“硬技能”。另一类是 EQ 技能，通常被称为“软技能”。在我的职业生涯中，早期我更多地依赖硬技能，也就是 IQ 方面的东西。那对我当时最有帮助。而到了后期，我花更多时间去提升 EQ 技能。PM 的现实情况是，在每一个类别中都有太多的技能，你会感到不知所措，所以我的建议是：一个技能一个技能地开始。我具体做的是：加入 Slack 时，我是一名个人贡献者（IC）PM。当你加入一家新公司，尤其是处于职业生涯早期或中期时，你真的需要擅长执行力（Execution）、IQ 技能、产品感（Product Sense）和策略（Strategy）。这些对我来说至关重要，尤其是在 Slack 的第一年。

---

### [00:13:51] Jules Walter (Continued)

**English:**
The other skill that I'll also call out, which nobody talks about for some reason, is interview skills, because so much of what gives you a chance to become better as a PM is working at a great company. How you get that job beyond networking is actually becoming good at interviewing. If you think about my career, getting into Slack changed my trajectory and I was able to do that because I got slightly somewhat good enough at interviewing. I barely got the job and then I was really good at execution and got better at these other things, product sense, strategy, et cetera. In that phase, the things that I was working on, as I mentioned earlier, were things like improving user activation. So, it relies on those skills: identifying the opportunities, running experiments, executing quickly, and so on. That's the first set of skills.

**中文翻译:**
我还想提到的另一个技能（出于某种原因没人谈论它）是面试技能。因为作为 PM，能让你变得更好的很大一部分机会来自于在一家伟大的公司工作。除了人脉，你获得那份工作的关键实际上是变得擅长面试。回想我的职业生涯，进入 Slack 改变了我的轨迹，而我之所以能做到这一点，是因为我的面试水平勉强达到了足够的程度。我当时是险些才拿到那份工作的，然后我表现出了很强的执行力，并提升了产品感、策略等其他能力。在那个阶段，正如我之前提到的，我负责的是提高用户激活率。这依赖于这些技能：识别机会、运行实验、快速执行等等。这就是第一组技能。

---

### [00:14:49] Lenny

**English:**
Before we move on, and the second set is EQ, right? Is that where you're going?

**中文翻译:**
在我们继续之前，第二组是 EQ，对吧？你是要讲这个吗？

---

### [00:14:51] Jules Walter

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:14:52] Lenny

**English:**
Cool. Maybe just one quick thread I want to pull on is this interviewing skill. That's really interesting. Your point here is you're not... And I think you're going to get to this of just how to get better at these skills. You mentioned one of the best ways is to be surrounded by amazing people who can help you get better at these skills, but you won't get there if you can't actually get into a company like Slack. Is there something you've found to be useful in building these interview skills? When you say interview, it's being interviewed, not interviewing other people, like passing these interview tests.

**中文翻译:**
酷。我想追问的一个点是面试技能。这很有趣。你的观点是……我想你稍后会讲到如何提升这些技能。你提到最好的方法之一是身边围绕着优秀的人，他们能帮你提升，但如果你进不去像 Slack 这样的公司，你就没法实现这一点。在培养面试技能方面，你发现有什么有用的方法吗？当你提到面试时，是指“被面试”，而不是面试别人，也就是通过那些面试测试。

---

### [00:15:28] Jules Walter

**English:**
When people tell me, "Hey, I'm going to a interview at this company." First question I ask is, "How many mock interviews have you done?" And the answer typically is zero. It's, "Oh, I read a bunch of stuff. I practiced in my head." But I'm like, "How many actual mock interviews have you done?" And I would recommend people to do dozens of those mock interviews. Now, the other thing about practice is it's always better if you deliberate practice. If you mock interview with somebody who's actually good at interviewing, then you'll get better faster. But even if you don't do that, just going from zero mocks to practicing in your head to actually doing mocks with peers and others is going to get you to another level. And then the other thing I'll say is interviewing can be quite traumatic and difficult for a lot of people, even me. I mean before I got this job, I interviewed at Google, I don't know how many times, over the last decade or two.

**中文翻译:**
当人们告诉我：“嘿，我要去这家公司面试了。” 我问的第一个问题通常是：“你做了多少次模拟面试（Mock Interview）？” 答案通常是零。他们会说：“噢，我读了很多资料，我在脑子里练习过了。” 但我会问：“你实际做了多少次模拟面试？” 我建议人们做几十次模拟面试。关于练习，另一件事是：刻意练习（Deliberate Practice）总是更好的。如果你和真正擅长面试的人进行模拟面试，你会进步得更快。但即使不这样做，从零模拟、只在脑子里练习，到实际与同行或其他人进行模拟，也会让你提升到一个新的水平。另外我想说的是，面试对很多人来说可能非常痛苦和困难，甚至对我也是。在拿到这份工作之前，在过去的一二十年里，我不知道在 Google 面试过多少次。

---

### [00:16:22] Lenny

**English:**
Wait. You're saying you're interviewed at Google many times and you didn't get in then you kept looking for new opportunities?

**中文翻译:**
等等。你是说你在 Google 面试过很多次都没进，然后你一直在寻找新的机会？

---

### [00:16:27] Jules Walter

**English:**
Yeah. I graduated from MIT and I think even since internship times in '07, I'd interviewed for roles at Google and I didn't get those roles or Meta or various other companies. It's because I wasn't good at interviewing and I didn't know people at those companies. By the way, most things you do, people give you some feedback so you can get better at it, but interviewing you never get any feedback. That's the thing people don't talk about, but it's actually an important skill or a barrier to underrepresented folks.

**中文翻译:**
是的。我从麻省理工学院（MIT）毕业，我想甚至从 2007 年实习期开始，我就面试过 Google 的职位，但没拿到，Meta 或其他各种公司也是如此。这是因为我不擅长面试，而且我不认识那些公司的人。顺便说一下，你做的大多数事情，人们都会给你一些反馈，这样你就能改进，但面试你永远得不到任何反馈。这是人们不常谈论的一点，但它实际上是一项重要的技能，也是少数群体面临的一个障碍。

---

### [00:17:01] Lenny

**English:**
To actually get feedback?

**中文翻译:**
指获得反馈这件事？

---

### [00:17:02] Jules Walter

**English:**
Yeah. You won't get feedback after an interview at any company.

**中文翻译:**
是的。在任何公司面试后，你都不会得到反馈。

---

### [00:17:05] Lenny

**English:**
That's a really good insight of just people see you join a YouTube and are like, "Oh, yeah, of course he's going to get into YouTube." But you're saying that you actually tried to interview and get into Google many times and it took a number of attempts and advancing your career a little bit before you actually... So, don't feel so discouraged if it doesn't work out.

**中文翻译:**
这是一个非常好的见解。人们看到你加入了 YouTube，会觉得：“噢，当然了，他肯定能进 YouTube。” 但你是说你实际上尝试面试并进入 Google 很多次，经过多次尝试并提升了职业水平后才最终……所以，如果面试不成功，不要感到太沮丧。

---

### [00:17:23] Jules Walter

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:17:24] Lenny

**English:**
In terms of this mock, that's a really important point of just actually doing the interviews, like practicing, practicing, practicing. Not just reading questions but actually testing and practicing interview. If you were interviewed at a big company, there's a lot of videos out there of like, "Here's the questions they ask. Here's what they look for." And you're saying find people that work at the company and do these sorts of interviews with them. For companies that are smaller that maybe don't... It's not as obvious what they're going to ask you. Do you have any advice on how to find someone to do a mock interview with or how or what to actually be talking through?

**中文翻译:**
关于模拟面试，实际去面试、不断练习是非常重要的一点。不只是读题目，而是实际测试和练习。如果你去大公司面试，网上有很多视频，比如“这是他们会问的问题，这是他们看重的特质”。你是说找在那家公司工作的人，和他们进行这种面试练习。对于那些规模较小、面试题目不那么明显的公司，你有什么建议吗？如何找到人进行模拟面试，或者实际应该聊些什么？

---

### [00:17:56] Jules Walter

**English:**
Yeah, it's hard at smaller companies. However, I think interviewing even at bigger companies will help you [inaudible 00:18:04]. A lot of the times the bigger companies have more rigorous processes. So if you can do well there, then it is a bit easier elsewhere. But the key is really that practice part, which people overlook.

**中文翻译:**
是的，小公司确实比较难。不过，我认为即使是在大公司面试的练习也会对你有帮助。很多时候大公司的流程更严谨。如果你能在那里表现出色，那么在其他地方也会容易一些。但关键在于练习，这是人们容易忽视的部分。

---

### [00:18:18] Lenny

**English:**
Cool. Well, maybe one last question there and we'll move on. Do you have any favorite resources or just advice of where to go find the questions to mock interview with and then who do you look forward to do these interviews with, like just find someone at the company or one of these larger companies that you respect to mock interview with?

**中文翻译:**
酷。关于这个再问最后一个问题，然后我们就继续。你有什么推荐的资源，或者关于去哪里找模拟面试题目的建议？你倾向于找谁来做这些面试？是直接找那家公司的人，还是找大公司里你尊敬的人？

---

### [00:18:34] Jules Walter

**English:**
I mentor a bunch of people who talk about various communities that exist out there. I can follow up on those, but there are large communities of people prepping for these companies. The key is really just being a part of a community and doing the mocks. And then the last thing I'll say on this is interviewing is hard and especially, I think, hard for underrepresented folks because it's high pressure. It's high stress, high ambiguity coming into a company. I've gone into companies like an interview and then the whole panel, nobody looks like me. I walk into the cafeteria, nobody looks like me. And then you are interviewing and you have all this self-talk about, "Hey, do I even want to work there? Will I belong," while you're trying to solve complex problems. So, that's also the other part companies don't think about. What I do, like folks at Black PMs that I coach, is really help them find groups of people, like small groups. Let's say three of us, et cetera, three to five, and then you practice with that group who are going through the process. And because you like the people, then it makes it a bit more fun and it also can help you prep for your own nerves in those interviews.

**中文翻译:**
我指导过很多人，他们提到过各种现有的社区。我可以后续提供这些信息，但确实有很多大型社区是专门为这些公司做准备的。关键在于加入一个社区并进行模拟面试。关于这一点我想说的最后一件事是，面试很难，尤其是对少数群体来说，因为压力很大。进入一家公司面临着高压力和高度不确定性。我曾去一些公司面试，整个面试小组里没有一个人长得像我。我走进食堂，也没有人长得像我。当你面试时，你脑子里会有各种自我对话：“嘿，我真的想在这里工作吗？我有归属感吗？”与此同时你还要尝试解决复杂的问题。这是公司通常不会考虑的另一部分。我所做的，比如我指导的 Black PMs 的成员，就是帮助他们找到小组，比如 3 到 5 人的小组，然后和这些同样在经历面试流程的人一起练习。因为你喜欢这些人，练习会变得更有趣，也能帮你缓解面试时的紧张情绪。

---

### [00:19:48] Lenny

**English:**
What I'm hearing is, and I know we hear this all the time, if you're, say, a Black product manager, it's so much harder to not just get in because there's potentially bias at the company, but you're just psychologically not feeling as comfortable because nobody looks like you. You're worried that they're going to have bias against you. Is that what you find?

**中文翻译:**
我听到的是（我知道我们经常听到这个），如果你是一名黑人产品经理，进入公司要难得多，不仅是因为公司可能存在潜在偏见，还因为你心理上感觉不那么舒服，因为没人长得像你。你会担心他们对你有偏见。这是你的发现吗？

---

### [00:20:07] Jules Walter

**English:**
Yeah, that has been my experience and it's also what I hear from a lot of people I mentor.

**中文翻译:**
是的，这是我的经历，也是我从很多我指导的人那里听到的。

---

### [00:20:13] Lenny

**English:**
Your advice there, and this is helpful to anyone also, is just practice even more because that's probably the best way to get over that as much as you can.

**中文翻译:**
你的建议（这对任何人都有帮助）就是：练习得更多，因为这可能是尽可能克服这种心理障碍的最好方法。

---

### [00:20:21] Jules Walter

**English:**
Yeah. You want to basically practice so much that even at your worst, you're good enough. I've always felt like most interviews, I literally did my worst. It's just that it was good enough to pass. You're so stressed out, you don't relate to the person, et cetera.

**中文翻译:**
是的。你基本上要练习到即使在你状态最差的时候，你也足够优秀。我一直觉得大多数面试中，我表现得其实是最差的。只是那个“最差”的表现也足以通过面试。你压力太大了，无法与面试官建立联系，等等。

---

### [00:20:38] Lenny

**English:**
Got it. Okay. Let's go back to the question I asked that I pushed us away from. We were talking about what skills as a PM you want to be focusing on that mostly will help you in your career, and we started with IQ. I wrote a couple notes, so there's the concrete skills, execution, products and strategy, interviewing, and then there's a second bucket of EQ.

**中文翻译:**
明白了。好，让我们回到我之前问的那个问题。我们当时在讨论作为 PM 应该关注哪些对职业生涯最有帮助的技能，我们从 IQ 开始。我记了几点：具体的技能包括执行力、产品感和策略、面试，然后是第二个类别：EQ。

---

### [00:20:57] Jules Walter

**English:**
So, the IQ I already talked about. Those are the skills that help me at, especially in my first year at Slack, drive big good experiments, design good product experiences, and then drive results. But then what happened is as I get promoted, managed people and then start having larger scope, then there's a lot of ambiguity and stress that comes in with that increase in scope. And that's where the EQ stuff shows up a lot, specifically things like communications, because it's no longer my team. It's like cross-functional partners, other teams, executives, so you have to communicate all the time to different people. And then the other thing is things like leadership. Now, I'm driving initiatives that involve multiple teams, basic company level OKRs, and then the other thing too is beyond leadership, which is managing your team as well. How do you be a good manager? How do you deal with the ambiguity, stress? How do you influence various people?

**中文翻译:**
IQ 方面我已经谈过了。这些技能帮助我在 Slack 的第一年推动了大型且成功的实验，设计了良好的产品体验，并取得了成果。但随着我被晋升、开始管理人员并拥有更大的职责范围，随之而来的是大量的不确定性和压力。这就是 EQ 技能大显身手的地方，特别是沟通能力。因为这不再仅仅关乎我的团队，还涉及跨职能合作伙伴、其他团队、高管，所以你必须不断地与不同的人沟通。另一件事是领导力。现在，我推动的倡议涉及多个团队和公司层面的 OKR。除此之外，还有管理团队。如何成为一名优秀的经理？如何处理不确定性和压力？如何影响各种各样的人？

---

### [00:21:58] Jules Walter (Continued)

**English:**
These are the EQ skills. What I've seen is, number one, it's much harder to learn these skills than the IQ stuff. The IQ is very intellectual. Sometimes, you just need a mental model, practice a bit. The EQ, I'm still learning these things. It's just like every... I'm trying to get better. Then the other thing beyond it being hard to learn is that the EQ stuff... What you need to focus on is specific to you, so you learn it. You probably work on something different than what I would work on versus if we're both trying to be better at strategy or execution, there's a lot more overlap. So, there's a lot of self-awareness that you need to have to know even what to work on and then you need to continuously practice it.

**中文翻译:**
这些就是 EQ 技能。我的观察是：第一，学习这些技能比学习 IQ 类的东西难得多。IQ 类的东西非常理智，有时你只需要一个思维模型，练习一下就行。而 EQ，我至今仍在学习。就像每一天……我都在努力变得更好。除了难学之外，EQ 技能的另一个特点是：你需要关注的东西是因人而异的。你可能需要练习的东西和我需要练习的完全不同；相比之下，如果我们都想提升策略或执行力，重叠部分会多得多。因此，你需要具备很强的自我意识（Self-awareness），才能知道自己该在哪些方面下功夫，然后你需要持续不断地练习。

---

### [00:22:44] Lenny

**English:**
What did you find was the most important EQ skill for your career that helped you in this journey?

**中文翻译:**
在你职业生涯的这段旅程中，你发现最重要的、对你帮助最大的 EQ 技能是什么？

---

### [00:22:50] Jules Walter

**English:**
I don't know if there is one that single-handedly was the most important. I had to develop on many of these things. I can tell you, for example, communication is something that is helpful, especially as I become more senior. What happened for me is, early in my career, it was more about clarity and then conciseness. Then later it became more about how do you tell a story, and then also how do you communicate in an empathetic way. Specifically, you're telling the same story or presentation but to different audiences, and each time you have to adjust it because the CEO will care about this part, the CFO will care about this other part, and so on. I think that's one area where I spend a lot of time. And then the other thing also that has been helpful is the self-awareness part that I mentioned, where through mentorship, especially mentors who were very honest and help me see my blind spots, I was able to see my own patterns.

**中文翻译:**
我不确定是否有一个技能可以单枪匹马地被称为最重要。我必须在很多方面同时发展。例如，我可以告诉你，沟通是非常有帮助的，尤其是随着我职位的提升。对我来说，职业生涯早期，沟通更多关乎清晰和简洁。后来，它更多地变成了如何讲故事，以及如何以同理心的方式进行沟通。具体来说，你向不同的受众讲述同一个故事或进行同一场演示，每次你都必须进行调整，因为 CEO 关心这一部分，CFO 关心另一部分，以此类推。这是我投入大量时间的一个领域。另一件非常有帮助的事情是我提到的自我意识部分。通过导师指导，特别是那些非常诚实并帮助我看到盲点的导师，我能够看清自己的行为模式。

---

### [00:23:54] Jules Walter (Continued)

**English:**
When I'm under stress, for example, I tend to withdraw and not see anything. So, then you might think I'm disengaged. By the way, in an interview context you might be like, "Oh, does this person even want to work here?" Then once you know these patterns you know, "Okay, I'm stressed right now, but I need to say something so that people see that I'm actually interested in this problem; I'm just thinking through it. Well, let me verbalize my thought process." So, that's me as an example. For you, it might be the opposite. The self-awareness piece has been really helpful and it's something I continue to work on.

**中文翻译:**
例如，当我处于压力之下时，我倾向于退缩，什么都不说。这样你可能会觉得我心不在焉。顺便说一下，在面试场景中，面试官可能会想：“噢，这个人真的想在这里工作吗？” 一旦你知道了这些模式，你就会意识到：“好吧，我现在压力很大，但我需要说点什么，让人们看到我实际上对这个问题感兴趣；我只是在思考。那么，让我把我的思考过程说出来吧。” 这只是我的例子。对你来说，情况可能正好相反。自我意识这一块非常有帮助，也是我一直在努力提升的部分。

---

### [00:24:26] Lenny

**English:**
That's an interesting point that it's important to understand how you react and to figure out what's unique about you that you want to be working on, especially within EQ. For this example you gave about how stress impacts you, how did you actually discover that? Was that this mentor just pointing out, "Hey, Jules, I've noticed this happens," or is there anything else there that maybe folks would find useful?

**中文翻译:**
这是一个很有趣的观点：了解自己的反应并找出自己特有的、需要改进的地方非常重要，尤其是在 EQ 方面。关于你举的压力如何影响你的例子，你是如何发现这一点的？是导师指出来的吗，比如“嘿，Jules，我注意到这种情况发生了”，还是有其他什么大家可能会觉得有用的方法？

---

### [00:24:47] Jules Walter

**English:**
Generally, you need someone to put a mirror in front of you irritably. Sometimes, it's like you hire a coach, I talk to, and they see patterns. I've done group coaching too. In this case specifically, he was a mentor. His name is Lawrence Ripsher. He was head of product at Pinterest and became a mentor and now a close friend. One day I was preparing for... I think I need to do a representation and he was like, "Hey, I've noticed that when you are thinking, you're just quiet. Let me tell you what's going on in my own head when I see that." And then he was like, "Hey, I'm telling myself that he's not interested in what we're doing." And I'm like, "Really? That's the least thing." And then I realized that's a pattern I have. Over time, through him and others, I've also observed other patterns.

**中文翻译:**
通常，你需要有人在你面前放一面镜子。有时是聘请教练，我通过交谈让他们发现模式。我也参加过小组教练。在这个具体的案例中，他是一位导师，名叫 Lawrence Ripsher。他曾是 Pinterest 的产品负责人，后来成了我的导师，现在是亲密的朋友。有一天我正在准备……我想是准备一个演示，他说：“嘿，我注意到当你思考时，你只是保持沉默。让我告诉你当我看到这种情况时，我脑子里在想什么。” 然后他说：“嘿，我告诉自己，他对我们正在做的事情不感兴趣。” 我当时想：“真的吗？那是我最不可能的想法。” 然后我意识到那是我的一个模式。随着时间的推移，通过他和其他人，我也观察到了其他的模式。

---

### [00:25:38] Lenny

**English:**
I missed this, but was he a manager or just a mentor you had within the company?

**中文翻译:**
我漏掉了这一点，他是你的经理，还是只是你在公司里的导师？

---

### [00:25:42] Jules Walter

**English:**
We didn't work at the same company. When I was at Slack, he was head of product at Pinterest. We met at a dinner and then from there, over time, he became a mentor and then we started meeting. When I would hit difficult situations, sometimes I would call him and ask for advice, and then through those interactions he's helped me identify some of my blind spots.

**中文翻译:**
我们不在同一家公司工作。我在 Slack 时，他是 Pinterest 的产品负责人。我们在一次晚宴上认识，从那时起，随着时间的推移，他成了我的导师，我们开始定期见面。当我遇到困难时，有时会打电话向他寻求建议，通过这些互动，他帮我识别了一些盲点。

---

### [00:26:08] Lenny

**English:**
Okay, awesome. We're definitely going to talk about mentorship and how to work with a mentor, but let's kind of wrap up this EQ piece. You mentioned within EQ, skills to think about working on communication, leadership, and management. Is there anything else and then is there an example of one of these skills and how, I don't know, it helped you in your career or held you back until you figure out how to work on this?

**中文翻译:**
好的，太棒了。我们肯定会讨论导师制度以及如何与导师合作，但让我们先总结一下 EQ 的部分。你提到 EQ 方面需要关注沟通、领导力和管理。还有其他的吗？能不能举个例子，说明其中一项技能是如何帮助你的职业生涯，或者在你学会如何改进它之前是如何阻碍你的？

---

### [00:26:30] Jules Walter

**English:**
High level, I think those buckets are pretty broad: comms, leadership, management. Within each of them, there are various skills like setting vision, strategy, listening to learn, those sort of things. It's actually the type of things that Matt Mochary talked about when he came to speak at your podcast. I mentioned communications was one thing, right? What happened was, when I was at Slack, I was pretty good at writing, which by the way I was terrible at long time ago. It took me years, maybe decade, to get better at. But then when it was time to present... I was fine at presenting, but then if you ask me questions, things would crumble. That even happened to me once at an interview, where I did well presenting and then they asked me a question and then I just gave an answer that wasn't good.

**中文翻译:**
从宏观上看，我认为这些类别非常广泛：沟通、领导力、管理。在每一个类别中，都有各种技能，比如设定愿景、策略、为了学习而倾听等等。这实际上就是 Matt Mochary 在你的播客中谈到的那些内容。我提到沟通是其中之一，对吧？情况是这样的：我在 Slack 时，我的写作能力还不错（顺便说一下，很久以前我的写作很糟糕，我花了几年甚至十年的时间才变好）。但到了演示的时候……我演示得还行，但如果你问我问题，事情就会崩溃。这甚至在一次面试中发生过，我演示得很好，但他们问了我一个问题，我给出的回答却很糟糕。

---

### [00:27:22] Jules Walter (Continued)

**English:**
Then the self-awareness part helped me figure out what was going on. For me specifically, I realized whenever people ask me questions, if I didn't know the answer, I would have all this negative self-talk and I basically... You'd ask me a question and of course it could be something like, "Why are we doing it this way?" And it might come from a place of curiosity, you're just like, "Hey, I don't know. Can you tell me why you have more context," right? But in my head I would hear, "I don't agree with this." And that would be my self-talk. "Oh, this person doesn't agree with this," instead of being present and trying to understand where are they coming from and maybe asking follow-ups like, "Hey, thanks for asking the question. Is your concern more about, I don't know, scalability of this approach or is it more that you don't think it's effective even if it's not scalable?"

**中文翻译:**
后来自我意识帮我弄清楚了是怎么回事。具体到我，我意识到每当人们问我问题时，如果我不知道答案，我就会产生各种负面的自我对话。比如你问我一个问题，当然可能只是像“我们为什么要这样做？” 这种出于好奇的问题，你只是想：“嘿，我不知道，你能告诉我吗，因为你了解更多背景。” 对吧？但在我脑子里，我听到的是：“我不赞成这样做。” 这就是我的自我对话：“噢，这个人不赞成这个。” 而不是保持专注并尝试理解他们的出发点，或者问一些后续问题，比如：“嘿，谢谢你的提问。你的担忧更多是关于这种方法的扩展性，还是你觉得即使它能扩展，它也不够有效？”

---

### [00:28:10] Jules Walter (Continued)

**English:**
You know what I mean? For someone else, it might be the easiest thing, but for me it took me months and months to, first of all, figure out that I had this pattern. And then once I figured out the pattern, it took also a while to now actually act on it so that now I'm comfortable. If you ask me a question, sometimes I don't know and I'll say, "Hey, let me get back to you." Sometimes I don't know and I'll say, "Hey, I don't know, but here's what I'm thinking." This little thing that may seem so obvious to you took me a while and different people have different versions of these blockers.

**中文翻译:**
你懂我意思吗？对别人来说，这可能是最简单的事情，但对我来说，我花了几个月的时间才首先意识到我有这种模式。一旦我意识到了这种模式，又花了一段时间才真正付诸行动，直到现在我才感到从容。如果你问我一个问题，有时我不知道，我会说：“嘿，让我稍后回复你。” 有时我不知道，我会说：“嘿，我不知道，但我是这么想的。” 这件对你来说可能显而易见的小事，我却花了好长时间，而且不同的人会有不同版本的这种障碍。

---

### [00:28:45] Lenny (Sponsor: Linear)

**English:**
This episode is brought to you by Linear. Let's be honest, the issue tracker that you're using today isn't very helpful. Why is it that always seems to be working against you instead of working for you? Why does it feel like such a chore to use? Well, Linear is different. It's incredibly fast, beautifully designed, and it comes with powerful workflows that streamline your entire product development process, from issue tracking all the way to managing product roadmaps. Linear is designed for the way modern software teams work. What users love about Linear are the powerful keyboard shortcuts, efficient GitHub integrations, cycles that actually create progress, and built-in project updates that keep everyone in sync. In short, it just works. Linear is the default tool of choice among startups and it powers a wide range of large established companies such as Vercel, Retool, and Cash App. See for yourself why product teams describe using Linear as magical. Visit linear.app/lenny to try linear for free with your team and get 25% off when you upgrade. That's linear.app/lenny.

**中文翻译:**
本集节目由 Linear 赞助。坦白说，你现在使用的工单追踪系统（Issue Tracker）并不是很有用。为什么它总是感觉在和你作对，而不是在帮你？为什么用起来像是在做苦差事？Linear 则不同。它速度极快，设计精美，并配有强大的工作流，可以简化从工单追踪到管理产品路线图的整个产品开发过程。Linear 是为现代软件团队的工作方式而设计的。用户喜爱 Linear 的原因是它强大的键盘快捷键、高效的 GitHub 集成、真正能推动进度的周期（Cycles），以及让每个人保持同步的内置项目更新。简而言之，它就是好用。Linear 是初创公司的首选工具，也为 Vercel、Retool 和 Cash App 等众多大型成熟公司提供支持。亲自去看看为什么产品团队将使用 Linear 描述为“神奇”。访问 linear.app/lenny 免费与你的团队试用 Linear，并在升级时享受 25% 的折扣。网址是 linear.app/lenny。

---

### [00:29:54] Lenny

**English:**
I love these stories and this is a good segue to start talking a bit about not just what skills to focus on, but how to actually get better at these things and identify these patterns in yourself. There's like a bunch of skills we just named, so let's also talk about where you think you start as you're starting off as a PM, which skills to focus on first, second, third. Let me just ask this broad question. We've talked about all these different skills PM should have. What have you found to be most effective broadly at building these skills in your career?

**中文翻译:**
我很喜欢这些故事，这正好可以引出下一个话题：不仅要关注哪些技能，还要讨论如何实际提升这些技能并识别自己的模式。我们刚才列举了一堆技能，所以我们也来聊聊，作为一名刚起步的 PM，你认为应该从哪里开始，第一、第二、第三步应该关注哪些技能。让我问一个宽泛的问题：我们谈到了 PM 应该具备的所有这些不同技能，在你的职业生涯中，你发现广泛提升这些技能最有效的方法是什么？

---

### [00:30:24] Jules Walter

**English:**
I will share my approach. It might not work for everyone and later when we talk about strengths and weaknesses. You might see why that works for me. What I do specifically is when I'm trying to learn something new, I try to think about what is an outcome that I could drive. And if I drive this outcome, it will be proof that I'm better at this thing. If we go back to this story of when I joined Slack, I didn't know anything, literally anything about growth. And I was telling myself, "I hope they don't fire me." But then the outcome I wanted is, within six months, I wanted to ship enough experiments that were successful, that drove activation by, let's say, X percent. So, that's very concrete.

**中文翻译:**
我会分享我的方法。它可能不适合所有人，稍后当我们讨论优势和劣势时，你可能会明白为什么这种方法对我有效。我具体做的是：当我尝试学习新东西时，我会思考我可以推动什么样的“成果”（Outcome）。如果我实现了这个成果，它将证明我在这件事上变得更好了。回到我加入 Slack 的故事，当时我对增长一无所知，真的是一窍不通。我当时告诉自己：“希望他们别开除我。” 但我想要的成果是：在六个月内，发布足够多成功的实验，将激活率提高 X%。这非常具体。

---

### [00:31:06] Jules Walter (Continued)

**English:**
Then once I have this outcome, I work backwards to figure out how am I going to do that. One of the things we can talk about later when we talk about strength is that, for me, I'm really good at asking questions. What I do then is I start asking questions like, "Okay, I'm trying to drive activation for Slack. What are some frameworks that I should use to drive activation? What are best practices? What are examples?" I have a sense of the kind of question that, if I were to answer them, I'd be able to drive the outcome. And then what I do is I read a little bit, not a lot about the topic, just to make sure I'm asking the right question. Then I refine my questions and then I find the best people in the field and I just go talk to them. That's where we'll talk later about the mentorship part.

**中文翻译:**
一旦有了这个成果目标，我就开始倒推如何实现它。稍后谈到优势时我们会提到，我非常擅长提问。于是我开始问自己：“好吧，我要提高 Slack 的激活率。我应该使用哪些框架来推动激活？最佳实践是什么？有哪些例子？” 我对那些如果能回答出来就能推动成果的问题有一种直觉。然后我会读一点（不是很多）关于这个主题的资料，只是为了确保我问的问题是对的。接着我完善我的问题，找到该领域最优秀的人，直接去请教他们。这就是我们稍后会谈到的导师部分。

---

### [00:31:54] Jules Walter (Continued)

**English:**
In the case of activation, I was like, "Okay, what's the company that defined growth?" At the time, Facebook. "Who are the people that I can reach out to that do growth at Facebook?" And one of them was Bangaly Kaba and also Adriel Frederick who spoke at your podcast. I had met both of them at a random event. Then I'm like, "I need to find a way to have a chat with these folks and to help answer those questions with them." So, that's what I did with Bangaly in particular and also Adriel to a certain extent. I then learned, "Okay, here are frameworks to use for growth." For example, understand, identify, execute. Spend a lot more of your time understanding why people aren't staying on Slack versus anything else, so then I had pointers.

**中文翻译:**
以激活为例，我想：“好吧，哪家公司定义了增长？” 当时是 Facebook。“我可以联系 Facebook 哪些做增长的人？” 其中之一是 Bangaly Kaba，还有曾在你播客中发言的 Adriel Frederick。我曾在一次随机活动中见过他们。然后我想：“我得想办法和这些人聊聊，让他们帮我回答那些问题。” 所以我找了 Bangaly，在某种程度上也找了 Adriel。然后我学到了：“好吧，这是增长可以使用的框架。” 例如：理解（Understand）、识别（Identify）、执行（Execute）。花更多时间去理解为什么人们不留在 Slack，而不是做别的，这样我就有了方向。

---

### [00:32:40] Jules Walter (Continued)

**English:**
Once I have the pointers, then I try to go through the thing. I'm like, "Okay, now let me..." I call the user researcher, "Hey, can we do a research on people who are signing up on Slack?" Data analysts, let's look at the data. What correlates with activation?" Those sort of things. Then after I go through a look, where I actually see results, whether they're good or bad, I go back to the mentor and I'm like, "Hey, I did this. It was actually successful. Thanks a lot. Now, I'm thinking about this other problem." I keep going and that's how I rinse and repeat, and over time I drive the outcome and I also know I'm getting better at this thing by working with the experts.

**中文翻译:**
一旦有了方向，我就开始付诸行动。我会想：“好吧，现在让我……” 我打电话给用户研究员：“嘿，我们能对注册 Slack 的人做个研究吗？” 找数据分析师：“让我们看看数据，哪些因素与激活相关？” 诸如此类。当我完成一个循环并看到结果（无论好坏）后，我会回到导师那里说：“嘿，我做了这个，效果确实不错。非常感谢。现在我在考虑另一个问题。” 我就这样不断循环往复，随着时间的推移，我推动了成果，同时也知道通过与专家合作，我在这一领域变得更强了。

---

### [00:33:18] Lenny

**English:**
There's a few interesting takeaways there. One, is that you kind of create a forcing function for yourself to learn a thing. It's like, "Hey, I'm going to learn this thing. Let's create a goal that my ass is on the line to hit and then that's going to force me to go figure this out." And then two, it's interesting how often you come back to mentors and other people around you helping you out, which is a really good reminder. You don't have to figure things out for yourself; there's people out there that know these things and they're happy to help. A question I want to ask and I'll save this, because I we're going to talk about mentorship specifically a little bit later, just like how to find these people. Not everyone has access to Bangaly and Adriel, and I'm curious just how you found these folks, how you recommend other people find folks like that. But that's an awesome example. One tactic you're talking about here is just work backwards from a forcing function you've created for yourself to learn a thing. And in this case, what was it you were trying to learn? You were trying to learn growth, is that right?

**中文翻译:**
这里有几个有趣的收获。第一，你为自己创造了一个学习某样东西的“强制机制”（Forcing function）。就像是：“嘿，我要学这个，让我们设定一个目标，如果达不到我就惨了，这会迫使我去搞定它。” 第二，有趣的是你经常提到导师和其他身边的人在帮助你，这是一个很好的提醒。你不需要凡事都靠自己摸索；外面有懂这些的人，而且他们乐于助人。我想问的一个问题（我会留到后面，因为我们要专门聊导师制度）是：如何找到这些人。并不是每个人都能接触到 Bangaly 和 Adriel，我很好奇你是如何找到这些人的，以及你建议其他人如何寻找这样的人。但这是一个极好的例子。你在这里谈论的一种策略就是：从你为学习某事而创建的强制机制开始倒推。在这个案例中，你想学的是增长，对吗？

---

### [00:34:11] Jules Walter

**English:**
Yeah, I was trying to learn growth and I wanted to do it in a context of activation, like new onboarding. And then later I also wanted to learn growth but in a different context, which was monetization. How do you drive revenue growth, not just get more users? And then later it was things like, "How do I learn how to create a growth org? How do I structure my team? How do I set work streams that add up to a coherent strategy?" And you just keep going.

**中文翻译:**
是的，我当时想学增长，并想在激活（比如新用户引导）的背景下学习。后来我也想学增长，但在不同的背景下，即变现（Monetization）。如何推动营收增长，而不仅仅是获取更多用户？再后来是诸如：“我如何学习建立一个增长组织？如何构建我的团队？如何设置工作流以形成连贯的策略？” 你就这样不断进阶。

---

### [00:34:42] Lenny

**English:**
In those examples, did you do the same thing, you found people to talk to?

**中文翻译:**
在那些例子中，你也是做同样的事情吗，找人请教？

---

### [00:34:46] Jules Walter

**English:**
Yeah. Yeah. It's the same approach. Sometimes what happens is I have a few mentors that I just keep going to over the years and it's just a top exchange and sometimes I sort of get new mentors who are experts at these new topics. It's a combination of those two things for me. And the thing is you obviously can learn without this approach, but this approach makes you, at least for me, makes me learn so much faster.

**中文翻译:**
是的，是的。方法是一样的。有时我会找几位多年来一直保持联系的导师，进行高层次的交流；有时我会找一些在这些新主题上的专家作为新导师。对我来说是这两者的结合。事实是，你显然可以在没有这种方法的情况下学习，但这种方法至少对我来说，让我学得快得多。

---

### [00:35:14] Lenny

**English:**
That's probably one of the most interesting things I've learned about mentors, and you're touching on this, that people want to help. They're happy to help if people come ask, unless they're just dumb questions or they're just overwhelmed. People are generally very happy to help. People are always worried like, "Why would they spend any time trying to help me with this random thing?" It's really the opposite; they're happy to help.

**中文翻译:**
这可能是我学到的关于导师最有趣的事情之一，你也提到了这一点：人们其实是想提供帮助的。如果有人来请教，他们很乐意帮忙，除非问题太蠢或者他们实在太忙了。人们通常非常乐意帮忙。大家总是担心：“他们为什么要花时间帮我处理这个随机的小事？” 事实恰恰相反，他们很乐意。

---

### [00:35:34] Jules Walter

**English:**
Yeah, exactly.

**中文翻译:**
是的，没错。

---

### [00:35:35] Lenny

**English:**
Coming back to the EQ and IQ buckets, are there other examples of ways you've learned to improve, say, strategy, execution, product sense, things like that?

**中文翻译:**
回到 EQ 和 IQ 的分类，还有其他例子说明你是如何学习提升策略、执行力、产品感之类的能力吗？

---

### [00:35:46] Jules Walter

**English:**
Whether you have a mentor or not, there's other things you kind of have to do. For me, for example, one thing I do is I try to identify what's the best practice for something. For example, let's say strategy. There was a phase where I got feedback, "Hey you need to be better at strategy." Then I'm like, "Okay. Well, can you help me understand what are people at this company that was awhile back, where you think have done a great job at strategy or what are examples of artifacts?" Then I get these artifacts and I reverse engineering them. I try to think, "Okay, what are the top questions, the answer? Maybe I'm not answering all these questions. How do they do it?" And you start seeing the patterns like, "This person did it in a memo, this person did it in a deck." So, it's not about the format, but what is it about? Then this person had a lot of data, this person is quantitative, qualitative. So, that's a big part of what I do as well. It's true for all these things.

**中文翻译:**
无论你是否有导师，你都必须做一些其他事情。对我来说，例如，我会尝试识别某件事的“最佳实践”。比如策略。曾有一个阶段我收到反馈说：“嘿，你需要在策略方面做得更好。” 然后我想：“好吧，你能帮我了解一下这家公司里（那是很久以前的事了），你认为谁在策略方面做得很好，或者有哪些产出物（Artifacts）的例子吗？” 然后我拿到这些产出物并对它们进行“逆向工程”。我会思考：“好吧，他们回答的核心问题是什么？也许我没有回答所有这些问题。他们是怎么做的？” 你开始看到模式，比如：“这个人用备忘录写的，那个人用幻灯片做的。” 所以重点不在于格式，而在于内容。这个人有很多数据，那个人是定量的，这个是定性的。这也是我所做工作的重要组成部分。对于所有这些技能都是如此。

---

### [00:36:47] Jules Walter (Continued)

**English:**
For execution, it would be things like me attending another PMs meeting. "Oh, I heard this person is amazing at executing. Let me just see how they're on a meeting." And then you're like, "Whoa, things we didn't notice." Or somebody is great at communicating and I'm like, "Okay. Well, did you send this email? It's great. Let me save it." I'd have docs where I saved templates of things, and a lot of the reason, I think, people don't learn through osmosis that way is because one is you're not at a company where you can see great artifacts sometimes. That's why I mentioned if you can get a better company, do that. The other thing, too, is even if you see the greatness around you, some people don't try to break it down, to understand: "Why is this one great and not that one?" So, I actually do spend a lot of time every week reflecting like, "Oh, I saw these docs that were great or I saw this presentation this person gave." I sometimes crash presentation audits PMs give to executives, just to see how they handle questions or these sort of things. A lot of it is just spending time observing as well.

**中文翻译:**
对于执行力，我会去参加另一个 PM 的会议。“噢，我听说这个人执行力极强，让我看看他们是怎么开会的。” 然后你会发现：“哇，有些细节我们以前没注意到。” 或者某人擅长沟通，我会想：“好吧，你发的这封邮件太棒了，让我把它存下来。” 我会有专门的文档来保存这些模板。我认为很多人没有通过这种“潜移默化”（Osmosis）的方式学习，原因之一是你有时不在一家能看到优秀产出物的公司。这就是为什么我提到如果你能进更好的公司，就去。另一个原因是，即使你身边有优秀的人，有些人也不会尝试去拆解它，去理解：“为什么这个很棒而那个不行？” 所以我每周确实会花很多时间反思，比如：“噢，我看到这些文档很棒，或者我看到某人的演示很精彩。” 我有时会去旁听 PM 给高管做的演示评审，只是为了看他们如何处理问题之类的事情。很大一部分就是花时间观察。

---

### [00:37:54] Lenny

**English:**
I love this advice, it's so powerful. Just like, "Who is amazing at this skill? And let me just go watch them and learn from them."

**中文翻译:**
我非常喜欢这个建议，它非常有力。就像是：“谁在这项技能上很厉害？让我去观察他们，向他们学习。”

---

### [00:38:01] Jules Walter

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:38:02] Lenny

**English:**
Something that you touched on here is, and I talk about this a bunch, that one of the benefits of working at a large company like Google, like Slack, is that you have access to a ton of real examples of strategy documents and vision documents and roadmaps and things like that, that once you're out of a company, like me, nobody shares these things publicly because they're sensitive. One of the best benefits of working at a large company is they have access to real life strategy documents, vision documents, things like that, so you should really savor that and collect them and, to your point, just study them. And I love your advice of just working backwards from like, "Okay, here's a strategy that work. What is it about the strategy that I can use when I'm building my strategy? What questions are they answering? How are they structuring it?" Things like that. That's awesome.

**中文翻译:**
你提到的一点（我也经常谈到）是，在像 Google、Slack 这样的大公司工作的好处之一是，你可以接触到大量真实的策略文档、愿景文档和路线图之类的例子。一旦你离开公司，像我这样，就没人会公开分享这些东西了，因为它们很敏感。在大公司工作的最大好处之一就是能接触到现实生活中的策略文档、愿景文档等，所以你真的应该珍惜并收集它们，并且正如你所说，去研究它们。我很喜欢你关于倒推的建议，比如：“好吧，这是一个行之有效的策略。这个策略中有哪些是我在构建自己的策略时可以借鉴的？他们回答了哪些问题？他们是如何构建框架的？” 诸如此类。太棒了。

---

### [00:38:48] Jules Walter

**English:**
Similar to the mentor point, people are actually happy to talk to you. They're even flattered because no one else asked them. "Well, hey, I read your doc. Can we talk about it?"

**中文翻译:**
和导师那一点类似，人们其实很乐意和你交流。他们甚至会感到受宠若惊，因为没别人问过他们。“嘿，我读了你的文档，我们能聊聊吗？”

---

### [00:38:54] Lenny

**English:**
Right. Whoever gets the... What PM ever gets someone coming to them? "I love your strategy doc. Tell me all about it. I'd love to talk about that."

**中文翻译:**
没错。哪个 PM 会遇到有人找上门说：“我太喜欢你的策略文档了，快跟我讲讲，我想聊聊这个。”

---

### [00:39:06] Jules Walter

**English:**
Yeah. And then the other thing I'll say, too, is a lot of learning happens through the iterations and not by seeing the final product. We all see these products, like the iPhone and name your favorite product, but you don't know what versions they tried and sort of eliminated. And that's the benefit you also get at a company that has great product management. I actually sometimes tell the PM like, "Hey, don't just show me the one you just did. When are you going to do your next strategy? Can I join you then? I just want to sit and watch you write down the outline and just understand your thought process," or "I want to see when you're going to write your next exec update and understand how are you..." And you see them go through these iteration and you see them do things like get feedback that you didn't know they were getting all this feedback from. So, seeing the backstage is also really helpful.

**中文翻译:**
是的。我还想说的是，很多学习发生在“迭代”过程中，而不是通过看最终产品。我们都看到这些产品，比如 iPhone 或你最喜欢的产品，但你不知道他们尝试过并淘汰了哪些版本。这就是你在一家拥有优秀产品管理体系的公司能获得的好处。我有时会告诉 PM：“嘿，别只给我看你刚做完的那个。你下次做策略是什么时候？我能加入吗？我只想坐在旁边看你写大纲，理解你的思考过程，” 或者 “我想看你写下一次高管汇报，了解你是如何……” 你看着他们经历这些迭代，看着他们获取反馈（你以前都不知道他们会从这么多渠道获取反馈）。所以，看到“后台”过程也很有帮助。

---

### [00:39:58] Lenny

**English:**
It's interesting. Just as you're talking, I'm reflecting on how many benefits there are to working at a world class company. You are surrounded by really smart people who you can talk to and ask for advice and watch how they operate. You have access to really incredible documents and artifacts that you can learn from. Also, just the logo on your resume is really powerful for future job opportunities, which then comes back to the interview skills that you talked about and how important it is to be good at that to get into a company like that.

**中文翻译:**
很有趣。听你说话时，我在反思在世界级公司工作有多少好处。你身边围绕着非常聪明的人，你可以与他们交谈、寻求建议并观察他们的运作方式。你可以接触到令人惊叹的文档和产出物并从中学习。此外，简历上的公司 Logo 对未来的工作机会也非常有力，这又回到了你提到的面试技能，以及为了进入这样的公司，擅长面试是多么重要。

---

### [00:40:24] Jules Walter

**English:**
Yeah, totally.

**中文翻译:**
是的，完全正确。

---

### [00:40:25] Lenny

**English:**
Interesting. Okay. What about on EQ? Any examples of how you learned some of those skills that you talked about communication or leadership or management or anything along those lines?

**中文翻译:**
有意思。那 EQ 方面呢？有没有例子说明你是如何学习你提到的那些技能的，比如沟通、领导力、管理或类似的能力？

---

### [00:40:36] Jules Walter

**English:**
Yeah. On the communications side, I read some stuff like Minto's Pyramid Principles. Extremely helpful and I know you had an article on that. I mentioned also that whenever I see a great email exec update or whatever, I literally save it in a special folder. Also, by the way, I always ask for feedback more than I think many people and I try to see patterns in feedback. For me, one thing I've observed is I tend to write long sentences, coming from a Haitian-French background, but then I see that because I've seen enough feedback that are about it so I see the patterns. Or as I mentioned earlier, I used to not be clear like, "Are you saying this solution or that solution?" It's better sometimes to be wrong but clear than the other way around. That's on the comms side. And then the other things, it's mostly, for me, through mentorship, people like Lawrence helping me be real with myself. I've had a coach for a while and I also do group coaching, which I really love. Right now I'm doing group coaching with a company called Pathways to Leadership.

**中文翻译:**
有的。在沟通方面，我读过像《金字塔原理》（Minto's Pyramid Principles）之类的书。非常有帮助，我知道你也写过相关的文章。我也提到过，每当我看到一封很棒的邮件、高管汇报或其他东西，我都会把它存进一个专门的文件夹。顺便说一下，我请求反馈的频率比大多数人都高，并且我会尝试从反馈中寻找模式。对我来说，我观察到的一点是，由于我的海地-法国背景，我倾向于写长句子，但我通过足够多的反馈看到了这个模式。或者像我之前提到的，我以前表达不清晰，比如：“你是在说这个方案还是那个方案？” 有时，“宁可错误但清晰”也比含糊其辞要好。这是沟通方面的。其他方面，对我来说主要是通过导师指导，像 Lawrence 这样的人帮助我诚实面对自己。我请过一段时间的教练，也参加小组教练（Group Coaching），我非常喜欢。目前我正在参加一家名为 Pathways to Leadership 的公司的小组教练。

---

### [00:41:48] Jules Walter (Continued)

**English:**
These sort of things have helped me infer what my strengths and weaknesses are and then work on them. And then one thing I'll say also about the EQ: it was the most frustrating learning for me. For the IQ stuff, within six months, sometimes three months, I can see clear progress when you see enough documents. You see five, six of them, you start seeing 80% of the patterns. But then with the EQ stuff, it's things I've been working on for years. I am better at them, but I still feel like I'm continuing to work on those things. And a lot of it is like lifting weights or building muscles; you have to do it every day or every week. And then if you stop doing it, over time you atrophy again. That's something that people need to acknowledge, too. Give yourself time and then also learn these skills one at a time ideally.

**中文翻译:**
这些事情帮助我推断出我的优势和劣势，然后针对性地改进。关于 EQ，我还想说一点：这是我学习过程中最令人沮丧的部分。对于 IQ 类的东西，在六个月甚至三个月内，只要你看过足够的文档，就能看到明显的进步。你看过五六个文档，就能掌握 80% 的模式。但对于 EQ 类的东西，有些是我已经努力了很多年的。我确实变好了，但我仍然觉得我需要继续努力。这在很大程度上就像举重或练肌肉；你必须每天或每周都练。如果你停止练习，随着时间的推移，它又会萎缩。这也是人们需要承认的一点。给自己时间，理想情况下，一次只学习一项技能。

---

### [00:42:45] Lenny

**English:**
Oh, interesting. Can you talk a bit more about that learning skills one at a time? Is your approach just like, "Here's the thing, I'm working on this the next six months. I'm going to focus on that."

**中文翻译:**
噢，很有趣。你能多聊聊“一次只学一项技能”吗？你的方法是类似于：“这就是我要练的，接下来的六个月我就专注这一项”吗？

---

### [00:42:53] Jules Walter

**English:**
Yeah. My approach is typically I'll say, "I'm giving myself, I don't know, three months, six months." It depends on what [inaudible 00:43:00] I want to see in my behavior for these things and then I just go all in on that skill. Let's say I wanted to learn strategy, I'll be like, "Okay, I'm giving myself, let's say, six months." Every week, I'm going to do something related to learning strategy. It's going to be maybe I read the strategy for another feature product at my company and you just divide, right? Let's just say there's 10 features or 20, it doesn't matter. You just do one a week, so 20 weeks. You see what I'm saying? And then the other thing is, every week I'm also going to practice it towards my outcome. I'm going to spend, I don't know, three hours a week, maybe one hour a day, just thinking through my own product strategy. And I do that for six months. You do it enough that you get over the hump and then actually develop the skill. Now, the other approach you could take is... What most people do is they read an article on your newsletter or some other place and then like, "Oh, great. I learned an insight." And then you go back to usual.

**中文翻译:**
是的。我的方法通常是说：“我给自己三个月或六个月。” 这取决于我想在这些行为中看到什么样的变化，然后我就全身心投入到那项技能中。假设我想学策略，我会说：“好吧，我给自己六个月时间。” 每周我都会做一些与学习策略相关的事情。可能是阅读公司里另一个功能产品的策略，你可以把它拆解，对吧？假设有 10 个或 20 个功能，没关系，每周看一个，就是 20 周。你懂我意思吗？另一件事是，每周我也会针对我的目标进行练习。我会每周花，比如三小时，或者每天一小时，专门思考我自己的产品策略。我坚持做六个月。你做得足够多，就能跨过那个坎，真正掌握这项技能。而大多数人采取的另一种方法是：读了你的通讯或其他地方的一篇文章，然后想：“噢，太棒了，我学到了一个见解。” 然后就一切照旧了。

---

### [00:44:00] Lenny

**English:**
And it's not like at the end of these six months, you're done. I'm strategy expert, I am good on strategy. To your point, it's building this muscle that will never be fully built. It just will get stronger. And every time you invest time learning something, it gets stronger.

**中文翻译:**
而且并不是说这六个月结束你就“完工”了，成了策略专家，策略无敌了。正如你所说，这是在练肌肉，它永远不会完全练成，只会变得更强。每次你投入时间学习，它就会变得更强一点。

---

### [00:44:15] Jules Walter

**English:**
Yeah, exactly. It's not that within six months you are clearly better. Now, you can invest another six months to get to the next level. Or you could say, "Now I'm going to switch focus to another skill and get that one to a similar level."

**中文翻译:**
是的，没错。并不是说六个月内你就明显变强了。你可以再投入六个月进入下一个阶段。或者你可以说：“现在我要把重心转移到另一项技能上，把它提升到类似的水平。”

---

### [00:44:28] Lenny

**English:**
Is there a skill you're working on right now?

**中文翻译:**
你现在正在练习哪项技能吗？

---

### [00:44:30] Jules Walter

**English:**
Always working on something. One I can call out is listening. One thing about the EQ stuff, too, by the way is you hear these words, and depending on how familiar you are, you understand or don't understand what it actually means. When I say listening, I'm good at seeking information to solve a problem. If you come to me and you're like, "Hey, Jules, I have this problem," I will know what to listen for and what to ask you. "Hey, Lenny, can you tell me A, B?" And then I'll help you solve the problem. However, there's also different listening patterns, one of which is you just create space for someone. It's not like you're seeking a particular information, just give them space to tell you what they want to tell you. And then the other side of it, too, is you help that person feel heard, "Hey, I feel like you actually understand me and you've heard what I'm saying." So, that's the part I am working on.

**中文翻译:**
我总是在练习某些东西。我可以提的一个是“倾听”。顺便说一下，关于 EQ 的东西，你会听到这些词，但根据你的熟悉程度，你可能理解也可能不理解它的真正含义。当我提到倾听时，我擅长为了解决问题而寻求信息。如果你来找我说：“嘿，Jules，我有这个问题，” 我会知道该听什么以及该问你什么。“嘿，Lenny，你能告诉我 A 和 B 吗？” 然后我会帮你解决问题。然而，倾听也有不同的模式，其中之一是为某人创造空间。你不是在寻求特定的信息，只是给他们空间让他们说出想说的话。另一面是，你让那个人感到被听见了，“嘿，我觉得你真的理解我，听进去了我说的话。” 这就是我正在努力的部分。

---

### [00:45:25] Lenny

**English:**
You mentioned the Matt Mochary episode. I imagine you've been listening to that, because that has a lot of great advice.

**中文翻译:**
你提到了 Matt Mochary 那一集。我猜你一直在听那一集，因为那里有很多极好的建议。

---

### [00:45:29] Jules Walter

**English:**
Yeah. Yeah, exactly. It's those kinds of things, right? And then he talked about saying back to people what you heard, asking for more information, et cetera.

**中文翻译:**
是的，没错。就是那类事情，对吧？他谈到了向对方复述你听到的话，询问更多信息等等。

---

### [00:45:38] Lenny

**English:**
Awesome. You mentioned that you asked for feedback from your peers, and I wrote that down. I wanted to double-click on that a little bit. How do you actually approach asking for feedback? Do you sound like a survey? Do you just ask people in meeting? How do you do that?

**中文翻译:**
太棒了。你提到你会向同事寻求反馈，我记下了这一点。我想深入探讨一下。你实际上是如何请求反馈的？听起来像是在做调查吗？还是直接在会议上问？你是怎么做的？

---

### [00:45:51] Jules Walter

**English:**
The feedback piece, it's something that I had to get better at. Over time, I'm asking for it, because what I realize is if people don't feel comfortable with you, they won't give you feedback. It's depending on the risk, right? Especially if it's constructive feedback. By the way, that's also something that's hard about being underrepresented. People sometimes don't have the same natural level of connection with you. I basically learned to go out of my way to make people comfortable giving me feedback. There's different techniques and Matt Mochary also talks about some of them. Sometime it's basically ask in a very specific way, "Hey, I did this presentation. I'm working on, I don't know, having more executive presence. Did you feel that? To which extent did you feel that I showed executive presence?" So, it's a very specific thing versus, "Hey, how did it go?" That's one thing you can do.

**中文翻译:**
反馈这一块，是我必须努力提升的部分。随着时间的推移，我一直在主动请求反馈，因为我意识到如果人们觉得和你相处不自在，他们就不会给你反馈。这取决于风险，对吧？尤其是建设性的反馈。顺便说一下，这也是作为少数群体比较困难的一点。人们有时和你没有那种天然的联系感。我基本上学会了特意去让人们在给我反馈时感到自在。这里有不同的技巧，Matt Mochary 也谈到了一些。有时是采用非常具体的方式提问：“嘿，我做了这个演示。我正在努力提升，比如，高管气场（Executive Presence）。你感觉到了吗？在多大程度上你觉得我展现了高管气场？” 这是一个非常具体的问题，而不是问“嘿，表现怎么样？” 这是你可以做的一件事。

---

### [00:46:45] Jules Walter (Continued)

**English:**
Other thing you can do sometimes is you give yourself critical feedback in front of them and then you give them a chance to agree or disagree. "Hey, I feel like this presentation didn't go well for this reason. What do you think? But actually I thought it would've been fine; however, this other thing could have been better." And then the other thing I'll say that is very, very important if you're asking people for feedback is if you manage to get them to take the risk to give you the feedback, your answer has to be enthusiastically grateful. That's the key. What people knew at Slack, Google, et cetera, is if you give me feedback, I'll be like, "Hey, thank you so much. This is super helpful," because people are like, "Oh, he actually likes the feedback." Now, inside, my heart might be melting. I'm like, "Oh, I thought I got better at this." You know what I mean?

**中文翻译:**
有时你也可以做的另一件事是，在他们面前先给自己一些批判性的反馈，然后给他们机会表示赞同或反对。“嘿，我觉得这次演示因为这个原因表现得不太好。你觉得呢？其实我本来觉得还行，但另一件事本可以做得更好。” 还有一件非常非常重要的事情，如果你请求别人给你反馈，一旦你成功让他们冒着风险给了你反馈，你的回答必须是“充满热情的感激”。这是关键。在 Slack、Google 等公司，人们都知道如果你给我反馈，我会说：“嘿，非常感谢。这非常有帮助。” 因为人们会觉得：“噢，他真的喜欢反馈。” 虽然我内心可能正在“滴血”，想着：“噢，我以为我在这方面已经进步了。” 你懂我意思吧？

---

### [00:47:42] Lenny

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:47:42] Jules Walter

**English:**
But externally, I'm like, "Hey, thank you," and I mean it. I think that's the key that most people don't sort of focus on. And if you get more feedback, then you'll just get better at the things.

**中文翻译:**
但在外表上，我会说：“嘿，谢谢你，” 而且我是真心的。我认为这是大多数人不太关注的关键。如果你能获得更多反馈，你就能在这些事情上做得更好。

---

### [00:47:51] Lenny

**English:**
That is such a good advice, all these very tactical ways of getting actual real feedback from people.

**中文翻译:**
这真是极好的建议，这些从人们那里获得真实反馈的方法非常具有实操性。

---

### [00:47:55] Jules Walter

**English:**
Yeah. And then one thing I'll say, too, by the way, it's harder to get feedback on the EQ stuff, and that's also why it's harder to develop and why a lot of people reach terminal levels in product, because people are like, "Oh, they lack emotional intelligence." They say that in calibration rooms but not in your face, so that's also what you want when you hear feedback. You don't want just to like, "Hey, here's my piece of feedback that I can prove." You also want the part that is like, "Here's how you make me feel or how you come across that... If this is taken out of context, it won't be good for... I don't want this to be shared publicly or taken out of context, but I want you to know."

**中文翻译:**
是的。顺便说一下，获得关于 EQ 方面的反馈更难，这也是为什么它更难培养，以及为什么很多产品经理职业生涯会遇到瓶颈的原因。因为人们会私下说：“噢，他们缺乏情商。” 他们会在绩效校准会议（Calibration rooms）上这么说，但不会当面告诉你。所以当你听取反馈时，你也想要那部分内容。你不仅仅想要那种“嘿，这是我有据可查的一条反馈”，你还想要那部分：“你给我的感觉是这样的，或者你表现出来的样子是……如果脱离语境，这对你不好……我不希望这被公开分享或断章取义，但我希望你知道。”

---

### [00:48:55] Jules Walter (Continued)

**English:**
And it could be things like, "Hey, when I talk to you, sometimes I feel like, I don't know, you're angry." And then I'm like, "Oh, really? In what scenario?" And then it's like, "Oh, I was so focused and listening to you intently that I could see now why I come across that way." But you could literally go your whole career and then nobody ever says these things, right? And that's the kind of feedback that I personally find most helpful is the subjective feedback, because nobody will tell me those things. Once somebody I trust tell me and I'm like... Oh, here's an example. I mentioned earlier I'm good at asking questions. I had somebody ask like, "Tell me. Hey, sometimes when you ask questions, you sound more junior." And I was like, "Huh." And then I can see that because I asked the question plainly like, "Hey, why did you do this or how did you that," instead of also saying where I'm coming from, "Hey, I noticed this blah, blah, why, blah?" You know what I'm saying? Instead of showing I have an understanding of the thing and then asking a follow-up question, I just ask the question bluntly without context and people feel like, "Hey, I'm asking a very basic question." So, that's the kind of feedback that I particularly value.

**中文翻译:**
它可能是这样的：“嘿，当我跟你说话时，有时我觉得，我不知道，你好像在生气。” 然后我会问：“噢，真的吗？在什么情况下？” 接着发现：“噢，我当时太专注、太认真地听你说话了，我现在明白为什么我会给人那种感觉了。” 但你可能整个职业生涯都没人告诉你这些，对吧？这种主观的反馈是我个人觉得最有帮助的，因为没人会告诉我这些。一旦我信任的人告诉我，我就会……噢，举个例子。我之前提到我擅长提问。有人曾对我说：“嘿，有时你问问题的方式让你听起来比较资浅（Junior）。” 我当时想：“哈？” 然后我明白了，因为我问得很直白，比如：“嘿，你为什么要这么做？” 或者 “你是怎么做的？” 而没有说明我的出发点，比如：“嘿，我注意到了这点，为什么会这样？” 你懂我意思吗？我没有表现出我对这件事已有理解然后再问后续问题，而是不带背景地生硬提问，人们就会觉得：“嘿，他在问一个非常基础的问题。” 这就是我特别看重的那种反馈。

---

### [00:49:48] Lenny

**English:**
The feedback you're getting is pretty incredible, like the stuff you shared about someone saying you come across as angry in a meeting if you ask questions or you sound a junior. I don't know if I've ever gotten anyone to give me that brutally honest feedback. When those specific cases, what was it about these people that helped them give you this feedback? Is that what you talked about, you built trust with them over the years or is there something you did to get that kind of feedback?

**中文翻译:**
你得到的反馈相当惊人，比如你分享的有人说你在会议上提问时显得很生气，或者听起来很资浅。我不确定是否有人曾给过我这种“残酷诚实”的反馈。在那些具体的案例中，是什么让这些人愿意给你这种反馈？是因为你提到的多年来建立的信任吗？还是你做了什么才得到了这种反馈？

---

### [00:50:10] Jules Walter

**English:**
I mean, it's definitely they trusted me and they cared about me. They trust that if they tell me the feedback without translating, that I would see the intent behind it. And they were able to do that, because after months and years of working together, they know how to respond to feedback. Because what happens is most people, when you have to get feedback, you kind of have to really do a lot of translation work so that it lands, "I don't want to hurt your feeling. I don't want you to take this." I just told people, "You don't have to that with me." That's one. And then the other thing, too, is people reciprocate also how you talk. I'm not saying I talk to people like this, but I try to be vulnerable with people so they know we can be vulnerable and things are safe like, "I really want to hear things the way you experience it."

**中文翻译:**
我的意思是，这绝对是因为他们信任我、关心我。他们相信如果他们不加修饰地告诉我反馈，我能理解背后的意图。他们之所以能做到这一点，是因为经过数月甚至数年的合作，他们知道我会如何回应反馈。因为通常情况下，当你必须给别人反馈时，你必须做大量的“翻译”工作，好让它听起来委婉，“我不想伤害你的感情，我不想让你误解。” 我直接告诉大家：“跟我说话不需要那样。” 这是其一。其二，人们也会根据你说话的方式给予回报。我不是说我总是这样对人说话，但我尝试对人展现脆弱（Vulnerable），这样他们就知道我们之间可以坦诚相见，环境是安全的，比如：“我真的很想听听你真实的感受。”

---

### [00:50:59] Lenny

**English:**
Got it. So, there's a lot of foundation setting that you do to create this environment where people are like, "Jules, here's something that's going wrong. You can work on this."

**中文翻译:**
明白了。所以你做了很多铺垫工作来创造这种环境，让人们觉得可以对你说：“Jules，这里有些问题，你可以改进一下。”

---

### [00:51:05] Jules Walter

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:51:06] Lenny

**English:**
That's an awesome takeaway. One other thread I wanted to pull on is you mentioned focusing on strengths and how that ends up being really important. Something I'm a big believer in is focusing on strengths versus trying to make your weaknesses much, much stronger. Is there any advice you can share to better understand what your strengths are, why that's an approach to take in developing your skills?

**中文翻译:**
这是一个很棒的收获。我想追问的另一个点是你提到的关注优势，以及这为何如此重要。我非常坚信应该关注优势，而不是试图把劣势补强。关于如何更好地了解自己的优势，以及为什么这是培养技能的一种有效方法，你有什么建议吗？

---

### [00:51:28] Jules Walter

**English:**
For the strengths, breakthroughs. For me, a lot of it was talking to my mentor, Lawrence Ripsher. And I organized this event for Black PMs at Pinterest, where Lawrence was speaking, and then we were talking about, "Hey, watch should we talk about, et cetera." I don't know how, but in the conversation he talked about doubling down your strengths more than on fixing your weaknesses, and then he used me as an example. Then the fun part is he had this approach of how you actually find your strength. It's a very simple question, where basically he's like, "Hey, what is something that a lot of people say you're good at, but you think it's not a big deal or it's not that important?" And that's the key. I always that's what resonated with me. I was like, "Oh, a lot of people keep saying I'm really good at networking."

**中文翻译:**
关于优势的突破。对我来说，很大程度上是由于与我的导师 Lawrence Ripsher 的交谈。我曾在 Pinterest 为 Black PMs 组织了一次活动，Lawrence 是演讲嘉宾，我们当时在讨论：“嘿，我们应该聊些什么，等等。” 我不记得是怎么开始的，但在谈话中他谈到了“加倍发挥优势”比“修补劣势”更重要，然后他拿我举例。有趣的是，他有一套寻找优势的方法。这是一个非常简单的问题，他基本上会问：“嘿，有什么事情是很多人说你很擅长，但你自己觉得没什么大不了，或者觉得不那么重要的？” 这就是关键。这一直让我产生共鸣。我想：“噢，很多人一直说我非常擅长社交（Networking）。”

---

### [00:52:32] Jules Walter (Continued)

**English:**
I'm like semi-introvert, so I'm like, "Hold on, I don't know." [inaudible 00:52:32] not everyone or people will tell me, "Hey, you have asked great questions." And I'm like, "I asked basic questions." And then he helped me understand, "Actually, that's how you know it's a strength." Now, what you need to figure out is how do you get more out of that strength. An analogy, by the way, is imagine that you saw a fish and you were like, "Hey, you're really good at swimming." And then the fish would be like, "Oh. Duh, doesn't everybody swim?" And so, that's the key and I invite people to think about that question like, "What's something people keep telling you you're good at, but you yourself don't think is a big deal?" And that's how I was able to find a bunch of my strengths.

**中文翻译:**
我有点半内向，所以我想：“等等，我不知道。” 并不是每个人都会这样，或者人们会告诉我：“嘿，你问的问题太棒了。” 而我会想：“我问的是基础问题啊。” 然后他帮我理解：“实际上，这就是你判断它是一项优势的方法。” 现在，你需要弄清楚的是如何从这项优势中获得更多价值。顺便打个比方，想象你看到一条鱼，你说：“嘿，你真的很擅长游泳。” 鱼会说：“噢，废话，难道不是大家都会游泳吗？” 所以，这就是关键，我邀请大家思考这个问题：“有什么事情是别人一直夸你做得好，但你自己却觉得没什么大不了的？” 这就是我找到自己一系列优势的方法。

---

### [00:53:09] Jules Walter (Continued)

**English:**
For me, generally I'm thoughtful, ask great questions. I also simplify problems a lot. I mean, we work together on a product sense article, which is a very complex thing, made it more simple. And then once you identify the strength, then it helps to also think about why are you good at this thing? Because that's the underlying resource that you have. A big part for me is I'm actually quite curious. And fun fact, I don't think of myself as curious, but people keep telling me I am. And even my mom was telling me when I was a kid, I used to always try to unscrew toys to see how they work in the inside. That's one thing: being curious help me ask the questions and so on. And then the other thing, too, is once you have the strength, you want to understand the shadow side of it, and that's the connection between your strength and weaknesses.

**中文翻译:**
对我来说，通常我比较周到，擅长提问。我也经常简化问题。我是说，我们曾合作写过一篇关于产品感的文章，那是一个非常复杂的主题，但我们把它简化了。一旦你识别了优势，思考一下“你为什么擅长这件事”也会很有帮助，因为那是你拥有的底层资源。对我来说，很大一部分原因是我其实非常有好奇心。有趣的是，我不觉得自己好奇心强，但人们一直这么说。甚至我妈妈告诉我，我小时候总是尝试拧开玩具的螺丝，看看里面是怎么运作的。这就是一点：好奇心帮助我提问等等。另一件事是，一旦你有了优势，你也要了解它的“阴暗面”（Shadow side），这就是优势和劣势之间的联系。

---

### [00:54:02] Jules Walter (Continued)

**English:**
That was a key breakthrough for me, especially Lawrence helped me understand that. Strengthen and weakness, it's not a binary thing. It's like the same thing, but it's a dial. In some context it's good, in other contexts it's serving you. An example in my cases is... I talked about I ask great questions, but sometimes I ask a question without context, I might come across as less knowledgeable. Or another thing for me is I'm able to take very complex problems and then create a mental model that's much simpler, whether it's growth or other things. But until I come up with that mental model, if I'm in a meeting with you, I won't talk much about that topic. Basically, I'm more quiet than other people when people want to hear my point of view because I'm just listening and trying to create a mental model of the situation. You're seeing how the same strength is perceived as a weakness depending on context. And once you have that... For me, I feel more empowered. I'm like, "Oh, I just have to dial down a little bit here or dial a little bit here," and I also know this thing is serving me, which is why I keep doing the bad side of it.

**中文翻译:**
那对我来说是一个关键的突破，尤其是 Lawrence 帮我理解了这一点。优势和劣势并不是二元的。它们就像是同一件事，只是刻度盘的位置不同。在某些语境下它是好的，在其他语境下它可能对你不利。我的例子是……我说过我擅长提问，但有时我不带背景地提问，可能会显得我不够专业。或者我的另一个特点是，我能处理非常复杂的问题并创建一个更简单的思维模型，无论是增长还是其他事情。但在我建立起那个思维模型之前，如果我和你一起开会，我不会对那个话题说太多。基本上，当人们想听我的观点时，我比别人更安静，因为我只是在倾听并尝试构建现状的思维模型。你看，同样的优势根据语境的不同会被视为劣势。一旦你明白了这一点……对我来说，我感到更有力量了。我会想：“噢，我只需要在这里调低一点，或者在那里调高一点，” 我也知道这件事在某种程度上是在帮助我的，这也是为什么我一直保留着它“不好”的那一面。

---

### [00:55:10] Lenny

**English:**
Awesome. This all often comes back to mentors in your life. I want to get to talking about mentorship and how you find your mentors, how you work with them, all that kind of stuff; something we've been touching on a bunch and I'm excited to begin to. Maybe to start, can you just talk about some of the mentors you've had in your life, some of the most impactful mentors that you've had?

**中文翻译:**
太棒了。这一切通常都会回到你生命中的导师身上。我想开始聊聊导师制度：你是如何找到导师的，如何与他们合作，以及所有这些我们一直在触及的内容，我很兴奋能开始这个话题。也许先从这里开始，你能谈谈你生命中遇到过的一些导师吗？哪些是对你影响最大的？

---

### [00:55:35] Jules Walter

**English:**
I've definitely had a large number of mentors over the years. Fun fact, when I came to the area eight years ago, I didn't know anyone. It took a while to build those relationships. I talked earlier about Bangaly Kaba who sort of helped me figure out how to grow Slack even though he wasn't working outside, but helped me have the frameworks. I talked about Lawrence Ripsher. He helped me discover my strengths and also how to lean into them. Aaron Teague is another friend and mentor who brought me to Google, actually. And there's also Bradley Horowitz, former VP of Google Photos, also helped me in terms of how do you think about leadership and so on. Many other folks, Nikhyl Singhal, VP at Meta helped me with PM career. So, lots of mentors for sure.

**中文翻译:**
这些年来我确实有很多导师。有趣的是，八年前我刚来湾区时，一个人都不认识。建立这些关系花了不少时间。我之前提到过 Bangaly Kaba，尽管他当时不在 Slack 工作，但他帮我理清了如何增长 Slack，给了我很多框架。我提到了 Lawrence Ripsher，他帮我发现了我的优势以及如何利用它们。Aaron Teague 是另一位朋友兼导师，实际上是他把我带进 Google 的。还有 Bradley Horowitz，前 Google Photos 副总裁，在如何思考领导力等方面也给了我很大帮助。还有很多人，比如 Meta 的副总裁 Nikhyl Singhal，在 PM 职业生涯方面指导过我。所以，确实有很多导师。

---

### [00:56:23] Lenny

**English:**
Okay, that's the killer list. Two questions. One, what do you look for in a mentor when you're trying to find someone to work with? And then two, how do you actually find these people? Most people listening are like, "Wow, I would love an amazing mentor to help me in my career. I don't know how to find one." What advice do you have for folks to finding a mentor?

**中文翻译:**
好，这是一份超强的名单。两个问题。第一，当你尝试找人合作时，你在导师身上寻找什么特质？第二，你实际上是如何找到这些人的？大多数听众可能会想：“哇，我也想要一个这么棒的导师来帮我发展职业生涯，但我不知道怎么找。” 对于寻找导师，你有什么建议吗？

---

### [00:56:41] Jules Walter

**English:**
I look for two things. One is, are you good at one specific thing I'm trying to get better at? And then two is, are you good at explaining it? Those two, at least for me, they're important. I know people are really good at their roles, at their job and at the subject, but they don't actually know how they do it or they don't really want to explain or cannot explain easily. So, that's what I look for. And then in terms of where I find these people, it's really everywhere. If you look at the list I mentioned earlier, Bangaly I met at an event. Facebook had a recruiting event, I showed up, I see this guy, I'm like, "Oh. Hi." Chat a little bit. I talked about Lawrence, who's now a close friend. I met Lawrence at a dinner. He organized a dinner for underrepresented PMs, we chatted, one thing led to the other, and then he became a mentor and friend. Bradley was at a fundraiser. And Nikhyl was an intro via email. Somebody was like, "Oh, you should meet Nikhyl."

**中文翻译:**
我主要看两点。第一，你是否擅长我正努力提升的某项具体技能？第二，你是否擅长解释它？这两点对我来说很重要。我知道有些人非常擅长他们的角色、工作和专业领域，但他们其实不知道自己是怎么做到的，或者他们不想解释，或者无法轻易解释清楚。所以这是我寻找的特质。至于在哪里找到这些人，其实到处都是。看看我刚才提到的名单：Bangaly 是我在一次活动中认识的。Facebook 举办了一次招聘活动，我去了，看到了他，打了个招呼，聊了一会儿。我提到的 Lawrence 现在是密友，我是在一次晚宴上认识他的。他为少数群体 PM 组织了一次晚宴，我们聊了聊，顺理成章地，他成了我的导师和朋友。Bradley 是在一次筹款活动上认识的。Nikhyl 是通过邮件介绍认识的，有人说：“噢，你应该见见 Nikhyl。”

---

### [00:57:41] Jules Walter (Continued)

**English:**
I know this sounds counterintuitive. I don't think the hard part is where to find them; it's more about finding the right person and then how do you get a foot in? Now, what I've seen... A lot of people, sometimes they get mentors who are too senior or who don't actually think about the topic they're interested in. Maybe they did five years ago, but once you find the right person, the key is like, "How do you have that initial conversation? How do you get the foot in the door?" And what I've found is you should make the smallest ask possible, which is the opposite of what 95% of people do. 95% of people is like, "Hey, I've never met you, but I heard your talk or I saw you on LinkedIn or whatever. Can we set up a call?"

**中文翻译:**
我知道这听起来可能违背直觉。我不认为难点在于“去哪里找”，而在于找到合适的人，以及如何“入门”？现在我看到的是……很多人有时找的导师太资深了，或者对方其实并不关注他们感兴趣的主题（也许五年前关注，但现在不关注了）。一旦你找到了合适的人，关键在于：“如何进行第一次对话？如何敲开大门？” 我发现你应该提出“尽可能小的请求”，这与 95% 的人的做法恰恰相反。95% 的人会说：“嘿，我从没见过你，但我听过你的演讲或者在 LinkedIn 上看到过你，我们能打个电话吗？”

---

### [00:58:29] Jules Walter (Continued)

**English:**
That's like a big ask. What I do... For example, there's this person who came to Slack, he was head of product of a major company and then he gave a talk about different methods to improve products. He had this concept of finding the heat for products. He spoke at the company, I got his email, and I reached out in the evening and I was like, "Hey, thanks so much for speaking today. We talked about finding the heat for products. Is there an example of product that you think was created with this approach?" Something he could answer in literally two minutes via email? That was my question. It wasn't like, "Hey, you talked. Now, I feel entitled to meet with you." But then the key is once you get that foot in the door, it could be a quick email, a tweet, a quick chat at an event, that sort of thing, and you get some advice that's useful, the key is to circle back with them at a later point and show that you've actually made good use of the advice.

**中文翻译:**
那是一个很大的请求。而我会这样做……例如，有个人来 Slack 演讲，他是一家大公司的产品负责人，他做了一个关于改进产品的不同方法的演讲。他提出了一个“寻找产品热点”（Finding the heat for products）的概念。他在公司演讲完后，我拿到了他的邮箱，当晚就联系了他，我说：“嘿，非常感谢今天的演讲。我们谈到了寻找产品热点，有没有哪个产品的例子是你认为是用这种方法创造出来的？” 这是一个他花两分钟回邮件就能回答的问题。这就是我的问题。我没有表现得像是：“嘿，你演讲了，现在我觉得我有权见你一面。” 关键在于，一旦你敲开了门（可能是一封简短的邮件、一条推文、活动中的简短交谈），并且得到了一些有用的建议，关键是要在之后回馈给他们，展示你确实很好地利用了这些建议。

---

### [00:59:30] Jules Walter (Continued)

**English:**
I think that's the thing nobody does. What I would do... For example, there's currently the CEO of a top tech company I met an event. She spoke there and then she gave some advice that was useful. I emailed her a follow-up type thing and then she gave me advice about how to rethink the mission statement for my nonprofit, all via email. Then at some point I was like, "Hey, I've applied your problem trend competency framework to crafting the mission for my nonprofit. Here's where we landed. That was super helpful. Thank you so much." Replies back. And then what I would do then later is maybe a month later or two months, X months later, I can reach out again for another problem and maybe I could say, "Hey, this time it's a little bit more nuanced. Can we grab 15 minutes?" And the person was like, "Yeah, sure." That person was very, very busy. I was like, "Hey, let's do it." And then over time we become Facebook friends, that sort of thing, but that's the approach I take.

**中文翻译:**
我认为这是没人做的事情。我会这样做……例如，我曾在一次活动中遇到一位顶尖科技公司的 CEO。她在那里演讲并给了一些有用的建议。我给她发了一封后续邮件，然后她通过邮件给了我关于如何重新思考我非营利组织使命宣言的建议。后来在某个时间点我说：“嘿，我把你那个‘问题趋势能力框架’应用到了我非营利组织的使命制定中。这是我们的最终结果。非常有帮助，太感谢了。” 她回信了。然后过了一两个月，或者几个月后，我可以再就另一个问题联系她，也许我会说：“嘿，这次的问题稍微复杂一点，我们能聊 15 分钟吗？” 对方会说：“好啊，没问题。” 那个人非常非常忙，但我说：“嘿，我们聊聊吧。” 随着时间的推移，我们成了 Facebook 好友之类的，这就是我采取的方法。

---

### [01:00:29] Lenny

**English:**
That's such a good advice. It reminds me of Tim Ferris's advice also, which is just like, "Don't go up to someone and be like, 'Will you be my mentor?'" Everyone's going to be like, "I don't have time for that." Instead, to your point, it's the exact opposite. Just start asking simple questions and then over time build up relationship, and then over time, maybe you start meeting regularly. But don't start big; start small.

**中文翻译:**
这真是极好的建议。这让我想起了 Tim Ferriss 的建议，即：“不要直接走到某人面前问‘你能当我的导师吗？’” 每个人都会觉得：“我没时间做那个。” 相反，正如你所说，应该反其道而行之。先从问简单的问题开始，随着时间的推移建立关系，然后也许会开始定期见面。不要一开始就搞得很大，要从小处着手。

---

### [01:00:50] Jules Walter

**English:**
You. As small as possible.

**中文翻译:**
是的，尽可能小。

---

### [01:00:53] Lenny

**English:**
It's not like you just have one mentor. You've listed a whole bunch of people that have helped you over your career. It's not like, "Here's the person, they have to be perfect." It sounds like you kind of identify, "Here's a skill or an area I want to focus and this person is going to be really good at that."

**中文翻译:**
而且你并不是只有一个导师。你列举了一大堆在职业生涯中帮助过你的人。并不是说“就是这个人了，他必须是完美的”。听起来你更像是识别出：“这是我想专注的一项技能或领域，而这个人在这方面非常擅长。”

---

### [01:01:06] Jules Walter

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:01:07] Lenny

**English:**
Then I also just love the point about it feels really hard to find an amazing mentor. From what I'm hearing, the main thing you do is just go to things, attend events, basically go events, meet people, right? That's kind of the foundation in which you're sharing is just meet as many people as you can, and amongst that group, you'll find people that are probably going to be helpful.

**中文翻译:**
我也很喜欢你提到的关于寻找优秀导师很难的那一点。根据我的理解，你做的主要事情就是去参加活动、出席会议，基本上就是去现场见人，对吧？这就是你分享的基础：尽可能多地见人，在这些人中，你会找到可能对你有帮助的人。

---

### [01:01:26] Jules Walter

**English:**
Yeah. And I understand it can be harder for some folks. I mean, now I have two young kids, so I don't do as many events. I've also met quite a few people through introductions, sometimes being cold outreach. I had a chat with Shishir through cold outreach [inaudible 01:01:44] a very clear question, and then he offered to come to Black PMs and share some insights. Those kinds of things happen, too, but you have to show the person that you're going to make really good use of their time. You have to give really specific contexts like, "Hey, let's grab coffee." It's like, "Hey, here's a very specific question. Can you share some thoughts or point via email?" And then they might offer, "Hey, why don't we just talk?" That sort of thing, too. Yeah.

**中文翻译:**
是的。我明白这对某些人来说可能更难。我是说，我现在有两个年幼的孩子，所以我参加的活动没那么多了。我也通过介绍认识了不少人，有时也会进行“冷启动”联系（Cold outreach）。我曾通过冷启动联系与 Shishir 交流过，问了一个非常明确的问题，然后他主动提出到 Black PMs 分享一些见解。这类事情也会发生，但你必须向对方证明你会非常有效地利用他们的时间。你必须给出非常具体的背景，而不是说“嘿，我们去喝杯咖啡吧”。应该是：“嘿，这是一个非常具体的问题，你能通过邮件分享一些想法或指点一下吗？” 然后他们可能会主动说：“嘿，我们干脆聊聊吧？” 也会有这种情况。是的。

---

### [01:02:09] Lenny

**English:**
That works really well. Anytime I get an email request of, "Hey, could we do a 15-minute Zoom or a copy chat," I quickly do not have time for that. But an actual question that I can be really helpful with really quickly, that's so much easier, so that makes a lot of sense. The next thing I wanted to ask you is: how do you build and continue this relationship? And then once you actually start engaging regularly, what do you suggest folks talk about in these meetings if they're ongoing.

**中文翻译:**
这非常奏效。每当我收到邮件请求说“嘿，我们能进行 15 分钟的 Zoom 或咖啡聊聊吗”，我很快就会发现我没时间。但如果是一个我能很快提供帮助的实际问题，那就容易得多，所以这很有道理。接下来的问题是：你如何建立并维持这种关系？一旦你们开始定期交流，你建议大家在这些持续的会议中聊些什么？

---

### [01:02:37] Jules Walter

**English:**
I make sure to bring something very specific that I'm dealing with where they can provide input. And this is the opposite of what many people do where they're like, "Hey, can you tell me about how you... Whatever, your path to PM," which may or may not be relevant to them, versus, "Hey, I've interviewed for three companies. I'm trying to decide among those three. Can I walk you through my thought process and get your feedback?" So, it's very different. I definitely make sure I bring a very specific context, and sometime it could be... I mentioned the example of Bangaly like, "Hey, I'm now a growth PM at Slack. I'm trying to improve activation. Can I talk to you about how you approach growth in general?" Or it could be, "Hey, I'm having internal..." Let's say I have internal mentors at Google and I have a few, then it's like, "Hey, I'm about to have this negotiation with this team. Can I walk you through my thought process and hear your advice?" So, it's very specific things.

**中文翻译:**
我会确保带去一些我正在处理的、他们可以提供建议的非常具体的事情。这与很多人的做法相反，很多人会问：“嘿，你能告诉我你是如何……比如，你的 PM 晋升之路吗？” 这对他们来说可能相关也可能不相关。相比之下，我会问：“嘿，我面试了三家公司，我正在这三家之间做决定。我能向你梳理一下我的思考过程并听听你的反馈吗？” 这非常不同。我一定会带去一个非常具体的背景。有时可能是……我提到过 Bangaly 的例子：“嘿，我现在是 Slack 的增长 PM，我正在努力提高激活率。我能和你聊聊你通常是如何处理增长的吗？” 或者可能是：“嘿，我正在处理内部事务……” 假设我在 Google 有几位内部导师，我会说：“嘿，我正准备和这个团队进行一次谈判。我能向你梳理一下我的思考过程并听听你的建议吗？” 都是非常具体的事情。

---

### [01:03:37] Jules Walter (Continued)

**English:**
And then the other thing I'll say, too, is when I talk to mentors, I always take notes. I mean, I'm seeing you even here in this interview. You're taking notes. These are basic things people don't actually think about it sometimes. And then when I follow up, whether it's via email or in person, I bring up older conversations. It's like, "Hey, remember last time we told about X? I did it," or "Hey, how's your daughter? I know she was going to college this semester. How did that go?" So, it always feels like a continuation of a conversation and it feels like an actual relationship instead of transactional interactions. And then the other thing, too, is I try really hard to identify ways that I can be helpful. Sometimes, at the end of chat I'll be like, "Hey, is there anything I can help you with? Anything top of mind for you?" And sometimes the person could be senior or wealthy, doesn't matter, and they're like, "Actually, yes. I'd love to better understand how the team is really doing. Nobody will tell me the truth," or "Hey, I am trying to hire for this role. You have [inaudible 01:04:43] Black PMs. Do you mind sharing?" There's always ways you can help, but most people are so focused on themselves that they miss out on these opportunities.

**中文翻译:**
另一件事是，当我与导师交谈时，我总是记笔记。我是说，我看到你甚至在这次采访中也在记笔记。这些是人们有时不会想到的基础事情。当我后续跟进时，无论是通过邮件还是当面，我都会提起之前的谈话。比如：“嘿，记得上次我们聊到的 X 吗？我做了，” 或者 “嘿，你女儿怎么样？我知道她这学期要上大学了，情况怎么样？” 这样感觉就像是谈话的延续，感觉像是一段真实的关系，而不是事务性的互动。还有一点，我会非常努力地寻找我能提供帮助的方式。有时在聊天结束时我会问：“嘿，有什么我可以帮你的吗？你最近有什么关注的事情吗？” 有时对方可能很资深或很富有，这没关系，他们可能会说：“实际上，是的。我很想更好地了解团队的真实情况，没人跟我说实话，” 或者 “嘿，我正尝试招聘这个职位，你在 Black PMs 有人脉，你介意分享一下吗？” 总有你可以帮忙的地方，但大多数人太专注于自己，以至于错失了这些机会。

---

### [01:04:52] Lenny

**English:**
The point about coming back to the person and sharing what impact their advice had and how it went is so good, because to your point, it just feels like you're sharing all this advice and just isn't going anywhere. And then note-taking, such great stuff. This is really good advice. I could see how it would work on me if someone's asking me for advice.

**中文翻译:**
关于反馈建议的影响和进展这一点非常好，因为正如你所说，如果只是分享建议却没有任何回音，感觉就像建议石沉大海。还有记笔记，这些都太棒了。这是非常好的建议。我可以想象如果有人这样向我寻求建议，我会很受用。

---

### [01:05:10] Jules Walter

**English:**
By the way, I mean we didn't know each other two years ago, right?

**中文翻译:**
顺便说一下，两年前我们还不认识，对吧？

---

### [01:05:10] Lenny

**English:**
Yeah, that's right.

**中文翻译:**
是的，没错。

---

### [01:05:14] Jules Walter

**English:**
Yeah. It's like a similar process, where we got to know each other mostly via email and led to the other, and we try to help each other.

**中文翻译:**
是的。这其实是一个类似的过程，我们主要通过邮件认识，然后一步步发展，我们尝试互相帮助。

---

### [01:05:22] Lenny

**English:**
And look at us now. Any final thoughts before we wrap up and head to our very exciting lightning round?

**中文翻译:**
看看现在的我们。在结束并进入非常令人兴奋的闪电轮（Lightning round）之前，还有什么最后的想法吗？

---

### [01:05:31] Jules Walter

**English:**
I have found the process of learning how to be a PM very difficult and I also find it quite rewarding. And I want to set expectation, especially for people who are early in their career, people may be frustrated by the process, because you have all these skills. We listed, I don't know, half a dozen, a dozen that you want to get better at. So, be patient. Then also it takes a while to see massive differences, but once you see those differences, you set yourself apart from your peers. That's one thing. And then the other thing, too, is it's really building muscles more so for the EQ stuff, but even for the IQ stuff. You have to practice. It's not just read Lenny's top 10 articles for two hours and then you're good. Read them, do what they say, get feedback after you do what they say and say like, "Huh, it worked for me. It didn't work for me." Reread them again, find mentors, et cetera. It's a long process and I don't think people have that mental model around how to learn in general, but also specifically how to learn the PM skills.

**中文翻译:**
我发现学习如何成为一名 PM 的过程非常困难，但也非常有成就感。我想给那些处于职业生涯早期的人设定一个预期：你可能会在这个过程中感到沮丧，因为有这么多技能需要掌握。我们列举了半打甚至一打你想提升的技能。所以，请保持耐心。看到巨大的差异需要时间，但一旦你看到了这些差异，你就会脱颖而出。这是一点。另一点是，这真的是在练肌肉，EQ 方面如此，IQ 方面亦然。你必须练习。不仅仅是花两小时读完 Lenny 的前 10 篇文章就完事了。读完它们，按照它们说的去做，做完后获取反馈，然后思考：“哈，这对我有用，或者这个对我没用。” 再次阅读，寻找导师等等。这是一个漫长的过程，我认为人们通常没有关于“如何学习”的思维模型，尤其是在学习 PM 技能方面。

---

### [01:06:41] Lenny

**English:**
I imagine there's also this one step forward, two step back experience that often happens, too, where you're just like, "Oh, I thought I figured out how to think about strategy, and this one failed." And you're like, "Oh, that was useless." No, this is how you learn. You fail sometimes. Oftentimes, it works out slowly but surely you move forward.

**中文翻译:**
我想通常也会有这种“进一退二”的经历，你会觉得：“噢，我以为我已经搞懂怎么思考策略了，结果这次失败了。” 然后你会想：“噢，那没用。” 不，这就是学习的过程。你有时会失败。通常情况下，虽然缓慢但确实是在稳步前进。

---

### [01:06:57] Jules Walter

**English:**
Yeah, totally.

**中文翻译:**
是的，完全正确。

---

### [01:06:58] Lenny

**English:**
Amazing. Well, with that, we have reached our very exciting lightning round. Since we've gone a little long, I'm going to keep it just four questions. I'm just going to go through them pretty fast, whatever comes to mind. Fire off. You ready?

**中文翻译:**
太棒了。那么，我们进入了非常令人兴奋的闪电轮。因为时间有点长了，我只准备了四个问题。我会很快地过一遍，想到什么就说什么。准备好了吗？

---

### [01:07:10] Jules Walter

**English:**
Yeah.

**中文翻译:**
准备好了。

---

### [01:07:10] Lenny

**English:**
What are two or three books that you've recommended most to other people?

**中文翻译:**
你向别人推荐最多的两三本书是什么？

---

### [01:07:15] Jules Walter

**English:**
One of them is Never Split the Difference by Chris Voss. It's about negotiations. There's actually also a masterclass on it.

**中文翻译:**
其中一本是 Chris Voss 的《掌控谈话》（Never Split the Difference）。它是关于谈判的，实际上还有一个相关的 Masterclass 课程。

---

### [01:07:21] Lenny

**English:**
I was just going to say that. I watched that. That was really good.

**中文翻译:**
我正想说这个。我看过那个课程，非常棒。

---

### [01:07:24] Jules Walter

**English:**
Yeah. Yeah. And then another one is Connect by Carole Robin. It's inspired by Stanford's Touchy-Feely class, if you've ever heard of it.

**中文翻译:**
是的。另一本是 Carole Robin 的《人际关系》（Connect）。它的灵感来自斯坦福大学著名的“人际互动”（Touchy-Feely）课程，如果你听说过的话。

---

### [01:07:33] Lenny

**English:**
Yeah. She did a guest post for the newsletter, actually.

**中文翻译:**
是的。实际上她为我的通讯写过一篇客座文章。

---

### [01:07:35] Jules Walter

**English:**
Oh, really? Awesome. Yeah. It's really a helpful especially as you are thinking about the EQ skills and how to improve your relationships with people.

**中文翻译:**
噢，真的吗？太棒了。是的，这本书非常有帮助，尤其是当你思考 EQ 技能以及如何改善人际关系时。

---

### [01:07:44] Lenny

**English:**
Awesome. I highly recommend that book. I haven't read it, but I read a lot of things about the class and my friends have been in that class and she wrote this guest post. That sounds like a really good pick for EQ, so I'm actually going to re-pick it up. Next question: favorite other podcast that isn't this podcast.

**中文翻译:**
太棒了。我强烈推荐那本书。我还没读过，但我读过很多关于那个课程的资料，我的朋友也参加过那个课程，她还写了那篇客座文章。这听起来是 EQ 方面的绝佳选择，我打算重新读一下。下一个问题：除了这个播客，你最喜欢的其他播客是什么？

---

### [01:08:02] Jules Walter

**English:**
Lex Fridman is one I'll call out. Brings really interesting speakers and also on diverse topics, so I find it really helpful.

**中文翻译:**
我想推荐 Lex Fridman 的播客。他邀请的嘉宾非常有趣，话题也非常多样，我觉得非常有帮助。

---

### [01:08:11] Lenny

**English:**
Awesome. I also love that podcast. Favorite recent movie or TV show?

**中文翻译:**
太棒了。我也喜欢那个播客。最近最喜欢的电影或电视剧？

---

### [01:08:15] Jules Walter

**English:**
I watch fewer now. Top Gun: Maverick is a movie I really like. I'm sure many people have seen it. For me, it's like just going back in the 80s. And then TV show is Never Have I Ever. It's coming of age in America, Indian teenager. Pretty funny and also deep.

**中文翻译:**
我现在看电视比较少了。《壮志凌云 2：独行侠》（Top Gun: Maverick）是我非常喜欢的一部电影。我相信很多人都看过。对我来说，它就像带我回到了 80 年代。电视剧是《好想做一次》（Never Have I Ever）。讲的是一个印度裔美国青少年的成长故事。非常有趣，也很有深度。

---

### [01:08:34] Lenny

**English:**
Awesome. I haven't heard of that one. We'll check it out. Final question: favorite interview question that you like to ask folks when you're interviewing them?

**中文翻译:**
太棒了。我还没听说过那部剧，我会去看看。最后一个问题：你在面试别人时最喜欢问的问题是什么？

---

### [01:08:41] Jules Walter

**English:**
One I used to ask a lot is: what's something work related that you're trying to get better at? Sometimes I change the wording of it, but a big part of it is trying to understand how self-aware people are, to which extent they have a growth mindset, and then also how honest and vulnerable they can be. What I will say, though, about interview question, by the way, is I don't anchor a lot on the first question. What I find the most value from are the follow-ups. Once you ask that question, you can take in various directions like, "Why did you focus on this versus other things? How did this come to your attention? Was it feedback you sought or feedback people gave you, et cetera?" Yeah.

**中文翻译:**
我以前经常问的一个问题是：在工作方面，你正在努力提升的是什么？有时我会改变措辞，但很大程度上是为了了解一个人的自我意识有多强，他们在多大程度上拥有增长心态，以及他们能有多诚实和坦诚。顺便说一下，关于面试问题，我不会过多纠结于第一个问题。我发现最有价值的是后续追问。一旦你问了那个问题，你可以引向不同的方向，比如：“你为什么关注这个而不是其他事情？你是如何注意到这一点的？是你主动寻求的反馈，还是别人给你的反馈，等等？” 是的。

---

### [01:09:24] Lenny

**English:**
Awesome advice. Jules, this interview was a longtime coming. It was everything I hoped it would be and more. Thank you again so much for being here. Two final questions: where can folks find you online if they want to reach out and learn more, and how can listeners be useful to you?

**中文翻译:**
极好的建议。Jules，这次采访期待已久。它完全符合我的预期，甚至超出了预期。再次非常感谢你的到来。最后两个问题：如果大家想联系你或了解更多信息，可以在哪里找到你？以及听众可以为你做些什么？

---

### [01:09:39] Jules Walter

**English:**
In terms of finding me, Twitter is one place to start. My handle is @julesdwalt. And then in terms of how people can be useful, it's really about paying it forward and then sharing this with others, especially parts that people find useful.

**中文翻译:**
关于找到我，Twitter 是一个开始的地方。我的账号是 @julesdwalt。至于人们可以如何帮到我，其实就是把这份善意传递下去（Pay it forward），然后把这些内容分享给其他人，特别是那些人们觉得有用的部分。

---

### [01:09:55] Lenny

**English:**
Amazing. Jules, thank you so much. We'll chat again soon.

**中文翻译:**
太棒了。Jules，非常感谢。我们很快会再聊。

---

### [01:10:00] Jules Walter

**English:**
Yeah, thanks for having me.

**中文翻译:**
好的，谢谢你邀请我。

---

### [01:10:03] Lenny

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcast, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
非常感谢大家的收听。如果你觉得这些内容有价值，可以在 Apple Podcast、Spotify 或你喜欢的播客应用上订阅本节目。此外，请考虑给我们评分或留下评论，这能真正帮助其他听众找到这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目再见。