# Julia Schottenstein - 双语对照

# Lenny's Podcast: Julia Schottenstein (dbt Labs) - Full Bilingual Transcript

---

### (00:00:00) Julia Schottenstein

**English:**
M&A is always about creating plan Bs. And the way I would think about it is for any one company, there's only ever two to three buyers that find what you're building to be extremely strategic. And the strategy that I would do in how do you get noticed is I would figure out the area that you bring a competitive advantage. And I would inflict pain on that potential buyer. Make it impossible for them to not notice you because that's when they're going to have their ears perk up and say, "Well, what's going on with this company?"

**中文翻译:**
并购（M&A）的核心始终是创建备选方案（Plan B）。我的看法是，对于任何一家公司来说，通常只有两到三家买家会觉得你所构建的东西具有极高的战略价值。至于如何引起注意，我的策略是：找出你具备竞争优势的领域，然后向那个潜在买家“施加压力”（inflict pain）。要做到让他们无法忽视你，因为只有在那时，他们才会竖起耳朵关注并心想：“这家公司到底是怎么回事？”

---

### (00:00:33) Julia Schottenstein

**English:**
The really important piece here is you want to do that in a way that's still friendly and open. I see a lot of founders get this wrong and they prematurely will shut down a conversation or they won't talk to an incumbent or a potential future buyer because they take too competitive of a stance. But that's a mistake because M&A is all about creating plan Bs and you don't want to shut that door down prematurely because you don't know if you can really go the distance and be an independent company. So you want to have optionality.

**中文翻译:**
这里非常重要的一点是，你需要以一种友好且开放的方式去做这件事。我看到很多创始人在这方面犯错，他们会过早地终止对话，或者因为立场过于对立而不愿与现有的巨头或潜在的未来买家交谈。但这是一个错误，因为并购的本质是创造备选方案，你不想过早地关上那扇门，因为你不知道自己是否真的能走到底并成为一家独立的公司。所以，你需要保持选择权（optionality）。

---

### (00:01:04) Lenny

**English:**
Welcome to Lenny's Podcast, where I interview world-class product leaders and growth experts to learn from their hard-won experiences building and growing today's most successful products. Today my guest is Julia Schottenstein. Julia is a product leader at dbt Labs where she leads the dbt Cloud product. She's also the co-host of the dbt Labs podcast called Analytics Engineering Podcast, a show about data trends that impact analytics engineers' work. As you'll hear in this episode, Julia actually led the acquisition of a startup that I'm an investor in called Transform from the side of dbt Labs.

**中文翻译:**
欢迎来到 Lenny 的播客。在这里，我会采访世界级的跨国产品负责人和增长专家，学习他们在构建和发展当今最成功产品过程中积累的宝贵经验。今天的嘉宾是 Julia Schottenstein。Julia 是 dbt Labs 的产品负责人，负责 dbt Cloud 产品。她还是 dbt Labs 播客《Analytics Engineering Podcast》的联合主持人，这是一档关于影响分析工程师工作的业务趋势的节目。正如你在本集节目中听到的，Julia 实际上代表 dbt Labs 主导了对一家名为 Transform 的初创公司的收购，而我恰好是那家公司的投资者。

---

### (00:01:37) Lenny

**English:**
And in our conversation, we dig into the M&A process and get into a bunch of advice for how to improve your odds of having a good outcome and just approaching M&A broadly. We also dig into the story of dbt, which is one of the most successful startups out there that you probably don't know about. And we talked about what they did right to get to where they are now. We also cover how to best think about competition, a bunch of frameworks for thinking about product and advice on how to approach pricing and also open source. Enjoy this episode with Julia Schottenstein after a short word from our sponsors.

**中文翻译:**
在我们的对话中，我们深入探讨了并购流程，并就如何提高获得良好结果的几率以及如何从宏观角度看待并购提供了一系列建议。我们还挖掘了 dbt 的故事，它是目前最成功的初创公司之一，但你可能还没听说过。我们讨论了他们为了达到今天的成就做对了什么。我们还涵盖了如何最好地思考竞争、一系列关于产品的思考框架，以及关于定价和开源策略的建议。在听完赞助商的简短介绍后，请欣赏与 Julia Schottenstein 的这一集。

---

### (00:02:11) Lenny (Sponsor Ad: Vanta)

**English:**
This episode is brought to you by Vanta, helping you streamline your security compliance to accelerate your growth. Thousands of fast-growing companies like Gusto, Calm, Quora and Modern Treasury trust Vanta to help build, scale, manage, and demonstrate their security and compliance programs and get ready for audits in weeks, not months. By offering the most in-demand security and privacy frameworks such as SOC 2, ISO 27001, GDPR, HIPAA, and many more. Vanta helps companies obtain the reports they need to accelerate growth, build efficient compliance processes, mitigate risks to their businesses, and build trust with external stakeholders. Over 5,000 best-scoring companies use Vanta to automate up to 90% of the work involved with SOC 2 and these other frameworks. For a limited time Lenny's podcast listeners get $1,000 off Vanta. Go to vanta.com/lenny, to learn more and to claim your discounts. Get started today.

**中文翻译:**
本集节目由 Vanta 为您带来，Vanta 帮助您简化安全合规流程，加速业务增长。数千家快速成长的公司（如 Gusto、Calm、Quora 和 Modern Treasury）信任 Vanta，帮助他们构建、扩展、管理和展示其安全合规计划，并在几周而非几个月内为审计做好准备。通过提供最受青睐的安全和隐私框架（如 SOC 2、ISO 27001、GDPR、HIPAA 等），Vanta 帮助公司获得加速增长所需的报告，建立高效的合规流程，降低业务风险，并与外部利益相关者建立信任。超过 5,000 家优秀公司使用 Vanta 自动化处理 SOC 2 及其他框架中高达 90% 的工作。在限定时间内，Lenny 播客的听众可享受 Vanta 1,000 美元的优惠。访问 vanta.com/lenny 了解更多信息并领取折扣。今天就开始吧。

---

### (00:03:10) Lenny (Sponsor Ad: Superhuman)

**English:**
This episode is brought to you by Superhuman. How much time do you spend in email each day? How about your team? You may not realize this, but your email tools are wasting your time. Superhuman is blazingly fast email for high-performing teams built to work with Gmail and Outlook. Teams who use Superhuman spend half the time in their inboxes, respond to twice the number of emails and save over four hours a week. That's over a month of saved time per year. With Superhuman, you can split your inbox into streams for VIPs, team members and emails from your favorite products to reduce context switching. And make sure you never miss an important email.

**中文翻译:**
本集节目由 Superhuman 为您带来。你每天花多少时间处理邮件？你的团队呢？你可能没有意识到，你的邮件工具正在浪费你的时间。Superhuman 是专为高效团队打造的极速邮件工具，支持 Gmail 和 Outlook。使用 Superhuman 的团队在收件箱上花费的时间减少了一半，回复邮件的数量增加了一倍，每周节省超过四个小时。这相当于每年节省了一个多月的时间。通过 Superhuman，你可以将收件箱拆分为 VIP、团队成员和来自你喜爱产品的邮件流，从而减少上下文切换，并确保你绝不会错过重要邮件。

---

### (00:03:48) Lenny (Sponsor Ad: Superhuman continued)

**English:**
You can start reminders if you don't hear back so that you can follow up and never drop the ball on an email thread. You can also work faster than ever before with powerful AI features like writing, editing, summarizing and even translating. Join the ranks of the most productive teams and unleash the power of Superhuman. Try one month free at superhuman.com/lenny. That's superhuman.com/lenny.

**中文翻译:**
如果你没有收到回复，可以设置提醒以便跟进，永远不会在邮件往来中掉链子。你还可以利用强大的 AI 功能（如写作、编辑、总结甚至翻译）以前所未有的速度工作。加入最高效团队的行列，释放 Superhuman 的力量。在 superhuman.com/lenny 免费试用一个月。地址是 superhuman.com/lenny。

---

### (00:04:15) Lenny

**English:**
Julia, welcome to the podcast.

**中文翻译:**
Julia，欢迎来到播客。

---

### (00:04:17) Julia Schottenstein

**English:**
Super excited to be here.

**中文翻译:**
非常兴奋能来到这里。

---

### (00:04:19) Lenny

**English:**
So you have a really interesting career path in that you went from VC into product management. Usually it's the other way around. Usually PMs become VCs and it's rare to see this version of it. So I wanted to start with just a question of just how did that come to be?

**中文翻译:**
你的职业路径非常有趣，你是从风险投资（VC）转行做产品管理（PM）的。通常情况正好相反，一般是 PM 变成 VC，这种版本确实少见。所以我想先问一下，这是怎么发生的？

---

### (00:04:34) Julia Schottenstein

**English:**
I do have an unusual background, but it doesn't surprise me that people who are interested in product are also interested in investing and vice versa. For me, I've always had three interests broadly and that's an interest in business, an interest in technology and an interest in markets. And I get to express those interests both in investing and in product, but just with different weights. So in product you go a lot deeper on the tech and markets is less of a focus, but you still get to do all three. So I have a unusual background and I used to be a professional investor at NEA. Spent all my time investing in early stage startups that built for technical audiences. So think dev tools, infra data companies.

**中文翻译:**
我的背景确实比较特殊，但对于那些对产品感兴趣的人同时也对投资感兴趣，我并不感到意外，反之亦然。对我来说，我一直有三个广泛的兴趣点：商业、技术和市场。无论是在投资还是在产品领域，我都能表达这些兴趣，只是权重不同。在产品领域，你会更深入地研究技术，而市场关注度相对较低，但你仍然能兼顾这三者。我曾是 NEA 的职业投资者，大部分时间都在投资面向技术受众的早期初创公司，比如开发工具、基础设施和数据公司。

---

### (00:05:22) Julia Schottenstein

**English:**
And in 2019 I first discovered dbt, which was an open source data transformation framework. And I got really very, very excited about dbt because when I talked to people that were using it, the way that they described their experience on dbt was like unlike anything I had heard before. It was much more of an identity for them than just a tool that they were using to get their job done. And that really struck me. And as I thought about what was happening in the market, there was a lot going on in 2019. The markets were changing quite a bit. Cloud data warehouses were starting to explode. This was the year where Snowflake went from a 4 billion company to a 12 billion company. And I thought to myself, if dbt worked, it could work in a really extraordinary way. And I naturally tried to spend all my time getting close to Tristan, who's the CEO and founder and I wanted to invest.

**中文翻译:**
2019 年，我第一次发现了 dbt，它是一个开源的数据转换框架。我对 dbt 感到非常兴奋，因为当我与使用者交谈时，他们描述 dbt 体验的方式与我以前听到的完全不同。对他们来说，这不仅仅是一个完成工作的工具，更像是一种身份认同。这深深触动了我。当时我也在思考市场动态，2019 年发生了很多变化。云数据仓库开始爆发，那一年 Snowflake 的估值从 40 亿美元飙升至 120 亿美元。我心想，如果 dbt 能成功，它将以一种非凡的方式取得成功。于是我自然而然地花了很多时间试图接近 CEO 兼创始人 Tristan，想要进行投资。

---

### (00:06:24) Lenny

**English:**
Okay. So at this point you're a spec at NEA, you're trying to invest in dbt and okay, keep going.

**中文翻译:**
明白。所以当时你是 NEA 的投资人，正试图投资 dbt，好，请继续。

---

### (00:06:29) Julia Schottenstein

**English:**
Yeah. So I was very, very excited. I thought if this worked, it could work in a really extraordinary way and I spent all my time trying to get Tristan to like me so that I could invest in the company. And then in 2020, I finally got the call that I was waiting for. Tristan said, "We're going to raise some money." He had a term sheet from a firm that he liked. It was a good venture fund, but he also liked me and he wanted to give me a shot and I was super excited to get that message because this is my chance. And unfortunately I ended up losing that deal to Sequoia. It's a formidable partner.

**中文翻译:**
是的，我当时非常兴奋。我觉得如果这行得通，那将是惊人的成功。我花了很多精力让 Tristan 认可我，以便我能投资这家公司。到了 2020 年，我终于接到了期待已久的电话。Tristan 说：“我们要融资了。”他已经拿到了一家他喜欢的公司的条款清单（term sheet），那是一家不错的风投基金，但他也很看好我，想给我一个机会。收到这个消息我超级兴奋，因为这是我的机会。但不幸的是，我最终在那个交易中输给了红杉资本（Sequoia）。那是一个非常强大的对手。

---

### (00:07:04) Lenny

**English:**
Reasonable loss.

**中文翻译:**
输给红杉不丢人。

---

### (00:07:05) Julia Schottenstein

**English:**
I was just so convicted that it was going to be a special company that I asked to even put my personal money in and I asked to put a very irresponsible, irrational amount, nearly like 20% of my liquid net worth into dbt because I was so convinced that this was special. And sometimes when deals don't work out as an investor, you can create this narrative in your head like, "Good, I dodged a bullet or better off without them or screw them." But for me that was quite the opposite with dbt. I really felt like dbt was this runaway train and it was special and I wanted to jump on board. So a few months later I ended up calling Tristan and asked him if I could be a part of the company that built the product that I thought was so special. So that was my unique path into product and to dbt.

**中文翻译:**
我当时坚信这会是一家特别的公司，甚至请求投入我个人的钱。我当时想投一笔非常“不负责任”、不理智的金额，几乎占我流动净资产的 20%，因为我太确信它的特殊性了。作为投资者，当交易没谈成时，有时你会自我安慰说：“太好了，我躲过了一劫”或者“没他们更好”。但对于 dbt，我的感觉完全相反。我真的觉得 dbt 就像一列飞驰的列车，它是如此特别，我想上车。所以几个月后，我打电话给 Tristan，问我是否能加入这家公司，一起构建这个我认为如此特别的产品。这就是我进入产品领域和加入 dbt 的独特路径。

---

### (00:08:02) Lenny

**English:**
So you invested in dbt and then an opportunity opened up where you ended up working there?

**中文翻译:**
所以你投资了 dbt，然后出现了一个机会，你最终去那里工作了？

---

### (00:08:08) Julia Schottenstein

**English:**
No, I think if I was able to invest I wouldn't be here. So I got no, the board ended up vetoing my personal investment, but it's okay because I ended up dedicating all of my personal time to building the company.

**中文翻译:**
不，我想如果我当时能投进去，我现在可能就不会在这里工作了。董事会最终否决了我的个人投资，但没关系，因为我最终把所有的个人时间都奉献给了这家公司的建设。

---

### (00:08:23) Lenny

**English:**
Awesome. Okay. So something you touched on there that was really interesting of what you saw about dbt that was so interesting and I think this is maybe a broader question of just in your time investing and finding a company like dbt early, what have you learned about just picking well, finding companies early especially? What are signs in your experience of just that this is going to be something really interesting that you might want to join? And this is more for people listening that are thinking about joining a company early on. What do you think they should look for?

**中文翻译:**
太棒了。你刚才提到的关于 dbt 的特质非常有趣。我想问一个更广泛的问题：在你做投资以及早期发现 dbt 这样的公司的过程中，关于如何“选得准”，特别是早期发现公司，你学到了什么？根据你的经验，有哪些迹象表明某件事会非常有趣，值得加入？这主要是针对那些考虑加入早期公司的听众，你认为他们应该寻找什么？

---

### (00:08:52) Julia Schottenstein

**English:**
So the way I would look at joining an early stage company would be the same way I would evaluate investing in one. So there are four things that I care about when I'm looking at really early stage companies and it's people, market, product and distribution. And I'll touch on each of those four to say a little bit more about what specifically I'm looking at. So people, this is really the CEO, the founder of the company put simply do you trust this person to lead. And for me, Tristan had this really rare ability to paint a very compelling future of the industry and how dbt was going to be a part of making that vision a reality. But he also was really, really detailed in the day-to-day work of the analytics engineering work. And it was that range in scale that made me feel like this is a founder that's very rare and compelling.

**中文翻译:**
我看待加入早期公司的方式与评估投资一家公司的方式是一样的。在观察极早期公司时，我关注四个方面：人、市场、产品和分发（distribution）。我来详细说说这四个方面。首先是“人”，这主要是指 CEO 和创始人，简单来说就是：你信任这个人的领导力吗？对我来说，Tristan 拥有一种罕见的能力，他能描绘出行业非常引人入胜的未来，以及 dbt 将如何成为实现这一愿景的一部分。但同时，他对分析工程的日常工作细节也非常了解。正是这种跨度极大的视野和执行力，让我觉得这是一个非常罕见且有魅力的创始人。

---

### (00:09:42) Julia Schottenstein

**English:**
The next is markets. We touched on it a little bit, but what I'm looking for in markets it's like is it growing? Is there space for new entrant to make its mark? And when it came to dbt, it was an explosive time in cloud data warehouses and it was that chaos that was really the opportunity for dbt because they created some orderliness and structure to the way that people worked with their data in the cloud data warehouse. So that was very compelling. The next is product. Everyone who's listening hopefully either is interested in products or has a product background. So I won't say too much there, but can you talk to users or potential customers, are they building something that's really special, unique? Can you hear that, spark that enthusiasm and figure out if this is going to be special.

**中文翻译:**
接下来是“市场”。我们刚才提到了一点，我在市场中寻找的是：它在增长吗？是否有新进入者立足的空间？对于 dbt 来说，当时正是云数据仓库爆发的时期，正是那种“混乱”为 dbt 创造了机会，因为他们为人们在云数据仓库中处理数据的方式带来了一定的秩序和结构。这非常有吸引力。再者是“产品”。听众们应该都对产品感兴趣或有相关背景，我就不多说了，但关键在于：你能否与用户或潜在客户交谈，看看他们是否在构建一些真正特别、独特的东西？你是否能感受到那种火花和热情，并判断这是否会成为特别的存在。

---

### (00:10:31) Julia Schottenstein

**English:**
And then the last, I think this is more important arguably than if they have a good product but is distribution, do they have an advantage on how are they going to get to market because that's really, really hard? And think about how they think about their competitive advantage on either the ecosystem or distribution and how they're going to ultimately sell the product. You're not going to get a 10 out of 10 on all four dimensions. So when you're joining a company, you also have the benefit of dedicating your time. So try to think if they're weaker on one dimension, what is it that you bring to the table or what are you special at that could potentially de-risk the success of the company.

**中文翻译:**
最后一点，我认为甚至比拥有好产品更重要的是“分发”。他们在进入市场方面是否有优势？因为这真的非常难。思考一下他们如何看待自己在生态系统或分发渠道上的竞争优势，以及他们最终将如何销售产品。你不可能在所有四个维度上都拿到 10 分。所以当你加入一家公司时，你的优势在于你可以投入时间。试着思考，如果他们在某个维度上较弱，你能带来什么，或者你的特长是什么，从而可能降低公司成功的风险。

---

### (00:11:11) Lenny

**English:**
In terms of spark with a product. Right now on product market fit, now how do you know if you have product market fit? And a lot of it often comes down to there's a emotional reaction from someone you're talking to about the product you're building. There's like, "Holy shit, I want this now." Is there anything even more specific you've seen of just what is a sign that this, there's a spark that people are just really enthused? You talked about people made dbt part of their identity. Is there anything else there?

**中文翻译:**
关于产品的“火花”。现在谈到产品市场匹配（PMF），你如何知道自己是否达到了 PMF？很多时候归结为你交谈的人对你正在构建的产品产生的这种情感反应。比如，“天哪，我现在就想要这个。”除了你提到的“人们把 dbt 当作身份认同的一部分”之外，你还见过哪些更具体的迹象，能表明人们真的非常热衷？

---

### (00:11:36) Julia Schottenstein

**English:**
Yeah. It's can they not stop talking about it and that's the chatter about a product, they want to share it with their teammates or to other people at different companies. That just top of mind love and wanting to share what they've found with others is really a great sign that you're onto something. And then that spark will help do a lot of the work on how do you get to market because your evangelists are really your users of people that love what you're building.

**中文翻译:**
是的，就是他们是否“停不下来地谈论它”。这种关于产品的议论，他们想把它分享给队友或其他公司的朋友。这种发自内心的喜爱以及分享欲，是表明你找对方向的绝佳信号。这种火花会极大地帮助你进入市场，因为那些热爱你所构建之物的人，就是你最好的布道者。

---

### (00:12:06) Lenny

**English:**
What about in terms of the distribution bucket? What are some examples of just really important, I don't know, unique or effective distribution strategies or I don't know, unfair advantages you've seen maybe with dbt, maybe other companies? What are some examples of that?

**中文翻译:**
那么在“分发”这一块呢？有没有一些非常重要、独特或有效的分发策略，或者你见过的“不公平竞争优势”？无论是在 dbt 还是其他公司，能举些例子吗？

---

### (00:12:20) Julia Schottenstein

**English:**
So dbt had an ecosystem advantage and they were open source and this helped really dramatically for lots of people to have low barrier friction to just try it out and spread organically. They first got started with very horizontal. People could just get started without ever even talking to sales and think that was a competitive advantage. But not all companies need to be product led. Some companies are enterprise top-down sales. So in those situations think about does the team really know how to land a complex enterprise sale? Do they have a background in that particular space? Do they have a network of connections? Can be different depending on what the company is selling, but you either want to see a company that's really strong at enterprise or really strong at the bottoms up.

**中文翻译:**
dbt 拥有生态系统优势，而且他们是开源的，这极大地降低了门槛，让很多人可以毫无阻碍地尝试并有机地传播。他们最初从非常横向的领域切入，人们甚至不需要和销售交谈就能开始使用，我认为这就是竞争优势。但并非所有公司都需要是产品驱动型（PLG）。有些公司是企业级自上而下的销售模式。在这种情况下，要思考：团队真的知道如何达成复杂的企业级销售吗？他们在该领域有背景吗？有关系网吗？这取决于公司卖的是什么，但你通常希望看到一家公司要么在企业级销售上极强，要么在自下而上的驱动上极强。

---

### (00:13:11) Lenny

**English:**
Okay, cool. So I want to shift a bit to talking about an area that you have a lot of experience in which a lot of people are also really interested in right now, which is M&A. I've invested in a lot of companies and maybe, I don't know, once a month I'm getting an email from a startup I've been investor in. There's just like, we're looking at maybe selling the company, things aren't working out the way we were hoping. And you've been on I think maybe all sides of the table of M&A transactions, including I think you led the acquisition of a company... I was an investor in the dbt acquired that I think is public company called Transform. So my question is just for founders who are currently thinking about M&A meaning acquisition essentially. What's your best advice for them for how to be most successful in M&A outcome for themselves?

**中文翻译:**
好的，太酷了。我想转而谈谈一个你非常有经验、且现在很多人都非常感兴趣的领域：并购（M&A）。我投资了很多公司，大概每个月都会收到我投资的初创公司的邮件，说“我们可能考虑卖掉公司，事情进展不如预期”。你几乎坐过并购谈判桌的所有位置，包括你主导了 dbt 对 Transform 的收购（我曾是 Transform 的投资者）。所以我的问题是，对于目前正在考虑并购（本质上是被收购）的创始人，你对他们如何获得最成功的并购结果有什么最好的建议？

---

### (00:13:57) Julia Schottenstein

**English:**
When it comes to acquisitions, the time to start thinking about an M&A strategy is hopefully when you don't need one. And the best strategy that I could give a founder is to have a really strong offense in building their company. And when founders start their businesses, they don't usually set out to start a company to sell it to another business. They start it to be an enduring independent standalone company. And if you have that path, then you'll have the upper hand in absolutely every single M&A conversation because you have a viable alternative, which is do nothing, stay the course, you don't have to sell. But of course that's not the case for most companies. Most companies don't have a viable path to being an independent company forever. So they have to think about M&A. So M&A is always about creating plan Bs.

**中文翻译:**
谈到收购，开始思考并购策略的最佳时机，最好是你还不需要它的时候。我能给创始人的最好策略是：在公司建设上保持极强的进攻性。创始人创业时，通常不是为了把公司卖给另一家企业，而是为了建立一家持久、独立的百年老店。如果你拥有这条路径，那么在每一场并购对话中你都会占据上风，因为你有一个可行的替代方案：什么都不做，按原计划进行，你不必非卖不可。但当然，大多数公司并非如此。大多数公司没有永远保持独立的路径，所以他们必须考虑并购。因此，并购始终是关于创建备选方案（Plan B）。

---

### (00:14:49) Julia Schottenstein

**English:**
And the way I would think about it is for any one company, there's only ever two to three buyers that find what you're building to be extremely strategic. And the strategy that I would do and how do you get noticed is I would figure out the area that you bring a competitive advantage and I would inflict pain on that potential buyer. Make it impossible for them to not notice you because that's when they're going to have their ears perk up and say, "Well, what's going on with this company?" We just bought this company Transform. They are playing a really good playbook here.

**中文翻译:**
我的想法是，对于任何一家公司，通常只有两到三家买家会觉得你所构建的东西具有极高的战略价值。至于如何引起注意，我的策略是：找出你具备竞争优势的领域，然后向那个潜在买家“施加压力”。要做到让他们无法忽视你，因为只有在那时，他们才会竖起耳朵关注并心想：“这家公司到底是怎么回事？”我们刚刚收购了 Transform 这家公司，他们在这一策略上玩得非常出色。

---

### (00:15:25) Julia Schottenstein

**English:**
And the really important piece here is you want to do that in a way that's still friendly and open. I see a lot of founders get this wrong and they prematurely will shut down a conversation or they won't talk to an incumbent or a potential future buyer because they take too competitive of a stance. But that's a mistake because M&A is all about creating plan Bs and you don't want to shut that door down prematurely because you don't know if you can really go the distance and be an independent company. So you want to have optionality.

**中文翻译:**
这里非常重要的一点是，你需要以一种友好且开放的方式去做这件事。我看到很多创始人在这方面犯错，他们会过早地终止对话，或者因为立场过于对立而不愿与现有的巨头或潜在的未来买家交谈。但这是一个错误，因为并购的本质是创造备选方案，你不想过早地关上那扇门，因为你不知道自己是否真的能走到底并成为一家独立的公司。所以，你需要保持选择权。

---

### (00:15:54) Lenny

**English:**
I love this term with pain on your potential acquirers. What are some examples of that? Who's done that well or what's an example of that interaction?

**中文翻译:**
我喜欢“向潜在收购者施加压力”这个说法。能举些例子吗？谁做得好，或者这种互动的例子是什么样的？

---

### (00:16:03) Julia Schottenstein

**English:**
Yeah. I mean I can share the transform stories of a company we just acquired, we announced it in February. So dbt Labs, we build transformations, that's our main product. And we were venturing into a new product area that we call the semantic layer. And to describe what that is quickly, it's allowing companies to define their business metrics and so that whenever anyone queries it, we always serve back consistent data on those business metrics and transform. They were a pure play company only in this metrics layer, semantic layer. And they had a really strong product.

**中文翻译:**
我可以分享一下我们刚刚收购的 Transform 的故事，我们在二月份宣布了这一消息。dbt Labs 的主打产品是构建数据转换（transformations）。当时我们正进军一个名为“语义层”（semantic layer）的新产品领域。简单解释一下，它允许公司定义其业务指标，这样无论谁查询，我们返回的业务指标数据始终是一致的。Transform 是一家专注于指标层、语义层的纯技术公司，他们的产品非常强大。

---

### (00:16:41) Julia Schottenstein

**English:**
They had figured out some of the technical challenges and they had solved it early on. They had the benefit of having worked at Airbnb, which and Airbnb in the data world is famous for having a really successful semantic layer metrics layer called Minerva. And what we had at dbt Labs is really good distribution and ecosystem, but we were a little behind in bringing a product to market and we felt that pressure from Transform because they were doing such a great job at being vocal and loud about how their semantic layer solves these really hard technical problems.

**中文翻译:**
他们很早就解决了一些技术挑战。他们的优势在于曾在 Airbnb 工作过，而 Airbnb 在数据领域因其非常成功的语义层/指标层 Minerva 而闻名。dbt Labs 的优势在于极佳的分发渠道和生态系统，但在将产品推向市场方面稍显落后。我们感受到了来自 Transform 的压力，因为他们在宣传其语义层如何解决这些艰巨技术问题方面做得非常出色。

---

### (00:17:20) Julia Schottenstein

**English:**
But they didn't have any distribution. So that was really tough for them and they were putting pressure, but they were still positioning their company as a partner to us because they wanted our community to be excited about what they were building and hopefully lure them over to use their product. So because they had positioned themselves as a friendly partner when really we were trying to compete for this similar use case, when it came time to do an acquisition, we were really excited because we knew their product was good and they had already done a lot of the work to make integrating with dbt possible and that helps us post acquisition do the integration much more easily.

**中文翻译:**
但他们没有任何分发渠道，这对他们来说很艰难。他们虽然在施压，但仍将自己定位为我们的合作伙伴，因为他们希望我们的社区对他们构建的东西感到兴奋，并希望能吸引用户使用他们的产品。正因为他们把自己定位为友好的合作伙伴（尽管实际上我们在竞争相似的用例），当到了收购时机时，我们非常兴奋，因为我们知道他们的产品很棒，而且他们已经做了大量工作使与 dbt 的集成成为可能，这有助于我们在收购后更轻松地完成集成。

---

### (00:18:01) Lenny

**English:**
How do you just think about either as a startup or even an incumbent about how to think about competition, how much emphasis, how much energy to put into thinking what competitors are doing and just how that informs your strategy?

**中文翻译:**
无论是作为初创公司还是行业巨头，你如何看待竞争？应该投入多少精力去关注竞争对手在做什么，以及这如何影响你的战略？

---

### (00:18:15) Julia Schottenstein

**English:**
So we recently codified our philosophy when it comes to competition. And I'll give Nick Handel the founder of Transform who led this exercise at dbt Labs. But we really have three pillars when it comes to competition. So the first is hold true to our vision. We're really excited about the path and the journey that we're going on at dbt Labs and we don't want the distraction. So occasionally you'll have competitors maybe throw shade or throw stones, but most of that is just noise. If you have a lot of conviction that you're going in the right journey, you want to just keep your eyes straight ahead and run your best race and not be too distracted by what maybe some critics are saying.

**中文翻译:**
我们最近明确了关于竞争的哲学。我要归功于 Transform 的创始人 Nick Handel，他在 dbt Labs 主导了这项工作。关于竞争，我们有三大支柱。第一是“坚守愿景”。我们对 dbt Labs 正在走的道路非常兴奋，不想被分心。虽然偶尔会有竞争对手“泼脏水”或扔石头，但大部分只是噪音。如果你坚信自己走在正确的道路上，就应该目不斜视，跑好自己的比赛，不要被批评者的言论过度干扰。

---

### (00:19:00) Julia Schottenstein

**English:**
The second philosophy we have is really a grow the pie philosophy. So we want to work with our partners in our ecosystem to make the opportunity set even larger and we see that today. We mostly serve reporting and BI use cases, we're seeing lots of companies start to operationalize their data. Now with this big wave of ML, clean Transform data assets are being used to train machine learning models so that the pie continues to grow. Let's focus on that as our target and work with people to make the opportunity set really attractive and not try to slice it up too thinly.

**中文翻译:**
我们的第二个哲学是“做大蛋糕”。我们希望与生态系统中的合作伙伴合作，让机会集变得更大。今天我们看到了这一点：我们主要服务于报告和商业智能（BI）用例，但现在看到很多公司开始将数据业务化。随着机器学习（ML）的大潮，干净的转换后数据资产正被用于训练模型，蛋糕在持续变大。让我们以此为目标，与他人合作让机会变得更有吸引力，而不是试图把现有的蛋糕切得太薄。

---

### (00:19:37) Julia Schottenstein

**English:**
And then the last one is we want to lean into our strengths. So we have an ambition to be a platform company and we know what we're good at, but we also want to leave space for our ecosystem to offer solutions to our users that help them out. And we really want to foster an ecosystem where we can partner with lots of companies in the modern data stack. And generally speaking, when it comes to competition, we take a really long-term view and there are a few areas that we do want to hold our ground and that's in our transformation standard as well as our semantic standard because we believe those two are better served together for the user's sake. But for everything else, we really feel like we can work with our ecosystem and accomplish what we want to accomplish and also help them accomplish their goals too.

**中文翻译:**
最后一点是“发挥优势”。我们有成为平台公司的雄心，也清楚自己的擅长之处，但我们也想为生态系统留出空间，让他们为用户提供解决方案。我们真心希望培育一个能与现代数据栈（Modern Data Stack）中众多公司合作的生态系统。总的来说，在竞争方面，我们持有长期观点。有几个领域我们确实想坚守阵地，那就是我们的“转换标准”和“语义标准”，因为我们相信为了用户利益，这两者结合在一起效果更好。但对于其他一切，我们觉得可以与生态系统合作，在实现我们目标的同时，也帮助他们实现目标。

---

### (00:20:27) Lenny

**English:**
This might be a good time to just chat about dbt and the success the company has had. So many startups have tried to become a standard default layer of what's now called the modern data stack. And I don't know any startup doesn't use dbt or planning to use dbt. It's just a incredibly rare success story somewhere to snowflake where it's just like it's the default for building large data startups and most startups these days work with a lot of data. So my question is just like what do you think dbt did most right to win in this and continue to win?

**中文翻译:**
现在可能是聊聊 dbt 及其成功的绝佳时机。很多初创公司都试图成为现在所谓的“现代数据栈”的标准默认层。据我所知，几乎没有哪家初创公司不使用 dbt 或不打算使用 dbt。这是一个极其罕见的成功故事，类似于 Snowflake，它已成为构建大型数据初创公司的默认选择，而现在的初创公司大多都要处理大量数据。所以我的问题是，你认为 dbt 做对了什么，从而赢得了市场并保持领先？

---

### (00:21:01) Julia Schottenstein

**English:**
So I think dbt did a lot of things right, but I'll point out too that really stick out to me. And the first is just power and simplicity and the second is a commitment to being open. And I'll touch on what I mean by those two things. So when dbt was first getting started, you would hear a lot from companies, I don't understand, what's so special about dbt? We have a SQL templating tool at our company, we built one in-house. Like this is really straightforward and simple and it's true like dbt is really simple, but that is the power of it.

**中文翻译:**
我认为 dbt 做对了很多事，但我会指出两个最突出的点。第一是“强大与简洁”，第二是“对开放的承诺”。我来解释一下。当 dbt 刚开始时，你会听到很多公司说：“我不明白，dbt 有什么特别的？我们公司也有 SQL 模板工具，是我们内部开发的。这东西非常直观简单。”确实，dbt 非常简单，但这正是它的威力所在。

---

### (00:21:37) Julia Schottenstein

**English:**
So our founders, Tristan, Drew and Connor, they had a belief that the people who do data analysis work, that really work closely with their business stakeholders should also be the ones to contribute to creating clean data assets in production because that data prep work is a necessary prerequisite for any analysis that you do. So dbt was really this belief that if you know SQL, we want to invite you to do these workflows that were traditionally held by data engineers but you had to earn that. So dbt has this nice framework where it's harder to mess up, keeps data quality really high, but it is pretty simple to get started and learn and learn. And that was really the unlock in the industry. We were definitely solving a pain point at the right time.

**中文翻译:**
我们的创始人 Tristan、Drew 和 Connor 坚信，那些做数据分析工作、与业务利益相关者密切合作的人，也应该是那些在生产环境中贡献干净数据资产的人，因为数据准备工作是任何分析的必要前提。dbt 的核心理念是：如果你懂 SQL，我们就邀请你参与这些传统上由数据工程师负责的工作流，但你需要通过工具来规范它。dbt 提供了一个很好的框架，让人很难出错，保持了极高的数据质量，但入门和学习又非常简单。这正是行业的突破口。我们确实在正确的时间解决了一个痛点。

---

### (00:22:26) Julia Schottenstein

**English:**
And the second thing is this commitment to being open. So dbt is open source and that's the main guts of dbt where you write your business logic and it helps in a number of ways. Specifically it helps with flywheel, keep the flywheel running and also with network effects. And I'll explain what that looks like. So dbt is really easy to get started with at your company with reduced friction. We're building a product that people, so they talk about it, they want to share it both at their organization and with other companies. Other companies get started with dbt again with reduced friction.

**中文翻译:**
第二点是对“开放”的承诺。dbt 是开源的，这是 dbt 的核心部分，你在这里编写业务逻辑。开源在很多方面都有帮助，特别是它有助于形成“飞轮效应”并产生网络效应。我来解释一下：dbt 很容易在公司内部启动，摩擦力极小。我们构建的产品让人们愿意谈论它，愿意在组织内部和跨公司分享。其他公司也会因为低门槛而开始使用 dbt。

---

### (00:23:05) Julia Schottenstein

**English:**
We now get to see this really diverse set of use cases for dbt across company sizes, across industries and it allows us to build a truly horizontal company. As our company grows, we get to invest back into our community and our product and the flywheel begins to spin faster. And then meanwhile we have a really large user base. So we have 20,000 companies using dbt every single week and that attracts partners to want to build for dbt and so they share best practices, build workflows, and now if you're a company and you've standardized on dbt, you've really unlocked an integrated modern data ecosystem that wasn't available for you before. So that has a flywheel and also benefits everyone that decides to be on the standard. So it's those two really important trends that made dbt so powerful today.

**中文翻译:**
我们现在看到了 dbt 在不同规模、不同行业的极其多样化的用例，这使我们能够建立一家真正的横向公司。随着公司的成长，我们可以反哺社区和产品，飞轮转得越来越快。同时，我们拥有庞大的用户群——每周有 20,000 家公司使用 dbt，这吸引了合作伙伴为 dbt 构建插件，分享最佳实践，构建工作流。现在，如果一家公司在 dbt 上实现了标准化，你就真正解锁了一个以前无法获得的集成现代数据生态系统。这不仅形成了飞轮，也让每一个选择该标准的人受益。正是这两个重要的趋势成就了今天如此强大的 dbt。

---

### (00:24:02) Lenny

**English:**
So what I'm hearing there is essentially the product was right for what people needed to solve. There's also a product led component, open source, free self-serve piece that people adopted, used and started working and then scaled and started paying for it. And then there's an alignment of the vision of where this was going and how it fit with how people wanted this to work for them. Is there anything else? Because a lot of startups do that and that all sounds really smart and good, but a lot of startups try to do those things and no one cares. Maybe their product isn't necessarily what people are looking for, maybe they don't get the right distribution. I don't know. Is there anything else that you think they did really well that helped them kickstart this to even be a thing? Is it timing that was really great? Is it specific influencers early on?

**中文翻译:**
所以我听到的是，本质上产品切中了人们需要解决的问题。还有一个产品驱动（PLG）的组成部分：开源、免费自服务，人们采用、使用并开始工作，然后扩展并开始付费。此外，愿景与人们期望的工作方式高度契合。还有别的吗？因为很多初创公司也这么做，听起来都很聪明，但很多公司尝试了这些却没人理会。也许他们的产品不是人们想要的，或者分发不对。你觉得还有什么他们做得特别好，帮助启动了这一切？是时机太好了吗？还是早期有特定的影响力人物支持？

---

### (00:24:48) Julia Schottenstein

**English:**
Yeah. I think timing was really important with the success of dbt. That they were there when the cloud data warehouses were really exploding and growing in an enormous way. And dbt Labs started as Fishtown Analytics, a consulting firm. So they worked really, really closely and hands-on with all of their consulting partners to get the pain point and really solve firsthand challenges that they saw. I think that combination of being at the right place at the right time and also getting to work really closely with people's day-to-day problems created a really special experience.

**中文翻译:**
是的，我认为时机对 dbt 的成功至关重要。当云数据仓库真正爆发式增长时，他们正好在那儿。而且 dbt Labs 最初叫 Fishtown Analytics，是一家咨询公司。所以他们与所有的咨询合作伙伴非常紧密地合作，亲自动手解决他们看到的痛点和第一手挑战。我认为这种“在正确的时间出现在正确的地点”，加上与人们日常问题紧密结合的经历，创造了一种非常特殊的体验。

---

### (00:25:29) Lenny

**English:**
I didn't know that. That's a really important element of the story is basically they were focused... How long did they do that Fishtown Analytics consultancy?

**中文翻译:**
我以前不知道这个。这是故事中非常重要的一个元素，基本上他们专注于……他们做 Fishtown Analytics 咨询业务做了多久？

---

### (00:25:38) Julia Schottenstein

**English:**
Board consulting part of the business was almost two years.

**中文翻译:**
咨询业务部分持续了将近两年。

---

### (00:25:42) Lenny

**English:**
Okay. So they basically spent two years solving this problem basically manually for people, and that's such a great way to understand real pain and figure out how to solve it.

**中文翻译:**
明白了。所以他们基本上花了两年时间手动为人们解决这个问题，这是理解真实痛点并找出解决方案的绝佳方式。

---

### (00:25:53) Julia Schottenstein

**English:**
Totally.

**中文翻译:**
完全正确。

---

### (00:25:54) Lenny

**English:**
Awesome. Okay, so that's a really interesting insight. Just spend a few years. It sounds like it was almost manually helping people transform their data using whatever tools already existed.

**中文翻译:**
太棒了，这是一个非常有趣的见解。花几年时间，听起来就像是手动帮助人们使用当时已有的任何工具来转换数据。

---

### (00:26:05) Julia Schottenstein

**English:**
Yeah. Well, they were building dbt and using dbt to help them do their jobs better and supporting their clients. And whenever they encountered paper cuts or friction or the workflow was taking longer than they expected, they would build that into dbt. And that really matured the experience of the product because the people who were building it, the founders were also day-to-day working with these customers or clients that had pain points.

**中文翻译:**
是的。其实他们当时就在构建 dbt，并利用 dbt 帮助自己更好地完成工作并支持客户。每当他们遇到小麻烦、摩擦，或者工作流耗时超出预期时，他们就会把解决方案构建到 dbt 中。这让产品体验变得非常成熟，因为构建产品的人（创始人）每天都在与这些有痛点的客户打交道。

---

### (00:26:36) Lenny

**English:**
That reminds me of a story you told me about how you made your eng team do some manual work of an algorithm involved in transformation. Can you share that?

**中文翻译:**
这让我想起你跟我说过的一个故事，关于你如何让你的工程团队手动模拟转换中涉及的算法。你能分享一下吗？

---

### (00:26:47) Julia Schottenstein

**English:**
Okay. So I'm going to preface this story by sharing that I'm a huge math nerd and one of my favorite books on logic is called Girdle Escher Bach. And in this book there's a fun scene where there's an ant farm that bands together to do the work of a computer flipping bits from zero to one to solve logic gates. So this chapter of that book was really the inspiration for an exercise that I ran my team through. So about a year ago we were doing a big zero to one new project at dbt Labs and we were going to change the algorithm for how we built customers' data transformation graphs. And I needed a way for the team to really internalize all of the changes that we were going to be making and I needed them to own it because otherwise they wouldn't be able to anticipate all of the edge cases and it wouldn't be quite as durable. You couldn't copy paste the algorithm.

**中文翻译:**
好的。在讲这个故事之前，我先声明我是一个超级数学迷，我最喜欢的逻辑学书籍之一是《哥德尔、艾舍尔、巴赫》（GEB）。书中有一个有趣的场景：一个蚁群团结起来像计算机一样工作，通过翻转 0 和 1 来解决逻辑门问题。书中的这一章启发了我对团队进行的一次练习。大约一年前，我们在 dbt Labs 进行一个重大的从 0 到 1 的新项目，我们要更改构建客户数据转换图（graphs）的算法。我需要一种方式让团队真正内化我们将要做的所有更改，并让他们产生主人翁意识，否则他们无法预见所有的边缘情况，算法也不会那么耐用。你不能只是复制粘贴算法。

---

### (00:27:41) Julia Schottenstein

**English:**
So I showed up to a team offsite with a spool of rope and sticky notes and I think my team looked at me crazy, went with two heads when I started to tie people up to create a graph. So each note of the graph was an engineer and the rope was the edges of the graph to connect them. And then we worked through the new algorithm extremely slowly, step by step. And it was a way that you couldn't leave that exercise without knowing exactly what was going on because everyone had a role to play.

**中文翻译:**
于是，我带着一卷绳子和便利贴出现在团队团建现场。当我开始把大家绑在一起创建一张“图”时，我想我的团队一定觉得我疯了。图中的每个节点都是一名工程师，绳子就是连接他们的边。然后我们极其缓慢地、一步一步地演练新算法。通过这种方式，你不可能在不清楚发生了什么的情况下结束练习，因为每个人都有自己的角色。

---

### (00:28:16) Julia Schottenstein

**English:**
So I think a lot of times when you're starting something new, you get into a situation where a few people really understand it and they're running way ahead of the rest of the pack. But I needed a way for the whole team to go along for the journey. So I'm constantly trying to create these important moments or memorable moments for the team so that it's centered around our mission and they can have the ownership of taking the project and making it successful. So it was perhaps a overly creative or kooky way to spend the day, but it was really successful.

**中文翻译:**
我认为很多时候当你开始新事物时，会出现只有少数人真正理解并遥遥领先的情况。但我需要一种方式让整个团队同步前进。所以我一直在努力为团队创造这些重要或难忘的时刻，让一切围绕我们的使命展开，让他们拥有推动项目成功的责任感。这可能是一种过于创意或古怪的度过一天的方式，但它确实非常成功。

---

### (00:28:49) Lenny

**English:**
What was the actual algorithm you were trying to implement?

**中文翻译:**
你当时试图实现的具体算法是什么？

---

### (00:28:53) Julia Schottenstein

**English:**
We were trying to figure out how to make flipping the way that we run people's dags from an imperative way to a declarative way. So instead of running things left to when data arrived in your warehouse. You think about it as reverse, like what would need to happen to make your data SLAs be materialized in time.

**中文翻译:**
我们当时在研究如何将运行 DAG（有向无环图）的方式从“命令式”转变为“声明式”。也就是说，不再是当数据到达仓库时从左到右运行，而是反向思考：为了让你的数据 SLA（服务等级协议）按时实现，需要发生什么。

---

### (00:29:16) Lenny

**English:**
Awesome. And sounds like the team found that valuable.

**中文翻译:**
太棒了。听起来团队觉得很有价值。

---

### (00:29:20) Julia Schottenstein

**English:**
Yeah.

**中文翻译:**
是的。

---

### (00:29:20) Lenny

**English:**
Okay. Reminds me of a clip from this last season of Ted Lasso where they have used red strings and I won't get into it, but if you've seen it you will know what I'm talking about. I want to come back to your chatting about open source versus not open source. So some part of dbt was is open source and some isn't. I'm curious how the team decides what is open source and what should be open source, what isn't open source and what to charge for?

**中文翻译:**
好的。这让我想起《泰德·拉索》（Ted Lasso）最后一季的一个片段，他们也用了红绳，我就不细说了，看过的人都懂。我想回到关于开源与非开源的讨论。dbt 的一部分是开源的，一部分不是。我很好奇团队如何决定什么是开源的，什么应该开源，什么不开源以及对什么收费？

---

### (00:29:50) Julia Schottenstein

**English:**
We think about dbt open source. It's really the guts of the data transformation. It's where you describe your business logic. And then on the cloud side we build proprietary software that supercharges the development life cycle and the productionization of dbt at scale. So what we think about as leaving for our cloud offering is we deal with state, so stateful interactions and also any cross team or structural collaboration. We want to reserve that for our proprietary offering. And I think it's really important to have that distinction of what do you believe should be open source or what is the open standard that really matters? And ecosystem to us is really important. So it's important that that remains open source, but then we want to supercharge that experience with an open core model and build proprietary software that makes people much more successful at using dbt.

**中文翻译:**
我们对 dbt 开源版的定位是：它是数据转换的核心“内脏”，是你描述业务逻辑的地方。而在云端（Cloud），我们构建专有软件，以增强 dbt 的开发生命周期和大规模生产化能力。我们认为应该留在云端产品中的是：处理“状态”（stateful interactions）的功能，以及任何跨团队或结构化的协作功能。我们希望将这些保留在专有产品中。我认为明确“你认为什么是开源的”或“什么是真正重要的开放标准”非常重要。对我们来说，生态系统至关重要，所以保持其开源性很重要，但随后我们希望通过“开放核心”（open core）模式来增强这种体验，构建能让人们更成功使用 dbt 的专有软件。

---

### (00:30:48) Lenny (Sponsor Ad: AssemblyAI)

**English:**
Today's episode is brought to you by AssemblyAI. If you're looking to build AI powered features in your audio and video products, then you need to know about AssemblyAI, which makes it easy to transcribe and understand speech at scale. What I love about AssemblyAI is you can use their simple API to access the latest AI breakthroughs from top tier research labs. Product team that startups and enterprises are using AssemblyAI to automatically transcribe and summarize phone calls and virtual meetings, detect topics in podcasts, pinpoint when sensitive content spoken and lots more. All of AssemblyAI's models which are accessed through their API are production ready.

**中文翻译:**
本集节目由 AssemblyAI 为您带来。如果您正寻求在音频和视频产品中构建 AI 驱动的功能，那么您需要了解 AssemblyAI，它能让大规模转录和理解语音变得轻而易举。我喜欢 AssemblyAI 的一点是，您可以使用他们简单的 API 访问来自顶级研究实验室的最新 AI 突破。初创公司和企业的业务团队正在使用 AssemblyAI 自动转录和总结电话及虚拟会议、检测播客主题、精准定位敏感内容等。所有通过 API 访问的 AssemblyAI 模型都是生产就绪的。

---

### (00:31:26) Lenny (Sponsor Ad: AssemblyAI continued)

**English:**
So many PMs I know are considering or already building with AI and AssemblyAI is the fastest way to build with AI for audio use cases. Now's the time to check out AssemblyAI, which makes it easy to bring the highest accuracy transcription plus valuable insights to your customers. Just like Spotify, CallRail and writer do for theirs. Visit assemblyai.com/lenny to try their API for free and start testing their models with their no code playground. That's assemblyai.com/lenny. I know you also spent a lot of time thinking about pricing and willingness to pay and things along those lines.

**中文翻译:**
我认识的很多 PM 都在考虑或已经在使用 AI 进行构建，而 AssemblyAI 是构建音频 AI 用例最快的方式。现在是了解 AssemblyAI 的最佳时机，它能轻松为您的客户带来最高准确度的转录和宝贵的洞察，就像 Spotify、CallRail 和 Writer 所做的那样。访问 assemblyai.com/lenny 免费试用他们的 API，并在他们的无代码游乐场中测试模型。地址是 assemblyai.com/lenny。我知道你也花了很多时间思考定价、付费意愿之类的事情。

---

### (00:32:03) Lenny

**English:**
Is there anything you could share about which is what you've learned about how to think about pricing for a tool like this or even in general?

**中文翻译:**
关于如何为这类工具甚至一般产品定价，你有什么学到的经验可以分享吗？

---

### (00:32:09) Julia Schottenstein

**English:**
Pricing and willingness to pay is such a hard conversation and lots of startups don't do this early enough in their company journey. Likely a side effect of zero interest rates where investors were happy funding GitHub stars and usage and companies never thought about how am I going to make revenue or make money, which is it's important. So for us at dbt Labs, I don't claim to be perfect at it, but we're trying to get a better muscle around it. And I always think about Madhavan who wrote this book Pricing Innovation. I know you've had him on the show before, but he shares that you don't get to decide if you're going to have a pricing or willingness to pay a conversation. You only get to decide what. So it's much better to have that conversation before you build the product than have it when your sales team's trying to sell something and people aren't excited about what you've built, aren't willing to pay for it.

**中文翻译:**
定价和付费意愿是非常艰难的话题，很多初创公司在创业初期都没有足够早地考虑这件事。这可能是零利率时代的副作用，当时投资者乐于资助 GitHub 的星数和使用量，而公司从未考虑过如何产生收入或赚钱，但这其实很重要。对于 dbt Labs 来说，我不认为我们做得完美，但我们正在努力加强这方面的能力。我经常想到写了《定价创新》（Pricing Innovation）的 Madhavan（我知道你以前请他上过节目），他分享过：你无法决定是否要进行定价或付费意愿的对话，你只能决定对话的内容。所以，在构建产品之前进行这种对话，比在销售团队试图卖东西而人们却不感兴趣、不愿付钱时再谈要好得多。

---

### (00:33:04) Julia Schottenstein

**English:**
And at dbt Labs we have this value, it's one of our core values that says we are more concerned with value creation than value capture. And we really mean this. When we talk about what is the value of dbt Labs to our customers, they often talk about how it's either 20 to 35% as valuable as what they spend on their cloud data warehouse. But what we charge our customers is a very small fraction of that 20 to 35% and that's by design. And last year we did our first ever pricing change in the company history and you learn a tremendous amount when you have that event because you get to test the price elasticity by of your customers.

**中文翻译:**
在 dbt Labs，我们有一个核心价值观：我们更关心“价值创造”而非“价值获取”。我们是认真的。当我们谈论 dbt Labs 对客户的价值时，他们经常说其价值相当于他们在云数据仓库上支出的 20% 到 35%。但我们向客户收取的费用只是这 20%-35% 中的极小一部分，这是有意为之。去年我们进行了公司历史上第一次定价变更，通过这次事件你会学到很多，因为你可以测试客户的价格弹性。

---

### (00:33:49) Julia Schottenstein

**English:**
It's so important to learn that lesson while the company is still smaller or the stakes are lower because pricing just is always evolving. It's not a fixed thing, it gets more complex over time. So we have to think about it quite a bit because my team builds proprietary software for dbt cloud and when we lose a deal we most often lose it to dbt open source and we like it that way. We're happy to lose to ourselves, but we have to really think very deeply about what are people willing to pay for and what moves the needle for them and focus on that.

**中文翻译:**
在公司规模还小、风险较低时学习这一课非常重要，因为定价总是在演变的。它不是一成不变的，随着时间的推移会变得越来越复杂。我们必须深入思考，因为我的团队为 dbt Cloud 构建专有软件，当我们丢掉一笔交易时，通常是输给了 dbt 开源版，我们喜欢这样——我们乐于输给自己。但我们必须深入思考人们愿意为什么付钱，以及什么能真正解决他们的问题，并专注于此。

---

### (00:34:26) Lenny

**English:**
I'm so curious what that pricing process was like to figure out what to change. Is there anything you could share about just what that was for you or what are some just surprises that came out of that process or just like, "Wow, we didn't expect that in these conversations?"

**中文翻译:**
我很想知道那个定价过程是怎样的，如何决定改变什么。你能分享一下那个过程吗？或者在那个过程中有什么让你惊讶的事情，比如“哇，我们没料到对话中会出现这种情况”？

---

### (00:34:42) Julia Schottenstein

**English:**
It's really like an all hands on deck conversation. Pricing is so cross-cutting because it's a finance discussion as well. You're modeling out things in spreadsheets and figuring out how that might impact the business. But you can't just solve these problems in spreadsheets. You have to go talk to customers, test the waters, understand where people's appetites are and sussing that out is really hard. And then of course there's a product piece to it too where you have to affect it and communicate it as well. So it was very cross-cutting. We learned a lot. We track our conversion rates really carefully. We track our turn rates very carefully and I think largely we were happy with the change that we made and we felt like one of the big things that we were trying to solve for was have our pricing catch up to how people valued the tool.

**中文翻译:**
这真的是一次全员参与的对话。定价非常具有跨职能性，因为它也是一个财务讨论。你在电子表格中建模，计算它可能对业务产生的影响。但你不能只在表格里解决问题，你必须去和客户交谈，试探反应，了解人们的胃口，而摸清这一点非常难。当然还有产品部分，你必须实施并传达它。所以这是非常综合的。我们学到了很多，仔细追踪转化率和流失率。总的来说，我们对所做的改变感到满意，我们觉得试图解决的一大问题是让定价赶上人们对该工具的价值认可。

---

### (00:35:40) Lenny

**English:**
How many people did you end up talking to, who was doing these conversations and is there anything really important you learned about how to ask these questions and these sorts of leanness to pay conversations?

**中文翻译:**
你最终和多少人谈过？谁在主导这些对话？关于如何在这种付费意愿对话中提问，你学到了什么重要的东西吗？

---

### (00:35:50) Julia Schottenstein

**English:**
So we talked to dozens. It was combination of product and product marketing, having the conversations and people aren't very willing to share explicitly what they will pay. But there's some tools that we use on relative value. People most think about what is the relative value of dbt in their cloud warehouse. And we also tried to employ some of the tactics that we tried to suss out what do people view as very inexpensive? What's a price point that's very cheap or a no-brainer? What price point is maybe fair or comfortable for them and what would be too expensive? And then we had all the data back to figure out where we landed.

**中文翻译:**
我们谈了几十个人。由产品和产品市场团队共同参与。人们通常不愿意明确说出他们愿意付多少钱。但我们使用了一些关于“相对价值”的工具。人们通常会考虑 dbt 相对于其云仓库的价值。我们也尝试了一些策略来摸底：人们认为什么价格是非常便宜的（不假思索就能买）？什么价格是公平或舒适的？什么价格又太贵了？然后我们汇总所有数据来决定最终定价。

---

### (00:36:34) Lenny

**English:**
I want to come back to M&A for a bit. I had a few more questions there and I moved on from that. So again, you've done a lot of work within the M&A realm. Something that I saw recently, and this connects to the fact that a lot of startups now are looking to get sold. This VC hunter walk, he's a founder of Home Brew Ventures, had this interesting blog post where he basically suggested you should actually think about being public about the fact that you're selling your company. Which is crazy because in the past you never want to come across as too selly. I don't want people to think I'm desperate. And his point is many startups are desperate right now and it's okay to be public about that. And then in theory creates more of a bidding situation where many people know versus keeping it secret and in closed rooms. So my question is just what do you think of that? Do you think that's effective strategy? Is it not?

**中文翻译:**
我想回到并购（M&A）的话题。我还有几个问题。你在并购领域做了很多工作。我最近看到一件事，这与现在很多初创公司寻求出售有关。Home Brew Ventures 的创始人 Hunter Walk 写了一篇有趣的博客，建议你应该公开自己正在寻求出售公司的实情。这听起来很疯狂，因为过去你绝不想表现得太想卖，不想让人觉得你走投无路。但他的观点是，现在很多初创公司确实走投无路，公开这一点也没关系。理论上这能创造更多的竞价机会，因为大家都知道了，而不是关起门来保密。你对此怎么看？你认为这是有效的策略吗？

---

### (00:37:28) Julia Schottenstein

**English:**
I think it's good advice. If you're in a Hail Mary situation where you're looking for a home or you need an exit for your business, it's better to be transparent and cast a wider net. And you're right, in previous times founders tried to be a little bit cute or obfuscate that they were evasive the situation that they were in because they wanted to drum up some competitive interest when there really wasn't any. But unfortunately in today's climate, too many companies are in that spot so it's impossible to hide it. So the better approach is just to be transparent and I see it pretty regularly and there's absolutely no shame in sending a note that says something like, "Hey, we're looking for an exit for our company X, Y, and Z didn't pan out as we expected. We built a really interesting product and we want to keep the team together. We're running a process. Are you interested?" Really just as simple as that.

**中文翻译:**
我认为这是个好建议。如果你处于“孤注一掷”（Hail Mary）的境地，正在为业务寻找归宿或退出路径，那么保持透明并广撒网会更好。你说得对，以前创始人总是试图表现得委婉一些，或者掩饰自己的真实处境，想以此制造竞争性兴趣，哪怕实际上并没有。但在当下的气候下，太多公司处于这种境地，根本藏不住。所以更好的办法就是坦诚。我经常见到这种情况，发一封邮件说：“嘿，我们正在为公司寻求退出，X、Y、Z 的进展不如预期。我们构建了一个非常有趣的产品，希望能保留团队。我们正在进行出售流程，你有兴趣吗？”真的就这么简单。

---

### (00:38:24) Lenny

**English:**
I've seen a lot of companies put together these really detailed decks or even websites of just like, here's the team, here's what we built to be very promotional about it. Is that something you've seen? Is that something you'd recommend?

**中文翻译:**
我看到很多公司准备了非常详细的 PPT 甚至网站，展示团队成员和所构建的产品，非常有宣传性。你见过这种吗？你会推荐这样做吗？

---

### (00:38:35) Julia Schottenstein

**English:**
Yeah. Usually in these situations people are acquiring the teams and so having your data room together, really the most important thing is these are the team members that are going to come along with the acquisition is the biggest motivator for why a buyer would get excited.

**中文翻译:**
是的。通常在这种情况下，买家是为了收购团队。所以整理好你的“数据室”（data room），最重要的一点是展示哪些团队成员会随收购一起加入，这是让买家兴奋的最大动力。

---

### (00:38:52) Lenny

**English:**
You made this point earlier that a lot of the seeds need to be planted early for you to have the best outcome. And this reminded me... So I had a startup local mine that we sold to Airbnb and I met Airbnb initially at a year before we actually started exploring the process at a random party at South by Southwest where I was, I actually have no memory of this party, but the head of product at Airbnb, Joe Zadeh, remembered it and came back to us a year later and just like, "Hey, what are you guys up to? Maybe we could collaborate on some stuff," and that led to an acquisition. So I think that's just wanted to touch a ban on that point of just the power of, the way I thought about it is let a thousand flowers bloom, just like meet everyone. Get the word out that you're around and what you're doing so that in the future when someone has that problem they're like, "That company, maybe we should talk to them."

**中文翻译:**
你之前提到，为了获得最好的结果，很多种子需要尽早播下。这让我想起……我曾有一家初创公司卖给了 Airbnb。我第一次接触 Airbnb 是在正式开始出售流程的一年前，在西南偏南（SXSW）的一个随机派对上。我其实对那个派对完全没印象了，但 Airbnb 的产品负责人 Joe Zadeh 记得。一年后他回来找我们说：“嘿，你们最近在忙什么？也许我们可以合作一些东西。”这最终促成了收购。所以我想强调这一点：让“百花齐放”，去见每一个人。让大家知道你的存在和你正在做的事，这样未来当有人遇到那个问题时，他们会想到：“那家公司，也许我们该找他们谈谈。”

---

### (00:39:37) Julia Schottenstein

**English:**
Yeah, you want to make sure that the buyer knows who you are before the acquisition moment and hopefully that's because you've made an impact and they like what you're building. Maybe you've inflicted some pain on them. But yeah, certainly creating those connections well ahead of an exit event is important.

**中文翻译:**
是的，你要确保买家在收购时刻到来之前就知道你是谁，最好是因为你产生了影响力，他们喜欢你构建的东西。也许你还给他们制造过一些“痛苦”。但无论如何，在退出事件发生前很久就建立这些联系是非常重要的。

---

### (00:39:58) Lenny

**English:**
And specifically there it's meet people at your competitors potentially. For us, Airbnb was never even a potential company we would sell to because it had nothing to do with it but ended up making sense down the road. What's like the realm of the companies and people that you think people should think about meeting?

**中文翻译:**
具体来说，可能是去见竞争对手公司的人。对我们来说，Airbnb 甚至从未在我们的潜在买家名单上，因为业务完全不相关，但后来却变得合情合理。你认为人们应该考虑去见哪些范围内的公司和人？

---

### (00:40:12) Julia Schottenstein

**English:**
If the company is buying a lot or they're active, they often have corp dev (corporate development) teams and so use that corp dev team to your advantage. It's their job to meet absolutely every company that could be potentially interested. So take that meeting, say you're not interested in an acquisition just yet, but push them to make an introduction to someone that could sponsor the deal. So usually that's someone in product or maybe a GM and use that as a starting point for maybe just a conversation, maybe something more like a partnership but get the corp dev team to work for you.

**中文翻译:**
如果一家公司经常收购或者非常活跃，他们通常会有企业发展（Corp Dev）团队。利用好这个团队。他们的工作就是去见每一家可能有兴趣的公司。所以去参加那个会议，告诉他们你目前对被收购还没兴趣，但推动他们把你介绍给可能支持这笔交易的人，通常是产品部门的人或总经理（GM）。以此为起点，先进行对话，或者开展类似合作伙伴关系的活动，让对方的企业发展团队为你服务。

---

### (00:40:50) Lenny

**English:**
What if you're at the other end of the spectrum and you're in dire straits right now and you're just like, "Man, what do we do to potentially sell this company?" I know odds are not going to be great, but just what do you suggest folks do in terms of I guess finding connections to potential companies that might be acquirers?

**中文翻译:**
如果你处于光谱的另一端，现在处境艰难，心想：“天哪，我们该怎么做才能把公司卖掉？”我知道几率可能不大，但你建议大家在寻找潜在收购公司的联系方面该怎么做？

---

### (00:41:07) Julia Schottenstein

**English:**
Yeah. I mean use your network. Usually your venture capitalist has a really big network and one of the things that I hear founders feeling the most nervous about is a duty to return the money to the investors. And maybe this is a unpopular thing to say on a podcast, but your investors understand that they're not making their money back. And what they want to do instead is have you end up at a really great company like an Airbnb because that will help them down the road. So it's all about the long game, but use your investors to help you find connections at different companies that could be buying and don't worry so much about disappointing them or being really realistic about where you are in your company journey.

**中文翻译:**
利用你的关系网。通常你的风投（VC）拥有庞大的网络。我听到创始人最担心的事之一就是“有义务把钱还给投资者”。虽然这在播客上说可能不太讨喜，但你的投资者明白他们可能拿不回钱了。相反，他们希望你最终能去一家像 Airbnb 这样伟大的公司，因为这在长远来看对他们有好处。所以这是一个长期博弈。利用你的投资者帮你联系潜在买家，不要太担心让他们失望，要对公司所处的阶段保持现实。

---

### (00:41:55) Lenny

**English:**
To build on that, I'm just an angel investor, I'm not like the lead fund and they feel differently I imagine. But the last thing I want for a founders to get stuck at a company they hate and just so that they could return some money or have some outcome rather they just give up, move on. Life is short.

**中文翻译:**
补充一点，我只是个天使投资人，不是领投基金，我想他们的感受可能不同。但我最不希望看到的是创始人为了还点钱或为了某个结果而困在一家他们讨厌的公司里。我宁愿他们放弃，继续前进。人生苦短。

---

### (00:42:11) Julia Schottenstein

**English:**
Yeah. I think founders forget that it is so risky investing in early stage companies that 50% of portfolios investments don't return anything. And that's just part of the game and it's a very acceptable path where hey, we gave it our best shot. It didn't work out and moving on.

**中文翻译:**
是的。我认为创始人忘记了投资早期公司风险极高，50% 的投资组合可能没有任何回报。这只是游戏规则的一部分。一个非常可以接受的路径是：嘿，我们尽力了，但没成功，然后继续前行。

---

### (00:42:36) Lenny

**English:**
Which is tough a lot of times for founders that are told like it's all about grit and not giving up and don't quit. Sometimes you should quit.

**中文翻译:**
这对创始人来说很难，因为他们一直被告知要坚韧、不放弃、不退出。但有时候，你确实应该退出。

---

### (00:42:43) Julia Schottenstein

**English:**
Gosh, yeah. I don't want to say that. I think being founders, it's an extremely lonely role sometimes and it is very hard to know what your next chapter will look like or what the journey will look like and sometimes you really are out of cash and you do have to find a home. But I hope that you can continue to fight and find a way forward.

**中文翻译:**
天哪，是的。我不想这么说。我觉得做创始人有时是一个极其孤独的角色，很难预见下一章会是什么样。有时你确实没钱了，必须找个归宿。但我希望你能继续战斗，找到前进的道路。

---

### (00:43:08) Lenny

**English:**
Agreed. Specifically for people thinking about selling their company, are there any companies you think are good companies for people to look at right now that are actively acquiring or open to M&A?

**中文翻译:**
同意。具体到那些考虑出售公司的人，你认为现在有哪些公司是值得关注的、正在积极收购或对并购持开放态度的？

---

### (00:43:19) Julia Schottenstein

**English:**
This is a tough one. I think a lot of companies are on the sidelines for a number of reasons. And they could be on the sidelines because they just did an acquisition and they're trying to digest or integrate that company. They could be on the sidelines because they're not growing headcount as much and M&A is often org chart gymnastics of folding the target companies headcount into your budget and plan and maybe just don't have a lot of space. Or probably more common right now is there's just a general uncertainty about the future. And in highly volatile markets people want to take care of their own and even the best M&A deals at a level of complexity that a lot of buyers are just not looking to take on right now.

**中文翻译:**
这是一个难题。我认为很多公司因为各种原因在观望。可能是因为刚完成一笔收购，正在消化或整合；也可能是因为他们没有增加太多员额，而并购往往涉及“组织架构体操”，即将目标公司的员工纳入你的预算和计划，而他们可能没有足够的空间。或者目前更常见的原因是对未来普遍存在不确定性。在高度波动的市场中，人们想先顾好自己，即使是最好的并购交易也会带来一定的复杂性，很多买家现在不想承担这些。

---

### (00:44:07) Julia Schottenstein

**English:**
So there are a number of reasons why people might sit out, but what I would do if I were in a position of wanting to sell my company is I would come up with a buyer set of maybe a dozen and really there aren't more than a dozen companies that will find what you're doing to be a very good fit. Start with your buyer set and then start calling the list by looking at some of the criteria that might count people out. And then go have those conversations. And if you're in a Hail Mary situation, be very transparent about it. Maybe open up the buyer list. But if you still have some room, I would maybe focus on two to three partner or buyers and really play a different playbook, which is inflict pain. Make it really hard for them to not notice you but do it with a smile and be friendly at while you do that.

**中文翻译:**
所以人们观望有很多原因。但如果我处在想卖公司的位置，我会列出一个大约 12 家公司的买家名单，实际上不会有超过 12 家公司会觉得你的业务非常契合。从这个名单开始，根据一些可能排除掉他们的标准进行筛选，然后去进行对话。如果你处于绝境，就保持透明。如果你还有余地，我建议专注于两到三个合作伙伴或买家，玩一套不同的策略：施加压力。让他们很难不注意到你，但在做的过程中要保持微笑和友好。

---

### (00:44:57) Lenny

**English:**
Sometimes with M&A discussions, there's a lot of subtlety to the way you communicate where you don't come out and be like, please we'd love to sell our company to you. Any advice on just the phrasing and how to approach it or do you think it's just, it's fine, just tell us we're looking to sell our company. Are you interested in being buyer?

**中文翻译:**
有时在并购讨论中，沟通方式非常微妙，你不会直接说“请买下我们公司吧”。关于措辞和接触方式你有什么建议吗？还是你觉得直接说“我们想卖公司，你有兴趣买吗”也没问题？

---

### (00:45:15) Julia Schottenstein

**English:**
Yeah. I just wouldn't be too clever here. Everyone understands like I'm evaluating strategic alternatives. It means you're looking to sell your company and it depends. Do you have time? If you have time, yeah. Don't come out and say, "Hey, I'm for sale." That's not going to end up in a good outcome. But depends where you are in your company journey. If you have time, then don't talk about M&A at all. That's the last thing that you want to speak about. Instead, you're talking about maybe collaborating or partnerships. How do we work together? Knowledge sharing and M&A is a dirty word if you have a lot of runway and you're going to try to continue to pursue an independent path, but if you're out of time, you're out of time.

**中文翻译:**
是的，我建议不要太耍小聪明。大家都明白，“评估战略选择”（evaluating strategic alternatives）就意味着你想卖公司。这取决于你是否有时间。如果你有时间，千万别直接说“我要卖”。那不会有好结果。如果你有时间，根本不要提并购，那是你最不想谈的话题。相反，你应该谈论合作或伙伴关系：我们如何一起工作？知识共享。如果你有充足的现金流（runway）并打算继续独立发展，并购是个“脏词”；但如果你没时间了，那就是没时间了。

---

### (00:46:08) Lenny

**English:**
That's such good advice. I remember the term we used was we want to explore a strategic partnership and everyone's just like, I knows what you mean by that, but you just don't want to say it.

**中文翻译:**
真是太好的建议了。我记得我们当时用的词是“我们想探索战略合作伙伴关系”，大家心里都明白那是什么意思，只是不想说破。

---

### (00:46:19) Julia Schottenstein

**English:**
Yeah. It's like everyone in the room's looking like yeah. Okay. Strategic partnership or a strategic alternative, it's like we all know these code words and we understand the situation you're in.

**中文翻译:**
是的，房间里的每个人都会心照不宣地想：“好吧，战略合作伙伴或战略选择，我们都知道这些暗号，也明白你的处境。”

---

### (00:46:31) Lenny

**English:**
Yeah. When do you think M&A market might pick up again? I know it's impossible to predict. Do you have any sense?

**中文翻译:**
你认为并购市场什么时候会再次回暖？我知道这无法预测，但你有什么直觉吗？

---

### (00:46:37) Julia Schottenstein

**English:**
Yeah. I wish I had a magic ball. That'd be pretty sweet. I think what is happening though is we're far enough out from the peak of the markets. So the peak was really November of 2021. And why does that matter? Two things. One, founders are coming to terms with valuations that they maybe received at the highest of the market, are no longer going to hold in this market and companies are out of cash or maybe out of options. We'll be better assets entering the market soon. And at a certain point the opportunities will just be too great. That will incentivize a lot of the buyers that have been on the bench to start participating again in the M&A market. And I don't know exactly when that will be, but I think we're pretty close. I think we're pretty close.

**中文翻译:**
我也希望我有颗水晶球。我认为目前的情况是，我们距离市场巅峰已经够远了（巅峰是在 2021 年 11 月）。为什么这很重要？有两点：第一，创始人开始接受现实，即他们在市场最高点获得的估值在当前市场已不再成立；第二，公司快没钱了，或者没选择了。很快会有更好的资产进入市场。到了一定程度，机会将变得非常诱人，这会激励许多一直在观望的买家重新参与并购市场。我不知道具体是什么时候，但我认为快了。

---

### (00:47:28) Lenny

**English:**
And you mentioned a value that you have at dbt. I forget exactly what it was, but I'm curious what are the other values that you have at dbt, whatever you can share. Always curious what principles and values companies come down to help drive the way they think.

**中文翻译:**
你提到了 dbt 的一个价值观。我不记得具体是什么了，但我很好奇 dbt 还有哪些价值观？我很想知道公司依靠哪些原则和价值观来驱动他们的思维方式。

---

### (00:47:42) Julia Schottenstein

**English:**
The value that I shared is we are more concerned with value creation than value capture and that really drives everything that we do. We try to put a lot of good out into the world and it pays back slowly. The whole mission of dbt Labs is to help analytics engineers disseminate organizational knowledge through data. So we really believe also being participants of sharing that information and getting more people knowledgeable about all sorts of things.

**中文翻译:**
我分享的那个价值观是“我们更关心价值创造而非价值获取”，这驱动着我们所做的一切。我们努力向世界输出好的东西，回报虽然慢，但会到来。dbt Labs 的使命是帮助分析工程师通过数据传播组织知识。所以我们也坚信要参与分享信息，让更多人了解各种事物。

---

### (00:48:13) Julia Schottenstein

**English:**
Transparency wins. We're a really transparent company. We share our board decks. We have lots of communication and participation in all of our Slacks. We're writing culture. We have hard conversations in the open. So that's another a big one. Transparency always wins. We are humble. We don't ever feel like we are successful. We come at this from a very humble space where we feel like we have to serve our community and our users and that really motivates us. And then another one is just work done well as its own end and it's really focusing on the journey and not the end destination.

**中文翻译:**
“透明必胜”。我们是一家非常透明的公司。我们分享董事会报告，在 Slack 中有大量的沟通和参与。我们崇尚写作文化，公开进行艰难的对话。所以这是另一个重点。我们很谦逊，从不觉得自己已经成功了。我们以非常谦卑的态度服务社区和用户，这激励着我们。还有一个是“把工作做好本身就是目的”，专注于过程而非终点。

---

### (00:48:56) Lenny

**English:**
Awesome. I want to do a post someday of just like, here's the values all these different successful companies have come to and see if there's any patterns. I'm actually doing a post right now on Snowflake and on Figma and what you touched on. There's such a connection and a thread of obsessing with your users and making sure they're happy at Figma. I forget exactly what it is, but it's just like in this article, it's going to come out tomorrow actually. So people get a sense of when we recorded this where they think of their company as software as a service where service is their number one goal. They actually provide service and software is just a way to do that. And then it's Snowflake. Their number one core value is put customers first and they talk a lot about how they just actually informs their prioritization all I think, and all their thinking. So it's interesting. That also comes up a lot in what you're talking about, which I think it's easy to say, but I think what actually separates companies that succeed is they actually put this into practice.

**中文翻译:**
太棒了。我想有一天写篇文章，总结这些成功公司的价值观，看看有没有规律。我现在正在写关于 Snowflake 和 Figma 的文章。你提到的那种对用户的痴迷在 Figma 也有体现。Figma 把公司看作“软件即服务”，其中“服务”是第一目标，软件只是提供服务的手段。Snowflake 的头号核心价值观是“客户第一”，这影响了他们所有的优先级排序和思维。这很有趣，你说的也体现了这一点。口头上说很容易，但真正让成功公司脱颖而出的是他们将其付诸实践。

---

### (00:49:51) Julia Schottenstein

**English:**
It's really interesting too because a lot of the people who work at dbt Labs came from the community, so they feel this real ownership in making the experience an excellent one because they were so compelled to come join dbt Labs because the product changed the way that they work or changed their lives. So that commitment to the community and product experience is really, really strong.

**中文翻译:**
这很有趣，因为 dbt Labs 的很多员工都来自社区。他们对创造卓越体验有种真实的主人翁感，因为他们加入 dbt Labs 是因为这个产品改变了他们的工作方式甚至生活。所以对社区和产品体验的承诺非常强烈。

---

### (00:50:14) Lenny

**English:**
This isn't another thread. Maybe we'll go down real quick. I'm working on a different post around Reddit and how to work with really opinionated users that strong opinions about changes to the product and the way they described it, these guys were there for five years working with the community on the product. Is that to your users, the product is their baby, basically. It's like they think it's theirs versus the companies. And I'm curious, having a really strong opinionated community, what it sounds like you also have, what have you learned about just working with them to build product that makes them happy and avoid revolts and really upsetness?

**中文翻译:**
这是另一个话题，我们可以快速聊聊。我正在写一篇关于 Reddit 的文章，探讨如何与那些对产品变更非常有主见的用户打交道。Reddit 的团队在那里工作了五年，与社区一起打磨产品。对用户来说，产品就像他们的孩子，他们觉得产品是属于他们的，而不是公司的。你们也有一个非常有主见的社区，关于如何与他们合作构建产品、让他们满意并避免抵制或不满，你学到了什么？

---

### (00:50:51) Julia Schottenstein

**English:**
It's hard as you grow. I think it's just a challenge cause our community gets bigger. You can't service everybody's needs. But I think what we've done is everyone is very deep in our own product. I think one of the cool stats is at dbt Labs we have over 30% of our employee headcount has contributed to our data transformation workflow. So that's across every discipline. It's in obviously product, obviously in our data team. Our marketing team also contributes to data transformation. And our engineering team will also contribute to our internal dbt analytics project and that sense of really understanding what the experience is like and then soliciting as much feedback as we possibly can. We have a dbt Slack community of 50,000 and all of our employees are in that Slack channel regularly and can feel when we mess up or we don't quite deliver an experience that we're proud of, you will just see dozens of people trying to jump on board and try to make it better.

**中文翻译:**
随着规模扩大，这变得很难。社区越来越大，你无法满足每个人的需求。但我觉得我们做得好的一点是，每个人都深度参与自己的产品。一个很酷的数据是：dbt Labs 超过 30% 的员工都为我们的数据转换工作流贡献过代码。这涵盖了所有职能部门——产品、数据团队，甚至营销团队也会贡献。我们的工程团队也会参与内部的 dbt 分析项目。这种对体验的深刻理解，加上尽可能多地征求反馈，非常关键。我们有一个 5 万人的 Slack 社区，所有员工都在里面。当我们搞砸了或者没能提供令自己自豪的体验时，你会看到几十个员工立刻跳出来试图解决问题。

---

### (00:52:02) Lenny

**English:**
Is there any other frameworks or just general processes that you found to be release useful in building awesome product running teams?

**中文翻译:**
在构建出色产品和管理团队方面，还有其他你觉得非常有用的框架或通用流程吗？

---

### (00:52:10) Julia Schottenstein

**English:**
I'm not a big framework person, but there's two sayings that I find myself repeating or I either to myself or to others. And it's worse is better and tech debt is a champagne problem. And what do I mean by that? It's really to help me combat this perfectionism because perfect doesn't exist and you should instead go with good enough because when you ship, that's the moment when you get to learn a lot from your users and you just can't anticipate it. You try very hard to understand exactly how people will use the product and get all the edges ironed out. But you can't until you ship. And I'll share an example. So my team helps support the dbt cloud scheduler and the initial version of the dbt cloud scheduler was pretty naive. We were a little embarrassed by it.

**中文翻译:**
我不是一个迷信框架的人，但我经常对自己或他人重复两句话：“差一点更好”（Worse is better）和“技术债是幸福的烦恼”（Tech debt is a champagne problem）。什么意思呢？这主要是为了帮我克服完美主义。完美并不存在，你应该选择“足够好”。因为当你发布（ship）时，才是你从用户那里学习的开始，你无法预见一切。你努力想搞清楚用户会怎么用，想磨平所有棱角，但只有发布后才能做到。举个例子：我的团队负责 dbt Cloud 调度器，最初的版本非常简陋，我们甚至觉得有点不好意思。

---

### (00:53:02) Julia Schottenstein

**English:**
It was a big old for loop over a big old jobs table. So we would look like is it time for this job to run? Okay. Yes, run this job. Okay. It's not time for this job to run next, continue on. Is it time? Yes, run this job. And it would just loop over and it's extremely naive and very simple, but it got the job done. And I try to remind the engineers, we would be so lucky to have tech debt because that means people are using the product. And now we've had to rebuild our scheduler several times over because we do have meaningful scale. We have 8,000 companies using our scheduler. We have to manage 10 million runs per month. But what we didn't need at launch was a distributed scheduler with coworkers and RabbitMQ. We just didn't need it because we had no users. So these two sayings that worse is better and tech debt is a champagne problem, just really reminds people like, let's ship, let's get it out into the user's hands and then we'll learn and iterate and it'll be a better experience for them.

**中文翻译:**
它就是一个对任务表进行的大型循环（for loop）。我们会检查：这个任务该运行了吗？该了，那就运行。还没到时间？那就下一个。它极其简陋、非常简单，但它完成了任务。我常提醒工程师：如果我们有技术债，那是我们的幸运，因为这意味着有人在用我们的产品。现在我们已经重构了好几次调度器，因为规模上来了——有 8,000 家公司在使用，每月要管理 1,000 万次运行。但在发布之初，我们不需要带 RabbitMQ 的分布式调度器，因为当时没用户。所以这两句话提醒大家：先发布，交到用户手里，然后学习、迭代，最终为他们提供更好的体验。

---

### (00:54:08) Lenny

**English:**
That's a good segue to my last question. So weren't a PM before this role. You have strong experience in investing, investment banking business in general. I'm curious what you think product managers should maybe focus on more or learn more or lean into to become stronger product leaders based on the experience you've had moving into product.

**中文翻译:**
这是一个很好的过渡。在担任此职位之前你不是 PM。你在投资、投行和商业方面有丰富的经验。基于你转行做产品的经历，你认为 PM 应该更多地关注、学习或投入什么，才能成为更强大的产品领导者？

---

### (00:54:30) Julia Schottenstein

**English:**
So I pull a lot on my experience or some of the things that I did was as an investor in my current role in product. And maybe I'll touch on what is the scale of a venture capitalist might be a little bit foreign for people, but venture capitalists, they spend all their day meeting lots of different companies, context switching. They have to know a little bit about quite a lot of different things. And they do this to refine their investment tastes or find their investor judgment. And they're also investing a lot in their network and connecting people, supporting people, and mining people for ideas that are way smarter than they are. So you do that all the time in Venture and I've brought a lot of those skills with me into product and it translates really well.

**中文翻译:**
我在目前的产品角色中借鉴了很多做投资人的经验。风投的工作节奏对很多人来说可能有点陌生：他们整天都在见不同的公司，不断进行上下文切换。他们必须对很多不同的事物都有所了解。这样做是为了磨练投资品味或判断力。他们还投入大量精力建立人脉、连接他人、支持他人，并从比自己聪明得多的人那里挖掘想法。在风投领域你一直在做这些，我把这些技能带到了产品工作中，转化效果非常好。

---

### (00:55:17) Julia Schottenstein

**English:**
The first is I still spend a lot of time investing in my network and I think it's an underrated way for a PM to spend their time. And I try to build a network of operators at other companies that are like dbt Labs that are growing nicely, maybe a little bit ahead of where we are. And I ask them questions, how did you navigate open source? How did you navigate pricing? How did you navigate acquisitions? And then I take the best ideas, figure out which ones I can apply and bring it back to dbt Labs. The second thing is I really think my specialty or my superpower is that I'm a T-shaped generalist. So I know a little about a lot of things from finance to business to product. I have to go a lot deeper in product in the areas that I specialize in. That's where the tail of the tea comes in. But it's precisely because I've had a diverse background that makes me more effective when I'm trying to get things done within the organization. Because I have just more credible experiences that I can pull from.

**中文翻译:**
首先，我仍然花大量时间投资于我的人脉，我认为这是 PM 被低估的一种时间分配方式。我努力与那些像 dbt Labs 一样在良好增长、甚至领先我们一点的公司的运营者建立联系。我会问他们：你们如何处理开源？如何处理定价？如何处理收购？然后我吸取最好的想法，应用到 dbt Labs。第二点，我认为我的特长或“超能力”是我是一个“T 型通才”。从财务、商业到产品，我什么都懂一点。在我专业的领域，我必须钻研得更深（这就是 T 字的那一竖）。正是因为这种多元化的背景，让我在组织内推动事情时更有效率，因为我有更多可靠的经验可以借鉴。

---

### (00:56:18) Julia Schottenstein

**English:**
And then the last thing that I think maybe doesn't show up day to day in my product work, but in investing, you're constantly thinking about risk and the power laws, and we touched on this before, but most investments don't work out. You lose the dollars that you put in, but all the returns come from these rare events that make up for all the losses. You have to think about what are the uncapped upside opportunities in investing. And I think in product, you still have to do the same thing. If 50% of the things I worked on went to zero, we'd have a problem. But it encourages me to continue to make bets for the company that has the chance of bending the trajectory of our business.

**中文翻译:**
最后一点，虽然在日常产品工作中不常显现，但在投资中，你会不断思考风险和“幂律”（power laws）。我们之前提过，大多数投资都不会成功，你会赔钱，但所有的回报都来自那些弥补所有损失的罕见事件。你必须思考投资中那些“上不封顶”的机会。我认为在产品中也一样。如果我做的 50% 的事情都归零了，那确实有问题，但这种思维鼓励我继续为公司下注，去寻找那些有机会改变业务轨迹的机会。

---

### (00:57:03) Lenny

**English:**
We've reached our very exciting lightning round. I've got six questions for you. Are you ready?

**中文翻译:**
我们进入了非常激动人心的闪电问答环节。我有六个问题。准备好了吗？

---

### (00:57:07) Julia Schottenstein

**English:**
Yeah, let's do it.

**中文翻译:**
准备好了，开始吧。

---

### (00:57:08) Lenny

**English:**
What are two or three books that you've recommended most to other people?

**中文翻译:**
你向别人推荐最多的两三本书是什么？

---

### (00:57:12) Julia Schottenstein

**English:**
Okay. So two books that helped me learn a lot about myself. Range, it's a book about generalist and also Quiet, it's a book about introverts. And then I like a lot of biographies. So a few of my favorites are Snowball about Warren Buffet, Made in America, about Sam Walton and Leonardo da Vinci.

**中文翻译:**
好的。有两本书帮我了解了自己：一本是《范围》（Range），关于通才的书；另一本是《安静》（Quiet），关于内向者的书。此外我喜欢传记，最喜欢的几本是关于巴菲特的《滚雪球》、山姆·沃尔顿的《美国制造》以及《达芬奇传》。

---

### (00:57:31) Lenny

**English:**
What is a favorite recent movie or TV show?

**中文翻译:**
最近最喜欢的电影或电视节目是什么？

---

### (00:57:34) Julia Schottenstein

**English:**
So I almost watched a movie in preparation for this podcast, but I really don't watch things except in the holiday. During the holidays, I like Succession, but I have not seen the latest season.

**中文翻译:**
为了准备这个播客，我差点去看部电影，但我除了假期真的不怎么看东西。假期里我喜欢看《继承之战》（Succession），但我还没看最新一季。

---

### (00:57:46) Lenny

**English:**
Wow. You're in store for a treat. Favorite interview question you like to ask?

**中文翻译:**
哇，那你有的看了。你最喜欢问的面试问题是什么？

---

### (00:57:53) Julia Schottenstein

**English:**
When's the last time you had to teach yourself something new and how'd you do it? So I like to test for growth mindset and a thirst for learning. And then also why dbt Labs. I think a lot of people who come to dbt Labs have very authentic reasons why they're drawn to the company. And in moments where in things are tough, it's the answer to that question of why are you here, it's going to make all the difference.

**中文翻译:**
“你上一次必须自学新东西是什么时候，你是怎么做的？”我喜欢测试成长型思维和学习渴望。还有“为什么选择 dbt Labs”。我认为很多加入 dbt Labs 的人都有非常真实的理由。在困难时期，关于“你为什么在这里”的答案将决定一切。

---

### (00:58:17) Lenny

**English:**
And sounds like what you look for is just like an genuine enthusiasm.

**中文翻译:**
听起来你寻找的是一种真实的热情。

---

### (00:58:21) Julia Schottenstein

**English:**
Yeah.

**中文翻译:**
是的。

---

### (00:58:22) Lenny

**English:**
What are some favorite products you recently discovered that you really like?

**中文翻译:**
你最近发现了哪些非常喜欢的候选产品？

---

### (00:58:27) Julia Schottenstein

**English:**
I like Belly. It's a consumer social app that lets you find and discover restaurants and rate them with your friends. It's been a lot of fun looking at the New York City restaurant scene.

**中文翻译:**
我喜欢 Belly。这是一个消费社交应用，可以让你发现餐厅并和朋友一起评分。探索纽约市的餐饮界非常有趣。

---

### (00:58:37) Lenny

**English:**
I've never heard of that. Awesome. What is something relatively minor you've changed in the way you all do? Product that has had a lot of impact?

**中文翻译:**
我还没听说过那个。太棒了。在你们做产品的方式上，有什么相对较小的改变却产生了巨大的影响？

---

### (00:58:42) Julia Schottenstein

**English:**
Do fewer things and try to single thread the team as much as possible.

**中文翻译:**
少做点事，并尽可能让团队保持“单线程”工作。

---

### (00:58:50) Lenny

**English:**
And single thread meaning like one main priority, one goal?

**中文翻译:**
单线程是指一个主要优先级、一个目标吗？

---

### (00:58:53) Julia Schottenstein

**English:**
One mission. Yeah. We're all working rowing in the same direction.

**中文翻译:**
一个使命。是的，大家都在朝同一个方向划船。

---

### (00:58:57) Lenny

**English:**
Final question. You have a podcast, first of all, tell us what it's called, but second of all, what's a favorite podcast of yours other than this podcast and your podcast?

**中文翻译:**
最后一个问题。你有一个播客，首先告诉我们它叫什么，其次，除了这个播客和你的播客，你最喜欢的播客是什么？

---

### (00:59:05) Julia Schottenstein

**English:**
Yeah. It's called the Analytics Engineering Podcast, so if you want to learn more about the data industry, I host it every other week with our CEO Tristan Handy. It's a lot of fun. Check it out. Other podcasts that I really like are In Depth, it's First Round's podcast by Brett Berson. He interviews a lot of operators about how they do their very best work. And another podcast that I really like is the Logan Bartlett Show, which touches on timely trends in tech.

**中文翻译:**
是的，它叫《Analytics Engineering Podcast》。如果你想了解更多关于数据行业的信息，我每隔一周会和 CEO Tristan Handy 一起主持。很有趣，去听听看。我喜欢的其他播客包括《In Depth》，这是 First Round 的播客，由 Brett Berson 主持，他采访了很多运营者关于如何做到极致。还有《The Logan Bartlett Show》，它涉及科技领域的及时趋势。

---

### (00:59:34) Lenny

**English:**
And In Depth I think Todd Jackson actually hosts a lot of the episodes too. Also, a huge fan of the podcast. Definitely check it out. And then say your podcast again and how can folks find it?

**中文翻译:**
《In Depth》里 Todd Jackson 也主持了很多集。我也是那个播客的超级粉丝。一定要去听听。再重复一遍你的播客名字，大家怎么找到它？

---

### (00:59:43) Julia Schottenstein

**English:**
It's called the Analytics Engineering Podcast.

**中文翻译:**
叫《Analytics Engineering Podcast》。

---

### (00:59:47) Lenny

**English:**
And it's just in podcasting apps?

**中文翻译:**
在各大播客应用里都有吗？

---

### (00:59:48) Julia Schottenstein

**English:**
Yes.

**中文翻译:**
是的。

---

### (00:59:49) Lenny

**English:**
Amazing. Check it out. Julia, we've talked about inflicting pain and strategic partnerships and why worse is better. Thank you so much for being here. Two final questions. Where can folks find you online if they want to reach out and how can listeners be useful to you?

**中文翻译:**
太棒了。大家去听听。Julia，我们聊了施加压力、战略合作伙伴以及为什么“差一点更好”。非常感谢你能来。最后两个问题：如果大家想联系你，可以在哪里找到你？听众能为你做些什么？

---

### (01:00:03) Julia Schottenstein

**English:**
You can find me on Twitter J_Schottenstein, and you can also find me in the dbt community Slack also, Julia Schottenstein. Send me a note, reach me there and I'd love to hear from you if you have data problems or we can help serve your needs better, would love to chat.

**中文翻译:**
你可以在 Twitter 上找到我，账号是 J_Schottenstein，也可以在 dbt 社区的 Slack 里找到我，名字是 Julia Schottenstein。给我发消息吧。如果你有数据方面的问题，或者我们可以更好地满足你的需求，我很乐意聊聊。

---

### (01:00:22) Lenny

**English:**
Thank you so much for being here, Julia.

**中文翻译:**
非常感谢你能来，Julia。

---

### (01:00:24) Julia Schottenstein

**English:**
Awesome. Thanks Lenny.

**中文翻译:**
太棒了，谢谢 Lenny。

---

### (01:00:25) Lenny

**English:**
Bye everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
再见，各位。非常感谢收听。如果你觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅。此外，请考虑给我们评分或留下评论，这能帮助其他听众发现这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。