# Julie Zhuo 2.0 - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Julie Zhuo.

---

### [00:00:00] Lenny Rachitsky

**English:**
We're seeing this kind of flattening of orgs. Everyone's becoming an IC again.

**中文翻译:**
我们正看到组织架构的一种扁平化趋势。每个人都再次变回了 IC（Individual Contributor，个人贡献者）。

---

### [00:00:04] Julie Zhuo

**English:**
It used to be, okay, I don't have the skills to do 10 different jobs, but now with AI allows me to do many of those jobs myself. We need to dissolve the boundaries of these traditional roles and call ourselves builders. I'd love for us to get to the world where that's the title.

**中文翻译:**
过去的情况是，“好吧，我没有同时做 10 份不同工作的技能”，但现在有了 AI，我可以亲手完成其中的许多工作。我们需要打破这些传统角色的界限，称自己为“建设者”（Builders）。我希望我们能进入一个以这个词作为职位的世界。

---

### [00:00:21] Lenny Rachitsky

**English:**
I also just saw a stat Google let go of so many of their middle managers.

**中文翻译:**
我还刚看到一个统计数据，谷歌裁掉了非常多的中层管理人员。

---

### [00:00:22] Julie Zhuo

**English:**
Management is still really critical. You have a north star, you have a vision, and you're just trying to figure out how to use the resources that you have to get that thing done. Used to be people, but now it's basically models and different models have different strengths. You have to assemble the Avengers so that you can use the right tools for the right purposes.

**中文翻译:**
管理依然非常关键。你有一个北极星指标，有一个愿景，你只是在努力思考如何利用手头的资源来完成目标。过去资源主要是人，但现在基本上是模型，不同的模型有不同的优势。你必须集结你的“复仇者联盟”，以便针对不同的目的使用正确的工具。

---

### [00:00:39] Lenny Rachitsky

**English:**
What do you feel is the biggest change in the role in life of a manager these days?

**中文翻译:**
你觉得如今管理者的角色和生活最大的变化是什么？

---

### [00:00:43] Julie Zhuo

**English:**
It's always been manager's job to manage change. I just think the rate of change is accelerating. Today management is really about this idea of be sturdy while being flexible. So I think about this metaphor a lot of the willow tree. It can survive a lot of storms, disasters, et cetera, but it's also very flexible.

**中文翻译:**
管理者的工作向来就是管理变化。我只是觉得变化的速率正在加快。今天的管理核心在于“坚定且灵活”这个理念。我经常想到柳树这个比喻。它能挺过许多风暴和灾难，但它同时也非常柔韧灵活。

---

### [00:01:00] Lenny Rachitsky

**English:**
You have such an interesting trajectory from being head of design to now being obsessed with data and analytics.

**中文翻译:**
你的职业轨迹非常有趣，从设计负责人到现在痴迷于数据和分析。

---

### [00:01:05] Julie Zhuo

**English:**
You want to diagnose with data and treat with design. Data is not a tool that's going to tell you what you should build. I don't actually think a lot of the fast growing companies are using data well at this point. Traditionally things just didn't grow that fast. These companies are totally getting by on just good instincts and good vibes, but what always happens is eventually things stop growing.

**中文翻译:**
你应该“用数据诊断，用设计治疗”。数据并不是一个会直接告诉你该建造什么的工具。实际上，我认为目前很多快速增长的公司并没有很好地利用数据。传统上，事物增长没那么快。这些公司完全是靠敏锐的直觉和良好的氛围在维持，但通常发生的情况是，增长最终总会停滞。

---

### [00:01:27] Lenny Rachitsky

**English:**
Today my guest is Julie Zhuo. Julie was my first ever guest on this podcast, which I recorded over three years ago, so this is a very special conversation as I've shared many times before in other places, Julie's newsletter The Looking Glass was the inspiration for my newsletter and basically led to everything that I do now. If you're not familiar with Julie, she was the longtime head of design for the Facebook app used by over three billion people. She's also the author of the best selling and very important book The Making of a Manager. And most recently she started her own company, Sundial, which is an AI parent analyst used by companies like OpenAI Gamma and Character.AI. Julie is one of the most thoughtful and insightful product leaders that I've ever come across and she's also got one of the most interesting perspectives on product building.

(00:02:18):
Having worked at a mega large corp like Meta as head of design and now as a founder at a tiny startup that's all about using data to help you make decisions, it's really rare for someone to have this spectrum of experiences. In our conversation, we talk about how learning to be a great manager directly translates to learning how to use AI tools extremely well, which specific skills will become more valuable in the next couple of years, her most valuable and timeless advice for new managers, why she's not hiring product managers at her startup, her simple heuristic for knowing when to use data and when to use intuition in making decisions. There's something in this episode for everyone. And if you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. It helps tremendously. And if you become an annual subscriber of my newsletter, you get 15 incredible products for free for an entire year, including Lovable, Replit, Bolt, n8n, Linear, Superhuman, Descript, Whisperflow, Gamma, Perplexity, Warp, Granola, Magic Patterns, ChatPRD and Mobbin.

(00:03:20):
Head on over to lennysnewsletter.com and click product pass. With that, I bring you Julie Zhuo. This episode is brought to you by Mercury. I've been banking with Mercury for years and, honestly, I can't imagine banking any other way at this point. I switched from Chase and, holy moly, what a difference. Sending wires, tracking spend, giving people on my team access to move money around, so freaking easy. Where most traditional banking websites and apps are clunky and hard to use, Mercury is meticulously designed to be an intuitive and simple experience. And Mercury brings all the ways that you use money into a single product, including credit cards, invoicing, bill pay, reimbursements for your teammates and capital. Whether you're a funded tech startup looking for ways to pay contractors and earn yield on your idle cash, or an agency that needs to invoice customers and keep them current, or an eCommerce brand that needs to stay on top of cash flow and access capital. Mercury can be tailored to help your business perform at its highest level.

(00:04:19):
See what over 200,000 entrepreneurs love about Mercury. Visit mercury.com to apply online in 10 minutes is a FinTech, not a bank. Banking services provided through Mercury's FDIC-insured partner banks. For more details, check out the show notes. Today's episode is brought to you by DX, the developer intelligence platform designed by leading researchers. To thrive in the AI era, organizations need to adapt quickly, but many organization leaders struggle to answer pressing questions like which tools are working, how are they being used, what's actually driving value? DX provides the data and insights that leaders need to navigate this shift. With DX, companies like Dropbox, booking.com, Adyen, and Intercom get a deep understanding of how AI is providing value to their developers and what impact AI is having an engineering productivity. To learn more, visit DX's website at getdx.com/lenny. That's getdx.com/lenny. Julie, thank you so much for being here and welcome back to the podcast.

**中文翻译:**
今天的嘉宾是 Julie Zhuo。Julie 是我这个播客的第一位嘉宾，那是三年前录制的，所以这次对话非常特别。正如我多次在其他地方分享过的，Julie 的新闻通讯《The Looking Glass》是我创办新闻通讯的灵感来源，基本上成就了我现在所做的一切。如果你不熟悉 Julie，她曾长期担任 Facebook 应用的设计负责人，该应用拥有超过 30 亿用户。她还是畅销书且非常重要的著作《管理者养成指南》（The Making of a Manager）的作者。最近，她创办了自己的公司 Sundial，这是一家 AI 数据分析平台，客户包括 OpenAI、Gamma 和 Character.AI。Julie 是我见过的最深刻、最有见地的产品领导者之一，她对产品构建有着非常独特的视角。

(00:02:18):
她曾在 Meta 这样的大型企业担任设计负责人，现在又在一家专注于利用数据辅助决策的小型初创公司担任创始人，这种跨度的经验非常罕见。在我们的对话中，我们讨论了学习成为一名优秀的管理者如何直接转化为学习如何极好地使用 AI 工具；未来几年哪些特定技能会变得更有价值；她给新任管理者最宝贵且永恒的建议；为什么她在初创公司不招聘产品经理；以及她在决策时何时使用数据、何时使用直觉的简单启发式方法。这集节目适合每一个人。如果你喜欢这个播客，别忘了在应用或 YouTube 上订阅。如果你成为我新闻通讯的年度订阅者，你将免费获得 15 款不可思议的产品一年使用权，包括 Replit, Linear, Perplexity 等。

(00:03:20):
访问 lennysnewsletter.com 点击 product pass 即可。下面，让我们欢迎 Julie Zhuo。本集节目由 Mercury 赞助。我使用 Mercury 银行服务多年，无法想象用其他方式。从 Chase 转过来后，差别巨大。转账、追踪开支、授权团队成员移动资金，都极其简单。大多数传统银行网站笨重难用，而 Mercury 设计精良，体验直观。它将信用卡、发票、账单支付、报销和资本整合在一个产品中。无论你是需要支付承包商费用的初创公司，还是需要管理现金流的电商平台，Mercury 都能助你一臂之力。

(00:04:19):
看看超过 20 万企业家为何喜爱 Mercury。访问 mercury.com 即可在线申请。Mercury 是金融科技公司而非银行，银行服务由其受 FDIC 保险的伙伴银行提供。今天的节目还由 DX 赞助，这是一个由领先研究人员设计的开发者情报平台。为了在 AI 时代蓬勃发展，组织需要快速适应，但许多领导者难以回答哪些工具奏效、如何使用、什么在驱动价值。DX 提供领导者导航这种转变所需的数据和洞察。通过 DX，Dropbox、Booking.com 等公司能深入了解 AI 如何为开发者提供价值及其对工程生产力的影响。访问 getdx.com/lenny 了解更多。Julie，非常感谢你能来，欢迎回到播客。

---

### [00:05:26] Julie Zhuo

**English:**
Thank you, Lenny. I'm so excited to be here. I've been looking forward to this all week. I love your podcast. I love where you've taken it since our very first conversation and I'm super excited to have a fun and engaging chat.

**中文翻译:**
谢谢你，Lenny。我非常高兴能来到这里。我这整周都在期待这次对话。我非常喜欢你的播客，也很佩服你自我们第一次谈话以来所取得的成就，我很期待这次有趣且深入的交流。

---

### [00:05:38] Lenny Rachitsky

**English:**
Can you believe that first episode, the very first episode of this podcast, was over three years ago at this point? Holy shit.

**中文翻译:**
你能相信吗？这个播客的第一集，也就是我们录的那一集，已经是三年多以前的事了。天呐。

---

### [00:05:46] Julie Zhuo

**English:**
I'm not sure you had that fire in the background back then.

**中文翻译:**
我不确定你那时候背景里有没有那个壁炉火光。

---

### [00:05:49] Lenny Rachitsky

**English:**
So funny enough, I don't know how many people have noticed this Easter egg that I've stuck with, in that first studio, I was just watching the episode, I had this funny little mirror. I don't know if I had in the first episode with a fireplace that was showing up in that mirror because the mirror was showing something stupid. And so I've just kind of kept this fireplace across every studio I've moved across in my various places.

**中文翻译:**
很有趣的是，我不知道有多少人注意到了我一直坚持的这个“彩蛋”。在第一个工作室里，我刚才看那一集，我有一个滑稽的小镜子。我不确定第一集里镜子里是不是显示了一个壁炉，因为那个镜子当时反射了一些很傻的东西。于是我就在后来搬过的每一个工作室里都保留了这个壁炉背景。

---

### [00:06:12] Julie Zhuo

**English:**
I even remember we chatted. Video was kind of a newer thing. You're like, "We'll record it, but it's really about the audio." And now we moved into the video era.

**中文翻译:**
我还记得我们当时聊过。视频在当时还是个新鲜事。你当时说：“我们会录视频，但核心还是音频。”而现在我们已经完全进入了视频时代。

---

### [00:06:21] Lenny Rachitsky

**English:**
So as you were saying that, I realized my fire was broken, so I just had to turn that on. So we just cut a little piece. Yeah, that fire was my little funny strike for myself and I don't think anyone's ever realized this.

**中文翻译:**
就在你说话的时候，我意识到我的壁炉火灭了，所以我刚才得把它打开。我们剪掉那一小段。是的，那个火光是我给自己留的小趣味，我觉得可能没人发现过。

---

### [00:06:32] Julie Zhuo

**English:**
It's very cozy. I love it.

**中文翻译:**
非常温馨，我很喜欢。

---

### [00:06:33] Lenny Rachitsky

**English:**
That's the idea. I was actually just looking at the stats. So since that first episode, this podcast has done over 20 million downloads. It's approaching 30 million downloads.

**中文翻译:**
这就是我的初衷。我刚才其实在看统计数据。自第一集以来，这个播客的下载量已经超过了 2000 万次，正接近 3000 万次。

---

### [00:06:43] Julie Zhuo

**English:**
It's really incredible. I think it is a testament to just your curiosity and how much you really care about the craft of building great products and sharing that with the world. And I know I listen to your podcast and read your newsletter, my team does. We're constantly sharing things from all of the amazing speakers that you've had, so thank you for doing this.

**中文翻译:**
这真的很不可思议。我认为这证明了你的好奇心，以及你对构建伟大产品的工艺和向世界分享这些知识的热爱。我知道我自己在听你的播客、读你的通讯，我的团队也是。我们经常分享你邀请的那些了不起的嘉宾的观点，所以谢谢你所做的一切。

---

### [00:07:01] Lenny Rachitsky

**English:**
My pleasure. I really appreciate that. So the reason we are chatting again three years later is you're re-releasing your incredible book, The Making of a Manager. I've got it right here. You've sold a bazillion copies. It's been on every list that I've seen. You're releasing the paperback version, you're adding some chapters. I guess first of all, just how do you feel on reflecting back on the success of this book?

**中文翻译:**
我的荣幸，非常感谢。我们三年后再次交谈的原因是你要重新发行你那本了不起的著作《管理者养成指南》。我手里就有一本。你卖出了无数本，它出现在我见过的每一个书单上。你现在要发行平装版，并增加了一些章节。首先，回顾这本书的成功，你有什么感受？

---

### [00:07:24] Julie Zhuo

**English:**
It honestly went beyond my expectations, so I'm super happy with it. My big motivation to write it was I think largely because I felt if I had to write this thing, I was likely going to become a better manager. And that was actually a huge part of it because thinking about and writing something I've been blogging for a long time. And I know that part of my process is when I really sit down to try and put down everything I feel and write letters to myself, it really helps me. And so that was honestly a huge motivation. I hoped that it would go out there and it would sell some books. I was thinking about that maybe for people who grew up in companies like mine, like Facebook, high-scale Silicon Valley, it might resonate. I couldn't have expected that it would have much wider reach than that and that's been really awesome.

(00:08:11):
And just how many people will tell me things like I thought I was the only one who felt this way, but this book made me realize that, hey, these are very normal feelings. And that's certainly how I felt, just stumbling through and feeling like an imposter for so many years. And so it really is very gratifying to hear that from readers.

**中文翻译:**
老实说，这超出了我的预期，所以我非常开心。我写这本书的一大动力是，我觉得如果我必须把这些写下来，我可能会成为一名更好的管理者。这占了很大一部分原因，因为思考并写下某些东西——我已经写了很久的博客了。我知道我过程中的一部分就是当我真正坐下来，试着写下我所有的感受，写信给自己时，这对我非常有帮助。所以这真的是一个巨大的动力。我当时希望它能出版并卖出一些书。我当时想，也许对于那些在像 Facebook 这样的大规模硅谷公司成长起来的人来说，它会产生共鸣。我没预料到它的影响力会如此广泛，这真的很棒。

(00:08:11):
还有很多人会告诉我：“我以为只有我有这种感觉，但这本书让我意识到，嘿，这些都是非常正常的情绪。”这确实也是我当年的感受，多年来一直跌跌撞撞，觉得自己像个“冒充者”。所以听到读者的这些反馈真的非常有成就感。

---

### [00:08:29] Lenny Rachitsky

**English:**
I feel like it's the modern-day high output management. That's the book that's been mentioned most on this podcast and it feels like this is just a modern version. I feel like that book is actually out of date in a lot of ways, so I can see why people are really drawn to it. And this is a great segue to the first area I want to spend some time on, which is it feels like a lot of the skills you learn as a manager translate to being really good with AI and using AI tools really well. And I want to talk through a few trends that I want to get your take on that relate to this general theme. The first is it feels like just everyone is going to become a manager in the near future because of agents being so integrated into our workflows. There's this agentic society that we're coming to and it feels like the same skills of being a manager make you really good working with agents. Just thoughts on that and where you think that's going to go.

**中文翻译:**
我觉得它是现代版的《高产出管理》（High Output Management）。那是这个播客中被提及次数最多的书，而你的书感觉就像是它的现代版。我觉得那本书在很多方面已经过时了，所以我能理解为什么人们会被你的书吸引。这正好引出了我想探讨的第一个领域：感觉作为管理者学到的很多技能，可以转化为如何极好地使用 AI 工具。我想讨论几个趋势，想听听你对这个主题的看法。首先，感觉在不久的将来，由于智能体（Agents）如此深入地融入我们的工作流，每个人都会变成一名“管理者”。我们正在进入一个“智能体社会”，感觉成为管理者的那些技能会让你在与智能体协作时表现出色。你对此有什么看法，你认为这会走向何方？

---

### [00:09:20] Julie Zhuo

**English:**
I 100% believe that and agree with that, which is that management is just about, in my mind, having an outcome. So you want to get something done. That's the thing. You have a north star, you have a vision, and you're just trying to figure out how to use the resources that you have to get that thing done. And typically when we talk about management in traditional settings, we talk about the resources being people, and getting the right talent, and making sure that you've got the assemble the Avengers, so you've got the right mix of skills that you need. The second lever is around, okay, what's the purpose? Does everyone know what they're supposed to do with their talents? Do we have a goal? Do we have a purpose? And then the third thing is process, which is how should all of these different people and tools come together?

(00:10:07):
And these are still the fundamentals of working with agentic systems. You still need a goal. You need to be very clear about what the outcome is and you have to understand the strengths of, used to be people, but now it's basically models. And different models have different strengths, so it's like they have different personalities. And so you kind kind to get to know it, develop an intuition for it so that you can use the right tools for the right purposes. And I mean, we talk about agents, but we also talk about what are the tools that agents have access to? So you still have to make decisions around that and then there's of course process, which is how you do it. And now I think with better and better models, perhaps the agents get smarter so they can deal with higher and higher levels of figuring out how to do something, but I think it's still very important for us to be able to provide the right context, provide the right high level instruction so that we get what we want.

(00:10:59):
So really, it's the same principles and I absolutely agree with you that more and more of us are going to have to double down on these skills to be able to use these tools very effectively.

**中文翻译:**
我百分之百相信并同意这一点。在我看来，管理的核心就是为了达成一个结果。你想完成某件事，这就是核心。你有一个北极星指标，一个愿景，你只是在想如何利用手头的资源来达成它。通常在传统语境下谈论管理时，资源是指人，即获取正确的人才，确保你集结了“复仇者联盟”，拥有所需的技能组合。第二个杠杆是目标：每个人都知道该如何发挥才华吗？我们有目标吗？第三个是流程：所有这些人与工具该如何协作？

(00:10:07):
这些依然是与智能体系统协作的基础。你仍然需要一个目标。你需要非常清楚结果是什么，并且必须了解资源的优势——过去是人，现在基本上是模型。不同的模型有不同的优势，就像它们有不同的性格一样。所以你必须去了解它，培养对它的直觉，以便针对不同的目的使用正确的工具。我们谈论智能体，但也谈论智能体可以访问的工具。你仍然需要围绕这些做出决策，当然还有流程，即如何去做。现在随着模型越来越好，也许智能体变得更聪明，能处理更高层次的执行问题，但我认为提供正确的上下文、提供正确的高级指令以获得我们想要的结果，依然非常重要。

(00:10:59):
所以，原则是一样的。我完全同意你的看法，越来越多的人将不得不加倍磨练这些技能，以便有效地使用这些工具。

---

### [00:11:09] Lenny Rachitsky

**English:**
So along those lines, I have your book right here. You have this list of a manager's job is to build a team that works well together, support members in reaching their career goals and create processes to get work done smoothly and efficiently, which is basically exactly what you just said. Interestingly, that middle bullet is the part you don't have to worry about anymore with agents. You don't have to worry about their career development and progress.

**中文翻译:**
顺着这个思路，我手里就有你的书。你列出了管理者的工作：建立一个协作良好的团队，支持成员实现职业目标，并创建流程以顺利高效地完成工作。这基本上就是你刚才说的。有趣的是，中间那一项——支持成员实现职业目标——在面对智能体时你不再需要担心了。你不需要担心它们的职业发展和进步。

---

### [00:11:28] Julie Zhuo

**English:**
That's true. That's true, though some people do joke that if we don't treat our agents nice, what's going to happen when AGI comes? And maybe it still might benefit us to be kind.

**中文翻译:**
确实如此。不过也有人开玩笑说，如果我们不对智能体好一点，等 AGI（通用人工智能）到来时会发生什么？也许保持善良对我们还是有好处的。

---

### [00:11:39] Lenny Rachitsky

**English:**
I'm one of those people that says thank you to the Waymo when I leave and just thanks ChatGPT when I'm in voice mode. Just like, "Thank you. That was really helpful." So along these lines, I know there's a lot of ways to go here, but just in terms of skills that are important to a manager, which do you think are most valuable to develop in working with agents in AI systems? I think about things like clarity, communication. Just what comes to mind when you think about here's the things you want to double down on as you're learning to be manager that will also help you be really good at AI tooling and working with agents?

**中文翻译:**
我就是那种下 Waymo 无人车时会说谢谢，用 ChatGPT 语音模式时也会说“谢谢，这很有帮助”的人。所以，我知道这个话题有很多方向可以聊，但就管理者的重要技能而言，你认为在与 AI 系统和智能体协作时，哪些技能最值得培养？我想到的是清晰度、沟通。当你想到那些在学习成为管理者时需要加倍努力、同时也能帮你用好 AI 工具的技能时，你会想到什么？

---

### [00:12:16] Julie Zhuo

**English:**
The first is defining the goal and defining the outcome and being really, really crystal clear on what does success look like. If you ask a company to do this, we'll know that this is challenging for humans. I think a lot of times when you talk about why is alignment so difficult at a big company, it often comes down to this question, which is different people may have different pictures of what success looks like. And even if I describe in human words, Lenny, I want to build this product and it's going to be amazing, or this podcast episode, which you asked me, want lots of people to hear it and take away things, that's very general. How do we get even more specific so that we know without question whether we've hit it or not. And this is actually a really, really difficult problem.

(00:13:06):
It's a difficult question for us because, again, we tend to think very high level. So figuring out how to boil it down so that an agent can really understand what success and failure looks like is a lot of the game. And I think this also relates to things like, well, that's why we have to write evals and that's why they're so important, because they're helping us understand what is the objective criteria. And these days I work in data and my company is all about trying to automate data analysis. And the forever question goes the whole point of data and the whole point of metrics and KPIs is we're trying to put a little bit more of an objective measure or get as crystal clear as possible about what success looks like. And I think it's really an art more than it is like a science, but that's the first thing. I think if you're really unclear about what success looks like, the prompt, you're probably not going to get the most amazing work. I think that's true for managing teams and it's very much true for managing AIs.

**中文翻译:**
第一点是定义目标和结果，并对“成功是什么样子”做到极其清晰。如果你让一家公司去做这件事，你会发现这对人类来说极具挑战。我认为很多时候谈论大公司为什么难以达成共识（Alignment），往往归结为这个问题：不同的人对成功有不同的构想。即使我用人类语言描述，“Lenny，我想做这个产品，它会很棒”，或者关于这集播客，“希望很多人听并有所收获”，这都太笼统了。我们如何变得更具体，以便毫无疑问地知道我们是否达到了目标？这实际上是一个非常、非常困难的问题。

(00:13:06):
这对我们来说很难，因为我们习惯于高层次的思考。因此，弄清楚如何将其简化，让智能体能真正理解成功和失败的标准，是博弈的关键。我认为这也与编写评估（Evals）有关，这就是为什么评估如此重要，因为它们帮助我们理解客观标准是什么。如今我从事数据工作，我的公司致力于自动化数据分析。永恒的问题是：数据、指标和 KPI 的全部意义在于，我们试图建立一个更客观的衡量标准，或者尽可能清晰地描述成功。我认为这更像是一门艺术而非科学，但这是第一要务。如果你对成功的定义不清晰，那么你的提示词（Prompt）可能无法带来惊艳的作品。管理团队如此，管理 AI 更是如此。

---

### [00:14:01] Lenny Rachitsky

**English:**
Okay, so let me actually flip this on you and talk about another trend that we're seeing, which is this kind of flattening of orgs, managers being let go. Everyone's becoming an IC again. I just had the CEO of Airtable on the podcast and his whole shtick was that CEOs have to become ICs again. He's coding more than he's ever coded again and his feeling is you have to know what's possible by being in the weeds in order to figure out what your product should be. I also just saw a stat that Google let go of so many of their middle managers of smaller teams. It's just like this flattening trend. So do we even need managers, I guess is one question in the future, and then just thoughts on how this will play out?

**中文翻译:**
好，那让我反过来问你，谈谈我们看到的另一个趋势：组织扁平化，管理者被裁。每个人都再次变回 IC。我刚采访了 Airtable 的 CEO，他的核心观点是 CEO 必须重新变回 IC。他现在的代码量比以往任何时候都多，他的感觉是，你必须深入细节了解什么是可能的，才能确定你的产品应该是什么样。我也刚看到数据说谷歌裁掉了许多小团队的中层经理。这就是扁平化趋势。那么，未来的一个问题是：我们还需要管理者吗？你认为这会如何演变？

---

### [00:14:42] Julie Zhuo

**English:**
So I think the real promise and magic of AI that we're seeing in the workplace is that it leads us to each individual is far more empowered. So it used to be, okay, I don't have the skills to do 10 different jobs, so I need to supplement by hiring people to do these jobs. I need someone who's really good at design, I need someone who's really good at coding, I need someone who's really good at data analysis, and then I'll assemble that team. But now with AI and my companion, it's like, wait a second, AI allows me to do many of those jobs myself. Now, I'm not going to do them at what's called the PhD or the highest 1%, 10% level, but if I was at the zero or 10th percentile, it can certainly get me even today very quickly up to the 60th, 70th in terms of what the state of the art is.

(00:15:34):
And I think that that unlocks so many doors. And so the main thing that I felt so excited about, and this is something I tell my team all the time, is we need to dissolve the boundaries of these traditional roles. So in the past, again, we would have a traditional team, engineers, product manager, designer, researcher, data scientist. And I think now the teams can look more like, well, it's just two people. And they could be any of these traditional disciplines, but the key thing is they can now use AI to help themselves do a lot of the things that the other folks used to be able to do. So in some ways we can drop all of these different role distinctions and call ourselves builders. I think that's sort of the most general purpose way of thinking about what we can all be. We can all be builders. We can all be builders and I'd love for us to get to the world where that's like the title.

**中文翻译:**
我认为我们在职场中看到的 AI 的真正承诺和魔力在于，它让每个个体都获得了更强大的赋能。过去是，“好吧，我没有做 10 份不同工作的技能，所以我需要通过雇人来补充。我需要擅长设计的人，擅长编程的人，擅长数据分析的人，然后组建团队。”但现在有了 AI 助手，你会发现：等一下，AI 让我能亲自动手做其中的很多工作。虽然我可能做不到博士级或顶尖 1% 的水平，但如果我原本处于 0 或 10% 的水平，它今天就能迅速帮我提升到行业前 60% 或 70% 的水平。

(00:15:34):
我认为这开启了许多大门。我最感到兴奋的一点——这也是我经常告诉团队的——是我们需要打破这些传统角色的界限。过去，我们有传统的团队：工程师、产品经理、设计师、研究员、数据科学家。而现在，团队可能看起来只有两个人。他们可以来自任何传统学科，但关键是他们现在可以利用 AI 来帮助自己完成以前需要别人完成的工作。所以在某种程度上，我们可以抛弃所有这些不同的角色区分，称自己为“建设者”。我认为这是对我们所有人身份最通用的思考方式。我们都可以是建设者，我希望未来这个词能成为通用的职位头衔。

---

### [00:16:30] Lenny Rachitsky

**English:**
That's funny. That's the term I've been actually using more and more. I used to orient this podcast as a newsletter around product managers and then I started using just product to be a little more broad. And now I'm actually using that term builder and I love that term because it's exactly what you're saying. And this is very much a theme that comes up often in these conversations more and more, just the lines are blurring. I'm curious at your company, how does that look? What are you doing differently? What are you seeing on the ground within your company that maybe would be different from a few years ago?

**中文翻译:**
很有趣，我也在越来越多地使用这个词。我以前把这个播客和通讯定位在“产品经理”周围，后来为了更广泛，改成了“产品”。现在我实际上在用“建设者”这个词，我很喜欢它，因为它正如你所说。这也是这些对话中经常出现的主题：界限正在模糊。我很好奇在你的公司，这种情况是什么样的？你们的做法有什么不同？你在公司内部看到的哪些现象是几年前所没有的？

---

### [00:17:01] Julie Zhuo

**English:**
So we have eliminated more roles. For example, we thought we would need a bunch of product managers. It's turned out that actually if you don't have a product manager, I know this might be going against a little bit of the ethos of where Lenny started, but I find that sometimes when you have a designer or a product manager, and let's say I'm an engineer, then when I have a problem, like I need to figure out the product definition, my default will be, well, I've got these people and that's kind of their job description, so I'm just going to delegate that to them. And I think that in doing so, again, we want to be polite, we want to respect everyone's lanes. I think that's a missed opportunity for that, if I'm the engineer, to be like, "Wait a second, I should probably focus a lot, too." I need to understand and have an opinion about what to build or what the user experience is.

(00:17:54):
And so we found that if we actually make teams smaller and we even in the past, pre-AI, just have fewer of these, it allowed everyone to be like, "Wait, we don't have product manager on the team, so communication's up to me. Figuring out how we get greatest value to users is something that is now strictly in my charter. And so that's why I'm such a big fan of we can make teams smaller and we can eliminate these lines. Sure. Again, I'm not trying to say everyone has to do everything. We still can respect the fact that you might be much better at this particular skill than me, but it's less about the role and it's more about the specific context that we're in.

(00:18:32):
And I find that whenever you have teams and you empower them to be able to take more action on their specific context rather than having these higher level of rules or policies or this is how it's supposed to be, then you get better work. You get faster work and you get happier employees because people feel like they actually can have the power to create the thing that they want.

**中文翻译:**
我们减少了更多的角色。例如，我们原以为需要一群产品经理。结果发现，如果没有产品经理——我知道这可能有点违背 Lenny 播客最初的初衷——但我发现，当你有了设计师或产品经理，而假设我是一名工程师，当我遇到问题（比如需要确定产品定义）时，我的默认反应会是：“好吧，我有这些人，那是他们的工作职责，我就委托给他们吧。”我认为这样做虽然是出于礼貌和尊重分工，但却错失了一个机会。如果我是工程师，我应该想：“等一下，我也应该重点关注这个。”我需要理解并对“要建造什么”或“用户体验是什么”有自己的见解。

(00:17:54):
所以我们发现，如果我们把团队做得更小，甚至在 AI 出现之前就减少这些角色，它会让每个人意识到：“等等，团队里没有产品经理，所以沟通得靠我。弄清楚如何为用户创造最大价值现在完全是我的职责。”这就是为什么我非常支持缩小团队规模并消除这些界限。当然，我不是说每个人都必须做所有事。我们仍然尊重你可能在某项特定技能上比我强得多的事实，但这更多是关于具体的上下文，而不是关于角色。

(00:18:32):
我发现，每当你拥有一个团队并赋予他们在特定上下文中采取行动的权力，而不是受限于高层规则、政策或“本该如此”的教条时，你就能得到更好的产出。工作效率更高，员工也更快乐，因为人们觉得他们真正拥有创造自己想要的东西的权力。

---

### [00:18:58] Lenny Rachitsky

**English:**
That's really interesting, just that constraint of not having a PM makes the engineer realize they're not going to wait for someone else to do it. They have to figure it out. The obvious trick there is they have to be good at this. It's a very different job from engineering to be really good at articulating here's the problem we're going to solve, here's why it's important that we're solving, here's how we're going to prioritize everything we're thinking about, here's how we get alignment. Is there something you do differently when you're hiring these engineers, knowing you're going to probably not hire PM? And just that feels really hard to hire for someone that's really good at all these things.

**中文翻译:**
这很有趣，没有 PM 的约束让工程师意识到他们不能等别人来做，必须自己搞定。但明显的难点在于他们必须擅长这个。从工程转向擅长清晰表达“我们要解决什么问题”、“为什么解决它很重要”、“如何确定优先级”以及“如何达成共识”，这是一份截然不同的工作。在招聘这些工程师时，既然知道可能不招 PM，你们会有什么不同的做法吗？感觉要招到在所有这些方面都很出色的人真的很难。

---

### [00:19:30] Julie Zhuo

**English:**
It is true and I'm not trying to say again that everyone needs to be good at everything. I don't think that's very realistic. I do think, for example, if we were going to create a team and we're going to have a couple engineers and none of them are very good at thinking through product requirements or what the user angle is, we probably do need to supplement the team with somebody with that skill set. And that might be a designer, or that might be another engineer who's really good at that, or that might be a traditional product manager, or even sometimes a data analyst who's really good at it. So that skill is still important and the team still needs to have that skill, otherwise it's probably not going to produce the best outcome. But I like to think of it as what are the skills that are needed for this and can we now find a couple people?

(00:20:13):
But it doesn't mean we just automatically go to that script of need a PM, need a designer, need three engineers, need that. Another example for us is even thinking about front end, back end engineering. And it used to be like some people are front engineers. So if you have a project and it's got some front end, some back end, the shortcut is like I need one of these and one of these and that's how it's going to go. But if you say, look, you're an engineer, you're a builder, this has a little bit of front end, but you know what? You can probably figure that out. Use AI to help you figure it out. Get obviously someone who's a specialist to review the code or to give you some high level guidance on things, but just do it. And ever since we started to implement that as well, we see again a little bit of you have to invest a little bit in the beginning. So people are not as comfortable.

(00:21:01):
They have to learn, so initially things take longer, takes a little bit of extra time, versus if you did slot in a front-end specialist and this is a front end project. It probably would've gone a little bit shorter, but in the long run that investment really pays off because now you have a lot more people who are, again, a little more well rounded and can take on many more pieces just on their own. And then in specific scenarios this is super front and heavy. Sure, let's still bring in somebody who is more specialized in that particular skill.

**中文翻译:**
确实如此，我并不是说每个人都要样样精通，那不现实。我认为，如果我们要组建一个团队，里面有几个工程师，但没人擅长思考产品需求或用户视角，那我们确实需要补充具备这种技能的人。那可能是一个设计师，或者另一个擅长此道的工程师，也可能是一个传统的产品经理，甚至有时是一个擅长此道的数据分析师。所以这项技能依然重要，团队必须具备它，否则无法产生最佳结果。但我更倾向于思考：完成这件事需要哪些技能？我们能否找到几个人来覆盖这些技能？

(00:20:13):
但这并不意味着我们要自动套用“需要一个 PM、一个设计师、三个工程师”这种剧本。另一个例子是前后端工程。过去有些人只做前端。如果一个项目既有前端又有后端，捷径就是“我需要一个前端和一个后端”。但如果你说：“听着，你是一个工程师，一个建设者，这里有一点前端工作，但你知道吗？你大概能搞定。用 AI 帮你想办法。当然，找个专家来审查代码或给你一些高级指导，但动手去做吧。”自从我们开始实施这种做法，我们发现初期确实需要一点投入。人们会感到不太适应。

(00:21:01):
他们必须学习，所以最初进度会慢一点，比起直接塞进一个前端专家，花的时间会多一点。但从长远来看，这种投入是非常值得的，因为现在你有了更多全面发展的人才，他们可以独立承担更多环节。当然，在特定场景下，如果前端任务极重，我们当然还是会请更专业的人来处理。

---

### [00:21:31] Lenny Rachitsky

**English:**
I love that you've had the experience of working at a mega large company at Meta and now you're building your own startup that's small and in the middle of this trend of just staying very small and staying really lean and just everyone doing more things. It's so cool that you're experiencing that. So a couple of questions there, just which functions are you seeing most accelerated with all these AI tools? Is it engineering? Is it something else? And then are there tools that have been most helpful to you? Just AI tools for folks who'd be like, "I should check it out." I'm guessing Cursor, but curious if there's anything else.

**中文翻译:**
我很喜欢你既有 Meta 这种巨头公司的经验，现在又在创办自己的小型初创公司，正处于这种“保持极小规模、极度精简、每个人承担更多工作”的趋势中。你能亲历这种转变真的很酷。我有几个问题：在所有这些 AI 工具的加持下，你看到哪些职能被加速得最厉害？是工程吗？还是别的？另外，有哪些工具对你最有帮助？有没有什么 AI 工具是你会推荐大家去尝试的？我猜有 Cursor，但好奇还有没有别的。

---

### [00:22:04] Julie Zhuo

**English:**
Yeah, certainly engineering is one that, I mean, most of our company is engineers, so that's the one that we focused on a bunch. I certainly do see more people also prototyping things. We have two designers, but we also see engineers. We have a team that's called product science, which is this interesting blend of you can think about it as like a forward deployed person who has a lot of data analysis background and is kind of playing a customer success role and also kind of playing a product role. And you see them starting to take on building more prototypes or getting into some of the engineering. And so it's really lovely to see that blend of everyone can do a little bit of everything else and we're all encouraging each other. The other thing that recently we've also been trying to do a lot more is just obviously we say, "Hey, engineer, now you can do analysis."

(00:22:59):
And their first thing is like, "Oh, I don't really know analysis." This is where ChatGPT comes in. And it's like traditionally we would say, "Well, I have to learn that from a human. I have to ask this person and now I'm going to take a bunch of their time because I want them to explain everything to me." And in fact, I think these days ChatGPT or these other AI tools are better teachers. I find that we tend to maybe not use them quite as much just for the purposes of accelerating our education or even going through something. Sometimes what I'll do is I'll find a curriculum online. And if you take a course, it'll be like this 12 week curriculum and I'll just feed it into ChatGPT and I'll say, "Help me customize a program for me using the ways that I like to learn."

(00:23:43):
I am a person who really needs examples. I need a lot of explain like I'm five. Give me an analogy. And I know some other people on my team are like, "These examples don't make any sense." We're different types of learners and so the idea of a tool that personalizes learning for each of us really helps us, I think, accelerate and just learn these skills much faster than before. So yes, the tools are great. We can use Cursor, it helps us, it autocompletes, it writes a bunch of things, but the acceleration of learning I think is another maybe underutilized tool in all of our arsenals just because I know whenever I talk to people, we forget. We don't think that, wait, yes, we could be doing that and just sitting down and probably in 30 minutes or an hour learn so much faster than what we used to be able to do before.

**中文翻译:**
是的，工程绝对是其中之一。我们公司大部分是工程师，所以这是我们关注的重点。我也确实看到更多人在做原型开发。我们有两个设计师，但也看到工程师在做这些。我们有一个叫“产品科学”的团队，这是一个有趣的混合角色，你可以把它想象成一个拥有深厚数据分析背景的前线人员，既扮演客户成功角色，又扮演产品角色。你会看到他们开始承担更多的原型构建或参与工程工作。看到这种“每个人都能做一点别人的工作”并互相鼓励的融合，真的很棒。另一件我们最近尝试做更多的事是，显然我们会说：“嘿，工程师，现在你可以做分析了。”

(00:22:59):
他们的第一反应通常是：“哦，我不太懂分析。”这时 ChatGPT 就派上用场了。传统上我们会说：“我得向人请教。我得问某某人，然后占用他们大量时间，让他们给我解释一切。”事实上，我认为现在的 ChatGPT 或其他 AI 工具是更好的老师。我发现我们可能还没有充分利用它们来加速教育或自学。有时我会从网上找一个课程大纲，比如一个 12 周的课程，然后把它喂给 ChatGPT，说：“根据我喜欢的学习方式，帮我定制一个学习计划。”

(00:23:43):
我是一个非常需要例子的人。我需要大量的“像对五岁小孩解释那样”的说明，给我打比方。而我团队里的其他人可能会觉得“这些例子莫名其妙”。我们是不同类型的学习者，所以这种能为每个人提供个性化学习的工具，真的能帮我们加速，比以前快得多地掌握这些技能。所以，是的，工具很棒。我们可以用 Cursor，它帮我们自动补全、写代码，但“学习的加速”我认为是大家武器库中另一个被低估的工具。因为每当我与人交谈时，发现大家都会忘记这一点。我们没意识到，其实坐下来花 30 分钟或一小时，就能学得比以前快得多。

---

### [00:24:49] Lenny Rachitsky

**English:**
That's such an interesting point. There's these tools that are in the just in time, helping you move faster, but you also need to learn how to do something, some foundational lessons. What's an area that your team did that? What did they work on learning?

**中文翻译:**
这观点很有趣。有些工具是“即时”的，帮你跑得更快，但你也需要学习如何做某事，学习一些基础课程。你的团队在哪个领域尝试过这样做？他们学习了什么？

---

### [00:24:55] Julie Zhuo

**English:**
So I'll give you an example. I was just talking to an engineer this morning and he's written a bunch of these algorithms. So one of the things our company does is we're trying to automate data analysis, so one of the things we have to do is obviously understand the best practices. If there's a type of question, "Hey, what features are really the ones that people pay for?" We need to kind of figure out what is the right analysis to do. And so the engineer was saying to me, "Julie, I feel like I really understand the how. I know the algorithms, I know we do root cause analysis, how we do that. But what I don't really understand is why or when this would be most useful. In what context in a company would this company come up?" Because he's an engineer, he hasn't done that job of being a PM or an executive that asks these types of questions. And that was like the perfect thing where yeah, traditionally you might've asked someone, but this is more general purpose. There's so much resources in the world on the internet about it. This is like the perfect type of question where if you just talk to ChatGPT, it's probably going to give you a much better answer and allow you to go deeper.

(00:25:55):
And a secondary thing we've been learning too is this idea of, almost like as a... Using ChatGPT it's for to test your learning. So explains a bunch of things. And so what I often like to do is like, "Okay, I read this, so this..." I try to explain back what I heard. "So does this mean... Is that right way to think about it, that this is kind of like this analogy?" And ChatGPT will critique me. "Yes, that is right," or "No, you didn't quite get that right. In fact..." And it always tries to say it nicely. This is a funny part. It'll be like, "That's close, and then eventually it's like, "You were completely wrong." Just in the style. But it helps so much because it's interactive and so we can really test whether we really understand the concept by trying to retell it back in our own way.

**中文翻译:**
我给你举个例子。今天早上我刚和一个工程师聊过，他写了一堆算法。我们公司做的是自动化数据分析，所以我们必须理解最佳实践。如果有一个问题：“嘿，哪些功能是用户真正愿意付费的？”我们需要弄清楚正确的分析方法是什么。那个工程师对我说：“Julie，我觉得我非常理解‘怎么做’（How）。我知道算法，我知道怎么做根因分析。但我不太理解的是‘为什么’（Why）或者‘什么时候’（When）这最有用。在公司的什么语境下会提出这种问题？”因为他是工程师，他没做过 PM 或高管，没提过这类问题。这就是一个完美的场景：传统上你可能会问人，但这是通用知识，互联网上有海量资源。这种问题如果你去问 ChatGPT，它可能会给你一个好得多的答案，并让你深入钻研。

(00:25:55):
我们学到的第二件事是，利用 ChatGPT 来测试你的学习成果。它解释了一堆东西后，我通常喜欢说：“好，我读了这些，所以这意味着……我这样理解对吗？这就像是这个类比吗？”然后 ChatGPT 会批评我：“是的，没错，”或者“不，你没完全理解对，事实上……”它总是试着委婉地表达。这很有趣，它会说“很接近了”，然后最后其实是想说“你完全错了”。但这种互动非常有帮助，因为我们可以通过用自己的话复述来真正测试自己是否理解了某个概念。

---

### [00:27:38] Lenny Rachitsky

**English:**
It's incredible just how many ways all this AI breakthrough is helping us advance and do more and learn more and become better. I know there's some downsides, but this is incredible. So many ways of getting better and faster. I want to spend a little more time on this data analysis stuff. So again, you have such an interesting trajectory from working at a big company to starting your own small company. From being head of design to now being obsessed with data and analytics. So let me spend a little time there. What do AI companies that have kind of figured out how to use AI for data analysis and data work, doing differently, what are people missing and sleeping on in terms of getting better at working with data? And let me just add this point. It feels like we're almost working through , here's all the blockers to a team moving forward. There's like waiting for the PM to write the PRD and then there's waiting for the data scientists to give you answers analysis. So this is another really cool unblock that every team member will have.

**中文翻译:**
AI 的突破在这么多方面帮助我们进步、做得更多、学得更多、变得更好，这真的很不可思议。我知道有负面影响，但这确实太棒了。有这么多变强变快的方法。我想在数据分析这块多花点时间。再说一次，你的职业轨迹很有趣，从大公司到小公司，从设计负责人到痴迷数据。那些已经弄清楚如何利用 AI 进行数据分析和数据工作的 AI 公司，他们的做法有什么不同？在提高数据工作效率方面，人们错过了什么或忽视了什么？我再补充一点：感觉我们正在逐一扫清团队前进的障碍。以前是等 PM 写 PRD，然后是等数据科学家给分析结果。所以这是每个团队成员都能获得的另一个超酷的“解锁”。

---

### [00:28:00] Julie Zhuo

**English:**
So your first question was how are a bunch of AI companies using data? So the funny thing, my funny answer to this is, I don't actually think a lot of the fast-growing companies are using data well at this point. And the main reason why is because traditionally things just didn't grow that fast. And so if you got to a hundred million users, your company has probably been around for a while, and if your company has been around for a while, you've had time to set up things like logging and you've hired a growth team at that point and you've hired a data team and they've done a bunch of work to log an instrument and then transform the data. And we've talked about what is the observability for our business. And you just usually had years to build and develop that, because of the rate of growth.

(00:28:25):
And so today we see companies that are growing insane and there's still about 10 people or two people or however many people, but they've got hundreds of millions in ARR and hundreds of millions of users. And you know what? They don't actually have all of that infrastructure, that logging, to be able to truly do data analysis. So I would say that these companies are totally getting by on just good instincts and good vibes and we see that. You don't really need data analysis to sometimes make something that works. But I think what data helps us do is in my mind it sort of is helping us reflect back what is really reality. And so of course if ARR growing, awesome, great, keep doing what you're doing. But what always happens is eventually things stop growing. Growth does not happen forever. And usually when growth stops, everyone has this question of, "What's going on? Why did it happen?".

(00:29:22):
And then you start to be able to see the power of, if you've instrumented everything very well and you have a very good observability model for your business, it's much easier to start to get into the root cause, it's easier to even predict whether growth will slow down at a certain point, it's easier to catch these trends earlier. If you don't have good observability over how your business runs and what the company's key levers are, then you will be scrambling, and at that point, that's usually when people start investing a ton in data. So I wouldn't say that a lot of these hot companies are quite there yet, but what I also think is a trend is that every time there's a new technological shift, we actually have to change the way that we think about... Analysis has to answer the questions that we have, and if technology changes or context changes, we need new methodologies of analysis.

(00:30:16):
So for example, when mobile came to the forefront, looking at sessions or sessions per day or time spent on mobile, or length of sessions became something that was important for us to understand, are people getting value in this new medium? I think that's the same with what we have today. Conversational analytics is totally different. Used to be, let's say in the Google world, I knew you were interested in shopping if you click the shopping tab, I know you're interested in maps if you click the maps tab, we can measure clicks. Today it's just all conversation, and so it's actually harder for us to tease apart what is the user intent.

(00:30:55):
If I worked on any of these LLM, I would say one of probably the biggest questions is, hey, what use cases are growing or what use cases are shrinking? And that's much harder to tell today because it's not just clicks on tabs or pages. It's like we have to probably use an LLM or a machine learning model to bucket user intent. We probably have to ask questions like, is the flow going really well in conversations? Like, if I just ask one question and I don't go back and forth, did the user get value? It's always trying to get back to, we're trying to figure out if this was a good experience, but now it's like we need to actually invent new methodologies to help us analyze that.

**中文翻译:**
你第一个问题是 AI 公司如何使用数据。我的趣答是：我不认为目前很多快速增长的公司把数据用得很好。主要原因是，传统上事物增长没那么快。如果你达到一亿用户，你的公司可能已经存在一段时间了，你会有时间建立日志记录（Logging），雇佣增长团队和数据团队，做大量的埋点和数据转换工作。我们谈论业务的可观测性（Observability），因为增长率的关系，你通常有数年时间来构建这些。

(00:28:25):
而今天，我们看到一些公司增长极其疯狂，却只有 10 个人或 2 个人，但他们有数亿的 ARR（年度经常性收入）和数亿用户。你猜怎么着？他们其实并没有那套能真正进行数据分析的基础设施和日志系统。所以我会说，这些公司完全是靠敏锐的直觉和良好的氛围在维持，我们也看到了这一点。有时候你确实不需要数据分析也能做出成功的东西。但我认为数据在我的心目中是帮助我们反映现实。如果 ARR 在增长，太棒了，继续做。但最终增长总会停止，增长不会永远持续。通常当增长停止时，每个人都会问：“怎么回事？为什么会这样？”

(00:29:22):
那时你就能看到数据的力量。如果你做好了埋点，对业务有很好的可观测性模型，就更容易找到根因，甚至预测增长何时会放缓，更早发现趋势。如果你对业务运作和关键杠杆缺乏可观测性，你就会手忙脚乱，那时人们通常才开始在数据上投入巨资。所以我不会说这些热门公司已经做得很好了。但我认为还有一个趋势：每当有新的技术变革，我们必须改变思考方式。分析必须回答我们的问题，如果技术或语境变了，我们需要新的分析方法论。

(00:30:16):
例如，当移动互联网兴起时，观察会话数（Sessions）、每日会话数、移动端时长或会话长度变得至关重要，以了解用户是否在这个新媒介中获得了价值。我认为今天也是如此。对话式分析（Conversational analytics）完全不同。以前在谷歌的世界里，如果你点击购物标签，我就知道你对购物感兴趣；点击地图标签，我就知道你对地图感兴趣。我们可以衡量点击。而今天全是对话，所以更难梳理出用户的意图。

(00:30:55):
如果我在做大语言模型（LLM），最大的问题之一可能是：哪些用例在增长，哪些在萎缩？这在今天很难判断，因为不再是点击标签或页面。我们可能需要使用 LLM 或机器学习模型来对用户意图进行分桶。我们可能需要问：对话流程顺畅吗？如果我只问了一个问题就没下文了，用户获得价值了吗？我们总是试图弄清楚这是否是一次良好的体验，但现在我们需要发明新的方法论来帮助我们分析这一点。

---

### [00:31:40] Lenny Rachitsky

**English:**
Yeah, I think the question is always like with conversation, do you want it to be a long conversation, do you want it to be a short conversation? What's the right answer, what's better?

**中文翻译:**
是的，关于对话的问题总是：你希望它是一次长对话，还是短对话？正确答案是什么，哪种更好？

---

### [00:31:47] Julie Zhuo

**English:**
Yes.

**中文翻译:**
没错。

---

### [00:31:48] Lenny Rachitsky

**English:**
I had a ChatGPT on the podcast, Nick Turley, and turns out one of the ways they found the most common use cases early on was watching TikTok comments and things going viral on TikTok after they launched. How about that?

**中文翻译:**
我采访过 ChatGPT 的 Nick Turley，结果发现他们早期发现最常见用例的方法之一，是观察 TikTok 上的评论以及发布后在 TikTok 上疯传的东西。这方法怎么样？

---

### [00:32:01] Julie Zhuo

**English:**
Yep, yep.

**中文翻译:**
是的，没错。

---

### [00:32:02] Lenny Rachitsky

**English:**
Okay, so I want to come back to this really interesting, unusual path that you took from being a head of design at Facebook, you're an inspiration to so many designers, now you spend your time on a data startup obsessed with data. I don't know, classically designers aren't the biggest fans of experiments and data and making decisions based on data. When you look at designers and you hear designers kind of push back on like, "No, we don't want to be super data driven, we know better than... We have a sense of what's beautiful and great and intuition," all these things, what do you think designers are missing when they feel that and say that when they're afraid of writing experiments and data and kind of want to push that out?

**中文翻译:**
好，我想回到你这条非常有趣且不寻常的路径：从 Facebook 的设计负责人（你是这么多设计师的灵感来源），到现在经营一家痴迷于数据的数据初创公司。传统上，设计师并不是实验和数据的拥趸，也不喜欢基于数据做决策。当你看到设计师们抵触说“不，我们不想过度数据驱动，我们更懂……我们对美和卓越有直觉”时，你认为当他们害怕实验和数据并想排斥它们时，他们错过了什么？

---

### [00:32:46] Julie Zhuo

**English:**
There's one phrase that my co-founder and I would always discuss with amongst ourselves very early on in which we shared with a lot of the companies that we work with, which is, what you really want is you want to diagnose with data and treat with design. So data is not a tool that's going to tell you what you should build or what the solution is or how we're going to cure the fact that you don't have really great retention. It's just not. But it can tell you if you have a problem and where that problem or opportunity might be. But you still need to go back and undergo a very creative process to figure out what's the best way to solve that. So that's the first thing I would say, is this framework of, data helps you figure out what's actually happening, what do people like, what are they engaging with, what what not.

(00:33:32):
It just gives you a story that better reflects reality. Because again, we all have stories. We're like, "Oh, my company's amazing, people love us," blah, blah. That's the story I want to believe, but reality may be a different picture. And so what data is trying to do is capture reality. And by the way, I don't think of data just as it's an AB test and it's quantitative things we can measure. To me data is also, well, what did people put onto TikTok and which things went viral, and what are they saying in the Twitter verse or X verse I guess is what it's called now.

(00:34:07):
And if you do a customer interview, that's still all data, it's just that that is a little harder to distill and quantify. Although now with AI, we have better tools for synthesizing. So that's all data in my mind and it's just all trying to help us understand what is really happening, what is the phenomenon that's happening in reality and how do we understand it? You still have to go and invent and create and dream, and there's no formula and there's no science that will tell you exactly how you're going to make a hit. You can experiment, which allows you to try more things maybe and more rigorously understand what that does in the short term. It's all very contextualized. A-B tests don't tell you what will happen in the very long run, and again, it's all still data, you still have to synthesize and figure out what to do.

(00:34:57):
So that's the thing, I'll say. Diagnose with data and treat with design. The second thing I will usually tell designers about, is I find that sometimes, and maybe it's the, let's call it the false precision of numbers that we kind of fall into, right? Because it's like, okay, we got these numbers and the numbers go up. It's like no, the fact that you still have to choose which things you look at, is an art, not a science. And your interpretation of if the number went up 5%, is that good, is that not good, is also an interpretation and is an art, not a science. It's just that sometimes I think we can give ourselves this feeling, and I get it, sometimes there's this instinct to want to control things and we want everything to be buttoned up, and we want to know that if we did ABC, everything will be great, our career's going to be awesome, our product's going to rocket ship.

(00:35:49):
And I think designers are rightly often pushing back and saying, "No, the reality is this stuff is ambiguous and there's uncertainty and we can never know for sure." And I think all that is quite true. So the other thing I would say that I really support is you just actually can't make a really great product by thinking you can A-B test your way into it. So I fundamentally believe that, but I don't think we should throw the baby out with the bathwater. I think there's actually... You know? It's not either or, it's not like data or design.

(00:36:18):
It's like these are just tools for us to use, and I would say every amazing designer that I've ever met is absolutely obsessed with trying to get a better understanding of reality. They want to know what users really think, they want to know what they're really doing. If they could read every user's minds, that's the thing we would all want as a designer is like, if I could just know what everyone is thinking, feeling every time they used it, my life would be a lot easier, because then I would be able to build better and better things. And so that's what it's trying to help us do. It isn't perfect, no metric is going to tell you whatever we hope that it can in terms of the true certainty and precision, but it doesn't mean we can't use it to better our product development.

**中文翻译:**
我和我的联合创始人很早就讨论过一句话，我们也常分享给合作的公司：你真正想要的是“用数据诊断，用设计治疗”。数据不是一个会告诉你该建造什么、解决方案是什么，或者如何解决留存率低的问题的工具。它不是。但它可以告诉你是否存在问题，以及问题或机会可能在哪里。但你仍然需要回到一个非常有创造力的过程中，去弄清楚解决问题的最佳方法。所以我要说的第一点是这个框架：数据帮助你弄清楚实际发生了什么，人们喜欢什么，他们在参与什么。

(00:33:32):
它只是给了你一个更贴近现实的故事。因为我们都有自己的故事，比如“哦，我的公司很棒，人们爱死我们了”等等。那是我愿意相信的故事，但现实可能是另一番景象。数据试图做的就是捕捉现实。顺便说一下，我不认为数据仅仅是 AB 测试或我们可以衡量的定量指标。对我来说，数据也包括人们在 TikTok 上发布了什么，哪些东西疯传，以及他们在 Twitter（现在叫 X）上说什么。

(00:34:07):
如果你做一次客户访谈，那仍然是数据，只是更难提取和量化。虽然现在有了 AI，我们有了更好的合成工具。在我看来，这些都是数据，都是为了帮助我们理解真实发生了什么，现实中的现象是什么，以及我们如何理解它。你仍然需要去发明、创造和梦想，没有任何公式或科学能准确告诉你如何制造爆款。你可以做实验，这让你能尝试更多东西，并更严谨地理解短期效果。这都是非常情境化的。AB 测试不会告诉你长期会发生什么，而且这仍然是数据，你仍然需要综合分析并决定怎么做。

(00:34:57):
所以这就是我要说的：用数据诊断，用设计治疗。第二点我通常会告诉设计师的是，我发现有时我们会陷入所谓的“数字的虚假精确性”中。比如数字上升了，我们就觉得好。但事实上，选择看哪些指标本身就是一门艺术，而非科学。你对“数字上升 5% 是否算好”的解读也是一种解读，是艺术而非科学。有时我们会有这种想要控制一切的本能，希望一切都井井有条，希望知道只要做了 ABC，一切都会变好，职业生涯会很棒，产品会一飞冲天。

(00:35:49):
我认为设计师们抵触是对的，他们会说：“不，现实是模糊的，存在不确定性，我们永远无法确切知道。”我认为这非常正确。所以我支持的另一点是：你确实无法仅靠 AB 测试就做出伟大的产品。我深信这一点，但我不认为我们应该“把婴儿和洗澡水一起倒掉”。这不是非黑即白的选择，不是数据或设计。

(00:36:18):
它们只是供我们使用的工具。我会说，我见过的每一位优秀的设计师都绝对痴迷于更好地理解现实。他们想知道用户真正是怎么想的，真正是怎么做的。如果能读懂每个用户的心，那是每个设计师的梦想——如果我能知道每个人在使用产品时的想法和感受，我的生活会轻松得多，因为那样我就能做出越来越好的东西。这就是数据试图帮我们做的事。它不完美，没有任何指标能提供我们所希望的那种绝对确定性和精确性，但这并不意味着我们不能用它来改进产品开发。

---

### [00:37:03] Lenny Rachitsky

**English:**
I was going to say exactly what you just said, which is every great designer that I've worked with was obsessed with data in the most leaning into the data, versus designers that are just like, "Nah, I think I'm good, I have a sense of what's right, and why would we let that tell us what to do?" And to your point, it's not going to tell you what to do, it'll tell you where opportunities arise. Let me take us back to the management chat and maybe just let me ask something broad. What do you feel is the biggest change in the role and day-to-day work and life of a manager these days with the rise of AI?

**中文翻译:**
我正想说你刚才说的那点：我合作过的每一位优秀设计师都对数据非常痴迷，非常主动地拥抱数据；而那些说“不，我觉得我挺好，我有感觉什么是对的，为什么要让数据告诉我们怎么做”的设计师则相反。正如你所说，数据不会告诉你该做什么，它会告诉你机会在哪里。让我们回到管理的话题，我想问一个宏观的问题：随着 AI 的兴起，你觉得如今管理者的角色、日常工作和生活最大的变化是什么？

---

### [00:37:34] Julie Zhuo

**English:**
I think that managing change. It's always been manager's job to manage change, and there's always the chaos of what's going on. I just think the rate of change is accelerating, and we've seen that over the last couple of decades. And so I find that there's just a great deal more uncertainty that people have about things, like where is AI going to be in two years from now? I don't know. Who really knows? And so are we going to have AGI in five years? That kind of changes a lot about the landscape. Not to mention, I think there's quite a lot of fear that many organizations are feeling. It's like if my career has always been in design and now these tools are getting better and better at what I'm doing, then holy shit, what happens to my career and my future? And do I need to pivot? Do I need to learn different things?

(00:38:25):
And so it's this change, it's this feeling of uncertainty. And I think a lot of times managers have to deal with that in addition to what you were saying before, which is they also have to learn these new skills, which is managing AI and managing these more powerful tools in their arsenal of trying to get things done. So that is very different, I think, than maybe 10, 20, 30 years ago. And so I think that the skills that become more important are obviously communication, feedback, compassion, but just being able to work with humans and to have them understand that yes, we are in a state of change. I think every leader has to do this now, every startup founder that I know, every CEO, is how do you land this message that things are changing and we need to be very open to change?

(00:39:16):
If we go and stick to our old ways, we're probably going to get left behind, our product's going to get left behind, even our way of doing things is going to be left behind. So we need to change. We need to change our product and we need to change the way that we work, as we all talked about in terms of smaller teams, more nimble, blah, blah, blah. But at the same time it's like, how do we do that in a way that doesn't just freak everyone out? And it's like, "Ah, it's chaos. Everything's changing.".

(00:39:44):
So I think about this metaphor a lot, of the willow tree, which is the willow tree is a very sturdy tree. It can survive a lot of storms, disasters, et cetera, but it's also very flexible. The branches are very, very flexible, and that's in some ways what allows it to be very sturdy. So I think today, management is really about this idea of be sturdy while being flexible, and that is a very hard thing to pull off, but I think that's at least when I even go into... I'm like, "Be like the willow tree, Julie. Just imagine the willow tree and try and channel that as the kind of feeling of what it is that we're trying to do together."

**中文翻译:**
我认为是管理变化。管理变化一直是管理者的工作，总会有各种混乱发生。我只是觉得变化的速率在加快，我们在过去几十年里已经看到了这一点。我发现人们对事物有更多的不确定感，比如“两年后 AI 会发展到什么程度？”我不知道，谁真的知道呢？“五年后我们会拥有 AGI 吗？”这会极大地改变格局。更不用说，我认为许多组织内部存在相当多的恐惧。比如“如果我的职业生涯一直是做设计，而现在这些工具在我所做的事情上变得越来越强，那么天呐，我的职业和未来会怎样？我需要转型吗？我需要学习不同的东西吗？”

(00:38:25):
所以这就是这种变化，这种不确定感。我认为很多时候管理者除了要处理你之前提到的那些——学习管理 AI、管理武器库中更强大的工具以完成工作——还要处理这些情绪。我认为这与 10、20、30 年前非常不同。因此，变得更重要的技能显然是沟通、反馈、同理心，以及与人合作并让他们理解：是的，我们正处于变革状态。我认为现在的每位领导者、我认识的每位初创公司创始人、每位 CEO 都必须做到这一点：你如何传达“世界正在改变，我们需要对变化保持开放”的信息？

(00:39:16):
如果我们坚持老一套，我们可能会被抛弃，我们的产品会被抛弃，甚至我们的工作方式也会被抛弃。所以我们需要改变。我们需要改变我们的产品，改变我们的工作方式，就像我们讨论的小团队、更灵活等等。但与此同时，如何以一种不让所有人惊慌失措的方式来做这件事？而不是让人觉得“啊，太乱了，一切都在变”。

(00:39:44):
所以我经常想到柳树这个比喻：柳树是一种非常坚固的树，它能挺过许多风暴和灾难，但它同时也非常柔韧。它的枝条非常灵活，这在某种程度上正是它能保持坚固的原因。所以我认为今天的管理核心在于“在保持灵活的同时保持坚定”。这很难做到，但至少当我面对这些时，我会对自己说：“Julie，要像柳树一样。想象那棵柳树，并试着把那种感觉融入到我们共同努力的目标中。”

---

### [00:40:23] Lenny Rachitsky

**English:**
This reminds me of a couple things from other guests. I had Marc Benioff on the podcast and I asked him, "Just how do you deal with all this change? It's like agents now, it was, I don't know, there's AGI coming as you said, just like, "How do you survive through this?" And his advice is just, he's like, "I'm always just like, 'Good. This is great. This is what we want. This is exciting. We have so much opportunity, it's just not boring. We can always reinvent.'" And he's always embracing with "This is good." And just I'll never forget the way he responded to that.

**中文翻译:**
这让我想起了其他嘉宾说过的几件事。我采访 Marc Benioff 时问他：“你如何应对所有这些变化？现在是智能体，以前是别的，正如你所说 AGI 也要来了，你如何挺过来？”他的建议是，他总是说：“好极了。这太棒了。这就是我们想要的。这令人兴奋。我们有这么多机会，这至少不无聊。我们总能重新发明。”他总是以“这很好”的心态去拥抱变化。我永远不会忘记他当时的回答。

---

### [00:40:55] Julie Zhuo

**English:**
I think if you don't think it's good, it's kind of a painful way to live. It'll be very, very difficult over these next. So I do think that all things be equal, lean into it. If you can wake up every day and see it as opportunity and excitement rather than fear, again, they're all flip sides of the same coin, but I think if we can lean more into what could it be, while recognizing that the other side does exist and it's still there. And I think if managers who try to pretend like it isn't there, it's all good, no one's upset, et cetera, there's something also missing about just addressing and being able to be like, yeah, it's hard. Change is hard. We're probably going to get upset. We're going to have some chaos. This is going to happen, but we will work through it because we're going to be flexible and we're going to be able to put our eyes on the big picture of what is possible, which is exciting.

**中文翻译:**
我认为如果你不觉得这很好，那生活会变得很痛苦。接下来的日子会非常艰难。所以我觉得在同等条件下，应该积极拥抱它。如果你每天醒来能把它看作机会和兴奋点而不是恐惧——当然，它们是同一枚硬币的两面——但如果我们能更多地关注“可能性”，同时承认另一面确实存在。我认为如果管理者试图假装恐惧不存在，假装一切都好，没人不开心，那也缺失了一些东西。你应该能够直面它并说：“是的，这很难。变革很难。我们可能会感到沮丧。会有一些混乱。这一定会发生，但我们会挺过去的，因为我们会保持灵活，我们会把目光投向‘什么是可能的’这个宏大愿景，这很令人兴奋。”

---

### [00:41:45] Lenny Rachitsky

**English:**
There's another quote that and came up as you were talking. I forget who it was exactly, maybe Kevin Wheal, maybe Mike Krieger. They said that this is the most normal things will be, ever. Like, it will only get weirder. And I think giving people that sense of like, okay, just enjoy this normal, because this is going to be only weirder, is we'll at least give people an expectation, real expectations where things might be going.

**中文翻译:**
当你说话时，我想到了另一句话。我不记得是谁说的了，可能是 Kevin Weil 或 Mike Krieger。他们说：“现在是未来最‘正常’的时候了。以后只会变得越来越怪异。”我认为给人们这种感觉——“好吧，享受现在的正常吧，因为以后只会更怪异”——至少能给人们一个预期，一个关于未来走向的真实预期。

---

### [00:42:11] Julie Zhuo

**English:**
Yes, yes.

**中文翻译:**
没错，没错。

---

### [00:42:11] Lenny Rachitsky

**English:**
What a time to be alive.

**中文翻译:**
真是个活在当下的好时代。

---

### [00:42:12] Julie Zhuo

**English:**
What a time.

**中文翻译:**
确实。

---

### [00:42:14] Lenny Rachitsky

**English:**
Okay, let me zoom out even further and chat about... I want to ask you just outside of AI, management in many ways is unchanged. It's still a lot of the same work, managing people, helping them be successful, producing great work. What are just some of the, I'd say most timeless, most important lessons that you think managers, especially new managers still don't totally understand, need to hear more? What are just some that come to mind? And then we'll see where this goes.

**中文翻译:**
好，让我进一步放大视角。我想问你，抛开 AI 不谈，管理在很多方面其实没有改变。它仍然是很多同样的工作：管理人、帮助他们成功、产出优秀成果。你认为有哪些最永恒、最重要的教训，是管理者（尤其是新任管理者）仍然没有完全理解、需要多听听的？你脑海中首先浮现的是哪些？

---

### [00:42:43] Julie Zhuo

**English:**
The first thing that comes to mind is the importance of managing yourself and understanding yourself. This was chapter five of my book. It's called Managing Yourself. In fact, when I wrote it, I kind of wanted it to be chapter one, and then my publisher was like, "Well, maybe you should get into some of the tactical..." People don't necessarily think managing other people or manage a team starts with them, but I really do fundamentally believe this, because I think all of us, of course, like any human being, we have things that we're strong at, we have things that we're weak at. And I am a very big believer that every strength is its own weakness, and every weakness is a strength.

(00:43:18):
There's no such thing as you're going to somehow get every dimension to be 100%. In fact, I think one of the most interesting concepts or frameworks for myself, and also even, this is also kind of like a data framework concept, is this concept of dimensionality. So what dimensionality means is you're a human being, but we can kind of look at you in infinite dimensions. There is, for example, how good is Lenny at throwing an ax? That's one dimension.

**中文翻译:**
我首先想到的是管理自己和了解自己的重要性。这是我书中的第五章，叫《管理自己》。事实上，我写的时候想把它放在第一章，但我的出版商说：“也许你应该先讲一些战术性的东西……”人们不一定认为管理他人或管理团队是从管理自己开始的，但我深信这一点。因为我认为我们所有人，就像任何人类一样，都有擅长和不擅长的地方。我坚信“每种优势都有其对应的弱点，而每种弱点也是一种优势”。

(00:43:18):
不存在某种方法能让你在每个维度都达到 100%。事实上，我认为对我来说最有趣的概念或框架之一（这其实也像是一个数据框架概念）就是“维度”（Dimensionality）。维度的意思是，你是一个人，但我们可以从无限的维度来看待你。例如，Lenny 扔斧头的技术怎么样？这是一个维度。

---

### [00:43:49] Lenny Rachitsky

**English:**
Pretty good.

**中文翻译:**
还不错。

---

### [00:43:51] Julie Zhuo

**English:**
How good is Lenny at being a podcast moderator? Fantastic.

**中文翻译:**
Lenny 做播客主持人的水平怎么样？太棒了。

---

### [00:43:56] Lenny Rachitsky

**English:**
So-so. Okay, thank you.

**中文翻译:**
一般般啦。好，谢谢。

---

### [00:43:58] Julie Zhuo

**English:**
How good is Lenny at doing a zero to one type of project in the AI space? Right? So again, just can think about these as infinite dimensions. And the reality is each of our profiles is very unique, it's like a fingerprint. So for you it's like these are all these areas that you're really great at, much better, like in the top 1%. And then there's some areas where in the top 10%, then there's some areas where you're kind of average, and then there's some dimensions in which you're worse than average compared to other people. And that's just true for all of us. And what I like about that is therefore if you take that as the model, you realize that none of these dimensions are you entirely. So I can make a comment like "Lenny, your ax throwing really could use some improvement."

(00:44:48):
And ideally you're not like, "Julie is saying I'm a bad person, my identity is at risk," right? Because it's just one dimension of who you are. But what happens sometimes is that we can get very attached to certain dimensions because we start to think that that's who we are. And I think managers can do that, and clearly individuals on their teams. And when that happens, it starts to get very difficult to have, I think more objective conversations about, okay, what can you get better at? What can get worse at? And so I say all this because I think this framework for me at least, and many people that I've talked to, has helped them realize that somebody can give you feedback or you can be maybe not great at certain dimensions, you can have room to improve, and that's not who you are because you are all of these infinite dimensions in one, and none of them is representative of your true worth as an individual.

(00:45:42):
I'm a big believer that we are all beautiful and worthy, and sure we have all of these skills and we want to improve those skills, but it does not speak to whether we are worthy or not by saying whether we are strong or weak in these skills. And so I think if you can take that and really internalize that, then you can look at yourself a little bit more objectively as a manager, and you can realize that there are areas where you're going to be really strong, there are areas where you have biases, and often they are one and the same. So I'll give an example. People have often told me, I would get this in my performance reviews from managers in the past, like, "Hey Julie, you're really thoughtful. So when you think about something, you have a way to think about it, you've clearly thought about it in depth and you've got these frameworks and all this. That's a great thing.". And then on the flip side, I'll get feedback like, "Well, Julie, you don't really say a lot in a dynamic discussion. You're kind of quiet and you don't really think that quickly on your feet." And what you realize is these are kind of, again two... Because I don't do that and I'm not just off the cuff, that's what allows me to oftentimes be very, very thoughtful, or at least, okay, when I was younger, it's very clear that that particular weakness also very much is speaking to a particular strength, which is I am the kind of person that doesn't always have a snap judgment. I have to really think about it and internalize it and sometimes get to how I feel, and then I can share it and present it in the world.

(00:47:18):
And so just knowing that about me is supremely helpful. Now doesn't mean of course that I can never get better at this thing, but what I often think about is mastery is where we realize that both of these we can get better at, and what we want to do is just figure out in the context, what makes sense to be. So I got this feedback and I'm like, "Cool, one of the things I need to work on, is figuring out how to be more open in person, how to speak a little bit more clearly in person, maybe say things like, 'I don't know exactly how I feel about it yet, but this is what I'm thinking right now,'" if there's still clear tactics that will allow me to be a more effective team member and to do a better job in the context of what I'm trying to do with my team.

(00:48:04):
So I've tried to build those skills, but the meta skill is now being able to step back and say, okay, in certain context it is really important that we move fast and we are decisive and we just do something. And even if it's not perfect, we just kind of have to do it. And if I struggle with that, I should realize that that's an area to improve upon. But there are other contexts in which the right thing to do is actually to take a step back and be very thoughtful and to not rush into decisions.

(00:48:31):
And that's so what I want to get to is not like let's reject this strength or this weakness, but just know that that's where we come from, that naturally, we might be wired in a particular way. Our growth often looks like getting better at doing the opposite, but not rejecting again the thing that we're good at, but rather over time getting to this balance where we can read the context and the situation and know, "Should I lean a little more thoughtful or is this a time where I need to try and be a little more decisive and just share what's on my mind right now?"

**中文翻译:**
Lenny 在 AI 领域做从 0 到 1 项目的能力怎么样？对吧？所以，你可以把这些看作无限的维度。现实是，我们每个人的画像都是独一无二的，就像指纹一样。对你来说，有些领域你非常出色，处于顶尖 1%；有些领域处于前 10%；有些领域处于平均水平；还有些维度你比平均水平差。我们每个人都是这样。我喜欢这个模型的原因是，你会意识到这些维度中的任何一个都不能代表完整的你。所以我可以说：“Lenny，你扔斧头的技术确实需要改进。”

(00:44:48):
理想情况下，你不会觉得“Julie 在说我是一个坏人，我的身份受到了威胁”，对吧？因为那只是你作为人的一个维度。但有时我们会过度执着于某些维度，因为我们开始认为那就是我们的全部。我认为管理者会这样，团队成员也会。一旦发生这种情况，就很难进行客观的对话，比如：你可以在哪些方面做得更好？哪些方面可能会变差？我之所以说这些，是因为这个框架（至少对我以及我交谈过的许多人来说）帮助他们意识到，别人可以给你反馈，或者你在某些维度上可能做得不好，你有改进的空间，但这并不代表你这个人。因为你是所有这些无限维度的集合体，其中任何一个都不能代表你作为个体的真正价值。

(00:45:42):
我深信我们每个人都是美好且有价值的。当然我们拥有这些技能，也想提高它们，但技能的强弱并不代表我们是否有价值。如果你能真正内化这一点，你就能作为管理者更客观地看待自己。你会意识到有些领域你非常强，有些领域你有偏见，而这两者往往是同一件事。举个例子：过去我的上级在绩效评估中常对我说：“嘿 Julie，你非常深思熟虑。当你思考某事时，你很有条理，显然经过了深入思考，有框架等等。这很棒。”但另一方面，我也会收到反馈说：“Julie，你在动态讨论中话不多。你比较安静，反应没那么快。”你会意识到这其实是……正因为我不随口乱说，才让我能表现得非常深思熟虑。至少在我年轻时，很明显那个特定的弱点也对应着一个特定的优点：我不是那种总能立刻做出判断的人，我必须深入思考、内化，有时还要理清感受，然后才能分享并呈现给世界。

(00:47:18):
了解自己的这一点非常有帮助。这当然不意味着我永远无法改进，但我认为“精进”是指我们意识到这两方面都可以提高，而我们要做的就是根据具体语境判断该怎么做。所以我收到反馈后会想：“好，我需要努力的一点是，如何更开放地与人交流，如何更清晰地口头表达，也许可以先说‘我还不知道确切的感受，但我现在的想法是……’”如果有一些清晰的战术能让我成为更有效的团队成员，在团队背景下做得更好，我就去尝试。

(00:48:04):
我尝试培养这些技能，但“元技能”是能够退后一步说：在某些语境下，快速行动、果断决策并付诸实践非常重要，即使不完美也得做。如果我在这方面有困难，我应该意识到这是需要改进的地方。但在另一些语境下，正确的做法其实是退后一步，深思熟虑，不要仓促做决定。

(00:48:31):
所以我想达到的不是否定某种优势或弱点，而是了解我们的天性可能是某种方式。我们的成长往往看起来像是变得擅长做相反的事，但不是否定我们擅长的事，而是随着时间的推移达到一种平衡，能够审时度势：“我是该多思考一下，还是现在就该果断分享我的想法？”

---

### [00:49:54] Lenny Rachitsky

**English:**
I love this advice that things that we are incredible at and have a downside, and oftentimes the feedback we're getting is something we're not great at, there's a good version of that that people appreciate. And I was going to ask you, and I think you answered most of this, but just when you got this feedback of, "Hey Julie, you're not speaking enough in these meetings, you're not contributing quickly enough," it sounds like, so one option is just like, "Okay, cool, that's me, that's how I am, and I'm just going to solve the problem this other way and then just not going to change anything." What I heard you say is, find opportunities where you want to actually change that behavior, even though it doesn't come naturally in specific situations where things are moving fast. I guess just how far do you recommend people push themselves in things they're not great at, versus leaning further into their strength, let's say?

**中文翻译:**
我很喜欢这个建议：我们擅长的事情往往有其负面影响，而我们收到的反馈通常是我们不擅长的地方，但其实那背后也有人们欣赏的正面版本。我本想问你（虽然你已经回答了大部分）：当你收到“Julie，你在会上发言不够，贡献不够快”的反馈时，一种选择是“好吧，我就是这样的人，我会用别的方式解决问题，不打算改变”。但我听到你说的是，在特定节奏很快的情况下，即使不自然，也要寻找机会去改变这种行为。我想问，你建议人们在多大程度上强迫自己去做不擅长的事，而不是进一步发挥优势？

---

### [00:50:53] Julie Zhuo

**English:**
Oo, I think that's a really great question. So the way I think about it is it's very dependent on what is your goal. So for example, let's say that you are... Let's even take, for example, ICs versus managers. I think often about the pathway of an IC, an individual contributor, as wanting to deepen a craft. You love this thing and you just want to get better and better and better at this very specific skill or this craft, right? So think about in our dimension, infinite... It's like you pick a couple dimensions, "I just want these to be... I want to be the top 0.01%," and that's kind of the pathway of extending it as an IC. Now, if that's your high level goal and you're like, "I want to be able..." Let's say your high level goal is, "I want to be able to do this 10 hours a day because I love it and I want to be able to support myself doing it, meaning I get paid and I have a great job, and I want to have a bunch of impact in the world by doing this thing."

(00:51:03):
And if there is, awesome. Then if someone's like, "Hey, do you want to be a manager?" You're like, "Nope, don't need to because these are my goals and this pathway actually allows me to do that." But if somehow you get to a point where the skill you really want to perfect is not something that may be commercially viable in the world, that's going to somehow allow you to buy the big mansion that you want to buy to support your family, then I think you have to ask yourself, "Okay, so if I just do this, it's not going to cut it. I might actually need to learn some of these other skills in order to be able to fulfill the job that is going to be valuable enough that people are going to pay me a bunch of money at this certain level so that I can afford my mansion."

(00:51:43):
So I just think it has to go back to, what are your goals? And there are cases in which yes, it'll support your goal to do this and to deepen your craft. And there are cases in which it won't. And I think it's important, it's a very individual question for each person. But what I often think suffering is, is when these things are not aligned. So what you want is the giant mansion and all of that, but you're like, "But I also just want to spend on my time perfecting my egg omelet." And then, you're just in this tension place, and it's very hard to feel satisfied and fulfilled because you're a little bit like, "Oh, why doesn't the world value my deep egg omelet skills?" You can [inaudible 00:52:27] egg omelet, you should maybe not do this thing. Or if you want this thing, you may actually need to be better at just egg omelets. Perhaps you need to expand your repertoire of cuisines, and go and build a Michelin star restaurant or something.

**中文翻译:**
这是一个非常棒的问题。我的看法是，这很大程度上取决于你的目标是什么。例如，我们拿 IC 和管理者来对比。我认为 IC（个人贡献者）的路径通常是想要深耕一项手艺。你热爱这件事，只想在某个特定技能或工艺上变得越来越强。在无限的维度中，你选了几个维度说：“我只想在这些方面达到顶尖 0.01%。”这就是 IC 的延伸路径。现在，如果你的高层目标是：“我想每天做这件事 10 小时，因为我热爱它，而且我想靠它养活自己，有一份好工作，并产生影响力。”

(00:51:03):
如果这条路行得通，那太棒了。如果有人问：“嘿，你想当经理吗？”你会说：“不，不需要，因为我的目标通过这条路就能实现。”但如果有一天，你发现你想磨练的技能在商业上并不可行，无法让你买得起想买的大房子来养家糊口，那么你就得问自己：“好吧，如果我只做这个，那是行不通的。我可能需要学习其他一些技能，以便能胜任一份足够有价值的工作，让人们愿意付给我足够的钱去买大房子。”

(00:51:43):
所以我觉得必须回到：你的目标是什么？在某些情况下，深耕手艺能支持你的目标；而在另一些情况下则不能。这对每个人来说都是非常个性化的问题。但我认为“痛苦”往往源于这些东西不一致。你想要大房子，但你又说：“我只想花时间钻研怎么煎出完美的蛋卷。”然后你就陷入了紧张状态，很难感到满足，因为你会想：“为什么世界不重视我深厚的煎蛋卷技能？”如果你想要那个目标，你可能不能只做这一件事，或者你得把煎蛋卷做成米其林星级餐厅之类的。

---

### [00:52:39] Lenny Rachitsky

**English:**
This is really good advice. It's not just definitely always work on your weaknesses or don't worry about them, it's if you need to do this thing to achieve this goal that you have, make sure you understand what your goal is. And then is this thing a thing you need to work on? For example, [inaudible 00:52:52] become a VP, you probably need to be really good in big important meetings, and being on the spot, and just not waiting until everything's over and then sharing an email of all your thoughts.

**中文翻译:**
这是非常好的建议。不是说一定要补齐短板或完全不管它们，而是：如果你需要做这件事来达成你的目标，请确保你清楚自己的目标是什么。然后看这件事是否是你必须攻克的。例如，如果你想成为 VP，你可能必须擅长在重要的大型会议上即兴发言，而不是等会议结束才发邮件分享你的所有想法。

---

### [00:53:01] Julie Zhuo

**English:**
That's right.

**中文翻译:**
没错。

---

### [00:53:02] Lenny Rachitsky

**English:**
Yeah. For me, I actually went through a period where I was like, "I do not want to get promoted. I'm so happy in this very specific role, just leave me alone." And that path is very different from the skills I need to build to be a manager. And then things changed and then, okay, now these are the things I need to work on.

**中文翻译:**
是的。对我来说，我曾经历过一段时期，我觉得：“我不想升职。我对这个特定的角色非常满意，别管我。”那条路径所需的技能与成为管理者完全不同。后来情况变了，于是我意识到：“好吧，现在这些是我需要努力的方向了。”

---

### [00:53:17] Julie Zhuo

**English:**
Yeah. I love that you knew that about yourself, because I think it's so easy for a young person to go into their career and everyone is telling them, maybe their whole family has been telling them, "You need to level up, you need to get paid more. You need to get that manager title. You need to get a VP." And at a certain point, I think sometimes people opt into this without knowing what they're actually signing up for. What are the trade-offs? And is that really what you want to do? Does that really align with your passions? And of course, sometimes we have to... Again, it's a compromise for us, but we get to design. We get to design what are goals and what's the right pathway. And I go back to, usually when people are unhappy, it's because these things are a little bit out of sync. They want this big thing, but they're not actually excited about what it takes to do that thing, and therefore it's just going to be a mismatch.

**中文翻译:**
是的。我很欣赏你当时能了解自己。因为年轻人进入职场很容易被周围的人影响，家人可能会说：“你需要升级，你需要赚更多钱，你需要那个经理头衔，你需要当 VP。”在某种程度上，我认为有时人们在不知道自己到底在签什么协议的情况下就选择了这条路。代价是什么？这真的是你想做的吗？这真的符合你的热情吗？当然，有时我们需要妥协，但我们可以“设计”。我们可以设计目标和正确的路径。回到那句话，通常人们不快乐是因为这些东西脱节了：他们想要那个宏大的结果，但对达成结果所需的过程并不感兴趣，因此产生了错位。

---

### [00:54:09] Lenny Rachitsky

**English:**
And along those lines it sounds like, oh, sure, I can design my life and design my role. But what I find is if you at least first of all know what you'd love and ideally do, and then at least mention that to your manager, it often is a lot more possible than you think.

**中文翻译:**
顺着这个思路，听起来像是“当然，我可以设计我的生活和角色”。但我发现，如果你首先知道自己热爱什么、理想状态是什么，然后至少向你的经理提一下，通常实现的可能性比你想象的要大得多。

---

### [00:54:26] Julie Zhuo

**English:**
A hundred percent. I think it's so important to be... We often also have this mental model like, "Oh, our managers are our judge, and they're going to judge me on whether or not I did well, I should get a promotion, I should be fired." So there's this sometimes fear that people have, but I think in the very best relationships, the manager is like a guide. It's like, look, the manager has a job, and if you understand your manager's job, which is how to get better outcomes from the team, and also you understand what exactly would your manager consider success for the team, it also makes it easier for you to then be like, "Oh, well if I do this project, then that clearly seems like it's a very direct path to creating value for the team. And that also is a kind of project that suits my skills. It's something I'm excited about." You should suggest that to your manager.

(00:55:16):
But the other is true, right? So you would know that if you actually asked your manager, "What is your job and what do you consider success to be, and what is your greatest hopes and dreams?" And then you might be able to help your own career and yourself because you would know that context. And conversely, if you say, "Hey, manager, these are my hopes and dreams. This is what I think I'm good at. I really want to get better at this skill. I really want to get that VP promotion, but I don't know what it entails. Can you tell me, what does it take?" That's a really wonderful conversation as well because then you'll get all of that context, and then you can actually decide whether you want to do it or not. And if you want to, then ask your manager for help, "Okay, if you see opportunities that are going to help me become a better presenter or increase my communication, please tell me." Even better, "If you have feedback for me about communication, I want to hear it, because that's what's going to help me grow in this particular skill."

(00:56:11):
And so, it becomes this collaborative relationship much more so than this almost adversarial, like I'm trying to get you to give me a promotion, and you're trying to get me to work harder. That is not a very good vibe.

**中文翻译:**
百分之百同意。我认为这非常重要。我们经常有一种心理模型：“哦，经理是我的法官，他们会评判我做得好不好，我是该升职还是该被解雇。”所以人们有时会感到恐惧。但我认为在最好的关系中，经理更像是一个向导。经理也有自己的工作，如果你理解经理的工作（即如何让团队取得更好的成果），并且你理解经理认为团队的成功是什么，那么你就更容易说：“哦，如果我做这个项目，那显然是为团队创造价值的直接路径。而且这个项目也适合我的技能，是我感兴趣的。”你应该向经理提议。

(00:55:16):
反之亦然。如果你问经理：“你的工作是什么？你认为成功是什么？你最大的希望和梦想是什么？”你就能通过了解这些背景来帮助自己的职业生涯。相反，如果你说：“嘿，经理，这是我的梦想。这是我擅长的。我想提高这项技能。我想升职当 VP，但我不知道那意味着什么。你能告诉我需要具备什么吗？”这也是一段非常棒的对话，因为你会获得所有背景信息，然后你可以决定是否真的想做。如果你想，就向经理寻求帮助：“如果你看到能帮我成为更好的演讲者或提高沟通能力的各种机会，请告诉我。”甚至更好的是：“如果你对我的沟通有反馈，我想听听，因为这能帮我在这个特定技能上成长。”

(00:56:11):
这样，关系就变成了一种协作关系，而不是那种近乎对立的——“我试图让你给我升职，而你试图让我干更多活”。那种氛围可不太好。

---

### [00:56:28] Lenny Rachitsky

**English:**
It reminds me of a guest post by Ethan Evans that I'll link to that has a really good framework for how to actually do exactly what you're talking about called, The Magic Loop, where it's kind of a framework for figuring out what to work on and how to help your manager see you're capable of stuff and earn that trust.

**中文翻译:**
这让我想起了 Ethan Evans 的一篇客座文章，我会把链接放上来。他有一个非常好的框架来实践你刚才说的，叫“魔法循环”（The Magic Loop），它能帮你弄清楚该做什么，以及如何让经理看到你的能力并赢得信任。

---

### [00:56:42] Lenny Rachitsky (Ad Read)

**English:**
This episode is brought to you by PostHog, the product platform your engineers actually want to use. PostHog has all the tools that founders, developers and product teams need, like product analytics, web analytics, session replays, heat maps, experimentation, surveys, LLM observability, air tracking, and more. Everything PostHog offers comes with a generous free tier that resets every month. More than 90% of customers use PostHog for free. You are going to love working with a team this transparent and technical. You'll see engineers landing pull requests for your issues and their support team provides code level assistance when things get tricky. PostHog lets you have all your data in one place.

(00:57:21):
Beyond analytics events, their data warehouse enables you to sync data from your Postgres database, Stripe, HubSpot, S3, and many more sources. Finally, their new AI product analyst, Max AI helps you get further faster. Get help building complex queries and setting up your account with an expert who's always standing by. Sign up today for free at PostHog.com/Lenny and make sure to tell them Lenny sent you. That's PostHog.com/Lenny.

**中文翻译:**
本集节目由 PostHog 赞助，这是工程师们真正想使用的产品平台。PostHog 拥有创始人、开发者和产品团队所需的所有工具，如产品分析、Web 分析、会话重放、热力图、实验、调查、LLM 可观测性、错误追踪等。PostHog 的所有功能都有丰厚的每月重置免费额度。超过 90% 的客户免费使用 PostHog。你会喜欢与这样一个透明且技术导向的团队合作。你会看到工程师为你的问题提交 PR，他们的支持团队在棘手时提供代码级协助。PostHog 让你所有数据汇聚一处。

(00:57:21):
除了分析事件，他们的数据仓库还支持同步来自 Postgres、Stripe、HubSpot、S3 等来源的数据。最后，他们新的 AI 产品分析师 Max AI 助你事半功倍。在专家的协助下构建复杂查询并设置账户。立即在 PostHog.com/Lenny 免费注册，记得说是 Lenny 推荐的。

---

### [00:57:49] Lenny Rachitsky

**English:**
So along the lines of timeless manager, especially new manager advice, you've shared a bunch. Is there anything else that you think is really important, really interesting, valuable?

**中文翻译:**
关于永恒的管理者建议，尤其是给新任管理者的建议，你已经分享了很多。还有什么你认为非常重要、有趣且有价值的吗？

---

### [00:57:59] Julie Zhuo

**English:**
Feedback is one of the other topics that I am super, duper passionate about. And my general impression for both myself, everyone I've worked with, is that we don't value feedback enough or we don't think about it enough. Again, companies have these performance cycles, and so we're all like, yes, every six months we're going to go and do these reviews. That's when I'll get feedback. But feedback really, in my mind, ideally, should be a daily practice. Because the thing that matters for us in the long run as a team is how quickly are we getting better? So a team that just gets 1% better every week compared to a team that gets 1% better a month, even if they start off at a much lower baseline, is going to outperform in a very short amount of time the team that doesn't get better.

(00:58:50):
And so, what is the best tool for us to get better? It is feedback. And what I think about in feedback, it's very similar to what we said earlier about data metrics. It's essentially trying to put your hypotheses and test them against reality. So as an example, maybe I have this perception right now that I am a positive and engaging speaker. So, I have this sense that I'm smiling and I'm very engaging, and I'm telling great stories, but is that really true? I don't know. The reality is that I'm often biased, and we know these psychological effects where sometimes the Dunning-Kruger effect, people think they're way more expert at something than they actually are. You ask people, "Hey, are you a better than average driver?"

(00:59:35):
And it's like 70 or 80% of people, "Yes, I'm better than average." How could that possibly be? We have biases. And imposter syndrome is a bias on the other side, it's like me feeling, "Oh, I suck. I don't actually belong here." Whereas, that also is a bias. It may not actually be true. In fact, I might very well be here and other people value my contribution.

(00:59:56):
So we are just wildly out of sync a lot of times in our perceptions of ourselves, our strengths, our weaknesses, what's going on. And the way that we're going to understand and truly get better is we need other people to reflect back what is actually their truth. And the way I think about it is like, I'm going to ask you for feedback after this podcast episode and you're going to tell me something. And what you're going to do is you're going to give me a gift. Because it'll be a gift of reflecting something back of what you see that I can't see. Just like if I have a leaf in the back of my head, I can't see that. And so if you're telling me, "Hey, Julie, you have a leaf."

(01:00:33):
"Oh, wow, thank you." Okay, maybe I can get rid of the leaf or whatnot. But that is what feedback is. It is essentially reflection back. It helps us calibrate to reality, and it allows me to get this information about whether or not I'm moving in the direction of my goals.

**中文翻译:**
反馈是我非常、非常热衷的另一个话题。我对自已以及合作过的每个人的普遍印象是，我们对反馈的重视程度不够，或者思考得不够。公司通常有绩效周期，所以我们都觉得：“是的，每六个月我们会做一次评估，那时我会得到反馈。”但在我看来，理想情况下，反馈应该是一种日常练习。因为作为一个团队，从长远来看，最重要的是我们进步的速度有多快。一个每周进步 1% 的团队，比起一个月进步 1% 的团队，即使起步基数低得多，也会在极短时间内超越那个不进步的团队。

(00:58:50):
那么，让我们变好的最佳工具是什么？就是反馈。我对反馈的看法与我们之前讨论的数据指标非常相似：它本质上是把你的假设拿去与现实进行测试。举个例子，也许我现在觉得自己是一个积极且有感染力的演讲者。我有这种感觉，觉得自己面带微笑、引人入胜、讲着精彩的故事。但这是真的吗？我不知道。现实中我们经常带有偏见，我们知道一些心理效应，比如“邓宁-克鲁格效应”（Dunning-Kruger effect），人们觉得自己比实际水平更专业。你问人们：“嘿，你是一个水平高于平均水平的司机吗？”

(00:59:35):
大约 70% 或 80% 的人会说：“是的，我高于平均水平。”这怎么可能呢？我们都有偏见。而“冒充者综合征”是另一面的偏见，比如我觉得：“哦，我很差，我不属于这里。”那也是一种偏见，可能并非事实。事实上，我可能完全胜任，别人也很看重我的贡献。

(00:59:56):
所以很多时候，我们对自已、对优势和弱点的认知与现实是严重脱节的。而我们理解并真正变好的方式，是需要别人反映出他们眼中的真相。我的想法是：这集播客结束后我会向你征求反馈，你会告诉我一些事情。你实际上是在给我一份“礼物”。因为它是一份反映出“你看到了而我没看到的东西”的礼物。就像如果我后脑勺上粘了一片叶子，我自己是看不见的。如果你告诉我：“嘿 Julie，你头上有一片叶子。”

(01:00:33):
“噢，哇，谢谢。”这样我就可以把叶子拿掉。这就是反馈。它本质上是一种反射。它帮助我们校准现实，让我获得关于我是否正朝着目标前进的信息。

---

### [01:00:50] Lenny Rachitsky

**English:**
I love that. I completely agree. The challenge for most people, as you know, is giving feedback that people receive and don't feel defensive about, and then receiving feedback and not being like, "Oh, no, they don't know. They don't know anything. How dare they say this about me?" Could you give us maybe a tip or two for delivering feedback well and for receiving feedback well? And maybe even just seeking, how do you get more feedback? This all makes a lot of sense. Most of the time people don't get any feedback.

**中文翻译:**
我很喜欢这个观点，完全同意。但如你所知，对大多数人来说，挑战在于：如何给出让对方接受且不产生防御心理的反馈；以及在接收反馈时，如何不心想“哦不，他们根本不懂，他们什么都不知道，他们怎么敢这么说我？”你能给我们一两个关于如何“给好反馈”和“接好反馈”的建议吗？甚至包括如何主动寻求更多反馈？这很有意义，因为大多数时候人们根本得不到任何反馈。

---

### [01:01:18] Julie Zhuo

**English:**
The best way... The first tip on getting feedback or delivering hard feedback is first go and actually establish that our relationship is one in which we value each other's contribution, we want to help each other grow, and therefore we're going to be the kind of people that want to give feedback to each other every week. So when you first start working with someone, don't wait until something bad has happened [inaudible 01:01:42] given feedback, because that's already a pressurized situation. Start by saying, "Hey, really excited to work with you. I feel like our best collaboration is I want you to help me get better. I think I'm good at this stuff. I'm not so good at this stuff. What about you? Okay, you think you're good at this stuff? How about we just work together and we just help each other get better at these things? And the way we're going to do that is, all feedback is open. I want you to tell me everything. Ideally, you're going to then say, 'Yeah, I want you to tell me everything.'" And we've already established that.

**中文翻译:**
最好的方式……关于获取反馈或提供困难反馈的第一个建议是：首先去建立一种关系，即我们重视彼此的贡献，我们想帮助彼此成长，因此我们要成为那种每周都想给彼此反馈的人。所以当你开始和某人合作时，不要等到坏事发生了才给反馈，因为那时已经处于高压状态了。从一开始就说：“嘿，很高兴能和你合作。我觉得我们最好的协作方式是互相帮助变好。我觉得我擅长这些，不擅长那些。你呢？好，你觉得你擅长这些？那我们就一起努力，互相帮助在这些方面提高。我们的做法是：所有反馈都是公开的，我希望你告诉我一切。理想情况下，你也会说：‘是的，我也希望你告诉我一切。’”这样我们就建立好了这种共识。

---

### [01:02:10] Lenny Rachitsky

**English:**
And this is colleagues or manager or all colleagues?

**中文翻译:**
这是指同事之间，还是经理与下属之间，还是所有同事？

---

### [01:02:13] Julie Zhuo

**English:**
It's like everyone. It's like people you're dating, it's like your children. It can be with everyone, just establishing what kind of relationship do we want to have? I think most people want to opt into a relationship where you can be close, you can be tight with one another. You can say things to one another and not have to hide behind... I think most people will opt into it, and if you opt into it, everything gets easier down the road. So the first thing is get everyone to opt in that this is the kind of relationship that we want to have.

**中文翻译:**
是所有人。就像你约会的对象，像你的孩子。可以是任何人，只是建立“我们想要什么样的关系”。我认为大多数人都希望选择一种亲密、紧密的关系。你可以对彼此直言不讳，而不需要躲躲闪闪。我认为大多数人都会选择这种关系，一旦选择了，以后的事情就会变得容易得多。所以第一步是让大家达成共识：这就是我们想要的关系。

---

### [01:02:41] Lenny Rachitsky

**English:**
One trickle throughout that I've heard that worked really well along these same lines is asking people, "Do you prefer feedback in the moment or do you prefer it kind of every month or every week or something like that?" And everyone's like, "No, no in the moment and just tell me as soon as something happens." And then that gives you that freedom to just, " Okay, yeah, let me give you feedback here."

**中文翻译:**
我听过一个顺着这个思路且非常有效的技巧，就是问对方：“你更喜欢即时反馈，还是喜欢每月、每周一次之类的？”每个人都会说：“不，不，要即时的，一旦发生什么就告诉我。”这给了你一种自由：“好吧，那我现在就给你个反馈。”

---

### [01:03:09] Julie Zhuo

**English:**
So if you get people to opt in, "Yes, I want us to have a great relationship. I want us to help each other get better. I want feedback." That's 60% of the hard part of delivering difficult feedback later on. Then the second tactic I will say is that when you actually give the feedback, it helps a lot. First, you have to check, "Am I actually giving this feedback because it's in the spirit of trying to help one another?" And if the answer is yes, then we've moved from 60% to 80%, it's going to go well.

(01:03:37):
But what can often happen is something happens. You do something, it triggers me, because I don't know, I had a bad experience about that type of thing before. And so, I'm kind of feeling mad and I want to be right. If my real rationale for why I want to give you feedback is I want to validate myself, I want to be right, I want to tell you you're wrong, I want to punish you, it's not going to go well. It's just already there. There's no way you can deliver it, unless you're a tremendous actor. It's just not going to go well. So you have to first check your intention.

(01:04:16):
But if you've done that, you're like, "No, no, no. I thought about it. I'm calm now. I'm not seeing red. I really think that Lenny is just not aware that when he says this, it makes me and other people feel left out," or whatever it is, right? Then I need to be able to give it to you. And so usually then if you're like, "Okay, now I might be nervous because I don't know to offend you. I really value our relationship. How am I going to tell you. I don't want you to get defensive?"

(01:04:44):
Then the third tactic is, just say that out loud. If I sit down with you and I say, "Lenny, I'm so nervous right now. I want to give you some feedback and I'm really worried that it's going to impact our relationship, and I so value our relationship and I don't want that to happen. But I also feel like it's just going to help you to hear it if you can." That does so much of the work of... It's humanizing. You're going to realize that I'm going out on the limb, I'm being really vulnerable, and likely you're going to hear that so much more than if I just find a way to drop it, just lobby it over because it's so difficult. Just actually lean into the fact that it is difficult and expose that because that builds a lot of human connection.

**中文翻译:**
如果你让人们选择了“是的，我希望我们有很好的关系，互相帮助变好，我想要反馈”，那么以后提供困难反馈的 60% 难点就已经解决了。第二个策略是：当你真正给出反馈时，首先要检查：“我给这个反馈真的是为了帮助对方吗？”如果答案是肯定的，那么成功率就从 60% 提高到了 80%。

(01:03:37):
但经常发生的情况是：某件事发生了，你做了一些事触发了我的情绪（可能因为我以前有过不好的经历）。所以我感到生气，我想证明我是对的。如果我给你反馈的真实动机是想证明自己、想说你是错的、想惩罚你，那结果肯定不好。除非你是顶级演员，否则根本瞒不住。所以你必须先检查自己的意图。

(01:04:16):
但如果你检查过了，觉得：“不不不，我考虑过了，我现在很冷静，没有被愤怒冲昏头脑。我真的觉得 Lenny 没意识到他这么说会让我也让别人感到被冷落。”那么我就需要告诉你。如果你当时想：“好吧，我现在可能有点紧张，因为我不想冒犯你，我很看重我们的关系。我该怎么开口？我不希望你产生防御心理。”

(01:04:44):
那么第三个策略就是：直接把这些话大声说出来。如果我坐下来对你说：“Lenny，我现在非常紧张。我想给你一些反馈，但我真的很担心这会影响我们的关系。我非常看重我们的关系，不希望那种事发生。但我同时也觉得，如果你能听到这些，会对你有帮助。”这能起到巨大的作用……它让对话充满人情味。你会意识到我在冒险，我表现得很脆弱，比起我因为觉得困难而随口丢下一个反馈，你更有可能听进去。直接承认这件事很难，并把它暴露出来，因为这能建立深厚的人与人之间的连接。

---

### [01:05:33] Lenny Rachitsky

**English:**
This is amazing advice. Very tactical. Okay, is there anything else? So we've talked about a bunch of timeless pieces of manager wisdom, things that people need to hear, especially as new managers. Is there anything else that you think is really important that you think people are just not fully grokking for being great managers?

**中文翻译:**
这是非常棒的建议，非常具有实操性。好，还有别的吗？我们谈了一堆永恒的管理者智慧，那些人们（尤其是新任管理者）需要听到的东西。还有什么你认为非常重要，但人们在成为优秀管理者的道路上还没有完全领悟的吗？

---

### [01:05:53] Julie Zhuo

**English:**
I think the idea of win-win, I think about that all the time in my mind. And I go back to it, because I think that often we have the story in our heads that sometimes things are adversarial. As a manager, I'm trying to get people to be more productive, so I'm trying to get them to do a thing that maybe they don't want to do. I'm going to try and get them to work harder or I'm going to somehow put more pressure on them. If you start thinking like that, that's not a win-win way to be thinking, right? That's like you saying, "My getting better outcomes has to come at the expense of somebody else losing something."

(01:06:33):
And I think if you start thinking like that, it's very difficult to come up with a strategy or to truly be successful. But if you say, "Look, actually, my job is to figure out how to create win-wins." So I actually don't want somebody over the long run to feel like what I've done is just create a ton of pressure for them and now they're super burnt out, real quick, because that's not good for our team, that's not good for me, that's not good for our long-term relationship. How do we find the solution that can be a win-win? And I think if you think like that, a lot of things get easier. So for example, with new managers, I think this is true for me, too, the first time I had to tell someone that they shouldn't be a part of this team was extremely fraught for me. And the main reason was because I'm putting myself in their shoes, and I'm imagining that this is truly horrible, and I've just done a huge disservice to this person, and that's the most awful thing.

(01:07:32):
But there's another way to look at it, which is, hey, if there's persons on the team, they probably want to be successful. They want to do great work, they want to be valued, they want to grow their career. If this is not the place for them, because it doesn't align with their true interests and the things that are going to help them be successful is just not the thing that they either want to do or can do at this point, it doesn't do that person any good for me to somehow try to continue to make it. It's actually going to be miserable. I'm going back to prolonging that misery state.

(01:08:06):
And so, sometimes a win-win thing is to just say, "Look, it's not working, and I respect and value you so much that I know you want to do something that you can be proud of and you can grow in, and that's going to be really valued. And right here, what we got, this isn't it." That's like a win-win way of looking at the situation, not a like, "Oh, my firing them is just definitely going to be a horrible..." I'm not trying to say it's not going to be hard, obviously it's hard, but it's in the mentality and the mental model I think makes all the difference. Because it's going to be different in the way that I convey it to them. It's going to be different and why this actually in the grander scheme of things may be great, and it's going to reduce this adversarial feeling where they're now going to see me as an enemy or somebody with all this power who's making choices that impact them and they feel powerless. It has to be a collaboration. And I think if it's not win-win... And I could be wrong. I would say I don't think it's right. The person could actually say, "No, you're wrong." And that would actually be great information, because then maybe we can go back and we can find a way to make it win-win.

**中文翻译:**
我认为是“双赢”（Win-win）的理念，我脑子里一直在想这个。我经常回到这一点，因为我认为我们脑子里经常有一种“对抗性”的故事。作为管理者，我试图让人们更有生产力，所以我试图让他们做一些他们可能不想做的事。我试图让他们更努力工作，或者以某种方式给他们施压。如果你开始这样想，那就不是双赢的思维方式，对吧？那就像是在说：“我获得更好的结果必须以牺牲别人的利益为代价。”

(01:06:33):
我认为如果你开始这样想，就很难制定出好的策略或获得真正的成功。但如果你说：“看，实际上我的工作是弄清楚如何创造双赢。”所以我实际上不希望某人长期觉得我只是给他们制造了巨大压力，让他们很快就精疲力竭，因为这对团队不好，对我不好，对我们的长期关系也不好。我们如何找到一个双赢的解决方案？如果你这样想，很多事情都会变得容易。例如，对于新任管理者（对我来说也是如此），第一次不得不告诉某人他们不适合这个团队时，我感到非常焦虑。主要原因是我把自己代入他们的处境，想象这简直太可怕了，我亏待了这个人，这是最糟糕的事。

(01:07:32):
但还有另一种看待方式：嘿，如果团队里有这样一个人，他们肯定也想成功。他们想做出伟大的工作，想被重视，想发展职业生涯。如果这里不适合他们，因为这不符合他们的真实兴趣，或者能帮助他们成功的事情并不是他们现在想做或能做的，那么我强行留住他们对那个人没有任何好处。实际上这会让他们很痛苦。我只是在延长那种痛苦的状态。

(01:08:06):
所以，有时双赢的做法是直接说：“看，这行不通。我非常尊重和看重你，我知道你想做一些让你自豪、能让你成长且被高度重视的事情。而在我们这里，目前的情况并不是那样的。”这是一种双赢的视角，而不是“哦，我解雇他们肯定是一件可怕的事……”。我不是说这不难，显然很难，但我认为心态和心理模型决定了一切。因为这会改变我向他们传达的方式。这会改变为什么从大局来看这可能是件好事，并且会减少那种对抗感——即他们把我视为敌人，或一个拥有权力、做出影响他们的选择而让他们感到无能为力的人。这必须是一种协作。我认为如果不是双赢……我也可能是错的。如果对方说：“不，你错了。”那其实也是很好的信息，因为我们可以回头寻找实现双赢的方法。

---

### [01:09:12] Lenny Rachitsky

**English:**
Yeah, I was just going to say, they have to believe this. You can't just make it sound like this, "Here's the win you're getting let go. It's a huge win for you." But in reality, the way you phrased it, it is actually almost always true, "This is just not a place that you'll be happy and succeed at, and it's better you go do something else."

**中文翻译:**
是的，我正想说，他们必须相信这一点。你不能只是听起来像是在说：“这是你的赢面：你被解雇了，这对你来说是巨大的胜利。”但实际上，按照你的措辞，这几乎总是事实：“这只是一个你不会快乐、也不会成功的地方，你最好去做点别的。”

---

### [01:09:27] Julie Zhuo

**English:**
Yeah.

**中文翻译:**
没错。

---

### [01:09:28] Lenny Rachitsky

**English:**
Okay. I'm going to keep fishing in this pool to see what else we got, but when we run out, let me know. Is there anything else that you think people should know, should hear, especially new managers that they're still not fully getting?

**中文翻译:**
好，我打算继续在这个池子里挖挖看，如果挖完了告诉我。还有什么你认为人们（尤其是新任管理者）应该知道、应该听到，但目前还没完全领悟的吗？

---

### [01:09:41] Julie Zhuo

**English:**
I think being aware of your own energy and conviction is really, really important. So a lot of these themes, as you can see, go back to, you have to first understand this about yourself and have the right mindset, and when you do, it becomes much easier to be able to be impactful with other people. So this is another one. I think it's very difficult for managers to be able... We talked a lot about the three pillars of what are the major tools of a manager. The first is people. And so, we talked a lot about the importance of dimensionality and feedback and helping reflect and grow people.

(01:10:21):
I think the second one is around purpose. Purpose is like, "What are we here to do? What's our North Star?" And I think it's very hard to actually convey that if you don't have conviction yourself. And so watching your conviction is really important, particularly since a lot of people who are managers, you often start out not as the founder of the CEO of the company, but you might be a middle manager. So in some ways, you didn't create the vision, but you are in some ways expected to execute it or take a piece of it and do it. And I find that sometimes what new managers don't pay attention to enough is what is their true belief. They feel like they might have to be a soldier, so they just get orders and they have to execute it. But it really makes a difference if they themselves have gone through the work of thinking through, "Wait, why are we doing this? Do I believe this strategy? Does it make sense or not?"

(01:11:18):
And if it doesn't make sense, to go and actually have the conversation with their manager or whoever else, just so they can get to alignment on, "I really believe in what I'm doing." Because if you don't really believe in what you're doing or you're just parroting the thing that got passed through the organization, it's very hard for you to then be able to help other people see what that magic is or to be actually really effective as a person who can hold that vision and that purpose. So I just think you have to really check in with yourself on like, "Wait, I know we're told to do this and this is what we have to do, but how do we really feel about it?" Because if you don't feel good about it, then it's not going to be very likely that the project's going to succeed. I can tell you right now, every single manager I've ever managed where they're like, "I don't really think this is a good idea," there's no case where I can think of where the project somehow turned out to be wildly successful.

**中文翻译:**
我认为意识到你自己的能量和信念（Conviction）非常、非常重要。如你所见，很多主题都回到了：你必须首先了解自己并拥有正确的心态，一旦做到了，影响他人就会变得容易得多。这是另一点。我们谈了很多关于管理者的三大支柱工具。第一是人，我们谈了很多关于维度、反馈以及帮助人们反思和成长。

(01:10:21):
我认为第二点是关于目标（Purpose）。目标是：“我们在这里要做什么？我们的北极星是什么？”我认为如果你自己没有信念，很难向他人传达这一点。所以关注自己的信念非常重要，特别是很多管理者最初并不是公司的创始人或 CEO，而可能是中层经理。在某种程度上，你没有创造愿景，但你被期望去执行它或承担其中的一部分。我发现有时新任管理者不够关注的是：他们真实的信念是什么？他们觉得自己必须像个士兵，接到命令就执行。但如果他们自己能深入思考：“等等，我们为什么要这么做？我相信这个策略吗？它合理吗？”这会产生巨大的差别。

(01:11:18):
如果觉得不合理，就去和经理或其他人沟通，直到达成共识：“我真的相信我正在做的事。”因为如果你不相信自己所做的事，或者只是在复述组织传达下来的话，你就很难让别人看到其中的魔力，也很难作为一个持有愿景和目标的人发挥真正的效力。所以我认为你必须真正审视自己：“我知道我们被要求这样做，但我们真实的感觉如何？”因为如果你感觉不好，项目就不太可能成功。我可以告诉你，在我管理过的所有经理中，如果他们说“我真的不觉得这是个好主意”，我还没见过哪个项目最后能取得巨大成功的。

---

### [01:12:13] Lenny Rachitsky

**English:**
This is such a classic challenge of managers, is getting things done that you don't really agree with. And I can't help but ask you for advice on someone that isn't in that place of just, "Okay, we have this feature our CEO's prioritizing. This is not a good idea, but I need to have a brave face and not make it sound like I'm just being told what to do and I'm just reporting orders. I don't believe in this." You don't want to do that. You become a terrible unsuccessful manager and people lose trust in you. What's your advice to folks that are in that place of just how to find that balance?

**中文翻译:**
这是管理者的经典挑战：完成你并不真正认同的事情。我忍不住想请你给那些处于这种境地的人一些建议：“好吧，CEO 优先考虑这个功能。这不是个好主意，但我得表现得勇敢，不能听起来像只是在传达命令。我不相信这个。”你不想那样做，因为那样你会成为一个糟糕、不成功的经理，人们会失去对你的信任。你对处于这种境地、试图寻找平衡的人有什么建议？

---

### [01:12:44] Julie Zhuo

**English:**
So I think, first, if you feel that way, you got to actually find a way to get it out and engage in dialogue. So if you're like, "My manager told me to do this, I think it's a terrible idea," you've got to talk to your manager about it or you've got to talk to the CEO or whoever and feel... Because once you engage in a dialogue, what will often happen is you'll learn more, you'll have new information, you'll have new assumptions, and maybe you'll have influenced a project in some manner. But often, the more you can learn about, "Okay, why did some other smart people feel like we should do this? And what parts of it do I believe and what parts am I more skeptical about?"

(01:13:20):
You can probably decompose it from a blanket it's good or bad to like, "Okay, this is a hypothesis, this is a hypothesis, this is a hypothesis. I might kind of believe this one. The reason I don't like the proposal, I don't believe this particular hypothesis, but I believe these other ones." And so, when you can start to get one level deeper into breaking it down into a set of assumptions, that makes it much easier, because then likely find something that you do kind of resonate with. And you might be able to then steer things like, "Okay, if that hypothesis doesn't... I believe in disagree and commit, but now we can be very specific. We can isolate the thing that..."

(01:13:59):
And what we can also often do is like, "Okay, the reason I didn't like this proposal is because I believe that this assumption is wrong." I'm going to come up with a really stupid example. But your suggestion is, "I know we have a great idea. We're going to go and put a lemonade stand on every block. And my core assumption is people do not like lemonade. That's not the hot beverage right now. And so therefore, I think this is a stupid plan." But if I talk to you about it and you're like, "No, no, this is the core assumption we disagree on."

(01:14:29):
Likely what starts to unfold is like, "Well, can we get some data? Can we get some information? Is there a quicker way to validate whether people like lemonade? Perhaps we should just test it in one market before we go and open up the lemonade stands across the entire 50 states." And so what happens is we can likely get to the actual specific area and come up with something. And then, if I have to now share with my team, We're going to try this hypothesis. I'm not sure how I feel about it, but I actually do think... I don't know for sure and our CEO seems to think this is... But we're just going to test it."

(01:15:00):
For sure, and our CEO seems to think this is... But we're just going to test it, and we're going to do the test in a way where... That's what we want to find out, is do 18 to 25-year-olds love lemonade if we put them on these neighborhood college campuses? It becomes very specific and everyone's like, "Well, yeah, I don't know for sure, but I'm happy to go in, and test that, and commit to it."

**中文翻译:**
我认为，首先，如果你有这种感觉，你必须找到一种方式表达出来并进行对话。如果你觉得“经理让我做这个，我觉得主意烂透了”，你必须和经理谈，或者和 CEO 谈。因为一旦你参与对话，通常会发生的是：你会学到更多，获得新信息，了解新的假设，也许你还能以某种方式影响项目。通常，你可以更多地了解：“好吧，为什么其他聪明人觉得我们应该这样做？其中哪些部分是我相信的，哪些是我怀疑的？”

(01:13:20):
你可以把它从笼统的“好或坏”分解开来：“好，这是假设 A，这是假设 B，这是假设 C。我可能有点相信 A。我不喜欢这个提议的原因是我不相信假设 B，但我相信其他的。”当你能深入一层，将其分解为一系列假设时，事情就变得容易多了，因为你很可能会找到一些能产生共鸣的东西。然后你就可以引导事情：“好吧，如果那个假设不成立……我相信‘保留意见并执行’（Disagree and commit），但现在我们可以非常具体。我们可以隔离出那个……”

(01:13:59):
我们通常还可以说：“好，我不喜欢这个提议的原因是我认为这个前提假设是错误的。”我举个很傻的例子。你的建议是：“我们有个好主意，要在每个街区都设一个柠檬水摊。而我的核心假设是人们不喜欢柠檬水，那现在不是热门饮料。所以我认为这是个愚蠢的计划。”但如果我和你谈，你说：“不不，这是我们产生分歧的核心假设。”

(01:14:29):
接下来可能会展开的是：“那我们能不能拿点数据？能不能弄点信息？有没有更快的办法验证人们是否喜欢柠檬水？也许在全美 50 个州铺开之前，我们应该先在一个市场测试一下。”这样我们就能找到具体的切入点并想出办法。然后，如果我现在要和团队分享：“我们要尝试这个假设。我不确定结果如何，但我确实认为……我不能肯定，而我们的 CEO 似乎认为这是对的……但我们要测试它。”

(01:15:00):
“我们要以这种方式进行测试……这就是我们想要发现的：如果我们把摊位设在大学校园附近，18 到 25 岁的年轻人会喜欢柠檬水吗？”这变得非常具体，每个人都会觉得：“好吧，我不确定，但我愿意参与测试并全力以赴。”

---

### [01:15:24] Lenny Rachitsky

**English:**
This is such a good advice, and there's also, you could layer on, "Here's the things I do agree with and believe. Here's the ways that I see this as totally right. Here's the piece that I'm not so sure about, but that's why we're going to run this test, and here's why it's the smallest version of this test and why it's a great idea just to figure it out." We'll show them. You probably don't want to say that. As you give this answer, it's so interesting, I almost want to do a whole new episode with you later of just common conundrums managers have, challenges that every manager runs into that are really difficult to figure out on the spot. We could save that for the future. Okay, I'm going to take us to a couple of recurring themes on this podcast, occasional recurring that every episode corners that we take guests to. The first is I want to take us to AI corner. What I like to do in AI corner is ask, what's a way that you've figured out to use AI in your work or your life that's just really interesting, really useful?

**中文翻译:**
这是非常好的建议。你还可以加上：“这是我认同和相信的部分。这是我认为完全正确的地方。这是我不那么确定的部分，但这就是我们要运行测试的原因，也是为什么这是该测试的最小版本，以及为什么弄清楚它是个好主意。”“我们会证明给他们看。”——你可能不想说这句。听你回答时我觉得很有趣，我甚至想以后再和你录一集，专门讲讲管理者常遇到的难题，那些每个管理者都会遇到且很难当场解决的挑战。我们可以留到以后。好，现在进入播客的几个固定环节。首先是“AI 角”。在 AI 角，我喜欢问：你在工作或生活中发现的哪些使用 AI 的方式是非常有趣且有用的？

---

### [01:16:19] Julie Zhuo

**English:**
Well, I already shared a lot about education and learning, but I'll share maybe a more fun story. It's my kid's birthdays. One of them just passed. My middle son's birthday is in two weeks and my daughter's birthday is in a month.

**中文翻译:**
我已经分享了很多关于教育和学习的内容，但我可以分享一个更有趣的故事。关于我孩子的生日。其中一个刚过，我二儿子的生日在两周后，我女儿的生日在一个月后。

---

### [01:16:32] Lenny Rachitsky

**English:**
By the way, the birthday just passed. The kid didn't pass.

**中文翻译:**
顺便说一下，是生日刚过，不是孩子“走了”。

---

### [01:16:34] Julie Zhuo

**English:**
Okay. Yes, the birthday passed.

**中文翻译:**
好的，是的，是生日过了。

---

### [01:16:35] Lenny Rachitsky

**English:**
[inaudible 01:16:35].

**中文翻译:**
（笑声）

---

### [01:16:35] Julie Zhuo

**English:**
That's right, that's right. The birthday passed, my kid's birthday. One of my goals this year was to try and build them something, so give them a present that has me going back to being the IC and making something for them. AI makes this really fun, and so just from my youngest son who was six years old, this is an idea that I stole from Eric Antonow, if you know Eric. Have you had him on your podcast?

**中文翻译:**
没错，是我孩子的生日过了。我今年的目标之一是尝试为他们亲手做点东西，给他们一份让我重新变回 IC、亲手制作的礼物。AI 让这件事变得非常有趣。对于我六岁的小儿子，我从 Eric Antonow 那里偷了个主意。你认识 Eric 吗？你请他上过播客吗？

---

### [01:16:59] Lenny Rachitsky

**English:**
I haven't, I am trying to. He actually sent me the... What is it? The-

**中文翻译:**
还没，我正打算请他。他其实给我发过那个……叫什么来着？那个——

---

### [01:16:59] Julie Zhuo

**English:**
Yes, yes.

**中文翻译:**
是的，没错。

---

### [01:17:06] Lenny Rachitsky

**English:**
What is it called? The metha-

**中文翻译:**
叫什么名字？那个 Metha——

---

### [01:17:06] Julie Zhuo

**English:**
Methaphone?

**中文翻译:**
Methaphone?

---

### [01:17:06] Lenny Rachitsky

**English:**
Methaphone.

**中文翻译:**
Methaphone.

---

### [01:17:06] Julie Zhuo

**English:**
Yes.

**中文翻译:**
是的。

---

### [01:17:06] Lenny Rachitsky

**English:**
Methaphone, check this out.

**中文翻译:**
Methaphone，看看这个。

---

### [01:17:08] Julie Zhuo

**English:**
Yeah, yes.

**中文翻译:**
是的。

---

### [01:17:11] Lenny Rachitsky

**English:**
It's like instead of holding the phone in your pocket, you hold this thing, and then you walk around with it and everyone's like, "What the hell is that?" Methaphone.

**中文翻译:**
就像你不再把手机放在口袋里，而是拿着这个东西走来走去，每个人都会问：“那到底是什么鬼？”Methaphone。

---

### [01:17:16] Julie Zhuo

**English:**
Yeah. I, too, am the proud owner of a methaphone and the next version upgrades with the little stickers, but-

**中文翻译:**
是的，我也是 Methaphone 的骄傲拥有者，下一代版本还升级了小贴纸，但是——

---

### [01:17:23] Lenny Rachitsky

**English:**
No, I don't have that one yet.

**中文翻译:**
不，我还没拿到那个版本。

---

### [01:17:24] Julie Zhuo

**English:**
... Eric is great. You should definitely have him on your... He's such a creative character. One time, I saw him with a parrot on his shoulder, and I was like, "Why do you have a parrot on your shoulder?" He's like, "Well, you can talk to my parrot. It's a talking parrot," and then I spoke to the parrot and the parrot spoke back to me. What had happened is that he had hooked up a microphone, he surgically went into the parrot and added a microphone, a speaker, and connected it to voice mode on ChatGPT so that... It spoken I think like a pirate voice.

(01:17:55):
I was like, "This is the best idea." My six-year-old son is really into raccoons. He has a huge amount of raccoon stuffies. I was like, "I want a raccoon that can talk to him," so I made that using the Eric Antonow method, but it was great. It was a huge hit. Now, my middle son's birthday's coming up, and he is really into parody. He loves video games, so Minecraft, but what he often listens to on his Alexa are these parody songs. It'll be like Justin Bieber's hit or Gangnam Style, but they've changed the lyrics so it becomes a video game parody of some video game that he's playing, and they're horribly sung. They're like off-tune, it's just like some person who produced it. I was like, "Well, if he doesn't seem to mind off-key singing, I'm going to create him an album of video game parody songs, and I'm going to create an..."

(01:18:47):
I created an app on Replit, and what it does is you just give it a song. This is Justin Bieber's Baby and you link to a Spotify song, and I give him some context like, "Oh, Locke likes playing Kingdom Rush right now. We have an inside joke about the gargoyles being free money." Whatever it is, I just give it a bunch of context. I'm like, "Write me a song that just personalizes it and it's a parody of this particular video game." It writes me the lyrics. It's pretty good at doing this. It's pretty high quality. Again, it does it according to the beats of the music, and then I just sing it and record it, and then I got myself a song, so I'm creating an album of this, which I'm going to give to him. He's not going to hear this podcast, so no one spoil it to him. I think this is going to go publish after his birthday, but I'm very excited about this.

**中文翻译:**
Eric 很棒，你一定要请他。他是个非常有创意的人。有一次，我看到他肩膀上站着一只鹦鹉，我问：“你为什么肩膀上站着只鹦鹉？”他说：“你可以和我的鹦鹉说话，它会说话。”然后我对鹦鹉说话，鹦鹉居然回话了。原来他给鹦鹉装了麦克风和扬声器，并连接到了 ChatGPT 的语音模式，它用一种海盗腔说话。

(01:17:55):
我觉得这是最棒的主意。我六岁的儿子非常喜欢浣熊，他有很多浣熊毛绒玩具。我想：“我要做一个能和他说话的浣熊。”于是我用 Eric 的方法做了一个，效果极佳，大受欢迎。现在我二儿子的生日快到了，他非常喜欢恶搞歌曲（Parody songs）。他喜欢电子游戏，比如 Minecraft，他经常在 Alexa 上听这些恶搞歌。比如把贾斯汀·比伯的热门单曲或《江南 Style》改了歌词，变成他正在玩的某个游戏的恶搞版。那些歌唱得很烂，跑调严重，就是普通人制作的。我想：“既然他不介意跑调，那我要为他制作一张电子游戏恶搞歌曲专辑。”

(01:18:47):
我在 Replit 上做了一个应用，你只要给它一首歌（比如比伯的《Baby》）并链接到 Spotify，然后我给它一些背景信息，比如“Locke 最近喜欢玩《王国保卫战》，我们有个关于石像鬼是‘免费送钱’的内部梗”。我给它一堆背景，说：“帮我写一首个性化的歌，恶搞这个特定的游戏。”它写出的歌词非常棒，质量很高，而且完全符合音乐节拍。然后我只要自己唱出来并录音，就得到了一首歌。我正在为他制作这样一张专辑。他不会听这个播客，所以大家别剧透。我想这集播出时他生日已经过了，但我对此非常兴奋。

---

### [01:19:34] Lenny Rachitsky

**English:**
Wait, so you're going to be the one singing the song?

**中文翻译:**
等等，所以是你亲自唱这些歌吗？

---

### [01:19:37] Julie Zhuo

**English:**
Yes, yes.

**中文翻译:**
是的，没错。

---

### [01:19:37] Lenny Rachitsky

**English:**
I thought you were going to use Suno or some AI thing to actually sing it.

**中文翻译:**
我以为你会用 Suno 或者什么 AI 工具来唱。

---

### [01:19:40] Julie Zhuo

**English:**
No, I think I'm going to sing it myself.

**中文翻译:**
不，我想我自己唱。

---

### [01:19:41] Lenny Rachitsky

**English:**
Wow.

**中文翻译:**
哇。

---

### [01:19:43] Julie Zhuo

**English:**
All of this made it so easy. All I have to do is just record. Again, I'm not a very good singer, but it doesn't turn him off to hear off-key singing.

**中文翻译:**
AI 让这一切变得如此简单。我只需要录音就行。再说一次，我唱得不好，但他并不介意听跑调的歌。

---

### [01:19:54] Lenny Rachitsky

**English:**
Yeah. Wow, that is so beautiful. This gave me so many ideas for gifts I can give to kids in my life, and I just love how AI is making it, I don't know, easier to be a parent and, in some ways, more delightful. These are awesome examples. Okay, I'm going to take us to a different corner, contrarian corner. What's something that you believe that most other people don't, people would disagree with?

**中文翻译:**
哇，这太美好了。这给了我很多关于送礼物的灵感。我喜欢 AI 让为人父母变得更简单，在某些方面也更令人愉悦。这些例子太棒了。好，现在进入另一个环节：“非共识角”（Contrarian corner）。有什么是你相信但大多数人不同意、会反对的观点？

---

### [01:20:20] Julie Zhuo

**English:**
I believe that there's infinity in every direction. That makes me pretty contrarian on pretty much everything that anyone says. If someone says something like on Twitter, I sometimes play this game with myself, which is in what context would that actually not be true? I think the reality is that the world is so, or at least my reality and my understanding of the reality, is that the world is just infinitely complex. For example, if my kids say something like going outside is boring, or taking a walk is boring, or doing something is boring, my general response will be, "Well, it's because you're not seeing the infinity that's in that direction."

(01:21:05):
Even, for example, something really mundane like staring at a blank wall, I think that you can make that actually deeply, deeply interesting, because you can use that as an opportunity to go into your own mind and to figure out how you can make time pass, or you can meditate on the existence or meditate on your breath, or just be grateful for the purpose of being alive. Two people, one person you can say, "Sit in front of a wall for an hour," and, like my kid, they will super complain and be like, "This is the worst thing ever," but you can put somebody else like a monk and they'll have a wonderful experience. It's not really about the environment or the wall. It's really about how we see it and whether we can find the thing that is deep, and rich, and infinite in that direction.

**中文翻译:**
我相信“每个方向都有无限可能”。这让我对几乎任何人说的任何话都持有一种非共识的态度。如果有人在 Twitter 上说了什么，我有时会和自己玩个游戏：在什么语境下这句话其实是不成立的？我认为现实是——或者至少我理解的现实是——世界是无限复杂的。例如，如果我的孩子说去外面很无聊，或者散步很无聊，我的回答通常是：“那是因为你没有看到那个方向上的无限性。”

(01:21:05):
甚至是一些非常平庸的事，比如盯着一面白墙。我认为你可以让它变得极其有趣，因为你可以利用这个机会进入自己的内心，思考如何打发时间，或者冥想存在、冥想呼吸，或者仅仅为活着而感到感激。两个人，你让其中一个对着墙坐一小时，像我孩子那样，他们会疯狂抱怨“这是最糟糕的事”；但如果你放一个僧侣在那，他会有美妙的体验。这其实与环境或墙无关，而在于我们如何看待它，以及我们是否能发现那个方向上深邃、丰富且无限的东西。

---

### [01:21:56] Lenny Rachitsky

**English:**
Wow, these are some deep answers. This is very, I don't know, Buddhist, very mindfulness-oriented. I did a retreat once and their advice was just anytime you're bored, just notice all the things that are going on around you. What does your seat feel like right now? What does the air feel like? What are you hearing right now? It's exactly what you're saying, there's infinite things to pay attention to and keep you interested. It's hard.

**中文翻译:**
哇，这些回答很有深度。这非常……怎么说呢，很有禅意，非常关注正念。我参加过一次静修，他们的建议是：任何时候你感到无聊，就去观察周围发生的一切。你现在的座位感觉如何？空气感觉如何？你现在听到了什么？正如你所说，有无限的事物值得关注并让你保持兴趣。但这很难。

---

### [01:21:56] Julie Zhuo

**English:**
It's hard.

**中文翻译:**
确实很难。

---

### [01:22:21] Lenny Rachitsky

**English:**
Hard to actually do that for a long time and practice. That's why it's a practice.

**中文翻译:**
很难长时间坚持并练习。这就是为什么它被称为一种“修行”。

---

### [01:22:24] Julie Zhuo

**English:**
That's why it's a practice. But I repeat that to myself, because oftentimes, if I have a bad experience feeling a certain way, it helps me to realize that it's often probably in my head. It's because I haven't gained the skills to be able to see the richness and infinity in that... I can maybe work on that. That feels better than feeling like, "Oh, I'm a victim of my circumstances. This thing happened to me," and that's so awful but not powerless, I can't do anything about it. That, to me, is a worse feeling than the alternative, which is I just don't have the skill yet. I can recognize it for what it is. I don't have the skill yet, but I can grow. I can maybe get better at it. There is a person out there who had the same situation as me and feels much more positively than I do, and don't I want to be more like that person?

**中文翻译:**
这就是为什么它是一种修行。但我会对自己重复这一点，因为通常如果我有不好的体验或情绪，它能帮我意识到这可能只是我的主观想法。是因为我还没有获得看到其中丰富性和无限性的技能……我可以努力提高。这种感觉比觉得自己是“环境的受害者”要好。如果我觉得“这件事发生在我身上，太糟糕了，我无能为力”，那是一种更糟糕的感觉。而另一种想法是：“我只是还没掌握这项技能。我可以认清现状，我还没这技能，但我可以成长，可以做得更好。世界上肯定有人遇到了和我一样的情况，但心态比我积极得多，难道我不该向那个人学习吗？”

---

### [01:23:15] Lenny Rachitsky

**English:**
It's such a beautiful circle back to our very first episode, which a lot of it was on imposter syndrome and overcoming that and your story there, so I love that that's maybe a way to close this conversation. But before we do that and before we get to our very exciting lightning ground, is there anything else that you wanted to mention, or share, or double down on that we've talked about?

**中文翻译:**
这真是一个美丽的轮回，回到了我们的第一集，那时很多内容是关于“冒充者综合征”及其克服方法，以及你的故事。我很喜欢用这个方式来结束对话。但在我们进入激动人心的“闪电回合”之前，还有什么你想提到、分享或强调的吗？

---

### [01:23:35] Julie Zhuo

**English:**
I just want to say thank you. Honestly, I'm so inspired by the work that you do. I know we've known each other for quite a while, and I just think from the very first idea that you had for this newsletter, for the podcast, has been incredible, and I think the world gets so much from it. I'm sure you hear that a lot, but I am very grateful.

**中文翻译:**
我只想说声谢谢。老实说，你所做的工作给了我很多启发。我们认识很久了，我觉得从你最初产生办这个通讯和播客的想法开始，这一切都非常不可思议，这个世界从中获益良多。我确定你经常听到这些，但我真的很感激。

---

### [01:23:52] Lenny Rachitsky

**English:**
Well, I really appreciate that, and I say this every time we do a chat, is just this wouldn't have been possible without you, Julie. I was inspired by your longtime newsletter, The Looking Glass. Essentially, my idea was what if I do this for product? I started on Medium just like you did, and then I moved to Substack, and then it's like, "What if I charge for this?" That worked, and then I'm like, "What if I do a podcast?" and then that worked. But it all began with your concept, so thank you, Julie.

**中文翻译:**
我非常感激。我每次和你聊天都会说：没有你，这一切都不可能实现，Julie。我是受你长期经营的新闻通讯《The Looking Glass》启发的。本质上，我的想法是：如果我针对“产品”领域也做一个这样的东西会怎样？我像你一样从 Medium 开始，然后搬到 Substack，然后想“如果我收费呢？”，结果成功了。然后我想“如果我做播客呢？”，也成功了。但这一切都始于你的理念，所以谢谢你，Julie。

---

### [01:24:22] Julie Zhuo

**English:**
Yeah. I think you do it with so much kindness and curiosity as you always have, so I love that.

**中文翻译:**
是的。我觉得你一如既往地带着善意和好奇心在做这件事，我很喜欢。

---

### [01:24:27] Lenny Rachitsky

**English:**
That's just who I am. Well, with that, we have reached our very exciting lighting round. I've got five questions for you. Are you ready?

**中文翻译:**
我就是这样的人。好，现在我们进入了激动人心的闪电回合。我有五个问题问你，准备好了吗？

---

### [01:24:34] Julie Zhuo

**English:**
I'm ready.

**中文翻译:**
准备好了。

---

### [01:24:36] Lenny Rachitsky

**English:**
What are two or three books that you find yourself recommending most to other people?

**中文翻译:**
有哪两三本书是你向别人推荐最多的？

---

### [01:24:39] Julie Zhuo

**English:**
The first is Zen and the Art of Motorcycle Maintenance. I absolutely love that book. It's beautifully written. It's so deep. My whole philosophy around quality is beautifully... A lot of it comes from that book, the idea and even all the stuff that we talked about change. What does it mean to be at that forefront of change and dynamic quality? I think he just talks about so beautifully and so masterfully in that book. Old classic, but I try to reread it every few years or so. Second is Conscious Business. It is my favorite management book. It's a little bit of a sleeper head because I actually end up recommending this one far more than my own book.

(01:25:23):
I read this one after I wrote my book, and I always tell people that if I read it before, I'm not sure I would've written my book, because I would've been like, "Conscious Business is really the book that really, really so much resonates." Many of the things I talked about, this idea of win-win, idea of being a player, not a victim, and how to think about work, not just it's a job but how do you really think about aligning it with your own personal values and what you want to do in the world, I think that this book really speaks to that so beautifully. It is also very tactical. It's got a lot of really wonderful examples. I will tell people, the cover isn't very attractive, and I think that if you judge a book by its cover, this seems very corporate-y. The title also seems like, "What conscious business?" and the first chapter is a little bit more technical. But if you just get past it and get into chapter two and you start with examples of the soccer team, it's just the best management book.

**中文翻译:**
第一本是《禅与摩托车维修艺术》（Zen and the Art of Motorcycle Maintenance）。我非常喜欢这本书，写得太美了，而且很有深度。我关于“质量”的整个哲学，很大一部分都来自这本书，包括我们谈论的关于变化的理念。处于变革前沿和动态质量意味着什么？我认为他在书中讲得非常精彩。这是一本老经典，但我每隔几年就会重读一次。第二本是《清醒企业》（Conscious Business）。这是我最喜欢的管理书。它有点像一匹黑马，因为我最后推荐它的次数甚至超过了我自己的书。

(01:25:23):
我是写完自己的书后才读到它的。我常告诉别人，如果我早点读到它，我不确定我还会不会写我那本书，因为我会觉得：“《清醒企业》才是那本真正引起共鸣的书。”我谈到的很多东西——双赢、做参与者而非受害者、如何思考工作（不仅是一份工作，而是如何与个人价值观和世界理想结合）——这本书都讲得非常透彻。它也非常具有实操性，有很多精彩的例子。我会告诉大家，封面不太好看，如果你以貌取书，它看起来很像那种死板的企业读物。标题也让人困惑，第一章也有点技术化。但如果你能坚持读到第二章，从那个足球队的例子开始，它就是最好的管理书。

---

### [01:26:23] Lenny Rachitsky

**English:**
That is good advice to get people over the hump when they look for it. They're like, "Okay, okay, I'm going to stick with it."

**中文翻译:**
这是个好建议，能帮人们度过刚开始阅读时的那段枯燥期。

---

### [01:26:28] Julie Zhuo

**English:**
Yes. Okay, third book. I love the book Good Inside by Dr. Becky. It's a parenting book and it's a very wildly popular parenting book, so I really recommend it to all parents, but I also think it's just a wonderful book for thinking about relationships, because parenting is that. It's like a very, very deep and intense relationship and interaction that you have with another human being, and there's so many things that I read in parenting books, including Good Inside by Dr. Becky, that I think could just as well been a management or a team leadership book.

**中文翻译:**
是的。第三本，我喜欢 Dr. Becky 的《Good Inside》。这是一本育儿书，非常受欢迎。我向所有父母推荐它，但我认为它也是一本思考“关系”的绝佳书籍。因为育儿本质上就是关系——一种与另一个人类进行的非常深厚且强烈的关系和互动。我在育儿书（包括《Good Inside》）中读到的很多东西，我认为完全可以作为管理或团队领导力书籍。

---

### [01:27:03] Lenny Rachitsky

**English:**
I am thinking about trying to ask Dr. Becky to come on the podcast. I feel like there could be a lot of synergy exactly for that reason. She uses this term sturdy, which inspired maybe your bullet tree process.

**中文翻译:**
我正考虑邀请 Dr. Becky 上播客。我觉得正因为这个原因，会有很多协同效应。她使用了“坚定”（Sturdy）这个词，也许这启发了你的“柳树”理念。

---

### [01:27:16] Julie Zhuo

**English:**
Oh, yeah, I probably got it... I think she talks a lot about sturdiness and that just incepted right in here.

**中文翻译:**
噢，是的，我可能就是从那儿……她谈了很多关于坚定的内容，那直接植入到了我的脑海里。

---

### [01:27:20] Lenny Rachitsky

**English:**
Yes. Yeah. Her whole thing is being a sturdy parent. Strong but flexible, I imagine. Yeah. I love her and I love her stuff. I watch all her videos on TikTok and Emily Oster. Okay, next question. Is there a movie or TV show you recently enjoyed?

**中文翻译:**
是的。她的核心理念是做一个“坚定的父母”。我想是强大但灵活。我很喜欢她和她的内容。我常看她和 Emily Oster 在 TikTok 上的视频。好，下一个问题：最近有什么喜欢的电影或电视节目吗？

---

### [01:27:36] Julie Zhuo

**English:**
I have not watched anything. I have no good answer for you. I think the only thing I watched this year was a rewatch of La La Land, which I do truly love.

**中文翻译:**
我最近什么都没看，没法给你好答案。我想我今年唯一看过的就是重温了《爱乐之城》（La La Land），我真的很喜欢那部电影。

---

### [01:27:36] Lenny Rachitsky

**English:**
So delightful. Okay. Is there a product you recently discovered that you really love?

**中文翻译:**
很经典。好，最近有没有发现什么非常喜欢的产品？

---

### [01:27:49] Julie Zhuo

**English:**
I don't think there's anything too new. I love Granola, I love Replit. I've used all of the different coding lamps. Cursor is big on me for now. I just got a Matic Robot. I think that's been really delightful so far, at least the setup. I haven't used it long, long term, but it's the setup, the way that it worked. The fact that it had little stickers and you could make it into a dog or a cat was a wonderful experience.

**中文翻译:**
我觉得没有什么太新的。我喜欢 Granola，喜欢 Replit。我用过各种不同的编程助手，目前 Cursor 是我的首选。我刚买了一个 Matic 机器人。到目前为止体验非常愉快，至少设置过程很棒。我还没长期使用，但它的设置方式和运作方式，还有它附带小贴纸可以把它装饰成猫或狗，这体验太棒了。

---

### [01:28:17] Lenny Rachitsky

**English:**
The Matic Robot, willing to it, I am also a huge fan. I'm not an investor that's... Essentially, Waymo meets Roomba. For folks that don't anything about it, it's like a very sophisticated robot vacuum built by AI vision people.

**中文翻译:**
Matic 机器人，我也非常喜欢。我不是投资人……它基本上是“Waymo 遇上 Roomba”。对于不了解的人来说，它是一个由 AI 视觉专家打造的非常先进的扫地机器人。

---

### [01:28:32] Julie Zhuo

**English:**
Oh, I just thought of one more as well, the Limitless Pendant. Disclaimer, I am a small investor in Limitless, but what I love about it is that... Okay. It's a pendant, you wear it, and it just records everything that's going on, and later it summarizes things and it gives you feedback. I don't usually wear it out because I find that maybe other people feel awkward that I'm recording everything, I usually try and get people's permission, but I do wear it at home when I'm with my kids, and one of the best things that the pendant does is it gives me feedback on parenting.

**中文翻译:**
噢，我还想到一个：Limitless 吊坠。免责声明，我是 Limitless 的小股东。但我喜欢它的一点是……它是一个你戴在身上的吊坠，它会记录发生的一切，稍后进行总结并给你反馈。我通常不戴它出门，因为我觉得别人可能会因为我在录音而感到尴尬，我通常会征求许可。但我会在家陪孩子时戴着它，它最棒的一点是能给我育儿方面的反馈。

---

### [01:29:04] Lenny Rachitsky

**English:**
What? Automatically or run into ChatGPT?

**中文翻译:**
什么？自动给反馈，还是通过 ChatGPT？

---

### [01:29:08] Julie Zhuo

**English:**
No, automatically. There's an app and it will sometimes notify me, or if I check it, it'll... Or I can also engage with Ask It, but what it does is essentially... It's like Granola, but for your life in terms of capturing everything, summarizing it, and then giving you tips and feedback. It's said things like, "Hey, there was that time you were talking about the game and you cut your kid off a lot. Maybe next time, think about letting them speak fully and listening better."

**中文翻译:**
不，是自动的。它有一个 App，有时会通知我，或者我去查看。我也可以问它。它本质上就像是为你生活打造的 Granola，捕捉一切、总结，然后给你建议和反馈。它会说：“嘿，刚才聊游戏的时候，你打断了孩子好几次。下次试着让他们把话说完，多听听。”

---

### [01:29:34] Lenny Rachitsky

**English:**
The app itself natively does that?

**中文翻译:**
App 本身自带这个功能？

---

### [01:29:36] Julie Zhuo

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:29:37] Lenny Rachitsky

**English:**
I did not know that, because I have one. I haven't used it much recently. That is incredible. I wonder if it gives you relationship advice too if you're talking to your partner. I wonder how it even knows.

**中文翻译:**
我以前不知道这个，我也有一台，但最近没怎么用。这太不可思议了。我想知道如果你和伴侣说话，它会不会也给感情建议。我好奇它怎么知道的。

---

### [01:29:46] Julie Zhuo

**English:**
Yeah. It did a pretty good job of inferring. I think I said person two, but it was kind of eye-opening for me.

**中文翻译:**
是的，它在推断方面做得很好。虽然它可能只标为“人物 2”，但这对我来说非常开眼界。

---

### [01:29:57] Lenny Rachitsky

**English:**
Incredible. There's a recent episode of our How I AI podcast, our sister podcast, where somebody wears that in their meetings with their CEO and automatically turns what they're asking for into a prototype from the meeting notes, and then sales teams can start showing it to people to see if they're interested. How about that?

**中文翻译:**
太神了。我们姐妹播客《How I AI》最近有一集，有人在和 CEO 开会时戴着它，自动把会议记录里的需求变成原型，然后销售团队就可以直接拿去给客户看是否感兴趣。这怎么样？

---

### [01:30:19] Julie Zhuo

**English:**
That's awesome. That is super cool.

**中文翻译:**
太棒了，超级酷。

---

### [01:30:20] Lenny Rachitsky

**English:**
Holy moly. [inaudible 01:30:22], what is even happening? Okay, I'll keep going. Do you have a favorite life motto that you find yourself repeating to yourself, sharing with others?

**中文翻译:**
天呐，这世界变化太快了。好，继续。你有没有什么最喜欢的座右铭，经常对自己说或分享给别人的？

---

### [01:30:30] Julie Zhuo

**English:**
I like make it happen. Just a reminder that, at the end of the day, we could have a lot of motion. Maybe this is another one that I really like. I think about this poster. It used to be a poster at Facebook that says "don't mistake Motion for progress". There's this idea of be the change We want to be in the world, I guess is other ways of saying the same thing, which is I can do things. We can all do things. We have better and better tools to go out there and make things happen. Make it happen.

**中文翻译:**
我喜欢“让它发生”（Make it happen）。这只是一个提醒：到头来，我们可能做了很多动作。也许这是我喜欢的另一个：我想起 Facebook 以前的一张海报，上面写着“不要把动作误认为进步”。还有“成为你想在世界上看到的改变”，我想这些都是在表达同一件事：我可以做事，我们都可以做事。我们有越来越好的工具去让事情发生。让它发生。

---

### [01:30:59] Lenny Rachitsky

**English:**
The common meme on Twitter, you can just do things.

**中文翻译:**
Twitter 上流行的那个梗：你只需要动手去做。

---

### [01:31:02] Julie Zhuo

**English:**
Yes.

**中文翻译:**
没错。

---

### [01:31:03] Lenny Rachitsky

**English:**
Final question. I like to ask this question to folks that are really deep in AI, and been working with AI, and getting a sense of where things are going. Is there something that you teach your kids or teaching your kids, think about encouraging them to learn, knowing that AI is going to be a big part of their life?

**中文翻译:**
最后一个问题。我喜欢问那些深耕 AI 领域的人：既然知道 AI 将成为他们生活的重要组成部分，你现在教给孩子或鼓励他们学习的东西是什么？

---

### [01:31:20] Julie Zhuo

**English:**
Emotional regulation is still really, really, really important. That's probably the thing that I think about the most in terms of what I want my kids to learn. I want my kids to be able to introspect, to have a better understanding of where their state of mind is, because we're still human. We still have the same hardware that humans have had for thousands of years, and that's not changing even as the tools and the environment around us change, and so I feel that you have to really understand yourself and you have to understand what's going on for you and where you are biased and where you're not, because AI can make it... This is my great fear, is that it makes things so much more comfortable. I have this great fear that this has been the trajectory that we've been on with technology. This is, again, going back to every strength is a weakness.

(01:32:05):
Technology makes things a lot easier. That's why we invent, that's why we create. Human race has always been about trying to better our circumstances and, in some ways, control our destiny, control our future. But at the same time, all of that control gets to a point where we have so many shortcuts in our lives and you can shortcut a lot of things. You can shortcut relationships, you can shortcut hard feelings, because now you can just watch TikTok instead of actually dealing with a very difficult emotion or tension that you had with a colleague, or with your partner, or with your children. AI makes it even, I think, more attractive, because now there's a person or there's a thing that can be very, very personalized, and if you're like, "Oh, I want a distraction, I want to do something," you got that.

(01:32:51):
But how do we actually still learn to sit with what is our true biology that's not changing, and how do we continue to be the kind of people that want to take on the freedom of doing challenging things? Because I find that if we don't do challenging things, we suffer. We suffer in a different way, and so, to me, true freedom is you can pick the things that are hard and you can feel pride in becoming the thing that you want to be. It's not forced upon you. It's not for survival's sake anymore, but you still have to pick. I want to figure out for my children the fact that it is really important to still find the challenge. Yes, you can use AI to do that, but really, don't think about it as a shortcut tool, because if that's the case, I don't actually think that they're going to be able to become the kind of people they want to be in the world.

**中文翻译:**
情绪调节（Emotional regulation）依然非常、非常、非常重要。这可能是我最希望孩子学习的东西。我希望我的孩子能够内省，更好地了解自己的心理状态。因为我们仍然是人类，我们仍然拥有数千年来人类一直拥有的相同“硬件”。即使我们周围的工具和环境发生了变化，这一点也不会改变。所以我觉得你必须真正了解自己，了解自己身上发生了什么，哪里有偏见，哪里没有。因为 AI 会让……这是我最大的恐惧，它让事情变得太舒服了。我非常担心这就是技术发展的轨迹。这又回到了“每种优势都是弱点”。

(01:32:05):
技术让事情变得容易得多。这就是我们发明和创造的原因。人类一直致力于改善环境，并在某种程度上控制命运和未来。但与此同时，这种控制达到了一个点，我们的生活中有了太多的捷径。你可以走很多捷径：你可以走关系的捷径，可以走处理负面情绪的捷径——因为现在你可以直接刷 TikTok，而不是去处理与同事、伴侣或孩子之间非常困难的情绪或紧张关系。我认为 AI 让这种诱惑变得更强，因为现在有一个非常个性化的东西存在，如果你想要分心，想要做点什么，它就在那。

(01:32:51):
但我们如何学会与自己那不变的生物本能共处？我们如何继续成为那种想要拥有“做挑战性事情的自由”的人？因为我发现如果我们不做挑战性的事，我们就会痛苦。那是一种不同形式的痛苦。所以对我来说，真正的自由是你可以选择那些困难的事，并为成为你想成为的人而感到自豪。这不是被迫的，不再是为了生存，但你仍然必须做出选择。我想让我的孩子们明白，寻找挑战依然非常重要。是的，你可以利用 AI 来做这件事，但千万不要把它仅仅看作一个走捷径的工具。因为如果是那样的话，我不认为他们能成为他们想在这个世界上成为的那种人。

---

### [01:33:41] Lenny Rachitsky

**English:**
What a beautiful way to end this conversation. Julie, it feels like this is just some kind of huge milestone of this podcast. Just like having you back three years later, it's like, I don't know, a chapter in the journey. I appreciate you coming back. I appreciate you sharing all this wisdom with us. Two final questions. Where can folks find you online if they want to reach out and maybe chat about maybe Sundial, maybe whatever else you're up to, and then how can listeners be useful to you?

**中文翻译:**
多么美妙的结尾。Julie，感觉这是播客的一个巨大里程碑。三年后请你回来，就像是这段旅程中的一个重要章节。感谢你回来，感谢你与我们分享这些智慧。最后两个问题：如果大家想联系你，或者聊聊 Sundial，或者你正在做的其他事情，在哪里可以找到你？以及听众可以如何帮到你？

---

### [01:34:06] Julie Zhuo

**English:**
Well, I would love to work with people who are at companies building really cool things and want better answers to how we build better, and so if you think your company would be interested in working with us at Sundial and figuring out how do we make every single decision maker into their own expert analyst, please reach out. That's one area, sundial@sundial.so. I am on X, so I've been tweeting a lot more, sharing thoughts. Going back to that skill of practicing, just share what's on your mind.

(01:34:40):
But for the long form stuff, I have my blog, The Looking Glass. It's on Substack. I share articles and thoughts about AI, product building, leadership periodically, and then, of course, I have my book, the revised edition with two additional chapters. One is around managing remotely and the other one is around managing in a downturn or managing in difficult change scenarios. That will be coming out in two weeks' time. The new content will be in the paperback. That's important. I'll send you a version of this when I get a copy myself, Lenny-

(01:35:15):
... but the paperback has a gradient type of cover. The hardback will eventually get the new content, but it just takes a while to phase out from all of the different retailers, so if you buy one, I cannot guarantee that it's going to have the new content. But certainly, the Kindle and the paperback will have all of the new content.

**中文翻译:**
我非常希望能与那些正在构建酷炫产品、并想知道如何构建得更好的公司合作。如果你觉得你的公司有兴趣与 Sundial 合作，探索如何让每个决策者都成为自己的专家分析师，请联系我们。邮箱是 sundial@sundial.so。我也在 X（原 Twitter）上，最近发推比较多，分享想法。回到那个练习技能的话题，就是分享你脑子里的想法。

(01:34:40):
至于长篇内容，我有我的博客《The Looking Glass》，在 Substack 上。我会定期分享关于 AI、产品构建和领导力的文章。当然，还有我的书，修订版增加了两个章节：一个是关于远程管理，另一个是关于在经济低迷或困难的变革场景下进行管理。修订版将在两周后出版。新内容会包含在平装本（Paperback）中，这很重要。Lenny，等我拿到样书会寄给你一本。

(01:35:15):
平装本的封面是渐变色的。精装本最终也会更新内容，但从零售商那里更替需要时间，所以如果你现在买精装本，我不能保证它有新内容。但 Kindle 电子书和平装本肯定会有全部新内容。

---

### [01:35:33] Lenny Rachitsky

**English:**
Just for the publish day, because this might come out later, what's the date that's coming up just for folks?

**中文翻译:**
为了确定发布日期（因为这集可能晚点播），具体日期是哪天？

---

### [01:35:37] Julie Zhuo

**English:**
September 9th.

**中文翻译:**
9 月 9 日。

---

### [01:35:40] Lenny Rachitsky

**English:**
Okay, amazing. I think it'll be out by the time this is out, so go buy it. I imagine available on Amazon, all your local retailers.

**中文翻译:**
太棒了。我想这集播出时书已经上市了，大家快去买吧。亚马逊和各大零售商应该都有售。

---

### [01:35:46] Julie Zhuo

**English:**
Yes, yes.

**中文翻译:**
是的，没错。

---

### [01:35:47] Lenny Rachitsky

**English:**
Amazing. Julie, thank you so much for being here.

**中文翻译:**
太好了。Julie，非常感谢你能来。

---

### [01:35:49] Julie Zhuo

**English:**
Thank you so much, Lenny. This was so fun. I hope to be back in another three years or whatever the next chapter is.

**中文翻译:**
非常感谢，Lenny。这很有趣。希望三年后或者下一个篇章开启时我能再回来。

---

### [01:35:56] Lenny Rachitsky

**English:**
Hopefully sooner. Bye, everyone.

**中文翻译:**
希望不用等那么久。大家再见。

---

### [01:35:58] Julie Zhuo

**English:**
Bye.

**中文翻译:**
再见。

---

### [01:36:00] Lenny Rachitsky

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
非常感谢您的收听。如果您觉得这集节目有价值，可以在 Apple Podcasts、Spotify 或您喜欢的播客应用中订阅。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现这个播客。您可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下集见。