# Julie Zhuo - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Julie Zhuo.

---

### (00:00:06) Lenny

**English:**
Welcome to our very first episode with Julie Zhou. Julie spent 13 years at Facebook where she was the head of design for the Facebook app. She actually joined as an IC designer and worked her way up to VP of design. She's also an incredible writer, having written the best-selling book, The Making of a Manager. She's also the author of a newsletter called The Looking Glass which was a huge inspiration to me throughout my entire career. Since leaving Meta, she's started her own company called Sundial which you'll hear a bit about, and in our chat, we cover career advice, imposter syndrome, product review meetings, hiring designers, giving feedback to designers, and so much more. I hope you enjoy this chat as much as I did.

**中文翻译:**
欢迎收看我们与 Julie Zhuo 合作的第一集节目。Julie 在 Facebook 工作了 13 年，曾担任 Facebook App 的设计负责人。她最初是以 IC（Individual Contributor，个人贡献者）设计师的身份加入的，后来一路晋升为设计副总裁。她还是一位出色的作家，写过畅销书《经理人的养成》（The Making of a Manager）。她还是名为《望远镜》（The Looking Glass）的新闻通讯作者，这在我的整个职业生涯中给了我巨大的启发。离开 Meta 后，她创办了自己的公司 Sundial，稍后你会听到相关介绍。在我们的对话中，我们涵盖了职业建议、冒充者综合征（Imposter Syndrome）、产品评审会议、招聘设计师、给设计师提供反馈等诸多内容。希望你像我一样喜欢这次聊天。

---

### (00:00:52) Lenny

**English:**
This episode is brought to you by Amplitude, the number one product analytics solution. Amplitude helps product teams, growth teams, marketing and data teams build winning products faster and turn products into revenue. Amplitude has everything you need, including an integrated CDP, self-service analytics, and even an experimentation platform to help you better understand your users, drive conversions, and increase engagement, growth, and revenue. Amplitude is built for teams that want to learn as fast as they ship and ship as fast as they learn. Ditch your vanity metrics, rest your data, work smarter, and grow your business. With over 1,700 customers like Atlassian, Instacart and HBO, Amplitude is helping companies build better products. Try Amplitude for free. Visit amplitude.com to get started.

**中文翻译:**
本集节目由 Amplitude 为您呈现，它是排名第一的产品分析解决方案。Amplitude 帮助产品团队、增长团队、营销和数据团队更快地打造制胜产品，并将产品转化为收入。Amplitude 拥有你所需的一切，包括集成的 CDP（客户数据平台）、自助式分析，甚至还有一个实验平台，帮助你更好地了解用户、推动转化，并增加参与度、增长和收入。Amplitude 是为那些希望“学习速度与交付速度同步”的团队而设计的。抛弃那些虚荣指标（Vanity Metrics），信任你的数据，更聪明地工作，并发展你的业务。Amplitude 拥有超过 1,700 家客户，如 Atlassian、Instacart 和 HBO，正在帮助各家公司打造更好的产品。免费试用 Amplitude，请访问 amplitude.com 开始体验。

---

### (00:01:40) Lenny

**English:**
This episode is brought to you by Productboard. Product leaders trust Productboard to help their teams build products that matter. From startups to industry titans, over 6,000 companies rely on Productboard to get the right products to market faster, including companies like Zoom, Volkswagen, UiPath, and Vanguard. Productboard can help you create a scalable, transparent, and standardized process so your PMs understand what their customers really need and then prioritize the right features to build next. Stakeholders feel the love too with an easy-to-view roadmap that automatically updates so everyone knows what you're building and why. Make data-driven product decisions that result in higher revenue and user adoption, and empower your product teams to create delightful customer experiences. Visit productboard.com to learn more.

**中文翻译:**
本集节目由 Productboard 为您呈现。产品领导者信任 Productboard，因为它能帮助团队打造真正有意义的产品。从初创公司到行业巨头，超过 6,000 家公司依靠 Productboard 更快地将正确的产品推向市场，其中包括 Zoom、大众汽车、UiPath 和先锋集团（Vanguard）。Productboard 可以帮助你创建一个可扩展、透明且标准化的流程，让你的 PM（产品经理）了解客户的真实需求，然后确定下一步要构建的正确功能的优先级。利益相关者（Stakeholders）也会喜欢它，因为它提供易于查看且自动更新的路线图（Roadmap），让每个人都知道你在构建什么以及原因。做出数据驱动的产品决策，从而提高收入和用户采用率，并赋能你的产品团队创造令人愉悦的客户体验。访问 productboard.com 了解更多信息。

---

### (00:02:32) Lenny

**English:**
Julie, I am so excited to be chatting. You've been such an inspiration to me, both in my PM career and in my writing. I think I've mentioned that your newsletter inspired my newsletter, and so, I'm really excited to be chatting, and I'm really thankful that you're joining me on this podcast.

**中文翻译:**
Julie，能和你聊天我太兴奋了。无论是在我的 PM 职业生涯还是在我的写作中，你都给了我很大的启发。我想我提到过，你的新闻通讯启发了我的新闻通讯，所以我真的很激动能和你交流，也非常感谢你参加这个播客。

---

### (00:02:46) Julie Zhuo

**English:**
Thank you, Lenny. It is a pleasure to be here. I think it's going to be a super fun conversation.

**中文翻译:**
谢谢你，Lenny。很高兴来到这里。我想这会是一次超级有趣的对话。

---

### (00:02:51) Lenny

**English:**
For listeners who maybe aren't familiar with you and your career, could you just kind of briefly walk us through your journey in design and then a little bit about what you're up to these days?

**中文翻译:**
对于那些可能还不熟悉你和你的职业生涯的听众，你能简要地带我们回顾一下你的设计历程，以及你最近在忙些什么吗？

---

### (00:02:59) Julie Zhuo

**English:**
Okay. So, let's see. I am a first generation immigrant to the United States, and so, with Asian parents, there were really only three options that I had for a career. From the time I was six years old, I was told I could either be a doctor, a lawyer, or an engineer. Nothing else was really in the realm of possibilities. Unfortunately, I was really scared of blood, so I couldn't be a doctor, and I only liked reading fiction growing up, so I was like, "Never really be a lawyer." So, I was always like, "Okay, right, this engineering thing," but actually, it was during middle school and high school that I discovered what I love to do is drawing and in particular digital art, and the reason for that is because I actually have a very shaky hands, and so, whenever I draw a line, it never looks good, I have to erase it, start over, and so, by the time the art was done, it was a mess. It was like here's like 20,000 eraser remarks.

**中文翻译:**
好的。让我想想。我是美国的第一代移民，有着亚洲父母，我的职业选择其实只有三个。从六岁起，我就被告知要么当医生，要么当律师，要么当工程师。其他的都不在考虑范围内。不幸的是，我非常怕血，所以当不了医生；而我从小只喜欢读小说，所以我觉得自己也当不了律师。所以我一直想，“好吧，那就选工程吧。”但实际上，在初中和高中期间，我发现自己热爱的是绘画，尤其是数字艺术。原因是我手抖得厉害，每当我画一条线时，它看起来总是不太对，我不得不擦掉重画。等画完的时候，纸面已经一团糟了，到处都是擦除的痕迹。

---

### (00:03:45) Julie Zhuo

**English:**
But when I discovered MS Paint, and I kid you not, that was my very first design application, I was like, "Oh my gosh, I can draw a line, and even if it looks crummy," which it always does because you have to use a mouse in those early days, "I can just Ctrl+Z, it goes away, and just keep trying over and over again. No one ever has to know how often I tried to get to this to be what I wanted." And so, MS Paint became PaintShop Pro, and then one summer I finagled my way into a pirated copy of Photoshop because I couldn't actually afford real Photoshop, and I was off to the races in my digital art career.

**中文翻译:**
但当我发现 MS Paint（微软画图）时——我不骗你，那是我的第一个设计应用——我心想：“天哪，我可以画一条线，即使它看起来很糟糕（早期用鼠标画总是很糟糕），我只需要 Ctrl+Z，它就消失了，然后我可以一遍又一遍地尝试。没人需要知道我为了达到想要的效果尝试了多少次。”于是，MS Paint 变成了 PaintShop Pro，后来有一个夏天，我设法弄到了一份盗版的 Photoshop，因为我当时买不起正版，就这样，我的数字艺术生涯正式起步了。

---

### (00:04:16) Julie Zhuo

**English:**
It was actually through digital art that I realized, "Okay, I've actually amassed all this collection of art. What should I do?" And I was like, "Well, let me go and actually build a website. All these artists that I admire on the internet did that. So, I'm going to learn how to write HTML and put together a website," and that's essentially what I did on the side in my middle and high school years.

**中文翻译:**
正是通过数字艺术，我意识到：“好吧，我已经积累了这么多作品。我该怎么办呢？”我想：“嗯，让我去建个网站吧。我在网上崇拜的那些艺术家都这么做。所以，我要学习如何写 HTML 并搭建一个网站。”这基本上就是我在初中和高中时期利用业余时间做的事情。

---

### (00:04:34) Julie Zhuo

**English:**
So, that's kind of how I got into design, but I didn't know it was design because I really still thought of myself as an artist, and I thought that the only thing I could be was an engineer, but I went in and studied computer science in college. Right? I always had this vision, "Okay, if I like building websites, maybe computer engineering is the closest thing to that," and I had this idea that maybe I could go work for one of these big tech companies, and after I took a class my senior year, that taught me what is Silicon Valley, what is entrepreneurship. By the way, here's all these stories of two people in a garage, and then they went and built something big, and I totally just was so into that. I was like, "All right, I do not want to work for a big company. I want to figure out if I can do this startup thing and make something small into something big."

**中文翻译:**
这就是我进入设计领域的过程，但当时我并不知道那是“设计”，因为我仍然认为自己是一个艺术家，而且我觉得自己唯一能做的职业就是工程师。于是我在大学里学习了计算机科学。我当时想：“好吧，如果我喜欢建网站，也许计算机工程是最接近的专业。”我当时想，也许我可以去这些大科技公司工作。但在大四上了一门课后，我了解了什么是硅谷，什么是创业。顺便说一下，课上讲了很多“两个人在车库里，然后做出了一番大事业”的故事，我完全被吸引住了。我想：“好吧，我不想在大公司工作。我想看看自己能不能创业，把小东西做大。”

---

### (00:05:17) Julie Zhuo

**English:**
I just happened to be very lucky at the time. There was a startup down the street from my university. It's a product I had been using for two or three years. It was Facebook. It was still a high school and college social networking product at the time, 8 million users. They were doing a lot of recruitment at Stanford, and so, that's how I decided to go and join for an internship, and on my first day I remember my mentor, Ruchi, she said, "What kind of engineering do you like to do?" And I was like, "The stuff that people see, of course. I want to be able to..." The stuff that I'd always done. Right? And she goes, "Oh, I see. You should go sit next to the designers," and that was the first time I heard that design was a profession, that it was actually a job. It was a thing that people did.

**中文翻译:**
我当时非常幸运。就在我大学附近有一家初创公司。那是我已经用了两三年的产品，就是 Facebook。当时它还只是一个高中和大学的社交网络产品，拥有 800 万用户。他们当时在斯坦福大学进行了大量的招聘，于是我决定去那里实习。我记得第一天，我的导师 Ruchi 问我：“你喜欢做哪种工程？”我说：“当然是人们能看到的东西。我希望能……”就是我一直在做的那些。她说：“噢，我明白了。你应该去坐在设计师旁边。”那是第一次有人告诉我“设计”是一个专业，是一份真正的工作。那是人们赖以生存的事情。

---

### (00:05:55) Julie Zhuo

**English:**
Back in those days, all of the design team was technical. So, we were both the front-end engineers as well as the designers, but I felt like I'd found my tribe. I had found people who kind of had always been passionate about this thing that I didn't really realize was a job. And so, I realized though as well that I had a lot to learn about design. I was never really formally trained in it. Right? I'd only ever designed for myself for me to express my creative, artistic side, so there was a lot in those first three years. I would think of my time at Facebook as chapter one, learn how to be a designer, learn about usability, learn about the actual language, nomenclature of design, learn how to think about the user as somebody separate than just me and my own work.

**中文翻译:**
在那个年代，所有的设计团队成员都有技术背景。所以，我们既是前端工程师，也是设计师。我觉得我找到了自己的“部落”。我找到了一群一直对我以前没意识到是份工作的事情充满热情的人。但我也意识到，关于设计我还有很多要学的。我从未接受过正式的训练。我以前只为自己设计，为了表达我的创意和艺术的一面。所以在最初的三年里有很多东西要学。我把在 Facebook 的时光看作第一章：学习如何成为一名设计师，学习可用性（Usability），学习设计的实际语言和术语，学习如何将用户视为独立于我和我作品之外的个体。

---

### (00:06:36) Julie Zhuo

**English:**
Then, because Facebook was always scaling, I got the opportunity to eventually manage a team of designers. Totally unprepared for that, no idea what I was doing, kind of jumped in, and just started to manage, but there was a huge amount of learning around recruiting, process, what even is good design, what is the way that we want to design at this company in our team, and so, tons of learnings there. The third chapter is just sort thinking about scale. Right? Learning how to scale in management, learning how to build a wide diversity of products, learning more about strategy, and how design fits into working with all of these other disciplines to build something great. So, that's kind of how I think about my time at Facebook and the various chapters.

**中文翻译:**
后来，因为 Facebook 一直在扩张，我最终得到了管理一个设计师团队的机会。当时我完全没有准备，不知道自己在做什么，就这么跳了进去开始管理。但在招聘、流程、什么是好的设计、我们公司和团队想要的设计方式等方面，我学到了大量的东西。第三章是关于规模化（Scale）的思考。学习如何在管理中实现规模化，学习如何构建多样化的产品，学习更多关于战略的知识，以及设计如何与其他学科协作来打造伟大的产品。这就是我对在 Facebook 不同阶段的看法。

---

### (00:07:16) Julie Zhuo

**English:**
The latest chapter is eventually I left Facebook about two years ago and now I am a startup founder. So, it's something that I've always wanted to do. So, go back to that, the early phases of figuring out how to build something from zero to one, and I'm working on a product and product analytics. I'm really passionate about the idea of making data accessible about... I've seen the power firsthand from working at Facebook of what data can do to help us make better products, especially for people at scale, to help us reduce the bias in our intuitions, and how we think about what is the way that we should prioritize, and I'm really passionate about the idea of making that such that every single company, every single business in the world can properly use data, know how to interpret it correctly, know how to use it to influence roadmap strategy and prioritization decisions, and make better decisions as a result.

**中文翻译:**
最近的一章是，大约两年前我离开了 Facebook，现在我是一名初创公司创始人。这是我一直想做的事情。回到最初的阶段，弄清楚如何从 0 到 1 构建一些东西。我正在开发一个关于产品和产品分析的产品。我非常热衷于让数据变得触手可及。在 Facebook 工作期间，我亲眼见证了数据在帮助我们打造更好产品方面的力量，特别是对于大规模用户，它能帮助我们减少直觉中的偏见，并指导我们如何确定优先级。我非常希望让世界上每一家公司、每一家企业都能正确使用数据，知道如何正确解读数据，知道如何利用数据影响路线图战略和优先级决策，并因此做出更好的决策。

---

### (00:08:07) Lenny

**English:**
I feel like that, this idea that you're working on has such intense founder market fit, and I can't wait to hear more about it when you're ready to kind of go deeper and for people to use it. But going back to your time at Facebook, you kind of made it sound like you just kind of like, "I joined as a designer, figured out design, became a manager," and then somehow you became VP of design, and it sounded too easy. That's an insane trajectory for someone to follow. Do you have any thoughts or advice on what contributed to your success rising through the ranks that quickly for folks that are kind of just early in their career maybe?

**中文翻译:**
我觉得你正在做的这个想法具有非常强的“创始人与市场契合度”（Founder Market Fit），我迫不及待想在你准备好深入探讨并让人们使用它时听到更多消息。但回到你在 Facebook 的时光，你听起来好像只是“我作为设计师加入，搞懂了设计，成了经理”，然后不知怎么就成了设计副总裁，这听起来太容易了。对于任何人来说，这都是一个疯狂的职业轨迹。对于那些处于职业生涯早期的人，你对这种快速晋升的成功因素有什么想法或建议吗？

---

### (00:08:36) Julie Zhuo

**English:**
Absolutely, and I want to make it really clear. I always say that the first seven or eight years that I was at Facebook, every single week, I felt like an imposter. I had no idea really what I was doing. The constant refrain in my head is like, "Well, do you really deserve to be here? Do you really know what's happening? You're not really prepared for this job. You've never done this before. What right do you have to be put in this situation and get to do what you do?" Right? And that was really a constant refrain in my head.

**中文翻译:**
当然，我想说得很清楚。我常说，在 Facebook 的前七八年里，我每周都觉得自己是个“冒牌货”（Imposter）。我真的不知道自己在做什么。我脑子里不断回响的声音是：“你真的配待在这里吗？你真的知道发生了什么吗？你还没为这份工作做好准备。你以前从未做过这个。你有什么权利处在这个位置并做你正在做的事？”这种声音在我脑海中挥之不去。

---

### (00:09:03) Julie Zhuo

**English:**
But looking back, I think it probably took me about, yeah, seven or eight years till I became a little bit more comfortable with that, and after seven or eight years, I could look back, I could see all of the things that I got to work on, I could see all the ways that I had grown and learned in that experience, and something clicked for me where I realized it's kind of two sides of the same coin. Right? Being in an uncomfortable situation, being in a position where you feel like, Hey, do I really know how to do this? I've not prepared for it is kind of coin sides with the fastest and most intense periods of growth in one's career. And I started to realize, well, maybe it's not so much of a bad thing. Right? Maybe if I am constantly putting myself in a situation where I haven't seen this problem before, that's also what's going to push me to grow and learn. Right?

**中文翻译:**
但回过头来看，我想我大概花了七八年的时间才对此感到稍微舒服一点。七八年后，我可以回顾过去，看到我参与过的所有事情，看到我在那段经历中成长和学习的所有方式。我突然明白了一件事：这就像是一枚硬币的两面。处于一个不舒服的环境中，处于一个让你觉得“嘿，我真的知道怎么做吗？我还没准备好”的位置，往往与一个人职业生涯中增长最快、最密集的时期重合。我开始意识到，也许这并不是一件坏事。也许，如果我不断把自己置于从未遇到过的问题面前，那正是推动我成长和学习的动力。

---

### (00:09:47) Julie Zhuo

**English:**
And so, yes, you asked for specific advice. I think there's two things. The first is, well, I was lucky. I was in the right place at the right time. I was at a company that was scaling, and when you're at a company that grows, there's always a lot more opportunity to then be able to try something new, right, to raise your hand, to volunteer for things to be just thrown into because somebody has to do it because it's a growing company and a lot of other people. So, the first piece of advice I have would be like if you want those types of opportunities, sometimes you just have to be at a smaller place and you have to be at a place that is going through that rate of growth. The second thing is embrace the fact that it's okay to be in a position where maybe you don't know what to do, you haven't been trained for. Right? It does coincide with that intense learning. Maybe approach it with that sense of curiosity and that sense of yes, it's hard, yes, I might be an imposter and I might feel that way for a while, but this is also what's going to help me get there. It's going to be what forces me to do the work, and in that process, learn and become better.

**中文翻译:**
所以，是的，你问具体的建议。我认为有两点。第一，我很幸运。我在正确的时间出现在了正确的地方。我在一家正在扩张的公司，当你在一家成长的公司时，总会有更多的机会去尝试新事物，去举手示意，去自荐，或者仅仅是因为公司在成长，必须有人去做某件事而被推上去。所以我的第一条建议是：如果你想要这类机会，有时你必须待在一个较小的、正处于高速增长阶段的地方。第二点是，接受这样一个事实：处于一个你可能不知道该做什么、没有接受过相关培训的位置是没关系的。这恰恰与高强度的学习相吻合。也许可以用好奇心去对待它，承认“是的，这很难，是的，我可能是一个冒牌货，我可能会有这种感觉一段时间，但这正是帮助我到达目标的动力”。它会强迫我去做这些工作，并在过程中学习和变得更好。

---

### (00:10:45) Lenny

**English:**
It's amazing to hear that you had imposter syndrome for such a long period of time and you basically ran design for the Facebook app. Right? And so, it's kind of an empowering, inspiring insight that someone at your level went through that for so long and made it through that. Do you have any other advice or thoughts on just for folks that are going through that? Because I had that too for a number of years, just like, "What the hell am I doing here? People are going to see I don't really know what I'm doing, and it's all going to crumble as soon as I make my next mistake." Do you have any other advice there for folks going through that themselves?

**中文翻译:**
听到你在这么长的时间里都有冒充者综合征，而你当时基本上是在负责 Facebook App 的设计，这真的很惊人。对于像你这样级别的人经历过这些并挺了过来，这真是一个给人力量、令人鼓舞的见解。对于正在经历这些的人，你还有什么其他的建议或想法吗？因为我也有过好几年的这种感觉，就像是：“我到底在这里干什么？人们会发现我其实不知道自己在做什么，只要我犯下一个错误，一切都会崩塌。”对于正在经历这些的人，你还有什么建议吗？

---

### (00:11:14) Julie Zhuo

**English:**
I think just exactly what you said, Lenny, right? I think so much of it that helped me was realizing that everyone feels this way to some extent, and that's also why I always want to talk about that, right, because I feel like sometimes you can see from the outside. You're like, "Oh, this person has this title. They have this position. They have these responsibilities. Clearly, they've made it. They know what they're doing." But that's never the case, and I mean, logically let's think about it. Right? If you're going to do anything new for the first time, how are you ever going to feel totally comfortable, totally prepared? Every time, there's something new that you hadn't encountered before, it's always going to be a little bit rough. You're never going to feel perfectly at ease.

**中文翻译:**
我觉得正如你所说的，Lenny。对我帮助最大的一点是意识到每个人在某种程度上都有这种感觉。这也是为什么我总是想谈论这个话题，因为我觉得有时候你从外部看，会觉得：“噢，这个人有这个头衔，有这个职位，有这些责任。显然，他们成功了，他们知道自己在做什么。”但事实并非如此。逻辑上想一想，如果你是第一次做某件新事，你怎么可能感到完全舒适、完全准备好了呢？每当你遇到以前从未遇到过的新事物时，过程总是会有点艰难。你永远不会感到完全自在。

---

### (00:11:50) Julie Zhuo

**English:**
It's only upon doing something multiple times that you start to see the patterns, you start to realize, "Okay, it's going to be all right." And even now the people that I talk to, the people I really look up to, the people who I think are role models and mentors for me, I mean, they regularly also share with me that it's the same. It's like they still encounter things that are unprecedented. Right? And if we work in tech, I mean the rate of change, the rate of the industry and companies and kind of these new experiences that we have, that never goes away. Right? That's just par for the course. And so, I think that feeling always exists.

**中文翻译:**
只有在多次重复做某件事之后，你才会开始看到模式，开始意识到：“好吧，会没事的。”即使是现在，我交谈过的那些我真正仰慕的人，那些我认为是榜样和导师的人，他们也经常向我分享同样的心情。他们仍然会遇到前所未有的事情。如果我们从事科技行业，行业、公司以及我们拥有的这些新体验的变化速度是永远不会消失的。这只是常态。所以，我认为那种感觉一直存在。

---

### (00:12:24) Julie Zhuo

**English:**
I think that what I have learned is that there are better tools in your toolkit for dealing with it. One of them is of course me just reminding myself that if I feel uncomfortable, it's okay. Other people feel that way too. Everyone does. It's totally natural, but then to also find other pieces in that toolkit. Right? One is I am much better at asking for help now than I was earlier in my career. I used to actually just try and hold it all in. I was like, "Hey, I better fake it until I make it. If everyone thinks that maybe I'm coming to a table like I know it, then I can fool them." And now I realize I was really just, I was preventing myself from being able to get that support and that empathy and that camaraderie and that advice that would've helped me actually grow faster and maybe with a little bit less pain in the process.

**中文翻译:**
我学到的是，你的工具箱里有更好的工具来应对它。其中之一当然是提醒自己，如果感到不舒服，没关系。其他人也有这种感觉，每个人都有，这完全是自然的。但也要寻找工具箱里的其他工具。第一，我现在比职业生涯早期更擅长寻求帮助。我以前总是试图把一切都憋在心里。我想：“嘿，我最好‘假装成功直到真正成功’（Fake it until I make it）。如果大家都觉得我胸有成竹，我就能瞒过他们。”现在我意识到，我其实是在阻止自己获得那些支持、共情、战友情谊和建议，而这些本可以帮助我成长得更快，或者在过程中少受点痛苦。

---

### (00:13:09) Julie Zhuo

**English:**
And so, one of the things I learned is it's okay to ask for help. It's okay to reach out to people who both may be going through the same things you're going or maybe are step or two ahead of you in the journey, right, who have actually gone through that and have lived to tell the tale and can tell you it's going to be okay because often that's just what you need. You just need people to tell you, "It's going to be fine. You're fine. You're good. You've got this." And that's so meaningful, right, whenever we sometimes feel down about ourselves. So, that's another, I would say tool in the toolkit, right, asking for help, finding groups of support.

**中文翻译:**
所以我学到的一件事是，寻求帮助是可以的。向那些可能正在经历同样事情的人，或者在旅程中领先你一两步的人寻求帮助是可以的。他们已经经历过这些，并且能够告诉你“一切都会好起来的”，因为通常这就是你所需要的。你只需要有人告诉你：“会没事的。你很好。你很棒。你能行。”当我们对自己感到沮丧时，这非常有意义。所以，这是工具箱里的另一个工具：寻求帮助，寻找支持群体。

---

### (00:13:39) Julie Zhuo

**English:**
And then I think the third is it's also okay to just be vulnerable and just talk to people about it. Right? I found that some of the most meaningful conversations I had, whether with people like managers or whether with my own reports is when we can be much more open about what it is that we find hard, what are we struggling with, and in that way, you actually form deeper connections and people are more able to help out. Right? We can spread the load a little bit. We can put our heads together and brainstorm a better way to solve the problem, and I find that too, even as the head of a department, right, or a founder, it's like I'm not going to solve everything myself. I'm never going to have all the answers. Sometimes by just sharing what the problem is, by sharing the load, we're all going collectively come up with a better solution.

**中文翻译:**
我认为第三点是，表现出脆弱并与人谈论它也是可以的。我发现，无论是在与经理还是与我自己的下属交谈时，一些最有意义的对话都是当我们能够更坦诚地讨论什么是困难的、我们在挣扎什么。通过这种方式，你实际上建立了更深层的联系，人们也更能提供帮助。我们可以分担一些压力，集思广益，寻找更好的解决问题的方法。我发现，即使作为部门主管或创始人，我也无法独自解决所有问题。我永远不会拥有所有答案。有时，仅仅通过分享问题、分担压力，我们就能共同想出更好的解决方案。

---

### (00:14:25) Lenny

**English:**
I love that advice. It's so simple and so effective. Reminds me of advice a coach once told me that when you're in a new role, you are an imposter. You're doing something you've never done before and that's normal and don't feel like that's unusual. So, speaking of being uncomfortable and being vulnerable and doing hard things, you now have a startup that you've started and I'm curious. What's kind of different from the experience of being a leader at a Meta versus being a founder, especially things that maybe are surprising, good or bad?

**中文翻译:**
我喜欢这个建议。它既简单又有效。这让我想起一位教练曾经告诉我的建议：当你处于一个新角色时，你就是一个“冒牌货”。你在做一些你从未做过的事情，这很正常，不要觉得这有什么不寻常。说到不舒服、表现脆弱和做困难的事情，你现在创办了一家初创公司，我很好奇。在 Meta 担任领导者与担任创始人之间有什么不同？特别是那些可能让你感到惊讶的事情，无论是好的还是坏的？

---

### (00:14:52) Julie Zhuo

**English:**
I will say it is definitely a very humbling experience, but it's also exactly the journey that I wanted, and a lot of it is just going back to kind of this like base layer. When you're at a large company, a lot is taken care of for you. Right? If I have a question about, I don't know, finance or how to deal with a people situation, they're experts. There's experts in every single field, and I just go and reach out to them and talk to them and kind of handle that and help me. But when you get back to it, it's like, okay. In the beginning, it was myself and my founder, Chandra. It's just the two of us, and it was like all sorts of stuff that it was like talk about being an imposter. It's setting up, figuring out taxes, or just figuring out how to incorporate, or just thousand little decisions, right, a thousand little things that were new and different.

**中文翻译:**
我想说，这绝对是一次让人保持谦逊（Humbling）的经历，但也正是我想要的旅程。其中很大一部分是回到了最基础的层面。当你在一家大公司时，很多事情都会为你处理好。如果我对财务或如何处理人事情况有疑问，那里有专家。每个领域都有专家，我只需要去找他们谈谈，他们就会帮我处理。但当你回到创业状态，情况就变成了：刚开始只有我和我的合伙人 Chandra。只有我们两个人，要处理各种各样的事情——说到“冒牌货”的感觉，那就是要搞定税务、弄清楚如何注册公司，或者处理成千上万个微小的决定，成千上万件新鲜且不同的事情。

---

### (00:15:34) Julie Zhuo

**English:**
So, there's a huge amount of learning. There's a huge amount of just having to do it all yourself and realizing in a lot of ways just how many things you're bad at, or don't really like to do and that because you don't like to do them, it's hard to get them done. Right? So, it's humbling that way of just helping you realize these things about who you are.

**中文翻译:**
所以有大量的学习。有大量的事情必须亲力亲为，并在很多方面意识到自己有多少事情不擅长，或者根本不喜欢做。而因为你不喜欢做，就很难把它们完成。所以，这种方式让你保持谦逊，帮助你意识到关于你自己的这些特质。

---

### (00:15:52) Julie Zhuo

**English:**
I think the other thing is for me, it's going back to the idea of being much more focused on doing, working with people who are at different stages in their career. When I was leading design for let's say the last five or seven years, right, I was often directly managing senior people, either senior designers or managers or directors and so forth, and going back to working with folks at various stages, including new grads, early career folks, it was actually both me realizing I had to kind of really change a lot of how I manage, so it was, again, also very humbling in that respect. I had to change a lot of what good management looks like in that context which was different from a lot of the habits that I had built up, but it was also so rewarding. I realized I actually really love working with people who are in that early phase of their careers. It's totally different, and what they need and how to best support them is really different than what you would do with a director or very senior person, but it's also just a whole lot of fun.

**中文翻译:**
我认为另一件事是，对我来说，回到了更专注于“做”的状态，并与处于职业生涯不同阶段的人合作。当我领导设计团队的最后五到七年里，我通常直接管理资深人士，比如资深设计师、经理或总监等。现在回到与各个阶段的人合作，包括应届毕业生、职场新人，这让我意识到我必须改变很多管理方式。在这方面，这再次让我感到谦逊。我必须改变在那种背景下“好的管理”的定义，这与我建立的许多习惯不同，但同时也非常有成就感。我发现我其实非常喜欢与处于职业生涯早期阶段的人合作。这完全不同，他们需要的以及如何最好地支持他们，与你对待总监或非常资深的人完全不同，但也非常有意思。

---

### (00:16:50) Julie Zhuo

**English:**
So, that was something that is really new, and then of course, so much of it is again putting that IC hat back on, right, and it's been years since I've actually sat down and designed. Often as a manager, the thing I develop is I develop my eye, but not my hand. So, I learned to be a good critiquer of design, but actually because I stop practicing design, I'm definitely, the limits of what I can actually make and what I can produce myself become really evident. Right? And so, again, back in this new company setting, well, I have to put on a bit of that IC hat. I have to learn how to be kind of an ICPM learn how to be an IC designer, realize that there's so much that I'm actually really bad at as well and in that way, but develop and grow some of my muscles and those skills again.

**中文翻译:**
所以那是很新鲜的事情。当然，很大一部分是重新戴上 IC 的帽子。我已经很多年没有真正坐下来做设计了。通常作为经理，我培养的是“眼力”而不是“手力”。我学会了如何成为一名优秀的设计评论者，但实际上因为我停止了设计实践，我能亲手制作和产出的东西的局限性变得非常明显。所以，回到这家新公司的环境，我必须戴上 IC 的帽子。我必须学习如何成为一名 IC PM，学习如何成为一名 IC 设计师，意识到自己其实在很多方面也很差，并以此重新锻炼和增长这些肌肉和技能。

---

### (00:17:35) Lenny

**English:**
The first point you made about having to do everything again, I remember the reverse of that when we sold our startup. I was so happy just to like, "Okay, here's a one goal we're going to focus on. We don't have to think about everything in the company all the time. I'm just going to hit this one goal, this one product. It's going to be so, so much easier." And that was really fun for a while, and then gets itchy and hard again, and you kind of want to have more responsibility and more challenge.

**中文翻译:**
你提到的关于必须重新亲力亲为的第一点，我记得当我们卖掉初创公司时，情况正好相反。我当时非常高兴，心想：“好吧，现在我们只需要专注于一个目标。我们不必时刻考虑公司里的一切。我只需要达成这一个目标，这一个产品。这会变得非常非常容易。”那段时间确实很有趣，但过了一阵子，手又开始痒了，觉得又变难了，你又会想要更多的责任和挑战。

---

### (00:17:58) Julie Zhuo

**English:**
It's fun though. I am really enjoying it.

**中文翻译:**
但这很有趣。我很享受其中。

---

### (00:18:00) Lenny

**English:**
Oh yeah. I want to transition a little bit to talking about your writing and writing in general. I think I mentioned that your newsletter, The Looking Glass, inspired my writing in a big way. I basically modeled your newsletter and focused it on growth and product. That was the idea. Let me just do what Julie's doing and I'll do it around a different vertical. And so, first of all, I just want to thank you for all the writing that you've done over the years because it was really impactful to me. And so, first of all, I just want to thank you for doing that.

**中文翻译:**
噢是的。我想转而谈谈你的写作以及一般的写作。我想我提到过，你的新闻通讯《望远镜》在很大程度上启发了我的写作。我基本上是模仿了你的新闻通讯，并将其重点放在增长和产品上。当时的想法就是：让我照着 Julie 的做法去做，只是换一个不同的垂直领域。所以，首先，我要感谢你多年来所写的所有文章，因为它们对我产生了很大的影响。首先，我要谢谢你所做的一切。

---

### (00:18:26) Julie Zhuo

**English:**
Oh, thank you for sharing that. It's really meaningful for me to hear as well.

**中文翻译:**
噢，谢谢你告诉我这些。听到这些对我来说也很有意义。

---

### (00:18:29) Lenny

**English:**
I still go back to a lot of your writing, even though I know you've slowed down the focus on the startup which makes a lot of sense, and we'll chat a little bit about that. But I'm curious, what got you to start the writing, and broadly, what impact have you seen it have on your career and just anything in life?

**中文翻译:**
我仍然会经常回顾你的很多文章，尽管我知道你因为专注于初创公司而放慢了写作速度，这完全可以理解，我们稍后会聊聊这个。但我很好奇，是什么让你开始写作的？广义上讲，你认为写作对你的职业生涯以及生活中的其他方面产生了什么影响？

---

### (00:18:43) Julie Zhuo

**English:**
What actually started me on this writing journey was a piece of feedback I got during a performance review cycle, and I remember I was talking to my manager and he shared that, "Hey, one of the pieces of something you should work on, an area of growth is that you have a lot of really great ideas, and you're always really engaged whenever discussions happen in a small forum, one on one, or there's like two or three people in the room, but whenever there's a large room, we're talking about seven people, 10 people, 15 people, you're just sort of quiet and you're not really telling your perspective. You're not really contributing to these larger conversations, and that's something for you to think about and work on."

**中文翻译:**
真正让我开始写作之旅的是我在一次绩效评估周期中收到的一条反馈。我记得当时在和我的经理谈话，他分享说：“嘿，你应该改进的一点，一个成长领域是，你有很多非常棒的想法，而且每当在小型论坛、一对一或者两三个人在场讨论时，你总是非常投入。但每当在大房间里，比如有 7 个人、10 个人、15 个人时，你就会变得很安静，不怎么表达你的观点。你没有真正参与到这些更大规模的对话中，这是你需要思考和改进的地方。”

---

### (00:19:19) Julie Zhuo

**English:**
It was really good feedback because I absolutely felt it. I definitely felt that barrier of speaking up in a large room. I think the fear could be summarized as I don't want to look stupid in front of a lot of people. And so, I had all these barriers. I was like, "Okay, am I sure that what I'm going to say, what comes out of my mouth is absolutely brilliant?" And that was really just this emotion that was getting in the way, and I was like, "Okay, I really want to work on this. I want to figure out how to get that to be less and less of a friction for me."

**中文翻译:**
这是一个非常好的反馈，因为我完全感受到了这一点。我在大房间里发言确实有障碍。我想这种恐惧可以总结为：我不想在很多人面前显得很蠢。所以我有很多心理障碍。我会想：“好吧，我确定我要说的话、我嘴里吐出来的东西绝对精辟吗？”这其实就是一种情绪在作祟。我想：“好吧，我真的很想改进这一点。我想弄清楚如何减少这种阻力。”

---

### (00:19:47) Julie Zhuo

**English:**
And so, it was around I think the January timeframe. Right? So, when the new year came, I was like, "Okay, here's an idea. What if I just did something," that at the time seemed really scary to me which was put my opinion out there on the internet and just do it, just do it for a year. Okay? My goal was post one thing every single week. It seemed terrifying. Right? I'm not sure what people are going to say. Again, maybe all my ideas are stupid, but I just want to get better at doing that, and hopefully, through that year, get more comfortable with that.

**中文翻译:**
大约是在一月份的时候。新年来临时，我想：“好吧，有个主意。如果我做一件当时对我来说非常可怕的事情呢？”那就是把我的观点发布到互联网上，坚持做一年。我的目标是每周发布一篇文章。这看起来很吓人。我不确定人们会说什么。再说一次，也许我所有的想法都很愚蠢，但我只想变得更擅长表达，并希望通过那一年的时间，让自己对此感到更自在。

---

### (00:20:18) Julie Zhuo

**English:**
So, that's how this whole writing thing began. It came with this kind of New Year's resolution of just 52 times, I was going to click publish on something, some opinion piece. And I was like, "It doesn't have to even be..." It doesn't even matter what the opinion is. Just put something out there and just expose yourself a little bit in that manner. So, that's what I did, and I tried to not have any goals around, well, maybe people will read it, maybe it'll be considered high quality. Those are all just, again, additional barriers that I was putting that would make me even harder for me. The only goal was to hit the publish button.

**中文翻译:**
这就是整个写作事情的开端。它源于一个新年决心：我要点击 52 次“发布”按钮，发布一些观点文章。我想：“甚至不需要……”观点是什么并不重要。只要把东西发出来，以这种方式稍微暴露一下自己。所以我就是这么做的，我尽量不去设定任何目标，比如也许人们会读它，也许它会被认为是高质量的。这些都只是我给自己设置的额外障碍，会让事情变得更难。唯一的目标就是按下“发布”按钮。

---

### (00:20:49) Julie Zhuo

**English:**
And the first couple weeks were actually quite excruciating. I remember I just spent hours on this piece and I just kept editing it, and I was like, "I don't know if this is any good? Should I actually publish it?" And so forth, but eventually, I did it. Right? And again, little by little, it started to just become easier as anything does when it's done a lot. So, by week 10, by week 15, I had gotten into a bit of a cadence, and I realized something that was having an impact on my work. I realized that it became much more clarifying for me to have that space to be able to write, and it almost became a kind of self-therapy because through the week I would have all these thoughts running around my head, things I wanted to get better at, pieces of product that I was mulling on, and the act of writing allowed me some quiet time to just sit down and try and organize those different threads of thoughts.

**中文翻译:**
最初的几周其实挺痛苦的。我记得我花了好几个小时写一篇文章，然后不停地修改，心想：“我不知道这好不好？我真的应该发布吗？”等等。但最终，我做到了。就像任何事情做多了都会变容易一样，一点一点地，它开始变得简单。到了第 10 周、第 15 周，我找到了一定的节奏，并且意识到写作正在对我的工作产生影响。我发现，拥有写作的空间让我思路变得清晰得多，它几乎成了一种自我疗愈。因为在一周中，我脑子里会有各种各样的想法，我想改进的事情，我正在思考的产品细节，而写作的行为让我有一段安静的时间坐下来，尝试理清这些不同的思绪。

---

### (00:21:40) Julie Zhuo

**English:**
I approach my writing then and I still do now as letters to myself. This is the framework. This is the advice that I need to give myself that I need to go and really do better, and that is what my writing became for me, and it was hugely helpful for clarifying my train of thought. It was hugely helpful for me to then be able to do a better job of expressing myself, and by the end of that year, I saw a huge difference in my ability then in large meetings to speak up and to become more comfortable.

**中文翻译:**
我当时把写作看作是写给自己的信，现在依然如此。这是框架，这是我需要给自己的建议，是我需要去做得更好的地方。这就是写作对我的意义，它对理清我的思路非常有帮助。它极大地帮助我更好地表达自己。到那年年底，我发现自己在大型会议上发言的能力有了巨大的提升，变得更加自如。

---

### (00:22:11) Julie Zhuo

**English:**
But even after that year, because I had seen all of these advantages in what it did for my clarity of thinking, and I just decided to continue, and it became also a really, I think, a wonderful side effect that other people started to resonate with the writing. They were like, "Oh, this is actually helpful for me, or I was feeling the same thing, or this gave me a little bit of additional structure to think about the problem," and that was also extremely motivating, but I will say that what I think helped me continue the writing habit is I always did it for me. I always did it because I felt that there was a lot that I had to gain from it, and it's been obviously a wonderful experience to connect with readers and other people in the community about it. It definitely made me feel less alone. It definitely confirmed a lot of the ideas that I had about is this the right way to think about something. It led to a lot of really rich discussion with my colleagues and with people who just emailed or responded about the writing. So, that was a wonderful side benefit as well. But yeah, I really credit my ability to think better through the process and the practice of writing.

**中文翻译:**
即使在那一年之后，因为我看到了写作在理清思路方面的所有优势，我决定继续写下去。而且我认为这产生了一个美妙的副作用：其他人开始对我的文字产生共鸣。他们会说：“噢，这对我也很有帮助，或者我也有同样的感觉，或者这给了我思考问题的额外框架。”这也非常有动力。但我必须说，我认为帮助我坚持写作习惯的原因是我始终是为自己而写。我写是因为我觉得自己能从中获益良多。显然，能与读者和社区中的其他人建立联系是一段美妙的经历。它确实让我觉得不再孤单。它肯定了我关于“这是否是思考某事的正确方式”的许多想法。它引发了我与同事以及那些发邮件或回复文章的人之间许多丰富的讨论。所以，这也是一个美妙的额外收益。但是，是的，我真的将自己思考能力的提升归功于写作的过程和实践。

---

### (00:23:14) Lenny

**English:**
That's such a cool story. I love that it was kind of driven by a manager, but kind of led to so many externalities. One thing I wanted to ask you is how did you find time to this writing? People always want to write and very few people do or find time to. How did you actually make the time and keep that up?

**中文翻译:**
这真是一个很酷的故事。我喜欢它是由经理驱动的，但却带来了这么多外部效应。我想问你的一件事是，你是如何挤出时间写作的？人们总是想写作，但很少有人能真正做到或找到时间。你是如何腾出时间并坚持下去的？

---

### (00:23:29) Julie Zhuo

**English:**
So, I actually had this practice of writing even before I did this more publicly with a blog, and it was because I harbored this dream back when I was a teenager and well into my college years of one day writing the next great American novel. So, I wrote a lot of fiction and I wrote a lot of... I have four unpublished novels just collecting dust. They're not very good. I can say that now with a lot more objectivity.

**中文翻译:**
其实在我开始公开写博客之前，我就有写作的习惯。那是因为我从青少年时期到大学时代一直怀揣着一个梦想：有一天能写出下一部“伟大的美国小说”。所以我写了很多小说，我还有四部未出版的小说在吃灰。它们写得不太好，我现在可以更客观地这么说了。

---

### (00:23:52) Julie Zhuo

**English:**
But I did that, and I would participate in this program called NaNoWriMo every year which later I was fortunate enough to be on the board for a number of years. But what NaNoWriMo was is this idea of... It Stands for National Novel Writing Month in November. So, it's exactly what it sounds like. In the month of November, the goal is to write 50,000-word novel in 30 days, and the whole purpose and the whole point of NaNoWriMo, and again, I did it for a number of years in my early twenties, it's all about just getting the words out. Right? It's not about, hey, is every paragraph, is every sentence pristine, or do you have the right beginning, middle, end. It was like no. It was like you're going to write a novel every single day. You need to write 1,667 words, and you just do that over 30 days, you'll have 50,000 words.

**中文翻译:**
但我确实写了，而且我每年都会参加一个叫 NaNoWriMo 的项目，后来我有幸在该项目的董事会任职多年。NaNoWriMo 的意思是“国家小说写作月”，在 11 月举行。顾名思义，在 11 月份，目标是在 30 天内写出一部 5 万字的小说。NaNoWriMo 的核心目的——我在二十岁出头的时候参加了好几年——就是把文字写出来。它不在于每一段、每一句是否完美，也不在于是否有完美的开头、中间和结尾。不，它的要求是每天都要写。你需要每天写 1,667 个单词，坚持 30 天，你就有 5 万字了。

---

### (00:24:37) Julie Zhuo

**English:**
The whole premise was, yeah, no, those 50,000 words, they're definitely going to be junk. They're not going to be really good. But at the end you'll have something that you can then edit and then you can shape and you refine. Right? And the hardest part is just getting started. It's just getting past the blank screen and the first page.

**中文翻译:**
整个前提是，是的，那 5 万字肯定都是垃圾，不会写得很好。但最后你会得到一些可以编辑、塑形和精炼的东西。最难的部分就是开始，就是越过空白的屏幕和第一页。

---

### (00:24:55) Julie Zhuo

**English:**
And so, because I'd gone through that experience, I had really internalized that writing for me is just get the words out. It is just about the sit your butt in the seat and just do it, get the word count goal out or get a time goal. I actually like word count goal even better than time goal because sometimes you can spend 30 minutes and then still just produce a sentence, and so, that was always how I approached my writing. I was like, "All right, I'm going to sit my butt down. I'm going to write for 30 or 45 minutes, but it's going to be, whatever, like 250 words. It's going to be 500 words. It's going to be this number of words." And that just gave me the discipline to just get it out and then think about revising, think about quality, think about all that later.

**中文翻译:**
因为有过那段经历，我真正内化了一个观念：对我来说，写作就是把话写出来。就是坐下来，硬写，达成字数目标或时间目标。实际上，我喜欢字数目标胜过时间目标，因为有时你花了 30 分钟，却只写出了一句话。所以我总是这样对待写作。我会想：“好吧，我要坐下来，写 30 到 45 分钟，但必须写出 250 字或 500 字，或者某个确定的字数。”这给了我一种纪律，让我先把它写出来，然后再去考虑修改、质量以及之后的一切。

---

### (00:25:32) Julie Zhuo

**English:**
And when I got into writing my book, that was exactly how I approached the first draft. I was like, "Okay, I'm going to divide up. It needs to be 60 or 70,000 words. I have like a year. I'm going to divide it up into the number of days and weeks." And I think what it came down to for me was five nights a week, I needed to write 500 words each day, and I eventually got that down to, it was like 30 or 45 minutes. I mean, some days, a little longer, other days, a little shorter, but it was about that, and I just kept that weekly goal up until the book was written.

**中文翻译:**
当我开始写书时，我写初稿的方式也是一模一样的。我想：“好吧，我要分摊任务。这本书需要 6 万到 7 万字。我有一年的时间。我要把它分摊到每一天和每一周。”最后，我的计划是每周五个晚上，每天写 500 字。最后我发现这只需要 30 到 45 分钟。有些日子长一点，有些日子短一点，但大概就是这样。我一直坚持这个每周目标，直到书写完。

---

### (00:26:01) Lenny

**English:**
Speaking of the book, I definitely wanted to chat about that briefly. Did you always know you wanted to write a book or is this kind of a thing that emerged from people just asking you the same questions again and again, and then similarly, what impact have you seen from that book, which I own many copies and have gifted many copies?

**中文翻译:**
说到那本书，我确实想简短地聊聊。你是一直就知道自己想写一本书，还是因为人们一遍又一遍地问你同样的问题而产生的想法？同样地，你看到了那本书产生了什么影响？我自己买了很多本，也送出了很多本。

---

### (00:26:15) Julie Zhuo

**English:**
Thank you. I had this dream that I would write the great American novel. I still want to do that someday. One day, I really do want to sit down and hopefully write a fiction book. So, I always had that on my mind. I don't think I ever thought that I would write a non-fiction book. I never thought I would write a business book, right? That really came about organically, and it came about because I was writing this blog and I was publishing these letters to myself that I was again putting on the internet, and then occasionally, I would have publishers or various folks reach out and say, "Oh, this was a really great article. Have you ever thought about developing that into a book?" And my answer for the longest time was always like, "No, because I don't think I have the stamina to make this one topic into this huge thing. I don't think about myself as kind of like a career writer." Honestly, there wasn't necessarily anything that I felt that differentiated or maybe a unique angle.

**中文翻译:**
谢谢。我曾梦想写出伟大的美国小说。我仍然希望有一天能做到。有一天，我真的很想坐下来写一本虚构类的小说。所以我一直有这个念头。但我从未想过我会写一本非虚构类的书，从未想过我会写一本商业书。这真的是自然而然发生的。因为我一直在写博客，发布那些写给自己的信，然后偶尔会有出版商或各种各样的人联系我说：“噢，这是一篇非常棒的文章。你有没有想过把它扩展成一本书？”在很长一段时间里，我的回答总是：“没有，因为我觉得我没有精力把这一个话题变成这么大的一件作品。我不认为自己是一个职业作家。”老实说，我当时并不觉得有什么差异化或独特的视角。

---

### (00:27:03) Julie Zhuo

**English:**
I also felt that most books that I read, there was always a huge amount of research that went into it, and I was like, "I just..." I know this about myself. I don't love research, not great at it. I don't want to sit there and compile a bunch of stats and whatnot to make an argument. But one day, a publisher reached out and they were like, "You know, we had some ideas about the fact that you're writing really, especially the part about for new managers, your advice for new managers or for people new to leadership, it really seems like it strikes a chord for that particular audience, and we have some ideas. Why don't we get on the phone to discuss?" I took that call and actually really was... That call just did change my perspective because it gave me a particular angle on something that I felt was missing in the market. Right?

**中文翻译:**
我还觉得我读过的大多数书都投入了大量的研究，而我……我很了解自己。我不喜欢研究，也不擅长。我不想坐在那里为了证明一个论点而汇编一堆统计数据之类的东西。但有一天，一位出版商联系了我，他们说：“你知道吗，我们有一些想法，关于你写的那些内容，特别是针对新经理的部分，你给新经理或新领导者的建议，似乎真的引起了那个特定群体的共鸣。我们有一些想法，不如通个电话讨论一下？”我接了那个电话，实际上……那个电话确实改变了我的看法，因为它给了我一个特定的角度，让我看到了市场上缺失的东西。

---

### (00:27:44) Julie Zhuo

**English:**
Again, most of the stuff that I'm writing, again, they're advice to myself, but I was brought back to when I first became a manager, and I went back, I went to the bookstore one day, I was looking for resources on what it means to manage and stuff that would help me become a better manager, and not a lot of it spoke to me because it seemed like most management books were written by CEOs who had been leading their company for years and years, or it was by management consultants who didn't really seem like they had been in the situation of just like, "Hey, I was an IC on the team, and now next week I have four reports that I'm going to be working with."

**中文翻译:**
再说一次，我写的大部分内容都是给自己的建议。但我回想起了我刚成为经理的时候。我记得有一天去书店，寻找关于管理的资源，寻找能帮助我成为更好经理的东西。但没多少内容能打动我，因为大多数管理书籍似乎都是由领导公司多年的 CEO 写的，或者是管理顾问写的，他们似乎并没有经历过那种“嘿，我原本是团队里的 IC，下周我就要有四个下属要带了”的情况。

---

### (00:28:20) Julie Zhuo

**English:**
There just wasn't that much for the completely new manager who didn't have an MBA, wasn't on some sort of ladder, and just one day got dropped and asked to kind of go and support a couple people who were starting next week. I was brought back to that moment in time and realizing there really isn't that much that is great out there that is particularly geared for new managers, and I felt that I had to really learn and make a lot of these mistakes on my own, and even very fundamentally, I don't think that people ever really explained to me, what is a manager, what does it mean to do a good job as a manager of a handful of people. Right?

**中文翻译:**
对于那些没有 MBA 学位、没有经过某种晋升阶梯、只是有一天突然被委以重任去支持下周入职的几个人的纯新手经理来说，市面上真的没有太多好的资源。我回到了那个时刻，意识到真的没有什么特别针对新经理的好东西。我觉得我必须独自学习并犯下很多错误。甚至从根本上说，我认为从来没有人真正向我解释过：什么是经理？作为一个管理几个人的经理，做好工作的定义是什么？

---

### (00:28:56) Julie Zhuo

**English:**
And so, it sparked this idea that this was something that was somewhat missing in the market, that there was an opportunity to just really write something that could speak to people like me and people, again, similar to me who maybe weren't on this ladder for 10 or 12 years, especially in tech, right, I knew many people who had gone through that. Then the second thing for me is I realized that I would likely also become a better manager through this process because it would force me to think about management a lot every single day. It would force me to reflect on my frameworks for management, and whenever you think about something all the time in the back of your head, it's just more top of mind. I was looking to become a better manager myself at that point, and that was the additional boost that I needed to commit to the project.

**中文翻译:**
所以这激发了我的想法：这是市场上缺失的东西，这是一个机会，可以写一些真正能引起像我这样的人共鸣的东西。特别是那些在科技行业，可能没有经过 10 到 12 年晋升阶梯的人，我知道很多人都有这种经历。对我来说，第二点是，我意识到通过这个过程，我也可能会成为一个更好的经理，因为它会迫使我每天深入思考管理。它会迫使我反思我的管理框架。当你脑子里一直思考某件事时，它就会变得更重要。当时我也想让自己成为更好的经理，这成了我投入这个项目所需的额外动力。

---

### (00:29:39) Lenny

**English:**
Has that last piece bitten you in the butt at all, when you maybe make a mistake as a manager and people are like, "Julie, you wrote this book on management. What the hell's going on?"

**中文翻译:**
最后那一点有没有让你“搬起石头砸自己的脚”？比如当你作为经理犯错时，人们会说：“Julie，你可是写过管理书的人，这到底是怎么回事？”

---

### (00:29:47) Julie Zhuo

**English:**
I always tell people, I tell my own reports as well, it's like, "You might come in and you might have read my book and you might think that somehow I am a really great manager and an expert in management, and I always try. I'm going to lower your expectations. I'm still learning." There's a lot of things that I'm still working on that I know I'm not perfect at, but that's what I think it is. Right? I think so much about, for me, at least, learning to be a better manager, and I know I'll probably be on this journey for the rest of my life is that you can know oftentimes the theory because the theory is it makes sense, right? It's like, okay, we all been in that situation. We can feel. It is so hard to just actually put it in practice. It's so hard to do some of these things every single day because they're sort of counterintuitive and it is so hard to apply it to the appropriate context.

**中文翻译:**
我总是告诉别人，也告诉我的下属：“你进来时可能读过我的书，可能觉得我是一个非常优秀的经理和管理专家。但我总是会降低你的期望：我还在学习。”有很多事情我仍在努力改进，我知道自己并不完美。但这就是我的看法。对我来说，学习成为一个更好的经理——我知道我余生可能都会在这条路上——是因为你通常可以了解理论，因为理论是讲得通的。但是，要把理论付诸实践真的很难。每天做这些事情很难，因为它们往往是违背直觉的，而且很难应用到恰当的语境中。

---

### (00:30:30) Julie Zhuo

**English:**
Just even the example I gave earlier, managing early career, new grads is just completely different than managing really senior people and being able to tailor to each individual person or each specific group of people because humans are, we're all different. We're all unique. Right? No two people are the same. No groups of people are the same. So, it is an art as anything else. A lot of it too is about learning about who I am, what am I good at, what am I not good at, how can I be more honest and more authentic to my own strengths and weaknesses, and then be able to pair that up with the person that I'm talking to or the group of people that I'm working with. So, definitely not by any means today still consider myself great or an expert or whatnot. I think everyone else, I'm still trying to get better.

**中文翻译:**
就像我之前举的例子，管理职场新人、应届生与管理资深人士完全不同。你需要能够针对每个人或每个特定群体进行调整，因为人都是不同的，都是独特的。没有哪两个人是完全一样的，也没有哪两个群体是完全一样的。所以这和其他事情一样，是一门艺术。很大程度上也是关于了解我是谁，我擅长什么，不擅长什么，我如何能对自己优缺点更诚实、更真实，然后将其与我交谈的人或合作的群体相匹配。所以，我绝对不认为自己现在已经很伟大了，或者是什么专家。和大家一样，我也还在努力变得更好。

---

### (00:31:14) Lenny

**English:**
That's a little bit how I feel where people think that I've got it all figured out, I'd be like the most amazing product manager they've ever worked with, and I feel like I could never get a regular job again, because the hype. The expectations would be way too high. People forget that I have time to think, research, process, and that kind of thing. And so, I can never get a PM job again. This is basically the problem that I've created for myself.

**中文翻译:**
我也有点这种感觉。人们觉得我已经把一切都搞清楚了，觉得我会是他们合作过的最出色的产品经理。我觉得我再也找不到一份普通的工作了，因为名声在外，期望值会太高。人们忘了我有时间去思考、研究、处理这些事情。所以我再也找不到 PM 的工作了。这基本上是我为自己制造的问题。

---

### (00:31:36) Julie Zhuo

**English:**
I think you'd be a pretty great PM, Lenny.

**中文翻译:**
我觉得你会是一个非常棒的 PM，Lenny。

---

### (00:31:38) Lenny

**English:**
It's all an illusion, but I appreciate it. And then the other piece is that you pointed this out, that a lot of people don't realize when folks like us write, it's like us figuring it out. It's not like we have the answer and we're just like, "Okay, here, I'm just going to write down the answer I already have in my head." The process of writing is how we learn a lot about these sorts of things, and a lot of people don't realize that.

**中文翻译:**
那都是幻觉，但我心领了。另一点正如你指出的，很多人没有意识到，当像我们这样的人写作时，其实是我们自己在梳理思路的过程。并不是说我们已经有了答案，然后说：“好吧，我现在就把脑子里的答案写下来。”写作的过程正是我们学习这些事情的方式，很多人没有意识到这一点。

---

### (00:31:56) Julie Zhuo

**English:**
Yeah, I absolutely agree. Like I said, it's about reminding ourselves. Right? I always often say I'm the number one audience for my own writing because I'm the person who needs to really hear it the most.

**中文翻译:**
是的，我完全同意。就像我说的，这是为了提醒我们自己。我经常说，我是自己文章的第一号读者，因为我是那个最需要听到这些话的人。

---

### (00:32:06) Lenny

**English:**
That's exactly how I feel a lot of times. When I go back to my own pieces, like, "Oh yeah. Okay. That's what I wanted to remember." On the writing, something I wanted to ask about is you've kind of slowed down for a good reason. You have a startup to run and you've started doing more tweeting than news lettering and blogging. How do you think about that? Just, is that intentional? How do you think about, I don't know, Twitter versus newsletters and other things?

**中文翻译:**
很多时候我也有同感。当我回顾自己的文章时，会想：“噢，对。好吧。这就是我想记住的东西。”关于写作，我想问的是，你最近放慢了速度，这有很好的理由——你要经营一家初创公司。而且你开始更多地发推特（Twitter），而不是写新闻通讯和博客。你是怎么想的？这是有意的吗？你是如何看待推特与新闻通讯等其他形式的区别的？

---

### (00:32:25) Julie Zhuo

**English:**
Yeah, it was very much. This is another New Year's resolution that came up later. Right? One of the things that I recognize about myself is I kind of have a tendency to ramble, and I've gotten this feedback as well in 360s where I'm not always the clearest communicator. I can be a pretty good storyteller and I am clearer in writing often than I am in person, but this was another area that I wanted to get better at. Right? I wanted to get better at in the moment communicating more clearly and being just a little bit sharper, a little bit crisper in the points that I had to make.

**中文翻译:**
是的，确实如此。这是后来出现的另一个新年决心。我意识到自己有一个倾向，就是说话容易啰嗦。在 360 度评估中我也收到过这样的反馈，说我并不总是最清晰的沟通者。我可以是一个很好的讲故事的人，而且我在写作时通常比面对面交流时更清晰。但这是我想改进的另一个领域。我想提高即时沟通的清晰度，让我的观点更犀利、更干脆利落。

---

### (00:32:56) Julie Zhuo

**English:**
I remember I work with a number of colleagues who are just so good at this. Right? There will be some really complex topic, this big product thing that we're trying to figure out, and in the moment, they would go and they would say, "Okay, I see. This is what the problem is. The problem is one, blah, blah, blah, blah, blah, two, blah, blah, blah, three. Right?" Everybody like, "Yeah, that's amazing. That's so crystal clear." This huge thing we're all talking past each other there now became boiled to something so sharp and so beautiful. Right? I always had so much respect and admiration for the people who could do that, and that wasn't me, but I was like, "Okay, well, as anything, if I have a thing I like and want and admire and respect, I could at least get better at it. Maybe I'll never be at that level, but I can work towards it."

**中文翻译:**
我记得我的一些同事非常擅长这一点。面对一个非常复杂的话题，或者我们试图弄清楚的一个重大产品问题，他们会当场说：“好的，我明白了。问题在于：第一，某某某；第二，某某某；第三，某某某。”大家都会觉得：“哇，太棒了，太清晰了。”原本大家各说各的、一团乱麻的事情，现在被浓缩成了如此犀利、如此优美的东西。我一直非常尊敬和钦佩能做到这一点的人，而我以前不是这样的人。我想：“好吧，就像任何事情一样，如果我喜欢、想要、钦佩并尊重某种能力，我至少可以变得更好。也许我永远达不到那个水平，但我可以朝着那个方向努力。”

---

### (00:33:36) Julie Zhuo

**English:**
And one of the ways I saw of working towards that is, well, let's just change it up. I'd been doing long-form, which again, works really well for these stories and this kind of more meandering prose, but what if I just push myself to communicate in a much shorter form which is going to force me to really strip away all that ornamentation and focus on the core idea. And I was like, "I'm just going to go and publish threads on Twitter for a year." Again, same thing. Write once a week a little thread and just take whatever is the advice I needed to give myself and then boil that down to a tweet form. So, also, it has helped me. It has helped me to get better at enumerating things. I think more naturally now sometimes. It's like 1, 2, 3, and that has helped me as well in just, again, the day job and the way that I communicate. Still a long ways to go. But I think Twitter is really great at that. It's really great at trying to boil it down to the essence of what it is that one wants to communicate.

**中文翻译:**
我发现实现这一目标的方法之一就是：改变形式。我一直在写长篇文章，这对于讲故事和这种比较随性的散文非常有效。但如果我强迫自己用更短的形式沟通呢？这会迫使我剥离所有修饰，专注于核心思想。于是我想：“我要在推特上发布一年的 Thread（系列推文）。”同样的方法：每周写一个简短的 Thread，把我要给自己的建议浓缩成推文的形式。这确实帮到了我。它帮我变得更擅长列举要点。我现在思考时会更自然地想到“1, 2, 3”，这在我的日常工作和沟通方式中也很有帮助。虽然还有很长的路要走，但我认为推特在这方面非常棒。它非常适合将想要表达的内容浓缩成精华。

---

### (00:34:27) Lenny

**English:**
I love that you use these tools to help work on a very specific skill that you're hoping to develop. So, you said that worked. Is that something you'd recommend to folks that are working on something like this and have a challenge there too?

**中文翻译:**
我喜欢你利用这些工具来磨练你希望发展的特定技能。既然你说这很有效，你会向那些也在努力提升类似技能、面临类似挑战的人推荐这种方法吗？

---

### (00:34:38) Julie Zhuo

**English:**
I do. I talk to a lot of people who want to write more because they feel like there is a lot of benefits, and maybe it's because writers often talk about all of the benefits, but a lot of people do maybe find it, as you were saying earlier, hard to get started. Right? My number one advice is try to find an angle that's going to work for you because if you find yourself writing for your audience, if you find yourself writing because you want likes or you want a certain number of views, that actually is a really hard barrier to overcome because you don't have control over all of that. But if you write because you're trying to work on a particular key skill, whether it is clarity of thinking, whether it's helping you work through some stuff that's complicated in your mind, whether it's just, again, working on being more comfortable, putting your voice out there, then make it a goal, but make it a action goal. Make it like a word count goal.

**中文翻译:**
是的。我遇到过很多人想多写点东西，因为他们觉得写作有很多好处。也许是因为作家们经常谈论这些好处，但很多人可能发现，正如你之前所说的，很难开始。我最重要的建议是：尝试找到一个适合你的角度。因为如果你发现自己是为了观众而写，为了获得点赞或一定的浏览量而写，那实际上是一个很难克服的障碍，因为你无法控制这些。但如果你写作是为了磨练某项关键技能——无论是思维的清晰度，还是帮助你理清脑子里复杂的事情，或者是为了让自己更自如地发出声音——那么就把它设定为一个目标，但要是一个“行动目标”。比如设定一个字数目标。

---

### (00:35:26) Julie Zhuo

**English:**
I saw this on Twitter, I think it was that last year, the idea of the 30 days of just writing a thing every day or tweeting a thing every day. Right? You see this in design too. There's Inktober which is you just draw a thing every single day in the month of October, and I love those types of structures and programs. I think that they're a way to go and get into the habit of that. Everyone kind of feels like they can do anything for 30 days. You can do anything for three months if you just commit to doing it once a week. It doesn't have to be forever. It doesn't have to be some sort of like five-year thing and the commitment. That's a huge milestone. You just have to do it for a little bit and then reflect on it. Is it really helping you? Is it actually helping you get closer to that goal? And that's usually the easiest way I've found to get started.

**中文翻译:**
我在推特上看到过，好像是去年，有人提出“连续 30 天每天写点东西或发条推文”的想法。在设计领域也能看到这种做法，比如 Inktober（十月绘），即在十月份每天画一幅画。我喜欢这种结构和计划。我认为这是养成习惯的一种方式。每个人都会觉得自己在 30 天内可以做任何事情。如果你承诺每周做一次，你可以坚持三个月。它不需要是永久的，不需要是某种五年计划的承诺。那是一个巨大的里程碑。你只需要做一小段时间，然后反思：它真的对你有帮助吗？它真的让你更接近那个目标了吗？这是我发现的最简单的开始方式。

---

### (00:36:05) Lenny

**English:**
I love that. Just creating a little bit of structure for yourself so you don't have to think about it, you just do it, and I don't care what I do on that day, but I'm doing it, and maybe one time something will come out really great.

**中文翻译:**
我喜欢这个。为自己建立一点结构，这样你就不必思考，直接去做。我不在乎那天我做了什么，但我一定要做。也许有一次，会做出非常棒的东西。

---

### (00:36:16) Lenny

**English:**
This episode is brought to you by Sprig. If you've been a member of my community for a while, you know I'm a user, fan, and investor in Sprig. Sprig is a user research platform that makes getting user insights from your product as easy and fast as getting analytics. The best product and research teams at companies like Loom, Opendoor, and Dropbox use Sprig's in-product surveys to target specific users, start collecting insights, and identify issues and opportunities related to activation onboarding engagement and more. Talk about a platform that pays for itself.

**中文翻译:**
本集节目由 Sprig 为您呈现。如果你加入我的社区有一段时间了，你就会知道我是 Sprig 的用户、粉丝和投资者。Sprig 是一个用户研究平台，它让从产品中获取用户洞察变得像获取分析数据一样简单快捷。Loom、Opendoor 和 Dropbox 等公司的顶尖产品和研究团队都在使用 Sprig 的产品内调查来针对特定用户、开始收集洞察，并识别与激活、入职、参与度等相关的各种问题和机会。这是一个真正能收回成本的平台。

---

### (00:36:48) Lenny

**English:**
But I'm perhaps most excited about Sprig's newest launch which extends the power of the platform prelaunch and makes it possible to test mockups and prototypes with your own users in minutes. The testing interface is super slick and doesn't require any of the typical plugins that make testing with your own users unappealing, and with unlimited seats, you're able to invite anyone from your company to view and use insights generated by Sprig. If you want to get started, head over to sprig.com/lenny and mention that I sent you.

**中文翻译:**
但我最兴奋的可能是 Sprig 最新发布的功能，它将平台的能力扩展到了发布前，让你可以在几分钟内用自己的用户测试模型和原型。测试界面非常流畅，不需要任何那些会让用户测试变得乏味的典型插件。而且由于席位不限，你可以邀请公司里的任何人查看和使用 Sprig 生成的洞察。如果你想开始体验，请访问 sprig.com/lenny 并提到是我推荐的。

---

### (00:37:18) Lenny

**English:**
That reminds me of something I wanted to plus-one, the point that especially on Twitter, I find whenever you're trying to go viral, it just comes across often is just like, okay, they're just trying to go viral. So lame. This person just wants a lot of likes versus I just want to share a thing that's interesting to me quickly, or here's how I want to think about it, or here's just a thing I want to remember in the future. I find those end up being a lot more successful.

**中文翻译:**
这让我想起我想补充的一点，特别是在推特上，我发现每当你试图“走红”时，给人的感觉往往是：好吧，他们只是想红。这太逊了。这个人只是想要很多赞。相比之下，如果只是“我想快速分享一件我觉得有趣的事”，或者“这是我的思考方式”，或者“这是我想在未来记住的一件事”，我发现这些内容最终往往会成功得多。

---

### (00:37:40) Julie Zhuo

**English:**
That's right. Yeah, that's totally right. I think it's what really gets you interested in it is likely the thread that you want to enroll and to continue to explore. If you're just try and say what you think people want to hear, it just comes across not that genuine, and personally, not that interesting.

**中文翻译:**
没错。是的，完全正确。我认为真正让你感兴趣的东西，才可能是你想要展开并继续探索的线索。如果你只是试图说一些你认为人们想听的话，那就会显得不那么真诚，而且就我个人而言，也不那么有趣。

---

### (00:37:55) Lenny

**English:**
Yeah, the thing I've kind of learned is if I find something interesting, other people will find it interesting, and so, I'll just share that in some form and often ends up being really helpful to a lot of people. Speaking of Twitter, one of the threads I've liked best that you've written about, and I think you've done this a couple times, is around product thinking and product sense and how to build that muscle. And so, I'd love to just hear your advice on for folks that are thinking about how do I get better at product sense and product thinking. What are ways that people can get better at these things?

**中文翻译:**
是的，我学到的一点是，如果我觉得某件事有趣，其他人也会觉得它有趣。所以我就会以某种形式分享出来，结果往往对很多人都很有帮助。说到推特，我最喜欢的你写过的 Thread 之一（我想你写过好几次）是关于产品思维（Product Thinking）和产品感（Product Sense）以及如何锻炼这项能力的。我很想听听你对那些思考“如何提高产品感和产品思维”的人有什么建议。人们可以通过哪些方式在这些方面做得更好？

---

### (00:38:20) Julie Zhuo

**English:**
The number one advice that I always have for people when talking about product sensor or product thinking is it's just really about observation and it's about curiosity and can start by first observing yourself. Every time you're going to go and use something, every time you're going to have a new experience, you download an app, you try something new, it's take the moment to reflect on your emotion or your assumption at every step. Right? What was the new user experience? At what moment did it become clear to you what was going on? When were you confused? How many times did you tap something and then had to exit because you went down a wrong pathway? And even before that, it's like what even led you to trying this service in the first place to downloading the app? Was it word of mouth? Did you see something on the internet? Did somebody that you respect pitch it?

**中文翻译:**
在谈到产品感或产品思维时，我给人们的首要建议是：这其实就是关于观察和好奇心，可以从观察你自己开始。每当你去使用某样东西，每当你有一个新的体验——下载一个 App，尝试一件新鲜事——花点时间反思你在每一步的情绪或假设。新用户体验如何？在哪个时刻你清楚地知道了发生了什么？你什么时候感到困惑？你有多少次点击了某个东西，然后因为走错了路径而不得不退出？甚至在此之前，是什么促使你最初尝试这项服务或下载这个 App 的？是口碑传播吗？你在网上看到了什么吗？还是你尊敬的人向你推荐了它？

---

### (00:39:07) Julie Zhuo

**English:**
But these are all ways in which we're learning about how things work, how products work. It always starts by just if you first observe yourself, then you'll make a lot of progress. Right? And oftentimes it's hard to do that because sometimes we're just, we're going through the motions or we're not necessarily sitting down and analyzing every step of it. But the first step I think is just to get really good, comfortable, familiar, habitual with just that personal observation.

**中文翻译:**
这些都是我们学习事物运作方式、产品运作方式的途径。如果你先观察自己，你就会取得很大进步。通常这很难做到，因为有时我们只是在机械地操作，而不一定会坐下来分析其中的每一步。但我认为第一步就是让自己非常擅长、自如、熟悉并习惯于这种个人观察。

---

### (00:39:31) Julie Zhuo

**English:**
The second step is then, okay, cool, you do that for yourself. Well, that's not enough because you're not the world. Right? You don't necessarily represent everyone, but now it's to just build on those circles. So, the next thing you do is you go and actually observe and share those observations with somebody else, and so, how that often looks is discussions about products. So, you download this, why did you download this? What made you decide that this was a great app? Do you think it's a great app? What was compelling about it? And to just really find the curiosity of thinking through which decisions did the builders or the creators of something make and what was the impact of it on us users, us customers and so forth.

**中文翻译:**
第二步是，好吧，你为自己做了这些。但这还不够，因为你并不代表全世界。你并不一定代表所有人。所以现在要扩大这个圈子。接下来的事情就是去观察并与他人分享这些观察结果。这通常表现为关于产品的讨论。比如，你下载了这个，你为什么下载它？是什么让你觉得这是一个很棒的 App？你觉得它棒吗？它有什么吸引人的地方？真正带着好奇心去思考：构建者或创造者做出了哪些决定，以及这些决定对我们这些用户、客户产生了什么影响。

---

### (00:40:07) Julie Zhuo

**English:**
So, often it goes into then the next step which is spending a lot of time sharing those observations and critiquing. Right? I mean, our role of thumb is really I want to get better. How often are you having a conversation with somebody about products, dissecting something, and really, what did you think was good or bad about it, and engaging that because if you aren't, it's going to be harder for you to actually learn about all of those different micro decision and what its impact is.

**中文翻译:**
所以，通常下一步就是花大量时间分享这些观察并进行评论（Critiquing）。我的经验法则是：如果你想变得更好，你多久会和别人讨论一次产品，剖析某样东西，并真正思考你认为它好在哪里、坏在哪里？如果你不参与其中，你就很难真正了解所有那些微小的决策及其产生的影响。

---

### (00:40:33) Julie Zhuo

**English:**
And then you can go a little broader than that. Right? There's lots of really great resources. There's amazing folks on the internet who will go down and really dissect... I love Eugene Wei's writing. I love Kevin Kwak. I always learn something because they take these apps like Figma or TikTok or whatever it is, and then they really go very, very deep with their own observations, what works, what patterns do we see across different apps that are successful and that aren't. Right? And this is all helping us to understand what are these again, the key decisions and what impact does it lead to that helps us become better at then making those intentional decisions in the product. So, that's a huge part of it.

**中文翻译:**
然后你可以再拓宽一点。网上有很多非常棒的资源，有很多了不起的人会深入剖析。我喜欢 Eugene Wei 的文章，也喜欢 Kevin Kwak。我总能学到东西，因为他们会拿 Figma 或 TikTok 之类的 App 开刀，然后非常深入地分享他们的观察：什么有效，我们在成功和不成功的不同 App 中看到了哪些模式。这些都在帮助我们理解什么是关键决策，以及这些决策会导致什么影响，从而帮助我们更擅长在产品中做出那些有意识的决策。这是很大的一部分。

---

### (00:41:13) Julie Zhuo

**English:**
I think another thing then is of course you have to try and validate. So, one thing we can do is of course we look at opinions, we look at reactions. That's data. Right? That's the qualitative side. I think the other side is quantitative. So often if you are building products and you have the opportunity to run experiments, to do AB tests, or if you're working on one team but lots of other people in lots of other teams are also doing AB tests, it's so interesting to then be able to ask people, ask the product manager on the other team about what they're learning about their products, and to really be able to look at specific decisions and what causally happened as a result.

**中文翻译:**
我认为另一件事当然是尝试验证。我们可以看观点，看反应。那是数据，是定性（Qualitative）的一面。我认为另一面是定量（Quantitative）。通常如果你在构建产品，并且有机会进行实验、做 AB 测试，或者如果你在一个团队工作，而其他团队的很多人也在做 AB 测试，那么去询问别人、询问另一个团队的产品经理他们从产品中学到了什么，并真正观察特定的决策以及由此产生的因果关系，是非常有趣的。

---

### (00:41:48) Julie Zhuo

**English:**
That's what I love about AB tests, and I think being really deep in the data and really going back to can we infer some sort of causal relationship because we're... Correlation or causation, but with causation with AB tests, can we actually pick up some of these learnings, can we look at patterns, and can we take some insights away that helps validate and confirm a lot of the hypotheses that we had about product, and just ingesting as much of that as you can also helps develop your instinct for what works and what doesn't. Right?

**中文翻译:**
这就是我喜欢 AB 测试的原因。我认为深入研究数据，并回归到“我们能否推断出某种因果关系”是非常重要的。是相关性还是因果关系？通过 AB 测试的因果关系，我们能否真正获得一些教训，能否观察模式，并提取一些洞察，帮助验证和确认我们对产品的许多假设。尽可能多地吸收这些信息，也有助于培养你对“什么有效、什么无效”的直觉。

---

### (00:42:17) Julie Zhuo

**English:**
I always find people often have this, oh, design and user experience is on the other side of the coin. It's like it a totally different industry, and they're at odds with each other, being data informed and being quantitative versus being very designer-y and subjective and caring about those aesthetics. I just think that's totally wrong. I think that there really... One helps confirm the assumptions or the other. Right? No, it is true that looking at a bunch of numbers isn't often going to tell you exactly the leaps of faith that you need to make to start something new, but they surely can help you validate whether a number of your assumptions about how people work or the way the world works are true or not.

**中文翻译:**
我总发现人们常有一种误解，觉得设计和用户体验是硬币的另一面，就像是一个完全不同的行业，而且它们是相互对立的——数据驱动和定量分析 vs. 充满设计感、主观且在意美学。我只是觉得这完全错误。我认为它们实际上是……一个帮助确认另一个的假设。确实，看一堆数字通常不会告诉你开始新事物时需要做出的那种“信念跃迁”（Leaps of Faith），但它们肯定能帮你验证关于人们如何工作或世界如何运作的许多假设是否正确。

---

### (00:42:57) Julie Zhuo

**English:**
And so, I know of a lot of really brilliant product thinkers who got that way not necessarily because they came through the route of subjective observation, but because they went and they were so disciplined about always studying what happened, what was the impact in the numbers and people and so forth, and then eventually you marry that of course with, well, why might that be the case, and you get into the qualitative side and the observation, but these two both support each other in helping to build a really great product sense.

**中文翻译:**
所以我认识很多非常出色的产品思想家，他们之所以出色，不一定是因为他们走的是主观观察的路线，而是因为他们非常自律，总是研究发生了什么，对数据和人产生了什么影响等等。然后最终你当然要把这些与“为什么会这样”结合起来，进入定性分析和观察的层面。这两者相辅相成，共同帮助建立起非常棒的产品感。

---

### (00:43:25) Lenny

**English:**
That's awesome. There's so much material there that we could go on and on. On that last point, I wanted to kind of double-click on it a little bit. So, say you're founder and you're like, "Man, I have all these really clear vision and ideas of where I want to go with my product," and your team's like, "Oh, I don't know if this is right. What if we do a little more user research or run some experiments?" Do you have any advice to the founder of just when to rely on their gut and experience and just go with that versus doing more research, getting more data?

**中文翻译:**
太棒了。那里有太多的素材，我们可以一直聊下去。关于最后一点，我想深入探讨一下。假设你是一位创始人，你觉得：“天哪，我对自己产品的走向有非常清晰的愿景和想法”，而你的团队却说：“噢，我不知道这是否正确。如果我们多做一点用户研究或运行一些实验呢？”对于创始人，你有什么建议吗？什么时候该依靠直觉和经验直接行动，什么时候该做更多研究、获取更多数据？

---

### (00:43:52) Julie Zhuo

**English:**
That is a really great question. One of the most common pieces of advice for founders, and I actually also had to remind myself constantly of this one is the more you know your customers, the more you can really close your eyes and just imagine everything about their life and what they're doing on almost like a minute to minute basis, probably the better you're going to do in terms of coming up with something that's going to meaningfully solve a problem for them. Right?

**中文翻译:**
这是一个非常棒的问题。给创始人最常见的建议之一——实际上我也必须不断提醒自己这一点——就是：你越了解你的客户，你就越能闭上眼睛，想象他们生活的方方面面，想象他们几乎每一分钟都在做什么。这样一来，你在提出能有意义地解决他们问题的方案时，可能会做得更好。

---

### (00:44:15) Julie Zhuo

**English:**
And so, that comes from a couple of different places. The first is, look, if you're the person you're building for, you're the target audience, awesome. You probably do have a lot of stuff that is instinctively known to you, and maybe in those cases, your team doesn't have that experience and they maybe can't feel the same level of conviction you do, and they might be asking you, ""Hey, well, can we validate?" and all of that. Right? It's always good advice, but sometimes, you're so deep in it and you can... You're this person or you know this person, or you did this job that probably can trust your instincts and your gut quite a bit.

**中文翻译:**
这源于几个不同的方面。首先，如果你就是你所服务的对象，你就是目标受众，那太棒了。你可能本能地知道很多事情。在这种情况下，你的团队可能没有那种经验，他们可能无法感受到和你一样程度的信念，他们可能会问你：“嘿，我们能验证一下吗？”之类的话。这总是好的建议，但有时你深陷其中，你就是那个人，或者你了解那个人，或者你做过那份工作，你可能可以相当程度地信任你的本能和直觉。

---

### (00:44:48) Julie Zhuo

**English:**
I remember early days at Facebook, that was us. Everybody who worked at the company was either a college dropout or a recent college grad, and we were building a product for college students. I mean, we were the perfect... It was like for us by us. We understood exactly what this audience wanted. If we didn't, we would call up some friends. I mean, this was just pure target a demographic for what we were building.

**中文翻译:**
我记得 Facebook 早期，我们就是这样。公司里的每个人要么是大学辍学生，要么是刚毕业的大学生，而我们正在为大学生开发产品。我的意思是，我们是完美的……就像是“由我们创造，为我们服务”。我们完全理解这个受众想要什么。如果我们不理解，我们就给朋友打个电话。我的意思是，这完全就是针对我们正在构建的目标人群。

---

### (00:45:10) Julie Zhuo

**English:**
But eventually if that's not true, and it evolved at Facebook, and it evolves for companies. You might start out that way, but eventually, we started to open up to the world. We started to add people in different countries. The percentage of people that were college grads who were like us who were using the product started to shrink, became a smaller and smaller percentage of actually all core Facebook users, so therefore our intuitions started to become less and less reliable. I remember in spectacular fashion, I think this was in 2008 or '09, we had a string of failures, big kind of launches that were failures, and I think it was because we reached the end of our intuition for the user base at that particular moment.

**中文翻译:**
但最终如果情况不再如此——这在 Facebook 发生过，在所有公司都会发生。你可能一开始是那样，但最终我们开始向世界开放。我们开始增加不同国家的人。像我们这样使用产品的大学毕业生的比例开始萎缩，在所有 Facebook 核心用户中所占的比例越来越小。因此，我们的直觉开始变得越来越不可靠。我记得在 2008 年或 2009 年，我们经历了一连串惨痛的失败，一些重大的发布都失败了。我认为那是由于在那一刻，我们对用户群的直觉已经走到了尽头。

---

### (00:45:49) Julie Zhuo

**English:**
That's true for founders as well. Sometimes you're building a product in a domain where you weren't the target audience. Right? I feel this right now for myself. I'm building an analytics product. I was never a data analyst. I understand the outside, the value of data, but I never did the job, and therefore, what I really needed to do was just spend a lot of time with data scientists immersing or actually just trying to do the job myself because the better that I understand what it is and what it's like and what the company context is, and I think with, for SaaS companies in particular, you might have done the job at one company, but you probably didn't do it at 20 or 50 companies, and you're probably selling to a lot of companies so it's just way more critical for you to spend a lot of time interviewing customers because your intuition is likely not going to carry you nearly as far as if you're building, again, a very consumer product for a very consumer audience of which you yourself are part of.

**中文翻译:**
这对创始人来说也是一样的。有时你正在构建一个你并非目标受众的领域的产品。我现在对自己就有这种感觉。我正在开发一个分析产品。我从未当过数据分析师。我从外部了解数据的价值，但我从未做过那份工作。因此，我真正需要做的是花大量时间与数据科学家在一起，沉浸其中，或者实际上尝试自己去做那份工作。因为我越了解那是什么样的工作、公司的背景是什么……我认为特别是对于 SaaS 公司，你可能在一家公司做过那份工作，但你可能没有在 20 或 50 家公司做过，而你可能要卖给很多公司。所以对你来说，花大量时间采访客户就显得更加关键，因为你的直觉可能无法带你走得像开发一个你自己也是其中一员的纯消费级产品那么远。

---

### (00:46:41) Julie Zhuo

**English:**
So, I do think that, yeah, it doesn't matter that you need to really understand your customers. Do you have to go out and do the work, have the conversations, teach yourself the things that they do? It depends a bit on the context, depends on where you are, but it's never bad advice. The better you understand your customers, I think the better you're going to be able to build a product.

**中文翻译:**
所以我确实认为，是的，真正了解你的客户至关重要。你是否必须走出去做这些工作、进行对话、自学他们所做的事情？这取决于具体的背景，取决于你所处的位置，但这永远不是坏建议。你越了解你的客户，我认为你就越能打造出好的产品。

---

### (00:46:57) Lenny

**English:**
I really like that advice of just this model of the more time the founder spends with their customers, the more you can trust that they're going to have the right sorts of instincts, and the less they start to spend time there, maybe start running more experiments and doing more research as a team around the founder. That's interesting.

**中文翻译:**
我非常喜欢这个建议，即这样一个模型：创始人花在客户身上的时间越多，你就越能信任他们会有正确的直觉；而当他们花在那里的时间变少时，也许团队应该开始围绕创始人运行更多的实验并做更多的研究。这很有趣。

---

### (00:47:12) Julie Zhuo

**English:**
Yeah. Or the larger your user base becomes, the less reliable any one or 10 or even a hundred people are in terms of understanding the whole. Right? It's just the numbers get too big.

**中文翻译:**
是的。或者当你的用户群变得越大，任何一个、十个甚至一百个人在理解整体方面的可靠性就越低。因为数字变得太大了。

---

### (00:47:24) Lenny

**English:**
And luckily in theory, you have a lot more data at that point, and so, you can actually run experiments and start relying on data.

**中文翻译:**
幸运的是，理论上到那时你会有更多的数据，所以你实际上可以运行实验并开始依赖数据。

---

### (00:47:30) Julie Zhuo

**English:**
That's right, yeah.

**中文翻译:**
没错，是的。

---

### (00:47:31) Lenny

**English:**
Something I also wanted to get your advice on. It's something that a lot of founders, especially, and even PMs come to me around is product review meetings and designer meetings, and I know you've run many, and so, I wanted to get your thoughts of just how should companies structure product review meetings or designer meetings, who should be in the room, how should they be set up. Any advice for folks that are trying to figure that out?

**中文翻译:**
我也想听听你的建议。很多创始人，特别是 PM，经常来找我咨询关于产品评审会议和设计师会议的问题。我知道你主持过很多这样的会议，所以我想听听你的想法：公司应该如何组织产品评审会议或设计师会议？谁应该在场？应该如何设置？对于那些试图弄清楚这些的人，你有什么建议吗？

---

### (00:47:52) Julie Zhuo

**English:**
I really believe that it's never a bad thing, it's always a better thing to have more feedback. Right? And so, often, I think you don't necessarily want to be like, "Oh, we have the one review meeting and that's the one in which we get everyone's opinions out and we make all these decisions, and then we're done." I think about product and feedback as just the more, the better. Right? And most people, again, everyone, especially with design, has an opinion to some degree, and so, all opinions are valid because they are a true opinion. The question is how do you then prioritize, how do you figure out what it is that you should do because we also can't... It isn't successful to try and do things by consensus. You're never going to get a group of people, smart people to agree about what is absolutely the best design.

**中文翻译:**
我坚信，获得更多的反馈永远不是坏事，反而总是一件好事。所以，通常我认为你不需要觉得：“噢，我们有一个评审会议，在那个会议上我们要听取所有人的意见，做出所有这些决定，然后就完事了。”我认为对于产品和反馈来说，越多越好。而且大多数人，尤其是对于设计，在某种程度上都有自己的看法，所以所有的观点都是有效的，因为它们是真实的看法。问题在于你如何确定优先级，如何弄清楚你应该做什么，因为我们也不能……试图通过共识（Consensus）来做事是不会成功的。你永远无法让一群聪明人对什么是绝对最好的设计达成一致。

---

### (00:48:32) Julie Zhuo

**English:**
So, one principle is, okay, great. If you're going to have feedback on the product, more is better. Try and have different sessions with different groups of people. I would advise a designer, "Hey, go in, actually do a critique with a design audience, but go and then show this to the people who are most directly working on the product because they're going to have a different set of knowledge, but then go and see if you can find some people outside of your direct team who don't have as much bias on just knowing exactly how things work and then show them the user experience, and then go and actually see if you can find a group of target customers for who we're actually going to launch, and then run some user research sessions and get feedback. "They all are going to be valuable. They all might contradict each other to some degree, but the right answer isn't because we don't like disagreement, let's just go with one and then ignore the others. Everyone is going to have something to contribute to the product because everyone has that different perspective.

**中文翻译:**
所以一个原则是：好的，太棒了。如果你要收集关于产品的反馈，越多越好。尝试与不同的人群进行不同的会议。我会建议设计师：“嘿，去和设计受众做一次 Critique（设计评审），但也去把它展示给那些最直接参与产品开发的人，因为他们会有不同的知识背景。然后再去看看能不能在你的直接团队之外找一些人，他们对事情的具体运作方式没有那么多偏见，向他们展示用户体验。最后，去看看能不能找到一群我们要发布的产品的目标客户，运行一些用户研究会议并获取反馈。”这些都是有价值的。它们在某种程度上可能会相互矛盾，但正确的答案并不是因为我们不喜欢分歧就只选一个而忽略其他。每个人都会对产品有所贡献，因为每个人都有不同的视角。

---

### (00:49:24) Julie Zhuo

**English:**
So, again, lots of sessions, lots of user review sessions, awesome. Okay, but then there is an important job which is the synthesis of all of that feedback and a way of understanding what really matters. The way that I often think about this is we have to be absolutely clear on who is that target audience and what is the most important problem that we're trying to solve for them. Right? So, if you can get every group to align on this is who it is. Again, go and paint that very clear picture of the person, the problem, what it is that we're trying to help them with, and then what is most important. What is the job? I really love the jobs to be done for it, but what's the job that this particular feature or product is going to fulfill for that person?

**中文翻译:**
所以，再次强调，多开会、多做用户评审会议，这很好。但是，接下来有一项重要的工作，那就是综合（Synthesis）所有这些反馈，并理解什么才是真正重要的。我经常思考的方式是：我们必须绝对清楚目标受众是谁，以及我们试图为他们解决的最重要的问题是什么。所以，如果你能让每个小组都达成一致，明确“这就是那个人”。再次强调，去描绘出那个人、那个问题、我们试图帮助他们解决什么的清晰图景，然后确定什么是最重要的。这项“任务”是什么？我非常喜欢“待办任务”（Jobs to be Done）框架，即这个特定的功能或产品将为那个人完成什么任务？

---

### (00:50:08) Julie Zhuo

**English:**
Then it makes it easier for us to then start to categorize different buckets of feedback because the first thing that's most important to address is, well, is this thing actually valuable, is this solving the problem?, is it doing the job correctly, and if a lot of other stuff below is bad, but this is good, then we can move on to kind of the next most important thing. But if all the other stuff is maybe even good or interesting, but this is not there, then we should just actually disregard all the other stuff until we are quite certain that we've gotten the core value, we understand the user, this in some sense is addressing the core pain.

**中文翻译:**
然后，这会让我们更容易开始对不同类别的反馈进行归类。因为首先要解决的最重要的事情是：这东西真的有价值吗？它解决了问题吗？它正确地完成了任务吗？如果下面的很多其他东西都很糟糕，但这一点是好的，那么我们可以继续进行下一个最重要的事情。但如果所有其他东西可能都很好或很有趣，但核心价值不在那里，那么我们实际上应该忽略所有其他东西，直到我们非常确定我们已经获得了核心价值，我们理解了用户，这在某种意义上解决了核心痛点。

---

### (00:50:45) Julie Zhuo

**English:**
And then once we do that, then let's focus on the next layer which I think about as ease of use. Right? So, okay, cool. We've figured out that we validated, this thing is valuable. It does solve the job. Now, is it easy to use? Are people confused? Are they getting hung up somewhere? Is it just really slow, so no one can use it because it just takes 10 seconds to load each time? Ease of use is just about can people access the value in a really great manner. That's the next most important bucket.

**中文翻译:**
一旦我们做到了这一点，我们就专注于下一层，我认为那是“易用性”。好了，太棒了。我们已经确定并验证了这东西是有价值的，它确实完成了任务。现在，它好用吗？人们会感到困惑吗？他们会在哪里卡住吗？它是不是非常慢，以至于没人能用，因为每次加载都要 10 秒钟？易用性就是关于人们能否以一种非常棒的方式获得价值。这是下一个最重要的类别。

---

### (00:51:11) Julie Zhuo

**English:**
And then finally, if it is valuable, it's easy to use, then I think we get into is it joyful to use, is it pleasurable, does it really exceed expectations, and I think that is the bar that we should aim for whenever we are creating products. Here, you might have debates about colors, or aesthetic properties, or animation and delight, and all of the other things that just make it that much more enjoyable and surprising and wonderful for the core audience. But you don't want to just focus on that and then lose, okay, actually, this thing wasn't valuable and it loaded in 10 seconds. Who cares about how great was the animation when the thing doesn't even load? So, I think there's a work to do to try and actually help the different pieces of feedback get synthesized so we understand what bucket they are and we can have the right order of prioritization to make sure we tackle the most important things first.

**中文翻译:**
最后，如果它有价值且易于使用，那么我认为我们就进入了“使用起来是否愉悦”、“是否令人愉快”、“是否真的超出了预期”的阶段。我认为这是我们在创造产品时应该追求的标准。在这里，你可能会对颜色、审美属性、动画和惊喜感，以及所有其他让核心受众感到更愉快、更惊喜、更美妙的事物产生争论。但你不想只关注这些，然后丢掉核心——实际上，这东西没有价值，而且加载要 10 秒钟。当东西甚至都加载不出来时，谁在乎动画有多棒呢？所以，我认为需要做一些工作，尝试帮助不同的反馈片段进行综合，这样我们就能理解它们属于哪个类别，并拥有正确的优先级顺序，以确保我们首先处理最重要的事情。

---

### (00:52:03) Lenny

**English:**
And just to be clear, this is a kind of ongoing process. This isn't one meeting where you go through all these four layers. Right?

**中文翻译:**
明确一下，这是一种持续的过程。并不是在一个会议上就要过完这四个层级，对吧？

---

### (00:52:10) Julie Zhuo

**English:**
Yeah.

**中文翻译:**
是的。

---

### (00:52:12) Lenny

**English:**
Cool. And then is your advice to focus on it in that sequence generally and not focus on say the delight and so you make it through these other points, or do you find it's helpful to think about all these things at once?

**中文翻译:**
酷。那么你的建议通常是按这个顺序来关注，在通过其他点之前不要关注所谓的“惊喜感”吗？还是你觉得同时考虑所有这些事情更有帮助？

---

### (00:52:23) Julie Zhuo

**English:**
I usually find that if you're going to go in and run a design critique or review session, it's helpful to start off front by saying, "Here's where we are in the process. This is the most important set of things we want to validate. We want to validate whether this actually solves the problem. We've validated it solves the problem, but now we validate whether it's easy to use," or something along those effect. So, being more specific about where you are, what kind of feedback matters the most at that particular phase for the team is valuable because if you don't do that, sometimes you'll just get all sorts of feedback, and some of it is you're not even ready for. The team's not even thinking about some of these additional level details or just thinking about the core stuff, and usually it follows just from how product development happens.

**中文翻译:**
我通常发现，如果你要进行设计评审或审查会议，在开始时说明情况会很有帮助：“这是我们目前所处的阶段。这是我们想要验证的最重要的一组事情。我们要验证这是否真的解决了问题。我们已经验证了它能解决问题，但现在我们要验证它是否易于使用”，或者类似的话。所以，更具体地说明你所处的位置，以及在那个特定阶段对团队来说什么样的反馈最重要，是非常有价值的。因为如果你不这样做，有时你会收到各种各样的反馈，其中一些你甚至还没准备好处理。团队甚至还没开始考虑那些额外层面的细节，或者只是在考虑核心的东西，这通常取决于产品开发的过程。

---

### (00:53:07) Julie Zhuo

**English:**
The first thing that often teams will come up with when they build a product is some kind of product brief or some kind of understanding of the user in a very high-level picture about how the product is. Usually, there's not high-fidelity mocks or prototypes at that stage. Right? And so, that's great because we're using a different fidelity. We're looking at documents and words and values and data as a way to understand the opportunity and that lends itself well to that kind of feedback.

**中文翻译:**
团队在构建产品时通常首先会提出某种产品简报（Product Brief），或者对用户在产品形态方面的一种非常高层次的理解。通常在那个阶段没有高保真模型（High-fidelity mocks）或原型。这很好，因为我们使用的是不同的保真度。我们通过文档、文字、价值观和数据来理解机会，这非常适合那类反馈。

---

### (00:53:35) Julie Zhuo

**English:**
But where I find that things get a little confusing is sometimes you will go and just make a prototype, and again, the goal of the prototype is to give a feeling of how it works. It's not that the team had already spent a bunch of time on the exact UI decisions or so forth, and so, what happens though is sometimes the audience or the people who are giving feedback, they can't always distinguish that. So, then the feedback goes immediately towards, "Oh, I don't like that shade of blue, or maybe we should put step two before step three," and that's not actually where the conversation is because we haven't actually gone and have conviction in just the first core piece of whether this is even the right thing to build or whether it really is solving an important enough problem. So, being very clear about where you are and what is the feedback that you want to get is important.

**中文翻译:**
但我发现事情变得有点混乱的地方在于，有时你会直接做一个原型，而原型的目标是给人一种它如何运作的感觉。这并不意味着团队已经花了很多时间在精确的 UI 决策等方面。然而，有时观众或提供反馈的人并不总能区分这一点。于是，反馈立刻转向了：“噢，我不喜欢那个蓝色阴影，或者也许我们应该把第二步放在第三步之前。”但这实际上并不是对话的重点，因为我们还没有对第一个核心部分——这是否是正确的东西，或者它是否真的解决了一个足够重要的问题——产生坚定的信念。所以，非常清楚你所处的位置以及你想获得的反馈是非常重要的。

---

### (00:54:20) Julie Zhuo

**English:**
Now, again, eventually you go and you put stuff in front of customers. It's a little harder for them to just fully be able to distinguish between wait, what's the difference between the feedback versus around value versus ease of use. It gets all blended for them at that point in time though, so they'll just give whatever feedback. And again, I think that's fine. Just collect it, but then when you go and do the synthesis, when you go and do the prioritization, make sure that you're getting what you need at that stage.

**中文翻译:**
当然，最终你会把东西展示给客户。对他们来说，要完全区分价值反馈和易用性反馈之间的区别会更难一些。在那个时间点，对他们来说一切都是混合在一起的，所以他们会提供任何反馈。我认为这没关系。只要收集起来，但当你进行综合和确定优先级时，确保你得到了那个阶段你所需要的东西。

---

### (00:54:45) Lenny

**English:**
As a colleague of the designer, say you're a PM or an engineer, data scientist or whatever, do you have any advice for just giving feedback to a designer in the critique?

**中文翻译:**
作为设计师的同事，假设你是一名 PM、工程师、数据科学家或其他职位，你对于在评审中给设计师提供反馈有什么建议吗？

---

### (00:54:52) Julie Zhuo

**English:**
Yes. The most important feedback I would say is focus on identifying the problem and making it really clear for the other person, the person you're giving feedback to, what is the problem. All right? And the reason I always give that is because sometimes we're all solvers and builders, and so, you often can very much get into like, "Wait a second. I see the problem. But instead of talking about the problem, I'm just going to give you a solution." So, people will say things like, "Oh, I see this," and they'll be like, "Why don't we make the logo purple, or why don't we try and add this feature here?"

**中文翻译:**
有的。我想说最重要的反馈是：专注于识别问题，并向对方（你提供反馈的对象）非常清楚地说明问题是什么。好吗？我总是这样建议的原因是，有时我们都是解决者和构建者，所以你经常会陷入这种状态：“等一下，我看到问题了。但我不打算谈论问题，我直接给你一个解决方案。”所以人们会说：“噢，我看到了这个，”然后他们会说，“为什么我们不把 Logo 改成紫色，或者为什么我们不尝试在这里添加这个功能？”

---

### (00:55:23) Julie Zhuo

**English:**
There's a lot of assumptions that are already in place. You are giving that because you assume the current thing is insufficient in some way, and it's maybe not ideal at being clear, or it is forgetting to bring some important value prop, or maybe yellow just makes this whole thing look pukey or whatever it is. Right? There's a reason, but instead of actually stating the reason, we go straight to the solution. At that point, it's like, I don't know, maybe the solution is good, maybe it isn't. Right? But honestly, you have designers, you have other people who are just focused on coming up with the right solution. You're kind of taking that power away from them by going straight to what you think is the right solution.

**中文翻译:**
这其中已经包含了很多假设。你之所以提供这个建议，是因为你假设当前的东西在某些方面是不够的，也许在清晰度上不理想，或者忘记了带来一些重要的价值主张（Value Prop），或者也许黄色让整个东西看起来很恶心，诸如此类。这背后是有原因的，但我们没有陈述原因，而是直接跳到了解决方案。在那一点上，我不知道，也许解决方案是好的，也许不是。但老实说，你有设计师，你有其他专门负责想出正确解决方案的人。你直接给出你认为正确的解决方案，实际上是在剥夺他们的权力。

---

### (00:56:00) Julie Zhuo

**English:**
Again, I'm not saying don't ever propose a solution. It's always good to give a suggestion, but you also have to respect that whoever is actually coming up with the answer and the solution, they're the ones who should be empowered to ultimately... They know the most about the problem. They've thought about it the longest. Right? Help them understand what you think the problem is with whatever it is they are proposing. Give examples. Show them where you're getting stuck. Why is it unclear to you? Why do you think that this color is not the right color? Right? Try and paint that because when everyone is aligned on the problem, then we can all collectively come up with better solutions, and then we can kind of rate and critique the solutions against each other. But by going straight to brainstorming ideas, sometimes a lot gets lost and people aren't actually following along on is this really the problem, do we agree this is a problem, is this actually the most important problem.

**中文翻译:**
再说一次，我不是说永远不要提出解决方案。提供建议总是好的，但你也要尊重那个真正提出答案和解决方案的人，他们才是最终应该被赋能的人……他们对问题的了解最多，思考的时间最长。帮助他们理解你认为他们提出的方案中存在什么问题。举例子，向他们展示你在哪里卡住了。为什么这对你来说不清楚？为什么你认为这个颜色不是正确的颜色？尝试去描绘这些，因为当每个人都在问题上达成一致时，我们就能共同想出更好的解决方案，然后我们可以互相评估和评论这些方案。但如果直接进入头脑风暴，有时会丢失很多东西，人们实际上并没有跟上：这真的是问题吗？我们同意这是一个问题吗？这真的是最重要的问题吗？

---

### (00:56:49) Lenny

**English:**
I imagine PMs are very guilty of this, of just like, "Mm, let's just move this button over here. We'll solve all these problems. Let's move it higher up." It's kind of ironic because PMs also don't want people coming to them with a solution, and it's funny, you kind of forget that, and you just give people, "Here's what we should just do. Let's move on."

**中文翻译:**
我能想象 PM 们经常犯这种错，比如：“嗯，我们把这个按钮移到这里吧。这样就能解决所有这些问题。让我们把它移高一点。”这挺讽刺的，因为 PM 也不希望别人带着解决方案来找他们。有趣的是，你往往会忘记这一点，直接告诉别人：“这就是我们该做的。继续吧。”

---

### (00:57:04) Julie Zhuo

**English:**
Yeah. We all forget it all the time. I mean, it is a hard one, right, because it's fun. It's like we are all solvers to some degree. It's fun to jump in there and do it. But when you don't have extreme clarity on the problem, then that's what happens when you just end up talking past each other.

**中文翻译:**
是的。我们总是会忘记。我的意思是，这很难，因为这很有趣。在某种程度上，我们都是解决者。跳进去解决问题很有趣。但当你对问题没有极度的清晰度时，结果就是大家各说各的，没有交集。

---

### (00:57:17) Lenny

**English:**
Absolutely. I've been guilty of that myself. Okay. So, I've sucked up an hour of your time. I want to let you go, but I have two more questions I want to ask in different directions. One is coming back to your book about The Making of a Manager. By the way, we haven't even mentioned the name of the book yet. The Making of a Manager, available at all of local bookstores and Amazon and every online shop, bookshop. So, a lot of people want to become managers, and oftentimes, they struggle for whatever reason. They can't make it to manager. Nobody wants to promote them. They're just kind struggling there. Do you have any advice for folks that are just having a hard time getting to that point where they can actually get to be a manager?

**中文翻译:**
绝对是这样。我自己也犯过这种错。好了，我已经占用了你一个小时的时间。我想让你去忙，但我还有两个不同方向的问题想问。一个是回到你的书《经理人的养成》（The Making of a Manager）。顺便说一下，我们还没提到书名呢。《经理人的养成》，在所有当地书店、亚马逊和每家网上书店都有售。很多人想成为经理，但往往因为各种原因而挣扎。他们无法晋升为经理，没人想提拔他们，他们就在那里苦苦挣扎。对于那些很难达到能真正成为经理的那个点的人，你有什么建议吗？

---

### (00:57:50) Julie Zhuo

**English:**
The first is make sure your manager is aware of those aspirations. Bring them in to your hopes and dreams. Right? If your manager understands your goals and what you would like to work towards, then it's much easier for you to be like, "Okay, can you help? I really want to be able to do what you do. I want to lead a team. I want to lead a project, et cetera. Help me figure out how to get there." And the first thing you should ask is what does it take. Where are the skills that I'm going to need to get better at in order for you to believe that I could be successful in doing so? And just make sure that you hear that, and make sure that you can have an honest conversation where your manager can help you be aware of what are the things that you should work on.

**中文翻译:**
首先，确保你的经理知道你的这些抱负。让他们了解你的希望和梦想。如果你的经理了解你的目标和你想要努力的方向，那么你就会更容易说：“好的，你能帮帮我吗？我真的很想能做你正在做的事。我想领导一个团队，我想领导一个项目等等。帮我弄清楚如何达到那个目标。”你首先应该问的是：需要具备什么条件？为了让你相信我能成功做到这一点，我需要提高哪些技能？确保你听到了这些，并确保你能进行一次诚实的对话，让你的经理帮助你意识到你应该在哪些方面下功夫。

---

### (00:58:30) Julie Zhuo

**English:**
And then work together to just make a plan to be like, "Okay, cool. One of the things that I've got to improve on is that one of the roles and responsibilities as manager is go and spending a lot of time on recruiting, and I haven't done that. So, let's see, let's work together for a plan where I can start to learn some of those skills." One of the nice things about, at least, that I find about what the path to management is a lot of this stuff you can do even when you're not a manager. Some stuff you can't. Right? You probably can't fire someone and learn those skills without actually being a manager and being in that role. But a lot of things like hiring, like mentoring, like working on process is all things that you can start to contribute and help out with in the capacity of an IC. If you've identified these different skills, then find opportunities to start to practice and be able to grow those skills.

**中文翻译:**
然后共同制定一个计划，比如：“好的，太棒了。我需要改进的一点是，作为经理的职责之一是花大量时间在招聘上，而我还没做过。所以，让我们一起制定一个计划，让我可以开始学习其中的一些技能。”关于通往管理之路，我发现的一件好事是，很多事情即使你还不是经理也可以做。当然，有些事情不行，比如你可能无法在不担任经理角色的情况下解雇某人并学习相关技能。但很多事情，如招聘、指导、改进流程，都是你作为 IC 可以开始贡献和提供帮助的。如果你已经识别出了这些不同的技能，那就寻找机会开始练习并增长这些技能。

---

### (00:59:19) Julie Zhuo

**English:**
So, for example, oftentimes, a really great... If you're a part of a company that's growing and has a summer internship program, awesome. Can you go in and sign up and mentor and intern and manage an intern. Right? It's a very sort of small way of doing that and getting started. Here's another example. If you're at a growing company and new people are joining and you might work with your manager to say, "Hey, let me be this person's onboarding buddy. Let me be responsible for helping them get up to speed over the first one or two weeks." Or if you want a spot, an opportunity, and let's say there's documentation or there's some process that we have to change the structure of the meeting, ask your manager if you can help out with that. You can volunteer for that. You help come up with some new process for doing something, or a new way of running the meeting and just take the lead.

**中文翻译:**
例如，通常一个非常好的机会是：如果你所在的公司正在成长，并且有暑期实习生计划，那太棒了。你可以报名去指导和管理一名实习生。这是一种非常小规模的尝试和开始方式。再举个例子，如果你在一家成长中的公司，有新人加入，你可以和你的经理商量：“嘿，让我当这个人的入职伙伴（Onboarding Buddy）吧。让我负责帮助他们在头一两周内进入状态。”或者如果你看准了一个机会，比如有文档需要整理，或者我们需要改变会议结构的某些流程，问问你的经理你是否可以帮忙。你可以自荐。你帮助想出一些做某事的新流程，或者主持会议的新方式，并担任领导角色。

---

### (01:00:02) Julie Zhuo

**English:**
So, a lot of these things you don't need to have the official title to do. You can do a lot of it in that capacity as an IC. And again, it's also great for you to then try out. Do I like doing these things? Do these things give me energy? And as well, your manager can see whether you can be successful in this respect and then give you more and more responsibility if so. So, it's really not binary. It's not all or nothing.

**中文翻译:**
所以，很多事情你不需要有正式的头衔就能做。你可以在 IC 的岗位上做很多这样的事。而且，这对你来说也是一个很好的尝试机会：我喜欢做这些事吗？这些事能给我能量吗？同样，你的经理也可以看到你在这方面是否能取得成功，如果是的话，就会给你越来越多的责任。所以这真的不是二元对立的，不是“全有或全无”。

---

### (01:00:24) Julie Zhuo

**English:**
I also want to point, there's one other thing though which is that sometimes the reason you can't easily become a manager is because your company just isn't growing. It isn't a need to have a new manager unless the current manager leaves or unless somebody departs the company and a new role opens up. I mean, you can very well have done all the right things, have the right skills, but there just isn't the role and opportunity available at your current company, and if that's the case, sometimes that's how it is, and the way that you can further your goals there is to think about moving into a different environment.

**中文翻译:**
我还想指出另一件事，那就是有时你无法轻易成为经理的原因仅仅是因为你的公司没有在增长。除非现任经理离开，或者有人离职并空出了新职位，否则就不需要新经理。我的意思是，你可能已经做对了所有事情，拥有了正确的技能，但你现在的公司就是没有那个职位和机会。如果是这种情况，有时事实就是如此，而你进一步实现目标的方法就是考虑换一个环境。

---

### (01:00:55) Lenny

**English:**
I did a lot of the things that you recommended, and I 100% agree with everything being really helpful to getting you to manager, and I think basically if you're just sitting there being really upset about not having a chance, clearly there's a lot you can do. All the things you shared, I found to be really helpful too. So, thanks for getting into all the detail there. Last question, for founders, or even PMs, a lot of them are struggling to hire designers. There's just such a shortage of great designers. Do you have any advice? I know, I don't know if there's an answer to this, but do you have any advice for founders or PMs trying to hire designers?

**中文翻译:**
我做过很多你推荐的事情，我 100% 同意这些对于晋升经理非常有帮助。我认为基本上如果你只是坐在那里为没有机会而感到沮丧，显然你还有很多可以做的。你分享的所有事情，我也觉得非常有帮助。谢谢你讲得这么详细。最后一个问题，对于创始人甚至 PM 来说，很多人都在为招聘设计师而苦恼。优秀的设计师实在是太短缺了。你有什么建议吗？我知道这可能没有标准答案，但你对试图招聘设计师的创始人或 PM 有什么建议吗？

---

### (01:01:26) Julie Zhuo

**English:**
Yeah. I mean, for hiring anyone, even engineers too. All of us are looking for really great talent and there is a shortage. So, for designers, this is what I often advise for founders. So, the first thing is that designers want to work with people who care about design. They don't want to be like, "Hey, you're going to toss me some spec, and then I have to come up with a thing, and then I toss it over the engineer." So, the first thing you could do is demonstrate a commitment to design. Make yourself out to be someone who cares about design. Again, not because you just need to fill a box because everyone says you need a designer for your company to get that teeth, but because you truly care about it, and that already puts you far ahead of the pack.

**中文翻译:**
是的。我的意思是，招聘任何人都是如此，甚至包括工程师。我们都在寻找非常优秀的人才，而且人才短缺。对于设计师，我经常给创始人这样的建议。首先，设计师想和在意设计的人一起工作。他们不想只是：“嘿，你扔给我一些规格说明（Spec），然后我必须想出一个东西，再把它扔给工程师。”所以，你能做的第一件事就是展示对设计的承诺。让自己成为一个在意设计的人。再说一次，不是因为你需要填补一个空缺，或者因为大家都说你的公司需要一个设计师才能有竞争力，而是因为你真正关心它。这已经让你遥遥领先了。

---

### (01:02:01) Julie Zhuo

**English:**
So, what are some ways that you can demonstrate your commitment to design? Well, the first is even if you don't have a full-time designer, are you working with a good agency, or you have venture capital funding and you're thinking about what to invest in, are you working with someone on a contract basis just to build a really wonderful marketing side, or to focus on even the V1 of your product being something that shows that this is something you want to invest in. Because if you're going to hire someone, they're going to go check out your website, they're going to look at the stuff, and they're going to go and make some judgements about whether you seem like the kind of person that's committed to building a great culture of design at your organization.

**中文翻译:**
那么，有哪些方式可以展示你对设计的承诺呢？首先，即使你没有全职设计师，你是否在与优秀的代理机构合作？或者如果你有风险投资，你在考虑投资什么时，是否在以合同形式聘请人来打造一个非常棒的营销页面，或者专注于让你产品的 V1 版本就能展示出这是你想投入的东西？因为如果你要招聘某人，他们会去查看你的网站，看你的东西，并判断你是否看起来像是那种致力于在组织中建立优秀设计文化的人。

---

### (01:02:34) Julie Zhuo

**English:**
But I think the second is just being somebody who can speak to and align with a lot of the values of design, and often, what that means is just, again, being really, really people-centric, having good taste, thinking about what it means to have a design organization. If you don't really understand design, you don't understand the tools designers use, you don't understand that nomenclature of how designers talk, if that's foreign, then go do the research. Go and study it. Go and interview designers that work at companies. Go and try and follow the top designers on Twitter. I mean, just immerse yourself in a bit of that culture and really get to understand what great designers value, and so, do the research so that you can... Now you're talking to a designer, you can express that, right? You can speak to them in a common language. If you say things like, "Oh, we need a designer, but I don't really understand design. That's your thing. I'm just here to do my..." Whatever, that's not often going to make you stand out against a very competitive field.

**中文翻译:**
我认为第二点是，做一个能够理解并认同许多设计价值观的人。通常这意味着要真正以人为中心，拥有良好的品味，思考拥有一个设计组织意味着什么。如果你不真正了解设计，不了解设计师使用的工具，不了解设计师说话的术语，如果这些对你来说很陌生，那就去做研究。去学习它。去采访在公司工作的设计师。去尝试关注推特上的顶尖设计师。我的意思是，让自己沉浸在那样的文化中，真正了解优秀设计师看重什么。做这些研究，这样当你和设计师交谈时，你就能表达出来，对吧？你可以用共同的语言与他们交流。如果你说：“噢，我们需要一个设计师，但我不懂设计。那是你的事。我只是来做我的……”之类的话，这通常不会让你在竞争激烈的领域中脱颖而出。

---

### (01:03:30) Julie Zhuo

**English:**
Sometimes when you just ask someone to teach you about their domain or discipline and you form a relationship, that person then maybe sees that you care, maybe has a friend, or maybe later on, they decide to get... There's already a relationship that you're making with people in the community, and that's often for long-term. I mean, again, it might not yield you designers right away, but in the long-term, it pays off because you will be considered a team or a company that really does care.

**中文翻译:**
有时，当你只是请教别人关于他们的领域或学科的知识并建立起联系时，那个人可能会看到你的用心，也许他有朋友推荐，或者以后他自己决定加入……你已经在社区中与人们建立了联系，这通常是长期的。我的意思是，这可能不会立刻为你带来设计师，但从长远来看，它是会有回报的，因为你会被认为是一个真正关心的团队或公司。

---

### (01:03:55) Lenny

**English:**
Amazing. I've sucked up way too much of your time. I need to let you get back to building your company. Where can folks find you online and maybe reach out if they have questions, and then is there any way listeners can be useful to you?

**中文翻译:**
太棒了。我占用了你太多的时间。我得让你回去继续建设你的公司了。大家可以在哪里找到你？如果有问题，该如何联系你？另外，听众有什么可以帮到你的吗？

---

### (01:04:05) Julie Zhuo

**English:**
Yes. So, I am active on Twitter and LinkedIn. My handle is @J-O-U-L-E-E on Twitter. I also have a newsletter, although I haven't actually been as active in it on Substack. It's called The Looking Glass, and I have a lot of old articles and things on Medium and on Substack as well. Yeah, and I have my book, The Making of a Manager. So, that's where you can find me online.

**中文翻译:**
好的。我在推特和 LinkedIn 上很活跃。我的推特账号是 @JOULEE。我也有一个新闻通讯，虽然我最近在 Substack 上没那么活跃了，它叫《望远镜》（The Looking Glass）。在 Medium 和 Substack 上我也有很多旧文章。当然，还有我的书《经理人的养成》。这些就是你可以在网上找到我的地方。

---

### (01:04:28) Julie Zhuo

**English:**
And then you have such a wonderful community, Lenny, and very fortunate to be a subscriber, to have gleaned a lot of wisdom and knowledge from yourself and all of the amazing guests and the community that you've developed as well on Substack. So, one of the things, as I mentioned, that we're working on in our startup is just helping companies be able to use data effectively and be able to access it and make great decisions. So, if there's anybody who's listening and is a growth PM or works on the data team and would be excited to have a conversation where I can interview you, learn more about how your company works, how you guys think about data, and just learn from you, please reach out. DM me on Twitter, my DMs are open, and I would gladly take up that invitation.

**中文翻译:**
Lenny，你有一个非常棒的社区，我很荣幸能成为订阅者，从你、所有了不起的嘉宾以及你在 Substack 上建立的社区中汲取了很多智慧和知识。正如我提到的，我们在初创公司中致力于的一件事就是帮助公司有效地使用数据，使其能够获取数据并做出伟大的决策。所以，如果听众中有增长 PM 或在数据团队工作的人，并且愿意和我交流，让我采访你，了解你们公司是如何运作的，你们是如何思考数据的，并向你学习，请联系我。在推特上私信我，我的私信是开放的，我会非常乐意接受邀请。

---

### (01:05:09) Lenny

**English:**
Is there a website people can go to learn more about what you're building?

**中文翻译:**
有没有网站可以让人们了解更多关于你正在构建的东西？

---

### (01:05:12) Julie Zhuo

**English:**
Yes. My product is called Sundial. The website doesn't give you that much. It's fairly high level, but it is sundial.so.

**中文翻译:**
有的。我的产品叫 Sundial。网站上提供的信息还不算多，还比较高层次，网址是 sundial.so。

---

### (01:05:18) Lenny

**English:**
Awesome. We're going to link to that in the show notes. Julie, this was such a treat for me. I so appreciate you making time for this. Thank you so much.

**中文翻译:**
太棒了。我们会把链接放在节目介绍里。Julie，这对我来说真是一次享受。非常感谢你抽时间参加。太感谢了。

---

### (01:05:25) Julie Zhuo

**English:**
This was wonderful. Thank you so much for having me, Lenny.

**中文翻译:**
这太棒了。非常感谢你邀请我，Lenny。

---

### (01:05:29) Lenny

**English:**
That was awesome. Thank you for listening. If you enjoy the chat, don't forget to subscribe to the podcast. You could also learn more at lennyspodcast.com. I'll see you in the next episode.

**中文翻译:**
太棒了。感谢您的收听。如果您喜欢这次聊天，别忘了订阅本播客。您也可以在 lennyspodcast.com 了解更多信息。我们下期节目再见。