# Karri Saarinen - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Karri Saarinen, CEO of Linear.

---

### [00:00:00] Karri Saarinen

**English:**
My belief is that, like any domain or industry, the more it matters, the more the design matters. What happens is whenever there's a new paradigm, I don't know, like the mobile or the web or something the first iterations of those products existing there, they don't have to be super well designed necessarily because they are the first. Then, as you build the 100,000 different email clients, any email client now has to be pretty good to be even considered an email client. It's like the bar is so high. I think today it's almost a very basic thing now. Pretty much from the very beginning, you need pretty high level design for people to even pay attention or consider you seriously.

**中文翻译:**
我的信念是，就像任何领域或行业一样，某件事越重要，设计就越重要。情况往往是这样：每当出现一个新范式时——比如移动端或网页端之类的——最初出现的那些产品迭代并不一定需要设计得非常好，因为它们是先行者。但是，当你面对市面上已经存在的 10 万个不同的邮件客户端时，任何一个新的邮件客户端现在都必须做得相当出色，才能被称之为一个“邮件客户端”。现在的门槛已经非常高了。我认为在今天，设计几乎已经成了一项最基本的要求。基本上从最开始，你就需要高水准的设计，人们才会关注你或认真考虑使用你的产品。

---

### [00:00:46] Lenny

**English:**
Today my guest is Karri Saarinen. Karri was the founding designer at Coinbase, principal designer at Airbnb, co-founder of two previous startups, and most recently is the co-founder and CEO of Linear, which I'm fairly confident is the fastest growing and most beloved issue tracking tool in the world and something that a growing number of product teams are using to build their own product. Karri and his team are building their company and their product in a really unique way with a huge focus on craft and quality, no AB tests, no metrics-based goals, instead a focus on taste and opinions. Also, no durable cross-functional teams, instead teams assemble around a project and then disperse once it's done. Also, they have just one product manager as the head of product and that's it. In our conversation, Karri shares how he built a culture around quality and craft, how he makes trade-offs, and how he operationalizes quality and thoughtfulness where design can be a differentiator in competing against incumbents.

**中文翻译:**
今天的嘉宾是 Karri Saarinen。Karri 曾是 Coinbase 的创始设计师、Airbnb 的首席设计师，也是两家初创公司的联合创始人。最近，他是 Linear 的联合创始人兼 CEO。我相当确信 Linear 是世界上增长最快、最受喜爱的“问题追踪工具”（issue tracking tool），越来越多的产品团队正在使用它来构建自己的产品。Karri 和他的团队以一种非常独特的方式建立公司和产品：他们极度关注工艺（craft）和质量，没有 AB 测试，没有基于指标的目标，取而代之的是对品味和见解的关注。此外，他们没有长期的跨职能团队，而是围绕项目组建团队，项目完成后即解散。而且，他们只有一位产品经理，担任产品负责人，仅此而已。在我们的对话中，Karri 分享了他是如何围绕质量和工艺建立文化的，他如何做权衡，以及他如何在设计成为竞争差异化因素的情况下，将质量和深度思考转化为可操作的流程，从而与老牌对手竞争。

---

### [00:01:42] Lenny

**English:**
We talk about something called the linear method of building product, which is big on building opinionated software, working in consistent cycles amongst other principles. We also get into Linear's unique hiring approach, which involves a paid work trial where candidates work alongside the team for a number of days instead of just having an interview, also a glimpse into how Linear got their first 10 customers, found product market fit, and scaled their growth engine. There is so much gold in this episode. I'm very excited for you to hear it. With that, I bring you Karri Saarinen after a short word from our sponsors. [Sponsor messages for Mercury and Composer omitted for brevity]. Karri, thank you so much for being here. Welcome to the podcast.

**中文翻译:**
我们讨论了所谓的“Linear 产品构建方法”，其核心原则包括构建“有主见/有态度的软件”（opinionated software）、以一致的周期（cycles）工作等。我们还深入探讨了 Linear 独特的招聘方式，其中包括付费工作试用（paid work trial），候选人会与团队一起工作几天，而不仅仅是面试。此外，我们还一窥 Linear 如何获得前 10 名客户、如何找到产品市场契合点（PMF）以及如何扩展其增长引擎。这一集里有很多干货，我非常激动能让大家听到。在听完赞助商的简短介绍后，我将为您带来 Karri Saarinen 的访谈。[赞助商信息略]。Karri，非常感谢你能来到这里。欢迎来到本播客。

---

### [00:04:29] Karri Saarinen

**English:**
Thanks, Lenny. It's great to be here.

**中文翻译:**
谢谢，Lenny。很高兴来到这里。

---

### [00:04:31] Lenny

**English:**
Maybe to start, set a little context, can you just explain what is Linear? What does Linear do? Then, share maybe a few stats of just the scale of Linear at this point.

**中文翻译:**
也许我们可以先从背景介绍开始，你能解释一下什么是 Linear 吗？Linear 是做什么的？然后，分享一些关于 Linear 目前规模的数据。

---

### [00:04:41] Karri Saarinen

**English:**
Linear is the project and issue tracking system that software companies and technical teams love to use. We help software companies to build software. We started 2019. Today some of the top growth companies like Block, Vercel, Ramp, Retool, Mercury, and Softstack are building with Linear. We also additionally have lots of other companies, thousands of other companies using Linear. These companies can be a very early stage team like some companies just graduated from YC or a public company. Just briefly, why we created Linear is that, like you said, I worked with you at Airbnb and before that I worked at Coinbase. Before that, I had my own startup. All of us founders, there's three of us, we had a similar path where we worked in multiple different companies in different stages. What we saw often is that the tools available for managing software projects weren't really cutting it. I think a lot of them felt very clunky or complex or just like they had this legacy way of thinking about software development. We just felt like we should do something about it. With Linear, we set out to build this most frictionless and streamlined system for modern software development. I'm also happy to share that we've been profitable the last two years. We also have this thing where we actually have this net negative lifetime burn rate, which means that we just have more cash in the bank today than we have raised. I think with a lot of startups usually the normal way is that you raise money and then you need to spend it to build it. I think since we were able to build a business pretty early on, we've been able to be in this position that actually we haven't spent any money on building the business.

**中文翻译:**
Linear 是一个软件公司和技术团队非常喜爱使用的项目与问题追踪系统。我们帮助软件公司构建软件。我们成立于 2019 年。今天，一些顶尖的增长型公司，如 Block、Vercel、Ramp、Retool、Mercury 和 Softstack 都在使用 Linear。此外，我们还有成千上万的其他公司在使用 Linear。这些公司既有像刚从 YC 毕业的早期团队，也有上市公司。简而言之，我们创建 Linear 的原因是，正如你所说，我曾和你一起在 Airbnb 工作，在那之前我在 Coinbase。再之前，我有自己的初创公司。我们三位创始人都有类似的经历，在不同阶段的多家公司工作过。我们经常发现，现有的软件项目管理工具并不给力。我觉得很多工具用起来非常笨重、复杂，或者带有一种陈旧的软件开发思维。我们觉得应该为此做点什么。通过 Linear，我们致力于为现代软件开发构建最无摩擦、最流线化的系统。我也很高兴地分享，我们在过去两年一直盈利。我们还有一个特点，就是我们的“终身净烧钱率”是负数（net negative lifetime burn rate），这意味着我们银行里的现金比我们筹集到的资金还要多。对于很多初创公司来说，通常的做法是融资然后花钱去构建业务。由于我们很早就建立起了商业模式，我们现在处于一个实际上没有花掉任何融资款来构建业务的地位。

---

### [00:06:43] Lenny

**English:**
That is insane. I didn't even know that. For all those reasons, a lot of founders and a lot of product leaders look up to the way Linear builds product and the way you think about product. To frame this conversation, there's three areas I want to dive into. One is just how you approach building product. Two is how you go about building the team and the business in general and then three is just how you grow Linear. To start, I want to talk about craft. Clearly, one of the biggest reasons that people look up to Linear and use Linear is the quality of the user experience and the product. I know your team puts a lot of emphasis on craft and user experience. I imagine that also comes at the cost of some trade-offs like it takes probably longer to get stuff out the door. You're probably losing sales because people are waiting for a feature and you're not ready to launch it yet. You want to make it better. What have you learned about creating space for craft and building product that is really, really great?

**中文翻译:**
这太疯狂了，我甚至都不知道这一点。正因为这些原因，许多创始人和产品负责人非常推崇 Linear 构建产品的方式以及你对产品的思考。为了展开这次对话，我想深入探讨三个领域：第一是你如何构建产品；第二是你如何组建团队和经营业务；第三是 Linear 如何增长。首先，我想谈谈“工艺”（craft）。显然，人们推崇并使用 Linear 的最大原因之一就是用户体验和产品的质量。我知道你的团队非常强调工艺和用户体验。我猜这也会带来一些权衡，比如产品上线可能需要更长的时间。你可能会因此损失一些销售额，因为人们在等待某个功能，而你还没准备好发布，因为你想把它做得更好。关于如何为工艺创造空间并打造真正伟大的产品，你学到了什么？

---

### [00:07:40] Karri Saarinen

**English:**
I think it's interesting that those things you mentioned like hiring, building business, and building product and craft, I think that all of those are somewhat related to each other. What I can say about the product craft per se is it definitely starts with the people. On the hiring front, we always look for people that care about it. As a business, why we really care about it is that we see that cooperation only happens if people use the product and our product, which is supposed to help the cooperation, coordination. If there's friction or the experience isn't that great or there's little paper cuts, I think it gets really annoying for people to use. We think for the business to be successful the quality and the craft is very important. There's definitely trade-offs sometimes. There can be for example timelines like we are about to launch something and then for example I or someone else goes to look at it and sees, "Oh, this doesn't feel right and we should fix it so I don't think we should launch this now." Sometimes it does definitely push the timelines, but this might be days. It's not like we need to redo everything. The other way we think about it is we are actually very okay pushing things out to ourselves and for a small group of customers if they opt into that. Whenever we build a new feature one of the things is we don't want to spend tons of time upfront just designing it, then polishing it perfectly. We actually believe that when you start building the thing you actually start realizing more how it should work and how it should be better. A lot of times with the teams we tell them, "Just put it there in, I don't know, the first week almost. After you have some designs in place or some design ideas, just put it into the app and ship it to production." It's only visible to us so we internally can test it out. Then, I think the next stage is we look for a customer that could be interested in this feature or we just ask people to opt in to some better program. In those stages, the experience can be a little janky or it's not that polished, but we're okay with it because we are saying, "It's not finished. We just want to get your feedback early so we can make it better." Once we get to the full general release, then we pay more attention to the actual polish or the craft.

**中文翻译:**
我觉得很有趣，你提到的招聘、业务构建、产品构建和工艺，这些其实都是相互关联的。关于产品工艺本身，我能说的是，它绝对始于人才。在招聘方面，我们总是寻找那些真正在意工艺的人。作为一家企业，我们之所以如此在意它，是因为我们看到，只有当人们使用产品时，协作才会发生，而我们的产品正是为了帮助协作和协调。如果产品有摩擦，或者体验不够好，或者有一些小瑕疵（paper cuts），人们用起来会觉得非常烦。我们认为，要让业务成功，质量和工艺至关重要。当然，有时确实会有权衡。比如时间线，我们准备发布某个功能，然后我或其他人去看了一下，发现“哦，这感觉不对，我们应该修复它，所以我觉得现在不该发布”。有时这确实会推迟时间线，但通常只是几天，而不是要推倒重来。另一种思考方式是，我们非常乐意先向内部员工和一小部分选择加入的客户发布。每当我们开发新功能时，我们不想在前期花大量时间仅仅进行设计，然后把它打磨得完美无缺。我们相信，当你开始构建它时，你才会真正意识到它应该如何运作以及如何变得更好。很多时候我们告诉团队：“就在第一周把它放进去。有了初步设计或想法后，直接放入应用并发布到生产环境。”它只对我们内部可见，这样我们可以进行内部测试。接下来的阶段是寻找可能对该功能感兴趣的客户，或者邀请人们加入测试计划。在这些阶段，体验可能有点简陋或不够精致，但我们觉得没关系，因为我们会明确说：“这还没完工，我们只是想尽早获得反馈以便改进。”一旦进入正式发布阶段，我们就会更加关注实际的打磨和工艺。

---

### [00:10:11] Lenny

**English:**
That is so interesting. I didn't know you do that. You actually go ahead and launch things really early to a select group of people that want the early stuff. Then, did you say that you find one customer to co-create and help evolve the feature and change it?

**中文翻译:**
这太有意思了，我以前不知道你们会这么做。你们实际上会非常早地向一小部分想要尝鲜的人发布功能。然后，你刚才是不是说，你会找一个客户来共同创造，并帮助演进和修改这个功能？

---

### [00:10:26] Karri Saarinen

**English:**
Usually it can be one or it's three or five or 10. Often, especially with the larger company facing features, we usually do try to find a large company because sometimes it's hard to imagine these things, how they should work. It's better if someone is willing to work with us to explain, "Okay, this is how we do something." For example, we work this way with Vercel in that there was some changes they wanted to see in the roadmap feature. We worked with them to improve it and then they could give us feedback along the way.

**中文翻译:**
通常可能是一个，也可能是三五个或十个。通常，特别是针对大公司的功能，我们通常会尝试找一家大公司，因为有时很难凭空想象这些功能应该如何运作。如果有人愿意配合我们解释“好的，这就是我们处理某事的方式”，那就好办多了。例如，我们曾以这种方式与 Vercel 合作，他们希望在路线图（roadmap）功能中看到一些变化。我们与他们合作改进了该功能，他们在此过程中为我们提供反馈。

---

### [00:11:02] Lenny

**English:**
That is so interesting because I think people seeing Linear from the outside, it feels like you just take the time you need to build something awesome. Then, it launches and it's amazing and it's great, but it turns out that isn't exactly how you build. You actually do launch things really early and people don't necessarily see it until it's done, but there's this whole process behind the scenes.

**中文翻译:**
这太有趣了，因为我觉得外界看 Linear，感觉你们就是花足够的时间去打造一些很棒的东西，然后发布时它就非常惊艳。但事实证明，这并不完全是你们构建的方式。你们实际上发布得很早，只是人们在它完工前未必能看到，但这背后有一整套流程。

---

### [00:11:21] Karri Saarinen

**English:**
I think sometimes people think that craft is about perfecting things and perfecting them in a very organized way or very early on. The downside with this perfection mindset is that it can be sometimes hard to put anything out because nothing is ever fully perfect. We try to balance this thinking with the fact that we should be always pushing things out very quickly, but then also fixing them, improving them very quickly. It's almost like the opposite idea, but then we try to combine that and I think it's been working well. Generally, in the company there's not necessarily a lot of reviews or something that we always review everything that gets shipped this way because we do want people to feel that they can put something in the app and then we can try it out. It's more like let's just try it out, but then we do need to look at it again before we release it to everyone.

**中文翻译:**
我觉得有时人们认为工艺就是追求完美，而且是以一种非常有组织的方式或在非常早期就追求完美。这种完美主义心态的缺点是，有时很难发布任何东西，因为没有什么是绝对完美的。我们试图平衡这种想法：我们应该始终非常快速地推出东西，但同时也要非常快速地修复和改进它们。这几乎是相反的理念，但我们尝试将两者结合，我认为效果很好。通常在公司内部，并不一定有很多正式的审查流程，或者说我们并不总是以这种方式审查每一件发布的东西，因为我们希望员工觉得他们可以把东西放进应用里，然后我们一起尝试。更多的是“让我们先试试看”，但在发布给所有人之前，我们确实需要再次审视它。

---

### [00:12:25] Lenny

**English:**
A lot of founders, a lot of product leaders, a lot of designers definitely want to create space for craft and making products really great, something they're really proud of, but in practice it's really hard. Very few teams and companies do this. Is there anything else you've learned about creating space for this sort of thing and prioritizing it for founders that are listening that are trying to instill more and more of this or do you have to be a designer CEO like Karri and really it's hard to do otherwise?

**中文翻译:**
很多创始人、产品负责人和设计师肯定都想为工艺创造空间，打造出让他们引以为豪的伟大产品，但在实践中这非常困难。很少有团队和公司能做到这一点。对于正在收听并试图在公司中注入这种文化的创始人，关于如何为这类事情创造空间并确定优先级，你还有什么心得吗？或者说，是不是必须像 Karri 这样本身是设计师出身的 CEO 才能做到，否则很难？

---

### [00:12:53] Karri Saarinen

**English:**
I don't think actually. It's not purely coming from me. I think all of us founders like Jori and Tuomas additionally, their background is engineering, but I would say I think they spend even more time on the details than sometimes I do. I think very early on when it was the three of us I would be the one doing the broad strokes designs like this is how the UI works and this is how some of the things work. They were the ones that were like, "Oh, there should be animation here and there should be this kind of thing here." I think it's like that DNA I think comes from all of us. I think with the craft it always starts with people need to care about it. If it's not valued in the company, then it's very hard for anyone to do because people don't feel like it's valued. I gave this advice to some founder. He was asking me about it and in their case their founders were coming from different companies. Maybe this one founder came from Airbnb and then the other ones came from Facebook and Amazon. For example, I think Facebook and Amazon have a very different culture on quality or craft or shipping. I think it's what I said to them. You need to align on it. It's like you cannot run a company with multiple different kinds of cultures. I think I made some points like why the quality is important for certain products and you should all believe in that and then instill that with everyone you hire. The other thing I would say that we like to do is we actually don't have much PMs in the company. We only have one and we can talk about more about it. One of the things I think that happens is when you build a team and you start creating these very specific roles for everything I think that often the PM can be the ones figuring things out and making decisions and guiding the team, but they're not the ones building the feature. They're not there looking at it the whole day like where does this button go or how does it work? I think a lot of that, this craft for us happens when we give the project team this ownership and the project team is just engineering and design. Then, when they start building that feature they start seeing these opportunities that this thing could be better. A good example of this is one of our engineers, Andreas. When we were building this right click menu in the app so you can click different things and under that you have sub-menus. Mac OS does this well where it's when you open that menu you hover on the menu and then you want to go to the sub-menu. You hover to the right. You don't have to go exactly horizontally to get into that menu. You can actually go diagonally or you don't actually have to hit the menu exactly. There's this safe zone, but a lot of software just implements like, "Hey, let's do this menu. Let's make the sub-menu." It only works if you exactly hover over the menu. Then, what happens is the user often misses with few pixels what they were trying to do. What Andreas did, which we didn't tell him to do, is like, "Yeah, this kind of sucks and we should make this better." He figured out a way to create those safe areas that are dynamic based on the sub-menu positioning and everything. It's much easier now. You can go diagonally to the actual thing you want to go to. I think these things happen when you give people more of the ownership of the project and also the space to do that and then you also have leadership or generally the company culture that values the quality or the craft.

**中文翻译:**
我不这么认为。这并不完全源于我。我认为我们所有的创始人，比如 Jori 和 Tuomas，他们的背景是工程，但我会说他们花在细节上的时间有时甚至比我还多。在只有我们三个人的早期阶段，我负责大轮廓的设计，比如 UI 如何运作，某些功能如何运作。而他们则是会说：“哦，这里应该有动画，这里应该有这种效果。”这种 DNA 存在于我们所有人身上。关于工艺，它始于人们的在意。如果公司不重视它，那么任何人都很难做到，因为员工感受不到它的价值。我曾给一位创始人建议，他的合伙人们来自不同的公司，比如一个来自 Airbnb，其他的来自 Facebook 和 Amazon。Facebook 和 Amazon 在质量、工艺或发布节奏上有着非常不同的文化。我对他们说，你们需要达成一致。你不能在一家公司里运行多种不同的文化。我阐述了为什么质量对某些产品至关重要，你们必须共同相信这一点，并将其灌输给每一个新入职的人。另一件事是，我们公司其实没有多少产品经理（PM）。我们只有一个，待会儿可以细聊。我认为当一个团队开始为每个环节创建非常具体的角色时，PM 往往成了那个理清思路、做决定和指导团队的人，但他们并不是亲手构建功能的人。他们不会整天盯着看“这个按钮该放哪”或者“它怎么运作”。对我们来说，工艺的产生是因为我们将所有权交给了项目团队，而项目团队只由工程和设计组成。当他们开始构建功能时，他们会看到让产品变得更好的机会。一个很好的例子是我们的工程师 Andreas。当我们构建应用内的右键菜单时，Mac OS 做得很好：当你打开菜单并想进入子菜单时，你向右滑动，不需要完全水平移动，你可以对角线移动，甚至不需要精确触碰菜单。这有一个“安全区域”（safe zone）。但很多软件实现菜单时，只有当你精确悬停在菜单上时才有效，导致用户经常因为几个像素的偏差而操作失败。Andreas 在没有被要求的情况下说：“这体验太差了，我们得改进。”他想出了一种方法来创建基于子菜单位置动态生成的安全区域。现在操作起来容易多了，你可以对角线滑向你想去的地方。我认为当给予人们更多的项目所有权和空间，并且公司文化重视质量和工艺时，这些事情就会发生。

---

### [00:16:42] Lenny

**English:**
I got to follow this thread. There's a couple of questions I want to ask. You have one product manager. Would you call him the head of product?

**中文翻译:**
我得顺着这个话题问下去。有几个问题我想请教。你们只有一名产品经理，你会称他为产品负责人（Head of Product）吗？

---

### [00:16:48] Karri Saarinen

**English:**
Yeah, Nan Yu, he is the head of product.

**中文翻译:**
是的，Nan Yu，他是产品负责人。

---

### [00:16:52] Lenny

**English:**
Awesome, what made you decide to hire him and even have any PMs?

**中文翻译:**
太棒了，是什么让你决定雇佣他，甚至决定设立 PM 职位的？

---

### [00:16:56] Karri Saarinen

**English:**
We started to see that we have enough features and areas of the product and also the team speaker that it's hard to keep aligned on all of these things or even keep track of things. Initially, we actually hired Nan as a contractor to help us with this insights data tool. We have this data tool feature built in Linear so you can get data on what's happening in the workspace. For us founders, we realized none of us, we are not super experienced in data tools. We need someone to help out. Luckily, Nan, we knew him and he actually worked at Mode, which is a data tool. We initially hired him like, "Can you help us figure out what exactly should this data tool and how should it work?" I think there's different ways of doing that. I think always the easiest way is let's just copy what some other company is doing, but we didn't want to do that. We wanted to figure out what is actually a useful way to use this data or get this data? He helped us with that and then we saw this could be useful in other larger areas or overall with the whole product it's like we might have these kind of questions. What should we exactly be thinking around here and why and how would we define this direction and then help the teams to also align on it? To us, it's more like he figures out the direction of the product and steers some of the efforts and not like he's there in every meeting and making every decision or writing every spec or something like that.

**中文翻译:**
我们开始发现，产品的功能和领域越来越多，团队规模也在扩大，很难在所有事情上保持一致，甚至很难追踪进度。最初，我们聘请 Nan 作为承包商来帮助我们开发“洞察数据工具”（insights data tool）。Linear 内置了这个功能，可以让你获取工作空间内发生的数据。作为创始人，我们意识到我们中没有人对数据工具有丰富的经验，我们需要帮手。幸运的是，我们认识 Nan，他曾在数据工具公司 Mode 工作过。我们最初雇他是想问：“你能帮我们弄清楚这个数据工具到底该是什么样，以及它该如何运作吗？”我认为有很多方法可以做到这一点，最简单的方法就是抄袭其他公司的做法，但我们不想那样。我们想弄清楚使用或获取这些数据的真正有效方式是什么。他帮我们解决了这个问题，然后我们发现这在其他更大的领域或整个产品中也很有用。比如，我们可能会有这类问题：在这里我们到底该考虑什么？为什么？我们如何定义这个方向，并帮助团队达成共识？对我们来说，他更多的是负责理清产品方向并引导一些工作，而不是参加每一个会议、做每一个决定或写每一份规格说明书。

---

### [00:18:38] Lenny

**English:**
Another question along this line, because there's a lot of PMs listening that are going to be like, "Oh, shit, these guys don't need PMs or PM is over, product management dead." Just another question along these lines, somebody needs to do the work that a PM does basically, right? There's all these things that is on the plate of a product manager when they're at a company and if they're not there, other people have to do those things. What I'm hearing is basically you give those responsibilities to the engineers, designer, and maybe other functions within the team. Is that right?

**中文翻译:**
顺着这个话题再问一个问题，因为有很多 PM 在听，他们可能会想：“天哪，这些人不需要 PM，或者 PM 时代结束了，产品管理已死。”其实，总得有人去做 PM 做的工作，对吧？当 PM 在一家公司时，他们手头有很多事情要做，如果他们不在，其他人就得承担这些工作。我听到的是，你基本上把这些职责交给了工程师、设计师，可能还有团队中的其他职能。是这样吗？

---

### [00:19:06] Karri Saarinen

**English:**
Yeah, I mean definitely I think what it means is, and there's definitely a trade-off. I think sometimes when companies specialize roles a lot it's because it's more efficient. If the engineer spends 100% of their time coding something, then it's like they're using their skillset to the max. Then, we just think that in order to build quality things or build things in a certain way it's actually better if people actually also spend some time thinking about things and not just executing. Yes, for every project there's a project lead. That lead can be engineer or designer. It's not a formal role or it's not based on your whatever level or it's just like you need to be certain title that you can be that. It's more like an assignment that now you are responsible getting the project started and working together with the team, figuring it out, and then communicating changes or communicating how that progress happens. Definitely it means that the engineers or designers also have to do these things and they do need to communicate and they do need to think about the scope or things. It's a different way of doing things. Also, not everyone wants to do that, which is fine, but we on the hiring front try to hire people that are interested in the broader scope than just the specific skillset that they have.

**中文翻译:**
是的，这肯定意味着一种权衡。我认为有时公司将角色分得非常细是为了效率。如果工程师 100% 的时间都在写代码，那他们就是在最大限度地利用自己的技能。但我们认为，为了构建高质量的东西或以某种方式构建东西，如果人们也能花点时间思考而不仅仅是执行，效果会更好。是的，每个项目都有一个项目负责人（Project Lead）。这个负责人可以是工程师也可以是设计师。这不是一个正式的职位，也不取决于你的级别或头衔。它更像是一项任务：现在你负责启动项目，与团队合作，理清思路，然后沟通变更或进度。这肯定意味着工程师或设计师也必须做这些事，他们需要沟通，需要考虑范围（scope）等。这是一种不同的做事方式。当然，并不是每个人都想这么做，这也没关系，但在招聘时，我们会努力寻找那些对更广泛的领域感兴趣的人，而不仅仅局限于他们特定的技能。

---

### [00:20:36] Lenny

**English:**
I think those last two points are really essential. One, people often don't want to do this work and they are happy to offload it to a potential product manager. The fact that say engineers have to do all these boring PM things like communicate timelines and keep PR specs aligned and make sure timelines are hit and all that stuff and run meetings, a lot of people don't want to do that. A lot of times they do and I think in this case people seem to really want to be doing that. The other is I think you need a really high caliber team that's very product-minded and the hiring bar needs to be very, very high for say engineers and designers to want to do all these things and be good at them. I think those are two necessary ingredients for this to work out.

**中文翻译:**
我觉得最后这两点非常关键。第一，人们通常不想做这些工作，他们很乐意把这些工作甩给潜在的产品经理。让工程师去做那些枯燥的 PM 工作，比如沟通时间线、保持 PR 规格一致、确保按时交付、主持会议等等，很多人是不愿意的。但在你们这里，人们似乎真的很想做这些。第二，我认为你需要一支非常高素质、非常有产品思维的团队，招聘门槛必须非常非常高，才能让工程师和设计师愿意并擅长做这些事。我认为这是成功的两个必要条件。

---

### [00:21:16] Karri Saarinen

**English:**
Sure.

**中文翻译:**
没错。

---

### [00:21:16] Lenny

**English:**
For teams that want to try this approach, especially startups that are starting out and maybe not excited about hiring product managers, is there anything else that you think is essential or important to functioning well without any product managers? You're at around 50 people at this point?

**中文翻译:**
对于想要尝试这种方法的团队，尤其是那些刚起步、可能对雇佣产品经理不感兴趣的初创公司，你认为在没有 PM 的情况下良好运作还有什么必不可少或重要的地方吗？你们现在大约有 50 人？

---

### [00:21:32] Karri Saarinen

**English:**
We're around 50. Probably the only thing I would say is it's the hiring front that you really need to spend more time on it. Basically, you cannot really interview engineers only for the engineering skills. You also have to interview them for the product skills. Obviously, you cannot I think expect that people have some. If you do some PM interview for them, they're not going to have the same skillset or the same understanding of the concepts or something. The way we have done it in the past is basically I might interview them about the product. I'm not a technical person per se. I will just ask them questions about how did they do something or how do they think about something? It's similar to other roles too. We just look for does this person have opinions about products and how they work? Can they form opinions and can they use their own judgment at times? Then, can they communicate or articulate those things as well?

**中文翻译:**
我们大约 50 人。我唯一想说的是，你真的需要在招聘上花更多时间。基本上，你不能只面试工程师的工程技能，你还必须面试他们的产品技能。显然，你不能指望他们拥有和专业 PM 一样的技能集或对概念的理解。我们过去的做法是，我会面试他们的产品思维。我本身不是技术人员，我会问他们如何做某事，或者对某事怎么看。其他角色也是如此。我们只是寻找：这个人对产品及其运作方式有自己的见解吗？他们能形成观点并在有时运用自己的判断吗？然后，他们能很好地沟通或表达这些想法吗？

---

### [00:22:30] Lenny

**English:**
Awesome, I was just thinking it's interesting that a tool that, I don't think it's designed specifically for product managers, but essentially for building products like the infrastructure for building product in a team is built by a company that has one PM and very few PMs.

**中文翻译:**
太棒了，我刚才在想，一个虽然不是专门为 PM 设计、但本质上是为构建产品而生（作为团队构建产品的基础设施）的工具，竟然是由一家只有一个 PM、极少 PM 的公司打造的，这很有趣。

---

### [00:22:43] Karri Saarinen

**English:**
I mean I think in some ways I would say that with Linear we're trying to help the whole company and I think engineers is probably the largest user group of the product. I think in some ways we want to make the PM's job easier in that they have to spend less time managing everything or the day-to-day because the engineers are actually using the product and they're updating the things. For the PMs, it would be much more easier to get what is the state of things and maybe trust that much more because people actually use the product. In some ways, I think we are trying to make it easier for everyone, easier for the engineers. They can focus more on their work. Then, for PMs I think we're trying to make it so that they can also focus more on other things than just, I don't know, managing the tool that they use. I think that's not the most important job of a PM. I think they should be thinking more of the, I don't know, bigger picture or the other problems or figuring out the next features or something.

**中文翻译:**
我想在某种程度上，Linear 是在试图帮助整个公司，而工程师可能是该产品最大的用户群体。在某种意义上，我们想让 PM 的工作变得更轻松，因为工程师们实际上在深度使用产品并更新信息，PM 就不需要花那么多时间去管理琐事。对于 PM 来说，获取项目状态会容易得多，而且因为大家都在用这个工具，数据的可信度也更高。从某种角度看，我们是在让每个人的工作都变得更容易：让工程师更专注，让 PM 也能专注于工具管理之外的事情。我认为管理工具并不是 PM 最重要的工作，他们应该更多地思考大局、解决其他问题或规划下一个功能。

---

### [00:23:47] Lenny

**English:**
Just one more question along these lines, there's other companies like Stripe I think waited until 200 employees to hire I think their first product manager. Snapchat I think is famous for something around that. Do you have any sense of if you think this might change, when you think you might hire more product managers? Is there a plan here or is it just see how it goes as you grow?

**中文翻译:**
关于这个话题再问最后一个问题。像 Stripe 这样的公司，我记得是直到 200 名员工时才雇佣了第一位产品经理。Snapchat 在这方面也很出名。你觉得这种情况会改变吗？你认为什么时候会雇佣更多的产品经理？是有计划，还是随着增长走着瞧？

---

### [00:24:05] Karri Saarinen

**English:**
I think we'll definitely hire more. It's I think like what I said before. I think we like to see the PM's smarts operating on a higher level. The whole company, I think the way we are trying to build it is we have less people, but people who are more high caliber and can think about larger scope than what their current role is. I think we're just trying to build smaller units, but more effective units, which is I think where the PMs go. There would be also less of them and they're not there at every level. I think in the future as the company grows and the team grows and the product grows, we might have several PMs that are focusing on or looking at specific areas or specific types of things of the product or specific customers or something like that.

**中文翻译:**
我想我们肯定会雇佣更多。就像我之前说的，我们希望看到 PM 的智慧在更高层面上运作。我们构建公司的方式是：人少，但素质极高，能够思考超出当前角色范围的事情。我们试图建立更小但更高效的单元，这就是 PM 的去处。PM 的数量会比较少，而且不会出现在每一个层级。未来随着公司、团队和产品的增长，我们可能会有几位 PM 专注于产品的特定领域、特定类型的功能或特定的客户群体。

---

### [00:24:57] Lenny

**English:**
Awesome, that was a tangent because I could not go in that direction, but I want to come back to design again and craft. So it feels like Linear, one of the reasons you guys have been successful is design and experience is basically a huge differentiator from other products and there's always this question of can design be enough of a differentiator in specific markets? Is there always an opportunity to build a significantly better product experience and have a real shot at disrupting an incumbent? Do you have any sense of when design can be enough of a differentiator? And this is coming from a founder trend aside, should we go big on design and experience or should we invest in distribution or new technology or something along those lines? Any thoughts there?

**中文翻译:**
太棒了，刚才有点扯远了，因为我忍不住想往那个方向聊，但我现在想回到设计和工艺上。感觉 Linear 成功的原因之一是设计和体验，这基本上是与其他产品的巨大差异化因素。一直有一个问题：在特定市场中，设计足以成为差异化因素吗？是否总有机会通过构建显著更好的产品体验来颠覆老牌对手？你觉得什么时候设计足以成为核心竞争力？对于那些正在纠结“我们应该在设计和体验上大举投入，还是应该投资于分销、新技术或类似领域”的创始人，你有什么想法吗？

---

### [00:25:41] Karri Saarinen

**English:**
My belief is that any domain or industry, the more it matters, the more the design matters. I think it's fairly easy to see in different, even in software or in other industries. It's like what happens is whenever there's a new paradigm, I don't know, it's the mobile or the web or something, the first iterations of those products existing there, they don't have to be super well-designed necessarily because they're the first. But then as you build the hundreds, thousand different email clients, any email client now has to be pretty good to be even considered an email client. The bar is so high. I think today the startups, I don't know if you look at the webpage Google launched with or the webpage YouTube launched with or some of these older companies, they were very basic. If you launch that website today, no one would really pay attention. So I think the design is, it's almost like a very basic thing now, that from pretty much from the very beginning you need pretty high level design for people to even pay attention or consider you seriously. And I think it's not necessarily fair because sometimes it's like maybe the product is really good but they didn't have a designer or they didn't have time to do it and then people just dismiss it because it doesn't seem like something that they interest them. So I think that's the first thing is I think it is, and it's going to be more and more important. But I would also say design is never going to be the reason why a company is successful. It's like the company still has to have some other things. The product still needs to be something, it needs to be better in some ways or it needs to be different in some ways. And then a design is just enabling some of these things, enable and similar to technology, it's like if you have good technology, it's easier to do certain things and the product works better in some ways than you having a bad technology or bad infrastructure. So similar to design, I think if you have a good design or even a good brand, people are drawn into it and then it makes some user acquisition or user retention or just even people perception of the product better. I think an example is packaging and products, is like Apple or a lot of companies spend a lot of time effort into the packaging because it's kind of already sets the expectations for the user who is receiving the product. It's like even before you use the product, you start thinking that this is a high quality product and I'm going to love it. And then when you actually have it, then you actually might feel that way, unless the product is really bad and then you wouldn't feel that way. So I think similarly, with startups or SaaS, it's like your landing page or some of the other things. It's like they are already communicating something to the user and they're setting the expectations and then I think that that can be very useful thing, especially early on when no one really knows you or knows the product or cares about you. So I think especially, I feel like design can be very good leverage in the beginning.

**中文翻译:**
我的信念是，在任何领域或行业，某件事越重要，设计就越重要。这在不同行业甚至软件业都很容易观察到。当新范式出现时——比如移动端或网页端——第一代产品不需要设计得特别好，因为它们是首创。但当你面对成百上千个不同的邮件客户端时，任何一个新的客户端现在都必须做得非常好，才能被视为一个合格的选项。门槛太高了。如果你看 Google 或 YouTube 刚上线时的网页，或者其他老牌公司的早期页面，它们都非常简陋。如果你今天发布那样的网站，没人会理你。所以我认为设计现在几乎是一项基础要求，从一开始你就需要高水平的设计，人们才会关注你或认真对待你。我觉得这有时并不公平，因为可能产品本身很好，但因为没有设计师或没时间做设计，人们就因为它看起来不吸引人而忽略它。所以这是第一点：设计会变得越来越重要。但我也要说，设计永远不会是公司成功的唯一原因。公司仍需具备其他要素。产品必须在某些方面更好或更独特。设计只是赋能这些东西，就像技术一样：如果你有好的技术，做某些事会更容易，产品性能会更好。设计也是如此，如果你有好的设计甚至好的品牌，人们会被吸引，这会改善用户获取、留存以及人们对产品的感知。一个例子是产品的包装，像苹果或很多公司在包装上投入大量精力，因为它预先设定了用户的期望。在你使用产品之前，你就开始觉得这是一个高质量的产品，你会喜欢它。当你真正拿到它时，你可能真的会这么觉得，除非产品真的很烂。对于初创公司或 SaaS 来说也是如此，你的落地页（landing page）或其他东西已经在向用户传递信息并设定预期。我认为这非常有用，尤其是在早期没人认识你、不了解你的产品或不在乎你的时候。所以我觉得设计在初期是一个非常好的杠杆。

---

### [00:29:08] Lenny

**English:**
I think that's such an interesting insight, especially that first thing you said around how the more often and the more crowded the spaces, the more opportunity there is for design to be a differentiator. Is that roughly how you think about it?

**中文翻译:**
我觉得这是一个非常有趣的见解，尤其是你说的第一点：一个领域竞争越激烈、越拥挤，设计作为差异化因素的机会就越大。这大概就是你的想法吗？

---

### [00:29:21] Karri Saarinen

**English:**
Yeah. So I mean just think about, I don't know, any product category, basically people have then a lot of choices and then they how do they make choices? Maybe there's a specific thing they want, but a lot of people don't necessarily know what is the specific feature I want from this software. So it's more like, well what is the best one? What is the highest quality one? And if you put things side by side and people see things, people are visual. So then the design can be one of those things, it stands out, it's like, "Well, that looks the best or that looks the most quality product to me, so I'm going to use that one." When people have a lot of choices, they probably will pick the one that looks most interesting. Then I think there is, the second part is the brand, which is something that if you can build a brand, then I think it's even the product almost doesn't matter, it becomes this kind of default. I don't know again, like Apple or Nike, it's like yeah, there's all kinds of shoes you can buy, but there's a reason for someone to buy Nike shoes other than some random brand. Even if the random brand would be actually a better shoe, they still buy Nike because they, I don't know, like the brand. So then I think both the design of the product but also the design of the brand can be very strong things that pull people to your company or to the product.

**中文翻译:**
是的。想想看，在任何产品类别中，人们都有很多选择，他们如何做决定？也许他们有特定需求，但很多人并不一定知道自己到底想要软件的哪个具体功能。他们更多会想：“哪个是最好的？哪个质量最高？”如果你把东西并排放在一起，人们是视觉动物。设计就是那个能脱颖而出的东西，人们会觉得：“嗯，那个看起来最棒，或者那个看起来质量最高，我就用那个。”当选择很多时，人们通常会选看起来最有趣的那个。然后是第二部分：品牌。如果你能建立一个品牌，那么甚至产品本身都快变得不那么重要了，它会成为一种“默认选择”。就像苹果或耐克，市面上有各种鞋子，但人们买耐克而不是某个随机品牌是有原因的。即使那个随机品牌的鞋子可能更好，他们还是买耐克，因为他们喜欢这个品牌。所以，产品设计和品牌设计都是吸引人们关注公司或产品的强大力量。

---

### [00:30:48] Lenny

**English:**
Is there anything you've learned about just building a brand over the course of building Linear, something you find to be really important in actually building that perception that Linear is really great and amazing?

**中文翻译:**
在构建 Linear 的过程中，关于建立品牌，你学到了什么？在建立“Linear 非常棒、非常惊艳”这种认知方面，你觉得什么是真正重要的？

---

### [00:30:59] Karri Saarinen

**English:**
To me, I think the brand should be always authentic and it should, I think even if people can't articulate it, if people start to feel like something is off, I think there can be companies or startups, they think about brands like, oh brand is the logo or the colors of the website or something. And then they do the same thing and some other company does and then they think, "Okay, now we have a brand." But you actually didn't think about what's your brand, what is the message or voice you want to talk about? And it doesn't also, the brand doesn't happen overnight. So it's basically just you start in the beginning and when you start a company you don't have no brand and so you have to create it and you create it over time by the things you do, the things you say, how you say them and how do you approach things, how do you treat customers, how do you build the website or the product? All of these things starts to build this idea, what does this company mean to me in people's heads? I know we both worked at Airbnb and I think Brian Chesky is, I think the brand was probably the most important thing for him. And I don't know how many hours or meetings or conversations there was about the brand and the brand was always, it's part of everything the company does. Because it's true. It's like, yeah, you could book things like places to stay in a lot of places on the web, but when people think about, "Oh, I want to stay in some cool place," they're going to think about Airbnb. It's like they're not going to think about those other places. So that's the power of the brand, people stop thinking about the other things or they start understanding, okay, this is the thing for this.

**中文翻译:**
对我来说，品牌必须始终是真实的。即使人们无法用言语表达，如果他们开始觉得哪里不对劲，品牌就会受损。有些公司或初创公司认为品牌就是 Logo、网站颜色之类的。他们照搬别人的做法，然后觉得“好了，我们有品牌了”。但你实际上并没有思考你的品牌是什么，你想传达什么信息或声音？品牌不是一夜之间形成的。刚开始创业时你没有品牌，你必须通过你做的事、你说的话、你说话的方式、你处理问题的方法、你对待客户的态度、你构建网站或产品的方式来逐渐创造它。所有这些事情开始在人们脑海中构建一个概念：这家公司对我意味着什么？我知道我们都曾在 Airbnb 工作过，我认为对 Brian Chesky 来说，品牌可能是最重要的东西。我不知道他花了多少小时开会或交谈来讨论品牌，品牌始终贯穿于公司所做的一切。事实确实如此，你可以在网上很多地方订房，但当人们想“哦，我想住个酷一点的地方”时，他们会想到 Airbnb，而不会想到其他地方。这就是品牌的力量，它让人们停止考虑其他选项，或者让他们明白：这就是做这件事的首选。

---

### [00:32:43] Lenny

**English:**
And it's part of the reason Airbnb's been able to build a direct destination where people aren't Googling, I want to stay in a home. They're like airbnb.com, which gives Airbnb such a massive advantage not having to run ads on Facebook and Google or SEO. It's just like people know Airbnb and they just go straight there. And there's very few sites where people go, "I'm going to go straight there and look for some," knowing that they can also compare hotels on all these other sites. Coming back to design briefly, just very practically, how do you guys do design reviews? Just how do you actually go about reviewing what's going at, and then this may be too big a question, but just whatever you can share here, is just how do you know when it's done? How do you know when it's ready and approved? Karri sealed, checkbox, ready to go.

**中文翻译:**
这也是 Airbnb 能够成为直接访问目的地的部分原因——人们不会去 Google 搜“我想住家里”，而是直接输入 airbnb.com。这给了 Airbnb 巨大的优势，不需要在 Facebook 或 Google 上打广告，也不需要拼命做 SEO。人们知道 Airbnb，就直接去了。很少有网站能让人们在明知可以去其他网站比价的情况下，依然选择直接访问。回到设计话题，从实际操作层面看，你们是如何进行设计评审（design reviews）的？你们如何审查正在进行的工作？这可能是一个很大的问题，但请分享一下：你如何知道什么时候“完工”了？如何知道它已经准备好并获得批准了？也就是所谓的“Karri 盖章，勾选，可以发布”。

---

### [00:33:26] Karri Saarinen

**English:**
We've been exploring different ways of doing this. I think today, I still run the design team, so I do see some of the designs on a weekly basis and then, or one of the other co-founders or head of product, we are basically the sponsors for the projects. So then we are responsible reviewing the work. And so we might just have a meeting where we go through, okay, well let's go through the demo and people can explain what's going on and how they think about it and why. And then we might have feedback, okay, this seems strange or something, and then just after that I might just go into the product myself and try it out. And then what happens sometimes, it's in the initial stages, obviously we're not going to start fixing everything, it's just more like let's try to get the main concept there and figure out how it works. But then before we are launching it, I might just go in and try it out and try the different states and click it around. And sometimes I find things, like we were building this threading to comments and then when it looked all good in the demos and stuff, and then I went to try it and try different lengths of messages and stuff and then I start to see, oh, sometimes the animations are kind of janky or it's just off. They don't go the right way, the screen doesn't scroll exactly right. So then I just captured those things and send it to the team. And so we had to pull back the release a little bit until those things were fixed. That one was, it's very, I think a simple concept and it's very known concept like, okay, this is how threading comments works. So that was mostly about, okay, what's the execution of this? But then we have projects where we are not sure exactly how this should work and we can try it ourselves. We also have to see how companies use it. So something like we built this feature project updates and it's a common thing companies do. It's like you need to write an update on a project. Is it yellow, green, red? And companies have very different ways of doing this in different tools and we just thought, well, I think it would be really nice if it's inside Linear and the team, when they work on a project, they can write the update, Linear can also capture some of the stats, what actually happened. I think with that feature it's been working well, but then also now it'd be exploring. It's like after using it a while we think, oh actually, if there could be more robust way of following these updates. Maybe the leadership could just get these updates over email or maybe when you have a lot of updates you should have a search or a filtering system or something. So I think a lot of times we just think, okay, this is the scope of it for now and we are okay launching this and the execution is good. But we know that this is not the fully figured out version and we just need to see people trying it out and see the feedback.

**中文翻译:**
我们一直在探索不同的方式。目前我仍然领导设计团队，所以我每周都会看一些设计。我、其他联合创始人或产品负责人基本上是项目的“赞助人”（sponsors），负责审查工作。我们可能会开个会，看演示（demo），大家解释进展、思路和原因。然后我们可能会给反馈，比如“这看起来有点奇怪”。之后，我会亲自进入产品试用。在初始阶段，我们显然不会开始修复所有细节，更多是尝试理清核心概念。但在发布之前，我会亲自去试，尝试不同的状态，到处点点。有时我会发现问题，比如我们做评论嵌套（threading）时，演示看起来很好，但我去试不同长度的消息时，发现动画有时会卡顿或不对劲，滚动也不太精确。我会把这些记下来发给团队，我们会推迟发布直到修复。那个功能的概念很简单，大家也熟悉，所以评审重点在于执行。但有些项目我们不确定该如何运作，除了自己试，还得看公司怎么用。比如我们做的“项目更新”功能，这是公司的常见需求：写个项目进展，是黄灯、绿灯还是红灯？不同公司在不同工具里的做法大相径庭。我们觉得如果能内置在 Linear 里，团队工作时顺手写个更新，Linear 还能自动抓取一些统计数据，那就太棒了。这个功能目前运行良好，但我们也在探索：用了一段时间后，我们觉得也许需要更强大的方式来关注这些更新，比如领导层可以通过邮件接收，或者当更新很多时需要搜索和过滤系统。所以很多时候我们觉得，目前的范围（scope）可以了，执行得也不错，可以发布。但我们知道这还不是最终版本，我们需要看用户的使用反馈。

---

### [00:36:36] Lenny

**English:**
So it sounds like on the decision of whether it goes out or not, it's kind of this intuitive feeling from your actual experience trying it out, feeling gut level, this is ready or this needs a little work?

**中文翻译:**
所以听起来，关于是否发布的决定，更多是基于你亲自试用后的直觉，一种直觉层面的感受：“这已经准备好了”或者“这还需要再打磨一下”？

---

### [00:36:46] Karri Saarinen

**English:**
Yeah, I would say a lot of things that we do is more like that but we don't do AP testing or we don't do specific, go follow certain metrics or something. Sometimes we do have telemetry or we can look at how people use certain things and we sometimes do that, but that's not usually the goal we have in mind, like, yeah, we should move this number this much. So it's more about based on the understanding of the problem we have and based on the [inaudible 00:37:16], what we think is right, is this the right solution and is this a good enough solution to be released to the customers?

**中文翻译:**
是的，我会说我们做的很多事情都是这样的。我们不做 AB 测试，也不去刻意追踪某些特定指标。有时我们会有遥测数据，或者观察人们如何使用某些功能，但那通常不是我们的目标，比如“我们要把这个数字提高多少”。更多是基于我们对问题的理解，以及我们认为什么是正确的：这是正确的解决方案吗？这个方案足够好到可以发布给客户吗？

---

### [00:37:24] Lenny

**English:**
One more question along this thread is how do you actually structure these reviews? It sounds like you go straight to a prototype. Is there a design review phase? Is it all kind of informal and people just review, here's what we need your feedback on?

**中文翻译:**
关于这个话题再问一个：你们到底是如何组织这些评审的？听起来你们是直接看原型。有专门的设计评审阶段吗？还是说一切都很非正式，大家只是过一下“这里需要你的反馈”？

---

### [00:37:38] Karri Saarinen

**English:**
So projects don't necessarily have specific states to them, but I would say roughly, usually we do start with design. So there's some explorations on the design, there's different ways that we could approach this or sometimes there's just one way because pretty clear. But then what I said before, is that we do try to get into the building phase as quickly as possible because then we can also see is this direction actually reasonable and is there some problems it causes or how does it just generally feel here? So I think that there isn't specific review stages. It's more like, yeah, let's check on this project every week or every two weeks and then before releasing, let's also make a review of it and really test it out, is it the quality we want?

**中文翻译:**
项目不一定有特定的阶段，但大致上，我们通常从设计开始。会有一些设计探索，尝试不同的方法，或者有时只有一种很明确的方法。但正如我之前说的，我们会尽量快地进入构建阶段，因为这样我们能看到这个方向是否合理，是否会引发问题，或者整体感觉如何。所以没有特定的评审阶段，更多是每周或每两周检查一下进度，然后在发布前进行最终评审并深入测试，看它是否达到了我们想要的质量。

---

### [00:38:34] Lenny

**English:**
Awesome. So that's a good segue to another area I wanted to spend some time, which is the Linear Method. You espouse this way of building product that you call the Linear Method, which you publish online and willing to in the show notes. And I just want to ask a few questions around this way of building product. One is, you are big on this idea of building opinionated software. Can you talk about just what does that mean and then maybe give an example or two of how you actually have done that at Linear?

**中文翻译:**
太棒了。这正好可以过渡到我想聊的另一个领域：Linear 方法（The Linear Method）。你推崇这种构建产品的方式，并将其发布在网上（我会在节目介绍中附上链接）。我想问几个关于这种产品构建方式的问题。首先，你非常推崇构建“有主见/有态度的软件”（opinionated software）。你能谈谈这意味着什么吗？能不能举一两个 Linear 实际操作的例子？

---

### [00:39:02] Karri Saarinen

**English:**
So first with the Linear Method, why did we create it in the first place? Is we just believe that there is more of this modern ways of building software and thinking about it. And we wanted to share some of our thinking on it. And that's also, it relates to how we built Linear as well. So you might understand why we make some choices because this is the way we think about making these choices. So we are trying to share our thinking behind the product and also just like, here's the product and figure it out. So the opinionated piece, I personally have this belief that productivity software should be, and especially company software should be opinionated. I think that what the productivity software is trying to do is make people productive. And I think what productive means is you actually do something that matters for the company, which is, I don't know, build some new feature or fix something or design something. All of those things are eventually, they provide some kind of value for the customer. I think there is this ideas or notions in the world that flexible software is great. I'm like, I think it can be great sometimes. But what happens is people start spending a lot of time figuring things out. Like, how does this feature work? You can use it in 10 different ways and then every team or everyone figures out the different way of doing it. So our thinking is we like to provide this good default or good opinions. Like, this is how the feature works and this is how the workflow works. So you, as a user or as a team don't have to think about it and you can focus on the work you do. And the other thing is, my design mantra is always design something for someone. It is very hard to design everything for everyone because you just end up with a very generalized solution. So then what we are trying to do with the opinionated solution is that that's the best solution or at the most optimized solution we think of. And then when you use it, hopefully you agree and you can feel that it's most optimized. So being opinionated, I think the value it provides people is you don't have to think too much or spend more time on the tool than you do on your actual work.

**中文翻译:**
首先，关于 Linear 方法，我们为什么要创建它？因为我们相信存在更现代的软件构建和思考方式，我们想分享这些思考。这也与我们如何构建 Linear 本身有关。通过它，你可能会理解我们为什么做某些选择。我们试图分享产品背后的思考，而不仅仅是把产品扔给用户让他们自己摸索。关于“有主见”这一点，我个人认为生产力软件，尤其是企业软件，应该是“有主见”的。生产力软件的目标是让人变得高效。而高效意味着你真正去做对公司有意义的事，比如开发新功能、修复 Bug 或做设计。这些最终都会为客户提供价值。世界上有一种观念认为“灵活的软件才是好软件”。我觉得灵活有时确实不错，但后果是人们会花大量时间去研究工具：这个功能怎么用？它有 10 种用法，结果每个团队、每个人都搞出一套不同的用法。我们的想法是提供优秀的默认设置或观点：功能就是这么用的，工作流就是这样的。这样你作为用户或团队就不需要去思考工具本身，而是专注于你的工作。另外，我的设计准则是“为特定的人设计特定的东西”。很难为所有人设计所有东西，因为那样你只会得到一个平庸的通用方案。我们试图通过“有主见”的方案提供我们认为最优化、最好的解决方案。当你使用它时，希望你能认同并感受到它的高效。所以，“有主见”提供给人们的价值在于：你不需要在工具上花费比实际工作更多的心思。

---

### [00:41:35] Lenny

**English:**
And then another core element of the Linear Method is something you call cycles. I know Linear is all around this idea of creating cycles and working in cycles. Can you talk about what is a cycle and how it works at Linear?

**中文翻译:**
Linear 方法的另一个核心要素是你称之为“周期”（cycles）的东西。我知道 Linear 的一切都围绕着创建周期和按周期工作。你能谈谈什么是周期，以及它在 Linear 是如何运作的吗？

---

### [00:41:35] Karri Saarinen

**English:**
So for example, the cycles, it's optional, not that the whole team has to use it or not that the whole company has to use it, but it's there as you can turn it on or off. But basically, I think why we created cycles is that I think any team that works on software or some other products, you always have almost infinite list of things to do and that list gets longer every day. And it can be sometimes very distracting for the individual or for the team to decide, there's a new thing coming in, should we work on that or should we work on this other thing we decided in the past? So the cycles is just a way to say that for the next week or the next two weeks or whatever timeframe, we are going to work on these things and these other things we think are the priority or the focus for this timeframe. And then the team can try to focus on those things. Now if something happens, like I don't know, we really need to jump on this other thing. At least there was some kind of initial state that we decided before we want to do these things and then now something else happened and so now we have to go on this thing. So you have an answer when someone comes to you to ask, "Why didn't you do this other thing before?" Then you can say, "Well, we did decide to do that, but then something happened and we had to do this other thing." So the cycles, it's very similar to sprints, but we like to call it cycles because we are not really sprinting anywhere. The cycles also run on automated schedule. So it's like you don't have to think about which day does it start? Or every time, set it up manually so it just runs automatically. And so it's just meant to help the team to focus on, let's just focus on this few things and forget about the infinite list of other things that are in the background.

**中文翻译:**
例如，周期是可选的，不是说整个团队或整个公司必须使用，你可以开启或关闭它。我们创建周期的原因是，任何开发软件或产品的团队总是有近乎无限的待办事项，而且清单每天都在变长。对于个人或团队来说，决定是处理新来的任务还是处理过去决定的任务，有时会非常分散注意力。周期就是一种方式，明确在接下来的一周、两周或任何时间段内，我们将专注于这些事情，这些是当前的优先级。这样团队就能尝试专注。如果发生了突发状况，比如必须处理另一件事，至少我们有一个初始状态：我们之前决定做这些，但现在发生了变故，所以我们转而处理另一件事。当有人问“你为什么没做之前那件事”时，你有一个明确的答案。周期非常类似于敏捷开发中的“冲刺”（sprints），但我们喜欢称之为周期，因为我们并不是真的在到处“冲刺”。周期是自动运行的，你不需要考虑哪天开始，也不需要每次手动设置。它的目的就是帮助团队专注于这几件事，暂时忘掉背景中那无限的待办清单。

---

### [00:43:27] Lenny

**English:**
You mentioned earlier that you don't set metrics goals and so let me dig into that a little bit. Is that true? You don't really have number goals for features for launches and things like that? And so let me start there and then I have a follow-up question.

**中文翻译:**
你之前提到你们不设定指标目标，让我深入探讨一下。这是真的吗？你们真的没有针对功能发布之类的数字目标吗？我先问这个，然后还有一个后续问题。

---

### [00:43:41] Karri Saarinen

**English:**
So we might have a company level goal sometimes, for example, weekly active users, that's a metric we want to increase or something. But in terms of specific features, we don't have goals for those. And the reason is that I think a product like us or a system that is used by different kinds of companies, and it's like a system made of multiple different parts and it's not necessarily like you want to optimize any specific thing about it. Also, companies are a little bit different, so their usage of different features can differ because they just operate slightly differently or their team size is different or the setup of the team is different or the culture is different. So I think for example, I don't know, some Instagram or some of these apps, it's like, yeah, we need to drive engagement and that's the main feature. That's the main metric for every feature. We don't actually have that. We just think that there should be features that help companies and sometimes we can look at the metrics before we start working on it, like let's see what this state of things are, but we don't necessarily want to set, oh, we need to increase this specific metric by X. It's more like we want to solve this problem. And ideally, the success what it looks like customers agree that the problem is solved or they enjoy the solution and it's not like that the metrics went up.

**中文翻译:**
我们有时会有公司层面的目标，比如周活跃用户数（WAU），这是我们想要增长的指标。但对于具体的功能，我们没有目标。原因是，像我们这样的产品或系统被各种不同的公司使用，它是由多个不同部分组成的系统，不一定非要优化某个特定的点。而且，每家公司都不同，他们对不同功能的使用方式也不同，因为他们的运作方式、团队规模、团队架构或文化都略有差异。像 Instagram 这样的应用，核心是驱动参与度，那是每个功能的关键指标。但我们没有那个。我们只是认为应该有能帮助公司的功能。有时我们在开始工作前会看一下指标，了解现状，但我们不一定会设定“我们要把这个指标提高 X%”。我们更多是想“我们要解决这个问题”。理想情况下，成功的标志是客户认同问题得到了解决，或者他们喜欢这个方案，而不是指标上升了。

---

### [00:45:08] Lenny

**English:**
So just to summarize so far, you have no metrics, you have no experiments, you have essentially no PMs, just one product leader. You spend a lot of time on design and craft and making things awesome. I'm curious just what you think it takes to make a company work in that way? Because this is pretty different from how a lot of other founders think and a lot of other product teams work.

**中文翻译:**
总结一下到目前为止的情况：你们没有指标，没有实验，基本上没有 PM（只有一个产品负责人）。你们在设计和工艺上投入大量时间，力求把东西做得出彩。我很好奇，你认为要让一家公司以这种方式运作需要具备什么条件？因为这与很多其他创始人的想法和产品团队的工作方式大相径庭。

---

### [00:45:32] Karri Saarinen

**English:**
We like to talk about this internally, I like this mixture of magic and science and how we described, there's always some level of science that we do. And I think some companies are very scientific on their product management that they like to measure everything and they do a lot of tests and things, but we just decided we don't think that's necessary or that's good for us. So the science for us, means that we do talk to users a lot and any project we start with, we do some level of user research and as founders, different people on the team, we might have weekly calls with customers or users. We also encourage everyone in the team, go to the customer Slack, they answer people questions. We have shared Slack channels with customers. Anyone, I sometimes go answer the questions there. I also see when they complain about something. I think the first part is the whole team has to be really understanding the product and the customers and the problems people are facing and have that empathy and as well as the understanding what is the state of things today. And then we talk about that. And then sometimes we might pull up stats and see, oh, wonder, is there some kind of patterns we see, okay, these kind of companies are using this thing more and what do we think about it? But usually we have some kind of question we want to answer. It's like, I wonder what is going on. And then we look at it versus let's pull some metrics and then decide that we should increase this metric. And then the magic part is what happens when you build this understanding, everyone in the company builds. It's not like everyone has the same understanding, but everyone builds more of that customer and product understanding. Then we have discussions like what should we be doing or what decision we want to make here? Then everyone is much more informed of actual reality of the customers or the product. And then we think you can much more use your intuition or thinking to do those decisions so you don't have to use data or metrics to back those things up. So I think the main thing is the whole company has to be with the customers or talk to them and then understand where the product might work well or where it might fall short.

**中文翻译:**
我们喜欢在内部谈论这个，我喜欢这种“魔法与科学”的结合。我们总会做一定程度的“科学”工作。有些公司的产品管理非常科学，喜欢测量一切，做大量测试，但我们觉得那对我们来说没必要也不合适。对我们来说，“科学”意味着我们经常与用户交流。任何项目开始前，我们都会做一定程度的用户研究。作为创始人，团队中的不同成员每周都会与客户或用户通话。我们也鼓励团队中的每个人去客户的 Slack 频道回答问题。我们与客户有共享的 Slack 频道。我有时也会去那里回答问题，我能看到他们的抱怨。第一部分是整个团队必须真正了解产品、客户以及人们面临的问题，具备同理心，并了解现状。然后我们会讨论这些。有时我们会调取统计数据，看看是否有某种模式，比如“这类公司使用这个功能更多，我们怎么看？”但通常我们是带着问题去看的，比如“我想知道发生了什么”，而不是为了提高某个指标。而“魔法”部分在于，当全公司都建立了这种对客户和产品的理解时（虽然每个人的理解不尽相同，但都在加深），我们讨论“该做什么”或“做什决策”时，每个人都对客户或产品的实际情况了如指掌。这样你就可以更多地利用直觉或思考来做决定，而不需要用数据或指标来支撑。所以核心是全公司都要贴近客户，了解产品的优缺点。

---

### [00:48:05] Lenny

**English:**
That's what I imagined you were going to say, and I love hearing that. For someone that wants to create a similar culture, is there tactically anything you find, just understand if your employees and engineers, designers have enough of that context and really understand the problem?

**中文翻译:**
我猜你就会这么说，我非常喜欢这个回答。对于想要建立类似文化的人，在战术层面，你如何确保你的员工、工程师和设计师拥有足够的背景信息并真正理解问题？

---

### [00:48:20] Karri Saarinen

**English:**
I think it's always, different people in a company will have different understandings. It's not like you can expect everyone will every day go to see everything and has this. But we do sometimes sessions with the team or we do record videos with the customers, we write notes and we share this with people. I feel like again, it's fairly apparent, if you know your customers or the product, it's a very different way you can talk about it versus if you don't have any idea. I think if you don't have any idea, you probably don't even know what to say. So I think it's apparent if people have that then, it's not like every project's like we need everyone to have this understanding. Probably, usually enough if one or two people have that understanding or have different understanding of different things. So I think again, I feel like it's a culture thing. I think the other thing is you just have to kind of believe in it. I think sometimes people use data a lot or too much because they're worrying or they're afraid that, will I make the wrong choice? And I'm using data to make the choice for me. But then you might still feel like this is not the right choice, but the data is telling me is the right choice and then turns out maybe it was the right choice or not. But it's more like, again, like a practice thing. I think the company and you need to be okay that sometimes we make mistakes and we made the wrong choice and then we just can fix it. But at least we made that choice and the data didn't make that choice for us.

**中文翻译:**
公司里不同的人会有不同的理解，你不能指望每个人每天都去关注所有事情。但我们有时会与团队举行会议，或者录制与客户的视频，写笔记并分享。如果你了解客户或产品，你谈论它的方式会完全不同。如果你一无所知，你可能都不知道该说什么。所以这很明显。并不是每个项目都需要每个人都完全理解，通常有一两个核心人员理解就足够了。这还是文化问题。另一件事是你必须相信这种方式。有时人们过度依赖数据是因为害怕做错决定，想让数据替自己做决定。但有时你心里觉得这不是正确的选择，数据却说是，结果可能对也可能错。这更像是一种实践。你和公司需要接受：有时我们会犯错，选错了方向，那我们就去修复它。但至少是我们自己做的选择，而不是让数据替我们做选择。

---

### [00:50:03] Lenny

**English:**
What's interesting about this is if you've heard the episode on RAMP and how Ramp builds product with Geoff Charles, there's such different ways of building product. Ramp is all about velocity, shipping all the time, metrics, measuring everything. And your approach is almost the opposite. And I think what's interesting there, as a takeaway, is just there's many ways to do it. You just have to do it almost fully and you have to have really specific people. It feels like the people want to work in a certain way. And a lot of it I think also is the founder has to be natural to the way the founder operates and thinks about building and building a company.

**中文翻译:**
有趣的是，如果你听过关于 Ramp 以及 Geoff Charles 如何构建产品的那一集，你会发现那是截然不同的方式。Ramp 强调速度、不断发布、指标和测量一切。而你的方法几乎相反。我觉得这说明构建产品有很多种方式。你只需要彻底地贯彻其中一种，并且拥有合适的人才。感觉员工也想以某种特定的方式工作。而且很大程度上，这种方式必须符合创始人运作和思考公司构建的本能。

---

### [00:50:39] Karri Saarinen

**English:**
Yeah, and for sure. And then if you look at successful companies and Amazon is very different than Apple in how they operate. And I think both of them are successful, but not in the same way. So I think it's, again, it's like... Yeah, it's a decision you make as a company or as a founder, what kind company you want to build. I do think there is some aspects of the domain that you're in. What does that domain and the problem space require from that company? And for us, I think it's... I think we are in the retention business. And the trust business that ideally we have a company starting use Linear very early on and then they stay with us forever. And I think the only way we can do that is we need to continuously deliver them good quality product and maintain that trust that we are... That we don't fail them more or somehow otherwise mistreat them. And I think some businesses are much more transactional where it's like, yeah, we just need to make this e-commerce sale. And then once it's done, we don't care what happens. So our case, it's more like we really need to build this relationship over time. And then that's why I think some of the choices we make are also more about respecting the customer versus we're just wanting to drive the revenue of the company.

**中文翻译:**
确实如此。看看那些成功的公司，亚马逊和苹果的运作方式完全不同。它们都很成功，但方式迥异。所以这取决于公司或创始人想建立什么样的公司。我也认为这与你所处的领域有关。那个领域和问题空间对公司有什么要求？对我们来说，我们做的是“留存”生意和“信任”生意。理想情况下，一家公司在很早期就开始使用 Linear，然后永远留在我们这里。我认为实现这一目标的唯一方法是持续提供高质量的产品，并维持那份信任——我们不会让他们失望，也不会亏待他们。有些业务更具交易性，比如电商，只要完成销售，后续就不太关心了。而我们的情况是需要长期建立关系，所以我们的很多选择更多是关于尊重客户，而不仅仅是驱动公司收入。

---

### [00:52:02] Lenny

**English:**
Awesome. Such an important point. [Sponsor message for Pendo omitted]. Something you're really good at personally is focus. I find that just trying to get you on this podcast was a lot of like, "Hey Karri. Hey, have you thought about this yet?" And I know that a lot of VCs are just reaching out to you all the time, all these really fancy VCs that are just trying to talk to you and get close to you. And I just know you're really good at avoiding shiny objects and staying really focused and really heads down. And I've always wanted to just ask you, how do you do that? Do you have any tricks, systems, processes, approaches to staying focused other than just ignore the inbox mostly?

**中文翻译:**
太棒了，这一点非常重要。[赞助商信息略]。你个人非常擅长的一点是“专注”。我发现邀请你上这个播客费了不少劲，得不停问：“嘿 Karri，考虑得怎么样了？”我知道很多风投（VC）一直在找你，那些顶尖的 VC 都想和你聊聊，想拉近关系。但我知道你非常擅长避开那些华而不实的东西（shiny objects），保持专注，埋头苦干。我一直想问，你是怎么做到的？除了忽略收件箱，你有什么秘诀、系统、流程或方法来保持专注吗？

---

### [00:53:39] Karri Saarinen

**English:**
Yeah. I don't think there's any complicated processes. And so I think one of the things, I was in YC in 2012 and one of the main things they say there is what you should be focusing on when you build a startup is talk to customers, build the product, exercise. And if you find yourself doing something else, then those three things, it's probably the wrong thing to do. And the exercise is that it's important for you to be healthy or not just burn yourself out. So I think it was a balance to that. I'm doing those three things. I think the thinking there is, I think we often as a company also talk about this, and very early on. And I use this the same way and I think the company can use it the same way. I think there's always things that you're supposed to do or it sounds like a good idea to do. And it could be like, yeah, come to this podcast. And I actually think before it wasn't like... Or I always have this question, is this important to do now or is it important to maybe do later? So I think, for example, the question on this podcast is I didn't feel like it was important to do it earlier because we weren't at the stage or a scale or something that I think it'd be as interesting or something. So I think it was a better timing to do it later. Similarly, when we built the product, initially we were just very focused on is this really important thing to do? There's always like, yeah, you could get SOC 2 security certificate. And we know that eventually we need to get it, but we don't need it today. So we just say no to that. And if customer asks for it, so we say we don't have it. And we'll have it one day but not now. And see, a lot of times people are like, "Okay, that's fine." And then internally, we also talk about this, you knowing RPG games, you have the main quest lines and then you have the side quest lines. And we often talk about the companies avoid the side quests. There's always ideas people have and it's a good thing and it's like people have ideas, but then it might be like, "Yeah, let's make this T-shirt, so let's make this thing." And then we're like, "Well, does it help the customers? Does it help the product?" This sounds like a side quest to me, and basically means we shouldn't do it. This doesn't progress the main quest line, which is building this product and making it awesome for these customers. So it's similar to me. It's like I operate this way personally too, that I think about "Is this important for the main quest line in building this company for me? Or is this something that I can ignore for now, or something that I can do later and it makes more sense then?"

**中文翻译:**
其实没有什么复杂的流程。2012 年我在 YC 时，他们教的一件核心事情就是：在创办初创公司时，你应该专注于三件事：与客户交谈、构建产品、锻炼身体。如果你发现自己在做这三件事以外的事情，那可能就是错的。锻炼是为了保持健康，不至于精疲力竭。所以我一直在做这三件事。我觉得公司也可以这样思考。总会有一些你“应该”做或者听起来不错的主意，比如上这个播客。我总是问自己：这件事现在做重要吗？还是以后做更合适？比如上播客，我觉得之前没那么重要，因为我们还没到那个阶段或规模，没那么有趣。所以我觉得晚点做时机更好。同样，在构建产品时，我们最初非常专注：这真的是必须做的吗？比如 SOC 2 安全认证，我们知道最终需要它，但今天不需要。所以我们拒绝了。如果客户问起，我们就说现在没有，以后会有。很多时候人们会说：“好吧，没问题。”在内部，我们也用 RPG 游戏的术语：你有“主线任务”和“支线任务”。我们常说公司要避免支线任务。人们总会有各种主意，比如“我们做件 T 恤吧”或者“做个这个吧”。我们会问：“这能帮助客户吗？能改进产品吗？”如果听起来像支线任务，我们就不错。因为它不推进主线任务——即构建产品并为客户提供极致体验。我个人也是这样运作的：这对我建立这家公司的主线任务重要吗？还是我可以现在忽略，或者以后再做更有意义？

---

### [00:56:35] Lenny

**English:**
That is such incredibly good advice. Basically ask yourself, "How important is this to do now? And is this the main quest or is this a side quest?" Amazing. Okay, so let's talk about hiring. As with most areas, you're very, very, very deliberate about hiring. The bar is so insanely high at Linear, and you also hire very few people. So just a few questions along these lines, just one is when you're hiring people, what do you look for that you think maybe other people are not looking for enough? And where do you spend a lot of time?

**中文翻译:**
这建议太棒了。基本上就是问自己：“现在做这件事有多重要？这是主线任务还是支线任务？”太赞了。好了，聊聊招聘吧。和大多数领域一样，你在招聘上非常、非常、非常谨慎。Linear 的门槛高得惊人，而且你们招的人很少。关于这一点我有几个问题：当你招聘时，你会看重哪些别人可能不够重视的特质？你在哪些方面花的时间最多？

---

### [00:57:09] Karri Saarinen

**English:**
I think one of the things all of us founders saw in this high-growth company is that sometimes the high growth, especially on the employee side, is not that great. It can create a lot of chaos or just messiness. Or just generally in my past and working in companies, it's almost never... It was always easier to work with a smaller team, very high quality people than with a very large team of more average people. It's almost like it's always faster and better output when you have a much more smaller team. That was the thing with Linear too, is we just believe that you can actually build better with less people than you can with more people. So that's the basic belief we have. So then when it goes to hiring, we've been taking very slow steps on it that in almost the first year we didn't hire anyone. Then the second year we hired a couple people, and then the second year we hired a few more. We never more than doubled in a year. And that's been our guideline that we shouldn't more than double. And this might be something we change in the future that we actually might do less than that. But when we look into hiring, it is a couple things. One is also that it obviously depends on the role, but basically I would say with every role, we often talk about there needs to be some taste or some this kind of understanding of how things are done or what's the... People have more a broader perspective than whatever their role is. So we talked about the engineering before that they do need to do some of this PM type of stuff. And so what we look for in them is that if they have some of this skill set or product thinking, or they can articulate why some choices are better than some others, or in their past did they disagree with some of the company's choices or the team's choices, or... So we want to have this... Obviously they need to be good developers, but also do they have this a product sensibility, or do they have a judgment around that? And this goes similar to, for example, a marketing hire is... We think about, yeah, we do need the marketing skill sets, but then we also want to see that this person also maybe is a good storyteller or they have this appreciation for writing or stories or they have a taste of what's interesting and what's not. So I think, or when we hire operations person, we also like to see that they maybe have understanding on HR and maybe it's not their role, but they understand it. And what happens is when you have these people that are a little bit more than their title, it's like the company is, I think, much more easier to manage because it's like people can pick up things more easily or they can work together more easily because everyone has more like a shared areas or you rarely get to the point people say it's not my job. It's more like people understand, okay, yeah, I'm kind of in operations, but today I need to help on this HR thing, which is okay. And so that's what we look for people is they are more than their... They can take more scope than their skill set would assume, or what normally is expected from them.

**中文翻译:**
我们几位创始人在高增长公司中看到的一点是，有时高增长（尤其是员工规模的增长）并不一定是好事。它会带来混乱。在我过去的职业生涯中，与一支高素质的小团队合作，总是比与一支庞大但平庸的团队合作更容易。小团队的产出通常更快、更好。这也是 Linear 的理念：我们相信人少反而能比人多做得更好。所以我们招聘非常慢，第一年几乎没招人，第二年招了几个。我们的准则是每年人数翻倍不超过一次，未来甚至可能更少。在招聘时，我们看重几点：首先是“品味”（taste），或者说对事情如何完成的一种理解。人们需要有比其角色更广阔的视野。比如之前提到的工程师，他们需要做一些 PM 的工作，所以我们看重他们的产品思维，看他们能否解释为什么某些选择更好，或者他们过去是否曾对公司的决策提出异议。他们必须是优秀的开发者，但也必须具备产品敏感度和判断力。市场营销人员也是如此，除了营销技能，我们还希望他们是优秀的讲故事的人，对写作有鉴赏力，知道什么是真正有趣的。即使是运营人员，我们也希望他们懂一点 HR。当你的员工能力超出其头衔时，公司会更容易管理，因为大家能更轻松地协作，很少会出现“这不是我的工作”这种情况。我们寻找的是那些能够承担超出其技能设定或常规预期范围的人。

---

### [01:00:45] Lenny

**English:**
So essentially you're looking for these Venn diagram overlappings across different functions and teammates.

**中文翻译:**
所以本质上，你是在寻找不同职能和团队成员之间的“韦恩图重叠部分”。

---

### [01:00:51] Karri Saarinen

**English:**
Yeah. I think the other thing is, like I said before, is we want to build much... I think a company that has less employees, which means that it's... Like I said before, we don't want that many specialized roles or too specific areas of ownership or something. We just think that we could build this... We could have less people and those people can take on more scope and they can own more scope. I think traditionally, I feel like in companies, how do you get more scope is that you advance in the levels of the company because there's a lot of different teams and different levels. And then to get any kind of scope, you need to rise into this higher levels. And what we try to do is you don't actually have to have that many levels, but people can just already, when they start, they can start owning more areas. And I think that can be much more also interesting, not to everyone, but I think interesting to many people. And it's kind of like how I also always felt about us being a designer is I didn't feel like my job is purely just looking at the designs. I also thought I actually need to be helping this business or helping this other area as well. So I think it's just also natural to me.

**中文翻译:**
是的。另一件事是，我们想建立一家员工较少的公司。我们不想要太多专门化的角色或过于细分的负责领域。我们认为人少一点，但每个人承担更多的职责范围。传统公司里，你通常需要通过晋升来获得更大的职责范围。而我们尝试的是，不需要那么多层级，人们从入职开始就可以拥有更大的自主权和负责领域。我觉得这对很多人来说更有趣。就像我做设计师时，我不觉得我的工作只是看设计，我觉得我也需要帮助业务或其他领域。这对我来说很自然。

---

### [01:02:10] Lenny

**English:**
Awesome. So one thing you didn't mention is you have a really unique way of interviewing, which is a paid work trial. Can you just talk about what that is? And also just while you're in that area, you talked about testing for product sensibility, so whatever you can share how you actually do that would be awesome.

**中文翻译:**
太棒了。有一件事你没提到，就是你们有一种非常独特的面试方式：付费工作试用（paid work trial）。你能谈谈那是怎么回事吗？另外，既然聊到这了，你提到测试产品敏感度，如果你能分享具体是怎么做的就太好了。

---

### [01:02:27] Karri Saarinen

**English:**
Yeah. So we do with all of the employees, we've done a paid work trial and depends on the role, what it looks like, how long it is and depends on also sometimes on the person. But basically we do fairly standard interview loops where we test... We have some hiring manager interviews and then skill interviews or tests. And then the last step of the process is the work trial. And basically, they basically come as a mini contractor to the company, and we give them a very usually fairly vague problem statements. If you're an engineer, it's like, hey, there's this feature that needs to be built. How would you build it? Then go build it. And so basically they need to first understand the problem. Then they need to scope it down to something that they can do in the timeframe that they have. And then they actually go... They get the access to a code base. They can actually go and go and build a version of it. And then at the end they can present the work they did. And why we do this is that we just seeing that it's a very good way to see for both of us, both for the company and the candidates to see how we work together. And I think for the candidate, what they can see is, what kind of company are you joining, what is it like to work here, and what is [inaudible 01:03:53] ownership or how do I approach this? I think a lot of engineers also like that they see the code base and they're like, oh wow, this is really clean and it's not some kind of spaghetti code type of thing situation. So I think it helps the candidates as well understand what are they signing off for, which I think can be very risky sometimes. Especially with startups, it's really hard to tell how the startup is operating just from the interviews. And in large companies, I think things are more standardized. So I think they're more similar and it's easier to make that choice. But with startups, it can be very different how companies operate.

**中文翻译:**
是的，我们对所有员工都进行付费工作试用。具体形式和时长取决于角色，有时也取决于个人。基本上，我们会先进行标准的面试流程：招聘经理面试、技能面试或测试。最后一步是工作试用。候选人会以“迷你承包商”的身份加入公司，我们会给他们一个通常比较模糊的问题陈述。如果是工程师，我们会说：“嘿，有个功能需要开发，你会怎么做？去把它做出来吧。”他们首先需要理解问题，然后将其范围缩小到在规定时间内能完成的程度。接着他们会获得代码库权限，去构建一个版本。最后，他们展示自己的成果。我们这样做是因为这是双方互相了解的绝佳方式。候选人可以看到这是一家什么样的公司，在这里工作是什么感觉，所有权是如何分配的。很多工程师喜欢看到我们的代码库，会感叹：“哇，这代码真整洁，不是那种乱七八糟的‘面条代码’。”这能帮助候选人了解他们即将加入的是什么，这在初创公司尤其重要，因为仅凭面试很难看出初创公司的真实运作方式。大公司比较标准化，容易选，但初创公司之间差异巨大。

---

### [01:04:32] Lenny

**English:**
Yeah. That is so unique and I rarely hear of a company being able to hire that way. I imagine one of the reasons you can get away with that where people don't have a full-time job for a while, while we're doing a paid trial is because Linear is such an enticing place to work. I imagine for a lot of companies they can't really do that. But I guess any thoughts on just maybe more companies can actually pull this off?

**中文翻译:**
这确实很独特，我很少听说有公司能这样招聘。我猜你们之所以能做到这一点（让候选人在试用期间暂时放下全职工作），是因为 Linear 是一个非常有吸引力的工作场所。我想很多公司可能做不到。你觉得其他公司也能推行这种模式吗？

---

### [01:04:51] Karri Saarinen

**English:**
Yeah, I think it's always like if you don't ask, you don't know. I think in our case that's just been the standard and we try to work with the candidate. Let's figure out maybe we do it on the weekend or maybe we do it some other vacation holiday or something. So there can be ways we can schedule it so that it causes as little kind of problems to the candidate as possible. And I think we only had only a few people probably have ever declined it. It's not like I think everyone else has been, at least after the fact, they've been happy that they did it because they felt like they had a much better sense of the company they're joining. And then also during that workshop, they can actually join our meetings, they get access to our Slack and Notion, and they also have one-on-one chats with some of the other people on the team. So they already get to know people. So it's a good way for them to evaluate us as well. And then for us, it's obviously we can see... What is important for us to see is how does this person operate in this kind of environment and how do they approach problems? How do they think and are they able to make progress in a very short timeframe, which I always think it's very important for startups. In large companies, you have maybe all the time in the world to do stuff. But I think any kind of startup, even with us when we take our time doing things sometimes, it's still important. We can do things quickly if we have to.

**中文翻译:**
如果你不问，你永远不知道。在我们的案例中，这已经成了标准。我们会配合候选人的时间，比如安排在周末或假期，尽量减少对他们的干扰。只有极少数人拒绝过。大多数人在试用后都很高兴，因为他们对即将加入的公司有了更清晰的认识。在试用期间，他们可以参加我们的会议，访问 Slack 和 Notion，并与团队成员进行一对一交流。这对他们评估我们也是个好机会。对我们来说，重要的是观察这个人在这种环境下如何运作，如何处理问题，以及是否能在短时间内取得进展。这对初创公司至关重要。在大公司你可能有大把时间，但在初创公司，即使我们有时会花时间打磨，但必要时快速行动的能力依然不可或缺。

---

### [01:06:21] Lenny

**English:**
Super cool. Just to close the thread on product sensibility, is there anything you could share of just how you actually help understand someone's strength and ability there?

**中文翻译:**
太酷了。关于产品敏感度，你能不能分享一下你是如何具体考察一个人的这项能力的？

---

### [01:06:30] Karri Saarinen

**English:**
Yeah. I wouldn't say we have some kind of very scientific or some special way figure it out for this. So I think a lot of it, it's like a discussion of... And I often think ask people that... Ask about their projects and I try to go deeper. It's like why was this decision made? Why do you think the decision was made? And I might ask, "Do you think it was the right decision or did you agree on it?" Or ask about what you think you would have done differently or something. So I think it's more like I'm trying to... In this area and what their answers is. And people's answers can be very different levels. Some people might be, "Yeah, I didn't like it. Which yeah, it's not opinion, but it's not based on anything. It's just like you didn't like it. You should be able to expand on it saying well, I don't like it because in this case it would not work well for this kind of users or in this kind of context or for this kind of purposes. So they have more of this reasoning or some kind of rational why they think this way and they can articulate that. So I think that's what we often testing for is can they do this and how well they can do it. Then there can be very wide ranges of how people do it. And when you see someone who really thinks about this stuff, it's very clear to see that they can just talk about it forever and they can go deeper and deeper. And then some people that maybe haven't had the experience or don't think this way, they're like, yeah, I don't really know. I just built it and then seemed fine.

**中文翻译:**
我们并没有什么非常科学或特殊的方法。很大程度上是通过讨论。我会询问他们的项目并尝试深入挖掘：为什么要做出这个决定？你认为做这个决定的初衷是什么？我会问：“你觉得那是正确的决定吗？你当时同意吗？”或者问：“如果是你，你会做哪些不同的尝试？”通过他们的回答，我能看出他们的水平。有些人的回答可能只是“我不喜欢它”，但这没有依据。你应该能展开说：“我不喜欢它，因为在这种情况下，它对这类用户或在某种语境下效果不好。”他们需要有推理过程和逻辑，并能清晰表达。这就是我们考察的：他们能做到这一点吗？做得有多好？当遇到真正思考过这些问题的人时，你会发现他们能滔滔不绝，越聊越深。而那些没经验或不这样思考的人，只会说：“我不知道，我就是把它做出来了，看起来还行。”

---

### [01:08:18] Lenny

**English:**
Let's transition to the third area I wanted to spend some time on, which is growth. And basically I'd love to just understand how Linear grows and what you figured out around growth, especially in B2B SaaS. So our first question here is just how long did it take from starting to work on Linear to launching, say, V1, something that a number of people can use?

**中文翻译:**
让我们转到我想聊的第三个领域：增长。我非常想了解 Linear 是如何增长的，以及你在 B2B SaaS 增长方面发现了什么。第一个问题是：从开始研发 Linear 到发布 V1 版本（即可以让一定数量的人使用的版本）花了多长时间？

---

### [01:08:38] Karri Saarinen

**English:**
So we started officially in 2019. Some, I think, months before that we were already exploring and prototyping the product. So I think we prototyped different kinds of designs a little bit. And then we also, one of the things we really wanted to solve is we wanted to make the application really fast. And the way we figured out we do that is we have more of this local-based data structure where all the data lives in the client, and then it gets synced on the backends with this delta [inaudible 01:09:13]. And back then, we were just exploring different off-the-shelf solutions and systems, but there was nothing really there, so we ended up building our own. And so we spent some time prototyping that. And then once we officially, I think, started working on the company in April 2019, and then we announced the company roughly mid-April, and we had this little website up with the wait list. And then I think by May we could use it ourselves. And then we started inviting some friends to try it out. But then I think in June, I think we started more inviting people from the wait list. And around June, July, I think we had about, I don't know, 100, 200 users on it and maybe about 10 companies or something. And then we were in this private beta stage for almost a year. And the way we did it was just like we had this wait list of people on the wait list. There was few survey questions, like what kind of tools you use today and then why do you want to use Linear and what's the company size? And we invited people based on... We invited more smaller companies using the tools we currently supported. And then also I was trying to see who is more interested versus just, I don't know, I just want to try it out type of people. And then a year later, in June, we launched it publicly. And back then maybe we already had, I don't know, several hundred of companies using it. And then we also launched the pricing and I think almost all of them... Maybe one company didn't subscribe, but everyone else subscribed to that paid plan.

**中文翻译:**
我们是在 2019 年正式开始的。在那之前的几个月，我们已经在进行探索和原型设计。我们尝试了不同的设计方案。我们最想解决的问题之一是让应用运行得飞快。我们想出的办法是采用基于本地的数据结构，所有数据都存在客户端，然后通过增量同步与后端同步。当时我们考察了各种现成的解决方案，但没发现合适的，所以我们决定自研。我们花了一些时间做原型。2019 年 4 月公司正式启动，4 月中旬我们发布了带有候补名单（waitlist）的小网站。到 5 月份，我们自己就能用了，然后开始邀请朋友试用。6 月份开始从候补名单中邀请人。到 6、7 月份，大约有 100 到 200 个用户，大约 10 家公司。之后我们处于“私人测试”（private beta）阶段将近一年。我们的做法是：候补名单上有几个调查问题，比如你现在用什么工具、为什么要用 Linear、公司规模多大。我们根据这些信息邀请用户，优先邀请那些使用我们当时支持的工具的小公司。我也会观察谁是真正感兴趣的，而不仅仅是“想随便试试”的人。一年后的 6 月，我们正式公开上线。那时已经有几百家公司在用了。我们同时推出了定价方案，几乎所有公司都订阅了付费计划，可能只有一家没订。

---

### [01:11:01] Lenny

**English:**
Okay. There's a number of really interesting things here. So one is you're in private beta for a year and then a year later, you launched. How long was that period between starting to incubate and starting to build to that private beta milestone?

**中文翻译:**
好的，这里有很多有趣的点。第一，你们在私人测试阶段待了一年才正式发布。那么从开始孵化到达到私人测试那个里程碑，花了多长时间？

---

### [01:11:16] Karri Saarinen

**English:**
Yeah, I think it's just a few months. I think just-

**中文翻译:**
也就几个月。我想大概——

---

### [01:11:19] Lenny

**English:**
Just a few months of building the V1?

**中文翻译:**
只用了几个月就做出了 V1？

---

### [01:11:21] Karri Saarinen

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:11:22] Lenny

**English:**
Wow, okay. I thought it was a lot longer. That is so interesting. Okay. What a team you've got over there. Okay. And then this survey piece is really interesting. I've heard a little bit about this story. So essentially you launched it on Twitter. You had kind of a following. Your founders had a bit of a following, so I think that helped build up the initial wait list. But what you did there wasn't just like, hey, go sign up for a wait list and you just add email addresses. It's a survey asking them what tools they use, whether it's GitHub or something else, and then also the size of the company and their interest. And that helped you basically prioritize who to go after and who to onboard. Is that right?

**中文翻译:**
哇，好吧。我以为会久得多。这太有意思了，你们的团队真厉害。关于调查问卷的部分很有趣，我听过一点这个故事。本质上你们是在 Twitter 上发布的，你们几位创始人都有一定的关注度，这有助于建立最初的候补名单。但你们做的不仅仅是让人填个邮箱，而是一个调查问卷，询问他们使用的工具（GitHub 等）、公司规模和兴趣程度。这帮助你们确定了优先邀请和入驻的对象，对吗？

---

### [01:11:56] Karri Saarinen

**English:**
Yeah. And the reason we did it, because we know that we didn't support everything and what I said before and the focus is we want to also be focused on let's just build a version that can work for some people or some companies. We don't have to try to address everyone in the world in the first months of the business. And even before, after that. So it was very selective process. And I think we were fortunate that we were able to get people sign up on a wait list and I think after a month or so we had maybe 4,000 people on the wait list. And then we had this internal... I think initially it was just a very manual process, but eventually we built this invite tool that we could just send invites. But in the beginning, I would go read the actual surveys in a spreadsheet, then I copied the email, and then I emailed them the invite link from my personal email. And then I would just email them after a few days or a week and it's like, "Hey, what do you think?" And the reason we... And so we would invite only like... In the beginning, we maybe invited like 10 people a week. And eventually we increased those amounts. But the reason we did it that way was that we thought that if you just invite everyone at once or a lot of people at once, all of those people are going to probably hit the same problems in this kind of software that is very early stage. So I don't know. They hit the same bug or the same problem in the software. So then they will all send us feedback like, hey, there's this problem. And then we felt like it was a wasted effort. So we would just do these cohorts. Let's invite these people and then they say, hey, this is a problem. This doesn't work, or something. Then we go fix that. Then after we fix that, we invite the next cohort of people. Then they say, well, there's this thing that is needed or this doesn't work, then we fix that. So eventually, I think it was much more... I think an effective way of doing the initial development than just inviting or letting everyone to use the product right at the beginning.

**中文翻译:**
是的。我们之所以这么做，是因为我们知道自己还没法支持所有功能。正如我之前强调的“专注”，我们想先做一个能让一部分人或公司用起来的版本。我们不需要在业务的前几个月就试图解决全世界所有人的问题。所以这是一个非常挑剔的过程。我们很幸运，大约一个月后就有 4000 人在名单上了。最初是非常手动的过程，后来我们才做了邀请工具。刚开始时，我会亲自去电子表格里读调查问卷，复制邮箱，然后用我的个人邮箱给他们发邀请链接。几天或一周后，我会再发邮件问：“嘿，你觉得怎么样？”最初我们每周只邀请大约 10 个人。之所以这样做，是因为我们觉得如果一次性邀请所有人，大家可能会遇到相同的早期 Bug 或问题。如果所有人都发反馈说“嘿，这里有个问题”，那对我们来说是重复劳动。所以我们采用“分批次”（cohorts）的方式：邀请这批人，他们反馈问题，我们修复；修复完后再邀请下一批人，他们反馈新需求或新问题，我们再修复。最终，我认为这比一开始就让所有人使用要有效得多。

---

### [01:14:16] Lenny

**English:**
There are so many interesting lessons from this. I wanted to ask how you got your first 10 customers. And what I'm hearing essentially was from this wait list, you launched it on Twitter, people signed up, you picked people to let onboard, you worked with them over the course of a year to make it what they needed, and then eventually you started charging.

**中文翻译:**
这里面有很多有趣的教训。我本想问你如何获得前 10 个客户，现在听起来，本质上是通过 Twitter 发布吸引候补名单，然后挑选用户入驻，花一年时间与他们合作打磨产品，最后开始收费。

---

### [01:14:33] Karri Saarinen

**English:**
Yeah. I think the first 10 companies using it, I think maybe a little over half. Maybe there was three friends that have startups and they used it. And then I think the majority of them were just from this wait list. But they didn't pay us anything. We didn't have pricing in the beginning or during the private beta. At some point we started building the payments function, so we just added a page in the settings that you can optionally pay. The page in the settings that you can optionally pay and then we just give you a slider that's, how much do you want to pay per seat? Then we just see if... I know some people paid $28 per seat and some people pay $1, but it doesn't matter, we just wanted to test the functionality and see what people think. After a year, when we launched, we already had... In the, I don't know, first week of launching, we had probably some hundreds of customers.

**中文翻译:**
是的。前 10 家公司里，可能有一半多一点是朋友的初创公司，其余大部分来自候补名单。但他们最初不付钱，私人测试期间没有定价。后来我们开始开发支付功能，就在设置里加了一个页面，你可以选择性付费。我们提供了一个滑块，让你决定每个席位想付多少钱。有人付 28 美元，有人付 1 美元，这没关系，我们只是想测试功能并看看大家的反应。一年后正式发布时，我们在第一周就已经有了几百个付费客户。

---

### [01:15:34] Lenny

**English:**
I have never heard of the approach to pricing as just an actual sliding scale where people can slide the scale themselves on how much they want to pay. Did that help you figure out what to charge, or is it mostly just an experiment?

**中文翻译:**
我从未听说过这种定价方式——让用户自己拉滑块决定付多少钱。这有帮你确定最终定价吗？还是纯粹是个实验？

---

### [01:15:46] Karri Saarinen

**English:**
I don't think it gave enough data to decide, but I think it was good to see that there was some people that went... I think that 20 was probably the maximum that people could pay, so I think there was some people that went to it and they felt like, "Actually, yeah, I really love the products. I'm happy to pay $20." I think at least it gave us some confidence that, if we charge for this and it's something under $20, there's going to be market for it.

**中文翻译:**
我不认为它提供了足够的数据来做决定，但看到有人愿意付最高价（我记得上限是 20 美元）感觉很好。有些人觉得：“我真的很喜欢这个产品，我愿意付 20 美元。”这至少给了我们信心：如果我们定价在 20 美元以下，肯定是有市场的。

---

### [01:16:16] Lenny

**English:**
I want to hear about the story of how you've started to feel product market fit, whatever that means to you. When did you start to feel like, "Wow, this is actually going to work and maybe this is going to be a real business"?

**中文翻译:**
我想听听你感受到“产品市场契合点”（PMF）的故事。你什么时候开始觉得：“哇，这真的行得通，这会成为一门真正的生意”？

---

### [01:16:31] Karri Saarinen

**English:**
Yeah, I think we've always been, I don't know, some paranoid or... I guess maybe a paranoid is a good way about the product market fit. I think it's paranoid in a way, we are always wondering, "Do we really have it?" And, "With who do we have it?" I think it's true in our business, that... I think we started feeling it very early on, and when people first started using it and we could see, "Now the whole company is using it and they seem happier using it and the feedback is good and they might have some additional asks for us," but we started feeling like there was definitely a product market fit with certain customer and these were more smaller, early-stage companies maybe where the founder is still running the product and they care about the speed of the shipping or they have certain values in a way, so it was a good fit with them. Then I think we always know that we want to address the whole market and also just these early-stage customers, but we knew that if a Fortune 500 company came to us then, or even today, we might not be... I don't think we can provide them the solution today that works for them, so I don't think the fit is there. For us, the way we think about is, "Do we have the fit in the specific segments?" And how strong that fit is. In the company's journey, the first year, we just focused on, "Can we get the fit..." In the first two years, we focused on, "Can we get the fit in the early stage startup segment?" Basically, the goal was, "We want to be the default for startups, the default tool that the startups pick, and I think we were able to accomplish that, but we just purely focused on that segment and getting the product market fit there. At the same time, we started getting some larger companies and we saw, "Yeah, it's not really great for you right now, but let's work on it, making it better," so I think the last two years we've been focusing on that. It's like, "How do we make the software work better? How do we get the product market fit stronger in this larger company segments that are hundreds of people or 1000 people?"

**中文翻译:**
我们一直对 PMF 保持着一种“偏执”。我们总是在问：“我们真的拥有它吗？”以及“我们是对谁拥有它？”在我们的业务中，我们很早就开始感受到了。当人们开始使用它，我们看到整个公司都在用，而且用得很开心，反馈很好，虽然会有新需求，但我们感觉到在特定客户群中确实存在 PMF。这些客户通常是较小的早期公司，创始人还在亲自管产品，他们在意发布速度，有特定的价值观。但我们也知道我们想服务整个市场，而不仅仅是早期客户。我们清楚，如果当时（甚至现在）有一家财富 500 强公司找上门，我们可能无法提供让他们满意的方案，所以在那类客户中还没有 PMF。我们思考的方式是：“我们在特定的细分市场（segments）中有契合点吗？这种契合度有多强？”在公司的前两年，我们只专注于早期初创公司市场。目标是成为初创公司的默认选择，我们做到了。与此同时，我们开始接触一些大公司，发现产品对他们来说还不够好，所以过去两年我们一直在努力改进，让软件在几百人甚至上千人的大公司中也能拥有更强的 PMF。

---

### [01:18:53] Lenny

**English:**
I think this is such a good way and smart way of thinking about product market fit. A lot of people see product market fit as this binary, "I have it or I don't," and, "When am I going to really feel product market fit?" What you're describing is what I often hear, it's more of this spectrum of more and more confidence that there's product market fit and, even more specifically, it's product market fit with segments of the market. It's this map of the world and you're just slowly acquiring territory in the market with specific elements and then, over time, it grows and grows.

**中文翻译:**
我觉得这是一种非常聪明且深刻的思考 PMF 的方式。很多人把 PMF 看作是二元的——“有”或“没有”。而你描述的是一种光谱：随着信心不断增强，PMF 也在不断扩大，而且是针对特定的市场细分。这就像一张世界地图，你正在通过特定的元素慢慢占领市场领地，随着时间推移，它会不断增长。

---

### [01:19:23] Karri Saarinen

**English:**
Yeah, I think a spectrum is a good way to think about it, too. I feel like there's this blog post written in the past where you know when you have product market fit and I think it probably... It's like that for some, I don't know, social consumer apps. If it's taking off or not, then you don't really have a lot of different segments, or you don't really think about it, you have millions of users and then you see it's taking off, so you have a product market fit. I think in more like a B2B world. I think there's always... You can have different sizes of customers, you can have different domains the customers are in, or there's different categories where you might be doing really well in one category and then not that well another. I think maybe the countering to do things is that, actually, if you're doing really well in some category, just double down on that. This is something I talked to the Zoom founder, Eric, at some point in the company's lifecycle, and this is also what he said. When they were building Zoom in the early days, they would get this one type of customer. I don't know, maybe it's a university and then it worked really well for them. Then they're like, "How do we get more of the universities?" They would always focus on a certain customer rather than, "Let's just try to get everyone, so let's focus on everything," which is not possible. Again, it's about the focus. If you see that something is working really well, then it's almost like you should focus on doing that more until you hit some point. It's like, "Okay, now we do have that category captured or handled as much as we want," and we should expand to new area.

**中文翻译:**
是的，光谱是一个很好的比喻。过去有些博客文章说“当你拥有 PMF 时你自己会知道”，这可能适用于社交类消费应用，爆发了就是爆发了，不需要考虑细分市场。但在 B2B 领域，客户规模不同、领域不同、类别不同，你可能在某一类客户中做得很好，在另一类中却不行。我觉得一种反直觉的做法是：如果你在某个类别做得很好，那就加倍投入。我曾和 Zoom 的创始人袁征（Eric Yuan）聊过，他也这么说。Zoom 早期会抓住一类客户，比如大学，如果效果很好，他们就会想“如何获取更多大学？”他们总是专注于特定客户，而不是试图取悦所有人。这又是关于“专注”。如果你发现某件事非常奏效，就应该专注于此，直到占领该领域，然后再扩展到新领域。

---

### [01:21:12] Lenny

**English:**
Essentially, look for pull and just follow that and pay attention to that.

**中文翻译:**
本质上就是寻找“拉力”（pull），顺着它走，并关注它。

---

### [01:21:17] Karri Saarinen

**English:**
Yeah. I think, for us, there can be sometimes... For example, now we have... Most of the AI companies are using us, so I think it's always... Before that, it was a crypto company, so I think there's... When we see these kinds of things happening, then we start to think like, "Could we do something differently or could we get more of these AI companies on board?"

**中文翻译:**
是的。对我们来说，有时会出现这种情况：比如现在，大多数 AI 公司都在用我们。在那之前是加密货币公司。当我们看到这种趋势时，我们就会思考：“我们能做些什么不同的事情，或者如何吸引更多这类 AI 公司加入？”

---

### [01:21:42] Lenny

**English:**
Such a great lesson. Just a few more questions, you mentioned that you launched on Twitter and that led to a large wait list and a growing wait list. Is there anything you did before that to build this following? That sounds really amazing, "Cool, we just announced it on Twitter and we have this large wait list and then we grow and we get all these customers." Is there anything you did ahead of time in anticipation of this launch? Would you recommend people work on building some kind of following online before they work in a startup? Was it just like, "Hey, we happen to have this following," and it worked out? Anything along those lines you would recommend to founders these days?

**中文翻译:**
非常有意义的一课。还有几个问题：你提到在 Twitter 上发布带来了巨大的候补名单。在那之前你做了什么来积累这些关注者吗？听起来很神奇：“我们在 Twitter 上宣布一下，就有了大批候补，然后就增长并获得了客户。”你为了这次发布提前做了准备吗？你会建议人们在创业前先在网上建立影响力吗？还是说这只是“碰巧有关注者”然后就成功了？你对现在的创始人有什么建议？

---

### [01:22:16] Karri Saarinen

**English:**
Yeah. I think definitely if you have a following and, obviously, depends on what kind of following, but I think my background as a designer, I would say at Airbnb and Coinbase and other places, and I did some talks in conferences and write some blog posts. I was definitely out there and had some of that following, which was helpful, but it wasn't like I have hundreds of thousands of followers or millions, or something. I had maybe 10,000 or something, which is a significant number, but then I think the other thing is... I think with the announcement, one of the things we did, I think, well is I think sometimes startups do try to emulate successful, large companies too much and you do this fancy announcements where it's like, "Hey, now we are doing this fancy thing and it sounds very corporate or something." With our announcement, we wrote it more direct or authentic to us like, "This is what we're going to do and this is why, and these are some of the things we're going to do." On a Twitter, we did the same thing. All of us founders, we wrote our own reasons why we're doing this, and I think it was just much more... I think people like us could resonate more with it, so we were writing to the right audience. I think that's probably the first thing when you're announcing your company, you think about, "Who is my first audience? Who would be the best early users for this product and where are they?" And then, "How do they think about things and what kind of language do they use?" For us, it came very naturally, because we are these people. We are in building software and these companies, and other people have seen similar things we have seen, so I think the way we announced it resonated with a lot of people. Then I think we did have some friends... I said we got some angel round where we got some friends involved. The main reason we did it was that we just felt like, in the early days, it's good to have... You feel like a real company in a way, that you have someone to answer for in a way. Even though the investors normally run your company or they don't have that much power, it's more like, "I took someone's money so I now need to make it worth it," kind of. With the announcement, again, we could use some of those people to spread the message as well.

**中文翻译:**
是的。如果你有关注者，那肯定有帮助，当然这取决于是什么样的关注者。作为设计师，我在 Airbnb 和 Coinbase 工作过，参加过会议演讲，写过博客。我在圈内有一定的知名度，这很有帮助，但我也不是那种拥有几十万或几百万粉丝的大 V，大概也就一万左右。另一件事是，在发布公告时，我们做得很好的一点是：很多初创公司试图模仿大公司的做法，发布那种听起来非常“企业化”的华丽公告。而我们的公告非常直接、真实：“这是我们要做的，这是原因，这是我们的计划。”在 Twitter 上，我们几位创始人都写了自己为什么要这么做的理由。这让像我们这样的人产生了共鸣，因为我们找准了受众。发布公司时的第一件事应该是思考：“谁是我的第一批受众？谁是最佳早期用户？他们在哪里？他们怎么思考？他们用什么语言？”对我们来说这很自然，因为我们本身就是这类人。我们发布的方式引起了很多人的共鸣。此外，我们有一些天使投资人朋友，这让我们在早期感觉像是一家真正的公司，有一种责任感：“我拿了别人的钱，我得让它物有所值。”发布时，这些朋友也帮我们传播了消息。

---

### [01:24:57] Lenny

**English:**
To close out our conversation, just a couple more broad questions. You have a pretty unique culture at Linear, and I know one fun thing that you do is you have this baking competition. Can you talk about that and what it is you do there?

**中文翻译:**
在结束对话前，还有几个宽泛的问题。Linear 有非常独特的文化，我知道你们有一件很有趣的事，就是举办烘焙比赛。你能聊聊那是怎么回事吗？

---

### [01:25:12] Karri Saarinen

**English:**
Yeah. Since we are a fully remote and distributed company, so we have people in Europe and US, a lot of group gatherings are challenging. Remote group sessions are challenging, because the time zones are so different, so some of the basic things, like happy hours, don't really work that well. Also, Zoom happy hours is probably not that fun anyway. I think a lot of people in the company watch The Great British Baking Show, so we decided, "Maybe we do something like that," where basically, we would just pick a recipe. Firstly, it was baking, now we expanded to cooking recipes, too. We just pick a recipe that is somewhat reasonable to do in a few hours, in a couple of hours, and it doesn't require tons of equipment or skill, or something. Then we just tell people, "Go buy the ingredients, use the company card," everyone has a company card, "And then hop on Zoom on this day." For me, since I'm in California, it's like 8:00 AM, so we started the baking or cooking then. We've made things like roll cake and lemon meringue pie, and we made some [Portuguese 01:26:35], which is Portuguese pastry. Then we just hop on the Zoom, everyone's doing their thing, following the recipe, and then sometimes people have questions like, "Hey," I don't know, "I'm stuck with this," or, "My dough looks weird, does your dough look like this?" People can help each other and then also chitchat about whatever random things at the same time. Then we do the thing and then everyone takes pictures and posts on the Slack channel, it's what they achieved. I think we have friendly competitions like who did it best, so people sometimes put a lot of effort into the decorations and visuals. In a way, it's, again, a craft thing that we do. I think baking and cooking and these kinds of things are also a craft, so we liked it that way. Yeah, we've been basically doing it quarterly since the beginning of the company. Yeah, the latest thing, we were a little bit... I think didn't have that much time, because we decided to do an easier thing, which is a summer drink recipe, so I think people made matcha drinks and some coconut drinks or white iced tea, or something. Yeah, that was interesting to do.

**中文翻译:**
是的。因为我们是一家完全远程和分布式办公的公司，员工遍布欧洲和美国，组织线下聚会很困难。远程聚会也很有挑战，因为时差太大，像“欢乐时光”（happy hours）这种活动效果并不好，而且 Zoom 上的欢乐时光其实挺无聊的。公司里很多人喜欢看《全英烘焙大赛》（The Great British Baking Show），所以我们决定也搞一个类似的活动。最初是烘焙，现在扩展到了烹饪。我们会选一个能在两小时内完成、不需要太多专业设备或技能的食谱。然后告诉大家：“去买食材，刷公司卡（每个人都有公司卡），然后某天在 Zoom 上见。”对我这个在加州的人来说，通常是早上 8 点开始。我们做过卷饼蛋糕、柠檬蛋白派，还有葡萄牙蛋挞。大家在 Zoom 上各忙各的，照着食谱做，有问题就互相问：“嘿，我卡住了”或者“我的面团看起来怪怪的，你们的也这样吗？”大家一边做一边闲聊。完成后，大家拍照发到 Slack 频道展示成果。我们会有友谊赛，看谁做得最好，大家有时会在装饰和视觉效果上花很多心思。在某种程度上，这又是关于“工艺”的。烘焙和烹饪也是一种工艺，我们很喜欢这种形式。从公司成立起，我们基本上每季度做一次。最近一次因为大家比较忙，我们做了一个简单的夏季饮品，大家做了抹茶饮品、椰子水或白冰茶之类的，很有趣。

---

### [01:27:55] Lenny

**English:**
Have you ever won one of these competitions yourself?

**中文翻译:**
你自己赢过这种比赛吗？

---

### [01:27:59] Karri Saarinen

**English:**
I don't know if we declare winners that much, but I do think I do... Since I'm a designer, I do have some advantages on the visual presentation, so I think that I generally do well on that. Obviously, with this remote competition, that's the only thing you can really look for. It's not necessarily about the texture, because you can't really taste it through the Zoom.

**中文翻译:**
我不确定我们是否真的宣布过冠军，但我觉得……因为我是设计师，我在视觉呈现上有优势，所以通常表现不错。显然，在这种远程比赛中，视觉是唯一能评判的标准，没法评价味道或口感，因为隔着屏幕尝不到。

---

### [01:28:27] Lenny

**English:**
Maybe as a last question, just again broadly, you've gone from being an IC designer, manager of designers, to the CEO of very fast-growing company. What's something that you've learned about leadership over the journey of Linear that maybe you didn't expect?

**中文翻译:**
最后一个大问题：你从一名独立贡献者（IC）设计师、设计经理，成长为一家快速增长公司的 CEO。在 Linear 的这段旅程中，关于领导力，有什么是你没预料到的收获吗？

---

### [01:28:43] Karri Saarinen

**English:**
For some reason, it was surprising to me, I think, that being a CEO or some of these leadership roles is that you end up doing so many different things. When I was a designer, even if I would be some high-level designer in some company, you're just mostly focusing on the design and that's your job, but then when you're a CEO, then every week or every day, there's some different thing going on. Sometimes there can be problems, but a lot of times, it's like, "Hey, we need to figure out how we're going to do this. How are we going to do this compensation?" Or, "How are we going to do this marketing plan?" Or, "How are we going to do this offsite thing?" What's definitely challenging for me is handling that different kinds of things that come to you and staying somewhat focused, still, on something. I think I haven't necessarily fully figured it out, but I also figured it out, that hiring and delegation helps with this, that if you can find other leaders that can take on certain areas, that's helpful. That's the main thing, that it's a very wide range of things that you maybe didn't have experience before, but also, I think it's interesting for me to learn about these things. You learn about the financials and you learn about legal things, and then you start to feel like, "Actually, I know something about this thing," over time.

**中文翻译:**
出于某种原因，令我惊讶的是，作为 CEO 或领导者，你最终会处理如此多杂乱的事情。当我还是设计师时，即使是高级设计师，我也主要专注于设计。但作为 CEO，每天、每周都有不同的事情发生。有时是解决问题，但更多时候是：“嘿，我们要决定怎么做这件事。薪酬方案怎么定？”或者“营销计划怎么搞？”或者“团建怎么安排？”对我来说，真正的挑战是处理这些接踵而至的杂事，同时还要保持专注。我还没完全理顺，但我发现招聘和授权很有帮助：如果你能找到其他领导者负责特定领域，那就轻松多了。核心就是：你会接触到大量以前从未经历过的事情，但学习这些也很有趣。你会了解财务、法律，随着时间推移，你会觉得：“嘿，我居然也懂这些了。”

---

### [01:30:18] Lenny

**English:**
For the actual final question, before we get to very exciting lightning round, what's just the future of Linear? What's coming? What's happening in the future? Anything you can share?

**中文翻译:**
在进入激动人心的闪电轮问答之前，真正的最后一个问题：Linear 的未来是什么？有什么新动向？未来会发生什么？有什么可以分享的吗？

---

### [01:30:27] Karri Saarinen

**English:**
Yeah, I think there's always things we're working on and improving. One, a newer thing we're working on is this feature called Asks. Basically, what it is is that... We see that, in a company, there can be a lot of different people that need to interact with the product team or different people that need to interact with this team, but they're not necessarily in Linear or part of this team. We'd be building this an Ask feature, which is an integration to Slack where you can very easily go to a Slack channel and then ask your question. You need something from this team, maybe it's the IT team, that you need a laptop, or maybe it's the infrastructure team and you need something from them, then the team that is handling the request, they can very easily send it to Linear, into this triage that we have, and then they can start doing stuff with it. If they have questions or additional questions to the actual person who requested it, we can send those messages back to the person through Slack, so they don't actually have to go to Linear or they don't have to be a Linear user to use it. We think this is just a good way for the company, or the whole company, to be more potentially involved in the product operations without having to be a power user of Linear, because not every function really uses it or needs to use it.

**中文翻译:**
是的，我们一直在改进。我们正在开发的一个新功能叫“Asks”。我们发现，在公司里，很多人需要与产品团队或其他团队互动，但他们并不一定使用 Linear，也不是该团队的成员。我们正在构建这个“Ask”功能，它与 Slack 集成：你可以直接在 Slack 频道提问。比如你需要 IT 团队配台电脑，或者需要基建团队帮忙，处理请求的团队可以轻松地将其发送到 Linear 的分流系统（triage）中进行处理。如果他们有后续问题，可以通过 Slack 回复给提问者。这样提问者不需要进入 Linear，甚至不需要是 Linear 用户。我们认为这能让全公司更好地参与到产品运营中，而不需要每个人都成为 Linear 的重度用户，因为并不是每个职能部门都需要深度使用它。

---

### [01:32:01] Lenny

**English:**
Awesome. What a cool peek at something coming out soon, or maybe out by the time this comes out. With that, we've reached our very exciting lightning round. I've got a bunch of questions for you. Are you ready?

**中文翻译:**
太棒了。这是一个非常酷的预告。现在，我们进入了激动人心的闪电轮问答。我准备了一堆问题，准备好了吗？

---

### [01:32:13] Karri Saarinen

**English:**
Yeah, I'm ready.

**中文翻译:**
准备好了。

---

### [01:32:14] Lenny

**English:**
All right. What are two or three books that you've recommended most to other people?

**中文翻译:**
好的。你向别人推荐最多的两三本书是什么？

---

### [01:32:20] Karri Saarinen

**English:**
Timeless Way of Building by Christopher Alexander. He wasn't really an architect, but he, I think, taught in Berkeley. He has these interesting thoughts about building things and he focuses on buildings and towns and these kinds of spaces, but I think there's a lot of things that are also interesting for building software. The other book that I like is the Zen and the Art of Motorcycle Maintenance, because it also talks about the quality of things and I think that's one of the main themes of the book. The thing is also that quality is so hard to define. If you actually start thinking about it, it's like, how do you define it? It's really hard to pin down, but it's like when you try something or see it, then you know if it's quality or not.

**中文翻译:**
一本是 Christopher Alexander 的《建筑的永恒之道》（Timeless Way of Building）。他不是纯粹的建筑师，曾在伯克利任教。他对构建事物有非常有趣的见解，虽然他关注的是建筑和城镇，但很多理念对构建软件同样适用。另一本我喜欢的书是《禅与摩托车维修艺术》（Zen and the Art of Motorcycle Maintenance），因为它探讨了事物的“质量”（Quality），这是书的主题之一。质量很难定义，但当你看到或体验到它时，你就会知道它是否具备高质量。

---

### [01:33:13] Lenny

**English:**
What are some recent movies or TV shows you've really enjoyed?

**中文翻译:**
最近有什么你非常喜欢的电影或电视剧吗？

---

### [01:33:17] Karri Saarinen

**English:**
I think that the movie is probably John Wick 4. Obviously, there's no story in that movie, but I think it's very true to its nature, so I like that fact. Also, recently, I started watching the Silo on Apple TV, and I think I like it. It's like a good mystery and then, also, it reminds me of the Fallout games, so I like it that way, too.

**中文翻译:**
电影的话可能是《疾速追杀 4》（John Wick 4）。显然那电影没什么剧情，但它非常忠于自己的风格，我喜欢这一点。最近我也在看 Apple TV 上的《羊毛战记》（Silo），我觉得挺好看的，悬疑感很强，而且让我想起了《辐射》（Fallout）系列游戏。

---

### [01:33:46] Lenny

**English:**
I actually read the Silo books and I was really excited for the show to come out, but I mentioned this on a previous podcast, the show is so little to do with actual books. The core ideas are the same, but there's all these stories that they're just making up on the show, so I stopped watching, because that's not what I was hoping for, but-

**中文翻译:**
我读过《羊毛战记》的原著，对剧集很期待。但我在之前的播客里提过，剧集和原著差别很大。核心概念是一样的，但剧里编了很多新故事，所以我没看了，那不是我期待的样子。

---

### [01:34:02] Karri Saarinen

**English:**
Okay, interesting. Maybe I need to check the books later, once I watch the show.

**中文翻译:**
好吧，有意思。也许等我看完了剧再去读读原著。

---

### [01:34:08] Lenny

**English:**
Yeah. Definitely, read the books, but there's three of them and only the first one is actually good. The other ones are not actually very good and I should not have read them, because it just went off the rails a little bit. Anyway, next question. What is a favorite interview question that you'd like to ask candidates when you're interviewing them?

**中文翻译:**
原著值得一读，但一共三本，只有第一本好。后面两本不太行，我不该读的，剧情有点跑偏了。言归正传，下一个问题：面试候选人时，你最喜欢问的问题是什么？

---

### [01:34:22] Karri Saarinen

**English:**
I think, usually, I like to ask, what is the candidate most proud of and why? On their professional life or otherwise, what they're most proud of and why. Then I think we can go deeper on that, but I think it gives you a little bit of indication, what the person values and how they think about things. Also, I think it's always nice that people can share something they think they did really well and we can spend time on it versus just asking something more like negative things.

**中文翻译:**
我通常喜欢问：候选人最引以为豪的事情是什么？为什么？无论是职业生涯还是其他方面。我们可以顺着这个话题深入聊聊。这能体现一个人的价值观和思考方式。而且，让人们分享自己做得出色的事情，比总是问负面问题要好得多。

---

### [01:34:52] Lenny

**English:**
What are some favorite products you've recently discovered that you really, really like?

**中文翻译:**
你最近发现了哪些非常喜欢的、心头好的产品？

---

### [01:34:58] Karri Saarinen

**English:**
I'm not sure if I discovered them recently, but recently in this home office, I've been installing some of these hue lights and I really like them, because throughout the day, I can have more harsh lighting, because I'm in meetings or something, and then in the evening, I can change the temperature. I make it much more red or orange, or something. I think it's nice that you can transition the space. It's like, "Okay, now I'm working and now I'm doing something else." You can use the lights to indicate that.

**中文翻译:**
不确定是不是最近才发现的，但我最近在家里办公室装了一些飞利浦 Hue 智能灯，我很喜欢。白天开会时我用冷色调的强光，晚上我可以调低色温，变成红色或橙色。这种空间氛围的转换很棒，灯光会提醒我：“好了，现在是工作时间”或者“现在是休息时间”。

---

### [01:35:31] Lenny

**English:**
That is so cool. Do you automate the schedule or you manually change the color?

**中文翻译:**
太酷了。你是设置了自动定时，还是手动更改颜色？

---

### [01:35:35] Karri Saarinen

**English:**
Yeah, I just manually change it. On my home app, I have scenes that... There's the night scene and then there's the day scene, or the morning scene, so I just click that button and then it changes the lights.

**中文翻译:**
我是手动改的。在 Home 应用里我有不同的场景：夜晚场景、白天场景、早晨场景。点一下按钮，灯光就变了。

---

### [01:35:50] Lenny

**English:**
That is extremely cool, I'm going to try that myself. What is a favorite life motto that you like to repeat yourself or share with people? Something you come back to a lot.

**中文翻译:**
太酷了，我也要试试。你最喜欢的人生格言是什么？那种你会经常对自己重复或分享给别人的。

---

### [01:36:02] Karri Saarinen

**English:**
Go slow to go fast. I think, for me, it's about that. Sometimes people have a tendency to rushing into things and especially, I think, in startups, but other places too, you have this like... I think urgency is important, but then sometimes you have too much urgency and you are rushing things, and what happens is that you rushed it and now you need to come back to fix it. I think sometimes I like to think that you should take some time to actually think about it and, "What are you going to do?" And then do it. In the end, it's going to be faster that way than going back and forth and fixing things.

**中文翻译:**
“欲速则不达”（Go slow to go fast）。对我来说就是这样。人们往往倾向于匆忙行事，尤其是在初创公司。紧迫感很重要，但有时过度紧迫会导致草率，结果你不得不回头去修复。我觉得应该先花时间思考清楚“你要做什么”，然后再动手。最终，这比反复修改要快得多。

---

### [01:36:42] Lenny

**English:**
What is the most valuable lesson that your mom or your dad taught you?

**中文翻译:**
你的父母教给你的最宝贵的一课是什么？

---

### [01:36:45] Karri Saarinen

**English:**
I think it's respecting people and things. I think the people respect is pretty obvious, but I think with the things you have, also, I think you should take good care of them when you use them. I don't know, clean them or put them away, and then they're ready for the next time. I think I like that, though. Rather than you treating things like they're trash or not that valuable, you should treat things that they are valuable.

**中文翻译:**
我想是“尊重人和物”。尊重人很显而易见，但对于你拥有的物品，你也应该好好爱护。用完后清洗干净或收好，方便下次使用。我喜欢这种态度：不要把东西当成垃圾或廉价品对待，而要像对待有价值的东西一样对待它们。

---

### [01:37:16] Lenny

**English:**
Final question. You were born in Finland, I think you grew up in Finland. What is a Finnish food that people should definitely try to get as soon as they can?

**中文翻译:**
最后一个问题。你出生在芬兰，也在那里长大。有什么芬兰美食是人们应该尽快尝试的？

---

### [01:37:25] Karri Saarinen

**English:**
One is this salmon soup, and it might sound weird, a fish soup, maybe it's not going to be that interesting. It's a creamy soup, it's on potatoes, carrots, and other things, and it's almost like a little bit of sweet flavor to it. You can make it yourself at home or you can... If you go to Finland, there's probably always a few restaurants that offer it.

**中文翻译:**
一个是三文鱼汤（salmon soup）。听起来可能很普通，就是鱼汤，但它是一种奶油浓汤，里面有土豆、胡萝卜等，带有一点点甜味。你可以自己在家做，如果你去芬兰，几乎每家餐厅都有。

---

### [01:37:52] Lenny

**English:**
Okay, amazing. Is that something we could get here or you have to go to Finland to get it?

**中文翻译:**
太棒了。在美国能吃到吗，还是必须去芬兰？

---

### [01:37:56] Karri Saarinen

**English:**
I don't think I've ever seen it here in the US in any restaurant, but it's not very hard to make it yourself. You can probably Google a recipe. Basically, you just need some salmon, some basic spices and some cream and some fruit, vegetables.

**中文翻译:**
我在美国的餐厅里没见过，但自己做并不难。你可以搜一下食谱，基本上只需要三文鱼、基础香料、奶油和一些蔬菜。

---

### [01:38:13] Lenny

**English:**
All right. Next episode, we're going to do a cooking show with Karri. Karri, thank you so much for being here. You're building a very special company in a really unique way, and I think many founders and many product builders can learn a ton from watching you operate in the business that you're building. Again, thank you so much for being here. Two final questions. Where can folks find you online if they want to reach out, maybe ask you some more questions, and how can listeners be useful to you?

**中文翻译:**
好的，下一集我们要和 Karri 搞个烹饪节目。Karri，非常感谢你能来。你正以一种非常独特的方式建立一家非常特别的公司，我相信许多创始人和产品开发者都能从你的经营之道中学到很多。再次感谢。最后两个问题：如果大家想联系你或问更多问题，可以在哪里找到你？听众们能为你做些什么？

---

### [01:38:38] Karri Saarinen

**English:**
Yeah. I'm on Twitter, my name, Karri Saarinen. We also have the Linear account, which I think is interesting. That's just @Linear. I hope everyone can check out Linear and see if it could work for them in their company, and figure out if there's a pilot. I think we are always happy to assist on those things, if you just want to try it out and try it with the team, we can help you to set it up and help you to understand how to use the product.

**中文翻译:**
我在 Twitter 上，搜我的名字 Karri Saarinen 就能找到。我们也有 Linear 的官方账号 @Linear。我希望大家能去看看 Linear，看看它是否适合你们公司。如果你想在团队里试用，我们非常乐意提供帮助，协助你设置并了解如何使用。

---

### [01:39:09] Lenny

**English:**
Awesome. It's just Linear.app, right? Is that the URL?

**中文翻译:**
太棒了。网址是 Linear.app，对吗？

---

### [01:39:13] Karri Saarinen

**English:**
Yes.

**中文翻译:**
是的。

---

### [01:39:14] Lenny

**English:**
Awesome. Okay, easy-peasy. Amazing. Karri, again, thank you so much for being here. Bye, everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review, as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
太好了，简单明了。Karri，再次感谢。各位再见，感谢收听。如果你觉得本期节目有价值，欢迎在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅。也请考虑给我们评分或留下评论，这能帮助更多听众发现我们。你可以在 lennyspodcast.com 找到往期节目或了解更多信息。下期见。