# Kayvon Beykpour - 双语对照

This is the complete bilingual transcript for Lenny’s Podcast featuring Kayvon Beykpour.

---

### [00:00:00] Kayvon Beykpour

**English:**
The first time I ever met Elon was over FaceTime. He was just like, "Do you want to just come hang out? You can swipe left or swipe right."

**中文翻译:**
我第一次见到埃隆（Elon Musk）是通过 FaceTime。他当时就说：“你想过来一起玩吗？你可以选择‘左滑’或‘右滑’（意指像社交软件一样选择留下来或离开）。”

---

### [00:00:05] Lenny Rachitsky

**English:**
You're known for at Twitter someone that turned the culture of the product team and Twitter in general from a very stagnant, nothing-is-changing product to shipping all the time.

**中文翻译:**
你在推特（Twitter）是出了名的，你把产品团队乃至整个推特的文化，从一种非常停滞、产品毫无变化的局面，转变成了不断发布新功能的文化。

---

### [00:00:15] Kayvon Beykpour

**English:**
We wanted to change the lack of ambition, the lack of creativity, the lack of customers feeling that the product had changed at all.

**中文翻译:**
我们想要改变那种缺乏雄心、缺乏创造力，以及客户觉得产品根本没有任何变化的现状。

---

### [00:00:21] Lenny Rachitsky

**English:**
Here's a list of stuff that your team shipped while you were there, Super Follows, Communities, newsletters, topics, Fleets, testing reactions, edge-to-edge photos, Twitter Blue, Spaces, and obviously, live video.

**中文翻译:**
这是你在职期间团队发布的一系列功能：超级关注（Super Follows）、社群（Communities）、时事通讯（newsletters）、话题（topics）、Fleets（即时动态）、表情回应测试、无边框照片、Twitter Blue（订阅服务）、Spaces（音频空间），当然还有直播视频。

---

### [00:00:31] Kayvon Beykpour

**English:**
The sacred cows are like their own roadmap. What are all the things that you think we're not allowed to change? Let's start there.

**中文翻译:**
那些“神圣不可侵犯的传统”（Sacred cows，指长期存在且不容质疑的惯例）本身就是一份路线图。哪些是你认为我们绝对不能改动的？我们就从那里开始。

---

### [00:00:37] Lenny Rachitsky

**English:**
This was all relatively quickly.

**中文翻译:**
这一切发生得都相对很快。

---

### [00:00:39] Kayvon Beykpour

**English:**
I was like, "I might flame out completely, but Hell if I don't try."

**中文翻译:**
我当时想：“我可能会彻底失败，但如果不试一下，我肯定会后悔死。”

---

### [00:00:46] Lenny Rachitsky

**English:**
Today, my guest is Kayvon Beykpour. Kayvon was the beloved and longest-tenured head of product at Twitter and also GM of the consumer business at Twitter up until the day that it was sold to Elon Musk. He landed at Twitter through an acquisition of his company, Periscope, which was the world's largest live-streaming platform, which ended up inspiring Instagram Live, TikTok Live, Facebook Live, and basically every other social network getting into live video. He sold the company to Twitter in 2015, continued leading Periscope for a number of years, and then moved into leading product and then the entire consumer business.

**中文翻译:**
今天的嘉宾是 Kayvon Beykpour。Kayvon 曾是推特备受喜爱且任职时间最长的产品负责人，同时也是推特消费者业务的总经理，直到推特被卖给埃隆·马斯克那天为止。他通过收购进入推特，他的公司 Periscope 曾是全球最大的直播平台，后来启发了 Instagram Live、TikTok Live、Facebook Live 以及几乎所有进入直播领域的社交网络。他在 2015 年将公司卖给推特，继续领导 Periscope 数年，随后转而领导产品部门，最终负责整个消费者业务。

---

### [00:01:19] Lenny Rachitsky

**English:**
In our wide-ranging conversation, Kayvon shares what it was like getting Elon up to speed at Twitter, what it was like to be fired from Twitter, which actually happened during his pat leave. He also shares all kinds of lessons and stories from transforming Twitter's internal culture from a risk-averse, stagnant, product org to one that was shipping major features regularly. We talk about how they used acquihires and up-and-coming hungry product leaders to lead new initiatives and break through many of their sacred cows.

**中文翻译:**
在我们广泛的对话中，Kayvon 分享了帮助埃隆快速了解推特的情况，以及被推特解雇的经历——这实际上发生在他的陪产假（pat leave）期间。他还分享了将推特内部文化从一个厌恶风险、停滞不前的产品组织转变为定期发布重大功能的组织的各种教训和故事。我们讨论了他们如何利用“人才收购”（acquihires）和充满渴望的新晋产品领导者来领导新项目，并打破许多固有的禁忌。

---

### [00:01:47] Lenny Rachitsky

**English:**
We also get into jobs-to-be-done, Elon's layoffs of most of Twitter's staff after the acquisition, his lessons from building and shutting down Periscope, and also building consumer products in general, and so much more. This episode is full of stories and lessons and a bunch of stuff that you haven't heard anywhere else. With that, I bring you Kayvon Beykpour after a short word from our sponsors. And if you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. It's the best way to avoid missing future episodes, and it helps the podcast tremendously.

**中文翻译:**
我们还深入探讨了“待办任务”（jobs-to-be-done）框架、埃隆收购后对推特大部分员工的裁员、他从建立和关闭 Periscope 中吸取的教训，以及开发消费级产品的一般经验等等。这一集充满了故事、教训和许多你从未在别处听过的内容。在听完赞助商的简短介绍后，我将为你带来 Kayvon Beykpour 的访谈。如果你喜欢这个播客，别忘了在你的播客应用或 YouTube 上订阅和关注。这是避免错过未来节目的最好方式，也对本节目有巨大的帮助。

---

### [00:02:21] Lenny Rachitsky

**English:**
This episode is brought to you by Enterpret. Enterpret unifies all of your customer interactions from Gong calls to Zendesk tickets to Twitter threads to app store reviews, and makes it available for your product team. It's used by leading product orgs like Canva, Notion, Loom, Linear, and Descript to accurately integrate the voice of the customer into your product development process, helping you build best-in-class products.

**中文翻译:**
本集由 Enterpret 为您呈现。Enterpret 统一了您所有的客户互动——从 Gong 的通话记录到 Zendesk 的工单，从推特帖子到应用商店评论，并将其提供给您的产品团队。Canva、Notion、Loom、Linear 和 Descript 等领先的产品组织都在使用它，将客户的声音准确地整合到产品开发过程中，帮助您打造一流的产品。

---

### [00:02:46] Lenny Rachitsky

**English:**
What makes Enterpret special is its ability to build customer-specific, adaptive AI models that provide the most granular and accurate categorization of all your customer feedback, and also connect customer feedback to revenue impact to help product leaders confidently prioritize things that will actually move the needle for your business. If you want a custom model built for your organization so that you can automate your feedback loops and prioritize your roadmap with confidence, get in touch with the team at enterpret.com/lenny. That's E-N-T-E-R-P-R-E-T.com/lenny.

**中文翻译:**
Enterpret 的特别之处在于它能够构建针对特定客户的自适应 AI 模型，对所有客户反馈进行最细粒度（granular）和准确的分类，并将客户反馈与营收影响联系起来，帮助产品领导者自信地确定那些真正能推动业务发展（move the needle）的优先事项。如果您想为您的组织构建定制模型，从而自动化反馈循环并自信地规划路线图，请访问 enterpret.com/lenny 联系他们的团队。

---

### [00:03:23] Lenny Rachitsky

**English:**
Today's episode is brought to you by OneSchema, the embeddable CSV importer for SaaS. Customers always seem to want to give you their data in the messiest possible CSV file, and building a spreadsheet importer becomes a never-ending sink for your engineering and support resources. You keep adding features to your spreadsheet importer, the customers keep running into issues. Six months later, you're fixing yet another date conversion edge case bug.

**中文翻译:**
今天的节目由 OneSchema 为您呈现，它是面向 SaaS 的可嵌入式 CSV 导入工具。客户似乎总是想把数据放在最混乱的 CSV 文件里交给你，而构建一个电子表格导入器会成为工程和支持资源的无底洞。你不断为导入器添加功能，客户却不断遇到问题。六个月后，你还在修复另一个日期转换的边缘案例（edge case）Bug。

---

### [00:03:45] Lenny Rachitsky

**English:**
Most tools aren't built for handling messy data, but OneSchema is. Companies like Scale AI and Pave are using OneSchema to make it fast and easy to launch delightful spreadsheet import experiences from embeddable CSV import to importing CSVs from an SFTP folder on a recurring basis. Spreadsheet import is such an awful experience in so many products. Customers get frustrated by useless messages like error on line 53 and never end up getting started with your product. OneSchema intelligently corrects messy data so that your customers don't have to spend hours in Excel just to get started with your product. For listeners of this podcast, OneSchema is offering a $1,000 discount. Learn more at oneschema.co/lenny.

**中文翻译:**
大多数工具并非为处理混乱数据而设计，但 OneSchema 是。Scale AI 和 Pave 等公司正在使用 OneSchema，快速轻松地推出令人愉悦的电子表格导入体验，包括可嵌入的 CSV 导入以及从 SFTP 文件夹定期导入 CSV。在许多产品中，电子表格导入体验都非常糟糕。客户会被“第 53 行错误”这种无用的信息搞得心烦意乱，最终根本没法开始使用你的产品。OneSchema 能智能纠正混乱数据，让你的客户不必为了开始使用你的产品而在 Excel 中耗费数小时。对于本播客的听众，OneSchema 提供 1000 美元的折扣。欲了解更多信息，请访问 oneschema.co/lenny。

---

### [00:04:28] Lenny Rachitsky

**English:**
Kayvon, thank you so much for being here, and welcome to the podcast.

**中文翻译:**
Kayvon，非常感谢你能来，欢迎来到本播客。

---

### [00:04:35] Kayvon Beykpour

**English:**
Thanks so much for having me, Lenny. Great to meet you finally.

**中文翻译:**
非常感谢邀请我，Lenny。很高兴终于见到你了。

---

### [00:04:38] Lenny Rachitsky

**English:**
It's amazing to meet you. I think this is going to be quite a unique and interesting podcast. A big thank you to Scott Belsky, illustrious former podcast guest for introducing us. When he introduced us, the one thing that he told me is that "Hopefully, Kayvon will share the story about our time getting Elon up to speed at Twitter." I would love to hear that story. I bet other people would too. Are you able to share that story?

**中文翻译:**
见到你太棒了。我想这将是一期非常独特且有趣的播客。非常感谢 Scott Belsky（著名的前播客嘉宾）为我们牵线搭桥。他介绍我们认识时，对我说的唯一一件事就是：“希望 Kayvon 能分享我们当时帮埃隆快速了解推特情况的故事。”我很想听听那个故事，我敢打赌其他人也想听。你能分享一下吗？

---

### [00:05:03] Kayvon Beykpour

**English:**
When all the drama went down with Twitter and Elon ended up buying the company and after the eight months saga of legal back and forth ended up actually taking control of the company, there was that first two-day period where it was complete chaos at Twitter with the sink and Elon spreading his tentacles trying to find out who are the people that he wants to keep and what are the projects that are interesting. In the midst of all that, Scott ended up getting contacted and being asked, "Who should Elon talk to?" Scott recommended that Elon chat with me.

**中文翻译:**
当推特的所有闹剧尘埃落定，埃隆最终买下了公司，在经历了八个月的法律拉锯战并最终实际控制公司后，最初的两天推特内部完全是一片混乱——埃隆带着那个水槽（sink，玩梗“let that sink in”）进场，到处伸出触角，试图找出他想留住的人和有趣的项目。在那混乱之中，Scott 接到了联系，对方问：“埃隆应该找谁谈谈？”Scott 建议埃隆和我聊聊。

---

### [00:05:42] Kayvon Beykpour

**English:**
So, the first time I ever met Elon was over at FaceTime where Elon was just very curious to ask, "Hey, you were at Twitter for a while. You seem to have done some things. What should I be digging into, and who I be talking to?" At the end of that conversation, we ended up arranging an in-person meeting where Scott and I went to Twitter HQ to actually meet Elon. I think this was day two of Elon having brought the sink in. So, we had this really bizarre, wild, but really fun experience of walking into Twitter HQ, and in my case, walking back to Twitter HQ for the first time after having been fired, which was a very strange experience for me, and we walked into the building.

**中文翻译:**
所以我第一次见埃隆是通过 FaceTime，他当时非常好奇地问：“嘿，你在推特待了挺久，似乎做了一些事情。我应该深入研究什么？我应该找谁谈谈？”在那次谈话结束时，我们安排了一次面对面的会面，Scott 和我去了推特总部见埃隆。我想那是埃隆搬着水槽进来的第二天。所以，我们有了一次非常离奇、疯狂但又很有趣的经历：走进推特总部。对我来说，这是被解雇后第一次回到推特总部，感觉非常奇怪。

---

### [00:06:29] Kayvon Beykpour

**English:**
I was scurried through the back door because I didn't want to make a scene and make it ... There was a lot of rumors around is Kayvon coming back, and I just wanted to avoid all of that. So, it was just a very weird experience of being scurried through the elevator and through the back door and go to this massive conference room, which we had on the second floor of the 110th building.

**中文翻译:**
我是从后门溜进去的，因为我不想引起骚动……当时有很多关于“Kayvon 是不是要回来”的传闻，我只想避开这些。所以，被匆忙带进电梯、穿过后门，然后进入 110 号大楼二层那个巨大的会议室，这种体验非常诡异。

---

### [00:06:53] Kayvon Beykpour

**English:**
In that massive conference room, it was me, Scott, Elon, and then at the very, very end of the room, Walter Isaacson, who by the way, I had a hard time. I knew I recognized. I'd never met Walter in person, but I was like, "Is that Walter Isaacson?" But he said nothing the entire time, and we had probably a two-hour conversation talking about the past, the future of Twitter, the good, the bad, the ugly. At the very end of the conversation, Walter came up and introduced himself and was like, "Hi, I'm Walter. Can I get your information just in case I need to ask any follow-up questions?" And I was like, "Oh, shit. I guess that whole conversation was on the record. I don't know."

**中文翻译:**
在那个巨大的会议室里，有我、Scott、埃隆，然后在房间的最尽头坐着沃尔特·艾萨克森（Walter Isaacson，著名传记作家）。顺便说一下，我当时有点懵，我觉得我认出他了，虽然没见过真人，但我心想：“那是沃尔特·艾萨克森吗？”但他全程一言不发。我们聊了大概两个小时，谈论推特的过去、未来，好的、坏的、丑陋的一面。谈话结束时，沃尔特走过来介绍自己说：“嗨，我是沃尔特。我能留个你的联系方式吗，以防我有后续问题？”我当时心想：“噢，该死，看来刚才那番话全都被记录在案了。”

---

### [00:07:31] Kayvon Beykpour

**English:**
So, it was a very surreal experience for a bunch of reasons, including just being weird for me since I was very conflicted about coming back to Twitter, even physically in the office. But I must say it was really fun. It was fun talking to someone. Obviously Elon, I'd never met him before, and he's one of the most successful entrepreneurs of our time. So, that was exciting to go into that meeting. Also, I had been spending so much time dreaming about Twitter and trying to mold Twitter in a direction that I thought was compelling and working with a team of people to do that, and to meet someone who also had a similar ambition, but obviously, in different ways ... He had his own dream for Twitter ... but it was really bizarre and unique and surreal seeing that glimmer in someone else who was like, "Yeah, I also just bought this thing, so I can actually do whatever the Hell I want. And by the way, here's some crazy dreams I have for doing it."

**中文翻译:**
所以，出于各种原因，那是一次非常超现实的经历。对我来说很奇怪，因为对于回到推特——哪怕只是肉身进入办公室——我内心是非常矛盾的。但我必须说，那真的很有趣。和埃隆交流很有意思，我以前从未见过他，他是我们这个时代最成功的企业家之一。所以参加那次会议很令人兴奋。而且，我花了那么多时间梦想推特，试图把推特塑造成我认为引人注目的方向，并带领团队为此努力；而见到一个同样拥有类似雄心的人（虽然方式显然不同……他有他自己对推特的梦想），看到另一个人眼中闪烁着那样的光芒，感觉非常奇特、独特且超现实。他就像在说：“是的，我刚买下了这玩意儿，所以我真的可以随心所欲。顺便说一下，这是我想做的一些疯狂梦想。”

---

### [00:08:35] Kayvon Beykpour

**English:**
It was just a really ... As someone who had had their own dreams for the product, witnessing that it was really unusual and cool. I think that's probably what Scott meant when he said, "You should ask Kayvon about that," was that I think we both kind of recognized that something's about to happen here. Obviously, you have this very public spectacle of someone essentially having a takeover of a public company, but all of that stuff aside, also, you could tell Elon was scheming and cooking up, "What am I going to do with this?" It was cool to see that.

**中文翻译:**
作为一个对这款产品有过自己梦想的人，亲眼目睹这一切是非常不寻常且酷的。我想这可能就是 Scott 说“你应该问问 Kayvon 那件事”的意思，因为我觉得我们都意识到这里即将发生大事。显然，你看到了一个公开的奇观：有人接管了一家上市公司。但撇开这些不谈，你也能看出埃隆正在筹划和酝酿：“我要拿这东西做什么？”看到那一幕很酷。

---

### [00:09:12] Lenny Rachitsky

**English:**
That's an amazing story. I love the Walter Isaacson component of it. Do you feel like you made a dent on his approach and way of thinking? Obviously, he made a lot of big radical changes. Do you feel like you made a dent in his view of where Twitter should go?

**中文翻译:**
这故事太精彩了。我特别喜欢沃尔特·艾萨克森那个细节。你觉得你对他的方法和思维方式产生了影响吗？显然，他做了很多重大的激进变革。你觉得你对他关于推特发展方向的看法产生了影响吗？

---

### [00:09:26] Kayvon Beykpour

**English:**
I don't know. I certainly don't think I've made any impression on how he should run the company. I think that's Elon's going to Elon in his way, and I think he certainly has had some radical moves in terms of how he's running the company, the decisions he made, how many people he let go, how the company is structured, the culture, and all that stuff is like ... We didn't even talk about that stuff.

**中文翻译:**
我不知道。我肯定不认为我对“他应该如何经营公司”产生了任何影响。我觉得埃隆会按埃隆的方式行事，他在经营公司、决策、裁员人数、公司架构、文化等方面的举措确实非常激进……我们甚至都没谈过那些。

---

### [00:09:49] Kayvon Beykpour

**English:**
I think what we spent time talking about is I shared my perspective with him of people I thought who were exceptional, who were at the company, and if I was in his shoes, who I would spend time with and embrace. Most of the people that I mentioned are still there, which is awesome, and they seem to be A, empowered, which is great, and B, having fun, which is awesome. So, hopefully, that stuff is useful.

**中文翻译:**
我想我们花时间讨论的是，我向他分享了我认为公司里哪些人非常出色，如果我是他，我会花时间去接触和重用哪些人。我提到的大多数人现在还在那里，这太棒了，而且他们看起来：A，得到了授权，这很好；B，玩得很开心，这太棒了。所以，希望这些信息是有用的。

---

### [00:10:16] Kayvon Beykpour

**English:**
We spent a bunch of time brainstorming products, and I had my set of projects that I was very passionate about because we'd given birth to them. I think a bunch of those projects, it seems like Twitter's still investing in and putting a lot of energy behind like Community Notes, which at the time was called Birdwatch. But I always felt really bullish on that being the future of essentially how content is moderated on Twitter, just because it was very clear that the way we were handling content moderation among many other flaws just wasn't scalable.

**中文翻译:**
我们花了很多时间进行产品头脑风暴，我有一系列我非常热衷的项目，因为是我们亲手创造了它们。我觉得其中一些项目，推特似乎仍在投资并投入大量精力，比如社区笔记（Community Notes），当时叫 Birdwatch。我一直非常看好它，认为它本质上是推特内容审核的未来，因为很明显，我们当时处理内容审核的方式（以及许多其他缺陷）是不可持续、无法规模化的。

---

### [00:10:55] Kayvon Beykpour

**English:**
Spaces and Communities and the Creator Program of helping people make money on the platform, those are projects that we started over the year-ish prior to Elon taking over. My hope, having left the company and having had a new leader come in, was that those things would be given more oxygen. It's been awesome to see that those have been continuing to grow and be molded in different directions. Yeah, I think in that sense, I hope that our brainstorm was useful, but for all I know he doesn't even remember the conversation.

**中文翻译:**
Spaces、社群（Communities）以及帮助人们在平台上赚钱的创作者计划（Creator Program），这些都是我们在埃隆接管前一年左右启动的项目。我离开公司并迎来新领导后，我的希望是这些项目能获得更多的资源（oxygen）。看到它们继续增长并向不同方向发展，感觉很棒。是的，从这个意义上说，我希望我们的头脑风暴是有用的，但据我所知，他可能根本不记得那次谈话了。

---

### [00:11:31] Lenny Rachitsky

**English:**
I freaking love Community Notes. It's such an amazing product. Let me ask two more dramatic-oriented Elon Twitter questions just to get these out of the way. The first is you said you were fired. I don't know if you've shared that publicly. People always wondered, I think, what happened. I know you tweeted during your pat leave, "I'm leaving Twitter," and no one really knows the story as far as I know. What actually went on there?

**中文翻译:**
我超级喜欢社区笔记。那真是一个了不起的产品。让我再问两个关于埃隆和推特的戏剧性问题，把这些先处理掉。第一，你说你被解雇了。我不确定你是否公开分享过这件事。我想人们一直很好奇发生了什么。我知道你在陪产假期间发推说“我要离开推特了”，但据我所知，没人真正知道背后的故事。当时到底发生了什么？

---

### [00:11:53] Kayvon Beykpour

**English:**
It was weird, to say the least. Honestly, it took me some time to come to peace with it because it was frustrating and surprising. I guess the story of what happened starts with Jack resigning. Jack resigned in ... It was like November of 2021 at the end of the year. The board chose Parag to be the CEO of the company, and I've had a long relationship with Parag. I respect him, but I had mixed feelings about that.

**中文翻译:**
说得委婉点，那感觉很诡异。老实说，我花了一些时间才释怀，因为那既令人沮丧又出人意料。我想故事要从杰克（Jack Dorsey）辞职说起。杰克是在 2021 年 11 月底辞职的。董事会选择了 Parag 担任公司 CEO。我和 Parag 认识很久了，我很尊敬他，但我对此心情复杂。

---

### [00:12:23] Kayvon Beykpour

**English:**
To his credit, Parag very quickly addressed one of the biggest things that I was really frustrated about in the last three years essentially of my time at Twitter. One of my biggest points of feedback and points of consternation was the structure of the company in that we had a functional organizational model, meaning we had a head of consumer product, me, we had a head of revenue product, Bruce, we had a head of engineering, we had a head of design, we had head research. It was a functionally run organization.

**中文翻译:**
值得称赞的是，Parag 很快解决了我过去三年在推特最感到沮丧的一件事。我最大的反馈点和困扰点之一就是公司的架构——我们当时采用的是职能型组织模型（functional organizational model），这意味着我们有消费者产品负责人（我）、营收产品负责人（Bruce）、工程负责人、设计负责人、研究负责人。这是一个按职能运行的组织。

---

### [00:12:52] Kayvon Beykpour

**English:**
And the combination of that model and the type of leader that Jack was wasn't working in my view. I think if you're going to have a functional organization, you need to have a GM or a CEO who's extremely leaned-in to tiebreak and resolve conflict and make sure the team is moving quickly. And Jack, for all of his amazing qualities, just wasn't operating that way, and so you had a group of highly opinionated people that often disagreed and would create either the need for consensus or deadlock. That just was driving a lot of people crazy, including me, and I think it really held us back from living up to Twitter's potential.

**中文翻译:**
在我看来，这种模式加上杰克那种类型的领导者是行不通的。我认为，如果你要建立一个职能型组织，你需要一个非常投入的总经理或 CEO 来进行裁决、解决冲突并确保团队快速行动。而杰克尽管有很多优秀的品质，但他并不是那样运作的。所以你有一群非常有主见的人，他们经常意见不一，要么需要达成共识，要么陷入僵局。这让很多人抓狂，包括我，我认为这真的阻碍了推特发挥其潜力。

---

### [00:13:29] Kayvon Beykpour

**English:**
Anyway, all of that was super frustrating for me, and the combination of that and a dramatic change in leadership with Jack leaving and Parag coming in, I wasn't feeling too stoked. Parag to his credit, when he became CEO, quickly changed that and shifted the company to be a GM structure. And he promoted me to being the GM of consumers. So, for the prior three-ish years, having been responsible for growing Twitter's consumer product, I was only responsible for the product management team. I didn't have engineering or design, and that honestly was difficult. It's very difficult to change culture with one hand tied behind your back.

**中文翻译:**
总之，所有这些都让我超级沮丧。再加上杰克离开、Parag 上任带来的领导层剧变，我当时并不怎么兴奋。Parag 值得称赞的地方在于，他当上 CEO 后很快改变了现状，将公司转向了总经理（GM）架构。他提拔我担任消费者业务总经理。在此之前的三年左右时间里，虽然我负责推特消费者产品的增长，但我只管产品管理团队，我没有工程或设计的管辖权。老实说，这很难。当你的一只手被绑在背后时，很难改变文化。

---

### [00:14:10] Kayvon Beykpour

**English:**
Still no regrets. Had a lot of fun. I think we had some impact, but it was frustrating. So, Parag changed that. The irony of this, by the way, is he was one of the biggest proponents of the functional structure. When he became a CEO, he changed the structure, promoted me to be the GM of consumer, and I was, at that point, one month ... This is one month before I went on pat leave because my daughter was due.

**中文翻译:**
但我依然不后悔，玩得很开心。我觉得我们产生了一些影响，但过程很令人沮丧。所以 Parag 改变了这一点。顺便说一下，讽刺的是，他曾是职能架构最大的支持者之一。当他成为 CEO 后，他改变了架构，提拔我为消费者业务总经理。而那时，距离我休陪产假（因为我女儿要出生了）还有一个多月。

---

### [00:14:35] Kayvon Beykpour

**English:**
So, I went into my paternity leave being like, "All right, I'm going to give this a shot. We'll see. We'll see how this goes," as Parag addressed the biggest frustration that I had with the company and how it was being run. So, I had some trepidations but went into my pat leave feeling optimistic. Mind you, this was all before Elon was even part of the picture. He had not become a board member. There was no news about him having beef with the executive team or for that matter, trying to buy the company.

**中文翻译:**
所以我开始休陪产假时想：“好吧，我要试一试。看看情况如何。”因为 Parag 解决了我对公司及其运作方式最大的不满。虽然我有些忐忑，但开始休假时还是感到乐观的。请记住，这都是在埃隆出现之前。他还没成为董事会成员，也没有关于他与管理层不和，或者他想买下公司的消息。

---

### [00:15:06] Kayvon Beykpour

**English:**
So, I went on pat leave maybe a week and a half before our daughter's due date. Three weeks goes by. In that three weeks, Elon joins the board, leaves the board, makes an offer, has a short dramatic feud about whether that goes through. And also during that time, my daughter was born. Some drama at the hospital for us, but a week afterwards, we come home. Mom's healthy. Daughter's healthy.

**中文翻译:**
我在女儿预产期前大约一周半开始休假。三周过去了。在那三周里，埃隆加入了董事会，退出了董事会，发出了收购要约，并就收购是否能通过发生了一场短暂而戏剧性的争执。也就是在那段时间，我女儿出生了。我们在医院经历了一些波折，但一周后我们回家了。妈妈很健康，女儿也很健康。

---

### [00:15:35] Kayvon Beykpour

**English:**
The day after we get home from the hospital, Parag called me and said that he was letting me go and that he was taking the team in a different direction. That night, Twitter signed a term sheet with Elon to sell the company. So, a lot happened in a very short period of time, and the reason that Parag gave is exactly what I shared publicly, which was that he wanted to take the team in a different direction. The only other thing he said is that given that new direction, he thinks that the things that I'm good at, Twitter doesn't need anymore. And the things that Twitter needs are not particularly in my skill set or in my interest.

**中文翻译:**
就在我们从医院回家的第二天，Parag 给我打电话说他要解雇我，他要带领团队走向不同的方向。那天晚上，推特与埃隆签署了出售公司的条款清单。所以，在极短的时间内发生了很多事情。Parag 给出的理由正是我公开分享的：他想带团队走不同的方向。他唯一说的另一件事是，鉴于这个新方向，他认为我擅长的事情推特不再需要了，而推特需要的东西并不在我的技能范围或兴趣之内。

---

### [00:16:14] Kayvon Beykpour

**English:**
He wasn't particularly expressive about what that direction was, but that was the reason he gave me. That was a huge bummer for me for a bunch of reasons. One, I love the company. I love the product, and also it just sucks to leave not on your own terms. And two, I was just confused. The timing was very frustrating and confusing for me, not least of which because I had just come home from the hospital while on paternity leave. But also because at that time, especially the fact that Elon was buying the company was ...

**中文翻译:**
他并没有特别明确地说明那个方向是什么，但这就是他给我的理由。出于多种原因，这对我来说是一个巨大的打击。第一，我热爱这家公司，热爱这款产品，而且非自愿离开的感觉真的很糟糕。第二，我很困惑。这个时机让我非常沮丧和困惑，不仅是因为我刚休着陪产假从医院回家，还因为当时埃隆正在买下公司这件事……

---

### [00:16:48] Kayvon Beykpour

**English:**
Well, I was conflicted, honestly. I was very excited because Elon is someone that I looked up to immensely, and you just look at the things that he's achieved in the world and you can't help but be inspired by that. And two, Twitter for all of, I think, the impact and progress that we had made, had a lot of challenges associated with its governance and the fact that it was constantly vulnerable as a public company. So, there's just always this drama associated with Twitter as a public company, even a private company before that, that made it extremely hard as a builder to get shit done and have the product live up to its potential.

**中文翻译:**
老实说，我当时很矛盾。一方面我很兴奋，因为埃隆是我非常仰慕的人，你看看他在世界上取得的成就，很难不受到启发。另一方面，尽管我认为推特取得了一些影响和进步，但它在治理方面面临很多挑战，而且作为一家上市公司，它一直很脆弱。作为一家上市公司（甚至在那之前的私营公司时期），推特总是伴随着各种闹剧，这让开发者极难专心做事，也很难让产品发挥出应有的潜力。

---

### [00:17:27] Kayvon Beykpour

**English:**
One of the benefits of this particular takeover was that Elon offered a path towards solving all of that. It was like, "Oh, cool, now you've got one owner who happens to be, by the way, extremely opinionated about the product and a voracious consumer and creator of the product." I think there was an incredible opportunity in that that now you have this organization and this product and this incredible ecosystem that can be devoid of all the political bullshit associated with being a public company. Now, it has this conduit to just living up to its potential.

**中文翻译:**
这次收购的一个好处是，埃隆提供了一条解决所有这些问题的途径。就像是：“噢，太酷了，现在你有一个老板，而且他恰好对产品非常有见地，还是产品的狂热用户和创作者。”我认为这是一个难得的机会，现在你拥有了这个组织、这个产品和这个不可思议的生态系统，可以摆脱所有与上市公司相关的政治废话。现在，它有了一个直接发挥潜力的渠道。

---

### [00:17:59] Kayvon Beykpour

**English:**
So, it was a bummer to be removed from that, I suppose, without having any agency myself. That was very a long-winded answer to your question, but that's what happened towards the end there. Like I said at the beginning, it took me a while to come to terms with it and to be at peace with it. I did eventually. Listen, there's a huge silver lining of I spent the first year of my daughter's life with her and my family. My wife Sarah had left Twitter eight months prior to me leaving, and so when's the next time we could all be together and have time and space to just enjoy each other and our new family, and frankly, to avoid a lot of the drama that ended up ensuing that not a lot of people could have predicted? The deal was on. The deal was off. It is just a whole lot of drama that I got to miss, which is the silver lining.

**中文翻译:**
所以，在没有任何自主权的情况下被踢出局，确实很令人沮丧。这回答有点长，但这就是最后发生的事情。正如我开头所说，我花了一段时间才接受并释怀。我最终做到了。听着，这件事有一个巨大的因祸得福之处：我陪女儿度过了她生命的第一年。我妻子 Sarah 在我离开前八个月就离开了推特，所以我们什么时候才能再次聚在一起，有时间和空间享受彼此和我们的新家庭？坦率地说，这还让我避开了后来发生的许多没人能预料到的闹剧。交易一会儿成，一会儿不成。我错过了那一大堆闹剧，这就是不幸中的万幸。

---

### [00:18:53] Kayvon Beykpour

**English:**
Then it was confusing there for a bit because when Elon did end up buying the company, in that conversation that I had with him, it was definitely ... I was conflicted about do I want to maybe spend some time working on this still? Elon was very cool about ... He actually used this phrase at the end of our conversation, which I still find hilarious. He was just like, "Do you want to just come? You seem like you care about the product, and you don't have dumb ideas. Do you want to come hang out?" And I was like, "What would my job be?" And he was like, "Don't know, just hang out, and you can swipe left or swipe right." He used the swipe right, swipe left Tinder metaphor, and I thought that was hilarious coming from him.

**中文翻译:**
后来有一阵子挺让人困惑的，因为当埃隆最终买下公司时，在我和他的那次谈话中，我确实很矛盾：我是否还想花时间在这上面工作？埃隆人很酷……他在谈话结束时用了一个词，我现在想起来还觉得好笑。他直接说：“你想过来吗？你看起来很在乎产品，而且你没什么蠢主意。你想过来一起玩吗？”我问：“我的工作是什么？”他说：“不知道，就一起玩，你可以‘左滑’或‘右滑’。”他用了 Tinder 的左滑右滑隐喻，我觉得从他嘴里说出来特别搞笑。

---

### [00:19:38] Lenny Rachitsky

**English:**
For ideas that come up just like, "Here, I have this idea [inaudible 00:19:41]?

**中文翻译:**
是针对冒出来的想法说：“嘿，我有个主意”那种吗？

---

### [00:19:40] Kayvon Beykpour

**English:**
No, like swipe right on whether you want to be here or swipe ... He's like, "We don't have to make this a thing. Just do you want to hang out and work on the product with us?"

**中文翻译:**
不，是针对“你是否想待在这里”进行右滑……他说：“我们不必把它搞得太正式。你只想和我们一起玩、一起做产品吗？”

---

### [00:19:40] Lenny Rachitsky

**English:**
That's so funny.

**中文翻译:**
太有意思了。

---

### [00:19:51] Kayvon Beykpour

**English:**
So, I ended up deciding that actually, I'm just ready. I'm ready to move on. I spent enough time at this company, at this product trying to shape it into something that I was passionate about. I think it's someone else's turn, and especially Elon. If you buy it's your turn. You can do whatever you want with it.

**中文翻译:**
所以我最终决定，实际上我已经准备好了。我准备好向前看了。我在这个公司、这个产品上花了足够多的时间，试图把它塑造成我热爱的东西。我想该轮到别人了，尤其是埃隆。既然你买了它，那就是你的轮次了，你可以随心所欲。

---

### [00:20:13] Kayvon Beykpour

**English:**
So, that was conflicting for a bit, but I would say towards the end of the year, it was pretty clear in my mind that I was ready to move on and start thinking about other problems.

**中文翻译:**
所以，虽然纠结了一阵子，但到了年底，我心里已经很清楚，我准备好离开了，去思考其他问题。

---

### [00:20:23] Lenny Rachitsky

**English:**
What I think about is there's always this tension being a PM at a company with a very strong-minded, product-oriented founder, and I feel like you would've been in the epitome worst possible situation there, where you're a product leader between Elon and the rest of org. So, I think it probably would not have worked out.

**中文翻译:**
我在想，在一家拥有极强主见、以产品为导向的创始人的公司当 PM，总是存在这种张力。我觉得你当时可能会处于最糟糕的境地：作为一个产品领导者，夹在埃隆和组织其他成员之间。所以，我觉得那可能行不通。

---

### [00:20:40] Kayvon Beykpour

**English:**
I'm not sure I would've been able to articulate it as succinctly as you did just now, but I think that is the feeling that I had that it's not my place anymore. I don't have a canvas to try and exert my dreams on this place. I think Elon took that mantle, and I'm excited to see what he going to do with it is the feeling I had.

**中文翻译:**
我不确定我能不能像你刚才说得那么简洁，但我当时的感觉确实是：那里已经没有我的位置了。我不再拥有在那块画布上施展梦想的机会。我觉得埃隆接过了那个重任，我很期待看到他会怎么做。

---

### [00:21:07] Lenny Rachitsky

**English:**
Yeah. You've touched on this. You're known for at Twitter someone that turned the culture of the product team and Twitter in general from a very stagnant, nothing-is-changing product to shipping all the time, all kinds of stuff. So, here's a list of stuff that I've gathered your team shipped while you were there. Twitter Blue, which is I think called Premium now, Spaces, Super Follows, Communities, newsletters, topics, fleets, being able to see Instagram photos in line, testing reactions, edge-to-edge photos, tons of UX improvements, and obviously, live video. What did you learn about how to change a product culture from a company that's very risk-averse and essentially just not shipping a lot to taking big, bold bets and becoming a lot more open to new stuff?

**中文翻译:**
是的。你提到过这一点。你在推特以改变产品团队文化而闻名，把推特从一个停滞不前、毫无变化的产品变成了不断发布各种新功能的产品。这是我收集的你任职期间团队发布的东西：Twitter Blue（现在好像叫 Premium）、Spaces、超级关注、社群、时事通讯、话题、Fleets、在流内查看 Instagram 照片、表情回应测试、无边框照片、大量的 UX 改进，当然还有直播视频。关于如何改变一个非常厌恶风险、基本不发布新功能的产品文化，转而采取大胆尝试并对新事物更加开放，你学到了什么？

---

### [00:21:53] Kayvon Beykpour

**English:**
Trying to drive culture change is both one of the most challenging things and rewarding things. For the first year of my role ... There was a chapter of my time at Twitter, maybe just to backup, that was just leading Periscope. In that first chapter of maybe two years, I was not really involved with Twitter stuff all that much. That started to change when we really tried integrating Periscope with Twitter, but chapter two of my time at Twitter was when I became the head of product. That first year of being the head of product was one of the most difficult of my career not because the work was difficult, but because it was so politically and bureaucratically exhausting to try and change culture in a way that just there wasn't alignment around.

**中文翻译:**
试图推动文化变革既是最具挑战性的事情之一，也是最有成就感的事情之一。在我任职的第一年……回顾一下我在推特的时光，第一章只是领导 Periscope。在最初的大约两年里，我并没有真正参与推特的核心事务。当我们开始尝试将 Periscope 与推特整合时，情况开始发生变化。而我在推特的第二章是我成为产品负责人。担任产品负责人的第一年是我职业生涯中最艰难的一年，不是因为工作本身难，而是因为在没有达成共识的情况下试图改变文化，在政治和官僚层面上让人精疲力竭。

---

### [00:22:40] Kayvon Beykpour

**English:**
It comes back to the point I was making earlier around the organization of the company was functional, and so it is one thing for me to have some ideas and a plan and a strategy that I felt compelling. But when you have to essentially drive consensus amongst your peers across the other functions, that's a different game. That's not execution. That's politics and consensus building. I both can't stand that stuff, but I think ... This is going to sound like I'm tooting my own horn, but good enough at it and I have enough patience at it that I invested the time and the energy. I think a less patient person wouldn't have bothered and would've thrown their hands up.

**中文翻译:**
这又回到了我之前提到的点：公司的组织架构是职能型的。我有想法、有计划、有我认为引人注目的战略，这是一回事；但当你必须在其他职能部门的同事之间达成共识时，那就是另一场游戏了。那不是执行，那是政治和共识构建。我既受不了这些东西，但我想……这听起来像是在自夸，但我在这方面做得还行，而且我有足够的耐心去投入时间和精力。我想一个没那么耐心的人可能根本不会费这个劲，早就撒手不管了。

---

### [00:23:25] Kayvon Beykpour

**English:**
I think honestly, a lot of it just comes down to I had practice. At my first company that I started in college with one of my best friends, Joe, who I ended up co-founding Periscope with, we got acquired by a big, public, ad tech company called Blackboard, and we were 19 at the time. We got thrown into a public ... I was a senior executive at a public company that was not your quintessential tech company. It was even more difficult to get things done. So, through the four years I spent there, I learned a lot about how to navigate that type of environment.

**中文翻译:**
老实说，我认为很大程度上归功于我有过实践。我在大学时和好友 Joe（后来也是 Periscope 的联合创始人）创办了第一家公司，后来被一家名为 Blackboard 的大型上市广告技术公司收购，当时我们才 19 岁。我被扔进了一家上市公司……我成了一家并非典型科技公司的上市企业的高管。在那里办事甚至更难。所以在那里的四年里，我学到了很多关于如何在这种环境中周旋的经验。

---

### [00:23:56] Kayvon Beykpour

**English:**
It all came coming back when I was given the product role at Twitter. That first year of changing culture was like-

**中文翻译:**
当我被任命为推特的产品负责人时，这些经验都派上了用场。改变文化的第一年就像是——

---

### [00:24:00] Kayvon Beykpour

**English:**
... product role at Twitter. That first year of changing culture was like walking through mud, and it was really difficult. But I think when we started building that alignment and building excitement that like, oh, actually maybe we should be taking some bigger swings, and when we started seeing through the execution against some of those plans, I think it ended up, it got easier and easier. It becomes addicting. I think people end up feeling like, oh wow, maybe these sacred cows we had didn't need to be so sacred.

**中文翻译:**
……在推特担任产品角色的第一年。改变文化的第一年就像在泥泞中行走，非常困难。但我想，当我们开始建立共识，并激发起大家的兴奋感，让大家觉得“噢，也许我们真的应该做一些大胆的尝试（bigger swings）”时，当我们开始看到这些计划被执行时，事情变得越来越容易。这会让人上瘾。我想人们最终会觉得，哇，也许我们拥有的这些“神圣禁忌”其实并没那么神圣。

---

### [00:24:37] Kayvon Beykpour

**English:**
And so I think after that first year, it became a lot more fun. It was still difficult, but it felt like we were all swimming in the same direction a lot more. But I think my takeaway there is you can't change culture without having alignment from the top. It's difficult to change culture when you have a pocket of a company trying to advocate for change.

**中文翻译:**
所以我想在第一年之后，事情变得有趣多了。虽然依然困难，但感觉大家更多是在朝着同一个方向努力。我的感悟是，如果没有高层的支持，你无法改变文化。当公司只有一小部分人在倡导变革时，很难改变整体文化。

---

### [00:25:01] Kayvon Beykpour

**English:**
So I think we got there in the end. We didn't move as much urgency as I think we drove. We were not fast enough, we were not bold enough. I was consistently dissatisfied with what I was achieving and what our team was achieving. But I think we did make a change. Twitter was an organization that had a lot of sacred cows and became very [inaudible 00:25:24] in its ways. Literally the first two years I was at the company, the stated product strategy for Twitter was refine the core. It was like, we're not making any big bets here, team. Our goal is to keep turning the knobs that are working.

**中文翻译:**
所以我认为我们最终做到了。虽然我们的紧迫感没有我想象中那么强，我们不够快，也不够大胆。我一直对自己和团队取得的成就感到不满意。但我认为我们确实做出了改变。推特曾是一个有很多“神圣禁忌”且行事风格非常僵化的组织。字面上看，我进公司的前两年，推特明确的产品战略是“优化核心”（refine the core）。就像是在说：“团队，我们在这里不做任何大的赌注。我们的目标是继续微调那些已经在起作用的功能。”

---

### [00:25:42] Kayvon Beykpour

**English:**
And listen, as much as I was kind of throwing stones from the sidelines through that period when I was in Periscope land in our separate office a few blocks away from the mothership, that focus actually did help the company for some period. The reason why Twitter went from stagnant to declining DAU growth to growing DAU again is because they refined the core. This is when they went from the reverse chronological timeline to the ranked timeline, and the year after that was a lot of knob turning. It was like, how do we make these recommendations better? How do we make our push notifications more relevant?

**中文翻译:**
听着，尽管在那段时间里，我在距离总部几个街区外的 Periscope 办公室里冷嘲热讽，但那种专注确实在一段时间内帮助了公司。推特之所以能从停滞不前、日活（DAU）增长下滑转变为日活再次增长，就是因为他们优化了核心。也就是在那时，他们从按时间倒序的排列方式转变为算法排序，之后的一年里做了大量的微调。比如：我们如何让推荐更好？如何让推送通知更相关？

---

### [00:26:16] Kayvon Beykpour

**English:**
Now, that is not an inspiring product strategy. That does not result in the product feeling materially different or adding new capabilities, but it did return the company to user growth. And I think that the fact that it did actually calcified the organization's reticence to take any risky bets even more. So it was a very interesting predicament because when I got into the role, the goal wasn't to change that progress. We wanted to continue reaping the benefits of refining the things about the product that were working really well. What we wanted to change was a lack of ambition, the lack of creativity, the lack of customers feeling that the product was changed at all.

**中文翻译:**
虽然那不是一个令人振奋的产品战略，也不会让产品感觉有实质性的不同或增加新功能，但它确实让公司恢复了用户增长。我认为，正是因为这种做法奏效了，反而让组织更加不敢进行任何风险投资。所以这是一个非常有趣的困境，因为当我接手这个角色时，目标并不是要改变这种进步。我们希望继续从优化那些运作良好的功能中获益。我们想要改变的是缺乏雄心、缺乏创造力，以及客户觉得产品毫无变化的状态。

---

### [00:26:58] Kayvon Beykpour

**English:**
Because you would hear people, I mean, one of the beautiful things about working on Twitter as a product is that you have literally customers being injected into your veins. Every single day, whatever you change about a product or whatever you don't change, they're telling you what they love and what they hate. And it is both exhausting and exhilarating. It is one of the most ridiculous luxuries of product development, is working on a product that many people use and therefore you get that much feedback around.

**中文翻译:**
因为你会听到人们的声音。我是说，开发推特这款产品最美妙的事情之一就是，客户的声音简直是直接注入你的静脉。每一天，无论你对产品做了什么改变或者没做什么改变，他们都会告诉你他们喜欢什么、讨厌什么。这既让人精疲力竭，又让人兴奋不已。这是产品开发中最奢侈的事情之一：开发一款有这么多人使用的产品，并因此获得海量的反馈。

---

### [00:27:25] Kayvon Beykpour

**English:**
And it was a very common thing for us to hear people say, "What are you all doing over there? The product hasn't changed in eight years." And that was horrible to hear, and I felt it too, as a critic on the sidelines, as a user who wasn't an employee who eventually became an employee, I had the same feedback. And so that was my mission. I was like, I am somehow ridiculously in this fortunate position that I've been entrusted some responsibility here. I might flame out completely, but hell if I don't try. And so that was both fun and exhausting, like I said.

**中文翻译:**
我们经常听到人们说：“你们在那儿忙什么呢？这产品八年都没变过了。”听起来很糟糕，而且我也感同身受。作为一个旁观的批评者，作为一个后来成为员工的用户，我也有同样的反馈。所以这就是我的使命。我想，我竟然如此幸运地被委以重任。我可能会彻底失败，但如果不试一下，我肯定会后悔。所以就像我说的，这既有趣又累人。

---

### [00:28:00] Kayvon Beykpour

**English:**
But it was as simple as starting with we are voracious users of the product ourselves, and if we aren't, by the way, that's its own problem. I think that in order to build something wonderful, you have to be a customer of the product. And sure, I'm sure you could point to businesses and products where that's not the case, and I'm sure there's a flaw in that philosophy somewhere, but I've always believed that one of the best ways to build products is to be a customer yourself and to find your own pain points and to build a product that you want to use. And so that's actually not that hard to do if you're a user of Twitter and you can think critically. It was ripe with opportunity. And so it was actually really fun and amazing to be able to craft a plan that started to take a swing at some of these things.

**中文翻译:**
但这其实很简单，首先我们自己就是产品的狂热用户。顺便说一下，如果我们不是，那本身就是个问题。我认为为了打造出色的东西，你必须是产品的客户。当然，我确信你能举出反例，而且这种哲学肯定有缺陷，但我一直相信，开发产品最好的方法之一就是自己成为客户，找到自己的痛点，并开发出一款你自己想用的产品。如果你是推特用户并且能批判性地思考，这其实并不难。到处都是机会。所以，能够制定一个计划并开始尝试解决这些问题，真的很有趣也很奇妙。

---

### [00:28:50] Kayvon Beykpour

**English:**
And the other thing I'll add to this is that there were so many sacred cows at Twitter that the sacred cows are their own roadmap. It's like a built-in free roadmap of like, all right, what are all the things that you think we're not allowed to change? Let's start there. Everything from moving from reverse chron to a ranked feed, that was a sacred cow. Text and 140 characters, that's a sacred cow. Not letting anyone control any tweets that they see on the platform. The notion of Lenny owning his reply space was anathema at Twitter.

**中文翻译:**
我还想补充一点，推特有太多的“神圣禁忌”，以至于这些禁忌本身就是一份路线图。就像是一份内置的免费路线图：好吧，哪些是你认为我们不能改动的？我们就从那里开始。从时间倒序改为算法排序，这是一个禁忌。140 个字符限制，这是一个禁忌。不让任何人控制他们在平台上看到的推文。在推特，“Lenny 拥有他自己的回复空间”这种想法简直是离经叛道。

---

### [00:29:21] Kayvon Beykpour

**English:**
It's just like if a tweet gets, if you get an at mention and you don't like it or it's abusive, we're not touching that. We can't annotate tweets with [inaudible 00:29:30], all that stuff, those are all sacred cows. And the process of starting to address those one by one reveals a lot of the cultural hesitations that existed.

**中文翻译:**
就像如果有一条推文艾特了你，你不喜欢或者那是辱骂性的，我们也不会去管。我们不能给推文加注释，所有这些都是禁忌。而开始逐一解决这些问题的过程，揭示了当时存在的许多文化上的迟疑。

---

### [00:29:43] Kayvon Beykpour

**English:**
So yeah, I'll never forget one of the first features, and this is such a tiny feature that we worked on after I started the role, we were building this feature called hide replies. It still exists in the product today. If someone replies to one of your tweets, in the tweet details area as a reply to one of your conversations, before you had no ability, the only way you could address unwanted content was reporting it. So that was like Twitter acting as policemen and policewoman, completely unscalable and challenging, especially in the context of someone replying to one of your tweets.

**中文翻译:**
是的，我永远不会忘记我上任后开发的首批功能之一，这是一个非常小的功能，叫“隐藏回复”（hide replies）。它现在还存在于产品中。如果有人回复了你的推文，在推文详情页的对话回复区，以前你没有任何处理能力，处理不想要内容的唯一方法就是举报。那就像是推特在充当警察，这完全无法规模化，而且极具挑战性，尤其是在有人回复你推文的情况下。

---

### [00:30:18] Kayvon Beykpour

**English:**
And so we wanted to add a feature that let you hide a reply to one of your tweets, and it's not impacting what people say. It's not impacting free speech in the sense of you can still broadcast whatever you want, but if you're going to come into my reply space and say some shit that I don't want to see in my feed, I should be able to hide that. Tweet what you want, but don't at mention. You can't scream in my face basically.

**中文翻译:**
所以我们想增加一个功能，让你能隐藏对自己推文的回复。这并不影响人们说什么，也不影响言论自由，因为你仍然可以广播任何你想说的内容。但如果你跑到我的回复空间说一些我不想在信息流里看到的东西，我应该能把它藏起来。你想发什么推文随你，但别艾特我。基本上就是，你不能对着我的脸尖叫。

---

### [00:30:40] Kayvon Beykpour

**English:**
And I remember we had a PM on our team who was leading this feature who a few weeks into this project mentioned to me that she had had a conversation with someone on the engineering team that told them, "Don't work on this feature. This is bad for your career. This is not going to launch, and you don't want to work on this. You don't want to be seen as having worked on this." Because it was so kind of anathema to we can't let people hide replies to their tweets. And I just remember hearing that and my blood was boiling. That is the most, it was such an interesting representation of the culture, not just hesitation to try new things, which by the way, that product might've failed. And that's fine, but it doesn't mean you shouldn't try.

**中文翻译:**
我记得我们团队里有一位负责这个功能的 PM，在项目开始几周后她告诉我，她和工程团队的一个人聊过，那人对她说：“别做这个功能。这对你的职业生涯不利。这东西发布不了，你不会想做这个的。你不想让人看到你做过这个。”因为“让人们隐藏回复”在当时太离经叛道了。我记得听到这话时我气得血往上涌。那是当时文化最典型、最有趣的体现——不仅仅是犹豫要不要尝试新事物（顺便说一下，那个产品可能会失败，这没关系，但不代表你不该尝试）。

---

### [00:31:27] Kayvon Beykpour

**English:**
But to go so far as to dissuade someone else who was excited about experimenting with a hypothesis to see if it could help customers on the platform and telling them, "Don't work on this. It's bad for your career." As a microcosm for some of the cultural challenge we had around trying big, bold bets, which by the way, this wasn't even a big, bold bet. It was such an innocuous thing to try. But there was a lot of that and it made it very difficult without some sheer force of will and also just a lot of effort. So there was a lot of that.

**中文翻译:**
竟然到了去劝阻一个对实验假设充满热情、想看看能否帮助平台客户的人，并告诉她“别做这个，对职业生涯不好”。这是我们当时在尝试大胆博弈时面临的文化挑战的一个缩影。顺便说一下，这甚至算不上什么大胆博弈，只是一个无伤大雅的尝试。但当时这种事很多，如果没有强大的意志力和大量的努力，事情会变得非常困难。

---

### [00:32:01] Lenny Rachitsky

**English:**
Kayvon, there's fractals of stories that I could infinitely follow. There's so much interesting stuff here. One that just stands out is this idea of the sacred cows become your future roadmap. It's like flipping it from here's the thing that we're all afraid of. No, this is not what we should be doing. I think that's really interesting and could be a lesson to people.

**中文翻译:**
Kayvon，这里有太多我可以无限挖掘的故事碎片了。其中最突出的一点是“神圣禁忌成为你未来的路线图”。这就像是把“这是我们都害怕的东西”反转过来，变成“不，这正是我们该做的”。我觉得这非常有趣，可以给人们带来启发。

---

### [00:32:20] Lenny Rachitsky

**English:**
The other is just, I love this point you made about the growth was most accelerant when you're just focusing on the core, that's what actually ... Like optimize, people bash on optimizing the existing experience and just micro-optimizing, improving, versus trying to take all these big, bold bets and experiments. Obviously, that's also valuable. But I think it's really interesting that that's what reignited growth and was responsible for growth for a while.

**中文翻译:**
另一点是，我很喜欢你提到的：当你专注于核心产品时，增长是最快的。人们常抨击“优化现有体验”或“微调改进”，而推崇“大胆博弈和实验”。显然，后者也有价值。但我认为很有趣的是，正是前者重新点燃了增长，并在一段时间内对增长负责。

---

### [00:32:44] Kayvon Beykpour

**English:**
And continue to be, by the way. One of the lines that we had to maneuver was creating a portfolio of bets where some of them were not speculative at all. We knew that if we continue to invest in ML and getting better with recommendations in the main feed and through notifications and things like improving the onboarding flow, it was rife with opportunity.

**中文翻译:**
顺便说一下，现在依然如此。我们必须权衡的一点是创建一个“博弈组合”，其中一些完全不是投机性的。我们知道，如果我们继续投资机器学习（ML），改进主信息流和通知中的推荐，以及优化新用户引导流程（onboarding flow），那里充满了机会。

---

### [00:33:12] Kayvon Beykpour

**English:**
You'd have really dumb things happen. We would learn. There was one just bizarre and incredible meeting we had where we finally had got more rigorous around instrumenting our onboarding flow. And we found that in a couple countries, like we had a bug with our SMS verification flow where we wanted to verify users who were signing up with a phone number and our telco integration to send SMS verification cards just wasn't working. And so a huge percentage of people signing up in the UAE and other countries just couldn't use Twitter.

**中文翻译:**
你会遇到一些非常愚蠢的事情。我们会从中学习。有一次非常离奇且不可思议的会议，我们终于对引导流程进行了更严格的监测。结果发现，在几个国家，我们的短信验证流程有个 Bug。我们想验证用手机号注册的用户，但我们与电信运营商发送验证码的集成根本不工作。所以阿联酋和其他国家很大一部分注册用户根本没法用推特。

---

### [00:33:46] Kayvon Beykpour

**English:**
And so of course at the scale that we were operating in with hundreds of millions of users, you need to be able to refine the basic building blocks of the product, and that's going to lead to reliable growth. But we wanted to balance that with a portfolio of other bets and product improvements that would materially add new capabilities. And that was a balance that I don't think existed. And by the way, I don't think we nailed it either under my tenure, but it was the driving force of what I wanted to achieve, was to create a better balance that would result in evolving the product and introducing new capabilities. And so that's what we tried to do.

**中文翻译:**
所以，在我们这种拥有数亿用户的规模下，你必须能够优化产品的基本构建模块，这会带来可靠的增长。但我们希望将其与一系列能实质性增加新功能的其他博弈和产品改进相平衡。我认为那种平衡以前并不存在。顺便说一下，我不认为我在任期间完美解决了这个问题，但那是我想要实现的驱动力：创造更好的平衡，从而推动产品进化并引入新功能。这就是我们尝试做的。

---

### [00:34:28] Lenny Rachitsky

**English:**
In terms of what actually helped turn things around, things that I kind of gathered from what you shared so far, one is just building a little momentum, having some quick wins of new products that people start to get excited about. So creating more excitement down the, oh wow, we can actually try new things. There's also, it felt like there's a sense of trust that you built with Jack and execs of just like, okay, we can actually trust this team.

**中文翻译:**
关于到底是什么帮助扭转了局面，根据你目前的分享，我总结了几点：一是建立势头，通过新产品获得一些“快速胜利”（quick wins），让人们开始感到兴奋。从而创造出一种“哇，我们真的可以尝试新事物”的氛围。还有一点，感觉你与杰克和高层之间建立了一种信任感，让他们觉得“好吧，我们真的可以信任这个团队”。

---

### [00:34:47] Lenny Rachitsky

**English:**
Also, it feels like because growth started up, there's probably a sense of like, okay, we can try some new crazy ideas. It feels like another part of your strategy was [inaudible 00:34:56] hires and bringing in these entrepreneurial folks to take the lead on some of these big ideas. Can you talk about that? Was that something you actively thought about and was that a big part of the impact there?

**中文翻译:**
此外，感觉因为增长开始了，大家可能会觉得“好吧，我们可以尝试一些疯狂的新主意”。感觉你战略的另一部分是人才收购，并引入这些具有创业精神的人来领导一些大想法。你能谈谈这个吗？这是你主动考虑的事情吗？它对结果产生了很大影响吗？

---

### [00:35:07] Kayvon Beykpour

**English:**
Totally. Yeah. So I think a couple things. One, the only thing I'd add to what you said in terms of the ingredients, it was also just storytelling and just repetitive storytelling around this is the vision, these are the bets we're making. Here's why. And you can't just tell that story once. I'm talking internally, by the way. There's a whole other component of this, which is externally how do you tell, especially for a product like Twitter where it's a consumer product that hundreds of millions of people are using, and you have many constituents, you have users, you have advertisers. And so it was very important for us to tell the story of here's what we're doing and why. Here's why you should believe in us. And by the way, give us all your constructive criticism too, because we're listening and we're going to build that into ... So that storytelling was really, really important.

**中文翻译:**
完全正确。我想补充几点。第一，在你提到的那些要素之外，还有“讲故事”，而且是反复讲：这就是愿景，这就是我们要做的博弈，这就是原因。你不能只讲一次。顺便说一下，我指的是对内。还有另一部分是对外：你如何讲述这个故事？尤其是对于推特这样拥有数亿用户的消费级产品，你有许多利益相关者——用户、广告商。所以对我们来说，讲述“我们在做什么以及为什么做”非常重要。告诉大家为什么应该相信我们。顺便说一下，也请给我们建设性的批评，因为我们在倾听，我们会将其融入……所以讲故事真的非常重要。

---

### [00:35:51] Kayvon Beykpour

**English:**
And this is oversimplifying the world, but there's two types of internal team members. There are people who hear that story, who have been a part of the organization who's been slow, or maybe they've been outside the company as a user of Twitter, and they're like, I'd never really want to work there because it doesn't seem like a particularly ambitious product company. And one of two things happens when you hear that story. Either you're inspired and you're like, yeah, we can finally take a swing at making this product better. And maybe I wasn't interested in working in this company before, but I mean, this is an iconic product, and to have an opportunity to reshape it is really exciting. Or again, oversimplified world, but there are people who are very pessimistic and maybe aren't excited by that vision. Let's just stick to what we know works. We're not going to take any big swings. That's a waste of time.

**中文翻译:**
虽然这有点把世界简化了，但内部团队成员大致分为两类。一类人听了那个故事，他们可能曾是那个行动迟缓的组织的一员，或者曾是外部用户，觉得“我不想在那儿工作，因为它看起来不像一家有野心的产品公司”。当你听到那个故事时，会发生两种情况之一：要么你受到启发，觉得“太好了，我们终于可以尝试让产品变得更好，虽然我以前没兴趣在这儿工作，但这是一个标志性的产品，有机会重塑它真的很令人兴奋”；或者（再次简化），有些人非常悲观，对那个愿景不感兴趣，觉得“我们就守着那些行之有效的东西吧，别搞什么大胆尝试，那是浪费时间”。

---

### [00:36:35] Kayvon Beykpour

**English:**
I think one of the really important things about driving cultural change at the leadership level is you've got to identify whether someone's on the wagon or off the wagon and either quickly convince them to get on the wagon or if they're not on the wagon, they shouldn't be there. And that's something that we were terrible at, and we didn't have the organizational structure to be able to enact that.

**中文翻译:**
我认为在领导层推动文化变革的一件非常重要的事情是，你必须识别某人是“在车上”还是“在车下”（即是否认同愿景并愿意为此努力），要么迅速说服他们上车，如果他们不上车，他们就不该待在那里。而这正是我们当时做得非常糟糕的地方，我们没有相应的组织架构来执行这一点。

---

### [00:36:59] Lenny Rachitsky

**English:**
The wagon is they're excited and bought into this vision and want this to happen?

**中文翻译:**
“在车上”是指他们感到兴奋、认同愿景并希望它实现？

---

### [00:37:03] Kayvon Beykpour

**English:**
Correct, and contribute towards it. And off the wagon is like you're not at the company. And we didn't have an organizational structure that could allow for that, nor frankly, the fortitude. I include myself in this. I feel like I've learned a lot about how to make that determination. So I think we were terrible at that. And Elon is the whatever, if that's a spectrum, Elon is the opposite spectrum of that. His tolerance for people who are not aligned and his tolerance for low performance is famously extremely low. And I think it's one of the things that when I say A/B test, it's very interesting to see the extreme to which he has operated.

**中文翻译:**
没错，并且为此做出贡献。“在车下”就是指你不在公司了。我们当时没有允许这种做法的组织架构，坦率地说，也没有那样的魄力。我也包括在内。我觉得我学到了很多关于如何做决定的知识。所以我觉得我们当时做得糟透了。而埃隆，如果这是一个光谱，他就在光谱的另一端。他对不一致的人和低绩效的人的容忍度极低，这是出了名的。我想这就是我所说的“A/B 测试”，看到他运作的极端程度是非常有趣的。

---

### [00:37:37] Kayvon Beykpour

**English:**
And I think I've learned a ton around, we didn't have the organizational structure nor the fortitude to be swifter, and that made cultural change way slower. We still were able to change the culture, not as much as we should have, and certainly not as quickly as we should have or efficiently as we should have. Because by the way, a lot of high performers who are aligned with that desire to change and build, they don't have the, there's not like an equal distribution of patients. If you're extremely talented and you're dealing with organizational shit, you're going to go find someplace else that lets you do your craft and have impact. So it's very difficult.

**中文翻译:**
我学到了很多。我们当时既没有组织架构，也没有魄力去变得更迅速，这使得文化变革慢得多。我们最终还是改变了文化，虽然程度不如预期，速度和效率也不如预期。顺便说一下，许多认同变革和建设愿景的高绩效人才，他们的耐心并不是无限的。如果你极具才华却在处理组织内部的烂事，你会去找另一个能让你施展才华并产生影响的地方。所以这非常困难。

---

### [00:38:16] Kayvon Beykpour

**English:**
But anyway, going to your question, one of the things we found that was a really effective way of accelerating cultural change and also helping drive some of these product initiatives that were particularly speculative was doing small acquires. And really the benefit of that was, A, you bring in a founder type who is an entrepreneur, who drives urgency, who has ambition, who's ideally savvy enough to also work in the context of a large organization, which sometimes is a totally different skillset. I mean, it is a totally different skillset. And a lot of our most ambitious bets that were the riskiest and most misaligned with how the product worked or there was no easy staff to build on top of, a lot of those bets were driven by founders who we basically acquired and said, "Here, you are going to run this."

**中文翻译:**
总之，回到你的问题，我们发现加速文化变革并推动一些投机性产品计划的一个非常有效的方法是进行小型人才收购。这样做的好处是：A，你引入了一个创始人类型的人，他是一个企业家，能带来紧迫感，有雄心，且理想情况下足够精明，能在大型组织背景下工作（这有时是完全不同的技能组合）。我们许多最宏大、风险最高、与产品运作方式最不一致、或者没有现成团队可以依靠的博弈，都是由我们收购来的创始人驱动的，我们直接说：“给你，你来负责这个。”

---

### [00:39:13] Kayvon Beykpour

**English:**
And they believed in it. They were able to rally a team around them, and it's all the attributes of a startup, but with the canvas of a product that hundreds of millions of people use and more resources. So Spaces, Communities, Community Notes, called Birdwatch back then, these were all projects driven by ... Fleets, as well. These were all projects that were run by small teams led by entrepreneurs who we acquired, like Keith Coleman runs Community Notes, last Birdwatch. He actually was my predecessor. We acquired his company so that he could be the head of product. And then when he moved on from that role, he was extremely passionate about this idea of crowdsource moderation and letting people annotate misleading content on the platform without Twitter acting as a policeman.

**中文翻译:**
他们相信这个项目。他们能团结周围的团队，具备创业公司的所有属性，但拥有数亿用户使用的产品画布和更多资源。所以 Spaces、社群、社区笔记（当时叫 Birdwatch）、还有 Fleets，这些项目都是由我们收购来的企业家领导的小团队运行的。比如 Keith Coleman 负责社区笔记，他其实是我的前任。我们收购了他的公司让他担任产品负责人。当他卸任后，他非常热衷于众包审核的想法，让人们在平台上标注误导性内容，而不需要推特充当警察。

---

### [00:40:03] Kayvon Beykpour

**English:**
And that was a very speculative bet that by the way, a lot of people thought, most people thought was a terrible idea. We gave Keith a little silo to go build this vision, and then it was our job to make sure that bet didn't get suffocated in the context of a big organization that would otherwise have not had patience for it.

**中文翻译:**
那是一个非常投机性的博弈，顺便说一下，很多人（甚至大多数人）认为那是个糟糕的主意。我们给了 Keith 一个独立的小空间（silo）去实现这个愿景，我们的工作就是确保这个博弈不会在缺乏耐心的大组织环境中窒息而死。

---

### [00:40:26] Kayvon Beykpour

**English:**
All of the community effort or the creator efforts started with Super Follows and tipping, and all these things were led by Esther Crawford, whose company we acquired and who had her own couple of viral moments with the Elon acquisition. But she's a phenomenal leader who, again, is a perfect example of balancing that entrepreneurial startup muscle with the savviness to be able to get things done at a large organization. Fleets was run by Mo Oladam, who's an entrepreneur, and Communities has gone through a few iterations obviously and still is in the product, but John Barnett and a team of people who we acquired from Chroma Labs.

**中文翻译:**
所有的社群努力或创作者努力，从超级关注和打赏开始，都是由 Esther Crawford 领导的。我们收购了她的公司，她在埃隆收购期间也有过几次走红时刻。她是一位杰出的领导者，再次证明了如何平衡创业公司的冲劲与在大组织中办事的精明。Fleets 由企业家 Mo Oladam 负责，Communities 经历了几次迭代，现在仍在产品中，由我们从 Chroma Labs 收购的 John Barnett 及其团队负责。

---

### [00:41:02] Kayvon Beykpour

**English:**
So I think that that story of acquiring hungry, ambitious founders and giving them responsibility and latitude is a success story of Twitter's. I mean, I'm a beneficiary of such a bet as well. My company Periscope was acquired, and I was given the responsibility to eventually lead the product team. So I feel like that we ended up realizing, both through the company's history and through learning, that this is actually a very effective way to drive cultural change and to deliver impact because you need a special type of person to be able to both operate within the existing structure and change the structure, to know when to use the system and to know when to fuck the system.

**中文翻译:**
所以我认为，收购充满渴望、有雄心的创始人并赋予他们责任和自由度，是推特的一个成功故事。我自己也是这种博弈的受益者。我的公司 Periscope 被收购，我最终被赋予领导产品团队的责任。我觉得我们通过公司的历史和学习意识到，这确实是推动文化变革和产生影响的一种非常有效的方式。因为你需要一种特殊类型的人，既能在现有架构内运作，又能改变架构；既知道何时利用系统，又知道何时去打破系统（fuck the system）。

---

### [00:41:52] Kayvon Beykpour

**English:**
And I feel like my whole life has benefited from other people taking bets on me like that, to the point that even I was like, "Really? You sure you want to?" And so I think I've enjoyed trying to pass the buck and do that for other people, and I've never regretted it. You always, taking a bet on people and especially throwing them in a deep end, which on paper they may be unqualified for, I think is one of the best ways of driving change. And by the way, supporting growth, you've learned so much more when you're thrown into the deep end than in other contexts. And so I think it's fantastic, it's an expensive strategy if you're going to go buy a bunch of companies, but it's a great strategy for the situation that we found ourselves in at Twitter.

**中文翻译:**
我觉得我的一生都受益于别人对我进行这样的博弈，甚至有时我自己都会问：“真的吗？你确定要这么做？”所以我很享受把这种机会传递给别人，我从未后悔过。对人进行博弈，尤其是把他们扔进深水区（即便纸面上看他们可能不够格），我认为是推动变革最好的方式之一。顺便说一下，这也能支持成长，你在深水区学到的东西比在其他任何环境下都多。所以我觉得这很棒。如果你要买一堆公司，这确实是个昂贵的策略，但对于我们在推特所处的境地来说，这是一个伟大的策略。

---

### [00:42:40] Lenny Rachitsky

**English:**
It feels like every big bet was one of these companies from the list that you just shared, and I'm glad you shared Periscope, obviously. That's a great example, too. I guess maybe just a follow-up question here, is there anything you learned about how to do this well? I know you talked about maybe creating a little silo for the team, because so many companies acquire and acquihire and they just go nowhere.

**中文翻译:**
感觉每一个重大的博弈都来自你刚才列举的那些公司，很高兴你提到了 Periscope，那也是个绝佳的例子。我想跟进一个问题：关于如何做好这件事，你学到了什么？我知道你提到了为团队创建一个独立的小空间，因为很多公司进行收购或人才收购后，最后都无疾而终。

---

### [00:42:59] Lenny Rachitsky

**English:**
So I guess just a two-part question, just like what are some tips for how to do this well at a company? And then, two, you also, we were talking offline about this previously and I think it's a really interesting point, that a lot of companies staff based on who's available versus who is right for the role, and let's wait until that person is there for us to bet on this. Can you just talk about lessons there?

**中文翻译:**
所以我有两个问题：第一，在公司里做好这件事有什么秘诀？第二，我们之前私下聊过一个很有趣的点，很多公司是根据“谁有空”而不是“谁合适”来配置人员的，而不是等到合适的人出现再去进行博弈。你能谈谈这方面的教训吗？

---

### [00:43:19] Kayvon Beykpour

**English:**
That last one is a huge pet peeve of mine that I feel like we learned the hard way, and particularly it's a common pattern I think in highly functional organizations where you have different people making decisions on how to staff projects, and there's nothing inherently wrong with that. But I think in the situations, in the situation we found ourselves in where we had this sort of cultural evolution that we were going through where some people just didn't agree with the things that we were prioritizing, they were begrudgingly going along with it, but you would end up in a situation where the combination of that sort of cultural shift and strategy and the fact that the way teams were being staffed was not, there's ultimately no single decision maker other than the CEO and Jack is not going to get in the weeds and debate a staffing decision on the team, resulted in a situation where oftentimes we'd have projects, like the one I mentioned about hiding replies, where there wasn't even an agreement on the team about whether this was a good idea and whether this is worth trying or how to do it.

**中文翻译:**
最后那一点是我非常反感的事情，我觉得我们是付出了惨痛代价才学到的。特别是在高度职能化的组织中，这是一个常见的模式：由不同的人决定如何为项目配置人员，这本身没问题。但在我们当时的情况下，我们正在经历文化演变，有些人根本不认同我们优先考虑的事情，他们只是勉强配合。由于这种文化转变、战略以及人员配置方式的结合，最终除了 CEO 之外没有唯一的决策者，而杰克又不会深入细节去争论团队的人员配置，导致我们经常遇到像“隐藏回复”那样的项目，团队内部甚至对这是否是个好主意、是否值得尝试或如何去做都没有达成共识。

---

### [00:44:22] Kayvon Beykpour

**English:**
And imagine, it's hard enough to build something from nothing. It's even harder if the team doesn't believe in it. This is to the point of just being toxic. The startup would never succeed if all the people who are working on that startup aren't to the point of being perhaps irrational obsessed with that idea. And still willing to see truth, you need to be able to see whether the thing is working or not, but if you don't believe it in the first place, I'm not betting on that succeeding.

**中文翻译:**
想象一下，从无到有地构建一个东西已经够难了，如果团队还不相信它，那就更难了。这甚至会变得有毒。如果创业公司的所有员工没有对那个想法达到近乎非理性痴迷的程度，创业公司永远不会成功。当然还要愿意面对现实，看清事情是否奏效，但如果你从一开始就不相信它，我绝不会赌它能成功。

---

### [00:44:50] Kayvon Beykpour

**English:**
And so this was common, and sometimes not as extreme as the examples that I mentioned, but I think one of the lessons I learned, and it's quite intuitive actually, is you need to staff projects with the team of people that are well equipped from a skillset standpoint, but more importantly have an obsession with the idea they want to pursue. It's going to make them work harder, it's going to make them be more creative. It's going to make them have the sufficient level of ambition and desire to will this thing into existence. Because every project, whether big or small, there is an element of you need to will this thing into existence because it's hard. The only way you're going to get through that pain is by having that desire, and I think a very easy cheat code for an organization to employ is to say, if you're going to work on something, especially if it's speculative or risky, staff it with a set of people who believe in it and really want to learn whether this solves a customer problem or not. Because if you don't have that ingredient, it's going to drag everyone down and it's just not going to be as successful.

**中文翻译:**
这种情况很常见，有时不像我举的例子那么极端。但我学到的教训之一（其实很直观）是：你需要为项目配置一支在技能上准备充分，但更重要的是对他们追求的想法有痴迷感的团队。这会让他们工作更努力，更有创造力。这会让他们有足够的雄心和欲望去“用意志让这件事成真”（will this thing into existence）。因为每个项目，无论大小，都包含这种成分，因为过程很艰难。度过痛苦的唯一方法就是拥有那种渴望。我认为组织可以采用的一个简单“作弊码”就是：如果你要做某件事，尤其是投机性或风险性的事，请配置一群相信它并真心想知道这是否能解决客户问题的人。如果你没有这个要素，它会拖累所有人，而且不会那么成功。

---

### [00:45:55] Lenny Rachitsky

**English:**
This episode is brought to you by Heap, the product analytics solution that shows you everything users do on your digital product, website, mobile product, or other digital services. We all know a great digital experience when we see it. It's intuitive, it anticipates your needs, and it makes it easy for you to do your job. If you're trying to build that kind of experience for your users, you need up to date, reliable information about what your users do in your product and why they do it.

**中文翻译:**
本集由 Heap 为您呈现。Heap 是一款产品分析解决方案，能向您展示用户在您的数字产品、网站、移动产品或其他数字服务中所做的一切。当我们看到出色的数字体验时，我们都能识别出来：它是直观的，能预见您的需求，并让您的工作变得轻松。如果您想为用户打造这种体验，您需要关于用户在产品中做什么以及为什么这么做的最新、可靠的信息。

---

### [00:46:24] Lenny Rachitsky

**English:**
Want to know how your users behave across platforms, what keeps them coming back, what they're doing that you're not even aware of? Well, I have some great news for you. Heap captures all of this user activity for you automatically and then gives you definitive answers to all your questions about user behavior in seconds, not weeks. With Heap, it's easy to prioritize the product investments that improve conversion, engagement, and retention. Visit heap.io/lenny to get started with a demo. That's heap.io/lenny. This kind of touches on something I wanted to touch on, which is jobs-to-be-done. This is maybe one of the most recurring controversies of the podcast, is jobs-to-be-done amazing or is it really bad and not something you should do? We've had many guests share their opinions. I feel like at Twitter, jobs-to-be-done was implemented so strictly that it burned a lot of people out on it. It's like, oh my, this is not anything anyone should ever do. I'm curious, just your lessons and experience of just with frameworks in general, the jobs-to-be- done specifically, maybe even OKRs.

**中文翻译:**
想知道您的用户如何跨平台行为？是什么让他们不断回头？他们在做哪些您甚至没意识到的事情？Heap 会为您自动捕捉所有这些用户活动，然后在几秒钟内（而不是几周）为您所有关于用户行为的问题提供明确答案。使用 Heap，可以轻松确定能提高转化率、参与度和留存率的产品投资优先级。访问 heap.io/lenny 开始演示。这触及了我想要探讨的一个话题，即“待办任务”（Jobs-to-be-done，简称 JTBD）。这可能是本播客中最常出现的争议之一：JTBD 到底是很棒，还是真的很糟糕且不该做？我们有很多嘉宾分享过意见。我觉得在推特，JTBD 的执行非常严格，以至于让很多人感到厌倦。就像是：“天哪，这绝对不是任何人该做的事。”我很好奇你对一般框架、特别是 JTBD，甚至 OKR 的教训和经验。

---

### [00:47:31] Kayvon Beykpour

**English:**
I've only seen one interview on your show that covers this. Sriram was particularly spicy when he talked about jobs-to-be-done, which is unsurprising because. I spent a lot of time talking to Sriram about jobs-to-be-done. I mean, I guess I'll just start by saying I was not a fan of how we leveraged jobs-to-be-done at Twitter. I thought it was exhausting and not particularly helpful, and so it's a particularly sore subject for me because I was sort of charged with defending it and rolling it out. It's hard to do that when you don't really believe in something. But...

**中文翻译:**
我只看过你节目中涉及这个话题的一次采访。Sriram 在谈到 JTBD 时言辞非常犀利，这并不奇怪，因为我花了很多时间和他讨论这个。我想我首先要说的是，我不喜欢我们在推特利用 JTBD 的方式。我觉得它让人精疲力竭，而且没什么特别的帮助。这对我来说是一个特别痛的话题，因为我当时负责捍卫并推广它。当你并不真正相信某件事时，很难去推广它。但是……

---

### [00:48:00] Kayvon Beykpour

**English:**
It's hard to do that when you don't really believe in something, but to me the critique is less about Jobs-to-be-Done though there are many critiques of it and more about every framework at its limit is followed to such a religious extent it's just unhelpful. You need to have nuance in how you leverage these frameworks. Otherwise, you lose the forest through the trees and you end up following a process for the sake of following a process. And that's what happened with Jobs-to-be-Done. So I think that's my real critique of it. It's not the... I mean listen, the premise of Jobs-to-be-Done and my most charitable take on Jobs-to-be-Done, which is actually useful is that it forces you to look at things through the lens of customers and understanding what their needs are and understanding what their true alternatives are outside of the narrow lens of your product.

**中文翻译:**
当你并不真正相信某件事时，很难去推广它。但对我来说，批评的重点不在于 JTBD 本身（虽然它有很多槽点），而在于任何框架一旦被推向极端，被像宗教一样狂热地遵循，它就会变得毫无用处。你在利用这些框架时需要有细微的差别（nuance）。否则，你会见树不见林，最终为了走流程而走流程。这就是 JTBD 在推特发生的情况。所以我真正的批评是针对这一点的。并不是说……听着，JTBD 的前提，以及我对它最宽容的看法（也是它真正有用的地方），是它强迫你从客户的角度看问题，理解他们的需求，并理解在你的产品这个狭窄视角之外，他们真正的替代方案是什么。

---

### [00:48:47] Kayvon Beykpour

**English:**
And I think that's just healthy product thinking. You don't need a framework called Jobs-to-be-Done. You don't need to think about milkshakes in order to be able to do that. It's like you could employ common sense or you could leverage something like Jobs-to-be-Done, to be able to force your mind to think of things through that lens. So I think that's my charitable view on what Jobs-to-be-Done can help you do, but as a framework into and of itself as a sole governing principle of what to build, it's just not useful.

**中文翻译:**
我认为这只是健康的产品思维。你不需要一个叫“待办任务”的框架，也不需要为了做到这一点而去思考什么“奶昔理论”（milkshakes，JTBD 的经典案例）。你可以运用常识，也可以利用像 JTBD 这样的东西来强迫自己从那个视角思考。这就是我对 JTBD 作用的宽容看法。但作为一个框架本身，作为决定“构建什么”的唯一指导原则，它就是没用。

---

### [00:49:14] Kayvon Beykpour

**English:**
By the way, in the same way as, and I think Twitter had this problem as well prior to our detour around Jobs-to-be-Done, if the only way the organization is trained to think about what to build and what not to build is OKRs, it's equally unhelpful at the limit because sure, you can have a good sense of what you should build to drive metrics, but by the way, you might be focusing on the wrong metrics or that might not help you have the right balance of things to build. That might not help you see when the things that you're building are actually hostile to customers.

**中文翻译:**
顺便说一下，同样地（我认为推特在转向 JTBD 之前也有这个问题），如果一个组织被训练成只通过 OKR 来思考该做什么和不该做什么，那么推向极端时同样没用。因为当然，你可能很清楚该做什么来推动指标，但你可能关注了错误的指标，或者这无法帮你平衡要构建的东西。这可能无法让你看到，你正在构建的东西实际上是对客户不友好的。

---

### [00:49:47] Kayvon Beykpour

**English:**
So just as an interesting example, the thing that I remember about your interview with Shriram, if I'm not mistaken, I think he mentioned, and I love Shriram, I'd be happy to debate him about this on his podcast, but he mentioned one of the examples I think was the Amazon. When you get order confirmation from Amazon, they intentionally bury the order details. You have to click the link and authenticate to go see what you ordered. I don't give two shits what metrics that drive for Amazon. That is one of the most customer hostile things I experience in my daily life. I order a lot of things from Amazon. I hate the fact that I can't search my email to see what I ordered. And so I think the problem with these frameworks is that you lose nuance and ultimately, and this is where I agree with Shriram, he actually mentioned this on your podcast as well, you need to be able to make trade-off decisions that balance what's right for the organization and what's right for the customer.

**中文翻译:**
举个有趣的例子，如果我没记错的话，在你对 Sriram 的采访中，他提到了亚马逊。当你收到亚马逊的订单确认邮件时，他们故意隐藏了订单详情。你必须点击链接并验证身份才能看到你买了什么。我根本不在乎这为亚马逊带来了什么指标。那是我日常生活中经历过的最不尊重客户的事情之一。我在亚马逊买很多东西，我讨厌无法通过搜索邮件来查看我买了什么。所以我认为这些框架的问题在于你失去了细微的权衡。最终（这也是我同意 Sriram 的地方，他在你的播客中也提到过），你需要能够做出权衡决策，平衡对组织有利的事情和对客户有利的事情。

---

### [00:50:43] Kayvon Beykpour

**English:**
And sometimes based on how you devise your frameworks, your metrics aren't actually aligned with the customer's benefit. Like the Amazon example, and we had many famous examples in Twitter's history, which were the same. One of our key metrics that we always optimized Shriram growing was DAU and we had obviously the rank timeline did wonders for growing DAU and it was a great experience for many customers, but we often had features that would not lead to a good customer experience and the team would just be blind towards leaving hostile customer experiences in place because it was good for metrics and aggregate. And the famous example of this is we had this toggle, which we called Swish very affectionately, but it was like a sparkle icon.

**中文翻译:**
有时，基于你设计框架的方式，你的指标实际上与客户利益并不一致。就像亚马逊的例子，推特历史上也有很多类似的著名例子。我们一直优化的关键指标之一是日活（DAU），显然算法排序的时间线在增加日活方面效果显著，对许多客户来说也是很好的体验。但我们经常有一些功能会导致糟糕的客户体验，而团队却视而不见，保留那些对客户不友好的体验，因为它们对整体指标有利。一个著名的例子是我们的那个切换开关，我们亲切地称之为“Swish”，就是一个星星图标。

---

### [00:51:26] Kayvon Beykpour

**English:**
Before you could switch between the rank timeline and the following, that reverse chronological timeline, which is still in the product right now, it was just the toggle. You would press a button and it would turn your feed reverse chron, which very few people use as a percentage of our users. But you had power users who really cared about having a reverse chronological timeline and we took so many baby steps on the evolution of this product. The very first baby step was you press the toggle, it turns you to reverse chron and then we would pull the rug out from underneath you and make the experience go back to the rank timeline after, I don't know, 24 hours or something like that.

**中文翻译:**
以前你可以在算法排序和“正在关注”（即时间倒序，现在产品里还有）之间切换，那只是一个开关。你按一下按钮，信息流就变成倒序排列，虽然只有极小比例的用户会用。但有些重度用户非常在意时间倒序。我们在产品的演进上采取了很多小步骤。第一步是：你按下开关，它变成倒序，然后我们会突然变卦（pull the rug out），在大概 24 小时后让体验自动回到算法排序。

---

### [00:52:02] Lenny Rachitsky

**English:**
Oh, wow.

**中文翻译:**
噢，哇。

---

### [00:52:03] Kayvon Beykpour

**English:**
And the reason that the team felt strongly about keeping it this way is it was better for metrics. Why? Even if Lenny wants a reverse chron feed, we knew that he would spend more time in the app if we put them in the rank timeline and this was the number of debates that we had about this because the team understandably was like, "This is good for metrics", but at the same time you'd have customers being like, "I fucking hate this experience. I'm telling you I want reverse chron. Stop randomly changing it for me."

**中文翻译:**
团队坚持这么做的原因是它对指标更有利。为什么？因为即便 Lenny 想要倒序排列，我们也知道如果把他放在算法排序里，他在 App 里待的时间会更长。我们为此进行了无数次辩论，因为团队理所当然地认为“这对指标有好处”，但同时客户会说：“我真他妈讨厌这个体验。我告诉你我要倒序，别再随机给我改回去了。”

---

### [00:52:34] Kayvon Beykpour

**English:**
Instagram has I think gone through their own struggles with this as well. They tiptoed their way towards ultimately giving people control and the difficulty in making product decisions comes down ultimately to making these trade-off decisions and you have to look at things through the lens of the customer. You have to balance that with what's driving the right business outcomes. And sometimes those things are aligned and sometimes they're not, and the answer isn't any one framework. Sometimes it's just good old-fashioned judgment and product taste. And so that's where my take is different. I don't think the issue is Jobs-to-be-Done, although I'm not the biggest fan of Jobs-to-be-Done. The issue is just having the right nuance and ultimately the right leadership to be able to weigh these things and see when your frameworks are not actually helping you make the right decisions.

**中文翻译:**
我想 Instagram 也经历过类似的挣扎。他们小心翼翼地摸索，最终才把控制权交给用户。制定产品决策的难点最终归结为做出这些权衡决策。你必须从客户的角度看问题，同时平衡业务成果。有时这些是一致的，有时不是。答案不在于任何一个框架，有时只是老派的判断力和产品品味（product taste）。这就是我的看法不同的地方。我不认为问题出在 JTBD 本身，虽然我不是它的忠实粉丝。问题在于是否具备正确的细微权衡能力，以及最终是否有正确的领导层来权衡这些事情，并看清你的框架何时其实并没有帮你做出正确的决定。

---

### [00:53:20] Lenny Rachitsky

**English:**
I think that's really important advice and I love hearing the details if I actually think about this stuff. Actually finding this balance is very hard in practice. I'm curious if there's something you could recommend or have learned about how to know when you've gone too far with a framework like signs like you have implemented this to religiously and maybe you should be thinking a little more broadly.

**中文翻译:**
我认为这是非常重要的建议。在实践中找到这种平衡非常难。我很好奇，你是否有什么建议或经验，能让人知道什么时候框架用得过头了？比如有哪些迹象表明你执行得太教条了，也许应该思考得更宽广一些？

---

### [00:53:41] Kayvon Beykpour

**English:**
There's two, I think, simple and obvious ones. One is if the result of your framework is that subjectively bad decisions are being made, then something's got to change. Assuming the person who's making this assessment has good product taste, which is in of itself subjective obviously, but my personal view on this would be in the role that I had, if I saw that our organization was being incentivized to make decisions that to some non-trivial degree of the time were just bad decisions that I don't like as a user, I can't stand by as a user or builder, then something's got to change. Either bad judgment was made in following the process or the process was wrong, or if that framework, it didn't even lead to the right debates, then that's how you know. Either you have an incentive problem but the team did what they were incentivized to do or that there was bad judgment and that's a different problem obviously.

**中文翻译:**
我认为有两个简单明显的迹象。第一，如果你的框架导致了主观上的错误决策，那么就必须做出改变。假设做出评估的人有良好的产品品味（这本身当然是主观的），但以我当时的职位来看，如果我看到我们的组织被激励去做出一些在很大程度上就是错误的决策——作为用户我不喜欢，作为开发者我也无法认同——那么就必须改变。要么是在执行流程时判断失误，要么是流程本身错了。或者，如果那个框架甚至没有引发正确的辩论，你就能察觉到了。要么是激励机制有问题（团队只是在做被激励去做的事），要么是判断失误，这显然是不同的问题。

---

### [00:54:38] Kayvon Beykpour

**English:**
But I think in the situation we found ourselves in where the team was again understandably hyper focused on driving DAU because that was the strategy for so long. It left so little room for even taking ambitious bets that in the short term wouldn't drive DAU, like some of our bets that I still to this day believe in hurt DAU in the short term, but you had to squint and believe over time would improve some metric DAU or otherwise, like a product like Spaces. In order for Spaces to be actually used, you needed to make sure that when Lenny starts a Space that people would join. And how do you get people to join Lenny space when they're used to having an asynchronous feed of tweets? Well, you can send push notifications, you can occupy really trying real estate at the top of the app that lets people know, "Hey, Lenny's live right now. He's in a space, there's people here, come join."

**中文翻译:**
但在我们当时的情况下，团队理所当然地过度关注推动日活（DAU），因为那是长久以来的战略。这导致几乎没有空间去进行那些短期内不会推动日活的大胆博弈。比如我至今仍相信的一些博弈，在短期内确实损害了日活，但你必须有远见并相信，随着时间的推移，它会改善日活或其他指标。比如 Spaces。为了让 Spaces 真正被使用，你需要确保当 Lenny 开启一个 Space 时，有人会加入。当人们习惯了异步的推文流时，你如何让他们加入 Lenny 的 Space？你可以发送推送通知，你可以占据 App 顶部非常显眼的黄金位置，告诉人们：“嘿，Lenny 正在直播，他在一个 Space 里，这里有人，快来加入。”

---

### [00:55:31] Kayvon Beykpour

**English:**
Guess what happens when you put a bar at the top of the app that tells people when they're live? You move tweets down, you move ads down, DAU goes down, revenue goes down. And so if you have an organization that's just hyper focused on the thing that matters is driving DAU quarter over quarter, then that doesn't leave enough room for nuance to accommodate new speculative bets that might hurt one metric, but over time have other consequences that are positive and beneficial, like enabling an entire new vector of content creation and conversation on the platform. I guess the other answer to your question in terms of how do you know when the framework's not serving you right? When you start imagining and planning for a bunch of bets that the organization then sees is disincentivized to make successful, then something's got to change.

**中文翻译:**
猜猜当你把一个显示直播状态的栏放在 App 顶部时会发生什么？你把推文往下挤了，把广告往下挤了，日活下降了，收入也下降了。所以，如果你的组织只关注季度环比的日活增长，那就没有足够的空间去容纳那些可能损害单一指标、但长期来看具有积极益处的新博弈，比如在平台上开启一个全新的内容创作和对话维度。关于如何知道框架何时不再适用，我的另一个答案是：当你开始构思和规划一系列博弈，而组织却觉得成功实现这些博弈会受到惩罚（disincentivized）时，那就必须改变了。

---

### [00:56:17] Kayvon Beykpour

**English:**
Either your strategy is just not the right strategy because it doesn't abide by the frameworks or the framework needs to accommodate the fact that actually we're going to try some things that in the short term either might not show up as blips on our DAU radar or are going to help some other metric that's important. And so that took us some time to get, and we tried a variety of schemes to make that work. Community Notes, the project that I was mentioning Keith started, we intentionally structured that like a startup. It was literally like we made a seed bet on Keith and his team and we were like, don't worry about the OKRs. We're not going to judge you on the basis of your OKRs.

**中文翻译:**
要么是你的战略不对（因为它不符合框架），要么是框架需要调整，以适应我们要尝试一些短期内可能不会在日活雷达上显示、或者会帮助其他重要指标的事实。我们花了一些时间才明白这一点，并尝试了各种方案。我提到的 Keith 启动的社区笔记项目，我们特意把它结构化得像个创业公司。字面上看，我们就像是对 Keith 和他的团队进行了一次种子轮投资，我们说：“别担心 OKR，我们不会根据 OKR 来评判你们。”

---

### [00:56:57] Kayvon Beykpour

**English:**
And there's some pros and cons to that. A lot of our projects worked that way. Fleets started that way. Community Notes started that way and some other projects started more part of the core organization because they were so intertwined with how we were the nature of the product that it just made sense to... Separating it was going to do more harm than good. So you just have to figure out based on how execution is going, whether you've got the right framework and you've got to be willing to make adjustments when it's not working.

**中文翻译:**
这样做各有利弊。我们的很多项目都是这样运作的。Fleets 是这样开始的，社区笔记也是。而其他一些项目则更多作为核心组织的一部分开始，因为它们与产品的本质紧密相连，分开反而弊大于利。所以你必须根据执行情况来判断框架是否正确，并在行不通时愿意做出调整。

---

### [00:57:29] Lenny Rachitsky

**English:**
That's actually really helpful. The two that I'm taking away here is how often are you feeling bad about the features you're shipping? Like they're bad for users and you think they're bad for you as a user potentially. And the other is it keeping you from taking big bold bets that don't necessarily drive the metrics you're focusing on. Okay, so before I let you go, I want to spend some time on Periscope. I don't know if everybody knows the history and story of Periscope. Basically it was the biggest live video streaming platform in the world and I imagine inspired basically every other social network to build a live-streaming platform, Instagram live, Facebook, TikTok, obviously Twitter. So I want to spend a little time here and see what you learned and also just broadly consumer products, but first of all, I hear there's a story with Kobe Bryant and Periscope about him using it in some form. Can you share that story?

**中文翻译:**
这真的很有帮助。我总结的两点是：你对自己发布的功感到糟糕的频率有多高？比如它们对用户不好，或者作为用户的你也觉得不好。另一点是，它是否阻碍了你进行那些不一定能推动当前关注指标的大胆博弈。好了，在结束之前，我想花点时间聊聊 Periscope。我不知道大家是否了解 Periscope 的历史。它曾是全球最大的直播平台，启发了几乎所有其他社交网络构建直播功能，如 Instagram Live、Facebook、TikTok，当然还有推特。我想在这里花点时间，看看你学到了什么，以及关于消费级产品的广泛经验。首先，我听说有一个关于科比·布莱恩特（Kobe Bryant）和 Periscope 的故事，他曾以某种形式使用过它。你能分享一下吗？

---

### [00:58:18] Kayvon Beykpour

**English:**
Before Periscope launched publicly, which it was in March of 2015, I want to say, we had a small beta that grew to maybe 500 people in total before we actually released the app publicly. And in that time while we were still in beta, I was trying to personally onboard every single user and I had a shtick that I did, which was we'd get them in the app and I would start a broadcast. We had a feature called Private Broadcasting that we basically built for this use case, which is someone joins, I'm going to go live and they're going to join and I'm going to show them how the app works. And we were spending a lot of time in our office, so Kobe, Chris Saka actually invited Kobe to the beta.

**中文翻译:**
在 Periscope 2015 年 3 月正式发布之前，我们有一个小规模的内测，在公开发布前总共大概有 500 人。在内测期间，我尝试亲自引导每一位用户。我有一套固定的流程：让他们进入 App，然后我开始直播。我们有一个叫“私人直播”的功能，基本上就是为这种场景开发的：有人加入，我开始直播，他们进来，我向他们展示 App 是如何运作的。我们当时在办公室花了很多时间。Chris Sacca 邀请了科比参加内测。

---

### [00:58:59] Kayvon Beykpour

**English:**
And so Chris connected us and I did a private broadcast and Kobe joins and I was like, it was like 10:00 PM in the office and my routine was like, let me just walk around the office talking through the mechanics of Periscope through the lens of this demo of like, "Hey, let me show you around the office and here's how the chat works and you can tap the screen to send hearts and if you want me to do something, go to the room over there, just type it in the chat and it'll come up."

**中文翻译:**
Chris 帮我们牵了线，我做了一次私人直播，科比加入了。当时大概是晚上 10 点，我在办公室里，我的惯例是：边在办公室走动，边通过演示讲解 Periscope 的机制，比如：“嘿，我带你参观一下办公室，这是聊天功能，你可以点击屏幕送爱心，如果你想让我做什么，比如去那个房间，就在聊天框里打出来。”

---

### [00:59:22] Kayvon Beykpour

**English:**
And sort of showed one of the things that was unique about Periscope was it was a one to many broadcasts, but still low latency enough that it felt like a FaceTime so you could have the bidirectional communication between multiple viewers and a broadcaster. And so I was teaching him how to use the chat and showing him the office and he was playing with it and at one point through the end of the demo he posts a comment that was like, "Why the fuck would anyone want to watch someone else stream live?" And I remember my heart sank and I started fumbling through like, "Well, we think it's cool."

**中文翻译:**
我展示了 Periscope 的独特之处：它是一对多的广播，但延迟足够低，感觉就像 FaceTime，所以观众和主播之间可以进行双向沟通。我教他如何使用聊天功能，带他参观办公室，他一直在玩。在演示快结束时，他发了一条评论：“到底为什么会有人想看别人的直播？”我记得当时我心凉了一截，开始语无伦次地解释：“呃，我们觉得这很酷……”

---

### [01:00:03] Kayvon Beykpour

**English:**
And before I could even get the words out, he posted like, "I'm just fucking with you, bro. This is incredible." And I just remember it was just such a surreal moment that has, I'll never forget, I mean Kobe's a legend obviously, but to have him essentially troll me while also putting a point on what was cool about the experience and that was bidirectional and something he commented on to cause the broadcaster to change their behavior or change the experience, it was a really ironic full circle of showing off how the product works. But yeah, it's one of my favorite early Periscope stories.

**中文翻译:**
还没等我说完，他又发了一条：“我逗你玩呢，兄弟。这太不可思议了。”我记得那真是一个超现实的时刻，我永远不会忘记。科比显然是个传奇，但他竟然在“调戏”我的同时，精准地指出了这个体验的酷点：它是双向的，他可以通过评论来改变主播的行为或体验。这真是一个展示产品运作方式的讽刺又完美的闭环。是的，这是我最喜欢的 Periscope 早期故事之一。

---

### [01:00:41] Lenny Rachitsky

**English:**
Oh man, if I kept doing that, the manual onboarding, I'd be like, "Who's coming?" Just always worried that someone else fancy is going to join. You never know who Chris Saka is getting, who he's talking to. That's amazing. Okay, so it's been about 10 years, I believe, since you sold Periscope and about six years ish since you stopped running at as CEO, something like that. Now as I shared, every single platform basically is doing this. They added live video streaming. I'm curious if there's anything you learned about just competing with these major platforms.

**中文翻译:**
天哪，如果我一直做那种人工引导，我会一直想：“接下来是谁？”总是担心会有什么大人物加入。你永远不知道 Chris Sacca 会找来谁。太棒了。好了，距离你卖掉 Periscope 大约 10 年了，距离你卸任 CEO 大约 6 年。正如我所说，现在几乎每个平台都在做直播。我想知道，在与这些主流平台竞争的过程中，你学到了什么？

---

### [01:01:14] Kayvon Beykpour

**English:**
Well, there's a few reasons why Periscope failed ultimately and why we shut down the app. Obviously Periscope, the technology and the mechanics still lives on because you can go live on Twitter, you can watch live broadcasts on Twitter, you can do audio conversations on Twitter and all of that is the Periscope stack. Still there, which is awesome that the legacy lives on in a different form factor. The reason that the Periscope app failed, it really comes down to a few things. One, we did not address the core problem that retention wasn't good. Our poor retention was mapped by just an incredible surge in top-line user growth. And for Periscope, it was interesting because every month or two we would blow up in a new market that would just bring along an incredible surge in usage.

**中文翻译:**
Periscope 最终失败并关闭 App 有几个原因。显然，Periscope 的技术和机制仍然存在，因为你可以在推特上直播、看直播、进行音频对话，所有这些都是 Periscope 的技术栈。它还在那里，这种遗产以不同形式延续的感觉很棒。Periscope App 失败的原因归结为几点：第一，我们没有解决留存率不佳的核心问题。我们糟糕的留存率被惊人的顶层用户增长掩盖了。Periscope 很有趣，因为每隔一两个月我们就会在一个新市场爆发，带来巨大的使用量激增。

---

### [01:02:02] Kayvon Beykpour

**English:**
We blew up in the US, we then blew up in France. We then blew up in Turkey. We then blew up in the Middle East and you had these incredible surges, but underneath that surge, the core product had retention issues and we ultimately just did not, we didn't spend enough time prioritizing, addressing those. And in fact, we shipped product changes that made those retention issues worse. Compounding that was the fact that one of the theses behind our acquisition, the Twitter acquisition, was that we would leverage the scale and the community and the product mechanics of Twitter to make the product grow faster and also become more durable. And I think that's connects to one of the reasons why I feel like one of my learnings and one of the things that we knew but just failed to execute on was that I still am very skeptical that there can be a consumer product that is just focused on live video, like a generalized synchronous live video application for short form video I don't think can be durable on its own. I think you have to surround that product with enough features and capabilities to allow a community and an ecosystem of users to be able to stay in touch with one another asynchronously and synchronously.

**中文翻译:**
我们在美国爆发，然后在法国、土耳其、中东爆发。你会看到这些惊人的激增，但在激增之下，核心产品存在留存问题，而我们最终没有花足够的时间去优先解决这些问题。事实上，我们发布的一些产品改动反而让留存问题恶化了。更糟糕的是，推特收购我们的一个前提是：我们将利用推特的规模、社区和产品机制让产品增长更快、更持久。这引出了我的一个感悟，也是我们当时知道但未能执行好的：我仍然非常怀疑是否能存在一个纯粹专注于直播的消费级产品。我不认为一个通用的、同步的短视频直播应用能独立持久存在。你必须为该产品配备足够的功能，让用户社区和生态系统能够异步和同步地保持联系。

---

### [01:03:39] Kayvon Beykpour

**English:**
This is why a lot of the other products that you mentioned that incorporate live capabilities and we're shameless about copying. What was working about Periscope, they're surrounded by a scaffolding that lets people also stay in touch with each other. Asynchronously Instagram, it's an asynchronous product that has synchronous features like live. Same with TikTok obviously. And I think we were in this position where it was a live only product.

**中文翻译:**
这就是为什么你提到的其他整合了直播功能的产品（它们毫不避讳地抄袭了 Periscope 行之有效的地方）都有一个支撑架构，让人们也能保持联系。Instagram 是一个异步产品，拥有直播等同步功能。TikTok 显然也是如此。而我们当时处于一个“纯直播”产品的境地。

---

### [01:04:32] Kayvon Beykpour

**English:**
You are connecting with your audience and having a great time when you're broadcasting live, but you're not using the product to keep in touch with that community when you're not broadcasting. How often throughout the day would you broadcast live from your phone? And mind you, this is different for products that are live. There are live consumer products that focus on a specific vertical like whatnot for selling or Twitch for gaming that have very different properties that make it more durable as a standalone live product. But Periscope was really in this consumer generalized live-streaming from a phone land, and I think it was just not durable to have the product be live only. And the time it took us to integrate with Twitter was way too long. And there was reasons for that that come down to just how distracted Twitter was with its own roadmap and refining the core and they just had other fish to fry basically.

**中文翻译:**
当你直播时，你与观众建立了联系并度过了愉快的时光，但当你不在直播时，你不会使用这个产品来与社区保持联系。你一天能用手机直播几次？请注意，这与某些直播产品不同。有些消费级直播产品专注于特定垂直领域，如用于销售的 Whatnot 或用于游戏的 Twitch，它们具有非常不同的属性，使其作为独立的直播产品更持久。但 Periscope 处于通用的手机直播领域，我认为纯直播模式是不持久的。而且我们与推特整合的时间拖得太长了。原因在于推特当时正忙于自己的路线图和优化核心，基本上是无暇他顾。

---

### [01:04:56] Kayvon Beykpour

**English:**
And all of that leads us to competition because at some point Facebook woke up and decided this is cool and we need to go build this. And I obviously wasn't there on the inside, but legend has it, Mark says, "Hey, you 300 people, stop what you're doing. Go basically make live exist in our product as a first [inaudible 01:04:56] experience."

**中文翻译:**
所有这些都导致了竞争，因为在某个时刻 Facebook 醒悟了，觉得这很酷，我们需要做这个。我显然不在他们内部，但传闻说马克（扎克伯格）说：“嘿，你们这 300 个人，停下手里所有的活。去把直播功能做进我们的产品里，作为一级体验。”

---

### [01:04:56] Lenny Rachitsky

**English:**
Oh, wow. I didn't know that.

**中文翻译:**
噢，哇。我以前不知道这个。

---

### [01:04:57] Kayvon Beykpour

**English:**
And if you have that level of organizational effort put on building something that by the way, you don't have to spend any time wondering what the product looks like, just go copy these features basically and make them work. And they did a lot of other savvy things too from a partnership standpoint. We had a lot of prominent streamers that ranged from influencer or just creative people that became known on Periscopes, all the way up to celebrities like Kevin Hart and others who were prolific Periscopers that Facebook just went and bought out.

**中文翻译:**
如果你投入这种级别的组织力量去构建一个东西，而且顺便说一下，你根本不需要花时间去思考产品长什么样，直接抄这些功能并让它们运行就行。他们在合作伙伴关系方面也做了很多精明的事。我们有很多著名的主播，从在 Periscope 成名的网红或创意人士，到像凯文·哈特（Kevin Hart）这样高产的名人，Facebook 直接把他们买断了。

---

### [01:05:30] Kayvon Beykpour

**English:**
They were just like, "Cool, we're going to pay you a bunch of money to stream exclusively with us." So they hit us from all sides. They had the entire company put their effort towards building live in a way that was cohesive in the core product first with Facebook and then Instagram and then also attacked it from the creator as well. And we were too slow and it was very painful to think about because it was like many other insights that Twitter had early. Twitter had the right insight, but botched the follow through. I'm not pointing fingers, I blame myself for that just as much, but there's a pattern where Twitter is really great at spotting meaningful consumer behavior changes. They spotted Vine and acquired Vine, botched it, spotted Periscope, botched it, spotted Instagram by the way, before Facebook tried to buy Instagram, Twitter was trying to buy Instagram, and there are other reasons why that didn't fall through, but it's interesting to me, it's one of the interesting aspects of Twitter's history.

**中文翻译:**
他们直接说：“酷，我们会给你一大笔钱，让你只在我们这里直播。”所以他们从各方面打击我们。他们动员全公司力量，先在 Facebook 核心产品中构建直播，然后是 Instagram，同时还从创作者端发起进攻。而我们太慢了，回想起来非常痛苦。这就像推特早期拥有的许多其他洞察一样：推特有正确的洞察，但搞砸了后续执行。我不是在指责别人，我也同样责怪自己。但推特有一个模式：它非常擅长发现有意义的消费者行为变化。他们发现了 Vine 并收购了它，搞砸了；发现了 Periscope，搞砸了；顺便说一下，在 Facebook 尝试收购 Instagram 之前，推特也曾尝试收购它。推特历史上一个有趣的方面是：他们极度擅长发现社交行为的重大变化，并愿意投入资金尝试将这些博弈引入内部，但随后却搞砸了执行。

---

### [01:06:35] Kayvon Beykpour

**English:**
They were phenomenal at spotting meaningful changes in consumer social behavior, and actually putting their money where their mouth is in terms of trying to follow through on bringing those bets in-house, but then botching the execution. And so that was one of the things that was really motivating for me when I was in my role leading product of Twitter was I didn't want to make that mistake and we didn't end as up buying anything like Vine or Periscope and keeping the product. We obviously bought lots of small acquirers, but we did obviously have a bit of a story with Clubhouse that ended up with us building Spaces and competing with them. But anyway, that was a long, rambly story. Hopefully that answered your question.

**中文翻译:**
他们在发现消费者社交行为的重大变化方面表现出色，并且真的愿意付诸行动尝试将这些博弈引入内部，但随后却搞砸了执行。所以当我担任推特产品负责人时，这成了我的动力之一：我不想再犯那样的错误。我们后来没有再买像 Vine 或 Periscope 这样的大产品并保留它们，而是买了很多小型人才收购。当然，我们和 Clubhouse 之间也有一段故事，最终导致我们构建了 Spaces 并与他们竞争。总之，这是一个漫长而散乱的故事，希望回答了你的问题。

---

### [01:07:25] Lenny Rachitsky

**English:**
Yeah, there's so many. Again, it's all these fractals of thought threads I want to follow and ask you about. Real quick on the Vine and Periscope point, I was going to ask this. Twitter, as you said, had the opportunity to win in video in so many ways. Vine was amazing, killing everyone, loved it, and then it's fades away. I guess, you already shared a lot of challenges Twitter had with executing, shipping, Secret Cows, things like that. Is there anything specific with video? Was it just like, oh, this is not actually a huge priority and we're just going to ride it for now and that's why it didn't work out? Or is there anything more that?

**中文翻译:**
是的，故事太多了。关于 Vine 和 Periscope，我想问：正如你所说，推特曾有很多机会在视频领域获胜。Vine 曾非常惊人，横扫一切，深受喜爱，然后就消失了。你已经分享了推特在执行、发布、禁忌等方面的挑战。关于视频，有什么具体的原因吗？是因为它实际上不是最高优先级，大家只是想顺其自然，所以才没成功吗？还是有更深层的原因？

---

### [01:07:53] Kayvon Beykpour

**English:**
No, it's even more like pathetic than that 'cause I think Twitter did believe in video, but it made this classical mistake that we also unfortunately recreated with Periscope, which was they had the insight around short-run video, they bought Vine. They then competed with Vine internally. So Vine was a separate organization within Twitter, separate office obviously in New York and then Twitter rather than integrated holistically into the product and pour gasoline on it, they built a native Twitter video feature that was a different stack, different team. It became what you think of as Twitter video now. It's like the most simple active uploading video and all the professional video tools called Media Studio that let publishers like ESPN put content. All of that was basically built as a separate team, separate organization, separate product that was competing with Vine. You had two visions for short form video that were manifesting, and that's the quickest way for things to get messy.

**中文翻译:**
不，情况甚至比那更可悲。因为我认为推特确实相信视频，但它犯了一个经典错误，不幸的是我们在 Periscope 上也重蹈覆辙了。他们对短视频有洞察，买了 Vine，然后却在内部与 Vine 竞争。Vine 是推特内部的一个独立组织，在纽约有独立办公室。推特没有将其整体整合进产品并火上浇油，而是构建了一个原生的推特视频功能，使用了不同的技术栈和团队。它变成了你现在认为的“推特视频”——最简单的上传视频功能，以及让 ESPN 等出版商发布内容的专业视频工具 Media Studio。所有这些基本上都是由一个独立的团队、独立的组织、独立的产品构建的，它们在与 Vine 竞争。你有两个短视频愿景在同时进行，这是让事情变得混乱最快的方法。

---

### [01:08:58] Kayvon Beykpour

**English:**
And of course the separate startup team is going to get, you're not going to be able to make good on the vision of buying the company and integrating it in all the right ways if you compete with it internally. And we had a similar thing happen with Periscope. We were very focused on Periscope with separate organizations, separate structures, separate app. Periscope at the time primarily was focused on UGC live video. So user-generated content being streamed from a phone. Twitter then decided to get in the premium live video business very famously with acquiring rights to Thursday night football, the NFL. Guess what happened? We competed internally rather than have a cohesive technical and product vision for how to embrace live video across the spectrum of UGC and premium live video, Twitter put a separate team in charge of premium with a separate product, separate technology stack. And so you had two ways to manifest live video on the product. It was like UGC live video, which was awkwardly not even really implemented well with Twitter at the time. And then premium live video, which had totally different UX, total different team, totally different architecture. And by the way, the company put a tremendous amount of energy and investment in talking about Twitter being a place to watch the NFL. Meanwhile you had this burgeoning UGC ecosystem, so this was like we're making the same mistake all over again.

**中文翻译:**
当然，如果你在内部与被收购的公司竞争，你就无法实现收购并整合它的愿景。Periscope 也发生了类似的事情。我们非常专注于 Periscope，拥有独立的组织、架构和 App。当时 Periscope 主要关注 UGC（用户生成内容）直播。推特随后决定进军高端直播业务，最著名的是购买了 NFL 周四晚间橄榄球赛的版权。猜猜发生了什么？我们在内部竞争。推特没有一个统一的技术和产品愿景来涵盖从 UGC 到高端直播的整个光谱，而是让一个独立的团队负责高端直播，使用独立的产品和技术栈。所以你在产品上有两种直播形式：一种是当时与推特整合得并不好的 UGC 直播，另一种是拥有完全不同 UX、团队和架构的高端直播。顺便说一下，公司投入了巨大的精力和资金宣传推特是看 NFL 的地方，而与此同时，你还有一个蓬勃发展的 UGC 生态系统。这就像是在重蹈覆辙。

---

### [01:10:48] Kayvon Beykpour

**English:**
Now, luckily in the Periscope case with a lot of persistence and impatience and table pounding, we eventually fixed that mistake, but we wasted a tremendous amount of time. It was just a lot of headbutting in politics and eventually it took us a lot of time to technically reintegrate things together and now it's clean and awesome, right? ESPN can go live with behind the scenes content at Wimbledon and it's the same technology stack and the same user experience, the powers, Lenny going live from his iPhone. But I think that was one of the reasons why it was an example of failed execution that ended up wasting time, resources and just leading to a subpar product experience that other companies I think have avoided making such mistakes. Facebook being a prime example, as frustrated, I am with them as a competitor for having really taken over the use case for live video. Got to hand it to them, brilliant execution, have a lot of respect for them. So we made sure to not make that mistake moving forward.

**中文翻译:**
幸运的是，在 Periscope 的案例中，通过大量的坚持、不耐烦和拍桌子，我们最终修正了这个错误，但我们浪费了大量时间。那涉及大量的政治斗争，最终我们花了很长时间才在技术上重新整合。现在它很简洁也很棒，对吧？ESPN 可以在温网直播幕后内容，它使用的技术栈和用户体验，与 Lenny 用 iPhone 直播时完全一样。但我认为那是执行失败的一个例子，导致了时间、资源的浪费，并带来了次优的产品体验。我认为其他公司避开了这种错误。Facebook 就是一个典型的例子，尽管作为竞争对手我对他们抢走了直播用例感到沮丧，但不得不佩服他们出色的执行力，我非常尊敬他们。所以我们确保以后不再犯这种错误。

---

### [01:11:33] Lenny Rachitsky

**English:**
I imagine there was reason for that. Partly I imagine this calcification of just like, we can't get you done, we just need to start a new team and do this thing. I imagine it always comes from like, oh, this makes sense. And then you realize, okay, this was a terrible idea down the road.

**中文翻译:**
我能想象其中的原因。部分原因可能是那种僵化：我们没法在现有体系下完成，所以我们需要成立一个新团队来做。我想出发点总是“噢，这很有道理”，然后过一阵子你才意识到：“好吧，这主意糟透了。”

---

### [01:11:47] Kayvon Beykpour

**English:**
Yeah, it's that and also leadership. When you don't have unified leadership around these things, you end up making decisions that are in conflict with one another. They're just need a highly opinionated person at the top that avoids that kind of messiness from a product and engineering standpoint.

**中文翻译:**
是的，还有领导力的问题。当你在这些事情上没有统一的领导时，你最终会做出相互冲突的决定。顶层需要一个非常有主见的人，从产品和工程的角度来避免这种混乱。

---

### [01:12:05] Lenny Rachitsky

**English:**
You mentioned Clubhouse, so I think what's interesting is one, many people copy Periscope as a product. I don't know if you'll describe it as copying, but it feels like spaces very inspired by Clubhouse. Do you have just a current philosophy on when it makes sense to be super inspired by another product and build it into your existing product versus like, no, you should not do this?

**中文翻译:**
你提到了 Clubhouse。有趣的是，很多人抄袭了 Periscope。我不知道你会不会用“抄袭”这个词，但感觉 Spaces 很大程度上受到了 Clubhouse 的启发。关于什么时候应该从另一个产品中获得灵感并将其构建到现有产品中，还是说“不，你不该这么做”，你现在的哲学是什么？

---

### [01:12:30] Kayvon Beykpour

**English:**
I think it's always about doing the right thing for the customer. Everyone has always been shameless to be shamelessly inspired by other people's ideas. I don't think there's anything wrong with that. I think copying ideas can be done in poor taste and can be done with taste. I think some of the people who copied Periscope did so in poor taste, can't blame them. I wouldn't have done it the same way, but it worked. So you can't say it's the wrong thing. I think that it's possible to take ideas in good taste and take ideas in poor taste.

**中文翻译:**
我认为核心始终是为客户做正确的事。每个人一直都在毫不避讳地从别人的想法中获取灵感。我不认为这有什么错。我认为抄袭想法可以做得很低俗，也可以做得很有品味。我认为有些抄袭 Periscope 的人做得比较低俗，但不能怪他们。我不会用同样的方式去做，但它奏效了，所以你不能说那是错的。我认为借鉴想法是有品味高低之分的。

---

### [01:13:07] Kayvon Beykpour

**English:**
And I think with Clubhouse, we actually had been working on audio. Audio was one of those bets I mentioned that we structured very separately with a team of people, many of which were the former Periscope team, that when we wound down Periscope, I felt very strongly that there was still something to the idea of synchronous conversations. Because one of the famous things that I think we botched with Periscope is that we always... Our dream and our vision for Periscope and how we talked about it was was a mechanism for teleportation. You could see through someone else's eyes and be teleported somewhere else. It was like that was the story we told ourselves. That was the thing that inspired Periscope.

**中文翻译:**
关于 Clubhouse，实际上我们一直在研发音频功能。音频是我提到的那些独立运作的博弈之一，团队中很多成员来自原 Periscope 团队。当我们关闭 Periscope 时，我强烈感觉到“同步对话”的想法仍然有价值。因为我认为我们在 Periscope 上搞砸的一件著名的事是：我们对 Periscope 的梦想和愿景，以及我们描述它的方式，是将其作为一种“瞬间移动”的机制。你可以通过别人的眼睛看世界，被传送到别处。那是我们告诉自己的故事，也是启发 Periscope 的初衷。

---

### [01:13:58] Kayvon Beykpour

**English:**
And to a certain extent, a lot of people did use the product for that way. You could go see what it was like someplace in the world where it was something amazing happening or civil unrest happening or some important moment happening with breaking news or otherwise. But it turns out the vast majority of our users were not using Periscope that way. It wasn't a rear-facing camera experience where you were showing someone the world, the vast majority of people were using it to just talk to other people. They were bored or they were lonely and they wanted to just have a conversation with other people. And it turns out video and audio is a very interesting way of doing that that allows for more nuance, more long-form conversation, more in-depth conversation, especially in contracts to Twitter, which has mechanics to really incentivize quick, snappy broadcasts that don't lead to much depth.

**中文翻译:**
在某种程度上，很多人确实是这样使用产品的。你可以看到世界上某个正在发生奇迹、动乱或重大新闻时刻的地方是什么样子的。但事实证明，绝大多数用户并不是那样使用 Periscope 的。它不是一种展示世界的后置摄像头体验，绝大多数人只是用它来和别人聊天。他们感到无聊或孤独，只想和别人交流。事实证明，视频和音频是实现这一目标的一种非常有趣的方式，它允许更多的细微差别、更长篇、更深入的对话，尤其是相对于推特而言——推特的机制更倾向于激励快速、简短的广播，往往缺乏深度。

---

### [01:14:54] Kayvon Beykpour

**English:**
And so when we shut down Periscope, we were like, man, we really need to enable a new form of conversation on Twitter that has some of those properties. And so we had a team that was working on a project that we sort of code named Hydra. Hydra because there were multiple heads on this monster and those heads are participants in a conversation. And so well before Clubhouse was on the map, we had many different iterations of both video and audio only experiences that just didn't feel right, weren't working right, but we felt like we were onto something.

**中文翻译:**
所以当我们关闭 Periscope 时，我们觉得，天哪，我们真的需要在推特上开启一种具备这些属性的新对话形式。于是我们有一个团队在做一个代号为“九头蛇”（Hydra）的项目。叫 Hydra 是因为这个怪物有很多头，而这些头就是对话的参与者。所以在 Clubhouse 出现之前很久，我们就有了很多视频和纯音频体验的迭代，虽然感觉不对劲，运行也不顺畅，但我们觉得我们找对了方向。

---

### [01:15:31] Kayvon Beykpour

**English:**
And when Clubhouse came on the map, it really re-centered, it put into focus a user experience that felt a lot more right and now give them complete credit for that. Paul and Rohan and that team did an exceptional job crafting an experience that really enabled that mechanic and that premise of enabling these longer form conversations to shine. And so we did shamelessly seek inspiration from what they had done and what had worked and we put our own spin on it. The execution of Spaces within Twitter I think has some similarities, but also really took advantage of the mechanics that you had available to you in Twitter. It's a different product. And so we took the ideas that we felt were shortcuts to making the experience work and then we put our own spin on it. And so I have no problems with what we did there.

**中文翻译:**
当 Clubhouse 出现时，它真的重新聚焦并凸显了一种感觉更正确的使用体验，这完全归功于他们。Paul、Rohan 及其团队在打造这种体验方面做得非常出色，让长篇对话的机制大放异彩。所以我们确实毫不避讳地从他们的做法和成功经验中汲取灵感，并加入了我们自己的特色。Spaces 在推特内部的执行与他们有一些相似之处，但也充分利用了推特现有的机制。它是一个不同的产品。我们采纳了那些我们认为是实现体验捷径的想法，然后加入了我们自己的风格。我对我们的做法没有任何心理负担。

---

### [01:15:55] Kayvon Beykpour

**English:**
And having had experienced the pain of not moving quickly enough with Vine from the outside and Periscope having lived that experience, we were not willing to not be the winner with this use case. It is one of the projects I'm most proud of that we worked on at Twitter because we were very radical in our execution. Hydra went from this tiny project that six people were working on that no one knew or care about to, we made Spaces as the number one priority of the company literally above any other project period. And we put a bunch of people on accelerating that product and making it come to life within Twitter. And a lot of that was having felt the pain and burn of fucking this up with Vine and Periscope. And so I'm really proud of our execution. And it was also really energizing. I hope for the company to see that, wow, we pulled that off. So yeah, it was good. It was nice to have that full circle experience and also nice that, personally, I love that aspects of Periscope continue living on within Twitter.

**中文翻译:**
由于曾目睹 Vine 因行动不够快而失败，并亲历了 Periscope 的痛苦，我们绝不甘心在这个用例上再次落败。这是我在推特参与过的最令我自豪的项目之一，因为我们的执行非常激进。Hydra 从一个只有 6 个人在做、没人知道也没人在意的微型项目，变成了推特的第一优先级，字面上看高于任何其他项目。我们投入了大量人力来加速这个产品，让它在推特内部落地。这很大程度上是因为我们感受过搞砸 Vine 和 Periscope 的切肤之痛。所以我对我们的执行力感到非常自豪。这也非常振奋人心，我希望公司能看到：哇，我们做到了。所以这很好，这种圆满的体验很棒，而且就我个人而言，我很高兴 Periscope 的某些特质在推特内部得以延续。

---

### [01:17:15] Lenny Rachitsky

**English:**
I did not know that. That is extremely interesting. Speaking full circle, when I joined Clubhouse the first time, Paul was there introducing me to Clubhouse and exactly the way you described Periscope, so I feel like he drew some inspiration from you one step back.

**中文翻译:**
我以前不知道这些。这非常有趣。说到圆满，我第一次加入 Clubhouse 时，Paul 就在那里向我介绍 Clubhouse，方式和你描述 Periscope 时一模一样。所以我觉得他可能也从你那里获得了一些灵感。

---

### [01:17:30] Kayvon Beykpour

**English:**
Paul's amazing. I feel like we're kindred spirits and I could see... It was one of the things I love about that team is just you could just feel how palpable their excitement was and their passion was for what they were building. Another universe we could have worked together more closely, but I think what they built was incredible and we took inspiration from it for sure. Yeah.

**中文翻译:**
Paul 很棒。我觉得我们志趣相投。我喜欢那个团队的一点是，你能感受到他们对自己所构建的东西那种显而易见的兴奋和激情。在另一个平行宇宙，我们可能会合作得更紧密，但我认为他们构建的东西非常了不起，我们确实从中汲取了灵感。

---

### [01:17:58] Lenny Rachitsky

**English:**
So you've built some of the most successful, most beloved, most used consumer products. You continue to help other founders with their product. I'm curious just if you have any advice for how to get better at building consumer products in terms of maybe craft a product, product sense. What have you learned about what it takes to build a successful consumer product?

**中文翻译:**
你打造了一些最成功、最受喜爱、使用最广泛的消费级产品。你也一直在帮助其他创始人打磨产品。我很好奇，关于如何更好地构建消费级产品，在产品技艺或产品感（product sense）方面，你有什么建议吗？关于打造成功的消费级产品需要什么，你学到了什么？

---

### [01:18:19] Kayvon Beykpour

**English:**
The best cheat codes for getting better at building products is just being a voracious user of products. And just trying new things, feeling out what works well, what doesn't, what you like, what you don't like. There's just no replacement for that. It's such an effective way of honing your own taste and seeing what's superficial but not useful, what's ugly but useful, what's beautiful and useful. And you hone that by having practice and building muscle memory. And so I think there's not a lot of science to it, I think. I mean obviously science can help you become more effective at lots of things. But I feel like I've just always been very curious about trying new things. I'm a very hungry consumer of new things that people are building and I'm not quick to judge. I'll try it even if it seems dumb because sometimes things that seem dumb at the beginning become very meaningful.

**中文翻译:**
提升产品构建能力的最好“作弊码”就是成为产品的狂热用户。不断尝试新事物，感受什么是好用的，什么是不好用的，你喜欢什么，不喜欢什么。这无可替代。这是磨练你品味最有效的方法：看清什么是华而不实的，什么是虽然丑但好用的，什么是既美观又好用的。你通过实践和建立肌肉记忆来磨练这种能力。我认为这其中没有太多的科学成分。当然，科学可以帮你提高效率，但我一直对尝试新事物充满好奇。我是别人所构建的新事物的饥渴消费者，而且我不会急于下结论。即便有些东西看起来很蠢，我也会尝试，因为有时最初看起来很蠢的东西最后会变得非常有意义。

---

### [01:19:20] Kayvon Beykpour

**English:**
And so it's always been a very helpful cheat code for me. And it's also just personally interesting. Every tool, even the silly ones, people put their heart and soul into it and it's like an expression of themselves and it's always interesting to see that, to see people's creations and to learn from them and see what you like, what you don't like and how you might create something of your own that borrows from that. So if I could give people any advice through the lens of what's worked for me, it's that.

**中文翻译:**
所以这对我来说一直是一个非常有用的“作弊码”。而且这在个人层面上也很有趣。每一个工具，哪怕是那些傻傻的工具，人们都倾注了心血，它是他们自我的一种表达。看到人们的创造并从中学习，看你喜欢什么、不喜欢什么，以及你如何借鉴并创造出自己的东西，这总是很有趣。如果让我根据自己的经验给人们建议，那就是这个。

---

### [01:19:51] Lenny Rachitsky

**English:**
Speaking of trying new things, what are you up to these days?

**中文翻译:**
说到尝试新事物，你最近在忙什么？

---

### [01:19:55] Kayvon Beykpour

**English:**
I'm building something in the consumer space. I started the company with a couple of co-founders late last year. We're not quite ready to talk about it yet, but hopefully you'll be hearing from us pretty soon. But it's really nice to be back building something again, particularly building something with a small team again after seeing the opposite extreme with a really large company. We've just talked about lots of large company things. But yeah, hopefully you'll be hearing about it soon.

**中文翻译:**
我正在消费领域构建一些东西。去年年底我和几个合伙人创办了这家公司。我们还没准备好公开谈论它，但希望很快你们就能听到我们的消息。在见识过大公司的极端情况后，能重新回来亲手做点东西，尤其是再次和一个小团队一起奋斗，感觉真的很好。我们刚才聊了很多大公司的事。但总之，希望你们很快能听到消息。

---

### [01:20:26] Lenny Rachitsky

**English:**
Oh man, I think this is breaking news. So mysterious and exciting. Kayvon, is there anything else you wanted to share or leave listeners with before we get to our very exciting lightning round?

**中文翻译:**
天哪，我觉得这是个大新闻。既神秘又令人兴奋。Kayvon，在进入我们非常精彩的闪电问答环节之前，你还有什么想分享或留给听众的吗？

---

### [01:20:38] Kayvon Beykpour

**English:**
No, no, I think we've covered quite a bit.

**中文翻译:**
没有了，我想我们已经聊得挺多了。

---

### [01:20:42] Lenny Rachitsky

**English:**
We have. We have indeed. With that, we've reached our very exciting lightning round. Are you ready?

**中文翻译:**
确实如此。那么，我们进入非常精彩的闪电问答环节。准备好了吗？

---

### [01:20:46] Kayvon Beykpour

**English:**
I'm going to take a sip of water and then I'll be ready.

**中文翻译:**
我喝口水，然后就准备好了。

---

### [01:20:49] Lenny Rachitsky

**English:**
Okay, here we go. First question, what are two or three books that you've recommended most to other people?

**中文翻译:**
好，开始。第一个问题：你向别人推荐最多的两三本书是什么？

---

### [01:20:54] Kayvon Beykpour

**English:**
I love reading sci-fi. I just feel like sci-fi and mystery books are so healthy for jogging the imagination. And so some of my favorite books are by Neal Stephenson, I love Cryptonomicon. I love Reamde. I love a book called Name of the Wind by Patrick Rothfuss, which is more like a fantasy book, but I just love escaping reality and thinking about sci-fi, thinking about fantasy is just, it's helpful for the soul and helpful for the imagination. So those are some of my favorite reads because it helps me. I feel like in some weird circular or wandering way, it helps me be more creative and imaginative.

**中文翻译:**
我喜欢读科幻小说。我觉得科幻和悬疑书对激发想象力非常有益。我最喜欢的一些书是 Neal Stephenson 的作品，比如《加密解密》（Cryptonomicon）和《雷德》（Reamde）。我还喜欢 Patrick Rothfuss 的《风之名》（Name of the Wind），它更像是一本奇幻小说。我喜欢逃离现实，思考科幻和奇幻对灵魂和想象力都很有帮助。这些是我最喜欢的读物，因为我觉得它们以某种奇妙的方式帮我变得更有创造力和想象力。

---

### [01:22:30] Kayvon Beykpour

**English:**
And by the way, that's true outside of reading as well. Some of the content that has shaped me, I feel like and help motivate my curiosity and a lot of things I built is sci-fi TV, right? Star Trek is incredible. We used to use as a metaphor for what Periscope was, we would think about Star Trek. It'd be really cool to be able to teleport or get beamed somewhere else in the world and we're not smart enough to go build that device, but what's the closest approximation to that that we can realize through software? Live streaming.

**中文翻译:**
顺便说一下，阅读之外也是如此。一些塑造了我、激发了我的好奇心并影响了我所构建的东西的内容是科幻电视剧。比如《星际迷航》（Star Trek）就很了不起。我们曾用它来隐喻 Periscope：如果能瞬间移动或被传送到世界其他地方，那该多酷。我们不够聪明，造不出那种物理设备，但通过软件能实现的最接近的方式是什么？就是直播。

---

### [01:22:37] Kayvon Beykpour

**English:**
I mean the most recent movie I saw in theaters was Dune Two, and it was incredible.

**中文翻译:**
我最近在电影院看的一部电影是《沙丘 2》，非常震撼。

---

### [01:22:41] Lenny Rachitsky

**English:**
I just saw that.

**中文翻译:**
我也刚看。

---

### [01:22:41] Kayvon Beykpour

**English:**
It's insane. I also thought Oppenheimer was... I'm a huge Nolan fan. Oppenheimer was captivating. To have that level of high octane in a biopic consistently for two and a half hours is so hard to pull off. And I thought it was exceptional. TV shows we're watching Tokyo Vice right now, which I really like. I think one of the best TV shows I've watched recently, I mean Succession was amazing, but maybe I'll pull a less popular one, which is Devs also in the sci-fi realm. I think it was a Hulu show. But if you're interested in tech and AI and you want great acting in Nick Offerman, Devs is a pretty amazing show.

**中文翻译:**
太疯狂了。我还觉得《奥本海默》……我是诺兰的超级粉丝。《奥本海默》非常迷人。能让一部传记片在两个半小时里始终保持那种高强度的张力，真的很难做到。我觉得它非常出色。电视剧方面，我们正在看《东京罪恶》（Tokyo Vice），我很喜欢。最近看过的最好的剧，除了《继承之战》（Succession）很棒之外，我推荐一个冷门点的：科幻题材的《开发者》（Devs）。我想那是 Hulu 的剧。如果你对科技和 AI 感兴趣，想看 Nick Offerman 的精彩演技，《开发者》是一部很棒的剧。

---

### [01:23:28] Lenny Rachitsky

**English:**
I haven't heard of that. Have you seen 3 Body Problem yet, by the way? It feels like it's squarely in your wheelhouse.

**中文翻译:**
我没听说过那部。顺便问下，你看《三体》（3 Body Problem）了吗？感觉那完全是你的菜。

---

### [01:23:33] Kayvon Beykpour

**English:**
I haven't seen it yet.

**中文翻译:**
还没看。

---

### [01:23:35] Lenny Rachitsky

**English:**
Okay.

**中文翻译:**
好吧。

---

### [01:23:35] Kayvon Beykpour

**English:**
And it's funny, some content people are talking about it so much that I kind of want to not watch it now because I feel like it's really hard for shows to live up to the hype when you're mid-hype cycle. So I haven't gone around to it yet, but it's definitely on my list. I know it's the type of show that I would love, but I just haven't gone.

**中文翻译:**
很有趣，有些内容大家讨论得太多了，我反而有点不想看了，因为在炒作高峰期，剧集很难达到人们的预期。所以我还没看，但它肯定在我的清单上。我知道那是我会喜欢的类型，只是还没开始看。

---

### [01:23:54] Lenny Rachitsky

**English:**
Okay, great. Do you have a favorite interview question that you like to ask candidates you're hiring?

**中文翻译:**
好。你招聘时最喜欢问候选人的面试问题是什么？

---

### [01:23:58] Kayvon Beykpour

**English:**
The thing that I find is both very illustrative and helpful is just asking people to talk about something they worked on that failed and talk about something they built that succeeded as well. But I think you just learn a lot about self-reflection and their passions. But particularly their self-reflection. If they talk through something that they really cared deeply about that didn't work and why didn't it work? What were the takeaways? What did you learn from it? I think it teaches you about how willing people are to take risks. It tells you have they experienced failure, what they learned from failure. And so I think it's always, you just get to know someone really well. It ends up in a well-rounded understanding of a person, if you can dig into that.

**中文翻译:**
我发现非常有启发性且有帮助的问题是：让人们谈谈他们做过的一个失败的项目，以及一个成功的项目。我觉得你可以从中了解到很多关于他们的自我反思和激情。特别是自我反思。如果他们谈论一件他们深切关注但最终失败的事情，为什么没成功？有什么收获？学到了什么？这能让你了解人们承担风险的意愿，了解他们是否经历过失败以及从中学到了什么。如果你能深入挖掘，你就能非常全面地了解一个人。

---

### [01:24:48] Lenny Rachitsky

**English:**
Is there a favorite product you recently discovered that you really like?

**中文翻译:**
你最近发现并非常喜欢的某个产品吗？

---

### [01:24:51] Kayvon Beykpour

**English:**
I love Proplexity. It's really interesting to me how Proplexity is a product that fits in your life and replaces a product that is so ingrained in people's behavior, which is using Google search for some set of use cases. And it's just really incredible to me how quickly Proplexity took that over. It is very hard actually to rewire your muscle memory if you're used to using Google for searching for 15, 20 years or whatever. It was just amazing to me how quickly my go-to became Proplexity. And frankly, it's one of the only non-development tool AI products that actually has retained. A lot of people try and consumer AI products that just aren't really, haven't retained. But Proplexity is one that it's a daily driver for me. It's on my home screen and I love it. I'm very impressed by it.

**中文翻译:**
我喜欢 Perplexity。对我来说非常有趣的是，Perplexity 作为一个产品如何融入你的生活，并取代了一个在人们行为中根深蒂固的产品——即在某些场景下使用谷歌搜索。Perplexity 如此迅速地接管了这一领域，这对我来说简直不可思议。如果你已经习惯使用谷歌搜索 15、20 年，要重塑肌肉记忆其实非常难。让我惊讶的是，Perplexity 竟然这么快就成了我的首选。坦率地说，它是少数几个真正留住了用户的非开发工具类 AI 产品之一。很多人尝试消费级 AI 产品，但留存率并不高。但 Perplexity 是我的日常必备工具，它就在我的手机首屏，我非常喜欢它，印象深刻。

---

### [01:25:45] Lenny Rachitsky

**English:**
Also a huge fan.

**中文翻译:**
我也是它的忠实粉丝。

---

### [01:25:46] Kayvon Beykpour

**English:**
Yeah. Here's a bias one, my wife is actually working on a startup called Particle, and they're the news experience with AI. And what I love about what they're doing is that for the first time they're like they've rethought what the form factor and the unit of content for news stories should be. Articles are a failed format, is my belief, and certainly their belief. And so they've really come up with an elegant and engaging experience for understanding what's happening in the world in a way that's purely powered by AI. And it's awesome. Again, hashtag biased husband, but it's amazing. It's in beta right now. You can sign up on the wait list. The URL is particlenews.ai. They're letting people in on beta. If you sign up, use coupon code hashtag #KayvonLenny. That's not a real code. But yeah, so that's amazing. So that would be my second pick.

**中文翻译:**
是的。这里有一个带偏见的推荐：我妻子正在做一家叫 Particle 的创业公司，他们是用 AI 打造的新闻体验。我喜欢他们的一点是，他们第一次重新思考了新闻故事的内容形态和单元。我认为“文章”是一种失败的格式，他们也这么认为。所以他们真的想出了一种优雅且吸引人的体验，纯粹由 AI 驱动，让你了解世界上正在发生的事情。这很棒。再次声明，我是个“带偏见的丈夫”，但它真的很神奇。目前正在内测，你可以去 particlenews.ai 申请加入候补名单。他们正在陆续放人进去。如果你注册，可以使用优惠码 #KayvonLenny（这不是真的代码）。总之，那很棒，这是我的第二个选择。

---

### [01:26:48] Kayvon Beykpour

**English:**
I'll give you a non-software one, which is actually a board game that I ran into, that I was gifted actually for my birthday. And it's called Crokinole. Have you heard of this game called Crokinole?

**中文翻译:**
我再给你推荐一个非软件类的，是我生日时收到的一款桌游，叫 Crokinole。你听说过这款游戏吗？

---

### [01:27:00] Lenny Rachitsky

**English:**
I have not.

**中文翻译:**
没听说过。

---

### [01:27:01] Kayvon Beykpour

**English:**
So Crokinole is Canadian. I think it's a Canadian board game and it's amazing to me because I've never seen a game be captivating to all age ranges. I love it. I play with my friends. My parents over Christmas were obsessed with this game. My daughter loves. It's a physical game. You flick a puck, like shuffleboard style, but miniaturized with a totally different set of mechanics. And it was just like seeing this game captivate, people of all age ranges was mind-blowing to me and it's really fun. So maybe a curveball answer for you there, but I think those are some of the products that I've been really enjoying and appreciating lately.

**中文翻译:**
Crokinole 是加拿大的，我想是一款加拿大的桌游。让我惊讶的是，我从未见过一款游戏能吸引所有年龄段的人。我喜欢它，我和朋友一起玩。我父母在圣诞节期间对这款游戏着迷。我女儿也喜欢。它是一款物理游戏，你像玩沙狐球那样弹射圆盘，但是缩小版的，有一套完全不同的机制。看到这款游戏能吸引所有年龄段的人，让我大开眼界，真的很有趣。这可能是一个出人意料的答案，但这些确实是我最近非常享受和欣赏的产品。

---

### [01:27:48] Lenny Rachitsky

**English:**
These are awesome answers. What's the name of that game again? I'm going to-

**中文翻译:**
这些答案太棒了。那游戏叫什么名字来着？我要——

---

### [01:27:48] Kayvon Beykpour

**English:**
Crokinole.

**中文翻译:**
Crokinole。

---

### [01:27:53] Lenny Rachitsky

**English:**
Okay. I don't don't know how to spell it, but I'm sure Google will help me figure it out. We'll link to it in the show notes.

**中文翻译:**
好。我不知道怎么拼，但我相信谷歌能帮我。我们会把它放在节目介绍的链接里。

---

### [01:27:56] Kayvon Beykpour

**English:**
C-R-O-K-I-N-O-L-E.

**中文翻译:**
C-R-O-K-I-N-O-L-E。

---

### [01:27:59] Lenny Rachitsky

**English:**
Great. I love the K in there. That makes it really fun. And by the way, I think it's also Particle.news looking at it. It's so cool. It's basically bullet points of news items and then it links to all the articles that have written about it. So it just summarizes, here's the things you need to know and it's beautiful.

**中文翻译:**
太好了。我喜欢里面的 K，听起来很有趣。顺便说一下，我看了一下，应该是 Particle.news。它非常酷，基本上是新闻要点的列表，然后链接到所有相关的报道文章。它总结了你需要知道的事情，而且界面很漂亮。

---

### [01:28:13] Kayvon Beykpour

**English:**
Yeah, basically they consume and aggregate everything that's happening in the world by among other things, ingesting articles and then crafting these story modules through them that are summarized by AI. And then they let you actually interrogate the news and ask questions. So leveraging LLMs and tool calls, it's able to actually help you understand what's happening in the world. And they also are building a social layer as well. So it was very cool. I'll definitely get you in the beta.

**中文翻译:**
是的，基本上他们通过摄取文章来消费和聚合世界上发生的一切，然后通过 AI 总结成故事模块。然后他们让你能够真正地“审问”新闻并提问。利用大语言模型（LLM）和工具调用，它能真正帮你理解世界上正在发生的事情。他们还在构建社交层。非常酷，我一定会让你加入内测。

---

### [01:28:39] Lenny Rachitsky

**English:**
This is actually amazing timing, because I was a huge fan of Artifact, the news app, and they're going away, so this is the next news app, so thanks for sharing that. Okay, two more questions. Do you have a favorite life motto that you often come back to or share with people that you find useful in work or in life?

**中文翻译:**
这时机真的太棒了，因为我是新闻应用 Artifact 的忠实粉丝，但他们要关停了，所以这就是下一个新闻应用。谢谢分享。好了，最后两个问题。你有没有最喜欢的人生格言，是你经常回想或分享给别人的，觉得在工作或生活中很有用？

---

### [01:28:57] Kayvon Beykpour

**English:**
Something that definitely shaped my work ethic and how I work that came from my first boss actually. When I was 14, I had a summer job basically replacing and doing maintenance on fire extinguishers. So I would drive into San Francisco, my boss would pick me up in his truck, we'd go to big commercial buildings, hospitals, high rises, and we would take all the fire extinguishers in the building, hundreds of them to the garage, empty them, fill them, tag them, inspect them. And that was my first job. And I don't even remember if I was getting paid. I was probably getting paid very small amount, but it was just first work experience. And I remember there was this moment that I had finished dealing with my extinguishers and I was just sitting in his truck twiddling my thumbs doing nothing. And my boss came up to me and was like, when you've got nothing to do, sweep never sit around.

**中文翻译:**
有一件事确实塑造了我的职业道德和工作方式，它其实来自我的第一任老板。我 14 岁时有一份暑期工，基本上是更换和维护灭火器。我会开车去旧金山，老板开卡车接我，我们去大型商业建筑、医院、高层建筑，把楼里所有的灭火器（几百个）搬到车库，清空、填充、贴标签、检查。那是我的第一份工作。我甚至不记得有没有报酬，可能有很少一点，但那是我的第一份工作经历。我记得有一次我处理完了我的灭火器，就坐在他的卡车里无所事事地玩手指。我老板走过来对我说：“当你没事可做的时候，就去扫地，永远不要闲坐着。”

---

### [01:29:57] Kayvon Beykpour

**English:**
And it was so funny, it was just very tiny moment, but I've never ever forgotten that. When you got nothing to do sweep. And it had such a profound impact on my work ethic of there's always something you can be doing to move the ball forward and being productive and being impactful. And I'm so grateful that Fred, my boss, had that moment with me. It was like, I don't even think he understands how impactful that was, but it felt so much a life motto, but it definitely stuck with me and shaped how I work.

**中文翻译:**
这很有趣，那只是一个非常微小的时刻，但我永远不会忘记。当你没事做时，就去扫地。这对我的职业道德产生了深远影响：总有一些事情你可以做来推动进展，保持高效并产生影响。我很感激我的老板 Fred 给了我那个时刻。我想他甚至不知道那句话的影响有多大，但它感觉就像一个人生格言，深深地印在我的脑海里，塑造了我的工作方式。

---

### [01:30:35] Lenny Rachitsky

**English:**
I love that you shared that story. I found that quote and story in GQ Magazine turns out is where you talked about this and I was going to ask about it and I didn't and I'm glad you shared it because I love it.

**中文翻译:**
我很喜欢你分享这个故事。我后来发现你在《GQ》杂志上也谈到过这段话和故事，我本来想问的，结果没问，很高兴你主动分享了，因为我很喜欢。

---

### [01:30:47] Lenny Rachitsky

**English:**
Final question, we're going to go full circle. Scott Belsky, you're friends with him. What's something people would be surprised about or don't know about Scott, that might be interesting?

**中文翻译:**
最后一个问题，我们要回到原点。Scott Belsky，你是他的朋友。关于 Scott，有什么会让人们感到惊讶或大家不知道的趣事吗？

---

### [01:30:58] Kayvon Beykpour

**English:**
Well, I'll tell you one funny story and then I'll first tell you something I love about Scott. Scott is a great example of someone who I think has driven immense cultural change at a massive, legendary company in Adobe obviously. But the number of transformations that Scott oversaw and led and contributed to at Adobe are incredible. And I'm sure having a fraction of this experience at Twitter, I can appreciate how difficult and challenging and rewarding that was, right? Going from package software to cloud, going from non-AI to AI, going from discrete tools to an integrated suite that worked really elegantly together. I think Scott oversaw a lot of this stuff and it's pretty incredible to see that transformation have been so successful at Adobe. So I love that.

**中文翻译:**
好吧，我先讲一个我喜欢 Scott 的地方，然后再讲一个有趣的故事。Scott 是一个很好的例子，他在 Adobe 这样一家庞大的传奇公司推动了巨大的文化变革。他在 Adobe 监督、领导并促成的转型次数是惊人的。在推特有过类似经历的我，能体会到那是多么困难、具有挑战性且充满回报。从套装软件转向云端，从非 AI 转向 AI，从离散工具转向优雅整合的套件。我想 Scott 监督了很多这样的工作，看到这种转型在 Adobe 如此成功，真的很不可思议。我非常欣赏这一点。

---

### [01:31:55] Kayvon Beykpour

**English:**
I guess a funny story about Scott that people might not know, I consider him to have been the first Periscoper. So Scott believed in Periscope before it was Periscope, before we had turned it into live video, we had a previous version of our beta that was static photo sharing, same vision, same concept, but the product was called Bounty. And it was like you put a pin somewhere in the world like the Tokyo fish market and someone would respond with a photo of what it looked like there.

**中文翻译:**
关于 Scott，人们可能不知道的一个趣事是：我认为他是第一个“Periscoper”（Periscope 用户）。Scott 在 Periscope 还没成为 Periscope 之前就相信它。在我们把它变成直播视频之前，我们的内测版是静态照片分享，愿景和概念一样，但产品叫 Bounty。就像你在地图上的某个地方（比如东京鱼市场）插个大头针，然后有人会回复一张那里的照片。

---

### [01:32:25] Lenny Rachitsky

**English:**
I didn't know that.

**中文翻译:**
我以前不知道这个。

---

### [01:32:26] Kayvon Beykpour

**English:**
Our vision was still to help you see through someone else's eyes, but the first manifestation was really static and had this marketplace dynamic, and it took us a while to get to the point where we were like, press a button, go live and have it be live video because by definition it's real time rather than static.

**中文翻译:**
我们的愿景仍然是帮你通过别人的眼睛看世界，但最初的表现形式是非常静态的，带有这种市场动态。我们花了一段时间才达到“按一下按钮，开始直播”的程度，因为从定义上讲，直播是实时的，而不是静态的。

---

### [01:32:42] Kayvon Beykpour

**English:**
Anyways, before we built any of that, when we were playing with the idea and Scott was encouraging us to go in this direction, I remember probably the second time I ever met Scott, we did it FaceTime and he was at the TED conference, I want to say it was in Vancouver, and just to illustrate how cool it would be when he accepted the FaceTime and he's like, "Cool, and I'm going to take you on a Periscope." And he flipped this camera and started walking around the TED conference and basically pretending like he was prototyping the product, but using FaceTime. And it was such an amazing experience because having an investor essentially encourage you down a product direction by showing rather than telling, it was such a great encapsulation of how supportive Scott was and inspiring Scott was as one of our cheerleaders. And I respect him so much for everything he did to help Periscope make happen, and also for betting on us, because he was one of the first people who said yes to investing. He didn't know us, he just believed in us. And that helped everything else come together. And yeah, he's amazing.

**中文翻译:**
总之，在我们构建这些之前，当我们还在构思这个想法，而 Scott 鼓励我们朝这个方向发展时，我记得大概是我第二次见 Scott，我们通过 FaceTime 通话。他当时在温哥华参加 TED 大会，为了说明这有多酷，他接通 FaceTime 后说：“酷，我现在带你体验一下 Periscope。”然后他翻转摄像头，开始在 TED 会场走动，基本上是在用 FaceTime 模拟产品的原型。那是一次非常奇妙的经历，因为一个投资者通过“展示”而不是“说教”来鼓励你的产品方向，这完美地体现了 Scott 作为我们的支持者是多么给力和具有启发性。我非常尊敬他为促成 Periscope 所做的一切，也感谢他敢于在我们身上下注，因为他是第一批同意投资的人之一。他不认识我们，他只是相信我们。这促成了后来的一切。是的，他很了不起。

---

### [01:33:48] Lenny Rachitsky

**English:**
What a mensch.

**中文翻译:**
真是个大好人（mensch）。

---

### [01:33:48] Kayvon Beykpour

**English:**
What a mensch.

**中文翻译:**
确实是大好人。

---

### [01:33:49] Lenny Rachitsky

**English:**
We've got to get him back on the podcast. The story reminds me of your Elon's story, where he FaceTimed you, and it also makes me think about your lesson of building consumer products, just using it, being obsessed with it, Scott, just like, here's what it could look like. And actually using the product, not just talking about.

**中文翻译:**
我们得再请他来一次播客。这个故事让我想起了你和埃隆的故事，他也给你打了 FaceTime。这也让我想起你关于构建消费级产品的教训：去使用它，痴迷于它。Scott 就像是在说：“看，它可能是这个样子的。”他是真的在用产品，而不仅仅是空谈。

---

### [01:34:04] Kayvon Beykpour

**English:**
Yeah, he's a great example of that as well. He's definitely a gracious user of all tools and products, and that's why he has really great, really great product sense.

**中文翻译:**
是的，他也是这方面的一个绝佳例子。他绝对是所有工具和产品的热心用户，这就是为什么他拥有非常、非常出色的产品感。

---

### [01:34:15] Lenny Rachitsky

**English:**
Kayvon, you're amazing. This was so freaking fascinating. There's so many nuggets here. Can't wait for folks to hear this. Two final questions. Where can folks find you if they want to reach out and learn more and maybe follow up on anything if there's things you want to follow up on potentially? And then, how can listeners be useful to you?

**中文翻译:**
Kayvon，你太棒了。这期节目真的太迷人了，里面有太多的干货。迫不及待想让大家听到。最后两个问题：如果大家想联系你、了解更多或者跟进某些事情，可以在哪里找到你？以及，听众可以为你提供什么帮助？

---

### [01:34:30] Kayvon Beykpour

**English:**
People can find me on Twitter/X/whatever we're calling it these days. My handle is @kayvz, K-A-Y-V-Z. And yeah, if you're of this podcast and you're working on something cool and you need some help or advice or you're looking for an angel investor, don't hesitate to reach out and would love to try what you're building.

**中文翻译:**
大家可以在 Twitter/X（不管现在叫什么）上找到我。我的账号是 @kayvz。如果你是这个播客的听众，正在做一些酷的事情，需要帮助、建议或者正在寻找天使投资人，请随时联系我，我很乐意尝试你正在构建的东西。

---

### [01:34:51] Lenny Rachitsky

**English:**
Amazing. And also check out Particle.news.

**中文翻译:**
太棒了。大家也去看看 Particle.news。

---

### [01:34:53] Kayvon Beykpour

**English:**
There you go.

**中文翻译:**
没错。

---

### [01:34:54] Lenny Rachitsky

**English:**
Support the wife.

**中文翻译:**
支持一下夫人。

---

### [01:34:55] Kayvon Beykpour

**English:**
Exactly.

**中文翻译:**
正是如此。

---

### [01:34:56] Lenny Rachitsky

**English:**
Amazing. All right, Kayvon, thank you so much for being here.

**中文翻译:**
太棒了。好了，Kayvon，非常感谢你能来。

---

### [01:34:59] Kayvon Beykpour

**English:**
Thanks Lenny. Great to meet you.

**中文翻译:**
谢谢 Lenny。很高兴见到你。

---

### [01:35:00] Lenny Rachitsky

**English:**
Bye everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
大家再见。非常感谢收听。如果你觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用上订阅本节目。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。