# Ken Norton - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Ken Norton.

---

### [00:00:00] [Ken Norton]

**English:**
Part of what I think is pretty exciting about product management is you are a leader from day one in product management. There's leadership all over the place, but that's your job. You're a leader. You don't have any formal authority, but you're a leader. You're expected to lead.

**中文翻译:**
我认为产品管理中非常令人兴奋的一点是，从进入这个领域的第一天起，你就是一名领导者。领导力无处不在，但这就是你的工作。你是一名领导者。虽然你没有任何正式的职权，但你就是领导者。人们期望你发挥领导作用。

---

### [00:00:22] [Lenny]

**English:**
Over his 14-year career at Google. Ken Norton led product teams at built Google Docs, Google Calendar, Google Maps, and even did a stint at Google Ventures. The products that he's helped craft are now used by over three billion people.
(00:00:37):
Today Ken is a full-time executive coach specializing at working with product leaders. In our conversation, we cover the creative versus reactive mindset, why the art of product management is much more important than the science of product management, how to get over imposter syndrome, the most common PM blind spots, how to find a coach and how to know if a coach is right for you, and so much more. I hope that you enjoy this episode with Ken Norton.

**中文翻译:**
在谷歌 14 年的职业生涯中，Ken Norton 领导的产品团队打造了 Google Docs、Google Calendar、Google Maps，甚至还在 Google Ventures（谷歌风投）工作过一段时间。他参与打造的产品现在拥有超过 30 亿用户。
(00:00:37):
如今，Ken 是一名全职高管教练，专门为产品领导者提供辅导。在我们的对话中，我们讨论了“创造型”与“反应型”心态、为什么产品管理的艺术远比科学重要、如何克服冒充者综合征、PM 最常见的盲点、如何寻找教练以及如何判断教练是否适合你，等等。希望你们喜欢这集与 Ken Norton 的对话。

---

### [00:01:05] [Lenny]

**English:**
If you're setting up your analytics stack but you're not using Amplitude, what are you doing? Amplitude is the number one most popular analytics solution in the world, used by both big companies like Shopify, Instacart, and Atlassian, and also most tech startups. Amplitude has everything you need, including a powerful and fully self-service analytics product, an experimentation platform, and even an integrated customer data platform to help you understand your users like never before.
(00:01:33):
Give your teams self-service product data to understand your users, drive conversions, and increase engagement, growth, and revenue. Get your vanity metrics, trust your data, work smarter, and grow your business. Try Amplitude for free. Just visit amplitude.com to get started.

**中文翻译:**
如果你正在搭建分析栈（analytics stack）但没有使用 Amplitude，那你还在等什么？Amplitude 是全球排名第一的最受欢迎的分析解决方案，不仅被 Shopify、Instacart 和 Atlassian 等大公司使用，也被大多数科技初创公司采用。Amplitude 拥有你所需的一切，包括强大且完全自助的分析产品、实验平台，甚至是集成的客户数据平台，帮助你以前所未有的方式了解用户。
(00:01:33):
为你的团队提供自助式产品数据，以了解用户、推动转化并增加参与度、增长和收入。告别虚荣指标，信任你的数据，更聪明地工作，并发展你的业务。免费试用 Amplitude，只需访问 amplitude.com 即可开始。

---

### [00:01:53] [Lenny]

**English:**
Have you heard of Lenny's Job Board? Well, if you're hiring or open to a new gig, have I got the site for you, lennysjobs.com. If you're a hiring manager, sign up and get access to hundreds of hand-curated people who are open to new opportunities. Thousands of people apply. And I personally review and accept just 10% of them to be part of this collective. You won't find a better place to hire product managers and growth people.
(00:02:18):
If you're someone who's looking around for someone new, join the collective. It's free. You can be anonymous and hide yourself from any company. You can also leave anytime. You'll only hear from companies that you want to hear from. Check out lennysjobs.com to learn more.

**中文翻译:**
你听说过 Lenny 的招聘板（Job Board）吗？如果你正在招聘或正在寻找新机会，我为你准备了一个网站：lennysjobs.com。如果你是招聘经理，注册后即可接触到数百名经过人工筛选、正在寻找新机会的人才。成千上万的人申请，而我个人只审核并接受其中 10% 的人加入这个人才库。你找不到比这更好的地方来招聘产品经理和增长人才了。
(00:02:18):
如果你正在寻找新机会，欢迎加入这个人才库。它是免费的，你可以保持匿名并对任何公司隐藏自己。你也可以随时退出。你只会收到你感兴趣的公司的消息。访问 lennysjobs.com 了解更多信息。

---

### [00:02:38] [Lenny]

**English:**
Welcome to the podcast, Ken. I am so honored to have you here. You're such a legend of product managers and product management circles. Your writing has had so much influence on so many people, including myself. If nothing else, you've led to many donuts being purchased by tech companies over the years. So thanks for being here.

**中文翻译:**
欢迎来到播客，Ken。非常荣幸能邀请到你。你是产品经理和产品管理界的传奇人物。你的文章对包括我在内的许多人都产生了巨大的影响。即便不说别的，这些年来你也促使科技公司购买了大量的甜甜圈。所以，感谢你的到来。

---

### [00:02:58] [Ken Norton]

**English:**
Thank you and thanks for having me. The feeling's mutual. Obviously a big fan of your work and all the things you've done for the community and this podcast, which has been fantastic. So humbled and excited to be here. Yes, I do think that I'm at least maybe partially responsible for at least a lot of consumption of donuts over these years.

**中文翻译:**
谢谢你，也谢谢你的邀请。我也深有同感。显然，我是你作品的大粉丝，也非常欣赏你为社区所做的一切以及这个精彩的播客。能来到这里我感到很荣幸也很兴奋。是的，我也认为这些年来甜甜圈的大量消耗，我至少要负一部分责任。

---

### [00:03:18] [Lenny]

**English:**
Are you tired of people asking you about donuts?

**中文翻译:**
你会厌倦人们总是问你关于甜甜圈的事吗？

---

### [00:03:21] [Ken Norton]

**English:**
I'll never get tired of it. Well, back when we met with people in person, people would bring me donuts, and I never got tired of it, nor did any of the people that I worked with who got to eat those donuts get tired of it. So, no, no, I'll never get tired of donuts.

**中文翻译:**
我永远不会厌倦。以前我们线下见面时，人们会给我带甜甜圈，我从不厌倦，和我一起工作的那些吃到甜甜圈的人也从不厌倦。所以，不，不，我永远不会厌倦甜甜圈。

---

### [00:03:37] [Lenny]

**English:**
Someone on Twitter asked what's a digital equivalent of bringing the donuts now that we're in a remote world. Do you have any advice on that?

**中文翻译:**
推特上有人问，既然现在是远程办公时代，“带甜甜圈”的数字化等价物是什么？你对此有什么建议吗？

---

### [00:03:45] [Ken Norton]

**English:**
That's a great question. I'm not even sure if the physical equivalent of donuts is donuts. I mean when I came up with that, I think it was really to be a metaphor around being a servant leader, bringing whatever needs to be done, filling the white space, filling the gaps, whatever needed to happen. So it doesn't always have to be donuts.
(00:04:07):
I did put that question out to some of the readers in my newsletter a while ago, maybe earlier in the pandemic, and got a lot of really interesting ideas. Maybe that was at a place where people had a little bit more patience for happy hours over Zoom and stuff like that. Maybe that patient set is worn out. The idea that I love the most was actual donuts. There was a PM who got DoorDash codes and found the best local donut place for each of the people on the team and basically sent them a code and said, "Click here and order the donuts to come to your house whenever you want them." So maybe at least partially the digital equivalent of donuts might be actual donuts.

**中文翻译:**
这是一个好问题。我甚至不确定甜甜圈的物理等价物是否就是甜甜圈本身。我的意思是，当我提出这个概念时，它实际上是一个关于“仆人式领导”（servant leader）的隐喻——去做任何需要做的事情，填补空白，弥补差距，无论需要发生什么。所以它并不总是必须是甜甜圈。
(00:04:07):
不久前，可能是在大流行初期，我在时事通讯中向读者提出了这个问题，并得到了很多有趣的反馈。也许那时候人们对 Zoom 上的欢乐时光（happy hours）之类的事情还有点耐心，现在可能已经耗尽了。我最喜欢的点子其实还是真正的甜甜圈。有一位 PM 购买了 DoorDash 的代金券，并为团队中的每个人找到了当地最好的甜甜圈店，然后发给他们一个代码说：“点击这里，随时订购甜甜圈送到你家。”所以，也许甜甜圈的数字化等价物在某种程度上还是真正的甜甜圈。

---

### [00:04:40] [Lenny]

**English:**
Decentralized donuts.

**中文翻译:**
去中心化甜甜圈。

---

### [00:04:42] [Ken Norton]

**English:**
Decentralized donuts, on the blockchain.

**中文翻译:**
去中心化甜甜圈，在区块链上。

---

### [00:04:46] [Lenny]

**English:**
Oh boy, let's not go there.

**中文翻译:**
噢天哪，我们还是别聊那个了。

---

### [00:04:48] [Ken Norton]

**English:**
I don't know what that is.

**中文翻译:**
我甚至不知道那是什么。

---

### [00:04:50] [Lenny]

**English:**
So I was perusing your career path ahead of this chat. You had this pretty wild career. You were an engineer initially, and then you were CTO at a part of NBC. Then you're a founder. Then you spent 14 years at Google working on products that folks may have heard of, like Google Docs and Google Calendar and Google Maps. You've also done a bunch of writing. Then more recently, you've become a full-time executive coach focusing on product people.
(00:05:17):
I have so many questions I'd love to ask you about your career and learnings along the way, and the writing. But I'd actually like to spend most of our time talking about the coaching and things that you've learned through that experience. And so, I have a couple questions just off the bat. What does an executive coach actually do? What kinds of things are you helping people with? What does a session look like? Then, two, just how did you decide you wanted to be a coach full time after leaving Google?

**中文翻译:**
在这次聊天之前，我仔细研究了你的职业路径。你的职业生涯相当精彩。你最初是一名工程师，然后担任过 NBC 旗下部门的 CTO。接着你成为了一名创始人。随后你在谷歌度过了 14 年，参与了大家耳熟能详的产品，如 Google Docs、Google Calendar 和 Google Maps。你还写了很多文章。最近，你成为了一名全职高管教练，专注于辅导产品人才。
(00:05:17):
关于你的职业生涯、一路走来的感悟以及写作，我有很多问题想问。但我实际上想把大部分时间花在谈论教练工作以及你通过这段经历学到的东西上。所以，我有几个开门见山的问题。高管教练实际上是做什么的？你都在哪些方面帮助别人？一次辅导课程是什么样的？第二，你是如何决定在离开谷歌后全职做教练的？

---

### [00:05:40] [Ken Norton]

**English:**
Yeah, that's a great question. I think coaching does mean a lot of different things. I mean it depends on who you talk to. It is a little bit of who you are, your style, your approach. Some people are calling themselves coaches, doing more mentoring, more advice. Other people are maybe more like me, more peer coaching.
(00:06:01):
To me, I see executive coaching as a partnership or creative partnership. It's all about helping my client reach their goals, their potential, whatever that means to them. So an important thing about coaching is the definition of success does belong to the client. I don't have an agenda. I don't have a set of things I'm trying to share, teach, learn. It really is fundamentally up to them, which means every client is completely different. They have different sense of where they want to go. Different barriers that might be standing in their way.
(00:06:35):
My coaching practice, I coach the whole person. So there is no restriction on what we might talk on, what we might work on together. It's not limited to product. It's not even limited to work or even leadership. It's wherever they want to go, whatever change, transformation means to them.
(00:06:52):
As coaches, we bring a bunch of tools to the conversation. The most important ones, honestly, are probably listening and curiosity, intuition, open-mindedness, really there to help challenge them to see things in different ways, help them tap into their imagination, figure out when there might be underlying beliefs, help them connect dots that need to be connected, help them disconnect things that feel connected. There's a lot of exploration to it.
(00:07:20):
It's very jazz-like. My love of jazz has been shared before, but there is an improvisation to it. What coaching is really powerful is you may not necessarily know where you're going when you start and you follow wherever there is meaning and change for that individual, wherever is they want to go.
(00:07:38):
The question around what brought me into it was actually interesting. I, honestly working with my own executive coach, started to figure out what it is that mattered to me, what I liked, what my values were, what my purpose was, started to unpack that I love deeply connecting with people and I love helping people change and grow.
(00:08:01):
The moments when I had the opportunity to do that as a manager, as a product leader were the most fulfilling parts of my career. And so, I started to unpack that and figure out what would it look like if that was what I did.
(00:08:15):
The other part of the journey was, for several years at Google, I worked at GV. It's Google Ventures, Google's venture capital arm. I had the opportunity to work with founders and product leaders in the portfolio. I started to simultaneously recognize the shortcomings of giving advice, because it seemed like, well, I can meet with these folks, I could tell them what I did, I could tell them what Google did, and that'll answer all their questions.
(00:08:41):
You start to realize advice is not as powerful as you might think it is. It's a little bit like cotton candy. Doesn't have a lot of nutrition. You get a nice sugar high. You feel great, both sides feel happy, but then a couple weeks later, a couple months later, nothing's really changed.
(00:08:57):
That's because it doesn't often confront the real problem. It often isn't relevant. Like what worked for us at Google may not have worked anywhere else. It may not even have worked at Google for all I know. I feel like there were years at Google where all we were doing was making things worse by showing up and we should just all have gone sat on a beach somewhere, and the company would've grown even faster. So who knows?
(00:09:20):
I mean so it was these just twin pillars of wanting to figure out where I could do what I like the most, and then also recognizing that where growth comes from is less around advice and telling people what to do and more about helping them figure out their own path, their own way. Then that ultimately you brought me into, hey, I want to do this full time, and that's what I've been doing ever since.

**中文翻译:**
是的，这是一个很好的问题。我认为“教练”（coaching）确实意味着很多不同的东西。这取决于你和谁交谈。这在一定程度上取决于你是谁、你的风格和你的方法。有些人自称为教练，但做的是更多的导师工作（mentoring）和提供建议。其他人可能更像我，做的是更多的同伴教练（peer coaching）。
(00:06:01):
对我来说，我将高管教练视为一种伙伴关系或创造性的伙伴关系。它的核心是帮助我的客户实现他们的目标、挖掘他们的潜力，无论这对他们意味着什么。所以教练工作中很重要的一点是，成功的定义权属于客户。我没有预设的议程。我没有一套想要分享、教授或学习的东西。这从根本上取决于他们，这意味着每个客户都是完全不同的。他们对想去的地方有不同的感觉，面临的障碍也各不相同。
(00:06:35):
在我的教练实践中，我辅导的是“完整的人”（whole person）。所以我们谈论的内容、共同努力的方向没有任何限制。它不限于产品，甚至不限于工作或领导力。它关乎他们想去的任何地方，以及改变和转型对他们意味着什么。
(00:06:52):
作为教练，我们为对话带来了一系列工具。老实说，最重要的可能是倾听、好奇心、直觉和开放的心态，真正去挑战他们以不同的方式看待事物，帮助他们挖掘想象力，找出可能存在的潜在信念，帮助他们连接需要连接的点，或者断开那些感觉相连但其实不应相连的事物。这其中有很多探索的过程。
(00:07:20):
这非常像爵士乐。我以前分享过我对爵士乐的热爱，教练工作也有一种即兴性。教练真正强大的地方在于，你开始时未必知道要去哪里，你只是跟随对那个人有意义和能带来改变的地方，跟随他们想去的地方。
(00:07:38):
关于是什么让我进入这个行业的，这其实很有趣。老实说，是通过与我自己的高管教练合作，我开始弄清楚什么对我重要，我喜欢什么，我的价值观是什么，我的目标是什么。我开始发现，我热爱与人建立深层的联系，我热爱帮助人们改变和成长。
(00:08:01):
当我作为经理、作为产品领导者有机会这样做时，那是我职业生涯中最有成就感的时刻。于是，我开始思考，如果这就是我的全职工作，那会是什么样子。
(00:08:15):
这段旅程的另一部分是，在谷歌的几年里，我在 GV（谷歌风投）工作。我有机会与投资组合中的创始人和产品领导者合作。我开始同时意识到“提供建议”的局限性。因为看起来，我可以和这些人见面，告诉他们我做了什么，告诉他们谷歌做了什么，这就能回答他们所有的问题。
(00:08:41):
但你开始意识到，建议并不像你想象的那么强大。它有点像棉花糖，没有多少营养。你会得到短暂的血糖升高，感觉很棒，双方都很开心，但几周或几个月后，什么都没有真正改变。
(00:08:57):
那是因为建议通常没有直面真正的问题，而且往往不相关。比如在谷歌对我们有效的方法，在其他任何地方可能都行不通。据我所知，它甚至在谷歌内部也未必一直有效。我觉得在谷歌的某些年份里，我们所做的一切只是让事情变得更糟，如果我们都去海滩坐着，公司可能会发展得更快。谁知道呢？
(00:09:20):
所以，正是这两个支柱——一方面想弄清楚在哪里可以做我最喜欢的事，另一方面意识到成长的源泉不在于建议和告诉别人该做什么，而在于帮助他们找到自己的道路。这最终让我决定：“嘿，我想全职做这件事。”从那以后我就一直从事这项工作。

---

### [00:09:46] [Lenny]

**English:**
When do you find people come to you to get advice and coaching? What kind of clients do you find you end up working with?

**中文翻译:**
你发现人们通常在什么时候会来找你寻求建议和辅导？你最终合作的都是什么样的客户？

---

### [00:09:53] [Ken Norton]

**English:**
That's a great question. Generally speaking, I work with senior product leaders, however you want to define that. Typically, these are chief product officers, VPs of product at startups, largely director level and above at bigger tech companies, some CEOs, other C-level execs in there. I think really anyone that considers themselves in a product leadership role.
(00:10:15):
Often they come to me because there's a career milestone or a crossroads, and it could be that they now find themselves in the position of being a CPO for the first time. Maybe there's a new industry change, or they've gone from a big company to a startup and a have this sense of what got me here isn't going to get me there. That's oftentimes when they reach out for coaching.
(00:10:41):
I think my clients are also very introspective and surrounded by great mentors and advisors and have all sorts of people in their life who can help them, but are realizing that a lot of the work is going to be internal work that's going to get them to the next level. And so, this transformation is going to be just as much what I need to do as who I am. That's often when people come to me.

**中文翻译:**
这是一个好问题。总的来说，我的合作对象是资深产品领导者，无论你怎么定义这个词。通常，他们是首席产品官（CPO）、初创公司的产品副总裁（VP of Product），在大公司主要是总监级（Director）及以上，还有一些 CEO 和其他 C 级高管。我认为任何认为自己处于产品领导岗位的人都是我的潜在客户。
(00:10:15):
通常他们来找我是因为遇到了职业里程碑或十字路口。可能是他们第一次担任 CPO；可能是行业发生了新变化；或者他们从大公司跳槽到了初创公司，并产生了一种“过去让我成功的经验，无法带我走向未来”的感觉。这通常是他们寻求教练辅导的时候。
(00:10:41):
我认为我的客户也非常善于反思，他们身边围绕着优秀的导师和顾问，生活中也有各种可以帮助他们的人。但他们意识到，要达到下一个层次，很多工作将是“内在工作”。这种转型不仅关乎“我需要做什么”，更关乎“我是谁”。这通常是人们来找我的时候。

---

### [00:11:08] [Lenny]

**English:**
You said that the way you coach is about the whole person. I'm curious ... I don't know if there's an answer to this, but when people come to get help and coaching, how much of their blocks, I guess, are rooted in their regular life versus skills, technical skills, and more like the PME, product leadership side, if that makes sense?

**中文翻译:**
你说你的教练方式是针对“完整的人”（whole person）。我很好奇……我不知道这是否有标准答案，但当人们来寻求帮助和辅导时，他们的障碍有多少是根植于日常生活，又有多少是根植于技能、技术能力，或者更偏向产品领导力（PM 业务）方面的？

---

### [00:11:31] [Ken Norton]

**English:**
Yeah, I think ... Well, let me maybe try to illustrate this with an example from my life right now. Indulge me, I'm going to go a little bit left field here, but I promise [inaudible 00:11:45].

**中文翻译:**
是的，我想……好吧，让我试着用我现在生活中的一个例子来说明这一点。请包容一下，我要说一个稍微有点离题的话题，但我保证……（听不清）。

---

### [00:11:45] [Lenny]

**English:**
Let's do it.

**中文翻译:**
开始吧。

---

### [00:11:46] [Ken Norton]

**English:**
So we are teaching our 16-year-old son how to drive. So he just got his driver's permit. Do you remember when you learned how to drive, Lenny?

**中文翻译:**
我们正在教 16 岁的儿子开车。他刚拿到驾驶许可证。Lenny，你还记得你学开车的时候吗？

---

### [00:11:56] [Lenny]

**English:**
I do. Yup.

**中文翻译:**
记得，当然。

---

### [00:11:58] [Ken Norton]

**English:**
Yeah. Yeah. So it's scary. I don't know if you know how your parents might have felt, but-

**中文翻译:**
是的，那很吓人。我不知道你是否了解你父母当时的感受，但是——

---

### [00:12:04] [Lenny]

**English:**
Nope, [inaudible 00:12:06].

**中文翻译:**
不了解，（听不清）。

---

### [00:12:06] [Ken Norton]

**English:**
... [inaudible 00:12:06] on the other side of it. It's a whole new journey. Look, he's a smart kid. He's going to do great. But it helped me actually think back to when I learned how to drive. Actually, what I think is maybe a little bit more important here is before you learn to drive. And so, if you think about it as a ... When you're a kid, cars just go places. You get strapped in and you just wait and you get impatient. Then eventually you go somewhere. You're not even consciously aware of the concept of driving. Just cars just happen and you're not even aware of it.
(00:12:41):
As you get a little bit older, you start to become curious. You start to figure out, oh, that wheel has something to do with it. You turn the wheel. Maybe you start to understand there's pedals. But it also just seems really simple. Just like you get in the car and you drive it and you go somewhere. Maybe as you get older, you end up maybe even being a little bit of a smart Alec about how easy it looks and you start talking to your parents about, like, "It doesn't look hard. I can do this."
(00:13:07):
Now suddenly you're behind the wheel of the car. This is what my son is doing. Wow. Is it different than you thought it was going to be? Is it way more complicated? You have to remember check your mirrors. You've got to look before you turn. You didn't even know what that sign meant. You didn't know what those stripes meant. It is just overloading with complication and your internal mindset for confronting this challenge is not going to suit you the way you used to approach the world.
(00:13:44):
Maybe to put it in product leadership, product terms, everyone around you has got some real pithy advice about the things you're forgetting to do. It's like, "Hey, don't forget to check your mirror." Everyone's got a framework. It's like, "Ah, do you know about the 10:00 and 2:00 framework?" "Wait, what's the 10:00 and 2:00 framework?" "Oh, you just put your left hand on the 10:00, your right hand on the 2:00. That's the only thing you're missing. Here's a great medium post about that." Then you're like, "This is a problem is I have not adapted to the complexity of the world around me."
(00:14:19):
And so, there is this sense that what is interesting about driving is the world hasn't gotten any more complex. Driving's always been driving. But now your place in the world has shifted such that the internal meaning-making and self-complexity that is required requires a complete reboot of the internal operating system in order to allow you to thrive there.
(00:14:41):
And so, when you talk about this question of how much of this is skills, how much of this is tactics, how much of this is learning versus how much is internal growth, the answer is it's both, but the shift that is required is very much around how your inner self can make meaning and respond to the demands of the world around you so that you can succeed and thrive in this mindset shift that happens.
(00:15:09):
The skills matter, but by this point, you're beyond the place where you've learned the skills. There's mastering the skills, but there is this sense of what developmental psychologists call self-complexity, the ability to respond and adapt to that.
(00:15:24):
And so, I think we go through a lot of those shifts in our career. The driving example is simple. Actually, probably too simple, because the world is actually getting more complex for those of us that work in product. I mean every day something changes. It forces us to respond and adapt. So there aren't even rules of the road in product.
(00:15:42):
But I think this is what we're talking about, this question of the internal operating system I develop my ability to restructure it such that I can succeed given the demands that have been placed upon me.

**中文翻译:**
……（听不清）在另一边。这是一个全新的旅程。听着，他是个聪明的孩子，他会做得很好。但这确实让我回想起我学开车的时候。实际上，我认为这里更重要的一点是“学会开车之前”。如果你想一想……当你还是个孩子时，车只是带你去某个地方。你系好安全带，等待，变得不耐烦，然后最终到达目的地。你甚至没有意识到“驾驶”这个概念。车只是在运行，你甚至没有察觉。
(00:12:41):
当你长大一点，你开始好奇。你开始发现，哦，那个方向盘和驾驶有关。你转动方向盘。也许你开始明白还有踏板。但它看起来仍然非常简单。就像你上车，开走，然后到达某个地方。也许随着年龄增长，你甚至会自作聪明地觉得这看起来很容易，你会对父母说：“这看起来不难，我能行。”
(00:13:07):
现在，你突然坐在了驾驶座上。这就是我儿子正在经历的。哇，这和你想的一样吗？是不是复杂得多？你必须记得检查后视镜。转弯前必须观察。你甚至不知道那个标志是什么意思，不知道那些条纹意味着什么。复杂性让你超负荷，你过去应对世界的心态已经不再适用于这个挑战了。
(00:13:44):
如果用产品领导力或产品术语来说，你周围的每个人都会给你一些简练的建议，告诉你忘记做的事情。比如：“嘿，别忘了看后视镜。”每个人都有一个框架。比如：“啊，你知道‘10 点和 2 点’框架吗？”“等等，什么是 10 点和 2 点框架？”“哦，就是把左手放在 10 点钟位置，右手放在 2 点钟位置。这就是你唯一缺少的。这里有一篇关于这个的优秀 Medium 文章。”然后你会觉得：“问题在于，我还没有适应周围世界的复杂性。”
(00:14:19):
所以，关于驾驶有趣的一点是，世界并没有变得更复杂。驾驶一直就是驾驶。但现在你在世界中的位置发生了转变，以至于所需的内在意义构建和自我复杂性需要对内在操作系统进行彻底重启，才能让你在那里茁壮成长。
(00:14:41):
所以，当你谈论有多少是技能、有多少是战术、有多少是学习，而有多少是内在成长时，答案是两者兼而有之。但所需的转变主要在于你的内在自我如何构建意义，并对周围世界的需求做出反应，从而让你在这种心态转变中获得成功和发展。
(00:15:09):
技能很重要，但到这一步，你已经超越了单纯学习技能的阶段。虽然还有技能的精进，但更多的是发展心理学家所说的“自我复杂性”（self-complexity），即应对和适应这种复杂性的能力。
(00:15:24):
我认为我们在职业生涯中会经历很多这样的转变。驾驶的例子很简单，实际上可能太简单了，因为对于我们这些从事产品工作的人来说，世界实际上变得越来越复杂。每一天都在发生变化，迫使我们做出反应和调整。在产品领域，甚至没有所谓的“交通规则”。
(00:15:42):
但我认为这就是我们要讨论的：关于内在操作系统的问题，我培养了重构它的能力，以便在面对施加于我的需求时能够取得成功。

---

### [00:15:57] [Lenny]

**English:**
What an amazing analogy. Totally hits home in a good and bad way. It's a really good segue to something I wanted to chat about, something that we talked about before the recording, which is what you're finding to be one of the bigger unlocks for your clients. It's also a concept that you've been spending a lot of time refining and you're finding is helping people shift, and specifically shift their leadership mindset. And so, I'd love to just hear you talk through your thinking there.

**中文翻译:**
多么棒的类比。无论从好还是坏的方面看，都让人感同身受。这很好地引出了我想聊的话题，也就是我们在录音前谈到的，你发现的能为客户带来重大突破的关键点之一。这也是一个你花了很多时间完善的概念，你发现它正在帮助人们实现转变，特别是领导力心态的转变。所以，我很想听听你在这方面的思考。

---

### [00:16:24] [Ken Norton]

**English:**
Yeah, it does sort lead into this. Maybe another analogy that might work for your listeners, if you think about product management, your career arc and where you are challenged from a mindset perspective, in some ways it does feel like the early part of your career. You're learning to play a video game. Hopefully there's a tutorial. Your first job is learning the ropes, somebody's teaching you. You maybe have managers that are giving you simple little missions that you can succeed at and if you fail, the consequences aren't bad.
(00:17:03):
It does feel like a little bit ... And I felt this way, and I talked to a lot of people earlier in their career. It does feel like you're trying to learn the rules of the game, trying to figure out the physics. You want to run up the score.
(00:17:15):
You get better at playing the game. You fail, but you start to develop some confidence that when you fail, you'll learn from it. You'll get better. You get really good at the game. You get promoted, you get rewarded, you unlock new levels, teach other people how to play the game. You start to feel really awesome about yourself.
(00:17:32):
But then suddenly you're put in a place where you realize that the rules of the game aren't so black and white. Maybe there's a long delay now between when you get to see what you did and the score of it. Things start to behave in unexpected ways. The physics start to get weird. You're on a level where you're floating. I don't know what the right metaphor is here.
(00:17:52):
But you start to recognize that there's been this huge change. The most frightening part about it is you look around and everyone is looking at you like you're the designer of the game, and you thought you were playing. That's often what it feels like when you move into a leadership role, to come back to this sense of what got me here is not going to get me there.
(00:18:17):
I work with a lot of leaders and sometimes that's come with a pretty significant cost, this juxtaposition, maybe your happiness, your health, your marriage. There's been this existential crisis of I don't know if I love this anymore. Maybe it leads to burnout. Maybe it's not even that dire. It's just a sense of, well, I'm looking around and I need to be something. I need to unlock something else to continue on this path. There is a sense of stuckness that comes from that.
(00:18:45):
What I've come to realize is this is the precipice of, I think, this pretty fundamental concept in leadership. I'm not the originator of this, so this has come up again and again and again. It's not new. It's going to sound familiar. It's like the flood myth from Gilgamesh showing up in all this oral histories of the world. It's not new.
(00:19:10):
Conscious Leadership Group, an organization that I'm big fan of, they call it above the line versus below the line. Brene Brown calls it daring versus armored leadership, sage versus warrior. Even in the world of sports, there's playing to win versus playing not to lose. It's this concept that's come up again and again. Leadership Circle calls it creative versus reactive, and that's the term I'm going to use. I like that.
(00:19:35):
Here's the distinction. Very simple. Are you responding to the world from a place of fear, where you see problems and threats, you want to be right, you want to be liked, you're defensive as an inward approach, or are you responding to the world from a place of openness, possibility, curiosity, passion, growth, purpose? Very simple concept. Pretty much everyone understands what I mean. It makes sense.
(00:20:11):
Everyone also then immediately says a couple of different things. "That sounds amazing. I'd rather have that," or, "Here are moments when I've felt that," but that's usually followed up by a couple of questions. "I don't know if that works. It doesn't sound very effective. Is it possible?" Then how do you that?
(00:20:38):
The effective part is actually a question we can answer, which is, yes, it is more effective. Bob Anderson, Bill Adams are two management scientists who've written extensively, done a whole bunch of research, and they have looked at every possible dimension you can imagine of success, both leadership capability, they've looked at revenue, brand, profitability, everything, and it's shown, yes, this creative form of leadership is in every possible way positively correlated with success and reactive leadership is negatively correlated. So, yes, it works yet.
(00:21:17):
Yet, according to their research, some 75% of leaders are primarily operating reactively. So most leaders are operating from a place of fear, reacting, seeing problems, and threats. That's because that other question of how do you do it is such a hard one to answer. It's not an easy thing that you flip the switch of. It goes back to this notion of redesigning that internal operating system, so how you confront the world, what underlying belief systems and assumptions you have that are causing you to operate from that place.

**中文翻译:**
是的，这确实引出了这一点。也许另一个类比对你的听众也有效：如果你思考产品管理、你的职业弧线以及你在心态上面临的挑战，在某种程度上，职业生涯早期确实感觉像是在玩电子游戏。希望那里有教程。你的第一份工作是学习基本功，有人教你。你可能有经理给你一些简单的小任务，你可以成功完成，即使失败了，后果也不严重。
(00:17:03):
这确实感觉有点……我以前也有这种感觉，我也和很多处于职业生涯早期的人聊过。感觉就像你在努力学习游戏规则，试图弄清楚物理定律。你想刷高分。
(00:17:15):
你变得越来越擅长玩这个游戏。你会失败，但你开始建立信心，相信失败后能学到东西。你会变得更好。你变得非常精通这个游戏。你获得晋升，得到奖励，解锁新关卡，教别人怎么玩。你开始对自己感觉非常棒。
(00:17:32):
但突然间，你被置于一个境地，你意识到游戏规则不再是非黑即白的。也许现在你所做的事情和看到得分之间有很长的延迟。事情开始以意想不到的方式表现。物理定律开始变得奇怪。你处于一个漂浮的关卡。我不知道这里最合适的比喻是什么。
(00:17:52):
但你开始意识到发生了巨大的变化。最可怕的部分是，你环顾四周，发现每个人都看着你，好像你才是这个游戏的“设计师”，而你原本以为自己只是个“玩家”。当你进入领导岗位时，通常就是这种感觉，回到了那种“过去让我成功的经验，无法带我走向未来”的感觉。
(00:18:17):
我与许多领导者合作，有时这种转变伴随着巨大的代价——这种并置可能影响你的幸福、健康、婚姻。会出现一种存在主义危机：“我不知道我是否还热爱这个。”也许这会导致职业倦怠。也许没那么严重，只是一种感觉：“我环顾四周，我需要成为某种角色。我需要解锁其他东西才能在这条路上走下去。”由此产生了一种“被困住”的感觉。
(00:18:45):
我开始意识到，这是领导力中一个非常基本概念的边缘。我不是这个概念的原创者，它被一次又一次地提及。它并不新鲜，听起来会很熟悉。就像吉尔伽美什的洪水神话出现在世界所有的口述历史中一样，它并不新鲜。
(00:19:10):
我非常推崇的一个组织“意识领导力小组”（Conscious Leadership Group）称之为“线上”与“线下”（above the line versus below the line）。Brene Brown 称之为“勇敢型”与“盔甲型”领导力，或者是“智者”与“战士”。甚至在体育界，也有“为了赢而战”与“为了不输而战”的区别。这个概念一再出现。领导力圈子（Leadership Circle）称之为“创造型”（creative）与“反应型”（reactive），我将使用这两个术语。我喜欢这两个词。
(00:19:35):
区别很简单：你是出于恐惧而对世界做出反应吗？在这种状态下，你看到的是问题和威胁，你想证明自己是对的，你想被喜欢，你的内在方式是防御性的。还是说，你是从开放、可能性、好奇心、激情、成长和目标的角度对世界做出反应？概念很简单，几乎每个人都能明白我的意思。这很合逻辑。
(00:20:11):
每个人也会立即说出几件不同的事：“那听起来太棒了，我宁愿要那种，”或者，“在某些时刻我有过那种感觉。”但通常紧接着会有几个问题：“我不知道那是否有效。听起来不太高效。这可能吗？”以及，“该怎么做？”
(00:20:38):
“有效性”部分实际上是一个我们可以回答的问题，答案是：是的，它更有效。Bob Anderson 和 Bill Adams 是两位管理科学家，他们撰写了大量著作并做了大量研究。他们研究了你能想象到的成功的每一个维度，包括领导能力、收入、品牌、盈利能力等。结果显示，是的，这种“创造型”领导力在每一个可能的维度上都与成功呈正相关，而“反应型”领导力则呈负相关。所以，是的，它确实有效。
(00:21:17):
然而，根据他们的研究，约 75% 的领导者主要以“反应型”模式运作。也就是说，大多数领导者是在恐惧中运作，做出反应，看到问题和威胁。这是因为另一个问题——“如何做到”——太难回答了。这不是拨动一个开关那么简单。这回到了重新设计内在操作系统的问题：你如何面对世界，你拥有什么样的潜在信念系统和假设，导致你从那个（反应型）位置出发。

---

### [00:21:55] [Lenny]

**English:**
Can I ask you a quick question? Just to clarify the two sides, what's a sign that you're in the reactive side of things? I think one thing you said is you're worrying a lot about how people think about you and make sure that they like you. Is there anything else that's going to tell a listener, "Oh, maybe I'm falling into this trap"?

**中文翻译:**
我能问一个简单的问题吗？为了澄清这两个方面，处于“反应型”状态的迹象是什么？我想你提到的一点是，你会非常担心别人怎么看你，并确保他们喜欢你。还有什么其他迹象能告诉听众：“哦，也许我正掉入这个陷阱”？

---

### [00:22:13] [Ken Norton]

**English:**
Yeah, you've nailed it, which is that fear, like operating from a place of anxiety. There are different ways, depending on our mindsets, our approaches. I like the word postures because it seems to click different ways that we retreat into this reactive mode. Fear and anxiety is the way. That's how you know. You're just like, "Ugh, I'm below the line." I'm just like I'm seeing problems. I'm seeing threats.
(00:22:43):
Our brains are hardwired to do that, so it's not like that's wrong. These are brains that learn to do that, I don't know, on the tundra being chased by wild animals. So this is our normal way of being. There might be different desires and needs that force you to operate that way. We think there's really three of these postures.
(00:23:11):
Anybody is probably more than one of them, so this is not pathologizing. This isn't putting you in a box. But probably one of these will resonate more than the others. Wanting to be approved, wanting to be loved, wanting other people to like you. This was me in my early part of my career.

**中文翻译:**
是的，你抓住了重点，那就是恐惧，比如在焦虑的状态下运作。根据我们的心态和方法，有不同的表现方式。我喜欢“姿态”（postures）这个词，因为它似乎能点出我们退缩到这种反应模式的不同方式。恐惧和焦虑就是这种方式。这就是你判断的方法。你会觉得：“呃，我在‘线下’了。”我只看到了问题，看到了威胁。
(00:22:43):
我们的大脑天生就会这样做，所以这并不是说这样做是错的。这些大脑是在苔原上被野生动物追赶时学会这样做的。所以这是我们的常态。可能有不同的欲望和需求迫使你以这种方式运作。我们认为主要有三种这样的“姿态”。
(00:23:11):
任何人可能都不止具备其中一种，所以这不是在诊断疾病，也不是把你归类。但其中一种可能会比其他的更能引起你的共鸣。第一种是：渴望被认可，渴望被爱，渴望别人喜欢你。这就是我职业生涯早期的样子。

---

### [00:23:28] [Lenny]

**English:**
Same.

**中文翻译:**
我也一样。

---

### [00:23:29] [Ken Norton]

**English:**
Yeah. So you're kind of like the heart type. It's sometimes called move toward other people. A lot of that came from my environment. I was coming up with product management. No one necessarily knew what the job even was. I had no authority and most people could just ignore me if they wanted to. And so, I had to meet other people's expectations, please them, want to be accepted by them, seek their approval. It was this what we call a complying approach.
(00:23:58):
Here, this is why this is so vexing is it actually worked really well. It was pretty effective. Other people liked working with me. I listened to them and I considered everyone's needs and made sure everyone felt heard. But there came a point where I gave away so much power that it was hurting me when it came to purpose and execution and decisiveness.
(00:24:22):
And so, again, these aren't bad. There's usually underlying tendencies that are very good. It just starts to have a cost as you become more senior. It's like the gears start to grind to a halt a little bit.
(00:24:35):
Another way is more of a needing to be right head type, protecting one's own ideas, sometimes called a move away from type, distance, arrogance, criticism, retreating into your own ideas and head. Then the other will not be a surprise, is the more controlling, my way or the highway, autocratic will move against wanting to win, wanting to be number one, wanting to excel, wanting dominance, wanting control, this would be another tendency.
(00:25:10):
Often one of those feels natural to you and another one feels just so incredibly distasteful that you can't imagine possibly operating that way. This goes into the underlying beliefs part. If you had told me early in my career, when you saw me being passive and people-pleasing like that, "You've just got to stop caring what other people think, Ken. You've got to be more pushy."
(00:25:41):
People did say that to me. That was pretty common probably in my performance review. It was very common. Even people who worked for me were like, "You need to push back." My only archetype for doing that was the autocratic, controlling type. I was like, "I don't want to be like that. That guy's a jerk. That's a fascist. I don't want to be a fascist. I do care about other people."
(00:26:04):
And so, many of our examples and archetypes are these equally ineffective reactive ways of being. And so, no wonder I didn't want to be like that, because that's also not very effective either. But there was a sense for me of redefining ... This is where coaching is powerful is this what are the underlying assumptions and beliefs that you have that are causing you to fall back on some of these fundamental ways of operating and not let go of them?
(00:26:35):
Because the answer for me wasn't stop caring about other people. I wasn't going to do that. That's a value of mine. It's part of who I am. But take the caring about other people, the empathy, the connection, and direct it in a more creative way where you're operating now from a place of purpose and vision and not reacting and protecting and defending and wanting to be.
(00:26:56):
For me, the key to that was letting go of needing to be liked and redefining it as an admiration that takes place over time. So rather than I want to leave this room with everyone liking me, I started to realize I want to be the type of leader where, a decade later, people say, "I would work with that guy again in a heartbeat." That was part of the unlock for me.
(00:27:25):
Again, I care about other people. That's a natural gift that underlines it. But it's a redefinition of how that serves me, if that makes sense.

**中文翻译:**
是的。所以你有点像“情感型”。有时这被称为“向他人靠拢”。这很大程度上源于我的环境。我刚开始做产品管理时，甚至没人知道这份工作到底是做什么的。我没有职权，如果别人想的话，大多数人都可以无视我。所以，我必须满足别人的期望，取悦他们，渴望被他们接受，寻求他们的认可。这就是我们所说的“顺从型”方法。
(00:23:58):
这就是为什么这很让人苦恼——因为它实际上效果很好。它非常有效。别人喜欢和我一起工作。我倾听他们，考虑每个人的需求，确保每个人都感到被倾听。但到了某个阶段，我让出了太多的权力，以至于在涉及目标、执行和果断性时，它开始伤害到我。
(00:24:22):
所以，再次强调，这些并不坏。通常背后都有非常好的初衷。只是随着你变得更加资深，它开始产生代价。就像齿轮开始磨损停滞一样。
(00:24:35):
另一种方式是更偏向“理智型”的“必须正确”，保护自己的想法，有时被称为“远离型”——保持距离、傲慢、批评、退缩到自己的想法和头脑中。第三种大家也不会感到意外，是更具“控制型”的——“不听我的就滚蛋”，独裁式的“对抗型”——渴望赢，渴望成为第一，渴望卓越，渴望主导，渴望控制。这是另一种倾向。
(00:25:10):
通常其中一种会让你觉得很自然，而另一种则让你觉得非常厌恶，以至于你无法想象自己会那样运作。这涉及到了潜在信念的部分。如果你在我职业生涯早期，看到我那样被动和讨好别人时对我说：“Ken，你得停止在意别人的看法，你得更强势一点。”
(00:25:41):
确实有人对我这么说过。这在我的绩效评估中很常见。甚至为我工作的人也会说：“你需要反击。”但我当时唯一的反击原型就是那种独裁、控制型的人。我想：“我不想变成那样。那家伙是个混蛋，是个法西斯。我不想当法西斯，我确实关心别人。”
(00:26:04):
所以，我们的许多榜样和原型都是这些同样低效的“反应型”生存方式。难怪我不想变成那样，因为那同样不太有效。但对我来说，关键在于重新定义……这就是教练工作的强大之处：你有哪些潜在的假设和信念，导致你退回到这些基本的运作方式中并且不愿放手？
(00:26:35):
因为对我的答案并不是“停止关心别人”。我不会那样做，那是我的价值观，是我的一部分。但是，要把对别人的关心、同理心和连接，引导到一种更具“创造性”的方式中——在这种方式下，你基于目标和愿景运作，而不是在反应、保护、防御和渴望被认可。
(00:26:56):
对我来说，关键在于放下“被喜欢”的需求，并将其重新定义为“随着时间的推移而产生的钦佩”。所以，与其想着“我要让走出这个房间的每个人都喜欢我”，我开始意识到“我想成为那种领导者：十年后，人们会说‘我非常愿意再次和那家伙共事’”。这就是我的突破点之一。
(00:27:25):
再说一次，我关心别人，这是我内在的一种天赋。但这是一种关于这种天赋如何为我服务的重新定义，你明白我的意思吗？

---

### [00:27:34] [Lenny]

**English:**
Say someone's in that first bucket ... And I was definitely in that first bucket. I still want people to like me and I still probably have flaws there. But say you're a PM and you're like, "Oh, man. That's exactly how I am acting right now." It sounds like is the core of it just a mindset shift, going from I need people to like me to what you just talked about of, okay, I'm going to shift to I just want them to respect me over time? Is that the core of it? I know it's probably not that easy, but how should someone behave during that bucket right now?

**中文翻译:**
假设有人属于第一类……我以前绝对属于那一类。我现在仍然希望别人喜欢我，在这方面可能仍有缺陷。但假设你是一名 PM，你心想：“天哪，我现在就是这么做的。”听起来核心似乎只是心态的转变，从“我需要别人喜欢我”转变为你刚才说的“好吧，我要转变为希望他们随着时间的推移而尊重我”？这就是核心吗？我知道这可能没那么容易，但处于那一类的人现在应该如何表现呢？

---

### [00:28:03] [Ken Norton]

**English:**
Yeah. It sounds easy, right? This is part of what's hard about this, is it always sounds easy when you describe it, having gone through the journey. It's sort of like talk to somebody on the summit of Mount Everest and they'll be like, "Yeah. Well, I could just climb this mountain. That's how I got here." You're like, "Okay, wait, that's not that easy." Again, it is very individualized.
(00:28:21):
I think there's an appreciation that you have to understand what is holding you back. This is a lot of the work that I'll do with my clients is what is those underlying expectations? What are these underlying beliefs?
(00:28:40):
I Believe that my style was incompatible with being the leader. I would've said I can't be a CEO because I'm not tough enough. I'm not strong enough. I'm not commanding enough. I can't command a room. It's like, okay, what is the underlying belief I'm making about what leadership is there? There's an archetype that I have in my mind that is incompatible with this this way.
(00:29:10):
And so, there's a need to confront that. Okay, what makes you believe the only type of leader is the leader that orders people around? Maybe that's all I've ever seen. Maybe I don't believe it's possible to be another type of leader. Maybe there's an inner critic that is convincing me that that's not who I am, because a part of it is redefinition of what does leadership need for you, for you authentically? What would it be like, in my case, to lead with purpose and be decisive and lead with vision and to have other people felt like they're being brought along and listened to and participated and create safe spaces for other people? That was the question there.
(00:29:47):
It took people challenging my point of view. It took working with a coach, asking me questions, forcing me to see places I'd made connections, that the connections don't really need to be made. There's a lot of instruments and tools we work with in coaching. There's 360-degree assessments that are very helpful here that will start to help you understand, hey, here are places where you're operating actively. Here are places where you're operating really creatively, because, by the way, most people are partially somewhere in that journey. It's a developmental process.
(00:30:17):
And to start to be able to get the feedback, the dopamine hit of seeing when I do it this way, actually it's more effective and it doesn't cost me as much. I'm happier and I'm enjoying it, I'm seeing that it's working, is oftentimes a big part of this because there is this belief that it won't work. The number of times when I'm with a client in coaching and say, "Well, what if you did do that?" and they go, "It just won't work." You realize that there is this wiring in there that needs ... And this is what I talk about, this operating system that needs to be rejiggered to start to make sense of what if it did and how might you know.

**中文翻译:**
是的。听起来很容易，对吧？这就是困难所在——当你经历过这段旅程后再去描述它时，它听起来总是很容易。这有点像和站在珠穆朗玛峰顶的人交谈，他们会说：“是啊，我就这么爬上来了，这就是我到这里的方法。”你会觉得：“好吧，等等，那可没那么容易。”再次强调，这是非常个性化的。
(00:28:21):
我认为关键在于你必须理解是什么在阻碍你。这是我与客户合作时做的很多工作：那些潜在的期望是什么？那些潜在的信念是什么？
(00:28:40):
我曾相信我的风格与成为领导者是不相容的。我会说我当不了 CEO，因为我不够强硬，不够强大，不够有威慑力，我无法掌控全场。那么，关于“领导力是什么”，我持有什么样的潜在信念？我脑海中有一个原型，它与我现在的样子是不相容的。
(00:29:10):
所以，需要去直面它：是什么让你相信唯一的领导者类型就是那种对人颐指气使的人？也许那是我见过的全部。也许我不相信还有另一种类型的领导者。也许有一个“内在批评者”在说服我那不是我，因为其中一部分是重新定义：对你来说，真实的领导力需要什么？在我的案例中，带着目标去领导、果断、带着愿景去领导，并让其他人感到他们被带动、被倾听、参与其中，并为他人创造安全空间，那会是什么样子？这就是当时的问题。
(00:29:47):
这需要别人挑战我的观点。这需要与教练合作，向我提问，迫使我看到那些我建立的、但其实并不需要的联系。在教练工作中，我们使用很多工具。360 度评估在这里非常有帮助，它会开始帮你理解：嘿，这些是你处于“反应型”运作的地方，这些是你真正以“创造型”运作的地方。顺便说一下，大多数人都处于这段旅程的某个中间阶段，这是一个发展的过程。
(00:30:17):
开始获得反馈，看到“当我以这种方式做事时，实际上更有效，而且我的内耗更小，我更快乐、更享受，我看到它起作用了”，这种多巴胺的分泌通常是很大一部分动力。因为人们往往有一种“这行不通”的信念。无数次我和客户在辅导时说：“如果你真的那样做了会怎样？”他们会说：“那行不通的。”你会意识到，大脑里的这种“布线”需要……这就是我所说的，需要重新调整操作系统，去理解“如果行得通会怎样”以及“你如何才能知道”。

---

### [00:30:55] [Lenny]

**English:**
The point you just made about how you can realize that you can be successful in a lot of different ways and you don't have to be this one archetype of a leader really resonates with my experience. I actually had an executive coach for a few months, and that was probably the biggest unlock for me. We did the strengths exercise, which a lot of people do. The main thing that she helped me see is you can do all the things that you want to do through the lens of the strengths that you have and not have to force yourself to be good at these other things, because there's many ways to accomplish the same outcomes.

**中文翻译:**
你刚才提到的关于意识到你可以通过很多不同方式获得成功，而不必非得成为某种特定原型的领导者，这一点真的让我深有感触。我实际上请过几个月的高管教练，那可能是我最大的突破。我们做了很多人都做过的优势练习。她帮我看到的最主要的一点是：你可以通过你现有的优势视角去做所有你想做的事，而不必强迫自己在其他方面变得擅长，因为达成同样结果的方法有很多种。

---

### [00:31:29] [Ken Norton]

**English:**
That's exactly right. Then once you start to understand that, you start to develop a better way of finding the right place, the right environment, the right role. When we began the conversation, you asked me what brought me into executive coaching. I would feel these ... I would describe it as flying too close to the sun in my career, where I would have a team. I'd be managing a small team. I would love it. I would enjoy it. Then suddenly my team would grow.
(00:31:57):
I'd become more senior than I felt comfortable being. Then I felt like I wasn't getting to do the "real" work anymore. Then I would be just completely disheveled and dissatisfied. Then I'd go try to go find a smaller team or even stop being a manager. It was a very meandering, reactive path. It was like every so often I was catching a wave, and I knew what it felt like to be on the wave, but I didn't know what the characteristics of the wave were.
(00:32:23):
Then through coaching, I was like I love connecting with other people. I like helping people grow. I like helping challenge people. I like helping. Then I was like what are those parts? What if I unpack those? Oh, that's why I loved managing that team of five because I got to do a lot of it. That's why I hated managing a team of 35 because there's no time for it.
(00:32:44):
Then you start to say, okay, well, what if rather than just randomly meandering through my career, I actually elevated needing to connect, wanting to be helpful? Then you're like what would it be like if I wanted the helping professions? It's just a reframing of move through your career in a way that seems externally to fit some definition of success and to start to define that internally.
(00:33:11):
That is the very definition of the reactive versus creative mindset. Reactive, allowing the world to set the expectations and try to meet them versus tap into what your real, true sense of purpose and vision is. Then use that to navigate the world.

**中文翻译:**
完全正确。一旦你开始理解这一点，你就会开始找到更好的方法来寻找合适的地方、合适的环境和合适的角色。当我们开始谈话时，你问我是什么让我进入高管教练领域的。我会觉得这些……我将其描述为职业生涯中“飞得离太阳太近”的时刻。我会带一个团队，管理一个小团队，我非常热爱并享受其中。然后突然间，我的团队扩大了。
(00:31:57):
我变得比我感到舒适的程度更加资深。然后我觉得我不再能做“真正”的工作了。接着我就会变得心力交瘁、不满现状。然后我会尝试去找一个更小的团队，甚至不再担任经理。这是一条非常曲折、反应式的道路。就像我偶尔能赶上一个浪头，我知道在浪尖上的感觉，但我不知道那个浪的特征是什么。
(00:32:23):
后来通过教练辅导，我意识到：我热爱与人建立联系，我喜欢帮助人们成长，我喜欢挑战别人，我喜欢提供帮助。然后我心想：这些部分是什么？如果我把它们拆解开呢？哦，这就是为什么我喜欢管理那个 5 人的团队，因为我可以做很多这样的事；这就是为什么我讨厌管理 35 人的团队，因为根本没时间做这些。
(00:32:44):
然后你开始想：好吧，如果我不再只是在职业生涯中随机漫步，而是真正提升“需要连接”和“想要提供帮助”的地位呢？然后你会想：如果我进入助人行业会怎样？这只是一个重新框架的过程：不再是以一种表面上符合某种成功定义的方式度过职业生涯，而是开始从内在去定义它。
(00:33:11):
这就是“反应型”与“创造型”心态的定义。反应型是让世界设定预期并努力去满足它们；而创造型是挖掘你真实、真正的目标感和愿景，然后用它来导航世界。

---

### [00:33:28] [Lenny]

**English:**
It's interesting that so much of this is just mindset. It's not like learning a new skill as a leader or a product manager. It's just seeing yourself in the world differently. All of a sudden you unlock your career. Is that what you find?

**中文翻译:**
很有趣，这其中很大一部分仅仅是心态问题。这不像作为领导者或产品经理学习一项新技能，而只是以不同的方式看待自己在世界中的位置。突然之间，你就解锁了自己的职业生涯。这是你的发现吗？

---

### [00:33:40] [Ken Norton]

**English:**
Absolutely. That's why I think so much of the focus on the skills, the frameworks, it can be limited as you develop these capabilities, because it's inner work. Where we're talking about is this is all me.
(00:33:57):
Now that's empowering. There's empowerment to be able to say I want to change something and it doesn't involve a whole bunch of other people convincing and persuading them, getting into an executive ... This is all me. But it also, in some ways, makes it harder because it is all you. In coaching, it's all about you. It's all about that. Who am I and what matters to me? What underlying belief systems, inner voices are challenging me in ways that I want to be challenged? What is my unique ...
(00:34:31):
I love the word authenticity. It's, like you were just talking about, like what is my authentic way to lead, and then how do I center that rather than trying to fit into someone else's definition of what leadership might be?
(00:34:43):
You may recognize I can't be that authentic way of leader at this place or in this place type of company, but I know how to find it and I'm going to go find it.

**中文翻译:**
绝对是这样。这就是为什么我认为，如果过于关注技能和框架，当你发展这些能力时可能会受到限制，因为这是“内在工作”。我们讨论的是“这全关乎我”。
(00:33:57):
这很有力量。能够说“我想改变一些事情，而且这不需要去说服和劝导一大堆其他人，或者进入某个高管层……”这全关乎我。但在某些方面，这也让事情变得更难，因为这全靠你自己。在教练工作中，一切都围绕着你。我是谁？什么对我重要？什么样的潜在信念系统、内在声音正在以我想要被挑战的方式挑战我？我独特的……
(00:34:31):
我喜欢“真实性”（authenticity）这个词。就像你刚才说的，我真实的领导方式是什么？我如何以此为中心，而不是努力去迎合别人对领导力的定义？
(00:34:43):
你可能会意识到，在目前这个地方或这种类型的公司，我无法以那种真实的方式领导，但我知道如何找到它，并且我会去找。

---

### [00:34:55] [Lenny]

**English:**
Do you have any more examples of either someone uncovering this about themselves, or another mindset shift that you can make in one of these other buckets, similar to the idea of I'll think about people over the long term versus immediately?

**中文翻译:**
你还有更多的例子吗？无论是关于某人发现自己的这些特质，还是在其他类别中可以做出的心态转变，类似于“我会从长远而非眼前考虑人际关系”的想法？

---

### [00:35:10] [Ken Norton]

**English:**
Yeah. It really does vary. You start to pick up on that shift when it's less of the goals being defined externally and more of the goals being defined internally. So you'll have a conversation with somebody who's new to coaching and you'll say, "What do you want?" They'll be like, "Well, I want to get promoted to VP." "Why?" "Because I want to be a VP." It's like, "Well, what's important about being VP?" "Well, because ... " Eventually the answer is, well, because it's there and that's the thing that I'm supposed to do.
(00:35:45):
Then you start to notice the shift and it starts to become more of, "Well, because really what's important to me is creativity. I want more creativity in my life. I want more ability to challenge other people." And so, you start to just sense that's more from in than from out. That's where that shift is.
(00:36:06):
The journey is different for everyone. I think ultimately this is part of why, quite frankly, coaching may not be right for everyone. If we go back to that video game analogy, if you're looking for someone to just teach you the tutorial so you can learn how to play the video game and there's this jackass like me sitting next to you and saying, "What's important to you about playing this video game?" you're going to be like, "Just can you tell me how to hold the controller? Can you stop?"
(00:36:31):
So it's not always right. It's a place where I think oftentimes people recognize that they've gotten all the advice, all the frameworks, all the rules, all the tricks, all the tips. They've learned that, they've mastered it, they've tweaked it, they've optimized it, they've recognized the shortcomings, they've customized it. The emergence that's required for them to get to the next level is just going to come just as much from inside them as it is from outside, if not more. That's when that shift is made.

**中文翻译:**
是的。这确实因人而异。当目标不再由外部定义，而是更多由内部定义时，你就会开始察觉到这种转变。比如你和一个刚接触教练辅导的人交谈，你问：“你想要什么？”他们会说：“我想晋升为副总裁。”“为什么？”“因为我想当副总裁。”“那么，当副总裁有什么重要的呢？”“嗯，因为……”最终答案会是：“嗯，因为那个职位在那儿，那是我应该做的事。”
(00:35:45):
然后你开始注意到转变，它开始变成：“嗯，因为对我来说真正重要的是创造力。我希望生活中能有更多的创造力，我希望有更多的能力去挑战他人。”所以，你开始感觉到这更多是自内而外，而不是自外而内的。这就是转变发生的地方。
(00:36:06):
每个人的旅程都不同。我认为最终，坦率地说，这就是为什么教练辅导可能并不适合所有人。如果我们回到那个电子游戏的类比：如果你只是想找人教你教程，好让你学会怎么玩游戏，而旁边坐着一个像我这样的笨蛋问你：“玩这个游戏对你来说有什么重要意义？”你会说：“你能不能直接告诉我怎么拿手柄？能不能闭嘴？”
(00:36:31):
所以它并不总是合适的。我认为，通常是在人们意识到他们已经得到了所有的建议、所有的框架、所有的规则、所有的诀窍和技巧之后。他们学习了、掌握了、调整了、优化了、认识到了缺点并进行了定制。而他们达到下一个层次所需的突破，将同样多地（如果不是更多的话）来自他们的内心，而不是外部。那就是转变发生的时候。

---

### [00:36:58] [Lenny]

**English:**
That's called mentorship, I think, for people that are just looking for actual concrete advice on how to do a thing, is that right, versus coaching?

**中文翻译:**
我想，对于那些只是寻求关于如何做某事的具体建议的人来说，那被称为“导师制”（mentorship），对吗？这与“教练制”（coaching）不同。

---

### [00:37:05] [Ken Norton]

**English:**
I think so. This is where the words are squishy because there are a lot of people who are mentoring, who are also stepping into a coach role occasionally. There are plenty of managers who are great at coaching as necessary. So skills run the gamut, but it's a question of how much are you looking for someone to tell you the right way versus how much do you believe that there even is no right way? It's ultimately going to have to be your way.
(00:37:33):
That's a different place, a different point in your career at different levels of journey. It's part of why I tend to work with probably more senior executives, because they're not looking to me to tell them how to do the job. They've already learned how to do the job. It's just something deeper that's going to need to break through from that.

**中文翻译:**
我想是的。这就是词义模糊的地方，因为有很多在做导师工作的人，偶尔也会进入教练的角色。也有很多经理在必要时非常擅长辅导。所以技能是全方位的，但问题在于：你是在多大程度上寻找别人告诉你“正确的方法”，还是在多大程度上相信根本没有“正确的方法”？最终，它必须是“你的方法”。
(00:37:33):
这是职业生涯中不同的阶段，处于旅程的不同水平。这也是为什么我倾向于与更资深的高管合作，因为他们不指望我告诉他们如何开展工作，他们已经学会了如何工作。只是有一些更深层次的东西需要从中突破。

---

### [00:37:50] [Lenny]

**English:**
This episode is brought to you by Unit. What did Gusto, Uber, Shopify and AngelList all have in common? They've all decided to build banking into their product. According to AngelList head of product, "Banking makes every single feature more interesting. With it, our platform functions as financial mission control for our customers. Without it, we're just another software tool in a big messy stack."
(00:38:12):
Embedding banking into your product not only adds differentiation, but also helps you acquire, retain, and monetize your customers. Unit is the market leader in banking as a service, combining multiple bank partners with a developer-friendly API to empower companies of all sizes to launch accounts, cards, payments, and lending in just a few weeks.
(00:38:33):
Unit is trusted by leading brands such as AngelList, Highbeam, Invoice2go, and Roofstock. To hear more about how Unit enables companies like yours to build banking, visit unit.co/lenny to request a demo or to try their free sandbox. That's unit.co/lenny.

**中文翻译:**
本集节目由 Unit 为您呈现。Gusto、Uber、Shopify 和 AngelList 有什么共同点？他们都决定将银行业务构建到自己的产品中。正如 AngelList 的产品负责人所说：“银行业务让每一个功能都变得更有趣。有了它，我们的平台就像客户的财务控制中心。没有它，我们只是庞杂工具栈中的又一个软件工具。”
(00:38:12):
将银行业务嵌入到你的产品中不仅能增加差异化，还能帮助你获取、留住客户并实现变现。Unit 是银行即服务（BaaS）领域的市场领导者，它将多个银行合作伙伴与开发者友好的 API 相结合，使各种规模的公司都能在短短几周内推出账户、卡片、支付和贷款业务。
(00:38:33):
Unit 深受 AngelList、Highbeam、Invoice2go 和 Roofstock 等领先品牌的信赖。要了解更多关于 Unit 如何赋能像你这样的公司构建银行业务的信息，请访问 unit.co/lenny 申请演示或试用他们的免费沙盒。地址是 unit.co/lenny。

---

### [00:38:51] [Lenny]

**English:**
For someone that wants to do the work, but can't find a coach, can't afford a coach, is there something people can do on their own that you'd recommend to help them shift their mindset and do a lot of these things that you've been describing?

**中文翻译:**
对于那些想要提升自己，但找不到教练或负担不起教练的人，你有什么建议是他们可以自己做的，来帮助他们转变心态并实践你所描述的这些事情吗？

---

### [00:39:06] [Ken Norton]

**English:**
Yeah, it's a great question. Here's the secret about the coaching industry. Anyone can call themselves a coach. It's very democratized. It's great. There's no gatekeepers and barriers and there's no 500 licenses you have to go through.
(00:39:22):
There are tons of great coaches who are at various different price levels, at different levels of accessibility. And so, if you say, "I can't afford a coach," I might challenge that a little bit and say have you looked?
(00:39:36):
The other thing is that you don't need a coach who's done the job before. I mean obviously I've done the job before, so I'm undermining part of my own selling point here. But coaches are trained to coach people on any topic. So when I go through coach training, I can coach you on anything. People can coach you on anything.
(00:39:52):
Sometimes even there might be power in having a coach that's never done the product management job because there won't be any cheating of starting to move into a more of advisor role or maybe as the coach either. There may be, "Well, you tell me what should I should do," and the person would be like, "I don't know. I've never done this job. Let's go back to what you want." So there could be some benefit from that. Again, you don't have to have done that.
(00:40:13):
So I would say coaching is incredibly powerful. I wish I'd had a coach much, much earlier in my career. And so, the answer may be coaching is more accessible than you thought. If not, I think the things that we're talking about here are internal understanding of what matters to you, your sense of purpose, this inner curiosity, and that could be harnessed at any age. So just wondering about yourself at any point in your career, wondering what's important to you.
(00:40:43):
I love doing values work, like, "What are your values? Okay. No. What really are your values?" That's something you can do yourself. That's something you can question. You can read about, you can start to understand.
(00:40:53):
Mentors can be great, especially mentors who are less about trying to tell you the right way and get you to follow directly their path, but are more they're applying some curiosity, asking questions, challenging you in certain ways, being a way that you can bounce ideas off of.
(00:41:09):
Great managers, I think, especially the best product leaders, understand how to put the coach hat on and when it's appropriate to put the coach hat on, and are explicit about that, are like, "Okay, let me take off my manager hat now and put the coach hat on. What do you really want to do, Lenny? What's important to you? What's your career?" And so, I think you can get coaching from everywhere.
(00:41:28):
There's a lot of self-coaching you can do. This is honestly one of the benefits for me having gone through tons of training and coaching is starting to coach myself, like feeling an emotion and asking myself coach questions. Really powerful. That's something you can do when you've had a coach. You can do it when you don't have a coach. You can explore it.
(00:41:46):
So I think this is really all about really being curious and wanting to understand who you really are at the core and what's important to you and what matters. That's something that can be done with or without a coach.

**中文翻译:**
是的，这是一个很好的问题。教练行业有一个秘密：任何人都可以自称为教练。这个行业非常民主化，这很好。没有守门人和门槛，也不需要考取 500 个证书。
(00:39:22):
有大量优秀的教练处于不同的价格水平和准入门槛。所以，如果你说“我负担不起教练”，我可能会稍微挑战一下你，问问你：“你找过了吗？”
(00:39:36):
另一件事是，你不需要一个以前做过这份工作的教练。显然我以前做过这份工作，所以我在这里是在削弱我自己的卖点。但教练是受过培训的，可以就任何话题辅导任何人。当我接受教练培训时，我可以就任何事情辅导你。人们可以就任何事情辅导你。
(00:39:52):
有时，找一个从未做过产品管理工作的教练甚至更有力量，因为这样教练就不会“作弊”——不会轻易进入顾问角色。客户可能会说：“好吧，你告诉我该怎么做，”而教练会说：“我不知道，我从未做过这份工作。让我们回到你想要什么。”所以这可能会带来一些好处。再次强调，你不需要教练必须做过你的工作。
(00:40:13):
所以我想说，教练辅导是非常强大的。我希望我在职业生涯早期就能有一个教练。所以，答案可能是教练辅导比你想象的更容易获得。如果不是，我认为我们在这里讨论的是对什么对你重要的内在理解、你的目标感、这种内在的好奇心，而这些在任何年龄都可以培养。就是在职业生涯的任何阶段对自己保持好奇，思考什么对你重要。
(00:40:43):
我喜欢做价值观梳理，比如：“你的价值观是什么？不，真正的价值观是什么？”这是你可以自己做的事情。这是你可以质疑、阅读并开始理解的事情。
(00:40:53):
导师也可以很棒，尤其是那些不急于告诉你“正确的方法”并让你直接遵循他们的道路，而是运用好奇心、提出问题、以某些方式挑战你、让你能够与之交流想法的导师。
(00:41:09):
我认为优秀的经理，尤其是最优秀的产品领导者，知道如何戴上“教练帽子”，以及什么时候适合戴上它，并且会明确表达：“好吧，现在让我摘下经理帽子，戴上教练帽子。Lenny，你真正想做的是什么？什么对你重要？你的职业生涯规划是什么？”所以，我认为你可以从各处获得辅导。
(00:41:28):
你还可以进行大量的自我辅导。老实说，对我来说，接受过大量培训和辅导的好处之一就是开始自我辅导——比如感受到一种情绪，然后问自己教练式的问题。这非常强大。当你请过教练时你可以这样做，当你没有教练时也可以这样做。你可以去探索。
(00:41:46):
所以，我认为这完全在于保持好奇心，想要了解核心的你到底是谁，什么对你重要，什么有意义。无论有没有教练，这都是可以做到的。

---

### [00:41:58] [Lenny]

**English:**
Are there any resources that you love for either the values work or learning these questions to ask yourself? We can put them in the show notes if nothing comes to mind immediately. But is there something you recommend people check out?

**中文翻译:**
有没有你喜欢的资源，无论是关于价值观梳理，还是学习这些自问的问题？如果现在想不起来，我们可以放在节目笔记里。但有什么是你推荐大家去看看的吗？

---

### [00:42:08] [Ken Norton]

**English:**
Yeah, there are some great books. Maybe I'll use this opportunity to throw out a couple suggestions.

**中文翻译:**
是的，有一些很棒的书。也许我可以借此机会提出几个建议。

---

### [00:42:13] [Lenny]

**English:**
Let's do it.

**中文翻译:**
开始吧。

---

### [00:42:14] [Ken Norton]

**English:**
I guess we can link it into the show notes. Brene Brown's Dare to Lead. It's a good book. She actually even has a whole section in there around values, confronting her values. I like her approach. There's some free resources on her website.
(00:42:26):
I love Conscious Leadership Group's work here. The 15 Commitments of Conscious Leadership book is fantastic. You don't even need to buy the book. There's a ton of stuff on their website. Jim Dethmer, Diana Chapman and Kaley Warner Klemp are of the authors of that book. That's all about a lot of the stuff we've been talking about. They're the ones that have the above the line versus below the line that fits into this creative versus reactive standpoint. Those are all fantastic.
(00:42:57):
If you want to go deeper into more of the management science behind it, if you're like me and really curious about the psychology and the management science, Bob Anderson and Bill Adams's book, Mastering Leadership, creates the entire integrated system around creative versus reactive.
(00:43:19):
As a teaser, they identify five levels of leadership, of which reactive is the second, creative is the third. So beyond that, you get into integral and unitive. So if you're looking to unlock the advanced stages beyond creative, there's a lot of great stuff in there. Those are where all the research comes in as well.
(00:43:38):
From an adult development standpoint, Robert Kegan is the godfather of the adult-stage development work and the meaning-making that underlines a lot of this. He has a great book called Immunity to Change if you're curious about that.

**中文翻译:**
我想我们可以把链接放在节目笔记里。Brene Brown 的《勇于领导》（Dare to Lead）是一本好书。她甚至在书里专门有一节讲价值观，直面她的价值观。我喜欢她的方法，她的网站上也有一些免费资源。
(00:42:26):
我非常喜欢“意识领导力小组”（Conscious Leadership Group）的工作。《意识领导力的 15 个承诺》（The 15 Commitments of Conscious Leadership）这本书非常棒。你甚至不需要买书，他们的网站上有很多资料。Jim Dethmer、Diana Chapman 和 Kaley Warner Klemp 是该书的作者。这本书涵盖了我们讨论过的很多内容。他们提出了“线上”与“线下”的概念，这与“创造型”与“反应型”的观点非常契合。这些都非常精彩。
(00:42:57):
如果你想更深入地了解背后的管理科学，如果你像我一样对心理学和管理科学非常好奇，Bob Anderson 和 Bill Adams 的书《掌握领导力》（Mastering Leadership）围绕“创造型”与“反应型”构建了整个集成系统。
(00:43:19):
剧透一下，他们确定了领导力的五个层次，其中“反应型”是第二层，“创造型”是第三层。除此之外，你还会进入“整合型”和“统一型”。所以如果你想解锁“创造型”之上的高级阶段，书里有很多好东西。所有的研究数据也都在那里。
(00:43:38):
从成人发展的角度来看，Robert Kegan 是成人阶段发展研究和意义构建（meaning-making）的教父，这也是很多理论的基础。如果你对此好奇，他有一本很棒的书叫《变革的免疫力》（Immunity to Change）。

---

### [00:43:52] [Lenny]

**English:**
Awesome. We will link to all those in the description of this podcast so folks don't have to Google around. I have a couple of more coaching questions before we move on to a few other topics. One is just what are you finding are the most common blind spots for product people in general? How are people shooting themselves in the foot most?

**中文翻译:**
太棒了。我们会把这些链接都放在播客的描述中，这样大家就不用到处去搜了。在转入其他话题之前，我还有几个关于教练的问题。一个是，你发现产品经理最常见的盲点是什么？人们最常在哪些方面“搬起石头砸自己的脚”？

---

### [00:44:11] [Ken Norton]

**English:**
Oh, that's a great question. I think probably the number one category, I'm not sure it's necessarily a problem, but maybe category or problems, is ... And this is, I think, great lesson for people earlier in their career, is how much all of the challenges that senior executives are dealing with come down to people versus product. So it's like it's fun to think about designing products, optimizing, doing user discovery, and testing what, but it's like you sit down with an executive and it's all about people.
(00:44:47):
That's the hard part. It's about persuading people, getting groups of people to want to work together, trying to figure out how to deal with difficult personalities, figuring out how to set a vision and articulate a vision, create an environment where people can collaborate and play.
(00:45:01):
And so, I think this category of blind spot often is people being confronted with that without having been intentional about thinking of it as a skill or an area that they needed to work on, needed to improve.
(00:45:18):
Part of what I think is pretty exciting about product management is you are a leader from day one in product management. There's leadership all over the place, but that's your job. You're a leader. You don't have any formal authority, but you're a leader. You're expected to lead.
(00:45:39):
Guess what? The hardest part about being a leader is when you don't get to just rely on the formal authority. So you're getting to practice all the hard parts about leadership from day one, because you're nobody's boss. You get to sharpen those skills, develop those intuitions, get better and better at that, so that when you do someday, if this is right for you, become someone else's boss, you've already been able to lean into that.
(00:46:04):
And so, the people side of this is such an incredible aspect of what product management is. What I find, and this may be a category of blind spots, is people realizing that when they're put in a position where they're expected to have impact and realizing that they haven't developed the skills, they haven't developed the capability to actually be able to manage and work through all these people, which is ...

**中文翻译:**
噢，这是一个好问题。我想排名第一的类别——我不确定它是否一定是个“问题”，但可能是一个类别——而且我认为这对职业生涯早期的人来说是一个很好的教训，那就是：资深高管面临的所有挑战中，有多少最终归结为“人”的问题，而不是“产品”的问题。思考产品设计、优化、用户调研和测试确实很有趣，但当你和高管坐下来谈时，谈的全是人的问题。
(00:44:47):
那是困难的部分。它关乎说服别人、让一群人愿意一起工作、弄清楚如何应对难相处的性格、弄清楚如何设定愿景并清晰地表达愿景、创造一个人们可以协作和发挥的环境。
(00:45:01):
所以，我认为这类盲点通常是人们在面对这些问题时，并没有有意识地将其视为一项需要努力、需要提高的技能或领域。
(00:45:18):
我认为产品管理中非常令人兴奋的一点是，从第一天起你就是一名领导者。领导力无处不在，但这就是你的工作。你是一名领导者。你没有任何正式的职权，但你就是领导者。人们期望你发挥领导作用。
(00:45:39):
猜猜怎么着？作为领导者最难的部分，就是当你不能仅仅依靠正式职权的时候。所以你从第一天起就在练习领导力中最难的部分，因为你不是任何人的老板。你可以磨练这些技能，培养直觉，变得越来越擅长，这样当有一天（如果这适合你的话）你真的成了别人的老板时，你已经能够游刃有余了。
(00:46:04):
所以，“人”的这一面是产品管理中一个非常不可思议的方面。我发现，这可能属于盲点的一类，即人们意识到当他们被置于一个需要产生影响力的位置时，才发现自己还没有培养出管理和处理这些人际关系的技能和能力，而这正是……

---

### [00:46:33] [Lenny]

**English:**
How do you actually get better at that or develop those skills?

**中文翻译:**
你实际上如何提高这方面的能力或培养这些技能？

---

### [00:46:37] [Ken Norton]

**English:**
Yeah. I just think recognizing it is part of the job. It's important. Maybe I came up at a certain time where it was often dismissed as soft skills. It's just like soft skills are helpful, but they're not actually something you want to work on. They're not something you train, not something you ...
(00:46:54):
And this is just as important. This is the equal ... I wrote a piece recently about the art versus the science. The art is communication, collaboration, the more fuzzy, softer skills, people stuff. It's an elevation of that being just as important, if not more important, over time, as all this skills, techniques, tactics, managing a backlog, all that kind of stuff that you have to do. You should invest in that the same way you invest in those other skills.
(00:47:25):
So if you go off to a training to learn a technique for doing, I don't know, some sort of technical dashboard analysis, why don't you go to training to learn how to have difficult conversations? Because there's some great training about having difficult conversations, or do some training about storytelling. These are all really, really important factors that start to come into play.
(00:47:54):
What I would recommend is just appreciating that these are going to really, really matter and practicing and then valuing them and not thinking of them as something that either will matter later or a distraction or not really part of the job.

**中文翻译:**
是的。我认为意识到这是工作的一部分非常重要。也许在我成长的那个时代，这些通常被轻视为“软技能”。人们觉得软技能虽然有帮助，但并不是你真正想要努力的方向，不是你需要培训的东西，不是你……
(00:46:54):
但这同样重要。我最近写了一篇关于“艺术与科学”的文章。艺术就是沟通、协作、那些更模糊、更软的技能，也就是人的问题。随着时间的推移，这些东西应该被提升到与技能、技术、战术、管理待办事项等所有你必须做的事情同等重要、甚至更重要的地位。你应该像投资其他技能一样投资这些技能。
(00:47:25):
所以，如果你去参加培训学习某种技术仪表盘分析的技术，为什么不去参加培训学习如何进行“艰难对话”呢？因为有一些关于如何进行艰难对话的优秀培训，或者参加一些关于讲故事（storytelling）的培训。这些都是开始发挥作用的非常、非常重要的因素。
(00:47:54):
我的建议是，要意识到这些真的非常重要，去练习并重视它们，不要认为它们是以后才重要的事，或者认为它们是干扰，或者不属于工作的一部分。

---

### [00:48:07] [Lenny]

**English:**
I think the reason people don't do that work is because it's so hard. Difficult conversations are difficult. We talked about this with Trey Hass. But just like it's a rule of thumb, the thing that is hard is probably the thing you should be doing. It's like a compass point of you to the thing you should do.

**中文翻译:**
我认为人们不做那项工作的原因是因为它太难了。艰难的对话确实很难。我们和 Trey Hass 讨论过这个问题。但就像一个经验法则：那件困难的事，可能就是你应该做的事。它就像一个指南针，指向你该做的方向。

---

### [00:48:23] [Ken Norton]

**English:**
Absolutely. We are all about doing hard stuff, product managers. That's what we're all about. And so, when something seems hard and it seems squishy and it seems like it's difficult to put a three-step rule around, chances are it's really going to matter. It goes back to this mindset shift. That means that there's an opportunity for you to readjust your inner complexity management system to adapt to that area of complexity that you're now seeing, because this stuff really feels squishy. And so, that's even more of a reason why you want to get your hands around it and grab onto it and value it and learn and grow from it.

**中文翻译:**
绝对如此。我们产品经理就是为了处理困难的事情。这就是我们的全部意义。所以，当某件事看起来很难、很模糊、很难用一个“三步走规则”来概括时，它很可能真的非常重要。这又回到了心态转变的问题。这意味着你有一个机会去重新调整你的内在复杂性管理系统，以适应你现在看到的那个复杂领域，因为这些事情确实感觉很模糊。所以，这更有理由让你去深入了解它、抓住它、重视它，并从中学习和成长。

---

### [00:49:07] [Lenny]

**English:**
Speaking of difficult and squishy, I'm guessing that one of the biggest challenges that people you work with face and one of the most recurring themes is imposter syndrome, people having imposter syndrome, something definitely I went through and it comes up a lot on this podcast. What do you usually advise your clients to do when they're feeling imposter syndrome?

**中文翻译:**
说到困难和模糊，我猜你合作的人面临的最大挑战之一，也是最常出现的主题之一，就是冒充者综合征（imposter syndrome）。这是我肯定经历过的事情，在这个播客中也经常被提及。当你的客户感到冒充者综合征时，你通常会建议他们怎么做？

---

### [00:49:27] [Ken Norton]

**English:**
Yeah, it's a great question. I always get corrected to say imposter phenomenon by people in the psychology community, because I guess it's not a dysfunction. And so, I've learned to use their terms. But, yeah, I think just about everyone experiences it at some point. Research shows that that definitely is born out ... It's really the moments when you're doubting your abilities or you feel like a fraud or you feel like you don't belong.
(00:49:54):
It's funny because as I'm interrogating my own inner emotional state right now, I'm feeling it a little bit, because there's a part of me right now that's just like, "You're not a trained psychologist." When I said that whole thing, well, it's technically a phenomenon, there's a voice that was like, "What are you talking about? You don't know what you're talking about. Who are you [inaudible 00:50:14] on this?"

**中文翻译:**
是的，这是一个很好的问题。心理学界的人总是纠正我，让我说“冒充者现象”（imposter phenomenon），因为我想它并不是一种功能障碍。所以我学会了使用他们的术语。但是，是的，我认为几乎每个人在某些时刻都会经历它。研究表明这确实是普遍存在的……这通常发生在你怀疑自己的能力，或者觉得自己是个骗子，或者觉得自己不属于这里的时候。
(00:49:54):
很有趣，因为当我此刻审视自己的内在情感状态时，我也有一点这种感觉。因为我内心的一部分现在就在想：“你又不是受过训练的心理学家。”当我刚才说“技术上它是一种现象”时，有一个声音在说：“你在说什么呢？你根本不知道自己在说什么。你凭什么……（听不清）谈论这个？”

---

### [00:50:14] [Lenny]

**English:**
We'll put a disclaimer on the episode.

**中文翻译:**
我们会在这一集里加个免责声明。

---

### [00:50:16] [Ken Norton]

**English:**
Yeah, I'm not a psychologist. So, look, we all feel it. There's a part of me right now that's like I'm going to say the wrong thing and embarrass myself. Product managers, product leaders maybe more so because the role is so cross-functional and ill-defined. There's always going to be an edge of the job that you aren't as qualified as whoever you're interacting with. It's the nature of it. Look, we're never going to be as good as an engineer, as good as a designer, as good ... So there's all these opportunities for that.
(00:50:40):
I find, certainly from client work, that there is a little bit of a softening and solidarity just knowing that. I'm just like, "Oh, you have that, too? Oh, I have that. Yeah, there's some value to that."
(00:50:51):
I think it's important to pause here and say that there is the risk of dismissing or even maybe weaponizing imposter phenomenon against particular populations, particularly women, people of color of all genders, women of color especially, who are facing real external feedback and doubt about their abilities.
(00:51:15):
The environment is reinforcing and the source of a lot of this stuff, microaggressions, bias, real aggressions. And so, I think we always have to be careful in the helping professions to not dismiss it as a problem that just shifts the obligation to the person. So it's like, "Oh, that's just your imposter syndrome. Deal with it." Well, it's really easy to overlook all these systemic issues that are leading to that imposter syndrome.
(00:51:39):
So the leaders I work with, I think we have a special obligation both to confront our own inner dynamic, but also to recognize what our role is in the broader environment that might be contributing to some of this stuff. If you're a leader, you have a special obligation to dismantle those, not when you're meeting with your people, be like, "Ah, it's just your imposter syndrome. You can work through it. Hire a coach," but to be able to recognize, "Okay, wait, what signals are you getting? What issues are contributing to this? What's our role in needing to change that?" So I think that's worth pointing out.
(00:52:13):
By the way, there's a great article in Harvard Business Review from a couple of years ago. I think the title was literally Stop Telling Women They Have Imposter Syndrome. The two authors of that were Ruchika Tulshyan and Jodi-Ann Burey, if you're curious and you want to go into more depth on that.
(00:52:29):
As coaches there, there's all sorts of ways we're trained to work with this. Oftentimes as an inner critic and inner voice, we all have voices, saboteurs. They're often trying to help us, they have good intentions, but they're developed to try to protect us in certain ways. So gaining awareness of those, just sort of like, "Oh, that is an inner critic. That's what it's trying to do." There's a self-distancing that's valuable to that, really kind of ...
(00:52:54):
I like to think of it a little bit as you got inner border directors, and there's some noisy, chatty voices that every so often sit in the chairperson's seat and start taking over. If you start to recognize, "Wait, no, I'm the chairperson. I don't want to hear from you right now. We'll hear from you later," it starts to create some power and you start to notice when it's happening.
(00:53:16):
We bypass inner critic sometimes as a classic coaching technique. It's like, "Okay, I'm sounding that's your inner critic is saying that. What if we just ask it to maybe step aside? Let's keep talking here."
(00:53:28):
You can befriend it. There's a lot of practices and works just actually trying to understand what its motivations are. You can think of it as a board. Give this board member a new job, put it on a new committee, reassign it.
(00:53:41):
There's oftentimes underlying belief systems. We talked before about my impression of what a real leader was and who they had to be. And so, hey, when all those second-guessing of me not being a real leader, of me not being qualified came from some of those underlying assumptions, that that was the only type of leader that was effective, was somebody that was slamming their fist out on the table.
(00:54:02):
Okay, so what if we redefine that? I'm too kind to be a leader. I'm not dominating, commanding enough. When you hear a client say that as a coach, you recognize, okay, there's a connection being made here between what effective leadership is and isn't. Let's interrogate that connection. Is that connection actually true?
(00:54:21):
Again, it get backs to this question of you're often responding to other styles, approaches you've seen. You're comparing yourself to others. So this is the reactive mindset of I'm always comparing myself to that person, to that wave, that being, and seeing myself as lesser then. And so, the inner work of starting to see who I really am truly inside and less comparing myself to others.
(00:54:42):
But, yeah, imposter phenomenon, syndrome, whatever you want to call it, very common and very popular, I suppose. Although when I say popular, it's like popular like a play.

**中文翻译:**
是的，我不是心理学家。所以，你看，我们都有这种感觉。我现在内心的一部分就在想，我会说错话让自己难堪。产品经理、产品领导者可能更是如此，因为这个角色是跨职能的，而且定义模糊。工作中总会有一些边缘地带，让你觉得自己不如与你互动的人那么专业。这是它的本质。看，我们永远不会像工程师那样擅长工程，不会像设计师那样擅长设计……所以总会有产生这种感觉的机会。
(00:50:40):
我发现，当然是从客户工作中发现，仅仅是知道这一点，就会产生一种缓和感和团结感。我会觉得：“哦，你也有这种感觉？哦，我也有。是的，这有一定的价值。”
(00:50:51):
我认为在这里停顿一下并说明这一点很重要：存在一种风险，即忽视甚至可能将“冒充者现象”作为武器来针对特定人群，特别是女性、各种性别的有色人种，尤其是面对真实的外部负面反馈和对其能力怀疑的有色人种女性。
(00:51:15):
环境在强化这一点，也是很多此类事情的源头——微侵犯、偏见、真实的侵犯。因此，我认为在助人行业中，我们必须始终小心，不要将其仅仅视为一个将责任推给个人的问题。比如：“哦，那只是你的冒充者综合征，自己处理一下。”其实，很容易忽视导致这种冒充者综合征的所有系统性问题。
(00:51:39):
所以，对于我合作的领导者，我认为我们有一种特殊的义务，既要面对我们自己的内在动态，也要认识到我们在可能导致这些问题的更广泛环境中所扮演的角色。如果你是一名领导者，你有一种特殊的义务去消除这些问题，而不是在见你的员工时说：“啊，这只是你的冒充者综合征，你可以克服它，请个教练吧。”而是要能够识别：“好吧，等等，你收到了什么信号？什么问题导致了这种情况？我们在改变这种状况中扮演什么角色？”所以我认为这一点值得指出。
(00:52:13):
顺便说一下，《哈佛商业评论》几年前有一篇很棒的文章，标题直译过来就是《停止告诉女性她们有冒充者综合征》。两位作者是 Ruchika Tulshyan 和 Jodi-Ann Burey，如果你好奇并想深入了解，可以去看看。
(00:52:29):
作为教练，我们受过各种训练来处理这个问题。通常作为“内在批评者”和“内在声音”，我们都有各种声音、破坏者。它们通常试图帮助我们，初衷是好的，但它们的发展是为了以某些方式保护我们。所以，意识到这些声音，就像是：“哦，那是一个内在批评者，那是它试图做的事情。”有一种“自我疏离”对此很有价值，真的有点像……
(00:52:54):
我喜欢把它想象成你有一群内在的董事会成员，其中有一些嘈杂、爱说话的声音，每隔一段时间就会坐在主席的位置上开始接管一切。如果你开始意识到：“等等，不，我才是主席。我现在不想听你说话，我们稍后再听你的。”这就会开始产生力量，你会开始注意到它什么时候发生。
(00:53:16):
我们有时会使用一种经典的教练技术来“绕过”内在批评者。比如：“好吧，我听起来那是你的内在批评者在说话。如果我们请它先靠边站，我们继续聊，会怎么样？”
(00:53:28):
你可以和它交朋友。有很多练习和方法只是为了真正理解它的动机。你可以把它看作一个董事会，给这个董事会成员一份新工作，把它放进一个新委员会，重新分配它的任务。
(00:53:41):
通常还有潜在的信念系统。我们之前谈到过我对“真正的领导者”是什么样以及他们必须是什么样的印象。所以，嘿，当我所有那些对自己不是真正领导者、不称职的自我怀疑都源于那些潜在假设——即唯一有效的领导者类型是那种在桌子上拍拳头的人。
(00:54:02):
好吧，那如果我们重新定义它呢？“我太善良了，当不了领导者。我不够强势，不够有威慑力。”当教练听到客户这么说时，你会意识到：这里在“有效的领导力是什么”和“不是什么”之间建立了一种联系。让我们审视这种联系，这种联系真的是真的吗？
(00:54:21):
再次回到这个问题：你通常是在对你见过的其他风格和方法做出反应。你在把自己和别人比较。这就是“反应型”心态——我总是在把自己和那个人、那个浪潮、那个存在进行比较，并认为自己不如别人。所以，内在的工作是开始看到内心真实的自我，减少与他人的比较。
(00:54:42):
但是，是的，冒充者现象、综合征，无论你想怎么称呼它，都非常普遍，我想也非常“流行”。虽然我说流行时，它的意思就像一部流行的戏剧。

---

### [00:54:53] [Lenny]

**English:**
Right. Another inner critic tactic I've heard that I used for a bit that was helpful is to give your inner critic a name, like Jim. I mean like, "Jim, not right now. I don't need you right now." That kind of helps.

**中文翻译:**
对。我听过并试用过一段时间的另一个应对内在批评者的策略是，给你的内在批评者起个名字，比如叫“吉姆”。我的意思是，就像说：“吉姆，现在不行，我现在不需要你。”这确实有帮助。

---

### [00:55:06] [Ken Norton]

**English:**
Yeah. There is a whole school of coaching that I've worked with that's called parts work or internal family systems. It comes from a psychologist named Richard Schwartz who determined this. It can be really, really powerful.
(00:55:19):
I'll word my clients and we will give them names. We will imagine what they look like. They will interview these parts. If you've seen the Pixar movie Inside Out, this notion that like, hey, all these different parts show up in different ways. I'm going to put myself, the real me, the real self into the chairperson's seat. When I hear these voices, I'm going to appreciate them from what they are and who they are. They're not me. They're parts of me.
(00:55:46):
There's something really powerful in that, in that sense of like ... Because, otherwise, they're all me. So I just hear this voice telling me I'm an idiot and I'm a clown and I'm not qualified to be in this room. Then when you can start to go, "Oh, yeah, there it is. That's Larry Loser. My big angry, irritating judge who's, of course ... Oh, yeah, Larry always shows up every time I do something new, because Larry doesn't want me to challenge myself. So, of course, Larry's going to pipe in. I've heard from Larry. I'm going to ask Larry to step aside. Let's go." Yeah, it can be very powerful.

**中文翻译:**
是的。我接触过的一整套教练流派被称为“部分工作”（parts work）或“内在家庭系统”（internal family systems）。它源于心理学家 Richard Schwartz 的研究。这可能非常、非常强大。
(00:55:19):
我会引导我的客户，我们会给这些部分起名字，想象它们长什么样。他们会采访这些部分。如果你看过皮克斯的电影《头脑特工队》（Inside Out），就会明白这个概念：嘿，所有这些不同的部分以不同的方式出现。我要把我，那个真实的自我，放在主席的位置上。当我听到这些声音时，我会根据它们的本质和身份来欣赏它们。它们不是我，它们是我的一部分。
(00:55:46):
这其中蕴含着非常强大的力量，因为如果不这样想，它们就全都是“我”。所以我只会听到一个声音告诉我我是个白痴，是个小丑，没资格待在这个房间里。但当你开始能够说：“哦，是的，它在那儿。那是‘失败者拉里’。我那个愤怒、烦人的大裁判，当然……哦，是的，每当我做新事情时，拉里总是会出现，因为拉里不想让我挑战自己。所以，拉里当然会插嘴。我已经听过拉里的意见了，现在我要请拉里靠边站。我们继续。”是的，这可以非常强大。

---

### [00:56:22] [Lenny]

**English:**
I love that. One last question about coaching. For folks that want to find a coach, do you have any advice of just how to find a coach, and then what are a couple questions you can ask to evaluate if they're a good fit for you?

**中文翻译:**
我喜欢这个。关于教练的最后一个问题。对于想要寻找教练的人，你有什么建议吗？如何找到教练，以及可以问哪几个问题来评估他们是否适合你？

---

### [00:56:35] [Ken Norton]

**English:**
Yeah, great question. So I think, like any helping profession, finding a therapist or really anyone who you're going to have a deep and lasting relationship with, this sort of trust and authenticity is really important. I think we all, as coaches, recognize, and we feel this as well with clients, is it either has to be a fit or not. Sometimes it's hard to put your finger on it. Sometimes you meet with someone and you're like, "Yeah, it clicks. It feels right." Sometimes you're like, "Eh, it doesn't," and that's okay. And so, all coaches worth their salt will offer a free session to understand that, engage that.
(00:57:13):
I always tell everyone in that session, if you don't decide to work with me or I decide ... We don't need a reason. It's fine. It's just not a fit, and that's okay. You don't need to come up with bullet point reasons to let me down. It's part of how it goes.
(00:57:28):
You might prefer certain people, certain gender, certain backgrounds. You may feel more comfortable or less comfortable with ... Maybe you want an old guy like me. Maybe you want an old guy like me, and that's fine. It has to feel right.
(00:57:41):
I would ask them to talk to you about what coaching is to them, because, again, it might combine some of these more mentory things. It might be more tactical. Some coaches are more structured, "Week one, we're going to do this. Week two, we're going to do this. Week ... " Others are more pure coaches like me, where, look, within the first five minutes, I'm going to ask you what you want to talk about today, because you're bringing the agenda. So figure that out. Figure out what works for you.
(00:58:07):
Then I think there's a lot of great places to go. Actually, specifically where to go, the International Coaching Federation is our governing body. So those of us that are credentialed coaches you'll find there. Again, you don't have to be credentialed, but that'll be a great place to find people who are.
(00:58:23):
There are some matchmaking services, BetterUp, Torch, or some of the more accessible ones. There's one called Prismaticco. It's a little bit more higher end for more senior execs. Scale just put out a list of top coaches who work with product managers and product leaders, all sorts of great coaches. We can include that link. Lenny, I think you're involved.

**中文翻译:**
是的，好问题。我认为，就像任何助人职业一样，寻找治疗师或任何你将与之建立深厚且持久关系的人，这种信任和真实性非常重要。我认为我们所有的教练都意识到，并且我们也和客户有同样的感觉：要么合适，要么不合适。有时很难说清楚原因。有时你见到某人会觉得：“是的，很合拍，感觉很对。”有时你会觉得：“呃，不太对劲。”这没关系。因此，所有名副其实的教练都会提供一次免费课程来了解和接触。
(00:57:13):
我总是在那次课程中告诉每个人，如果你决定不和我合作，或者我决定……我们不需要理由。没关系，只是不合适，这很正常。你不需要想出一堆理由来拒绝我。这就是过程的一部分。
(00:57:28):
你可能偏好某些人、某些性别、某些背景。你可能会对……感到更舒适或不那么舒适。也许你想要一个像我这样的老家伙，那也没问题。关键是感觉要对。
(00:57:41):
我会请他们谈谈教练辅导对他们意味着什么。因为，再次强调，它可能结合了一些导师制的内容，可能更具战术性。有些教练更有条理：“第一周我们要这样做，第二周我们要那样做……”而另一些则是像我这样的纯粹教练，在开始的五分钟内，我会问你今天想聊什么，因为议程是由你带来的。所以要弄清楚这一点，弄清楚什么适合你。
(00:58:07):
然后我认为有很多好地方可以去。具体来说，国际教练联盟（ICF）是我们的管理机构。你可以在那里找到我们这些获得认证的教练。再次强调，不一定非要找有认证的，但那是寻找专业人士的好地方。
(00:58:23):
还有一些匹配服务，比如 BetterUp、Torch，或者一些更容易接触到的服务。还有一个叫 Prismaticco 的，针对资深高管，定位更高。Scale 刚刚发布了一份与产品经理和产品领导者合作的顶级教练名单，里面有很多优秀的教练。我们可以把链接放进去。Lenny，我想你也参与其中了。

---

### [00:58:43] [Lenny]

**English:**
Yeah. Congrats on winning one of their categories for best coach of ... Which category was that?

**中文翻译:**
是的。恭喜你获得了他们其中一个类别的最佳教练……那是哪个类别？

---

### [00:58:49] [Ken Norton]

**English:**
Product leaders. So, yeah, this was just a setup for you to say that. But thank you. But there's tons of great coach, and different styles, different stages of careers. I think all those folks have work with or have worked with product folks.
(00:59:03):
And so, again, just talk to a few. Reach out to a few. Ask them. If you're looking for more names, ask people who you admire, whose leadership styles you like and want to emulate, who they recommend, because oftentimes they have a better understanding of, hey, this is the type of coach that may want to work with, more of the emotional work, or this is the type of coach who actually maybe has a more compatible vision of what you're looking for, because, look, all coaches are different. You can tell I'm a touchy-feely heart coach.
(00:59:35):
There are coaches who are ... Sometimes people want a coach and they're just like, "You grab that brass ring. We're going to pound the table. I'm going to push you. I'm going to challenge you. I'm going to beat you up. I'm going to be more of a drill sergeant." That's a different style of coach that works with other people. That may be more what you're looking for.
(00:59:50):
So I would just talk to a bunch, do some free sessions, get an opportunity to explore it. I coach people in the free session. So it's not just like we're talking. We're going to talk about something. I'm going to coach you. You're going to get a sense of what this looks like. Then come away and just ask yourself, what are your goals and where was there a fit? If there's not, just keep looking.

**中文翻译:**
产品领导者。所以，是的，这只是为了让你说出这句话而设的套（笑）。但谢谢你。确实有很多优秀的教练，风格各异，针对职业生涯的不同阶段。我想名单上的那些人都与产品人合作过。
(00:59:03):
所以，再次建议，多找几个聊聊。联系几个，问问他们。如果你想找更多名字，去问问那些你钦佩的人，那些你喜欢并想效仿其领导风格的人，问问他们推荐谁。因为通常他们更了解：嘿，这是那种可能想做更多情感工作的教练，或者这是那种可能与你寻找的愿景更契合的教练。因为，你看，每个教练都不同。你可以看出我是一个感性的、走心的教练。
(00:59:35):
也有一些教练……有时人们想要一个教练，他们会说：“你要抓住那个成功的机会。我们要拍桌子。我会逼你，我会挑战你，我会‘折磨’你，我会更像一个钻头教官。”那是另一种适合其他人的教练风格。那可能正是你想要的。
(00:59:50):
所以我建议多聊几个，做几次免费课程，获得探索的机会。我在免费课程中就会开始辅导。所以不只是聊天，我们会谈论具体的事情，我会辅导你。你会对这种形式有一个感觉。然后结束之后问问自己：你的目标是什么？哪里感觉合适？如果不合适，就继续找。

---

### [01:00:09] [Lenny]

**English:**
Amazing. That was very tactically helpful. I really appreciate all those resources. We'll definitely link to all that in the description. I have just a couple questions I wanted to ask you outside of coaching, around some of your posts that you've written before we get to our exciting lightning round. One is around this idea of 10X versus 10%.
(01:00:26):
So you wrote this post about the importance of thinking 10X versus 10%. Truthfully, I actually had a post started, "10X versus 10%." I was like, "Oh, this is going to be great." Then I Googled, "Oh, Ken's already written about it." So I'm glad that you have written about it and written about it so well.

**中文翻译:**
太棒了。这些在战术上非常有帮助。我非常感谢你提供的这些资源。我们肯定会把这些都链接在描述中。在进入令人兴奋的闪电轮环节之前，我还想问几个教练工作之外的问题，是关于你写过的一些文章。其中一个是关于 10 倍（10X）与 10% 的想法。
(01:00:26):
你写过一篇关于 10 倍思维与 10% 思维重要性的文章。说实话，我其实也开始写一篇叫《10X vs 10%》的文章，我想：“噢，这会很棒。”然后我搜了一下，发现：“噢，Ken 已经写过了。”所以我很高兴你已经写了，而且写得这么好。

---

### [01:00:41] [Ken Norton]

**English:**
Great minds think alike, as they say.

**中文翻译:**
俗话说，英雄所见略同。

---

### [01:00:44] [Lenny]

**English:**
Now I don't have to write it. I'd love to just hear your general take on what this idea is and how to think about 10X or 10% bets.

**中文翻译:**
现在我不用写了。我很想听听你对这个想法的总体看法，以及如何思考 10 倍或 10% 的赌注。

---

### [01:00:53] [Ken Norton]

**English:**
Again, I'm a great synthesizer of ideas. This isn't my idea. This is a lot of ... It came from some thinking at Google and some push. I think it's really the sense that we think too small sometimes. You'll see that as a theme for some of the other things I've written too. There needs to be a push. If you really want to have huge breakthrough innovation, you need to be able to try, you need to be able to fail. You need to be able to shoot for the moon is where this 10X comes from.
(01:01:22):
A lot of it is mindset, but a lot of it is also cultural. It's creating environments where ... And I had the great privilege of working at Google for 14 years. I felt like it was definitely an environment that I got to play in, of being willing to take big swings that might fail.
(01:01:36):
This doesn't mean that the company could all be out of business tomorrow. But it's like if you have a choice between trying something that could have a massive breakthrough, a massive change, and playing small ball where you're going to get a bunch of 10% improvements, you are over time, if you're willing to try, if you're willing to fail, if you're willing to push yourself, if you're willing to think bigger, if you're willing to create environments, great ideas come from places that are unexpected, you'll achieve massive, massive breakthrough.
(01:02:02):
You can find the piece on my website, because I use examples from history, but it is a little bit of being brave and trying big things. If you look at all the great technology, the huge breakthrough innovations that we've had, the coronavirus vaccine, just this ... Man, there is no small balling that. That was a big, big swing that there was no guarantee of success, but we were willing to try it. We were willing to fail knowing that failure was probably the more likely outcome in the chance that we would achieve something that would really have that level of breakthrough.
(01:02:36):
And so, I think it is what I always challenge leaders to do is create the environment where people can step in and bring those types of ideas, and not play it safe or not be like, "Ah, boy, that seems like a big one. If we bring that to the CEO, there's no way they'll take a chance. So let's ramp down our expectations. Let's bring this little idea in that is a little bit more guaranteed to work."
(01:03:01):
And so, it is the obligation of leaders to create that environment for people to be able to innovate, because the ideas are out there. I use the example of Kodak. Kodak invented the digital camera. It wasn't like, oh, people at Kodak were dumb. They didn't know digital was coming. No, they literally invented the digital camera. There just wasn't an environment created where the people who had that idea, who saw that potential, who saw that possibility could step up through the plate and try.

**中文翻译:**
同样，我只是一个思想的综合者。这不是我的主意。这很大程度上……源于谷歌的一些思考和推动。我认为这实际上是因为我们有时想得太小了。你会发现这也是我写过的其他一些东西的主题。需要有一种推动力。如果你真的想要巨大的突破性创新，你需要能够尝试，需要能够失败。你需要能够“登月”，这就是 10 倍思维的来源。
(01:01:22):
这很大程度上是心态问题，但很大程度上也是文化问题。它是创造一种环境……我有幸在谷歌工作了 14 年。我觉得那绝对是一个我可以尽情发挥的环境，愿意进行可能失败的大胆尝试。
(01:01:36):
这并不意味着公司明天就会倒闭。但如果你在“尝试可能带来巨大突破、巨大变革的事情”和“打小球、获得一堆 10% 的改进”之间做选择，随着时间的推移，如果你愿意尝试、愿意失败、愿意逼自己一把、愿意想得更大、愿意创造环境，伟大的想法就会从意想不到的地方产生，你就会取得巨大的突破。
(01:02:02):
你可以在我的网站上找到这篇文章，因为我使用了历史上的例子，但这确实关乎勇敢和尝试大事。如果你看看所有伟大的技术，我们拥有的巨大突破性创新，比如冠状病毒疫苗，这种事情……伙计，那可不是打小球能出来的。那是一个巨大的尝试，没有成功的保证，但我们愿意尝试。我们愿意在知道失败可能是更大概率结果的情况下失败，只为了有机会实现那种程度的突破。
(01:02:36):
所以，我认为我总是挑战领导者去做的事情，就是创造一个环境，让人们可以参与进来并提出这类想法，而不是为了稳妥，或者说：“啊，天哪，这看起来是个大工程。如果我们把它提交给 CEO，他们绝不会冒险的。所以让我们降低预期，提交这个更有把握成功的小想法吧。”
(01:03:01):
所以，领导者有义务为人们创造创新的环境，因为想法就在那里。我举过柯达的例子。柯达发明了数码相机。并不是说柯达的人很笨，不知道数码时代要来临。不，他们字面上发明了数码相机。只是没有创造出一种环境，让那些有这个想法、看到这种潜力、看到这种可能性的人能够站出来尝试。

---

### [01:03:29] [Lenny]

**English:**
Do you have any rules of thumb of how many of your ideas/resources should go into these big ideas versus incremental 10% bets, or is the general advice just like people aren't thinking big enough, often enough, so you should always think a little bit bigger than you naturally will?

**中文翻译:**
你有没有什么经验法则，规定应该投入多少想法/资源到这些大想法中，而不是增量式的 10% 赌注？或者一般的建议只是说人们想得不够大、不够频繁，所以你应该总是比你自然想到的再想得大一点？

---

### [01:03:44] [Ken Norton]

**English:**
I think it depends. I mean it depends on the company. If you work in R&D, in labs, maybe everything is in that category and you build a portfolio. If you're a venture capital seed investor, or if you're working at a research lab, it's like you're building a huge portfolio of these bets. You're just assuming that maybe 99 of them will fail, but one will succeed and it'll make it all worthwhile.
(01:04:09):
Most of us aren't in those environments. We're in places where we have real customers buying our products, wanting our products, using our products. We're like, "Let's bet the entire company own 50 things that may not work out." It may not be right for you.
(01:04:20):
So I think it is a little bit of an approach. I think it needs to be thought of in a fractal way, though, because maybe at the company level, they're thinking Google once upon a time had a 70-20-10 thing, whereas 70% is our core business. It's the time we're searching ads. 20% is adjacent business, and then 10% on crazy bets that may not be anything.
(01:04:43):
But I think that's at the company level. At the individual level, at your team level, you might have your own way of thinking. You're just like, okay, I've got 12 engineers on the team. We're working on, at any time, a bunch of stuff that we know we have to do. This is a bunch of stuff that we hope is like 10%. Then we're going to create some space for some innovation. Maybe it's just one engineer every sprint, or it's like a couple of times a year.
(01:05:09):
You create that type of space in your own little air bubble that isn't necessarily at the portfolio level, to try things that may not work. But if they do, the payoff will be so substantial that it'll make the whole thing worthwhile.

**中文翻译:**
我认为这取决于情况。我是说，这取决于公司。如果你在研发部门或实验室工作，也许所有事情都属于那一类，你会建立一个投资组合。如果你是风险投资种子轮投资者，或者在研究实验室工作，你就像是在建立一个巨大的赌注组合。你只是假设其中 99 个可能会失败，但只要有一个成功，一切就都值得了。
(01:04:09):
我们大多数人并不在那种环境中。我们在那些有真实客户购买、需要并使用我们产品的地方。我们不能说：“让我们把整个公司的命运押在 50 件可能行不通的事情上。”这可能不适合你。
(01:04:20):
所以我认为这是一种方法论。不过，我认为需要以一种“分形”的方式来思考。也许在公司层面，他们会考虑——谷歌曾经有一个 70-20-10 原则：70% 是核心业务，比如搜索和广告；20% 是相邻业务；然后 10% 是那些可能一无所获的疯狂赌注。
(01:04:43):
但那是公司层面的。在个人层面、在你的团队层面，你可能有自己的思考方式。你会想：好吧，我团队里有 12 名工程师。我们随时都在处理一堆我们知道必须做的事情，这些是我们希望带来 10% 改进的事情。然后我们要为创新创造一些空间。也许是每个冲刺（sprint）安排一名工程师，或者是每年几次。
(01:05:09):
你在自己的小环境里创造这种空间，而不必非得在整个公司的投资组合层面，去尝试一些可能行不通的事情。但如果行得通，回报将是如此巨大，以至于让这一切都变得值得。

---

### [01:05:23] [Lenny]

**English:**
Awesome. Very helpful. Next question is around I think your most popular post that you've ever written, and maybe the thing that put you on the radar of writing, is around how to hire a product manager. Maybe this is where you mentioned donuts the first time. Is that right, or no?

**中文翻译:**
太棒了。非常有帮助。下一个问题是关于你写过的一篇最受欢迎的文章，也许正是这篇文章让你在写作界崭露头角，那就是关于如何招聘产品经理。也许这就是你第一次提到甜甜圈的地方，对吗？

---

### [01:05:40] [Ken Norton]

**English:**
It's funny. I think that was later.

**中文翻译:**
很有趣。我想那是后来的事。

---

### [01:05:42] [Lenny]

**English:**
Okay.

**中文翻译:**
好的。

---

### [01:05:43] [Ken Norton]

**English:**
Yeah, I think that was a talk that came after that.

**中文翻译:**
是的，我想那是之后的一次演讲。

---

### [01:05:45] [Lenny]

**English:**
Okay, cool.

**中文翻译:**
好的，酷。

---

### [01:05:46] [Ken Norton]

**English:**
Yeah, that was definitely the big one for me.

**中文翻译:**
是的，那对我来说绝对是一篇大作。

---

### [01:05:48] [Lenny]

**English:**
So here's the question, just to keep it simple, what's one piece of advice that you would give people trying to hire a product manager? What's the thing that you think is most maybe missed or useful?

**中文翻译:**
所以问题是，简单来说，你会给那些试图招聘产品经理的人什么建议？你认为最容易被忽视或最有用的东西是什么？

---

### [01:06:00] [Ken Norton]

**English:**
Yeah, I think the intangibles. So basically I wrote that originally as an email, that it was a copy pasta thing for me, where people kept coming to me and being like, "Hey, I think we're going to try to hire a product manager or a company. Can you send over a sample job description?" I'd be like, "Yeah. Before we write the job description, let's talk about what the job is, because I'm not sure we all mean the same thing." And so, then I wrote that ... It was in 2005, so this goes back ... to try to define what the role actually is.
(01:06:31):
I actually feel like maybe the pendulum shifted way too far now where it's the interview process is so structured. Everyone's doing all these mock. They know exactly what questions they're going to get. It's SAT prep. Everyone's ready. But we've missed out with can they do the job? Because it's like they can pass the interview, but can they do the job?
(01:06:53):
And so, I think you have to be careful. This is particularly the case if you are a smaller company. You don't have a huge apparatus of Google and Meta, where you've got interviewing monolith of getting persuaded into ... Maybe this goes back a little bit to the science and the art. They passed all the technical questions. They do all this, they do all that. They do all that. But then you neglect to find out can this person show up and work with these engineers, these designers? Can they inspire them? Is this somebody that they want to follow? Do they have the right mindset for what this job entails? Do we even have an agreement on what their job is going to be?
(01:07:35):
The number of people you see earlier in their career will be like, "Well, I thought I was hiring for this, but it turns that's not even product management," or it was like, "I thought I was going to do this, but all they want me to do is build fee." It's like how'd that not come out in the group process? It's like, well, I know how it didn't come out because they answered a whole bunch of structured questions around ... They did a programming exercise and they did a presentation and nobody stopped to ask.
(01:07:55):
And so, I think that's really the big thing from an interviewer perspective. I think same thing goes for the candidate's perspective. You are interviewing a potential employer. You're interviewing a boss. You're interviewing coworkers. What do you want? What do you care about? What is the type of place you want to be in? What do you not want to be in? How are you evaluating that? How are you asking those questions?
(01:08:18):
Yeah, salary matters, title. All that kind of stuff matters. But you're interviewing a place to plop yourself into. How are you approaching that to make sure you're making the right decision?

**中文翻译:**
是的，我认为是那些无形的东西。基本上，我最初是把它作为一封邮件写的，那是我用来“复制粘贴”的东西。当时人们不断来找我说：“嘿，我想我们要为公司招一个产品经理，你能发个职位描述的样本吗？”我会说：“好啊。但在我们写职位描述之前，先聊聊这份工作到底是做什么的，因为我不确定我们说的是不是同一件事。”于是我在 2005 年写了那篇文章——这已经很久了——试图定义这个角色到底是什么。
(01:06:31):
我实际上觉得现在的钟摆可能摆动得太远了，面试过程变得过于结构化。每个人都在做模拟面试，他们确切地知道会遇到什么问题。这就像 SAT 备考，每个人都准备好了。但我们忽略了：他们能胜任这份工作吗？因为他们能通过面试，并不代表他们能胜任工作。
(01:06:53):
所以，我认为你必须小心。特别是如果你是一家较小的公司，你没有谷歌和 Meta 那样庞大的面试机器。也许这又回到了科学与艺术的问题。他们通过了所有的技术问题，他们做了这个，做了那个。但你却忽略了去发现：这个人能融入并与这些工程师、这些设计师一起工作吗？他们能激励团队吗？这是团队想要追随的人吗？他们是否有适合这份工作的心态？我们对他们的工作内容达成共识了吗？
(01:07:35):
你会看到很多职业生涯早期的人说：“嗯，我以为我被雇来是做这个的，但结果发现那甚至不是产品管理，”或者说：“我以为我要做这个，但他们只想让我做功能堆砌。”这怎么没在面试过程中暴露出来呢？我知道为什么没暴露出来，因为他们回答了一大堆结构化的问题……他们做了编程练习，做了演示，但没人停下来问核心问题。
(01:07:55):
所以，我认为从面试官的角度来看，这是件大事。我认为从应聘者的角度来看也是一样。你也在面试潜在的雇主，面试老板，面试同事。你想要什么？你在乎什么？你想待在什么样的环境里？你不想待在什么样的环境里？你如何评估这些？你如何提出这些问题？
(01:08:18):
是的，薪水很重要，头衔很重要，所有这些都很重要。但你是在面试一个你要投身其中的地方。你如何通过面试确保自己做出了正确的决定？

---

### [01:08:30] [Lenny]

**English:**
Well, with that, we've reached our very exciting lightning round, where I'm going to ask you a few questions and whatever comes to mind, just give me an answer. That's it. Very simple. Does that sound good?

**中文翻译:**
好了，说到这里，我们进入了非常令人兴奋的闪电轮环节。我会问你几个问题，无论你想到什么，直接给我答案就行。就这么简单。听起来不错吧？

---

### [01:08:43] [Ken Norton]

**English:**
Yeah. Inner critic is raging right now.

**中文翻译:**
是的。内在批评者现在正闹腾得厉害。

---

### [01:08:45] [Lenny]

**English:**
Oh, no. Real-time imposter syndrome.

**中文翻译:**
噢，不。实时的冒充者综合征。

---

### [01:08:48] [Ken Norton]

**English:**
Here we go.

**中文翻译:**
开始了。

---

### [01:08:49] [Lenny]

**English:**
[inaudible 01:08:49].

**中文翻译:**
（听不清）。

---

### [01:08:48] [Ken Norton]

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:08:50] [Lenny]

**English:**
Okay. So question one, what are two or three books that you recommend most to other people?

**中文翻译:**
好的。第一个问题，你最推荐给别人的两三本书是什么？

---

### [01:08:55] [Ken Norton]

**English:**
Oh, 15 Commitments of Conscious Leadership. Definitely on that book. I'd just add books I've never recommended before. Probably Innovators Dilemma. It's probably my number one favorite book for product managers and product leaders.

**中文翻译:**
噢，《意识领导力的 15 个承诺》。绝对有这本书。我还会加上一些以前从未推荐过的书。可能是《创新者的窘境》（Innovator's Dilemma）。这可能是我最喜欢的产品经理和产品领导者读物。

---

### [01:09:09] [Lenny]

**English:**
Amazing. What's a recent movie or TV show that you've liked?

**中文翻译:**
太棒了。最近有什么你喜欢的电影或电视节目吗？

---

### [01:09:14] [Ken Norton]

**English:**
I love Ms. Marvel. My whole family were really enjoying it. I love all the MCU stuff. We just eat it up. Ms. Marvel has been amazing. Then watching Barry, which is crazy. It's sort of like nothing else I think ever on TV. Then, over the last year, probably Severance. It's my favorite program over the last ... I'd say last year.

**中文翻译:**
我喜欢《惊奇少女》（Ms. Marvel）。我们全家都很喜欢。我喜欢所有漫威电影宇宙（MCU）的东西，我们看个不停。《惊奇少女》非常棒。还有《巴里》（Barry），那部剧很疯狂，我觉得电视上没有其他剧像它一样。还有过去一年里，可能是《人生切割术》（Severance）。这是我过去一年里最喜欢的节目。

---

### [01:09:34] [Lenny]

**English:**
Wow. Yeah. That is a trippy show. I've watched it all. We might be severed people, we don't even know.

**中文翻译:**
哇。是的。那是一部很玄幻的剧。我全看完了。我们可能也是被“切割”的人，只是自己不知道。

---

### [01:09:39] [Ken Norton]

**English:**
You won't even know.

**中文翻译:**
你甚至不会知道。

---

### [01:09:41] [Lenny]

**English:**
Okay. What is a favorite interview question that you like to ask folks when you interview them?

**中文翻译:**
好的。你面试别人时最喜欢问的问题是什么？

---

### [01:09:46] [Ken Norton]

**English:**
Well, actually let me flip it because I just talked about interviewing as the interview ... Maybe I'll ask a favorite question for people who are being interviewed to ask the employer. Is that fair or is that turn the tables too much?

**中文翻译:**
好吧，实际上让我反转一下，因为我刚才谈到了作为面试官的面试……也许我会给那些被面试的人提供一个问雇主的好问题。这公平吗，还是说反客为主得太厉害了？

---

### [01:09:58] [Lenny]

**English:**
I love it. Yes.

**中文翻译:**
我喜欢这个，请讲。

---

### [01:09:59] [Ken Norton]

**English:**
I think a great question ... Actually maybe I have a couple. I think one question that I love is how does the company define a product team? Because it answers so much. It says so much about culture, collaboration, decision-making, the role of product management. If there's one question and you could figure out what is this culture like, it would be asking that.
(01:10:20):
I think another great question for candidates is to ask them to pick an example of something they've shipped recently and just talk about how it came to be. How did the bill become a law? Was it somebody in sales yelled and it got added to the backlog and it was the next thing? Is it a group of people together understanding customer user needs through discovery and ideating and trying some things and testing it? It says a lot about what it would be like to work there, particularly when it comes to empowerment and product culture. So those are probably two good questions.

**中文翻译:**
我认为一个很棒的问题……实际上我有几个。一个我非常喜欢的问题是：“公司如何定义产品团队？”因为这能回答很多问题。它反映了文化、协作、决策制定以及产品管理的职责。如果只能问一个问题来了解这种文化是什么样的，那就是这个问题。
(01:10:20):
我认为对应聘者来说，另一个好问题是请面试官举一个最近发布的产品的例子，并谈谈它是如何诞生的。这个“法案”是如何变成“法律”的？是因为销售部门的某人大喊大叫，然后它就被添加到了待办事项中并成了下一项任务？还是由一群人通过调研了解客户和用户需求，进行构思、尝试和测试？这能说明在那里工作会是什么样子，特别是在授权和产品文化方面。所以这可能是两个很好的问题。

---

### [01:10:58] [Lenny]

**English:**
Those are really good questions. I'm going to steal them. Final question, who else in the industry do you respect as a thought leader? I imagine this list is very long, but what comes to mind?

**中文翻译:**
这些真的是非常好的问题。我要偷师了。最后一个问题，业内还有谁是你尊敬的思想领袖？我想这个名单会很长，但你现在想到的是谁？

---

### [01:11:06] [Ken Norton]

**English:**
Well, this list is all of my fellow podcast guests on your podcast, Lenny, which is, speaking of imposter phenomenon, is just an incredible group of all the folks that I love and admire. I think, though, because ... Maybe I'll answer it a little bit outside of product, because I would worry that I would leave out too many great names.
(01:11:26):
In the realms of leadership, Amy Edmondson is somebody I really admire. She's done a lot of the work on psychological safety. I really, really value her work, her contributions. There's a guy named Tom Garrity, who has a newsletter about psychological safety. I think he's collaborated with Amy before. It's one of the best, not the best newsletter I received, Lenny, maybe the second best, about psychological safety for those of us that are wanting to create environments where people can really thrive and do their best.
(01:12:05):
In the coaching profession, I mean the coaching profession emerges from the humanist psychology traditions or the client-first work of ... Carl Rogers and Abraham Maslow are intellectual heroes of mine. They're both dead. I don't know if we're supposed to talk about living people here, but definitely as I think about in my profession, they really set the stage and created the environment that coaching could even exist. So I'll include them.

**中文翻译:**
嗯，这个名单就是你播客里的所有其他嘉宾，Lenny。说到冒充者现象，那真的是一群我热爱和钦佩的了不起的人。不过，也许我会给出一个产品领域之外的答案，因为我担心会漏掉太多伟大的名字。
(01:11:26):
在领导力领域，Amy Edmondson 是我非常钦佩的人。她在心理安全感（psychological safety）方面做了大量工作。我非常、非常看重她的研究和贡献。还有一个叫 Tom Garrity 的人，他有一份关于心理安全感的时事通讯。我想他以前和 Amy 合作过。Lenny，那是我收到的最好的时事通讯之一，也许仅次于你的，排名第二。对于我们这些想要创造一个让人们真正茁壮成长并发挥最佳水平的环境的人来说，这非常有用。
(01:12:05):
在教练职业中，这个职业起源于人本主义心理学传统或以客户为中心的工作……卡尔·罗杰斯（Carl Rogers）和亚伯拉罕·马斯洛（Abraham Maslow）是我的精神英雄。他们都去世了，我不知道这里是不是应该只谈论活着的人，但每当我思考我的职业时，他们确实奠定了基础，创造了让“教练”这一职业得以存在的环境。所以我把他们也包括进来。

---

### [01:12:36] [Lenny]

**English:**
Amazing. Ken, this was such a special episode, unlike any other podcast that I've had so far. I can't wait for people to listen to it. Before I let you go, where can folks find you online if they want to reach out, learn more, and then how can listeners be helpful to you?

**中文翻译:**
太棒了。Ken，这是一集非常特别的节目，和我目前做过的任何其他播客都不同。我迫不及待想让大家听到它。在结束之前，如果大家想联系你或了解更多信息，可以在哪里在线找到你？另外，听众可以为你提供什么帮助吗？

---

### [01:12:51] [Ken Norton]

**English:**
Yeah, bringthedonuts.com is my home on the worldwide web. All my writing is there. You can get in contact with me there. I have a newsletter that I am occasionally send out, but you can find all the stuff that I've ever written and get in contact with me there.
(01:13:09):
The how to help be helpful question is a really easy one to answer, but that brings me a lot of joy, which is just keep being awesome product folks. You're so much my tribe. You're so close to my heart, all the work that you do, everything you bring into the world, the amazing products that we get to use that I'm sure you're working on right now that we haven't even seen yet, that you can't wait to share with us, and the cultures and teams that you make better, so your very existence. So I would say you can be helpful to me by just keep doing what you're doing.

**中文翻译:**
是的，bringthedonuts.com 是我的主页。我所有的文章都在那里，你也可以在那里联系我。我有一份偶尔发送的时事通讯，你可以在那里找到我写过的所有东西。
(01:13:09):
关于“如何提供帮助”的问题很容易回答，但它能带给我很多快乐，那就是：继续做优秀的产品人。你们是我的同类，我非常牵挂你们。你们所做的工作、你们带给世界的一切、我们正在使用的那些了不起的产品（我确信你们现在正在开发一些我们还没见过的、迫不及待想分享给我们的产品），以及你们改善的文化和团队——你们的存在本身就是意义。所以我想说，只要继续做你们正在做的事情，就是对我最大的帮助。

---

### [01:13:41] [Lenny]

**English:**
What an awesome answer. Thank you for being here, Ken.

**中文翻译:**
多么棒的回答。谢谢你能来，Ken。

---

### [01:13:43] [Ken Norton]

**English:**
Thanks for having me, Lenny.

**中文翻译:**
谢谢你的邀请，Lenny。

---

### [01:13:46] [Lenny]

**English:**
That was awesome. Thank you for listening. If you enjoyed the chat, don't forget to subscribe to the podcast and, even better, leave a review, which helps a lot. You can also learn more at lennyspodcast.com. I'll see you in the next episode.

**中文翻译:**
太棒了。感谢您的收听。如果您喜欢这次对话，请不要忘记订阅播客，如果能留下评论就更好了，这对我很有帮助。您也可以在 lennyspodcast.com 了解更多信息。我们下期节目再见。