# Kenneth Berger - 双语对照

# Lenny's Podcast: Kenneth Berger Bilingual Transcript

---

### [00:00:00] [Lenny Rachitsky]

**English:**
You were famously the first PM at Slack and then you ended up transitioning into executive coaching.

**中文翻译:**
你是 Slack 著名的第一位产品经理，后来转型成为了高管教练。

---

### [00:00:05] [Kenneth Berger]

**English:**
For me, the impact was about making this work sustainable so that we're not burning out or selling out, but actually able to pursue these hard goals that we have in startups.

**中文翻译:**
对我来说，影响力在于让这种工作变得可持续，这样我们就不会精疲力竭（burn out）或违背初衷（selling out），而是能够真正去追求我们在初创公司中设立的那些艰难目标。

---

### [00:00:14] [Lenny Rachitsky]

**English:**
What we're going to be talking about today is your personal magnum opus, the output of 10 plus years as a founder and operator and seven plus years as a coach.

**中文翻译:**
我们今天要聊的是你的个人代表作（magnum opus），这是你作为创始人和运营者 10 多年，以及作为教练 7 多年的心血结晶。

---

### [00:00:23] [Kenneth Berger]

**English:**
The core idea is ask for what you want. Turns out when you actually ask for what you want out loud, you're much more likely to get it.

**中文翻译:**
核心理念就是：开口要你想要的。事实证明，当你真的大声说出你想要什么时，你得到它的可能性会大大增加。

---

### [00:00:30] [Speaker 3]

**English:**
You're hired.

**中文翻译:**
你被录用了。

---

### [00:00:32] [Lenny Rachitsky]

**English:**
How do you know that this is something you need to be working on?

**中文翻译:**
你怎么知道这是你需要努力的方向？

---

### [00:00:34] [Kenneth Berger]

**English:**
If you're more in the people pleasing camp, maybe you're used to not asking at all. You're hoping that people are reading your mind. And if you're sort of more in the control freak camp, maybe you're used to ordering people around and saying, "Go do this now."

**中文翻译:**
如果你属于“讨好型”人格，也许你习惯了根本不提要求，寄希望于别人能读懂你的心思。而如果你属于“掌控欲强”的人，也许你习惯了对人颐指气使，说：“现在就去干这个。”

---

### [00:00:44] [Lenny Rachitsky]

**English:**
How do you know what you want?

**中文翻译:**
你怎么知道自己想要什么？

---

### [00:00:46] [Kenneth Berger]

**English:**
Complaints are great inspiration. Every complaint implies a dream. Let me envision a better future. Let me think about what's an effective way to actually move towards that. See what it's like to not be sort of living in fear all the time.

**中文翻译:**
抱怨是极好的灵感来源。每一个抱怨都隐含着一个梦想。让我展望一个更美好的未来，让我思考迈向那个目标的有效途径。看看不再整天生活在恐惧中是什么感觉。

---

### [00:01:01] [Lenny Rachitsky]

**English:**
Today, my guest is Kenneth Berger. Kenneth coaches startup leaders to help them avoid burnout and live the life that they want. He was the first product manager at Slack and spent over 10 years in tech before transitioning into coaching. His core focus with leaders is to help them learn how to ask for what they want. This sounds really simple, but as you'll hear in our chat, this one skill is at the core of so many of the struggles that people have in their career and in their life.

**中文翻译:**
今天，我的嘉宾是 Kenneth Berger。Kenneth 担任初创公司领导者的教练，帮助他们避免职业倦怠，过上自己想要的生活。他是 Slack 的第一位产品经理，在转型做教练之前在科技行业工作了 10 多年。他与领导者合作的核心重点是帮助他们学会如何“开口要他们想要的”。这听起来很简单，但正如你在我们的聊天中听到的那样，这项技能是人们在职业生涯和生活中面临的许多挣扎的核心。

---

### [00:01:28] [Lenny Rachitsky]

**English:**
Kenneth shares a ton of very tactical advice to help you figure out what it is you want, how to overcome the resistance that comes with asking for what you want, how to actually ask for what you want effectively, why the most important step is hearing the response that you get when you ask for what you want and all of the things that will change in your life if you get better at this one skill.

**中文翻译:**
Kenneth 分享了大量非常实用的战术性建议，帮助你弄清楚自己到底想要什么，如何克服提要求时的阻力，如何有效地提出要求，为什么最重要的步骤是倾听提要求后的回应，以及如果你掌握了这项技能，你的生活会发生哪些改变。

---

### [00:01:50] [Lenny Rachitsky]

**English:**
Kenneth also shares the story of him being fired three times from Slack, which is hilarious. With that, I bring you Kenneth Berger after a short word from our sponsors. And if you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. It's the best way to avoid missing feature episodes and it helps the podcast tremendously.

**中文翻译:**
Kenneth 还分享了他被 Slack 解雇三次的故事，非常搞笑。在听完赞助商的简短介绍后，我将为你带来 Kenneth Berger 的访谈。如果你喜欢这个播客，别忘了在你不喜欢的播客应用或 YouTube 上订阅并关注。这是避免错过未来节目的最佳方式，也对本播客有很大帮助。

---

### [00:02:09] [Lenny Rachitsky]

**English:**
Let me tell you about a product called Sidebar. The best way to level up your career is to surround yourself with extraordinary peers. This gives you more than a leg up. It gives you a leap forward. This worked really well for me in my career, and this is the Sidebar ethos. When you have a trusted group of peers, you can discuss challenges you're having, get career advice, and just gut check how you're thinking about your work, your career, and your life. This was a big trajectory changer for me, but it's hard to build this trusted group of peers.

**中文翻译:**
让我来介绍一下 Sidebar。提升职业生涯的最佳方式就是与优秀的同行相伴。这不仅能给你提供帮助，还能让你实现跨越式发展。这在我的职业生涯中非常奏效，也是 Sidebar 的核心理念。当你拥有一群值得信赖的同行时，你可以讨论面临的挑战，获得职业建议，并对你对工作、职业和生活的想法进行直觉检查（gut check）。这对我来说是一个巨大的转折点，但建立这样一个值得信赖的同行群体很难。

---

### [00:02:40] [Lenny Rachitsky]

**English:**
Sidebar is a private, highly vetted leadership program where senior leaders are matched with peer groups to lean on for unbiased opinions, diverse perspectives and raw feedback. Guided by world-class programming and facilitation, Sidebar enables you to get focused tactical feedback at every step of your career journey. If you're a listener of this podcast, you're already committed to growth. Sidebar is the missing piece that catalyze your career.

**中文翻译:**
Sidebar 是一个私密的、经过严格筛选的领导力项目，资深领导者会被匹配到同行小组中，从中获得公正的意见、多元的视角和原始的反馈。在世界级课程和引导的指导下，Sidebar 让你在职业生涯的每一步都能获得专注的战术反馈。如果你是本播客的听众，说明你已经致力于成长。Sidebar 正是催化你职业生涯的那块缺失拼图。

---

### [00:03:06] [Lenny Rachitsky]

**English:**
93% of members say Sidebar helped them achieve a significant positive change in their career. Why spend a decade finding your people when you can meet them at Sidebar today? Join thousands of top senior leaders who have taken the first step to career growth from companies like Microsoft, Amazon, and Meta by visiting sidebar.com/lenny. That's sidebar.com/lenny.

**中文翻译:**
93% 的成员表示 Sidebar 帮助他们在职业生涯中实现了显著的积极变化。既然今天就能在 Sidebar 遇到志同道合的人，为什么要花十年时间去寻找呢？访问 sidebar.com/lenny，加入成千上万来自微软、亚马逊和 Meta 等公司的顶尖资深领导者的行列，迈出职业成长的第一步。网址是 sidebar.com/lenny。

---

### [00:03:32] [Lenny Rachitsky]

**English:**
This episode is brought to you by Webflow. We're all friends here, so let's be real for a second. We all know that your website shouldn't be a static asset. It should be a dynamic part of your strategy that drives conversions. That's business 101. Here's a number for you. 54% of leaders say web updates take too long. That's over half of you listening right now. That's where Webflow comes in. Their visual first platform allows you to build, launch, and optimize webpages fast.

**中文翻译:**
本集节目由 Webflow 赞助。大家都是朋友，咱们实话实说。我们都知道网站不应该是一个静态资产，它应该是你驱动转化的战略中动态的一部分。这是商业基础。给你一个数据：54% 的领导者表示网站更新耗时太长。这超过了现在正在收听节目的一半人。这就是 Webflow 的用武之地。他们的视觉优先平台让你能够快速构建、发布和优化网页。

---

### [00:04:02] [Lenny Rachitsky]

**English:**
That means you can set ambitious business goals and your site can rise to the challenge. Learn how teams like Dropbox, IDEO and Orangetheory trust Webflow to achieve their most ambitious goals today at webflow.com.

**中文翻译:**
这意味着你可以设定宏伟的业务目标，而你的网站能够应对挑战。立即访问 webflow.com，了解 Dropbox、IDEO 和 Orangetheory 等团队如何信任 Webflow 来实现他们最宏伟的目标。

---

### [00:04:20] [Lenny Rachitsky]

**English:**
Kenneth, thank you so much for being here. Welcome to the podcast.

**中文翻译:**
Kenneth，非常感谢你能来。欢迎来到本播客。

---

### [00:04:23] [Kenneth Berger]

**English:**
Yay. thanks for having me.

**中文翻译:**
耶，谢谢邀请。

---

### [00:04:30] [Lenny Rachitsky]

**English:**
I love that, yay. That should be a tradition that everyone goes with. I love that. So we originally met when I was doing a post on being a first product manager at a company. You were famously the first PM at Slack, and then you ended up transitioning into executive coaching, which is what you do now. What we're going to be talking about today is something that you described to me as, quote, your personal magnum opus, the output of 10 plus years as a founder and operator, and seven plus years as a coach to startup leaders.

**中文翻译:**
我喜欢这个“耶”。这应该成为每个人的传统。我喜欢。我们最初相识是因为我写了一篇关于担任公司首位产品经理的文章。你是 Slack 著名的第一位 PM，后来转型做高管教练，也就是你现在从事的工作。我们今天要聊的是你向我描述为“个人代表作”的内容，这是你作为创始人和运营者 10 多年，以及作为初创公司领导者教练 7 多年的成果。

---

### [00:04:59] [Lenny Rachitsky]

**English:**
And the core idea is simply asking for what you want, which sounds really simple. So let me just start broadly just why have you found that this skill, this one idea is so core to so many of the challenges that people run into in work and in life?

**中文翻译:**
核心理念非常简单，就是“开口要你想要的”，听起来确实很简单。那么让我先从大处着眼，为什么你发现这项技能、这一个想法，是人们在工作和生活中遇到的这么多挑战的核心？

---

### [00:05:19] [Kenneth Berger]

**English:**
If I had to answer in one word, it would be integrity. I think that it's one of these funny things where everyone thinks they already know how to ask for what they want. We all ask for what we want. We order our coffee in the morning and we all think we have integrity. No one walks around thinking, "I'm lying to myself all the time or lying to others certainly." And yet we tend to fool ourselves a little bit. When it comes to are we really pursuing the things that we want in life? And I think to me, the flip side of that is sort of the reason that the stakes around asking for what you want are so high because we can't guarantee we're going to get what we want.

**中文翻译:**
如果非要用一个词来回答，那就是“正直/言行一致”（integrity）。我觉得这是一件很有趣的事情，每个人都觉得自己已经知道如何开口要自己想要的了。我们都会提要求，早上点咖啡就是提要求，而且我们都觉得自己很有原则。没有人会整天想着“我一直在欺骗自己，或者肯定在欺骗别人”。然而，在是否真的在追求生活中想要的东西这件事上，我们往往会自欺欺人。对我来说，另一面是，关于“开口要你想要的”这件事之所以赌注如此之高，是因为我们无法保证一定能得到想要的东西。

---

### [00:05:59] [Kenneth Berger]

**English:**
But if we're asking for it regularly, if we're listening to the response, we're expecting the nose we get from the world, then we can get the sense of, "Yeah, I'm honoring what's important to me. I'm honoring the world's response and I'm moving forward towards what I want." And if we don't do that, "Well, then we're fooling ourselves that we're actually moving towards of what we want." There tends to be all these unexpected secondary and tertiary effects that come out of that of stress and frustration, and unhappiness because of course, asking for what we want, pursuing what's important to us in life is just one of the most important things of fulfillment, of what's important in achieving our purpose.

**中文翻译:**
但如果我们经常提出要求，倾听回应，预料到世界会给我们的拒绝（no），那么我们就能感觉到：“是的，我在尊重对我重要的事情。我在尊重世界的反馈，并朝着我想要的目标前进。”如果我们不这样做，那我们就是在自欺欺人，以为自己真的在朝着目标前进。这往往会产生各种意想不到的二阶、三阶负面效应，比如压力、挫折和不快乐。因为当然，开口要我们想要的，追求生活中对我们重要的事情，是获得成就感、实现人生目标最重要的事情之一。

---

### [00:06:37] [Lenny Rachitsky]

**English:**
What are just some challenges that people have in their life and career that are just rooted in doing this badly? Not asking for what you want, not knowing what you want.

**中文翻译:**
人们在生活和职业生涯中，有哪些挑战仅仅是因为这件事没做好而产生的？比如不开口要想要的，或者不知道自己想要什么。

---

### [00:06:47] [Kenneth Berger]

**English:**
For me with clients, I think what I'm often looking for are just kind of this sense of being stuck because everybody has got frustrations. Everybody gets nervous at work sometimes. But if we're in the same stuck place week after week after week in our coaching sessions, probably you're trying the same thing and not getting any different results. It's that definition of insanity thing.

**中文翻译:**
对于我的客户，我通常会观察他们是否有一种“停滞不前”的感觉。因为每个人都会有挫折感，每个人在工作中偶尔都会紧张。但如果在我们的教练环节中，你周复一周地处于同样的困境中，那很可能你一直在尝试同样的方法，却没有得到不同的结果。这就是所谓的“疯狂的定义”（重复做同样的事却期待不同的结果）。

---

### [00:07:11] [Kenneth Berger]

**English:**
So really I look at that and say, "Okay. Maybe you're asking for what you want." Maybe. Although often people aren't. But even if you are, you're probably not achieving it. You're not getting the results that you want. So why are we not learning from that? Why are we not moving forward getting new data, trying something new, actually treating it as a sort of iterative development discovery process?

**中文翻译:**
所以我会观察并想：“好吧，也许你在开口要你想要的。”也许吧，尽管通常人们并没有。但即使你提了，你可能也没有实现它，没有得到想要的结果。那么为什么我们不从中学习呢？为什么我们不向前迈进，获取新数据，尝试新事物，真正把它当作一种迭代开发和探索的过程呢？

---

### [00:07:32] [Kenneth Berger]

**English:**
So I think that stuckness is one thing. And I think the other thing I look for is interpersonal conflict, right? Because I think that one mode of not asking for what you want well is holding back and not really saying it out loud. I think another really common mode is coming with a lot of entitlement of, "You know what? You better do what I say. I'm your boss. You're my report. You better obey or agree," or whatever it is. And of course the danger of that is interpersonal conflict. Even if you are their boss, that's a really disrespectful way to come into the conversation and it's an obvious source for a lot of issues.

**中文翻译:**
所以我觉得“停滞感”是一方面。另一方面我观察的是人际冲突。因为我认为“没能好好表达需求”的一种模式是退缩，不真正大声说出来。另一种非常常见的模式是带着一种优越感（entitlement）：“你知道吗？你最好按我说的做。我是你老板，你是我的下属，你最好服从或同意。”当然，这样做的危险在于人际冲突。即使你是他们的老板，这也是一种非常不尊重的沟通方式，也是许多问题的明显根源。

---

### [00:08:09] [Lenny Rachitsky]

**English:**
Before we get into how to learn to do this better and more of why this is so important, is there an example from your career where you did this really badly or you didn't ask what you want?

**中文翻译:**
在我们深入探讨如何做得更好以及为什么这如此重要之前，你职业生涯中是否有做得特别糟糕，或者没有表达自己需求的例子？

---

### [00:08:19] [Kenneth Berger]

**English:**
There's so many examples. I think we will eventually get into the story of how I was fired from Slack. But I think for me, the thing that always came up was just being attached to being right. And I think a lot of us get into this boat. We enter into a meeting and we're sure from the first moment, "I'm right and they're wrong." And I think that especially in product management, we're supposed to be the holders of this vision for what the product should be. And so it's easy to come in with a lot of conviction and not really a lot of openness to other ideas.

**中文翻译:**
例子太多了。我想我们最终会聊到我被 Slack 解雇的故事。但对我来说，经常出现的问题是执着于“我是对的”。我想我们很多人都在同一条船上。我们走进会议室，从第一刻起就确信“我是对的，他们是错的”。我认为特别是在产品管理中，我们应该是产品愿景的持有者。因此，很容易带着极强的信念进来，而对其他想法缺乏开放性。

---

### [00:08:51] [Kenneth Berger]

**English:**
Often what I try to introduce people to, and I've learned all this stuff the hard way, believe me, is it's fundamentally disrespectful to go into a meeting already deciding that you're right and the other person is wrong because you can't know that for sure. There's always a new perspective, new data that could come in. And so you want that conversation to really be a back and forth. And if you're coming in with this really ingrained sense of righteousness, you can't do that. There's no way to have that conversation.

**中文翻译:**
我经常尝试引导人们理解——相信我，这些都是我通过惨痛教训学到的——在进入会议之前就认定自己是对的而别人是错的，这从根本上是不尊重的，因为你不可能百分之百确定。总会有新的视角、新的数据出现。所以你希望对话是真正的互动。如果你带着这种根深蒂固的正义感进来，你就无法做到这一点，对话根本无法进行。

---

### [00:09:17] [Lenny Rachitsky]

**English:**
I think you may have already answered this question, but I think it's really important is how do you know that this is something you need to be working on? How do you know like, "I really need to pay attention to what Kenneth is about to tell me?" You said one is you feel you're stuck in your career, something you're just not making progress, and this could be the answer. Or you said there's interpersonal conflict and you're just having a lot of conflict with people. Are those the two answers? Are there more?

**中文翻译:**
我想你可能已经回答了这个问题，但我认为这非常重要：你怎么知道这是你需要努力的方向？你怎么知道“我真的需要注意 Kenneth 接下来要说的话”？你提到一个是感觉职业生涯停滞不前，没有进展，而这可能是答案。或者你提到存在人际冲突，你经常和人发生冲突。这就是那两个答案吗？还有更多吗？

---

### [00:09:37] [Kenneth Berger]

**English:**
I think those are great things to look for. I think it's also good to look for a sense of things being high stakes, because I think part of what can create a lot of conflict and difficulty in these situations is a sense of this is life or death. And that was certainly how it was when I was a founder of, "Okay, normally..." When I was at Adobe, it's a big company, they're going to be fine either way, no matter what I do. Right? I can be easy going. Let someone else have their way in the meeting. But when it was my company, when it was my vision on the line, I didn't feel especially flexible. The stakes seemed really, really high.

**中文翻译:**
我觉得这些都是很好的观察点。我认为留意那种“事关重大”（high stakes）的感觉也很重要，因为在这种情况下，产生冲突和困难的部分原因在于一种“生死攸关”的感觉。当我还是创始人的时候，情况确实如此。以前我在 Adobe 的时候，那是一家大公司，无论我做什么，他们都会好好的。对吧？我可以随和一点，让别人在会议上按他们的意思办。但当那是我的公司，当我的愿景面临考验时，我就感觉没那么灵活了。赌注看起来非常、非常高。

---

### [00:10:12] [Kenneth Berger]

**English:**
This is the success of my idea, of my vision, my reputation is on the line. And so I think often when the stakes feel high, we're kind of focused more on the fear of what we don't want to happen than on actually achieving what we do want. And that's a really critical distinction because if we're running away from our fears, it doesn't necessarily mean we're getting anywhere meaningful for what our desires are. And so that sense of high stakes that often we can get, whether it's in interpersonal conflict or being afraid of asking for what we want, that can get us really focused on the fears rather than focused on the goals.

**中文翻译:**
这关乎我想法的成败，关乎我的愿景，我的名誉也面临考验。所以我认为，当赌注感觉很高时，我们往往更关注对“不希望发生的事情”的恐惧，而不是真正去实现“想要的事情”。这是一个非常关键的区别，因为如果我们只是在逃避恐惧，并不一定意味着我们在朝着欲望的终点迈进。因此，无论是在人际冲突中，还是在害怕开口要我们想要的东西时，那种“事关重大”的感觉会让我们过度关注恐惧，而不是目标。

---

### [00:10:48] [Lenny Rachitsky]

**English:**
There's a question I was going to save for later, but it's something that's very top of mind for me is knowing what you want. How do you know what you want? There's basically knowing what you want and then asking for what you want. I like equanimity in my life, and so I often don't ask for what I want or push down maybe what I want, or I don't think about what I want. I just want other people to be happy.

**中文翻译:**
有一个问题我本想留到后面，但现在它在我脑海中挥之不去，那就是：如何知道自己想要什么？这基本上分为“知道自己想要什么”和“开口要你想要的”。我喜欢生活中的平静（equanimity），所以我经常不提要求，或者压抑自己的想法，甚至不去想自己想要什么。我只想让别人开心。

---

### [00:11:15] [Lenny Rachitsky]

**English:**
I'm curious what people can do and what I can do to get better at knowing here's what actually want, here's what would make me happy and fulfilled? What are some skills there I could work on and other people can work on?

**中文翻译:**
我很想知道，人们可以做些什么，我可以做些什么，来更好地了解自己真正想要什么，什么会让我感到快乐和满足？有哪些技能是我和其他人可以去磨练的？

---

### [00:11:27] [Kenneth Berger]

**English:**
Well, first of all, I'd say you're very far from alone there. I mean, I think the people pleaser coping strategy is one of the sort of most classic, and it is effective, right? In the short term like, "Oh, you can feel safe and calm when other people are generally happy with you." And the cost tends to be long term in terms of am I really pursuing the things that are important to me?

**中文翻译:**
首先，我想说你绝不是一个人在战斗。我认为“讨好型”人格的应对策略是最经典的之一，而且它确实有效，对吧？在短期内，当别人对你普遍满意时，你会感到安全和平静。但代价往往是长期的：我真的在追求对我重要的事情吗？

---

### [00:11:48] [Kenneth Berger]

**English:**
So one of my favorite techniques here is this concept they call dream behind the complaint. Because you're right that we tend to not be that great always at really dreaming and envisioning and saying, "This is my dream of what I want out of life." That can sound really scary for people, but we're very good at complaining. Usually people are very good at saying, "Oh my God, there's this thing happening at work, it's so annoying. Or there's this person that really bothers me so much, why are they always like this?"

**中文翻译:**
我最喜欢的技巧之一是一个叫做“抱怨背后的梦想”的概念。因为你说得对，我们往往不擅长真正去梦想、去憧憬并说出“这就是我对生活的梦想”。这对人们来说可能听起来很吓人，但我们非常擅长抱怨。通常人们很擅长说：“天哪，公司发生了这件事，太烦人了。或者那个人真的让我很困扰，为什么他们总是这样？”

---

### [00:12:17] [Kenneth Berger]

**English:**
So the magic of that complaining is that every complaint implies a dream. It implies a better world where that complaint is resolved. And so often that's the tool that I'll take people to first to say, "All right, great. Let's complain. Right? It feels so fun and good and releasing to complain, and let's look at what that implied world is behind that complaint." What is this vision? And then to really check, "Okay. Let's imagine you get that. That's the world of the future that you get. How does that feel? Is that big enough or is it kind of meh?"

**中文翻译:**
抱怨的神奇之处在于，每一个抱怨都隐含着一个梦想。它隐含着一个更好的世界，在那里抱怨得到了解决。所以这通常是我带人们使用的第一个工具，我会说：“好极了，让我们来抱怨吧。抱怨感觉很有趣、很爽、很解压，让我们看看抱怨背后隐含的世界是什么样的。”那个愿景是什么？然后去真正检查：“好，想象一下你得到了那个。那是你未来的世界。感觉如何？它足够宏大吗，还是感觉一般般？”

---

### [00:12:50] [Kenneth Berger]

**English:**
Are we like, "Oh, my dream is that I get to speak up a little more in meetings?" It's like, "Well, that's probably not a hundred percent of your dream. What's really behind that?" And so I think that check can help you sort of level up to say, "Is this really an inspiring dream for me that's going to motivate me more than those fears that might be hiding in the background?"

**中文翻译:**
我们是不是在想：“哦，我的梦想是在会议上多发点言？”这就像是：“那可能不是你梦想的全部。背后真正的原因是什么？”所以我认为这种检查可以帮助你提升层次，问自己：“这对我来说真的是一个鼓舞人心的梦想吗？它能比那些潜伏在背景中的恐惧更能激励我吗？”

---

### [00:13:13] [Kenneth Berger]

**English:**
On the flip side, with entitled people, you can also get really unrealistic dreams where I might say, "Okay. So it sounds like what I'm hearing is that your dream is that everyone obeys you and automatically agrees with you no matter what." And they sort of say, "Ah, I don't know if that's quite my dream." And so if your dream is so embarrassing to say out loud, you can't even really own it, maybe that's not the right dream. And so that checking whether it actually feels inspiring, but also sort of credible and possible is a good way to find that middle ground where, "Yeah, this dream is hard. I don't know that I'm going to get it, but, damn, it's worth trying. I want to go for it."

**中文翻译:**
另一方面，对于那些有优越感的人，你也可能会得到非常不切实际的梦想，我可能会说：“好吧，听起来你的梦想是让每个人都服从你，无论如何都自动同意你的观点。”他们可能会说：“呃，我不确定那是不是我的梦想。”如果你的梦想尴尬到不敢大声说出来，甚至无法真正认同它，那也许它就不是正确的梦想。因此，检查它是否真的令人振奋，同时又是否可信、可行，是找到中间地带的好方法：“是的，这个梦想很难。我不确定能不能实现，但该死的，它值得一试。我想去争取。”

---

### [00:13:54] [Lenny Rachitsky]

**English:**
I love that for someone that wants to try this on their own and help themselves get better at this without you being there, what is it that you do? Is it you dream about what would make you happiest? Is it complain and see what's at the root of it? Is it just imagine a world where you're really happy and see what emerges.

**中文翻译:**
我喜欢这个。对于那些想自己尝试、在没有你指导的情况下提升这项技能的人，具体该怎么做？是梦想什么会让你最快乐？是抱怨并寻找根源？还是仅仅想象一个你非常快乐的世界，看看会出现什么？

---

### [00:14:11] [Kenneth Berger]

**English:**
Specifically for articulating what you want because that's the first step of the asking for what you want process. It really is as simple as that of let's start with what you have consciously in terms of what you want. And if you have trouble, then we can try looking at complaints and starting to articulate a vision out of that.

**中文翻译:**
具体到明确表达你想要什么，因为这是“开口要你想要的”过程的第一步。它真的就那么简单：让我们从你意识中已经知道的想要的东西开始。如果你有困难，那么我们可以尝试观察抱怨，并从中开始勾勒出一个愿景。

---

### [00:14:29] [Kenneth Berger]

**English:**
But to me, really what's interesting about asking for what you want is that on the surface it's very simple, right? I mean, the steps I outline are articulate what you want, ask for what you want intentionally and accept the response and then try again. Because it's an iterative process. We're learning from the response and what it tells us because the response is usually no. So really what tends to be hard there, I mean, that's a straightforward process. It's not rocket science. What's hard there is the resistance.

**中文翻译:**
但对我来说，关于“开口要你想要的”真正有趣的地方在于，表面上它非常简单，对吧？我是说，我概述的步骤是：明确表达你想要的，有意识地提出要求，接受回应，然后再次尝试。因为它是一个迭代过程。我们从回应中学习，因为回应通常是“不”。所以真正难的地方——我是说，这是一个很直接的过程，不是什么高深科学——难点在于阻力（resistance）。

---

### [00:14:58] [Kenneth Berger]

**English:**
The parts of us that are not so excited about that, that thinks asking for what we want is scary and articulating a big dream that we might not get is really scary. Because god, what if I don't get it? What does that mean about me? Am I a failure? Or what does it mean if I respect the no? What if I ask for my big dream and someone tells me I'm not going to get it? What does that mean? How am I going to feel?

**中文翻译:**
我们内心有些部分对此并不兴奋，认为提出要求很可怕，明确一个可能无法实现的宏大梦想也非常可怕。因为天哪，如果我没得到怎么办？那对我意味着什么？我是个失败者吗？或者如果我尊重那个“不”意味着什么？如果我提出了宏大的梦想，而有人告诉我我得不到，那意味着什么？我会是什么感觉？

---

### [00:15:19] [Kenneth Berger]

**English:**
So working through all that resistance is really a lot of what tends to be tricky about asking for what you want because otherwise it's articulate, ask, accept.

**中文翻译:**
所以，克服所有这些阻力，才是“开口要你想要的”这件事中最棘手的部分，否则它就只是：表达、要求、接受。

---

### [00:15:28] [Lenny Rachitsky]

**English:**
Okay. You're getting into where we're going to go. Before we get there. Final question. This idea of dealing with, no, I think this is the other big blocker for people is like, "Oh, that's so scary to ask for something I really want or ask for something big that is really important to you." What is it that you advise there of just getting over this fear of just asking for what you want?

**中文翻译:**
好的，你正切入我们要讨论的主题。在此之前，最后一个问题。关于应对“不”（no），我认为这是人们的另一个大障碍：“噢，开口要我真正想要的东西，或者要一件对我非常重要的大事，太可怕了。”关于克服这种恐惧，你有什么建议？

---

### [00:15:49] [Kenneth Berger]

**English:**
So I have a more expansive definition of no than most people, I think, because for me it's not a yes unless it's a hell yes. Because you really want enthusiastic consent. Not just, "Maybe, kinda. I'll try. We'll see. But yeah, absolutely, let's do this." And I think that often it's so tempting to settle for something less than that to say, "Oh, well, okay, we'll give that a try." And that often comes to bite us later on because we accept this thing that short of a hell yes. And then we realized later on, "Oh yeah, they weren't really in."

**中文翻译:**
我想，我对“不”的定义比大多数人更宽泛。因为对我来说，除非是“太棒了，当然可以”（hell yes），否则就不是“行”（yes）。因为你真正想要的是热情的同意。不仅仅是“也许吧，大概，我会试试，再看看”，而是“是的，绝对没问题，咱们干吧”。我认为通常人们很容易退而求其次，说：“噢，好吧，那我们试试看。”这往往会在以后让我们自食其果，因为我们接受了一个并非“hell yes”的答复。然后我们后来才意识到：“噢，原来他们并没有全身心投入。”

---

### [00:16:26] [Kenneth Berger]

**English:**
They didn't show up to the party or they didn't deliver on time because my CTO said, "Yeah, I think maybe we can deliver by May 1st." And then May 1st comes and surprise, surprise, your milestone is not done because you didn't go for that hell yes. And so I think part of what I encourage people to do is, one, to really hear anything short of a hell yes as a no. So it's not a bad thing. Mostly the world tells us it's actually really great data. It helps us figure out what are we going to try next? What are we going to try next, try next, try next? Because that's going to help us learn how to actually get to that hell yes.

**中文翻译:**
他们没来参加聚会，或者没按时交付，因为我的 CTO 说：“是的，我想也许我们能在 5 月 1 日前交付。”然后 5 月 1 日到了，意不意外，惊不惊喜，你的里程碑没完成，因为你当时没有争取那个“hell yes”。所以我鼓励人们去做的一件事是：把任何不到“hell yes”程度的回答都听成是“不”。这并不是坏事。通常世界告诉我们“不”，其实是非常棒的数据。它帮助我们弄清楚下一步要尝试什么？下一步，再下一步，再下一步？因为这将帮助我们学会如何真正达到那个“hell yes”。

---

### [00:17:03] [Kenneth Berger]

**English:**
And part of that asking process is of not settling for it, but actually asking and saying, "Hey, I'm hearing maybe you're lukewarm on May 1st as a date. What would be a hell yes day for you where you could say, absolutely, we can deliver on that?" And that way we're not making them wrong for saying no. We're saying, "Of course you get to say no. Everybody gets to say no whenever they want. But let's get to a hell yes. What would it take for us to get there?"

**中文翻译:**
提要求过程的一部分就是不妥协，而是真正去问：“嘿，我听出来你对 5 月 1 日这个日期似乎不太积极。对你来说，哪一天才是‘hell yes’的日期，能让你说‘绝对没问题，我们一定能交付’？”这样我们不是在指责他们说“不”。我们是在说：“你当然可以拒绝。每个人随时都有权拒绝。但让我们达成一个‘hell yes’。我们需要怎么做才能达到那个状态？”

---

### [00:17:29] [Lenny Rachitsky]

**English:**
That's a really helpful framework and phrase to use is just what would it take to get to hell yes? Not just what would it take to get to you feeling comfortable with this? What would it take for you to just agree to this? It's more a hell yes. And your point there is hell yes is when they actually fully agree. Oftentimes people kind of like, "Yeah, yeah, yeah, yeah." And then they don't actually follow through.

**中文翻译:**
这是一个非常有用的框架和表达方式：“怎样才能达到 hell yes 的状态？”而不仅仅是“怎样才能让你觉得舒服？”或者“怎样才能让你同意？”更多的是一种“hell yes”。你的观点是，“hell yes”是他们真正完全同意的时候。通常人们会说“行行行”，但实际上并没有贯彻执行。

---

### [00:17:49] [Kenneth Berger]

**English:**
Some people call this a whole body yes because sometimes your head is saying yes, but your heart is saying no or your gut is saying no. And so I think you can really feel in your body when you've got a hell yes, when all of you is fully in and ready to do this.

**中文翻译:**
有些人称之为“全身心的认同”（whole body yes），因为有时你的大脑说行，但你的心说不行，或者你的直觉说不行。所以我认为，当你得到一个“hell yes”时，你的身体真的能感觉到，那时你整个人都完全投入并准备好去做了。

---

### [00:18:06] [Lenny Rachitsky]

**English:**
And this applies to, you're giving examples here of just getting like aligning a deadline. I imagine the same skill applies to everything in relationship questions and friends and family and work.

**中文翻译:**
这适用于你举的例子，比如达成截止日期的共识。我猜同样的技能也适用于人际关系、朋友、家人和工作中的一切。

---

### [00:18:19] [Kenneth Berger]

**English:**
It does. And it is something universal, but I do think of it as being particularly relevant to my work with startups because I work primarily with startup founders. Because with startups you know that mostly they fail. We all know the numbers on that. And so to me, there's a perspective you have to take if you're going to operate in the startup world of being okay with not knowing that you're going to get the outcome you want. A lot of people, we operate in a safer world where we're more clear exactly what the outcomes are going to be, but if you're a startup founder, you've got to be okay with, "I'm just going to go for this, and I know I probably won't get it. But it's so meaningful to me, I'm going to go for it anyway."

**中文翻译:**
确实如此。它是通用的，但我认为它与我处理初创公司的工作特别相关，因为我主要与初创公司创始人合作。因为在初创公司，你知道大多数都会失败，我们都知道那些数据。所以对我来说，如果你要在初创界混，你必须持有一种观点：即使不知道是否能得到想要的结果，也没关系。很多人生活在一个更安全的世界里，结果非常明确。但如果你是初创公司创始人，你必须接受：“我就要去争取这个，我知道我可能得不到。但它对我意义重大，无论如何我都要去争取。”

---

### [00:19:00] [Kenneth Berger]

**English:**
And so to me, that's not just about the big picture of running a startup, it's about really anything you might want in life, because that's such a useful perspective to say, "I know I'm not going to get it. I know I'm not guaranteed to get it. I'm not going to be attached to that. I know people aren't obligated to tell me yes, but I'm going to go forward anyway because I want it and that's enough."

**中文翻译:**
所以对我来说，这不仅仅关乎经营初创公司的大局，它关乎你在生活中可能想要的任何事情。因为这是一种非常有用的视角：“我知道我可能得不到。我知道我不能保证得到。我不会执着于此。我知道别人没有义务对我说‘行’，但我还是要向前迈进，因为我想要它，这就足够了。”

---

### [00:19:20] [Lenny Rachitsky]

**English:**
So let's actually get into the skill of learning how to actually ask for what you want more effectively. You already described three steps, so maybe just describe them again and let's just walk through them.

**中文翻译:**
那么让我们进入学习如何更有效地“开口要你想要的”这项技能。你已经描述了三个步骤，也许可以再描述一遍，让我们逐一过一遍。

---

### [00:19:32] [Kenneth Berger]

**English:**
The first step is articulating what you want. And we've gone into this a little bit, but to me, I think that the key places that people tend to have missteps here, or one in this phrase, it's fine. I think of the "it's fine" cartoon with the flames and the dog, I think it is. But I think a lot of us fall into that trap of saying, "You know what? I'm fine. I actually, I don't need anything. I'm good."

**中文翻译:**
第一步是明确表达你想要什么。我们已经讨论了一点，但对我来说，我认为人们最容易犯错的地方，或者说最容易掉进的陷阱，就是“我很好”（it's fine）这句话。我想到了那个著名的漫画：一只狗坐在火焰中说“我很好”。我认为我们很多人都会掉进这个陷阱，说：“你知道吗？我很好。我其实什么都不需要，我挺好的。”

---

### [00:19:59] [Kenneth Berger]

**English:**
And again, this is tempting, right? Because it's so nice to have this idea that I'm fine, I don't need anything. And in a certain way, that's a nice attitude because yeah, we're not guaranteed anything, so it's nice to be okay with the status quo. But for those folks, often what I'm encouraging that do is to really tune into the parts of them that maybe aren't so fine like, "Gosh, I'd prefer it a little bit if things were this way or yeah, I'm a little bit bothered by this, or I'm a little bit nervous about this."

**中文翻译:**
这确实很有诱惑力，对吧？因为“我很好，我什么都不需要”这种想法感觉很棒。在某种程度上，这是一种很好的态度，因为既然不能保证得到任何东西，那么对现状感到满意也不错。但对于这些人，我通常鼓励他们去真正关注内心那些可能“并不太好”的部分，比如：“天哪，如果事情是这样的话我会更喜欢一点”，或者“是的，这件事让我有点困扰”，或者“我对这件事有点紧张”。

---

### [00:20:26] [Kenneth Berger]

**English:**
And so kind of tuning more into those subtle emotions that are pointing them towards, "Sure, I'm okay with the status quo, but I want something more." And so helping them articulate that in a clearer way where they can want something without being attached to having to get it. The other extreme of this is people who articulate these sort of wildly unrealistic goals. So this is the founder that just wants everyone to agree with him all the time and to obey him immediately.

**中文翻译:**
所以要更多地关注那些微妙的情绪，它们在暗示：“当然，我对现状没意见，但我想要更多。”帮助他们以更清晰的方式表达出来，让他们可以想要某样东西，而不必执着于一定要得到它。另一个极端是那些提出极其不切实际目标的人。比如那种希望每个人随时都同意他、并立即服从他的创始人。

---

### [00:20:56] [Kenneth Berger]

**English:**
So for those folks, it really tends to be more about saying it out loud. Once you say it out loud, it is clearer. That's not really what it's about. And so for those folks, I tend to ask them to go deeper to say, "Yeah, I know you're not a control freak. You don't want everyone to think exactly what you think. What's it really about? What does that get you?" And so often it goes from being this more kind of objective external goal to being a more kind of social emotional goal of, "You know what, I just want to have a team that feels really aligned around me and we're just ready to go for it and we've got each other's backs."

**中文翻译:**
对于这些人，重点在于大声说出来。一旦你说出口，事情就会变得更清晰：那其实并不是真正的目的。所以对于这些人，我倾向于让他们深入挖掘：“是的，我知道你不是掌控狂。你并不真的想让每个人的想法都和你一模一样。那到底是为了什么？那能给你带来什么？”于是，它通常会从一个客观的外部目标转变为一个社交情感目标：“你知道吗，我只是想要一支真正与我保持一致的团队，我们准备好大干一场，并且彼此支持。”

---

### [00:21:35] [Kenneth Berger]

**English:**
That doesn't mean we agree with each other all the time or that we're a hundred percent aligned in everything, but it doesn't mean there's a certain feeling that I have when I go into work. Even though I don't know that we're going to get what we want or that everyone is going to agree.

**中文翻译:**
这并不意味着我们随时都意见一致，或者在所有事情上都百分之百同步，但这意味着当我走进办公室时，我有一种特定的感觉。尽管我不知道我们是否能得到想要的结果，或者每个人是否都会同意。

---

### [00:21:47] [Lenny Rachitsky]

**English:**
Do you have any examples from your time you could share of someone articulating what they want and figuring out how they articulate, how to articulate what they want just to make it even more real?

**中文翻译:**
你有没有自己经历过的例子可以分享？关于某人明确表达自己的需求，并弄清楚如何表达，如何让它变得更真实？

---

### [00:21:58] [Kenneth Berger]

**English:**
To me a lot of the classic examples are around feedback. Because I work with a lot of founders who are not the sort of classic control freaks. They're super nice and their teams love them and they love their teams. So for them, it can be really hard to deliver hard feedback, to deliver negative feedback and even more to actually create consequences. Because the thing about accepting other people's no is that, "Sure, they can always say no. Everybody gets to say no whenever they want, but there are consequences." And so the classic thing I see with the nice founders is they're really afraid to actually create consequences when people are not living up to their expectations. Right?

**中文翻译:**
对我来说，很多经典的例子都围绕着反馈。因为我与许多并非典型“掌控狂”的创始人合作。他们人超级好，团队爱他们，他们也爱团队。所以对他们来说，给出严厉的反馈、负面的反馈，甚至更进一步去设定后果（consequences），是非常困难的。因为接受别人的拒绝（no）的关键在于：“当然，他们随时可以拒绝。每个人随时都有权说不，但拒绝是有后果的。”所以我看到的那些“好人”创始人的典型问题是，当员工没有达到预期时，他们真的害怕去设定后果。对吧？

---

### [00:22:40] [Kenneth Berger]

**English:**
When they're not aligned with the culture, they're not delivering in the way that the CEO wants them to be delivering because it doesn't seem that nice. They're like, "Oh, I think of myself as nice and of being so kind and of people loving me." And it's like, "Well, that doesn't mean that there aren't consequences for their actions."
(00:22:56):
Part of really respecting them is respecting that they can make the choices they want and they're grownups enough that they can deal with the consequences of those choices."

**中文翻译:**
当员工与文化不符，或者没有按 CEO 想要的方式交付成果时，设定后果看起来似乎“不太友善”。他们会想：“噢，我觉得自己是个好人，我很善良，大家都爱我。”但事实是：“这并不意味着他们的行为不需要承担后果。”真正尊重他们的一部分，就是尊重他们可以做出自己想要的选择，并且他们已经成熟到可以承担这些选择带来的后果。

---

### [00:23:05] [Lenny Rachitsky]

**English:**
Can you even get more concrete there? Is it we need to hit this date, or are there going to be big problems? Or is it like, "I need you to hire this large of a team?" I don't know. What is it that they're not articulating that they later realize, "Oh, here's what I need to articulate."

**中文翻译:**
你能再具体一点吗？是“我们需要在某个日期前完成，否则会有大麻烦”？还是“我需要你招聘这么大规模的团队”？我不知道。他们之前没有表达出来，后来才意识到“噢，这就是我需要表达的内容”的是什么？

---

### [00:23:20] [Kenneth Berger]

**English:**
So I think sometimes it is about alignment, the disagree and commit. So I see that a lot of founders saying, "Hey, I'm super respectful of your differing opinion here, and I totally validate you and I appreciate you. Thank you so much for sharing that." But they're not willing to go that extra step and say, "Yeah, but this is the call and I need you to actually follow through with that. I understand that might be disappointing or frustrating or what have you, but part of the expectation for this role is that you can roll with disagree and commit sometimes when that's necessary."

**中文翻译:**
我认为有时是关于一致性，即“保留意见并执行”（disagree and commit）。我看到很多创始人会说：“嘿，我非常尊重你在这里的不同意见，我完全认可你，也感谢你。非常感谢你的分享。”但他们不愿再进一步说：“是的，但这就是最终决定，我需要你真正去执行。我理解这可能会让你失望或沮丧，但这个职位的预期之一就是，在必要时你能够做到‘保留意见并执行’。”

---

### [00:23:52] [Lenny Rachitsky]

**English:**
That's an awesome example. I fully get that and I could see how scary that is to a lot of people. One is just coming to terms with, "This is what I actually want to be doing, but I just don't feel like I can because it's going to, I think, upset people." Okay. So what else can you suggest people do to help identify what it is they want and articulate what they want?

**中文翻译:**
这是一个极好的例子。我完全理解，也能看出这对很多人来说有多可怕。首先是接受现实：“这就是我真正想做的，但我只是觉得我做不到，因为我觉得这会让人不高兴。”好的。那么，你还有什么建议可以帮助人们识别并表达自己的需求？

---

### [00:24:40] [Kenneth Berger]

**English:**
It always comes back to integrity. And a great way to do an integrity check is to just look have I fully expressed myself? And so I think we've talked a little bit about charting your feelings as a piece of that of like, "Yeah, am I really tuning into how annoyed I am or how frustrated I am or how nervous I am?" Because if I haven't fully owned those feelings and expressed those in whatever way is appropriate, then probably I'm not fully in integrity.

**中文翻译:**
这最终总会回到“正直/言行一致”（integrity）上。进行正直检查的一个好方法是看看：我是否已经充分表达了自己？我们之前谈到过记录自己的感受，比如：“是的，我是否真的关注到了我有多烦恼、多沮丧或多紧张？”因为如果我没有完全接纳这些感受，并以适当的方式表达出来，那么我可能就没有完全做到言行一致。

---

### [00:25:09] [Kenneth Berger]

**English:**
I think saying what you have to say is a piece of that too. "Gosh, is there something that I keep thinking about and I'm just like three or four days, I'm just like, man, I really want to say this to this person." At this point, you're probably out of integrity because there's something deep in you that really needs to say this, right? And so to me, articulating what you want is really about mindfulness is about checking for all these things.

**中文翻译:**
我认为说出你必须说的话也是其中的一部分。“天哪，是不是有什么事我一直在想，想了三四天，我心想，伙计，我真的很想对那个人说这件事。”到这一步，你可能已经违背了内心的正直，因为你内心深处有些东西真的需要表达出来，对吧？所以对我来说，明确表达你想要的，实际上关乎正念（mindfulness），关乎检查所有这些事情。

---

### [00:25:35] [Kenneth Berger]

**English:**
What is the part of me that's not fully expressed? Because it doesn't mean I'm going to get what I want or that people are going to give me all my dreams immediately, but it feels so much better to have it out. That sort of suffering that fear usually comes from holding it in and saying, "Oh, having these stories of I'm not allowed to say that. It's not appropriate to express that I'm bored in this meeting." Versus saying, "Probably a lot of people would be grateful if we said out loud, 'I'm bored in this meeting.' Let's move things along."

**中文翻译:**
我内心哪一部分还没有完全表达出来？因为这并不意味着我一定会得到想要的，或者别人会立即实现我所有的梦想，但说出来感觉会好得多。那种痛苦和恐惧通常源于压抑，源于内心戏：“噢，我不被允许说那个。在会议上表达我很无聊是不合适的。”而另一种做法是说：“如果有人大声说‘这个会我很无聊，咱们快点吧’，可能很多人都会心存感激。”

---

### [00:26:04] [Lenny Rachitsky]

**English:**
This episode is brought to you by Vanta. When it comes to ensuring your company has top-notch security practices, things get complicated fast. Now you can assess risks, secure the trust of your customers and automate compliance for SOC2, ISO 27001, HIPAA and more with a single platform, Vanta. Vanta's market-leading trust management platform helps you continuously monitor compliance alongside reporting and tracking risks. Plus, you can save hours by completing security questionnaires with Vanta AI. Join thousands of global companies that use Vanta to automate evidence collection, unify risk management, and streamline security reviews. Get $1,000 off Vanta when you go to vanta.com/lenny. That's vanta.com/lenny.

**中文翻译:**
本集节目由 Vanta 赞助。在确保公司拥有顶尖安全实践方面，事情很快就会变得复杂。现在，你可以通过 Vanta 这一个平台评估风险、赢得客户信任，并自动完成 SOC2、ISO 27001、HIPAA 等合规认证。Vanta 市场领先的信任管理平台可帮助你持续监控合规性，同时报告和跟踪风险。此外，你还可以通过 Vanta AI 完成安全问卷，从而节省数小时的时间。加入成千上万使用 Vanta 自动收集证据、统一风险管理并简化安全审查的全球公司行列。访问 vanta.com/lenny，即可享受 Vanta 1000 美元的优惠。网址是 vanta.com/lenny。

---

### [00:27:12] [Kenneth Berger]

**English:**
So for asking what you want, I think the really important tweak here is asking intentionally because I think a lot of us are stuck on a certain track that's comfortable for us when we ask. And so if you're more in the people-pleasing camp, maybe you're used to not asking at all. You're hoping that people are reading your mind and just magically knowing what you want.

**中文翻译:**
关于“开口要你想要的”，我认为非常重要的调整是“有意识地提要求”（asking intentionally）。因为我认为我们很多人在提要求时都困在了一条让自己感到舒适的特定轨道上。如果你属于讨好型人格，也许你习惯了根本不提要求，希望别人能读懂你的心思，神奇地知道你想要什么。

---

### [00:27:34] [Kenneth Berger]

**English:**
And if you're more in the control-free camp, maybe you're used to ordering people around and saying, "Go do this now." And so for both of those folks, it's not about... I think if you ask any of them, "Is this working for you?" They'd say no. Of course, it's obvious from an effectiveness standpoint, it's not working well, but they more just haven't embraced that you can do it a different way that they only really see one way of doing it.

**中文翻译:**
如果你属于掌控欲强的人，也许你习惯了对人颐指气使，说：“现在就去干这个。”对于这两类人，如果你问他们：“这对你有效吗？”他们都会说不。当然，从效率的角度来看，这显然效果不佳，但他们只是还没有意识到可以用不同的方式去做，他们只看到了一种方式。

---

### [00:28:00] [Kenneth Berger]

**English:**
So part of asking for what you want effectively is really just recognizing the rut that you get stuck in and working through all those narratives that make us resist asking it a different way. Because often the people who don't want to ask have a story that says, "This is too risky. Or it's not worth it. They're going to say no anyway, so why even bother?"

**中文翻译:**
所以，有效地开口要你想要的，其一部分实际上就是识别出你陷入的陈规，并克服所有那些让我们抵制以不同方式提要求的内心戏。因为通常那些不想提要求的人内心都有一个故事：“这太冒险了。或者这不值得。反正他们也会拒绝，何必费劲呢？”

---

### [00:28:24] [Kenneth Berger]

**English:**
So these are all very common things that people go through, but then they end up not actually asking for what they want. Now, actually expressing who they are and what they stand for in the world. And that has a really serious cost. I think that we tend to tell ourselves the story, "Oh, this is fine. I'll be fine." Versus owning, "I'm going to be living my life not asking for what I want." Do I really want to be at my funeral and have people say, "Oh, Kenneth played it safe. He didn't really go for his dreams, but he was nice. No one was ever mad at him." That's not what we want people to say at our eulogies.

**中文翻译:**
这些都是人们经历的非常普遍的事情，但结果就是他们并没有真正开口要他们想要的。他们没有真正表达自己是谁，以及他们在世界上代表什么。这付出了非常沉重的代价。我认为我们倾向于告诉自己：“噢，这没关系，我会没事的。”而不是正视：“我的一生都将不开口要我想要的。”我真的希望在我的葬礼上，人们说：“噢，Kenneth 这一生过得很稳妥。他没有真正追求过梦想，但他很友善，从来没有人对他发过火。”这绝不是我们希望在悼词中听到的话。

---

### [00:29:01] [Lenny Rachitsky]

**English:**
No. That's good motivation. Okay. Say in this example you gave of like, "I need us to make a decision. I know I'm trying to keep everyone happy, but we need to make a decision." Do you have advice for maybe phrases of how to approach. You talked about making intentional. How do you actually go about doing that? Is it the way you communicate it? Is it something else? How do you actually do this without pissing people off and also just risking too much?

**中文翻译:**
不，这是很好的动力。好的。假设在你举的例子中，比如“我需要我们做一个决定。我知道我一直在努力让每个人都开心，但我们需要做一个决定。”关于如何切入，你有什么建议的措辞吗？你谈到了要有意识。具体该怎么做？是沟通的方式吗？还是别的什么？你如何既不惹恼别人，又不冒太大的风险？

---

### [00:29:33] [Kenneth Berger]

**English:**
Even implicit in that question, to me that's that question of, "Oh, how do I do it without being any risk of ever pissing anyone off?" That's a piece of the resistance right there. And so this is a great example of the type of work that we have to do, right? Because in theory, asking is easy, "Oh, you just try some way and maybe people are pissed off and maybe they're not." But probably it's going to be fine and you'll have the chance to try again and iterate and work from it.

**中文翻译:**
甚至在这个问题中，对我来说，隐含的意思就是：“噢，我该如何在没有任何激怒任何人的风险的情况下做到这一点？”这本身就是阻力的一部分。这是一个很好的例子，说明了我们需要做哪类工作，对吧？因为理论上，提要求很容易：“噢，你就试着提一下，也许人们会生气，也许不会。”但很可能结果会没事的，你会有机会再次尝试、迭代并从中改进。

---

### [00:30:00] [Kenneth Berger]

**English:**
But often we get stuck so we don't get to go through those levels of iteration because we want to make sure we're going to get the outcome. We say, "Oh, well, I'm not willing to ever piss anyone off ever. And so I'm just going to be stuck at this step because I haven't figured out what's going to guarantee me." And of course, there's no guarantee. We can never guarantee that people are going to feel a particular way.

**中文翻译:**
但通常我们会被困住，无法进行那些迭代，因为我们想确保一定能得到想要的结果。我们会说：“噢，好吧，我不愿意激怒任何人。所以我就会被困在这一步，因为我还没想出什么能给我保证。”当然，没有保证。我们永远无法保证别人会有什么样的感觉。

---

### [00:30:22] [Kenneth Berger]

**English:**
So part of asking for what you want effectively is actually bringing some compassion for yourself. Of course, we all want to be sure that the way we ask is going to be effective and no one is going to be mad at us and we're going to get all of our dreams come true. But we don't get that. I wish we did. That would be nice. But is that worth not pursuing your dreams in life?

**中文翻译:**
所以，有效地开口要你想要的，其一部分实际上是给自己一些同情心。当然，我们都希望确保我们提要求的方式是有效的，没有人会生我们的气，我们所有的梦想都能实现。但现实并非如此。我希望是这样，那会很美好。但为了这个，就不去追求人生梦想，值得吗？

---

### [00:30:45] [Lenny Rachitsky]

**English:**
Such a good point about what you identified and the way... I think a lot of people that think about it, it's just like, "I'd always do this without causing anyone any pain or risking anything going wrong." I think that's, to your point, part of it. So you talk a lot about founders. You work with a lot of founders, a lot of listeners here are not founders, they're product managers, ICs on teams, other functions that don't have "power". Is there anything that you suggest these folks do differently or think about this differently or is it kind of the same thing? In the end everyone has power in some way. How would you think about this if you're just, say, a product manager, individual contributor?

**中文翻译:**
你识别出的这一点以及这种方式……说得太好了。我认为很多人在思考时都会想：“我总是想在不给任何人造成痛苦或冒任何风险的情况下完成这件事。”我认为，正如你所说，这就是问题的一部分。你谈到了很多关于创始人的内容。你与许多创始人合作，但这里的许多听众不是创始人，他们是产品经理、团队中的个人贡献者（IC），或者是其他没有“权力”的职能部门。你是否建议这些人采取不同的做法，或者以不同的方式思考，还是说其实是一样的？毕竟每个人在某种程度上都有权力。如果你只是一个产品经理、个人贡献者，你会如何考虑这个问题？

---

### [00:31:23] [Kenneth Berger]

**English:**
I think one of the most important balances in terms of the asking step is both asking clearly, but asking with great humility. And this actually works whether you're in a position of power or not because I think a lot of folks will go so far to the end of humility. They say, "Well, I'm not going to say this out loud at all." But in fact, if you're willing to say, I really disagree with this product decision and I would really prefer that we make this different decision. I know it's not my call and I'm just one opinion and a lot of people are going to see things differently and that's fine, but it's important to me that you know that. So what do you think? Are you willing to reconsider this?"

**中文翻译:**
我认为在“提要求”这一步中，最重要的平衡之一是既要清晰地表达，又要保持极大的谦逊。无论你是否处于权力地位，这其实都奏效。因为我认为很多人在谦逊方面走得太远了，他们会说：“好吧，我根本不会大声说出来。”但事实上，如果你愿意说：“我真的不同意这个产品决定，我真的更希望我们做另一个决定。我知道这不是我说了算，我只是一个人的意见，很多人会有不同的看法，这没关系，但让你知道这一点对我来说很重要。所以你怎么看？你愿意重新考虑一下吗？”

---

### [00:32:00] [Lenny Rachitsky]

**English:**
That's such a great approach. It's very not scary to say that. It also, I think, highlights something I wanted to touch on is I think people have a lot more influence and power than they think they do. Say a PM on a team disagrees with a plan for a product. People actually care about your opinion and you could actually change things. But just telling them, "I think this is a bad idea." And you often don't. Is that what you find, that people have a lot more influence than they think they do? Anything along those lines that comes up?

**中文翻译:**
这是一种非常棒的方法。说出这样的话一点也不可怕。而且，我认为这突出了我想触及的一点：人们拥有的影响力和权力比他们想象的要大得多。假设团队中的一名 PM 不同意某个产品计划。人们其实很在乎你的意见，你其实可以改变现状。但你往往不会告诉他们：“我认为这是个坏主意。”你是否发现人们的影响力比他们想象的要大？有什么相关的例子吗？

---

### [00:32:35] [Kenneth Berger]

**English:**
You're giving me deep goosebumps because I think this is a really underappreciated thing in terms of asking for what we want because especially in the PM world, we're trained to look for data. We're not just going to state an opinion. We're going to say, "Oh, the AB test said this. Or 30% of our users do this, or the ROI on this is X." And data is great. We love data for a reason of course. And I think people forget about exactly what you're highlighting, that your relationships matter, and that just your opinion because you believe something or because you want something often that's enough.

**中文翻译:**
你让我起了一身鸡皮疙瘩，因为我认为在“开口要你想要的”这件事上，这是一个非常被低估的点。特别是在 PM 的世界里，我们被训练去寻找数据。我们不会只陈述观点，我们会说：“噢，AB 测试结果是这样，或者 30% 的用户这样做，或者这个的投资回报率（ROI）是 X。”数据当然很好，我们喜欢数据是有原因的。但我认为人们忘记了你强调的那一点：你的人际关系很重要，仅仅因为你相信某件事或想要某件事而提出的观点，往往就足够了。

---

### [00:33:13] [Kenneth Berger]

**English:**
Because guess what? You're in a relationship with these people you work with. They care about you. You have some sort of leverage with them. And I think that often people go the other way and say, "Oh, I've got power. I'm going to try and leverage it." But actually, if you go the other direction and you're humble and you say, "I know I can't make you do anything, it's not my call to make. But man, this is really what I want. I'm just going to put it out there and ask." That I think it feels really vulnerable and uncomfortable to not lean on data as a sort of way of saying, "No, no, I'm right, so you should believe what I believe." But just say, "Actually, I don't know that I'm right. This is just what I think and I hope that's enough on its own."

**中文翻译:**
因为你猜怎么着？你与共事的人是有关系的。他们在乎你。你在他们面前是有某种筹码的。我认为通常人们会走另一个极端，说：“噢，我有权力，我要试着利用它。”但实际上，如果你反其道而行之，保持谦逊并说：“我知道我不能强迫你做任何事，这不是我能决定的。但是，伙计，这真的是我想要的。我只是把它摆出来问问。”我认为，如果不依靠数据作为一种“不，不，我是对的，所以你应该相信我所相信的”手段，会让人感到非常脆弱和不舒服。但只要说：“实际上，我不知道我是不是对的。这只是我的想法，我希望这本身就足够了。”

---

### [00:33:50] [Lenny Rachitsky]

**English:**
Do you find that that's actually a crutch a lot of times to people not saying anything is they don't have that data? They don't have evidence and they just, "I shouldn't say anything. If someone asks for why I don't have a great answer, I just think this is what should be."

**中文翻译:**
你是否发现，很多时候“没有数据”成了人们保持沉默的借口？他们没有证据，于是就想：“我不该说什么。如果有人问我为什么，我没有一个完美的答案，我只是觉得应该是这样。”

---

### [00:34:03] [Kenneth Berger]

**English:**
Totally. And I think there's a balance there as with anything. Is ignoring data and going in gut all the time, great? Probably not, right? We use data for a reason, but I think there are all these moments when we are making a gut decision and having all the data there means having the opinion set out loud. I think often the dangers of people saying, "Oh, I don't have data to back this up. It's just what I think. And I'm not sure people are going to agree with me, so I'm just not going to say it."

**中文翻译:**
完全正确。我认为凡事都有平衡。完全忽视数据、总是凭直觉行事好吗？可能不好，对吧？我们使用数据是有原因的。但我认为在很多时刻，我们是在做直觉决定，而拥有所有数据意味着大声说出观点。我认为危险往往在于人们说：“噢，我没有数据支持这一点。这只是我的想法。我不确定人们是否会同意我，所以我干脆不说了。”

---

### [00:34:35] [Kenneth Berger]

**English:**
So we don't have the data of all those gut opinions of these subject matter experts in the room, even though that gut information to me is just as important as anything we could get from the SQL database or whatever.

**中文翻译:**
这样我们就失去了房间里这些领域专家所有直觉观点的“数据”，尽管对我来说，这些直觉信息与我们从 SQL 数据库或其他任何地方获得的信息一样重要。

---

### [00:34:48] [Lenny Rachitsky]

**English:**
Before we move on to step three, you talked about the opposite of asking for what you want. This was just step two is just complaining and being angry later like, "I knew this project was going to fail. I knew this was a terrible deadline. I knew this design was not great." Anything more you want to say along those lines of just like, "If you're not asking for what you want, complaining is often a sign that you should be doing that more"?

**中文翻译:**
在进入第三步之前，你谈到了“开口要你想要的”的反面。这其实就是第二步，即事后抱怨和生气，比如：“我就知道这个项目会失败。我就知道这个截止日期很糟糕。我就知道这个设计不太好。”关于这一点你还有什么想说的吗？比如“如果你不开口要你想要的，抱怨往往是一个信号，表明你应该多做这件事”？

---

### [00:35:11] [Kenneth Berger]

**English:**
To me, complaints are great inspiration. To me, I love radical candor, for example, where I try to go a step further than radical candor is to not just say, "Hey, here's my feedback. Just wanted you to know." But to say, "And I want something. I would like to see an outcome." And so I think that to me it's all about the effective framing that the complaint is probably not going to be an effective way to do it, but it can be great inspiration to say, "Gosh, that complaining means I'm frustrated. What am I frustrated about? Let me envision that better future. Let me think about what's an effective way to actually move towards that. What's an effective way to communicate that desire that's actually likely to get me towards a yes?"

**中文翻译:**
对我来说，抱怨是极好的灵感。例如，我非常推崇“彻底坦诚”（radical candor），我尝试比“彻底坦诚”更进一步，不仅仅是说：“嘿，这是我的反馈，只是想让你知道。”而是说：“而且我想要一些东西，我希望能看到一个结果。”所以对我来说，关键在于有效的框架：抱怨本身可能不是一种有效的方式，但它可以成为极好的灵感，让你说：“天哪，抱怨意味着我很沮丧。我为什么沮丧？让我憧憬一下更美好的未来。让我思考一下迈向那个目标的有效途径。用什么有效的方式来沟通这个愿望，才真正有可能让我得到肯定的答复？”

---

### [00:35:58] [Kenneth Berger]

**English:**
And so when we actually embrace that sort of frustration, annoying, complaining thing and follow that thread down and think about how to be effective that way, we can actually get something really compelling and useful, but it requires actually embracing that part of ourselves that sometimes we're a little bit ashamed of like, "Oh, I don't like that whiny part of myself. I'm just going to push that one down versus actually taking what it has to say as important data."

**中文翻译:**
所以，当我们真正接纳那种沮丧、烦恼、抱怨的情绪，并顺着这条线索思考如何以有效的方式处理时，我们其实可以得到一些非常有说服力和有用的东西。但这需要我们真正接纳那部分有时让我们感到羞愧的自我，比如：“噢，我不喜欢自己爱发牢骚的那一面。我要把它压下去。”而不是真正把它要说的话当作重要的数据。

---

### [00:36:24] [Lenny Rachitsky]

**English:**
That's a really good point. I think that's actually another blocker for a lot of people is just, "I don't want to be a complaining person. I just want to be like, let's do this. I'm in, let's go. I don't want to be seen as a squeaky wheel." Is there anything you say there about as a resistance point for people?

**中文翻译:**
这是一个非常好的观点。我认为这实际上是很多人的另一个阻碍：“我不想成为一个爱抱怨的人。我只想表现得积极配合。我不想被看作是一个‘刺头’（squeaky wheel）。”关于这个阻力点，你有什么想说的吗？

---

### [00:36:40] [Kenneth Berger]

**English:**
Well, I'm a big fan of internal family systems, which is this sort of psychotherapy technique that really talks about parts and the sort of parts of ourselves and the ways in which they don't always agree with each other. Part of why I love this approach is, A, because we already use this language. We say, "Part of me thinks this, a part of me thinks that." And really when I talk about how to work through resistance, really it's about embracing and validating all of our parts.

**中文翻译:**
我是“内部家庭系统”（Internal Family Systems, IFS）的忠实粉丝，这是一种心理治疗技术，它讨论了我们内在的“部分”，以及这些部分并不总是意见一致。我喜欢这种方法的部分原因是，首先，我们已经在用这种语言了。我们会说：“我内心的一部分这么想，另一部分那么想。”当我谈到如何克服阻力时，实际上就是关于接纳并认可我们所有的部分。

---

### [00:37:07] [Kenneth Berger]

**English:**
Because often we're really comfortable with one part of ourselves that we think is, "Oh, this part is virtuous and good and great, and this part is whiny and bad, and not great, and I don't respect that part of me as much." So really to sort of ask effectively, we generally need to embrace all these parts and really bring in all the information they're bringing in because if we ignore the part that's really scared to ask, well, then we're going to stay stuck.

**中文翻译:**
因为通常我们只对自己认为“高尚、善良、优秀”的那部分感到舒适，而认为另一部分是“爱发牢骚、糟糕、不怎么样”的，并且不那么尊重那部分自我。所以，为了有效地提要求，我们通常需要接纳所有这些部分，并真正整合它们带来的所有信息。因为如果我们忽视了那个“真的害怕提要求”的部分，我们就会一直停滞不前。

---

### [00:37:32] [Kenneth Berger]

**English:**
Versus if we come in and say, "Hey, buddy, why are you scared? You seem terrified. What's going on? Oh, well man, you think your whole professional reputation has staked on this and you're an imposter and they're going to find out, and then you'll never work again? Well, of course you'd be scared. That makes a ton of sense." And by embracing that, instead of ignoring that and being ashamed of that, that is often how we soften those fears and say, "I know that's scary, but we also know that's not really true. You're not an imposter, right? You're an experienced professional."

**中文翻译:**
反之，如果我们走进去说：“嘿，伙计，你为什么害怕？你看起来吓坏了。怎么了？噢，天哪，你觉得你整个职业声誉都押在这上面了，你觉得自己是个冒牌货，他们会发现真相，然后你就再也找不到工作了？好吧，你当然会害怕。这完全说得通。”通过接纳这种情绪，而不是忽视它或为此感到羞愧，我们通常能软化那些恐惧并说：“我知道那很可怕，但我们也知道那不是真的。你不是冒牌货，对吧？你是一个经验丰富的专业人士。”

---

### [00:38:01] [Lenny Rachitsky]

**English:**
Man, there's so many threads we can't follow here. This whole line of internal family systems, right?

**中文翻译:**
天哪，这里有太多我们可以深入探讨的话题了。比如内部家庭系统，对吧？

---

### [00:38:06] [Kenneth Berger]

**English:**
Mm-hmm.

**中文翻译:**
嗯哼。

---

### [00:38:07] [Lenny Rachitsky]

**English:**
That's its own podcast episode potentially. And then imposter syndrome, we've touched a bunch of different podcast episodes, but I'll avoid going in that direction. Something you reminded me of is we just had Carole Robin on the podcast who taught this class touchy-feely at Stanford for a long time, which is all about helping people learn how to deal with other people, which we never learned in life. It's like a class, how to learn to work with other people.

**中文翻译:**
这本身就可能是一集播客的内容。还有冒充者综合征，我们在很多集播客中都提到过，但我会避免往那个方向发展。你提醒了我一件事，我们刚邀请了 Carole Robin 来节目，她在斯坦福教了很久那门叫“感性”（touchy-feely）的课，内容是关于帮助人们学习如何与他人打交道，这是我们生活中从未学过的。这就像一门课，教你如何学习与他人合作。

---

### [00:38:29] [Kenneth Berger]

**English:**
I took one of Stanford's T-Group Weekends, summer of 2020, I think a month after George Floyd was murdered and was facilitated by a black woman. And it was one of the most profound transformative weekends of my life. Because T-groups already people rave about them. But having it at that point in history with those people in the room, oof.

**中文翻译:**
我参加过斯坦福的一个 T-Group 周末课程，那是 2020 年夏天，大概是在乔治·弗洛伊德被谋杀一个月后，由一位黑人女性引导。那是我生命中最深刻、最具变革性的周末之一。因为 T-groups 本身就让人赞不绝口，但在那个历史时刻，和那些人待在同一个房间里，呼，太震撼了。

---

### [00:38:53] [Lenny Rachitsky]

**English:**
A lot of tears, I imagine.

**中文翻译:**
我猜当时流了很多泪。

---

### [00:38:54] [Kenneth Berger]

**English:**
It was crazy. I mean, it was really wild.

**中文翻译:**
太疯狂了。我是说，那真的很震撼。

---

### [00:38:58] [Lenny Rachitsky]

**English:**
I feel like every single person that has gone through, I think it's called Leaders in Tech is the broader umbrella term. And Carole talked about it. Everyone that has gone through it, 100% have told me that it's a transformative life experience for them. And you had a bonus transformational piece. So anyway, if people want to check out that episode, I will include it in the show notes. But the reason I brought it up is Carole shared this framework for how to actually give feedback in a way where people can receive it that I'll just highlight here. I have it here.

**中文翻译:**
我觉得每一个参加过——我想那个大项目的名称叫“科技领袖”（Leaders in Tech）——Carole 也谈到了它。每一个参加过的人都 100% 告诉我，那是改变人生的经历。而你还有额外的感悟。总之，如果大家想听那一集，我会把它放在节目介绍里。我提到这个的原因是，Carole 分享了一个如何给反馈的框架，让对方能够接受。我在这里强调一下，我手头就有。

---

### [00:39:26] [Lenny Rachitsky]

**English:**
And it's somewhat related to nonviolent communication, which is what you touched on. And she told me, actually, she taught this way before nonviolent communication came out with their whole philosophy. And it's basically when you want to give someone feedback, the template is when you do a behavior, I feel a feeling, and she's big on like say actual feeling word not like, "I feel like, or I feel that," blah, blah, blah. And step three is, "I'm telling you this because..." and then what you want them to change. Do you find that sort of approach helpful?

**中文翻译:**
这在某种程度上与你提到的非暴力沟通有关。她告诉我，实际上她在非暴力沟通那套哲学出现之前很久就在教这个了。基本上，当你给某人反馈时，模板是：“当你做某个行为时，我感到某种情绪。”她非常强调要说实际的情绪词，而不是“我觉得像……”或“我觉得……”之类的。第三步是：“我告诉你这些是因为……”，然后是你希望他们做出的改变。你觉得这种方法有用吗？

---

### [00:40:01] [Kenneth Berger]

**English:**
I do. I teach the same thing. I think sort of Carole's approach and nonviolent communication, DBT teaches a similar approach. They call dear man.

**中文翻译:**
有用。我也是这么教的。我认为 Carole 的方法、非暴力沟通，以及辩证行为疗法（DBT）教授的方法都很相似。他们称之为 DEAR MAN。

---

### [00:40:12] [Lenny Rachitsky]

**English:**
To me, what's DBT?

**中文翻译:**
对我来说，什么是 DBT？

---

### [00:40:14] [Kenneth Berger]

**English:**
It's a dialectical behavioral therapy. It's related to CBT. So there's kind of rough consensus in the sort of personal development world of how to ask. And really what they have in common is around staying really factual because I think that what can we know factually well? We can know our thoughts, we can know our feelings because no one else can know that better than us. Maybe we can trust our eyes. What would a video camera have recorded? And that's about it.

**中文翻译:**
它是辩证行为疗法（Dialectical Behavioral Therapy），与认知行为疗法（CBT）相关。所以在个人成长领域，关于如何提要求，存在着大致的共识。它们的共同点在于保持真实，因为我认为我们能确切知道的事实是什么？我们可以知道自己的想法，可以知道自己的感受，因为没有人比我们自己更了解这些。也许我们还可以相信自己的眼睛：摄像机会记录下什么？仅此而已。

---

### [00:40:44] [Kenneth Berger]

**English:**
So I think often we get really distracted by all these stories we have about the data, but when we bring it back to that fundamental core of this is what I think, this is what I feel, this is what I've observed in the world, it tends to make the ask a lot clearer versus these stories like you mentioned of, "I feel like you're an asshole." It's like, "Well, that's a story. That's not a fact."

**中文翻译:**
所以我认为，我们经常被关于数据的各种“内心戏”所干扰。但当我们把它带回最基本的内核——“这是我的想法，这是我的感受，这是我在世界上观察到的事实”——这往往会让要求变得清晰得多。而不是像你提到的那种内心戏：“我觉得你是个混蛋。”这只是个故事，不是事实。

---

### [00:41:07] [Lenny Rachitsky]

**English:**
Yeah. I feel that is not the right way to say I feel. What do you actually feel? No. Okay, so let's move to step three. We've been going on this whole tangent of therapy and stuff, which is amazing, but let's make sure we cover all three steps. So step one again was articulate what you want. Step two is ask for what you want. What's step three?

**中文翻译:**
是的。“我觉得……”并不是表达感受的正确方式。你到底感觉到了什么？不。好的，让我们进入第三步。我们一直在聊治疗之类的话题，这很棒，但我们要确保涵盖了所有三个步骤。第一步是明确表达你想要什么，第二步是开口要你想要的。第三步是什么？

---

### [00:41:28] [Kenneth Berger]

**English:**
So to me step three is actually the trickiest for most people.

**中文翻译:**
对我来说，第三步实际上是对大多数人来说最难的一步。

---

### [00:41:32] [Lenny Rachitsky]

**English:**
So far, they're all tricky to me.

**中文翻译:**
到目前为止，对我来说每一步都很难。

---

### [00:41:34] [Kenneth Berger]

**English:**
Oh yeah, they're all tricky, for sure.

**中文翻译:**
噢是的，确实都很难。

---

### [00:41:36] [Lenny Rachitsky]

**English:**
The most tricky.

**中文翻译:**
最难的一步。

---

### [00:41:38] [Kenneth Berger]

**English:**
But step three is accept the response. And it might seem so simple, but it actually is kind of subtle. And so one reason is that idea of sort of the whole body yes or the hell yes. Because I think often we really want a yes. And so we're very, very biased to look for a yes versus accepting no, "That was a no." If someone made this face, that's a no. It doesn't matter what comes out of their mouth. And so the challenge of accepting the response is often that of hearing the no, but not over accepting or under accepting it.

**中文翻译:**
第三步是：接受回应。这听起来可能很简单，但实际上很微妙。一个原因是“全身心认同”或“hell yes”的概念。因为我们通常非常渴望得到肯定的回答。所以我们会有极强的偏见去寻找“行”，而不是接受“不”。“那就是个‘不’。”如果有人露出这种表情，那就是“不”，不管他嘴里说的是什么。所以接受回应的挑战往往在于听出那个“不”，但既不过度接受，也不接受不足。

---

### [00:42:18] [Kenneth Berger]

**English:**
Because I think sometimes what people who are really afraid to ask will do is they say, oh, well, that was a no. So it's no forever and I should never ask again. My dream is dead and nothing is ever going to happen for me again." And that's because they get so scared. But actually no, that's over accepting. The no is just from this person right now in the way that you asked, which doesn't necessarily mean anything about the next time you ask to a different person in a different way, in a different time.

**中文翻译:**
因为我认为，有时那些真正害怕提要求的人会想：“噢，好吧，那是拒绝。所以永远都是拒绝，我再也不该提了。我的梦想破灭了，我再也不会有任何机会了。”那是因为他们太害怕了。但实际上，那是过度接受。那个“不”只是此时此刻、针对你这种提问方式、来自这个人的拒绝，这并不一定意味着下次你以不同的方式、在不同的时间、向不同的人提要求时也会被拒绝。

---

### [00:42:44] [Kenneth Berger]

**English:**
And on the flip side, in that sort of more control freak mode, I think for them they'll often skip over the response say, "Well, they said no, but they don't know what they're talking about." Or they're my direct report, so they have to do what I say. So these are all fundamentally disrespectful ways to operate in this relationship. When we're talking about asking for what we want, we're talking about influence. So you need to have good relationships. You can't be influential with a bad relationship.

**中文翻译:**
另一方面，在那种掌控欲强的模式下，他们往往会跳过回应，说：“好吧，他们说了不，但他们根本不知道自己在说什么。”或者“他们是我的下属，所以他们必须按我说的做。”这些从根本上说都是在一段关系中不尊重的运作方式。当我们谈论开口要我们想要的，我们谈论的是影响力。所以你需要有良好的人际关系。如果关系糟糕，你就无法产生影响力。

---

### [00:43:13] [Kenneth Berger]

**English:**
So really accepting the response is about, yes, I'm going to be genuine about what I want, but I'm also going to genuinely care about you and have deep respect for your ability to consent or not consent to whatever the ask is. Because I think the counterintuitive thing is that often when we really respect people's no's, it can actually be more influential, more motivating. If someone says, "Okay. I'm not ready to deliver this on time." Be like, "Okay. Well, I'm going to give the project to another person."

**中文翻译:**
所以，接受回应实际上是：是的，我会真诚地表达我想要的，但我也会真诚地关心你，并深深尊重你同意或拒绝要求的权利。因为我认为反直觉的一点是，通常当我们真正尊重别人的拒绝时，它实际上会更有影响力、更有激励作用。如果有人说：“好吧，我还没准备好按时交付。”那就说：“好的。那么，我会把这个项目交给另一个人。”

---

### [00:43:46] [Kenneth Berger]

**English:**
I'm taking your no at face value. And they say, "Oh gosh, well, I didn't realize that was going to be the consequence. Maybe I can get it done by that time." And so that way you're not forcing them and you're not coercing them, right? You're just saying, "No, you said no? So that your no is no, and I accept that."

**中文翻译:**
我按字面意思接受你的拒绝。然后他们会说：“噢天哪，好吧，我没意识到会有这样的后果。也许我能在那个时间完成。”这样你就不是在强迫他们，也不是在威逼他们，对吧？你只是在说：“不，你说了不？那么你的‘不’就是‘不’，我接受这一点。”

---

### [00:44:01] [Lenny Rachitsky]

**English:**
So it feels like part of the skill here is preparing, is knowing. Some people just say no and that's okay. That's part of the experience. Part of it is if there's this not yet component... We had Mihika Kapoor on the podcast. She has a PM at Figma and she had this really great approach to building new things within companies is just like everything to her is not yet and no is a not yet. And the way you phrased it is it could just be the way you asked. It could be, maybe they'll agree if you can figure out a better way to pitch the thing. Is there anything more you can add there about just this idea of it's not no forever?

**中文翻译:**
所以感觉这项技能的一部分是做好心理准备，知道有些人就是会说“不”，而那是正常的。这只是经历的一部分。还有一部分是“尚未”（not yet）的成分。我们邀请过 Figma 的 PM Mihika Kapoor 来播客，她对于在公司内部构建新事物有一套非常棒的方法：对她来说，一切都是“尚未”，而“不”就是“尚未”。正如你所说，这可能只是因为你提问的方式不对。也许如果你能找到更好的推销方式，他们就会同意。关于“这并不是永远的拒绝”这个想法，你还有什么要补充的吗？

---

### [00:44:36] [Kenneth Berger]

**English:**
Acceptance of the response is primarily an emotional regulation issue because once we get our emotions intact, it's just, is it yes or is it no? And if it's no, which it probably is, most of the time the world tells us no, then the question is, "All right, what can I learn from this? What am I going to try next?" And so when we're able to emotionally regulate, it's all very cut and dry, right? It's like, "Okay. Here's data to tell me what to try next."

**中文翻译:**
接受回应主要是一个情绪调节的问题。因为一旦我们的情绪平复下来，问题就变成了：是“行”还是“不行”？如果是“不行”——这很可能，因为大多数时候世界都会对我们说不——那么问题就是：“好吧，我能从中学习到什么？下一步我要尝试什么？”所以当我们能够调节情绪时，一切都变得非常干脆利落，对吧？就像是：“好的，这是告诉我要尝试下一步的数据。”

---

### [00:45:02] [Kenneth Berger]

**English:**
And so really, 99% of the challenge tends to be all the feelings that come up for us when we hear no. Because We hate hearing no. It's so uncomfortable. And so part of the practice of getting good at asking for what we want is recognizing you're going to hear no all the time, and that's completely normal and fine, and it doesn't need to be something so scary or awful.

**中文翻译:**
所以实际上，99% 的挑战往往源于我们听到“不”时产生的所有情绪。因为我们讨厌听到拒绝，那太不舒服了。因此，练习“开口要你想要的”的一部分，就是意识到你会经常听到拒绝，这完全正常且没关系，它不需要是一件多么可怕或糟糕的事情。

---

### [00:45:23] [Lenny Rachitsky]

**English:**
Easier said than done in real life. Is there an example of either a client of yours... I know you can't actually share specific details, but I'm just curious if there's an example that comes up of someone dealing with this and getting better at it, or your own career.

**中文翻译:**
现实生活中说起来容易做起来难。有没有你客户的例子……我知道你不能分享具体细节，但我很好奇是否有某人应对并改善这一点的例子，或者是你自己的职业生涯。

---

### [00:45:38] [Kenneth Berger]

**English:**
I gave a talk about this sort of right after it happened, but I was fired from Slack three different times, which I feel like has to be some kind of startup record. I don't know who would be the record-keeping body for this. But now 10 years on, I have different perspective, of course. And so this was almost exactly 10 years ago, spring of 2014 and I just gotten the job as the first PM at Slack. It was already the hottest thing out there. It was only a couple dozen employees.

**中文翻译:**
我在事情发生后不久就做过一次关于这个的演讲，但我曾被 Slack 解雇过三次，我觉得这肯定创下了某种初创公司的纪录。我不知道谁会负责记录这种数据。但 10 年后的今天，我当然有了不同的视角。那是大约 10 年前，2014 年春天，我刚得到 Slack 第一位 PM 的工作。当时它已经是市面上最火的东西了，只有几十名员工。

---

### [00:46:03] [Kenneth Berger]

**English:**
I came in excited, but also a little insecure because I had just come off my breakup with my co-founder. I just wanted to put my head down and do a good job. I was engaged at the time, so Slack already knew I was going to be going away on a bachelor or backpacking trip. I have a wedding and honeymoon in the fall. And so I came in naive and overconfident of, "I've been a founder. I've worked on iconic products. I know how to do this. I'm a pro. I'm just going to go in and do the work."

**中文翻译:**
我当时既兴奋又有点不安，因为我刚和我的合伙人分道扬镳。我只想埋头苦干，把工作做好。我当时订婚了，所以 Slack 已经知道我要去参加单身派对或徒步旅行，秋天还要举行婚礼和度蜜月。所以我带着天真和过度自信进去了：“我当过创始人，我做过标志性的产品，我知道该怎么做。我是专业的。我只要进去干活就行了。”

---

### [00:46:32] [Kenneth Berger]

**English:**
So instead of getting really clear on what does success look like here or what's your culture or what are your expectations of me, I just went in and made my best guess and went for it. And lo and behold, turns out what I came in with, that supreme overconfidence was not what they wanted at all. They'd kind of been in the trenches reinventing from the game to Slack. They'd been through layoffs, really hard times together. So they wanted someone to come in humble and to earn their trust of this kind of core team that had been together for years.

**中文翻译:**
所以我没有去弄清楚这里的成功标准是什么，或者你们的文化是什么，或者你们对我的期望是什么，我只是凭直觉进去大干一场。结果你瞧，我带进去的那种极度自信根本不是他们想要的。他们一直在前线奋战，经历了从游戏到 Slack 的转型。他们一起经历过裁员和非常艰难的时期。所以他们想要的是一个谦逊的人，一个能赢得这支共事多年的核心团队信任的人。

---

### [00:47:07] [Kenneth Berger]

**English:**
I just didn't get any of that. I wasn't hearing that feedback. I wasn't hearing those nos, and I wasn't articulating what I wanted. What I wanted was really very basic. I just wanted to figure out how to do a good job, and I wanted to have a good relationship with the CEO because I was working for him. And you need to have a good relationship with your boss. But the problem was in the first firing anyway was I had not articulated those goals.

**中文翻译:**
我完全没领会到这些。我没听进那些反馈，没听进那些拒绝，我也没有明确表达我想要的。我想要的其实非常基本：我只想弄清楚如何做好工作，我想和 CEO 建立良好的关系，因为我是为他工作的。你必须和老板搞好关系。但第一次被解雇的问题在于，我根本没有明确表达过这些目标。

---

### [00:47:36] [Kenneth Berger]

**English:**
And so I shouldn't have been surprised when six weeks into my tenure at Slack, I came back from my backpacking trip with my bachelor buddies, and I had an email in my inbox saying, "Hey, you're fired. It seems like it's not working out. Let me know how you want to wrap it up." So as you can imagine, I freaked out. I loved this job, I love this company, so I profusely apologized. I said, "I'll do whatever it takes. I'm so sorry. I'm going to be committed to turn this around."

**中文翻译:**
所以，当我在 Slack 工作六周后，从单身派对徒步旅行回来，看到收件箱里有一封邮件说：“嘿，你被解雇了。看起来进展不顺。告诉我们你想怎么收尾。”我一点也不该感到惊讶。你可以想象，我吓坏了。我热爱这份工作，热爱这家公司，所以我诚恳地道歉。我说：“我会不惜一切代价。非常抱歉。我致力于扭转局面。”

---

### [00:48:07] [Kenneth Berger]

**English:**
And so early stage startup turns out firing doesn't always stick. Monday morning, I had my job back. But obviously things were not the same as they'd been before because in the second era, what I wanted was sort of better articulated more clear, but all of a sudden that fear that had been under the surface, that insecurity was now very, very present every day because I was terrified of was I going to get fired? Was I going to not make the most of this opportunity? And so I went fully into people pleaser mode. And so that meant that even though what I desperately wanted was to have this good relationship was to be successful, build a great product. I had a year of one-on-ones with the CEO.

**中文翻译:**
在早期初创公司，解雇并不总是最终定论。周一早上，我拿回了工作。但显然情况和以前不一样了，因为在第二个阶段，我想要的东西表达得更清晰了，但突然之间，那种潜伏在表面下的恐惧和不安全感每天都变得非常强烈，因为我害怕再次被解雇，害怕没能充分利用这次机会。于是我完全进入了“讨好型”模式。这意味着，尽管我拼命想要建立良好的关系、获得成功、打造伟大的产品，但在与 CEO 进行的一年 1 对 1 沟通中……

---

### [00:48:52] [Kenneth Berger]

**English:**
I never, never ever asked for what I wanted. I never said it out loud because I was scared. I was scared of what the consequences were. I knew there were a hundred PMs standing behind me ready to take my job if the CEO is ever a moment unhappy with me. I said, "No, I'm not going to take the risk. I'm too scared of what the consequences might be." And so I held all that fear and all those desires of, "I just want to do a great job. I want us to be awesome partners and build this amazing industry changing product."

**中文翻译:**
我从来、从来没有开口要过我想要的。我从来没有大声说出来，因为我害怕。我害怕后果。我知道我身后站着一百个 PM，只要 CEO 有一刻对我不满意，他们随时准备接替我的工作。我说：“不，我不想冒险。我太害怕可能的后果了。”所以我压抑了所有的恐惧和渴望：“我只想做出成绩。我想让我们成为极好的伙伴，共同打造这款改变行业的惊人产品。”

---

### [00:49:22] [Kenneth Berger]

**English:**
I never said any of that stuff out loud. I just put my head down and I tried to obey. And so as you can imagine, this didn't work very well. I was feeling horrible day to day. I was terrified of this guy I was working for. And so again, I shouldn't have been surprised, but I was, when I got fired for the second time. It wasn't quite firing. But this time I'd come back from my honeymoon and I had a phone call on Monday that said, "Seems like product management is not working out for Slack. We're actually just going to get rid of product. You're going to be user research. It's going to be fine."

**中文翻译:**
我从未大声说出那些话。我只是埋头苦干，试图服从。所以，你可以想象，这并没有奏效。我每天感觉都很糟糕，我害怕我的老板。所以，当我第二次被解雇时，我不该感到惊讶，但我还是惊讶了。那次不完全是解雇。当时我刚度蜜月回来，周一接到一个电话说：“看起来产品管理在 Slack 行不通。我们打算取消产品职能。你去做用户研究吧，会没事的。”

---

### [00:49:56] [Kenneth Berger]

**English:**
And for me, I love user research, but that was the beginning of my career. I was not interested in going back to that. What was fascinating was at that point, I was actually able to articulate what I wanted there and was willing to say it out loud. Because what I wanted was, "No, let's keep me in product. I've got an idea for how we can run it." So I wrote a proposal, I sent it around to the management team. Turns out, when you actually ask for what you want out loud, you're much more likely to get it.

**中文翻译:**
对我来说，我喜欢用户研究，但那是我的职业起点，我没兴趣回到过去。有趣的是，在那一刻，我竟然能够明确表达我想要什么，并且愿意大声说出来。因为我想要的是：“不，让我留在产品岗位。我有一个关于如何运作它的想法。”于是我写了一份提案，发给了管理层。事实证明，当你真的大声说出你想要什么时，你得到它的可能性会大大增加。

---

### [00:50:21] [Kenneth Berger]

**English:**
And so within a week, this new plan had traction with the management team team and I had my old job back again. Everything was fine except of course it wasn't fine because now I was scared, but the stakes seemed really high, and this is where that deep imposter syndrome sit in. I was like, "Am I even any good at this? Should I even be in product management? Am I ever going to work in this industry again? Is this going to be my dark secret that I take to the grave that Stewart Butterfield fired me three times?"

**中文翻译:**
于是在一周之内，这个新计划得到了管理层的认可，我又拿回了原来的工作。一切看起来都很好，但实际上并不好，因为现在我感到恐惧，而且赌注似乎非常高，这就是深度冒充者综合征发作的时候。我在想：“我真的擅长这个吗？我真的该做产品管理吗？我还能在这个行业混下去吗？Stewart Butterfield 解雇了我三次，这会不会成为我带进坟墓的阴暗秘密？”

---

### [00:50:58] [Kenneth Berger]

**English:**
I think what I couldn't be with in that moment was the no's, because I was getting no after no after no after no from Stewart and the rest of the management team saying, "What you're doing is not working for us, right? Your ask are not landing. You're not being effective in the way that you want to be effective." And because I wasn't able to hear those no's again, because to that emotional regulation standpoint, I couldn't handle the feelings of like, "Ugh, maybe what I'm doing is not good enough."

**中文翻译:**
我认为那一刻我无法面对那些“不”，因为我不断收到来自 Stewart 和管理层其他成员的“不”，他们在说：“你所做的对我们不起作用，你的要求没有达成，你没有以你想要的方式发挥效力。”因为我再次无法听进那些“不”，从情绪调节的角度来看，我无法处理那种“呃，也许我做得不够好”的感觉。

---

### [00:51:26] [Kenneth Berger]

**English:**
So instead of pointing the finger at myself, I pointed the finger at him. I said, "You know what? Actually this guy, he's not such a great manager. He's not so good at product. I'm the one who was on the ground with the users. I know what's right." Against all evidence to the contrary, by the way, is this product luminary, visionary, famous person.

**中文翻译:**
所以我没有反省自己，而是指责他。我说：“你知道吗？实际上这家伙并不是个好经理，他也不擅长产品。我才是那个深入用户一线的人，我知道什么是对的。”顺便说一句，尽管所有的证据都指向相反的方向——他可是产品界的泰斗、远见卓识的名人。

---

### [00:51:45] [Kenneth Berger]

**English:**
So clearly not based on any facts, but it was an emotional issue of I couldn't deal with the reality of what I was doing was not working. And so again, because I was not articulating what I wanted, I was not asking for it and I certainly was not listening to the no's. I shouldn't have been surprised when finally the third time it came down, and this time it was serious because we had HR.

**中文翻译:**
所以这显然不是基于任何事实，而是一个情绪问题，我无法面对我所做的没有奏效这一现实。所以，再次因为我没有明确表达我想要的，没有开口要求，也肯定没有倾听那些“不”。当最后第三次解雇降临时，我不该感到惊讶，而且这次很严重，因为我们有了 HR。

---

### [00:52:09] [Kenneth Berger]

**English:**
So it turns out once you hire HR, the firings are final. And so I only made it to a year at Slack and it was a year of just utter torture because I spent that year being fully out of integrity with myself. Never saying what I really wanted, how I really felt because it didn't feel safe. I was too scared. I kept it all inside. And it took me six months or a year even after that to really feel safe and okay again. It was a serious decompression time.

**中文翻译:**
事实证明，一旦聘请了 HR，解雇就是最终决定。我在 Slack 只待了一年，那是极其痛苦的一年，因为那一整年我都违背了内心的正直。我从未说过我真正想要的，从未表达过我真实的感受，因为我觉得不安全。我太害怕了，把一切都憋在心里。在那之后，我花了半年甚至一年的时间才重新感到安全和踏实。那是一段漫长的减压期。

---

### [00:52:39] [Kenneth Berger]

**English:**
My wife and I had a baby during that time. I was on zero sleep. It was a rough, rough period. But the irony is that when I actually came out of that experience, the reality of it was extremely simple. I hadn't articulated what I wanted. I hadn't asked for what I wanted. I had not listened to the no's in response to my non-ask.

**中文翻译:**
我和妻子在那段时间生了个孩子。我完全没觉睡。那是一段非常、非常艰难的时期。但讽刺的是，当我真正走出那段经历时，现实其实非常简单。我没有明确表达我想要的。我没有开口要求。我没有倾听对我“未曾提出的要求”的回应。

---

### [00:53:02] [Kenneth Berger]

**English:**
And so of course I was unhappy with the result. Why would I have expected anything different? I wasn't the victim. Stewart wasn't the villain. It was just ineffective asking. And so to me, especially because I was already on that path towards coaching, that lesson hit really hard in terms of how do we make this work more sustainable?

**中文翻译:**
所以我当然对结果不满意。我还能期待什么不同的结果呢？我不是受害者，Stewart 也不是恶棍。这只是无效的提要求。对我来说，特别是因为我当时已经走上了教练之路，那个教训在“如何让工作更可持续”方面给了我沉重的一击。

---

### [00:53:24] [Kenneth Berger]

**English:**
We stay in integrity with ourselves even when it's hard, even when it's scary, even when we don't know exactly what the outcome is going to be. And so that's really the story of how I became a coach, of seeing exactly how much I'd screwed up at Slack and seeing how much I had suffered and how much a lot of people suffer in these similar circumstances. All you have to do to turn it around is ask for what you want.

**中文翻译:**
即使在困难、恐惧、不知道结果会怎样的时候，也要保持内心的正直。这就是我成为教练的故事——我看到了自己在 Slack 搞砸了多少，看到了自己遭受了多少痛苦，也看到了很多人在类似的情况下遭受了多少痛苦。而扭转局面的唯一方法就是：开口要你想要的。

---

### [00:53:45] [Kenneth Berger]

**English:**
So this is why I'm so passionate about this stuff because it can sound so fluffy to say, "Oh, focus on integrity. Honor your desires. No, it's real life stuff of a year of suffering, of pain, of fear." I don't want other people to be going through that and that's why I'm so passionate about this stuff.

**中文翻译:**
这就是为什么我对这些东西充满激情，因为说“噢，关注正直，尊重你的欲望”听起来很虚。不，这是现实生活，是一整年的痛苦、折磨和恐惧。我不希望别人也经历这些，这就是我如此热衷于此的原因。

---

### [00:54:08] [Lenny Rachitsky]

**English:**
Wow, what a story. I love that it's kind of a microcosm of everything we've talked about. You've did all the things that you teach people to avoid.

**中文翻译:**
哇，真是个精彩的故事。我喜欢它，因为它就像是我们讨论过的所有内容的缩影。你做了所有你教别人要避免的事情。

---

### [00:54:18] [Kenneth Berger]

**English:**
Exactly.

**中文翻译:**
没错。

---

### [00:54:18] [Lenny Rachitsky]

**English:**
And I think what's interesting is you went through these three phases. Interestingly, at the beginning, your first phase was you were not hearing the no's, but it was rooted in this confidence that you're a founder, you're awesome. They're so lucky to have you. I know what I'm doing, get out of my way. And then the third phase, you also, the issue there was you weren't hearing the no's, but it was more from fear of being fired again. And so it's interesting that there's these different reasons you're not hearing what people are actually saying.

**中文翻译:**
我觉得有趣的是你经历了这三个阶段。有趣的是，在开始的第一阶段，你没有听进那些“不”，但那是源于一种“我是创始人，我很牛，他们能招到我是他们的运气，我知道我在做什么，别挡我的道”的自信。而在第三阶段，你同样没听进那些“不”，但更多是因为害怕再次被解雇。所以有趣的是，你听不到别人真实想法的原因是不同的。

---

### [00:54:46] [Kenneth Berger]

**English:**
Totally. Well, and to me, the first one is about articulation as well because I think that if in the beginning it articulated that, "Yeah, I'm confident, but actually I want to do a really good job and I want to have good relationships. So let me think about intentionally, how do I create those outcomes?" But because I hadn't articulated that's what I wanted, it didn't even occur to me like, "Oh yeah, I need to do some intentional relationship building, figure out some metrics for success."

**中文翻译:**
完全正确。对我来说，第一个阶段也关乎“明确表达”。因为如果一开始我就明确表达：“是的，我有信心，但实际上我想做出最好的成绩，我想建立良好的关系。那么让我有意识地思考，我该如何创造这些结果？”但因为我没有明确表达过这些是我想要的，我甚至没想过：“噢对了，我需要有意识地建立关系，弄清楚成功的衡量标准。”

---

### [00:55:11] [Kenneth Berger]

**English:**
It was an early stage startup. There wasn't a ton of sort of process or structure in place, suffice to say. And so if I wanted that, I needed to create it myself, but because I hadn't articulated that any of that was important to me, I just flew by the seat of my pants and it took failing to get some data to say, "Ooh, yeah, maybe I need to look at this more closely."

**中文翻译:**
那是一家早期初创公司，可以说并没有太多的流程或结构。所以如果我想要那些，我需要自己去创造。但因为我没有表达过这些对我来说很重要，我只是凭感觉行事，直到失败了才获得一些数据，告诉我：“噢，是的，也许我需要更仔细地审视一下。”

---

### [00:55:31] [Lenny Rachitsky]

**English:**
I imagine you've gone through this exercise many times, but say you were to do it again, what would you do differently and what do you think would've happened? Do you think you would've stayed there for many, many years, had a product at Slack at this point? Just imagining that reality, what would you have done differently? And then what would you have imagined have turned out?

**中文翻译:**
我猜你已经做过很多次这个练习了，但如果你再做一次，你会做哪些不同的事情？你认为会发生什么？你认为你会留在那里很多年，现在已经是 Slack 的产品负责人了吗？想象一下那个现实，你会做哪些不同的事情？你想象的结果会是怎样的？

---

### [00:55:49] [Kenneth Berger]

**English:**
Well, I mean obviously broadly, I would've asked for what I wanted and what I wanted was I wanted to do the best work of our life. I wanted to have a deep professional partner in the CEO and the rest of the product and management team. And I wanted to produce great work that people loved. And that was part of why I was attracted to the culture and the mission and the company. And so this is what's tricky is of course, that's what I would've done. Now, do I know what the outcome would've been?

**中文翻译:**
显然，从大方向上讲，我会开口要我想要的。而我想要的是做出我们一生中最好的作品。我想与 CEO 以及产品和管理团队的其他成员建立深厚的专业合作伙伴关系。我想做出人们喜爱的伟大作品。这也是我被这家公司的文化、使命和公司本身所吸引的部分原因。棘手的地方在于，当然，我会那么做，但我知道结果会怎样吗？

---

### [00:56:16] [Kenneth Berger]

**English:**
No, I might've been fired even sooner. They might've said, "No, this is not working out. Let's just be done here." So that's what's tricky about this is it really isn't about the outcome. Of course, asking for what you want makes you more likely to get the outcome you want, but you don't do it for guarantee of a certain outcome because no one can promise you that. You do it so you can stay in integrity with yourself and not suffer through all this. Because at least then I would've said, "You know what? It didn't work out. At least I'm not sitting here suffering. I can get another job at another startup. It's not the end of the world."

**中文翻译:**
不知道，我可能会被解雇得更早。他们可能会说：“不，这行不通，咱们就到此为止吧。”所以这就是棘手之处：这真的不是为了结果。当然，开口要你想要的会让你更有可能得到想要的结果，但你这样做并不是为了保证某个结果，因为没有人能向你保证。你这样做是为了对自己保持正直，不再遭受这些痛苦。因为至少那时我会说：“你知道吗？没成功。但至少我没有坐在这里受苦。我可以在另一家初创公司找另一份工作，这又不是世界末日。”

---

### [00:56:51] [Kenneth Berger]

**English:**
And I think that the mistake we make is pretending that it is of saying, going into fight or flight and saying, "This is a severe existential threat to who I am and my safety in the world," versus being like, "I'm disappointed. I wish it had worked out, but it didn't."

**中文翻译:**
我认为我们犯的错误是假装它是世界末日，进入“战斗或逃跑”模式，并说：“这对我的身份和我在世界上的安全构成了严重的生存威胁。”而不是说：“我很失望。我希望它能成功，但它没有。”

---

### [00:57:07] [Lenny Rachitsky]

**English:**
That's a really profound point that this practice isn't necessarily to just have everything work out beautifully and to get the things you're looking for. It's to feel like you did, which you could have and to feel integrity with yourself that you did what you needed to do and you're not going to regret something down the road.

**中文翻译:**
这是一个非常深刻的观点：这种练习并不一定是为了让一切都完美解决，得到你想要的东西。它是为了让你觉得你已经尽力了，并且对自己保持正直，这样你以后就不会后悔。

---

### [00:57:29] [Kenneth Berger]

**English:**
Indeed.

**中文翻译:**
确实如此。

---

### [00:57:31] [Lenny Rachitsky]

**English:**
I'm going to take a quick tangent down the being the first PM route real quick. There's a lot of people that think about being the first PM at a startup join as the first PM. I imagine you work with people asking for advice along these lines. It's classically a very challenging role. Many people don't last. Many people follow your trajectory where it's like, "Oh, shit. What have I done?" Any advice for people that are a first PM at a company or startup or thinking about that role?" What can you tell them to help them be successful or at least not suffer?

**中文翻译:**
我要稍微绕一下，聊聊“首位产品经理”这个话题。有很多人在考虑成为初创公司的首位 PM。我猜你会遇到向你寻求这类建议的人。这通常是一个非常具有挑战性的角色。很多人坚持不下来。很多人经历了和你一样的轨迹：“噢，该死。我做了什么？”对于那些正在担任或考虑担任公司首位 PM 的人，你有什么建议？你能告诉他们什么来帮助他们获得成功，或者至少不那么痛苦？

---

### [00:58:05] [Kenneth Berger]

**English:**
To me, it really is about the relationship with the CEO or with the founders because that's the root of a lot of the issues that come out of that scenario because it's not always you. In my story, I think it was primarily about me, but I also work with a lot of founders who are going through really tough things. My clue to people who report to a founder is to say, "Imagine if you're confused about how your founder is behaving. Imagine that they're terrified all the time, and see if that makes their behavior more clear."

**中文翻译:**
对我来说，这实际上关乎与 CEO 或创始人的关系，因为那是这种场景下产生许多问题的根源。问题并不总是在你身上。在我的故事中，我认为主要是我自己的问题，但我也与许多正在经历艰难时期的创始人合作。我对那些向创始人汇报的人的建议是：“如果你对创始人的行为感到困惑，试着想象他们一直处于恐惧之中，看看这是否能让他们的行为变得更清晰。”

---

### [00:58:38] [Kenneth Berger]

**English:**
Because it is scary to be a founder. Everything is on your shoulders. And I think a lot of people do feel that sense of high stakes all the time. And so I think being real about that of what is the state that the person or the people you're working for are in and sort of working within that versus sort of pretending that it's something else or wishing that it were something else is the path to having a healthy relationship. Because if you don't have a healthy relationship with the person you're working for, you're not going to get anything done. You're not going to succeed in any meaningful way.

**中文翻译:**
因为当创始人确实很可怕，所有的担子都在你肩上。我认为很多人确实一直感到那种“事关重大”的压力。所以，正视你为之工作的人所处的状态，并在那种状态下工作，而不是假装是别的情况或希望情况有所不同，这才是建立健康关系的途径。因为如果你与老板没有健康的关系，你将一事无成，无法取得任何有意义的成功。

---

### [00:59:10] [Lenny Rachitsky]

**English:**
I love that framework of how to think about why a founder is behaving in a certain way. Just maybe a last following thread there is just what should people look for to help them understand if the founder and them are a good fit, if they're going to have a good time working with that founder? Is there anything just like questions they might ask or ways of operating that are useful to understand like, "Okay, I think I'll be okay with this founder in this company as the first PM or not.

**中文翻译:**
我喜欢这个思考创始人为何会有某种行为的框架。最后一点后续：人们应该寻找什么来帮助他们了解创始人与自己是否契合？他们是否会和那位创始人共事愉快？有没有什么问题可以问，或者有什么运作方式可以帮助理解：“好吧，我觉得作为首位 PM，我和这位创始人在这个公司会相处得很好”？

---

### [00:59:34] [Kenneth Berger]

**English:**
I think it's a hard thing to generalize about, but to me it really is about understanding expectations. I guess this is a predictable coming from me, "But what do you really want? Because I think that often the founders put together a job description, but then they're faced with a real human being who has real human subtleties and things they're good at or not so good at." And so being very, very clear about expectations and of figuring out collaboratively a way to work together that's effective to me is there's no guarantees of course, but it gives you a more sure path to having a productive relationship.

**中文翻译:**
我认为这很难一概而论，但对我来说，这确实关乎理解预期。我猜你会预料到我会这么说：“但你到底想要什么？”因为创始人通常会写一份职位描述，但随后他们面对的是一个真实的、具有人性微妙之处、有长处也有短处的人。所以，非常清晰地明确预期，并共同寻找一种有效的合作方式，对我来说，虽然不能保证成功，但它为你建立富有成效的关系提供了一条更可靠的路径。

---

### [01:00:13] [Kenneth Berger]

**English:**
It's actually something that I recommend to a lot of founders for maybe their first 10 or 15, or 20 employees of just have a relationship design conversation with each of them when they're first hired. Because I think a lot of us come in naive the way I did, assuming, "Oh yeah, I'm just going to come in and do my thing the way I've always done it. It's going to be fine." Versus coming in and saying, "I actually don't know how I'm going to operate at this company. I have range like anyone has range, and I don't know what this company needs and who else is here and sort of what my role and what my place is going to be within these other people. And so by really understanding that intentionally and not from a place of performance management, you're already doing this poorly, you're in big trouble. But what is the best way to work together given who we have now and what we want and what we need? Let's figure it out.

**中文翻译:**
实际上，我建议很多创始人在招聘前 10、15 或 20 名员工时，在他们入职之初就与每个人进行一次“关系设计对话”。因为我认为很多人像我当初一样天真，以为：“噢是的，我只要进来按我一直以来的方式做事就行了，会没事的。”而另一种做法是进来并说：“我其实不知道我在这家公司会如何运作。我和其他人一样有自己的适应范围，我不知道这家公司需要什么，这里还有谁，以及在这些人中我的角色和位置会是什么。通过有意识地去理解这些，而不是从绩效管理的角度（比如‘你已经做得很差了，你有大麻烦了’），而是问：‘考虑到我们现在的人员、我们的目标和需求，最好的合作方式是什么？让我们一起弄清楚。’”

---

### [01:01:01] [Lenny Rachitsky]

**English:**
Coming back to our core topic, is there anything that we didn't cover, anything that I should have asked you about the skill, the art of asking for what you want? Anything else you want to leave listeners with?

**中文翻译:**
回到我们的核心话题，还有什么是我们没有涵盖的，关于“开口要你想要的”这项技能或艺术，我还有什么应该问你的吗？还有什么想留给听众的吗？

---

### [01:01:12] [Kenneth Berger]

**English:**
I do want to mention something that I hear a lot from founders when I talk about the piece of working through resistance because I think a lot of them say, "Oh, you want me to let go of fear and focus on what I want? Well, I mean, I've been running from fear my whole career. That's how I'm so hard-working and I'm so smart is I'm always afraid I'm not good enough."

**中文翻译:**
当我谈到克服阻力时，我想提一下我从创始人那里经常听到的一点。因为很多人会说：“噢，你想让我放下恐惧，专注于我想要的？但我整个职业生涯都在被恐惧驱使。这就是我如此努力、如此聪明的原因，因为我总是担心自己不够好。”

---

### [01:01:34] [Kenneth Berger]

**English:**
Am I going to be able to do this job without fear hounding me every step of the way? I just remember the first time I heard this, it broke my heart, and now I've heard it dozens of times I'd say. So I mean, it really is. I think it's a belief that sits deep in the hearts of a lot of us high achieving Silicon Valley tech types of, "My fear of not being good enough is what drives me to be great."

**中文翻译:**
“如果没有恐惧每一步都紧逼着我，我还能胜任这份工作吗？”我记得第一次听到这话时，我心都碎了，而现在我已经听过几十次了。所以，这确实是很多硅谷高成就科技人士内心深处的一种信念：“我对‘不够好’的恐惧，正是驱动我走向卓越的动力。”

---

### [01:02:00] [Kenneth Berger]

**English:**
And I just want to come out here and say there's other ways to motivate. You can motivate based on joy, based on vision, based on your inspiration in this vision of what you want. I think a lot of folks I talk to are skeptical understandably because operated a different way their whole life and all I can really say is try it. Try following an inspiring vision that's really meaningful to you and just see what it's like to not be living in fear all the time because it is a big difference and it's really meaningful. It matters a lot.

**中文翻译:**
我只想在这里说，还有其他的激励方式。你可以基于快乐、基于愿景、基于你对想要的目标的灵感来激励自己。我接触过的很多人对此持怀疑态度，这可以理解，因为他们一辈子都是以另一种方式运作的。我能说的就是：试试看。尝试追随一个对你真正有意义的、鼓舞人心的愿景，看看不再整天生活在恐惧中是什么感觉，因为这会有巨大的不同，而且非常有意义。这非常重要。

---

### [01:02:35] [Lenny Rachitsky]

**English:**
So is the fear there that if they ask for what they want, they'll get what they want and they let go of this drive to prove themselves? And is that the fear? How is it that they move away from that need to prove themselves?

**中文翻译:**
所以，那种恐惧是：如果他们开口要他们想要的，他们就会得到想要的，从而失去了证明自己的动力？那是恐惧所在吗？他们如何摆脱那种证明自己的需求？

---

### [01:02:51] [Kenneth Berger]

**English:**
Well, I mean that's a longer story. I would say managing our own fear as a sort of lifelong practice. I'm not going to claim I'm anywhere near done with it. But I guess I'd just say that I think part of the big shift I see in personal development for people I work with is from saying, "Oh, no, my fear is good. I need it. It's keeping me safe."

**中文翻译:**
那是一个很长的故事。我会说，管理我们自己的恐惧是一种终身的修行。我不会声称我已经接近完成了。但我只想说，我看到的我所合作的人在个人成长中的一个重大转变是从说“不，我的恐惧是好的，我需要它，它让我保持安全”……

---

### [01:03:16] [Kenneth Berger]

**English:**
To saying, "Fear is for when there's a tiger chasing you and there's no tiger chasing me." I'm sitting in my office in a desk chair on a zoom call. There's no real danger here. And so fear is not particularly functional. And so when they start realizing that, the practice becomes, "Oh yeah, I'm feeling afraid." But I'm reminding myself there's not a tiger in the room. If I really want to get things done, achieve my goals, I need to focus on vision on what I want to achieve in the world, not on avoiding all these fears. So that's the short of it.

**中文翻译:**
转变为说：“恐惧是当有老虎追你的时候才需要的，而现在并没有老虎在追我。”我正坐在办公室的椅子上打 Zoom 电话，这里没有真正的危险。所以恐惧并没有特别的功能。当他们开始意识到这一点时，练习就变成了：“噢是的，我感到害怕。”但我提醒自己，房间里没有老虎。如果我真的想把事情做好，实现我的目标，我需要专注于愿景，专注于我想在世界上成就什么，而不是专注于逃避所有这些恐惧。简而言之就是这样。

---

### [01:03:49] [Lenny Rachitsky]

**English:**
Amazing. It reminds me, we have a chat... I had a chat with Matt Mochari, and we spent a bunch of time on dealing with fear and overcoming fear. So folks want to dig deeper there. They could check out that episode. Just maybe one more question before we get to our very exciting lightning round. I want to take us to Contrarian Corner, classic contrarian corner. I'm curious if there's anything that you have a contrarian opinion about, something that you believe that most other people don't.

**中文翻译:**
太棒了。这让我想起我们的一次谈话……我和 Matt Mochari 聊过，我们花了很多时间讨论应对恐惧和克服恐惧。如果大家想深入了解，可以听听那一集。在进入非常精彩的闪电战环节之前，可能还有一个问题。我想带你进入“反直觉角落”（Contrarian Corner），经典的环节。我很好奇你是否有什么反直觉的观点，即你相信但大多数人不相信的事情？

---

### [01:04:16] [Kenneth Berger]

**English:**
For me, I'm not a big believer in discipline that I think some folks come to coaching looking for a drill sergeant and say, "All right. Shout at me and tell me to do better." And I start to say, "That's not how I operate." Because it's not the discipline doesn't work, but it's like people-pleasing. It's a short-term coping strategy. Discipline will get you in the gym for a week, but it's not going to get you in the gym for a year. The people who are in the gym for a year are doing it because they want to.

**中文翻译:**
对我来说，我不太相信“自律”（discipline）。我认为有些人来找教练是想找一个“教官”，说：“好吧，对我大喊大叫，告诉我做得更好。”我会开始说：“那不是我的运作方式。”因为并不是自律不起作用，而是它就像“讨好他人”一样，是一种短期的应对策略。自律能让你在健身房待一周，但不能让你待一年。那些在健身房待了一年的人，是因为他们想去。

---

### [01:04:49] [Kenneth Berger]

**English:**
There's actually something that's motivating for them in that. It's not just, "Oh, I hate this, but I'm going to go anyway." And so I try to be really clear with people about that, that I'm not going to be the drill sergeant because it's unsustainable. Someone shouting at you is not going to get you moving towards what you want in life over multiple years. It's days or weeks or even hours thing. And so I really look for a higher bar to say, "Let's look for true long-term sustainable motivation," which means relying on vision, pursuing what you want.

**中文翻译:**
那里面其实有某种东西在激励着他们。而不仅仅是“噢，我讨厌这个，但我还是要去”。所以我试着向人们明确这一点：我不会做那个教官，因为那是不可持续的。有人对你大喊大叫并不能让你在多年时间里朝着人生目标迈进。那是几天、几周甚至几小时的事。所以我追求更高的标准，即寻找真正的长期可持续动力，这意味着依靠愿景，追求你想要的。

---

### [01:05:25] [Lenny Rachitsky]

**English:**
I love that it all ties back to knowing what you want, asking for what you want, and then dealing with the answers that you get.

**中文翻译:**
我喜欢这一点，它最终都回到了：知道你想要什么，开口要你想要的，然后处理你得到的回应。

---

### [01:05:30] [Kenneth Berger]

**English:**
I am a broken record admittedly.

**中文翻译:**
我承认，我像个坏掉的唱片一样一直在重复这一点。

---

### [01:05:33] [Lenny Rachitsky]

**English:**
Amazing. Kenneth, is there anything else you wanted to share or leave listeners with before we get to our very exciting lightning round?

**中文翻译:**
太棒了。Kenneth，在进入我们非常精彩的闪电战环节之前，你还有什么想分享或留给听众的吗？

---

### [01:05:40] [Kenneth Berger]

**English:**
No, but just thank you for letting me share this stuff. It really is my life's work and I'm very passionate about it and I hope it's helpful for people. I'm going to be writing more about it on LinkedIn.

**中文翻译:**
没有了，只是感谢你让我分享这些内容。这真的是我一生的事业，我对此充满激情，希望它对人们有所帮助。我会在 LinkedIn 上写更多相关内容。

---

### [01:05:51] [Lenny Rachitsky]

**English:**
Okay, amazing. We'll point people there. With that, we've reached our very exciting lightning round. Are you ready?

**中文翻译:**
太好了。我们会引导大家去那里的。那么，我们进入了非常精彩的闪电战环节。准备好了吗？

---

### [01:05:57] [Kenneth Berger]

**English:**
I'm ready. Let's do it.

**中文翻译:**
准备好了。开始吧。

---

### [01:05:58] [Lenny Rachitsky]

**English:**
First question, what are two or three books that you've recommended most to other people?

**中文翻译:**
第一个问题：你向别人推荐最多的两三本书是什么？

---

### [01:06:03] [Kenneth Berger]

**English:**
Well, I already mentioned Radical Candor. I think that is for sure a modern classic and I think that whole idea of challenging directly, but caring personally is very much aligned with what I'm talking about, right? Because you need the relationships and you need to actually speak your truth. So I love Kim Scott's writing on that stuff.

**中文翻译:**
我已经提到了《彻底坦诚》（Radical Candor）。我认为它绝对是现代经典，那种“直接挑战但给予个人关怀”的想法与我所说的非常一致，对吧？因为你需要人际关系，你也需要说出真相。所以我喜欢 Kim Scott 关于这些内容的写作。

---

### [01:06:25] [Lenny Rachitsky]

**English:**
We had a Kim Scott on the podcast. Folks want to dig deeper there. We'll link to that episode. I'll let you keep going. Sorry for the interruption.

**中文翻译:**
我们邀请过 Kim Scott 来播客。如果大家想深入了解，我们会附上那一集的链接。让你继续，抱歉打断了。

---

### [01:06:31] [Kenneth Berger]

**English:**
Yeah. I mean I mentioned before, but I actually took Jonny Miller's Nervous System Mastery course. I just wrapped up. So you've had lots of great personal professional development thinkers on the podcast, so thank you for introducing me to them.

**中文翻译:**
是的。我之前提到过，但我实际上参加了 Jonny Miller 的“神经系统掌控”（Nervous System Mastery）课程。我刚刚结束。你在播客上邀请过很多优秀的个人和职业发展思想家，所以谢谢你把他们介绍给我。

---

### [01:06:47] [Lenny Rachitsky]

**English:**
I'm so happy to hear that. We'll link to that episode as well. I love that. What a circle of life we've got here, guests following other guests, taking their courses, joining the podcast. What a happy world.

**中文翻译:**
很高兴听到这个。我们也会附上那一集的链接。我喜欢这种“生命之环”，嘉宾关注其他嘉宾，参加他们的课程，然后加入播客。多么美好的世界。

---

### [01:06:58] [Kenneth Berger]

**English:**
Yeah, indeed.

**中文翻译:**
确实如此。

---

### [01:07:00] [Lenny Rachitsky]

**English:**
Okay. Any other books before we move on?

**中文翻译:**
在继续之前，还有其他书吗？

---

### [01:07:02] [Kenneth Berger]

**English:**
I also love the 15 Commitments of Conscious Leadership, so I'm pretty sure other guests have mentioned that as well. But to me, part of why I like that is that I think a lot of personal development books are not very directive. They say, "Oh, just dig deeply and find your truth." And while there is value to that, of course, I think sometimes it is nice to have some direction of, "Here's 15 things that generally your life's going to be better if you do them." And so to me, it's a nice balance of embracing the really deep stuff of how to live a good life and be effective in the world and be really directive. Try this stuff. It works.

**中文翻译:**
我还喜欢《意识领导力的 15 个承诺》（The 15 Commitments of Conscious Leadership），我很确定其他嘉宾也提到过。对我来说，我喜欢它的部分原因是，我认为很多个人成长书籍不够具有指导性。它们会说：“哦，只要深挖并找到你的真相。”虽然这当然有价值，但有时有一些方向性的指导是很不错的：“这里有 15 件事，如果你做了，你的生活通常会变得更好。”所以对我来说，它在探讨如何过好生活、如何在世界上发挥效力这些深刻内容与提供明确指导之间取得了很好的平衡。试试这些东西，它很管用。

---

### [01:07:38] [Lenny Rachitsky]

**English:**
Do you have a favorite recent movie or TV show you've really enjoyed?

**中文翻译:**
你最近有没有非常喜欢的电影或电视节目？

---

### [01:07:43] [Kenneth Berger]

**English:**
I'm a recent tennis fanatic, so it was one of the things I picked up during the pandemic, so I really enjoyed Netflix's Breakpoint because it's a documentary on the best tennis players in the world. I just find it so... I don't know. It is just beautiful seeing how everyone is the same because all these people, they all know all the strokes perfectly. They're technically perfect in pretty much every way. And so it really is mental.

**中文翻译:**
我最近成了网球迷，这是我在疫情期间培养的爱好之一，所以我非常喜欢 Netflix 的《破发点》（Breakpoint），因为它是一部关于世界上最好的网球选手的纪录片。我只是觉得它非常……我不知道。看到每个人都一样，这真的很美，因为所有这些人，他们都完美地掌握了所有的击球动作。他们在几乎所有方面在技术上都是完美的。所以这真的是心理博弈。

---

### [01:08:10] [Kenneth Berger]

**English:**
For those folks, it is about working through resistance as well. When they have a that says, "Oh, I'm behind. The other person is better. I'm not going to be able to do this." Are they believing that or are they working through that resistance and saying, "That's just a story I have. I actually don't know what's going to happen, but I'm going to try to win."

**中文翻译:**
对于那些人来说，这也是关于克服阻力。当他们内心有个声音说：“噢，我落后了。对方更强。我做不到这一点。”他们是相信那个声音，还是克服那个阻力并说：“那只是我内心的戏。我其实不知道会发生什么，但我会努力去赢。”

---

### [01:08:29] [Lenny Rachitsky]

**English:**
I love that you see coaching opportunities in everything even entertainment.

**中文翻译:**
我喜欢你在任何事情中都能看到教练机会，甚至是娱乐活动。

---

### [01:08:34] [Kenneth Berger]

**English:**
I mean actually speaking of that, I mean, it's almost too on the nose, but there's this movie living from a couple of years ago. This British actor is this sort of tough, old sort of stodgy government office manager, and he gets diagnosed with cancer. And he has this real transformation where he thinks about, "God, I've just been sitting in an office filing papers my whole life. What do I actually want to do with the last months of my life?" And he builds this playground for children, and that's actually his legacy. Sorry, actually, spoiler alert. Whoops, should've.

**中文翻译:**
说起这个，虽然有点太直白了，但有一部几年前的电影叫《生之欲》（Living）。这位英国演员扮演一个严厉、年迈、古板的政府办公室经理，他被诊断出患有癌症。他经历了一场真正的转变，他思考：“天哪，我这辈子就坐在办公室里整理文件。在我生命的最后几个月里，我到底想做什么？”他为孩子们建了这个游乐场，那实际上是他的遗产。抱歉，剧透了。哎呀，本不该说的。

---

### [01:09:12] [Lenny Rachitsky]

**English:**
You mentioned tennis and you mentioned British people. I will actually be at Wimbledon this year in London with my dad in July and we're going to host a meetup there while I'm there just for anyone listening right now, just to give you a heads up.

**中文翻译:**
你提到了网球，也提到了英国人。今年 7 月我将和父亲一起去伦敦看温网，我打算在那里举办一场见面会，只是给正在听节目的各位提个醒。

---

### [01:09:26] [Kenneth Berger]

**English:**
Awesome.

**中文翻译:**
太棒了。

---

### [01:09:27] [Lenny Rachitsky]

**English:**
How fun is that going to be? Okay, next question. Do you have a favorite product you've recently discovered that you really love?

**中文翻译:**
那会多有趣啊！好的，下一个问题。你最近有没有发现什么非常喜欢的、真正热爱的产品？

---

### [01:09:33] [Kenneth Berger]

**English:**
Well, it's funny. I used to be a big wine aficionado, and I think as with many of us, I am discovering I feel better with less alcohol in my life. And so one of the things I've been picking up is oolong tea. I've got a little cup of Taiwanese [foreign language 01:09:51] in front of me, and I feel like it's all the nerdery that I put into wine of regions, and varietals, and history and processing, but it's actually good for me. It's like full of antioxidants and makes me more focused and I can drink it during the day. I've been totally going down a nerdy tea rabbit hole, and I recommend it. Taiwanese mountain teas especially.

**中文翻译:**
很有趣。我以前是个葡萄酒爱好者，我想和我们中的许多人一样，我发现生活中少喝点酒感觉更好。所以我一直在接触的一件事是乌龙茶。我面前有一小杯台湾的高山茶，我觉得我把研究葡萄酒的那股钻研劲儿都用在了茶叶的产区、品种、历史和加工工艺上，但这对我有好处。它富含抗氧化剂，让我更专注，而且我可以在白天喝。我完全陷入了研究茶叶的“兔子洞”，我推荐它。特别是台湾高山茶。

---

### [01:10:16] [Lenny Rachitsky]

**English:**
I got to give me some of that. I always have tea here when I'm doing these podcasts. I'm a less sophisticated tea drinker. I just go with Earl Grey, but a really nice Earl Grey, and so I'm going to have to buy some of this. Do you have a place in a brand you recommend most?

**中文翻译:**
我也得弄点。我做播客的时候总是喝茶。我是一个不太讲究的喝茶人。我只喝格雷伯爵茶（Earl Grey），但要是那种非常好的格雷伯爵茶，所以我得买点这个。你有最推荐的品牌或购买地点吗？

---

### [01:10:30] [Kenneth Berger]

**English:**
There's lots of great stores online. You can check out teafromtaiwan.com. That's a good one.

**中文翻译:**
网上有很多很棒的商店。你可以看看 teafromtaiwan.com。那是个不错的网站。

---

### [01:10:36] [Lenny Rachitsky]

**English:**
They're going to get a bunch of traffic. They're like, "What the hell just happened?" Teafromtaiwan.com amazing. Do you have a favorite life motto that you often come back to, find useful, share with friends or family and work around life?

**中文翻译:**
他们会迎来一大波流量。他们会想：“到底发生了什么？”teafromtaiwan.com，太棒了。你有没有最喜欢的人生格言，是你经常回想起、觉得有用、会分享给亲友或在工作生活中运用的？

---

### [01:10:52] [Kenneth Berger]

**English:**
I mean, I pretty sure you can guess, Lenny.

**中文翻译:**
我想你能猜到，Lenny。

---

### [01:10:54] [Lenny Rachitsky]

**English:**
I wonder what it might be. I wonder what it might be.

**中文翻译:**
我想知道会是什么。我想知道会是什么。

---

### [01:11:00] [Kenneth Berger]

**English:**
So this is actually part of why I started writing this book, is because my friends were probably annoyed with me telling them, "Have you asked for what you wanted? Ask for what you want." Because yeah, it's best advice I have is to ask for what you want.

**中文翻译:**
这实际上也是我开始写这本书的部分原因，因为我的朋友们可能已经厌烦我告诉他们：“你开口要你想要的了吗？开口要你想要的。”因为是的，我能给出的最好的建议就是：开口要你想要的。

---

### [01:11:15] [Lenny Rachitsky]

**English:**
It all just comes back to that final question. We've been talking a lot about asking for what you want. Kenneth Berger, what do you want?

**中文翻译:**
一切又回到了那个最终的问题。我们一直在聊“开口要你想要的”。Kenneth Berger，你想要什么？

---

### [01:11:25] [Kenneth Berger]

**English:**
Ooh. All right. Well, I think for me, Lenny, you are already an industry luminary with thousands of followers. I am interested in sharing more of these ideas. So if y'all would come follow me on LinkedIn and subscribe to my newsletter, I'm going to be exploring these ideas and sharing more of this stuff because I just am so passionate about it. I'd love if you'd come and join me in that journey, bring questions and ideas, and I'd love to talk about this stuff because I just find it endlessly interesting.

**中文翻译:**
噢。好吧。我想对我来说，Lenny，你已经是拥有成千上万追随者的行业名人了。我有兴趣分享更多这些想法。所以，如果大家能去 LinkedIn 关注我并订阅我的时事通讯，我将继续探索这些想法并分享更多内容，因为我对此充满激情。我希望你们能加入我的旅程，提出问题和想法，我很乐意讨论这些，因为我觉得这非常有意思。

---

### [01:12:00] [Lenny Rachitsky]

**English:**
But you're working on a book along these lines at some point that will come out, right?

**中文翻译:**
但你正在写一本关于这方面的书，迟早会出版的，对吧？

---

### [01:12:03] [Kenneth Berger]

**English:**
That's right, that's right. I am working on it in book form, but part of what I've been doing is I realize I want to work on it in community. Speaking of asking for what you want, I mean, for me, it's not just about my vision and my framing, but I'm a coach. I'm not just about big ideas. I'm about making a difference for my clients. And so I realize, if I really want to make a difference with people, I need... It's like a product, I need to get out in the world and test out these ideas and see what lands with people and what's effective for them and what works, and hear the stories and really get into it. So that's kind of why I've been putting myself more out there.

**中文翻译:**
没错，没错。我正在以书的形式进行创作，但我意识到我想在社区中进行创作。说到“开口要你想要的”，对我来说，这不仅仅关乎我的愿景和框架，我是一名教练。我不只是关注宏大的想法。我关注的是为我的客户带来改变。所以我意识到，如果我真的想对人们产生影响，我需要……就像做产品一样，我需要走到世界中去测试这些想法，看看哪些能引起人们的共鸣，哪些对他们有效，听听他们的故事并真正投入其中。这就是为什么我更多地展示自己。

---

### [01:12:39] [Lenny Rachitsky]

**English:**
Amazing. So along those lines, two last questions. Where can folks actually find you online and follow the stuff that you're writing and how can listeners be useful to you?

**中文翻译:**
太棒了。那么，最后两个问题。大家可以在哪里在线找到你并关注你写的文章？听众可以如何帮到你？

---

### [01:12:47] [Kenneth Berger]

**English:**
So you can find me on LinkedIn. I'm Kenneth Berger, B-E-R-G-E-R. So please follow me there. Subscribe to the Ask for What You Want newsletter. And you can check out my website, kberger.com, K-B-E-R-G-E-R.

**中文翻译:**
你可以在 LinkedIn 上找到我。我是 Kenneth Berger，B-E-R-G-E-R。请在那里关注我。订阅“开口要你想要的”（Ask for What You Want）时事通讯。你也可以查看我的网站 kberger.com，K-B-E-R-G-E-R。

---

### [01:13:01] [Lenny Rachitsky]

**English:**
Kberger.com. Kenneth, you're amazing. Thank you so much for sharing so much wisdom with us. I think we've helped a lot of people. Thank you for being here.

**中文翻译:**
kberger.com。Kenneth，你太棒了。非常感谢你与我们分享这么多智慧。我想我们已经帮助了很多人。谢谢你能来。

---

### [01:13:09] [Kenneth Berger]

**English:**
Thank you.

**中文翻译:**
谢谢。

---

### [01:13:10] [Lenny Rachitsky]

**English:**
Bye, everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcast, Spotify or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcasts.com. See you in the next episode.

**中文翻译:**
再见，各位。非常感谢收听。如果你觉得这期节目有价值，可以在 Apple Podcast、Spotify 或你喜欢的播客应用上订阅本节目。此外，请考虑给我们评分或留下评论，因为这确实能帮助其他听众找到本播客。你可以在 lennyspodcasts.com 找到所有往期节目或了解更多关于本节目的信息。下期节目见。