# Kevin Aluwi - 双语对照

# Lenny's Podcast: Kevin Aluwi (Gojek Co-founder) - Bilingual Transcript
# Lenny's Podcast：对话 Gojek 联合创始人 Kevin Aluwi —— 中英双语对照文稿

---

### [00:00:00] Kevin Aluwi

**English:**
In the early days of Gojek, there was a lot of resistance to our services. The most common form of that resistance in the early days was actually by motorcycle taxi mafia. So you would have these areas that are essentially controlled through violence by specific area mafia. And when we start having drivers pick up orders and pick up passengers, these people would actually physically assault our drivers. We've had everything from bricks thrown at our drivers to knives and machetes being brandished at them, and I think it would've been easy for us to say like, "Hey, they're all contractors. They're third parties, let them kind of just sort it out." But instead, we actually hired private security. So we actually work with private security companies to help our drivers in those situations, to help kind of extract them out of these sticky situations. And so we actually ran a fairly big private security operation for a fairly long time.

**中文翻译:**
在 Gojek 成立初期，我们的服务遇到了很多阻力。早期最常见的阻力形式实际上来自“摩托车出租车黑手党”（地头蛇）。在某些地区，基本上是由特定的地方黑势力通过暴力控制的。当我们开始让司机接单和载客时，这些人实际上会对我们的司机进行人身攻击。我们经历过各种情况，从向司机扔砖头，到向他们挥舞小刀和砍刀。我想，对我们来说，当时很容易会说：“嘿，他们都是承包商，是第三方，让他们自己解决吧。”但相反，我们实际上雇佣了私人安保。我们与私人安保公司合作，在这些情况下帮助我们的司机，帮他们从这些棘手的局面中脱身。因此，在相当长的一段时间里，我们实际上运行着一个规模相当大的私人安保行动。

---

### [00:01:16] Lenny

**English:**
Welcome to Lenny's podcast, where I interview world-class product leaders and growth experts to learn from their hard won experiences building and growing today's most successful products. Today my guest is Kevin Aluwi. Kevin is the co-founder and former CEO of a company called Gojek, which I've always been fascinated by. You may recall a former guest Crystal Widjaja, who was head of growth at Gojek, and I've always wanted to get more of the story. Gojek is infamous for their scrappiness, their unique approach to ops and growth, and as being one of the first and most successful super apps in the world. They've also long been maybe the biggest startup in Indonesia and all of Southeast Asia. Kevin and the story of Gojek have a lot to teach founders in the US and all over the world, and so I was really excited to sit down with Kevin to dig into the story, he did not disappoint.

**中文翻译:**
欢迎来到 Lenny 的播客。在这里，我会采访世界级的产品领导者和增长专家，学习他们在构建和发展当今最成功产品过程中辛勤换来的经验。今天的嘉宾是 Kevin Aluwi。Kevin 是 Gojek 公司的联合创始人兼前 CEO，我一直对这家公司非常着迷。你可能还记得之前的嘉宾 Crystal Widjaja，她曾是 Gojek 的增长负责人，我一直想了解更多关于这家公司的故事。Gojek 以其极强的拼劲（scrappiness）、独特的运营和增长方式，以及作为世界上最早且最成功的“超级应用”（super apps）之一而闻名。长期以来，它也可能是印度尼西亚乃至整个东南亚最大的初创公司。Kevin 和 Gojek 的故事对美国及全世界的创始人都有很多启发，所以我非常兴奋能和 Kevin 坐下来深入探讨这个故事，他果然没有让我失望。

---

### [00:02:04] Lenny

**English:**
You'll hear all kinds of wild stories about them having to hire a private security team to protect their drivers, having to build their own cash distribution centers to pay their drivers, plus how they won in large part thanks to their early investment in brand, why it's important to do the hard things as a startup. Also, why super apps are surprisingly overrated and much more. Enjoy this episode with Kevin Aluwi after a short word from our sponsors.

**中文翻译:**
你会听到各种疯狂的故事，比如他们不得不雇佣私人安保团队来保护司机，不得不建立自己的现金分发中心来给司机发工资，此外还有他们如何在很大程度上凭借早期的品牌投入赢得市场，以及为什么作为一家初创公司，做“难事”至关重要。此外，还有为什么超级应用在某种程度上被高估了，以及更多精彩内容。在听完赞助商的简短介绍后，请欣赏本期与 Kevin Aluwi 的对话。

---

### [00:02:29] Lenny

**English:**
This episode is brought to you by Coda. You've heard me talk about how Coda is the doc that brings it all together, and how can I help your team run smoother and be more efficient? I know this firsthand because Coda does that for me. I use Coda every day to wrangle my newsletter content calendar, my interview notes for podcasts, and to coordinate my sponsors. More recently, I actually wrote a whole post on how Coda's product team operates, and within that post, they shared a dozen templates that they use internally to run their product team, including managing the roadmap, their OKR process, getting internal feedback, and essentially their whole product development process is done within Coda.

**中文翻译:**
本期节目由 Coda 赞助。你听我谈论过 Coda 是如何将一切整合在一起的文档，以及它如何帮助你的团队运行得更顺畅、更高效。我有切身体会，因为 Coda 就在为我做这些。我每天都使用 Coda 来整理我的时事通讯内容日历、播客采访笔记以及协调赞助商。最近，我实际上写了一篇关于 Coda 产品团队如何运作的长文，在那篇文章中，他们分享了十几个内部用于运行产品团队的模板，包括路线图管理、OKR 流程、获取内部反馈，基本上他们的整个产品开发流程都是在 Coda 中完成的。

---

### [00:03:07] Lenny

**English:**
If your team's work is spread out across different documents and spreadsheets and a stack of workflow tools, that's why you need Coda. Coda puts data in one centralized location regardless of format, eliminating roadblocks that can slow your team down. Coda allows your team to operate on the same information and collaborate in one place. Take advantage of this special limited time offer just for startups. Sign up today at coda.io/lenny and get a thousand dollars startup credit on your first statement. That's coda.io/lenny to sign up and get a startup credit of $1,000. Coda.io/lenny.

**中文翻译:**
如果你的团队工作分散在不同的文档、电子表格和一堆工作流工具中，这就是你需要 Coda 的原因。Coda 将数据放在一个集中的位置，无论格式如何，消除了可能拖慢团队进度的障碍。Coda 允许你的团队在相同的信息上运作并在一个地方协作。请利用这个专门针对初创公司的限时特别优惠。今天就在 coda.io/lenny 注册，即可在你的第一张账单上获得 1000 美元的初创公司抵扣额度。访问 coda.io/lenny 注册并获得 1000 美元的初创抵扣额度。coda.io/lenny。

---

### [00:03:45] Lenny

**English:**
This episode is brought to you by rows.com, the world runs on spreadsheets. You probably have a tab open with a spreadsheet right now, but the spreadsheet product you're using today was designed decades ago, and it shows. They live in silos away from your business data. They weren't made to be used on a phone. And if you want to do even the simplest automation, you have to figure out complex scripts that are nightmare to maintain. Rows is different. It combines a modern spreadsheet editor, data integrations with APIs and your business tools and a slick sharing experience that turns any spreadsheet into a beautiful interactive website that you'll be proud to share.

**中文翻译:**
本期节目由 rows.com 赞助。世界运行在电子表格之上。你现在可能就打开了一个电子表格标签页，但你今天使用的电子表格产品是几十年前设计的，这一点显而易见。它们存在于远离业务数据的孤岛中。它们不是为了在手机上使用而设计的。如果你想做哪怕最简单的自动化，你也必须弄清楚复杂的脚本，而这些脚本的维护简直是噩梦。Rows 则不同。它结合了现代电子表格编辑器、与 API 及业务工具的数据集成，以及流畅的共享体验，可以将任何电子表格变成一个精美的交互式网站，让你自豪地分享。

---

### [00:04:20] Lenny

**English:**
If you're writing a report on a growth experiment, you can use Rows to do your analysis on data straight from BigQuery or Snowflake. If you're deep diving on marketing, you can import reports straight from Google Analytics, Facebook ads, or Twitter. Or if you're working with sales, you can natively plug Stripe, Salesforce or HubSpot directly into Rows. And when you're done, you can share your work as a beautiful spreadsheet that's easy to read and embed charts, tables and calculators into Notion, Confluence or anywhere on the web. I've already moved some of my favorite spreadsheet templates to Rose. Go to rows.com/lenny to check them out. That's rows.com/lenny.

**中文翻译:**
如果你正在撰写关于增长实验的报告，你可以使用 Rows 直接对来自 BigQuery 或 Snowflake 的数据进行分析。如果你正在深入研究营销，你可以直接从 Google Analytics、Facebook 广告或 Twitter 导入报告。或者，如果你从事销售工作，你可以将 Stripe、Salesforce 或 HubSpot 直接原生接入 Rows。完成后，你可以将你的工作分享为一个易于阅读的精美电子表格，并将图表、表格和计算器嵌入到 Notion、Confluence 或网络上的任何地方。我已经把我最喜欢的一些电子表格模板移到了 Rows。访问 rows.com/lenny 查看它们。就是 rows.com/lenny。

---

### [00:05:01] Lenny

**English:**
Kevin, welcome to the podcast.

**中文翻译:**
Kevin，欢迎来到播客。

---

### [00:05:03] Kevin Aluwi

**English:**
Thank you. Thanks for having me, Lenny. We've finally made it happen after a few weeks or months of going back and forth.

**中文翻译:**
谢谢。谢谢你邀请我，Lenny。在经过几周甚至几个月的来回沟通后，我们终于实现了这次对话。

---

### [00:05:10] Lenny

**English:**
Yeah, I'm really excited to finally meet you and to dig into a bunch of stuff. I think this is going to be a really unique episode. I don't often have founders on the podcast, especially founders of companies that are not based in the US. In this case, Indonesia, Crystal Widjaja, who is on this podcast previously. One of my favorite guests is just like "Lenny, you got to get Kevin on your podcast." And so here we are.

**中文翻译:**
是的，我非常兴奋终于能见到你并探讨很多事情。我认为这将是非常独特的一集。我不经常邀请创始人上播客，尤其是那些总部不在美国的公司的创始人。这次是印度尼西亚。之前上过这个播客的 Crystal Widjaja（我最喜欢的嘉宾之一）曾对我说：“Lenny，你一定要请 Kevin 上你的播客。”所以，我们今天聚在这里。

---

### [00:05:38] Kevin Aluwi

**English:**
I'm glad to be in a small group of category of people that you invite. Thank you. I'm a huge fan of what you do.

**中文翻译:**
我很荣幸能成为你邀请的少数人群类别中的一员。谢谢。我是你工作的超级粉丝。

---

### [00:05:38] Lenny

**English:**
Thanks, man, I really appreciate that. And just redirect to you, you are the co-founder of a company called Gojek. Many people listening have never heard of Gojek, especially people in the US. So just to start, can you just describe what is Gojek, what do y'all do? And then also I think more interestingly is just the scale of I think people in the US, their mind will blow once they hear the scale you've reached with this company. They probably hadn't heard of it.

**中文翻译:**
谢谢，伙计，我非常感激。现在把话题转回到你身上，你是 Gojek 公司的联合创始人。很多听众可能从未听说过 Gojek，尤其是美国人。所以首先，你能描述一下 Gojek 是什么，你们是做什么的吗？而且我认为更有趣的是它的规模——我想美国人一旦听到这家公司的规模，一定会大吃一惊，尽管他们可能从未听说过它。

---

### [00:06:03] Kevin Aluwi

**English:**
So Gojek started as a motorcycle taxi based service. So it's a kind of uniquely Indonesian things where we have millions of motorcycle taxi drivers in all of the urban centers in Indonesia. And so we started with a very local problem and the first product was a on-demand super app, if you will, where you could ask someone on a motorcycle to give you a ride, send a package for you or buy something and deliver it to you. This then evolved over the years into a more general on demand consumer super app that also included car drivers and other services ranging from the ones mentioned to grocery deliveries and payments and financial services.
(00:06:52):
And today we took the company public about a year and a half ago after we merged with Indonesia's top e-commerce platform. And we've managed to also expand outside of just Indonesia, where today we have about 2.7 million drivers across Southeast Asia. We've completed about 3 billion orders last year, so that's 3 billion orders. So the scale of our region is often under underappreciated, where we also have about 15 million merchants doing general e-commerce, but also restaurants on our food delivery service. And on that IPO, we're pretty proud to say that it was Indonesia's largest IPO of all time, where we raised over a billion dollars at something like 27, 28 billion dollars in terms of valuation.

**中文翻译:**
Gojek 最初是以摩托车出租车（ojek）为基础的服务。这是一种印度尼西亚特有的现象，我们在印尼所有的城市中心都有数百万名摩托车出租车司机。所以我们从一个非常本土的问题开始，第一个产品是一个“按需超级应用”（on-demand super app），如果你愿意这么称呼的话。你可以让骑摩托车的人载你一程，帮你寄包裹，或者帮你买东西并送货上门。多年来，这演变成了一个更通用的按需消费者超级应用，还包括了汽车司机和其他服务，范围从刚才提到的那些到杂货配送、支付和金融服务。
(00:06:52):
今天，我们在大约一年半前与印尼顶尖的电子商务平台（Tokopedia）合并后上市了。我们也成功扩展到了印尼以外的地区，目前在整个东南亚拥有约 270 万名司机。去年我们完成了约 30 亿个订单，是的，30 亿个。我们这个地区的规模经常被低估，我们还有大约 1500 万个商家在进行普通电商业务，以及我们外卖服务上的餐厅。关于那次 IPO，我们非常自豪地说，那是印尼历史上规模最大的 IPO，我们筹集了超过 10 亿美元，估值大约在 270 亿到 280 亿美元之间。

---

### [00:07:50] Lenny

**English:**
And these numbers you shared 2.7 million drivers, 30 billion orders,

**中文翻译:**
你分享的这些数字，270 万名司机，300 亿个订单……

---

### [00:07:55] Kevin Aluwi

**English:**
3 billion.

**中文翻译:**
是 30 亿。

---

### [00:07:57] Lenny

**English:**
3 billion. How would that compare to an Uber or Lyft?

**中文翻译:**
30 亿。这与 Uber 或 Lyft 相比如何？

---

### [00:07:58] Kevin Aluwi

**English:**
I don't know what their latest numbers are, but just in terms of the numbers of people and the number of activity, I would place our scale among the largest US companies.

**中文翻译:**
我不知道他们的最新数据是多少，但仅就人员数量和活动量而言，我会将我们的规模列入美国最大公司的行列。

---

### [00:08:10] Lenny

**English:**
That's pretty wild that there's this company out there that a lot of people didn't know about that is basically of the scale of Uber and Lyft.

**中文翻译:**
这太疯狂了，居然有这样一家很多人都不知道的公司，其规模基本上与 Uber 和 Lyft 相当。

---

### [00:08:17] Kevin Aluwi

**English:**
In terms of volume, I would say that we're up there with Uber globally and definitely larger than Lyft. I don't remember how many drivers are in the US, but we definitely have more drivers in the region than all of America.

**中文翻译:**
就业务量而言，我认为我们在全球范围内可以与 Uber 媲美，而且肯定比 Lyft 大。我不记得美国有多少司机，但我们在这个地区的司机数量肯定比全美国都多。

---

### [00:08:35] Lenny

**English:**
Just to kind of check this check box, you said it was a super app. What are all the things that Gojek does? Just whatever you want to share, all the things that you can do.

**中文翻译:**
为了确认一下，你提到它是一个超级应用。Gojek 到底都做些什么？只要你想分享的，所有能做的事情都可以说。

---

### [00:08:43] Kevin Aluwi

**English:**
From the point when we had the most services, we had everything from ride hailing to package delivery to food delivery, to grocery deliveries. We had moving services on trucks and vans. We had on demand massages, cleaning services. You could get your hair done on Gojek, you could order movie tickets, you could get a loan, you could pay for things. I think at our peak we had something like near 30 different services all in one app.

**中文翻译:**
在我们服务最全的时候，我们拥有从网约车、包裹递送、外卖到杂货配送的一切服务。我们还有卡车和面包车的搬家服务。我们提供按需按摩、清洁服务。你可以在 Gojek 上预约理发，订电影票，申请贷款，支付各种费用。我想在巅峰时期，我们在一个应用中集成了近 30 种不同的服务。

---

### [00:09:18] Lenny

**English:**
I think it's like you're officially a super app if your founder can't even remember all the things that you do right now.

**中文翻译:**
我想，如果创始人自己都记不全现在做的所有事情，那你们就是名副其实的超级应用了。

---

### [00:09:25] Kevin Aluwi

**English:**
Yeah, definitely. I would challenge anyone within the company to be able to name all of our services that we've ever had on the app because it was pretty wild at one point. And I'd love to talk a little bit about my thoughts on super apps at some point during the session because I definitely have some mixed views over it as a product strategy as we've gone through that whole cycle.

**中文翻译:**
是的，绝对是。我会向公司里的任何人发起挑战，看谁能说出我们在应用上提供过的所有服务，因为在某个阶段那确实非常疯狂。我很想在这次对话中谈谈我对超级应用的看法，因为在经历了整个周期后，作为一种产品策略，我对它的看法确实比较复杂。

---

### [00:09:54] Lenny

**English:**
It might be actually a good time just to jump into it. I know that I was actually saving that for later, but this might be a good time. And part of the reason I think this is really interesting is if you open up Uber these days, it's like 40 things that they're offering now. Elon at Twitter is talking about turning Twitter into a super app like payments, communication, messaging, all these things. So I think it's a really interesting trend that continues to pop up here in the US and I would absolutely love to hear your perspective on super apps.

**中文翻译:**
现在可能正是切入这个话题的好时机。我本来打算稍后再谈，但现在看来很合适。我认为这很有趣的部分原因是，如果你现在打开 Uber，他们提供了大约 40 种功能。埃隆·马斯克也在谈论将 Twitter 变成一个包含支付、通信、消息等功能的超级应用。所以我认为这是一个在美国不断涌现的有趣趋势，我非常想听听你对超级应用的看法。

---

### [00:10:19] Kevin Aluwi

**English:**
Okay, I'm going to come off a little strong on this, but I am kind of annoyed at how much it's being mentioned these days. It's really popular in VC-consultant-analyst circles because it sounds really great on a strategy deck because all of the things that are really appealing, we'll talk about lower customer acquisition costs, higher attach rates to different products, talk about higher retention across different services, the ease of cross-selling and upselling. All of these things sound great, but in reality, a lot of those benefits don't pan out. And one probably really good example that I like to reference is that I remember one of our products was mobile phone top up and recharge. In Southeast Asia, a majority of people are on prepaid plans instead of postpaid plans. So everyone basically buys their minutes and their data plans upfront in the beginning of the week or the beginning of the month.
(00:11:27):
So we had a product which was a mobile top-up product. And so the reason I mentioned this specific product as a really illustrative point on super apps is that it's a product that 95% plus of our customers need because they're all on prepaid plans. So it's a very relevant product. And we had our UX research research team actually look into why the engagement in the product wasn't as high as we thought it should be. So one of the questions that our URX team asked our customers was like, "Hey, do you know that you could top up your mobile minutes and by data on the Gojek app?" And only about 40% of our customers, like 30 or 40% of our customers knew that this product existed. And that completely blew our minds because one, it's a product that is relevant for all of our customers.
(00:12:25):
Two, it was literally there on one of the six buttons on the homepage. And I think the insight that we got here was that there kind of needs to be a unifying concept across all of your services within the app for your users to be able to think about your product in a sensible way. And for us, the way that our customers thought about us was that they thought about the driver. And so when we went from ride hailing to package delivery to food delivery, to grocery delivery, customers really understood that. And we didn't have to sell this idea to our customers that you had all of these services under one app because they thought about the Gojek driver. That made sense. You can easily cross sell somebody from a ride hailing customer to a grocery customer or a food delivery customer because they understood the unifying factor there being the driver.
(00:13:24):
But then when you start doing other things that don't have that unifying factor in terms of the concept that a customer has when they think about your service, it starts breaking down. So one other fun UXR insight here was when we launched massage services. So we had at one point though we've shut it down a few years after, we had massage services where you can order a masseuse to come to your place. And a question that many of our customers asked was that, "oh, is the driver going to come into my house and give me a massage?" And for us, that was insane. Of course not, our drivers are not trained masseuses, but that was the question that people asked because they thought like, "oh, this app is an app for these driver related services, so if there was a massage service, I'm assuming it's that same man who's going to give me a massage."
(00:14:17):
And so I think this kind of illustrates the importance of having these unifying concepts that are easy for customers to think about the multiple different services. It's not as simple as just saying, oh, we have a lot of engagement, we have a lot of eyeballs at a service. And then you have a super app that makes sense for customers. And so that whole nirvana of lower CAC, higher retention that are all on these great strategy decks often don't pan out because you kind of have to then resell this idea of like, oh, this is another service and that you can use. And that's a bit of investment that you have to actually put in terms of advertising and customer education that increases those customer acquisition costs.
(00:15:03):
And it also leads to design constraints because there's only so many ways you can display a whole bunch of different services that actually have little to do with each other, which is why when you see super apps today, it's kind of like this giant menu or this giant grid which does limit the design decisions that you can make, which is unfortunate because if you actually, I think it's an unsolved problem at this point.

**中文翻译:**
好，我接下来的话可能有点重，但我确实对最近这个词被频繁提及感到有些厌烦。它在风投、顾问和分析师圈子里非常流行，因为在战略 PPT 上听起来很棒——我们会谈论更低的获客成本（CAC）、不同产品之间更高的附加率（attach rates）、跨服务的更高留存率，以及交叉销售和向上销售的便利性。所有这些听起来都很完美，但在现实中，很多好处并没有实现。我喜欢引用一个非常好的例子：我记得我们的一个产品是手机话费充值。在东南亚，大多数人使用的是预付费套餐，而不是后付费套餐。所以基本上每个人都会在周初或月初预先购买通话时长和流量包。
(00:11:27):
所以我们有一个手机充值产品。我提到这个特定产品作为超级应用的一个典型例证，是因为 95% 以上的客户都需要它，因为他们都在用预付费套餐。所以这是一个相关性极高的产品。我们的用户体验研究（UXR）团队调查了为什么该产品的参与度没有我们预想的那么高。其中一个问题是：“嘿，你知道你可以在 Gojek 应用上充值话费和购买流量吗？”结果只有大约 30% 到 40% 的客户知道这个产品的存在。这让我们大吃一惊，因为第一，这是一个对所有客户都相关的产品。
(00:12:25):
第二，它就在首页的六个按钮之一。我认为我们得到的启示是：在应用内的所有服务之间，需要有一个“统一的概念”，这样用户才能以一种合乎逻辑的方式思考你的产品。对我们来说，客户对我们的认知是围绕着“司机”展开的。所以当我们从网约车扩展到包裹递送、外卖和杂货配送时，客户非常理解。我们不需要向客户推销“一个应用包含所有服务”的概念，因为他们想到了 Gojek 司机。这很合理。你可以很容易地将网约车客户转化为杂货或外卖客户，因为他们理解其中的统一因素就是司机。
(00:13:24):
但当你开始做其他没有这种统一因素的事情时，客户对你服务的认知就开始瓦解了。另一个有趣的 UXR 洞察是关于我们推出按摩服务的时候。我们曾一度推出过按摩服务（几年后关闭了），你可以预约按摩师上门。很多客户问的一个问题是：“哦，是那个（骑摩托车的）司机进我家给我按摩吗？”对我们来说，这简直不可思议。当然不是，我们的司机没有受过按摩培训。但人们就是会这么问，因为他们认为：“哦，这个应用是提供与司机相关的服务的，所以如果有按摩服务，我假设就是那个男人来给我按摩。”
(00:14:17):
我认为这说明了拥有易于客户理解的“统一概念”来串联多种服务的重要性。这不仅仅是说“我们有很多参与度，有很多流量”，然后你就拥有了一个对客户有意义的超级应用。那些精美战略 PPT 上描述的低 CAC、高留存的“涅槃境界”往往无法实现，因为你必须重新向用户推销“哦，这是另一个你可以使用的服务”。这需要在广告和客户教育方面投入大量资金，从而增加了获客成本。
(00:15:03):
它还会导致设计上的约束，因为展示一堆互不相关的服务的方式有限，这就是为什么你今天看到的超级应用往往像一个巨大的菜单或网格，这限制了你可以做出的设计决策。这很遗憾，因为我认为到目前为止，这仍然是一个未解决的问题。

---

### [00:15:28] Lenny

**English:**
It's hilarious story about the massage product. Sounds like a lot of startups are going to have some issues scaling to new products and trying to become a super app. I want to shift a little bit and talk about brand. I did a little research on you ahead of this chat. I watched your Marshall graduation and speech and a few other interviews you did, and something that came out of your previous writing and talks is just how much you care about brand and how much value you put into brand. And that you just have a lot of opinions about the importance of brand. And to me and to most people, brand is this really squishy thing and it's hard to know what exactly to do to build your brand, when to prioritize it, how to prioritize it amongst other things you're doing, especially early on. So I'd love to hear your advice for founders that are listening and just like, what should I actually do around brand? What's your advice for how to tactically do something about brand and also just why do you think it's so important?

**中文翻译:**
关于按摩产品的故事太好笑了。听起来很多初创公司在扩展新产品和尝试成为超级应用时都会遇到问题。我想转换一下话题，谈谈品牌。在这次聊天之前，我对你做了一些研究。我看了你在马歇尔商学院的毕业演讲和其他几次采访，从你之前的文章和谈话中可以看出，你非常看重品牌，并赋予了品牌极高的价值。你对品牌的重要性有很多见解。对我以及大多数人来说，品牌是一个非常模糊（squishy）的东西，很难知道具体该做些什么来建立品牌，什么时候该优先考虑它，以及在处理其他事务时如何平衡它，尤其是在早期阶段。所以我很想听听你给正在收听的创始人们的建议：关于品牌，我到底该做些什么？你对如何从战术上打造品牌有什么建议？以及你为什么认为它如此重要？

---

### [00:16:23] Kevin Aluwi

**English:**
I do agree with you that it is kind of this squishy thing that most people see as an afterthought, may be because it is kind of this squishy thing that it's hard to define, but I'm a very big believer that the two most important things in a consumer business are product and brand in that order. And I don't think I need to sell the idea, especially to your audience. That product is absolutely critical and probably the most important. But brand as an afterthought is definitely one of the areas where I think there's a giant missed opportunity for consumer tech businesses. And I get why we opened the session by talking about the size of the business to get an appreciation of the scale for audience members who might be unfamiliar with us or with the region.
(00:17:16):
But I wish I did have to start there because we actually started as a very scrappy company where we were by far the underfunded player and without brand. We probably would've never gotten to escape velocity beyond that scrappy stage, we've maintained our leadership in Indonesia through a lot of the things that we actually did on the brand side to give you a sense of how scrappy we had to be in competition.
(00:17:52):
For the first six months after launching our app, we had only raised about $2 million and our regional competitor had already raised 250. So they had literally more than a hundred times more capital than we have. So it's easy to talk about what we built as this kind of giant business, but we came from a place where we were seriously underfunded. And I think a big reason why we survived was that we built a great brand for our consumers and for our drivers and for our merchants. And I think that great brands create associations in their customer's minds that transcend the typically transactional or utilitarian one that most people have with businesses and they become part of one's identity.
(00:18:42):
I think some of the best-in-class examples of these are probably all the Apple fanboys and fangirls, Nike sneakerheads, for these individuals, the brand becomes a really big part of their identity and their loyalty towards the products of the company go beyond a relationship that can easily be swayed just through discounts or other more features that other competitors might have. And so I'm a really firm believer of how important this is because you can see it if you step out of the tech bubble for a second, you can see that there's so many great companies out there that really rely on the strength of their brand to build these fantastic businesses and to create great experiences for their customers. And you ask, what are the things that one can do?
(00:19:45):
I think for us, we invested a lot in our brand across multiple areas. And I think one specific area that I think is really important is that you create consistency across all customer touchpoints. And so branding is not just cool logo, cool advertising, fun imagery, but it's really about the impression that a customer or user has with your product and with your business. So having that consistency across all customer touchpoints is really important. So how you write copy and advertising and in the app, how you've even designed the app, but we were the first company of scale to have ads that don't take ourselves too seriously. We make fun of ourselves, we make fun of our cultural observations of Indonesia. And again, to just build this overall field that like, Hey, we get, we are part of the overall culture of Indonesia. And I think even going beyond the more aesthetic or communication oriented investments, we also leaned into cultural artifacts in our product features to really build this brand that is part of day-to-day culture.
(00:21:09):
One of my favorite cultural artifacts is that in Asia it's fairly common to send food as gifts to your loved ones or maybe people you're interested in dating. So people would send over food as gifts to their romantic interests. And so when we launched our food delivery service, a lot of people were actually using it for this, I'm going to send it to my boyfriend or my girlfriend or the person that I'm interested in dating. And so it became this whole cultural phenomenon of sending go-food for these people and we kind of lean into it in our product feature where all of the other players in the market at the time basically only allowed you to deliver food to your home or your office, but we actually created a feature that allowed you to choose a delivery point that was far away from where you were.
(00:22:04):
There was a lot of reasons why other companies didn't allow it at the time because it's like, oh, it might be used for fraud and stuff like that. But we leaned into it, we leaned into it and actually created features that allowed to put your pickup point far away from where your actual location was. And then we just had fun with this whole idea of go-food dating. And so yes, it's kind of part of branding, but thinking about branding beyond just marketing communication but actually be as being relatable and being part of the culture and being sensitive of what that culture is, I think was something that we did really well in the early days that allowed us to continue maintaining leadership in spite of the fact that our competitors had more money, which meant that they could offer more discounts, they could offer more incentives to drivers, but we really kind of lean very hard into being not just a utilitarian commodity, which is what a lot of people would say is the nature of our business to some level of accuracy.

**中文翻译:**
我同意你的看法，品牌确实是一个模糊的东西，大多数人把它当作事后才考虑的事情，也许正是因为它难以定义。但我坚信，在消费业务中，最重要的两件事是产品和品牌，排名分先后。我不认为我需要推销这个观点，尤其是对你的听众。产品绝对是至关重要的，可能是最重要的。但把品牌当作事后才考虑的事，绝对是消费科技企业错失巨大机会的领域之一。我明白为什么我们开场要谈论业务规模，是为了让不熟悉我们或该地区的听众对规模有个概念。
(00:17:16):
但我希望我不需要从规模开始讲起，因为我们最初是一家非常“草根”的公司，资金严重匮乏。如果没有品牌，我们可能永远无法跨越那个草根阶段达到“逃逸速度”。我们在印尼保持领先地位，很大程度上归功于我们在品牌方面所做的工作。为了让你感受一下我们在竞争中有多么艰难：
(00:17:52):
在我们的应用发布后的前六个月，我们只筹集了大约 200 万美元，而我们的地区竞争对手已经筹集了 2.5 亿。所以他们的资金实际上是我们的 100 多倍。所以现在谈论我们建立的这个庞大业务很容易，但我们是从一个资金严重不足的境地起步的。我认为我们生存下来的一个重要原因是，我们为消费者、司机和商家建立了一个伟大的品牌。我认为伟大的品牌会在客户心中建立一种联想，这种联想超越了大多数人与企业之间典型的交易或功利关系，品牌成为了个人身份的一部分。
(00:18:42):
我认为这类例子中最好的包括苹果的粉丝、耐克的球鞋收藏者。对于这些人来说，品牌成为了他们身份的重要组成部分，他们对公司产品的忠诚度超越了那种容易被折扣或其他竞争对手的功能所动摇的关系。我坚信这一点的重要性，因为如果你暂时跳出科技圈，你会发现有很多伟大的公司依靠品牌实力建立了出色的业务，并为客户创造了极佳的体验。你问，一个人能做些什么？
(00:19:45):
对我们来说，我们在多个领域对品牌进行了大量投入。我认为一个特别重要的领域是：在所有客户触点上创造一致性。品牌塑造不仅仅是酷炫的 Logo、酷炫的广告或有趣的图像，它实际上是客户或用户对你的产品和业务留下的印象。因此，在所有触点上保持一致性非常重要。包括你如何撰写文案、广告和应用内的文字，甚至你如何设计应用。我们是第一家拥有“不把自己太当回事”的广告的大型公司。我们自嘲，我们调侃对印尼文化的观察。再次强调，这只是为了建立一种整体感觉：嘿，我们懂你，我们是印尼整体文化的一部分。我认为除了审美或沟通导向的投入外，我们还在产品功能中融入了“文化产物”（cultural artifacts），以真正建立一个融入日常生活的品牌。
(00:21:09):
我最喜欢的文化产物之一是：在亚洲，把食物作为礼物送给亲人或约会对象是很常见的。人们会把食物送给他们感兴趣的人。所以当我们推出外卖服务时，很多人实际上就是这么用的——“我要送给我的男朋友、女朋友或我想追求的人”。这成了送 Go-Food 的一种文化现象。我们在产品功能中顺应了这一点。当时市场上的其他玩家基本上只允许你把食物送到家里或办公室，但我们创造了一个功能，允许你选择一个远离你当前位置的配送点。
(00:22:04):
当时其他公司不允许这样做有很多原因，比如“哦，这可能会被用于诈骗”之类的。但我们坚持做了，创造了允许设置远程取货点的功能。然后我们围绕“Go-Food 约会”这个点玩得很开心。所以，是的，这属于品牌塑造的一部分，但要超越营销沟通去思考品牌，要让品牌变得可亲近、成为文化的一部分，并对这种文化保持敏感。我认为这是我们在早期做得非常好的一点，这让我们在竞争对手更有钱（意味着他们可以提供更多折扣、给司机更多激励）的情况下，依然能保持领先地位。我们努力让自己不只是一个功利性的商品，尽管很多人会说我们的业务本质上就是商品。

---

### [00:23:08] Lenny

**English:**
So just to get even more concrete, one takeaway from what you just shared, which is interesting, is the first part of figuring out how to approach your brand is what's the personality of your product for you? You said it was like we're just of the people, we're like you, we're here to help you, make your life easier. And then that informs the copy, the messaging, be a little, I forget how you describe it, but just almost bad grammar and stuff just because it relates more to people and then some of these product launches that connect to that. So maybe if there's anything else you want to add there that'd be interesting. And then what's like, I don't know, one or two moments that most helped build the brand. I know you're kind of famous for having helmets and jackets on the drivers that help spread the Gojek brand. Is there anything else that just like, wow, this was really effective to build this brand that ended up dominating Indonesia?

**中文翻译:**
为了更具体一点，从你刚才分享的内容中我得到的一个有趣启示是：确定品牌方法的第一步是确定产品的个性。你说你们的个性是“平民化”的——我们和你一样，我们在这里是为了帮助你，让你的生活更轻松。然后这影响了文案和信息传递，变得稍微……我忘了你怎么描述的，但就是甚至有点语法不规范之类的，因为这样更能引起人们的共鸣，还有一些与之相关的产品发布。也许你还有什么想补充的？另外，有没有一两个瞬间是对建立品牌帮助最大的？我知道你们因为让司机戴头盔、穿夹克来传播 Gojek 品牌而闻名。还有什么其他事情是让你觉得“哇，这对建立这个最终统治印尼的品牌非常有效”的吗？

---

### [00:23:58] Kevin Aluwi

**English:**
The jackets and helmets piece I think is really, really important for two reasons. One, the more obvious reason, which is that because they were just all over the streets of many cities in Indonesia, people were familiar with the imagery and the names, but I think it's also really important that people saw what was happening. So if we were like, I don't know, an airline and we branded a bunch of people on the streets with our brand, yeah, sure, that might help with brand recall and people might know about the name. But what was really powerful was that when people would be seeing these drivers with their jackets and helmets, they would be seeing passengers on the backseat as they were stuck in traffic. So I'm stuck in traffic and I'm seeing these people whiz past me with with this imagery on them, and immediately I get that association like, oh, I'm stuck in traffic, but I could be out there cutting through traffic on a motorcycle or you see them carrying packages or delivering food, and you immediately get like, oh, these are guys who can deliver food or deliver packages for me.
(00:25:14):
And so it was like this beautiful combination of one just having that imagery and having that visual everywhere as a reminder of the brand. But more importantly, it was also a physical reminder of the service of what we do and of how we can help you. And so looking for these opportunities where again, customers can make that connection between the logo and the colors and the name with actually what the service is, I think are the opportunities that I would say people should look out for. They're admittedly quite rare, which is why in my opinion, the laziest kind of branding tends to be the most popular. Just put your name and your copy on a billboard or on a CPM or CPC campaign. But there are these opportunities I think, on being able to reinforce the value proposition of your business in a way that is beyond just visual recall. And I think that was why that specific anecdote is something I like to talk about because it was really one of those special things that reminded people on why we're here.

**中文翻译:**
夹克和头盔这件事我认为非常非常重要，原因有二。第一，显而易见的原因是，因为它们遍布印尼许多城市的街道，人们熟悉了这些图像和名称。但我认为同样重要的是，人们看到了正在发生的事情。如果我们是一家航空公司，我们在街上给一群人打上品牌标识，是的，这可能有助于品牌回想，人们可能会知道这个名字。但真正强大的是，当人们看到这些穿着夹克、戴着头盔的司机时，他们会看到后座上的乘客，而此时他们正被堵在车流中。所以，当我被堵在路上，看到这些人带着品牌标识从我身边呼啸而过时，我立刻会产生联想：“哦，我被堵住了，但我本可以骑着摩托车穿梭在车流中。”或者你看到他们拎着包裹或送外卖，你立刻会想到：“哦，这些人可以帮我送饭或送包裹。”
(00:25:14):
所以这是一种完美的结合：一方面是随处可见的视觉图像作为品牌提醒；但更重要的是，它也是对我们所做服务以及我们如何帮助你的物理提醒。因此，寻找这些机会——让客户能将 Logo、颜色和名称与实际服务联系起来的机会——我认为是人们应该留意的。诚然，这种机会相当罕见，这就是为什么我认为最懒惰的品牌塑造往往最流行：只需将你的名字和文案放在广告牌上，或者进行 CPM/CPC 广告投放。但我认为，确实存在一些机会，能够以超越视觉回想的方式强化业务的价值主张。我想这就是为什么我喜欢谈论那个特定的轶事，因为它确实是那些提醒人们我们为何存在的特殊事物之一。

---

### [00:26:37] Lenny

**English:**
Yeah, I think you tweeted that it was one of the most important things you ever did as a company is decide to put these logos on the helmets and jackets. Reminds me of Lyft's pink mustache, which went away, but felt like a really important way for them to differentiate.

**中文翻译:**
是的，我记得你发过推特说，决定在头盔和夹克上印 Logo 是你们公司做过的最重要的决定之一。这让我想起了 Lyft 的粉色胡子，虽然它后来消失了，但当时感觉是他们实现差异化的一个非常重要的方式。

---

### [00:26:51] Kevin Aluwi

**English:**
No, totally.

**中文翻译:**
没错，完全同意。

---

### [00:26:53] Lenny

**English:**
You talked about how scrappy you've been, and I want to dig into that a little bit more. I think there's like US startup scrappy, and then there's like Gojek scrappy, and it'd be fun to hear maybe a story or two just to illustrate how ridiculously scrappy you were as a company early on, especially.

**中文翻译:**
你谈到了你们有多么“草根拼命”（scrappy），我想再深入挖掘一下。我觉得有“美国初创公司式的拼命”，还有“Gojek 式的拼命”。如果能听一两个故事来展示你们早期作为一家公司有多么不可思议地拼命，那一定会很有趣。

---

### [00:27:11] Kevin Aluwi

**English:**
One thing that we did in the early days that was absolutely crazy was that we were one of the pioneering companies, one of the pioneering technology companies in Indonesia and in Southeast Asia. And so we came into a environment where a lot of the things that maybe companies or people in more developed economies take for granted, for example, having electronic or digital payments, that was something that actually didn't really exist that much when we first started. And so we had a problem of actually trying to pay drivers because drivers every day we would be paying out incentives or just having customers pay with their credit cards or their store balance, and then we'd have a challenge and getting our drivers to actually be able to take that money out for their earnings. And in the early days, we actually had cash booths. So we actually had physical spaces with a vault and cash sitting in the vault where drivers can show up that, oh, this is my driver ID and this is the balance that I have with you. Please give me the cash.
(00:28:31):
And so we would have these actual physical locations where there would be lions of drivers essentially taking cash. And we eventually figured this out of like, okay, we'll work with a bank and integrate with an ATM network and all that. But in the early days we just did it ourselves of building essentially a mini at ATM network, which I think even that sounds too fancy of what it was it. Because it was literally a booth with a vault with cash in it. And we had at the time already tens of thousands of drivers all across in Indonesia.
(00:29:10):
Another scrappy story that actually Crystal reminded me of recently that we did was at the time there was a lot of fake driver apps out there because we didn't have all of the security investments that we eventually made, things like code obfuscation and better API security that wouldn't allow for these fraudulent driver apps, these basically third party driver apps to connect to our platform. So there were a lot of these drivers using these third party driver apps that were doing things that... So they were kind of doing unsavory things like stealing driver details, some of them even as bad as financial details so that they can then at some point drain driver funds. And the way that they did it, the way that they convinced drivers to actually use these apps was that they actually added some features that at the time we didn't allow. So things like we wanted drivers to be conscious of what was happening on the app, and so we would actually make sure that drivers would push the accept order button.
(00:30:28):
We made sure that that was the only way that drivers could accept orders, but this app had a functionality that would automatically accept orders as soon as they came in. And so actually it was kind of this interesting situation where they were doing things that were fraudulent and were not safe for the integrity of the platform, but at the same time they were also providing some value to the people who were using them. And so at the time we had to make a decision of like, okay, we need to nip this in the bud and one way that we could have done it, that would've taken time was it really invest in a lot of the technical security aspects of it, but we didn't have the bandwidth to be able to do that. Engineering and security talent is actually super scarce in Southeast Asia at the time, still is today, but at that time extremely scarce.
(00:31:25):
And so we ended up making the decision of actually copying those features. So we actually saw all of these third party fraudulent apps and instead of building a whole system to prevent them from being built or preventing them from working on the platform, we just said, "Hey, let's take their top two or three features and let's build them into our app." And that actually significantly reduced the number of users on these third party apps just by having this mentality of you can't beat them, then join them. And that I would say that wasn't a philosophical decision or a principal decision. Is was actually a decision made out of necessity because we simply couldn't build all the capability to combat these apps at the time?

**中文翻译:**
我们在早期做的一件绝对疯狂的事是：我们是印尼和东南亚的先驱科技公司之一。我们进入的环境中，很多在发达经济体中被视为理所当然的事情——比如电子支付或数字支付——在我们刚开始时其实并不怎么存在。所以我们面临一个给司机发工资的问题。每天我们都要发放奖励，或者客户用信用卡或余额支付，然后我们要让司机能把这些收入取出来。在早期，我们实际上设立了“现金亭”。我们有实体的空间，里面有保险库，保险库里放着现金。司机可以过来说：“哦，这是我的司机 ID，这是我在你们这儿的余额，请给我现金。”
(00:28:31):
所以我们会有这些实体地点，排着长队的司机在那儿领现金。最终我们解决了这个问题，比如与银行合作、接入 ATM 网络等等。但在早期，我们只是自己动手，建立了一个本质上是“迷你 ATM 网络”的东西，虽然我觉得这个说法太高级了，因为它实际上就是一个放着保险库和现金的小亭子。而当时我们在全印尼已经有数万名司机了。
(00:29:10):
Crystal 最近提醒我的另一个故事是：当时市面上有很多虚假的司机端应用。因为我们当时还没有进行后来的那些安全投入，比如代码混淆（code obfuscation）和更好的 API 安全，无法阻止这些欺诈性的第三方司机应用连接到我们的平台。很多司机使用这些第三方应用，而这些应用在做一些……令人不齿的事情，比如窃取司机信息，有些甚至恶劣到窃取财务信息，以便日后掏空司机的资金。他们说服司机使用这些应用的方法是添加了一些我们当时不允许的功能。例如，我们希望司机能意识到应用上发生了什么，所以我们会确保司机必须点击“接受订单”按钮。
(00:30:28):
我们确保这是司机接单的唯一方式，但那些应用有一个功能：订单一进来就自动接单。所以这成了一个有趣的情况：他们虽然在做欺诈行为，危害平台完整性，但同时也为使用者提供了一些价值。当时我们必须做一个决定：我们需要把它掐灭在萌芽状态。一种方法是投入大量时间进行技术安全建设，但我们当时没有那个带宽。东南亚的工程和安全人才当时非常稀缺，现在依然如此，但当时是极端稀缺。
(00:31:25):
所以我们最终决定：直接抄袭那些功能。我们观察了所有这些第三方欺诈应用，没有去建立一套复杂的系统来阻止它们开发或运行，而是直接说：“嘿，让我们把它们最受欢迎的两三个功能拿过来，做进我们自己的应用里。”通过这种“打不过就加入”的心态，实际上显著减少了这些第三方应用的用户数量。我想说，这并不是一个哲学上的决定或原则上的决定，这纯粹是出于无奈，因为我们当时根本没有能力去对抗那些应用。

---

### [00:32:13] Lenny

**English:**
Are you hiring or on the flip side, are you looking for a new opportunity? Well, either way, check out lennysjobs.com/talent. If you're a hiring manager, you can sign up and get access to hundreds of hand curated people who are open to new opportunities. Thousands of people apply to join this collective. And I personally review and accept just about 10% of them. You won't find a better place to hire product managers and growth leaders, join almost a hundred other companies who are actively hiring through this collective.
(00:32:44):
And if you're looking around for a new opportunity actively or passively join the collective, it's free. You can be anonymous and you can even hide yourself from specific companies. You can also leave any time and you'll only hear from companies that you want to hear from. Check out lennysjobs.com/talent.

**中文翻译:**
你正在招聘吗？或者反过来，你正在寻找新机会吗？无论哪种情况，请查看 lennysjobs.com/talent。如果你是招聘经理，你可以注册并接触到数百名经过人工筛选、正在寻找新机会的人才。成千上万的人申请加入这个人才库，而我个人会审核并仅录取其中约 10% 的人。你找不到比这更好的地方来招聘产品经理和增长领导者了。加入近百家正通过该人才库积极招聘的公司吧。
(00:32:44):
如果你正在主动或被动地寻找新机会，请加入这个人才库，它是免费的。你可以保持匿名，甚至可以对特定公司隐藏自己。你也可以随时退出，并且只会收到你感兴趣的公司的消息。请访问 lennysjobs.com/talent。

---

### [00:33:03] Lenny

**English:**
These are hilarious stories that you had to compete with these ripoff jail broken apps, fraudulent apps, and then you had to build a cash box network all over the country. That's amazing. I knew there would be good stories in this question and I'm glad you delivered. There's also this feeling of within Gojek of just doing the hard thing and you just shared a couple stories of this versus the simple... A lot of startups are like, let's do the simplest thing, feels like you guys lean into the hard thing. Why is that? Where'd that come from? And then is there any other story of something that you did that was like, we'll do it the hard way?

**中文翻译:**
这些故事太有意思了，你们不得不与那些山寨破解版应用、欺诈应用竞争，还得在全国建立现金盒网络。太神奇了。我就知道这个问题会有好故事，很高兴你分享了。在 Gojek 内部还有一种“只做难事”的感觉，你刚才分享了几个例子。很多初创公司会想“让我们做最简单的事”，但感觉你们总是倾向于做难事。这是为什么？这种精神从何而来？还有没有其他故事，是关于你们选择“走难走的路”的？

---

### [00:33:41] Kevin Aluwi

**English:**
I really don't like the idea of moats. Again, one of the concepts that gets thrown out a lot by strategy type folks of what's the moat of your business or your product? And usually people are looking for an answer like, oh, look at this capability or look at this feature or look at this distribution partner or all of those kind of things. And I don't believe that any moats are durable over time. Eventually with enough time all moats can be crossed. And I think one so-called moat that doesn't get talked about enough is the fact that you're able to do hard things because hard things are hard and just simply doing things that are hard, as long as they create value to your customers, actually is a position that makes it harder for your competitors to be able to win over your customers because it's hard to do those things.
(00:34:52):
And probably another example of doing something that sounds very difficult was that in the early days of Gojek, there was a lot of resistance to our services and one of the forms of that resistance, one of the more most common form of that resistance in the early days was actually by motorcycle taxi mafia. So you would have these areas that are essentially controlled through violence by specific area mafia. And when we start having drivers pick up orders and pick up passengers, these people would actually physically assault our drivers. We've had everything from bricks thrown at our drivers to knives and machetes being brandished at them to just physical altercations, literally mobs of people getting into these brawls. And there was a lot of these kind of things that actually happened in the streets of Jakarta at the time. And I think it would've been easy for us to say, "Hey, they're all contractors, they're third parties, let them kind of just sort it out."
(00:36:14):
But instead we actually hired private security. So we actually work with private security companies to help these situations, to help our drivers in those situations, to help extract them out of these sticky situations. And so we actually ran a fairly big private security operation for a fairly long time until it became common to have Gojek drivers do all of these things across cities. We actually ran this very operation intensive thing just to make sure that our drivers could be as safe as possible and it showed our commitment to the driver community, it showed our commitment that we cared. And again, going back to that earlier point around having that branding association, drivers knew that, hey, we weren't just a platform that didn't care. We actually cared about their safety and that helped build that goodwill even as competitors started coming in and paying more money, we still had a lot of loyalty within the driver community because of things like that.

**中文翻译:**
我真的很不喜欢“护城河”（moats）这个概念。这也是战略专家们经常抛出的概念之一：你的业务或产品的护城河是什么？通常人们期待的答案是：哦，看这个能力，或者看这个功能，或者看这个分销合作伙伴，诸如此类。我不相信任何护城河是永久耐用的。只要时间足够，所有的护城河最终都能被跨越。我认为有一个所谓的护城河被讨论得不够多，那就是“你能做难事”这一事实。因为难事就是很难，只要这些难事能为客户创造价值，那么仅仅是“做难事”本身就能让你处于一个竞争对手难以挖走你客户的位置，因为做这些事太难了。
(00:34:52):
另一个听起来非常困难的例子是：在 Gojek 早期，我们的服务遇到了很多阻力。早期最常见的一种阻力形式实际上来自“摩托车出租车黑手党”。有些地区基本上是由特定的地方黑势力通过暴力控制的。当我们开始让司机接单和载客时，这些人实际上会对我们的司机进行人身攻击。我们经历过各种事情，从向司机扔砖头，到向他们挥舞小刀和砍刀，再到肢体冲突，简直就是暴徒群殴。当时雅加达街头经常发生这类事情。我想，对我们来说，当时很容易会说：“嘿，他们都是承包商，是第三方，让他们自己解决吧。”
(00:36:14):
但相反，我们实际上雇佣了私人安保。我们与私人安保公司合作来应对这些情况，在那些场合帮助我们的司机，帮他们从棘手的局面中脱身。因此，在相当长的一段时间里，我们实际上运行着一个规模相当大的私人安保行动，直到 Gojek 司机在城市各处提供服务变得司空见惯。我们运行这个极其繁重的运营项目，只是为了确保我们的司机尽可能安全。这展示了我们对司机社区的承诺，展示了我们的关怀。再次回到之前提到的品牌联想点：司机们知道，嘿，我们不只是一个漠不关心的平台，我们真的在乎他们的安全。这帮助我们建立了声誉，即使后来竞争对手进入并提供更高的报酬，我们在司机社区中依然拥有极高的忠诚度，就是因为这类事情。

---

### [00:37:30] Lenny

**English:**
How did you actually have a security person on a motorcycle? Were they pretending to be the rider and then just get out and punch them in the face?

**中文翻译:**
你们具体是怎么做的？是让安保人员骑着摩托车吗？他们是假装成骑手，然后突然跳出来给对方一拳吗？

---

### [00:37:39] Kevin Aluwi

**English:**
A minority of situations were like that, but a lot of that was just like, having an on-call service where they could just dial a number and somebody within a 5-10 minute distance would actually show up. And so we would have these patrols effectively in specific hotspots where if there was a situation brewing that they would instantly or almost instantly show up to the site and help diffuse it.

**中文翻译:**
极少数情况是那样的，但大部分情况更像是提供一种“随叫随到”的服务。司机只需拨打一个号码，5 到 10 分钟路程内的人就会出现。我们在特定的“热点地区”设有巡逻队，如果发现有冲突苗头，他们会立即或几乎立即赶到现场协助化解。

---

### [00:38:13] Lenny

**English:**
I love that you have this super app that's doing all these things for people. Plus within the company you've built all these mini businesses, like a whole bank to pay people, private security company. There's probably some other... Crystal shared a story of you guys rented out a stadium for drivers to collect all the drivers and give them phones.

**中文翻译:**
我喜欢这种感觉：你们有一个为人们做这么多事的超级应用，而在公司内部，你们还建立了一堆“微型业务”，比如一个给人们发钱的银行，一个私人安保公司。可能还有其他的……Crystal 分享过一个故事，说你们租下了一个体育场，把所有司机召集起来给他们发手机。

---

### [00:38:33] Kevin Aluwi

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:38:34] Lenny

**English:**
Okay. This is great.

**中文翻译:**
太棒了。

---

### [00:38:34] Kevin Aluwi

**English:**
Yeah, that I think is probably one of the hallmarks of this region in general where I have no doubt that what we were building and what we are today is a technology company, but I do think that in the early days you do have to be a lot more operations heavy. And then I think that lends to that scrappiness because there are a lot of things that to solve elegantly and technically will take a lot of time and just kind of over focusing on those type of solutions I think would be doing your customers a disservice because there are opportunities to make things a lot better just through probably more innovation in operations to kind of kickstart things until you have the more elegant, scalable, technical or product solution.

**中文翻译:**
是的，我认为这可能是这个地区的标志性特征之一。我毫不怀疑我们当时正在构建的以及我们今天所处的是一家科技公司，但我确实认为在早期，你必须更加注重运营。我认为这造就了那种“拼劲”，因为有很多事情如果想用优雅的技术手段解决会花很长时间。我认为如果过度专注于这类解决方案，反而是对客户的不负责任，因为通过运营上的创新来启动项目，可以更快地让事情变得更好，直到你拥有更优雅、可扩展的技术或产品解决方案。

---

### [00:39:38] Lenny

**English:**
That reminds me that at Gojek, you held tons of different roles throughout the time you were there. You were obviously co-founder, your Co-CEO at one point, defacto CPO at one point, CIO, CFO. I heard that you were writing like push notification copy, became a driver at one point just to keep things running. So feels like another good example of exactly what you're talking about of just doing the hard thing in the operational component.

**中文翻译:**
这让我想起你在 Gojek 期间担任过无数不同的角色。你显然是联合创始人，曾任联席 CEO，一度是事实上的 CPO（首席产品官），还当过 CIO（首席信息官）和 CFO（首席财务官）。我听说你还写过推送通知的文案，甚至一度亲自去当司机以维持运转。这似乎是你刚才所说的“在运营环节做难事”的又一个绝佳例子。

---

### [00:40:05] Kevin Aluwi

**English:**
I mean, yes, actually I did have a stint as an amateur performance marketer in the early days of Gojek. I would write copy, I would upload ads onto Facebook and Google and try and do my best in optimizing our online marketing spend. But I think I did all of those things, not because I wanted to be scrappy necessarily, but I do think that as, and this is probably most relevant for founders, less for executives, but I think as a founder, I do think it's really important to understand the work that needs to be done in order to see what excellence looks like. And for us, again, we came from an ecosystem where the availability of experienced talent was relatively low. And so for me it was very hard to be able to say, "oh, let's hire person X from organization Y with job description Z," and we know that they probably can deliver because again, the talent availability was really low.
(00:41:16):
And so a lot of times I felt like I needed to understand, okay, what is this job? What exactly does it entail is, and seeing how bad I am at it allowed me to understand what good looked like. And so I held a lot of those roles just because I wanted to understand every part of the business as best as I could in order to then find somebody who could do it orders of magnitude better than myself. I would say that is true for all of these roles except for being a driver. I think being a driver, I wasn't trying to understand what excellence as a driver look like. Obviously the drivers do a really challenging job and I think I just wanted to understand what that role was like to build a lot more empathy towards the job and make sure that our product was catered towards what those needs were.
(00:42:12):
So when we first launched our car ride hailing services, I think I was the first actual driver on the app and I would every now and then be a driver. And I remember the early days when I actually picked up a customer. It was this lady and she put in her destination as a mall. And so I went to this house and I knew that, okay, I needed to drive to this mall, but then this lady comes out with this giant bag and so I had to hop out the car, take this giant bag, put it in my trunk, and then off we went. And in the middle of the drive she's like, "Hey, I need to drop off and do my laundry on the way to the mall." And I just had to, "okay, cool." We took a detour, I lugged this giant bag out of our trunk and helped this lady do her laundry.
(00:43:17):
And then we went to the mall and I got very little money out of that experience and it wasn't instant, but this is eventually what led to, I think a lot of the support I gave to our driver teams when they were pushing for, Hey, we need more waiting fees, we need to add multiple stops in order to make sure that hey, a lot of this extra work was actually compensated. And it was something that I obviously experienced personally and it was something that I definitely was excited about as a set of product features and principles when it came to building our driver app.

**中文翻译:**
是的，实际上在 Gojek 早期，我还做过一段时间的业余绩效营销人员（performance marketer）。我会写文案，把广告上传到 Facebook 和 Google，并尽力优化我们的在线营销支出。但我做这些事，不一定是因为我想表现得多么“草根”，而是因为我认为作为创始人（这对创始人最相关，对高管次之），理解需要完成的工作对于定义什么是“卓越”至关重要。再次强调，我们当时所处的生态系统中，有经验的人才相对匮乏。所以对我来说，很难直接说：“哦，让我们从 Y 机构招个做 Z 工作的 X 人才吧”，然后就指望他们能出成果，因为人才供应真的很有限。
(00:41:16):
所以很多时候我觉得我需要先理解：好吧，这份工作是什么？它具体包含什么？看到自己做得有多烂，能让我理解什么是做得好。所以我担任这些角色只是为了尽可能深入地了解业务的每个部分，以便随后找到能比我做得好上几个数量级的人。除了当司机以外，所有角色都是如此。我觉得当司机时，我并不是在试图理解什么是“卓越的司机”。显然，司机们做的是一份非常具有挑战性的工作，我只是想了解那个角色是什么样的，从而对这份工作产生更多的共鸣（empathy），并确保我们的产品能迎合这些需求。
(00:42:12):
所以当我们第一次推出汽车网约车服务时，我想我是应用上的第一个真实司机，我偶尔会去跑跑单。我记得早期有一次我接到了一个客户。那是一位女士，她的目的地是一个商场。我开车去她家，我知道我要开往商场，但那位女士拎着一个巨大的袋子出来，所以我不得不跳下车，接过那个大袋子放进后备箱，然后出发。开到一半，她说：“嘿，去商场的路上我得顺便把衣服送去洗了。”我只能说：“好吧，没问题。”我们绕了路，我把那个大袋子从后备箱搬出来，帮那位女士洗了衣服。
(00:43:17):
最后我们到了商场，那次经历我只赚了很少的钱。虽然不是立竿见影，但这最终促使我大力支持司机团队提出的需求，比如：我们需要增加等待费，我们需要增加多点停靠功能，以确保这些额外的工作能得到补偿。这是我亲身经历过的事情，所以在构建司机端应用时，我对这些产品功能和原则感到非常兴奋。

---

### [00:43:58] Lenny

**English:**
It feels like having to do that ends up being a feature as you said, that you actually experienced a lot of these challenges and you said the really good point about knowing what to hire and what these people are going to actually do.

**中文翻译:**
感觉就像你说的，亲自去做这些事最终变成了一种“功能”，因为你亲身经历了这些挑战。而且你提到了一个非常好的观点：只有这样你才知道该招什么样的人，以及这些人具体要做什么。

---

### [00:44:07] Kevin Aluwi

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:44:07] Lenny

**English:**
That's interesting how that often turns into a good thing. I know you also have a pretty interesting journey into tech. What can you share around that?

**中文翻译:**
这很有趣，这种经历往往会转化为好事。我知道你进入科技行业的历程也很有趣。关于这一点你能分享些什么吗？

---

### [00:44:18] Kevin Aluwi

**English:**
So I am basically a failed finance professional. I didn't really know what I wanted to do in my life. And in 2005, which is when I entered college, the hot sexy thing to do was finance. And I guess that was what I wanted to do. And I went, studied finance, and then the crash of 2008 happened and I graduated 2009, so it's probably the worst time to try and be a finance professional. And so I went through a really challenging time there, but eventually I got a job at a boutique investment banking firm. And that was, I thought like, okay, now I was set for life. I got the job that I wanted. I'm working in finance. But then long story short, I was not very good. I was not very good. My bosses thought I was underperforming. I didn't feel like I was performing, and I kind of left that field that I thought I built my entire, I guess future dreams and identity around.
(00:45:32):
And after I did that, I decided to take a bet in Indonesian technology because when all of this was happening was around 2010, 2011, and it was starting to see the development of the current technology giants in the US at the time. And I thought that it would be pretty cool if Indonesia ever had a technology industry to be part of it at the ground floor. And so I moved back in 2011 and it was super early. It was really early at the time where the level of talent, the level of funding, the level of product market fit, the number of people who transacted on the internet was also still super low. People still saw the internet as a place for chat apps and social media. And so the level of belief that people had in the space at that time was pretty low.
(00:46:30):
People didn't think that real businesses and real valuable products could be built, especially be built locally. And so taking that bet was something that I think it really panned out for us to be really early in the space, which today has become very vibrant to the scene. Southeast Asia has become, I think one of the most exciting spaces in technology in the world to date. But at the time it wasn't obvious. And being able to see that development I think was something that was really important to me because it really shows you what's possible in a very short time. And I think it's something that probably people in technology in the US can relate to, the people who've been working in this space for like 20, 30 years. But being able to see those early days for me was just really valuable and I think was an experience that I definitely cherish.

**中文翻译:**
我基本上是一个失败的金融从业者。我以前真的不知道自己想做什么。2005 年我上大学时，最热门、最光鲜的职业是金融。我想那就是我想做的。于是我去学了金融，然后 2008 年金融危机爆发，我 2009 年毕业，那可能是成为金融从业者最糟糕的时机。我经历了一段非常艰难的时期，但最终我在一家精品投资银行（boutique investment banking）找到了一份工作。当时我想：好吧，这辈子稳了。我得到了想要的工作，我在金融界工作。但长话短说，我做得并不好。我真的不在行。我的老板认为我表现不佳，我自己也觉得没发挥出来。于是我离开了那个我曾以为会寄托我全部未来梦想和身份认同的领域。
(00:45:32):
在那之后，我决定在印尼科技行业博一把。因为这一切发生时大约是 2010、2011 年，当时美国现在的科技巨头正开始崛起。我想，如果印尼能有自己的科技产业，能在初期就参与其中一定会很酷。于是我在 2011 年搬了回来，当时还处于非常早期的阶段。人才水平、资金水平、产品市场匹配度（PMF）以及在网上交易的人数都非常低。人们仍然把互联网看作是聊天应用和社交媒体的场所。所以当时人们对这个领域的信心相当低。
(00:46:30):
人们不认为能建立起真正的业务和真正有价值的产品，尤其是本地化的产品。所以，在那时博一把，让我们成为了这个领域的先行者，这最终得到了回报。今天这个领域已经变得非常活跃。我认为东南亚已成为当今世界上最令人兴奋的科技领域之一。但在当时，这并不显而易见。能够见证这种发展对我来说非常重要，因为它向你展示了在极短时间内一切皆有可能。我想美国科技界那些工作了 20、30 年的人可能也会有共鸣。但对我来说，能亲历那些早期岁月是非常宝贵的，是我非常珍惜的一段经历。

---

### [00:47:31] Lenny

**English:**
It's really hard to just build a company outside of Silicon Valley, and it was even harder back then. COVID and remote work almost made it the easiest it's ever been.

**中文翻译:**
在硅谷以外建立一家公司真的很难，而当时更是难上加难。新冠疫情和远程办公几乎让这件事变得前所未有的容易。

---

### [00:47:40] Kevin Aluwi

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:47:40] Lenny

**English:**
Sounds like a lot of the fact that you were so far away from the Bay Area informed the way that you built this company, the scrappiness that you talked about. I'm curious if you have any advice for a founder who's trying to build a company now outside of, say the Bay Area or just US in general based on your experience.

**中文翻译:**
听起来，远离湾区这一事实影响了你们建立公司的方式，也就是你提到的那种“拼劲”。我很想知道，根据你的经验，对于现在想要在湾区以外、或者说美国以外建立公司的创始人，你有什么建议吗？

---

### [00:47:58] Kevin Aluwi

**English:**
Yeah, look, it was super hard back then. It was particularly hard because Indonesia is such a valuable market, Indonesia and the rest, I would say primarily Indonesia just because of its scale. But I think overall Southeast Asia was just such a valuable market and it was interesting for global companies to want to win it. So we competed with global and regional companies, but the local talent and funding ecosystems were really underdeveloped. So that challenge of having to compete with the best in the world for customers in the market while also not having all of the resources available within the market to be able to build products and companies that can compete was I would say one of the most challenging parts of building probably in markets that are atypical or outside of Silicon Valley and maybe some of the other technology centers in the world like China and India.
(00:49:01):
So some of my learnings probably there that I would take going forward is I think we talked a lot about being scrappy. In the beginning, we were a lot more ops-heavy than tech-heavy. And doing the things that don't scale through other means I think is definitely something that is absolutely necessary if you're building outside of these main technology hubs. Another thing I would say is you need to get good at remote work really early. And I think today that's kind of become a lot more prevalent as more and more people have experience with remote work. For us, we built an engineering center in Bangalore in 2015, and this allowed us to compete a lot better with the global giants because we had access to a really deep talent market in India at the time, but we were really early in this whole remote work thing because it wasn't common for people in our region, but also globally to have so much talent concentration outside of headquarters.
(00:50:14):
And I do believe that companies who want to compete against world class competitors outside of these technology centers like Silicon Valley need to become good at remote work really fast because getting that talent probably means having offices or individuals who are outside of your home market or your headquarters. And probably the final I would say tip here is don't just copy, because Gojek was not an Uber clone, even though that was kind of how some investors or analysts talk about us, we were focused on a solution that was uniquely an Indonesian phenomenon, the motorcycle taxi driver. And this led to both product and branding innovation. On the product side, we were an on-demand super app because we saw that a human being on a motorcycle could do a lot of things. And so we built a product around that idea and hence we ended up with a super app even before super apps were really a thing.
(00:51:24):
And then that branding point that we talked about a little earlier about giving our drivers jackets and helmets so people could see them zip around town, which actually doesn't make sense if you're a car ride hailing service because it's not very easy to brand a car and the drivers are inside the car. But all of our competitors at the time when they first entered the motorcycle ride hailing space didn't brand their drivers because they came from a car-centric view. And so again, understanding your unique market dynamics is also really important if you're building outside of these technology centers.

**中文翻译:**
是的，听着，当时真的超级难。特别难是因为印尼是一个非常有价值的市场，主要是因为它的规模。我认为整个东南亚都是一个非常有价值的市场，全球性公司都想赢得它。所以我们不仅要与全球公司竞争，还要与地区性公司竞争，但本地的人才和资金生态系统却非常不发达。因此，既要与世界上最优秀的公司竞争客户，又没有足够的市场资源来构建具有竞争力的产品和公司，我认为这是在非典型市场（即硅谷以及中国、印度等科技中心以外的市场）创业最困难的部分之一。
(00:49:01):
我的一些经验教训是：首先，我们谈了很多关于“拼劲”。在开始阶段，我们更偏重运营而非技术。如果你在这些主要科技中心以外的地方创业，通过其他手段做那些“无法规模化”（don't scale）的事情绝对是必要的。另一件事是，你需要很早就擅长远程协作。我想今天这已经变得很普遍了。我们在 2015 年就在班加罗尔建立了一个工程中心，这让我们能更好地与全球巨头竞争，因为我们当时接触到了印度深厚的人才市场。但在当时，我们在远程办公方面走得很超前，因为当时在我们的地区乃至全球，在总部以外拥有如此高的人才集中度并不常见。
(00:50:14):
我坚信，想要在硅谷等科技中心以外与世界级对手竞争的公司，必须迅速掌握远程协作，因为获取人才可能意味着要在本土市场或总部以外设立办公室或招募个人。最后一点建议是：不要只是抄袭。Gojek 不是 Uber 的克隆版，尽管有些投资者或分析师是这么看我们的。我们专注于解决一个独特的印尼现象：摩托车出租车司机。这带来了产品和品牌上的创新。在产品方面，我们是一个按需超级应用，因为我们看到一个骑摩托车的人可以做很多事情。于是我们围绕这个想法构建了产品，因此在超级应用真正流行之前，我们就已经拥有了一个。
(00:51:24):
还有我们之前提到的品牌塑造点：给司机发夹克和头盔，让人们看到他们在城里穿梭。如果你是汽车网约车服务，这其实行不通，因为给汽车打品牌标识不容易，而且司机在车里。当时我们所有的竞争对手在进入摩托车网约车领域时都没有给司机打品牌标识，因为他们持有的是“以汽车为中心”的观点。所以，如果你在这些科技中心以外创业，理解你独特的市场动态也非常重要。

---

### [00:52:10] Lenny

**English:**
We've been chatting about Indonesia and Southeast Asia. I'd love to hear just what should people know about that market? We've chatted about what you guys have built and a few other companies here and there, but what companies should people be aware of what's happening? What's the latest, what's exciting?

**中文翻译:**
我们一直在聊印尼和东南亚。我很想听听，人们应该了解那个市场的哪些方面？我们聊了你们建立的公司，以及其他一些零星的公司，但人们还应该关注哪些公司？那里正在发生什么？最新的、令人兴奋的事情是什么？

---

### [00:52:24] Kevin Aluwi

**English:**
Yeah, I think specifically Indonesia, most people don't know that Indonesia is the fourth largest country in the world and that Southeast Asia holds almost 10% of the world's population. But beyond the macro picture, I think also we've experienced a pretty unique level of pace of adoption for products with great product market fit. So products with great product market fit grow tremendously fast in this part of the world. And in 2015, for example, when we launched our app, we grew more than a hundred percent month on month for the first 16, 18 months. So we more than doubled every month for more than a year.

**中文翻译:**
是的，我认为特别是印尼，大多数人不知道印尼是世界第四大人口大国，而东南亚拥有世界近 10% 的人口。但除了宏观层面，我认为我们还经历了一种非常独特的、具有极佳 PMF（产品市场匹配度）的产品的采用速度。在这个地区，具有极佳 PMF 的产品增长速度惊人。例如在 2015 年我们发布应用时，在前 16 到 18 个月里，我们的月环比增长超过了 100%。也就是说，在一年多的时间里，我们每个月都在翻倍。

---

### [00:53:16] Lenny

**English:**
That is insane. I've never heard of that.

**中文翻译:**
这太疯狂了。我从未听说过这种增长速度。

---

### [00:53:19] Kevin Aluwi

**English:**
No, and our investors at the time, Sequoia is one of our investors at the time, told us that this was the craziest growth story that they've ever heard of in the world. And I wouldn't say because of our necessarily our brilliance, it was a combination of how in Indonesia and in Southeast Asia, there are a lot of these things that are obviously broken and could be improved with better technology and better products. But we also have in this region a very young population who are excited to try new things. And so if you find a solution that really resonates with a lot of these common day-to-day problems, the adoption curve is just absolutely insane. And I think it's one of the things that are definitely unique to developing regions like this one.
(00:54:14):
One company that's really interesting for example, just to give a flavor of the type of seemingly off the wall product or company being built in this part of the world, there's a company called eFishery, and what they do is they basically create a closed loop ecosystem for fish farmers in currently, I think they're only operational Indonesia or they're recently expanding beyond Indonesia.
(00:54:45):
They help farmers feed their fish through this IOT smart device that helps measure the amount of fish feed that needs to go into the ponds, but they also then help farmers do things that get financing and also sell their produce out to local or even regional or global markets. And it's a company doing something like a quarter billion dollars in revenue and it's profitable and it's basically a fish farmer, a close loop ecosystem. And it's pretty wild that something like this exists, but it does speak to, I think again earlier what I said earlier about the hunger that the population have for better solutions. And if you can find these better solutions, you can really build companies of the very meaningful scale very, very quickly.

**中文翻译:**
是的，我们当时的投资者（红杉资本是其中之一）告诉我们，这是他们在全球听过的最疯狂的增长故事。我不会说这完全是因为我们的聪明才智，而是因为在印尼和东南亚，有很多显而易见的问题可以通过更好的技术和产品来改善。而且这个地区拥有非常年轻的人口，他们热衷于尝试新事物。所以，如果你能找到一个能引起日常问题共鸣的解决方案，其采用曲线（adoption curve）简直是疯狂的。我认为这是像我们这样发展中地区所特有的现象。
(00:54:14):
举个有趣的例子，为了让你感受一下这个地区正在构建的那种看似“离谱”的产品或公司：有一家公司叫 eFishery。他们基本上是为养鱼户创建一个闭环生态系统。目前我想他们主要在印尼运营，或者最近刚开始向海外扩张。
(00:54:45):
他们通过物联网（IOT）智能设备帮助渔民喂鱼，该设备可以测量需要投入池塘的饲料量。此外，他们还帮助渔民获得融资，并将产品销往本地、地区甚至全球市场。这家公司的营收大约在 2.5 亿美元左右，而且已经盈利了。它本质上就是一个养鱼户的闭环生态系统。这种公司的存在挺疯狂的，但它再次印证了我之前说的：人们对更好解决方案的渴望。如果你能找到这些解决方案，你真的可以非常迅速地建立起具有重大规模的公司。

---

### [00:55:42] Lenny

**English:**
So at this point, you've stepped down a CEO, you've stepped down from the board, what's next and how does it feel?

**中文翻译:**
那么现在，你已经卸任了 CEO，也退出了董事会。接下来有什么打算？感觉如何？

---

### [00:55:50] Kevin Aluwi

**English:**
Yeah, I'm still on this journey honestly, of how does it feel. I think that building Gojek is by far the most important professional experience and frankly, one of the most important life experiences I've had. It's made me a way better person actually. And now that I've stepped away, I am not as bored or as aimless as people would expect after having such a kind of all-consuming thing be part of my life experience.
(00:56:37):
What's next? Honestly, Lenny, I don't know. I don't have a plan at this stage. I do some angel investing on the side. I work with other founders to be able to maybe just share some of these experiences that I shared today and just figuring out what makes me happy and what are the kind activities that I find rewarding. I don't know, maybe I'll start another company at some point. I think that's my default, but I think right now I'm just taking things easy and trying to figure out another problem I guess, that I could be obsessed about.

**中文翻译:**
说实话，关于“感觉如何”，我还在体会中。我认为建立 Gojek 是我迄今为止最重要的职业经历，坦率地说，也是我最重要的生活经历之一。它实际上让我变成了一个更好的人。现在我离开了，我并没有像人们预期的那样感到无聊或迷茫，毕竟之前那是占据了我全部生活的经历。
(00:56:37):
接下来做什么？老实说，Lenny，我不知道。现阶段我没有计划。我会做一些天使投资，也会与其他创始人合作，分享我今天分享的这些经验。我只是在弄清楚什么能让我快乐，以及哪些活动让我觉得有意义。我不知道，也许在某个时候我会再开一家公司，我想那是我的默认选项。但现在，我只是想放松一下，试着寻找另一个能让我痴迷的问题。

---

### [00:57:25] Lenny

**English:**
You've earned that time to explore and look for new problems. Is there anything else you wanted to touch on before we get to our very exciting lightning round?

**中文翻译:**
你赢得了探索和寻找新问题的时间。在我们进入非常令人兴奋的闪电轮（lightning round）之前，你还有什么想谈的吗？

---

### [00:57:33] Kevin Aluwi

**English:**
No Lenny. I think we've covered a lot today, and I just wanted to thank you for the time.

**中文翻译:**
没有了，Lenny。我想我们今天已经涵盖了很多内容，我只想感谢你抽出的时间。

---

### [00:57:41] Lenny

**English:**
Amazing. It's absolutely my pleasure. And with that, we've reached our very exciting lightning round. I've got five questions for you. Are you ready?

**中文翻译:**
太棒了。这是我的荣幸。那么，我们进入了非常令人兴奋的闪电轮。我有五个问题要问你。准备好了吗？

---

### [00:57:48] Kevin Aluwi

**English:**
Yes, let's go.

**中文翻译:**
准备好了，开始吧。

---

### [00:57:50] Lenny

**English:**
What are two or three books that you've recommended most to other people?

**中文翻译:**
你向别人推荐最多的两三本书是什么？

---

### [00:57:54] Kevin Aluwi

**English:**
What You Do Is Who You Are. I think that was the second most popular Ben Horowitz's book, but I'm really obsessed with building interesting and engaging cultures, so I think that's one. Another is a classic marketing book. Again, we talked a lot about branding today, so there's this book called How Brands Grow by Byron Sharp. I don't agree necessarily with everything in it, but I do think that it's a great primer on how to think about branding and marketing.

**中文翻译:**
《你的行为决定你是谁》（What You Do Is Who You Are）。我想这是本·霍罗维茨（Ben Horowitz）第二受欢迎的书，但我非常痴迷于建立有趣且引人入胜的文化，所以这是其中一本。另一本是经典的营销书籍。既然我们今天谈了很多品牌，有一本书叫《品牌如何增长》（How Brands Grow），作者是 Byron Sharp。我不一定同意书中的所有观点，但我认为它是思考品牌和营销的极佳入门读物。

---

### [00:58:25] Lenny

**English:**
Favorite recent movie or TV show?

**中文翻译:**
最近最喜欢的电影或电视节目？

---

### [00:58:27] Kevin Aluwi

**English:**
Favorite recent movie, The Menu and favorite recent TV show? Netflix show is a Cyberpunk 2077 Edge Runners.

**中文翻译:**
最近最喜欢的电影是《五星菜单》（The Menu）。最近最喜欢的电视节目？Netflix 的动画片《赛博朋克：边缘行者》（Cyberpunk 2077: Edgerunners）。

---

### [00:58:38] Lenny

**English:**
Oh, wow. I haven't heard of that one.

**中文翻译:**
噢，哇。我还没听说过那个。

---

### [00:58:39] Kevin Aluwi

**English:**
Oh, you should check it out. It's super cool.

**中文翻译:**
噢，你应该去看看。超级酷。

---

### [00:58:42] Lenny

**English:**
I'll go check it out.

**中文翻译:**
我会去看的。

---

### [00:58:43] Kevin Aluwi

**English:**
Yeah.

**中文翻译:**
好的。

---

### [00:58:43] Lenny

**English:**
Favorite interview question that you like to ask.

**中文翻译:**
你最喜欢问的面试问题是什么？

---

### [00:58:46] Kevin Aluwi

**English:**
Tell me about a subject or activity you've been obsessed with for a long time.

**中文翻译:**
告诉我一个你长期以来一直痴迷的主题或活动。

---

### [00:58:51] Lenny

**English:**
What do you look for in an answer that's like, okay, this is good.

**中文翻译:**
你希望在回答中看到什么，从而觉得“好吧，这个回答很棒”？

---

### [00:58:54] Kevin Aluwi

**English:**
I want somebody to basically almost pitch to me an obsession they have than makes me interested in knowing more into that subject. The more obscure, the better and the more passionate they are about an obscure thing, even better. And I think it shows people's capability to be really passionate about something and sell something and think about something in a very structured and detailed way.

**中文翻译:**
我希望对方能向我“推销”他们的痴迷，让我对那个主题产生进一步了解的兴趣。越冷门越好，如果他们对冷门事物充满激情，那就更好了。我认为这展示了一个人对某事充满热情的能力，以及推销某事、以非常结构化和详细的方式思考某事的能力。

---

### [00:59:25] Lenny

**English:**
What are some products that you love and have recently discovered?

**中文翻译:**
有哪些你喜欢且最近发现的产品？

---

### [00:59:30] Kevin Aluwi

**English:**
Two products, I think right now that I've found absolutely delightful. One is the ARC Browser. I know that it's gaining a lot of traction out there, but I'm a very chronic tab hoarder. My Chrome tabs are just all over the place, and I love that they've figured out I would say the best approach to kind of tab management, and there's just a ton of little delightful, awesome design details in the app that I think is just really cool. And it's a browser. When's the last time there was a really cool browser that came out? So I also love the ambition that the company has.
(01:00:09):
Second product, Steam Deck. I'm a huge gamer, and I think it is probably, I would say the best game platform to actually build on the vision of truly portable mobile gaming.

**中文翻译:**
有两个产品我觉得非常令人愉悦。一个是 ARC 浏览器。我知道它现在很火，但我是一个典型的“标签页囤积狂”。我的 Chrome 标签页到处都是，我喜欢他们找到了一种我认为是最好的标签页管理方法。应用里有很多令人愉悦、很棒的设计细节，我觉得非常酷。而且它是一个浏览器——上一次出现这么酷的浏览器是什么时候？我也很喜欢这家公司的雄心壮志。
(01:00:09):
第二个产品是 Steam Deck。我是一个资深游戏玩家，我认为它可能是真正实现“便携式移动游戏”愿景的最佳游戏平台。

---

### [01:00:25] Lenny

**English:**
I love your point with ARC for tab hoarders. I also used to have a lot of tabs and I love it just auto deletes stuff and just disappear, and it forces you to lose your tabs and it works out surprisingly.

**中文翻译:**
我喜欢你关于 ARC 适合标签页囤积狂的观点。我以前也有很多标签页，我喜欢它会自动删除一些东西，让它们消失，这强迫你放弃那些标签页，结果效果出奇地好。

---

### [01:00:38] Kevin Aluwi

**English:**
Final question.

**中文翻译:**
最后一个问题。

---

### [01:00:38] Lenny

**English:**
I'm curious what comes up for this one? What's something you've recently changed or that you've heard of someone at Gojek recently changed in their product development process that was maybe minor, that had a tremendous impact on the team's ability to execute.

**中文翻译:**
我很好奇这个问题你会怎么回答。你最近改变了什么，或者你听说 Gojek 的某人在产品开发流程中最近改变了什么（也许是很小的改变），但对团队的执行能力产生了巨大的影响？

---

### [01:00:53] Kevin Aluwi

**English:**
One relatively minor thing that I thought had a lot of impact with execution is being very clear that whoever is accountable for the results should also be the decider. I found that a lot of literature out there says that product teams should be this communal best ideas come from everywhere group, which I think is well-intentioned and absolutely everyone should contribute ideas, but I think not having it be super clear who is accountable and who is deciding often slows down execution a lot. And I think when we switch to making it really clear that who was the decider for any kind of product development process, I think our execution definitely improved significantly.

**中文翻译:**
我认为对执行力产生重大影响的一个相对较小的改变是：明确规定谁对结果负责，谁就应该是决策者。我发现很多文献都说产品团队应该是一个“好点子来自四面八方”的共同体，我认为这出发点是好的，每个人确实都应该贡献点子。但如果不明确谁负责、谁决策，往往会大大降低执行速度。我认为当我们转向明确谁是任何产品开发流程的决策者时，我们的执行力确实得到了显著提升。

---

### [01:01:37] Lenny

**English:**
Amazing. Kevin, thank you so much for being here. Gojek is such an interesting and important story, and I feel like most founders can learn something from the story, so I was really excited to bring you on and to hear a lot of these wild stories that you shared. Two final questions. Where can folks find your line if they want to reach out, learn more, and how can listeners be useful to you?

**中文翻译:**
太棒了。Kevin，非常感谢你能来。Gojek 是一个如此有趣且重要的故事，我觉得大多数创始人都能从中受益。所以我非常兴奋能请你来，听你分享这些疯狂的故事。最后两个问题：如果人们想联系你或了解更多信息，可以在哪里找到你？以及听众可以为你提供什么帮助？

---

### [01:01:57] Kevin Aluwi

**English:**
I am @kaluwi on Twitter. That's also my email, kaluwi@gmail.com. I'll always be happy to chat about Gojek or just generally anything technology related. Again, I have nothing I'm working on at the moment, so I just would love to jam with cool people.

**中文翻译:**
我的 Twitter 账号是 @kaluwi。我的邮箱也是 kaluwi@gmail.com。我很乐意聊聊 Gojek 或者任何与科技相关的话题。再次强调，我目前没有在做具体项目，所以我很想和酷的人一起交流碰撞。

---

### [01:02:22] Lenny

**English:**
Amazing. Thank you again for being here.

**中文翻译:**
太棒了。再次感谢你的到来。

---

### [01:02:25] Kevin Aluwi

**English:**
Thanks, Lenny.

**中文翻译:**
谢谢，Lenny。

---

### [01:02:28] Lenny

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
非常感谢您的收听。如果您觉得本期节目有价值，可以在 Apple Podcasts、Spotify 或您喜欢的播客应用中订阅本节目。此外，请考虑给我们评分或留下评论，因为这能帮助其他听众发现这个播客。您可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目再见。