# Kevin Yien - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Kevin Yien.

---

### (00:00:00) Kevin Yien

**English:**
The PM job can become a little too internal, influencing my stakeholders and getting alignment and all these things. But if you can't sell or support your own product, I don't trust you to build the product.

**中文翻译:**
产品经理（PM）的工作有时会变得过于对内，整天忙于影响利益相关者、达成共识之类的。但如果你连自己的产品都卖不出去，或者没法提供客户支持，那我就不相信你能打造出好产品。

---

### (00:00:10) Lenny Rachitsky

**English:**
You think every PM should keep a decision log?

**中文翻译:**
你认为每个产品经理都应该记录决策日志吗？

---

### (00:00:13) Kevin Yien

**English:**
We all talk about product sense. To me, it's just a fancy way of saying you can make good decisions with insufficient data. PMs need as many reps as possible in making decisions, documenting the rationale behind those decisions, and then crucially seeing the outcome of them.

**中文翻译:**
我们都在谈论“产品感”。对我来说，这只是“在数据不足的情况下做出正确决策”的一种高级说法。产品经理需要尽可能多地练习做决策，记录决策背后的逻辑，而最关键的是，要观察这些决策最终产生的结果。

---

### (00:00:28) Lenny Rachitsky

**English:**
We have a lot of interesting approaches to hiring, including this idea of a unsell email.

**中文翻译:**
我们在招聘方面有很多有趣的方法，包括这个“劝退邮件”（unsell email）的想法。

---

### (00:00:31) Kevin Yien

**English:**
When you get to offer stage, I send an email and I say all the terrible things that are probably going to reinforce their fears. If you can tell them that upfront and they can read that whole email and still be equally excited to join you, find yourself a A+ hire.

**中文翻译:**
当到了发录用信（offer）的阶段，我会发一封邮件，列出所有可能加剧他们担忧的糟糕情况。如果你能提前把这些告诉他们，而他们在读完这封邮件后依然对加入公司感到兴奋，那么你就找到了一个 A+ 级的员工。

---

### (00:00:45) Lenny Rachitsky

**English:**
I'm curious if you found any interesting uses of AI in your work.

**中文翻译:**
我很想知道你在工作中是否发现了 AI 的一些有趣用途。

---

### (00:00:49) Kevin Yien

**English:**
We are not even beneath the dust on the surface when it comes to what's going to change.

**中文翻译:**
谈到即将发生的变革，我们现在的认知甚至还没触及到表面灰尘之下的部分。

---

### (00:01:00) Lenny Rachitsky

**English:**
Today, my guest is Kevin Yien. Kevin leads product for merchant experiences at Stripe. Before that, he built the restaurant business and the ecosystem teams at Square, and most recently was head of product and design at Mutiny. He also makes ice cream and, as you'll hear in there conversation, was a pretty competitive eater for some part of his life.

**中文翻译:**
今天的嘉宾是 Kevin Yien。Kevin 在 Stripe 负责商户体验产品。在此之前，他在 Square 建立了餐饮业务和生态系统团队，最近曾担任 Mutiny 的产品与设计负责人。他还会做冰淇淋，而且正如你在对话中听到的，他在人生的某个阶段还是个相当厉害的大胃王选手。

---

### (00:01:17) Lenny Rachitsky

**English:**
In our conversation, Kevin shares a ton of unique and insightful perspectives on how to be a successful product manager, including how to get into product management, how to improve your relationship with your engineers and designers, bunch of advice on hiring, why you should keep a decision log, how to automate your customer research, plus a ton of really powerful stories around failure and AI and career.

**中文翻译:**
在我们的对话中，Kevin 分享了大量关于如何成为成功产品经理的独特且深刻的见解，包括如何进入产品管理领域、如何改善与工程师和设计师的关系、一系列招聘建议、为什么要记录决策日志、如何自动化客户研究，以及许多关于失败、AI 和职业生涯的极具感染力的故事。

---

### (00:01:40) Lenny Rachitsky

**English:**
This episode is for anyone looking to become a better leader, thinker, and builder of products. If you enjoy this podcast, don't forget to subscribe and follow in your favorite podcasting app or YouTube. It's the best way to avoid missing feature episodes, and it helps the podcast tremendously. With that, I bring you Kevin Yien.

**中文翻译:**
这一集是为那些希望成为更好的领导者、思考者和产品构建者的人准备的。如果你喜欢这个播客，别忘了在你不常用的播客应用或 YouTube 上订阅和关注。这是避免错过未来节目的最好方式，也对我们的播客有巨大帮助。那么，现在有请 Kevin Yien。

---

### (00:02:00) Lenny Rachitsky

**English:**
Kevin, thank you so much for being here and welcome to the podcast.

**中文翻译:**
Kevin，非常感谢你能来，欢迎来到本播客。

---

### (00:02:04) Kevin Yien

**English:**
Thanks, Lenny. I am humbled to be here.

**中文翻译:**
谢谢，Lenny。能来到这里我感到很荣幸。

---

### (00:02:05) Lenny Rachitsky

**English:**
I've been a big fan of yours from afar. I've been following you on Twitter for a long time. You have a very distinct profile photo that I feel like you maybe haven't changed for a long time. How long have you had this profile?

**中文翻译:**
我一直是你的忠实粉丝。我在 Twitter 上关注你很久了。你有一张非常有辨识度的头像，感觉你好像很久没换过了。这张头像你用了多久了？

---

### (00:02:16) Kevin Yien

**English:**
Oh gosh, probably 2011 or 2012. The story behind that is I was inspired actually by Chris Dixon's avatar at the time and I wanted something really similar to it, but I couldn't figure out how to. Luckily, I was dating a designer at the time, and so she made me that sort of custom pick that has been my profile since then, and she's now my wife.

**中文翻译:**
噢天哪，大概是 2011 或 2012 年开始用的。背后的故事是，我当时受到了 Chris Dixon 头像的启发，想要一个非常类似的，但我不知道怎么弄。幸运的是，我当时正在和一个设计师约会，她帮我做了那个定制头像，从那以后就一直用作我的个人资料照片，而她现在成了我的妻子。

---

### (00:02:40) Lenny Rachitsky

**English:**
Oh my god. Funny enough, I had a startup idea once where it's like a profile picture as a service business where there's these three tiers where it's like one has automated, one has someone illustrates, and one is a professional photo. It feels like everyone profile photos are so important.

**中文翻译:**
我的天。有趣的是，我曾经有过一个创业点子，就是做“头像即服务”的业务，分为三个等级：一个是自动生成的，一个是人工插画的，一个是专业摄影。感觉每个人的头像都非常重要。

---

### (00:02:54) Kevin Yien

**English:**
True.

**中文翻译:**
确实。

---

### (00:02:55) Lenny Rachitsky

**English:**
But I never follow through. Probably not a good business anyway.

**中文翻译:**
但我从未付诸行动。反正可能也不是什么好生意。

---

### (00:02:59) Kevin Yien

**English:**
Yeah, but a good idea, a good tool.

**中文翻译:**
是的，但确实是个好主意，也是个好工具。

---

### (00:03:00) Lenny Rachitsky

**English:**
Good idea. Thank you. Thank you for making me feel better.
(00:03:03):
I've been looking forward to this conversation for a long time. As I said, I've been a big fan of yours for a long time. Something that I've noticed about you is you have a lot of really unique perspectives on a lot of different things, and in particular, product management, how to be successful as a PM, how to get into product management, things like that. So I thought it'd be fun to start there talking through some of these things that I've heard you talk about and then get into some very tactical stuff that you found to be useful in your product management career.
(00:03:29):
The first thing that I've heard you talk about is that you discourage people from going straight into product management. If they want to become product managers, you encourage them to start somewhere else first. Why is that? Where do you think people should start? Talk about this insight that you've had.

**中文翻译:**
好主意。谢谢，谢谢你让我感觉好受点。
我期待这次对话很久了。正如我所说，我关注你很久了。我注意到你对很多事情都有非常独特的见解，尤其是关于产品管理、如何成为成功的 PM、如何入行等等。所以我想从这些话题开始聊起，然后再深入探讨一些你在职业生涯中发现非常有用的实操技巧。
我听你提到的第一件事是，你不鼓励人们直接进入产品管理领域。如果他们想成为 PM，你鼓励他们先从其他岗位开始。这是为什么？你认为人们应该从哪里开始？谈谈你的这个见解。

---

### (00:03:45) Kevin Yien

**English:**
Yeah, so follow me on the detour to science world temporarily. If we all remember high school science classes, there was this concept of potential and kinetic energy. There's so many different definitions for product management, but the one that I have come to myself that I really like is, when you are building a product, you have this team, engineers, designers, so much potential. The purpose of product management, not the person, but the practice, is to convert that potential into as much realized value for someone as possible, right? Minimum loss. When you're just getting started with a new product, the people that should be doing that are the people who are building it. That's an engineer, that's a designer, that's a sales person or a support person. They're the front line of the smallest loop possible to get something going, and it's through those practices that I think you're able to get the most exposure to what it takes to build a good product.
(00:04:50):
And then from there, that's your foundation. That's the unique perspective that you bring and allows you then to actually take on a "role" of product manager in a good, unique, insightful way. That's sort of like the foundation. There's a lot more to unpack behind that comparison, but that's where it comes from.

**中文翻译:**
好的，请允许我暂时绕道去一下科学世界。如果我们还记得高中的科学课，里面有势能和动能的概念。产品管理有很多不同的定义，但我自己总结并非常喜欢的一个是：当你构建产品时，你拥有一个团队——工程师、设计师，他们蕴含着巨大的势能。产品管理的目的（不是指这个人，而是指这项实践）就是将这种势能转化为尽可能多的、为某人实现的价值，对吧？并且损失最小。当你刚开始做一个新产品时，应该做这件事的人是那些正在构建它的人。那是工程师、设计师、销售人员或支持人员。他们是让事情运转起来的最短闭环的前线。我认为正是通过这些实践，你才能最大限度地接触到构建好产品所需的要素。
从那里开始，那就是你的基础。那是你带来的独特视角，让你能够以一种优秀的、独特的、有见地的方式真正承担起产品经理的“角色”。这就像是基石。这个类比背后还有很多可以挖掘的东西，但这就是它的来源。

---

### (00:05:06) Lenny Rachitsky

**English:**
I love that. I'd love to unpack it further.
(00:05:10):
This episode is brought to you by BuildBetter.AI. Back in 2020 when AI was just a toy, BuildBetter bet that it could cut down on a product teams' operational BS. Fast-forward to today, 23,000 product teams use purpose-built AI in BuildBetter every day.

**中文翻译:**
我喜欢这个观点。我想进一步探讨一下。
本集节目由 BuildBetter.AI 赞助。早在 2020 年，当 AI 还只是个玩具时，BuildBetter 就打赌它可以减少产品团队运营中的琐碎杂事。快进到今天，每天有 23,000 个产品团队在 BuildBetter 中使用专门构建的 AI。

---

### (00:05:28) Lenny Rachitsky

**English:**
First, BuildBetter uses custom models to turn unstructured data like product and sales calls, support tickets, internal communications, and surveys into structured insights. It's like having a dedicated data science team. Second, BuildBetter runs those structured insights into workflows, like weekly reports about customer issues, context-aware PRDs, and user research document with citations. It even turns standups into action items that automatically get assigned and shared into your tools. Plus, with unlimited seat pricing on all plans, BuildBetter ensures everyone at your company has access to this knowledge. Truly, no data silos.

**中文翻译:**
首先，BuildBetter 使用自定义模型将非结构化数据（如产品和销售电话、支持工单、内部沟通和调查）转化为结构化洞察。这就像拥有一个专门的数据科学团队。其次，BuildBetter 将这些结构化洞察运行到工作流中，例如关于客户问题的周报、具有上下文感知能力的 PRD（产品需求文档）以及带有引用的用户研究文档。它甚至能将站会转化为自动分配并共享到你工具中的行动项。此外，所有方案都提供无限席位定价，BuildBetter 确保你公司的每个人都能访问这些知识。真正做到无数据孤岛。

---

### (00:06:05) Lenny Rachitsky

**English:**
In a world of AI demos over promising and under delivering, see why BuildBetter has a 93% subscription retention. Get a personalized demo and use code LENNY for $100 credit if you sign up now at buildbetter.ai/lenny.
(00:06:22):
I'm excited to chat with Christina Gilbert, the founder of OneSchema, one of our longtime podcast sponsors. Hi, Christina.

**中文翻译:**
在 AI 演示满天飞、承诺多兑现少的今天，来看看为什么 BuildBetter 拥有 93% 的订阅留存率。现在访问 buildbetter.ai/lenny 注册，获取个性化演示并使用代码 LENNY 即可获得 100 美元的抵扣额度。
很高兴能与 OneSchema 的创始人 Christina Gilbert 聊天，她是我们的长期赞助商之一。你好，Christina。

---

### (00:06:30) Christina

**English:**
Yes, thank you for having me on, Lenny.

**中文翻译:**
是的，谢谢你邀请我，Lenny。

---

### (00:06:32) Lenny Rachitsky

**English:**
What is the latest with OneSchema? I know you now work with some of my favorite companies like Ramp, Vanta, Scale, and Watershed. I heard that you just launched a new product to help product teams import CSVs from especially tricky systems like ERPs.

**中文翻译:**
OneSchema 最近有什么新动态？我知道你们现在正与我最喜欢的一些公司合作，比如 Ramp、Vanta、Scale 和 Watershed。我听说你们刚刚推出了一个新产品，帮助产品团队从 ERP 等特别棘手的系统中导入 CSV 文件。

---

### (00:06:47) Christina

**English:**
Yes, so we just launched OneSchema FileFeeds, which allows you to build an integration with any system in 15 minutes as long as you can export a CSV to an SFTP folder. We see our customers all the time getting stuck with hacks and workarounds. And the product teams that we work with don't have to turn down prospects because their systems are too hard to integrate with. We allow our customers to offer thousands of integrations without involving their engineering team at all.

**中文翻译:**
是的，我们刚刚推出了 OneSchema FileFeeds，只要你能将 CSV 导出到 SFTP 文件夹，它就能让你在 15 分钟内构建与任何系统的集成。我们经常看到客户被各种临时补丁和变通方案困扰。与我们合作的产品团队不必因为对方系统太难集成而拒绝潜在客户。我们让客户能够提供数千种集成，而完全不需要工程团队参与。

---

### (00:07:09) Lenny Rachitsky

**English:**
I can tell you that if my team had to build integrations like this, how nice would it be to be able to take this off my roadmap and instead use something like OneSchema and not just to build it but also to maintain it forever.

**中文翻译:**
我可以告诉你，如果我的团队必须构建这样的集成，能把它从我的路线图中拿掉，转而使用像 OneSchema 这样的工具，那该有多好——不仅是构建，还包括永久的维护。

---

### (00:07:21) Christina

**English:**
Absolutely, Lenny. We've heard so many four stories of multi-day outages from even just a handful of bad records. We have laser-focused on integration reliability to help teams end all of those distractions that come up with integrations. We have a built-in validation layer that stops any bad data from entering your system, and OneSchema will notify your team immediately of any data that looks incorrect.

**中文翻译:**
绝对是这样，Lenny。我们听过太多因为几条错误记录就导致长达数天停机的惨痛故事。我们专注于集成的可靠性，帮助团队消除集成过程中出现的所有干扰。我们有一个内置的验证层，可以阻止任何错误数据进入你的系统，OneSchema 会立即通知你的团队任何看起来不正确的数据。

---

### (00:07:40) Lenny Rachitsky

**English:**
I know that importing incorrect data can cause all kinds of pain for your customers and quickly lose their trust. Christina, thank you for joining us. If you want to learn more, head on over to oneschema.co. That's oneschema.co.
(00:07:54):
Every PM has their definition of what is product management, and I have one that I'm trying to find exactly what I wrote, but essentially, it's to marshal the resources of your team to solve customer problems and drive business impact most efficiently, something like that. And I feel like it's very aligned with your perspective, but I really love this view of it's unlocking the potential energy of the team. Not just marshaling the resources of a team, but it's there, and your job is to maximize their effort. And this is why when people say, "I hate product managers. I don't want any product managers at my team. We don't need product managers here," I feel like that's often because you've had a bad PM. Good PMs make you better and make your life better, allow you to do the work you want to do and they take all the stuff you don't want to do, make sure the stuff you're doing is worthwhile.
(00:08:38):
Is there anything more you want to add along those lines?

**中文翻译:**
我知道导入错误数据会给客户带来各种痛苦，并迅速失去他们的信任。Christina，谢谢你加入我们。如果你想了解更多，请访问 oneschema.co。
每个 PM 对什么是产品管理都有自己的定义，我也有一个，我正在找我具体是怎么写的，但本质上是：调动团队资源，以最高效的方式解决客户问题并推动业务影响，大概是这样。我觉得这与你的观点非常一致，但我真的很喜欢“释放团队势能”这个视角。不仅仅是调动资源，资源就在那里，你的工作是最大化他们的努力。这就是为什么当人们说“我讨厌产品经理，我团队里不想要任何产品经理，我们不需要产品经理”时，我觉得通常是因为你遇到了糟糕的 PM。好的 PM 会让你变得更好，让你的生活更轻松，让你能做你想做的工作，他们承担了你不想做的杂事，并确保你所做的事情是有价值的。
关于这一点，你还有什么想补充的吗？

---

### (00:08:41) Kevin Yien

**English:**
To elaborate on that, I think the broader point is that truly not every team needs a product manager, but the activities, the outcome that one would drive needs to get done no matter what. And in some cases, this is why the prototypical companies that everyone references when they say, "They never had product managers, look at how successful they are," they're all building for themselves. Stripe, Twilio, Figma, designers for designers, engineers for engineers. When you are the customer, why the heck do you need someone else to help do the things that let you make decisions on what to build? But if you are not the customer, if you're working in a particularly complex space, if there's something that you, as the person that could build the product, feel you don't have, that's when you can essentially delegate that responsibility to someone else to say, "Hey, let me do the things I'm really good at and you do something that I need to get my job done."
(00:09:39):
So it's that sort of relationship that I think is often missing in the discourse. I think it would alleviate a lot of the, "We don't want PMs. PM is useless" or, "PM's one of the best thing since [inaudible 00:09:52]," which they're not. It's just a manifestation of that problem.

**中文翻译:**
详细说明一下，我认为更广泛的观点是，确实并非每个团队都需要一个产品经理，但产品经理所推动的那些活动和结果，无论如何都必须完成。在某些情况下，这就是为什么大家常提到的那些典型公司——当人们说“他们从来没有产品经理，看他们多成功”时——他们其实都是在为自己构建产品。Stripe、Twilio、Figma，设计师为设计师做产品，工程师为工程师做产品。当你自己就是客户时，你到底为什么需要别人来帮你做那些决定“该造什么”的事情呢？但如果你不是客户，如果你在一个特别复杂的领域工作，如果你作为能够构建产品的人，觉得缺少某些东西，那时候你就可以把这项责任委托给别人，说：“嘿，让我做我擅长的事，你来做那些我为了完成工作而需要的事情。”
所以我认为这种关系在讨论中经常被忽略。我觉得这能缓解很多“我们不想要 PM，PM 没用”或者“PM 是自切片面包以来最伟大的发明”之类的极端言论（其实 PM 没那么伟大）。这只是那个问题的一种表现形式。

---

### (00:09:55) Lenny Rachitsky

**English:**
Yeah. Just to build on that, we're going on a tangent, but I think that's really interesting. I think there's another element of that, SNAP actually is another example where they waited, I think, until they had 200 people before they hired their first PM. To me, that's an example of other people were doing the PM job. As you said, there's PM activity, someone's doing them, lining people, prioritizing, making sure things are clear, making sure people aren't surprised, all these things PMs do. Someone's doing that, and my feeling is like, "Okay, your designers may love doing that, great. Let them do it." If your engineers that have a lot of product sense may want to do that, great.
(00:10:28):
But there's some point they either is like, "Forget it. I just want to code. I want to build that. I want to be sitting around in meetings all day," or they just aren't as good as things are scaling. And so it's kind of like, if your engineers, designers want to do it and are good at it, great. You don't need PMs for a long time. Oftentimes they're not good at it or they don't want to be sitting in doing all these PM things.

**中文翻译:**
是的。补充一点，虽然有点扯远了，但我认为这很有趣。还有另一个因素，SNAP 实际上是另一个例子，我记得他们直到有 200 人时才雇佣了第一个 PM。对我来说，这说明当时是其他人在做 PM 的工作。正如你所说，PM 的活动总得有人做：协调人员、确定优先级、确保事情清晰、确保大家不会感到意外，所有这些 PM 做的事。有人在做这些，我的感觉是：“好吧，如果你的设计师喜欢做这些，太好了，让他们去做。”如果你的工程师很有产品感，想做这些，也太好了。
但到了某个点，他们要么会觉得：“算了，我只想写代码，我只想构建产品，我不想整天坐在会议室里”，要么就是随着规模扩大，他们做得不够好。所以这就像是，如果你的工程师、设计师想做且擅长做，那太棒了，你很长一段时间都不需要 PM。但通常情况下，他们要么不擅长，要么不想整天陷在这些 PM 的琐事里。

---

### (00:10:46) Kevin Yien

**English:**
Yep, precisely.

**中文翻译:**
没错，正是如此。

---

### (00:10:48) Lenny Rachitsky

**English:**
Okay, so going back to the question of... So your advice is don't go straight into product management if you want to become a great PM. Where do you think people should start if they can? What are some options you recommend?

**中文翻译:**
好，回到那个问题……所以你的建议是，如果你想成为一名优秀的 PM，不要直接入行。你认为如果可以的话，人们应该从哪里开始？你推荐哪些选择？

---

### (00:10:58) Kevin Yien

**English:**
The best way to think about this, in my opinion, is who were the people that you would be taking the PM responsibilities from and then do those jobs? And so for me, the sort of foundational three are going to be engineer, designer or salesperson. I think sales also gets not a bad rep, but a misrepresented reputation in tech where all they care about is quota, it's just about numbers, et cetera. In reality, the best salespeople are the best listeners, the best people at understanding the problem that the customer is having and then translating that into what you can do for them. And so if you get really good at having those calls, getting told no a lot, and being able to translate that, I mean, why would you not want to start there and then eventually move into something like product? So that's the foundational three for me.

**中文翻译:**
在我看来，思考这个问题最好的方式是：你会从谁手里接手 PM 的职责？那就先去做那些工作。对我来说，最基础的三个岗位是：工程师、设计师或销售人员。我认为销售在科技行业名声不算坏，但被误解了，大家觉得他们只关心业绩指标、只看数字等等。实际上，最优秀的销售是最好的倾听者，最擅长理解客户面临的问题，并将其转化为你能为他们做的事情。所以，如果你能变得非常擅长打那些电话、习惯被拒绝，并能转化这些信息，我的意思是，为什么不从那里开始，然后最终转向产品呢？所以这三个是我的基础推荐。

---

### (00:11:56) Lenny Rachitsky

**English:**
So your advice is essentially if you want to be a PM, start as a designer or an engineer or a salesperson. I was an engineer, so this is exactly the path I went on. And I think there's an element of you start there and then you realize you're never going to be as amazing as the other people at that role and you're like, "Okay, maybe I should explore this other thing," because I was like, "I'm never going to be an amazing engineer. I'm good enough."

**中文翻译:**
所以你的建议本质上是：如果你想当 PM，先做设计师、工程师或销售。我以前是工程师，所以我走的正是这条路。我觉得其中有一个因素是，你从那里开始，然后意识到自己在那个角色上永远不会像其他人那样出色，于是你会想：“好吧，也许我该探索一下别的东西”，因为我当时觉得：“我永远不会成为一名顶尖的工程师，我只是还凑合。”

---

### (00:12:18) Kevin Yien

**English:**
Totally.

**中文翻译:**
完全理解。

---

### (00:12:18) Lenny Rachitsky

**English:**
I'm like, "I'm pretty good at this other stuff. Let's explore that."

**中文翻译:**
我会想：“我在其他这些事情上做得挺好，让我们探索一下吧。”

---

### (00:12:21) Kevin Yien

**English:**
The one thing that I might tack on there, because this could lead to a negative perception, is, "Well, I'm never going to be a world-class engineer, world-class designer or et cetera, and so let me settle for being a PM." That could be the conclusion you arrive at, but I think a better way of framing it is, "I'm okay at those things. I'm potentially world-class at this other thing. Let me see what it feels like to double down on this area."

**中文翻译:**
我可能想补充一点，因为这可能会导致一种负面的认知，即：“好吧，我永远成不了世界级的工程师或设计师，所以我只好退而求其次当个 PM。”你可能会得出这样的结论，但我认为更好的表达方式是：“我在那些事情上做得还可以，但我在这件别的事情上可能有世界级的潜力。让我看看在这个领域加倍努力会是什么感觉。”

---

### (00:12:44) Lenny Rachitsky

**English:**
Absolutely.

**中文翻译:**
绝对正确。

---

### (00:12:45) Kevin Yien

**English:**
And I think that's just a good framing.

**中文翻译:**
我觉得这才是好的思维框架。

---

### (00:12:47) Lenny Rachitsky

**English:**
Okay, so let's talk about another insight and piece of advice that you have, is that you think that great PMs need to be great writers. I think a lot of people don't necessarily think this. I think people may probably think, "If I'm an okay writer, I can probably be really successful PM." Talk about why you think it's so important to be a really great writer to be a really great PM.

**中文翻译:**
好，那我们聊聊你的另一个见解和建议：你认为优秀的 PM 必须是优秀的作家（写作者）。我想很多人不一定这么认为。人们可能会想：“如果我写作水平还行，我也能成为非常成功的 PM。”谈谈为什么你认为要成为顶尖 PM，优秀的写作能力如此重要。

---

### (00:13:07) Kevin Yien

**English:**
It's actually shocking for me to hear that this isn't commonplace sort of acceptance, but the place that this comes from for me is, writing is clarity at scale, and a key component to a PM's job is creating clarity both internally and externally, but it is both sides of that that I think often get lost. A lot of times the PM job can become a little too internal, and it's about influencing my stakeholders and getting alignment and all these things. Don't get me wrong, all that's very important. You should write your PRDs, they should be super crisp, they should articulate things really well, but I'm not saying that every PM needs to be a marketer or a world-class copywriter, but you should be able to write really compelling messaging in the voice of the person that you're trying to serve. And I'm working backwards from the beliefs that, if you can't sell or support your own product, I don't trust you to build the product. And so that's where I think writing is the foundational component there.

**中文翻译:**
听到这还没成为普遍共识，我其实挺惊讶的。对我来说，这个观点的来源是：写作是“规模化的清晰”。PM 工作的核心组成部分就是在内部和外部创造清晰度，但我认为这两方面往往都会被忽视。很多时候，PM 的工作变得过于对内，整天忙于影响利益相关者、达成共识等等。别误会，这些都很重要。你应该写 PRD，它们应该非常简洁明了，表达清晰。但我并不是说每个 PM 都需要成为营销人员或世界级的文案，但你应该能够以你所服务的对象的口吻，写出非常有说服力的信息。我的逻辑是基于这样一个信念：如果你不能推销或支持你自己的产品，我就不相信你能造出这个产品。这就是为什么我认为写作是其中的基础组件。

---

### (00:14:11) Lenny Rachitsky

**English:**
There's a few quotes I say often on this podcast just because they always come to mind. One is by Joan Didion who said that, "I don't know what I think until I've written it down." And that's what I find with writing where I need to actually write it down for me to really understand what the heck I'm thinking to really crystallize it.

**中文翻译:**
在这个播客中我经常引用几句话，因为它们总是在我脑海中浮现。一个是琼·狄迪恩（Joan Didion）说的：“在写下来之前，我不知道自己在想什么。”这也是我对写作的感受，我需要真正把它写下来，才能明白自己到底在想什么，才能让想法真正结晶。

---

### (00:14:26) Kevin Yien

**English:**
Yeah, and I think writing is, it's both a mechanism for translating what you're trying to think into that thought into what you're actually trying to do, but then it needs additional revs to be properly consumed by everyone else. And that's I think the really hard part that a lot of folks don't do the extra mile effort to take on.

**中文翻译:**
是的，我认为写作既是一种将你的思考转化为想法、再转化为实际行动的机制，但它还需要额外的打磨，才能被其他人正确地吸收。我认为这才是真正困难的部分，很多人不愿意多花那份力气去完成。

---

### (00:14:50) Lenny Rachitsky

**English:**
And this to your earlier point of a job of PM is to unlock this potential energy of your team, of the various resources you have and obviously having everyone aligned behind a very, like, "This is what we are doing and everyone understanding it" and it being very clear is really powerful there.
(00:15:06):
Okay. So this begs the question, how does one become a great writer? What helped you become a better writer? How do you feel about your ability to write at this point?

**中文翻译:**
这回到了你之前的观点：PM 的工作是释放团队和各种资源的势能。显然，让每个人都对“我们正在做什么”达成共识，并确保每个人都理解且清晰，这在其中非常有力量。
好，那么问题来了，一个人如何成为优秀的写作者？是什么帮助你提高了写作水平？你现在对自己写作能力的评价如何？

---

### (00:15:13) Kevin Yien

**English:**
Oh man.

**中文翻译:**
噢，伙计。

---

### (00:15:14) Lenny Rachitsky

**English:**
Any advise on becoming better?

**中文翻译:**
有什么变强的建议吗？

---

### (00:15:16) Kevin Yien

**English:**
I'll start with a slightly cheeky comment, which is, I think some of this is changing with the advent of large language models and the ability to actually just mimic someone else's tone. But I take inspiration from the camp of Anthony Bourdain, and he has, I'm going to butcher the exact quote but it's something like, "If you want to know how to make good food, you have to eat a lot of food, and you have to be willing to have a bad meal every now and again." And so for me, good writing comes from consuming as much good writing as possible. Sometimes you'll read something and say, "That was actually absolute fresh." But that's okay, you have to be willing to take on some of that stuff. But the more you index towards developing your own taste for what you think is good by consuming others, then you can shift into producing your own and then comparing them and riffing it off other people. So I think that's sort of the cycle that I've gone through.

**中文翻译:**
我先说个有点俏皮的观点：随着大语言模型的出现以及模仿他人语调的能力，情况正在发生变化。但我从安东尼·波登（Anthony Bourdain）那里得到了启发，他有一句话（我可能记不全原话了），大意是：“如果你想知道如何做出美食，你就必须吃大量的食物，并且必须愿意偶尔吃一顿糟糕的饭。”对我来说，好的写作来自于尽可能多地吸收好的作品。有时你会读到一些东西，然后觉得“这简直是垃圾”。但没关系，你必须愿意接触这些。你通过吸收他人的作品，越是倾向于培养自己对“什么是好作品”的品味，你就越能转向创作自己的作品，然后进行比较，并从他人那里汲取灵感。我认为这就是我经历的循环。

---

### (00:16:13) Lenny Rachitsky

**English:**
I have a friend who's a very good writer and a poet and helped me develop my writing early on, Vanessa, and she said exactly the same thing. Just to become a better writer, read beautiful writing, and it just kind of infuses you or your brain. In your experience, is there anything you read, anything you found really effective? Anything that you think influenced the way you write or think that people can check out?

**中文翻译:**
我有一个朋友，她是一位非常优秀的作家和诗人，在早期帮助我提高了写作水平，她叫 Vanessa，她也说过完全一样的话。要成为更好的写作者，就去读优美的文字，它会潜移默化地影响你或你的大脑。在你的经验中，有没有什么你读过的、觉得非常有效的东西？有没有什么你认为影响了你写作或思考方式的东西，可以让大家参考一下？

---

### (00:16:36) Kevin Yien

**English:**
I explicitly do not mean read a bunch of other PM artifacts. You're not going to become a better writer by reading PRDs or whatever it is or support articles. It needs to be writing that compels. That's the theme I would go back to because that's what you're trying to do at the end of the day.
(00:16:56):
And when I say compels, I mean it pushes you to action. Because if you read something and you're like, "Oh, that's interesting," that's not enough. You need to be able to give someone something that then allows them to do something differently. And so the things for me that have been best... Obviously there's all the Paul Graham essays, I think his writing is very succinct, very clear, that's not novel. I learned a lot by finding specific voices back in the day on Twitter, and it wasn't always what they were posting on Twitter, but if they wrote an essay or a post, that would be their crispus thinking. And so you can use these broadcast channels to find where their golden nuggets are, but then spend time with those instead and don't worry about all the additional noise that comes with it.

**中文翻译:**
我明确指的不是去读一堆其他的 PM 产出物。读 PRD 或支持文章不会让你成为更好的写作者。它必须是具有“感召力”的文字。这是我会反复强调的主题，因为这正是你最终想要达到的目的。
当我提到“感召力”时，我的意思是它能推动你采取行动。因为如果你读了某些东西，只是觉得“噢，挺有意思”，那是不够的。你需要能够给别人一些东西，让他们能够以不同的方式行事。对我来说，最好的东西……显然有保罗·格雷厄姆（Paul Graham）的所有文章，我认为他的写作非常简洁、清晰，这并不新鲜。我以前在 Twitter 上通过寻找特定的声音学到了很多，不一定是他们在 Twitter 上发的内容，但如果他们写了一篇文章或帖子，那通常是他们最清晰的思考。所以你可以利用这些传播渠道找到他们的“金句”，然后花时间去研读那些精华，而不用担心随之而来的额外噪音。

---

### (00:17:46) Lenny Rachitsky

**English:**
Paul Graham actually, you mentioned him, he has a great piece on how to become a good, that we'll link to, where basically his advice is, write the way you talk. Just keep it really simple and really regular. And so we'll link to that. Is there anything else along these lines of writing that you'd recommend for folks that are like, "Okay, I need to become a great writer. How do I do this?"?

**中文翻译:**
你提到的保罗·格雷厄姆确实有一篇关于如何成为优秀写作者的佳作，我们会附上链接。他核心的建议是：像说话一样写作。保持简单、自然。我们会链接那篇文章。关于写作，你还有什么建议给那些觉得“好吧，我需要成为一名优秀的写作者，我该怎么做”的人吗？

---

### (00:18:02) Kevin Yien

**English:**
Actually along the lines of write how you talk, there's this concept of cadence that I think is really important when it comes to internal writing. There's probably some very good article about this, but it's the idea that if you only write in a monotonous cadence, either all really short sentences or all really long sentences, then your brain just tunes out eventually. And so you have to interrupt the pattern intentionally, and so you go short-long, long-short, whatever it is, but there's a few various specific things that you can do that allow someone to just roll through a post or something when you write that way.

**中文翻译:**
实际上，顺着“像说话一样写作”的思路，我认为在内部写作中，“节奏感”（cadence）这个概念非常重要。可能有一些关于这方面的优秀文章，但核心思想是：如果你只用单调的节奏写作，要么全是短句，要么全是长句，那么大脑最终会感到疲劳并走神。所以你必须有意识地打破这种模式，长短结合，错落有致。当你这样写的时候，有一些具体的技巧可以让读者非常顺畅地读完一篇文章。

---

### (00:18:43) Lenny Rachitsky

**English:**
Along these lines, there's a book that I just found to make sure I had the right title called Several Short Sentences About Writing that is really helpful along these lines. And the whole book is very short sentences and it teaches you to write very short sentences because once you're good at that, you can get better writing longer sentences. And so we'll link to that too. It's like a really good book that I have two copies around my house that I kind of poke at sometimes.

**中文翻译:**
顺着这个思路，我刚找了一本书，确认了一下书名，叫《关于写作的几个短句》（Several Short Sentences About Writing），对这方面非常有帮助。整本书都是由非常短的句子组成的，它教你如何写短句，因为一旦你擅长写短句，你就能更好地驾驭长句。我们也会链接这本书。这是一本非常棒的书，我家里有两本，偶尔会翻一翻。

---

### (00:19:08) Kevin Yien

**English:**
Nice. I'll have [inaudible 00:19:09] too.

**中文翻译:**
太好了，我也要去看看。

---

### (00:19:10) Lenny Rachitsky

**English:**
Okay. Another area that you have a really clever insight into is how the PM role fits with engineering design. We've talked about this a little bit, but you have a really clever way of just thinking about how these roles interact and who's responsible for what. Talk about that.

**中文翻译:**
好。你在另一个领域也有非常聪明的见解，那就是 PM 角色如何与工程和设计相配合。我们刚才聊了一点，但你对这些角色如何互动以及谁负责什么有一种非常巧妙的思考方式。谈谈那个吧。

---

### (00:19:24) Kevin Yien

**English:**
So this description came from writing PRDs at Square. I think there was a lot of confusion from my team specifically when I joined them. For what it's worth, it was new product line, three engineers, three designers, there was nothing but a slide deck.

**中文翻译:**
这个描述源于我在 Square 写 PRD 的经历。我刚加入那个团队时，大家都很困惑。顺便说一下，那是一个全新的产品线，只有三个工程师、三个设计师，除了一个幻灯片（PPT）外什么都没有。

---

### (00:19:41) Lenny Rachitsky

**English:**
Three engineers and three designers?

**中文翻译:**
三个工程师和三个设计师？

---

### (00:19:43) Kevin Yien

**English:**
The best ratio ever. This is a whole other thing. Most people, I would say, under invest in design, point-blank. When you get to a certain scale, maybe things change, but truly I don't think most teams have experienced what it feels like to have a really high design ratio and what that actually does to the quality of the work and the quality of the thinking. So shout out to designers. We need more, is the short version. And I would rather hire an incremental designer than PM almost any day of the week.

**中文翻译:**
有史以来最好的比例。这是另一回事了。直截了当地说，我认为大多数人在设计上的投入都严重不足。当你达到一定规模时，情况可能会改变，但我真的认为大多数团队都没有体验过拥有极高设计比例的感觉，以及这会对工作质量和思考质量产生怎样的影响。所以，向设计师们致敬。简而言之，我们需要更多设计师。在绝大多数情况下，我宁愿多招一个设计师，也不愿多招一个 PM。

---

### (00:20:18) Lenny Rachitsky

**English:**
Wow. I've never experienced this ratio. Incredible.

**中文翻译:**
哇。我从未经历过这种比例。太不可思议了。

---

### (00:20:21) Kevin Yien

**English:**
Yes, I was very lucky. Shout out to Bruce Bell, who was my manager at the time, who was an ex designer, at the time, GM, and declared that starting ratio.
(00:20:31):
So anyways, with that setup, they all had sort of an opinion. They had seen PRDs in the past, they weren't quite sure what the purpose of it actually was because they had designs already. They had something to start from. And when I came in and talked to everyone and figured out where we needed to be in a year's time, I was like, "Okay, here's how I think it. Let me know if you agree." And this is a whole other concept, which is, the best way to get feedback from people is not by asking what they think, but to put something concrete in front of them and then have them react to it, right? So chewing fork.
(00:21:03):
And so my description is, PM should be doing everything in their power to draw the perimeter of the space, of the problem space. And it's within that, eng, design, everyone else that you're working with, they can go as crazy as they want, push up against the bounds and it's fill the box to its maximum capacity, but you've now applied the constraints that allow you to actually have productive conversations.
(00:21:26):
On the other end of the spectrum though, I think there's a lot of folks who think, "Oh, PMs are just strategy high in the clouds. All they do is kick things off." You need to be obsessed about the final deliverable and whether or not value is actually getting to the customer. I have a really trite example of this if you want to go down it.

**中文翻译:**
是的，我非常幸运。向 Bruce Bell 致敬，他当时是我的经理，以前是设计师，当时是总经理（GM），他确定了这个初始比例。
总之，在那种配置下，大家都有自己的看法。他们以前见过 PRD，但不确定 PRD 的真正目的是什么，因为他们已经有设计稿了，已经有出发点了。当我加入并和大家交流，弄清楚一年后我们需要达到什么目标时，我说：“好吧，这是我的想法，看看你们是否同意。”这涉及另一个概念：获取反馈最好的方式不是问别人怎么想，而是把具体的东西摆在他们面前，让他们做出反应，对吧？就像“调音叉”一样。
所以我的描述是：PM 应该竭尽全力划定问题空间的“周界”（perimeter）。在这个周界之内，工程师、设计师以及所有合作伙伴可以尽情发挥，挑战边界，把这个“盒子”填满。但因为你设定了约束条件，你们现在的对话才是有成效的。
但在光谱的另一端，我认为很多人觉得“PM 只是在高空谈战略，他们只负责启动项目”。其实你需要痴迷于最终的交付物，以及价值是否真正传递到了客户手中。如果你想听的话，我有一个非常平凡但典型的例子。

---

### (00:21:46) Lenny Rachitsky

**English:**
Please.

**中文翻译:**
请讲。

---

### (00:21:46) Kevin Yien

**English:**
But the key point I want to make is, I think it is tempting when we think about engineering product and design to draw these really clear swim lanes and say, "You do X. I do Y. Don't tread on my area." But you need these murky overlaps in order to build something really good.
(00:22:07):
And so even if the engineers are going to build a better product than you and the designers are going to design something better than you, you need to come with a strong opinion and you need to do the legwork to get their trust so they actually care about your opinion in the first place.
(00:22:21):
So time for a mini story. So Square, we're building a point of sale for restaurants. If you've ever seen one of these in a restaurant, there's this sort of grid of tiles that they tap to enter your order when you're sitting down for dinner. We were developing one, and there's this concept of a menu group. So it's a little box, you tap on it and then it pops the screen in so you go to the next level of the hierarchy. So example would be you have a wine button, you tap it, and you see your reds, whites, et cetera.
(00:22:53):
If you think about the people that we were trying to serve, there's the restaurants that were coming from a really old legacy system. And if you've seen a bartender tap on one of these, I mean it is muscle memory to the max. They're not even looking at the thing and just punching in the order blindfolded, and it's rapid fast.
(00:23:12):
On the other hand, you have people who are entering the workforce the first time, they've never used a point of sale. And so we have to serve both of these equally. Well, how do you deal with that level of speed but also the ease of use that anyone can learn it for the first time? And so there was this interaction that we really cared about, which was, when you tap on a menu group, what's the animation to pop you into that next level? This seems like such a small thing, but it made the difference in how easy it was to adopt for a lot of the restaurants.
(00:23:41):
And so a designer and myself spent literally an entire week just fine-tuning how many milliseconds it would take to pop in and out so that it felt right. And we actually brought in servers and bartenders to play with the prototypes we had on iPads and be like, "Here's an order. Pop it in." And we would see where they would sort of flinch or hesitate because the animation was too slow and they thought, "I can't tap it yet," or something related to that.
(00:24:07):
And so it's easy, I think, for a PM to say, "That's not my responsibility. I define the requirements. Have a menu group that goes to the next level, design or engineer, figure it out." No way. That's fully on you, and you better be involved in those details.

**中文翻译:**
我想表达的关键点是：当我们思考工程、产品和设计时，很容易想划清界限，说“你做 X，我做 Y，别过界”。但要做出真正好的东西，你需要这些“模糊的重叠地带”。
所以，即使工程师能造出比你更好的产品，设计师能设计出比你更好的方案，你仍然需要带着强烈的观点，并且你需要做大量的前期工作来赢得他们的信任，这样他们才会真正在意你的观点。
讲个小故事。在 Square，我们正在为餐厅开发收银系统（POS）。如果你在餐厅见过这种东西，它通常有一个网格状的磁贴，服务员点击它们来输入订单。我们当时正在开发一个功能，涉及“菜单组”的概念。它是一个小方块，你点击它，屏幕就会跳转到下一级目录。比如你有一个“葡萄酒”按钮，点击它，就能看到红葡萄酒、白葡萄酒等。
想想我们服务的对象：有些餐厅使用的是非常陈旧的遗留系统。如果你见过调酒师操作这些机器，那简直是肌肉记忆的极致。他们甚至不用看屏幕，闭着眼就能飞快地输入订单。
另一方面，有些是第一次进入职场的新人，从未用过收银系统。我们必须同时服务好这两类人。那么，如何兼顾极致的速度和初学者也能上手的易用性呢？我们非常在意一个交互细节：当你点击菜单组时，进入下一级的动画效果是怎样的？这看起来是件小事，但它决定了许多餐厅是否容易上手。
我和一位设计师整整花了一周时间，仅仅是为了微调弹出和退出的毫秒数，直到感觉“对了”为止。我们甚至请来服务员和调酒师在 iPad 原型上操作，让他们输入订单。我们会观察他们在哪里会退缩或犹豫，可能是因为动画太慢，让他们觉得“现在还不能点”，或者类似的原因。
我认为 PM 很容易说：“那不是我的责任。我定义了需求：点击菜单组进入下一级。设计师或工程师，你们去搞定吧。”绝对不行。这完全是你的责任，你最好参与到这些细节中去。

---

### (00:24:24) Lenny Rachitsky

**English:**
I love this. There's two directions I want to go. So there's the drawing the perimeter, and then there's this paying attention to the final deliverable and keeping the borrow really high, which I love and I totally agree with both.
(00:24:34):
In terms of this animation, people hearing this, that our PMs are going to be like, "How do you have time to spend a week on animation for one little product? I have so much to do. I get to hit some goals, drive some numbers. I have people waiting for me." Maybe because Square is like this, once you deploy, it's harder to change and it's like a big deal to ship. But I'm curious if you have any advice or things you've learned about how to create space for that sort of thing to create time to spend a week on this animation? Or was it just obvious to everyone, "We need to spend as much time as we can"? Top down, everyone knew.

**中文翻译:**
我太喜欢这个了。我想从两个方向深入探讨：一个是划定周界，另一个是关注最终交付物并保持极高的标准，这两点我都非常赞同。
关于这个动画，听众里的 PM 们可能会想：“你怎么有时间花一周时间在一个小产品的动画上？我有那么多事要做，要达成目标，要拉升数据，还有人在等着我。”也许是因为 Square 的性质，一旦部署就很难更改，发布是一件大事。但我很好奇，你是否有任何建议或经验，关于如何为这类事情创造空间，从而腾出一周时间来研究动画？还是说这对每个人来说都是显而易见的，“我们需要尽可能多地花时间”？是自上而下大家都知道吗？

---

### (00:25:07) Kevin Yien

**English:**
I definitely don't think it was obvious to everyone, and I can definitely say that because we were given a pretty strict deadline that we needed to launch by and I pushed it out three times. That's not because of this one animation, but it's because of a series of decisions where we said, "This is what we believe we need to ship, and this matters much more than hitting some artificial external GA date."
(00:25:35):
There's this other aspect that I think PMs like to feel good about how busy they are and they're like, "I'm involved in so many processes and I have to talk to this person and talk to that person." All that might be true, but I think there needs to be a calibration or at least a spring-cleaning of, "What's everything I'm doing?" and how much do these things actually matter to getting value to a customer. Because as a company gets bigger, as teams get more complex, it's very easy and natural to spend more time on things that are internally-focused and not externally-focused. I think we just all have to have sensitive antenna to that so that we don't fall prey to, "Well, the way that my job is described is to do these things," but really it's the outcome again of put something in a customer's hands that's also a problem, and it's amazing.

**中文翻译:**
我绝对不认为这对每个人来说都是显而易见的。我可以肯定地说，因为当时我们有一个非常严格的发布截止日期，而我把它推迟了三次。这不只是因为这一个动画，而是因为一系列决策，我们认为：“这是我们坚信需要交付的东西，这比达成某个人为设定的外部发布日期（GA date）重要得多。”
还有另一方面，我认为 PM 喜欢沉浸在“我很忙”的良好感觉中，觉得“我参与了这么多流程，我得和这个人谈，和那个人谈”。这些可能都是事实，但我认为需要进行一次校准，或者至少是一次“大扫除”，问问自己：“我做的所有这些事情，到底有多少对向客户传递价值真正重要？”因为随着公司变大、团队变复杂，人们很容易自然而然地把更多时间花在对内而非对外的事情上。我认为我们必须对此保持敏锐的嗅觉，这样才不会陷入“我的工作描述就是做这些事”的陷阱，而忘记了真正的结果是把解决问题的、惊艳的东西交到客户手中。

---

### (00:26:29) Lenny Rachitsky

**English:**
Reminds me of your now colleague Jeff Weinstein's advice he got from one of the Coulsons where they came to him and they're like, "You're world-class at doing the second and third most important things and you're not focusing on the most important thing because it's so hard, and that's something you need to work on."

**中文翻译:**
这让我想起你现在的同事 Jeff Weinstein 从 Collison 兄弟（Stripe 创始人）那里得到的建议。他们对他说：“你在做第二和第三重要的事情上是世界级的，但你没有专注于最重要的事情，因为那太难了，这是你需要改进的地方。”

---

### (00:26:47) Kevin Yien

**English:**
Totally. I will say so one on that, the CEO at Mutiny, Charlie, she always repeated to me nonstop, "Keep the main thing the main thing" and would just say it ad nauseum, and I'm really glad that she did. The one excuse I don't want to give folks is, as you progress in your career, you have to walk and chew gum at the same time. You can't say, "Oh, I'm only focused on this thing over here, so other folks handle that." You do have to figure out how to do a little bit more at the same time, but prioritization does play a factor.

**中文翻译:**
完全正确。关于这一点，Mutiny 的 CEO Charlie 总是对我没完没了地重复一句话：“让最重要的事始终是最重要的事”（Keep the main thing the main thing）。她说到我耳朵都起茧了，但我真的很庆幸她这么做了。我不想给人们的一个借口是：随着职业生涯的发展，你必须学会“一心多用”（walk and chew gum at the same time）。你不能说：“噢，我只专注于这一件事，所以其他事让别人去管吧。”你确实需要学会同时处理更多事情，但优先级排序确实是关键因素。

---

### (00:27:25) Lenny Rachitsky

**English:**
There's a framework [inaudible 00:27:27] suggested that I really like, the LNO framework. I forget exactly what the LNO stands for, but leverage something something. And we'll link to it in the show notes that gives you some advice on how to prioritize your time based on the stuff.

**中文翻译:**
有一个框架我非常喜欢，叫 LNO 框架。我忘了 LNO 具体代表什么了，大概是杠杆（Leverage）之类的。我们会在节目介绍中附上链接，它提供了一些关于如何根据事情的性质来分配时间的建议。

---

### (00:27:38) Kevin Yien

**English:**
Totally.

**中文翻译:**
完全同意。

---

### (00:27:38) Lenny Rachitsky

**English:**
Good idea. Thank you. Thank you for making me feel better.
(00:27:50):
Okay. So I guess in the case of pushing back to create space, this was just you as a product leader recognizing, "This is really important to get right. I will convince people we need to make more time for that."

**中文翻译:**
好主意。谢谢，谢谢你让我感觉好受点。
所以我猜在推迟进度以创造空间的情况下，这只是你作为产品领导者意识到：“把这件事做对非常重要，我要说服大家我们需要为此腾出更多时间。”

---

### (00:28:41) Kevin Yien

**English:**
I don't want to make it seem like it was me against everyone because that was definitely not the case. I think the starting engineers and designers on that team really cared about the quality of what they built too. That's a pretty structural DNA for a team as well. If you don't start with that, and as a comparison, you have a team that really prides themselves on shipping fast and meeting deadlines really prescriptively, you might end up in a different world or your role as a PM might be a little bit more challenging if you want to push on this stuff. So I do think you have to take into account what is the DNA of the team. And then can you exploit that? Which I was able to do. Or do you actually have some change management to put into effect if you believe that it's worthwhile?

**中文翻译:**
我不想表现得好像是我一个人在对抗所有人，因为事实绝对不是那样。我认为那个团队最初的工程师和设计师也非常在意他们所构建的东西的质量。这也是一个团队非常结构化的 DNA。如果你不是从这种 DNA 开始，相比之下，如果你的团队以快速交付和严格遵守截止日期为荣，你可能会处于一个完全不同的世界，或者如果你想推行这些东西，你作为 PM 的角色会更具挑战性。所以我确实认为你必须考虑团队的 DNA 是什么。然后，你能利用这一点吗？我当时做到了。或者，如果你认为值得，你是否真的需要实施一些变革管理？

---

### (00:28:41) Lenny Rachitsky

**English:**
Let's go back to the perimeter, drawing the perimeter concept to make that a little more real for people. So your advice here is the role of a PM, part of your main job, especially when it comes to engineers and design is to draw the perimeter for the team. Can you make that a little more real? What's an example of that maybe from something you worked on? What does that look like?

**中文翻译:**
让我们回到“周界”这个概念，把它讲得更具体一点。所以你的建议是，PM 的角色，尤其是面对工程师和设计团队时，主要工作之一就是为团队划定周界。你能举个具体的例子吗？比如你做过的某个项目？那看起来是什么样的？

---

### (00:28:58) Kevin Yien

**English:**
Totally. The best word to describe the perimeter is just constraints. At the end of the day, you should be adding as many constraints as reasonable in order to let engineers and designers come up with the most creative solutions for whatever you're trying to do.
(00:29:15):
And so again, if we just stay focused on this point of sale example, one constraint would be, "Who the hell are we serving? Are we trying to go after sit-down restaurants that are serving five different courses and have a 200 item wine list? Or are we trying to serve the taco truck?" Those will lead to very different spaces. And if you leave both on the table, the lack of that constraint makes designing a good solution that much harder, that there instances where you actually can't apply that many constraints. But I bet that if you push on enough different axes, you eventually scope it down to a point where it feels really good for the team. It's just about how do you remove decisions, right? Because this I think is maybe a trite phrase, but the best decision is no decision. If you don't even have to think about the decision, the team is that much more effective.

**中文翻译:**
当然可以。描述“周界”最好的词就是“约束”（constraints）。归根结底，你应该在合理的范围内增加尽可能多的约束，以便让工程师和设计师针对你的目标提出最具创意的解决方案。
再次以收银系统（POS）为例，一个约束条件可以是：“我们到底在服务谁？我们是针对提供五道菜、有 200 种酒单的正餐餐厅，还是针对路边的塔可餐车？”这两个方向会导向完全不同的空间。如果你把两个都摆在桌面上，缺乏约束会使设计好的解决方案变得异常困难。虽然有些情况下你确实无法应用那么多约束，但我敢打赌，如果你在足够多的维度上发力，你最终能把范围缩小到一个让团队感觉非常舒服的程度。这本质上是关于如何减少决策，对吧？因为虽然这听起来像句陈词滥调，但“最好的决策就是不需要决策”。如果你甚至不需要考虑某个决策，团队的效率就会大大提高。

---

### (00:30:04) Lenny Rachitsky

**English:**
So yo give people a few maybe even pointers of, "I need to create more constraints maybe for my team to help them go crazy, but within this box that we all agree on," so you mentioned make sure the user's clear of who you're designing for. Is there anything else, just thinking about maybe the PRD someone's trying to write to help create this constraint? What other maybe bullet points, sections would you imagine or do you find useful to add?

**中文翻译:**
所以，为了给人们一些指引，比如“我需要为我的团队创造更多约束，让他们在大家达成共识的‘盒子’里尽情发挥”，你提到了要明确设计对象是谁。还有别的吗？比如在写 PRD 时，为了帮助创造这种约束，你觉得还有哪些要点或章节是有用的？

---

### (00:30:25) Kevin Yien

**English:**
So beyond customer segment/like-what-their-specific-role is, I think another one would be, we can loosely call it, jobs to be done, even though I know that's becoming an increasingly loaded term.

**中文翻译:**
除了客户细分或他们的具体角色之外，我认为另一个可以松散地称为“待办任务”（Jobs to be Done），尽管我知道这个词现在的含义越来越复杂了。

---

### (00:30:35) Lenny Rachitsky

**English:**
Yeah, it's great.

**中文翻译:**
是的，这个概念很棒。

---

### (00:30:36) Kevin Yien

**English:**
But what's the thing they're trying to do and how many different pathways are you willing to entertain around it? That's another one that I would think about. Depending on what you're building, there's availability. So do you care about desktop web, mobile web, native mobile, et cetera? And maybe another one to think through just as an example would be, this is probably getting closer to what a lot of people think about in terms of principles, but what are the things that you want to be known for when you ship a product? One example there might be speed. And so if you say speed is more important than consistency of data, that's a huge tradeoff and constraint that you can give the team." Oh my god, if an engineer hears I don't need real time consistency of data, I can do so much cool stuff and easily accomplish that speed thing." And so that's just a very technical example maybe.

**中文翻译:**
他们想做的事情是什么，以及你愿意围绕它尝试多少种不同的路径？这是我会考虑的另一个点。根据你构建的产品，还有“可用性”：你是在意桌面网页、移动网页，还是原生移动应用？另一个例子可能更接近大家所说的“原则”：当你发布产品时，你希望它以什么著称？比如“速度”。如果你说速度比数据一致性更重要，这就是一个巨大的权衡和约束。工程师听到“我不需要实时数据一致性”时，会想：“天哪，我可以做这么多酷炫的事情，轻而易举地实现速度目标。”这可能只是一个非常技术性的例子。

---

### (00:31:35) Lenny Rachitsky

**English:**
Awesome. Okay, I'm glad I followed up on that. There's a couple more things you mentioned that I want to come back to real quick. The first is this tuning fork idea. I completely agree, this point you made, that the best way to get feedback from your team is to take a first pass at it, and here's a rough quick draft. I find with design, especially if you design something ugly, designers are often like, "Let me make that better. We can't stand this thing." Is there anything else you want to add there? Just this idea of tuning fork as a feedback strategy.

**中文翻译:**
太棒了。很高兴我追问了这个问题。你提到的还有几件事我想快速回顾一下。首先是“调音叉”的想法。我完全同意你说的，获取团队反馈最好的方式是自己先尝试一下，拿出一个粗略的草稿。我发现对于设计，尤其是如果你设计的东西很丑，设计师通常会说：“让我把它变好点，我们受不了这玩意儿。”关于“调音叉”作为反馈策略，你还有什么想补充的吗？

---

### (00:31:55) Kevin Yien

**English:**
Okay, there's two areas we can go deeper on here. One is in how you get the feedback. So this is definitely a Square-ism, I think it was probably adopted from Amazon, which is around the silent read of documents. When you are all so busy and someone's like, "I wrote a doc," you send it into the Slack ecosystem and everyone goes, "Please give feedback." You have so much going on... You'll be lucky to maybe get a response. Maybe there's one or two people that chime in.
(00:32:35):
And so even though we hate meetings and we love asynchronous, there is a lot of value to saying, "I need 20 minutes of focused time to interrogate something that I've done. We're not going to talk. I'm literally going to force us into a room or Zoom. You're going to read this doc, I'm going to watch you comment on it in real time. I'm going to respond to your comments in real time. And at the end of this thing I'm going to have enough really good input that I can do a huge rub on this thing and get to the next phase."

**中文翻译:**
好的，这里有两个可以深入探讨的领域。一个是获取反馈的方式。这绝对是 Square 的风格，我想可能是借鉴自亚马逊，即“静默阅读文档”。当大家都忙得不可开交，有人说“我写了个文档”并把它发到 Slack 里说“请给点反馈”时，你手头有那么多事……能得到一个回复就算走运了，可能只有一两个人会搭理。
所以，尽管我们讨厌开会，喜欢异步沟通，但这种做法非常有价值：“我需要 20 分钟的专注时间来审视我做的一项工作。我们不说话，我直接把大家拉进会议室或 Zoom。你们读文档，我看着你们实时评论。我会实时回复你们的评论。结束时，我就有了足够好的输入，可以对这个东西进行大改，进入下一阶段。”

---

### (00:33:08) Lenny Rachitsky

**English:**
I love that. So it's basically instead of, "Hey, I'm sending you this doc to go review, give me feedback," it's, "I'm going to schedule a meeting, and the meeting is for you to spend time reviewing this doc and giving me feedback and then maybe we could talk about it."

**中文翻译:**
我喜欢这个。所以基本上不是说“嘿，我发给你这个文档去审阅，给我反馈”，而是“我要安排一个会议，会议的内容就是让你花时间审阅这个文档并给我反馈，然后我们也许可以讨论一下”。

---

### (00:33:19) Kevin Yien

**English:**
Yep. And I think a lot of people are going to hate hearing that because like, "Oh my god, I have so many meetings already. Why do I want another meeting that isn't even a meeting?" But that's the best kind then, because it's actual work getting done, right? And maybe you carve out two minutes at the end for one really immediate discussion topic or something. But I don't think we give enough space in any type of meeting for people to actually think. And when you are just staring at a doc with your camera off and the only expectation is to engage with that thing, thoughts are a little bit better and crisper.

**中文翻译:**
没错。我想很多人听到这个会很反感，因为他们会想：“天哪，我已经有这么多会了，为什么还要参加一个甚至算不上会议的会议？”但那其实是最好的一种会，因为那是真正在干活，对吧？也许你可以在最后留出两分钟讨论一个非常紧急的话题。我认为在任何类型的会议中，我们都没有给人们留出足够的思考空间。当你关掉摄像头盯着文档，唯一的任务就是处理它时，你的想法会更清晰、更敏锐。

---

### (00:33:55) Lenny Rachitsky

**English:**
And I think with this idea, if someone says, "I want a meeting where you just sit and review this doc," you could always say, "Let me just review it asynchronously. I'll give you feedback, I promise. Give me 24 hours." Right? It's not like they have to come to this meeting.

**中文翻译:**
而且我觉得，如果有人说“我想开个会让你坐下来审阅文档”，你总是可以回答：“让我异步审阅吧，我保证给你反馈，给我 24 小时。”对吧？并不是说他们非得参加这个会。

---

### (00:34:07) Kevin Yien

**English:**
Although I would urge you to make them come to the meeting.

**中文翻译:**
尽管如此，我还是会敦促你让他们来参加会议。

---

### (00:34:10) Lenny Rachitsky

**English:**
Okay, say more there, because you find that that's a lot more effective.

**中文翻译:**
好，多说两句，因为你发现那样有效得多。

---

### (00:34:14) Kevin Yien

**English:**
I think there's two sneaky things hiding behind that. One is the, "Yeah, I'll get to this in the next 24 hours." Maybe they don't. Maybe you've really trust that person and they're the exception. But beyond that, there is something else to the real time interaction that can happen when you're commenting and responding on a dock at the same time. I think this is the part that often gets lost, which is the latency between a comments or question and a quick follow-up from the author just pushes that cycle speed really long in a way that doesn't need to be. And so when people are trying to find how do you move faster, this actually is one of those very good examples of moving slower to move faster.

**中文翻译:**
我认为这背后隐藏着两件微妙的事情。一是那种“行，我会在接下来的 24 小时内处理”的承诺，也许他们根本不会做。除非你非常信任那个人，而他们又是例外。但除此之外，当你们同时在文档上评论和回复时，那种实时互动是有特殊价值的。我认为这是经常被忽略的部分：评论或问题与作者快速跟进之间的延迟，会不必要地拉长迭代周期。所以当人们在寻找如何跑得更快时，这实际上是一个“以慢为快”的绝佳例子。

---

### (00:34:57) Lenny Rachitsky

**English:**
It reminds me Claire Vo, I think it was her phrase of moving one clock speed faster, and just like that's the way you speed up a company is try to move one clock speed faster, which in this case is just reduce the time between feedback and iteration. I love it.
(00:35:13):
Okay, I want to shift to talking about a few very tactical things that you've found really helpful in your PM career and something you recommend to other product teams. The first is something you call a decision log. You think every PM should keep a decision log. Talk about what that is and why that's powerful.

**中文翻译:**
这让我想起 Claire Vo 的一句话，大意是“提高一个时钟频率”。这就是加速一家公司的方式：尝试提高一个时钟频率。在这个例子中，就是缩短反馈和迭代之间的时间。我喜欢这个观点。
好，我想转而讨论一些你在 PM 职业生涯中发现非常有用的实操技巧，以及你向其他产品团队推荐的东西。第一个是你称之为“决策日志”的东西。你认为每个 PM 都应该记录决策日志。谈谈那是什么，以及为什么它很有力量。

---

### (00:35:32) Kevin Yien

**English:**
I will say there's two different decision logs we could talk about. We'll focus on the former though. The latter is just as you're making decisions within your job, you should document those within a PRD. Make sure everyone knows. It's just a silly, very small thing, but I think every PM should do it.
(00:35:48):
The other decision log though that I think is quite critical is if we zoom out for a second, every person has something that they can do to slightly increment in their craft. Sprinters have certain exercises that they do. There's something beautiful about pianists and piano scales where it doesn't matter if you are just learning the piano or you are a 30-year veteran, you're still doing your scales, and it's because it lays the foundation for everything else that you need to do.
(00:36:23):
And so we all talk about product sense. It's this super mystical thing that no one knows how to get better at. To me, it's just a fancy way of saying you can make good decisions with insufficient data, and the core of that is decisions. And so PMs need as many reps as possible in making decisions, documenting the rationale behind those decisions, and then crucially seeing the outcome of them. And so the natural followup would be, "Well, I only have to make X decisions in my job. How the hell do I make more of them?" Look around you. There's other teams that are making decisions. What would you do if you were in that position with the information you have? Great, write it down. Say why.
(00:37:06):
There's other companies that are doing crazy things. What are they doing? What would you do if you were responsible for the roadmap? Write it down. A year later, see what they've shipped. You can just do this for anyone. It's free, and no one takes the time to do it, but that's how I think you get better at actually making decisions, is just doing more of them.

**中文翻译:**
我们可以讨论两种不同的决策日志。我们重点讨论前者。后者只是指你在工作中做决策时，应该在 PRD 中记录下来，确保每个人都知道。这只是一件很小、甚至有点傻的事，但我认为每个 PM 都应该做。
但我认为另一种决策日志非常关键。如果我们把视野放大一点，每个人都可以做一些事情来微调自己的技艺。短跑运动员有特定的训练动作。钢琴家练音阶也有一种美感：无论你是刚学琴还是 30 年的老手，你仍然在练音阶，因为它是你所需做的一切的基础。
我们都在谈论“产品感”。这是一个超级神秘的东西，没人知道如何提高。对我来说，它只是“在数据不足的情况下做出正确决策”的一种高级说法，而核心在于“决策”。因此，PM 需要尽可能多地练习做决策，记录决策背后的逻辑，最关键的是观察结果。那么自然而然的问题就是：“我在工作中只需要做 X 个决策，我到底怎么才能做更多决策？”看看你周围。其他团队也在做决策。如果你处在那个位置，利用你掌握的信息，你会怎么做？很好，把它写下来，说明原因。
还有其他公司在做一些疯狂的事情。他们在做什么？如果你负责他们的路线图，你会怎么做？写下来。一年后，看看他们发布了什么。你可以针对任何人做这件事。它是免费的，而且没人花时间去做，但我认为这就是你提高决策能力的方式：多做决策。

---

### (00:37:24) Lenny Rachitsky

**English:**
Hearing you describe this, it feels like, "Obviously yes, why aren't we doing this? How else can we get better if we're not reflecting back on the decisions we've made? And realizing, "Hey, I made a bunch of bad decisions, but I'm always so confident in my decision still, maybe shouldn't be. So I guess first of all, do you actually do this? How often do you do this? And is there an example of you learning something from your own decision log?

**中文翻译:**
听你这么描述，感觉就像是：“显然应该这样做啊，为什么我们没做呢？如果我们不反思自己做过的决策，还能怎么进步呢？”并且意识到：“嘿，我做了一堆错误的决策，但我对自己现在的决策仍然如此自信，也许不该这样。”所以我猜首先，你真的在做这件事吗？你多久做一次？有没有你从自己的决策日志中学到东西的例子？

---

### (00:37:50) Kevin Yien

**English:**
Many. And many of them because it was a wrong decision. But yes, I do keep a decision log. I have a separate sort of practice where it's just a daily log, which is everyone wants the perfect note-taking system. To me, the best note-taking system is inspired by... What is it called? big ass text file, BATF. There's a funny blog post from 2001 on it, but it's just, you write everything that happens to you in a day in a bolded list and it's all in one big note. That way you can command F it, do whatever you want. The way that I keep track of it is I do a little hashtag decision and then write things down just as I think about them. And then I'll have a reminder to comb back through on some cadence.
(00:38:36):
And so I'll first use a positive example, which is a funny one. So if you rewind to, I don't even know what year, but Shopify had just launched Shop app, their consumer application for what started as tracking your order when you bought something from a Shopify customer and then it's evolved into a full-blown Amazon competitor, where you can actually find merchants and buy things through it.
(00:39:03):
When they first launched it though, I was like, "Oh my God, this is so brilliant. They have completely hijacked this specific loop for consumer buying behavior via this very unassuming thing, which is package tracking." And so that morning I was like, "Whatever, I'm going to quickly draw a diagram of this flywheel that I think Amazon owns today. I'm going to show how Shopify is slowly planting their little seed to take over this and how Shop app fits into it." I tweeted out. And then I don't know, that day there must have been 60 Shopify employees that followed me. I was like, "What the hell is this guy talking about?"
(00:39:40):
And so funny enough, fast-forward, I've talked to some of the folks that worked on it and they're like, "Yeah, nailed it. Here's what we were thinking. Here's why." It's no longer secret sauce. But that was a really interesting example of both doing a decision log, putting my rationale down on paper. In this case, broadcasting it out, but then having that be a mechanism for it making its way back to me to actually better understand why did they make the decision versus what I thought, because the reasons were a little bit different, but the outcome was the same. So that's one interesting example.

**中文翻译:**
有很多例子，其中很多是因为决策错了。但是是的，我确实记录决策日志。我还有另一种习惯，就是记录“每日日志”。每个人都想要完美的笔记系统，对我来说，最好的笔记系统灵感来自……叫什么来着？“超大文本文件”（Big Ass Text File, BATF）。2001 年有一篇关于它的有趣博文。它就是把你一天中发生的所有事情写成一个加粗的列表，全部放在一个大笔记里。这样你就可以用 Command+F 搜索，随心所欲。我记录决策的方式是加一个 `#decision` 标签，然后想到什么就写什么。我会设置提醒，定期回头梳理。
我先举一个正面的例子，挺有意思的。回溯到几年前，Shopify 刚推出 Shop app，那是他们的消费者应用，起初只是为了追踪你在 Shopify 商家那里买的东西，后来演变成了亚马逊的强力竞争对手，你可以在上面找商家买东西。
当他们刚推出时，我想：“天哪，这太天才了。他们通过包裹追踪这个非常不起眼的东西，完全劫持了消费者的购买行为闭环。”于是那天早上我想：“管它呢，我要快速画一张飞轮图，我认为亚马逊目前占据着这个飞轮。我要展示 Shopify 是如何慢慢播下种子来接管这个领域的，以及 Shop app 是如何融入其中的。”我发了推特。结果那天大概有 60 个 Shopify 员工关注了我，他们可能在想：“这家伙到底在说什么？”
有趣的是，快进到现在，我和一些参与该项目的人聊过，他们说：“没错，你说对了。这就是我们的想法，原因如下。”这已经不再是商业机密了。但这是一个非常有趣的例子：既记录了决策日志，又把逻辑写在纸上。在这种情况下，我把它公开发布了，这成了一种机制，让信息反馈到我这里，让我真正理解他们为什么做那个决策，以及与我的想法有何不同——原因略有不同，但结果是一样的。这是一个有趣的例子。

---

### (00:40:13) Lenny Rachitsky

**English:**
It's an amazing story. You doing this explains why you've been so successful. I could see how this all connects now. I think for a lot of people, they would want to build this habit. Clearly there's a lot of value here, but they just don't because they got a lot of other things going on or it's just like this new thing they have to start doing. Is there anything that helped you adopt this practice of this daily log/decision log that you think might be helpful to folks to motivate them to give this a shot?

**中文翻译:**
这是一个了不起的故事。你做这些事解释了你为什么如此成功。我现在能看出这一切是如何关联起来的了。我想对很多人来说，他们会想养成这个习惯。显然这很有价值，但他们就是没做，因为有很多其他事要忙，或者这只是他们必须开始做的一件新事。有没有什么东西帮助你养成了记录每日日志/决策日志的习惯，你觉得可以帮助激励大家尝试一下？

---

### (00:40:40) Kevin Yien

**English:**
This is probably just general advice on building any habit, which is start small and just force yourself to do it. And there's that old saying around, how do you start running as a hobby? You don't do it by saying, "I'm going to run a mile every day." You do it by putting your sneakers at the foot of your bed unless you take your shoes off inside, then you put it at the front door, you have your shorts ready to go and you're like, "I commit to putting on my shorts. And if I decide after getting dressed to go run, that I still don't want to go run. Okay, fine." But you build up to that thing.
(00:41:16):
I think decision logs are the lightest weight thing possible. And so you can start super easy by saying, "You know what? Every Sunday morning I'm going to scroll through Twitter, I'm going to check out Hacker News, whatever it is, I'm going to see something interesting and I'm going to make a bet. I'm going to place my decision on this thing." Write it down, and then set a calendar invite in X weeks, X months to see what plays out. And that's all it is, right? 10 minutes once a week, super easy. And then over time you can crank it up. And then eventually you're just constantly writing these decisions down and then it's like feeding its way back into you. It becomes second nature.

**中文翻译:**
这可能只是建立任何习惯的通用建议：从小处着手，强迫自己去做。有一句老话：你如何开始把跑步当成爱好？你不是通过说“我每天要跑一英里”来开始的。你是通过把运动鞋放在床脚来开始的（除非你在室内脱鞋，那就放在门口），准备好短裤，然后对自己说：“我承诺穿上短裤。如果穿好衣服后我还是不想去跑，那也行。”但你要循序渐进。
我认为决策日志是门槛最低的事情。你可以从超级简单的开始：“你知道吗？每个周日早上我会刷刷 Twitter，看看 Hacker News，无论是什么，只要看到有趣的东西，我就打个赌。我会针对这件事做一个决策。”写下来，然后在日历上设置一个 X 周或 X 个月后的提醒，看看结果如何。仅此而已，对吧？每周一次，每次 10 分钟，超级简单。随着时间的推移，你可以增加频率。最终，你会不断地写下这些决策，它们会反哺你，成为你的第二天性。

---

### (00:41:52) Lenny Rachitsky

**English:**
And you're touching on something that there's been a little bit of talk on this podcast and newsletter post about this idea of to get better product sense and product taste and also just decision making this case, one of the best strategies is to simulate other people's decisions and simulate what they're thinking through and predict what they're going to do, which is what you're describing here.

**中文翻译:**
你触及了一些在这个播客和新闻通讯中讨论过的话题：为了获得更好的产品感、产品品味，以及在这个案例中的决策能力，最好的策略之一就是模拟他人的决策，模拟他们的思考过程，并预测他们会做什么，这正是你所描述的。

---

### (00:42:12) Kevin Yien

**English:**
Totally. I do want to apply a pretty severe caveat here though, which is, a decision log is not a replacement for building products. It's a additional complimentary thing that you can be doing on your own. But if you think that you can just sit back in your chair, look out at the market, make a bunch of calls and be like, "Look at how smart I'm getting without actually being hands-on with building a product," you're not actually going to get any better. So I just want to interject that

**中文翻译:**
完全正确。不过我确实想在这里加一个非常严肃的警告：决策日志不能替代构建产品。它只是你可以自己做的一项额外的补充工作。但如果你认为你可以坐在椅子上，观察市场，做出一堆判断，然后想：“看我变得多聪明”，而没有真正亲手去构建产品，那你实际上不会有任何进步。我只是想插一句这个。

---

### (00:42:42) Lenny Rachitsky

**English:**
Amazing caveat, very important. Don't just sit and read Hacker News and think you're going to be become an amazing founder or product leader.
(00:42:49):
This episode is brought to you by Eppo. Eppo is a next generation A/B testing and feature management platform built by alums of Airbnb and Snowflake for modern growth teams. Companies like Twitch, Miro, ClickUp, and DraftKings rely on Eppo to power their experiments.

**中文翻译:**
了不起的警告，非常重要。不要只是坐在那读 Hacker News，就以为自己会成为一名了不起的创始人或产品领导者。
本集节目由 Eppo 赞助。Eppo 是由 Airbnb 和 Snowflake 的校友为现代增长团队打造的下一代 A/B 测试和功能管理平台。Twitch、Miro、ClickUp 和 DraftKings 等公司都依靠 Eppo 来支持他们的实验。

---

### (00:43:05) Lenny Rachitsky

**English:**
Experimentation is increasingly essential for driving growth and for understanding the performance of new features. And Eppo helps you increase experimentation velocity while unlocking rigorous deep analysis in a way that no other commercial tool does. When I was at Airbnb, one of the things that I left most was our experimentation platform, where I could set up experiments easily, troubleshoot issues, and analyze performance all on my own. Eppo does all that and more with advanced statistical methods that can help you shape weeks off experiment time and accessible UI for diving deeper into performance and out of the box reporting that helps you avoid annoying, prolonged and analytics cycles.

**中文翻译:**
实验对于推动增长和了解新功能的表现越来越重要。Eppo 帮助你提高实验速度，同时以其他商业工具无法做到的方式解锁严谨的深度分析。当我在 Airbnb 时，我最怀念的东西之一就是我们的实验平台，在那里我可以轻松地设置实验、排除故障并独立分析表现。Eppo 实现了这一切，甚至更多，它拥有先进的统计方法，可以帮你缩短数周的实验时间，还有易用的 UI 用于深入研究表现，以及开箱即用的报告，帮你避免烦人且漫长的分析周期。

---

### (00:43:42) Lenny Rachitsky

**English:**
Eppo also makes it easy for you to share experiment insights with your team, sparking new ideas for the A/B testing flywheel. Eppo powers experimentation across every use case, including product, growth, machine learning, monetization, and email marketing. Check out Eppo at get eppo.com/lenny and 10X your experiment velocity. That's get eppo.com/lenny.
(00:44:07):
If someone wants to try this idea of a daily log, what is it exactly? Say decision log or daily log, is it just things that happen today and then hashtag, "Here's a decision I made, or here's a decision I think Shopify will make in the future"? Is that the format?

**中文翻译:**
Eppo 还让你能轻松地与团队分享实验洞察，为 A/B 测试飞轮激发新灵感。Eppo 支持各种场景下的实验，包括产品、增长、机器学习、变现和邮件营销。访问 geteppo.com/lenny 了解 Eppo，让你的实验速度提升 10 倍。
如果有人想尝试“每日日志”这个想法，它具体是什么样的？不管是叫决策日志还是每日日志，它是记录今天发生的事，然后加上标签，比如“这是我做的决策”或者“这是我认为 Shopify 未来会做的决策”？是这种格式吗？

---

### (00:44:21) Kevin Yien

**English:**
Yeah, it depends on how far you want to go down productivity and notetaking as to rabbit holes, but let's start basic. This is not what I do, but I think it's the easiest place to start. Spin up a Google doc or a Notion page, just call it daily log and then bullet point out the date of today. And then as you're going through your day, you have a meeting, just type in the meeting name. If there's a takeaway, put it under there. If there's a decision you can make, do hashtag decision. And in this case, say, "Shopify launch Shop app. I think this is their way to take over the fulfillment to buying behavior loop. The reason for that is X, Y, Z." Follow up on this in six months and then set your calendar invite.

**中文翻译:**
是的，这取决于你想在生产力和笔记系统这个“兔子洞”里钻多深，但让我们从基础开始。这不是我现在的做法，但我认为这是最容易开始的方式。打开一个 Google 文档或 Notion 页面，就叫它“每日日志”，然后列出今天的日期。在你度过这一天时，如果你开了个会，就输入会议名称。如果有收获，就写在下面。如果你能做一个决策，就加个 `#decision` 标签。在这个例子中，写上：“Shopify 发布了 Shop app。我认为这是他们接管从履行到购买行为闭环的方式。原因是 X、Y、Z。”设置一个六个月后的日历提醒来跟进这件事。

---

### (00:45:02) Lenny Rachitsky

**English:**
Awesome. So as motivation for listeners to try this sort of thing, just look at the success Kevin has had as in his career and how insightful he has been so far and will continue to be. And this is how these happen. This is how your mind learns to see things in a really unique, interesting way. So I know you're modest and aren't going to take any credit, but I'm just saying this is how you get better, is trying stuff like this.

**中文翻译:**
太棒了。为了激励听众尝试这类事情，看看 Kevin 在职业生涯中取得的成功，以及他到目前为止所展现出的深刻见解。这些见解就是这样产生的。这就是你的大脑学会以独特、有趣的方式观察事物的方式。我知道你很谦虚，不会把功劳归于此，但我只想说，尝试这类事情就是你变强的方式。

---

### (00:45:24) Kevin Yien

**English:**
Footnote, correlation versus causation. It's all put out there.

**中文翻译:**
补充说明一下：相关性不等于因果关系。我只是把这些摆出来。

---

### (00:45:27) Lenny Rachitsky

**English:**
Could be all genes. Could be completely unrelated to anything you've done entire life, I suspect.

**中文翻译:**
也可能全是基因使然。我怀疑这可能和你这辈子做的任何事都完全无关。

---

### (00:45:33) Kevin Yien

**English:**
Could just be me being very lucky, I'll put that out there.

**中文翻译:**
也可能只是我运气非常好，我也得提一下这点。

---

### (00:45:35) Lenny Rachitsky

**English:**
Could also be luck. Okay, so something I wanted to touch on with this decision log idea, and it's a segue to talking about hiring, is I think interviewing is also really good opportunity to try some like this. I feel like people interview lots of people. They think they know what they're looking for. They think they've made all these decisions. They think they have these amazing interview questions that are going to help them see really good signal, but you never actually go back and see, "Was I right? Should we have hired that person? Did this person work out? Was that question asked them at all inform? Was it at all a leading indicator of anything?" And I feel like this is a really good method for improving your interviewing abilities, is like, "Here's the questions asked. Here's what I decided. Here's what I think," and then a year later look back, "Was that actually right?"

**中文翻译:**
也可能是运气。好，关于决策日志的想法，我想提一点，这可以作为谈论招聘的过渡：我认为面试也是尝试这种做法的绝佳机会。我觉得人们面试了很多人，他们以为自己知道在找什么，以为自己做了所有这些决定，以为自己有那些能发现优秀信号的神奇面试题。但你从未真正回头去看：“我是对的吗？我们当初该雇那个人吗？那个人表现如何？那个问题真的提供了信息吗？它真的是某种先行指标吗？”我觉得这是提高面试能力的绝佳方法：“这是问的问题，这是我的决定，这是我的想法”，然后一年后回头看，“那真的是对的吗？”

---

### (00:46:16) Kevin Yien

**English:**
Yeah, totally. I think some of the best companies actually do have a practice around this where they have a 6, 12, 18 month check-in on new hires and they then compare their performance against level hired at and then review against the scorecards. It's a pretty laborious process. So startups aren't probably going to do it in the same amount of rigor, but it shows you so much about the holes in your interviewing process. So I definitely plus one of that one.

**中文翻译:**
是的，完全正确。我认为一些最优秀的公司确实有这方面的实践，他们会对新员工进行 6、12、18 个月的跟进，然后将他们的表现与入职时的职级进行对比，并对照面试评分卡进行复盘。这是一个相当费力的过程。初创公司可能不会做得那么严谨，但它能让你看到面试流程中的许多漏洞。所以我绝对赞同这一点。

---

### (00:46:50) Lenny Rachitsky

**English:**
I love that. Oh my god, that puts all this pressure on your score, which is great. So that's actually a segue talking about hiring. There's a couple more tactics that I've seen you be really good at. So one is just hiring in general. You have a lot of interesting approaches to hiring, including this idea of a unsell email where you try to convince someone not to join your company. Talk about that and why you think that's effective and then anything else along the lines of hiring you've learned.

**中文翻译:**
我喜欢这个。天哪，这给你的评分增加了不少压力，这很好。这实际上是谈论招聘的一个过渡。我看到你还擅长另外几个策略。一个是通用的招聘。你有很多有趣的招聘方法，包括这个“劝退邮件”的想法，即你试图说服某人不要加入你的公司。谈谈那个，为什么你认为它有效，以及你在招聘方面学到的其他东西。

---

### (00:47:11) Kevin Yien

**English:**
I'll say the idea of the unsell email came from a place of failure, which is at Square I had shifted into a position where I had to hire a lot of people really quickly. And through that, as a fairly new hiring manager, you're like, "All right, great. I've been told the goal is to hire fast." Okay, you give me a metric, you're going to go after it. So you do your best to get as many people in the door as possible. When you're talking to your recruiting partner, they're incentivized to increase pass through rates, offer to close rates, all these other things, and so they're like, "Yeah, this person's really good." And you listen. "Yeah, they are pretty good, aren't they?" Even though there's a sneaking suspicion that maybe they're not the right fit, but you move forward anyways.
(00:47:54):
So fast-forward, there's a few folks I bring on, and within six months they come to me and they're like, "This is not at all what I thought I was going to do. This is not the environment I thought I was going to walk into. You didn't warn me about this, that and the other. I feel terrible. How do I prevent this?" And the reason it's bad is not just because they feel surprised, but because then, either one, they decide to leave, two, they're not performing because it's not the right role or environment for them, or three, maybe the company is still good, but that role isn't. And so they immediately try to do internal mobility or something to another team, which then leaves you with the same hole. So all of those bad outcomes. [inaudible 00:48:37] "How do I prevent this?" Well, I just got to front load all the gnarly stuff they're going to find out in their first six months.
(00:48:44):
And so the practice I started developing is you go through the whole interview process. During that period, you're collecting all these little concerns, fears, anxieties that they're not explicitly saying, but they're definitely hinting at. You got to be pretty honest with yourself about which ones are real. But then when you get to offer stage, I send an email with no more than eight bullet points and I say all the terrible things that are probably going to reinforce their fears. I'm pretty candid about, "This is what it's like here." Maybe one example would be, "Hey, I'm a parent and I'm worried about work-life balance." Maybe they don't say that explicitly in the interview process, but you get a feeling for it. And I get that as a parent too.
(00:49:31):
So if I'm at a startup, I'll be really clear and I'll say, "You know what? We are a series A startup. We are pushing really hard at product-market fit. The expectation here is going to be that you're online at 10:00, that you can occasionally hop on a meeting on a Saturday or Sunday." And if you can tell them that upfront and they can read that whole email and still be equally excited to join, you find yourself an A+ hire. But if they read that and they're like," I don't know anymore," it's way better to say, "Great, this is not a good fit. Let's go our separate ways" than have them leave after six months.
(00:50:08):
When I first instituted this, I lost 30% of candidates at offer stage.

**中文翻译:**
我会说，“劝退邮件”的想法源于一次失败。在 Square 时，我转到了一个需要快速招聘大量人员的岗位。作为一个相当年轻的招聘经理，你会想：“好吧，太棒了，我的目标是快速招聘。”既然你给了我一个指标，我就去追求它。所以你会尽力让尽可能多的人入职。当你和招聘伙伴沟通时，他们的动力是提高通过率、录用转化率等，所以他们会说：“是的，这个人真的很棒。”你听了也会觉得：“是啊，他们确实挺棒的，不是吗？”尽管你内心隐约怀疑他们可能不是最合适的人选，但你还是继续推进了。
快进一下，我招了几个人，不到六个月他们就来找我说：“这完全不是我想象中的工作。这不是我想象中的环境。你没提醒过我这个、那个还有其他事。我感觉糟透了。我该如何防止这种情况？”这种情况之所以糟糕，不仅是因为他们感到意外，还因为：第一，他们决定离开；第二，因为角色或环境不匹配，他们表现不佳；第三，也许公司很好，但那个岗位不好，于是他们立即尝试内部转岗，结果你还是留下了那个空缺。所有这些都是坏结果。我当时想：“我该如何防止这种情况？”好吧，我得把他们在前六个月会发现的所有棘手的事情都提前告诉他们。
所以我开始养成一个习惯：在整个面试过程中，收集他们没有明说但肯定有所暗示的所有小顾虑、恐惧和焦虑。你必须对自己诚实，判断哪些是真实的。然后到了发录用信阶段，我会发一封不超过 8 个要点的邮件，列出所有可能会加剧他们恐惧的糟糕事情。我会非常坦率地说：“这里的情况就是这样。”举个例子，如果对方说：“嘿，我是个家长，我担心工作与生活的平衡。”也许他们在面试中没有明说，但你能感觉得到。作为家长，我也理解这一点。
所以如果我在一家初创公司，我会非常明确地说：“听着，我们是一家 A 轮初创公司，我们正在拼命寻找产品与市场的契合点（PMF）。这里的期望是你在晚上 10 点还要在线，偶尔周六或周日也要参加会议。”如果你能提前告诉他们这些，而他们读完整封邮件后依然同样兴奋地想加入，那么你就找到了一个 A+ 级的员工。但如果他们读完后觉得“我不确定了”，那么说“太好了，这不合适，我们各走各的路”要比让他们在六个月后离开好得多。
当我刚开始实行这个方法时，我在录用阶段失去了 30% 的候选人。

---

### (00:50:13) Lenny Rachitsky

**English:**
Oh wow.

**中文翻译:**
噢，哇。

---

### (00:50:13) Kevin Yien

**English:**
Which drove my recruiting partners insane because they look terrible. Their manager is like, "What the hell are you doing? You're losing everyone at the very end." And so they ask, "Can you either not send this thing?" Or, "Can you send it at the very beginning?" And my answer is no, because I don't know what they're afraid of yet. I have to go through the whole process to actually understand the thing that's going to potentially make them say no, and that's really crucial I think.

**中文翻译:**
这让我的招聘伙伴们抓狂了，因为这让他们的数据看起来很糟糕。他们的经理会问：“你到底在搞什么？你在最后关头把人都弄丢了。”于是他们问：“你能不能别发这玩意儿？”或者“你能不能在最开始就发？”我的回答是“不行”，因为我当时还不知道他们害怕什么。我必须走完整个流程，才能真正理解那个可能让他们拒绝录用的点，我认为这非常关键。

---

### (00:50:36) Lenny Rachitsky

**English:**
But once you hear it again, this is such an obviously good idea, clearly not an easy thing to do. In this case where recruiters were upset, is it just get buy-in from folks above, like, "Okay, this sucks for them, but at a macro level, this is good for the business" and they're like, "All right, let's keep doing it"?

**中文翻译:**
但再次听到这个想法，这显然是个好主意，虽然做起来不容易。在这种招聘人员感到不快的情况下，是不是只要获得上级的支持就行，比如“好吧，这对他们来说很难受，但从宏观来看，这对业务是有好处的”，然后他们就会说“好吧，继续做吧”？

---

### (00:50:55) Kevin Yien

**English:**
At Square, at least, when I first started doing it, luckily I had a very good relationship with them. So that's a good starting point. This is maybe going to come across a little bit flippant, but they can't stop you from sending an email technically. So I'm just going to send the email. And if someone really wants to come and say, "This is bad for business," whatever it is, I have very strong reasons for why that's not the case. And now I've done it so many times, at least, that I can point to very clear proof points on why this is the right path.

**中文翻译:**
至少在 Square，当我刚开始这么做时，幸运的是我和他们的关系非常好。这是一个好的起点。接下来的话可能听起来有点轻率，但从技术上讲，他们无法阻止你发邮件。所以我就是要发这封邮件。如果有人真的跑来跟我说“这对业务不利”之类的，我有非常充分的理由反驳。而且现在我已经做了很多次了，至少我可以拿出非常明确的证据来证明为什么这是正确的道路。

---

### (00:51:27) Lenny Rachitsky

**English:**
In theory, the incentives would be aligned where the recruiter success matters. It's based on, did they actually have a good time? Did they stay? Did they have good impact?

**中文翻译:**
理论上，激励机制应该是统一的，招聘人员的成功取决于：新员工是否真的过得愉快？他们留下来了吗？他们产生了好的影响吗？

---

### (00:51:35) Kevin Yien

**English:**
Totally.

**中文翻译:**
完全正确。

---

### (00:51:36) Lenny Rachitsky

**English:**
But since they're not, obviously incentives aren't right.

**中文翻译:**
但既然事实并非如此，显然激励机制出了问题。

---

### (00:51:39) Kevin Yien

**English:**
I think some companies have shifted on that, where recruiters and salespeople are compensated sometimes in similar ways in terms of quota and whatnot. And so they'll hold the recruiter accountable to six, 12 post offer tenure before they say, "Oh yeah, you successfully landed this role." So you can tweak the incentive structure a little bit, but not everyone does that.

**中文翻译:**
我认为有些公司已经在这方面做出了改变，招聘人员和销售人员有时在指标和薪酬方面的考核方式类似。他们会要求招聘人员对录用后 6 到 12 个月的留存期负责，然后才会说：“哦，是的，你成功招到了这个人。”所以你可以微调激励结构，但并不是每个人都这么做。

---

### (00:52:03) Lenny Rachitsky

**English:**
Okay, so the advice here is to end up with better people that end up being successful and happy. Keep track of the things that will probably be painful for them at the company, and then craft an email that shares upfront, "Here's what made be a problem if you join, and I just want to be very upfront about it." I think you actually shared a template of one of these emails in one of your blog posts.

**中文翻译:**
好，所以这里的建议是：为了最终得到更优秀、更成功、更快乐的员工，记录下他们在公司可能会感到痛苦的事情，然后写一封邮件提前告知：“如果你加入，这些可能会成为问题，我只想非常坦率地说明这一点。”我想你确实在某篇博文中分享过这类邮件的模板。

---

### (00:52:25) Kevin Yien

**English:**
Yep, that's right. I have a fairly real one in [inaudible 00:52:30].

**中文翻译:**
是的，没错。我在博文里放了一个相当真实的例子。

---

### (00:52:29) Lenny Rachitsky

**English:**
Is there anything else hiring-wise? I know there's probably infinite things that you've done, but is there anything else you think might be worth sharing of things you've learned to be more successful at hiring awesome people?

**中文翻译:**
在招聘方面还有别的吗？我知道你可能做过无数尝试，但还有什么你认为值得分享的经验，能让人更成功地招到优秀人才吗？

---

### (00:52:39) Kevin Yien

**English:**
One final note I'll make on unsell email is it's not as if you just send the email and then they either say yes or no. Most of the time they will say, "Thank you. I am cool with six of these. This one freaks me out. Can we talk more?" Definitely. And I think this is where hiring managers have an incredible responsibility that sometimes isn't taken as seriously as it should, which is, when you are working with someone to get them to join or to offer, you need to bend to do whatever it takes for them. And so if they're like, "Hey, the only time I can talk is tonight at 11 o'clock after my kids go to bed."
(00:53:18):
"No problem. Here's my phone number, let's hop on. I will walk you through whatever you want to talk about." That sort of has to be the place you get to for really strong hires. So that's just one other thing I'll say.
(00:53:29):
The meta point around that is you need to be really invested in the candidates. This probably does change at a certain scale, like if you're "organization" is hiring a hundred engineers or whatever, you have process around it, you have pipelines, there's a machine at that point, but I do think the direct hiring managers have a responsibility to be really involved in every individual, because there's no one who's directly hiring a hundred people. It's always within a number that I think you can take on.

**中文翻译:**
关于“劝退邮件”，我想说的最后一点是：并不是说你发了邮件，他们要么说“好”要么说“不”。大多数时候他们会说：“谢谢。这其中的六条我没问题，但这一条让我有点担心，我们能再聊聊吗？”当然可以。我认为这就是招聘经理肩负巨大责任的地方，有时这种责任没有得到应有的重视：当你努力争取某人加入或发录用信时，你需要竭尽全力满足他们的需求。如果他们说：“嘿，我唯一能聊的时间是今晚 11 点，等我孩子睡了以后。”
“没问题。这是我的电话，我们聊聊。我会详细解答你想谈的任何事情。”为了招到真正顶尖的人才，你必须做到这种程度。这是我想说的另一点。
这背后的核心观点是：你需要真正投入到候选人身上。这可能会随着规模的扩大而改变，比如如果你的“组织”要招 100 个工程师，你会有流程、有管道，那时候就像一台机器。但我确实认为，直接招聘经理有责任深入参与到每一个个体中，因为没有人会直接亲手招 100 个人。人数总是在你可以应付的范围内。

---

### (00:54:01) Lenny Rachitsky

**English:**
Okay, so this is the final tactic that I heard you're amazing at, which is automating user research. On the surface this sounds amazing. "I'm going to automate my user research. It's going to be amazing. So great." Talk about why you find this really powerful and important. And then how do you actually do this? How do you automate user research? How have you done this on your teams?

**中文翻译:**
好，这是我听说你非常擅长的最后一个策略：自动化用户研究。表面上看这听起来很棒。“我要自动化我的用户研究，这太神奇了，太棒了。”谈谈为什么你觉得这非常强大且重要。以及你具体是怎么做的？如何自动化用户研究？你在团队中是如何实施的？

---

### (00:54:17) Kevin Yien

**English:**
Let's start from why this even matters. I think a lot of folks, going back to what is the point of product management, I think there's a similar overlap with UXR, like user experience research, and people will say, "Well, if they're doing research, what do I need to do? I should just be consuming what they're producing to help with that."
(00:54:39):
I know PM should settle for looking through bent glass in my opinion because whether it's a research report, whether it's something a salesperson is telling you, whether it's market research, don't care, it's been processed by someone, and PMs need direct exposure to raw material. End of story. And so that's where I think you just need to constantly be talking to or interacting with whoever is your customer. That's the foundation.
(00:55:08):
So okay, if we all agree on that, then the question is, "Well, I don't have time. It's so hard. How do I find them? My customer success manager says I can't talk to the client." If you are in a situation where the product manager is literally not allowed to talk to a customer, there is something structurally wrong and that needs to be fixed first. So I am going to ignore that one for now just because that's a whole other rabbit hole, but you need to fix that in order to even get close to the next thing.
(00:55:38):
Okay, now the excuse is going to be, "Well, I don't have time. I don't want to run a program. I don't want to have to query and look up and send out emails every week." There's so many good resources out there right now, and I think that there are... I'll speak mainly from a B2B sense. I think B2C, slightly different story, I don't have as much experience there. But B2B, the two things I will say, one is, there's this thing called userinterviews.com. Shout out to them. They're pretty much user testing but explicitly focused on B2B and you can put in super clear criteria on the type of people you want to talk to. They do the heavy lifting and sourcing it, and then you just review and say, "Yes, yes. No, no," and you can have a steady stream of the exact ICP, you want to go after. ICP is ideal customer profile that you want to go after just coming to you automatically. Amazing.
(00:56:28):
The next one though, it depends on whether or not you have this tooling in place, but the broader theme behind this next category is your sales team is a research team, and if you don't view them that way, you are missing out on half the value. And so there's tools like Gong, which do call recordings, and you can set up filters and alerts for specific terms, phrases, competitors, whatever you want. I don't care what PM you are in the team. You can find the terms that are associated with what you care about the most. Those then get pushed automatically to a Slack channel or otherwise. And then you can set up workflows either via Zappy or something else to say, "Who was the customer? Pull their email, put that into a sequence, drop in my Calendly" and you just have interviews showing up automatically on your calendar. I will say I cannot take credit for this. Shout out to Beth Hills who was a PM that hired at Mutiny. She is the queen of automating customer research and built an amazing system around this.

**中文翻译:**
让我们先从为什么这很重要开始。回到产品管理的意义，我认为它与用户体验研究（UXR）有重叠。人们会说：“既然他们在做研究，我还需要做什么？我只需要吸收他们产出的东西来辅助工作就行了。”
但在我看来，PM 不应该满足于“隔着磨砂玻璃看世界”。因为无论是研究报告、销售人员告诉你的信息，还是市场研究，不管是什么，它们都经过了别人的处理。PM 需要直接接触原始素材。这就是结论。所以，我认为你需要不断地与你的客户交谈或互动。这是基础。
好，如果我们都同意这一点，那么问题就是：“我没时间。这太难了。我怎么找到他们？我的客户成功经理说我不能直接联系客户。”如果你处于一个 PM 真的不被允许与客户交谈的环境中，那说明结构上出了问题，必须先解决这个问题。我暂时先忽略这一点，因为那是另一个话题，但你必须解决它才能谈下一步。
好，现在的借口通常是：“我没时间。我不想运营一个项目。我不想每周都去查询、查找并发送邮件。”现在有很多优秀的资源。我主要从 B2B 的角度来谈，B2C 可能略有不同，我在这方面经验不多。但在 B2B 领域，我要说两点：第一，有一个叫 userinterviews.com 的网站。向他们致敬。他们基本上就是做用户测试，但专门针对 B2B，你可以输入非常明确的标准来筛选你想交谈的人。他们负责繁重的搜寻工作，你只需要审核并说“是”或“否”，你就能获得源源不断的、符合你理想客户画像（ICP）的人选，而且是自动找上门来的。太神奇了。
第二点取决于你是否有相应的工具，但核心主题是：你的销售团队就是一个研究团队。如果你不这么看，你就失去了一半的价值。有一些工具，比如 Gong，它可以录制通话，你可以针对特定的术语、短语、竞争对手等设置过滤器和提醒。无论你是团队中的哪个 PM，你都可以找到与你最关心的事物相关的术语。这些信息会自动推送到 Slack 频道或其他地方。然后你可以通过 Zapier 或其他工具设置工作流：“客户是谁？提取他们的邮箱，放入序列邮件中，附上我的 Calendly 链接。”这样，访谈就会自动出现在你的日历上。我必须声明，这不全是我的功劳。向 Beth Hills 致敬，她是我在 Mutiny 招的一名 PM。她是自动化客户研究的女王，围绕这个建立了一套了不起的系统。

---

### (00:57:28) Lenny Rachitsky

**English:**
So the way it works is you set a term for like, I don't know, POS, point of sale, something in Gong, and if somebody says that or has an issue there, talk about again how that schedules a meeting with you potentially.

**中文翻译:**
所以它的运作方式是：你在 Gong 里设置一个术语，比如 POS（收银系统），如果有人提到这个词或者在那方面有问题，再讲讲它是如何潜在地帮你预约会议的。

---

### (00:57:42) Kevin Yien

**English:**
Yes. So Gong has an integration with Slack. You set up this alert, it posts to Slack the excerpt of the transcript where it was mentioned along with the user or customer name. So in this case, it'll be Lenny's Burger shop. lenny@lennysburgershop.com, and then you can set up a Zapier to take every new Slack post from that and then send using, I don't know, customer.io in email to that person using that field. And then in that template of the email, drop in your Calendly specifically for user research.

**中文翻译:**
是的。Gong 与 Slack 有集成。你设置好提醒，它就会把提到该术语的转录文本片段连同用户名或客户名一起发到 Slack。比如：“Lenny 的汉堡店，lenny@lennysburgershop.com”。然后你可以设置一个 Zapier 任务，抓取该频道的每一条新 Slack 消息，然后通过 customer.io 之类的工具向该邮箱发送邮件。在邮件模板中，放入你专门用于用户研究的 Calendly 链接。

---

### (00:58:21) Lenny Rachitsky

**English:**
Wow, that is genius. I love that. There's another similar tactic that Teresa Torres shared on the podcast in one of the earlier episodes where you have a little popup on your homepage asking people, "Hey, do you want to talk? We'd love to hear feedback on our product. Click here if you want to give us some feedback," and then that schedules Calendly on the PMs.

**中文翻译:**
哇，这真是天才。我喜欢这个。Teresa Torres 在之前的节目中也分享过一个类似的策略：在你的主页上放一个小弹窗问用户：“嘿，想聊聊吗？我们很想听听对产品的反馈。如果你想提供反馈，请点击这里。”然后这就会在 PM 的日历上预约 Calendly。

---

### (00:58:41) Kevin Yien

**English:**
Totally.

**中文翻译:**
完全正确。

---

### (00:58:41) Lenny Rachitsky

**English:**
PM's calendar. So you mentioned Gong, customer.io. There's some tools here. Zapier obviously. Is there anything else you find useful to help automate the sort of stuff?

**中文翻译:**
PM 的日历。你提到了 Gong、customer.io，还有 Zapier。还有其他你觉得对自动化这类事情有用的工具吗？

---

### (00:58:52) Kevin Yien

**English:**
If I take a step back from the automation side or maybe straddle it, depending on the type of business you're in, there's ideally people talking about you somewhere, right? It's either happening on Reddit or Twitter or on some forum or your support forum. There is a community, there's a destination somewhere. And if there isn't, then I don't know, that's too bad. Maybe you don't have product-market fit. If you can take advantage of that, you can usually set up something. And if it's not a Gong or a Zapier, maybe it needs to be just a custom script that you write or you sit down with an engineer to say like, "How do we set up alerting around this thing so that I know when things are happening?"
(00:59:36):
I think you can't use the effort required to do that as an excuse to not be talking to your customers more frequently. Because again, if we go back to a product manager should be trying to convert this potential into kinetic energy, part of that understanding and part of knowing the constraints you can apply is just living in that world as much as possible.
(00:59:59):
The best comparison I can give is, there is a world of difference between reading a report about a lime cook and then standing with a lime cook. You will just pick up on so many ancillary aspects of what their life is like that cannot possibly be communicated in a report. You owe it to yourself as a PM to be exposed to those things all the time.

**中文翻译:**
如果我从自动化的角度退一步，或者说结合来看，取决于你的业务类型，理想情况下总会有人在某个地方谈论你，对吧？可能是在 Reddit、Twitter、某个论坛或者你的支持论坛上。总会有一个社区，一个目的地。如果没有，那可能很遗憾，也许你还没达到产品与市场的契合。如果你能利用这一点，通常可以建立一些机制。如果不是用 Gong 或 Zapier，也许只需要你自己写一个简单的脚本，或者找工程师坐下来聊聊：“我们如何针对这件事设置提醒，以便我知道什么时候发生了什么？”
我认为你不能把做这些事所需的努力当作不去频繁与客户交谈的借口。因为再次回到那个观点：产品经理应该努力将势能转化为动能，而理解这一点以及知道可以应用哪些约束的一部分，就是尽可能多地生活在那个世界里。
我能给出的最好的比喻是：阅读一份关于初级厨师（line cook）的报告，和真正站在一名初级厨师身边，有着天壤之别。你会捕捉到关于他们生活的许多细微方面，而这些是报告根本无法传达的。作为 PM，你有责任让自己时刻接触这些真实的情况。

---

### (01:00:27) Lenny Rachitsky

**English:**
In my experience, every time I talk to a customer, I'm always reminded, "Why have I not been doing this more? How can I not be doing this? It's absurd that I haven't done this," like every time you actually do it. But until you do that, you're like, "No, no, I know what they want. I'm reading all the customer service talent issues, I'm reading their emails, I get it." Until you actually talk to them, you're like, "Oh wow, I had no idea."
(01:00:51):
I love that your advice is like, the tactics you're sharing aren't, "Here's how you get a bunch of feedback." From your users, it's like, "Here's how you actually get to talk to the right users." It's like in the end of the funnel talking to a potential customer. It's not just reading a cool... some feedback that they shared.

**中文翻译:**
根据我的经验，每次我和客户交谈，我总会提醒自己：“为什么我以前没多做这件事？我怎么能不做这件事呢？没做这件事简直太荒谬了。”每次实际去做时都会有这种感觉。但在你真正去做之前，你会想：“不，不，我知道他们想要什么。我在读所有的客服工单，我在读他们的邮件，我懂的。”直到你真正和他们交谈，你才会惊呼：“噢，哇，我完全不知道是这样。”
我喜欢你的建议，你分享的策略不是“如何从用户那里获得一堆反馈”，而是“如何真正接触到正确的用户”。这就像是在漏斗的末端与潜在客户交谈，而不仅仅是阅读他们分享的一些反馈。

---

### (01:01:07) Kevin Yien

**English:**
That's right. I think just like the last point on this one is when you join a new team or start a new role, every PM is budding with energy to do this, "Of course I'm going to talk to my users." But then you reach a point where you go, "No, I know them inside and out. I don't need to talk to them anymore. I can write a PRD in my sleep. And I'm so busy doing both, product improvements, maintenance, annual planning, something else.I can use my intuition from the hundred interviews I've already done. I don't need to do one more interview." And that is a very tempting lie to tell yourself because the world is changing, their lives are changing, and you need to constantly be exposed to those little micro changes in their lives in order to build the product that they'll eventually need.

**中文翻译:**
没错。关于这一点我想说的最后一点是：当你加入一个新团队或开始一个新角色时，每个 PM 都充满活力地想去做这件事，“我当然要和我的用户交谈”。但随后你会达到一个点，你会想：“不，我已经了如指掌了。我不需要再和他们谈了。我闭着眼都能写 PRD。我忙着做产品改进、维护、年度规划等等。我可以利用之前做过的 100 次访谈得出的直觉，我不需要再多做一次访谈了。”这是一个非常诱人的谎言，因为世界在变，他们的生活也在变，你需要不断接触他们生活中的那些微小变化，才能构建出他们最终需要的产品。

---

### (01:02:00) Lenny Rachitsky

**English:**
The best explanation I've heard of this is actually from your new boss, Patrick Collison, boss's boss's boss, I don't know how far away you're from him, where he talks about user research and where it fits in. And the way he described it is, instead of doing user research, talking to customers, informing what to build, it's talking to user, talking to customers informs your mental of what the customer needs and then that informs what to build.

**中文翻译:**
关于这一点，我听过的最好解释实际上来自你的新老板 Patrick Collison（老板的老板的老板，我不知道你离他有多远）。他谈到了用户研究及其定位。他的描述是：与其说做用户研究、与客户交谈是为了决定“造什么”，不如说与用户和客户交谈是为了完善你对“客户需求”的心智模型，然后由这个模型来决定“造什么”。

---

### (01:02:23) Kevin Yien

**English:**
100%.

**中文翻译:**
100% 同意。

---

### (01:02:24) Lenny Rachitsky

**English:**
Beautiful way to think about it.
(01:02:26):
Okay, so I'm going to take us to a couple recurring themes of this podcast, a couple corners of this room that we have. First of all, I want to go to AI corner, so let's walk over there. Hello, AI corner. I'm curious if you've found any interesting uses of AI in your work or in your life.

**中文翻译:**
非常优美的思考方式。
好，现在我要带大家进入本播客的几个固定环节。首先，我们要去“AI 角”，让我们走过去。你好，AI 角。我很想知道你在工作或生活中是否发现了 AI 的一些有趣用途。

---

### (01:02:46) Kevin Yien

**English:**
There's plenty in work. I don't know if any of them are interesting or novel. I feel like everyone's just figuring it out in real time together. So I'll actually take us in a slightly different direction. And this may be isn't directly useful to product managers, but I think it's a really good story.
(01:03:02):
So when Midjourney V1 was released, if we can remember that far back, it was at least I got beta access on a Saturday. And for what's worth, I have three daughters, one of them's seven years old, and so her and I were awake. We were waiting for the other two to wake up and I was like, "Oh, I have this cool new thing. Do you want to play with me?" And she goes, "Of course." So we log in, we create an account and I type in the first prompt, image gets generated, it's like a rainbow or something. And then I ask her, "Do you want to try it?" She goes, "Of course." So she types in unicorn prancing in a field and it generates this hideous looking demented unicorn with two rear ends and a demon flying over it. And I'm appalled at first thinking that she's going to feel really bad about what she got shown, but instead I look over and she's in awe. She is amazed.
(01:04:04):
And then she turns to me and she goes, "Did I draw that?"
(01:04:06):
"Yeah, I guess you did." And the thing that I got hung up on was that she used the word draw. She didn't say, "Oh, I enter a prompt and the LLM produced this thing," or whatever weird terminology that all of us use. It's like, "Did I draw that?" I don't know when it clicked for me, but at some point in time after that I was like, "The concept of these image generation models is the same as a crayon to her. There is no difference in her mind." And that is an insane change that I can't even comprehend. And so for me that's just been I think an experience that I go back to when I think about people asking, "What do you think AI is going to do and what's the next thing? And is it chat or is it something else?" I cannot comprehend what a child who grew up with a crayon of an LLM is going to think is a good product in 20 years. I need to start crying. But goddammit, I have no freaking clue.
(01:05:11):
And so I think I have a cheat code actually as a parent, because I get to see how they evolve and use these tools in real time. But all I can say is we are not even beneath the dust on the surface when it comes to what's going to change.

**中文翻译:**
工作中有很多，但我不知道其中是否有有趣或新颖的。我觉得大家都在实时地一起摸索。所以我想带大家往一个稍微不同的方向走。这可能对产品经理没有直接的用处，但我认为这是一个非常好的故事。
当 Midjourney V1 发布时（如果大家还记得那么久以前的话），我是在一个周六拿到的测试权限。顺便说一下，我有三个女儿，其中一个七岁。当时我和她都醒了，在等另外两个醒来。我说：“噢，我有个酷炫的新玩意儿，你想和我一起玩吗？”她说：“当然想。”于是我们登录，创建了账号，我输入了第一个提示词（prompt），生成了一张图片，好像是个彩虹之类的。然后我问她：“你想试试吗？”她说：“当然。”于是她输入了“在田野里奔跑的独角兽”，结果生成了一个长相丑陋、看起来有点疯狂的独角兽，有两个屁股，上面还飞着一个恶魔。起初我感到很震惊，以为她看到这个会很难过，但相反，我转头看她，她满脸敬畏，非常惊讶。
然后她转向我问：“这是我画的吗？”
“是的，我想是你画的。”让我感触很深的是她用了“画”这个词。她没有说“噢，我输入了一个提示词，大语言模型生成了这个东西”，或者我们所有人都在用的那些古怪术语。她说的是“这是我画的吗？”我不知道什么时候突然想通了，但在那之后的某个时刻我想：“对她来说，这些图像生成模型的概念和蜡笔是一样的。在她的脑海里没有区别。”这是一个我甚至无法理解的疯狂变化。所以对我来说，每当人们问“你认为 AI 会做什么？下一步是什么？是聊天机器人还是别的？”时，我都会想起这段经历。我无法想象一个伴随着“大模型蜡笔”长大的孩子，在 20 年后会认为什么样的产品才是好产品。我简直想哭。但该死的，我真的毫无头绪。
所以我觉得作为家长，我其实有一个“作弊码”，因为我可以实时看到他们如何进化并使用这些工具。但我只能说，谈到即将发生的变革，我们现在的认知甚至还没触及到表面灰尘之下的部分。

---

### (01:05:29) Lenny Rachitsky

**English:**
Wow, that is an amazing story, it gave me tingles. It makes me think a little bit about how we used to code in binary and then assembly and now it's Java, and then I don't know, all the languages, Python. And now it's like AI, LLM generating code and it's the same thing for drawing potentially. It used to be sticks on a cave and then became crayons and pens and iPads and all that stuff. And now it's again LLMs, so that's pretty bonkers. Amazing story. Thanks for sharing that. Useful to PMs and non PMs alike.
(01:06:06):
Okay, I'm going to take you to another recurring corner/segment of the podcast, fail corner. I'm curious if there's a story of failure that you can share of something that didn't go the way you wanted and still had a positive impact on your life or career?

**中文翻译:**
哇，这真是一个了不起的故事，听得我起鸡皮疙瘩。这让我想起我们以前用二进制编程，然后是汇编语言，现在是 Java，还有 Python 等各种语言。现在变成了 AI、大模型生成代码。绘画可能也是一样：以前是山洞里的木棍，然后变成了蜡笔、钢笔、iPad 等等。现在又变成了大模型，这太疯狂了。很棒的故事，谢谢分享。这对 PM 和非 PM 都有用。
好，我要带你进入播客的另一个固定环节：“失败角”。我很想知道你是否能分享一个失败的故事，某些事情没有按你预想的方向发展，但仍然对你的生活或职业生涯产生了积极影响？

---

### (01:06:25) Kevin Yien

**English:**
Well, there's countless stories of failure, but I'll choose the one that I think I've had to reference the most with people and has been to date the most difficult one to really talk about. I'm on the other end of it, and so now it's very easy, but it took several years to get there.
(01:06:44):
So context, I'm [inaudible 01:06:47] my way to PM, I land my first official, by title, PM job at a startup. I made it. I've arrived. I'm officially a product manager. And we go up, we go down, all the things happen. Fast-forward, the company is really struggling and so we go through a series of rolling layoffs and I'm round 4 something. At that point in time, my wife was nine months pregnant with our first child, and so I am freaking out. There is the personal side that I'm worried about, but then there's also my identity that has been completely crushed, because in the moment all I could think was, "I thought I was a product manager. This is evidence I am not," and I couldn't get past that.
(01:07:37):
And so for what it's worth, this is the one post I have on my website that I actually feel really, really proud of. It's called Finding Swagger. I can talk about why it's titled that way, but it's the thing that I really wrote more for myself because it's a good reminder to me every time I fall into this mentality again, because that may have been the first time that I really had the feelings of, "I'm not worth it" or, "I'm not meant to be this person," but it's recurred several times since then over the past decade. And when I read back through my mentality of how I got to the other end of it, it helps even myself sort of get back on the horse.
(01:08:28):
So okay, I get laid off, I'm distraught, I have no purpose, I'm nothing. And it was through a lot of reflection, a lot of conversation with friends and my wife where you eventually need to convince yourself that there is a difference between you not being good at something and a business or company not needing that thing at a particular moment in time, or you being very good at something but not in the way that a company needs.
(01:09:01):
And so I think once I was able to get to that, Square for me was the immediate subsequent role that I took on. And I went into that thing just full steam ahead, I'm going to prove myself. "I know I'm good," because I think I'm good, "and I am going to prove the hell out of that" mainly to myself, but ideally to other people too.
(01:09:24):
I think you shouldn't do things for other people for validation, but the initial success I got to see in launching a product, gaining the trust of my peers, having something that restaurants were texting me about, saying, "I can start my restaurant because of this. I didn't go down during rush hour because of this," that gave me the validation to say, "Okay, I am competent at this thing called product management." And then from there you can continue to build and continue to grow.
(01:09:53):
But I think right now, the market's weird, right? The market's wonky. There's a lot of really good talent that is just getting hit over sideways. I have a lot of friends that are having the same mental conversations around, "Well, I guess I'm just not worth it. I guess I wasn't cut out actually to do this job, do this role, be of this purpose." In some cases, maybe that's true and you can sort of have a career transition or a pivot in your life, but I think it's worthwhile to reflect on what are the things that were in your control that you can now change moving forward? And then what are the things that were truly out of your control that you can now apply to find a better fit? And that's one of the big things that I've been able to, I think, come around to.
(01:10:41):
And it's really hard because early on I think it's very tempting to associate a lot of different things with your identity. You're like, "I'm a startup guy. I'm a PM, I'm a fast whatever, I'm a fast thinker." And when an event happens that pokes at that part of your identity, the rest of it crumbles. And so long story short, I think it's really important for folks to use these moments where it feels bad and feels like a failure to reevaluate what parts are actually part of your identity and which parts are in your control to change in whatever you do next.

**中文翻译:**
失败的故事数不胜数，但我会选择一个我向别人提起次数最多，也是迄今为止最难开口的一个。我现在已经走出来了，所以现在说起来很容易，但当时花了好几年时间。
背景是：我努力转型成了 PM，在一家初创公司拿到了我第一份正式挂着 PM 头衔的工作。我成功了，我入行了，我正式成为了一名产品经理。然后公司经历了起起伏伏。快进一下，公司陷入了困境，开始了一系列滚动裁员，我是第四轮左右被裁的。那时候，我妻子怀着我们的第一个孩子，已经九个月了，所以我整个人都崩溃了。一方面是生活上的担忧，另一方面是我的身份认同被彻底粉碎了。因为在那一刻，我脑子里想的全是：“我以为我是个产品经理，但这证明我不是。”我无法摆脱这种想法。
顺便说一下，这是我个人网站上唯一一篇让我感到非常自豪的文章，题目叫《找回自信》（Finding Swagger）。我可以谈谈为什么起这个名字，但那篇文章更多是写给我自己的，因为每当我再次陷入这种心态时，它都是一个很好的提醒。那可能是我第一次真正产生“我不值得”或“我不适合做这个人”的感觉，但在过去的十年里，这种感觉又反复出现过几次。当我回头读我当时是如何走出来的心理历程时，它能帮助我自己重新振作起来。
好，我被裁员了，心烦意乱，没有目标，觉得自己一无是处。通过大量的反思，以及与朋友和妻子的交谈，你最终需要说服自己：你“不擅长某事”与“一家公司在特定时刻不需要某事”之间是有区别的，或者你“非常擅长某事”但“不是以公司需要的方式”之间也是有区别的。
一旦我能想通这一点，Square 就成了我紧接着担任的角色。我全身心地投入到那份工作中，我要证明自己。“我知道我很棒”，因为我觉得我很棒，“我要拼命证明这一点”，主要是向我自己证明，理想情况下也向别人证明。
我认为你不应该为了获得别人的认可而做事，但当我看到发布产品带来的初步成功，赢得同事的信任，看到餐厅给我发短信说“因为这个我可以开餐厅了”、“因为这个我们在高峰期没有宕机”，这些给了我认可，让我可以说：“好吧，我胜任产品经理这份工作。”从那以后，你可以继续构建，继续成长。
但我觉得现在市场很奇怪，对吧？市场很不稳定。有很多非常优秀的人才正遭受打击。我有很多朋友也在进行同样的心理对话：“好吧，我想我就是不值得。我想我其实不适合做这份工作，不适合这个角色，不适合这个目标。”在某些情况下，也许那是真的，你可以进行职业转型或人生转折。但我认为值得反思的是：哪些事情是在你控制之下的，是你以后可以改变的？哪些事情是真正超出你控制的，你可以利用这些信息去寻找更好的匹配？这是我能够想通的大事之一。
这真的很难，因为在早期，人们很容易把很多不同的东西与自己的身份联系起来。你会觉得“我是个初创公司的人”、“我是个 PM”、“我是个思维敏捷的人”。当发生一件触及你身份认同那一部分的事情时，剩下的部分就会崩塌。所以长话短说，我认为对于大家来说，利用这些感觉糟糕、感觉失败的时刻去重新评估哪些部分真正属于你的身份，哪些部分是你可以在下一步工作中控制并改变的，这非常重要。

---

### (01:11:23) Lenny Rachitsky

**English:**
Wow, what an important and great story. As you mentioned, a lot of people are dealing with finding it hard to find a new gig and a bunch of layoffs. I think this is going to help a lot of people. The two categories you shared I think are especially powerful. So the advice here is just separate, "This company just doesn't need someone with my skills right now" from, "I'm not good at these skills." Can you just share those two kind of things that might be true that you may not be recognizing about why they maybe laid you off again?

**中文翻译:**
哇，多么重要且精彩的故事。正如你所提到的，现在很多人都在面临求职困难和裁员潮。我认为这会帮助到很多人。你分享的那两个类别非常有力量。所以这里的建议是：把“这家公司现在不需要具备我这种技能的人”和“我不擅长这些技能”区分开来。你能再分享一下那两件可能真实存在、但你可能没意识到的关于“为什么他们裁掉你”的事情吗？

---

### (01:11:52) Kevin Yien

**English:**
Totally. So one is the business just doesn't have a need for you. They got ahead of their skis and that's their fault. They probably admit that, but that's not up to you. The second one though is my skills and the way that company operates are not compatible. This one I think is really, really important because I've seen so many times where there's been a PM engineer, designer, whatever role, they cannot make it work at company A, and then you see them five years later just killing it in company B and you're like, "Did they change as a person? Did they get super good at what they were bad at before?" Maybe a little bit, but honestly it was just a change in environment. And when you find the right environment in the right role, you just flourish.
(01:12:40):
I think this is actually... Sorry, we'll go back to hiring for just a moment or at least management.

**中文翻译:**
当然。第一种是业务本身对你没有需求。他们扩张过度了（got ahead of their skis），那是他们的错。他们可能也承认这一点，但这不取决于你。第二种是：我的技能和那家公司的运作方式不兼容。我认为这一点非常非常重要，因为我见过太多次，一个 PM、工程师或设计师在 A 公司怎么也做不好，但五年后你看到他们在 B 公司大放异彩。你会想：“他们变了吗？他们把自己以前不擅长的东西练得超级厉害了吗？”也许有一点，但老实说，那只是环境的改变。当你找到正确的环境和正确的角色时，你就会茁壮成长。
我认为这实际上……抱歉，我们再回到招聘或者至少是管理话题一小会儿。

---

### (01:12:44) Lenny Rachitsky

**English:**
Please.

**中文翻译:**
请讲。

---

### (01:12:45) Kevin Yien

**English:**
This is why performance conversations can always feel so difficult because it seems like you're telling someone you are bad, and as the recipient you're like, "I am bad." No one wants to hear that. But the reality is, you are not bad. It is that maybe the way that your environment is working, the machine that you exist as a part of, is not the kind that you thrive in. And so it's within your control to decide, "I'm going to change how I work to fit that environment" or, "I'm going to find a different environment that actually fits the way I work much better." And that's empowering.

**中文翻译:**
这就是为什么绩效谈话总是让人感觉如此艰难，因为看起来你是在告诉某人“你很差”，而作为接收者，你会觉得“我很差”。没人想听这个。但事实是，你并不差。只是可能你所处的环境运作方式、你作为其中一部分的这台“机器”，不是那种能让你大放异彩的类型。所以，你可以决定：“我要改变我的工作方式来适应这个环境”，或者“我要去寻找一个更适合我工作方式的环境”。这是一种赋能。

---

### (01:13:26) Lenny Rachitsky

**English:**
I think that also applies a lot to interviewing. A lot of times you interview, don't get the job, and you exactly feel like, "Oh, I'm just not good enough." But really that company's way of working just may not gel with the way you operate. Like Uber operates very differently from Airbnb, operates very differently from Google. And so it's not that necessarily something you're doing wrong, they just don't think you're fit.
(01:13:46):
And this connects to something. I just had another guest on the podcast. He was a brain science dude, and he talks about how every company has this kind of habitat. What habitat are you creating for your employees to enable them to think differently or to be shut down and not feel like they can be creative or try big things or not? And basically, the way he just kind of to leverage that metaphor, like you may be a palm tree and you're trying to join Antarctica and it's not going to go well.

**中文翻译:**
我认为这也非常适用于面试。很多时候你参加面试没拿到工作，你就会觉得“噢，我就是不够好”。但实际上，那家公司的运作方式可能就是和你不对路。比如 Uber 的运作方式与 Airbnb 非常不同，与 Google 也非常不同。所以不一定是你做错了什么，他们只是觉得你不合适。
这让我想起了一件事。我刚请过另一位嘉宾，他是一位脑科学专家，他谈到每家公司都有自己的“栖息地”。你为员工创造了什么样的栖息地，是让他们能够进行差异化思考，还是让他们感到压抑、觉得无法发挥创意或尝试大事？基本上，借用那个比喻：你可能是一棵棕榈树，但你正试图加入南极洲，那肯定不会有好结果。

---

### (01:14:16) Kevin Yien

**English:**
Totally.

**中文翻译:**
完全正确。

---

### (01:14:17) Lenny Rachitsky

**English:**
Kevin, this has been amazing. Okay, so before we get to very exciting lightning round, is there anything else that you think is important or valuable to share, leave listeners with? And if not, absolutely.

**中文翻译:**
Kevin，这太精彩了。好，在进入激动人心的闪电轮问答之前，你觉得还有什么重要或有价值的东西想分享给听众吗？如果没有，也没关系。

---

### (01:14:30) Kevin Yien

**English:**
I think we'll probably find ourselves on interesting detours to the lightning round, so let's roll in.

**中文翻译:**
我想我们在闪电轮问答中可能会聊到一些有趣的题外话，所以让我们开始吧。

---

### (01:14:35) Lenny Rachitsky

**English:**
Kevin, with that, we've reached our very exciting lightning round. Are you ready?

**中文翻译:**
Kevin，就这样，我们进入了非常激动人心的闪电轮问答。准备好了吗？

---

### (01:14:39) Kevin Yien

**English:**
Hell, yeah. Let's do it.

**中文翻译:**
当然，来吧。

---

### (01:14:40) Lenny Rachitsky

**English:**
Let's do it. Question one, what are two or three books that you've recommended most to other people?

**中文翻译:**
开始。第一个问题：你向别人推荐最多的两三本书是什么？

---

### (01:14:46) Kevin Yien

**English:**
I'll start by saying the type of book by volume that I read and get the most joy from are autobiographies and memoirs. It is just the ultimate cheat code to spend time with people that you respect, are interested by, or want to learn from.
(01:15:05):
Could you imagine what it would take in real life to sit down with Albert Einstein for 50 hours and just have him talk to you about his life? Impossible. But you can read and pretty much get the same thing.
(01:15:21):
So anyways, strong requirement or a strong suggestion, go read autobiographies and memoirs of people that you respect, mostly for their mental model and way to approach thinking, less about specific things. But the one book that I read without fail every year has a very misleading title. It's called The Courage to Be Disliked. I think it's been mentioned previously on the podcast, but it covers... It's a very Socratic method style, so it's about a philosopher and a young person, and it tries to teach you the ways of Adlerian psychology, which is sort of counter to Jungian theory.
(01:15:56):
The reason I really like it is because it makes me uncomfortable. So the whole premise, in my opinion, behind the book and other in psychology is focus on what you control. That's the one line. Don't worry about everything else. Don't worry about what other people think. Don't worry about what other people do. You cannot control those. You focus on yourself and you focus on the actions you can take. And be the person that you think will attract other people, that you want to be around.
(01:16:29):
There's some really pointed notes in there that I'm like, "Ha-ha-ha-ha. I don't fully agree with that one," but it always pushes me to question something about what I believe. And so in every physical copy of a book I have, I write the date that I started reading it again. The front inside cover of this book, I think it's been seven or eight years at this point that I've read it every single year.

**中文翻译:**
我先说一下，我读得最多、获得快乐最多的书是自传和回忆录。这简直是与你尊敬、感兴趣或想学习的人共度时光的终极“作弊码”。
你能想象在现实生活中，和阿尔伯特·爱因斯坦坐在一起 50 个小时，听他讲述他的一生需要付出什么吗？这不可能。但你可以通过阅读获得几乎同样的体验。
所以，我强烈建议去读你尊敬的人的自传和回忆录，主要是学习他们的心智模型和思考方式，而不是具体的事情。但我每年必读的一本书，书名很有误导性，叫《被讨厌的勇气》。我想这个播客之前提到过。它采用苏格拉底式的对话风格，讲述了一位哲学家和一个年轻人的对话，试图教你阿德勒心理学，这在某种程度上与荣格理论相反。
我之所以非常喜欢它，是因为它让我感到不舒服。在我看来，这本书和阿德勒心理学的核心前提是：专注于你能控制的事情。就这一句话。不要担心其他任何事情。不要担心别人怎么想，不要担心别人怎么做。你无法控制那些。你专注于你自己，专注于你可以采取的行动。做一个你认为会吸引你想结交的人的人。
书中有些观点非常犀利，我会想：“哈哈，我并不完全同意这一点”，但它总是促使我质疑自己所相信的东西。在我拥有的每一本纸质书中，我都会写下我再次开始阅读的日期。这本书的扉页上，我想我已经连续七八年每年都读一遍了。

---

### (01:16:55) Lenny Rachitsky

**English:**
Wow. It's like a decision logging in another context almost.

**中文翻译:**
哇。这几乎是另一种语境下的“决策记录”。

---

### (01:16:59) Kevin Yien

**English:**
Yeah, a little bit. I would say the other book I was going to mention is The Paper Menagerie. This actually shout out to Sean Rose for... I've never met him, but I really appreciate Sean. He was one of the early, if not, first PMs of Slack, and he used to be really loud on Twitter in a very good way, and I think I learned a ton from stuff that he would post. But one of the things that he posted was this book. It is just the most beautiful collection of essays that span sci-fi and fantasy. And so if you're into that kind of stuff, if you like exhalation, then Paper Menagerie is even better.

**中文翻译:**
是的，有一点。我想提到的另一本书是《纸动物园》（The Paper Menagerie）。这要感谢 Sean Rose……我从未见过他，但我非常欣赏他。他是 Slack 早期（如果不是第一位的话）的 PM 之一，他以前在 Twitter 上非常活跃，分享的东西很棒，我从他发的帖子里学到了很多。他推荐过这本书。这是一部非常优美的短篇小说集，跨越了科幻和奇幻。如果你喜欢这类东西，如果你喜欢《呼吸》（Exhalation），那么《纸动物园》甚至更棒。

---

### (01:17:39) Lenny Rachitsky

**English:**
Oh, shit. Guess I got to add this book to my list. I do love exhalation.

**中文翻译:**
噢，天。看来我得把这本书加进清单了。我确实很喜欢《呼吸》。

---

### (01:17:43) Kevin Yien

**English:**
There you go.

**中文翻译:**
这就对了。

---

### (01:17:45) Lenny Rachitsky

**English:**
Oh, man, this job is tough. I get to learn all these amazing books and then I got to read them, but I don't have time. Hard.
(01:17:51):
Speaking of more time, next question. Do you have any favorite recent movies or TV shows that you really enjoyed?

**中文翻译:**
噢，伙计，这份工作真不容易。我了解到了所有这些了不起的书，然后我得去读它们，但我没时间。太难了。
说到时间，下一个问题：你最近有什么非常喜欢的电影或电视剧吗？

---

### (01:17:57) Kevin Yien

**English:**
There's less time for either these days. I will say not novel, the Bear holds a very special place in my heart right now, both because I worked in restaurants and I got to build for them. And so seeing the details that they do actually gives me a lot of anxiety, but I really appreciate the craft they put into it.
(01:18:16):
The other show, actually, I think this is the first time, Physical 100. So this is a Netflix show. It's a Korean show about a hundred different bodybuilders, athletes, what have you, on who has the optimum physique or whatever. I don't really care about that part. The two things I love about the show are, one, it's ridiculous what people are capable of. You see what they can physically do and you're like, "Oh my God, that's amazing what they can put their minds to." The other part though, and this is maybe a trend of Korean shows that I've noticed, is the amount of respect they have in this competition is bar none. You have this guy who is historically famous, was the top champion in judo or something, and you have all these other athletes that are 15, 20 years younger, and they're bowing and just humble to compete against the guy. I kind of wish that more American Joes had that level of respect as opposed to just trying to find the most conflict. There's something that I really like about that.

**中文翻译:**
最近看这些的时间也少了。我要说一个不怎么新鲜的，《大熊餐厅》（The Bear）在我心中占据着非常特殊的位置，既因为我曾在餐厅工作过，也因为我为他们开发过产品。看到剧中的那些细节实际上让我感到很焦虑，但我非常欣赏他们投入其中的匠心。
另一部剧，我想这可能是第一次有人提到，《体能之巅：百人大挑战》（Physical 100）。这是 Netflix 的一部韩国真人秀，关于 100 名不同的健美运动员、运动员等，看谁拥有最完美的体魄。我并不怎么关心那部分。我喜欢这部剧的两点是：第一，人类的潜能简直不可思议。你看到他们身体能做到的事情，会惊叹：“我的天，当他们下定决心时，能做到的事情太惊人了。”另一点是（这可能是我注意到的韩国节目的一个趋势），他们在竞争中表现出的尊重是无与伦比的。比如有一个名声显赫的柔道冠军，其他比他年轻 15、20 岁的运动员都会向他鞠躬，能和他同场竞技感到非常谦卑。我希望更多的美国节目也能有这种程度的尊重，而不是仅仅试图制造冲突。我非常喜欢这一点。

---

### (01:19:25) Lenny Rachitsky

**English:**
That's beautiful. I've started that show, but I haven't continued it, so I'm going to revisit it.

**中文翻译:**
太棒了。我开始看那部剧了，但没看完，我会重新去看的。

---

### (01:19:30) Kevin Yien

**English:**
Cool.

**中文翻译:**
酷。

---

### (01:19:30) Lenny Rachitsky

**English:**
Do you have a favorite product that you've recently discovered that you really like?

**中文翻译:**
你最近有没有发现什么非常喜欢的、心头好的产品？

---

### (01:19:34) Kevin Yien

**English:**
We got a really old 2002 Jeep to work on with my daughters, just like a true junker. And as a result of that, we're repairing it. We're taking off the rust, replacing parts, and so there's these little magnetic trays that you can hold screws and nails and whatnot, so they don't go flying and rolling around everywhere. It's stupidly useful when you're working on a car. And the girls love it because they can use it for other things like collecting hair clips or whatever else. So magnetic trays, shout out.
(01:20:06):
And then selfishly, I will say my buddy Arjun Mahanti has an app called Circuit. If you search the app store for Circuit, like C-I-R-C-U-I-T, HIIT timer, it's such a delightful little app that lets you track Tabata sex or whatever else to just get a little workout in.

**中文翻译:**
我和女儿们弄了一辆 2002 年的老吉普车来折腾，简直就是一辆破烂。我们在修理它，除锈、更换零件。有一种小型的磁性托盘，可以吸住螺丝、钉子之类的东西，这样它们就不会到处乱飞乱滚。修车的时候这玩意儿简直好用到爆。女儿们也很喜欢，因为她们可以用它来收集发夹之类的。所以，向磁性托盘致敬。
然后私心地推荐一下，我哥们儿 Arjun Mahanti 开发了一个叫 Circuit 的 App。如果你在应用商店搜索 Circuit（C-I-R-C-U-I-T），它是一个 HIIT 计时器，非常精致的小应用，可以帮你追踪 Tabata 训练之类的，方便随时锻炼一下。

---

### (01:20:24) Lenny Rachitsky

**English:**
Super cool. Magnetic tray is not boring at all. That is extremely cool and it has a really cool story too. Do you have a favorite life motto that you often come back to and find useful to share with friends and family in work or in life?

**中文翻译:**
超级酷。磁性托盘一点也不无聊，它非常酷，而且背后还有一个很棒的故事。你有没有什么经常想起的人生格言，觉得在工作或生活中分享给亲友很有用？

---

### (01:20:36) Kevin Yien

**English:**
I think we've actually maybe touched on both of these. I'll cheat and I'll pull one from maybe each parent so that in case they see this, they don't feel like I'm favoring one of them.
(01:20:45):
So my mom's side, I think something that she would always repeat to me growing up is everything happens for a reason. I hated that growing up because she only said it when something bad would happen. Something bad happens, she goes, "Everything happens for a reason," and I'm like, "No, it doesn't. Life just sucks." And to no surprise at this point in the conversation, I've now grown to really, really appreciate that piece of advice because what it's actually trying to communicate is, when something happens, good or bad, frankly, don't dwell on it. That's the past. Focus on what you want to do and then just move towards that. And then in most cases, you'll be able to look back in one, five, 10 years and connect the dots in a way where the story makes sense in your mind. And so just having that shift in perspective I think has helped me a lot to not overreact to anything that happens in my life. So that's one side.
(01:21:46):
And then on my dad's side, so the funny origins of this, unsurprising to anyone with Asian parents, I'm a spunky little 7-year-old, I come home with my math test one day. I got 97%. I think that's pretty good. I go show it to my dad with beaming eyes and pride. He sort of stares down his nose at it, looks at me, "Where's my other 3%?"

**中文翻译:**
我想我们可能已经触及过这两个观点了。我耍个赖，从我父母那里各选一个，这样万一他们看到，就不会觉得我偏心。
我妈妈那边，她在我成长过程中总是重复一句话：“凡事发生必有其因”（Everything happens for a reason）。我小时候很讨厌这句话，因为她只有在坏事发生时才说。坏事发生了，她说“凡事发生必有其因”，我会想“才不是呢，生活就是很烂”。但听到现在的对话，你肯定不会感到意外，我现在已经变得非常、非常感激这条建议。因为它真正想传达的是：当事情发生时，坦白说，无论是好是坏，都不要沉溺其中。那是过去。专注于你想做的事，然后朝着那个方向前进。在大多数情况下，你能在 1、5、10 年后回头看，并以一种让故事在脑海中合乎逻辑的方式把这些点连起来。我认为这种视角的转变极大地帮助了我，让我不会对生活中发生的任何事情反应过度。这是其中一方面。
我爸爸那边，这个故事的起源很有趣，对于任何有亚裔父母的人来说都不意外：我当时是个 7 岁的小屁孩，有一天带着数学试卷回家。我得了 97 分，我觉得挺不错的。我满怀自豪、眼睛发光地拿给爸爸看。他低头看了看，又看着我问：“我那另外的 3% 呢？”

---

### (01:22:08) Lenny Rachitsky

**English:**
Oh, my God.

**中文翻译:**
噢，我的天。

---

### (01:22:10) Kevin Yien

**English:**
I'm just distraught and I sulk away. I'm very sad. I study hard. I do the next math test, I get 100% yes. All right, dad's approval, here we come. I come flying back, I put the test in his hands, he stares down his nose at it, looks at me, "Where's my other 3%?" I'm so confused. I'm like, "I got 100 out of 100. I have no clue what you're talking about." He just looks me down the eye and goes, "Who said a hundred is the most you can get?" At that age, I literally had no clue what he was talking about. And he had to reframe it for me in the moment around like, "Well, was there extra credit? Can you just write your own problems to challenge yourself more? Could you have given yourself another test? And maybe the teacher won't give you credit, but you give yourself credit for doing additional work."
(01:23:01):
I think I carry that theme forward where there's this weird transition we all go through from childhood to adulthood where we no longer receive homework, we're responsible for defining the work that we do. And when you do that, if all you do is the minimum of what defined the 100% of what your job requires, you'll never grow. And so it's up to you to actually find what is the additional 3%? There's always three more percent. So that's my dad's lesson.

**中文翻译:**
我当时心烦意乱，垂头丧气地走开了。我很伤心，于是拼命学习。下一次数学考试，我得了 100 分。太棒了，老爸的认可要来了。我飞奔回家，把试卷递到他手里，他低头看了看，又看着我问：“我那另外的 3% 呢？”我彻底懵了，我说：“我得了 100 分啊，满分 100 分。我完全不知道你在说什么。”他直视着我的眼睛说：“谁说 100 分就是你能得到的最高分？”在那个年纪，我真的不知道他在说什么。他当时不得不为我重新解释：“嗯，有没有额外加分题？你能不能自己出题来进一步挑战自己？你能不能给自己再做一套测试？也许老师不会给你分数，但你会因为做了额外的工作而给自己加分。”
我认为我继承了这个主题：我们从童年到成年都会经历一个奇妙的转变，那就是我们不再收到作业，我们要负责定义自己的工作。当你这样做时，如果你只做工作要求的那 100% 的最低限度，你永远不会成长。所以，这取决于你如何找到那额外的 3%？永远都有额外的 3%。这就是我爸爸教给我的。

---

### (01:23:35) Lenny Rachitsky

**English:**
Kevin, you're blowing my mind. There's so many great stories, you're just full of them. And I feel like this lesson also applies really well to product and building product and founding companies.

**中文翻译:**
Kevin，你让我大开眼界。你有这么多精彩的故事，简直信手拈来。我觉得这个教训也非常适用于产品开发、构建产品和创立公司。

---

### (01:23:46) Kevin Yien

**English:**
Totally.

**中文翻译:**
完全正确。

---

### (01:23:46) Lenny Rachitsky

**English:**
Just pushing further than people expect and making it a lot more delightful than the minimum bar.
(01:23:53):
Final question, speaking of things that maybe people don't expect and may not understand is possible, looking at you, nobody would've guessed that you're a competitive eater at some point in your life. As a final question, tell us about this part of your life. What did you eat? How does this work? How far did you get in this path?

**中文翻译:**
就是比人们预期的做得更多，让它比最低标准更令人愉悦。
最后一个问题，说到那些人们可能意想不到、甚至不理解其可能性的事情：看着你，没人会想到你在人生的某个阶段曾是一名大胃王选手。作为最后一个问题，给我们讲讲你那段生活。你都吃些什么？那是怎么运作的？你在那条路上走了多远？

---

### (01:24:12) Kevin Yien

**English:**
It's probably misleading to say that I was a true competitive eater. I wasn't on the circuit with a... I forget his name, but Johnny Chestnut.

**中文翻译:**
说我是真正的职业大胃王选手可能有点误导。我并没有和那个……我忘了他的名字，好像叫 Johnny Chestnut（乔伊·切斯纳特）的人一起参加巡回赛。

---

### (01:24:21) Lenny Rachitsky

**English:**
[inaudible 01:24:21]. Oh yeah, Chestnut

**中文翻译:**
噢是的，切斯纳特。

---

### (01:24:22) Kevin Yien

**English:**
Back in the day, that's like the OG competitive eater on the hotdog circuit, I guess.

**中文翻译:**
在那个年代，他应该是热狗大赛里的元老级大胃王了。

---

### (01:24:25) Lenny Rachitsky

**English:**
Right.

**中文翻译:**
没错。

---

### (01:24:26) Kevin Yien

**English:**
For me it was more eating challenges. And so whenever I would travel, I would find the local eating challenge, whether it was time-based, volume-based, something else, and just try to see what I could push my body to do. I was blessed with a great metabolism, so I never really had to worry too much about anything else. And the origin, the first moment of this was when I was 14, my sister was going to college in Minnesota and there's this steakhouse up there called Manny's, which is where the Vikings Frontline goes to after every game. And they have this ridiculous 97 ounce order house. I don't know how many pounds that is, but it's too much meat for a human to consume.

**中文翻译:**
对我来说，更多的是参加“大胃王挑战”。所以每当我旅行时，我都会寻找当地的挑战项目，无论是限时的、限量的还是其他的，只是想看看我能把身体推向什么极限。我很幸运，新陈代谢很快，所以从不需要太担心别的。这一切的起源是我 14 岁的时候，我姐姐在明尼苏达州上大学，那里有一家叫 Manny's 的牛排馆，那是维京人队（NFL 球队）的前锋们赛后常去的地方。他们有一份离谱的 97 盎司牛排。我不知道那是多少磅，但那肉量多到人类根本无法消耗。

---

### (01:24:26) Lenny Rachitsky

**English:**
97 ounce.

**中文翻译:**
97 盎司。

---

### (01:25:07) Kevin Yien

**English:**
97 ounces, yeah. And so I sit down, I order it thinking, "This is going to be great." They put it in front of me, it's a monster. You have to eat in under an hour. And so 45 minutes into it, I'm halfway through and about to die. And the catch is, if you finish it in under an hour, you get it for free. And so my dad again leans in and goes, "You can't afford not to finish this."

**中文翻译:**
是的，97 盎司。我坐下来，点了一份，心想：“这肯定很棒。”当它摆在我面前时，简直是个巨无霸。你必须在一小时内吃完。吃了 45 分钟后，我才吃了一半，感觉快要死掉了。规则是：如果你在一小时内吃完，就免单。于是我爸又凑过来对我说：“你可付不起不吃完它的代价。”

---

### (01:25:39) Kevin Yien

**English:**
And so, "Message received, sir." Hunker down. I plowed the other half in 15 minutes. I then slept for I think three days afterwards. But after that I was like, "Oh my God, if I could do that, what else could I do?" And so, [inaudible 01:25:54] carried for, I don't know, nearly a decade of trying to do these interesting challenges.

**中文翻译:**
于是我心想：“收到，长官。”我埋头苦干，在 15 分钟内扫清了剩下的一半。我想在那之后我睡了整整三天。但从那以后我想：“我的天，如果我能做到那个，我还能做到什么？”于是，这种劲头持续了将近十年，我一直在尝试这些有趣的挑战。

---

### (01:25:58) Lenny Rachitsky

**English:**
Wow. I don't know how that's physically possible, but clearly you did it.
(01:26:02):
Kevin, this has been wonderful. I think there's so many lessons here for people in so many ways, life and work and parenting. Two final questions, where can folks find you online if they want to follow you and learn more from you over time? And how can listeners be useful to you?

**中文翻译:**
哇。我不知道生理上是怎么做到的，但显然你做到了。
Kevin，这太棒了。我认为这里有很多关于生活、工作和育儿的教训。最后两个问题：如果大家想关注你并向你学习，可以在哪里找到你？以及，听众能为你做些什么？

---

### (01:26:17) Kevin Yien

**English:**
I'm on Twitter, just @kevinyien. Technically, I'm on LinkedIn. I don't post over there. I probably should. I hear it's very good. But that's where you can find me. Also, my website. I don't write that often, and I don't have an RSS feed, which has always been on my backlog, and I'm always too lazy to do. But one day I will add it.
(01:26:38):
One quick note, I'll actually make on websites. So on one hand, I love all the different website builders that exist. It's amazing what we've enabled anyone to be able to do. There is something really special about having your corner of the internet that you built sort of hand by hand, line by line. And so my website is, it's a GitHub page. It's hosts on GitHub pages, but it's just raw HTML, CSS, nothing fancy. I get so much joy every year just doing a slight tweak or cleaning of it. And so I really do recommend that for anyone with the curiosity and the desire to buy your domain, even if you're never going to write anything on it, you're never going to share it out, just own a little piece of the internet. It feels good.

**中文翻译:**
我在 Twitter 上，账号是 @kevinyien。严格来说我也在 LinkedIn 上，但我不在那儿发帖。也许我应该发，听说那里很不错。你也可以在我的个人网站上找到我。我不常写东西，也没有 RSS 订阅源，这一直在我的待办清单里，但我总是太懒没去弄。不过总有一天我会加上的。
关于网站我想多说一句：一方面，我喜欢现在各种各样的建站工具，它们让任何人都能建站，这很了不起。但拥有一个你自己亲手一行行代码敲出来的互联网角落，感觉真的很特别。我的网站是一个 GitHub 页面，托管在 GitHub Pages 上，只有原始的 HTML 和 CSS，没什么花哨的东西。每年只是对它进行微调或清理，我都能获得巨大的快乐。所以我真的建议任何有好奇心和欲望的人去买一个自己的域名，即使你永远不在上面写东西，永远不分享出去，只是拥有互联网的一小块领地，感觉也会很好。

---

### (01:27:28) Lenny Rachitsky

**English:**
I love that. I didn't know that about your website. And I could see it now as I go there. It's .html, which you don't see as much anymore.

**中文翻译:**
我喜欢这个。我以前不知道你的网站是这样的。我现在去看确实能看到，它是 .html 结尾的，现在不常见了。

---

### (01:27:35) Kevin Yien

**English:**
Exactly. [inaudible 01:27:37].

**中文翻译:**
没错。

---

### (01:27:36) Lenny Rachitsky

**English:**
And then... Yeah, can listeners be useful to you.

**中文翻译:**
然后……是的，听众能为你做些什么？

---

### (01:27:39) Kevin Yien

**English:**
This is going to sound trite, and it has nothing to do with product necessarily, just be kind. Make for a nicer world, right? Say thank you a little bit more often. Hold the door open a little more often. Wave if you cut someone off in a car. I think there is a temptation and incentive structure to create conflict intention. And in most cases, the world would just benefit from a little bit more kindness.

**中文翻译:**
这听起来可能有点陈词滥调，而且与产品不一定有直接关系：请保持善良。让世界变得更美好一点，对吧？多说几次谢谢，多帮别人扶一下门。如果你在开车时插了别人的队，招手示意一下。我认为现在的环境和激励机制倾向于制造冲突和紧张。而在大多数情况下，世界只需要多一点点善意就会变得更好。

---

### (01:28:06) Lenny Rachitsky

**English:**
What an incredibly beautiful way its ended. Kevin, this was so much fun. I'm so glad we did this. Thank you so much for coming on.

**中文翻译:**
多么优美的结尾。Kevin，这真的很有趣。我很高兴我们做了这次访谈。非常感谢你的到来。

---

### (01:28:13) Kevin Yien

**English:**
Thank you for having me.

**中文翻译:**
谢谢你邀请我。

---

### (01:28:14) Lenny Rachitsky

**English:**
Bye, everyone.
(01:28:16):
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
大家再见。
非常感谢您的收听。如果您觉得本期节目有价值，可以在 Apple Podcasts、Spotify 或您喜欢的播客应用中订阅本节目。此外，请考虑给我们评分或留下评论，因为这能极大地帮助其他听众发现本播客。您可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目再见。