# Kim Scott - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Kim Scott.

---

### [00:00:00] Kim Scott

**English:**
If you say, "Do you have any feedback for me?" You're wasting your breath. The other person's going to say, "Oh no, everything's fine." The question that I like to ask is, "What could I do or stop doing that would make it easier to work with me?" Do not write down my question because if you sound like Kim Scott and not like yourself, then other people are not going to believe you want the answer. It needs to sound authentic to you, and if everybody can write down their question, who they're going to ask it of and then pop it into their calendar right now, this will be one of the most productive podcasts in all of podcast land.

**中文翻译:**
如果你问：“你对我有什么反馈吗？”那你是在白费口舌。对方肯定会说：“噢，没，一切都挺好的。”我喜欢问的问题是：“我做些什么，或者停止做些什么，能让你跟我合作起来更轻松？”但不要直接照抄我的原话，因为如果你听起来像金·斯科特（Kim Scott）而不是你自己，别人就不会相信你是真心想要答案。它必须听起来对你而言是真实的。如果每个人现在都能写下自己的问题、打算问谁，然后立刻把它排进日程表，这将会成为整个播客界最高产的一期节目。

---

### [00:00:33] Lenny

**English:**
Today my guest is Kim Scott. Kim is the author of Radical Candor, which is the single most referenced book on this podcast. The book has sold over 1 million copies, has been translated into twenty-three languages. It was such an honor to have Kim on the podcast. Prior to this book, Kim was a CEO coach at Dropbox, Qualtrics, Twitter and many other tech companies. She was a member of the faculty at Apple University. Before that, she led AdSense, YouTube and DoubleClick teams at Google. Prior to that, Kim managed a pediatric clinic in Kosovo and started a diamond cutting factory in Moscow. She's also working on a new book that you can pre-order now called Radical Respect. In our conversation, we get very practical and very tactical about practicing radical candor. Kim briefly describes the core idea, shares, language and phrases and words you can use to get better at practicing radical candor.

**中文翻译:**
今天的嘉宾是金·斯科特。金是《彻底坦诚》（Radical Candor）一书的作者，这本书是本播客中被引用次数最多的书。该书销量已突破 100 万册，并被翻译成 23 种语言。能邀请到金参加节目是我的荣幸。在写这本书之前，金曾在 Dropbox、Qualtrics、Twitter 等多家科技公司担任 CEO 教练。她曾是苹果大学（Apple University）的教员。在此之前，她在谷歌领导过 AdSense、YouTube 和 DoubleClick 团队。更早之前，金在科索沃管理过一家儿科诊所，并在莫斯科创办了一家钻石切割厂。她目前正在撰写新书《彻底尊重》（Radical Respect），现在已经可以预订。在我们的对话中，我们将非常务实且具战术性地探讨如何实践“彻底坦诚”。金简要描述了核心理念，并分享了你可以用来提升这项能力的语言、短语和词汇。

---

### [00:01:24] Lenny

**English:**
She shares tips for people-pleasers like myself. Also, a lot of very concrete advice for how to get feedback. Also, what to do if your culture is on the ruinous empathy side of the spectrum, or even worse, obnoxious aggression and so much more. I guarantee listening to this episode will make you a better leader and a better employee. With that, I bring you Kim Scott after a short word from our one featured sponsor for this episode.

**中文翻译:**
她为像我这样的“讨好型人格”提供了建议。此外，还有关于如何获取反馈的大量具体建议。同时，她还探讨了如果你的公司文化处于“毁灭性同理心”的一端，或者更糟，处于“令人厌恶的侵略性”一端时该怎么办。我保证，听完这一集会让你成为更好的领导者和员工。在进入正题之前，先听一段我们本期唯一赞助商的简短广告，随后为您带来金·斯科特。

---

### [00:01:50] Lenny (Sponsor Message)

**English:**
You fell in love with building products for a reason, but sometimes the day-to-day reality is a little different than you imagined. Instead of dreaming up big ideas, talking to customers and crafting a strategy, you're drowning in spreadsheets and roadmap updates, and you're spending your days basically putting out fires. A better way is possible. Introducing Jira Product Discovery, the new prioritization and road mapping tool built for product teams by Atlassian.

**中文翻译:**
你爱上打造产品是有原因的，但有时日常现实与你的想象略有不同。你没有在构思伟大的创意、与客户交谈或制定战略，而是淹没在电子表格和路线图更新中，整天都在忙于“救火”。其实有更好的方法。向您介绍 Jira Product Discovery，这是由 Atlassian 为产品团队打造的全新优先级排序和路线图工具。

---

### [00:02:17] Lenny (Sponsor Message)

**English:**
With Jira Product Discovery, you can gather all your product ideas and insights in one place and prioritize confidently, finally replacing those endless spreadsheets. Create and share custom product roadmaps with any stakeholder in seconds. And it's all built on Jira where your engineering team's already working. So true collaboration is finally possible. Great products are built by great teams, not just engineers, sales support, leadership, even Greg from finance. Anyone that you want can contribute ideas, feedback, and insights in Jira Product Discovery for free, no catch. And it's only $10 a month for you. Say goodbye to your spreadsheets and the never-ending alignment efforts. The old way of doing product management is over rediscover what's possible with Jira Product Discovery. Try it for free at atlassian.com/Lenny. That's atlassian.com/Lenny.

**中文翻译:**
通过 Jira Product Discovery，你可以将所有的产品创意和洞察集中在一处，并充满信心地确定优先级，最终取代那些没完没了的电子表格。只需几秒钟即可创建并与任何利益相关者分享定制的产品路线图。而且它完全构建在你的工程团队已经在使用的 Jira 之上，因此真正的协作终于成为可能。伟大的产品是由伟大的团队打造的，不仅是工程师，还包括销售支持、领导层，甚至是财务部的 Greg。你想要的任何人都可以免费在 Jira Product Discovery 中贡献创意、反馈和洞察，没有任何套路。而对你来说，每月只需 10 美元。告别电子表格和永无止境的对齐工作。旧的产品管理方式已经结束，通过 Jira Product Discovery 重新发现无限可能。请访问 atlassian.com/Lenny 免费试用。

---

### [00:03:13] Lenny

**English:**
Kim, thank you so much for being here and welcome to the podcast.

**中文翻译:**
金，非常感谢你能来，欢迎来到本播客。

---

### [00:03:17] Kim Scott

**English:**
Thank you for having me. I'm excited for our conversation.

**中文翻译:**
谢谢你的邀请。我很期待我们的对话。

---

### [00:03:20] Lenny

**English:**
Your book, Radical Candor is the single most recommended book on this podcast. I don't know if you know this podcast well, but at the end of the podcast, I ask every guest, "What are two or three books you recommend most to other people?" And your book has come up the most of any book mentioned on the podcast.

**中文翻译:**
你的书《彻底坦诚》是本播客中被推荐次数最多的书。我不知道你是否了解这个播客，但在每期节目的最后，我都会问每位嘉宾：“你最推荐给别人的两三本书是什么？”而你的书是被提及次数最多的。

---

### [00:03:37] Kim Scott

**English:**
Amazing. Well, tell your listeners I love them and I'm grateful to them.

**中文翻译:**
太棒了。请转告你的听众，我爱他们，也非常感谢他们。

---

### [00:03:45] Lenny

**English:**
Okay, they'll hear this. So I'm really excited to have you on chat about all the things that you teach and your book. For people that have heard the term Radical Candor, have maybe skimmed the book, maybe even read the book a while ago, but don't truly remember or understand the concept. Could you just spend just a few minutes giving a high level overview of the concept of Radical Candor?

**中文翻译:**
好的，他们会听到的。我非常激动能邀请你来聊聊你教授的内容和你的书。对于那些听过“彻底坦诚”这个词，或者可能翻过书，甚至很久以前读过但不太记得或理解这个概念的人，你能不能花几分钟时间，从高层面概述一下“彻底坦诚”的概念？

---

### [00:04:04] Kim Scott

**English:**
Absolutely. Radical Candor is just what happens when you care personally and challenge directly at the same time. And I think it's probably best understood by what it's not because we all fail on one of those two dimensions or both of them multiple times a day. So you can think about it as a two by two framework. On the vertical axis is care personally, the horizontal axis is challenge directly. What happens when we remember to challenge directly, but we forget to show that we care personally. That is what I call obnoxious aggression, and it's really important to distinguish between radical candor and obnoxious aggression. I think one of the mistakes that people often make about, and I've gotten a lot, you write a book about feedback, you're going to get a lot of it, and I've heard a lot of feedback that sometimes teams will be rolling out the idea of Radical Candor and someone will charge into the room and say, "In the spirit of Radical Candor," and then they act like a garden variety jerk.

**中文翻译:**
没问题。“彻底坦诚”就是当你同时做到“个人关心”（Care Personally）和“直接挑战”（Challenge Directly）时所发生的状态。我认为通过了解它“不是什么”来理解它可能是最好的，因为我们每个人每天都会在其中一个维度或两个维度上失败多次。你可以把它想象成一个 2x2 的矩阵框架。纵轴是“个人关心”，横轴是“直接挑战”。当我们记得“直接挑战”却忘了表现出“个人关心”时，会发生什么？那就是我所说的“令人厌恶的侵略性”（Obnoxious Aggression）。区分“彻底坦诚”和“令人厌恶的侵略性”非常重要。人们常犯的一个错误是——我收到了很多反馈，毕竟写了一本关于反馈的书，肯定会收到很多——我听说有些团队在推行“彻底坦诚”时，有人会冲进房间说：“本着彻底坦诚的精神……”，然后表现得像个彻头彻尾的混蛋。

---

### [00:05:00] Kim Scott

**English:**
And that is not the spirit of Radical Candor. That's the spirit of obnoxious aggression. And obnoxious aggression is a big problem. It's a problem because it hurts other people. It's also a problem because it's inefficient. If I'm a jerk to you Lenny, then I'm going to send you into fight or flight mode and then you literally cannot hear what I'm saying, so I'm wasting my breath. But I don't know if this is true for you, but for me, there's a third problem. And the third problem is that when I realize I've acted like a jerk, when I realize I've landed in obnoxious aggression, it's not actually my instinct to go the right way on care personally. Instead, it's my instinct to go the wrong way on challenge directly and to pretend that I agree when I disagree, and then I wind up in the worst place of all, manipulative insincerity.

**中文翻译:**
那根本不是“彻底坦诚”的精神，那是“令人厌恶的侵略性”。这种侵略性是个大问题。首先它会伤害他人；其次它效率低下。如果我对你表现得像个混蛋，莱尼，我会让你进入“战斗或逃跑”模式，然后你根本听不进我在说什么，我就是在白费口舌。而且对我来说还有第三个问题：当我意识到自己表现得像个混蛋，陷入了“令人厌恶的侵略性”时，我的本能反应通常不是转向“个人关心”，而是转向错误的“直接挑战”——假装同意我其实并不同意的事，结果陷入了最糟糕的境地：“虚伪的操纵”（Manipulative Insincerity）。

---

### [00:05:48] Kim Scott

**English:**
And it's kind of fun to tell stories about obnoxious aggression and manipulative insincerity. If you watch The Office or any show about problems at work or problems in any kind of relationship really, you're going to see a lot of episodes about obnoxious aggression and manipulative insincerity. But I think the real rub comes and the fact that these, even though this is what we like to talk about, these two problems are what we like to talk about, these are not the most common problem. By far and away the most common problem occurs when we do remember to show that we care personally because you know what? Most people try to be nice people. So we do remember to show that we care personally, but we're so worried about not hurting someone's feelings or not offending them, that we fail to tell them something they'd be better off knowing in the long run. And that is what I call ruinous empathy. So that is Radical Candor in a nutshell. That's the TLDR. But please do read.

**中文翻译:**
讲述关于“令人厌恶的侵略性”和“虚伪的操纵”的故事挺有意思的。如果你看《办公室》（The Office）或任何关于职场问题或人际关系的剧集，你会看到很多这类情节。但真正的痛点在于，尽管我们喜欢讨论这两个问题，但它们并不是最普遍的问题。到目前为止，最常见的问题发生在当我们记得表现出“个人关心”时——因为大多数人都想做个好人。我们记得关心他人，但因为太担心伤害对方的感情或冒犯对方，我们没能告诉他们一些从长远来看对他们更有利的事情。这就是我所说的“毁灭性的同理心”（Ruinous Empathy）。这就是“彻底坦诚”的简要概括。这是“太长不看”版，但还是请大家去读读原书。

---

### [00:06:40] Lenny

**English:**
Amazing and we'll link to a diagram of this two by two for people that aren't visual thinkers and want to actually see it. So just to make it super clear, if you're challenging directly, basically being very candid with feedback, but it's not clear you care deeply about the person, you call that obnoxious aggression.

**中文翻译:**
太棒了，我们会为那些非视觉思维、想亲眼看看这个矩阵的人提供链接。所以为了说得更清楚一点：如果你直接发起挑战，也就是反馈非常坦诚，但并没有表现出你深切关心对方，你称之为“令人厌恶的侵略性”。

---

### [00:06:40] Kim Scott

**English:**
Yes.

**中文翻译:**
是的。

---

### [00:06:57] Lenny

**English:**
And if you make it clear, you care a lot about the person but aren't actually giving them direct candid feedback, you call that ruinous empathy.

**中文翻译:**
如果你明确表示你非常关心对方，但实际上并没有给他们直接、坦诚的反馈，你称之为“毁灭性的同理心”。

---

### [00:07:05] Kim Scott

**English:**
Yes, exactly.

**中文翻译:**
没错，正是如此。

---

### [00:07:11] Lenny

**English:**
Which of these buckets do you find most people fall into? Is there a percentage of people or companies?

**中文翻译:**
你发现大多数人属于哪一类？有没有一个大致的人数或公司比例？

---

### [00:07:11] Kim Scott

**English:**
Yeah, I mean, I would say 90% of us make 90% of our mistakes in that ruinous empathy bucket. It's by far and away the most common problem. But I think all of us make mistakes in the other quadrants as well. And very often we kind of, I think one of, if I'm going to offer some self-criticism of this framework, it's much easier to notice when one has been ruinously empathetic. It's almost like, give yourself some critical feedback. "I work too hard." But it's much harder to notice when we've been manipulatively insincere and obnoxiously aggressive. And maybe I could have named those things because very often manipulative insincerity is sort of self-protective insincerity. Very often obnoxious aggression is just extreme frustration. So I want people to use this framework not to judge themselves or other people harshly, but like a compass to guide specific conversations with specific people to a better place and to help us understand when we're going in the wrong direction, which we are all bound to do on a daily basis.

**中文翻译:**
是的，我想说我们中 90% 的人在 90% 的情况下犯的错都属于“毁灭性的同理心”。这是目前为止最普遍的问题。但我认为我们所有人也会在其他象限犯错。而且通常——如果我要对这个框架做一点自我批评的话——意识到自己陷入了“毁灭性的同理心”要容易得多。这有点像给自己提批评意见时说“我工作太努力了”。但要意识到自己何时陷入了“虚伪的操纵”或“令人厌恶的侵略性”则难得多。也许我该给它们起别的名字，因为“虚伪的操纵”往往是一种“自我保护式的虚伪”，而“令人厌恶的侵略性”往往只是极度的挫败感。所以我希望人们使用这个框架不是为了严厉地审判自己或他人，而是把它当作指南针，引导与特定人的特定对话走向更好的结果，并帮助我们理解何时走偏了——而我们每个人每天都难免会走偏。

---

### [00:08:26] Lenny

**English:**
I want to talk about all those things and also how to get better at these things. But before we do that, it's very hard to change. And it's also hard just to challenge directly innately, it's hard for people to be candid, just to give people a little motivation to invest in this skill. What sort of impact do you see when people develop the skill of being better at radical candor?

**中文翻译:**
我想聊聊所有这些事情，以及如何提升这些能力。但在那之前，改变是很困难的。天生直接发起挑战也很难，人们很难做到坦诚。为了给大家一点动力去投资这项技能，你看到当人们掌握了“彻底坦诚”的技巧后，会产生什么样的影响？

---

### [00:08:48] Kim Scott

**English:**
When we get better at radical candor? I mean, I'll tell you a story in fact about the impact it had on my life, some radical candor, but the sort of abstract answer to your question is we build better relationships and we do better work and we're more successful and we're happier. You ready for a story? Let's do it. Love stories. Okay. So shortly after I joined Google, this was now a very long time ago, 2004, I had to give a presentation to the founders and the CEO about how the AdSense business was doing. And I walked into the room and there in one corner of the room was one of the founders on an elliptical trainer wearing toe shoes and a bright blue spandex unitard, super tight, not what I was expecting or frankly wanting to see in the room. And there in the other corner of the room was the CEO doing his emails like his brain had been plugged into the machine.

**中文翻译:**
当我们变得更擅长“彻底坦诚”时？其实我可以给你讲个故事，关于“彻底坦诚”对我生活产生的影响。但抽象一点回答你的问题：我们会建立更好的人际关系，做出更好的工作成果，变得更成功、更快乐。准备好听故事了吗？我们开始吧，我喜欢听故事。好的。在我加入谷歌后不久，那是很久以前的 2004 年，我必须向创始人（拉里·佩奇和谢尔盖·布林）和 CEO（埃里克·施密特）汇报 AdSense 业务的进展。我走进房间，看到一个角落里，其中一位创始人正踩着椭圆机，穿着五趾鞋和一件亮蓝色的氨纶紧身衣，超级紧身，那完全不是我预料中、坦白说也不是我想在房间里看到的景象。而在另一个角落，CEO 正在回邮件，感觉他的大脑就像直接插在机器上一样。

---

### [00:09:49] Kim Scott

**English:**
So probably like you in such a situation, I felt a little bit nervous. How was I supposed to get these people's attention? Luckily for me, the AdSense business was on fire. And when I said how many new customers we had added, the CEO almost fell off his chair. "What did you say? This is incredible. Do you need more engineers? Do you need more marketing dollars?" So I'm thinking the meeting's going all right. In fact, I now believe that I am a genius. And I walked out of the room, I walked past my boss and I was expecting a high five a pat on the back. And instead she said to me, "Why don't you walk back to my office with me?" And I thought, Oh gosh, I screwed something up in there and I'm sure I'm about to hear about it. And she began not by telling me what I had done wrong, but what had gone well in the meeting, not in the feedback sandwich.

**中文翻译:**
所以，可能和你遇到这种情况时一样，我感到有点紧张。我该怎么引起这些人的注意呢？幸运的是，当时的 AdSense 业务非常火爆。当我提到我们增加了多少新客户时，CEO 差点从椅子上摔下来。“你说什么？这太不可思议了。你需要更多工程师吗？需要更多营销预算吗？”所以我当时觉得会议进行得很顺利。事实上，我当时甚至觉得自己是个天才。我走出房间，经过我老板（谢丽尔·桑德伯格）身边，期待着一个击掌或拍拍后背的鼓励。结果她却对我说：“你为什么不跟我回办公室走走？”我心想：噢天哪，我肯定搞砸了什么，马上就要挨训了。她开始说话时，并没有先说我做错了什么，而是先说会议中表现好的地方——但不是用那种“反馈三明治”的方式。

---

### [00:10:37] Lenny

**English:**
It's acceptable, fully acceptable.

**中文翻译:**
（关于脏话）没问题，完全可以接受。

---

### [00:10:43] Kim Scott

**English:**
Not in the shit sandwich since the word, but really seeming to mean what she said. But of course, all I wanted to do was hear about what I had done wrong. And eventually she said to me, "You said um a lot in there, were you aware of it?" And with this, I braved a huge sigh of relief if that was all I had done wrong who really cared. And I kind of made this brush off gesture with my hand. I said, "Yeah, I know, it's a verbal tech. It's no big deal, really." And then she said to me, "I know this great speech coach. I bet Google would pay for it. Would you like an introduction?" And once again, I made this brush off gesture with my hand.

**中文翻译:**
不是那种“狗屎三明治”（指在批评前后各塞一句赞美），而是她看起来真的是那个意思。但当然，我当时只想听听我到底哪里做错了。最后她对我说：“你在里面说了很多次‘嗯’（um），你意识到了吗？”听到这儿，我长舒了一口气——如果这就是我唯一的错，谁在乎呢？我挥了挥手，做了个不在意的姿势说：“是啊，我知道，那是口头禅，真的没什么大不了的。”然后她对我说：“我认识一个很棒的演讲教练，我敢打赌谷歌会出这笔钱，你想让我介绍一下吗？”我再次挥挥手拒绝了。

---

### [00:11:14] Kim Scott

**English:**
I said, "Oh, I'm busy. I don't have time for a speech coach. Didn't you hear about all these new customers?" And then she said to me, "I can tell when you do that thing with your hand, then I'm going to have to be a lot more direct with you. When you say um every third word, it makes you sound stupid." Now she's got my full attention. And some people might say it was mean of her to say I sounded stupid, but in fact, it was the kindest thing that she could have done for me at that moment in my career because she knew me well enough to know that if she didn't use just those words with me, and by the way, this is a really important point, she never would've used those words with other people on her team who were perhaps a better listener than I was.

**中文翻译:**
我说：“噢，我很忙，没时间找演讲教练。你没听到刚才说的那些新客户吗？”接着她对我说：“我看得出来，当你做那个手势时，我必须对你更直接一点了。当你每隔两个词就说一个‘嗯’时，这让你听起来很蠢。”这下她彻底引起了我的注意。有些人可能会说，她说我听起来很蠢太刻薄了，但事实上，那是她在我职业生涯那个时刻能为我做的最仁慈的事。因为她足够了解我，知道如果她不对我用那样的词——顺便说一下，这很重要，她绝不会对团队里其他比我更善于倾听的人用那样的词。

---

### [00:11:56] Kim Scott

**English:**
But she knew me well enough. She cared personally enough to know that if she didn't use those words with me, I never would've gone to visit the speech coach and I wouldn't have learned that she was not exaggerating. And this was news to me because I had raised millions of dollars for two different startups giving presentations. I thought I was pretty good at it. And it really got me to thinking sort of why had no one told me. It was almost like I suddenly realized I'd been marching through my whole career with a giant hunk of spinach in between my teeth and nobody had had the common courtesy to tell me it was there. So why had no one else told me. But what was it about her leadership style that made it so seemingly easy for her to tell me? And as I thought about that, I realized it really came down to those two things.

**中文翻译:**
但她足够了解我，足够关心我，所以她知道如果不对我用那些词，我永远不会去找演讲教练，也就永远不会发现她其实并没有夸大其词。这对我来说是个新闻，因为我曾通过演讲为两家不同的创业公司筹集了数百万美元，我一直觉得自己很擅长演讲。这真的让我开始思考：为什么从来没有人告诉我？这就像我突然意识到，在整个职业生涯中，我的牙缝里一直塞着一大块菠菜，却没有人出于基本的礼貌告诉我。为什么别人没说？而她的领导风格中又是什么让她能如此轻松地告诉我真相？当我思考这些时，我意识到归根结底就是那两件事。

---

### [00:12:41] Kim Scott

**English:**
She cared personally and she challenged directly. She cared about me not just as an employee but as a human being. For example, when my father was diagnosed with late stage cancer, I was devastated and she could tell that I was devastated. And she said, "Kim, look, you go to the airport, fly home to Memphis, you need to be with your family. Your team and I will sit down and write your coverage plan." That's what great teams do for one another. And those were the kinds of things, that was the kind of thing that she did. She couldn't do, of course, for all 5,000 people in her organization, no matter how talented you are, relationships don't scale. But she did do those things for her direct reports and the people who she worked most closely with, all of us.

**中文翻译:**
她做到了“个人关心”和“直接挑战”。她不仅把我当成员工，还把我当成一个完整的人来关心。例如，当我父亲被诊断出癌症晚期时，我崩溃了，她能看出来。她说：“金，听着，你现在就去机场，飞回孟菲斯老家，你需要和家人在一起。我和你的团队会坐下来写一份工作交接计划。”这就是优秀团队成员之间会做的事。她就是会做这类事情的人。当然，她无法对组织里的 5000 人都这样做，无论你多有才华，人际关系是无法规模化的。但她确实为她的直接下属和与她工作最紧密的人——也就是我们所有人——做到了这些。

---

### [00:13:27] Kim Scott

**English:**
And when a leader treats their team, the people who they interact with on a day-to-day basis with that kind of real care, then it's much more likely that their direct reports in turn are going to treat their teams with real care. And that creates a culture of caring. And even though relationships don't scale, culture does scale. So that was part of it. But of course there's also this challenge directly part which is equally as important. And I learned very quickly beyond a shadow of a doubt that if I screwed up, she was going to tell me and she was going to keep telling me until it penetrated my sometimes thick skull.

**中文翻译:**
当一位领导者以这种真正的关怀对待他们的团队，也就是那些日常互动的人时，他们的直接下属就更有可能反过来以真正的关怀对待自己的团队。这就创造了一种关怀文化。虽然人际关系无法规模化，但文化是可以规模化的。这是原因之一。当然，还有“直接挑战”的部分，这同样重要。我很快就确信无疑：如果我搞砸了，她一定会告诉我，而且会一直说到我那偶尔不开窍的脑袋瓜真正领悟为止。

---

### [00:14:07] Lenny

**English:**
I had a manager that was also very good at this. He was very good at just giving me very direct feedback, and I knew that he was only doing it because he cared about my future. To kind of follow this thread and get a little tactical, is there language or phrases or ways of communicating that you recommend people use to either challenge directly and avoid people getting defensive or make it clear you care deeply?

**中文翻译:**
我曾经也有一位经理非常擅长这一点。他非常擅长给我直接的反馈，而我知道他这么做只是因为他关心我的未来。顺着这个思路，我们聊聊战术层面：你有没有推荐的语言、短语或沟通方式，让人们既能直接发起挑战并避免对方产生防御心理，又能明确表达出深切的关心？

---

### [00:14:31] Kim Scott

**English:**
People always want me to give them a script. And the problem with the script is that if I write it, you're going to sound like Kim Scott and not like yourself. And then people won't really think you mean what you're saying. But I do think there are some important things to consider when having these conversations. I think you want to go into the conversation, and by the way, everything I'm about to say applies to praise as much as it does to criticism. And I want to pause for a moment. That story is helpful because that's the kind of thing that has happened to so many of us, that's not unique to me. However, praise is even more important than criticism in terms of radical candor. Radical candor is not all about the boss giving the employee criticism. It should always start with soliciting feedback and it should include more praise and criticism, but anyway, way without offering up shit sandwiches.

**中文翻译:**
人们总是想要我给他们一个剧本。但剧本的问题在于，如果是我写的，你听起来就会像金·斯科特而不是你自己。那样的话，人们就不会相信你是真心实意的。但我确实认为在进行这些对话时，有一些重要的事情需要考虑。首先，进入对话时——顺便说一下，我接下来要说的内容既适用于赞美，也适用于批评。我想停顿一下：那个故事很有帮助，因为那是发生在我们很多人身上的事，并非我独有。然而，在“彻底坦诚”中，赞美甚至比批评更重要。“彻底坦诚”并不只是老板批评员工，它应该始终从征求反馈开始，并且应该包含比批评更多的赞美。当然，前提是不使用那种虚伪的“狗屎三明治”。

---

### [00:15:31] Kim Scott

**English:**
So anyway, I think that the important thing for these conversations, these sort of two-minute impromptu moments of management, is to go into the conversation being humble. To me, I call it candor and not truth because if I march into a room and I say, "Lenny, I'm going to tell you the truth." I'm kind of implying I've got a pipeline to God and you don't know anything. And that's not what this is all about. This is a dialogue, not a monologue. So to me, candor implies here's how I understand the situation. I'm also curious to know how you understand the conversation. So you want to go in being humble, you might be wrong, and that's totally fine. Omniscience is not a requirement for radical candor, thank heavens. So you want to be humble. You want to state your intention to be helpful. You want to remember in your own head and you want to make it explicit to the other person that you're telling them this to help them.

**中文翻译:**
总之，我认为对于这些对话——也就是那种两分钟的即兴管理时刻——最重要的一点是：带着谦逊进入对话。对我来说，我称之为“坦诚”（Candor）而不是“真相”（Truth），因为如果我走进房间说：“莱尼，我要告诉你真相”，我其实是在暗示我掌握了上帝的视角而你一无所知。这并不是我们的初衷。这应该是对话，而不是独白。所以对我来说，“坦诚”意味着“这是我对情况的理解，我也很好奇你是如何理解的”。所以你要保持谦逊，你可能是错的，这完全没问题。谢天谢地，“全知全能”并不是“彻底坦诚”的要求。所以要谦逊，要表明你提供帮助的意图。你要在脑子里记住，并向对方明确表示，你告诉他们这些是为了帮助他们。

---

### [00:16:25] Kim Scott

**English:**
You're not trying to be dominant or kick them in the shins or anything like that. You're telling them this because you care about them. So you want to state your intention to be helpful. You want to have these conversations right away, almost immediately. I mean, there's exceptions to everything I'm saying. None of this is absolute. But usually if I'm telling myself and Lenny, you can tell me if you have the same problem, but if I tell myself, Oh, I'm going to wait for a better moment to tell this person this thing, what I'm really saying is I'm never going to say. So if the purpose of praise is to tell people what to do more of, and the purpose of criticism is to tell them what to do less of, why wait. So you want to do it immediately unless you are so upset that you're going to say it in a terrible way or the other person is so upset that they can't hear you. But usually that's not the case.

**中文翻译:**
你不是想表现出支配欲，或者踢他们的胫骨，或者做类似的事。你告诉他们是因为你关心他们。所以要表明助人的意图。你要立即进行这些对话，几乎是立刻。当然，我说的所有话都有例外，没有什么是绝对的。但通常如果我告诉自己——莱尼，你可以告诉我你是否有同样的问题——如果我对自己说：“噢，我要等一个更好的时机再告诉他这件事”，我真正的意思其实是“我永远不会说了”。如果赞美的目的是告诉人们多做些什么，批评的目的是告诉人们少做些什么，那为什么要等呢？所以要立即行动，除非你当时情绪太激动会导致表达方式很糟糕，或者对方情绪太激动听不进你的话。但通常情况并非如此。

---

### [00:17:16] Kim Scott

**English:**
You also want, and in the before times I used to say have these conversations in person. Now I say have these conversations synchronously and I'm going to recommend phone over video. There's a lot of evidence coming out of University of Chicago and probably other places, but that's the article I've read that there's more noise than signal in facial expressions and body language, especially if somebody is just a little square on a computer screen. But it also may be true in real life, like the phone actually may be one of our best communication innovations of all time because when you're talking to someone on the phone, you're listening to the words that they are saying to you, and that is really what you want to do in this moment. So make sure that you're having these conversations synchronously, because what you want to do next is gauge how it's landing.

**中文翻译:**
另外，在以前，我会说要当面谈。现在我会说要“同步”谈，而且我更推荐电话而不是视频。芝加哥大学以及其他地方有很多证据表明——这是我读过的文章——面部表情和肢体语言中的噪声多于信号，尤其是当对方只是电脑屏幕上的一个小方块时。但在现实生活中可能也是如此，电话实际上可能是我们有史以来最伟大的沟通创新之一，因为当你和某人通电话时，你会专注于对方对你说的每一个词，而这正是你那一刻需要做的。所以要确保同步沟通，因为你接下来要做的是观察对方的反应（Gauge how it's landing）。

---

### [00:18:15] Kim Scott

**English:**
So I'll talk about that in a minute. And you can't gauge how something is landing if you're sending an email or a text, and Slack is just a feedback train wreck waiting to happen. I once coached someone who kept giving feedback over Slack and I finally just quit coaching him. I was like, "If you keep making this mistake, I can't be your coach." So don't do that. Take a moment to pick up the phone and call the person. Go back to those old AT&T commercials when I was a kid. Reach out and touch someone. You want to show you care.

**中文翻译:**
我稍后会详细谈谈这一点。如果你发邮件或短信，你无法观察对方的反应。而 Slack 简直就是一个等待发生的反馈车祸现场。我曾经辅导过一个人，他总是通过 Slack 给反馈，最后我直接放弃辅导他了。我说：“如果你一直犯这个错误，我没法当你的教练。”所以别那样做。花点时间拿起电话打给对方。就像我小时候那些老牌 AT&T 广告里说的：“伸出手，触动某人”（Reach out and touch someone）。你要表现出你的关心。

---

### [00:18:52] Kim Scott

**English:**
So let's review. You want to be humble, you want to be helpful, you want to do it immediately. You want to do it in person or at least synchronously. If you can't do it in person. You also want to praise in public and criticize in private, and you don't want to give people either praise or criticism about their personality. So if you want to remember all that, it's HHIIPPP, two H's, two I's, kind of three P's depending on how you count.

**中文翻译:**
所以我们复习一下：要谦逊（Humble），要助人（Helpful），要立即行动（Immediate），要当面或至少同步（In person/Synchronous）。如果你不能当面谈，也要同步。你还要公开赞扬（Praise in public），私下批评（Criticize in private），并且不要针对性格（Personality）进行赞扬或批评。如果你想记住这些，那就是 HHIIPPP：两个 H，两个 I，根据你的算法，大概有三个 P。

---

### [00:19:21] Kim Scott

**English:**
And so let's double-click though on this not about personality point. I think it's really important to remember that for both praise and criticism, you want to use sort of context, observation, result, next step. So context, in the meeting, observation, when you said um every third word, result, it made you sound stupid. Next step, go to the speech coach. Also is important for praise, in the meeting context, when you offered both sides of the argument, observation, result is it earned you credibility. Next step is do more of that. So you can call it CORE, you can think about that as CORE. I used to call it CORN, but I got some feedback that corn is like some shorthand for porn on TikTok. So I call it CORE instead, HIP CORE.

**中文翻译:**
让我们深入探讨一下“不针对性格”这一点。我认为非常重要的一点是，无论是赞美还是批评，都要使用：背景（Context）、观察（Observation）、结果（Result）、下一步（Next step）。比如背景：在会议中；观察：当你每三个词就说一个“嗯”时；结果：这让你听起来很蠢；下一步：去找演讲教练。赞美也同样重要，背景：在会议中；观察：当你提出论点的正反两面时；结果：这为你赢得了信誉；下一步：多做这样的事。你可以称之为 CORE 框架。我以前叫它 CORN，但我收到反馈说 corn 在 TikTok 上是 porn（色情）的缩写。所以我改叫它 CORE 了，合起来就是 HIP CORE。

---

### [00:20:16] Lenny

**English:**
Wow, that is amazing. Thank you for sharing all that. So the E at the end stands for?

**中文翻译:**
哇，太棒了。谢谢分享。所以最后的 E 代表？

---

### [00:20:20] Kim Scott

**English:**
Next step, big E.

**中文翻译:**
下一步（Next Step），大写的 E。

---

### [00:20:21] Lenny

**English:**
Oh, I see the E is the next, you skipped the N, clever.

**中文翻译:**
噢，我明白了，E 是 nExt 的 E，你跳过了 N，真聪明。

---

### [00:20:26] Kim Scott

**English:**
Yes. I don't know, clever or ridiculous. Maybe I should just call it HIP CORN,

**中文翻译:**
是的。我也不知道是聪明还是荒谬。也许我该直接叫它 HIP CORN。

---

### [00:20:31] Lenny

**English:**
Right? No, I think either one's great. So you share this example of the speaking example. Maybe if we can do another example just to reinforce this framework.

**中文翻译:**
是吧？不，我觉得两个都挺好。你分享了演讲的例子，也许我们可以再举一个例子来巩固这个框架。

---

### [00:20:43] Kim Scott

**English:**
Let's do a little ruinous empathy.

**中文翻译:**
我们来举一个“毁灭性同理心”的例子吧。

---

### [00:20:47] Lenny

**English:**
Okay, great. Let's do it.

**中文翻译:**
好，太棒了，开始吧。

---

### [00:20:47] Kim Scott

**English:**
How about that? That is the mistake. I think that I am really focused in the book Radical Candor and also in my next book Radical Respect. That's the mistake I really want to eliminate.

**中文翻译:**
怎么样？这就是那个错误。我在《彻底坦诚》以及我的新书《彻底尊重》中都非常关注这个错误。这是我真正想要消除的错误。

---

### [00:21:00] Lenny

**English:**
Let's do it.

**中文翻译:**
开始讲吧。

---

### [00:21:00] Kim Scott

**English:**
Because ruinous empathy creates this false harmony, which is really bad. So here's my ruinous empathy story. I had just hired this guy, we'll call him Bob, and I liked Bob a lot. He was smart, he was charming, he was funny. He would do stuff like we're at a manager offsite playing one of those endless get to know you games. And everybody was getting more and more and more stressed out. So start up, we've got a lot going on. And Bob was the guy who had the courage to raise his hand and to say, "I can tell everyone is getting stressed. I want to get to know all of you. I've got an idea. It'll help us do that and it'll be really fast."

**中文翻译:**
因为“毁灭性同理心”会创造一种虚假的和谐，这非常糟糕。这是我的故事：我当时刚雇了一个人，我们叫他鲍勃（Bob），我很喜欢他。他聪明、迷人、幽默。比如有一次我们在经理团建，玩那种没完没了的“破冰游戏”。大家压力越来越大，毕竟是创业公司，有很多事要忙。鲍勃是那个有勇气举手说：“我能感觉到大家压力都很大。我想了解大家，我有个主意，能帮我们达到目的，而且非常快。”

---

### [00:21:41] Kim Scott

**English:**
Whatever his idea was, if it was really fast, we were down with it. And Bob says, "Let's just go around the table and confess what candy our parents used when potty training us." Really weird but really fast. And then for the next 10 months, every time there was a tense moment in a meeting, Bob would whip out just the right piece of candy for the right person at the right moment. And we all remember that was the weirder thing. Like Hershey Kisses right here. That was what my parents used to potty train me.

**中文翻译:**
不管他的主意是什么，只要快，我们就同意。鲍勃说：“咱们绕桌子一圈，坦白一下小时候父母在训练我们上厕所时用的是什么糖果。”非常古怪，但确实很快。接下来的 10 个月里，每当会议气氛紧张时，鲍勃总能在恰当的时刻为恰当的人掏出恰当的糖果。我们都记得——这才是更古怪的地方——比如，“给，好时之吻，这是我父母训练我上厕所时用的。”

---

### [00:22:16] Kim Scott

**English:**
And so Bob was quirky, but he brought a little levity to the office. Everybody kind of loved working with Bob. There was one problem with Bob. He was doing terrible work. He would hand stuff into me and there was shame in his eyes. He kind of knew it wasn't good enough. He was very creative, but riddled with sloppy mistakes. And I would say something to Bob along the lines of, "Oh Bob, this is such a great start. You're so awesome. We all love working with you. Maybe you can make it just a little bit better." So let's pause for a moment. Why did I say such a banal thing to Bob? I think part of the problem was that I liked Bob and I really didn't want to hurt his feelings.

**中文翻译:**
鲍勃虽然古怪，但他给办公室带来了轻松的气氛。大家都挺喜欢和他一起工作的。但鲍勃有一个问题：他的工作做得一团糟。他交东西给我时，眼神里带着羞愧。他其实知道做得不够好。他很有创意，但到处是粗心的错误。而我会对鲍勃说类似这样的话：“噢，鲍勃，这是一个非常好的开始。你太棒了，我们都喜欢和你一起工作。也许你可以把它做得再好那么一点点。”让我们停下来想一想：为什么我会对鲍勃说这种平庸无奇的话？我觉得部分原因是我喜欢鲍勃，我真的不想伤害他的感情。

---

### [00:23:05] Kim Scott

**English:**
So that was the ruinous empathy part of why I said that. But also part of the problem was something more insidious, a little bit of manipulative insincerity, because Bob was popular and Bob was also sensitive kind of. And there was part of me that was afraid if I told Bob in no uncertain terms that his work wasn't nearly good enough, he would get upset. He might even start to cry and then everybody would think I was a big, you know what? So the part of me that was worried about my reputation as a leader, that was the manipulative insincerity part, the part of me that was worried about Bob's feelings, that was the ruinous empathy part. And this went on for 10 months, 10 long months, and I was so puzzled the whole time I couldn't understand what was going on. I learned much later that one of the issues perhaps was that Bob was smoking pot in the bathroom three times a day, which maybe explained all that candy that he had at all times.

**中文翻译:**
这就是我这么说的“毁灭性同理心”部分。但问题中还潜藏着更阴险的东西，一点点“虚伪的操纵”。因为鲍勃很受欢迎，而且他也很敏感。我内心深处有一部分在害怕：如果我毫不含糊地告诉鲍勃他的工作完全不合格，他会难过，甚至可能会哭，然后大家都会觉得我是个大……你懂的。所以，担心自己作为领导者名声的那部分是“虚伪的操纵”，担心鲍勃感受的那部分是“毁灭性同理心”。这种情况持续了 10 个月，整整 10 个月。我一直很困惑，不明白发生了什么。很久以后我才知道，其中一个原因可能是鲍勃每天在厕所抽三次大麻，这也许解释了为什么他随时随地都有糖果。

---

### [00:24:11] Kim Scott

**English:**
But I didn't know any of that at the time. All I knew is that Bob was consistently doing bad work, but I wasn't really dealing with it. And eventually the inevitable happened. I realized that if I didn't fire Bob, I was going to lose all my best performers because not only had it been unfair to Bob not to tell him, I also had been unfair to everyone on the team. And they were frustrated. Their deliverables were late because his deliverables were late. They weren't able to do their best work because they were having to spend so much time redoing his work.

**中文翻译:**
但我当时并不知道这些。我只知道鲍勃的工作一直很差，但我并没有真正去处理。最终，不可避免的事情发生了。我意识到如果我不解雇鲍勃，我就会失去所有最优秀的员工。因为不告诉鲍勃真相不仅对他不公平，对团队里的每一个人也不公平。他们感到很沮丧。因为鲍勃的交付物迟到，他们的交付物也迟到了。他们无法发挥出最佳水平，因为他们不得不花大量时间重做鲍勃的工作。

---

### [00:24:46] Kim Scott

**English:**
And the people who were best at their jobs were going to quit because they wanted to be able to do their best work. They were going to go to a different company where they could do their best work. And so I sat down to have a conversation with Bob that I should have begun frankly 10 months previously. And when I finished explaining to him where things stood, he kind of pushed his chair back from the table. He looked me right in the eye and he said, "Why didn't you tell me?" And as that question was going around in my head with no good answer, he looked at me again and he said, "Why didn't anyone tell me? I thought you all cared about me." And now I realized that by not telling Bob, thinking I was being so nice, I'm having to fire him as a result. Not so nice after all. But it was too late to say Bob because at this point even he agreed he should go because his reputation on the team was just shot.

**中文翻译:**
那些最擅长工作的人会辞职，因为他们想在能发挥所长的地方工作。他们会去另一家能让他们做到最好的公司。于是，我坐下来和鲍勃谈话，坦白说，这番谈话本该在 10 个月前就开始。当我解释完现状后，他把椅子往后挪了挪，直视着我的眼睛说：“你为什么不早告诉我？”当这个问题在我脑海中盘旋却找不到合理解释时，他再次看着我说：“为什么没有人告诉我？我以为你们都很关心我。”这时我才意识到，因为没告诉鲍勃真相，我自以为是在做好人，结果却不得不解雇他。这一点也不好。但现在挽留鲍勃已经太晚了，因为此时连他自己都同意该离开了，他在团队中的声誉已经彻底毁了。

---

### [00:25:46] Kim Scott

**English:**
All I could do in the moment was make myself a very solemn promise that I would never make that mistake again, and that I would do everything in my power to help other people avoid making that mistake. It was so painful. It was painful for me. It was painful for Bob, much more painful for Bob actually, and it was bad for the whole team and it was bad for our investors. We weren't getting results because of my ruinous empathy and ruinous empathy slash manipulative insincerity. It's much harder to admit the manipulative insincerity part. And that is really why I'm here talking to you because I want all of your listeners to avoid making that mistake because it's the most painful and the most common mistake that I think leaders and not just leaders, I mean all of us make this mistake in all of our relationships.

**中文翻译:**
那一刻我唯一能做的，就是郑重地向自己承诺：我再也不会犯同样的错误，并且我会竭尽全力帮助其他人避免犯错。这太痛苦了。对我来说很痛苦，对鲍勃来说更痛苦，对整个团队和我们的投资者来说都很糟糕。因为我的“毁灭性同理心”以及“虚伪的操纵”，我们没有拿到结果。承认“虚伪的操纵”那部分要难得多。这就是我今天在这里和你交流的原因，我希望你的所有听众都能避免犯这个错。因为这是我认为领导者——不仅是领导者，而是我们所有人——在所有人际关系中最痛苦、最常见的错误。

---

### [00:26:41] Lenny

**English:**
I love that this also gives an example of the impact of getting better at this point of you'll lose not just the people that are not necessarily great, but also other high performers on the team because they're seeing people slip through the cracks that aren't amazing. And if you're not practicing this early, your team basically becomes not high performing.

**中文翻译:**
我喜欢这个例子，因为它展示了提升这项能力的影响：如果你不改进，你失去的不仅是那些表现平平的人，还有团队中的高绩效人才。因为他们看到那些表现不佳的人在浑水摸鱼。如果你不尽早实践这一点，你的团队基本上就无法保持高绩效。

---

### [00:27:00] Kim Scott

**English:**
Yeah, exactly. You're going to lose your top performers. And I think very often people are afraid to tell someone on their team when their work isn't good enough because they're afraid of losing them. But that's not a good reason. You should be helping this person to improve. This person deserves to have a job where they can excel and you either help them excel on this team or you help them find a different job where they can excel, because everyone can do great work somewhere. And Bob could have done great work. Maybe I would've helped him keep it to the weekends because he's very creative and very smart, but the floppy mistakes just got in the way of his ability to do his best work.

**中文翻译:**
没错。你会失去顶尖人才。我认为人们常常害怕告诉团队成员他们的工作不够好，因为担心会失去他们。但这并不是一个好理由。你应该帮助这个人进步。每个人都值得拥有一份能让他们出类拔萃的工作，你要么帮他在这个团队里出类拔萃，要么帮他找一份能让他发光发热的其他工作，因为每个人都能在某个地方做出伟大的成就。鲍勃本可以做出伟大的成就。也许我会帮他把那些“爱好”留在周末，因为他非常聪明且有创意，但那些低级错误阻碍了他发挥出最佳水平。

---

### [00:27:50] Lenny

**English:**
Following that thread, I imagine the reason you didn't tell him early, and most people don't do this well, is many people are, you can maybe call them people pleasers. I'm a recovering people pleaser, I'll say. It's just hard to give people hard feedback. You want people to like you. It's not a natural state for a lot of people. What do you find helps people get over this kind of need to be liked as a leader and helps them be more candid?

**中文翻译:**
顺着这个话题，我想你当初没早点告诉他的原因——也是大多数人做不好的原因——是因为很多人都是所谓的“讨好型人格”。我得说，我就是一个正在康复中的“讨好者”。给别人严厉的反馈真的很难。你希望别人喜欢你。对很多人来说，坦诚并不是一种自然的状态。你发现有什么方法能帮助领导者克服这种“被喜欢的渴望”，并帮助他们变得更坦诚吗？

---

### [00:28:15] Kim Scott

**English:**
I think that one of the things that was helpful for me anyway, so you can tell me if it's helpful for you, was realizing that my job was not to be liked. My job was to care about other people and to get out of my own head and to become others focused is what helped me kind of let go of the need to be liked. I think that also as a woman, I think there was something extra, as my teenage children would say, there was something extra for me because the sort of likability- competence bias that a lot of women face pushed me, especially early in my career, in the wrong direction on challenge directly.

**中文翻译:**
我认为对我非常有帮助的一点是——你可以告诉我这对你是否有用——那就是意识到我的工作不是为了“被人喜欢”。我的工作是“关心他人”。走出自我的小世界，转而关注他人，这帮助我放下了对被喜欢的渴望。此外，作为一名女性，我觉得还有一些额外的挑战。就像我正值青春期的孩子会说的那样，对我来说有些“额外的东西”，因为很多女性面临的“亲和力与能力偏见”（Likability-Competence Bias）在我职业生涯早期把我推向了“直接挑战”的错误方向。

---

### [00:29:04] Kim Scott

**English:**
And it made it much harder for me to, because often I would say something and I would say it even more gently than my colleagues who were men, but people would say, "Ah, Kim is a real whatever." And they weren't saying, Kim is obnoxious. I was being unjustly accused of obnoxious aggression and it wasn't obnoxious or they were accusing me of being bossy or or abrasive or whatever. And it's really hard. I would also say when it comes to eliciting feedback, it's really important to be open to it and it's really important to separate the wheat from the chaff from the feedback you're getting.

**中文翻译:**
这让我变得更难。因为通常我说一些话，甚至比我的男同事说得还要温柔，但人们会说：“啊，金真是个……”他们虽然没直接说我令人厌恶，但我却被不公正地指责为“令人厌恶的侵略性”，而那其实并不令人厌恶。或者他们会指责我爱指挥人、生硬等等。这真的很难。我还想说，在征求反馈时，保持开放的心态非常重要，而且从你收到的反馈中“去粗取精”也同样重要。

---

### [00:29:41] Lenny

**English:**
So in this example of Bob, say you were to do it now, what would you do differently other than give him feedback earlier? Is there something you've learned about just how you would've phrased it or approached it?

**中文翻译:**
所以在鲍勃的例子中，假设你现在来处理，除了早点给反馈，你还会做哪些不同的事？关于如何措辞或处理，你有没有学到什么新东西？

---

### [00:29:58] Kim Scott

**English:**
I think probably what I would do, and I would love to hear what you would've said to Bob too, I certainly don't have all the answers, but probably what I would've said is let's go back to the first time Bob handed work into me with shame in his eyes. I would've said, "Bob, maybe I'm misinterpreting the expression on your face, but it looks to me like you are not happy with this. What's going on?" And so I would've asked him to diagnose it himself and I want to pause on that because that can be very risky. He might have said to me, "I think this is awesome. This is my best work," and now I've kind of made my job of giving him feedback a little bit harder. So it's not always the right thing to ask questions, but I would've tried to ask it before I had examined the work when I noticed that he looked uncomfortable himself.

**中文翻译:**
我想我可能会这么做——我也很想听听你会对鲍勃说什么，我肯定没有所有答案——但我可能会在鲍勃第一次带着羞愧的眼神交作业时就说：“鲍勃，也许我误解了你的表情，但在我看来你对这份工作并不满意。发生什么事了？”我会让他自己诊断。我想在这里停顿一下，因为这可能很有风险。他可能会说：“我觉得这太棒了，这是我最好的作品。”这样一来，我给他反馈的工作反而变难了。所以提问并不总是对的，但我会尝试在检查工作之前，当我注意到他自己看起来很不自在时，就先问出来。

---

### [00:31:53] Kim Scott

**English:**
And I think also another thing I've learned about noticing, I said earlier that there's a lot of evidence that we often misinterpret each other's facial expressions and body language. So I would've tried to say that with some humility, it seems like you're not, maybe I'm wrong, but you don't look to me like you're happy with this. And I would've given him an opportunity to say, "Yeah, maybe I need to do it again." Let's imagine though that he said, "Oh no, it's awesome. It's ready." So then I get it and I look at it. I would have not been shy about pointing out very specifically every problem that I saw in that piece of work, every single one. Sometimes it can be tempting when you're giving someone feedback to say, "Oh, there's a number of careless mistakes here. Can you go back and look at it again," and the person will notice a few of them and then you got to go, sometimes it's useful to show someone a pattern.

**中文翻译:**
我还学到了关于观察的另一件事。我之前说过，有很多证据表明我们经常误解对方的表情和肢体语言。所以我会带着谦逊去说：“看起来你并不……也许我错了，但在我看来你对这个并不满意。”我会给他一个机会说：“是的，也许我需要重做。”但假设他说：“噢不，这很棒，准备好了。”那么当我拿到并查看时，我会毫不犹豫地指出我在那份工作中看到的每一个具体问题，每一个。有时候给反馈时，人们容易受诱惑说：“噢，这里有一些粗心的错误，你能回去再看一遍吗？”然后那个人只会注意到其中几个。有时候，向对方展示一种“模式”是很有用的。

---

### [00:31:53] Kim Scott

**English:**
All of the careless mistakes, especially if someone is defensive or if you think they're likely to be defensive, if you think they're likely to do to you what I did to my boss, oh no, everything's fine. It's no big deal. You need to move out on the challenge directly dimension. You need to be prepared to keep going until you have communicated with a person. And that was really the problem with Bob. He probably would not have started to cry. I think my fear around his tears was probably more about my fear than what was actually likely to happen. But I think we do fear someone else getting upset more often than they actually get upset. We have kind of a negativity bias when it comes to part of the reason why we're reluctant to give feedback.

**中文翻译:**
列出所有的粗心错误，特别是当对方有防御心理，或者你认为他们可能会有防御心理时。如果你觉得他们可能会像我对我老板那样说“噢不，一切都好，没什么大不了的”，你就需要加强“直接挑战”的力度。你需要准备好持续沟通，直到真正传达到位。这正是鲍勃的问题所在。他可能根本不会哭，我对眼泪的恐惧可能更多源于我自己的恐惧，而不是实际可能发生的情况。我认为，我们担心别人不高兴的频率远高于他们真正不高兴的频率。在不愿给反馈的原因中，我们存在一种“负面偏见”。

---

### [00:32:42] Lenny

**English:**
And I think to your point, that we want to be liked, like you said, that you should get over that. I think that's obviously very hard just to be like, "Nah, I'm not going to worry about that." But I think your point is really important that you'll be liked later if you don't do the hard thing now. It'll only get worse if you just let it continue happening.

**中文翻译:**
我觉得关于“想被喜欢”这一点，就像你说的，应该克服它。虽然这显然很难，很难直接说“不，我不在乎”。但我觉得你的观点非常重要：如果你现在不做这件难事，以后你也不会被喜欢。如果你任由事情继续发生，情况只会变得更糟。

---

### [00:33:01] Kim Scott

**English:**
And I think also for me to say to myself going into that conversation, it's more important for me to demonstrate care, that I care about Bob than it is for Bob to like me, and if I demonstrate that I care about Bob, then I'm going to do the right thing that will ultimately create the conditions for a good relationship with Bob. Me pulling my punches did not create the conditions for a good relationship with Bob.

**中文翻译:**
而且我觉得在进入对话前对自己说：表现出我对鲍勃的“关心”，比让鲍勃“喜欢我”更重要。如果我表现出关心，我就会做正确的事，这最终会为与鲍勃建立良好关系创造条件。而我当初的“手下留情”并没有为良好关系创造条件。

---

### [00:33:31] Lenny

**English:**
I actually did that and I learned this from a manager of mine is just almost work backwards from ask them, what do you want to achieve in your career? Where do you want to go in this company and make sure they know you know what they want, and then basically work backwards from to get there. Here's the things you need to get, and here's the thing you did recently that isn't necessarily on the track and here's what we should be working on if you want to get to the skull that you have.

**中文翻译:**
我确实这么做过，这是我从一位经理那里学到的：几乎是倒推法。问他们：“你的职业目标是什么？你想在这家公司达到什么位置？”确保他们知道你了解他们的诉求，然后倒推：为了达到那个目标，你需要具备哪些条件；你最近做的哪些事偏离了轨道；如果你想实现那个目标，我们应该在哪些方面努力。

---

### [00:33:57] Kim Scott

**English:**
Yeah, I think one of the really important things that all managers can do for their direct reports to show that they care is to have real meaningful career conversations, where you talk about their life story, sort of their past, whatever part of it they're comfortable talking to you about so that you understand what motivates them at work. And I would have three separate 45 minute conversations, so one about their past, one about their future, their dreams for the future, and it's not just the next couple of years. It's like imagine at the height of your career you have everything you want. What does it look like? And give me three or four different pictures of that because very few of us know what we want to do when we grow up.

**中文翻译:**
是的，我认为所有经理能为下属做的、最能体现关心的事之一，就是进行真正有意义的职业对话。聊聊他们的生活经历、他们的过去，只要是他们愿意分享的部分，这样你就能理解是什么在工作中激励着他们。我会安排三次独立的 45 分钟对话：一次关于过去；一次关于未来，关于未来的梦想——不仅仅是未来两三年，而是想象当你处于职业生涯巅峰、拥有想要的一切时，那是什么样子的？给我描绘三四个不同的画面，因为很少有人真正知道自己长大后想做什么。

---

### [00:34:40] Kim Scott

**English:**
Then the third conversation is to sort of sit down with your director report and come up with a career action plan. So given what motivates you and where you want to go, what are the skills that it would be useful for you to develop so that you can get where you want to go and who can I introduce you to? What are the educational opportunities? Can we tweak your job so that you're gaining those skills so you're at least taking a step in the direction of your dreams, even if you're not there yet?

**中文翻译:**
第三次对话是和你的下属坐下来，制定一个职业行动计划。基于你的动力和目标，哪些技能对你的发展有用？我可以介绍谁给你认识？有哪些教育机会？我们能否微调你的工作内容，让你能习得这些技能，从而至少朝着梦想迈进一步，即使现在还没达到？

---

### [00:35:11] Lenny

**English:**
Amazing. I have a post about this. I'll link to in the show notes that gives people a guide to having these conversations, and there's a spreadsheet I share with people like, here's an action plan you can come up with your teammate and here's what you're going to work on these next six months.

**中文翻译:**
太棒了。我写过一篇关于这个的文章，我会放在节目介绍里，为人们提供进行这些对话的指南。我还分享了一个电子表格，比如：这是你可以和队友一起制定的行动计划，这是未来六个月要努力的方向。

---

### [00:35:24] Kim Scott

**English:**
Did you read the book When they Win, You Win by Russ Laraway?

**中文翻译:**
你读过拉斯·拉拉威（Russ Laraway）写的《他们赢，你就赢》（When They Win, You Win）吗？

---

### [00:35:24] Lenny

**English:**
No.

**中文翻译:**
没读过。

---

### [00:35:29] Kim Scott

**English:**
Oh, he has a hundred pages on career conversations and he's also built sort of some tools that help people. So check that out.

**中文翻译:**
噢，他书里有 100 页专门讲职业对话，他还开发了一些帮助人们的工具。去看看吧。

---

### [00:35:39] Lenny

**English:**
And it's called When You Win... When They Win, You Win.

**中文翻译:**
书名是《当你赢……》《他们赢，你就赢》。

---

### [00:35:41] Kim Scott

**English:**
When They Win, You Win.

**中文翻译:**
《他们赢，你就赢》。

---

### [00:35:42] Lenny

**English:**
Amazing.

**中文翻译:**
太棒了。

---

### [00:35:42] Kim Scott

**English:**
Yes, by Russ Laraway, he and I worked together at Google and then we started a company together.

**中文翻译:**
是的，作者是拉斯·拉拉威，我和他在谷歌共事过，后来还一起创办了一家公司。

---

### [00:35:48] Lenny

**English:**
Oh wow. Okay, cool. We'll link to them in the show notes. Maybe I'll get him on the podcast too. Great.

**中文翻译:**
噢哇，好的。我们会把链接放在节目介绍里。也许我也会邀请他来上播客。太好了。

---

### [00:35:51] Kim Scott

**English:**
Yeah, he'd be great.

**中文翻译:**
是的，他会很棒的。

---

### [00:35:53] Lenny

**English:**
Okay, so we've been chatting about ways individually to get better at some of these skills. Another area that I think people struggle with is the company culture often isn't welcoming of direct feedback. So there's a question, so you probably saw this on Twitter. I asked people, what should I ask you? And a lot of people came in with a lot of questions and there's one that came in from Pete, so I'm just going to read it along these lines. So this question is just how do you practice being radically candid in a culture? And most cultures are like this where people aren't ready for direct feedback. Since company culture is often closer to ruinous empathy and being radically candid is more of a long-term good than a short-term good. You could potentially risk retention with your employees if you're too direct with them. So how do you think about finding this balance of being candid but not pissing people off, or do you just hire people that are open and ready for direct feedback and that's kind of how you solve that problem?

**中文翻译:**
好，我们一直在聊个人提升这些技能的方法。我认为人们挣扎的另一个领域是公司文化——通常公司文化并不欢迎直接反馈。有一个问题，你可能在 Twitter 上看到了，我问大家该问你什么，很多人提了问。其中一个是皮特（Pete）提的，我读一下：在一种人们还没准备好接受直接反馈的文化中，你如何实践“彻底坦诚”？因为大多数文化更接近“毁灭性同理心”，而“彻底坦诚”更多是长期利益而非短期利益。如果你太直接，可能会面临员工流失的风险。那么，你如何考虑在“保持坦诚”和“不惹恼别人”之间寻找平衡？还是说你只雇佣那些心态开放、准备好接受直接反馈的人，以此来解决问题？

---

### [00:36:45] Kim Scott

**English:**
I don't think you can only hire people who are open and ready for direct feedback because it's hard for all of us. I just want to acknowledge that, it's hard for me. I mean, I wrote the book, I believe in it to my core and sometimes it's still hard for me. It's hard for me to hear it and it's hard for me to deliver it. This is a really difficult thing to do. The good thing about that two by two is it makes it look easy, which is useful, but it's not easy. So anyway, I think there are, to answer Pete's question, I think there are a few things that can help. There's really an order of operations to radical candor, and if you begin with soliciting criticism, then you take the first and most important step to improving your relationship with that person enough that it becomes easier for you to give it as well as to get it.

**中文翻译:**
我不认为你能只雇佣那些心态开放、准备好接受直接反馈的人，因为这对我们所有人来说都很难。我必须承认这一点，对我来说也很难。虽然我写了这本书，打心底里相信它，但有时对我来说依然很难。听取反馈很难，给出反馈也很难。这是一件非常不容易的事。那个 2x2 矩阵的好处是它让事情看起来很简单，这很有用，但做起来并不容易。总之，为了回答皮特的问题，我认为有几件事会有所帮助。实践“彻底坦诚”其实是有先后顺序的：如果你从“征求批评”开始，你就迈出了最重要的一步，这能改善你与对方的关系，从而让你给出反馈和接受反馈都变得更容易。

---

### [00:37:35] Kim Scott

**English:**
So I want to leave folks with some sort of steps on how to solicit feedback, and this is true, especially if you're a boss, but it's true in all your relationships. You can use this at home as well. So if you say, "Do you have any feedback for me?" You're wasting your breath. The other person's going to say, "Oh no, everything's fine." Nobody in your life accepts your teenage children. If you have teenage children, they'd really want to give you some criticism, but nobody else in your life really wants to give you criticism. And so you want to think about how you're going to ask the person that's going to be most likely to elicit a response. The question that I like to ask is, "What could I do or stop doing that would make it easier to work with me?" But do not write down my question because if you sound like Kim Scott and not like yourself, then other people are not going to believe you want the answer. It needs to sound authentic to you.

**中文翻译:**
所以我想给大家提供一些关于如何征求反馈的步骤。这不仅适用于老板，也适用于你所有的人际关系，甚至在家里也可以用。如果你问：“你对我有什么反馈吗？”你是在浪费口舌。对方会说：“噢没，一切都好。”你生活中除了正值青春期的孩子，没人想批评你。如果你有青春期的孩子，他们确实很想批评你，但除此之外没人想这么做。所以你要思考如何提问最能引发回应。我喜欢问的是：“我做些什么，或者停止做些什么，能让你跟我合作起来更轻松？”但不要照抄我的问题，因为如果你听起来像金·斯科特而不是你自己，别人就不会相信你是真心想要答案。它必须听起来对你而言是真实的。

---

### [00:38:33] Kim Scott

**English:**
I was working with Christa Quarles when she was CEO of OpenTable and she said, "Kim, I could never imagine those words coming out of my mouth." She said, "The way I like to ask is tell me why I'm wrong." Okay, that's fine too. It demands an answer to her question. But of course there were a couple of people on her team who felt that that was too aggressive, that shut them down, so she had to adjust her question. Being authentic does not mean ignoring the impact you're having on others. So you want to think about your question, you want to think about who you're going to ask that question of, and if everybody can write down their question, who they're going to ask it of and then pop it into their calendar right now, this will be one of the most productive podcasts in all of podcast land.

**中文翻译:**
我曾与 OpenTable 的前 CEO 克里斯塔·夸尔斯（Christa Quarles）合作，她说：“金，我无法想象我会说出那样的话。”她说：“我喜欢问的方式是：‘告诉我为什么我是错的。’”好吧，那也行。这要求对方必须回答她的问题。但当然，她团队里有几个人觉得这太有侵略性了，让他们不敢开口，所以她必须调整提问方式。保持真实并不意味着忽视你对他人的影响。所以你要思考你的问题，思考你要问谁。如果每个人现在都能写下自己的问题、打算问谁，然后立刻排进日程表，这将是播客界最高产的一刻。

---

### [00:39:22] Lenny

**English:**
Let's spend more time on this actually. So what is it you recommend, that they pick? How many people would you recommend they pick, and ask feedback from?

**中文翻译:**
我们再多花点时间聊聊这个。你建议他们选多少人来征求反馈？

---

### [00:39:28] Kim Scott

**English:**
Well, I think if you are a manager, you need to be soliciting every week feedback from each of your direct reports, and you need to sort of, I would budget five minutes at the end of your one-on-one to solicit feedback. So mostly a one-on-one should be your employees setting the agenda and your employee's time and don't by the way, save up when you have to give feedback. Don't save it up for your one-on-one and definitely don't save it up for a performance review. You want to give that in the moment. We can talk more about that in a second, but when you're soliciting feedback, save five minutes at the end of your one-on-one and ask that go-to question. And you also want to ask that go-to question of your cross-functional peers who you work most closely with and of your boss. And I think you don't want to ask the same question every single time. It'll start to sound like you don't really want the answer, but you want to make this part of your daily weekly routine with the people who you interact most closely with.

**中文翻译:**
如果你是经理，你需要每周从每位直接下属那里征求反馈。我建议在 1对1 面谈结束前预留 5 分钟来征求反馈。通常 1对1 面谈应该是员工设定议程，是属于员工的时间。顺便说一下，不要攒着反馈。不要攒到 1对1 面谈才说，更不要攒到绩效评估才说。你应该当场给出反馈。我们稍后可以详谈这一点。但在征求反馈时，留出最后 5 分钟问那个“必问问题”。你还应该向与你合作最紧密的跨职能同事以及你的老板问这个问题。我认为你不需要每次都问完全一样的问题，否则听起来就像你并不是真的想要答案。但你要让这成为你与紧密合作者之间日常或每周的惯例。

---

### [00:40:34] Lenny

**English:**
So you added to the end of this your one-on-one agenda, and two versions of this question are, what am I doing wrong? Which is that one I guess you iterated.

**中文翻译:**
所以你把它加到了 1对1 面谈议程的末尾。这个问题的两个版本是：“我哪里做错了？”我想这是你迭代后的版本。

---

### [00:40:43] Kim Scott

**English:**
Tell me why I'm wrong or what am I doing wrong or what could I do or stop doing that would make it easier to work with me? Or what should I stop doing? What should I start doing? What should I continue doing? Those are some common ones. What do you like to ask Lenny?

**中文翻译:**
“告诉我为什么我是错的”，或者“我哪里做错了”，或者“我做些什么或停止做些什么能让你跟我合作更轻松？”或者“我应该停止做什么？开始做什么？继续做什么？”这些都是常见的。莱尼，你喜欢怎么问？

---

### [00:41:00] Lenny

**English:**
I think it was something along the lines of like, what's one thing I could be doing better or what's one way I could be helping you be more successful?

**中文翻译:**
我想大概是类似：“有什么是我可以做得更好的？”或者“我可以通过哪种方式帮助你更成功？”

---

### [00:41:07] Kim Scott

**English:**
That's a really good one. What's one way I could help you be more successful? Or Jason Rosoff, my co founder at Radical Candor likes to ask, "What could I have done this week?" So he time, he time bounds it. "What could I have done this week to better support you in your work?" In fact, Jason told me after we had worked together for about a month, he was like, "Kim, I really hate your go-to question." He said, "It's too open-ended for me. If you can tell me what you're working on and ask me at the end of a meeting specifically what I noticed then that is much better."

**中文翻译:**
那是个非常好的问题。“我可以通过哪种方式帮助你更成功？”或者我的合伙人杰森·罗索夫（Jason Rosoff）喜欢问：“这周我可以做些什么？”他给问题加了时间限制。“这周我可以做些什么来更好地支持你的工作？”事实上，杰森在和我共事一个月后告诉我：“金，我真的很讨厌你那个必问问题。”他说：“那对我来说太开放了。如果你能告诉我你正在努力的方向，并在会议结束时问我具体观察到了什么，那会好得多。”

---

### [00:41:48] Lenny

**English:**
How often do you accept no answer? Just like, no everything's great.

**中文翻译:**
你多久会接受一次“没有反馈”的回答？比如对方说“没，一切都挺好”。

---

### [00:41:52] Kim Scott

**English:**
Never,

**中文翻译:**
从不。

---

### [00:41:53] Lenny

**English:**
Never,

**中文翻译:**
从不？

---

### [00:41:53] Kim Scott

**English:**
Never. I mean, there are some people who really don't like to be put on the spot. So if I can tell that I'm inflicting a cruel and unusual punishment on the person, I'll say, "Look, you know I'm not perfect. I know I'm not perfect. Next time we meet, I want you to think of something, notice something. It's the thing that you can do that would help me more than anything else that you could do is to tell me when I'm wrong because I need to know that." In fact, Andy Grove, who was the CEO of Intel said he used to at the end of his one-on-ones say to people, "There's one more thing. And he explained to me that that was coded Intel for like this is the most important thing." I was working at Apple at the time and I said, "Oh, did you get that from Steve Jobs?"

**中文翻译:**
从不。我的意思是，有些人确实不喜欢被当场追问。如果我感觉到我是在对那个人施加某种“残酷且不寻常的惩罚”，我会说：“听着，你知道我不完美，我也知道我不完美。下次见面时，我希望你能想到点什么，观察到点什么。你能做的对我最有帮助的事，就是告诉我什么时候我错了，因为我需要知道。”事实上，英特尔前 CEO 安迪·格鲁夫（Andy Grove）曾说，他过去常在 1对1 面谈结束时对人说：“还有一件事。”他向我解释说，那是英特尔的暗语，意思是“这是最重要的事”。我当时在苹果工作，我问：“噢，你是从史蒂夫·乔布斯那里学来的吗？”

---

### [00:42:47] Kim Scott

**English:**
That was always how he introduced, "Just one more thing, the iPad." And Andy got immediately very grumpy and very offended, and he said, "No, we both got it from Colombo. The detective show." You can get tips from anywhere. So you want to make sure that you're though letting the person know that you really do care about what they say and that it's really when they give you this critical feedback that you're going to reward it. But that's not the end. Asking that question is only the first step, the bad news about your question, no matter how hard you think about it, and no matter how good a question it is, the other person is still going to feel uncomfortable. There's no such thing as emotional Novocaine. That's why I don't believe in scripts. People believe if I just say the magic words like the door will open, that's not how it works. It's a give and take. So you want to sort of be prepared to embrace that discomfort. The only way out is through. Simplest way to embrace the discomfort is to close your mouth and count to six.

**中文翻译:**
乔布斯总是这样介绍新产品：“还有一件事……iPad。”安迪立刻变得非常暴躁且感觉被冒犯了，他说：“不，我们都是从《神探可伦坡》（Colombo）那部侦探剧里学来的。”你可以从任何地方获得灵感。所以，你要确保让对方知道你真的很在乎他们说的话，并且当他们给你批评性反馈时，你会给予奖励。但这还没完。提问只是第一步。坏消息是，无论你多么努力思考，无论问题多么好，对方依然会感到不舒服。世界上没有“情绪麻醉剂”。这就是我不相信剧本的原因。人们相信只要说出咒语，门就会打开，但事实并非如此。这是一种互动。所以你要准备好拥抱那种不适感。唯一的出路就是穿过它。拥抱不适最简单的方法就是闭上嘴，默数到六。

---

### [00:43:59] Kim Scott

**English:**
Only made it to three just there, and your eyes were popping out.

**中文翻译:**
刚才我才数到三，你的眼睛都要瞪出来了。

---

### [00:44:03] Lenny

**English:**
That is so long.

**中文翻译:**
那时间太长了。

---

### [00:44:04] Kim Scott

**English:**
Six seconds is a really long time. Almost nobody can endure six full seconds of silence. So they'll probably tell you something. So now you've dragged this poor soul out on a conversational limb that they never wanted to go on. They're probably going to say something. The third step is to make sure that you listen with the intent to understand not to respond, because you're probably going to feel defensive and that's okay. It doesn't mean you're a lesser mortal or that you're shut down the feedback. All it means is that you're human. And that's all part of this. You want to figure out how to manage your natural defensive reaction to critical feedback, which you're probably going to have. The simplest tactic I can offer folks there is to think of some follow-up questions.

**中文翻译:**
六秒钟确实非常漫长。几乎没有人能忍受整整六秒钟的沉默。所以他们大概率会开口说点什么。现在你已经把这个可怜的灵魂拽到了一个他们本不想涉足的对话边缘。他们可能会说点什么。第三步是确保你倾听的目的是为了“理解”而不是为了“回应”。因为你可能会感到防御心理，这没关系。这并不意味着你是个平庸的人或者你拒绝反馈，这只说明你是个人。这都是过程的一部分。你要学会如何管理对批评性反馈的自然防御反应。我能提供的最简单策略就是：想一些后续问题。

---

### [00:44:56] Kim Scott

**English:**
So at breakfast, my daughter not too long ago said to me, "Mom, I wish you weren't the Radical Candor lady." And immediately this wave of parental guilt washed over me and I thought, ah, I'm spending too much time at work. She wants more of my time. I shouldn't be traveling so much. But then I thought, well, I should ask her, make sure I understood. I'm jumping to conclusions here. I'm not listening with the intent to understand. So I asked a follow-up question. I said, "Well, who do you wish I were?" And she said, "I wish you were the lady who minded her own business," so I could go spend a little more time at work as far as she was concerned. So you want to make sure you really understand what a person is telling you. And once you feel certain that you really do understand and that you've been open to it, the last and most important step is to reward the candor.

**中文翻译:**
不久前在吃早餐时，我女儿对我说：“妈妈，我希望你不是那个‘彻底坦诚女士’。”瞬间，一阵为人父母的愧疚感袭来，我想：啊，我花在工作上的时间太多了，她想要我多陪陪她，我不该出差那么多。但接着我想，我应该问问她，确保我理解对了。我这是在草率下结论，没有带着理解的意图去听。于是我问了一个后续问题：“那你希望我是谁呢？”她说：“我希望你是那个‘少管闲事女士’。”所以对她来说，我可以去多工作一会儿。所以，你要确保你真的理解了对方在说什么。一旦你确定自己理解了并且保持了开放心态，最后也是最重要的一步就是：奖励这种坦诚。

---

### [00:45:46] Kim Scott

**English:**
A person takes a huge risk, especially if this person is your employee. A person takes a huge risk to give you critical feedback. And if you do not reward that risk richly, you're never going to get any feedback again. So if you agree with the feedback, fix the problem and make your listening tangible, be loud. So-and-so told me that the tea in the break room is terrible, and now we have thirty-five different kinds of tea. Thank you for telling me. And that can demonstrate to people that they're not wasting their breath to come to you. That if you become aware of a problem, you'll fix it. And you also want to, by the way, you want to ask for feedback after you fixed it. Did I over-correct or did I under-correct?

**中文翻译:**
一个人给你批评性反馈是冒了巨大风险的，尤其是如果这个人是你的员工。如果你不给予丰厚的奖励，你以后再也收不到任何反馈了。所以，如果你同意反馈，就解决问题，并让你的倾听变得可见——要大声说出来。“某某告诉我茶水间的茶很难喝，现在我们有了 35 种不同的茶。谢谢你告诉我。”这能向人们证明，找你反映问题不是白费口舌。如果你意识到问题，你会解决它。顺便说一下，解决后你还要征求反馈：“我修正过度了吗？还是修正得不够？”

---

### [00:46:31] Kim Scott

**English:**
My boss at Google, the same boss from the um story also told me when she gave me some feedback that I tended to move too fast. And she said, "Kim, until people and giving you feedback that you're going too slow. You won't have corrected this problem." So you kind of want to shoot to over-correct if you get some critical feedback. I also want to though pause on what to do when you get some critical feedback that you disagree with because it can be easy to feel wedged here. And if all you do is say thank you for the feedback, the other person is going to hear something much less polite than a brush off or worse.

**中文翻译:**
我在谷歌的老板，就是那个“嗯”故事里的老板，在给我反馈时也说过我倾向于行动太快。她说：“金，直到人们开始反馈说你行动太慢了，你才算真正纠正了这个问题。”所以当你收到批评性反馈时，你可能需要尝试“过度修正”。不过，我也想停下来谈谈当你收到不认同的批评性反馈时该怎么办，因为这很容易让人感到左右为难。如果你只是说“谢谢你的反馈”，对方听到的可能比敷衍还要糟糕。

---

### [00:47:10] Kim Scott

**English:**
And so what you want to do is you want to look for that five or 10% of whatever the person said that you can agree with, and you want to give voice to that. And then what you want to do is you want to say, "As for the rest of it, I want to think about it and get back to you." And then you've got to get back to them. You got to offer a respectful explanation of why you disagree. And it's tempting to feel like a disagreement poses a risk to our relationships, but it's not disagreement that poses a risk to our relationships. It's unspoken disagreement. Many, I don't know about you Lenny, but a lot of my best professional relationships began with a good respectful disagreement.

**中文翻译:**
所以你要做的是，从对方说的话中找出那 5% 或 10% 你能认同的部分，并表达出来。然后你要说：“至于剩下的部分，我想思考一下再回复你。”然后你必须真的回复他们。你需要对你的不认同给出一个尊重的解释。人们很容易觉得分歧会危及人际关系，但真正危及关系的不是分歧本身，而是“未说出口的分歧”。莱尼，我不知道你怎么样，但我很多最好的职场关系都是从一次良好且尊重的分歧开始的。

---

### [00:47:51] Lenny

**English:**
Interesting. That reminds me of just watching Squid Games, the reality show on Netflix. Yeah. Have you seen this at all?

**中文翻译:**
有意思。这让我想起了 Netflix 上的真人秀《鱿鱼游戏》。你看过吗？

---

### [00:47:56] Kim Scott

**English:**
I haven't watched it, but it's on my list.

**中文翻译:**
还没看，但在我的清单上。

---

### [00:47:59] Lenny

**English:**
There's this guy who makes a huge bad decision on behalf of his whole team and they hate him in the show. And then on TikTok, he shared that they're best friends now, even though they called him a big idiot.

**中文翻译:**
里面有个家伙代表整个团队做了一个巨大的错误决定，节目里大家都恨死他了。但后来他在 TikTok 上分享说，他们现在是最好的朋友，尽管当时大家都骂他是大白痴。

---

### [00:48:09] Kim Scott

**English:**
Yeah, no.

**中文翻译:**
是啊，没错。

---

### [00:48:09] Lenny

**English:**
So funny.

**中文翻译:**
太逗了。

---

### [00:48:10] Kim Scott

**English:**
It can happen for sure.

**中文翻译:**
这种情况确实会发生。

---

### [00:48:12] Lenny (Sponsor Message - Repeated)

**English:**
You fell in love with building products for a reason, but sometimes the day-to-day reality is a little different than you imagined... (Full sponsor text repeated)

**中文翻译:**
你爱上打造产品是有原因的，但有时日常现实与你的想象略有不同……（赞助商信息重复，略）

---

### [00:49:32] Lenny

**English:**
So to recap the steps roughly for how to get feedback from people, it's ask your question like what's one thing I could have done this week to make you more successful? Wait six seconds potentially or try to, it's very hard. Ask a few follow-up questions to make sure you understand what they're saying and then find a way to reward them. Say thank you.

**中文翻译:**
所以粗略概括一下获取反馈的步骤：问你的问题，比如“这周我做哪件事能让你更成功？”；等待六秒钟，或者尽量尝试，这很难；问几个后续问题确保你理解了对方的意思；然后想办法奖励他们。说声谢谢。

---

### [00:49:53] Kim Scott

**English:**
Do more than say thank you.

**中文翻译:**
做的要比说谢谢更多。

---

### [00:49:55] Lenny

**English:**
Especially if you disagree, which is a really interesting nuance of this. I had Jules Walter on the podcast. I always think of him when I think of getting feedback. He shared this advice. When you get feedback, just be so appreciative so that people keep giving me just like, "Thank you so much for that feedback." The way he phrases it. Even if you're melting inside and really hate this feedback, just like, "thank you, I really appreciate it." But I think your nuance there is really key is if you do disagree, I really like this tip of just like, let me think about this element of it and then actually follow up.

**中文翻译:**
特别是如果你不认同的时候，这是一个非常有趣的细节。我曾邀请朱尔斯·沃尔特（Jules Walter）上过播客，想到获取反馈我总会想到他。他分享过这个建议：当你收到反馈时，表现得非常感激，这样人们才会继续给你反馈，就像他说的那样：“非常感谢你的反馈。”即使你内心在崩溃，非常讨厌这个反馈，也要说：“谢谢，我真的很感激。”但我认为你提到的细节很关键：如果你真的不认同，我非常喜欢这个技巧——“让我考虑一下这部分内容”，然后真的去跟进。

---

### [00:50:25] Kim Scott

**English:**
Even if you're melting inside, if you say thank you and you're melting inside, I mean maybe it's a terrible actor, but usually people know. And that's why I say it's not enough to say thank you. You got to fix the problem and then show what you did to fix the problem and get more feedback. Did I over-correct? Did I under-correct. And if you disagree, you got to say that you disagree, but you got to say, so respectfully.

**中文翻译:**
即使你内心在崩溃，如果你一边说谢谢一边崩溃，除非你是个极烂的演员，否则人们通常能感觉得到。这就是为什么我说仅仅说谢谢是不够的。你必须解决问题，展示你为了解决问题做了什么，然后获取更多反馈：“我修正过度了吗？还是不够？”如果你不认同，你必须说出来，但要说得非常尊重。

---

### [00:50:48] Lenny

**English:**
As a leader, this sounds like a lot of work to be doing every week. If you have a one-on-one following up correcting things. Is there anything you'd recommend there? Or is it just, this is really important, you got to make time.

**中文翻译:**
作为领导者，这听起来每周都有大量工作要做。如果你要在 1对1 面谈中跟进并纠正事情。你有什么建议吗？还是说，这真的很重要，你必须挤出时间？

---

### [00:50:58] Kim Scott

**English:**
It's not as much work as failing to do this as we saw from the Bob story. So I think that the important thing that I have found is that this is part of why it's so important to do it immediately. It's important for the other person, but it's also important for you. If you're doing this in a one-on-one, which you should be having anyway. So you're saving some time in a one-on-one. So it's not adding time necessarily to your day. And when you hear about problems, you should fix them. Yes, it takes time, but that is your job. And when you disagree with something, you can disagree in your next regularly scheduled one-on-one. So I'm not talking about adding meetings to your calendar, so it doesn't actually take more time. I have found that in fact, it saves tremendous amounts of time, but it does take emotional discipline.

**中文翻译:**
这不像没做到位那么费事，就像我们在鲍勃的故事里看到的那样。所以我发现最重要的一点是，这就是为什么“立即行动”如此重要。这对对方很重要，对你也同样重要。如果你在 1对1 面谈中做这件事（反正你本来也要开这个会），你其实是在节省时间，而不是在增加额外的时间。当你听到问题时，你应该解决它们。是的，这需要时间，但这就是你的工作。当你不同意某事时，你可以在下一次例行的 1对1 面谈中提出。所以我不是在说要在你的日程表上增加会议，它实际上不会占用更多时间。我发现，事实上它节省了大量时间，但它确实需要“情绪自律”。

---

### [00:51:52] Kim Scott

**English:**
And I think it also requires you, especially when it comes to giving it, which we talked about before, where the humble, helpful, those are impromptu two-minute conversations, giving the feedback that you should be having in between your meetings. In the um story, walk to my meeting with me, it didn't take any extra time for my boss to give me that feedback. She had to walk to her meeting anyway, and I had to go in the same direction. So it didn't even take extra time from me. But it is, I think one of the most common reasons why people don't do this in addition to fear of retaliation and just sort of existential dread, which are both factors, which hopefully we've helped alleviate, but is that you're scheduled back to back to back and you don't have those two minutes in between meetings.

**中文翻译:**
我认为这也要求你——特别是在给出反馈时，就像我们之前讨论的，谦逊、助人，这些都是即兴的两分钟对话——在会议间隙给出反馈。在那个“嗯”的故事里，老板让我陪她走回办公室，给她反馈并没有花费额外时间。她反正也要走回办公室，我也顺路。所以甚至没占用我的额外时间。但我认为，除了担心报复和某种“存在主义恐惧”（这两个因素我们希望能帮你缓解）之外，人们不做这件事最常见的原因是：你的日程排得太满了，会议一个接一个，你连会议间隙那两分钟都没有。

---

### [00:52:42] Kim Scott

**English:**
And that's why I think it's important either to schedule slack time in your calendar, make your 30 minute meetings, 25 minute meetings, make your hour-long meetings, 50 minute meetings, maybe give yourself a few breaks in the day. But if it's not possible, and often it was not possible for me in my career to sort of schedule my time that way, I just decided that these moments of management were more important than being on time to my next meeting. And so I was just late sometimes. So I wish I had a better answer than either control your time, which is really annoying advice because it's impossible to follow or be willing to be late to your next meeting. But those were the things that I tried to do.

**中文翻译:**
这就是为什么我认为在日程表中安排“缓冲时间”很重要。把 30 分钟的会议改成 25 分钟，把一小时的会议改成 50 分钟，给自己留点空隙。但如果做不到——在我的职业生涯中，经常无法那样安排时间——我就会决定，这些“管理时刻”比准时参加下一个会议更重要。所以我有时会迟到。我希望我有比“控制你的时间”（这建议很烦人，因为很难做到）或“愿意在下一个会议迟到”更好的答案，但这些确实是我尝试去做的事。

---

### [00:53:34] Lenny

**English:**
That was super helpful. I think your point of just, if you're not making two minutes to do this thing now, it'll be a lot more time intensive later.

**中文翻译:**
这非常有帮助。我觉得你的核心观点是：如果你现在不花两分钟做这件事，以后会耗费更多时间。

---

### [00:53:40] Kim Scott

**English:**
Oh yeah. It's stitch in time takes nine on all these two minute, and really it should be brushing and flossing. This is not like a root canal. These are like, this is relationship hygiene that you should be doing all the time.

**中文翻译:**
噢是的。这就是“及时一针省九针”。这些两分钟的小事就像刷牙和用牙线。这不像做根管治疗，这是你应该一直做的“人际关系卫生”。

---

### [00:53:55] Lenny

**English:**
I was just reading Charlie Munger's book and there's a quote that he references of just the classic, an ounce of prevention is worth a pound of cure.

**中文翻译:**
我刚读了查理·芒格的书，他引用了一句经典名言：“一盎司的预防胜过一磅的治疗。”

---

### [00:54:03] Kim Scott

**English:**
Yes, absolutely.

**中文翻译:**
是的，绝对如此。

---

### [00:54:04] Lenny

**English:**
Same idea. So we've talked about a leader getting feedback. What if you're the employee? Do you also recommend the same thing in the one-on-one, have an agenda item and ask this question? Or is there a different approach you'd recommend?

**中文翻译:**
同样的道理。我们聊了领导者如何获取反馈。那如果你是员工呢？你也建议在 1对1 面谈中加入一个议程项并问这个问题吗？还是你有其他推荐的方法？

---

### [00:54:16] Kim Scott

**English:**
I think yes, if you're the employee, you should also be soliciting feedback on a regular basis from your boss. So there's sort of an order of operations you want to solicit at first, no matter who you are, it's the same up, down, and sideways, even though it feels very different, the order of operations is the same. So start by soliciting feedback. Then you want to give both praise and criticism. I think sometimes it feels like you're kissing up if you give your boss praise, but bosses need praise too. And if there are things that your boss does that you appreciate and you want your boss to do more of those things, praise is a better tool for that than criticism.

**中文翻译:**
我想是的。如果你是员工，你也应该定期向老板征求反馈。这有一套操作顺序：无论你是谁，向上、向下还是横向，顺序都是一样的，尽管感觉可能大不相同。首先从征求反馈开始。然后，你要给出赞美和批评。我认为有时给老板赞美会让人觉得是在拍马屁，但老板也需要赞美。如果老板做的某些事是你欣赏的，并且你希望老板多做这些事，赞美是比批评更好的工具。

---

### [00:55:09] Kim Scott

**English:**
When it comes time to offering your boss some critical feedback, you want to make sure, and by the way, this is also true when it comes time to give your employee critical feedback or your spouse or anybody else in your life, you want to be sure that you are prepared to gauge how it lands. So you want to start in kind of a neutral place. You don't want to go to the outer edge of challenge directly because then you're going to wind up in obnoxious aggression. So if we go back to that story, my boss started, "You said um a lot, were you aware of it?" "Nah." That was my response. And then "I know this great speech coach, would you like an introduction?" "Nah," was my response. So she had to keep going out on that challenge directly.

**中文翻译:**
当轮到给老板提供批评性反馈时——顺便说一下，给员工、配偶或生活中任何其他人反馈时也是如此——你要确保你准备好观察对方的反应。你要从一个相对中立的地方开始。你不想直接冲到“直接挑战”的最边缘，因为那样你会陷入“令人厌恶的侵略性”。回到那个故事，我老板开始问：“你说了好多‘嗯’，你意识到了吗？”我的回答是“没”。然后她说：“我认识一个很棒的演讲教练，要介绍吗？”我的回答还是“没”。所以她不得不继续加强“直接挑战”的力度。

---

### [00:55:51] Kim Scott

**English:**
She didn't start out by saying, "When you say um I'm every third word, it makes you sound stupid." But she realized she had to go that far. So you want to keep going out if you think they're brushing you off. But if you find that your boss looks either sad or mad, that is your cue to move up on the care personally dimension. And so to take a moment, and if you find your employee looks sad or mad, if they look sad, pause and say, "I feel like maybe I didn't say that in the best possible way. How could I have said it differently?" And so that means you're going up on the care personally, dimension, but you're not going the wrong way on challenge directly.

**中文翻译:**
她一开始并没有说：“当你每三个词就说一个‘嗯’时，这让你听起来很蠢。”但她意识到她必须说到那个份上。所以如果你觉得对方在敷衍你，你就要继续加强力度。但如果你发现老板看起来很难过或很生气，那就是你的信号，该转向“个人关心”维度了。花点时间，如果你发现员工看起来很难过或很生气——如果他们很难过，停下来并说：“我觉得我刚才的表达方式可能不是最好的。我该怎么说才更好呢？”这意味着你在加强“个人关心”，但并没有在“直接挑战”上退缩。

---

### [00:56:34] Kim Scott

**English:**
I don't know about you Lenny, but if I say something to someone and they look sad, it's so tempting for me to try to pull the words back. "Oh no, it's no big deal. I didn't mean it," but it is a big deal, and I did mean it, that's why I just said it. And so if you go the wrong way on challenge directly, you wind up in ruinous empathy, and then you leave the person both sad and confused, so you make it worse. So you want to take a beat to pay attention to the emotions in the moment, but not to go the wrong way on challenge directly. Same thing if they're mad, although if somebody's mad, that maybe is even harder. If somebody starts yelling at me, it's tempting for me either to start yelling back and wind up in obnoxious aggression or to crawl off to a self-protective, manipulative insincerity. And so instead, what I try to do is get curious, not furious, and why is this person so mad? So say like, Look, maybe I didn't say that in the right way, but this is an important issue and we need to resolve it.

**中文翻译:**
莱尼，我不知道你怎么样，但如果我对某人说了什么而他们看起来很难过，我非常想把话收回来。“噢不，没什么大不了的，我不是那个意思。”但那确实是件大事，我确实是那个意思，这就是为什么我刚才说了。如果你在“直接挑战”上退缩，你就会陷入“毁灭性同理心”，让对方既难过又困惑，情况反而更糟。所以你要停顿一下，关注当下的情绪，但不要在挑战维度上走错方向。如果他们生气了也一样，虽然处理愤怒可能更难。如果有人对我大吼大叫，我很容易也吼回去（陷入侵略性），或者退缩到自我保护的“虚伪操纵”中。相反，我尝试做的是“保持好奇，而非愤怒”：为什么这个人这么生气？然后说：“听着，也许我刚才说的方式不对，但这是一个重要的问题，我们需要解决它。”

---

### [00:57:14] Lenny

**English:**
This comes back to the point you made about when you're giving feedback to try to do it in person or on a phone call to do exactly what you're saying, to read them as you're giving this feedback and figure out which axis you want to go down.

**中文翻译:**
这回到了你之前提到的观点：给反馈时尽量当面或通过电话，正是为了做到你刚才说的——在给反馈时读懂对方，并决定该往哪个轴向调整。

---

### [00:57:25] Kim Scott

**English:**
Yeah, you want to gauge it. I mean, when we communicate with other people, we communicate on an emotional level and on an intellectual level at the same time. And if we ignore the emotional signals that are coming at us or say don't take it personally, then we're just not going to communicate very well.

**中文翻译:**
是的，你要观察反应。我的意思是，当我们与他人交流时，我们是同时在情感层面和理智层面进行交流的。如果我们忽视了传来的情感信号，或者说“别往心里去”，那我们就无法进行良好的沟通。

---

### [00:57:43] Lenny

**English:**
Along these same lines, another question that came in is from a coach of yours that works I think for you or somehow with the program. She asked this question of many top leaders have very low self-awareness. They believe obnoxious aggression is the only way to give feedback, or they just ignore the problem and fire people with no feedback. Is there something you've learned about how to change their mind about this is the way to operate?

**中文翻译:**
顺着这个思路，另一个问题来自你的一位教练，我想她是为你工作或参与了你的项目。她问：很多顶尖领导者的自我意识非常低。他们认为“令人厌恶的侵略性”是给出反馈的唯一方式，或者干脆忽视问题，然后在没有任何反馈的情况下解雇员工。关于如何改变他们对这种运作方式的看法，你学到了什么吗？

---

### [00:58:05] Kim Scott

**English:**
Yeah, I think the most important thing with leaders like that, that you can do is to explain to them the impact that they're having and to also show them that there is another way that is going to help them succeed. Very often the leaders who are low on the care personally dimension, they do care about their results and they do care about their own careers. And so when you sort of explain this to them in terms of enlightened self-interest, they tend to get better at it. And also, I mean there I can think of maybe one or two people I've worked with who are truly low on care, who truly don't care. Very often people are bad at showing they care, but they do actually care. And also sometimes there are leaders who think they're not supposed to care. And so unleashing that capacity that they innately have to care and telling them this is actually part of the job can make them a much better, more effective leader. But look, if someone is a psychopath and they truly don't care, they shouldn't be a manager. That's the solution.

**中文翻译:**
是的，我认为对这类领导者来说，你能做的最重要的事情就是向他们解释他们产生的影响，并向他们展示还有另一种方式能帮助他们成功。通常，那些在“个人关心”维度得分较低的领导者，他们确实关心结果，也关心自己的职业生涯。所以当你从“开明的自利”（Enlightened Self-interest）角度向他们解释时，他们往往会做得更好。而且，我能想到的真正缺乏关怀、真正不在乎的人可能也就一两个。通常人们只是不擅长表现出关心，但内心其实是在乎的。还有些领导者认为自己“不应该”表现出关心。因此，释放他们天生具备的关怀能力，并告诉他们这其实是工作的一部分，可以让他们成为更好、更高效的领导者。但听着，如果某人是个反社会人格，真的完全不在乎，那他就不该当经理。这就是解决方案。

---

### [00:59:27] Lenny

**English:**
I totally get that one. So I really like that takeaway. Just basically show them the impact they're having because to your point, they want the company to succeed. They want their team to succeed. And if they're not realizing there's downsides to the way they're operating.

**中文翻译:**
我完全理解。我很喜欢这个结论。基本上就是向他们展示他们产生的影响，因为正如你所说，他们希望公司成功，希望团队成功。如果他们没意识到自己的运作方式有副作用……

---

### [00:59:38] Kim Scott

**English:**
And they want themselves to succeed. That's why I say part of the problem with obnoxious aggression is that you harm other people, but it's also inefficient because when you act like that, people can't hear what you're saying, so you're wasting your breath.

**中文翻译:**
而且他们希望自己成功。这就是为什么我说“令人厌恶的侵略性”的部分问题在于你伤害了他人，但它也是低效的，因为当你那样做时，人们听不进你在说什么，你是在白费口舌。

---

### [00:59:56] Lenny

**English:**
And the way you show them that impact. Do you recommend interviewing people, getting stories, seeing, I don't know, how do you collect this impact so that they're like, oh, wow, I didn't realize this.

**中文翻译:**
那你如何向他们展示这种影响？你建议访谈员工、收集故事吗？我不知道，你如何收集这些影响，好让他们感叹：“噢哇，我以前没意识到这一点”？

---

### [01:00:07] Kim Scott

**English:**
I think that the best thing to do is, for me anyway, is I start by sharing stories from my career and stories when I was a jerk. I've acted like a jerk too, plenty of times, unfortunately. And I show the impact that I've had and then I ask them for a similar story. And usually sort of me holding up the mirror to myself is useful for them to be able to hold the mirror up to themselves to realize you want to help these people adopt a growth mindset around this stuff. I am not telling you that you're an asshole. I'm telling you that we all behave like assholes sometimes. And it's a big problem for us as well as for the people around us. And here's my story, when I acted like a jerk, what's yours? And people, that kind of self-awareness, sometimes people talk about inflicted insight like it's some kind of burden, but usually that kind of self-awareness makes people feel lighter. They're like, "Ah, now I know what's wrong and now I know what I can do about it."

**中文翻译:**
我认为最好的做法——至少对我来说——是先分享我职业生涯中的故事，分享我表现得像个混蛋的时候。不幸的是，我也曾多次表现得像个混蛋。我会展示我产生的影响，然后问他们是否有类似的故事。通常，我对自己“照镜子”的行为能帮助他们也对自己“照镜子”，从而意识到你想帮助他们在这些事情上建立成长型思维。我不是在说你是个混蛋，我是在说我们有时都会表现得像个混蛋。这对我们自己和周围的人都是个大问题。这是我的故事，当我表现得像个混蛋时，你的故事是什么？这种自我意识——有时人们把“强加的洞察”看作负担，但通常这种自我意识会让人们感到轻松。他们会觉得：“啊，现在我知道哪里出问题了，也知道该怎么做了。”

---

### [01:01:14] Lenny

**English:**
Yeah, I've definitely noticed that about your stories. They always are you making the mistake, which I think is very disarming.

**中文翻译:**
是的，我确实注意到你的故事总是关于你自己犯错，我觉得这非常能消除别人的戒心。

---

### [01:01:20] Kim Scott

**English:**
We all make mistakes.

**中文翻译:**
我们都会犯错。

---

### [01:01:22] Lenny

**English:**
Yeah. Maybe the extreme of this obnoxious aggressiveness is Bridgewater. Their whole approach is like theirs.

**中文翻译:**
是的。也许这种“令人厌恶的侵略性”的极端例子就是桥水基金（Bridgewater）。他们的整套方法论就像是那样。

---

### [01:01:31] Kim Scott

**English:**
Oh my gosh. Did you read the book The Fund?

**中文翻译:**
噢天哪。你读过《基金》（The Fund）那本书吗？

---

### [01:01:34] Lenny

**English:**
No, not yet.

**中文翻译:**
还没。

---

### [01:01:35] Kim Scott

**English:**
You must read it. It's all about Bridgewater. I always thought it was problematic. I had no idea just how problematic it is. Put that book in the show notes one of the best business books I've read in the last decade.

**中文翻译:**
你一定要读读。全是关于桥水的。我一直觉得它有问题，但我没想到问题竟然这么大。把那本书放在节目介绍里，那是我过去十年读过的最好的商业书籍之一。

---

### [01:01:48] Lenny

**English:**
Wow, that is high praise. Yes, I will read that. And so I guess for people that aren't familiar, like Bridgewater, they encourage, they have a system called Dots where they tell people, you must give hard critical feedback after every meeting, publicly.

**中文翻译:**
哇，这评价很高。我会去读的。我想对于那些不熟悉的人来说，桥水鼓励——他们有一套叫“点数”（Dots）的系统，要求人们必须在每次会议后公开给出严厉的批评性反馈。

---

### [01:02:01] Kim Scott

**English:**
Not after the meeting, in the meeting, publicly. And it's recorded on, it was, I think they changed it since, but it was recorded for posterity on video. And sometimes, in fact, true story, shortly after I left Google, I was approached to work at Bridgewater in a management capacity, not in an investment capacity. And so I called someone I knew who worked there and he said, "Let me give you an anecdote." He said, "The other day there was a meeting and there was a woman who in the meeting who had made a mistake and everybody just piled on. The criticism was very personal. There was no core about the criticism. It was like, these are your personality attributes that make you a useless human being. Kind of terrible feedback until she started to cry and the whole meeting was recorded and then they emailed a recording of the meeting out to the whole company, including all the people who were not in the meeting saying, this is an example of how to have..." So I would say that is deep, dark, obnoxious aggression. That is not radical candor. That is horrible.

**中文翻译:**
不是会议后，是“在会议中”公开给。而且会被录下来——我想他们后来改了，但以前是为了留存而录像。事实上，这是一个真实的故事：在我离开谷歌后不久，有人找我去桥水做管理工作，不是投资。我打电话给一个在那儿工作的朋友，他说：“我给你讲个轶事吧。”他说：“前几天有个会，会上有一个女性犯了错，结果所有人一拥而上。批评非常针对个人，完全没有遵循 CORE 框架。就像是说‘这些性格缺陷让你成了一个没用的人’。这种糟糕的反馈一直持续到她开始哭泣，而整个会议都被录了下来，然后他们把录像发给了全公司，包括没参会的人，说‘这是一个如何进行……的范例’。”所以我会说，那是深层的、黑暗的“令人厌恶的侵略性”。那不是“彻底坦诚”，那是恐怖。

---

### [01:03:24] Lenny

**English:**
So it's safe to say you're not a fan of that approach?

**中文翻译:**
所以可以肯定地说，你并不推崇那种方法？

---

### [01:03:26] Kim Scott

**English:**
No. In fact, I did an analysis of Dalio's book Principles and it's like a, I don't know, 3 or 400 page book. And there were I think four or five pages about caring about people. There's very low care personally.

**中文翻译:**
不推崇。事实上，我分析过达利欧（Ray Dalio）的《原则》（Principles），那是一本三四百页的书，但关于“关心他人”的内容大概只有四五页。那里的“个人关心”程度非常低。

---

### [01:03:44] Lenny

**English:**
I imagine many people see that, they see Elon, they see Steve Jobs, and the perception is they're very challenge directly people, they're not clearly care about you people, but they're very successful. What do you say to people that are like, but it works. Why wouldn't I be that if that's the way I want to do it?

**中文翻译:**
我想很多人看到这些，看到马斯克，看到乔布斯，感觉他们都是那种“直接挑战”的人，而不是那种“关心你”的人，但他们非常成功。对于那些说“但这很有效啊，如果我想这么做，为什么不学他们？”的人，你会怎么说？

---

### [01:04:00] Kim Scott

**English:**
Well, first of all, I would not put Steve Jobs in the same category as Ray Dalio and Elon Musk. I mean, Steve Jobs could be obnoxiously aggressive, but mostly I would say he built such good relationships with his direct reports that when he got cancer, Tim Cook offered to give him half his liver. And I don't know of a word to describe that other than love. These were real human relationships. When I worked at Apple, you could see Steve and Johnny talking. You could tell these people cared about each other. Now, radical candor gets measured not at the speaker's mouth, but at the listener's ear. And I think that Steve had built a team around him of people who didn't mind rather what other people would consider obnoxious aggression. But I think in the context of their relationship, it was understood as care.

**中文翻译:**
首先，我不会把史蒂夫·乔布斯和瑞·达利欧、埃隆·马斯克归为一类。我的意思是，乔布斯有时确实会表现出“令人厌恶的侵略性”，但我想说，他与直接下属建立了非常深厚的关系，以至于当他患癌时，蒂姆·库克（Tim Cook）甚至提出要分一半肝脏给他。除了“爱”，我找不到别的词来形容这种关系。那是真正的人际关系。我在苹果工作时，能看到史蒂夫和乔尼（Jony Ive）交谈，你能感觉到这些人是彼此关心的。现在，“彻底坦诚”的衡量标准不在于说话者的嘴，而在于听者的耳朵。我认为史蒂夫在他周围建立了一个团队，这些人并不介意别人眼中的“侵略性”，因为在他们的关系语境中，那被理解为关怀。

---

### [01:05:44] Kim Scott

**English:**
I'll give you an example of that from my own career, not that I am comparing myself to Steve Jobs, I think I'm a much gentler person, but sometimes I develop relationships with people. And part of that relationship is that we push each other pretty hard. So there was a person who I had worked with for a long time, for many years. He had followed me from one company to another, and we were localizing a product and he kept conflating Slovakia and Slovenia, and I corrected him once. I corrected him twice the third time, I was like, did Slovakia, not Slovenia dumb ass. And he started laughing, and that was fine in the context of our relationship, but I realized that the people around me, I was silencing them. They were like, "Oh my gosh, I don't want to make a mistake. Kim's going to call me a dumb ass."

**中文翻译:**
我从自己的职业生涯中举个例子——并不是要把自己比作乔布斯，我觉得我是个温和得多的人——但有时我会和某些人建立起一种互相逼得很紧的关系。有一个和我共事多年的同事，他跟着我换了好几家公司。有一次我们在做产品本地化，他总是把斯洛伐克和斯洛文尼亚搞混。我纠正了他一次，两次，第三次时我说：“是斯洛伐克，不是斯洛文尼亚，你个笨蛋。”他笑了起来，这在我们的关系中是没问题的。但我意识到，周围的人被我吓得不敢出声了。他们会想：“噢天哪，我可不想犯错，金会骂我是笨蛋的。”

---

### [01:06:19] Kim Scott

**English:**
So I had to pause and say, "Look, I respect this person enormously, and I like this person enormously. We work very well together." And so I think that sometimes people have relationships with others and they have those relationships in public and other people misinterpret those relationships. Steve Jobs was not perfect. He made all kinds of mistakes, but he was no Ray Dalio or Elon Musk, who I would say make far more and worse and more egregious mistakes. And I think you're raising a really important point. You're raising a point, which is that there's this false dichotomy. In fact, the new biography of Elon Musk falls into this category. I like Walter Isaacson's work a lot, but he falls prey to this in his biography of Elon Musk, which is there's this notion that we have to choose between being a total jerk but really competent or really nice but incompetent. And those are not our two choices. That's the whole point of radical candor is that there's this other way that works better and doesn't hurt people.

**中文翻译:**
所以我不得不停下来解释：“听着，我非常尊重这个人，也非常喜欢他，我们合作得非常好。”我认为有时人们在公共场合展现出的关系会被旁人误解。乔布斯并不完美，他犯过各种错误，但他不是达利欧或马斯克，我认为后两者犯的错误要多得多、严重得多。你提出了一个非常重要的观点，即存在一种“虚假的二分法”。事实上，马斯克的新传记就陷入了这个误区。我很喜欢沃尔特·艾萨克森（Walter Isaacson）的作品，但他在马斯克传记中也落入了这种观念：我们必须在“做一个有能力但彻头彻尾的混蛋”和“做一个平庸但大好人”之间做选择。但这并不是仅有的两个选项。“彻底坦诚”的核心意义就在于，存在第三条路，它更有效且不会伤害他人。

---

### [01:07:13] Lenny

**English:**
I think that's the key takeaway there is you can be even more successful if you lean into the care deeply. In theory, they could have gotten more out of their people if they made it clear they really care about them.

**中文翻译:**
我认为关键的启示是：如果你能做到深切关心，你可以变得更加成功。理论上，如果他们能明确表达对员工的关心，他们本可以从员工身上获得更多。

---

### [01:07:26] Kim Scott

**English:**
And there's plenty of counter examples of incredibly successful people who are very caring leaders, and it's not as much fun to tell stories about that. And so we don't as often.

**中文翻译:**
而且有很多反例，那些极其成功的领导者同时也是非常关怀他人的领导者。只是讲这类故事没那么“刺激”，所以我们讲得没那么频繁。

---

### [01:07:40] Lenny

**English:**
Along the same lines, there's someone that you worked with that suggested I ask you about investing in your authentic leadership style, Melissa Tan. I don't know if you remember her.

**中文翻译:**
顺着这个话题，有一位曾与你共事的人建议我问问关于“投资于你真实的领导风格”的问题，她叫梅丽莎·谭（Melissa Tan）。不知道你还记不记得她。

---

### [01:07:50] Kim Scott

**English:**
Yes.

**中文翻译:**
记得。

---

### [01:07:51] Lenny

**English:**
Okay, great. And she was on the podcast in the past, and she just said how when she met you, she was a very people-pleasery person and just wanted to be like, and you helped her develop her natural leadership style. Can you just talk about what you suggest to people to figure this out and how to find that for yourself?

**中文翻译:**
太好了。她以前也上过这个播客，她说她遇到你时是一个非常严重的“讨好型人格”，只想被人喜欢，而你帮助她发展出了她自然的领导风格。你能谈谈你建议人们如何去发现并找到属于自己的领导风格吗？

---

### [01:08:06] Kim Scott

**English:**
I mean, I wonder what Melissa would say, but my memory of conversations with her, and this is an issue that I talk about a lot because a people pleaser too. I grew up in the South and I'm a woman. I was not brought up to challenge directly. That was not part of the culture that I was brought up in. I was brought up to be polite but also brought up to be kind. And for me, the thing that is most important to hang on to is that fundamental kindness and to realize that it's actually unkind not to say the thing. And so that is part of the reason why I encourage people. I tell the Bob story so often and I encourage other leaders who I work with to think about what their Bob story is that you realize it's not nice in the long run.

**中文翻译:**
我想知道梅丽莎会怎么说，但在我记忆中与她的对话里——这也是我经常谈论的话题，因为我也是个“讨好者”。我在南方长大，又是女性，我从小接受的教育不是“直接挑战”。那不是我成长文化的一部分。我被教导要礼貌，也要善良。对我来说，最重要的一点是坚持那种基本的善良，并意识到“不把话说出来”实际上是不善良的。这就是为什么我经常讲鲍勃的故事，并鼓励我合作的其他领导者去思考他们的“鲍勃故事”——你会意识到，从长远来看，不坦诚一点也不友好。

---

### [01:09:00] Kim Scott

**English:**
It's unkind in the long run, not to tell someone if they're making a mistake. There's nothing nice about that in the long run. And so that I think at least for me, that's been helpful. And then another thing that is helpful is again, to get others focused, to focus not on pleasing people, but on doing the right thing for those people, on truly caring about those people more than you care about your own discomfort in the moment. And that is something that is easier for people to do than just to challenge directly. I think in many ways it's about what is getting in the way. That's why I call it ruinism. Empathy is a good thing, but sometimes empathy can paralyze at least me because I'm so acutely aware of how what I'm going to say might impact the other person, might hurt their feelings that I don't say it.

**中文翻译:**
如果某人犯了错却不告诉他，长远来看是不仁慈的。这其中没有任何友善可言。我觉得至少对我来说，这很有帮助。另一件有帮助的事是再次强调“关注他人”：不是关注如何取悦他人，而是关注如何为他们做正确的事，真正关心他们，胜过关心你当下的不适感。这对人们来说比单纯的“直接挑战”更容易做到。我认为在很多方面，问题在于是什么阻碍了我们。这就是为什么我称之为“毁灭性”。同理心是好事，但有时同理心会让我瘫痪，因为我太敏锐地意识到我说的话可能会如何影响对方、伤害对方的感情，以至于我闭口不言。

---

### [01:10:01] Kim Scott

**English:**
And so when I push myself to be, and you can call it compassionate candor if you like that better than radical candor. But when I push myself not to feel so acutely what I think the other person might feel, and by the way, I could be wrong about what I think the other person might often, they're like, it's no big deal. They're like, oh, thank you for letting me know. But when I can let go of that and think about the other person and what I care about and what they care about for their future, going back to your point, if you know that it's really important for someone to get promoted and they won't get promoted if they keep talking to people in a particular way, then you're focused on what they want. That is really helpful to move past that.

**中文翻译:**
所以当我强迫自己变得——如果你觉得“彻底坦诚”不好听，可以叫它“慈悲的坦诚”。当我强迫自己不要那么强烈地去感同身受我“认为”对方会有的感受时（顺便说一下，我经常想错，对方往往觉得没什么大不了，甚至会说“谢谢你告诉我”）。当我能放下这些，转而思考对方、思考我所关心的以及他们所关心的未来时——回到你的观点，如果你知道晋升对某人很重要，而如果他继续以某种方式与人交流就无法获得晋升，那么你就专注于“他想要的”。这对于克服障碍非常有帮助。

---

### [01:10:47] Lenny

**English:**
Just a few more questions before we wrap up. Your book sold something like half a million copies.

**中文翻译:**
在结束前还有几个问题。你的书卖了大约 50 万册？

---

### [01:10:47] Kim Scott

**English:**
A million now.

**中文翻译:**
现在是 100 万册了。

---

### [01:11:00] Lenny

**English:**
A million copies. 23 languages. Jesus Christ. So a lot of people have read it, a lot of people have been using it. What's something that people often just get wrong that super frustrates you about the system, the recommendations that you just wish people come on, here's what I really wanted to say, or here's what you should change.

**中文翻译:**
100 万册，23 种语言。天哪。所以很多人读过它，很多人在使用它。关于这套系统或建议，人们经常搞错什么让你感到非常沮丧？你最希望人们明白什么，或者希望他们改变什么？

---

### [01:11:17] Kim Scott

**English:**
There's two things. I mean, as I mentioned earlier, when you write about a book about feedback, you're going to get a lot of it. One is this, in the spirit of Radical Candor and then the person acts like a jerk. That is not the spirit of Radical Candor. That is the spirit of obnoxious aggression. But shortly after the book came out, I was giving a talk at a tech company in San Francisco and I got some feedback from the CEO of that company that was so impactful that it caused me to write my next book, which is called Radical Respect. And in many ways, Radical Respect is kind of the prequel to Radical Candor because if you don't respect the other person, it's impossible to care about them and you're not going to bother challenging them directly.

**中文翻译:**
有两件事。正如我之前提到的，写一本关于反馈的书会让你收到很多反馈。第一件就是那种“本着彻底坦诚的精神……”然后表现得像个混蛋。那不是“彻底坦诚”，那是“令人厌恶的侵略性”。但在书出版后不久，我在旧金山一家科技公司演讲，收到了那位 CEO 的反馈，那次反馈影响深远，促使我写了下一本书《彻底尊重》（Radical Respect）。在很多方面，《彻底尊重》像是《彻底坦诚》的前传，因为如果你不尊重对方，你就不可能关心他们，也就不会费心去直接挑战他们。

---

### [01:12:04] Kim Scott

**English:**
What happened in this meeting? I walked in, I was really excited to give this talk. The CEO had been a colleague of mine for the better part of a decade. She's a person I like and respect enormously, and she's one of too few black women CEOs in tech or in any other sector. And when I finished giving the talk, she pulled me aside and she said, "Kim, I'm excited to roll out Radical Candor. I think it's really going to help me build the kind of career I want." But she said, "I got to tell you, it's much harder for me to roll it out than it is for you." And she went on to explain to me that as soon as she would offer folks even the most gentle, compassionate criticism, they would call her an angry black woman.

**中文翻译:**
那次会议发生了什么？我走进去，非常兴奋地准备演讲。那位 CEO 曾是我近十年的同事，我非常喜欢并尊重她，她是科技界乃至任何领域中为数不多的黑人女性 CEO 之一。演讲结束后，她把我拉到一边说：“金，我很兴奋能推行‘彻底坦诚’，我觉得它能帮我建立我想要的职业生涯。”但她说：“我必须告诉你，我推行它要比你难得多。”她接着解释说，只要她给别人哪怕是最温和、最富有同情心的批评，人们就会称她为“愤怒的黑人女性”。

---

### [01:12:49] Kim Scott

**English:**
And I knew this was true as soon as she said it, and I knew how unfair it was because she's like one of the most even keeled, cheerful people I've ever worked with. And I realized a bunch of things at the same time when she told me that, the first was that I had not been the kind of colleague that I aspire to be, that I imagined myself to be. I had failed even to notice the extent to which she had to show up unfailingly, cheerful and pleasant in every meeting we had ever been in together even though she had what to be ticked off about as we all do at work. So I had failed to be an upstander, a good colleague.

**中文翻译:**
她一说完我就知道这是真的，也知道这有多么不公平，因为她是我合作过的最情绪稳定、最开朗的人之一。当她告诉我这些时，我同时意识到了几件事：第一，我并没有成为我渴望成为的那种同事。我甚至没有注意到，在我们一起参加的每一次会议中，她都必须表现得始终如一的开朗和愉快，尽管她和我们所有人一样，在工作中也有值得生气的事。所以我没能成为一个“挺身而出者”（Upstander），没能成为一个好同事。

---

### [01:13:41] Kim Scott

**English:**
The second thing I realized was that I had also failed to acknowledge when I was experiencing different versions of bias, prejudice and bullying. And I think part of the reason it's kind of hard for the author of a book called Radical Candor to admit she was in denial. But I had been in denial about a bunch of experiences I had had in the workplace. I had pretended that a whole host of things were not happening, that were in fact happening. And I think part of the reason why I did that was that I never wanted to think of myself as a victim, but even less than wanting to think of myself as a victim did I want to think of myself as the culprit.

**中文翻译:**
第二件事我意识到，我也没能承认自己何时经历过不同形式的偏见、歧视和霸凌。我想部分原因是，对于一个写了《彻底坦诚》的人来说，承认自己在“逃避现实”是很难的。但我确实对自己在职场中的一系列经历视而不见。我假装很多事情没有发生，而它们实际上发生了。我想部分原因是我不想把自己看作受害者，但更重要的是，我更不想把自己看作“罪魁祸首”。

---

### [01:14:11] Kim Scott

**English:**
So I'd been even more deeply in denial about the times that I had said or done things that hurt other people who I worked with, said or done things that were biased or worse. I had bullied people before. And by the way, when you become a leader, you're much more prone to bullying even if you don't think of yourself as a bully, which I certainly don't think of myself as a bully, but that doesn't mean I never bullied anyone. And then the last thing I realized was that as a leader, I imagined that I was creating these BS free zones, but I had allowed all manner of BS to pass. So that was what prompted me to write the next book, Radical Respect, which you can pre-order right now and please do.

**中文翻译:**
所以我更深地否认了那些我曾说过或做过的伤害同事的事，那些带有偏见甚至更糟的事。我以前也霸凌过别人。顺便说一下，当你成为领导者时，你更容易陷入霸凌，即使你并不认为自己是个霸凌者——我当然不觉得自己是，但这并不意味着我从未霸凌过任何人。最后我意识到，作为领导者，我以为自己在创造一个“拒绝废话”的区域，但我却允许了各种各样的“废话”存在。这就是促使我写下一本书《彻底尊重》的原因，现在已经可以预订了，请大家支持。

---

### [01:14:41] Lenny

**English:**
That was my next question. Talk more about this book. What is it about? Where people find it?

**中文翻译:**
这正是我下一个问题。多聊聊这本书吧，它是关于什么的？人们在哪里可以找到它？

---

### [01:14:46] Kim Scott

**English:**
Radical Respect comes out in May. You can pre-order it now. Anywhere you buy books, at your local independent bookstore, I'm speaking at a conference of independent bookstore owners soon you can pre-order it on Amazon or Barnes Noble or anywhere else you buy buy books.

**中文翻译:**
《彻底尊重》将于五月出版。你现在就可以预订。任何买书的地方都有，比如你当地的独立书店（我很快要在独立书店主会议上演讲），也可以在亚马逊、Barnes & Noble 或任何其他购书平台预订。

---

### [01:15:05] Lenny

**English:**
And who would you say it's most for?

**中文翻译:**
你觉得这本书最适合谁读？

---

### [01:15:08] Kim Scott

**English:**
So there are chapters in that book about things leaders can do. There are chapters in the book about things you can do if you're harmed by bias, prejudice, or bullying. There are chapters in the book about how to be a great upstander, how to be a better colleague, and there are chapters in the book about how to become part of the solution, not part of the problem when you're the culprit. And I think we all find ourselves in all four of those roles at different moments in time, and I don't think there's any one group who can solve this problem. Everyone is responsible for creating a more respectful work environment.

**中文翻译:**
书中有专门讲领导者可以做什么的章节；有讲如果你受到偏见、歧视或霸凌伤害时可以做什么的章节；有讲如何成为一个优秀的“挺身而出者”、如何成为更好的同事的章节；还有讲当你成为“罪魁祸首”时，如何成为解决方案的一部分而非问题的一部分。我认为我们在不同时刻都会扮演这四种角色，没有任何一个群体能单独解决这个问题。每个人都有责任创造一个更具尊重感的工作环境。

---

### [01:15:48] Lenny

**English:**
Awesome. We'll link to that in the show notes.

**中文翻译:**
太棒了。我们会把链接放在节目介绍里。

---

### [01:15:50] Kim Scott

**English:**
Amazing.

**中文翻译:**
太好了。

---

### [01:15:51] Lenny

**English:**
To leave people with a very tactical next step. What's one thing they could do this week today to get better at Radical Candor, to start building that muscle?

**中文翻译:**
为了给听众一个非常具战术性的下一步建议：他们这周或今天可以做哪一件事，来提升“彻底坦诚”的能力，开始锻炼这块肌肉？

---

### [01:16:00] Kim Scott

**English:**
I would love it if everyone would write down their go-to question what are the words that will come out of your mouth and practice it. Practice it in front of the mirror and then practice it with a friend and refine it. Just figure out what, because it is uncomfortable to solicit feedback from others. They don't want to give it to you and you don't really want to hear it. So if everybody can write down their go-to question and then put five minutes in your calendar of someone you're going to ask that question of.

**中文翻译:**
我希望每个人都能写下自己的“必问问题”——也就是那些会从你嘴里说出来的话，并练习它。对着镜子练习，然后和朋友练习并不断完善。弄清楚该怎么说，因为向别人征求反馈是不舒服的：他们不想给，你也不想听。所以，如果每个人都能写下自己的必问问题，然后在日程表里留出 5 分钟，找一个你想问的人去问。

---

### [01:16:31] Lenny

**English:**
And that calendar entry, I was going to come back to it actually. So you do the one-on-one agenda, adding the question, the calendar entry is for people you don't have a one-on-one with, pick someone that you're going to ask that you're not meeting with regularly.

**中文翻译:**
关于那个日程安排，我正想回头再确认一下。所以，除了在 1对1 面谈议程中加入问题，日程安排是针对那些你没有 1对1 面谈的人，选一个你不经常见面的人去问？

---

### [01:16:42] Kim Scott

**English:**
Absolutely. Or add it to the bottom of your next one-on-one agenda. That's fair too. Either one.

**中文翻译:**
绝对没错。或者把它加到你下一次 1对1 面谈议程的最下面。那也行。两种都可以。

---

### [01:16:44] Lenny

**English:**
Amazing. Kim, is there anything else you want to leave folks with before we get to our very exciting lightning round?

**中文翻译:**
太棒了。金，在进入激动人心的闪电问答环节之前，还有什么想留给大家的吗？

---

### [01:16:52] Kim Scott

**English:**
I think just remember, you do not have to choose between being successful and being a jerk. You can be a successful kind person.

**中文翻译:**
我想请大家记住：你不需要在“成功”和“做个混蛋”之间做选择。你可以做一个既成功又善良的人。

---

### [01:17:00] Lenny

**English:**
Oh, I love that. Amazing. Okay, well with that, we've reached a very exciting lightning round. Are you ready?

**中文翻译:**
噢，我太喜欢这句话了。太棒了。好，那么我们进入非常精彩的闪电问答环节。准备好了吗？

---

### [01:17:07] Kim Scott

**English:**
I'm ready.

**中文翻译:**
准备好了。

---

### [01:17:08] Lenny

**English:**
What are two or three books you've recommended most to other people? You've already mentioned a few but what do you want to share?

**中文翻译:**
你最常推荐给别人的两三本书是什么？你已经提到了几本，还有什么想分享的吗？

---

### [01:17:14] Kim Scott

**English:**
Yes, I've mentioned a couple. Please do buy Radical Respect, I believe that the more novels people read, the better. People often ask me, what can I do to move up on the care personally dimension of Radical Candor and read more novels? This is the best way I know of to build compassion for other people, to understand the emotional signals that might be coming at you. I mean, some of my favorite novels are Middlemarch. I try to reread that all the time. Anything that Toni Morrison wrote, the Bluest Eye is one of my favorite, but also Song of Solomon. It just such a brilliant writer and will help you enter into the lives of people that you haven't entered into. I think that Orlando by Virginia Woolf is another one of my favorites. And Robertson Davies, the Deptford Trilogy is an incredible set of novels to read. I'm cheating now and giving you three.

**中文翻译:**
是的，我已经提了几本。请一定要买《彻底尊重》。另外，我相信人们读的小说越多越好。人们常问我：我该怎么提升“彻底坦诚”中的“个人关心”维度？答案是多读小说。这是我所知道的建立同理心、理解他人情感信号的最佳方式。我最喜欢的小说包括《米德尔马契》（Middlemarch），我经常重读。还有托妮·莫里森（Toni Morrison）的所有作品，《最蓝的眼睛》是我的最爱之一，还有《所罗门之歌》。她是一位天才作家，能帮你进入那些你从未涉足过的生活。弗吉尼亚·伍尔夫的《奥兰多》也是我的最爱。还有罗伯逊·戴维斯的《德普特福德三部曲》，那是一套不可思议的小说。我现在耍赖多给了你几本。

---

### [01:18:27] Lenny

**English:**
The more the merrier.

**中文翻译:**
越多越好。

---

### [01:18:27] Kim Scott

**English:**
Yes, Alice Walker, the Color Purple is another one of my very favorite books, so I recommend reading more novels.

**中文翻译:**
是的，爱丽丝·沃克的《紫色》也是我最喜欢的书之一。所以我建议多读小说。

---

### [01:18:34] Lenny

**English:**
I love this leaning into fiction that doesn't come up often on this podcast, so this is great. What is a favorite recent movie or TV show that you really enjoyed?

**中文翻译:**
我喜欢这种对虚构文学的推崇，这在本播客中不常出现，太棒了。最近有什么你非常喜欢的电影或电视剧吗？

---

### [01:18:47] Kim Scott

**English:**
I watched all 19 seasons of Grey's Anatomy with my daughter during and after COVID. That was really fun.

**中文翻译:**
在疫情期间和之后，我和女儿一起看完了整整 19 季的《实习医生格蕾》。那真的很有趣。

---

### [01:18:55] Lenny

**English:**
Actually. I did the same thing with my wife. We didn't do all the seasons, but we watched a lot of Grey's Anatomy.

**中文翻译:**
事实上，我和我妻子也做了同样的事。我们没看完所有季度，但也看了很多。

---

### [01:18:59] Kim Scott

**English:**
We watched every single one. It's still coming out.

**中文翻译:**
我们每一集都看了。它现在还在出。

---

### [01:19:04] Lenny

**English:**
Yeah, it's funny to see which characters continue and which I die off, leave.

**中文翻译:**
是的，看哪些角色留下来，哪些角色领便当或离开，挺有意思的。

---

### [01:19:07] Kim Scott

**English:**
Yeah, exactly.

**中文翻译:**
没错。

---

### [01:19:09] Lenny

**English:**
Oh man. Okay. Funny

**中文翻译:**
噢天，好吧。真逗。

---

### [01:19:10] Kim Scott

**English:**
And Shonda Rhimes, I mean, watch her TED Talk, amazing person.

**中文翻译:**
还有珊达·瑞姆斯（Shonda Rhimes），一定要看她的 TED 演讲，她是个了不起的人。

---

### [01:19:14] Lenny

**English:**
All right, we'll link to that in the show notes. Do you have a favorite interview question that you like to ask when you're interviewing people that might be helpful to folks interviewing?

**中文翻译:**
好的，我们会把链接放在节目介绍里。你面试别人时有没有什么最喜欢问的问题，可能对正在面试的人有帮助？

---

### [01:19:22] Kim Scott

**English:**
The question that I like to ask is just tell me the story of your career. And I know that's kind of, maybe it's a hard, it seems like a softball, but it's actually can be unfairly hard or not. I don't know, unfairly hard, but I always learn a lot about people from how they tell the story of their life and their career. And then what I try to do is they'll say a couple of things that really interest me and I sort of double-click down into the details of a couple of aspects. I love people's life stories, so that makes it a more fun conversation for me. Often people like talking about themselves so it's not too painful for them, but you also learn all kinds of unexpected things.

**中文翻译:**
我喜欢问的问题是：“给我讲讲你的职业生涯故事。”我知道这听起来像个“软球”，但实际上它可能非常难。我总能从一个人讲述生活和职业故事的方式中学到很多。然后我会针对其中几个让我感兴趣的点，深入挖掘细节。我热爱听别人的生活故事，这让对话对我来说更有趣。通常人们也喜欢谈论自己，所以对他们来说也不太痛苦，但你却能学到各种意想不到的东西。

---

### [01:20:13] Lenny

**English:**
And is there anything you're looking for in an answer that's like, this is a good person to hire or is it mostly information? I'm just gathering a lot of background.

**中文翻译:**
你在答案中会寻找什么特定的东西来判断“这是一个值得雇佣的人”吗？还是主要为了获取背景信息？

---

### [01:20:22] Kim Scott

**English:**
I find that I learn how the person approaches setbacks from a story, from the way they tell a story. I learn whether a person is able to identify mistakes they made. I mean, if you say, "Tell me the story of your career," if there's not a couple of mistakes in there, I also find that when they talk about accomplishments and then I double click on it, I learn a lot about what a person really did. Sometimes a person will claim credit for something that just happened that they had very little to actually to do with, and I learn about very often. I find that a good way to learn about people's skills and depth of knowledge.

**中文翻译:**
我发现我能从故事中、从他们讲故事的方式中了解一个人如何应对挫折。我能了解一个人是否能识别自己犯过的错误。如果你讲职业故事却没提到一两个错误，那就有问题。此外，当他们谈论成就时，我深入挖掘细节，就能了解这个人到底做了什么。有时人们会把一些顺带发生、而他们其实没怎么参与的事归功于自己。我发现这是了解一个人技能和知识深度的绝佳方式。

---

### [01:21:10] Lenny

**English:**
Is there a favorite product you've recently discovered that you really like?

**中文翻译:**
最近有没有什么你发现并非常喜欢的个人产品？

---

### [01:21:14] Kim Scott

**English:**
Yes. I love my new it's called Attitude, and they're shampoo bars and conditioner bars, so it comes in cardboard, wrapped in paper. There's no plastic. It's much more environmentally friendly, and I have long hair. It gets very tingly and the conditioner works, so I recommend.

**中文翻译:**
有的。我喜欢我新买的叫 Attitude 的洗发皂和护发皂。它是纸盒包装，用纸裹着的，没有塑料，非常环保。我头发很长，容易打结，但这个护发皂很有效，所以我推荐。

---

### [01:21:35] Lenny

**English:**
Very unique suggestion. Is there a favorite motto that you often repeat to yourself, share with people, find useful to come back to in work or in life?

**中文翻译:**
非常独特的建议。你有没有什么经常对自己重复、或与人分享的座右铭，觉得在工作或生活中很有用？

---

### [01:21:46] Kim Scott

**English:**
"It's not mean. It's clear." This is something someone told me on the streets of Manhattan. It's actually the origin story of Radical Candor. I was walking my dog, almost got hit by a cab, and this man, a perfect stranger, looked at me and he said, "I can tell you love that dog." That was all he had to do to move up on the care personally dimension, but he says, "You're going to kill that dog if you don't teach her to sit." And he pointed at the ground this kind of harsh gesture. He said, "Sit." The dog sat, had no idea she even knew what that meant. And I kind of looked up at him in amazement and he said, "It's not mean. It's clear." And then the light changed and he walked off leaving me with words to live by. So I think about that stranger all the time.

**中文翻译:**
“这不是刻薄，这是清晰。”这是曼哈顿街头的一个人告诉我的。这实际上是“彻底坦诚”的起源故事。当时我在遛狗，差点被出租车撞到。一个完全陌生的男人看着我说：“我看得出来你很爱那条狗。”这就是他在“个人关心”维度上所做的。但他接着说：“如果你不教它‘坐下’，你会害死它的。”他指着地面，做了一个很生硬的手势说：“坐下！”狗竟然坐下了，我甚至不知道它听得懂。我惊讶地看着他，他说：“这不是刻薄，这是清晰。”然后红绿灯变了，他走开了，留下了这句让我受用终身的话。我经常想起那个陌生人。

---

### [01:22:30] Lenny

**English:**
Such a good story. Final question. I read online that you started a diamond cutting factory in Moscow at some point in your life. Can you please explain this part of your life?

**中文翻译:**
太棒的故事。最后一个问题：我在网上读到你曾在莫斯科创办过一家钻石切割厂。你能解释一下你人生中的这段经历吗？

---

### [01:22:41] Kim Scott

**English:**
Yes. So I studied Russian literature in college, very practical major. And then I moved to what was then the Soviet Union in 1990 when I graduated from college, and I wound up taking a job with, first of all, I was with an investment company and then they pulled out of Russia and put the money in China. And so I wanted to stay in Russia and through a friend of a friend, I got a job working for this diamond company called Lazare Kaplan, new York-based diamond company, and they were trying to figure out what they should do in Russia. And I found out there was an opportunity to start this diamond cutting factory. And it was actually my first management job because I had to hire these diamond cutters and I had to hire them away from these Russian diamond cutting factories and I knew nothing about management or business or anything.

**中文翻译:**
是的。我大学学的是俄罗斯文学，非常“实用”的专业。1990 年毕业后我搬到了当时的苏联。我先是在一家投资公司工作，后来他们撤出俄罗斯把钱投向了中国。我想留在俄罗斯，通过朋友介绍，我进了一家叫 Lazare Kaplan 的纽约钻石公司，他们当时正想在俄罗斯大展拳脚。我发现了一个创办钻石切割厂的机会。那实际上是我的第一份管理工作，因为我必须雇佣那些钻石切割师，把他们从俄罗斯国营工厂挖过来。而我当时对管理、商业一窍不通。

---

### [01:23:44] Kim Scott

**English:**
I'd studied Russian literature. I knew a lot about Dostoyevsky, so I thought it was going to be easy though. I was like, well, the ruble is collapsing. I'm going to pay them in dollars. Of course they'll come work for me. But they didn't take the job right away. To my surprise, they wanted to have a picnic. And at the picnic we brought a bottle of vodka, and there's a rule in Russia, if you open a bottle, you got to finish the bottle. So by the end of the bottle of vodka, I realized that what I could offer that the state could not offer them was to give a damn about them. They wanted to know that I would be a manager who would get them out of Russia if things went sideways there. And as you can imagine, I've been thinking a lot about, they were all men, about these men because I haven't been able to get them out. And I'm devastated by what Russia has done to Ukraine, but that was the moment when I realized that management really matters, and that to be good at it, you have to care about other people. And that was what made it interesting to me.

**中文翻译:**
我学的是俄罗斯文学，我对陀思妥耶夫斯基了如指掌，所以我以为这会很容易。我想：卢布在崩溃，我付给他们美金，他们肯定会来。但他们没有立刻接受工作。令我惊讶的是，他们想去野餐。野餐时我们带了一瓶伏特加，俄罗斯有个规矩：开了瓶就得喝完。喝完那瓶酒后，我意识到我能提供而国家不能提供的东西是：对他们的真正关怀。他们想知道，如果局势恶化，我这个经理是否能带他们离开俄罗斯。你可以想象，我最近经常想起这些男人（他们全是男性），因为我没能带他们出来。我对俄罗斯对乌克兰所做的一切感到心碎。但正是那一刻让我意识到，管理真的很重要，而要做好管理，你必须关心他人。这就是管理对我产生吸引力的原因。

---

### [01:24:53] Lenny

**English:**
Man, that is a heavy first job as a manager.

**中文翻译:**
天哪，作为经理的第一份工作可真够沉重的。

---

### [01:24:56] Kim Scott

**English:**
Yeah. Yes, it was.

**中文翻译:**
是的，确实如此。

---

### [01:24:58] Lenny

**English:**
Wow, Kim, this was awesome. I think we're going to help a lot of people become better leaders. I think we're going to help a lot of companies change their culture. I'm so honored that you agreed to do this. Two final questions. Where can folks find you online if they want to follow up and learn more about your stuff? And then two, how can listeners be helpful to you?

**中文翻译:**
哇，金，这太棒了。我想我们会帮助很多人成为更好的领导者，帮助很多公司改变文化。我很荣幸你能答应这次访谈。最后两个问题：如果大家想跟进并了解更多你的内容，可以在哪里找到你？第二，听众可以如何帮助你？

---

### [01:25:18] Kim Scott

**English:**
Radicalcandor.com is our website, and I'm not much on Twitter slash X anymore, but you can find us. We do a lot of posting on LinkedIn. I think that the thing that people can help me do is to send us a note. You can also email us radicalcandor@radicalcandor.com and let us know what could we do in podcasts like this or in our materials? What could we do that would make it easier for you to put these ideas into practice? Because Radical Candor is, it's about behavior change, and it sounds easy, but it's really hard, and we're always trying to figure out how to help people walk the talk here.

**中文翻译:**
我们的网站是 Radicalcandor.com。我不怎么用 Twitter/X 了，但你可以在 LinkedIn 上找到我们，我们经常在那里发帖。我觉得大家能帮我做的就是给我们留言。你也可以发邮件到 radicalcandor@radicalcandor.com 告诉我们：在这样的播客中或在我们的资料中，我们还能做些什么，能让你更容易地将这些想法付诸实践？因为“彻底坦诚”关乎行为改变，听起来容易做起来难，我们一直在努力寻找如何帮助人们做到言行一致。

---

### [01:26:02] Lenny

**English:**
I think doing this podcast is going to make a dent in that goal.

**中文翻译:**
我想这期播客会为实现那个目标做出贡献。

---

### [01:26:05] Kim Scott

**English:**
Oh, good.

**中文翻译:**
噢，那就好。

---

### [01:26:06] Lenny

**English:**
Kim, thank you so much for being here.

**中文翻译:**
金，非常感谢你能来。

---

### [01:26:08] Kim Scott

**English:**
Thank you. I really enjoyed it.

**中文翻译:**
谢谢，我很享受这次对话。

---

### [01:26:11] Lenny

**English:**
Same. Bye everyone.

**中文翻译:**
我也是。大家再见。

---

### [01:26:12] Kim Scott

**English:**
Take care everyone.

**中文翻译:**
大家保重。

---

### [01:26:15] Lenny

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lenny'spodcasts.com. See you in the next episode.

**中文翻译:**
非常感谢您的收听。如果您觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或您喜欢的播客应用中订阅本节目。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现本播客。您可以在 lennyspodcasts.com 找到所有往期节目或了解更多信息。下期节目再见。