# Krithika Shankarraman - 双语对照

This is the complete bilingual transcript for Lenny’s Podcast featuring Krithika Shankarraman.

---

### [00:00:00] Krithika Shankarraman

**English:**
It seems like there's a playbook for everything, there is a framework for everything, but the reality is you have to spend the hours and the time to really understand your customer.

**中文翻译:**
似乎每件事都有一个策略手册（playbook），每件事都有一个框架，但现实是，你必须投入大量的时间和精力去真正了解你的客户。

---

### [00:00:09] Lenny Rachitsky

**English:**
You were the first marketing hire at OpenAI. I believe ChatGPT is the fastest-growing product in history. Let me ask you this. A lot of people might be hearing like, "Oh, ChatGPT." It's like, why do you need marketing?

**中文翻译:**
你是 OpenAI 的第一位营销员工。我相信 ChatGPT 是历史上增长最快的产品。我想问你：很多人可能会觉得，“哦，是 ChatGPT 啊。” 既然它这么火，为什么还需要营销呢？

---

### [00:00:18] Krithika Shankarraman

**English:**
Everyone knew of ChatGPT, but when you clicked one zoom level further, the thing that came up was, "I don't know what to use it for." The work of marketing ended up becoming creating this sort of use case epiphany where people could say, "I had no idea ChatGPT can do that." A lot of marketing metrics tend to be vanity metrics about the number of clicks that you got, number of views, number of impressions. I think those are all bullshit numbers. What is that experience that you want your customers to come away with when they interact with your brand?

**中文翻译:**
人人都知道 ChatGPT，但当你深入了解一层时，出现的问题往往是：“我不知道该用它来做什么。” 营销工作最终变成了创造一种“用例顿悟”（use case epiphany），让人们感叹：“我竟然不知道 ChatGPT 还能做这个。” 很多营销指标往往是虚荣指标（vanity metrics），比如点击量、观看量、曝光量。我觉得这些都是扯淡的数据。真正重要的是，你希望客户在与你的品牌互动后获得什么样的体验？

---

### [00:00:45] Lenny Rachitsky

**English:**
If your advice is, "Don't just copy what other companies do," what should people be doing?

**中文翻译:**
如果你的建议是“不要只是模仿其他公司的做法”，那么人们应该怎么做呢？

---

### [00:00:50] Krithika Shankarraman

**English:**
Put together a four-step process that has served me pretty well. The first step here is...

**中文翻译:**
我总结了一个对我非常有用的四步流程。第一步是……

---

### [00:00:55] Lenny Rachitsky

**English:**
Today my guest is Krithika Shankarraman. Krithika was the first marketing hire and VP of marketing at OpenAI, the first marketing hire at Stripe where she was the only marketing person for three years. She was also an early marketing leader at Retool and at Dropbox. She also did marketing for Android at Google. Currently, she is executive in residence at Thrive Capital where she supports their portfolio and founders on all things marketing and helps hire early marketing leaders for their startups.

**中文翻译:**
今天的嘉宾是 Krithika Shankarraman。Krithika 是 OpenAI 的首位营销员工兼营销副总裁，也是 Stripe 的首位营销员工，并在那里独自负责了三年的营销工作。她还是 Retool 和 Dropbox 的早期营销负责人，也曾在 Google 负责 Android 的营销。目前，她是 Thrive Capital 的驻企高管（EIR），负责支持其投资组合和创始人处理所有营销事务，并帮助初创公司招聘早期营销负责人。

---

### [00:01:21] Lenny Rachitsky

**English:**
In our conversation, we talk through all of the biggest lessons that she has learned about how to market your product from her time at OpenAI, Stripe, Retool, Dropbox and other places, including her four-step diagnostic approach to marketing, her anti-playbook playbook, what B2B companies can learn from consumer marketing, career advice for people looking to get into marketing, and also just what people that don't want to get into marketing should know about marketing to be successful.

**中文翻译:**
在我们的对话中，我们探讨了她在 OpenAI、Stripe、Retool、Dropbox 等公司学到的关于如何营销产品的最重要教训，包括她的营销四步诊断法、她的“反策略手册”策略、B2B 公司可以从消费级营销中学到什么、给想进入营销领域的人的职业建议，以及那些不想进入营销领域的人为了取得成功也应该了解的营销知识。

---

### [00:01:46] Lenny Rachitsky

**English:**
A big thank you to Kevin Garcia and Kelly Sims for suggesting questions and stories to get into. If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. Also, if you become an annual subscriber of my newsletter, you get a year free of a bunch of world-class products, including Superhuman, Notion, Linear, Perplexity, and Granola and more. Check it out at lennysnewsletter.com and click Bundle. With that, I bring you Krithika Shankarraman.

**中文翻译:**
非常感谢 Kevin Garcia 和 Kelly Sims 提供的建议问题和素材。如果你喜欢这个播客，别忘了在常用的播客应用或 YouTube 上订阅和关注。此外，如果你成为我时事通讯（newsletter）的年度订阅者，你可以免费获得一年的多款世界级产品，包括 Superhuman、Notion、Linear、Perplexity、Granola 等。请访问 lennysnewsletter.com 并点击 Bundle 查看。现在，让我们欢迎 Krithika Shankarraman。

---

### [00:02:13] Lenny Rachitsky (Ad: Eppo)

**English:**
This episode is brought to you by Eppo. Eppo is a next generation A/B testing and feature management platform built by alums of Airbnb and Snowflake for modern growth teams... [Full ad text omitted for brevity in this sample, but would be translated in a full document]

**中文翻译:**
本集节目由 Eppo 赞助。Eppo 是由 Airbnb 和 Snowflake 的校友为现代增长团队打造的下一代 A/B 测试和功能管理平台……（此处省略广告正文翻译，保持与原文一致）

---

### [00:03:31] Lenny Rachitsky (Ad: Airtable)

**English:**
This episode is brought to you by Airtable ProductCentral... [Full ad text omitted for brevity] Krithika, thank you so much for being here and welcome to the podcast.

**中文翻译:**
本集节目由 Airtable ProductCentral 赞助…… Krithika，非常感谢你能来到这里，欢迎来到我们的播客。

---

### [00:04:29] Krithika Shankarraman

**English:**
Thank you so much for having me. I'm excited to be chatting.

**中文翻译:**
非常感谢你的邀请。很高兴能和你聊天。

---

### [00:04:32] Lenny Rachitsky

**English:**
So you were an early and the first marketing hire at some of the most iconic companies in the world. What I want to do with our chat today is basically go through a lot of these companies that you've worked at and see what lessons we can extract about your time leading marketing at these companies. And I want to start with OpenAI. No big deal. You were the first marketing hire at OpenAI. Things seem to have gone really well over there. I believe ChatGPT is the fastest-growing product in history. Does that resonate?

**中文翻译:**
你曾在一些世界上最具代表性的公司担任早期及首位营销员工。今天我想通过我们的聊天，回顾你工作过的这些公司，看看能从你领导这些公司营销工作的经历中总结出哪些经验。我想从 OpenAI 开始。这可不是小事，你是 OpenAI 的第一位营销员工。那里的发展似乎非常顺利。我相信 ChatGPT 是历史上增长最快的产品。你认同吗？

---

### [00:05:03] Krithika Shankarraman

**English:**
It does. Not that I can take credit for it.

**中文翻译:**
是的，虽然我不能把功劳都揽在自己身上。

---

### [00:05:05] Lenny Rachitsky

**English:**
Well, we'll talk about that. Either way, nice job. Let me ask you this. A lot of people might be hearing like, "Oh, ChatGPT." It's like, why do you need marketing? It's like the most magical thing in the history of the world. How much value does anything add to making it as successful? Can you just talk about just the value that a marketing person adds to a product like that that's already incredible?

**中文翻译:**
好吧，我们会聊到这个。不管怎样，干得漂亮。我想问你：很多人可能会觉得，“哦，ChatGPT。” 感觉它就像是世界历史上最神奇的东西，为什么还需要营销？营销人员能为这样一个已经如此出色的产品增加多少价值？你能谈谈营销人员对这种已经非常惊人的产品所带来的价值吗？

---

### [00:05:25] Krithika Shankarraman

**English:**
Yeah. When you think about all of the different stages of the funnel, awareness was clearly not the problem that ChatGPT or OpenAI had. Everyone knew of ChatGPT, but when you clicked one zoom level further, the thing that came up was, "I don't know what to use it for. I don't know what it replaces. Should I be using search for this? Should I be using ChatGPT for this? How can it even help me?" And so the work of marketing ended up becoming, creating this sort of use case epiphany where people could say, "I had no idea ChatGPT can do that. And yeah, maybe I should be using it for X, Y, Z reason in my own life." And so I think you have to be very diagnostic in terms of what can marketing be doing to help, rather than just going off of the typical top of funnel, and then middle of funnel and conversion-oriented tactics that end up being in a playbook.

**中文翻译:**
是的。当你思考营销漏斗的所有不同阶段时，知名度（awareness）显然不是 ChatGPT 或 OpenAI 面临的问题。人人都知道 ChatGPT，但当你深入了解时，问题就变成了：“我不知道该用它做什么。我不知道它能替代什么。我应该用搜索还是用 ChatGPT？它到底能帮我什么？” 因此，营销工作最终变成了创造一种“用例顿悟”，让人们觉得：“我竟然不知道 ChatGPT 还能做那个。是的，也许我应该在生活中出于某某原因使用它。” 所以我认为你必须非常有诊断性地思考营销能提供什么帮助，而不是仅仅套用策略手册中典型的漏斗顶部、中部和转化导向的战术。

---

### [00:06:14] Lenny Rachitsky

**English:**
So for folks that listen to this podcast, it's a lot of product managers, product builders. A lot of them don't have a lot of experience with marketing. I think it's an important insight there of just, this is a thing marketing can help you with is helping people understand how to use your product, understand use cases, understand examples, things like that. So I think as we go through this, I think this is useful for folks to understand of, here's what you may not be good at and may need marketing help with.

**中文翻译:**
对于听这个播客的人来说，很多是产品经理、产品开发者。他们中很多人没有太多的营销经验。我认为这是一个很重要的见解：营销可以帮助你让人们理解如何使用你的产品，理解使用场景和案例等等。所以当我们深入讨论时，这对大家理解“你可能不擅长什么以及可能需要营销帮助的地方”非常有用。

---

### [00:06:38] Krithika Shankarraman

**English:**
Yeah. When done right, product management and product marketing should be best friends, right? And you are working together at every stage of product development. Rather than thinking of it as a handoff at the end of the conveyor belt when the product's been built, you sort of hand it off to marketing to take it out the door. If you can think of it as sort of a three-legged race from the very beginning of product development, then you go to market with the right thing in the first place. You get these insights from customers, you hear the language that they're using, which can be the sort of cheat code for how to message and position the product in market. And of course, there's a creativity angle on how to differentiate your product in the market, but ideally, you're doing that in lockstep with the product management side.

**中文翻译:**
没错。如果做得好，产品管理和产品营销应该是“最好的朋友”，对吧？你们应该在产品开发的每个阶段都紧密合作。不要把它看作是传送带末端的交接——产品做好了，然后交给营销部门推向市场。如果你能从产品开发之初就把它看作是一场“三人两足”的比赛，那么你从一开始就能带着正确的东西走向市场。你会从客户那里获得洞察，听到他们使用的语言，这可以成为你在市场上进行产品传讯（messaging）和定位（positioning）的“作弊码”。当然，如何让产品在市场中脱颖而出还有创意层面的考量，但理想情况下，你应该与产品管理部门步调一致地完成这些工作。

---

### [00:07:18] Lenny Rachitsky

**English:**
The other element of ChatGPT's marketing success, I know that you spent a lot of time on the enterprise side, is just consumerish marketing tactics for enterprisey products. Can you just talk about that? And it feels like that's emerging more and more just like consumer tactics for enterprise products.

**中文翻译:**
ChatGPT 营销成功的另一个要素——我知道你在企业端投入了很多时间——就是将消费级营销战术应用于企业级产品。你能谈谈这一点吗？感觉这种趋势越来越明显，即在企业产品中使用消费级战术。

---

### [00:07:35] Krithika Shankarraman

**English:**
In typical organizations that I've been a part of and leading marketing for, the enterprise side of the house, the B2B side of the house usually fits the mold of demand generation where you're creating demand for the sales team and you're bringing new customers and prospects into the fold and into the orbit of the company. That again, was not the problem at OpenAI. When we turned on the contact sales form for ChatGPT Enterprise, which was one of my first launches at the company, our lead volume 40 X-ed overnight. It was unanticipated even beyond our wildest expectations. And so some of the things that I had to do are not typical to marketing at all. I sat down with ChatGPT and I coded up a Python script that ended up functioning as our first lead qualification, lead-scoring model. That was used in production for way too long, longer than I'd care to admit.

**中文翻译:**
在我工作过并领导营销的典型组织中，企业端或 B2B 端通常符合“需求挖掘”（demand generation）的模式，即为销售团队创造需求，并将新客户和潜在客户带入公司的轨道。但这在 OpenAI 同样不是问题。当我们开启 ChatGPT 企业版的“联系销售”表单时（这是我在公司负责的首批发布之一），我们的线索量（lead volume）一夜之间增长了 40 倍。这超出了我们最疯狂的预期。因此，我不得不做一些完全不属于典型营销范畴的事情。我坐下来和 ChatGPT 一起写了一个 Python 脚本，它最终成为了我们第一个线索筛选和评分模型。那个脚本在生产环境中运行了太久，久到我都不好意思承认。

---

### [00:08:25] Lenny Rachitsky

**English:**
It's so funny. I think about when ChatGPT first launched and OpenAI just launched, everyone was just like, "How will you make money? How do you make money with something like this chatbot that's pretty smart, but sort of not that smart?" I remember there's a video of Sam Altman being asked, "How do you make money with something like this?" And I don't know if you just saw this, he just like, "At some point we will ask ChatGPT, how do we make money?"

**中文翻译:**
太有意思了。我想起 ChatGPT 刚发布、OpenAI 刚起步时，每个人都在问：“你们怎么赚钱？靠这样一个挺聪明但又没那么聪明的聊天机器人怎么赚钱？”我记得有个视频，Sam Altman 被问到：“你怎么靠这种东西赚钱？”我不确定你有没有看过，他当时大概是说：“在某个时刻，我们会问 ChatGPT，我们该怎么赚钱？”

---

### [00:08:47] Krithika Shankarraman

**English:**
Yes. And I think the reality is it's not a solved problem. And a lot of folks, a lot of companies in the AI domain are trying to figure out the right pricing model. And it's something that you've talked about in your newsletter and so on, but there is a value creation aspect to using AI that doesn't kind of neatly fit the mold of SaaS-based pricing or seed-based pricing, or even usage-based pricing. So, I think there are still some frontiers to figuring out where is the value, how do different types of organizations and companies and consumers find value? And again, it's not the typical sort of KPIs that you would typically try to optimize and maximize.

**中文翻译:**
是的。我认为现实情况是，这仍然不是一个已经解决的问题。AI 领域的很多公司都在试图寻找合适的定价模型。你在时事通讯里也讨论过这个。使用 AI 存在一个价值创造的维度，它无法完美契合传统的 SaaS 定价、按席位定价（seat-based pricing）甚至按量计费（usage-based pricing）。所以，我认为在弄清楚价值在哪里、不同类型的组织和消费者如何发现价值方面，仍有待探索。而且，这也不是你通常会尝试优化和最大化的那种典型 KPI。

---

### [00:09:27] Lenny Rachitsky

**English:**
I will say, though, in terms of pricing, it feels like ChatGP, it works. It's just like a monthly fee, talk to it up to a certain limit. It's wild to think back now, there was a sense, "We don't have no idea how will this make money." Now it seems so obvious.

**中文翻译:**
不过我要说，就定价而言，ChatGPT 现在的模式似乎行得通。就是月费，在一定限制内使用。现在回想起来挺疯狂的，当时大家觉得“完全不知道这怎么赚钱”，现在看来却如此显而易见。

---

### [00:09:41] Krithika Shankarraman

**English:**
Truly was a research preview.

**中文翻译:**
当时确实只是一个研究预览版。

---

### [00:09:44] Lenny Rachitsky

**English:**
And I remember Sam Altman just launched, "Here, check out this chat thing that we are trying with," and then the fastest product growth in history. No big deal. I want to come back to this point you made about this playbook, anti-playbook kind of a thinking. You kind of pointed out that with ChatGPT and OpenAI, there was no playbook, and you find that often people following playbooks don't work. Talk about that insight.

**中文翻译:**
我记得 Sam Altman 当时只是发布说：“嘿，来看看我们正在尝试的这个聊天小玩意儿”，然后就成了历史上增长最快的产品。没什么大不了的（开玩笑）。我想回到你提到的关于“策略手册”和“反策略手册”的思考。你指出，对于 ChatGPT 和 OpenAI 来说，并没有现成的策略手册，而且你发现人们盲目遵循策略手册往往行不通。谈谈这个见解吧。

---

### [00:10:08] Krithika Shankarraman

**English:**
In my current role in my career, I've spoken with a lot of founders, and typically, the founders reach out because I've worked at companies that they look up to and they're looking for that playbook. They're looking for, "Hey, just tell me how Stripe did it. Tell me how Retool did it. Tell me how OpenAI did it." And I really hesitate to share any such detail because there was a combination of context, competitive landscape, and the overall sort of zeitgeist of when the company's operating, how the company's operating, that really adds a lot of nuance to what works in the market. And so doing the same things, like if you're just kind of copying the outcomes or the outputs of the strategy and trying to follow in the footsteps of the tactics, you're not paying enough attention to the inputs and, what were the variables and the deciding factors which led to that strategy in the first place? So what I like to do is try to unpack more of a framework for how do you get to become more of a diagnostician to understand the right strategy or tactic in the first place, rather than saying, "How do you copy something that led someone else to success?" Because those criteria may not apply to you at all.

**中文翻译:**
在我目前的职业角色中，我与很多创始人交谈过。通常，创始人联系我是因为我曾在他们仰慕的公司工作过，他们想要那套“策略手册”。他们会问：“嘿，告诉我 Stripe 是怎么做的。告诉我 Retool 是怎么做的。告诉我 OpenAI 是怎么做的。”但我非常犹豫是否要分享这些细节，因为那是背景、竞争格局以及公司运营时的整体时代精神（zeitgeist）共同作用的结果，这些因素为“什么在市场上奏效”增添了很多细微差别。因此，如果你只是复制策略的结果或产出，并试图追随这些战术的脚步，你就没有足够关注投入（inputs）——即最初导致该策略的变量和决定性因素是什么？所以我喜欢做的是，尝试拆解出一个框架，教你如何成为一名“诊断师”，从根本上理解正确的策略或战术，而不是教你“如何复制让别人成功的做法”。因为那些标准可能根本不适用于你。

---

### [00:11:17] Lenny Rachitsky

**English:**
So let's follow that thread because everyone's like, "Goddamn, I need a play. Just tell me how to do this." Okay, so there's no playbooks that you... If your advice is, "Don't just copy what other companies do that have done well," what should people be doing? How do they approach figuring out how to market their product and help it grow faster?

**中文翻译:**
那我们顺着这个思路聊下去，因为每个人都会想：“该死，我需要一个方案。直接告诉我怎么做就行。”好吧，既然没有现成的策略手册……如果你的建议是“不要只是复制那些做得好的公司”，那么人们应该做什么？他们应该如何着手弄清楚如何营销自己的产品并让它增长得更快？

---

### [00:11:35] Krithika Shankarraman

**English:**
Yeah. So I was an engineer before I became a marketer, and so I have brought a little bit of an engineer's framework to the marketing side of the house. And so something that I've tried to do is put together a four-step process that has served me pretty well. The first step here is diagnosing. So, diagnosing the actual problem. Again, this usually means taking a zoom back when a founder comes and asks, "Hey, we really need to hire a demand gen leader. Who do you know in your network that we should be thinking about?" And I'm like, "Let's talk about your funnel. Do you have a lot of people coming in at the top of the funnel? And when they do come in at the top of the funnel and you start talking to them and having a sales conversation, how likely is it that you close them? How likely is it that you win that deal?" That usually tells you very astutely, do you have product market fit? Once you're already in the room and people are converting, you have found that problem statement that is critical to them that is hurting them the most, and your solution is resonating as a solve to that problem. And so that means yes, probably throwing in more at the top of the funnel is a very good move to make at that time. But on the other hand, if you say, "Yeah. I mean, we get a lot of interest, but once they're in the room, they have a bunch of questions. They're asking about, how do you compare to X competitor and Y competitor? And why does it cost so much?" and et cetera, et cetera. That probably means that there's more to be done in the product market fit zone rather than throwing in more at the top of the funnel because you have a leaky funnel at the bottom. And so hiring a demand generator may be the worst thing that you can do versus thinking about more of a product marketer who's thinking about the competitive differentiation, the positioning, the sales enablement that gets more people through at the bottom. So that's that diagnostic step at the top.

**中文翻译:**
是的。在成为营销人员之前我是一名工程师，所以我把工程师的框架带到了营销领域。我尝试总结了一个对我非常有用的四步流程。第一步是**诊断（Diagnosing）**。也就是诊断实际问题。通常这意味着当创始人跑来问：“嘿，我们真的需要招一个需求挖掘负责人，你认识的人里有谁推荐吗？”时，我会退后一步说：“我们先聊聊你的漏斗。你的漏斗顶部有很多人进来吗？当他们进来后，你开始和他们交谈并进行销售对话时，成交的可能性有多大？你赢得这笔交易的可能性有多大？”这通常能非常敏锐地告诉你，你是否达到了产品与市场契合（Product Market Fit）。如果你已经在谈判桌上且人们正在转化，说明你找到了对他们至关重要、最令他们痛苦的问题，而你的解决方案作为该问题的解法引起了共鸣。这意味着，在那时往漏斗顶部投入更多资源是一个非常明智的举动。但另一方面，如果你说：“是的，我们有很多意向，但一旦进入谈判，他们就会有一堆问题。他们会问，你和竞争对手 X 或 Y 相比怎么样？为什么这么贵？”等等。这可能意味着在产品与市场契合方面还有更多工作要做，而不是往漏斗顶部投入更多，因为你的漏斗底部在漏水。在这种情况下，招聘需求挖掘负责人可能是最糟糕的选择，你应该考虑招聘产品营销人员，去思考竞争差异化、定位和销售赋能，从而让更多人通过漏斗底部。这就是最开始的诊断步骤。

---

### [00:13:24] Krithika Shankarraman

**English:**
Second to me is analyzing your competitors' approaches. So to me, this is not about being super laser focused on your competition because that leads to these local maxima rather than thinking about face shift changes and breakthroughs that you can make as a company. But when you analyze your competitors' approaches, evaluating what others do in the space can kind of give you a useful baseline and identify opportunities and gaps and niches that your company can take in instead. And then, this is the critical step. The next one is you have to intentionally take a different path than what everyone else is doing. And so driving a strategy that sort of sets the company apart is really critically important. I think it's so core to the discipline of marketing, ensuring that differentiation in the market. And you don't have to go into a cave to come up with these ideas and strategies. You can usually go and look at domains that are far outside of your own rather than your direct competitors and come up with some great ideas that you can cross apply and bring in and steal into your own domain or vertical instead. And then the final piece is just experiment, test, validate all of that, and then scale what works and kind of discard what doesn't. So you really have to have a lot of that ability to throw away work when you might have spent a ton of calories on this wonderful piece of content. But if it's not working, don't double down on it. That bias of the sunk cause fallacy really comes into play, especially when you've poured your heart and soul into creating artifacts for marketing. So experiment, test, validate. Give people that psychological safety to fail, especially your teams and organizations. And then, yeah, once you find what works, really double down on it.

**中文翻译:**
第二步是**分析（Analyzing）**竞争对手的方法。对我来说，这并不是要过度关注竞争对手，因为那会导致“局部最优”（local maxima），而不是去思考公司可以实现的阶跃式变化和突破。但当你分析竞争对手的方法时，评估该领域的其他人正在做什么可以给你一个有用的基准，并识别出你的公司可以填补的机会、空白和利基市场。接下来是关键的一步：**采取不同的路径（Taking a different path）**。你必须刻意走一条与众不同的路。制定一套能让公司脱颖而出的策略至关重要。我认为这是营销学科的核心——确保市场差异化。你不需要躲进山洞里苦思冥想这些点子和策略。你通常可以去观察那些远超你自身领域的行业，而不是只看直接竞争对手，从中寻找可以交叉应用、引入甚至“偷”到你自己的领域或垂直行业的好主意。最后一步就是**实验（Experimenting）**、测试、验证，然后扩大有效的规模，舍弃无效的部分。你必须具备舍弃工作的能力，即使你可能在某篇精彩的内容上花费了大量心血。如果它不起作用，就不要加倍投入。沉没成本谬误（sunk cost fallacy）的偏见经常会起作用，尤其是当你倾注心血创作营销素材时。所以，去实验、测试、验证。给人们（尤其是你的团队和组织）失败的心理安全感。然后，一旦找到有效的方法，就全力以赴。

---

### [00:15:06] Lenny Rachitsky

**English:**
Let me summarize what you just shared here. So essentially if you think you're like, "I need help with marketing," or, "I have a problem and I think I need to hire a demand gen person or a paid growth person or a SEO person, or I don't know, content writer," something like that, before you do that, first of all, go through these four steps. So step one is diagnose. Spend time understanding what's the specific problem you want to solve, then analyze. This is so interesting, I've never heard it this way. So then it's analyze what your competition is doing so that you can then, one, find inspiration and see where gaps exist. And then it sounds like the core part of it is just make sure you differentiate and choose a different path versus just try to be the better thing or the cheaper thing. And then the final piece is just like, "Okay, here's our path. Let's test run some small scale tests to see if this would work."

**中文翻译:**
让我总结一下你刚才分享的内容。本质上，如果你觉得“我需要营销方面的帮助”，或者“我有个问题，我觉得需要招一个需求挖掘人员、付费增长人员、SEO 专家，或者内容作者”之类的，在做这些之前，首先要经过这四个步骤。第一步是诊断：花时间了解你想解决的具体问题。然后是分析：这很有趣，我从未听过这种说法。分析竞争对手在做什么，以便你可以从中寻找灵感并发现差距。核心部分似乎是确保差异化，选择一条不同的路径，而不是仅仅试图做得更好或更便宜。最后一步就是：“好，这是我们的路径，让我们进行一些小规模测试，看看是否奏效。”

---

### [00:15:54] Krithika Shankarraman

**English:**
Yeah. I'm a marketer through and through now. So I mean you got diagnose, D. Analyze, A. Take a different path, T. And experiment for the E. So it's the DATE framework. I've just kind of coined it.

**中文翻译:**
是的。我现在是一个彻头彻尾的营销人了。所以你看，诊断（Diagnose）是 D，分析（Analyze）是 A，采取不同路径（Take a different path）是 T，实验（Experiment）是 E。所以这就是 DATE 框架。我刚刚才想出这个缩写。

---

### [00:16:05] Lenny Rachitsky

**English:**
Oh, beautiful. Okay. We got a new framework hot off the presses. I love it. DATE, okay. So with differentiation, what's your thoughts on saying you're just a lot better or a lot cheaper?

**中文翻译:**
噢，太棒了。我们有了一个刚出炉的新框架。我喜欢这个，DATE。那么关于差异化，你对“只是说自己更好或更便宜”有什么看法？

---

### [00:16:19] Krithika Shankarraman

**English:**
Being cheaper is a race to the bottom, especially when you think about sort of scaling laws and how things are playing out. Every company is sort of becoming an AI company at this time. And so as models get cheaper and more capable, being cheaper is not going to be the thing that really is a durable approach in the market. And I think in terms of doing things differently, it's not just for the sake of it. I think it's really that novelty and that differentiation is something that people are craving for. They're not looking for yet another tool in the market. They are looking for something that aligns with their values, aligns with what their goals are. And so if you can be really crisp on understanding the user need, understanding what is the problem space in which they're operating, I think that one-two punch of a fantastic product experience, and then the marketing experience to match, can be a superpower for your company.

**中文翻译:**
追求更便宜是一场“逐底竞争”（race to the bottom），尤其是考虑到规模法则（scaling laws）和现状。现在每家公司都在变成 AI 公司。随着模型变得越来越便宜且功能越来越强，价格低廉将不再是市场上持久的竞争手段。我认为，做不同的事情不仅仅是为了不同而不同。人们渴望的是那种新颖感和差异化。他们不想要市场上又一个平庸的工具。他们寻找的是能与他们的价值观和目标相契合的东西。因此，如果你能非常清晰地理解用户需求，理解他们所处的“问题空间”，我认为“出色的产品体验”加上“与之匹配的营销体验”这种组合拳，可以成为公司的超级力量。

---

### [00:17:11] Lenny Rachitsky

**English:**
Awesome. Okay. So let's go through an example of a company you did this with, and then this may take us to another company you worked at in the stories there.

**中文翻译:**
太棒了。那我们来看一个你实践过这个框架的公司案例，这可能会带出你工作过的另一家公司的故事。

---

### [00:17:19] Krithika Shankarraman

**English:**
Yeah. One that comes to mind is definitely Retool. Retool was very different from both my experiences at Stripe and at OpenAI because both Stripe and OpenAI, for better or for worse, were inbound companies, right? There was so much latent demand that we were fighting off people breaking down the door trying to get to our products. With Retool, marketing was between the company and revenue. And we had fantastic product market fit with the enterprise space, with the developer community, but awareness was a challenge. And so how do we go out, not just wait inside of our house waiting for people to knock down the door, but rather step outside of our house and start introducing ourselves to the neighborhood? So, thinking about outbound channels and building demand engines was the name of the game. And here, one of the ways to think about that is, "Hey, should we just scale the paid marketing channels that we already have working for us?" And that's when the diagnostic really came into play, which is, what are the leads that are coming through the funnel? Are they turning into sales-qualified opportunities? What kind of pipeline are they driving? A lot of marketing metrics, again, tend to be vanity metrics. They tend to be about the number of clicks that you got, number of views that a tweet got, number of impressions. I think those are all bullshit numbers. Really, what you want to be looking at is your impact on either signups if you're a self-serve product, PLG, or in terms of a B2B company, sales leads and revenue that you're driving, pipeline and opportunity that you're driving. So we diagnosed that and we found that for the most part, our paid social channels were doing not much for us. And so we had to invest in net new engines. So that was the diagnostic. When we looked at some of the competitors, we saw that they were doing a lot of content marketing. They were doing a lot of events programming. And we could've kind of followed in those footsteps, but there was the ability to take a different path. And so what we decided to do was double down on customer marketing and customer storytelling because the thing that differentiated Retool from a lot of the copycat competitors in the market was that we had terrific traction with true enterprises who were paying for the product, who believed in the product, who were expanding within the product. And so having them tell the stories on our behalf was so much more compelling, and no other company could replicate the kind of customers that Retool had in its bench. So, we wanted to make sure that we were using those logos, we were using those companies to the best impact possible, and then we experimented. We tried to put together webinars, different types of sales dinners, different types of event formats to see what actually worked best for us, and scaled the ones that worked and discarded the ones that didn't.

**中文翻译:**
是的。我首先想到的是 Retool。Retool 与我在 Stripe 和 OpenAI 的经历非常不同，因为无论好坏，Stripe 和 OpenAI 都是“被动型”（inbound）公司，对吧？那里有如此多的潜在需求，以至于我们得应付那些挤破头想用我们产品的人。而在 Retool，营销是连接公司与收入的关键。我们在企业领域和开发者社区都有极佳的产品与市场契合度，但知名度是个挑战。所以，我们如何主动出击，而不是坐在家里等别人敲门，而是走出家门向邻居介绍自己？因此，思考主动触达（outbound）渠道和建立需求引擎是关键。在这里，一种思考方式是：“嘿，我们是不是应该直接扩大那些已经见效的付费营销渠道？”这时诊断就派上用场了：进入漏斗的线索是什么？它们是否转化成了销售合格机会（SQO）？它们驱动了什么样的销售管线（pipeline）？很多营销指标往往是虚荣指标，比如点击量、推文观看量、曝光量。我觉得这些都是扯淡的数据。你真正应该看的是你对注册量的影响（如果你是自服务产品或 PLG），或者对于 B2B 公司来说，是你驱动的销售线索、收入、管线和机会。我们进行了诊断，发现大部分付费社交渠道对我们没什么用。所以我们必须投资全新的引擎。这就是诊断。当我们观察竞争对手时，发现他们做了很多内容营销和活动策划。我们本可以跟随他们的脚步，但我们有能力走一条不同的路。于是我们决定加倍投入**客户营销和客户故事讲述**，因为 Retool 区别于市场上众多模仿者的关键在于，我们拥有真正的企业客户，他们付费使用、信任产品并在内部扩大使用规模。让他们代表我们讲述故事要更有说服力，而且没有其他公司能复制 Retool 拥有的客户群。所以，我们希望确保尽可能发挥这些品牌背书的作用，然后我们进行了实验。我们尝试举办网络研讨会、各种类型的销售晚宴、不同形式的活动，看看哪种最有效，然后扩大有效的规模，舍弃无效的。

---

### [00:20:02] Lenny Rachitsky

**English:**
Okay, there's so much here. So in the diagnose step, I think in kind of a between-the-lines piece of advice here is look at what's already working. So you looked at, okay, maybe paid growth, maybe this, maybe that. And then it's like, "Okay, what seems to be working is people find us through maybe another logo, another customer that's fancy, and they're like, 'Oh, Netflix is using Retool. Oh, maybe I should check it out.'" So I think that's a really important lesson there is don't try to like, "Hey, we need to start expanding our top of funnel to all these different channels." There's one more-

**中文翻译:**
好，这里面信息量很大。在诊断步骤中，我认为一个隐含的建议是：看看什么已经奏效了。你观察了付费增长等等，然后发现：“好吧，似乎有效的是人们通过另一个大品牌、另一个高端客户发现我们，他们会想，‘哦，Netflix 也在用 Retool，也许我也该试试。’”所以我认为这是一个非常重要的教训：不要盲目地想“嘿，我们需要把漏斗顶部扩展到所有这些不同的渠道”。还有一个——

---

### [00:20:32] Krithika Shankarraman

**English:**
And really litigate some of those channels, too, because on the surface they might be working, but are they actually driving pipeline and revenue?

**中文翻译:**
而且要真正去“审问”其中的一些渠道，因为表面上它们可能有效，但它们真的驱动了销售管线和收入吗？

---

### [00:20:38] Lenny Rachitsky

**English:**
Got it. So they may be showing vanity metrics. Numbers are nice at the top, but they're not sales qualified potential. They don't actually stick around. Okay. And then, the analyze competition is really interesting. So again, it's just like, "What are they doing? What can we be doing differently?" Does it ever make sense just to do what they're doing but do it better, or is that rarely a successful path?

**中文翻译:**
明白了。所以它们可能只是显示虚荣指标。漏斗顶部的数字很好看，但它们不是销售合格的潜力客户，也不会留存。好。然后，分析竞争对手这一点很有趣。再次强调，就是“他们在做什么？我们可以做些什么不同的？” 仅仅做他们正在做的事情但做得更好，这有意义吗？还是说这很少是一条成功的路径？

---

### [00:20:58] Krithika Shankarraman

**English:**
You still have to do something a little bit different. I recall a very specific example at Stripe where our product, Stripe Connect, which was made for marketplaces like Uber and Airbnb, where not only are you accepting money as a platform, you're also paying out people on the seller side of the marketplace. The competition truly was to become a payment facilitator. So rather than using another off-the-shelf service, instead of using Stripe Connect, you might go off and become a PayFac yourself. And a lot of the services, organizations, the consulting groups that were helping companies become PayFacs, the things that they were doing was really leaning into that old school terminology, the jargon of the legacy systems and so on and so forth. And Stripe kind of figured out, "Hey, we need to rank higher for the SEO terms that people are searching for. So how do we help rank for PayFac without actually talking about ourselves as a PayFac solution?" So we decided to kind of do a reverse RFP system where we created a piece of content that said, "Hey, if you want to be a payment facilitator, here's the secret playbook. Here's all the things that you have to do. And by the way, if this feels onerous or annoying, it is, and you should use Stripe Connect instead." So there was still a little bit of a zigging where others were zagging. Yeah, but I think if we had done the same thing in terms of becoming a consulting service to become a payment facilitator, Connect would be nowhere near the sort of run rate or revenue that it drives for the company.

**中文翻译:**
你还是得做一些稍微不同的事情。我记得 Stripe 的一个非常具体的例子。我们的产品 Stripe Connect 是为 Uber 和 Airbnb 这样的平台设计的，作为平台，你不仅要收款，还要向卖方打款。当时的竞争对手实际上是“支付促进者”（PayFac）。所以，与其使用 Stripe Connect 这样的现成服务，你可能会选择自己成为一个 PayFac。很多帮助公司成为 PayFac 的服务机构和咨询团队，他们所做的是沉溺于那些老派的术语、遗留系统的黑话等等。Stripe 意识到：“嘿，我们需要在人们搜索的 SEO 词条中排名更高。那么，如何在不把自己标榜为 PayFac 解决方案的情况下，在 PayFac 搜索中获得高排名呢？”于是我们决定做一个“反向 RFP（征求建议书）”系统，我们创作了一篇内容说：“嘿，如果你想成为支付促进者，这是秘密手册。这是你必须做的所有事情。顺便说一句，如果这让你觉得繁琐或讨厌，那确实如此，你应该改用 Stripe Connect。”所以这仍然是在别人往左走时我们往右走（zigging where others were zagging）。是的，我认为如果我们也做同样的事情，变成一个咨询服务，Connect 绝对不会达到现在为公司带来的这种运行率或收入水平。

---

### [00:22:29] Lenny Rachitsky

**English:**
Okay. And this is a great segue to Stripe, which, another company you were the very first marketing hire at. You were also, I believe, the only marketing person for three years at Stripe.

**中文翻译:**
好。这很好地过渡到了 Stripe，这是另一家你是首位营销员工的公司。而且我相信，你在 Stripe 独自负责了三年的营销。

---

### [00:22:38] Krithika Shankarraman

**English:**
I do not recommend that to anybody.

**中文翻译:**
我不向任何人推荐这种做法（太累了）。

---

### [00:22:41] Lenny Rachitsky

**English:**
There's a lesson there. Okay, so let's talk about Stripe. What are some of the biggest things you learned marketing at Stripe that you think might be helpful to other marketing people and founders?

**中文翻译:**
这本身就是一个教训。好，那我们聊聊 Stripe。在 Stripe 负责营销期间，你学到的哪些最重要的东西是你认为对其他营销人员和创始人有帮助的？

---

### [00:22:51] Krithika Shankarraman

**English:**
Oh, man, there are so many things to choose from because I was Stripe for almost eight and a half years. Joining as the company's first marketing hire, building that marketing function from the ground up, it really gave me the privilege of working very closely with our founders, John and Patrick. I would say actually I was not the first marketer at Stripe, John and Patrick were the first marketers at Stripe because they were developers themselves. They truly understood the developer community. And when that audience for Stripe was squarely developers to begin with, they knew exactly how to authentically reach that audience. And so I had to unlearn a lot of the things that I had learned at Google and Dropbox coming into Stripe in order to reach developers authentically. The experience really taught me the importance of deep product understanding as well. You couldn't really play act at understanding the product, especially when developers are trained to spot bugs, right? So not only do they spot those bugs in code, they spot those bugs in marketing and in blog posts. And so if the marketing pieces are your first impression of the product, they're an extension of the product itself, you have to hold yourself to a very high bar in terms of how you communicate about the product. And so we did a lot of investment in design work, in polish in terms of how the marketing came together. And yeah, the value of creating marketing artifacts that were deeply integrated with the company's mission and the craftsmanship that went into the product was another lesson that I learned very deeply at Stripe.

**中文翻译:**
噢，天哪，有太多可以选了，因为我在 Stripe 待了将近八年半。作为公司的第一位营销员工加入并从零开始建立营销职能，让我有幸能与创始人 John 和 Patrick 紧密合作。我会说，实际上我不是 Stripe 的第一个营销人，John 和 Patrick 才是，因为他们本身就是开发者。他们真正了解开发者社区。当 Stripe 最初的受众完全是开发者时，他们非常清楚如何真实地触达这群人。因此，为了真实地触达开发者，我进入 Stripe 后不得不“忘掉”很多在 Google 和 Dropbox 学到的东西。这段经历也教会了我深度理解产品的重要性。你不能假装了解产品，尤其是当开发者受过专门训练去寻找 Bug 时。他们不仅能在代码中发现 Bug，也能在营销文案和博客文章中发现。如果营销素材是用户对产品的第一印象，它们就是产品本身的延伸，你必须在产品沟通方面对自己要求极高。因此，我们在设计工作和营销素材的打磨上投入了大量精力。是的，创造与公司使命深度融合、体现产品匠心的营销作品，是我在 Stripe 学到的另一个深刻教训。

---

### [00:24:23] Lenny Rachitsky

**English:**
So kind of along those lines, again, people may look at Stripe and be like, "Okay, it's the best thing ever for payments. Why do we need marketing? It's just like, engineers build it and integrate, it works." What is it that marketing most adds to a product like Stripe?

**中文翻译:**
顺着这个思路，人们可能会看着 Stripe 想：“好吧，它是支付领域最棒的东西。为什么需要营销？工程师把它造出来，集成一下，就能用了。” 营销能为像 Stripe 这样出色的产品增加什么价值？

---

### [00:24:40] Krithika Shankarraman

**English:**
Across my time at Stripe, marketings are very different purposes. And so I kind of see it in different epochs or chapters of my time at the company. The first chapter when I joined, our head of partnerships at the time, Cristina Cordova, handed me a Hackpad at the time, which is like a notion- (Lenny: I remember Hackpad.) Oh, yeah. (Lenny: It turned into Dropbox Paper.) That's right. And so she had kept a Hackpad, a secret Hackpad away from the engineering team, which was all of the features and products that we had shipped but had never communicated to our customers about. And so the launch sort of ended with shipping the feature rather than communicating with the user. So the first chapter at Stripe was really just getting through that backlog and making sure that the ethos at the company changed to say, "Hey, your launch isn't complete if you're just code complete. You have to actually ship it to the customer and make them aware of it." So usage became the north star, engagement became the north star rather than just the binary, has it launched or not? The second chapter at Stripe was really starting to expand what a launch meant, right? So, going from just putting out a blog post for people who were already subscribed to the RSS feed of the company versus thinking through, "Hey, how do we reach out to them through an email, through other channels? How do we really invest in this fanatical community that is getting so excited about the product experience?" So we pulled together developer experience as a function, built out developer relations to really have that community feeling and vibe. And then it was about starting to think through the multi-product ecosystem. So Stripe went from a single-threaded payments processing company to one that had multiple different products and features for the audience and the user base. So then the work of marketing became, how do you help people understand and navigate potentially this multi-product ecosystem and platform to figure out what's the right set of features and solutions that they should be using for their needs?

**中文翻译:**
在我效力 Stripe 期间，营销服务于非常不同的目的。我把它看作我在这家公司时期的不同“纪元”或章节。第一章是我刚加入时，当时的合作伙伴负责人 Cristina Cordova 给了我一个 Hackpad（类似于现在的 Notion）。（Lenny：我记得 Hackpad。）噢是的。（Lenny：它后来变成了 Dropbox Paper。）没错。她背着工程团队偷偷记了一个 Hackpad，上面全是已经发布但从未向客户沟通的功能和产品。所以当时的“发布”仅仅止于交付功能，而不是与用户沟通。因此，Stripe 的第一章实际上就是处理这些积压工作，并确保公司的文化发生转变，即：“如果只是代码完成了，发布就不算完成。你必须真正把它交付给客户并让他们知晓。” 于是，使用量和参与度成为了北极星指标，而不仅仅是“是否发布”这个二元结果。Stripe 的第二章是真正开始扩展“发布”的含义。从仅仅为订阅了 RSS 的人发一篇博客，转变为思考：“嘿，我们如何通过邮件和其他渠道触达他们？我们如何真正投资于这个对产品体验感到兴奋的狂热社区？”于是我们组建了开发者体验职能部门，建立了开发者关系（DevRel），以营造社区感。接着是开始思考多产品生态系统。Stripe 从一家单一的支付处理公司转变为一家为受众和用户群提供多种不同产品和功能的平台。于是营销的工作变成了：你如何帮助人们理解并引导他们在这个多产品生态系统和平台中找到最适合他们需求的特征和解决方案？

---

### [00:26:41] Lenny Rachitsky

**English:**
And so this is, again, a good example of marketing can do a lot of different things and depends on the stage, depends on the needs. It almost starts again with diagnose. Where do we have a need for marketing and growth?

**中文翻译:**
所以这再次证明了营销可以做很多不同的事情，这取决于阶段和需求。它几乎又是从“诊断”开始：我们在哪里需要营销和增长？

---

### [00:26:53] Krithika Shankarraman

**English:**
And especially in hyper-growth companies, I think you have to run that diagnostic every three months, every six months in order to stay adaptable and flexible because those top level goals do change. At some point, we really have to figure out how to scale our sales function. We have to figure out how to scale internationally. And so being adaptable to that meant constant reprioritization and making sure that you were also hiring people who weren't super deep in particular disciplines, but having a team structure that was T-shaped, people who could be flexible to those needs of the company.

**中文翻译:**
特别是在高速增长的公司，我认为你必须每三个月或六个月进行一次诊断，以保持适应性和灵活性，因为高层目标确实会改变。在某些阶段，我们必须弄清楚如何扩展销售职能，如何进行国际化扩展。适应这些变化意味着不断重新排列优先级，并确保你招聘的人员不仅在特定领域有深度，而且具备“T型”团队结构，即能够灵活应对公司需求的人才。

---

### [00:27:24] Lenny Rachitsky

**English:**
Coming back to your point about how there's no playbooks, is Stripe another example where it's like, this has never been done before, we shouldn't copy what other payments companies have done in the past?

**中文翻译:**
回到你说的“没有策略手册”这一点，Stripe 是不是另一个例子，即“这件事以前从未有人做过，我们不应该复制其他支付公司过去的做法”？

---

### [00:27:34] Krithika Shankarraman

**English:**
Yeah. If we did, we would still be talking about PCI compliance and payment gateways.

**中文翻译:**
是的。如果我们那样做了，我们现在还在谈论 PCI 合规和支付网关。

---

### [00:27:40] Lenny Rachitsky

**English:**
There's so much of what you share that reminds me of Raaz from Wiz, who also, you were an engineer originally, she was a product person. Yeah, I think. I don't know if she was an engineer, but a product person. So it's your-

**中文翻译:**
你分享的很多东西让我想起了 Wiz 的 Raaz，她也一样，你最初是工程师，她是产品人。是的，我想。我不确定她是不是工程师，但她是产品背景。所以这是你的——

---

### [00:27:52] Krithika Shankarraman

**English:**
Her first PM, actually. Yeah, Raaz is great.

**中文翻译:**
实际上是他们的第一个 PM。是的，Raaz 很棒。

---

### [00:27:54] Lenny Rachitsky

**English:**
Okay. And I think there's a few things that are so interesting here. One is you both have non-marketing backgrounds, you went from another function. And I think, you tell me, it gives you a whole new perspective on marketing, not just the traditional education of marketing. Is there anything there?

**中文翻译:**
好。我觉得这里有几点非常有趣。一是你们都有非营销背景，是从其他职能转过来的。我想，你告诉我，这是否给了你一个全新的营销视角，而不仅仅是传统的营销教育？有什么体会吗？

---

### [00:28:09] Krithika Shankarraman

**English:**
One thing it's definitely made me is very skeptical of most marketing channels and strategies and tactics. And so I would be one of the first people to say, "Is that really going to work? What developer is clicking on paid ads? Isn't a better thing that we could be doing for them telling them to install ad block?" So I think that skepticism means that you just have a higher bar for the quality of the content, the substance of the content. You want to make sure that the marketing is as substantive and as crafted as the product experience itself.

**中文翻译:**
有一点是肯定的，它让我对大多数营销渠道、策略和战术持怀疑态度。我会是第一个问：“那真的有效吗？哪个开发者会去点付费广告？我们为他们做的更好的事情难道不是告诉他们安装广告拦截插件吗？”所以这种怀疑态度意味着你对内容的质量和实质有更高的标准。你希望确保营销内容像产品体验本身一样充实且精心打造。

---

### [00:28:40] Lenny Rachitsky

**English:**
The other really interesting corollary here is she was very big on avoiding the generic acronyms and classic industry norms, I forget what they were, for cloud security. But it's just like, "We're not this thing. We're Wiz. Here's what we do."

**中文翻译:**
另一个有趣的相似之处是，她非常坚持避免使用通用的缩写和经典的行业规范（我忘了云安全领域具体是什么了）。她会说：“我们不是那种东西。我们是 Wiz。这是我们做的。”

---

### [00:28:53] Krithika Shankarraman

**English:**
They are definitely a company that zags when others zig. I still have my Wiz socks, which have these beautiful 8-bit characters on them. Their branding really stands out in the sea of sameness in SaaS conferences.

**中文翻译:**
他们绝对是一家在别人往左时往右走的公司。我还留着 Wiz 的袜子，上面有漂亮的 8 位元字符。在 SaaS 会议那千篇一律的海洋中，他们的品牌确实脱颖而出。

---

### [00:29:05] Lenny Rachitsky

**English:**
Okay. There's something I heard that you did at Stripe that I wanted to ask you about that worked really well. When you came into Stripe, you looked at all of the biggest customer support issues and you turned those into docs to help people serve themselves. Can you just talk about that insight and the power of doing something like that?

**中文翻译:**
好。我听说你在 Stripe 做了一件效果非常好的事情，我想问问。当你进入 Stripe 时，你查看了所有最大的客户支持问题，并将它们转化为文档，帮助人们自助解决。你能谈谈那个见解以及这样做带来的力量吗？

---

### [00:29:22] Krithika Shankarraman

**English:**
Yeah, and this was a great practice that existed at Stripe even before I joined, which is all new hires would do a support rotation just to build empathy with our customers. So, users first was a very core operating principle for the company, and we spent about 20% of our time collectively talking to customers, talking to users, talking to non-users to understand their needs, their gripes about the product. And that tradition, I think, continues to today. The support rotation specifically was such a fantastic fountain of understanding, "Hey, these are the areas that people are confused about." Again, I kind of mentioned this sort of cheat code of talking to your customers and using the language that they use to describe their problems as a shortcut to fantastic product marketing and messaging, because it really tells you what are their pain points and how can you meet them where they are. You want them nodding their heads along as they're reading your landing pages. And so when I was doing the support rotation, there were thematic things that kept coming up. People were asking, "Hey, do you process subscription payments or recurring payments?" Or, "Can I pay people out with Stripe?" And I was like, "Of course you could, but there's no reason you should know that because we don't tell you anywhere." And so that ended up being a stacked rank backlog of landing pages that we produce that just educated people. And this is really important when you have strong top of funnel demand, and potentially not as many people and you're not trying to scale your teams linearly. Having those educational resources, especially for developers, a fantastic marketing funnel sometimes doesn't look like talking to sales. It often never looks like talking to sales. It looks like a self-directed educational experience. Even the sales process ends up being very consultative typically with very technical folks on the other side. So yeah, that was a great way and a great program to figure out what content we should focus and prioritize.

**中文翻译:**
是的，这是 Stripe 在我加入之前就有的优良传统，即所有新员工都要进行支持轮岗（support rotation），以建立与客户的共情。所以，“用户第一”是公司非常核心的运营原则，我们集体花费约 20% 的时间与客户、用户和非用户交谈，了解他们的需求和对产品的抱怨。我认为这个传统延续至今。支持轮岗尤其是一个极好的理解源泉，让你知道“嘿，这些是人们感到困惑的地方”。再次强调，我提到的那个“作弊码”——与客户交谈并使用他们描述问题的语言，是通往出色产品营销和传讯的捷径，因为它能告诉你痛点在哪里，以及如何满足他们的需求。你希望他们在阅读你的落地页时不断点头。当我在做支持轮岗时，有一些主题性的问题反复出现。人们会问：“嘿，你们处理订阅支付或经常性付款吗？”或者“我可以用 Stripe 给别人打款吗？”我会想：“当然可以，但你没理由知道这一点，因为我们没在任何地方告诉你。”于是，这变成了一个按优先级排列的落地页积压清单，我们制作这些页面来教育用户。当你拥有强大的漏斗顶部需求，但人手有限且不想线性扩展团队时，这非常重要。拥有这些教育资源，尤其是对于开发者来说，一个出色的营销漏斗有时看起来不像是在和销售谈话。它通常看起来像是一种自我导向的教育体验。甚至销售过程通常也是咨询式的，对方通常是非常技术的人员。所以，是的，这是一个弄清楚我们应该关注和优先处理哪些内容的绝佳方式和项目。

---

### [00:31:12] Lenny Rachitsky

**English:**
These are really cool just little ways as a new marketing person. You can add value really quickly is kind of what I'm taking away.

**中文翻译:**
作为一名营销新人，这些真的是非常酷的小方法。我学到的是，你可以非常快速地增加价值。

---

### [00:31:21] Krithika Shankarraman

**English:**
Talking to customers is at the top of the list.

**中文翻译:**
与客户交谈永远排在第一位。

---

### [00:31:24] Lenny Rachitsky (Ad: LinkedIn Ads)

**English:**
Today's episode is brought to you by LinkedIn Ads... [Full ad text omitted]

**中文翻译:**
本集节目由 LinkedIn Ads 赞助……（此处省略广告正文翻译）

---

### [00:32:32] Lenny Rachitsky

**English:**
There's something else that I know that you're a big advocate of which is internal reviews and just making sure everyone's aligned, which I think a lot of people and especially startups try to avoid. Like, "Let's just move fast. We don't need to have all these meetings where people review stuff," but I know you're a big advocate of that. Talk about why that's so important.

**中文翻译:**
我知道你还非常推崇另一件事，那就是内部评审（internal reviews）并确保每个人都达成一致。我认为很多人，尤其是初创公司，会试图避免这一点。他们觉得：“我们要快，不需要开这么多评审会。”但我知道你非常支持这个。谈谈为什么这如此重要。

---

### [00:32:48] Krithika Shankarraman

**English:**
Yeah, this is a hill that I would die on, which is that good process or sufficient process is actually something that speeds up a company rather than slow it down. It stems from this idea that we talked about a little bit, which is that marketing is an extension of your product. It's the first touchpoint your customers have with your product. And ideally, you're setting expectations there in terms of what they should expect once they sign up for the product or commit to a contract and start using it within their companies. And when I think about that, consistency is really, really important. The other part, the other facet of why process is important is because especially as you're in hyper-growth companies, scaling teams is part and parcel like what you're trying to do. And when you bring in someone new, you want them to be just as self-sufficient as somebody who's been at the company for two years. So in your second week, can you be as successful as someone who's been at the company for two years? And the reason that I have that principle in mind is because it makes you kind of break out of your shell of, "I've been at this company for some time now. I understand the sort of unspoken rules of the organization. I've built up enough social capital that I can withdraw from to get something done. And I know which conference room to stand outside of to get the founder to review a piece of content before it goes out the door." That is not scalable, that is not sustainable. And so if you want somebody to be successful and contributing member of the organization very, very quickly, setting up some of these processes with the intention of trying to help them navigate how to go from idea to execution can be very empowering and powerful. Nobody wants to do the wrong thing. They want the guardrails to understand what great looks like at the company.

**中文翻译:**
是的，这是我坚决捍卫的观点：良好的流程或充足的流程实际上是加速公司发展的东西，而不是减慢它。这源于我们刚才讨论过的观点，即营销是产品的延伸。它是客户与产品的第一个接触点。理想情况下，你是在那里设定预期，让他们知道一旦注册产品或签署合同并在公司内部开始使用时应该期待什么。考虑到这一点，一致性（consistency）就变得非常非常重要。流程重要的另一个方面是，特别是在高速增长的公司中，扩展团队是你工作的重要组成部分。当你引入新人时，你希望他们能像在公司待了两年的老员工一样自给自足。那么，在你入职的第二周，你能像待了两年的老员工一样成功吗？我坚持这一原则的原因是，它能让你打破这种局面：“我在这家公司待了一段时间，我了解组织中那些潜规则，我积累了足够的社交资本可以用来办事，我知道该站在哪个会议室门口等创始人评审内容。” 这是不可扩展的，也是不可持续的。所以，如果你想让某人非常迅速地成为组织的成功贡献者，建立一些旨在帮助他们完成从创意到执行的流程，会非常有赋能作用且强大。没有人想做错事，他们需要护栏来理解公司心目中的“优秀”是什么样的。

---

### [00:34:33] Lenny Rachitsky

**English:**
Can you speak more about what this looks like? Say a startup wants to start implementing something like this.

**中文翻译:**
你能多谈谈这具体是什么样的吗？假设一家初创公司想开始实施这样的流程。

---

### [00:34:38] Krithika Shankarraman

**English:**
Two simple processes that you could put into place today is, one, set up a forum called Marketing Review. This can be a live meeting that you host for an hour a week or it can be a Slack channel where people are posting things async, or even an email alias where things get sent to. Have that be transparent to the rest of the organization so anyone in the marketing team, anyone in the product organization can join that forum. What that does is it creates a fishbowl where you see sort of, what are the themes that come out when somebody reviews a piece of content? Are they looking at the strategy? Are they looking at the audience? Are they looking at the words? Are they looking at the sort of design approach? So you learn through osmosis of looking at some of these discussions. And then I would say don't overdo it. I would say there are probably two checkpoints in a program that are really important to get aligned at. One is the 20% review. A 20% review is a strategy review. What are we trying to accomplish? Who are we trying to do it for, and what is the rough approach that we're going to take? If everyone feels comfortable with that, you come back at the 80% mark where you've done a lot of the work on the artifacts, the different types of teams that have to be involved and how do you take something to market it in the first place. And the reason that I say 80% is sort of critical because if you come in at the 99% mark and you're just looking for a rubber stamp of approval, and you don't really have the slack in the system to be able to make any changes, then that review was worthless. So come in at the 80% mark where you can still make some substantive changes before it goes out the door. And that serves the purpose of consistency so that your brand is showing up in a consistent way to the audience. And two, it helps the rest of the organization learn from each other.

**中文翻译:**
你今天就可以实施两个简单的流程。第一，设立一个名为“营销评审”（Marketing Review）的论坛。这可以是一个每周一小时的现场会议，也可以是一个大家异步发布内容的 Slack 频道，甚至是专门的邮件别名。让它对组织的其余部分透明，这样营销团队或产品组织的任何人都可以加入。这样做创造了一个“鱼缸效应”，你可以看到当有人评审内容时会出现哪些主题。他们是在看策略吗？在看受众吗？在看措辞吗？还是在看设计方法？这样你就可以通过观察这些讨论潜移默化地学习。第二，不要做得太过火。我认为一个项目中有两个关键的对齐检查点。一个是 **20% 评审**。20% 评审是策略评审：我们要实现什么目标？受众是谁？我们打算采取的大致方法是什么？如果大家都觉得没问题，你就在 **80% 进度**时再回来，那时你已经完成了大部分素材工作，确定了涉及的团队以及如何推向市场。我之所以说 80% 很关键，是因为如果你在 99% 的时候才来，只是为了寻求一个“橡皮图章”式的批准，而系统已经没有余地进行任何更改，那么这次评审就毫无意义。所以要在 80% 的时候介入，这样在发布前还能进行一些实质性的修改。这既保证了一致性，让你的品牌以统一的方式呈现在受众面前，又能帮助组织的其他成员互相学习。

---

### [00:36:19] Lenny Rachitsky

**English:**
There's almost this unspoken element of what you're describing that I want to dig into a little bit, which is the need and value of having consistent and high quality marketing, communication. Why is that important? There's always this talk of just move fast break things. "We're going to be scrappy. We're not going to be obsessed with perfect quality of our, I don't know, websites and emails." Just, why is that important? Why do you value that? Why should companies maybe value that more?

**中文翻译:**
你所描述的内容中似乎有一个隐含的元素我想挖掘一下，那就是拥有持续且高质量的营销沟通的需求和价值。为什么这很重要？人们总是在谈论“快速行动，打破常规”。“我们要简陋一点（scrappy），不要痴迷于网站和邮件的完美质量。” 为什么这很重要？你为什么看重这个？为什么公司应该更看重这一点？

---

### [00:36:45] Krithika Shankarraman

**English:**
It's funny because with the companies who value velocity actually do value their brand just as much, but oftentimes they think of these as two siloed separate initiatives that they have to put their headspace and calories towards. And I actually think they are not mutually exclusive. They are actually very interconnected. And so when you understand the consistency of your brand, it actually empowers the organization to move faster because you kind of understand how you want the brand to show up in the world. What is that experience that you want your customers to come away with when they interact with your brand? And the brand is not just marketing artifacts, it is your product experience. It is how your customer support team talks to them, how they resolve tickets. Are you getting passed between a bunch of different teams or is someone just resolving your ticket right away? It's the experience that they have for candidates when they come to recruit your company. So all of these variety of touch points that touch so many different organizations and teams within your organization, they are the amalgamation that makes up your brand. And so if you think of these two things as separate silos, you are optimizing for entirely the wrong thing.

**中文翻译:**
很有趣，因为那些看重速度的公司实际上同样看重品牌，但他们往往认为这是两个孤立的、需要分别投入精力的项目。而我实际上认为它们并不互斥，而是紧密相连的。当你理解了品牌的一致性，它实际上能赋能组织行动得更快，因为你清楚地知道你希望品牌以何种形象呈现在世人面前。你希望客户在与你的品牌互动时获得什么样的体验？品牌不仅仅是营销素材，它是你的产品体验，是你的客户支持团队如何与他们交谈、如何解决工单。你是被在不同团队之间踢皮球，还是有人立即解决了你的问题？它是应聘者来公司面试时的体验。所有这些触及组织内这么多不同部门和团队的触点，共同构成了你的品牌。所以，如果你把这两者看作独立的孤岛，你的优化方向就完全错了。

---

### [00:38:02] Lenny Rachitsky

**English:**
I've very viscerally learned the power of brand doing my newsletter. I so fear doing something very wrong in my newsletter. It's like, saying something that's completely off or having something broken, or sending an email by accident to everyone that's not ready. I just feel like once I break that, just there's so much power and trust that people have built for what I share and there's so much power that comes from that trust. If I launch a new podcast, people will assume it will be good if they trust what I do and I maintain high quality. And so it's just like a constant fear I have now of breaking that trust.

**中文翻译:**
在做时事通讯的过程中，我非常深刻地体会到了品牌的力量。我非常害怕在时事通讯中犯严重的错误。比如说了完全不着边际的话，或者链接坏了，或者不小心把没准备好的邮件发给了所有人。我觉得一旦我打破了这种信任——人们对我分享的内容建立了很多信任，而这种信任蕴含着巨大的力量。如果我发布一个新的播客，如果人们信任我并看到我一直保持高质量，他们就会预设它会很好。所以，我现在一直担心会破坏这种信任。

---

### [00:38:40] Krithika Shankarraman

**English:**
Yeah, I mean whether it's fear that drives you is questionable because I think it's also a commitment to your craft. (Lenny: Yeah, yeah.) But I think that's exactly right. A brand is an expectation that you create within your audience.

**中文翻译:**
是的，虽然驱动你的是否仅仅是恐惧还有待商榷，因为我认为这也是一种对匠心的承诺。（Lenny：是的，没错。）但我认为你说得很对。品牌就是你在受众心中建立的一种预期。

---

### [00:38:57] Lenny Rachitsky

**English:**
And to what you said, if you have a strong brand that people trust, everything gets easier. You pitch them a new product. Like if Stripes like, "Oh, we have a new billing service." "Oh. Oh, I bet it'll be awesome because it's Stripe." Or if OpenAI launches something. So it just makes life easier if your brand is strong, if there's trust.

**中文翻译:**
正如你所说，如果你有一个人们信任的强大品牌，一切都会变得更容易。你向他们推销新产品，比如 Stripe 说：“噢，我们有一个新的计费服务。” 用户会想：“噢，我敢打赌它一定很棒，因为它是 Stripe。” 或者 OpenAI 发布了什么东西。所以，如果你的品牌强大且有信任感，生活就会变得更轻松。

---

### [00:39:17] Krithika Shankarraman

**English:**
Yeah, and you got to take that responsibility seriously because even with something like Stripe, we know that people are going to come try out things that we put out the door. And so we wanted to make sure that that met up to people's expectations. And same thing with OpenAI. When we launched something, even though we were trying to be first to market and that velocity was so important for the company, oftentimes it also came with sometimes putting the brakes on to kind of understand, how can we improve the quality of the experience? How can we make sure that it is safe? So there were different criteria at the two companies, but a similar ethos overall for the brand experience that we wanted people to experience.

**中文翻译:**
是的，你必须认真对待这份责任。因为即使像 Stripe 这样，我们知道只要我们发布东西，人们就会来尝试。所以我们希望确保它符合人们的预期。OpenAI 也是一样。当我们发布产品时，尽管我们努力争取率先上市，速度对公司至关重要，但通常我们也需要适时踩刹车，去思考：我们如何提高体验质量？我们如何确保它是安全的？虽然两家公司的标准不同，但对于我们希望人们体验到的品牌精神，整体上是相似的。

---

### [00:39:55] Lenny Rachitsky

**English:**
Let's actually come back to OpenAI. How long were they around before you joined? It was like many, many years, right?

**中文翻译:**
让我们回到 OpenAI。在你加入之前，他们成立多久了？好像有很多年了吧？

---

### [00:40:01] Krithika Shankarraman

**English:**
Many, many years. So OpenAI had been around for almost a decade as primarily a research organization. They had launched ChatGPT about a year before I joined. And so that was the first foray into saying, "Hey, our work is not just announcing research breakthroughs, it is about putting products into the market."

**中文翻译:**
很多年了。OpenAI 作为一个主要的研究机构已经存在了将近十年。在我加入前大约一年，他们发布了 ChatGPT。那是他们第一次尝试表达：“嘿，我们的工作不仅仅是宣布研究突破，还要把产品推向市场。”

---

### [00:40:19] Lenny Rachitsky

**English:**
So there's a few questions I want to ask here. When is a time to bring in a Krithika? When is it like, "Okay, we need help here"? Or, "A bunch of smart people doing great work, people have the product, but I think we need a marketing person that knows what they're doing."

**中文翻译:**
所以我想问几个问题。什么时候该引入像你这样的人才？什么时候公司会觉得：“好吧，我们需要这方面的帮助”？或者是“一群聪明人在做伟大的工作，产品也有了，但我认为我们需要一个懂行的营销人员”。

---

### [00:40:33] Krithika Shankarraman

**English:**
I think the first criteria is having tremendous product market fit, which is really important because you're throwing fuel on the fire, and you might be throwing different types of fuel on your particular fire. So one pillar for marketing that you have to think about is product marketing. So, if you have a high velocity engineering organization and product organization that is putting out a lot of different features and your customers aren't able to keep track, maybe the engagement's not so high for some of the newer features versus some of the core features that you had in the past, a product marketer can really help bring a discipline of launch excellence and customer engagement, differentiation in the market. How are you positioning the product? The second pillar for me is demand generation. So if you have much more of a sales driven buyer journey in motion, how are you bringing the demand engines to bear so that your lead generation, your pipeline generation is staying really strong and solid? Or you might want to think about brand, right? You might want to think about community development as a big part of what you're doing as a company. So it really depends, but I think in all of these, you found a spark of product market fit before you're really going for it.

**中文翻译:**
我认为第一个标准是拥有极佳的产品与市场契合度（PMF），这非常重要，因为你是在火上浇油，而你可能需要为你的那把火投下不同类型的燃料。营销的一个支柱是**产品营销（Product Marketing）**。如果你有一个高速运转的工程和产品组织，不断推出许多不同的功能，而你的客户跟不上节奏，或者新功能的参与度不如核心功能高，那么产品营销人员可以帮助建立发布卓越性、客户参与度和市场差异化的准则。你如何定位产品？第二个支柱是**需求挖掘（Demand Generation）**。如果你有一个更多由销售驱动的买家旅程，你如何运用需求引擎来确保线索生成和管线生成保持强劲？或者你可能想考虑**品牌（Brand）**，或者将社区发展作为公司业务的重要组成部分。所以这取决于具体情况，但我认为在所有这些情况下，在你真正发力之前，你必须已经找到了产品与市场契合的火花。

---

### [00:41:43] Krithika Shankarraman

**English:**
The second for me is that you're distinguishing enough between capital and marketing and lowercase and marketing. And there's an important distinction I've learned over the years, which is capital and marketing, the marketing team, the marketing function at the company is responsible for those channels and artifacts and engines that are driving the funnel for the company, but they are not the end all be all of the discipline of marketing. And that's where the lowercase and marketing comes in, which is, what do you stand for as a company? What is the storyline that you're telling as a founder when you're talking to the press, to the larger business community? And then it really is a whole company motion where the product team is thinking about, "How are we going to market? What are we going to market with?" The sales team is figuring out, "What is the right ICP, the right customer profile that decision makers, that we need to be reaching?" And then it is this entire joining of the organizations to make that happen really effectively.

**中文翻译:**
对我来说，第二点是要区分“大写营销”（Marketing，指职能部门）和“小写营销”（marketing，指营销行为）。这些年来我学到了一个重要的区别：“大写营销”是指公司的营销团队和职能，负责驱动漏斗的渠道、素材和引擎，但它们并不是营销学科的全部。这就是“小写营销”发挥作用的地方：作为一家公司，你代表什么？作为创始人，当你面对媒体和更广泛的商业社区时，你在讲述什么样的故事？这实际上是一个全公司的行动，产品团队在思考：“我们如何走向市场？我们带着什么走向市场？”销售团队在弄清楚：“谁是正确的理想客户画像（ICP）？我们需要触达哪些决策者？”然后是整个组织的联合，才能真正有效地实现目标。

---

### [00:42:47] Lenny Rachitsky

**English:**
Yeah. I think along these lines, there's a reason Brian at Airbnb merged marketing, or product marketing and product management. However much of that actually happened or not, but the intention-

**中文翻译:**
是的。我想顺着这个思路，Airbnb 的 Brian 将营销（或者说产品营销）与产品管理合并是有原因的。无论这在多大程度上真正实现了，但其意图是——

---

### [00:42:58] Krithika Shankarraman

**English:**
I would be so curious to see a follow-up a few years on on how that's been going.

**中文翻译:**
我非常好奇几年后的后续情况，看看进展如何。

---

### [00:43:01] Lenny Rachitsky

**English:**
Yeah. Okay, let's have Brian back to talk about that. That'd be really interesting. I wanted to actually ask, an interesting thing is happening with ChatGPT versus Claude, and it's so interesting. Claude is arguably better at many things at code, at least at this point. Things are always changing. It seems to be a better writer in a lot of ways. People prefer it for writing, but it's just like ChatGPT is just dominating. It's like, that's what people associate with AI now is just ChatGPT. It's just caught mindshare globally. What is it, do you think, that allowed ChatGPT just to be that? Is it just first mover advantage? Is it some kind of other element? Has it been better longer? Something really interesting is going on there.

**中文翻译:**
是的。好，下次请 Brian 回来聊聊这个。那会很有趣。我其实想问，ChatGPT 和 Claude 之间正在发生一件很有趣的事情。Claude 在很多方面（至少目前在代码方面）可以说更好。情况总是在变化。它在很多方面似乎是一个更好的写作者，人们更喜欢用它写作，但 ChatGPT 却占据了统治地位。现在人们一提到 AI 就会想到 ChatGPT。它在全球范围内占据了心智份额（mindshare）。你认为是什么让 ChatGPT 达到了这种地位？仅仅是先发优势吗？还是其他因素？是因为它好用的时间更长吗？那里确实发生了一些很有趣的事情。

---

### [00:43:46] Krithika Shankarraman

**English:**
One of the things that comes to mind is the orientation when it comes to large language models, and AI in general, is that we're just at the very beginning innings of this whole paradigm shift. And so every single week there is a new breakthrough in AI that comes out from some lab or the other. There's this one-upmanship on point changes and eval numbers and so on and so forth. But I think to customers, the users of the product, the things that make it delightful are the same things that make any product delightful. And there's a sense of loyalty that builds up over time when there is a shorter and smaller delta between your expectations and your reality. And where those expectations are exceeded, it is accretive to the brand and your loyalty to the product. And where there is a negative delta, that tends to be something that it really detracts. I guess, long story short, what I'm trying to say is that all of these companies have to think in a much more long-term oriented fashion because it's not about a race of the best chatbot and the best outputs. It's about, how does AI become a positive force for humanity? And so that's going to take a lot of change management and a lot of collaboration between a variety of different organizations rather than just the companies themselves and the product experience itself, because it's going to permeate every aspect of our lives. Our personal lives, our academic lives, our work lives. And so to make that transformation happen, my hope is these companies are not super focused on just their competition and one-upmanship, but rather thinking about the paradigm changes that need to happen for our society at large.

**中文翻译:**
我想到的一点是，对于大语言模型和整个 AI 领域来说，我们正处于整个范式转移的最初阶段。每周都有某个实验室发布新的 AI 突破。在评分变化和评估数据上存在着这种“互相比拼”。但对于客户和产品用户来说，让产品令人愉悦的因素与让任何产品令人愉悦的因素是一样的。当你的预期与现实之间的差距（delta）越来越小时，忠诚度就会随之建立。当预期被超越时，它会增加品牌价值和对产品的忠诚度；而当出现负差距时，则会损害品牌。长话短说，我想说的是，所有这些公司都必须以更长远的眼光来思考，因为这不仅仅是关于谁有最好的聊天机器人和最好的输出。而是关于 AI 如何成为人类的积极力量。这需要大量的变革管理以及各种不同组织之间的协作，而不仅仅是公司本身和产品体验，因为它将渗透到我们生活的方方面面：个人生活、学术生活、工作生活。为了实现这种转型，我希望这些公司不要过度关注竞争和比拼，而是思考整个社会需要发生的范式变革。

---

### [00:45:31] Lenny Rachitsky

**English:**
It does feel like they are taking that responsibility really seriously, but it is a massive responsibility. Before we leave OpenAI, it feels like it may be the most impactful, important company in the world right now just because they seem to be at the furthest edge of where AI is going. And so it's just such an interesting place to study. So let me ask you this. Just as a person working there, what's something people may not know that's a wonderful, positive element of how open AI works that's just like, "Oh, that's super interesting"? And then, what was maybe a challenge of working at OpenAI?

**中文翻译:**
确实感觉他们非常认真地对待这份责任，但这确实是一份巨大的责任。在结束 OpenAI 的话题前，感觉它可能是目前世界上最具影响力、最重要的公司，因为他们似乎处于 AI 发展的最前沿。所以这是一个非常有趣的研究对象。我想问你：作为一个在那里工作过的人，有什么是人们可能不知道的、关于 OpenAI 运作方式的积极且美好的元素，让人觉得“噢，那太有趣了”？另外，在 OpenAI 工作可能面临的挑战是什么？

---

### [00:46:08] Krithika Shankarraman

**English:**
A surprising thing that surprised me at the company was just the warmth and intellectual curiosity of my peers and leaders at the company. And truly, the sort of commitment to the mission of making artificial intelligence that benefits all of humanity was not just lip service. It was something that was embodied day to day. The sort of questioning that happened, the sort of pressure testing that happened, the rigor with which products were developed, go-to market strategies were developed, was bar none. And so that's something that I really admired, and it was a privilege to be a part of that organization. I think challenging, of course, is just being at the eye of the storm, right? The eye of the hurricane. So, all eyes are on OpenAI at all times, and I think that is a good thing because of the ramifications of the product. But it also really raised the stakes in terms of how we operated and with what scrutiny, everything that we did was looked at with.

**中文翻译:**
在公司里令我惊讶的一件事是同事和领导们的温暖和求知欲。真的，那种“让人工智能造福全人类”的使命感绝非口头禅，而是体现在日常工作中。那种质疑精神、压力测试，以及开发产品和制定进入市场策略时的严谨程度，都是无与伦比的。这是我非常钦佩的地方，能成为那个组织的一员是我的荣幸。至于挑战，当然就是处于“风暴眼”中心。全世界的目光时刻都盯着 OpenAI，考虑到产品的影响力，我认为这是件好事。但这也确实提高了我们运营的门槛，我们所做的每一件事都会受到极其严苛的审视。

---

### [00:47:09] Lenny Rachitsky

**English:**
Do you recommend that sort of experience for people? Because I imagine work-life balance wasn't great. I imagine there was a lot of stress and worry constantly. Who's the right... When in your career is this a sort of gig to take on versus not?

**中文翻译:**
你会向别人推荐这种经历吗？因为我想象工作与生活的平衡肯定不太好。我猜那里一直有很多压力和担忧。什么样的人适合……或者在职业生涯的什么阶段适合接下这样一份工作？

---

### [00:47:25] Krithika Shankarraman

**English:**
I'm a big believer of what Claire Hughes Johnson, who was COO at Stripe, used to share with us, which is there is a concept of a work-life blend and sort of making sure that you're working at a company that has three components. I think first and foremost is always people. So, are the people that you're surrounding yourself with ones that push your thinking, who are kind, who are genuinely interesting people to spend your hours with? Because you're spending a vast majority of your time with them. The second to me is product, right? Do you go to sleep thinking about the product, waking up, wanting to put it into the hands of more people because you know it is going to be good for them or useful to them? I'm not one of those marketers who can pick up any product and market it. I have to have that conviction behind the product itself. And then third is sort of potential, right? Not just potential for the company to do well, but potential for your discipline to have an impact on the trajectory of the company. And so when you have that kind of potent combination, it can really change your perspective on what's draining, what's energizing. But being very self-aware of what gives you energy is also very helpful to align with the needs of the company, also.

**中文翻译:**
我非常认同 Stripe 前 COO Claire Hughes Johnson 曾与我们分享的观点，即“工作与生活融合”（work-life blend）的概念，并确保你在一家具备三个要素的公司工作。我认为首要的永远是**人（People）**。你周围的人是否能推动你的思考？他们是否善良？是否是真正有趣、值得共度时光的人？因为你绝大部分时间都和他们在一起。第二是**产品（Product）**。你是否在睡觉前想着产品，醒来后想把它交到更多人手中，因为你知道它对他们有好处或有用？我不是那种随便拿个产品就能营销的人，我必须对产品本身有信念。第三是**潜力（Potential）**。不仅是公司成功的潜力，还有你的专业领域对公司发展轨迹产生影响的潜力。当你拥有这种强有力的组合时，它真的会改变你对“什么是消耗、什么是赋能”的看法。非常清楚什么能给你带来能量，对于对齐公司需求也非常有帮助。

---

### [00:48:41] Lenny Rachitsky

**English:**
Let's shift to talking about Thrive, which is where you work now, and talk about what your role is. And what's interesting, I think, about this role is you get to work now with a bunch of different startups instead of go really deep with one. So share what you do there. And then, what are some things you've learned there so far from a perspective for marketing?

**中文翻译:**
让我们转而谈谈 Thrive，也就是你现在工作的地方，聊聊你的角色。我认为这个角色有趣的地方在于，你现在是与一群不同的初创公司合作，而不是深入一家公司。分享一下你在那里做些什么，以及到目前为止你从营销的角度学到了什么？

---

### [00:48:59] Krithika Shankarraman

**English:**
Yeah, surprisingly, more people know about Thrive these days than used to even just a few years ago. Thrive's a very unique type of investment company. And sometimes, when I made the leap, people used to ask me, "Oh, was this always in your ambition to make the leap into the investment side of the house?" And I can honestly say it wasn't. But I think being at a firm like Thrive really gives you a very different perspective and it strengthens your ability to be a stronger operator, whether that's in marketing or go-to market or strategic finance, or whatever other pillar within the company there is. Yeah, Thrive's mission is to be the most meaningful partner to founders. And so there's a lot of high-concentration, high-conviction investments each year. And Thrive is also unique in that it's a network of builders, and so they are really pulling their investment strategies from having been founders themselves. So my role at the company is to help our entire portfolio with all of their marketing needs, so sometimes it means being interim CMO for some portion of time until they find a great leader to fill that seat. Sometimes it means pressure testing their strategy and making sure that their growth targets are ambitious enough. Sometimes it means looking at a Figma file for a landing page that's going out the next day and making sure the words are as good as they can be. And that variety across a bunch of industries, a bunch of stages of companies, everything from a company that hasn't even been incorporated yet, all the way to Databricks and Stripe and OpenAI when it comes to the types of organizations that we work with. And in the end, the variety of domains can range from consumer to healthcare, to defense, to B2B SaaS, to AI. So it is a variety pack in the best way possible.

**中文翻译:**
是的，令人惊讶的是，现在知道 Thrive 的人比几年前多得多。Thrive 是一家非常独特的投资公司。当我转型时，人们常问我：“噢，进入投资领域一直是你抱负的一部分吗？”我可以诚实地说，并不是。但我认为在 Thrive 这样的公司工作确实能给你一个非常不同的视角，它能增强你作为一个更强大运营者的能力，无论是在营销、进入市场（GTM）、战略财务还是公司的其他支柱领域。Thrive 的使命是成为创始人最有意义的合作伙伴。因此，每年都会有很多高度集中、高信念的投资。Thrive 的独特之处还在于它是一个建设者（builders）网络，他们的投资策略源于他们自己曾是创始人的经历。我在公司的角色是帮助我们所有的投资组合公司处理他们的营销需求。有时这意味着在他们找到合适的领导者之前担任一段时间的临时 CMO；有时意味着对他们的策略进行压力测试，确保他们的增长目标足够宏大；有时意味着查看第二天就要发布的落地页 Figma 文件，确保文案尽可能完美。这种跨行业、跨阶段的多样性非常迷人，从尚未注册的公司到 Databricks、Stripe 和 OpenAI。涉及的领域从消费级到医疗保健、国防、B2B SaaS 再到 AI。这简直是一个最棒的“大礼包”。

---

### [00:50:43] Lenny Rachitsky

**English:**
And so what are some things you've learned so far? Because I imagine this is a very different experience. I don't know, especially things that you've changed your mind on even, working with a bunch of companies, early stage versus, what can I say?

**中文翻译:**
那么到目前为止你学到了什么？因为我想象这是一种非常不同的体验。有没有什么事情是你甚至改变了看法的，在与这么多不同阶段（早期 vs 后期）的公司合作后？

---

### [00:50:57] Krithika Shankarraman

**English:**
It's a really different method of operating. And so when you're in the leadership role for marketing within a single organization, you have at least a medium term north star in terms of what your teams are trying to drive for the company. And as much context switching as there might be, there is still one company, ideally one product, one buyer journey. That hasn't always been the case, especially with OpenAI and Stripe, but it can span B2C, B2B, B2D. Thrive is very different in that if you want to be a meaningful partner to the founders, you cannot just jump from 30-minute call to 30-minute call to 30-minute call. You have to go deep to understand the context. And if anything, it's really underscored my ethos that you as a marketer, the best thing that you can bring to the table is your adaptability and flexibility. So, to really diagnose and not just try to spot patterns and themes and playbooks for these companies, but rather be very deep in the trenches with them to understand their unique context, their unique concerns, their unique characteristics, and their values and what they want to bring into the world. The reason that they want to work with Thrive is not because we are bringing our past experiences to the table, but rather because they're trying to do something new that has never been done in the world. And so those are engagements that are the most exciting is that you are building and going into uncharted territory alongside these founders.

**中文翻译:**
这确实是一种完全不同的运营方式。当你在单一组织中担任营销领导角色时，你至少有一个中期的北极星指标，指引团队为公司努力。尽管会有很多上下文切换，但仍然是一家公司、理想情况下一个产品、一个买家旅程。虽然在 OpenAI 和 Stripe 并不总是这样，但它可能跨越 B2C、B2B、B2D。Thrive 非常不同，如果你想成为创始人有意义的合作伙伴，你不能只是从一个 30 分钟的电话跳到另一个 30 分钟的电话。你必须深入了解背景。如果说有什么收获的话，那就是它真正强调了我的理念：作为一名营销人员，你能带来的最好东西就是你的适应性和灵活性。去真正地诊断，而不仅仅是试图为这些公司寻找模式、主题和策略手册，而是与他们一起深入战壕，了解他们独特的背景、独特的担忧、独特的特征、价值观以及他们想带给世界的东西。他们想与 Thrive 合作，不是因为我们带来了过去的经验，而是因为他们正试图做一些世界上从未做过的新事情。这些合作是最令人兴奋的，因为你正与这些创始人一起进入未知的领域。

---

### [00:52:26] Lenny Rachitsky

**English:**
I bet they're all like, "Krithika, what is the playbook for growing this B2B SaaS company?" And you're like, "Nope."

**中文翻译:**
我敢打赌他们都会问：“Krithika，增长这家 B2B SaaS 公司的策略手册是什么？”而你会说：“没有。”

---

### [00:52:30] Krithika Shankarraman

**English:**
And I say, "There is none."

**中文翻译:**
我会说：“根本没有这种东西。”

---

### [00:52:31] Lenny Rachitsky

**English:**
Damn. But we got the framework that we talked about. Okay, I want to zoom out a little bit and talk about just career advice for marketing people, whether it's early stage or later stage. You have this concept, the chameleon CMO. Talk about that and why that's important for marketing folks to think about.

**中文翻译:**
好吧。但我们有刚才讨论过的框架。好，我想放大一点视角，谈谈给营销人员的职业建议，无论是早期阶段还是后期阶段。你有一个“变色龙 CMO”（chameleon CMO）的概念。谈谈这个，以及为什么营销人员思考这个问题很重要。

---

### [00:52:48] Krithika Shankarraman

**English:**
Yeah. The conventional wisdom for many CMOs is to be like a T-shaped marketer. And what that means is go deep in one of these pillars that we talked about, product marketing, demand marketing, brand marketing, and that kind of becomes your calling card in the world. If a company needs brand expertise, they go for this kind of flavor of CMO. Or if a company needs to really grow their pipeline or their demand gen or their consumer growth, they go for more of a demand and growth-oriented CMO. And I think this chameleon CMO concept is a bit of a novel one in that, again, I think modern marketing leaders have to be really good at a bunch of different things. They have to be very analytical. They have to be best friends with the data science pod because they need to understand the impact of their marketing. They, of course, have to bring creativity, but it is in service to the buyer journey. It is in service to revenue goals and goals that they share with the sales team or the product team and so on, so marketing operating in a silo is no longer a real possibility. So the ability to diversify your interest, maybe going from T-shaped to comb-shaped is probably the right approach here so that you can go deeper in different domains when it is useful for the company through the diagnostic that you do.

**中文翻译:**
是的。许多 CMO 的传统观念是成为一名“T型”营销人。这意味着在你提到的支柱（产品营销、需求营销、品牌营销）之一中深耕，这成了你在世界上的名片。如果一家公司需要品牌专业知识，他们会找这种风格的 CMO；如果需要增长管线或消费者增长，他们会找更偏向需求和增长的 CMO。我认为“变色龙 CMO”是一个比较新颖的概念，因为现代营销领导者必须擅长很多不同的事情。他们必须非常有分析能力，必须与数据科学小组成为最好的朋友，因为他们需要了解营销的影响。当然，他们必须带来创意，但创意是为买家旅程服务的，是为收入目标以及与销售或产品团队共享的目标服务的。因此，营销在孤岛中运作已不再可能。所以，多样化你的兴趣，也许从“T型”转变为“梳型”（comb-shaped，指在多个领域都有深度）是更正确的方法，这样你就可以根据诊断结果，在对公司有用的不同领域进行深钻。

---

### [00:54:08] Lenny Rachitsky

**English:**
That sounds very hard. I love this beneficial of the comb shape. It sounds like I have so much to learn, so many little skills to build.

**中文翻译:**
这听起来很难。我喜欢“梳型”这个比喻。听起来我有太多的东西要学，有太多的技能要建立。

---

### [00:54:16] Krithika Shankarraman

**English:**
Before AI can come in handy. Some of the most brand marketers can become very analytical with the support of a tool like ChatGPT. If your eyes glaze over when you look at giant dumps of CSVs, it's nice to have a partner that is nonjudgmental to kind of push your thinking and to help you understand the details of the data behind the brand work that you might be doing, or vice versa. If you're a very creative product marketer, a very analytical growth marketer, you can work with ChatGPT to be more of a brainstorm partner and really push your thinking on the creative side. So I think becoming a non T-shaped marketer is getting a little bit easier.

**中文翻译:**
这就是 AI 可以派上用场的地方。在 ChatGPT 这种工具的帮助下，一些最感性的品牌营销人员也可以变得非常有分析能力。如果你看到大堆的 CSV 文件就眼花缭乱，那么有一个不会评判你的伙伴来推动你的思考，并帮助你理解品牌工作背后的数据细节，那是很棒的。反之亦然，如果你是一个非常有分析能力的增长营销人员，你可以把 ChatGPT 当作头脑风暴伙伴，在创意方面推动你的思考。所以我认为，成为一名非单一 T 型的营销人员正变得容易一些。

---

### [00:55:00] Lenny Rachitsky

**English:**
That's such a good point. A good segue to an AI question. Hey, we got to talk about AI. One of your former colleagues, Kevin Garcia, wanted me to ask you something. He suggested I ask you about taste and creativity in AI. So he said that you're one of the best writers that he's ever worked with. You combine technical backgrounds with creative taste. You do pottery, you should. And you're a voracious reader. And he wanted just to poke at what you think about just how taste and creativity and writing change in the era of AI.

**中文翻译:**
说得太好了。这正好过渡到 AI 的问题。嘿，我们得聊聊 AI。你以前的一位同事 Kevin Garcia 想让我问你一件事。他建议我问问你关于 AI 中的“品味”和“创意”。他说你他是合作过的最好的写作者之一。你将技术背景与审美趣味结合在一起。你还做陶艺，而且是个酷爱阅读的人。他想探究一下你对“在 AI 时代，品味、创意和写作如何变化”的看法。

---

### [00:55:31] Krithika Shankarraman

**English:**
I think it's going to become so much more important. First of all, I will say I am not a ChatGPT hyphen person. I was an em dasher well before it became a ChatGPT thing. (Lenny: Me too. Me too. I hate that. But just for people don't know, people are filtering out em dashes, right? Because they think ChatGPT is the only thing using em dashes?) Yeah, and I don't know what to do about it because this is such a core part of my identity, but- To take a step back though, I think if anything, taste is going to become a distinguishing factor in the age of AI because there's going to be so much drivel that is generated by AI, can be generated by AI, that power is at anyone's fingertips. But truly, the companies that are going to distinguish themselves are the ones that show their craft. That they show their true understanding of the product, the true understanding of their customer, and connect the two in meaningful ways. If they can use AI to augment their efforts to make that happen, that's better than them subsuming their efforts. So to build taste, there's plenty of past episodes that you yourself have recorded that get into building that work. But to me, that is going to be a real differentiator for not only great marketers but great companies to stand out in the field.

**中文翻译:**
我认为它会变得更加重要。首先，我要声明我不是那种“ChatGPT 式连字符”的人。在破折号（em dash）变成 ChatGPT 的标志之前，我就是它的忠实用户了。（Lenny：我也是，我也是。我讨厌那样。但为了让大家明白，现在人们甚至在过滤破折号，对吧？因为他们觉得只有 ChatGPT 才用破折号。）是的，我不知道该怎么办，因为这是我身份的核心部分，但是——退一步说，我认为在 AI 时代，品味将成为一个区分因素。因为 AI 会生成海量的废话，任何人都能轻易做到。但真正能脱颖而出的公司，是那些展现出匠心的公司。他们展示了对产品的真正理解，对客户的真正理解，并以有意义的方式将两者联系起来。如果他们能利用 AI 来增强这些努力，而不是让 AI 取代这些努力，那就更好了。至于如何培养品味，你自己录制过很多关于这方面的节目。但对我来说，这将是伟大的营销人员乃至伟大的公司在领域中脱颖而出的真正差异化因素。

---

### [00:56:50] Lenny Rachitsky

**English:**
There's a concept that I love that recently I learned from Guillermo at Vercel. He calls it exposure hours. That's when I asked him how to build taste, and that's kind of a value they have at their company is just increase your exposure hours to great stuff, because that is how you build taste. I love that. It's such a simple actionable thing you can do.

**中文翻译:**
我最近从 Vercel 的 Guillermo 那里学到了一个我很喜欢的概念。他称之为“接触时长”（exposure hours）。当我问他如何培养品味时，他说这是他们公司的一种价值观：增加你接触优秀事物的时长，因为这就是你建立品味的方式。我喜欢这个，这是一个非常简单且可操作的方法。

---

### [00:57:09] Krithika Shankarraman

**English:**
Yeah. (Lenny: Yeah.) And at Thrive, we have this share channel, which is just sharing things that we're seeing out into the world. It's not particularly deal flow news or competitive news or anything like that, but it is things that we have seen that resonated with us for whatever reason.

**中文翻译:**
是的。在 Thrive，我们有一个分享频道，专门分享我们在世界上看到的东西。它不一定是关于交易流或竞争对手的新闻，而是那些因为某种原因引起我们共鸣的东西。

---

### [00:57:24] Lenny Rachitsky

**English:**
Along these lines of not over-relying on ChatGPT, AI tools for writing and creativity, it feels like there's going to be a big issue with people just starting early in their career where they just never learn how to do the thing, and they just rely really heavily on ChatGPT and tools like that to write, to email, to communicate well. I guess, do you have any advice for folks that are early career, just how to find that balance of not over-relying but still leveraging these tools?

**中文翻译:**
顺着“不要过度依赖 ChatGPT 等 AI 工具进行写作和创意”的思路，感觉对于刚开始职业生涯的人来说，会有一个大问题：他们可能永远学不会如何亲自动手，而是过度依赖 ChatGPT 这种工具去写作、发邮件和沟通。对于职业生涯早期的人，你有什么建议吗？如何找到“不过度依赖但仍能利用这些工具”的平衡点？

---

### [00:57:53] Krithika Shankarraman

**English:**
I think there's two schools of thought here. One is that sort of the domain, the discipline itself stays static and the way that you approach it changes over time, whether you're going at it in a manual way or an automated way or an AI augmented way. But I think the other school of thought, which I more believe in, is that the discipline itself is changing. And so what it means to market a product, what it means to show up as a fantastic operator is in and itself changing. So if you're not leveraging some of these tools, you will be putting yourself at a disadvantage. But understanding the underlying mechanics, this is why I would still be a very firm believer in STEM education, is that you understand the fundamental concepts. And then you can have a choice and optionality in how you decide to apply those concepts, but the concepts themselves have to be there in the foundations.

**中文翻译:**
我认为这里有两种流派。一种认为领域或学科本身是静态的，只是你处理它的方式随着时间而改变，无论是手动、自动化还是 AI 增强。但我更倾向于另一种观点：学科本身正在发生变化。因此，“营销产品”的含义、“成为一名优秀的运营者”的含义本身就在改变。所以如果你不利用这些工具，你就会处于劣势。但理解底层机制——这也是为什么我仍然坚定相信 STEM 教育的原因——是为了让你理解基本概念。然后，你可以选择如何应用这些概念，但概念本身必须作为基础存在。

---

### [00:58:46] Lenny Rachitsky

**English:**
Yeah. Easier said than done because there's all these tools now and you're just like, "Hey, I need to write a report for school. I guess I could just, maybe this time I'll just ask ChatGPT to help me with this one."

**中文翻译:**
是的。说起来容易做起来难，因为现在有这么多工具，你会想：“嘿，我需要写个学校报告。我想，也许这次我就让 ChatGPT 帮我一下吧。”

---

### [00:58:56] Krithika Shankarraman

**English:**
Yeah, the mindset of learning has to be maybe the one that we have to really imbue as a value. Because being of that growth mindset, if you go to school just to earn the grades or to finish the coursework, it's a very different mindset than if you go to school to learn those concepts and to understand how to apply them.

**中文翻译:**
是的，学习的心态也许是我们必须真正灌输的一种价值观。如果你带着成长型思维，去学校不仅仅是为了拿高分或完成作业，这与去学校学习概念并理解如何应用它们是完全不同的心态。

---

### [00:59:20] Lenny Rachitsky

**English:**
That's something that stuck with me from my chat with Toby Lutke from Shopify. We were chatting about just what is the most important things to incubate in your child? And his answer I loved, which is just, "Curiosity."

**中文翻译:**
这让我想起了我与 Shopify 的 Tobi Lütke 的聊天。我们当时在聊“在孩子身上培养的最重要的东西是什么？”我非常喜欢他的回答，只有两个字：“好奇心”。

---

### [00:59:32] Krithika Shankarraman

**English:**
I love that.

**中文翻译:**
我喜欢这个回答。

---

### [00:59:33] Lenny Rachitsky

**English:**
Yeah, and that's what you're kind of speaking to is just if you're curious about learning, you'll almost avoid some of these things or you'll use these tools in a really interesting way just to learn things more deeply.

**中文翻译:**
是的，这正是你所说的。如果你对学习充满好奇，你几乎会避免盲目依赖，或者你会以一种非常有趣的方式使用这些工具，从而更深入地学习。

---

### [01:00:04] Lenny Rachitsky

**English:**
That reminds me. To sort of close out our conversation, I wanted to come back to pricing strategy. I have that in my notes here and I haven't gone back to it. So let's focus on the AI and pricing strategy. Just say someone is trying to figure out pricing for their product and they have some kind of AI product. What are some tips, some piece of advice to think this through? Any general frameworks you use?

**中文翻译:**
这让我想起来了。在结束我们的对话之前，我想回到定价策略。我的笔记里有这一项，但我还没聊到。让我们关注一下 AI 和定价策略。假设有人正在为他们的 AI 产品制定定价，你有什么建议或思考方式吗？有什么通用的框架吗？

---

### [01:00:25] Krithika Shankarraman

**English:**
Again, there's no playbook. I feel like it's such a non-answer, but I think the real answer is experimentation. And we found this firsthand multiple times at Stripe, but also at Retool. I think there was a very visceral example where we decided to bring our free product into the hands of more users and sort of what was available in the free plan. And then there was another one that we tested out as a pricing function where we decided to do something quite controversial, which is to take the thing that our sales team was gated on, a self-hosted version of Retool, and made that available self-serve to anybody who wanted it. They didn't have to talk to a salesperson. And that kind of blew up the funnel, right? Because the amount of pipeline that the sales team saw had diminished considerably, but it also helped them focus up market, on higher ACV deals. And so that trade-off is really hard to make, so the only way we could do it was through experimentation and piloting to build conviction. So I would say AI is no different in that you kind of have to test the market to see what works. Is it a seed-based model? Is that where people are deriving value? Or is the way that they speak about the value of the product something quite different? Is it hours saved? Is it the amount of things that they could do now that they couldn't do before? And so there might be a metric there to go off of, and I don't think anyone solved it, especially with agents coming into play. How you pay for AI workers is going to be very different. What is that unit of completion for things like code generators? It's going to be a Wild, Wild West before we come up with something that is as internalized now as seed-based pricing or usage-based pricing.

**中文翻译:**
再次强调，没有现成的策略手册。我觉得这听起来像没回答一样，但真正的答案是**实验**。我们在 Stripe 和 Retool 都多次亲身体会到了这一点。Retool 有一个非常深刻的例子：我们决定让更多用户使用我们的免费产品，并调整了免费计划的内容。另一个定价实验则相当有争议：我们将销售团队原本把持的“私有化部署版”（self-hosted）Retool 开放给任何人自服务使用，不需要联系销售。这几乎“炸掉”了漏斗，销售团队看到的管线量大幅减少，但也帮助他们专注于高端市场和更高年度合同价值（ACV）的交易。这种权衡很难做，所以我们唯一的办法就是通过实验和试点来建立信心。所以我认为 AI 也不例外，你必须测试市场看看什么有效。是按席位收费吗？那是人们获得价值的地方吗？还是他们谈论产品价值的方式完全不同？是节省的小时数吗？是他们现在能做而以前做不到的事情的数量吗？可能会有一个指标可以参考，但我认为目前还没有人真正解决这个问题，尤其是随着 AI Agent（智能体）的出现。你如何为 AI 员工付费将非常不同。对于代码生成器之类的东西，完成的单位是什么？在出现像现在的按席位定价或按量计费那样深入人心的模式之前，这会是一片“大西部荒野”。

---

### [01:02:10] Lenny Rachitsky

**English:**
Wild indeed. I want to actually follow this insight you had around Retool. That's really interesting. Yeah, so you opened up self-hosted Retool. What was the insight there, because this might be useful to people, that convinced you to play with that? Seems like a big deal change to how you price and do trials.

**中文翻译:**
确实很荒野。我想追问一下你关于 Retool 的见解。这很有趣。你们开放了私有化部署版 Retool，当时的洞察是什么？因为这对其他人可能有用。是什么说服你们去尝试这个的？这看起来是对定价和试用方式的重大改变。

---

### [01:02:30] Krithika Shankarraman

**English:**
There were two guiding principles here. One is, do people actually want to talk to sales before they get a self-hosted thing? It's sort of like the SSO attacks, right? Is that really the thing that you want to gate your value on? So, that was one. And so we saw a lot of demand from smaller customers that still wanted self-hosted for a variety of reasons, because they worked in regulated industries or they worked with very private data and PII. And so it wasn't just something that was, "Hey, if you have 10,000 employees at your company and you're an enterprise, you want self-hosted." It was that for a variety of different reasons, regardless of your company size, you might want self-hosted. So that insight kind of led us to say, "Hey, where is the delineation here? Because the sales team should be talking to larger customers, landing larger deals." And so to align those two was one of the driving principles.

**中文翻译:**
这里有两个指导原则。第一，人们在获得私有化部署版本之前，真的想和销售谈谈吗？这有点像“SSO 税”（SSO attacks），你真的想把价值卡在这些地方吗？这是其一。第二，我们看到很多小客户出于各种原因仍然想要私有化部署，因为他们在受监管的行业工作，或者处理非常私密的数据和个人身份信息（PII）。所以这不仅仅是“嘿，如果你公司有 1 万名员工，你是大企业，你就想要私有化部署”。而是无论公司规模大小，出于各种原因，你都可能需要它。这个洞察让我们思考：“界限在哪里？因为销售团队应该去谈大客户、签大单。” 将这两者对齐是驱动原则之一。

---

### [01:03:19] Lenny Rachitsky (AI Corner)

**English:**
Awesome. Okay. Two final questions before we get to our very exciting lighting around. I'm going to take you to a couple of recurring segments on this podcast. The first is AI Corner. And with AI Corner, what I try to get to is some way that you have figured out to use an AI tool in your work to do better work or do faster work, to be more efficient. Is there something there that you could share? And if not, that's also totally cool.

**中文翻译:**
太棒了。在进入激动人心的闪电轮之前，还有最后两个问题。我会带你进入本播客的几个固定环节。第一个是“AI 角落”。在 AI 角落，我试图挖掘你在工作中如何使用 AI 工具来做得更好、更快或更高效。有什么可以分享的吗？如果没有也没关系。

---

### [01:03:46] Krithika Shankarraman

**English:**
Ooh, it is hard to pick because there's not many things I don't use AI for these days, and oftentimes it's a catalyst and an accelerant to the work that I'm already doing. But I think I can actually unlock my ability to talk to dozens of companies across the Thrive portfolio in any given week, and the ability to get deep on their context, their environment, their competitive landscape. We can do that because of the tools and the products that Thrive has invested in from an engineering perspective. So we have internal tools that are driven with AI that give us a lot of insights and access to expertise for these companies so we can show up as more meaningful partners in a day-to-day basis. So I think the ability to mix AI tooling then accelerates work that you're already doing, and then AI-based tools that unlock superpowers that wouldn't otherwise be available to you unless you're going deep into Google Groups archives or talking to people across the organization to pull out things that are inside of their brain. That kind of institutional knowledge being made more accessible by AI is actually more powerful sometimes than the tools themselves. And in fact, even at OpenAI, it's one of the things that we advised most enterprises to invest in first is their own operational efficiency rather than just the AI magic dust they could sprinkle on top of their product experience for their customers.

**中文翻译:**
噢，很难选，因为现在几乎没有我不使用 AI 的事情，它通常是我工作的催化剂和加速器。但我认为，我之所以能在任何一周内与 Thrive 投资组合中的几十家公司交谈，并深入了解他们的背景、环境和竞争格局，是因为 Thrive 从工程角度投资的工具和产品。我们有 AI 驱动的内部工具，能为我们提供关于这些公司的洞察和专业知识，使我们每天都能成为更有意义的合作伙伴。所以，混合使用 AI 工具可以加速你正在做的工作，而基于 AI 的工具则能解锁你原本无法获得的神力——除非你深入挖掘 Google Groups 的存档，或者与组织各处的人交谈以挖掘他们大脑里的东西。这种通过 AI 变得更易获取的“组织知识”（institutional knowledge），有时比工具本身更强大。事实上，即使在 OpenAI，我们也建议大多数企业首先投资于他们自己的运营效率，而不是仅仅在给客户的产品体验上撒一点“AI 魔法粉”。

---

### [01:05:15] Lenny Rachitsky (Fail Corner)

**English:**
Awesome. Okay. Final segment of the podcast we call Fail Corner. And the idea here is we have all these amazing guests, all these super successful people on the podcast, all these stories of epic wins and nothing but success. And I think in reality, that's not the case. And it's important for people to hear that things aren't always up and to the right and always win, win, win. Is there a story from your career you can share where things didn't work out and what you learned from that experience?

**中文翻译:**
太棒了。播客的最后一个环节叫“失败角落”。这个环节的初衷是，我们请来了这么多优秀的嘉宾，这么多超级成功的人，听到了这么多史诗般的胜利。但现实并非总是如此。让人们听到事情并不总是蒸蒸日上、赢赢赢是很重要的。在你的职业生涯中，有没有什么失败的故事可以分享，以及你从中学到了什么？

---

### [01:05:44] Krithika Shankarraman

**English:**
And again, this question's hard because there's so many things to choose from as potential examples here. And you're absolutely right, Lenny, in that most careers are not the sort of linear journeys that are reflected on somebody's LinkedIn profile. No, I'll talk about a fantastic success, which is called Stripe Relay, which you probably... Oh, I'm just kidding because nobody remembers it. It was ahead of its market. We launched it back in 2014. It was supposed to be the platform with which e-commerce companies would tap into social commerce. The buy buttons if you remember that. And it launched to a lot of fanfare, but then eventually failed. It didn't produce the sort of revenue or the numbers that we had expected. And the understanding here was that as much as one side of the marketplace, or you might have some conviction that you need to put something into the market for a particular moment in time, the timing of the market really matters. And the timing of multiple parties coming together to make a platform work really matters. And so the learning here was we hadn't gone deep enough into the market dynamics. We hadn't done enough user research. Did people really want this? And if they did, what were their alternatives? What was the stacks that they were operating in? And would they adopt a net new tool versus one that integrated into existing systems directly like their e-commerce inventory management systems and so on? And so for that reason, I think, again, it was ahead of its market and ahead of its time, but a clear flop regardless of the effort that we put into that launch.

**中文翻译:**
同样，这个问题很难，因为有太多例子可以选了。你说得对，Lenny，大多数职业生涯并不像 LinkedIn 个人资料上显示的那样是线性上升的。不，我要说一个“伟大的成功”，叫 Stripe Relay，你可能……噢，我开玩笑的，因为没人记得它。它领先于市场。我们在 2014 年发布了它，它本应是一个让电子商务公司接入社交电商的平台。如果你还记得当时的“购买按钮”（buy buttons）。它在万众瞩目中发布，但最终失败了。它没有产生我们预期的收入或数字。这里的教训是，尽管你可能对在特定时刻向市场推出某样东西有坚定的信念，但市场的时机（timing）真的非常重要。多方共同协作使平台运作的时机也非常重要。我们的教训是，我们没有深入研究市场动态，没有做足够的用户研究。人们真的想要这个吗？如果想要，他们的替代方案是什么？他们正在使用的技术栈是什么？他们会采用一个全新的工具，还是更倾向于一个能直接集成到现有系统（如电商库存管理系统）中的工具？因此，我认为它再次证明了领先于市场和时代有时也会导致失败，无论我们在发布上投入了多少精力，它最终还是彻底失败了。

---

### [01:07:22] Lenny Rachitsky

**English:**
This reminds me of when Kevin Weil was on the podcast talking about Libra, which was his cryptocurrency project that Facebook ran, and he's just like, "Okay, that was a terrible time to launch something like that where people trusted Facebook the least in our history." And now may be a good time to try something like that. Basically, a cryptocurrency platform to send money internationally for free. What a dream that would be. Okay. Krithika, is there anything else you wanted to share or maybe something you wanted to remind people of from what we've talked about? Just to leave folks with a final nugget before we get to our very exciting lightning round.

**中文翻译:**
这让我想起了 Kevin Weil 在播客里谈到的 Libra，那是他在 Facebook 负责的加密货币项目。他说：“好吧，那是发布那种东西的最糟糕时机，因为当时人们对 Facebook 的信任度处于历史最低点。” 而现在可能是尝试这种东西的好时机。基本上，一个可以免费进行国际汇款的加密货币平台，那简直是梦想。好，Krithika，在进入闪电轮之前，你还有什么想分享的，或者想提醒大家的吗？给听众留最后一点干货。

---

### [01:07:55] Krithika Shankarraman

**English:**
If there's one thing that folks take away, I hope it is that they know that there isn't one clear answer to any of the marketing problems. It seems like there's a playbook for everything, there is a framework for everything, but the reality is the work is hard. You have to spend the hours and the time to really understand your customer, and there is no replacement for that, and there isn't going to be even with the advent of AI. And the other part of it is to deeply understand your product as well. What are you bringing to the table? And not just your product, but your company's values, your unique approach that you're bringing to the table. And really be intentional and thoughtful about that because in the absence of that, nothing is going to be a substitute to bring that combination of ingredients together.

**中文翻译:**
如果听众只能带走一样东西，我希望是：任何营销问题都没有唯一的标准答案。似乎每件事都有策略手册和框架，但现实是，这项工作很辛苦。你必须投入大量时间去真正了解你的客户，没有任何东西可以替代这一点，即使 AI 出现了也不行。另一部分是深度理解你的产品。你带来了什么价值？不仅是产品，还有公司的价值观、你带来的独特方法。要非常有意识且深思熟虑地对待这些，因为如果没有这些，任何东西都无法替代这些要素的结合。

---

### [01:08:45] Lenny Rachitsky (Lightning Round)

**English:**
With that, we've reached our very exciting lightning round. We have five questions for you. Are you ready?

**中文翻译:**
现在进入我们非常激动人心的闪电轮。我们有五个问题。准备好了吗？

---

### [01:08:51] Krithika Shankarraman

**English:**
Hit me.

**中文翻译:**
来吧。

---

### [01:08:51] Lenny Rachitsky

**English:**
Here we go. What are two or three books that you find yourself recommending most to other people?

**中文翻译:**
第一题：你最常向别人推荐的两三本书是什么？

---

### [01:08:57] Krithika Shankarraman

**English:**
On the professional side, one book that I recommend to most people is April Dunford's book on positioning called Obviously Awesome. She does a great job breaking down how to position a product from scratch if you've never had to do that, and she's just so great for her real talk. So, really highly recommend that. And then I love fiction, so I would say one of the best reads in the last couple years has been Madeline Miller's Circe, which is a retelling of a Greek myth. Lyrical prose, beautiful writing, highly recommend.

**中文翻译:**
在专业领域，我向大多数人推荐的一本书是 April Dunford 关于定位的书，叫《显然很棒》（Obviously Awesome）。如果你从未做过产品定位，她能很好地教你如何从零开始，而且她的风格非常务实。非常推荐。另外我喜欢小说，过去几年读过的最好的书之一是 Madeline Miller 的《瑟曦》（Circe），它是对希腊神话的重新演绎。文笔优美，极力推荐。

---

### [01:09:32] Lenny Rachitsky

**English:**
Love the combo. April Dunford, we're huge fans of her on the podcast. She's been on twice. I think her book is in my background. We'll link to her episodes.

**中文翻译:**
很棒的组合。我们是 April Dunford 的忠实粉丝，她来过两次。我想她的书就在我的背景里。我们会附上她的节目链接。

---

### [01:09:40] Krithika Shankarraman

**English:**
And mine.

**中文翻译:**
我的背景里也有。

---

### [01:09:41] Lenny Rachitsky

**English:**
Oh, wow. Okay. So cool. Yeah, she's the best. Okay, next question. Do you have a favorite recent movie or TV show that you have really enjoyed?

**中文翻译:**
噢哇，太酷了。是的，她是最好的。好，下一个问题：你最近有没有非常喜欢的电影或电视剧？

---

### [01:09:48] Krithika Shankarraman

**English:**
I'm really late to the game, but I'm finally catching up on Severance. So, no spoilers, but I'm about halfway through the first season.

**中文翻译:**
我入坑很晚，但我终于在补《人生切割术》（Severance）了。别剧透，我刚看到第一季的一半。

---

### [01:09:54] Lenny Rachitsky

**English:**
Wow, okay. It's hard to weigh the spoilers, but yeah, keep going. It's amazing. Do you have a favorite product you've recently discovered that you really love?

**中文翻译:**
哇，好。不剧透很难，但继续看吧，非常精彩。你最近有没有发现什么非常喜欢的、心头好的产品？

---

### [01:10:03] Krithika Shankarraman

**English:**
Granola for meeting notes because, all right, I love taking meeting notes as a way to stay engaged in the conversation and to pay a lot of attention, but I also know I'm furiously typing away. And so the ability to augment my notes and bullet points has been a game changer.

**中文翻译:**
用于会议记录的 Granola。我喜欢记会议笔记，这能让我保持专注，但我知道我总是在疯狂打字。Granola 增强笔记和要点的能力简直改变了游戏规则。

---

### [01:10:20] Lenny Rachitsky

**English:**
That's two guests in a row that said Granola, and I'll give a plug. You get a year free of Granola if you become an annual subscriber of my newsletter... [Promo details omitted]

**中文翻译:**
连续两个嘉宾都提到了 Granola。我顺便打个广告，如果你成为我时事通讯的年度订阅者，可以免费获得一年 Granola……

---

### [01:10:36] Krithika Shankarraman

**English:**
Happy to help, Lenny.

**中文翻译:**
很高兴能帮上忙，Lenny。

---

### [01:10:38] Lenny Rachitsky

**English:**
It's helping Granola, and me, I guess. Yeah, it's great. Okay, thank you. Two more questions. Do you have a favorite life motto that you find useful in work or in life?

**中文翻译:**
我想这对 Granola 和我都有帮助。是的，太棒了。好，谢谢。还有最后两个问题。你有没有什么在工作或生活中觉得非常有用的座右铭？

---

### [01:10:49] Krithika Shankarraman

**English:**
My teams have now gotten tired of me saying this, but I say it all the time, which is the delta between expectations and reality is the function for unhappiness. And so it is much easier to change expectations than it is reality, so I tend to spend a lot of my energy making sure that expectations are set. Not just with customers when it comes to our external marketing, but internally with stakeholders, project partners, and even within the team so that they understand what are some of the trade-offs that we're making, or why we're making certain decisions. So I could not espouse that philosophy enough.

**中文翻译:**
我的团队已经听腻了这句话，但我一直在说：**预期与现实之间的差距是衡量不快乐的函数**。改变预期比改变现实要容易得多，所以我倾向于投入大量精力确保预期被正确设定。不仅是在外部营销中对客户设定预期，在内部对利益相关者、项目伙伴甚至团队内部也是如此，让他们理解我们正在做出的权衡，以及为什么做出某些决定。我非常推崇这个哲学。

---

### [01:11:25] Lenny Rachitsky

**English:**
I love that this isn't, because I think when people first hear that it's about your own happiness, but I love that it's about other people perceiving how a something did and setting their expectations correctly. Final question. Okay, we've already talked about the em dash, but I want to ask you again. What I'm finding is, so the story here is basically people have discovered ChatGPT's using em dashes a lot, which are these long dashes that you have to use special couple letters on the keyboard to use. I'm a huge... I use these all the time, and people are starting to filter them out on Twitter because they're assuming it's generated by ChatGPT. There's content that has em dashes they assume isn't real. Will you continue using em dashes in spite of all this?

**中文翻译:**
我喜欢这个观点，因为人们第一次听到时可能以为是关于自己的快乐，但我喜欢它关于“别人如何感知某件事”以及“正确设定他们的预期”这一点。最后一个问题。好，我们已经聊过破折号（em dash）了，但我还想再问一次。现在的背景是，人们发现 ChatGPT 经常使用破折号（就是键盘上需要特殊组合键打出的长横杠）。我也是破折号的忠实用户，但现在人们开始在 Twitter 上过滤带破折号的内容，因为他们觉得那是 ChatGPT 生成的。尽管如此，你还会继续使用破折号吗？

---

### [01:12:06] Krithika Shankarraman

**English:**
I have begrudgingly reduced my usage of em dashes- (Lenny: Same.) ... but you will not pry them out of my cold dead hands if you tried.

**中文翻译:**
我虽然很不情愿地减少了使用频率——（Lenny：我也是。）——但除非我死了，否则谁也别想把破折号从我手里夺走。

---

### [01:12:15] Lenny Rachitsky

**English:**
Oh, man, me too. I don't even know. It's like command, options, dash or something to even put it in there.

**中文翻译:**
噢，伙计，我也是。我甚至都不知道怎么打出来，好像是 Command + Option + Dash 之类的。

---

### [01:12:20] Krithika Shankarraman

**English:**
No, it's option, shift, minus.

**中文翻译:**
不，是 Option + Shift + 减号。

---

### [01:12:23] Lenny Rachitsky

**English:**
Option, shift, minus.

**中文翻译:**
Option + Shift + 减号。

---

### [01:12:23] Krithika Shankarraman

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:12:24] Lenny Rachitsky

**English:**
I have to type it. I can't conceptualize in my head. Yeah, and then there's actual rules for when an em dash is the right thing versus, there's a middle-

**中文翻译:**
我得亲手打出来才行，脑子里记不住。是的，而且关于什么时候该用破折号，什么时候该用中横线，是有明确规则的——

---

### [01:12:32] Krithika Shankarraman

**English:**
Em dash and the Oxford comma, the two core tenets of my toolbox.

**中文翻译:**
破折号和牛津逗号（Oxford comma），是我工具箱里的两大核心原则。

---

### [01:12:36] Lenny Rachitsky

**English:**
Is an Oxford comma where you add the comma at the end or you don't? Is that the-

**中文翻译:**
牛津逗号是在列表最后加逗号还是不加？

---

### [01:12:36] Krithika Shankarraman

**English:**
You keep the comma at the end. You must.

**中文翻译:**
必须在最后保留逗号。必须。

---

### [01:12:39] Lenny Rachitsky

**English:**
Okay. I'm all for that, too. It looks so weird without it. But there's also another, like a shorter not em dash. I guess it's called something else, right? There's like-

**中文翻译:**
好，我也支持。没有它看起来太奇怪了。但还有一种更短的，不是 em dash，我猜叫别的名字？

---

### [01:12:48] Krithika Shankarraman

**English:**
The en dash, yeah.

**中文翻译:**
是 en dash，没错。

---

### [01:12:48] Lenny Rachitsky

**English:**
En dash.

**中文翻译:**
En dash。

---

### [01:12:49] Krithika Shankarraman

**English:**
That's for ranges of numbers.

**中文翻译:**
那是用于表示数字范围的。

---

### [01:12:51] Lenny Rachitsky

**English:**
Okay, okay. I love that you know all this. Okay. Well, with that, Krithika, this has been so fun and so awesome. Thank you so much for being here. Two final questions. Where can folks find you online if they want to reach out, maybe work with you, and how can listeners be useful to you?

**中文翻译:**
好，好。我喜欢你对这些了如指掌。好，Krithika，这次聊天非常愉快，也非常精彩。非常感谢你能来。最后两个问题：如果大家想联系你或者和你合作，可以在哪里找到你？听众能为你提供什么帮助？

---

### [01:13:05] Krithika Shankarraman

**English:**
Krithix.com is where you'll find links to all my online presences. And one of my personal missions this year is to meet as many of the up-and-coming marketing talents in the world. So anyone that you know is earlier career, ambitious, but really showing their impact at their organization, please introduce them to me. I would love to chat.

**中文翻译:**
Krithix.com 可以找到我所有社交媒体的链接。我今年的个人使命之一是结识尽可能多的全球营销新秀。所以，如果你认识任何处于职业生涯早期、有抱负且在组织中展现出真实影响力的人，请把他们介绍给我。我很乐意交流。

---

### [01:13:26] Lenny Rachitsky

**English:**
And then what's the best way for them to reach out to you? Is it just on your website?

**中文翻译:**
那联系你的最好方式是什么？直接通过你的网站吗？

---

### [01:13:29] Krithika Shankarraman

**English:**
Yes, please.

**中文翻译:**
是的，拜托了。

---

### [01:13:30] Lenny Rachitsky

**English:**
Amazing. We'll link to that in the show notes. Krithika, thank you so much for being here.

**中文翻译:**
太棒了。我们会把链接放在节目介绍里。Krithika，非常感谢你能来。

---

### [01:13:34] Krithika Shankarraman

**English:**
Thank you for having me.

**中文翻译:**
谢谢你的邀请。

---

### [01:13:35] Lenny Rachitsky

**English:**
Bye everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
再见，各位。非常感谢收听。如果你觉得本期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅。此外，请考虑给我们评分或留下评论，这能帮助其他听众发现这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目再见。