# Lane Shackleton - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Lane Shackleton (CPO of Coda).

---

### [00:00:00] Lane Shackleton

**English:**
Moments that stretch you or moments that you feel uncomfortable in or you find yourself saying, "Oh shit. I shouldn't be here," or, "I'm under qualified to be here," those are the moments you should be seeking out. Those are the moments that stretch you and give you a new foundation. So oftentimes you'll hear a career question like, "Hey, do you feel like you're growing in your role?" And that's a very ambiguous, in my opinion, way to ask this question. A much sharper way is like, "Hey, how many, oh shit moments have you had in the last six months, year, two years, and what are they?" I think if you ask yourself that question and the answer is, "It's been a really long time since I've been stretched in some meaningful way or I've felt like I'm under qualified to be there," then it may be worth digging into.

**中文翻译:**
那些让你感到挑战、让你觉得不舒服，或者让你不由自主地说出“天呐（Oh shit），我不该在这儿”或“我资历不够，不配在这儿”的时刻，正是你应该去寻找的时刻。这些时刻能磨练你，并为你打下新的基础。所以，你经常会听到关于职业生涯的问题，比如：“嘿，你觉得你在现在的职位上有成长吗？”在我看来，这种问法非常模糊。一个更犀利的方式是问：“嘿，在过去的六个月、一年或两年里，你有过多少次‘天呐’时刻？它们分别是什么？”我觉得如果你问自己这个问题，而答案是“我已经很久没有在任何有意义的方面受到挑战，或者很久没有那种‘我资历不足以胜任’的感觉了”，那么这可能值得你深入思考一下。

---

### [00:00:51] Lenny

**English:**
Welcome to Lenny's Podcast, where I interview world-class product leaders and growth experts to learn from their hard won experiences building and growing today's most successful products. Today my guest is Lane Shackleton. Lane is Chief Product Officer at Coda where he's held the role for over eight years. Before that, he was Group Product Manager at YouTube, a Product Specialist at Google, and as you'll hear, he started his career as an Alaskan mountain guide and then as a manual reviewer of Google AdWords ads. Lane is an incredibly deep thinker, very first principles oriented, and has built an incredible product team and culture at Coda. In part, he's done that by studying the principles and rituals of great product leaders and great product teams. In our conversation, Lane shares what he's learned, what he's found great PMs and great teams do differently. He shares a bunch of his favorite rituals and principles, how you can implement them on your own team, plus a really clever and unique way of understanding if you're making progress in your career, plus so much more. I could talk to Lane for hours, but we tried to keep this to under an hour and a half. With that, I bring you Lane Shackleton after a short word from our sponsors.

**中文翻译:**
欢迎来到 Lenny 的播客。在这里，我会采访世界级的产品领导者和增长专家，学习他们在构建和发展当今最成功产品过程中积累的宝贵经验。今天的嘉宾是 Lane Shackleton。Lane 是 Coda 的首席产品官（CPO），他担任这一职位已经超过八年。在此之前，他是 YouTube 的群组产品经理（GPM），Google 的产品专家。正如你将听到的，他的职业生涯始于阿拉斯加的登山向导，然后是 Google AdWords 广告的人工审核员。Lane 是一个非常有深度、极其注重第一性原理（First Principles）的思考者，他在 Coda 建立了一支非常出色的产品团队和文化。在某种程度上，他是通过研究伟大产品领导者和团队的原则与仪式（Rituals）来实现这一点的。在我们的对话中，Lane 分享了他的所学，以及他发现优秀的产品经理（PM）和团队有哪些与众不同之处。他分享了许多他最喜欢的仪式和原则，以及你如何将它们应用到自己的团队中，此外还有一个非常聪明且独特的方法来判断你的职业生涯是否在进步，还有更多精彩内容。我可以和 Lane 聊上好几个小时，但我们尽量把时间控制在一个半小时以内。下面，在听完赞助商的简短介绍后，让我们欢迎 Lane Shackleton。

---

### [00:01:55] Lenny (Sponsor Message)

**English:**
This episode is brought to you by Eppo. Eppo is a next generation AB testing platform built by Airbnb alums for modern growth teams. Companies like DraftKings, Zapier, ClickUp, Twitch and Cameo rely on Eppo to power their experiments. Wherever you work, running experiments is increasingly essential, but there are no commercial tools that integrate with a modern grow team stack. This leads to wasted time building internal tools or trying to run your own experiments through a clunky marketing tool. When I was at Airbnb, one of the things that I loved most about working there was our experimentation platform where I was able to slice and dice data by device types, country, user stage. Eppo does all that and more, delivering results quickly, avoiding annoying prolonged analytic cycles and helping you easily get to the root cause of any issue you discover. Eppo lets you go beyond basic click through metrics and instead use your north star metrics like activation, retention, subscription and payments. Eppo supports tests on the front end, on the backend, email marketing, even machine learning claims. Check out Eppo at geteppo.com. That's geteppo.com and 10x your experiment velocity.

**中文翻译:**
本期节目由 Eppo 赞助。Eppo 是由 Airbnb 前员工为现代增长团队打造的下一代 AB 测试平台。像 DraftKings、Zapier、ClickUp、Twitch 和 Cameo 这样的公司都依赖 Eppo 来支持他们的实验。无论你在哪里工作，运行实验都变得越来越重要，但目前还没有商业工具能与现代增长团队的技术栈完美集成。这导致人们浪费时间构建内部工具，或者尝试通过笨重的营销工具运行实验。当我在 Airbnb 时，我最喜欢的工作内容之一就是我们的实验平台，在那里我可以按设备类型、国家、用户阶段对数据进行切片分析。Eppo 实现了这一切甚至更多，它能快速交付结果，避免烦人且漫长的分析周期，并帮助你轻松找到发现的任何问题的根本原因。Eppo 让你超越基本的点击率指标，转而使用你的北极星指标（North Star Metrics），如激活、留存、订阅和支付。Eppo 支持前端、后端、邮件营销甚至机器学习声明的测试。请访问 geteppo.com 查看 Eppo。即 geteppo.com，让你的实验速度提升 10 倍。

---

### [00:03:03] Lenny (Sponsor Message)

**English:**
This episode is brought to you by Vanta, helping you streamline your security compliance to accelerate your growth. Thousands of fast-growing companies like Gusto, Calm, Quora and Modern Treasury trust Vanta to help build, scale, manage and demonstrate their security and compliance programs and get ready for audits in weeks, not months. By offering the most in-demand security and privacy frameworks such as SOC2, ISO 27,001, GDPR, HIPAA and many more, Vanta helps companies obtain the reports they need to accelerate growth, build efficient compliance processes, mitigate risks to their businesses, and build trust with external stakeholders. Over 5,000 fast-growing companies use Vanta to automate up to 90% of the work involved with SOC2 and these other frameworks. For a limited time Lenny's Podcast listeners get $1,000 off Vanta. Go to vanta.com/lenny. That's V-A-N-T-A.com/lenny to learn more and to claim your discounts. Get started today.

**中文翻译:**
本期节目由 Vanta 赞助，帮助你简化安全合规流程，加速业务增长。数千家快速成长的公司，如 Gusto、Calm、Quora 和 Modern Treasury，都信任 Vanta 来帮助构建、扩展、管理和展示其安全与合规计划，并在几周而非几个月内为审计做好准备。通过提供最受青睐的安全和隐私框架，如 SOC2、ISO 27001、GDPR、HIPAA 等，Vanta 帮助公司获得加速增长所需的报告，建立高效的合规流程，降低业务风险，并与外部利益相关者建立信任。超过 5,000 家快速成长的公司使用 Vanta 自动完成 SOC2 及其他框架中高达 90% 的工作。在限定时间内，Lenny's Podcast 的听众可以享受 Vanta 1,000 美元的优惠。访问 vanta.com/lenny（即 V-A-N-T-A.com/lenny）了解更多信息并领取折扣。今天就开始吧。

---

### [00:04:04] Lenny

**English:**
Lane, thank you so much for being here. Welcome to the podcast.

**中文翻译:**
Lane，非常感谢你能来。欢迎来到本播客。

---

### [00:04:07] Lane Shackleton

**English:**
So glad to be here. Thanks for having me.

**中文翻译:**
很高兴来到这里。谢谢你的邀请。

---

### [00:04:09] Lenny

**English:**
It's absolutely my pleasure. I've always really admired the way that you write about product, the way you think about product, and it feels like Coda has one of the strongest and also the most thoughtful product teams out there. And so I am really excited to have you on here and learn from what you've learned over the years. My first question is completely unrelated. I have to ask. Your last name's Shackleton. Any relation to a certain very famous Antarctic explorer?

**中文翻译:**
这是我的荣幸。我一直非常钦佩你写产品的方式和你思考产品的方式，感觉 Coda 拥有业内最强大、也最深思熟虑的产品团队之一。所以我非常激动能请你过来，向你学习这些年积累的经验。我的第一个问题完全无关。我必须得问一下：你的姓是 Shackleton（沙克尔顿）。你和那位非常有名的南极探险家（欧内斯特·沙克尔顿）有什么亲戚关系吗？

---

### [00:04:36] Lane Shackleton

**English:**
Yeah. It's probably distant at best. I wish it was close. I wish I could claim it was my father or grandfather. But I definitely grew up with those stories and reading a lot about him as a kid. In high school we read Endurance, which is a great book if you haven't read it. It's an amazing story. Very inspiring how he put people first and brought back all of his men from this journey to the South Pole. So have taken a lot of lessons from that, but that's as close as I can come to the greatness of Ernest Shackleton.

**中文翻译:**
哈哈，充其量也就是远亲吧。我倒希望关系能近点，希望我能说他是我父亲或祖父。但我确实是听着那些故事长大的，小时候读了很多关于他的书。高中时我们读了《坚忍号》（Endurance），如果你没读过的话，那是一本很棒的书。那是一个惊人的故事，他如何坚持以人为本，并把所有的部下都从那次南极之旅中安全带回来，非常令人振奋。我从中吸取了很多教训，但这就是我能与伟大的欧内斯特·沙克尔顿扯上的最深关系了。

---

### [00:05:09] Lenny

**English:**
Okay. So there's a connection. When I think of Shackleton, I also think of the ad that he ran for recruiting people to join his journey. Low chance of survival, incredibly hard, chance for glory if you succeed, something like that.

**中文翻译:**
好吧，看来还是有点渊源的。当我想到沙克尔顿，我还会想到他为了招募探险队员而刊登的那则广告：生存机会渺茫，极其艰辛，如果成功则有获得荣耀的机会，大概是这样。

---

### [00:05:23] Lane Shackleton

**English:**
It's a wonderful ad. I think I had a mug of that when I was a kid. Yeah.

**中文翻译:**
那是一则精彩的广告。我记得我小时候还有一个印着那则广告的马克杯。是的。

---

### [00:05:28] Lenny

**English:**
Amazing. Okay. So on that same topic, I noticed maybe your first job was a mountain guide in Alaska. Was that inspired by this legacy? And also why did you decide not to pursue that and get into product management? Completely different life.

**中文翻译:**
太棒了。好，回到这个话题，我注意到你的第一份工作可能是在阿拉斯加当登山向导。那是受这份家族传承的启发吗？还有，你为什么决定不继续做那个，而是进入了产品管理领域？这完全是两种不同的生活。

---

### [00:05:42] Lane Shackleton

**English:**
Yeah. Yeah. Very, very different. Very different time. Didn't have kids back then. I think I was convinced at the time I wanted a career outside. Just loved spending time in the mountains and climbing, things like that. To be honest, I wasn't the best guide. There were a lot of amazing guides out there that just had ... They were almost invincible in terms of their ability to climb for 20, 30 hours. But I learned a lot from the experience and maybe the quick story on why I stopped guiding. I was on what is a dream trip for mountain guides, which is we were flown to a remote portion of southeast Alaska. It's an hour long flight. Mountain called Mount Fairweather. Beautiful 15,000 foot peak. And as a part of climbing on glaciers one of the things that you do for context is you're roped to another person. And the reason that you do that is because if someone falls in a crevasse, you want to be able to stop them or pull them out.
(00:06:48):
So I was roped to a very nice client that I was guiding and he fell pretty close to the top on our way down. And luckily we were able to self-arrest and arrest that fall. But I spent probably the next six hours walking down that mountain thinking the same thing over and over again, which is I really don't want to die roped to someone that I barely know and don't trust or love. So that was the last season that I guided. But tons of great memories and learnings and I think it impacted my life in a pretty significant way.

**中文翻译:**
是的，非常非常不同。那是完全不同的时期，当时还没有孩子。我想我那时坚信自己想要一份户外职业，就是喜欢待在山里、攀岩之类的。老实说，我并不是最好的向导。那里有很多了不起的向导，他们简直是……在连续攀登 20、30 个小时的能力上几乎是无敌的。但我从那段经历中学到了很多。关于我为什么停止当向导，有一个简短的故事：当时我正在进行一次登山向导梦寐以求的旅行，我们被空投到阿拉斯加东南部的一个偏远地区。那是一个小时的航程，去一座叫费尔韦瑟山（Mount Fairweather）的山，那是一座海拔 15,000 英尺的美丽山峰。在冰川攀登中，为了安全，你需要和另一个人用绳子系在一起。这样做是因为如果有人掉进冰裂缝（Crevasse），你想能够拉住他们或把他们拉出来。
(00:06:48):
当时我和一位非常友好的客户系在一起，在下山途中快到山顶的地方，他滑倒了。幸运的是，我们成功进行了自我制动（Self-arrest）并止住了坠落。但在接下来的六个小时下山路程中，我脑子里一直在重复同一个念头：我真的不想和一个我几乎不认识、不信任也不爱的人系在一起死掉。所以，那是我的最后一个向导赛季。但那留下了无数美好的回忆和教训，我认为它以一种非常深远的方式影响了我的生活。

---

### [00:07:37] Lenny

**English:**
Damn. Software much lower stakes. I guess just while we're on this topic, is there any parallels or big lesson you learned from that experience that you bring to product?

**中文翻译:**
天呐。软件行业的风险可低多了。既然聊到这个话题，那段经历中有什么相似之处，或者你学到的能应用到产品中的重要教训吗？

---

### [00:07:37] Lane Shackleton

**English:**
One is just preparation. I think when you go climbing or when you guide climbing, you spend months and months preparing for usually a few days of climbing. So there's that kind of preparation. There's also just a million checklists. So before you go on an expedition, you may check a checklist of all your equipment, stuff like that a dozen times or more. So you ensure redundancy across all your systems. So that was definitely a parallel. The other thing I think about a lot is just how to stay calm in challenging or scary scenarios. We had another instance where I had a client pull a big chunk of rock off and break their feet and I was the junior guide on that particular instance and the more senior guide looked at me, looked at the situation and was like, "Okay, we're getting this guy out of here right now." Put him on his back and we basically took turns carrying him out for a couple miles I'll just never forget instances like that where the clarity of stay calm, assess the situation, prioritize, take action. There's a mini version of that when you're building software, I think. So experiences like that, I think, even though I only did it for a handful of summers, were pretty profound.

**中文翻译:**
一个是准备工作。我认为当你去攀登或带队攀登时，你通常会花好几个月的时间为几天的攀登做准备。这就是那种程度的准备。还有就是无数的检查清单。在探险之前，你可能会把所有装备的清单检查十几遍甚至更多。这样你就能确保所有系统的冗余。这绝对是一个相似点。另一件我经常思考的事是如何在具有挑战性或恐怖的场景中保持冷静。我们还有过一次经历，一位客户踩落了一大块岩石并摔断了脚，当时我是那次任务的初级向导，高级向导看了看我，看了看情况，说：“好，我们现在就把这家伙弄出去。”他把他背在背上，我们基本上轮流背着他走了几英里。我永远不会忘记那样的时刻：保持冷静、评估形势、确定优先级、采取行动，这种清晰度。我认为在开发软件时也有这种模式的缩小版。所以，尽管我只做了几个夏天的向导，但那些经历对我来说非常深刻。

---

### [00:09:12] Lenny

**English:**
Yeah. What a very different life that life path would've been.

**中文翻译:**
是的。如果走那条路，那将是多么不同的人生。

---

### [00:09:12] Lane Shackleton

**English:**
Pre kids. Yeah.

**中文翻译:**
那是还没孩子的时候。是的。

---

### [00:09:12] Lenny

**English:**
Oh, man. So you mentioned your writing, you mentioned that this is something you want to write about. Shifting to the core topic of our chat, it's very clear that you spent a lot of time studying how great product managers operate and how great product teams operate. You've been doing a bunch of writing on the principles of great product management and also the rituals of great teams. And so I want to spend a bunch of time trying to extract as much as I can from your learning so that listeners can learn. Essentially what are principles of great product managers, what are rituals of great teams and generally how do the best teams operate? And my first question is just why is this something that you started doing? What pulled you into spending so much time and effort trying to understand how the best teams and people operate?

**中文翻译:**
噢，伙计。你提到了你的写作，提到这是你想写的东西。转到我们聊天的核心话题，很明显你花了很多时间研究优秀的产品经理是如何运作的，以及优秀的产品团队是如何运作的。你写了很多关于优秀产品管理的原则以及优秀团队的仪式（Rituals）的文章。所以我想花点时间尽量从你的学习中挖掘出更多的东西，让听众也能学习。本质上，优秀产品经理的原则是什么，优秀团队的仪式是什么，以及最顶尖的团队通常是如何运作的？我的第一个问题是，你为什么开始做这件事？是什么吸引你投入这么多时间和精力去理解最优秀的团队和个人是如何运作的？

---

### [00:09:53] Lane Shackleton

**English:**
Yeah. Yeah. I've been asking myself that question a little bit lately. There's a few reasons. One reason is I just found myself giving a similar set of advice in one on ones. And so I think anytime you find as a leader yourself repeating the same lessons, it should be a good flag to say like, oh, I should probably scale this in some way. And as you know, as soon as you write something down, you have to clarify your own thinking and so it becomes very useful for that. And I don't think I quite expected how useful it would be in that sense. Writing something down and then putting it out there, you start to get feedback back of where you might've been right or where you might not be right. And so for me it's been a good learning experience there as well. I think the second reason is I've always been pretty frustrated with career ladders. Most companies have career ladders with 10 or 15 levels and as soon as they hit some scale levels, there's levels between levels and I feel like I looked at the one at Google and you needed a PhD to decipher it and interpret how to operate within it.
(00:11:11):
And so that's one piece of the construct. If you think more broadly though, they aren't consistent across companies, so now you're in a situation where you're in your version of the rat race. And so I found that I basically wanted to have a broader set of principles that transcended level. So things that could be true when you are an ICPM starting your career and things that can also be true when you're the head of product or running a product team or things like that. That's one. I won't rant further on that but I think that's one piece of it.
(00:11:49):
And then I think the last reason I'll mention is I was pretty inspired by a talk that is by this guy named Brett Victor, who's like a prototyper thinker. May have heard of his work. He has this talk called Inventing on Principle. And in the early days of Coda, one of our first designers, this guy Jeremy Britten, showed this talk to the company and my mind was blown. And I think it was one of those examples of someone developing a clear view of what principles they should operate with and then following that principle. And it was just a meta example of how important it is and how impactful it can be when you decide on a principle and then follow it. And so ever since then I've been thinking what are my principles as it pertains to building software and other things. So those are the three reasons that led me to start writing these things down.

**中文翻译:**
是的，最近我也在问自己这个问题。有几个原因。一个原因是我发现自己在 1 对 1 面谈中总是给出类似的一套建议。我认为，作为一名领导者，当你发现自己在重复同样的教训时，这应该是一个很好的信号，提醒你：哦，我可能应该以某种方式把这些内容规模化。而且如你所知，一旦你把东西写下来，你就必须理清自己的思路，所以这对理清思路非常有用。我当时并没预料到它在这方面会如此有用。写下来并发布出去后，你会开始收到反馈，告诉你哪里是对的，哪里可能不对。所以对我来说，这也是一个很好的学习过程。第二个原因是我一直对“职业阶梯”（Career Ladders）感到很沮丧。大多数公司的职业阶梯有 10 到 15 级，一旦达到一定规模，级与级之间还有中间级。我觉得我看 Google 的那个阶梯时，得有个博士学位才能破译它并理解如何在其中运作。
(00:11:11):
所以这是结构的一部分。但如果从更广的角度看，不同公司的阶梯并不一致，所以你现在处于一种“内卷”（Rat race）的状态。因此我发现，我基本上想要一套超越级别的更广泛的原则。也就是说，无论你是刚开始职业生涯的个人贡献者产品经理（ICPM），还是产品负责人或管理产品团队的人，这些原则都适用。这是其中一点，我就不再多抱怨了，但这确实是原因之一。
(00:11:49):
最后一点，我深受 Brett Victor 的一次演讲启发，他是一位原型设计思想家。你可能听说过他的作品。他有一个名为《依原则发明》（Inventing on Principle）的演讲。在 Coda 的早期，我们最早的设计师之一 Jeremy Britten 向全公司展示了这个演讲，我当时被震撼了。我认为那是一个典型的例子，展示了某人如何对应该遵循的原则形成清晰的看法，然后去践行那个原则。这是一个关于“决定一个原则并遵循它”有多重要、多有影响力的元示例（Meta example）。从那以后，我就一直在思考，在构建软件和其他事情方面，我的原则是什么。这就是促使我开始把这些东西写下来的三个原因。

---

### [00:13:06] Lenny

**English:**
Amazing. We'll find that talk and link to it in the show notes. I want to ask about what principles you've come to, but I also want to understand how you actually ended up doing ladders and performance review stuff at Coda. Would it be better to talk about that later after we go through some of these things or is there something you want to share first of just how you think about it at Coda?

**中文翻译:**
太棒了。我们会找到那个演讲并链接到节目笔记中。我想问问你总结出了哪些原则，但我也想了解你们在 Coda 实际上是如何处理职业阶梯和绩效评估的。是在我们讨论完这些原则后再聊这个比较好，还是你想先分享一下你们在 Coda 是怎么考虑这件事的？

---

### [00:13:06] Lane Shackleton

**English:**
When we were doing career ladders, first of all, we put it off for quite a bit of time and that was based on the advice of a lot of other leaders that said as soon as you introduce this, then the incentives flip from being company focused to being individual focused. So I think we delayed it for a good bit of time. There came a time where we decided, "Hey look, we really do need to provide better guidance here about what it means to grow and what it means to be great." And so about the same time we were doing the levels thing I started writing down some of the principles that I've been publishing. One of the things that I think about a lot when talking about levels is just how to keep everyone oriented toward their team and their company. And I think that we've done a really good job of that over the years. So levels aren't by any means at the forefront of any company discussion. In fact, we don't use titles that much.

**中文翻译:**
当我们制定职业阶梯时，首先，我们推迟了相当长一段时间。这是基于许多其他领导者的建议，他们说一旦你引入这个，激励机制就会从以公司为中心转变为以个人为中心。所以我想我们推迟了很久。直到有一天我们决定：“嘿，看，我们确实需要在这里提供更好的指导，说明成长意味着什么，优秀意味着什么。”就在我们处理级别问题的同时，我开始写下我一直在发布的一些原则。在讨论级别时，我经常思考的一件事是如何让每个人都保持以团队和公司为导向。我认为这些年来我们在这方面做得非常好。所以，级别绝不是公司讨论的重点。事实上，我们并不怎么使用头衔。

---

### [00:14:11] Lenny

**English:**
You said that it's not specific to role. Do you mean the same leveling attributes are the same from design and product and engineering?

**中文翻译:**
你说这不针对特定角色。你的意思是设计、产品和工程部门的职级属性都是一样的吗？

---

### [00:14:19] Lane Shackleton

**English:**
We basically have five levels and we call them role stages and they go from apprentice to principal. So apprentice is ... Rope analogy here is learns about rope. Practitioner is can tie basic knots, shown complex knots. Given a problem, they can do it. Career is you can calculate rope strength. You know a lot about knots. Principal is basically invented nylon. So the bar is really, really high for principal in these levels and I think that that's appropriate. It should be aspirational that the bar is exceptionally high at the highest level of our role stages. I find it's a pretty good process to draw maybe a little bit of contrast with other companies. I think most other companies, especially large companies have 10 to 15 levels. I think we've made a really conscious choice to have only five. I think the other bit of contrast I would draw is basically role stages are not visible across the whole company. We're not showing levels of any individual PM or designer, and that's partially because we just don't want to put a big focus on it. And then probably the biggest difference is we have a centralized compensation committee and that's who decides compensation and so it's not the manager that drives your compensation. So those are some differences.

**中文翻译:**
我们基本上有五个级别，我们称之为“角色阶段”（Role Stages），从学徒（Apprentice）到首席（Principal）。学徒是……用绳子打个比方，就是学习关于绳子的知识。从业者（Practitioner）是能打基本的结，见过复杂的结。给他们一个问题，他们能解决。职业者（Career）是你能计算绳子的强度，对结非常了解。首席（Principal）基本上就是发明了尼龙的人。所以这些级别中首席的门槛非常非常高，我认为这是合适的。在我们的角色阶段中，最高级别的门槛异常高，这应该是一种愿景。我发现这是一个很好的过程，可以与其他公司做一点对比。我认为大多数其他公司，特别是大公司，有 10 到 15 个级别。我认为我们是有意识地选择只设 5 个级别。我想做的另一个对比是，角色阶段在全公司范围内是不可见的。我们不会展示任何个人 PM 或设计师的级别，部分原因是我们不想把重点放在这上面。然后最大的区别可能是我们有一个集中的薪酬委员会，由他们决定薪酬，所以决定你薪酬的不是你的经理。这些就是一些不同之处。

---

### [00:16:08] Lenny

**English:**
Super cool. I've never seen it done this way before. I think it's an awesome example of first principles thinking, which I see a lot come out from your product team. And then just to make sure I heard you right, these five stages are roughly the same across role, so designers have the same five and they're described similarly.

**中文翻译:**
太酷了。我以前从未见过这种做法。我认为这是一个极好的“第一性原理”思考的例子，我在你的产品团队中经常看到这种思考。为了确保我没听错，这五个阶段在不同角色中大致相同，所以设计师也有同样的五个阶段，而且描述也类似。

---

### [00:16:15] Lane Shackleton

**English:**
That's right. They're described similarly at a high level, but then the specifics if you get into it are a little bit different.

**中文翻译:**
没错。在高层面上描述是相似的，但如果你深入细节，具体内容会有一点不同。

---

### [00:16:15] Lenny

**English:**
Okay. I'm going to ask about what the principles are, or a few of them that you can share. But one other very tactical question. At what size of product teams, say just PMs, did you start to develop this framework?

**中文翻译:**
好的。我接下来想问问具体的原则是什么，或者你能分享其中的几个。但在那之前还有一个非常战术性的问题：当产品团队（比如只算 PM）达到什么规模时，你们开始开发这个框架的？

---

### [00:16:26] Lane Shackleton

**English:**
We were probably at 20-ish PMs and designers when we did that.

**中文翻译:**
当我们做这件事时，大概有 20 个左右的 PM 和设计师。

---

### [00:16:31] Lenny

**English:**
Awesome. Okay. So let me just ask, what are some of these principles you've narrowed it on as principles of great product managers?

**中文翻译:**
太棒了。那么，让我问一下，你总结出的优秀产品经理的原则有哪些？

---

### [00:16:38] Lane Shackleton

**English:**
Maybe it's helpful to start with a little higher level context on the unifying thesis. I think the unifying thesis is the core job of a product person in general is to turn ambiguity into clarity. And if you think about the job of a product leader or a product manager, everything is ambiguous all the time. It's like what's my role on this team? What problem are we solving? Who's the target customer? What prototype is going to solve this particular problem? So it's literally everything. And so if you're going to do the job well, you really need to get good at spotting ambiguity and turning it into clarity. And so the obvious question that follows from that is okay, great, that sounds like a great Hallmark card, but how do you actually do that? And so I think the principles that I've been writing down are very personal. They're my take on how to do this.
(00:17:41):
So the first one that I wrote about was systems not goals. And one of the ways that I started this post ... I'm a big fan of getting inspiration from outside of tech and so one of the stories that I tell is basically the story of Jerry Seinfeld. If you haven't seen the documentary Comedian, it's amazing, it's definitely worth watching. But the story goes, he's done Seinfeld the show and he's got all this material from the last 15 years and he comes in one day and he says, "Look, I'm going to throw away all my material and I'm going to start fresh." And this is unheard of in comedy for someone to just throw away all their old material and start fresh. And so the question is what does he do next? And the thing that he does is he sets a goal, which is basically to build up to an hour of material again.
(00:18:34):
But the goal isn't that important. What's important here is the system. So the system that he uses is he writes for an hour every morning, doesn't write for more if he doesn't want to, and then he goes and performs at night. And so when you rinse and repeat that system, do it hundreds of times, that's how he builds up from five minutes to 15 minutes to 30 minutes of material. And so I think that I take a lot of inspiration from that and I think product people can generally, which is instead of being obsessed with the goal, be obsessed with the system that gets you there. And so the phrase I sometimes use is goals with good intentions don't work. I really need to give a common example. A really common example is teams that are trying to learn about customers or do research. And one thing I've observed is a team may have a goal like an OKR of talking to 10 customers this quarter and they may or may not hit that OKR. And then if you watch closely, the next quarter, they may not have a goal of talking to customers anymore. And so their learning is going up and down.
(00:19:49):
And to draw a contrast, that's just really different than a team that has some default on system for talking to customers. Every few times a week they're talking to customers for whatever reason. And the impact of that is really hard to see until you understand that the latter team tends to have really good product instincts or really good customer instincts. It's because they've just had this default on mindset of talking to customers. And in the early days of Coda, we actually did something similar. We had a time allotted on Fridays and it was basically, it was on the calendar a customer or a potential customer was coming in and so you knew that it was going to happen and you had to have something to show. And so sometimes we'd be scrambling the three hours before to have a prototype ready for a customer. Sometimes we would've had something that we've been baking for a while. But the point is that it was default on. And so the way that we developed good customer instincts was not the goal, it was really just the system behind it. So that's one that I'm passionate about and I think it also translates into a lot of the rituals that we talk a lot about.

**中文翻译:**
也许先从一个更高层面的统一论题开始会有所帮助。我认为这个统一论题是：产品人的核心工作通常是将模糊性（Ambiguity）转化为清晰性（Clarity）。如果你思考一下产品领导者或产品经理的工作，你会发现一切始终都是模糊的。比如：我在这个团队中的角色是什么？我们要解决什么问题？目标客户是谁？什么样的原型能解决这个特定问题？简直是所有事情。所以，如果你想做好这份工作，你真的需要擅长发现模糊性并将其转化为清晰性。接下来的显而易见的问题是：好吧，太棒了，这听起来像是一句漂亮的格言，但你具体怎么做呢？所以我写下的这些原则是非常个人化的，是我对如何实现这一目标的看法。
(00:17:41):
我写的第一个原则是“系统而非目标”（Systems not goals）。我写这篇文章的方式之一是……我非常喜欢从科技行业以外获取灵感，所以我讲的一个故事基本上是杰里·赛恩菲尔德（Jerry Seinfeld，著名喜剧演员）的故事。如果你没看过纪录片《喜剧演员》（Comedian），它非常棒，绝对值得一看。故事是这样的：他已经做完了《赛恩菲尔德》这个节目，手里有过去 15 年积累的所有素材，有一天他进来说：“听着，我要扔掉我所有的素材，从头开始。”在喜剧界，有人扔掉所有旧素材重新开始是闻所未闻的。那么问题是，他接下来做什么？他做的事情是设定一个目标，基本上就是再次积累到一个小时的素材。
(00:18:34):
但目标并不那么重要。重要的是系统。他使用的系统是：每天早上写一个小时，如果不想写就不多写，然后晚上去表演。当你反复运行这个系统，做上几百次，他就是这样把素材从 5 分钟积累到 15 分钟再到 30 分钟的。所以我从中得到了很多启发，我认为产品人通常也可以借鉴，即：不要痴迷于目标，而要痴迷于能让你达到目标的系统。我有时会用这样一句话：只有良好意愿的目标是行不通的。我真的需要举一个常见的例子。一个非常典型的例子是那些试图了解客户或做研究的团队。我观察到的一点是，一个团队可能有一个目标，比如一个季度内与 10 个客户交谈的 OKR，他们可能达到也可能达不到这个 OKR。然后如果你仔细观察，下个季度，他们可能不再有与客户交谈的目标了。所以他们的学习过程是起伏不定的。
(00:19:49):
相比之下，这与一个拥有“默认开启”的客户沟通系统的团队完全不同。他们每周会有几次因为各种原因与客户交谈。这种影响很难察觉，直到你意识到后一个团队往往拥有非常好的产品直觉或客户直觉。这是因为他们一直保持着这种“默认开启”的与客户交谈的心态。在 Coda 的早期，我们实际上也做了类似的事情。我们在周五分配了时间，基本上是日历上写着会有客户或潜在客户过来，所以你知道这件事会发生，你必须拿出点东西给他们看。所以有时我们会在之前的三个小时里拼命赶出一个原型给客户看。有时我们会拿出已经打磨了一段时间的东西。但重点是它是“默认开启”的。因此，我们培养良好客户直觉的方式不是靠目标，而纯粹是背后的系统。这是我非常热衷的一个原则，我认为它也转化成了我们经常讨论的许多仪式。

---

### [00:21:06] Lenny

**English:**
There are so many directions I can go with this. I really like this one. It reminds me of something I did at Airbnb where we had a lunch with a host every Friday with the team and we had a community person find someone in San Francisco that's a host. And there's no agenda, it's just let's have lunch and meet the team. Curious what you're wondering.

**中文翻译:**
关于这一点，我可以从很多方向展开。我真的很喜欢这个。它让我想起我在 Airbnb 做过的一件事：我们团队每周五都会和一位房东共进午餐，我们会让社区负责人找一位在旧金山的房东。没有议程，就是一起吃个午饭，见见团队。我很想知道你是怎么想的。

---

### [00:21:22] Lane Shackleton

**English:**
Exactly.

**中文翻译:**
没错。

---

### [00:21:22] Lenny

**English:**
And Airbnb hosts are always so nice and has such a pleasant experience. Also makes me think about this book, The Score Takes Care of Itself.

**中文翻译:**
Airbnb 的房东总是那么友善，体验非常愉快。这也让我想起了《比分自会揭晓》（The Score Takes Care of Itself）这本书。

---

### [00:21:30] Lane Shackleton

**English:**
Yep.

**中文翻译:**
是的。

---

### [00:21:31] Lenny

**English:**
Have you read that?

**中文翻译:**
你读过吗？

---

### [00:21:31] Lane Shackleton

**English:**
Yeah.

**中文翻译:**
读过。

---

### [00:21:31] Lenny

**English:**
Where it's just do the fundamentals and you'll win?

**中文翻译:**
书里说只要做好基本功，你就会赢？

---

### [00:21:34] Lane Shackleton

**English:**
Totally.

**中文翻译:**
完全正确。

---

### [00:21:34] Lenny

**English:**
The other thing it reminds me of is I have this quote hanging in my office here. I Believe it's from the Rick Rubin book. And the quote is, "The object isn't to make art, it's to be in that wonderful state which makes art inevitable."

**中文翻译:**
另一件让我想起的事是，我办公室里挂着这样一句话。我相信它是出自 Rick Rubin 的那本书。这句话是：“目的不是为了创作艺术，而是为了进入那种让艺术变得不可避免的奇妙状态。”

---

### [00:21:48] Lane Shackleton

**English:**
I love it.

**中文翻译:**
我太喜欢这句话了。

---

### [00:21:49] Lenny

**English:**
I feel like you just changed art-

**中文翻译:**
我觉得你刚才把“艺术”换成了——

---

### [00:21:51] Lane Shackleton

**English:**
Yeah. Rick Rubin's amazing.

**中文翻译:**
是的。Rick Rubin 太了不起了。

---

### [00:21:52] Lenny

**English:**
Oh my god, it's so good. Just every section is this quotable thing I want ... I need to hold onto this thing.

**中文翻译:**
噢天呐，那本书太棒了。每一节都是这种我想引用的金句……我得好好留着它。

---

### [00:21:58] Lane Shackleton

**English:**
Yeah. He's got a great thing on listening. I really admire what he says about listening and I think that a lot of PMs could take that lesson, which is-

**中文翻译:**
是的。他关于倾听有一段很棒的论述。我非常钦佩他关于倾听的见解，我认为很多 PM 都可以吸取这个教训，那就是——

---

### [00:22:10] Lenny

**English:**
Yeah. What is that lesson?

**中文翻译:**
是的，那个教训是什么？

---

### [00:22:11] Lane Shackleton

**English:**
The way he talks about it is essentially you want to listen and absorb every fragment of what that person is saying, including their body language and everything else, and try to turn off the side which is crafting your response or figuring out what you're going to say next or what the problem with their argument is or whatever. It's quite hard to do. Because your default mode is always the next step of the conversation. But I think if you can really challenge yourself, like he says, to pause and really try to internalize holistically what that person's saying, it's pretty powerful.

**中文翻译:**
他谈论它的方式本质上是：你想倾听并吸收那个人所说的每一个片段，包括他们的肢体语言和其他一切，并尝试关掉大脑中正在构思回应、思考下一步该说什么、或者寻找对方论点漏洞的那一部分。这很难做到。因为你的默认模式总是对话的下一步。但我认为，如果你能像他所说的那样真正挑战自己，停下来，尝试从整体上内化那个人所说的话，那将是非常强大的。

---

### [00:22:55] Lenny

**English:**
I was actually just reading that chapter and the next chapter is about this idea of the beginner's mind. I don't know if you remember that. I feel like people get sniped by Rick Rubin stuff. But anyway, I'm going to go down this thread. He talks about how AlphaZero or AlphaGo, the first AI thing that beat humans at Go and how there was this move it made, move 37 in the game that was just like ... The person the AI was playing walked out of the room. He's like, "I don't even know what just happened. This is out of anything I've ever imagined." And it won. And the lesson there it was trained not on what we've learned, but it trained itself and figured things out from first principles and then came up with this thing we've never even comprehended. And so it's a really good example of the power of coming from a beginner's mind and not being influenced by what's already been done.

**中文翻译:**
我刚才正好在读那一章，下一章是关于“初心”（Beginner's mind）这个概念。我不知道你是否记得。我觉得人们很容易被 Rick Rubin 的东西吸引。不管怎样，我想沿着这个思路说下去。他谈到了 AlphaZero 或 AlphaGo，就是那个第一个在围棋上击败人类的 AI，以及它在比赛中下出的第 37 手棋，那简直是……和 AI 对弈的人直接走出了房间。他心想：“我甚至不知道刚才发生了什么。这超出了我所有的想象。”结果它赢了。其中的教训是，它不是根据我们学到的东西训练的，而是自我训练，从第一性原理出发去摸索，然后想出了我们从未理解过的东西。所以这是一个很好的例子，展示了保持初心、不被既有经验影响的力量。

---

### [00:23:41] Lane Shackleton

**English:**
Yeah. We have a walkthrough ritual that we do.

**中文翻译:**
是的。我们有一个“走查”（Walkthrough）仪式。

---

### [00:23:45] Lenny

**English:**
Tell me more.

**中文翻译:**
多跟我说说。

---

### [00:23:46] Lane Shackleton

**English:**
The prompt is essentially put yourself in the shoes of someone who knows nothing about this topic whatsoever and have beginner's mind and then walk through with five or 10 people watching you and let's fix all the problems that we see.

**中文翻译:**
提示语本质上是：把自己想象成一个对这个话题一无所知的人，保持初心，然后在 5 到 10 个人的注视下进行走查，让我们修复所有发现的问题。

---

### [00:24:05] Lenny

**English:**
Okay. I want to talk about rituals. We're getting ahead of ourselves a little bit. Is there any other principles that you can share either just on a high level or in depth that you can share? And I know people can go to your Substack and read this. And by the way, what's your Substack URL for people that want to check it out?

**中文翻译:**
好的。我想聊聊仪式。我们有点超前了。还有其他原则可以分享吗？无论是高层面的还是深入的。我知道人们可以去你的 Substack 阅读。顺便问一下，你的 Substack 网址是什么，方便想看的人去查阅？

---

### [00:24:21] Lane Shackleton

**English:**
Just lane.substack.com.

**中文翻译:**
就是 lane.substack.com。

---

### [00:24:24] Lenny

**English:**
Sweet. We'll definitely link into it. Yeah. Any other principles?

**中文翻译:**
太棒了。我们一定会放上链接。好的，还有其他原则吗？

---

### [00:24:28] Lane Shackleton

**English:**
I think the other one is cathedrals, not bricks, and then the other one is proactive, not reactive. Cathedrals, not bricks I think is a classic one. I think I had a moment of realization and talking to Shishir in a one-on-one when I was at YouTube bemoaning the fact that my team wasn't performing to the potential that I thought they had. And he had a very pointed and unexpected question, which is like, "Do they know their cathedral? Do they have a cathedral?" And I'm sitting there like, "Man, what are you talking about? We're talking about performing as a team and you're asking me about cathedrals." And then he explained the cathedral story, which I can talk about. In that-

**中文翻译:**
我认为另一个原则是“大教堂而非砖块”（Cathedrals, not bricks），还有一个是“主动而非被动”（Proactive, not reactive）。“大教堂而非砖块”我认为是一个经典的原则。我记得我在 YouTube 时，有一次在和 Shishir（Coda CEO）进行 1 对 1 面谈时，我正抱怨我的团队没有发挥出我认为他们应有的潜力。他问了一个非常尖锐且出人意料的问题：“他们知道他们的大教堂是什么吗？他们有大教堂吗？”我坐在那儿心想：“伙计，你在说什么呢？我们在谈论团队表现，你却问我大教堂。”然后他解释了大教堂的故事，我可以讲讲。在那——

---

### [00:25:11] Lenny

**English:**
What's the cathedral story?

**中文翻译:**
大教堂的故事是什么？

---

### [00:25:11] Lane Shackleton

**English:**
It was quite clarifying.

**中文翻译:**
它非常具有启发性。

---

### [00:25:13] Lenny

**English:**
Yeah. Do share.

**中文翻译:**
是的，请分享。

---

### [00:25:14] Lane Shackleton

**English:**
Yeah. The cathedral story is basically you walk up to three people, they're laying bricks. You ask the first person, "What are you doing?" They say, "Well, I take the bricks from over here and I put them on that sack over there." You ask the second person, "What are you doing?" They say, "Well, I take this little cement and I put it on top of the brick that that person lays." You ask the third person, "What are you doing?" And they say, "Well, we're building a cathedral." And the core insight here is that you want your teams to feel like they're building a cathedral and not laying bricks. And I think it's really, really easy to do when PMs are really busy on a day-to-day to just be one task after the other, really execution oriented and maybe not take the time to help the team take a broader frame, open the aperture a little bit and have a view of what the cathedral is. And I think we've learned many times that one unexpected bit of this is that everybody needs to see a different facet of the cathedral.
(00:26:22):
So very often ... And I've made this mistake before plenty of times. Very often people will do a great writeup on vision or strategy or whatever it is and the result is people can't quite see their version of what this broader arc is or this broader cathedral is. And so one of the things that we have tried to do when we go through big planning cycles is show all the different sides of this. So instead of just having a writeup, we may have a writeup, we may couple that with a metric, we may couple that with directional mocks and what the billboard might look like or how our homepage may change. And really what we're trying to do is take the mystery out of the set of broader constraints or where we're headed. I think great product teams and great PM leaders tend to always orient their teams towards a broader cathedral as opposed to laying bricks.

**中文翻译:**
好的。大教堂的故事基本上是：你走向三个正在砌砖的人。你问第一个人：“你在做什么？”他们说：“哦，我把这边的砖搬到那边的麻袋上。”你问第二个人：“你在做什么？”他们说：“哦，我把这些水泥抹在那个人的砖上。”你问第三个人：“你在做什么？”他们说：“我们在建造一座大教堂。”核心见解是，你希望你的团队觉得他们是在建造一座大教堂，而不是在砌砖。我认为当 PM 每天忙于一个接一个的任务、非常注重执行时，很容易忽略这一点，可能没有花时间帮助团队建立更宏大的框架，稍微打开视野，看看大教堂的全貌。而且我们多次学到，这一点中有一个意想不到的地方：每个人都需要看到大教堂的不同侧面。
(00:26:22):
所以经常会出现这种情况……我也犯过很多次这样的错误。通常人们会写出一篇关于愿景、战略或什么的精彩文档，但结果是人们无法完全看到他们版本的宏大蓝图或宏大大教堂。因此，在进行大型规划周期时，我们尝试做的一件事是展示这件事的所有不同侧面。所以除了文档之外，我们可能还会配合一个指标，配合一些方向性的原型图（Mocks），或者展示广告牌可能长什么样，或者我们的主页会如何变化。我们真正想做的是消除宏观约束或前进方向的神秘感。我认为优秀的产品团队和优秀的 PM 领导者往往总是引导他们的团队面向宏大的大教堂，而不是仅仅砌砖。

---

### [00:27:26] Lenny

**English:**
Such a beautiful metaphor. Reminds me of this other quote I just looked up while you're chatting. "If you want to build a ship, don't drum up the men to gather wood, divide the work and give orders. Instead teach them to yearn for the vast and endless sea."

**中文翻译:**
多么优美的比喻。让我想起了你聊天时我刚查到的另一句话：“如果你想造一艘船，不要招揽人手去收集木材，也不要给他们分配工作和下达命令。相反，要教会他们向往浩瀚无垠的大海。”

---

### [00:27:39] Lane Shackleton

**English:**
Classic. Classic. It's Antoine.

**中文翻译:**
经典。太经典了。是安托万（圣埃克苏佩里）说的。

---

### [00:27:42] Lenny

**English:**
That is right. Antoine de St. Exupery. Okay. Something I was curious about as you were chatting also is for folks that want to develop their own principles and define how they want to think about products, is there anything you found to be useful in helping emerge these into principles that you can come to? Is it just sitting around thinking? Is there anything else you've done that has helped you define these things?

**中文翻译:**
没错。安托万·德·圣埃克苏佩里。好的。在你聊天时我也很好奇，对于那些想要建立自己的原则并定义自己产品思维的人来说，你觉得有什么方法能有效地帮助这些想法浮现并形成原则吗？只是坐在那儿思考吗？还有什么其他事情是你做过并帮助你定义这些原则的吗？

---

### [00:28:06] Lane Shackleton

**English:**
Probably two things. One is reading really broadly. So I think not just reading PM style literature. Like I said, I tend to get a lot of inspiration from outside of tech. I think that's one thing. I think the other thing is insofar as you get the opportunity to mentor other people, think about what you're saying to these people. Think about, okay, this person came to me with this challenge. What was my response? Why was that my response? Am I giving that response a lot of times? Okay, maybe this is a more deeply held belief. So I think noticing those instances was helpful for me.

**中文翻译:**
大概有两点。一是广泛阅读。我认为不应该只读 PM 类的文献。就像我说的，我倾向于从科技行业以外获取很多灵感。这是其一。其二，只要你有机会指导别人，就去思考你对这些人说了什么。思考一下：这个人带着这个挑战来找我，我的回应是什么？为什么我会这样回应？我是不是多次给出这样的回应？如果是，那这可能是一个更深层的信念。所以我认为注意到这些瞬间对我很有帮助。

---

### [00:28:46] Lenny

**English:**
Are there any books or topics or areas that you found most inspirational when you talk about reading and studying other non-product tech?

**中文翻译:**
当你谈到阅读和研究非产品科技领域时，有没有哪些书、主题或领域是你觉得最有启发性的？

---

### [00:28:53] Lane Shackleton

**English:**
I mean definitely sports. I would say sports is really interesting to me. Team sports. I've always been a huge fan of everything team sports. Storytelling. Go look at some of the best storytellers in the world and they're actually out there on a stage telling stories. There's a book called Storyworthy that I really like.

**中文翻译:**
我是说，绝对有体育。我会说体育对我来说非常有趣。团队运动，我一直是所有团队运动的超级粉丝。还有讲故事。去看看世界上一些最好的讲故事的人，他们实际上是在舞台上讲故事。有一本叫《讲故事的艺术》（Storyworthy）的书，我非常喜欢。

---

### [00:29:15] Lenny

**English:**
I was just going to mention that. That book is so good. Somebody mentioned this on the podcast and I read it. It's the most useful practical book for how to tell stories.

**中文翻译:**
我正想提那本书呢。那本书太棒了。有人在播客里提到过，我就读了。它是关于如何讲故事的最有用、最实用的书。

---

### [00:29:23] Lane Shackleton

**English:**
It's so good. The insight is amazing. Just in case your listeners are interested, the insight is basically the nugget of a great story is five seconds of transformation. So if you just orient everything else around that moment of transformation, then you end up usually telling a reasonably good story. I had a conversation with the author right after I read that book because I was just totally enamored with it. And then we ended up bringing him into Coda and he gave a great talk. So yeah, big plug for Matthew Dicks.

**中文翻译:**
它太棒了。其中的见解非常惊人。万一你的听众感兴趣，这个见解基本上是：一个伟大故事的核心是“五秒钟的转变”。所以如果你把其他所有事情都围绕那个转变时刻展开，你通常就能讲出一个相当不错的故事。读完那本书后，我立刻和作者聊了聊，因为我完全被迷住了。后来我们把他请到了 Coda，他做了一场精彩的演讲。所以，强烈推荐 Matthew Dicks。

---

### [00:29:58] Lenny

**English:**
The other thing that stuck with me also from that same ... We're just going on all kinds of tangents. From that same insight is, and I watch movies completely differently now, where basically the characters you meet at the beginning of the story, they're going to be completely opposite at the end of the story because of this transformation that takes place. So I'm watching movies with my wife now, I'm like, "Okay, she's very shy right now. She's going to be very extroverted by the end of this movie." Or, "They love each other. Oh, they're going to have a lot of problems." That's so interesting. Oh, that's such a good idea. Okay, I'm going to get this guy on hopefully. And he's a Moth champion basically.

**中文翻译:**
另一件让我印象深刻的事也来自同一个……我们聊得太远了。来自同一个见解的是，我现在看电影的方式完全不同了：基本上你在故事开头遇到的角色，到故事结尾会变得完全相反，因为发生了这种转变。所以我现在和妻子看电影时会说：“好，她现在很害羞，到电影结束时她会变得非常外向。”或者“他们现在相爱，哦，他们会有很多问题。”这太有趣了。噢，真是个好主意。好，我希望能请到这家伙。他基本上是 Moth（著名讲故事比赛）的冠军。

---

### [00:30:30] Lane Shackleton

**English:**
Yeah. I would say as maybe a principal version of this, the way that you learn or the way that everyone including me learns new things is you go seek out the best at that given craft. So in this case, you go to the Moth StorySLAM you see some really good stories. If you ever watch these on YouTube. And then you just unpack what they're doing and how they're doing it. And then obviously I think the other way to learn quickly is to throw yourself in the deep end. So insofar as you can put yourself in situations that are uncomfortable or force you to do things like tell a story or force you to come up with a clear strategy, you should always opt into those, especially early in your career.

**中文翻译:**
是的。我想说，作为这方面的一个原则版本，你学习的方式，或者包括我在内的每个人学习新事物的方式，就是去寻找那个领域最顶尖的人。在这个例子中，你去 Moth StorySLAM 听一些非常棒的故事。如果你在 YouTube 上看过这些。然后你去拆解他们在做什么，以及他们是怎么做的。显然，我认为另一种快速学习的方法是把自己扔进深水区。所以，只要你能把自己置于不舒服的境地，或者强迫你去做讲故事、制定清晰战略之类的事情，你都应该选择参与，尤其是在职业生涯早期。

---

### [00:31:18] Lenny

**English:**
The first thing you said, that's basically the whole premise of this podcast. Find the best at all these things and learn from them, extract and share.

**中文翻译:**
你说的第一点，基本上就是这个播客的全部前提：找到所有这些领域最优秀的人，向他们学习，提取并分享。

---

### [00:31:18] Lane Shackleton

**English:**
And the world is much better for it. This podcast is an amazing resource.

**中文翻译:**
世界因此变得更美好。这个播客是一个了不起的资源。

---

### [00:31:29] Lenny

**English:**
Thanks man.

**中文翻译:**
谢谢，伙计。

---

### [00:31:29] Lane Shackleton

**English:**
You've done something very special.

**中文翻译:**
你做了一件非常特别的事情。

---

### [00:31:31] Lenny

**English:**
I appreciate it. This podcast episode is already very special. The point you just made reminds me of something that I heard you talk about, which is this oh shit moment. I don't know if it's related to what you shared of just giving people a sense of whether they're making progress in your career. Can you talk about that?

**中文翻译:**
过奖了。这期播客已经非常特别了。你刚才提到的那一点让我想起我听你谈论过的一件事，就是那个“天呐”（oh shit）时刻。我不知道这是否与你分享的关于让人们感知自己职业生涯是否在进步有关。你能谈谈那个吗？

---

### [00:31:49] Lane Shackleton

**English:**
Sure. Yeah. I think I picked this up originally from Seth Godin, the author, and it just totally stuck with me. The basic thesis is that moments that stretch you or moments that you feel uncomfortable in or you find yourself saying, "Oh shit, I shouldn't be here," or, "I'm under qualified to be here," those are the moments you should be seeking out. Those are the moments that stretch you and give you a new foundation. And so I have found that they turn out to be a pretty good way to calibrate whether someone is growing in their career. So oftentimes you'll hear a career question like, "Hey, do you feel like you're growing in your role?" And that's a very ambiguous in my opinion way to ask this question. And a much sharper way is like, "Hey, how many, oh shit moments have you had in the last six months, year, two years, and what are they?" I think if you ask yourself that question and the answer is, "It's been a really long time since I've been stretched in some meaningful way or I've felt like I'm under qualified to be there," then it may be worth digging into.

**中文翻译:**
当然。是的。我想我最初是从作家 Seth Godin 那里学到这一点的，它深深地印在了我的脑海里。基本论点是：那些让你感到挑战、让你觉得不舒服，或者让你不由自主地说出“天呐，我不该在这儿”或“我资历不够，不配在这儿”的时刻，正是你应该去寻找的时刻。这些时刻能磨练你，并为你打下新的基础。所以我发现，这些时刻最终成为了衡量一个人在职业生涯中是否在成长的很好方式。所以，你经常会听到关于职业生涯的问题，比如：“嘿，你觉得你在现在的职位上有成长吗？”在我看来，这种问法非常模糊。一个更犀利的方式是问：“嘿，在过去的六个月、一年或两年里，你有过多少次‘天呐’时刻？它们分别是什么？”我觉得如果你问自己这个问题，而答案是“我已经很久没有在任何有意义的方面受到挑战，或者很久没有那种‘我资历不足以胜任’的感觉了”，那么这可能值得你深入思考一下。

---

### [00:33:04] Lenny

**English:**
That is so good. Making me think about this podcast where I never wanted to do podcasts. I'm like I'm not a podcast person. I just want to sit there and type out newsletters. How cool is that? And I'm like, no, I got to do it because it's hard. And I'm glad I did it. It also reminds me of this quote that I love that I always think back to. "The cave you fear contains the treasure you seek."

**中文翻译:**
太棒了。这让我想到了这个播客，我以前从未想过要做播客。我想我不是那种做播客的人，我只想坐在那儿写时事通讯（Newsletters），那多酷啊。但我又想，不，我得做，因为这很难。我很庆幸我做了。这也让我想起了我非常喜欢并经常回想起的一句话：“你所恐惧的山洞里，藏着你所寻找的宝藏。”

---

### [00:33:26] Lane Shackleton

**English:**
Nice. That reminds me of ... Have you read the book The Obstacle is the Way?

**中文翻译:**
漂亮。这让我想起了……你读过《障碍就是道路》（The Obstacle is the Way）这本书吗？

---

### [00:33:26] Lenny

**English:**
No. Say More.

**中文翻译:**
没读过，多讲讲。

---

### [00:33:33] Lane Shackleton

**English:**
It's a great book by Ryan Holiday. And the core thesis is ... It's a bit about stoicism. But the core idea is essentially instead of running away from obstacles, you should be running toward them and that's where you experience either the most growth or the most profound moments of your life. He gives a lot of examples in that book of people throughout history who made that choice. And I think he's also given that talk to hundreds of sports teams. It's a good book. Worth reading.

**中文翻译:**
那是 Ryan Holiday 写的一本很棒的书。核心论点是……它有点关于斯多葛学派（Stoicism）。但核心思想本质上是：你不应该逃避障碍，而应该奔向它们，因为那是你经历人生最大成长或最深刻时刻的地方。他在书中举了很多历史上做出这种选择的人的例子。我想他也向数百支体育队伍做过相关的演讲。这是一本好书，值得一读。

---

### [00:34:08] Lenny

**English:**
It's so hard. It's so hard to do hard things, man. So we've been talking about principles of great product managers. You also spent a lot of time looking at the rituals of great product teams. And I know you're working on this handbook that I'm excited to learn more about. Can you just talk about ... I guess one, where this idea came from of studying rituals of great teams and also just how do you actually go about learning about these rituals? I know you have this really interesting process.

**中文翻译:**
太难了。做困难的事情真的太难了，伙计。我们一直在讨论优秀产品经理的原则。你也花了很多时间研究优秀产品团队的仪式。我知道你正在编写一本手册，我很想了解更多。你能谈谈……我想知道，研究优秀团队仪式的想法是从哪里来的？以及你实际上是如何去了解这些仪式的？我知道你有一个非常有趣的过程。

---

### [00:34:31] Lane Shackleton

**English:**
Yeah. In general, I'm a big believer in good design and good product starts with noticing. Tony Fadell has a great talk on this. So I think a bunch of us that are really obsessed with rituals, we just honestly try to be great at noticing. So see something happening with a customer, ask a few questions, get introduced to their team, hear about something interesting from a non-customer, ask for an intro, end up just probing and asking a lot of questions. And then in many cases nowadays with Coda, we're building new rituals alongside people. So someone has a creative idea about how to implement something and we're like partners or collaborators with them on that, which is honestly incredibly fun to just see people's creativity expressed in a tool and then by extension the social construct that they exist in. So that's a little bit about how we got started in that whole process. And then of course Shishir is writing a book called Rituals of Great Teams so we've been cataloging those. We've been hosting a bunch of rituals dinners where we basically get people together for a dinner and we usually have three or four presenters at those dinners. It's just a great chance to learn and think about how the engine runs in a lot of these companies.

**中文翻译:**
是的。总的来说，我坚信好的设计和好的产品始于“察觉”（Noticing）。Tony Fadell（iPod 之父）对此有一个精彩的演讲。所以我们这群对仪式非常痴迷的人，真的只是在努力变得擅长察觉。比如看到客户身上发生了一些事，问几个问题，被介绍给他们的团队；或者从非客户那里听到一些有趣的事，请求引荐，最后就是不断地探究并问很多问题。现在在很多情况下，通过 Coda，我们正在与人们一起构建新的仪式。如果有人对如何实施某件事有创意，我们就会成为他们的合作伙伴或协作方，看到人们的创造力在工具中表达出来，并延伸到他们所处的社会结构中，这真的非常有意思。这就是我们开始整个过程的一点背景。当然，Shishir 正在写一本名为《伟大团队的仪式》（Rituals of Great Teams）的书，所以我们一直在对这些仪式进行分类。我们还举办了一系列“仪式晚宴”，基本上就是把人们聚在一起吃顿饭，通常会有三四个演讲者。这是一个学习和思考许多公司内部引擎如何运转的绝佳机会。

---

### [00:36:03] Lenny

**English:**
What are some rituals that you've learned from these dinners and these and this research you've done that have really stuck with me?

**中文翻译:**
在这些晚宴和你所做的研究中，有哪些让你印象深刻的仪式？

---

### [00:36:10] Lane Shackleton

**English:**
There are so many. It's hard to choose. Maybe I'll choose two that are top of mind. One is Dharmesh Shah has this ritual from HubSpot called flash tags. Have you heard of this?

**中文翻译:**
有很多，很难选。也许我会选两个我最先想到的。一个是 Dharmesh Shah 在 HubSpot 建立的一个叫“闪存标签”（Flash tags）的仪式。你听说过吗？

---

### [00:36:24] Lenny

**English:**
No.

**中文翻译:**
没有。

---

### [00:36:27] Lane Shackleton

**English:**
We've all probably been in the situation where someone gives you feedback and you either under interpret it or over interpret it. And as an organization, I think the core principle here is like you want to be calibrated on how much to pay attention to a bit of feedback. And so he outlines four flash tags. He presented this in one of our dinners. And I absolutely love the phrasing of these as someone who's given a lot of feedback on product stuff in their career. So it ranges from ... I think it's FYI, suggestion, recommendation, plea. So FYI is basically like I had a thought, take it or leave it kind of thing. Suggestion is ... And he uses this hill dying metaphor. So is this a hill I'm going to die on? And FYI is there's no hill in sight. Suggestion is there's a hill. I'm not going to die on it but this is what I would do if I were you. You can take it or leave it. Recommendation is I'm climbing the hill. I'm not going to die here, but I've thought about this a lot, so don't ignore this.
(00:37:41):
And then the fourth one, plea, is hopefully rarely used in the organization. It's like, I don't like dying on hills. That's not what we do here. But this is a pretty good candidate for it. You should really trust me. And so we have ended up using that. I was actually just at an offsite and someone gave a lightning talk to our team on how valuable this has been just to calibrate, hey, we got 100 pieces of feedback and there's one plea. Okay, let's spend our time on that. Or there's a whole bunch of FYIs. I think we're fine. Let's keep going. No worries.

**中文翻译:**
我们可能都遇到过这种情况：有人给你反馈，你不是理解不足就是过度解读。作为一个组织，我认为这里的核心原则是：你希望在关注某条反馈的程度上保持校准。所以他列出了四个“闪存标签”。他在我们的一次晚宴上介绍了这个。作为一个在职业生涯中给出过很多产品反馈的人，我非常喜欢这些措辞。它们分别是……我想是：仅供参考（FYI）、建议（Suggestion）、推荐（Recommendation）、恳求（Plea）。“仅供参考”基本上就是：我有个想法，你听听就行，不用太在意。“建议”是……他用了一个“死在山头上”的比喻。也就是说，这是我愿意为之拼命（死在上面）的山头吗？“仅供参考”意味着视线里根本没有山头。“建议”意味着有一座山，我不会死在上面，但如果我是你，我会这么做。你可以采纳也可以不采纳。“推荐”意味着我正在爬这座山。我不会死在这里，但我对此思考了很多，所以不要忽视它。
(00:37:41):
第四个，“恳求”，希望在组织中很少用到。它就像是：我不喜欢死在山头上，这不是我们的风格。但这件事是一个很好的候选，你真的应该相信我。所以我们最终也采用了这个。实际上我刚参加完一个团建（Offsite），有人向我们团队做了一个闪电演讲，讲了这个方法在校准方面的价值：嘿，我们收到了 100 条反馈，其中有一条是“恳求”。好，让我们把时间花在那上面。或者有一大堆“仅供参考”，那我觉得没问题，继续吧，不用担心。

---

### [00:38:20] Lenny

**English:**
That's amazing. It's interesting none of them are just do it this way. I imagine that's very intentional.

**中文翻译:**
太棒了。有趣的是，没有一个是“就按这个做”。我猜那是刻意为之。

---

### [00:38:25] Lane Shackleton

**English:**
Yeah. Honestly it's a sign of ... In Dharmesh's case, I don't know him super well, but it's a sign of a really experienced leader to know that scale. But every time I look at the scale and I'm weighing where I am between suggestion or recommendation, I have to giggle to myself.

**中文翻译:**
是的。老实说，这是一种标志……就 Dharmesh 而言，我不太了解他，但能定出这个尺度是一个非常有经验的领导者的标志。但每次我看着这个尺度，权衡自己是处于“建议”还是“推荐”之间时，我都会忍不住偷笑。

---

### [00:38:45] Lenny

**English:**
And how do you actually use it? In the feedback you put a hashtag plea kind of thing?

**中文翻译:**
那你们具体是怎么用的？在反馈里加一个 #恳求 之类的标签吗？

---

### [00:38:51] Lane Shackleton

**English:**
The way gets used in code docs and the way I think other companies have made it a ritual is you'll have a feedback table and you'll write your feedback and then there'll just be a little select list and you can select between those four. And usually what people do is they include the description so you can as you're choosing it, think do I really feel that strongly about this? And honestly, it's good hygiene. Otherwise, every bit of feedback is taken the same. Which just fundamentally the impact of that is it slows everything down because now you're looking at a list of 100 pieces of feedback and you're going like, "Oh man, we got to address all this feedback." Whereas as soon as you distinguish between what's most important, it's much easier to sort through that.

**中文翻译:**
在 Coda 文档中的用法，以及我认为其他公司将其作为仪式的方式是：你会有一个反馈表，你写下你的反馈，然后会有一个下拉选择列表，你可以从这四个选项中选择。通常人们会附带描述，这样你在选择时可以思考：我真的对这件事有那么强烈的感觉吗？老实说，这是一种良好的习惯。否则，每一条反馈都会被同等对待。这从根本上会导致一切变慢，因为你现在看着 100 条反馈的清单，心想：“噢天呐，我们得处理所有这些反馈。”而一旦你区分出什么是最重要的，筛选起来就容易得多。

---

### [00:39:46] Lenny

**English:**
What about if it's in person? Do you say this is a plea or this is a FYI?

**中文翻译:**
如果是面对面呢？你会说“这是一个恳求”或者“这只是个 FYI”吗？

---

### [00:39:50] Lane Shackleton

**English:**
Oh, I've definitely heard that in many meetings. Are you making a recommendation or are you making a plea?

**中文翻译:**
噢，我在很多会议上都听过。你会问：“你是在提出推荐，还是在提出恳求？”

---

### [00:39:57] Lenny

**English:**
Amazing.

**中文翻译:**
太棒了。

---

### [00:39:58] Lane Shackleton

**English:**
And making the person think through that choice I think is just a very helpful shared language.

**中文翻译:**
让对方思考那个选择，我认为这是一种非常有用的共同语言。

---

### [00:40:04] Lenny

**English:**
I imagine one of the other benefits of this is I think most leaders that rise up the ranks eventually realize anything they say in a meeting is going to be taken really seriously and the team's going to rush back and be like, "Oh, Lane told us to change this thing." I imagine it helps you just make it clear. No, you don't need to actually change this. It's just my thoughts.

**中文翻译:**
我想这还有另一个好处：大多数晋升上来的领导者最终都会意识到，他们在会议上说的任何话都会被非常严肃地对待，团队会冲回去说：“噢，Lane 让我们改这个东西。”我想这能帮你明确表达：不，你不需要真的改这个，这只是我的想法。

---

### [00:40:21] Lane Shackleton

**English:**
Yeah. Exactly. Yeah.

**中文翻译:**
是的，没错。

---

### [00:40:22] Lenny (Sponsor Message)

**English:**
This episode is brought to you by Ezra, the leading full body cancer screening company. I actually used Ezra earlier this year unrelated to this podcast, completely on my own dime because my wife did one and loved it and I was super curious to see if there's anything that I should be paying attention to in my body as I get older. The way it works is you book an appointment, you come in, you put on some very cool silky pajamas that they give you that you get to keep afterwards. You go into an MRI machine for 30 to 45 minutes, and then about a week later you get this detailed report sharing what they found in your body. Luckily, I had what they called an unremarkable screening, which means they didn't find anything cancerous, but they did find some issues in my back, which I'm getting checked out at a physical next month. Probably because I spend so much time sitting in front of a computer. Half of all men will have cancer at some point in their lives, as will one third of women. Half of all of them will detect it late.
(00:41:21):
According to the American Cancer Society, early cancer detection has an 80% survival rate compared to less than 20% for late stage cancer. The Ezra team has helped 13% of their customers identify potential cancer early, and 50% of them identify other clinically significant issues such as aneurysms, disc herniations, which may be what I have, or fatty liver disease. Ezra scans for cancer and 500 other conditions in 13 organs using a full body MRI powered by AI and just launched the world's only 30-minute full body scan, which is also their most affordable. Their scans are non-invasive and radiation free. And Ezra is offering listeners $150 off their first scan with code Lenny150. Book your scan at ezra.com/lenny at E-Z-R-A.com/lenny.

**中文翻译:**
本期节目由 Ezra 赞助，它是领先的全身癌症筛查公司。实际上，我在今年早些时候就使用过 Ezra，与这个播客无关，完全是自费的，因为我妻子做了一次并且非常满意，我也非常好奇随着年龄增长，我的身体里是否有什么需要注意的地方。它的运作方式是：你预约一个时间，过去，穿上他们提供的非常酷的丝绸睡衣（之后你可以带走）。你在核磁共振（MRI）机器里待 30 到 45 分钟，大约一周后，你会收到一份详细的报告，分享他们在你体内发现的情况。幸运的是，我得到的是所谓的“无异常筛查”，这意味着他们没有发现任何癌症迹象，但他们确实发现了我背部的一些问题，我下个月体检时会去检查一下。可能是因为我花了太多时间坐在电脑前。一半的男性在生命中的某个阶段会患上癌症，女性的比例是三分之一。其中一半的人发现时已是晚期。
(00:41:21):
根据美国癌症协会的数据，早期癌症检测的存活率为 80%，而晚期癌症不到 20%。Ezra 团队已帮助 13% 的客户及早识别潜在癌症，50% 的客户识别出其他具有临床意义的问题，如动脉瘤、椎间盘突出（可能就是我的问题）或脂肪肝。Ezra 使用由 AI 驱动的全身 MRI 扫描 13 个器官中的癌症和其他 500 种疾病，并刚刚推出了世界上唯一的 30 分钟全身扫描，这也是他们最实惠的项目。他们的扫描是非侵入性且无辐射的。Ezra 为听众提供首单扫描 150 美元的优惠，优惠码为 Lenny150。请在 ezra.com/lenny（即 E-Z-R-A.com/lenny）预约你的扫描。

---

### [00:42:15] Lenny

**English:**
Any other rituals that stand out as really interesting, either more recently you've learned or something you're just like, oh, wow, that was a genius?

**中文翻译:**
还有其他让你觉得非常有趣的仪式吗？无论是最近学到的，还是让你觉得“噢，哇，这真是天才之举”的？

---

### [00:42:21] Lane Shackleton

**English:**
I guess one that I get asked about a lot on our team is called Catalyst. And I guess maybe to set some context on this one, in most product teams, the review forum is just a really important part of the product development process. And the core insight for most review forums or product reviews or decision forums is that they generally suffer from two problems that are hard to spot unless you've sat through hundreds of them. The first is they have standing attendees, and the second is they're normally single-threaded, meaning they're normally one topic at a time. So maybe I'll talk about both of those because I think they're not exactly intuitive. So when you think about what happens with a standing set of attendees, you either have the situation where you have too many people in the meeting or you have not enough people in the meeting, and both of those can cause problems.
(00:43:25):
So if you've ever been in a meeting, I certainly have, where it's like, "Hey, do we have the salesperson who knows most about this or do we have the engineer who's actually implementing this here? Oh, great. They're not here? They're not a part of the standing set of attendees?" You either have to reschedule the meeting or worse, you just do the discussion without the person who's most knowledgeable, which seems crazy in retrospect. The second problem is single-threaded. So one topic at a time. So if you think about if a product development process is somewhat of a chaotic assembly line for a second, your review or your decision forum ends up being a big time bottleneck in many cases. And obviously you want to be in a situation where product people have a lot of autonomy and they can make most of the decisions themselves. And I'm a big believer in decentralized leadership and all of that, but there are things that cut across the company that need to get reviewed by a broader set of stakeholders.
(00:44:29):
And so what happens when those things are single threaded is either the meeting is really long, so it's a three-hour review meeting once a week, and by the end everyone is about to fall asleep, or it's really short and it's really hard to get on the calendar. You're like, "Oh, can we get on the calendar in two weeks?" And the downside of the not being able to get on the calendar is that now you've just slowed down the whole velocity of the company because the throughput of your review meeting is really slow. So we built Catalyst to really solve those two problems. And so the way it works is it's essentially three one hour blocks throughout the week, and the assumption is that the whole company is free. So you can get anyone in the company for those three hours. And each topic has essentially four roles. Driver, maker, braintrust, and interested. It's a very transparent system.
(00:45:28):
So a salesperson can say, "Oh, I'm interested in this product development review. I'm just going to mark myself as interested." And then the driver is the person who's actually going to drive the meeting, drive the decision, drive the outcome, things like that. And basically, this is all centralized in one doc. And what happens is the day before, that hold that's on calendar gets removed, and then you have specific topics that get added. So there may be three topics going all at the same time because they don't have overlapping attendees. And the impact of this, I think if you really watch it in progress is huge. You basically have many topics running all at the same time, so the throughput is much better and you have the right attendees every single time, and you have a clear set of drivers and roles in these meetings. So that means that we can review work much, much faster with the right people, and ideally that results in more value to our customers, more things getting shipped, just a higher velocity organization. So that's one that we get asked about a lot. And actually a couple of weeks ago, we spent a while remaking the template for that one.

**中文翻译:**
我想我们团队经常被问到的一个叫“催化剂”（Catalyst）。为了给这个仪式设定一些背景：在大多数产品团队中，评审论坛是产品开发过程中非常重要的一部分。大多数评审论坛、产品评审或决策论坛的核心痛点在于，它们通常存在两个问题，除非你参加过几百场，否则很难察觉。第一是它们有“固定参会者”，第二是它们通常是“单线程”的，意味着一次只能讨论一个话题。我想谈谈这两点，因为它们并不完全直观。当你考虑固定参会者会发生什么时，你要么会遇到会议人数过多的情况，要么会遇到人数不足的情况，这两者都会产生问题。
(00:43:25):
如果你曾经参加过这样的会议（我肯定参加过），会上有人问：“嘿，最了解这个情况的销售人员在吗？或者实际实施这个功能的工程师在吗？噢，太棒了，他们不在？他们不是固定参会者？”你不得不重新安排会议，或者更糟的是，在没有最了解情况的人在场的情况下进行讨论，回想起来这简直疯了。第二个问题是单线程，即一次一个话题。如果你把产品开发过程想象成一条有点混乱的流水线，那么评审或决策论坛在很多情况下最终会成为一个巨大的时间瓶颈。显然，你希望产品人员拥有很大的自主权，能够自己做出大部分决定。我非常相信去中心化领导之类的理念，但有些跨公司的事情需要更广泛的利益相关者进行评审。
(00:44:29):
当这些事情是单线程处理时，结果要么是会议变得非常长（比如每周一次三小时的评审会，到最后每个人都快睡着了），要么是会议时间非常短且很难排上号。你会说：“噢，我们能排到两周后的日程吗？”无法排上日程的负面影响是，你降低了整个公司的速度，因为评审会议的吞吐量非常低。所以我们构建了 Catalyst 来解决这两个问题。它的运作方式是：每周基本上有三个一小时的时间段，假设全公司在这段时间都是有空的。所以你可以在这三小时内请到公司里的任何人。每个话题基本上有四个角色：驱动者（Driver）、执行者（Maker）、智囊团（Braintrust）和感兴趣者（Interested）。这是一个非常透明的系统。
(00:45:28):
销售人员可以说：“噢，我对这个产品开发评审感兴趣，我就把自己标记为‘感兴趣’。”驱动者是实际推动会议、推动决策、推动结果的人。基本上，这一切都集中在一个文档中。发生的情况是，在会议前一天，日历上的预留时间会被移除，然后添加具体的话题。因此，可能会有三个话题同时进行，因为它们的参会者没有重叠。我认为如果你观察它的实际运行，影响是巨大的。你基本上有许多话题同时运行，所以吞吐量要好得多，每次都有正确的参会者，并且在这些会议中有明确的驱动者和角色。这意味着我们可以与正确的人一起更快地评审工作，理想情况下，这会为我们的客户带来更多价值，交付更多东西，从而成为一个更高效率的组织。这是我们经常被问到的一个，实际上几周前，我们还花了一段时间重新制作了那个模板。

---

### [00:46:45] Lenny

**English:**
I love that ritual. You actually wrote even in more depth in the post that we worked together on how Coda builds product, which we'll link to if folks want to try this out and you link to actual templates people can actually use it their companies. When someone's listening to this and they're like, "Oh, wow, this is extremely cool," how easy is it do you find for people to take a ritual from a company and implement it? How much is cultural and it's hard to transplant, or do you find people can take this Catalyst idea plug and play at a lot of companies?

**中文翻译:**
我喜欢那个仪式。实际上，在我们合作的那篇关于 Coda 如何构建产品的文章中，你写得更深入，如果大家想尝试，我们会放上链接，你还链接了人们可以在自己公司使用的实际模板。当有人听了这些并觉得“噢，哇，这太酷了”时，你觉得人们从一家公司借鉴一个仪式并实施它有多容易？有多少是文化层面的、难以移植的？还是说你发现人们可以将这个 Catalyst 的想法在很多公司即插即用？

---

### [00:47:15] Lane Shackleton

**English:**
Yeah. I think it depends a lot on what your role in the company is. Maybe to say the extremes for a second, if you're a brand new PM to an organization, you probably shouldn't go try to remake the whole product review cycle that the head of product is really passionate about and has crafted. But you can probably take a decision template or some interesting ritual that has facilitated a team in the past and use it with your team. Another one of my favorites there is a hundred dollar voting. We use that a lot in the context of planning, and I find that creative rituals like that are easy to pick up for teams because oftentimes it's like, okay ... And maybe I'll describe the ritual real quick.

**中文翻译:**
是的。我认为这很大程度上取决于你在公司中的角色。说得极端一点，如果你是一个刚加入组织的新 PM，你可能不应该尝试去重塑整个产品评审周期，因为那是产品负责人非常热衷并精心打造的。但你或许可以借鉴一个决策模板，或者一些过去曾帮助过团队的有趣仪式，并将其应用到你的团队中。我最喜欢的另一个仪式是“100 美元投票”。我们在规划背景下经常使用它，我发现这类创意仪式很容易被团队采纳，因为通常情况下……也许我可以快速描述一下这个仪式。

---

### [00:48:01] Lenny

**English:**
Yeah. I was going to ask.

**中文翻译:**
是的，我正想问呢。

---

### [00:48:02] Lane Shackleton

**English:**
The ritual is essentially you can take any set of problems or solutions or themes or whatever you want to get people's input on, and you put those into a table and then people can basically vote with their dollars and usually you allocate $100. And so people will go through and say, "Oh, I want to allocate $10 to this and $20 to this and $50 to this because I think it's really important." And I have found that especially in planning processes, little rituals like this are great at getting the elephant in the room out. So it's like, "Oh wow, we have a huge spread on this one particular problem. You think it's a huge problem. I don't think it's a problem at all. Let's talk about it." Going back to the thesis of turning ambiguity into clarity, a lot of this is like we're trying to get the ambiguous stuff out there so that we can make it more clear.
(00:49:03):
And so I use that as an example because you can be a brand new PM, run a brainstorm, run a planning session like that, and you're probably going to get great feedback. People are probably going to go, "This is cool. I've never done this before." Now to go to the other side of the spectrum, we help a lot of companies that want to remake a whole process. They want to remake a review system like Catalyst or they want to remake their decision rituals. And so in that sense, we're usually talking to a head of product or director of product or VP of product and someone who tends to have a lot more agency over the way that the team works.

**中文翻译:**
这个仪式本质上是：你可以拿出一组问题、解决方案、主题或任何你想征求大家意见的东西，把它们放进一个表格里，然后大家基本上可以用他们的“钱”来投票，通常你会分配 100 美元。人们会浏览并说：“噢，我想给这个分配 10 美元，给那个分配 20 美元，给这个分配 50 美元，因为我觉得它非常重要。”我发现，特别是在规划过程中，像这样的小仪式非常擅长把“房间里的大象”（显而易见却被忽视的问题）揭示出来。比如：“噢哇，我们对这一个特定问题的看法分歧巨大。你觉得这是一个大问题，我却觉得根本不是问题。让我们谈谈吧。”回到将模糊性转化为清晰性的论题，这其中的很多工作就是把模糊的东西摆出来，这样我们才能让它变得更清晰。
(00:49:03):
所以我用这个作为例子，因为即使你是一个全新的 PM，主持一场头脑风暴或规划会议，你可能也会得到很好的反馈。人们可能会说：“这很酷，我以前从未这样做过。”现在说另一端，我们帮助很多想要重塑整个流程的公司。他们想要重塑像 Catalyst 这样的评审系统，或者重塑他们的决策仪式。在这种情况下，我们通常是在与产品负责人、产品总监或产品 VP 交谈，这些人往往对团队的工作方式拥有更多的代理权（Agency）。

---

### [00:49:48] Lenny

**English:**
Coda is interesting in that it feels like you have pretty stable processes for planning and reviews. I find most companies just every six months rethink a lot of these things. I guess that's probably a sign that you found something that's really good and works and you don't have to redo it. How much are you radically changing the way you operate versus working in similar ways? How do you think about that percentage wise?

**中文翻译:**
Coda 的有趣之处在于，感觉你们在规划和评审方面有相当稳定的流程。我发现大多数公司每六个月就会重新思考很多这类事情。我想这可能是一个信号，表明你们找到了一些非常棒且有效的东西，不需要推倒重来。你们在多大程度上激进地改变运作方式，还是说大部分时间都在以类似的方式工作？从百分比来看，你怎么看？

---

### [00:50:11] Lane Shackleton

**English:**
People are always coming up with new creative ways to make their teams run better, make decisions go smoother. And we're continuously adopting those, but there's definitely a backbone of the system. The backbone of the system is Catalyst and tag-ups and the concept called Bullpen. And then there'll be a lot of iteration on top of that. And even those systems went through a lot of iteration. I talked about how the calendar hold got removed and then individual topics got added. That took us launching automations and the ability to add things to calendar in order for that whole process to really work. So in the years prior to us launching that, we did it very manually. So I think there's still a lot of creativity that I see every day.
(00:51:06):
So I'll give one quick example. One of our PM leads on core product, this guy Nathan, he basically saw that a lot of decisions had a lot of different stakeholders because he's in the core product. And now he's leading the core product team so he's trying to figure out what guidance do I give to each of these PMs on who to involve in these decisions? Because every one of these with core product feels like they impact everybody. And so a very simple thing that he did probably in the last six months was he had a table of all the upcoming decisions and then at a tag-up ... Which I can explain if you want. But basically with a small set of stakeholders, he had all the upcoming decisions and then he let people hit a little reaction and say, "Oh, I don't need to be involved. Just notify me of the decision after." Or, "Hey, I have some opinions, but you can keep going." Or, "No, I really want to be heavily involved in this decision."
(00:52:10):
And it was such a pro move. It was such a, I've been through a million of these. I don't want to treat every one of them the same because if I do, it's going to slow down the velocity of this whole organization. And so instead, the majority of those, Shishir or I or Oliver, the head of engineering will say, "I may have some opinions, but keep going." That's often the default. And then there are plenty where we say, "Just notify us of the decision after." And in doing that, Nathan can now give better guidance to the PMs on his team and say, "Hey, you don't really need to involve as wide a group as you think, so just keep going and check in later." So I think those types of little iterations are usually based on a really good insight.

**中文翻译:**
人们总是在想出新的创意方法来让团队运行得更好，让决策更顺畅。我们也在不断采纳这些方法，但系统肯定有一个骨架。系统的骨架是 Catalyst、Tag-ups（同步会）以及一个叫 Bullpen（牛棚）的概念。在此基础上会有很多迭代。甚至这些系统本身也经历了很多迭代。我提到过日历预留是如何被移除并添加具体话题的，这需要我们推出自动化功能和向日历添加内容的能力，才能让整个流程真正运转起来。所以在我们推出这些功能之前的几年里，我们是手动完成的。所以我认为我每天仍然能看到很多创造力。
(00:51:06):
我举一个简单的例子。我们核心产品的一位 PM 主管 Nathan，他发现很多决策都有很多不同的利益相关者，因为他负责核心产品。现在他领导核心产品团队，所以他试图弄清楚：我该给这些 PM 什么样的指导，告诉他们谁应该参与这些决策？因为核心产品的每一项变动感觉都会影响到所有人。所以他在过去六个月里做了一件非常简单的事：他列了一个包含所有即将做出的决策的表格，然后在一次 Tag-up 中……如果你想听我可以解释。但基本上，在只有一小群利益相关者的情况下，他展示了所有即将做出的决策，然后让大家点击一个小表情来表达：“噢，我不需要参与，事后通知我决策结果就行。”或者“嘿，我有一些意见，但你们可以继续。”或者“不，我真的想深度参与这个决策。”
(00:52:10):
这真是一个高手（Pro）的举动。这体现了“我已经经历过无数次这种事了，我不想对每一件事都一视同仁，因为如果我这样做，会降低整个组织的速度”。相反，对于大多数决策，Shishir、我或者工程负责人 Oliver 会说：“我可能有一些意见，但你们继续吧。”这通常是默认选项。还有很多时候我们会说：“事后通知我们决策结果就行。”通过这样做，Nathan 现在可以给团队里的 PM 更好的指导，说：“嘿，你真的不需要像你想象的那样涉及那么广的人群，所以继续做吧，晚点再来汇报。”所以我认为这类小迭代通常是基于非常好的洞察。

---

### [00:53:17] Lenny

**English:**
It sounds like a dream come true for a platform team to reduce how many people have to be involved in all your planning and decision making. And that process in which you call it tag-up, maybe just briefly explain it and then I want to talk about this handbook you're working on, which is going to I think, cover a lot of these things.

**中文翻译:**
对于一个平台团队来说，能减少参与规划和决策的人数简直是梦想成真。你提到的那个叫 Tag-up 的流程，能不能简单解释一下？然后我想聊聊你正在编写的那本手册，我想它会涵盖很多这类内容。

---

### [00:53:17] Lane Shackleton

**English:**
Tag-up is based on this insight that a lot of work and project work tends to get discussed in one-on-ones. And actually it's really an anti-pattern. It's a pattern you should try to avoid. So if you're talking to your manager about product work, what's not happening in that moment is your eng lead and your design lead, they're not hearing that. And so you end up with this big game of telephone where you'll have a conversation with your manager in a one-on-one, they'll go back and translate to their engineering and design lead, and of course the fidelity of the game of telephone, something is lost in all of those transmissions. And so the core idea is have a group one-on-one with the key stakeholders. And so we have this concept of braintrust that's modeled off after Pixar's braintrust.
(00:54:11):
And so we'll have a tag-up with a small set of people from a given team, or sometimes we have larger groups, and then they meet with their braintrust and it's once a week. It's the same mindset of a one-on-one. It's their time. So anything that they need to unblock a decision or to make progress, they should use that time for. And they often start by reviewing OKRs and metrics and things like that. But then we generally get into a table of topics. Anyone can add a topic. Those topics are up voted, so people will react and then the table will sort itself. And then we'll say, "Okay, this is clearly the topic on people's mind." And that's a version of what we call Dory, which I can talk about. But essentially the principle is you should discuss that project work with the whole group there. With the whole triad there. And oftentimes with the sales person there and with the marketer there and with everybody else. So I found that that is just a really good practice to try to move a lot of that work out of one-on-ones and into a small group setting.

**中文翻译:**
Tag-up 基于这样一个洞察：很多工作和项目工作往往会在 1 对 1 面谈中讨论。实际上，这是一种“反模式”（Anti-pattern），是你应该尽量避免的模式。如果你在和你的经理讨论产品工作，那么在那一刻，你的工程主管和设计主管是听不到这些的。于是你最终陷入了一场巨大的“传声筒游戏”（Game of telephone）：你在 1 对 1 中和经理交谈，他们回去后再转达给工程和设计主管，当然，在这些传递过程中，传声筒游戏的保真度会受损，信息会丢失。所以核心思想是：与关键利益相关者进行“小组 1 对 1”。我们借鉴皮克斯（Pixar）的智囊团（Braintrust）模式，提出了这个概念。
(00:54:11):
我们会让某个团队的一小群人（有时是更大的群体）与他们的智囊团进行 Tag-up，每周一次。这和 1 对 1 的心态是一样的：这是属于他们的时间。所以任何他们需要用来解除决策阻塞或取得进展的事情，都应该利用这段时间。他们通常从审查 OKR 和指标之类的事情开始。但随后我们通常会进入一个话题表。任何人都可以添加话题。这些话题会被投票，人们会点击表情，然后表格会自动排序。接着我们会说：“好，这显然是大家最关心的话题。”这是我们称之为 Dory（多莉，一种 Q&A 机制）的一个版本，我可以再细说。但本质上的原则是：你应该在整个小组都在场的情况下讨论项目工作。让整个“三位一体”（产品、工程、设计主管）都在场，通常还有销售人员、市场人员和其他所有人。所以我发现，尝试将大量此类工作从 1 对 1 中移出，转入小组环境，是一个非常好的实践。

---

### [00:55:26] Lenny

**English:**
Awesome. Okay. So you're working on a handbook that's collecting a lot of these rituals. Talk about that and then when can people maybe look for it?

**中文翻译:**
太棒了。好，你正在编写一本收集了许多这类仪式的“手册”。谈谈那个吧，人们什么时候能看到它？

---

### [00:55:36] Lane Shackleton

**English:**
One of the realizations I had the other day, probably a month or two ago when we started working on this thing, was I was talking to someone about Catalyst and a couple other concepts, and they were like, "I get it. I'm sold. I want to implement some of these things. Where do I look?" And so I found myself sending them a bunch of links to individual templates. So that cued us into the fact that we needed to have a better core handbook for teams that wanted to adopt some of these rituals and also learn from all the rituals that we have learned from and feel very fortunate to have partnered with so many customers on. And so what we did was started writing this handbook, and it's going to come out hopefully by the time this recording is done. And in it, we'll talk about everything from rituals like Catalyst to decision rituals to a lot of planning and strategy and roadmaps, that kind of stuff. And trying to pull out the most interesting patterns and also give people a pretty practical view of how to implement these things. I think that's what has been lacking sometimes.

**中文翻译:**
前几天，大概是一两个月前我们开始做这件事时，我意识到了一点：当时我正和某人谈论 Catalyst 和其他几个概念，他们说：“我明白了，我被说服了，我想实施其中一些东西。我该去哪儿看？”结果我发现自己给他们发了一堆指向单个模板的链接。这提醒了我们：我们需要为那些想要采用这些仪式、并从我们所学到的仪式中学习的团队提供一个更好的核心手册。我们感到非常幸运能与这么多客户合作。所以我们开始编写这本手册，希望在这次录音发布时它已经面世了。在手册中，我们会讨论从 Catalyst 这样的仪式到决策仪式，再到大量的规划、战略和路线图之类的内容。我们试图提取出最有趣的模式，并为人们提供如何实施这些东西的非常实用的视角。我认为这正是目前有时所缺乏的。

---

### [00:56:50] Lenny

**English:**
Amazing. We'll definitely link to that. Hopefully it's live by the time goes out. We'll make it happen. I know also you said Shishir's working on a book that's related and basically rituals of great teams and Shishir was on the podcast and he talked about Dory, so we don't have to get into that. If people want to learn about Dory, they can watch that episode. It was one of the earliest episodes actually. One of the most popular.

**中文翻译:**
太棒了。我们一定会放上链接。希望节目发布时它已经上线了。我们会搞定的。我也知道你提到过 Shishir 正在写一本相关的书，基本上是关于伟大团队的仪式。Shishir 之前上过这个播客，他谈到了 Dory，所以我们就不细聊那个了。如果大家想了解 Dory，可以去看那一集。那实际上是最早的几集之一，也是最受欢迎的一集。

---

### [00:57:09] Lane Shackleton

**English:**
Yeah. I remember that.

**中文翻译:**
是的，我记得。

---

### [00:57:11] Lenny

**English:**
Okay. Cool. I have a bunch of random questions now. I'm just going to go in a few different directions. One is, you wrote this post that you call Learn by Making, Not Talking. Is that another principle by the way? Is that amongst your many principles?

**中文翻译:**
好，酷。我现在有一堆随机的问题，我想从几个不同的方向展开。一个是，你写过一篇名为《通过实践学习，而非空谈》（Learn by Making, Not Talking）的文章。顺便问一下，那是另一个原则吗？它是你众多原则中的一个吗？

---

### [00:57:11] Lane Shackleton

**English:**
Yes.

**中文翻译:**
是的。

---

### [00:57:24] Lenny

**English:**
Okay. Awesome. So in that post, which we'll link to, you share this story of how you and the YouTube team came up with skippable ads, which I didn't realize it was such a controversial ... But in thinking about it, obviously letting people skip ads, I could see why people were not excited about that. Could you just tell that story? And basically it's like the story of how skippable ads on YouTube came about?

**中文翻译:**
好的，太棒了。在那篇文章（我们会放上链接）中，你分享了你和 YouTube 团队如何想出“可跳过广告”的故事。我以前没意识到这竟然是一个如此有争议的……但仔细想想，让人们跳过广告，我确实能理解为什么当时人们并不兴奋。你能讲讲那个故事吗？基本上就是 YouTube 可跳过广告是如何诞生的故事。

---

### [00:57:46] Lane Shackleton

**English:**
Yeah. So I moved over to YouTube shortly after the acquisition. It was an amazing tight-knit team. It definitely felt like the Wild West. We were getting sued by Viacom for a billion dollars when that was a lot of money. No advertiser wanted to talk to us. It was essentially viewed as a site of cat videos and dogs on skateboards and things like that. And then I guess the other context, the sales team was very nascent and all they wanted to sell was the homepage and for good reason. That was where you made your money as a salesperson. And so I had just been sponsored by Salar and Shishir to become a PM. It's a longer story that I'll leave out for now and we can go into. But on day one of being a PM, Shishir's like, "Great. You're the new guy. You get the project that nobody else wants and that's called skippable ads. And we've got this crazy idea that we can align the incentives of advertisers and viewers and creatives in this really clever way by putting a skip button on the ad and then charging people per views." And the latter part we hadn't quite cemented yet, but it was part of the core idea.
(00:59:04):
And so the thing I write about in this post is as a new PM, this feels like a really consequential decision. It's like we've got this new product idea. Nobody really wants it. Advertisers don't want it. The sales team doesn't want it. And it's a very unproven thesis. And so the thing I write about is these are the types of things that you can debate for months or years. And I was sitting in a one-on-one with this guy named Phil Farhi who's an amazing product leader and was my boss at the time. And we're trying to figure out what to do and how to handle all the different dynamics. And he just stops and he's like, "You know what? Just test the extremes. Start the experiment tomorrow. We'll figure it out." Essentially.
(00:59:49):
And I think his point was like, look, we can debate this forever. So I would rather us see the upper and lower bounds of how good this could be or how bad this is going to be immediately. And so we launched a set of experiments. This guy Jamie Kerns who's still there. Tiny little skip button on one experiment, giant skip button that covered the entire player on the other side of the experiment. And within a few weeks, I think we had developed some conviction based on some very directional data that we were onto something. And so the lesson that I took, this is many years ago and I've seen this proven out hundreds of times since, is stop talking about it and go make something. Go run an experiment. Go make a prototype, go write a doc, go make a mock. Just don't talk about it.
(01:00:49):
And I found that also as a leader, people really follow that concept. And I also found that it transcends level. I am not talking just to ICPMs. I'm talking to heads of product and CPOs and CEOs to some degree. You should always be out there trying to learn by expressing your ideas and putting them out there. And that's much more valuable in many cases than pontificating about it or having endless circular discussions on it.

**中文翻译:**
好的。我在 YouTube 被收购后不久就调到了那里。那是一个非常紧密、了不起的团队。当时感觉绝对像是在“西部大荒野”。我们正被维亚康姆（Viacom）起诉索赔 10 亿美元，在当时那可是一大笔钱。没有广告商想理我们。YouTube 基本上被视为一个充斥着猫片和滑板狗视频之类的网站。另一个背景是，销售团队还处于萌芽阶段，他们只想卖首页广告位，理由很充分：那是销售人员赚钱的地方。当时我刚在 Salar 和 Shishir 的支持下转岗成为 PM。那是一个很长的故事，我现在先略过，以后可以细聊。但在我当 PM 的第一天，Shishir 就说：“太好了，你是新来的，你负责那个没人想要的项，叫‘可跳过广告’。我们有一个疯狂的想法，通过在广告上放一个跳过按钮，然后按观看次数收费，以这种聪明的方式对齐广告商、观众和创作者的利益。”后半部分当时还没完全确定，但它是核心想法的一部分。
(00:59:04):
我在文章中写道，作为一个新 PM，这感觉是一个影响深远的决定。我们有这个新产品想法，但没人想要它：广告商不想要，销售团队也不想要，而且这是一个完全未经证实的论题。我写道，这类事情你可以争论几个月甚至几年。当时我正和 Phil Farhi（一位出色的产品领导者，当时是我的老板）进行 1 对 1 面谈。我们正试图弄清楚该做什么，以及如何处理所有不同的动态。他突然停下来，说：“你知道吗？直接测试极端情况。明天就开始实验。我们会搞清楚的。”本质上就是这样。
(00:59:49):
我认为他的观点是：看，我们可以永远争论下去。所以我宁愿让我们立即看到这件事情好能好到什么程度，坏能坏到什么程度。于是我们启动了一系列实验。Jamie Kerns（他现在还在那儿）负责。一个实验用极小的跳过按钮，另一个实验用覆盖整个播放器的巨大跳过按钮。几周之内，我想我们根据一些非常有方向性的数据建立了一些信心，意识到我们找对方向了。我吸取的教训是（这是很多年前的事了，从那以后我见过几百次这样的证明）：停止空谈，去动手做点什么。去做个实验，做个原型，写个文档，画个草图。就是不要只停留在嘴上。
(01:00:49):
我发现作为一名领导者，人们真的会追随这个理念。我还发现它超越了职级。我不仅是在对个人贡献者 PM 说，我也在某种程度上对产品负责人、CPO 和 CEO 说。你永远应该走出去，通过表达你的想法并将其付诸实践来尝试学习。在很多情况下，这比夸夸其谈或进行无休止的循环讨论要有价值得多。

---

### [01:01:23] Lenny

**English:**
It makes me think a little bit about Twitter where they spent years just thinking about the edit button or all these different changes. They're so scared, they did so much research and then now they're changing things left and right. Everything's fine. Everyone's still using it. It shows you that you don't have to be so delicate.

**中文翻译:**
这让我想到了 Twitter，他们花了数年时间仅仅在思考“编辑按钮”或所有这些不同的变化。他们太害怕了，做了那么多研究，而现在他们到处乱改，结果一切都好，大家还在用。这说明你不需要那么小心翼翼。

---

### [01:01:39] Lane Shackleton

**English:**
Yes. It's almost never as bad as you think it's going to be. So yeah, it's just a question of how much better it can be oftentimes.

**中文翻译:**
是的。情况几乎从未像你想象的那么糟。所以，通常这只是一个“它能变得多好”的问题。

---

### [01:01:46] Lenny

**English:**
You mentioned in your early career ... We talked about your Alaska guide phase. Something else I saw is that you were on the AdWords approval team. You basically were reviewing ads people submitted to run on AdWords and that's how you started in tech. So I guess first of all, is that true? And then second of all, how did you graduate from that phase and become this Chief Product Officer of one of the fastest growing, most interesting companies in the world?

**中文翻译:**
你提到了你的早期职业生涯……我们聊过你的阿拉斯加向导阶段。我还看到你曾在 AdWords 审核团队工作过。你基本上是在审核人们提交给 AdWords 投放的广告，这就是你进入科技行业的起点。首先，这是真的吗？其次，你是如何从那个阶段“毕业”，并成为世界上增长最快、最有趣的公司之一的首席产品官的？

---

### [01:02:13] Lane Shackleton

**English:**
That was a really memorable time. There's an amazing cohort of people that started in tech. I think there was 200 or 300 of us at that time and then eventually thousands that started in Sheryl Sandberg's organization. I guess maybe some quick context. Before running ads on google.com at that time, you had to have them manually approved by a human before that was handled by machine learning and outsourced to other countries. And so there was this process where basically an ad would show up on your screen, you would mark it family safe, non-family safe, porn. And then based on that, it would either run or it wouldn't. And actually, funny enough, some of my most successful friends were terrible at the approval event. They failed the rote task of approving ads. They just couldn't handle it and they went on to be really, really successful.
(01:03:08):
So after working on ad approvals, at that time, I moved to chat support. It was basically when AdWords was launching chat support. I remember very fondly having two chats, chatting with two advertisers at once. Moved on to phone support. That was eight hours a day of talking to AdWords customers. Really a total rollercoaster ride. It was basically one minute you would pick up the phone and it would be someone from a Fortune 100 company trying to spend millions of dollars on AdWords and then the next minute you would be on the phone with a psychic or a taxi driver that was warring with their compatriots over some really specific keyword. I think there were two lessons that I would draw from this. One is I had a mentor at the time and his advice when I was starting my career was basically you have to get customer facing from the very beginning because you're going to end up serving a customer your whole career. Even when you're the CEO of a company, you're going to be serving a customer. So you better get really good at being in any customer scenario and being able to handle it. And so I think that that turned out to be insanely good advice. And if I think about a piece of advice that I give out to people who are early in their career, I've definitely recycled that advice.
(01:04:29):
I think the other thing that I took away from that experience was it's just a great lesson in when people don't actually care about your product. So in AdWord's case, people did not care about AdWords. You were the expert on it and you're trying to tell them about ad groups and how this ad format works and blah, blah. And most of the time people are like, "Dude, I'm a small business owner. I'm trying to get people to come to my auto mechanic store." Or, "I'm trying to get people to come to my taxi service," or whatever it was. I don't care. Basically the product had to get out of the way and really just drive impact for the customer. It was like they just want more phone calls or they want more people in the store. So those are I think two pieces that I think about from those days still.
(01:05:21):
And then I worked in a variety of other roles. I worked in a role called product specialist, which is an awesome role back when there were 15 product specialists at Google. For me, that was an amazing time because I was getting to sit on seven or eight different core product teams. And in my observation, these days, most PMs don't get to sit on other people's core teams. And so I had these three or four years of just ... I call it a masterclass in PMing because I was getting to watch what was working for some PMs and what wasn't working for other PMs and just taking notes behind the scenes. So that was a really influential role. And then went on to various PM roles at Google and YouTube.

**中文翻译:**
那真是一段难忘的时光。当时有一大批进入科技行业的人才，我想那时我们有两三百人，后来在 Sheryl Sandberg（谢丽尔·桑德伯格）的部门里发展到了数千人。给一点背景：在那个时候，广告在 google.com 上投放之前，必须由人工手动审核，后来才由机器学习处理并外包给其他国家。所以当时有一个流程，广告会出现在你的屏幕上，你会将其标记为“家庭安全”、“非家庭安全”或“色情”。根据标记，广告要么投放，要么不投放。有趣的是，我一些最成功的朋友在审核这件事上做得一塌糊涂。他们无法胜任这种机械的审核任务，根本受不了，但后来他们都变得非常非常成功。
(01:03:08):
在做完广告审核后，我转到了在线聊天支持。那是 AdWords 刚推出聊天支持的时候。我非常怀念同时开两个窗口和两个广告商聊天的日子。后来又转到了电话支持，每天八小时都在和 AdWords 客户通话。那简直是坐过山车：前一分钟你接起电话，可能是一家财富 100 强公司的员工想在 AdWords 上花几百万美元；后一分钟你可能就在和一个通灵者或出租车司机通话，他们正为了某个非常具体的关键词和同行开战。我想我从中吸取了两个教训。第一，我当时有一位导师，在我职业生涯开始时，他的建议是：你必须从一开始就面向客户，因为你整个职业生涯最终都是在为客户服务。即使你是公司的 CEO，你也是在为客户服务。所以你最好学会如何应对任何客户场景并处理好它。我认为这被证明是极好的建议。如果让我给职业生涯早期的人提建议，我肯定会重复这条建议。
(01:04:29):
我从那段经历中得到的另一件事是：这是一个关于“人们其实并不关心你的产品”的深刻教训。以 AdWords 为例，人们并不关心 AdWords 本身。你是专家，你试图告诉他们广告组、广告格式如何运作等等。但大多数时候人们会说：“伙计，我只是个小企业主，我只想让人们来我的修车店。”或者“我只想让人们打我的出租车”。我不在乎产品。基本上，产品必须“让路”，真正为客户带来影响。他们只想要更多的电话或更多的进店人数。所以这些是我至今仍在思考的两点。
(01:05:21):
之后我担任过各种其他角色。我做过一个叫“产品专家”（Product Specialist）的职位，当时 Google 只有 15 个产品专家，那是一个很棒的角色。对我来说，那是一段奇妙的时光，因为我有机会参与七八个不同的核心产品团队。据我观察，现在的 PM 大多没有机会参与别人的核心团队。所以我经历了三四年的……我称之为 PM 的“大师班”，因为我可以观察哪些 PM 的做法有效，哪些无效，并在幕后做笔记。那是一个非常有影响力的角色。之后我进入了 Google 和 YouTube 的各种 PM 职位。

---

### [01:06:09] Lenny

**English:**
Coming back to noticing. It comes up again and again in our chat. This is so interesting because it feels like you basically came from the mail room of tech to the top of the product field. And so I think there's a lot of inspiration people can take from this journey. One quick question is how long was that journey from not being a PM, from I guess being at a tech company to getting your first PM role? Just to give people a sense.

**中文翻译:**
又回到了“察觉”。这在我们的聊天中反复出现。这太有趣了，因为感觉你基本上是从科技行业的“收发室”一路走到了产品领域的顶端。我认为人们可以从这段旅程中获得很多启发。一个小问题：从不是 PM（我猜是从进入科技公司开始）到获得第一个 PM 职位，这段旅程花了多长时间？给听众一个概念。

---

### [01:06:33] Lane Shackleton

**English:**
Let's see. I probably worked for at least four, five years before being able to move to PM and I think that was a slightly harrowing journey because at the time, you had to have a computer science degree.

**中文翻译:**
让我想想。在转岗到 PM 之前，我大概工作了至少四五年。我认为那是一段有点艰辛的旅程，因为在那个时候，你必须拥有计算机科学学位（才能在 Google 当 PM）。

---

### [01:06:46] Lenny

**English:**
At Google. Right. Cool. So I think that's one takeaway too is give it time. It's not going to happen. There's a lot of people that are just like, "I need to become a PM immediately."

**中文翻译:**
在 Google，没错。酷。所以我认为这也是一个启示：给它一点时间。它不会一蹴而就。现在有很多人觉得“我必须立刻成为 PM”。

---

### [01:06:55] Lane Shackleton

**English:**
Totally.

**中文翻译:**
完全正确。

---

### [01:06:56] Lenny

**English:**
I think that's a good example of it's not going to happen overnight. Coming back to your two lessons, I think they're really interesting and I'm curious if there's anything else that comes to mind of what you found was essential to you succeeding in this path? So the first lesson you shared as being customer facing. And in this case being in retail as customer facing, is your advice get in a tech company and work on something customers use or is even working at Starbucks or Abercrombie, does that count?

**中文翻译:**
我认为这是一个很好的例子，说明成功不会一夜之间发生。回到你的两个教训，我觉得它们非常有趣。我想知道，关于你认为在这条道路上取得成功的关键因素，还有什么其他的想法吗？你分享的第一个教训是面向客户。在这种情况下，如果是零售业的面向客户，你的建议是进入科技公司并从事客户使用的产品，还是说在星巴克或 Abercrombie 工作也算数？

---

### [01:07:24] Lane Shackleton

**English:**
Yeah. I think in many cases if you're in a customer facing role, you are the expert on the customer and that is really, really valuable in tech organizations. And oftentimes it's undervalued. And so I think people who want to move into PM roles who are not currently in PM roles can often lever that experience and that knowledge of the customer in ways that are pretty profound for the organization and pretty insightful for the organization if they really are creative about it. And then I think the other thing is, regardless of where you are in the organization, you're always serving a customer. You can't just talk to one big enterprise customer and you can't just talk to the smallest customer. You have to have a diverse and continuous stream of customer interactions in order to have good intuitions about what to do next. And your engineers aren't going to really trust you unless you have good intuitions about where the customer's headed and what they want and stuff like that. And so the stakes I think are pretty high. The good news is it's easier than ever with all these tools to really get into the mindset of a customer.

**中文翻译:**
是的。我认为在很多情况下，如果你处于面向客户的角色，你就是客户专家，这在科技组织中是非常非常有价值的。而且它往往被低估了。所以我认为，那些目前不在 PM 职位但想转岗的人，如果他们真的有创意，往往可以利用那段经验和对客户的了解，以对组织产生深远影响和深刻见解的方式来实现转岗。另一件事是，无论你在组织的哪个位置，你总是在为客户服务。你不能只和一家大企业客户谈，也不能只和最小的客户谈。你必须拥有多样化且持续的客户互动流，才能对下一步该做什么产生良好的直觉。除非你对客户的走向、他们的需求等有良好的直觉，否则你的工程师不会真正信任你。所以我认为赌注相当高。好消息是，有了现在这些工具，进入客户的心态比以往任何时候都容易。

---

### [01:08:47] Lenny

**English:**
My lesson touches on something a previous guest talked about, Paige Costello, where she was often the youngest person in the room and built a lot of respect and people really trusted her over time. And her lesson was know thy customer. If you know the most about what they need, and you can show, here's what I've heard again and again and again, people will just like, "Oh Lane, tell us more." And they bring you into conversation because providing value, you're not just there sharing opinions. Everyone's got opinions.

**中文翻译:**
我的教训触及了之前的一位嘉宾 Paige Costello 谈到过的内容。她经常是房间里最年轻的人，但随着时间的推移，她赢得了极大的尊重，人们非常信任她。她的教训是：了解你的客户。如果你最了解他们的需求，并且你能展示出“这是我一次又一次听到的反馈”，人们就会说：“噢 Lane，多跟我们讲讲。”他们会把你带入对话，因为你在提供价值，而不仅仅是在分享观点。每个人都有观点。

---

### [01:09:15] Lane Shackleton

**English:**
That's basically how both me and ... I had a friend named Bill Ferrell who transitioned into PM at the same time and that's essentially how we got the try at being a PM inside of Google was we knew the customer really, really well and we were often in conversations bridging the gap from here's what I think they're really saying, or here's what I think we should build based on what they said.

**中文翻译:**
这基本上就是我和……我有一个叫 Bill Ferrell 的朋友，他和我同时转岗成为 PM。这本质上就是我们在 Google 内部获得尝试成为 PM 机会的原因：我们非常非常了解客户，我们经常在对话中弥合差距，比如“这是我认为他们真正想表达的意思”，或者“这是我认为基于他们所说的我们应该构建的东西”。

---

### [01:09:41] Lenny

**English:**
The other thing I wanted to mention, you talked about the product and how a lot of customers don't care about the product, they just care about just I need this thing done. It reminds me at Airbnb, we hired this guy, Chip Connolly, who was a hotelier. He created the Joie de Vivre hotel chain and just is steeped in hospitality. And he came to Airbnb and started doing this worldwide tour talking to hosts. And he's just like, "Guys, when you talk about product, you're telling hosts, 'Hey, the product's going to be updated. We're going to launch all these features.', they think their home is the product of Airbnb. They don't understand what you're talking about when you're talking about the online experience and the website. That's the last thing they think about. It's the experience of someone traveling on Airbnb and staying in their home." So I think it's a really good reminder of most people don't care about the product. They just have this problem and you just happen to be this website that'll help them solve it.

**中文翻译:**
我还想提另一件事。你谈到了产品，以及很多客户并不关心产品，他们只关心“我需要把这件事办成”。这让我想起在 Airbnb，我们聘请了 Chip Conley，他是一位酒店大亨。他创建了 Joie de Vivre 连锁酒店，深谙款待之道。他来到 Airbnb 后开始在全球巡回与房东交谈。他说：“伙计们，当你们谈论产品时，你们在告诉房东‘嘿，产品要更新了，我们要发布这些功能’，但房东认为他们的家才是 Airbnb 的产品。当你们谈论在线体验和网站时，他们根本不明白你们在说什么。那是他们最后才会想到的事情。他们想到的是某人通过 Airbnb 旅行并住在他们家里的体验。”所以我认为这是一个很好的提醒：大多数人并不关心产品。他们只是遇到了问题，而你恰好是那个能帮他们解决问题的网站。

---

### [01:10:30] Lane Shackleton

**English:**
I think most people can be way more concise with their communication. Even internally, people don't care. You should assume that people don't care. Or if you're talking to customers, writing a blog post for customers, you should assume that they don't care. When you start with that assumption, you really force yourself to be a little bit sharper in your communication style.

**中文翻译:**
我认为大多数人的沟通可以更简洁。即使在内部，人们也不在乎。你应该假设人们不在乎。或者如果你在和客户交谈，为客户写博客文章，你也应该假设他们不在乎。当你带着这个假设开始时，你真的会强迫自己在沟通风格上变得更犀利一点。

---

### [01:10:53] Lenny

**English:**
And one final question before we get to our very exciting lightning round. I heard a story that at Coda there's this moment called Tim Ferriss Day that drove a lot of traffic. Can you share that story? Does that ring a bell?

**中文翻译:**
在进入我们非常令人兴奋的闪电轮问答之前，最后一个问题。我听过一个故事，说在 Coda 有一个叫“Tim Ferriss 日”的时刻，它带来了巨大的流量。你能分享那个故事吗？有印象吗？

---

### [01:11:08] Lane Shackleton

**English:**
Yeah. There's lots of memorable days at Coda. One of them was Tim Ferris Day. So I guess maybe for context, we had built this very nascent publisher motion where we were going out and helping people publish their rituals. And this is what you see in the Coda Gallery and a lot of what we talked about today. But we had this one person on that team, this guy Al Chen, Tim Ferriss fan, and also I think had been really tenacious with the people around Tim Ferriss and basically finally got an in to him and figured out a really neat way to implement one of his rituals and wrote a doc. And so none of us really knew this, but this was all happening. And anyway, we wake up one morning and traffic is just spiking through the roof, signups are spiking, no one knows what's going on.
(01:11:59):
I'm convinced this is all spam. I'm like, "Something's wrong with our data or something's going haywire." At the time, we were also in the China Basin office and the fire alarm went off. And so now we're outside on our laptops. We were in a war room trying to figure out what was happening and now we're outside trying to figure out what's going on. So anyway, make a long story short, data scientists investigate and we eventually figured out that we had been featured in Tim Ferriss' email newsletter and I think early on you hear this lesson or this adage of first time founder, build a great product, second time founder, build a great distribution. I think that was one of those early big cues to think about the importance of content distribution and the importance of these publishing flywheels. And it definitely made us double down. We're like, "Okay, if we can do this with Tim Ferriss, what's next?" And we definitely spent a few months trying to reach that high watermark that was set that day in traffic and sign-ups. So it was a fun memorable day and people for the subsequent one or two years would refer to it as Tim Ferriss Day.

**中文翻译:**
是的。在 Coda 有很多难忘的日子。其中之一就是 Tim Ferriss 日。给一点背景：我们当时建立了一个非常初级的“发布者机制”，我们走出去帮助人们发布他们的仪式。这就是你在 Coda Gallery 中看到的，也是我们今天谈论的很多内容。我们团队中有一个叫 Al Chen 的人，他是 Tim Ferriss 的粉丝，而且我认为他对 Tim Ferriss 身边的人非常有韧性，最终成功联系上了他，并想出了一个非常巧妙的方法来实现他的一个仪式，还写了一个文档。我们当时都不知道这件事，但它正在发生。总之，有一天早上我们醒来，流量突然爆表，注册量激增，没人知道发生了什么。
(01:11:59):
我当时确信这全是垃圾流量。我想：“我们的数据出问题了，或者什么东西乱套了。”当时我们还在 China Basin 的办公室，结果火警响了。于是我们现在抱着笔记本电脑站在外面。我们本来在“作战室”试图弄清楚发生了什么，现在却在外面试图弄清楚怎么回事。总之，长话短说，数据科学家进行了调查，我们最终发现我们被列入了 Tim Ferriss 的邮件通讯中。我想在早期你会听到这样一个教训或格言：第一次创业者关注构建好产品，第二次创业者关注构建好分发。我认为那是促使我们思考内容分发重要性和这些发布飞轮重要性的早期重要信号之一。这绝对让我们加倍投入。我们想：“好吧，如果我们能和 Tim Ferriss 合作，下一步是什么？”在接下来的几个月里，我们确实一直在努力达到那天创下的流量和注册量的最高纪录。所以那是一个有趣且难忘的日子，在随后的两三年里，人们都会称之为“Tim Ferriss 日”。

---

### [01:13:15] Lenny

**English:**
So funny. I bet Tim Ferriss had no idea what he did.

**中文翻译:**
太有意思了。我敢打赌 Tim Ferriss 根本不知道他做了什么。

---

### [01:13:18] Lane Shackleton

**English:**
No idea.

**中文翻译:**
完全不知道。

---

### [01:13:19] Lenny

**English:**
Hoping you have a Lenny's podcast day once this comes out. Everyone's going to be freaking out. What is going on here? Is there anything else you wanted to share before we get to our very exciting lightning round?

**中文翻译:**
希望这期节目播出后，你们能迎来一个“Lenny's Podcast 日”。每个人都会惊呼：“这儿发生什么了？”在进入我们非常令人兴奋的闪电轮问答之前，你还有什么想分享的吗？

---

### [01:13:30] Lane Shackleton

**English:**
Maybe we're talking really briefly about two-way writeups.

**中文翻译:**
也许我们可以简单聊聊“双向文档”（Two-way writeups）。

---

### [01:13:33] Lenny

**English:**
Yeah, let's do it. I had that in my notes, but I skipped it, so I'm glad you mentioned it.

**中文翻译:**
好啊，来吧。我的笔记里有这个，但我跳过了，很高兴你提到了。

---

### [01:13:37] Lane Shackleton

**English:**
Cool. Yeah, I mean this is a concept that I wrote a bunch about and I often now get asked about, and I guess maybe the historical view of this, I got really obsessed with the history of how work gets discussed and decided upon and broke it down into three phases. And so the first phase was 1980s we had PowerPoint. It was this amazing tool. You could manipulate shapes on a screen and we were all using fancy clip art and it was really fun, but we've all had the experience of being in a really long PowerPoint presentation and someone's droning on in their slides and stuff like that. Second phase is in the early 2000s, two things converged. One was Google bought this company called Rightly that became Google Docs. So instead of having Word on your desktop and sending files around you now had online collaborative editing.
(01:14:35):
And the other thing was Jeff Bezos sent this very famous memo, which basically said no more PowerPoint at Amazon. And what that did was started in earnest their six pager ritual. You can read all about this in the book Working Backwards. It's a really good book. Colin Breyer's book. And so that started I think what I'll call the one-way writeup phase, which is you're writing down your ideas, you're expressing them clearly. It's in prose so you have to be really clear. That was a big step up I think from always presenting work and deciding on work via presentations. And then the thesis is that we're in the midst of a new phase, which is essentially two-way writeups and that's where it's more conversational and feedback and discussion is actually part of the content itself. So that's the broader historical arc. But if you think about it, PMs and product people are always at the brunt.
(01:15:31):
They feel this the most because they're the ones that are driving decisions and really the ones that are driving discussions oftentimes in companies. And so I think the problem with one-way writeups I felt very deeply at Google and YouTube. And just to name them, the first one is you would always be trying to figure out who's read your write-up. So I have many memories of sending a write-up out at 11:30 PM and then waiting patiently for the avatar of the SVP in my area to show up in there. And that was a sign that they had read it, which is just totally insane if you think about that behavior. The second one is you end up having a lot of the discussion in the comments itself. So this is a space that's really built for grammar and spell checking and things like that. And you're having these really meaningful discussions in this a hundred pixel right margin.
(01:16:30):
And part of that I think is there all these questions that are being raised, and so you have really no idea what the most important question is. And so if you're facilitating those discussions in one way writeups, you're often going through the comments in the 20 minutes before that session trying to figure out which one of these do I want to address. And then the other behavior, and I don't know if you've ever seen this in a doc, but in one way writeups that you see a lot is there'll be just a mega comment thread on the title of the doc. And people are like, "I don't think we should do this," or you'll get into this 30 comment thread on the title because that's the best place to put your overall thoughts. And I saw this pattern all the time. So if you live that life, I think the world of two-way writeups and the way that I think a lot of our customers are doing it, and you can do this on other tools besides Coda too, I think is quite a bit better.
(01:17:26):
I guess the alternative to go down that list is you have a done reading button at the end of a writeup. So now you can say, oh, these are all the people that have read this. And I think even you see a pattern in some of our customers where if it's a particularly long writeup, you'll have three done reading buttons so you can see where everyone has gotten to. And then the second thing is making sure that you're actually addressing the most important question. So instead of pulling questions out of the comments and trying to figure out which one to address, just putting those in a table and then letting people upload those. And that's what we call Dory. And then I think probably the most valuable is sentiment or pulse, which is, well, how do you feel overall about this particular proposal?
(01:18:13):
And if you think about the contrast between a comment thread on the title and seeing a list of all the sentiment, how everybody feels about this proposal and really being inclusive to the entire audience is just wildly different. I think in my particular experience. I'll give you one example. I wrote this proposal, this is now a couple years ago. I thought it was going to sail through no problem. I thought it was going to get four out of five and five out of five smiley faces from everybody. That's sort of how the sentiment table works. And one of the lead designers basically said, "One smiley face. We shouldn't do this." And I was like, oh man. This particular person's not really vocal in meetings. And so I would not have heard that feedback. It was very unlikely I would've heard that feedback unless they had had a sentiment table, a place to add that. And so I think the punchline on all of this is I really authentically believe that this is where we're headed and hope that a lot of PMs and product teams adopt this in general.

**中文翻译:**
酷。是的，这是一个我写过很多文章、现在也经常被问到的概念。我想从历史的角度来看，我非常痴迷于工作讨论和决策的历史，并将其分为三个阶段。第一阶段是 1980 年代，我们有了 PowerPoint。这是一个了不起的工具，你可以在屏幕上操作形状，我们都在用花哨的剪贴画，这很有趣。但我们都有过这样的经历：参加一个非常长的 PPT 演示，有人在幻灯片前喋喋不休。第二阶段是在 2000 年代初期，两件事汇合了：一是 Google 收购了一家叫 Rightly 的公司，它后来变成了 Google Docs。所以你不再是在桌面上用 Word 并到处发送文件，而是有了在线协作编辑。
(01:14:35):
另一件事是杰夫·贝佐斯发了那份著名的备忘录，基本上说亚马逊不再使用 PowerPoint。这开启了他们著名的“六页纸”（Six-pager）仪式。你可以在《逆向工作法》（Working Backwards）这本书里读到相关内容，那是 Colin Breyer 写的一本好书。这开启了我称之为“单向文档”（One-way writeup）的阶段，即你写下你的想法，清晰地表达出来。它是散文体，所以你必须表达得非常清楚。我认为这比总是通过演示文稿来展示和决定工作有了巨大的进步。然后我的论题是，我们正处于一个新阶段，本质上是“双向文档”（Two-way writeups），在这里它更具对话性，反馈和讨论实际上是内容本身的一部分。这是更广泛的历史弧线。但如果你仔细想想，PM 和产品人员总是首当其冲。
(01:15:31):
他们对此感受最深，因为他们是推动决策的人，通常也是公司里推动讨论的人。我在 Google 和 YouTube 时深刻感受到了单向文档的问题。举几个例子：第一，你总是试图弄清楚谁读了你的文档。我有很多回忆，在晚上 11:30 发出一份文档，然后耐心地等待我那个领域的 SVP 的头像出现在文档里。那是他们读过文档的信号，如果你仔细想想这种行为，简直是疯了。第二，你最终会在评论区进行大量讨论。但评论区这个空间实际上是为语法和拼写检查之类的东西设计的。而你却在这个 100 像素宽的右侧边栏里进行非常有意义的讨论。
(01:16:30):
我认为其中的一部分问题是，所有这些问题都被提了出来，但你根本不知道哪个问题最重要。所以如果你在单向文档中主持讨论，你通常会在会议开始前的 20 分钟里翻遍评论，试图弄清楚我想处理哪一个。还有一种行为，我不知道你是否在文档中见过，但在单向文档中很常见：在文档标题上有一个超级长的评论链。人们会说“我不认为我们应该这样做”，或者你会看到标题上有 30 条评论，因为那是发表整体看法的最佳位置。我一直看到这种模式。所以如果你过着那样的生活，我认为双向文档的世界（以及我认为我们的许多客户正在做的方式，你也可以在 Coda 以外的其他工具上这样做）要好得多。
(01:17:26):
我想，沿着这个清单走下去，替代方案是在文档末尾有一个“已读”按钮。这样你就可以说：噢，这些是所有读过的人。我甚至在一些客户那里看到一种模式：如果是一份特别长的文档，会有三个“已读”按钮，这样你就能看到每个人读到了哪里。第二件事是确保你真正处理了最重要的问题。所以不要从评论中提取问题并试图弄清楚该处理哪一个，而是把它们放在一个表格里，让大家投票。这就是我们所说的 Dory。然后我认为最有价值的是“情绪”或“脉搏”（Sentiment/Pulse），即：你对这个特定提案的整体感觉如何？
(01:18:13):
如果你对比一下标题上的评论链和看到所有情绪的列表（每个人对这个提案的感觉），并真正包容所有受众，那感觉是完全不同的。根据我个人的经验，我给你举个例子。几年前我写了一份提案，我以为会毫无悬念地通过。我以为每个人都会给我四颗星或五颗星的笑脸（情绪表就是这样运作的）。结果一位首席设计师基本上说：“一颗星，我们不应该这样做。”我当时想：噢天呐。这个人在会议上并不怎么发言。所以除非有情绪表这个可以表达的地方，否则我不太可能听到那个反馈。所以这一切的重点是，我真的由衷地相信这就是未来的方向，并希望广大 PM 和产品团队能采纳这种方式。

---

### [01:19:23] Lenny

**English:**
I'm so glad that we touched on it and there's a template or an explanation of this that you wrote up that we'll link to. Yeah.

**中文翻译:**
我很高兴我们聊到了这个，你写过一个模板或解释，我们会放上链接。是的。

---

### [01:19:31] Lane Shackleton

**English:**
Great. Yeah.

**中文翻译:**
太好了，是的。

---

### [01:19:32] Lenny

**English:**
Awesome. Is there anything else that you think that we should touch on that we haven't touched on?

**中文翻译:**
太棒了。你觉得还有什么我们还没聊到但应该聊聊的内容吗？

---

### [01:19:37] Lane Shackleton

**English:**
Yeah. I think one thing that we've discussed before is just about strategy and planning and stuff like that. So it may be useful to touch on a couple of insights there. I think there's two insights in the strategy and planning thing. And this is again in the handbook that we're writing, but the first that I end up seeing a lot is just this idea that OKRs are not actually strategy. So I think the way that we plan and the way that our customers plan, the key point is it's critical to disconnect strategy discussions from OKR discussions. And it sounds really obvious, but it's I think a very common mistake. And I think a really simple question to ask yourself is do we have a separate strategy process or strategy ritual that is distinct from OKR setting and metric setting and goal setting? And I have found you can pick whatever strategy framework works for you, but I do think it's quite important to pull those two things apart.
(01:20:43):
The other rule that we live by on the planning side is what we call a 10% planning rule, which is essentially just ensure that you're not for a given time period planning for more than 10% of that execution period. And I think this is a really easy mistake to make. I mean, this is a hard fought rule because we've made that mistake before. But you end up getting bogged down in planning or saying, planning felt rushed and so we need to make it three weeks instead of one week or whatever. And the byproduct of that over the course of a lot of time is that you end up just planning way too much and oftentimes you really don't know what's ahead until you've launched or learned something. And so I think that's a pretty good rule to follow.

**中文翻译:**
是的。我想我们之前讨论过的一件事是关于战略和规划之类的。所以在这里分享几个见解可能会有用。我认为在战略和规划方面有两个见解。这同样包含在我们正在编写的手册中。第一个是我经常看到的：OKR 实际上并不是战略。我认为，从我们规划的方式以及我们客户规划的方式来看，关键点在于：将战略讨论与 OKR 讨论分开至关重要。这听起来显而易见，但我认为这是一个非常普遍的错误。我认为一个非常简单的问题可以问问自己：我们是否有一个独立的战略流程或战略仪式，是独立于 OKR 设定、指标设定和目标设定的？我发现你可以选择任何适合你的战略框架，但我确实认为把这两件事分开非常重要。
(01:20:43):
我们在规划方面遵循的另一个规则是我们称之为“10% 规划规则”，本质上就是确保对于给定的时间段，你的规划时间不超过执行时间的 10%。我认为这是一个很容易犯的错误。我是说，这是一个经过艰苦努力才总结出的规则，因为我们以前也犯过这个错误。但你最终会陷入规划的泥潭，或者说规划感觉太仓促了，所以我们需要把它从一周变成三周之类的。长期下来的副作用就是你最终规划得太多了，而通常情况下，在你发布或学到一些东西之前，你真的不知道未来会发生什么。所以我认为这是一个非常值得遵循的规则。

---

### [01:21:32] Lenny

**English:**
I love that rule. I found the same heuristic. 10%. If you're planning for a week, plan for half a day, planning for a month, maybe like three days. Yeah, I love it. With that, we've reached our very exciting lightning round. Are you ready?

**中文翻译:**
我喜欢这个规则。我也发现了同样的启发式方法：10%。如果你规划一周，那就花半天时间规划；规划一个月，大概花三天。是的，我喜欢。说到这，我们进入了非常令人兴奋的闪电轮问答。准备好了吗？

---

### [01:21:46] Lane Shackleton

**English:**
I'm ready.

**中文翻译:**
准备好了。

---

### [01:21:47] Lenny

**English:**
What are two or three books that you've recommended most to other people?

**中文翻译:**
你向别人推荐最多的两三本书是什么？

---

### [01:21:51] Lane Shackleton

**English:**
One that comes to mind is Turning the Flywheel. It's a little manuscript book. Jim Collins wrote it. It's really, I think a very succinct and very fast read about how flywheels work. We talked about Storyworthy. I recommend that book a lot. Good Strategy/Bad Strategy. Love that book. Very simple framework that I've reused a bunch. Maybe outside of tech, Waking Up is a book by Sam Harris on mindfulness that I really like. And then an old one that I really like is The Inner Game of Tennis by Timothy Galway, which is a kind of classic.

**中文翻译:**
我想到的一本是《转动飞轮》（Turning the Flywheel）。那是 Jim Collins 写的一本小册子。我认为它非常简洁，能让你快速了解飞轮是如何运作的。我们谈过《讲故事的艺术》（Storyworthy），我经常推荐那本书。还有《好战略，坏战略》（Good Strategy/Bad Strategy），我非常喜欢那本书，我多次复用了其中非常简单的框架。在科技领域之外，Sam Harris 写的关于正念的《醒来》（Waking Up）我也很喜欢。还有一本我很喜欢的旧书是 Timothy Gallwey 写的《网球的内心游戏》（The Inner Game of Tennis），这是一部经典之作。

---

### [01:22:27] Lenny

**English:**
Amazing. On Good Strategy/Bad Strategy, I'm working on getting Richard Rumelt on the podcast. I'm in talks with his agent and they seem to be excited. So we'll hope that actually happens. And then you inspired me to try to get the Storyworthy guy on. So what a cast of characters we're going to get on here.
(01:22:43):
Next question. What is a favorite recent movie or TV show that you really enjoyed?

**中文翻译:**
太棒了。关于《好战略，坏战略》，我正在努力邀请 Richard Rumelt 上播客。我正在和他的经纪人洽谈，他们似乎很兴奋。希望这能成真。然后你启发了我去邀请《讲故事的艺术》的作者。我们要请到的嘉宾阵容真是太强大了。
(01:22:43):
下一个问题。最近你非常喜欢的电影或电视节目是什么？

---

### [01:22:48] Lane Shackleton

**English:**
Yeah, it's a little bit hard with three kids and a job these days to watch a lot of TV. I would say I really enjoyed The Last Dance. I love any sports documentary. All those.

**中文翻译:**
是的，现在有三个孩子和一份工作，很难看很多电视。我会说我非常喜欢《最后一舞》（The Last Dance）。我喜欢任何体育纪录片，所有的都喜欢。

---

### [01:22:59] Lenny

**English:**
Have you seen Underrated, Steph Curry's new documentary?

**中文翻译:**
你看过《被低估》（Underrated）吗？就是斯蒂芬·库里的新纪录片。

---

### [01:23:01] Lane Shackleton

**English:**
No, I haven't. I got to watch that.

**中文翻译:**
还没，我得去看看。

---

### [01:23:03] Lenny

**English:**
Ooh. It's really good.

**中文翻译:**
噢，真的很好看。

---

### [01:23:05] Lane Shackleton

**English:**
I've been rewatching Arrested Development. That's also just a timeless classic.

**中文翻译:**
我一直在重温《发展受阻》（Arrested Development）。那也是一部永恒的经典。

---

### [01:23:11] Lenny

**English:**
Classic. I love that Michael Cera is in the Barbie movie, not to give any spoilers. That was a funny surprise.
(01:23:18):
Next question. What is a favorite interview question that you like to ask candidates?

**中文翻译:**
经典。我喜欢 Michael Cera 出现在《芭比》电影里，不剧透了，那是一个有趣的惊喜。
(01:23:18):
下一个问题。你最喜欢问应聘者的面试问题是什么？

---

### [01:23:22] Lane Shackleton

**English:**
There are two I really like. One is teach me something that I don't already know. I think it's just an awesome way of seeing if someone's going to lean in and really figure out what you don't know and then how passionate they are about pitching what they do know I think is really fun. And then Shishir and I have been asking a version of teleporter question and evolving it for many years now, so I like that question quite a bit.

**中文翻译:**
有两个我非常喜欢的。一个是“教我一些我还不知道的东西”。我认为这是一个极好的方式，可以观察某人是否会投入进来，真正弄清楚你不知道什么，然后看他们对自己所知事物的推销有多大热情，这很有趣。另外，Shishir 和我多年来一直在问一个“传送门问题”的版本并不断改进它，我也非常喜欢那个问题。

---

### [01:23:49] Lenny

**English:**
Shishir shared that question in his episode and we make TikTok clips out of some of these conversations and that clip just went crazy. People love it. It's our most viewed clip, I think on TikTok. Or just like, what would your answer to that question, so we'll try to link to it in the show notes if you want to watch just that one interview question. I think you maybe gave it away, so maybe that's why you're evolving it.

**中文翻译:**
Shishir 在他那一集里分享了那个问题。我们将其中一些对话制作成 TikTok 短视频，那个视频简直疯传。人们非常喜欢它，我想那是我们在 TikTok 上播放量最高的视频。如果你只想看那一个面试问题，我们会尝试在节目笔记中放上链接。我想你可能已经泄露了答案，所以这也许就是你们不断改进它的原因。

---

### [01:24:10] Lane Shackleton

**English:**
Yeah. We-

**中文翻译:**
是的，我们——

---

### [01:24:11] Lenny

**English:**
Don't know if we screwed you.

**中文翻译:**
不知道我们是不是把你坑了。

---

### [01:24:13] Lane Shackleton

**English:**
I also recently wrote a post about my favorite ref check question, which I think I would love to learn other people's favorite ref check questions.

**中文翻译:**
我最近还写了一篇关于我最喜欢的背景调查（Ref check）问题的文章，我也很想学习别人最喜欢的背景调查问题。

---

### [01:24:20] Lenny

**English:**
References check. Oh man. That's its own. Oh man, I'd love to do a podcast just on that. That is such an important skill. The first question you mentioned of asking people to teach you something, I heard the best version of that in a previous episode where Maya, the Head of Product for Spotify podcasts, asks what would your podcast be if you were to start a podcast?

**中文翻译:**
背景调查。噢伙计，那本身就是一个大话题。我真想专门做一期关于这个的播客。那是一项非常重要的技能。你提到的第一个问题（让人教你一些东西），我在之前的一集里听到了最好的版本：Spotify 播客产品负责人 Maya 会问：“如果你要开一个播客，你的播客会关于什么？”

---

### [01:24:40] Lane Shackleton

**English:**
I like that.

**中文翻译:**
我喜欢这个。

---

### [01:24:42] Lenny

**English:**
So feel free to steal it.

**中文翻译:**
所以尽管拿去用吧。

---

### [01:24:45] Lane Shackleton

**English:**
I sometimes do a version of making them explain it two different ways after, and making the candidate explain it two different ways and saying, "Okay, now you have to explain that to your grandparent." And then now you just told me about sewing or some hobby of yours. Now sell it in its most technical form to someone who knows everything about this particular topic. And so it's kind of fun to also see the range that people can operate.

**中文翻译:**
我有时会做一个进阶版：让应聘者用两种不同的方式解释。我会说：“好，现在你得向你的祖父母解释这个。”然后，“你刚才跟我讲了缝纫或你的某个爱好，现在请以最专业的形式把它推销给一个对这个特定话题了如指掌的人。”看到人们能驾驭的跨度也很有趣。

---

### [01:25:13] Lenny

**English:**
Awesome. What is a favorite product that you've recently discovered that you really love? Either digital or physical, anything that comes to mind?

**中文翻译:**
太棒了。你最近发现并非常喜欢的某个产品是什么？数字的或实体的都可以，任何想到的。

---

### [01:25:21] Lane Shackleton

**English:**
A few. I'm becoming a real sleep nerd, so those eye masks that cup around your eyes, I love. Obviously in the tech world, ChatGPT. I got really obsessed with tennis during the pandemic. There's a product called Swing Vision that's really good. It basically cuts up your match into different ... All of your forehands or all the longest rallies or all that and uses AI to do that. There's a corresponding meditation app to the book Waking Up that I really like. That one's a very good one.

**中文翻译:**
有几个。我正变成一个睡眠极客，所以我很喜欢那种能罩住眼睛的眼罩。在科技界，显然是 ChatGPT。大流行期间我迷上了网球，有一个叫 Swing Vision 的产品非常好。它基本上能把你的比赛切成不同的片段……你所有的正手击球，或者所有最长的拉锯战等等，它利用 AI 来实现。还有与《醒来》这本书配套的冥想 App，我也非常喜欢，那是一个非常好的应用。

---

### [01:25:57] Lenny

**English:**
We live not so far from each other, so we got to play some tennis and I could check out this very cool product.

**中文翻译:**
我们住得不远，所以我们得一起打打网球，顺便我也能见识一下这个酷产品。

---

### [01:26:01] Lane Shackleton

**English:**
Yeah, let's do it.

**中文翻译:**
好啊，来吧。

---

### [01:26:03] Lenny

**English:**
You're on. That'll be our sequel. Just our game. Next question. What is a favorite life motto that you either repeat to yourself often, like to share with people around you, share with your kids maybe?

**中文翻译:**
一言为定。那将是我们的续集：我们的比赛。下一个问题。你最喜欢的人生格言是什么？无论是你经常对自己重复的，还是喜欢分享给周围人或孩子的？

---

### [01:26:16] Lane Shackleton

**English:**
I don't know if it's as motto as much as it's just a way of being. It's essentially the present moment is all that we have. Realizing that our attention is very often on the past or the future and in so many ways the present is where it should be always. And so I think that that is something I think about a lot. I think maybe more broadly, I had a mentor who roughly said a version of make things happen, and so I really try to apply that to anything that I do. If that's work or life or sports, I try to be the person who creates momentum and positive change and progress. And so I think that that's generally a good motto to live by.

**中文翻译:**
我不知道这算不算格言，它更像是一种生存方式。本质上就是：当下是我们所拥有的一切。意识到我们的注意力经常停留在过去或未来，但在很多方面，当下才是它应该始终停留的地方。所以我经常思考这件事。也许更广泛地说，我有一位导师曾说过一个版本的“让事情发生”（Make things happen），所以我真的尝试将其应用到我做的任何事情中。无论是工作、生活还是体育，我都努力成为那个创造动力、积极变化和进步的人。所以我认为这通常是一个很好的生活格言。

---

### [01:26:58] Lenny

**English:**
Beautiful. What is the most valuable lesson that your mom or your dad taught?

**中文翻译:**
太美了。你父母教给你的最宝贵的教训是什么？

---

### [01:27:03] Lane Shackleton

**English:**
My mom's a psychologist and a professional counselor so certainly active listening. Maybe the tech version of that or the modern version of that is steal manning someone's argument, being able to repeat back to someone what they said in a better form, more clear form. So yeah, she's an amazing woman. Taught me a lot about listening.

**中文翻译:**
我妈妈是一位心理学家和专业咨询师，所以当然是“积极倾听”。也许它的科技版或现代版是“强论证”（Steal manning，即以最强、最清晰的形式重述对方的论点）。是的，她是一位了不起的女性，教了我很多关于倾听的知识。

---

### [01:27:28] Lenny

**English:**
Final question. You were a guide in Alaska helping people climb. If someone were to pursue climbing, is there a tip or a lesson or something that you think people should know to get better at this or to know before they go down this route?

**中文翻译:**
最后一个问题。你曾在阿拉斯加当向导帮助人们攀登。如果有人想追求攀登，你觉得有什么技巧、教训或事情是人们为了做得更好、或者在走这条路之前应该知道的吗？

---

### [01:27:43] Lane Shackleton

**English:**
There's a saying, which is the safest climber is the one who knows when to come down essentially. And I think that there are many times that you have to put your ego in check and come off a mountain or come out of a climb because it's not quite as safe as you thought it was. So I think that's maybe one. I think the other is it's probably not a one-way door. So I think in many ways you can do climbing and you can do some of these outdoor pursuits on the side, or you can always come back from them. So it's maybe not as big of a choice as some people think it is.

**中文翻译:**
有一句话是：最安全的登山者本质上是那个知道什么时候该下山的人。我认为很多时候你必须克制自己的自尊心，从山上下来或退出攀登，因为情况并不像你想象的那么安全。这可能是一个。另一个是，这可能不是一扇“单向门”。我认为在很多方面，你可以把攀登和一些户外追求作为副业，或者你总是可以从中回归。所以这可能不像某些人想象的那么重大。

---

### [01:28:24] Lenny

**English:**
Lane, I said at the top of this episode, Coda has one of the most thoughtful product teams out there, and I think it'll be clear to people after listening to this why that's the case and where it trickles down from. Thank you so much for being here. Two final questions. Where can folks find you online if they want to reach out and ask you any other questions? And how can listeners be useful to you?

**中文翻译:**
Lane，我在本集开头说过，Coda 拥有业内最深思熟虑的产品团队之一。我想听完这期节目后，大家就会明白为什么是这样，以及这种文化是从哪里传承下来的。非常感谢你能来。最后两个问题：如果大家想联系你或问你其他问题，可以在哪里找到你？以及听众可以为你做些什么？

---

### [01:28:42] Lane Shackleton

**English:**
I'm on LinkedIn and Twitter and I have a Substack. We'll be releasing that handbook for product teams that I will probably post on Substack. And in terms of useful to me, yeah, give Coda a try. Give us feedback. I love hearing from product people all over. It's one of the bright spots in my day to hear all the creative rituals that come from this community. You've created just a legendary community of people and so they always give very thoughtful feedback so I'm very open to all of that. And yeah, thanks for having me.

**中文翻译:**
我在 LinkedIn 和 Twitter 上，我还有一个 Substack。我们会发布那本产品团队手册，我可能会发在 Substack 上。至于对我有什么帮助，是的，去试试 Coda 吧。给我们反馈。我喜欢听来自各地产品人的声音。听到来自这个社区的所有创意仪式是我一天的亮点之一。你建立了一个传奇般的社区，他们总是给出非常深思熟虑的反馈，所以我对所有这些都持非常开放的态度。是的，谢谢你的邀请。

---

### [01:29:22] Lenny

**English:**
Awesome. Lane, thank you again so much for being here.

**中文翻译:**
太棒了。Lane，再次感谢你能来。

---

### [01:29:25] Lane Shackleton

**English:**
Thanks.

**中文翻译:**
谢谢。

---

### [01:29:26] Lenny

**English:**
Bye everyone.
(01:29:29):
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
大家再见。
(01:29:29):
非常感谢您的收听。如果您觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或您喜欢的播客应用中订阅本节目。此外，请考虑给我们评分或留下评论，因为这能真正帮助其他听众发现这个播客。您可以在 lennyspodcast.com 找到所有往期节目或了解更多关于本节目的信息。下期节目见。