# Laura Modi - 双语对照

This is the complete bilingual transcript for Lenny’s Podcast featuring Laura Modi, founder of Bobbie.

---

### [00:00:00] [Laura Modi]

**English:**
So our head of growth, who... I mean, this girl is just fabulous. She was watching our inventory levels very carefully and also watching how quickly we were growing. And I'll never forget that moment. I can visualize it, sitting in a meeting, and she pulls up her screen. She goes, "Here's the dilemma. We are depleting inventory far quicker than our ability to replenish and the customers keep coming." You sit there and your first reaction is "This is great. We're growing." And she's like, "It's not that great, actually, because here's what's going to happen. We are going to run out of product for the babies that are on Bobbie today. We have about six days before we get to a place where we won't be able to serve those who've already made a commitment to Bobbie." She's like, "So we need to turn off our site and stop growing the business."

**中文翻译:**
我们的增长负责人，我得说，这姑娘简直太棒了。她当时非常仔细地盯着我们的库存水平，同时也关注着我们的增长速度。我永远不会忘记那一刻，我甚至能想象出那个画面：我们正开着会，她拉出屏幕说：“现在的困境是，我们消耗库存的速度远快于补货的速度，而且客户还在源源不断地涌入。” 你坐在那儿，第一反应是“这太棒了，我们在增长”。但她说：“其实没那么好，因为接下来会发生这样的情况：我们将没有足够的产品供应给目前正在使用 Bobbie 的宝宝。大约还有六天，我们就会陷入无法服务那些已经选择 Bobbie 的客户的境地。” 她接着说：“所以，我们需要关闭网站，停止业务增长。”

---

### [00:00:56] [Lenny]

**English:**
Welcome to Lenny's Podcast, where I interview world-class product leaders and growth experts to learn from their hard-won experiences building and growing today's most successful products. Today my guest is Laura Modi. Laura and I actually worked together at Airbnb for many years where she was director of hospitality, leading all of the work around strengthening the host community and also improving marketplace quality. After leaving Airbnb, she went on to found a company called Bobbie, the only female-founded and mom-led organic infant formula company in the US which basically every mom I know uses.

**中文翻译:**
欢迎来到 Lenny 的播客。在这里，我会采访世界级的跨国产品负责人和增长专家，学习他们在打造和发展当今最成功产品过程中积累的宝贵经验。今天的嘉宾是 Laura Modi。我和 Laura 实际上在 Airbnb 共事多年，当时她是款待业务总监（Director of Hospitality），负责加强房东社区联系以及提升市场质量的所有工作。离开 Airbnb 后，她创立了一家名为 Bobbie 的公司，这是美国唯一一家由女性创立、由妈妈领导的有机婴儿配方奶粉公司，基本上我认识的每一位妈妈都在用。

---

### [00:01:26] [Lenny]

**English:**
I rarely have CEOs or founders on this podcast, and when I do, it's because I'm confident that product leaders and growth teams and other founders can learn a lot from this person. Laura is a great example of this and I've been incredibly impressed with watching Laura execute and build this company. In our conversation, we talk about how to build and maintain momentum within your organization, how sometimes slowing growth down is the best way to grow long term, why the most innovative ideas often come from people with no experience in the problem space, how to lead through tough times, why manufacturing fake deadlines is so powerful and effective and so much more. Laura is such a great leader and such a great human, and I'm really excited for you to learn from her. With that, I bring you Laura Modi, after a short word from our sponsors.

**中文翻译:**
我很少邀请 CEO 或创始人来这个播客，一旦邀请，是因为我确信产品负责人、增长团队和其他创始人能从这个人身上学到很多东西。Laura 就是一个极佳的例子，看着她执行并建立这家公司，给我留下了极其深刻的印象。在我们的对话中，我们讨论了如何在组织内部建立并保持势头（Momentum），为什么有时放慢增长速度是长期增长的最佳方式，为什么最具创新性的想法往往来自那些在相关领域毫无经验的人，如何在艰难时期进行领导，为什么制造“虚假截止日期”如此强大且有效，以及更多内容。Laura 是一位出色的领导者，也是一个非常棒的人，我很高兴能让大家向她学习。在听完赞助商的简短介绍后，让我们欢迎 Laura Modi。

---

### [00:02:11] [Lenny]

**English:**
This episode is brought to you by Vanta, helping you streamline your security compliance to accelerate your growth. Thousands of fast-growing companies like Gusto, Com, Hora and Modern Treasury, trust Vanta to help build, scale, manage and demonstrate their security and compliance programs and get ready for audits in weeks, not months. By offering the most in-demand security and privacy frameworks such as SOC 2, ISO 27001, GDPR, HIPAA, and many more, Vanta helps companies obtain the reports they need to accelerate growth, build efficient compliance processes, mitigate risks to their businesses, and build trust with external stakeholders. Over 5,000 fast-growing companies use Vanta to automate up to 90% of the work involved with SOC 2 and these other frameworks. For a limited time, Lenny's Podcast listeners get $1,000 off Vanta. Go to vanta.com/lenny. That's V-A-N-T-A.com/lenny to learn more and to claim your discounts. Get started today.

**中文翻译:**
本期节目由 Vanta 为您带来。Vanta 帮助您简化安全合规流程，从而加速业务增长。数千家快速成长的公司（如 Gusto、Com、Hora 和 Modern Treasury）都信任 Vanta，通过它来构建、扩展、管理和展示其安全合规计划，并在几周而非几个月内做好审计准备。通过提供最热门的安全和隐私框架（如 SOC 2、ISO 27001、GDPR、HIPAA 等），Vanta 帮助公司获得加速增长所需的报告，建立高效的合规流程，降低业务风险，并与外部利益相关者建立信任。超过 5,000 家快速成长的公司使用 Vanta 来自动化处理 SOC 2 及其他框架中高达 90% 的工作。在限定时间内，Lenny 播客的听众可享受 Vanta 1,000 美元的优惠。访问 vanta.com/lenny（即 V-A-N-T-A.com/lenny）了解更多信息并领取折扣。今天就开始吧。

---

### [00:03:09] [Lenny]

**English:**
Today's episode is brought to you by Element. I just recently discovered the stuff actually from another podcast, and it is such sweet, salty goodness. Element is a tasty electrolyte drink mix with a science-backed electrolyte ratio. And, unlike most electrolyte drinks, there's no sugar, coloring, artificial ingredients, gluten or any other BS. Getting enough electrolytes helps prevent and eliminate headaches, muscle cramps, fatigue, sleeplessness, and other common symptoms of electrolyte deficiency. Element is the exclusive hydration partner to Team USA Weightlifting and many other Olympic athletes.

**中文翻译:**
今天的节目由 Element 为您带来。我最近刚从另一个播客中发现了这个东西，它真的是那种甜咸交织的美味。Element 是一款美味的电解质饮料冲剂，具有科学支持的电解质比例。而且，与大多数电解质饮料不同，它不含糖、色素、人工成分、麸质或其他任何乱七八糟的东西。摄入足够的电解质有助于预防和消除头痛、肌肉抽搐、疲劳、失眠以及其他常见的电解质缺乏症状。Element 是美国国家举重队和许多其他奥运选手的独家补水合作伙伴。

---

### [00:03:42] [Lenny]

**English:**
Also, dozens of NBA and NFL teams and players rely on Element to stay hydrated, along with Navy SEAL teams, FBI sniper teams and the Marines. You can try Element totally risk-free. If you don't like it, you can share it with a salty friend and they'll give you your money back, no questions asked. To give it a shot, go to drinklmnt.com/lenny and you'll get a free sample pack with any purchase, which includes one packet of every flavor. My favorite is watermelon salt. You won't find this offer publicly available, so you have to head to drinklmnt.com/lenny to take advantage of this offer. Stay salty.

**中文翻译:**
此外，数十支 NBA 和 NFL 球队及球员，以及海豹突击队、FBI 狙击小组和海军陆战队都依靠 Element 来保持水分。您可以完全无风险地尝试 Element。如果您不喜欢，可以分享给一位“重口味”的朋友，他们会无条件退款。想要尝试的话，请访问 drinklmnt.com/lenny，任何购买都将获赠免费样品包，包含每种口味各一小袋。我最喜欢的是西瓜盐味。这个优惠在公开渠道是找不到的，所以您必须前往 drinklmnt.com/lenny 才能享受。保持活力（Stay salty）。

---

### [00:04:20] [Lenny]

**English:**
Laura, welcome to the podcast.

**中文翻译:**
Laura，欢迎来到播客。

---

### [00:04:22] [Laura Modi]

**English:**
Hi, I'm so happy to be here. It's a Friday, Lenny, this is amazing.

**中文翻译:**
嗨，很高兴来到这里。Lenny，今天是周五，这感觉太棒了。

---

### [00:04:26] [Lenny]

**English:**
Oh, my God, already starting strong. I was looking forward to this chat for a few weeks already. I knew that we booked it a couple of weeks ago. Just as context, we worked together at Airbnb for a while and, not something I expected, but you went on to now become a magnate in the baby formula industry, which I'm excited to dig into. And so thank you again for being here.

**中文翻译:**
天哪，一上来就状态拉满。我已经期待这次聊天好几周了。我知道我们几周前就约好了。背景介绍一下，我们曾在 Airbnb 共事过一段时间，虽然我没预料到，但你后来成了婴儿配方奶粉行业的巨头，我很期待深入探讨这个话题。再次感谢你的到来。

---

### [00:04:45] [Laura Modi]

**English:**
Thank you. This is going to be exciting. Hope you don't mind. I am going to have a little bit of wine as we go through this.

**中文翻译:**
谢谢。这会很有趣的。希望你不介意，我打算边聊边喝点酒。

---

### [00:04:50] [Lenny]

**English:**
It's highly encouraged. Maybe I need to start drinking more on the show. That might help.

**中文翻译:**
非常鼓励。也许我也该在节目里多喝点，那可能会有帮助。

---

### [00:04:54] [Laura Modi]

**English:**
Highly approved.

**中文翻译:**
完全赞同。

---

### [00:04:56] [Lenny]

**English:**
We'll see. We'll see how it ends up. It'll be a good retrospective.

**中文翻译:**
走着瞧吧。看看最后会聊成什么样。这会是一次很好的回顾。

---

### [00:05:00] [Laura Modi]

**English:**
Merlot's so good.

**中文翻译:**
梅洛葡萄酒（Merlot）真好喝。

---

### [00:05:00] [Lenny]

**English:**
So I thought it'd be fun to start with just your time at Airbnb where we got to work together. You spent five and a half years there. Everyone that spends that amount of time at Airbnb, and let me know if you agree, always ends up being in this transformative time in their life and their career. Yeah, okay, you're nodding.

**中文翻译:**
我想从你在 Airbnb 的时光聊起会很有趣，那是我们共事的地方。你在那里待了五年半。每一个在 Airbnb 待过那么长时间的人——如果你同意的话请告诉我——最终都会经历一段人生和职业生涯的转型期。是的，我看你在点头。

---

### [00:05:15] [Laura Modi]

**English:**
I can't imagine a world where I would be without Airbnb.

**中文翻译:**
我无法想象如果没有在 Airbnb 的经历，我现在会是什么样子。

---

### [00:05:21] [Lenny]

**English:**
Yeah, I feel the same way. And so I want to spend a little time on what you learned from that experience and what you took away there. But just to start, can you just share briefly what you worked on while you were at Airbnb?

**中文翻译:**
是的，我也有同感。所以我想花点时间聊聊你从那段经历中学到了什么，以及带走了什么。首先，你能简要分享一下你在 Airbnb 期间负责的工作吗？

---

### [00:05:28] [Laura Modi]

**English:**
I mean, what didn't we work on? Just, I reflect back and it's one of those experiences where it probably was transformative because you do get an opportunity to work on so many different things. So I remember joining and I was just put in charge of leading and growing parts of customer service, vendor management. I mean, we were scaling the team so fast on that side. It quickly shifted into taking me to Europe where I led our consolidation of our European offices in Dublin. It was so funny. I remember at the time being asked to go do it and thinking, am I being asked purely because I'm just the only Irish person in the company right now? But it was one of the biggest operational changes that we went through there. And then for the last few years I was the director of hospitality leading global host community and host operations.

**中文翻译:**
我是说，有什么是我们没做过的吗？回想起来，那确实是一段转型期的经历，因为你真的有机会接触到各种各样的事情。我记得刚加入时，我负责领导和发展客户服务、供应商管理的部分。当时我们在那方面的团队扩张速度极快。很快，我被派往欧洲，负责都柏林欧洲办公室的整合工作。很有趣，我记得当时被要求去做这件事时在想：是因为我是公司里唯一的爱尔兰人吗？但那确实是我们经历过的最大的运营变革之一。在最后的几年里，我担任款待业务总监，领导全球房东社区和房东运营。

---

### [00:06:26] [Lenny]

**English:**
I think you're underselling that last part. Can you just share a little bit more of what that actually means?

**中文翻译:**
我觉得你把最后那部分说得太简单了。你能再详细分享一下那具体意味着什么吗？

---

### [00:06:26] [Laura Modi]

**English:**
Our product really wasn't our technology. It wasn't the technology that we were building, although for a few years we all thought it was. And then it got to a place where we realized Airbnb is nothing without its hosts, nothing. If anything, Airbnb's product was its hosts. So there was a moment, and I can't remember, it was two or three years in, where that narrative was building up more and more and we realized that there was a need to have a central team, which we called Hospitality, dedicated to equipping and recognizing and holding this product of our hosts accountable to their job.

**中文翻译:**
我们的产品其实并不是我们的技术。虽然有几年我们都以为是，但后来我们意识到，如果没有房东，Airbnb 什么都不是。如果非要说的话，Airbnb 的产品就是它的房东。所以有那么一个时刻——我不记得是第二年还是第三年——这种认知越来越强烈，我们意识到需要一个核心团队（我们称之为“款待团队”），专门负责为房东提供支持、认可，并让他们对自己的工作负责。

---

### [00:07:09] [Lenny]

**English:**
Yeah, I think we could go down that. Maybe let me ask one question there because I think that's really interesting. For a company where the product, as you said, and marketplaces in general, the product you're selling is the supply, in our case Airbnb hosts. Is there something maybe you learned from that experience, I don't know, working at a software, company about how to think about the supply as the product and how that maybe informs, I don't know, what you're building today or just something in general?

**中文翻译:**
是的，我们可以深入探讨一下。我想问一个问题，因为这很有趣。对于一家公司来说，正如你所说，在双边市场（Marketplace）中，你销售的产品其实是供应端，在我们的案例中就是 Airbnb 的房东。你在一家软件公司工作时，有没有从那段经历中学到如何将“供应端”视为“产品”？这种思维是否影响了你今天所做的事情，或者有什么通用的感悟？

---

### [00:07:37] [Laura Modi]

**English:**
I think it maybe just starts internally where you have to be able to create a culture first, to all understand that. Because otherwise you're going to be in a position where you're focused on optimizing the technology, efficiency, growth, looking at tools for tools' sake versus tools for users' sake. And I mean, I remember a very pivotal shift when we started realizing that we really needed to understand our hosts far more than we had leading up to that. And I think growth just follows. I mean, we certainly saw that at Airbnb. If we put the hosts first and we thought about building tools for them versus what do we need just to drive more bookings, users begets users, and that's exactly what we saw.

**中文翻译:**
我认为这可能要从内部开始，你必须首先建立一种文化，让大家都能理解这一点。否则，你就会陷入只关注优化技术、效率和增长的境地，为了工具而开发工具，而不是为了用户。我记得一个非常关键的转变，就是我们开始意识到，我们需要比以往更深入地了解我们的房东。我认为增长自然会随之而来。我们在 Airbnb 确实看到了这一点：如果我们把房东放在首位，考虑为他们构建工具，而不是仅仅考虑如何增加预订量，那么“用户会带来用户”，这正是我们所看到的。

---

### [00:08:29] [Lenny]

**English:**
What are some lasting lessons from your time at Airbnb that you bring to what you're working on now?

**中文翻译:**
你在 Airbnb 期间学到的哪些持久的教训，是你现在带入到工作中去的？

---

### [00:08:33] [Laura Modi]

**English:**
The most obvious kind of cliched one is culture. It is bread and butter to everything you do, from the people you hire to how you build the right mindset to just keeping the energy. I mean, energy at Airbnb was the currency. It was like, unless you didn't have that energy, nothing was happening. And I think about that every day. How do you keep energy going? And my God, they did that for a decade, just keeping it going. I think the other big takeaway is if you can get people excited behind a vision and storytelling, it again kind of carries through that cross-functional work.
(00:09:16):
I now reflect back on just how powerful our storytelling was at Airbnb to get people pumped up. I mean, even for some of the smallest features that we would build, Lenny, they would kick off with the most powerful storytelling. I mean, we were changing lives. And again, it makes you wake up every day going, "Fuck, yeah, I want to work on this." And you're not just going in to fix something, you actually feel like you're having very large impact. And that has to be felt the whole way down the org.

**中文翻译:**
最明显、甚至有点陈词滥调的一点就是“文化”。它是你所做一切的基础，从你雇佣的人到你如何建立正确的思维模式，再到保持活力。在 Airbnb，活力（Energy）就是通用的货币。如果没有那种活力，什么都不会发生。我每天都在思考这个问题：如何保持活力？天哪，他们坚持了十年，一直保持着这种状态。另一个重要的收获是，如果你能让人们为一个愿景和故事感到兴奋，这种力量会贯穿所有的跨职能工作。
(00:09:16):
我现在回想起来，Airbnb 的讲故事（Storytelling）能力是多么强大，能让人们热血沸腾。Lenny，即使是我们开发的一些微小功能，也会以最有感染力的故事拉开序幕。我的意思是，我们当时在改变生活。这让你每天醒来都会想：“太棒了，我想做这个。” 你不只是去修补什么东西，你真的觉得自己正在产生巨大的影响。这种感觉必须传达到组织的每一个角落。

---

### [00:09:44] [Lenny]

**English:**
I love that you're already getting into the specifics of what culture actually... how it manifests and how to build a culture. And so I want to maybe ask another question there. You talked about keeping the energy up is a big part of creating the culture. You want to create strong storytelling, either in one of those buckets or another example. What do you do at Bobbie, which we're going to talk about, to build a strong culture? What else do you do to actually do that? Because people hear about building a strong culture and they're like, "What do I do? How do I do that?" So I'd love to hear anything you've actually done there.

**中文翻译:**
我喜欢你已经开始深入探讨文化的具体表现以及如何构建文化。所以我想再问一个问题。你提到保持活力是创造文化的重要组成部分。你想要创造强大的故事。在 Bobbie（我们待会会详细聊），你是如何建立强大文化的？你还做了哪些具体的事情？因为人们听到“建立强大文化”时，往往会问：“我该怎么做？” 所以我很想听听你实际做过的事情。

---

### [00:10:11] [Laura Modi]

**English:**
I think one of the biggest ones I would say is that you need to get to know people personally as much as you do professionally. And that was maybe something I also maybe took a little bit for granted at Airbnb. We had built a culture where people really personally loved each other. They loved working together. Now, fast-forward to today and you're building a company that's completely remote, how do you build a personal relationship?
(00:10:36):
For example, we make sure that we take time to have personal and professional check-ins. And cross-functional people in the org who maybe have no idea someone else as a kid or what they're doing in their lives. Because those personal connections, I mean, again, it's your second family, you're waking up every day to spend time with them. I think those personal connections are some of the biggest.

**中文翻译:**
我认为最重要的一点是，你需要像了解员工的专业能力一样去了解他们的个人生活。这可能是我在 Airbnb 时有点想当然的事情。我们建立了一种文化，大家在私下里真的很喜欢彼此，喜欢一起工作。现在，快进到今天，你正在建立一家完全远程办公的公司，你该如何建立个人关系呢？
(00:10:36):
例如，我们确保花时间进行个人和专业的沟通（Check-ins）。组织中跨职能的人可能根本不知道同事有孩子，或者他们的生活状况。因为这些个人联系——再说一次，这是你的第二个家庭，你每天醒来都要和他们共度时光。我认为这些个人联系是最重要的因素之一。

---

### [00:10:56] [Lenny]

**English:**
It's interesting because there's also this movement away from your workmates or your family. Airbnb I think is very... Everyone called themselves AirFam, but that becomes challenging when you have to let people go and there's challenging times. So is your perspective, that's where you find value, to kind of stay close to that?

**中文翻译:**
这很有趣，因为现在也有一种趋势，主张不要把同事当成家人。我认为 Airbnb 非常典型，每个人都自称“AirFam”，但当你不得不裁员或面临艰难时期时，这就会变得很有挑战性。所以你的观点是，保持这种亲密关系依然是有价值的吗？

---

### [00:11:14] [Laura Modi]

**English:**
I think you need a hybrid. I do. I think looking at work for transactions' sake, are your colleagues purely as the people who are just there to get the job done with you? That's not inspiring. No. Do I think that there's a balance and maybe some of the things that get introduced in a culture probably don't need to go that far? Yeah. But no matter what, I do believe building personal connections and actually caring about the people you work for is imperative for building a lasting business.

**中文翻译:**
我认为需要一种混合模式。确实如此。如果纯粹为了交易而看工作，把同事仅仅看作是帮你完成任务的人，那一点也不鼓舞人心。不。我是否认为需要一种平衡，有些文化元素可能不需要走得那么远？是的。但无论如何，我坚信建立个人联系并真正关心与你共事的人，对于建立一家持久的企业至关重要。

---

### [00:11:45] [Lenny]

**English:**
What's the story of going from Airbnb to building a baby formula?

**中文翻译:**
从 Airbnb 离职去研发婴儿配方奶粉，这中间有什么故事？

---

### [00:11:48] [Laura Modi]

**English:**
Oh, my god. You mean leaving one of the fastest growing companies to start powdered milk? It was so funny. I don't know if I ever shared this with you, Lenny. I remember telling my dad and he was like, "Hold on a second, Laura. I don't understand." He's like, "You're lactose intolerant. Why are you starting a milk company?" He just couldn't fathom why I would, I mean in many ways, leave an established business that had established parental leave benefits, everything that in many ways, as you grow through your career, become more and more what you need and you need the stability.
(00:12:30):
So that shift, I suppose, just socializing it is probably one of the hardest. And it's a big thing to take a risk because you're taking 10 steps backwards in hopes of making major leaps forward. And I think that's just always kind of been a narrative mostly in my career, which is I don't believe there's such a thing as taking a big leap without first taking a major risk, and that was. I mean, it was a very big risk, obviously. But then also, keep in mind, even before I joined Airbnb, I had a good job at Google. And Airbnb at the time, I think, just had one of its most major crises back in 2011.

**中文翻译:**
噢天哪。你是说离开一家增长最快的公司去卖奶粉？太搞笑了。我不确定有没有跟你说过，Lenny。我记得告诉我爸时，他说：“等一下，Laura，我不明白。你有乳糖不耐受，为什么要开一家牛奶公司？” 他完全无法理解我为什么要离开一家成熟的企业，那里有完善的育儿假福利，以及随着职业生涯发展你越来越需要的稳定性。
(00:12:30):
所以这种转变，尤其是向周围人解释，可能是最难的部分之一。冒险是一件大事，因为你是为了实现重大飞跃而先退后十步。我认为这贯穿了我的职业生涯：我不相信不冒大险就能实现大飞跃。那确实是一个巨大的风险。但请记住，在我加入 Airbnb 之前，我在 Google 有一份很好的工作。而当时的 Airbnb，我记得在 2011 年正经历着最严重的危机之一。

---

### [00:13:09] [Lenny]

**English:**
CJ or EJ?

**中文翻译:**
是 CJ 事件还是 EJ 事件？（注：指 Airbnb 早期房客损毁房屋事件）

---

### [00:13:11] [Laura Modi]

**English:**
EJ. EJ incident. It was all over the papers. It was a small company. I wasn't really given a title. And I'll never forget as well, exactly the same narrative. My parents going, "Hold on a second. You're leaving Google to go start a B&B." Like, "No, I'm not starting a B&B. I really believe this company's going somewhere." So anyway, the moral of the story is the move into starting my own business, it was a big risk and it was one that I felt so confident on that was needed, it was worth it.

**中文翻译:**
EJ。EJ 事件。当时报纸上全是这个。那还是一家小公司，甚至没给我正式头衔。我永远不会忘记，当时也是同样的剧本。我父母说：“等一下，你要离开 Google 去开民宿（B&B）？” 我说：“不，我不是去开民宿，我真的相信这家公司大有前途。” 总之，这个故事的寓意是，开始创业是一个巨大的风险，但我非常有信心这是市场需要的，所以值得一试。

---

### [00:13:41] [Lenny]

**English:**
Some people do what you did there, where you take a big risk and kind of maybe stick backwards and it doesn't work out. And in your case it's worked out many times. Is there a thread across the decisions you've made that you think people maybe should look for or you think is important in taking that big risk? Or do you think it was a lot of super luck?

**中文翻译:**
有些人像你一样冒了大险，退后一步，但结果并不理想。而在你的案例中，成功了很多次。在你做出的这些决定中，有没有什么共同点是你认为人们应该去寻找的，或者你认为在冒大险时很重要的？还是说你觉得这很大程度上是靠运气？

---

### [00:14:02] [Laura Modi]

**English:**
Super luck. I mean, I have a folder of businesses and product ideas that, prior to Bobbie, I had dreamt of. And we can always get into that again in the future. Some of them I still dream of doing one day, but a big reason for not taking the risk is because I didn't feel the conviction. So, yes, while I think it's luck, I think I put a lot of intention into researching the marketplace, understanding the business, determining how much of a risk I'm really able to take, even financially. Sitting with my husband and determining how long I may need to be in this position before raising capital and is it possible? It certainly isn't what sometimes it can appear on the surface, which is, "Oh, she had an idea and she left." There's a lot of work that goes into determining is this actually going to be something that's viable?

**中文翻译:**
超级好运。我是说，在创立 Bobbie 之前，我有一个文件夹，里面全是我梦想过的业务和产品创意。我们以后可以再聊这个。其中一些我至今仍梦想着有一天能实现，但没去冒险的一个重要原因是当时没有那种坚定的信念（Conviction）。所以，虽然我认为有运气成分，但我投入了大量精力去研究市场、了解业务，并确定我真正能承担多大的风险，甚至是财务上的风险。我会和丈夫坐下来商量，在融资之前我需要在这个状态下坚持多久，这是否可行？这绝不像表面看起来那样简单——“噢，她有个主意，然后就辞职了”。要确定一个项目是否真的可行，需要做大量的工作。

---

### [00:14:57] [Lenny]

**English:**
I like that lesson. It may seem like Laura went to here, to Airbnb and was just like, "Oh, how lucky she picked Airbnb of all the companies." But what you're saying is you spent the time researching, seeing what the company started.

**中文翻译:**
我喜欢这个教训。看起来 Laura 只是运气好，在所有公司中选中了 Airbnb。但你所说的是，你花了时间去研究，去观察这家公司是如何起步的。

---

### [00:15:09] [Laura Modi]

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:15:10] [Lenny]

**English:**
Yeah. Okay. So let's talk about Bobbie, just broadly. Can you just talk about what is Bobbie and then what is the scale of Bobbie these days? What stats can you share to give people a sense of how large this has gotten?

**中文翻译:**
好。那我们来泛泛地聊聊 Bobbie。你能介绍一下 Bobbie 是做什么的，以及现在的规模有多大吗？你能分享哪些数据，让大家对它的规模有个概念？

---

### [00:15:20] [Laura Modi]

**English:**
Bobbie is a powdered milk company. We are an infant formula. And prior to infant formula, the formula-gate of 2022, which everyone is now familiar with. The short of it is that this is an industry that is owned by a duopoly. It's one of the last remaining industries in the CPG space that has seen any disruption or change in probably 40 years. And my desire was to create a formula that parents could feel proud of, an infant formula that felt modern and met where science is today. Because frankly, none of the infant formulas on the market really had caught up to where science has evolved to.
(00:16:00):
Now, obviously, I only experienced this as becoming a mother myself. I knew nothing about this at all. And then I pick up a can of formula and I read the back of the can and there's ingredients in there I would never feed myself. And I think the thing that really hit me, and this was more of the business investor side of me, I just hated the product and I couldn't understand why, as something that is used by so many, 83% of parents, why is it that I'm embarrassed about it? I feel guilty feeding my child this and it's also ugly. It's sitting on my counter every day and this isn't what I want to see.
(00:16:41):
I remember saying to my husband, "I feel like we have failed to breastfeed." And the alternative is that I need to give her a medical solution to survive, which it's milk. I should feel like I'm giving her food. But for whatever reason, society has set this up to make formula feel like you have failed. I mean, that was the impetus. I know you asked me, what is Bobbie? We are a better-for-you infant formula without the guilt.

**中文翻译:**
Bobbie 是一家奶粉公司。我们生产婴儿配方奶粉。在 2022 年大家都熟知的“奶粉危机”之前，简单来说，这个行业一直被双头垄断（Duopoly）所掌控。它是快消品（CPG）领域中极少数在过去 40 年里几乎没有任何颠覆或改变的行业之一。我的愿望是创造一种让父母感到自豪的配方奶粉，一种具有现代感且符合当今科学水平的婴儿配方奶粉。因为坦率地说，市场上没有任何一款婴儿配方奶粉真正跟上了科学发展的步伐。
(00:16:00):
当然，我是在自己成为母亲后才体会到这一点的。我以前对此一窍不通。当我拿起一罐配方奶粉读背面的成分表时，发现里面有些成分我甚至都不会给自己吃。最触动我的一点——这更多是出于我作为商业投资者的那一面——是我讨厌这个产品，我不明白为什么作为一种被 83% 的父母使用的产品，我却会因为它感到尴尬？给孩子喂这个让我感到内疚，而且包装也很丑。它每天摆在我的柜台上，但这并不是我想看到的。
(00:16:41):
我记得对我丈夫说：“我觉得我们母乳喂养失败了。” 而替代方案是我必须给她一种“医疗解决方案”来维持生命，但它明明是奶啊，我应该觉得是在给她喂食物。但出于某种原因，社会环境让喂配方奶粉感觉像是你失败了。这就是动力。我知道你问我 Bobbie 是什么，我们是一款“让你更好、没有负罪感”的婴儿配方奶粉。

---

### [00:17:12] [Lenny]

**English:**
Ooh, I like that. That was a good summary at the end. How about about the scale of Bobbie? What kind of numbers can you share? Just to give people a sense of how large this has become.

**中文翻译:**
噢，我喜欢这个。最后的总结很棒。那 Bobbie 的规模呢？你能分享哪些数据，让大家感受一下它现在有多大？

---

### [00:17:20] [Laura Modi]

**English:**
Yeah. Oh, my god. I remember launching, it was 100% direct-to-consumer, it was at the top of 2021. And the moment you're about to launch, the first question all investors ask is what do you believe your growth is going to be? First question. It's the same question you get after you're married, when are you going to have a baby? I'm like, "I have no clue what my growth is going to be. I've been on the market for a hot minute." I remember thinking hopefully four million, five million in our first year. So the growth has been fabulous and beyond our wildest dreams in what we had expected.

**中文翻译:**
是的。天哪。我记得刚发布时，我们是 100% 的 D2C（直接面向消费者）模式，那是 2021 年初。在你即将发布的那一刻，所有投资者问的第一个问题都是：你认为你的增长会是多少？第一个问题。这就像你结婚后会被问“什么时候生孩子”一样。我当时想：“我根本不知道增长会是多少，我才刚上市没多久。” 我记得当时希望第一年能达到 400 万或 500 万美元。结果增长非常惊人，完全超出了我们最大胆的预期。

---

### [00:17:54] [Lenny]

**English:**
Amazing. There's a bunch of questions I'm going to ask about how you grew Bobby, but you mentioned the COVID baby shortage crisis. And there's a couple stories I wanted to get into that was one of them. Can you just talk about what you went through in that period? Because I imagine it was both a blessing and a curse. Also, it reminds me, I have a friend who uses Bobbie and she just told me a story about how someone, she couldn't find any Bobbie during COVID, supply chain issues and all that, and an employee of Bobbie came to her house and brought her formula just to make sure she had enough. And obviously that created forever brand loyalty. And we'll talk a little bit about brand, but I'd love to hear about just that period of the journey and what you learned from it.

**中文翻译:**
太棒了。关于你如何发展 Bobbie，我有很多问题要问，但你提到了新冠期间的婴儿奶粉短缺危机。我想深入了解几个故事，那是其中之一。你能聊聊在那段时期你经历了什么吗？因为我能想象那既是福也是祸。此外，这让我想起我有一个朋友在用 Bobbie，她告诉我一个故事：在新冠期间，因为供应链等问题，她买不到 Bobbie，结果一名 Bobbie 的员工亲自去她家送了奶粉，只为了确保她有足够的存货。显然，这建立了终身的品牌忠诚度。我们稍后会聊聊品牌，但我很想听听那段旅程以及你从中学习到了什么。

---

### [00:18:34] [Laura Modi]

**English:**
There is nothing like a crisis that gives you more of an appreciation for what opportunity lies ahead. And I would thank my blessings every day that the only way to look at this positively was to be in a position of gratitude that I have an opportunity that most startups would wait a lifetime for. So what happened was I woke up one day and the President of the United States was talking about there being an infant formula shortage. And again, it's just being in the right place at the right time. A topic that never has really been brought up. Unfortunately, one of the large companies, one of the duopolies, had a recall and that recall basically left the nation without product and we were not able to feed babies in the US.
(00:19:29):
Being one of the smallest companies here, we ended up seeing our customer count double the first week that that shortage happened. All of that would seem great, almost like a dream for any startup to be in, that you're going to see your product grow now because they're moving from one customer to another or from one product to another. But here's what happens. Infant formula is one of those products you can't run out of. It's not cool to be out of infant formula. It's not like a piece of furniture and you're at capacity for a certain amount of time.
(00:20:03):
So our Head of Growth who, I mean this girl is just fabulous. She was watching our inventory levels very carefully and also watching how quickly we were growing. And I'll never forget that moment. I can visualize it, sitting in a meeting. And she pulls up her screen, she goes, "Here's the dilemma. We are depleting inventory far quicker than our ability to replenish. And the customers keep coming." You sit there and your first reaction is, "I mean, this is great. We're growing." And she's like, "It's not that great, actually, because here's what's going to happen. We are going to run out a product for the babies that are on Bobbie today. That's a problem."
(00:20:48):
So in my absorption of everything that's happening, and again, being a company that had only been on the market 14 months, saying to her, "Well, Shireen, what do we do next?" And she's like, "We have about six days before we get to a place where we won't be able to serve those who've already made a commitment to Bobbie." She's like, "So we need to turn off our site and stop growing the business." That's a big decision to make when you're like, "Okay, so I'm going to turn to all of our investors and say we're turning off our site, we're closing down to ensure that we keep enough product."
(00:21:23):
But honestly, in hindsight, it was a no-brainer. We were not going to run out of product on our current subscribers and we had no idea how long the crisis was going to last. So even though we didn't know how long we'd be off, I gave the thumbs up, sally forth, turn it off, and we went into hibernation mode. And in many ways we switched immediately into our customers come first. We now have 70,000 subscribers who are in a place of panic because they hear the news every day that there's formula running out and our job is to give them confidence and clarity that we have the products for them and we're never going to run out. And we did. For six months, six months, we kept our website off and we didn't grow the business last year and we continued to serve our current subscribers and in the end we became the only formula company that was able to reliably serve its current customers and never run out.

**中文翻译:**
没有什么比危机更能让你体会到未来的机遇了。我每天都心存感激，唯一能积极看待这件事的方式就是：我拥有了一个大多数初创公司等一辈子都等不到的机会。事情是这样的：有一天我醒来，发现美国总统正在谈论婴儿配方奶粉短缺。这又是“在正确的时间出现在正确的地点”。这是一个以前从未被真正提及的话题。不幸的是，其中一家大公司（双头垄断之一）发生了召回事件，那次召回基本上让全国断货，我们无法喂养美国的婴儿。
(00:19:29):
作为这里最小的公司之一，在短缺发生的第一周，我们的客户数量就翻了一番。这一切看起来都很棒，几乎是任何初创公司的梦想——你的产品正在爆发式增长，因为客户正从其他品牌转向你。但问题在于：婴儿配方奶粉是那种你绝对不能断货的产品。断货一点也不酷。它不像家具，你可以有一段时间的产能限制。
(00:20:03):
我们的增长负责人——我再说一次，这姑娘太棒了——她非常仔细地观察着库存水平，也观察着我们的增长速度。我永远不会忘记那一刻，我能想象出那个画面：在一次会议上，她拉出屏幕说：“现在的困境是，我们消耗库存的速度远快于补货的速度，而且客户还在不断涌入。” 你坐在那儿，第一反应是：“这太棒了，我们在增长。” 但她说：“其实没那么好，因为接下来会发生这种情况：我们将没有足够的产品供应给目前正在使用 Bobbie 的宝宝。这是个大问题。”
(00:20:48):
在我消化这一切的时候——再次强调，我们当时才上市 14 个月——我问她：“那么 Shireen，我们下一步该怎么办？” 她说：“大约还有六天，我们就会陷入无法服务那些已经选择 Bobbie 的客户的境地。所以我们需要关闭网站，停止业务增长。” 这是一个重大的决定，你要面对所有的投资者说：“我们要关闭网站，停止新业务，以确保我们有足够的存货。”
(00:21:23):
但坦率地说，事后看来，这是一个显而易见的决定。我们不能让现有的订阅用户断货，而且我们不知道危机还会持续多久。所以即使不知道会关闭多久，我还是批准了，勇往直前，关掉它。我们进入了“冬眠模式”。在很多方面，我们立即切换到了“客户第一”的模式。我们当时有 7 万名订阅用户，他们正处于恐慌中，因为每天都能听到奶粉短缺的新闻。我们的工作是给他们信心和明确的保证：我们有产品供应给他们，永远不会断货。我们做到了。整整六个月，我们关闭了网站，去年没有发展新业务，而是继续服务现有的订阅用户。最终，我们成为了唯一一家能够可靠地服务现有客户且从未断货的奶粉公司。

---

### [00:22:21] [Lenny]

**English:**
That's an amazing story. I haven't heard that before. You threw out this term at some point when we were emailing earlier of slowth, you called it a slowth. Slow growth, I think.

**中文翻译:**
这是一个了不起的故事。我以前没听说过。我们在之前的邮件往来中，你提到了一个词叫“Slowth”，你称之为“Slowth”。我想是指“慢速增长”（Slow growth）。

---

### [00:22:32] [Laura Modi]

**English:**
Oh, my gosh.

**中文翻译:**
噢，天哪。

---

### [00:22:32] [Lenny]

**English:**
Is that how you think about this?

**中文翻译:**
你是这么看待这件事的吗？

---

### [00:22:33] [Laura Modi]

**English:**
That was part of also how do you change the culture internally? I had 60 people on the team who were all in a position of driving growth and many of them were probably only hired weeks before the shortage with the position of growth, email growth, paid acquisition. And all of a sudden you're telling someone who just left a cushy job to join a startup that we're no longer growing. And in fact, your job now is to completely flip what you thought you were going to do on its head. So we named the entire growth team, the slowth team.

**中文翻译:**
这也是如何改变内部文化的一部分。我当时团队里有 60 个人，他们都在负责推动增长，其中许多人可能在短缺发生前几周才被雇佣，岗位是增长、邮件增长、付费获取。突然之间，你告诉一个刚刚离开安逸工作加入初创公司的人，我们不再增长了。事实上，你现在的工作是把你原本计划要做的事情完全颠倒过来。所以我们将整个增长团队（Growth Team）改名为“慢速增长团队”（Slowth Team）。

---

### [00:23:09] [Lenny]

**English:**
That's awesome.

**中文翻译:**
太棒了。

---

### [00:23:09] [Laura Modi]

**English:**
And I mean, they got creative. At some point we were emailing subscribers to nudge them to cancel because we were looking for a way to ensure that we could keep product, and my God, it was a mind-boggling moment.

**中文翻译:**
我是说，他们变得非常有创意。在某些时刻，我们甚至给订阅用户发邮件，暗示他们取消订阅，因为我们在寻找确保能留住产品的方法。天哪，那真是一个令人难以置信的时刻。

---

### [00:23:24] [Lenny]

**English:**
What else did you learn from that period that has either stuck with you in this time and/or is there something maybe you think you would've done differently if you could go back?

**中文翻译:**
在那段时期，你还学到了哪些至今仍让你受益匪浅的东西？或者，如果可以回到过去，你觉得有什么事情你会做得不一样？

---

### [00:23:34] [Laura Modi]

**English:**
Well, I have a personal belief of never looking back and regretting or changing things, but there were definitely some learnings and I would say on the positive end, some of the biggest learnings were just the power of storytelling and bringing the impact of what we were doing back into the company. I'm in a fortunate position as the CEO where, whether I'm speaking to advisors or on panels or engaging the outside world a lot more, I was able to truly feel, I mean, viscerally feel the impact that we were having by doing this.
(00:24:13):
I'll never forget, I was speaking at Davos on this topic and I had a customer. Oh my God, Lenny, this moment. I was standing outside of this events area and this woman comes running up to me and she's bawling, crying, and this is at a global leader's conference and she's crying and she just held my hands. And she's like, "Oh my God, you saved my life over the last year." She's like, "You have no idea the impact that Bobbie played in our lives by making the decision and giving me confidence that you weren't going to run out of product on us."
(00:24:53):
And that emotional connection of just, wow, yes, we may have grown the business faster, we may have gotten product back, but at the end of the day, these 70,000 voices that are out there and the stories that they have and bringing those back to the company, it's undeniable the impact, by making that decision, we've had. And I think the rest of the company feels it, too.

**中文翻译:**
嗯，我个人的信念是永远不回头看，不去后悔或试图改变过去。但确实有一些教训。从积极的一面来看，最大的收获之一就是“讲故事”的力量，以及将我们所做事情的影响力带回公司内部。作为 CEO，我处于一个幸运的位置，无论是在与顾问交谈、参加研讨会，还是更多地与外界接触时，我都能真正感受到——我是说，发自肺腑地感受到——我们这样做所产生的影响。
(00:24:13):
我永远不会忘记，我在达沃斯论坛谈论这个话题时，遇到了一位客户。噢天哪，Lenny，那一刻。我正站在会场外面，一个女人跑向我，她嚎啕大哭。这可是在全球领导人会议上，她哭着握住我的手说：“噢天哪，过去一年你救了我的命。” 她说：“你无法想象 Bobbie 对我们的生活产生了多大的影响，因为你们做出了那个决定，让我有信心你们不会断货。”
(00:24:53):
那种情感连接让我感叹：哇，是的，我们本可以更快地发展业务，本可以拿回产品，但归根结底，这 7 万个声音和他们的故事，以及把这些带回公司，无可否认，我们做出那个决定所产生的影响是巨大的。我想公司里的其他人也感受到了这一点。

---

### [00:25:16] [Lenny]

**English:**
This connects with something we've brought up a couple of times now, which is just brand and brand building. Clearly, it's something that you've spent a lot of energy on and something you've done incredibly well. I think every mom I know knows of Bobbie. By the way, let me just throw this out there. I don't know if I've told you this, but I'm having a kid and we're going to get some Bobbie.

**中文翻译:**
这与我们刚才提到的几次内容有关，即品牌和品牌建设。显然，这是你投入了大量精力并且做得非常出色的事情。我想我认识的每一位妈妈都知道 Bobbie。顺便提一下，我不确定有没有告诉过你，我要有孩子了，我们打算买点 Bobbie。

---

### [00:25:34] [Laura Modi]

**English:**
What?

**中文翻译:**
什么？

---

### [00:25:36] [Lenny]

**English:**
Yep.

**中文翻译:**
是的。

---

### [00:25:37] [Laura Modi]

**English:**
Oh my god, Lenny's going to be a dad. This is so exciting.

**中文翻译:**
噢天哪，Lenny 要当爸爸了。这太令人兴奋了。

---

### [00:25:42] [Lenny]

**English:**
Oh man, this is going to be a whole new direction.

**中文翻译:**
噢伙计，这会是一个全新的方向。

---

### [00:25:44] [Laura Modi]

**English:**
I've got your milk, if you need it, of course, if Michelle's in a position and she wants it, we're here for you.

**中文翻译:**
如果你需要，我这儿有奶粉。当然，如果 Michelle 需要且想要的话，我们随时为你效劳。

---

### [00:25:50] [Lenny]

**English:**
Okay, I appreciate that. We're going to get a deal.

**中文翻译:**
好，非常感谢。我们要达成一笔交易了。

---

### [00:25:53] [Laura Modi]

**English:**
Oh, my God, I'm so excited for you.

**中文翻译:**
噢天哪，我真为你感到高兴。

---

### [00:25:54] [Lenny]

**English:**
Thank you. Laura, I feel like we need some formula just in case, right? Doesn't that-

**中文翻译:**
谢谢。Laura，我觉得我们需要备一些配方奶粉以防万一，对吧？难道不该——

---

### [00:25:58] [Laura Modi]

**English:**
You do. You do. And the rule is you have to try it, as well.

**中文翻译:**
是的，你需要。而且规则是你也得尝尝。

---

### [00:26:02] [Lenny]

**English:**
Oh, okay.

**中文翻译:**
噢，好吧。

---

### [00:26:03] [Laura Modi]

**English:**
Yeah. If baby's going to try it, you need to give it a shot.

**中文翻译:**
是的。如果宝宝要喝，你也得试一下。

---

### [00:26:06] [Lenny]

**English:**
Okay. Okay, okay. Oh, I'll get ready for that. I like that rule. I like that rule. Okay. There's so many things to get used to.

**中文翻译:**
好。好，好。噢，我会做好准备的。我喜欢这个规则。好，有太多事情需要适应了。

---

### [00:26:14] [Laura Modi]

**English:**
We'll talk again.

**中文翻译:**
我们回头再聊。

---

### [00:26:15] [Lenny]

**English:**
Okay, so going back to my question about brand, basically I just want to understand what have you learned about building a brand and when do you think it is important to invest there?

**中文翻译:**
好，回到我关于品牌的问题。基本上我想了解，你在建立品牌方面学到了什么？你认为什么时候投资品牌是重要的？

---

### [00:26:24] [Laura Modi]

**English:**
I mean, it all depends on what your product is, but the first thing I've learned about it is you have to build a brand that connects with what your customers are going through, and the experience. I once had someone say to me, "Think about who your customer is and that one customer, the exact person, is going to wake up tomorrow morning and there's going to be three things that are just playing on them in the back of their mind, the things that keep them up at night. And if you are not solving for one of those, then you're going to be finding a way to build a brand and to get in the way of that, get in the way of their mindset, have them remember who you are or what you're about."
(00:27:06):
And it was very clear to us that everything, from who our brand was, what it stood for, the positioning, needed to be something that parents were really finding as a struggle in that first year in feeding. So you see it in our messaging, you see it in our creative. I have no desire to bombard people with something that isn't part of those top three things that they're experiencing. Otherwise, we will have companies out there and brands out there being loud for no reason. And I think that's continued to help us in every time we have to reframe or relaunch something, to keep remembering what do they care about, let's build a brand for them.

**中文翻译:**
这完全取决于你的产品是什么。但我学到的第一件事是，你必须建立一个能与客户的经历和感受产生共鸣的品牌。曾有人对我说：“想想你的客户是谁，那个具体的客户明天早上醒来时，脑海里会萦绕着三件事，那是让他们彻夜难眠的事。如果你没有解决其中之一，那么你就得想办法建立一个品牌，切入他们的思维模式，让他们记住你是谁，你是做什么的。”
(00:27:06):
对我们来说非常明确的是，从品牌形象、品牌主张到定位，所有的一切都需要针对父母在第一年喂养过程中真正感到挣扎的问题。所以你在我们的文案和创意中都能看到这一点。我不想用那些不属于他们最关心的三件事的东西去轰炸人们。否则，市场上就会充斥着那些无缘无故大声喧哗的公司和品牌。我认为这一直在帮助我们，每当我们不得不重新构思或重新发布产品时，都会不断提醒自己：他们关心什么？让我们为他们建立品牌。

---

### [00:27:48] [Lenny]

**English:**
I really like that. That is such a good reminder of just, you are not going to convince someone they have a problem unless you're just spending endless money hammering into their head there's a new problem you have. If you connect to something they already know is a problem and just make it clear this is a solution to a problem, life gets a lot easier.

**中文翻译:**
我非常喜欢这一点。这是一个很好的提醒：你很难说服别人他们有一个问题，除非你花无穷无尽的钱往他们脑子里灌输“你有一个新问题”。如果你能连接到他们已经知道的问题，并明确表示这是一个解决方案，生活就会变得容易得多。

---

### [00:28:06] [Laura Modi]

**English:**
That's right.

**中文翻译:**
没错。

---

### [00:28:07] [Lenny]

**English:**
Although I know that you also have to kind of fight this breastfeeding-is-best kind of thing. So in a sense you also have to convince people this isn't what you think it is.

**中文翻译:**
虽然我知道你还得对抗那种“母乳喂养最好”的观念。所以从某种意义上说，你还得说服人们，事情并不像他们想象的那样。

---

### [00:28:22] [Laura Modi]

**English:**
Yeah. And then, what's the saying? If you're explaining, you're losing. And I think there's a part of this where there's going to be a large group of people that are always going to be in the mindset that breast is the only way to do it, and anyone who does otherwise is doing second best. And I'm not there to try and convince them. I think a part of this is amplifying those that are in need of our products, that are the 83% using formula and make sure that they feel heard. But that has been a learning. I mean, that's been a huge brand learning. How do you not lean into or amplify the voices that shouldn't be heard and in many ways just get distracted by it?

**中文翻译:**
是的。而且，俗话说得好：如果你在解释，你就已经输了。我认为总会有一大群人坚持认为母乳是唯一的途径，任何其他方式都是退而求其次。我并不打算去说服他们。我认为我的一部分工作是放大那些需要我们产品的人的声音，也就是那 83% 使用配方奶粉的人，并确保他们感到被倾听。这对我来说是一个教训，一个巨大的品牌教训：你如何不被那些不该被放大的声音所左右，或者不被它们分散注意力？

---

### [00:29:19] [Lenny]

**English:**
That's really interesting, and I don't know how much you want to talk about this, but I know initially the brand strategy was basically breast is not best. Formula is just as good. And what I'm hearing is you kind of realized you're not going to convince people of that and it's more lean into people that already understand.

**中文翻译:**
这很有趣。我不知道你想聊多深，但我知道最初的品牌策略基本上是“母乳并非最好，配方奶粉同样好”。而我现在听到的是，你意识到你无法说服所有人，所以更多是倾向于那些已经理解这一点的人。

---

### [00:29:19] [Laura Modi]

**English:**
Yeah. And I think another major belief I have is no brand, and I do fundamentally believe this, no brand should ever be in a position of pointing fingers to something that's better or worse. Our only job, and I wish politics would also do this, our only job is to talk about what we do and why we exist and why we believe our product is good. And I would say the flip is the same in formula. If a mother out there has access to another brand of formula that is more accessible, maybe more affordable, and it suits their baby, then good for them. And I should never be a company in a position pointing to a competitor or another way of feeding saying that it's worse off, ever.

**中文翻译:**
是的。我还有一个核心信念，我深信不疑：任何品牌都不应该指责别的东西更好或更坏。我们唯一的工作——我希望政治也能如此——就是谈论我们在做什么，我们为什么存在，以及为什么我们相信自己的产品是好的。在配方奶粉领域也是如此。如果一位母亲能接触到另一个更方便、更实惠且适合她宝宝的奶粉品牌，那对她来说是好事。我永远不应该作为一个公司去指责竞争对手或另一种喂养方式更糟，永远不。

---

### [00:30:04] [Lenny]

**English:**
Today's episode is brought to you by Assembly AI. If you're looking to build AI-powered features in your audio and video products, then you need to know about Assembly AI, which makes it easy to transcribe and understand speech at scale. What I love about Assembly AI is you can use their simple API to access the latest AI breakthroughs from top-tier research labs. Product team that startups and enterprises are using assembly AI to automatically transcribe and summarize phone calls and virtual meetings, detect topics in podcasts, pinpoint when sensitive content is spoken and lots more.
(00:30:37):
All of Assembly AI's models which are accessed through their API are production ready. So many PMs I know are considering or already building with AI and Assembly AI is the fastest way to build with AI for audio use cases. Now's the time to check out Assembly AI, which makes it easy to bring the highest accuracy transcription plus valuable insights to your customers. Just like Spotify, CallRail and Writer do for theirs. Visit assemblyai.com/lenny to try their API for free and start testing their models with their no-code playground. That's assemblyai.com/lenny.

**中文翻译:**
今天的节目由 Assembly AI 为您带来。如果您想在音频和视频产品中构建 AI 驱动的功能，那么您需要了解 Assembly AI。它能让大规模转录和理解语音变得轻而易举。我喜欢 Assembly AI 的一点是，您可以使用他们简单的 API 来访问顶级研究实验室的最新 AI 突破。初创公司和企业的跨国产品团队正在使用 Assembly AI 自动转录和总结电话及虚拟会议、检测播客中的话题、精确定位敏感内容被提及的时刻等等。
(00:30:37):
Assembly AI 所有通过 API 访问的模型都是生产就绪的。我认识的许多 PM 都在考虑或已经在使用 AI 进行构建，而 Assembly AI 是在音频用例中利用 AI 进行构建的最快方式。现在是了解 Assembly AI 的最佳时机，它可以轻松地为您的客户带来最高精度的转录和有价值的洞察，就像 Spotify、CallRail 和 Writer 所做的那样。访问 assemblyai.com/lenny 免费试用他们的 API，并在他们的无代码游乐场（No-code playground）中开始测试他们的模型。地址是 assemblyai.com/lenny。

---

### [00:31:13] [Lenny]

**English:**
Something else I heard about the way you operate is you, speaking of brand, is you brand internal things. Can you just talk about what that's all about?

**中文翻译:**
关于你的运营方式，我还听说了一件事，说到品牌，你会给内部事务也打上品牌。你能聊聊那是怎么回事吗？

---

### [00:31:21] [Laura Modi]

**English:**
Oh, my God. This is, I feel, like a secret sauce of just how to get it done half the time. And I really, really do believe the power of branding the mundane is so successful. I mean, we brand, to be fair, I actually feel like that this was a page out of the Airbnb book. Do you remember going back early days when we were doing customer service deep dives? What were the issues that customers were having? And we branded a program called Air Dives. Do you remember Air Dives?

**中文翻译:**
噢天哪。我觉得这是事半功倍的“秘密武器”。我真的非常相信给平凡琐碎的事情打上品牌标签的力量。公平地说，我觉得这是从 Airbnb 那里学到的一招。你还记得早期我们做客户服务深度调研（Deep dives）的时候吗？客户遇到了什么问题？我们把那个项目命名为“Air Dives”。你还记得 Air Dives 吗？

---

### [00:31:56] [Lenny]

**English:**
Yeah.

**中文翻译:**
记得。

---

### [00:31:57] [Laura Modi]

**English:**
And this program just became this thing where everyone wanted to know on a Friday what was the latest Air Dive. And really what an Air Dive was was an analysis of customer service tickets and customer service pain points. But how much better is Air Dive than a customer service analysis? So much better. So I think a lot of learnings on just the power of branding and storytelling your workflows and your frameworks and what it means to do your job, often keeps people motivated, too. And it creates memory recall a lot better, too. So now when you prefer Slack channels, they're all like, I don't even want to name them because I'm going to give you-

**中文翻译:**
这个项目后来变成了一件大家周五都想关注的事，想知道最新的“Air Dive”是什么。实际上，Air Dive 就是对客服工单和客服痛点的分析。但“Air Dive”听起来是不是比“客服分析”好得多？好太多了。所以我认为，给你的工作流程、框架以及工作内容打上品牌并讲好故事，通常也能让人们保持动力。而且它能让人记忆更深刻。所以现在如果你看我们的 Slack 频道，它们都像……我甚至不想说出它们的名字，因为我会给你——

---

### [00:32:43] [Lenny]

**English:**
No, I was going to ask. I'd love some examples and I know they're going to sound ridiculous to an outsider, but what are some examples of things? And you can say like Bobbie Blank, or what's your naming convention?

**中文翻译:**
不，我正想问呢。我很想听几个例子，我知道对局外人来说可能听起来很荒谬，但有哪些例子？你可以说像“Bobbie 某某”，或者你们的命名习惯是什么？

---

### [00:32:52] [Laura Modi]

**English:**
Oh, my God. Project Shamrock. I'm not going to tell you what that's about. Project Lumberjack. Ooh, Got B 2022. I can give you so much insight into what these are and I'll give you an example of it. We have legal approvals that need to get made and these legal approvals on content claims have to happen. And I was like, okay, well how do we make sure everyone sticks to the quality SOP that legal wants set for all of the claims we have to have in place? So we created a program called the Secret Shopping Program, and our regulatory legal team go out and they do their own secret shopping once a month and then they report back on any misleading claims or ones that aren't fully understood that Bobbie needs to go back and update. But having a secret shopping meeting is very different to potentially coming in and listening to legal report out in your claims mishaps.

**中文翻译:**
噢天哪。“三叶草项目”（Project Shamrock），我不会告诉你那是关于什么的。“伐木工项目”（Project Lumberjack）。噢，“Got B 2022”。我可以告诉你很多关于这些项目的内幕，我给你举个例子。我们需要进行法律审批，尤其是关于内容声明（Content claims）的法律审批。我在想，好吧，我们如何确保每个人都遵守法务部门为所有声明制定的质量标准作业程序（SOP）？于是我们创建了一个名为“神秘顾客计划”（Secret Shopping Program）的项目。我们的监管法务团队每月会进行一次自己的“神秘购物”，然后反馈任何误导性声明或理解不透彻的地方，Bobbie 需要据此进行更新。但是，参加一个“神秘购物会议”的感觉，与听取法务部门报告你的声明失误，感觉是完全不同的。

---

### [00:33:59] [Lenny]

**English:**
Speaking of legal mishaps and copy nuances, one of my favorite memories of you is I was in San Francisco on Divisadero outside, I think, The Mill, and you were just running by heading somewhere and we started chatting. You were heading, I believe, to the warehouse that you're manufacturing the early versions of Bobbie, and apparently the FDA showed up and shut you down because of some misleading communication in the news, as you're launching. I'd love to hear that story because I love it.

**中文翻译:**
说到法律失误和文案细微差别，我对你最深刻的记忆之一是：当时我在旧金山的 Divisadero 街，好像是在 The Mill 咖啡馆外面，你正匆忙跑向某个地方，我们聊了起来。我记得你当时正要去生产 Bobbie 早期版本的仓库，显然 FDA（美国食品药品监督管理局）找上门来，因为你们发布时在新闻中存在一些误导性沟通，把你们关停了。我很想听听那个故事，因为我觉得太精彩了。

---

### [00:34:26] [Laura Modi]

**English:**
By the way, how you just transitioned from one example I just gave to that was absolutely exceptional, speaking of content mishaps.

**中文翻译:**
顺便说一句，你从我刚才举的例子过渡到那个故事的方式简直绝了，说到内容失误。

---

### [00:34:40] [Lenny]

**English:**
I appreciate that.

**中文翻译:**
过奖了。

---

### [00:34:42] [Laura Modi]

**English:**
This is why you're such a good podcast host, Lenny.

**中文翻译:**
这就是为什么你是一个如此优秀的播客主持人，Lenny。

---

### [00:34:44] [Lenny]

**English:**
You're so kind.

**中文翻译:**
你太客气了。

---

### [00:34:44] [Laura Modi]

**English:**
You're so good.

**中文翻译:**
你真的很棒。

---

### [00:34:45] [Lenny]

**English:**
Thank you, Laura.

**中文翻译:**
谢谢你，Laura。

---

### [00:34:46] [Laura Modi]

**English:**
Oh, my god, that moment. I do remember bumping into you. I was in an identity crisis. Yeah, early days. I think the one big learning I've had is that when you're in an industry where you are disrupting, I mean truly disrupting the status quo, you're going to be met with some reactions, people, or in our case government agencies who aren't happy about what you're doing. It was early days, we just launched a pilot and the FDA showed up at our warehouse and they didn't like the way that we were labeling the product. We had to pull all of our product from the market, we had to relabel everything and we had to work with the agency for another year before we could bring our products back. For startup world, that was a huge, I wouldn't even say it was a pivot, it was a patient pause, thinking sure that we could get back on track and build intentions with the FDA again.

**中文翻译:**
噢天哪，那一刻。我确实记得撞见你。当时我正处于身份危机中。是的，早期阶段。我想我学到的一个重要教训是，当你处于一个你正在颠覆——我是说真正颠覆现状——的行业时，你会遇到一些反应，有些人，或者在我们的案例中是政府机构，会对你的所作所为感到不满。那是早期阶段，我们刚启动试点，FDA 就出现在我们的仓库，他们不喜欢我们给产品贴标签的方式。我们不得不从市场上撤回所有产品，重新贴标，并与该机构合作了一年，才重新将产品推向市场。对于创业界来说，这是一个巨大的……我甚至不会说它是转型（Pivot），而是一个耐心的暂停，确保我们能回到正轨并重新与 FDA 建立互信。

---

### [00:35:45] [Lenny]

**English:**
Another example of slowth, maybe.

**中文翻译:**
也许是“慢速增长”（Slowth）的另一个例子。

---

### [00:35:47] [Laura Modi]

**English:**
Another example of slowth, yes.

**中文翻译:**
是的，另一个例子。

---

### [00:35:49] [Lenny]

**English:**
How did you personally stay motivated and keep morale up within the company during that period?

**中文翻译:**
在那段时期，你个人是如何保持动力并维持公司内部士气的？

---

### [00:35:55] [Laura Modi]

**English:**
Well, I found out I was pregnant with my third child right after.

**中文翻译:**
嗯，紧接着我就发现自己怀了第三个孩子。

---

### [00:35:59] [Lenny]

**English:**
Super.

**中文翻译:**
太棒了。

---

### [00:36:01] [Laura Modi]

**English:**
There is something about also growing your personal life while professionally it's happening. There's a little bit of give and take as well. So sometimes in moment of professional slowth, you might find that there's personal growth. That's exactly what I found. So I mean, yeah, during this journey I went on from being inspired by my first kid where I wasn't able to breastfeed and then had two more along the journey. And I don't know, I've actually never spoken about this, but I do think there's a beautiful marriage in that personal and professional growth that you can have and you kind of need to find moments where you lean into one and maybe the other. And then there's moments, like I kind of feel like I'm going through right now, where both of them are just on fire and you can't slow them down.

**中文翻译:**
在职业生涯发生变动的同时，个人生活也在成长，这其中有一种奇妙的联系。这是一种取舍。所以有时在职业上的“慢速增长”期，你可能会发现个人生活在成长。这正是我所经历的。我是说，在这段旅程中，我从第一个孩子（当时我无法母乳喂养）那里获得灵感，然后一路上又有了两个孩子。我以前从未谈论过这个，但我确实认为个人成长和职业成长之间有一种美妙的结合，你需要找到那些时刻，有时侧重于这一面，有时侧重于那一面。然后有些时刻，就像我现在感觉的那样，两者都在全速前进，你根本无法让它们慢下来。

---

### [00:36:44] [Lenny]

**English:**
It might be a good time to chat about that. So you have this fast-growing business, you have three kids. Your partner is also a founder, also very busy. How do you manage all of these things?

**中文翻译:**
现在聊这个可能正是时候。你有一家快速增长的公司，有三个孩子。你的伴侣也是创始人，也非常忙。你是如何管理这一切的？

---

### [00:36:59] [Laura Modi]

**English:**
That question is actually probably the most common question I get from new founders, those that are aspiring entrepreneurs, on just like how do you do it all? I mean, a lot of it's your infrastructure, it's your... Actually, hold on a second. I'm going to do something I don't think you've done on a podcast before. Hold on. This is my EA. I'm going to pull this woman in. Everyone just needs to say hi to Kendra. This woman.

**中文翻译:**
这个问题可能是我从新创始人、那些有抱负的企业家那里听到的最常见的问题：你是如何兼顾所有的？我的意思是，很大程度上取决于你的基础设施，你的……事实上，等一下。我要做一件我想你以前在播客里没做过的事。等一下。这是我的行政助理（EA）。我要把她拉进来。大家跟 Kendra 打个招呼。就是这位女士。

---

### [00:37:25] [Lenny]

**English:**
Hi, Kendra.

**中文翻译:**
嗨，Kendra。

---

### [00:37:28] [Laura Modi]

**English:**
I'm introducing her because the power of a support system to be able to do what you do, I mean, you are an extension, my leverage, my everything. And never leave.

**中文翻译:**
我介绍她是因为，要做到你所做的事情，支持系统的力量至关重要。我是说，你就是我的延伸，我的杠杆，我的一切。千万别离开。

---

### [00:37:42] [Kendra]

**English:**
I'm not going anywhere.

**中文翻译:**
我哪儿也不去。

---

### [00:37:43] [Laura Modi]

**English:**
I'd be so screwed. And everyone should not only know the power and leverage of their person, but the level of appreciation and celebration you need to have for them is just huge.

**中文翻译:**
（要是你走了）我就完蛋了。每个人不仅应该知道身边人的力量和杠杆作用，而且你对他们的感激和赞赏程度也应该是巨大的。

---

### [00:37:56] [Kendra]

**English:**
I always feel celebrated, so thank you. I appreciate it.

**中文翻译:**
我一直感到被重视，所以谢谢你。我很感激。

---

### [00:37:59] [Lenny]

**English:**
How do people find a Kendra of their own? That's the million-dollar question.

**中文翻译:**
人们如何找到属于自己的 Kendra？这是一个价值百万美元的问题。

---

### [00:38:02] [Laura Modi]

**English:**
Well, first, you don't take this one. This is a poach-free podcast.

**中文翻译:**
首先，你不能抢走这一个。这是一个“禁止挖角”的播客。

---

### [00:38:02] [Lenny]

**English:**
Her name Lauren, not-

**中文翻译:**
她的名字叫 Lauren，不是——

---

### [00:38:10] [Laura Modi]

**English:**
Yes, that's right.

**中文翻译:**
是的，没错。

---

### [00:38:11] [Kendra]

**English:**
We should have code names.

**中文翻译:**
我们应该用代号。

---

### [00:38:12] [Laura Modi]

**English:**
There is no last names here. How do you find your Kendra? I will say it took multiple interviews and it's all about chemistry. I think it's about chemistry and finding somebody that you genuinely care about. I genuinely care about you, your heart, your kids, your family, and I think finding that connection is really important.

**中文翻译:**
这里没有姓氏。如何找到你的 Kendra？我想说这需要多次面试，而且全看化学反应。我认为是化学反应，以及找到一个你真正关心的人。我真心关心你，关心你的内心、你的孩子、你的家庭，我认为找到这种连接非常重要。

---

### [00:38:36] [Kendra]

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:38:37] [Laura Modi]

**English:**
Yeah. You know what's also funny, too, I think there's this feeling, and I would hear this from folks, how do you do it all? And I think we also just need to be very transparent. It takes a lot of work to do it all. I, as an operator, am very proud of the infrastructure I have built. I mean, we have calendars on our walls, we have calendars for our kids. We have back and forth birthday planning. It's additional help in the house. My nanny is the other extension in our house.
(00:39:10):
I mean, I don't know what we would do without Clifford. He is everything for us and I also have to see him as an extension to our parenting. But that is, I think, the only way to get through the chaos and the only way to embrace the all, is you actually need to put in the work to build the infrastructure, the systems, the frameworks, and then every month, or sometimes in our case on a weekly basis, me and my husband, we have a meeting every Sunday and it's walking through the agendas. Who's going to what TaeKwonDo classes this week? Or who's trading off on birthday parties or parent-teacher meetings. Because you're right, a dual CEO-founder household and three kids, it will age you fast if you don't have it.

**中文翻译:**
是的。还有件有趣的事，我常听人们问：你是怎么兼顾所有的？我认为我们也需要非常坦诚：要兼顾所有需要付出巨大的努力。作为一名运营者，我对我建立的基础设施感到非常自豪。我是说，我们墙上有日历，孩子们也有日历。我们有来回沟通的生日计划。家里还有额外的帮手。我的保姆是我们家庭的另一个延伸。
(00:39:10):
我是说，如果没有 Clifford，我不知道该怎么办。他对我们来说就是一切，我也必须把他看作是我们育儿工作的延伸。但我认为，度过混乱并拥抱一切的唯一方法，就是你真的需要投入精力去建立基础设施、系统和框架。然后每个月，或者像我们家是每周，我和丈夫每周日都会开个会，过一遍日程。这周谁去上跆拳道课？谁去参加生日派对或家长教师会议？因为你说得对，一个有两个 CEO 创始人的家庭加上三个孩子，如果没有这些，你会老得很快。

---

### [00:39:58] [Lenny]

**English:**
It also makes me think a little bit about what you talked about earlier where, when things slow down a little bit in the business, there's an opportunity to lean into that part of life and then kind of get ahead on some stuff, in theory.

**中文翻译:**
这也让我想到你之前提到的，当业务稍微放缓时，就有机会投入到生活的那一部分，理论上可以在某些事情上取得进展。

---

### [00:40:09] [Laura Modi]

**English:**
Totally, totally.

**中文翻译:**
完全正确，完全正确。

---

### [00:40:11] [Lenny]

**English:**
In terms of the business, I imagine you never started a D2C business before this. Also, you mentioned you've never formulated a baby formula prior to this. Clearly, it's working out. What's a lesson there of just doing something you've never done? Is that something you imagined is a good idea? Maybe looking back, maybe it doesn't matter. What have you learned about just this idea of doing something totally new and different?

**中文翻译:**
就业务而言，我猜你以前从未创办过 D2C 企业。而且，你也提到在此之前从未研发过婴儿配方奶粉。显然，现在进展顺利。做一件从未做过的事情，有什么教训吗？你觉得这是一个好主意吗？也许回过头来看，这并不重要。关于“做一些完全新鲜和不同的事情”这个想法，你学到了什么？

---

### [00:40:34] [Laura Modi]

**English:**
I think one of the biggest beliefs is that an ounce of naivety will be your biggest secret to success. And I think the word even naivety sometimes gets a bad rap, but naivety is the definition of creativity and innovation and canvas and white space and opportunity. And I definitely went into starting this company with a level of naivety to how regulated it was, to the stigma associated with it, to how hard it would be. But that has allowed me to continue to look at the status quo differently.
(00:41:15):
I don't, because I don't fully understand it, and I have applied those same principles even into how I hire people because I do think... I'm now wondering who's going to watch this on my team, because obviously we have some specialists, but this is generalists who make the world go round. I think sometimes putting the most unlikely people who have an ounce of naivety to what it takes to win and succeed are the ones that are going to drive the biggest impact.

**中文翻译:**
我认为最大的信念之一是：一点点“天真”（Naivety）将是你成功的最大秘诀。我觉得“天真”这个词有时会被贬义化，但天真其实是创造力、创新、画布、留白和机遇的代名词。我在创办这家公司时，确实对它的监管程度、相关的负面标签以及它的难度抱有一种天真。但正是这种天真让我能够持续以不同的眼光看待现状。
(00:41:15):
因为我不完全了解它，我也把同样的原则应用到了招聘上。因为我确实认为……我现在在想团队里谁会看这个，因为显然我们有一些专家，但正是通才（Generalists）让世界运转。我认为有时把那些最不可能的人放在岗位上，他们对获胜和成功所需的条件保有一丝天真，反而能产生最大的影响。

---

### [00:41:45] [Lenny]

**English:**
I love that. And it makes me think of a couple of things that I'll just share real quick. One is I was listening to an interview with Mr. Beast who is the number one YouTube creator on TikTok. I think he's got the biggest TikTok, and he talked about how he's got this business he's building, which is like a new way of creating content. And anytime he hires someone from a traditional Hollywood movie-making established kind of background, he's like, "They know what they're doing. They're going to help me legitimize this thing, make it scale." He's like, "Every time, they never work out. They just don't see what we're doing here. They don't understand how this is different and they just slow everything down." And he finds just finding really young, hungry, hardworking people that can learn and understand what he's done end up working a lot better.

**中文翻译:**
我喜欢这个观点。这让我想起两件事，我快速分享一下。一是我听过 Mr. Beast（YouTube 第一大创作者）的采访。他谈到他正在建立的业务，这是一种全新的内容创作方式。每当他雇佣具有传统好莱坞电影制作背景的人时，他会想：“他们知道自己在做什么，他们会帮我让这件事变得正规化、规模化。” 但他说：“每一次，他们都行不通。他们根本看不懂我们在做什么，不明白这有什么不同，他们只会拖慢一切。” 他发现，找那些非常年轻、饥渴、勤奋、能够学习并理解他所做事情的人，最终效果要好得多。

---

### [00:42:27] [Laura Modi]

**English:**
Always.

**中文翻译:**
总是如此。

---

### [00:42:28] [Lenny]

**English:**
The other interesting insight is I'm doing a series right now on B2B businesses and how the biggest B2B companies started and so far I'm finding 70% of the founders had no specific background or skill in the area. They went in to say it's security or sales or something like that. So there's a lot of examples of this.

**中文翻译:**
另一个有趣的见解是，我正在做一个关于 B2B 业务以及最大的 B2B 公司如何起步的系列。到目前为止，我发现 70% 的创始人并没有该领域的特定背景或技能。他们进入了安全、销售或类似的领域。所以这方面有很多例子。

---

### [00:42:48] [Laura Modi]

**English:**
I'll give you one example of someone who's in C who's just an absolute rockstar. Our girl who leads marketing is an Emmy Award news anchor. She's not your traditional marketer. She came in asking me to... She was like, "What does CAC mean? Do we need to look at this LTV number?" And the reason I wanted her in C was because she was the complete antithesis to what we would normally define as a good performance marketer. I wanted someone in C who got media, who got brand and storytelling, and she operates like a news anchor. And in many ways I would look to the team that she's built and think that we maybe have more of a media company than we do a marketing team. And that has been the fuel for the brand that you see today, 100%. And then you hire, unlike the people in those positions and especially senior positions, they're going to do exactly the same throughout the business as well.

**中文翻译:**
我给你举个例子，我们公司里有一位绝对的明星。我们负责营销的姑娘曾是艾美奖新闻主播。她不是传统的营销人员。她进来时问我：“CAC（获客成本）是什么意思？我们需要看 LTV（终身价值）这个数字吗？” 我之所以想要她，是因为她与我们通常定义的优秀绩效营销人员完全相反。我想要一个懂媒体、懂品牌和讲故事的人，而她的运作方式就像新闻主播。在很多方面，我看她建立的团队，觉得我们更像是一家媒体公司，而不是营销团队。这 100% 是你今天看到的品牌的动力源泉。当你雇佣了与传统岗位要求不同的人，尤其是高管职位，他们也会在整个业务中推行这种做法。

---

### [00:43:53] [Lenny]

**English:**
That is really interesting. It makes me think of Airbnb a bit. Also, the browser company. We had the founder of that company on here and they have a storytelling team within their company. Their job is tell the story.

**中文翻译:**
这真的很有趣。这让我想起了 Airbnb。还有 The Browser Company。我们请过那家公司的创始人，他们公司内部有一个“讲故事团队”。他们的工作就是讲好故事。

---

### [00:44:01] [Laura Modi]

**English:**
I love that.

**中文翻译:**
我喜欢这个。

---

### [00:44:03] [Lenny]

**English:**
So you talked about how you're hiring people that aren't necessarily deep in a specific skill that you need them to do. What is it that you look for instead that you think is important for them to figure out what they need to be doing?

**中文翻译:**
你谈到你雇佣的人不一定精通你要求他们做的特定技能。那你寻找的是什么？你认为什么是让他们弄清楚自己需要做什么的关键？

---

### [00:44:15] [Laura Modi]

**English:**
Curiosity. A lot of curiosity and just openness to what's out there. I definitely look for people who have the ability to make decisions and move fast and not get worried about the outcome. That is the biggest learning in a startup. The secret is momentum and just keeping momentum. And if we try and perfect everything, you just miss the boat. And I believe that, what's the common saying, perfect is the enemy of good, or something.

**中文翻译:**
好奇心。强烈的好奇心，以及对外界事物的开放态度。我肯定会寻找那些有能力做决定、行动迅速且不担心结果的人。这是在初创公司学到的最大教训。秘诀在于势头（Momentum），并保持这种势头。如果我们试图完善一切，就会错失良机。我相信那句俗话：完美是优秀的敌人（Perfect is the enemy of good）。

---

### [00:44:52] [Lenny]

**English:**
Yeah, I think that's the one.

**中文翻译:**
是的，我想就是这句。

---

### [00:44:54] [Laura Modi]

**English:**
I mean, it really is. So I look for people who just want to do it, just get it done. Again, part of that is just rolling up your sleeves and not questioning your job. When I find in interviews and people are really questioning the lanes they're going to be in and the job they're going to do, or "I don't do that." That's saying, "I don't do that." A huge flag. You do do it. If you're joining this company, if you're within a certain work stream or a certain department and you're behind what the company's working on, in many ways we need people who do do that. So I look for just optimistic doers.

**中文翻译:**
确实如此。所以我寻找的是那些只想去做、只想把事情办成的人。再说一次，其中一部分就是卷起袖子干活，不去质疑你的工作范围。当我在面试中发现人们一直在纠结自己属于哪个赛道、要做什么工作，或者说“我不做那个”时，这就是一个巨大的警示信号。你必须做。如果你加入这家公司，如果你在某个工作流或部门，并且你支持公司的目标，那么在很多方面我们需要的是愿意动手的人。所以我寻找的是“乐观的实干家”。

---

### [00:45:32] [Lenny]

**English:**
I love that. That's such a cool phrase of how to simplify it, what you want to hire and just optimistic doers. There's so many people that have big ideas and pontificate strategy, and you just need people doing the thing.

**中文翻译:**
我喜欢这个。这是一个很酷的短语，简化了你的招聘标准：乐观的实干家。有太多人空有大想法、夸夸其谈战略，而你只需要真正做事的人。

---

### [00:45:44] [Laura Modi]

**English:**
100%. I call it intellectual ejaculation, which, if that's not allowed of the podcast, [inaudible 00:45:52] totally wiped.

**中文翻译:**
100% 正确。我称之为“思想上的过度宣泄”（Intellectual ejaculation）。如果播客里不允许这么说，那就把它删掉。

---

### [00:45:52] [Lenny]

**English:**
That's allowed. I'll allow it.

**中文翻译:**
允许，我准了。

---

### [00:45:55] [Laura Modi]

**English:**
Thank you.

**中文翻译:**
谢谢。

---

### [00:45:57] [Lenny]

**English:**
Okay, so you're talking about momentum. I want to talk about growth. A lot of this podcast is about growth strategy, how companies grow. You're building a D2C company. D2C is really hard. There's been so many attempts. Most fail, most people can't figure out how to do it scalably. So many challenges. What have you learned about growing D2C company? What's worked well for you?

**中文翻译:**
好，你谈到了势头。我想聊聊增长。这个播客的很多内容都是关于增长策略、公司如何增长。你正在建立一家 D2C（直接面向消费者）公司。D2C 真的很难。有太多的尝试，大多数都失败了，大多数人弄不清楚如何规模化。挑战重重。关于发展 D2C 公司，你学到了什么？什么对你有效？

---

### [00:46:17] [Laura Modi]

**English:**
This narrative of D2C isn't working, or D2C is over, D2C is dead. It kills me. Because we're being way too reductionist in that message. D2C isn't dead. Just the approach for how people did D2C is a bit dated. We should not be paying for every customer and we should be very careful that people aren't getting hooked on the drug that is paid marketing or performance marketing. And I think that drug, and then obviously as we start to see changes on the way certain performance works, it just becomes more expensive and people are resetting how they do performance marketing. The short of it is D2C is not dead. How you drive people to D2C, how you acquire customers, how you build sustainable businesses, that needs to change.

**中文翻译:**
那种“D2C 行不通了”、“D2C 时代结束了”或者“D2C 已死”的说法，简直让我抓狂。因为这种说法太片面了。D2C 没死，只是人们做 D2C 的方式过时了。我们不应该为每一个客户付费，我们应该非常小心，不要让人们对“付费营销”或“绩效营销”这种毒药上瘾。我认为这种毒药，再加上显然我们开始看到某些绩效运作方式的变化，它只会变得越来越贵，人们正在重新设定他们做绩效营销的方式。简而言之，D2C 没死。你如何吸引人们关注 D2C，如何获取客户，如何建立可持续的业务，这些才是需要改变的。

---

### [00:47:14] [Lenny]

**English:**
And what is it that you've done that allows you to do that? I imagine a lot of it is word-of-mouth, which everyone always wants. "How do we do more word-of-mouth?" So what's worked? How do you do that?

**中文翻译:**
那你做了什么让你能做到这一点？我猜很大程度上是口碑（Word-of-mouth），这是每个人都想要的。“我们如何获得更多口碑？” 那么什么有效？你是怎么做的？

---

### [00:47:24] [Laura Modi]

**English:**
Well, I mean, the three major pieces of it is that the focus on commerce, content and community.

**中文翻译:**
嗯，我是说，它的三个主要组成部分是关注商业（Commerce）、内容（Content）和社区（Community）。

---

### [00:47:30] [Lenny]

**English:**
Commerce, content and community.

**中文翻译:**
商业、内容和社区。

---

### [00:47:33] [Laura Modi]

**English:**
So commerce, content and community. But most D2C businesses have put commerce at the top of their list. We flipped it. It's now content, community and commerce, and building good content that is really smart SEO, that has the ability to drive people back to your site to be able to build you as a thought leader. That's really hard and it takes a lot of work. As an example, five years ago we started a platform called Milk Drunk, separate to Bobbie. Milk Drunk Blog. And the reason why we started it is because we realize that there was a dearth of education in the world of formula out there.
(00:48:15):
And what people were really looking for was good recommendations, usability charts, how to make formula, how long does formula last? So we wanted to become the content leaders in that, with the hypothesis, and it's holding true five years later, with the hypothesis that if we win on content and as a thought leader, that will drive back to Bobbie. And today I'm going to give you a totally random example. If you do a cursory Google search for something like "How long does formula last?" Milk Drunk is showing up between the CDC and the bum on the first page of Google? That SEO work and that content building and thought leadership and credibility does take a lot of work. And in the meantime, I've had to squat away requests to put another 100,000, another 300,000 every month into paid marketing because the moment that drug starts, it's very easy to keep it going.

**中文翻译:**
商业、内容和社区。但大多数 D2C 企业把“商业”放在首位。我们把它颠倒过来了。现在是“内容、社区和商业”。建立好的内容，配合非常聪明的 SEO（搜索引擎优化），能够吸引人们回到你的网站，并把你塑造成思想领袖。这非常难，需要投入大量工作。举个例子，五年前我们建立了一个名为 Milk Drunk 的平台，独立于 Bobbie。Milk Drunk 博客。我们建立它的原因是，我们意识到奶粉领域的教育非常匮乏。
(00:48:15):
人们真正寻找的是好的建议、使用图表、如何冲泡奶粉、奶粉能保存多久？所以我们想成为这方面的内容领导者。我们的假设是——五年后证明这个假设是正确的——如果我们赢得了内容并成为思想领袖，这就会反哺 Bobbie。今天我给你举个随意的例子：如果你在 Google 上搜索“奶粉能放多久？”，Milk Drunk 会出现在 Google 第一页，排在 CDC（疾控中心）和 The Bump 网站之间。这种 SEO 工作、内容建设、思想领导力和公信力确实需要大量工作。与此同时，我不得不拒绝每月再投入 10 万或 30 万美元到付费营销的请求，因为一旦这种“毒瘾”开始，就很难停下来。

---

### [00:49:15] [Lenny]

**English:**
I think Airbnb is a great example of that. During COVID, they shut down paid growth and I think they've turned it on, but it's a tiny component, which is really unusual and really rare, where you have paid growth, you're sending tons of money, Facebook, and then you stop. It's so hard to stop because growth slows and no one ever wants to do that. And it's interesting, coming back to using a crisis as an opportunity, Airbnb use that as an opportunity to get off that drug.

**中文翻译:**
我认为 Airbnb 就是一个很好的例子。在新冠期间，他们停止了付费增长。我想他们后来又开启了，但只占很小一部分。这非常不寻常且罕见：你原本有付费增长，给 Facebook 投了大量的钱，然后你停下来了。停下来很难，因为增长会放缓，没人想看到那样。有趣的是，回到“利用危机作为机遇”这一点，Airbnb 利用那次机会戒掉了那种“毒瘾”。

---

### [00:49:40] [Laura Modi]

**English:**
That's right. Yeah.

**中文翻译:**
没错。是的。

---

### [00:49:42] [Lenny]

**English:**
If you think about the pie chart of what helps Bobbie grow, how much of it would you say is just like make an awesome product that people talk about with other moms and it spreads like that, versus SEO and content and paid?

**中文翻译:**
如果你思考一下助力 Bobbie 增长的饼图，你觉得有多少是归功于“做一个很棒的产品，让妈妈们互相传颂”，又有多少是归功于 SEO、内容和付费营销？

---

### [00:49:55] [Laura Modi]

**English:**
60% of it is your product and the package around the product, which is your brand. So even if you did nothing to market your brand, your product and brand is 60% of it. And then the last 40% is how do you get the word out there? How do you ensure the word-of-mouth, mom begets mom? That has to happen. That flywheel will only happen if they're able to look at a product that they fully believe in and a brand that speaks to them. And without that, you're going to be a fast-fashion company, which is also my worst nightmare, the fear that people get distracted by the 40% and the 60% actually is just mediocre.

**中文翻译:**
60% 取决于你的产品以及围绕产品的包装，也就是你的品牌。所以即使你什么营销都不做，产品和品牌也占了 60%。剩下的 40% 是你如何把名声传出去？你如何确保口碑传播，让“妈妈带来妈妈”？这必须发生。只有当用户看到一个他们完全信任的产品和一个能引起共鸣的品牌时，飞轮效应才会产生。如果没有这些，你就会变成一家快时尚公司，那也是我最大的噩梦：担心人们被那 40% 的营销分散了注意力，而那 60% 的核心产品其实很平庸。

---

### [00:50:43] [Lenny]

**English:**
Something I wasn't planning to ask, but I thought it'd be interesting and we can cut this if it's not interesting, is Emily Oster, she's one of the, I think, pioneers of breastfeeding is not as great as people say necessarily. Has that been really important to Bobbie in this industry? What do you think of Emily Oster? I'm a huge fan, so I hope you're also a big fan.

**中文翻译:**
有一件事我本来没打算问，但我觉得很有趣（如果不感兴趣我们可以剪掉），那就是 Emily Oster。我认为她是“母乳喂养未必像人们说的那么神奇”这一观点的先驱之一。这对 Bobbie 在这个行业的发展重要吗？你觉得 Emily Oster 怎么样？我是她的超级粉丝，希望你也是。

---

### [00:51:01] [Laura Modi]

**English:**
We are massive fans of Emily and Emily's a massive fan of Bobbie. She is my idol. She's the one who got me through my first year of pregnancy and then beyond. She has been a really, really important voice. And actually she has kind of set the stage for the power of data to bust myths. I mean, just like you said, she's come out and said, "There is no study, no study at all out there that you can point to that can qualify why breastfeeding is better." And to have an economist, a professor, come out and to be able to underscore that and point to where that is the case and why it is the case. I mean, it's so much better than a company. To be fair, companies are brands coming out trying to say that. So I am acutely aware that, as a business and as a brand, sometimes we need to bring in other credible voices. And my God, Emily is one of those.

**中文翻译:**
我们是 Emily 的超级粉丝，Emily 也是 Bobbie 的超级粉丝。她是我的偶像。是她帮我度过了怀孕的第一年以及之后的时光。她一直是一个非常、非常重要的声音。实际上，她为利用数据的力量打破神话奠定了基础。就像你说的，她站出来说：“没有任何一项研究，完全没有任何研究能证明为什么母乳喂养更好。” 让一位经济学家、一位教授站出来强调这一点，并指出事实及其原因，这比一家公司站出来说要好得多。公平地说，公司只是试图推销观点的品牌。所以我敏锐地意识到，作为一个企业和品牌，有时我们需要引入其他可靠的声音。天哪，Emily 就是其中之一。

---

### [00:52:05] [Lenny]

**English:**
I love it. Okay, great. I'm glad. I'm glad you love her. I've been reading all our books. I think I just read that section.

**中文翻译:**
太棒了。好，太好了。我很高兴你喜欢她。我一直在读她所有的书。我想我刚读完那一章节。

---

### [00:52:11] [Laura Modi]

**English:**
You read her books. I love it. You're not a dad yet, you'll like all of them, Family Firm.

**中文翻译:**
你读她的书，我喜欢。你还没当爸爸，你会喜欢她所有的书的，比如《家庭公司》（Family Firm）。

---

### [00:52:14] [Lenny]

**English:**
Okay, the first two. The first two. Cribsheet. I'll stop there, I think. And I was actually just reading the breastfeeding section and it's funny, one of the only remaining benefits of breastfeeding is less cow farts and creating methane. Unrelated to your child, there's a cow component.

**中文翻译:**
好，前两本。前两本，《养育数据》（Cribsheet）。我想我就读到这儿吧。我刚才确实在读母乳喂养那一章，很有趣，母乳喂养仅存的好处之一竟然是减少奶牛放屁和甲烷排放。这与你的孩子无关，而是与奶牛有关。

---

### [00:52:32] [Laura Modi]

**English:**
We do want to cut down on the farts.

**中文翻译:**
我们确实想减少放屁。

---

### [00:52:35] [Lenny]

**English:**
We do. We do. Not what I thought of when I thought of why should I go with formula or not. Maybe just zooming out a little bit and to kind of close, are there any other lessons that you've learned along this journey about building a company, hiring, team building, anything along those lines? Creating urgency, creating momentum?

**中文翻译:**
是的，没错。这可不是我考虑“是否选择配方奶粉”时会想到的理由。也许我们可以稍微跳出来总结一下，在建立公司、招聘、团队建设等方面，你在这段旅程中还学到了什么？比如创造紧迫感、创造势头？

---

### [00:52:56] [Laura Modi]

**English:**
I mean, momentum. Momentum really is it. We did this a good bit at Airbnb too. I think as a founder and as a CEO or for any leader out there, your job is not just to keep people going on momentum. Your job is to make momentum. And sometimes that momentum has to be manufactured. And that has been one of my biggest lessons on just how, as leaders and people starting companies, how do you force yourself? And sometimes when it's early on, you're actually just doing it to yourself, creating manufactured deadlines and launch dates.
(00:53:36):
The amount of times people say to me, "Why are we launching this May 1st?" And I'm like, "Just because we said it. Because if we don't do it now, we may never do it." It was something we were talking about the last day on just how important it is to look at the fuel that keeps you going and how you have to kind of force those milestones to get you there. So yeah, I would say manufacture yourself some momentum.

**中文翻译:**
我是说，势头。势头真的很关键。我们在 Airbnb 也经常这么做。我认为作为创始人、CEO 或任何领导者，你的工作不仅仅是让人们保持势头，你的工作是“制造”势头。有时这种势头必须是人为制造出来的。这是我最大的教训之一：作为领导者和创业者，你如何强迫自己？有时在早期，你其实只是在强迫自己，制造一些虚假的截止日期和发布日期。
(00:53:36):
无数次有人问我：“为什么我们要定在 5 月 1 日发布？” 我说：“就因为我们这么说了。因为如果我们现在不做，可能永远都不会做。” 我们前几天还在聊，观察那些让你前进的动力有多重要，以及你必须如何强迫自己设定里程碑来达到目标。所以，是的，我会说：为自己制造一些势头。

---

### [00:54:00] [Lenny]

**English:**
I so agree with that. One of my favorite things and one of our former colleagues, Vanessa, taught me this, which is just like, "Let's all set an arbitrary deadline right now." And just make it clear, this is just arbitrary, but it's useful.

**中文翻译:**
我非常同意。我最喜欢的事情之一，也是我们以前的同事 Vanessa 教给我的，就是：“让我们现在设定一个随意的截止日期。” 并且明确表示，这只是随意的，但它很有用。

---

### [00:54:13] [Laura Modi]

**English:**
It's so true.

**中文翻译:**
太对了。

---

### [00:54:15] [Lenny]

**English:**
Well, with that, Laura, we've reached our very exciting lightning round.

**中文翻译:**
好，Laura，现在进入我们非常精彩的闪电问答环节。

---

### [00:54:18] [Laura Modi]

**English:**
Who?

**中文翻译:**
什么？

---

### [00:54:19] [Lenny]

**English:**
I don't know if I told you this was coming, but it is. I've got six questions for you. Are you ready for exciting lightning round?

**中文翻译:**
我不知道有没有告诉你这个环节，但它来了。我有六个问题要问你。准备好进入精彩的闪电问答了吗？

---

### [00:54:26] [Laura Modi]

**English:**
I think I am. Let's do it.

**中文翻译:**
我想我准备好了。开始吧。

---

### [00:54:27] [Lenny]

**English:**
Okay, let's do it. What are two or three books that you've recommended most to other people?

**中文翻译:**
好，开始。你向别人推荐最多的两三本书是什么？

---

### [00:54:33] [Laura Modi]

**English:**
One recently, Great by Choice, the author of From Good to Great, amazing.

**中文翻译:**
最近的一本是《选择卓越》（Great by Choice），《从优秀到卓越》的作者写的，非常棒。

---

### [00:54:40] [Lenny]

**English:**
Jim Collins?

**中文翻译:**
Jim Collins？

---

### [00:54:40] [Laura Modi]

**English:**
Some really, really good frameworks. Yes, that's right. Really good frameworks in there. Metabolical, very specific into the world of health, healthcare. Actually, very specifically the takeaway of Metabolical is we don't have a healthcare crisis in this country, we have a health crisis. And it really makes you think about the source, food and how we live our lives. It's amazing. And then I think you a really good traditional one, going back to just brand and for people who are really just looking for a good foundation, I love Purple Cow.

**中文翻译:**
里面有一些非常、非常好的框架。是的，没错。非常好的框架。还有《代谢》（Metabolical），非常深入地探讨了健康和医疗领域。实际上，《代谢》的核心观点是：这个国家没有医疗危机，而是有健康危机。它真的让你思考源头——食物以及我们的生活方式。它很棒。然后我认为还有一本很经典的，回到品牌层面，对于那些寻找良好基础的人，我喜欢《紫牛》（Purple Cow）。

---

### [00:55:13] [Lenny]

**English:**
I love that. I think I have it in my back around here.

**中文翻译:**
我喜欢那本。我想我就在身后的某个地方放着它。

---

### [00:55:13] [Laura Modi]

**English:**
You do?

**中文翻译:**
是吗？

---

### [00:55:15] [Lenny]

**English:**
There it is, yeah. Tiny little book. It's so cute.

**中文翻译:**
在那儿，是的。小小的一本书，很可爱。

---

### [00:55:18] [Laura Modi]

**English:**
That is so good.

**中文翻译:**
那本书太棒了。

---

### [00:55:20] [Lenny]

**English:**
Yeah. Also, we could mention Emily Oster's book, Laura, Expecting Better.

**中文翻译:**
是的。Laura，我们还可以提到 Emily Oster 的书，《怀得上，生得好》（Expecting Better）。

---

### [00:55:23] [Laura Modi]

**English:**
I mean, we should. Expecting Better is a good classic.

**中文翻译:**
是的，我们应该提。那是一本经典好书。

---

### [00:55:27] [Lenny]

**English:**
Your list is reminding me of a new book by Peter Attia, that I don't know if you've seen, called Outlive, I think it's called. It's about longevity and how to live longer and all the latest sciences and how to live a longer life. But anyway, that's my answer and I'm asking you questions, so let's move on to the next question. Favorite recent movie or TV show?

**中文翻译:**
你的书单让我想起 Peter Attia 的一本新书，不知道你有没有看过，叫《超越期待》（Outlive）。它是关于长寿、如何活得更久以及所有最新的科学研究。总之，那是我的答案，现在是我在问你问题，所以我们进入下一个问题。最近最喜欢的电影或电视节目？

---

### [00:55:44] [Laura Modi]

**English:**
Bad Sisters. Do you have bad sisters?

**中文翻译:**
《坏姐妹》（Bad Sisters）。你有看《坏姐妹》吗？

---

### [00:55:47] [Lenny]

**English:**
No.

**中文翻译:**
没有。

---

### [00:55:48] [Laura Modi]

**English:**
About a group of Irish sisters getting up to trouble. Highly recommended.

**中文翻译:**
讲的是一群爱尔兰姐妹惹麻烦的故事。强烈推荐。

---

### [00:55:53] [Lenny]

**English:**
Amazing. What's a favorite interview question that you like to ask when you're hiring people?

**中文翻译:**
太棒了。你在招聘时最喜欢问的面试问题是什么？

---

### [00:55:57] [Laura Modi]

**English:**
Teach me something. Actually, we just talked about that today. Teach me something. Yeah. I love getting someone to, not related to work, not related to their job, something in your life, something you find interesting, just teach me about it.

**中文翻译:**
“教我点什么”。实际上我们今天刚聊过这个。“教我点什么”。是的。我喜欢让别人教我一些与工作无关、与他们的岗位无关的事情，比如你生活中的某些事，或者你觉得有趣的事，教教我。

---

### [00:56:11] [Lenny]

**English:**
What is it that you look for in their answer that gives you a sense that they're someone that you want to hire?

**中文翻译:**
你从他们的回答中寻找什么，能让你觉得他们就是你想雇佣的人？

---

### [00:56:16] [Laura Modi]

**English:**
Creative, but also just their ability to explain something, and it is a huge indicator. I mean, I'll never forget one guy teaching me how to cook the perfect steak, and now every time I cook a steak, I go back to the way he described it, to someone being able to teach me the foundation of Latin. But if someone's unable to take one thing that they find is core to who they are and what they've done or what they understand and their inability to explain that to you, they may struggle.

**中文翻译:**
创造力，还有他们解释某件事的能力，这是一个巨大的指标。我永远不会忘记有一个人教我如何烹饪完美的牛排，现在每次我煎牛排，都会想起他描述的方式。还有人教我拉丁语的基础。如果一个人无法拿出一件他们认为是其核心、或者他们做过、理解透彻的事情并向你解释清楚，那么他们可能会在工作中遇到困难。

---

### [00:56:49] [Lenny]

**English:**
I want to learn how to cook a perfect steak. I'm going to have to interview you at some point and ask you about that. What's a favorite product you've recently discovered that you love? And especially if it's a baby product, that'll be bonus.

**中文翻译:**
我也想学怎么煎完美的牛排。我得在某个时候采访你并请教一下。你最近发现并喜爱的产品是什么？如果是婴儿用品，会有额外加分。

---

### [00:57:01] [Laura Modi]

**English:**
I mean, yeah, I think Frida Baby's amazing, the nose sucker.

**中文翻译:**
嗯，是的，我觉得 Frida Baby 很棒，就是那个吸鼻器。

---

### [00:57:06] [Lenny]

**English:**
Okay, great. The nose sucker.

**中文翻译:**
好，太棒了。吸鼻器。

---

### [00:57:08] [Laura Modi]

**English:**
Actually, no. Sorry, the nose sucker. That's terrible. It's the snot sucker.

**中文翻译:**
其实不是，抱歉，吸鼻器听起来太难听了，应该是“吸鼻涕神器”（Snot sucker）。

---

### [00:57:13] [Lenny]

**English:**
Okay, great.

**中文翻译:**
好，太棒了。

---

### [00:57:13] [Laura Modi]

**English:**
As a new parent, you really, really need this, Lenny. Your poor little boy is going to get blocked up and you're going to want to get out that sucker and suck on it-

**中文翻译:**
作为一个新手爸爸，Lenny，你真的、真的需要这个。你可怜的小儿子鼻子会堵住，你会想拿出那个吸鼻器吸一吸——

---

### [00:57:23] [Lenny]

**English:**
Oh, dear.

**中文翻译:**
噢，天哪。

---

### [00:57:23] [Laura Modi]

**English:**
... and get it out. I can see you quickly looking for the next question. Move away from the snot sucker.

**中文翻译:**
……把它吸出来。我看到你正急着找下一个问题。让我们跳过吸鼻涕的话题吧。

---

### [00:57:30] [Lenny]

**English:**
No, this is great.

**中文翻译:**
不，这挺好的。

---

### [00:57:31] [Laura Modi]

**English:**
So I'll leave you with that.

**中文翻译:**
那就留给你这个建议吧。

---

### [00:57:33] [Lenny]

**English:**
Perfect. We'll just call the episode The Snot Sucker. So many options. Okay, next question. What's something relatively minor that you've changed in the way that you build/ship product that was minor but had a tremendous impact on your team's ability to execute and ship?

**中文翻译:**
完美。我们就把这集命名为“吸鼻涕神器”好了。选择真多。好，下一个问题。在你们构建或发布产品的方式中，有没有什么相对微小的改变，虽然微小但对团队的执行和发布能力产生了巨大影响？

---

### [00:57:51] [Laura Modi]

**English:**
More recently, async work. Moving away from meeting culture and being able to be in a position where we can work async, whether it's one-hour sprint over Slack, make decisions and go back and forth, 20 people, and then everyone's made a decision by the end of the hour and we're moving forward.

**中文翻译:**
最近的话，是异步协作（Async work）。摆脱会议文化，能够处于一种我们可以异步工作的状态。无论是通过 Slack 进行一小时的冲刺，20 个人来回讨论并做决定，然后在一小时结束时，每个人都做出了决定，我们继续前进。

---

### [00:58:12] [Lenny]

**English:**
Is there a tool that helps you do that or is it just in Slack? "Here's the question we're trying to answer," and everyone-

**中文翻译:**
有什么工具能帮你们做到这一点吗？还是就在 Slack 里？“这是我们要解决的问题”，然后每个人——

---

### [00:58:16] [Laura Modi]

**English:**
You know what? Every so often we try and introduce tools and then it's like we've over-processed this entire thing, when what we really just need to do is all just get our head into the moment we're in and brand it and get it done. So even though I think we've introduced some tools, I know we use some video ones as well. I'm a little bit removed sometimes from everyone working through these tools, but I'm in the Slack world the most.

**中文翻译:**
你知道吗？我们经常尝试引入新工具，然后感觉整个过程变得过于繁琐。而我们真正需要做的只是全身心投入到当下的时刻，给它打上品牌标签，然后把它搞定。所以虽然我认为我们引入了一些工具，我也知道我们用了一些视频工具，但我有时会稍微脱离这些具体的工具，我待得最多的还是 Slack 的世界。

---

### [00:58:40] [Lenny]

**English:**
Final question, what is your best advice for a soon-to-be parent, aka, me?

**中文翻译:**
最后一个问题，你对即将成为父母的人（也就是我）最好的建议是什么？

---

### [00:58:45] [Laura Modi]

**English:**
Hire a sitter who you love that you want to have on board every Thursday night and keep your date night with Michelle, whatever your date night is, and just don't worry about the price because the date is worth it, but just lock it in and do it.

**中文翻译:**
雇一个你喜欢的保姆，让她每周四晚上都来，保持你和 Michelle 的约会之夜，无论你们的约会内容是什么。别担心价格，因为约会是值得的。定下来，然后去做。

---

### [00:59:03] [Lenny]

**English:**
We actually have a date night currently with another couple who has two kids, and so we could just maintain that. How early do you hire a sitter to do that, in their age?

**中文翻译:**
我们目前确实和另一对有两个孩子的夫妇有约会之夜，所以我们可以保持下去。孩子多大时开始雇保姆做这件事？

---

### [00:59:13] [Laura Modi]

**English:**
Second week.

**中文翻译:**
第二周。

---

### [00:59:14] [Lenny]

**English:**
Second week. Okay, great. Not first week.

**中文翻译:**
第二周。好，太棒了。不是第一周。

---

### [00:59:16] [Laura Modi]

**English:**
Okay. Maybe second month. It totally depends on how you guys are feeling.

**中文翻译:**
好吧，也许是第二个月。这完全取决于你们的感觉。

---

### [00:59:23] [Lenny]

**English:**
No. Okay, that early.

**中文翻译:**
不，好吧，那么早。

---

### [00:59:24] [Laura Modi]

**English:**
That depends on how she's feeling, but I would say sometimes you just need to rip the bandaid and you need to go for it, even if it means the two of you are just going out for a quick meal and you're coming back, keep your date night.

**中文翻译:**
这取决于她的感觉，但我想说，有时你只需要果断一点，去尝试。即使这意味着你们两个只是出去快速吃顿饭就回来，也要坚持你们的约会之夜。

---

### [00:59:33] [Lenny]

**English:**
Laura, this was as fun and insightful as I expected. I'm going to go try some Bobbie, I'm going to go by snot suckers. Thank you so much for spending time here. Two final questions. Where can folks find you online if they want to reach out, learn more, learn more about Bobbie, potentially, and how can listeners be useful to you?

**中文翻译:**
Laura，这次谈话正如我预期的那样有趣且富有洞察力。我要去尝尝 Bobbie，还要去买吸鼻涕神器。非常感谢你来到这里。最后两个问题：如果人们想联系你、了解更多信息，或者了解 Bobbie，可以在哪里找到你？听众们能为你提供什么帮助？

---

### [00:59:51] [Laura Modi]

**English:**
Okay. Well, the first thing I'm going to say, how listeners can be useful. I am hiring a growth product manager right now and we are really focused on optimization. So now I'm moving away from everything I just said and I want a specialist who's really good at growth optimization. And how folks can find us, our website is hibobbie, H-I bobbie, B-O-B-B-I-E.com. And if folks just want to reach out to me, I would highly recommend just sending me an email, Laura@hibobbie.com.

**中文翻译:**
好。首先，关于听众能提供什么帮助：我目前正在招聘一名增长产品经理（Growth PM），我们非常关注优化。所以现在我要推翻我刚才说的一切，我想要一个非常擅长增长优化的专家。至于人们在哪里可以找到我们，我们的网站是 hibobbie.com（H-I-B-O-B-B-I-E）。如果大家想直接联系我，我强烈建议给我发邮件：Laura@hibobbie.com。

---

### [01:00:20] [Lenny]

**English:**
And for the hiring position, how do they go apply for that and learn more about it?

**中文翻译:**
关于那个招聘职位，他们该如何申请并了解更多信息？

---

### [01:00:24] [Laura Modi]

**English:**
Great question. I'm assuming it's on our careers page on the website.

**中文翻译:**
好问题。我想应该在网站的职业（Careers）页面上。

---

### [01:00:27] [Lenny]

**English:**
Great. We'll make sure it's there before this all goes out.

**中文翻译:**
太好了。我们会确保在节目发布前它就在那儿。

---

### [01:00:29] [Laura Modi]

**English:**
Amazing.

**中文翻译:**
太棒了。

---

### [01:00:30] [Lenny]

**English:**
Laura, this is amazing. Thank you so much for being here.

**中文翻译:**
Laura，这太棒了。非常感谢你的到来。

---

### [01:00:33] [Laura Modi]

**English:**
It's such a pleasure, Lenny. This is so fun.

**中文翻译:**
这是我的荣幸，Lenny。这非常有趣。

---

### [01:00:35] [Lenny]

**English:**
It's my pleasure. And goodbye, everyone.

**中文翻译:**
我的荣幸。大家再见。

---

### [01:00:37] [Laura Modi]

**English:**
Bye.

**中文翻译:**
再见。

---

### [01:00:41] [Lenny]

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcast, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
非常感谢您的收听。如果您觉得本期节目有价值，可以在 Apple Podcast、Spotify 或您喜欢的播客应用中订阅本节目。此外，请考虑给我们评分或留下评论，因为这确实能帮助其他听众发现这个播客。您可以在 lennyspodcast.com 找到所有往期节目或了解更多关于本节目的信息。下期节目见。