# Laura Schaffer - 双语对照

This is the complete bilingual (English-Chinese) transcript for Lenny's Podcast featuring Laura Schaffer.

---

### [00:00:00] Laura Schaffer

**English:**
... Like the dead of the night. And by that, I mean 7:00 PM or something on. I'm pretty sure it was a Friday. We just asked for forgiveness and put these questions into the silent flow and ran as Navy test with a small group. And I'm fully expecting, "Okay, this is going to hurt our numbers, but maybe it won't be so bad and I'm going to be prepared to advocate the power of this data that we're getting." And I was totally geared up thinking about written, started to write the framework for how I wanted to surface this. And we start to get the data for this thing. I'm not kidding, an improved conversion. There's no personalization, nothing past it, just the questions. An improved conversion by like 5%, just improved signups. And it was one of those like, "What? Okay, what is going on here?"

**中文翻译:**
……就像在深夜里。我的意思是，大概是周五晚上 7 点左右。我们当时抱着“先斩后奏”的心态，直接在静默流程中加入了这些问题，并针对一小部分用户进行了 A/B 测试。我当时完全做好了心理准备：“好吧，这肯定会影响我们的转化数据，但也许不会太糟，而且我已经准备好去论证我们获取的这些数据的价值了。”我甚至已经开始构思如何向上级展示这些数据的框架了。结果当我们开始看到数据时，我没开玩笑，转化率竟然提高了。没有任何个性化推荐，后面什么都没做，仅仅是加了几个问题。注册转化率竟然提升了约 5%。当时我就懵了：“什么？这到底是怎么回事？”

---

### [00:00:50] Lenny

**English:**
Welcome to Lenny's Podcast where I interview world-class product leaders and growth experts to learn from their hard one experiences building and growing today's most successful products. Today my guest is Laura Schaffer. The week we recorded this chat turned out to be Laura's first week in a new gig as head of growth for Amplitude taking over for a previous legendary guest, Elena Verna. Prior to Amplitude, Laura was VP of product and growth at a company called Rapid. Before that, she spent over seven years at Twilio as Head of Growth and PM lead of the growth platform and experimentation platform at Twilio. In our conversation, we dig into Laura's career growth framework and the importance of carving your own path versus waiting for one to be carved for you. We also get into a bunch of tactical and surprising advice around running experiments, making decisions on gut versus data, developing your growth strategy and how to sell your product to developers. Laura has a wealth of wisdom and I learned a lot from our conversation. With that, I bring you Laura Schaffer after a short word from our wonderful sponsors.

**中文翻译:**
欢迎来到 Lenny 的播客。在这里，我会采访世界级的产品领导者和增长专家，学习他们在构建和发展当今最成功产品过程中积累的宝贵经验。今天的嘉宾是 Laura Schaffer。我们录制这次访谈的那周，恰好是 Laura 在 Amplitude 担任增长负责人（Head of Growth）的第一周，她接替了我们之前的传奇嘉宾 Elena Verna。在加入 Amplitude 之前，Laura 在 Rapid 公司担任产品与增长副总裁。在此之前，她在 Twilio 工作了七年多，担任增长负责人以及增长平台和实验平台的 PM 主管。在我们的对话中，我们将深入探讨 Laura 的职业成长框架，以及“开辟自己的道路”而非“坐等机会”的重要性。我们还会聊到许多关于运行实验、凭直觉还是数据做决策、制定增长策略以及如何向开发者销售产品的实战建议。Laura 拥有丰富的智慧，我从这次对话中学到了很多。在听完赞助商的简短介绍后，让我们正式开始与 Laura Schaffer 的对话。

---

### [00:01:55] Lenny (Sponsor: public.com)

**English:**
This episode is brought to you by public.com who want to tell you about their new treasury accounts, which earn a 4.8% yield on your cash. That is higher than a high yield savings account, while still being backed by the full faith and credit of the US government. Treasure yields are at a 15-year-high. But buying US treasuries is super complicated. If you go to a bank or navigate an ancient government website, or at least that was the case. Now you can move your cash and the US treasuries with the flexibility of a bank account. You can access your cash whenever you want, even before your treasury bills hit maturity. There are no hold periods, no settlement days. Just a safe place to park your cash and earn a reliable yield. Public will automatically reinvest your treasury bills at maturity so you don't have to do anything to continue growing your yield. And you can manage your treasuries alongside stocks, ETFs, crypto, and any alternative assets. Do all your investing in one place and earn 4.8% a higher yield than a high yield savings account only with a treasury count at public.com/lenny.

**中文翻译:**
本期节目由 public.com 赞助。他们推出了全新的国债账户，现金收益率高达 4.8%。这比高收益储蓄账户还要高，而且由美国政府的全面信誉担保。目前国债收益率正处于 15 年来的高点。但购买美国国债通常非常复杂，你得去银行或者忍受陈旧的政府网站。现在，你可以像使用银行账户一样灵活地将现金转入美国国债。你可以随时提取现金，甚至在国债到期前也可以。没有持有期限制，没有结算日。这只是一个存放现金并赚取可靠收益的安全场所。Public 会在国债到期时自动进行再投资，你无需任何操作即可持续获得收益。你还可以在同一个地方管理国债、股票、ETF、加密货币和任何替代资产。在 public.com/lenny 开设国债账户，一站式投资并赚取 4.8% 的高收益。

---

### [00:03:02] Lenny (Sponsor: Eppo)

**English:**
This episode is brought to you by Eppo. Eppo is a next generation AB testing platform built by Airbnb alums for modern growth teams. Companies like Netlify, Contentful, and Cameo rely on Eppo to power their experiments. Wherever you work, running experiments is increasingly essential, but there are no commercial tools that integrate with a modern grow team stack. This leads to waste of time building internal tools. We're trying to run your experiments through a clunky marketing tool. When I was at Airbnb, one of the things that I loved about our experimentation platform was being able to easily slice results by device, by country, and by user stage. Eppo does all that and more delivering results quickly, avoiding annoying prolonged analytics cycles and helping you easily get to the root cause of any issue You discover. Eppo lets you go beyond basic click through metrics and instead you turn north star metrics like activation, retention, subscriptions and payments. An Eppo supports test on the front end, the back end e-mail marketing and even machine learning clients. Check out Eppo at geteppo.com, get E-P-P-O.com and 10 x your experiment velocity.

**中文翻译:**
本期节目由 Eppo 赞助。Eppo 是由 Airbnb 前员工为现代增长团队打造的下一代 A/B 测试平台。Netlify、Contentful 和 Cameo 等公司都依赖 Eppo 来驱动他们的实验。无论你在哪里工作，运行实验都变得越来越重要，但目前还没有商业工具能完美集成到现代增长团队的技术栈中。这导致人们要么浪费时间开发内部工具，要么被迫使用笨重的营销工具。我在 Airbnb 时，最喜欢我们的实验平台的一点就是能轻松地按设备、国家和用户阶段切分结果。Eppo 不仅能做到这些，还能快速交付结果，避免烦人的漫长分析周期，并帮你轻松找到问题的根源。Eppo 让你超越基础的点击率指标，转而关注激活、留存、订阅和支付等北极星指标。Eppo 支持前端、后端、邮件营销甚至机器学习客户端的测试。访问 geteppo.com (G-E-P-P-O.com)，让你的实验速度提升 10 倍。

---

### [00:04:15] Lenny

**English:**
Laura, welcome to the podcast.

**中文翻译:**
Laura，欢迎来到我们的播客。

---

### [00:04:18] Laura Schaffer

**English:**
Thanks, Lenny, it is so great to be here. Thanks for having me.

**中文翻译:**
谢谢 Lenny，很高兴能来到这里。感谢你的邀请。

---

### [00:04:21] Lenny

**English:**
It's great to have you. So I asked Elena Elena, Elena, I'm not even sure how to pronounce her name, maybe. What is it?

**中文翻译:**
很高兴你能来。我问过 Elena（艾琳娜）……我不确定她的名字到底怎么发音，应该是怎么读？

---

### [00:04:21] Laura Schaffer

**English:**
Elena. You got it.

**中文翻译:**
Elena。你读对了。

---

### [00:04:27] Lenny

**English:**
Elena. Okay. Okay. I think I've said it wrong all the time. All this time. Okay, Elena. So I asked Elena Ferna, who's a popular guest on this podcast who I should have on this podcast and you are the first person that immediately came to mind. And so I'm really excited that we're doing this and that you agreed to be on.

**中文翻译:**
Elena。好吧，看来我一直都读错了。好吧，Elena。我问过 Elena Verna（她是本播客非常受欢迎的嘉宾），我该邀请谁来上节目，她第一个想到的就是你。所以我非常兴奋能邀请到你，也很高兴你答应了。

---

### [00:04:42] Laura Schaffer

**English:**
Well, she's the best and I'm really happy that she referred me because I'm just stoked to be here. So thanks for listening to her guidance.

**中文翻译:**
她是最棒的，我很开心她推荐了我，能来到这里我真的很兴奋。谢谢你听从了她的建议。

---

### [00:04:50] Lenny

**English:**
Absolutely. And it's a cool time to be chatting. You're the newly minted head of growth at Amplitude and so congrats, first of all.

**中文翻译:**
那是当然。现在聊这个时机非常好。你刚成为 Amplitude 的增长负责人，首先恭喜你。

---

### [00:04:57] Laura Schaffer

**English:**
Thank you. Appreciate that. Yeah, this is my day two and a half here. So very [inaudible 00:05:04].

**中文翻译:**
谢谢，非常感谢。是的，这只是我入职的第 2.5 天。所以感觉非常[听不清]。

---

### [00:05:06] Lenny

**English:**
Wow, you're a veteran.

**中文翻译:**
哇，你已经是“老兵”了。

---

### [00:05:06] Laura Schaffer

**English:**
Yeah, right.

**中文翻译:**
哈哈，没错。

---

### [00:05:06] Lenny

**English:**
I love it. Some companies, there's a little percentage of that shows you how many people have joined before you and I wonder what that percentage already is [inaudible 00:05:12].

**中文翻译:**
太棒了。有些公司会显示一个百分比，告诉你排在你之前入职的人有多少，我很好奇你现在的百分比是多少了。

---

### [00:05:12] Laura Schaffer

**English:**
We had that in Twilio and I got pretty, pretty high up there after a while. We had a stack rank and a spreadsheet. Yeah, but it is funny. So wherever that thing exists in Amplitude, I am right fresh there at the very bottom.

**中文翻译:**
我们在 Twilio 时就有这个，过了一段时间后我的排名变得非常靠前。我们有一个排名表和电子表格。但这很有趣，无论 Amplitude 的那个排名在哪里，我现在肯定是在最底层。

---

### [00:05:25] Lenny

**English:**
So what was the number you got to Twilio? Any, do you remember?

**中文翻译:**
那你在 Twilio 时的编号是多少？还记得吗？

---

### [00:05:28] Laura Schaffer

**English:**
Yeah, no, I was very proud to crack the top 50. That was my claim the same because as people left, you move up. Right?

**中文翻译:**
记得，我很自豪能进入前 50 名。那是我的“功勋章”，因为随着老员工离职，你的排名就会上升，对吧？

---

### [00:05:36] Lenny

**English:**
Right. Yeah, it's bittersweet.

**中文翻译:**
没错，真是苦乐参半。

---

### [00:05:39] Laura Schaffer

**English:**
Well, yeah, right. On one hand it's like, "Ooh, very cool." And one of the OGs on the other hand, it's like, "Oh my gosh, this person's [inaudible 00:05:47]. Bummer." It's a shift, but I'm excited about it for sure.

**中文翻译:**
是啊。一方面觉得“哇，太酷了，我是元老之一”；另一方面又觉得“天哪，那个人也走了，真遗憾”。这是一种转变，但我确实对此感到兴奋。

---

### [00:05:51] Lenny

**English:**
So you have this new exciting role and I thought it'd be fun to start to chat about career growth and just how you think about career growth. I know you have a framework of how you think about your own career growth and clearly it's worked out, so I'm curious to hear about it and see how it could be helpful to folks that are listening. So yeah, can you just tell us about how you think about career growth?

**中文翻译:**
既然你开始了这份令人兴奋的新工作，我想聊聊职业成长，以及你是如何看待职业成长的。我知道你有一套关于职业成长的框架，而且显然非常奏效。我很想听听这个框架，看看它能给听众带来什么启发。你能分享一下你对职业成长的看法吗？

---

### [00:06:11] Laura Schaffer

**English:**
Career growth is definitely not a straight lineup, but there's definitely some frameworks and methods that have worked really well for me. And I think to dive into it, it's first good to just talk about the one that I most typically see people use to try to grow their career and why that can be a little problematic, which is that I see most people try to work really hard the job that they have within the role that they have at a company. Do whatever you can to grow there, show your manager all these things. I see people keep spreadsheets, it wins. So it can come up with performance reviews. Maybe you try to get better advocating for yourself, maybe try to get peers to notice or your manager's peers. And that's all good. It's all stuff.
(00:06:52):
But the problem with it is that you're limited to what your manager's ability is to advocate for you, to promote you. And you're also limited by the explicit trajectory of your role at that company and where the there's room for that or not at the company. And then often that perception can sometimes be a little bit in contrast to what your perception is. And also other things that happen, your manager leaves and then you have to restart with someone else. So the method that I use tries to take that power back a little bit. And something that I learned really early on in my career, I was very lucky to learn by accident, was at a company called Bandwidth, which is my first real job. And Bandwidth is now a public company and they've done all kinds of crazy amazing things.
(00:07:38):
But I joined when it was just 50 people and I actually joined in sales and I was just hungry to make it succeed and grow and bright eyes and everything, first real job. But I realized after a few months of being in sales that I was often repeating the same thing over again, using the same thing to sell over and over again. And it's like, gosh, this isn't ideal for the customer because [inaudible 00:08:04] call me and ask these questions and get these answers and all this stuff. And it's not ideal for the company because they're paying commission on this every time. That's not going to be efficient for our growth. And because we were small, I was able to catch our GM and I was just like, "Hey, I've noticed this pattern where I'm repeating things over and over again and they're asking the same thing.
(00:08:29):
I think we should put that online. I think we should make that available so they can just see it and then buy it," because we had an online checkout process. And I was expecting him to be like, "Oh, well, I know it's important but for this [inaudible 00:08:46] another, we need to do it this way, and obviously you've thought all about it." And thinking, "Oh, I'm going to come in this new person, he's just going to help me understand what I'm missing here." There's a little bit of that that I was expecting. And he goes, "Wait a minute, tell me more about that. What do you mean?" And by the end of the conversation he was like, "Hey, why don't you go do that? Why don't you go build that experience? Why don't you put that stuff in a self-serve flow?"
(00:09:06):
And we called it e-commerce manager and it was like got a growth before this growth, this is like 2010. And that moved me into a totally new position. And the main learning that I had from that was, which really took life at Twilio and absolutely worked for me there and I'm happy to talk about that too. But the core that learning was, your executive team and executive teams at companies are often very sharp, but the nature of their day-to-day just does not link them with customers.
(00:09:34):
And that means that over time, especially as a company grows, they often lose access to some of the best insights and in the heartbeat of the people who they're providing value to in contrast to folks that are closer to the problem. And so that means that your superpower is in really pulling those insights in and bringing them to life, staying close to the customer. There's not a single leader or executive that isn't going to be stoked to hear about valuable customer insights that highlight problems they might not be seeing. And there's a lot of those. So especially when they align to North Star metrics, those ones are the powerful ones. That was the way that I grew my career at Phil and I'm happy to share that journey too.

**中文翻译:**
职业成长绝对不是一条直线，但确实有一些框架和方法对我非常有效。在深入探讨之前，最好先谈谈我最常看到的大家用来提升职业生涯的方法，以及为什么这种方法可能存在问题。大多数人倾向于在现有的岗位上非常努力地工作，尽一切可能在当前角色中成长，向经理展示自己的成果。我看到有人会专门记电子表格，记录自己的成绩，以便在绩效评估时使用。也许你会尝试更好地为自己争取利益，或者让同事和经理的同级注意到你。这些都很好，都是该做的事。

但问题在于，你的晋升受限于你经理为你争取的能力。你还受限于公司内部该职位的明确晋升轨迹，以及公司是否有相应的空间。而且，公司对你的看法有时可能与你的自我认知不符。此外还会发生其他变数，比如你的经理离职了，你不得不和新经理重新开始。

所以我使用的方法是尝试夺回一点主动权。这是我在职业生涯早期偶然学到的，当时我在一家叫 Bandwidth 的公司工作，那是我的第一份正式工作。Bandwidth 现在已经上市了，做得非常出色。但我加入时公司只有 50 人，我当时在销售部门，满腔热血想让公司成功，那是我的第一份工作。但在做了几个月销售后，我发现自己总是在重复同样的话，用同样的方式推销。我觉得这对客户来说并不理想，因为他们得打电话问我同样的问题；对公司也不理想，因为每次都要支付佣金，这对增长来说效率不高。

因为公司规模小，我有机会见到我们的总经理。我说：“嘿，我发现了一个模式，我总是在重复同样的事情，客户问的也一样。我觉得我们应该把这些内容放到网上，让他们能直接看到并购买。”因为我们当时已经有了在线结账流程。我本以为他会说：“哦，我知道这很重要，但因为这样那样的原因，我们必须按现在的方式做。”我以为他会帮我指出我漏掉了什么。结果他说：“等等，再多跟我说说，你是什么意思？”谈话结束时，他说：“嘿，你为什么不去试试呢？你去构建那个体验，把那些东西放进自助服务流程（self-serve flow）里。”

我们把那个职位叫做“电子商务经理”，这有点像 2010 年时的“增长”职位。这把我带入了一个全新的岗位。我从中获得的核心教训是——这在后来的 Twilio 职业生涯中得到了充分验证——公司的高管团队通常非常精明，但他们的日常工作性质决定了他们无法直接接触客户。这意味着随着公司成长，他们往往会失去对一线客户洞察的掌握。因此，你的“超能力”就在于提取这些洞察并将其付诸实践，保持与客户的近距离接触。没有任何一位领导者或高管在听到能揭示他们可能忽视的问题的宝贵客户洞察时会不感到兴奋。特别是当这些洞察与北极星指标（North Star metrics）挂钩时，它们的力量是巨大的。这就是我在职业生涯中成长的方式，我也很乐意分享那段旅程。

---

### [00:10:18] Lenny

**English:**
Yeah, it'd actually be cool to hear maybe another example of that. But I think an interesting thing that comes up for me here is sometimes you may have an awesome idea and it may not immediately happen. It may not be like, yes or let's move on, that's right, immediately. And I think it's important to just recognize they're not going to follow all your ideas, but they're always looking for better ideas. And to your point, they may not have the information that will lead to an idea that you will have because you're on the ground dealing with real problems, day-to-day. So I think it's important to recognize you're not going to always get your way and that's normal.

**中文翻译:**
是的，如果能再听一个例子就太酷了。但我想到的一点是，有时候你可能有一个很棒的主意，但它不会立即实现。高管可能不会马上说“太好了，就这么办”。我认为意识到这一点很重要：他们不会采纳你所有的想法，但他们一直在寻找更好的想法。正如你所说，他们可能没有足够的信息来产生你那样的想法，因为你在一线处理日常的实际问题。所以，意识到你不可能总是如愿以偿是很正常的。

---

### [00:10:52] Laura Schaffer

**English:**
Yeah, totally. And it's almost like building up your individual brand a little bit. And I think one of the most powerful and accessible ways is learning about your customers. There's always those people at companies who's like, "Oh, well, she just knows our customers or he just knows our customers, they just know our customers. They just know." And it's like, "Well, how?" "They just know. Let's ask that person. Let's get their feedback." And those people often have a good amount of brand recognition of powers within the company and they're often thought of when the company needs to do something new or different or if someone is hiring, maybe they're thinking about that person for a cross team thing.
(00:11:31):
So it's one of the ways that you can build that brand. And again, I think it's a sweet spot because it's something that is very valuable to everyone, all the way up to the most senior leaders, which we can talk about here in a minute. And so it's going to be valuable for you in a valuable tool no matter where you're at in your career. And that's not always an immediate payoff, but it often does give you a trajectory outside of just your role and just your manager. It gives you something a little bit broader.

**中文翻译:**
没错。这有点像在建立你的个人品牌。我认为最强大且最容易实现的方式就是了解你的客户。公司里总有那样的人，大家会说：“哦，她非常了解我们的客户”或者“他就是懂客户”。别人会问：“怎么做到的？”“他们就是知道。去问问那个人吧，听听他们的反馈。”这些人通常在公司内部拥有很高的品牌认可度和影响力。当公司需要做一些新尝试或不同尝试时，或者有人在招聘跨团队职位时，往往会想到那个人。

所以这是建立个人品牌的方法之一。而且我认为这是一个“甜蜜点”，因为它对每个人都有价值，一直到最高层领导。无论你处于职业生涯的哪个阶段，这都是一个宝贵的工具。虽然它并不总能带来即时回报，但它通常能为你提供一条超越当前角色和经理的成长轨迹，给你更广阔的空间。

---

### [00:12:05] Lenny

**English:**
So maybe a simple way of describing to mirror back what you're saying is carve your own path. Don't necessarily assume your managers will give you the path that makes most sense for you or even give you the biggest opportunity. Just propose, "Hey, I think this might be a better opportunity and I'd love to pursue it." I'd love to hear the Twilio example if that's generally-

**中文翻译:**
所以，用一种简单的方式来总结你的观点就是：开辟你自己的道路。不要假设你的经理会为你提供最适合你的路径，甚至不要指望他们会给你最大的机会。你应该主动提议：“嘿，我觉得这可能是一个更好的机会，我想去尝试。”我很想听听 Twilio 的那个例子，如果方便的话。

---

### [00:12:25] Laura Schaffer

**English:**
Yeah. So when I joined Twilio, there was no growth team at all, not even a breath of it. I joined in product marketing and I was leading our product marketing for our messaging lines, but I followed the same guy that I just mentioned. I made it my own personal policy to like, hey, I'm going to do my job. And I'm going to do well, I'm going to keep notes of things I'm doing well and all that stuff because it's good, but I'm also going to get to know our customers. And I'm going to get to know our customers really well and I'm going to pay attention when I'm connecting with them, not just about the space I'm in, but just broadly what are some of the pain points and things they're articulating that are relevant to the business and what we're trying to get done.
(00:13:00):
And one of the things that came up was that users were struggling and folks were struggling to get started and use Twilio. And that contrasted so deeply to some of the things that our executive team was saying and had high conviction in our company had high conviction, which is that Twilio was so easy to use. In fact, it was top three things about Twilio that we were really trying to get out of their brand. Were so easy. Developers love us, they say we're so easy. And there were tweets coming all the time, developers saying like, "Oh my gosh, they got started in a couple of minutes." So there's all these things that made that compound and made that conviction stick. But as I was talking to customers, I was hearing a very different story and it made sense as we were penetrating new markets, adding more products, we were adding complexity and we were pulling in folks who were a little bit less motivated and those things contributed to people saying this is difficult.
(00:13:55):
And so at the time, this wasn't a 50 person in where I could just go to the floor and go to someone and be like, "Hey, there's this thing I heard about, I think we should do something." But there was another tactic that I could take, and I just started sharing a voice of the customer report. I started sharing my insights, started writing down and just sharing them. And it became with digest and eventually people were like, "Hey, can you share it with me? Can you share with me? Can you get on your list? Can share with me?" And this was in a few months of me joining, I was doing this. And then that turned into, "Hey, you should host a quarterly voice to the customer session or for all of product." And this was a request that was coming from some of the senior leaders at the company.
(00:14:33):
And when our Jeff Lawson is our CEO at the time heard about, he started attending too. So now in the session I started pulling in other people's insights too, because now they had a forum for this. I could do that and have people send that to me and I could compile it and all of these things. So then this established me as that person who knows about the customer even after short tenure. And then when came time to do annual planning that year, and I joined in 2014 at the end, so this is 2015, I pitched this idea, "Hey, we think that it's easy. It is not. Here's data that I have, the information that I have and I think that we need to start a growth team here and that needs to be a core focus." And I was able to bring in a really critical partner to that and other folks who could support that because I had built up some of that trust.
(00:15:28):
So by the time I was making that pitch, I had someone on Andre Crow who was the seventh hire at Twilio and got to number three on that spreadsheet or whatever who was really close to the CEO being like, "Yeah, we desperately need this." I'm seeing this. He led a website, he basically created the Twilio brand and he led all the website stuff and he is like, "Yeah, we definitely need this." So not only did I have that little bit of trust from the executive team, but I also had folks who were just trusted on their own advocating and supporting this that I was doing. And so it was approved just almost very easily. I put stuff together for it, but it was the meeting before the meeting had already been done by this other thing. So it helped me create the growth engineering, growth product team at Twilio.

**中文翻译:**
好的。当我加入 Twilio 时，根本没有增长团队，甚至连这个概念都没有。我当时在产品营销部门，负责短信业务线。但我遵循了刚才提到的那个原则：我会做好本职工作，记录下我做得好的地方，但我也会去深入了解客户。我会非常深入地了解他们，在交流时不仅关注我负责的领域，还会广泛关注他们表达的与业务相关的痛点。

当时发现的一个问题是，用户在上手使用 Twilio 时非常吃力。这与高管团队的认知形成了鲜明对比，公司当时坚信 Twilio 非常易用。事实上，“易用”是 Twilio 品牌推广的前三大卖点。开发者喜欢我们，说我们上手很快。当时推特上到处都是开发者说“天哪，几分钟就搞定了”。这些反馈加深了公司的这种信念。但当我与客户交谈时，我听到了完全不同的故事。随着我们进入新市场、增加产品，复杂性也在增加，我们吸引了一些动力稍弱的用户，这些因素导致人们觉得 Twilio 很难用。

当时公司已经不止 50 人了，我不能直接跑到某人面前说“嘿，我听到了个事，咱们得做点什么”。但我采取了另一种策略：我开始分享“客户之声”（Voice of the Customer）报告。我开始写下我的洞察并分享出去。它变成了一份简报，后来人们纷纷要求：“嘿，能分享给我吗？能把我加进邮件列表吗？”这发生在我入职后的几个月内。接着，这演变成了“你应该为整个产品团队主持季度客户之声会议”。这是公司一些高级领导提出的要求。

当当时的 CEO Jeff Lawson 听说后，他也开始参加。于是，在会议中我也开始汇集其他人的洞察，因为现在有了一个论坛。这确立了我作为“懂客户的人”的形象，尽管我入职时间不长。到了那年的年度规划时（我是 2014 年底加入的，所以那是 2015 年），我提出了这个想法：“嘿，我们觉得产品好用，其实不然。这是我掌握的数据和信息，我认为我们需要组建一个增长团队，并将其作为核心重点。”因为我已经建立了一定的信任，我成功拉拢了一位关键合作伙伴和其他支持者。

当我做这个提案时，Andre Crow（Twilio 的第 7 号员工，在那个排名表上排第 3，与 CEO 关系非常近）也表示：“是的，我们迫切需要这个。”他负责网站和品牌，他也看到了这个问题。所以，我不仅获得了高管团队的一点信任，还有那些本身就备受信任的人在支持我。提案几乎非常顺利地通过了。虽然我准备了材料，但其实在正式会议之前，通过之前的努力，事情已经定下来了。这促成了我在 Twilio 组建了增长工程和增长产品团队。

---

### [00:16:14] Lenny

**English:**
I love just how proactive your advice is here. There's a lot of people that don't do well and then just like, "Oh, I never had the opportunity or I kept got looked over all this time." And I love that there's all this just like, here's things you can be doing to get in front of people to provide value, to just create opportunity for yourself. Any other advice along the lines of just like, here's the things you could do for yourself versus waiting for someone to come and give you opportunity?

**中文翻译:**
我非常喜欢你这种积极主动的建议。很多人表现不好时会抱怨：“哦，我从来没有机会，或者我一直被忽视。”我喜欢你分享的这些：你可以做这些事来展示自己、提供价值，从而为自己创造机会。关于“为自己创造机会”而不是“坐等机会”，你还有什么其他建议吗？

---

### [00:16:42] Laura Schaffer

**English:**
Yeah, I think that's the most easily actual because to do all of our jobs, we need to know customers, we need to know about customer insights, product, we need to know. But then also customer facing teams, social, those want to crack into product. Your insights are extremely valuable. You're talking to customers every day more about their problems and their pain than a lot of other people do. And so that is by far and away to me the most powerful and accessible by anyone in any role in any space. But I'll also say that that broader concept of just, hey, there's things that, and things of value that you know that others can benefit from at your company and building your brand as someone that is supportive, smart, creative, able to solve problems, make sure that you're sharing that. And so maybe you're really freaking good at communicating with brevity.
(00:17:35):
I suck at that by the way. So more powered anyone that can do that, I'm actively working on it. So share that. Go to your general Slack channel or whatever and just be like, "Hey, just wrote some tips for how to do it, some ways that I am good at this." And those kinds of things can really go a long way towards people starting to view you as an SME and not just the space that you're in, but in broader areas. And that can always present open doors for you and other people are looking up to you and seeing you, someone who's strong in ways outside of just the role that you're in.

**中文翻译:**
是的，我认为这是最容易付诸行动的。因为要做好工作，我们必须了解客户，了解客户洞察和产品。对于那些在面向客户的团队（如社交媒体、客服）并想转岗到产品部门的人来说，你们的洞察力极其宝贵。你们每天都在和客户交流，比其他人更了解他们的痛苦。所以对我来说，这是任何角色、任何领域的人都能掌握的最强大且最容易获取的工具。

此外，还有一个更广泛的概念：在公司里，你肯定掌握一些别人能从中受益的有价值的东西。要把自己塑造成一个乐于助人、聪明、有创意、能解决问题的人，并确保分享这些。比如，也许你非常擅长简洁明了地沟通。

顺便说一下，我不擅长这个，所以我很佩服能做到的人，我也在努力改进。你可以分享这些，去 Slack 的公共频道发个消息：“嘿，我写了一些关于如何简洁沟通的小贴士，这是我擅长的方法。”这类事情能让你在别人眼中成为一个 SME（领域专家），不仅限于你所在的领域，还包括更广泛的领域。这总能为你打开新的大门，让别人看到你在本职工作之外的强大能力。

---

### [00:18:07] Lenny

**English:**
SME is a Subject Matter Expert, is that right?

**中文翻译:**
SME 是指 Subject Matter Expert（领域专家），对吗？

---

### [00:18:10] Laura Schaffer

**English:**
Yes. Thank you for unpacking my acronyms. That's another thing that I am actively working on.

**中文翻译:**
是的。谢谢你解释我的缩写。这也是我正在努力改进的另一件事（少用缩写）。

---

### [00:18:16] Lenny

**English:**
I got you. I'll be on the lookout.

**中文翻译:**
没问题，我会帮你留意的。

---

### [00:18:19] Laura Schaffer

**English:**
Yes.

**中文翻译:**
好的。

---

### [00:18:19] Lenny

**English:**
Maybe one last question along these lines is do you have any advice for framing the proposal, framing an opportunity to your manager, higher ups that you see has worked best broadly?

**中文翻译:**
关于这方面最后一个问题：在向经理或高管提交提案或展示机会时，你有没有什么通用的、效果最好的建议？

---

### [00:18:34] Laura Schaffer

**English:**
Yeah. Yeah. And one thing I want to say too is with this stuff, I don't think that it necessarily does counter to what your manager's doing. It's more supporting them. I've done this stuff and then it's helped my manager promote me. So it's not necessarily, "Oh, we'll do this if your manager's failing you." Or they are not the boarding you or they can't support you. It's more like do this because this is going to be an accelerator for yourself irrespective of your manager.
(00:18:55):
But then also it'll be an accelerator for your manager in supporting you because one of the things that comes into play a lot when managers figure out promotions and doing those things is they'll sit in a room, often calibrations and with a bunch of people, and it makes it a lot easier when those people have had some access or exposure or whatever to you in a positive light. So these things can all run with your manager and not against, but it's just another way of you taking back the ability to build that momentum instead of relying on all of that going through one single other person.

**中文翻译:**
有的。我想说的一点是，做这些事并不一定是在违背你经理的意愿，更多是在支持他们。我做过这些事，结果反而帮我的经理更容易地提拔了我。所以这不一定是“如果经理对你不好才这么做”，而是无论经理如何，这都是你个人的加速器。

同时，它也是经理支持你的加速器。因为当经理们讨论晋升时，他们通常会聚在一起进行人才盘点（calibrations）。如果房间里的其他人也对你有积极的了解或接触，事情就会变得容易得多。所以这些事可以和经理配合着做，而不是对着干。这只是你夺回主动权、建立势头的一种方式，而不是把一切都寄托在某一个人身上。

---

### [00:19:33] Lenny

**English:**
And what I like about your second example is you just did it. You just started doing that tenant report for the company. It wasn't like, "Hey, I have a proposal, here's what I think you should do. Should we do it?"

**中文翻译:**
我喜欢你第二个例子的原因是：你直接就去做了。你直接开始为公司写那份报告，而不是问：“嘿，我有个提案，我觉得你们应该这么做，我们要不要试试？”

---

### [00:19:42] Lenny

**English:**
It's just like, yeah, just do it.

**中文翻译:**
就像是，“没错，直接做就是了”。

---

### [00:19:44] Laura Schaffer

**English:**
Yeah, ungate your knowledge I think is the buzzword that I'm hearing.

**中文翻译:**
是的，“解禁你的知识”（ungate your knowledge）是我最近听到的一个流行词。

---

### [00:19:52] Lenny

**English:**
Mm. Never heard that.

**中文翻译:**
嗯，没听过这个词。

---

### [00:19:52] Laura Schaffer

**English:**
I think that's an Elena, see how many times we can bring her up. But you can do that within your own company. Everybody is skilled at things that they aren't explicit to their role or their space. And I think that ungating that opens opportunities. And if you're not sure, then go to my favorite go-to, which is talk to customers, get insights. Those are incredibly valuable. So rarely do people share those when they find them. So be the person that does that.

**中文翻译:**
我想那是 Elena 说的，看看我们能提到她多少次。但你可以在自己公司里这么做。每个人都有一些本职工作之外的技能。把这些知识分享出来会创造机会。如果你不确定该分享什么，那就用我最喜欢的那招：去和客户聊聊，获取洞察。这些洞察非常有价值，而且很少有人在发现后会主动分享。所以，去做那个分享的人吧。

---

### [00:20:21] Lenny

**English:**
Another area I want to chat about is experimentation and growth and data, which makes sense if strong perspectives is on being the new head of growth amplitude. So maybe we start with experimentation. You mentioned that there's a really interesting surprising result in an experiment you ran at Twilio that maybe changed your perspective on experimentation and what you think might work and not work.

**中文翻译:**
我想聊的另一个领域是实验、增长和数据，考虑到你刚成为 Amplitude 的增长负责人，你一定有很深刻的见解。我们先从实验开始吧。你提到过在 Twilio 运行的一个实验有一个非常令人惊讶的结果，这可能改变了你对实验以及“什么有效、什么无效”的看法。

---

### [00:20:45] Laura Schaffer

**English:**
A hundred percent. Yeah, I'm through a fortune of two mind-blowing experiments that really shifted the way that I think about growth. So one of them, one of my favorite ones happened very early on at Twilio. So after I created this growth team, one of the things that I saw as to me an issue was that under signup flow, we just asked people for a username and an e-mail, like a password, and that was it. And that's actually relatively common at the time. This is a while ago now, everybody is [inaudible 00:21:16]. But we didn't, and actually there was a lot of existing conviction around that. I was like, "Hey, we retarding developers. Developers, they just want to do, they just want to get their hands on things. Don't put anything in their way, it's going to be disastrous. We don't want any shenanigans here with these folks, let's just let them in the gates."
(00:21:33):
But to me this was a really big assumption to make and a very costly one. It's like, okay, if that's the case, we're not going to know anything about anyone. And we didn't know who was signing up, we didn't know what they wanted to do. And that hurt our ability to understand how people were performing from a quantitative perspective. We were a little bit lost with prioritization. There's a number of implications here, but it's obviously a very contentious space. So this is the very first thing that I did and the first experiment that I ran. I did some research to understand say, okay, what are the most important questions to answer? What would I do really, really need to know? And it was stuff like what language are you coding in, what's your use case? What product you want to use?
(00:22:14):
And then there's one around, are you developer at all or were you use something else? Because there is rumors that we're having, not just developers sign up, which is this whole other interesting story. And I think of these questions that would also potentially be things that our developers signing up would understand why we're asking that it would feel natural. But anyway, again, adding anything to the signup was very contentious, but I really just wanted to get a little bit of data on it. So I wanted to run a test. I didn't have a team, I didn't have an engineering team yet and none of that stuff had built out. It was just me, myself and I. But like I said, I had started to build a little bit of trust and [inaudible 00:22:50], Andre, who I mentioned earlier who, because he was early employee and he had access to everything, one of those people, and he also was supportive of this and had similar haunches.
(00:23:03):
And so like the dead of the night, and by that, I mean 7:00 PM or something, I'm pretty sure it was a Friday. We just asked for forgiveness and put these questions into the signup flow and ran as Navy test with a small group. And I'm fully expecting, "Okay, this is going to hurt our numbers, but maybe it won't be so bad and I'm going to be prepared to advocate the power of this data that we're getting." I was totally thinking with written... Started to write the framework for how I wanted to surface this. And we start to get the data for this thing. I'm not kidding, an improved conversion. There's no personalization, nothing past it, just the questions. It improved conversion by 5%, just improved signups. And it was one of those like, "What? Okay, what is going on here?" And I actually dug into it, and what I found from just talking to a few customers once through the flow, I'm just learning about [inaudible 00:24:00] about it.
(00:24:01):
It was actually for folks, it was comforting. When you think about it, when users are signing up for your product for the very first time, it's new. This is new, that means it's scary. They're expecting it to be difficult. They're anticipating that there's going to be friction and challenges and that they're not going to figure it out. Almost like looking for the bogeyman. And that's the headspace. It's often the headspace that any of us are in when we're doing something new for the first time like ooh, this could be very challenging. And so by putting in these questions it's like, what's your language? It's like, "Oh, I do. I code a JavaScript and I can select that." Well, that's something I'm uncomfortable with. That would make my journey easier. Like "Yeah, bingo. That's my use case. Okay, I'm in the right place here."
(00:24:51):
It was actually giving folks something comforting and challenging the notion that this was going to be difficult, just the questions because it was aligning to some of the things that they were organically thinking about, which is what if they don't support my language? Or can I even do this use case I want to do? And so it was just a really interesting, the takeaway for me for this, the really interest takeaway was the psyche of the user is so, so critical. That's just as important as understanding your product and the broader market you're applying to and all those things. Just the psyche of users, new people doing things for the first time in your user flow, understanding that is powerful. And the simple catchy thing I say is that ultimately the learning here is, bad friction is bad, and good friction is good. There's no such thing as it being simple. It's just all friction is bad, which is what I had assumed going into this.

**中文翻译:**
百分之百。我有幸经历过两个令人大开眼界的实验，它们彻底改变了我对增长的看法。其中一个我最喜欢的实验发生在 Twilio 早期。在我组建增长团队后，我发现注册流程有一个问题：我们只要求用户提供用户名、邮箱和密码，仅此而已。这在当时很常见。但公司内部对此有一种根深蒂固的信念：“嘿，我们的目标受众是开发者。开发者只想动手尝试，别在他们面前放任何障碍，否则会是灾难性的。别搞那些花里胡哨的，直接让他们进来。”

但在我看来，这是一个非常大胆且代价高昂的假设。如果是这样，我们对用户一无所知。我们不知道谁在注册，不知道他们想做什么。这损害了我们从定量角度理解用户表现的能力，我们在优先级排序上也有些迷茫。这显然是一个非常有争议的领域。

所以这是我做的第一件事，也是我运行的第一个实验。我做了一些研究，想弄清楚：哪些是最需要回答的问题？我真正需要知道什么？答案包括：你用什么语言编程？你的使用场景是什么？你想用什么产品？还有一个问题是：你到底是不是开发者？因为有传言说注册的不只是开发者，这又是另一个有趣的故事。

我设计的这些问题，是希望开发者能理解我们为什么要问，让他们觉得很自然。但无论如何，在注册流程中增加任何内容都是极具争议的。我只想获得一点数据，所以我决定做一个测试。当时我还没有团队，没有工程团队，什么都没有。只有我一个人。但正如我所说，我已经建立了一点信任。Andre（我之前提到的那位老员工）支持我，他也有类似的直觉。

于是在一个深夜（大概是周五晚上 7 点），我们抱着“先斩后奏”的心态，把这些问题加入了注册流程，并针对一小部分用户进行了 A/B 测试。我完全预料到：“好吧，这会降低转化率，但也许不会太糟，我会准备好去论证这些数据的价值。”我甚至开始写展示框架了。

结果数据出来后，我没开玩笑，转化率提高了。没有任何个性化，后面什么都没改，仅仅是加了问题。注册转化率提升了 5%。我当时想：“什么？这怎么可能？”我深入研究了一下，通过与几个走完流程的客户交谈，我发现：对于用户来说，这其实是一种安慰。

想想看，当用户第一次注册你的产品时，一切都是陌生的。陌生意味着恐惧。他们预感会很难，预感会有摩擦和挑战，担心自己搞不定。就像在寻找“妖怪”一样。这是人们尝试新事物时的普遍心态。

通过加入这些问题，比如“你用什么语言？”，用户会想：“哦，我用 JavaScript，我可以选这个。这是我熟悉的东西，这会让我的旅程更容易。”或者“没错，这就是我的使用场景，我来对地方了。”这些问题实际上给了用户安慰，挑战了“增加内容就会变难”的观念，因为这些问题契合了他们内心本就在担心的事情，比如“他们支持我的语言吗？”或“我能实现我想做的场景吗？”

所以这非常有趣。对我来说，核心教训是：用户的心理（psyche）至关重要。这与理解产品和市场同等重要。理解用户流程中第一次尝试的新人的心理是非常强大的。我总结的一句简单易记的话是：坏的摩擦是坏的，好的摩擦是好的。事情没那么简单，并不是“所有摩擦都是坏的”，而这正是我之前的假设。

---

### [00:25:50] Lenny

**English:**
I love that you were new to Twilio and you just year-load an experiment to production.

**中文翻译:**
我喜欢你刚到 Twilio 就直接把实验推向生产环境这种“硬刚”（YOLO）的做法。

---

### [00:25:55] Laura Schaffer

**English:**
Year-load. Yeah.

**中文翻译:**
哈哈，是的。

---

### [00:25:56] Lenny

**English:**
That's a big move.

**中文翻译:**
这动作可真够大的。

---

### [00:25:58] Laura Schaffer

**English:**
It ended up being very helpful for everyone. I shared the insights from it and all these things. I've shared the [inaudible 00:26:05].

**中文翻译:**
结果证明这对每个人都很有帮助。我分享了从中获得的洞察，还有所有这些东西。

---

### [00:26:05] Lenny

**English:**
And [inaudible 00:26:05] conversion.

**中文翻译:**
而且还提高了转化率。

---

### [00:26:08] Laura Schaffer

**English:**
But for sure, use such processes with caution for sure. Yeah.

**中文翻译:**
但当然，使用这种流程一定要谨慎。是的。

---

### [00:26:08] Lenny

**English:**
I love it. It's amazing.

**中文翻译:**
我太喜欢这个故事了，太神奇了。

---

### [00:26:15] Laura Schaffer

**English:**
That the right way to do [inaudible 00:26:15] advocating for the engineers here is the right way to make any changes in production is through or with the approval of engineering, but it was the right move overall and definitely helped business, so yeah.

**中文翻译:**
正确的方法（在这里我要为工程师们说句话）是在生产环境中做任何更改都应该经过工程部门的批准。但总的来说，那是一个正确的举动，确实对业务有帮助。

---

### [00:26:33] Lenny

**English:**
Yeah, I love it. No, that's great. I like that move. I think we need more of that probably. I want to dig into what you actually... So what is it you changed, you added how many questions and then what were the questions?

**中文翻译:**
是的，太棒了。我喜欢这种做法，也许我们需要更多这样的尝试。我想深入了解一下你具体改了什么……你增加了多少个问题？具体是什么问题？

---

### [00:26:37] Laura Schaffer

**English:**
There was a question around what language are you coding in? And then as an option to that, it was like, "Oh, I'm actually not coding, I'm not a developer." So for us, it actually gave us two really, really interesting data points. One was how many developers versus people who are not coding or in our flow? And then what language of the coding, which was massively helpful not just for growth and onboarding, but our documentation team, dos team. Would that end up being a critical way for us to gauge trends over time and catch things before whatever reports would come out at the end of the year, what people are doing, you start to see it. And then also product. What product are you interested in using? That was very critical for knowing the basics of how to organize someone's onboarding. Are you doing SMS? You're doing voice? To 281 or whatever. And then use case in use cases, you're doing a appointment reminders or are you doing a autoresponder or are you doing anonymous communications for a dating app or something. Right? So those were the very first questions.

**中文翻译:**
有一个问题是“你使用什么编程语言？”。选项中还包括“我不写代码，我不是开发者”。这对我们来说提供了两个非常有趣的数据点：一是我们的流程中有多少开发者和非开发者；二是他们使用什么语言。这不仅对增长和新手引导（onboarding）有巨大帮助，对文档团队也是如此。这成了我们衡量长期趋势的关键方式，让我们在年底报告出来前就能发现用户在做什么。

然后还有关于产品的问题：“你对使用哪个产品感兴趣？”这对于了解如何组织用户的新手引导至关重要。你是要做短信（SMS）？语音？还是别的？最后是关于使用场景（use case）：你是要做预约提醒、自动回复，还是为约会软件做匿名通信？这些就是最初的几个问题。

---

### [00:27:39] Lenny

**English:**
Wow, okay. So it was four dropdown questions and that increased conversion. I love these examples where friction and increased conversion... There's so few of them. You hear about this could work and it's rare. And so what did you take away? What's the pattern you took from this? There's the idea, it's good friction, but is there something that you're like, what is a sign of this is going to be good friction?

**中文翻译:**
哇，好吧。所以是四个下拉菜单问题，反而提高了转化率。我太喜欢这种“增加摩擦却提高转化”的例子了，这种例子太少了。虽然听过这种理论，但实际发生的很少。那么你从中总结出了什么？你发现的模式是什么？除了“好的摩擦”这个概念，有没有什么迹象能让你预判“这将会是好的摩擦”？

---

### [00:28:02] Laura Schaffer

**English:**
There's still alleviated a problem. They alleviated the problem they had where they're coming in and worried that it was going to be difficult or that they weren't going to be able to figure it out, they weren't going to be able to get their footing. And I'd say that that's not unique to Twilio. That's something that I think users experience at any front door, at any company, any signup beginning the signup loads, it's like, "Here we go, buckle up." Especially when it's in a work context and there might be extra pressure on you to succeed or for you to make as an accurate assessment. So I think that psyche of, "Okay, am I in the right place? Is it's going to do what I need it to do? Can I figure it out? Am I capable?" These are extremely common things for people to feel when they're signing up.
(00:28:48):
And so certainly, that I think can carry out to any place. I'd encourage absolutely everybody to be putting those experiences within their early onboarding, not just for you selfishly, so you can learn and segment them appropriately, but also so the user can feel more confident as they get going and like, "Hey, I'm in the right place. This is going to do what I needed to do." But I think that the carry over there is just the psyche of the user and just being so aware that it's not so cookie cutter as, "What is the problem my market experience is and what can my product do to help them?" There's also this other thing in the room which is so important to people's success, their ability to succeed with your products and your self-serve experiences, which is, what is the mentality and the psyche of the person at the various stages in your journey?
(00:29:37):
And if you're not incorporating that or addressing that, you will absolutely miss things or things will fail and you'll be very confused as to why. We had a great experiment that I'm happy to talk about where same concept, a totally different situation, which is later in onboarding. One of the things that we tried to do over time to make Twilio less complex was to offer steps like, [inaudible 00:30:08] onboarding, welcome step one, here's what you want to build. Great, we all know that now, "Okay, step one, go do this thing. Step two, go to this thing. Three, this thing. Four, this thing. Five, bam, you're live, congratulations, aha," all these things. So we shipped that, got that out there and I was like, yeah, it was improved conversion. It wasn't like that great. It's like, man. We went from there being absolutely nothing, "Choose you're adventure, figure it out, go figure it out. Good luck." To this prescriptive thing. And it wasn't converting [inaudible 00:30:37].
(00:30:38):
So to talk to some users and there wasn't anything particularly obvious that was coming out as to what the issue was. It was like, "Oh yeah, Let's go to step one." And we did mock the people. "Okay, now I know, I do step two." But there was one thing that I was hearing that was coming out that feels like something, and that was the telephone number, the telecom part. Developers when they were coming into Twilio, it was things that were familiar to them. APIs, the language they're coding in, code samples, documentation, things like the bogeyman, the things that would psychologically trip them up, telecom, phone numbers. These things that just were completely out of the zone of anything that they'd ever worked with before, especially earlier on in Twilio's journey.
(00:31:28):
But even now, right? Telecom's very different beast for most developers. And guess what was step one? Get a phone number because that's step one. Anytime that anyone's trying to teach one to use Twilio one-on-one, always going to sit down, ask and be like, "Okay, here we're going to go get a phone number and configure it." And that's what anyone every time will do. However, in a self-serve experience, when you don't have that safe person sitting next to you being like, "Don't worry, it's going to be okay, I'm going to take you through this crazy telecom journey." They're on their own, but that's psyche telling is them like, "Oh my god, telecom. Well, I can't do that. That sounds scary. We're getting a phone number configured. Whoa, I'm out of my debt."
(00:32:01):
And so what did we do to test this out? Test out whether that was the issue? Actually, and it's first we're in the MVP. They kicked them out of the portal entirely and put them into a docs page where we could manufacture an experience where the first thing they saw was code and they're in the docs safe place, the language that they're coding in and then snuck in there.
(00:32:26):
It was like, "Oh, get a phone number, let's go configure it." Not as step one, not as the leading thing, but embedded. And the analogy I have for this is pilling a hot dog. So if anyone's got a dog or an animal you have to feed a pill to, it's like you can't just feed the pill to the animal, it's never going to happen. But if you shove it inside of a hot dog, which looks good and that's exciting, then you can get them to consume it more easily. And so this was-

**中文翻译:**
这些问题缓解了一个问题。它们缓解了用户进入时的担忧：担心太难、担心搞不定、担心找不到方向。我认为这不仅限于 Twilio。用户在任何公司的“大门口”，在任何注册流程开始时都会有这种感觉：“好了，系好安全带，要开始了。”特别是在工作场景下，你可能会面临成功的压力，或者需要做出准确评估的压力。所以这种心理——“我来对地方了吗？这能实现我的需求吗？我能搞定吗？我有这个能力吗？”——是人们注册时极其普遍的感受。

因此，我鼓励每个人都在新手引导的早期加入这些体验。这不仅是为了你自己能学习和进行用户分群，也是为了让用户在开始时感到更有信心：“嘿，我来对地方了，这能满足我的需求。”这里的核心在于关注用户的心理，意识到这不仅仅是简单的“市场有什么问题，我的产品能帮什么”。还有一个非常重要的因素：用户在旅程各个阶段的心态和心理状态。

如果你不考虑或不解决这个问题，你绝对会遗漏一些东西，或者导致失败，而且你会对失败的原因感到困惑。我们做过另一个很棒的实验，概念相同但情况完全不同，是在新手引导的后期。为了降低 Twilio 的复杂性，我们尝试提供分步引导，比如：“欢迎，第一步，你想构建什么？太好了。第一步，去做这件事；第二步，做那件事……第五步，砰，你上线了，恭喜！”

我们上线了这个功能，转化率有所提高，但没那么理想。我们从完全没有任何引导（“祝你好运，自己摸索吧”）变成了这种指令式的引导，但转化率并没有大幅提升。于是我们和用户聊了聊，并没有发现什么显而易见的问题。用户会说：“哦，好的，去第一步，然后我知道要做第二步。”但有一件事引起了我的注意，那就是“电话号码”，也就是电信（telecom）部分。

开发者进入 Twilio 时，API、编程语言、代码示例、文档都是他们熟悉的东西。而那些会让他们在心理上产生畏难情绪的“妖怪”，就是电信和电话号码。这些东西完全超出了他们之前的知识范围，尤其是 Twilio 早期。即使是现在，电信对大多数开发者来说也是个完全不同的领域。

猜猜第一步是什么？“获取一个电话号码”。因为那是第一步。任何一对一教别人用 Twilio 的人都会说：“好了，我们先去拿个号码并配置它。”每个人都会这么做。然而，在自助服务体验中，没有那个“安全的人”坐在你旁边说“别担心，没事的，我会带你走完这段疯狂的电信之旅”。用户是孤身一人的，他们的心理会告诉他们：“天哪，电信。我搞不定，这听起来很吓人。配置电话号码？哇，这超出了我的能力范围。”

为了测试这是否是问题所在，我们在 MVP（最小可行性产品）阶段做了一件事：把用户完全踢出控制台，带到一个文档页面。在那里我们制造了一种体验：他们首先看到的是代码，是在文档这个“安全地带”，用他们熟悉的语言。然后我们把“获取电话号码”偷偷塞了进去。

它不再是第一步，不再是主导内容，而是嵌入式的。我对此有一个比喻，叫“给热狗塞药”（pilling a hot dog）。如果你养过狗，要给它喂药，你不能直接喂，它不会吃的。但如果你把药塞进热狗里，热狗看起来很好吃，很诱人，它就会很容易地吃下去。所以这就是——

---

### [00:32:53] Lenny

**English:**
Yeah. We do peanut butter, that's [inaudible 00:32:55].

**中文翻译:**
是的，我们用花生酱，效果一样。

---

### [00:32:55] Laura Schaffer

**English:**
Yeah, exactly, right? Yeah, hot hotdog, peanut butter, all that. You bury it. You embed the scary unpleasant thing. And so that's what you said with the phone number stuff, that telecom stuff. And guess what? Even though we're a good amount of the console and they're going off and we had no easy return button, it converted better because we were addressing the big problem that was there at the time, which is their psyche. They were not ready to come in and immediately thrown into a phone number experience. That was letting the bogeyman and out to party and that's not what was going to work. We needed to put that bogeyman pill and the hotdog.
(00:33:31):
And so then once that validated, then we can actually go through the business of putting that into the onboarding float correctly and then that could be even better. But so again, the psyche of your user is such a critical thing to be thinking about. And if something very logical isn't converting well sometimes, it means that you're battling against the psyche of a user and you want to take a step back and think about and learn about where someone is psychologically in your space.

**中文翻译:**
没错，热狗、花生酱都行。你把它埋起来，把那个吓人的、不愉快的东西嵌入进去。这就是我们对电话号码和电信部分所做的。猜猜结果如何？尽管我们把用户带离了控制台，而且当时还没有方便的返回按钮，但转化率反而更高了。因为我们解决了当时最大的问题，即用户的心理问题。他们还没准备好一进来就被扔进电话号码的配置体验中。那就像是把“妖怪”放出来狂欢，那是行不通的。我们需要把那个“妖怪药片”塞进热狗里。

一旦这个假设得到验证，我们就可以正式地把它正确地放入新手引导流程中，效果会更好。所以再次强调，用户的心理是一个极其关键的考量因素。如果某些逻辑上非常合理的东西转化率却不好，那通常意味着你在与用户的心理作斗争。你需要退后一步，思考并了解用户在你的领域中处于什么样的心理状态。

---

### [00:33:59] Lenny

**English:**
Feels like you had this experiment that was a complete redesign of the onboarding flow and that didn't work. And then your second attempt was a different approach that's like a full onboarding flow. And I'm curious, do you have a take on just when you run experiments? And it's something we dealt with a lot at Airbnb in other places is like, do you just redesign the whole thing or is it better to iteratively work from where you're today and just experiment piece by piece towards some future much better experience?

**中文翻译:**
听起来你经历过那种彻底重新设计新手引导流程但失败的实验。然后你的第二次尝试采用了不同的方法。我很好奇，关于什么时候运行实验，你有什么看法？我们在 Airbnb 和其他地方经常遇到这种问题：是直接重新设计整个东西，还是基于现状进行迭代，一步步通过实验走向未来更好的体验？

---

### [00:34:26] Laura Schaffer

**English:**
Here's what I would say to this is that from a high level, it's always going to be better to be iterative. And the reason that it's better is that roughly 80% of the times, ORs in the time are hypotheses and the things that we believe will be true [inaudible 00:34:42]. And this is amazing. There's an amazing article out there I'm happy to share with you so you can put in the show notes.

**中文翻译:**
关于这一点，我想说的是：从宏观层面来看，迭代（iterative）总是更好的。原因在于，大约 80% 的假设，也就是我们认为会奏效的事情，其实都是错的。这很惊人。有一篇非常棒的文章，我很乐意分享给你，你可以把它放在节目介绍里。

---

### [00:34:48] Lenny

**English:**
Yeah, absolutely.

**中文翻译:**
好的，没问题。

---

### [00:34:49] Laura Schaffer

**English:**
That really takes a scientific approach to proving that out. Companies like Netflix and Microsoft, there's over and over again 80 plus percent. Some companies say 90% of things fail. And so the closer you get to something that you go bear your head in the sand or go into an attic and build something for six months and ship it, the more likely it is that you are going to ship the 80% wrong stuff.
(00:35:17):
Whereas the more iterative you are, the more likely that you're going to catch it sooner. And failure doesn't have to be a wall, it can be a compass, it can be the thing that leads you to the right thing. And so you always want to as best you can, get stuff in front of customers so that you can get that compass and get that compass activated, know where to go.
(00:35:40):
So that means doing ugly things. I tell my teams all the time, if it's not embarrassing, you've gone too far. Got to be embarrassing. The first thing, that was embarrassing, kicking people out, onboarding, spend all this money and whatever to get them into your center flow, and then the first thing we do, get out of here. That's nuts. But if it hadn't validated, that would've been a very cheap but very valuable learning. Instead, it was a very powerful cheap learning in the other direction. Okay, now we know we can invest in it. We know that's the right thing to do. So always better to be iterative so that you are letting failure work for you instead of having it be a trap that you fall into.

**中文翻译:**
那篇文章用科学的方法证明了这一点。像 Netflix 和微软这样的公司，一次又一次地证明 80% 以上的假设是错误的，有些公司甚至说是 90%。所以，如果你选择闭门造车，躲在阁楼里开发六个月再发布，你极有可能发布的是那 80% 错误的东西。

而你越是迭代，就越能早点发现错误。失败不一定是一堵墙，它可以是一个指南针，指引你走向正确的方向。所以你要尽可能地把东西推到客户面前，激活那个“指南针”，知道该往哪走。

这意味着要做一些“丑陋”的事情。我经常告诉我的团队：如果这个东西不让你感到尴尬，说明你做得太过了。必须得让人感到尴尬。第一件事（把用户踢出新手引导流程）就很尴尬，花了那么多钱把用户引进来，结果第一件事就是让他们“滚出去”，这太疯狂了。但如果它没有得到验证，那也将是一个成本极低但价值极高的教训。相反，它成了一个在另一个方向上非常强大的低成本教训。现在我们知道可以投入资源了，知道那是正确的事。所以，迭代总是更好的，这样你就能让失败为你服务，而不是掉进失败的陷阱。

---

### [00:36:22] Lenny

**English:**
I know that you just shared as per experiment, you're probably wrong 80% of the time. In my experience, launching a halt redesign is as negative a hundred percent of the time. I've grown weary to avoid that as much as possible, which is like, you know that, you're taught that as you go into growth and product, but you're just like, "Nah, come on, let's just make it awesome. Just redesign this whole thing." Especially your designers is always like, "No, let's start again. Let's make it amazing." But it always ends up being negative and you're like, "Okay, well, it's too late now we got to launch this thing, we don't have time to start again."

**中文翻译:**
我知道你刚才分享说实验有 80% 的概率是错的。根据我的经验，发布一个完整的重新设计（redesign），其负面影响的概率几乎是 100%。我已经对此感到厌倦并尽可能避免了。虽然在进入增长和产品领域时大家都学过这一点，但你总会想：“不，别这样，让我们把它做得更棒，把整个东西重新设计一遍。”特别是设计师总会说：“不，让我们推倒重来，做一个惊艳的东西。”但结果总是负面的，然后你会想：“好吧，现在太晚了，我们必须发布，没时间重做了。”

---

### [00:36:52] Laura Schaffer

**English:**
Well, it's funny, in the articles, and you'll see it was written by somebody from Microsoft who built Implementation platform and did all these cool things, as he went into actually trying to apply a scientific method of figuring out how often people are wrong about their hypotheses and what they're planning to do. He's like, "I wonder if that applies to us here at Microsoft." Even for him, that question of [inaudible 00:37:16]. And I think it's challenging when there's a lot of smart people in this space doing things and it's very difficult to think, "Gosh, am I really wrong? 80 plus, 90% of the time?" But when you think about it, makes total sense because what has to happen for something to be successful? You have to understand the problem perfectly. You have to then understand who's having the problem perfectly, the customer. At what time they're having the problem.
(00:37:43):
Then you've got to put the right solution in front of them to solve that problem. Maybe you've got the problem, all that stuff, but your solution something off. Or maybe your solution is right, but maybe it's just not presented, it communicated in the right way. You could have any one of those things off and it's not going to succeed. It's not going to have the metric impact you're expecting it to have. So in that context, it's almost like incredible. We do succeed 20 to 10% of the time given everything that has to line up. And so I think it's one of those things where you really want to go into it embracing that, "Okay, this isn't about how smart I am or how good my team is or any of that stuff. It's just the logic of this is challenging to get it right and let's embrace that and let's lean into that knowledge and make it a part of our strategy," instead of finding against it.

**中文翻译:**
很有趣，在那篇文章里（作者是微软的一位构建实验平台的专家），当他尝试用科学方法计算人们对假设的错误频率时，他也在想：“我想知道这是否也适用于我们微软。”即使对他来说，这也是个问题。我认为当这个领域有很多聪明人时，承认“天哪，我真的有 80% 到 90% 的时间是错的吗？”是非常困难的。

但仔细想想，这完全合理。因为要获得成功，需要满足多少条件？你必须完美地理解问题；必须完美地理解谁遇到了问题（客户）；必须知道他们什么时候遇到问题。然后你得在他们面前展示正确的解决方案。也许你找准了问题，但解决方案不对；或者解决方案是对的，但呈现或沟通的方式不对。只要其中任何一个环节出错，它就不会成功，不会产生预期的指标影响。

所以在这个背景下，考虑到所有这些因素必须同时对齐，我们能有 10% 到 20% 的成功率简直是奇迹。因此，你应该抱着这样的心态：“好吧，这与我有多聪明或我的团队有多优秀无关。这只是因为把事情做对的逻辑本身就极具挑战。让我们接受这一点，并将其纳入我们的策略，而不是与之对抗。”

---

### [00:38:39] Lenny

**English:**
Have you found anything that helps you increase those odds or is just, this is the way of the world and you probably can't significantly increase the chances your experiment works out?

**中文翻译:**
你有没有发现什么方法能提高成功的概率？还是说这就是世界的运行规律，你无法显著提高实验成功的机会？

---

### [00:38:51] Laura Schaffer

**English:**
So here's the thing, I think there's very little that we can do to make that space easier. All those things have to be figured out. And so I definitely think that everybody is going to be in a space where their original ideas, untested ideas are going to be around that hit rate. However, the way that you go about validating those can be totally different and you can be very fast about validating those ideas and that's the key. And AB testing is one of the most expensive kinds of ways to validate an experiment. It often requires design and engineering and the PM or growth person or marketing person who's crafting it. All these things are investments that take a lot of time even for simple thing. And then you have the time factor, how long's the thing I have to run to have an impact?
(00:39:47):
So all of that is extremely expensive. And so I think the key is to just think through, "Okay, what are the things I can do to quickly validate what these ideas are that we [inaudible 00:39:59]?" And you can do that with painted doors, which is where you test rate the concept and the idea before it exists versus the actual experience. You can do mocks. If you've got a designer, create those mocks for that experience, put it in front of people, see how they engage with it. That can be so powerful.
(00:40:16):
You could invalidate tons of hypotheses at that state. The only things you want to get to that deep AB testing environment or ones that have been vetted along the way. And that way, you reduce your fail rate, because you're failing faster by using other methods. So I think I more advocate for that side. Let's fail fast by using those tools rather than figuring out a way that you can rise above where everyone else is operating and figure out ways to solve all that complex stuff better because that's going to be challenging, but you can always get better at experimenting and validating things faster.

**中文翻译:**
是这样的，我认为我们很难让这个过程变得更容易，所有那些环节都必须搞清楚。所以我认为每个人的原始想法、未经测试的想法，其命中率大概都在那个水平。然而，你验证这些想法的方式可以完全不同。你可以非常快速地验证这些想法，这就是关键。

A/B 测试是验证实验最昂贵的方式之一。它通常需要设计、工程，以及 PM、增长人员或营销人员的参与。即使是简单的事情，这些投入也需要很多时间。然后还有时间因素：这个测试需要运行多久才能产生显著影响？

所有这些都极其昂贵。所以关键在于思考：“我能做些什么来快速验证这些想法？”你可以使用“虚设门测试”（painted doors），即在实际体验存在之前测试概念和想法。你可以做原型（mocks）。如果你有设计师，制作这些体验的原型，展示给人们看，观察他们的反应。这非常有效。

在那个阶段，你可以排除大量的假设。你只想把那些经过初步筛选的想法带入深度的 A/B 测试环境。这样，你就能降低失败率，因为你通过其他方法“失败得更快”了。所以我更提倡这一面：利用这些工具快速失败，而不是试图找到一种超越常人的方法来更好地解决所有复杂问题。那太难了，但你总能通过更快的实验和验证来不断进步。

---

### [00:40:59] Lenny (Sponsor: Writer)

**English:**
This episode is brought to you by Writer. How much hype have you been hearing about generative AI? So much. But how do you take it from a shiny toy to an actual business tool that helps you do your actual job? Writer is an enterprise grade generative AI platform built specifically for the needs of businesses and already widely deployed at world-class brands like Uber, Spotify, HubSpot, and UiPath. With writer, you can break through content bottlenecks across your organization from marketing webpages to sales e-mails in product messages to creating high quality on-brand content at scale.
(00:41:34):
And unlike other AI applications, writers' training happens securely on your data and your style and brand guidelines that you provide specific to your organization. The result is that you get consistent content in your brand voice at scale. Get AI that your people will love for a limited time. Listeners to Lenny's podcast and get 20% off if they go to writer.com/lenny, that's writer.com/lenny.

**中文翻译:**
本期节目由 Writer 赞助。关于生成式 AI 的炒作你听过多少？太多了。但如何把它从一个闪亮的玩具变成一个能帮你完成实际工作的业务工具呢？Writer 是一个企业级的生成式 AI 平台，专为企业需求打造，已被 Uber、Spotify、HubSpot 和 UiPath 等世界级品牌广泛采用。有了 Writer，你可以突破整个组织的内容瓶颈，从营销网页到销售邮件，从产品内消息到大规模创建高质量、符合品牌调性的内容。

与其他 AI 应用不同，Writer 的训练是在你的数据、风格和品牌指南上安全进行的。结果就是你可以大规模获得符合品牌语调的一致内容。在限定时间内，Lenny 播客的听众访问 writer.com/lenny 即可享受 20% 的优惠。

---

### [00:41:59] Lenny

**English:**
Where do you find the best ideas come from for driving meaningful lift? Is it gut instinct type and experience bucket or is it data telling you like, "Hey, or here's a huge opportunity," in your experience?

**中文翻译:**
根据你的经验，那些能带来显著提升的最佳创意通常来自哪里？是直觉和经验，还是数据告诉你说“嘿，这里有一个巨大的机会”？

---

### [00:42:15] Laura Schaffer

**English:**
I'm a very data-driven person. I self-describe and think of myself that way. In large part because of that, I feel you have to be constantly checking yourself and data is a really great way to do that. But I definitely think that I would be described as someone who's going more by their gut when looking at date end results just because of the way that I approach it, which is I'm very comfortable and very common in using qualitative responses and things like that and supplement to quantitative data to make a decision and that puts less of a burden on the quantitative to really make an assessment of whether something was working or not.
(00:42:51):
One of the things I see, I think sometimes goes against what other folks do, although I'm seeing things shift a little, is that 95% confidence rate. My background in college, I was in a lab running experiments or really publishing two journal and stuff and we had to have that 95% confidence rate, had to because the things that were coming out of the lab and being published were influencing things like how we do education and how we understand how bias works and when it shows up and therefore how we can combat it.
(00:43:23):
Things were wrong. And sending a bunch of bologna, that can cause some significantly bad things like false positive, false negatives in that context can be very dangerous, for lack of a better word. And you think of other pharmaceuticals, the 95% confidence rate belongs in some companies and some industries because the risk of failure on the impact of a false success is very high.
(00:43:47):
But those of us converting users and trying to upsell folks, we are very fortunate to not have that level of burden on us and we can take advantage of that. And so there are definitely times where I will advocate for and I will push for and I will myself use lower confidence intervals and 95%, especially if that doubles amount of experiments that you can run in a year. End of the day, these are all methods that we use to try to validate the hypotheses that we have. And if you're doing a 95% confidence in a role, you're still accepting a 5%, some amount of false success, do that a little bit more, challenge you to do that a little bit more. And then run way more experience. If you look at the net of what your team is doing over the course of year, what you're doing over the course of a year, you will be positive.

**中文翻译:**
我是一个非常数据驱动的人，我也这样定义自己。很大程度上是因为我觉得必须不断地审视自己，而数据是做到这一点的好方法。但我肯定会被描述为一个在看数据结果时更倾向于“直觉”的人，这仅仅是因为我的方法论：我非常习惯使用定性反馈（qualitative responses）来补充定量数据，从而做出决策。这减轻了定量数据在评估“某事是否有效”时的负担。

我看到的一件事（虽然现在情况在改变）是大家对 95% 置信度（confidence rate）的执着。我大学时在实验室做实验、发表论文，我们必须达到 95% 的置信度。必须如此，因为实验室出来的结果会影响教育方式、我们对偏见的理解以及如何应对它。如果错了，发布一堆胡言乱语，会导致严重的后果，比如假阳性或假阴性在那种背景下是非常危险的。在制药等行业，95% 的置信度是必须的，因为“虚假成功”的风险极高。

但对于我们这些做用户转化和追加销售的人来说，我们很幸运，没有那么重的负担，我们可以利用这一点。因此，我有时会主张甚至推动使用低于 95% 的置信区间，特别是如果这能让你一年的实验数量翻倍的话。归根结底，这些都是我们用来验证假设的方法。如果你坚持 95% 的置信度，你仍然在接受 5% 的虚假成功概率。稍微放宽一点，多跑一些实验。如果你看团队一整年的净产出，你会发现结果是正向的。

---

### [00:44:42] Lenny

**English:**
Wow, that is a big idea. Idea of releasing the P-value confidence interval for experimentation and data teams. Everyone would be excited about this. Probably maybe not some data scientists on teams. Do you do that? How do you act? Is that how you operate on your teams? Just like we don't need 95% competence?

**中文翻译:**
哇，这真是个大胆的想法。放宽实验和数据团队的 P 值置信区间。大家都会为此感到兴奋，除了团队里的一些数据科学家。你真的这么做吗？你是怎么操作的？你的团队就是这样运作的吗？直接说“我们不需要 95% 的置信度”？

---

### [00:45:03] Laura Schaffer

**English:**
So I'll say this, this is actually very critically important. You must have this game plan set before you run something. Failure mode that I see so many teams fall into is they'll run the experiment or whatever it is and then they'll make the data fit the hypothesis. Or sometimes they'll go without a hypothesis and just be like, "This is going to do better things for our metrics," but not a core reason as to why or what exactly are we testing here. And so this is another area we could absolutely fall into that trap. "Let's [inaudible 00:45:36] on good 80. I think it's good. That Laura person said it was cool. So I think that that's fine." That will always be a trap. So it needs to be very deliberately thought of in advance as a way of like, "Hey, here's how we're going to validate this." And always, always, always, if you're going to accept more risk of a false success or false positive, false negative, you want to then be really thinking about how you're going to harden your validation of a hypothesis.
(00:46:03):
For example, let's take that when we talked about with Twilio where we are kicking people out and we're sending them to the pilling hotdog experiment, and we're sending people to that experience to hide the phone number. Now in that case, let's say that we were going to accept a lower confidence interval. I would very much want to see qualitative feedback to confirm that that hypothesis was true. I want to be looking at the qualitative data from the ones where people were thrown into the existing flow and one's put into the dogs that one of them felt more confident and more like this was really easy to get through and they felt out of a territory and things like that. And I'd be wanting to hear from the ones who were in the other one, things like, "Oh, I got stuck on that [inaudible 00:46:48]." Like, "Figure this out, but it feels like it's that amount of my depth."
(00:46:52):
I would want to be looking for other things to corroborate the hard data that I'm seeing. And yes, it opens the door to whenever you open the door to more risk acceptance, you are going to have some false successes there. But all of these things together can overall make it more likely that you're shipping more things that are going to positively influence the customer. And again, I can't say it enough. It is a huge risk in and of itself to not ship as much as you possibly could in a year. That is a huge risk given that very high fail rate. So to those data scientists, and I've chatted with a few of my time, what I try to explain is that that article, that data that the 80%, that's hard data about what a detriment it can be if you don't run an enough experiments.
(00:47:51):
If you just run 10 in a year on there, maybe two around impact, two of a course of an entire year if you take that approach. So data scientists can understand, "Hey, if we do this, if we run this down, we can double or triple whatever it is, the number of experiments where we can run and overall net that's going to result in more successes that will overall net us to a positive place." You can still tell a data story to the data scientist about why you're doing this. Again, this is why when you asked that question identify, as a very data-driven person. But I think some of the methods that I use can sound at the service level as more like, "Oh, I'm going by my gut." But again, very data driven is just embracing the reality of some of the hard data that I don't think we all embrace or are even aware of sometimes about that fail rate.

**中文翻译:**
我要说明一点，这其实非常关键：你必须在运行实验之前就制定好计划。我看到很多团队陷入的失败模式是：先跑实验，然后让数据去强行符合假设。或者有时根本没有假设，只是说“这会让指标变好”，但没有核心原因，也不知道到底在测试什么。如果我们只是说“Laura 说 80% 的置信度也行，那就这样吧”，那绝对是个陷阱。

所以必须提前深思熟虑：“嘿，这就是我们要验证它的方式。”而且，如果你打算接受更高的“虚假成功”风险，你就必须思考如何加强对假设的验证。

例如，回到 Twilio 的那个“热狗塞药”实验。如果我们接受较低的置信区间，我就会非常希望看到定性反馈来确认假设。我会观察那些被放入文档页面的用户的定性数据，看他们是否感到更自信、觉得更容易上手。同时观察另一组用户，看他们是否会说“我卡在那个环节了”或“这超出了我的能力范围”。

我会寻找其他证据来佐证我看到的硬数据。是的，接受更多风险意味着会有一些虚假成功。但综合来看，这能让你发布更多对客户有积极影响的东西。我再强调一遍：一年内不尽可能多地发布东西，本身就是巨大的风险，尤其是考虑到极高的失败率。

对于那些数据科学家，我会解释说：那篇关于 80% 失败率的文章是硬数据，它说明了实验数量不足的危害。如果你一年只跑 10 个实验，可能只有 2 个有影响。如果我们将实验数量翻倍或翻三倍，最终获得的成功总数会更多，整体结果会更正向。你可以向数据科学家讲述这个关于“为什么这样做”的数据故事。这就是为什么我自认为是非常数据驱动的人，尽管我的方法听起来像是在凭直觉。其实，这只是在拥抱那些关于失败率的残酷现实。

---

### [00:48:42] Lenny

**English:**
This episode is brought to you by Writer. How much hype have you been hearing about generative AI? So much. But how do you take it from a shiny toy to an actual business tool that helps you do your actual job? Writer is an enterprise grade generative AI platform built specifically for the needs of businesses and already widely deployed at world-class brands like Uber, Spotify, HubSpot, and UiPath. With writer, you can break through content bottlenecks across your organization from marketing webpages to sales e-mails in product messages to creating high quality on-brand content at scale.
(00:41:34):
And unlike other AI applications, writers' training happens securely on your data and your style and brand guidelines that you provide specific to your organization. The result is that you get consistent content in your brand voice at scale. Get AI that your people will love for a limited time. Listeners to Lenny's podcast and get 20% off if they go to writer.com/lenny, that's writer.com/lenny.

**中文翻译:**
本期节目由 Writer 赞助。关于生成式 AI 的炒作你听过多少？太多了。但如何把它从一个闪亮的玩具变成一个能帮你完成实际工作的业务工具呢？Writer 是一个企业级的生成式 AI 平台，专为企业需求打造，已被 Uber、Spotify、HubSpot 和 UiPath 等世界级品牌广泛采用。有了 Writer，你可以突破整个组织的内容瓶颈，从营销网页到销售邮件，从产品内消息到大规模创建高质量、符合品牌调性的内容。

与其他 AI 应用不同，Writer 的训练是在你的数据、风格和品牌指南上安全进行的。结果就是你可以大规模获得符合品牌语调的一致内容。在限定时间内，Lenny 播客的听众访问 writer.com/lenny 即可享受 20% 的优惠。

---

### [00:48:42] Lenny

**English:**
This is awesome. This is a big idea. Have you written about this anywhere for folks that maybe want to try this approach at their company? And if not, you should.

**中文翻译:**
太棒了，这真是个伟大的想法。你有没有在什么地方写过这个，好让想在公司尝试这种方法的人参考？如果没有，你应该写一下。

---

### [00:48:50] Laura Schaffer

**English:**
I appreciate that. It's funny, it's like all my general life to do is just start writing some of this down. I have three children, one of whom is five months old, and then I have two and four. And so sometimes I'll start to write and then one of them will crawl across the keyboard. And by one of them, I mean all of multiple times. But eventually, yeah, I'll be very happy to do that if folks would be interested. I'm always happy to do whatever I can to help folks, help empower folks with knowledge to do better because none of this is secret sauce really. It's just learn from experience and it's always better to learn from others' experience than your own. It's faster. So yeah, I would definitely [inaudible 00:49:35] is that, I think that's the best that I can say, but eventually my kids will get older. I hear this and maybe I can do so.

**中文翻译:**
谢谢。很有趣，我的人生待办事项之一就是把这些写下来。但我有三个孩子，一个才五个月大，另外两个分别是两岁和四岁。有时候我刚开始写，其中一个就会爬过键盘——我的意思是，他们会轮流爬过好几次。但最终，如果大家感兴趣，我很乐意去做。我总是乐于尽我所能帮助大家，用知识赋能，因为这其实不是什么秘密配方，只是经验总结。学习他人的经验总比自己摸索要快。所以，等我的孩子们长大一点，我应该就能写了。

---

### [00:49:42] Lenny

**English:**
Hopefully. Cool. So maybe if you're watching us on YouTube, leave a comment and if you want Laura to write in depth about this idea and spread it to your company. Okay, I want to talk about growth, but I have one last question just along the lines of experimentation. Is there any other just, I don't know, big lessons or takeaways of running experiments that would be interesting to share?

**中文翻译:**
希望如此。太酷了。如果你在 YouTube 上看我们的节目，请留言告诉我们你是否想让 Laura 深入写写这个想法。好了，我想聊聊增长，但在实验方面我还有最后一个问题：关于运行实验，还有什么重大的教训或心得值得分享吗？

---

### [00:50:02] Laura Schaffer

**English:**
I think we got into this one a little bit, but I just really want to exclamation point, underline it, which is that notion of making the data wrap to fit a concept. I think a lot of teams feel and are under a lot of pressure to show progress and, "What did you do this month? Where did the metrics move?" And it can cause folks to feel like they have to do that, where it's like, "Oh gosh, this experiment." Everyone's got the experience where you run an experiment and you're like looking at the data, refresh, refresh, refresh, oh my gosh, and actually perform worse. Or it's not the same and, "Gosh, we got everyone really excited about this thing that we all worked on really hard. Like, oh my god, what are we going to say in the QBR or the monthly report?" Whatever it is that the results come to light.
(00:50:55):
And to this, I'd say this, that it's incredibly important for growth teams to educate out and for folks outside of growth and leading growth, especially to understand that the best way for a growth team to succeed, the only way really for them to succeed is to embrace the fact that they're there to validate, to understand what the biggest opportunities are and to go after them.
(00:51:24):
And that is not something that can be done on a weekly timeline, sometimes even a monthly, depending on the space you're in and what's known and unknown. And so any growth team that's beholden to short timeline wins and improvement is always going to be dangerous. That's an environment that's conducive to vanity Metric usage and massaging the data [inaudible 00:51:47]. And ones that are more successful are ones that are reporting over longer periods of time. Because I think growth team, given enough time to fail, enough time to learn the right thing to do is absolutely going to show success, real success. Not that, "Okay, we're going to make this data fit." But real moving the metrics success.
(00:52:03):
And so definitely educating out. If you find yourself in a position where you are beholden to that, share that 80% fail rate. Just math, statistics, data. You cannot be successful in an environment, but over time you can be. And so that's one thing I definitely would draw on. I end up spending a decent amount of my pie chart at Twilio and then also at Rapid where I was after that and I'm sure I'll spend some time at Amplitude as well. Just helping folks understand what is the healthiest ecosystem, most powerful ecosystem for a growth team to operate in. And time and expectations over time is a big part of that.

**中文翻译:**
我们之前提到了一点，但我真的想加粗并划重点：那就是“让数据去迎合某个概念”的想法。很多团队面临巨大的压力要展示进展：“这个月你做了什么？指标提升了吗？”这会导致人们觉得必须这么做。每个人都有过这种经历：跑了一个实验，盯着数据不断刷新，结果发现表现更差，或者没变化。然后你会想：“天哪，我们让大家都对这个努力了很久的项目感到兴奋，现在 QBR（季度业务回顾）或月报里该怎么说？”

对此我想说：增长团队向外进行教育极其重要。增长团队之外的人，尤其是领导层，必须理解：增长团队成功的唯一方式是接受他们是去“验证”的，去发现最大的机会并追求它们。

这不可能在每周甚至每月的周期内完成，取决于你所在的领域以及已知和未知的程度。任何受限于短期获胜和提升的增长团队都是危险的。那种环境只会滋生虚荣指标（vanity metrics）和数据修饰。成功的团队通常是在更长的时间跨度内进行汇报。因为增长团队只要有足够的失败时间、足够的时间去学习正确的事，绝对会展示出真正的成功——不是那种“让数据看起来合适”的成功，而是真正推动指标的成功。

所以一定要向外教育。如果你发现自己处于那种被短期指标束缚的境地，分享那个 80% 的失败率。这就是数学、统计学和数据。在那种环境下你不可能成功，但拉长时间线你就可以。这是我一直坚持的一点。在 Twilio、Rapid 以及现在的 Amplitude，我都会花很大一部分精力去帮助大家理解：增长团队运作的最健康、最强大的生态系统是什么样的。而“时间”和“对长期结果的预期”是其中很大一部分。

---

### [00:52:46] Lenny

**English:**
When you say pie chart, it's like the pie chart of your time like a big chunk of your time goes to this?

**中文翻译:**
当你提到“饼图”时，是指你时间分配的饼图吗？也就是说你很大一部分时间都花在了这上面？

---

### [00:52:46] Laura Schaffer

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:52:50] Lenny

**English:**
That's awesome. I like that. I use white charts a lot as to describe that same idea. Just to be a little more concrete there, what is the timeframe you think is the minimum for a growth team to be thinking across?

**中文翻译:**
太棒了，我喜欢这个比喻。我也经常用饼图来描述这个概念。具体来说，你认为增长团队考虑问题的最小时间跨度应该是多久？

---

### [00:53:01] Laura Schaffer

**English:**
I think it's good, especially for newer teams, but even teams in general. Commit to something that you can do over the course of a year and low, medium, high is always helpful in that space. A lot times-

**中文翻译:**
我认为，特别是对于新团队，甚至是所有团队，承诺在一年内实现某些目标是比较好的。在这种情况下，“低、中、高”三档预期总是很有帮助的。很多时候——

---

### [00:53:01] Lenny

**English:**
What do you mean by that, by low, medium, high?

**中文翻译:**
你说的“低、中、高”是什么意思？

---

### [00:53:17] Laura Schaffer

**English:**
Low, medium high, more like, "Hey we've got a few bets that we have or few core hypotheses." And if they take off that's going to be our high bucket like, wow [inaudible 00:53:26]. We think these things could become lightening on a bottle here, but they could also be a bunch of [inaudible 00:53:31] missed. But until we run in, we're not going to know. And if those bear out though, then yeah, that's our high. And hey, we've got a few things that we think are safer. Maybe it was validated a bit in the previous year, what have you. And these looking really the metrics this amount.
(00:53:45):
So it's helpful to give people though that construct, it deviates from it very hard deviates from this notion of like, here's the single number that we're going to hit. Just things that help people understand that space a little bit better and what to expect. And because of that it can be a little bit lumpy. There were some things that you released. Truly for the most number of years, can be easiest to talk about in this construct here, but there's one thing that we did that generated tens of millions of dollars in the pipeline, was really, really powerful and took, sometimes navigate and validate. Other times we did that onboarding stuff that I was talking about catching those things. That could happen on a little bit of a faster clip but still took some time to validate and understand. But yeah, over the course of a year you should generally be able to commit to movement. But help people understand the methods there so that they're not coming at you on a weekly basis being like, "And what did you do these past couple days?"

**中文翻译:**
“低、中、高”更像是：“嘿，我们有几个赌注或核心假设。”如果它们成功了，那就是我们的“高”目标，就像瓶子里的闪电一样惊人。但它们也可能完全落空。在运行之前我们不会知道。如果它们奏效了，那就是“高”。同时，我们也有一些更稳妥的事情，可能去年已经验证过一部分了，这些能保证指标有一定程度的提升。

给人们这样一个框架很有帮助，它打破了“我们要达到一个单一数字”的观念。这能帮大家更好地理解增长空间以及预期。正因如此，增长可能是“不平稳”的。在 Twilio 的那些年里，我们做的一件事为管道（pipeline）创造了数千万美元的价值，那非常强大，但也花了很长时间去摸索和验证。其他时候，比如我提到的新手引导优化，节奏会快一点，但仍需时间验证。总之，在一年的跨度内，你通常可以承诺指标的变动。但要让大家理解其中的方法，这样他们就不会每周跑来问你：“过去这两天你做了什么？”

---

### [00:54:44] Lenny

**English:**
Okay, I got to follow up on a couple of these things. What was that big change of Twilio that lead to tens of millions of dollars?

**中文翻译:**
好的，我得追问一下。Twilio 那个带来数千万美元收益的重大变化是什么？

---

### [00:54:50] Laura Schaffer

**English:**
This is part of the course that I teach at Reforge.

**中文翻译:**
这是我在 Reforge 教授的课程的一部分。

---

### [00:54:55] Lenny

**English:**
Oh, amazing. You get to work for Reforge with [inaudible 00:54:57].

**中文翻译:**
噢，太棒了。你在 Reforge 工作。

---

### [00:55:04] Laura Schaffer

**English:**
I'm actually interested in retention, I think is my part. Right now, I'll give you links so we can [inaudible 00:55:05] in the show notes. But yeah, the high level version, this was deeper into my journey at Twilio. This is fast-forward a few years, build up this team and some cool things going on. But I was really looking for what's the next big thing for us to do? What could that be? And I noticed, remember that question very back of the day when I asked about the developer versus not developer folks [inaudible 00:55:34]?

**中文翻译:**
我负责的部分主要是关于留存（retention）。我会给你链接，我们可以放在节目介绍里。简单来说，这是我在 Twilio 旅程的后期。快进几年，团队已经建立，也有了一些成果。但我一直在寻找：我们的下一个大动作是什么？我注意到——还记得我很久以前问的那个关于“开发者 vs 非开发者”的问题吗？

---

### [00:55:33] Lenny

**English:**
Mm. Yeah.

**中文翻译:**
嗯，记得。

---

### [00:55:35] Laura Schaffer

**English:**
We saw that little non-developer little dude ad was growing. We were actually the number of people in the ecosystem who were identifying themselves as not a developer were in the space.
(00:55:46):
But very interestingly they were, as we got more refined in our understanding of those folks, a lot of them wanted to build with Twilio. There was a hypothesis of like, "Oh well maybe they're lost, maybe this want pricing, maybe they [inaudible 00:60:00] mistake." And I was like, "Nope, they're here to build, they won't build." And they struggled through the developer on onboarding and some of them would succeed and some would... But anyway, it was all about identifying what did they need to succeed. If we were made them successful, could it contribute to dollars? One of the core learnings I'd heard from sales at the time was, "Hey, it's very challenging for us to get the folks when a developer's not involved yet to go from zero to one to get something off the ground. But man, if we can get them to do that, if I can get them in $1 and spend, I can get them to five. If I get them to five, and get them to 50, like 10,000, then I can get them to hundred thousand."
(00:56:39):
This whole long journey like, "Hey, Laura, if your team could just get them off the ground, man, we can do so much." So yeah, the journey is all about, okay, what were the things that were missing in the experience we were offering and ultimately was they couldn't write code from scratch. That was really difficult. And also we're going to stand up a server. That was difficult. But we ended up iteratively experiencing a way to validate those hypotheses and what's the right way to do this and yeah, that was great. It's called quick deploy on code exchange. Anyone can go there and deploy an app without having to write code and get an aha moment there with Twilio.

**中文翻译:**
我们发现那个“非开发者”的小群体正在增长。在我们的生态系统中，自认为不是开发者的人数在增加。

非常有趣的是，随着我们对这些人的了解越来越深入，发现他们中很多人其实想用 Twilio 构建东西。之前的假设是：“哦，也许他们迷路了，或者只是想看价格，或者是点错了。”但我认为：“不，他们是来构建东西的，他们想动手。”他们在面向开发者的引导流程中挣扎，有些人成功了，有些没有。总之，关键在于找出他们成功需要什么。如果我们能让他们成功，这能转化为收入吗？

当时我从销售团队那里学到的核心经验是：“嘿，如果还没有开发者介入，让我们把这些人从 0 带到 1 是非常困难的。但天哪，如果我们能让他们开始，只要他们花 1 美元，我就能让他们花 5 美元；如果能花 5 美元，我就能让他们花 50 美元，甚至 1 万、10 万美元。”

这是一个漫长的旅程：“嘿 Laura，如果你的团队能帮他们起步，我们就能大展身手。”所以，这段旅程就是找出我们提供的体验中缺失了什么。最终发现，他们无法从零开始写代码，这太难了；搭建服务器也很难。我们通过迭代验证了这些假设，找到了正确的方法。那就是 Code Exchange 上的“快速部署”（Quick Deploy）。任何人都可以去那里，无需写代码就能部署一个应用，并在 Twilio 中获得“Aha Moment”（惊喜时刻）。

---

### [00:57:16] Lenny

**English:**
That is awesome. So basically it's like a low code Twilio app?

**中文翻译:**
太棒了。所以基本上就像是一个低代码（low-code）的 Twilio 应用？

---

### [00:57:20] Laura Schaffer

**English:**
Yeah, it ended up being, we had a lot of pet names, nicknames for it. I think probably the one that most succinctly describes it as just, it ended up being a create your own demo experience which made you talk about the psyche of people. We talked about how developers telecom until can be intimidating. We'll talk about the non-development, sometimes the buyers or the people who are instantly buying decisions, for them, it was not only was it telco, but it was the developer stuff was inaccessible but they still wanted to jump in and they wanted to have that experience. And so this was a way for us to give them momentum, give them comfortable. Geez, I can get this running my development team, I'd definitely do it. And so it was a very powerful moment where we could really address the psyche of those users, get them excited about Twilio, and then give sales the ability to give something powerful to those non-engineering buyers and folks they're talking to.

**中文翻译:**
是的，我们给它起了很多昵称。我想最简洁的描述是：它最终成了一个“创建你自己的演示”的体验。这又回到了用户心理的话题。我们说过电信对开发者来说很吓人；而对于非开发者（有时是买家或决策者）来说，不仅电信吓人，开发相关的东西也难以触及，但他们仍想参与并获得那种体验。所以这成了我们给他们动力、让他们感到舒适的方式。他们会想：“天哪，我能让这个跑起来，我的开发团队肯定也能行。”这是一个非常强大的时刻，我们真正解决了这些用户的心理问题，让他们对 Twilio 感到兴奋，并让销售团队有能力向那些非工程背景的买家展示强大的功能。

---

### [00:58:17] Lenny

**English:**
So genius, looking back seems like an obvious win. One of my readers suggested that I start a series of the story of a feature and walk through the discovery ideation development iteration and this feels like a really interesting example of that. But anyway. I got just a couple more questions. I know we've been going for an hour now. But I have questions, I don't want to let you go just yet, and they're on growth. So one question is just you worked at Twilio, which is very product led growth. You're now Amplitude, which is more sales driven and I know you're trying to go more product led. I know Elena talks a lot about this, how every company needs to have product led motions, otherwise they're going to be disrupted by someone that comes product led. And I don't know what hires, which blanket would they fall into?

**中文翻译:**
太天才了，回过头看这显然是一个巨大的胜利。我的一位读者建议我开一个“功能背后的故事”系列，讲述从发现、构思、开发到迭代的全过程，这感觉就是一个非常有趣的例子。不管怎样，我还有最后几个问题。我知道我们已经聊了一个小时了，但我还不想放你走，这些问题是关于增长的。你在 Twilio 工作过，那是典型的产品驱动增长（PLG）。你现在在 Amplitude，它更多是销售驱动（Sales-driven），而我知道你们正尝试转向产品驱动。我知道 Elena 经常谈论这个：每家公司都需要有产品驱动的机制，否则就会被那些产品驱动的竞争对手颠覆。

---

### [00:59:05] Laura Schaffer

**English:**
Between the AI like SLG and PLG. Yeah, for me they're two sides of the same coin. Product growth and sales. It's all to me, very thematically the same stuff. The difference is that with growth, you are selling with your product, and with sales you're selling with person like one-to-one. And so companies need to be employing both of those forces to optimally convert their audience. We're in a world where people are expecting both. They're expecting to be sold by your product and sold at the enterprise level. And large companies buy by human beings. It's going to listen to their specific needs and really break it off for them. And if you only have one, you're going to miss stuff. So absolutely, I think you want those two forces together working well. And obviously there's different stages, things work differently in different spaces, but I think when it comes to Amplitude, I think there's a huge opportunity here.
(01:00:06):
I think the key is, and that the challenge for companies that have done the sales thing and are trying to crack into the PLG thing really comes down to how you fundamentally are approaching that space. And again, your users and where they're at and the psyche of where they're at, I think a lot of companies will say, "Well okay, hey, we're going to do this PLG stuff. Let's take that sales enterprise whatever offering that we have and let's chop it up a bit and cut access here and cut out this feature here and we're going to slap this plan out and we're going to put a price on it and we'll maybe have hours of debates over whether it's like 10 99 or $104 or 75, and eventually someone will win that battle and slap it on and then [inaudible 01:00:54]." And anyway, the discussion of the focus is a lot around the product.
(01:00:58):
What are we going to do with this product? How are we going to crack it open and shift shift it in and then give it to these people, these users, these visitors? And what it's missing, I think is, and a lot of times it's easy to miss, is that when we're doing PLG and we're shifting from sales to PLG, we need to reset. We need to recognize that, again, this is sales, sales via the product. What does a good sales rep do when they're engaging? They understand what the problem is of the person in the space they're talking to. So we need the same thing here. What are the unique problems of people who are coming into our self-serve space? And I think when it comes to a company like Amplitude, a lot of the folks that will be looking to address via the PLG motion, there's a number of things we want to achieve there, but one of the primary things is to tap into the SMV market market and really give them a really startups and give them a space to land and to grow.
(01:01:57):
And again, you have to think what are the challenges and unique problems that they have because we're going to be using our product to settle them. We need to meet them where they're at with the problems that they've got. And I think one of the things that I've observed from being in all these startups and advising some startups is I very rarely... I don't think I've ever come across a startup where they have the right number of analysts for their needs. In fact, a lot of them don't have any. And so what that means is that the CEO is being an analyst to create their dashboards for the board and the product manager is being an analyst to figure out what the heck's going on and creating their boards for their product.
(01:02:34):
And that's happening all over the place is that people are in their roles and they have to be an analysts too. And I think that that's a problem that especially younger companies and early stage companies have. And so when they connect their psyche, what are they caring about? What are they thinking about when they're sending it for product analytic product or something? They'll looking for something that's going to help them feel reassured they're going to be able to actually get to the bottom of the right metrics, create the reports that show things the right way. What's the best way to show churn? There's got to be a best way so many people are doing it. Guess what? Yes, there are some really good ways to do it and there are some really successful ways to set up dashboards for the board. People have done that too.
(01:03:16):
There's a lot of that knowledge that exists in one of those frameworks that exist, benchmarking. Are these numbers even good? And so, one of the hypotheses that I have is that if we take that perspective and we understand that that is the problem, that there's a number of things that we can do to really change the way that self-serve experience works to help convert people and show them how Amplitude can make them that powerful. But the thing that I think sticks across all companies, not just amplitude making the shift, is just that, that when you're doing this, do not think this is a copy paste, but chop it for parts thing. Don't start with your product when you're building at your strategy, start with your customers, your users, your prospects, the people who are going to be coming into yourself or flow. Make sure you are understanding how their problems differ because they do from the people that you're addressing at the sales led side. And then make sure that you're orienting your experience of product around those people.

**中文翻译:**
关于 SLG（销售驱动增长）和 PLG。对我来说，它们是同一枚硬币的两面。产品增长和销售，在我看来主题是一样的。区别在于：增长是通过产品销售，而销售是通过人进行一对一销售。公司需要同时运用这两股力量来优化转化。我们处在一个用户期望两者兼得的世界：他们希望被产品打动，也希望在企业层面获得服务。大公司是由人来购买的，他们需要有人倾听特定需求并提供方案。如果你只有其中一种，你就会错失机会。所以，这两股力量必须协同工作。

对于那些已经习惯了销售模式并试图切入 PLG 的公司来说，关键在于你从根本上如何看待这个领域。很多公司会说：“好吧，我们要搞 PLG 了。把我们现有的企业级产品拿过来，砍掉一些功能，限制一下访问权限，定个价格（比如 99 美元或 104 美元），然后发布。”这种讨论的焦点全在产品上：我们怎么拆分产品？怎么把它塞给用户？

我认为这漏掉了一点：当我们从销售转向 PLG 时，我们需要“重置”。我们要意识到，这仍然是销售，只是通过产品销售。一个优秀的销售代表会做什么？他们会理解对方的问题。所以我们也需要这样做：进入我们自助服务空间的人，他们独特的痛点是什么？

以 Amplitude 为例，PLG 运动的目标之一是切入 SMB（中小企业）和初创公司市场，给他们一个落地和成长的空间。你必须思考他们面临的独特挑战。我观察到，几乎没有哪家初创公司拥有足够数量的数据分析师，事实上很多公司一个都没有。这意味着 CEO 必须充当分析师为董事会做仪表盘，PM 必须充当分析师去搞清楚发生了什么。

每个人都在自己的岗位上兼任分析师。这是初创公司普遍面临的问题。当他们注册一个产品分析工具时，他们在想什么？他们在寻找能让他们感到安心的东西，确保他们能找到正确的指标，创建正确的报告。比如，“展示流失率的最佳方式是什么？”肯定有最佳实践。是的，确实有，也有为董事会设置仪表盘的成功案例。

这些知识和框架（比如基准测试：这些数字算好吗？）是存在的。我的一个假设是：如果我们从这个角度出发，理解这就是问题所在，我们就能改变自助服务体验，向用户展示 Amplitude 如何让他们变得强大。所以，不仅是 Amplitude，所有做这种转型的公司都要记住：不要只是“复制粘贴再拆分”。制定策略时不要从产品开始，要从客户、用户、潜在客户开始。理解他们的痛点与销售侧面对的客户有何不同，然后围绕这些人来定位你的产品体验。

---

### [01:04:12] Lenny

**English:**
It's interesting that you almost have to start again as a product company, as a product because you may need to solve completely different problems that eventually lead to the same place. But it's interesting what you're saying that you may end up targeting analysts or PMs. I know Amplitude or has always focused on PMs, but-

**中文翻译:**
很有趣，作为一家产品公司，你几乎要重新开始，因为你可能需要解决完全不同的问题，尽管最终指向同一个目标。你提到最终可能会针对分析师或 PM，这很有意思。我知道 Amplitude 一直专注于 PM，但是——

---

### [01:04:32] Laura Schaffer

**English:**
Yeah, it's right. And there's always nice thing about it is it's in some ways, it does feel like you're starting fresh because you do need to start with the customer again and what's their problem. But in a lot of ways, you can carry over a lot of the same knowledge. At that point you know what's working well. Amplitude for example, does have a ton of knowledge around what some of the best ways artists set up reports. There's a lot of things that they have the momentum going, like where do you choose that momentum and how do you put that and curate that in front of users and make sure that they're getting the right things. There's a ton of momentum already there. It's just a little bit about harnessing it and understanding like, yeah, where are the gaps because there are going to be gaps.
(01:05:08):
But anchoring in a customer problem as I think the way that you start any new product, any new thing that you're releasing, should always think about the customer and the pain point. So no different than when you're doing PLG for the first time or cracking into it. You need to be thinking again, starting again with the problem, the problems they have, the psyche that they have coming to your space so that you can build something that is going to effectively make them feel like, "Oh you can solve my problem, you get me." And show them how your product's going to do that.

**中文翻译:**
没错。这种感觉确实像是在重新开始，因为你必须重新从客户和他们的问题出发。但在很多方面，你可以沿用已有的知识。Amplitude 拥有大量关于如何设置最佳报告的知识。已经有很多势能了，关键在于如何利用这些势能，如何将其呈现给用户，确保他们得到正确的东西。

就像启动任何新产品或发布任何新功能一样，你必须锚定在客户的问题上。做 PLG 也是如此。你需要重新思考：他们的问题是什么？他们来到你的领地时是什么心理？这样你才能构建出让他们觉得“哦，你能解决我的问题，你懂我”的东西，并展示你的产品是如何做到的。

---

### [01:05:42] Lenny

**English:**
Final question, and this is around developers. You worked at Twilio, obviously Twilio sold developers. I think Rapid where you work right before Amplitude also sold developers. Selling to developers feels like such a hot space right now. There's so many startups that are just building developer tools, such a huge market. Used to be not. Used to be like there's not a market in developers. They're not going to spend money, there's not enough of them. And now it is a big popular spot. And so I'm curious, what have you learned about building a startup and a product that sells to developers? I imagine a lot of founders building search tools would be really curious.

**中文翻译:**
最后一个问题是关于开发者的。你在 Twilio 工作过，Twilio 显然是卖给开发者的。你在加入 Amplitude 之前的 Rapid 也是卖给开发者的。现在“向开发者销售”感觉是一个非常热门的领域，有很多初创公司在做开发者工具，市场巨大。以前可不是这样，以前人们觉得开发者市场不存在，他们不愿花钱，人数也不够多。现在它成了热门。所以我很好奇，关于构建一个面向开发者销售的初创公司和产品，你学到了什么？我想很多正在构建搜索工具的创始人会非常感兴趣。

---

### [01:06:16] Laura Schaffer

**English:**
The first is that developers are just a very different audience from any others. I've seen so many people who have come in strong on growth really well or product really well with other audiences and like, "Oh, I'm going to take all those learnings, I'll pivot into serving developers." And as it being a very steep climb because developers are so different. And let me give you a couple just fun facts that make them really different. And some of these have some interesting stories. One is developers, almost two, one, do not look at your marketing website at all. They go straight to your signup flow. So what that means is all that beautiful context that you're setting and the product aid pricing, all that stuff, very often they're skipping all of it context free and going straight to your signup. And so anytime you make an assumption like, "Oh, well, they probably know this coming in to signup." Or like, "Well, we don't need to include, that's on the marketing website." None of that's going to apply to this group of people.
(01:07:15):
They're there. The analogy I have for this group is they're the IKEA buyers who when IKEA package comes, they're not opening up the instruction manual and reading in and then starting to go through, they're in there tearing open the bags and starting to pull the pieces together and trying to build it. They'll come up for context and steps and such when they get stuck if they're motivated. So that's one thing. And then another one is just the aversion to talking to sales. And I think hearing that, some they're like, "Oh yeah, well, I hate sales too." When I'm sent out and get bombarded by sales, that's the worst. I totally get that. But developers are on this whole other level. There was a fang company sign up for Twilio, built a POC, launched to production, all this, and operated in that space for months without engaging once with sales.
(01:08:12):
I was trying to reach them and I ended up being the one that talked to them first because they reached out to support because there was something about their delivery that was off ,there missing a feature and they did not want to talk to sales. They ended up talking to me when I was in product marketing. And that was my first exposure of like, these people not want to talk to sales. And then there's another one where a giant retail company where the engineering team signed up with their personal e-mail addresses so they wouldn't get bombarded by sales. It was only later that we found out. Anyway. But the thing that's most important, these are fun facts, but the thing that I would say is the most important, the thing to leave with listeners here is what makes them so different?
(01:08:54):
Why? What's the deal here? And it stems from their charter and their responsibility. So if we put ourselves in developer's shoes for a minute, a developer, if a developer is required to use your product, especially if they're the primary user, the primary builder, it's really important to recognize that they're responsible for that. If your service goes down, that's their responsibility. Not just for themselves but their team. If the pager wakes up someone because the service they bought from you goes down, that's on them. If, oh, it turns out that doesn't work with the systems that they said it was, well, that's on them. Doesn't integrate with the data the way that everyone wanted it to? That's on them. Everyone lives to developer when it's not working right and it cannot work right. In so many ways, that's their failure, it can cost them their job, it could cost them the trust to their team.
(01:09:50):
It cost them their reputation. And that means that the stakes are very high for them every time that they're adopting something new. So they can't afford to take someone's word for it. Especially a sales rep who might have some other motivations from their perspective, they can't afford to trust your content or someone's word. They must do it. They must prove it themselves. And so that means they're going to be pretty darn deep in their self-serve experience with you before they're ready to commit. And so if you are a company that is providing, that requires developers to build, you must invest in self-serve experiences in order to effectively convert your audience. And you should be thinking of them. Something akin your self-serve function and growth folks, someone akin to Salesforce because your developers are not going to accept sales coming in and trying to convert them at that stage.

**中文翻译:**
首先，开发者是一个与任何其他群体都完全不同的受众。我见过很多在其他领域做增长或产品非常成功的人，想把那些经验直接搬到开发者身上，结果发现困难重重。

让我分享几个关于开发者的有趣事实。第一，开发者几乎从不看你的营销网站，他们直接进入注册流程。这意味着你精心准备的所有背景信息、产品介绍、定价说明，他们往往全都跳过，直接去注册。所以，如果你假设“他们注册时肯定已经知道这些了”，那你就错了。

我给这个群体打了一个比方：他们就像是买宜家家具的人，包裹一到，他们不看说明书，而是直接撕开包装袋开始组装。只有当他们卡住了，且动力足够强时，才会去找说明书。

第二，他们极度反感与销售交谈。你可能会说：“我也讨厌销售。”但开发者是另一个层级的。曾经有一家大厂（FAANG）的公司注册了 Twilio，做了 POC（概念验证），上线了生产环境，运行了几个月，一次都没和销售沟通过。销售一直想联系他们，最后是我（当时在产品营销部门）第一个和他们说上话的，因为他们联系了客服，说有个功能缺失。他们宁愿找客服也不找销售。还有一家大型零售公司，工程团队用个人邮箱注册，就是为了躲避销售。

最重要的一点是：为什么他们如此不同？这源于他们的职责。如果你站在开发者的角度想一想：如果公司要求开发者使用你的产品，他们就是主要的构建者，他们要为此负责。如果你的服务挂了，那是他们的责任。如果半夜报警器响了，那是他们的锅。如果集成出了问题，那是他们的错。当事情不顺时，所有人都会看向开发者。这关系到他们的工作、团队的信任和声誉。

这意味着他们每次采用新东西时，赌注都非常高。他们不敢听信别人的话，尤其是销售。他们必须亲自动手证明它有效。这意味着在他们准备下单之前，他们已经在你的自助服务体验中走得很深了。所以，如果你是做开发者工具的，你必须投资自助服务体验，才能有效地转化受众。你应该把自助服务功能和增长团队看作是你的“Salesforce”，因为开发者在那个阶段是不会接受销售介入的。

---

### [01:11:00] Lenny

**English:**
I love that you always come back to the psyche of the user and how in this case, developers like, here's why they're responsible for this thing. Salespeople are going to convince them this is going to work. And it's not. That's a really interesting tool and that's a really cool takeaway.
(01:11:16):
Is there anything else that we didn't cover before we get to our very exciting lightning round?

**中文翻译:**
我喜欢你总是回到“用户心理”这一点，比如开发者为什么觉得自己要负责。销售人员会试图说服他们这行得通，但他们不信。这是一个非常有趣的视角，也是一个很酷的心得。在进入令人兴奋的闪电轮（lightning round）之前，还有什么我们没聊到的吗？

---

### [01:11:20] Laura Schaffer

**English:**
Plenty. I think we covered it all, man.

**中文翻译:**
很多，但我认为我们已经涵盖了重点。

---

### [01:11:22] Lenny

**English:**
You got all my questions and more. So with that, welcome to the very exciting lightning round. I've got six questions for you. Are you ready?

**中文翻译:**
你回答了我所有的问题，甚至更多。那么，欢迎来到闪电轮。我有六个问题，准备好了吗？

---

### [01:11:30] Laura Schaffer

**English:**
I am so ready.

**中文翻译:**
准备好了。

---

### [01:11:31] Lenny

**English:**
What are two or three books that you recommend most to other people?

**中文翻译:**
你最推荐给别人的两三本书是什么？

---

### [01:11:35] Laura Schaffer

**English:**
I'm a big believer in happiness. Not just being crunchy or we should all be happy, but also because it helps us do our best work and we're more creative and all this. So one is Simple Path to Wealth by JL Collins. I don't ignore the data, that money is something that often gets in the way of our happiness. I know so many smart people that just have not figured out the whole managing their finances thing. And this book will cover all of your basics. It's very easy to read. He's got an audiobook that he narrates himself. Simple Path to Wealth by JL Collins, he's fantastic.

**中文翻译:**
我非常看重幸福感。不仅是因为我们应该快乐，还因为快乐能让我们工作得更好、更有创意。第一本是 JL Collins 的《简单致富之路》（Simple Path to Wealth）。数据表明，金钱往往是幸福的障碍。我认识很多聪明人，但他们还没搞清楚理财这件事。这本书涵盖了所有基础知识，非常易读，作者自己朗读的音频书也很棒。

---

### [01:12:12] Lenny

**English:**
What's a recent movie... Oh wait, wait, there's more?

**中文翻译:**
最近看的电影……噢等等，还有吗？

---

### [01:12:18] Laura Schaffer

**English:**
Oh, let's do it. Let's do it.

**中文翻译:**
有的，继续。

---

### [01:12:18] Laura Schaffer

**English:**
[inaudible 01:12:18] Happiness, which is Atomic Habits by James Clear. If you ever want to change something about yourself or something's not quite working for you, this guy will give you a framework to change it. Guaranteed.

**中文翻译:**
关于幸福的另一本是 James Clear 的《原子习惯》（Atomic Habits）。如果你想改变自己，或者觉得某些事情不太对劲，这本书会给你一个改变的框架。我保证有效。

---

### [01:12:30] Lenny

**English:**
I really enjoyed that book. That guy's killing it. He was on Tim Ferris, he had a great interview. Folks that don't want to read it, they could listen to that. There's a lot of cool tips there. Favorite recent movie or TV show?

**中文翻译:**
我也很喜欢那本书，作者太厉害了。他在 Tim Ferriss 的访谈也非常精彩。不想看书的人可以去听听那个访谈。最近最喜欢的电影或电视节目？

---

### [01:12:39] Laura Schaffer

**English:**
Unabashedly, the Great British Baking Show. I love that show. I love that show for all the reasons everyone loves that show. It's heartwarming and makes you feel good and uplifts you. But also because it is a competitive show. They're trying to be the best baker and they're out there helping each other. They're like a big family. Most reality competitive TV shows that I see, all of them are like cutthroat, they're sabotaging. So I'm just endlessly fascinated also by the psychology of what's happening here. I want somebody to do a research paper on it, get to the bottom of why they're all helping each other. It's wonderful though. Wonderful to watch.

**中文翻译:**
毫不掩饰地说，是《全英烘焙大赛》（The Great British Baking Show）。我爱死那个节目了，原因和大家一样：它很温馨，让人心情愉悦。而且虽然是竞技节目，大家在争夺最佳烘焙师，但他们却在互相帮助，像个大家庭。大多数竞技真人秀都是残酷竞争、互相拆台。我对比其中的心理学现象非常着迷。我真希望有人能写篇论文，研究一下为什么他们都在互相帮助。总之，非常好看。

---

### [01:13:18] Lenny

**English:**
Interesting. I always comes back to psychology with you.

**中文翻译:**
有趣，你总是能绕回到心理学。

---

### [01:13:24] Laura Schaffer

**English:**
I know. I know. I feel like I'm really, really sinking deep in there. And it's true though. It's very interesting to me, and I love that show.

**中文翻译:**
我知道，我陷得太深了。但确实如此，这对我来说很有趣。

---

### [01:13:30] Lenny

**English:**
What's a favorite interview question that you like to ask in interviews?

**中文翻译:**
你最喜欢在面试中问什么问题？

---

### [01:13:34] Laura Schaffer

**English:**
I love asking about a ship or release that is not cherry-picked by the person you're talking to. You can get it a lot of different ways. The thing is, everyone has a big success story. Everyone does. It really doesn't actually tell you very much to ask someone like, "What's a great thing you released?" Because everyone could tell that. Instead, take that away. What's the most recent ship is a really easy one because recency, time. But there's other things you can do to take that out. Just give them specific parameters for a ship that they've shared or whatever, and that will allow you to listen more and learn more about their frameworks versus the outcomes. Because if you're picking a random ship, odds are it probably wasn't fantastic. So they're going to want to talk more about how they approach getting there and that's what you want to know about to know if they're going to succeed, what their frameworks to how they approach things.

**中文翻译:**
我喜欢问一个“非面试者精心挑选”的发布案例。有很多问法。问题在于，每个人都有成功的案例。问“你发布过最棒的东西是什么？”其实得不到太多信息。相反，你应该去掉这个选项。问“你最近发布的一个东西是什么？”是一个简单的方法，因为有时间限制。或者给他们一些特定参数。这能让你更多地了解他们的思维框架，而不是结果。因为如果你随机挑一个发布案例，很可能它并不完美。这样他们就不得不更多地谈论他们是如何处理过程的，而这正是你想知道的：他们的思维框架是什么，他们如何解决问题。

---

### [01:14:24] Lenny

**English:**
That is cool. I've never heard that one. That is a really clever idea. What are five SaaS products that you use in your day-to-day work? Can't say Amplitude.

**中文翻译:**
很酷，我还没听过这种问法，非常聪明。你在日常工作中使用的五款 SaaS 产品是什么？不能说 Amplitude。

---

### [01:14:33] Laura Schaffer

**English:**
I know, right? Still learning which ones we have here. But yeah, I'll just share the ones that I like a lot that I've used elsewhere. So one is Hotjar. Hot Jar [inaudible 01:14:44] also works. Just anything that allows you to put some quick little thing in front of customers, get that qualitative feedback we talked about. It's a critical, critical supplement to quantitative data to understand what's really causing the change or not causing the change [inaudible 01:14:58]. So that's important. I will say Amplitude is a fantastic tool that I have used and I would've said that if I hadn't just joined Amplitude so I got to use it... I know. I got to use it for the first time at Amplitude and it was awesome. So again, like asterisk, because I'm like working there now, but I do actually like it. And Slack, it's boring, everyone says Slack, but I just have to hand it to them.
(01:15:26):
It makes life so much easier and just nod their way. And then Builder, which I'll also put in asterisk on that one, but I really want to serve this. A lot of people don't know about it and it's really helpful. I do advise them so I'm in their corner. But this is another one I also say would be a powerful one. I think a lot of team gets stuck. They're relying on too much in their engineers to make changes. Again, we talk about rapid experimentation, getting these out, out, out. And Builder makes it really easy for folks to do that. Also, a headless CMS, you can drag and drop headless CMS so they do make it easy for non-engineers to make changes. So especially if you're trying to figure out how to get around that 80% [inaudible 01:16:11] that I mentioned, this builder would be a good way.
(01:16:14):
And then yeah, if you want one more, I'll give you Chat GPT, which is really boring and everyone's saying that, but I think I'll just say I don't have any crazy things to say about it except that I do think we all need to figure out how we pull that in to [inaudible 01:16:28] put people who don't do that are probably going to lose out or smart AI whatever bots. But that would be it for you, Lenny. But if you ask me in a few months after I've actually been an Amplitude for a bit, I'm sure I'd give you a different answer.

**中文翻译:**
我知道。我还在熟悉这里的工具。我会分享一些我在其他地方用过且非常喜欢的。第一是 Hotjar（或者类似的工具），任何能让你快速获取客户定性反馈的工具。它是定量数据的重要补充。第二，我必须说 Amplitude 确实是个很棒的工具，即使我没加入公司我也会这么说。第三是 Slack，虽然很无聊，大家都说它，但它确实让生活变得更容易。第四是 Builder.io（声明：我是他们的顾问），很多人不知道它，但它非常有用。很多团队卡在过度依赖工程师来做更改上，而 Builder 让非工程师也能通过拖拽来修改内容，这对于快速实验非常重要。第五是 ChatGPT，虽然也很无聊，但我们确实需要思考如何利用它。

---

### [01:16:42] Lenny

**English:**
That's a good time to plug lennybot.com. And I wrote a newsletter or Dan Shipper who created the bot wrote a newsletter post about how he built this thing. And so you could go ask me questions using the content of my newsletter as answers. And it's very cool. Lennybot.com or lennysbot.com.

**中文翻译:**
现在是宣传 lennybot.com 的好时机。我写了一篇通讯，或者说制作这个机器人的 Dan Shipper 写了一篇关于他如何构建这个东西的文章。你可以向它提问，它会用我通讯里的内容作为答案。非常酷。

---

### [01:17:00] Laura Schaffer

**English:**
Amazing.

**中文翻译:**
太棒了。

---

### [01:17:01] Lenny

**English:**
There we go.

**中文翻译:**
就是这样。

---

### [01:17:03] Laura Schaffer

**English:**
I didn't know about that. Well, there you go. I've changed my answer. It's that.

**中文翻译:**
我之前不知道这个。好了，我改答案了，就是它。

---

### [01:17:05] Lenny

**English:**
Yeah, there we go. That's all I need.
(01:17:09):
Two more questions. What is something relatively minor you've changed in your product development process that has had a lot of impact on your team's ability to execute?

**中文翻译:**
哈哈，这就够了。还有两个问题。在产品开发流程中，你做过什么微小的改变，却对团队的执行能力产生了巨大影响？

---

### [01:17:17] Laura Schaffer

**English:**
Yeah, the be embarrassed thing, like I mentioned earlier, be Embarrassed by the first iteration. If you are not embarrassed, you've gone too far. That really speeds up ships and helps people celebrate the unpolished as opposed to feel embarrassed about it. So just embracing that.

**中文翻译:**
就是我之前提到的“感到尴尬”。对第一次迭代感到尴尬。如果你不觉得尴尬，说明你做得太过了。这真的能加快发布速度，让大家学会庆祝那些“不完美”的东西，而不是为此感到羞愧。

---

### [01:17:35] Lenny

**English:**
Awesome. And final question. I know you just started Amplitude, but do you have a favorite pro-tip for how to use Amplitude or maybe Hidden Feature people may not know about?

**中文翻译:**
太棒了。最后一个问题。我知道你刚加入 Amplitude，但你有没有什么关于如何使用 Amplitude 的独家秘籍，或者大家可能不知道的隐藏功能？

---

### [01:17:44] Laura Schaffer

**English:**
You tell me [inaudible 01:17:45], but I'll say one thing that was super cool actually that someone put together on my team at Rapid, literally before I left, he put together a video of how powerful Amplitude could be when linked up and integrated with other things like in this case Hotjar and Segment. There was a Amplitude report that someone had created and there was something that was an anomaly happening there. Users were using something in a way we didn't expect and Amplitude one of the reports surface it, but Al Kirsten, we want to know why is that happening. And so we could find out what the event is and then using by Segment, find out what that name was and look at Hotjar and actually go in and get screencasts of people doing that exact event.
(01:18:30):
And from that, we were able to form some really concrete hypotheses about what actually was causing it. And so obviously talking to customers is very powerful, but in this case, just that simple use of connecting and threading those technologies together could really get a good picture of that without needing to engage customers. So the tip would be how you can really amplify when you get an amplitude when you use it with.

**中文翻译:**
我来说一个我在 Rapid 时团队成员展示的超酷用法。他做了一个视频，展示了当 Amplitude 与 Hotjar 和 Segment 等工具集成时有多强大。当时 Amplitude 报告显示了一个异常：用户以一种我们未预料到的方式使用某个功能。我们想知道为什么。于是我们通过 Segment 找到对应的事件和用户，然后在 Hotjar 中查看该用户执行该特定事件时的屏幕录像。

通过这种方式，我们能够形成非常具体的假设，了解到底是什么原因导致的。虽然与客户交谈很强大，但这种将不同技术串联起来的方法，让你无需打扰客户就能获得清晰的洞察。所以秘籍就是：通过与其他工具集成来放大 Amplitude 的威力。

---

### [01:18:59] Lenny

**English:**
Laura, we covered a lot of ground, career experimentation, growth, embarrassment, psychology. Thank you so much for being here. Two final questions, where can folks finding online if they want to reach out, learn more, maybe send you an appreciation or two? And two, how can listeners be useful to you?

**中文翻译:**
Laura，我们聊了很多：职业、实验、增长、尴尬、心理学。非常感谢你的到来。最后两个问题：如果大家想联系你、了解更多，或者表达感谢，可以在哪里找到你？另外，听众可以为你做些什么？

---

### [01:19:17] Laura Schaffer

**English:**
Yeah, find me on LinkedIn. I don't post a lot. Yeah, I'll blame my three children. Eventually, I promise that I will. But I'm pretty good about responding to messages, so definitely link with me there.
(01:19:29):
And then what listeners can do, I think I'm always happy to hear feedback, suggestion, all that, but I'll just say I also know that it's a little bit crazy out there right now, especially folks working in tech. So I'm also cognizant what I might be able to do to help all of you. I know there's a few places I advise and rapids hiring. I know of a few folks that are hiring growth, strong growth people and product folks. So if you are interested in learning more about that, don't hesitate to hit me up. I want to make sure that I help as many people as I can in that respect because it's trying times and I'm sure you've heard it and read it, but if you're laid off, this is not about you, it's not your fault. It's this crazy world we're in. Things will get better. And I would be feel very lucky if I could help even one person land. So feel free to hit me up about that too.

**中文翻译:**
可以在 LinkedIn 上找我。我不常发帖，这得怪我的三个孩子，但我保证以后会多发的。不过我回复消息挺快的，所以可以在那里联系我。

至于听众能做什么，我总是乐于听到反馈和建议。但我也知道现在科技行业的情况有点疯狂，所以我也在想我能帮大家做点什么。我担任顾问的一些公司和 Rapid 正在招聘。我知道有一些地方在招优秀的增长和产品人才。如果你感兴趣，尽管联系我。我想尽我所能提供帮助，因为现在是艰难时期。如果你被裁员了，请记住这不是你的错，是这个疯狂的世界。情况会好转的。如果我能帮到哪怕一个人找到工作，我都会觉得很幸运。所以，关于这方面也欢迎联系我。

---

### [01:20:21] Lenny

**English:**
Awesome. And maybe if you share some links, we could include links to open roles in the show notes.

**中文翻译:**
太棒了。如果你分享一些链接，我们可以把招聘职位的链接放在节目介绍里。

---

### [01:20:26] Laura Schaffer

**English:**
Yes. I know there's a few that don't have JDs open yet. They're that hot off the press, but I'm happy to surface a few things there for sure because I know that makes it easier for people to know.

**中文翻译:**
好的。有些职位甚至还没发布 JD，但我很乐意分享一些信息，让大家更容易了解到。

---

### [01:20:37] Lenny

**English:**
Awesome. We will do our best with the show notes then. Laura, thank you again for being here.

**中文翻译:**
太好了。我们会尽力做好节目介绍。Laura，再次感谢你的到来。

---

### [01:20:43] Laura Schaffer

**English:**
Yeah, thanks so much for having me. This was awesome and so much fun.

**中文翻译:**
谢谢你的邀请。这次对话非常棒，很有趣。

---

### [01:20:47] Lenny

**English:**
Bye everyone.
(01:20:49):
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcast, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
大家再见。非常感谢您的收听。如果您觉得本期节目有价值，可以在 Apple Podcast、Spotify 或您喜欢的播客应用中订阅。此外，请考虑给我们评分或留下评论，这能帮助更多听众找到我们。您可以在 lennyspodcast.com 找到往期所有节目或了解更多信息。下期节目再见。