# Lauren Ipsen - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Lauren Ipsen.

---

### [00:00:00] Lauren Ipsen

**English:**
Regardless of whether or not you're hiring, you should always be keeping a pulse on the market. That is the most important thing. And I think that should be the case for both candidates and folks that are hiring. Like, you never want to put yourself in a position where you have no idea what good looks like, whether that's from a company standpoint or from a candidate standpoint. So, both parties should always be having a good understanding of which companies are thriving, which individuals are building great things and are well known commodities in their organizations and get great references.

**中文翻译:**
无论你现在是否正在招聘，你都应该始终保持对市场的敏锐洞察（keeping a pulse on the market）。这是最重要的事情。我认为无论是候选人还是招聘方都应如此。你绝不想让自己处于一种完全不知道“优秀”长什么样（what good looks like）的境地，无论从公司角度还是候选人角度来看都是如此。因此，双方都应该清楚哪些公司正在蓬勃发展，哪些人正在创造伟大的产品，并且在他们的组织中是众所周知的“抢手货”（well known commodities），且拥有极佳的口碑。

---

### [00:00:35] Lauren Ipsen

**English:**
Oftentimes, I encourage founders to simply chat with what good looks like and get a really good sense of what benchmark candidate profiles could be, and who knows where that person will be in a year or what have you, but staying really, really close to really great people and using them from an advising capacity or getting them ingrained in some type of involvement in the product prior to actually having that specific need, I think, is really important.

**中文翻译:**
我经常鼓励创始人去和那些代表“优秀”的人聊聊，从而对“基准候选人画像”（benchmark candidate profiles）有一个清晰的认识。谁知道那个人一年后会在哪里呢？但在实际产生特定招聘需求之前，与优秀的人保持紧密联系，以顾问身份（advising capacity）邀请他们，或者让他们以某种形式参与到产品中，我认为这非常重要。

---

### [00:01:05] Lenny

**English:**
Welcome to Lenny's Podcast. I'm Lenny and my goal here is to help you get better at the craft of building and growing products. Today my guest is Lauren Ipsen.

**中文翻译:**
欢迎来到 Lenny 的播客。我是 Lenny，我的目标是帮助你提升构建和增长产品的技能（craft）。今天的嘉宾是 Lauren Ipsen。

---

### [00:01:15] Lenny

**English:**
One of the most important skills for founders and senior product leaders to develop is the ability to hire great people. You won't be able to build the best company or the best product if you can't hire the best people. And Lauren is one of the most experienced and successful people in the world when it comes to hiring product leaders. She's placed over 80 senior product leaders across tech companies and has worked with some of the biggest companies out there. When I asked a bunch of really smart product leaders who their favorite product recruiter was, Lauren's name came up a ton.

**中文翻译:**
创始人及资深产品领导者需要培养的最重要技能之一，就是招聘优秀人才的能力。如果你招不到最优秀的人，你就无法建立最好的公司或打造最好的产品。在招聘产品领导者方面，Lauren 是全球最有经验且最成功的人士之一。她已为各大科技公司安置了 80 多名资深产品领导者，并与一些顶尖大公司有过合作。当我询问一群聪明的产品领导者谁是他们最喜欢的产品猎头时，Lauren 的名字被提及了无数次。

---

### [00:01:46] Lenny

**English:**
In our conversation, we get super tactical about what founders need to do to find the best product talent, what product managers should be doing during their career to give themselves the most opportunity, and we also touch on what recruiters themselves often get wrong when trying to attract great talent. This episode is rich with actionable advice for basically everyone, and I am really excited to bring it to you. With that, I bring you Lauren Ipsen.

**中文翻译:**
在我们的对话中，我们将深入探讨非常实操（super tactical）的建议：创始人该如何寻找顶尖产品人才，产品经理在职业生涯中应该做些什么来为自己创造更多机会，我们还会触及招聘人员在吸引优秀人才时经常犯的错误。本集内容充满了对每个人都有用的实操建议，我非常激动能把它呈现给大家。下面，让我们欢迎 Lauren Ipsen。

---

### [00:02:12] Lenny

**English:**
Who has an opinion on internal tools? Internal tools are something you probably don't think about until you have to, or it probably didn't even occur to you to think about them, but if you work at a big company, you probably have a bunch of one-off custom apps or dashboards that are laser focused on just one job to be done for one specific team or just one role, and they're always such a huge pain to build and maintain. And that's why I'm such a big fan of Retool, and why I think Retool is so popular. Retool allows teams as small as just one person to build a suite of custom internal apps in a fraction of the time that you think it takes. The productivity gains of custom apps is now within reach, not just for large enterprises, but for small teams as well. And as you scale your company, Retool scales with you.

**中文翻译:**
谁对内部工具有看法？内部工具通常是你直到不得不面对时才会去考虑的东西，或者你甚至根本没想过它们。但如果你在大公司工作，你可能会有一堆一次性的定制应用或仪表盘，它们只专注于某个特定团队或角色的某项“待办任务”（job to be done），而这些工具的构建和维护总是让人头疼。这就是为什么我是 Retool 的忠实粉丝，也是 Retool 如此受欢迎的原因。Retool 允许哪怕只有一人的小团队，也能以极短的时间构建一套定制的内部应用。定制应用带来的生产力提升现在触手可及，不仅适用于大型企业，也适用于小团队。随着你公司规模的扩大，Retool 也会随之扩展。

---

### [00:02:57] Lenny

**English:**
Snowflake saves about 26 hours a week of manual spreadsheet work with custom internal apps built on Retool. Amazon uses Retool to handle GDPR requests. Thousands of teams at companies like Coinbase, DoorDash, and NBC collaborate around custom-built Retool apps to operate with greater efficiency.

**中文翻译:**
Snowflake 通过在 Retool 上构建的定制内部应用，每周节省了约 26 小时的手动电子表格工作。亚马逊使用 Retool 处理 GDPR（欧盟通用数据保护条例）请求。Coinbase、DoorDash 和 NBC 等公司的数千个团队都在使用定制的 Retool 应用进行协作，以实现更高的运营效率。

---

### [00:03:17] Lenny

**English:**
Maybe you've thought about using Retool before but just haven't, and I'm here to tell you that now teams of up to five can build unlimited Retool apps for free. Get started today at retool.com/lenny.

**中文翻译:**
也许你以前考虑过使用 Retool 但还没行动，我现在告诉你，现在最多 5 人的团队可以免费构建无限量的 Retool 应用。今天就访问 retool.com/lenny 开始吧。

---

### [00:03:31] Lenny

**English:**
Today's episode is brought to you by Miro. Creating a product, especially one that your users can't live without, is damn hard, but it's made easier by working closely with your colleagues to capture ideas, get feedback, and being able to iterate quickly. That's where Miro comes in. Miro is an online visual whiteboard that's designed specifically for teams like yours.

**中文翻译:**
今天的节目由 Miro 赞助。创造一个产品，尤其是让用户离不开的产品，是非常困难的。但通过与同事紧密合作来捕捉想法、获取反馈并快速迭代，会让这件事变得容易些。这就是 Miro 的用武之地。Miro 是一个在线视觉白板，专为像你们这样的团队设计。

---

### [00:03:53] Lenny

**English:**
I actually used Miro to come up with a plan for this very ad. With Miro, you can build out your product strategy by brainstorming sticky notes, comments, live reactions, voting tools, even a timer to keep your team on track. You can also bring your whole distributed team together around wire frames where anyone can draw their own ideas with the pen tool or put their own images or mock-ups right into the Miro board. And with one of Miro's ready made templates, you can go from discovering research to product roadmaps to customer journey flows to final mocks.

**中文翻译:**
实际上，我就是用 Miro 来策划这条广告的。通过 Miro，你可以利用便签（sticky notes）、评论、实时反应、投票工具，甚至计时器来头脑风暴并构建产品战略，确保团队进度不掉队。你还可以让整个分布式团队围绕线框图（wire frames）协作，任何人都可以用画笔工具画出自己的想法，或者直接将图片或模型图（mock-ups）放入 Miro 画板。借助 Miro 的现成模板，你可以完成从调研发现到产品路线图，再到客户旅程流（customer journey flows）和最终高保真模型图的全过程。

---

### [00:04:24] Lenny

**English:**
Want to see how I use Miro? Head on over to my Miro board at miro.com/lenny to see my most popular podcast episodes, my favorite Miro templates. You can also leave feedback on this podcast episode and more. That's M-I-R-O.com/lenny.

**中文翻译:**
想看看我是如何使用 Miro 的吗？请访问我的 Miro 画板 miro.com/lenny，查看我最受欢迎的播客集锦和我最喜欢的 Miro 模板。你还可以在上面对本集播客留下反馈。网址是 M-I-R-O.com/lenny。

---

### [00:04:45] Lenny

**English:**
Lauren, thank you for being here. Welcome to the podcast.

**中文翻译:**
Lauren，感谢你的到来。欢迎来到本播客。

---

### [00:04:47] Lauren Ipsen

**English:**
Thanks so much. It's great to be here.

**中文翻译:**
非常感谢。很高兴能来到这里。

---

### [00:04:50] Lenny

**English:**
I've been meeting to do an episode on product hiring and recruiting product people for a while, and when I asked a bunch of smart friends who should I have on to talk about this stuff, your name came up a bunch, and so I'm really happy that we're finally doing this.

**中文翻译:**
我一直想做一期关于产品招聘和招揽产品人才的节目。当我问一群聪明的朋友该请谁来聊聊这些话题时，你的名字被反复提及。所以我很高兴我们终于成行了。

---

### [00:05:03] Lauren Ipsen

**English:**
Me too. Absolutely. I'm grateful that you asked.

**中文翻译:**
我也是。当然，我很感激你的邀请。

---

### [00:05:07] Lenny

**English:**
So, to help listeners get a sense of just your background and kind of the journey you've been on to get to where you are now, can you just spend maybe just a minute kind of talking through the wonderful things you've done in your career and what you're doing now?

**中文翻译:**
为了让听众了解你的背景以及你走到今天的历程，你能花一分钟左右的时间，简单介绍一下你职业生涯中做过的精彩事情以及你现在的工作吗？

---

### [00:05:19] Lauren Ipsen

**English:**
Yeah, absolutely. So I started my career in broadcast. I originally thought that I wanted to be on the news and quickly realized I didn't necessarily want to be the face of sadness. There's a ton of that happening in the world.

**中文翻译:**
好的。我的职业生涯始于广播电视行业。最初我想做新闻主播，但很快意识到我并不想成为“悲伤的代言人”。毕竟这个世界上发生了太多令人难过的事情。

---

### [00:05:36] Lauren Ipsen

**English:**
So, made a pivot pretty early on and thought, where could I use the communication skills that I've been working so hard on and do something that's impactful in a big way, but maybe just with a little bit of a different angle? And stumbled across executive search.

**中文翻译:**
所以我在很早期就转型了，我在想：哪里能用到我苦练的沟通技巧，去做一些有重大影响力、但切入点略有不同的事情呢？于是我偶然接触到了高管搜寻（executive search，即高管猎头）。

---

### [00:05:52] Lauren Ipsen

**English:**
Exec search is not really something that people major in college by any means or think they're going to end up doing. So it was something I found fascinating. I had applied to all of these different companies like Twitter and Snap and Pinterest, hadn't heard back from any of them, was a name in the resumes, and thought, well, how cool would it be if I could work with all of them and have an opportunity to play a part from a different lens?

**中文翻译:**
高管搜寻绝对不是人们在大学里会修的专业，也不是大家预想中会从事的职业。但我发现它非常迷人。我曾向 Twitter、Snap 和 Pinterest 等各种公司投过简历，但石沉大海，只是简历堆里的一个名字。于是我想，如果我能与所有这些公司合作，并有机会从另一个视角参与其中，那该多酷啊？

---

### [00:06:18] Lauren Ipsen

**English:**
So, got into exec search, was really focused early on on consumer mobile build outs. Was doing a lot of work with Twitter and Reddit and TaskRabbit and Nextdoor, Postmates, you name it, and that was probably 85% of the work I was doing. And then as, on the agency side, 15% was obscure, autonomous helicopters selling into the Department of Defense and then retail and robotics, and it was all very fascinating, but for me, who has wicked bad ADD, it was amazing to be able to be so stimulated by so many different industries and feel like I couldn't really master this.

**中文翻译:**
于是我进入了高管搜寻领域，早期专注于消费级移动端团队的组建。我曾与 Twitter、Reddit、TaskRabbit、Nextdoor、Postmates 等公司合作，这大概占了我工作的 85%。在猎头公司（agency side）期间，剩下的 15% 是一些冷门领域，比如向国防部销售无人直升机，还有零售和机器人技术。这一切都非常迷人，对于我这个患有严重注意力缺失症（ADD）的人来说，能受到这么多不同行业的启发，并感到自己永远无法完全“精通”所有领域，这种感觉太棒了。

---

### [00:06:57] Lauren Ipsen

**English:**
So, long story short, had an awesome career at Daversa Partners, which is a boutique executive search firm, and thought I was going to be there potentially forever. Was tapped by a awesome individual, Abe Shafi, who was founding a company. I had been doing a lot of work for them. They were a client of mine at the time. Placed a couple great hires and they said, "We're either going to kick off a head of talent search with you or you can come over and join us." So I was the first recruiting hire over there, built out the talent function in its entirety.

**中文翻译:**
长话短说，我在 Daversa Partners（一家精品高管猎头公司）度过了一段精彩的职业生涯，本以为会一直待在那里。后来，一位非常出色的人士 Abe Shafi 找到了我，他当时正在创办一家公司。我曾为他们做过很多工作，他们当时是我的客户。在帮他们招到几个优秀人才后，他们说：“我们要么找你帮我们搜寻一位人才负责人（Head of Talent），要么你干脆直接加入我们。”于是我成了那里的第一位招聘人员，从零开始构建了整个人才职能部门。

---

### [00:07:27] Lauren Ipsen

**English:**
I definitely think there was a part of me that I loved the operating experience, learned a ton, worked side by side some amazing people, but was really missing working with founders, and lots of them, and keeping a pulse on the market. So General Catalyst tapped me most recently, and been working here for the past couple months, and it's been great thus far, and I'm specializing in our consumer and crypto investments.

**中文翻译:**
我确实很喜欢那段实操经验（operating experience），学到了很多，并与一些了不起的人并肩作战。但我真的很怀念与众多创始人合作、并时刻掌握市场脉搏的感觉。所以最近 General Catalyst（风投基金）找到了我，我在这里工作了几个月，目前感觉非常棒，我主要负责我们的消费和加密货币投资领域的人才工作。

---

### [00:07:51] Lenny

**English:**
Awesome. The fact that you're at GC now makes me think about another recruiter that I know who's awesome, Austin Brizendine, and it's interesting that a lot of the best recruiters seem to be heading to VC funds, and I'm curious why that is happening. Is it like a comp thing? Is it other things that are pulling everyone away into funds?

**中文翻译:**
太棒了。你现在在 GC，这让我想起我认识的另一位优秀的招聘官 Austin Brizendine。很有意思，很多顶尖的招聘人员似乎都在往风投基金（VC funds）跑。我很好奇为什么会这样。是因为薪酬（comp）吗？还是有其他因素把大家都吸引到了基金公司？

---

### [00:08:09] Lauren Ipsen

**English:**
It's a great question. It's definitely not a comp thing. I'll say that. I think it could be a stability of life thing. Search is incredibly volatile, and you have to hustle so hard, and as soon as you have three wins, you've got four more things to execute on. And so, there's aspects of it that can be tough, especially in a market like right now where you really do have to chase business and you can't be selective about what you take on, so you could be pitching things that maybe you don't necessarily believe in in its entirety or what have you. So, I think that's one component.

**中文翻译:**
这是一个好问题。我得说，绝对不是因为薪酬。我认为可能是因为生活的稳定性。猎头行业（Search）波动性极大，你必须拼命奔波，刚搞定三个单子，又有四个任务等着你。所以有些方面很辛苦，尤其是在现在的市场环境下，你必须主动去找业务，没法挑肥拣瘦，有时你甚至得去推销一些你自己都不完全相信的项目。我认为这是一个因素。

---

### [00:08:39] Lauren Ipsen

**English:**
In house is obviously difficult right now as well for talent leaders. It's really scary to take a bet on one single company right now and know what it's going to look like six months from now. And so I think those things combined might be the reason for an influx in folks leaning more towards venture, and I think it's just timeliness.

**中文翻译:**
对于企业内部（In-house）的人才负责人来说，现在显然也很困难。在目前的环境下，把赌注押在一家公司身上，且不知道六个月后会是什么样子，这是很可怕的。所以我认为这些因素结合在一起，可能是导致人才流向风投领域的原因，我觉得这纯粹是时势使然。

---

### [00:08:59] Lenny

**English:**
Got it. That makes sense. The downside is it's hard for people to find awesome recruiters because once you're in a fund, you're just going to help those startups. And so we're going to talk later about just how do people find awesome recruiters, what do you look for? But there's roughly three things I want to spend our time chatting through today. One is for founders and hiring managers, just how to find the best talent and what they could do to be successful finding the best talent. Two is for product leaders and PMs, how to give themselves the most opportunity from the flip side. And then third is just for recruiters, what do they often do wrong? How do they miss out on the best product talent? Does that sound good?

**中文翻译:**
明白了，有道理。缺点是人们很难找到优秀的猎头了，因为一旦你进了基金，你就只为那些被投初创公司服务。我们稍后会聊聊人们该如何找到优秀的招聘人员，以及该看重什么。今天我想聊三件事：第一，针对创始人和招聘经理，如何找到顶尖人才以及如何成功招到他们；第二，针对产品领导者和 PM，从另一面看，如何为自己创造最多的机会；第三，针对招聘人员，他们经常犯什么错？为什么会错过最优秀的产品人才？这样安排可以吗？

---

### [00:09:37] Lauren Ipsen

**English:**
Yeah, that sounds great.

**中文翻译:**
好的，听起来很棒。

---

### [00:09:39] Lenny

**English:**
Okay, cool. So on the hiring front, just diving in, say you are a founder, you're someone really early at a company, and maybe you've got a couple PMs and you're starting to think about we need to hire a really senior product leader or first senior product leader.

**中文翻译:**
好。关于招聘，我们直接切入正题。假设你是一位创始人，处于公司非常早期阶段，手下可能有几个 PM，你开始考虑需要聘请一位非常资深的产品领导者，或者是第一位资深产品领导者。

---

### [00:09:52] Lauren Ipsen

**English:**
Sure.

**中文翻译:**
明白。

---

### [00:09:53] Lenny

**English:**
What do you find is often the biggest mistake that founders make when they're trying to hire their first senior product leader?

**中文翻译:**
你发现创始人在试图招聘第一位资深产品领导者时，最常犯的错误是什么？

---

### [00:09:59] Lauren Ipsen

**English:**
I think especially for founders that haven't hired for this caliber of talent in the past, it's really easy to be distracted by shiny objects and look at huge names. You want to find the CPOs of Google and YouTube or what have you because that seems like it would be such an incredible opportunity for brand recognition. And to an extent, it is. But the fact of the matter is, oftentimes those individuals are pretty far from the work and have a great team of executors that they've put into place that are actually the ones that are in the weeds.

**中文翻译:**
我认为，尤其是对于那些以前从未招聘过这种级别人才的创始人来说，很容易被“华而不实的东西”（shiny objects）分散注意力，只盯着那些大名鼎鼎的人物。你想找 Google 或 YouTube 的 CPO 之类的人，因为这似乎是提升品牌认可度的绝佳机会。在某种程度上确实如此。但事实是，这些大佬通常已经脱离一线工作很久了，他们手下有一支优秀的执行团队，那些人才是真正深入细节（in the weeds）干活的人。

---

### [00:10:33] Lauren Ipsen

**English:**
And so I think that's the biggest mistake I see people make, especially on the hiring front where they have limited resources, and maybe they're an early stage company and trying so hard to bring in big names is not always the best way to go about it because the fact of the matter is they need to go then hire a team. So, I think looking for someone that's a little closer to the work, maybe someone that can step up into that type of role and do so in a way where some days they might actually be operating like a PM and then other days they might be able to build from a leadership perspective, that's more of the DNA that people should be targeting.

**中文翻译:**
所以我认为这是我见过的最大错误，尤其是在资源有限的招聘方。对于早期公司来说，费尽心思引进大人物并不总是最佳方案，因为现实是，他们进来后还得再去招一个团队。因此，我认为应该寻找那些离一线工作更近的人，也许是那些能够胜任这个角色，并且既能像 PM 一样实操，又能从领导力角度进行建设的人。这才是人们应该寻找的特质（DNA）。

---

### [00:11:09] Lenny

**English:**
Do you think the source of the issue with that going wrong, that they no longer can do that work as well because they've been shielded away from the tactical day to day? Or is it that they're not as hungry as they used to be and they're just like, "I already, I'm a YouTube 10 year super success, I don't need to prove myself anymore," and they're just not as hungry, or something else?

**中文翻译:**
你认为出问题的原因是因为他们被日常琐事屏蔽太久，导致不再擅长那些工作了？还是因为他们不再像以前那样“饥渴”了，觉得“我已经在 YouTube 成功了 10 年，不需要再证明自己了”，所以缺乏动力？还是别的什么原因？

---

### [00:11:29] Lauren Ipsen

**English:**
I mean, I'm not going to sit here and say that all senior leaders aren't hungry. I think that there's some folks that really lean into the work in a different way and miss that, and often go to startups because they crave building.

**中文翻译:**
我并不是说所有资深领导者都没有动力。我认为有些人确实以不同的方式投入工作，他们怀念那种感觉，去初创公司正是因为他们渴望“从无到有”的建设过程。

---

### [00:11:41] Lauren Ipsen

**English:**
So it's not necessarily that, but I do tend to lean towards folks that have a chip on their shoulder or have something to prove and want to build a name for themselves. All of that to say, there's a reason that a lot of those people got to where they are, and some of the best talent are some of the senior folks, but just maybe not necessarily the best talent for where this company is today. Right? It could be great for 10 years down the road, but the past five years of that individual's career could have been far more focused on camaraderie, team building, operational components, performance reviews, and then aspects of product vision, which just might not be the innovative AB testing type of profile that you typically look for in these pre-IPO companies.

**中文翻译:**
所以不一定是动力问题，但我确实更倾向于那些“憋着一股劲儿”（have a chip on their shoulder）或急于证明自己、想要打响名号的人。话虽如此，那些人能达到今天的高度是有原因的，一些最优秀的人才确实是资深人士，但他们未必是这家公司“现阶段”最需要的人才。对吧？他们可能适合公司 10 年后的样子，但过去五年里，他们的职业重心可能更多是在团队情谊、团队建设、运营组件、绩效评估以及产品愿景上，而这可能并不是 pre-IPO 公司通常寻找的那种专注于创新和 AB 测试的画像。

---

### [00:12:27] Lenny

**English:**
Got it. I imagine there are stories that you can share about people you've placed like that, that have not worked out. If you can share one, that'd be awesome. But maybe a side question is the general advice, just don't assume someone that's been successful at a big company with a fancy background is going to be great. Sometimes they work out, but not always, is that kind of the takeaway?

**中文翻译:**
明白。我想你一定有一些关于这类人才安置后却没能成功的案例。如果你能分享一个，那就太棒了。不过顺便问一下，普遍的建议是不是：不要假设一个在大公司拥有光鲜背景并取得成功的人就一定会表现出色。有时他们行，但并非总是如此，这是核心结论吗？

---

### [00:12:46] Lauren Ipsen

**English:**
Yeah. I would say the general advice is who is going to be best for this specific role at this specific time, not necessarily who is the best talent in the world or in the market. Those are two very, very different questions to ask. And I think early on in my recruiting career, I was often just trying to recruit these whales of executives to try and prove myself and say, "Oh, I got this person to entertain this opportunity, how sick is that?" But naturally, that's not necessarily the person that actually can move the needle. And so you need to think very specifically. Just because this is the best talent, that doesn't necessarily mean they are the best talent for this role today.

**中文翻译:**
是的。我会说，普遍的建议是：谁最适合“此时此刻”的“这个特定角色”，而不一定是“世界上”或“市场上”最优秀的人才。这是两个截然不同的问题。在我职业生涯早期，我经常试图招揽那些“大鱼”级别的高管来证明自己，心想：“哦，我竟然让这个人考虑这个机会了，多牛啊！”但很自然地，那个人未必是真正能产生实质影响（move the needle）的人。所以你需要考虑得非常具体。仅仅因为某人是最顶尖的人才，并不意味着他是这个角色当下的最佳人选。

---

### [00:13:25] Lenny

**English:**
So to double down on that, say you are hiring and you know you're going to start hiring a senior product leader, what is it that you suggest founders nail down and iron out when they're kicking off the hiring process, either on their own or with a recruiter? Like, in the job description, what else do they have to get right to find the right person?

**中文翻译:**
为了进一步探讨，假设你正在招聘，并且知道要开始招一位资深产品领导者，你建议创始人在启动招聘流程时（无论是自己招还是找猎头），需要明确和落实哪些事情？比如在职位描述（JD）中，还有哪些地方必须做对才能找到合适的人？

---

### [00:13:48] Lauren Ipsen

**English:**
It's a number of things, like product leaders can come in a lot of different flavors, and so I think it's trying to determine where this person should major and minor, where they should spike. Is this someone that's going to really lean into the design efforts? Is it someone that actually kind of needs to just operate like a very senior PM and continue to build out a team? Is this someone that really should be focused on product vision for the long haul? And then thinking more holistically about how to build the rest of the team.

**中文翻译:**
有很多方面。产品领导者有很多种类型，所以要确定这个人的“主修”和“辅修”是什么，他们的长处（spike）在哪里。是那种会全身心投入设计的人吗？还是那种实际上需要像资深 PM 一样操作并继续组建团队的人？还是那种应该长期专注于产品愿景的人？然后还要更全面地思考如何组建团队的其余部分。

---

### [00:14:12] Lauren Ipsen

**English:**
There's so many different ways in which you can hire for a product leader. So I think it's trying to work a little bit backwards and think about, what is the actual outcome that we are trying to solve for with this hire? Or are we just hiring a head of product because we feel like we need to hire a head of product? That's so often what I see is the board's telling me we need to hire a head of product and I don't necessarily think that we do, or I'm not exactly sure what we need in this role. And so whenever you're starting a search in that regard, it's kind of doomed from inception, so you need to get incredibly granular on the front end around, what is this person going to be coming in to do? What's their mandate? And if we think about someone that's just absolutely hitting it out of the park and crushing it, what does that look like? So I think just trying to be really specific on the front end.

**中文翻译:**
招聘产品领导者有很多不同的方式。所以我认为应该尝试“逆向推导”：我们通过这次招聘想要解决的实际结果（outcome）是什么？还是说我们只是因为觉得“需要”一个产品负责人而招聘？我经常看到的情况是，董事会告诉我需要招一个产品负责人，但我并不一定觉得需要，或者我不确定这个角色到底需要做什么。如果你在这种情况下开始搜寻，从一开始就注定失败。所以你需要在前期做得非常细致：这个人进来要做什么？他们的使命（mandate）是什么？如果我们想象一个人表现极其出色（hitting it out of the park），那会是什么样子的？总之，前期一定要非常具体。

---

### [00:14:59] Lenny

**English:**
I love that last piece, just what does success really look like for this person? On the first piece, that's exactly the same advice I give founders when they're looking for a PM is like, what do you concretely need them to do day to day? Not like, "We need someone to help us with product." And that often helps illuminate, okay, I see. We need someone to help us ship more consistently. We need someone to help us hire engineers. Yeah, just make a list. What are they going to do in the first month or two or three?

**中文翻译:**
我喜欢最后那一点，即“成功对这个人来说到底意味着什么”。关于第一点，这和我给那些寻找 PM 的创始人的建议完全一样：你具体需要他们每天做什么？而不是说“我们需要有人帮我们搞产品”。这通常有助于理清思路：哦，我明白了，我们需要有人帮我们更稳定地发布产品（ship more consistently），或者我们需要有人帮我们招聘工程师。是的，列个清单，他们在第一、第二或第三个月要做什么？

---

### [00:15:24] Lauren Ipsen

**English:**
Yeah, yeah, absolutely. I think those are the most important things. Like the 90 day plan is something that's overused but so necessary, and that's just the tip of the iceberg. So that component and then, okay, a year from now, what should this person be doing? Two years from now? Do we want them to grow up into a CPO role? Do we think about that in a different way? How are we thinking about the product direction today, 12 months from now, 18 months from now, through IPO? I think it's really difficult to think about things that way, and so often you're thinking about the task in front of you and just trying to iterate quickly, but that is the type of thought process that needs to be happening from the CEOs and founders.

**中文翻译:**
没错，绝对是这样。我认为这些是最重要的事情。比如“90 天计划”虽然被说烂了，但确实非常必要，而且这只是冰山一角。除了这个，还要想：一年后这个人应该做什么？两年后呢？我们希望他们成长为 CPO 吗？我们是否以不同的方式思考这个问题？我们如何看待今天、12 个月后、18 个月后直到 IPO 的产品方向？我知道这样思考很难，因为你通常只关注眼前的任务并试图快速迭代，但这就是 CEO 和创始人需要具备的思维过程。

---

### [00:16:06] Lenny

**English:**
Are there archetypes of PMs, if you just bucket like here's the three maybe most common types of product leaders that founders hire, because there's an infinite list of skills and things they could do, but just to make it even simpler, like here's probably one of these three you're looking for. Do you have something like that in your head?

**中文翻译:**
有没有 PM 的原型（archetypes）？如果你把创始人招聘的最常见的几种产品领导者归为三类，因为技能和职责是无限的，但为了简单起见，能不能说“你找的大概就是这三类之一”。你脑子里有这样的分类吗？

---

### [00:16:25] Lauren Ipsen

**English:**
Yeah, there's platform product leaders or folks that are kind of more indexed on the infrastructure components. There's folks that are typically focused on core product, or consumer product if it's on the consumer side of things. And then you'll have folks that are really indexed and that can include UX individuals, design folks. And then there's also typically specialists, so individuals that are really hyper-focused on growth or monetization or what have you. Those are the three buckets that I would say I see most often.

**中文翻译:**
有的。第一类是平台产品领导者，或者说更侧重于基础设施组件的人。第二类是通常专注于核心产品的人，如果是消费端，就是消费级产品。第三类是那些非常侧重用户体验（UX）和设计的人。此外，通常还有专家型人才，比如极度专注于增长（growth）或变现（monetization）的人。这就是我最常看到的三大类。

---

### [00:16:57] Lenny

**English:**
Do you feel like founders sometimes pick one of the wrong buckets and that's a common mistake, or is it generally it's the wrong bucket but then maybe it's not the right spikes of skills within that bucket?

**中文翻译:**
你觉得创始人有时会选错类别吗？这是一个常见的错误吗？还是说通常类别选对了，但该类别下的具体技能长处（spikes）不对？

---

### [00:17:08] Lauren Ipsen

**English:**
Well, it's kind of twofold. I think sometimes people just bring in a head of product to do everything, so that's probably not the best way to go about things. I think that ends up being a unicorn, which you hear often in the search world, and it becomes really difficult to hone in on what good looks like.

**中文翻译:**
这有两个方面。我认为有时人们只是招一个产品负责人来做“所有事情”，这可能不是最好的办法。这最终会变成寻找所谓的“全才/独角兽”（unicorn），这在猎头界经常听到，而且很难界定到底什么样的才算优秀。

---

### [00:17:25] Lauren Ipsen

**English:**
And so I think again, it just comes back to having a clear org chart on the front end and determining, are we hiring someone specifically to build out our walled garden ads approach, or are we hiring someone to run product marketing, or are we hiring someone to help from a product perspective to build a better core user experience? Those are all very, very, very different roles, and if you bring in one person to try and do it all, the facts of the matter is, they're going to have to bring in some key lieutenants to help them, so is that something you want to do or are you more focused on bringing in someone imminently to help on the ad side of things, and then we can find that head of product to help them out down the road?

**中文翻译:**
所以，这又回到了前期要有清晰的组织架构图，并确定：我们是招人专门构建“围墙花园”式的广告方案，还是招人负责产品市场（PMM），或者是招人从产品角度构建更好的核心用户体验？这些都是非常、非常不同的角色。如果你招一个人来做所有事，现实情况是，他们必须再招一些核心副手（key lieutenants）来帮忙。那么这是你想做的吗？还是你更倾向于先招一个能立刻解决广告端问题的人，以后再找产品负责人来协助他们？

---

### [00:18:05] Lauren Ipsen

**English:**
That's kind of the way in which I would architect it and think about it, is what's most imminent, and what do you actually need to hire for today, as opposed to just hiring for the sake of hiring and bringing in that leader.

**中文翻译:**
这就是我会规划（architect）和思考的方式：什么是迫在眉睫的？你今天到底需要招什么样的人？而不是为了招聘而招聘，盲目引进一个领导者。

---

### [00:18:17] Lenny

**English:**
And part of the discussion there is maybe they grow up into this head of product long term, maybe not. Maybe we just need someone to ship the ads platform, right?

**中文翻译:**
这里的讨论也包括：也许他们长期能成长为产品负责人，也许不能。也许我们现在只需要有人把广告平台发布出来，对吧？

---

### [00:18:24] Lauren Ipsen

**English:**
That's exactly right. Yeah.

**中文翻译:**
完全正确。

---

### [00:18:26] Lenny

**English:**
You mentioned this title of head of product. There's also VP of product, CPO. There's all these titles and I feel like people sometimes use them interchangeably, don't know which one to use when they're putting out a job description. Do you have any kind of heuristic rule of thumb of just, here's how to think about when to use each of these titles? Or is it not even a big deal for, say, a founder, hiring the first senior product leader?

**中文翻译:**
你提到了“产品负责人”（Head of Product）这个头衔。还有 VP of Product、CPO。头衔这么多，我觉得人们有时会混用，发 JD 时不知道该用哪一个。你有没有什么经验法则（heuristic rule of thumb），告诉大家如何考虑何时使用这些头衔？或者对于招聘第一位资深产品领导者的创始人来说，这根本不重要？

---

### [00:18:48] Lauren Ipsen

**English:**
It's a great question and it definitely leads to confusion across the board because I'll have candidates come to me and they'll say, "I'm only looking for a CPO role," when I'm working with a startup where, maybe on the venture side of things, we've actually advised that startup to not hire C-level executives at this point. And so that naturally could eliminate a candidate that could be amazing for the role.

**中文翻译:**
这是一个很好的问题，确实会引起普遍的困惑。有些候选人会跟我说：“我只看 CPO 的职位。”但我合作的初创公司，可能在风投方的建议下，现阶段并不打算聘请 C 级高管。这样一来，自然就会刷掉一些本来非常适合该职位的候选人。

---

### [00:19:15] Lauren Ipsen

**English:**
Similarly, people could feel that way if it's a VP of product role, but that in their mind is the most senior product leader within the organization running everything from end to end who they intend to be the CPO down the road but are not in a position where they're ready to hire C-level execs. So, it's tough, and it really depends on the organization and the way in which they're thinking about org charts and leveling.

**中文翻译:**
同样，如果是 VP of Product 职位，人们也可能有这种感觉。但在公司看来，这就是组织内最资深的产品领导者，负责端到端的所有事务，他们打算让这个人未来担任 CPO，但目前还没准备好聘请 C 级高管。所以这很困难，很大程度上取决于组织本身以及他们对组织架构和职级（leveling）的思考方式。

---

### [00:19:39] Lauren Ipsen

**English:**
A lot of startups at this point are almost allergic to C titles or VP titles or are just more title agnostic than I've seen in the past, so you see a lot more of these head ofs, and that is sector leaders, up until probably C plus or D stage. And then you get to D and E, and you'll see more of the VP, director, CPO type. And I think that is the way that people should be thinking about it is, if I'm joining a company very, very early days and it's called head of engineering, that is intended to be the most senior engineering leader within the organization.

**中文翻译:**
现在的很多初创公司几乎对 C 级或 VP 头衔“过敏”，或者比我过去看到的更不在乎头衔（title agnostic）。所以你会看到更多“Head of”（负责人）这样的称呼，这些是部门领导者，这种情况通常持续到 C+ 轮或 D 轮。到了 D 轮和 E 轮，你会看到更多 VP、总监、CPO 之类的头衔。我认为人们应该这样理解：如果我在非常早期加入一家公司，职位叫“工程负责人”（Head of Engineering），那它指的就是组织内最资深的工程领导者。

---

### [00:20:19] Lauren Ipsen

**English:**
The fact of the matter though is there's good reason sometimes why they're not throwing out that C title, and could this person be layered down the road? Potentially, because maybe the talent they need right now is different than, just as we had spoken to earlier, is different than the talent that they might need from a massive CPO in two and a half years.

**中文翻译:**
但事实是，有时他们不给 C 级头衔是有充分理由的。这个人以后会被“架空”（layered，即在上面加人）吗？有可能。因为正如我们之前聊过的，他们现在需要的人才，可能与两年半后公司规模扩大时需要的 CPO 人才完全不同。

---

### [00:20:37] Lauren Ipsen

**English:**
And so I think that rubs people the wrong way because they want a bit of a promise that things are going to, if they join at this stage, that they'll be in it for the long haul and be that chief product officer that takes a company through an IPO. But companies are so dynamic and things change so quickly.

**中文翻译:**
我认为这会让一些人感到不爽，因为他们想要一种承诺：如果在这个阶段加入，他们能长期干下去，并作为首席产品官带领公司上市。但公司是动态发展的，情况变化非常快。

---

### [00:20:52] Lauren Ipsen

**English:**
So, I guess a long-winded way of me saying there's different breadth and depth to each role, but I think for the most part, unless it's a very siloed company with multiple different VPs, if you're coming into a company and they say this is the head of product, the VP of product, or the CPO, that all means the same thing dependent on the stage, for the most part.

**中文翻译:**
所以，我绕了这么大一圈想说的是，每个职位的广度和深度都不同。但大多数情况下，除非是一家拥有多个不同 VP 的高度职能化公司，否则如果你加入一家公司，他们说这是产品负责人、产品 VP 或 CPO，在很大程度上，根据公司所处的阶段，它们指的都是同一件事。

---

### [00:21:14] Lenny

**English:**
And the other takeaway there, which is awesome, is if you're early stage startup, probably just start with head of product. Keep it simple.

**中文翻译:**
另一个很棒的结论是：如果你是早期初创公司，可能直接用“产品负责人”就行了。保持简单。

---

### [00:21:19] Lauren Ipsen

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:21:19] Lenny

**English:**
Don't over promise. Everyone understands.

**中文翻译:**
不要过度承诺。大家都能理解。

---

### [00:21:22] Lauren Ipsen

**English:**
Yeah. Because the last thing you want to do is have to demote someone. But once you get to a place of having C-level executives, like that's not going to do any good, but maybe you start as a head of product, and then as the company continues to grow, you lean into the growth side of things more, and so you become that head of growth or an SVP of growth. Like things iterate and change, but you just never know and you can't predict the outcome of a company on the front end, so.

**中文翻译:**
是的。因为你最不想做的就是不得不给某人降职。一旦你到了需要 C 级高管的阶段，降职没任何好处。但也许你开始是产品负责人，随着公司成长，你更多地转向增长领域，于是你成了增长负责人或增长高级副总裁（SVP）。事情在不断迭代和变化，你永远无法在前期预测公司的最终结果。

---

### [00:21:49] Lenny

**English:**
A lot of people listening to this probably aren't hiring senior product leaders right now, but plan to and will in the future, and so I wanted to ask, what should founders do when they know they will hire a head of product, say, in the next year, that could set them up for success down the road? What should they be doing ahead of time?

**中文翻译:**
听这期节目的很多人现在可能还没在招资深产品领导者，但计划将来会招。所以我想问，如果创始人知道自己明年会招产品负责人，他们现在该做些什么来为未来的成功打下基础？他们应该提前做些什么？

---

### [00:22:07] Lauren Ipsen

**English:**
Regardless of whether or not you're hiring, you should always be keeping a pulse on the market. That is the most important thing. And I think that should be the case for both candidates and folks that are hiring. Like, you never want to put yourself in a position where you have no idea what good looks like, whether that's from a company standpoint or from a candidate standpoint. So, both parties should always be having a good understanding of which companies are thriving, which individuals are building great things and are well known commodities in their organizations and get great references.

**中文翻译:**
无论你现在是否在招聘，你都应该始终保持对市场的敏锐洞察。这是最重要的。我认为候选人和招聘方都应如此。你绝不想让自己处于完全不知道“优秀”长什么样的境地，无论从公司还是候选人的角度。因此，双方都应该清楚哪些公司正在蓬勃发展，哪些人正在创造伟大的产品，并且在他们的组织中是众所周知的“抢手货”，且拥有极佳的口碑。

---

### [00:22:43] Lauren Ipsen

**English:**
Oftentimes, I encourage founders to simply chat with what good looks like and get a really good sense of what benchmark candidate profiles could be, and who knows where that person will be in a year or what have you, but staying really, really close to really great people and using them from an advising capacity or getting them ingrained in some type of involvement in the product prior to actually having that specific need, I think, is really important.

**中文翻译:**
我经常鼓励创始人去和那些代表“优秀”的人聊聊，从而对“基准候选人画像”有一个清晰的认识。谁知道那个人一年后会在哪里呢？但在实际产生特定需求之前，与优秀的人保持紧密联系，以顾问身份邀请他们，或者让他们以某种形式参与到产品中，我认为这非常重要。

---

### [00:23:11] Lenny

**English:**
That sounds awesome and it makes sense. How do you, as a founder, do some of that? Do you just ask folks like, "Hey, who are some of the best product leaders you know? I just want to chat with them. I'm not hiring, just want to kind of meet people who are awesome." Is that the behavior you suggest or is there something else you can do?

**中文翻译:**
听起来很棒，也很有道理。作为创始人，具体该怎么做？是直接问别人：“嘿，你认识的最优秀的产品领导者有哪些？我只想和他们聊聊。我不招人，只是想认识一些厉害的人。”这是你建议的做法吗？还是有别的招数？

---

### [00:23:27] Lauren Ipsen

**English:**
That's a great way to go about it. And by simply saying, "No agenda, I'm not trying to hire you tomorrow, I just want to know great people." And to be totally honest, people feel flattered by that, typically. Most of the time if you've been referred to someone and heard nothing but great things about them and you really don't have an agenda other than wanting to pick their brain, people are like, "Huh, well, this is different from the day to day. This is fulfilling," and people want to pour their knowledge, especially into companies that they believe in.

**中文翻译:**
这是一个很好的方法。只需简单地说：“没有目的（No agenda），我不是明天就要招你，我只是想认识优秀的人。”坦白说，人们通常会因此感到受宠若惊。大多数情况下，如果有人向你推荐了某人，而你听到的全是关于他们的好评，且你除了想向他们请教（pick their brain）之外真的没有别的目的，人们会觉得：“嘿，这和日常工作不一样，这很有成就感。”人们愿意倾囊相授，尤其是对那些他们看好的公司。

---

### [00:23:58] Lauren Ipsen

**English:**
So, I think more often than not you'll find that, not just products leaders, but executives across the board are actually really inclined to do so and want to help out because it's a little bit different from the day to day monotony of their work life.

**中文翻译:**
所以，我认为你会发现，不仅是产品领导者，各行各业的高管其实都很乐意这样做并提供帮助，因为这能让他们从单调的日常工作中解脱出来。

---

### [00:24:12] Lenny

**English:**
So the advice is keep track of companies who are killing it, who you might be able to kind of poach from in the future, and keep a list and keep warm contact with folks that are awesome.

**中文翻译:**
所以建议是：关注那些表现极其出色的公司，未来你可能会从那里挖人（poach），列个清单，并与那些优秀的人保持联系。

---

### [00:24:22] Lauren Ipsen

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:24:23] Lenny

**English:**
It reminds me of a founder that ... or basically all founders who are really good at hiring and how far ahead they plant seeds and how they just play the long game with the best people they meet, and they just kind of keep the conversation going until they finally convince them to join a year or two later. Do you find that the same thing?

**中文翻译:**
这让我想起那些非常擅长招聘的创始人，他们播种的时间非常早，对遇到的最优秀的人才总是玩“长线游戏”（play the long game），不断保持对话，直到一两年后最终说服他们加入。你也发现是这样吗？

---

### [00:24:41] Lauren Ipsen

**English:**
Yeah, 1000000%. Yeah. When I was on the executive recruiting side of things at Daversa, the VP of engineering candidate that we ultimately landed, it was a seven month game of courtship, and let's bring him in to help out from an advising capacity, let's ask him how he would think about structuring this organization, let's talk to him about the best talent that he would recommend that we're spending time with. No question that's invasive, but more so just collaborative and exciting, and you'll find that the founder and that leader will build a different level of rapport and trust by not going through a formal interview process and having it feel transactional. And then with that, magic can happen and you can land incredible people.

**中文翻译:**
是的，百分之百同意。当我在 Daversa 做高管猎头时，我们最终搞定的一位工程 VP 候选人，经历了一个长达七个月的“追求期”（courtship）。我们先请他以顾问身份来帮忙，问他如何构思这个组织的架构，请他推荐我们应该接触的顶尖人才。这些问题一点也不冒犯，反而充满协作感和趣味性。你会发现，通过不走正式面试流程、不让过程显得像是一场交易，创始人和那位领导者之间会建立起不同层次的默契（rapport）和信任。然后，奇迹就会发生，你能招到不可思议的人才。

---

### [00:25:24] Lenny

**English:**
This all sounds like a lot of work and a lot of time. Do you have guidance on how long it should take to find, like for a early stage startup, say series A or B, to find someone awesome, and/or how much time founders should spend a week, just best practice, on hiring for someone like this?

**中文翻译:**
这听起来需要投入大量的工作和时间。你有没有什么指导建议，比如对于 A 轮或 B 轮的早期初创公司，找到一个优秀的人通常需要多长时间？或者创始人每周应该花多少时间在招聘这类人才上？

---

### [00:25:41] Lauren Ipsen

**English:**
I mean, I think if you're going to search, so if you're looking for this individual, it's really so case to case. There's searches that I've been in that I call three people. I know they're amazing for this. I tell the founder and CEO, "These are the three people you should chat with, hire one of them." And it's that easy.

**中文翻译:**
我想说，如果你开始搜寻，也就是寻找这个特定的人，真的是因人而异（case to case）。有些搜寻任务，我只给三个人打电话，因为我知道他们非常适合。我告诉创始人和 CEO：“这就是你应该聊的三个人，招其中一个就行。”就是这么简单。

---

### [00:25:59] Lauren Ipsen

**English:**
There's others where it's a lot of trying to figure out what the person's actually looking for. If there's some ... they hit it off from an emotional standpoint. There's so many different things that come with it. I would say from a timing perspective, it's not a hard number. It's more of just put yourself in the room with great people. If you have a tremendous amount of respect for someone, continue to harvest that relationship and ask what good looks like. Find excuses to continue to touch base with people that are important in your network. If you remembered that they'd mentioned that they were going to some event and you think that you might want to hire them down the road, in a non-creepy way, show up to that event. These are things that I'm constantly doing, and I think that founders can do a better job of, but just make yourself known and relevant. And then when you reach out and timing is right, it won't feel so obscure or so transactional.

**中文翻译:**
但也有些情况，需要花很多时间去弄清楚对方到底想要什么，双方是否在情感层面合得来。这里面涉及很多因素。从时间角度来看，没有一个死板的数字。更多的是要让自己置身于优秀的人群中。如果你非常尊重某人，就继续维护这段关系，并请教他们“优秀”的标准。找借口与你网络中重要的人保持联系。如果你记得他们提到要去参加某个活动，而你觉得以后可能想招他们，那就以一种不让人反感（non-creepy）的方式出现在那个活动上。这些是我一直在做的事，我认为创始人可以做得更好。总之，让你自己变得广为人知且与对方相关。这样当你联系他们且时机成熟时，就不会显得突兀或太像一场交易。

---

### [00:26:55] Lenny

**English:**
That reminds me of a time at Airbnb where we had these meetups for engineers every month or so where it was a tech talk, and then all the engineers get a target engineer that is coming to the event. Like they get their profile and their picture, and their job is to make sure they have a great time and try to convince them to join someday.

**中文翻译:**
这让我想起在 Airbnb 的一段经历。我们大约每月为工程师举办一次聚会，通常是一个技术演讲（tech talk），然后每个内部工程师都会分配到一个“目标工程师”候选人。他们会拿到对方的资料和照片，任务就是确保对方玩得开心，并试图说服他们将来加入。

---

### [00:27:14] Lauren Ipsen

**English:**
Oh my god. But it's so real. It's similar to college trips where you're trying to get recruited for a sport, and you have to ensure that you're, yeah, just continuing to give people the best experience possible and staying top of mind for people.

**中文翻译:**
天哪，但这非常真实。这就像大学为了招募体育特长生而组织的参观活动，你必须确保给人们提供最好的体验，并让他们始终记住你。

---

### [00:27:28] Lenny

**English:**
Yeah. But I can see it being creepy, They have no idea there's this person assigned to them, but it works. It worked great. It was a great tactic.

**中文翻译:**
是的。但我能想象这可能有点“诡异”，对方根本不知道有人被专门指派来对接他们，但确实有效。效果非常好，是个很棒的策略。

---

### [00:27:35] Lauren Ipsen

**English:**
That's awesome.

**中文翻译:**
太棒了。

---

### [00:27:36] Lenny

**English:**
I want to come back to a question that I asked, but I feel like you'll have an actual more concrete answer to the specific piece of just, what's your guidance per week how much time you should be spending on hiring broadly, and specifically, heads of product, if that's any different. Do you have any just advice? Because I imagine it's always spend more time than you think. It's going to take a lot of time.

**中文翻译:**
我想回到我之前问过的一个问题，我觉得你对这个具体细节会有更具体的答案：你建议每周在广义的招聘上花多少时间？特别是招聘产品负责人时，会有所不同吗？你有什么建议吗？因为我猜答案总是“花比你想象中更多的时间”，这会耗费大量精力。

---

### [00:27:54] Lauren Ipsen

**English:**
Yeah, it's definitely spend more time than you think. If you are in an actual search, then you should devote all of your time to it. I know that sucks to hear, but you should be really carving out concrete time.

**中文翻译:**
是的，绝对要比你想象的花更多时间。如果你正处于实际的搜寻阶段，你应该投入全部精力。我知道这听起来很糟糕，但你真的应该拨出专门的时间。

---

### [00:28:05] Lauren Ipsen

**English:**
The thing that's tough though is you could spend, I guess what I was trying to say is you could spend one hour on something or you could spend 10 hours on it, but it's more so around, are you doing things to be impactful during that period of time? Are you actually doing things that are going to move the needle? Are you just blindly reaching out to people on LinkedIn? Because that's not going to be the way in which you're going to find the best of the best. Some of the greatest talent, they're not even on LinkedIn.

**中文翻译:**
但难点在于，你可以花 1 小时做某事，也可以花 10 小时，关键在于：在那段时间里，你做的事情是否有影响力？你是否真的在做能推动进展（move the needle）的事？你只是在 LinkedIn 上盲目地联系人吗？因为那不是寻找顶尖人才的方法。有些最优秀的人才甚至不在 LinkedIn 上。

---

### [00:28:32] Lauren Ipsen

**English:**
And so I think it's building a really strong network in advance, and then once you actually get to a place where you need to hire that person, calling all of those amazing people that you've built relationships with and saying, "Now tell me who your favorite person is and who the best person you've ever worked with is, and could you put me on a thread with them?" How are you going to differentiate yourself from the rest of the market? So it's less in my mind like a quantitative number of hours and more of, how are you doing things differently than the rest of the market?

**中文翻译:**
所以我认为应该提前建立一个非常强大的网络。一旦你到了真正需要招人的时候，就给你建立过关系的那些牛人打电话说：“现在告诉我，你最欣赏的人是谁？你合作过的最优秀的人是谁？能不能帮我引荐一下？”你打算如何让自己在市场上脱颖而出？所以在我看来，这与其说是投入的小时数，不如说是你做事的方式与市场其他人的差异化。

---

### [00:29:01] Lenny

**English:**
I want to pull on this thread. Okay, so spending one hour versus 10 hours, and your point about how you could spend one hour and get as much done maybe in those 10 hours. What sorts of behaviors and actions should folks take to make use of, say, that one hour in hiring? How do you not waste your time?

**中文翻译:**
我想深入探讨一下。好，关于花 1 小时还是 10 小时，以及你提到的 1 小时可能达到 10 小时的效果。人们应该采取什么样的行为和行动，才能高效利用那 1 小时的招聘时间？如何不浪费时间？

---

### [00:29:18] Lauren Ipsen

**English:**
I mean, I would say I've got probably five of my all time favorite product leaders in the world that I tap whenever I'm kicking off a search. And they know that whenever life brings them to an opportunity where they are going to start looking or want to lean into board opportunities, that I'm going to set them up and shout their name from the rooftop, so oftentimes they're willing to point me in the right direction of great people, make those introductions, what have you, and I'm going to know simply because of how great they are that they would never put me in touch with someone that wasn't equally as qualified.

**中文翻译:**
我会说，我大概有五个全球最欣赏的产品领导者，每当我启动搜寻任务时都会找他们。他们知道，一旦他们想看新机会或想进入董事会，我会全力帮他们安排，极力推荐（shout their name from the rooftop）他们。所以他们通常愿意为我指引方向，介绍优秀的人才。正因为他们本身非常优秀，我知道他们绝不会介绍一个不够格的人给我。

---

### [00:29:55] Lauren Ipsen

**English:**
So that I think because the quality is there, so I'm not just blindly guessing on quantity, spending a ton of time on LinkedIn, and then having to call unknown entities and ask for back channel references when they also might not even feel comfortable sharing the dirt. You know? So it comes back to rapport and people that you have around you that you know you can trust and tap into and ensuring that you're spending the time in the right areas.

**中文翻译:**
因为质量有保证，所以我不是在盲目追求数量，也不是在 LinkedIn 上耗费大量时间，然后不得不给陌生人打电话询问非正式背景调查（back channel references），而对方可能根本不方便透露实情。你懂吗？所以这又回到了默契以及你身边那些值得信赖、可以求助的人身上，确保你把时间花在了正确的地方。

---

### [00:30:19] Lenny

**English:**
Got it. Yeah, tapping your network makes a lot of sense. If you don't have that yet, I guess is it worth spending time on LinkedIn just cold messaging people as a founder, and any tips there for just cold outreach that you think work for a founder doing it versus you who are a professional at it?

**中文翻译:**
明白。利用人脉网络非常有道理。如果你还没有这样的人脉，作为创始人，在 LinkedIn 上给陌生人发私信（cold messaging）值得吗？对于创始人的冷启动沟通，你有什么建议吗？毕竟你是专业人士，而他们不是。

---

### [00:30:37] Lauren Ipsen

**English:**
I do think it is worth that time. If you see someone that looks amazing, hell yeah, reach out to them, spend time with them, why not? And oftentimes, again, people are excited to see, oh, this CEO and founder wants to pick my brain, doesn't look like they're coming at me to try and recruit me, but rather just to have an open-ended conversation. For sure, and they can sense. You can definitely sense that type of interaction and feel comfortable with it, whereas sometimes the walls immediately go up when someone senses that they're trying to get poached.

**中文翻译:**
我认为值得花这个时间。如果你看到一个看起来很棒的人，当然要联系他们，花时间交流，为什么不呢？而且通常情况下，人们会很兴奋地看到：“哦，这位 CEO 兼创始人想向我请教，看起来不像是在招募我，而只是想进行一次开放式的对话。”确实如此，人们能感觉到这种互动的性质并感到舒适；而如果有人感觉到自己要被“挖墙脚”（poached），他们往往会立刻产生戒心。

---

### [00:31:08] Lauren Ipsen

**English:**
And so it's I think something that's worth them doing for sure. It's just if you are going to look for a key executive and are on a time crunch, I don't necessarily think the best use of your time is blindly reaching out to executives when you don't necessarily have the expertise in knowing which companies were thriving during that period of time, which organizations were great, and which were a little bit weaker within companies. All of those things are just the inner workings of the recruiting atmosphere and technology, and I think tapping people, if you don't have the network, talk to a great recruiter or just spend some time kind of doing some research on who's great. You can ask investors or board members in your companies as to who you should be targeting. So there's always got to be one or two people that can at least point you to another three or four.

**中文翻译:**
所以我认为这绝对值得一试。只是如果你要寻找核心高管且时间紧迫，我不认为盲目联系高管是最佳的时间利用方式，因为你可能缺乏专业知识，不知道那段时间哪些公司在蓬勃发展，哪些组织架构很棒，哪些公司内部其实比较薄弱。这些都是招聘领域和科技圈的内部信息。如果你没有这样的人脉，那就找个优秀的猎头聊聊，或者花点时间研究一下谁比较厉害。你可以询问公司的投资者或董事会成员，看看你应该瞄准谁。总会有一两个人能至少为你引荐另外三四个人。

---

### [00:31:56] Lenny

**English:**
That reminds me of a tactic Gokul shared on this podcast about one of his best tricks, as you think of, if you're hiring salespeople, instead of looking for who are just the best salespeople, you look for the company that is known for being really good at sales and then you go find people there and try to poach their lieutenant types, not maybe necessarily their head of sales. Do you think that's a good move?

**中文翻译:**
这让我想起 Gokul 在这个播客上分享的一个策略，那是他最好的秘诀之一：如果你要招销售，不要只看谁是最好的销售，而是去找那些以销售能力著称的公司，然后去那里挖他们的“副手型”（lieutenant types）人才，而不一定是他们的销售负责人。你觉得这是个好主意吗？

---

### [00:32:17] Lauren Ipsen

**English:**
Yes and no.

**中文翻译:**
是，也不是。

---

### [00:32:18] Lenny

**English:**
Ooh.

**中文翻译:**
哦？

---

### [00:32:19] Lauren Ipsen

**English:**
Yes and no, because I think if the organization is incredibly good at sales then the majority of the folks are probably amazing, but you always have weak links, and just because someone has a brand on their resume at the right time, I think oftentimes CEOs and founders will do this thing where they kind over generalize, well, Amazon's Prime team at this time was amazing or something like that. It's like, they definitely could have been, but just as any other company, there's going to be people that are breakout, top 1% type individuals, and then other individuals that get to ride the wave and reap the benefits of being at the right place at the right time. And I think that's a good starting place, but then also spending time getting a little bit deeper on who the best people are within that organization. But yeah, we always start with market mapping, so determining who the best companies are within a specific area, and then I just encourage everyone to take that a layer deeper.

**中文翻译:**
说是，是因为如果一个组织的销售非常强，那么大部分人可能都很出色。说不是，是因为总会有薄弱环节（weak links）。仅仅因为某人在正确的时间简历上有个大品牌，CEO 和创始人往往会过度概括，比如“亚马逊当时的 Prime 团队太棒了”。确实可能很棒，但就像任何其他公司一样，总会有那种前 1% 的顶尖人才，也会有那些只是“乘势而上”（ride the wave）、在正确的时间出现在正确地点的普通人。我认为这是一个好的切入点，但也要花时间深入了解该组织内部谁才是最优秀的。是的，我们总是从“市场地图”（market mapping）开始，确定特定领域内最好的公司，然后我鼓励大家再深入挖掘一层。

---

### [00:33:16] Lenny

**English:**
Got it. It just comes back to your previous piece of advice. Don't assume someone that has an awesome logo is going to be great, but sometimes they are. There's a question I should have asked you at the beginning that I'm going to ask now. How many folks have you placed? How many companies have you worked with? And then also, is there a story of just your favorite person that you've placed/company you've helped hire that comes to mind?

**中文翻译:**
明白。这又回到了你之前的建议：不要假设拥有光鲜履历（awesome logo）的人就一定很棒，虽然有时确实如此。有个问题我本该在开头问你：你一共安置了多少人？合作过多少家公司？另外，有没有哪个你安置的人或你帮助招聘的公司让你印象最深？

---

### [00:33:36] Lauren Ipsen

**English:**
Yeah. So both great questions. I've placed probably 85 executives over the course of my career, and then lots of entry level employees when I was in house, and also some great key leaders. Yeah, probably 85 searches that I've opened and closed, so that's been incredibly fulfilling work. It's also fun too on the exec side of things because you hire the VP of engineering at Postmates and you see firsthand the product change. You know, you watch those types of things happen before your eyes, which is, it's fulfilling stuff, it's really cool.

**中文翻译:**
好的，这两个问题都很棒。在我的职业生涯中，我大概安置了 85 位高管，在企业内部工作时还招了很多初级员工和一些核心领导者。是的，大约完成了 85 次搜寻任务，这是一份非常有成就感的工作。在高管招聘方面也很有趣，比如你为 Postmates 招了一位工程 VP，然后你亲眼见证了产品的变化。你看着这些事情在眼前发生，这非常充实，也非常酷。

---

### [00:34:09] Lenny

**English:**
And delivery gets there faster too.

**中文翻译:**
而且外卖送得也更快了。

---

### [00:34:10] Lauren Ipsen

**English:**
Yeah, yeah, exactly. So, that's really fun. Favorite placement of all time has got to be the VP of engineering that I placed at IRL, which is, to be completely honest, a big reason that I joined that company. Alex Strand is his name, and he is just the most incredible, atypical, high emotional intelligent engineering leader. Still super technical, but has managed teams in the hundreds, built out Amazon Prime Day, then went on to build the core messaging platform at Snapchat, called him and he was like, "Why would I ever leave? There's a ton of financial incentive and a team that I've built that all loves me."

**中文翻译:**
没错，正是如此。所以这真的很有趣。我最满意的一次安置是为 IRL 招募的工程 VP，坦白说，这也是我后来加入那家公司的重要原因。他叫 Alex Strand，他是一个不可思议的、非典型的、高情商的工程领导者。他技术极强，管理过数百人的团队，打造过亚马逊的 Prime Day，后来又在 Snapchat 打造了核心消息平台。我给他打电话时，他说：“我为什么要离开？这里有丰厚的期权激励（financial incentive），我亲手组建的团队也都爱戴我。”

---

### [00:34:54] Lauren Ipsen

**English:**
And we got him to ultimately make a move in two weeks, which is just kind of unheard of, although it ended up being like a seven month push for a start date, but that was a big reason why I went and joined IRL was to work side by side him and help build out his team and learn to get more deep on the technical side of things. Because oftentimes, on the executive level, as mentioned before, can be sometimes more of that people management type role. And so he just felt like this unique hybrid of an individual, and yeah, you close searches and you cross your fingers and hope for the best and feel very good about it, but he was one where I had all the confidence in the world that I could not have done better. You know? I just felt so great about that. So, that was a good one.

**中文翻译:**
最终我们让他在两周内决定跳槽，这简直是闻所未闻的，尽管最后花了七个月才确定入职日期。但我加入 IRL 的一个重要原因就是为了能与他并肩作战，帮他组建团队，并学习更深层的技术知识。因为正如之前提到的，高管层有时更多是人员管理类的角色。而他给人的感觉就像是一个独特的“混合体”。是的，当你完成一次搜寻，你会祈祷一切顺利并感觉良好，但对于他，我有十足的信心，觉得自己不可能做得更好了。我感觉非常棒。那次真的很成功。

---

### [00:35:38] Lenny

**English:**
I don't know how much more confidence you could instill in a candidate joining a company than the recruiter also then joining the company.

**中文翻译:**
我想不出还有什么比“猎头自己也加入了这家公司”更能给候选人信心的了。

---

### [00:35:44] Lauren Ipsen

**English:**
Yeah, I did say that to him. I kept saying, "And if I were to go in house, I swear this is probably the company I would do it for." And then about four weeks after he signed, I'd texted him and I said, "Well, you'll never guess."

**中文翻译:**
是的，我确实对他这么说过。我一直说：“如果我要去企业内部，我发誓这可能就是我会选择的公司。”在他签约大约四周后，我给他发短信说：“嘿，你绝对猜不到……”

---

### [00:35:58] Lenny

**English:**
Wow.

**中文翻译:**
哇。

---

### [00:35:58] Lauren Ipsen

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:36:00] Lenny

**English:**
Amazing. What a stamp of confidence.

**中文翻译:**
太神奇了。真是最有力的信心背书。

---

### [00:36:02] Lauren Ipsen

**English:**
Yeah. And a full circle life moment. I sent him a box of cookies, he sent it back and said, "Your turn."

**中文翻译:**
是的。这真是一个奇妙的轮回。我送了他一盒饼干，他回寄给我说：“轮到你了。”

---

### [00:36:07] Lenny

**English:**
And is he still there at IRL? Awesome.

**中文翻译:**
他还在 IRL 吗？太棒了。

---

### [00:36:09] Lauren Ipsen

**English:**
Yes, he is. He's great.

**中文翻译:**
是的，他还在。他很出色。

---

### [00:36:12] Lenny

**English:**
This episode is brought to you by Vanta, helping you streamline your security compliance to accelerate growth. If your business stores any data in the cloud, then you've likely been asked or you're going to be asked about your SOC 2 compliance. SOC 2 is a way to prove your company's taking proper security measures to protect customer data and builds trust with customers and partners, especially those with serious security requirements.

**中文翻译:**
本集节目由 Vanta 赞助，帮助你简化安全合规流程以加速增长。如果你的业务在云端存储数据，那么你很可能已经被问到或将被问到 SOC 2 合规性问题。SOC 2 是证明公司采取了适当安全措施来保护客户数据的一种方式，有助于建立客户和合作伙伴的信任，尤其是那些有严格安全要求的客户。

---

### [00:36:37] Lenny

**English:**
Also, if you want to sell to the enterprise, proving security is essential. SOC 2 can either open the door for bigger and better deals or it can put your business on hold. If you don't have a SOC 2, there's a good chance you won't even get a seat at the table.

**中文翻译:**
此外，如果你想向企业级客户销售产品，证明安全性至关重要。SOC 2 既能为你开启更大、更好的交易之门，也可能让你的业务停滞不前。如果你没有 SOC 2，很可能连谈判桌都上不去（get a seat at the table）。

---

### [00:36:51] Lenny

**English:**
Beginning a SOC 2 report can be a huge burden, especially for startups. It's time consuming, tedious, and expensive. Enter Vanta. Over 3,000 fast growing companies use Vanta to automate up to 90% of the work involved with SOC 2. Vanta can get you ready for security audits in weeks instead of months, less than a third of the time that it usually takes.

**中文翻译:**
开始准备 SOC 2 报告可能是一个巨大的负担，尤其是对初创公司而言。它耗时、乏味且昂贵。这时 Vanta 就派上用场了。超过 3000 家快速成长的公司使用 Vanta 将 SOC 2 涉及的工作自动化高达 90%。Vanta 可以在几周内（而不是几个月）让你准备好接受安全审计，时间不到通常所需的三分之一。

---

### [00:37:14] Lenny

**English:**
For a limited time, Lenny's Podcast listeners get $1,000 off Vanta. Just go to vanta.com/lenny, that's V-A-N-T-A.com/lenny to learn more and to claim your discount. Get started today.

**中文翻译:**
在限定时间内，Lenny 播客的听众可以享受 Vanta 1000 美元的优惠。只需访问 vanta.com/lenny 即可了解更多信息并领取折扣。今天就开始吧。

---

### [00:37:29] Lenny

**English:**
I want to shift a little bit to kind of flip to the product person's perspective and talk about, how do you be successful as a product leader in finding new opportunities and giving yourself opportunities in the space? And so maybe a first question is just generally, what should product leaders and PMs focus on to give themselves the most opportunity in their career?

**中文翻译:**
我想转换一下话题，从产品人的角度来聊聊：作为一名产品领导者，如何成功地寻找新机会并在这个领域为自己创造机会？第一个问题是，总的来说，产品领导者和 PM 应该关注什么，才能在职业生涯中获得最多的机会？

---

### [00:37:51] Lauren Ipsen

**English:**
I think breadth is incredibly important. It's so critical, especially if someone has an end goal of wanting to step into a product leadership role to have been able to have touched lots of different components, as opposed to specializing in one specific thing. So I would say that's very important, to be able to make sure that you're maximizing opportunities for yourself down the road.

**中文翻译:**
我认为广度（breadth）极其重要。这非常关键，特别是如果某人的最终目标是进入产品领导层，那么接触过许多不同的组件，而不是只专注于某一个特定领域，是至关重要的。所以我会说，为了确保你能在未来最大化自己的机会，这一点非常重要。

---

### [00:38:12] Lauren Ipsen

**English:**
And then as mentioned before, just always keeping a pulse on the market, regardless of how happy you are in your current company, regardless of what the project is that you're so incredibly excited about that isn't going to conclude until Q1 of next year. It's just so important that you always know the companies that are doing great things and keep those windows open for people, because you never know what the next 12 months hold, and you want to be in a position where you're never running out the door looking for what's next, but rather being able to be super selective about the things that you have in front of you. And that comes with time and network building and relationship building over years, honestly.

**中文翻译:**
正如之前提到的，要始终保持对市场的敏锐洞察。无论你在现在的公司有多开心，无论你正在做的那个让你兴奋不已的项目要到明年第一季度才结束，这都不重要。重要的是你始终了解哪些公司在做伟大的事情，并为他人留一扇窗。因为你永远不知道接下来的 12 个月会发生什么，你希望自己处于这样一种状态：永远不需要急急忙忙跑出门去找下一份工作，而是能够对面前的机会进行精挑细选。老实说，这需要多年的时间、人脉积累和关系维护。

---

### [00:38:54] Lenny

**English:**
And when you say breadth, are you saying things like work on the platform team for a bit, work on the user facing team, maybe the internal tools team, like different types of product, or something else?

**中文翻译:**
当你提到“广度”时，你是指在平台团队待一段时间，在面向用户的团队待一段时间，或者在内部工具团队待一段时间，也就是尝试不同类型的产品，还是指别的？

---

### [00:39:04] Lauren Ipsen

**English:**
Exactly that. Yeah. I think there's people that probably want to just be a specialist in growth, or want to get super deep on ads, and if that's the case, then by all means, do so. And I think there's something to be said about that as well because those types of skillsets will be needed. But if you're looking to diversify your skillset, continue to grow from a career trajectory perspective and think about potentially being in a head of product type role, I think it's really important that you touch all aspects of that.

**中文翻译:**
正是如此。我想有些人可能只想成为增长专家，或者想深耕广告领域，如果是这样，那完全没问题。这些技能也是被需要的。但如果你想让自己的技能多样化，从职业轨迹（career trajectory）的角度持续成长，并考虑未来担任产品负责人之类的角色，我认为接触产品的方方面面是非常重要的。

---

### [00:39:38] Lenny

**English:**
I'm really happy to hear that because that's exactly the advice I give new PMs is that a variety of experience is one of the most powerful things you can do because you also just become a better PM because you can see how different types of products are built and how different types of teams operate and it just makes you better.

**中文翻译:**
听到这个我很高兴，因为这正是我给新 PM 的建议：丰富的经验（variety of experience）是你拥有的最强大的武器之一。这也会让你成为更好的 PM，因为你能看到不同类型的产品是如何构建的，不同类型的团队是如何运作的，这会让你变得更优秀。

---

### [00:39:52] Lauren Ipsen

**English:**
Yes. Variety of experience, I think taking a bet on doing something more entrepreneurial, starting something, and then also joining things that are a little bit later and more established to get best practices. I think diversifying your skillset within an organization but also diversifying the work in which you're doing and the companies that you're spending time with is awesome.

**中文翻译:**
是的。经验的多样性，我认为可以尝试做一些更有创业精神（entrepreneurial）的事情，比如从零开始做点什么，然后再加入一些后期、更成熟的公司去学习最佳实践。我认为在组织内部实现技能多样化，同时在工作内容和所服务的公司类型上实现多样化，是非常棒的。

---

### [00:40:15] Lenny

**English:**
Yeah. So on that, something I'm always weary of is folks jumping around between all the fancy companies to get a bunch of logos on the resume. "Oh, I worked at Snap and Facebook and Netflix," and I feel like you're just building a resume and then your life flies by, and you forget that you should enjoy the things you're doing and work on things that are fulfilling and optimized for not a great resume. And, curious your thoughts on just how often you think you should move from company to company, one to optimize for opportunities in the future, or just generally, do you recommend people try to move around or go deeper at their company? There's a bunch of questions there, but take it wherever you want to.

**中文翻译:**
是的。关于这一点，我一直很警惕那些在各种光鲜的公司之间跳来跳去、只为了在简历上收集一堆名企标签（logos）的人。“哦，我在 Snap、Facebook 和 Netflix 都待过。”我觉得这样只是在刷简历，然后生活就这么溜走了，你忘了你应该享受正在做的事情，去做那些有成就感的事，而不是为了简历而优化。我很想听听你的看法：你认为为了优化未来的机会，跳槽的频率应该是怎样的？或者总的来说，你建议人们多跳槽还是在一家公司深耕？这里有很多问题，你可以随意发挥。

---

### [00:41:01] Lauren Ipsen

**English:**
Yeah, yeah. Okay. Sounds good. I think it's an interesting one because logo collecting is never something that you want to be known for, and the first thing you're taught, like entry level recruiting 101 is recognize patterns of candidates that jump from place to place and don't give opportunities a full chance. So, you're spot on. That is definitely not something you want to be known for if you're a prospect.

**中文翻译:**
好的。这是一个很有趣的话题。因为“收集名企标签”绝不是你想被打上的标签。在初级招聘培训（recruiting 101）中，学到的第一件事就是识别那些频繁跳槽、不给机会充分发展时间的候选人模式。所以你说得很对，如果你是一个有潜力的候选人，你绝对不想以这种形象示人。

---

### [00:41:27] Lauren Ipsen

**English:**
There's also something to be said about staying somewhere too long though. And I will say that. I think sometimes you find people that are almost loyal to a fault, and companies have tanked and all executives have left and the writing's on the wall, and they're holding onto the fact that they were hired by a really good guy or gal and they want to make it work because they care about the human being, and I think sometimes in your career you do have to be a little bit more selfish and think about what's going to be best for you in the long haul. And so maybe that is still keeping your head down and working hard while also being thoughtful about other things that are out there and not saying hard nos to opportunities that knock on your door.

**中文翻译:**
不过，在一家公司待太久也有弊端。我得说，有时你会发现有些人忠诚过度（loyal to a fault），公司已经不行了，高管都走光了，败局已定（writing's on the wall），但他们还守在那里，仅仅因为当初招他们进来的人很好，他们想报恩。我认为在职业生涯中，有时你确实需要稍微“自私”一点，考虑什么对你的长远发展最有利。所以，也许你应该继续埋头苦干，但同时也要留意外部的机会，不要对找上门来的机会一口回绝。

---

### [00:42:12] Lauren Ipsen

**English:**
So it's one where I would say it's an art and a science because you have to be thoughtful about taking on new things and knowing when it's worth taking a bet on yourself, but also you can't run as soon as things get hard because that is recognized, and if there's a riff or an internal dispute or a new leader brought in, and that is so quick as to make you run for the fences, that's not something that people look for because startup world is hard, tech is hard. Look at the crypto world right now. Things are incredibly volatile and difficult, and you want to be able to bring people in that are going to hang with you through the highs and lows.

**中文翻译:**
所以我会说这既是艺术也是科学。你必须慎重考虑接受新事物，知道什么时候值得在自己身上下注；但你也不能一遇到困难就跑，因为这会被人看在眼里。如果公司出现分歧、内部纠纷或空降了新领导，你就立刻想“逃跑”（run for the fences），那不是大家想要的人才。因为初创界很艰难，科技圈很艰难。看看现在的加密货币世界，极其动荡和困难。你希望招到的是那些能陪你共度高潮和低谷的人。

---

### [00:42:55] Lauren Ipsen

**English:**
We're always looking to see where people moved the needle, especially on the product side, where their fingerprints were, what they can actually point to that they did and are proud of during their time there. And so if all that they can say that they did was onboarded and moved on, then doesn't matter where you were, but it's not going to be something that I can at least stand on to cheer you on.

**中文翻译:**
我们总是在寻找人们在哪里产生了实质影响，特别是在产品端，他们的“指纹”（fingerprints，即贡献痕迹）在哪里，他们能具体指出在任职期间做了哪些引以为豪的事情。如果他们能说的只有“入职然后离职”，那么无论你在哪家名企待过，我都无法为你背书或喝彩。

---

### [00:43:22] Lenny

**English:**
I really like that. A lot of this comes down to, what impact have you made? And I was going to touch on that, and your point is, one, kind of heuristic for how long to stay at a place at the minimum is have some meaningful impact you can point to that you led. Does that sound right?

**中文翻译:**
我很喜欢这一点。归根结底在于：你产生了什么影响？我正想聊这个。你的观点是，判断在一家公司至少待多久的一个经验法则是：你是否能指出一项由你主导并产生的重大影响。我理解得对吗？

---

### [00:43:35] Lauren Ipsen

**English:**
Yeah, exactly. And have that meaningful impact be something that others can speak to. I think that's huge. If you built something within the organization that you're proud of but no one knows about it, then that's more difficult to have as your stamp of approval for what you are able to accomplish there. But if you did something that cross-functional leaders were speaking to, that your team all sings the praises of, then that is something that you can put a feather in the cap and say, "Okay, I left this place better than I found it, and that's the reason that I have decided to move forward."

**中文翻译:**
没错，正是如此。而且这种重大影响应该是别人也能感知到的。我认为这非常重要。如果你在组织内部做了一些让你自豪的事情，但没人知道，那就很难作为你能力的证明。但如果你做的事情让跨职能领导者都在谈论，你的团队都赞不绝口，那么你就可以引以为荣（put a feather in the cap）并说：“好，我离开时这家公司比我来时更好，这就是我决定继续前行的原因。”

---

### [00:44:15] Lenny

**English:**
I imagine part of that is reference checks. People are going to check to see if you actually were successful.

**中文翻译:**
我猜这其中一部分涉及背景调查（reference checks）。人们会去核实你是否真的取得了成功。

---

### [00:44:20] Lauren Ipsen

**English:**
All the time. Yup. Whether you are exploratory, opportunistic, not looking at all, people are constantly calling each other, and the world of tech is so, so, so small, and no matter how fired up you were leaving a company or what went sideways, it is so critical that you try to leave the place better than you found it and do so as seamlessly as possible, because you want people to have nothing but positive to say. And oftentimes, that ... The thing that I always find too is if I call 10 people that were a part of the same organization as someone during a given period of time and they can't speak to anything they did, in that case, no news is not necessarily good news. You want to have an impact, you want to be able to say, "I did X, Y and Z. I'm super proud of this and the reason I moved on is because I did what I came in to accomplish."

**中文翻译:**
一直如此。是的。无论你是主动寻找、等待机会还是根本没在看机会，人们都在不断地互相打听。科技圈非常小，无论你离开公司时有多愤怒，或者发生了什么不愉快，尽量体面地离开并让公司变得更好是至关重要的，因为你希望别人对你只有好评。我经常发现，如果我给某人任职期间的 10 个同事打电话，而他们都说不出这个人做了什么，在这种情况下，“没有消息不一定是好消息”。你必须产生影响，你必须能说：“我做了 X、Y 和 Z。我为此感到自豪，我离开是因为我已经完成了我进来的使命。”

---

### [00:45:20] Lenny

**English:**
It's a little bit innately tricky for product leaders. I imagine you run into this, that sometimes you have to upset people as a product leader to get stuff done that needs to get done and maybe they disagree and then later it's like, okay, I see what you did. Is that true? Do you deal with that or is it generally like, oh, yeah, they're the great people everyone knows, like a hundred percent of people will say they're awesome?

**中文翻译:**
这对产品领导者来说天生就有点棘手。我想你一定遇到过这种情况：作为产品领导者，为了完成必须完成的任务，有时不得不让一些人不爽，他们当时可能不同意，但后来会觉得“哦，我明白你为什么这么做了”。是这样吗？你会处理这种情况吗？还是说通常优秀的人大家都知道，百分之百的人都会说他们很棒？

---

### [00:45:38] Lauren Ipsen

**English:**
It's a really good question. I think there's a way to navigate conflict without rubbing people the wrong way so that they'll say negative things. There's a way to be an impactful product leader and disagree and make change, and maybe your engineering leader and design leader and marketing leader completely disagree with the direction in which you're going, but because you have all of the data to support it and because you have gone about things in a way that feels very fact first and less emotional, it's really difficult for them to then point to why they disliked this person.

**中文翻译:**
这是一个非常好的问题。我认为有一种处理冲突的方法，既能解决问题又不会让人反感到说你坏话。你可以做一个有影响力的产品领导者，在表达不同意见和做出改变的同时，即使你的工程负责人、设计负责人和市场负责人完全不同意你的方向，但因为你有数据支持，且你处理问题的方式是事实优先、不带情绪，他们很难在事后指出为什么要讨厌这个人。

---

### [00:46:19] Lenny

**English:**
Yeah. This is interesting. So say you make those 10 calls, in your experience, the leaders you want to hire, are you finding 10 out of 10 are generally like, "Yes, this person's amazing, you should hire them"?

**中文翻译:**
是的，这很有趣。那么假设你打了那 10 个电话，根据你的经验，那些你想聘请的领导者，是否通常 10 个人都会说“是的，这个人太棒了，你应该招他”？

---

### [00:46:31] Lauren Ipsen

**English:**
There's ones that are slam dunks and no one has any negative to say. That's incredibly rare. More often you find some people like to just have something negative to say, just to have something negative to say. I also take all of my back channels with a grain of salt. Maybe the person I'm calling to back channel this person with I also haven't back channeled, right?

**中文翻译:**
有些确实是“板上钉钉”（slam dunks）的优秀，没人说坏话。但这极其罕见。更多时候，你会发现有些人就是喜欢说点负面的，纯粹是为了说而说。我也会对所有的非正式背调（back channels）持保留态度（take with a grain of salt）。毕竟，我打电话询问的那个人，我可能也没对他做过背调，对吧？

---

### [00:46:50] Lauren Ipsen

**English:**
So every single thing that you hear, you just take, make note of, and then move on and think more holistically about. But I think typically what I would say is the glaring nos are very obvious. People that are polarizing individuals or have done wrong within an organization or made bad calls across the board are, you can get that information typically pretty quick.

**中文翻译:**
所以你听到的每一件事，只需记下来，然后继续，再进行更全面的思考。但我认为通常情况下，那些“绝对不行”的人是非常明显的。那些极具争议（polarizing）的人，或者在组织内犯过错、做过极其糟糕决策的人，你通常能很快得到这些信息。

---

### [00:47:13] Lauren Ipsen

**English:**
It's the mixed ones where it's, "I think that person was decent," those are pretty tough, and you need to really find people that worked super closely with them because otherwise it's pretty difficult to say whether or not they were able to make an impact. Which again comes back to why right off the bat it's so nice to just have people that you can tap within every organization that's like an academy company or a great company and say, "Point me in the direction of the three best people." I don't want to have to go through the burden of having to try and back channel all of the maybe middle 50% or what have you.

**中文翻译:**
难办的是那些评价毁誉参半的，比如“我觉得那个人还行”。这种情况下，你需要找到与他们共事非常紧密的人，否则很难判断他们是否真的产生了影响。这又回到了为什么一开始就拥有人脉是件好事，你可以直接找那些“黄埔军校”式公司（academy company）或优秀公司里的人说：“给我指引三个最优秀的人。”我不想费劲去给那些表现平平的 50% 的人做背调。

---

### [00:47:48] Lenny

**English:**
Yeah, most people don't have that, which is a reason to hire, work with a recruiter. You come build in with all of that network.

**中文翻译:**
是的，大多数人没有这种人脉，这就是为什么要找猎头合作的原因。你们自带这种人脉网络。

---

### [00:47:55] Lauren Ipsen

**English:**
Totally. Totally there. Yeah.

**中文翻译:**
完全正确，确实如此。

---

### [00:47:56] Lenny

**English:**
There's a couple things I want to touch on that I wasn't planning to touch on, but reference calls. You do a lot of them, I imagine. And I'm curious, do you have any tips for how to ask questions on a reference call where you actually get useful advice where it's not just, "Yes, I like them, they're great. Hire them"?

**中文翻译:**
有几件事我想聊聊，虽然原本没打算聊，那就是背景调查电话。我想你一定打过很多。我很好奇，你有没有什么技巧，能在背调电话中问出真正有用的建议，而不仅仅是听到“是的，我喜欢他，他很棒，招他吧”？

---

### [00:48:11] Lauren Ipsen

**English:**
Especially on references, provided references, I've only had two candidates where provided references have come back negative, which that's tough. Outside of that, typically references are a standard. It is important to dig pretty deep and ask the hard questions.

**中文翻译:**
特别是对于候选人提供的推荐人（provided references），我只遇到过两个候选人的推荐人给了负面评价，那确实很糟糕。除此之外，推荐信通常都很标准。所以深入挖掘并问一些尖锐的问题非常重要。

---

### [00:48:28] Lenny

**English:**
What's the hard questions?

**中文翻译:**
尖锐的问题有哪些？

---

### [00:48:29] Lauren Ipsen

**English:**
Yeah, why would I not hire this person? What are their biggest weaknesses? And then if they give you the typical, "Oh, if they work too hard," it's like, no, tell me more. What are their actual weaknesses? What are things that we should be really cognizant of? Would you hire this person again? Would you report to this person? Would you endorse this person if you knew that your name was attached to it? Things like that I think get people thinking, and even if you just sense the slightest pause, that in itself will be enough to make you think twice. Right?

**中文翻译:**
比如：“我为什么不该雇佣这个人？”“他们最大的缺点是什么？”如果他们给你那种老掉牙的回答，比如“哦，他们工作太努力了”，你就得追问：“不，告诉我更多。他们真正的弱点是什么？我们应该特别注意什么？”“你会再次雇佣这个人吗？”“你愿意向这个人汇报吗？”“如果你知道你的名字会和这份评价挂钩，你还会为这个人背书（endorse）吗？”这类问题会引发人们的思考，即使你只感觉到一丝犹豫，那也足以让你三思。对吧？

---

### [00:49:04] Lauren Ipsen

**English:**
So it's a lot of reading the room and probing harder than you think necessary, which is tough. But back channel references I think will always provide a greater source of truth than provided. It's similar to an Instagram Reel as opposed to the photos you're tagged in. That's the way I think of it. It's like this is what you want the world to see or think of you as, and then these are what your peers and your direct reports and the people around you actually say about the work that you did during this time.

**中文翻译:**
所以这需要很强的察言观色能力，并且要比你认为必要的程度问得更深，这很难。但我认为非正式背调（back channel）总是比候选人提供的推荐人更能提供真相。这就像 Instagram 上的精选视频（Reel）与你被别人标记的照片的区别。我是这么想的：精选视频是你希望世界看到的你，而别人标记的照片才是你的同事、下属和你身边的人对你那段时间工作的真实评价。

---

### [00:49:33] Lenny

**English:**
Awesome. Coming back to a point you made about recruiter training 101, you learn how to find patterns and red flags in people's resume. What else is a red flag in your resume that you want to avoid/there's a rule of thumb of like, if you're at a place for less than a year, it's bad. Is that true? How do you feel about that? How do hiring managers generally feel about that?

**中文翻译:**
太棒了。回到你提到的招聘培训 101，你会学习如何发现简历中的模式和红线（red flags）。简历中还有哪些应该避免的红线？有没有一种经验法则，比如“在一家公司待不到一年就很糟糕”？这是真的吗？你怎么看？招聘经理通常怎么看？

---

### [00:49:53] Lauren Ipsen

**English:**
It definitely depends, with regards to being at a place less than a year. If that's a recurring theme, of course that's a big red flag. Even if it's happened two or three times, three definitely. If it's happened twice, it's like, "Huh, that feels off." You got to let people tell their story though and their side of things, and again, it comes back to reaching out to different people and understanding if what they're saying is true was actually the truth. And so when you have a really good pulse on what's happening in tech and whether there was a riff and the reason that person was let go was actually because they weren't prioritizing a certain part of the product or whatever, like those things, it happens. That's life, especially right now, right? If we were to X every single person that has a short stint that joined a new company over the course of the past year, that wouldn't do anyone any good.

**中文翻译:**
关于待不到一年，这取决于具体情况。如果这成了一个反复出现的主题（recurring theme），那当然是一个巨大的红线。如果发生了两三次，三次绝对是红线；如果发生了两次，会让人觉得“嗯，有点不对劲”。但你得让人们讲述他们的故事和他们的立场。这又回到了联系不同的人，去核实他们说的是否属实。如果你对科技圈的动态了如指掌，知道当时是否有分歧，或者那个人被解雇的原因是否真的是因为他们没有优先处理产品的某个部分，诸如此类。这些事情时有发生，这就是生活，尤其是现在。如果我们把过去一年中所有有过短暂任职经历（short stint）的人都刷掉，那对谁都没好处。

---

### [00:50:44] Lauren Ipsen

**English:**
Another thing I've found that's pretty interesting is that people will often, because they're so afraid of that narrative, they'll often not include on their resume companies that they didn't stay for a year. And in my personal opinion, that's actually almost more of a red flag because that did happen, and you don't want to just pretend like that wasn't a decision you made in your life, and usually is handled with grace. You can speak to the reason that you decided to make a bet, the reason that you went there, and the reason that you moved on, in a way that people can typically resonate with. But I've seen executives just put that they've simply been advising for two years or something like that, when in reality they had two companies that failed.

**中文翻译:**
我还发现一件很有趣的事：人们因为太害怕那种负面叙事，往往不在简历中写那些待不到一年的公司。在我看来，这反而更像是一个红线，因为那确实发生了。你不能假装那不是你人生中的一个决定。通常只要处理得体，你可以解释为什么决定在那儿下注，为什么去那里，以及为什么离开，人们通常是能产生共鸣的。但我见过有些高管只写自己做了两年的顾问，而实际上他们经历了两次创业失败。

---

### [00:51:33] Lauren Ipsen

**English:**
And the fact of the matter is, I have some CFO candidates I'm talking to right now and their past three years have been short stints because they were brought in to take a company through an IPO and then that changed, or they were brought in to enter into a SPAC and then that became less of the buzz. Right?

**中文翻译:**
事实是，我目前正在接触的一些 CFO 候选人，他们过去三年都是短暂的任职经历，因为他们被招进来是为了带领公司上市，但后来情况变了；或者他们被招进来是为了通过 SPAC（特殊目的收购公司）上市，但后来热度退了。对吧？

---

### [00:51:51] Lauren Ipsen

**English:**
So these things happen and roles change, and I think it's just allowing people to tell their story is the most important thing. So I would say red flag is, for me, just always be honest about when you started, when you left a company. If I see that someone still has present on their LinkedIn but they've been gone for two years and they kind of are acting like they're still there, that doesn't feel good. Just want people to give you the truth, the straight facts, so that you can support them and tell their story and represent them in a way that makes you feel like you have all the details.

**中文翻译:**
所以这些事情会发生，角色也会改变。我认为最重要的是让人们讲述他们的故事。对我来说，红线是：请务必诚实地交代你何时入职、何时离职。如果我看到某人在 LinkedIn 上还显示“在职”，但实际上已经离开两年了，而且表现得好像还在那里，这种感觉很不好。我只希望人们能给出真相和事实，这样我才能支持他们，讲好他们的故事，并以一种掌握了所有细节的方式来代表他们。

---

### [00:52:23] Lenny

**English:**
Got it. So basically, don't lie. That makes sense. That reminds me a little bit of people kind of upgrade their titles a little bit because maybe they don't have an official title or they just want to sound a little important. How do you feel about when people do that on their resumes?

**中文翻译:**
明白。所以基本上就是：别撒谎。这很有道理。这让我想起有些人会稍微“美化”一下他们的头衔（upgrade their titles），也许是因为他们没有正式头衔，或者只是想让自己听起来重要一点。你怎么看简历上的这种行为？

---

### [00:52:35] Lauren Ipsen

**English:**
Yeah, I don't love that. I also don't love on the resume when people, and some people do this and it's okay, but when people say silly, vague names like they'll say something along the lines of, "Whatever at Reddit," as their title or, "Master of blank at this," and it's like, okay, what were you actually doing?

**中文翻译:**
是的，我不喜欢那样。我也不喜欢简历上出现那些愚蠢、模糊的名称。有些人会这么做，虽然也行，但当人们写类似“在 Reddit 负责乱七八糟的事”或者“某某大师”之类的头衔时，我会想：好吧，你到底是在做什么？

---

### [00:52:58] Lenny

**English:**
But I think they do that to avoid recruiters reaching out to them.

**中文翻译:**
但我认为他们这样做是为了避免猎头骚扰。

---

### [00:53:00] Lauren Ipsen

**English:**
Exactly. As their direct target, I'm pissed. So I feel directly attacked in that regard. So that's something that throws me off, but that could definitely be a personal thing. And I think overall, for the most part, people don't have any other things that really just throw me for a loop. And the fact of the matter is, resumes we look at less and less, especially at the executive level, and it's a lot more of allowing people to tell their story, meeting in person, talking with their different people that support them, and getting kind of more of the big picture around who they are.

**中文翻译:**
没错。作为他们的直接目标，我很生气。我觉得这对我是一种直接攻击（笑）。所以这会让我很不爽，但这绝对是我个人的看法。总的来说，大部分人没有其他特别让我困惑的事情。事实是，我们看简历的时间越来越少，特别是在高管层面，更多的是让人们讲述自己的故事，进行面对面交流，与支持他们的不同人交谈，从而更全面地了解他们是谁。

---

### [00:53:33] Lenny

**English:**
I want to talk about what recruiters often do wrong and what you've learned there. But before we get there, one last question: do you have any tips for a product manager in the interviewing process, how to be more successful interviewing?

**中文翻译:**
我想聊聊招聘人员经常犯的错误以及你从中吸取的教训。但在那之前，最后一个问题：对于正在面试的产品经理，你有什么建议能让他们在面试中更成功吗？

---

### [00:53:45] Lauren Ipsen

**English:**
I've had this come up a few times when I've interviewed product folks that they'll speak down on their counterparts or say that the reason they weren't able to meet deadlines or push product in the right way was because of the engineering team or because of other components of the business and it wasn't them. And so I think that's never a good way to go about it. So it seems obvious, but you would be surprised how not obvious it is.

**中文翻译:**
我在面试产品人员时遇到过几次这种情况：他们会贬低（speak down on）他们的同事，或者说他们之所以没能按时完成任务或以正确方式推进产品，是因为工程团队或业务的其他部门，而不是他们自己的问题。我认为这绝不是一个好方法。这看起来很显而易见，但你会惊讶于有多少人意识不到这一点。

---

### [00:54:10] Lauren Ipsen

**English:**
So thinking about things more holistically, speaking honestly about your strengths and things that you want to continue to grow and improve upon, and then being able to tell your story, like practice telling your story. So often people don't do that, especially when they're not looking for jobs, and then it's not until their 10th interview that they know how to tell their story and what they did and what they impacted and why they were someone to be missed when they moved on. Those are things that you want to know how to speak to, and unless it's something you've been doing or practicing, it's less natural. That's some advice I think just off the top of the head.

**中文翻译:**
所以要更全面地思考问题，诚实地谈论你的长处以及你想要继续成长和改进的地方。然后要能讲好你的故事，比如练习讲述你的经历。人们经常不练习，特别是当他们没在找工作的时候。直到第 10 次面试，他们才学会如何讲述自己的故事、做了什么、产生了什么影响，以及为什么他们离开后会让人怀念。这些是你需要学会表达的东西，除非你一直在做或在练习，否则会显得不自然。这是我随口能想到的一些建议。

---

### [00:54:45] Lenny

**English:**
Awesome. That's really good advice. One thing that makes me think about, I know I want to get to this last section, but do you think the best product leaders have their kind of story figured out in the future and work backwards from that and have a sense of where they want to end up, or just kind of take it as it goes? Because I'm the latter. I had no plan, I just went to see ... follow the path that was presented. Do you think that is generally true for folks that end up being successful, or do you recommend people think about, "Here's where I want to be in five years, here's what I need to do to get there"? Do you have any guidance there?

**中文翻译:**
太棒了，非常有用的建议。这让我想起一件事，虽然我想进入最后一个环节，但你认为最优秀的产品领导者是已经构思好了未来的故事并据此逆向推导（work backwards），清楚自己最终想达到什么位置，还是随遇而安？因为我是后者。我没有任何计划，只是顺势而为。你认为对于那些最终成功的人来说，这通常是真的吗？还是你建议人们思考“五年后我想达到什么位置，为了达到那里我需要做什么”？你有什么指导建议吗？

---

### [00:55:18] Lauren Ipsen

**English:**
I mean, for what it's worth, I'm definitely more with you. I don't know where I want to be in five years, so it's tough for me to say. But I do think that typically someone that has the end goal of being a CEO will put the pieces into place to try and get there, and so it's not a bad idea if you do have an end goal of wanting to run your own thing to inch towards that. So maybe you go from being a product specific leader to then operating in some type of GM of a business unit capacity and owning a P&L, and then although it's more of a product oriented role, you're still getting closer and closer to that end goal of COO or CEO.

**中文翻译:**
我想说，就我个人而言，我绝对更倾向于你。我也不知道五年后我想在哪儿，所以很难说。但我确实认为，通常那些以成为 CEO 为终极目标的人，会为了实现目标而排兵布阵。如果你确实有经营自己事业的终极目标，那么向那个方向一点点挪动（inch towards）并不是个坏主意。比如，你可能从一个纯粹的产品领导者转变为某个事业部的总经理（GM），负责损益表（P&L）。虽然这仍然是一个以产品为导向的角色，但你离 COO 或 CEO 的终极目标越来越近了。

---

### [00:55:53] Lauren Ipsen

**English:**
So if it's something like that, then I think that naturally makes sense. Do think people can be enticed by shiny objects, so excited because it's a step up from a title perspective and things like that, and I think that's just so not important in the grand scheme of things. You could be the VP of product or a CPO of what, you know? That's so vague. If someone just says, "I want to be a chief product officer, that's the end goal," I always say, "Of what?" You could be the chief product officer of your household. Is it of a multi-billion dollar consumer brand or ...

**中文翻译:**
如果是这种情况，那自然是有道理的。但我确实认为人们会被“华而不实的东西”诱惑，比如因为头衔提升了而感到兴奋。我认为从长远来看，这根本不重要。你可以是 VP of Product 或 CPO，但那是哪里的 CPO 呢？这太模糊了。如果有人说“我的终极目标是成为首席产品官”，我总是会问：“哪里的？”你可以是你家的首席产品官。是价值数十亿美元的消费品牌的 CPO，还是……？

---

### [00:56:32] Lauren Ipsen

**English:**
So I guess what I'm trying to say is work backwards from a goal for sure, but don't allow titles or valuation bubbles or other things to derail something that feels good. If you're in a role and you feel like you're making an impact and you're learning and you're growing and are excited about the work you're doing, do not allow a title of some other company to make you feel like what you're doing isn't worthwhile.

**中文翻译:**
所以我想说的是，确定一个目标并逆向推导固然重要，但不要让头衔、估值泡沫（valuation bubbles）或其他东西干扰了你感觉良好的现状。如果你在目前的岗位上觉得自己在产生影响、在学习、在成长，并且对工作充满激情，不要因为另一家公司的某个头衔就让你觉得现在所做的一切没有价值。

---

### [00:57:01] Lenny

**English:**
I love that advice. So many people just chase some fancy new role, new title, new logo, and end up getting there like, "Man, this sucks."

**中文翻译:**
我喜欢这个建议。太多人只是在追求光鲜的新角色、新头衔、新公司标签，结果到了那里却发现：“天哪，这地方太烂了。”

---

### [00:57:08] Lauren Ipsen

**English:**
Exactly. Yeah.

**中文翻译:**
没错，就是这样。

---

### [00:57:09] Lenny

**English:**
This reminds me, I did a meditation retreat once and one of the teachings there was you don't want to be fixated with achieving a specific thing, but you want to push your cart in that direction, just like head that direction and have a general sense, but not, "I need to be that thing and that's what'll make me happy."

**中文翻译:**
这让我想起我参加过的一次冥想静修，其中的一个教导是：你不要执着于达成某个具体的目标，而是要“推着你的小车”（push your cart）朝那个方向走。只要朝着那个方向，有个大体感觉就行，而不是非得说“我必须成为那样的人，我才会快乐”。

---

### [00:57:26] Lauren Ipsen

**English:**
Exactly. I think that's exactly right.

**中文翻译:**
没错。我认为完全正确。

---

### [00:57:27] Lenny

**English:**
Awesome. Okay. Final topic is from the recruiter perspective, what do you find recruiters do wrong most often or miss when they're trying to attract great product talent to a company?

**中文翻译:**
太棒了。好，最后一个话题是从招聘人员的角度来看：你发现招聘人员在试图为公司吸引优秀产品人才时，最常犯的错误或遗漏的是什么？

---

### [00:57:38] Lauren Ipsen

**English:**
Yeah, so this is one I feel especially passionate about because I do think recruiters have a bit of a reputation, and I think that it's for some good reason. There's naturally people that forget that these are human beings that we're dealing with every single day that have lives, have families, have careers, or ambitions outside of their career.

**中文翻译:**
是的，我对这个话题特别有激情，因为我确实认为招聘人员的名声不太好，而且我认为这是有原因的。很自然地，有些人会忘记我们每天打交道的是活生生的人，他们有自己的生活、家庭、职业，或者职业之外的抱负。

---

### [00:58:01] Lauren Ipsen

**English:**
So I think it's essential that you remember that this is another human being on the other end of things and that you should treat them with the same level of respect that you would expect to be treated.

**中文翻译:**
所以我认为至关重要的一点是，你要记住对方也是一个人，你应该以你希望被对待的尊重程度来对待他们。

---

### [00:58:15] Lauren Ipsen

**English:**
This has become even more apparent now that I have gone through some of my own recruiting cycles where I was looking for different jobs, and a transactional recruiting call just will rub you so the wrong way and will make you want to put things on your resume like I just alluded to that say things like, "Whatever at Reddit," or what have you because you just don't want to deal with it.

**中文翻译:**
在我自己经历了一些求职过程后，这一点变得更加明显。那种交易性（transactional）的招聘电话真的会让你非常反感，让你想在简历上写一些我刚才提到的东西，比如“在 Reddit 负责乱七八糟的事”，因为你根本不想理他们。

---

### [00:58:36] Lauren Ipsen

**English:**
And so I think you have to be a human, you have to start with a relationship, find common ground, build rapport, listen to people, like actually listen, and remember what they say. So if someone says, "I never want to do a crypto company," and I just am only shoving crypto companies down their throat, that's just insanely tone deaf. Or if they say, "I have this vest that I really want to be around for in May of next year," and I just keep hitting them up prior to that, that's just so not receptive to what they just said.

**中文翻译:**
所以我认为你必须像个人一样去交流，必须从建立关系开始，寻找共同点，建立默契，倾听别人——是真正的倾听，并记住他们说的话。如果有人说“我永远不想去加密货币公司”，而我却一直把加密货币公司塞给他们，那简直是极度“没眼力见”（tone deaf）。或者如果他们说“我明年五月有一笔期权要归属（vest），我想留下来拿到它”，而我却在那之前一直骚扰他们，那说明我根本没听进去他们说的话。

---

### [00:59:12] Lauren Ipsen

**English:**
Things like that, make notes if easier, because we speak to so many people all day long so it's definitely not easy to do. But I'll have a note on my calendar that John Kim's vest just happened in March, and then I'll be like, "Oh, okay, might be a good time for me to catch up." I won't say, "Congrats on the recent vest." I'll say, "You want to grab a coffee, or do you want to catch up about this?" Or, "Hey, I saw that you were speaking at this conference, love what you spoke about with regards to this." You got to find ways to connect with people outside of just shoving them into a job.

**中文翻译:**
诸如此类的事情，如果记不住就做笔记，因为我们整天和那么多人说话，确实不容易记住。但我会在日历上记一笔：John Kim 的期权在三月份归属。然后我会想：“哦，好，现在可能是找他叙旧的好时机。”我不会说“恭喜你期权到手”，我会说“想一起喝杯咖啡吗？或者想聊聊这件事吗？”或者“嘿，我看到你在那个会议上演讲了，我很喜欢你关于某某话题的分享。”你必须找到在“把人塞进工作”之外与人建立联系的方法。

---

### [00:59:46] Lauren Ipsen

**English:**
And so I would say something that I've learned and become very good at is starting with a foundation of relationship building, gaining trust from people, because once you have that, then people will hear you out on jobs and people will listen to you and actually trust your advice from a career direction and perspective, but that takes time to build that, and it's definitely not going to be built by just chucking things at the wall and seeing what sticks with people and seeing where you can shove them temporarily. In fact, that will make them lose trust. And once you lose trust in a candidate, it's impossible to get it back.

**中文翻译:**
所以我学到并变得非常擅长的一点是：以建立关系为基础，赢得人们的信任。因为一旦有了信任，人们才会听你介绍工作，才会听取并真正信任你从职业方向和视角给出的建议。但这需要时间来建立，绝对不是靠随便扔几个职位看哪个能“粘住”人，或者看能把人暂时塞到哪里就能建立起来的。事实上，那样做会让他们失去信任。一旦你失去了候选人的信任，就再也找不回来了。

---

### [01:00:22] Lenny

**English:**
It's interesting how one of the recurring themes of our chat so far is just play the long game in every way, which takes more time.

**中文翻译:**
很有意思，我们聊到现在，一个反复出现的主题就是：在方方面面都要玩“长线游戏”，而这需要更多的时间。

---

### [01:00:28] Lauren Ipsen

**English:**
Yes.

**中文翻译:**
是的。

---

### [01:00:28] Lenny

**English:**
Kind of sucks that you have to put in all this time ahead of time before you really need to get something done, but what you keep coming back to is just that's how you end up being successful as a recruiter, as a product leader, as a hiring manager, as a founder.

**中文翻译:**
在真正需要完成某件事之前，必须提前投入这么多时间，这确实有点让人沮丧。但你反复强调的是，这就是你作为招聘人员、产品领导者、招聘经理或创始人最终获得成功的方式。

---

### [01:00:39] Lauren Ipsen

**English:**
A million percent. Yeah. Yeah. And it's really easy when you've got a quota to hit and you've got people to provide for and a mortgage to just think about the numbers, but you have to play the long game because people aren't just a commodity. It's so much more.

**中文翻译:**
百分之百同意。当你面临业绩指标、要养家糊口、要还房贷时，很容易只盯着数字看。但你必须玩长线游戏，因为人不仅仅是商品，他们远不止于此。

---

### [01:00:56] Lenny

**English:**
And one of the perks of working with a recruiter is they have done that already for you, and so I was going to ask, when does it make sense for a founder to engage with a recruiter like yourself and when should they not?

**中文翻译:**
与猎头合作的好处之一是他们已经为你做好了这些工作。所以我正想问：创始人什么时候应该找像你这样的猎头合作，什么时候不应该？

---

### [01:01:08] Lauren Ipsen

**English:**
Engaging with recruiters sooner rather than later in a proactive way is always a positive thing. It's just sometimes companies aren't at the stage where they can necessarily hire a full-time recruiter because of resources and how expensive it is to bring in an exec recruiter.

**中文翻译:**
尽早以主动的方式与招聘人员接触总是一件好事。只是有时公司还没到能雇佣全职招聘人员的阶段，因为资源有限，而且聘请高管猎头的费用很高。

---

### [01:01:26] Lauren Ipsen

**English:**
So having someone that you can bounce things off of in a more informal capacity, bringing in someone like a talent advisor that can help in a consultative way, those types of things, a million percent. Leaning into the venture firms that have backed you, which is a lot of what I'm doing right now, that is definitely areas in which early CEO founders should be leaning into that and trying to get as knowledgeable as possible. And then I would say typically series B feels ... series A, dependent on the check size, and then series B feels like a good time to bring in a couple key big players, if the company's well positioned to do so.

**中文翻译:**
所以，找一个可以非正式交流的人，或者请一个能提供咨询帮助的人才顾问（talent advisor），这些做法我百分之百支持。利用支持你的风投公司的人才资源——这也是我目前正在做的大部分工作——这绝对是早期 CEO 创始人应该借力的地方，并尽可能多地获取知识。然后我会说，通常 B 轮……或者 A 轮（取决于融资规模），到了 B 轮，如果公司状况良好，就是引入几位核心大牌人才的好时机。

---

### [01:02:06] Lenny

**English:**
And bring in meaning full-time in-house recruiters or a firm?

**中文翻译:**
你说的“引入”是指全职的内部招聘人员还是猎头公司？

---

### [01:02:09] Lauren Ipsen

**English:**
Probably bring in a firm. Yeah. That would be my recommendation. I think you can bring in one or two recruiters in the early days like seed, if it makes sense for the company and they're growing quickly, but it's all kind of case to case.

**中文翻译:**
可能是找猎头公司。是的，那是我的建议。我认为在种子轮等早期阶段，如果公司发展迅速且有必要，可以招一两个内部招聘人员，但这都要视具体情况而定。

---

### [01:02:22] Lenny

**English:**
The fact that you're kind of off the table for most founders now that you're at GC, which is a part ... And is that true? Like you basically at this point work for General Catalyst founders, is that correct?

**中文翻译:**
既然你现在在 GC，大多数创始人可能就没法直接找你合作了……这是真的吗？也就是说，你目前基本上只为 General Catalyst 投资的创始人服务，对吗？

---

### [01:02:32] Lauren Ipsen

**English:**
I am supporting all of our GC founders in the consumer and crypto portfolio. That being said, I spend all day every single day networking and chatting with amazing entrepreneurs, people that could be founding a company down the road and need some advice, great people that want to help in an advising capacity. So it is, I would say, 50% networking, 50% actual parachuting into portfolio.

**中文翻译:**
我确实在支持我们 GC 消费和加密货币投资组合中的所有创始人。话虽如此，我每天都在与优秀的创业者建立联系和交流，包括那些未来可能创业并需要建议的人，以及那些愿意提供顾问帮助的优秀人才。所以我会说，我的工作 50% 是建立人脉，50% 是实际“空降”（parachuting）到投资组合公司中提供支持。

---

### [01:03:00] Lenny

**English:**
Got it. Okay.

**中文翻译:**
明白了。

---

### [01:03:01] Lauren Ipsen

**English:**
Supporting them.

**中文翻译:**
支持他们。

---

### [01:03:01] Lenny

**English:**
That's cool. I didn't know that part.

**中文翻译:**
太酷了，我以前不知道这一部分。

---

### [01:03:03] Lauren Ipsen

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:03:03] Lenny

**English:**
So outside of that, what do you suggest founders look for when they're looking for a recruiter, and the second to last question, what are signs that this is a good firm, a good recruiter? Just what should you be looking for when you're looking to hire a recruiter, either in house or a firm?

**中文翻译:**
那么除此之外，你建议创始人在寻找招聘人员时应该看重什么？倒数第二个问题：什么是好的猎头公司或好的招聘人员的标志？当你打算雇佣一名招聘人员（无论是内部还是外部公司）时，你应该寻找什么？

---

### [01:03:15] Lauren Ipsen

**English:**
I think it's important to provide them with some direction and then see if they can recite it back to you. Tell them the types of things you're looking for and then say, "Did that resonate? Because I'd love to hear from you what you took away from that and what you think we should be looking for."

**中文翻译:**
我认为很重要的一点是，给他们一些方向，然后看他们能否向你复述出来。告诉他们你正在寻找的人才类型，然后问：“这引起你的共鸣了吗？我很想听听你从中领会到了什么，以及你认为我们应该寻找什么样的人。”

---

### [01:03:32] Lauren Ipsen

**English:**
And then kind of off the bat, ask them for a couple candidate ideas. Don't give them time to just go call other people. In real time, ask them for some candidate ideas. Where does their brain go? Who are people they would call tomorrow on this? The more that you can get that dynamic relationship formed before you even go to search, the more you can determine whether this is someone you want to calibrate with.

**中文翻译:**
然后，立刻请他们提供几个候选人的思路。不要给他们时间去给别人打电话。当场问他们一些候选人的想法。他们的脑子是怎么转的？针对这个职位，他们明天会给谁打电话？在正式开始搜寻之前，你越能建立起这种动态的互动关系，你就越能判断这是否是你想要一起“校准”（calibrate）的人。

---

### [01:03:54] Lauren Ipsen

**English:**
So yeah, I think just putting them on the spot a little bit and asking them to show their work rather than just sending over a deck of searches that could have been done by other partners or could have just been done by other people on their team. You want to actually understand who this person is. So that first question is testing their listening skills and their ability to actually hear what you're saying and what you're looking for, and then the second is, okay, now how quickly can we get calibrated on what this profile should look like.

**中文翻译:**
所以，是的，我认为要让他们当场表现一下，让他们展示自己的真本事，而不是只发给你一份可能由其他合伙人或团队成员完成的搜寻案例 PPT。你想真正了解这个人是谁。第一个问题是测试他们的倾听技巧，以及他们是否真的听懂了你的需求；第二个问题是看你们能多快就人才画像达成共识。

---

### [01:04:21] Lenny

**English:**
Awesome. That is great advice. Very tactical. Any final words or wisdom before we get to our very exciting lightning round?

**中文翻译:**
太棒了。这是非常实操的建议。在进入激动人心的闪电问答环节之前，还有什么最后的寄语或智慧分享吗？

---

### [01:04:26] Lauren Ipsen

**English:**
This has been awesome, by the way. I think more generally, the advice is just treat people like human beings, build rapport, play the long game, and gain trust, and that takes time. And so those are the most important things from a recruiting standpoint, is being able to tap people and have them feel like you genuinely have their best interest at heart and that you care about their career and life outside their career. And so I think that's what makes for a really good recruiter.

**中文翻译:**
顺便说一下，这次交流太棒了。总的来说，我的建议是：把人当人看，建立默契，玩长线游戏，赢得信任，而这需要时间。从招聘的角度来看，最重要的事情是能够触达人才，并让他们觉得你真心在为他们的利益着想，关心他们的职业生涯以及职业之外的生活。我认为这就是成就一名优秀招聘人员的关键。

---

### [01:04:53] Lenny

**English:**
Simple advice, but often forgotten and easy to overlook. Awesome. All right. We've reached our very exciting lightning round. I'm going to give you six questions, whatever comes to mind, we'll go through them real fast. Does that sound good?

**中文翻译:**
简单的建议，但经常被遗忘且容易被忽视。太棒了。好了，我们进入了非常激动人心的闪电问答环节。我会问你六个问题，想到什么就说什么，我们快速过一遍。可以吗？

---

### [01:05:08] Lauren Ipsen

**English:**
Okay. Yes. Let's do it.

**中文翻译:**
好的，没问题，开始吧。

---

### [01:05:10] Lenny

**English:**
Let's do it. What are two or three books that you recommend most to other people?

**中文翻译:**
开始。你最推荐给别人的两三本书是什么？

---

### [01:05:14] Lauren Ipsen

**English:**
The Power of Now and You Are Here.

**中文翻译:**
《当下的力量》（The Power of Now）和《你在这里》（You Are Here）。

---

### [01:05:17] Lenny

**English:**
Wow. Awesome. What are favorite other podcasts that you listen to other than this one?

**中文翻译:**
哇，太棒了。除了这个播客，你还喜欢听哪些播客？

---

### [01:05:22] Lauren Ipsen

**English:**
I mean, there's tech ones, but Your Own Backyard because I went to Cal Poly, so that one hits a little close to home.

**中文翻译:**
有一些科技类的，但我喜欢《Your Own Backyard》，因为我上的是加州州立理工大学（Cal Poly），所以那个节目让我很有共鸣。

---

### [01:05:28] Lenny

**English:**
Wow, I haven't heard of that. Cool. What's a recent movie or TV show that you've watched that you've enjoyed?

**中文翻译:**
哇，我没听说过那个。酷。最近你看过并喜欢的电影或电视节目是什么？

---

### [01:05:34] Lauren Ipsen

**English:**
Top Gun I've watched too many times and-

**翻译:**
《壮志凌云》（Top Gun）我看了太多遍了，还有……

---

### [01:05:39] Lenny

**English:**
The new Top Gun.

**中文翻译:**
是新的那部《壮志凌云》吗？

---

### [01:05:39] Lauren Ipsen

**English:**
Yeah. And then TV show. Oh, it's all trash reality, so I just can't tell you.

**中文翻译:**
是的。至于电视节目，噢，全是些没营养的真人秀，所以我没法告诉你（笑）。

---

### [01:05:45] Lenny

**English:**
I get that. I understand. My wife has that and she can't tell anyone. Yeah.

**中文翻译:**
我懂，我理解。我妻子也看那些，她也不敢告诉别人。

---

### [01:05:51] Lauren Ipsen

**English:**
That's my one secret.

**中文翻译:**
那是我的一个小秘密。

---

### [01:05:51] Lenny

**English:**
All right. Okay, great. We'll move on, but that's great. What's a favorite ... Oh, this is interesting. What's a favorite interview question that you like to ask or maybe you've seen someone ask?

**中文翻译:**
好的，没问题。我们继续。你最喜欢的面试问题是什么？或者你见过别人问过的最棒的问题是什么？

---

### [01:06:01] Lauren Ipsen

**English:**
I love the good strengths and weaknesses question. I think it's really good to see how people self-analyze themselves.

**中文翻译:**
我喜欢经典的优缺点问题。我认为这能很好地观察人们如何进行自我分析。

---

### [01:06:06] Lenny

**English:**
What do you look for in their answer that's the sign that it's well answered?

**中文翻译:**
你会在他们的回答中寻找什么，来判断这是一个好的回答？

---

### [01:06:10] Lauren Ipsen

**English:**
Honesty, authenticity. Can read right through a, "Work too hard," answer or a perfectionist type answer. What are your weaknesses? Let's talk about it.

**中文翻译:**
诚实和真实。我能一眼看穿那种“工作太努力”或“完美主义者”之类的回答。你的弱点是什么？让我们开诚布公地聊聊。

---

### [01:06:19] Lenny

**English:**
For real.

**中文翻译:**
说真的。

---

### [01:06:21] Lauren Ipsen

**English:**
So that one I think is always a really good test of character.

**中文翻译:**
所以我认为那始终是对性格的一个很好的测试。

---

### [01:06:24] Lenny

**English:**
What are some favorite apps right now?

**中文翻译:**
你现在最喜欢的应用有哪些？

---

### [01:06:27] Lauren Ipsen

**English:**
I've been playing around on BeReal. I mean, I love Spotify, it's straightforward. And then I've been on Strava, I've been running, so that are the-

**中文翻译:**
我最近在玩 BeReal。我很喜欢 Spotify，它很简洁。还有 Strava，我一直在跑步，所以这些是……

---

### [01:06:34] Lenny

**English:**
That's a good combination of apps. That's like a full life.

**中文翻译:**
这是一个很好的应用组合。听起来生活很充实。

---

### [01:06:37] Lauren Ipsen

**English:**
Thank you. Thanks so much. Trying to be.

**中文翻译:**
谢谢，非常感谢。努力让生活充实。

---

### [01:06:41] Lenny

**English:**
Final question. Who else in the industry would you say that you most respect as a leader and a thought leader influence type person?

**中文翻译:**
最后一个问题。在业内，你最尊敬的领导者或思想领袖（thought leader）是谁？

---

### [01:06:49] Lauren Ipsen

**English:**
My first boss out of college, Joe Suliman, is awesome. He's always taught me to lead with that relationship-based approach and it's really so easy to say that you do that, but then to actually do it and live it out for the people that work for you, as well as the people that are in industry and speak of you, is something else. And so he's always taught me to do that, and I just learned a ton from him and he's just incredibly smart and in tune with what's happening in industry and makes great stances and opinions on how to navigate those types of things. So, he's someone that I have an immense amount of respect for.

**中文翻译:**
我大学毕业后的第一任老板 Joe Suliman 非常棒。他总是教导我要以“建立关系”为导向来领导。口头上说很容易，但要真正做到，并为你的下属以及业内评价你的人身体力行，那是另一回事。他一直教我这样做，我从他身上学到了很多。他极其聪明，对行业动态了如指掌，并且在如何处理各种问题上总能给出精辟的见解。他是我非常尊敬的人。

---

### [01:07:24] Lenny

**English:**
Sounds like an amazing person. Lauren, this was excellent. I feel like this is going to be useful to so many people, product managers, founders, other recruiters, all kinds of other people. Thank you so much for doing this and making the time. Two final questions. Where can folks find you online if they want to reach out or maybe collaborate with you and learn more? And how can listeners be useful to you?

**中文翻译:**
听起来是个了不起的人。Lauren，这次交流太精彩了。我觉得这对很多人都会有用，包括产品经理、创始人、其他招聘人员等等。非常感谢你抽出时间参加节目。最后两个问题：如果大家想联系你、合作或了解更多信息，可以在哪里找到你？听众们能为你做些什么？

---

### [01:07:44] Lauren Ipsen

**English:**
Yes, absolutely. And also, thank you. This has been so much fun. They can reach out to me on LinkedIn. I happen to be on that one quite a bit, so definitely can DM me there, can send me an email, and I can shoot you that over as well. And then the way they can be helpful is if there's people that they think the world of, shoot them my way. If they have questions around best ways to go through an interview process or how to navigate different things, please, by all means, a huge part of my job is trying to help people that are going through this for the first time. Happy to just be a sounding board or of help in any capacity.

**中文翻译:**
好的。也要谢谢你，这次交流非常愉快。大家可以在 LinkedIn 上找到我，我经常在那上面。可以直接给我发私信，也可以给我发邮件。至于大家能帮到我的地方：如果你认识一些你非常欣赏的人，请把他们推荐给我。如果你对面试流程或职业规划有疑问，请随时联系我。我工作的很大一部分就是帮助那些第一次经历这些过程的人。我很乐意倾听并提供任何形式的帮助。

---

### [01:08:19] Lenny

**English:**
So if you're an awesome product leader, you want to see what's out there, find Lauren on LinkedIn. Is that the best place to find you?

**中文翻译:**
所以，如果你是一位优秀的产品领导者，想看看外面的机会，请在 LinkedIn 上找 Lauren。那是找你最好的地方吗？

---

### [01:08:24] Lauren Ipsen

**English:**
That's perfect.

**中文翻译:**
没错，那里最合适。

---

### [01:08:25] Lenny

**English:**
All right. Awesome.

**中文翻译:**
好的，太棒了。

---

### [01:08:25] Lauren Ipsen

**English:**
Yep.

**中文翻译:**
嗯。

---

### [01:08:25] Lenny

**English:**
Thanks, Lauren.

**中文翻译:**
谢谢，Lauren。

---

### [01:08:26] Lauren Ipsen

**English:**
Thanks so much. Appreciate it.

**中文翻译:**
非常感谢，很愉快。

---

### [01:08:29] Lenny

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review, as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
非常感谢大家的收听。如果你觉得本期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用上订阅。此外，请考虑给我们评分或留下评论，这能帮助其他听众发现这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。我们下期再见。