# Luc Levesque - 双语对照

This is the complete bilingual transcript of Lenny’s Podcast featuring Luc Levesque.

---

### [00:00:00] Luc Levesque

**English:**
We talk about the 10X engineer and we don't really talk about the 10X growth advisor or 10X growth person, but the same dynamic applies. You could argue it applies even more because the right growth advisor can have literally company changing impact. Something I've experienced several times in hindsight when you're like, "Okay, here's the needle in the haystack." And then it's implemented and you can see hundreds of percentages, sometimes over a thousand percent lift when you get it right. It's one of those weird disciplines where the right person at the right time can literally say a sentence that changes the trajectory of your company. You can't say that for a lot of different disciplines, but this is one of them.

**中文翻译:**
我们经常谈论 10 倍速工程师（10X engineer），但很少谈论 10 倍速增长顾问或 10 倍速增长人才，但同样的逻辑也适用。你甚至可以认为这更适用，因为一个合适的增长顾问真的能产生改变公司命运的影响力。这是我多次经历过的事情，事后回想起来你会觉得：“好吧，这就是大海里的那根针。”一旦方案落地，如果做对了，你会看到百分之几百、有时甚至超过 1000% 的提升。增长是一个奇特的学科，在正确的时间，正确的人说出的一句话，就可能彻底改变公司的发展轨迹。很多学科都做不到这一点，但增长绝对是其中之一。

---

### [00:00:36] Lenny

**English:**
Welcome to Lenny's Podcast, where I interview world-class product leaders and growth experts to learn from their hard-won experiences building and growing today's most successful products. Today my guest is Luc Levesque. Luc is currently the chief growth officer at Shopify. Before this, he was recruited personally by Mark Zuckerberg to help grow Facebook Messenger, Instagram and WhatsApp. He's also VP of Growth and a GM at Tripadvisor. He's also been a growth advisor to companies like Twitter, Pinterest, Patreon, Thumbtack, and Canva.

**中文翻译:**
欢迎来到 Lenny 的播客。在这里，我会采访世界级的产品领导者和增长专家，从他们构建和发展当今最成功产品的艰辛经验中学习。今天的嘉宾是 Luc Levesque。Luc 目前担任 Shopify 的首席增长官（CGO）。在此之前，他曾受马克·扎克伯格亲自招揽，负责推动 Facebook Messenger、Instagram 和 WhatsApp 的增长。他还曾担任 TripAdvisor 的增长副总裁兼总经理。此外，他还是 Twitter、Pinterest、Patreon、Thumbtack 和 Canva 等公司的增长顾问。

---

### [00:01:05] Lenny

**English:**
In our conversation, Luc shares advice on how and when to think about getting a growth advisor, including how to structure the relationship and what to look for in an advisor. We also spent a ton of time on SEO, how to think about this as a growth channel, who it's well suited for, and how everything is about to change in SEO with Bard and ChatGPT. Plus Luc shares a ton of really interesting advice around the value of self-reflection, building routines, cold plunges, also a couple of amazing stories about working with Zuck and what you learned from him. This is such an insight-rich episode and I know you'll love it. With that, I bring you Luc Levesque after a short word from our sponsors.

**中文翻译:**
在我们的对话中，Luc 分享了关于何时以及如何考虑聘请增长顾问的建议，包括如何构建合作关系以及在顾问身上寻找哪些特质。我们还花了大量时间讨论 SEO（搜索引擎优化），如何将其视为增长渠道，它适合什么样的公司，以及随着 Bard 和 ChatGPT 的出现，SEO 将发生怎样的巨变。此外，Luc 还分享了许多关于自我反思价值、建立日常习惯、冷水浴（cold plunges）的有趣建议，以及几个关于与扎克伯格共事及其收获的精彩故事。这一集充满了真知灼见，我相信你们会喜欢的。在听完赞助商的简短介绍后，让我们欢迎 Luc Levesque。

---

### [00:01:43] Lenny

**English:**
This episode is brought to you by Mixpanel. Get deep insights into what your users are doing at every stage of the funnel at a fair price that scales as you grow. Mixpanel gives you quick answers about your users from awareness to acquisition through retention. And by capturing website activity, ad data, and multi-touch attribution right in Mixpanel, you can improve every aspect of the full user funnel. Powered by first-party behavioral data instead of third-party cookies, Mixpanel is built to be more powerful and easier to use than Google Analytics. Explore plans for teams of every size and see what Mixpanel can do for you at mixpanel.com/friends/lenny. And while you're at it, they're also hiring. So check it out at mixpanel.com/friends/lenny.

**中文翻译:**
本集节目由 Mixpanel 赞助。Mixpanel 能以随业务增长而扩展的公平价格，为您提供用户在漏斗每个阶段行为的深度洞察。从认知、获取到留存，Mixpanel 都能快速回答关于用户的问题。通过在 Mixpanel 中直接捕获网站活动、广告数据和多触点归因，您可以优化整个用户漏斗的方方面面。Mixpanel 由第一方行为数据而非第三方 Cookie 驱动，比 Google Analytics 更强大且更易用。请访问 mixpanel.com/friends/lenny 探索适合各种规模团队的方案。顺便提一下，他们也在招聘，欢迎查看。

---

### [00:02:31] Lenny

**English:**
This episode is brought to you by Attio, a new type of CRM that's powerful, flexible, and built around your data. Traditional CRMs were built for a different era with totally different speed, scale, and data demands. Attio is different. It allows you to quickly build a CRM that matches your unique workflows and data structures. Within minutes of connecting your email and calendar, you'll have a CRM that's already set up complete with customer profiles and automatic data enrichment. You'll also have real-time dynamic reporting at your fingertips. No more slow deployments, outdated user experiences, or tedious manual data input. With Attio, you can build and adapt your CRM on the fly no matter your business model or company stage. Attio is the CRM for startups. Get started today and get 15% off your first year at attio.com/lenny. That's A-T-T-I-O.com/lenny.

**中文翻译:**
本集节目由 Attio 赞助。Attio 是一种新型 CRM，功能强大、灵活且围绕您的数据构建。传统的 CRM 是为另一个时代设计的，其速度、规模和数据需求完全不同。Attio 则不同，它允许您快速构建匹配独特工作流和数据结构的 CRM。连接电子邮件和日历后，几分钟内您就能拥有一个配置完善的 CRM，包含客户档案和自动数据增强功能。您还可以随时获取实时动态报告。不再有缓慢的部署、过时的用户体验或繁琐的手动数据录入。无论您的业务模式或公司阶段如何，Attio 都能让您随需构建和调整 CRM。Attio 是专为初创公司设计的 CRM。立即开始使用，并在 attio.com/lenny 享受首年 85 折优惠。

---

### [00:03:31] Lenny

**English:**
Luc, welcome to the podcast.

**中文翻译:**
Luc，欢迎来到播客。

---

### [00:03:34] Luc Levesque

**English:**
Thank you. Good to see you.

**中文翻译:**
谢谢，很高兴见到你。

---

### [00:03:36] Lenny

**English:**
It's good to see you too. I want to start with a story that you shared once when we were hanging out in the past and something that I'll never forget, and it's about the time that you just joined Facebook and apparently you had some kind of big presentation you had to give to the entire company or the executive staff. And then I just love the way it kind of unfolded and it kind of gives you a glimpse into what it's like to work with Zuck and at Facebook. Can you share that story if that rings a bell?

**中文翻译:**
见到你也很高兴。我想从你以前跟我聊天时分享的一个故事开始，那个故事让我终生难忘。那是关于你刚加入 Facebook 的时候，显然你当时要向全公司或高管团队做一个重大的演示。我非常喜欢那个故事的发展过程，它能让人窥见与扎克伯格共事以及在 Facebook 工作的真实样子。如果你还记得的话，能分享一下吗？

---

### [00:04:00] Luc Levesque

**English:**
If remember the story, well, basically I had just started at Facebook about... I'll use those two interchangeably. I remember it as Facebook and I always will. I was three months in and was working on a new area for me. So I came in, started putting together our thoughts on a strategy and was asked to do a presentation in front of the company with Mark on the strategy. So I whipped up a draft strategy, put together some plots and plans, presented in front of the company and went well. And then every six months there's something called the [inaudible 00:04:32] Team Review of Facebook and basically product area leads will go in and present their strategy, how it's going. Again, I just joined three months before, so I walk in no idea what to expect. I am sitting at a table. You can kind of envision it's a big room, a really big room with a bunch of tables set up in a big square with a little microphone.

**中文翻译:**
我记得那个故事。基本上，我当时刚加入 Facebook 大约……我会交替使用 Facebook 和 Meta 这两个词，但我永远记得它是 Facebook。当时我刚入职三个月，负责一个对我来说全新的领域。我进来后开始构思战略，并被要求和马克一起向全公司演示这个战略。于是我草拟了一份战略初稿，制定了一些方案和计划，在公司面前做了演示，效果还不错。Facebook 每六个月会有一次所谓的团队评估（Team Review），基本上各产品领域的负责人都要进去汇报战略和进展。再次强调，我当时才来三个月，走进去时完全不知道会发生什么。我坐在一张桌子旁，你可以想象那是一个非常大的房间，很多桌子围成一个大方阵，配有一个小麦克风。

---

### [00:04:50] Luc Levesque

**English:**
So I sit in there, there's Mark and all the executives sitting on the other side. And I sit down and it's quiet for what felt like five minutes. I'm sure it was not, but it was quiet for a while, just sitting there waiting for what's going to happen now. And at some point Mark kind looks over, says, "Hey, we saw your presentation, saw your strategy. Now when are we going to start seeing results?" And that was my introduction to Facebook. It was kind of my introduction to working with Mark and was a pretty kind of intense thing to go through. Again, I just joined. The strategy was very much a draft at that point, but I think what it highlights is something that Facebook does really, really well, which you get very quickly when you join Facebook and it's why they're such an execution machine and can build a lot of great product. It's because they focus exclusively on that magic word, which is impact.

**中文翻译:**
我坐在那里，马克和所有高管坐在另一边。我坐下后，全场陷入了死寂，感觉持续了五分钟。肯定没那么久，但确实安静了好一会儿，我就坐在那等着接下来会发生什么。突然，马克看了过来，说：“嘿，我们看了你的演示，看了你的战略。那么，我们什么时候能开始看到结果？”这就是我进入 Facebook 的“洗礼”。这也是我与马克共事的开端，那是一段相当紧张的经历。毕竟我才刚来，战略在当时还只是草稿。但我认为这凸显了 Facebook 做得非常好的一点，你加入后很快就能体会到，这也是为什么他们是如此强大的执行机器、能做出这么多伟大产品的原因：因为他们只关注一个神奇的词——影响力（Impact）。

---

### [00:05:44] Luc Levesque

**English:**
And that was kind of my first introduction to working with Mark and just that laser focus on, "All right, got it. Now when are we going to start seeing impact and kind of moving from there?" So it's something that is very much in the culture there and something that is so important. It's something of course that we focus on a lot at Shopify, but it's that difference between, "I don't care how hard you've worked. I don't care what you're working on, what the activities are. What are the outcomes? What is the impact you're having?" I actually really love that word impact and focusing on it because it's vague enough that it covers off any work that is impactful towards the mission and it's precise enough to know what does that mean when you say, "Are you having impact? Or what is the impact we're having?" So it's a great way to approach things. That was my first experience there within a few months. And yeah, we jumped in and started focusing on having a lot of impact from there.

**中文翻译:**
那是我第一次与马克共事，那种激光般的专注力：“好，明白了。现在，我们什么时候能看到影响力，并以此为基础继续推进？”这种文化在 Facebook 根深蒂固，非常重要。当然，我们在 Shopify 也非常关注这一点。它的核心区别在于：“我不在乎你工作有多努力，不在乎你在做什么，也不在乎具体活动是什么。结果是什么？你产生了什么影响力？”我非常喜欢“影响力”这个词，并专注于它，因为它足够宽泛，可以涵盖任何对使命有贡献的工作；同时它又足够精确，能让你明白“你是否有影响力”或“我们正在产生什么影响”的含义。这是一种极佳的处理方式。那是我入职几个月后的第一次经历。从那以后，我们就全身心投入，开始专注于创造巨大的影响力。

---

### [00:06:36] Lenny

**English:**
I love that story. There's a couple things there. One is, if I were in your shoes, I'd poop my pants sitting there for five minutes waiting for what do you guys-

**中文翻译:**
我太喜欢这个故事了。有几点感触：第一，如果我是你，坐在那里等五分钟看你们要干嘛，我可能会吓尿了——

---

### [00:06:45] Luc Levesque

**English:**
That did not happen. I had a report.

**中文翻译:**
那倒没有发生，我当时有一份报告要汇报。

---

### [00:06:47] Lenny

**English:**
Okay. How did it go? How did you deal with it? Or I guess how did you respond?

**中文翻译:**
好吧。进展如何？你是怎么处理的？或者说，你是怎么回应的？

---

### [00:06:51] Luc Levesque

**English:**
Well, we had, funny enough, already started having impact, so I was able to at least respond with, "Hey, we've kind of already started in a few ways" and walk through where we were having impact and just focus on the strategy, what our plans forward were and where we wanted to go from there. So I think that's how I responded.

**中文翻译:**
有趣的是，我们当时其实已经开始产生影响力了。所以我至少能回应说：“嘿，我们已经在几个方面开始了，”然后详细说明了我们在哪里产生了影响，并专注于战略、未来的计划以及我们想去的目标。我想这就是我当时的回应方式。

---

### [00:07:08] Lenny

**English:**
Okay, great work. So something I've started doing actually on this podcast is I've started to keep a little Post-it of, here it is, of themes that continue to recur across companies that are most successful. And impact comes... It's number one on my Post-it here, is just impact comes up so often as something that the best companies continue to come back to and focus on and put a lot of emphasis on. I guess I don't know what the question is exactly, but is that just what you find in the work that you do with all the companies you work with? Just how important it's to come back to impact as maybe the primary thing?

**中文翻译:**
干得漂亮。其实在这个播客中，我开始做一件事，就是记一张便利贴——就在这——记录那些在最成功的公司中不断出现的共同主题。而“影响力”排在第一位。它出现的频率太高了，最好的公司总是会回到这个点上，专注于此并给予极大的重视。我不知道具体该怎么问，但这是否也是你在与所有这些公司合作的过程中发现的？回归“影响力”作为首要任务到底有多重要？

---

### [00:07:42] Luc Levesque

**English:**
Yeah, I mean I think it's easy for a lot of leaders and companies to get caught up in how hard are people working, what did they do, and recognizing and rewarding activity. I mean, everybody wants to have impact. The companies that truly focus on that are the ones that break through and really make a lot of progress towards the mission. So that seems obvious I think when I say it out loud, but being in that culture and having it really ingrained in everything you do whether it's performance reviews or strategies or these reviews with the executive team, it all gravitates around impact. And I think it's that laser focus on it that matters so much. But I mean I've certainly seen it going other ways where it's more about working long hours. And certainly there's a correlation, to be clear, between working hard and impact, but I find it's just such a precise way to think about how people are performing or what you're doing in terms of is your strategy working? Is the direction you're moving in having the intended outcomes that you want? And yeah, I do think it's all about that.

**中文翻译:**
是的。我觉得很多领导者和公司很容易陷入“员工工作有多努力”、“他们做了什么”这些表象，并去认可和奖励这些“活动”。其实每个人都想产生影响力，但只有那些真正专注于此的公司才能实现突破，并在使命上取得巨大进展。这听起来显而易见，但身处那种文化中，让它深深扎根于你所做的每一件事——无论是绩效评估、战略制定，还是与高管团队的评审——一切都围绕着影响力展开。我认为这种激光般的专注至关重要。我也见过其他情况，比如更看重加班时长。当然，努力工作和影响力之间肯定有相关性，但我发现“影响力”是一种非常精确的衡量方式，可以思考员工的表现，或者你的战略是否奏效：你前进的方向是否产生了你预期的结果？是的，我认为核心就在于此。

---

### [00:08:46] Luc Levesque

**English:**
Being a growth leader where everything's so measurable, impact is something that can be very clearly measured and you know whether you have it or not. So the most important thing that we work on constantly is reviewing what's our strategy, what are we working on? Is that driving towards the top level north star outcome we want? Is that having the impact? And then basically doing everything around that singular north star. So it's very, very important. I think it's more profound than it might seem just from the outside. But if you've worked in different companies, you've probably experienced different versions of this too.

**中文翻译:**
作为一名增长领导者，一切都是可衡量的，影响力是可以被非常清晰地量化的，你有还是没有，一目了然。所以我们不断做的最重要的事情就是审视：我们的战略是什么？我们在做什么？这是否在朝着我们想要的最高层级“北极星”结果迈进？是否产生了影响力？然后基本上围绕那个唯一的北极星去做所有事情。这非常非常重要。我认为它比从外面看起来要深刻得多。如果你在不同的公司工作过，你可能也经历过这个理念的不同版本。

---

### [00:09:20] Lenny

**English:**
Yeah. I want to spend more time on this, but before we move on, you also have another Zuck story. Correct me if I'm wrong, but Zuck recruited you personally to join Facebook/Meta. Is that true? And then if true, what was that like to be recruited by Zuck personally?

**中文翻译:**
是的。我想在这上面多花点时间，但在继续之前，你还有另一个关于扎克伯格的故事。如果我没记错的话，是扎克伯格亲自招募你加入 Facebook/Meta 的，对吗？如果是真的，被扎克伯格亲自招募是什么感觉？

---

### [00:09:35] Luc Levesque

**English:**
It was an interesting experience, very intense, but also one of the reasons for it was I was living in Canada and my family was there and I had some strong personal reasons why I couldn't leave Canada. But yeah, we had a lot of discussions with Mark. I won't get into the micro details of it, that's more Mark's story to tell than mine. But a few takeaways from going through that experience. As a leader, hiring is the most important thing as we all know. It's a craft and a skill that I'm always working on refining. I have my own playbook that I'm constantly tweaking, testing out different approaches, trying to find the best talent and assessing them and trying to close them and bringing them on board. So I learned a lot through that experience with Mark.

**中文翻译:**
那是一段有趣的经历，非常紧凑。其中一个原因是当时我住在加拿大，家人也在那里，我有很强的个人理由不能离开加拿大。但确实，我和马克进行了很多讨论。我不会透露微观细节，那是马克的视角，不是我的。但从那次经历中我有几点收获。作为领导者，招聘是最重要的事情，这大家都知道。这是一门手艺，也是一种技能，我一直在精进它。我有自己的“剧本”，不断调整、测试不同的方法，试图找到最优秀的人才，评估他们，并努力说服他们入职。通过与马克的接触，我学到了很多。

---

### [00:10:15] Luc Levesque

**English:**
A couple things that stood out were the first one would be that Mark really involved the entire executive team. It wasn't just me talking to recruiting or talent or HR or just Mark, it was the entire executive team. That's something that I think a lot of leaders don't take advantage of. I've seen leaders, I've certainly done this at times where you go it alone or you're working with recruiting, but the reality is all the leaders, all the execs in the company know how important it's to bring in talent and they're always more than happy to help. So that's something that I think more leaders should do is really recruit all of their peers and their leaders in the company to help close. And that's certainly something that happened when I was in discussions with Mark and Facebook about joining.

**中文翻译:**
有几件事让我印象深刻。第一点是，马克真的动员了整个高管团队。不仅仅是我在和招聘人员、HR 或者马克本人谈，而是整个高管团队都参与了进来。我觉得很多领导者都没有充分利用这一点。我见过有些领导者——我自己有时也这样——喜欢单打独斗或者只和招聘部门合作。但现实是，公司里所有的领导者和高管都知道引进人才有多重要，他们总是非常乐意帮忙。所以我觉得更多领导者应该做的是：动员公司里所有的同僚和上级来协助“成交”（close）候选人。当我与马克和 Facebook 讨论加入事宜时，情况确实如此。

---

### [00:10:55] Luc Levesque

**English:**
The second one, which I had I suppose never experienced before, was that they made it very personal. I had these reasons why I couldn't leave. So initially I was excited by the opportunity, but I couldn't see myself moving to California for personal reasons. And through discussions, Mark basically involved my wife, involved my spouse in this, Andrea. We flew down, had dinner with him and Priscilla, his wife. Andrea had ended up meeting with many of the executives at Facebook and really talking through what was holding us back, why we couldn't come, potential options and ideas for how we could come down.

**中文翻译:**
第二点是我以前从未经历过的，那就是他们把这件事变得非常“私人化”。我有不能离开的理由，所以最初虽然对机会感到兴奋，但出于个人原因，我没法想象自己搬到加州。在讨论过程中，马克基本上把我的妻子 Andrea 也拉了进来。我们飞过去，和他以及他的妻子 Priscilla 一起吃了晚饭。Andrea 最终见到了 Facebook 的许多高管，深入探讨了阻碍我们的原因、为什么我们不能来，以及我们可以搬过去的潜在方案和想法。

---

### [00:11:33] Luc Levesque

**English:**
But involving somebody's spouse and family I think is a really good idea because it's a very personal decision to change company. It involves more than just that person you're talking to, it involves the whole family. So that was something that I think is an important thing to have in your kind of playbook for hiring, is really think about the whole person's family and involve them if you can. In fact, Toby did this as well at Shopify. He flew down here with Fiona and we had breakfast with Andrea and them and reviewed a few offers when I joined Shopify.

**中文翻译:**
我认为让候选人的配偶和家人参与进来是一个非常棒的主意，因为换公司是一个非常私人的决定。它涉及的不只是你正在交谈的那个人，而是整个家庭。所以我觉得这是招聘“剧本”中很重要的一环：真正考虑候选人的整个家庭，如果可以的话，让他们也参与进来。事实上，Shopify 的 Tobi（首席执行官）也这么做了。当我准备加入 Shopify 时，他带着 Fiona 飞到这里，和 Andrea 以及我一起吃早餐，并讨论了几份邀约。

---

### [00:12:03] Luc Levesque

**English:**
And then the third thing is just to be absolutely relentless and don't give up and don't let momentum drop. It took seven months for me to go from, "This is amazing, exciting, but there's no way I can make this work" to, "Okay, let's move to Palo Alto." And Mark, the execs, a variety of leaders there were in discussions for months and months and months and never letting the momentum die. That's something that I think is really important. No doesn't necessarily mean no, and in this case it definitely wasn't the case. I had the same experience with Toby at Shopify where we've been talking about working together for over 10 years now. And then finally the timing was right and I was able to join the company.

**中文翻译:**
第三点就是绝对的“坚持不懈”（relentless），永不放弃，不让势头减弱。我花了七个月的时间才从“这很棒、很令人兴奋，但我绝对没法去”转变为“好吧，我们搬去帕罗奥图吧”。马克、高管们以及那里的各种领导者进行了长达数月的讨论，从未让这种势头熄灭。我认为这非常重要。“不”并不一定意味着拒绝，在这种情况下绝对不是。我在 Shopify 的 Tobi 身上也有同样的经历，我们讨论合作已经超过 10 年了，最终时机成熟，我才加入了公司。

---

### [00:12:45] Luc Levesque

**English:**
So just be relentless, involve the family, involve the spouse if you can, and recruit some help from other executives in the company. Those were some of the things that stood out through my experience. But yeah, it was a pretty wild time in my life.

**中文翻译:**
所以，就是要坚持不懈，让家人参与进来，如果可以的话让配偶也参与，并寻求公司其他高管的帮助。这些是我经历中比较突出的几点。不过说真的，那是我人生中一段相当疯狂的时光。

---

### [00:13:00] Lenny

**English:**
Relentless is actually another word. I wasn't necessarily I'm supposed to yet, but I feel like it's another trend to cross. The most impactful and successful founders is just this like, "I will not give up. I will keep at it."

**中文翻译:**
“坚持不懈”确实是另一个关键词。我还没正式总结，但我感觉这是最成功、最有影响力的创始人身上的另一个共同趋势：就是那种“我绝不放弃，我会一直坚持下去”的劲头。

---

### [00:13:09] Luc Levesque

**English:**
[inaudible 00:13:10].

**中文翻译:**
（听不清）。

---

### [00:13:10] Lenny

**English:**
And so that's a really interesting example of that in action. I was going to talk about this later, but maybe it's a good time to talk about it now, which is around hiring. So you talked about you have this playbook for how to hire. You mentioned to me that you kind of find that as you scale as a leader, hiring ends up being like the most important skill maybe, maybe one of the most important skills. I'd love to hear your take on just what you found about hiring as you've grown as a product leader.

**中文翻译:**
所以这是一个非常有趣的实际案例。我本来打算稍后再谈这个，但现在也许是谈论招聘的好时机。你提到你有招聘的“剧本”。你曾跟我说过，随着你作为领导者的规模扩大，招聘最终会成为最重要、或者说最重要的技能之一。我很想听听你作为产品领导者在成长过程中对招聘的看法。

---

### [00:13:33] Luc Levesque

**English:**
Well, I think you reach a point in your career where you realize that hiring is the skill you now need to become world-class at because you're not no longer doing the work yourself. You're still of course involved and doing some of the work and getting your hands dirty, but the bulk of your team's success now will be the quality of the hires you make and you truly need to be world-class at that. So yeah, I built this playbook out. I was in Canada in Ottawa when I sold that company, Tripadvisor, and really started growing my team and becoming more Leaning into leadership at the time through that experience.

**中文翻译:**
当你职业生涯达到一定阶段时，你会意识到招聘是你现在需要达到世界级水平的技能，因为你不再亲自去做具体工作了。当然，你仍然会参与其中，做一些工作，亲力亲为，但你团队的大部分成功现在将取决于你招聘的人才质量，你真的需要在这方面做到世界一流。所以我建立了这套剧本。当我把公司卖给 TripAdvisor 时，我还在加拿大的渥太华，从那时起我开始扩大团队，并更多地投入到领导工作中。

---

### [00:14:07] Luc Levesque

**English:**
One of the benefits of being in Ottawa and kind of off the grid if you will, is it's a curse and a benefit as that you don't have a ton of people you can learn from. So it does mean you need to go to first principles and think things through from the ground up. It takes a little longer, but you come up with your own playbooks on how to do things. I think you've seen my blueprint, which is a good example of that where I have this blueprint I put together. When new people join the team, I show them my blueprint, which is basically a list of my quirks so we can really quickly align. That's something that just being in Ottawa and trying to figure out how to be a leader and avoid mistakes, I was like, "Wouldn't it be nice if you had a blueprint? When somebody joined, you can just tell them all of your quirks and you can just quickly calibrate on how it is to work together versus through awkward long discussions over the course of a year."

**中文翻译:**
在渥太华这种有点“与世隔绝”的地方工作，既是诅咒也是福利。坏处是你没有太多可以学习的对象，但好处是这意味着你必须回归第一性原理，从零开始思考。虽然花的时间长一点，但你会形成自己的一套做事方法。我想你见过我的“蓝图”（blueprint），那是一个很好的例子。当新人加入团队时，我会给他们看我的蓝图，基本上就是我个人怪癖的清单，这样我们可以快速达成共识。在渥太华摸索如何当领导并避免犯错时，我想：“如果有一份蓝图不是很好吗？有人加入时，你直接告诉他们你所有的怪癖，大家就能快速磨合，而不是通过长达一年的尴尬讨论来了解彼此。”

---

### [00:14:51] Luc Levesque

**English:**
My hiring playbook's a similar thing. I think of it in three different chapters, if you will. There's finding talent, assessing talent, and closing talent. In terms of finding talent, I do believe that the best predictor of future performance is past performance. So I'm looking for what I call signs of excellence. So I want to know the top people generally have done multiple amazing things in their life, repeated success, not just once. Maybe it was work related, maybe not work related. But generally speaking, if you think back to the stars you've worked with, they've done some amazing things. And that's why I always start when I interview or when I chat with people, I started talking about just trying to understand, "What has been your path? What have you done professionally and not professionally?" And generally, stars going to stand out. It's very rare that there's not something obvious that comes through.

**中文翻译:**
我的招聘剧本也类似。我把它分为三个章节：寻找人才、评估人才和说服人才。在寻找人才方面，我坚信预测未来表现的最佳指标是过去的表现。所以我寻找的是我所谓的“卓越迹象”（signs of excellence）。我想知道顶尖人才通常在生活中做过多次了不起的事情，是重复的成功，而不仅仅是一次。也许与工作有关，也许无关。但一般来说，回想一下你合作过的明星员工，他们都做过一些惊人的事情。这就是为什么我在面试或聊天时，总是先试图了解：“你的成长路径是怎样的？你在职业和非职业领域都做过什么？”通常，明星人才会脱颖而出，很少有不显露明显特质的情况。

---

### [00:15:39] Luc Levesque

**English:**
So for myself personally, I'm looking for kind of three different signs of excellence to tell me that it doesn't have to be three. The mental model I have is as you're talking to them, you're getting pluses and negatives. There's red flags you're hearing and there's really great things. And then at the end you can make an opinion of how good this person is.

**中文翻译:**
对我个人而言，我寻找的是大约三种不同的卓越迹象，不一定非得是三个。我的心智模型是：当你与他们交谈时，你会得到加分项和减分项。你会听到危险信号，也会听到非常棒的事情。最后，你就能对这个人的优秀程度做出判断。

---

### [00:15:56] Luc Levesque

**English:**
Another great sign of excellence, and this was just through reflecting on stars on the team and thinking what makes them unique, what about them. One of them is when somebody's boss leaves the company and then comes back to poach them, that is such a strong signal because if you think of what just happened, the leader who knows exactly how good this person you're talking to is, they have the most knowledge of the performance of this individual, they left the company. They've come back to poach them, putting their own reputation at risk by coming back depending on the situation. And they would never do that unless this person was really, really good.

**中文翻译:**
另一个极佳的卓越迹象——这是通过反思团队中的明星员工并思考他们的独特之处得出的——就是当某人的老板离开公司后，又回来挖走他们。这是一个非常强烈的信号。想想发生了什么：那个最了解你正在交谈的这个候选人有多优秀、掌握其绩效信息最全面的领导者离开了公司，然后又回来挖人，甚至在某些情况下冒着自己的声誉风险回来。除非这个人真的非常非常优秀，否则他们绝不会这么做。

---

### [00:16:37] Luc Levesque

**English:**
So you don't want to over pivot on one signal, you want to look at the full picture. But those are the types of things I look at to bring in top talent. And I've got this whole playbook, mistakes I've made that I've learned from, things to avoid. And over the years, yeah, I've put together this playbook that I try to follow and I'm always running little experiments to try to make it better.

**中文翻译:**
当然，你不想过度依赖单一信号，你想看全貌。但这些就是我引进顶尖人才时关注的事情。我有一整套剧本，包括我犯过的错、学到的教训、需要避免的事情。多年来，我整理出了这套我努力遵循的剧本，并且一直在做小实验来完善它。

---

### [00:16:56] Lenny

**English:**
Were going to that blueprint that you mentioned. A lot of which you're talking about is probably more relevant to senior executive type people because you're looking for... Or maybe not because you're looking for say three.

**中文翻译:**
关于你提到的那个蓝图，你谈到的很多内容可能更适合高级管理人员，因为你在寻找……或者也许不是，因为你在寻找比如三个（卓越迹象）。

---

### [00:17:06] Luc Levesque

**English:**
[inaudible 00:17:06].

**中文翻译:**
（听不清）。

---

### [00:17:06] Lenny

**English:**
Okay. So people early in their career could also have three, say, moments of excellence?

**中文翻译:**
好吧。那么职业生涯早期的人也可能有三个，比如说，卓越时刻吗？

---

### [00:17:12] Luc Levesque

**English:**
Yeah, I mean just thinking off the top, it depends on the type of person you're hiring, but are they a founder? Have they tried to do something? Did they win an award somewhere? Are they a gold medalist at something? Have they done something that others have not that shows grit, that shows drive, that shows the ability to succeed? And I've seen that you can apply that to any candidate you're hiring.

**中文翻译:**
是的，我想想，这取决于你招聘的人才类型。但他们是创始人吗？他们尝试过做某事吗？他们在哪里得过奖吗？他们在某方面是金牌得主吗？他们是否做过别人没做过的事情，展现了毅力、驱动力和成功的潜力？我发现你可以把这一点应用到你招聘的任何候选人身上。

---

### [00:17:36] Lenny

**English:**
The implication there is, without that, they're probably not going to be stars, that there's a strong correlation between having signs of excellence and them performing really well in this role.

**中文翻译:**
这里的含义是，如果没有这些，他们可能不会成为明星员工；拥有卓越迹象与他们在这个职位上表现出色之间存在强相关性。

---

### [00:17:45] Luc Levesque

**English:**
Correct, exactly. Yeah, I mean I suppose it's possible, but it would be pretty rare that somebody would come in without some sign that they stand above the crowd. And again, I'm talking about you generally want to hire the top 1% of candidates. So when you're looking for the best of the best, you definitely are looking for those signals.

**中文翻译:**
没错，正是如此。虽然也有可能，但如果一个人没有任何脱颖而出的迹象就进来了，那是非常罕见的。再说一次，我谈论的是你通常想雇佣前 1% 的候选人。所以当你寻找出类拔萃的人才时，你肯定在寻找那些信号。

---

### [00:18:01] Lenny

**English:**
Awesome. Okay, so I'm going to bring us back on the agenda that I had for myself, which is I want to start with talking about advisorships and advising and growth advisors. You've been a growth advisor for a long time to some of the most amazing companies out there, Twitter, Pinterest, Patreon, Canva, Thumbtack. I'm sure there's others that you don't list that are more informal. Now you work at Shopify. And so what I think about here is a lot of founders often think about, "Should I bring on an advisor? What should I look for an advisor? I've heard stories of advisors being useless sometimes. People tell me I don't need advisors." So I guess the question here is just what's your take on when it makes sense to bring on and consider bringing on a growth advisor and what should people look for when they're exploring and talking to a potential growth advisor?

**中文翻译:**
太棒了。好，我要把话题拉回到我设定的议程上，我想先谈谈顾问身份、咨询和增长顾问。你长期以来一直是许多顶尖公司的增长顾问，比如 Twitter、Pinterest、Patreon、Canva、Thumbtack。我相信还有其他你没列出来的更非正式的合作。现在你在 Shopify 工作。我想到的是，很多创始人经常在想：“我该请顾问吗？我该找什么样的顾问？我听过顾问没用的故事。有人告诉我不需要顾问。”所以我的问题是，你认为什么时候适合考虑聘请增长顾问？人们在考察和交谈潜在增长顾问时应该寻找什么？

---

### [00:18:47] Luc Levesque

**English:**
A few thoughts. In terms of when, I don't think you can probably come into early. It's probably harder to find really good ones than it is to time it. But generally speaking, I would say you don't want to focus too much on growth until you have product market fit. So make sure you have a product that users love that's either showing strong signs of retention or has some good loop that you can see that you can start thinking about growth.

**中文翻译:**
几点想法。关于“何时”，我不认为会太早。找到真正优秀的顾问可能比把握时机更难。但总的来说，我会说在实现产品市场契合度（PMF）之前，不要过度关注增长。所以要确保你有一个用户喜爱的产品，它要么显示出强烈的留存迹象，要么有一个你可以预见的良好循环，这时你才可以开始考虑增长。

---

### [00:19:08] Lenny

**English:**
Let me follow on that thread real quick because I find some founders still want to have someone come help them with growth even though they know they don't have product market fit, even though this tip comes up every single time when I'm talking to growth person, like, "Wait till you have product market fit before doing growth stuff." So could you just add a little bit of why that's important while we're on that topic?

**中文翻译:**
让我快速追问一下，因为我发现有些创始人即使知道自己还没有达到 PMF，仍然想找人帮他们做增长，尽管每次我和增长专家聊天时都会提到这个建议：“等有了 PMF 再做增长。”既然谈到了这个话题，你能补充一下为什么这很重要吗？

---

### [00:19:27] Luc Levesque

**English:**
Growth advice is generally always applicable. And if you can start thinking about how to build your product early, even if it's pre-product market fit, you're not going to do any damage, but you may be wasting some capital on an advisor or a growth person too early. The problem that I see is if you start growing a product that doesn't have product market fit, you're actually doing more damage than good because you have a product that is now being exposed to the market through growth levers and through optimization that is giving a bad experience with your product. And you want that product that you know is tight and you know has product market fit to start building the flywheel and start growing. You don't want it to be growing if it doesn't satisfy that need that you're trying to build out for. So I can see it having more damage than good because when somebody tries something, they're unlikely to try it again. And so that's the dangerous game you can get into. So you're better off with a good product that's satisfying a need and then growing from there.

**中文翻译:**
增长建议通常总是适用的。如果你能尽早开始思考如何构建产品，即使是在 PMF 之前，也不会造成什么伤害，但你可能会在顾问或增长人员身上过早浪费资金。我看到的问题是，如果你开始推广一个没有 PMF 的产品，你实际上是弊大于利，因为你正在通过增长杠杆和优化将一个体验不佳的产品推向市场。你希望那个已经打磨好、确定有 PMF 的产品开始构建飞轮并增长。如果它不能满足你试图解决的需求，你就不希望它增长。所以我认为这可能弊大于利，因为当用户尝试了某样东西（觉得不好）后，他们不太可能再次尝试。这就是你可能陷入的危险游戏。所以，你最好先有一个能满足需求的优秀产品，然后再从那里开始增长。

---

### [00:20:20] Luc Levesque

**English:**
I will say to kind of play devil's advocate with myself and something that I've done actually in one of the products, I've built several consumer products and grown them, is that sometimes to know if you have a product, you need users to use it. So there's like some subtlety in here, but I would say if you are trying to get users in to start playing with it at scale, I mean try to focus in on a market that is maybe off the grid. Like pick some English-speaking country that's a bit off the grid that you can isolate your marketing to so you can start getting dozens or a couple hundred people per day coming in and giving you feedback.

**中文翻译:**
我也想反驳一下自己——这是我在自己开发并增长的几个消费级产品中实际做过的事情——有时为了知道你是否真的做出了一个产品，你需要用户去使用它。所以这里有一些微妙之处。我想说，如果你想吸引用户开始大规模试用，可以尝试专注于一个“偏远”的市场。比如选一个稍微边缘一点的英语国家，把你的营销隔离在那里，这样你每天可以吸引几十个或几百个人进来给你反馈。

---

### [00:20:58] Luc Levesque

**English:**
I've seen that work too. So I'd say wait till you have product market fit. If you do start growing your product early because you need that signal from people actually using it beyond just focus groups and friends or small numbers of people, try to do it off the grid in smaller markets that you can get kind of contain the growth and get what you're really trying to get, which is that signal on is it working or not.

**中文翻译:**
我也见过这种做法奏效。所以我建议等有了 PMF 再说。如果你确实因为需要真实用户的信号（而不仅仅是焦点小组、朋友或少数人）而过早开始增长产品，请尝试在较小的边缘市场进行，这样你可以控制增长规模，并获得你真正想要的东西：即产品是否奏效的信号。

---

### [00:21:19] Lenny

**English:**
Awesome. Let's get back on track. So we're talking about when it makes sense to find a growth advisor and then what to look for and so on that you might want to work with.

**中文翻译:**
太棒了。让我们回到正轨。我们正在讨论什么时候适合找增长顾问，以及在你想合作的人身上应该寻找什么。

---

### [00:21:27] Luc Levesque

**English:**
I mean, what makes a great growth advisor is somebody who really understands what to do but also why certain growth levers work. It's that kind of deep understanding of levers of onboarding or whatever area they're focusing on that really makes growth advisor stand out. So when you're looking for a growth advisor, you want to have those discussions to see like, "How much depth does this person have? Have they seen a playbook and they're just good at repeating the playbook or are they evolving, are they growing?" The best way to get to know that is to start really asking them questions about growth and growth advising and the certain things that they've done and why they think those have worked.

**中文翻译:**
我的意思是，一个优秀的增长顾问不仅要真正理解该做什么，还要理解为什么某些增长杠杆会奏效。正是这种对新用户引导（onboarding）杠杆或他们所关注的任何领域的深度理解，才让增长顾问脱颖而出。所以当你寻找增长顾问时，你要通过讨论来看：“这个人的深度如何？他们是只见过一套剧本并擅长重复它，还是在不断进化和成长？”了解这一点的最佳方式是开始向他们提问，关于增长、增长咨询、他们做过的具体事情，以及他们认为这些事情奏效的原因。

---

### [00:22:09] Luc Levesque

**English:**
This can be tricky if you don't yourself know growth. So I think one thing that I have not seen a lot of founders do that I would advise is if you have an advisor already... Because this applies to finding growth advisors, but it also applies to hiring good growth talent. So if you have somebody you know whether it's already an advisor or somebody who knows growth, you can solicit their help in trying to flesh out whether somebody you're trying to hire is of high talent. So if you have an advisor, you can make that one of their roles is vet out any new talent coming in. And if you're looking for an advisor, try to find somebody that you know and trust who can do that first pass. Because for somebody who knows growth that you trust, it's actually not a lot of work for them to vet out how talented someone else's. It's an easy ask to make and something that if you have that person in your network or that worked with you that you can leverage for.

**中文翻译:**
如果你自己不懂增长，这可能会很棘手。所以我建议创始人做一件我很少见到的事：如果你已经有了一位顾问……这既适用于寻找增长顾问，也适用于招聘优秀的增长人才。如果你认识某人，无论是现有的顾问还是懂增长的人，你可以寻求他们的帮助，来判断你打算聘请的人是否是高水平人才。如果你已经有了一位顾问，你可以把“审核新进人才”作为他们的职责之一。如果你正在寻找顾问，试着找一个你认识并信任的人来做第一轮筛选。因为对于一个懂增长且你信任的人来说，审核别人的水平其实并不费什么事。这是一个很容易提出的请求，如果你的人脉网中有这样的人，或者曾与你共事过，你就可以利用这一点。

---

### [00:23:01] Luc Levesque

**English:**
But I haven't seen that too often where founders kind of take advantage of people they know or existing growth advisors to help recruit and vet talent because it can be quite hard if you don't know the growth space to know if somebody's good or not.

**中文翻译:**
但我并没有经常看到创始人利用熟人或现有的增长顾问来帮助招聘和审核人才，因为如果你不了解增长领域，很难判断一个人到底好不好。

---

### [00:23:15] Lenny

**English:**
That's a really interesting idea and it could be where you find someone that's too busy to work with you, but maybe you could just ask, "Hey, could you just easily help me vet people?" And it takes a lot less time.

**中文翻译:**
这是一个非常有趣的切入点。也许你找到了一个太忙而无法与你合作的人，但你可以问：“嘿，你能帮我简单审核一下候选人吗？”这花费的时间要少得多。

---

### [00:23:26] Luc Levesque

**English:**
Yeah, I've never been asked that, which is, I mean I don't know if I'll start getting asked this now, but it does seem like that's a really simple way to add a ton of value. And as a founder, I mean even if you have to pay this person or whatever you have to do, but it's such an important hire to get right. We talk about the 10X engineer and we don't really talk about the 10X growth advisor or 10X growth person, but the same dynamic applies. You could argue it applies even more because the right growth advisor can have literally company changing impact where they're either building or helping to ideate or helping to implement a growth loop that literally changes the company. As we know, you need a great product and you need a great growth loop. And it's usually just one loop that you need to get right. Most companies have gotten to where they are just off of one really strong channel that they've just dominated, so it's important to get right.

**中文翻译:**
是的，从来没有人这样要求过我。我不知道现在会不会开始有人这样问，但这确实是一个增加巨大价值的简单方法。作为创始人，即使你必须付钱给这个人，你也得这么做，因为招对人太重要了。我们谈论 10 倍速工程师，却不怎么谈论 10 倍速增长顾问或 10 倍速增长人才，但同样的动态也适用。你甚至可以认为这更适用，因为合适的增长顾问真的能产生改变公司的影响力——他们要么构建、要么协助构思、要么协助实施一个彻底改变公司的增长循环（growth loop）。众所周知，你需要一个伟大的产品和一个伟大的增长循环。通常你只需要做对一个循环就够了。大多数公司之所以能达到今天的地位，仅仅是因为他们主导了一个非常强大的渠道，所以做对这一点至关重要。

---

### [00:24:17] Lenny

**English:**
Is there an example of that sort of impact that you've seen in your advisorship or other people's of just an impact from one conversation or a little bit of a help?

**中文翻译:**
在你的顾问生涯或其他人的经历中，有没有那种通过一次谈话或一点点帮助就产生巨大影响的例子？

---

### [00:24:25] Luc Levesque

**English:**
Definitely. And I think what I would point to is the advantage of a growth advisor is it takes a long time to understand a channel. Certainly people have to know their stuff, they have to be very good at their craft, their growth craft, but also they have to be exposed to a large set of experiments or an environment where they've just seen what works and what doesn't. So no matter how good somebody is, if they haven't been exposed to an environment where there's a lot of experimentation, a lot of learning, it's very hard for them to internalize that. So once a growth advisor has that, it's takes years to learn it, but it literally can take seconds literally to communicate that. So I've worked with some companies that you've mentioned and certainly have had impact very quickly.

**中文翻译:**
绝对有。我想指出的是，增长顾问的优势在于：理解一个渠道需要很长时间。当然，人们必须懂行，必须精通增长这门手艺，但他们还必须接触过大量的实验，或者身处一个能亲眼看到什么有效、什么无效的环境。所以无论一个人多优秀，如果他们没有接触过大量实验和学习的环境，很难内化这些知识。一旦增长顾问拥有了这些，虽然学习它需要数年时间，但传达它真的只需要几秒钟。我曾与你提到的一些公司合作过，确实很快就产生了影响力。

---

### [00:25:09] Luc Levesque

**English:**
I mean, one example would be a company that I worked with. Now, a public company. At the time, they weren't. On day one, walked in, they presented their strategy, their plans, their funnels and their landing pages. I could see very quickly that there was something they were doing that was a little off and I asked them, "Well, why are you doing it that way?" And they said, "Well, we think it just looks better that way." And I said, "Well, just do it this other way." I remember this because it was such a short conversation and then three weeks later we connected and I heard they had rolled it out and it was a large impact that they had from this one change. This has happened many times with the companies I've worked with, but it's a good example that once you know it, it's not hard to recognize it if you deeply understand it to give advice, but it takes a long time to get the base knowledge.

**中文翻译:**
举个例子，我合作过的一家公司，现在已经上市了，但当时还没上市。第一天我走进去，他们展示了战略、计划、漏斗和落地页。我很快就发现他们做的某些事情有点不对劲，我问他们：“你们为什么要那样做？”他们说：“嗯，我们觉得那样看起来更好看。”我说：“试试用另一种方式做。”我记得这件事是因为那次谈话非常简短，三周后我们联系时，我听说他们已经上线了那个改动，并且产生了巨大的影响。这种情况在我合作过的公司中发生过很多次，这是一个很好的例子：一旦你掌握了它，如果你有深刻的理解，给出建议并识别问题并不难，但获得这些基础知识需要很长时间。

---

### [00:26:02] Luc Levesque

**English:**
So I don't do these too often anymore, but when I do advise, I take them very seriously. I focus exclusively on having impact. I think that's really important because like you say, there's a lot of advisors out there. Some of them are great, some of them different qualities, and you really want to make sure that if you are an advisor, you want to be in the camp of when this person comes in, they have a lot of impact and it takes time and focus and energy and alignment and there's a bunch of things we can talk about that that helps to drive that alignment. But having impact is the most important thing, whether you're an advisor or if you're hiring because it's one of those weird disciplines where the right person at the right time can literally say a sentence that changes the trajectory of your company. You can't say that for a lot of different disciplines, but this is one of them.

**中文翻译:**
我现在不经常做咨询了，但当我做的时候，我会非常认真。我唯一的焦点就是产生影响力。我认为这非常重要，因为正如你所说，外面有很多顾问，有的很棒，有的素质参差不齐。如果你是一名顾问，你真的希望自己属于那一类：一旦进入公司，就能产生巨大的影响。这需要时间、专注、精力和一致性（alignment），我们可以讨论很多有助于推动这种一致性的事情。但产生影响力是最重要的事情，无论你是做顾问还是在招聘，因为增长是那些奇特的学科之一，在正确的时间，正确的人说出的一句话，就可能彻底改变公司的发展轨迹。很多学科都做不到这一点，但增长绝对是其中之一。

---

### [00:26:49] Lenny

**English:**
There's that word impact again,

**中文翻译:**
又是“影响力”这个词。

---

### [00:26:51] Luc Levesque

**English:**
Impact. Impact.

**中文翻译:**
影响力，影响力。

---

### [00:26:52] Lenny

**English:**
The point you just made about how one conversation can have a ton of impact is a reminder of why sometimes the price of an advisor feels absurd where like, "For one hour it's like thousands of dollars," but it's because obviously they spent a decade learning a thing and one conversation is all of that work they put into it crystallized for you in the moment.

**中文翻译:**
你刚才提到的“一次谈话就能产生巨大影响”这一点，提醒了我们为什么有时顾问的价格看起来很荒谬，比如“一小时要几千美元”。但显然，这是因为他们花了十年时间去学习一件事，而那一次谈话就是他们所有心血在瞬间为你结出的果实。

---

### [00:27:13] Luc Levesque

**English:**
Exactly. It's something I've experienced several times in hindsight when you're like, "Okay, here's the needle in the haystack" and then it's implemented and you can see hundreds of percentages, sometimes over a thousand percent lift when you get it right. It's exhilarating. It's great. I have something I used to say, which is, you want your impact to be so big there's a slide in the next board deck on try to explain what happened. That can happen when you are advising companies because you're able to share a very quickly insights. But one way to drive alignment is not everybody can do this, not all advisors do it this way, but I personally love just when I do these, which is not that frequent, just purely doing equity because I love the alignment in outcomes where the founder will be successful and you will be successful. So the incentives are really good to drive the right performance and the right outcomes that you want as a founder.

**中文翻译:**
没错。事后回想起来，我经历过好几次这样的时刻：你找到了“大海里的那根针”，然后方案落地，你看到了百分之几百、甚至超过 1000% 的提升。这令人兴奋，太棒了。我以前常说一句话：你希望你的影响力大到在下一次董事会报告中，必须专门用一张幻灯片来解释到底发生了什么。当你为公司提供咨询时，这种情况是可能发生的，因为你能快速分享洞察。但推动一致性的一种方式是——虽然不是每个人都能做到，也不是所有顾问都这样做——我个人在做咨询时（虽然不频繁），非常喜欢纯粹拿股权。因为我喜欢结果上的一致性：创始人成功，我也成功。这种激励机制非常好，能推动创始人想要的正确表现和结果。

---

### [00:28:09] Luc Levesque

**English:**
So if you can do it, I would definitely advise founders to bring advisors in for equity if you can. I think the same applies for your internal growth team. You want to make sure that the teams are incentivized not on activities, on doing stuff, because there's a lot of stuff to be done in growth, but really driving the outcomes that you want. And equity's just a great way of saying, "Hey, we're in this together. We're on the same side of the table. Let's go grow this company."

**中文翻译:**
所以如果可以的话，我绝对建议创始人用股权来聘请顾问。我认为这同样适用于你的内部增长团队。你要确保团队的激励不是基于“活动”或“做事”，因为增长领域有很多事情可以做，而是要基于推动你想要的结果。股权就是一种很好的表达方式：“嘿，我们同舟共济，我们在桌子的同一边。让我们一起把这家公司做大。”

---

### [00:28:36] Lenny

**English:**
I was actually about to ask you what kind of structure you recommend for an advisorship. Is there anything else you can share about just what you'd recommend a founder do in terms of compensation for an advisor?

**中文翻译:**
我正想问你推荐什么样的顾问合作结构。关于创始人对顾问的薪酬安排，你还有什么建议可以分享吗？

---

### [00:28:45] Luc Levesque

**English:**
There's a couple things. I'm a big fan of equity because of the alignment of incentives. You should think about, without getting into too much detail of the actual structure of the deals, but think about how you vest the equity. The last thing you want is an advisor holding back on sharing knowledge. The ideal engagement would be an advisor comes in, delivers as much value as possible quickly, and then trains your team. And then maybe it's a one-year engagement and hopefully they've learned because the advisor has been incentivized to share as much as possible and to train the team as much as possible. And then ideally you don't need them anymore after. So there's something there about structuring equity vesting. I'm a big fan of vesting earlier rather than later. So think about in terms of structure you're vesting, commensurate with the value you want, which is very much front loaded.

**中文翻译:**
有几点。因为激励机制的一致性，我是股权的坚定拥护者。在不涉及具体交易结构细节的情况下，你应该考虑股权如何归属（vest）。你最不希望看到的是顾问保留知识。理想的合作是顾问进来，快速提供尽可能多的价值，然后培训你的团队。也许这是一年的聘期，希望团队已经学会了，因为顾问有动力尽可能多地分享和培训。理想情况下，之后你就不再需要他们了。所以关于股权归属的结构设计很有讲究。我非常支持“前置归属”（vesting earlier），而不是后置。所以考虑归属结构时，要与你想要的价值相匹配，而这种价值通常是非常前置的。

---

### [00:29:35] Luc Levesque

**English:**
I'm also a big fan of three month cliffs. Something I've done, I always do actually, is listen, in the first three months you'll know both sides if it's working or not. And you want to de-risk that on both sides because it really should be seen as a partnership between the advisor and the founder. If the founder thinks you're not adding value in the first few months, I think they should just tear it up and both sides move on. It's not good for the founder to continue the deal and it's not good frankly for the advisor because they're not, for some reason, able to add value in that environment. So I love a three-month cliff at the beginning where if it's not working in the first three months, you tear up the deal and both parties walk away and de-risk the entire thing, and again, drives incentives in the right way where the advisor is 100% incentivized at as much value as fast as possible. And so that's another thing that I tend to do and I've done it for a long time.

**中文翻译:**
我也非常推崇三个月的“悬崖期”（cliff）。我一直这样做：听着，在前三个月，双方都会知道合作是否奏效。你想降低双方的风险，因为这应该被视为顾问和创始人之间的伙伴关系。如果创始人觉得你在前几个月没有增加价值，我认为他们应该直接终止协议，双方各自安好。对创始人来说，继续交易没好处；坦白说，对顾问也没好处，因为由于某种原因，他们无法在那个环境下创造价值。所以我喜欢在开始时设置三个月的悬崖期，如果前三个月不行，就撕毁协议，双方退出，降低整个事情的风险。这再次以正确的方式驱动了激励：顾问有 100% 的动力尽快提供尽可能多的价值。这是我长期以来一直坚持的做法。

---

### [00:30:28] Lenny

**English:**
That's a really good tip. Basically don't do it for a year if you're vesting for advisors, probably not even to a year, but yeah.

**中文翻译:**
这是一个非常好的建议。基本上，如果是给顾问的股权归属，不要设为一年，甚至可能都不到一年。

---

### [00:30:33] Luc Levesque

**English:**
There's a bunch of ways to do it. Honestly, it's hard enough to find growth advisors that have capacity, so you got to also say like, "What can you do that the advisor's comfortable with?" But yeah, I mean just to be candid, I think you want to structure in a way where you're not dependent on the advisor over time. They're adding a ton of value, they're helping teach the team, they're probably bouncing around because your company's changing, your team's changing, your leaders are changing. But over time, and that can be years, but it shouldn't be indefinite. You shouldn't need an advisor forever.

**中文翻译:**
有很多方法。坦白说，找到有档期的增长顾问已经够难了，所以你还得考虑：“你能做些什么让顾问感到舒服？”但说实话，我认为你应该以一种“不长期依赖顾问”的方式来构建结构。他们提供巨大价值，帮助培训团队，他们可能会因为你的公司、团队或领导层的变动而调整关注点。但这可能持续几年，但不应该是无限期的。你不应该永远需要一个顾问。

---

### [00:31:04] Luc Levesque

**English:**
I've seen a scenario where there's desire to keep the advisor on almost as insurance, like, "If something goes wrong, I just wanted to be able to pick up the phone." That can make sense. But I do think a good growth advisor is incentivized to share as much as possible, as fast as possible to have impact to train your team. And then whether you want to keep them on or not long term as an insurance policy or just to answer questions as things change, that should be a choice and not because, "If we lose the advisor. We're completely screwed." That would be a bad place for you to be in as a founder.

**中文翻译:**
我见过一种情况，创始人想留住顾问几乎是作为一种“保险”，比如：“如果出了什么问题，我希望能随时打电话找到他。”这也有道理。但我认为，一个好的增长顾问应该有动力尽可能快、尽可能多地分享知识，以产生影响力并培训你的团队。至于你是否想长期留住他们作为保险政策，或者只是为了在情况变化时解答疑问，那应该是一个选择，而不是因为“如果我们失去了顾问，我们就彻底完蛋了”。作为创始人，如果你处于那种境地，那就太糟糕了。

---

### [00:31:35] Lenny

**English:**
You said it's hard to find a good advisor, 100% agree. Any advice for people to help them find an advisor that might be the right fit?

**中文翻译:**
你说很难找到好的顾问，我 100% 同意。对于如何找到合适的顾问，你有什么建议吗？

---

### [00:31:43] Luc Levesque

**English:**
Yeah, I would say there's more of them these days than there were even just five years ago or 10 years ago. Depending on your situation, if you're a founder, I would start with your investors. I think VCs have an amazing network of advisors. I get, I don't know, a couple requests a week that I'm not taking right now. But that from my experience and what I've seen, that's probably especially the high end VCs, the very talented VCs will have this network. And frankly, it's a great partnership as an advisor for you to have. You can help the companies, you can help the VCs and it helps you. So everybody wins, just asking other founders that had good experience, much like hiring.

**中文翻译:**
是的，我想说现在的顾问比五年前甚至十年前要多。根据你的情况，如果你是创始人，我会先从你的投资者开始。我认为风投（VC）拥有惊人的顾问网络。我每周都会收到一两个请求，虽然我现在不接。但根据我的经验和观察，特别是高端 VC、非常有才华的 VC 都会有这个网络。坦白说，作为顾问，这也是一个很好的合作伙伴关系：你可以帮助公司，帮助 VC，也帮助你自己。所以这是多赢的。另外，就像招聘一样，去问问其他有良好经验的创始人。

---

### [00:32:21] Luc Levesque

**English:**
The third advice I would give is to find companies that are world-class at what you're trying to grow, what channel or skill you're looking at, and then reach out and see if there's a way to help that way. That's actually how I got started. I was at Tripadvisor and a prominent VC reached out. One of the companies they were working with needed some help on SEO. I was still in Canada at the time, got connected with them, had a phone call, had a significant impact through that one phone call. And rather than joining as an advisor, I essentially helped them out pro bono in exchange for, "Hey, I want to get connected in the Valley." So I was in Canada, I wanted to start another company, I wanted to get connected. So through that tactic where they reached out to a company that was known to be world-class at SEO, I think that was really smart on this VC's part.

**中文翻译:**
第三个建议是：找到那些在你想要增长的领域、渠道或技能方面做得世界一流的公司，然后联系他们，看看是否有办法获得帮助。这其实就是我开始的方式。当时我在 TripAdvisor，一位著名的 VC 联系了我。他们投资的一家公司在 SEO 方面需要帮助。我当时还在加拿大，和他们取得了联系，打了一个电话，通过那一个电话就产生了重大影响。我当时没有以顾问身份加入，而是基本上免费帮助他们，作为交换，我说：“嘿，我想在硅谷建立联系。”当时我在加拿大，想再创办一家公司，想建立人脉。所以通过这种联系“公认的 SEO 世界级公司”的策略，我认为这位 VC 做得非常聪明。

---

### [00:33:13] Luc Levesque

**English:**
And then maybe some advice to up and coming growth advisors would be that first one, I didn't take a single shred of equity or money and just tried to have as much impact as possible and to help out this company as much as possible and then make sure that I was able to get connected to other people that I wanted to meet in the Bay Area. And then kind of things snowballed from there.

**中文翻译:**
对于那些崭露头角的增长顾问，我的建议是：在最开始，我没有拿一丁点股权或钱，只是努力产生尽可能大的影响，尽力帮助那家公司，然后确保我能联系到我想在湾区见到的其他人。从那以后，事情就像滚雪球一样发展起来了。

---

### [00:33:33] Lenny

**English:**
I definitely want to chat about how to become a growth advisor because I think people listening here might be like, "Oh, that sounds pretty good. Someday maybe I'll become a growth advisor." But before we get to that, what are things that an advisor are best suited for versus finding someone full-time versus no one? What are the ideal kind of problem sets for an advisor versus say, full-time hire person?

**中文翻译:**
我肯定想聊聊如何成为一名增长顾问，因为听众可能会觉得：“噢，听起来不错，也许有一天我也能成为增长顾问。”但在那之前，顾问最适合解决什么样的问题？相比于找全职员工或不找人，顾问的理想应用场景是什么？

---

### [00:33:57] Luc Levesque

**English:**
I would say your preference should always be to have somebody in-house. I'll start there because you want to have that as part of the culture. There's so much more that they can do when they're in-house. That being said, if you can't find somebody in-house, then bring on an advisor... Even if you bring on an advisor, some advice to founders would be you want to surround your team or at least one person that you've identified who's just a amazing world-class doer, even if they don't know growth, with a set of growth advisors so that they're learning, that's being put through the culture of the company and that knowledge stays inside of the company. So I'd say I would prefer to go internal, surround these people with great advisors and then take it from there. That would be how I approach it.

**中文翻译:**
我会说，你的首选应该永远是内部人员。首先是因为你希望增长成为文化的一部分，内部人员能做的事情要多得多。话虽如此，如果你找不到合适的内部人选，那就请一位顾问……即使你请了顾问，我对创始人的建议是：你应该让你团队中至少一个你认定的、世界一流的“执行者”（哪怕他们不懂增长），被一群增长顾问包围。这样他们就能学习，知识会融入公司文化并留在公司内部。所以我会说，我更倾向于内部化，然后用优秀的顾问来辅助这些人。这就是我的处理方式。

---

### [00:34:41] Lenny

**English:**
Okay. So two thoughts here. One is I feel like this podcast is becoming an interesting way to discover awesome growth advisors. I think over time I'm building this directory of who are awesome, smart growth people that are open to advising. So that could be an interesting opportunity to just look through the folks on this podcast and-

**中文翻译:**
好。这里有两个想法。第一，我觉得这个播客正在成为发现优秀增长顾问的一个有趣途径。随着时间的推移，我正在建立一个名录，记录那些聪明、优秀且愿意做咨询的增长人才。所以，翻翻这个播客的嘉宾名单可能是一个有趣的机会——

---

### [00:34:59] Luc Levesque

**English:**
Yep, there's some great people that have been on here. Definitely.

**中文翻译:**
是的，这里确实来过一些非常棒的人。

---

### [00:35:02] Lenny

**English:**
Totally working my way through all the amazing least smart growth people and product leaders. The other is I've noticed they're a lot of the best growth advisors have worked with the same sorts of companies. I find Miro comes up a lot, Canva comes up a lot, Pinterest. All these people that have worked with say Pinterest that I hear about are just awesome. Casey comes to mind, Melissa Tan who's coming out with a podcast, I think she worked with them. Dropbox. Anyway, so maybe one idea, see who these companies work with as advisors and that can maybe point you to people that are worth exploring.

**中文翻译:**
我一直在努力结识所有这些了不起的增长人才和产品领导者。另一个想法是，我注意到很多最好的增长顾问都曾在类似的公司工作过。我发现 Miro 经常被提及，Canva 也是，还有 Pinterest。我听到的所有在 Pinterest 工作过的人都很棒。我想到了 Casey，还有即将推出播客的 Melissa Tan，我想她也和他们合作过。还有 Dropbox。总之，也许一个主意是：看看这些公司聘请了谁做顾问，这可能会指引你找到值得探索的人才。

---

### [00:35:34] Luc Levesque

**English:**
I mean, that's a good idea. It kind of goes back to something I mentioned earlier, which is companies that have a lot of traffic and that have a lot of users are a great learning ground for growth people and for advisors, because no matter how smart you are, you need the reps. You got to go to the growth gym and put in the reps, which is experiments. You've got to try things, things that are going to work, things that aren't going to work. There's a discipline of when something doesn't work, you can learn almost as much as when something works. But you need that traffic, you need that environment. And that's why certain companies have these great people coming out like Casey at Pinterest and other people that have been at these companies that have the traffic, have the culture to support it, to support growth. I don't think that's a coincidence why some of these companies have some great people coming from them.

**中文翻译:**
这确实是个好主意。这又回到了我之前提到的：拥有海量流量和用户的公司是增长人才和顾问的最佳练兵场。因为无论你多聪明，你都需要“重复练习”（reps）。你得去“增长健身房”锻炼，而锻炼的方式就是实验。你必须尝试各种事情，有的会成功，有的会失败。有一门学问是：当某件事失败时，你学到的东西几乎和成功时一样多。但你需要流量，需要那个环境。这就是为什么像 Pinterest 的 Casey 这样优秀的人才层出不穷，因为这些公司有流量，有支持增长的文化。我认为这些公司能培养出这么多优秀人才绝非偶然。

---

### [00:36:20] Lenny

**English:**
The other tip I just thought about as you were talking is everyone's launching a Substack newsletter that is doing any sort of advising because there's a lot of power in building an audience and creating kind of awareness of what you do. So I wonder if another tip is search Substack's directory of newsletters for specific things you're dealing with, like say, go to PLG or sales and you might find someone there."

**中文翻译:**
刚才听你说话时我想到的另一个建议是：现在每个做咨询的人都在开 Substack 专栏，因为建立受众和提高知名度非常有力量。所以我在想，另一个建议是不是去 Substack 的通讯目录里搜索你正在处理的具体问题，比如搜索“PLG”（产品驱动增长）或“销售”，你可能会在那里找到合适的人。

---

### [00:36:39] Luc Levesque

**English:**
I haven't done that, but that seems like a reasonable way to do it.

**中文翻译:**
我还没试过，但这看起来是个合理的方法。

---

### [00:36:42] Lenny

**English:**
That's where we're all heading.

**中文翻译:**
我们大家都在往那个方向走。

---

### [00:36:44] Luc Levesque

**English:**
I'm not saying that the people on Substack have this. But as advice to the people listening, is when you're vetting for a growth advisor or growth talent, don't just wait it on the public halo of somebody. That's a common mistake I've seen where maybe somebody's done presentations at a conference or somebody's done... I don't know, but their Twitter following is broad. They can be excellent. That's not a disqualifier immediately, but just make sure not to make the hire just exclusively on that. I've made that mistake a few times and it's a common one to get into. So make sure you're vetting properly, even if somebody with a large following on Substack or Twitter. That's I think an important thing to keep in mind.

**中文翻译:**
我不是说 Substack 上的人都有这个问题。但给听众一个建议：在审核增长顾问或增长人才时，不要只看一个人的“公共光环”。我见过一个常见的错误，就是因为某人在会议上做过演讲，或者在 Twitter 上有很多粉丝。他们可能确实很优秀，这并不是直接否定他们的理由，但千万不要仅仅因为这些就雇佣他们。我犯过几次这样的错误，这是一个很常见的坑。所以即使是 Substack 或 Twitter 上拥有大量粉丝的人，也要确保进行适当的审核。我认为记住这一点很重要。

---

### [00:37:25] Lenny

**English:**
1000% agree. I always say that the best product leader is the best growth. People don't have time to sit on Twitter and tweet and write newsletters. They're doing the job, working, building, growing, and maybe eventually they get out of that and start writing. But I 1000% agree, there's a lot of people-

**中文翻译:**
1000% 同意。我常说，最好的产品领导者和增长专家没时间整天泡在 Twitter 上发推或写通讯。他们忙着干活、构建、增长，也许最终他们会抽身出来开始写作。但我 1000% 同意，有很多人——

---

### [00:37:40] Luc Levesque

**English:**
Well, not to disqualify all the people on Twitter.

**中文翻译:**
当然，不是要否定 Twitter 上的所有人。

---

### [00:37:43] Lenny

**English:**
Absolutely.

**中文翻译:**
那是肯定的。

---

### [00:37:43] Luc Levesque

**English:**
Some of them are tweeting [inaudible 00:37:45], but my point is just don't over pivot on the halo. Just look at their past performance. What teams have they been on? What environment do they have? Do they really know growth? And sometimes they do, but I think it's a common mistake to say, "Oh yeah, they have a large following, let's hire this person." That's poorly.

**中文翻译:**
他们中有些人发推（听不清），但我的观点是不要过度依赖光环。看看他们过去的表现。他们在哪些团队待过？他们在什么样的环境下工作？他们真的懂增长吗？有时他们确实懂，但我认为说“哦，他们粉丝很多，雇他吧”是一个常见的错误。那通常结果不好。

---

### [00:38:03] Lenny

**English:**
1000% agree. Rarely does a celebrity hire that seems really genius on Twitter and Substack end up being as amazing as you think.

**中文翻译:**
1000% 同意。那些在 Twitter 和 Substack 上看起来像天才的“明星雇员”，很少能像你想象的那么出色。

---

### [00:38:12] Luc Levesque

**English:**
Yeah, it does happen, but yeah.

**中文翻译:**
是的，虽然偶尔也有例外，但确实如此。

---

### [00:38:13] Lenny

**English:**
It does happen. Absolutely. One last question around this topic. People listening might want to become growth advisors, I'd mentioned this earlier. Is there any other advice you want to share? Just like, "If you want to become a growth advisor someday, here's what you should think about."

**中文翻译:**
确实。关于这个话题最后一个问题。听众中可能有人想成为增长顾问，我之前提过。你还有什么想分享的建议吗？比如：“如果你想有一天成为增长顾问，你应该考虑这些。”

---

### [00:38:26] Luc Levesque

**English:**
Yeah, I think the right mental model as a growth advisor is around the same one as an investor. So the most important thing an advisor can do aside from having impact and knowing their craft is picking which companies to work with, especially if you're working for equity. So I'll only speak to that, but you're basically putting in your time, you're picking likely a smaller number. You only have so many hours in the day of companies to work with and you want to make sure there's a likely exit in the future. So for me personally, I have a spreadsheet, like most big decisions that I make in my life. Over the years I've just added criteria and questions to ask myself about the company and then reflect on, "Okay, is this kind of checking all the boxes for a likely outcome?" Because you don't just need to be successful, you need to be successful and for the company to be successful and for there to be liquidity of that.

**中文翻译:**
是的，我认为作为增长顾问，正确的心智模型应该和投资者类似。所以，除了产生影响力和精通手艺之外，顾问能做的最重要的事情就是选择与哪些公司合作，尤其是当你为了股权而工作时。我只针对这一点来说：你基本上是在投入时间，你可能会选择少数几家公司合作（毕竟一天只有那么多小时），你要确保未来有退出的可能。对我个人而言，我有一个电子表格，就像我人生中大多数重大决定一样。多年来，我不断增加评估公司的标准和自问的问题，然后反思：“好吧，这家公司是否符合所有可能获得成功的条件？”因为不仅你需要成功，公司也需要成功，而且这种成功最终需要变现。

---

### [00:39:17] Luc Levesque

**English:**
So you need to put yourself in the shoes of an investor and look at it as an investment. That is arguably the most important thing because you can go and do a great job and then wait many years and potentially not see any reward for it. And I think that's the nice thing about the equity structure in that you're tied in the same incentives with the founder, which is just great in terms of any relationship to have the same incentives, but you want to make sure that there's a good likelihood of a decent outcome down the road.

**中文翻译:**
所以你需要站在投资者的角度，把它看作一项投资。这可以说是最重要的事情，因为你可能做得非常出色，但等了很多年，最终却可能看不到任何回报。我认为股权结构的妙处在于你和创始人的激励机制是绑定的，在任何关系中，拥有相同的激励机制都是极好的。但你要确保未来有很大可能性获得不错的结果。

---

### [00:39:49] Luc Levesque

**English:**
If I can throw another one in.

**中文翻译:**
如果我能再补充一点的话。

---

### [00:39:49] Lenny

**English:**
Yeah, absolutely.

**中文翻译:**
当然可以。

---

### [00:39:50] Luc Levesque

**English:**
The other piece of advice I would give is it can take a long time for some of these companies to be successful. That's okay. You should expect that. In fact, you should just go in with that mindset. When I'm deciding to work with a company, I'm in there for 10 years and I know that and I say that. And I say, "I'm in. We're in this together if I choose to work with the company." But it does mean that the structure of the deal needs to reflect that. So you need to have a long tail at the end.

**中文翻译:**
我想给的另一条建议是：其中一些公司可能需要很长时间才能成功。这没关系，你应该预料到这一点。事实上，你应该带着这种心态加入。当我决定与一家公司合作时，我是奔着 10 年去的，我清楚这一点，也会明确说出来。我会说：“我加入了。如果我选择与公司合作，我们就同舟共济。”但这意味着交易结构需要体现这一点。所以，你需要在结尾有一个“长尾”。

---

### [00:40:15] Luc Levesque

**English:**
So if you're taking options or RSUs and it's pure of the equity, make sure you have the time for that to happen. There would be nothing worse than putting your heart and soul having impact and then waiting, I don't know, a couple years and then your equity expires. So you make sure there's a long tail. I mean, it can literally take over 10 years for these companies to exit. And you should be okay with that. I think that's okay. You're taking some risks. They're taking some risk on you and that's a great partnership, but you'll just need the time for that. So advice to growth advisors, make sure to ask for a long tail so that you don't end up in a bad spot in the end. And that incentives, again, are perfectly aligned between the founder and the advisor.

**中文翻译:**
所以如果你拿的是期权或 RSU（受限股票单位），而且纯粹是股权，请确保你有足够的时间等待结果。没有什么比倾注心血产生影响力，然后等了几年，结果你的股权过期了更糟糕的了。所以要确保有一个长尾。我的意思是，这些公司退出可能真的需要 10 年以上。你应该接受这一点。我认为这没问题。你在承担风险，他们也在你身上承担风险，这是一种伟大的伙伴关系，但你只需要时间。所以给增长顾问的建议是：确保要求一个长尾，这样你最后就不会陷入尴尬的境地。再次强调，这样创始人和顾问之间的激励机制才能完美契合。

---

### [00:40:52] Lenny

**English:**
This episode is brought to you by Eppo. Eppo is the next generation A/B testing platform built by Airbnb alums for modern growth teams. Companies like DraftKings, Zapier, ClickUp, Twitch and Cameo rely on Eppo to power their experiments. Wherever you work, running experiments is increasingly essential, but there are no commercial tools that integrate with a modern grow team stack. This leads to waste of time building internal tools or trying to run your own experiments through a clunky marketing tool. When I was at Airbnb, one of the things that I loved most about working there was our experimentation platform where I was able to slice and dice data by device types, country, user stage. Eppo does all that and more delivering results quickly, avoiding knowing prolonged analytic cycles and helping you easily get to the root cause of any issue you discover. Eppo lets you go beyond basic click-through metrics and instead use your north star metrics like activation, retention, subscription and payments. Eppo supports test on the front end, on the backend, email marketing, even machine learning claims. Check out Eppo at geteppo.com. That's geteppo.com and 10X your experiment velocity.

**中文翻译:**
本集节目由 Eppo 赞助。Eppo 是由 Airbnb 校友为现代增长团队打造的下一代 A/B 测试平台。DraftKings、Zapier、ClickUp、Twitch 和 Cameo 等公司都依赖 Eppo 来驱动他们的实验。无论你在哪里工作，运行实验都变得越来越重要，但目前还没有商业工具能与现代增长团队的技术栈集成。这导致人们浪费时间构建内部工具，或者试图通过笨重的营销工具运行实验。当我在 Airbnb 时，我最喜欢的事情之一就是我们的实验平台，我可以在那里按设备类型、国家、用户阶段对数据进行切片分析。Eppo 能做到这一切甚至更多，它能快速交付结果，避免漫长的分析周期，并帮助你轻松找到发现的任何问题的根本原因。Eppo 让你超越基本的点击率指标，转而使用激活、留存、订阅和支付等北极星指标。Eppo 支持前端、后端、邮件营销甚至机器学习方案的测试。请访问 geteppo.com 查看 Eppo，让你的实验速度提升 10 倍。

---

### [00:41:59] Lenny

**English:**
So I want to segue to a different topic, SEO. You're kind of the... You tell me, but it feels like you're one of the earliest SEO people in tech. You helped grow Tripadvisor many years ago and it was mostly SEO-driven. I think you innovated a lot of SEO tactics and strategies. And then you helped Pinterest, Thumbtack, other companies that are very SEO-driven. You talked about how many companies grow through one channel and these are all very SEO-driven companies. I imagine Shopify has a lot of SEO work that's happening right now with you there. And so I want to chat about SEO. So I guess broadly SEO is like... It's like this amazing growth channel. It's basically free. It continues to work after you stop doing any work on it for a while. Many founders think about, "Should we invest in SEO? How do we approach SEO?" So maybe just as a first question, what are signs that your product and company is a good fit for SEO being potentially a huge channel for growth?

**中文翻译:**
我想转到一个不同的主题：SEO。你是……你来告诉我，但感觉你是科技界最早的一批 SEO 专家之一。多年前你帮助 TripAdvisor 增长，那主要是由 SEO 驱动的。我认为你创新了很多 SEO 战术和策略。后来你又帮助了 Pinterest、Thumbtack 等非常依赖 SEO 的公司。你提到过很多公司通过单一渠道增长，而这些都是典型的 SEO 驱动型公司。我猜 Shopify 现在也有很多 SEO 工作正在进行。所以我想聊聊 SEO。广义上讲，SEO 是一个神奇的增长渠道：它基本上是免费的，而且在你停止工作一段时间后仍能持续发挥作用。很多创始人都在想：“我们应该投资 SEO 吗？我们该如何切入 SEO？”所以第一个问题是，有哪些迹象表明你的产品和公司适合将 SEO 作为潜在的巨大增长渠道？

---

### [00:42:55] Luc Levesque

**English:**
Yeah, I've been doing SEO for a really long time. It's a lot of fun and certainly being a supervisor was a great learning ground for that, that we were able to really innovate and try new things there. In terms of the playbook that we built out. That was a lot of fun, those years.

**中文翻译:**
是的，我做 SEO 已经很久了。这很有趣，在 TripAdvisor 的经历确实是一个极好的学习场所，让我们能够真正创新并尝试新事物。关于我们建立的那套剧本，那些年真的很有趣。

---

### [00:43:11] Luc Levesque

**English:**
Couple thoughts. The first one would be I do think there's an SEO play in any company. Maybe at a different extent, but Google is such a large funnel of existing demand for your product or your product area that there's usually an angle to get some SEO traffic there. So I do think it applies to most companies. I would say if you're an early product that the world's never seen, it's a brand new thing, there might be some creation, some demand creation you need to do, but most of the time there's existing demand in Google where you can harvest demand or there's queries that are related to your topic that you can start ranking for to start building brand awareness. So there's always some angle.

**中文翻译:**
几点想法。第一，我认为任何公司都有 SEO 的发挥空间。程度可能不同，但 Google 是一个巨大的现有需求漏斗，针对你的产品或产品领域，通常总能找到获取 SEO 流量的角度。所以我认为它适用于大多数公司。我会说，如果你是一个世界上从未见过的早期产品，是一个全新的东西，你可能需要做一些需求创造的工作；但大多数时候，Google 上已经存在现有的需求，你可以去“收割”这些需求，或者针对与你主题相关的查询开始建立排名，从而建立品牌知名度。所以总会有切入点的。

---

### [00:43:52] Luc Levesque

**English:**
And then I kind of divide websites or online products into two categories. There's the ones which are smaller sites, small number of pages, very targeted at your product and don't have this kind of loop of creating new pages automatically. Most eCommerce sites actually have would a number of pages around the products and about us, those types of pages. That's one type of sites. Let's say they have dozen pages. And then there's other ones with thousands, tens of thousands, hundreds of thousands, millions of pages which are either user generated content like Tripadvisor and Pinterest and others, or marketplaces like Thumbtack and other types of websites like that. Those are generally easier to see a huge amount of impact very quickly because there's such a large optimization surface and ideally it's growing and generating traffic automatically.

**中文翻译:**
然后我把网站或在线产品分为两类。第一类是小型网站，页面数量少，非常针对你的产品，没有那种自动创建新页面的循环。大多数电子商务网站实际上只有一些围绕产品和“关于我们”的页面。这是其中一类，假设它们只有几十个页面。另一类是拥有成千上万、甚至数百万个页面的网站，它们要么是用户生成内容（UGC），如 TripAdvisor 和 Pinterest 等，要么是像 Thumbtack 这样的平台型网站。这类网站通常更容易在短时间内看到巨大的影响，因为它们的优化空间非常大，而且理想情况下，它们会自动增长并产生流量。

---

### [00:44:40] Luc Levesque

**English:**
I've always thought of LinkedIn as just such a great example of this where you have this viral loop where if you recall when it was just starting, everybody was getting these invites from LinkedIn. Those come and go. You get an invite, you register, you don't. That happens. But the byproduct is when people join, they create this beautiful lightning page, which is your profile that gets indexed. It's kind of like a viral loop feeding an SEO loop that continues to grow. So that's a good example of use generated content which kind of feeds on itself and grows. So there's those two categories. Going back to the first category, if you only have a small handful of pages, the way to think about that is you certainly want to optimize those pages, then you want to start creating content that speaks to your audience beyond that. So you need a content strategy, whether it's a blog or creating new parts of your site that address questions that your audience might have. But generally speaking, I think there's an SEO play in any company and there's just different tactics, strategies, and approaches to get there.

**中文翻译:**
我一直觉得 LinkedIn 是一个绝佳的例子。它有一个病毒式循环：如果你还记得它刚开始的时候，每个人都会收到 LinkedIn 的邀请。这些邀请发出去，有人注册，有人不注册。但副产品是，当人们加入时，他们会创建一个精美的个人资料页，这个页面会被索引。这就像是一个病毒式循环在为 SEO 循环提供养分，使其持续增长。这就是 UGC 自我喂养并增长的一个好例子。所以就是这两类。回到第一类，如果你只有少量的页面，思考方式应该是：你肯定要优化这些页面，然后你需要开始创建除此之外能引起受众共鸣的内容。所以你需要一个内容策略，无论是博客还是在网站上创建新板块，来回答受众可能有的问题。但总的来说，我认为任何公司都有 SEO 的机会，只是实现目标的战术、策略和方法不同。

---

### [00:45:40] Lenny

**English:**
Awesome. I never thought of it that way, that there's kind of these two buckets. So the first bucket is like you don't have a ton of pages that naturally are generated as a part of your experience. And the second is you do. I guess in the second bucket I think of Reddit and Glassdoor and Quora, Tripadvisor, a great example, Pinterest. In the first bucket is the way to generate pages. Basically, it's editorially write content and have people write things for you. Is that generally the strategy?

**中文翻译:**
太棒了。我从未这样想过，原来可以分为这两个“桶”。第一个桶是你的产品体验不会自然产生大量页面；第二个桶则是会。我想第二个桶里有 Reddit、Glassdoor、Quora、TripAdvisor 和 Pinterest。在第一个桶里，生成页面的方式基本上是编辑撰写内容，或者让人为你写东西。这通常就是策略吗？

---

### [00:46:07] Luc Levesque

**English:**
There's different ways of doing it, but a good content strategy is a kind of tried and true approach. Definitely.

**中文翻译:**
有很多不同的方法，但一个好的内容策略确实是一个经得起考验的方法。绝对是。

---

### [00:46:13] Lenny

**English:**
And in that bucket of you don't naturally have a ton of pages, can you primarily grow through SEO? Or is SEO always going to be this minority channel and you have to find something else?

**中文翻译:**
在那个不会自然产生大量页面的桶里，你能主要通过 SEO 增长吗？还是说 SEO 永远只是一个次要渠道，你必须寻找其他增长点？

---

### [00:46:24] Luc Levesque

**English:**
No, it can be a big channel. This is also about creating content, but it's not your users creating the content. You have to go create the content and have some high quality answer to a question that's being asked on Google. I think one thing to keep in mind with SEO is entire industries are based off of single keywords. I remember when I was in the travel industry that literally companies were bought and sold based on one keyword rank. So it's not like, "Oh, it's a little bit of traffic." And I think this is a bit unintuitive with growth. A lot of people, they'll think of growth as linear or it's another channel, it's another thing. I mean, growth done right is exponential. It literally is company changing.

**中文翻译:**
不，它也可以成为一个大渠道。这同样关乎创建内容，只是不是由用户创建。你必须去创建内容，并针对 Google 上的问题提供高质量的答案。我认为关于 SEO 有一点需要记住：整个行业都可能建立在单个关键词之上。我记得我在旅游行业时，有些公司纯粹是根据某个关键词的排名被买卖的。所以这不仅仅是“哦，有一点流量”。我认为这在增长方面有点反直觉。很多人认为增长是线性的，或者只是另一个渠道、另一件事。但我的意思是，做对了增长就是指数级的，它真的能改变公司。

---

### [00:47:00] Luc Levesque

**English:**
When you're talking specifically about SEO, keep in mind the world is searching for that thing, targeted on that one keyword and likely you're clicking the number one search result. So getting that number one spot is not like, "Oh, that's a little bit of traffic." You can literally build an entire business around that first spot. So don't think that's... Well, maybe it is commonly known, I'm not sure, but it's definitely something that is non-obvious or intuitive I think to most people. And if you have an entire SEO team working on one keyword, I don't think that's crazy because a small number of keywords can define an entire industry or a business.

**中文翻译:**
当你专门谈论 SEO 时，请记住全世界都在搜索那个东西，瞄准那个关键词，而且用户很可能会点击排名第一的搜索结果。所以拿到第一名不仅仅是“哦，那是一点流量”，你完全可以围绕那个第一名建立一整个业务。所以不要觉得这……好吧，也许这是常识，我不确定，但我认为对大多数人来说，这绝对不是显而易见或直观的。如果你有一整个 SEO 团队只攻克一个关键词，我并不觉得这疯狂，因为少数几个关键词就能定义整个行业或一家企业。

---

### [00:47:37] Lenny

**English:**
Is there an example of that sort of situation when keyword's building a massive company?

**中文翻译:**
有没有那种靠一个关键词建立起庞大公司的例子？

---

### [00:47:41] Luc Levesque

**English:**
Yeah, I mean there's a lot I'm sure. I can speak to my own company that I sold to Tripadvisor. It was called TravelPod. It was a travel blogging website where you can think WordPress, but for travel, which I started earlier. It was the first site to do that. I made the mistake of not knowing SEO or growth before I sold the company. And so that was a great learning for me. When I went in, this is a story where we're looking to acquire another site and I thought the product was pretty poor. I remember talking to the founder and thinking... He'd asked me if we'd want to acquire it, and, "The product's terrible. Why would I want to acquire that?" He's like, "Yeah, they're 10 times bigger than you." And, "What?" That was when I realized, "Okay, we've been building a great product and great engineering culture and it is important, but you really need to know this growth stuff." So that's actually the moment I shifted to, "All right, we have to really know these growth levers."

**中文翻译:**
是的，我相信有很多。我可以谈谈我卖给 TripAdvisor 的那家公司，叫 TravelPod。它是一个旅游博客网站，你可以把它想象成旅游界的 WordPress，是我早些时候创办的。它是第一个做这种业务的网站。在卖掉公司之前，我犯了一个错误，就是不懂 SEO 或增长。那对我来说是一个深刻的教训。当时我们正考虑收购另一个网站，我觉得那个产品做得很烂。我记得和那个创始人聊天，他问我们想不想收购，我想：“产品这么烂，我为什么要买？”他说：“是啊，但他们的规模是你的 10 倍。”我当时就惊了：“什么？”就在那一刻我意识到：“好吧，我们一直在构建优秀的产品和优秀的工程文化，这固然重要，但你真的需要懂增长这门学问。”那实际上就是我转向“好吧，我们必须真正掌握这些增长杠杆”的时刻。

---

### [00:48:34] Luc Levesque

**English:**
In that space, the number one keyword was Travel Blog. And so owning that was a big deal and we did not own it. I think we ranked number two for a really long time. I can't remember if we got it in the end, but that's just one example where... And there was many, many travel businesses where I always loved looking at a business and trying to figure out, "What's their growth loop? How did they do that?" And it's not like, "Oh, it's a great business. It just grew." Most of the time it's price line crushed it at SEM. Facebook crushed it at a viral loop where you got tagged in a photo, you got an email and you had to go register because there's a photo of you somewhere you really want to see. Tripadvisor did a great job at SEO. In [inaudible 00:49:14], it's just one really strong channel that propelled the company forward. And in this case, it can literally come down to one keyword like we had at TravelPod.

**中文翻译:**
在那个领域，排名第一的关键词是“旅游博客”（Travel Blog）。拥有这个词意义重大，但我们当时没有拥有它。我想我们排在第二名很久。我不记得最后有没有拿到第一，但这只是一个例子。有很多旅游企业，我总是喜欢观察一家企业并试图弄清楚：“他们的增长循环是什么？他们是怎么做到的？”这不仅仅是“哦，这是一家伟大的企业，它就这么长大了”。大多数时候，比如 Priceline 在 SEM（搜索引擎营销）上做到了极致；Facebook 靠病毒式循环取胜——你被标记在照片里，收到邮件，然后你必须去注册，因为你想看那张有你的照片。TripAdvisor 在 SEO 上做得非常出色。通常，就是一个非常强大的渠道推动了公司的发展。在这种情况下，它真的可以归结为一个关键词，就像我们在 TravelPod 时那样。

---

### [00:49:20] Lenny

**English:**
So maybe it's a good time just to give a people a mental model of the different channels/loops that exist. So you've talked about SEO is one, paid search is one. What's the collection for people to think about? Usually as you said, one of the use is the primary source of growth for a company.

**中文翻译:**
那么，现在也许是给人们提供一个关于现存不同渠道/循环的心智模型的好时机。你提到了 SEO 是一个，付费搜索是一个。人们还应该考虑哪些渠道？通常正如你所说，其中一个是公司增长的主要来源。

---

### [00:49:38] Luc Levesque

**English:**
Yeah, there's a variety of them. I think you have to look at where the intent is right now. It does change over time, but you have social channels like TikTok, Instagram. Influencers are a great area to engage with there. You have SEO, you have search. I think ChatGPT is another upcoming one that we might want to talk about a little bit where I do think we've never seen that kind of growth for search before and that's a platform that we have to start thinking about how do we optimize for it. Google just announced there are recent changes. They're going to be putting in an AI box at the top, the searchers also, how do you optimize in a world where it's not so much about optimizing for the platform, but teaching the AI what you do and why you're the best in the world at it. So that's another whole area that we could talk about, but that's a big channel I think that that's growing.

**中文翻译:**
是的，有很多种。我认为你必须观察现在的“意图”在哪里。它会随时间而变化，但你有 TikTok、Instagram 等社交渠道，网红营销（Influencers）是其中一个很好的切入点。你有 SEO，有搜索。我认为 ChatGPT 是另一个新兴渠道，我们可能想聊聊，我认为我们以前从未见过搜索领域出现那样的增长，这是一个我们必须开始思考如何优化的平台。Google 刚刚宣布了最近的变化，他们将在顶部放置一个 AI 框。那么，在一个不再仅仅是针对平台优化，而是要“教 AI 你是做什么的、为什么你是世界上最棒的”的世界里，你该如何优化？这是我们可以讨论的另一个全新领域，但我认为这是一个正在壮大的大渠道。

---

### [00:50:29] Luc Levesque

**English:**
Viral loops are always a powerful thing if you can get them to work. That's more about psychology and channel optimization, where you want people to be incentivized to share the product that you have with their friends and then to have their friends come back and register. So you can have one viral loop, you can have secondary viral loops, you can bolt viral loops on your existing products. There's different ways of doing this. And then just backing up. When I think about growth, I don't think about a specific... It's not growth equals SEO and Instagram. For me, growth equals whatever it takes to move the needle. So I get this question all the time, "How do you build a growth team? What does a growth team do?" And I say whatever it takes. That could be zero to one building a new product. It could be M&A, it could be SEO, it could be social, it could be onboarding.

**中文翻译:**
如果你能让病毒式循环奏效，它们总是非常强大的。这更多关乎心理学和渠道优化，你希望人们有动力向朋友分享你的产品，然后让他们的朋友回来注册。你可以有一个主病毒循环，也可以有次级循环，或者在现有产品上嫁接病毒循环。有很多方法。退一步说，当我思考增长时，我不会想到某个具体的……增长并不等于 SEO 加 Instagram。对我来说，增长等于“为了推动指标增长所采取的一切手段”。所以我经常被问到：“你如何组建增长团队？增长团队是做什么的？”我会说，做任何需要做的事。这可能是从 0 到 1 构建新产品，可能是并购（M&A），可能是 SEO，可能是社交媒体，也可能是新用户引导。

---

### [00:51:15] Luc Levesque

**English:**
I think that's a better framework to look at. And then if you look at it through that lens, then partnerships easily folds into that where I've seen a lot of businesses get very big on just really clever partnerships, either strategic or broad kind of affiliate based partnerships. So there's a lot of channels. I definitely wouldn't restrict the scope of a growth team to just a small subset, but have a very wide funnel or at least strategy in terms of just test a lot of different things and go after the channels that work and pivot when it does, and then really lean into the one or two or three that really work because sometimes that's all it takes for business.

**中文翻译:**
我认为这是一个更好的思考框架。如果你透过这个镜头看，合作伙伴关系（partnerships）也很容易融入其中。我见过很多企业仅仅依靠非常聪明的合作伙伴关系就做得非常大，无论是战略性的还是广泛的联盟营销（affiliate）合作。所以渠道有很多。我绝对不会把增长团队的范围限制在一个小的子集里，而是要有一个非常宽的漏斗，或者至少在策略上测试很多不同的东西，追求有效的渠道，并在有效时进行转向，然后真正投入到那一两个或三个真正有效的渠道中，因为有时这就是业务成功所需的全部。

---

### [00:51:50] Lenny

**English:**
Well, you definitely nerd sniped me with the ChatGPT, so let's just spend some time there. I think this relates to just the general sense that SEO is always changing and it feels like this is an SEM I guess in this case too. And ChatGPT and Bard, I guess, is maybe the latest change. So what should we know there?

**中文翻译:**
你提到 ChatGPT 真的勾起了我的好奇心，那我们就聊聊这个吧。我认为这与“SEO 总是处于变化中”的大背景有关，而且感觉在 SEM 领域也是如此。ChatGPT 和 Bard 可能是最新的变数。关于这一点我们应该了解些什么？

---

### [00:52:05] Luc Levesque

**English:**
Yeah, I think we're all still trying to figure it out. I was at Google IO last week or the week before. As soon as I saw the search result with the big box of AI, answers at the top, having done this for so long, I immediately knew the impact that I think is about to come. I've seen this play out in travel where Google acquired ITA and did flight search and hotel search. Generally, it's great for users and great for Google and the search engines, but makes it a little bit difficult for the publishers and the sites that are adding value to the ecosystem through being ranked in search results.

**中文翻译:**
是的，我想我们大家都在摸索。上周或前周我参加了 Google I/O 大会。当我看到搜索结果顶部那个巨大的 AI 回答框时，作为一个做了这么久 SEO 的人，我立刻意识到即将到来的冲击。我在旅游行业见过类似的情况，当时 Google 收购了 ITA 并推出了航班搜索和酒店搜索。通常，这对用户、对 Google 和搜索引擎来说都很棒，但对于那些通过搜索排名为生态系统增加价值的发布商和网站来说，情况就变得有点困难了。

---

### [00:52:42] Luc Levesque

**English:**
So what we're about to see is basically Google, what they showed was a big box on top of the search results that answers the query directly. So if you think about that, that means that there's a lot of queries right now that users are clicking through down on the organic links and getting their answer there, which will be answered directly in the search result. We've seen this play out over the last five to 10 years where more and more answers are being shown at the top. Every time something changes, entire industries are disrupted or are changed. And I think that's going to happen again.

**中文翻译:**
所以我们即将看到的是，Google 展示的那个搜索结果顶部的巨大方框会直接回答查询。如果你仔细想想，这意味着目前用户点击下方自然搜索链接获取答案的许多查询，现在将直接在搜索结果中得到解答。在过去的 5 到 10 年里，我们已经看到了这种情况，越来越多的答案被显示在顶部。每当发生这种变化，整个行业都会被颠覆或改变。我认为这种情况会再次发生。

---

### [00:53:14] Luc Levesque

**English:**
So there's different types of keywords. There's transactional ones like e-commerce keywords with purchase intent. There's navigational ones where you're trying to get somewhere. And there's informational keywords, which is, "I have a question. I'm looking for an answer." It's pretty broad. It's a big area. I think that last category of keywords is particularly at risk. So if anybody listening to this is currently getting traffic on those, you should start thinking about what does that mean when things start changing. And I think the changes will be... We'll probably start seeing things shift to paid. You have to pay for that free traffic.

**中文翻译:**
关键词有不同的类型。有交易型（transactional）的，比如带有购买意图的电商关键词；有导航型（navigational）的，比如你想去某个网站；还有信息型（informational）的，即“我有一个问题，我在寻找答案”。信息型关键词范围很广，是一个巨大的领域。我认为最后一类关键词尤其危险。所以，如果听众中有人目前正从这些关键词获取流量，你应该开始思考当情况发生变化时这意味着什么。我认为变化将是……我们可能会看到流量向付费转移。你必须为以前免费的流量付费。

---

### [00:53:47] Luc Levesque

**English:**
The second one is there may just be a case where those keywords just don't get many clicks anymore. You might drop down to a very small number of clicks, if at all, because questions will get answered directly in the search results. So it's a big shift. We have to see how things land, but that's, I think over the next 12 to 24 months, if history repeats itself, we'll see that channel change. We've seen this play out in all the different channels. They kind of evolve generally. You can't blame the companies are doing what they have to do. ChatGPT is now 50% of my daily searches and not Google. So I think Google has to react and this is what we'll see. So from a growth perspective, definitely something to start to think about.

**中文翻译:**
第二点是，可能会出现这些关键词不再获得多少点击的情况。点击量可能会降到极低，甚至为零，因为问题直接在搜索结果中就解决了。这是一个巨大的转变。我们必须观察最终会如何落地，但我认为在接下来的 12 到 24 个月里，如果历史重演，我们将看到这个渠道的巨变。我们在所有不同的渠道都见过这种情况，它们通常都会进化。你不能责怪这些公司，他们只是在做必须做的事。ChatGPT 现在占了我日常搜索量的 50%，而不是 Google。所以我认为 Google 必须做出反应，这就是我们将看到的。所以从增长的角度来看，这绝对是需要开始思考的事情。

---

### [00:54:25] Lenny

**English:**
Super fascinating. I think about my newsletter and now Google suck it all up and just tell you all the answers. Great. Good news for me.

**中文翻译:**
太有意思了。我在想我的通讯，现在 Google 会把内容全部吸走，然后直接告诉用户答案。太棒了，对我来说真是个“好消息”。

---

### [00:54:33] Luc Levesque

**English:**
[inaudible 00:54:34].

**中文翻译:**
（听不清）。

---

### [00:54:39] Lenny

**English:**
Yeah. Yeah. And change is great. Things don't-

**中文翻译:**
是啊。变化是好事。事情不会——

---

### [00:54:41] Luc Levesque

**English:**
It's exciting. It's exciting. I'm just geeking out on growth a little bit, we haven't had a big platform change in a long time. So I'm like, "All right, cool. Let's go see what we can do here. How do you optimize this? How do you get listed if you can?" We're not sure where the placements will be, but that will be the new game.

**中文翻译:**
这很令人兴奋。我只是对增长有点痴迷，我们已经很久没有遇到重大的平台变革了。所以我心想：“好吧，太酷了。让我们看看能在这里做些什么。如何优化？如果可以的话，如何被列入其中？”我们还不确定展示位置会在哪里，但这将是新的游戏规则。

---

### [00:54:58] Lenny

**English:**
Yeah, there's actually a lennybot.com that is a GPT bot trained on my content that there's a newsletter post about how it was all built so you could build your own. And so I think my new goal is going to have to convince people to go to lennybot.com instead of Google. Wish me luck.

**中文翻译:**
是的，实际上有一个 lennybot.com，它是一个基于我内容训练的 GPT 机器人。我有一篇通讯文章介绍了它是如何构建的，这样你也可以构建自己的机器人。所以我认为我的新目标是说服人们去 lennybot.com 而不是 Google。祝我好运吧。

---

### [00:55:15] Luc Levesque

**English:**
Hey, you got to lean into it. Yeah, we have a shop.ai, this great AI-based shopping engine. And I'll tell you, I bought so much on it. It's so good. The more you use these technologies, the more you realize how good they are. And that's something biggest coming. It's not just, "Oh yeah, there's another change." I was summarizing the Google change is to some people and originally was thinking this is the biggest change in the last 10 years. And then when I reflected on the last 10 years, I thought this is actually the biggest change since the inception of Google actually. I don't think we've seen something as profound as what's coming. And you really need to get ready for it.

**中文翻译:**
嘿，你得拥抱它。是的，我们有 shop.ai，这是一个非常棒的基于 AI 的购物引擎。我告诉你，我在上面买了很多东西，它太好用了。你越使用这些技术，就越能意识到它们有多出色。而且，重大的变革即将到来。这不仅仅是“哦，又一个变化”。我曾向一些人总结 Google 的变化，最初我认为这是过去 10 年最大的变化。但当我反思过去 10 年时，我认为这实际上是自 Google 诞生以来最大的变化。我不认为我们见过比即将到来的变革更深刻的事情。你真的需要为此做好准备。

---

### [00:55:52] Lenny

**English:**
Yeah, I've been using ChatGPT for helping me with interview questions actually, and once in a while there's like a really good one.

**中文翻译:**
是的，我实际上一直在用 ChatGPT 帮我准备面试问题，偶尔它会给出一个非常棒的问题。

---

### [00:55:59] Luc Levesque

**English:**
Oh, that's cool.

**中文翻译:**
噢，那很酷。

---

### [00:56:00] Lenny

**English:**
So thank you ChatGPT, bringing me good things also. Maybe one more question along these lines around kind of connecting advisorship in SEO. Would you suggest when you're starting to think about SEO, starting to invest in SEO, you might be listening to this feeling like, "I got to think about SEO," does it make sense to bring on, say, SEO advisor like you? I know you're not available currently, but other folks like you or are an agency that is really good at this stuff or bring on someone full time? Do you have any kind of frameworks for thinking about which direction to go?

**中文翻译:**
所以谢谢 ChatGPT，也给我带来了好东西。关于将顾问身份与 SEO 联系起来，也许还有一个问题。如果你开始考虑 SEO、开始投资 SEO，听众可能会觉得“我得考虑 SEO 了”，那么聘请一位像你这样的 SEO 顾问是否有意义？我知道你目前没空，但找像你这样的人，或者找一家擅长此道的代理机构，还是招一个全职员工？你有没有什么框架来决定该往哪个方向走？

---

### [00:56:30] Luc Levesque

**English:**
It's hard for an agency or a pure advisor without internal help to do a really good job without internal talent at the center. So I would say I would start with just hire somebody internally and give them the mandate and incentivize them correctly to go and own this channel. Even if they don't know SEO, my advice would be get an engineer, get somebody who is just a relentless doer who wants to learn this and surround them with great advisors that I've just seen that work really well.

**中文翻译:**
如果没有内部人员的配合，代理机构或纯粹的顾问很难做好工作。所以我建议先从内部招聘开始，给他们授权并正确激励他们去负责这个渠道。即使他们不懂 SEO，我的建议是找一个工程师，找一个想学习这方面知识的、坚持不懈的执行者，然后让他们身边围绕着优秀的顾问。我见过这种模式运作得非常好。

---

### [00:56:59] Luc Levesque

**English:**
There are some good agencies out there. Agencies will be working with multiple companies, so it's a little bit harder to get the same impact from an agency. It can work sometimes. But my preference is generally a last resort would be an agency. And I'd much rather have somebody who's internal who knows the business, who knows the keywords, who can have the knowledge internally inside the company permanently and help grow a team around them and have succession in place and a proper team so that you're not too dependent on this one person. But that would be my go-to. And then if you're really stuck, you can use agencies, but my default would be having somebody internal supplemented with agencies if you have to. Sorry, SEO is very specific. I mean, it's a very tight channel that knowing certain things about it can have a big impact. I think you do want people that have that experience that can bring that in from the outside to augmenting internal teams. It'll take a really long time to learn it.

**中文翻译:**
市面上确实有一些不错的代理机构。但代理机构同时服务多家公司，所以很难从他们那里获得同样的影响力。有时可行，但我的偏好是：代理机构通常是最后的手段。我更希望有一个内部人员，他了解业务，了解关键词，能将知识永久留在公司内部，并帮助围绕自己建立团队，建立继任计划和完善的团队，这样你就不会过度依赖某一个人。这是我的首选方案。如果你真的卡住了，可以使用代理机构，但我的默认选项是内部人员，必要时辅以代理机构。SEO 非常专业，它是一个非常严密的渠道，了解其中的某些门道会产生巨大影响。我认为你确实需要有经验的人从外部把这些知识带进来，以增强内部团队。毕竟学习它需要很长时间。

---

### [00:58:01] Lenny

**English:**
Awesome. I was going to ask that. So you ideally want to find someone that's done it before that isn't just a relentless learner, but is that plus, has done SEO in the past?

**中文翻译:**
太棒了。我正想问这个。所以理想情况下，你想找一个以前做过的人，他不只是一个坚持不懈的学习者，还得加上过去做过 SEO 的背景？

---

### [00:58:08] Luc Levesque

**English:**
Oh, yeah. Ideally, you hire an amazing SEO person who can bring internal. Second would be somebody amazing who can get things done, surround them with advisors. And then in my stack rank, the third would be agencies.

**中文翻译:**
噢，是的。理想情况下，你雇佣一个非常棒的 SEO 专家并将其内部化。其次是找一个能干成事的优秀人才，并为他配备顾问。在我的优先级排序中，第三才是代理机构。

---

### [00:58:20] Lenny

**English:**
Awesome. And then the other kind of common issue with SEOs, it takes a long time to show impact. Do you have just a rule of thumb of just give them this much time to see if they can make an impact?

**中文翻译:**
太棒了。SEO 还有一个常见问题：需要很长时间才能看到效果。你有没有什么经验法则，比如给他们多长时间来看看是否能产生影响？

---

### [00:58:29] Luc Levesque

**English:**
I'd say a few things. I'd say if you already have content and pages that are pretty good and getting a decent amount of traffic, it doesn't necessarily have to take a long time. So that would be my first reaction. It can take a long time. Generally, it takes a long time when you have to build new content. So the way to think about Google is it is going to take your content, it's going to show it to its users, people that are searching, and it's going to determine which piece of content is the best to ranked highly. It's not just about little tricks and links and keyword ratios. Those days are over. Those do matter, but it's not purely about that. And if you have a new piece of content, it takes time for Google to build enough trust to say, "Okay, I'm going to start showing this to users now" and then start collecting user feedback and then rank it appropriately. That can take some time.

**中文翻译:**
我想说几点。首先，如果你已经有了相当不错的内容和页面，并且有一定的流量，那不一定需要很长时间。这是我的第一反应。通常，当你需要构建新内容时，确实需要很长时间。思考 Google 的方式应该是：它会获取你的内容，展示给搜索的用户，并决定哪篇内容最适合排在前面。这不仅仅是关于小技巧、链接和关键词密度，那些日子已经过去了。这些确实重要，但不仅仅是这些。如果你有新内容，Google 需要时间建立足够的信任，才会说：“好吧，我现在开始向用户展示这个，”然后开始收集用户反馈，最后给出合适的排名。这确实需要一些时间。

---

### [00:59:14] Luc Levesque

**English:**
But if you have existing pages that are ranking eight and they're already on the first page, it doesn't always happen. But I've certainly seen it, in fact more common than not that you could have sometimes hundreds of percentages of lift very quickly. And it depends what you're starting with, is probably the right way to think about it. So if I'm trying to summarize it, I would say 12 months is probably max. If you can't see impact in 12 months, there's something wrong. If you have existing content, it could happen pretty early. It could happen on day one. Actually I've seen that happen. If you have to build new parts of the site, it can take months. I've seen that happen in companies I've worked with where I think it would be like a quarter, we had to wait till we saw a big lift. So it's somewhere between three to 12 months.

**中文翻译:**
但如果你现有的页面排名第八，已经在第一页了，虽然不总是发生，但我确实见过——事实上还挺常见的——你有时可以很快获得百分之几百的提升。这取决于你的起点，这可能是正确的思考方式。所以如果让我总结一下，我会说 12 个月大概是上限。如果你在 12 个月内看不到影响，那肯定有问题。如果你有现有的内容，效果可能很早就显现，甚至在第一天，我确实见过。如果你必须构建网站的新部分，可能需要几个月。在我合作过的公司中，我见过需要等待大约一个季度才能看到大幅提升的情况。所以，时间通常在 3 到 12 个月之间。

---

### [01:00:05] Lenny

**English:**
Final topic/final question. You've had a truly incredible career. You've worked with incredible companies, incredible leaders. I'm looking at your site here in a site window and you're like, here's a picture of you and Zuck. Here's a picture of you and Toby from Shopify, and there's more. I'm curious what you believe has been key to your success and your career success that you suggest listeners who want to have some measure of similar success do.

**中文翻译:**
最后一个话题，最后一个问题。你的职业生涯真的非常精彩，与顶尖的公司和领导者合作过。我正在看你的网站，旁边窗口里有你和扎克伯格的合影，还有你和 Shopify 的 Tobi 的合影，还有很多。我很好奇，你认为你个人和职业成功的关键是什么？对于那些想要获得类似成功的听众，你有什么建议？

---

### [01:00:36] Luc Levesque

**English:**
It's probably a bunch of things we could talk about here. Yeah, this is the obvious thing is I think you've just got to love what you do. You got to work hard. You have to have impact. Certainly at the end of the day in growth, that's all that will matter. If I think back to specific things that I do though to pick one thing that's been very important for me throughout my journey is the art of self-reflection. And coaches. I've had coaches my whole career. But the macro theme is you're constantly iterating, experimenting, and becoming the best you can be in your career also as a dad and as a husband, and of course for your own personal health. But that reflection is so important. I've leveraged many, many different coaches over the years and now do a lot of self-reflection through a morning routine that I have and that I've been doing for quite some time that has been a big unlock for me.

**中文翻译:**
这可能涉及很多方面。显而易见的是，你必须热爱你所做的事情，必须努力工作，必须产生影响力。在增长领域，最终这才是最重要的。但如果回想我所做的具体事情，挑出一件对我整个旅程至关重要的事情，那就是“自我反思的艺术”。还有教练，我整个职业生涯都有教练。宏观主题是：你不断迭代、实验，在职业生涯中成为最好的自己，同时作为父亲、丈夫，当然还有你个人的健康。反思太重要了。多年来我请过很多不同的教练，现在我通过坚持了很久的早间例行习惯（morning routine）进行大量的自我反思，这对我来说是一个巨大的突破。

---

### [01:01:32] Luc Levesque

**English:**
The biggest, most important part of that morning routine is dedicating an hour aside to really think about, "What's going well? What's not going well? What am I screwing up? Well, why am I screwing it up?" Which is often more important than, "What am I screwing up?" And of course, "What am I going to do about it?" But as long as you're learning and iterating every day, then you're just making constant progress towards your goals. It's something I do that I love doing. I love thinking. So I literally can just sit there and think for hours actually. I have a dashboard on all the areas that I'm focusing on with red, yellow, green, and just constantly revving on what am I working on improving, what am I doing, what experiments am I running and where am I doing well and where am I not doing well and how can I be better in all areas of my life, including being a leader. There's a lot of different things to it, but I think that's really important and something that I've learned over the years that is probably the most valuable to have as a skill.

**中文翻译:**
早间例行习惯中最重要的一部分是专门留出一小时来深入思考：“什么进展顺利？什么不顺利？我在哪里搞砸了？为什么会搞砸？”这通常比“我搞砸了什么”更重要。当然还有“我打算怎么办？”只要你每天都在学习和迭代，你就在朝着目标不断前进。这是我热爱做的事情。我喜欢思考，我真的可以坐在那里思考好几个小时。我有一个仪表盘，记录了我关注的所有领域，用红、黄、绿标示，不断审视我在改进什么、在做什么、在运行什么实验，哪里做得好，哪里做得不好，以及如何在生活的各个领域（包括作为领导者）变得更好。这涉及很多方面，但我认为这非常重要，这是我多年来学到的最有价值的技能。

---

### [01:02:32] Lenny

**English:**
I definitely want to spend more time on this. So you said you sit for an hour reflecting on what's going well, what's not going well. Is there more you can share about how you accomplish that, how you find time to do this for an hour?

**中文翻译:**
我肯定想在这上面多花点时间。你说你坐一小时反思什么顺利、什么不顺利。关于你是如何做到的，以及如何找出一小时的时间来做这件事，你还能分享更多吗？

---

### [01:02:43] Luc Levesque

**English:**
Yeah, it sounds crazy when you say it, but I do. So I wake up at 5:00. I work out. So I do cardio, I do some exercise. There's this great book called Spark, which is all around the neuroscience of exercise and I really learned a lot from that in terms of having this great morning routine that really boots you up. I kind of call it my bootloader. When I start in the day, if I go through my bootloader, I have just a much better day.

**中文翻译:**
是的，说出来可能觉得疯狂，但我确实这么做。我 5 点起床，然后锻炼。我会做有氧运动，做一些练习。有一本很棒的书叫《运动改造大脑》（Spark），讲的是运动的神经科学，我从中受益匪浅，建立了一套能让你精神焕发的早间例行习惯。我把它称为我的“引导程序”（bootloader）。当我开始新的一天时，如果我运行了我的引导程序，我这一天会过得好得多。

---

### [01:03:09] Luc Levesque

**English:**
So exercise, stretching, meditation, and then I do a cold plunge now. So I do a bunch of different things. But then I do some reading, but I do carve aside one hour where I go through... And this is probably important and it's where I've landed, but structured self reflections. That's why I have this dashboard. I have certain areas that I think about what's going well, what's not. I track all the experiments I'm writing. I'm just really passionate about if you're going to do something, try to do it as best as you can. This is a habit that has allowed me to sharpen my skills in certain areas.

**中文翻译:**
包括锻炼、拉伸、冥想，现在我还会做冷水浴。我做很多不同的事情。然后我会读点书，但我会专门留出一小时来进行……这可能很重要，也是我最终坚持下来的方式：结构化的自我反思。这就是为什么我有那个仪表盘。我有特定的领域来思考什么好、什么不好。我记录我正在进行的所有实验。我只是非常热衷于：如果你要做一件事，就尽力做到最好。这个习惯让我磨练了特定领域的技能。

---

### [01:03:47] Lenny

**English:**
What are some of these things you're working on? If you can share what's on this dashboard, how can people imagine what this might be?

**中文翻译:**
你正在处理的这些事情有哪些？如果你能分享仪表盘上的内容，人们该如何想象它是什么样子的？

---

### [01:03:53] Luc Levesque

**English:**
So there's a lot of personal stuff on it, but it literally is broken down between being a better friend, better husband, better dad, and then better leader. And so on the personal side, I've been known to work a lot of times. Balance is always hard to find. From being a dad and then thinking about how to be better there, I realized about six months ago that I've never actually asked for feedback on how I'm doing. So I asked my kids six months ago, I asked both of them independently, "What's one thing I can do to do more of or do less of to be a better dad?" And they were kind of caught off guard by it. My son's 15 and my other son is 12. And I said, "Take some time to think about it." And after about a month, my son came back and said, "Dad, I got one." He said, "I want to spend more time with you."

**中文翻译:**
上面有很多私人的内容，它被细分为：成为更好的朋友、更好的丈夫、更好的父亲，以及更好的领导者。在个人生活方面，我以工作狂著称，平衡总是很难找到。作为一名父亲，在思考如何做得更好时，我大约六个月前意识到，我从未真正征求过关于我表现的反馈。所以六个月前我问了我的孩子们，我分别独立地问他们：“为了成为更好的爸爸，我有什么可以多做或少做的一件事？”他们当时有点措手不及。我儿子 15 岁，另一个 12 岁。我说：“花点时间考虑一下。”大约一个月后，我儿子回来说：“爸爸，我想到了。”他说：“我想花更多时间陪你。”

---

### [01:04:53] Luc Levesque

**English:**
So that was very helpful for me to hear. I'm big on routines and habits to make sure that things that you want to do are repeatable and it's not one-off things. So ever since that day, I've now have a daddy date if you want to call it. But every two weeks we do one-on-one time together with each of the boys. They get to pick what we do just so we have that consistent, whether it's dinner or play basketball in the front. But it's all about feedback. So that's one example on the personal side.

**中文翻译:**
听到这个对我非常有帮助。我非常看重例行程序和习惯，以确保你想做的事情是可重复的，而不是一次性的。所以从那天起，我现在有了所谓的“爸爸约会”。每两周，我会分别和每个儿子进行一对一的相处。他们可以挑选我们做什么，这样我们就有了这种持续的互动，无论是吃晚饭还是在门前打篮球。这一切都关乎反馈。这是个人生活方面的一个例子。

---

### [01:05:27] Lenny

**English:**
This reminds me of a tweet I just saw where someone said that the only people that are going to remember that you worked late for many nights is your kids.

**中文翻译:**
这让我想起我刚看到的一条推文，有人说：唯一会记得你很多个晚上加班到很晚的人，是你的孩子。

---

### [01:05:37] Luc Levesque

**English:**
Wow. Wow. That's deep. I like that a lot.

**中文翻译:**
哇。哇。这太深刻了。我很喜欢这句话。

---

### [01:05:43] Lenny

**English:**
As a soon to be parent, that's going to stick with me.

**中文翻译:**
作为一个即将成为父母的人，这句话会一直印在我脑海里。

---

### [01:05:46] Luc Levesque

**English:**
Wow, I like that a lot. So it's tough, right? It's tough to balance it all out. It's very difficult because you want excel at everything you do in life. So that reflection helps, be it check-in as well of how am I doing in all these areas? And that I find the color coding is helpful for that too, of just doing a bit of a gut check and asking for that feedback.

**中文翻译:**
哇，我真的很喜欢这句话。这很难，对吧？平衡一切非常困难，因为你想在生活的方方面面都做到卓越。所以反思很有帮助，它也是一种检查：我在所有这些领域做得怎么样？我发现颜色标记对此也很有帮助，可以进行直觉检查并寻求反馈。

---

### [01:06:06] Lenny

**English:**
So it also makes me think about, I was watching a Jeff Bezos interview and ask him what his morning routine was and he said that he just likes to putter around. he likes to just sit around, talk to his kids, read the newspaper. He doesn't book any meetings in the morning. He just finds he just needs a little flex time at the beginning.

**中文翻译:**
这也让我想起我看过的一个杰夫·贝佐斯的采访，问他的早间习惯是什么，他说他只是喜欢闲逛。他喜欢坐着，和孩子们聊天，看报纸。他早上不安排任何会议。他发现自己在一开始只需要一点灵活的时间。

---

### [01:06:22] Luc Levesque

**English:**
Totally. Before I became a dad, I read somewhere that one of the most impactful things you can do as a father is just be there for dinner every night. So I have been there for 15 years every single night. But it was a good reminder it's not enough. Having dinner is important with your family, but in our case there's more you can do. And just getting that feedback and doing some reprioritization is always important.

**中文翻译:**
完全正确。在我成为父亲之前，我在哪里读到过，作为父亲最有影响力的事情之一就是每天晚上都回家吃晚饭。所以我 15 年来每天晚上都在。但这是一个很好的提醒：这还不够。和家人一起吃晚饭很重要，但在我们的情况下，你还可以做得更多。获得反馈并重新排列优先级总是很重要的。

---

### [01:06:46] Lenny

**English:**
Speaking of dinners, and maybe just as a last question, I know you do this really interesting thing where you have dinners with interesting people. You just kind of invite them to your house. I don't know if interesting is the right way to describe it, but just kind of interesting people, prominent people. Can you just talk about what that is and what you think about and the benefits of doing something like that?

**中文翻译:**
说到晚餐，也许作为最后一个问题，我知道你做了一件非常有趣的事情，就是和有趣的人共进晚餐。你邀请他们去你家。我不知道用“有趣”来形容是否准确，但就是一些有趣的人、杰出的人。你能谈谈那是怎么回事，你是怎么想的，以及这样做有什么好处吗？

---

### [01:07:04] Luc Levesque

**English:**
I think interesting is the right way to think about it.

**中文翻译:**
我认为用“有趣”来形容很贴切。

---

### [01:07:07] Luc Levesque

**English:**
I started this when I was in Ottawa with a bunch of founders there. It's become one of my favorite things to do. Honestly, it's like the bright spot in my month that, I call them guilds. So the word guild is with the builders. That's how it originally started. So Guild Night is what I call it. The idea is basically all interesting people doing interesting things actually want to spend time with each other. That's why I'm actually surprised more people don't do this. But I'll basically have interesting people come, usually five or six. We'll sit around talking about specific topics. So I do one for consumer product, I do one for SEO, I do one for growth leaders and just have really smart, interesting people come and we'll talk about different topics that are relevant.

**中文翻译:**
我在渥太华时就开始这么做了，当时是和一群创始人一起。这成了我最喜欢做的事情之一。老实说，这是我每个月的亮点。我称之为“公会”（guilds）。“公会”这个词是和建设者们在一起的意思，最初就是这样开始的。所以我称之为“公会之夜”。核心理念是：所有做着有趣事情的有趣的人，其实都想和彼此待在一起。我其实很惊讶为什么没有更多人这样做。我基本上会邀请有趣的人来，通常是五六个。我们坐在一起讨论特定的主题。我会为消费级产品办一场，为 SEO 办一场，为增长领导者办一场，邀请非常聪明、有趣的人来，讨论相关的不同话题。

---

### [01:07:57] Luc Levesque

**English:**
Sometimes we'll pick a topic, so we'll have a group and then we'll say, "Hey, we want to talk about AI." So one of the advantages of being in the Bay Area is you can find three or four people that likely wrote some of the core code in Google or in AI, and then they'll join. People want to meet. People want to get together and have these conversations. So it's very exhilarating. I learn a ton. It's a lot of fun. I don't know why more people don't do it. And it's a bit of work to organize, but it's also just tactically been a great way to meet fascinating people. It's helped a lot for recruiting, for if you need a back channel. Now you know all these people that are in different industries. But business aside, they're very valuable business wise, but they're just a lot of fun and they've become some of my favorite things that I do.

**中文翻译:**
有时我们会选一个主题，比如大家聚在一起说：“嘿，我们想聊聊 AI。”在湾区的一个优势是，你可以找到三四个可能编写了 Google 或 AI 核心代码的人，然后他们就会加入。人们渴望见面，渴望聚在一起进行这些对话。这非常令人振奋，我学到了很多，也很有趣。我不知道为什么没有更多人这样做。组织起来确实需要花点功夫，但从战术上讲，这也是结识迷人人才的绝佳方式。它对招聘很有帮助，如果你需要背景调查（back channel），现在你认识了各行各业的人。抛开业务不谈，它们在业务上非常有价值，但它们本身就很有趣，已经成为我最喜欢做的事情之一。

---

### [01:08:43] Luc Levesque

**English:**
I'm really surprised why more people don't do it because I think especially now that everybody's remote and we're working from home, or most people are, it's more valued than ever. So it's something I'm looking forward to continuing and always actually through my morning reflection, thinking about what are new ones I can spin up who are interesting people that we want to break bread with. I do think it's important that it's done at your house. If anybody's thinking of starting this, you can do it at a restaurant, but there's something about being in your home or being in somebody's home, five or six people having a great conversation about a topic that's mutually interesting. I think everybody values it and it adds a lot of spice to life. I think it's really important.

**中文翻译:**
我真的很惊讶为什么没有更多人这样做，因为我认为特别是在现在大家都远程办公、居家办公（或者大多数人是这样）的情况下，这种交流比以往任何时候都更有价值。所以我期待着继续做下去，而且在我的早间反思中，我总是在想我可以发起哪些新的聚会，有哪些有趣的人是我想一起共进晚餐的。我认为在家里举办很重要。如果有人想开始尝试，你可以在餐厅做，但在家里或在某人家里，五六个人围绕一个共同感兴趣的话题进行深入交谈，那种感觉是不一样的。我认为每个人都珍惜这种机会，它为生活增添了很多色彩。我认为这非常重要。

---

### [01:09:23] Lenny

**English:**
Any other tactical tips for making one of these happen? So you do it at your home, you cater. How many people? How long? Anything else you want to share there?

**中文翻译:**
关于如何举办这种聚会，还有什么战术性的建议吗？在家里办，叫外卖。多少人？持续多久？还有什么想分享的吗？

---

### [01:09:31] Luc Levesque

**English:**
Yeah, so I think the most I've done is 10. That's a bit too much. Six seems to be perfect, six to eight, eight at the max. I do get a catered so you don't have to worry about cooking. The topic, something like a topic that it's common so that everybody can rally around. I do think it's important, like I mentioned, doing it at home. Usually we start around 6:00, we go till 9:00 or 10. It's just been a really good thing that I've learned over time is a really good thing to do to just make for a better life, frankly. Make richer life with some great friends.

**中文翻译:**
是的，我最多办过 10 个人的，那有点太多了。6 个人似乎最完美，6 到 8 个，最多 8 个。我会叫外卖，这样你就不用担心做饭了。主题要选一个通用的，这样大家都能参与进来。正如我提到的，在家里办很重要。通常我们 6 点左右开始，一直持续到 9 点或 10 点。随着时间的推移，我发现这真的是一件能让生活变得更好的事情，坦白说，它让生活和友谊变得更丰富。

---

### [01:10:08] Lenny

**English:**
And when we say cater, it's just ordering in basically, right? It's not that-

**中文翻译:**
我们说“叫外卖”（cater），基本上就是点餐送过来，对吧？不是那种——

---

### [01:10:11] Luc Levesque

**English:**
Yeah, you can just DoorDash some food so you don't have to worry about cooking. I'm sure there's other things. I've never really deeply thought about it, but in terms of what are the specific things, I've evolved it over time, but I don't cook anyways, so it would be terrible if I cooked. So this is much easier to do it this way. And as long as you're inviting kind of interesting people, everybody's going to want to come and spend some time and bring some bread.

**中文翻译:**
是的，你可以直接用 DoorDash 点些吃的，这样就不用担心做饭了。肯定还有别的细节，我没深入思考过，但具体做法是随时间演变的。反正我也不会做饭，如果我做饭那简直是灾难。所以这样做要容易得多。只要你邀请的是有趣的人，大家都会愿意来聚聚，共度时光。

---

### [01:10:33] Lenny

**English:**
Well, with that, we've reached our very exciting lightning round. I've got six questions for you. Are you ready?

**中文翻译:**
好，接下来进入我们非常刺激的闪电问答环节。我有六个问题要问你。准备好了吗？

---

### [01:10:39] Luc Levesque

**English:**
I think so.

**中文翻译:**
我想我准备好了。

---

### [01:10:40] Lenny

**English:**
I think you are. Well, question one. What are two or three books that you've recommended most to other people?

**中文翻译:**
我觉得你准备好了。好，第一个问题：你向别人推荐最多的两三本书是什么？

---

### [01:10:47] Luc Levesque

**English:**
So there's one that I've already mentioned, which is Spark. It's the neuroscience of exercise. That's a great book. It's not one of these exercise to stay fit and to live longer. This is really about, frankly, if you exercise and do it in a specific way, they have a kind of blueprint they lay out, it's good for just cognition and kind of horsepower and performance. So that's been a really important one and has been a big part of me building on my morning routine. The second one is when I picked up I think about a year ago or six months, and I recommended it, gee, I don't know, at least to a couple hundred people now because I recommended it to my team. It's called Smart Brevity. Have you heard of this one?

**中文翻译:**
一本是我已经提到的《运动改造大脑》（Spark）。它讲的是运动的神经科学。这是一本伟大的书，它不是那种教你为了健身或长寿而运动的书，而是关于如果你以特定的方式运动（他们提供了一套蓝图），它对认知、大脑马力和表现都有好处。所以这对我来说非常重要，也是我建立早间习惯的重要部分。第二本是我大约一年前或六个月前读的，我已经向至少几百人推荐过了，因为我把它推荐给了我的团队。书名叫《精简表达》（Smart Brevity）。你听说过吗？

---

### [01:11:31] Lenny

**English:**
No, but I love the sound of it.

**中文翻译:**
没听过，但听起来很棒。

---

### [01:11:33] Luc Levesque

**English:**
I've always been big on writing crisply and being very tight and not having three-page memos that you're sending off. Especially now that we're remote and we're all doing slack and email and different ways of messaging, how tightly you communicate, how crisp your communication is really important for frankly you getting your point across and also for the other person who's probably digesting a hundred of these messages. So this book is... It's a book on how to do that. It breaks down how to write crisply and the different parts of it. I've definitely seen improvements in the team since I've passed around. So that's a great book frankly for anybody, work or personal because we're writing so much and communication is so key. So that's the second one. The third one is a golden oldie. It's one that I've read many, many times and I recommend from a growth perspective. This one youlikely heard of, it's Influence by Cialdini.

**中文翻译:**
我一直非常看重写作的简洁有力，不要发那种三页纸的长篇备忘录。特别是在现在远程办公、大家都在用 Slack、邮件和各种消息工具的情况下，你沟通得多么紧凑、多么清晰，对于准确表达观点以及对于那些每天要处理上百条消息的人来说都非常重要。这本书就是教你如何做到这一点的。它分解了如何简洁写作及其各个组成部分。自从我把这本书传阅后，我确实看到了团队的进步。坦白说，这对任何人（无论是工作还是生活）都是一本好书，因为我们写得太多了，而沟通又是如此关键。这是第二本。第三本是一本经典老书，我读过很多很多次，并从增长的角度推荐它。这本你肯定听过，就是西奥迪尼的《影响力》（Influence）。

---

### [01:12:28] Lenny

**English:**
I got it back on my bookshelf there.

**中文翻译:**
就在我后面的书架上。

---

### [01:12:30] Luc Levesque

**English:**
Yeah, it's a great book, and it's because it's really the underpinning of so many different product and growth principles that you can apply. So that's just a classic that is good to reread at least once a year. So those are three books.

**中文翻译:**
是的，这是一本伟大的书，因为它真的是你可以应用的许多产品和增长原则的基础。这是一本值得每年至少重读一次的经典。这就是那三本书。

---

### [01:12:42] Lenny

**English:**
I'm going to extend this a little bit. I'm going to add two books that are building on your two books, or the first two books, I guess. One is Peter Attia just wrote a book called Outlive. That is-

**中文翻译:**
我想扩展一下。我想在你的两本书（或者说前两本）的基础上再加两本。一本是 Peter Attia 刚写的《长寿》（Outlive）。那是——

---

### [01:12:50] Luc Levesque

**English:**
I've got to read it.

**中文翻译:**
我得读读。

---

### [01:12:51] Lenny

**English:**
Okay. And it's exactly the same kind of premise of just how important exercise is. I think there's a quote in there of just the only thing proven to help you live longer is exercise. And then Smart Brevity, there's another book that I'd recommend if people want more on though on this topic called Nobody Wants to Read Your Shit.

**中文翻译:**
好的。它的前提完全一样，就是强调运动有多重要。书中有一句话说，唯一被证明能帮你长寿的事情就是运动。关于《精简表达》，如果人们想深入了解这个话题，我还推荐另一本书，叫《没人想看你写的烂东西》（Nobody Wants to Read Your Shit）。

---

### [01:13:07] Luc Levesque

**English:**
[inaudible 01:13:08].

**中文翻译:**
（听不清）。

---

### [01:13:08] Lenny

**English:**
And it's by the guy that wrote the War of Art and Bagger Vance. I forget his name off the top of my head, but it's like, "Nobody wants to read your shit. Here's what you need to do for people to want to read anything you're writing."

**中文翻译:**
那是写过《艺术之战》（War of Art）和《重返荣耀》（Bagger Vance）的那位作者写的。我一下子忘了他的名字，但书的核心就是：“没人想看你写的烂东西。如果你想让人读你写的东西，你需要这样做。”

---

### [01:13:23] Luc Levesque

**English:**
Yeah. We want to scan. We want to read. Yeah, that's great. I'll pick that one up. Nobody Wants to Read Your Shit.

**中文翻译:**
是的。我们只想扫视，我们想阅读。太棒了，我会去买那本《没人想看你写的烂东西》。

---

### [01:13:27] Lenny

**English:**
Exactly. What a title.

**中文翻译:**
没错，这书名起得真绝。

---

### [01:13:29] Luc Levesque

**English:**
That's a great title.

**中文翻译:**
书名起得太棒了。

---

### [01:13:31] Lenny

**English:**
All right, back on track. What is a favorite recent movie or TV show that you've really enjoyed?

**中文翻译:**
好，回到正轨。最近有什么你非常喜欢的电影或电视节目吗？

---

### [01:13:36] Luc Levesque

**English:**
I don't watch TV much and I haven't really watched any movies in a while. But I do watch a lot of podcasts on YouTube. Andrew Huberman has got, of course, a great series. I've watched I think everyone he puts out, so I don't know if that counts, but that's-

**中文翻译:**
我不怎么看电视，也有一段时间没看电影了。但我会在 YouTube 上看很多播客。Andrew Huberman 当然有一个非常棒的系列，我想他出的每一集我都看了。我不知道这算不算，但那是——

---

### [01:14:01] Lenny

**English:**
Absolutely

**中文翻译:**
当然算。

---

### [01:13:50] Luc Levesque

**English:**
Okay. So I watched that. And then of course the All-In Podcast is always fun, so I make sure to watch those when they come out as well. A lot of fun and informative. So those are my two, I would say.

**中文翻译:**
好的。所以我看那个。当然，《All-In Podcast》也总是很有趣，所以每当他们更新时我也一定会看。非常有趣且信息量很大。这就是我的两个选择。

---

### [01:14:01] Lenny

**English:**
Great picks. What is a favorite interview question that you like to ask?

**中文翻译:**
很棒的选择。你最喜欢问的面试问题是什么？

---

### [01:14:06] Luc Levesque

**English:**
Teach me something about growth that I don't already know. Because... and you could apply this to engineering product, any other area, because it really gives you a sense of what this person thinks is the top of the stack in terms of the smartest thing they know. Whether you know it or not is irrelevant. But sometimes you actually do end up learning some stuff. But it's my favorite question because you can really engage in a conversation around, "Okay, the thing you think is so unique that maybe you've come up with this learning yourself or you've created this tactic and then it gives you a sense of how much they know the craft." So that's my favorite question.

**中文翻译:**
“教我一些关于增长但我还不知道的事情。”因为……你可以把这应用到工程、产品或任何其他领域。因为它能让你感觉到这个人认为自己掌握的最聪明、最顶尖的知识是什么。你是否真的知道并不重要，但有时你确实能学到一些东西。这是我最喜欢的问题，因为你可以围绕“你认为如此独特的东西”展开对话，也许是他们自己总结出的教训，或者是他们创造的战术，这能让你了解他们对这门手艺的掌握程度。

---

### [01:14:42] Lenny

**English:**
What is a favorite product that you've recently discovered that you just really love?

**中文翻译:**
你最近发现并非常喜欢的某个产品是什么？

---

### [01:14:46] Luc Levesque

**English:**
I've got a cold plunge that I bought that I love. So it's called the Renew Cold Plunge. It's cold but super convenient and I do that every morning and I just love it.

**中文翻译:**
我买了一个冷水浴池（cold plunge），非常喜欢。它叫 Renew Cold Plunge。虽然很冷，但超级方便，我每天早上都泡，非常喜欢。

---

### [01:14:58] Lenny

**English:**
Any advice for cold plunging? That sounds very painful and hard.

**中文翻译:**
关于冷水浴有什么建议吗？听起来非常痛苦和艰难。

---

### [01:15:01] Luc Levesque

**English:**
I usually start going... I go in a hot tub to warm up, then I go in the cold plunges and back in the hot tub. That's an easy way to get started. But I will say I jumped in yesterday and today without going to hot tub. It was very painful, but I felt so much better after. So I might be changing up my approach, but I'm just kind of experimenting with different things. But that would be some advice. And then just go slow. Start it not too cold, and then slowly make it cold over time. But I think it's a pretty good thing to add in so far.

**中文翻译:**
我通常先去热水浴缸里热身，然后跳进冷水浴池，再回到热水浴缸。这是入门的简单方法。但我必须说，昨天和今天我没去热水浴缸就直接跳进去了。非常痛苦，但之后感觉好多了。所以我可能会改变我的方法，我只是在尝试不同的东西。这就是一些建议。另外，慢慢来，开始时不要太冷，然后随着时间的推移慢慢调低温度。但到目前为止，我认为这是一个非常值得加入的习惯。

---

### [01:15:31] Lenny

**English:**
How long have you spent in the cold plunge?

**中文翻译:**
你在冷水浴池里待多久？

---

### [01:15:33] Luc Levesque

**English:**
It varies. Right now I'm doing five minutes. Five minutes at, I think it's 53 degrees. So I've started at 60, slowly bringing it down. But you do have to go slow because I brought it down even further and kind of caught me off guard and got a little dizzy. So you got to find your sweet spot.

**中文翻译:**
不一定。目前我泡 5 分钟。5 分钟，大约 53 华氏度（约 11.6 摄氏度）。我从 60 度开始，慢慢降下来。但你必须慢慢来，因为我之前降得更低，结果让我措手不及，有点头晕。所以你得找到自己的舒适点。

---

### [01:15:53] Lenny

**English:**
Damn. Very Huberman inspired. I imagine this-

**中文翻译:**
厉害。非常有 Huberman 的风格。我想这——

---

### [01:15:57] Luc Levesque

**English:**
Definitely it was part of the source there.

**中文翻译:**
确实，他是灵感来源之一。

---

### [01:15:59] Lenny

**English:**
I know people would hear a lot about cold plunges. I guess what have you seen as a benefit just while we're on this topic for people to seriously consider doing this?

**中文翻译:**
我知道人们听过很多关于冷水浴的事情。既然聊到了这个话题，你认为人们应该认真考虑做这件事的好处是什么？

---

### [01:16:06] Luc Levesque

**English:**
So a couple things. Mood afterwards is so much better. You get this great multi-hour boost from doing it. Especially like I mentioned, not doing warm before or waiting 10 minutes and waiting 10 minutes after before you warm up, after you get out, great mood boost. It also helps a lot with sleep. So if you do it at night, which is a little bit difficult, it helps a lot with sleep. Those are probably the two biggest things. And you do get to a point, I'm there now where I kind of look forward to it because you know how good you'll feel afterwards. So when I'm thinking about it, I know it's painful, it doesn't make it easier, but I do look forward to it now. It's a pretty cool thing.

**中文翻译:**
有几点。首先是心情会变好很多。泡完后你会获得持续数小时的精力提升。特别是像我提到的，如果之前不热身，或者出来后等 10 分钟再热身，心情提升非常明显。它对睡眠也很有帮助。如果你在晚上做（虽然有点难），它会极大地改善睡眠。这可能是最大的两点。而且你会达到一个境界——我现在就是这样——你会开始期待它，因为你知道泡完后感觉有多棒。所以当我想到它时，虽然知道很痛苦，但这并不会让过程变容易，但我现在确实很期待。这是一件很酷的事情。

---

### [01:16:44] Lenny

**English:**
Oh man. I got to get one now.

**中文翻译:**
天哪，我现在也想弄一个了。

---

### [01:16:46] Luc Levesque

**English:**
Yeah. [inaudible 01:16:49].

**中文翻译:**
是的。（听不清）。

---

### [01:16:49] Lenny

**English:**
Okay, two more questions. What's something relatively minor that you've changed in your product development process that has had a big impact on your team's ability to execute?

**中文翻译:**
好，还有两个问题。在你的产品开发流程中，有什么相对较小的改变，却对你团队的执行能力产生了重大影响？

---

### [01:16:56] Luc Levesque

**English:**
One change that comes to mind is it's common to hear discussion around you need to experiment, you need to have rigor, you need to look at results, iterate based on those results. That's pretty much common knowledge is how all good companies that execute growth that do it. I think the subtlety is that experiments are great, but they can be slow. You have to look at the results. You have to analyze how things went. You have to learn what's going on. You have to build the experiment. So there's a cost to an experiment and not everything needs to be experimented. And that's not something that I generally hear growth teams talk about. It's usually, "Hey, we need to experiment."

**中文翻译:**
我想到的一点改变是：人们通常会讨论你需要实验、需要严谨、需要看结果并基于结果进行迭代。这几乎是所有执行增长的优秀公司的常识。我认为微妙之处在于，实验虽然很棒，但可能很慢。你必须看结果，分析过程，学习发生了什么，还得构建实验。所以实验是有成本的，而且并非所有事情都需要实验。这通常不是我听到的增长团队会讨论的事情，他们通常只会说：“嘿，我们需要做实验。”

---

### [01:17:40] Luc Levesque

**English:**
So one thing that we're definitely focused more on lately is this idea of sometimes you just need to YOLO it because it's a better product experience or you just kind of know it's going to work. And if you're YOLO-ing 40 things and three of them work and you can look at pre-post, you can look at holdouts, there's ways of making sure you don't cause major damage, but the speed can outweigh the cost and time it takes to do experiment. So that's one change we've recently implemented. That's been pretty impactful.

**中文翻译:**
所以我们最近确实更加关注的一个想法是：有时你只需要“放手一搏”（YOLO），因为那是一个更好的产品体验，或者你凭直觉就知道它会奏效。如果你直接上线 40 件事，其中有 3 件奏效了，你可以通过前后对比、留存测试等方式确保不造成重大损害，但这种速度带来的收益可能超过做实验所需的时间和成本。这是我们最近实施的一个改变，非常有影响力。

---

### [01:18:09] Lenny

**English:**
Final question. So we met actually a long time ago in Montreal, or maybe it was in Ottawa, in Canada somewhere. I think it was through an organization called C100 when I was starting my company back in the day. And so my question is, what is your favorite Canadian food?

**中文翻译:**
最后一个问题。我们其实很久以前在蒙特利尔见过面，也可能是渥太华，在加拿大的某个地方。我想那是通过一个叫 C100 的组织，当时我正在创办我的公司。所以我的问题是：你最喜欢的加拿大食物是什么？

---

### [01:18:24] Luc Levesque

**English:**
It's funny. My favorite Canadian food, I'm from Ottawa and there's a lot of shawarma, Lebanese shawarma everywhere. I know it's not traditionally Canadian, but Canada's so multicultural, so I'll make this count. I love a good shawarma and it's so hard to find a good shawarma in the Bay Area. We've still been looking here. But my favorite Canadian food or pseudo Canadian is shawarma. If I had to pick one purely Canadian food, and this is related to Montreal where we first met, it's got to be a Montreal smoked meat sandwich.

**中文翻译:**
很有趣。我最喜欢的加拿大食物……我来自渥太华，那里到处都是沙瓦玛（shawarma，黎巴嫩烤肉卷）。我知道这不算是传统的加拿大食物，但加拿大非常多元文化，所以我也把它算进去。我喜欢好吃的沙瓦玛，但在湾区很难找到好吃的，我们一直在找。所以，我最喜欢的加拿大（或伪加拿大）食物是沙瓦玛。如果非要选一种纯正的加拿大食物，而且这与我们初次见面的蒙特利尔有关，那一定是蒙特利尔熏肉三明治（Montreal smoked meat sandwich）。

---

### [01:18:58] Lenny

**English:**
Excellent choices. You're making me very hungry. I'm going to go get some shawarma, buy me a cold plunge. Luc, this was amazing. We talked through everything I was hoping to talk through. Advisorships, SEO, hiring, building habits, cold plunges. Two final questions. Where can folks find you online if they want to reach out and learn more? And how can listeners be useful to you?

**中文翻译:**
绝佳的选择。你让我觉得很饿。我要去买点沙瓦玛，再买个冷水浴池。Luc，这太棒了。我们聊遍了我想聊的所有话题：顾问身份、SEO、招聘、建立习惯、冷水浴。最后两个问题：如果人们想联系你或了解更多信息，可以在哪里找到你？听众能为你做些什么？

---

### [01:19:18] Luc Levesque

**English:**
You can find me online at luclevesque.com. So first name, last name.com. And how can they be useful to me? Listen, we're always looking to hire the best of the best. So if you want to work at an amazing company with an amazing team doing very impactful work and learn the craft of growth, please reach out. We're always looking to bring on amazing talent. So that would be the woodway.

**中文翻译:**
你可以在网上找到我，网址是 luclevesque.com。就是我的名字加姓氏.com。至于听众能为我做什么？听着，我们一直在寻找最优秀的人才。所以，如果你想在一家了不起的公司工作，与了不起的团队一起做非常有影响力的事情，并学习增长的手艺，请联系我们。我们一直在寻找优秀的人才。这就是最好的方式。

---

### [01:19:40] Lenny

**English:**
Awesome. Luc, thank you again so much for being here.

**中文翻译:**
太棒了。Luc，再次感谢你来到这里。

---

### [01:19:43] Luc Levesque

**English:**
Thanks. It's great to chat.

**中文翻译:**
谢谢，聊得很开心。

---

### [01:19:45] Lenny

**English:**
Bye everyone.

**中文翻译:**
大家再见。

---

### [01:19:48] Lenny

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
非常感谢您的收听。如果您觉得本期节目有价值，可以在 Apple Podcasts、Spotify 或您喜欢的播客应用上订阅本节目。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现这个播客。您可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目再见。