# Madhavan Ramanujam 2.0 - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Madhavan Ramanujam.

---

### [00:00:00] Madhavan Ramanujam

**English:**
The good founders need to be able to dominate both market share and wallet share. It is not a choice. You need to get better at both.

**中文翻译:**
优秀的创始人需要能够同时主导市场份额（Market Share）和钱包份额（Wallet Share，即客户支出占比）。这不是一个二选一的问题，你必须在这两方面都变得更强。

---

### [00:00:07] Lenny Rachitsky

**English:**
It feels like every company wants to be an AI company these days. How is AI pricing different?

**中文翻译:**
现在感觉每家公司都想成为 AI 公司。AI 的定价方式有什么不同吗？

---

### [00:00:11] Madhavan Ramanujam

**English:**
The winners in AI will need to master monetization from day one. If you're bringing a lot of value to the table and you start at training your customers to expect $20 a month and you anchored yourself on a low price point, you're in trouble. 20% of what you build drives 80% of the willingness to pay. But the irony is that that 20% is the easiest thing to build often.

**中文翻译:**
AI 领域的赢家需要从第一天起就精通变现（Monetization）。如果你提供了巨大的价值，却从一开始就让客户习惯于每月 20 美元的价格，把自己锚定在一个低价位上，那你就麻烦了。你所构建的功能中，20% 的部分驱动了 80% 的付费意愿。但讽刺的是，那 20% 的功能往往是最容易构建的。

---

### [00:00:30] Lenny Rachitsky

**English:**
What would you say is the biggest lesson you want founders to take away?

**中文翻译:**
你最希望创始人吸取的教训是什么？

---

### [00:00:33] Madhavan Ramanujam

**English:**
If you think about market share and wallet share, let's think about it as a two-by-two. The quadrant that you really want to be in is the outcome-based pricing model, the top-right quadrant where you have great autonomy and great attribution. About 5% of companies are probably in a true outcome-based pricing model. If you want to win in AI, figure out a way to get to that quadrant.

**中文翻译:**
如果我们把市场份额和钱包份额看作一个四象限矩阵，你真正想进入的是右上角的象限，即“基于结果的定价模型”（Outcome-based pricing model），在那里你拥有极高的自主性和极强的归因能力。目前可能只有约 5% 的公司处于真正的基于结果的定价模型中。如果你想在 AI 领域获胜，就得想办法进入那个象限。

---

### [00:00:54] Lenny Rachitsky

**English:**
Do you feel like the popular IDE startups, they're going to be in trouble down the road?

**中文翻译:**
你觉得那些热门的 IDE（集成开发环境）初创公司以后会有麻烦吗？

---

### [00:00:58] Madhavan Ramanujam

**English:**
Some of them, yes, without naming names.

**中文翻译:**
其中一些确实会，我就不点名了。

---

### [00:01:02] Lenny Rachitsky

**English:**
Today my guest is Madhavan Ramanujam. Madhavan is the smartest person I know on pricing and monetization strategy. As managing partner at Simon-Kucher, he's worked with over 250 companies, including 30 unicorns, to help them figure out how to price, package, and grow their products.
(00:01:18):
He's also the author of the book on pricing called Monetizing Innovation. And now he's back with a new book, a sequel, called Scaling Innovation, which teaches you how to architect your business for long-term profitable growth and also how to avoid the common traps that teams fall into that keep them from building real, durable, sustainable businesses.
(00:01:36):
Bill Gurley wrote the foreword. I had a chance to read an early copy. I absolutely loved it. It's a book that every founder needs to read. And in this episode, Madhavan shares many of the biggest lessons from the book, including how pricing strategy is very different for AI companies, why you need to get your pricing model right from the start in today's market, a very simple two-by-two to help you pick your pricing model, how to gain pricing power, a ton of tactical advice for negotiating more effectively, the most common traps founders fall into, and so much more.
(00:02:05):
If you order five copies of the book, Madhavan is offering a chance to win a free conversation with him, a signed copy of the book, an invite to the book launch, a t-shirt, and more. Just send a copy of your purchase receipt to promo@49palmsvc.com.
(00:02:19):
And some more good news, Madhavan is now more accessible. He left Simon-Kucher. He's now investing full-time with his own fund. He focuses on early-stage AI companies. If you want to work with them, check him out at 49palmsvc.com.
(00:02:32):
If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. With that, I bring you Madhavan Ramanujam.

**中文翻译:**
今天的嘉宾是 Madhavan Ramanujam。Madhavan 是我认识的在定价和变现策略方面最聪明的人。作为 Simon-Kucher 的管理合伙人，他曾与超过 250 家公司合作，其中包括 30 家独角兽企业，帮助他们解决如何定价、打包和增长产品的问题。
(00:01:18):
他也是定价专著《货币化创新》（Monetizing Innovation）的作者。现在他带着续作《规模化创新》（Scaling Innovation）回归了，这本书教你如何构建业务以实现长期的盈利性增长，以及如何避开那些阻碍团队建立真正持久、可持续业务的常见陷阱。
(00:01:36):
Bill Gurley 为本书作序。我有幸读到了早期副本，非常喜欢。这是每个创始人都必读的书。在本期节目中，Madhavan 分享了书中的许多核心教训，包括 AI 公司的定价策略有何不同，为什么在当今市场你需要从一开始就确定正确的定价模型，一个帮助你选择定价模型的简单四象限矩阵，如何获得定价权，大量关于更有效谈判的战术建议，创始人最常掉入的陷阱，等等。
(00:02:05):
如果你订购五本该书，Madhavan 将提供赢取与他免费交谈的机会、签名书、新书发布会邀请函、T 恤等。只需将购买收据发送至 promo@49palmsvc.com。
(00:02:19):
还有一个好消息，Madhavan 现在更容易联系到了。他离开了 Simon-Kucher，现在通过自己的基金全职从事投资。他专注于早期 AI 公司。如果你想与他合作，请访问 49palmsvc.com。
(00:02:32):
如果你喜欢这个播客，别忘了在常用的播客应用或 YouTube 上订阅和关注。下面，让我们欢迎 Madhavan Ramanujam。

---

### [00:02:40] Lenny Rachitsky (Sponsor Message)

**English:**
This episode is brought to you by Enterpret. Enterpret is a customer intelligence platform used by a leading CX and product orgs like Canva, Notion, Perplexity, Strava, Hinge and Linear. To leverage the voice of the customer and build best-in-class products. Enterpret unifies all customer conversations in real-time, from Gong recordings to Zendesk tickets to Twitter threads, and makes it available for your team for analysis and for action.
(00:03:05):
What makes Enterpret unique is its ability to build and update a customer-specific knowledge graph that provides the most granular and accurate categorization of all customer feedback and connects that customer feedback to critical metrics like revenue and CSAT. If modernizing your voice-of-customer program to a generational upgrade is a 2025 priority, like customer-centric industry leaders like Canva, Notion, Perplexity, and Linear, reach out to the team at enterpret.com/lenny. That's E-N-T-E-R-P-R-E-T .com/lenny.

**中文翻译:**
本期节目由 Enterpret 赞助。Enterpret 是一个客户情报平台，被 Canva、Notion、Perplexity、Strava、Hinge 和 Linear 等领先的客户体验（CX）和产品组织所采用，旨在利用客户的声音构建一流的产品。Enterpret 实时统一所有客户对话，从 Gong 的录音到 Zendesk 的工单再到 Twitter 的帖子，并供你的团队进行分析和采取行动。
(00:03:05):
Enterpret 的独特之处在于它能够构建并更新特定于客户的知识图谱，提供对所有客户反馈最细致、最准确的分类，并将这些反馈与收入和客户满意度（CSAT）等关键指标联系起来。如果将你的“客户之声”计划现代化并进行代际升级是 2025 年的优先事项，就像 Canva、Notion、Perplexity 和 Linear 等以客户为中心的行业领导者一样，请联系 enterpret.com/lenny 团队。

---

### [00:03:40] Lenny Rachitsky (Sponsor Message)

**English:**
Today's episode is brought to you by DX. If you're an engineering leader or on a platform team, at some point your CTO will inevitably ask you for productivity metrics. But measuring engineering organizations is hard, and we can all agree that simple metrics, like the number of PRs or commits, doesn't tell the full story. That's where DX comes in.
(00:04:00):
DX is an engineering intelligence solution designed by leading researchers, including those behind the DORA and SPACE frameworks. It combines quantitative data from developer tools with qualitative feedback from developers to give you a complete view of engineering productivity and the factors affecting it.
(00:04:17):
Learn why some of the world's most iconic companies, like Etsy, Dropbox, Twilio, Vercel, and Webflow rely on DX. Visit DX's website at getdx.com/lenny.

**中文翻译:**
今天的节目由 DX 赞助。如果你是工程负责人或平台团队成员，你的 CTO 迟早会向你索要生产力指标。但衡量工程组织非常困难，我们都同意简单的指标（如 PR 数量或提交次数）无法反映全貌。这就是 DX 的用武之地。
(00:04:00):
DX 是由领先的研究人员（包括 DORA 和 SPACE 框架背后的专家）设计的工程情报解决方案。它将来自开发工具的定量数据与来自开发者的定性反馈相结合，为你提供工程生产力及其影响因素的全景视图。
(00:04:17):
了解为什么 Etsy、Dropbox、Twilio、Vercel 和 Webflow 等全球最具代表性的公司都信赖 DX。请访问 DX 官网 getdx.com/lenny。

---

### [00:04:34] Lenny Rachitsky

**English:**
Madhavan, thank you so much for being here. Welcome to the podcast.

**中文翻译:**
Madhavan，非常感谢你能来。欢迎来到本播客。

---

### [00:04:37] Madhavan Ramanujam

**English:**
It's exciting to be back, Lenny. Thanks so much for hosting me again.

**中文翻译:**
很高兴能回来，Lenny。非常感谢再次邀请我。

---

### [00:04:41] Lenny Rachitsky

**English:**
This is a very rare second visit to the podcast. You've got a new book coming out. I've got a very early copy right here. If you're watching on YouTube, here's the copy you sent me. It's like 200 pages. Did you print this out on your printer, by the way?

**中文翻译:**
这是非常罕见的第二次做客。你有一本新书要出版了。我手里就有一本早期的副本。如果你在 YouTube 上观看，这就是你寄给我的那一本。大约有 200 页。顺便问一下，这是你自己用打印机打印出来的吗？

---

### [00:04:54] Madhavan Ramanujam

**English:**
Yes, I think I ran out of printer ink after that, I guess.

**中文翻译:**
是的，我想印完这本后，我的打印机墨水就用光了。

---

### [00:04:58] Lenny Rachitsky

**English:**
I appreciate the early copy. It's amazing. What we're going to be doing with this conversation is going through some of the biggest lessons that you shared in this book to give people a sense of many of the things that you share, many things you've learned since writing the first book.
(00:05:11):
Let me start with this question. Why'd you decide to write another book? And what is the difference between Scaling Innovation, which is the name of this book, and Monetizing Innovation, is the name of the first book?

**中文翻译:**
感谢你提供早期副本，非常棒。在这次对话中，我们将梳理你在书中分享的一些核心教训，让大家了解你自写完第一本书以来学到的许多新东西。
(00:05:11):
让我先问这个问题：你为什么决定再写一本书？《规模化创新》（Scaling Innovation）和第一本书《货币化创新》（Monetizing Innovation）之间有什么区别？

---

### [00:05:21] Madhavan Ramanujam

**English:**
So Monetizing Innovation, we actually wrote it eight years ago. Time Flies. And the core thesis of that book was, how do you build products that are not just cool but are products that people need, value, and are actually willing to pay for? And I think that took a life of its own.
(00:05:36):
And over the years, we kept getting another question from entrepreneurs that, "Hey, we built a great product, we know there is willingness to pay, but how do we build a great business? How do we scale this?" And the brutal truth is that even if you have a great product, you might actually not figure out a way to grow fast and grow profitably. So we wrote Scaling Innovation in an effort to actually solve that puzzle.
(00:05:55):
So you can think of this as a sequel to Monetizing Innovation. And Monetizing Innovation. Talked about how to build great products. Scaling Innovation talks about how to build a great business. And writing a book is... There needs to be a purpose for this. For me, the reason for writing books is about giving a bit back based on what I know to founders. And book writing is hard. Writing a good book is even harder.
(00:06:19):
And just like Monetizing Innovation, Scaling Innovation is not marketing fluff. It actually has real actionable stuff packed in that you can go on Monday morning and start implementing. And we wrote this book to give back a bit of what we know and to help companies scale and architect towards profitable growth.

**中文翻译:**
《货币化创新》其实是八年前写的了，时光飞逝。那本书的核心论点是：如何构建不仅酷，而且是人们需要、看重并真正愿意付费的产品？那本书后来产生了很大的影响力。
(00:05:36):
这些年来，我们不断收到创业者的另一个问题：“嘿，我们做出了很棒的产品，我们也知道有人愿意付费，但我们如何建立一个伟大的业务？我们如何规模化？”残酷的现实是，即使你有一个好产品，你也可能找不到快速且盈利性增长的方法。所以我们写了《规模化创新》，试图解开这个谜题。
(00:05:55):
所以你可以把它看作是《货币化创新》的续集。《货币化创新》讲的是如何打造好产品，《规模化创新》讲的是如何打造好业务。写书需要一个目的。对我来说，写书是为了把我所知道的东西回馈给创始人。写书很难，写一本好书更难。
(00:06:19):
就像《货币化创新》一样，《规模化创新》不是营销废话。它包含了真实、可操作的内容，你周一早上就可以开始执行。我们写这本书是为了分享我们的知识，帮助公司规模化并构建盈利性增长的架构。

---

### [00:06:38] Lenny Rachitsky

**English:**
I love people like you that do the work for, I don't know, decades at this point, learn from real life experiences over and over and over, and then just share all this stuff with people. This is the most... the highest ROI way to learn, is letting you do all this work to learn all these things and then you share all your answers with us. So that's why I love these books.
(00:07:00):
If you had to boil down the thesis of this book into just a simple thought so that we can just start to plant this in founders's heads, what would that be?

**中文翻译:**
我非常喜欢像你这样的人，投入了几十年的时间，从现实经验中反复学习，然后把这些东西分享给大家。这是投资回报率（ROI）最高的学习方式——让你去做所有的工作来学习这些东西，然后你把答案分享给我们。这就是我喜欢这些书的原因。
(00:07:00):
如果你必须把这本书的论点浓缩成一个简单的想法，以便植入创始人的脑海中，那会是什么？

---

### [00:07:08] Madhavan Ramanujam

**English:**
So if I have to boil down the core thesis of the book, it is basically that if you want to build an enduring business, you need to be able to architect towards profitable growth. What that means is you need to be able to master two engines: market share and wallet share.
(00:07:26):
It sounds simple on the surface, but it's actually quite complex. Because if you unpack that, for gaining market share and wallet share, you need to be good at acquisition, monetization, and retention, as in get customers, make an initial money on them, but also make money on an ongoing basis and have your customers actually refer more customers.
(00:07:46):
Many companies, actually, what they do is they focus on a single engine strategy. So they focus on one of those two topics and pretty much exclude the other one. That leads to all kinds of situations. You see companies saying, "I'll grow at all costs and postpone monetization." You see some who would say, "I'm going to monetize earlier on," but they might miss out on acquisition opportunities. Or yet others who are so focused on a small set of loyal customer base that they're neither monetizing nor are they actually acquiring.
(00:08:17):
So the good founders need to be able to dominate both market share and wallet share. It is not a choice. You need to get better at both. But this does not mean that you're putting equal effort on market share and wallet share at all given points in time, but it means you're putting equal attention on both those topics and being thoughtful about the trade-offs and saying, "How can I actually look at these two topics together so that I'm architecting towards profitable growth?" That's the core thesis of the book.
(00:08:47):
We actually showcase nine strategies that actually allow companies to architect towards profitable growth. And every chapter ends with how this particular strategy circumvents a single-engine problem and helps you focus on market share and wallet share at the same time. And there's also CEO questions and leadership questions that people should reflect on when they architect towards profitable growth and are they on the right track? I mean, think about this ways. If you're flying a aircraft, you don't want to flight on one engine. Why do you actually want to do that for your business?

**中文翻译:**
如果要浓缩核心论点，那就是：如果你想建立一家长青的企业，你必须能够构建盈利性增长的架构。这意味着你需要掌握两个引擎：市场份额和钱包份额。
(00:07:26):
表面上听起来很简单，但实际上非常复杂。因为如果你拆解开来，为了获得市场份额和钱包份额，你需要擅长获客（Acquisition）、变现（Monetization）和留存（Retention）——也就是获取客户，从他们身上赚到第一笔钱，还要持续赚钱，并让客户推荐更多客户。
(00:07:46):
实际上，许多公司采用的是“单引擎策略”。他们只关注这两个话题中的一个，几乎完全排除了另一个。这会导致各种情况：你会看到有的公司说“不惜一切代价增长，推迟变现”；有的公司说“我要尽早变现”，但可能会错失获客机会；还有的公司过于关注一小群忠实客户，既不怎么变现，也不怎么获客。
(00:08:17):
优秀的创始人需要能够同时主导市场份额和钱包份额。这不是一种选择，你必须两者兼顾。但这并不意味着你在任何时间点都要在两者上投入相等的精力，而是意味着你要对这两个话题给予同等的关注，深思熟虑地进行权衡，并思考：“我如何将这两个话题结合起来看，从而构建盈利性增长的架构？”这就是书的核心论点。
(00:08:47):
我们展示了九种允许公司构建盈利性增长架构的策略。每一章的结尾都会说明该特定策略如何规避单引擎问题，并帮助你同时关注市场份额和钱包份额。书中还有 CEO 问题和领导力问题，供人们在构建盈利性增长架构时反思：他们是否走在正确的轨道上？想想看，如果你在开飞机，你肯定不想只靠一个引擎飞行。那你为什么要对你的业务这样做呢？

---

### [00:09:21] Lenny Rachitsky

**English:**
Okay. So I imagine many founders or people thinking about starting a company are not feeling like they're in one bucket or another. Intuitively, you're not like, "Oh, Of course. We're going to just focus on growth forever, and that's all that matters."
(00:09:36):
You had these kind of traps that founders fall into that you referenced a bit. Can you just talk again about just the common traps you find founders fall into that people may recognize like, "Shit, that's what I'm doing probably"?

**中文翻译:**
明白。我想很多创始人或打算创业的人并不觉得自己属于某一个特定的阵营。直觉上，你不会说：“哦，当然，我们要永远只关注增长，那是唯一重要的事情。”
(00:09:36):
你刚才提到了一些创始人容易掉入的陷阱。你能再详细讲讲你发现的那些常见陷阱吗？好让大家能意识到：“该死，我可能正在做这件事。”

---

### [00:09:47] Madhavan Ramanujam

**English:**
So let's unpack the traps that are correlated to the archetypes. If you're a disruptor archetype, you might fall into one of two traps. The first one is you might land, but you might not expand. As in your eagerness for acquiring, you might have actually given away a lot at less and you have given the farm away, but you don't have anything to expand to. That's the first trap you're likely to fall into.
(00:10:12):
The second trap that you actually fall into is you start... A market share that won, is different from a market share that is actually held. If you're so acquisition focused, you're actually focused on getting more and more customers, but you're not spending enough time with customers that you actually got to keep them, upsell them, keep them happy, et cetera. So you might fall into that trap.
(00:10:34):
If you're a moneymaker, you fall into one of two traps. The first one is you might nickel and dime your customers to death. Because you're focused on monetization, you might come up with a very differentiated pricing model, different levels, hidden fees, things to charge for many different things and come across as just trying to nickel and dime your customer.
(00:10:53):
The second trap that a moneymaker actually falls into is that you fall into the price premium paradox where you think that pricing high actually indicates value, but your price is so high that you actually start hurting your acquisition, so it just becomes irrelevant for most people.
(00:11:13):
If you're in the community builder, you actually fall into two common traps. The first one is you're focused so much on the foundation that you actually miss the frontier, which is you're so focused on your loyal customer base that you forget to attract different types of customers and you're not acquiring.
(00:11:30):
And the second trap that you fall into if you're a community builder is you train your customers to expect more for less. Because you're so eager to satisfy your loyal base, you start giving them more and more, and you're training your best customer base to expect more for less.
(00:11:46):
So these six traps are very common across these archetypes. Being a profitable growth architect means that you're avoiding these traps. In other words, you're simultaneously being a disruptor, a moneymaker, and a community builder all at the same time. And how do you actually have that archetype and the right strategies to actually go about your business?

**中文翻译:**
让我们拆解一下与不同原型（Archetypes）相关的陷阱。如果你是“颠覆者”（Disruptor）原型，你可能会掉入两个陷阱之一。第一个是“登陆但无法扩张”（Land but not expand）。由于急于获客，你可能以极低的价格给出了太多东西，几乎是“倾家荡产”式推销，结果后续没有扩张的空间。
(00:10:12):
第二个陷阱是：赢得的市场份额不等于守住的市场份额。如果你过于关注获客，你只顾着拉新，却没有花足够的时间在已有的客户身上，去留住他们、向上销售、让他们满意。
(00:10:34):
如果你是“赚钱者”（Moneymaker）原型，你也会掉入两个陷阱。第一个是“锱铢必较”（Nickel and dime your customers to death）。因为你专注于变现，你可能会设计一个非常复杂的定价模型，分很多层级，有很多隐藏费用，对各种小事都收费，这会让客户觉得你只是在算计他们。
(00:10:53):
第二个陷阱是“价格溢价悖论”（Price premium paradox）。你认为高价代表高价值，但你的价格高到开始伤害获客，导致你的产品对大多数人来说变得无关紧要。
(00:11:13):
如果你是“社区建设者”（Community builder），你也会掉入两个陷阱。第一个是过于关注“根基”而错失了“前沿”。你太关注忠实客户群，以至于忘了吸引不同类型的客户，导致获客停滞。
(00:11:30):
第二个陷阱是“训练客户期待物美价廉”。因为你太想取悦忠实粉丝，你不断给他们更多东西，结果训练了你最好的客户群去期待“花更少的钱得到更多的东西”。
(00:11:46):
这六个陷阱在这些原型中非常普遍。成为一个“盈利性增长架构师”意味着你要避开这些陷阱。换句话说，你要同时成为颠覆者、赚钱者和社区建设者。如何拥有这种原型并采用正确的策略来经营业务？

---

### [00:12:07] Lenny Rachitsky

**English:**
Okay. So this is what you want to not do. You mentioned you have nine strategies for how you actually want to approach pricing, monetization, scaling, monetization, and innovation. Can you share a couple of these strategies, maybe two or three, maybe some of your favorites?

**中文翻译:**
好，这些是反面教材。你提到你有九种策略来处理定价、变现、规模化和创新。你能分享其中的几个吗？比如两三个你最喜欢的？

---

### [00:12:21] Madhavan Ramanujam

**English:**
Sure. So I will unpack a couple of strategies. Maybe the first one I would take is what we call as beautifully simple pricing. So in your early days it is by far more important to have pricing that is really simple and it's not creating too much friction in the sales conversation. I mean, the asset test that you probably should go back on Monday morning and do is take some of your early prospects or customers and ask them to articulate the pricing strategy back to you, right? If they were to actually sell on your behalf, how would they describe the pricing strategy? And if they cannot contextualize that in a simple manner and actually explain, you don't have a simple pricing strategy. It's as simple as that.
(00:13:02):
And having a simple pricing strategy also means that your pricing needs to be able to tell a value story, as in you need to contextualize your price based on the value that you actually bring to the table.
(00:13:15):
A great example here is Superhuman. When they started, they were actually competing with free email products and they were coming up with a premium email experience. And how do you actually price that? And I thought the team at Superhuman with Rahul and others did a pretty good job. They came up with a $30 price point per month, which was pretty simple. But the way they kind of told the story was that you pay a dollar a day for actually getting four hours of productivity back in the week, and then suddenly the pricing doesn't look too off. I mean, it's like the price for a latte in a week to actually get four hours back. Why wouldn't I actually do that, right?
(00:13:50):
And pricing contextualization and value story doesn't need to just apply for premium products. If you take another example, like the Subway $5 footlong is a different way to say a story with pricing that, oh, for $5, you get a lot of value actually back. So beautifully simple pricing really means coming up with a simple pricing strategy that your customers immediately get and your pricing is actually telling a value story and how do you actually get that. So in the book, we have a checklist of 10 different things that you actually need to look at to make sure that your pricing is beautifully simple.

**中文翻译:**
当然。我会拆解几个策略。第一个我想讲的是我们所谓的“极简定价”（Beautifully simple pricing）。在早期，拥有一个非常简单、不会在销售对话中产生太多阻力的定价策略至关重要。我建议你周一早上回去做一个“试金石测试”：找一些早期的潜在客户或现有客户，让他们向你复述你的定价策略。如果让他们代表你去销售，他们会如何描述定价？如果他们不能以简单的方式概括并解释清楚，那你的定价策略就不够简单。就这么简单。
(00:13:02):
拥有简单的定价策略还意味着你的定价需要能够讲述一个“价值故事”，也就是说，你需要根据你带来的价值来为价格提供背景。
(00:13:15):
这里有一个很好的例子：Superhuman。当他们开始时，他们实际上是在与免费的电子邮件产品竞争，他们推出的是高端的邮件体验。该如何定价呢？我认为 Rahul 和 Superhuman 团队做得很好。他们定了一个每月 30 美元的价格，这很简洁。但他们讲故事的方式是：你每天支付 1 美元，每周就能换回 4 小时的生产力。突然之间，这个价格看起来就不那么离谱了。这就像每周花一杯拿铁的钱换回 4 小时时间，为什么不呢？
(00:13:50):
定价背景化和价值故事不仅适用于高端产品。再举个例子，赛百味（Subway）的“5 美元长三明治”也是一种用定价讲故事的方式：只需 5 美元，你就能获得巨大的价值。所以，“极简定价”意味着制定一个客户能秒懂的定价策略，并且这个定价本身就在讲述一个价值故事。在书中，我们列出了一个包含 10 个要点的清单，确保你的定价做到了极简。

---

### [00:14:25] Lenny Rachitsky

**English:**
As we go through these strategies, is your advice try all these things, like you should do as many of these strategies as you can, or is it maybe pick a few that work for you or just one is enough?

**中文翻译:**
在我们讨论这些策略时，你的建议是尝试所有这些策略，还是挑选几个适合自己的，或者只做一个就够了？

---

### [00:14:34] Madhavan Ramanujam

**English:**
So there are nine strategies. We have organized that into strategies that apply during your startup phase, like just when you get started, and strategies that apply to you in your scale-up phase. So there are four strategies that you need to do in your startup and five in the scale-up, so it's quite manageable. I would argue that all four apply in the startup and all five actually apply in the scale-up phase, but it's not like you need to start focusing on nine things from day one.

**中文翻译:**
一共有九种策略。我们将它们分为适用于“初创阶段”（Startup phase）的策略和适用于“规模化阶段”（Scale-up phase）的策略。初创阶段有四种，规模化阶段有五种，所以还是比较好掌握的。我认为初创阶段的四种都适用，规模化阶段的五种也都适用，但并不是说你从第一天起就要同时关注这九件事。

---

### [00:14:59] Lenny Rachitsky

**English:**
So this first one was the startup phase?

**中文翻译:**
所以第一个（极简定价）是初创阶段的？

---

### [00:15:01] Madhavan Ramanujam

**English:**
Yeah. The beautifully simple pricing is the startup. Exactly. And so in the scale-up phase, I think one of the most important strategies is to master negotiations and really get better at acing negotiations, especially if you're in a B2B situation. And how do you actually do that? Because you need to be able to talk about the value and contextualize your price based on those kind of conversations.
(00:15:25):
So to master negotiations, it comes down to actually three things. Mastering gives and gets, being good at value selling, and third, having the right negotiation strategies. So let's unpack that each at a time.
(00:15:39):
So giving and getting, why is that important? Because in a negotiation, typically you're giving. I mean, you're giving concessions. People are asking. If you don't get anything back, you're basically indicating to the other person that they can keep beating you up and you need to keep giving. But if you're giving something but you ask for something in exchange, then you're basically bringing authenticity into the negotiation because it actually means something to you to give, so you're asking something back. It actually makes the negotiation way more effective.
(00:16:10):
And in the book we actually talk about the top 10 gets in B2B and the top 10 gets in B2C. One of my favorite gets in the B2B situation is what I call as conducting a value audit. So what this means is if you're giving a concession, ask for a value audit in exchange where every six months a team internally from your customers would be commissioned to actually conduct a value assessment of your products so that it becomes their business case and you co-create it with them saying how much value is actually produced. And this is great because if they actually engage in that, that gives you tremendous pricing power for renegotiations because it is their business case, they're championed it internally, and you're pretty much making your products pretty sticky. So it's a pretty harmless get, but it could be very powerful for future negotiations. So being good at-

**中文翻译:**
是的，极简定价属于初创阶段。而在规模化阶段，我认为最重要的策略之一是“精通谈判”（Mastering negotiations），尤其是在 B2B 场景下。你该如何做呢？因为你需要能够谈论价值，并根据这些对话为你的价格提供背景。
(00:15:25):
精通谈判归结为三件事：掌握“给予与索取”（Gives and gets）、擅长“价值销售”（Value selling），以及拥有正确的谈判策略。让我们逐一拆解。
(00:15:39):
首先是“给予与索取”，为什么这很重要？因为在谈判中，你通常是在“给予”——你在做出让步。如果对方索要让步而你没有换回任何东西，你实际上是在向对方暗示：他们可以继续压榨你，而你会一直让步。但如果你在给予某样东西的同时要求交换，你就为谈判带来了真实性，因为这表明你的让步是有代价的，所以你要求回报。这会让谈判变得有效得多。
(00:16:10):
书中我们讨论了 B2B 和 B2C 中最常见的 10 种“索取”。在 B2B 中，我最喜欢的索取之一是“价值审计”（Value audit）。这意味着如果你做出了价格让步，就要求对方每六个月由其内部团队对你的产品进行一次价值评估。这样评估结果就成了他们的“业务案例”（Business case），你与他们共同创造了关于产品产生了多少价值的证明。这非常棒，因为如果他们参与其中，这会为你未来的重新谈判提供巨大的定价权，因为这是他们内部认可的案例，而且会让你的产品变得非常具有粘性。这是一个看似无害的索取，但在未来的谈判中却非常有力。

---

### [00:17:00] Lenny Rachitsky

**English:**
That's really smart.

**中文翻译:**
这真的很聪明。

---

### [00:17:01] Madhavan Ramanujam

**English:**
... gives and gets is... Thank you. Being good at gives and gets is really critical.
(00:17:07):
The second thing in mastering negotiations is being good at value selling. And for being good at value selling, you need to do three things. First, you need to be able to create the needs. Second, you need to be able to create affirmation loops. And the third one is creating a good ROI model. And let's talk about each of those. So creating needs is very important because many founders show up and try to understand what are the needs of the customers. That's one way to look at it. But you need to be able to create needs rather than just discover them.
(00:17:38):
So for instance, if you're a marketing automation AI product and you save, let's say, three weeks of work that actually needs to be done to actually get stuff in a dashboard that can be analyzed by marketing managers, the way you create the need is ask about existing processes and say, "Okay, so just so I understand, all of this stuff actually takes you three weeks to put data together to actually have meaningful dashboards for your marketing managers to take action. What if that was available to you instantaneously?" Oh, you have now just created a need, right? So being in that mindset of creating a need as opposed to just discovering them.
(00:18:17):
The second thing is creating affirmation loops. And this is really important. I've seen a lot of founders get into negotiations. They're so eager to talk about their products. They keep talking about the products without any affirmation from the other side. You need to pause and create affirmation loops, things like, for instance, "Okay, so far, you've seen all of this. How does this actually play out in your company? Do you see it as valuable? What about this dashboard do you actually like?"
(00:18:44):
So when you ask these kind of questions and your customers are playing back the value that they actually see in your product, you're creating affirmation loops, which become tremendously useful when you start selling the product finally. Because if they've agreed that there's value that is being produced, then you also have a better commercial discussion.
(00:19:03):
And the third one is creating a good ROI model. And I see a lot of founders work on a POC. And after the POC's over, they'll show up with an ROI model and try to defend a price. You've already lost the battle. I mean, no one is going to believe an ROI model that you just cooked up. Everyone is going to challenge you on assumptions.
(00:19:22):
The right way to think about an ROI model is to actually co-create it with your customers from day one, which means agree and validate on the assumptions and the inputs. So like, "Hey, how long does this process take today? How many engineers are there?" So you create ask questions that are all inputs to an ROI model. And if you have done that process and the customer agrees on all the inputs, they're very unlikely to push back on the output of an ROI model. So a POC needs to be framed as the purpose of a POC is to build a business case, and we are going to co-create an ROI model with the customer as opposed to it being a tech and product functionality feature test and you show up with an ROI model.
(00:20:06):
And when you're building an ROI model, there are many buckets to focus on, but there are three that are very critical. The first one is, what are the incremental gains that you actually bring to the table based on KPIs and metrics that your customer is tracking? So this could be things like incremental revenue, reduction in churn. These are the immediate, tangible, clear impact to the business line based on the products that you actually bring to the table.
(00:20:33):
The second bucket is cost savings. Are you reducing headcount? Are you reducing license costs? What are the tangible cost savings?
(00:20:41):
And the third one, which is often overlooked, is opportunity cost. For instance, if you save 10 hours of time for a team, what do they actually do with that 10 hours? That can also be quantified. So when you put all of these three things together, you start building a proper ROI model that you can actually use in your value selling to defend the right price.

**中文翻译:**
谢谢。掌握给予与索取确实至关重要。
(00:17:07):
精通谈判的第二点是擅长“价值销售”。要做好价值销售，你需要做三件事：第一，创造需求；第二，创造“确认循环”（Affirmation loops）；第三，创建一个好的投资回报率（ROI）模型。
(00:17:38):
创造需求非常重要。许多创始人只是试图去“理解”客户的需求，这只是一个方面。你需要能够“创造”需求，而不仅仅是发现它们。例如，如果你是一个营销自动化 AI 产品，能节省三周的数据整理工作，你可以问：“为了让营销经理看到仪表盘并采取行动，你们现在需要花三周时间整理数据。如果这些数据能瞬间呈现呢？”瞧，你刚刚创造了一个需求。
(00:18:17):
第二点是创造“确认循环”。这非常重要。我见过很多创始人在谈判中只顾着滔滔不绝地讲自己的产品，却不寻求对方的确认。你需要停下来，问一些问题，比如：“到目前为止，你已经看到了这些功能。你觉得这对你们公司有什么帮助？你觉得它有价值吗？你最喜欢这个仪表盘的哪一点？”当客户向你复述他们看到的价值时，你就创造了确认循环。这在最终成交时非常有用，因为如果他们已经承认了价值，商务讨论就会顺利得多。
(00:19:03):
第三点是创建一个好的 ROI 模型。我看到很多创始人在做完 POC（概念验证）后，拿着一个 ROI 模型去辩护价格。这时候你已经输了，因为没人会相信你临时编出来的模型，大家会质疑你的假设。
(00:19:22):
正确的方法是从第一天起就与客户“共同创建”ROI 模型。这意味着要就假设和输入数据达成一致并进行验证。比如问：“这个流程现在需要多长时间？有多少工程师参与？”这些都是 ROI 模型的输入。如果客户同意了所有的输入数据，他们就不太可能反驳输出的结果。所以，POC 应该被定义为“建立业务案例”的过程，而不是简单的技术功能测试。
(00:20:06):
在构建 ROI 模型时，有三个关键维度：1. 增量收益（Incremental gains），如增加收入、降低流失率，这些是直接影响业务线的指标。2. 成本节约（Cost savings），如减少人头、降低授权费用。3. 机会成本（Opportunity cost），这是常被忽视的。比如你为一个团队节省了 10 小时，他们可以用这 10 小时去做什么？这也可以量化。把这三者结合起来，你就拥有了一个可以用来捍卫价格的 ROI 模型。

---

### [00:21:02] Madhavan Ramanujam

**English:**
So we talked about three steps in mastering negotiations. The first one was gives and gets. The second one was getting better at value selling. The third one is actually getting better at even negotiations and what strategies would you actually use. And there are a couple of strategies that we have found to be really productive.
(00:21:20):
The first one is to show up with options. Many founders rush with one product and one price and say, "Okay, this is a hundred K product, and that's what we are trying to sell." Inevitably, what will happen is the immediate focus of the conversation will be on the price, and you're only talking about price.
(00:21:39):
But if you have options on the table, let's say if you have a good, better, best, if you're a hundred K product, a 200K and a 300K option, then you're not just talking price, you're talking value. Because if your customer is budget conscious, they'll say, "Hey, I like the hundred K price point, but I actually like the functionality in your 200K product." Then your immediate question is, what in the functionality do you actually like? Why is that beneficial for you? So you switch the conversation back to value as opposed to just talking about price. And we have seen that with these kind of conversations, you're by far more better off to actually land in a much better place than just showcasing one product and one price.
(00:22:18):
And showcasing options doesn't need to be just different products. It could even be a pricing model choice. And I'd probably give a simple hack that people can try on Monday morning. I was talking to this founder who said, "Hey, I think the budget is about 100K. That's what I believe from the key stakeholder, but my product really brings crazy value. I could even charge, let's say, a 500K for this product, but I don't have the courage to actually go and ask for a 500K price because I kind of know a hundred K is the budget. What should I do?" So for those kind of situations, actually show up with options in your pricing model.
(00:22:58):
So we coached him to go in with a hundred K, plus 10% on any incremental value that you bring, or it's a 500K fixed. So now this is actually a great situation in negotiation. Because if you're price sensitive, you're focused on the hundred K. It's a small fee to actually get started. But the conversation will gravitate towards, "What is that 10%? How do you measure value?" That's a great conversation to have because now you're talking about, "How you add value? Where's the value generation? What portion would you take?"
(00:23:28):
And you see one of two situations. Either the customer say, "That's great. You're putting skin in the game. Let's go with a hundred K and 10%," or, 80% of the situations, you might actually want to avoid the outcome-based pricing as a buyer, but you're not really fixated on the 500K at that point. It is the premium that you're actually paying for the certainty. So no one is focusing on the 5K because of the hundred K option on the table, and you just put a 500K and got the courage to do that. And in this specific situation, that 500K got negotiated to 400K, and they just 4X the deal compared to where they would be. So having options on the table when you negotiate is critical.
(00:24:05):
And there's also some tactics that we showcase in the book, like anchoring is important. If you start high, you'll also end up higher. And also tapering concessions. How do you give concessions? I mean, the worst negotiators will start by giving a small concession and then give a bit more when someone asks like... You might give a 5% discount, and the procurement guy says, "That's not enough." "Okay, I'll give you 10% more." "Okay, that's not enough." "I'll give you 15." What are you indicating to the other person? You're just basically indicating that I can keep beating you up and I can get more discounts.
(00:24:35):
The best negotiators who taper the concessions. So they would say, "I can give you 15%." "Okay, I need more." "I'll give you five." "I need more." "I'll give you two." So you're automatically indicating to the other person that the negotiation's actually ending. So how do you taper concessions also become important.
(00:24:51):
So when you put all of these three things together, if you master your gives and gets, you get better at value selling, and you use the right negotiation strategy, you can extract full value from every deal. That's probably way more important when you're at the scale-up phase.

**中文翻译:**
我们谈到了精通谈判的三个步骤：1. 给予与索取；2. 价值销售；3. 具体的谈判策略。我们发现有几个策略非常有效。
(00:21:20):
第一个是提供“选项”。许多创始人只带着一个产品和一个价格去谈，比如“这是一个 10 万美元的产品”。不可避免地，对话的焦点会立刻集中在价格上。但如果你提供“好、更好、最好”三个选项，比如 10 万、20 万和 30 万的方案，你就不再只是在谈价格，而是在谈价值。如果客户预算有限，他们会说：“我喜欢 10 万的价格，但我想要 20 万方案里的功能。”这时你可以问：“你为什么喜欢那个功能？它对你有什么好处？”这样你就把话题转回了价值。
(00:22:18):
提供选项不一定非得是不同的产品，也可以是不同的“定价模型”。这里有一个周一就能用的“小窍门”：我曾遇到一位创始人，他说客户预算只有 10 万，但他觉得产品价值巨大，甚至可以收 50 万，但他没勇气开口。我们建议他提供两个选项：1. 10 万固定费 + 10% 的增量价值分成；2. 50 万固定费。
(00:22:58):
这在谈判中非常有利。如果客户对价格敏感，他们会关注那 10 万。但对话会转向：“那 10% 是什么？如何衡量价值？”这是一个极好的话题，因为你们在讨论如何创造价值。结果通常有两种：要么客户同意分成方案；要么（80% 的情况）客户为了规避不确定性而选择固定费，但此时他们不再纠结于 50 万这个高价，而是把它看作是为了获得确定性而支付的溢价。在那个案例中，50 万最终谈成了 40 万，交易额翻了四倍。
(00:24:05):
书中还提到了一些战术，比如“锚定”（Anchoring）很重要，起步价高，终点价也会高。还有“递减式让步”（Tapering concessions）。差劲的谈判者会先给 5% 折扣，对方不满意再给 10%，再给 15%，这等于告诉对方：继续压榨我，我还有空间。而优秀的谈判者会先给 15%，对方要更多时给 5%，再要时给 2%，这在暗示对方：谈判快到底线了。
(00:24:51):
把这三者结合起来，你就能从每笔交易中提取全部价值。这在规模化阶段尤为重要。

---

### [00:25:05] Lenny Rachitsky

**English:**
This is such great advice. I love that this is just one small chapter of your book. This could make or break your company. It's interesting that you have a whole thing on negotiation in a book about scaling innovation and growing your company. Is the assumption here that your pricing and monetization is so impacted by how well you negotiate because that changes your entire pricing structure and how much you're making? Is that why you put so much effort into this part?

**中文翻译:**
这建议太棒了。我喜欢这只是你书中的一小章。这可能决定一家公司的成败。很有趣，你在关于规模化创新和增长的书里专门讲了谈判。这里的假设是不是：定价和变现受谈判能力的影响极大，因为谈判会改变你的整个定价结构和收入？这就是你投入这么多精力的原因吗？

---

### [00:25:31] Madhavan Ramanujam

**English:**
Exactly. I mean, in a B2B situation, you can set all the pricing you want, come up with great pricing models. But at least even today, it's a human having a human conversation trying to negotiate. So if you cannot contextualize what you put on the table, how do you negotiate around value, how do you contextualize your price, you're leaving a lot of money on the table.
(00:25:49):
So to us, negotiations is yet another monetization topic where you're thinking about it as extracting full value from every deal. And this is not just negotiation tactics, like keep your boss at home and just negotiate and things like that. This is actual negotiation strategies that are rooted on value selling, gives and gets, and focusing on extracting full value from every deal.

**中文翻译:**
没错。在 B2B 场景中，你可以设定任何你想要的定价，设计完美的模型。但至少在今天，谈判仍然是人与人之间的对话。如果你不能为你的方案提供背景，不能围绕价值进行谈判，不能为价格提供合理解释，你就会损失很多钱。
(00:25:49):
所以对我们来说，谈判是另一个变现课题，核心是如何从每笔交易中提取全部价值。这不仅仅是谈判技巧（比如“把老板留在家里”之类的），而是植根于价值销售、给予与索取的真实谈判策略。

---

### [00:26:14] Lenny Rachitsky

**English:**
So useful. This idea of throwing out a third higher priced option, say 500K, it's so interesting. Because usually the advice I hear is like, "Just throw out twice the number you used to... " Just put it out there just in case, which is really scary to ask for like, "What about $50,000?" And this is like a much less scary way of doing that. "Okay, but we also have this 500K option. Here's what you get." And then they may be like, "Oh, that's exactly what we want." And you're like, "Oh, wow. It worked."

**中文翻译:**
太有用了。抛出一个高价选项（比如 50 万）的想法很有趣。因为通常我听到的建议是“直接报出你以前价格的两倍”，这其实挺吓人的。而你这种方式压力小得多：“好的，但我们也有一个 50 万的选项，包含这些内容。”然后对方可能会说：“哦，那正是我们想要的。”你会惊叹：“哇，居然成功了。”

---

### [00:26:40] Madhavan Ramanujam

**English:**
Exactly. It's a very simple hack to get your courage.

**中文翻译:**
没错。这是一个让你获得勇气的简单小窍门。

---

### [00:26:43] Lenny Rachitsky

**English:**
That is so cool.

**中文翻译:**
太酷了。

---

### [00:26:44] Madhavan Ramanujam

**English:**
Put a good price point.

**中文翻译:**
定一个好的价位。

---

### [00:26:45] Lenny Rachitsky

**English:**
Wow, this is awesome. This is just like a golden nugget within golden nuggets of advice. Okay. So you have nine strategies. We've covered two. Let's not get into them, but just what are a few more just so people know what else they might be able to learn?

**中文翻译:**
哇，这太棒了。这简直是金点子中的金点子。好，你有九种策略，我们已经讲了两种。不用展开讲，能不能再提几个，让大家知道还能学到什么？

---

### [00:26:59] Madhavan Ramanujam

**English:**
Sure. We talk about how to land and expand, as in how to design your best free product in such a way that you are landing, but also expanding. We talk about things like how to have the right packaging strategy, how to stop churn before it happens, how to do price increases effectively. Because at some point in your scale-up journey, you need to increase price, but how do you do that meaningful fashion?
(00:27:24):
So we have various strategies that apply both for the startup and the scale-up phase. But in combination, all of those things help you articulate and architect towards profitable growth.

**中文翻译:**
当然。我们讨论了如何“登陆并扩张”，即如何设计你的免费产品，使其既能吸引客户进入，又能为后续扩张铺路。我们还讨论了如何制定正确的打包策略、如何在流失发生前阻止它、如何有效地涨价。因为在规模化过程中，你迟早要涨价，但如何以一种有意义的方式进行？
(00:27:24):
我们有各种适用于初创和规模化阶段的策略。结合起来，这些都能帮助你构建盈利性增长的架构。

---

### [00:27:35] Lenny Rachitsky

**English:**
Awesome. Okay. Let's talk about AI for a bit. A lot of your book is about how AI pricing is very different from other previous traditional pricing strategies. And it feels like every company wants to be an AI company these days, so I think this is going to apply to a lot of people. How is AI pricing different?

**中文翻译:**
太好了。让我们聊聊 AI。你书中的很大一部分内容是关于 AI 定价如何不同于以往传统的定价策略。现在感觉每家公司都想成为 AI 公司，所以我觉得这会对很多人适用。AI 定价到底有什么不同？

---

### [00:27:51] Madhavan Ramanujam

**English:**
Yeah, AI pricing is very different from the previous vintage of companies. Why is that so? Because AI founders need to tackle monetization from the very early days, like day one in their seed stage pre-seed kind of thing, which was not probably the focus for the previous SaaS companies. Why is that? So because of two reasons.
(00:28:11):
One, for the first time there's cost dynamics to actually navigate. So you need to think about monetization from day one. But there's also a more critical reason, which is value capture. Because with AI products, you're actually bringing a lot of value to the table. And if you don't capture that from day one, then you're training your customers to expect more for less.
(00:28:31):
So for instance, think about this. If you're building a agentic AI product that taps into labor budgets, labor budgets are 10X compared to software budgets. So if you use all the old playbooks, then you're under monetizing, again, from day one and training your customers to expect more for less. So how do you come up with foundational models that actually allow you to capture the value that you bring to the table?
(00:28:55):
And why has this become critical? Because with AI, finally, founders can really solve the attribution problem. In the previous vintages... For instance, if you take Slack, you can say that the productivity went up, efficiency happened, but you cannot measure it, monitor it, attribute it to Slack. Okay, that's probably why they were in a seed-based pricing model.
(00:29:17):
But in today's situations, you see companies that say, "In a Fortune 100 company, I was able to improve throughput by 10%, reduce crap by 5%." And when you get into those kinds of situation where an AI is creating core value and it's attributable to the AI, you get a lot of pricing power.
(00:29:35):
So the two questions that we commonly hear from AI founders is, "How do I set the right pricing model?" as in, "How do I charge?" which becomes way more important than how much you charge. Because the underlining business model has changed. We have moved from software being a pay for access to now you're paying for work delivered. So the monetization model's become key. That is the first question that people actually ask us.
(00:30:05):
The second one is, "How do I navigate POCs, commercial discussions early?" Because the buyer on the other side also wants to see the value before they engage in a commercial discussion." So those two topics become very critical, and we have showcased a lot of this in the book.

**中文翻译:**
是的，AI 定价与前几代公司非常不同。为什么？因为 AI 创始人需要从非常早期（比如种子轮、前种子轮的第一天）就开始处理变现问题，而这在以前的 SaaS 公司中通常不是重点。原因有两点：
(00:28:11):
第一，这是第一次需要处理“成本动态”（Cost dynamics，如算力成本）。所以你必须从第一天起就考虑变现。但还有一个更关键的原因，即“价值捕获”（Value capture）。因为 AI 产品带来了巨大的价值，如果你不从第一天起就捕获它，你就是在训练客户期待“花小钱办大事”。
(00:28:31):
例如，如果你在构建一个代理型 AI（Agentic AI）产品，它切入的是“人力预算”，而人力预算通常是软件预算的 10 倍。如果你沿用旧的剧本，你从第一天起就变现不足。那么，你如何设计基础模型来捕获你带来的价值呢？
(00:28:55):
为什么这变得至关重要？因为有了 AI，创始人终于可以真正解决“归因问题”（Attribution problem）。在以前，比如 Slack，你可以说它提高了生产力，但你无法精确衡量并归因于 Slack。这可能就是为什么他们采用按席位定价（Seat-based pricing）的原因。
(00:29:17):
但在今天，你会看到有的公司说：“在一家财富 100 强公司中，我能将吞吐量提高 10%，将废品率降低 5%。”当 AI 创造了核心价值且该价值可归因于 AI 时，你就获得了巨大的定价权。
(00:29:35):
所以我们常听到 AI 创始人的两个问题：1. “我该如何设定正确的定价模型？”即“我该如何收费”，这比“收多少钱”重要得多。因为底层商业模式变了——从“为访问权限付费”变成了“为交付的工作成果付费”。2. “我该如何处理早期的 POC 和商务讨论？”因为买方也想在进入商务讨论前看到价值。这两个话题非常关键，我们在书中做了大量展示。

---

### [00:30:23] Lenny Rachitsky (Sponsor Message)

**English:**
This episode is brought to you by Persona, the adaptable identity platform that helps businesses fight fraud, meet compliance requirements, and build trust. While you're listening to this right now, how do you know that you're really listening to me, Lenny? These days, it's easier than ever for fraudsters to steal PII, faces, and identities. That's where Persona comes in.
(00:30:44):
Persona helps leading companies like LinkedIn, Etsy, and Twilio securely verify individuals and businesses across the world. What sets Persona apart is its configurability. Every company has different needs depending on its industry, use cases, risk tolerance, and user demographics. That's why Persona offers flexible building blocks that allow you to build tailored collection and verification flows that maximize conversion while minimizing risk. Plus, Persona's orchestration tools automate your identity process so that you can fight rapidly shifting fraud and meet new waves of regulation.
(00:31:19):
Whether you're a startup or an enterprise business, Persona has a plan for you. Learn more at withpersona.com/Lenny. Again, that's with P-E-R-S-O-N-A .com/Lenny.

**中文翻译:**
本期节目由 Persona 赞助。Persona 是一个灵活的身份平台，帮助企业打击欺诈、满足合规要求并建立信任。当你现在听这段音频时，你怎么知道真的是我 Lenny 在说话？如今，诈骗者窃取个人信息、面部数据和身份变得前所未有的容易。这就是 Persona 的用武之地。
(00:30:44):
Persona 帮助 LinkedIn、Etsy 和 Twilio 等领先公司安全地验证全球范围内的个人和企业。Persona 的独特之处在于其可配置性。每家公司根据行业、用例、风险承受能力和用户特征都有不同的需求。这就是为什么 Persona 提供灵活的构建模块，允许你构建定制的收集和验证流程，在最小化风险的同时最大化转化率。此外，Persona 的编排工具可以自动处理身份流程，助你应对快速变化的欺诈和新一波的监管。
(00:31:19):
无论你是初创公司还是大型企业，Persona 都有适合你的方案。请访问 withpersona.com/Lenny 了解更多。

---

### [00:31:34] Lenny Rachitsky

**English:**
Let's talk about this POC piece because I think this is something a lot of people deal with. And then I want to talk about this two-by-two that you have in the book. And I'll actually pull it up. So let's talk about POCs first.

**中文翻译:**
让我们聊聊 POC 的部分，因为我觉得很多人都在处理这个问题。然后我想聊聊你书里的那个四象限矩阵。我会把它调出来。先说 POC 吧。

---

### [00:31:43] Madhavan Ramanujam

**English:**
So POCs, when we talk about POCs, many founders think about a POC as a proof of technical functionality, and is their product actually working in their customer environments. And they set up the expectation that we are saying, "Hey, we are going to put the product, and we're going to see if it actually works." And they would probably say, "Should I charge for a POC versus not?" And we'll unpack that in a bit, should you or should you not.
(00:32:10):
And that's actually a completely wrong way of framing it. The POC should be framed as the entire goal of the POC is to create a business case, period, full stop. It is not to demonstrate product functionality fit within your customer environment's ability to integrate. All of that stuff is a consequence of the business case.
(00:32:30):
So if you frame it this way is you can say, "Look, it is a 30-day pilot for co-creating an ROI model and building a business case along with their users. If we see value at the end of the 30 days based on the business case, we can get to commercial discussions." So that way you've actually not talked about your price. You're only focused on co-creating a business case with the customer. And based on the business case, you can actually come up with a proper commercial agreement. And if they see value, they're going to pay you for it. So thinking about the POCs in that kind of manner.
(00:33:03):
And the question that I often get asked is, "Should I charge for a POC?" And the answer is yes, but smartly. Let's talk about why it's important to charge. The reason you need to charge for a POC is you start isolating people who are just tire kickers versus serious buyers. It becomes a lead qualification mechanism. If you didn't have that, you're going to attract all of these curious buyers who are just curious about AI. They just want to see if it works or not. They will say, "Yes, I'll engage with the POC." They will take 30, 60, 90 days with you. They will burn a lot of resources, never buy. You've just wasted your time. Time is of the essence. So having a price tag to your POC actually indicates that there is seriousness on both sides, so you should charge.
(00:33:48):
But how do you actually charge for it? You need to charge for it smartly. What this means is that you need to make sure that your POC pricing is not a reflection of your actual commercial deal. Because let's say if you just say it's a 10K POC for a 30-day pilot. If you don't talk about the fact that it is not the same as your commercial discussion, you have now set an anchor that, okay, it's 120K per year kind of deal if the POC works. So you have to be clear that the 10K is only for building a business case. Commercial discussions will follow after that. It is not an indication of the actual commercial discussion.
(00:34:28):
But your buyer on the other side might still push you saying, "That's all great, but I need a price or a budget, otherwise I won't move forward with it." So there are two ways to actually deflect those kind of questions. The first way is contextualize the price on the value. So you can say something like, if you're pushed for price, "Hey, for customers such as yours, we have been able to at least unlock 10 million in very similar situations. And our pricing is... One is to 10X when it comes to ROI."
(00:34:58):
So you basically said that you're a million dollars to actually get started, but you actually didn't say it. You just said, "It's a 10 million, and I'm taking one in 10 in exchange for it." So you've given the buyer an indication, but you've framed it in such a manner that actually is justifiable, right? A one in 10X ROI. So that's one way to do it.
(00:35:16):
They might still say, "Yeah, that's good, but I need a budget." So then rather than just give them a budget saying, "It could be a 200K option," don't do that. That's the worst thing you can actually say. Give them a range. You can say something like, "Look, the final pricing would be anywhere from 500K to a million. And based on the business case that we would co-create with you, we can pick a point in that range that justifies the value that we bring to the table." So you're giving budgetary ranges, right? So that's the other way to actually go about POCs.
(00:35:46):
So how you navigate your early wins, who you choose is very critical when you're building companies at scale and fast in AI because that actually dictates the destiny for the rest of your future. And picking those early wins is very, very critical. And having buyers who are serious, lead qualifying, having the right POC process, and thinking about POCs as, frankly, not just trying to see if your product actually works and delivers value, but it's a great chance to have a commercial test-and-learn experiment and have fun with it and try to see what you can bring to the table in terms of your value and what portion can you actually take.

**中文翻译:**
关于 POC，许多创始人认为它是“技术功能证明”，即证明产品在客户环境中能跑通。他们设定的预期是：“我们要部署产品，看看它是否有效。”然后他们会纠结：“我该不该收 POC 的钱？”
(00:32:10):
这其实是完全错误的定调方式。POC 的唯一目标应该是“建立业务案例”（Business case），句号。它不是为了演示功能或集成能力，那些只是业务案例的结果。
(00:32:30):
如果你这样定调，你可以说：“这是一个为期 30 天的试点，目的是与你们的用户共同创建一个 ROI 模型并建立业务案例。如果 30 天后我们基于业务案例看到了价值，我们再进入商务讨论。”这样你根本没谈价格，你只关注与客户共同创造业务案例。基于这个案例，你可以提出合理的商务协议。如果他们看到了价值，他们自然会付钱。
(00:33:03):
至于“该不该收 POC 的钱”，答案是：要收，但要收得聪明。为什么要收？因为这能帮你过滤掉那些只是“随便看看”的人，留下真正的买家。这是一种销售线索筛选机制。否则，你会吸引一大堆对 AI 好奇的人，他们折腾你 90 天，消耗大量资源，最后却不买。时间就是生命。所以，给 POC 贴上价格标签代表了双方的严肃态度。
(00:33:48):
但如何聪明地收费？你要确保 POC 的价格不代表最终的商务合同价格。比如你收 1 万美元做 30 天试点，如果你不说明这与最终合同无关，你就设定了一个锚点，对方会觉得一年的合同也就 12 万。所以你要明确：这 1 万只是为了建立业务案例，商务讨论在后面。
(00:34:28):
如果买方非要一个预算范围，有两种应对方式：1. 基于价值提供背景。你可以说：“对于像你们这样的客户，我们通常能解锁 1000 万美元的价值，而我们的定价通常是 ROI 的 1/10。”你暗示了价格是 100 万，但你用“10 倍 ROI”这种可证明的方式表达了出来。
(00:35:16):
2. 提供一个范围。不要直接说“大概 20 万”，那是你能说的最糟糕的话。你应该说：“最终价格可能在 50 万到 100 万之间，基于我们共同创造的业务案例，我们会选择一个能体现我们所带来价值的点。”
(00:35:46):
在 AI 领域，如何处理早期胜利、选择谁作为早期客户至关重要，因为这决定了你未来的命运。选择严肃的买家、进行线索筛选、建立正确的 POC 流程，并把 POC 看作是一场商务上的“测试与学习”实验，看看你能带来多少价值，以及你能从中分得多少。

---

### [00:36:26] Lenny Rachitsky

**English:**
So the core takeaway here is, for AI companies, you no longer can just grow and figure out monetization later. Your advice here is what you start with is what you're going to end up with, and it's very easy to under monetize because people aren't realizing that they're now helping with actual labor force savings versus just SaaS software that's making people a little bit more efficient.

**中文翻译:**
所以核心教训是：对于 AI 公司，你不能再先增长以后再考虑变现。你的建议是，你开始的方式决定了你的结局，而且很容易变现不足，因为人们没有意识到他们现在是在节省实际的“人力成本”，而不仅仅是让 SaaS 软件变得更高效一点。

---

### [00:36:50] Madhavan Ramanujam

**English:**
Yeah, absolutely. I mean, I strongly believe that the winners in AI will need to master monetization, and they need to master it from day one. And when we talk to early-stage founders, it is a topic that keeps many people up at night, but that's also why we wrote Scaling Innovation and other assets so that they can get some more courage to think about pricing correctly from day one. And it's become very critical for AI companies to do that.

**中文翻译:**
绝对正确。我坚信 AI 领域的赢家必须精通变现，而且必须从第一天起就精通。当我们与早期创始人交谈时，这是一个让许多人彻夜难眠的话题。这也是我们写《规模化创新》的原因，希望能给他们一些勇气，从第一天起就正确思考定价。这对 AI 公司来说至关重要。

---

### [00:37:16] Lenny Rachitsky

**English:**
Do you feel like the popular IDE startups, I won't name names, do you think they've under monetized and they're going to be in trouble down the road?

**中文翻译:**
你觉得那些热门的 IDE 初创公司（我不点名了），你觉得他们变现不足吗？以后会有麻烦吗？

---

### [00:37:24] Madhavan Ramanujam

**English:**
Some of them for sure have. I think they will probably run out of it because they might show a lot of, let's say, fast revenue growth, but is that enduring revenue? Are people actually going to stay? And is there going to be churn? And so there are a lot of aspects to marketing profitable growth. It's not just growing fast, but also growing profitably and having an enduring business. So some of them, yes, without naming names. But yeah, I think that's why it's important to be thoughtful about market share and wallet share.

**中文翻译:**
其中一些肯定是的。我想他们可能会难以为继，因为他们可能展示了很快的收入增长，但那是持久的收入吗？人们真的会留下来吗？会有流失吗？盈利性增长有很多维度，不仅仅是长得快，还要长得健康，拥有持久的业务。所以，是的，其中一些会有麻烦。这就是为什么同时考虑市场份额和钱包份额如此重要。

---

### [00:37:54] Lenny Rachitsky

**English:**
Well, those are different. I think what you're saying here is the retention may not work for some of these companies. But on the other hand, they're really cheap. 20 bucks a month to help your engineer be 10 times more productive potentially, is that too good a deal? Do you think they should have priced a lot higher?

**中文翻译:**
这是两回事。我想你指的是某些公司的留存可能成问题。但另一方面，他们真的很便宜。每月 20 美元就能让工程师的生产力提高 10 倍，这交易是不是太划算了？你觉得他们应该定更高的价吗？

---

### [00:38:11] Madhavan Ramanujam

**English:**
Yeah, for sure. I mean, if you're bringing a lot of value to the table and you started training your customers to expect $20 a month and you anchored yourself on a low price point, I think there are companies that have actually done that. And they try to undo it with having more sophisticated, let's say, products that are actually higher priced or much higher priced, et cetera. That's one way to undo that situation.
(00:38:32):
So it's really a trade-off between getting more customers and making money at the same time. That's the whole point of the book, market share and wallet share, and how do you dominate both. So if they're being thoughtful about both and have a vision to not just grow market share, but also have a clear strategy to land and expand and increase wallet share, those strategies might pan out for those types of companies. If you just threw out a $20 product hoping to just accelerate your market share, you're in trouble.

**中文翻译:**
肯定的。如果你带来了巨大的价值，却训练客户期待每月 20 美元，把自己锚定在低价位上，确实有些公司已经这么做了。他们现在正试图通过推出更复杂、价格更高甚至高得多的产品来扭转局面。
(00:38:32):
所以这真的是在“获取更多客户”和“同时赚钱”之间做权衡。这就是书的核心：市场份额和钱包份额，以及如何同时主导两者。如果他们深思熟虑，不仅有增长市场份额的愿景，还有清晰的“登陆并扩张”以及增加钱包份额的策略，那么这些公司可能会成功。但如果你只是抛出一个 20 美元的产品，寄希望于加速获取市场份额，那你就麻烦了。

---

### [00:38:59] Lenny Rachitsky

**English:**
Okay. This is a great segue to this two-by-two, which goes much deeper into this. So it's easy to be like, "Here's what you shouldn't do." Here's your advice on what to actually do. So I'm going to pull up on my screen this two-by-two that you have in your book. So if you're watching YouTube, you'll be able to see it.
(00:39:13):
So talk about this. This is essentially how to figure out the best possible pricing model and where you have the most power.

**中文翻译:**
好，这正好引出了那个四象限矩阵，它对这个问题有更深的探讨。说“不该做什么”很容易，现在来看看你建议“该做什么”。我要在屏幕上调出书里的这个矩阵。如果你在看 YouTube，就能看到它。
(00:39:13):
讲讲这个吧。这基本上是关于如何找到最佳定价模型，以及你在哪里拥有最大的权力。

---

### [00:39:20] Madhavan Ramanujam

**English:**
So when you talk about AI companies and monetization models, we get asked this question. "Should I be usage-based? Should I be outcome? Should I be a copilot mode? Or how do I actually think about my pricing model?" So we came up with this framework, which is a relatively simple, straightforward framework, but very powerful.
(00:39:39):
So there are two axes here. One is attribution, and the other one is autonomy. And when you have high attribution and high autonomy, that is when you have high pricing power, and we'll come back to that in a bit, right?
(00:39:51):
So let's take the first bottom-left quadrant. That is the quadrant where your attribution is low and your autonomy is low. In that situation, the best pricing archetype that actually fits is it is actually a seed-based or a subscription model because there's not much to do about it because you're not being able to attribute a lot of value to what you bring, but you're in a copilot mode and you're not in an autonomous mode, so a seed-based pricing would actually make sense.
(00:40:18):
But if you're at that quadrant, the immediate thing to think about is, how do you actually build more attribution and move to the right so that you actually get more pricing power? So if you think about the bottom-right quadrant, those are companies that have actually done that. They can prove more attribution to what they actually bring to the table, but they are still not in a fully autonomous mode, as in there is still humans in the loop.
(00:40:43):
If you take Cursor, for instance, it definitely improves productivity, can actually bring down the time to actually do code, the attribution is clear, but it's still in a copilot mode. In those kind of situations, a hybrid pricing model is the best option where you still have a seed-based model for the copilot kind of use case, but you also layer in a consumption model which actually says there are a certain number of AI credits or tokens that can layer in the usage aspects. So if you use more and more, then you're actually paying more on consumption. So it's a hybrid model that actually works there.
(00:41:18):
If you look at the top-left quadrant, those are products that are very autonomous but are not strong on attribution. So these tend to be mostly backend or infrastructure kind of products that are core critical to run businesses, can be autonomous, but they're not directly impacting the KPIs that businesses are tracking, and hence cannot prove attribution very effectively. So in that situation, you need to be on a pay-for-what-you-consume and a usage-based model. A seed-based model would not make sense because it's autonomous. There's no human in the loop. But that's why you're also in a usage-based model, saying the more you use it, the more you're actually charged. And usage becomes a proxy for the value that you bring to the table.
(00:42:07):
The quadrant that you really want to be in is the golden quadrant, which is the top-right one. That's the outcome-based pricing model where you have great autonomy and great attribution. And here is where I think AI can be really magical. So this means you're not only charging for work delivered, but you're charging for work delivered that was delivered by AI without no humans in the loop. So that becomes more of an outcome-based model situation.
(00:42:35):
So a classic example here is Intercom for Fin. What they actually do is they charge based on an AI resolution. So if an AI is able to resolve the ticket completely independently without a human in the loop, then they charge for it. If a human intervention is needed, they don't charge for it. So they're more on an outcome-based model. Or companies like Charge Flow would charge up to 25% on a charge bag that they're able to actually recover, because these are core savings that you actually bring to the table based on your AI. It is highly attributable, highly autonomous so you can start moving towards an outcome-based pricing model.
(00:43:14):
If you look at the state of where AI is today, as of the day of recording this podcast, now, the most popular model is right now a hybrid pricing model. So because this is also expected, because the previous SaaS playbook was usually on the seat-based model, but they've all now moved on to at least a hybrid to actually incorporate AI credits and usage, et cetera, about 5% of companies are probably in a true outcome-based pricing model as of today. But those companies, some of the best ones are able to recover 25 to 50% of the value that they actually bring to the table.
(00:43:54):
In the classic SaaS situation, we used to say if you can charge 10 to 20% of the value, that's actually great. But in AI, you can actually charge 25 to 50% because it is autonomous, you're doing it with the AI. There's no humans in the loop. You are creating incremental value to the business metrics. You are producing hard-cost savings. There's opportunity costs. You can justify all of that. It's attributable. So you can actually take 25 to 50% of what you bring to the table.
(00:44:22):
In a lot of benchmarks and studies that actually show, and this is also my belief, that in the next three years that 5% number will move to 25%. So what this really means is if you want to win in AI, figure out a way to get to that quadrant because that's a magic quadrant. If you can truly price based on outcomes, you've achieved and unlock tremendous value.

**中文翻译:**
当我们谈论 AI 公司和变现模型时，常被问到：“我该按用量收费吗？按结果收费吗？还是副驾驶（Copilot）模式？我该如何思考定价模型？”于是我们提出了这个框架，它相对简单直接，但非常强大。
(00:39:39):
这里有两个轴：一个是“归因”（Attribution），另一个是“自主性”（Autonomy）。当你拥有高归因和高自主性时，你就拥有了极高的定价权。
(00:39:51):
先看左下角象限：低归因、低自主性。在这种情况下，最适合的定价原型是“按席位”（Seat-based）或订阅模式。因为你无法将太多价值归因于你的产品，而且你处于副驾驶模式，不是自主运行，所以按席位收费是合理的。
(00:40:18):
但如果你在这个象限，你首先要考虑的是：如何建立更强的归因能力并向右移动，以获得更多定价权？右下角象限的公司做到了这一点：他们能证明更多的归因价值，但仍不是完全自主的，即“人在回路中”（Human in the loop）。
(00:40:43):
以 Cursor 为例，它确实提高了生产力，缩短了编码时间，归因很明确，但它仍是副驾驶模式。在这种情况下，“混合定价模型”（Hybrid pricing model）是最佳选择：你保留按席位的基本费，同时叠加一个“消耗模型”（如 AI 积分或 Token）。用得越多，付得越多。
(00:41:18):
左上角象限：高自主性、低归因。这些通常是后端或基础设施类产品，对业务运行至关重要，可以自主运行，但不直接影响业务追踪的 KPI，因此难以有效证明归因。在这种情况下，你应该采用“按需付费”（Pay-for-what-you-consume）或“按用量计费”（Usage-based）模型。按席位没意义，因为没有人在回路中。用量成了你所带来价值的代名词。
(00:42:07):
你真正想进入的是右上角的“黄金象限”：高自主性、高归因。这就是“基于结果的定价模型”。这是 AI 真正展现魔力的地方。这意味着你不仅是为交付的工作收费，而且是为 AI 在没有人工干预下交付的工作收费。
(00:42:35):
典型的例子是 Intercom 的 Fin。他们根据“AI 解决率”收费：如果 AI 独立解决了工单，他们就收费；如果需要人工介入，则不收。还有像 Charge Flow 这样的公司，他们会收取追回款项的 25%，因为这是 AI 带来的核心节约，高度可归因且高度自主。
(00:43:14):
目前 AI 的现状是，大多数公司采用混合定价模型。这很正常，因为之前的 SaaS 剧本是按席位的，现在大家都在向混合模式转型。目前只有约 5% 的公司处于真正的基于结果的定价模型中。但这些公司中表现最好的，能够捕获其创造价值的 25% 到 50%。
(00:43:54):
在传统 SaaS 时代，能收回价值的 10% 到 20% 就算很棒了。但在 AI 时代，你可以收 25% 到 50%，因为它是自主的，是 AI 在干活，没有人工成本。你创造了增量价值、节省了硬成本、减少了机会成本，且这一切都可归因。
(00:44:22):
许多研究和我的信念都表明，未来三年，那 5% 的比例将增加到 25%。这意味着如果你想在 AI 领域获胜，就得想办法进入那个象限。如果你能真正基于结果定价，你就解锁了巨大的价值。

---

### [00:44:49] Lenny Rachitsky

**English:**
Wow. Okay. I'm just going to pause again. This is amazing. Madhavan, thank you so much for it. I love, again, that you just spent years, decades studying this stuff, come here, tell us all the answers of what we should be doing. This is incredible.
(00:45:01):
Let me ask you this. By the way, for folks not watching on YouTube, the companies you have in the golden quadrant, outcome-based pricing, Sierra, Fin, and Chargeflow. We've got the founder of Sierra and Fin coming on the podcast soon, so we'll talk about all this with those guys.

**中文翻译:**
哇。好，我得停顿一下。这太精彩了。Madhavan，非常感谢。我再次感叹，你花了数十年研究这些东西，然后来到这里直接告诉我们答案。这太不可思议了。
(00:45:01):
顺便提一下，对于没看 YouTube 的听众，你在黄金象限（基于结果定价）里列出的公司有 Sierra、Fin 和 Chargeflow。Sierra 和 Fin 的创始人很快也会来做客，到时候我们会和他们聊聊这些。

---

### [00:45:16] Madhavan Ramanujam

**English:**
Awesome.

**中文翻译:**
太棒了。

---

### [00:45:18] Lenny Rachitsky

**English:**
So is the way to use this two-by-two figuring out your model? Is it like, "Okay, I'm like Cursor. I'm going to go in this quadrant," or is it, "How do I get to outcome-based no matter what? That's where I need to be"?

**中文翻译:**
那么，使用这个四象限矩阵的方法是先确定自己的模型吗？比如“好吧，我像 Cursor，我属于这个象限”，还是说“无论如何我都要想办法进入基于结果的象限，那才是终点”？

---

### [00:45:32] Madhavan Ramanujam

**English:**
Yeah, so that a great question. The first one is to actually figure out what is your right archetype based on where you are today. I think that is most important. If you try to rush into an outcome-based pricing model but cannot prove attribution, you will fail. So it is really coming up with what is the right archetype based on what I'm doing today, but also use this two-by-two to say, "How do I paint a vision to actually get to outcome based? And can I get close to that? Or can I be purely an outcome-based model? How do I evolve into that?"
(00:46:05):
What that would mean is, how do I build functionality in the products to actually show attribution, how do I build more agentic workforces to take the human out of the loop and be more autonomous, and being thoughtful about your vision and strategy so that you will orient yourself towards more outcome-based pricing models. So when you think about increasing attribution, that means, first of all, understanding what are the KPIs of your customers. How do they track their business performance? Can you impact it? Can you productize things in your product that showcase that you are actually affecting those KPIs in a positive manner? Can you build dashboards to show value attribution? Can you do those value audits that we talked about on an ongoing basis to actually show that you're bringing a lot of value to the table and is attributable to you? So how do you create these kind of attribution mechanisms become important and also autonomous based on building more agentic workforces that can actually be on an autonomous mold?
(00:47:04):
So pick the right archetype and plan to get to as close as you can to the outcome-based pricing model. That's how I would use the two-by-two. And you actually kind of see this happening with certain industries, right? If you think about coding as a overall category... Like back in the day with GitHub, everyone, they started with a seed-based model. They've now moved to the hybrid-based pricing model with Cursors and everyone else, but the natural move would be more towards a outcome-based pricing model where a AI agent can probably code everything at the same time, debug it, and you're kind of almost hiring a AI developer or AI QA person. And that actually becomes more closer to a outcome-based model because it's attributable and autonomous. So that is picking the right archetype and then figuring out your pathway is the key way to interpret this two-by-two.

**中文翻译:**
问得好。第一步是根据你现状确定正确的原型，这最重要。如果你在无法证明归因的情况下强行进入基于结果的定价模式，你会失败。所以，先确定基于现状的原型，然后利用这个矩阵思考：“我如何描绘一个愿景，最终走向基于结果的模式？我能接近它吗？我能完全转变成那种模式吗？”
(00:46:05):
这意味着：我如何在产品中构建能展示归因的功能？我如何构建更具代理能力的劳动力（Agentic workforces）来减少人工干预并提高自主性？你需要深思熟虑你的愿景和策略，使自己向基于结果的定价模型靠拢。增加归因意味着要理解客户的 KPI，在产品中通过仪表盘展示你对这些 KPI 的正面影响，或者进行我们之前提到的“价值审计”。
(00:47:04):
所以，选择正确的原型，并计划尽可能向基于结果的定价模型靠拢。这就是使用这个矩阵的方法。你会看到某些行业正在发生这种变化。比如编程领域：GitHub 时代是按席位收费；Cursor 时代变成了混合模式；而自然的演进将是基于结果的模式——AI 代理可以同时完成编码和调试，你就像是在雇佣一个 AI 开发人员或 QA，这因为高度可归因且自主，而更接近基于结果的模型。

---

### [00:47:56] Lenny Rachitsky

**English:**
This explains why everyone's pulling agents. That's where the money's at, what you're telling us here.

**中文翻译:**
这解释了为什么大家都在做代理（Agents）。听你这么一说，那才是赚钱的地方。

---

### [00:48:00] Madhavan Ramanujam

**English:**
Yeah. It's going to be the age of The Matrix. Too many agents.

**中文翻译:**
是的，我们要进入《黑客帝国》时代了，到处都是代理（Agent Smith）。

---

### [00:48:04] Lenny Rachitsky

**English:**
Agent Smiths everywhere. They didn't turn out too great. So what I'm hearing is if I were Canva... So Canva here in your model is bottom right. They're in a hybrid pricing model. They have a base fee and consumption fee. What you would do if you were helping Canva is what can you build that creates more autonomy, an autonomous version of Canva? And it's not like you need to do this. It's just you have more pricing power if you figure something out there.

**中文翻译:**
到处都是史密斯代理，他们的结局可不太好。所以我听到的是，如果我是 Canva……在你的模型里 Canva 在右下角，采用混合定价（基础费+消耗费）。如果你在帮 Canva，你会建议他们构建更具自主性的功能，比如一个“自主版 Canva”？并不是说必须这么做，而是如果你能做到，你就会有更强的定价权。

---

### [00:48:31] Madhavan Ramanujam

**English:**
Exactly. And a good case for that is the Fin product from Intercom. Because traditionally, all of those kind of companies used to price based on an agent basis. How many customer service agents are actually using the product? It used to be seed based, but they built out Fin, which is a completely AI resolution for those kind of support tickets. And then that actually enables them to move to the outcome-based pricing model quadrant.

**中文翻译:**
没错。Intercom 的 Fin 产品就是一个很好的案例。传统上，这类公司都是按客服坐席收费的，属于按席位定价。但他们开发了 Fin，这是一个完全由 AI 解决支持工单的产品，这使他们能够跨入“基于结果定价”的象限。

---

### [00:48:56] Lenny Rachitsky

**English:**
Amazing. So say you're an AI founder today. You're thinking about your pricing strategy, your monetization strategy long term. Your advice is work with design partners, create these POCs where you work on this ROI model with them to ideally find some outcome-based pricing strategy. Is that a good way to summarize it? What would you add to that?

**中文翻译:**
太棒了。所以如果你现在是一个 AI 创始人，在思考长期的定价和变现策略，你的建议是：与设计合作伙伴合作，通过 POC 与他们共同构建 ROI 模型，理想情况下找到某种基于结果的定价策略。这样总结对吗？你还有什么要补充的吗？

---

### [00:49:17] Madhavan Ramanujam

**English:**
Yes. I mean, at least be able to contextualize the business case. Even if you're not moving to an outcome-based pricing model, be clear on the outcome that you're actually creating for your customers through that business case, which actually will enable you to charge a fair price in exchange for that outcome. And if your customers agree with the business case, then you can actually take a portion of that.

**中文翻译:**
是的。我的意思是，至少要能为业务案例提供背景。即使你不打算采用基于结果的定价模型，也要通过业务案例明确你为客户创造的“结果”。这能让你为了那个结果收取公平的价格。如果客户认可这个业务案例，你就可以从中分得一杯羹。

---

### [00:49:43] Lenny Rachitsky

**English:**
Fin, actually, they're a new sponsor of the podcast, and I learned... I didn't know this. It costs 99 cents for every support ticket they solve [inaudible 00:49:51].

**中文翻译:**
Fin 其实是本播客的新赞助商，我了解到……以前我不知道，他们解决每张支持工单的费用是 99 美分。

---

### [00:49:51] Madhavan Ramanujam

**English:**
Through AI.

**中文翻译:**
通过 AI 解决。

---

### [00:49:52] Lenny Rachitsky

**English:**
Through AI.

**中文翻译:**
通过 AI。

---

### [00:49:53] Madhavan Ramanujam

**English:**
Exactly. If it needs a human intervention, then they don't charge for it.

**中文翻译:**
没错。如果需要人工干预，他们就不收费。

---

### [00:49:56] Lenny Rachitsky

**English:**
Yeah. And it's just like, what? That's such a simple story. Your agent costs 20 bucks. This thing costs 99 cents

**中文翻译:**
是的。这故事太简单明了了：你的真人客服成本很高，而这个只要 99 美分。

---

### [00:50:03] Madhavan Ramanujam

**English:**
Yeah. That is two chapters in one beautifully simple pricing and an outcome-based pricing model.

**中文翻译:**
是的，这一个案例就涵盖了两章内容：“极简定价”和“基于结果的定价模型”。

---

### [00:50:09] Lenny Rachitsky

**English:**
And interestingly, they were the most hated pricing model initially. I did a survey on Twitter ones, like, "What products do you pay the most for?" and it was always Intercom. And everyone hated their pricing, and they found a solution.

**中文翻译:**
有趣的是，他们最初的定价模型是最招人恨的。我曾在 Twitter 上做过调查：“你为哪些产品付的钱最多？”答案总是 Intercom。大家都讨厌他们的定价，但现在他们找到了解决方案。

---

### [00:50:21] Madhavan Ramanujam

**English:**
I think they found a great solution.

**中文翻译:**
我想他们确实找到了一个很棒的方案。

---

### [00:50:23] Lenny Rachitsky

**English:**
Okay. So is there anything else along these lines that you think companies, especially AI companies, should be thinking when they're thinking about pricing that you'd want to share before we move on to other stuff?

**中文翻译:**
好。在进入其他话题之前，关于定价，你觉得公司（尤其是 AI 公司）还有什么需要考虑的吗？

---

### [00:50:34] Madhavan Ramanujam

**English:**
I think we've covered most of the topics. Like we said, it's being thoughtful about POCs, choosing the right pricing archetype or the pricing models. Those things become very critical in the early stages. But when you start scaling and, let's say, you become a multi-product company, then you need to start focusing on, "What kind of packaging strategy should I have? Is it a platform plus add-ons? Should I have versions of the products like good, better, best? Should I tackle different use cases because now my AI can solve an insurance use case and a healthcare use case? Should I productize to different use cases? Is that my packaging strategy? Or should I keep it completely modularized for people to pick and choose?"
(00:51:17):
So these kind of questions become more critical, and that's why the chapter on blowing up your packaging from your early days and coming up with your packaging strategy for your scale-up phase become very critical. So I think that's the next thing that founders would be hit with, as in when they build multiple products, they need to think about the whole packaging, cross-selling, up-selling motion.

**中文翻译:**
我想我们已经涵盖了大部分主题。正如所说，早期关键在于深思熟虑 POC、选择正确的定价原型。但当你开始规模化，比如成为一家多产品公司时，你需要关注：“我该采用什么样的打包策略（Packaging strategy）？是平台+插件？还是‘好、更好、最好’的版本划分？我是否应该针对不同用例（如保险、医疗）进行产品化？还是保持完全模块化让客户自选？”
(00:51:17):
这些问题会变得越来越关键。这就是为什么书中关于“打破早期打包方式”并为规模化阶段制定打包策略的章节非常重要。我认为这是创始人接下来会遇到的挑战：当他们拥有多个产品时，需要考虑整体的打包、交叉销售和向上销售流程。

---

### [00:51:37] Lenny Rachitsky

**English:**
This touches on something I was about to ask, which is a change in your pricing strategy. How often is it a success to change the way you price? I know we're talking about you need to get it right from the beginning if you're an AI company. In your experience, how often... What does it take to successfully shift the way you price down the road if people are listening to this and are like, "Shit, we already have this pricing strategy"?

**中文翻译:**
这触及了我正想问的问题：改变定价策略。改变定价方式的成功率有多高？我知道我们一直在说 AI 公司需要从一开始就做对。根据你的经验，如果有人听了这期节目心想“糟了，我们已经有定价策略了”，那么以后成功转型需要具备什么条件？频率应该是怎样的？

---

### [00:52:00] Madhavan Ramanujam

**English:**
Back in the day, we used to say that you should revisit your pricing strategy, overall pricing model, how much you're charging at least once in two years. With AI, that's probably reduced in half because of the scale with which and the speed with which companies are built and competing.
(00:52:16):
So I would say that it is an ongoing journey. It is not like you just solve it in day one, fill it, and forget it. You have to be thoughtful from day one, but also be ready to pivot, iterate, and you're going to learn along your journey. So the whole point is to think about pricing as also a test-and-learn opportunity in your early days.
(00:52:38):
And there are things that you would change more often, and there are things that you probably don't want to change too often. Things like pricing model, unless you really changed your attribution autonomy, there is no need to shift your pricing model. Stay within that archetype. Don't confuse things.
(00:52:54):
But there are things like price points. Should I increase my price because it's been six months a year? Yeah, you should. Because in a year there's probably prices go up three to 5% for everything that you consume. But how can you actually increase your prices and be thoughtful about it? So that entire chapter on how to do price increases smartly become very important in the scale-up phase.
(00:53:16):
I think Warren Buffett summarized this really well. He said the true definition of a company is a pricing power. And if you have a prayer session for doing a 10% price increase, you have a terrible business. So you have to be able to increase prices over a bit of time. But how do you do it strategically that does not affect too much churn, but you're also able to pass on the increase as a value exchange, those things become critical.

**中文翻译:**
以前我们会说，你应该至少每两年重新审视一次定价策略、定价模型和价格水平。对于 AI，由于公司建立和竞争的速度，这个周期可能要减半。
(00:52:16):
所以我想说，这是一个持续的过程。不是第一天解决了就一劳永逸。你需要从第一天起就深思熟虑，但也要准备好转型和迭代。核心是将定价视为早期的“测试与学习”机会。
(00:52:38):
有些东西你会经常改，有些则不宜频繁变动。比如“定价模型”，除非你的归因和自主性发生了根本变化，否则没必要改，留在那个原型里，不要让客户困惑。
(00:52:54):
但像“价格点”（Price points）是可以动的。如果过了一年，我该涨价吗？是的，应该。因为通胀等因素，各种成本都在涨。但如何聪明地涨价？书中关于“如何巧妙涨价”的章节在规模化阶段非常重要。
(00:53:16):
沃伦·巴菲特总结得很好：一家公司的真正定义是它的“定价权”。如果你为了涨价 10% 还要开个祈祷会，那你的业务就很糟糕。你必须能够随着时间推移提高价格。但如何战略性地操作，既不导致大量流失，又能将涨价作为一种价值交换传递给客户，这才是关键。

---

### [00:53:39] Lenny Rachitsky

**English:**
Awesome. Zooming out a little bit, something that I love about your book is you structured it around these axioms. You have a bunch of these really clever axioms that get stuck in your head and help you think about pricing. Can you share some of your favorites, maybe two or three referred axioms from the book?

**中文翻译:**
太棒了。稍微跳出来看，我非常喜欢你书中的一点：你围绕着一些“公理”（Axioms）来构建内容。你有很多非常聪明的公理，它们能深深印在脑海里，帮助思考定价。你能分享几个你最喜欢的吗？

---

### [00:53:55] Madhavan Ramanujam

**English:**
You talked about Sierra being in your park founders. I don't know if that's Clay, but here's a shout-out for Clay. So Clay actually read the entire book and gave me feedback, Scaling Innovation, the similar copy that he actually had. I called it Scaling Innovation Axioms throughout the book. And the whole point of the axioms was that at the end of the day, if you can just take all the axioms, put it in a printout next to your desk is the summary of the book. And it's like PT statements that you'll just remember what to do.
(00:54:26):
So he came up with this idea that, "Hey, rather than calling them just generic scaling innovation axioms, you need to brand each and every axiom." And I thought that was a brilliant idea. So I went about coming up with a unique... He even contributed to some of the names. We came up with some unique names for each axiom.
(00:54:45):
And here's the other fun fact. Probably I'm geeking out too much. But when I counted the number of axioms, there were 42 axioms. And I didn't try to make this up. And if you're a Hitchhiker's fan, then you know that's the answer to everything.
(00:54:58):
But jokes apart, let me unpack a few axioms. One of my first favorite axioms, what I call is the 20-80 axiom. Especially in tech companies, 20% of what you build drives 80% of the willingness to pay. But the irony is that the 20% is the easiest thing to build often. So what founders do is they take this 20%, build it, put it out in the market almost for free, and then they're chasing their tails to build 80% stuff that's only driving 20% willingness to pay. So if you have not been thoughtful about that, you've given the farm away unintentionally.
(00:55:37):
So truly understanding what drives willingness to pay in your product is critical. And I think people call it the MVP. I think we should change the definition of MVP. It shouldn't be minimum viable product, it should be the most valuable product. And be thoughtful about what are you actually giving out as your early products I think is key. That's the 20-80 axiom.
(00:55:58):
Probably my second one is the price paralysis axioms. So what that means is your reluctance to do a price increase is often internal and emotional and it's not external and logical. This goes back to the same prayer session to actually do a price increase. If you're holding hands, you have a terrible business. So it's mostly internal and emotional, and how do you be thoughtful about price increases become important.
(00:56:29):
Probably my third favorite one is stopping churn before it happens, so stopping churn axiom. So to stop churn, you need to attract customers who won't leave. That sounds counterintuitive, but that's the best way to actually stop churn. What does this actually mean? Most companies will try to stop churn when someone actually says, "I want to go." It is too late, and you're being reactive. At the most, you'll throw some offers. They will stay for another six months, and they will leave. They've already made that determination.
(00:56:59):
The way to stop churn is to start acquiring customers who won't leave. And that is the most important thing. So if you look back at your data and say, "Who are the types of customers who actually tend to stay longer? What are their characteristics? How can I focus my acquisition dollars in getting more of those?" then you stop churn before it happens. And that's the key.

**中文翻译:**
你提到 Sierra 的创始人，我想那是 Clay，在这里向 Clay 致敬。Clay 读了整本书并给了我反馈。我原本在书中称它们为“规模化创新公理”。这些公理的意义在于，如果你把它们打印出来贴在桌边，那就是整本书的精华总结。
(00:54:26):
Clay 建议我：“嘿，与其叫它们通用的公理，不如给每一个公理都起个品牌名。”我觉得这是个天才的主意。所以我为每个公理都起了独特的名字，他甚至还帮我起了一些。
(00:54:45):
还有一个趣事，我数了一下，刚好有 42 个公理。我不是故意的，但如果你是《银河系漫游指南》的粉丝，你就知道 42 是万物的终极答案。
(00:54:58):
言归正传，我拆解几个公理。第一个我最喜欢的是“20-80 公理”。特别是在科技公司，你构建的功能中，20% 的部分驱动了 80% 的付费意愿。但讽刺的是，那 20% 往往是最容易构建的。创始人常做的事是：把这 20% 做出来，几乎免费地推向市场，然后拼命去构建剩下的 80% 那些只驱动 20% 付费意愿的功能。如果你没想清楚这一点，你就无意中“倾家荡产”了。
(00:55:37):
所以，真正理解产品中什么是驱动付费意愿的关键至关重要。人们常说 MVP（最小可行产品），我觉得应该改叫“最有价值产品”（Most Valuable Product）。
(00:55:58):
第二个是“价格瘫痪公理”（Price paralysis axiom）。这意味着你对涨价的抗拒通常是内部和情感上的，而不是外部和逻辑上的。这又回到了那个“涨价祈祷会”。如果你不敢涨价，说明你的业务有问题。涨价的阻力大多来自内部情绪。
(00:56:29):
第三个是“在流失发生前阻止流失公理”。要阻止流失，你需要吸引那些“不会离开”的客户。这听起来有点反直觉，但却是最好的方法。大多数公司在客户说“我要走”时才去挽留，那太晚了，你只是在被动反应。
(00:56:59):
阻止流失的方法是：从一开始就获取那些不会离开的客户。看看你的数据，哪类客户留存时间最长？他们有什么特征？如何把获客预算花在获取更多这类客户上？这样你就能在流失发生前阻止它。

---

### [00:57:22] Lenny Rachitsky

**English:**
That's interesting. I'm surprised you didn't say what was my favorite, which is... I think it's like, "If you land, make sure to expand."

**中文翻译:**
很有趣。我很惊讶你没提到我最喜欢的那个，好像是“如果你登陆了，确保要扩张”。

---

### [00:57:28] Madhavan Ramanujam

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:57:29] Lenny Rachitsky

**English:**
That one really stuck with me.

**中文翻译:**
那个公理让我印象非常深刻。

---

### [00:57:29] Madhavan Ramanujam

**English:**
That's a good one, too.

**中文翻译:**
那也是个好公理。

---

### [00:57:29] Lenny Rachitsky

**English:**
Maybe talk about that one. Yeah.

**中文翻译:**
也许可以讲讲那个。

---

### [00:57:32] Madhavan Ramanujam

**English:**
Sure. I mean, so if you land, you need to also make sure you're expanding, in the sense that if you give the farm away in your entry-level product, you don't have much to actually monetize later. So being thoughtful about what is the fence between your land product. Is it a free experience? What is the getting? And the getting is typically based on are you getting based on features? Are you also getting on usage? And how do you be thoughtful about that? So you leave stuff for the expansion.

**中文翻译:**
当然。如果你登陆了，你必须确保能扩张。如果你在入门级产品里就把所有好东西都给了出去，你以后就没什么可变现的了。所以要深思熟虑“登陆产品”和后续产品之间的界限（Fence）。是功能限制？还是用量限制？你需要为后续的扩张留出空间。

---

### [00:58:02] Lenny Rachitsky

**English:**
Okay. So zooming out even further, to kind of wrap up, what would you say is the biggest lesson you want founders to take away that they think they understand but they probably don't?

**中文翻译:**
好。再进一步总结一下，你认为创始人觉得自己懂了但实际上可能并没懂的最大教训是什么？

---

### [00:58:14] Madhavan Ramanujam

**English:**
Yeah, I think this comes back to what you started with. I think intuitively people get it that they need to think about market share and wallet share if they're growing. And even if you ask them, they'll say like, "Yeah, yeah, I'm thinking about wallet share," but have they really thought about it equally and paid equal attention? Have they postponed one of them? Are they operating in a single-engine strategy consciously or subconsciously? I think that's the key takeaway I have.
(00:58:40):
So the contrarian take is not to put equal effort on both the engines at the same time. In certain stages of your company, you might need to be more market share dominating. In certain stages you might need to be wallet share dominating. It's not equal effort, but it's equal attention and really developing that mindset of being a true profitable growth architect. And that is the main takeaway that I have for people. And if you are not in that mindset already, there's a book for you.

**中文翻译:**
我想这又回到了我们开始的话题。直觉上，人们明白增长时要考虑市场份额和钱包份额。如果你问他们，他们会说：“是的，我在考虑钱包份额。”但他们真的给予了同等的关注吗？他们是否推迟了其中一个？他们是在有意识或无意识地执行单引擎策略吗？
(00:58:40):
我的“反直觉”观点是：不是要在同一时间在两个引擎上投入相等的“精力”。在某些阶段，你可能需要主导市场份额；在另一些阶段，你可能需要主导钱包份额。这不是精力分配的问题，而是“关注度”的问题，是真正建立起“盈利性增长架构师”的心态。这就是我想传达的核心信息。如果你还没有这种心态，这本书就是为你准备的。

---

### [00:59:12] Lenny Rachitsky

**English:**
I'll point them to it. So just so folks know what to do when they're like, "Okay, I need to focus on wallet share more," is the main focus figure out a pricing model that aligns well with pricing power, what's in the bucket of work to do to invest more in wallet-share thinking?

**中文翻译:**
我会向大家推荐的。那么，当人们意识到“好吧，我需要更多关注钱包份额”时，主要工作是找到一个与定价权相匹配的定价模型吗？为了在钱包份额思维上投入更多，具体要做哪些工作？

---

### [00:59:28] Madhavan Ramanujam

**English:**
So it's actually all of those. Market share, wallet share, acquisition, monetization, retention are all kind of correlated. You can't think about them in isolation. So I wouldn't say only for wallet share what do you need to do. If you want to grow on both the market share and wallet share... Let's say, for instance, you need to have the right land-and-expand strategy. The land helps you with acquisition. The expansion helps you with wallet share.
(00:59:54):
If you have a pricing model, then you need to have a pricing model that lets you acquire faster because it's intuitive, but it should also help you recover value, which is like your monetization. And if people understand your pricing model, they're actually going to stay. So it's all sort of goes hand in hand. So I wouldn't isolate thinking one way or the other. That's why the nine strategies actually are very powerful. Because if you follow those strategies, you are not going to fall into the single-engine strap. These are tried and tested strategies of how to build businesses in such a way that you're being thoughtful and paying equal attention to both market share and wallet share.

**中文翻译:**
实际上是所有这些。市场份额、钱包份额、获客、变现、留存，它们都是相关的，不能孤立思考。我不会说只针对钱包份额要做什么。如果你想在两方面都增长，比如你需要正确的“登陆并扩张”策略：登陆有助于获客，扩张有助于钱包份额。
(00:59:54):
如果你有一个定价模型，它应该既能让你因为直观而快速获客，又能帮你回收价值（即变现）。如果人们理解你的定价模型，他们就会留下来。所以这些都是相辅相成的。这就是为什么那九种策略非常强大，因为如果你遵循它们，你就不会掉入单引擎陷阱。这些是经过验证的策略，教你如何构建业务，从而对市场份额和钱包份额给予同等的关注。

---

### [01:00:34] Lenny Rachitsky

**English:**
All right. That is a very reasonable answer. Madhavan, is there anything else you wanted to share or leave listeners with before we get to a very exciting lightning round?

**中文翻译:**
好的，这是一个非常合理的回答。Madhavan，在进入令人兴奋的闪电轮提问之前，你还有什么想分享或留给听众的吗？

---

### [01:00:41] Madhavan Ramanujam

**English:**
Read the two books in sequence, Monetizing Innovation and Scaling Innovation. Because it's one thing to build a great product, it's yet another thing to build a great business. You cannot build a great business with a not-so-great product, and you cannot do it the other way around either. So I think it's thinking about pricing early, especially for AI companies, being thoughtful about it, price before product, and then thinking about how to actually scale, developing a profitable growth mindset. All of these things become critical. And I'm looking forward to the feedback from the audience.

**中文翻译:**
按顺序阅读这两本书：《货币化创新》和《规模化创新》。因为打造好产品是一回事，打造好业务是另一回事。你不能用平庸的产品打造伟大的业务，反之亦然。所以，要尽早思考定价（尤其是 AI 公司），做到“定价先于产品”，然后思考如何规模化，培养盈利性增长的心态。这些都至关重要。我期待听众的反馈。

---

### [01:01:16] Lenny Rachitsky

**English:**
I feel like your books are in the staple of founder reading. There's all these things you just don't know what you're doing. And there's a few of these books that are like, "Okay, here's all this advice that'll answer so many questions and save you so much heartache." And so I'm really excited you're adding something to that bookshelf. With that, we've reached our very exciting lightning round. Are you ready?

**中文翻译:**
我觉得你的书是创始人的必读书目。创业时有很多事你根本不知道该怎么做，而有那么几本书会告诉你：“好了，这些建议能回答你的很多问题，并让你少走很多弯路。”我很高兴你又为那个书架增添了新成员。那么，我们进入闪电轮提问。准备好了吗？

---

### [01:01:16] Madhavan Ramanujam

**English:**
Okay. Let's go.

**中文翻译:**
好，开始吧。

---

### [01:01:36] Lenny Rachitsky

**English:**
Let's go. What are two or three books that you find yourself recommending most to other people?

**中文翻译:**
走起。你最常向别人推荐的两三本书是什么？

---

### [01:01:41] Madhavan Ramanujam

**English:**
The first one that comes to mind is Business Model Canvas by Alex Osterwalder. It's a classic and one of my favorite books. I recommend a lot of people to read that because I think it nicely ties a lot of what we are also seeing from a more strategic business model angle.
(01:01:57):
I like this book, Thinking Fast, Thinking Slow. I think that's also a classic because, again, there's always a human element to things. And understanding the customer psychology is important whether you're in B2C or in B2B. Because if you're in a B2B situation, it's humans having a human conversation. So it's as much behavioral as it's actually numbers. So I love that book, and there's a lot of nuggets in there, so I recommend a lot.
(01:02:20):
And probably the third one that I recommend is a book called Contagious by Jonah Berger. I love that. He was in the PhD program at Stanford in marketing, and he actually wrote this book on how to make messages viral. And he's actually seen the best viral messages and boiled it down to a framework. And if you follow that, then you can make those messages viral. And I've tried to use some of those in my own outreaches and things of that nature, so I think it's a fantastic read.

**中文翻译:**
我首先想到的是 Alex Osterwalder 的《商业模式画布》（Business Model Canvas）。这是一本经典，也是我最喜欢的书之一。我推荐很多人读，因为它从战略商业模式的角度很好地串联了我们所看到的很多东西。
(01:01:57):
我喜欢《思考，快与慢》（Thinking Fast, Thinking Slow）。这也是经典，因为凡事总有人为因素。无论在 B2C 还是 B2B，理解客户心理都很重要。在 B2B 场景中，也是人与人在对话。所以这既是数字问题，也是行为学问题。
(01:02:20):
第三本我推荐的是 Jonah Berger 的《疯传》（Contagious）。我非常喜欢这本书。他是斯坦福营销学的博士，写了这本书关于如何让信息病毒式传播。他分析了最成功的病毒式信息并总结成框架。我也在自己的推广中尝试使用其中的一些方法，这是一本非常棒的书。

---

### [01:02:51] Lenny Rachitsky

**English:**
Wow. Got to check this out. I have not. I haven't even heard of it. All right. We're going to go viral because we got the playbook.

**中文翻译:**
哇，我得去看看。我还没读过，甚至没听说过。好了，我们要火了，因为我们拿到了剧本。

---

### [01:02:57] Madhavan Ramanujam

**English:**
Contagious. That's the name of the book.

**中文翻译:**
《疯传》（Contagious），书名就叫这个。

---

### [01:02:58] Lenny Rachitsky

**English:**
Contagious. Okay. We'll link to that. Is there a recent movie or TV show you've really enjoyed?

**中文翻译:**
好的，我们会放上链接。最近有什么你非常喜欢的电影或电视节目吗？

---

### [01:03:04] Madhavan Ramanujam

**English:**
I guess a movie. Sure, let's pick a movie. Definitely enjoyed Mission Impossible, the final one, eighth in the sequence. I think I find that a whole... I love those, the entire genre, one through eight. But what I kind of like about it is my willingness to pay has constantly increased over a period of time. They could have charged me whatever they wanted for the eighth movie. I would've probably gone and seen it, when I wanted to. So I thought that's an interesting example of a durable brand where your monetization power actually increase over a period of time. So I think I enjoyed the movie. It was great. Yeah.
(01:03:43):
Hey, by the way, I just realized MI stands for Monetizing Innovation and also Mission Impossible. Maybe subconsciously that's why I liked it, too.

**中文翻译:**
选部电影吧。我非常喜欢《碟中谍》（Mission Impossible）系列的最后一部，也就是第八部。我喜欢这个系列的全部一到八部。但我喜欢它的原因是：随着时间的推移，我对它的付费意愿在不断增加。第八部电影他们收多少钱我可能都会去看。我觉得这是一个持久品牌的有趣案例，你的变现能力随着时间推移而增强。电影很棒。
(01:03:43):
嘿，顺便说一下，我刚意识到 MI 既代表《货币化创新》（Monetizing Innovation），也代表《碟中谍》（Mission Impossible）。也许潜意识里这也是我喜欢它的原因。

---

### [01:03:52] Lenny Rachitsky

**English:**
And you're the Tom Cruise character.

**中文翻译:**
而你就是汤姆·克鲁斯那个角色。

---

### [01:03:53] Madhavan Ramanujam

**English:**
Yeah, exactly.

**中文翻译:**
哈哈，没错。

---

### [01:03:55] Lenny Rachitsky

**English:**
I love how you're the only person in the world that thinks of Mission Impossible through a monetization, willingness-to-pay lens.

**中文翻译:**
我太喜欢了，你是世界上唯一一个从变现和付费意愿角度看《碟中谍》的人。

---

### [01:04:00] Madhavan Ramanujam

**English:**
Exactly. I think there's too many of these dinner conversations also gravitate towards pricing and monetization. I think it's become my life.

**中文翻译:**
确实。我想我的晚餐谈话有太多都转向了定价和变现。这已经成了我的生活。

---

### [01:04:09] Lenny Rachitsky

**English:**
Oh, man. We need a version of this movie, like a Mission Possible of Madhavan.

**中文翻译:**
天哪，我们需要一个这部电影的版本，比如《Madhavan 的可能任务》。

---

### [01:04:14] Madhavan Ramanujam

**English:**
Sure.

**中文翻译:**
没问题。

---

### [01:04:14] Lenny Rachitsky

**English:**
I'd pay anything for that. All right. Next question. Do you have a favorite product you've recently discovered that you really love?

**中文翻译:**
我愿意为此付任何价钱。好，下一个问题：你最近有没有发现什么非常喜欢的、心头好的产品？

---

### [01:04:22] Madhavan Ramanujam

**English:**
I would probably talk about two products. The first one is Delphi, the Digital Mind representation. There's a Lennybot that you actually, I think, put out. I find that product fascinating, and I also love the founders, Dara and Sam there. I truly believe that that is going to be the future for thought leadership and how thoughts are consumed by consumers.
(01:04:46):
And I've used your Lennybot. I really enjoy it, like if I can co-create some thought leadership piece with talking to you, but it's not you, your AI, and it's actually living and breathing your brain. How cool is that? And I think that I really love the product category. There's a lot of different use cases, longevity, extension, use cases, things of that nature. I'm excited about the product. I think it's been great. I plan to, taking inspiration from you, plan to create a Delphi of myself-
(01:05:15):
... at some point.

**中文翻译:**
我想说两个产品。第一个是 Delphi，它是“数字思想”的呈现。我想你推出的那个 Lennybot 就是用它做的。我觉得那个产品非常迷人，我也很喜欢那里的创始人 Dara 和 Sam。我坚信这将是思想领导力（Thought leadership）以及消费者消费思想的未来。
(01:04:46):
我用过你的 Lennybot，非常喜欢。就像我可以和你对话来共同创作一些思想领导力的内容，但那不是你本人，而是你的 AI，它承载着你的大脑。这多酷啊！我非常喜欢这个产品类别。它有很多不同的用例。受你启发，我也计划在某个时候为自己创建一个 Delphi。

---

### [01:05:15] Lenny Rachitsky

**English:**
Okay. I was going to ask.

**中文翻译:**
好，我正想问呢。

---

### [01:05:16] Madhavan Ramanujam

**English:**
I think it should be the book maybe. I'll try to. That's the promise. Try to keep it ready. So I think if you want to talk more about the book or things of that nature and talk pricing, you can talk to my AI, too, right? I mean, I find the product fascinating.
(01:05:31):
The second one I would probably say that's been super useful in terms of just productivity is Granola. We love that product. I think just the ability to take notes and during all the meetings and organize it and being able to query things, et cetera. I think it's been a great product that we recently started trying and we've been really liking it.

**中文翻译:**
我想也许会基于这本书来做。我会努力准备好的。所以如果你想聊聊这本书或者定价，你也可以和我的 AI 聊。
(01:05:31):
第二个我觉得在生产力方面超级有用的是 Granola。我们很喜欢那个产品。它在会议期间记笔记、整理笔记以及查询信息的能力非常出色。我们最近开始尝试，非常喜欢。

---

### [01:05:51] Lenny Rachitsky

**English:**
Cool. That's been the most mentioned product recently. How cool is that? Love Granola. Get a year free of Granola if you're a paid subscriber to my newsletter, lennysnewsletter.com. Click bundle, one year free for not just you, your whole team. What an offer they offered. It's crazy.
(01:06:05):
On Delphi, what's interesting about LennyBot is it's not just my knowledge, it's every single podcast guest's insights and lessons also fed into it. What an oracle of knowledge this thing's become. And it's free at this point, completely free. Lennybot.com. No, I get nothing from it. It's just out there.

**中文翻译:**
酷，那是最近被提到最多的产品。太棒了，我也喜欢 Granola。如果你是我的通讯（lennysnewsletter.com）付费订阅者，可以免费获得一年的 Granola，不仅是你，还有你的整个团队。这优惠太疯狂了。
(01:06:05):
关于 Delphi，LennyBot 有趣的地方在于它不仅包含我的知识，还喂入了每一位播客嘉宾的见解和教训。它简直成了一个知识神谕。目前它是完全免费的，Lennybot.com。我不从中获利，它就在那儿供大家使用。

---

### [01:06:24] Lenny Rachitsky

**English:**
Okay, next question. Do you have a favorite life motto that you often come back to and find useful in work or in life?

**中文翻译:**
好，下一个问题：你有没有什么最喜欢的人生格言，在工作或生活中经常想起并觉得有用？

---

### [01:06:32] Madhavan Ramanujam

**English:**
Create value in everything and anything that you touch. Everything else will follow. That's my life motto.

**中文翻译:**
在你接触的任何事情中创造价值，其他的一切都会随之而来。这就是我的人生格言。

---

### [01:06:40] Lenny Rachitsky

**English:**
That resonates deeply. Okay, last question. You recently moved into investing. So what's cool is it used to be very expensive to work with at Simon-Kucher, I think it was called. Very expensive. A lot of big company stuff. Now a lot of more founders have access to you because you're investing in startups. So just talk about that. Talk about what you're doing these days.

**中文翻译:**
这引起了深深的共鸣。好，最后一个问题：你最近转向了投资。酷的地方在于，以前在 Simon-Kucher 咨询费非常贵，大多是服务大公司。现在更多创始人可以接触到你了，因为你在投资初创公司。聊聊这个吧，你最近在忙什么？

---

### [01:07:00] Madhavan Ramanujam

**English:**
Sure. I mean, at Simon-Kucher, I got to work with over 250 companies. And my co-GP now, Josh Bloom, he also had an opportunity to work with our 250 companies. So combined, we worked with our 500 companies, more than 50-plus unicorns. It was a great ride.
(01:07:16):
And often, we were actually working with them in much later stages when series D or pre-IPO, post-IPO, private equity companies, et cetera. But the two of us actually now started a venture firm with an explicit goal of working with early-stage AI founders. And it goes back to the topic that we started with. AI companies needs to deal with monetization from day one. But for those kind of companies, fee-for-service transaction model doesn't necessarily work. And that's also why we pivoted to venture.
(01:07:51):
So our business model is pretty standard right now. You get access in the cap table. We roll up our sleeves and work with the founders in all things monetization. So we are invested in their success and we will partake in the value creation. There's no fee for service, no friction on those kind of manners. But on the flip side, we get to concentrate our efforts in fund one and probably 20 to 25 companies, and that's where we will be spending our time.

**中文翻译:**
当然。在 Simon-Kucher 期间，我有幸与超过 250 家公司合作。我的合伙人 Josh Bloom 也曾与 250 家公司合作。加起来我们服务过 500 家公司，50 多家独角兽。那是一段伟大的旅程。
(01:07:16):
但那时我们通常是在 D 轮、IPO 前后或私募股权阶段与他们合作。现在我们两人成立了一家风投公司，明确目标是与早期 AI 创始人合作。这又回到了我们开始的话题：AI 公司需要从第一天起就处理变现。但对于这类公司，传统的咨询服务费模式并不适用。这也是我们转向风投的原因。
(01:07:51):
我们的商业模式现在很标准：我们进入股东名册（Cap table），然后撸起袖子在变现方面与创始人并肩作战。我们投资于他们的成功，并分享价值创造。没有咨询费，没有摩擦。另一方面，我们可以在第一期基金中集中精力服务 20 到 25 家公司，这就是我们将投入时间的地方。

---

### [01:08:16] Lenny Rachitsky

**English:**
What a deal. Madhavan, two final questions. Where can folks find you if they want to reach out and talk about this offer? And how can listeners be useful to you?

**中文翻译:**
这交易太划算了。Madhavan，最后两个问题：如果人们想联系你谈谈那个优惠，去哪里找你？听众能为你做些什么？

---

### [01:08:25] Madhavan Ramanujam

**English:**
Ways to find out, I think just google for Monetizing Innovation and Scaling Innovation. You'll probably land in a lot of pages. You can also go to Amazon, I think, if you want to purchase the books. Actually, Scaling Innovation is now available in pre-order. I think we'll have the pod released before the book is actually out. The book is going to be out on August 5th. So there's an opportunity to pre-order.
(01:08:48):
And maybe I will take an inspiration from your master bundle, which I really think is the world's best bundle, and come up with my own bundle for getting users to pre-order. So if you love Monetizing Innovation, I can tell you you would really love Scaling Innovation. So go buy it for your teams. Buy it for yourself.
(01:09:06):
And here's the offer. So for anyone who's able to buy more than five copies, send us a screenshot of your purchase pre-order, right? Send us a screenshot of your purchase to promo@49palmsvc.com. So that's promo, as in promotion, @49 P-A-L-M-S-V-C .com.
(01:09:30):
And here's the bundle offer that I have. 10 people will get access to bundles as a raffle, and the bundle is going to include a signed copy of Scaling Innovation, a 30-minute ask-me-anything session, an exclusive invite for a Scaling Innovation book launch, and also a Scaling Innovation t-shirt. So that's my coming up with a bundle. I didn't get Granola and others to put in for me just yet, but I think this hopefully suffices and is exciting for folks to buy.
(01:10:01):
And, yeah. I mean if you like the book, please do leave a review on Amazon. That always is helpful. Because if more people review it, the book takes a life of its own. And I'm really thankful for also the support that I got over the years from founder community, from the venture community for Monetizing Innovation. I think there's been, over the last eight years, thousands and thousands of fans of the books. They've done a whole lot talking about it, writing reviews, posting on LinkedIn, and making things like price before product or product market price fit and things as a part of founder vocabulary. So I'm very passionate that people actually did that and very thankful for them. So there's also probably an equal measure. If you're excited about Scaling Innovation, I would love for you to talk about the book.

**中文翻译:**
寻找我的方式：直接谷歌搜索《货币化创新》和《规模化创新》，你会看到很多页面。也可以去亚马逊购买。实际上，《规模化创新》现在已经可以预订了，书将于 8 月 5 日正式出版。
(01:08:48):
受你的“大师捆绑包”启发，我也为预订用户准备了自己的捆绑包。如果你喜欢《货币化创新》，我保证你会非常喜欢《规模化创新》。所以，为你的团队买，为你自己买。
(01:09:06):
优惠如下：任何购买超过五本的人，请将预订截图发送至 promo@49palmsvc.com。
(01:09:30):
我准备了 10 个捆绑包名额进行抽奖，捆绑包包括：一本《规模化创新》签名书、30 分钟的 AMA（有问必答）环节、新书发布会的独家邀请函，以及一件《规模化创新》T 恤。虽然我还没拉到 Granola 赞助，但希望这已经足够吸引大家。
(01:10:01):
另外，如果你喜欢这本书，请在亚马逊上留下评论，这非常有帮助。我非常感谢多年来创始人社区和风投界对《货币化创新》的支持。在过去的八年里，成千上万的粉丝让“定价先于产品”或“产品-市场-价格契合”等词汇成为了创始人的常用词汇。如果你对《规模化创新》感到兴奋，我也希望你能多谈谈这本书。

---

### [01:10:55] Lenny Rachitsky

**English:**
Amazing. And I think the reason people do that is because you give away so much for free. You just shared so much wisdom for free that is going to help so many people, so it all comes back to you.

**中文翻译:**
太棒了。我想人们之所以支持你，是因为你免费分享了这么多。你刚刚免费分享了这么多智慧，将帮助到很多人，所以这一切都会回馈给你。

---

### [01:11:05] Madhavan Ramanujam

**English:**
I just tried to plan my give and get right there.

**中文翻译:**
我刚才只是在实践我的“给予与索取”策略。

---

### [01:11:06] Lenny Rachitsky

**English:**
There we go. Oh my God. A good callback. Madhavan, this was incredible. Thank you so much for being here.

**中文翻译:**
哈哈，说得好。Madhavan，这太精彩了。非常感谢你能来。

---

### [01:11:13] Madhavan Ramanujam

**English:**
Thank you so much, Lenny. Was a pleasure.

**中文翻译:**
非常感谢，Lenny。很愉快。

---

### [01:11:15] Lenny Rachitsky

**English:**
Same. Bye, everyone.
(01:11:18):
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review, as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
我也是。大家再见。
(01:11:18):
非常感谢收听。如果你觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅。此外，请考虑给我们评分或留下评论，这能帮助其他听众发现这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目再见。