# Madhavan Ramanujam - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Madhavan Ramanujam.

---

### (00:00:00) Madhavan Ramanujam

**English:**
When we talk about pricing, many people quickly gravitate to dollar figures. That's just a price point, that's a dollar figure. But when we think about price, we think about it as a measure. Like liter is a measure of volume, price is a measure of value. And when you think of it this way, it really stands for, do people actually want your product and would they actually buy it? And that is their whole willingness to pay conversation. And entrepreneurs and companies need to do this much earlier so that they can understand, are they on the right track?

**中文翻译:**
当我们谈论定价时，很多人会迅速联想到具体的金额。那只是一个价格点，一个数字。但当我们思考价格时，我们将其视为一种衡量标准。就像升是体积的衡量标准一样，价格是价值的衡量标准。当你这样思考时，它实际上代表了：人们是否真的想要你的产品，以及他们是否真的会购买它？这就是所谓的“支付意愿”（Willingness to Pay）对话。创业者和公司需要更早地进行这项工作，以便了解自己是否走在正确的轨道上。

---

### (00:00:31) Lenny

**English:**
Welcome to Lenny's Podcast. I'm Lenny and my goal here is to help you get better at the craft of building and growing products. Today my guest is Madhavan Ramanujam. Madhavan is the author of Monetizing Innovation, the most widely read book on pricing strategy. He's also Senior Partner at Simon-Kucher & Partners, which is the premier consulting agency for companies looking to get help with their pricing. And unsurprisingly, when I asked people on Twitter, who the smartest person on pricing is, Madhavan was by far the most mentioned. In this episode, we get deep into all manner of pricing strategy, specially focusing on five lessons for product teams on thinking about pricing. Enough talking. Let's get into it. I bring you Madhavan Ramanujam after a short word from our wonderful sponsors.

**中文翻译:**
欢迎来到 Lenny 的播客。我是 Lenny，我的目标是帮助你提升构建和增长产品的能力。今天的嘉宾是 Madhavan Ramanujam。Madhavan 是《货币化创新》（Monetizing Innovation）一书的作者，这是定价策略领域阅读量最高的书籍。他还是 Simon-Kucher & Partners 的高级合伙人，这是全球领先的定价咨询机构。不出所料，当我在 Twitter 上询问谁是定价领域最聪明的人时，Madhavan 是被提及次数最多的一位。在本期节目中，我们将深入探讨各种定价策略，特别关注产品团队在思考定价时的五个教训。废话少说，让我们开始吧。在听完赞助商的简短介绍后，我将为你介绍 Madhavan Ramanujam。

---

### (00:01:18) Lenny (Sponsor Break)

**English:**
This episode is brought to you by lemon.io. You've achieved product market fit. You're able to activate, engage, and retain your customers, but you don't have the engineers that you need to move as fast as you want to, because it's hard to find great engineers quickly, especially if you're trying to protect your burden rate. Meet lemon.io. Lemon.io will quickly match you with skilled senior developers who are all vetted, results oriented and ready to help you grow and all that at competitive rates. Startups choose lemon.io because they offer only handpicked developers with three or more years of experience and strong proven portfolios. Only 1% of candidates who apply get in, so you can be sure that they offer you only high quality talent. And if something ever goes wrong, lemon.io offers you a swift replacement so that you're hiring with a warranty. To learn more, just go to lemon.io/lenny and find your perfect developer or tech team in 48 hours or less. And if you start the process now, you can claim a special discount exclusively for Lenny's Podcast listeners. 15% off your first four weeks of working with your new software developer. Grow faster with an extra pair of hands. Visit lemon.io/lenny.

**中文翻译:**
本期节目由 lemon.io 赞助。你已经实现了产品市场契合（PMF），能够激活、留住客户，但你缺乏快速推进所需的工程师，因为很难快速找到优秀的工程师，尤其是当你试图控制成本率时。试试 lemon.io 吧。lemon.io 会为你快速匹配经过审核、以结果为导向的高级开发人员，帮助你以极具竞争力的价格实现增长。初创公司选择 lemon.io 是因为他们只提供拥有三年以上经验和优秀作品集的精选开发人员。只有 1% 的申请者能入选，因此你可以确信他们提供的是高质量人才。如果出现问题，lemon.io 还会提供快速更换服务，让你的招聘更有保障。欲了解更多信息，请访问 lemon.io/lenny，在 48 小时内找到理想的开发人员或技术团队。如果你现在开始申请，还可以享受 Lenny 播客听众专属折扣：前四周合作费用减免 15%。借助额外的人手实现更快增长，请访问 lemon.io/lenny。

---

### (00:02:31) Lenny (Sponsor Break)

**English:**
This episode is brought to you by Mixpanel, offering powerful self-serve product analytics. If you listen to this podcast, you know that it's really hard to build great product without making compromises. And when it comes to using data, a lot of teams think that they only have two choices. Make quick decisions based on gut feelings or make data driven decisions at a snail's pace. But that's a false choice. You shouldn't have to compromise on speed to get product answers that you can trust. With Mixpanel there are no trade-offs. Get deep insights at the speed of thought at a fair price that scales as you grow. Mixpanel builds powerful and intuitive product analytics that everyone can trust, use and afford. Explore plans for teams of every size and see what Mixpanel can do for you at mixpanel.com. And while you're at it, they're hiring. Check out mixpanel.com to learn more. Madhavan, welcome to the podcast.

**中文翻译:**
本期节目由 Mixpanel 赞助，提供强大的自助式产品分析服务。如果你听过这个播客，你就会知道，在不妥协的情况下打造伟大的产品是非常困难的。在利用数据方面，很多团队认为只有两个选择：要么凭直觉快速决策，要么以蜗牛般的速度进行数据驱动决策。但这是一个错误的抉择。你不应该为了获得值得信赖的产品答案而在速度上妥协。有了 Mixpanel，你无需权衡。以思维的速度获取深刻洞察，价格公平且随业务增长而扩展。Mixpanel 打造了每个人都能信任、使用和负担得起的强大且直观的产品分析工具。在 mixpanel.com 探索适合各种规模团队的方案。顺便说一下，他们正在招聘，请访问 mixpanel.com 了解更多。Madhavan，欢迎来到本播客。

---

### (00:03:27) Madhavan Ramanujam

**English:**
Thanks Lenny, pleasure to be here.

**中文翻译:**
谢谢 Lenny，很高兴来到这里。

---

### (00:03:28) Lenny

**English:**
I am really excited to be chatting. You're known as the smartest, maybe most experienced person on pricing strategy in the world. You literally wrote the book on pricing strategy that everyone seems to read and share and talk about. And so I'm really honored to have you on the podcast.

**中文翻译:**
我非常期待这次交流。你被认为是世界上在定价策略方面最聪明、或许也是经验最丰富的人。你写的关于定价策略的书似乎每个人都在阅读、分享和讨论。所以，我很荣幸能邀请你参加播客。

---

### (00:03:44) Madhavan Ramanujam

**English:**
Thanks for the nice words. I'm excited to be here.

**中文翻译:**
谢谢你的夸奖。我也很高兴能来这里。

---

### (00:03:47) Lenny

**English:**
To help folks fully grasp the level of experience that you have around pricing and pricing strategy, could you just talk about, how many companies you worked with, maybe name some companies you can share, maybe how many people bought the book? Anything that you can share about just the level of experience you have in pricing would be helpful.

**中文翻译:**
为了让大家充分了解你在定价和定价策略方面的经验水平，你能谈谈你合作过多少家公司吗？也许可以分享一些公司的名字，或者书的销量？任何能体现你在定价领域经验水平的信息都会很有帮助。

---

### (00:04:05) Madhavan Ramanujam

**English:**
Sure. So I work as a Senior Partner in a consulting company called Simon-Kucher. We are the world's largest pricing strategy consulting firm. We have about 2000 employees worldwide, in our 43 offices. So I work in our Bay Area offices and I've been here for the last 15 years. So I work primarily with tech companies here in the Bay Area, so that's software, internet marketplace companies, et cetera. So I work with over 250 companies, more than 20 unicorns on everything to do with pricing, monetization, profitable growth and these kind of topics. So companies such as Uber, Asana, DoorDash, LinkedIn, many come to mind. I think you asked about the book Monetizing Innovation that I wrote a number of copies, et cetera. Look, when we first launched the book, I used to track some of these copy sales and everything else. And I quickly realized that the book is only good if it actually creates impact. And that's also why we wrote the book. So the way I measure impact for Monetizing Innovation, literally there's probably someone reaching out on a daily basis saying, hey, I read the book, we could make some impact around pricing monetization in our companies. And to me that's real impact. And that's what keeps me going, because when we wrote the book, we didn't want to write any marketing fluffy crap. We wanted to write something that was more actionable. And to see that people find it actionable and can use it Monday morning to actually make changes, I think that's real impact. But of course the book has done well. It is still in top 10 categories in many categories in Amazon, for instance. It's been six years since we wrote the book.

**中文翻译:**
好的。我在一家名为 Simon-Kucher 的咨询公司担任高级合伙人。我们是全球最大的定价策略咨询公司，在全球 43 个办事处拥有约 2000 名员工。我在湾区办事处工作了 15 年，主要与这里的科技公司合作，包括软件、互联网平台公司等。我合作过超过 250 家公司，其中包括 20 多家独角兽企业，涵盖定价、变现、盈利性增长等所有相关话题。像 Uber、Asana、DoorDash、LinkedIn 等公司都在其中。关于你问到的《货币化创新》这本书的销量，其实刚出书时我会追踪销量，但我很快意识到，书只有产生实际影响才有价值。这也是我们写这本书的原因。我衡量这本书影响的方式是：几乎每天都有人联系我说，“嘿，我读了这本书，我们在公司的定价变现方面产生了一些实际影响。”对我来说，这才是真正的影响力。这也是我前进的动力，因为写书时我们不想写那些虚头巴脑的营销废话，我们想写一些更具操作性的东西。看到人们觉得它有用，并且能在周一早上就用来做出改变，我认为这才是真正的成功。当然，书卖得也很好，出版六年了，依然在亚马逊的多个类别中排名前十。

---

### (00:05:46) Lenny

**English:**
Wow.

**中文翻译:**
哇。

---

### (00:05:46) Madhavan Ramanujam

**English:**
Need a second edition soon.

**中文翻译:**
很快需要出第二版了。

---

### (00:05:49) Lenny

**English:**
That's incredible for a software tech oriented book, where they often get really out of date really quickly. I was just reading it and it's amazing how many things still are very true.

**中文翻译:**
对于一本面向软件科技的书来说，这太不可思议了，因为这类书通常过时得很快。我最近刚读过，惊讶于书中竟然有这么多内容在今天依然非常正确。

---

### (00:05:56) Madhavan Ramanujam

**English:**
The topic is one that is relevant in even years to come. So I think hopefully it's robust that way.

**中文翻译:**
这个话题在未来几年依然会具有相关性。所以我希望它在这方面是经得起时间考验的。

---

### (00:06:07) Lenny

**English:**
And you talked about the company Simon-Kucher, I'll just add that any smart product leader, growth person that I talk to, they're always talking about how they've worked with you, to figure out their pricing strategies. It's like the company that everyone goes to work with.

**中文翻译:**
你提到了 Simon-Kucher 这家公司，我想补充一点，我接触过的任何聪明的产品领导者或增长专家，他们总是在谈论如何与你们合作来制定定价策略。这就像是每个人都会寻求合作的“那家公司”。

---

### (00:06:20) Madhavan Ramanujam

**English:**
The Company. I like that. Maybe we should rebrand ourselves as The Company.

**中文翻译:**
“那家公司”。我喜欢这个说法。也许我们应该把品牌重塑为“The Company”。

---

### (00:06:24) Lenny

**English:**
The Company. Let's do it. Let's talk about rebranding next. How did you get into pricing and pricing strategy? How'd you first get into the world and focused your career around it?

**中文翻译:**
“The Company”。就这么办吧。我们下次再聊品牌重塑。你是如何进入定价和定价策略领域的？你是如何开始接触这个领域并将其作为职业重心的？

---

### (00:07:06) Madhavan Ramanujam

**English:**
I actually happened to stumble in it. It's classic fashion. I was at Stanford Graduate School, both Graduate School of Business and the Engineering School. And we had a lot of startup discussions thinking of creating startup, very classic. And I was this guy who was actually in charge of coming up with the pricing monetization strategy in our teams when we were actually pitching to VCs. And I remember going and pitching our ideas and the VC asked me, how do you know you'll actually make money on this innovation? And I pulled up a spreadsheet, I showed him all the assumptions and I said, so I'm going to do it. And I still remember this, he said, you've labeled them correct those assumptions. How do you truly know? And I was like, oh, I actually don't. I just made stuff up. And within that same week I got a call from the then managing partner of Simon-Kucher, Matt Johnson. And he said, hey, we're starting a pricing and growth strategy consulting firm. You want to come join us? We're looking for Stanford grads and I was like, whoa, I didn't even know you existed. I joined because I actually wanted to get to understand the science behind pricing, not just the art. And that's what I've been focusing on in the last 15 years. And also my education in Stanford was in quantitative marketing. So many of those, let's say theoretical models I could bring back into a practical industry in a relevant sense. So it's been a great journey.

**中文翻译:**
我其实是偶然进入这个领域的。非常典型的经历：当时我在斯坦福大学读研究生，同时在商学院和工程学院。我们有很多关于创业的讨论，非常经典。在向风投（VC）进行项目演示时，我负责制定团队的定价和变现策略。我记得有一次去演示我们的想法，VC 问我：“你怎么知道你这项创新真的能赚钱？”我打开一个电子表格，向他展示了所有的假设，然后说：“我就打算这么做。”我至今还记得他的话，他说：“你把这些假设标注得很清楚，但你到底是怎么知道的？”我当时心想：“噢，其实我不知道，我只是瞎编的。”就在那一周，我接到了 Simon-Kucher 当时的管理合伙人 Matt Johnson 的电话。他说：“嘿，我们要成立一家定价和增长策略咨询公司，你想加入吗？我们在找斯坦福的毕业生。”我当时心想：“哇，我甚至都不知道你们的存在。”我加入是因为我想了解定价背后的科学，而不仅仅是艺术。这就是我过去 15 年一直专注的事情。而且我在斯坦福学的是定量营销，所以我可以将许多理论模型以实际的方式应用到相关行业中。这是一段伟大的旅程。

---

### (00:08:18) Lenny

**English:**
When I think about books that people find most useful and sustain or books that are based on people's real experience doing a thing for a decade, and your book is a great example that, what made you decide to actually write a book? Because I know how hard that is from my wife's experience.

**中文翻译:**
当我想到那些人们认为最有用且经久不衰的书，或者是那些基于作者十年实战经验的书时，你的书就是一个绝佳的例子。是什么让你决定写一本书的？因为从我妻子的经验中我知道写书有多难。

---

### (00:08:32) Madhavan Ramanujam

**English:**
Yeah, I think it probably started with some mini frustration, because we used to get calls from companies saying, hey, we need a pricing strategy, we need a price plan. And they would've invested years probably making the innovation. And then we'd ask them, how long do we have? And they're like, we need it yesterday. So time and again, we witnessed this spray and pray approach. And then we used to ask this simple question, how do you truly know that people will actually pay for your innovation, when you built it? Did you do any studies? Did you actually understand whether there's a product market pricing fit? And usually the answer was no. And then it had to change. When we benchmarked 72% of innovations actually fail from a monetization or commercial perspective, simply because entrepreneurs or companies did not do the check earlier on. Had they done it, they could have probably pivoted the product, built things in a different way and built something that was more meaningful. So we wrote Monetizing Innovation because increasingly we were working with companies more early stage in helping them design the right innovations that customers need and what are they willing to pay for, as opposed to just building a product and slapping on a price. So it was crossing that chasm between knowing and hoping that you would, monetize knowing that you truly will. And that was the motivation for writing Monetizing Innovation.

**中文翻译:**
是的，我想这可能始于一种小小的挫败感。因为我们经常接到公司的电话说：“嘿，我们需要一个定价策略，一个价格方案。”而他们可能已经投入了数年时间进行创新。然后我们问：“我们有多少时间？”他们会说：“我们昨天就需要它。”所以，我们一次又一次地目睹这种“撒网式尝试”（spray and pray）的方法。于是我们经常问这个简单的问题：“当你构建这项创新时，你到底怎么知道人们会为此付钱？你做过研究吗？你真的了解是否存在‘产品-市场-价格契合’吗？”通常答案是否定的。这种情况必须改变。根据我们的基准测试，72% 的创新在变现或商业层面是失败的，原因仅仅是创业者或公司没有尽早进行检查。如果他们做了，他们可能会调整产品方向，以不同的方式构建，从而做出更有意义的东西。我们写《货币化创新》是因为我们越来越多地与早期公司合作，帮助他们设计客户真正需要且愿意付费的创新，而不是先造出产品再随便贴个价格。这是为了跨越“希望能够变现”和“确信能够变现”之间的鸿沟。这就是写这本书的动力。

---

### (00:09:58) Lenny

**English:**
Awesome. We're going to dive into a lot of these things that you've shared in the book and things you've learned. One more context setting question before we get into it all, which part of the org do you believe pricing strategies should sit in? Is it product sales, finance, marketing, something else?

**中文翻译:**
太棒了。我们将深入探讨你在书中分享的很多内容以及你的心得。在开始之前，还有一个背景设定问题：你认为定价策略应该归属于组织的哪个部门？是产品、销售、财务、营销，还是其他部门？

---

### (00:10:12) Madhavan Ramanujam

**English:**
Pricing by discipline is a cross-functional discipline. You can't talk pricing in isolation of product, finance, sales, et cetera. There's always touch points. So it's extremely cross-functional. Back in the day, probably a decade ago, I used to say pricing needs to sit in finance, because my view was finance would be the counterbalance to sales, especially if you have sales coming up with pricing in a B2B situation, you can set all the pricing you want, it's human having a human conversation. So how do you put checks and balance in some of that? And my view was pricing should sit in finance and it has to report on ultimately to the CFO. I have, over the last decade, I've been actually advocating that they should sit in the product side. And there was also the genesis of Monetizing Innovation because if we truly believe that we need to build products that are simply products that customers need, they love, they value, they're willing to pay for, it is a product function, because you need to be able to design the product around this information, around what customers need, what they value, and what they're willing to pay for, in short, around the price. If you look at Monetizing Innovation, the subtitle of the book is, How Smart Companies Design Their Products Around the Price. So if you take that viewpoint, then pricing needs to sit in the product function or the founder product and report onto this. This is my strong-held belief, one that probably won't change now.

**中文翻译:**
从学科角度来看，定价是一个跨职能的学科。你不能脱离产品、财务、销售等部门孤立地谈论定价，它们之间总有接触点。所以它是极度跨职能的。大约十年前，我曾认为定价应该归属于财务部，因为我认为财务可以制衡销售，特别是在 B2B 场景下，如果由销售来定价格，无论你设定什么价格，最终都是人与人的谈判。那么如何进行制衡呢？当时我认为定价应设在财务部，并向 CFO 汇报。但在过去十年里，我一直在倡导定价应该设在产品端。这也是《货币化创新》的起源——如果我们坚信需要构建客户需要、喜爱、重视且愿意付费的产品，那么这就是一个产品职能。因为你需要根据这些信息（客户需求、价值感、支付意愿，简而言之就是围绕价格）来设计产品。如果你看《货币化创新》的副标题，它是“聪明公司如何围绕价格设计产品”。如果你接受这个观点，那么定价就必须设在产品职能部门或由创始人负责产品并向其汇报。这是我坚定的信念，目前可能不会改变。

---

### (00:11:44) Lenny

**English:**
Awesome. That's a great segue to the meat of our conversation. So most of the listeners of this podcast are product builders and people that grow, product managers, founders, people that work on cross-functional product teams. And I was reading a book and I picked five topics that I thought would be especially useful to product leaders to dig into. And the first is the, willingness to pay, conversations. Which I know is foundational to the way that you think about pricing strategy and the advice that you share with people of how to think about pricing. So can you just talk about, just what is willingness to pay as a concept? And then when should founders focus on these conversations to figure out the willingness to pay?

**中文翻译:**
太棒了。这很好地过渡到了我们谈话的核心内容。本播客的大多数听众是产品构建者和增长人员、产品经理、创始人以及跨职能产品团队的成员。我在读你的书时挑选了五个我认为对产品领导者特别有用的主题。第一个是“支付意愿”（Willingness to Pay）对话。我知道这是你思考定价策略的基础，也是你给出的核心建议。你能谈谈“支付意愿”作为一个概念到底是什么吗？创始人应该在什么时候关注这些对话以确定支付意愿？

---

### (00:12:22) Madhavan Ramanujam

**English:**
Yeah, absolutely. So I think, look, most of your listeners, most product folks, they probably understand language like product market fit, especially made famous from lead startup and other literature, which is awesome. I think that the issue is, it's not just about product market fit, it is about achieving a product market pricing fit. For instance, if someone comes and asks me, do you like the headset that you're using for this podcast? I'll say, I like it. Do you like it at $200? The whole conversation is different. So if you didn't put pricing as part of your product market fit validation, you're often hearing what you want to hear. It is truly about understanding whether customers are willing to pay for your innovation and willingness to pay is a proxy for, do people actually value your product? And how badly do they actually want the product? And this even comes back to understanding what pricing really is. When we talk about pricing, many people quickly gravitate to dollar figures. That's just a price point, that's a dollar figure. But when we think about price, we think about it as a measure. Like liter is a measure of volume, price is a measure of value. And when you think of it this way, it really stands for, do people actually want your product and would they actually buy it? And that is their whole, willingness to pay conversation. And entrepreneurs and companies need to do this much earlier, so that they can understand, are they on the right track? Think of it this way, if I have the same sales and marketing conversation that I would have with the customer six months before launch of the product, pitch the whole value, and then ask them a simple question, would you pay for this innovation? And if someone says no, chances are you can put all the [inaudible] you want in the next six months, they're going to say the same thing. And if they do say no, the most important question to ask is why. And you start hearing all kinds of information that you can use to design your product and maybe even pivot your product strategy accordingly. So it is literally the litmus test of whether people like your product.

**中文翻译:**
当然可以。你看，大多数听众和产品人员可能都理解“产品市场契合”（Product Market Fit）这个词，它因《精益创业》等文献而闻名，这很好。但我认为问题在于，这不仅仅关乎产品市场契合，还关乎实现“产品-市场-价格契合”（Product Market Pricing Fit）。例如，如果有人问我：“你喜欢你做播客用的这款耳机吗？”我会说：“我喜欢。”但如果问：“你愿意花 200 美元买它吗？”整个对话就完全不同了。如果你没有将定价作为产品市场契合验证的一部分，你听到的往往只是你想听的话。它真正的核心在于了解客户是否愿意为你的创新付费。支付意愿是“人们是否真的看重你的产品”以及“他们有多想要这个产品”的代名词。这又回到了对定价本质的理解。当我们谈论定价时，很多人会迅速想到具体的金额。那只是一个价格点。但当我们思考价格时，我们将其视为一种衡量标准。就像升是体积的衡量标准一样，价格是价值的衡量标准。当你这样思考时，它代表了：人们是否真的想要你的产品，以及他们是否真的会购买它？这就是支付意愿对话。创业者和公司需要更早地进行这项工作，以便了解自己是否走在正确的轨道上。试想一下：如果在产品发布前六个月，我与客户进行同样的销售和营销对话，推销全部价值，然后问一个简单的问题：“你会为这项创新付费吗？”如果有人说不，那么在接下来的六个月里，无论你投入多少精力，他们可能还是会说不。如果他们说不，最重要的后续问题是“为什么”。你会开始听到各种信息，你可以利用这些信息来设计产品，甚至相应地调整产品策略。所以，这简直就是衡量人们是否喜欢你产品的试金石。

---

### (00:14:05) Lenny

**English:**
And so if I were to summarize your main point, the ideas, have these conversations right as you're thinking about designing the product. Don't try to just launch it, see how people like it, build a huge audience and then figure out pricing. Your advice is start having those conversations early, right?

**中文翻译:**
所以，如果我总结一下你的核心观点，那就是：在考虑设计产品时就开始这些对话。不要试图先发布产品，看人们是否喜欢，建立庞大的受众群，然后再去研究定价。你的建议是尽早开始这些对话，对吗？

---

### (00:14:22) Madhavan Ramanujam

**English:**
Exactly. And the folks that first round summarized this in four words, I thought when they wrote a blog article on this, and they call it, price before product, period. So I think that probably succinct, but really it's really that. Because frankly, Lenny, as an entrepreneur, a company, you actually don't have a choice whether you'll have a pricing conversation with your customer. The only thing in your control is when you will have it. You can build the most awesome innovation, you think is awesome, obsess over the engineering, the product and everything else, and then slap on a price [inaudible] in the market and hope to monetize or have this conversation much earlier, pitch the same sales and marketing pitches, and then try to understand whether people will actually pay for it and then design around this information. And you actually know that you will. So you're maximizing your chances for success. It's simply testing and learning. Everyone in your probably listener base knows tests and learn. We are talking about testing and learning pricing and willingness to pay. Why wouldn't you do that? And why would you postpone that to the very end?

**中文翻译:**
没错。First Round 的人在一篇博客文章中用四个词总结了这一点，我觉得非常精辟，那就是：“先定价，后产品”（Price before product），句号。我觉得这很简洁，但事实确实如此。因为坦白说，Lenny，作为创业者或公司，你其实无法选择是否要与客户进行定价对话。你唯一能控制的是“什么时候”进行。你可以构建你认为最棒的创新，痴迷于工程、产品和一切细节，然后随便定个价扔进市场，寄希望于变现；或者，你可以更早地进行对话，进行同样的销售和营销推销，然后尝试了解人们是否真的会付费，并围绕这些信息进行设计。这样你就确信自己能成功。所以你是在最大化成功的机会。这其实就是“测试与学习”。你的听众肯定都知道“测试与学习”，我们谈论的是对定价和支付意愿进行测试与学习。你为什么不这样做呢？为什么要把它推迟到最后呢？

---

### (00:15:24) Lenny

**English:**
Do you have any examples of products or companies where they have these conversations either way too early, way too late, or even just nailed it?

**中文翻译:**
你有没有一些产品或公司的例子，说明他们在这些对话上要么做得太早，要么太晚，或者做得恰到好处？

---

### (00:15:31) Madhavan Ramanujam

**English:**
Here's the thing, there's nothing way too early for this conversation. I even tell people who are early C-stage or just thinking about an idea, I would say, hey, go check, so if someone would actually pay for this idea. And there's some high level ways to actually check for this. And of course there's not about nailing the pricing strategy from get-go, three years before a product is launched, et cetera. It's about understanding whether there is a willingness to pay and then repeating this exercise as you go along so that you can refine and when you're ready to launch the product, you have a much more refined view on what is the willingness to pay. And of course then you're launching the product with a lot more enthusiasm, because you know this is actually going to have a product market pricing fit. So it's about iterating and learning and refining. So there's never too early. Too late, I think is more so the companies, this is why we wrote Monetizing Innovation. Like I told you. 72% of innovations fail and we also categorize them into why they fail. There are only four failure types and I have written about that in the book, so I can leave that for readers to actually go and see it. But all of those failure types happen because the conversation was just too late and pricing was an afterthought. Companies that did it well, maybe one or two examples that I can probably take just to motivate the concept, we talk about in the first chapter a tale of two cars and about how Porsche actually did this. And the example is something like this relevant, Porsche was really looking for launching a new innovation. They came up with an idea. They said, okay, should we launch an SUV? And even before a blueprint was drawn, they basically went and checked with the market, is there a need for an SUV? Would people value it from Porsche? Are they willing to pay for it? And to their surprise, they actually found that. And then what they did next was more fascinating. Every single feature that actually went into the car or the benefit that people had, was battle-tested with customers and no amount of convincing from product or engineering was enough. It had to be battle-tested with customers. Things like, for instance, big cup holder was inside because people loved it, needed an SUV would pay for it. Things like six feet manual transmission. People didn't need an SUVs out of the window. They literally used to bring cars in what is called as car clinics. And they would test for this and they would put people through prototypes before anything is even productized, anything is in the factory floor, where people would actually even drive around the Porsche and say, okay, did they like it? Would they pay for it? Et cetera. And then they would fine tune everything as thing that goes on. So the innovation process is very different from the classic spray and pray, build something, slap on a price, throw it out. It was really designing the product around customer feedback, around willingness to pay. The outcome of the process could also couldn't have been more different than the traditional approach of spray and pray. And this was when they launched this SUV, it was called Cayenne, which we all know now, and it accounts for more than half of Porsche's profit and literally one of the best rolling successes in automotive history. There's just an automotive example, but if I switch gears to more of a tech example or a software example for your audience, there was this company which, think of this as a two-sided marketplace, and I'll just keep it a bit abstract, but I'll tell you the details. Two-sided marketplace, think of this as they were already monetizing on the sell side and the CEO said, okay, let's go and build a product for the buy side that people will buy. So the buy side monetization product strategy. So in classic fashion, all the product folks, product managers, et cetera, they went offsite, generated thousands of post-it notes, design thinking, yada yada, everything. And then they said, okay, we can't take all of these so many ideas to the CEO, let's prioritize it somehow. And they prioritized it to 40 ideas and they took it to the CEO and said, this is what we want to build. And the CEO asked a simple question, how do you truly know you would monetize? It's the same question the VC asked me, back in the day, and they simply didn't know. They were just guessing. So what happened next was they took wire frames, blueprints, they took product concepts and they started testing this with their customers and prospects. So stuff that they actually thought was exciting, often was way down in the list of priorities. And if they didn't do these kind of tests, they would've probably built the product around this. To give you an example, one of the features that they were building was called, or the number one feature that the internal team thought was awesome, they called it Highlight Connections from Facebook. And everyone in the company thought that people would pay for this. It's an awesome feature, they need it, they love it. And the thesis was something like this. As a buyer, if I'm buying the product from the same seller and someone in my Facebook connection has already bought that product from that seller, that's credible information in lieu of reviews and everything else, and people would find it acceptable and pay for this. When they went and tested this and pitched the idea, they got all kinds of reactions. So there was one customer group I remember which said, so yeah, you're telling me I can't pull 200 of reviews and make my own determination? That's unacceptable. That spoils the fun out of actually doing research on products. There was another group of customers who said, do you like it? Yeah, I like it. Would you pay for it? Hell no. And then there was another group which even said, I don't even want anyone in my Facebook circle to know that I'm buying this product. Because there was some, let's say, premiumness associated with this and everything else. They could not find a single set of customers or a segment of customers who said, I love this feature, I would pay for it. If they hadn't done this exercise, they would've built the entire product around this and it would've been a disaster. But because they actually did this, they could prioritize what they were building. Literally, for your product folks, the number one lesson, and I hope this is the biggest takeaway for your audience, you cannot prioritize a product roadmap without having a willingness to pay conversation. If you're just prioritizing based on what you think or what you feel or technical resources, you're getting it wrong. Literally, you can prioritize what you are building based on what customers need, what they value, and what they're willing to pay for. And you can actually do this test and say, what should you be building? The funny thing that I've actually always seen, always, across these hundreds of companies that I've worked, 20% of what you build drives 80% of the willingness to pay, is a classic burrito. And if you don't know this, you're probably all indexing on one or the other. It's much better to find out what is this 20% so that you can focus on it, nail it, and focus on all of the usability around it and make an awesome product as opposed to not knowing what drives the willingness to pay and just trying to put everything out there. And at the worst form, often what happens then is this 20% is the easiest thing to build. And what companies do is they will build it, they will throw it out and they'll say, there's an MVP, give it for free. And then they're trying to chase their tails, building 80% of stuff that is driving 20% of value. So you all already lost the battle. So as a product person or a product builder, you need to prioritize your R&D roadmap based on willingness to pay conversations, exactly like what the two-sided marketplace did, exactly like what Porsche did. And this is the crux of everything that we are talking about.

**中文翻译:**
事情是这样的，这种对话永远不会嫌早。我甚至会告诉那些处于早期种子轮或刚有一个想法的人：去检查一下，看看是否有人真的会为这个想法买单。有一些高层级的方法可以进行这种检查。当然，这并不是说要在产品发布前三年就定死定价策略，而是要了解是否存在支付意愿，并在过程中不断重复这个练习，以便进行微调。当你准备发布产品时，你对支付意愿就会有一个更精确的认识。当然，到那时你发布产品时会更有热情，因为你知道这确实符合“产品-市场-价格契合”。所以这是一个迭代、学习和完善的过程。所以永远不会嫌早。至于太晚，我认为大多数公司都是这种情况，这也是我们写《货币化创新》的原因。正如我告诉你的，72% 的创新失败了，我们也对失败原因进行了分类。失败类型只有四种，我在书里写过，读者可以去看看。但所有这些失败类型都是因为对话太晚，定价成了事后的想法。做得好的公司，我可以举一两个例子来阐述这个概念。我们在第一章谈到了“两辆车的故事”，讲的是保时捷是如何做的。保时捷当时想推出一项新创新，他们想：我们要不要推出一款 SUV？在图纸还没画出来之前，他们就去市场上调研：人们需要 SUV 吗？人们会看重保时捷出的 SUV 吗？他们愿意为此付钱吗？令他们惊讶的是，答案是肯定的。接下来的做法更迷人：进入车内的每一个功能或带给人们的益处，都经过了客户的实战测试，产品或工程部门的任何说服都不管用，必须经过客户测试。例如，车内有大杯架，因为人们喜欢它，需要它，并愿意为此付钱。而像六速手动变速箱，人们在 SUV 上不需要，就被去掉了。他们甚至会把车带到所谓的“汽车诊所”，在产品化或进入工厂生产线之前，让人们体验原型车，甚至开着保时捷转一圈，然后问：他们喜欢吗？愿意付钱吗？等等。然后随着过程的推进，他们会微调一切。所以这种创新过程与传统的“撒网式尝试”（造个东西，贴个价，扔出去）截然不同。它是真正围绕客户反馈和支付意愿来设计产品。这种过程的结果也与传统方法完全不同。当他们推出这款名为 Cayenne（卡宴）的 SUV 时，大家都知道，它贡献了保时捷一半以上的利润，简直是汽车史上最成功的案例之一。这只是一个汽车行业的例子。如果我转到更适合你听众的科技或软件例子，有一家公司，你可以把它想象成一个双边市场。他们已经在卖方实现了变现，CEO 说：“好吧，让我们为买方构建一个人们会购买的产品。”也就是买方变现产品策略。按照传统方式，所有的产品经理等人都去场外开会，贴了成千上万张便签纸，搞设计思维等等。然后他们说：“我们不能把这么多想法都拿给 CEO，得排个优先级。”他们筛选出 40 个想法拿给 CEO 说：“这就是我们要做的。”CEO 问了一个简单的问题：“你到底怎么知道你能变现？”这和我当年被 VC 问到的问题一模一样。他们根本不知道，只是在瞎猜。接下来发生的是，他们拿着线框图、蓝图和产品概念，开始在客户和潜在客户中进行测试。结果，他们认为令人兴奋的东西，往往在优先级列表中排得很靠后。如果他们没做这些测试，他们可能就会围绕这些东西构建产品。举个例子，他们正在构建的功能之一，内部团队认为最棒的功能，叫做“显示来自 Facebook 的联系人”。公司里的每个人都认为人们会为此付钱。这是一个很棒的功能，人们需要它，喜爱它。其逻辑是：作为买家，如果我从某个卖家那里买东西，而我的 Facebook 好友也从那个卖家那里买过，这就是除了评论之外最可信的信息，人们会接受并为此付钱。当他们去测试并推销这个想法时，得到了各种各样的反应。我记得有一组客户说：“所以，你是说我不能自己看 200 条评论并做出判断？这不可接受，这剥夺了研究产品的乐趣。”另一组客户说：“你喜欢它吗？”“喜欢。”“你会付钱吗？”“绝对不会。”还有一组甚至说：“我甚至不想让我的 Facebook 圈子里的人知道我在买这个产品。”因为这涉及到一些溢价感之类的东西。他们找不到一组客户或一个细分市场说“我喜欢这个功能，我愿意付钱”。如果他们没做这个练习，他们就会围绕这个功能构建整个产品，那将是一场灾难。但因为他们做了，他们就能确定开发的优先级。真的，对于产品人员来说，头号教训（我希望这是听众最大的收获）是：如果没有关于支付意愿的对话，你就无法确定产品路线图的优先级。如果你只是根据你的想法、感觉或技术资源来排优先级，你就错了。你可以根据客户的需求、价值感和支付意愿来确定开发优先级。你可以通过测试来决定应该构建什么。我在合作过的数百家公司中总是看到一个有趣的现象：你构建的 20% 的功能驱动了 80% 的支付意愿，这是经典的帕累托法则。如果你不知道这一点，你可能在所有功能上平均用力。最好找出这 20% 是什么，这样你就可以专注于它，把它做好，围绕它做好易用性，打造出一款出色的产品，而不是在不知道什么驱动支付意愿的情况下，试图把所有东西都推出去。最糟糕的情况往往是，这 20% 的功能反而是最容易构建的。公司往往会先构建它，扔出去，然后说“这是 MVP，免费提供”。然后他们就开始拼命追赶，去构建那些只驱动 20% 价值的 80% 的功能。所以你已经输掉了这场战斗。作为产品人员或产品构建者，你需要根据支付意愿对话来确定研发路线图的优先级，就像那个双边市场公司所做的，就像保时捷所做的。这就是我们讨论的所有内容的核心。

---

### (00:23:16) Lenny

**English:**
Amazing. What's interesting about the second example versus the first is in the Porsche example, they started with, we want to charge this much. Let's build a car that we can sell for that much. And the second case, they had a product they were trying to build, and then they figured out which things to build. So it's interesting that this can come along the journey at different places, but the main takeaway is do it early and earlier than you think.

**中文翻译:**
太棒了。第二个例子与第一个例子的有趣之处在于，在保时捷的例子中，他们是从“我们想卖这个价钱”开始的，然后“让我们造一辆能卖这个价钱的车”。而在第二个案例中，他们已经有了想要构建的产品，然后弄清楚该构建哪些功能。所以有趣的是，这可以在旅程的不同阶段出现，但核心收获是：尽早做，比你想象的还要早。

---

### (00:23:41) Madhavan Ramanujam

**English:**
Correct. Either productize to a price point and the willingness to pay, or at least use willingness to pay as an access to prioritize what you're building. Either way, you'll get it right.

**中文翻译:**
没错。要么根据价格点和支付意愿进行产品化，要么至少将支付意愿作为确定开发优先级的维度。无论哪种方式，你都能做对。

---

### (00:23:50) Lenny

**English:**
Okay, so let's actually talk about how to have these conversations. I imagine that's what a lot of people are wondering right now. It's like, yes, I'm convinced I will have these conversations, but then the classic issue with customers, you ask them what they all do and you can't trust their stories of what they'll actually do. So what advice do you have for folks when they have these conversations? What questions should they ask? What words should they use? I know you have a few frameworks that you suggest, you can talk about that.

**中文翻译:**
好，那我们来谈谈如何进行这些对话。我想很多人现在都在想：“是的，我被说服了，我会去进行这些对话，但客户有个经典问题——你问他们会做什么，但你不能相信他们关于自己实际行为的说法。”那么，对于进行这些对话的人，你有什么建议？他们应该问什么问题？应该用什么词汇？我知道你建议了一些框架，可以谈谈吗？

---

### (00:24:15) Madhavan Ramanujam

**English:**
Yeah, we can go deep into this and you can pull me back or ask me to go deeper, whatever. It doesn't matter. So I've written an entire chapter in the book, chapter four, it's called How to Have the Willingness to Pay Conversation. If there's one chapter, just read that. It's quite detailed and goes into how to actually do this. But look, if you go and ask someone, how much should I charge for this product? You're actually going to get garbage back. That's your job. No one is supposed to tell you how much to charge, and that's the worst way to have the conversation. There are some really interesting and nuanced ways of having the conversation where you still tease out what people are willing to pay for without directly confronting someone as to what you should be charging. So let me go into a few methods and I can pause to see if you have any questions. So the first one is, what we say is frame. The first one is, what we say is, "Frame the question in a more relative manner", because, and sometimes I say tongue in cheek, that, "People are absolutely meaningless, relatively super smart." What I mean by that is, if you go and ask someone, "How much should I charge?" You'll get a meaningless answer. But if you actually ask it in a relative way, people actually give responses that are meaningful. So for instance, if you're a B2B SaaS company, and you're trying to see if your product actually has willingness to pay, one way to have that conversation is to say, "Okay. Hey, do your customers, do you use products like Salesforce in your install base?" "Yeah, I do use." "Okay, Salesforce was indexed at 100 in value. Where do you think we are in terms of the value that we bring to your, let's say, day to day business operations?" That people can answer all day long. They might say, "80", they might say, "120", depending on whether you're more or less compared to, let's say, what a Salesforce can do, which is an established [inaudible]. And then if you say, "Okay, if Salesforce was indexed at a 100 in pricing, where do you think we should be?" That also people can say, okay, if they say 110, what they're saying is, you can be more premium than that and we would still pay for it. At least you've gotten some information that is meaningful at a very basic level. So this is some relative ways of asking these questions are the most basic ways of actually doing it.

**中文翻译:**
好的，我们可以深入探讨，你可以随时叫停或让我讲得更深。我在书里写了整整一章，第四章，题目就叫《如何进行支付意愿对话》。如果只读一章，就读那一章。它非常详细地介绍了具体做法。但听着，如果你直接问某人：“我该为这个产品收多少钱？”你得到的只会是垃圾信息。那是你的工作，没人应该告诉你该收多少钱，那是进行对话最糟糕的方式。有一些非常有趣且微妙的方式可以套出人们愿意为什么付钱，而不需要直接问你应该收多少钱。让我介绍几种方法。第一种是“以相对的方式设定问题框架”。我有时开玩笑说：“人在绝对判断上毫无意义，但在相对判断上超级聪明。”我的意思是，如果你问“我该收多少钱？”，你会得到一个毫无意义的答案。但如果你以相对的方式问，人们会给出有意义的回答。例如，如果你是一家 B2B SaaS 公司，想看看你的产品是否有支付意愿，一种对话方式是：“嘿，你们在现有的系统中使用像 Salesforce 这样的产品吗？”“是的，我们用。”“好，如果把 Salesforce 的价值指数定为 100，你认为我们在为你们日常业务运营带来的价值方面处于什么位置？”这个问题人们可以对答如流。他们可能会说“80”或“120”，取决于你与 Salesforce 相比的价值高低。然后如果你说：“好，如果 Salesforce 的定价指数是 100，你认为我们的定价应该在哪里？”人们也能回答。如果他们说 110，他们其实是在说：“你可以比它更高端，我们仍然会付钱。”至少你在非常基础的层面上获得了一些有意义的信息。这是询问这些问题最基本的方法。

---

### (00:26:18) Madhavan Ramanujam (Continued)

**English:**
Then we have questions where there's some methods where we actually want to understand, are there some psychological thresholds or budgets when it comes to willingness to pay? So the way to do this is let's take your product that you're going to launch, pitch the value to your customers, have that exact sales and marketing conversation that you'd have after you launch the product, but before. And then you ask them, "What do you think is an acceptable price for this innovation?" Look, everyone would like to low ball, they'll negotiate with themselves. Let them give an answer, clock it, then ask them, "What do you think is an expensive price?" And then follow that with, "What do you think is a prohibitively expensive price?" And across thousands of projects that we have done, what we have come to realize is, acceptable price is the price where people not only love the product, but they also love the price. If you're in true growth mode, maybe you can put it there as a no-brainer price, no friction, et cetera. The expensive price tends to be the price that is value priced, as in, they don't love you, they don't hate you, they would pay you, but that's a neutral reaction. Prohibitively expensive tends to be the price that they'll laugh you out the room. And if you do this at scale, what you'll start seeing is that there are some cliffs in these demand curves, where suddenly, when you cross from let's say 99 to 101, 20 or 30% might say, "It is expensive," or, "Hey, it's prohibitively expensive." And that's what we look for to see if there are some psychological thresholds that if you actually cross, you have a perception of being expensive. So hiding behind some of these psychological thresholds become important. Rahul Vohra from Superhuman actually read the book, and he talked about this in an a16z podcast. He actually used this method to come up with his $30 price point for the Superhuman app. And I think that's a quick and dirty way to actually get to, what is a willingness to pay, and what's a psychological threshold? So I think that's a interesting method that you can do Monday morning.

**中文翻译:**
然后我们还有一些方法，旨在了解在支付意愿方面是否存在心理阈值或预算限制。具体做法是：拿你要发布的产品，向客户推销其价值，进行与产品发布后完全一样的销售和营销对话，但要在发布前进行。然后问他们：“你认为这项创新的‘可接受价格’是多少？”听着，每个人都想报低价，他们会和自己讨价还价。让他们给出一个答案，记录下来。然后问：“你认为‘昂贵的价格’是多少？”接着问：“你认为‘高得离谱的价格’是多少？”在我们做过的数千个项目中，我们意识到：“可接受价格”是人们不仅喜欢产品、也喜欢价格的价格。如果你处于纯增长模式，也许可以把价格定在这里，作为一个无需思考、无摩擦的价格。而“昂贵的价格”往往是“价值定价”，即他们不爱你也不恨你，他们会付钱，但反应中性。“高得离谱的价格”则是他们会把你哄出房间的价格。如果你大规模地这样做，你会开始看到需求曲线中出现一些“悬崖”。例如，当你从 99 跨越到 101 时，突然有 20% 或 30% 的人会说“这太贵了”或“这高得离谱”。这就是我们要找的心理阈值，一旦跨过，就会产生“昂贵”的感知。所以，躲在这些心理阈值后面变得非常重要。Superhuman 的 Rahul Vohra 读过这本书，他在 a16z 的播客中谈到过这一点。他实际上就是用这种方法为 Superhuman 应用确定了 30 美元的价格点。我认为这是一种快速有效的方法，可以了解支付意愿和心理阈值。这是你周一早上就能开始做的有趣方法。

---

### (00:28:16) Madhavan Ramanujam (Continued)

**English:**
But the key here is to not just ask the question, "What would you pay?" But have that sales and marketing conversation. Tell people where they actually might get the benefits. Basically, exactly everything you would do after launching the product to create awareness and showcase the benefits, do it, and then ask these questions, so that you're priming them to the value that your product gets and you're not just having a random conversation. There are other techniques that go more and more, let's say, rigorous. For instance, purchase probability questions. So if you ask someone, "Okay, would you buy this product?" That's a meaningless question. At least if you ground them on a scale and say, "On a scale of one to five, would you buy it?" One is, "I'm not at all interested", five is, "Most likely I would buy it," or, "I would buy it for certain." And four is, "Most likely", for instance, and three is, "I'm neutral." What we are actually seeing is, even if people say, "Five", they are probably only 30 to 50% sure about whether they would buy, so you can start, and if they say, "Four", it's 10 to 20%. If they say, "Three and below", they're never going to buy it. So if you do this at scale, you can start coming up with, let's say a demand curve. And then say, "Where is the price optimal?" et cetera. So you can understand purchase probabilities. And if someone says, let's say, three, for a certain price point, then you can lower the price and say, okay, would they actually move their ratings to a four or five. So I think these are some simple ways to understand purchase probabilities and elasticities.

**中文翻译:**
但这里的关键不仅仅是问“你会付多少钱？”，而是要进行销售和营销对话。告诉人们他们能从中获得什么好处。基本上，把你发布产品后为了提高知名度和展示益处所做的一切都做一遍，然后再问这些问题。这样你就在为他们灌输产品的价值，而不是在进行随意的谈话。还有其他更严谨的技术。例如，“购买概率”问题。如果你问某人：“你会买这个产品吗？”，这是一个毫无意义的问题。至少你应该让他们在一个量表上打分，比如：“从 1 到 5 分，你会买吗？”1 分是“完全没兴趣”，5 分是“极有可能购买”或“肯定会买”，4 分是“很有可能”，3 分是“中立”。我们实际观察到的是，即使人们说“5 分”，他们购买的可能性大概也只有 30% 到 50%；如果说“4 分”，可能性只有 10% 到 20%；如果说“3 分及以下”，他们根本不会买。如果你大规模地这样做，你就可以画出一条需求曲线，然后分析“最优价格在哪里”等等。这样你就能理解购买概率和价格弹性。如果有人对某个价格点打 3 分，你可以降低价格，看他们是否会将评分提高到 4 分或 5 分。我认为这些是理解购买概率和弹性的简单方法。

---

### (00:29:51) Madhavan Ramanujam (Continued)

**English:**
Two more, if I may, I think, another one is what we call is most and least questions. And the thesis behind this is, if you go and ask people, "Okay, I give them a list of 10 features", let's say. And I say, "Rank them one to 10", most people will find that exercise painful, horrible, because there's always this messy middle where everything is gray. They all look the same. There's a lot of psychological theory that people are very adept at identifying the extremes. When it gets in the between, that's when things become tougher. So what we do is, if we have a list of 10 features that we want to understand whether people have willingness to pay for, when we are prioritizing the R&D roadmap for our clients, we would take a subset of, let's say six or so features out of those 10. And then they say, "In this set of features, identify the most important for you, and the least important." And the most important is defined as, "Must have, I will pay for it." Least important is, "I don't need it. I won't pay for it", connotation. This, people can do all day long, because they're just picking the two. And then we will change the set of six, another combination from the 10, and ask that same question. So if you do this a few times, you will be able to prioritize the entire feature set in a relative fashion, and truly understand what drives willingness to pay.

**中文翻译:**
如果可以的话，再介绍两种。另一种是我们所谓的“最重要与最不重要”问题（MaxDiff）。其背后的理论是：如果你给人们 10 个功能的列表，让他们从 1 排到 10，大多数人会觉得这个练习很痛苦、很糟糕，因为总会有模糊的中间地带，看起来都差不多。心理学理论认为，人们非常擅长识别极端情况，而中间地带则很难。所以我们的做法是：如果我们有 10 个功能想了解人们的支付意愿，在为客户确定研发路线图优先级时，我们会从这 10 个功能中取出一个子集，比如 6 个。然后让他们说：“在这组功能中，找出对你最重要和最不重要的一个。”“最重要”定义为“必须拥有，我会为此付钱”；“最不重要”意味着“我不需要，不会为此付钱”。这种事人们可以一直做下去，因为他们只需要选出两个极端。然后我们会更换这 6 个功能的组合，再问同样的问题。如果你多做几次，你就能以相对的方式对整个功能集进行优先级排序，并真正了解是什么驱动了支付意愿。

---

### (00:31:08) Madhavan Ramanujam (Continued)

**English:**
The last method, which gets into more advanced methodology, is what we call is more trade-off exercises. So here, what we do is we put people through actual buying patterns, or actual buying scenarios and say, "Okay, if you had this packaging and pricing, for instance, for your software product, what would you do?" Which is akin to a real life question. You [inaudible] the features, all the price, the number of plans, et cetera. Then we would change that and say, "Okay. If you change the features and the price, how would you react? Would you buy any of these products? Or would you say, I won't choose any of these?" These are more like shopping scenarios for your products, but it's realistic, and it's akin to real life. Based on how they choose these products, what we are trying to reveal is the mental models and rules that people use to make decisions. For instance, if I add certain amount of features and increase the price, people say, "You know what? I'm not going to buy anything more." What that actually tells you is the addition of those features, people are not willing to pay the addition in terms of price, so they would actually opt out of the lineup that you actually have for your customers. So these kind of things, if you do these kind of exercise, you can get more precise on things like price elasticity, build some simulation models, try to understand how the market would react, et cetera. And different methods are actually applicable at different stages of a product and different stages of a company. If you're very early stage, let's say just an idea, just have the conversation. Just even asking, would you pay for it, is a good question because if someone says no, then ask why. Then you'll hear a lot of good information. If someone says yes, ask them, why would you pay for it, they would articulate back the value that they understood, and that should be in your value messaging. So that's just the simple questions. If you are somewhere in middle, then maybe some of these, if you're in the [inaudible] seat stage, maybe some of the purchase property questions, all of these things can actually be a quick and dirty way to at least get to an answer and a point of view. Or if you're launching a product and it's in late stage or late stage in the product or the company lifecycle, and you need to get more precise in terms of your pricing and packaging strategy, then some of the methods are around trade off exercises, most, least, all of these things become incredibly relevant. Sorry, it was a long answer, but there are so many methods. It's all summarized in chapter four. So just one chapter to read in the book.

**中文翻译:**
最后一种方法涉及更高级的方法论，我们称之为“权衡练习”（Conjoint Analysis）。在这里，我们让人们置身于实际的购买模式或场景中，问：“如果你的软件产品有这样的包装和定价，你会怎么做？”这类似于现实生活中的问题。你展示功能、价格、方案数量等。然后我们会改变这些变量并问：“如果改变功能和价格，你会如何反应？你会购买其中任何一个产品吗？还是说你一个都不选？”这更像是针对你产品的购物模拟，非常真实且贴近生活。根据他们如何选择这些产品，我们试图揭示人们做决策时的心理模型和规则。例如，如果我增加某些功能并提高价格，人们说：“你知道吗？我不会再买更多了。”这实际上告诉你，对于增加的那些功能，人们不愿意支付额外的价格，因此他们会退出你为客户准备的产品阵容。如果你做这类练习，你可以更精确地了解价格弹性，建立模拟模型，尝试理解市场会如何反应等等。不同的方法适用于产品和公司的不同阶段。如果你处于非常早期，比如只有一个想法，那就直接去对话。甚至只是问“你会付钱吗”也是个好问题，因为如果有人说不，你可以问“为什么”，你会听到很多有用的信息。如果有人说会，问他们“为什么愿意付钱”，他们会阐述他们理解的价值，而这应该出现在你的价值主张中。这些只是简单的问题。如果你处于中间阶段，比如种子轮，购买概率问题等可以作为快速获取答案和观点的方式。如果你正在发布产品，处于产品或公司生命周期的后期，需要更精确的定价和包装策略，那么权衡练习、最重要/最不重要分析等就会变得极其相关。抱歉，回答有点长，但方法确实很多。所有这些都总结在第四章。所以书里只要读那一章就行。

---

### (00:33:15) Lenny

**English:**
That was perfect. Thank you. Amazing. You mentioned that you want to ask why a lot, and that's something you talk about in your book a bunch. I think something like 50% of your questions should be why, after they answer these questions. Is that right?

**中文翻译:**
太完美了，谢谢。太棒了。你提到要经常问“为什么”，这也是你在书里多次谈到的。我想，在他们回答这些问题后，大约 50% 的问题应该是“为什么”，对吗？

---

### (00:33:29) Madhavan Ramanujam

**English:**
That's absolutely right. Yeah. I was tempted to ask you why, but that would've not been very relevant.

**中文翻译:**
完全正确。是的。我刚才差点想问你“为什么”，但那可能不太相关。

---

### (00:33:35) Lenny

**English:**
Nope, not on this question. I might take care of that later. Can you talk about, logistically, how are you asking these? Is this a meeting specifically you set up with a potential customer to talk about pricing? Does it come at the end of, here, I'm pitching you on this product, or I'm trying to get desirability research feedback? What is that meeting set up for on behalf of the customer?

**中文翻译:**
不，这个问题不用问。我待会可能会处理那个。你能谈谈在操作层面上你是如何询问这些问题的吗？是专门为了谈定价而约潜在客户开会吗？还是在推销产品或进行需求调研反馈的最后顺便问一下？从客户的角度来看，这个会议的目的是什么？

---

### (00:33:56) Madhavan Ramanujam

**English:**
It's usually either a one-on-one conversation with a customer, much early stage, you're a founder and you're having a conversation. It's basically, you're pitching the idea and trying to understand not just product market fit, but a product market pricing fit. Let's say, if you're a bit more late stage and you have a cross-functional team, this could be a conversation that the sales teams could actually be having along with the product teams to actually understand this. That's also what happens in companies like LinkedIn for instance, when they launch a new innovation. The team has to book in a credit card or lock in a budget from a customer for pilot POCs and everything else, and if they don't, they don't necessarily go down the route of productizing it because there was no final verdict on whether people would actually pay for these innovations. That's how I see it. So it depends. If it's early stage, more like founder led early conversations, if it's more late stage, then a cross-functional conversation, but usually, it's a one-on-one with, one-on-one as in with the company, it could be more multiple decision makers. Increasingly, in B2B SaaS for instance, it's not just one person deciding on a software budget, it's a team. So it's usually done with the team having that kind of conversation. It can also be done in terms of focus groups where you bring in a set of customers and then you mediate and moderate answers and trying to get to what is the right thing to do. And often, we also do a quantitative version of this where we are doing more test and learn through either AB testing or, most importantly, through controlled surveys that we would actually have, invite participants to actually participate and then they would give their opinions on these various concepts that we are actually testing. And then we try to understand what is the willingness to pay in the market based on those responses. So from a basic qualitative one-on-one validation all the way to more quantitative testing using other instruments.

**中文翻译:**
通常有两种情况。在非常早期，这可能是创始人与客户的一对一对话。基本上你是在推销想法，并试图理解不仅是产品市场契合，还有产品-市场-价格契合。如果你处于后期，拥有跨职能团队，这可能是销售团队与产品团队共同进行的对话。例如在 LinkedIn 这样的公司，当他们推出新创新时，团队必须让客户为试点（POC）刷信用卡或锁定预算。如果做不到这一点，他们就不一定会走产品化路线，因为对于人们是否真的会为这些创新付费还没有最终定论。我是这么看的。所以这取决于阶段：早期更像是创始人主导的对话；后期则是跨职能对话。通常是与公司的一对一（这里的“一”可能指多个决策者）。在 B2B SaaS 中，决定软件预算的往往不是一个人而是一个团队，所以通常是与团队进行这种对话。也可以通过焦点小组的形式，召集一组客户，由你主持并引导回答，以找出正确的做法。通常我们也会做定量版本，通过 AB 测试，或者最重要的是通过受控调查，邀请参与者对我们测试的各种概念发表意见。然后我们根据这些反馈来理解市场的支付意愿。所以，从基础的定性一对一验证，到使用其他工具进行更复杂的定量测试，都有可能。

---

### (00:35:45) Lenny

**English:**
So this is usually a part of a larger customer development product market fit discussion, here's a product we're thinking, here's classic user research. Desirability discussion, and at the end you talk about willingness to pay stuff. Is that-

**中文翻译:**
所以这通常是更大的客户开发或产品市场契合讨论的一部分，比如“这是我们正在构思的产品”，这是经典的用户研究、需求讨论，然后在最后你谈论支付意愿的内容。是这样吗？

---

### (00:35:58) Madhavan Ramanujam

**English:**
Yeah, exactly. I would think of it as... I wouldn't say necessarily user research. It's a bit before that. User research probably gets more into usability and how people would actually use it. This is a one step before conversation where you're trying to understand testing and learning, whether people buy into your idea, do they see the value, is there an ROI, and frankly, what needs are you actually solving in the market. This, people can articulate all day long/ what is their jobs to be done or what is their needs paying point. What product to build is your job in some way as a product person. But when you showcase the product and say, okay, this is the product that I'm building which will actually meet this need, you want to see if people's eyes slide up. And that's also when you need to have the willingness to pay conversation because it's not just about saying but actually meaning what you say. And that can only be bought in if you actually use willingness to pay in the conversation. Otherwise, it's a bit of an empty self fulfilling conversation often, so. And then when you actually do this more and more, like I said, [inaudible] or refining things, then you can bring this into other pieces of the conversation and gets more smarter before you launch the product.

**中文翻译:**
是的，没错。我会把它看作……我不一定会说它是用户研究，它比那还要早一点。用户研究可能更多涉及可用性以及人们如何实际使用它。而这是更前一步的对话，你试图通过测试和学习来了解人们是否认同你的想法，他们是否看到了价值，是否有投资回报率（ROI），坦白说，就是你在市场上解决了什么需求。人们可以滔滔不绝地讲述他们的“待办任务”（Jobs to be done）或痛点。作为产品人员，构建什么产品在某种程度上是你的工作。但当你展示产品并说“这就是我正在构建的、能满足这个需求的产品”时，你想看到人们是否眼前一亮。这也是你需要进行支付意愿对话的时候，因为这不仅仅是说说而已，而是要看他们是否真的当回事。只有在对话中引入支付意愿，才能真正验证这一点。否则，这往往只是一场空洞的、自我实现的对话。当你越来越多地这样做，不断完善，你就可以在发布产品前让对话变得更聪明。

---

### (00:37:09) Lenny

**English:**
Do you have a rule of thumb of how many people you should talk to, at least, to get a pretty good sense of maybe we've gotten some-

**中文翻译:**
你有没有一个经验法则，至少应该和多少人谈谈，才能获得一个比较好的感觉，觉得我们已经得到了一些……

---

### (00:37:16) Madhavan Ramanujam

**English:**
Yeah, I get this question all the time, and I say, please talk to one person. [inaudible] because most companies are not even doing that, in terms of willingness to [inaudible] conversations. But if you're, let's say a B2C company, of course you have scale in terms of reaching customers. You might have hundred thousands and millions of customers, consumers. In those situations, more of a quantitative validation might be easier to run. So if you get even 1,000, 2,000 responses that could be statistically significant and easy to do and pull off. If you're a B2B SaaS company and you're focusing on let's say 20 to 30 accounts leading 80 to 90% of your business, try to talk to as many of those as possible. So at least in the 20 to 30 ballpark. And often in these conversations after a point, you start hearing stuff repeatedly. If 20 people tell you the idea is horrible, it is horrible. You can test it all you want. So when you start hearing these things, then you pivot.

**中文翻译:**
是的，我经常被问到这个问题。我会说：请至少和“一个人”谈谈。因为大多数公司在支付意愿对话方面甚至连一个人都没谈过。但如果你是一家 B2C 公司，你当然有触达客户的规模，你可能有成千上万甚至数百万的消费者。在这种情况下，进行定量验证可能更容易。如果你能得到 1000 到 2000 份回复，那在统计上就具有显著性，而且很容易实现。如果你是一家 B2B SaaS 公司，专注于 20 到 30 个占据你 80% 到 90% 业务的账户，那就尽量多和他们谈谈。所以至少在 20 到 30 个这个范围内。通常在这些对话进行到一定程度后，你会开始听到重复的内容。如果 20 个人都告诉你这个主意很烂，那它就是很烂，你再怎么测试也没用。当你开始听到这些重复反馈时，就是该转型（pivot）的时候了。

---

### (00:38:13) Lenny

**English:**
And then once you have your initial thought on what pricing should be, how often do you suggest folks iterate on their pricing strategy?

**中文翻译:**
一旦你对定价有了初步想法，你建议大家多久迭代一次定价策略？

---

### (00:38:21) Madhavan Ramanujam

**English:**
Yeah. Usually we say at least every six months pause, and think whether you should revisit it. Within 12 to 18 months, probably there is time to revisit, especially given market dynamics in most industry verticals that people are in today. And also, there are some pivot points where it'll make sense to think about this, like you're introducing a new plan or you're introducing some new features. All of those moments in time from a product journey standpoint would necessitate having this conversation.

**中文翻译:**
是的。通常我们建议至少每六个月停下来思考一下是否需要重新审视。在 12 到 18 个月内，通常是重新审视的时机，特别是考虑到当今大多数垂直行业的市场动态。此外，还有一些关键节点也适合思考这个问题，比如你推出了新方案或新功能。从产品旅程的角度来看，所有这些时刻都需要进行这种对话。

---

### (00:38:51) Lenny

**English:**
Got it. Final question on this topic, which we've spent I think half an hour on, which is awesome, because it's probably the most important to start with, but this is going to be a deep episode. What's the first thing that a founder or PM should do to go down the route of willingness to pay, if they were to start something on Monday?

**中文翻译:**
明白了。关于这个话题的最后一个问题（我们已经聊了半小时了，这太棒了，因为这可能是最重要的开端，但这注定是一期深度节目）：如果创始人或产品经理（PM）想在周一开始着手研究支付意愿，他们应该做的第一件事是什么？

---

### (00:39:12) Madhavan Ramanujam

**English:**
First of all, start educating yourself that there is a science on this topic. It's not just an art. Get confidence that people have done this before. Not only just startups, but companies like Borsch, and then read chapter four and do it.

**中文翻译:**
首先，开始教育自己：这个话题是有科学依据的，而不仅仅是艺术。要确信前人已经做过这些，不仅是初创公司，还有像保时捷（Porsche）这样的公司。然后，读一下第四章，并付诸行动。

---

### (00:39:19) Lenny

**English:**
Okay. Topic two, which I know is really a big deal to you and a core part of the way you think about it in addition to willingness to pay, and it's segmentation. Thinking about how to segment your customers and product. So can you just talk about, broadly, why is this so important to think about segmentation when you're thinking about pricing?

**中文翻译:**
好的。第二个话题，我知道这对你来说非常重要，也是你思考方式的核心部分（除了支付意愿之外），那就是“细分”（Segmentation）。思考如何对客户和产品进行细分。你能概括地谈谈，为什么在思考定价时，考虑细分如此重要吗？

---

### (00:39:38) Madhavan Ramanujam

**English:**
Look, segmentation is a topic, again, just product market fit is a well understood term for many of your listeners. When we go and ask companies, do you have a segmentation strategy, roughly about 60% would say, yeah, we have it. And then when we check it, probably 10% of them actually have a meaningful segmentation strategy. What I mean by this is, most people think of segmentation as a demographic or persona exercise or how do I position this product to different personas and things and they get it horribly wrong. Tongue in cheek, I'll give you this example. If you think about a person who's 70 plus years old, lives in a castle, incredibly wealthy in the United Kingdom, you probably think about Charles, but that also fits Ozzy Osbourne. And I would probably measure that both of them have dramatically different tastes, need different things, value things differently, and are willing to pay for things differently. If you just base things on persona, you often get it wrong. Segmentation needs to be based on what customers need, what they value, and what are they willing to pay for, and how do you productize package to different segments. So the key lesson that I want your listeners to take away is, you need to be able to productize to segments. If you're trying to build a product and try to position it to different segments, you already lost the battle, because segmentation comes down to needs and understanding needs and building products based on those needs and willingness to pay. Show that you can treat your customers differently. Because if you build the same product and want to treat everyone similarly and say you have a segmentation strategy, you actually don't have it. Take a simple example. If you think about the water that we drink in a fountain, it's free. In a bottle, it's $2. You put gas in it, it's $2.50. Throw it in a mini bar, it's $5. It's the same water, but it's packaged, productized differently because people have different needs. I'm price conscious, I want it in a fountain, I want it to carry it around. I probably take in the bottle, I like the taste, I take gas in it, or I'm just simply ultimately lazy and I would pay the $5 to get it out of the mini bar and not go down the hotel lobby and get it for free because that's my need. If you don't understand these needs, you'll never be able to productize to those needs. So you'll just build one product and try to position it to the different needs based segments and you won't get it right for anyone. And we work with all kinds of industry verticals. We have not found a single vertical where our customer, where their clients' needs are homogenous. It is heterogeneous whether you want to accept it or not. And if you accept it, then you would start getting into the heart of segmentation and say, where is that heterogeneity? How do the needs differ in the market? How does a willingness to pay differ in the market and what can I productize to different needs and willingness to pay segments, so productizing to segments, as opposed to building one and positioning it to different segments. Usually, when I walk into these companies, they'll say, "We are building a one size fits all," I would quickly correct them and say, "One size fits none." So it's a bit of that. That's why this topic is deep, because people get the definition of segmentation wrong.

**中文翻译:**
看，细分这个话题，就像“产品市场契合”一样，对你的很多听众来说是个耳熟能详的词。当我们去问公司“你们有细分策略吗”，大约 60% 的人会说“有”。但当我们去检查时，可能只有 10% 的公司拥有真正有意义的细分策略。我的意思是，大多数人认为细分只是人口统计学或用户画像（persona）的练习，或者是“我如何针对不同的画像定位这个产品”，结果错得离谱。我开个玩笑举个例子：如果你想到一个 70 多岁、住在城堡里、在英国极其富有的人，你可能会想到查尔斯国王，但这描述也符合奥兹·奥斯本（摇滚明星）。但我敢打赌，他们两人的品味截然不同，需求不同，对价值的看法不同，支付意愿也不同。如果你只根据用户画像来做，你经常会出错。细分需要基于客户的需求、他们看重的价值以及他们的支付意愿，并据此针对不同细分市场进行产品化和包装。所以我希望听众记住的关键教训是：你需要能够“针对细分市场进行产品化”。如果你试图构建一个产品，然后尝试将其定位给不同的细分市场，你已经输了。因为细分归根结底是需求，是理解需求并基于这些需求和支付意愿来构建产品。要展示出你能区别对待客户。因为如果你构建同样的产品，却想以同样的方式对待每个人，还说你有细分策略，那你其实并没有。举个简单的例子：我们在饮水机喝的水是免费的；瓶装水是 2 美元；加了气的苏打水是 2.5 美元；放在迷你吧里的是 5 美元。水是一样的，但包装和产品化方式不同，因为人们有不同的需求。我可能对价格敏感，就在饮水机喝；我想随身携带，就买瓶装；我喜欢口感，就买加气的；或者我纯粹是懒，愿意花 5 美元从迷你吧拿，而不是下楼去大堂免费喝，因为那是我的需求。如果你不理解这些需求，你就永远无法针对这些需求进行产品化。你只会构建一个产品，然后试图把它推向不同的需求细分市场，结果谁也讨好不了。我们与各种行业合作，还没发现任何一个行业的客户需求是同质的。无论你是否接受，需求都是异质的。如果你接受这一点，你就会开始深入细分的核心，问：这种异质性在哪里？市场上的需求有何不同？支付意愿有何不同？我可以针对不同的需求和支付意愿细分市场开发什么产品？也就是“针对细分市场进行产品化”，而不是“构建一个产品并向不同细分市场定位”。通常当我走进这些公司，他们会说“我们正在构建一个通用的方案（one size fits all）”，我会迅速纠正他们：“通用方案其实谁也不适用（one size fits none）。”这就是为什么这个话题很深刻，因为人们搞错了细分的定义。

---

### (00:42:42) Lenny

**English:**
So segments are something that people hear often and I think, like you said, understand, and to your point, they think they've done segmentation. But again, to your point, a lot of times they do it wrong. You have this framework that is really interesting, this one phrase they use, "You can act differently to help you think about whether a segment makes sense and how to think about segmentation." So can you just talk about what's a sign your segmentation is correct versus not, and maybe how to think about the framework?

**中文翻译:**
所以细分是人们经常听到，并且像你说的，自认为理解的概念。他们认为自己已经做了细分，但实际上往往做错了。你有一个非常有趣的框架，其中有一句话：“你能否采取不同的行动（act differently）”，这有助于思考一个细分是否有意义。你能谈谈什么是细分正确与否的标志，以及如何思考这个框架吗？

---

### (00:43:12) Madhavan Ramanujam

**English:**
So the three most important words in what you said is, "You act differently," so you as in your product teams, your sales teams, your marketing teams, your finance teams, act as in, come up with new products, build a business case, come up with a product marketing messages, sales strategies, differently, as in there's no point in doing segmentation and having the same reaction or treatment to everyone. You need to be able to act differently. So what that means is, if I know what you need, what you're willing to pay for and what you value, then my conversation with you will be different than someone else who needs something else and is willing to pay something else. I productize something for Lenny, and I productize something else for the others. And the key here is to understand if there is a significant, let's say, total available market or size of the market, where the needs are similar, and they're willing to pay, as in, let's try to find all the people who would want to drink water in the fountain. Let's find the people who want to bring it in a bottle. Let's find the people who want to have gas, would they pay for it. And then when you understand these segments, then you can say, "Okay, what do I build for these different segments?" And then focus on that segment when you launch the product. Have the marketing message for that segment and target that segment, as opposed to just building one thing and hoping that somehow these four groups will sort themselves out into your product. And that's the key thing.

**中文翻译:**
你刚才说的那句话里最重要的三个词是“采取不同的行动”。“你”指的是你的产品团队、销售团队、营销团队、财务团队；“行动”指的是开发新产品、建立业务案例、制定产品营销信息和销售策略；“不同”指的是，如果做完细分后对每个人的反应或待遇还是一样，那就毫无意义。你需要能够采取不同的行动。这意味着，如果我知道你需要什么、愿意付多少钱以及看重什么，那么我与你的对话将不同于与另一个需求不同、支付意愿也不同的人的对话。我会为 Lenny 开发一种产品，为其他人开发另一种产品。这里的关键是了解是否存在一个足够大的市场规模（TAM），其中人们的需求相似且愿意付费。比如，让我们找出所有想在饮水机喝水的人，找出想买瓶装水的人，找出想要加气水的人。当你理解了这些细分市场，你就可以说：“好，我为这些不同的细分市场构建什么？”然后在发布产品时专注于那个细分市场，针对该市场发布营销信息，而不是只造一个东西，然后寄希望于这四类人能自己对号入座。这就是关键。

---

### (00:44:33) Lenny

**English:**
When should early stage founders think about segmentation? Do you suggest it's right from the beginning, the first product should have multiple segments, or does it come later?

**中文翻译:**
早期创始人应该什么时候考虑细分？你建议是从一开始就做吗？第一个产品就应该有多个细分市场，还是以后再说？

---

### (00:44:40) Madhavan Ramanujam

**English:**
This is also an often asked question in the sense that as a startup, as an early stage founder, often the excuse is, "Hey, we don't have time. We're actually pulling stuff out of the wall. We need to get something out there." It's like, "Time is of the essence, so we need to build a product." And usually they would say, "Let's build just a product, which is every awesome thing that we are working on, and then we come back and revisit whether we want to build other versions, et cetera, and we don't have resources to even build multiple products." Well, that logic makes sense when you don't understand the concept of segmentation. If you truly understand the concept of segmentation, you would say, you know what, as a first conversation, when you're having that willingness to pay conversation based on your idea, you would say, "Who's actually willing to pay for this innovation? What do they need? How many of them are there? Can we productize to this first compared to the others? "Then you'll start prioritizing not only your R&D roadmap, but you're resourcing to say, "Which segment should I start with? And then what segments would I actually add?" And then your value messaging would be tailored to that segment. People will understand the benefits. They will say, "Your product will be launched and people will get it and they would actually go for it." So having done this exercise early will tell you how many segments are there, what is the size of these segments, how to prioritize them, which one to pick first and which product to build first for that segment, and then productize to the other segments later. If you're lazy and sloppy, you'll build a product, you'll slap on a price, you'll throw it in the market and say, "I will attract everyone." You'll attract no one.

**中文翻译:**
这也是一个常被问到的问题。作为初创公司或早期创始人，常见的借口是：“嘿，我们没时间，我们正忙着把东西搞出来，我们需要尽快发布。”就像是“时间紧迫，所以我们需要先造个产品”。通常他们会说：“让我们先造一个产品，把我们正在做的所有酷炫功能都放进去，以后再回来考虑是否要出其他版本，而且我们现在也没资源造多个产品。”嗯，当你还不理解细分的概念时，这种逻辑听起来很合理。但如果你真正理解了细分，你会说：你知道吗，在基于你的想法进行第一次支付意愿对话时，你就会问：“谁真的愿意为这项创新付钱？他们需要什么？这样的人有多少？我们能否先针对这一类人进行产品化？”然后你不仅会开始确定研发路线图的优先级，还会确定资源的优先级，决定“我应该从哪个细分市场开始？然后我再增加哪些细分市场？”接着，你的价值主张将针对该细分市场量身定制。人们会理解其中的益处，他们会说：“你的产品发布了，人们理解它，并且真的会去买。”所以，尽早做这个练习会告诉你：有多少个细分市场，规模多大，如何排序，先选哪一个，先为那个市场造什么产品，以后再为其他市场做产品化。如果你懒惰且草率，你会造一个产品，随便贴个价扔进市场，说“我要吸引所有人”，结果你谁也吸引不了。

---

### (00:46:14) Lenny

**English:**
Amazing. So basically understand the segments right from the beginning. Don't necessarily launch products for every segment.

**中文翻译:**
太棒了。所以基本上是从一开始就理解细分市场，但不一定要为每个细分市场都发布产品。

---

### (00:46:21) Madhavan Ramanujam

**English:**
Exactly. That's totally acceptable because it's not like everyone has resourcing to launch five products, five segments, everything else. Complexity, and plus, you don't probably want to be too complex when you're launching your products, but focus on the right segment, and launch it for that first.

**中文翻译:**
没错。这完全可以接受，因为不是每个人都有资源去发布五个产品、针对五个细分市场等等。这太复杂了，而且你可能也不想在发布产品时搞得太复杂。但是，要专注于正确的细分市场，并先为它发布产品。

---

### (00:46:38) Lenny (Sponsor Break)

**English:**
Today's episode is brought to you by Miro. Creating a product, especially one that your users can't live without is damn hard. But it's made easier by working closely with your colleagues to capture ideas, get feedback, and being able to iterate quickly. That's where Miro comes in. Miro is an online visual whiteboard that's designed specifically for teams like yours. I actually use Miro to come up with a plan for this very ad. With Miro, you can build out your product strategy by brainstorming with sticky notes, comments, live reactions, loading tools, even a timer to keep your team on track. You can also bring your whole distributed team together around wire frames, where anyone can draw their own ideas with the pen tool or put their own images or mockups right into the Miro board. And with one of Miro's ready made templates, you can go from discovery and research to product roadmaps, customer journey flows, to final [inaudible]. Want to see how I use Miro? Head on over to my Miro board at miro.com/lenny to see my most popular podcast episodes, my favorite Miro templates, you can also leave feedback on this podcast episode and more. That's M-I-R-O . com/lenny. Are there any examples? You shared this water example, which I love, that's really clear. by the way, you forgot to mention Liquid Death, which I think is $8 water in a can that just looks really cool.

**中文翻译:**
本期节目由 Miro 赞助。打造一款产品，尤其是让用户离不开的产品，是非常困难的。但如果能与同事紧密合作，捕捉创意、获取反馈并快速迭代，事情就会变得简单。这就是 Miro 的用武之地。Miro 是一个专为像你们这样的团队设计的在线视觉白板。我实际上就是用 Miro 来策划这条广告的。通过 Miro，你可以利用便签、评论、实时反应、投票工具甚至计时器来进行头脑风暴，制定产品策略，确保团队步调一致。你还可以将分布在各地的团队聚集在原型图周围，任何人都可以用画笔工具画出自己的想法，或者将图片和模型直接放入 Miro 板中。借助 Miro 的现成模板，你可以完成从发现和研究到产品路线图、客户旅程图再到最终交付的全过程。想看看我是如何使用 Miro 的吗？请访问我在 miro.com/lenny 的白板，查看我最受欢迎的播客节目、我最喜欢的 Miro 模板，你还可以在那里留下对本期节目的反馈。地址是 M-I-R-O . com/lenny。还有其他例子吗？你分享的那个水的例子我很喜欢，非常清晰。顺便说一下，你忘了提到 Liquid Death，我觉得那是罐装的 8 美元的水，看起来真的很酷。

---

### (00:48:00) Madhavan Ramanujam

**English:**
Yeah, keep getting these tweets from Peter. Yes, I love the product actually. It's water packaged as an $8 product, so it's great. That's a segment of customers that love that and-

**中文翻译:**
是的，我一直收到 Peter 发来的推文。是的，我其实很喜欢那个产品。它是被包装成 8 美元产品的“水”，非常棒。那是喜欢这种风格的一个客户细分市场……

---

### (00:48:13) Lenny

**English:**
Oh, I love that. The VC wants you to include that as an example, as you talk about water.

**中文翻译:**
噢，我喜欢这个。VC 希望你在谈论水的时候把它作为一个例子。

---

### (00:48:17) Madhavan Ramanujam

**English:**
Exactly. Will do from next time. Liquid Death, eight bucks.

**中文翻译:**
没错。下次一定。Liquid Death，8 美元。

---

### (00:48:21) Lenny

**English:**
Yeah. Any other examples as the premise of my question?

**中文翻译:**
是的。回到我刚才问题的初衷，还有其他例子吗？

---

### (00:48:24) Madhavan Ramanujam

**English:**
I would probably start with a few obvious and famous examples so that just remember the point in some way, and then we can drill down further if needed. But if you look at, for instance, Apple. Let's assume the conversation in Apple was something like this, "Hey, we need to just build one product, one iPhone, because we need to maximize our market share and we will throw it out and slap on a price and hope to get the market." They wouldn't be the most profitable company in the planet today. What did they actually do? There is an iPhone for 299, 399, 499, all the way to 1499. They have built products to different segments. I remember walking into the Apple store when iPhone X was launched. I didn't want to part with a thousand bucks. I was checking the phone out ,and I looked at the features. I really didn't want the retina features and all these benefits. And then I saw that there was a phone without that for 799 and I picked the 8S and I walked out. So I belonged to that segment. I was not belonging to the iPhone X, but that's a product that has been productized for different needs, segments. And if you look deeply, Apple has not just priced their iPhones, they have productized to different price points and willingness to pay, and that's where it gets actually fascinating. So I think that's a great example of understanding differentiation and then productized to different needs. And I think that's a good example. Another one that comes to mind, where we worked with, this was in the pre-IPO days, Eventbrite, which is a B2B SaaS company. They used to have one product that was actually-

**中文翻译:**
我可能会先从几个显而易见且著名的例子开始，以便大家记住这个观点，如果需要我们可以再深入探讨。比如苹果公司。假设苹果当年的对话是这样的：“嘿，我们只需要造一个产品，一款 iPhone，因为我们需要最大化市场份额，我们把它扔出去，贴个价，希望能占领市场。”那他们今天就不会是地球上利润最高的公司了。他们实际上做了什么？有 299、399、499 一直到 1499 美元的 iPhone。他们为不同的细分市场构建了产品。我记得 iPhone X 发布时我走进苹果商店，我不想掏 1000 美元。我查看了那款手机，看了看功能，我其实并不想要视网膜屏幕那些功能。然后我看到有一款没有这些功能、售价 799 美元的手机，我选了 8S 然后就走了。所以我属于那个细分市场，我不属于 iPhone X 的市场。但那是一个针对不同需求和细分市场进行产品化的产品。如果你深入观察，苹果不仅仅是为 iPhone 定价，他们是针对不同的价格点和支付意愿进行了产品化，这才是最迷人的地方。所以，我认为这是理解差异化并针对不同需求进行产品化的绝佳例子。另一个我想到的例子是我们合作过的 Eventbrite，这是一家 B2B SaaS 公司，当时他们还没上市。他们以前只有一个产品，实际上是服务于……

---

### (00:49:56) Madhavan Ramanujam (Continued)

**English:**
A SaaS company, they used to have one product that was actually servicing all of their customers. And then we went through an exercise of understanding who are their customer segments and how do we productize to different segment needs. And if you look at what they have today, they have three plans, because there are segments behind this. And if you look at the plans, there are plans, for instance, the entry level plan has something like, you can only launch an event with one ticket type, like a general admission. And then if you take the middle plan, it has unlimited entry type. So you can have a general admission, a VIP admission, whatever, when you're actually having events. It actually makes sense, because if you're, let's say, hosting your local wine club meetup, whatever, event, you probably just need the general admission and that's it. But if you actually are a bit more professional and you needed multiple event types and you're having a event of that nature, then there's another product that actually appeals. But because of doing this, the one that has only one event type, that product is cheaper than the other one. So there's an essential product and there's a professional product and they have enterprise product. So this comes down to truly understanding what customers need, what they value, and what they're willing to pay for, and how can we productize towards that. Maybe another example that is obvious and in front of us, when we use our apps, like Uber is a great example of also segmentation.Because you have different car types. If they just had one car type, then okay, then that's a very different company, very different strategy. There's an Uber Black, Uber X. We used to even have the Uber pool pre pandemic. I don't know if it's back now.

**中文翻译:**
作为一家 SaaS 公司，他们以前只有一个产品服务于所有客户。然后我们进行了一项练习，了解他们的客户细分市场是谁，以及如何针对不同细分市场的需求进行产品化。如果你看他们现在的产品，他们有三个方案，因为背后有细分市场。如果你看这些方案，例如入门级方案规定你只能发布一种门票类型，比如普通票。而如果你选择中间档的方案，它有无限的门票类型。所以当你举办活动时，你可以有普通票、VIP 票等等。这其实很合理，因为如果你只是举办当地的红酒俱乐部聚会，你可能只需要普通票。但如果你更专业一些，需要多种活动类型，那么就有另一个产品吸引你。正因为这样做，只有一种门票类型的产品比另一个便宜。所以有了基础版、专业版和企业版。这归根结底是真正理解客户的需求、价值感和支付意愿，并据此进行产品化。另一个显而易见的例子是 Uber。Uber 也是细分的绝佳例子，因为你有不同的车型。如果他们只有一种车型，那将是一家完全不同的公司，有着完全不同的策略。现在有 Uber Black、Uber X。疫情前我们甚至有 Uber Pool（拼车），我不知道现在恢复了没有。

---

### (00:51:35) Lenny

**English:**
I think it's back.

**中文翻译:**
我想已经恢复了。

---

### (00:51:36) Madhavan Ramanujam

**English:**
It's back? Great. And they also launched this thing called comfort, which is a bit between Black and Uber X in terms of both price and also the types of cars. But it comes with certain features. For instance, you can say quiet preferred on a Comfort or a Black. And that's literally why I take one of these, because I'm probably working on my Uber ride over and I like to just have the quiet and just work on things, and I'm willing to pay for that and I belong in a different segment. But of course if I'm using, let's say Uber for my everyday commute, sometime maybe I do pool. So depending on even my point in time or depending on my situation, I might actually belong to different segments, and understanding this and then productizing towards that becomes key. So the topic that we have been focused with many companies nowadays is not just doing a static view of segmentation, but truly understanding dynamic segmentation and how to offer product and services around the fact that people switch segments. So if I'm ordering on a Friday night on a food delivery platform, maybe I'm thinking pizza. Tuesday afternoon during my office time, maybe I'm thinking of a different type of cuisine. So if I know all of these things, healthy choices versus not, when can I productize what, then you actually start getting a dynamic views of segmentation. And the technology around us actually allows us to take a very dynamic view of segments and that's very fascinating. So the [inaudible] there are multiple steps. First do the segmentation, that's the basic. [inaudible] a static view. Maybe if it's relevant, even a dynamic view of this is the next frontier.

**中文翻译:**
恢复了？太好了。他们还推出了一个叫 Comfort（舒适型）的选项，在价格和车型上介于 Black 和 Uber X 之间。但它带有一些特定功能，比如在 Comfort 或 Black 上你可以选择“偏好安静”。这正是我选择它们的原因，因为我可能在乘车途中工作，我喜欢安静地处理事情，我愿意为此付钱，我属于不同的细分市场。但当然，如果我是日常通勤，有时我可能会选拼车。所以，即使是同一个人，根据时间点或情况的不同，也可能属于不同的细分市场。理解这一点并据此进行产品化变得至关重要。所以，我们现在与许多公司关注的话题不仅是做静态的细分，而是真正理解“动态细分”，以及如何围绕“人们会切换细分市场”这一事实来提供产品和服务。如果我周五晚上在订餐平台上点餐，我可能想吃披萨；周二下午在办公室，我可能想吃另一种菜系。如果我知道所有这些信息（健康选择与否等），知道什么时候该把什么产品化，那么你就开始获得动态的细分视角。我们周围的技术实际上允许我们采取非常动态的细分视角，这非常迷人。所以这有多个步骤：首先做细分，这是基础；然后是静态视角；如果相关的话，动态视角就是下一个前沿。

---

### (00:53:19) Lenny

**English:**
Which you shared just now reminded me of another really interesting framework in your book, around pricing strategy. And you talk a lot about just how important it is, one to just write down your strategy and why you think this is the right strategy. But specifically, you have these concepts of either you want to be maximizing, you want to be penetrating or you want to be skimming. And I thought this would be a good time to chat a little bit about that. Can you just talk about what these three strategies are?

**中文翻译:**
你刚才分享的内容让我想起了你书中另一个非常有趣的关于定价策略的框架。你谈到了写下你的策略以及为什么你认为这是正确策略的重要性。具体来说，你有这些概念：要么你想“最大化”（maximizing），要么你想“渗透”（penetrating），要么你想“撇脂”（skimming）。我觉得现在是聊聊这个的好时机。你能谈谈这三种策略分别是什么吗？

---

### (00:53:42) Madhavan Ramanujam

**English:**
Sure. When we talk about pricing strategies, we hear many buzzwords, and it's irrelevant. So when we take a step back and look at it, there's literally only three types of pricing strategies. And if you know this, then you can follow one of these and [inaudible] to success products. The first one is skimming strategy, which is your Apple iPhone. They launch at a particular price and the next generation is probably at a higher price, but the previous generation actually goes down, so they launch at a higher price and then they start lowering the price. So they're skimming the market. And connotation of these products is also, it's a premium product. Price is a signal of quality, et cetera, et cetera. If you take penetration that's probably made famous by Amazon. And Amazon, they're probably operating at much thinner margins, but they're playing the volume game. Much more harder game to play because you need to have all of your costs in order, supply chain, everything else, and you're fine tuning towards the volume game. Often, I see entrepreneurs who say, "Let's just price load to gain growth." That's a fallacy. If you don't have a business model that actually supports this compared to Amazon, then you probably shouldn't be in a penetration strategy. And even in a company like Amazon and AWS has a very different strategy compared to the e-commerce marketplace. So within even business units, you can actually have different pricing strategies. And the third one is just maximization, which is you're neither on these two extremes but a bit in between, and you're saying, "Okay, what can I maximize in the next couple of years?" In my opinion at least Microsoft will probably belong in that category. And if I look at Apple, Microsoft, Amazon, companies that reached trillion valuations in our lifetime, probably the only three in some way, shape or form, they have dramatically different pricing strategies. The point is not about picking, just picking one, but it's about executing the one that you actually pick. And that's also what we write about in the book, how to pick one and not just pick one, but how to build your products around this executed live and breathe your business model strategy, which leads to your pricing strategy.

**中文翻译:**
当然。当我们谈论定价策略时，会听到很多流行词，但那不重要。当我们退一步看，定价策略其实只有三种。如果你知道这些，你就可以遵循其中之一并走向成功。第一种是“撇脂策略”（Skimming Strategy），比如苹果的 iPhone。他们以特定价格发布，下一代可能价格更高，但前一代价格会下降。所以他们以高价切入，然后逐渐降价，就像撇去奶油一样“撇取”市场。这类产品的内涵通常是高端产品，价格是质量的信号。第二种是“渗透策略”（Penetration），这可能因亚马逊而闻名。亚马逊的利润率可能非常薄，但他们在玩规模游戏。这是一种更难玩的游戏，因为你需要理顺所有成本、供应链和一切，并针对规模进行微调。我经常看到创业者说“让我们定低价来获得增长”，这是一个谬论。如果你没有像亚马逊那样支持这种做法的业务模式，你可能不应该采用渗透策略。即使在亚马逊内部，AWS 的策略也与电子商务平台截然不同。所以即使在业务单元内部，你也可以有不同的定价策略。第三种是“最大化策略”（Maximization），即你既不在两个极端，而是在中间，你在想：“在未来几年我能最大化什么？”在我看来，微软可能属于这一类。如果我看苹果、微软、亚马逊这些在我们有生之年达到万亿估值的公司，它们可能是仅有的三家，但它们的定价策略截然不同。重点不在于随便选一个，而在于执行你选中的那个。这也是我们在书里写的：如何选择一个，不仅是选择，还要如何围绕它构建产品，将其融入你的业务模式策略，从而引导出你的定价策略。

---

### (00:55:44) Lenny

**English:**
Amazing. I just want to say I love how deep we're getting into all these topics. This is amazing.

**中文翻译:**
太棒了。我只想说，我非常喜欢我们对这些话题的深入探讨。这太精彩了。

---

### (00:55:48) Madhavan Ramanujam

**English:**
Cool.

**中文翻译:**
酷。

---

### (00:55:49) Lenny

**English:**
One final question on this topic and then we'll get to the next and the rest will be quicker. We're spending a lot of time on each, which I love. You talk a lot about the importance of packaging and bundling and how that alone can help you win a segment, versus even the price of the segment. Can you talk about how to think about the importance of that?

**中文翻译:**
关于这个话题的最后一个问题，然后我们进入下一个，后面的会快一点。我们在每个话题上都花了很多时间，我很喜欢这样。你谈到了很多关于包装（packaging）和捆绑（bundling）的重要性，以及仅仅通过这些就能帮助你赢得一个细分市场，甚至比价格本身还重要。你能谈谈如何思考其重要性吗？

---

### (00:56:06) Madhavan Ramanujam

**English:**
The way to unlock your segmentation is to think about bundling and packaging, as in you're configuring your product, based on what customers need, what they value and what they're willing to pay for. Either you put a bunch of benefits that people like and call it packaging and put that out, or you're taking multiple products and calling it bundling and putting that out. So it's a question of, hey, that's the way you unlock segments. Your productizing. It's like the iPhone X versus the iPhone A test, different products, different features, different packages, et cetera. The quick framework to think about packaging, bundling, we call it the leaders, fillers and killers, exercise of framework. So if you think about the classic, let's say bundle, like a Big Mac or a Happy Meal, the Big Mac is the leader product, that's in the Happy Meal, and that's what people go for when they go to McDonald's. When you look at french fries and Coke, those are the fillers. You can put a burger along with french fries and coke, call it a happy meal, and most people wouldn't have bought a french fry or Coke, but if you just say for a dollar or two more, you know can actually get this, they would say, "Let's get the happy Meal." So you're actually bundling it in such a way that with marginal increase in price, you're also able to sell multiple products, which they wouldn't have if you didn't have it. The killer is the one where if you put it in the product, it just kills the bundle for everyone. So for instance, if you put coffee along with french fries and a coke and a burger, that's just going to kill the bundle. No one needs a double dose of caffeine when they're having a burger. But there are people like me, Lenny, who love to have coffee with their burgers. So these are great candidates for selling them as add-ons, because if I actually, I would pay for the add-on because I actually want the coffee. So I would take the burgers standalone, and I would take the coffee standalone and that's why it's actually listed separately in the menus. If you bundle it, what happens is it just depreciates the willingness to pay across the entire customer base to the point where no one actually wants it. So you need to find pockets of customers who want it and then maybe only sell it to them. So the rule of thumb that I usually say is, if 10 to 20% of your customers want something and they really want it badly, that's usually an add-on. That's not something that goes into a package unless you have a advanced package just for them, kind of thing. And if more than 50% of people want something, that's a leader product. So if you understand all these leaders, fillers and killers, then you can configure your product in such a way that your productizing to segments and you'll unlock maximum value.

**中文翻译:**
解锁细分市场的方法是思考捆绑和包装，也就是说，根据客户的需求、价值感和支付意愿来配置你的产品。要么你把人们喜欢的一堆益处放在一起，称之为“包装”并发布；要么你把多个产品放在一起，称之为“捆绑”并发布。所以这就是你解锁细分市场的方式——产品化。就像 iPhone X 对比 iPhone 8S，不同的产品、不同的功能、不同的包装等等。思考包装和捆绑的一个快速框架，我们称之为“核心产品 (Leaders)、填充产品 (Fillers) 和杀手产品 (Killers)”框架。如果你想到经典的捆绑包，比如巨无霸或开心乐园餐：巨无霸是开心乐园餐里的“核心产品”，那是人们去麦当劳的主要目的。薯条和可乐是“填充产品”。你可以把汉堡和薯条、可乐放在一起，称之为开心乐园餐。大多数人可能本来不会单独买薯条或可乐，但如果你说只要多花一两美元就能得到这些，他们会说“那我要开心乐园餐”。所以你通过这种捆绑方式，以微小的价格增幅卖出了多个产品，如果没有捆绑你可能卖不掉。而“杀手产品”是指如果你把它放进组合里，它会毁掉整个组合。例如，如果你把咖啡和薯条、可乐、汉堡放在一起，这会毁掉这个组合。没人想在吃汉堡时摄入双倍咖啡因。但像我这样的人，Lenny，喜欢汉堡配咖啡。所以这些是作为“附加组件”（add-ons）销售的绝佳候选，因为如果我真的想要咖啡，我会愿意为附加组件付钱。所以我会单独买汉堡，单独买咖啡，这就是为什么它们在菜单上是分开列出的。如果你强行捆绑，结果就是它会降低整个客户群的支付意愿，以至于没人想要它。所以你需要找到想要它的那一小部分客户，然后可能只卖给他们。我通常说的经验法则是：如果 10% 到 20% 的客户想要某样东西，而且非常想要，那通常是一个附加组件，而不是放入包装里的东西，除非你有一个专门为他们准备的高级包装。如果超过 50% 的人想要某样东西，那就是核心产品。如果你理解了核心产品、填充产品和杀手产品，你就可以配置你的产品，从而针对细分市场进行产品化，并解锁最大价值。

---

### (00:58:36) Lenny

**English:**
Your example reminds me, I just went In-N-Out yesterday, and how I don't think they've changed their model ever. Somehow, it just works. They nailed it.

**中文翻译:**
你的例子让我想起我昨天刚去了 In-N-Out，我觉得他们从来没改过模式。不知为何，它就是有效。他们做得太棒了。

---

### (00:58:45) Madhavan Ramanujam

**English:**
It somehow works. I think In-N-Out, that's a story for another day. I think it works for a different reason.

**中文翻译:**
它确实有效。我觉得 In-N-Out 的故事得改天再说，我认为它成功的原因有所不同。

---

### (00:58:51) Lenny

**English:**
Some people. Yeah. All right. And then the other thought I had while you're talking is, understanding who the leaders are and the fillers and the killers, comes from [inaudible] conversations. I imagine the stuff that people stack rank at the top is most likely going to be your leaders.

**中文翻译:**
好吧。我在听你讲的时候想到的另一个点是：了解谁是核心产品、填充产品和杀手产品，源于那些对话。我猜人们排在最前面的东西最有可能成为你的核心产品。

---

### (00:59:05) Madhavan Ramanujam

**English:**
Yes, exactly. So when you do those most and least questions and you stack rank them, the must haves will pay, or must have table stakes would be the leader products, or leader features or benefits. The ones that are nice to have and might consider paying or nice to have, those features are probably the fillers, and that don't need are the killers.

**中文翻译:**
是的，没错。当你做那些“最重要与最不重要”的问题并进行排序时，“必须拥有且愿意付费”或“必须拥有的基本门槛”就是核心产品，或者核心功能/益处。那些“有了更好且可能考虑付费”或“有了更好”的功能大概就是填充产品。而那些“不需要”的就是杀手产品。

---

### (00:59:27) Lenny

**English:**
Awesome.

**中文翻译:**
太棒了。

---

### (00:59:28) Madhavan Ramanujam

**English:**
Don't need I will not pay.

**中文翻译:**
不需要，我也不会付钱。

---

### (00:59:29) Lenny

**English:**
Got it. Interesting. When I saw you right about killers, I always thought it was things that it needs to have that would kill the deal if they don't, but that makes a lot more sense that it kills the deal if it includes it. Interesting.

**中文翻译:**
明白了。很有趣。当我看到你写“杀手产品”时，我一直以为是那些“必须有，否则会毁掉交易”的东西，但你说的“如果包含了它反而会毁掉交易”更有道理。很有趣。

---

### (00:59:38) Madhavan Ramanujam

**English:**
Includes it, exactly. Maybe we should change the language in the next sequence, monetizing innovation, but.

**中文翻译:**
包含了它，没错。也许我们在下一部《货币化创新》里应该改改措辞，但是……

---

### (00:59:44) Lenny

**English:**
No, it's working, don't change anything.

**中文翻译:**
不，它现在很有效，别改。

---

### (00:59:45) Madhavan Ramanujam

**English:**
All right, good.

**中文翻译:**
好，没问题。

---

### (00:59:47) Lenny

**English:**
All right. Third topic, around your pricing model. This is something that you talk a lot about that people thinks too much about how much to charge and not enough about how to actually charge the pricing model. So could you just talk about maybe what that is and why people maybe don't think about it as much as they should?

**中文翻译:**
好。第三个话题，关于你的定价模式。这是你经常谈到的：人们过多地考虑“收多少钱”，而对“如何收费”（即定价模式）考虑不足。你能谈谈那是什么，以及为什么人们没有给予足够的重视吗？

---

### (01:00:04) Madhavan Ramanujam

**English:**
We usually say how you charge is way more important than how much you charge. Take a quick example and then bring the point home and then we can talk about why this is actually essential. So taking a non SaaS or software example, if you think about Michelin, which is a tire company, probably one of the most price sensitive, let's say, markets because, think about it, you actually go into a tire store, you see all of these things look similar, but they're somehow priced differently. How are you supposed to make a decision? It's very hard when you need to understand what you're paying for. And they came up with this new tire, which was supposed to last 20% longer, was a true innovation in the industry, and these are tires that were used for moving trucks from point A to point B. And when they thought about it, they said, okay, if we go and ask for a 20% premium, there's no chance they would get it, because it's a price sensitive market. If they don't ask it, the tires are going to overrun and they're going to cannibalize 20% of their business. So what they actually did was they changed their pricing model or monetization model and they said, "Okay, we are going to charge based on the number of miles that a person would drive." The truckers actually love this model, not just because it was pay as you go and they could pay when they actually use the tires and how and everything else. That was the obvious reason. But then now they could also invoice their end customers and say, "Okay, my journey was 798 kilometers or miles, and that's the amount of tire costs," and they could pass it through because it became a variable cost and people love this kind of model. And of course, the tires lasted long. Michelin [inaudible] that more, but more people jumped into the Michelin bandwagon, because now they could actually buy a tire that's on a pay as you go basis. Now, if a tire could be actually with... And the age old model for tires is on a per tire basis. If a tire could actually be sold on a pay as you go consumption model, then obviously most products can actually explore this route, especially in a software setting. But the key lesson here is how you charge was the most important question. It was not the how much. The how much came about because of the how you charge.

**中文翻译:**
我们常说，“如何收费”比“收多少钱”重要得多。举个简单的例子来说明这一点，然后我们再讨论为什么这至关重要。举一个非 SaaS 或软件的例子：米其林（Michelin）轮胎公司。轮胎市场可能是价格最敏感的市场之一，因为你想想，你走进一家轮胎店，看到所有的轮胎看起来都差不多，但价格却各不相同。你该如何做决定？当你需要理解你到底在为什么付钱时，这非常困难。米其林发明了一种新轮胎，寿命延长了 20%，这在行业内是真正的创新。这些轮胎用于长途货运卡车。当他们考虑定价时，他们意识到：如果要求 20% 的溢价，根本没戏，因为市场太敏感了。但如果不收溢价，轮胎寿命长了，就会蚕食掉他们 20% 的业务。所以他们做的是改变了定价模式或变现模式，他们说：“好吧，我们将根据行驶里程收费。”卡车司机非常喜欢这个模式，不仅因为它是“按需付费”（pay as you go），他们可以在实际使用轮胎时才付钱，还因为现在他们可以向最终客户开发票说：“我的旅程是 798 公里，这就是轮胎成本。”他们可以将成本转嫁出去，因为它变成了变动成本。人们喜欢这种模式。当然，轮胎寿命确实长，米其林赚得更多，但更多的人加入了米其林的阵营，因为现在他们可以按需购买轮胎。如果轮胎这种古老的、按个卖的产品都能按里程消费模式销售，那么显然大多数产品（尤其是软件）都可以探索这条路。这里的核心教训是：“如何收费”是最重要的问题，而不是“收多少钱”。“收多少钱”是随“如何收费”而产生的。

---

### (01:02:09) Madhavan Ramanujam (Continued)

**English:**
Another SaaS example that is probably top of mind for me is B2B SaaS's segment. This was before they went to Twilio. They used to price based on APIs. So the number of APIs that you actually have with Segment, that used to dictate which plan you would be and how much you would pay for it. But increasingly, they were also shifting gears towards selling to different personas within companies. And what is an API is a debate. Probably a marketing person does not necessarily understand exactly what an API is and the how you charge question became very critical. And what they actually did was, we worked with them and we identified their monthly tracked users what was a much better metric into how customers perceive value, and that was the more fairer metric for customers. If you're tracking more users in Segment, you're probably willing to pay more compared if you're tracking less. So the packaging was changed to a monthly track user instead of APIs. This is literally exactly the same Michelin per mile models, on a B2B SaaS was number of monthly tracked users. So that was a different example. So the how you charge question is super important, way more important than how much. If you don't focus on it and just rush to one or the other, often you're sub optimizing like crazy.

**中文翻译:**
另一个我脑海中浮现的 SaaS 例子是 Segment（在被 Twilio 收购之前）。他们以前根据 API 数量定价。也就是说，你在 Segment 拥有的 API 数量决定了你属于哪个方案以及付多少钱。但后来，他们开始转向向公司内的不同角色销售。关于“什么是 API”存在争议，营销人员可能并不完全理解 API 是什么，于是“如何收费”的问题变得非常关键。我们与他们合作，确定了“月追踪用户数”（MTU）是一个更好的衡量客户感知价值的指标，对客户来说也更公平。如果你在 Segment 追踪的用户更多，你可能愿意付更多钱。所以包装从 API 变成了月追踪用户数。这本质上和米其林的“按里程计费”是一样的，在 B2B SaaS 中就是“按月追踪用户数计费”。所以“如何收费”的问题超级重要，比“收多少钱”重要得多。如果你不关注这一点，只是草率决定，往往会造成严重的次优选择。

---

### (01:03:30) Lenny

**English:**
It's interesting that both your examples are usage based models winning, and it feels like in general, the usage base is where people are trying to go more and more, or maybe not. So maybe two questions. Do you feel like that's the future of SaaS pricing generally? And roughly, do you feel like that should be a default way of approaching when you're building, say, a B2B SaaS company, or is it still seat based?

**中文翻译:**
很有趣，你的两个例子都是“基于用量”（usage-based）模式的获胜。感觉总的来说，基于用量是人们越来越趋向的方向，或者也许不是？所以我有两个问题：你觉得这通常是 SaaS 定价的未来吗？大致来说，你觉得当你构建一家 B2B SaaS 公司时，这应该成为默认方式吗？还是说依然应该是“基于席位”（seat-based）？

---

### (01:03:52) Madhavan Ramanujam

**English:**
I would say it this way. It's most B2B SaaS companies follow what is actually in vogue at that present point in time. If subscription is in vogue, then they say, "Oh, subscription is the best strategy." If usage is made famous by Snowflake and others, they would say usage. So I think usage is obviously, let's say in vogue right now. I think it comes down to really understanding, based on your business situation, does subscription make sense or should you be usage or pay as you go if you're a SaaS company. There are different markers which actually identify this. If customers demand, let's say predictable bills, or usage is very similar month over month as in if you're subscribing for tide pods for instance, it's not like you're going to wash more clothes one month versus the other. The usage is the same month over month, or when the usage is highly variable, which is changing quite a lot between month over month, then if you price based on pay as you go, then your bills are also going to be dramatically different month one versus month two versus month three so you're going to have a very tough conversation with your customers. In all of these situation, a subscription actually makes a lot more sense. Or it could also be, usage is intermittent but the value delivered is ongoing. LifeLock is a great example. It's a product that you probably have to protect your identity theft production. The value is ongoing. The usage of the product is only episodic when your identity theft gets compromised. If they say, "Okay, I'm going to price base on usage," that would be dramatically wrong pricing model. So in those cases, subscription makes sense, or simplifying the pricing conversation is to your advantage. Let's say the Spotify was a good example. If everyone wants to listen, everyone needs to listen on a per song basis, but having a subscription actually made sense. It simplified the pricing conversation. Same as Netflix, all of those situations. So don't just rush to something like usage just because understanding that is key. Usage makes sense when people want low commit or less friction. So making it easier to buy an AWS thing. You onboard people and then you grow the product and I think those situations make sense, or when customers would demand transparency and fairness. Please note that don't mix transparency and fairness with being predictable. Those are very different things. Transparency and fairness just means that you charge for the product. For instance, if you don't use a subscription for a few months, is it fair that you're being charged for those months? That's fairness. That's nothing to do with being predictable. But if they're demanding fairness and transparency, often a usage based pricing model could make sense. Or alternatively, usage is intermittent and episodic, and the value delivered is also episodic and not ongoing, like you for instance, book the movie theater ticket or you book the flight. It's also intermittent usage, intermittent value, so the pay as you go makes sense. Or maybe there's even some underlying cost that scales with usage, like an AWS pay you go can make sense or even probably lastly, if there's some... Most important thing for pays you go, Lenny, is you need to have clear metrics that you can actually track and identify and attribute value and your customers would agree to that value generation, then pay as you go would make sense. If you can't track what you are charging on, often it's a really bad idea. And then, of course you can also be more hybrid sometimes and that's also a winning model. For instance, if you take HubSpot, it's a hybrid model between a pay as you go and a subscription, and it actually works well for them because there's a certain component on a fixed monthly basis. And then if you exceed those quotas and limits, then you actually get into a pay as you go model. So I would urge the readers not to rush into one versus the other based on what is in style at a given point in time, but give it a deep thought and say, what is your business, how are your customers, how are they situated? What are you servicing? And what makes sense between the two models?

**中文翻译:**
我会这样看：大多数 B2B SaaS 公司都会追随当时流行的趋势。如果订阅制流行，他们就说“订阅是最好的策略”；如果 Snowflake 等公司让用量计费出名了，他们就说“用量计费”。所以我觉得用量计费现在显然很流行。我认为归根结底要理解：基于你的业务情况，订阅制是否有意义，或者你是否应该采用用量计费或按需付费。有一些不同的标志可以识别这一点。如果客户要求账单可预测，或者每月的用量非常相似（比如你订阅洗衣液，你不会这个月洗很多衣服下个月就不洗），那么每月的用量是稳定的。或者当用量波动极大，月与月之间变化很大时，如果你按需收费，那么第一个月、第二个月、第三个月的账单会天差地别，你和客户的沟通会非常艰难。在这些情况下，订阅制其实更有意义。或者，用量是间歇性的，但提供的价值是持续的。LifeLock 是个好例子，它保护你的身份不被盗用。价值是持续的，但只有当你的身份真的被盗用时，你才会用到这个产品。如果他们说“我们要按用量收费”，那将是极其错误的定价模式。所以在这些情况下，订阅制更有意义。或者，简化定价对话对你有利时，比如 Spotify。如果每个人都要按首付费，那太麻烦了，订阅制简化了对话。Netflix 也是如此。所以不要仅仅因为流行就冲向用量计费。用量计费适用于人们希望低承诺或低摩擦的情况，比如让购买 AWS 变得容易，先让人们上手，然后随着产品使用而增长。或者当客户要求透明和公平。请注意，不要把透明和公平与可预测性混为一谈。透明和公平意味着你为产品付费。例如，如果你几个月没用，却还要付订阅费，这公平吗？这是公平问题，与可预测性无关。如果他们要求公平和透明，用量计费通常更有意义。或者，用量是间歇性的，价值也是间歇性的，比如订电影票或订机票，按需付费就很有意义。或者，如果底层成本随用量扩展（如 AWS），按需付费也合理。最后，最重要的一点是：你需要有清晰的指标，可以追踪、识别并归因价值，且客户认同这种价值产生，那么按需付费才可行。如果你无法追踪你收费的依据，那通常是个坏主意。当然，有时也可以采用混合模式，这也是一种获胜模式。比如 HubSpot，它是按需付费和订阅制的混合体，对他们很有效，因为有固定的月费部分，如果超过配额，就进入按需付费模式。所以我敦促读者不要根据当时的流行趋势盲目选择，而要深入思考：你的业务是什么？你的客户是谁？他们的处境如何？你提供什么服务？这两种模式中哪一种更有意义？

---

### (01:07:41) Lenny

**English:**
Awesome. On the point of being able to even track usage, I've seen five startup decks of startups that help companies with this, because it's so complicated to know what to charge. What to charge on usage based models, where they basically plug into your systems to help you figure out how much every company owes you. Maybe a couple more questions on this topic. One is just, what's a simple way of thinking about the options? Say, a B2B SaaS company, there's seat based pricing, there's flat based annual contract pricing, there's usage based, you can lop on, freemium to make a free version of it. Is that the four? What's a way to think about your options

**中文翻译:**
太棒了。关于追踪用量这一点，我见过五个初创公司的融资计划书，都是专门帮助公司解决这个问题的，因为弄清楚该收多少钱太复杂了。在用量计费模式下，他们接入你的系统，帮你算出每家公司欠你多少钱。关于这个话题再问两个问题。第一，有没有一种简单的方法来思考这些选项？比如一家 B2B SaaS 公司，有基于席位的定价、固定年费合同定价、基于用量的定价，还可以加上免费增值（freemium）模式。就是这四种吗？该如何思考这些选项？

---

### (01:08:18) Madhavan Ramanujam

**English:**
For B2B SaaS, I think those are probably the options. You're either subscription, pay as you go, freemium, these things. And of course, the price metric that you actually pick, what measure are you charging on, and then how do you structure, the price structure that you pick is important. Because for instance, are you flat for a certain amount of time and then it becomes variable, that's a structure. Or for instance, can you be two dimensional in your structure on two metrics, so the more people actually use your product and take actions that benefit you, the better price you get. This is something we call as a value matrix. For instance, in B2B SaaS companies that actually want to achieve wall to wall adoption. In many companies, it's still a pipe dream. It's just, yeah, you can talk product lead growth, but if your pricing model, it actually incentivizes product-led growth, that's a whole different conversation. So what we would do is, for instance, on one axis, you have seats, and on the other axis could be the number of departments that the product is being used at, departments is HR, legal, et cetera. And then the more users and the more departments, you get a better per user price. So you automatically build an incentive to actually say, if you want better price, sure, you drive the right behaviors. [inaudible] get more people on the product and put it in the hands of more departments, so people can self-govern their pricing as opposed to just, you come up with a price and you're just negotiating. So when you think about pricing models, you have to think about first picking pay as you go subscription premium, then thinking about the metric, and then thinking about the price structure.

**中文翻译:**
对于 B2B SaaS，这些大概就是主要的选项：订阅制、按需付费、免费增值。当然，你选择的“价格指标”（你根据什么来收费）以及你选择的“价格结构”也很重要。例如，你是先收固定费用一段时间然后变动收费吗？这是一种结构。或者，你是否可以在结构中采用双维度指标？比如，人们越是使用你的产品并采取对你有利的行动，他们获得的价格就越好。这就是我们所谓的“价值矩阵”。例如，在希望实现全公司普及（wall to wall adoption）的 B2B SaaS 公司中，这在很多公司依然是白日梦。你可以大谈“产品驱动增长”（PLG），但如果你的定价模式不激励 PLG，那就是另一回事了。所以我们会这样做：例如，一个轴是席位，另一个轴是产品被使用的部门数量（如 HR、法务等）。用户越多、部门越多，你获得的单用户价格就越优惠。这样你就自动建立了一个激励机制：如果你想要更好的价格，没问题，去推动正确的行为——让更多人使用产品，让更多部门接入。这样人们就可以“自我管理”他们的定价，而不是你定一个价然后双方在那谈判。所以当你思考定价模式时，首先要选择按需付费、订阅或免费增值，然后考虑指标，最后考虑价格结构。

---

### (01:09:51) Lenny

**English:**
Awesome. And maybe one more example, say marketplaces. Basically, if you're taking a fee in almost every case, and it's a question of how much you take and then there's maybe a subscription piece on top of it, is that roughly right?

**中文翻译:**
太棒了。再举一个例子，比如平台（marketplaces）。基本上在几乎所有情况下你都会收取佣金，问题在于收多少，然后可能在上面加一个订阅费，大致是这样吗？

---

### (01:10:04) Madhavan Ramanujam

**English:**
Yeah, absolutely. So you could take a rake on the transaction and there's probably a platform fee or a subscription fee. So that comes down to, again, a hybrid of a structure. So there is a portion that is predictable and then there's a portion that is the usage base. It's not a reg based model, but it's similar to the HubSpot modeling principle.

**中文翻译:**
是的，完全正确。你可以从交易中抽取佣金（rake），可能还有平台费或订阅费。这又回到了混合结构：一部分是可预测的，另一部分是基于用量的。这类似于 HubSpot 的建模原则。

---

### (01:10:22) Lenny

**English:**
Okay, and one last question on this topic. Say you want to test different models, say you're, say seat based and you want to try usage base, or you're usage base, you want to go seat. Is that possible? If so, how do you do that?

**中文翻译:**
好，关于这个话题的最后一个问题。假设你想测试不同的模式，比如你现在是基于席位的，想尝试基于用量的；或者反过来。这可行吗？如果可行，该怎么做？

---

### (01:10:32) Madhavan Ramanujam

**English:**
It's definitely possible. There are ways to test this. It's a science. This is also what we do with many of our clients for a living, but maybe the easy Monday morning thing that I can actually ask your listeners to do is what we call as a break even exercises. So let's assume that for instance, let's take a marketplace. Let's say you're selling a dollar hundred item, as in your customer is selling it. If you ask them, what should the pricing model be, 3% transaction fee on a hundred dollar item, or one and a half percent transaction and dollar 50 cents, or 3 dollars, or are you indifferent? This is a basic question because if you do the math, all of those numbers are the same. So an economic human being rational, everything that business school taught us would say, okay, people will pick the indifferent option. I've done this thousands of times. I've never seen the indifferent actually win. It's always people will pick one or the other. So then you actually start understanding what model might make sense. Same thing with B2B SaaS companies. You would say, let's say you have a hundred seats and I would charge you, let's say, a thousand dollars and 10 dollars per seat, or I would charge you 2,000 dollars flat or I would charge you 500 dollars, and the rest in the seat based amount that equals 1500. It's all the same. People would say, "I like the lower platform P and the variable," or they would say, "I like the fixed," so the indifferent never wins. That's the easy way to test pricing models, what makes sense.

**中文翻译:**
这绝对是可能的。有很多方法可以测试，这是一门科学。这也是我们为客户提供咨询的主要内容。但也许你的听众在周一早上就能做的简单事情是所谓的“盈亏平衡练习”。假设一个平台，你的客户在卖一件 100 美元的商品。如果你问他们定价模式应该是：100 美元商品的 3% 交易费，还是 1.5% 的交易费加 1.5 美元固定费，还是直接收 3 美元，或者你觉得无所谓（indifferent）？这是一个基础问题，因为如果你算一下，这些数字其实是一样的。按照商学院教我们的理性经济人假设，人们应该选“无所谓”。但我做过几千次这种测试，从未见过“无所谓”胜出。人们总是会选其中一个。这样你就能开始理解哪种模式更有意义。B2B SaaS 公司也是一样：假设有 100 个席位，我是收 1000 美元固定费加每个席位 10 美元，还是直接收 2000 美元，还是收 500 美元加剩下的席位费凑够 1500 美元？虽然结果一样，但人们会说“我喜欢低平台费加变动费用”或者“我喜欢固定费用”。“无所谓”永远不会赢。这是测试定价模式哪种更合理的简单方法。

---

### (01:12:05) Lenny

**English:**
Awesome. That brings us to our fourth topic, and I think this is something that everyone listening is going to be like, "Oh no, I got this, I'm doing this. Great, I don't need to learn about this." But your point is that it's almost always wrong, which is focusing on benefits versus features when you're talking about your product. So maybe as a first question, just what's a sign that you're probably focusing too much on the features of your product when you're pitching it versus the benefits, which is, to your point, much more powerful.

**中文翻译:**
太棒了。这引出了我们的第四个话题。我想每个听众听到这个都会想：“噢，这个我懂，我已经在做了，我不需要学这个。”但你的观点是，大家几乎总是做错，那就是在谈论产品时过于关注“功能”（features）而非“益处”（benefits）。所以第一个问题是：当你推销产品时，有什么迹象表明你可能过于关注功能，而忽视了更有力量的益处？

---

### (01:12:32) Madhavan Ramanujam

**English:**
I think I see some tell tale markers or pattern recognition as to when people are talking more features as opposed to benefits. First of all, just to set the nomenclature, what you build as a product person is features. What people actually get out of it is the benefits, as what do the features actually do? And that's the benefit that a customer gets, and you need to pitch benefits. If you pitch features, you're not talking value. And if you're not talking value, no one is going to get it. So if you are super excited about the product and passionate about every single thing that the product is doing, most likely you're talking features and not benefits, because you're showcasing how cool your product is and how the different bells and whistles actually work, as opposed to focusing on what is the actual benefit for the customer. There are probably also other signs, for instance, if you don't see market fraction for what you actually build, either what you built is off base, but the good outcome of this could be that people actually don't understand what they're getting. And then actually then changing the speak to being more benefits is key. To take an example, for instance, SmugMug, which is a ridiculously awesome company, they used to actually publish their pricing plans, which was, you had to scroll literally three or four pages and then you would see the price. It's all the features. Everything else that the company did, they changed it to benefits based communication. So a very simple thing. For instance, the ability to sell photos online is a benefit. There are probably 15 features that is behind that [inaudible] actually enables that stuff. But then focusing on the benefits, they had a double digit improvement in revenue and no changes in products. We show the before and after also in monetizing innovation, if someone is interested, and it's what it was was what they actually did. So if you don't see enough traction, then that could be a marker, coming back to your question, or it could just be that if you're too passionate about your products, then your chances are, as a product person, you're talking features.

**中文翻译:**
我想我能看到一些明显的迹象或模式。首先，明确一下术语：作为产品人员，你构建的是“功能”；而人们从中得到的是“益处”，即这些功能到底能做什么？这就是客户获得的益处，你需要推销的是益处。如果你推销功能，你谈论的就不是价值；如果你不谈价值，没人会买账。所以，如果你对产品超级兴奋，对产品的每一个细节都充满激情，你很可能在谈论功能而非益处，因为你在展示你的产品有多酷，各种花哨的功能是如何运作的，而不是专注于客户实际得到了什么好处。可能还有其他迹象，比如，如果你发现你构建的东西没有市场吸引力，要么是你造错了东西，要么（较好的情况）是人们根本不理解他们能得到什么。这时，将话术转变为以益处为中心就至关重要。举个例子，SmugMug 是一家非常棒的公司。他们以前公布的定价方案需要你向下滚动三四页才能看到价格，全是功能介绍。后来他们改成了基于益处的沟通。举个简单的例子：“在线销售照片的能力”就是一个益处。背后可能有 15 个功能在支持这一点，但通过专注于益处，他们的收入实现了两位数的增长，而产品本身没有任何改变。我们在《货币化创新》中展示了前后的对比，感兴趣的人可以去看看。所以，如果你没看到足够的吸引力，这可能是一个信号；或者仅仅是因为你对产品太有激情了，作为产品人，你很可能在谈论功能。

---

### (01:14:30) Lenny

**English:**
Is there any other examples of companies that you think do this super well, to make it even more concrete?

**中文翻译:**
还有其他你认为做得特别好的公司例子吗？让这个概念更具体一点。

---

### (01:14:34) Madhavan Ramanujam

**English:**
To take a, let's say a non SaaS example, my favorite, I'll come back to Porsche again, because their value communication is, to me, legendary. When they launched Taycan, which is their electric car, their value communication was something like this, I'm trying to remember it, but it was something like, "Taycan is not your most affordable electric vehicle, but that was never Porsche's goal. Porsche's goal was to actually build a car that was first and foremost a Porsche." That value save statement, what they actually built, totally resonates with those, their audience. Taking a maybe SaaS example, Shopify is one of my favorites in terms of looking at the plans in terms of their benefit, like, what do they actually put out? All of the plans emphasize benefits and less features. Like for instance, the number of locations that you can track inventory is a benefit because if you actually have a more complicated supply chain, it's different from not, so there are plans which actually have different number of inventory locations, which is a benefit there. I mean, if I can track more or not, but behind this, that could be many features that actually enable this. So if you look at the plans that Shopify has, I think that's a great example. And also they have a lot of good value communication in there. I remember something like the tagline for Shopify Plus was, "Fair pricing, unfair advantage," and just things that actually make bloody sense, then you see it, what you're actually getting. So I think that's a great example that listeners can go into.

**中文翻译:**
举一个非 SaaS 的例子，我最喜欢的还是保时捷，因为他们的价值沟通对我来说是传奇级的。当他们推出电动车 Taycan 时，他们的价值主张大概是这样的（我试着回忆一下）：“Taycan 并不是最实惠的电动车，但这从来不是保时捷的目标。保时捷的目标是打造一辆首先必须是‘保时捷’的车。”这个价值陈述与他们的受众产生了强烈的共鸣。再举一个 SaaS 的例子，Shopify 是我最喜欢的例子之一，看他们的方案是如何体现益处的。所有的方案都强调益处而非功能。例如，“可以追踪库存的地点数量”就是一个益处，因为如果你有复杂的供应链，这很重要。虽然背后有很多功能支持，但他们呈现的是益处。如果你看 Shopify 的方案，我认为那是极佳的例子。而且他们有很多优秀的价值沟通，我记得 Shopify Plus 的口号是“公平的定价，不公平的优势”，这些话非常有道理，让你一眼就能看出你得到了什么。我觉得听众可以去研究一下这个例子。

---

### (01:16:02) Lenny

**English:**
So maybe as a takeaway, folks should probably look at their website, browse through their pages and just look, or am I pitching features, or am I pitching benefits to the reader?

**中文翻译:**
所以作为一个收获，大家或许应该检查一下自己的网站，浏览一下页面，看看自己是在向读者推销功能，还是在推销益处？

---

### (01:16:11) Madhavan Ramanujam

**English:**
Correct, exactly.

**中文翻译:**
没错，正是如此。

---

### (01:16:13) Lenny

**English:**
That brings us to our very final topic, which is behavioral pricing. You have all chapter on this concept of behavioral pricing, and it's super interesting. And it's interesting because you don't have to rethink your price, you could just sell at a higher rate by just thinking through this lens of behavioral pricing. So just to set context, what is behavioral pricing, and why is it important?

**中文翻译:**
这引出了我们的最后一个话题：行为定价（Behavioral Pricing）。你在书里专门用一章讲了这个概念，非常有趣。有趣之处在于，你不需要重新考虑价格，只需通过行为定价的视角，就能以更高的价格售出。为了设定背景，什么是行为定价，为什么它很重要？

---

### (01:16:34) Madhavan Ramanujam

**English:**
Behavioral pricing basically is tapping into the irrational modes of our decision making and not just rational. I think that when I talked about the break even exercise, if you take a very rational view, indifferent would always win. But like I said it, I have never seen it. So there's always an irrational side of our brain that actually makes decisions, and understanding this as a product person would lend yourself to building products, and also positioning or framing the product conversation in such a way that appeals to both sides of the brain. The Predictably Irrational was a great book from Dan Ariely, made the concept very famous. We build on top of that where we actually talk about product and pricing strategies that actually you need to take care of when you think about the irrational side, that's what we call as behavioral pricing. To take a concrete example, and maybe I remember walking into a company and they had three products, and I remember asking the CEO, "Why do you have three products?" And he said, "I learned that good, better, best is a great strategy in business school." So I'm like, "Okay, that sounds great." But when you actually look at what was going on, they were giving the farm away on their entry level product. So they had three products, 49, 79, and 149, that was the price points. And what they actually were doing is they gave a lot of features for the 49. So they were giving the farm away, so 60 to 70% of people were taking the $49 product. Not many are actually opting to the others. What they did was actually super interesting, they just reframed the argument and they found out that between 79 to 99, the pricing was inelastic and there's a threshold at 99, not at 79. It is the same exercise that I talked about in the acceptable and expensive price, et cetera. So they moved the price from 79 to 99, and they moved the price of the 149 to like 199 because of the same kind of reasoning. And then what they actually did is they built another product at 299, which was simply a decoy to make the $99 product look attractive. So if I put a $99 product that looks awesome next to a $299 product, it looks even more attractive. I mean, God bless the 2% that even take the $299 product. But what you actually see is the mix shifted, more people took the $99 product because the pricing made sense, it was respecting the psychological thresholds, and next to a decoy it actually made more sense to pick that product, right? So it's just reframing the conversation. It was a 30+ percent increase in MRR and ARPU right after they actually did this change. No changes in products, no changes in features, just in terms of how they reframe the conversation. I mean, these kind of things are around us, and we need to understand these. For instance, if you go to a movie theater, you'll see a small popcorn for $7, an extra large popcorn with butter on it. Huge one is $8. Most people will say, "For $1, I'm getting this extra large one, let me buy it." But that $7 popcorn is a decoy. I mean, if that was not there, most people would be scratching their heads saying, "Why am I paying $8 for popcorn in the first place?" Right? So this kind of behavioral framing and nudging becomes important, it's not about deceiving your customers, et cetera, but it's just about framing the products in such a way that it also appeals to the irrational side of the brain as much as the rational side. The example that I talked about in the SaaS product on the three products, and compromising to the 99, rather than going for the early product, is simply product discipline. Don't give too much away in your entry level product. Don't give the farm away your entry level product, at least reserve something for the $99 product. So if you build the packaging correctly, you can emphasize a compromise effect, and this is a well known behavioral theory where people avoid the extremes. If you are quality conscious, you'll go to the right. If your budget conscious, you'll go to the left, but most people will compromise in between. If you actually see your packaging mix is like this and is not the normal distribution, as in most people actually prefer the entry level product, you're giving the farm away, maybe you should think about how to change your features and benefits so that you can actually steer more outcomes towards a middle package compared to the entry level one, and also then charge based on the value that you're actually bringing to the table. So we have talked about many behavioral pricing strategies in the book, dedicated an entire chapter to this.

**中文翻译:**
行为定价基本上是利用我们决策中的非理性模式，而不仅仅是理性模式。当我谈到盈亏平衡练习时，如果从纯理性角度看，“无所谓”应该总是胜出。但正如我所说，我从未见过这种情况。我们的大脑总有一个非理性的一面在做决定。作为产品人员，理解这一点可以帮助你构建产品，并以一种同时吸引大脑两面的方式来定位或设定产品对话。丹·艾瑞里的《怪诞行为学》（Predictably Irrational）是一本伟大的书，让这个概念变得非常有名。我们在此基础上，探讨了在考虑非理性一面时需要注意的产品和定价策略，这就是我们所谓的行为定价。举个具体的例子：我记得走进一家公司，他们有三个产品。我问 CEO：“为什么你有三个产品？”他说：“我在商学院学到‘好、更好、最好’（good, better, best）是一个伟大的策略。”我说：“听起来不错。”但当你观察实际情况时，发现他们在入门级产品上“亏本大甩卖”（giving the farm away）。他们有三个产品，价格点分别是 49、79 和 149 美元。他们在 49 美元的档位放了太多功能，导致 60% 到 70% 的人都选了 49 美元的产品，没多少人选其他的。他们后来做的调整非常有趣：他们重新设定了论点，发现 79 到 99 美元之间的定价是缺乏弹性的，心理阈值在 99 而不是 79。这就是我之前提到的“可接受价格”和“昂贵价格”的练习。于是他们把 79 美元的价格提到 99 美元，把 149 美元的价格提到 199 美元。然后，他们又造了一个 299 美元的产品，纯粹作为一个“诱饵”（decoy），让 99 美元的产品看起来更诱人。如果你把一个很棒的 99 美元产品放在一个 299 美元的产品旁边，它看起来就更划算了。虽然只有 2% 的人会买 299 美元的，但结果是产品组合发生了变化，更多的人选择了 99 美元的，因为定价合理，尊重了心理阈值，而且在诱饵的衬托下，选择它更有道理。这只是重新设定了对话框架。在做出改变后，他们的月经常性收入（MRR）和每用户平均收入（ARPU）立即增长了 30% 以上。产品没变，功能没变，只是改变了沟通框架。这种事在我们身边随处可见。比如在电影院，小份爆米花 7 美元，加了黄油的超大份 8 美元。大多数人会想：“多花 1 美元就能买超大份，买它！”但那份 7 美元的爆米花其实是诱饵。如果没有它，大多数人会想：“我为什么要花 8 美元买爆米花？”所以这种行为框架和引导变得非常重要。这不是为了欺骗客户，而是为了以一种同时吸引理性和非理性大脑的方式来设定产品框架。我提到的那个 SaaS 产品的例子，让人们折中选择 99 美元的方案，其实就是一种“产品纪律”：不要在入门级产品中给得太多，至少为 99 美元的方案保留一些东西。如果你正确地构建包装，你可以强调“折中效应”（compromise effect），这是一个著名的行为理论，即人们倾向于避开极端。如果你注重质量，你会选右边；如果你注重预算，你会选左边；但大多数人会选择中间。如果你发现你的包装组合不是正态分布，而是大多数人都挤在入门级，那你就是给得太多了。也许你应该考虑如何改变功能和益处，引导更多人选择中间包，并根据你提供的价值收费。我们在书里讨论了很多行为定价策略，专门用了一整章。

---

### (01:20:54) Lenny

**English:**
Did you actually share a few of them? Just like some of these tactics that you find? I don't know if you have them in your head.

**中文翻译:**
你能再分享几个吗？就是你发现的一些这类策略？不知道你脑子里现在有没有现成的。

---

### (01:21:00) Madhavan Ramanujam

**English:**
Sure. You can talk about these topics all day long and I'm probably going to keep telling you what I know, but tell me when you're bored. So there are a few, right? I mean the compromise effect is the good, better, best that we talked about. The next one is what we call as, let's say pennies a day effect, or how you actually frame your pricing. So for instance, if I tell you a $30 per month price, it's very different from $1 per day. The way you actually frame your price, if you can actually showcase some kind of bargain, like AWS does this really well, the price that you actually see is so less because also the units and consumption is so less, but of course that will stack up if you use it a lot. But the price, if that started with a higher price point compared to a lower price point, that could have been different sort of situations. Similarly, for instance, when you take let's say you have a monthly subscription in your SaaS business and you also have an annual subscription, you need to showcase your annual subscription as a monthly price. Like, for instance it is 29.99 if you actually take an annual subscription, but it's 40 bucks a month if you actually do monthly subscription, but you're still messaging the price as a monthly price because if you actually just do the computation and say, "Okay, instead of saying $30 a month." I would end up saying it's 360 a year. That price could actually look like a higher price, but if you reframe it looks like a more attractive price. So that's a pennies a day kind of effect. I think that that kind of makes sense. On a product side, if you're what you're building is products and consumables, then things like the razor blade model actually makes a lot of sense. Most famous, made famous with razor blades, right? I mean if you think about the Gillette stick that you're buying, it's probably cheap, but their razor blades add up very quickly so that initial pricing or investment is less, but then you're making money on the consumables. Right? The HP print cartridges, same thing, the printer is cheaper, but then the cartridges add up. For a SaaS product, it's very similar. If you actually have a product that's a base platform, but then you have consumables, then you might want to make the platform price attractive so that people onboard themselves on the platform and then they're paying for chunks of usage, or things like this, which is a razor blade model, which is much more attractive for people typically because there's a lot of scrutiny on the upfront cost that people are actually paying as opposed to doing an entire TCV calculation. I mean, like a total cost of ownership calculation. Most people don't do that. They're looking at what they're actually going to pay. So if you're more attractive upfront, that could be a different way to reframe your product or price.

**中文翻译:**
当然可以。这些话题我可以聊一整天，我会一直告诉你我所知道的，如果你听烦了就叫停。还有几个：折中效应（好、更好、最好）我们已经谈过了。下一个是所谓的“每天几分钱”效应（pennies a day effect），或者说你如何设定价格框架。例如，我告诉你每月 30 美元，和每天 1 美元的感觉是非常不同的。如果你能展示某种廉价感，比如 AWS 做得很好，你看到的价格非常低，因为计费单位和消耗量很小，当然用多了也会累积。但如果一开始就以高价点切入，情况就会不同。同样，比如你的 SaaS 业务有月度订阅和年度订阅，你需要将年度订阅的价格展示为月度价格。比如，年付的话每月 29.99 美元，而月付是 40 美元。你依然以月度价格来沟通，因为如果你直接说一年 360 美元，这个数字看起来很大；但如果你重新设定框架，它看起来就更诱人。这就是“每天几分钱”效应。在产品方面，如果你构建的是产品加耗材，那么“剃须刀模式”（razor blade model）非常有意义。最著名的就是剃须刀：吉列的刀架可能很便宜，但刀片很贵，初始投资少，但通过耗材赚钱。HP 打印机墨盒也是一样：打印机便宜，墨盒贵。对于 SaaS 产品也类似：如果你有一个基础平台，然后有消耗品，你可能想让平台价格更具吸引力，让人们先上船，然后为用量付费。这种模式对人们更有吸引力，因为人们通常对前期成本非常敏感，而不会去做整个生命周期总成本（TCO）的计算。大多数人只看现在要付多少钱。所以，前期更具吸引力是重新设定产品或价格框架的另一种方式。

---

### (01:23:54) Madhavan Ramanujam (Continued)

**English:**
Maybe an advanced version of a behavioral tactic that I would probably talk about from product side is what we call is a Panini effect. The thesis for this is when we are kids, or for those of your listeners who have kids at home, one of the most repetitive exercises that we all went through as kids was to build puzzles, or fit different things together. Right? I used to do that. I thought I grew out of it. It so happens that you never grow out of this from a psychology standpoint, people love to build puzzles and have a compulsion because they just started with most of this in their childhood. So it is a Panini effect comes from the sticker book album that we actually used to collect when we are kids, or building puzzles, 500 pieces, whatever, all of these kind of things. So when you actually build a product, and even in the most of the most complex SaaS industries like financial services, when we have tested this with our clients, if you list the products usually 20% of people will buy more than one product, or they will attach themselves to more than one product because most of them are just buying one. Like, you have a real estate product, let's say you have a brokerage product, you have a different investment product, et cetera. You just list all the product. But if you show it as a puzzle and you actually say, "Hey, these are the six products that we offer, and if you complete it, you complete the puzzle. You have actually finished checking a few of these and these are empty." And that's like the first thing literally people actually see when they come into the product, we actually see the attached rates going crazily up. 40 to 50% of people suddenly start taking more products because there's a compulsion to say, "Yeah, I didn't finish this one." Even in a B2B SaaS setting. But of course if you're a B2C customer, like say you're a food delivery platform, or you're a ride hailing, for instance, if you say, "Okay, this is your weekly puzzle and if you take a ride every day, or you take a ride during evenings." Or, if you give people a task or a puzzle and show them the puzzle and show them that you have done this, but then these are the other things that you have not done, people change their behaviors because they actually feel a compulsion to finish it. Starbucks actually launched a bingo card, which is the same principle. So the Panini effect is a nice way to actually think about how to showcase your products in such a way that you create compulsion for people to buy multiple products. I mean, if there's show notes in your podcast, I'm happy to give you some visuals that you'll see it, it's bloody obvious.

**中文翻译:**
还有一个更高级的行为策略，我称之为“帕尼尼效应”（Panini effect）。其理论依据是：当我们还是孩子时，或者对于家里有孩子的听众来说，我们最常做的重复练习之一就是玩拼图，或者把不同的东西拼在一起。我以前也玩，我以为我长大了就不玩了。但从心理学角度看，你永远长不大，人们天生喜欢拼图，并有一种完成它的强迫感。帕尼尼效应源于我们小时候收集的贴纸簿，或者 500 片的拼图。当你构建产品时，即使是在最复杂的 SaaS 行业（如金融服务），当我们为客户测试这一点时：如果你只是列出产品，通常只有 20% 的人会购买超过一个产品。但如果你把它展示为一个拼图，并说：“嘿，这是我们提供的六个产品，如果你全部拥有，你就完成了拼图。你已经勾选了其中几个，这些还是空的。”当人们进入产品第一眼看到这个时，我们发现附加率（attach rates）疯狂上升。40% 到 50% 的人突然开始购买更多产品，因为有一种强迫感在说：“哎呀，我还没完成这个。”即使在 B2B SaaS 环境中也是如此。当然，如果你是 B2C 客户，比如外卖平台或打车软件，如果你说：“这是你的每周拼图，如果你每天打车，或者晚上打车……”如果你给人们一个任务或拼图，展示他们已经完成的部分和尚未完成的部分，人们会改变行为，因为他们感到一种完成它的强迫感。星巴克推出的宾果卡（bingo card）也是同样的原理。所以，帕尼尼效应是思考如何展示产品、创造购买多产品强迫感的一种好方法。如果你的播客有节目笔记，我很乐意提供一些视觉素材，你会发现这非常显而易见。

---

### (01:26:04) Lenny

**English:**
Absolutely. Please send, we will include them. I don't get why it's called the Panini effect. It makes me think of LinkedIn and their whole little completion percentage, but is the Panini because you make a thing and it all comes together?

**中文翻译:**
没问题，请发给我，我们会包含在笔记里。我不明白为什么叫“帕尼尼效应”。这让我想起 LinkedIn 的个人资料完成百分比。叫帕尼尼是因为你做了一个东西，然后它拼凑在一起了吗？

---

### (01:26:15) Madhavan Ramanujam

**English:**
No, I think this Panini effect, it comes from the Panini sticker books, whatever, all the things that we used to use before-

**中文翻译:**
不，这个帕尼尼效应源于帕尼尼（Panini）贴纸簿，就是我们以前用的那种……

---

### (01:26:22) Lenny

**English:**
Not the sandwich? Okay.

**中文翻译:**
不是那种三明治？好吧。

---

### (01:26:25) Madhavan Ramanujam

**English:**
No, it's not the sandwich. And yeah, I mean, I guess we made a category out of what this is. We just call it Panini.

**中文翻译:**
不，不是三明治。是的，我想我们是为这种现象创造了一个类别，就叫它帕尼尼。

---

### (01:26:32) Lenny

**English:**
Got it. There's something else you touched on that might be worth double clicking on it, is this price threshold psychological trick? Is there heuristics, or just rules of thumb of like, here's thresholds people generally have, or is it generally very custom to the product?

**中文翻译:**
明白了。你提到的另一件事可能值得深入探讨，就是价格阈值的心理技巧。有没有什么启发式方法或经验法则，比如人们通常有哪些阈值？还是说这通常是根据产品高度定制的？

---

### (01:26:46) Madhavan Ramanujam

**English:**
If you look across B2B SaaS, or consumer products, you'll find some thresholds that often make sense. Like for instance, if you are looking at $29, most people would say equate that to a dollar a day and say that $ 30 is a threshold. So you see some of these things. Beyond this you need to test for your own products and categories because the anchors are also referenced based on other competitive alternates, what their perception of value is, and so on. So doing the exercise, like I described earlier, the acceptable, expensive and prohibitively expensive would give you psychological thresholds. And by the way, that's also a behavioral pricing thing because you're saying if you cross 99 to like 101, there's a steep drop in the demand curve. And if you didn't know this, you can do all the quantity you want, you're going to probably optimize your prices somewhere. But at the end of the day, people are also looking at pricing from a psychological standpoint, and often we are able to validate this statistically and significantly as to what are the different thresholds for your products in the market. And this also gets a bit more quickly complex, and that's why the testing is important because it's not just about the product, but what happens when you have add-ons? What happens to the thresholds when you have price structures? Or, what happens to the thresholds when let's say you have a platform plus a usage strategy? So then the testing and learning becomes inevitable and there's no rule of thumb that you can just apply. But of course there are certain things like 30 bucks a month or whatever, that's a usual threshold that we see, or 9.99 famously made famous by all the subscriptions that we probably use.

**中文翻译:**
如果你观察 B2B SaaS 或消费品，你会发现一些通用的阈值。比如 29 美元，大多数人会把它等同于每天 1 美元，所以 30 美元是一个阈值。除此之外，你需要针对自己的产品和类别进行测试，因为锚点也会参考其他竞争替代品、他们的价值感知等等。所以，做我之前描述的“可接受、昂贵、高得离谱”的练习会给你心理阈值。顺便说一下，这也是行为定价的一部分，因为你是在说如果从 99 跨越到 101，需求曲线会大幅下降。如果你不知道这一点，无论你怎么做定量分析，你可能都会把价格优化到错误的地方。但归根结底，人们是从心理角度看待价格的，我们通常能够通过统计学验证市场上你产品的不同阈值。这很快会变得复杂，这就是为什么测试很重要，因为这不仅关乎产品，还关乎：有了附加组件会怎样？有了价格结构阈值会变吗？或者有了“平台+用量”策略会怎样？所以测试和学习是不可避免的，没有一个可以简单套用的经验法则。当然，像每月 30 美元这种是常见的阈值，或者是因各种订阅服务而闻名的 9.99 美元。

---

### (01:28:22) Lenny

**English:**
Awesome. Well, to start closing our chat, just a few more questions that I wanted to get through. One is the market is slower, the economy has slowed, purchasing seems to have slowed. Do you have any advice for founders, or product managers, or anyone thinking about pricing in this kind of market that we're in now?

**中文翻译:**
太棒了。在结束谈话前，我还有几个问题想问。一个是现在市场变慢了，经济放缓，购买似乎也减少了。对于在目前这种市场环境下思考定价的创始人、产品经理或任何人，你有什么建议吗？

---

### (01:28:46) Madhavan Ramanujam

**English:**
Yeah, I think it's a great question because we need to prepare for it, but of course be proactive. And I would say three things that founders can keep in mind when it comes to product pricing, if there is a downturn especially. The first thing to think about is building a lesser expensive alternate compared to what you actually have and keep it in your back pocket. So for instance, if you have a product, SaaS product, I would think of what can I de-feature from this product and then create a lesser expensive alternate that I keep in my back pocket to reduce churn. So if someone says, "You know what? I can't afford this anymore, it's a downturn." Give them the lesser expensive alternate, keep them in the system as opposed to them going away. If you just discounted price, guess what's going to happen six months later, that's going to be your new price. So before you price discount, think about what value can you exchange to actually justify that price discount. So you are taking value away in a de-featured product and hence you can discount. So having that price integrity is super important with your customers. So don't just rush to dropping price, that'll be the absolute worst thing you can do to yourself at that moment, and also in future. So having these kind of less expensive alternates. Second one I usually say, which is in line with not dropping the price, is to think about three non pricing actions that you can do when this actually happens. For instance, do I give more product to preserve the price? That's a non pricing action. So I give more value. Say, "Hey, times are tough. Take the best product professional, you've being a great customer." Earn the loyalty. But when times are great, you're probably going to renew the pricing at let's say a higher price because you just gave them a product for one year at the same price that they're actually paying. So I think that's a non pricing alternate. Or, it could be change the contract terms, say that, okay, take a three year contract, or two year contract and then think about that as an alternative as opposed to reducing price. Or, things like for instance, payment terms. Like, "Okay, if you say it's difficult, I'll change it from 15 days to 30 days." And level the payment terms as opposed to changing price, right? So three non pricing actions. We write about some of these also in the book, and the last one I would probably say is think about changing your business model or pricing model. You talked about usage based pricing, frankly an outcome based or attribution based pricing. Frankly, there's the best time to actually think about these things. Like, if people are not using the product, changing it to a usage based, people would say, "That's great because there's a downturn, we're not using the product." And they would opt into a usage based pricing because they're going to pay lesser because they're not using. But when times are good, again, they're going to use it. And basically what you did is you just lodged in a usage based pricing easily compared to trying to do that when the times are good and people are saying, "Oh, I actually want fixed, or I don't want the usage." And things like this. You actually just took that as an opportunity to change. I mean, one extreme example that was interesting during the pandemic is a software company that was actually providing software to hair salons. I mean, just as an example, like hair salons. And this company, I mean, it used to be a per seat model. I mean, that just used to make sense, but they want think about usage. During the pandemic no one for instance, went to a haircut. They were all taking this at home. So they said, "Okay, let's change it to a per haircut basis." But of course when things are back again, that kind of model can recoup a lot more compared to a per seat model because that's really where the value is actually getting derived, right? I mean, just as an example. So three things again. One is thinking about changing your pricing model, three non pricing actions that you can take, and then how can you de-feature something and keeping it in your back pocket so that you can have a proper pricing conversation and not just drop a price.

**中文翻译:**
是的，这是一个非常好的问题。我们需要为此做好准备，并且要主动出击。在经济低迷时期，关于产品定价，创始人可以记住三件事。第一，考虑构建一个比现有产品更便宜的替代方案，并把它作为“后手”。例如，如果你有一个 SaaS 产品，我会想：我可以从这个产品中去掉哪些功能，从而创建一个更便宜的替代品，放在口袋里以减少流失。如果有人说：“你知道吗，我付不起这个钱了，现在经济不景气。”那就给他们那个便宜的替代方案，把他们留在系统中，而不是让他们流失。如果你只是直接打折，猜猜六个月后会发生什么？那个折扣价就会变成你的新价格。所以在降价之前，想想你可以交换什么价值来证明降价的合理性。你在一个“去功能化”的产品中拿走了价值，因此你可以降价。保持价格诚信对客户来说非常重要。所以不要急于降价，那是你当时以及未来能对自己做的最糟糕的事。所以要准备好这种廉价替代品。第二，我常说的是（与不降价一致），考虑三种你可以采取的“非价格行动”。例如，我是否可以提供更多产品来维持原价？这是一种非价格行动。你提供了更多价值，说：“嘿，现在时局艰难，你是我们的老客户，免费升级到专业版吧。”以此赢得忠诚度。当经济好转时，你可能会以更高的价格续约，因为你只是在一年内以同样的价格给了他们更好的产品。或者，可以改变合同条款，比如签一个三年或两年的合同，以此作为降价的替代方案。或者改变支付条款，比如从 15 天结款改为 30 天，利用支付条款而不是改变价格。第三，考虑改变你的业务模式或定价模式。你提到了用量计费，坦白说，还有基于结果或基于归因的定价。现在其实是思考这些问题的最佳时机。如果人们不怎么用产品，改为用量计费，人们会说：“太好了，因为经济不景气，我们用得少。”他们会选择用量计费，因为付得更少。但当经济好转，他们会用得更多。你实际上是利用这个机会轻松引入了用量计费，而如果在经济好的时候做，人们可能会说“我想要固定价格”。疫情期间有一个有趣的极端例子：一家为理发店提供软件的公司。以前是按席位收费，这很合理。但在疫情期间，没人去理发，大家都在家自己理。于是他们改为“按理发次数”收费。当生活恢复正常后，这种模式比按席位收费能收回多得多的价值，因为那才是价值真正产生的地方。所以总结一下：一是考虑改变定价模式，二是采取非价格行动，三是准备好“去功能化”的廉价替代品，以便进行正当的定价对话，而不是直接降价。

---

### (01:32:48) Lenny

**English:**
That is some killer advice. Thank you for sharing all that.

**中文翻译:**
这建议太棒了。谢谢你的分享。

---

### (01:32:51) Madhavan Ramanujam

**English:**
Thank you.

**中文翻译:**
谢谢。

---

### (01:32:52) Lenny

**English:**
Something else is, during our chat, preparing for this call, you mentioned that you're maybe working on a new book.

**中文翻译:**
另外，在我们准备这次通话的聊天中，你提到你可能正在写一本新书。

---

### (01:32:59) Madhavan Ramanujam

**English:**
Yes.

**中文翻译:**
是的。

---

### (01:32:59) Lenny

**English:**
Can you talk about what it's going to be about and anything else?

**中文翻译:**
你能谈谈它关于什么吗？还有其他信息吗？

---

### (01:33:02) Madhavan Ramanujam

**English:**
Sure. I will try to see what I can talk about without getting too detailed, but the thesis of the book is... the title of the book is, it's called Unlocking Growth, Growth That is Profitable, Better, et cetera. So Unlocking Growth and the subtitle is Breakthrough Strategies for Acquisition, Monetization and Retention of Customers. So this is a bit like where Monetizing Innovation stopped and this book picks up from that, when let's assume you've built a great product based on what customers need, what they value, what they're willing to pay for, now what? You need to acquire customers, you need to monetize them, you need to retain them. So this book actually gets into all of those dimensions, and the key pattern that we have seen Lenny, over and over again is most companies would have teams and people dedicated to these three functions. I mean, acquisition, monetization, retention. If you unlock these three, you're getting to profitable growth, right? I mean, that's literally the three things you ought to focus on. But what ends up happening is most people don't understand the interaction effects across these, or they, in the worst case, they even treat it as silos. So the acquisition team works on something, but the monetization team is not looking at the interaction of what they actually do. For instance, 90% of customers or people who we meet who claim to have a land and expand strategy are only landing. They're not expanding because they gave their farm away in the land. So how do you actually think about a land and expense strategy in such a way that you can acquire, monetize, and retain customers? So this book actually goes into breakthrough strategies to balance the trade off between acquisition, monetization, and retention and build the right products and come up with the right pricing strategy.

**中文翻译:**
当然。我尽量在不透露太多细节的情况下说一下。书的主题……书名叫做《解锁增长》（Unlocking Growth），关注的是盈利性的、更好的增长。副标题是“客户获取、变现与留存的突破性策略”。这有点像《货币化创新》结束的地方，这本书从那里开始：假设你已经根据客户需求、价值和支付意愿构建了一个伟大的产品，然后呢？你需要获取客户，需要变现，需要留存。所以这本书深入探讨了所有这些维度。Lenny，我们反复看到的一个关键模式是：大多数公司都有专门负责这三个职能的团队和人员。如果你解锁了这三个环节，你就实现了盈利性增长，对吧？这正是你应该关注的三件事。但结果往往是，大多数人不理解这些环节之间的相互作用，或者在最坏的情况下，把它们当作孤岛。获取团队在做一套，但变现团队没有看他们行为的相互影响。例如，我们遇到的声称拥有“着陆并扩张”（land and expand）策略的客户中，90% 其实只是“着陆”了，他们根本没有“扩张”，因为他们在着陆阶段就把筹码都给光了。那么，你如何思考一种能同时兼顾获取、变现和留存的“着陆并扩张”策略呢？所以这本书深入探讨了平衡获取、变现和留存之间权衡的突破性策略，从而构建正确的产品并制定正确的定价策略。

---

### (01:34:41) Lenny

**English:**
You're going to have incredibly strong product market fit with this audience. Is this something anyone can pre-order yet, sign up to get notified when it's out?

**中文翻译:**
你这本书在这些听众中会有极强的“产品市场契合度”。现在可以预订了吗？或者可以注册接收出版通知吗？

---

### (01:34:48) Madhavan Ramanujam

**English:**
I think the pre-order probably is still open in Amazon, so I think that's something you can check. I haven't checked lately, but you can follow me on Twitter, @MadhavanSF. That's M-A-D-H-A-V- A-N-S-F. I usually tweet about this book, and in general, or follow me on LinkedIn, or add me on LinkedIn. I think those are probably some good ways to keep in touch. The book is supposed to be out in Q2. Q2, Q3 timeframe, so watch out for it.

**中文翻译:**
我想亚马逊上的预订可能已经开启了，你可以去查一下。我最近没看，但你可以关注我的 Twitter @MadhavanSF。我通常会发关于这本书的消息。或者在 LinkedIn 上关注或添加我。这些都是保持联系的好方法。书预计在第二季度或第三季度出版，敬请期待。

---

### (01:35:17) Lenny

**English:**
Amazing. So it's called Unlocking Growth, they can search on Amazon, right?

**中文翻译:**
太棒了。书名是《Unlocking Growth》，他们可以在亚马逊上搜到，对吧？

---

### (01:35:20) Madhavan Ramanujam

**English:**
Yeah, absolutely. If you look for Unlocking Growth and even bookmark it, you're going to have it in your list of books that you want to buy.

**中文翻译:**
是的，完全正确。如果你搜索《Unlocking Growth》并把它加入书签，它就会出现在你的待购清单里。

---

### (01:35:26) Lenny

**English:**
All right, I'm going to pre-order it immediately. Any other good resources that you recommend for folks that want to learn more about pricing and just all the things that we talked about other than your book?

**中文翻译:**
好，我马上就去预订。除了你的书，你还有什么好的资源推荐给那些想进一步了解定价和我们今天讨论的所有内容的人吗？

---

### (01:35:36) Madhavan Ramanujam

**English:**
There are a number of resources. Our founder Herman Simon, of the Simon of Simon Kucher has done a lot of books, particularly I like one, which is called Confessions of the Pricing Man. I mean, he started this business 35 years ago and literally out of university and academia, and we have grown to where we are today. But it talks about some of the lessons that he has learned. I find it fascinating and it's probably the better book, compared to Monetizing Innovation. So I think I would urge readers, definitely read that. The other book that probably we also put out, which is topical right now, is one of my partner colleagues, Adam Hector and Herman wrote a book on pricing during inflation and inflationary times. So I think that's a very topical book that I think your readers can pick. This is within our Simon Kucher assets of people who have actually written books. Another resource to probably look at is Kyle Poyar from Open View, he puts out some really good stuff on product led draw pricing, et cetera. I mean, he's an alumni Simon Kucher, so we are proud of our alumni, but it's some fantastic work that he has done. He has also written some SaaS pricing guides, et cetera. So I would highly encourage you to check Kyle's work. I think that's fascinating, and also feel the folks at First Round are pretty good at putting some good content on pricing product, et cetera.

**中文翻译:**
有很多资源。我们 Simon-Kucher 的创始人赫尔曼·西蒙（Herman Simon）写过很多书，我特别喜欢其中一本叫《定价人自白》（Confessions of the Pricing Man）。他 35 年前从学术界出来创办了这家公司，并发展到今天的规模。书中讲述了他学到的一些教训，我觉得非常迷人，甚至可能比《货币化创新》还要好。所以我敦促读者一定要读读那本。另一本我们出版的、现在非常应景的书是我的合伙人同事 Adam Hector 和赫尔曼合著的关于通货膨胀时期定价的书。我觉得这也是读者可以参考的热门书籍。此外，还可以关注 OpenView 的 Kyle Poyar，他在产品驱动增长（PLG）定价方面发布了很多非常棒的内容。他是 Simon-Kucher 的校友，我们为他感到自豪，他做的工作非常出色，还写了一些 SaaS 定价指南。我强烈建议大家查看 Kyle 的作品。另外，First Round 的人在定价和产品方面的内容也做得非常好。

---

### (01:36:55) Lenny

**English:**
Amazing. We will link to all of that in the show notes. Madhavan this was everything I hoped it would be. This is probably the record for the longest podcast we've done, and it's no better topic to spend a lot of time on. Thank you again so much for joining me. Two final questions. You answered most of them, but just in case there's anything else, where can folks find you online and learn more? And how can listeners be useful to you?

**中文翻译:**
太棒了。我们会把所有这些链接放在节目笔记里。Madhavan，这次谈话完全符合我的预期。这可能是我们做过的最长的一期播客，而定价这个话题确实值得花这么多时间。再次感谢你的参与。最后两个问题（虽然你已经回答了大部分）：大家可以在哪里在线找到你并了解更多？听众可以为你做些什么？

---

### (01:37:18) Madhavan Ramanujam

**English:**
Online I mentioned LinkedIn, so Madhavan Ramanujam that's on LinkedIn and @MadhavanSF on Twitter, that's probably where you can find me online. Or, even at SimonKucher.com, and you can search for leadership and you'll probably see my name there. What can listeners do? I think I would probably say that the fundamental level, if you can talk about this topic, actively share what you have learned. If there are sections of the book, for instance, that you like talk about it, the biggest thing that we can all do is to educate each other and everyone that there's a science behind all of this and it's not just an art, and if that's relevant, then I think message accomplished, that's also why we wrote Monetizing Innovation.

**中文翻译:**
在线方面，我提到了 LinkedIn（搜索 Madhavan Ramanujam）和 Twitter（@MadhavanSF），这些是找到我的主要地方。或者在 SimonKucher.com 搜索领导层名单，你也能看到我的名字。听众能做什么？我想说，在最基础的层面上，如果你能谈论这个话题，积极分享你学到的东西，那就太好了。如果你喜欢书中的某些章节，请谈论它。我们能做的最大的事就是互相教育，让每个人都知道这一切背后是有科学依据的，而不仅仅是艺术。如果大家能意识到这一点，那么我的使命就完成了，这也是我们写《货币化创新》的初衷。

---

### (01:38:04) Lenny

**English:**
What a beautiful way to end it. Madhavan, thank you again for being here.

**中文翻译:**
多么完美的结尾。Madhavan，再次感谢你的到来。

---

### (01:38:07) Madhavan Ramanujam

**English:**
Thanks, Lenny.

**中文翻译:**
谢谢，Lenny。

---

### (01:38:09) Lenny

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcast, Spotify, or your favorite podcast app. Also, please consider giving us a rating, or a leaving review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at Lennyspodcast.com. See you in the next episode.

**中文翻译:**
非常感谢大家的收听。如果你觉得本期节目有价值，可以在 Apple Podcast、Spotify 或你喜欢的播客应用中订阅。此外，请考虑给我们评分或留下评论，这能帮助其他听众找到这个播客。你可以在 Lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。