# Maggie Crowley - 双语对照

This is the complete bilingual transcript for **Lenny's Podcast** featuring **Maggie Crowley**.

---

### [00:00:00] Maggie Crowley

**English:**
If you ever find yourself saying something like, that's not my job, that's probably a thing you should do. And you know what? It probably isn't your job and it probably is someone else's job and you can spend your life getting frustrated at that or you can just get over and get the work done. And people who are willing to just get the work done will move faster. Their products will be more successful and they probably aren't carrying around all that anger and crappy emotion because as a PM, for better or for worse, and maybe this is not how we all want it to be, but you're oftentimes the emotional center of the team and it's your job to keep people motivated, keep people excited, keep them bought into the project, and you just have to keep that optimism going and it's hard work and part of it can be just like, you know what? Let me take that on. I'll do this thing. I'll hop on this sales call, I'll implement this with the customer. You just have to do whatever it takes.

**中文翻译:**
如果你发现自己说出“那不是我的工作”之类的话，那可能正是你应该去做的事。你知道吗？那确实可能不是你的职责，也确实应该是别人的工作，你可以一辈子为此感到沮丧，或者你可以直接跨过去把活干了。那些愿意直接把活干完的人会进步得更快。他们的产品会更成功，而且他们可能不会背负那么多愤怒和糟糕的情绪。因为作为一名产品经理（PM），无论好坏，也许这并非我们所愿，但你通常是团队的情感中心。你的职责是让大家保持动力，保持兴奋，让他们认同这个项目。你必须维持那种乐观情绪，这是件苦差事。其中一部分工作可能就是：“你知道吗？让我来承担吧。我来做这件事。我参加这个销售电话，我来帮客户实施这个功能。”你必须不惜一切代价达成目标。

---

### [00:00:57] Lenny

**English:**
Today my guest is Maggie Crowley. Maggie is currently vice president of Product at Toast. Prior to this, she was VP and head of product at Charlie Health, senior director of product at Drift, director of product at BevSpot, a product manager at TripAdvisor. She's also got an MBA from Harvard Business School. She was also an Olympic speed skater, which is insane and incredibly cool. And in our conversation we discuss the three most common threads across the best product managers that she's worked with, hired and managed how to very tactically write out a product strategy to share with your team and manager why being data-driven is a red flag for product thinking. Why product content you find online can be dangerous. Her best advice for how to break into product management. Also, the impact writing online has had on her career and so much more. Maggie is amazing.

**中文翻译:**
今天的嘉宾是 Maggie Crowley。Maggie 目前担任 Toast 的产品副总裁。在此之前，她曾任 Charlie Health 的产品副总裁兼负责人、Drift 的高级产品总监、BevSpot 的产品总监以及 TripAdvisor 的产品经理。她还拥有哈佛商学院的 MBA 学位。她曾是一名奥运速滑选手，这简直太疯狂、太酷了。在我们的对话中，我们讨论了她合作过、招聘过和管理过的最优秀产品经理身上的三个共同特质；如何非常务实地撰写一份产品策略并与团队和经理分享；为什么“数据驱动”有时是产品思维的危险信号；为什么你在网上看到的产品内容可能具有误导性；她对如何进入产品管理领域的最佳建议；以及在线写作对她职业生涯的影响等等。Maggie 非常出色。

---

### [00:01:44] Lenny (Sponsorships)

*(Note: This segment contains sponsorship information for Productroadmap.ai, Ignition, and Composer. For brevity and focus on the core content, the translation maintains the key value propositions.)*

**English:**
(00:01:44): I'm excited for you to learn from her like I did. With that, I bring you Maggie Crowley after a short word from our sponsors. This episode is brought to you by Productroadmap.ai and ignition Productroadmap.ai is the first AI roadmapping suite... [Sponsorship details for Productroadmap.ai, Ignition, and Composer]... Head to composer.trade and use the code Lenny for an extra week of free trial on your composer membership. That's composer.trade. (00:04:06): Maggie, thank you so much for being here. Welcome to the podcast.

**中文翻译:**
(00:01:44): 我很高兴你们能像我一样从她身上学到东西。在听完赞助商的简短介绍后，我将为你带来 Maggie Crowley 的访谈。本期节目由 Productroadmap.ai 和 Ignition 赞助。Productroadmap.ai 是首个 AI 路线图套件……[此处省略 Productroadmap.ai、Ignition 和 Composer 的具体广告详情]……请访问 composer.trade 并使用代码 Lenny 获取额外一周的免费试用。 (00:04:06): Maggie，非常感谢你能来。欢迎来到播客。

---

### [00:04:10] Maggie Crowley

**English:**
Thanks for having me. I'm super excited.

**中文翻译:**
谢谢邀请我。我非常兴奋。

---

### [00:04:12] Lenny

**English:**
You put out so much content across podcasts, blogs, tweets, I'm sure there's other things I haven't even seen. And so what I've done is I've scoured all of your content as much as I could to find topics that we could dig into in our conversation today. And I thought it'd be fun to start with how to become a successful product manager and what it takes to be a successful product manager, especially long-term in your career. You've worked with a bunch of PMs, you've hired a lot of PMs, you've managed a lot of PMs, and so I guess the question is just what are some common threads you've seen across the best product managers?

**中文翻译:**
你在播客、博客、推特上发布了这么多内容，肯定还有些我没看过的。所以我尽可能地搜寻了你所有的内容，想找些话题在今天的对话中深入探讨。我想，从“如何成为一名成功的产品经理”以及“成功的产品经理需要具备什么素质”开始会很有趣，尤其是从职业生涯的长期发展来看。你和很多 PM 合作过，招聘过也管理过很多 PM，所以我想问，你在那些最优秀的 PM 身上看到了哪些共同点？

---

### [00:04:50] Maggie Crowley

**English:**
Yeah, it's an interesting question mostly because I've worked in startups, zero to one, scaling stage startups, enterprise, all that kind of stuff. And there's a lot of content out there I think on how those roles are different and how PMs are different across those different types of companies. But what I've seen is that there are some standard things that are the same across the role no matter whether you're a consumer, B2B or startup or a large company and in particular about what sets PMs apart from one another. And the things that I look for when I'm hiring or when I'm looking to promote people or when PMs stand out, even when you're not looking are three things.
(00:05:31): First, I think the best PMs are really good at breaking things down and simplifying things. So, finding at any moment what is the really truly the only thing you need to do, especially in a big company, there are 8 million priorities, there's 700 OKRs, there's 25,000 projects you could work on, and teams will get bogged down in that complexity. Similarly speaking at a startup, you might think that it's easy to find the one thing to do, but at the same time there's so many fires that are happening and so many things you could do in such a world of opportunity that even just picking one and sticking with it is really difficult. And so the best PMs not only can find the one thing to work on, but they can stay with that one thing long enough to actually finish it.

**中文翻译:**
是的，这是一个很有趣的问题，主要是因为我曾在初创公司、从零到一阶段、规模化阶段的初创公司以及大型企业都工作过。关于这些角色在不同类型公司中的差异，网上已经有很多内容了。但我发现，无论是在消费级、B2B、初创公司还是大公司，这个角色都有一些通用的标准，特别是那些能让 PM 脱颖而出的特质。当我招聘、考虑晋升某人，或者观察那些即便你没刻意关注也能脱颖而出的 PM 时，我主要看三点：
(00:05:31): 第一，我认为最优秀的 PM 非常擅长拆解问题和简化事物。也就是说，在任何时刻都能找到那件“真正唯一”需要做的事。特别是在大公司，有 800 万个优先级，700 个 OKR，2.5 万个你可以做的项目，团队很容易陷入这种复杂性中。同样，在初创公司，你可能觉得找出一件事做很容易，但同时到处都在“救火”，机会太多了，以至于仅仅选定一个并坚持下去都非常困难。因此，最优秀的 PM 不仅能找到那件该做的事，还能在那件事上坚持足够长的时间，直到真正把它完成。

---

### [00:06:15] Lenny

**English:**
I think that's a really interesting point, because it sounds simple. Also, just this idea of simplifying, but I think there's so much up there partly because within simplifying is prioritizing and you can almost boil down the job of the PM as they're just prioritizing and telling people what is next. And so I think that's a really powerful point you're making.

**中文翻译:**
我觉得这一点非常有趣，因为它听起来很简单。简化这个概念看似容易，但其实内涵丰富，因为简化本质上就是优先级排序（Prioritizing）。你几乎可以把 PM 的工作归结为：不断排序并告诉大家下一步该做什么。所以我认为你提出的这一点非常有力量。

---

### [00:06:33] Maggie Crowley

**English:**
Prioritization is a tough word because there's so much wrapped up in that and what it means to prioritize. And I've worked for people who wanted to understand the formula for prioritization and why this thing and how can you prove that this is the right thing to work on and not that thing. And then a week goes by and then they want to reevaluate the priority and they want to re-litigate the priority. And so it's so much more than just a moment in time deciding, but it's the ability to stay with it and to make sure that it continues to be the most important thing, that you finish it and actually see that it works and that you can get people to continue to stay excited and engaged in that project.
(00:07:13): Because I think a lot of when we talk about product, it's like, oh, what should you build? What should you ship? But then you actually have to ship that and that can take a week, a month, three months, six months, a year. And so as a PM, your job is to stay on that and be the person who's beating that drum over and over again, and the best PMs are the ones who can do that and have the resilience and the energy to stay with it.

**中文翻译:**
“优先级排序”是个很难定义的词，因为它包含的内容太多了。我曾为一些人工作，他们想知道排序的公式，想知道为什么要选这个，以及你如何证明做这个是对的而不是那个。然后一周过去了，他们又想重新评估优先级，重新争论。所以，这不仅仅是某个时刻的决定，而是一种坚持下去的能力，确保它始终是最重要的事，直到你完成它并看到它产生效果，并且你能让大家在整个过程中保持兴奋和投入。
(00:07:13): 因为当我们谈论产品时，大家往往关注“该建什么？该发布什么？”，但你实际上必须去发布它，这可能需要一周、一个月、三个月、半年甚至一年。所以作为 PM，你的工作就是盯紧它，成为那个不断敲鼓催进的人。最优秀的 PM 是那些能够做到这一点，并拥有韧性和精力坚持到底的人。

---

### [00:07:38] Lenny

**English:**
Energy. That's a really important part of that. I'm going to ask you how you suggest people get better at these things. So, either we can go into how you found you get better at simplifying or we go through all three and then we can come back, however you prefer.

**中文翻译:**
精力，这确实是非常重要的一部分。我想问问你建议大家如何提高这些能力。我们可以先聊聊你如何学会简化的，或者我们先过完这三点再回头细聊，看你方便。

---

### [00:07:51] Maggie Crowley

**English:**
Let's just do all three really quick and then we can dig in.

**中文翻译:**
我们先快速过完这三点，然后再深入探讨。

---

### [00:07:54] Lenny

**English:**
Sounds great.

**中文翻译:**
太好了。

---

### [00:07:55] Maggie Crowley

**English:**
So, yeah, first one, simplifying. I think the second one has to do with this point about sticking with something and it's following up on results. So many people in the spec or the one pager or something will say, okay, here's the metric that I care about. Here's what I want to move. Awesome. Maybe they'll even write a SQL query, get a dashboard going, figure out what the number is today, that gets you some extra points, but the really, really good PMs remember to follow up. Because especially when you're in management, couple layers up in management, I'm not going to remember to follow up on that feature, but if a PM comes back to me and says, "Hey, remember we did that thing, here's what happened." I can't tell you how rare that is and how many times as a leader you might have to ask for that and for the people you don't have to ask that of is one of the best things when I'm looking at PMs and it's easy.
(00:08:43): It's not hard to do that, especially if you've set up metric tracking or you know how to pull that information or you have somebody who can help you get that. It's pretty easy to do and it's really high value activity. And then the third thing, and I think maybe we'll talk about this later too, is that a phrase actually we were talking about David Cancel before we started carrying the water, and this was a big theme when I joined Drift, and this was about how you can't be a good PM if you're not willing to do the hard boring unglamorous work of customer support, sales, marketing, writing, copy, project management, you have to do that stuff. It's your job. No one else is going to do it, because at the end of the day, you're responsible for outcomes and results. So, you're the person that has to do that, and if you're willing to do that work, that's what's going to make your product successful, which is what makes you successful.

**中文翻译:**
好的。第一点是简化。第二点与“坚持到底”有关，那就是**跟进结果（Following up on results）**。很多人在需求文档（Spec）或单页计划（One-pager）里会写：“这是我关注的指标，这是我想改变的数字。”这很好。也许他们还会写个 SQL 查询，弄个仪表盘，搞清楚今天的基准数字，这能加分。但真正顶尖的 PM 会记得跟进。因为当你处于管理层，尤其是高几级的管理层时，我不会记得去跟进那个具体功能。但如果一个 PM 回来跟我说：“嘿，记得我们做的那个东西吗？结果是这样的。”我无法告诉你这有多罕见。作为领导者，你往往需要主动去问，而对于那些不需要你问就能主动反馈的人，那是我衡量 PM 时最看重的特质之一。而且这其实很简单。
(00:08:43): 这并不难，特别是如果你已经设置了指标追踪，或者知道如何提取信息。这是非常容易做到且价值极高的活动。第三点，也许我们稍后还会细聊，就是“**挑水（Carrying the water）**”——这是我们在开始前聊到 David Cancel 时提到的一个词，也是我加入 Drift 后的一个重要主题。它的意思是，如果你不愿意做那些辛苦、枯燥、不体面的工作，比如客户支持、销售、市场、写文案、项目管理，你就无法成为一名优秀的 PM。你必须做这些事。这是你的职责，没别人会替你做。因为归根结底，你要对产出和结果负责。所以，你就是那个必须动手的人。如果你愿意做这些工作，你的产品才会成功，你也才会成功。

---

### [00:09:33] Lenny

**English:**
It's such an interesting list because when you ask most people what you need to get better at to become a great product manager, it's always communication skills, collaboration skills, vision, strategy, and it feels like these are input metrics to what it's normally what people think about.

**中文翻译:**
这个清单非常有趣。因为当你问大多数人“如何成为伟大的产品经理”时，答案总是沟通技巧、协作能力、愿景、策略。感觉你说的这些更像是达成那些人们通常认为的重要目标的“投入指标（Input metrics）”。

---

### [00:09:50] Maggie Crowley

**English:**
Those things to me, communication, super important, analytical ability, really, really important. The ability to look at a, especially if you're doing something that has a user experience component, the ability to look at that and understand if it's going to work and build up intuition around that, also really important. Those are things that I would see as sort of basics of the role. These are the things that make you great at the role and strategy to me, and hopefully we'll talk about strategy in a bit. It's one tiny slice. You do a strategy, but it's 5% of the work that you do. Yes, it's important because you want to get your strategy and you need to pick the right products, but at the end of the day, the person who has a good strategy will not be as successful as the PM who ships more stuff, gets more reps and has the ability to actually create impact. So, to me, you could be great at strategy, but if you're not good at this stuff and your stuff isn't getting out the door, you're never going to be that great at the job.

**中文翻译:**
对我来说，沟通、分析能力都超级重要。如果你在做涉及用户体验的东西，观察并判断它是否有效、建立直觉的能力也非常重要。但我认为这些只是这个角色的“基本功”。而我说的这三点是让你变得“伟大”的特质。至于策略（Strategy），我们待会儿会聊到，它其实只占很小一部分。你制定策略，但它只占你工作的 5%。是的，它很重要，因为你需要选对产品，但归根结底，一个拥有完美策略的人，其成功程度往往不如一个能发布更多东西、获得更多实战经验（Reps）并能真正产生影响力的 PM。所以对我来说，你可以很擅长策略，但如果你不擅长这些实干的事，你的东西发不出去，你就永远无法在这一行做到顶尖。

---

### [00:10:48] Lenny

**English:**
And impact is the other one. Everyone's always like, what makes a great PM? Oh, drive a lot of impact. And again-

**中文翻译:**
“影响力（Impact）”是另一个关键词。大家总说，什么是伟大的 PM？哦，就是能产生巨大影响力的。但是……

---

### [00:10:52] Maggie Crowley

**English:**
But they never say how.

**中文翻译:**
但他们从不告诉你“如何”产生影响力。

---

### [00:10:54] Lenny

**English:**
Right, exactly.

**中文翻译:**
没错，正是如此。

---

### [00:10:54] Maggie Crowley

**English:**
It's like, cool, let's do a strategy, let's have impact. Then when I was starting off as a PM, I was hearing this advice and reading about it and I was sitting there saying, awesome, I want to create impact. And I'm looking at my job thinking, now what? Yeah, impact. Let's do it. Where is it? How do I find it? Someone help me.

**中文翻译:**
就像是，“酷，我们来搞个策略，产生影响力吧。”当我刚开始做 PM 时，我听着这些建议，读着这些文章，坐在那儿想：“太棒了，我想创造影响力。”然后我看着我的工作想：“然后呢？影响力，来吧！它在哪儿？我怎么找到它？谁来帮帮我。”

---

### [00:11:14] Lenny

**English:**
I love it. Okay, so let's go back to these three and I'm curious just what you found helps you become better at these things and also just an example if you can share. So, say what's simplifying? How does one build that muscle?

**中文翻译:**
太真实了。好，让我们回到这三点。我很想知道你发现什么能帮助人们在这些方面变得更好，如果能分享个例子就更好了。比如“简化”，一个人该如何锻炼这种能力？

---

### [00:11:27] Maggie Crowley

**English:**
This is a tough one because some people, a broad generalization that I think comes up in things like when you're interviewing PMs for a job and you say things like are they a simplifier or are they complexifier? Do they make things complicated? And so some of it's a little bit of just who you are and how you think. But having said that, there's one tool that I use that I actually learned from my dad when I was in grade school, which is when you write something, for example, and a lot of what we do as PMs is written, when you write something, read it out loud, literally just read the thing you wrote out loud and half the time you'll realize it's way too complicated, it doesn't make sense. Or what happens is when someone comes to me and they say, okay, I'm working on this thing, check it out, can you read it?
(00:12:10): I read it and then I put it down and I say, "What are you trying to say?" And 99% of the time they say, "Oh, users are really struggling with this problem. We found this in research and we think that the way to solve it's to do X", but that's not what the document says. And so my reaction is always, and if anyone who I've worked with is listening to this, they're going to laugh is always, "Just say that. Just say that thing. The thing that you said to me in conversation is the thing you should write." There's no reason why your pros in a document has to be a certain way. We're not in school. Our goal is to get things done. So, those are just some simple tricks that I've used to help simplify what I've already been working on.
(00:12:54): And as for how to boil things down and really find the most important thing to do, which is another part of simplification, I think the best thing you can do is just get as many reps in as you can, have people review your work and listen to them. There's a thing that happens I think with PMs where you join a company and then all of a sudden it's like my boss doesn't know what they're doing and the highest paid person's opinion and the founder wants to swoop in and mess everything up, but those people had an insight on the market that you're in that made the company worth founding and they probably know more than you and so you might want to listen to them. And so find people who can review your work, listen to them and ask them to help you simplify.

**中文翻译:**
这很难，因为这涉及到一种普遍的分类：在面试 PM 时，我们会看他是“简化者（Simplifier）”还是“复杂化者（Complexifier）”？他会让事情变得更复杂吗？所以这在一定程度上取决于你的性格和思维方式。话虽如此，我有一个从我父亲那里学到的工具（当时我还在上小学）：当你写东西时（PM 的很多工作都是书面的），把它大声读出来。字面意思上的读出来。一半的情况下，你会发现它太复杂了，根本不通顺。或者经常发生这种情况：有人拿着文档来找我，“我在做这个，你能看看吗？”
(00:12:10): 我读完后放下文档问：“你想表达什么？”99% 的情况下，他们会说：“哦，用户在这个问题上很挣扎，我们在调研中发现了这一点，我们认为解决办法是做 X。”但文档里写的根本不是这个！所以我的反应总是（如果和我共事过的人在听，肯定会笑）：“那就直接这么写。把你刚才跟我说的话写下来。文档里的文字没必要非得是某种特定格式。我们不是在学校，我们的目标是把事情办成。”这些就是我用来简化工作的一些小技巧。
(00:12:54): 至于如何提炼重点并找到最重要的事情（这是简化的另一部分），我认为最好的办法就是多练习（Get reps），让人评审你的工作并听取意见。PM 圈子里常有一种现象：你加入一家公司，然后突然觉得“我老板根本不知道自己在干嘛”，或者抱怨“高薪人士的意见（HiPPO）”和创始人总是插手搞乱一切。但这些人对市场的洞察力是公司创立的基石，他们可能比你懂得多，所以你最好听听他们的。找那些能评审你工作的人，听取他们的意见，请他们帮你简化。

---

### [00:13:39] Lenny

**English:**
I'll share a couple other things that came to mind as you were talking, because this is a very hard thing to teach and you kind of have to do it again and again and honestly, I have this one manager who taught me to simplify in my writing and strategy docs one-pagers and things like that, and I think that actually had a big impact on my newsletter success is learning just to strip down as much as you can and anything that isn't necessary. So, there's a couple things that I'll share real quick. One is there's this book I read called On Writing Well, that is one of the most impactful books for writing for me, and the whole book is like, I don't know, 20 chapters and every chapter is more things you should cut from your writing and they show all these examples of like, here's a before and here's an after.
(00:14:18): And all these words were cut and nothing changed. They're completely necessary. So, I think that book can help and partly it's just like what is not necessary? You think all these adjectives are important. Another thing I found really helpful is the rule of thirds, I guess the rule of three, of just always having three. Try not to go beyond three when you're giving strategy bets or priorities or things like that. Just try to keep things under three.

**中文翻译:**
在你说话时，我想到了另外几件事。简化很难教，你必须反复练习。坦白说，我曾有一位经理教我如何在写作、策略文档和单页计划中进行简化。我认为这对我后来写 Newsletter 的成功有很大影响——学会尽可能地剥离一切不必要的东西。我快速分享两点：第一，我读过一本叫《金圣叹：谈写作》（*On Writing Well*，此处指威廉·津瑟的经典著作）的书，它对我写作影响极大。全书大约 20 章，每一章都在讲你应该从写作中删掉什么，并展示了大量的“修改前”和“修改后”对比。
(00:14:18): 删掉了那么多词，意思却一点没变。那些词完全是多余的。所以我觉得那本书很有帮助，它让你思考：什么是没必要的？你可能觉得那些形容词很重要，其实不然。另一件我觉得很有帮助的事是“三原则（Rule of Three）”。在提出策略赌注或优先级时，尽量不要超过三个。

---

### [00:14:44] Maggie Crowley

**English:**
Yeah, it's a very sort of business school ex-consultant point of view that I do agree with and share, which is there's always three things or fewer, never more than three things. You have to have a nice round couple and if you have a fourth, you've got to figure out how to squish it in there because it just doesn't look right if there's four.

**中文翻译:**
是的，这是一种非常典型的“商学院/前咨询顾问”观点，我非常认同。永远只有三件事或更少，绝不超过三件。你得凑成一个整齐的组合，如果你有第四件，你就得想办法把它塞进前三件里，因为如果是四件，看起来就不对劲。

---

### [00:15:02] Lenny

**English:**
Agree. Yeah, even though I've been guilty of more than three, try hard to avoid it.

**中文翻译:**
同意。虽然我也曾犯过超过三件的错，但我会努力避免。

---

### [00:15:07] Maggie Crowley

**English:**
Yeah, you're using notion and you have your three bullets expanding and there's sub bullets, but at least you have that top line.

**中文翻译:**
没错，哪怕你在用 Notion，虽然有三个大标题，下面还有展开的子标题，但至少最顶层看起来是三条。

---

### [00:15:13] Lenny

**English:**
That's right. The other thing is I think that there's just a focus you need to get good at just like, people often want to lump together a bunch of ideas and then every time you do that it just dilutes everything. So, I think there's just a lot of power and pick the thing, pick the thing that's going to have the most impact and cut other stuff that may have some impact but is much less important.

**中文翻译:**
没错。另一件事是你需要擅长“聚焦”。人们往往想把一堆想法混在一起，但每次这样做都会稀释重点。所以，选定那件事——那件影响力最大的事，并砍掉其他虽然也有点影响但没那么重要的事，这其中蕴含着巨大的力量。

---

### [00:15:31] Maggie Crowley

**English:**
I think again, simplification is something and prioritization, which is sort of the same thing, gets tossed around a lot as a thing you have to get good at, but it's really challenging. Getting to the one thing you should do is extremely difficult and being able and having the gumption to say no to all those other things is really hard, because there's probably at any given time, 10 things you should do, but you can't do 10 things, you'll never be successful if you do that in a number of things. And so you have to pick one.
(00:15:59): And so it's both figuring out how to get confident in your decision and then B, having the willingness, and maybe I should have added this to my what makes great PMs list, the willingness to make the bet and be responsible for it. And that's what I think separates the PM role from a lot of other roles and why it's such a challenging job when done right is because you have to be willing to take responsibility and it's your job to pick the thing and it's your job to be accountable to your team for picking the thing so you better get it right.

**中文翻译:**
我再次强调，简化和优先级排序（其实是一回事）经常被当作必须掌握的技能挂在嘴边，但实际操作极具挑战。找到那件“唯一该做的事”极其困难，而拥有拒绝其他所有事情的胆量（Gumption）更是难上加难。因为在任何时候，可能都有 10 件事是你“应该”做的，但你不能同时做 10 件事，否则你永远不会成功。你必须选一个。
(00:15:59): 所以这包含两方面：一是如何对自己的决定产生信心；二是（也许我该把它加入伟大 PM 的清单）愿意“下注”并为此负责。我认为这就是 PM 角色与其他角色的区别所在，也是为什么这个职位如果做得好会如此具有挑战性——因为你必须愿意承担责任，选什么是你的职责，对团队负责也是你的职责，所以你最好选对。

---

### [00:16:32] Lenny

**English:**
Ownership such an important part of just being a PM. Again, coming back to this interview I just did with an ex Amazon guy, that's one of their principles at Amazon is just leaders, basically ownership, feeling like you have ownership of what you're working on.

**中文翻译:**
“主人翁意识（Ownership）”是作为 PM 非常重要的一部分。这让我想起我刚做过的一个采访，对方是前亚马逊员工。亚马逊的原则之一就是领导力，本质上就是 Ownership，感觉你对自己所做的事情拥有所有权。

---

### [00:16:46] Maggie Crowley

**English:**
I agree, but to me at least the word ownership doesn't have the same oh shit feeling as you're making a bet. You make a bet, that means you know that there's a chance that the thing you're working on is not going to work out and you still have to be the one to do the thing, jump off the ledge, drop in on the ski run. So, ownership to me never signaled that risk that I think comes with being a PM.

**中文翻译:**
我同意，但对我来说，“Ownership”这个词没有“下注（Making a bet）”那种“噢，糟糕”的紧张感。下注意味着你知道你正在做的事情有失败的可能，但你仍然必须是那个动手的人，跳下悬崖，冲下雪道。所以，“Ownership”对我来说从未体现出我认为 PM 角色所自带的那种风险感。

---

### [00:17:10] Lenny

**English:**
Good point. On the simplify concept, it reminds me at Airbnb, one of the core values at Airbnb for time was simplify. Is this idea that we should always try to be simplifying, and then it turned out the founders realized we're not actually great at this and it's unfair for us to say this is a value for not doing it. So, they actually cut it as a core value because their feeling was we shouldn't have aspirational values, we should reflect who we actually are, and they actually cut two different values to be more clear, even though they still want to simplify, they're just like, we're not actually good at this, so why are we pretending like we are.

**中文翻译:**
很有道理。关于简化，这让我想起 Airbnb。Airbnb 曾有一段时间的核心价值观就是“简化（Simplify）”。我们的理念是应该始终尝试简化，但后来创始人意识到我们其实并不擅长这个，如果我们没做到却把它列为价值观，那是不公平的。所以他们把它从核心价值观中去掉了，因为他们觉得不应该有“愿景式”的价值观，而应该反映我们真实的样貌。为了更清晰，他们实际上砍掉了两个不同的价值观。尽管他们仍然想简化，但他们觉得：“我们其实并不擅长这个，为什么要假装擅长呢？”

---

### [00:17:54] Maggie Crowley

**English:**
I think maybe I'm good at it on paper, but there's been many times where I've been in situations where things are not simple and you just have to keep fighting for it.

**中文翻译:**
我觉得我也许在纸面上很擅长简化，但很多时候我身处的环境非常复杂，你必须不断为之奋斗。

---

### [00:18:12] Lenny

**English:**
Someone's trying to think about, okay, I want to become better as a PM and I'm going to try to start simplifying. What are examples of simplifying? Is it reduce your email length? Is it one pager focus? What are these buckets of things? And then also if there's an example of something you've simplified that comes to mind

**中文翻译:**
如果有人在想：“我想成为更好的 PM，我要开始尝试简化。”那么简化的具体例子有哪些？是缩短邮件长度？还是聚焦单页计划？有哪些类别？另外，你脑海中是否有你简化过什么的具体例子？

---

### [00:18:12] Maggie Crowley

**English:**
On what to simplify and more specifics, I would say anything can be simplified and shortened. Maybe another way to say shorten it. Definitely emails. I read them sometimes don't love them. Make them short. The Minto principle is something that I would recommend everyone do, which is put the headline, the full conclusion first and then you're supporting argument second.
(00:18:41): [Lenny mentions Minto Pyramid principle post]
(00:18:42): Yes, everyone should do that. A lot of new PMs fall into the trap of thinking that they should have some sort of buildup. Don't do that. Just tell me whatever the thing is, everyone will thank you. Doing things like that, things like you said, limiting your strategy docs, your conclusions, your next steps to three things maximum. I would generally say a rule of thumb would be pretty much every doc you write, you can delete the first two paragraphs that you've written. You don't need them. My dad, again, to go back to my dad when I would write, and this sounds cruel, but I promise it wasn't. When I would write a paper for school, he would just, and this is we didn't really have computers, whatever, he would just take away the first page and he'd be like, just start here. He would go, "Everything on the first page is crapola, don't use it."
(00:19:30): And he wouldn't even read it, which would drive me crazy. He would just like, "Oh, it's crap. I don't care about that." So, I would do that and then just get other people, there's probably somebody around you that's good and find people to edit your work and to look at it. I have a little Slack workspace that has three people in it, me and two other women who are product leaders, and we oftentimes send each other our work still and we say, "Hey, I'm struggling with this. Can you read it? Help me make it simpler. Can you help me fix this up?" And we do that for each other. So, find a peer maybe who's in a non-competitive space who can do that for you. I mean I still use those people to help me.

**中文翻译:**
关于简化的具体内容，我会说任何东西都可以被简化和缩短。缩短也许是另一种说法。绝对包括邮件。我读邮件时有时并不喜欢长篇大论。写短点。我建议每个人都学习“明托原理（Minto Principle，即金字塔原理）”，也就是先说标题和结论，然后再说支持论点。
(00:18:41): [Lenny 提到他有一篇关于金字塔原理的文章]
(00:18:42): 是的，大家都该这么做。很多新 PM 会掉进一个陷阱，觉得应该先做铺垫。别那样。直接告诉我结论，大家都会感谢你的。还有像你说的，把策略文档、结论、下一步计划限制在最多三项。我通常有一个经验法则：几乎你写的每一份文档，你都可以删掉前两段。你根本不需要它们。再说回我爸，我写学校论文时，他会（这听起来很残忍，但我保证不是）直接拿走第一页说：“从这儿开始写。”他会说：“第一页全是废话，别用。”
(00:19:30): 他甚至读都不读，这让我抓狂。他会说：“噢，那是垃圾，我不在乎。”所以我建议你也这么做，然后找别人帮你。你身边肯定有厉害的人，找他们帮你编辑、审阅。我有一个小的 Slack 工作区，里面只有三个人：我和另外两位女性产品领导者。我们现在还经常互相发送工作内容，说：“嘿，我在这件事上很纠结，你能读读吗？帮我简化一下，帮我修改一下。”我们互相帮助。所以，找一个可能处于非竞争领域的同行来帮你。我到现在还在靠这些人帮我。

---

### [00:20:10] Lenny

**English:**
That is extremely cool. Can you talk more about this group that you have?

**中文翻译:**
这太酷了。你能多聊聊你这个小组吗？

---

### [00:20:15] Maggie Crowley

**English:**
Yeah, I don't know if it's a group. It's like three friends. Shout out Alexa and Daphne. Yeah, I mean the three of us all worked together when we were at Drift. We've stayed in touch and I've just found that in order to be good at your job continuously, you need people who can help give you feedback, and the more senior you get, the harder that is. And so having people who can give you another point of view who maybe you can vent to if it's not appropriate as a leader who can give you other experiences that they're going through has been incredibly valuable. And so we just have a little group chat that is focused on product.

**中文翻译:**
是的，我不知道这算不算一个“小组”，更像是三个朋友。向 Alexa 和 Daphne 致敬。我们三个在 Drift 共事过。我们一直保持联系，我发现为了能持续做好工作，你需要能给你反馈的人，而且你职位越高，获得反馈就越难。所以，拥有能提供不同视角、能让你在不方便向团队发泄时倾诉、能分享他们正在经历的其他经验的人，是非常宝贵的。所以我们有一个专注于产品的小群聊。

---

### [00:20:49] Lenny

**English:**
That is so cool. Is there a tip you could share for someone that wants to create something like this? Is it important for you to have worked with them before? Is Slack a good way to communicate? Anything there that's just like, oh yeah, here's a cool tip.

**中文翻译:**
太棒了。对于想建立这种小组的人，你有什么建议吗？以前共事过重要吗？Slack 是个好的沟通方式吗？有没有什么“酷技巧”？

---

### [00:21:00] Maggie Crowley

**English:**
Slack just worked for us where we are during the day, and I think having easy access to it was important. You could probably use WhatsApp or a literal group text. There are small community, there's one, I worked in healthcare for a year and a bit, and there's a Slack community that somebody organized for heads of products and healthcare startups that is similar to those really, really powerful and a really great space to be in. And so you just have to kind of suss out where these things are. You work with amazing people and there's people around you who are going to become your friends, and so keep an eye out for them and keep in touch with them when you leave a job because you never know when they might become your little Slack workspace.

**中文翻译:**
Slack 对我们很合适，因为我们白天都在用，随时能点开很重要。你也可以用 WhatsApp 或者直接发短信群聊。还有一些小的社区，比如我曾在医疗行业工作过一年多，有人为医疗初创公司的产品负责人组织了一个 Slack 社区，非常强大，是个很棒的空间。所以你得去发掘这些资源。你会和很多优秀的人共事，你身边的人可能会成为你的朋友，所以要留意他们，离职后也要保持联系，因为你永远不知道什么时候他们会成为你那个小小的 Slack 工作区伙伴。

---

### [00:21:39] Lenny

**English:**
Oh, I love it. Okay, I'm glad we talked on that. Okay, back on track. The second bucket you described as following up on results, is it just do that. Is there anything more you can add there?

**中文翻译:**
太棒了。好，回到正题。你提到的第二个类别是“跟进结果”，就是字面意思上的“去做”吗？还有什么补充的吗？

---

### [00:21:49] Maggie Crowley

**English:**
I put reminders in my calendar. I mean, yeah, it's just do that. But if you're launching a product, usually you release something and you have that initial push of a couple of weeks where you're finding bugs and you're maybe you're pulling metrics and everyone remembers it, then I would remember two weeks after that, a month after that, six months after that, put a reminder in your calendar to check your dashboard or check the metrics or check whatever it is that you were doing, and you won't forget and then share them with whoever might care about it. And it's as simple as that.

**中文翻译:**
我会往日历里加提醒。我的意思是，是的，就是去做。但如果你发布一个产品，通常发布后的头几周你会忙着找 Bug、拉指标，大家还都记得这件事。但我会记得在两周后、一个月后、半年后，在日历里设个提醒去检查仪表盘，或者检查指标，或者检查你当时做的任何事。这样你就不会忘，然后把结果分享给可能关心的人。就这么简单。

---

### [00:22:20] Lenny

**English:**
And is the reason this is one of the three things you think are most consistent across great PMs, that it helps your manager see you like, wow, Maggie's so on top of everything, or is it more that you learn from that experience and drive more impact or is it both?

**中文翻译:**
你认为这是伟大 PM 身上最一致的三件事之一，是因为这能让你的经理觉得“哇，Maggie 掌控了一切”，还是因为你能从经验中学习并产生更大影响？还是两者兼有？

---

### [00:22:36] Maggie Crowley

**English:**
It's definitely both. I'm not going to pretend like if you're just great at your job quietly that you're going to get what you want. Just if you're toiling in the background, doing a great job getting results. If you have a great manager, maybe you'll be successful. Great managers are few and far between, and I am of the opinion that I never wanted to rely on someone else to get what I wanted. And so I would always make sure to share that, always make sure to share my progress because I didn't want to leave it up to chance that someone would notice. So, I would suggest doing it for both reasons. And that's one of those things that people want to pretend that everything's perfect and we're all great and we're always going to get what we want and always going to get that promotion, but you have to work for it.

**中文翻译:**
绝对是两者兼有。我不会假装只要你默默地把工作做好就能得到你想要的。如果你只是在后台埋头苦干，拿出了好结果，如果你碰巧有个伟大的经理，也许你会成功。但伟大的经理凤毛麟角，我的观点是，我从不想依靠别人来获得我想要的东西。所以我总是确保分享结果，确保分享我的进度，因为我不想把“被人注意到”这件事留给运气。所以我建议出于这两个原因去做。人们总想假装一切都很完美，我们都很优秀，总能得到想要的晋升，但你必须为此努力。

---

### [00:23:22] Lenny

**English:**
I love that point. It reminds me what I find one of the most important traits of a great product manager is they create this aura that they've got this, they put something on their plate and they're not going to drop it, that the threads are not going to be forgotten. And this connects to me there. They feel like Maggie's going to tell me what happened with this experiment. I don't have to think about it as a manager.

**中文翻译:**
我喜欢这一点。这让我想起，我认为伟大 PM 最重要的特质之一是他们能营造出一种“一切尽在掌握”的气场。他们接手了一件事，就不会让它掉在地上，也不会忘记任何线索。这和我刚才想的一样：作为经理，我觉得 Maggie 会告诉我这个实验的结果，我不需要操心。

---

### [00:23:45] Maggie Crowley

**English:**
Yeah, that's a really good point. And then you mentioned this a little bit ago, the side benefit is that you learn more. You will go back and learn why something happened or why it didn't happen, and the more that you follow up on what you've been doing and the more you learn, the better you get every time you ship something. To me, the other answer of what makes a great PM is family shipped a lot of stuff. The more you ship, the more you learn. And that's why it can take years to build up expertise because you just have to ship a lot of stuff.

**中文翻译:**
是的，非常有道理。而且你刚才也提到了，副作用是你学到了更多。你会回头去研究为什么某件事发生了，或者为什么没发生。你跟进得越多，学到的就越多，每次发布产品你都会变得更强。对我来说，衡量伟大 PM 的另一个标准是他们发布过很多东西。发布得越多，学得越多。这就是为什么建立专业知识需要很多年，因为你必须发布大量的东西。

---

### [00:24:19] Lenny

**English:**
There's a lot of people that are always frustrated. They're not getting promoted quickly enough as a PM. They're not moving off the ladder like, oh my god, I've been a PM for two years. I'm not a senior PM yet. Can you speak more to just that thought and just how long it takes to get actually good? I guess I'll share briefly in my experience, it took me four years to actually know what the hell I was doing as a PM and then things started to really take off. What's your experience?

**中文翻译:**
很多人总是感到沮丧，觉得作为 PM 晋升不够快。他们会说：“天哪，我已经做了两年 PM 了，还没当上高级 PM。”你能聊聊这种想法吗？到底需要多久才能真正变得优秀？我简单分享一下我的经验：我花了四年时间才真正搞清楚作为 PM 到底在干嘛，然后事业才真正开始起飞。你的经历呢？

---

### [00:24:40] Maggie Crowley

**English:**
I would say similarly, it took a lot of years to feel confident that I knew what I was doing. My first PM job was a product management rotation job at TripAdvisor. I had no PM background. It was after business school and I left those two years thinking, yeah, I've worked on four different teams over the two years. I've shipped all this stuff, I'm good. Went to a startup, there was another product person there, they left and I was the only product person at the startup. And I realized really quickly, I had no idea what I was doing. I had no one to learn from. I had only had two years of experience and I was not ready for that job. I didn't feel confident in the decisions I was making. That's why I joined Drift is because that team had all these really incredible product thinkers on it and they were shipping all sorts of stuff. They had all this momentum and I thought, okay, that's where I'm going to go to learn.
(00:25:29): And so then two more years. So, that's five years until I really felt like I knew what I was doing. And that's because it takes a long time to ship stuff. And so to people who want to progress, you can progress by job hopping, you can progress by going in and out of startups. But to me staying at that, when I was at Drip, I was there for almost four years. I got to see two or three cycles of the same product and I learned more from that than I did out of the year or so I spent doing other things each at a time because you got to see the consequences of your decisions and that's rare. And people, myself included, of course you want to get promoted, of course you want to move up. I'm ambitious. Lots of people are ambitious, but for better or for worse, spending the time is really helpful and I think allowed me to move faster later because I had just spent the time grinding it out for a while in order to be better later.

**中文翻译:**
我也差不多。花了很多年才感到有信心知道自己在做什么。我的第一份 PM 工作是在 TripAdvisor 的产品管理轮岗。我没有 PM 背景，那是商学院毕业后的事。两年后我离开时想：“我在四个不同的团队工作过，发布了这么多东西，我很厉害了。”然后我去了一家初创公司，那里本来还有另一个产品人员，但他走了，我成了唯一的 PM。我很快意识到，我根本不知道自己在做什么。我没有人可以学习，我只有两年经验，我还没准备好胜任那份工作。我对自己的决定没有信心。这就是为什么我后来加入了 Drift，因为那个团队有很多不可思议的产品思想家，他们发布各种东西，势头强劲，我想：“好，那是我该去学习的地方。”
(00:25:29): 然后又过了两年。所以一共是五年，我才真正觉得我入门了。这是因为发布东西需要很长时间。对于那些想要进步的人，你可以通过跳槽来晋升，可以通过进出初创公司来晋升。但对我来说，在 Drift 待了将近四年的经历非常宝贵。我看到了同一个产品的两三个周期，我从中学习到的比我之前每年换一件事做学到的要多得多，因为你能看到自己决定的后果，这很罕见。包括我在内，大家当然都想晋升，想往上走。我有野心，很多人都有野心。但无论好坏，花时间沉淀是非常有帮助的。我认为这让我后来跑得更快，因为我曾花时间磨练，为了以后变得更好。

---

### [00:26:31] Lenny

**English:**
So, is that advice you often give of go deep into a company or a product versus just bounce and track a bunch of different companies or depends?

**中文翻译:**
所以你经常给出的建议是“深耕一家公司或一个产品”，而不是“在不同公司之间跳来跳去”吗？还是说视情况而定？

---

### [00:26:39] Maggie Crowley

**English:**
It depends. There are lots of really good reasons to bounce. I've done it, many people have done it, but I was surprised at how much I value that experience of having stuck around for a while and how much I learned from it was something I hadn't expected going into it, especially because you don't hear that point of view as much or as I wasn't hearing that point of view as much when I was thinking about the sort of arc of my career, but I'm glad that I did it. And then of course people always want to get promoted, always ask that question and my answer is always create impact and that can take time.

**中文翻译:**
视情况而定。跳槽有很多正当理由，我也跳过，很多人都跳过。但我惊讶于我竟然如此看重那段“待了一段时间”的经历，从中学习到的东西超出了我的预期。特别是因为当你规划职业生涯曲线时，不常听到这种观点，但我很高兴我这么做了。当然，人们总想晋升，总问这个问题，而我的回答永远是：创造影响力，而这需要时间。

---

### [00:27:16] Lenny

**English:**
At my first job, I was there for nine years and then I started a company for a year and a half and then we sold to Airbnb, and then I was at Airbnb for seven years. So, I'm very much on that train of just, not that I intended for that to happen, but I definitely went deep and I think there's pros and cons, but there's so many pros to that, so many reasons. Okay. Let's talk about the last part, which is the third point you made, which is carrying the water, I think is how you described it.

**中文翻译:**
我的第一份工作待了九年，然后创业了一年半，公司卖给了 Airbnb，接着我在 Airbnb 待了七年。所以我非常认同这种方式。虽然不是刻意为之，但我确实深耕了。我认为这有利有弊，但利大于弊。好，让我们聊聊最后一部分，也就是你提到的第三点：“挑水（Carrying the water）”。

---

### [00:27:42] Maggie Crowley

**English:**
Yeah. This one, there's no tips and tricks. It's just do the work. If you ever find yourself saying something like, that's not my job, that's probably a thing you should do. And you know what? It probably isn't your job and it probably is someone else's job and you can spend your life getting frustrated at that or you can just get over and get the work done. And people who are willing to just get the work done will move faster, their products will be more successful and they probably aren't carrying around all that anger and crappy emotion.
(00:28:17): Because we touched on this earlier as a PM for better or for worse, and maybe this is not how we all want it to be, but you're oftentimes the emotional center of the team and it's your job to keep people motivated, keep people excited, keep them bought into the project, and you just have to keep that optimism going. And it's hard work. It's really hard work to stay positive and to keep people amped for that thing. And part of it can be just like, you know what? Let me take that on. Let me grab that, whatever. I'll do this thing. I'll hop on this sales call, I'll implement this with the customer. You just have to do whatever it takes.

**中文翻译:**
是的。这一点没什么秘诀，就是“去干活”。如果你发现自己说“那不是我的工作”，那可能就是你该做的。而且你知道吗？那确实可能不是你的活，确实是别人的活，你可以一辈子为此生气，或者你可以直接把它干完。愿意直接干活的人会跑得更快，他们的产品会更成功，而且他们可能不会带着满身怨气。
(00:28:17): 因为我们之前提到过，作为 PM，无论好坏，你通常是团队的情感中心。你的职责是让大家保持动力、兴奋并认同项目。你必须维持那种乐观。这是苦差事，保持积极并让大家为之振奋真的很难。其中一部分就是：“你知道吗？让我来承担吧。我来搞定。我参加这个销售电话，我来帮客户实施。”你必须不惜一切代价。

---

### [00:28:55] Lenny

**English:**
It reminds me of one of your lessons that you shared, in one of your podcast episodes. It was one of your PM lessons of 2021, and the lesson was, when in doubt it's your job as a PM, which I think relates very much to which it just shared. Can you speak to that?

**中文翻译:**
这让我想起你在播客里分享过的一个教训。那是你 2021 年的 PM 教训之一，内容是：“如有疑问，那就是你作为 PM 的职责。”我觉得这和你刚才分享的非常相关。你能谈谈吗？

---

### [00:29:12] Maggie Crowley

**English:**
It might actually make sense to put this in the context of the other roles that are part of the team. So, as an engineer, your job is to write the code to really reduce this down and build the thing and make it work to spec. As a designer, maybe your job is to design the thing, design the solution, design the user experience. Obviously there's lots more complexity in that role. Design your amazing engineering, your amazing TLDR, caveat, whatever. But as a PM, you don't have that thing, right?
(00:29:41): It's not like, oh, my job is just to write the one-pager. That's not true. Your job isn't just to pick the problem. Your job is to deliver a business result. And so you're uniquely positioned to have to fill in all the gaps because no one else is incentivized to do that. As an engineer, you can finish your work and hand it off and say, I did it, and the good ones care, but you don't have to care. As a PM, you're not going to do your job unless that problem gets solved for the customer or the user at the end of the day. And so your job is to make sure everything happens for that product.

**中文翻译:**
把这个放在团队其他角色的背景下看可能更有意义。作为工程师，你的职责是写代码，把东西造出来并符合规格。作为设计师，你的职责是设计产品、设计方案、设计用户体验。当然，这些角色也有很多复杂性。但作为 PM，你没有那种“具体的产出物”，对吧？
(00:29:41): 并不是说“哦，我的工作只是写个单页文档”。不是这样的。你的工作也不仅仅是挑选问题。你的职责是交付业务结果。因此，你处于一个独特的位置，必须填补所有的空白，因为没有其他人有动力去做这些。作为工程师，你可以完成工作并移交，然后说“我做完了”。优秀的工程师会关心后续，但你并不是非关心不可。而作为 PM，除非问题最终为客户或用户解决了，否则你就不算完成了工作。所以你的职责是确保产品相关的一切都能顺利发生。

---

### [00:30:17] Lenny

**English:**
It reminds me of another interview you did where you talked about how a lot of the PM job sucks. It's not as glamorous as people often think, and most of the job is these really boring, annoying things. I guess, is there anything you want to add there of just a lot of people want to get into PM, they're like, oh, I'm going to run the show. It's going to be so great. I'm going to be a product manager and tell people what to do. But that's not how it is.

**中文翻译:**
这让我想起你在另一次采访中提到的，PM 的很多工作其实很糟糕。它不像人们想象的那么光鲜亮丽，大部分工作都是这些非常无聊、烦人的事情。很多人想进这一行，觉得“哦，我要掌控全局，太棒了，我要当产品经理指挥别人干活”。但事实并非如此。

---

### [00:30:41] Maggie Crowley

**English:**
It's just one of those things that people, and when I joined product, it was just sort of becoming a cool job. It wasn't the hot job on campus when I was in business school. That was more private equity, venture capital. And now there's a sense of cachet around it. But again, it comes back to that earlier point, which is you do get to do cool stuff. You get to decide what gets built. That's cool. You have a lot of ownership like we talked about. You could see it as you have a lot of power, but at the same time you're responsible.
(00:31:12): And so with that comes this responsibility to get it right, to make the right bets, ship the right products, get them out the door. And so there's a lot of bullshit work you have to do. Again, project management is one everyone hates on. QA is a really good one. You should QA your products. That's great if you have a QA team, you should QA them. You should know how they work. You should implement with your customers, you should be able to sell them, you should be able to find users. All that stuff is stuff that you should be able to do, and none of it is above you.

**中文翻译:**
当我进入产品领域时，它才刚刚开始变成一个“酷”职业。我在商学院时，校园里最火的工作是私募股权和风险投资。现在它有了一种光环。但话说回来，你确实能做一些酷的事，比如决定建造什么。这很酷，你拥有很大的所有权。你可以把它看作拥有很大的权力，但同时你也承担着责任。
(00:31:12): 随之而来的是确保做对、下对注、发布对的产品并把它们推向市场的责任。所以有很多琐碎的破事（Bullshit work）要做。项目管理是大家都讨厌的一项。QA（质量保证/测试）也是一个很好的例子。你应该亲自测试你的产品。即使你有 QA 团队，你也应该亲自测。你应该知道它们是怎么运作的。你应该和客户一起实施，你应该能卖出产品，你应该能找到用户。所有这些都是你应该能做的事，没有哪样是“高人一等”而不屑于做的。

---

### [00:31:42] Lenny

**English:**
If someone is listening and they're not a PM and they are not convinced to not get into product manager, they still want to become a PM, what is your best advice for selling that is trying to get into product management of how to actually break into product management?

**中文翻译:**
如果有人在听，他现在还不是 PM，而且听了这些也没被劝退，还是想当 PM。那么对于如何真正进入产品管理领域，你最好的建议是什么？

---

### [00:31:55] Maggie Crowley

**English:**
I thought about this one a lot and I consulted the Slack workspace team. Because it's been a long time since I've tried to get into product. And so I didn't know what was going on these days because it's hard and I don't know if things have changed. I went to business school and that's how I got in. There was a program that took MBA students. I think there are some entry-level programs out there, big tech companies, if you can get them, I think they're really hard to get because they're very few and far between. And so the most common two paths that I've seen are people who switched laterally within a company. Again, challenging but can be done. Or people who joined startups. So, when I was at my last startup, I did hire someone who was coming out of business school who hadn't been into product into a PM role. And I can't say I wouldn't do it because it was awesome and she was amazing, but it takes a lot of work.
(00:32:49): The reason why people don't do it is because as a manager, it takes a lot of work because there's so much that these people need to learn. And what we ended up doing is she and I spent four months working together in a WeWork in person to help her onboard really quickly into the role, which was so rewarding. And I loved every second of it, and I wish I could do that again and again and again. But to get that, she basically just hounded me. Christina, if you're listening, you emailed me a lot. We talked a lot and we waited until the time was right and then you finally convinced me to do it. So, I don't know. I don't if there's a reliable path that I can say this is what my advice would be other than try a startup network. See what you can do.

**中文翻译:**
我思考了很久，还咨询了我的 Slack 小组。因为我已经很久没尝试“进入”产品圈了，不知道现在行情如何。我是通过商学院进去的，当时有一个招收 MBA 学生的产品项目。大科技公司有一些入门级项目（APM），但名额极少，很难进。我见过的最常见的两条路径是：一是在公司内部转岗，虽然有挑战但可行；二是加入初创公司。我在上一家初创公司时，确实招过一个刚从商学院毕业、没做过产品的 PM。我不能说我以后不会这么做，因为那次经历很棒，她非常出色，但这需要投入大量精力。
(00:32:49): 经理们不愿意招新人的原因是带人太累了，新人要学的东西太多。当时我和她在 WeWork 面对面共事了四个月，帮她快速上手。那段经历非常有成就感，我热爱其中的每一秒，我希望我能一遍又一遍地这样做。但为了得到那个机会，她基本上一直在“缠着”我。Christina，如果你在听，你当时给我发了很多邮件。我们聊了很多，等到时机成熟，你终于说服了我。所以，我不知道有没有什么“可靠”的路径，除了尝试初创公司、建立人脉，看看你能做些什么。

---

### [00:33:33] Lenny

**English:**
And you've made up this point elsewhere, which I think is an additional key piece is once you have a PM title on your resume, everything gets easier. As a hiring manager, I'm just like, I look at a resume like, oh, they've never been a PM. This isn't the role. It's rarely that someone wants someone that's never been a PM.

**中文翻译:**
你在别处也提到过一点，我觉得这是另一个关键：一旦你的简历上有了“产品经理”这个头衔，一切都会变得容易。作为招聘经理，我看到一份简历，如果上面写着“从未做过 PM”，我就会觉得这不合适。很少有人愿意招一个从未做过 PM 的人。

---

### [00:33:51] Maggie Crowley

**English:**
Yeah. And I tell people, I do unsurprisingly talk to lots of people who either are in product or want to be in product. And that's one of the things I always tell them because if they're deciding between roles and they have an opportunity to do something, and my advice is always, if you can get someone to stamp you with the product manager role, take it. Because to your point, it's what we screen on. It's for better or for worse, it's just like you have to get that first job. And then once you get that first job, it all gets easier. You can get in and then you can talk about your experience because then the second question I have is, what have you shipped? So, it's like, have you been at PM before? What have you shipped? And it's fascinating how quickly people can't answer that question. And the people who can are always several steps ahead of the people.

**中文翻译:**
是的。我经常和那些在做产品或想做产品的人聊天。我总是告诉他们：如果你在几个职位间犹豫，而其中一个能给你盖上“产品经理”的戳，那就选它。因为正如你所说，这就是我们筛选的标准。无论好坏，你必须拿到第一份工作。一旦有了第一份，后面就容易了。进去之后，你就可以谈论你的经验了。因为我的第二个问题通常是：“你发布过什么？”这很有趣，很多人答不上来。而那些能答上来的人，总是比别人领先好几步。

---

### [00:34:36] Lenny

**English:**
Let's shift topics and talk about product strategy. Many people are told you need to get better product strategy. You're not great at strategy. A lot of people are also just confused, what is strategy? How do I get better at strategy? How do we describe a strategy? And you have a really great explanation and overview of how to think about this stuff. So, I'd love to hear your take on just how do you actually write out and describe a strategy.

**中文翻译:**
让我们换个话题，聊聊产品策略。很多人被告知“你需要提高产品策略能力”或者“你不擅长策略”。很多人也很困惑：什么是策略？我该如何提高？我们该如何描述策略？你对这些东西有一套非常棒的解释和思考框架。我很想听听你的看法：到底该如何写出一份并描述一份策略？

---

### [00:35:04] Maggie Crowley

**English:**
Sure, yeah. And another thing that happens, and I'll give the outline, but another thing I hear, especially as you get further in your career, and unfortunately if you're maybe an underrepresented person in tech, is that you need to be more strategic. And so that's feedback that almost always happens, especially if you're a woman in product, in tech who's knocking at the door of a leadership role. You've probably gotten that feedback. And so I made it my mission to figure out what the heck is this thing? How do I do it? How can I do it in a way that is demonstrable so that I'm never getting that feedback that's like, oh, she's not strategic. And so what I did was something that I kind of did in the background because I had an engineer who I worked with who really wanted to understand why we were doing what we were doing, and he was not satisfied with sort of a surface level answer.
(00:35:57): And he was just pushing and pushing and pushing. And so what I did was I just wrote out a Google doc and I started with like, okay, and not fancy, these are just bullets. What is the mission? What is the point of the company? What are our goals? Maybe we have some sort of high level framing of what we're working on. And then I had this big section that was just the landscape. And in that section I put in what's going on with our business? What's happening with our products? What's our point of view on the market? Who are our competitors? A SWOT analysis, key risks that we might be facing. Just dump that all on paper. Then what are the current quarters business goals or however you do planning, what are the current things that your company's working on? Then I put in, all right, that's sort of the context that we're operating in.
(00:36:44): Then I wanted to understand where are we. So what is an honest accounting of the current state of your product, the business overall, and then the specific area that you're working in. What works, what doesn't work? What are your customers saying? Bottoms up feedback, users, customers, teams, what are your support tickets? Get that all out on paper. And then really importantly, where are your technical hurdles? What are the big pieces of tech debt? What are your engineering and technical teams always harping on that they want to invest in? Are there some big things coming down the pipe that you need to think about? Just get everything on paper. And then usually in the process of writing all that down, you'll start to see, okay, I kind of get where we are. I kind of get what the challenge is. And then you write a section that's like, what's the opportunity?
(00:37:34): From all of that, what's going to bubble up as the top one or two opportunities for your team? Where do you want to play? Where can you win? Where's the unique? Based on your unique competitive advantage, where do you think you all should be and why? And then based on that opportunity, what are the challenges? So, what's going to be the hardest about taking advantage of that? What has to be, another way to frame it is what has to be true about the world for that to work? That's a one that's been helpful. And then what would you do? Take a swing at writing down your solution, what you would need to build, how might it work? Anything that you have, this is where I would say three bullets, maybe what you might want to do and then a plan. If no one else had an opinion, how would you go about it?
(00:38:26): How would you sequence it? What would you do? How might you get the team to work on it? What would your team have to look like? How much would it cost to do it? All that you can start to layer in all that kind of stuff. And then I just share the doc. Share it with everybody. There should not be any secret. And you should be able to walk all the way from your company's mission down to the individual priority on your team and see the logic chain and why you got there. And if anyone doesn't agree with it, they can call out where their disagreement lands in that landscape. But at least then you've put everything on paper, you understand how you got to where you're going, and then you can have an argument about the different pieces and points of data and feedback that you're getting, but at least people understand how you got where you got. And then it doesn't become like, I don't agree with you. It becomes, I don't agree with this point.

**中文翻译:**
当然。我会给出一个大纲。但我想先说，随着你职业生涯的发展，你经常会听到“你需要更有战略眼光”这种反馈。不幸的是，如果你是科技圈的少数群体，比如女性，当你敲开领导层大门时，几乎总会得到这种反馈。所以我把搞清楚“这到底是什么鬼”当作我的使命。我该怎么做？我该如何以一种可证明的方式来做，这样我就再也不会听到“她没有战略眼光”这种评价了？
(00:35:57): 我当时共事的一位工程师非常想知道我们为什么要这么做，他不满足于表面答案。他一直在追问。于是我写了一份 Google 文档，不花哨，全是列表。首先是：**使命（Mission）**是什么？公司的意义是什么？我们的目标是什么？我们正在做的事情的高层框架是什么？接着是一个大章节：**现状景观（Landscape）**。在这里我写下：我们的业务状况如何？我们的产品现状如何？我们对市场的看法是什么？我们的竞争对手是谁？做一个 SWOT 分析，列出我们可能面临的关键风险。把这些全部写在纸上。然后是：当前季度的业务目标是什么？或者你们公司是如何做规划的，目前正在推进哪些事？好，这就是我们运作的背景。
(00:36:44): 接着我想了解：**我们在哪儿？** 对你的产品、整体业务以及你负责的具体领域做一个诚实的现状评估。什么有效，什么无效？客户在说什么？自下而上的反馈、用户、客户、团队、支持工单，全部写下来。然后非常重要的一点：**技术障碍（Technical hurdles）**在哪儿？有哪些重大的技术债？工程和技术团队一直嚷嚷着想投入的是什么？未来有什么需要考虑的大动作？全部写下来。通常在写完这些的过程中，你会开始发现：“好吧，我大概知道我们在哪儿了，也知道挑战是什么了。”然后你写一个章节：**机会（Opportunity）**是什么？
(00:37:34): 从所有这些信息中，哪一两个机会会脱颖而出？你想在哪里发力？你在哪里能赢？基于你们独特的竞争优势，你认为你们应该处于什么位置，为什么？接着，基于这个机会，**挑战（Challenges）**是什么？利用这个机会最难的地方在哪儿？或者换个问法：为了让这个方案奏效，世界上必须有哪些条件成立？这很有帮助。最后：**你会怎么做？** 尝试写下你的解决方案，你需要建造什么，它如何运作？这里我会用三个要点，写下你想做的事，然后是**计划（Plan）**。如果没有人干预，你会如何推进？
(00:38:26): 你会如何安排优先级？你会做什么？如何让团队参与进来？你的团队需要长什么样？成本是多少？你可以开始把这些内容分层加入。然后，我直接分享这份文档。分享给所有人。不应该有任何秘密。你应该能够从公司的使命一直推导到团队的个人优先级，并看到其中的逻辑链条。如果有人不同意，他们可以指出在这个“现状景观”中，他们的分歧点在哪里。但至少你已经把一切都写下来了，你理解了你是如何走到这一步的。然后你们可以针对不同的数据点或反馈进行争论，但至少大家明白你的推导过程。这样争论就不再是“我不同意你”，而是“我不同意这个具体点”。

---

### [00:39:18] Lenny

**English:**
This is such a cool way of doing it. By the way, is there a template that we can point people to that has this sort of-

**中文翻译:**
这种方法太酷了。顺便问一下，有没有什么模板可以推荐给大家？

---

### [00:39:23] Maggie Crowley

**English:**
There's not, I've only ever done it in a loose Google doc and then it just grows and changes. I can maybe try to write up those bullets, but it's just like I just make headers and then I just start dumping content in it.

**中文翻译:**
没有模板。我一直是在一份松散的 Google 文档里写的，然后它就不断生长和变化。我也许可以试着把那些要点写出来，但其实我就是先写好标题，然后开始往里填内容。

---

### [00:39:36] Lenny

**English:**
Yes, that's all people need. If you end up creating that before this comes out, we'll throw it in the show notes. And if not, people can just bother you on Twitter and ask Maggie, where's that template that we talked about?

**中文翻译:**
是的，大家需要的就是这个。如果你在节目播出前做出来了，我们就把它放进节目介绍里。如果没有，大家可以在 Twitter 上骚扰你，问：“Maggie，我们聊过的那个模板在哪儿？”

---

### [00:39:44] Maggie Crowley

**English:**
Yeah, I'm happy to write it on a piece of paper and take a photo of it and send it around.

**中文翻译:**
没问题，我很乐意把它写在纸上，拍张照发给大家。

---

### [00:39:49] Lenny

**English:**
There you go. Just make it really grainy and an artifact. We found Maggie's template. This is awesome. So, I've never heard of a version of this with so much depth into the landscape, and I think that's so smart because so much of conflict and disagreement comes from you just don't have the same information or the manager, exec or whatever doesn't think you have the information. So, if you just lean into, here's everything that I know and here's what's happening, and if you disagree with this goal, tell me, and then it'll change the plan.

**中文翻译:**
太好了。就把它弄得像个古董文物一样，“我们找到了 Maggie 的模板”。这太棒了。我从未听过有人在“现状景观”上做得这么深，我觉得这非常聪明。因为很多冲突和分歧都源于信息不对称，或者经理、高管觉得你掌握的信息不够。所以，如果你直接亮出“这就是我所知道的一切，这就是正在发生的事”，如果你不同意这个目标，请告诉我，然后我们会调整计划。

---

### [00:40:17] Maggie Crowley

**English:**
Right.

**中文翻译:**
没错。

---

### [00:40:18] Lenny

**English:**
And yeah.

**中文翻译:**
是的。

---

### [00:40:18] Maggie Crowley

**English:**
Part of it's also that typically speaking, when you're doing a strategy, you're doing it at a higher level. So, I don't think every product needs a strategy. Every feature doesn't need a strategy for example, you don't need to do this if you're working on a tiny slice of a product and you have user feedback, don't overcomplicate it, just do the stuff that makes sense. But especially as I've gotten more senior in my career, the questions are bigger and the impact is broader and the timelines are longer. And honestly, it was also because I wanted to get it right. I didn't want to make a bet on something and put a bunch of resources against a problem and get it wrong. And so this was also homework that I wanted to do for myself to know that I was going to do the right thing. For some reason, I'm always paranoid that other people have more information or doing it better than I'm doing it.
(00:41:11): So, I was like, okay, I have to write it all down and then make sure I got it right and share it with everyone and make sure that they agreed with me so that I didn't screw this thing up. And it just was such a useful exercise that I kept doing it. And of course people don't read it. People only read a tiny section. You'll run into the same problems you run in with everything else, but at least I knew that I had done the work and if people cared to engage with it was there.

**中文翻译:**
部分原因也是，通常当你制定策略时，你是在更高层面上进行的。我不认为每个产品都需要策略。比如，每个功能并不都需要策略。如果你只是在做一个产品的一小部分，并且有用户反馈，那就别把它复杂化，做该做的事就行。但随着我职位的提升，问题变得更大，影响更广，时间线更长。坦白说，这也是因为我想做对。我不想在一个问题上押注并投入大量资源，最后却发现错了。所以这也是我为自己做的功课，以确保我在做正确的事。出于某种原因，我总担心别人掌握的信息比我多，或者做得比我好。
(00:41:11): 所以我想：“好吧，我得把一切都写下来，确保我弄对了，然后分享给所有人，确保他们同意我的看法，这样我就不会搞砸了。”这成了一个非常有用的练习，所以我一直坚持做。当然，人们不会读完它。他们只读一小部分。你会遇到和其他事情一样的沟通问题，但至少我知道我做了功课，如果有人想深入了解，东西就在那儿。

---

### [00:41:33] Lenny

**English:**
So, along those lines, I was going to actually ask, how long do you find this should be depending either on the timescale, say you're doing a quarterly strategy or a year, how many pages should this doc be as any guide?

**中文翻译:**
顺着这个话题，我想问，根据时间跨度的不同（比如季度策略或年度策略），你觉得这份文档应该有多长？有没有什么页数建议？

---

### [00:41:46] Maggie Crowley

**English:**
It's long. It gets real long.

**中文翻译:**
很长。会变得非常长。

---

### [00:41:48] Lenny

**English:**
What is long?

**中文翻译:**
“长”是指多少？

---

### [00:41:53] Maggie Crowley

**English:**
The actual content, I end up writing a summary to go back to the Minto principle. I end up doing the whole thing, then putting a summary at the top so that there's one, within the first, above the fold, if you will. You can kind of get the point and the suggestion on what I think we should do or what the strategy should be, should be customizable in that section. But it can go 20 pages just because if you really want to get deep in a competitor or there's interesting market dynamics, interesting technological changes that are happening. Sometimes I'm screenshotting other companies marketing websites and dumping that in there. And that might be some interesting comments. So, it doesn't have to just be words or it can be all kinds of different things that you might want to put in there.

**中文翻译:**
实际内容方面，我最后会写一个摘要（回到金字塔原理）。我会写完整个文档，然后在顶部放一个摘要，这样在“首屏”（Above the fold）就能看到重点。关于我认为该做什么或策略是什么的建议都在那一节。但文档可能会达到 20 页，因为如果你真的想深入研究竞争对手、有趣的市场动态或正在发生的技术变革，内容就会很多。有时我会截取其他公司营销网站的图放进去，并加上评论。所以它不一定全是文字，可以包含各种你想放进去的东西。

---

### [00:42:58] Lenny

**English:**
And you made the point that it's not like you expect people to read this whole thing. There's the summary that gives them a conclusion and in theory if they want to really dig into it, they can. But I guess how do you find that balance of writing everything and making it so long that no one's ever going to read it to like this is actually going to be useful to someone and plus here's a summary.

**中文翻译:**
你提到过，你并不指望大家读完整个文档。摘要给出了结论，理论上如果他们想深挖，他们可以去读。但你如何平衡“写下所有内容导致太长没人读”和“确保它对某人有用”这两者呢？

---

### [00:42:58] Maggie Crowley

**English:**
It comes back to the reason why I write the document in the first place. And that's for me. So, it's my homework to do my job effectively. I just make sure to share it. And I find that my, especially my engineering and design counterparts, if you're working in a true triad, will almost always engage really deeply on the doc because they're pretty much also on the line and they want to make sure that when they sign their teams up to do whatever it is that they believe in the thing that you're working on.
(00:43:28): And so I find that those people will engage pretty deeply. Sometimes you'll have more junior folks on the team that'll just be interested and they'll get really into it too. And then there's some people that'll skim the upfront part and either say, yeah, that looks great, or You're dumb, I hate this. And okay, sure. There's always those people. So, it never really mattered to me that people read the whole thing. It was more I knew I had to do it to be confident in my own decisions and then I could facilitate a conversation, so it didn't really matter.

**中文翻译:**
这回到了我写这份文档的初衷：它是写给我自己的。这是我为了有效地完成工作而做的功课。我只是确保把它分享出去。我发现，特别是我的工程和设计搭档（如果你是在真正的“三位一体”模式下工作），几乎总是会深入参与这份文档。因为他们也身处一线，他们想确保当他们让团队去做某件事时，他们自己是认同这个方向的。
(00:43:28): 所以我发现这些人会深入参与。有时团队里的一些新人也会感兴趣并深入研究。当然，也有些人只扫一眼开头，要么说“看起来不错”，要么说“你太蠢了，我讨厌这个”。好吧，总会有这样的人。所以，别人是否读完整个文档对我来说并不重要。更重要的是，我知道我必须这样做才能对自己的决定有信心，然后我才能引导对话。所以没关系。

---

### [00:44:38] Lenny (Sponsorship - Eppo)

*(Note: This segment is an ad for Eppo, an A/B testing platform.)*

**English:**
This episode is brought to you by Eppo. Eppo is a next generation A/B testing and feature management platform... [Sponsorship details for Eppo]... Check out Eppo at getepo.com/lenny and 10X your experiment velocity. That's getE-P-P-O.com/lenny.

**中文翻译:**
本期节目由 Eppo 赞助。Eppo 是下一代 A/B 测试和功能管理平台……[此处省略 Eppo 广告详情]……请访问 getepo.com/lenny 了解 Eppo，让你的实验速度提升 10 倍。

---

### [00:45:28] Lenny

**English:**
Is there an example of a strategy you were thinking about recently or that you worked on in the past just to give people something concrete of like here's what Maggie thinks of as a question she's going to develop a strategy around?

**中文翻译:**
有没有你最近思考过或过去做过的策略例子？给观众一些具体的感觉，比如 Maggie 会针对什么样的具体问题去制定策略？

---

### [00:45:36] Maggie Crowley

**English:**
Yeah, I think, obviously this is where product content gets really challenging because obviously I can't really talk about the stuff I'm currently working on.

**中文翻译:**
是的，这就是产品内容变得棘手的地方，因为显然我不能谈论我目前正在做的具体工作。

---

### [00:45:38] Lenny

**English:**
Just tell us all of the secrets.

**中文翻译:**
把秘密都告诉我们吧。

---

### [00:45:38] Maggie Crowley

**English:**
The toast PR department would be really unhappy with me. It's questions like, if you're a director of product somewhere, maybe you're running a section of a business and it's annual planning. We're in Q4. What are you going to do next year? How do you answer that question? How do you back up your choices for that? You use a doc like this. Maybe you are realizing that the product that you're working on doesn't really matter, it's not really making an impact. You're kind of treading water. I would use this as a tool to figure out, okay, well what else could you do? So, yeah, quarterly planning, annual planning. If you feel like your team needs to make a pivot or if you think that there's a really interesting new opportunity that your business or your team should go after, is another time I might use something like this.

**中文翻译:**
Toast 的公关部门会很不高兴的。通常是这类问题：如果你是某处的产品总监，负责一个业务板块，现在是第四季度，要做年度规划。明年你要做什么？你如何回答这个问题？你如何支撑你的选择？你就用这样一份文档。或者，你意识到你正在做的产品其实无关紧要，没产生什么影响，你只是在“原地踏步”。我会用这个工具来弄清楚：“好吧，还能做点别的什么？”所以，季度规划、年度规划，或者当你觉得团队需要转型（Pivot），或者你发现了一个业务应该追求的有趣新机会时，我都会用这种方法。

---

### [00:46:30] Lenny

**English:**
This reminds me a little bit of, I keep mentioning this chat with Bill Carr that I had who is an early Amazon exec and how the narrative approach at Amazon, one of the benefits of that and the reasons they go there is partly for you to realize this is a bad idea before anyone even needs to give you feedback. And that's why they force you to write six pages in depth about your idea and then it goes in these concentric circles through the company. And idea is like, here's okay, and this is just not a good idea. Here's all the reasons why. So, I think there's a lot of similarities there.

**中文翻译:**
这让我想起我之前提到的和 Bill Carr（亚马逊早期高管）的聊天。亚马逊采用“叙述式（Narrative）”方法的一个好处是，让你在别人给你反馈之前，自己先意识到这可能是一个坏主意。这就是为什么他们强迫你写六页深入的构思文档，然后在公司内部传阅。目的是让你发现：“好吧，这其实不是个好主意，原因如下。”我觉得这有很多相似之处。

---

### [00:47:00] Maggie Crowley

**English:**
Yeah, there are many, many times when if you combine this artifact and process with the point about simplification where through that process you just start cutting so many things because then what happens is, let's say you've gone through this exercise and you're like, okay, I know exactly what my three things are that I want to work on. Then there's a moment where you take the strategy and then you look at your roadmap and they're never the same. And the roadmap is just bloated with all of this random stuff that like, oh, well, we have to do that because of this, or we have to do that because of that.
(00:47:37): This thing we're still working on, this is like six months delayed, so we're still going to do the thing. And then all of a sudden you've got 90% of your resources committed to things that don't track against your strategy. And it's a really interesting moment as a leader especially to sit there and go, well, what do we do? What do you do when you have that problem? And especially if you're a PM, you probably don't have the agency to say, scrap the entire roadmap and work on my new strategy. But at least it allows you to think about critically about whether you should be doing what you're doing and allows you to evaluate whether those things are still the most important things to work on.

**中文翻译:**
是的。很多时候，如果你把这种文档流程与“简化”结合起来，你会发现自己在过程中砍掉了非常多东西。因为通常会发生这种情况：假设你做完了这个练习，确定了最想做的三件事。然后你拿着策略去对比你的路线图（Roadmap），发现它们永远对不上。路线图里塞满了各种随机的东西：“哦，因为这个我们必须做那个”，“因为那个我们必须做这个”。
(00:47:37): “这个东西我们还在做，已经延迟了六个月，所以我们还得继续做。”突然间，你发现 90% 的资源都投入到了与策略无关的事情上。作为领导者，这是一个非常有趣的时刻，你会想：“好吧，我们该怎么办？”当你遇到这个问题时，你该怎么办？特别是如果你只是个 PM，你可能没有权力说“废掉整个路线图，按我的新策略来”。但至少它能让你批判性地思考你正在做的事是否正确，并评估那些事是否仍然是最值得投入的。

---

### [00:48:09] Lenny

**English:**
I'm going to summarize the template real quick, and then I'm going to have another question kind of along the lines. So, if you're trying to create your own little template, you start with the mission of the business, and then I imagine you also share the mission of your team because oftentimes it's a little more specific, if you're working on it like a product team strategy. Then there's a landscape of what's happening. So, you include competitive, SWOT analysis of competition risks, product state, business state, things like that.
(00:48:38): And then you share the current goals of what you're trying to achieve as a team slash business. And there's an account, honest accounting of what's happening in the product and technical hurdles and things like that that'll keep you from moving, I guess, achieving some of these goals. And then you share, here's the opportunity I see, how we win and how we actually achieve this opportunity where we place bets and things like that, or we could place bets. Then challenges of doing this, what needs to be true for this to be possible? And then you finally get to, here's what I think we should do, essentially the solution, ideally three bullet points, and then the plan. And I imagine the plan is step one, get sign off from exec. Step two, resource the team. Step three, start on this design research sprint.

**中文翻译:**
我快速总结一下这个模板。如果你想创建自己的模板：首先从**业务使命**开始，如果是产品团队策略，可能还要加上更具体的**团队使命**。接着是**现状景观**，包括竞争分析、竞争风险的 SWOT 分析、产品状态、业务状态等。
(00:48:38): 然后分享你作为团队/业务想要实现的**当前目标**。接着是对产品现状和**技术障碍**的诚实评估，这些障碍可能会阻碍你实现目标。然后分享你看到的**机会**：我们如何赢，如何实现这个机会，我们在哪里下注。接着是**挑战**：为了让这成为可能，需要满足哪些条件？最后是你认为**该做什么**，也就是解决方案，理想情况下是三个要点，最后是**计划**。我猜计划的第一步是获得高管批准，第二步是为团队争取资源，第三步是开始设计调研冲刺。

---

### [00:49:26] Maggie Crowley

**English:**
Pretty much.

**中文翻译:**
差不多就是这样。

---

### [00:49:30] Lenny

**English:**
Awesome. All right. Amazing. Somebody will create this template if you don't end up doing it.

**中文翻译:**
太棒了。如果你没做，肯定会有人根据这个做个模板出来的。

---

### [00:49:32] Maggie Crowley

**English:**
Yeah. I hope somebody does.

**中文翻译:**
是的，我希望有人能做。

---

### [00:49:34] Lenny

**English:**
So many promises already from this podcast. Along the same lines, you also have a one-pager template and process that I think people find really useful. So, how about we chat about that one briefly and then I'm going to go in a whole different direction.

**中文翻译:**
这期播客已经许下了这么多承诺。顺着这个思路，你还有一个单页计划（One-pager）模板和流程，我觉得大家也会觉得很有用。我们简单聊聊那个，然后我再换个话题。

---

### [00:49:52] Maggie Crowley

**English:**
Okay. Yeah, I don't think I have much to say about this. That has not been said by many people many times, but whether it's a spec, a PRD, a one pager, I don't even know what else people call it. It's the document that you use to define the thing that you're doing as a product team, and that means product design, engineering, your little squad. And what I think is really useful about this process is that it's the PM's artifact. So, designers produce designs, engineers write code. What do PMs do? A lot of people might say nothing. In theory, we write at least this document and it can be a pain. I've seen lots of ways where it hasn't been done very well, but when I think it's done really well and when it's really effective is it's a tool that allows the PM to start with why. And if you structure it correctly, the most important section in my opinion in the document is the first part, which is like what is the background and context?
(00:51:00): What is the problem, why does it matter and why does it matter now? And if you get those things right, the rest gets really easy, but it gives you a chance as a PM to center the team around the problem, why that problem exists, whether it's created by your own product or it's something the user is experiencing and why that problem is worth solving. That's a part that I think people sometimes forget to think about and why it's we're solving right now versus all the other problems you could be solving and then it can become the home base of the decisions that you make along the way. So, I think it's best when you have those sections and then also best when you write down on this day, we made this decision or we decided not to do this or we decided only to solve this part of the problem, not this part of the problem. Keeping a running list of that and a link off to all the different artifacts and research and things is helpful for a team.

**中文翻译:**
好。关于这个，我觉得很多人已经说过很多次了。无论是叫 Spec、PRD 还是单页计划，它就是你作为产品团队（包括设计、工程、你的小分队）用来定义你们正在做的事情的文档。我认为这个流程最有用的地方在于，它是 PM 的“产出物”。设计师产出设计，工程师写代码，PM 做什么？很多人可能会说“什么都不做”。理论上，我们至少写这份文档。这可能很痛苦，我也见过很多写得不好的。但我认为写得好且有效的文档，是能让 PM 从“为什么（Why）”开始的工具。如果你结构合理，我认为文档中最重要的部分是第一部分：**背景和上下文**是什么？
(00:51:00): **问题是什么？为什么它很重要？为什么现在很重要？** 如果你弄对了这些，剩下的就容易了。它让 PM 有机会让团队围绕问题达成共识：为什么这个问题存在（是产品本身造成的，还是用户的原生体验）？为什么这个问题值得解决？这是人们有时会忘记思考的部分：为什么现在解决它，而不是解决其他问题？然后它就成了你后续所有决策的“大本营”。我认为最好包含这些章节，并且最好记录下：“在这一天，我们做了这个决定”或者“我们决定不做这个”或者“我们决定只解决问题的一部分”。保留一份决策清单，并链接到所有的调研和产出物，这对团队非常有帮助。

---

### [00:51:52] Lenny

**English:**
So, just to summarize, what would be the headings again, just if someone's taking notes and wants to create the rule template?

**中文翻译:**
总结一下，如果有人在记笔记想做模板，标题有哪些？

---

### [00:51:57] Maggie Crowley

**English:**
I don't think these templates have to be really complicated. It's like background and context. The problem. I would literally write why this problem matters and why this problem matters now. Don't make it complicated, just answer those questions and if you can do that, and then again, it's only really helpful if then you bring that document before you go any further to your team and you use it to have a conversation and you get the smart people around you to take shots at it. I should have mentioned this earlier with the strategy. The first person I go to is typically speaking my engineering counterpart and I say, shred this, go through it, rip it apart, vomit comments on it, tear this down how it gets better. And as a PM you can't be precious about your work. You need people to poke holes in it.

**中文翻译:**
我觉得模板没必要太复杂。就是：**背景和上下文**、**问题**。我会直接写：**为什么这个问题很重要**，以及**为什么现在很重要**。别弄复杂了，直接回答这些问题。而且，只有当你把这份文档拿给团队，在进一步行动前进行讨论，让聪明人来挑战它时，它才真正有用。我之前聊策略时就该提到：我找的第一位通常是我的工程搭档，我会说：“把它撕碎，仔细看，挑刺，留下满篇评论，告诉我怎么能变得更好。”作为 PM，你不能对自己的作品过于“宝贝”，你需要别人来给你挑刺。

---

### [00:52:48] Lenny

**English:**
The why this matters now point is so interesting. I don't often hear that and I think it's such an important part of specs and plans and strategies because there's so many things you can do and there's certain things that are perishable that you can only do now. That if you don't do now you miss up the opportunity. And so I think that's a really interesting element that most people don't include and it reminds me of, I think I've done enough podcast episodes now where I'm just connecting all these things as people are talking. [inaudible 00:53:16] the John Nash thing happening where Karri, the founder of Linear talked about this concept of side quests as a founder. Because he's so good at staying focused and I was just like, "How do you stay focused and just get stuff done when you have so many people coming out?" He's just like, "There's the main quest and then there's the side quests and side quest I don't need to do right now. There's the main quest which is build up really successful business." And I feel like this is a good example of that in action.

**中文翻译:**
“为什么现在很重要”这一点非常有趣。我不常听到这个，但我认为它是 Spec、计划和策略中非常重要的一部分。因为你可以做的事情太多了，有些机会是“易腐烂”的，只能现在做，错过了就没了。我觉得这是一个大多数人没包含进去的有趣元素。这让我想起（我已经做了够多期播客了，现在别人说话时我总能把各种事联系起来），Linear 的创始人 Karri 谈到过创始人面临的“支线任务（Side quests）”概念。他非常擅长保持专注，我问他：“当有这么多人找你时，你如何保持专注并把事情办成？”他说：“有主线任务，也有支线任务。支线任务我现在不需要做。主线任务是建立一家真正成功的企业。”我觉得这就是那个理念的实际应用。

---

### [00:53:39] Maggie Crowley

**English:**
Yeah, I love his take on quality and taste too.

**中文翻译:**
是的，我也很喜欢他对质量和品味的看法。

---

### [00:54:39] Lenny (Contrarian Corner)

**English:**
I'm going to move on to a different topic and this might become a new thing that we do and I'm going to call it contrarian corner. I asked you if you have contrarian opinions about things before we started recording this episode and you had some really good ones. So, there's a couple topics I'm going to chat about and we'll see if this becomes a recurring theme and you're laughing and nodding your head, what are you thinking as I say this?

**中文翻译:**
我要换个话题了，这可能会成为我们的一个新环节，我称之为“非主流观点角（Contrarian Corner）”。在录制前我问你有没有什么非主流观点，你给出了几个非常棒的。所以我想聊聊这几个话题，看看这是否能成为一个固定环节。你现在又笑又点头，在想什么呢？

---

### [00:54:39] Maggie Crowley

**English:**
I'm thinking about when I had a podcast, you would do a show on a topic and we would click the end recording button and then every single guest would be like, I had no idea what I was doing. I made it all up, it was waterfall. None of that matters. I didn't know what I was ... People would say the wildest stuff and I would sit there as a PM and just think what. We just talked about this framework, we just talked about this thing and that's how you're supposed to do it. And then they would get off the official part and just say, yeah, it's wild. Nothing goes the way you want it to go. We're all just kind of making it up as we go. And so I hope that you get more of those takes in this part of the show.

**中文翻译:**
我在想，以前我做播客时，我们聊完一个话题，按下停止录音键，然后每个嘉宾都会说：“其实我根本不知道自己在干嘛。全是瞎编的，其实就是瀑布流开发。那些框架根本没用。我当时根本不知道……”人们会说出最疯狂的大实话。而我作为一个 PM 坐在那儿想：“什么？我们刚才还在聊这个框架，聊这件事该怎么做。”然后他们一离开正式录音就开始说：“是的，太疯狂了。没一件事是按计划走的。我们都是边走边摸索。”所以我希望在这个环节能听到更多这种大实话。

---

### [00:55:18] Lenny

**English:**
I'm very sensitive to that point right now because someone just tweeted about how they're just finding that many of my newsletter posts about how companies write product are the ideal version of what they do and I rarely or they rarely share, here's all the challenges we're having, which I think there's truth to that, but I also get into a lot of failures on this podcast. Actually, I think the podcast is a lot more of just here's things that go wrong versus the newsletter. So, I'm just like shit, I need to do more of that. So, I love that you mentioned that and let's see what we can get into. But I guess maybe before we get there, is there an example of something that didn't go just along the lines of some sort of failure slash mistake?

**中文翻译:**
我现在对这一点非常敏感，因为有人刚发推特说，他发现我 Newsletter 里写的那些公司如何做产品的文章，其实都是他们理想中的样子，而很少分享“我们遇到的所有挑战”。我觉得这确实有道理。但在播客里，我会聊很多失败案例。实际上，我觉得播客比 Newsletter 更多地在聊“哪里出错了”。所以我心想：“该死，我得更多地聊聊这个。”我很喜欢你提到这一点。但在那之前，你能不能分享一个没按计划进行的例子，某种失败或错误？

---

### [00:55:59] Maggie Crowley

**English:**
I might be foreshadowing, but a question I ask in every product interview is what's the worst product you've ever shipped? And that's because I don't think you're a good PM if you haven't shipped something that's really shitty, you just haven't had enough reps, you haven't done it enough time. And it's not only that you've done it but that you can admit it and which one it is. That's so important. And I remember, it was so dumb, I'm still so mad about this, that we did this. I won't name which team, which company, I'm not going to call that out, but we decided we needed to do a rewrite, red flag number one of a existing product and engineer who I'd worked with many times. We had a really good relationship and this person was like, yeah, yeah, it's going to take six months, no problem.
(00:56:47): Core part of the product been around for forever. One of those things that the code is still, it's still the code written by the founders kind of thing. It didn't take six months, it took two and a half years. It still wasn't done. It almost never, it went on for so much longer than it should have. It took us forever to get to feature parody. It was the worst project. So, many people rotated in and out of it. Everyone thought it was dumb, sunk cost fallacy, just the worst. And it's because A, we got arrogant and we thought we could do it. B, we skipped discovery. We didn't really write a one-pager, we just went for it. We didn't do enough technical and design research into what the requirements would actually have to be. And there you have it.

**中文翻译:**
我可能在做铺垫，但我每次产品面试都会问一个问题：“你发布过的最烂的产品是什么？”因为我认为，如果你没发布过烂东西，你就不是一个好 PM。这意味着你实战经验不够，时间不够长。不仅是你做过烂东西，而且你能承认它，并指出是哪一个。这非常重要。我记得一个非常愚蠢的例子，我现在想起来还很生气。我不说是哪个团队、哪家公司了，但我们决定对一个现有产品进行“重写（Rewrite）”——这是第一个危险信号。我和一位合作过多次、关系很好的工程师商量，他说：“没问题，六个月就能搞定。”
(00:56:47): 那是产品的核心部分，已经存在很久了，代码还是创始人写的。结果呢？没用六个月，用了两年半还没做完。它拖的时间比预想的长得多。我们花了无数时间才达到“功能对等（Feature parity）”。那是史上最烂的项目。人员进进出出，大家都觉得这事儿蠢透了，沉没成本谬误，简直是噩梦。原因有二：第一，我们太傲慢了，以为自己能行；第二，我们跳过了调研（Discovery），没写单页文档，直接就开始干了。我们没有对实际需求进行足够的技术和设计研究。结果就是这样。

---

### [00:57:39] Lenny

**English:**
And did not work out or was it a huge success in the end and it changed the trajectory of the business?

**中文翻译:**
那最后是失败了，还是最终大获成功并改变了公司的轨迹？

---

### [00:57:39] Maggie Crowley

**English:**
Absolutely not. But you know what, I didn't get fired, so it's fine.

**中文翻译:**
绝对没有成功。但你知道吗，我没被开除，所以还行。

---

### [00:58:16] Lenny (Contrarian Opinion: Data-Driven)

**English:**
Good times. Okay, well maybe we'll start a failure corner. That could be a new segment. We may have a little sound and theme music, but this time we have contrarian corner and you have a couple contrarian opinions about a couple topics. The first is product management. What is something that you believe about product management that maybe other people are less convinced by?

**中文翻译:**
有意思。好吧，也许我们可以开个“失败角”。这可以成为一个新环节，配上音效和主题曲。但这次我们先聊“非主流观点角”。关于产品管理，你有什么观点是别人可能不太认同的？

---

### [00:58:39] Maggie Crowley

**English:**
The one I like to have in this area is that people who are really excited about being data-driven, to me that is oftentimes a red flag for their product thinking, especially if it's an executive who's saying things like, oh, so we make all our decisions with our dashboards. To me that says that the team is over-emphasizing quantitative data at the expense of qualitative data and they're not using good judgment. They probably don't do a lot of direct user research. They don't really understand the humans who are using the thing, what they need, what they care about, and they're managing via a dashboard. And maybe if they got really, really good at picking metrics, it would be fine. And oftentimes maybe it is fine. Maybe you have a high volume business that's really easy to run experiments on and that works for you. But most PMs, most jobs, most products, you're going to be better off talking to 10 users and you'll get more and better insights out of why things are happening than you would with any dashboard.

**中文翻译:**
我最喜欢的一个观点是：那些对“数据驱动（Data-driven）”感到异常兴奋的人，对我来说往往是他们产品思维的危险信号。特别是如果一个高管说：“哦，我们所有的决策都是根据仪表盘做的。”对我来说，这意味着团队过度强调定量数据，而牺牲了定性数据，他们没有运用良好的判断力。他们可能没做多少直接的用户研究，不真正理解使用产品的“人”，不理解他们的需求和关切。他们是在通过仪表盘进行管理。也许如果他们非常擅长挑选指标，那也没问题。有时确实没问题，比如你有一个高流量业务，很容易做实验。但对于大多数 PM、大多数工作和产品来说，去和 10 个用户聊聊，你获得的关于“为什么会发生这些事”的洞察，会比任何仪表盘都多、都好。

---

### [01:00:00] Maggie Crowley (Obviously Better Thing)

**English:**
One quick story on this. I remember really early on in my career, Adam Medros, who was a VP [inaudible 01:00:24] at TripAdvisor, we were in a room, just had this meeting called product review that was amazing when I first joined and someone was justifying this project and he just... He was just like, this is an obviously better thing. Just do it. Stop. Stop it. Stop doing all the stuff that you're doing. Stop with these numbers, whatever it was that they were doing, if it's obviously better, if it's logically better, use your good judgment and do that thing and let's move on. And I've always thought about that, but you can just do the obviously better thing.

**中文翻译:**
关于这个有个小故事。我职业生涯早期在 TripAdvisor 时，当时的副总裁 Adam Medros 在一次产品评审会上。有人在为某个项目辩护，列了一堆理由。他直接说：“这显然是件更好的事。直接去做吧。停，别再做那些乱七八糟的分析了。别再纠结这些数字了。如果它显然更好，逻辑上更优，那就运用你的判断力去做，然后我们继续下一项。”我一直记着这句话：你其实可以直接去做那些“显然更好”的事。

---

### [01:01:20] Lenny (Contrarian Opinion: Product Content)

**English:**
Another topic that you have some interesting opinions about his product content very close to our hearts, both my heart and your heart. Do share.

**中文翻译:**
另一个你有有趣见解的话题是“产品内容”，这和我们俩都息息相关。请分享一下。

---

### [01:01:20] Maggie Crowley

**English:**
Really if you're going to make good content, you have to sanitize and frameworkize the thing that you're working on. And then slowly, I think for a lot of people who are reading it and looking at it, their thinking starts to become, well look how well I did this framework. Look how well I implemented this thing. And they lose touch with the point which is creating impact. And so all of this content makes it really noisy and then makes people think that, oh, if I just do these things that I'll get what I want. And now I'll just check off my list and then I checked it off and then I should get my promotion at the end of the day. But it's like the best PMs have built up so many different frameworks and they can apply them in different ways. And then sometimes they throw them out and they say, nothing I have in my toolkit makes sense for this moment, but I know what to do because I have intuition and I have data and I've talked to users or whatever.
(01:02:16): And so content sometimes can get in the way of the impact because you're trying to apply it and you think that the point is the framework and the point is the one pager or whatever it is that you're doing when it's not. And then if you're a leader and maybe if you've had the good and ill fortune of having published content, someone comes to you and says, well, you said in that one podcast episode that you don't believe in roadmaps, so why are you asking me for a roadmap? And then you're the who's sitting there being like, well, it's a little more complicated than that. And that was a fun take that I had, but I actually need to understand what we're doing because planning and I need to figure out what my budget is, blah, blah, blah.

**中文翻译:**
如果你想做出好的内容，你必须对你所做的事情进行“消毒”和“框架化”。然后慢慢地，对于很多读者来说，他们的思维变成了：“看我把这个框架用得多么好，看我把这件事实施得多么到位。”他们脱离了核心目标——创造影响力。所有这些内容让环境变得非常嘈杂，让人们觉得：“哦，只要我做了这些事，我就能得到我想要的。”他们只是在清单上打勾，然后觉得：“我打完勾了，今天结束我该升职了。”但事实上，最优秀的 PM 积累了许多不同的框架，并能以不同的方式应用它们。有时他们会把框架全扔掉，说：“我工具箱里没有任何东西适合现在，但我知道该怎么做，因为我有直觉、有数据、聊过用户。”
(01:02:16): 所以，内容有时会阻碍影响力的产生，因为你试图生搬硬套，觉得重点是那个框架或单页文档，其实不然。另外，如果你是一个领导者，且不幸（或幸运地）发布过内容，有人会跑来跟你说：“嘿，你在那期播客里说你不相信路线图，那你为什么现在问我要路线图？”然后你坐在那儿想：“额，这事儿比那复杂一点。那只是我当时一个有趣的观点，但我现在确实需要了解我们在做什么，因为我要做规划，要确定预算，等等。”

---

### [01:05:55] Maggie Crowley (Impact of Writing Online)

**English:**
Yeah, it's probably the best thing I've ever done for my career and I am so grateful for the people whose idea it was, who supported me and especially at Drift, when that became such a part of what we were doing at that time. And it's been helpful for a couple of reasons. One is just networking and access. I probably wouldn't be here today if I hadn't done that and if a friend of a friend had read the thing, it's like it just creates so many more connections. And so access to people and networking is one of the first benefits.
(01:06:51): Also building a personal brand is really helpful if you want, one of the things that I always wanted to do with my career is try to make it so that I'm always employable. I just didn't want to, I'm an 08 grad not to put my age out there, and it was a hard time. And so I've always had this in the back of my mind, you want to be able to have a solid career. And so I thought that investing in my personal brand would be a way to help me get access to roles. It helps in recruiting as well when I'm trying to hire people. Because a lot of my job now is bringing people in and because I've been vocal about how I like to work and who I am, a lot of people and they will send me a note and say, I want to work with you, or I want to work on a team like that.
(01:07:35): And that's huge because if my job is to hire people, then that's great and people can get a sense of who I am without needing to be on the phone with me. My favorite benefit outside of those things has been that it's helped me learn more from the work I've done than I otherwise would've been able to. Because in order to make content, you have to think through what you did, you have to summarize it, process it, make it interesting for people. And then especially if it's in a podcast meeting, talk to somebody about it. And the process of doing that means that you're paying attention to what you're learning along the way. And so often we don't do that because we're busy working, we have our lives, things are happening. And that to me is, I think what's made me a better product person faster is because I spent the time to think about what I was doing in a way that I wouldn't have if I didn't have to write something down.

**中文翻译:**
是的，这可能是我职业生涯中做过的最正确的事。我非常感谢那些提出这个想法并支持我的人，特别是在 Drift 时期，这成了我们当时工作的重要组成部分。它在几个方面很有帮助：第一是人脉和资源。如果我没做这些，如果不是朋友的朋友读到了我的文章，我今天可能就不会坐在这里。它创造了太多的连接。
(01:06:51): 其次，建立个人品牌非常有帮助。我一直希望我的职业生涯能达到一种状态：我永远是“可雇佣”的。我是 2008 年毕业的（暴露年龄了），那是个艰难的时期。所以我心里总有个念头，要拥有一份稳固的事业。我认为投资个人品牌是获得职位机会的一种方式。这在招聘时也很有帮助。我现在很大一部分工作是招人，因为我公开表达过我的工作方式和为人，很多人会给我发信息说：“我想和你共事”或者“我想在这样的团队工作”。
(01:07:35): 这太重要了，因为如果我的工作是招人，那人们不需要和我通电话就能了解我是谁。除了这些，我最喜欢的收获是：它帮我从工作中学习到了更多。因为为了制作内容，你必须思考你做了什么，必须总结、处理并让它变得有趣。特别是在播客里和人讨论。这个过程意味着你在关注自己一路上学到了什么。通常我们不会这样做，因为我们忙于工作和生活。对我来说，这让我更快地成为了更好的产品人，因为我花时间思考了我在做什么，如果不是为了写下来，我绝不会思考得这么深。

---

### [01:15:22] Lenny (Lightning Round)

**English:**
Maggie, what are two or three books that you've recommended most to other people?

**中文翻译:**
Maggie，你向别人推荐最多的两三本书是什么？

---

### [01:15:27] Maggie Crowley

**English:**
First, most common one is probably the Presentation Secrets of Steve Jobs, the little tiny one, really great way to improve your speaking skills and your presentation skills and to get distracted executives to agree with the point you're making. So, that's one. Thinking in Bets by Annie Duke is the second one. Coming back to the point about being able to make bets, I think that one's a really interesting one. And then bonus third one, this is more like a desk reference that I now have on my desk, the Scaling People book by Claire Hughes Johnson. I really enjoyed the way that one is working and it just sits on my desk and I reference it every once in a while, especially as manager.

**中文翻译:**
第一本最常用的是《乔布斯的演讲秘诀》（*The Presentation Secrets of Steve Jobs*），那本很薄的小书。它是提高演讲和演示技巧、让那些注意力不集中的高管同意你观点的绝佳方法。第二本是 Annie Duke 的《对赌》（*Thinking in Bets*）。回到“下注”那个点，我觉得这本非常有趣。第三本是加分项，更像是一本案头参考书，Claire Hughes Johnson 的《规模化人才》（*Scaling People*）。我非常喜欢它的组织方式，它就放在我桌上，我作为经理经常翻阅。

---

### [01:16:51] Maggie Crowley (Interview Question)

**English:**
I did. Yeah, it is what is the worst product that you've ever shipped? I think the best answers are ones, and I don't even care if someone listens to this and then I do this in an interview, people immediately laugh a little bit. They remember the horrible thing they did and then they share that horrible thing with you. And it tells me you have some humor, you're humble and you can point out when you've made a mistake. You've done enough to be able to confidently say, of course I've made a mistake. Because none of us are perfect. And you know how to spot those mistakes and you can learn from them. And I've always found that those conversations are the most interesting.

**中文翻译:**
是的，就是“你发布过的最烂的产品是什么？”我认为最好的回答是那些（我不在乎是否有人听了这期节目后在面试里这么答）：人们会立刻笑出声，他们想起了自己做过的那些糟糕事，然后分享给你。这告诉我你很有幽默感，很谦逊，而且能指出自己的错误。你已经积累了足够的经验，可以自信地说：“我当然犯过错。”因为没人是完美的。你知道如何发现错误并从中学习。我一直觉得这种对话是最有趣的。

---

### [01:19:38] Maggie Crowley (Olympic Speed Skating)

**English:**
The whole experience, I've obviously learned a ton from it, and I think what might surprise people about being a small sport athlete is that you have to think in four or eight year chunks. And so it's one of those things where you grind for so long in a dark corner and then you get a chance to get the light to shine on you and you learn how to love the process. Especially for speed skating, I was a long track speed skater, it's a 400-meter rink.
(01:20:15): You just are always turning left and going in a circle. There's not a lot going on. It's just you and your thoughts and you just really, really learn how to get good at perfecting something over and over again, and you learn how to grind, you learn how to focus, and I think it's also cool you get to go superfast. But yeah, I don't know if that would surprise people about speed skating, but I think just about being a small sport elite athlete, it's really about years and years and years of toiling and silence to get maybe one shot at something great.

**中文翻译:**
那段经历让我受益匪浅。作为一名小众运动项目的运动员，最让人们惊讶的可能是你必须以“四年”或“八年”为单位来思考。你会在阴暗的角落里磨练很久，然后才有机会站在聚光灯下。你学会了热爱这个过程。特别是速滑，我是长距离速滑选手，在 400 米的冰场上。
(01:20:15): 你总是在向左转，绕圈子。没什么新鲜事，只有你和你的思想。你学会了如何一遍又一遍地追求完美，学会了磨练，学会了专注。当然，能滑得飞快也很酷。我觉得作为小众项目的精英运动员，核心就是：在寂静中辛勤耕耘多年，只为那一次成就伟大的机会。

---

### [01:22:07] Lenny (Outro)

**English:**
Bye everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
再见，各位。非常感谢收听。如果你觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用上订阅。另外，请考虑给我们评分或留下评论，这能帮助更多听众发现这个播客。你可以在 lennyspodcast.com 找到往期所有节目或了解更多信息。下期节目见。