# Manik Gupta - 双语对照

This is the complete bilingual transcript of Lenny’s Podcast featuring Manik Gupta.

---

### (00:00:03) Lenny

**English:**
Manik Gupta has led two of the most successful consumer products in history: Google Maps, where he was director of product for the Maps team, and Uber where he was Chief Product Officer. After leaving Uber, he spent most of his time working on a product to help people avoid getting COVID, called CVKey, and most recently he took on a role at Microsoft as Corporate Vice President leading many of their consumer efforts.

**中文翻译:**
Manik Gupta 曾领导过历史上最成功的两款消费级产品：他曾担任 Google 地图团队的产品总监，以及 Uber 的首席产品官（CPO）。离开 Uber 后，他投入了大量时间开发一款名为 CVKey 的产品，旨在帮助人们预防感染新冠病毒。最近，他加入了微软，担任公司副总裁，负责领导多项消费者业务。

---

### (00:00:25) Lenny

**English:**
In our conversation, we cover what he's learned about building successful consumer products, how to structure and higher product teams, building consumer apps, a concept called the consumer stack, company market fit versus product market fit, what it's like to be CPO, what he learned working at Microsoft versus Uber versus Google, and also a ton of career advice for anyone thinking about becoming a CPO someday. I hope that you enjoy this episode with Manik Gupta.

**中文翻译:**
在我们的对话中，我们探讨了他关于构建成功消费级产品的经验、如何组建和招聘产品团队、开发消费级应用、一个被称为“消费者技术栈”（Consumer Stack）的概念、“公司产品契合度”与“产品市场契合度”的区别、担任 CPO 的真实体验、在微软、Uber 和 Google 工作分别学到了什么，以及为那些梦想有朝一日成为 CPO 的人提供了大量的职业建议。希望你们喜欢本期与 Manik Gupta 的对话。

---

### (00:00:53) Lenny

**English:**
This episode is brought to you by Mixpanel, offering powerful self-serve product analytics. Something we talk a lot about on the show is how startups can build successful and amazing products. And relying on gut feeling is a really expensive way to find out if you're heading in the right direction, especially when you're raising money. Because VCs don't want to pay the price for these kinds of mistakes. That's why Mixpanel will give you $50,000 in credits when you join their startup program. With Mixpanel, startups find product market fit faster, helping you take your company from minimal viable product to the next unicorn. Access realtime insights with the help of their prebuilt templates, and note that at every stage Mixpanel is helping you build with confidence and curiosity for free. Apply for the startup program today to claim your $50,000 in credits at mixpanel.com/startups with an S. And even if you're not a startup, Mixpanel has pricing plans for teams of every size. Grow your business like you've always imagined with Mixpanel.

**中文翻译:**
本期节目由 Mixpanel 赞助播出，他们提供强大的自助式产品分析服务。我们在节目中经常讨论初创公司如何打造成功且惊艳的产品。而仅仅依靠直觉来判断方向是否正确，代价是非常昂贵的，尤其是在融资阶段，因为风投（VC）不想为这种错误买单。这就是为什么 Mixpanel 在你加入其初创公司计划时，会提供价值 5 万美元的抵用金。通过 Mixpanel，初创公司可以更快地找到产品市场契合度（PMF），帮助你的公司从最小可行性产品（MVP）成长为下一个独角兽。借助其预设模板获取实时洞察，Mixpanel 在每个阶段都能免费帮助你带着信心和好奇心进行构建。立即申请初创公司计划，在 mixpanel.com/startups 领取 5 万美元抵用金。即使你不是初创公司，Mixpanel 也有适合各种规模团队的定价方案。用 Mixpanel 实现你梦寐以求的业务增长。

---

### (00:01:57) Lenny

**English:**
Hey, Casey Winters. What do you love about Coda?

**中文翻译:**
嘿，Casey Winters。你喜欢 Coda 的哪一点？

---

### (00:02:00) Casey Winters

**English:**
Coda is a company that's actually near and dear to my heart, because I got to work on their launch when I was at Greylock. But in terms of what I love about it, you know I love loops and Coda has some of the coolest and most useful content loops I've seen. How the loop works is someone can create a Coda and share it publicly for the world. This can be how you create OKRs, run annual planning, build your roadmap, whatever. Every one of those Codas can then be easily copied and adapted to your organization without knowing who originally even wrote it. They're embedding the sharing of best practices of scaling companies into their core product and growth loops, which is something I'm personally passionate about.

**中文翻译:**
Coda 是一家我非常亲近的公司，因为我在 Greylock 工作时曾参与过他们的发布。至于我喜欢它的原因，你知道我喜欢“循环”（loops），而 Coda 拥有我见过的最酷、最实用的内容循环。这种循环的运作方式是：有人可以创建一个 Coda 文档并向全世界公开分享。这可以是关于如何制定 OKR、进行年度规划、构建路线图等等。每一个这样的 Coda 都可以被轻松复制并应用到你的组织中，甚至不需要知道原作者是谁。他们将成长期公司的最佳实践分享嵌入到了核心产品和增长循环中，这正是我个人非常热衷的事情。

---

### (00:02:36) Lenny

**English:**
I actually use Coda myself every day. It's kind of the center of my writing and podcasting operation. I use it for first drafts, organize my content calendar, to plan each podcast episode, and so many more things. Coda's giving listeners this podcast $1,000 in free credit off their first statement. Just go to coda.io/lenny. That's coda.io/lenny.

**中文翻译:**
实际上我自己每天都在用 Coda。它几乎是我写作和播客运营的中心。我用它写初稿、整理内容日历、规划每一集播客，还有很多其他用途。Coda 为本播客的听众提供首份账单 1000 美元的免费抵用金。只需访问 coda.io/lenny 即可。

---

### (00:03:03) Lenny

**English:**
Manik, welcome to the podcast.

**中文翻译:**
Manik，欢迎来到本播客。

---

### (00:03:06) Manik Gupta

**English:**
Thank you, Lenny. It's great to be here, man.

**中文翻译:**
谢谢你，Lenny。很高兴能来到这里。

---

### (00:03:08) Lenny

**English:**
I don't know if it's obvious, but I am quite honored to have you on this podcast. You've had such an illustrious career as a founder leading the Google Maps team, as CPO at Uber for, I believe, four years. Now you're kind of a fancy VP at Microsoft on consumer stuff. It's this incredible career and trajectory. My first question is, looking back at your career, what would you say is maybe the one or two main things that you did that helped you get to where you are today? For folks that are maybe earlier in the career, of what they should be focusing on.

**中文翻译:**
我不知道这是否显而易见，但我非常荣幸能邀请你参加。你拥有如此辉煌的职业生涯：作为创始人，领导过 Google 地图团队，在 Uber 担任了大约四年的 CPO。现在你又是微软负责消费者业务的高级副总裁。这是一个令人惊叹的职业轨迹。我的第一个问题是，回顾你的职业生涯，你认为哪一两件关键的事情帮助你取得了今天的成就？对于那些处于职业生涯早期的人来说，他们应该关注什么？

---

### (00:03:39) Manik Gupta

**English:**
Yeah. Thanks, Lenny, for having me. I'm also a big fan of yours, by the way. I love your newsletter and it's been incredible to just see how you have also grown both the set of topics that you cover and this podcast. Just really a big fan, so again, thanks for having me.

**中文翻译:**
好的。谢谢你，Lenny。顺便说一下，我也是你的忠实粉丝。我非常喜欢你的时事通讯（newsletter），看到你涵盖的话题范围和这个播客的成长过程，真的很不可思议。我真的是你的粉丝，所以再次感谢你的邀请。

---

### (00:03:54) Lenny

**English:**
Appreciate that.

**中文翻译:**
非常感谢。

---

### (00:03:55) Manik Gupta

**English:**
Let me start by telling you a little bit about my philosophy of this. I'm maybe a little bit late to the party, but I recently read this book from Morgan Housel on Psychology of Money. And I highly recommend your listeners read it if they get a chance. There's a chapter in there, he talks about luck and risk. What he says is, when you look at individuals and you think about, or you ask them, or you think about what they have done that have made them successful, we tend to put a greater amount of emphasis on effort and a little less emphasis on luck and risk. I think I strongly subscribe to that. The important thing when you look back is how much luck played a big part, and of course the risk that somebody took played a big part.

**中文翻译:**
让我先谈谈我在这方面的哲学。我可能读得有点晚，但我最近读了 Morgan Housel 的《金钱心理学》（Psychology of Money）。我强烈推荐你的听众如果有机会的话去读一读。书中有一章专门讨论“运气与风险”。他说，当我们观察个人并思考（或询问）是什么让他们成功时，我们往往会过度强调努力，而忽视了运气和风险。我非常认同这一点。当你回首往事时，你会发现运气扮演了多么重要的角色，当然，某人所承担的风险也同样重要。

---

### (00:04:45) Manik Gupta

**English:**
This is something that I've been thinking a lot about myself, which is what are some of the patterns of people who have had multiple careers and have gone through a journey where they've learned a lot and they've contributed and things like that? I think there are two patterns that stand out, both when I look at myself in terms of what I've been through, and also when I talk to a lot of my friends who have also gone on and done interesting things, and I wanted to cover both of that. The first one is really about people. It's about surrounding yourself with the best people you can find.
(00:05:16):
It was so funny. I was watching the Warriors game last night, and yeah Warriors, we won the NBA championship. That's great.

**中文翻译:**
这也是我一直在思考的问题：那些拥有多段职业生涯、在旅途中学到很多并做出贡献的人，他们身上有什么共同模式？当我审视自己的经历以及与那些做出一番事业的朋友交谈时，我发现了两个突出的模式。第一个是关于“人”。也就是让你自己被你能找到的最优秀的人包围。
(00:05:16):
这很有趣。我昨晚在看勇士队的比赛，是的，勇士队赢得了 NBA 总冠军，太棒了。

---

### (00:05:22) Lenny

**English:**
Go Warriors.

**中文翻译:**
勇士队加油。

---

### (00:05:24) Manik Gupta

**English:**
One of the reporters, I think she asked Steve Kerr, the coach, "What's the secret?" And he goes, "Well just hang around superstars." That's what he said and he just passed the mic over to somebody else and said, "Look, this is a team that's hanging around superstars." And that's exactly what it is. If you're create enough opportunities, especially early on in your career as you asked, around hanging around people who are doing interesting things and they're doing things which really are different, or they're doing things in a different manner and it's exciting, the right things will happen.

**中文翻译:**
其中一名记者问教练 Steve Kerr：“秘诀是什么？”他回答说：“就是和超级巨星待在一起。”他说完就把麦克风递给了别人，意思就是：“看，这是一支由超级巨星组成的团队。”事实确实如此。如果你能创造足够的机遇，尤其是在你提到的职业生涯早期，去结识那些正在做有趣事情的人，那些做事方式与众不同且令人兴奋的人，那么正确的事情自然会发生。

---

### (00:05:55) Manik Gupta

**English:**
I was lucky in a way that I caught myself in that situation. I grew up in India and when I was 16 I got a scholarship to move to Singapore to do my high school and then my undergrad studies. It just turned out that during those days, Singapore... I mean it still is, but it was a melting pot for the best and brightest folks that you can get from all over the Asia diaspora if you will. Among my colleagues and my fellow students there were a bunch of really, really smart people, so I just learned a lot from them and that gave me a great start to just go on and do something interesting. Right out of college, I started my own company and I did that with two of my classmates. One of them happens to be one of my best friends whom I grew up with who also came on the same scholarship with me to Singapore. We were just part of that ecosystem and it gave me a lot of opportunities to try out different things in college and so on and so forth.

**中文翻译:**
我很幸运，自己曾处于那样的环境中。我在印度长大，16 岁时获得奖学金去新加坡读高中和本科。事实证明，那时候的新加坡——现在依然是——是亚洲各地最优秀、最聪明人才的熔炉。在我的同事和同学中，有一群非常非常聪明的人，我从他们身上学到了很多，这为我后来去做有趣的事情打下了良好的基础。大学一毕业，我就和两个同学一起创办了自己的公司。其中一个是我从小一起长大的好朋友，他也拿到了同样的奖学金和我一起去新加坡。我们当时就是那个生态系统的一部分，这让我在大学期间有很多机会尝试不同的事情。

---

### (00:06:44) Manik Gupta

**English:**
I think the main thing that I would say here for people who are early in career is just surround yourself with people who are really good at what they do. Learn from them. And by the way, play the long game. Once you find someone like that, stick to them. As long as they want to hang out with you, but just stick to them. Because you will go on to do multiple things over your career with the same set of people. And the shared trust and experience that you build with A plus people is just going to go a long way. Anyway, that's pattern number one. I think that has helped me a lot and I also see a lot of that in other folks whom I talk to.

**中文翻译:**
对于职业生涯早期的人，我想说的核心建议就是：让自己身边围绕着那些在各自领域非常优秀的人。向他们学习。顺便说一下，要玩“长线游戏”。一旦你找到了这样的人，就紧紧跟随他们。只要他们愿意带你玩，就别放手。因为在你的职业生涯中，你会和同一群人一起做很多不同的事情。你与这些“A+ 级人才”建立的共同信任和经验将让你受益终身。总之，这是第一个模式。我认为这对我帮助极大，我也在其他成功人士身上看到了这一点。

---

### (00:07:19) Manik Gupta

**English:**
Then the second pattern is... This is something I resonate a lot with personally, is I'm a strong technology optimist. There's always a lot of narrative these days around technology and maybe a little bit more pessimism, and I find that bizarre. I'm just such a strong technology advocate and optimist, because I feel technology's such a strong force for good. I grew up as an engineer myself, and I've always been attracted to projects where we can use technology to solve a real human need. I did that with my startup, I did that at Hewlett-Packard, I did that at Google and at Uber as well. The passion that you get if you're a strong advocate of technology and how it can really help, it just gets you to choose a set of things that you want to do at scale.

**中文翻译:**
第二个模式是……这是我个人非常有共鸣的一点，那就是我是一个坚定的“技术乐观主义者”。如今关于技术的讨论很多，甚至带有一点悲观色彩，我觉得这很奇怪。我是一个非常坚定的技术倡导者和乐观主义者，因为我觉得技术是推动社会向善的强大力量。我本身是工程师出身，一直被那些能利用技术解决人类真实需求的项目所吸引。我在自己的创业公司、惠普、Google 以及 Uber 都是这么做的。如果你坚信技术及其带来的帮助，这种热情会驱使你选择那些能够大规模产生影响的事情。

---

### (00:08:06) Manik Gupta

**English:**
For instance, when I joined Google in India to work on Maps, it was all about helping millions of users, around Asia particularly, navigate their world. There wasn't a good solution like that, so how can you bring technology to really solve those problems?
(00:08:21):
I think those are the two patterns, Lenny. One is surrounding yourself with A plus people, and the second is just having very strong optimism and passion about technology. At least if I connect their dots looking backwards, those are the things that have really helped me and a bunch of other folks that I see in a similar situation. I'm hoping that folks early in their career thing through that.

**中文翻译:**
例如，当我加入 Google 印度团队负责地图业务时，核心目标就是帮助数百万用户（尤其是亚洲用户）在现实世界中导航。当时还没有好的解决方案，所以如何利用技术来真正解决这些问题？
(00:08:21):
我认为这就是那两个模式，Lenny。一是让自己身边围绕着 A+ 级人才，二是保持对技术的强烈乐观和热情。至少从回溯的角度来看，这些是真正帮助了我以及许多处于类似情况的人的事情。我希望职业生涯早期的人能思考一下这些。

---

### (00:08:40) Lenny

**English:**
I bet there's a big overlap between those two points, technology optimist and just superstars. That's interesting.

**中文翻译:**
我敢打赌这两点之间有很大的重叠——技术乐观主义者和超级巨星。这很有趣。

---

### (00:08:46) Manik Gupta

**English:**
Yeah, there definitely is. That's actually really good. I hadn't thought about that. You're right. I think there's definitely that overlap, because folks who are in that mode, they really get around more together. I'm also an angel investor and an investor in a bunch of companies. Lenny, you and I have invested in a bunch of companies together as well. And it's like that. It's really about people who have the same kind of frequency in terms of thinking about the world outlook and they want to go on to do interesting things. I think that's really what drives the narrative forward.

**中文翻译:**
是的，肯定有。这说得太好了，我之前没往这方面想。你是对的，肯定有重叠，因为处于这种模式的人往往会聚在一起。我也是一名天使投资人，投资了很多公司。Lenny，你和我一起投资过好几家公司。情况就是这样：这关乎那些在世界观上处于同一频率、并想去做有趣事情的人。我认为这才是推动故事向前发展的动力。

---

### (00:09:14) Lenny

**English:**
Speaking of technology optimism and technology in general, of the things that you've worked on, what would you say you're most proud of project wise, product wise, feature wise?

**中文翻译:**
说到技术乐观主义和技术本身，在你参与过的所有事情中，无论是项目、产品还是功能，你最引以为豪的是什么？

---

### (00:09:23) Manik Gupta

**English:**
Yeah. Again, I've had just the incredible opportunity to be part of phenomenal companies that have created world changing products. I had a small, small, small part to play in that. I always emphasize that. It's not me, it was a team. And I really mean it. I'm not just saying it because I'm on your podcast, but it truly is. I'm particularly proud of the work that I did both at Google and at Uber. I'll give you a couple of examples to illustrate that point.

**中文翻译:**
好的。再次强调，我非常幸运能加入这些创造了改变世界产品的卓越公司。我在其中只扮演了一个非常非常小的角色。我总是强调这一点：不是我，而是团队。我是认真的，不只是因为在录你的播客才这么说，事实确实如此。我特别为我在 Google 和 Uber 所做的工作感到自豪。我给你举几个例子来说明。

---

### (00:09:47) Manik Gupta

**English:**
When I joined Google in India in 2008, I started off working on Google Maps and I remember how counterintuitive it was for anybody; my friends and family, a bunch of other folks whom I talked to. Counterintuitive in terms of why would anybody ever use maps on their mobile phone in India? The reason was because the norm was that, firstly, the country's unmappable because there's no good addressing system. So how do you even look at places? Then the second one was there were always people around that you can just roll down your car window and just ask people, "Hey, I'm going here and can you just give me guidance or directions?" That was the norm. That's how people navigated for a really long time.

**中文翻译:**
2008 年我加入 Google 印度时，开始负责 Google 地图。我记得当时这对任何人来说都是非常反直觉的，包括我的亲朋好友。反直觉的地方在于：为什么在印度会有人在手机上用地图？原因在于，首先，这个国家被认为是“无法绘制地图”的，因为没有良好的地址系统，你甚至不知道怎么查找地点。其次，路上到处都是人，你只需要摇下车窗问一句：“嘿，我要去这里，你能指个路吗？”这就是常态，人们长期以来都是这样导航的。

---

### (00:10:32) Manik Gupta

**English:**
When I started working on it, I think for me, my belief was, again going back to the tech optimism aspect, is why can't we in India have the same quality maps like we have in the United States? Why not? Why shouldn't we do it? Why are users here not getting the same benefit and same productivity gain, if you will, and less stress in their daily commute and things like that?

**中文翻译:**
当我开始做这件事时，我的信念（再次回到技术乐观主义）是：为什么我们在印度不能拥有和美国一样高质量的地图？为什么不呢？为什么我们不去做？为什么这里的用户不能享受同样的便利、同样的效率提升，并减少日常通勤中的压力？

---

### (00:10:55) Manik Gupta

**English:**
So we started building it. We started building the data. We went ahead and really mapped the country as much as we could. Both ourselves and through a lot of amazing work from our users who co-mapped the world with us. Over time, India became, I think, the second largest country for Google Maps in the world in terms of users. Of course, a lot of that happened because of Android. Android took off and Android had Google Maps on it. But it's just incredible to see how, in a short span of a few years, it just went up to becoming so useful. It's not that we were just distributing Google Maps on Android, people were using it. People were actually using it to go from point A to point B.

**中文翻译:**
于是我们开始构建它，开始建立数据。我们尽可能地绘制了这个国家的地图，既靠我们自己，也靠大量热心用户与我们共同绘制。随着时间的推移，印度成为了 Google 地图全球用户量第二大的国家。当然，这很大程度上归功于 Android 的崛起，Android 预装了 Google 地图。但在短短几年内，看到它变得如此有用，真的很不可思议。这不仅仅是因为我们在 Android 上分发了 Google 地图，而是人们真的在用它，真的在用它从 A 点导航到 B 点。

---

### (00:11:35) Manik Gupta

**English:**
I feel really proud about that. I think the team did an incredible effort. It wasn't even a big team. It was a relatively small team, very passionate about going and doing this, and we made that happen.
(00:11:43):
Then at Uber, initially, before I took on the CPO role, I was leading maps and marketplace. When I was doing maps and marketplace, again, how do you get the ETA that you see on Uber when you open the Uber app and you request a car... The average ETA's went down to less than five minutes globally. Just think about that for a minute. In fact, it was 75 countries, more than 300 cities, if I remember correctly, where you could just open the Uber app and get an Uber in, average, less than five minutes. A lot of operational work need to happen for sure, but the technology, the marketplace technology especially to be able to connect the right rider to the right driver, have the mapping infrastructure underneath it to ensure that the car actually reaches you in that amount of time; I just feel very proud of all the work that happened during that time to make Uber really successful in terms of providing that kind of a service.

**中文翻译:**
我为此感到非常自豪。我认为团队付出了巨大的努力。那甚至不是一个大团队，而是一个相对较小、非常有激情的团队，我们实现了这个目标。
(00:11:43):
后来在 Uber，在我担任 CPO 之前，我负责地图和市场（Marketplace）业务。当时我们的目标是：当你打开 Uber 应用叫车时，如何缩短你看到的预计到达时间（ETA）……全球平均 ETA 降到了 5 分钟以下。想一想吧，如果我没记错的话，在 75 个国家、300 多个城市，你只要打开 Uber，平均不到 5 分钟就能打到车。这当然需要大量的运营工作，但技术——尤其是市场匹配技术，能够将正确的乘客连接到正确的司机，以及底层的地图基础设施，确保车辆真的能在那个时间内到达——我为那段时间让 Uber 成功提供这种服务的所有工作感到自豪。

---

### (00:12:37) Manik Gupta

**English:**
One fun anecdote I'll give you where my world came together and it just blows my mind even today, I remember I joined Uber in late 2015 and I made a trip to India to see my parents in sometime around 2016, 2017. I forget. It was around that time. And I was at home in Bangalore and I ordered an Uber. And the guy shows up, the driver comes in, and I sit in the back of the car. He starts the trip using the Uber app, and then he clicks Navigate and he goes to Google Maps. And I was sitting there. I was like, "Man, I built these two to a certain extent." It was just crazy to think about how two of my worlds came together at that point. I still vividly remember that moment where I felt really proud that I had a little bit of a part to play in both those products.

**中文翻译:**
我给你讲个有趣的轶事，那是我的两个世界交汇的时刻，直到今天想起来仍让我心潮澎湃。我记得我是 2015 年底加入 Uber 的，大约在 2016 或 2017 年左右，我回印度看望父母。当时我在班加罗尔的家里叫了一辆 Uber。司机来了，我坐在后座。他用 Uber 应用开始行程，然后点击“导航”，跳转到了 Google 地图。我坐在那里心想：“天哪，这两个产品在某种程度上都是我参与构建的。”想到我的两个世界在那一刻交汇，真是太疯狂了。我至今仍清晰地记得那个时刻，我为自己在这两款产品中都贡献了一份力量而感到非常自豪。

---

### (00:13:26) Lenny

**English:**
That is some unbelievable impact. It boggles my mind how many people have been impacted by the work that you've done on the teams that you've been on. Like a billion people in India and everyone in the world using Uber. It's unreal. I would feel very proud myself, watching that experience.
(00:13:41):
Something people may feel when they see a career like yours, they're like, "Man, Manik's just killing it. He's done everything. Everything just is clicking, always winning." I imagine there's been a few times when you've made mistakes or things have been really challenging. What would you say has been one of the more challenging projects or points in your career?

**中文翻译:**
这影响力真是令人难以置信。想到你所在的团队所做的工作影响了这么多人，我简直惊呆了。比如印度的十亿人口，以及全世界使用 Uber 的人。这太不可思议了。如果是我，看到那一幕也会感到非常自豪。
(00:13:41):
当人们看到像你这样的职业生涯时，可能会觉得：“天哪，Manik 简直太顺了。他搞定了一切，事事顺心，一直在赢。”但我猜肯定也有过犯错或者面临巨大挑战的时候。你认为职业生涯中最具挑战性的项目或时刻是什么？

---

### (00:13:59) Manik Gupta

**English:**
Yeah. No, absolutely. This is really important to talk about as well, because we glamorize successes and we don't talk enough about challenges. I'm really happy that you're asking this. I would give you two times which... I had a lot of learning from both of them, but they were pretty tough times for me. The first time was, I had started my own company at the height of the dotcom boom. We incorporated our company in June '99, and then in March of 2000 we sold our company to another company from Norway. That was the peak of the dotcom boom. Then within a few months right after that, we had the dotcom bust and it was terrible. Terrible. I know we have a pretty bad economy right now. There's a lot of stuff going on. It was really bad, because people around me, my friends, were losing their jobs.

**中文翻译:**
是的，绝对有。谈论这些也非常重要，因为我们总是美化成功，而对挑战谈得不够。我很高兴你问这个问题。我会给你举两个例子，我从中学到了很多，但当时对我来说非常艰难。第一次是在互联网泡沫（dotcom boom）最鼎盛的时候创办了自己的公司。我们在 1999 年 6 月注册公司，然后在 2000 年 3 月把公司卖给了一家挪威公司。那是泡沫的顶峰。紧接着几个月后，互联网泡沫破裂了，情况非常糟糕。我知道现在的经济也不太好，发生了很多事，但当时真的很惨，我身边的朋友都在失业。

---

### (00:14:52) Manik Gupta

**English:**
Luckily we had some funding. We had secured some of our funding and we had had an acquisition. The parent company was pretty strong in terms of their balance sheet, so we could continue to do it. But things didn't get better, Lenny. 2000 went by, 2001 came in. We kept waiting for things to improve, but they never improved. So we had to pivot. We had to pivot as a company. My co-founders actually left the company at that point. I still wanted to be there, because I really believed that I can keep moving this company forward. Then I was working with the founders of the parent company. We pivoted multiple times, we tried a few things. I even relocated back from Singapore back to India to set up an engineering office so that we can get into a SaaS kind of a model versus an eCommerce company that we were.

**中文翻译:**
幸运的是，我们有一些资金，我们已经确保了一部分融资并完成了收购。母公司的资产负债表非常稳健，所以我们可以继续做下去。但情况并没有好转，Lenny。2000 年过去了，2001 年来了，我们一直在等好转，但从未发生。所以我们不得不转型。作为一家公司，我们必须转型。我的联合创始人当时都离开了公司。但我还想留在那儿，因为我坚信我能推动公司继续前进。后来我与母公司的创始人一起工作，我们转型了多次，尝试了很多东西。我甚至从新加坡搬回印度，建立了一个工程办公室，以便将我们从一家电子商务公司转型为 SaaS 模式。

---

### (00:15:35) Manik Gupta

**English:**
I tried many things over those two or three years. And remember, this was my first, quote unquote, "job" out of college. I was doing a lot of that and it was a very tough time. But at the same time I learned a lot. I learned a lot about myself, I learned a lot about managing ambiguity and just keeping people motivated through a tough time. A lot of that also has to come from keeping yourself motivated, because people can smell fear and pessimism from far. Just like optimism is infectious, so is pessimism. If you're not feeling great as a leader, people will see it. Absolutely. People are not stupid. You have to not fake it. You have to really be motivated to stick it out, and that's what I tried to do at least, and I learned a lot in that. That was one really challenging time for me.

**中文翻译:**
在那两三年里，我尝试了很多事情。记住，这是我大学毕业后的第一份“工作”。我做了很多尝试，那段时光非常艰难。但与此同时，我学到了很多。我更了解了自己，学会了如何管理模糊性，以及如何在困境中保持团队的动力。很大程度上，这源于保持自我激励，因为人们能从很远的地方嗅到恐惧和悲观。就像乐观具有传染性一样，悲观也是如此。如果你作为领导者感觉不好，人们会看出来的。绝对会，大家都不傻。你不能假装，你必须真正有动力坚持下去，这至少是我努力尝试去做的，我从中受益匪浅。那是对我来说非常具有挑战性的时期。

---

### (00:16:21) Manik Gupta

**English:**
Then the second one was, man, during Uber. 2017, 2018 was crazy at Uber. Oh my God. There were just so much going on with leadership changes, with the brand issues we were getting. For me, there were times when I would commute up from my house to the office, and while I'm in the car I will be listening to some news or whatever and I'll hear about things that happened at Uber that day from the news before I got to hear it from within the company. It was that crazy during that time. So again, a lot of chaos, a lot of churn at the company as well. It was something where you just had to keep your head down and just keep staying focused on what the core is.

**中文翻译:**
第二个挑战是在 Uber 期间。2017、2018 年的 Uber 简直疯了。天哪，领导层变动、品牌危机，各种事情接踵而至。对我来说，有时候我开车去上班，在车里听新闻，结果从新闻里听到了 Uber 当天发生的大事，而我还没从公司内部得到消息。那时候就是这么疯狂。所以，公司内部有很多混乱和人员流失。在那种情况下，你只能埋头苦干，专注于核心业务。

---

### (00:17:03) Manik Gupta

**English:**
I think that is where, Lenny, the optimism in me in terms of, what am I really doing? Is this a service that really benefits millions of people around the world? Are we creating true change? Those are things that I just have to dig deep into to make sure that I stay grounded on why am I here and why I remain to be here and then at the same time motivate my team. But yeah, those were the two really challenging times that I have encountered, at least in my career.

**中文翻译:**
Lenny，我认为正是在那种时刻，我内在的乐观主义发挥了作用：我到底在做什么？这项服务真的让全球数百万人受益吗？我们是在创造真正的改变吗？我必须深入思考这些问题，以确保我清楚自己为什么在这里，为什么留在这里，并同时激励我的团队。总之，这就是我职业生涯中遇到的两个非常具有挑战性的时期。

---

### (00:17:26) Lenny

**English:**
Those are awesome examples. I imagine a lot of founders are going through a lot of challenging times right now with the market, and imagine these experiences for you were really important and impacted your ability to take on bigger roles and bigger challenges in the future. Is that how you see it? These are important experiences to have over time as a product leader and just leader in general?

**中文翻译:**
这些例子太棒了。我想现在很多创始人也正因为市场环境经历着艰难时刻。我想这些经历对你来说非常重要，影响了你未来承担更大角色和挑战的能力。你是这么看的吗？作为产品领导者或通用领导者，这些是随时间推移必须经历的重要经验吗？

---

### (00:17:46) Manik Gupta

**English:**
Oh, absolutely. Because like I said, you learn a lot about yourself when you go through a situation like this. You learn both things that bother you or bring you down, and things that give you energy. It's sometimes counterintuitive to think about this. When you're going through a bad time, often then people will say, "Well, during a bad time I only learned things which are bad." But you also learn things that are good. Which is, maybe during a bad time you did something and you suddenly felt relieved or energized, and then you look at that and say, "Wait, I should do more of that even during a good time, because can you imagine the compounding power that I would get? Because stuff is good and I'm doing this and I'll feel even better."

**中文翻译:**
噢，绝对是。因为正如我所说，当你经历这样的情况时，你会学到很多关于自己的东西。你会发现哪些事情会困扰你或让你沮丧，哪些事情会给你能量。思考这一点有时是反直觉的。当人们处于困境时，往往会说：“在糟糕的时期，我只学到了糟糕的事情。”但你也会学到好的东西。也就是说，也许在糟糕的时期你做了某件事，突然感到宽慰或充满活力，然后你会反思：“等等，即使在顺境中我也应该多做这件事，因为你能想象那会产生多大的复利效应吗？因为环境本来就好，而我又在做这件事，感觉会更棒。”

---

### (00:18:26) Manik Gupta

**English:**
I learned a lot in terms of my own personal energy, things that get me going, things that really stop me in my tracks. And at the same time, how do you work with a team? How do you motivate them? How do you keep your head down and focus, versus getting distracted? What are some of the decisions you make around your product roadmap?
(00:18:47):
I'll give you an example. During my startup, when we were going through that, in order to motivate the team, one of the best tricks that I came up with, and I learned this from a bunch of other people also, is you just give a team a win. Winning really, really drives a lot of energy. We had a choice to make between launching something which will take six months, versus launching something that we can launch in a very small-ish kind of way, but launch it in a month. And we chose the latter, because when we did that, I remember people were giving high five to each other, people were saying, "Hey, you know what? This is great. We put something in front of customers." We had, I think, 10 customers who used it or something, because we were so soft-scaling that feature. But that didn't really matter. The point was that you get confidence from getting things out, putting it out there, and you feel good about being a builder and being someone who is actually creating a difference. That really grounds the team and focuses the team that there is some real value here.

**中文翻译:**
我学到了很多关于个人能量的东西：什么能让我前进，什么能让我停滞不前。同时，我也学会了如何与团队合作，如何激励他们，如何埋头专注而不被分心，以及如何围绕产品路线图做出决策。
(00:18:47):
我给你举个例子。在我的创业公司经历困境时，为了激励团队，我想到（也从别人那里学到）的一个最好的技巧就是：给团队一个“胜利”。胜利真的能带来巨大的能量。当时我们面临一个选择：是发布一个需要六个月才能完成的大功能，还是发布一个规模很小但一个月就能上线的功能。我们选择了后者。因为当我们上线那个功能时，我记得大家互相击掌，说：“嘿，你知道吗？这太棒了，我们把东西交到了客户手中。”当时可能只有 10 个客户在用，因为我们只是在小范围测试那个功能。但这并不重要。重点是，通过把东西做出来并发布出去，你获得了信心，你会因为自己是一个创造者、一个真正带来改变的人而感到自豪。这能让团队脚踏实地，并让他们专注于“这里确实有真正的价值”。

---

### (00:19:45) Manik Gupta

**English:**
Some of those things I picked up. Both going through that turbulent time, I picked up. And I have used that even in good times to make sure that we keep building good products.

**中文翻译:**
这些是我学到的一些东西。在经历那段动荡时期的过程中，我领悟到了这些。即使在顺境中，我也一直在运用这些方法，以确保我们持续打造优秀的产品。

---

### (00:19:56) Lenny

**English:**
That's such a good tactical tip. Find a win. Keep people motivated. Speaking of wins, coming back to Google Maps and Uber, they're probably two of the most widely used, successful consumer products in the world. I don't know if I can think of other products that are used by more people for this long. Then now at Microsoft you're helping Microsoft get more into consumer on the communications side. I imagine you know a thing or two about building successful consumer apps, and so I want to ask a couple questions along those lines. What are two or three surprising or counterintuitive things that you've learned about building consumer products?

**中文翻译:**
这真是一个非常棒的战术建议：寻找胜利，保持动力。说到胜利，回到 Google 地图和 Uber，它们可能是世界上使用最广泛、最成功的两款消费级产品。我想不出还有哪些产品能被这么多人使用这么久。现在你在微软，帮助他们在通信领域进一步拓展消费者市场。我想你对构建成功的消费级应用一定很有心得，所以我想问几个相关的问题。关于构建消费级产品，你学到了哪两三件令人惊讶或反直觉的事情？

---

### (00:20:32) Manik Gupta

**English:**
The good news is that there's just... Because of Twitter and a bunch of other channels, including your newsletter by the way, I feel like people are very well informed these days. And I love that.
(00:20:43):
Let me digress for a second and then I'll come back to your question. One thing that I'm observing a lot, Lenny, which I feel very, very happy about, is the quality of learning and insights and frameworks and best practices is so universal at this point. It used to be that you had to be in the Valley or being part of a small group of folks who are doing things at the cutting edge to have those crazy insights about how do you find product market fit and do all that kind of stuff. Today I talk to people from all over the world for various reasons, and it's incredible how fast people pick up all these insights and frameworks and then they apply them to their local setting and so on. I find that to be one of the most wonderful things ever.

**中文翻译:**
好消息是……由于 Twitter 和其他各种渠道，顺便也包括你的时事通讯，我觉得现在的人们消息非常灵通。我很喜欢这一点。
(00:20:43):
让我先跑个题，然后再回答你的问题。Lenny，我观察到一件让我非常高兴的事，那就是现在的学习质量、洞察力、框架和最佳实践已经变得非常普及。以前，你必须待在硅谷，或者属于那一小群处于前沿的人，才能获得关于“如何找到产品市场契合度”之类的独到见解。而今天，由于各种原因，我与来自世界各地的人交谈，令人惊讶的是，人们吸收这些洞察和框架的速度如此之快，并能将其应用到当地的环境中。我觉得这是有史以来最美妙的事情之一。

---

### (00:21:32) Manik Gupta

**English:**
I think folks like you have obviously played a big part, because you have global subscribers and you share some of the best practices. But just generally, that's actually a really good thing for the world, that people have so much access to clarity of thinking. And the best people are actually putting themselves out there, which is great.
(00:21:47):
In terms of the counterintuitive stuff, I think two things. One is building consumer products is very hard. I think people think it's easy, because each of us is a consumer. We think of ourselves as a good user, we think of our friends as users, we think of our family as users. And we say, "Well, if we just build it for ourselves and for our family and friends..." By the way, a lot of great consumer products started that way, so I'm not saying don't do that. But man, it's hard. It takes a long time to get things right. Because you're essentially trying to get so many things right when you're building a successful consumer product. You have to be able to reach out to a vast, heterogeneous set of users who have different needs, who have different perspectives. The go to market is always very interesting, because you can't force people to use your product. People have to choose you, you don't choose them. That's the part where... How do you drive virality? How do you drive that real love for a consumer product? And it has to create real value.

**中文翻译:**
像你这样的人显然发挥了很大作用，因为你有全球订阅者并分享最佳实践。但总的来说，这对世界是一件好事，人们有这么多途径获得清晰的思维。最优秀的人也愿意站出来分享，这太棒了。
(00:21:47):
至于反直觉的事情，我认为有两点。第一，构建消费级产品非常难。我觉得人们认为这很容易，因为我们每个人都是消费者。我们觉得自己是优秀的用户，觉得朋友和家人也是用户。我们会说：“好吧，如果我们只是为自己、为家人和朋友构建产品……”顺便说一下，很多伟大的消费级产品确实是这样开始的，所以我不是说不要这样做。但是，天哪，这真的很难。要把事情做对需要很长时间。因为在构建成功的消费级产品时，你本质上是在试图把太多事情同时做对。你必须能够触达庞大且异质的用户群体，他们有不同的需求和视角。进入市场（Go-to-market）总是很有趣，因为你不能强迫人们使用你的产品。是人们选择你，而不是你选择他们。这就是难点所在：你如何驱动病毒式传播？你如何让用户对产品产生真正的热爱？而且它必须创造真正的价值。

---

### (00:22:52) Manik Gupta

**English:**
The other thing about time is that, in order for you to find product market fit and then scale from there, you just have to try a lot of different things. There are theoretical playbooks around it, but you got to just get into it. Going back to the point I was making earlier about wins, get some wins and see the results and then iterate from there. I think it's just hard and it takes a lot longer than what people imagine consumer products do. Versus, let's say, enterprise products or products of other nature. That's one counterintuitive thing that at least I've learned.

**中文翻译:**
关于时间的另一件事是，为了找到产品市场契合度并以此为基础进行规模化，你必须尝试很多不同的东西。虽然有理论上的剧本，但你必须亲身实践。回到我之前提到的关于“胜利”的观点：获得一些小的胜利，观察结果，然后以此进行迭代。我认为这很难，而且花费的时间比人们想象的要长得多，尤其是与企业级产品或其他性质的产品相比。这是我学到的一个反直觉的点。

---

### (00:23:21) Manik Gupta

**English:**
The second one is the global patterns that you see in consumer products in terms of the user interface; the core things that people do or expect. At this point along of that is pretty universal. There's always this debate where people would say, "Well, need to have one product for the U.S., another different type of product for Asia, another different type of product for Africa. I think we are past that point. That's again another counterintuitive thing, where people spend a little too much... I've seen this in many companies. People spend too much time debating that, "Oh, the users in market X are different." Well yes, they're different, but they use the product the same way.

**中文翻译:**
第二点是你在消费级产品中看到的全球化模式，特别是在用户界面（UI）方面；人们的核心行为或期望。在这一点上，很多东西是非常通用的。总是有这样的争论，人们会说：“我们需要为美国做一个产品，为亚洲做另一个不同的产品，为非洲再做一个。”我认为我们已经过了那个阶段。这又是另一个反直觉的事情。我看到很多公司的人花太多时间争论：“噢，X 市场的用户是不同的。”是的，他们是不同，但他们使用产品的方式是一样的。

---

### (00:24:02) Manik Gupta

**English:**
That's the part which I think... And I'm not making an argument against localization. Of course you need localization around language, pricing. There are some legal requirements, all of that stuff. Obviously you have to do that, otherwise you don't even have a right to exist in that market. But by and large the patterns are very similar. You look at global products, even like Facebook or Google Search or Maps or Twitter or TikTok and so on, all of them have a similar pattern or similar app for the entire world, and they keep on innovating or localizing at the edges.

**中文翻译:**
这就是我想表达的……我并不是在反对本地化。当然，你需要在语言、定价方面进行本地化，还有一些法律合规要求，这些都是必须做的，否则你甚至没有权利在那个市场生存。但总的来说，模式是非常相似的。你看那些全球性产品，比如 Facebook、Google 搜索、地图、Twitter 或 TikTok 等，它们在全世界都有类似的模式或应用，它们只是在边缘进行持续创新或本地化。

---

### (00:24:33) Manik Gupta

**English:**
That's the other counterintuitive thing that people should know about consumer products. Build for the world from day one. Understand that there are going to be some nuances that you'll have to solve as you drive adoption in certain markets, but don't over index on building market specific solutions, because consumers have moved on from that kind of a model. Those are the two, in terms of product building, counterintuitive trends at least I have picked up over the years.

**中文翻译:**
这是人们应该了解的关于消费级产品的另一个反直觉点：从第一天起就为全球构建。要明白在某些市场推动采用时，会有一些细微差别需要解决，但不要过度投入去构建特定市场的解决方案，因为消费者已经不再受限于那种模式了。这些是我多年来在产品构建方面总结出的两个反直觉趋势。

---

### (00:25:02) Lenny

**English:**
This episode is brought to you by Unit. What did Gusto, Uber, Shopify, and AngelList all have in common? They've all decided to build banking into their product. According to AngelList head of product, banking makes every single feature more interesting. With it our platform functions as financial mission control for our customers. Without it we're just another software tool in a big messy stack. Embedding banking into your product not only adds differentiation, but also helps you acquire, retain, and monetize your customers. Unit is the market leader in banking as a service. Combining multiple bank partners with a developer friendly API to empower companies of all sizes to launch accounts, cards, payments, and lending in just a few weeks. Unit is trusted by leading brands such as AngelList, IB, Invoice2Go, and Roofstock. To hear more about how Unit enables companies like yours to build banking, visit unit.co/lenny to request a demo or to try their free sandbox. That's unit.co/lenny.

**中文翻译:**
本期节目由 Unit 赞助。Gusto、Uber、Shopify 和 AngelList 有什么共同点？他们都决定将银行业务（banking）内置到自己的产品中。据 AngelList 的产品负责人称，银行业务让每一个功能都变得更有趣。有了它，我们的平台就像是客户的财务控制中心；没有它，我们只是庞杂技术栈中的又一个软件工具。将银行业务嵌入你的产品不仅能增加差异化，还能帮助你获取、留存客户并实现变现。Unit 是“银行即服务”（BaaS）领域的市场领导者。它结合了多家银行合作伙伴和开发者友好的 API，赋能各种规模的公司在短短几周内推出账户、卡片、支付和贷款业务。Unit 深受 AngelList、IB、Invoice2Go 和 Roofstock 等领先品牌的信赖。想了解 Unit 如何帮助你的公司构建银行业务，请访问 unit.co/lenny 申请演示或尝试免费沙盒。

---

### (00:26:04) Lenny

**English:**
Before this chat, we were chatting about this idea of company product fit for bigger companies. How it's an approach to building new products within big companies. Can you just talk about that idea?

**中文翻译:**
在这次聊天之前，我们聊到了大公司的“公司产品契合度”（Company Product Fit）这个概念。这是在大公司内部构建新产品的一种方法。你能谈谈这个想法吗？

---

### (00:26:17) Manik Gupta

**English:**
Yeah, absolutely. I've been noodling a lot on this, especially since I took on my role at Microsoft as well. And prior to that, even at Google, this was always an interesting discussion. Let's say you are building a new product or leading a new project, if you will, at a larger company. In fact, this also applies to medium-sized companies. I wouldn't say for startups, but medium-sized companies. Usually the narrative in the room when you're discussing this with your team and with your leadership team would be, "Okay, we got to go find product market fit." Absolutely. Yeah. We have to do a bunch of stuff, as we just talked about. Consumer products take time. All of that stuff.

**中文翻译:**
是的，当然可以。我一直在思考这个问题，特别是在我入职微软之后。在此之前，甚至在 Google，这始终是一个有趣的讨论话题。假设你在一家大公司构建新产品或领导一个新项目。事实上，这也适用于中型公司，我不确定是否适用于初创公司，但中型公司肯定适用。通常，当你与团队和领导层讨论时，大家会说：“好，我们得去找产品市场契合度（PMF）。”没错，正如我们刚才讨论的，我们需要做很多工作，消费级产品需要时间，等等。

---

### (00:26:57) Manik Gupta

**English:**
But I think there's a question before that question, which is how do you find company product fit? What I define as company product fit. Which is a company essentially is a portfolio of products, and every large company, medium-sized company also has a portfolio. They'll have 10, 20, in some cases hundreds of products in the portfolio. Every company has unique strengths and weaknesses. This is pretty tried, but it's obvious. And I would encourage a lot of folks, when they start embarking on this journey where they're trying to really build out products and so on, is to ask that question. How does that product, assuming it's successful... If it is not successful, it doesn't matter anyway. But assuming it's successful, does it actually serve the right place in a company's product portfolio? Or not? And if it doesn't, don't do it. Why waste time?

**中文翻译:**
但我认为在那个问题之前还有一个问题，那就是：你如何找到“公司产品契合度”？我将其定义为：一家公司本质上是一个产品组合，每家大公司、中型公司都有自己的组合。他们的组合中可能有 10 个、20 个，甚至数百个产品。每家公司都有独特的优势和劣势。这虽然是老生常谈，但显而易见。我鼓励很多人在开始构建产品时问这样一个问题：假设这个产品成功了（如果不成功也无所谓），它在公司的产品组合中是否占据了正确的位置？如果不是，那就别做。为什么要浪费时间？

---

### (00:27:57) Manik Gupta

**English:**
Oftentimes companies will be like, "I want to do this because some other company is doing it." That is not a good reason. You should only invest in products, or projects for that matter, because you can play to your strengths and you can create some unique consumer, customer value. And by the way, you can do it better than anybody else out there. That's what I mean by company product fit. Take that first step and understand does this even resonate and is it part of the portfolio? Does it make sense?

**中文翻译:**
通常公司会说：“我想做这个，因为别的公司也在做。”这不是一个好理由。你投资产品或项目，应该是因为你能发挥自己的优势，并能创造独特的消费者或客户价值。而且，顺便说一下，你能比外面任何人都做得更好。这就是我所说的“公司产品契合度”。迈出第一步，弄清楚这是否能引起共鸣，是否属于产品组合的一部分？它是否有意义？

---

### (00:28:26) Manik Gupta

**English:**
Because if you can answer that question with enough conviction, then your road to the next step on finding product market fit becomes much easier, because you don't have distractions then. Everybody gets it. Everybody gets this is a strategic effort. You have the right sponsorship at the right levels in the company, and you're executing towards it and you're finding it out. Let's say things don't go well. That's okay. People will step in to help. A lot of that will happen, because people innately get it. That this is the right product to go after from a company product fit perspective. That's something that I've been thinking a lot about and also executing as we move forward.

**中文翻译:**
因为如果你能带着足够的信念回答这个问题，那么你寻找产品市场契合度的下一步就会变得容易得多，因为你没有了干扰。每个人都明白，每个人都理解这是一项战略任务。你在公司各个层面都有正确的支持，你正朝着这个方向执行并探索。假设事情进展不顺，那也没关系，人们会介入帮忙。这之所以会发生，是因为大家打心底里明白：从公司产品契合度的角度来看，这是值得追求的正确产品。这是我一直在思考并付诸实践的事情。

---

### (00:29:00) Lenny

**English:**
Is there an example of that gone wrong that you can share? Whether it's a company you've worked at or a company you've seen do it badly.

**中文翻译:**
你能分享一个失败的例子吗？无论是在你工作过的公司，还是你见过的做得不好的公司。

---

### (00:29:05) Manik Gupta

**English:**
I'll have to think through specific examples, but companies do this all the time, where they do these line extensions. Where they'll say, "Well, we have a lot of traction in a particular segment. Why don't we just go to an adjacent segment? If we just add two more features, suddenly this will be appealing to an adjacent segment." A classic example would be you're doing something for, I don't know, small and medium businesses and you say, "Well, now I just have to add two more features and now I'm going to go up market and I'll get to compete in the enterprise." Or it could be the other way around too, where you have something in the enterprise business and you want to suddenly go down market to SMB.

**中文翻译:**
我得仔细想想具体的例子，但公司经常犯这种错，比如做“产品线延伸”。他们会说：“我们在某个细分市场很有吸引力，为什么不进入相邻的市场呢？只要再加两个功能，它突然就会对相邻市场产生吸引力。”一个经典的例子是，你正在为中小型企业（SMB）做产品，然后你说：“现在我只需要增加两个功能，就能进入高端市场，去和企业级产品竞争。”或者反过来，你有一个企业级业务，突然想下沉到中小型企业市场。

---

### (00:29:44) Manik Gupta

**English:**
In my view, it's hard. Because again, the capabilities that you need, the thinking that you need, is something you have to really be clear about. This is not to say that it will not fit in the company's portfolio. It's just that when you're making a choice like that, make sure you set it up well to succeed. That's the other part of the equation as well.

**中文翻译:**
在我看来，这很难。因为你所需要的能力和思维方式，是你必须非常明确的。这并不是说它不符合公司的产品组合，而是说当你做出这样的选择时，要确保你为它的成功做好了充分的准备。这是问题的另一面。

---

### (00:30:02) Lenny

**English:**
Speaking of setting it up to succeed, you also have this idea of a consumer stack concept that I think you've been talking about at Microsoft. Can you talk about what that's all about?

**中文翻译:**
说到为成功做好准备，你还有一个“消费者技术栈”（Consumer Stack）的概念，我想你一直在微软谈论这个。你能谈谈那是怎么回事吗？

---

### (00:30:11) Manik Gupta

**English:**
Yeah, sure. One of the things that I'm doing at Microsoft right now is, while I'm working on a lot of the consumer communication products, the other thing that I'm really helping the company think about is how do we get more at scale consumer products built at Microsoft. Part of this is just distilling some of the learnings that I've had over the years. I think there are like five things that I would talk about, which I call the consumer stack, which is essentially a set of capabilities that companies need to have a good chance of success at building a consumer product. Remember, nobody can give a playbook to build a successful consumer product. That does not exist. Because as we were discussing earlier, it's so fickle and so many things have to go right for you to build a successful consumer product. But at least you have a set of capabilities, so you set yourself up the best.

**中文翻译:**
好的。我在微软目前的工作之一是负责消费级通信产品，另一件事是帮助公司思考：如何在微软构建更多大规模的消费级产品。这部分工作就是提炼我多年来的一些心得。我认为有五件事可以谈，我称之为“消费者技术栈”，它本质上是公司在构建消费级产品时，为了获得成功机会而需要具备的一系列能力。记住，没有人能提供构建成功消费级产品的万能剧本，那是不存在的。因为正如我们之前讨论的，消费级产品变幻莫测，必须有很多事情同时做对才能成功。但至少如果你具备了一系列能力，你就能为自己创造最好的条件。

---

### (00:31:01) Manik Gupta

**English:**
The first one I would say is around design-led thinking to delight users. Going back to your days at Airbnb, Lenny, I'm sure this is something that resonates with you. Design for consumer products is such a critical part of how you build the right pull from consumers these days. Poorly designed products have no chance at this point. Your craftsmanship and the design capabilities have to be A plus. And if you don't have that, then you should really invest in that. This is not just about having the best designers. Of course you should. It's just the thinking. It's a attention to detail. It's the attention to how things are pixel to pixel, moving from one screen to another screen and so on. You really have to sweat it out and really be clear in terms of how it's adding value to a consumer. That is, I think, a core capability in these days to build a consumer product. That's number one.

**中文翻译:**
第一点是“设计驱动思维”以取悦用户。Lenny，回到你在 Airbnb 的日子，我相信这一定会引起你的共鸣。对于现在的消费级产品来说，设计是构建用户吸引力的关键部分。设计糟糕的产品现在根本没有机会。你的工艺水平和设计能力必须是 A+ 级的。如果你没有，那就应该在这方面投入。这不仅仅是拥有最好的设计师，当然你也需要他们，更重要的是一种思维方式。是对细节的关注，是对像素级体验的关注，是屏幕之间切换的流畅度等等。你必须在这些细节上挥洒汗水，并明确它如何为消费者增加价值。我认为这是当今构建消费级产品的核心能力。这是第一点。

---

### (00:31:54) Manik Gupta

**English:**
Number two is strong focus and prioritization. You can apply strong focus and prioritization to anything in life, but I think it's even more important for consumer products. Because oftentimes people, when they think about solving a problem, they think about coming up with 20 features at the same time, and it's not needed. You don't need 20 features to solve a problem. You just need one or two features which work really well. This whole concept of critical user journeys. How do you make sure that, if you're solving problem X, any feature that you build in the product... Firstly your product should have very few features in the beginning. But even if it has those features, it should be well designed and it should have the focus and prioritization so that you're only getting things for the critical journey so that the user can use it and not get confused. That's the second one.

**中文翻译:**
第二点是“强大的专注力和优先级排序”。你可以将这一点应用到生活中的任何事情上，但我认为它对消费级产品尤为重要。因为通常人们在思考解决问题时，会想到同时推出 20 个功能，但其实没必要。你不需要 20 个功能来解决一个问题，你只需要一两个运行良好的功能。这就是“关键用户旅程”（Critical User Journeys）的概念。如何确保如果你在解决问题 X，你在产品中构建的任何功能……首先，你的产品在开始时应该只有极少数功能。但即使有了这些功能，它们也应该是经过精心设计的，并且具有明确的专注点和优先级，这样你才能只为关键旅程提供功能，让用户能够使用而不感到困惑。这是第二点。

---

### (00:32:38) Manik Gupta

**English:**
Most PMs totally understand that. That's their job description, to focus and prioritize. But I feel like a lot of times the PMs do get very confused and distracted, because the number of ideas that people have is so large that they want to just throw everything into the product, and that doesn't work. You have to keep a very high bar for focus and prioritization. That's capability number two.

**中文翻译:**
大多数产品经理（PM）都完全理解这一点，这是他们的职责所在：专注和排序。但我感觉很多时候 PM 确实会感到困惑和分心，因为人们的想法太多了，以至于他们想把所有东西都塞进产品里，但这行不通。你必须对专注和优先级排序保持极高的标准。这是第二项能力。

---

### (00:33:00) Manik Gupta

**English:**
Number three is having the right metrics and instrumentation. This talks to the data aspect of the culture, which is, if you don't have the metric with regards to what you're optimizing for at the initial state of the product, middle state of the product, late stage of the product, you're just not going to choose the right things. How will you measure success? How will you convince yourself, your team, and broader stakeholders that this is actually working or not working? Having the right metrics is important, but it's incredible how many times people have the metrics but they don't instrument them. They'll have all these debates, because the product is not instrumented properly. And everybody will talk about the same metric, but they'll have different nuances in terms of, "Oh, what does it really mean? What is a daily active user? Okay, daily means... Okay, I understand it's on a daily basis. What is active?" And there'll be debates about what is active. Pick a definition, instrument it, codify it. No confusion. That's number three.

**中文翻译:**
第三点是“拥有正确的指标和埋点（instrumentation）”。这涉及文化的指标数据方面。如果你在产品的初始阶段、中期阶段和后期阶段没有明确的优化指标，你就无法做出正确的选择。你如何衡量成功？你如何说服自己、团队和更广泛的利益相关者，证明这确实有效或无效？拥有正确的指标很重要，但令人难以置信的是，有多少次人们有了指标却不进行埋点。他们会进行各种辩论，仅仅是因为产品没有正确埋点。每个人都在谈论同一个指标，但理解却有细微差别，比如：“噢，这到底是什么意思？什么是日活用户（DAU）？好吧，‘日’的意思我懂，那什么是‘活跃’？”然后就会关于什么是“活跃”产生争论。选定一个定义，进行埋点，将其代码化。不要有歧义。这是第三点。

---

### (00:33:59) Manik Gupta

**English:**
Number four is more on the engineering side, which is how do you get to a very high ship velocity, and the ability to experiment and learn fast. At a broader level, especially during the initial phases, if you're not learning, you are really not doing anything well. You've got to be learning. You've got to be learning good things, bad things, doesn't matter. You've got to be learning. Having the experimentation velocity, having a building culture where engineers are able to check in code, see the results, and then quickly come into another release and stuff like that, I think that's really important for a consumer product.

**中文翻译:**
第四点更多是在工程方面，即如何实现极高的“发布速度”（ship velocity），以及快速实验和学习的能力。从更广泛的层面来看，特别是在初始阶段，如果你没有在学习，那么你其实什么都没做好。你必须在学习，学到好的东西、坏的东西，这都不重要，重要的是你在学习。拥有实验速度，拥有让工程师能够提交代码、查看结果并迅速进入下一个版本的构建文化，我认为这对消费级产品至关重要。

---

### (00:34:29) Manik Gupta

**English:**
Finally, underpinning all of this is just having strong talent. Assess your talent; your product talent, your design talent, your data talent, your engineering talent, your marketing talent, all these functions. You just have to have a talented pool of people who like to build stuff, and they're the people who understand and have the empathy for consumers.
(00:34:50):
To me, I think these five capabilities... And as a leader, or product leader, or an engineering leader, or anyone who's basically responsible for running products in small company, big company, medium-sized company, it doesn't matter; if you're in the consumer space, my thinking here is that if you look at these five categories and five capabilities, you should really have a report card and say, "Okay. How do I rate these?" If I were to look at my own team, what do I think about design thinking? What do I think about strong focus and prioritization? Are we doing an A job? Are we doing a B job? Are doing a C job or D job? I would argue that if you get to an A job over time, because not everybody will be at A on day one, but if you get that over time, I think you will start seeing results which are very meaningful. That's how I've been thinking about the consumer stack.

**中文翻译:**
最后，支撑这一切的是“强大的人才”。评估你的人才：产品人才、设计人才、数据人才、工程人才、营销人才，所有这些职能。你必须拥有一群喜欢创造东西的人才库，他们是理解并对消费者有同理心的人。
(00:34:50):
对我来说，我认为这五项能力……作为领导者、产品领导者、工程领导者，或者任何负责在小公司、大公司、中型公司运营产品的人，只要你在消费者领域，我的想法是：如果你审视这五个类别和五项能力，你应该给自己一个成绩单，问问：“好，我该如何给这些打分？”如果我观察自己的团队，我对设计思维怎么看？对强大的专注力和优先级排序怎么看？我们做得是 A 级、B 级、C 级还是 D 级？我认为，如果你能随着时间的推移达到 A 级（因为不是每个人第一天都能达到 A），你就会开始看到非常有意义的结果。这就是我对“消费者技术栈”的思考。

---

### (00:35:34) Lenny

**English:**
Awesome. I was going to ask how you operationalize this. It sounds like it's going to turn into Manik's consumer stack scorecard, and bigger companies can leverage this at their own company and show their manager, "Hey, we're moving really slowly. Maybe this is an area we should focus before we bet big on consumer."

**中文翻译:**
太棒了。我正想问你如何将其付诸实践。听起来这会变成“Manik 的消费者技术栈计分卡”，大公司可以在内部利用它向经理展示：“嘿，我们进展太慢了。也许在我们在消费者领域大举投入之前，这是我们需要关注的领域。”

---

### (00:35:50) Manik Gupta

**English:**
Yeah. I'm trying to operationalize this myself right now in my current job, and I have used some version of this. I mean, this is not something I just came up with. It's something that has been in my mind for a while. I've used it in some shape or form. But during my break, especially before I joined Microsoft, I think this came together for me as something a little bit more tangible that I can use. Then I started applying it, so I think it's been pretty interesting to see.

**中文翻译:**
是的。我现在就在目前的工作中尝试将其付诸实践，我以前也用过类似的版本。我的意思是，这不只是我突然想出来的，而是在我脑海中存在了一段时间的东西。我曾以某种形式使用过它。但在我休息期间，特别是在加入微软之前，我认为它变得更加具体、可操作了。然后我开始应用它，看到结果非常有趣。

---

### (00:36:15) Lenny

**English:**
Awesome. I'm hoping that this proliferates through larger companies and becomes a thing that we can root back to this chat.
(00:36:23):
Shifting a little bit to the CPO role and the VP of product role that you've had at a few companies, in theory this is kind of an end state for a product leader. Every PM, if they stay down the PM career track, they'll become a CPO or VP of product or head of product somewhere. A couple of questions here. One is, do you have a sense of how many PMs actually stay on this track and end up in one of these roles, versus move on to some other role or place?

**中文翻译:**
太棒了。我希望这能在更多大公司中传播开来，并成为我们可以追溯到这次谈话的一件事。
(00:36:23):
稍微转向你曾在几家公司担任过的 CPO 和产品副总裁角色。理论上，这是产品领导者的“终极状态”。每个 PM 如果坚持走 PM 职业道路，最终都会在某个地方成为 CPO、产品副总裁或产品负责人。这里有几个问题。第一，你是否了解有多少 PM 实际上坚持走这条路并最终获得这些职位，而不是转向其他角色或领域？

---

### (00:36:47) Manik Gupta

**English:**
Yeah. That's a great question. I would say that the percentage for CPO in particular, you having a C title and being a CPO, I think that percentage is still relatively small. This is just my sense. I haven't done the numbers to give you a more accurate picture here, but I think my sense is relatively smaller. Because I think a large part of it depends on how companies are organized. Companies can be organized functionally, companies can be organized through business units, and oftentimes these days it's a mix of both. If you look at any company, they'll have some C level functional executives, but underneath them they'll have GMs. The organization design is just such an evolving field always. And as they say, companies will go one... they'll swing the pendulum one way and they'll say, "Oh, over time it's not working," and then they'll swing the pendulum the other way and then they keep going back and forth. I think the percentage for CPO in particularly in my mind is probably not as big as what people think it is. Like I said, because of the way that companies are organized.

**中文翻译:**
是的，这是一个好问题。我会说，特别是 CPO 这个职位——拥有 C 开头的头衔并担任 CPO——我认为这个比例仍然相对较小。这只是我的感觉，我没有具体的数据来提供准确的图景，但我觉得比例相对较小。因为我认为很大程度上取决于公司的组织方式。公司可以按职能组织，也可以按业务单元（BU）组织，而现在通常是两者的混合。如果你观察任何一家公司，他们会有一些 C 级的职能高管，但在他们之下会有总经理（GM）。组织设计一直是一个不断演变的领域。正如人们所说，公司会像钟摆一样摆动：先朝一个方向摆，过一段时间觉得不行，再朝另一个方向摆，如此反复。我认为 CPO 的比例可能没有人们想象的那么大，正如我所说，这是因为公司的组织方式。

---

### (00:37:50) Manik Gupta

**English:**
I think the interesting thing here is I am just seeing personally, having been a CPO myself and also talking to a lot of people in my network and just observing a bunch of different companies, I think the CPO role is evolving. Or the head of product role is also evolving. I think a lot of it is morphing more into the GM model where you're running not just product management but also perhaps PM and engineering, and design to a certain extent and data science too. You're essentially becoming the overall technical product leader at the company.

**中文翻译:**
我认为有趣的是，根据我担任 CPO 的个人经历，以及与圈内人的交流和对不同公司的观察，我认为 CPO 的角色正在演变。或者说产品负责人（Head of Product）的角色也在演变。我认为很大一部分正在向 GM（总经理）模式转变，你不仅负责产品管理，可能还负责 PM 和工程，甚至在某种程度上还负责设计和数据科学。你本质上成为了公司的整体技术产品领导者。

---

### (00:38:27) Manik Gupta

**English:**
The reason why I feel that is happening is because it's all about accountability. It's about who has the single threaded leadership model where this person can make all the decisions when it comes to trade offs and running the roadmaps and all of that kind of stuff. It's not ideal, by the way, in all cases. Because what that means is, for somebody to be doing that, that person has to be really, really good at all those other functions too so that everyone who is in their organization respects that. Otherwise people feel like I'm the second class citizen in this model where this person doesn't know anything about, whatever; my function and so on. So it's harder, but I do feel that for optimization around decision making, around having a single threaded leadership and accountability, I feel like that's the direction where the product leadership role itself is going more and more. At least based on my experience.

**中文翻译:**
我觉得之所以发生这种变化，是因为这关乎“问责制”（accountability）。这关乎谁拥有“单线程领导模式”（single threaded leadership，亚马逊提出的概念），即这个人可以在权衡利弊、执行路线图等方面做出所有决定。顺便说一下，这并非在所有情况下都是理想的。因为这意味着，要做到这一点，那个人必须在所有其他职能领域也非常优秀，这样组织中的每个人才会尊重他。否则，人们会觉得在这个模式下自己是“二等公民”，因为领导者对我的职能一窍不通。所以这更难，但我确实觉得，为了优化决策、实现单线程领导和明确问责，产品领导角色本身正越来越多地朝这个方向发展。至少根据我的经验是这样的。

---

### (00:39:19) Lenny

**English:**
Is your sense that maybe CPO might fade away as a title and GMs become the common path across companies?

**中文翻译:**
你的感觉是 CPO 这个头衔可能会逐渐消失，而 GM 成为各家公司的通用路径吗？

---

### (00:39:26) Manik Gupta

**English:**
If you were to push me on this, I would say that's probably the direction we will go. I think it's interesting to also think about CTO. If you look at the CTO roles versus SVP of engineering or a VP of engineering, I think it's an interesting debate too, what's happening with CTO roles. If a company is organized purely functionally, I think that's absolutely the right call. But as companies are changing and thinking about how they drive more accountability and more business units and so on, I just feel it probably will become more GM oriented. That does not mean that the VP product is going to go away or the VP engineering is going to go away. I think those roles will still stay. But the C-level title, reporting into the CEO but you're just running that one function; if I look at over time, maybe that role is lot less prevalent than what we have right now.

**中文翻译:**
如果你非要我表态，我会说这可能是未来的方向。思考 CTO 的角色也很有趣。如果你对比 CTO 与工程高级副总裁（SVP）或工程副总裁（VP），关于 CTO 角色的演变也是一个有趣的辩论。如果一家公司纯粹按职能组织，那 CPO/CTO 绝对是正确的选择。但随着公司不断变化，思考如何推动更多问责制和业务单元化，我觉得它可能会变得更加以 GM 为导向。这并不意味着产品副总裁或工程副总裁会消失，这些角色仍会存在。但那种直接向 CEO 汇报、仅负责单一职能的 C 级头衔，随着时间的推移，可能会比现在少得多。

---

### (00:40:15) Lenny

**English:**
Do you think that's partly because there's this weird overlap between CPO and CEO, and there's often tension of who's leading the product? Is that something you've seen?

**中文翻译:**
你认为这部分是因为 CPO 和 CEO 之间存在某种奇怪的重叠，并且经常在“谁在领导产品”上产生紧张关系吗？这是你见过的现象吗？

---

### (00:40:24) Manik Gupta

**English:**
Yeah. I think that's definitely an interesting one as well. I mean, if you think about it, just based on my experience, what does the CPO really do? What is their job description? I think it's useful to think through that. Generally speaking, and again, we can always talk in generalizations because that's how you should think. And every company is unique. But generally you would say the CPO is responsible for driving the product vision for the company, and that product vision cannot be divorced from the company vision. Oftentimes this is actually what also creates conflict within the leadership team, where the product vision is... people are coming up with these grandiose plans. Like, "Oh, we'll do this, we'll do that," but then it's not really grounded in the reality of where the company is. Anyways, it's around product vision and making sure it's coherent with the company vision.

**中文翻译:**
是的，我认为这绝对也是一个有趣的点。根据我的经验，CPO 到底在做什么？他们的职位描述是什么？思考这些很有用。一般来说（我们总是可以用概括的方式来谈论，因为这是思考的方式，尽管每家公司都是独特的），你会说 CPO 负责推动公司的产品愿景，而产品愿景不能脱离公司愿景。通常这正是领导团队内部产生冲突的原因：产品愿景太宏大了，人们提出各种宏伟计划，比如“我们要干这个，我们要干那个”，但并没有真正立足于公司的现实。总之，核心是产品愿景，并确保它与公司愿景保持一致。

---

### (00:41:09) Manik Gupta

**English:**
Then the second big part of a CPO job is execution of the roadmap on the priorities. People sometimes think that, hey, I get to a C-level position. I don't have to worry about execution. Absolutely not. If you're a CPO in particular, even the CTO and the head of engineering, execution matters a lot. The operational excellence. Because things are so complex. I mean, we are in a situation where a lot of people are working remotely, there are all these different tool sets, there are all these different technologies that are coming up, you have different competitors. Execution is super important. And if people don't understand that that's a big part of their job when they get to the senior level, I think they're mistaken. The execution is another one.

**中文翻译:**
CPO 工作的第二个重要部分是路线图优先级的执行。人们有时会认为，嘿，我到了 C 级职位，就不需要担心执行了。绝对不是。特别是如果你是 CPO，甚至是 CTO 和工程负责人，执行都非常重要。也就是运营卓越性。因为事情太复杂了。我们现在处于很多人远程办公的环境中，有各种不同的工具集，有不断涌现的新技术，还有不同的竞争对手。执行至关重要。如果人们不理解到了高层这仍然是工作的重要组成部分，我认为他们就错了。执行是另一个重点。

---

### (00:41:50) Manik Gupta

**English:**
The third is, for a CPO, especially for a tech company, because you are really driving the product roadmap, it's a very leveraged job. Meaning you have to really work with all your other peers, whether the marketing person, or the sales person, or the business unit person and so on, and just make sure that you are really even deeply connected in terms of what is really needed, so that your product roadmap is how things are going to actually come to life. It's a very cross-functional, on steroids kind of job in that sense.

**中文翻译:**
第三点，对于 CPO，特别是科技公司的 CPO，因为你实际上在推动产品路线图，这是一份非常有杠杆作用的工作。这意味着你必须与所有其他同事紧密合作，无论是营销人员、销售人员还是业务单元负责人等等，确保你深入了解真正的需求，从而让你的产品路线图成为现实。从这个意义上说，这是一份极度跨职能、高强度的工作。

---

### (00:42:19) Manik Gupta

**English:**
In terms of the CEO, CPO, I think the important thing again is... And this is actually advice I've given to CEOs of some companies as well, when they first start looking for a VP of product or a CPO. This is almost like a questionnaire that I give them. The first question I ask the CEO is, what do you want to do? That's the most important question. Because a lot of times the CEO has either been the technical founder, or they have been the product founder. They can be a sales founder too. All that is fine. But what do you want to spend your time on? Because if you are going to get a CPO or a VP of product and then still want to own the product roadmap and own the execution, then don't do that. Because what is that person going to do? That's the first question that I tend to clarify between a CEO who's looking for a CPO or VP of product.

**中文翻译:**
关于 CEO 和 CPO 的关系，我认为重要的一点是……这也是我给一些正在寻找产品副总裁或 CPO 的 CEO 的建议。我几乎会给他们一份调查问卷。我问 CEO 的第一个问题是：“你想做什么？”这是最重要的问题。因为很多时候 CEO 要么是技术创始人，要么是产品创始人，也可能是销售背景的创始人。这些都没问题。但你想把时间花在什么地方？因为如果你打算招一个 CPO 或产品副总裁，却仍然想掌控产品路线图和执行，那就别招。因为那个人招来干什么呢？这是我在 CEO 寻找 CPO 或产品副总裁时首先要澄清的问题。

---

### (00:43:10) Manik Gupta

**English:**
Then the other thing is really about, are you trying to optimize for process? Are you optimizing for strategy? Are you optimizing for team building and attraction? I think that's a really big one. Sometimes you have to get the right level of leader to attract more talent to the team. Because people say, "Oh, this person is working there. Now I want to go work in their organization." How do you think about engineering and data science and design? How do you think about GM and operations? There are a bunch of all these things in terms of the design that you need to do before you decide whether VP of product, CPO is somebody you want to get and what kind of person you want to get.

**中文翻译:**
另一件事是：你是想优化流程？优化战略？还是优化团队建设和人才吸引？我认为人才吸引是一个大项。有时你需要一个合适级别的领导者来吸引更多人才加入团队。因为人们会说：“噢，那个人在那儿工作，我也想去他的组织工作。”你如何看待工程、数据科学和设计？你如何看待 GM 和运营？在决定是否需要产品副总裁或 CPO 以及需要什么样的人之前，你需要对这些组织设计进行大量的思考。

---

### (00:43:43) Manik Gupta

**English:**
I think that's where the intersection of the work between this... especially for a tech company, the CEO, CPO have to be... And even the CTO I would throw in the mix. That has to be very clearly articulated, otherwise it creates a lot of confusion. Those are some of the things, at least that I observe from different patterns and different companies that I've worked with and also guided and advised, those are things that always come up.

**中文翻译:**
我认为这就是工作的交集点……特别是对于科技公司，CEO、CPO 必须……我甚至会把 CTO 也加进来。这些职责必须非常清晰地表达出来，否则会造成很多混乱。这些是我从合作过、指导过或提供过建议的不同公司和模式中观察到的，这些问题总是会出现。

---

### (00:44:06) Lenny

**English:**
It's interesting how much similarity there is to that experience as there is to the first PM at a company. It feels like they have to have the same conversations with the founder. What do you want to work on? What am I going to take on? How do we avoid stepping on each other's toes the whole time?

**中文翻译:**
很有趣，这种经历与公司招第一个 PM 时的经历非常相似。感觉他们必须和创始人进行同样的对话：你想做什么？我负责什么？我们如何避免整天互相踩脚？

---

### (00:44:21) Manik Gupta

**English:**
That's actually a... I never thought about it that way, Lenny. I think that's a really good point. You're totally right. Obviously, if you're at a bigger company, then you're looking for a VP of product. Or if you're a super big company, then you're looking for a CPO. But you're right. The first product hire that you make as a founder, you'll pretty much have the same conversations to ensure that there are clear swim lanes and accountability for that group.

**中文翻译:**
这确实是一个……Lenny，我从未那样想过。我认为这是一个非常好的观点。你完全正确。显然，如果你在一家大公司，你会寻找产品副总裁；如果你在一家超级大公司，你会寻找 CPO。但你是对的，作为创始人，你招的第一个产品人员，基本上也会进行同样的对话，以确保有清晰的职责范围（swim lanes）和问责机制。

---

### (00:44:39) Lenny

**English:**
Interesting. I want to make sure to ask you, as kind of a big deal leader of product at larger companies, I'm curious, what do you look for in PMs that are looking to get promoted, or just deciding somebody's ready for promotion or ready for more responsibility? What do you look for and what should people focus on if they want to come across as promotion material?

**中文翻译:**
很有意思。我想问问你，作为大公司举足轻重级的产品领导者，我很想知道，在那些寻求晋升或准备承担更多责任的 PM 身上，你最看重什么？如果有人想让自己看起来具备晋升潜力，他们应该关注什么？

---

### (00:45:01) Manik Gupta

**English:**
I'm a big fan of looking at both the what and the how. So what did they accomplish and how did they accomplish. Because they're a package. And if you just look at one versus the other, then I think you end up making a mistake. Usually. On the what, I think the what is usually more objective. What I look for... And again, it depends on the level of the person. Don't try to calibrate someone based early in their career. You have to think through that. That they're in learning phase. If they're more senior than you have to of course calibrate them differently. But ultimately, if I were to boil it down on the what, it's really about real demonstrated impact. An ideal example is someone who had a strong product hypothesis, they rallied a bunch of people around them. They may not have come up with the hypothesis. That's fine. Somebody else could have come up with it, it doesn't matter. But they believed in it, they rallied the team behind it, they drove towards it and created impact.

**中文翻译:**
我非常喜欢同时观察“做了什么”（what）和“怎么做的”（how）。也就是他们取得了什么成就，以及他们是如何取得这些成就的。因为这两者是一个整体。如果你只看其中一个，我认为通常会犯错。关于“做了什么”，我认为这通常比较客观。我寻找的是……当然，这取决于那个人的级别。不要试图用同样的标准去衡量职业生涯早期的人，你必须考虑到他们还处于学习阶段。如果他们更资深，你当然要用不同的标准。但最终，如果要把“做了什么”浓缩一下，那就是“真实且可见的影响力”。一个理想的例子是：某人有一个强大的产品假设，他们团结了一群人围绕在自己身边。他们不一定是假设的提出者，这没关系，别人提出也可以。但他们相信这个假设，带领团队朝着这个方向努力，并创造了影响力。

---

### (00:45:58) Manik Gupta

**English:**
The impact not necessarily always has to be positive. It could also be a lot of stuff that we learned, but we learned from it and then we moved on and we did the next rev. By the time we did the next rev, we were smarter about it. Clear demonstrated impact from an end to end product cycle to me is probably one of the better indicators of readiness for someone to take on more. And you basically want to give them more, because now they have a pattern of doing things properly. That's one.

**中文翻译:**
影响力不一定总是正向的。也可以是我们学到了很多东西，从中吸取教训，然后继续前进，做下一个版本。当我们做下一个版本时，我们变得更聪明了。对我来说，从端到端的产品周期中展现出的清晰影响力，可能是衡量一个人是否准备好承担更多责任的最佳指标之一。你自然会想给他们更多任务，因为他们已经展现出了正确做事的能力模式。这是第一点。

---

### (00:46:23) Manik Gupta

**English:**
On the how, I just love people who are able to create both energy and create clarity. Think of the flip side. PMs who don't create clarity is such a time sink and the teams struggle so much. I'm sure all of us, when we think about back in the day, maybe we were in that position at some point. But we also worked with folks who were always confused and didn't really summarize, or didn't really follow up, or didn't really create that level of clarity in terms of what we need to do and so on, and how broken that felt. People who can create the clarity and then have the energy around them to get things done, I think that's the how in my opinion. Which is really important for determining somebody's career trajectory.

**中文翻译:**
关于“怎么做的”，我非常喜欢那些既能创造能量又能创造清晰度的人。想想反面：那些不能创造清晰度的 PM 简直是时间黑洞，团队会因此陷入挣扎。我相信我们所有人回想起过去，可能在某个时刻都处于那种位置。我们也和那些总是感到困惑、不总结、不跟进、或者无法明确我们要干什么的人共事过，那种感觉非常糟糕。我认为，那些能够创造清晰度并拥有完成任务的能量的人，就是我心目中的“怎么做的”。这对于决定一个人的职业轨迹非常重要。

---

### (00:47:11) Manik Gupta

**English:**
Then the last thing I would say is followership. Really important for PMs. Do people want to work with them? Do people at some point, as they go up and become more senior, do people want to work for them? Ultimately people make choices. And if you have a bunch of smart people and they're making smart choices and they're choosing this person to follow or to be with and work with them and reach out to them, and you keep hearing things about, hey, so and so wants to work with this person because this person is amazing; there is a ton of value in that.
(00:47:45):
Those are the three things that, if I were to really boil it down, not looking at a certain level, I think I always look for those attributes.

**中文翻译:**
最后我想说的是“追随力”（followership）。这对 PM 来说非常重要。人们想和他们一起工作吗？当他们变得更资深时，人们想为他们工作吗？最终，人们会做出选择。如果你有一群聪明人，他们做出了聪明的选择，选择追随这个人，或者选择与这个人一起工作并主动联系他，而且你不断听到有人说：“嘿，某某想和这个人合作，因为这个人太棒了”；这其中蕴含着巨大的价值。
(00:47:45):
如果我不分级别地总结一下，这三点就是我一直在寻找的特质。

---

### (00:47:51) Lenny

**English:**
Those are awesome. So simple and clear and succinct. I like the way that you framed it as followership versus leadership. There's a lot of PM attributes leadership, and there's something really nice about just a way to understand that as how many people are following you and excited to work on the things that you're trying to get them to work on. That's very cool.
(00:48:11):
Along the same lines, when you think about PMs that had an inflection point in their career, do you find that there's anything correlated with something that leads to a large inflection in the progress of someone's career where they all of a sudden started doing incredibly better?

**中文翻译:**
这些太棒了，简单、清晰、简洁。我喜欢你把这描述为“追随力”而不是“领导力”。PM 的特质中有很多关于领导力的描述，但用“有多少人追随你，并对你试图让他们做的事情感到兴奋”来理解这一点，感觉非常好。这很酷。
(00:48:11):
沿着同样的思路，当你想到那些职业生涯出现转折点（inflection point）的 PM 时，你是否发现有什么因素与职业生涯的巨大飞跃相关？即他们突然之间表现得异常出色。

---

### (00:48:24) Manik Gupta

**English:**
I've gone through a few inflection points myself, and almost always they've happened because something in the organization changed, so I got a shot. There's always that luck factor, going back to the first question that we discussed.
(00:48:37):
But generally speaking, I think the inflection points happen in two places. One is when someone has really successfully changed the dynamic, or the trajectory rather, of a particular product. That's a huge inflection point. That doesn't happen very often, to be fair. But when it happens, you know it. You know, as a leader, this person worked on this and they actually led this change and now we are playing a different game. We are playing a bigger game, we are playing a different game, all of that kind of stuff.

**中文翻译:**
我自己也经历过几次转折点，几乎总是因为组织内部发生了某些变化，让我得到了机会。这总是有运气成分，回到我们讨论的第一个问题。
(00:48:37):
但总的来说，我认为转折点发生在两个地方。第一，当某人真正成功地改变了一个特定产品的动态，或者说是轨迹。这是一个巨大的转折点。公平地说，这并不经常发生。但一旦发生，你就知道了。作为领导者，你知道这个人负责了这件事，他们实际上领导了这种变革，现在我们进入了一个不同的赛道。我们在玩一个更大的游戏，一个不同的游戏，诸如此类。

---

### (00:49:16) Manik Gupta

**English:**
In other words, what I'm saying is the inflection point for a career is correlated strongly with the inflection point in the product. If you can connect those, the cause and effect... If there's causality and not just correlation, if there's causality in that, I think that absolutely means that you've got a winner. And you really want to bet on them and you have to give them a lot more to do, because they have the ability to do it. That's one.

**中文翻译:**
换句话说，我想说的是，职业生涯的转折点与产品的转折点强相关。如果你能把这两者联系起来，看清其中的因果关系……如果其中存在因果关系而不仅仅是相关性，我认为这绝对意味着你找到了一个赢家。你会非常想在他们身上下注，给他们更多任务，因为他们有能力做到。这是第一点。

---

### (00:49:38) Manik Gupta

**English:**
The second is, oftentimes as people go up in their career, they start managing teams. They become a manager, and then you become a manager of managers, and then you become more senior. I mean, that's the organizational trajectory that happens. One inflection point that I've seen is, when you go from being a manager, a first line manager, to becoming a manager of managers, and if you're able to navigate that with very strong effectiveness, then you know. If you're their manager or if you're their leader you know this person has got their act together. Because managing ICs is so different from managing managers, because then you now need to create a structure. You need to be able to determine how much you delegate. How do you coach? How do coach your managers to do the right thing? If you see somebody making that transition effectively... And you have to give them some time, but if you see that and you know that they're actually doing it, and again, a lot of followership, a lot of other things are happening, good things are happening, then you know they're at that inflection point where they're ready to take on more.

**中文翻译:**
第二点是，通常随着人们职位的提升，他们开始管理团队。他们成为经理，然后成为经理的经理，然后变得更资深。这是组织中常见的轨迹。我见过的一个转折点是，当你从一名经理（一线经理）转变为经理的经理时，如果你能非常高效地应对这种转变，那么你就成功了。如果你是他们的经理或领导，你会知道这个人已经进入状态了。因为管理个人贡献者（IC）与管理经理非常不同，因为你现在需要建立一个结构。你需要决定授权多少，如何进行辅导，如何辅导你的经理去做正确的事。如果你看到有人有效地完成了这种转变（你需要给他们一些时间），如果你看到他们真的做到了，并且再次展现出强大的追随力，很多好事正在发生，那么你就知道他们正处于那个转折点，准备好承担更多责任了。

---

### (00:50:41) Manik Gupta

**English:**
Both product inflection in terms of real output and this management prowess inflection in terms of being able to effectively lead going from one step to another, a manager to becoming a manager of managers; I think those are the two places where I feel like, if I see somebody doing well, I know they're ready to put more onto them.

**中文翻译:**
无论是真实产出方面的产品转折，还是从一个阶段到另一个阶段（从经理到经理的经理）有效领导的管理能力转折；我认为如果我看到有人在这两个方面表现出色，我就知道可以给他们加担子了。

---

### (00:51:00) Lenny

**English:**
Do you find that second piece is this filter for PMs that do well in this manager manager role and go on to do better and better and then a lot just fall away because they can't handle that?

**中文翻译:**
你是否觉得第二点是一个过滤器？那些在“经理的经理”角色中表现出色的 PM 会越来越好，而很多人因为无法应对而掉队？

---

### (00:51:12) Manik Gupta

**English:**
Yeah, I think so. Maybe I'm a little bit more traditionist on this point. I know there are other schools of thought on this, which I respect. Which is there are a lot of times where people are like, "Well, oftentimes the best PMs are PMs who are IC PMs. They have this crazy, incredible, unbounded energy and they don't want to waste their time on management and whatnot and do that. Because a large part of a PM's job, by the way, is managing by influence. PMs typically don't have large organizations. In fact, one of the most leveraged teams in almost every company... Because you talk about PM manage ratios, PM design ratios, they're never one-ish to one, or one-ish to five, or one-ish to six. Sometimes it' going to be one-ish to 10. At Google it used to be one-ish to eight to one-ish to 10.

**中文翻译:**
是的，我想是的。也许在这一点上我有点传统。我知道对此有其他的流派，我也尊重他们。很多时候人们会说：“通常最好的 PM 是那些个人贡献者（IC）PM。他们拥有疯狂、惊人、无限的能量，不想把时间浪费在管理之类的事情上。”顺便说一下，PM 工作很大一部分是通过影响力进行管理。PM 通常没有庞大的组织。事实上，在几乎每家公司中，PM 都是杠杆率最高的团队之一。因为谈到 PM 与经理的比例、PM 与设计的比例，它们从来不是 1:1，也不是 1:5 或 1:6。有时会是 1:10。在 Google，以前通常是 1:8 到 1:10。

---

### (00:51:52) Manik Gupta

**English:**
I personally see that transition... If somebody's making that transition successfully and they're getting good scores out of it and delivering the product and the output of the team is significant, I definitely see that as a good filter criteria for someone whom we can bet on.

**中文翻译:**
我个人认为那种转变……如果有人成功实现了这种转变，并获得了良好的评价，交付了产品，且团队的产出非常显著，我绝对会将其视为一个很好的过滤标准，来判断这个人是否值得我们下注。

---

### (00:52:06) Lenny

**English:**
Do you find there's common habits or pitfalls PMs make to shoot themselves in the foot in their career, especially early on?

**中文翻译:**
你是否发现 PM 在职业生涯中（尤其是早期）有一些常见的习惯或陷阱，会导致他们自毁前程？

---

### (00:52:14) Manik Gupta

**English:**
Oh, I see that all the time. There's a few of the things that I have picked up. And by the way, I was doing this too early on and I learned the hard way. The first one I would talk about is you are early in your career and everyone expects you to just manage things and manage the process and all of that. Make sure that trains are running on time and all of that. Which, by the way, is really important for an early in career PM to understand. That that's actually a big part of your job. Let's not over glamorize a PM. A large part of being a PM initially is just basically doing whatever the team needs you to do. But I think one of the pitfalls of that is, if you start putting process over progress, that's a problem.

**中文翻译:**
噢，我经常见到。我总结了几点。顺便说一下，我早期也犯过这些错，并付出了惨痛的代价。第一点是，当你处于职业生涯早期，每个人都期望你只是管理事务、管理流程等等。确保“火车准时运行”。顺便说一下，对于职业生涯早期的 PM 来说，理解这一点非常重要，这确实是工作的一大部分。我们不要把 PM 这个职位过度美化。最初，PM 的很大一部分工作就是做团队需要你做的任何事情。但我认为其中的一个陷阱是：如果你开始把“流程”置于“进度”之上，那就是个问题。

---

### (00:52:58) Manik Gupta

**English:**
What I mean by that is, you want to introduce process into almost everything that the team does and not be flexible on shipping things out there and all the things that can come in the way of progress. If process is helping progress, great. But if process is hurting progress, you should not be the person saying, "No, no, no, no. We can't do it, because I'm just so married to the process. Because as a PM, that's what I own." I mean, as a PM you don't write code typically, you don't write design specs, you write product specs. Sometimes you feel like, what is the set of attributes that I own? Especially early in career PMs. And you're like, "I own this process. I own this weekly standup meeting, or I own this sprint planning, or whatever." And then you get so married to it that you forget the fact that that's just a means to an end and the end is what you're going to be actually measured on. That's one mistake that I see people making early on.

**中文翻译:**
我的意思是，你想在团队做的几乎每一件事中都引入流程，并且在发布产品和任何可能阻碍进度的事情上都不够灵活。如果流程有助于进度，那太好了。但如果流程损害了进度，你不应该是那个说“不不不，我们不能这样做，因为我必须严格遵守流程”的人。因为作为 PM，你觉得流程是你唯一掌控的东西。我的意思是，作为 PM，你通常不写代码，不写设计规范，你写产品规范。有时你会觉得，我到底拥有什么？特别是职业生涯早期的 PM。你会觉得：“我拥有这个流程，我拥有这个每周站会，或者我拥有这个冲刺计划（sprint planning）等等。”然后你变得如此执着于流程，以至于忘记了它只是达到目的的手段，而最终衡量你的是那个“目的”。这是我看到人们早期常犯的一个错误。

---

### (00:53:48) Manik Gupta

**English:**
The second one is becoming really too self-centered. It's all about me, not the team. I'm the PM. There's this myth that keeps going around. The PM is the CEO of the product. That's one of the most incorrect things in the world. The PM is an enabler. I said earlier, it's a leverage job. Your job is to really make the team successful. Of course you have to have the product thinking and the roadmap and all of that, but sometimes this can go to their head. Then people become too self-centered and that's a red flag.

**中文翻译:**
第二个错误是变得过于以自我为中心。凡事都只想到自己，而不是团队。我是 PM。一直流传着这样一个神话：PM 是产品的 CEO。这是世界上最错误的事情之一。PM 是一个赋能者。我之前说过，这是一份杠杆式的工作。你的工作是让团队获得成功。当然，你必须有产品思维和路线图等等，但有时这些会让 PM 冲昏头脑。然后人们变得过于以自我为中心，这是一个危险信号。

---

### (00:54:21) Manik Gupta

**English:**
Then the third one would be just not admitting your mistakes or learning from them. Early in career, the only thing you should optimize for is learning. Sure, you'll make a lot of mistakes. You don't know much yet. You're just coming into this journey and you should be humble and you should be learning and you should be saying, "Oops, I screwed up over here." And that's okay. That's fine. And by the way, if you work in a company where that is not accepted, you should not work in that company. What's the point? You should really be optimizing for learning and learning from other people. And people should be saying, "Yeah, don't worry. It's okay. You made the mistake. Learn from it. Don't make the mistake again. That's fine." But that's the kind of culture you want to choose for yourself.
(00:55:01):
Those are the three pitfalls that I see people get into, especially early on in their career.

**中文翻译:**
第三个是不承认错误或不从中学习。在职业生涯早期，你唯一应该优化的就是学习。当然，你会犯很多错。你还了解得不够多。你才刚刚开始这段旅程，你应该保持谦逊，不断学习，并敢于说：“哎呀，我在这里搞砸了。”这没关系，这很正常。顺便说一下，如果你在一家不容许犯错的公司工作，你不应该在那儿待着。那有什么意义呢？你应该真正优化学习，向他人学习。人们应该说：“没关系，别担心。你犯了错，从中学习，下次别再犯就行了。这很好。”这才是你应该为自己选择的文化。
(00:55:01):
这就是我看到的、尤其是职业生涯早期的人容易陷入的三个陷阱。

---

### (00:55:05) Lenny

**English:**
You touched on how different companies work in different ways and look for different things in different PMs. And something I wanted to ask you is just to chat a bit about the difference between working at Google versus Uber versus Microsoft as a PM, and also just generally how product is built differently at these companies. It's something I'm trying to do with this podcast as much as possible. Just give an overview of what product is like at different companies. You've worked at three of the biggest, and so I'm curious to hear what you can share around that.

**中文翻译:**
你提到了不同的公司运作方式不同，对 PM 的要求也不同。我想请你聊聊在 Google、Uber 和微软担任 PM 的区别，以及这些公司在构建产品方面的差异。这是我在这档播客中尽可能想做的一件事：概述不同公司的产品文化。你曾在其中三家最大的公司工作过，我很想听听你的分享。

---

### (00:55:32) Manik Gupta

**English:**
Yeah. It's actually really interesting. I mean, all the three companies are so different. Google, the core DNA of the company was very much engineering. In fact, there used to be a framework which was around technology insights drive innovation. It was always about what is the best tech we can come up with, which is going to indeed drive innovation, and have a longish view so that the market will get there. That was the Google philosophy always. As a PM, your job at Google... It might have changed in the last six, seven years that I've not been there, but at least when I was there from 2008 to 2015, especially working on Google Maps, it was all about how do you take good long-term bets grounded in strong technical insights, and then use the power of Google Search distribution to really get your product out there. That was it.

**中文翻译:**
是的，这确实非常有趣。这三家公司非常不同。Google 的核心 DNA 非常偏向工程。事实上，以前有一个框架是关于“技术洞察驱动创新”。它始终关注我们能想出的最好的技术是什么，它将如何驱动创新，并保持长远的眼光，等待市场跟上。这一直是 Google 的哲学。作为 Google 的 PM（虽然我已经离开六七年了，情况可能有所变化，但至少在 2008 到 2015 年我负责 Google 地图时），核心在于如何基于强大的技术洞察进行良好的长期博弈，然后利用 Google 搜索的分发能力将产品推向市场。就是这样。

---

### (00:56:33) Manik Gupta

**English:**
On the Maps team, our innovation was pretty much around crowdsourcing everyone's location signals for traffic. Huge, huge accomplishment. We had the best traffic models in the world. And then being able to do this crazy route optimization for driving directions. Then on top of that, we had the search stack, which came from Google Search anyway. So that you can search for any address, any business and so on.

**中文翻译:**
在地图团队，我们的创新主要围绕众包每个人的位置信号来获取路况信息。这是一个巨大的成就，我们拥有世界上最好的路况模型。然后是能够为驾驶路线提供疯狂的路径优化。除此之外，我们还有搜索技术栈（源自 Google 搜索），这样你就可以搜索任何地址、任何商家等等。

---

### (00:56:55) Manik Gupta

**English:**
Anyway, as a PM it was partnering very closely with engineers and really amplifying the engineer's ideas and so on. I think at that point also a lot of Google PMs were very technical. Very, very technical. Because that was just part for the course. It was expected that you will be able to at least have engineering discussions. A large part of what I did as a PM at Google, especially initially, was getting into the technical details with my engineers and really geeking out on what we can do. That was the Google model.

**中文翻译:**
总之，作为 PM，你需要与工程师紧密合作，并真正放大工程师的想法。我认为当时很多 Google 的 PM 都非常懂技术，非常非常懂。因为那是基本要求，大家期望你至少能参与工程讨论。我在 Google 担任 PM 期间（尤其是初期），很大一部分工作是与工程师一起深入研究技术细节，真正沉浸在我们可以实现的技术突破中。这就是 Google 模式。

---

### (00:57:25) Manik Gupta

**English:**
By the way, one thing I should say about Google before I go to... At Google as a PM, at least all the way up to the time even when I became a director, I never had to think about business models, man. Never. It was fascinating. You were in this weird state where you could just build and have the consumer traction and all of that, but you never thought about P&L, never thought about revenue and so on.

**中文翻译:**
顺便说一下，在谈下一家之前，我得提一下 Google：在 Google 担任 PM 期间，甚至直到我成为总监，我从来不需要考虑商业模式。从来不需要。这很奇妙。你处于一种奇特的状态，你可以只管构建产品、获取用户吸引力，却从不考虑损益表（P&L）、从不考虑收入等等。

---

### (00:57:48) Manik Gupta

**English:**
Then I landed at Uber, which was very different. Uber was very operations, very business driven, very P&L. In fact, one of the most incredible things that Uber did was they had a dashboard which every employee in the company could look at, and it had last week's revenue, last week's number of trips that we did, and you could slice and dice it and all of that. I think that changed over time as we became a public company and so on. But the point was that it was really in your face all the time. When there were weekly newsletters sent out, it was all about growth, it was all about business, all of that kind of stuff. It was very operational and business, so as a PM over there it was a lot about managing a bunch more stakeholders. The operations teams, the marketing teams, the policy teams and so on. And how do you work with them to deploy your product into each of these markets. Of course then a large chunk of your work was still working with the engineering team. It was different in that sense.

**中文翻译:**
然后我去了 Uber，那里非常不同。Uber 非常注重运营，非常业务驱动，非常看重损益。事实上，Uber 做过最不可思议的事情之一是，他们有一个每个员工都能看到的仪表盘，上面有上周的收入、上周的行程单数，你可以进行各种维度分析。随着我们上市，这些可能发生了变化。但重点是，这些数据一直就在你眼前。每周发出的时事通讯全是关于增长、关于业务之类的。它非常偏向运营和业务，所以作为那里的 PM，很大一部分工作是管理更多的利益相关者：运营团队、营销团队、政策团队等等。你需要与他们合作，将产品部署到各个市场。当然，你工作的很大一部分仍然是与工程团队合作。从这个意义上说，它很不一样。

---

### (00:58:47) Manik Gupta

**English:**
I think at Uber the other thing was it was also much more of a real time business. I mean, Google was also real time. Google Maps was real time. Billions of users were using it. But Uber was... every day there was something going on in the market and you had to keep on that hustle in terms of how do you make sure that your staying competitive, your product is working well, there are no outages. All of that kind of stuff was really important.

**中文翻译:**
我认为在 Uber 的另一件事是，它更像是一个实时业务。我的意思是，Google 也是实时的，Google 地图也是实时的，有数十亿用户在使用。但 Uber 是……市场上每天都有事情发生，你必须保持那种“拼命”的状态，确保保持竞争力、产品运行良好、没有宕机。所有这些都非常重要。

---

### (00:59:09) Manik Gupta

**English:**
Then finally, on Microsoft... I mean, Microsoft has been around for quite a while. The company went through so many different things and then over the last several years, especially under Satya's leadership, it has done so well. Incredibly well in terms of how the company has changed the culture, the kind of products that they have in the market, the traction they have in the market.

**中文翻译:**
最后是微软……微软已经存在很长时间了。这家公司经历了这么多变迁，在过去的几年里，特别是在 Satya 的领导下，表现得非常好。无论是公司文化的改变、推向市场的产品种类，还是在市场上的吸引力，都表现得令人难以置信。

---

### (00:59:29) Manik Gupta

**English:**
I think I would describe Microsoft as both... first and foremost, it's a very strong tech company. The engineers here are incredible. Oh my God. I am so privileged to work with some of the best engineers that I've worked with in my career. At the same time there's a lot of legacy. There are a lot of products that have been around for a really long time, which is good and bad. The good part is that they have seen pretty much every pattern there is to see. In fact, they came up with a lot of those patterns themselves. The bad part sometimes can be that change is hard. How do you convince people that we're going to go down a different path? As a PM, a lot of it is around bringing outside in perspective, bringing clarity of like, "Hey, this is how it has actually worked somewhere else." Bring a specific example. Let's try it out and see how that works.

**中文翻译:**
我想我会把微软描述为……首先，它是一家非常强大的技术公司。这里的工程师简直不可思议。天哪，我很荣幸能与我职业生涯中见过的最优秀的工程师共事。与此同时，这里有很多历史遗留（legacy）。有很多产品已经存在了很长时间，这既是好事也是坏事。好的一面是，他们几乎见过了所有的模式，事实上，很多模式就是他们自己创造的。坏的一面有时是变革很难。你如何说服人们我们要走一条不同的路？作为 PM，很大一部分工作是引入外部视角，带来清晰度，比如：“嘿，这是在别的地方实际运作的方式。”举一个具体的例子，让我们试一试，看看效果如何。

---

### (01:00:13) Manik Gupta

**English:**
The final thing I would say about it is the company is so grounded in trust. If there's one word that I would say about Microsoft is trust. They really care a lot about customers. Customers trust Microsoft a lot. I've been in some of the customer meetings myself and I can totally hear what customers say. It's all about trust. They expect resilience, they expect the products to work, and they expect that when they have a problem on the surface, that Microsoft will take care of it. They built that over time. A lot of that goes into your mind as a PM when you're working in that company, that a lot of the stuff that we are doing here is to really help our customers.

**中文翻译:**
最后我想说的是，这家公司非常注重“信任”。如果要用一个词来形容微软，那就是信任。他们非常关心客户，客户也非常信任微软。我亲自参加过一些客户会议，完全能听到客户的心声。核心就是信任。他们期望韧性，期望产品能正常工作，并期望当表面出现问题时，微软能负责解决。这是他们长期建立起来的。作为那里的 PM，你会时刻记住：我们在这里做的很多事情都是为了真正帮助我们的客户。

---

### (01:00:48) Lenny

**English:**
Going back to your point about company-product fit, these cultures and the way they work just fits perfectly with the thing they end up building. I wonder which one comes first.

**中文翻译:**
回到你关于“公司产品契合度”的观点，这些文化和运作方式完美地契合了他们最终构建的产品。我很好奇哪一个先出现。

---

### (01:00:57) Manik Gupta

**English:**
It's true. That's a whole nother conversation we can have at some point. I have a lot of thoughts on that. But I'll just echo what you just said, which is that's the reason why it's so important for companies, when they embark on new initiatives, to be really, really thoughtful. Is this the right area for us to get into? Or rather, what are the conditions and the reasons why we are getting into something? We have to be super clear on that. Because if the starting conditions are not right, then you will just trash the team. The team will keep working on something and people will never find the right internal fit. So that's super important.

**中文翻译:**
确实如此。那是我们以后可以进行的另一个话题，我对此有很多想法。但我只想呼应你刚才说的话，这就是为什么公司在启动新项目时必须非常、非常慎重。这是我们应该进入的正确领域吗？或者说，我们进入某个领域的条件和理由是什么？我们必须对此非常清晰。因为如果起始条件不对，你就会毁掉团队。团队会一直忙于某件事，但永远找不到正确的内部契合点。所以这至关重要。

---

### (01:01:35) Lenny

**English:**
You worked on Google Maps and Uber, which I imagine you still use often and maybe billions of people use every day. Is there a feature that you wish that you built back when you were on the team, or that you think should be killed, that annoys you about either of those products?

**中文翻译:**
你参与过 Google 地图和 Uber，我想你现在仍经常使用它们，而且每天可能有数十亿人在用。有没有什么功能是你希望当年在团队时就构建出来的？或者你认为应该砍掉的、让你感到烦恼的功能？

---

### (01:01:50) Manik Gupta

**English:**
Wow. Okay. This is a super interesting one. I don't know if that's something that I could have built at Google Maps, but one of the things that's interesting is the self-driving technology has just not gotten there fast enough. I feel like the best and brightest actually worked on it and are still working on it and it will get there. I'm a big believer. But of course the timelines have shifted for various reasons, because it is a really hard problem. It's actually really interesting to see what Cruise is doing right now in SF. They have started the pilots and so on, so I'm really happy to see some progress happening. I know Waymo's been doing a bunch of this already.

**中文翻译:**
哇，好吧，这是一个超级有趣的问题。我不知道那是不是我能在 Google 地图构建出来的东西，但有趣的一点是：自动驾驶技术的发展速度还不够快。我觉得最优秀、最聪明的人确实参与其中，并且仍在努力，它最终会实现的，我坚信这一点。但当然，由于各种原因，时间表推迟了，因为这确实是一个非常难的问题。看到 Cruise 目前在旧金山的进展非常有趣，他们已经开始了试点等等，我很高兴看到进展。我知道 Waymo 已经做了很多相关工作。

---

### (01:02:29) Manik Gupta

**English:**
But it would've been amazing. One of the things that we used to talk about all the time at Google on Maps was how would we design a navigation product when people are in self-driving cars? We had some really interesting ideas at that point, but we never got to it. Not because we didn't prioritize it, but the technology isn't there. I still keep a close watch on that and see at what point are we going to get there. It's going to take years, but it is just such a different paradigm. It's like computers talking to computers, algorithms talking to other algorithms. Then there's a human in the mix in terms of serving the human at the end, but it's like the human is not initiating that much. It's just, stuff is happening around it.
(01:03:08):
Anyway, that's one thing that is unfinished business, if you will, in my mind. And hopefully, as the technology comes together, that will happen.

**中文翻译:**
但如果能实现就太棒了。以前在 Google 地图团队，我们经常讨论：当人们坐在自动驾驶汽车里时，我们该如何设计导航产品？当时我们有一些非常有趣的想法，但从未付诸实践。不是因为我们不重视，而是技术还没到位。我仍然密切关注着这一点，看我们什么时候能实现。这需要很多年，但它是一个完全不同的范式。就像电脑在和电脑对话，算法在和算法对话。虽然最终是为了服务人类，但人类不再需要发起那么多操作，事情就在周围自然而然地发生了。
(01:03:08):
总之，这是我心中一件“未竟的事业”。希望随着技术的成熟，它最终能够实现。

---

### (01:03:16) Lenny

**English:**
Amazing. Manik, you've been extremely generous with your time. Just two last quick questions. Where can folks find you online if they want to reach out maybe, or learn more about what you're doing? And then how can listeners be useful to you?

**中文翻译:**
太棒了。Manik，你对时间的慷慨超乎想象。最后两个简短的问题：如果人们想联系你或了解更多你的动态，可以在哪里找到你？以及，听众可以为你提供什么帮助？

---

### (01:03:28) Manik Gupta

**English:**
Yeah. You can find me on Twitter, you can find me on LinkedIn. Those are the two places. I have not been very active on both those recently. I've not been active as a contributor, but I'm very active on those two platforms as a consumer. If you have any questions, if you have any thoughts, would love to hear from you, so please send me a note.

**中文翻译:**
好的。你可以在 Twitter 和 LinkedIn 上找到我。最近我在这两个平台上都不太活跃，至少不是作为内容贡献者，但我作为消费者在上面非常活跃。如果你有任何问题或想法，我很乐意倾听，请给我发消息。

---

### (01:03:47) Manik Gupta

**English:**
In terms of how listeners can be helpful, I just want to learn what's new and what's out there. I've had the privilege of being in these incredible companies. The reason why I'm still doing what I'm doing is because I still want to learn. If there are better patterns out there that you're seeing, particularly around how to build products, would love to know if there are other ways people think about finding product market fit. Because that's such an elusive thing that I just keep thinking a lot about. If you have some techniques, some tips, some best practices that you have learned and it has worked for you, please, please, please reach out to me. I would love to learn that, because it's so important for us to keep having that conversation.

**中文翻译:**
至于听众能帮我什么，我只想了解有什么新事物。我有幸在这些了不起的公司工作过，但我之所以还在坚持，是因为我仍然渴望学习。如果你看到了更好的模式，特别是关于如何构建产品的模式，我很想知道人们在寻找产品市场契合度方面还有哪些新思路。因为那是一个如此难以捉摸的东西，我一直在思考。如果你学到了一些技巧、心得或最佳实践，并且对你有效，请务必联系我。我很想学习，因为保持这种对话对我们来说非常重要。

---

### (01:04:24) Lenny

**English:**
Awesome. It's always such a pleasure chatting. I always learn a ton. And this did not disappoint, so thank you again for being here.

**中文翻译:**
太棒了。和你聊天总是一种享受，我学到了很多。这次也没让我失望，再次感谢你的到来。

---

### (01:04:30) Manik Gupta

**English:**
Lenny, thank you so much for asking all these questions and giving me the opportunity to share my learnings over the years. Thank you.

**中文翻译:**
Lenny，非常感谢你提出这些问题，并给我机会分享我这些年来的心得。谢谢。

---

### (01:04:36) Lenny

**English:**
Absolutely my pleasure. That was awesome. Thank you for listening. If you enjoyed the chat, don't forget to subscribe to the podcast. You could also learn more at lennyspodcast.com. I'll see you in the next episode.

**中文翻译:**
这是我的荣幸。太棒了。感谢大家的收听。如果你喜欢这次谈话，别忘了订阅本播客。你也可以在 lennyspodcast.com 了解更多信息。我们下期节目再见。