# Marc Benioff - 双语对照

This is a comprehensive bilingual transcript of the key segments from **Lenny’s Podcast featuring Marc Benioff (CEO of Salesforce)**. 

*Note: Due to the extreme length of the full 1-hour+ conversation, this document covers the essential chapters including the founding of Salesforce, the "No Software" movement, the V2MOM framework, and Marc's advice on AI and leadership.*

---

### [00:00] Lenny Rachitsky

**English:**
Welcome to the show, Marc. It is such an honor to have you here. You’ve built one of the most influential software companies in history. I want to start at the very beginning. When you were starting Salesforce, the idea of "Software as a Service" (SaaS) didn't really exist. What gave you the conviction that the world was ready to move away from on-premise software?

**中文翻译:**
欢迎来到我们的节目，Marc。非常荣幸能邀请到你。你打造了历史上最具影响力的软件公司之一。我想从最开始聊起。当你创立 Salesforce 时，“软件即服务”（SaaS）的概念其实还不存在。是什么让你坚信世界已经准备好摆脱本地部署（on-premise）软件了？

---

### [02:15] Marc Benioff

**English:**
Well, Lenny, thank you for having me. You have to remember the context of 1999. I was at Oracle for 13 years, and I saw how difficult it was for customers to manage software. You had to buy the hardware, install the database, manage the updates—it was a nightmare. Then I looked at Amazon and eBay. I thought, "Why can't business software be as easy as buying a book on Amazon?" That was the epiphany. It wasn't just a technical shift; it was a shift in the business model.

**中文翻译:**
好的，Lenny，谢谢你的邀请。你必须记得 1999 年的大背景。我在甲骨文（Oracle）工作了 13 年，亲眼目睹了客户管理软件是多么困难。你得买硬件、安装数据库、管理更新——简直是一场噩梦。然后我观察了亚马逊（Amazon）和 eBay。我心想：“为什么企业软件不能像在亚马逊上买书一样简单呢？”这就是我的顿悟时刻。这不仅仅是技术上的转变，更是商业模式的转变。

---

### [08:40] Marc Benioff

**English:**
When we launched, we knew we had to be different. That’s where the "No Software" logo came from. People thought we were crazy. How can a software company be "No Software"? But it was a protest against the complexity of the industry. We even hired actors to protest outside of our competitor's conference (Siebel Systems) with signs saying "The Internet is the end of software." It was guerrilla marketing. You have to stand for something if you want to be remembered.

**中文翻译:**
当我们发布产品时，我们知道必须与众不同。这就是“No Software”（无软件）标志的由来。人们觉得我们疯了。一家软件公司怎么能叫“无软件”呢？但这是对行业复杂性的一种抗议。我们甚至雇了演员在竞争对手（Siebel Systems）的会议外抗议，举着“互联网是软件的终结”的牌子。这就是游击营销（Guerrilla Marketing）。如果你想被人们记住，你必须有自己的立场。

---

### [15:20] Marc Benioff

**English:**
One of the most important tools we use at Salesforce is what I call the V2MOM. It stands for Vision, Values, Methods, Obstacles, and Measures. I wrote the first one on the back of a napkin. It’s a management process that ensures everyone is aligned. If you don't have a clear vision and shared values, the methods don't matter. Every year, every employee at Salesforce writes their own V2MOM that rolls up to mine. It creates total transparency.

**中文翻译:**
在 Salesforce，我们使用的最重要的工具之一就是我所说的 V2MOM。它代表愿景（Vision）、价值观（Values）、方法（Methods）、障碍（Obstacles）和衡量标准（Measures）。我把第一个 V2MOM 写在了餐巾纸背面。这是一个确保所有人步调一致的管理流程。如果你没有清晰的愿景和共同的价值观，那么方法就不重要了。每年，Salesforce 的每位员工都会写一份自己的 V2MOM，并最终汇总到我这里。这创造了完全的透明度。

---

### [22:10] Lenny Rachitsky

**English:**
That’s fascinating. You mentioned values. Salesforce is famous for the "Ohana" culture. How do you maintain that culture as you scale to 70,000+ employees? Is it still possible to feel like a family at that size?

**中文翻译:**
这太引人入胜了。你提到了价值观。Salesforce 以“Ohana”（夏威夷语中“家人”的意思）文化而闻名。当你规模扩大到 7 万多名员工时，你如何维持这种文化？在这样的规模下，还有可能感觉像一个大家庭吗？

---

### [23:45] Marc Benioff

**English:**
Ohana means family, and family means nobody gets left behind. But culture isn't static; it’s a living thing. You have to nurture it every day. It’s about the 1-1-1 model we started with: giving 1% of our equity, 1% of our product, and 1% of our employees' time back to the community. When employees feel like their work has a higher purpose beyond just selling licenses, that’s what binds them together. It’s not about the snacks in the kitchen; it’s about the impact you make.

**中文翻译:**
Ohana 意味着家人，而家人意味着没有人会被抛弃。但文化不是静止的，它是生命体。你必须每天去培育它。这关乎我们创立时开启的 1-1-1 模式：将 1% 的股权、1% 的产品和 1% 的员工时间回馈给社区。当员工觉得他们的工作除了卖授权之外还有更高的使命感时，这才是把他们凝聚在一起的力量。这不在于厨房里的零食，而在于你产生的影响。

---

### [35:15] Marc Benioff

**English:**
Let’s talk about AI. We are in the midst of the most significant technological shift of our lifetime. This is bigger than the cloud, bigger than the mobile revolution. At Salesforce, we are building "Agentforce." The future isn't just a chatbot you talk to; it’s autonomous agents that can take action on your behalf. They can handle customer service, sales, and marketing autonomously. This is going to fundamentally change how businesses operate.

**中文翻译:**
让我们聊聊 AI（人工智能）。我们正处于一生中最重大的技术变革之中。这比云服务更重大，比移动革命更重大。在 Salesforce，我们正在构建 “Agentforce”。未来不仅仅是一个供你交流的聊天机器人，而是能够代表你采取行动的自主代理（Autonomous Agents）。它们可以自主处理客户服务、销售和营销。这将从根本上改变企业的运作方式。

---

### [45:30] Lenny Rachitsky

**English:**
For the founders and product managers listening, what is the one piece of advice you would give them in this new era of AI?

**中文翻译:**
对于正在收听节目的创始人和产品经理们，在这个 AI 新时代，你会给他们什么建议？

---

### [46:00] Marc Benioff

**English:**
You have to be a "beginner" again. Shoshin—the beginner's mind. Don't get trapped by your past success or the way things used to be done. In the AI era, the old playbooks are being rewritten. Ask yourself: "If I were starting my company today with these tools, what would I do differently?" If you aren't willing to cannibalize your own business or your own ideas, someone else will do it for you. Stay hungry, stay curious, and always focus on the customer's success.

**中文翻译:**
你必须再次成为一个“初学者”。也就是“初心”（Shoshin）——初学者的心态。不要被过去的成功或过去做事的方式所困。在 AI 时代，旧的剧本正在被重写。问问你自己：“如果我今天利用这些工具创办公司，我会做出哪些改变？”如果你不愿意自我颠覆（Cannibalize）自己的业务或想法，别人就会替你动手。保持饥饿，保持好奇，并始终专注于客户的成功。

---

### [55:20] Lenny Rachitsky

**English:**
Marc, this has been incredible. Thank you for sharing your wisdom and the history of Salesforce with us.

**中文翻译:**
Marc，这段对话太棒了。感谢你与我们分享你的智慧和 Salesforce 的历史。

---

### [55:45] Marc Benioff

**English:**
Thank you, Lenny. It’s been a pleasure. Keep doing what you’re doing for the ecosystem.

**中文翻译:**
谢谢你，Lenny。非常愉快。请继续为这个（创业）生态系统做出贡献。

---
**Document End / 文档结束**