# Marty Cagan 2.0 - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Marty Cagan.

---

### (00:00:00) Marty Cagan

**English:**
There is no question that a lot of companies overhired during the pandemic. I go into some companies and honestly I can't believe all the ridiculous roles that they have, agile coaches and product owners and product ops and business analysts.

**中文翻译:**
毫无疑问，许多公司在疫情期间过度招聘了。我走进一些公司，坦白说，我简直不敢相信他们设立了那么多荒谬的角色：敏捷教练（Agile Coaches）、产品负责人（Product Owners）、产品运营（Product Ops）以及业务分析师（Business Analysts）。

---

### (00:00:13) Lenny

**English:**
And this is essentially the theater you're describing, people that aren't real product managers.

**中文翻译:**
这本质上就是你所描述的“演戏”（Theater），这些人并不是真正的产品经理。

---

### (00:00:18) Marty Cagan

**English:**
They're dramatically overpaid for the value they provide. Because it's a project management role. It is a lot easier to deliver output than it is to deliver outcomes.

**中文翻译:**
相对于他们提供的价值，他们的薪酬高得离谱。因为这本质上是一个项目管理角色。交付“产出”（Output，指功能上线）要比交付“成果”（Outcomes，指业务价值）容易得多。

---

### (00:00:27) Lenny

**English:**
What made you decide to write another book and what is it about?

**中文翻译:**
是什么让你决定再写一本书？这本书的主题是什么？

---

### (00:00:31) Marty Cagan

**English:**
Too many people in our industry view themselves as a victim of their company, like they're stuck in a feature team and there's nothing they can do about it other than quit. I think that's not true. There is so much they can do.

**中文翻译:**
我们行业中有太多人把自己看作公司的受害者，觉得被困在了一个“功能团队”（Feature Team）里，除了辞职别无他法。我认为事实并非如此，他们其实大有可为。

---

### (00:00:46) Lenny

**English:**
Today my guest is Marty Cagan. Marty has been helping product teams and product managers improve their craft, processes and careers for over 20 years. He's worked with more product teams and more product managers than any human alive. He's also written two of the most popular books in the field of product management, INSPIRED and EMPOWERED, and this week he's releasing his newest book, TRANSFORMED. In our conversation, we cover some spicy and important topics. Where the product management field is going, the over hiring of product managers and adjacent functions, a trend he's noticed called product management theater. Also, why most product management advice you find online is giving you the wrong advice and why that's the case. Why many product managers are simply project managers and how to avoid becoming that person. Also, how to avoid hiring that person. What skills you need to work on and build to be an incredible product manager, especially with AI.

**中文翻译:**
今天的嘉宾是马蒂·卡根（Marty Cagan）。20多年来，马蒂一直致力于帮助产品团队和产品经理提升专业技能、流程和职业生涯。他合作过的产品团队和产品经理比世界上任何人都多。他还撰写了产品管理领域最受欢迎的两本书：《启示录》（INSPIRED）和《赋能》（EMPOWERED），而本周他将发布他的新书《变革》（TRANSFORMED）。在我们的对话中，我们涵盖了一些犀利且重要的话题：产品管理领域的发展方向、产品经理及相关职能的过度招聘、他注意到的一种被称为“产品管理演戏”的趋势。此外，为什么你在网上看到的大多数产品管理建议都是错误的，以及原因何在。为什么许多产品经理仅仅是项目经理，以及如何避免成为那样的人，以及如何避免雇佣那样的人。为了成为一名优秀的产品经理，你需要培养哪些技能，特别是在 AI 时代。

---

### (00:01:43) Lenny

**English:**
How to shift your team and company to be more empowered. Signs that you're working on a feature team and why you probably don't want to be there and so much more. If you care about the field of product management and where it's going, you'll absolutely love this episode. With that, I bring you Marty Cagan after a short word from our sponsors. And if you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. It's the best way to avoid missing future episodes and it helps the podcast tremendously. Let me tell you about a product called Sprig. Next gen product teams like Figma and Notion rely on sprig to build products that people love. Sprig is an AI powered platform that enables you to collect relevant product experience insights from the right users so you can make product decisions quickly and confidently.

**中文翻译:**
如何转变你的团队和公司，使其更具赋能感。你正在“功能团队”工作的迹象，以及为什么你可能不想待在那里，等等。如果你关心产品管理领域及其未来走向，你一定会喜欢这一集。在听完赞助商的简短介绍后，我们将请出马蒂·卡根。如果你喜欢这个播客，别忘了在你的播客应用或 YouTube 上订阅和关注。这是避免错过未来节目的最好方式，也对播客有很大帮助。让我向你介绍一款名为 Sprig 的产品。像 Figma 和 Notion 这样的下一代产品团队都依赖 Sprig 来打造人们喜爱的产品。Sprig 是一个 AI 驱动的平台，让你能从正确用户那里收集相关的产品体验洞察，从而快速、自信地做出产品决策。

---

### (00:02:34) Lenny

**English:**
Here's how it works. It all starts with Sprig's precise targeting, which allows you to trigger in-app studies based on user's characteristics and actions taken in product. Then Sprigs AI is layered on top of all studies to instantly surface your product's biggest learnings. Sprig Surveys enables you to target specific users to get relevant and timely feedback. Sprig Replays enables you to capture targeted session clips to see your product experience firsthand. Sprig's AI is a game changer for product teams. They're the only platform with product level AI, meaning it analyzes data across all of your studies to centralize the most important product opportunities, trends, and correlations in one real time feed. Visit sprig.com/lenny to learn more and get 10% off. That's S-P-R-I-G.com/lenny. This episode is brought to you by Eppo. Eppo is a next generation AB testing and feature management platform built by alums of Airbnb and Snowflake for modern growth teams.

**中文翻译:**
它的工作原理如下：一切始于 Sprig 的精准定位，它允许你根据用户特征和在产品中的操作触发应用内研究。然后，Sprig 的 AI 会覆盖在所有研究之上，立即呈现出你产品中最重要的学习点。Sprig Surveys 让你能针对特定用户获取相关且及时的反馈。Sprig Replays 让你能捕捉特定的会话片段，亲身体验你的产品。Sprig 的 AI 是产品团队的游戏规则改变者。他们是唯一拥有产品级 AI 的平台，这意味着它能分析你所有研究中的数据，将最重要的产品机会、趋势和相关性集中在一个实时反馈流中。访问 sprig.com/lenny 了解更多并获得 10% 的折扣。即 S-P-R-I-G.com/lenny。本集节目由 Eppo 赞助。Eppo 是由 Airbnb 和 Snowflake 的校友为现代增长团队打造的下一代 AB 测试和功能管理平台。

---

### (00:03:36) Lenny

**English:**
Companies like Twitch, Miro, ClickUp and DraftKings rely on Eppo to power their experiments. Experimentation is increasingly essential for driving growth and for understanding the performance of new features, and Eppo helps you increase experimentation velocity while unlocking rigorous deep analysis in a way that no other commercial tool does. When I was at Airbnb, one of the things that I loved most was our experimentation platform where I could set up experiments easily, troubleshoot issues, and analyze performance all on my own. Eppo does all that and more with advanced statistical methods that can help you shave weeks off experiment time, an accessible UI for diving deeper into performance and out of the box reporting that helps you avoid annoying prolonged analytic cycles.

**中文翻译:**
Twitch、Miro、ClickUp 和 DraftKings 等公司都依赖 Eppo 来驱动他们的实验。实验对于推动增长和了解新功能的表现越来越重要，Eppo 帮助你提高实验速度，同时以其他商业工具无法做到的方式解锁严谨的深度分析。当我在 Airbnb 时，我最喜欢的事情之一就是我们的实验平台，在那里我可以轻松地设置实验、排除故障并独立分析表现。Eppo 实现了这一切，并利用先进的统计方法帮助你缩短数周的实验时间，它拥有易用的 UI 用于深入研究表现，以及开箱即用的报告，帮助你避免烦人且漫长的分析周期。

---

### (00:04:19) Lenny

**English:**
Eppo also makes it easy for you to share experiment insights with your team, sparking new ideas for the AB testing flywheel. Eppo powers experimentation across every use case, including product growth, machine learning, monetization and email marketing. Check out Eppo at geteppo.com/lenny and 10X your experiment velocity. That's getE-P-P-O.com/lenny. Marty Cagan, welcome back to the podcast.

**中文翻译:**
Eppo 还让你能轻松地与团队分享实验洞察，为 AB 测试的飞轮激发新灵感。Eppo 支持各种场景下的实验，包括产品增长、机器学习、变现和邮件营销。在 geteppo.com/lenny 查看 Eppo，让你的实验速度提升 10 倍。即 getE-P-P-O.com/lenny。马蒂·卡根，欢迎回到播客。

---

### (00:04:49) Marty Cagan

**English:**
Thanks very much Lenny. Thanks for inviting me back.

**中文翻译:**
非常感谢，莱尼。谢谢你再次邀请我。

---

### (00:04:52) Lenny

**English:**
Thank you for coming back. So our first episode together is still one of the top five most popular episodes of my entire podcast, which is wild because the podcast was much smaller back then. You've also got a book coming out. We're going to talk about that. You've also been getting a lot more spicy in your writing as of late. You've been writing about product management theater and product leadership theater and all these sorts of things. So I'm excited to dig into a lot of these things. I thought I'd start with just asking what is driving this recent spiciness in your writing?

**中文翻译:**
谢谢你的回归。我们合作的第一集至今仍是我整个播客中最受欢迎的前五集之一，这很疯狂，因为当时的播客规模要小得多。你还有一本新书要出版，我们待会聊聊。你最近的文章也变得越来越“犀利”（Spicy）了。你一直在写关于“产品管理演戏”和“产品领导力演戏”之类的内容。所以我很兴奋能深入探讨这些。我想先问问，是什么驱动了你最近写作中这种犀利的风格？

---

### (00:05:23) Marty Cagan

**English:**
It's conscious. I find myself, I'm aware of myself dialing up the rhetoric around this stuff. I've actually been saying these things for a long time, honestly, and it's on the record. You can read the blog articles from 10 years ago, 20 years ago, but things are changing. And first of all, I should acknowledge, I don't know if you're this way Lenny, but most product people I know like me are paranoid. So we're always worried that things are going to come and just take our customers away and disrupt our products. And so I know that there's a degree of that. I'm always looking at what are the things that could really shake things up in a good way but also in a bad way? And there's been a number of things I've been very worried about for a long time and I think that there's a convergence of factors that are going on and one of the challenges is it's simultaneous.

**中文翻译:**
这是有意识的。我意识到自己在加大这些事情的辞令力度。坦白说，这些话我已经说了很长时间了，都有记录在案。你可以去读我 10 年前、20 年前的博客文章，但时代在变。首先，我必须承认——莱尼，我不知道你是不是这样——但我认识的大多数产品人，包括我自己，都是“偏执狂”（Paranoid）。我们总是在担心会有什么东西出现，抢走我们的客户，颠覆我们的产品。所以我知道这其中有一定的成分。我一直在观察哪些事情可能会带来巨大的改变，无论是好的还是坏的。长期以来，我一直担心很多事情，我认为现在正处于多种因素的交汇点，而挑战之一在于它们是同时发生的。

---

### (00:06:22) Marty Cagan

**English:**
So there are a number of things happening in parallel, which is a recipe for some chaos and a lot of fear. And in the product community, in the design community, in the engineering community, it's there. You can see it. And like you, I talk to people pretty much every day. So I do have a lot of theories about why this is going on and what people can do to best protect themselves, their career, their companies. And so I'm happy to share that, but it's not small. It's not a small set. Maybe before I get into it though, I realize that people should understand where I'm coming from and how it's different than where you're coming from because this perspective... Just to be clear, I think we're both trying to help the product community, but we're trying to do it in very different ways.

**中文翻译:**
许多事情正在并行发生，这往往是混乱和恐惧的根源。在产品社区、设计社区、工程社区，这种情绪随处可见。和你一样，我几乎每天都在和人交流。所以我对于为什么会发生这些，以及人们如何最好地保护自己、职业和公司有很多理论。我很乐意分享，但这涉及的内容很多。不过在深入探讨之前，我意识到人们应该了解我的立场，以及我的立场与你的有何不同。明确地说，我认为我们都在努力帮助产品社区，但我们的方式非常不同。

---

### (00:07:18) Marty Cagan

**English:**
And I want to be clear, I love the way you do it. In fact, if people don't know, I'm a paid subscriber to yours because I find it incredibly useful for what I want to do. So let's talk about that. You obviously could describe what you do better than anyone, but my take is that you are, and this is what I find valuable, you're sharing a broad range, increasingly broad range of perspectives, people, ways of working, ways of doing products, experiments with the product model, experiments in leadership. I love that. It actually helps me a lot. That's why I subscribe. And I'll be honest, the main reason I took some prodding for me to... I know there's something about actually paying for a subscription when there's a hundred different product related newsletters and stuff, but what happened was you have a lot of subscribers and people that I know would see something and they'd email me and they'd say, "Did you see what Lenny was talking about with Lenny or with whoever? And how do you explain that? What do you think is going on?"

**中文翻译:**
我想明确一点，我非常喜欢你的方式。事实上，如果大家不知道的话，我是你的付费订阅者，因为我发现你的内容对我所做的事情非常有帮助。你显然比任何人都更能描述你所做的事，但在我看来——这也是我觉得有价值的地方——你分享了广泛且日益增长的视角、人物、工作方式、做产品的方法、产品模式的实验以及领导力的实验。我非常喜欢这一点，它确实对我帮助很大。这就是我订阅的原因。老实说，我花了一些时间才决定付费订阅，毕竟现在有上百种产品相关的简报，但事实是，你有这么多订阅者，我认识的人看到某些内容后会发邮件问我：“你看到莱尼和某某聊的内容了吗？你怎么解释那个？你觉得发生了什么？”

---

### (00:08:29) Marty Cagan

**English:**
And it made me want to watch a lot of these. Some of companies I know, but other ones you've introduced me to that I don't know anybody at. So to me that's incredibly valuable. It's a whole lot easier than the way it used to be, which is a whole lot of traveling to a lot of companies. So I love that. You are helping so many people to get a broader understanding of product. My goal is different, the SVPG. We are also trying to help the product community, but it's interesting when I watch your interviews, you're trying to pry out of people what's special about what they do, which is what I want to hear. But interestingly, what I'm looking for is not what's different, it's what's the same. What we are all about is sharing the principles and the practices that are used consistently by the best product companies. In fact, we have a heuristic, we've never made a secret of this.

**中文翻译:**
这让我想要去看很多你的节目。有些公司我了解，但有些是你介绍给我而我并不认识其中任何人的。所以对我来说，这非常有价值。这比以前到处出差跑公司要容易得多。所以我很喜欢这一点。你正在帮助这么多人更广泛地理解产品。而我的目标不同，也就是 SVPG（硅谷产品集团）。我们也试图帮助产品社区，但有趣的是，当我观看你的采访时，你试图挖掘出人们所做事情的“特殊之处”，这也是我想听的。但有趣的是，我寻找的不是“不同之处”，而是“相同之处”。我们的核心是分享那些被最优秀的产品公司一致使用的原则和实践。事实上，我们有一个启发式准则（Heuristic），我们从未对此保密。

---

### (00:09:27) Marty Cagan

**English:**
We are always asked about new techniques and new methods, new processes and we're like, "Look, we need to see it being used by at least several of the companies that have proven they can consistently innovate." If those companies can use it productively, we're all about evangelizing that. We make this clear in every one of the books. We don't invent any of these things. We just, if they work, we like to talk about them. So we are looking for the commonality and mostly we're looking to help a company, whether it's a startup or a large company to have the best possible chance of success. That's the goal for us. It's a different goal. You can see that. So all these data points become interesting as data points, but we're looking for those things that last and you never know. You have to see.

**中文翻译:**
总有人问我们关于新技术、新方法、新流程的问题，我们的态度是：“听着，我们需要看到它至少被几家已经证明能持续创新的公司所采用。”如果这些公司能有效地使用它，我们就会全力宣传。我们在每一本书中都明确了这一点：我们不发明任何东西。我们只是在它们奏效时谈论它们。所以我们寻找的是共性，主要是为了帮助一家公司——无论是初创公司还是大公司——获得最大的成功机会。这就是我们的目标。你可以看到这是个不同的目标。所以所有这些数据点本身很有趣，但我们寻找的是那些经久不衰的东西。你永远不知道，你必须观察。

---

### (00:10:25) Marty Cagan

**English:**
For one, I love working with startups, but as you know, a lot of startups are dominated by the founder and the early people and it almost doesn't matter what techniques they use. If they're good, it's amazing what they do. That's just amazing. And so that's probably important to get out of the way.

**中文翻译:**
一方面，我喜欢与初创公司合作，但如你所知，许多初创公司由创始人及其早期团队主导，他们使用什么技术几乎并不重要。如果他们足够优秀，他们所做的事情简直不可思议。这可能是一个需要先说明的重要前提。

---

### (00:10:44) Lenny

**English:**
Yeah, I love this.

**中文翻译:**
是的，我喜欢这个视角。

---

### (00:10:45) Marty Cagan

**English:**
Bringing that perspective.

**中文翻译:**
带入这个视角。

---

### (00:10:46) Lenny

**English:**
I agree with everything you said. I think we are very different in what we're providing to the product community. And it's interesting being on this side of the microphone is I built a lot of empathy for journalists. I know the Brian Chesky episode is a good example where there's a lot of things there that might sound problematic and you disagreed with. And as me interviewing him, the challenge I have is I have an hour with him and I have to always decide, do I go and push back and try to, hey, is this actually working the way you're describing? Is this actually the right way to approach stuff? Here's why maybe you would not. Versus there's so many things I want to get to and ask him about this stuff. I'm like, oh, which way do I go? And then if I'm pushing back too hard, people are like, "I'm not going to go on this podcast where he is just questioning everything I think." So it's a really interesting role.

**中文翻译:**
我同意你说的每一句话。我认为我们在为产品社区提供的内容上确实非常不同。坐在麦克风的这一端很有趣，我因此对记者产生了很大的共情。我知道布莱恩·切斯基（Brian Chesky）那一集是个很好的例子，其中很多内容听起来可能有问题，你也并不同意。作为采访者，我的挑战是只有一小时的时间，我必须决定：我是去反驳并尝试质疑“这真的像你描述的那样运作吗？这真的是正确的方法吗？这里有为什么不该这么做的理由”，还是去问我想问的其他很多事情。我常想，该走哪条路？如果我反驳得太厉害，人们会觉得：“我才不去上那个播客，他只会质疑我的一切想法。”所以这是一个非常有趣的角色。

---

### (00:11:27) Marty Cagan

**English:**
I think that's totally fair. And also, I don't think you want to scare off your guests. This is really the platform they have to share what they think is important. I do always find it entertaining because a number of the companies you profile I already know, and it's always fun to hear them describe it versus what I see at their company because of course they're not always same, but that's just human nature. We all do that. And so anyway, I hope you continue doing what you're doing, Lenny, and I'll keep following.

**中文翻译:**
我认为这完全公平。而且，你也不想吓跑你的嘉宾。这确实是他们分享自己认为重要事情的平台。我总觉得很有趣，因为你剖析的一些公司我本来就认识，听他们描述的方式与我在他们公司看到的实际情况对比总是很有意思，因为两者当然不总是一致的，但这就是人性，我们都会这样。总之，莱尼，我希望你继续做你正在做的事，我会继续关注的。

---

### (00:12:05) Lenny

**English:**
Amazing. I appreciate it. And same to you.

**中文翻译:**
太棒了，非常感谢。我也对你抱有同样的期待。

---

### (00:12:07) Marty Cagan

**English:**
All right.

**中文翻译:**
好的。

---

### (00:12:08) Lenny

**English:**
So with the writing, I think an implication with the way you're describing is basically you're telling people things they don't want to hear but they need to hear. That's the way you think about it, right?

**中文翻译:**
关于你的写作，我想你描述的方式意味着你基本上是在告诉人们一些他们不想听但必须听的事情。你是这么想的吧？

---

### (00:12:18) Marty Cagan

**English:**
I do. In fact, I've got some very uncomfortable things to talk about, which I know the more intelligent part of me is like, "Don't bring that up." But also the other side of me is like, "But people need to hear it."

**中文翻译:**
是的。事实上，我有一些非常令人不快的事情要谈，我理智的一面会说“别提那个”，但另一面却觉得“但人们需要听到它”。

---

### (00:12:36) Lenny

**English:**
So let's talk about it if people need to hear it, which I agree. So you've been talking about this concept of product management theater and product leadership theater. Let's get into it. What does that look like? What is the sign that you're in this theater versus doing it the way you should be doing it?

**中文翻译:**
既然人们需要听，那我们就聊聊吧，我也同意这一点。你一直在谈论“产品管理演戏”和“产品领导力演戏”的概念。让我们深入探讨一下。那是什么样子的？身处这种“演戏”状态而非正确做事方式的迹象是什么？

---

### (00:12:48) Marty Cagan

**English:**
There is no question that a lot of companies overhired during the pandemic. That was easy to see even while it was going on. And it's not just that they overhired, a lot of them lowered the bar. But at the same time, of course we have a change in the financial world that has really increased the cost of funds. And that's another thing going on simultaneously. And probably one of the biggest things of all, and this is the hardest because it's not happened yet, is the predicted impact of generative AI, right? I don't know if you saw, literally the CEO of NVIDIA the other day was saying don't learn programming.

**中文翻译:**
毫无疑问，许多公司在疫情期间过度招聘了。即使在当时，这也很容易看出来。而且不仅是过度招聘，很多公司还降低了门槛。与此同时，金融界的变化确实增加了资金成本。这是另一件同时发生的事情。而其中影响最大的——也是最难预测的，因为它还没完全发生——就是生成式 AI 的预期影响，对吧？不知道你看到没，英伟达（NVIDIA）的 CEO 前几天竟然说不要学编程了。

---

### (00:13:34) Marty Cagan

**English:**
First of all, I'm not even sure that's good advice, but the fact that the CEO of one of the most amazing companies in the world is saying don't learn programming, that's disruptive. And so at a minimum it creates uncertainty among the leaders in the companies, at a minimum. But honestly, I think there's very real impact. I'm convinced of that. I just don't know the real time horizon. I've got a long history of being overly optimistic. I think things are going to happen sooner than they really do. So I don't know when they'll really happen, but that's a big one. Here's another one that I think is not talked nearly enough about, and that is in a lot of companies, especially outside of Silicon Valley, team size has just gotten out of hand. I go into some companies and honestly I can't believe all the ridiculous roles that they have.

**中文翻译:**
首先，我不确定这是否是个好建议，但世界上最了不起的公司之一的 CEO 居然说不要学编程，这具有颠覆性。这至少会在公司领导层中制造不确定性。但老实说，我认为会有非常真实的影响，我对此深信不疑。我只是不知道具体的时间线。我一直有过度乐观的毛病，总觉得事情发生得会比实际快。所以我不知道什么时候会真正发生，但这是一个大因素。另一个我认为讨论得还远远不够的因素是，在很多公司，尤其是硅谷以外的公司，团队规模已经失控了。我走进一些公司，坦白说，我简直不敢相信他们设立了那么多荒谬的角色。

---

### (00:14:44) Marty Cagan

**English:**
And I'll go into that more if you want later, but no question that people realize that smaller teams can often produce more and better results. How many of your guests have said as much? I've heard it from many of them. It's reducing the size of the organization ironically can get you a lot more in terms of results. So there's this general appreciation that maybe we overdid it here with all of these roles. And of course I'm talking about agile coaches and product owners and product ops and business analysts and all these assistant product manager types. So we'll go into that if you want, but it's gotten out of hand at a lot of companies. And then the one that I really probably shouldn't bring up just because it's become a religious topic almost. I know it's a super sensitive topic for people, but the reality is with remote employees, both velocity and innovation have taken a real hit. Now we can talk about, don't get me wrong, I don't think we're ever going to go back to the days of big companies having almost all co-located teams.

**中文翻译:**
如果你愿意，稍后我可以详细展开，但毫无疑问，人们意识到小团队往往能产生更多、更好的结果。你的嘉宾中有多少人说过类似的话？我听很多人提过。讽刺的是，缩小组织规模反而能让你获得更多成果。所以现在大家普遍意识到，我们可能在这些角色上做得过头了。当然，我指的是敏捷教练、产品负责人、产品运营、业务分析师以及所有这些助理产品经理之类的角色。如果你想聊，我们可以深入探讨，但在很多公司这已经失控了。还有一个我可能真的不该提的话题，因为它几乎变成了一个“宗教”话题。我知道这对人们来说是个超级敏感的话题，但现实是，由于远程办公，速度和创新都受到了沉重打击。我们可以讨论这个——别误会，我不认为我们会回到大公司几乎所有团队都集中办公（Co-located）的时代。

---

### (00:15:49) Marty Cagan

**English:**
But there is no question, I work with a lot of them, they are all struggling with innovation and velocity. Things go slower and they don't really do that level of innovation that they used to do. And these are big factors, these are macro factors that are going on. And then on top of that, if you get outside of the Silicon Valley bubble, it's even worse because they have been investing at these companies, especially the big companies in all these extra roles. I mentioned agile coaches, but scrum masters and every flavor of project manager you could dream up, they're everywhere and every kind of assistant to product people. I think it's gotten crazy. In fact, I wrote an article a long time ago, something like a decade ago that was very popular at the time called Epic Waste, and I was pointing this out and saying this is crazy. The ironic thing is that the better companies do way more with a lot less.

**中文翻译:**
但毫无疑问，我与很多公司合作过，他们都在创新和速度上苦苦挣扎。事情进展变慢了，他们也无法达到以前那种创新水平。这些都是大因素，是正在发生的宏观因素。除此之外，如果你走出硅谷的泡沫，情况甚至更糟，因为这些公司，尤其是大公司，一直在投资这些额外的角色。我提到了敏捷教练，还有 Scrum Master 以及你能想象到的各种项目经理，他们无处不在，还有各种产品人员的助理。我认为这已经变得疯狂了。事实上，很久以前，大约十年前，我写过一篇当时非常流行的文章叫《史诗级的浪费》（Epic Waste），我指出并说这太疯狂了。讽刺的是，更优秀的公司用更少的人做了更多的事。

---

### (00:16:55) Marty Cagan

**English:**
So anyway, the roles. And then what about all the years that have been going on where they think these big companies think the answer lies in processes, especially things like safe, which outside of the Silicon Valley world is depressingly popular? And even though scrum, a lot of people don't even understand simple processes like scrum and they miss the point. So what's going on in so much of the world is they have so little in the way of outcomes to show for all this cost. And we talked about the sheer number of people becomes a problem and the amount of that cost can be shocking and the amount of waste is basically embarrassing. So it is not a surprise to me that companies are reacting to that. The bigger surprise honestly is it's taken so long for so many companies to realize what is going on.

**中文翻译:**
总之，就是这些角色。还有这些年来，那些大公司一直认为答案在于流程，尤其是像 SAFe（规模化敏捷框架）这种东西，在硅谷以外的地方流行得令人沮丧。即使是 Scrum，很多人甚至不理解像 Scrum 这样简单的流程，完全抓不住重点。所以世界上很多地方的情况是，投入了这么多成本，却几乎没有“成果”（Outcomes）可以展示。我们谈到人数过多成为了一个问题，成本之高令人震惊，浪费的程度基本上令人汗颜。所以公司对此做出反应，我并不感到意外。坦白说，更大的意外是这么多公司花了这么长时间才意识到发生了什么。

---

### (00:17:51) Marty Cagan

**English:**
And bottom line is today I think everybody, especially outside in those big process and role heavy companies, they need to take a hard look at how they build products and how they serve their customers. And they need to look harder at how the best companies do this with so much less proportional spend and so much more real return and really take a fresh look at how to best meet the needs of their customers. That's what transformation is about, is moving to work like that. And the ones that do that well I think are the ones with the best chance to survive.

**中文翻译:**
底线是，今天我认为每个人，尤其是那些身处流程繁琐、角色臃肿的大公司的人，都需要认真审视他们构建产品和为客户服务的方式。他们需要更深入地研究最优秀的公司是如何以极低的比例支出获得极高的真实回报的，并真正重新审视如何最好地满足客户需求。这就是“变革”（Transformation）的意义所在——转向那种工作方式。我认为那些做得好的人才是最有机会生存下来的人。

---

### (00:18:33) Lenny

**English:**
I think there's just this broader trend of people just really dislike PMs in a lot of places. There's this just trend of I don't want PMs at my company, I don't want PMs at my startup. For a long time, we're going to have no PMs. It's like this general idea, and I think you're saying a lot of this comes from many people who were hired as product managers that are not good at the job and people's experience with PMs is those sorts of people.

**中文翻译:**
我认为现在有一个更广泛的趋势，就是很多地方的人真的很讨厌 PM（产品经理）。有一种趋势是“我公司不想要 PM，我初创公司不想要 PM，我们要很长一段时间不设 PM”。这像是一种普遍的想法，我想你是说这很大程度上源于许多被聘为产品经理的人并不擅长这份工作，而人们对 PM 的体验就来自于这类人。

---

### (00:18:56) Marty Cagan

**English:**
I think it's a different really answer. And I haven't gone into this, but you probably. Those examples, with very few exceptions, and I hear it all the time, almost every day, what you're describing, they're feature teams. And the truth is, and I've been saying this for a long time, the truth is they don't need PMs in a feature team. They don't because it's a project management role, Lenny, and they already have plenty of people who can cover that. And furthermore, a lot of times the engineers or the designers say, "We'd rather do it ourselves than deal with this person that's got this complex and trying to be the boss of everybody and they really don't contribute anything." So that's what's really going on in my view. They are either a delivery team or a feature team, usually a feature team in this model.

**中文翻译:**
我认为真正的答案有所不同。我还没深入探讨过这个，但你可能听过。那些例子，极少数除外——我几乎每天都能听到你描述的情况——他们其实是“功能团队”（Feature Teams）。事实是，我已经说了很久了，功能团队根本不需要 PM。莱尼，因为那本质上是一个项目管理角色，而他们已经有足够的人手来应付了。此外，很多时候工程师或设计师会说：“我们宁愿自己干，也不愿应付这个自命不凡、想当所有人老大却没有任何贡献的人。”所以在我看来，这就是真相。在这种模式下，他们要么是交付团队，要么是功能团队，通常是后者。

---

### (00:19:49) Marty Cagan

**English:**
And I don't blame those people for not finding value in the product manager. They are just not bringing that value. They do bring a little value, in fairness, but, and this is very brutal, but they're dramatically overpaid for the value they provide. Now on the other hand, in a real product team, that's a very different job and I don't see that. In fact, I consider that complaint you're raising as the biggest clue that they're probably our feature team. And then I'll go ask them how they're working and what that person... And then of course the first thing I ask the product manager is how do you define your job? And I bet you've heard a hundred variations of the mealy mouth, squishy, I facilitate this and I do some communication and I herd the cats and I'm listening to that going, man, I would not want to try to defend that job to the CEO.

**中文翻译:**
我不怪那些人觉得产品经理没价值。因为他们确实没带来价值。公平地说，他们确实带来了一点点价值，但——这很残酷——相对于他们提供的价值，他们的薪酬高得离谱。另一方面，在真正的产品团队中，那是一份完全不同的工作，我没见过这种抱怨。事实上，我认为你提到的那种抱怨是判断他们可能是功能团队的最大线索。然后我会问他们是如何工作的，那个人在做什么……当然，我问产品经理的第一件事就是：你如何定义你的工作？我敢打赌你听过一百种含糊其辞、软绵绵的说法：“我负责协调这个，我做一些沟通，我负责‘赶猫’（指管理琐碎事务）。”我听着这些心想：天哪，我可不想向 CEO 辩护这份工作。

---

### (00:20:46) Lenny

**English:**
I know you talk about teams and product teams a lot. I imagine people still aren't 100% sure of exactly what you mean when you say that. So let's spend a little time on just what does it look like when you're on a feature team, feature factory versus an empowered product team?

**中文翻译:**
我知道你经常谈论团队和产品团队。我想人们可能还不百分之百确定你所说的具体含义。所以让我们花点时间聊聊，身处“功能团队”或“功能工厂”与身处“赋能型产品团队”（Empowered Product Team）到底有什么区别？

---

### (00:21:01) Marty Cagan

**English:**
Well, there's a lot of clues for sure. Some of the easiest is on a feature team, you're basically given a roadmap of output. That's the key, is output. In other words, their features are projects that usually it could have come from an executive, could have come from a big pocket customer, could have come from wherever. But it's a bunch of features and literally you're being asked to design, build, test, deploy that feature. You're usually given dates and timeframes as well, but that's a feature team. You deliver. And don't get me wrong, that's still work, but that's output. It is a lot easier to deliver output than it is to deliver outcomes. And a product team, an empowered product team, instead of being given that roadmap of features, they're given problems to solve. Now they're customer problems or they're business problems or both, but they're given a problem to solve.

**中文翻译:**
确实有很多线索。最简单的一点是，在功能团队中，你基本上被给予了一份“产出路线图”（Roadmap of Output）。关键在于“产出”。换句话说，他们的功能就是项目，通常来自高管、大客户或任何地方。就是一堆功能，你被要求去设计、构建、测试、部署那个功能。通常还会给你日期和时间表，这就是功能团队。你负责交付。别误会，那也是工作，但那是“产出”。交付产出比交付“成果”（Outcomes）容易得多。而一个产品团队，一个赋能型产品团队，不是被给予功能路线图，而是被给予要解决的问题。这些可能是客户问题、业务问题或两者兼有，但核心是给他们一个要解决的问题。

---

### (00:21:57) Marty Cagan

**English:**
Usually one or two a quarter on top of of course the keep the lights on kind of work that everybody does, but they're given hard problems to solve and the measure is not ship the thing. The measure is it solves the problem. And that's why really the biggest difference between a strong product company and the rest is strong product companies understand it's all about outcomes. You just don't get points for shipping, you get points for delivering the value. A lot of the CEOs and CFOs I talk to, they resonate best when I frame it as it's about time to money more than time to market. We know how to do time to market. If you insist on time to market, we know how to do that. The techniques are well-known. The harder part is time to money and I know that's what they care about and that's harder and that's what a product team really does.

**中文翻译:**
除了每个人都要做的日常维护工作外，通常每季度会有一两个难题。他们被给予难题去解决，衡量标准不是“把东西发出去”，而是“它是否解决了问题”。这就是为什么强大的产品公司与其他的公司最大的区别在于：强大的产品公司明白一切都关乎“成果”。你不会因为发布了产品而得分，你会因为交付了价值而得分。我接触过的许多 CEO 和 CFO，当我把它表述为“变现时间”（Time to Money）而非“上市时间”（Time to Market）时，他们最能产生共鸣。我们知道如何做上市时间，如果你坚持要这个，我们有成熟的技术。难点在于变现时间，我知道这才是他们关心的，这更难，而这正是产品团队真正做的事情。

---

### (00:22:51) Marty Cagan

**English:**
It's only when you sign up for an outcome that you have the needs for a product manager. I would say in the Silicon Valley sense, that's when you need a product manager. Because if you've been asked to solve these problems, that means you have to come up with a solution that's not only usable and feasible, which is what a feature team does, but is also valuable and viable. And that means you need a different set of skills that your engineers and your designers almost never have. That's not a knock on them. Those are very different skillsets. So now you need this person who understands the customers and understands the business deeply. That's where the product manager role came from. That's what they still at a good product company are responsible for. So that's a very different job. It's also if you have a person playing that kind of product manager, it is very unlikely they've got time on their hands to get in the face of the designer and start wire framing for them or start irritating the developers. They've got their own work to do.

**中文翻译:**
只有当你承诺交付一个“成果”时，你才需要产品经理。我会说，在硅谷的语境下，那是你真正需要产品经理的时候。因为如果你被要求解决这些问题，这意味着你必须想出一个不仅“可用”（Usable）和“可行”（Feasible，功能团队也能做这两点），而且还必须是“有价值”（Valuable）和“商业可行”（Viable）的解决方案。这意味着你需要一套你的工程师和设计师几乎从未具备的技能。这不是在贬低他们，这些是完全不同的技能集。所以现在你需要这个深入了解客户和业务的人。这就是产品经理角色的由来。在好的产品公司，他们仍然负责这些。所以这是一份完全不同的工作。而且，如果你有这样一个产品经理，他不太可能有闲工夫去干涉设计师画原型，或者去烦开发人员。他们有自己的工作要做。

---

### (00:24:00) Lenny

**English:**
And this is essentially the theater you're describing, that people that aren't real product managers doing product management activities, can you just talk about what that looks like?

**中文翻译:**
这就是你所描述的“演戏”，即那些不是真正产品经理的人在进行产品管理活动。你能谈谈那看起来像什么吗？

---

### (00:24:09) Marty Cagan

**English:**
The biggest example of that is that they carry this title product manager because the whole world largely, thanks to you, knows it's cool, but they're not doing any of the role and they don't have any of the skills. Now of course, what really bothers me is it's not that hard if they are motivated. It's not that hard for them to develop the skills, and that's what I talk to people about. You can raise your game so that you actually can contribute at this level. That's what you should do for your own career, but by the way, and not accidentally, that's what your company needs you to do.

**中文翻译:**
最大的例子就是他们挂着“产品经理”的头衔，因为全世界很大程度上（多亏了你）都知道这个头衔很酷，但他们并没有履行这个角色的职责，也不具备相应的技能。当然，真正让我困扰的是，如果他们有动力，这并不难。培养这些技能并不难，这也是我经常和人们谈论的。你可以提升自己的水平，从而真正达到这个层次的贡献。为了你自己的职业生涯，你应该这样做；而且顺便说一句，这绝非偶然，这正是你的公司需要你做的。

---

### (00:24:48) Lenny

**English:**
And for people that are listening to this wondering, what are these skills that I need to build to be a real product manager? I think you often say it's mostly focused on value and viability, and that's where a lot of this-

**中文翻译:**
对于那些正在听节目并想知道“为了成为真正的产品经理，我需要培养哪些技能”的人，我想你经常说主要集中在“价值”和“商业可行性”上，这就是很多……

---

### (00:24:58) Marty Cagan

**English:**
Value and viability is what you are responsible for as a product manager, just like an engineer is responsible for feasibility, it has to be a solution that can be built and delivered. But a product manager is responsible for value and viability. Another way I like to frame this is on a real empowered product team, product manager is a creator, not a facilitator. I always cringe when somebody tells me, oh, my job is to say why? And I'm like, "Well, what do you do for the rest of the week besides the 10 minutes it takes you to say why?" It's ridiculous. People think that. But you know what? On a feature team, when you're scrounging around for some justification of your job, it's not that big a surprise. But no, the why actually comes from the product strategy anyway. You don't even do the why.

**中文翻译:**
价值和商业可行性是你作为产品经理要负责的，就像工程师负责“可行性”（Feasibility）——即必须是一个可以构建和交付的解决方案。但产品经理负责价值和商业可行性。我喜欢的另一种表述方式是：在真正的赋能型产品团队中，产品经理是“创造者”，而不是“协调者”（Facilitator）。每当有人告诉我“哦，我的工作是解释‘为什么’（Why）”时，我都会感到尴尬。我会想：“除了花 10 分钟解释‘为什么’，你这一周剩下的时间都在干嘛？”这太荒谬了。人们居然这么想。但你知道吗？在功能团队中，当你四处寻找工作的合理性时，这并不奇怪。但实际上，“为什么”来自于产品战略，你甚至都不负责制定“为什么”。

---

### (00:25:45) Marty Cagan

**English:**
A product manager is a creator and so there's this side-by-side creation with design and engineering to come up with these solutions. Now, in order to do your job and represent value and viability, there are some real skills that are involved. First of all, you have to really become an expert on your users and customers. I know that I was not allowed to take the product manager role until I had visited 30 customers in person, 15 in the US, 15 in Europe. That was just the person who was coaching me. That was their rule. And all I know is those 30 customers changed my life because I thought I knew our customers and I really didn't. Another is you're supposed to be the expert on the data. How is our product being used? How is that usage changing over time? How is it being purchased? So that's big. Another big one is you are the person on the team that represents the compliance issues, the sales issues, the marketing issues, the financial cost issues, the monetization issues, go to market in general.

**中文翻译:**
产品经理是一个创造者，因此需要与设计和工程部门并肩作战，共同构思这些解决方案。现在，为了履行职责并代表价值和商业可行性，需要一些真实的技能。首先，你必须真正成为用户和客户的专家。我记得在亲自拜访 30 位客户（美国 15 位，欧洲 15 位）之前，我是不被允许担任产品经理角色的。那是当时指导我的人定的规矩。我只知道那 30 位客户改变了我的生活，因为我原以为我了解客户，其实不然。其次，你应该成为数据专家。我们的产品是如何被使用的？使用情况随时间如何变化？它是如何被购买的？这非常重要。另一个重点是，你是团队中代表合规问题、销售问题、营销问题、财务成本问题、变现问题以及整体进入市场（Go-to-market）策略的人。

---

### (00:26:51) Marty Cagan

**English:**
This is all legal constraints. This is all the product manager. Just think if you don't have this person on the team and you want to empower this team to make decisions, what are you going to do? You're just going to make it up? Or what they usually do is they call meetings with 20 stakeholders all in a room to try to decide these things, and now you've reverted to design by committee. So no, the product manager needs to bring this knowledge. They also need to bring deep understanding of the market. So when I describe these things to a typical product owner, they're like, "We're on different planets." What they learned in a CSPO or a PSPO class was how to manage a backlog in Jira, which to me is very analogous to learning how to operate Google Docs. Of course, that's not the job. That's something we do every day, but it's not the job just any more than...

**中文翻译:**
这些都是法律约束。这些都是产品经理的职责。试想一下，如果团队中没有这样一个人，而你又想授权这个团队做决定，你会怎么做？瞎编吗？或者他们通常的做法是召集 20 个利益相关者开会，试图决定这些事情，结果又回到了“委员会式设计”。所以不，产品经理需要带来这些知识。他们还需要对市场有深刻的理解。当我向典型的“产品负责人”（Product Owner）描述这些时，他们会觉得“我们不在同一个星球上”。他们在 CSPO 或 PSPO 课程中学到的是如何在 Jira 中管理待办事项（Backlog），对我来说，这就像学习如何操作 Google Docs 一样。当然，那不是工作本身。那是我们每天都要做的事，但它不是工作，就像……

---

### (00:27:50) Marty Cagan

**English:**
Developers are in Jira every day. Does that mean that's their job? Of course not. Their job is to build. So this is what a product manager contributes. And really the distinction, if you want to think about it on a spectrum, a product owner is one extreme. And honestly, that is a role in a delivery process. That has no business being a dedicated person, really doesn't. And most teams I know, the senior engineer could do it better anyway. Second on the other side of the spectrum is what we're talking about, an empowered product manager. And then a feature team product manager is somewhere in between there. They do more than administer the backlog. They do a lot of project management. And don't get me wrong, project management is important, but it is not product management. And furthermore, in almost every company I see with feature team product managers, they have a boatload of project managers anyway.

**中文翻译:**
开发人员每天都在用 Jira，那意味着那是他们的工作吗？当然不是。他们的工作是构建。所以这就是产品经理的贡献。真正的区别在于，如果你把它看作一个光谱，产品负责人（Product Owner）是一个极端。坦白说，那只是交付过程中的一个角色。它根本不该是一个专门的职位，真的不该。在我认识的大多数团队中，高级工程师无论如何都能做得更好。光谱的另一端就是我们所说的赋能型产品经理。而功能团队的产品经理介于两者之间。他们做的不仅仅是管理待办事项，他们还做大量的项目管理。别误会，项目管理很重要，但它不是产品管理。此外，在几乎所有我见过的拥有功能团队产品经理的公司里，他们本来就已经有一大堆项目经理了。

---

### (00:28:51) Marty Cagan

**English:**
So you could hear there's some exasperation in my voice because I feel like this has been quite clear for a long time, but most companies are deaf to this. They don't care. And I have theories about why, but that's kind of depressing. But for whatever reason, I feel like now I'm raising the volume because people are now seeing this the hard way because a lot of companies are cutting and these are easily among the most vulnerable people in a company.

**中文翻译:**
所以你能听出我声音里的无奈，因为我觉得这些事情已经很清楚很久了，但大多数公司对此充耳不闻。他们不在乎。我有一些关于原因的理论，但这挺让人沮丧的。但无论出于什么原因，我觉得现在我要加大音量，因为人们现在正通过惨痛的方式意识到这一点，因为很多公司都在裁员，而这些人很容易成为公司里最脆弱的群体。

---

### (00:29:27) Lenny

**English:**
Let me actually read a quote from you where you talk about this exact point. You wrote, "I have been warning for several years that delivery team, product owners and feature team product managers are likely to be facing a reckoning as companies realize that these roles are not what they thought they were. From what I can tell, that reckoning has begun and I'm expecting GenAI will only compound this."

**中文翻译:**
让我读一段你关于这一点的原话。你写道：“几年来我一直在警告，交付团队的产品负责人和功能团队的产品经理可能会面临一场‘清算’（Reckoning），因为公司意识到这些角色并不是他们想象的那样。据我观察，这场清算已经开始，我预计生成式 AI 只会加剧这一进程。”

---

### (00:29:48) Marty Cagan

**English:**
That's the pessimistic version of the world. Either I might be overreacting. Might be. I'm not really known for being alarmist, but maybe. It's possible. I hope so, but I doubt it. I think these trends are real. Now, does that mean people are... It's hopeless? They should all start retraining to be, I don't know what, housing construction, something that GenAI won't replace maybe? No. I think what really this does is you need to raise your skills. Enough with the silly facades of delivery teams and feature teams. You should raise your skills. And a lot of product managers, they reach out and they're like, "I know I'm in a feature team and I don't like it." I often use the phrase they're trapped in a feature team and they're like, "This isn't what I signed up for. The New York Times article about product management wasn't this. This was different." And they're like, "What should I do? Should I just leave my company and go to one of these other companies?"

**中文翻译:**
那是对世界的悲观版本。我也可能反应过度了。也许吧。我不以危言耸听著称，但也许。有可能。我希望如此，但我怀疑。我认为这些趋势是真实的。那么，这是否意味着人们……没希望了？他们都应该开始重新培训去做，我不知道，房屋建筑之类的，也许是生成式 AI 不会取代的工作？不。我认为这真正意味着你需要提升技能。别再搞那些交付团队和功能团队的愚蠢表象了。你应该提升技能。很多产品经理联系我，说：“我知道我在功能团队，我不喜欢这样。”我经常用“被困在功能团队”这个词，他们会说：“这不是我入行时想要的。关于产品管理的《纽约时报》文章说的不是这个，这完全不同。”他们会问：“我该怎么办？我应该离开公司去其他公司吗？”

---

### (00:31:01) Marty Cagan

**English:**
And I try to explain that they actually have a lot more agency than they realize. There is a lot an individual contributor... Of course, there's way more than a product leader could do. And that's the biggest shame in all this, is they're not doing this. Most product leaders are not doing this 'cause they of course have a lot of agency, a lot of ability to change a company. But an individual can do it as well. They can raise their game. They can literally do a self-assessment and raise the skills from a product owner or a feature team product manager to a real product manager. At a minimum, I tell people, and I've seen this countless times, at a minimum, your company will appreciate it and probably promote you because you will be one of the few that actually understands these things. Hopefully even more than that, they'll say, hey, why don't we try running a set of teams this way and see how we do? So it can happen from the ground up too.

**中文翻译:**
我试图解释，他们拥有的“主观能动性”（Agency）其实比他们意识到的要多得多。作为个人贡献者，有很多事可以做……当然，产品领导者能做的更多。而这一切中最遗憾的是，他们没有这样做。大多数产品领导者没有这样做，尽管他们拥有很大的能动性和改变公司的能力。但个人也可以做到。他们可以提升自己的水平。他们完全可以进行自我评估，将技能从产品负责人或功能团队产品经理提升到真正的产品经理。我告诉人们——我也见过无数次这样的例子——至少，你的公司会感激你，并可能提拔你，因为你将是少数真正理解这些事情的人之一。更有甚者，他们可能会说：“嘿，为什么我们不尝试用这种方式运行一组团队，看看效果如何？”所以，这种改变也可以自下而上地发生。

---

### (00:32:05) Lenny

**English:**
I imagine many people are wondering, how do I do this? I know you've written books, I guess there's courses, there's all kinds of things. If you could give people a couple tips of how to get better at this and what skills to focus on, what's a quick piece of advice you could share there?

**中文翻译:**
我想很多人都在想，我该怎么做？我知道你写过书，我想还有课程，各种各样的东西。如果你能给人们一些关于如何变得更好以及应该专注于哪些技能的建议，你能分享一些简短的建议吗？

---

### (00:32:19) Marty Cagan

**English:**
Well, this is maybe the most frustrating thing to me of all. And in fact, I should have answered when you asked me what motivated me to get spicy, what pushed me over the edge. Maybe I was in a bad mood that day, I don't know. But it was this article that made the rounds online by probably the biggest certification institution for product managers. And they had this big article saying, "This is what a product manager does." And it was a big graphic, and I'm looking at it and I was thinking, I cannot believe they said this out loud. This is 100% project manager, 100%. They didn't even pretend to put a little of the product, which most people of course are more creative than that. They bend over a little bit to make it look like a product manager, but not even close.

**中文翻译:**
嗯，这可能是我觉得最沮丧的事情。事实上，当你问我为什么变得犀利时，我本该回答是什么把我推向了边缘。也许那天我心情不好，我不知道。但那是因为一篇在网上流传的文章，出自可能是最大的产品经理认证机构。他们发了一篇大文章说：“这就是产品经理的工作。”配了一张大图，我看着它心想：我简直不敢相信他们居然敢大声说出来。这 100% 是项目经理，100%。他们甚至都不屑于假装放一点“产品”的内容，而大多数人当然比这更有创意。他们会稍微修饰一下，让它看起来像产品经理，但那张图甚至连边都不沾。

---

### (00:33:11) Marty Cagan

**English:**
And what I realized is what's so frustrating here is you have all these people that realize things aren't good yet most places they turn are just propagating that same model. So these certifications, which in my opinion are bogus, but most people don't know. And just imagine you're a brand new product manager. You look online probably what, 90% of the content out there is from the feature team world or worst. And so unless they get really lucky or they happen to be really lucky and have a manager that is guiding them in a good direction, it just propagates. And you see this all over, articles, books, conference speakers, and a lot of times I can't even bear to watch. And it's not like there aren't great people out there who can speak. It's just that proportionally they're in the minority. So it's not as easy as it should be. Like you're saying, why can't people just go and learn?

**中文翻译:**
我意识到最令人沮丧的是，有这么多人意识到现状不佳，但他们求助的大多数地方却只是在传播同样的模式。所以这些认证——在我看来是伪造的，但大多数人并不知道。想象一下你是一个全新的产品经理，你在网上搜索，大概 90% 的内容都来自功能团队的世界，甚至更糟。所以除非他们非常幸运，或者碰巧有一个引导他们走向正确方向的经理，否则这种模式只会不断传播。你在各处都能看到这种情况：文章、书籍、会议演讲者，很多时候我甚至不忍直视。并不是说没有优秀的演讲者，只是按比例来说，他们是少数。所以这并不像它本该有的那样容易。就像你说的，为什么人们不能直接去学习呢？

---

### (00:34:14) Marty Cagan

**English:**
They can if they're lucky enough to know where to go. Obviously I'm biased. You're biased too. We're biased on this, but people need to take more control of their career and really use their judgment, try to figure out what do you want to be if you want to be in the product world? What do you want to be? What kind of a product manager do you want to be? And if you want to stay, fine, but if you want to do this, then there are good resources for sure. There are good resources out there. And of course, I'm hoping more and more people do that.

**中文翻译:**
如果他们足够幸运知道该去哪里，他们是可以学到的。显然我有偏见，你也有偏见，我们在这方面都有偏见。但人们需要更多地掌控自己的职业生涯，真正运用自己的判断力，试着弄清楚：如果你想进入产品界，你想成为什么样的人？你想成为什么样的产品经理？如果你想维持现状，那没问题；但如果你想做到这一点，那肯定有好的资源。外面有好的资源。当然，我希望越来越多的人这样做。

---

### (00:34:59) Lenny

**English:**
I think that's such a powerful insight you just shared, that most of the content you find online about product management is, I think you called it 90%, or it's just from companies that are not doing it the right way, feature teams is the way you described it. Can you talk a bit more about that? Why is that the case? Why don't we hear more from great companies?

**中文翻译:**
我认为你刚才分享的见解非常有力量：你在网上找到的关于产品管理的大多数内容（你说是 90%）都来自于那些方式不对的公司，也就是你描述的“功能团队”。你能再多谈谈吗？为什么会这样？为什么我们听不到更多来自优秀公司的声音？

---

### (00:35:18) Marty Cagan

**English:**
In fact, one of the most frustrating things for me is community. One of the things that's great about community... You have one of the biggest communities today, but there's a lot of these communities out there in the product world, product sub communities. And the one I love about them is pretty much everybody you meet genuinely wants to help. Really everybody. The problem is somebody posts a question, happens many times every day, and the majority of the well-meaning people jump in with what they learn at their crappy company. And I'm looking at that and the person is, oh, thank you very much, now I know what to do. And I'm going, "Oh no, there goes another one." It becomes self-propagating. And what are you going to do? Is somebody going to try to police these boards, thousands and thousands of them, like a Lenny endorsed person or a Marty endorsed person? I don't want to do that. You probably don't want to do that.

**中文翻译:**
事实上，对我来说最令人沮丧的事情之一就是“社区”。社区有很多优点……你现在拥有最大的社区之一，但在产品界还有很多其他的子社区。我喜欢它们的一点是，你遇到的几乎每个人都真心想提供帮助。真的是每个人。问题是，有人发了一个问题（每天都会发生很多次），大多数好心人就会跳出来，分享他们在自己那家糟糕公司学到的东西。我看着这些，提问的人说：“哦，非常感谢，现在我知道该怎么做了。”而我会想：“噢不，又毁了一个。”这变成了自我传播。你能怎么办？难道要有人去监管这些成千上万的板块吗？比如搞个“莱尼认证”或“马蒂认证”的人？我不想那样做，你可能也不想。

---

### (00:35:18) Lenny

**English:**
No.

**中文翻译:**
不想。

---

### (00:36:21) Marty Cagan

**English:**
It's a recipe for disaster. So there are so many reasons it propagates. Most of the books I see, I'm asked to review a lot of the books. I love it when it's an exception and it's like, wow, that's a good book. Teresa Torres's book, Continuous Discovery Habits, good book. Try to get everybody to read that. But that's the exception. And most of the time people are earnestly describing what they learn, not really what good companies do. So it's very difficult because these are not bad people. They're well-meaning.

**中文翻译:**
那是灾难的根源。所以它传播的原因有很多。我看到的书，很多都被要求写书评。我喜欢那些例外，比如“哇，这是一本好书”。特蕾莎·托雷斯（Teresa Torres）的书《持续探索习惯》（Continuous Discovery Habits）就是本好书，我试着让每个人都读读。但那是例外。大多数时候，人们只是在诚恳地描述他们学到的东西，而不是优秀公司真正做的事情。所以这很难，因为这些人不是坏人，他们是出于好意。

---

### (00:37:03) Lenny

**English:**
Do you have any advice for somebody asking questions, getting answers, and having a sense of, should I listen to these people?

**中文翻译:**
对于那些正在提问、获取答案的人，你有什么建议能让他们判断“我该听这些人的吗”？

---

### (00:37:10) Marty Cagan

**English:**
It's very much this exists in the whole world, right? Buyer beware. You have to use your judgment. You have to think. Probably the most important skill for product people, and I know this sounds awful, but is really learning how to think critically. And that involves literally evaluating. I know I talk to people all the time when I help them for their interviewing. I say, "Look, the most important thing, you need to do some research on the manager that will be your direct manager. Do some background research. Go look at where they worked. It's all on LinkedIn. Check out those companies, check out that product. Make sure you are prepared there because that's what really matters. Not so much the company, but who's going to coach you." So there's a lot that people can do to prepare themselves, arm themselves, take more ownership of their career.

**中文翻译:**
这在全世界都一样，对吧？“购者自慎”（Buyer beware）。你必须运用你的判断力。你必须思考。对于产品人来说，最重要的技能——我知道这听起来很糟糕——其实是学会如何“批判性思考”。这涉及到字面意义上的评估。我经常在帮人准备面试时告诉他们：“听着，最重要的事情是，你需要对将成为你直属经理的人做一些研究。做背景调查，看看他们以前在哪里工作过，LinkedIn 上都有。去研究那些公司，研究那个产品。确保你在那方面做好了准备，因为那才是真正重要的。重要的不是公司，而是谁来指导你。”所以，人们可以做很多事情来武装自己，更多地掌控自己的职业生涯。

---

### (00:38:04) Lenny

**English:**
What's interesting, I'm sure you'll run into this and I'll just share something that I thought of. So while I was at Airbnb, I was reading your stuff and I was like, "Who works like this? He's talking about all these companies that are working in this strange way of just being given a roadmap." I'm like, "No way. This is not a thing. What is he writing about?" And it's because I was working at a company that does things well, and I know you disagree with where things have gotten. But anyway, so I imagine many people listening to this are like, I don't believe this is how a lot of companies work. What are you talking about? And then I also imagine there's a large percentage of people that work at a feature factory and they're just like, no, it's fine. It's not actually the way you're describing. So I bet this is quite frustrating for you.

**中文翻译:**
有趣的是，我确信你会遇到这种情况，我分享一下我的想法。当我在 Airbnb 时，我读你的文章，心想：“谁会这样工作啊？他说的这些公司居然以这种奇怪的方式工作，只是被给予一个路线图。”我想：“不可能，没这回事，他在写什么呢？”那是因为我当时在一家做得很好的公司工作，虽然我知道你不同意现在的发展。但无论如何，我猜很多听众会觉得：“我不相信很多公司是这样运作的，你在说什么呢？”然后我也猜有很大一部分在“功能工厂”工作的人会觉得：“不，这挺好的，并不是你描述的那样。”所以我敢打赌这对你来说挺挫败的。

---

### (00:38:48) Marty Cagan

**English:**
Yeah, I've experienced that 'cause I spent most of my career in that same bubble, and I was so surprised to find that people didn't work the way we did. I remember when it was too, because I was a developer at the time for developer tools, and I was building tools assuming that people were building like we built. And then I was sent out, I remember because one of the most eye-opening visits was my very first visit to Walmart's headquarters. And they were doing things so differently. They had just very different way of working, very different equipment, just everything. And it was a wake-up call. It was like, you know what? I'm living in a bubble. Silicon Valley is not like most of the world here. And of course I realized that why not? Why don't companies in Arkansas and India and everywhere else have the access to the same methods and tools and techniques? And so that became the inspiration for Silicon Valley Product Group, was to spread those things.

**中文翻译:**
是的，我经历过，因为我职业生涯的大部分时间也待在同样的“泡沫”里。当我发现人们的工作方式与我们不同时，我非常惊讶。我记得那是很久以前，当时我是一名开发工具的开发人员，我构建工具时假设人们构建产品的方式和我们一样。然后我被派了出去，我记得最让我大开眼界的一次访问是第一次去沃尔玛（Walmart）总部。他们的做法完全不同。他们有完全不同的工作方式、不同的设备，一切都不同。那是一个警钟，让我意识到：“你知道吗？我生活在一个泡沫里。硅谷并不代表这里的大多数世界。”当然我也意识到，为什么不呢？为什么阿肯色州、印度和其他任何地方的公司不能获得同样的方法、工具和技术？这就是成立硅谷产品集团（SVPG）的灵感来源——去传播这些东西。

---

### (00:39:56) Marty Cagan

**English:**
But I've had that exact conversation. I remember as you're saying it, the first time Shreyas Doshi told me the same thing. He was asking me, 'cause he had known me, and I'm like, "I know you write about this stuff, but I really can't believe people are doing this." And I'm like, "Shreyas, I wish it wasn't true." But he doesn't doubt it today.

**中文翻译:**
我也有过完全相同的对话。我记得当你这么说时，我想起了什里亚斯·多希（Shreyas Doshi）第一次跟我说同样的话。他问我——因为他认识我——他说：“我知道你在写这些东西，但我真的不敢相信人们居然在这么干。”我说：“什里亚斯，我也希望这不是真的。”但今天他已经不再怀疑了。

---

### (00:40:18) Lenny

**English:**
Yeah, 'cause he is doing a lot of that work now too. I'm curious if it's okay for people to be on a feature team and just stick with it and be happy. There's actually this LinkedIn post today by this PM, [inaudible 00:40:31] Ben Erez who talks about how if there's a B2B sales driven company, maybe it's okay for it to be feature factory where people know exactly what you need to build. You build these things, it's fine. We don't need you to inform our outcomes. Thoughts on that? Is it ever okay to just be like, it's fine?

**中文翻译:**
是的，因为他现在也做了很多这方面的工作。我很好奇，人们待在功能团队并安于现状是否可以？今天 LinkedIn 上有一位 PM（Ben Erez）发帖说，如果是一家 B2B 销售驱动的公司，也许成为“功能工厂”是可以接受的，因为人们确切知道你需要构建什么。你把这些东西造出来就行，没问题，我们不需要你来影响我们的成果。你对此怎么看？这种“就这样也行”的心态在某些时候是对的吗？

---

### (00:40:48) Marty Cagan

**English:**
Well, my first answer is this is not an accident why most B2B software is such crap. It is horrible. And of course, the ones that really stand out, they usually are not this way. So sales driven product, don't get me wrong. There's companies like Oracle that are massively valuable, driven with sales driven product, but do you really want to be Oracle or do you want to be SAP? Does anybody like those products out there? I don't know. I'm not sure I've ever met anybody that didn't hate those products. So no, I'd say that's just bad product. Now, I would argue that some of my favorite examples... In fact, in the new book we highlighted a classic sales driven financial services company moving to the product model and how it dramatically improved things for the sales organization.

**中文翻译:**
嗯，我的第一个回答是：大多数 B2B 软件之所以这么烂，绝非偶然。它们太糟糕了。当然，那些真正脱颖而出的公司通常不是这样的。销售驱动的产品——别误会，像甲骨文（Oracle）这样的公司非常有价值，也是由销售驱动产品的，但你真的想成为甲骨文或 SAP 吗？外面有人喜欢这些产品吗？我不知道。我不确定我是否见过不讨厌这些产品的人。所以不，我会说那只是糟糕的产品。现在，我会辩称我最喜欢的一些例子……事实上，在新书中，我们重点介绍了一家经典的销售驱动型金融服务公司转向“产品模式”的过程，以及这如何极大地改善了销售组织的情况。

---

### (00:41:48) Marty Cagan

**English:**
So there's a bigger reason I think so many sales driven companies exist, is that most of the time in those companies, the CEOs are not product people and that's why they run that way. And until and unless the CEO decides this is not very good, usually because some good product company comes along and takes away their customers, that's probably not going to change.

**中文翻译:**
所以我认为存在这么多销售驱动型公司的更深层原因是：在这些公司中，CEO 大多不是产品出身，所以公司才那样运作。除非 CEO 意识到这并不好——通常是因为某家优秀的产品公司出现并抢走了他们的客户——否则这种情况可能不会改变。

---

### (00:42:13) Lenny

**English:**
Got it. So your feedback there essentially is sure you can operate this way. You're not actually going to build a great product and long term you're going to run into competition [inaudible 00:42:21]?

**中文翻译:**
明白了。所以你的反馈本质上是：当然你可以这样运作，但你不会真正打造出伟大的产品，而且长期来看你会遇到竞争对手？

---

### (00:42:20) Marty Cagan

**English:**
The other thing I'd argue, Lenny, is an empowered product team can do everything a feature team can do and more. And once in a while I do hear somebody say, why isn't it good enough to be a feature team? How do you answer that really? To me, it is like, why are you in this business? Do you really not care what your customers think about your product? Seriously? I know I would never hire you if I had any say because that's one of the first things we want. We want people to genuinely care about our customers and about our business and making lives better for them. So I don't have a lot of sympathy for those people. I do know that there's plenty of resources for them, so they're fine. It's the people that really want to do better than that.

**中文翻译:**
莱尼，我还想说的一点是，赋能型产品团队能做功能团队能做的一切，甚至更多。偶尔我确实听到有人问：“为什么做个功能团队还不够好？”你到底该怎么回答呢？对我来说，这就像在问：“你为什么要入这一行？你真的不在乎客户怎么看你的产品吗？认真的吗？”如果我有话语权，我绝对不会雇佣你，因为那是我们最先要求的特质之一。我们希望人们真心关心我们的客户、关心我们的业务，并为他们创造更好的生活。所以我对那些人没什么同情心。我知道有很多资源是为他们准备的，所以他们没问题。我关心的是那些真正想做得更好的人。

---

### (00:43:16) Lenny

**English:**
Reminds me of something your colleague Christian said on our podcast episode of how lucky are we to get to solve people's problems and help them?

**中文翻译:**
这让我想起你的同事克里斯蒂安（Christian）在我们的播客节目中说的话：“能有机会解决人们的问题并帮助他们，我们是多么幸运啊？”

---

### (00:43:24) Marty Cagan

**English:**
Christian is a living example of what we're talking about. Absolutely. He lives for these opportunities.

**中文翻译:**
克里斯蒂安就是我们所谈论内容的活生生的例子。绝对是，他就是为这些机会而活的。

---

### (00:43:31) Lenny

**English:**
This episode is brought to you by Vanta. When it comes to ensuring your company has top-notch security practices, things get complicated fast. Now you can assess risk, secure the trust of your customers and automate compliance for SOC 2, ISO 27001, HIPAA and more with a single platform, Vanta. Vanta's market leading trust management platform helps you continuously monitor compliance alongside reporting and tracking risks. Plus you can save hours by completing security questionnaires with Vanta AI. Join thousands of global companies that use Vanta to automate evidence collection, unify risk management, and streamline security reviews. Get $1,000 off Vanta when you go to vanta.com/lenny. That's V-A-N-T-A.com/lenny.

**中文翻译:**
本集节目由 Vanta 赞助。当涉及到确保你的公司拥有顶级的安全实践时，事情会迅速变得复杂。现在，你可以通过单一平台 Vanta 来评估风险、赢得客户信任，并自动完成 SOC 2、ISO 27001、HIPAA 等合规认证。Vanta 市场领先的信任管理平台可帮助你持续监控合规性，同时报告和跟踪风险。此外，你还可以通过 Vanta AI 完成安全问卷，从而节省数小时的时间。加入成千上万家使用 Vanta 自动收集证据、统一风险管理并简化安全审查的全球公司。访问 vanta.com/lenny 即可获得 1,000 美元的 Vanta 优惠。即 V-A-N-T-A.com/lenny。

---

### (00:44:22) Lenny

**English:**
I want to touch on something. So I interviewed the CTO of Meta, and you made this really interesting point. So when I think of Meta/Facebook, I always imagine them as a very bottom-up culture. People on teams build experiments, run things. There's not a lot of do this, do that, but the way that he framed it is it's actually very top-down at Meta. Zuck and the execs come up with here's what we're working on, here's our strategy, here's our big bets. And so he sees it actually as a much more top-down than a bottom-up team, but it seems it comes across as bottom-up, I guess. I know there's a difference between bottom-up versus top-down versus featured factory and empowered product team. But I guess thoughts on that?

**中文翻译:**
我想谈谈一件事。我采访了 Meta 的 CTO，你提出了一个非常有趣的观点。当我想到 Meta/Facebook 时，我总觉得他们是非常“自下而上”（Bottom-up）的文化。团队里的人做实验、跑项目，没有太多的“做这个、做那个”。但他描述的方式是，Meta 实际上是非常“自上而下”（Top-down）的。扎克伯格和高管们决定我们要研究什么、我们的战略是什么、我们的重大赌注是什么。所以他认为这实际上更像是一个自上而下的团队，而不是自下而上的，但表现出来的样子似乎是自下而上的。我知道自下而上、自上而下、功能工厂和赋能型产品团队之间是有区别的。你对此有什么看法？

---

### (00:45:03) Marty Cagan

**English:**
So first of all, I would argue what he described is exactly what I see in good product companies, exactly. But we don't frame it as top-down. Top-down is really means something very different. In fact, handing a team a roadmap of features, that's very top-down. Another very common misunderstanding, which comes, again, a lot of the agile coaches, they have misguided so many organizations, but product teams don't do product strategy. Product leaders do product strategy. They need to do the product strategy. And look, I'm not the biggest fan of Meta, but Zuck is very good at product, very good. That's the problem in the world. He's so good at it. But that is the job, is to make these strategic decisions, the focus decisions, the bets you're going to place. But then in a good organization, you give those bets to the teams and you really do give them latitude to figure it out.

**中文翻译:**
首先，我会辩称他所描述的正是我们在优秀产品公司中看到的，完全一致。但我们不把它定义为“自上而下”。自上而下真正的含义非常不同。事实上，给团队一个功能路线图，那才是真正的自上而下。另一个非常普遍的误解（这又是很多敏捷教练误导了许多组织的结果）是：产品团队不制定产品战略，产品领导者才制定产品战略。他们必须制定产品战略。听着，我不是 Meta 的头号粉丝，但扎克伯格非常擅长产品，非常擅长。这就是这个世界的问题所在，他太擅长了。但那正是他的工作：做出战略决策、重点决策、决定要下的赌注。但在一个好的组织中，你会把这些赌注交给团队，并真正给予他们自由度去解决它。

---

### (00:46:08) Marty Cagan

**English:**
And honestly, it's been a while since I worked with Facebook at the time, but they had very good teams, very good product teams, serious cross-functional, serious engineers, serious product managers and designers, and they could solve very hard problems and that is what made them good. So I don't frame that as top-down. I frame that as product leaders doing their job and product teams doing their job. It's a very common misunderstanding that many people have about what empowerment even means. Empowerment does not mean you set up this product team and they go decide what to work on. No, that would just be anarchy, right? You'd have 50 teams doing 50 things. Instead, empowerment means the leaders do their job, come up with the bets, and then the teams are able to figure out the best way to solve those problems.

**中文翻译:**
老实说，虽然我有一段时间没和当时的 Facebook 合作了，但他们拥有非常优秀的团队，非常优秀的产品团队，严肃的跨职能协作，严肃的工程师、产品经理和设计师，他们能解决非常困难的问题，这就是他们优秀的原因。所以我不会把这定义为自上而下。我将其定义为产品领导者履行职责，产品团队也履行职责。很多人对“赋能”（Empowerment）的含义存在普遍误解。赋能并不意味着你建立一个产品团队，然后让他们自己决定做什么。不，那只会导致“无政府状态”（Anarchy），对吧？你会看到 50 个团队在做 50 件不同的事。相反，赋能意味着领导者履行职责，提出赌注，然后团队能够找出解决这些问题的最佳方案。

---

### (00:47:06) Lenny

**English:**
Awesome. That's a great clarification. I think a lot of people don't totally get that. So this is actually really helpful, I think, for a lot of people. Speaking of Meta, there's another product leader at Meta. He was actually one of the former guests and actually also one of the most popular episodes, Nikhyl Singhal. And he works with a lot of CPOs and heads of product at companies. The way he described it, he's noticed there's this reboot in what the PM role has been over the past couple of years because of the end of the [inaudible 00:47:31] era. So the way he sees it is for the past decade, PMs are mostly responsible as growth people. They're growing existing products, they have product market fit or they think they do and they're just optimizing, scaling. And now that the money has gone away, there's a return to building, finding product-market fit validation and discovery. I'm curious if you see that. Do you see a shift in what PMs should be doing in the last couple of years post [inaudible 00:47:58]?

**中文翻译:**
太棒了，这是一个很好的澄清。我想很多人并不完全理解这一点。所以这对很多人来说非常有帮助。说到 Meta，Meta 还有另一位产品领导者，他也是之前的嘉宾，那一集也是最受欢迎的节目之一，他叫尼基尔·辛格尔（Nikhyl Singhal）。他与许多公司的 CPO 和产品负责人合作。按照他的描述，他注意到过去几年 PM 的角色发生了一次“重启”，因为零利率（ZIRP）时代的结束。在他看来，过去十年 PM 主要负责增长，他们在扩展现有产品，他们已经有了产品市场契合点（PMF）或者自以为有，他们只是在优化和规模化。而现在钱变少了，大家又回到了构建、寻找产品市场契合点验证和探索（Discovery）的阶段。我很好奇你是否也看到了这一点？你是否看到过去几年 PM 的职责发生了转变？

---

### (00:47:57) Marty Cagan

**English:**
So yes and no. I think he's right in general, but there's a really important nuance. Many teams that aren't very good yet, they do exactly what he described. He describes as a gross hacking, I describe it as optimization. All they're doing is these low risk simple experiments. They live behind the AB test of just doing like, we're going to change the call to action here and maybe more people will register, that kind of test. Should they do that? Absolutely. Is that product really? Not really. That's not discovery, that's optimization. Now, in many companies they do that because they're given a roadmap of all the features. So all they can really fit in are these little optimization tests. But in others, they're scared to do anything else. They literally don't want to break it. And so I find that situation that he described in many companies that need to transform.

**中文翻译:**
可以说既是也不是。我认为他大体上是对的，但有一个非常重要的细微差别。许多还不怎么样的团队做的正是他描述的事情。他称之为“增长黑客”（Growth Hacking），我称之为“优化”（Optimization）。他们做的全是这些低风险、简单的实验。他们躲在 AB 测试后面，只是做些诸如“我们要改一下这里的行动号召按钮（CTA），也许会有更多人注册”之类的测试。他们该做这些吗？当然该。但这真的是“产品”吗？并不完全是。那不是“探索”，那是“优化”。现在，在许多公司，他们这样做是因为被给予了所有功能的路线图，所以他们唯一能塞进去的就是这些小小的优化测试。但在其他公司，他们是害怕做别的事情，他们真的不想把东西搞坏。所以我发现他描述的那种情况存在于许多需要“变革”的公司中。

---

### (00:48:58) Marty Cagan

**English:**
So I would argue what he's probably seeing mostly is a team that's learning how to go from a feature team to a product team. Now, has that happened more in the last two years? I would like to believe so, but I don't know. Some days I feel like yes, he's right. Some days I feel like I don't know who he's talking to because these people are still stuck doing optimization work. And so there's probably a lot of nuance there. In general, I think yes, but I don't think it's tied to interest rates. I don't think it's tied to that. I think it's more tied to the quality of the leadership and the need of the business to do more than optimization.

**中文翻译:**
所以我认为他看到的可能主要是那些正在学习如何从功能团队转变为产品团队的团队。那么，这种情况在过去两年里发生得更多了吗？我很想相信是这样，但我不知道。有时我觉得他是对的，有时我觉得我不知道他在和谁聊天，因为这些人仍然困在优化工作中。所以这里面可能有很多细微差别。总的来说，我认为是的，但我不认为这与利率有关。我不认为与那有关。我认为这更多地与领导层的质量以及业务除了优化之外还需要做更多事情的需求有关。

---

### (00:49:44) Lenny

**English:**
I know people ask you this all the time, but I'm curious, is there anything big you're seeing change in the PM role broadly?

**中文翻译:**
我知道人们总问你这个，但我很好奇，从广义上讲，你是否看到 PM 角色发生了什么重大变化？

---

### (00:49:51) Marty Cagan

**English:**
We've talked about quite a few big dynamics that are changing. Interestingly, what we're really been talking about is the different definitions of the PM role. And so if we hold one of those definitions constant, let's say we are focused now on the empowered product manager, the one you and I grew up with, and those are the ones that are responsible for value and viability. In general, I think the principles are stable and I think they will remain stable. However, the techniques are undergoing some radical changes, especially with generative AI. Don't get me wrong, I've been living this every day as most of us have. I don't have it figured out. In fact, I recently changed my advice because I used to say, start with ChatGPT, go from there and I'll help you make that great. We'll go from there.

**中文翻译:**
我们已经讨论了不少正在变化的重大动态。有趣的是，我们真正讨论的是 PM 角色的不同定义。如果我们保持其中一个定义不变——假设我们现在专注于赋能型产品经理，也就是你我成长过程中熟悉的那种，负责价值和商业可行性的那种。总的来说，我认为原则是稳定的，而且会保持稳定。然而，技术手段正在经历一些激进的变化，尤其是生成式 AI。别误会，我和大多数人一样每天都在经历这些。我还没完全搞明白。事实上，我最近改变了我的建议，因为我以前常说：“先从 ChatGPT 开始，然后从那里出发，我会帮你把它做得很棒。”

---

### (00:50:48) Marty Cagan

**English:**
And what I kept seeing was people taking what they get too literally, too seriously, too much value, and they were heading off in a wrong direction and then they were optimizing that. There's a lot going on right now. It's a moving target. Depends which system you're using and the day of the week now on what you're at, but whatever. Now I've been recommending to people that they think through the answer first. Really get them to think, put something down, then use ChatGPT to see if you can't improve on that, to see if you can't challenge that, to see if you can't make your argument tighter. So I've reversed and I did that because people are trusting the results too much.

**中文翻译:**
但我不断看到的是，人们太字面地、太严肃地对待他们得到的结果，赋予了太多的价值，结果他们朝着错误的方向前进，然后还在优化那个错误的方向。现在发生了很多事情，这是一个动态的目标。取决于你使用的是哪个系统，甚至取决于现在是星期几，但不管怎样。现在我一直建议人们先自己想清楚答案。真正让他们去思考，写下一些东西，然后再使用 ChatGPT 看看是否能改进，看看是否能挑战它，看看是否能让你的论点更严密。所以我反转了建议，这样做是因为人们太信任 AI 的结果了。

---

### (00:51:43) Lenny

**English:**
And when you talk about what they start with, is it like, here's a strategy I'm thinking for this product, or is it like a PRD [inaudible 00:51:48]

**中文翻译:**
当你谈到他们开始写的东西时，是指“这是我为这个产品构思的战略”，还是像 PRD（产品需求文档）之类的？

---

### (00:51:47) Marty Cagan

**English:**
Yeah, certainly you can use it for a spec, a PRD. You can certainly use it for strategy. You can certainly use it for even things like triaging bugs. It's hard to think of something you can't use it for. The harder question is what is it good for?

**中文翻译:**
是的，当然可以用于规格说明书、PRD。当然也可以用于战略。甚至可以用于 Bug 分类之类的事情。很难想到有什么是不能用它做的。更难的问题是，它到底擅长做什么？

---

### (00:52:07) Lenny

**English:**
Something along those lines I wanted to chat about. Something I've been thinking about. I want to write a post about this, is which skills of a product manager will be most disrupted by AI? So I think short term, there's communication is getting improved. You can improve your writing strategy. Maybe like here's my strategy, give me some feedback. So I think things are being optimized a bit through ChatGPT and tools like that. But in the five or 10 years, are there any skills that will potentially go away or 95% of it will be done by AI? And if so, where do you see most of that change happening in the skillsets?

**中文翻译:**
关于这一点，我也想聊聊。我一直在思考一件事，想写篇相关的文章：产品经理的哪些技能最容易被 AI 颠覆？我认为短期内，沟通能力正在得到提升，你可以改进你的写作策略。比如“这是我的战略，给我一些反馈”。所以我认为通过 ChatGPT 和类似的工具，事情正在得到一定的优化。但在 5 到 10 年内，是否有任何技能可能会消失，或者 95% 的工作将由 AI 完成？如果是这样，你认为技能集中的大部分变化会发生在哪里？

---

### (00:52:38) Marty Cagan

**English:**
Absolutely. And I think that is happening more on the engineering side right now and also on the design side, but I fully expect it will happen. Like I said at the beginning, I don't know when really because that timing is hard question, but this is another one of my arguments to people of why you need to uplevel your skills. If you are fundamentally a backlog administrator, good luck protecting that because already people are doing that. It's only a matter of time before that becomes pretty well-supported. That is not a good job prospect. Now, then we can talk about a feature team, project manager. There's very little that's going on in there that is truly value add. Most of these are administrative kinds of things that can be done at least significantly with help. So I wouldn't feel confident if I was a feature team product manager that I could keep doing this for any amount of years at least.

**中文翻译:**
绝对会。我认为目前这更多地发生在工程端和设计端，但我完全预料到它会发生。正如我开头所说，我真的不知道具体是什么时候，因为时机很难预测，但这是我向人们论证“为什么需要提升技能”的另一个论点。如果你本质上是一个“待办事项管理员”（Backlog Administrator），祝你好运能保住这份工作，因为已经有人在用 AI 这么做了。这变成完全由 AI 支持只是时间问题。那不是一个好的职业前景。然后我们可以谈谈功能团队的项目经理。那里几乎没有什么真正增值的事情。大多数都是行政类事务，至少在很大程度上可以借助 AI 完成。所以，如果我是一个功能团队的产品经理，我不会有信心至少在未来几年还能继续干下去。

---

### (00:53:45) Marty Cagan

**English:**
Now, for an empowered product manager, if your responsibility is value and viability, if you boil it down, that's the real challenge left with ChatGPT or GenAI, is viability becomes even more the important question. There's some very hard things left. So designers, I think the real product designers at the top of the chain, they're going to be incredibly important and of course tech leads are going to be incredibly important more than ever. But for a product manager, especially with viability, I've been on so many of these calls where we've been talking about the implications of probabilistic software versus deterministic software and what is okay? The lawyers are weighing in already with the legal perspective, but also ethical perspective and just if this is mission critical, is this something that we could be okay with having a probabilistic answer?

**中文翻译:**
现在，对于赋能型产品经理，如果你的职责是价值和商业可行性，归根结底，这就是 ChatGPT 或生成式 AI 留下的真正挑战——商业可行性（Viability）变得更加重要。还有一些非常困难的事情留了下来。所以设计师，我认为处于链条顶端的真正产品设计师将变得极其重要，当然，技术主管（Tech Leads）也将比以往任何时候都更重要。但对于产品经理，尤其是在商业可行性方面，我参加过很多会议，讨论“概率性软件”（Probabilistic Software）与“确定性软件”（Deterministic Software）的影响，以及什么是可以接受的？律师们已经从法律角度介入，还有伦理角度，以及如果这是任务关键型的，我们能接受一个概率性的答案吗？

---

### (00:54:49) Marty Cagan

**English:**
We don't know, trying to figure that out. So what is that really? That's a viability and a value question. So a lot more is landing squarely on the product manager than I think in general in the past.

**中文翻译:**
我们不知道，正在努力弄清楚。那到底是什么？那是一个商业可行性和价值的问题。所以，我认为比起过去，现在有更多的事情直接落在了产品经理的肩上。

---

### (00:55:04) Lenny

**English:**
Can you talk about viability, just so people know what you mean when you say that? What's the one sentence definition of what viability means?

**中文翻译:**
你能谈谈“商业可行性”吗？为了让大家明白你的意思。关于商业可行性的一句话定义是什么？

---

### (00:55:09) Marty Cagan

**English:**
So value means for the customer, viability means for your business. So that means it works for your business. You can sell it, market it. It's legal, you can service it. It's compliance. All of these constraints. Remember Airbnb, it wasn't so hard to get people to sign up. It was hard to make listings legal in San Francisco. That's the hard part, is the compliance side.

**中文翻译:**
“价值”是针对客户的，“商业可行性”是针对你的业务的。这意味着它对你的业务有效：你能卖掉它，能营销它，它是合法的，你能提供服务，它符合监管。所有这些约束。记得 Airbnb 吗？让人们注册并不难，难的是让旧金山的房源合法化。那才是难点，也就是合规方面。

---

### (00:55:38) Lenny

**English:**
I want to talk about your book. Is there anything else along these lines before we get into your book that you thought would be interesting to touch on or share?

**中文翻译:**
我想聊聊你的书。在深入探讨你的书之前，关于这些话题还有什么你觉得有趣、想提及或分享的吗？

---

### (00:55:45) Marty Cagan

**English:**
I think that's good. We covered a lot. We covered a lot.

**中文翻译:**
我觉得差不多了。我们涵盖了很多内容，真的很多。

---

### (00:55:48) Lenny

**English:**
We did. I imagine we covered some of the elements of your book, but let's talk about the book. So this is your third book, is that right?

**中文翻译:**
确实。我想我们也涵盖了你书中的一些元素，但让我们聊聊书吧。这是你的第三本书，对吗？

---

### (00:55:55) Marty Cagan

**English:**
Yes.

**中文翻译:**
是的。

---

### (00:55:56) Lenny

**English:**
Okay. What made you decide to write another book and add an addition to the Marty Cagan cannon and what is it about?

**中文翻译:**
好的。是什么让你决定再写一本书，为“马蒂·卡根作品集”再添一员？这本书是关于什么的？

---

### (00:56:05) Marty Cagan

**English:**
This is a different one though. It's different kind because INSPIRED, hopefully you know, is for product teams and product managers. It's really a book about product discovery. And then EMPOWER is really about product leadership, vision strategy, team topology, coaching. It's all about that. And that was the original idea. We would share those techniques 'cause that's what we share. But the single most common question we got honestly from the first edition of INSPIRED was that people would read the book and they would say, I love this, I want to do this. But have you ever seen our company? We are so far away from that. We are like night and day. And in fact, a lot of people would tell me point blank, there's no way their company's going to go along with this. And so what they were asking was, how in the world do you transform to work like this?

**中文翻译:**
不过这一本有所不同。它是不同类型的，因为《启示录》（INSPIRED）——希望你知道——是写给产品团队和产品经理的，它实际上是一本关于“产品探索”（Product Discovery）的书。而《赋能》（EMPOWERED）则是关于产品领导力、愿景战略、团队架构（Team Topology）和教练辅导的。那是最初的想法，我们分享这些技术，因为那是我们的专长。但老实说，自从《启示录》第一版出版以来，我们收到的最普遍的问题是：人们读完书后会说：“我喜欢这个，我想这么做。但你见过我们的公司吗？我们离那太远了，简直是天壤之别。”事实上，很多人会直截了当地告诉我，他们的公司绝不可能同意这样做。所以他们问的是：到底该如何“变革”才能像那样工作？

---

### (00:57:01) Marty Cagan

**English:**
And we've been getting that question for years now. That's really what my partners, Christian, Jonathan, Christopher, Leah, that's what they do is they help companies to transform. That's what we've been doing. But we do that on a one-off basis. There's only five of us. How many companies could we possibly work with? So we realized that this question was a global question. And if we've written books that explain, maybe you want to work this way, but we don't address how to change to work this way, that's leaving people without that hard part. So the goal of TRANSFORMED, unlike the other books, was to share how to actually change. There are techniques in TRANSFORMED as well, but there are transformation techniques. There are change techniques like the use of pilot teams or spreading things out to divide and conquer on some of the transformation work.

**中文翻译:**
多年来我们一直收到这个问题。这正是我的合伙人们——克里斯蒂安、乔纳森、克里斯托弗、利亚——所做的事情，他们帮助公司进行变革。这就是我们一直在做的。但我们是以个案形式进行的。我们只有五个人，能合作的公司有限。所以我们意识到这是一个全球性的问题。如果我们写书解释了“也许你想这样工作”，却没提到“如何改变以实现这样工作”，那就是把最难的部分丢给了读者。所以《变革》（TRANSFORMED）的目标与前几本书不同，它是为了分享如何“实际地”进行改变。书中也有技术，但那是“变革技术”，是关于改变的技术，比如使用试点团队（Pilot Teams），或者通过分散任务来对变革工作进行“分而治之”。

---

### (00:58:01) Marty Cagan

**English:**
So the other thing we wanted to do, in fact, we made a rule for ourselves. We knew we needed lots of examples, case studies, but we said it's too easy to include Silicon Valley companies because Airbnb was born in this model. They were designers, but still they were a Silicon Valley company. It was a big advantage for Airbnb over say your favorite bank or whatever that was not born in this way of working. So we said all our examples are going to be from outside Silicon Valley world. They're all companies, most of them pre-internet, that had to change dramatically to work this way. And not only were we going to show how they changed, but we were going to show what they were able to do when they changed, which to me is the coolest part, seeing the innovation. Some of these innovations, honestly, Lenny, are as impressive as anything I've seen Amazon do and that's saying a lot.

**中文翻译:**
另一件我们想做的事——事实上我们给自己定了个规矩。我们知道我们需要大量的例子和案例研究，但我们说，包含硅谷公司太容易了，因为 Airbnb 天生就是这种模式。他们是设计师出身，但仍然是一家硅谷公司。相比于你最喜欢的银行或任何非此类模式出身的企业，Airbnb 拥有巨大的优势。所以我们决定所有的例子都来自硅谷以外的世界。它们都是公司，大多数是前互联网时代的，它们必须经历剧烈的改变才能以这种方式工作。我们不仅要展示它们是如何改变的，还要展示它们改变后能做些什么，对我来说这是最酷的部分——看到创新。莱尼，老实说，其中一些创新和我见过的亚马逊所做的任何事情一样令人印象深刻，这评价已经很高了。

---

### (00:58:59) Marty Cagan

**English:**
Amazon in my opinion is the top of the pack and so that's impressive, what Trainline in the UK was able to do. A company I had never known before a few years ago in Saudi Arabia called Almosafer, a travel agency. They own, I forget what it is, 80 plus percent of the market over Expedia, over the big guys in the US because they actually learned this stuff and were able to do it. And we have a dozen examples from all over the world, Brazil, Virginia, everywhere, not Silicon Valley. In healthcare and car sales and fitness, all over the place. Honestly there was a few reasons. One is we wanted them to understand what it really means to move to this way of working. No fluff, just what does it really mean? Otherwise, how are they going to get there if they don't even know where there is? Then we wanted them to believe it's possible to transform. We're the first ones to say it's not easy, but we wanted them to believe it's possible.

**中文翻译:**
在我看来，亚马逊是业内的佼佼者，所以英国的 Trainline 所做到的事情非常了不起。还有一家我几年前从未听说过的沙特阿拉伯公司叫 Almosafer，是一家旅行社。他们占据了——我忘了具体数字——80% 以上的市场份额，超过了 Expedia 和美国的那些巨头，因为他们真正学会了这些东西并付诸实践。我们有十几个来自世界各地的例子：巴西、弗吉尼亚，到处都有，唯独没有硅谷。涉及医疗保健、汽车销售、健身等各个领域。老实说，有几个原因：一是我们想让他们理解转向这种工作方式的真正含义，没有废话，只有本质。否则，如果他们连目标在哪都不知道，又怎么能到达那里呢？其次，我们想让他们相信变革是可能的。我们首先承认这不容易，但我们想让他们相信这是可能的。

---

### (01:00:10) Marty Cagan

**English:**
And the third thing is we wanted to get them excited about what they'd be able to do after they transformed. And those were the three things we were trying to do in the book. And so that's different than our other books, but hopefully it makes the other books more accessible. They'll be able to apply more of them.

**中文翻译:**
第三点是，我们想让他们对变革后能做的事情感到兴奋。这就是我们在书中试图做的三件事。所以这与我们的其他书不同，但希望能让其他书变得更易于理解，让他们能应用更多书中的内容。

---

### (01:00:28) Lenny

**English:**
Who would you say this is most suited for? Is it leaders at companies? Is it ICPMs, everybody? Who do you think would get the most out of this?

**中文翻译:**
你会说这本书最适合谁？是公司的领导者？是个人贡献者 PM（ICPMs）？还是所有人？你认为谁能从中获益最多？

---

### (01:00:36) Marty Cagan

**English:**
We wrote it intentionally, again, unlike the other books. The other books are written for people like us and your audience and my audience. They're product people. These are written for non-product people too. And so the idea is a CEO, a CFO, a head of sale. Anybody who cares about their company changing how they build and wants to help is written for them. So that was one of the hardest parts really, including those kinds of reviewers and making sure all this stuff made sense to them.

**中文翻译:**
我们是有意为之，再次强调，这与前几本书不同。前几本书是写给你我以及我们的受众——也就是产品人的。而这一本也是写给非产品人的。所以，它的受众包括 CEO、CFO、销售主管。任何关心公司如何改变构建方式并想提供帮助的人，都是这本书的读者。所以这是最难的部分之一：邀请这类审阅者，并确保所有这些内容对他们来说都有意义。

---

### (01:01:08) Lenny

**English:**
So basically if you're listening to this and you're like, I'm working on these teams Marty's describing, I don't think this is optimal. We can do a lot better. We can get a lot more on out feature team, hand this book to your CEO essentially?

**中文翻译:**
所以基本上，如果你正在听节目并心想：“我正在马蒂描述的这种团队中工作，我觉得这不理想，我们可以做得更好，我们可以从功能团队中获得更多”，那么本质上就是把这本书递给你的 CEO？

---

### (01:01:22) Marty Cagan

**English:**
And I'd suggest they read it themselves so they know. Because I know I'm going to be talking more about this going forward because I know I need to. Too many people in our industry view themselves as a victim of their company. They're stuck in a feature team and there's nothing they can do about it other than quit. But really they have a family, they're not going to quit. So I think that's not true. I think there is so much they can do and hopefully they can see that in the book. It's like they can see what they individually can do to push their company in this direction, and at a minimum it'll help their career.

**中文翻译:**
我建议他们自己也读读，这样他们就明白了。因为我知道我以后会更多地谈论这个话题，因为我知道我必须这么做。我们行业中有太多人把自己看作公司的受害者。他们被困在功能团队里，觉得除了辞职别无他法。但实际上他们有家庭，不会轻易辞职。所以我认为那不是真的。我认为他们大有可为，希望他们能在书中看到这一点。他们可以看到作为个人能做些什么来推动公司朝着这个方向发展，至少这会对他们的职业生涯有所帮助。

---

### (01:02:05) Lenny

**English:**
I always love just the message of empowerment and giving people motivation to you can actually make change. You're not stuck in this way of working, and I know you do that a lot. The official title of the book, so it's TRANSFORMED: Moving to the Product Operating Model. What do you mean when you... There it is. I don't have my copy yet 'cause that hasn't come out in the US yet, otherwise, I'd have it here on my side as well. There it is. It's a beautiful green color by the way. It goes nicely with the other colors. Amazing. Beautiful design, whoever did that. Okay, so the part of the title is Moving to the Product Operating Model. What does that mean?

**中文翻译:**
我一直很喜欢这种“赋能”的信息，给人们动力去相信“你真的可以做出改变”。你并没有被困在这种工作方式中，我知道你经常传达这一点。书的正式标题是《变革：转向产品运营模式》（TRANSFORMED: Moving to the Product Operating Model）。当你提到……（马蒂展示了书）就是它。我还没拿到我的那本，因为美国还没上市，否则我也会把它放在手边。就是它，顺便说一下，是很漂亮的绿色，和其他颜色很搭。太棒了，设计得很美。好，标题的一部分是“转向产品运营模式”，那是什么意思？

---

### (01:02:40) Marty Cagan

**English:**
That was the biggest pain for the book was... 'Cause honestly, I had dodged that question for 20 years. If you look at any of my writing before starting on this book, I just said, "Look, do you want to work like the best or do you want to work like the rest?" That's how we referred to it, the best versus the rest because there is no word, there is no name that talks about the common principles with all the best companies. So we would just say, do you want to work like the best or not? But when I started to write the book, I'm like, okay, I can't just say work like the best. We have to have some name for this, but I don't know if you've come across this Lenny, but you don't want to coin a new term if you can avoid it.

**中文翻译:**
那是写这本书最大的痛苦……因为老实说，我已经回避这个问题 20 年了。如果你看我写这本书之前的任何文章，我只会说：“听着，你是想学最顶尖的公司（The Best），还是想学其他的公司（The Rest）？”这就是我们的称呼方式，“顶尖 vs 其他”，因为没有一个词、一个名字能涵盖所有最优秀公司的共同原则。所以我们只会问，你想不想像最优秀的公司那样工作？但当我开始写这本书时，我想，好吧，我不能只说“像最优秀的公司那样工作”。我们必须给它起个名字，但我不知道你是否遇到过这种情况，莱尼，如果可以避免，你真的不想创造一个新词。

---

### (01:03:27) Marty Cagan

**English:**
It is really painful to try to develop a new term. Some of the companies we worked with use the term product operating model and don't get me wrong, that's not the only term. Some people use the term product led company or product driven company, but those two we just don't like because it gives all the wrong message and the rest of the company thinks it's a power grab. So we wanted to avoid those words. We like product operating model for a couple reasons. One is it's a model, it's a conceptual model. It's not a process. It's not really a thing, it's more of a set of principles and also it's non-threatening to a lot of people. It's just saying, "Look, this is how these companies operate. You can look at it and decide if you think it's good for you too." So we adopted that term, we call it product model for short. And all it really is it boils down to a set of 20 principles and those 20 principles are what we find.

**中文翻译:**
试图开发一个新词真的很痛苦。我们合作过的一些公司使用“产品运营模式”（Product Operating Model）这个词，别误会，这不是唯一的词。有些人使用“产品主导型公司”（Product Led）或“产品驱动型公司”（Product Driven），但我们不喜欢这两个词，因为它们传达了错误的信息，公司的其他部门会认为这是一种权力争夺。所以我们想避开这些词。我们喜欢“产品运营模式”有几个原因：一是它是一个“模式”，一个概念模型，而不是一个流程。它不是一个具体的东西，而是一套原则；而且它对很多人来说没有威胁性。它只是在说：“看，这就是这些公司的运作方式。你可以看看，决定是否也适合你。”所以我们采用了这个词，简称“产品模式”。它归根结底就是一套 20 条原则，而这些原则正是我们的发现。

---

### (01:04:36) Marty Cagan

**English:**
Remember we started with this. I was explaining, when I listen to your guests, I'm listening for what's special about each of their companies, but what I'm looking for is the commonality. 'Cause most of the time when I see a successful company, they are living these principles. Principles like you have to experiment. You have to embrace experimentation. If you don't do that, most of this is not possible. Or you have to make sure that everything you release is instrumented so that we can prove the outcome. Stuff like that, that there's a million different methodologies and frameworks and tools and processes, but matters is those principles. And so that's what we mean by that product operating model. There's at a high level we talk about it, is how you decide what you're going to work on? How you decide which problems to solve?

**中文翻译:**
记得我们开头聊的吗？我解释过，当我听你的嘉宾讲话时，我听的是他们每家公司的特别之处，但我寻找的是共性。因为大多数时候当我看到一家成功的公司时，他们都在践行这些原则。比如“你必须进行实验”、“你必须拥抱实验”。如果你不这样做，大部分事情都不可能实现。或者“你必须确保发布的每一项内容都有埋点（Instrumented），以便我们证明成果”。诸如此类。虽然有成千上万种不同的方法论、框架、工具和流程，但真正重要的是这些原则。这就是我们所说的“产品运营模式”。从高层面上讲，它关乎：你如何决定要做什么？你如何决定解决哪些问题？

---

### (01:05:33) Marty Cagan

**English:**
That's what most companies do in annual planning, but it's basically the product strategy. That's what your Meta friend was describing that the leaders do. That's their job. The second is how do they solve problems? Do they have the skills to do product discovery like we're talking about? How to actually come up with good solutions that work for the customer and work for the business. That's the second big dimension of the product model. And the third big dimension is how do they actually build, test and deploy product to their customers? Do they do it in a way that is reliable, that is demonstrable where you can show that this generates the outcomes that you need? Those are the three big areas. And then there's a number of competencies. There's four new competencies that most companies don't have, but what makes it tricky is they have people with those titles, but they don't have people with those jobs. The one we've been talking about is product manager.

**中文翻译:**
大多数公司在年度计划中做这些，但它本质上是产品战略。这就是你的 Meta 朋友描述的领导者所做的事，那是他们的工作。第二是他们如何解决问题？他们是否具备我们所说的进行“产品探索”的技能？如何真正想出既对客户有效又对业务有效的解决方案。这是产品模式的第二个大维度。第三个大维度是他们如何实际构建、测试并向客户部署产品？他们是否以一种可靠、可演示的方式进行，从而证明这产生了你需要的成果？这就是三大领域。此外还有一些胜任力（Competencies）。大多数公司不具备四种新的胜任力，但棘手之处在于：他们有挂着这些头衔的人，却没人在做这些工作。我们一直在谈论的就是“产品经理”。

---

### (01:06:40) Lenny

**English:**
What would be most interesting to share? You said there's 20 attributes of a power product team.

**中文翻译:**
分享什么最有趣呢？你说一个强大的产品团队有 20 个属性。

---

### (01:06:46) Marty Cagan

**English:**
20 principles.

**中文翻译:**
20 条原则。

---

### (01:06:48) Lenny

**English:**
20 principles. I'm so curious what these are, but I know we don't have time to go through them all. Can you either share a few of those? You shared experimentation as one, or these four what you just mentioned. I'm just curious what these [inaudible 01:06:58]

**中文翻译:**
20 条原则。我很想知道这些是什么，但我知道我们没时间一一过一遍。你能分享其中的几条吗？你提到了实验是其中之一，或者你刚才提到的那四个。我只是很好奇这些……

---

### (01:06:58) Marty Cagan

**English:**
Well, I could share as much as you want, but the four competencies are product manager. Again, we're talking a serious product manager here, not a product owner, not a feature team product manager. Product manager, real product designer, service design, interaction design, visual design, user research, real product designer, a real tech lead, and then a real product leader, a manager of product design engineering that knows how to coach their people and knows how to do a real product strategy, which is what we were talking about. So those are the four new competencies. For most companies, those are new, meaning they might have people with those names, but they don't have those roles institutionalized.

**中文翻译:**
你想听多少我都能分享，但这四种胜任力分别是：产品经理（再次强调，这里指的是严肃的产品经理，不是产品负责人，也不是功能团队的产品经理）；真正的产品设计师（涵盖服务设计、交互设计、视觉设计、用户研究）；真正的技术主管（Tech Lead）；以及真正的产品领导者（即产品、设计、工程部门的管理者，懂得如何辅导员工并制定真正的产品战略）。这就是四种新的胜任力。对于大多数公司来说，这些都是全新的，意味着他们可能有挂着这些名字的人，但这些角色并没有在制度上真正确立。

---

### (01:07:43) Lenny

**English:**
It's interesting, you're building on the classic triad with this leader above. It's like the stool with something on the stool or something or filling up the stool.

**中文翻译:**
很有趣，你是在经典的“三位一体”（Triad，指产品、设计、工程）基础上增加了一个上层领导者。就像在凳子上加了东西，或者把凳子填满了。

---

### (01:07:51) Marty Cagan

**English:**
And that is the triad. That's where it came from. The word triad came from those three. We didn't invent that.

**中文翻译:**
那就是“三位一体”。这就是它的由来。“三位一体”这个词就源于那三者，不是我们发明的。

---

### (01:07:58) Lenny

**English:**
Right. But I think the product leader is a really interesting addition there. You can't just have this team off to the side without a product leader overseeing that work.

**中文翻译:**
对。但我认为“产品领导者”是一个非常有趣的补充。你不能只有这个团队在一旁工作，而没有一个产品领导者来监督。

---

### (01:08:04) Marty Cagan

**English:**
That's so true because one of the things I really learned with INSPIRED was that it wasn't enough to have the teams do their job. They needed leadership to do their job. So it is both. And that's why I was saying we don't frame it as top-down, bottom-up for that. We frame it as each group doing their job. And when that happens, it's actually a beautiful thing.

**中文翻译:**
太对了，因为我在写《启示录》时真正学到的一点是：光让团队各司其职是不够的，他们需要领导层也各司其职。所以两者缺一不可。这就是为什么我说我们不把它定义为自上而下或自下而上，我们将其定义为每个群体都在履行自己的职责。当这种情况发生时，那真的是一件美妙的事情。

---

### (01:08:28) Lenny

**English:**
We're going to link to a post that you wrote, Product Leadership Theater, which talks about how people do this actually badly and what it looks like when it's just pretend versus actually doing it right.

**中文翻译:**
我们会链接到你写的一篇文章《产品领导力演戏》，其中谈到了人们实际上是如何把这件事搞砸的，以及仅仅是假装与真正做对之间看起来有什么区别。

---

### (01:08:37) Marty Cagan

**English:**
Good.

**中文翻译:**
好的。

---

### (01:08:38) Lenny

**English:**
Okay. And then what are some of these principles, just to touch on a couple and a few-

**中文翻译:**
好。那么这些原则中还有哪些？能简单提几个吗？

---

### (01:08:42) Marty Cagan

**English:**
Just stop me, but there's a set of principles around the more cultural things, like innovation is more important than predictability. That's a principle. That learning is more important than failure. The principles are more important than process. Some examples of that. In terms of teams, empowered with problems to solve. That's one of your foundational principles. We talked about that, this idea of real ownership, real sense of ownership so that it's theirs. Well, of course in discovery you'd recognize all the principles, but it's about addressing product risks. It's about embracing quick experimentation. It's about testing ideas responsibly. These are principles. And then I did mention a couple of the delivery principles, things like small frequent uncoupled releases. For most companies that's CI/CD, instrumentation of everything, monitoring of everything. These are delivery principles. So none of these should surprise you 'cause they are what's consistent in the good companies that we know, but these are the things that we think matter.

**中文翻译:**
你可以随时打断我，但有一套关于文化方面的原则，比如“创新比可预测性更重要”，这是一条原则。“学习比失败更重要”、“原则比流程更重要”。这些都是例子。在团队方面，“被赋予要解决的问题”，这是基础原则之一。我们谈过这个，即真正的所有权、真正的归属感，让他们觉得这是他们自己的。当然，在“探索”阶段，你会认出所有的原则，但核心是应对产品风险、拥抱快速实验、负责任地测试想法。这些都是原则。然后我也提到了几条交付原则，比如“小规模、高频率、解耦的发布”。对于大多数公司来说，这就是 CI/CD（持续集成/持续部署）、万物皆有埋点、万物皆有监控。这些是交付原则。这些都不应该让你感到意外，因为它们在我们所知的优秀公司中是一致存在的，但这些正是我们认为重要的事情。

---

### (01:09:58) Lenny

**English:**
That's awesome. And I imagine people listening to this, if they're in that 10% or 20% of companies that you describe as doing this well are just like, of course. And then the rest are just like, no, there's no way we're going to be able to do that.

**中文翻译:**
太棒了。我想听众里如果有人身处你描述的那 10% 或 20% 做得好的公司，他们会觉得“理所当然”。而剩下的人则会觉得“不，我们绝对不可能做到那样”。

---

### (01:10:09) Marty Cagan

**English:**
You have to realize in most of the rest of the world, they release monthly or mostly quarterly. Think about that. Quarterly releases. Think about it. You cannot take care of your customers. You cannot learn at the pace you need to. By the way, quality is going to be terrible in that model.

**中文翻译:**
你必须意识到，在世界上大多数其他地方，他们是按月甚至按季度发布的。想想看，按季度发布。你想想，你根本无法照顾好你的客户，你无法以需要的速度学习。顺便说一句，在这种模式下，质量也会非常糟糕。

---

### (01:10:30) Lenny

**English:**
I don't want to go on this tangent necessarily, but I know in some cases, like a quarterly release, like Shopify as an example, they have seasonal releases like the winter launch and the summer launch.

**中文翻译:**
我不想跑题，但我知道在某些情况下，比如季度发布，以 Shopify 为例，他们有季节性发布，比如冬季发布会和夏季发布会。

---

### (01:10:40) Marty Cagan

**English:**
And salesforce.com has a big... But don't confuse the actual releasing by the teams with the marketing releases. So it's very normal and I think wise to batch. Because look, most product teams are releasing on the order of 20 times per day. You're going to do a marketing release 20 times a day? That would be useless. So it makes sense to have messaging on a periodic basis, but good companies, by the time they message it, it's live. It's been coming out. We may have released some things dark as you know, but we've got it in production solid. We've proven each thing probably with an AB test.

**中文翻译:**
Salesforce 也有大型发布……但不要把团队的“实际发布”与“营销发布”混为一谈。分批处理营销信息是非常正常且明智的。因为你看，大多数产品团队每天发布大约 20 次。难道你要每天做 20 次营销发布吗？那毫无意义。所以定期发布消息是有道理的，但优秀的公司在发布消息时，功能已经上线了。它一直在陆续推出。如你所知，我们可能已经进行了一些“暗部署”（Dark Releases），但它在生产环境中已经很稳固了。我们可能已经通过 AB 测试证明了每一项功能。

---

### (01:11:25) Lenny

**English:**
Airbnb is actually in that same model. Most of the stuff they announced every couple times a year is already out or an experiment to most people. One thing I wanted to clarify, so you call this the product operating model. There's also this role product ops, which you touched on a little bit. Any thoughts on product ops? We've had a few guests here talk about it.

**中文翻译:**
Airbnb 实际上也是这种模式。他们每年几次宣布的大多数内容其实已经上线了，或者对大多数人来说已经是一个实验了。有一点我想澄清一下，你把这称为“产品运营模式”（Product Operating Model）。还有一个角色叫“产品运营”（Product Ops），你刚才稍微提到了。对产品运营有什么看法吗？我们这里有几位嘉宾谈过这个。

---

### (01:11:43) Marty Cagan

**English:**
It's tricky. First of all, some people have asked me, is product ops the same as product operating model? No. That was just a very unfortunate name conflict, but product ops is more analogous to DevOps and design ops, that's all. Now, can you use product ops in the product operating model? Absolutely, if you're using one of the definitions that are part of the model. So for example, the heart of product ops in the good companies I know is user research and data analysts. And the only difference is they're now brought together under one product ops leader. That's all. That that is the same. How long has that been with us, Lenny? More than 20 years. Companies have had user research teams and have had data analyst teams to help you make decisions qualitatively and help you make teams quantitatively. So that's not new at all, but it is good. And I think there is some amount of value about bringing that in.

**中文翻译:**
这很微妙。首先，有人问我：产品运营（Product Ops）和产品运营模式（Product Operating Model）是一回事吗？不，那只是一个非常不幸的名称冲突。产品运营更类似于 DevOps 和设计运营（Design Ops），仅此而已。那么，你能在产品运营模式中使用产品运营吗？绝对可以，前提是你使用的是该模式中定义的职能。例如，在我所知的优秀公司中，产品运营的核心是用户研究和数据分析师。唯一的区别是，他们现在被整合在一位产品运营领导者之下。仅此而已，本质是一样的。莱尼，这存在多久了？超过 20 年了。公司一直有用户研究团队和数据分析师团队，来帮助你进行定性决策和定量决策。所以这一点也不新鲜，但它是好的。我认为引入它是有一定价值的。

---

### (01:12:52) Marty Cagan

**English:**
Some companies, of course, they interpret and define product ops very differently. A lot of them unfortunately think of it, they focus on the whole phrase of process in governance. That's a huge red flag and I try to tell people, if that's what you see, run. Don't walk away from that. The other thing that's going on in a lot of companies, it is amazing to me how creative companies can be to try to find a way to justify giving product managers assistance because the product manager says too much work, which is really ironic to me 'cause they're usually feature teams that are saying this and I'm like, "It's not even enough for your job." But anyway, they're like, "Too much work." And so they're like, "Well, we need help." And so for a while, they would all have these little associate product managers. And then a lot of companies they have, oh, we also have product owners.

**中文翻译:**
当然，有些公司对产品运营的理解和定义非常不同。不幸的是，其中很多公司专注于“流程和治理”这一套。这是一个巨大的危险信号（Red Flag），我试着告诉人们：如果你看到的是这种，跑，赶紧跑。另一件在很多公司发生的事让我惊讶：公司在为产品经理找助手这件事上是多么有“创意”，因为产品经理说工作量太大。这对我来说真的很讽刺，因为通常说这话的都是功能团队，我会想：“你那点活儿甚至都不够填满一份工作。”但不管怎样，他们会说“工作太多了”，然后说“我们需要帮助”。所以有一段时间，他们都有这些小小的助理产品经理（APM）。然后很多公司说，哦，我们还有产品负责人（Product Owners）。

---

### (01:13:51) Marty Cagan

**English:**
Product manager and product owner makes no sense. Huge anti-pattern. Today a lot of companies use the same excuse, but its product manager has product ops people to do the dirty work. No. And honestly, I would not want to be one of those people because I think they're very vulnerable right now.

**中文翻译:**
同时设立产品经理和产品负责人毫无意义，是巨大的反模式（Anti-pattern）。今天，很多公司使用同样的借口，只不过变成了让产品运营人员帮产品经理干脏活累活。不。老实说，我不想成为那些人中的一员，因为我认为他们现在非常脆弱。

---

### (01:14:12) Lenny

**English:**
I've changed my mind on product ops. One reason is because I also was like, "I don't need another person in the loop on everything I'm doing. I just want to have..." I don't know why I would do that even though I have endless work and I have working crazy hours. But I think one of the great things about product ops people that I talk to is there's not many of them. You need one often to do a ton and to help a lot of different teams, so it's not like a team that just grows like crazy.

**中文翻译:**
我对产品运营的看法有所改变。原因之一是我以前也觉得：“我不需要另一个人介入我做的每一件事。我只想……”我不知道为什么我会那样想，尽管我有干不完的活，还要疯狂加班。但我认为，我接触过的产品运营人员的一个优点是，他们人数并不多。通常你只需要一个人就能做大量工作并帮助许多不同的团队，所以它不像是一个会疯狂扩张的团队。

---

### (01:14:37) Marty Cagan

**English:**
That's what I like. Same with user research, by the way, and you had a very good guest on that I think tried to make that point as well, a small high leverage group. So it works for data analysts and it works for user research where they are helping the teams do the work they need to do, but that's where it really depends what they're doing. I will tell you I've seen too many companies where the product leaders are not doing their job, so what they do is they hire product ops to try to do their job. They're the ones now responsible for educating the product managers. That's just not good.

**中文翻译:**
这就是我喜欢的。顺便说一句，用户研究也是如此，你之前请过一位非常棒的嘉宾也试图说明这一点：一个小型的高杠杆群体。这同样适用于数据分析师和用户研究，他们帮助团队完成需要做的工作。但这真的取决于他们在做什么。我会告诉你，我见过太多公司的产品领导者不履行职责，所以他们雇佣产品运营来试图替他们履行职责。现在这些人负责教育产品经理了，这可不太妙。

---

### (01:15:13) Lenny

**English:**
I have just a few more questions before we get to our very exciting lightning round. Actually, maybe just one more question. We'll see where this goes. So I've mentioned this earlier that a lot of startup founders are just like, "I do not need product managers. I'm not going to hire them ever. Or maybe I'll wait until I have hundreds of engineers." But then I find many of them change their mind, bring in a PM and they're like, "Oh wow, this is amazing. Why didn't I do this earlier? This person, it's exactly what I needed." And these are guests I've had on the podcast that were like, "We don't need PMs." And then they get one and they're like, "Okay, I see. This is great." Do you have any advice for founders that are in this boat of just like, I don't want product managers, they're going to screw us up, they're going to slow us down? Any advice for this?

**中文翻译:**
在进入非常精彩的闪电轮问答之前，我还有几个问题。实际上，也许只有一个。我之前提到过，很多初创公司创始人会说：“我不需要产品经理，我永远不会雇佣他们。或者也许等我有几百个工程师再说。”但后来我发现他们中的许多人改变了主意，招进一个 PM 后会感叹：“哇，这太棒了。我为什么不早点这么做？这个人正是我需要的。”这些是我播客的嘉宾，他们曾说“我们不需要 PM”，然后招了一个后说“好吧，我明白了，这太棒了”。对于那些处于“我不想要产品经理，他们会把事情搞砸，会拖慢我们的速度”这种心态的创始人，你有什么建议吗？

---

### (01:15:53) Marty Cagan

**English:**
Yeah. Well, first of all, I'm one of the people that tries to discourage them from hiring product managers too soon because a lot of them make the mistake of hiring them too soon. Now, realize what we're talking about here, again, the whole discussion we've had, this is other layer to, I'm talking about a real product manager. If they're using them as project manager, which a lot of times they are, well, I would tell them they're overpaying, but okay, you can get some help for project management. That's not a good use of the CEO's time. But if they're a real product manager and they're worried about value and viability, that is the founder's job. So the founder should be doing that and needs to be doing that, and it usually causes conflict if they bring in a real product manager too soon. It's too many cooks in the kitchen.

**中文翻译:**
是的。首先，我是那种会劝阻他们不要过早雇佣产品经理的人，因为很多人犯了过早雇佣的错误。现在，请意识到我们在这里讨论的内容——再次回到我们之前的讨论——我指的是“真正的”产品经理。如果他们把 PM 当作项目经理用（很多时候确实如此），我会告诉他们薪水付高了，但好吧，你可以找人帮着做项目管理，那确实不值得 CEO 亲自花时间。但如果是一个真正的产品经理，负责价值和商业可行性，那其实是创始人的工作。所以创始人应该做，也必须做这件事。如果过早引入一个真正的产品经理，通常会引起冲突。这叫“厨师太多，烧坏了汤”。

---

### (01:16:45) Marty Cagan

**English:**
You need to reach a certain scale before it helps you to have other people responsible for value and viability. That all assumes that they understand real product management, otherwise it's going to lead to very different symptoms.

**中文翻译:**
你需要达到一定的规模，让其他人负责价值和商业可行性才会对你有帮助。这一切的前提是他们理解真正的产品管理，否则会导致完全不同的负面症状。

---

### (01:17:01) Lenny

**English:**
So I think one piece of advice here is after product-market fit is a better time to hire a product manager. Otherwise, they're just between you and the product and it slows everything down, right?

**中文翻译:**
所以我想这里的一个建议是：在达到产品市场契合点（PMF）之后是雇佣产品经理更好的时机。否则，他们只是介于你和产品之间，会拖慢一切，对吧？

---

### (01:17:10) Marty Cagan

**English:**
Yeah. Remember, usually as soon as you get product-market fit, you're working on it for other products and other markets, and so it's an ongoing thing, but while it's small, it usually is most useful just to look at the number of engineers. At a certain number of engineers, usually 20 to 25, it's a lot better if the co-founder is the product person for that.

**中文翻译:**
是的。记住，通常一旦你获得了产品市场契合点，你就会开始为其他产品和其他市场努力，所以这是一个持续的过程。但在规模还小时，观察工程师的数量通常是最有用的。当工程师达到一定数量，通常是 20 到 25 人时，如果由联合创始人担任产品负责人，效果会好得多。

---

### (01:17:35) Lenny

**English:**
Awesome. I was going to ask you if you have a heuristic for engineers and so thank you for preempting that. That's essentially all I had to chat about, Marty. Do you have anything else that you think would be interesting to share or touch on or leave listeners with before we get to a very exciting lightning round?

**中文翻译:**
太棒了。我正想问你关于工程师数量的启发式准则，谢谢你抢先回答了。马蒂，这基本上就是我想聊的所有内容了。在进入非常精彩的闪电轮问答之前，你还有什么觉得有趣、想提及或想留给听众的内容吗？

---

### (01:17:51) Marty Cagan

**English:**
Honestly, Lenny, we talked about so many big topics. I'm worried that may have overwhelmed people, I hope not. Because you asked all the hardest topics.

**中文翻译:**
老实说，莱尼，我们谈论了这么多宏大的话题。我担心这可能会让人们感到不知所措，希望不会。因为你问的全是最难的话题。

---

### (01:18:03) Lenny

**English:**
Well, good job me. Good job you. With that, we've reached our very exciting lightning round. Are you ready?

**中文翻译:**
好吧，我干得不错，你也干得不错。就这样，我们进入了非常精彩的闪电轮问答。准备好了吗？

---

### (01:18:09) Marty Cagan

**English:**
Sure.

**中文翻译:**
当然。

---

### (01:18:10) Lenny

**English:**
What are two or three books that you've recommended most to other people?

**中文翻译:**
你向别人推荐最多的两三本书是什么？

---

### (01:18:15) Marty Cagan

**English:**
I love the new book from Tony Fadell called Build. It's a wonderful book and he's describing the product model, but for hardware devices and his perspective was fabulous. He had a front row seat to some of the most iconic products in the world, the iPod, the iPhone, the Nest devices. Love it. So I loved his book and I've been recommending it to all kinds of people. Another one I really liked is, do you know Tim Urban, the guy behind Wait But Why?

**中文翻译:**
我非常喜欢托尼·法德尔（Tony Fadell）的新书《创造》（Build）。这是一本很棒的书，他描述了产品模式，但是针对硬件设备的，他的视角非常精彩。他曾近距离参与了一些世界上最具标志性的产品：iPod、iPhone、Nest 设备。我非常喜欢。所以我很爱他的书，并一直向各种各样的人推荐。另一本我非常喜欢的是——你知道 Tim Urban 吗？就是《Wait But Why》背后的那个人。

---

### (01:18:45) Lenny

**English:**
Absolutely.

**中文翻译:**
当然知道。

---

### (01:18:46) Marty Cagan

**English:**
I just love the way this guy thinks. And he wrote a book called What's Our Problem? that I found really provocative. Challenged me in a hundred different ways, so love that.

**中文翻译:**
我就是喜欢这家伙的思考方式。他写了一本书叫《我们的问题是什么？》（What's Our Problem?），我觉得非常有启发性。它在一百个不同的方面挑战了我，所以我很喜欢。

---

### (01:18:56) Lenny

**English:**
I've been reading about his book writing process as he was writing it over the many years and it was just quite a journey he went on to make that book happen. Do you have a favorite recent movie or TV show that you really enjoyed?

**中文翻译:**
我一直在读他写那本书的过程，写了很多年，为了让那本书问世，他经历了一段非凡的旅程。你最近有特别喜欢的电影或电视剧吗？

---

### (01:19:09) Marty Cagan

**English:**
Lenny, you couldn't ask that to a worst person 'cause I watch almost nothing, so not a good one for that.

**中文翻译:**
莱尼，你问错人了，因为我几乎什么都不看，所以这题我答不上来。

---

### (01:19:16) Lenny

**English:**
Great. I think that's often for the best. Do you have a favorite interview question that you either use yourself or find useful when interviewing folks, product managers especially?

**中文翻译:**
太好了。我认为这通常是件好事。你有没有最喜欢的面试问题，是你自己会用或者觉得在面试（尤其是面试产品经理）时很有用的？

---

### (01:19:26) Marty Cagan

**English:**
Well, given how much interviewing I do, I stopped giving out my real favorite questions because they became online. But I do have a go-to question that I pretty much start with everybody and I want to know if they can even define the job of a product manager.

**中文翻译:**
鉴于我做了大量的面试，我已经不再公开我真正最喜欢的问题了，因为它们都被传到网上了。但我确实有一个必问的问题，几乎对每个人都会问，那就是我想知道他们是否能定义产品经理的工作。

---

### (01:19:41) Lenny

**English:**
What do you find in the answer and what do you look for? Is it just how close they are to your version of a product manager?

**中文翻译:**
你从答案中能发现什么？你在寻找什么？只是看他们与你心目中的产品经理版本有多接近吗？

---

### (01:19:49) Marty Cagan

**English:**
I can tell where they learned from their answer, that's all. They don't have to give my answer. They just shouldn't give the old feature team answer, that's all.

**中文翻译:**
我能从他们的回答中看出他们是从哪里学到这些的，仅此而已。他们不必给出我的答案，只要不给出那种陈旧的功能团队式的答案就行。

---

### (01:20:00) Lenny

**English:**
Do you have a favorite product that you recently discovered that you really love, whether it's software or something physical, something around the house?

**中文翻译:**
你最近有没有发现什么特别喜欢的产品？无论是软件还是实物，或者是家里的什么东西？

---

### (01:20:06) Marty Cagan

**English:**
I recently got a Rivian, which is amazing that they did an absolutely beautiful job. They're the Airbnb of car companies because the founder's a designer and imagine if a designer designed the next generation car. It's a phenomenally good job.

**中文翻译:**
我最近买了一辆 Rivian（电动皮卡），太惊艳了，他们做得非常漂亮。他们是汽车界的 Airbnb，因为创始人是设计师。想象一下，如果由设计师来设计下一代汽车会怎样。他们做得极其出色。

---

### (01:20:27) Lenny

**English:**
Wow. I was imagining you could rent people's cars and that sounds pretty cool, but you mean it in a different way. Interestingly, both you and [inaudible 01:20:38] from Meta both had cars as your favorite recent product discovery. He had a Mercedes-Benz. And I made the joke that I hope to give away these products someday and the budget is blowing up with all these cars in the mix.

**中文翻译:**
哇。我刚才还在想是不是可以租别人的车，听起来挺酷的，但你的意思是另一种。有趣的是，你和来自 Meta 的嘉宾最近最喜欢的产品发现都是汽车。他的是梅赛德斯-奔驰。我还开玩笑说，希望有一天能把这些产品作为奖品送出去，但如果全是汽车，预算就要爆炸了。

---

### (01:20:52) Marty Cagan

**English:**
Well, my favorite thing to do is ride motorcycles and there is a new generation of product that who knows, might save my life one day, but these are literally wireless airbag vests that you wear and it uses AI technology and sensors to decide if it should deploy. Luckily, mine has never had to go off, but I know for a lot of people it saved their lives. That's an example of technology where without the technology, it's a very vulnerable... Even with it, it's vulnerable.

**中文翻译:**
嗯，我最喜欢做的事情是骑摩托车。现在有一种新一代产品，谁知道呢，也许哪天会救我的命。那是无线安全气囊背心，你穿在身上，它利用 AI 技术和传感器来决定是否弹出。幸运的是，我的背心还没弹出过，但我知道它救了很多人的命。这就是一个技术的例子，如果没有这项技术，人会非常脆弱……当然，即使有了它，也依然脆弱。

---

### (01:21:28) Lenny

**English:**
Wait, do you ride motorcycles?

**中文翻译:**
等等，你骑摩托车？

---

### (01:21:29) Marty Cagan

**English:**
I do.

**中文翻译:**
是的。

---

### (01:21:30) Lenny

**English:**
I had no idea. What bike do you ride?

**中文翻译:**
我完全不知道。你骑什么车？

---

### (01:21:33) Marty Cagan

**English:**
I have two and they're both BMWs.

**中文翻译:**
我有两辆，都是宝马（BMW）。

---

### (01:21:36) Lenny

**English:**
Wow. We need to see a picture of this somewhere. That's amazing. I had no idea. Two final questions. Do you have a favorite life motto that you often come back to, share with friends or family and find useful either in work or in life?

**中文翻译:**
哇。我们得在什么地方看看照片。太神奇了，我完全不知道。最后两个问题。你有没有最喜欢的人生格言，是你经常回想、与亲友分享，并觉得在工作或生活中很有用的？

---

### (01:21:49) Marty Cagan

**English:**
I don't really have a life motto, but I do have one I share a lot with people because as you might imagine, I think writing really helps me think and I encourage other people to develop their thinking skills and there's a great quote from Leslie Lamport, the guy who... You're not old enough to know this, but he invented one of the first word processors called LaTeX, which I used to use back in the day. But if you're thinking without writing, you just think you're thinking.

**中文翻译:**
我并没有真正的人生格言，但我确实有一个经常与人分享的观点。因为如你所料，我认为写作真的能帮助我思考，我也鼓励其他人培养思考能力。莱斯利·兰伯特（Leslie Lamport）有一句名言——你可能还太年轻不知道他，但他发明了最早的文字处理器之一 LaTeX，我以前经常用。他说：“如果你思考而不写作，你只是‘以为’自己在思考。”

---

### (01:22:21) Lenny

**English:**
There's a version of this that I love and it's the same idea that I don't know what I think until I've written it down. I think Joan Didion said that.

**中文翻译:**
我喜欢这个观点的一个版本，意思是一样的：“在写下来之前，我不知道自己在想什么。”我想那是琼·狄迪恩（Joan Didion）说的。

---

### (01:22:29) Marty Cagan

**English:**
Same idea.

**中文翻译:**
同样的道理。

---

### (01:22:30) Lenny

**English:**
And I so agree. That's why I started writing. I just want to figure this out that I have in my head. Crystallizing something that makes sense. Last question. You've been doing this work for many, many years now. How many years have you been at this?

**中文翻译:**
我非常同意。这就是我开始写作的原因。我只是想理清脑子里的东西，把有意义的东西结晶化。最后一个问题。你从事这项工作已经很多很多年了。你干这行多少年了？

---

### (01:22:43) Marty Cagan

**English:**
43.

**中文翻译:**
43 年。

---

### (01:22:45) Lenny

**English:**
43 years. What else would you have been doing right now if not having gone down this track?

**中文翻译:**
43 年。如果没有走上这条路，你现在会在做什么？

---

### (01:22:53) Marty Cagan

**English:**
Oh, well, honestly, I would've been really happy just staying in engineering. I've always loved design too. I think I would've been really happy as a designer. I think no matter what though, I would have been still building something, whether if it was houses or cars or whatever. I like building things.

**中文翻译:**
噢，老实说，如果一直留在工程领域，我也会很开心。我也一直很喜欢设计，我想如果当一名设计师，我也会很快乐。但无论如何，我想我还是会在构建某些东西，无论是房子、汽车还是别的什么。我喜欢创造东西。

---

### (01:23:13) Lenny

**English:**
I love that. You're essentially a one man triad team in this dream. Marty, this was incredible. It was everything I was hoping it'd be. We covered so much stuff. I think we're going to help a lot of people transform. Two final questions, where can folks find your book? When is it available? Where can they reach out if they want to follow up on stuff? And how can listeners be useful to you?

**中文翻译:**
我喜欢这个回答。在这个梦想中，你基本上是一个人的“三位一体”团队。马蒂，这太棒了。这正是我所期待的一切。我们涵盖了这么多内容，我想我们会帮助很多人完成变革。最后两个问题：大家在哪里可以买到你的书？什么时候上市？如果想跟进后续内容，可以在哪里联系你？以及，听众能为你做些什么？

---

### (01:23:34) Marty Cagan

**English:**
The book should be available worldwide in electronic Kindle audio and hardback on March 12th. We'll see, but that's what the publishers promise. And you can find about all of the things I talk about and all our stuff is for free on the website, svpg.com, Silicon Valley Product Group. And if you don't know at least one of the partners, you should try to meet one. We all love meeting the community and I think you'll enjoy it. So hopefully that's useful.

**中文翻译:**
这本书应该会在 3 月 12 日以电子书（Kindle）、有声书和精装本的形式在全球发售。我们拭目以待，但这是出版商承诺的。你可以在我们的网站 svpg.com（硅谷产品集团）上找到我谈论的所有内容，我们所有的资料都是免费的。如果你还不认识我们的任何一位合伙人，你应该试着认识一下。我们都喜欢与社区交流，我想你会喜欢的。希望这些信息有用。

---

### (01:24:12) Lenny

**English:**
We've had two partners so far. We'll work our way through the rest over time. And I want to make sure you answer the last question, how can listeners be useful to you?

**中文翻译:**
到目前为止，我们已经请过两位合伙人了，随着时间的推移，我们会把剩下的几位也请来。我想确保你回答了最后一个问题：听众能为你做些什么？

---

### (01:24:20) Marty Cagan

**English:**
To be honest, a lot of the inspiration for what we write comes from questions from people, and so we love it when people read something and if it works, great, and they tell us, we love that too. But if they have follow-up questions, one of the nice things about the online archive is we'll just go update the article to address the question. So we love that.

**中文翻译:**
老实说，我们写作的很多灵感都来自人们提出的问题。所以，如果人们读了某些内容并觉得有用，然后告诉我们，我们会非常开心。但如果他们有后续问题，我们的在线存档有一个好处，就是我们会直接去更新文章来回答那个问题。所以我们很欢迎提问。

---

### (01:24:40) Lenny

**English:**
You do the same thing.

**中文翻译:**
你也是这么做的。

---

### (01:24:41) Marty Cagan

**English:**
So feel free.

**中文翻译:**
所以请尽管提问。

---

### (01:24:42) Lenny

**English:**
All right. Amazing. Marty, thank you so much for making time to do this and for being here.

**中文翻译:**
好的。太棒了。马蒂，非常感谢你抽时间来参加节目。

---

### (01:24:47) Marty Cagan

**English:**
Thank you, Lenny.

**中文翻译:**
谢谢你，莱尼。

---

### (01:24:48) Lenny

**English:**
Bye everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
再见，各位。非常感谢大家的收听。如果你觉得这一集有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅本节目。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。我们下期再见。