# Matt Abrahams - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Matt Abrahams.

---

### [00:00:00] [Matt Abrahams]

**English:**
Visualization is a really useful technique and you see yourself not just in the moment of speaking, but getting up to the stage, seeing it being well received, thinking about how you step off the stage. We see athletes do this kind of thing all the time, and there's good research to say that this desensitizes people.

**中文翻译:**
视觉化（Visualization）是一个非常有用的技巧。你不仅要想象自己正在演讲的那一刻，还要想象自己走上舞台、看到演讲受到欢迎、以及思考如何走下舞台的过程。我们经常看到运动员做这种练习，而且有充分的研究表明，这能帮助人们脱敏（降低对特定压力的敏感度）。

---

### [00:00:16] [Lenny Rachitsky]

**English:**
Most of the public speaking we do is on the spot. It's not often you give a prepared talk.

**中文翻译:**
我们进行的大多数公众演讲都是即兴的。你很少会有机会去做一个准备充分的正式演讲。

---

### [00:00:20] [Matt Abrahams]

**English:**
You actually have to prepare to be spontaneous. And that's counterintuitive, but when you think about it in athletics or jazz music, it's like of course you would prepare and practice.

**中文翻译:**
你实际上必须为“即兴发挥”做准备。这听起来有悖常理，但当你想到体育运动或爵士乐时，你就会觉得准备和练习是理所当然的。

---

### [00:00:28] [Lenny Rachitsky]

**English:**
Are there any other techniques that you love that you find people find really helpful in calming their anxiety?

**中文翻译:**
还有其他你喜欢的、觉得对缓解焦虑非常有帮助的技巧吗？

---

### [00:00:34] [Matt Abrahams]

**English:**
Strive for connection over perfection by daring to be dull. Just answer the question. Just give the feedback. Just be engaged in the small talk. By doing that, you dial down the volume of self-evaluation, freeing up resources that can be used to really help you succeed.

**中文翻译:**
通过“敢于平庸”（daring to be dull）来追求连接而非完美。只需回答问题，只需给出反馈，只需投入到闲聊中。通过这样做，你降低了自我评价的音量，从而释放出资源，真正帮助你取得成功。

---

### [00:00:54] [Lenny Rachitsky]

**English:**
Today my guest is Matt Abrahams. Matt is a professor at Stanford University's Graduate School of Business where he teaches a very popular class on communication and public speaking. He's also the host of the incredibly popular podcast, Think Fast, Talk Smart; and the author of the very popular book, Think Faster and Talk Smarter. Matt also coaches people one-on-one on public speaking and communication skills. And in our conversation we focus on the two areas that people most need help with. One, reducing their anxiety before and during any form of public speaking, and getting better at speaking on the spot, including giving better toasts, giving feedback, doing Q&A, and even apologizing.

**中文翻译:**
今天的嘉宾是 Matt Abrahams。Matt 是斯坦福大学商学院的教授，他在那里教授一门非常受欢迎的沟通与公众演讲课程。他还是极受欢迎的播客《Think Fast, Talk Smart》的主持人，以及畅销书《Think Faster and Talk Smarter》的作者。Matt 还提供公众演讲和沟通技巧的一对一辅导。在我们的对话中，我们专注于人们最需要帮助的两个领域：第一，减少在任何形式的公众演讲之前和期间的焦虑；第二，提高即兴演讲的能力，包括如何更好地祝酒、给出反馈、进行问答环节，甚至是道歉。

---

### [00:01:36] [Lenny Rachitsky]

**English:**
Like we talk about in the actual conversation, speaking well is a superpower in your career for interviewing, for being great in meetings, for pitching your manager on ideas, to leading teams. And the skill becomes even more important as you grow in your career. The good news is that you can get better at it with a bit of help. I've worked on this a lot over the course of my career and I still get really nervous before big talks and even before every podcast episode, but many of these techniques I actually put into practice and I share that in our conversation. If you pick just a couple things from this episode to put into practice, you'll become a better communicator, you'll be less nervous, and you'll get better at dealing with on-the-spot moments.

**中文翻译:**
正如我们在对话中谈到的，擅长表达是你职业生涯中的一项超能力——无论是面试、在会议中表现出色、向经理推销想法，还是领导团队。随着职业生涯的发展，这项技能变得愈发重要。好消息是，只要有一点帮助，你就能做得更好。在我的职业生涯中，我在这方面下了很多功夫，但在大型演讲之前，甚至在每一集播客录制之前，我仍然会感到非常紧张。不过，我确实将其中许多技巧付诸实践，并在对话中分享了这些经验。如果你能从本集节目中挑选几件事去实践，你就会成为一个更好的沟通者，变得不那么紧张，并更擅长处理即兴时刻。

---

### [00:02:14] [Lenny Rachitsky]

**English:**
If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. It's the best way to avoid missing feature episodes and it helps the podcast tremendously. With that, I bring you Matt Abrahams after a short word from our sponsors.

**中文翻译:**
如果你喜欢这个播客，别忘了在您常用的播客应用或 YouTube 上订阅并关注。这是避免错过未来节目的最佳方式，也对本节目有巨大的帮助。下面，在听完赞助商的简短介绍后，让我们欢迎 Matt Abrahams。

---

### [00:02:29] [Lenny Rachitsky]

**English:**
Let me tell you about a product called Sprig. Next-gen product teams like Figma and Notion rely on Sprig to build products that people love. Sprig is an AI-powered platform that enables you to collect relevant product experience insights from the right users so you can make product decisions quickly and confidently.
(00:02:48):
Here's how it works. It all starts with Sprig's precise targeting, which allows you to trigger in-app studies based on users' characteristics and actions taken in product. Then Sprig's AI is layered on top of all studies to instantly surface your product's biggest learnings. Sprig Surveys enables you to target specific users to get relevant and timely feedback. Sprig Replays enables you to capture targeted session clips to see your product experience firsthand. Sprig's AI is a game changer for product teams. They're the only platform with product-level AI, meaning it analyzes data across all of your studies to centralize the most important product opportunities, trends, and correlations in one real-time feed. Visit sprig.com/lenny to learn more and get 10% off. That's S-P-R-I-G.com/lenny.

**中文翻译:**
让我向你介绍一款名为 Sprig 的产品。像 Figma 和 Notion 这样的新一代产品团队都依靠 Sprig 来打造深受人们喜爱的产品。Sprig 是一个人工智能驱动的平台，它能让你从目标用户那里收集相关的产品体验洞察，从而让你能够快速且自信地做出产品决策。
(00:02:48):
它的工作原理如下：一切始于 Sprig 的精准定位，它允许你根据用户的特征和在产品中的操作触发应用内研究。然后，Sprig 的 AI 会覆盖在所有研究之上，立即呈现出产品中最重要的学习点。Sprig Surveys（调查）能让你针对特定用户获取相关且及时的反馈。Sprig Replays（回放）能让你捕捉特定的会话片段，亲眼观察产品体验。Sprig 的 AI 对产品团队来说是一个游戏规则改变者。他们是唯一拥有产品级 AI 的平台，这意味着它能分析你所有研究中的数据，并在一个实时信息流中汇总最重要的产品机会、趋势和相关性。访问 sprig.com/lenny 了解更多信息并获得 10% 的折扣。即 S-P-R-I-G.com/lenny。

---

### [00:03:40] [Lenny Rachitsky]

**English:**
This episode is brought to you by Dovetail, the customer insights hub for product teams. Are you working in a feature factory building filler that nobody wants? Probably, because the sad truth is that most SaaS features are rarely or never used, costing the industry billions every year. Let's change that. Product managers, Dovetail is holding their first industry conference, it's called Insight Out, and they want you to come. Over one day in San Francisco, the product community is coming together to learn how to better leverage customer insights and build products that people actually love to use. It's on April 11, and you can hear from product leaders from Uber, Twitch, Meta and Netflix, as they share their strategies for driving innovation, thriving in uncertainty, and balancing customer-centered work with business needs. And here's the kicker, it's absolutely free for online tickets. Just go to dovetail.com/lenny to register. This is thanks to Dovetail, the best way for product teams to get the most out of customer insights. Check it out at dovetail.com/lenny.

**中文翻译:**
本集节目由 Dovetail 为你呈现，它是产品团队的客户洞察中心。你是否在“功能工厂”工作，制造没人想要的填充物？很有可能，因为悲哀的现实是，大多数 SaaS 功能很少或从未被使用，每年给行业造成数十亿美元的损失。让我们改变这种状况。产品经理们，Dovetail 正在举办他们的首届行业会议，名为 Insight Out，他们希望你能参加。在旧金山为期一天的会议中，产品社区将齐聚一堂，学习如何更好地利用客户洞察，打造人们真正喜爱使用的产品。会议将于 4 月 11 日举行，你可以听到来自 Uber、Twitch、Meta 和 Netflix 的产品领导者分享他们在驱动创新、在不确定性中蓬勃发展以及平衡以客户为中心的工作与业务需求方面的策略。最棒的是，在线门票完全免费。只需前往 dovetail.com/lenny 注册即可。感谢 Dovetail，这是产品团队充分利用客户洞察的最佳方式。请访问 dovetail.com/lenny 查看。

---

### [00:04:50] [Lenny Rachitsky]

**English:**
Matt, thank you so much for being here and welcome to the podcast.

**中文翻译:**
Matt，非常感谢你能来到这里，欢迎来到本播客。

---

### [00:04:54] [Matt Abrahams]

**English:**
Lenny, I am excited for our conversation and thank you for having me.

**中文翻译:**
Lenny，我很期待我们的对话，谢谢你邀请我。

---

### [00:04:57] [Lenny Rachitsky]

**English:**
Thank you for being here. I'm even more excited for the conversation. So what I want to do with our time today is there's two areas I want to focus. One is talking about techniques to help people manage anxiety when public speaking. And two is helping people get better at speaking on the spot, which you wrote a whole book about. And if you think about it, I think that's like most of the public speaking we do is on the spot. It's not often you give a prepared talk. It's usually like you said, Q&A or a or toast someone wants to give you or ask for feedback or things like that. So I'm excited to dig into those things. How do that sound broadly?

**中文翻译:**
谢谢你的到来。我更期待这次对话。所以我想利用今天的时间关注两个领域：一是探讨帮助人们在公众演讲时管理焦虑的技巧；二是帮助人们提高即兴演讲的能力，你为此写了一整本书。仔细想想，我认为我们进行的大多数公众演讲其实都是即兴的。你很少会去做一个准备好的正式演讲，通常就像你说的，是问答环节、祝酒、被要求提供反馈之类的事情。所以我很兴奋能深入探讨这些内容。大体上听起来怎么样？

---

### [00:05:33] [Matt Abrahams]

**English:**
Absolutely, I look forward to that and those are topics I'm very excited to talk about, have done a lot of research in and look forward to sharing more.

**中文翻译:**
没问题，我很期待。这些也是我非常兴奋想要探讨的话题，我对此做了大量研究，并期待分享更多内容。

---

### [00:05:41] [Lenny Rachitsky]

**English:**
I suspected as much. Okay, so let's talk about anxiety. You have a bunch of really novel techniques in your book and your podcast for calming your body down, calming your mind down when you're planning to give a talk, when you're actually about to give a talk, when you're giving a talk. And a lot of these I haven't actually seen anywhere else and I've used a few of them and they are really great. So what I was thinking we'd do is let me go through the ones that I found most useful and interesting and just share your advice on those and then see if there's any I missed and then maybe add those at the end. How's that?

**中文翻译:**
我猜也是。好的，那我们来谈谈焦虑。在你的书和播客中，你提到了很多非常新颖的技巧，用于在计划演讲、即将演讲以及正在演讲时让身体和头脑冷静下来。其中很多技巧我从未在别处见过，我试用了几个，效果非常好。所以我想，我们可以先过一遍我觉得最有用、最有趣的几个，请你分享建议，然后看看我是否遗漏了什么，最后再补充。这样可以吗？

---

### [00:06:15] [Matt Abrahams]

**English:**
That sounds great. That sounds great. I love that you've applied some of these techniques and found value from them.

**中文翻译:**
太棒了。我很高兴你应用了其中的一些技巧并从中发现了价值。

---

### [00:06:19] [Lenny Rachitsky]

**English:**
I'll talk about this, I'll talk about this. Okay, first of all, just to catch on this, you're not a fan of the picture people in your audience naked approach, correct?

**中文翻译:**
我会谈谈这个。首先，关于这一点，你并不赞成“想象观众是全裸的”这种方法，对吧？

---

### [00:06:27] [Matt Abrahams]

**English:**
The Brady Bunch advice is not good advice. I don't know about you and I don't know anybody who could imagine seeing a bunch of people in their underwear and feel more comfortable with that. And I think if you do, there are other issues you need to be dealing with than beyond speaking anxiety.

**中文翻译:**
《布雷迪家庭》（The Brady Bunch）式的建议并不是好建议。我不知道你怎么想，但我没见过谁能通过想象一群人穿着内衣就能感到更自在的。我认为如果你真的这么觉得，那你可能面临着比演讲焦虑更严重的其他问题。

---

### [00:06:42] [Lenny Rachitsky]

**English:**
Yeah, it feels like highly inappropriate now, just that idea, trying to picture everyone-

**中文翻译:**
是的，现在感觉这种想法非常不合适，试着想象每个人——

---

### [00:06:46] [Matt Abrahams]

**English:**
No, but underlying that if you'll give me a moment, there is some value. This notion of visualization as a tool of desensitization actually can be very helpful, but you're not visualizing the audience half naked. What you're doing is you're visualizing yourself in that space. You're visualizing the audience responding to you and what you're saying. So just like a pilot might do a flight simulator, having a visualization can actually really help you feel more comfortable and confident. It literally puts you in the room even though you're not there. And there's some tools and I'm fascinated by these tools that are virtual reality tools that can also serve to desensitize you. So this notion of seeing your audience in advance of actually speaking can actually impact your level of comfort. It's let's keep everybody clothed and let's keep them all focused on your topic.

**中文翻译:**
不，但如果你给我一点时间，这背后其实是有价值的。这种将视觉化作为脱敏工具的概念实际上非常有帮助，但你不是在想象观众半裸。你所做的是想象自己身处那个空间，想象观众对你和你所说的话做出反应。就像飞行员进行飞行模拟一样，进行视觉化练习确实能让你感到更自在、更自信。它能让你身临其境，即使你并不在现场。我对一些虚拟现实（VR）工具非常着迷，它们也能起到脱敏的作用。因此，在实际演讲前预见你的观众确实会影响你的舒适度。只是我们要让大家都穿好衣服，并让他们都专注于你的主题。

---

### [00:07:36] [Lenny Rachitsky]

**English:**
Well, let's actually talk about this one while we're on it because I think this is a really powerful technique. An idea just to kind of summarize, you picture ahead of time, what it's going to look like and feel like. You talking, looking at the audience. You talk about that and just how to go about using that technique.

**中文翻译:**
既然谈到了这个，我们来深入聊聊，因为我觉得这是一个非常强大的技巧。简单总结一下，就是你提前想象那个场景的样子和感觉：你正在说话，看着观众。请谈谈这个，以及具体如何使用这个技巧。

---

### [00:07:50] [Matt Abrahams]

**English:**
Yeah, absolutely. And this is some of the oldest research on public speaking anxiety. It was research done in the '80s from the University of Oregon. So visualization, what it does is it allows you to see the event in a way that you have much more control over it so you can think about it. So a good visualization involves some deep breathing to calm yourself. Either you close your eyes or you just look at a picture. Maybe you can get a picture of the environment you're speaking in. I often recommend speakers see the room even if they're not physically present, but get a picture online or some way envision yourself in the room, envision yourself in the room with the people you'll be speaking to. Often we know the individuals or some of them. We can also go online and figure out who they are.
(00:08:39):
So visualization is a really useful technique and you see yourself not just in the moment of speaking but getting up to the stage, delivering the presentation, seeing it being well received, thinking about how you step off the stage. And by taking yourself through that you in essence are a dress rehearsal even though you're not physically in the room. And there's good research to say that this desensitizes people. We see athletes do this kind of thing all the time where they'll do visualization to help them and it really does work. And like I said, there are virtual tools now that can help you do this where you can actually program it to have a certain size audience. You can even program some of these to have a responsive audience or a distracted audience. All of this in service of just preparing you for what you're really going to see.
(00:09:25):
The bottom line is this, what you're doing for yourself is making sure it's not new and novel. It's something been there, done that, even though if it was virtual or visualized in your mind, to help you feel better about the circumstance. It gives you a sense of agency.

**中文翻译:**
没错。这是关于公众演讲焦虑最古老的研究之一，是俄勒冈大学在 80 年代做的研究。视觉化的作用是让你以一种更有掌控感的方式预见事件，从而进行思考。一个好的视觉化练习包括深呼吸来让自己平静。你可以闭上眼睛，或者只是看一张照片。也许你可以找一张你将要演讲的环境的照片。我经常建议演讲者即使不能亲临现场，也要看看房间的样子，在网上找张照片，或者以某种方式想象自己就在那个房间里，想象自己和听众在一起。通常我们认识其中的一些人，或者可以在网上查到他们是谁。
(00:08:39):
所以视觉化是一个非常有用的技巧。你不仅要看到自己演讲的那一刻，还要看到自己走上舞台、进行演讲、看到演讲受到好评，以及思考如何走下舞台。通过这个过程，你本质上是在进行一场“彩排”，即使你并不在房间里。有充分的研究表明这能让人脱敏。我们看到运动员经常做这种视觉化练习来帮助自己，这确实有效。正如我所说，现在有一些虚拟工具可以帮助你，你可以设置特定规模的观众，甚至可以设置观众是积极响应的还是注意力分散的。所有这些都是为了让你对即将看到的真实场景做好准备。
(00:09:25):
归根结底，你是在确保这个场景对你来说不再是全新的、陌生的。它变成了某种“经历过”的事情，即使这种经历只是虚拟的或在脑海中想象的，这能让你对环境感觉更好，给你一种掌控感（agency）。

---

### [00:09:42] [Lenny Rachitsky]

**English:**
I've done this myself actually. I gave a TEDx talk once and it was probably the scariest talk I've ever given and I spent a lot of time doing this and it doesn't actually have to take that much time. It could be like a five-minute thing where you sit down, calm yourself, and then just picture the stuff. And ideally you do it a couple times, I imagine.

**中文翻译:**
我自己也做过这个。我曾经做过一次 TEDx 演讲，那可能是我做过最吓人的演讲。我花了很多时间做视觉化练习，其实它不需要占用太多时间。可能只需要五分钟，你坐下来，让自己平静，然后想象那些场景。我想，理想情况下应该多做几次。

---

### [00:09:57] [Matt Abrahams]

**English:**
That's right. Good for you. And congratulations on giving a TEDx talk. That is a high-stakes talk.

**中文翻译:**
没错。做得好。恭喜你做了 TEDx 演讲。那是一个高风险的演讲。

---

### [00:10:01] [Lenny Rachitsky]

**English:**
Thank you. That was before TEDx became super uncool. It was still pretty early. It's out there in the internet in case people want to find it.

**中文翻译:**
谢谢。那是发生在 TEDx 变得超级“不酷”之前。当时还挺早的。它还在网上，如果有人想找的话可以找到。

---

### [00:10:09] [Matt Abrahams]

**English:**
Don't say they're uncool. I'm doing one in two weeks.

**中文翻译:**
别说它们不酷。我两周后就要去做一个。

---

### [00:10:11] [Lenny Rachitsky]

**English:**
They're so cool. That is, they are cool.

**中文翻译:**
它们很酷。那是，它们确实很酷。

---

### [00:10:13] [Matt Abrahams]

**English:**
That's right.

**中文翻译:**
没错。

---

### [00:10:17] [Lenny Rachitsky]

**English:**
They're incredible. I'm impressed.

**中文翻译:**
它们太棒了。我很佩服。

---

### [00:10:17] [Matt Abrahams]

**English:**
I've done a number of them and I've coached many people and I think that there's a lot of value that they can provide people.

**中文翻译:**
我已经做过好几次了，也指导过很多人，我认为它们能为人们提供很多价值。

---

### [00:10:21] [Lenny Rachitsky]

**English:**
There is. There is. I think they've just become slightly less cool because now there's a lot of them, but they're still incredibly cool, I'm very proud.

**中文翻译:**
是的。是的。我觉得它们只是变得稍微没那么酷了，因为现在数量太多了，但它们依然非常酷，我很自豪。

---

### [00:10:29] [Matt Abrahams]

**English:**
Okay, thank you.

**中文翻译:**
好的，谢谢。

---

### [00:10:31] [Lenny Rachitsky]

**English:**
So on the visualization piece, I think we have a lot of techniques, but just on this one, part of it is continue to calm yourself as you're doing it. I think that's really important because you want to help your body not connect to the stress that you're feeling like you're going to experience.

**中文翻译:**
所以关于视觉化，我们有很多技巧，但就这一个而言，其中一部分是在做的过程中持续让自己冷静下来。我认为这非常重要，因为你想帮助你的身体不要与你预感会经历的压力产生连接。

---

### [00:10:46] [Matt Abrahams]

**English:**
That's correct. Any distance you can give yourself from the anxiety that you're feeling is helpful and there are lots of techniques that help give you a little bit of distance and visualization is one of those.

**中文翻译:**
没错。任何能让你与所感受到的焦虑保持距离的方法都是有帮助的，有很多技巧可以帮你拉开一点距离，视觉化就是其中之一。

---

### [00:10:57] [Lenny Rachitsky]

**English:**
One of my favorite techniques that it might be in this bucket, it might be on the spot advice bucket, but I think it works great here is what you call dare to be dull. Can you talk about that because I love that?

**中文翻译:**
我最喜欢的技巧之一——它可能属于这一类，也可能属于即兴建议那一类，但我认为在这里效果很好——就是你所说的“敢于平庸”（dare to be dull）。你能谈谈那个吗？因为我很喜欢。

---

### [00:11:09] [Matt Abrahams]

**English:**
Yeah. I really leaned into this with the spontaneous speaking work that I've been doing as of late, but it applies to anybody speaking. This is a notion that comes from the world of improvisation and when people hear improv, they often think of standup comedy, having to be funny. And that's not what improv is all about. Improv is all about being present, being collaborative, being open, and it's a wonderful tool just to help you get present oriented. Think of it as like meditation in action, but also it teaches lots of valuable skills for communication.
(00:11:42):
When we communicate, especially spontaneously, we want to do it really well. We want to answer the question with the best answer, we want to give the right feedback, we want to be the most interesting in small talk and that puts a lot of pressure on ourselves. And you can think of it this way, it's really taxing our cognitive bandwidth.
(00:12:04):
Your brain in many ways is like a CPU, a computer. It's not a perfect analogy, but it works. And if I am constantly judging and evaluating everything I am saying against some standard of perfection, whatever that is, it means I have a limited amount of bandwidth to focus on what I'm actually saying and connecting to my audience. If you have a laptop or a phone that has lots of windows and apps open, each one of those is performing less well because of the other ones being open. So I often say strive for connection over perfection by daring to be dull. Just get the task done, just answer the question, just give the feedback, just be engaged in the small talk. And by doing that you dial down the volume of self-evaluation, freeing up resources that can be used to really help you succeed. So dare to be dull is all about giving yourself permission to just be present and do what's needed. And when you do that you find that you actually do quite a good job at it.

**中文翻译:**
是的。我最近在即兴演讲的工作中非常推崇这一点，但它适用于任何形式的演讲。这个概念源自即兴表演（improvisation）。当人们听到即兴表演时，往往会想到单口喜剧，觉得必须搞笑。但那不是即兴表演的全部。即兴表演的核心在于临场感（being present）、协作和开放。它是一个极好的工具，能帮你专注于当下。你可以把它看作是“行动中的冥想”，同时它也教授许多宝贵的沟通技巧。
(00:11:42):
当我们沟通时，尤其是即兴沟通，我们总想表现得非常出色。我们想用最好的答案回答问题，想给出最正确的反馈，想在闲聊中成为最有趣的人，这给我们自己带来了巨大的压力。你可以这样想：这实际上在消耗我们的认知带宽。
(00:12:04):
在许多方面，你的大脑就像一个 CPU，一台电脑。这不是一个完美的类比，但很管用。如果我不断地根据某种完美标准（无论那是什么）来评判和评估我所说的每一句话，这意味着我只有有限的带宽来专注于我实际在说的话以及与观众的连接。如果你的笔记本电脑或手机打开了许多窗口和应用，由于其他应用的运行，每一个应用的性能都会下降。所以我经常说：通过“敢于平庸”来追求连接而非完美。只需完成任务，只需回答问题，只需给出反馈，只需投入到闲聊中。通过这样做，你降低了自我评价的音量，释放出资源，真正帮助你取得成功。所以，“敢于平庸”的核心在于允许自己仅仅是临场发挥，做该做的事。当你这样做时，你会发现自己其实做得相当不错。

---

### [00:13:03] [Lenny Rachitsky]

**English:**
The last point I think is really important, you talk about this in your book. Is when you start with, "Okay, I'm just going to say something, it'll be fine." Without that pressure, you end up saying something better and more interesting and more insightful because you're less nervous about it.

**中文翻译:**
最后一点我觉得非常重要，你在书里也提到了。当你开始想：“好吧，我随便说点什么就行，没事的。” 没有了那种压力，你最终反而会说出更好、更有趣、更有见地的话，因为你没那么紧张了。

---

### [00:13:16] [Matt Abrahams]

**English:**
That's exactly right. We are often our biggest impediments to good communication because of the anxiety we bring to the party.

**中文翻译:**
完全正确。由于我们带到现场的焦虑，我们往往是自己良好沟通的最大障碍。

---

### [00:13:23] [Lenny Rachitsky]

**English:**
That's awesome. And I think this can apply to prepared talks too. When you're preparing a deck, don't put this pressure on yourself, "This has to be the best talk ever." Just like, "I'm going to do my best. Let me just start with something that's good enough." People learn something and then from that, their editing ends up leading to something great in my experience.

**中文翻译:**
太棒了。我觉得这也可以应用于准备好的演讲。在准备幻灯片时，不要给自己压力，想着“这必须是有史以来最好的演讲”。只需想：“我会尽力而为。让我先从一个足够好的东西开始。” 根据我的经验，人们学到了一些东西，然后通过修改，最终会产生伟大的作品。

---

### [00:13:39] [Matt Abrahams]

**English:**
Right.

**中文翻译:**
对。

---

### [00:13:40] [Lenny Rachitsky]

**English:**
Awesome. Okay, let's go to the next technique, and this is another one I've practiced and another guest on the podcast actually suggested this and these two remind me of using this one, which is to tell yourself when you're going to be giving a talk. "I'm excited. This is going to be a lot of fun. I'm so excited to give this talk." And reframe it from, "I'm nervous," to like, "No, I'm excited. This is going to be amazing." Can you talk about that technique?

**中文翻译:**
太棒了。好的，我们来看下一个技巧，这是我练习过的另一个技巧，播客的另一位嘉宾也建议过，这两者让我想起使用这个技巧，那就是在你要演讲时告诉自己：“我很兴奋。这会很有趣。我非常兴奋能做这次演讲。” 把“我好紧张”重构为“不，我很兴奋。这会很棒。” 你能谈谈那个技巧吗？

---

### [00:14:04] [Matt Abrahams]

**English:**
Absolutely. So this is one of many cognitive reframing techniques. It is often attributed to my friend and colleague, Alison Wood Brooks, she's at Harvard Business School who did some research into this. And what she found is...
(00:14:18):
Well, first take a step back. When you get physically aroused by anxiety, you're under that fight or flight threat response. It turns out that same response happens to your body when you're excited. The human body has pretty much just one arousal response. Our heart beats faster, we breathe more shallow, we get a little shaky, but the big difference is how we label that. So if I say, "Hey Lenny, guess what? Your colleague couldn't show up today and you need to go teach the class or you need to go give that presentation." You might feel your heart rate go up, get a little shaky, sweat on your brow and you're seeing that as negative. But if I said, "Hey Lenny, guess what? You just won the lottery." Same physiological response would happen, but you would see that likely as more positive.
(00:15:06):
So how we label the arousal matters and what Alison's research and others have followed up with suggests is that when we feel those symptoms of anxiety, rather than seeing it as negative, say, "This is exciting. I get to share my point of view. I get to demonstrate my value." And in so doing by seeing it as more positive, it causes us by definition to relax. And her research fascinatingly found that people actually were perceived as communicating better. And again that's because that pressure was taken off of them. So I challenge everybody to think about what are the exciting elements of the communication opportunities you have and really lean into those. And when you feel those anxiety symptoms, remind yourself these are signs of excitement. This is me being excited about sharing this information and it can really help.

**中文翻译:**
当然可以。这是众多认知重构（cognitive reframing）技巧之一。这通常归功于我的朋友兼同事、哈佛商学院的 Alison Wood Brooks，她对此做了一些研究。她发现……
(00:14:18):
首先，让我们退一步看。当你因焦虑而产生生理唤醒时，你处于那种“战斗或逃跑”的威胁反应中。事实证明，当你兴奋时，你的身体也会产生同样的反应。人体基本上只有一种唤醒反应：心跳加快、呼吸变浅、身体微微发抖。但巨大的区别在于我们如何给它贴标签。如果我说：“嘿，Lenny，猜怎么着？你的同事今天没法来，你需要去代课或者去做那个演讲。” 你可能会感到心跳加快、微微发抖、额头冒汗，你会觉得这是负面的。但如果我说：“嘿，Lenny，猜怎么着？你刚中了彩票。” 同样的生理反应也会发生，但你很可能会觉得这是积极的。
(00:15:06):
所以，我们如何标记这种唤醒非常重要。Alison 的研究以及其他后续研究表明，当我们感到那些焦虑症状时，与其将其视为负面，不如说：“这很令人兴奋。我有机会分享我的观点，展示我的价值。” 通过将其视为更积极的事情，从定义上讲，它会让我们放松。她的研究还发现了一个有趣的现象：这些人实际上被认为沟通得更好。同样，这是因为压力被释放了。所以我挑战每个人去思考你的沟通机会中有哪些令人兴奋的元素，并真正投入其中。当你感到那些焦虑症状时，提醒自己这些是兴奋的迹象。这是我对分享这些信息感到兴奋的表现，这真的很有帮助。

---

### [00:15:56] [Lenny Rachitsky]

**English:**
This is another one I've done and it super works. It sounds so trivial and so like, "Why would this do anything?" But I find you just say that just like, "I'm going to have so much fun. This is going to be exciting." It does make an impact. So another one to try, even though it sounds really trivial.
(00:16:12):
Kind of along these lines, there's another technique you recommend which is a mantra, having a mantra that you repeat to yourself. I don't know if it's kind of the same general idea, but you have a couple mantras that you recommend to people like "I have value to add" and things like that. What advice do you have there?

**中文翻译:**
这是另一个我尝试过且超级有效的技巧。听起来很琐碎，好像“这能起什么作用？” 但我发现你只要那样说，“我会玩得很开心，这会很令人兴奋”，它确实会产生影响。所以这是另一个值得尝试的方法，尽管听起来很微不足道。
(00:16:12):
沿着这个思路，你还推荐了另一个技巧，那就是“咒语”（mantra），给自己重复一个咒语。我不知道这是否属于同一种思路，但你确实有几个推荐给人们的咒语，比如“我有价值可以贡献”之类的。你有什么建议吗？

---

### [00:16:27] [Matt Abrahams]

**English:**
Yes, thank you. And that's mine. The one that you shared is, "I have value to add." So if we were to really listen to the voice in our heads when it comes to communication, we say a lot of negative things to ourselves. We say things like, "I'm not prepared. I'm not going to be as good as this person. I'm an imposter." We carry around with us a lot of this chatter that actually sets us up to not do well or to be more nervous. So if we can actually change that talk track, it can help us.
(00:17:01):
I'm not saying you have to go to an extreme and say, "I'm going to be the best communicator ever." Rather you can simply say as I do and as you alluded to. What I'll say right before I speak is, "I have value to bring."
(00:17:12):
Often when we are in communicative situations, especially at work, people want to hear from us. We've been invited to speak, we're on the agenda for the meeting. There is value people can take from our communication and we just have to remind ourselves of that. So having some little mantra that you can say that's not over the top but just makes sense. It could be as simple as you've got this, or I'm prepared, or I know my stuff. And I actually encourage people to write it on a post-it note if you're old school, sometimes people put it into their phones as a reminder. So like a minute or two minutes before they're set to give the presentation or participate in the meeting, it flashes up. We just have to turn off or turn down the noise of that internal negative self-talk.

**中文翻译:**
是的，谢谢。那是我的。你分享的那个是：“我有价值可以贡献。” 如果我们真的去倾听脑海中关于沟通的声音，我们会对自己说很多负面的话。我们会说：“我没准备好”、“我不会像那个人一样好”、“我是个冒牌货”。我们随身携带的这些碎碎念实际上让我们表现不佳或更加紧张。所以，如果我们能改变这种对话轨道，它就能帮助我们。
(00:17:01):
我不是说你要走向极端，说“我要成为有史以来最好的沟通者”。相反，你可以像我一样，或者像你提到的那样简单地说。我在演讲前会说：“我有价值可以带来。”
(00:17:12):
通常当我们处于沟通情境中，尤其是在工作中，人们是想听我们说话的。我们被邀请发言，我们出现在会议议程上。人们可以从我们的沟通中获得价值，我们只需要提醒自己这一点。所以，准备一个简短的咒语，不要太夸张，只要合情合理就行。它可以简单到“你能行”、“我准备好了”或“我了解我的内容”。我甚至鼓励人们把它写在便利贴上（如果你比较传统的话），有时人们会把它存进手机作为提醒。在他们准备做演示或参加会议前一两分钟，它会弹出来。我们只需要关掉或调低那些内在负面自我对话的噪音。

---

### [00:17:58] [Lenny Rachitsky]

**English:**
What are some other mantras that you found helpful or that people use?

**中文翻译:**
还有哪些你觉得有帮助或者人们常用的咒语？

---

### [00:18:03] [Matt Abrahams]

**English:**
They're very personal to different people. I was just coaching a senior leader the other day who his mantra was, "Last time this went well." He's a leader, he does a lot of the same presentations and just by saying last time this went well, reminds him that it's likely to go well this time. We are very susceptible to catastrophizing when we're very nervous about things, especially when we're exposed in front of people. Not in the Brady Bunch exposure we talked about earlier, but when we're out there speaking or communicating and simply reminding ourselves that often they go very well is helpful.

**中文翻译:**
对不同的人来说，这些是非常个性化的。我前几天刚指导过一位资深领导者，他的咒语是：“上次进展很顺利。” 他是一位领导者，经常做同样的演示，只要说“上次进展很顺利”，就能提醒他这次也很可能顺利。当我们对某些事情感到非常紧张时，尤其是当我们在众人面前“暴露”时，我们非常容易产生灾难化思维（catastrophizing）。不是我们之前谈到的那种《布雷迪家庭》式的暴露，而是当我们站在那里演讲或沟通时，简单地提醒自己通常情况都进展得很好，这是非常有帮助的。

---

### [00:18:36] [Lenny Rachitsky]

**English:**
Yeah. There's another one that I think you shared which is, "It's not about me, it's about my content."

**中文翻译:**
是的。我觉得你还分享过另一个，就是：“这不关乎我，关乎我的内容。”

---

### [00:18:41] [Matt Abrahams]

**English:**
Yes, exactly. That's another one. That's a great one. It can be very helpful.

**中文翻译:**
是的，没错。那是另一个。那是一个很棒的咒语。它会非常有帮助。

---

### [00:18:45] [Lenny Rachitsky]

**English:**
The one you shared about, "I've got this," reminds me, my wife took a course with the Artist's Way writer, Julia Cameron I think is her name. And she has this piece of advice where you name your critic, your inner critic that's always telling you to stop doing stuff. You name him or her. So I name mine Jim. And then when he or she is giving you things you don't want to hear, you're just like, "Jim, I got this. Jim, I don't need this advice."

**中文翻译:**
你分享的那个“我能行”（I've got this）让我想起，我妻子参加过《艺术家之路》（The Artist's Way）作者 Julia Cameron 的课程。她有一个建议，就是给你的批评者，也就是那个总是叫你停止做事的内在批评者起个名字。我给我的起名叫 Jim。当他或她给你一些你不想听的建议时，你就说：“Jim，我能行。Jim，我不需要这个建议。”

---

### [00:19:11] [Matt Abrahams]

**English:**
There is a lot of evidence on personifying the things that challenge us and then having conversations with it. It's a way of rationalizing some of the things that we do that are quite negative. So something there for sure to be thinking about.

**中文翻译:**
有很多证据表明，将挑战我们的事物人格化，然后与其对话，是一种将我们所做的相当负面的事情合理化的方法。所以这绝对是值得思考的一点。

---

### [00:19:30] [Lenny Rachitsky]

**English:**
There we go. Bonus advice. That was-

**中文翻译:**
瞧。额外建议。那是——

---

### [00:19:32] [Matt Abrahams]

**English:**
Bonus advice, yes.

**中文翻译:**
额外建议，是的。

---

### [00:19:33] [Lenny Rachitsky]

**English:**
I didn't expect that.

**中文翻译:**
我没料到会聊到这个。

---

### [00:19:34] [Matt Abrahams]

**English:**
And the cool thing that what you're highlighting is there is a lot of advice out there on how to manage anxiety. Many of us feel like we're the only people who feel this nervous because we see our colleagues, our friends or Ted talks as you were talking about, and we see these people communicating just so effortlessly. Often a lot of work went into that and we don't see that work. And sometimes just knowing that others experience it makes us feel better.
(00:19:58):
If you'll allow me, I'll tell this very quick story. I was in the San Francisco Airport, this was several years ago after my Speaking Up Without Freaking Out book came out, and my name was called over the PA system at the airport counter. The seat that I was supposed to sit in was broken and they wanted to talk to me about it. So when I came away from that, somebody came up to me and said, "Hey, you're the guy that wrote that book on speaking anxiety." I said, "Yes." And I said, "What do you know about it?" He goes, "Oh, I bought the book." I said, "Oh, was it helpful?" He says, "Incredibly helpful, but I didn't read it." I'm like, "This is weird. So you're telling me the book was helpful and you didn't read it?" And so I said, "Tell me more." And he said, "Just knowing that a book like that existed made me feel better because I don't know you and I know you certainly didn't write the book for me. So it implies that lots of people have this issue."
(00:20:44):
And just by normalizing the anxiety, which by the way is the normal condition. Those of us who study this believe it is innate to being human to feel nervous communicating in front of others. So sometimes just reminding yourself that you're not alone and that others have it can actually help reduce the pressure that we feel.

**中文翻译:**
你强调的一点很酷，那就是关于如何管理焦虑有很多建议。我们中的许多人觉得只有自己感到这么紧张，因为我们看到同事、朋友，或者像你说的 TED 演讲，看到这些人沟通得如此轻松。通常这背后付出了大量的努力，而我们看不到。有时，仅仅知道别人也有同样的经历就会让我们感觉好些。
(00:19:58):
如果你允许的话，我讲一个简短的故事。几年前，在我的《Speaking Up Without Freaking Out》一书出版后，我在旧金山机场，机场柜台通过广播叫我的名字。原来是我原本要坐的座位坏了，他们想跟我谈谈。当我离开柜台时，有人走过来对我说：“嘿，你就是写那本关于演讲焦虑的书的人吧。” 我说：“是的。” 我问：“你怎么知道的？” 他说：“噢，我买了那本书。” 我问：“有帮助吗？” 他说：“非常有帮助，但我没读。” 我心想：“这太奇怪了。你告诉我书很有用，但你没读？” 于是我说：“再多讲讲。” 他说：“仅仅知道有这样一本书存在就让我感觉好多了，因为我不认识你，我知道你肯定不是专门为我写的。所以这暗示了很多人都有这个问题。”
(00:20:44):
通过将焦虑常态化（normalizing）——顺便说一下，这确实是正常状态。我们这些研究这个领域的人相信，在他人面前沟通感到紧张是人类的天性。所以有时只需提醒自己你并不孤单，别人也有这种感觉，实际上就能帮助减轻我们感受到的压力。

---

### [00:21:01] [Lenny Rachitsky]

**English:**
This is such an important point that I am kicking myself for not starting with this also because I think this is something people don't realize. They see all their execs at their company speaking incredibly well, so confidently, so articulately and just like, "Oh my God, how will I ever be someone like that?" Is there anything more you can share of just like you have tons of students that go through your class, you see these issues, they're more transparent, you think about their challenges, I imagine. Is there anything more you could share there to help people feel better? Like this is most people, even when you see someone amazing at speaking, they are also probably nervous.

**中文翻译:**
这是一个非常重要的观点，我也在责怪自己没有从这一点开始，因为我觉得这是人们没有意识到的。他们看到公司所有的主管演讲都非常出色，如此自信，如此口齿伶俐，就会想：“天哪，我怎么才能成为那样的人？” 关于这一点，你还能分享更多吗？你有大量的学生参加你的课程，你看到了这些问题，他们更透明，我想你也思考过他们的挑战。你还能分享什么来让人们感觉好一点吗？比如，这是大多数人的常态，即使你看到某个演讲非常出色的人，他们可能也很紧张。

---

### [00:21:36] [Matt Abrahams]

**English:**
With regard to that, I think we just need to talk about it more. We need to share about it. I mean, I always will share that I still have anxiety in speaking in certain situations and it's something that's taken me a long time to work on. I also help people understand that it's not a light switch. It's not like you either have it or you don't. It's a process. And so the idea is over time, we will feel less nervous if we apply some of these principles you and I are talking about.
(00:22:01):
A great technique to help people that often isn't talked about is many of us feel much more comfortable in conversation than we do in presenting. And conversation is a back and forth. So you can actually set up a lot of your communication situations, a presentation, a meeting, et cetera, as conversations. And you don't even have to have a conversation with the audience. You can simply have it with yourself. For example, what would it be like if you were to start a presentation by saying, "Today I have three questions I'd like to answer. Question number one is..." And you state the question and then you answer it. I am actually having a conversation with myself in that moment where I am asking myself a question. I happen to know the answer, I give the answer. This again, just like the reframing as excitement versus anxiety, this is a reframe. I'm not presenting, I'm having a conversation. And in so doing it ratchets down that anxiety.
(00:22:53):
So we need to talk about it. We need to share our experiences with developing anxiety management plans. We realize it's not binary, it's not I have it or I don't. And we start seeing where we feel more comfortable and how can we bring that comfort level into the types of situations that make us nervous, like simply having a conversation with yourself.

**中文翻译:**
关于这一点，我认为我们只需要更多地谈论它。我们需要分享它。我的意思是，我总是会分享我在某些情况下演讲仍然会感到焦虑，这是我花了很长时间才克服的。我也帮助人们理解，这不像电灯开关，不是说你要么有，要么没有。这是一个过程。所以，随着时间的推移，如果我们应用你我正在讨论的这些原则，我们会感到不那么紧张。
(00:22:01):
一个经常不被提及的帮助人们的好技巧是：我们中的许多人在对话中比在演示中感到自在得多。对话是双向的。所以你实际上可以将许多沟通情境（演示、会议等）设定为对话。你甚至不需要真的和观众对话，你可以简单地和自己对话。例如，如果你在开始演示时说：“今天我有三个想回答的问题。第一个问题是……” 然后你陈述问题并回答它。在那一刻，我实际上是在和自己对话，我问自己一个问题，我恰好知道答案，然后给出答案。这同样是一种重构，就像把焦虑重构为兴奋一样。我不是在演示，我是在对话。这样做可以降低焦虑。
(00:22:53):
所以我们需要谈论它。我们需要分享制定焦虑管理计划的经验。我们要意识到这不是非黑即白的，不是“我有”或“我没有”。我们开始观察自己在哪里感到更自在，以及如何将这种舒适感带入那些让我们紧张的情境中，比如简单地和自己对话。

---

### [00:23:13] [Lenny Rachitsky]

**English:**
You have another technique I think that's different, maybe it's exactly the same, which is to ask a question of somebody else as you're talking, which is I think deflects attention from you. Can you talk about that?

**中文翻译:**
你还有另一个我认为不同的技巧，或者可能完全一样，就是在你说话的时候向别人提问，我认为这可以转移对你的注意力。你能谈谈那个吗？

---

### [00:23:22] [Matt Abrahams]

**English:**
Yeah. So we talked about the way we desensitize through visualization. The other thing we can do is distract.
(00:23:30):
I coached a very senior leader at Google who got very nervous when he was up in front of people, and what we did is we distract his audience. So he would start every single presentation saying these words, "Good morning, let's watch this video." And he'd show a 30-second video that was on topic about something they were going to talk about in the meeting. And when the video stopped, he would then facilitate a discussion of what that video was about and then he would ease into his content. So he went from being a presenter to being a facilitator or somebody who was having a conversation with the audience. That made him feel so much better.
(00:24:05):
And so all of us can do things that can distract our audience. Now when I say distract, I don't mean take them on a tangent that's not relevant to what you're saying, but maybe you ask them a question, maybe you tell them a story, maybe you show them a video or ask them to read something. So there are lots of things that you can do that will help get the attention off you for just a little bit so that you can then focus on what works for you or take that deep breath that'll help calm you down. All of these are very useful techniques.

**中文翻译:**
是的。我们谈到了通过视觉化脱敏的方法。另一件我们可以做的事情是分散注意力（distract）。
(00:23:30):
我指导过谷歌的一位资深领导者，他在众人面前会非常紧张。我们做的是分散观众的注意力。所以他每次演示都会以这句话开始：“早上好，让我们看一段视频。” 他会展示一段 30 秒的视频，主题与会议要讨论的内容相关。视频结束后，他会引导大家讨论视频的内容，然后慢慢切入他的主题。这样，他就从一个演示者变成了一个引导者，或者一个正在与观众对话的人。这让他感觉好多了。
(00:24:05):
所以我们所有人都可以做一些分散观众注意力的事情。当我提到分散注意力时，我不是指带他们去聊与主题无关的题外话，而是你可以问他们一个问题，讲一个故事，给他们看一段视频，或者让他们读点东西。有很多事情可以做，能让注意力暂时离开你，这样你就可以专注于对自己有效的方法，或者深呼吸来让自己冷静下来。这些都是非常实用的技巧。

---

### [00:24:35] [Lenny Rachitsky]

**English:**
Yeah, it's interesting once you start talking, it's okay usually. It's the beginning part that you need [inaudible 00:24:40].

**中文翻译:**
是的，有趣的是，一旦你开始说话，通常就没问题了。你需要的是开始的那部分。

---

### [00:24:40] [Matt Abrahams]

**English:**
Yeah, most people are most nervous one minute before speaking and the first minute of speaking. And if you can find ways to get yourself through that, then it becomes much easier for most people. There are some people who that's not true for, but for most people that's the way it works.

**中文翻译:**
是的，大多数人在演讲前一分钟和演讲的第一分钟最紧张。如果你能找到方法度过那个阶段，那么对大多数人来说就会变得容易得多。虽然对某些人来说并非如此，但对大多数人来说确实是这样。

---

### [00:24:54] [Lenny Rachitsky]

**English:**
Awesome. Okay, next technique that actually another guest mentioned, and we spent a bunch of time on this, a guest named Johnny Miller, which is a breathing technique. And just to give a little context from what he taught us is that 80% of our neurons go from our body to our brain versus 20% is our brain telling our body what to feel. And so this research shows that what our body's feeling is what our brain's going to think. So if our body's acting nervous, we're going to think, oh, we're nervous. And if you change the state of your body, your mind feels different.

**中文翻译:**
太棒了。好的，下一个技巧实际上是另一位嘉宾提到的，我们花了很多时间讨论这个，那位嘉宾叫 Johnny Miller，就是呼吸技巧。简单介绍一下他教给我们的背景：我们 80% 的神经元是从身体传向大脑的，而只有 20% 是大脑告诉身体该感受什么。所以这项研究表明，我们身体的感受决定了大脑的想法。如果我们的身体表现得紧张，我们就会想：“噢，我很紧张。” 如果你改变身体的状态，你的心态也会随之改变。

---

### [00:25:23] [Matt Abrahams]

**English:**
I love this stuff. This research, embodied cognition is what it's called, is fascinating to me. I'll share one of my most favorite studies in this. There was a researcher at Duke, I think it was Duke, who... The only experimental variation that he did is he had people hold something that was cold in their hand, like an iced coffee versus a warm coffee. And then he asked the participants to make ratings of people. And if you were holding something cold, you saw the person as a colder person, as more aloof and more distant, and if you were holding something warm, you saw them as more collaborative and embracing. I find this stuff fascinating. What our body feels, our minds think.

**中文翻译:**
我喜欢这些东西。这项研究被称为“具身认知”（embodied cognition），对我来说非常迷人。我分享一个我最喜欢的研究。杜克大学（我想是杜克大学）的一位研究人员做了一个实验，唯一的变量是让参与者手里拿着冷的东西（比如冰咖啡）或热的东西（热咖啡）。然后他让参与者对人进行评价。如果你手里拿着冷的东西，你就会觉得那个人更冷漠、更疏远；如果你手里拿着热的东西，你就会觉得他们更具协作精神、更亲切。我觉得这太神奇了。身体的感受决定了头脑的想法。

---

### [00:26:03] [Lenny Rachitsky]

**English:**
Awesome. So along those lines, there's a technique that you recommend that he recommended, but I think it's a great reminder of the double exhale where you breathe in and then you exhale twice as long. Can you talk about that and tell people about it?

**中文翻译:**
太棒了。沿着这个思路，你推荐了一个他也推荐过的技巧，但我认为这是一个很好的提醒，就是“双倍呼气”（double exhale），即吸气，然后呼气时间是吸气的两倍。你能谈谈这个并告诉大家吗？

---

### [00:26:13] [Matt Abrahams]

**English:**
Yeah. Breathing is very helpful in managing so many of our anxiety symptoms. It slows down the heart rate, makes our voice sound more normal because when we get nervous, we breathe shallow and that changes... Our voice is a wind instrument, it changes the way we sound, can reduce some of the shakiness. So deep belly breathing, the kind you do if you've ever done yoga or tai chi, qigong, really important to do and there are a whole bunch of variations on it. The one you're talking about is the double inhalation where you're taking an inhale in until you feel completely full and then you sneak in a little extra air and then you take a long exhale. People call it box breathing and other types of breathing.
(00:26:54):
The bottom line is this, what's critical to the relaxation response is the exhale. Lots of ways to inhale, lots of ways to exhale. You want your exhale to be longer than the inhale. The magic of the relaxation happens during the exhale. So I have a rule of thumb, I jokingly call it a rule of lung. You want your exhale to be twice as long as your inhale. So if you take a three count in, even if you sneak in a little extra air as we were talking about, take a six count out. And it is that way that you will feel... Not only will your body physiologically feel less stress, you'll be more focused in a present moment and not catastrophizing about all the things that might happen in the future.

**中文翻译:**
是的。呼吸在管理我们的许多焦虑症状方面非常有帮助。它能减慢心率，让我们的声音听起来更正常，因为当我们紧张时，呼吸会变浅，这会改变……我们的声音就像管乐器，呼吸浅会改变音色。呼吸还能减少颤抖。所以深腹式呼吸（就像你在瑜伽、太极或气功中做的那样）非常重要，它有很多变体。你提到的那种是双重吸气：吸气直到感到完全充满，然后偷偷再吸一点点气，接着进行长长的呼气。人们称之为“箱式呼吸”或其他类型的呼吸。
(00:26:54):
归根结底，产生放松反应的关键在于呼气。吸气和呼气有很多种方式，但你希望呼气比吸气长。放松的魔力发生在呼气过程中。所以我有一个经验法则，我开玩笑地称之为“肺部法则”：你希望呼气的时间是吸气的两倍。如果你吸气数三下（即使像我们说的偷偷多吸一点），呼气就数六下。通过这种方式，你不仅会在生理上感到压力减轻，还会更专注于当下，而不是对未来可能发生的所有事情产生灾难性联想。

---

### [00:27:36] [Lenny Rachitsky]

**English:**
Great. Yeah, so it's like another example of this sounds so trivial and why would breathing differently do have any impact on my nervousness? But one, there's all this research that shows that it does, and two, if you try it, and this is another one I use, is it actually works very quickly and you do it a few times and like, wow, I feel really different.

**中文翻译:**
太棒了。是的，所以这是另一个听起来很琐碎的例子，为什么不同的呼吸方式会对我的紧张产生影响？但第一，所有的研究都表明它确实有效；第二，如果你尝试一下（这也是我用的一个方法），它确实起效非常快，做几次之后，哇，感觉真的不一样了。

---

### [00:27:54] [Matt Abrahams]

**English:**
Absolutely.

**中文翻译:**
绝对的。

---

### [00:27:55] [Lenny Rachitsky]

**English:**
It is interesting you put these together. From the way I've seen it, these are two different techniques, but I've never tried them together. One is... I think Huberman is big on this one. All his clips are always talking about this. One of you inhale fully and then you inhale a little bit more and there's some capillaries or something in your lungs that fill up that-

**中文翻译:**
有趣的是你把这些结合在一起。据我所知，这是两种不同的技巧，但我从未尝试过将它们结合。一个是——我觉得 Huberman（斯坦福教授，知名播客主）非常推崇这个，他的所有视频片段都在谈论这个：完全吸气，然后再多吸一点，肺部的一些毛细血管或什么东西会充满——

---

### [00:28:12] [Matt Abrahams]

**English:**
[inaudible 00:28:12]. Yeah.

**中文翻译:**
（听不清）。是的。

---

### [00:28:13] [Lenny Rachitsky]

**English:**
And then there's the 4, 4, 8 is the way this other guest shared is like breathe in four seconds, hold it four seconds, breathe out for eight seconds. But I'm going to try both. Wow. That's going to double up my calmness.

**中文翻译:**
然后还有 4-4-8 呼吸法，这是另一位嘉宾分享的：吸气四秒，屏息四秒，呼气八秒。但我打算两个都试试。哇。那会让我的冷静程度翻倍。

---

### [00:28:27] [Matt Abrahams]

**English:**
You'll be so mellow, nothing will bother you.

**中文翻译:**
你会变得非常从容，没有什么能困扰你。

---

### [00:28:29] [Lenny Rachitsky]

**English:**
So mellow. Okay. Are there any other techniques that you love that you find people find really helpful in calming their anxiety?

**中文翻译:**
非常从容。好的。还有其他你喜欢的、觉得对缓解焦虑非常有帮助的技巧吗？

---

### [00:28:39] [Matt Abrahams]

**English:**
Well, so the first book had 50 techniques and not all 50 techniques work for everybody. One that I personally think is a lot of fun is getting present oriented because when I'm in the present, by definition I'm not worried about the future. And many of our anxiety comes from our fear of a potential negative future outcome like, "I'm not going to achieve my goal." So if I can do anything to be in the present moment, that helps me out a lot.
(00:29:02):
Something I do as part of my personal anxiety management plan is I say tongue twisters. Tongue twisters for me are a great way to get present oriented. You can't say it right if you don't say the tongue twister if you're not focused on the present moment. And it also warms up your voice. A lot of nervous speakers get so inside their head that they don't warm up their voice. And we all know if you've ever done any exercise or competed in any sports, you should warm up first. We have this mistaken notion that we can go from silence to brilliance without warming up. And I like saying tongue twisters out loud to get present oriented and to warm up my voice. So that's one that I often recommend. People think it's silly, but I have people who are like, that really works. It really helps me to get centered and to warm up. And so I like that one a lot.

**中文翻译:**
嗯，第一本书里有 50 个技巧，并不是所有 50 个技巧都适合每个人。我个人觉得很有趣的一个是“关注当下”（getting present oriented），因为当我处于当下时，从定义上讲，我就不会担心未来。我们的许多焦虑源于对未来潜在负面结果的恐惧，比如“我无法实现目标”。所以，如果我能做任何事情让自己回到当下，那对我帮助很大。
(00:29:02):
我在个人焦虑管理计划中做的一件事就是说绕口令（tongue twisters）。对我来说，绕口令是关注当下的绝佳方式。如果你不专注于当下，你就无法正确地说出绕口令。它还能暖嗓。许多紧张的演讲者太过于沉浸在自己的思绪中，以至于忘记了暖嗓。我们都知道，如果你做任何运动或参加体育比赛，都应该先热身。我们有一种错误的观念，认为我们可以不经过热身就从沉默直接跳跃到精彩表现。我喜欢大声说绕口令来关注当下并暖嗓。这是我经常推荐的一个方法。人们觉得这很傻，但我遇到过一些人说这真的很管用，能帮我找回重心并完成热身。所以我非常喜欢这个方法。

---

### [00:29:46] [Lenny Rachitsky]

**English:**
Well, let's share a couple of tongue twisters. What are some recommendations?

**中文翻译:**
那我们来分享几个绕口令。有什么推荐吗？

---

### [00:29:50] [Matt Abrahams]

**English:**
I will only share my tongue twister, I say Lenny, if you promise to say it after me.

**中文翻译:**
Lenny，我只分享我的绕口令，如果你答应跟我读的话。

---

### [00:29:53] [Lenny Rachitsky]

**English:**
Absolutely. I'm so ready.

**中文翻译:**
没问题。我准备好了。

---

### [00:29:55] [Matt Abrahams]

**English:**
This is my favorite tongue twister. It takes five seconds to say, it's three phrases long. And if you say it wrong, you say a naughty word. So I'm going to be listening as for all your listeners. So are you prepared? So it goes as follows, I slit a sheet.

**中文翻译:**
这是我最喜欢的绕口令。说出来只需要五秒钟，有三个短句。如果你说错了，你就会说出一个脏话。所以我会仔细听，听众们也会听。准备好了吗？内容如下：I slit a sheet.

---

### [00:30:10] [Lenny Rachitsky]

**English:**
I slit a sheet.

**中文翻译:**
I slit a sheet.

---

### [00:30:11] [Matt Abrahams]

**English:**
A sheet I slit

**中文翻译:**
A sheet I slit.

---

### [00:30:13] [Lenny Rachitsky]

**English:**
A sheet I slit.

**中文翻译:**
A sheet I slit.

---

### [00:30:14] [Matt Abrahams]

**English:**
And on that slitted sheet I sit.

**中文翻译:**
And on that slitted sheet I sit.

---

### [00:30:18] [Lenny Rachitsky]

**English:**
And on that slitted sheet I sit.

**中文翻译:**
And on that slitted sheet I sit.

---

### [00:30:20] [Matt Abrahams]

**English:**
Very good. You didn't say that naughty word. I'm sure you can imagine what it would've been.

**中文翻译:**
非常好。你没说那个脏话。我相信你能想象出那会是什么词。

---

### [00:30:25] [Lenny Rachitsky]

**English:**
A lot of danger, a lot of [inaudible 00:30:26].

**中文翻译:**
风险很大，很多（听不清）。

---

### [00:30:26] [Matt Abrahams]

**English:**
A lot of danger. But in that moment you weren't thinking about, what's the next question I'm going to ask Matt? Or how much longer do we have in the podcast? No, you were simply focused on what we were saying and trying to say it without saying a naughty word. So that's that [inaudible 00:30:39]-

**中文翻译:**
风险很大。但在那一刻，你并没有在想：我要问 Matt 的下一个问题是什么？或者我们的播客还有多久结束？不，你只是专注于我们在说的话，并努力不带脏话地把它说出来。所以那就是（听不清）——

---

### [00:30:38] [Lenny Rachitsky]

**English:**
And not have to censor this podcast.

**中文翻译:**
而且不用给这个播客打码。

---

### [00:30:42] [Matt Abrahams]

**English:**
I've only had to bleep one guest in all my years of doing this.

**中文翻译:**
在我做这个的这么多年里，我只给一位嘉宾打过消音。

---

### [00:30:46] [Lenny Rachitsky]

**English:**
Okay, cool. We're going to link to that. Is there any other ones you want to share before we move on to getting better at speaking on the spot?

**中文翻译:**
好的，酷。我们会链接到那个。在我们转向如何更好地即兴演讲之前，你还有什么想分享的吗？

---

### [00:30:52] [Matt Abrahams]

**English:**
Well, the last one I'll say is, and this one is another one that falls in the kind of funny category, but there's research that says that when you swear, curse, it actually helps you reduce anxiety. When you curse, you release a flood of neurochemicals that blunt out the neurochemicals associated with anxiety, cortisol being a big one. So you get a big dopamine hit, for example, serotonin when you swear. So I'm not saying get up on stage and drop an F-bomb, but my students love this. I mean, it's like, "Matt's giving me permission to swear." And no, that's not what I'm doing, but it's an interesting technique that seems to help some people is to curse not necessarily in front of people, but that can help. And it also has an analgesic effect. It actually reduces pain as well.

**中文翻译:**
嗯，我要说的最后一个是，这个也是属于那种有点搞笑的类别，但有研究表明，当你咒骂、说脏话时，它实际上能帮你减轻焦虑。当你咒骂时，你会释放大量的神经化学物质，从而抵消与焦虑相关的神经化学物质（皮质醇是其中主要的一种）。例如，当你咒骂时，你会获得大量的多巴胺和血清素。我不是说让你上台大爆粗口，但我的学生们很喜欢这个。他们会想：“Matt 允许我骂人了。” 不，我不是那个意思，但这是一个有趣的技巧，似乎对某些人有帮助——不一定要在人前咒骂，但咒骂确实有帮助。它还有镇痛作用，实际上也能减轻疼痛。

---

### [00:31:44] [Lenny Rachitsky]

**English:**
That's interesting. I could see during birth women screaming curse words.

**中文翻译:**
这很有趣。我能想象在分娩过程中，女性大声尖叫咒骂。

---

### [00:31:48] [Matt Abrahams]

**English:**
Yeah. Well, I'm not going to say what I heard when my kids were born, but...

**中文翻译:**
是的。嗯，我不会说我孩子出生时我听到了什么，但是……

---

### [00:31:54] [Lenny Rachitsky]

**English:**
But again, this could double up with the tongue twister where you just go for it and say-

**中文翻译:**
但同样，这可以和绕口令结合起来，你就直接豁出去说——

---

### [00:31:58] [Matt Abrahams]

**English:**
Yeah, every tongue twister has to start with Nantucket and then we're good.

**中文翻译:**
是的，每个绕口令都必须以 Nantucket 开头，然后我们就没问题了。

---

### [00:32:05] [Lenny Rachitsky]

**English:**
This episode is brought to you by Coda, and I mean that literally. I use Coda every day to help me plan each episode of this very podcast. It's where I keep my content calendar, my guest research, and also the questions that I plan to ask each guest. Also, during the recording itself, I have a Coda page up to remind myself what I want to talk about. Coda is an all-in-one platform that combines the best of documents, spreadsheets and apps to help you and your team get more done. Now is the perfect time to get started with Coda, especially its extensive planning capabilities. With Coda, you can stay aligned and ship faster by managing your planning cycles in one location. You can set and measure OKRs with full visibility across teams and stakeholders. You can map dependencies, create progress visualizations, and identify risk areas. Plus you can access hundreds of pressure-tested templates for everything from roadmap strategy to final decision-making to PRDs.
(00:33:01):
If you want a platform that empowers your team to strategize, plan and track goals together, you can get started with Coda today for free. And if you want to see for yourself why product teams at high-growth companies like Pinterest, Figma and Qualtrics run on Coda, take advantage of the special limited-time offer just for startups. Head over to coda.io/lenny to sign up and get $1,000 in credit. That's C-O-D-A.io/lenny to sign up and get $1,000 in credit. Coda.io/lenny.

**中文翻译:**
本集节目由 Coda 为你呈现，我是认真的。我每天都使用 Coda 来帮助我规划这个播客的每一集。我在那里存放我的内容日历、嘉宾研究，以及我计划问每位嘉宾的问题。此外，在录制过程中，我会打开一个 Coda 页面来提醒自己想谈论的内容。Coda 是一个全能平台，它结合了文档、电子表格和应用程序的优点，帮助你和你的团队完成更多工作。现在是开始使用 Coda 的最佳时机，尤其是它强大的规划功能。通过 Coda，你可以在一个地方管理规划周期，从而保持步调一致并加快交付速度。你可以设定并衡量 OKR，让团队和利益相关者拥有完全的可见性。你可以绘制依赖关系、创建进度可视化并识别风险区域。此外，你还可以访问数百个经过压力测试的模板，涵盖从路线图策略到最终决策再到 PRD 的所有内容。
(00:33:01):
如果你想要一个能让你的团队共同制定策略、规划和跟踪目标的平台，你今天就可以免费开始使用 Coda。如果你想亲眼看看为什么 Pinterest、Figma 和 Qualtrics 等高增长公司的产品团队都在使用 Coda，请利用专门针对初创公司的限时优惠。前往 coda.io/lenny 注册即可获得 1,000 美元的抵用金。即 C-O-D-A.io/lenny 注册并获得 1,000 美元抵用金。Coda.io/lenny。

---

### [00:33:34] [Lenny Rachitsky]

**English:**
Okay, let's shift to talking about talking on the spot.

**中文翻译:**
好的，让我们转向谈论即兴演讲。

---

### [00:33:39] [Matt Abrahams]

**English:**
I see you said shift very carefully. I appreciate that.

**中文翻译:**
我看你用“转向”（shift）这个词用得很小心。我很欣赏。

---

### [00:33:44] [Lenny Rachitsky]

**English:**
Now we're going to be so, so careful, I don't want this podcast flagged and for adults only. Okay, shift to a new topic. You have a whole book about how to get better speaking on the spot. And I think why this is important is again, what I said at the beginning that I think most of our "public speaking" is not planned public speaking. There's people asking for feedback in a meeting, people wanting you to give a toast, Q&A as we talked about. So what I want to do is you have advice for broadly getting better at these things and then you have advice for very specifically how to get better at giving better toast, doing better Q&A, getting better at small talk and things like that. So I want to start with the broad advice and then get into each of these. That sound good?

**中文翻译:**
现在我们要非常、非常小心，我不想让这个播客被标记为成人节目。好的，转向一个新话题。你有一整本书是关于如何提高即兴演讲能力的。我认为这之所以重要，正如我开头所说的，我们大多数的“公众演讲”并不是有计划的公众演讲。比如在会议中有人要求你提供反馈，有人想让你祝酒，或者像我们谈到的问答环节。所以我想做的是，你先给出关于如何广泛提高这些能力的建议，然后再针对如何更好地祝酒、进行问答、闲聊等具体场景给出建议。我想先从宽泛的建议开始，然后再深入到每一个具体场景。听起来怎么样？

---

### [00:34:27] [Matt Abrahams]

**English:**
Absolutely.

**中文翻译:**
没问题。

---

### [00:34:28] [Lenny Rachitsky]

**English:**
How about you share your favorite techniques for broadly getting better at speaking on the spot, and then we'll see where that goes?

**中文翻译:**
你愿意分享一下你最喜欢的、能广泛提高即兴演讲能力的技巧吗？然后我们再看接下来的发展。

---

### [00:34:37] [Matt Abrahams]

**English:**
Sure. So the first thing in helping yourself feel better, speaking spontaneously, which is the vast majority of our communication, the plan presenting, the practiced pitch, the meeting with agenda pale in comparison to the times that we are spontaneously speaking. And the first thing that is important for everybody to know is we can all get better at it. That's the fundamental bottom line. Many of us feel like we're either born with the gift of gab or we're not. And so the first thing we have to realize is we can get better at it.
(00:35:08):
The second big point to make is you actually have to prepare to be spontaneous. And that's counterintuitive, but it is through preparation that we get better at it. And if you think about it, if you think about an athlete, when an athlete is doing their sport, they are being spontaneous, they are responding to the conditions that present themselves to them. What helps them do well is all the preparation and practice that they've done. So there are lots of analogs to this, but when we think about it in of communication, it seems foreign, but when you think about it in athletics or jazz music, it's like of course you would prepare and practice. Those are the two big underlying principles to helping people get better.
(00:35:48):
The next level has to do with we have to attack both mindset and approach and the actual messaging itself. The only way I have found to help people get better at this is to look at how we approach it, our mindset, and then how we actually craft the messages through structure and focus that help us be better. So that's the gradual process from the broadest level about how we have to go about making this better for ourselves.

**中文翻译:**
当然。首先，为了让自己在即兴演讲时感觉更好——这是我们绝大多数的沟通形式，有计划的演示、练习过的推销、有议程的会议，与我们即兴发言的次数相比都相形见绌。每个人都需要知道的第一点是：我们都能做得更好。这是最基本的底线。我们中的许多人觉得要么天生口才好，要么天生不行。所以我们首先要意识到，我们可以通过练习变得更好。
(00:35:08):
第二个重点是：你实际上必须为即兴发挥做准备。这听起来有悖常理，但正是通过准备，我们才能做得更好。如果你想一想，当运动员在进行比赛时，他们是在即兴发挥，是在对出现的各种情况做出反应。而让他们表现出色的是他们之前所做的所有准备和练习。这有很多类似的例子，但在沟通领域，这似乎很陌生；但当你想到体育或爵士乐时，你就会觉得准备和练习是理所当然的。这是帮助人们提高的两大基本原则。
(00:35:48):
下一个层次涉及我们必须同时攻克心态、方法以及实际的信息传递。我发现提高这一能力的唯一方法是审视我们的处理方式（心态），然后研究如何通过结构和重点来实际构建信息，从而帮助我们表现得更好。这就是从最广泛的层面开始，逐步改善我们沟通能力的渐进过程。

---

### [00:36:14] [Lenny Rachitsky]

**English:**
Maybe let's dig into the structure.

**中文翻译:**
也许我们来深入探讨一下结构。

---

### [00:36:17] [Matt Abrahams]

**English:**
Sure.

**中文翻译:**
好的。

---

### [00:36:17] [Lenny Rachitsky]

**English:**
What is your advice for how to think about structuring if you're on the spot, like, "Oh, shit, how do I share something smart [inaudible 00:36:22]?"

**中文翻译:**
对于如何思考结构，你有什么建议？如果你在现场，心想：“噢，该死，我该怎么聪明地分享一些东西（听不清）？”

---

### [00:36:22] [Matt Abrahams]

**English:**
See, the bad word came out, so you're ready for my tongue twister. So structure is critical. In spontaneous speaking, most of us, because we feel the intense pressure, the anxiety we just talked about, we just spew out information, we list and itemize information. We take our audience on the journey of our own discovery of what we want to say as we're saying it, and our brains are not wired for lists of information. In fact, Lenny, how many items do you need to buy from the grocery store before you actually have to physically write it down? For me it's four. Anything over four, I'm going to forget something. Our brains aren't wired for lists, right?

**中文翻译:**
瞧，脏话出来了，看来你已经为我的绕口令做好准备了。结构至关重要。在即兴演讲中，我们中的大多数人因为感受到巨大的压力（即我们刚才谈到的焦虑），往往只是在倾倒信息，罗列和逐条陈述信息。我们在说话的同时，带着观众经历我们自己探索想说什么的过程，而我们的大脑并不适合处理信息列表。事实上，Lenny，你去超市买东西，在必须动笔写下来之前，你能记住多少件？对我来说是四件。超过四件，我就会漏掉东西。我们的大脑不适合处理列表，对吧？

---

### [00:37:03] [Lenny Rachitsky]

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:37:03] [Matt Abrahams]

**English:**
And so-

**中文翻译:**
所以——

---

### [00:37:04] [Lenny Rachitsky]

**English:**
I text myself.

**中文翻译:**
我会发短信给自己。

---

### [00:37:05] [Matt Abrahams]

**English:**
Yeah, right, exactly. Yeah, no, I'm old school. I actually put it on a piece of paper, but the point is that we're not wired that way. Our brains are actually wired for story, for connection, a logical connection of ideas. So it's about connecting those pieces together. So a structure is nothing more than a beginning, a middle, and an end. A package of information. The structure that almost everybody listening in is familiar with is one that comes from the world of advertising. Most advertisements are set up as problem, solution, benefit. There's some problem in the world, here's how we solve it with our product or service, and here's how you benefit from it. That's a structure. It's a logical beginning, middle, and end. These items have a connection. So by finding a structure that you can rely on when put on the spot, it halves your burden.
(00:37:54):
When you're put on the spot, you have to think about what to say and how to say it. The structure tells you how to say it, and then you just have to think about what to put into it. So it's like having a recipe. If I have a recipe and I have good ingredients, I can cook a good meal. So there are lots of structures.
(00:38:10):
The whole second part of the book Think Faster, Talk Smarter is specific structures for specific situations, introducing yourself, making an apology, giving feedback. And I'm not saying every time you give an apology or give feedback that you have to follow these structures. It just gives you a place to go when you're in that moment where you're like, "Where do I go? How do I start?"

**中文翻译:**
是的，没错。我比较传统，我会写在纸上。但重点是，我们的大脑不是那样运作的。我们的大脑实际上更适合处理故事、连接以及想法之间的逻辑联系。所以关键在于将这些碎片连接起来。结构无非就是一个开头、一个中间和一个结尾。一个信息的包装。几乎所有听众都熟悉的一种结构来自广告界。大多数广告的设定都是：问题、解决方案、收益（Problem, Solution, Benefit）。世界上存在某个问题，这是我们如何通过产品或服务解决它的，这是你如何从中受益的。这就是一个结构。它有一个逻辑上的开头、中间和结尾。这些项之间是有联系的。所以，通过找到一个在即兴场合可以依靠的结构，你的负担就减轻了一半。
(00:37:54):
当你被推到聚光灯下时，你必须思考说什么以及怎么说。结构告诉你怎么说，然后你只需要思考往里填什么内容。这就像有一个食谱，如果我有食谱且有好的食材，我就能做出一顿美餐。所以有很多种结构。
(00:38:10):
《Think Faster, Talk Smarter》这本书的整个第二部分都是针对特定情况的特定结构：自我介绍、道歉、给出反馈。我并不是说你每次道歉或给出反馈都必须遵循这些结构，它只是在你感到“我该怎么办？我该从哪开始？”的时刻，给你一个可以依靠的支点。

---

### [00:38:33] [Lenny Rachitsky]

**English:**
Cool. So we're going to talk about those examples. One of the structures that I liked that I wrote down is called prep, which is make your point, give a reason for making that point, give an example. And then what's the last one point again?

**中文翻译:**
酷。我们要讨论那些例子。我喜欢的一个结构叫 PREP，即提出观点（Point）、给出理由（Reason）、给出一个例子（Example）。最后一个是再次强调观点（Point）吗？

---

### [00:38:47] [Matt Abrahams]

**English:**
Yeah, restate your point. Review it.

**中文翻译:**
是的，重申你的观点。回顾它。

---

### [00:38:48] [Lenny Rachitsky]

**English:**
Restate your point. That feels like something that say in product teams can come up a lot is just like, here's what I think, here's why. Here's an example and then let me just remind you again what the point I'm making.

**中文翻译:**
重申观点。这感觉像是产品团队中经常会出现的情况，比如：这就是我的想法，这就是原因。这是一个例子，然后让我再次提醒你我提出的观点。

---

### [00:38:57] [Matt Abrahams]

**English:**
That's right. Yes. I love prep and the structure I really like is a three-question structure: What? So what? Now what? And people on product teams I think could benefit so much from this. What is your product, your service, your offering, your update, your feedback? It's the what of why you're speaking. The so what is why is this important and relevant to the people you're talking to or to your company or to prospective clients? And then the now what is what comes next. So on a product team, if you're describing a feature, here's what the feature is, here's why it's important, and here's what we're doing about it. If you're giving an update in an update meeting, a standup that you're having, here's what I'm working on, here's why it's important, here's what I'm doing next.
(00:39:41):
By packaging the information up in what, so what, now what, it becomes much more digestible, much more memorable. Just like prep. Prep works really well for a point you're making. What, so what, now what works really well for a broader presentation, update, feedback session that you're giving. So having a whole series of these tools in your toolkit can really make a difference.

**中文翻译:**
没错。是的。我非常喜欢 PREP，但我真正喜欢的结构是一个三问结构：是什么？（What?）那又怎样？（So what?）现在该怎么办？（Now what?）我认为产品团队的人可以从中受益匪浅。“是什么”是你的产品、服务、提议、更新或反馈，也就是你发言的主题。“那又怎样”是为什么这对于你的听众、公司或潜在客户是重要且相关的？“现在该怎么办”是接下来的步骤。在产品团队中，如果你在描述一个功能：这是什么功能，为什么它很重要，以及我们正在为此做什么。如果你在站会或更新会议上做汇报：这是我正在做的工作，为什么它很重要，以及我接下来的计划。
(00:39:41):
通过将信息包装成“是什么、那又怎样、现在怎么办”，它会变得更容易消化、更容易被记住。就像 PREP 一样。PREP 非常适合阐述一个观点，而“是什么、那又怎样、现在怎么办”则非常适合更广泛的演示、更新或反馈环节。在你的工具箱里准备一系列这样的工具，真的会大不相同。

---

### [00:40:05] [Lenny Rachitsky]

**English:**
So we've talked about three structures so far. What, so what, now what; prep, which is make the point, give a reason example, and then restate the point; and then problem, solution benefit. So people listening to this it's like, "Oh, amazing, all these structures are great." Do you have any advice on how to remember these? You're like, "Oh, Matt, what do you think of this design?" Like, "Oh, shit, which one should I go with?"

**中文翻译:**
到目前为止我们已经讨论了三个结构：“是什么/那又怎样/现在怎么办”；PREP，即提出观点、给出理由、例子，然后重申观点；还有“问题/解决方案/收益”。听这个的人可能会想：“噢，太棒了，所有这些结构都很棒。” 你对于如何记住这些有什么建议吗？比如有人问：“噢，Matt，你觉得这个设计怎么样？” 然后你心想：“噢，该死，我该用哪一个？”

---

### [00:40:28] [Matt Abrahams]

**English:**
I try to give each structure a catchy name. What, so what, now what rolls off the tongue. There's a structure in the book for giving feedback called 4Is for Apologizing AAA. So part of it is just coming up with a mnemonic that works for you and you can name them whatever you want, but really the way to get familiar with them and to have them at the ready is to use them.
(00:40:48):
When I coach people on what, so what, now what, I encourage them at the end of a podcast they listen to or something they read, take a moment and say, "What was it about? Why is it important to me and what can I do with that information?" And if you do that, not only do you get better and more comfortable deploying that structure, but you also remember the material better because there's a whole bunch of research that says when we interrogate the material that we listen to or read, we digest it and remember it more. So in 30 seconds you're really helping yourself at least in two ways by getting the structure down and remembering more. So you have to put it into practice.
(00:41:24):
The other way to do it in which we do a lot in my classroom is we have people dissect communication. So you listen to somebody or you see it and you say, what structure did they use? So it's about awareness building and then actually getting the reps. The only way you get better at communication, spontaneous or planned, is the way you get better at anything. Repetition, reflection, and feedback. You got to practice, you got to think about what worked or what didn't, and then you have to get feedback from others. We are not always the best judges of our communication. And in so doing, repetition, reflection and feedback takes your communication to the next level.

**中文翻译:**
我试着给每个结构起一个朗朗上口的名字。“是什么/那又怎样/现在怎么办”读起来很顺口。书里还有一个给反馈的结构叫 4Is，道歉的结构叫 AAA。所以，一部分工作是想出一个适合你的助记符（mnemonic），你可以随意命名。但真正熟悉并随时准备使用它们的方法是去使用它们。
(00:40:48):
当我指导人们使用“是什么/那又怎样/现在怎么办”时，我鼓励他们在听完播客或读完东西后，花点时间说：“这是关于什么的？为什么它对我重要？我能用这些信息做什么？” 如果你这样做，不仅能更熟练、更自在地运用这个结构，还能更好地记住内容。因为有大量研究表明，当我们对听过或读过的内容进行审视（interrogate）时，我们会消化得更好，记得更牢。所以，在 30 秒内，你通过掌握结构和增强记忆，至少在两个方面帮助了自己。所以你必须付诸实践。
(00:41:24):
另一种方法（我们在课堂上经常做）是让人们剖析沟通。你听别人说话或看视频，然后问：他们用了什么结构？这就是建立意识，然后进行实际练习。提高沟通能力（无论是即兴的还是计划好的）的唯一方法，就像提高任何技能一样：重复、反思和反馈。你必须练习，必须思考哪些有效、哪些无效，然后必须从他人那里获得反馈。我们并不总是自己沟通表现的最佳评判者。通过重复、反思和反馈，你的沟通能力将提升到一个新的水平。

---

### [00:42:00] [Lenny Rachitsky]

**English:**
That's a lot of work, Matt. That's a lot of work.

**中文翻译:**
那是很多工作，Matt。那是很多工作。

---

### [00:42:02] [Matt Abrahams]

**English:**
It is work. There is no shortcut.

**中文翻译:**
确实是工作。没有捷径。

---

### [00:42:04] [Lenny Rachitsky]

**English:**
Got you.

**中文翻译:**
明白了。

---

### [00:42:05] [Matt Abrahams]

**English:**
But that's true with most things in life that are really important. There's no shortcut.

**中文翻译:**
但生活中大多数真正重要的事情都是如此。没有捷径。

---

### [00:42:09] [Lenny Rachitsky]

**English:**
That's right. That's right. As people are thinking about this and listening to this, there's your course, obviously that you teach at Stanford and only Stanford students can take that. There's your book obviously. Is there anything else? If there's nothing, that's totally fine, that you point people to to actually practice these outside of the workplace? Are there courses that anyone can take that you recommend? Anything else you can point people to?

**中文翻译:**
没错。没错。当人们思考这些并听这些内容时，显然有你在斯坦福教的课程，但只有斯坦福的学生能上。显然还有你的书。还有别的吗？如果没有也没关系，你会指引人们去哪里在工作之外练习这些？有什么任何人都可以参加的课程推荐吗？还有什么可以指引大家的吗？

---

### [00:42:31] [Matt Abrahams]

**English:**
Absolutely. There are a lot of resources out there. One, I'm a huge proponent and a former member of Toastmasters. I think Toastmasters is a wonderful organization designed primarily to give you the reps. They do some teaching, but it's really to give you the reps. So I highly recommend Toastmasters.
(00:42:48):
Improvisation is another way to get comfortable with these skills. When people hear improv, they think, "Oh, I got to be funny and it's about performing," and it's not. Improv is really just about being more comfortable, being present, and really focusing on collaborating with others.
(00:43:04):
And then there are courses. You mentioned obviously that people have to be MBA students to take my MBA class, but Stanford and other institutions have continuing studies classes or extension classes that are open to the community. So I, every quarter teach a class that's open to anybody who registers all over the world. It's virtual. I have students this very quarter who take a class on a Monday night Pacific Time, 7:00 PM. I've got somebody in Egypt, I have somebody in China. So there are ways to take advantage of things happening at universities without being an enrolled student. So I would point people to all of those. And then clearly listening to podcasts, reading books, checking out blogs and videos can be really helpful.

**中文翻译:**
当然。有很多资源。第一，我是 Toastmasters（头马国际演讲会）的坚定支持者和前成员。我认为 Toastmasters 是一个很棒的组织，其主要目的是为你提供练习机会。他们也教一些东西，但核心是让你反复练习。所以我强烈推荐 Toastmasters。
(00:42:48):
即兴表演（Improvisation）是另一种熟悉这些技能的方法。当人们听到即兴表演时，会想：“噢，我得搞笑，那是关于表演的。” 其实不然。即兴表演的核心只是让你变得更自在、更专注当下，并真正专注于与他人协作。
(00:43:04):
然后还有一些课程。你提到只有 MBA 学生才能上我的 MBA 课程，但斯坦福和其他机构都有面向社区开放的继续教育课程或进修课程。我每个季度都会教一门面向全球任何注册者开放的课程。它是虚拟的。就在这个季度，我有学生在太平洋时间周一晚上 7 点上课，他们有的在埃及，有的在中国。所以，即使不是在校学生，也有办法利用大学的资源。我会指引人们关注这些。显然，听播客、读书、看博客和视频也很有帮助。

---

### [00:43:44] [Lenny Rachitsky]

**English:**
I think to your point, it's like you can read about this and listen to podcasts all you want, but you're not going to actually get that much better. And with your course, I imagine there's practice you're doing as a part of the course.

**中文翻译:**
我觉得正如你所说的，你可以尽情阅读相关书籍、听播客，但你不会真的变得更好。而在你的课程中，我猜练习是课程的一部分。

---

### [00:43:53] [Matt Abrahams]

**English:**
Everything is applied. The only way to get better at communication is to do communication, to watch communication. And that's why in the books I write, I have this, try this. It's literally put the book down, go do this and then come back because that's how you learn communication. And so yes, any avenue to help you get the reps is going to be helpful.

**中文翻译:**
一切都是应用。提高沟通能力的唯一方法就是进行沟通、观察沟通。这就是为什么在我写的书里，我会有“试一试”环节。它字面意思就是让你放下书，去做这件事，然后再回来，因为这就是学习沟通的方式。所以，是的，任何能帮你获得练习机会的途径都是有帮助的。

---

### [00:44:13] [Lenny Rachitsky]

**English:**
I'll be honest, I did none of the try this. I'm just like, that's too much work. So I think that's why it's important to take something where you have to do it because it's too easy just like, yeah, yeah.

**中文翻译:**
说实话，我一个“试一试”都没做。我只是觉得那工作量太大了。所以我认为参加一些你必须去做的事情是很重要的，因为很容易就想：“对，对。”

---

### [00:44:24] [Matt Abrahams]

**English:**
Yeah. You're not the first person to say that they don't take the time to do that. There are others who say they really appreciate that. And for people such as yourself, at the very end of my book, I have a QR code that takes you to a bunch of videos. So if you don't want to do it yourself, you can actually watch people do it or watch me do it. And so that's at least better than not doing any of it.

**中文翻译:**
是的。你不是第一个说没时间做那些练习的人。也有人说他们非常感激那些练习。对于像你这样的人，在我的书最后，我有一个二维码，可以带你看一系列视频。所以如果你不想自己动手，你至少可以看别人怎么做，或者看我怎么做。这至少比什么都不做要好。

---

### [00:44:46] [Lenny Rachitsky]

**English:**
Awesome. I'll also give a shout-out to Toastmasters. I did Toastmasters for a while and two things there. One is there's a special focus on the spot speaking that's a part of the sequence.

**中文翻译:**
太棒了。我也要为 Toastmasters 点个赞。我参加过一段时间的 Toastmasters，那里有两点。一是那里特别关注即兴演讲，那是流程的一部分。

---

### [00:44:56] [Matt Abrahams]

**English:**
They call them table topics.

**中文翻译:**
他们称之为“即兴题目”（table topics）。

---

### [00:44:58] [Lenny Rachitsky]

**English:**
Table topics, yeah. And that's like a 60-second, someone gets up and just has to talk on something. So it's a big part of that method. Also, I did it for a long time and all I did was I was the counter or the timer. You can do it without having to give any talks for as long as you want. And it's very cheap and they're everywhere. There's a local chapter wherever you are.

**中文翻译:**
即兴题目，是的。那就像是一个 60 秒的环节，有人站起来就必须针对某个话题发言。所以那是该方法的重要组成部分。此外，我参加了很长时间，但我做的只是计票员或计时员。你可以根据自己的意愿，在不发表任何演讲的情况下参与很久。而且费用非常便宜，到处都有。无论你在哪里，都有当地的分会。

---

### [00:45:17] [Matt Abrahams]

**English:**
Absolutely. And many companies sponsor their own Toastmasters groups, so that's great. And they are very good at easing people into it. You're not forced to do anything. And the same is with improv. A good improv teacher never forces anybody to do anything.

**中文翻译:**
绝对的。许多公司赞助自己的 Toastmasters 小组，这很棒。他们非常擅长引导人们进入状态。你不会被强迫做任何事。即兴表演也是如此。一个好的即兴表演老师从不强迫任何人做任何事。

---

### [00:45:31] [Lenny Rachitsky]

**English:**
Great. We went way off-topic, but let's get back to the agenda at hand, which is let's talk about specific situations and advice you have for getting better at these. So maybe we start with small talk and there's one that I love and I find so important and so subtle, which is have comparable levels of disclosure. And the question basically is how do we get better at small talk? And here's one technique.

**中文翻译:**
太好了。我们跑题太远了，让我们回到正题，谈谈具体的情况以及你对提高这些能力的建议。也许我们从闲聊（small talk）开始。我喜欢其中一个技巧，我觉得它非常重要且微妙，那就是“保持对等的披露程度”（comparable levels of disclosure）。问题基本上是：我们如何提高闲聊的能力？这就是其中一个技巧。

---

### [00:45:55] [Matt Abrahams]

**English:**
Yeah, so let me get to that point in a second because that's a more refined point than some general principles. When it comes to small talk, many people dread small talk, they feel really awkward about it. I think small talk has a bad reputation, needs to be rebranded. I think a lot of big things happen in small talk. We learn about ourselves and others. We form and foster relationships. I challenge everybody listening to think about some of their friends, our closest friends. How did you meet them? Probably some component of small talk played a role, especially early in those relationships. So it does good things for us.
(00:46:32):
The best advice I have ever heard for small talk came from a guest on my podcast. Her name's Rachel Greenwald. She's an interesting person. She's an academic and a matchmaker, really fascinating. And her advice was this: Be interested, not interesting. Many of us go into small talk thinking we have to be super interesting. We have to spike the ball over the net every time. When in fact small talk is more like playing the game of Hacky Sack, where it's simply just set the other person up to be successful and get the ball back to you. So if we go in with that mindset, it makes it easier.
(00:47:06):
Now there's some rules that we can follow. One rule is the one that you shared that in small talk there should be a balance of disclosure or depth of disclosure over time. So if you're telling me about the first time your first pet died, and I'm telling you my favorite color is blue, there's a discrepancy in disclosure there. Clearly you've revealed a lot more than I have. And we have this notion of reciprocity that if you share something that is appropriate but is more disclosive, that I should at some point match that level or come close. And if we don't, then it feels very awkward and we feel like we're not jiving in that way.
(00:47:49):
I don't want everybody sitting with a little card that they're checking off, but having that general notion in mind can help. And the trick here is not to be too disclosive too quickly. So if we start small talk and we're talking about the I meeting that we're at, and you immediately jump into the fight you had with your significant other that might lead to divorce, that's a deep and big step that might feel a little inappropriate. But over time, if we continue to disclose, it might be perfectly natural for you to share that. So there's sort of expectations and we just have to be mindful of those.
(00:48:24):
Another thing we need to be mindful of that I think is really important is this distinction between shifting and supporting responses. In a conversation, I can be supportive. That is, you might say, "Hey Matt, I just got back from Costa Rica." I could say, "Oh great, did you spend time in San Jose? Did you get to any of the beaches?" Those are supporting responses. I'm asking you to keep telling me more. A shifting response would be like, "Oh, you went to Costa Rica. I went to Hawaii." And the goal in a good conversation is to have more supporting responses than shifting, but to have some shifting responses. Because if all I do is continually support you, it looks like I don't want to share. I'm not being disclosive at all. So there are these subtle things that we can be aware of to help the conversation go and to breed that intimacy and immediacy that we feel, but it takes a congruence, a balancing of doing that.

**中文翻译:**
好的，让我稍后谈谈那一点，因为那比一些通用原则更精细。说到闲聊，很多人害怕闲聊，觉得很尴尬。我认为闲聊的名声不好，需要重新品牌化。我认为很多大事都发生在闲聊中。我们通过闲聊了解自己和他人，建立并培养关系。我挑战每位听众去想想你们的朋友，尤其是最亲密的朋友。你们是怎么认识的？在关系的早期，闲聊很可能起到了作用。所以闲聊对我们是有好处的。
(00:46:32):
我听过的关于闲聊最好的建议来自我播客的一位嘉宾。她的名字叫 Rachel Greenwald。她是个很有趣的人，既是学者又是媒人，非常迷人。她的建议是：要表现出兴趣（Be interested），而不是表现得有趣（not interesting）。我们中的许多人在闲聊时总觉得必须表现得超级有趣，每次都要把球扣过网。但事实上，闲聊更像是在踢毽子，只是简单地为对方创造成功的机会，然后让球回到你这里。如果我们带着这种心态去闲聊，就会变得容易得多。
(00:47:06):
现在有一些我们可以遵循的规则。其中一条就是你分享的：在闲聊中，随着时间的推移，披露的程度或深度应该保持平衡。如果你在告诉我你第一只宠物去世的经历，而我却在说我最喜欢的颜色是蓝色，那么披露程度就出现了偏差。显然你透露的内容比我多得多。我们有一种互惠（reciprocity）的概念：如果你分享了一些合适但更具披露性的内容，我也应该在某个时刻达到同样的程度或接近它。如果我们不这样做，就会感觉非常尴尬，觉得彼此不合拍。
(00:47:49):
我不想让每个人都拿着小卡片去核对，但记住这个大原则是有帮助的。这里的诀窍是不要太快透露太多。如果我们刚开始闲聊，正在谈论我们参加的会议，你立刻跳到你和伴侣吵架可能导致离婚的话题，那这一步跨得太深太大了，可能会让人觉得不合适。但随着时间的推移，如果我们继续交流，你分享这些可能就变得非常自然。所以这涉及到某种预期，我们只需要留意这些预期。
(00:48:24):
另一件我认为非常重要且需要留意的事情是“转移性回应”（shifting response）和“支持性回应”（supporting response）之间的区别。在对话中，我可以是支持性的。例如，你可能会说：“嘿，Matt，我刚从哥斯达黎加回来。” 我可以说：“噢，太棒了，你在圣何塞待过吗？去过海滩吗？” 这些都是支持性回应，我在要求你继续多讲讲。而转移性回应则是：“噢，你去了哥斯达黎加，我去了夏威夷。” 在一段好的对话中，目标是支持性回应多于转移性回应，但也要有一些转移性回应。因为如果我一直只是支持你，看起来就像我不想分享，我完全没有在披露自己。所以，我们可以意识到这些微妙的事情，以帮助对话进行，并培养我们感受到的那种亲密感和即时感，但这需要一种一致性，一种平衡。

---

### [00:49:16] [Lenny Rachitsky]

**English:**
This is awesome. I feel like everyone needs this class to just like, how do I talk to people? What's the right way to talk?

**中文翻译:**
这太棒了。我觉得每个人都需要这门课，比如：我该如何与人交谈？正确的交谈方式是什么？

---

### [00:49:24] [Matt Abrahams]

**English:**
Well, right. The point that you're bringing up there, Lenny, is we're never taught this stuff and yet we have to do it all the time. And that's why focusing on it I think really matters. And it can really, as you said, superpower, it can be a superpower because so many people don't do this or spend the time getting better at it. We all operate under this notion of... the definition of insanity, doing the same thing over and over again, expecting different results. And that's not good for small talk and other communication situations.

**中文翻译:**
没错。Lenny，你提到的重点是，我们从未被教过这些东西，但我们却必须一直这样做。这就是为什么我认为关注它真的很重要。正如你所说，它可以成为一种超能力，因为很多人不这样做，也不花时间去提高。我们都在一种“疯狂的定义”下运作：一遍又一遍地做同样的事情，却期待不同的结果。这对于闲聊和其他沟通情境来说是不利的。

---

### [00:49:53] [Lenny Rachitsky]

**English:**
I love this balance you just shared of... So the primary piece of advice for small talk is be interested, not interesting, ask person questions, get excited about what they're telling you. There's a classic book, How to Win Friends and Influence People, which is very much about this. Highly recommend it. It's like very old school now, but there's so much good advice there. There's no better sound to someone's ears than their name. So just saying their name, they're like, "Yeah, I love that." And then just smiling. There's all these very simple things that that book shares. It sounds like you recommend and you're fan of that book, and it's something you've read, right?

**中文翻译:**
我很喜欢你刚才分享的这个平衡。所以闲聊的首要建议是表现出兴趣，而不是表现得有趣，向对方提问，对他们告诉你的事情感到兴奋。有一本经典的书《如何赢得朋友并影响他人》（How to Win Friends and Influence People），很大程度上就是关于这个的。强烈推荐。虽然现在看来很老派，但里面有很多好的建议。对一个人来说，没有比听到自己的名字更悦耳的声音了。所以只要叫他们的名字，他们就会觉得：“是的，我喜欢这个。” 还有微笑。那本书分享了所有这些非常简单的事情。听起来你很推荐那本书，也是那本书的粉丝，而且你读过，对吧？

---

### [00:50:27] [Matt Abrahams]

**English:**
I know the book. Some of that stuff has been true for a long time. Some of the stuff. I'm not a big fan of ingratiation and manipulation. I like authenticity and some of the advice in books like that can sound like smile, nod your head. And all of that can sound a little manipulative and inauthentic, but I think some of those principles are important. And if you can in an authentic, true, appropriate way, leverage some of that, I think it would help you.

**中文翻译:**
我知道那本书。其中的一些内容在很长一段时间内都是正确的。我不怎么喜欢讨好和操纵。我喜欢真实性，而那类书中的一些建议听起来像是“微笑、点头”。所有这些听起来可能有点操纵感和不真实，但我认为其中的一些原则是重要的。如果你能以一种真实、诚恳、恰当的方式利用其中的一些原则，我认为会对你有所帮助。

---

### [00:50:57] [Lenny Rachitsky]

**English:**
Yeah, somebody once shared a story with their kid... Then they're 13. They read that book and it just effed them up for a while because they just started putting these into practice way too young.

**中文翻译:**
是的，曾经有人分享过一个关于他们孩子的故事。当时他们 13 岁。他们读了那本书，结果那本书把他们搞砸了一段时间，因为他们开始在太小的年纪就把这些付诸实践。

---

### [00:51:06] [Matt Abrahams]

**English:**
Well, one thing... I mean, all of a sudden you're focusing on... You can get so wrapped up in doing these things that you're actually not connecting. It's like people who travel on a vacation and all they do is take pictures of where they are instead of experiencing where they are. And that's not where we want to be with this advice.

**中文翻译:**
嗯，有一件事……我的意思是，突然之间你专注于……你可能会太专注于做这些事情，以至于你实际上没有在建立连接。就像那些去度假的人，他们所做的只是拍下他们所在地方的照片，而不是体验他们所在的地方。这不是我们希望这些建议达到的效果。

---

### [00:51:23] [Lenny Rachitsky]

**English:**
But I love this other component of... Because a lot of people hear this advice, ask questions, be interested, be excited, this version of it, but you need to have somewhat equal levels of disclosure is really important. Because I fall into this sometimes where like, "I don't care about myself. I just want to ask you questions. And this is going great, I'm just going to keep asking." And if you're not sharing anything by yourself, it gets really strange. Even when they ask you, you're like, "No, no, let's keep talking about you." You think they want that, but they don't. They actually want to hear about you.

**中文翻译:**
但我喜欢另一个组成部分。因为很多人听到这个建议：提问、表现出兴趣、表现出兴奋，这是它的一个版本，但你需要有某种程度的对等披露（equal levels of disclosure）是非常重要的。因为我有时也会陷入这种情况：“我不关心我自己，我只想问你问题。进展得很好，我会继续问下去。” 如果你自己不分享任何东西，情况就会变得很奇怪。甚至当他们问你时，你也会说：“不，不，让我们继续谈谈你。” 你以为他们想要那样，但其实他们不想，他们实际上也想听听你的事。

---

### [00:51:50] [Matt Abrahams]

**English:**
Yeah, absolutely. And you do such a lovely job as a podcast... I mean, so podcast host is a great job for you if you like asking questions, but I bet you have found, because I have found this for me as being a host of Think Fast, Talk Smart is that sharing a little bit about your own experience actually makes the conversations go better. And so I think that's a lesson for all of us, and you don't have to have your own podcast to learn that lesson.

**中文翻译:**
是的，绝对的。作为一名播客主持人，你做得非常出色。我的意思是，如果你喜欢提问，播客主持人对你来说是一份很棒的工作，但我敢打赌你已经发现（因为我发现作为《Think Fast, Talk Smart》的主持人也是如此），分享一点你自己的经历实际上会让对话进行得更好。所以我认为这对我们所有人都是一个教训，而且你不需要拥有自己的播客就能学到这个教训。

---

### [00:52:16] [Lenny Rachitsky]

**English:**
Yeah, I read this book on podcasting interviewing when I first started, and one of the big piece of advice is if you share more about yourself, you'll hear more stories that they can share. They're more vulnerable. Not that I think about that, but that's in my head sometimes.

**中文翻译:**
是的，我刚开始做播客采访时读过这本关于播客采访的书，其中一个重要的建议是，如果你分享更多关于你自己的事情，你就会听到更多他们可以分享的故事。他们会更愿意展示脆弱的一面。虽然我平时不怎么想这个，但有时它会在我脑海中浮现。

---

### [00:52:29] [Matt Abrahams]

**English:**
Yeah. Well, you do a good job of it, even if it's just intuitive.

**中文翻译:**
是的。嗯，你做得很好，即使这只是直觉。

---

### [00:52:33] [Lenny Rachitsky]

**English:**
Appreciate it.
(00:52:33):
Let's talk about another version of on-the-spot talking, which is giving feedback. Oftentimes people listening to this podcast, they're asked, what do you think of this design? What do you think of this roadmap? What do you think of the strategy? What are some tips for getting better at on-the-spot feedback?

**中文翻译:**
谢谢。让我们谈谈另一种即兴交谈的情况，即给出反馈。听这个播客的人经常会被问到：你觉得这个设计怎么样？你觉得这个路线图怎么样？你觉得这个策略怎么样？关于即兴反馈，你有什么建议吗？

---

### [00:52:48] [Matt Abrahams]

**English:**
First and foremost, we need to look at and define feedback. Feedback to me is an opportunity to problem solve. Certainly there are some behaviors that we absolutely have to shut down. It's inappropriate, it's inexcusable, we have to shut it down. But often feedback is really an opportunity to problem solve. And if you take it as an opportunity to problem solve, then what you're looking for is collaboration with the other person, which means that we have to invite them to join us as we do this. So it's not me bestowing upon you my opinion, it's me inviting you to together work on whatever this issue challenge is that we have. And I am a huge disciple of Kim Scott, Radical Candor. I really like her approach to it. Kim's a friend. She's actually a neighbor.

**中文翻译:**
首先，我们需要审视并定义反馈。对我来说，反馈是一个解决问题的机会。当然，有些行为我们绝对必须制止——不恰当的、不可原谅的行为，我们必须制止。但通常反馈实际上是一个解决问题的机会。如果你把它看作解决问题的机会，那么你寻求的就是与对方的协作，这意味着我们必须邀请他们加入我们。所以，这不是我在向你施加我的意见，而是在邀请你一起解决我们面临的任何问题或挑战。我是 Kim Scott《彻底坦率》（Radical Candor）的忠实信徒。我非常喜欢她的处理方式。Kim 是我的朋友，她实际上是我的邻居。

---

### [00:53:33] [Lenny Rachitsky]

**English:**
Well, she's been on the podcast, by the way.

**中文翻译:**
噢，顺便说一下，她上过这个播客。

---

### [00:53:35] [Matt Abrahams]

**English:**
Oh, great. So you know Kim and your listeners know Kim. Yeah, she's great. Where I think I can add a little value to what Kim talks about, and she does talk about structure, but I think having the structure to package up the information to make it easier to digest by your audience, the person or people you're talking to, but also to formulate your thoughts can help. And we've already talked about one mechanism, one structure for feedback. It's what, so what, now what?
(00:53:59):
So imagine, Lenny, you and I come out of a meeting and you say, "Hey, Matt, how'd that go?" I could say, "I thought the meeting went really well, Lenny, except when you talked about the implementation plan. You spoke a little quicker than you did with the other parts and you didn't go into the same level of detail." That's my what. "When you speak quickly without a lot of detail, people might think you're not as prepared or you're really concerned about this part." That's the so what. "Next time I suggest you slow down and you include these two or three bits of data so that people see you really are knowledgeable on this area." So that's the now what.
(00:54:32):
So that what, so what, now what helps me very quickly structure information and package it in a way that helps me as the giver of the feedback, think through what are the things I need to say? I need to think through what's bothering me, what the consequences are of that behavior, and then what I think you should do.
(00:54:51):
There's a more robust structure I talk about in the book called The 4 Is, and each I stands for something starting with the letter I. But four eyes also like glasses. It helps you see more clearly. So in the 4 I structure, the first I is information. You're just setting the playing field so the person knows what you're giving the feedback about. The second is impact, and this is impact on you, the feedback giver. The third is the invitation that you make, and then the final is the implications or consequences.
(00:55:19):
So imagine I have an employee who doesn't show up to the meetings on time and prepared. I might say, "This is the third time that you have showed up late to this meeting. I feel you're not prioritizing this meeting the same way others of us are. What can we do to help make sure you show up prepared for the next meeting? Because if you do, we're going to finish the project on time and get a new cool project." So information, impact, invitation, and implications. Now, certainly I can vary the tone and the directness of some of those responses so it sounds very differently, but thinking through it in my mind, I have to level set what we're talking about. I have to share why it's important to me at least, make the invitation, and talk about the benefits or consequences. Makes a lot of sense. So there are lots of structures and lots of ways to communicate, especially in feedback. Find one or two that work for you so when you're put on the spot, you can default to it.

**中文翻译:**
噢，太棒了。所以你了解 Kim，你的听众也了解 Kim。是的，她很棒。我认为我可以在 Kim 谈论的内容基础上增加一点价值，她确实谈到了结构，但我认为拥有一个结构来包装信息，使其更容易被你的听众（你正在交谈的人）消化，同时也更容易构思你的想法，是有帮助的。我们已经讨论过一种反馈机制，一种结构。那就是：是什么？那又怎样？现在该怎么办？
(00:53:59):
想象一下，Lenny，你和我开完会出来，你问：“嘿，Matt，表现怎么样？” 我可以说：“我觉得会议进行得非常好，Lenny，除了你谈到执行计划的时候。你说话比其他部分快了一点，而且没有深入到同样的细节水平。” 这是我的“是什么”。“当你说话很快且没有太多细节时，人们可能会认为你准备得不够充分，或者你对这部分非常担心。” 这是“那又怎样”。“下次我建议你放慢速度，并加入两三条数据，这样人们就能看到你在这个领域确实很专业。” 这就是“现在该怎么办”。
(00:54:32):
所以，这个“是什么、那又怎样、现在怎么办”帮助我非常快速地组织信息，并以一种帮助我（作为反馈提供者）思考我需要说什么的方式来包装它。我需要思考什么在困扰我，这种行为的后果是什么，以及我认为你应该怎么做。
(00:54:51):
书中我谈到了一个更稳健的结构，叫做 4Is，每个 I 代表一个以字母 I 开头的单词。但 4Is 听起来也像眼镜（four eyes）。它能帮你更清晰地看问题。所以在 4Is 结构中，第一个 I 是信息（Information），你只是在设定背景，让对方知道你反馈的是什么。第二个是影响（Impact），这是对你（反馈提供者）的影响。第三个是你发出的邀请（Invitation）。最后一个是含义或后果（Implications）。
(00:55:19):
想象一下，我有一个员工，他参加会议不准时且没做好准备。我可能会说：“这是你第三次参加这个会议迟到了（信息）。我觉得你没有像我们其他人一样重视这个会议（影响）。我们能做些什么来确保你下次会议能做好准备准时参加？（邀请）因为如果你做到了，我们将按时完成项目并获得一个新的酷项目（后果）。” 所以是信息、影响、邀请和后果。当然，我可以改变这些回应的语气和直接程度，让它听起来非常不同，但在我脑海中思考时，我必须明确我们在谈论什么，我必须分享为什么这对我来说很重要，发出邀请，并谈论利益或后果。这非常有意义。所以有很多结构和沟通方式，尤其是在反馈中。找一两个适合你的，这样当你被推到聚光灯下时，你就可以默认使用它。

---

### [00:56:13] [Lenny Rachitsky]

**English:**
Maybe a big takeaway here is pick one of these structures that you want to use when somebody asks you for feedback. And the two you shared are what? So what? Now what? Or these four Is. Give information, show the impact that it had on you, invitation and then implications.

**中文翻译:**
也许这里的一个重要收获是，当有人要求你提供反馈时，选择其中一个你想使用的结构。你分享的两个是：“是什么？那又怎样？现在该怎么办？” 或者是这四个 I：提供信息、展示它对你产生的影响、发出邀请，然后是后果。

---

### [00:56:30] [Matt Abrahams]

**English:**
That's correct, yeah.

**中文翻译:**
没错，是的。

---

### [00:56:32] [Lenny Rachitsky]

**English:**
Okay. Let's talk about another category, which is not a work category, but I suck at toasts and I am always trying to get better at this. And you have a bunch of awesome advice for how to give better toasts. Can you share some stuff?

**中文翻译:**
好的。让我们谈谈另一个类别，这不是工作类别，但我很不擅长祝酒辞（toasts），我一直试图在这方面做得更好。你有很多关于如何给出更好的祝酒辞的绝佳建议。你能分享一些吗？

---

### [00:56:45] [Matt Abrahams]

**English:**
Yeah. We have all been victimized by bad toasts. The toast that goes on too long, the toast that's more about the person giving the toast than the event or the person. And when I say toast, I don't just mean at weddings, bar mitzvahs, quinceaneras. We give tributes at work all the time. Congratulations to the team or somebody's anniversary or somebody's retirement. So we give toasts and tributes all the time. In fact, I heard a statistic once that it is the most frequent public speaking event across people is giving toasts and tributes. So we should learn how to do these well.
(00:57:16):
So I have an acronym. It works. It's called WHAT. W-H-A-T. The W stands for why are we here? Now, if I'm at a wedding, I don't have to tell the audience why we're here. We get it. But if we're doing an all hands and I'm called up to speak, it might be in my best interest to share with everybody, I'm here to celebrate the release of this product that that team put out. So you might have to say, why are we here?
(00:57:42):
The H is how are you connected to the event? So if I'm at a wedding, people might not know who I am. I could say, "Hey, I've known the groom for 25 years." And people are like, "Oh, okay. Now that makes sense." If you're giving a tribute at work, you don't have to say, "And I'm the boss." Everybody knows your position. So again, these are choices you make. So why are we here? How are you connected?
(00:58:02):
The A stands for anecdote. Tell a story or a quick example that is relevant and accessible to everybody. There's no insider knowledge and keep it concise.
(00:58:16):
And then ultimately the last part is the gratitude, the thank you. So express gratitude, express some kind of thanks. In a toast at a celebratory event, you might say cheers or whatever's appropriate for the culture you come from to signal closure. But again, why are we here? How are you connected? Anecdote or two, and then the gratitude or thanking at the end. And if you follow that structure, it can navigate, just like a GPS, your way through the toast.

**中文翻译:**
是的。我们都曾是糟糕祝酒辞的受害者。祝酒辞说得太长，祝酒辞更多是关于敬酒的人而不是活动或被敬酒的人。当我提到祝酒辞时，我不只是指婚礼、成人礼。我们在工作中也经常致辞：祝贺团队、某人的周年纪念或某人的退休。所以我们一直在进行祝酒和致辞。事实上，我曾听过一个统计数据，致辞和祝酒是人们最频繁进行的公众演讲活动。所以我们应该学会如何做好这些。
(00:57:16):
所以我有一个缩写词。它很管用。叫做 WHAT。W-H-A-T。W 代表我们为什么在这里？（Why are we here?）如果我在婚礼上，我不需要告诉观众我们为什么在这里，大家都明白。但如果我们是在全员大会上，我被叫上去发言，我最好告诉大家：我在这里是为了庆祝那个团队发布的产品。所以你可能需要说“我们为什么在这里”。
(00:57:42):
H 代表你与这次活动有什么联系？（How are you connected?）如果我在婚礼上，人们可能不知道我是谁。我可以说：“嘿，我认识新郎 25 年了。” 人们就会想：“噢，好吧，现在明白了。” 如果你在工作中致辞，你不需要说“我是老板”，大家都知道你的职位。所以，这些是你做出的选择。所以是：为什么在这里？有什么联系？
(00:58:02):
A 代表轶事（Anecdote）。讲一个故事或一个简短的例子，要与每个人相关且易于理解。不要讲内部梗，并且要保持简洁。
(00:58:16):
最后一部分是感激（Gratitude），即谢谢。表达感激，表达某种谢意。在庆祝活动的祝酒中，你可以说“干杯”或任何适合你文化的词来表示结束。再说一遍：我们为什么在这里？你有什么联系？一两个轶事，最后是感激或致谢。如果你遵循这个结构，它就能像 GPS 一样导航你完成祝酒。

---

### [00:58:45] [Lenny Rachitsky]

**English:**
This is such an easy structure to remember. There's so much of it that I love. What I want to understand is where do you put the actual content of the tribute and the toast? Is it the anecdote expands into, "Here's what I want to say?" Like there's an example or story and then it's like-

**中文翻译:**
这是一个非常容易记住的结构。其中有很多我喜欢的地方。我想了解的是，你把致辞和祝酒辞的实际内容放在哪里？是轶事部分扩展为“这就是我想说的”吗？比如有一个例子或故事，然后——

---

### [00:58:59] [Matt Abrahams]

**English:**
Exactly. So it is typically part of that. You might do it as part of the why we're all here. "We're here to really celebrate the Herculean effort of this particular team to get this product launched. I'm so honored to have supported it. I'm the manager of the team. Here's a story about how Lenny worked overtime to get this done. Let's raise our glasses and give them a salute." So yes, you could do it in the why are we here or through the anecdotes.

**中文翻译:**
没错。所以它通常是其中的一部分。你可以把它作为“我们为什么都在这里”的一部分。“我们在这里是为了庆祝这个特定团队为产品发布所付出的巨大努力。我很荣幸能支持他们。我是团队的经理。这里有一个关于 Lenny 如何加班完成任务的故事。让我们举起酒杯向他们致敬。” 所以，是的，你可以在“为什么在这里”或通过轶事来表达。

---

### [00:59:29] [Lenny Rachitsky]

**English:**
Okay. And then one of your other piece of advice, which connects to what you just said is be brief.

**中文翻译:**
好的。你的另一个建议是，这与你刚才说的有关，就是要简短。

---

### [00:59:33] [Matt Abrahams]

**English:**
Yes, yes. So nobody has ever complained about a toast that's too brief. I'm sure it's possible, but the majority of complaints are the toast went on forever.

**中文翻译:**
是的，是的。没有人抱怨过祝酒辞太短。我确信这有可能，但大多数抱怨都是祝酒辞没完没了。

---

### [00:59:46] [Lenny Rachitsky]

**English:**
Do you find that it would ever make sense to give a couple anecdotes or make a couple points in a toast?

**中文翻译:**
你觉得在祝酒辞中讲几个轶事或提出几个观点会有意义吗？

---

### [00:59:51] [Matt Abrahams]

**English:**
Yeah, and it depends. Toasts are opportunities for teaching and learning as well, especially in a work environment. So it might make sense to tell a couple anecdotes. I'm a huge fan... I mean, your listeners know, you know minimally viable product design, agile development, really critical. What is it about? It's about understanding your audience, your users, and it's about rapidly prototyping and iterating. I believe in minimally viable communication, trademark pending, where it's the same principles. Know your audience, put together a rough draft of what you want to say, test it out. So if you're going to give a big toast in front of a company all hands, run it by a few people and say, "Is it too many anecdotes? Would it benefit from having another story?" Get people's feedback. We are not the best judges of our communication. So the answer is yes, but test it out.

**中文翻译:**
是的，这取决于情况。祝酒辞也是教学和学习的机会，尤其是在工作环境中。所以讲几个轶事可能是有意义的。我是……的超级粉丝……我的意思是，你的听众知道，你知道最小可行产品（MVP）设计、敏捷开发，这非常关键。它是关于什么的？它是关于了解你的受众、你的用户，以及快速原型设计和迭代。我信奉“最小可行沟通”（Minimally Viable Communication），商标申请中，其原理是一样的：了解你的受众，拟定一个你想说的草稿，然后进行测试。所以，如果你要在公司全员大会上做一个大型祝酒，先找几个人听听，问问：“轶事是不是太多了？再加一个故事会不会更好？” 获取人们的反馈。我们并不是自己沟通表现的最佳评判者。所以答案是肯定的，但要先测试一下。

---

### [01:00:45] [Lenny Rachitsky]

**English:**
Another element of a great toast that you recommend is to be emotional. Can you touch on that?

**中文翻译:**
你推荐的另一个精彩祝酒辞的要素是要有情感。你能谈谈那个吗？

---

### [01:00:50] [Matt Abrahams]

**English:**
Well, so emotion connects with people, and as long as it's genuine and authentic, it's really important. I've been thinking a lot about emotion and communication. My father recently passed away and everybody in my family said, "Well, Matt's going to do the eulogy." It was like, I had no choice. What do I do? I'm the guy who teaches communication. So I felt added pressure not only to honor my father's life, but everybody's like, "This is the way you do a eulogy." And so I wanted to do some research on what's all the advice out there on eulogies, and there wasn't a lot. So I actually wrote an article on my experience, and hopefully it'll help people. But the point is, in those circumstances where there's a lot of emotion, it's important because it connects to the audience, it makes it human, but sometimes the emotion can get in the way for you as a communicator. I mean, I was very concerned that my emotion would cover up or overshadow the honoring I was trying to do of my father. But the same thing can happen in any kind of toast situation.
(01:01:48):
So think about emotion. Emotion is a tool to use. The best way to convey emotion in a toast is through the anecdotes you use. The anecdotes reveal the emotion. It's one thing to say, "I am so sad." It's another thing to tell a story that is sad.
(01:02:02):
I was very fortunate to interview for my podcast coming up soon, a one-panel cartoonist. So she has to create everything in one panel. And her advice is: Don't tell, show. In that don't tell somebody you're angry, show that you're angry in the panel she writes. So showing the emotion through story and anecdote is the way to do it.

**中文翻译:**
嗯，情感能与人建立连接，只要它是真诚和真实的，它就很重要。我最近一直在思考情感和沟通。我父亲最近去世了，我家族里的每个人都说：“好吧，Matt 来做悼词。” 就像我别无选择一样。我该怎么办？我是教沟通的人。所以我感到额外的压力，不仅要纪念我父亲的一生，而且每个人都觉得：“这就是你做悼词的方式。” 于是我想研究一下关于悼词的建议，但发现并不多。所以我实际上写了一篇关于我经历的文章，希望能对人们有所帮助。但重点是，在那些充满情感的场合，情感很重要，因为它能连接观众，让它充满人性；但有时情感也会阻碍你作为沟通者的表现。我的意思是，我非常担心我的情绪会掩盖或盖过我对我父亲的纪念。但在任何形式的祝酒场合，同样的事情都可能发生。
(01:01:48):
所以要思考情感。情感是一种可以使用的工具。在祝酒中表达情感最好的方式是通过你使用的轶事。轶事揭示了情感。说“我很伤心”是一回事，讲一个令人伤心的故事是另一回事。
(01:02:02):
我很幸运地为我即将播出的播客采访了一位单幅漫画家。她必须在一个画框里创作出所有内容。她的建议是：不要说出来，要展示出来（Don't tell, show）。也就是说，不要告诉别人你很生气，要在她画的画框里展示出你很生气。所以，通过故事和轶事来展示情感才是正确的方法。

---

### [01:02:22] [Lenny Rachitsky]

**English:**
Have you had Matthew Dix on your podcast?

**中文翻译:**
你邀请过 Matthew Dix 上你的播客吗？

---

### [01:02:26] [Matt Abrahams]

**English:**
So it is so funny. I have not, and I want to. His name comes up more than anybody else's. And I know of his work and his advice, so I might ask you to connect me.

**中文翻译:**
太有趣了。我还没请过他，但我很想请。他的名字出现的频率比任何人都高。我了解他的作品和建议，所以我可能会请你帮我引荐。

---

### [01:02:35] [Lenny Rachitsky]

**English:**
Absolutely. I thought of him as you were talking because he helps people create their eulogy ahead of time before somebody passes away, before you get really emotional and you have to rush it. So that's one of his services is he helps to write eulogies for people.

**中文翻译:**
没问题。你说话的时候我想到了他，因为他帮助人们在某人去世之前、在你变得非常情绪化且不得不匆忙完成之前，提前创作好他们的悼词。所以那是他的服务之一，他帮助人们写悼词。

---

### [01:02:50] [Matt Abrahams]

**English:**
Yeah, yeah. No, I'd love an introduction. His work is very influential.

**中文翻译:**
是的，是的。不，我很想被引荐。他的作品非常有影响力。

---

### [01:02:53] [Lenny Rachitsky]

**English:**
Absolutely. He's amazing. We'll link his episode about storytelling.
(01:02:57):
Okay, let me talk about a couple more. Q&A, getting better at question, answer at the end of a talk, whether it's on the spot or not.

**中文翻译:**
绝对的。他很棒。我们会链接他关于讲故事的那一集。
(01:02:57):
好的，让我再谈几个。Q&A（问答环节），在演讲结束时更好地进行问答，无论是否是即兴的。

---

### [01:03:05] [Matt Abrahams]

**English:**
Again, I always start with approach. Many of us see Q&A as threatening or challenging, and in fact, we need to see Q&A as an opportunity. It's an opportunity to extend, expand, connect, learn. Even in the most hostile of situations where people are really coming at you with a lot of spice or hot and heavy, you can get a lot of value out of it. So we have to come to the approaches. These questions are opportunities. We have to make sure that we take the question in without interrupting or over-validating the question.
(01:03:36):
I have two pet peeves about Q&A sessions. One is saying good question to every question. And two, at the end of answering the question saying, "Does that make sense?" Because in both cases, you're trying to validate the asker when you say good question. You're also trying to buy yourself time. And there are other ways to do that. And at the end when you say, "Does that make sense," you've got a laudable goal in mind, which is, "Did I answer your question?" But I'd much rather you say, "Did I answer your question? Can I tell you more? Do you have a follow-up question?"" Because if you keep saying, "does that make sense, does that make sense," people are going to start thinking, "Maybe he doesn't make sense because he is always asking." So some pet peeves there.
(01:04:15):
Once the question comes in and you have to answer it, I have yet another structure. This structure is related to the what, so what, now what structure. It's called ADD for adding value. You answer the question cleanly and concisely. You then give an example to reinforce the answer, and then you explain the relevance or significance of the answer so people know it. Would you mind role-playing an example of this with me, Lenny?

**中文翻译:**
同样，我总是从心态开始。我们中的许多人将 Q&A 视为威胁或挑战，而事实上，我们需要将 Q&A 视为一个机会。它是一个延伸、扩展、连接和学习的机会。即使在最敌对的情况下，当人们带着火药味或咄咄逼人地向你提问时，你也能从中获得很多价值。所以我们必须改变方法：这些问题都是机会。我们要确保在不打断或过度肯定问题的情况下听取问题。
(01:03:36):
我对 Q&A 环节有两个反感的地方。一是每个问题都说“好问题”。二是回答完问题后说“这能理解吗？”（Does that make sense?）。因为在这两种情况下，当你说“好问题”时，你是在试图肯定提问者，同时也在试图为自己争取时间，其实还有其他方法可以做到这一点。而在最后说“这能理解吗”时，你的初衷是好的，即“我回答你的问题了吗？”，但我更希望你说：“我回答你的问题了吗？我还能多告诉你一些吗？你有后续问题吗？” 因为如果你一直说“这能理解吗，这能理解吗”，人们会开始想：“也许他说话没逻辑，因为他总是在问。” 所以这是我的一些反感点。
(01:04:15):
一旦问题提出，你必须回答它，我还有另一个结构。这个结构与“是什么/那又怎样/现在怎么办”结构有关。它被称为 ADD，代表增加价值（adding value）。你清晰简洁地回答（Answer）问题。然后你给出一个例子（Detailed example）来强化答案。然后你解释答案的相关性（Describe relevance）或重要性，以便人们了解它。Lenny，你介意和我一起角色扮演一个例子吗？

---

### [01:04:43] [Lenny Rachitsky]

**English:**
Absolutely.

**中文翻译:**
没问题。

---

### [01:04:44] [Matt Abrahams]

**English:**
Okay. Imagine you're hiring me. You're a hiring manager, and I'm interviewing to be what I do for my day job. I'm a lecturer at Stanford's Business School, teach strategic communication. You so happen to have a position open for a strategic communication lecturer. I show up. What is a reasonable question you would ask that doesn't just have a yes no answer?

**中文翻译:**
好的。想象一下你在雇佣我。你是一名招聘经理，而我正在面试我日常工作的职位。我是斯坦福大学商学院的讲师，教授战略沟通。你恰好有一个战略沟通讲师的职位空缺。我出现了。你会问一个什么样的合理问题，且不是那种只需回答“是”或“否”的问题？

---

### [01:05:07] [Lenny Rachitsky]

**English:**
Wait, so you're interviewing for a role to be a lecturer in my school and [inaudible 01:05:11] communication.

**中文翻译:**
等等，所以你正在面试我学校的一个讲师职位，关于沟通（听不清）。

---

### [01:05:11] [Matt Abrahams]

**English:**
Yes. You're the dean. You get to hire me. What's a reasonable question? I mean, you could ask a super hard one, but I want people to hear how ADD works.

**中文翻译:**
是的。你是院长。你负责雇佣我。什么是合理的问题？我的意思是，你可以问一个超级难的问题，但我希望人们听到 ADD 是如何运作的。

---

### [01:05:19] [Lenny Rachitsky]

**English:**
This might be too simple, but just how many students have you worked with and taught over the years?

**中文翻译:**
这可能太简单了，但就是这些年来你合作过并教过多少学生？

---

### [01:05:23] [Matt Abrahams]

**English:**
Okay, so I'm going to morph that question because I could just say thousands, which is true, but I'm going to turn it into a question about experience, because really what you're asking me is what's my experience? So because that I can give an ADD answer too. If it's just a numeric answer, just give a number. So I might say, "I've been doing this for 25 years and I have taught over thousands of students. I've taught both in the academic world, but also in the corporate world. What this means is I can tailor my material to be relevant and useful to your students."
(01:05:56):
So I answered the question. The question was, what's your experience? 25 years, thousands of students. I then give an example. I've done this in the corporate world, I've done this in the academic world. So I ground it in something tangible. And then I show the relevance. What this means for you as a dean hiring me, is that I'm going to be able to tailor my experience. We often assume that people can connect the dots. If I give my answer, you're going to see, "Oh, that's why this is relevant and important." But we need to actually connect those dots for our audience.
(01:06:24):
I had a psychology professor once who said, the funny thing about common sense is it's not so common, and we often make the assumption that people will connect the dots. So answer the question, give a detailed example, and then explain the relevance. And if you do that, it will help. And I challenge every one of your listeners working in companies that have FAQs, frequently asked questions, go back to those FAQs and put them in this structure. Not only will it help you digest and get familiar and comfortable with the structure, anybody looking at those answers begins to see that this is a way to give a complete answer. This is how our organization answers questions. And that can be so helpful to building consistency and helping yourself answer better.

**中文翻译:**
好的，我要转化一下那个问题，因为我可以直接说成千上万，这是事实，但我会把它转化成一个关于经验的问题，因为你真正问我的是我的经验是什么？这样我也可以给出一个 ADD 式的回答。如果只是一个数字答案，那就直接给数字。所以我可能会说：“我已经做这件事 25 年了，教过成千上万的学生（回答）。我既在学术界教过书，也在企业界教过书（详细例子）。这意味着我可以调整我的材料，使其对你的学生具有相关性和实用性（描述相关性）。”
(01:05:56):
所以我回答了问题。问题是：你的经验是什么？25 年，成千上万的学生。然后我给出一个例子：我在企业界做过，在学术界也做过。所以我把它建立在具体的事实上。然后我展示了相关性：这对于你这位雇佣我的院长意味着，我将能够量身定制我的经验。我们经常假设人们能够自己建立联系。如果我给出答案，你会明白：“噢，这就是为什么这很重要且相关。” 但我们实际上需要为我们的听众连接这些点。
(01:06:24):
我曾经有一位心理学教授说：常识的有趣之处在于它并不那么平常。我们经常假设人们会自己建立联系。所以，回答问题，给出一个详细的例子，然后解释相关性。如果你这样做，会有所帮助。我挑战每一位在公司工作的听众，如果你们公司有 FAQ（常见问题解答），回到那些 FAQ，把它们放入这个结构中。这不仅能帮助你消化并熟悉这个结构，任何看到这些答案的人都会开始意识到，这是一种给出完整答案的方式。这就是我们组织回答问题的方式。这对于建立一致性并帮助你自己更好地回答问题非常有帮助。

---

### [01:07:06] [Lenny Rachitsky]

**English:**
Just to clarify, the acronym is ADD?

**中文翻译:**
澄清一下，缩写词是 ADD？

---

### [01:07:09] [Matt Abrahams]

**English:**
ADD. Answer, detailed example, describe the relevance.

**中文翻译:**
ADD。回答（Answer）、详细例子（Detailed example）、描述相关性（Describe the relevance）。

---

### [01:07:12] [Lenny Rachitsky]

**English:**
Describe the relevance. I see how you snuck that D in there.

**中文翻译:**
描述相关性。我明白你是怎么把那个 D 塞进去的了。

---

### [01:07:16] [Matt Abrahams]

**English:**
Yeah. Yeah. I mean, you can come up with whatever acronym you want that helps you remember. ADD because it adds value.

**中文翻译:**
是的。是的。我的意思是，你可以想出任何能帮你记住的缩写词。ADD 是因为它增加了价值（adds value）。

---

### [01:07:24] [Lenny Rachitsky]

**English:**
Awesome. Okay. And maybe one last quick one, apologizing. What's a couple tips for getting better at apologizing on the spot?

**中文翻译:**
太棒了。好的。也许最后一个简短的，道歉。关于更好地即兴道歉，有什么建议吗？

---

### [01:07:33] [Matt Abrahams]

**English:**
First and foremost, we need to take the time to apologize. Many of us don't. And when we apologize, we need to make sure that we apologize for the transgression and not for how we made people feel. So often people will simply say, "I'm sorry that you feel bad." Well, that's not an apology. You're not assuming responsibility. So we need to first start by talking about the issue that we are addressing or the problem that we caused somebody. So we need to think about apologies in that way. So an apology to me, I have a AAA, like roadside repair service here in the United States, AAA. It's three steps, acknowledge, appreciate, and amends. So I have to acknowledge what I did.
(01:08:23):
So imagine we're in a meeting and I interrupted you. You were in the midst of speaking and I interrupted you. So I might say, "I'm very sorry for interrupting what you were saying. I over-spoke when you were talking." I'm acknowledging what I did.
(01:08:36):
Then I appreciate. "I can imagine my doing that made you feel bad and you feel that you didn't get your fair share of sharing your point of view." So that's the appreciation.
(01:08:46):
The amends part is, "I will work not to do this. In fact, I will wait till you're done, and I will actually paraphrase what you said before I contribute my point." So I'm signaling I understand it, and here's the very specific thing I'm going to do to try to remedy it, which of course you can comment on. You can say, no, I don't think that's enough. I think you whatever, or thank you, I think that's even more than is needed, whatever. So you acknowledge the actual behavior and offense, not how you made the person feel right away. You then express appreciation for the difficulty you might've caused, and then you make amends. And the AAA approach, I think can really be helpful to people to be better at in-the-moment apologies.

**中文翻译:**
首先，我们需要花时间去道歉。我们中的许多人并不道歉。当我们道歉时，我们需要确保我们是为过错道歉，而不是为我们让人们产生的感觉道歉。人们经常只是简单地说：“我很抱歉让你感到难过。” 嗯，那不是道歉，你没有承担责任。所以我们首先需要谈论我们正在处理的问题，或者我们给别人造成的麻烦。我们需要以这种方式思考道歉。所以对我来说，道歉有一个 AAA 结构，就像美国的 AAA 路边维修服务一样。它分为三个步骤：承认（Acknowledge）、感激（Appreciate）和弥补（Amends）。所以我必须承认我做了什么。
(01:08:23):
想象一下我们在开会，我打断了你。你正在说话，而我打断了你。所以我可能会说：“非常抱歉打断了你的话。在你说话的时候我抢话了（承认）。” 我在承认我所做的事。
(01:08:36):
然后是感激。“我可以想象我这样做让你感到很不舒服，让你觉得没有得到公平的机会来分享你的观点（感激/理解）。” 这就是感激。
(01:08:46):
弥补部分是：“我会努力不再这样做。事实上，我会等到你说完，并且在发表我的观点之前先转述一下你刚才说的话（弥补）。” 所以我在发出信号，表明我理解了，并且这是我为了补救而要做的非常具体的事情。当然，你可以对此发表评论。你可以说：“不，我觉得这还不够，你应该如何如何”，或者说：“谢谢，我觉得这甚至超出了需要”。所以，你要承认实际的行为和冒犯，而不是立刻针对你让对方产生的感觉。然后你对可能造成的困难表示理解，最后做出弥补。我认为 AAA 方法真的能帮助人们更好地进行即兴道歉。

---

### [01:09:29] [Lenny Rachitsky]

**English:**
Amazing. Matt, I think we've packed this episode with so many tactical golden nuggets to help people become better communicators, especially on the spot. Is there anything else you want to share or leave listeners with before I ask you how they can find you online and things like that?

**中文翻译:**
太棒了。Matt，我认为这一集充满了这么多战术性的金点子，可以帮助人们成为更好的沟通者，尤其是即兴沟通。在问你如何在网上找到你之类的问题之前，你还有什么想分享或留给听众的吗？

---

### [01:09:45] [Matt Abrahams]

**English:**
Again, I want to go back to how we started the second part about spontaneous speaking. Everybody can get better at communication. And I encourage, I challenge people to take the steps that they need to take to do it. So it starts with initiative. It's followed by grace and a lot of compassion, it takes time. But in so doing, you can improve your communication and help others. It's not just about you finding your voice, it's about you sharing that voice with others. So taking the time to work on your communication is critically important, and I encourage everybody to do so.

**中文翻译:**
我还是想回到我们开始第二部分关于即兴演讲时所说的话。每个人都可以提高沟通能力。我鼓励、我挑战人们采取他们需要采取的步骤去做这件事。这始于主动性，随后需要优雅和大量的同情心，这需要时间。但通过这样做，你可以改善你的沟通并帮助他人。这不仅仅是关于你找到自己的声音，更是关于你与他人分享那个声音。所以，花时间磨练你的沟通能力至关重要，我鼓励每个人都这样做。

---

### [01:10:18] [Lenny Rachitsky]

**English:**
All right. I'm hoping people will follow that advice. And if not, think back to what we talked about at the beginning of just how much impact these have and how many people are also going through the same challenges you're probably feeling speaking and being on the spot. All right, where can folks find your podcast, your book, and also how can listeners be useful to you?

**中文翻译:**
好的。我希望人们会遵循那个建议。如果没有，回想一下我们在开始时谈到的这些影响有多大，以及有多少人也正在经历你可能在演讲和即兴发挥时感受到的同样挑战。好的，大家在哪里可以找到你的播客、你的书，以及听众可以如何为你提供帮助？

---

### [01:10:37] [Matt Abrahams]

**English:**
Oh, I love that last question. So mattabrahams.com, great place to go to to find things. So at mattabrahams.com you'll find a whole bunch of resources. My own and others. I've curated a bunch of resources. You can find Think Fast, Talk Smart wherever you get podcasts and on YouTube. And then the book Think Faster, Talk Smarter is available everywhere. I'm a huge user of LinkedIn. And to answer that last question you asked, I invite people to connect on LinkedIn. I'd love to hear their stories and find ways to collaborate.

**中文翻译:**
噢，我喜欢最后一个问题。mattabrahams.com 是一个寻找资料的好地方。在 mattabrahams.com，你会发现一大堆资源，包括我自己的和他人的，我策划了很多资源。你可以在任何获取播客的地方和 YouTube 上找到《Think Fast, Talk Smart》。书《Think Faster, Talk Smarter》随处可见。我是 LinkedIn 的资深用户。为了回答你问的最后一个问题，我邀请人们在 LinkedIn 上建立联系。我很想听听他们的故事并寻找合作的方式。

---

### [01:11:06] [Lenny Rachitsky]

**English:**
Awesome. And your podcast is ranked higher than this podcast. You're in a different category, which is a very competitive category. The business category. I've moved myself to the technology category, which feels more natural to me, but your podcast is killing it, so congrats.

**中文翻译:**
太棒了。你的播客排名比这个播客还要高。你在一个不同的类别，那是一个非常有竞争力的类别——商业类别。我把自己移到了技术类别，这对我来说感觉更自然，但你的播客非常成功，所以恭喜你。

---

### [01:11:06] [Matt Abrahams]

**English:**
Thank you.

**中文翻译:**
谢谢。

---

### [01:11:21] [Lenny Rachitsky]

**English:**
Thank you for sharing your wisdom with us. That's it. Matt, thank you again for being here.

**中文翻译:**
感谢你与我们分享你的智慧。就这样。Matt，再次感谢你的到来。

---

### [01:11:27] [Matt Abrahams]

**English:**
Great pleasure to have the conversation with you, Lenny. I enjoyed it thoroughly.

**中文翻译:**
Lenny，很高兴能与你交谈。我非常享受。

---

### [01:11:30] [Lenny Rachitsky]

**English:**
Same. Bye everyone.
(01:11:34):
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
我也是。大家再见。
(01:11:34):
非常感谢您的收听。如果您觉得这很有价值，您可以在 Apple Podcasts、Spotify 或您喜欢的播客应用上订阅本节目。此外，请考虑给我们评分或留下评论，因为这确实能帮助其他听众找到这个播客。您可以在 lennyspodcast.com 找到所有往期节目或了解更多关于本节目的信息。我们下集再见。