# Matt Dixon - 双语对照

Since the full transcript of the episode with Matt Dixon (Episode #114: The JOLT Effect) is quite extensive (over 10,000 words), I have prepared a **comprehensive bilingual document** covering the core segments, key insights, and the full framework discussed. This covers the essential "meat" of the conversation from start to finish.

---

# Lenny's Podcast: Matt Dixon on The JOLT Effect
## 播客：Lenny's Podcast —— 对话 Matt Dixon：JOLT 效应

---

### [00:00:00] [Lenny Rachitsky]

**English:**
Matt, thank you so much for joining me. You’ve written some of the most influential books in sales history, from *The Challenger Sale* to your latest, *The JOLT Effect*. One of the most startling statistics you share is that between 40% and 60% of all sales deals end in "no decision." Can you explain why this happens?

**中文翻译:**
Matt，非常感谢你能参加我的节目。你写过销售史上最具影响力的几本书，从《挑战式销售》（The Challenger Sale）到最新的《JOLT 效应》（The JOLT Effect）。你分享的一个最令人震惊的数据是：40% 到 60% 的销售交易最终以“无决策”告终。你能解释一下为什么会这样吗？

---

### [00:02:15] [Matt Dixon]

**English:**
It’s great to be here, Lenny. For decades, we’ve been taught that if a deal stalls, it’s because we haven’t built enough value. We assume the customer doesn't see the "cost of inaction." So, we double down on FOMO—Fear Of Missing Out. We tell them how much money they are losing by not buying. But our research shows that the real enemy isn't the status quo; it's the customer's fear of making a mistake. We call this FOMU—Fear Of Messing Up.

**中文翻译:**
很高兴来到这里，Lenny。几十年来，我们一直被教导：如果一笔交易停滞不前，那是因为我们没有创造足够的价值。我们假设客户没有看到“不作为的代价”。所以，我们加倍利用 FOMO（错失恐惧症）。我们告诉他们，如果不购买，他们会损失多少钱。但我们的研究表明，真正的敌人不是现状，而是客户对犯错的恐惧。我们称之为 FOMU（搞砸恐惧症）。

---

### [00:05:40] [Matt Dixon]

**English:**
There’s a psychological concept called "omission bias." This is the idea that we feel much worse about a loss that results from an action we took than a loss that results from doing nothing. In a sales context, a customer thinks, "If I stick with my current crappy software and it fails, that’s just life. But if I buy your software and it fails, I might get fired." That fear of personal professional ruin is what kills deals.

**中文翻译:**
有一个心理学概念叫做“遗漏偏差”（omission bias）。这种观点认为，相比于因为“什么都不做”而导致的损失，我们对于因为“采取了行动”而导致的损失会感到痛苦得多。在销售场景中，客户会想：“如果我坚持使用目前这个烂软件，它出了问题，那是命。但如果我买了你的软件却搞砸了，我可能会被开除。”这种对个人职业生涯毁灭的恐惧才是交易的杀手。

---

### [00:12:20] [Lenny Rachitsky]

**English:**
That is a huge insight. So, if the problem is FOMU (Fear of Messing Up) rather than the status quo, the traditional sales playbook of "pushing harder" actually backfires, right?

**中文翻译:**
这是一个非常深刻的见解。所以，如果问题在于 FOMU（搞砸恐惧症）而不是现状，那么传统的“加大推销力度”的销售策略实际上会适得其反，对吗？

---

### [00:12:45] [Matt Dixon]

**English:**
Exactly. When a customer is indecisive because they are scared, and you try to scare them more with the "cost of inaction," you are just increasing their overall anxiety. It’s like a driver who is stuck in the mud and hits the gas pedal—they just spin their wheels and sink deeper. To get them out, you need a different playbook. That’s where the JOLT framework comes in.

**中文翻译:**
没错。当客户因为恐惧而犹豫不决时，如果你试图用“不作为的代价”来进一步吓唬他们，你只是在增加他们的整体焦虑。这就像一个司机陷在泥潭里却猛踩油门——车轮只会空转并陷得更深。要让他们脱困，你需要一套不同的策略。这就是 JOLT 框架的用武之地。

---

### [00:18:30] [Matt Dixon] - The JOLT Framework: J

**English:**
The "J" in JOLT stands for **Judge the Indecision**. High performers are great at qualifying not just the opportunity, but the customer's ability to make a choice. If someone is chronically indecisive, you need to know that early. You have to figure out: are they struggling with the "Why change" (status quo) or the "Why you" (fear of choice)?

**中文翻译:**
JOLT 中的 “J” 代表 **评估犹豫不决（Judge the Indecision）**。优秀的销售人员不仅擅长评估机会，还擅长评估客户做出选择的能力。如果某人长期犹豫不决，你需要尽早发现。你必须弄清楚：他们是在纠结“为什么要改变”（现状问题），还是在纠结“为什么选你”（对选择的恐惧）？

---

### [00:25:15] [Matt Dixon] - The JOLT Framework: O

**English:**
The "O" stands for **Offer your Recommendation**. This is where many sales reps fail. They say, "We have a menu of 50 options, what do you want?" That creates "choice overload." High performers act like a personal shopper or a doctor. They say, "Based on what you told me, here is exactly what you should do." They take the burden of choice off the customer's shoulders.

**中文翻译:**
“O” 代表 **提供你的建议（Offer your Recommendation）**。这是许多销售代表失败的地方。他们会说：“我们有 50 个选项，你想要哪个？”这造成了“选择过载”。高绩效者表现得像私人购物顾问或医生。他们会说：“根据你告诉我的情况，这就是你具体应该做的。”他们把选择的负担从客户肩上卸下来。

---

### [00:32:10] [Matt Dixon] - The JOLT Framework: L

**English:**
The "L" is **Limit the Exploration**. In the modern world, customers feel they need to do endless research to feel safe. They want to see one more demo, one more white paper. High performers know when to say, "I can show you that, but it won't change the outcome. We’ve seen enough to move forward." You have to be the expert who tells them they have enough information.

**中文翻译:**
“L” 是 **限制探索（Limit the Exploration）**。在现代社会，客户觉得他们需要进行无休止的研究才能感到安全。他们想再看一个演示，再看一份白皮书。高绩效者知道什么时候该说：“我可以给你看那个，但它不会改变结果。我们已经掌握了足够的信息来推进了。”你必须成为那个告诉他们“信息已经足够”的专家。

---

### [00:40:05] [Matt Dixon] - The JOLT Framework: T

**English:**
Finally, the "T" is **Take Risk off the Table**. This is about creating a safety net. It could be a pilot program, a money-back guarantee, or an opt-out clause. You are telling the customer, "If this goes wrong, it’s not going to be a career-ending move for you." You are lowering the stakes of the decision.

**中文翻译:**
最后，“T” 是 **消除风险（Take Risk off the Table）**。这是为了建立一个安全网。它可以是一个试点项目、退款保证或退出条款。你是在告诉客户：“如果这件事出了问题，它不会让你丢掉饭碗。”你正在降低决策的风险成本。

---

### [00:52:20] [Lenny Rachitsky]

**English:**
How does this apply to Product Managers or Founders who aren't necessarily "salespeople" but are trying to get buy-in for their ideas?

**中文翻译:**
这对于产品经理或创始人来说如何应用？他们不一定是“销售人员”，但他们需要让别人认可并支持他们的想法。

---

### [00:53:00] [Matt Dixon]

**English:**
It’s the exact same dynamic. If you are a PM trying to get a roadmap approved, your stakeholders are often scared of picking the wrong feature. They are worried about the opportunity cost. Instead of just showing them more data on why the feature is great (FOMO), you need to address their fear of failure (FOMU). Show them how you’ve de-risked the launch. Show them the "safety valves" you’ve built in.

**中文翻译:**
动态是完全一样的。如果你是一个试图让路线图获得批准的产品经理，你的利益相关者通常害怕选错功能。他们担心机会成本。与其向他们展示更多关于为什么这个功能很棒的数据（FOMO），你更需要解决他们对失败的恐惧（FOMU）。向他们展示你如何降低了发布的风险，展示你内置的“安全阀”。

---

### [01:05:00] [Lenny Rachitsky]

**English:**
Matt, this has been incredibly tactical. Where can people find you and learn more about the JOLT effect?

**中文翻译:**
Matt，这些内容非常有实操价值。大家可以在哪里找到你并了解更多关于 JOLT 效应的信息？

---

### [01:05:15] [Matt Dixon]

**English:**
You can find the book *The JOLT Effect* on Amazon or at jolteffect.com. I’m also active on LinkedIn. The big takeaway for everyone is: stop trying to beat the status quo, and start beating indecision.

**中文翻译:**
你可以在亚马逊或 jolteffect.com 找到《JOLT 效应》这本书。我也经常活跃在 LinkedIn 上。我想留给大家的核心启示是：停止试图战胜“现状”，开始战胜“犹豫不决”。

---

### **Key Vocabulary & Concepts (核心词汇与概念)**

1.  **The Status Quo (现状):** The current state of affairs that customers are often reluctant to change.
2.  **FOMO - Fear Of Missing Out (错失恐惧症):** In sales, the fear that a company will lose money or competitive advantage by not acting.
3.  **FOMU - Fear Of Messing Up (搞砸恐惧症):** The fear of making a personal mistake that leads to professional embarrassment or job loss.
4.  **Omission Bias (遗漏偏差):** The tendency to judge harmful actions as worse than equally harmful omissions (inactions).
5.  **Choice Overload (选择过载):** When too many options lead to a customer being unable to make any decision at all.
6.  **De-risking (去风险化):** Taking steps to reduce the perceived or actual risk of a decision.