# Matt LeMay - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Matt LeMay.

---

### [00:00:00] Matt LeMay

**English:**
More product managers and teams are getting laid off. The problem is the message that Daniel Ek from Spotify sent out with their layoffs in 2024, we still have too many teams doing work around the work.

**中文翻译:**
越来越多的产品经理和团队正在被裁员。问题在于 Spotify 的 Daniel Ek 在 2024 年裁员时发出的信息：我们仍然有太多的团队在做那些“围绕工作的琐事”（work around the work），而不是核心工作。

---

### [00:00:11] Lenny Rachitsky

**English:**
Even if you are told to build the thing that the execs are really excited about, you're still going to get fired eventually.

**中文翻译:**
即使你被要求去构建那些高管们非常兴奋的东西，如果这些东西没有实际产出，你最终还是会被解雇。

---

### [00:00:15] Matt LeMay

**English:**
If you were the CEO of this company, would you fully fund your own team? Frankly, most of the people I ask that question to don't know the answer right away.

**中文翻译:**
如果你是这家公司的 CEO，你会全额资助你现在的团队吗？坦白说，我问过的大多数人都无法立即给出答案。

---

### [00:00:24] Lenny Rachitsky

**English:**
Which is something you call the low impact PM Death Spiral.

**中文翻译:**
这就是你所说的“低影响力产品经理死亡螺旋”。

---

### [00:00:26] Matt LeMay

**English:**
Is the dynamic in which every medium to large company I've ever worked with finds itself in, one way or another. It starts with adding little features here and there, making little cosmetic improvements until the next round of layoffs.

**中文翻译:**
这是我合作过的每一家中大型公司都会以某种方式陷入的动态。它始于到处添加一些小功能，做一些表面上的改进，直到下一轮裁员到来。

---

### [00:00:39] Lenny Rachitsky

**English:**
You have three steps to become more of an impact first product team.

**中文翻译:**
你提出了三个步骤，让团队变得更加“影响力优先”。

---

### [00:00:42] Matt LeMay

**English:**
So the first is in setting team goals, no more than one step away from company goals. Don't let it get cascaded into oblivion.

**中文翻译:**
第一步是设定团队目标，使其与公司目标的距离不超过一个层级。不要让目标在层层传递中消失殆尽。

---

### [00:00:50] Lenny Rachitsky

**English:**
You're an ICPM. It's up to you. No excuses.

**中文翻译:**
如果你是一名个人贡献者产品经理（ICPM），这取决于你。没有任何借口。

---

### [00:00:52] Matt LeMay

**English:**
You can follow all the best practices, but if your company goes out of business, they're not going to keep writing your paycheck for two years because all of your OKRs were a 0.6 or a 0.7.

**中文翻译:**
你可以遵循所有的最佳实践，但如果你的公司倒闭了，他们不会因为你的 OKR 分数是 0.6 或 0.7 就继续给你发两年工资。

---

### [00:01:02] Lenny Rachitsky

**English:**
Today my guest is Matt LeMay. Matt is a longtime product leader, author of one of the most popular and practical books in the field of product management called Product Management in Practice. Over the course of his consulting practice, he's worked with hundreds of product teams, helping them improve how they operate and drive more impact, more consistently. From that experience, he wrote and recently published a new book called Impact First Product Teams, that I could not agree more with.

**中文翻译:**
今天的嘉宾是 Matt LeMay。Matt 是一位资深的产品领导者，也是产品管理领域最受欢迎且最实用的书籍之一——《产品管理实践》（Product Management in Practice）的作者。在他的咨询生涯中，他曾与数百个产品团队合作，帮助他们改进运营方式，并更持续地产生影响力。基于这些经验，他撰写并于近期出版了一本新书，名为《影响力优先的产品团队》（Impact First Product Teams），我对此深表赞同。

---

### [00:01:35] Lenny Rachitsky

**English:**
In our conversation, Matt shares why it is so essential to align all of your work with business critical outcomes, especially if you fear layoffs at your company. We talk about the low impact death spiral that many product teams fall into. What steps an individual product team can take to align their work to business critical outcomes, regardless of how their organization approaches product development. Tips for how to push back on stupid ideas that execs ask you to build, and so much more.

**中文翻译:**
在我们的对话中，Matt 分享了为什么将所有工作与业务关键成果对齐是如此重要，尤其是当你担心公司裁员时。我们讨论了许多产品团队陷入的“低影响力死亡螺旋”。无论组织如何看待产品开发，单个产品团队可以采取哪些步骤将工作与业务关键成果对齐。还有如何拒绝高管要求你构建的愚蠢想法的技巧，以及更多内容。

---

### [00:01:52] Lenny Rachitsky

**English:**
The message in this episode is one that I believe every product manager needs to hear, especially if you don't work at a high-flying Silicon Valley tech company. A huge thank you to Martin Erickson, Adrian Joselow, and Dan Corbin for suggesting topics and questions for this conversation.

**中文翻译:**
我相信本集传达的信息是每位产品经理都需要听到的，尤其是如果你不在那些显赫的硅谷科技公司工作。非常感谢 Martin Erickson、Adrian Joselow 和 Dan Corbin 为本次对话提供的建议主题和问题。

---

### [00:02:07] Lenny Rachitsky

**English:**
If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. Also, if you become an annual subscriber of my newsletter, you get a year free of a bunch of incredible products... Check it out at Lenny'snewsletter.com and click bundle.

**中文翻译:**
如果你喜欢这个播客，别忘了在订阅并关注。此外，如果你成为我时事通讯的年度订阅者，你可以免费获得一年的一系列不可思议的产品……请访问 Lenny'snewsletter.com 并点击“bundle”查看。

---

### [00:02:29] Lenny Rachitsky

**English:**
With that, I bring you Matt LeMay. This episode is brought to you by Enterpret. Enterpret is a customer intelligence platform used by a leading CX and product orgs like Canva, Notion, Perplexity, Strava, Hinge, and Linear to leverage the voice of the customer and build best-in-class products. Enterpret unifies all customer conversations in real time... reach out to the team at enterpret.com/Lenny.

**中文翻译:**
现在，让我们欢迎 Matt LeMay。本集由 Enterpret 赞助。Enterpret 是一个客户情报平台，被 Canva、Notion、Perplexity 等领先的 CX 和产品组织使用，旨在利用客户的声音构建一流产品。Enterpret 实时统一所有客户对话……请访问 enterpret.com/Lenny 联系他们的团队。

---

### [00:03:32] Lenny Rachitsky

**English:**
This episode is brought to you by Pragmatic Institute, a trusted leader in product training and the go-to source for teams driving real results. This fall, they're back with the biggest event of the year: the Future of Product Management Summit. On October 16th, join thousands of product managers... Save your seat at pragmaticinstitute.com/Lenny.

**中文翻译:**
本集由 Pragmatic Institute 赞助，他们是产品培训领域值得信赖的领导者。今年秋天，他们将举办年度盛会：产品管理未来峰会。10 月 16 日，与成千上万的产品经理一起参与……请在 pragmaticinstitute.com/Lenny 预留席位。

---

### [00:04:26] Lenny Rachitsky

**English:**
Matt, thank you so much for being here and welcome to the podcast.

**中文翻译:**
Matt，非常感谢你能来到这里，欢迎来到我们的播客。

---

### [00:04:29] Matt LeMay

**English:**
Thank you so much for having me. I'm really, really excited to be here.

**中文翻译:**
非常感谢你的邀请。能来到这里我真的非常兴奋。

---

### [00:04:32] Lenny Rachitsky

**English:**
I'm even more excited. You have a really interesting background. I usually don't spend time on background, but I thought this would be fun. I was looking at your LinkedIn and your background. The beginning of your career you spent 13 years at Pitchfork reviewing music.

**中文翻译:**
我更兴奋。你的背景非常有趣。我通常不在背景上花时间，但我认为这会很有趣。我看过你的 LinkedIn，你职业生涯的最初 13 年是在 Pitchfork 评论音乐。

---

### [00:04:46] Matt LeMay

**English:**
Yes.

**中文翻译:**
是的。

---

### [00:04:46] Lenny Rachitsky

**English:**
Reviewing artists. Pitchfork was a massive deal. I don't know where it is today, but it was the most influential music review site. Is it still a big deal or is it less so?

**中文翻译:**
评论艺术家。Pitchfork 曾经影响力巨大。我不知道它现状如何，但它曾是最具影响力的音乐评论网站。现在它依然举足轻重吗，还是大不如前了？

---

### [00:04:55] Matt LeMay

**English:**
It is still a big deal. It was much less of a big deal when I started working for them and I was a 16-year-old music nerd, writing record reviews in my bedroom at my parents' apartment.

**中文翻译:**
它依然很重要。但我刚开始为他们工作时，它还没那么出名，当时我只是个 16 岁的音乐宅男，在父母公寓的卧室里写唱片评论。

---

### [00:05:06] Lenny Rachitsky

**English:**
Okay, so what I'm hearing is you helped make them a big deal. Excellent. That's impact. We're going to talk all about impact.

**中文翻译:**
好吧，所以我听到的是你帮助他们变得举足轻重。太棒了，这就是影响力。我们今天就要大谈特谈影响力。

---

### [00:05:11] Matt LeMay

**English:**
If I were better at telling my own story, that's exactly what I'd be saying, is that before I started, I was product manager number one at Pitchfork.

**中文翻译:**
如果我更擅长讲自己的故事，我肯定会这么说：在我开始之前，我是 Pitchfork 的一号产品经理。

---

### [00:05:17] Lenny Rachitsky

**English:**
Funny enough, you look at your resume, you went into product management from Pitchfork. Very typical career path. By the way, if you're on YouTube watching, there's a lot of musical paraphernalia behind you, an awesome guitar, so clearly there's a thread of music throughout your background.

**中文翻译:**
有趣的是，看你的简历，你是从 Pitchfork 转行做产品管理的。非常典型的职业路径。顺便说一下，如果你在 YouTube 上观看，会看到你身后有很多音乐器材，一把很棒的吉他，显然音乐贯穿了你的背景。

---

### [00:05:31] Matt LeMay

**English:**
Yes.

**中文翻译:**
是的。

---

### [00:05:31] Lenny Rachitsky

**English:**
Let me ask you this question: what is most similar about making music, and even critiquing music, and building great product?

**中文翻译:**
让我问你这个问题：创作音乐、甚至评论音乐，与打造优秀的产品之间，最相似的地方是什么？

---

### [00:05:39] Matt LeMay

**English:**
The magic lies in the way people work together. That's really what I think has been the consistent thread between all the work that I've done. I spent years as a touring musician... It's that magic of people with different perspectives, different ideas, building into something that is somehow greater than the sum of its individual parts and perspectives. That's what makes this interesting. That's what makes music magical. That's what makes product development interesting, especially in the age of AI.

**中文翻译:**
魔力在于人们协作的方式。我认为这是我所有工作中的一贯主线。我当过多年的巡演音乐人……那种拥有不同观点、不同想法的人们共同构建出某种超越个体部分总和的东西，这就是魔力所在。这就是音乐的神奇之处，也是产品开发的有趣之处，尤其是在 AI 时代。

---

### [00:06:13] Matt LeMay

**English:**
When people have the opportunity to, I think, close themselves off from the messier parts of human interaction... I think that those interactions, that ability to learn from and build with each other, is only going to become more valuable and more precious, frankly, as technology continues to do what technology does.

**中文翻译:**
当人们有机会把自己从复杂的人际互动中封闭起来时……我认为，随着技术继续向前发展，那种相互学习、共同构建的能力，以及那些互动，坦率地说，只会变得更加有价值和珍贵。

---

### [00:06:44] Lenny Rachitsky

**English:**
Wow, what a beautiful answer.

**中文翻译:**
哇，多么美妙的回答。

---

### [00:06:45] Matt LeMay

**English:**
Thank you.

**中文翻译:**
谢谢。

---

### [00:06:47] Lenny Rachitsky

**English:**
I love that. So let's get to the task at hand.

**中文翻译:**
我很喜欢。那我们进入正题吧。

---

### [00:06:50] Matt LeMay

**English:**
Yes.

**中文翻译:**
好的。

---

### [00:06:51] Lenny Rachitsky

**English:**
So you're known for writing one of the most popular books in the field of product management called Product Management in Practice. Basically describes the job of a product manager very practically, very specifically, better than any other book out there. You have a new book out called Impact First Product Teams. I asked you what the goal of this book was and you said the goal was what are the steps that individual product teams can take to align their work to business critical outcomes, regardless of how their organizations approach product development?

**中文翻译:**
你因撰写了产品管理领域最受欢迎的书籍之一《产品管理实践》而闻名。它非常实际、具体地描述了产品经理的工作，比市面上任何其他书都好。你现在出了一本新书叫《影响力优先的产品团队》。我问过你这本书的目标是什么，你说目标是：无论组织如何看待产品开发，单个产品团队可以采取哪些步骤将工作与业务关键成果对齐？

---

### [00:07:32] Lenny Rachitsky

**English:**
And I thought this was a really nice way of framing this conversation. There's two important parts to the sentence that you gave me. One is aligning your work to business critical outcomes, and the other is steps an individual product team can take, regardless of other business functions. So let me start with this first part. This is kind of you named your book after this concept of impact, first: Why is aligning work to impact and to business critical outcomes so important?

**中文翻译:**
我认为这是开启对话的一个很好方式。你给我的那句话有两个重要部分：一是将工作与业务关键成果对齐，二是单个产品团队可以采取的步骤（不依赖于其他业务职能）。让我们从第一部分开始。你用“影响力优先”这个概念为书命名：为什么将工作与影响力和业务关键成果对齐如此重要？

---

### [00:07:51] Matt LeMay

**English:**
It's important because at the end of the day, it is those business critical outcomes against which you and your team will be evaluated. That's the reality of working for a business, right? If you are contributing to the business in a way that the business at large can understand, that the CEO can understand, that the CFO can understand, if your team is a good investment for the business, then the business will continue making that investment.

**中文翻译:**
这很重要，因为归根结底，你和你的团队是根据这些业务关键成果被评估的。这就是在企业工作的现实，对吧？如果你以一种整个公司、CEO、CFO 都能理解的方式为业务做贡献，如果你的团队对公司来说是一项好的投资，那么公司就会继续这项投资。

---

### [00:08:16] Matt LeMay

**English:**
If your team is not a good investment for the business or you don't really know if your team is a good investment for the business, but you figure you're showing up, so probably it's fine, you guess, then that puts you in a really tenuous position, and a position that I think we've all seen not work out terribly well for everybody in recent history.

**中文翻译:**
如果你的团队不是一项好的投资，或者你根本不知道你的团队是否是一项好的投资，只是觉得自己每天都出勤了，大概没问题吧——那么你就处于一个非常危险的境地。在最近的历史中，我们都看到这种境地对大家来说结果并不好。

---

### [00:08:36] Lenny Rachitsky

**English:**
And so, what is this a reaction to? Because I imagine many people hearing this are, like, "Of course, PMs, product teams we're driving business impact, well, that's why we're here." That's not actually the case in most cases. So first of all, just what is this reaction to? Is this the reaction to people being, like, "Oh, we're just going to build great products, we're going to listen to customers,"? Talk about the flip side of this.

**中文翻译:**
那么，这是对什么现象的反应？因为我想很多人听到这里会说：“当然了，PM 和产品团队就是在推动业务影响力，这就是我们存在的意义。”但在大多数情况下，事实并非如此。所以首先，这反映了什么？是对那些只想着“哦，我们只要打造好产品、听取客户意见就行了”的人的反应吗？谈谈另一面。

---

### [00:08:55] Matt LeMay

**English:**
I mean, there's a couple of things. I think the main one is just more product managers and teams are getting laid off. That's a really scary reality right now. And if you look at the messages that are being conveyed by CEOs when they lay off these teams, some of them are pretty clear. The message that Daniel Ek from Spotify sent out with their layoffs in 2024 said, "We still have too many teams doing work around the work and supporting work, rather than focusing on opportunities with real impact."

**中文翻译:**
我想有几点。最主要的一点是越来越多的产品经理和团队被裁员。这是目前一个非常可怕的现实。如果你看看 CEO 们在裁掉这些团队时传达的信息，有些是非常明确的。Spotify 的 Daniel Ek 在 2024 年裁员时说：“我们仍然有太多的团队在做‘围绕工作的琐事’和支持性工作，而不是专注于具有真正影响力的机会。”

---

### [00:09:25] Matt LeMay

**English:**
And that really struck a nerve because I've been on those supporting teams before. I've done the work around the work. And I've assumed that if I was given work around the work to do, that surely it must be critical to the business, otherwise they wouldn't have hired me to do it. I don't think that is a safe assumption to make.

**中文翻译:**
这真的触动了我的神经，因为我以前也待过那些支持性团队。我做过那些“围绕工作的琐事”。我曾假设，如果我被分配了这些琐事，那它们对业务肯定至关重要，否则他们不会雇我来做。但我认为这不再是一个安全的假设了。

---

### [00:10:12] Lenny Rachitsky

**English:**
Awesome. So where this comes from is, one, if you are not driving something that is directly driving business growth, you're not as valuable to the company. You're the kind of person that they'd lay off.

**中文翻译:**
太棒了。所以这源于：第一，如果你没有推动直接促进业务增长的事情，你对公司来说就没有那么大的价值。你就是那种会被裁掉的人。

---

### [00:10:23] Lenny Rachitsky

**English:**
There's also a flip side of finding a job. It feels like if you have shown impact in your resume, "Here's all the impact I've driven," this also helps you get hired. True?

**中文翻译:**
找工作也有另一面。感觉如果你在简历中展示了影响力，比如“这是我推动的所有影响力”，这也有助于你被录用。对吗？

---

### [00:10:31] Matt LeMay

**English:**
Absolutely. Yeah. I mean, it's the most common resume advice I see, is show the number, show the impact, say what you did. I have a friend who does resume coaching... She said, "I love your resume except for one thing. Why do you write like a little girl? Say what you did, say what your contributions were. Don't say 'I helped. I may have maybe helped people do this'. Say the impact. Put the number on it."

**中文翻译:**
绝对正确。这是我见过的最普遍的简历建议：展示数字，展示影响力，说明你做了什么。我有一个做简历辅导的朋友……她说：“我喜欢你的简历，除了一点。你为什么写得像个小女孩？说出你做了什么，说出你的贡献。不要说‘我提供了帮助，我可能帮人们做了这个’。说出影响力，放上数字。”

---

### [00:11:22] Matt LeMay

**English:**
And I think I needed to hear that from her because I think there is a tendency, especially for those of us who do really thrive in that collaborative environment... It's really hard to say, "Well, I did this and I contributed to that," but that's part of why I wrote this book at the team level, because I think for folks, like myself, who really enjoy and thrive in that team environment, if you can look at the product team as the foundational unit of impact and say, "We delivered this. We were able to work together to have this impact for the business," that feels really good.

**中文翻译:**
我想我需要听她这么说，因为我们中有些人确实在协作环境中茁壮成长，往往有一种倾向……很难说“我做了这个，我贡献了那个”。但这就是为什么我从团队层面写这本书的原因，因为对于像我这样喜欢团队环境的人来说，如果你能把产品团队视为影响力的基础单元，并说“我们交付了这个，我们能够共同努力为业务产生这种影响力”，那感觉会非常好。

---

### [00:11:49] Lenny Rachitsky

**English:**
That's a really interesting insight. I think a lot of this comes from just PMs naturally are trained to deflect credit and to include, say 'we' in everything and just this person did that. So I get where that comes from. So most listeners will probably still be thinking, "Yes, I'm driving impact, I'm great. I don't have a problem here. I don't to change, need to change anything." What are some ways to stress test your thinking? Maybe some questions to ask yourself or maybe your team of just, like, "Okay, maybe I'm not?"

**中文翻译:**
这是一个非常有趣的见解。我想这很大程度上是因为 PM 天生就被训练去推卸功劳，在所有事情中都说“我们”，或者说是某某人做的。所以我理解这种心态的来源。大多数听众可能仍在想：“是的，我正在产生影响力，我很棒。我这里没问题，不需要改变任何东西。”有哪些方法可以压力测试这种想法？也许可以问问自己或团队：“好吧，也许我并没有产生影响力？”

---

### [00:12:17] Matt LeMay

**English:**
So the first question I ask most of the teams I work with is if you were the CEO of this company, would you fully fund your own team? And that is a small question that can provoke some big reactions. Because, for me, when I was working as a product manager, I truly believed that my job was to find the next most defensible thing to build, build it, celebrate it, find the next most defensible thing to build, and so on and so forth. Rinse and repeat forever and ever.

**中文翻译:**
我问大多数合作团队的第一个问题是：如果你是这家公司的 CEO，你会全额资助你自己的团队吗？这是一个小问题，却能引起巨大的反应。因为对我来说，当我做产品经理时，我真心认为我的工作就是找到下一个最站得住脚的东西去构建，构建它，庆祝，然后再找下一个，如此循环往复。

---

### [00:13:13] Matt LeMay

**English:**
But the idea that my team came at a cost to the business, that at some point somebody might look at my team on a spreadsheet and say, "Who are these very expensive people? Why do we need them? Do we actually need them?" It just wasn't something that crossed my mind because I wasn't in the room for those conversations. That wasn't how I was thinking about my team's work.

**中文翻译:**
但我从未想过我的团队对业务来说是有成本的，从未想过某天有人会看着电子表格上的我的团队说：“这些昂贵的人是谁？我们为什么需要他们？我们真的需要他们吗？”我根本没想过这些，因为我不在那些讨论的现场。那不是我思考团队工作的方式。

---

### [00:13:52] Matt LeMay

**English:**
And frankly, most of the people I ask that question to don't know the answer right away. They're not sure. They say, "I think so," or, "Yeah, yeah. Yeah, because... " And then you can see the gears turning. And again, to me that is a risky situation to be in because if you can't answer that question as a member of the team, nobody else in the organization is going to be as well-equipped to answer that question as you are.

**中文翻译:**
坦白说，我问过的大多数人都不能立刻回答。他们不确定，会说“我想是吧”或者“是的，因为……”，然后你可以看到他们的大脑在飞速运转。对我来说，这是一种危险的处境，因为如果你作为团队成员都无法回答这个问题，组织中就没有其他人比你更有资格回答了。

---

### [00:14:50] Lenny Rachitsky

**English:**
So is kind of the signal here is if you can't confidently say yes, asking yourself this question or your team talking through this and having a clear answer, there's maybe a potential problem that you need to work on?

**中文翻译:**
所以这里的信号是，如果你不能自信地说“是”，或者当你问自己或团队这个问题时没有明确的答案，那么可能存在一个你需要解决的潜在问题？

---

### [00:15:01] Matt LeMay

**English:**
Absolutely. I think that's exactly it, yeah.

**中文翻译:**
绝对正确。我想正是如此。

---

### [00:15:04] Lenny Rachitsky

**English:**
And we'll talk about what to actually do and the steps you recommend to fix this problem, but I want to keep talking about impact because sometimes it takes a while for people to be convinced, "Okay, I need to really do this," versus, "Okay, here's the ways to do this."

**中文翻译:**
我们会讨论具体该怎么做，以及你推荐的解决步骤，但我还想继续聊聊影响力，因为有时候人们需要一段时间才能被说服“好吧，我真的需要这样做”，而不是直接跳到“好吧，这是做这件事的方法”。

---

### [00:15:22] Lenny Rachitsky

**English:**
I think the layoffs are a really good convincing function for people. Where they're seeing all these PMs being laid off and just, like, "How do I avoid that?" And this is basically the answer to that, is here's how you avoid getting laid off. There's an interesting implication in what you describe here where you encourage the PM and the product team to think like the CEO. This touches on something I've been meaning to write about, but I haven't, which is a lot of people, there's this argument are PMs the mini CEO?

**中文翻译:**
我认为裁员对人们来说是一个很好的说服机制。当他们看到这么多 PM 被裁时，会想：“我该如何避免这种情况？”而这基本上就是答案：这就是你避免被裁的方法。你在这里描述的内容有一个有趣的含义，即你鼓励 PM 和产品团队像 CEO 一样思考。这触及了我一直想写但还没写的东西，即很多人都在争论：PM 是“小 CEO”吗？

---

### [00:15:46] Lenny Rachitsky

**English:**
In my mind, the PM is 100% the mini CEO, in terms of they think like the CEO or they should within the team. They're the same; their job is to think about the business like a CEO within the team. Obviously they're not in charge of everyone. They can't let get anyone go. The reporting lines are not the same. But I feel like that's a really good lens for the job of a PM, is just you're like the mini CEO on a team, making sure you're building the right things, thinking about the business, solving real problems that matter.

**中文翻译:**
在我看来，PM 100% 是“小 CEO”，就他们在团队内部像 CEO 一样思考（或者应该这样思考）而言。他们的工作是在团队内部像 CEO 一样思考业务。显然，他们并不管辖所有人，不能解雇任何人，汇报关系也不同。但我觉得这是一个看待 PM 工作的很好视角：你就像团队里的“小 CEO”，确保构建正确的东西，思考业务，解决真正重要的问题。

---

### [00:16:19] Matt LeMay

**English:**
I think the way I've come to think about it is that the product manager is responsible for the whole team thinking like a CEO, if that makes sense.

**中文翻译:**
我想我现在的看法是：产品经理负责让“整个团队”像 CEO 一样思考，如果这能解释得通的话。

---

### [00:16:26] Lenny Rachitsky

**English:**
I love that.

**中文翻译:**
我喜欢这个说法。

---

### [00:16:27] Matt LeMay

**English:**
So if the product manager takes that on as their sole responsibility and says, "I'm the mini CEO. I think about the business," that's a missed opportunity. In my consulting work, it's more often than not been an engineer who's actually able to get to that specific impact-level goal for the team, sometimes before the product manager does, because the engineer is thinking in systems... Sometimes it's a designer or a UX researcher who understands what customers need.

**中文翻译:**
如果产品经理把这当作自己唯一的责任，说“我是小 CEO，我负责思考业务”，那就错失了机会。在我的咨询工作中，往往是工程师能先于产品经理触及团队的具体影响力目标，因为工程师在以系统化方式思考……有时是设计师或用户体验研究员，他们了解客户的需求。

---

### [00:17:02] Matt LeMay

**English:**
So I think the way that I certainly initially misinterpreted the mini CEO thing was you are solely in charge of this, as opposed to you are the person who brings that kind of CEO-level commercial thinking to the team. And I've been much more inclined of late to see the product manager's job as to bring in and facilitate that conversation, rather than to be the sole owner of that conversation.

**中文翻译:**
所以我认为，我最初对“小 CEO”的误解是你独自负责这件事，而不是你是那个将 CEO 级别的商业思维带入团队的人。最近我更倾向于认为，产品经理的工作是引入并促进这种对话，而不是成为这种对话的唯一所有者。

---

### [00:17:29] Lenny Rachitsky

**English:**
That is a really good nuance to what I said, and it makes all the sense in the world. Following these lines of what is the job for product manager, you have a really nice way of just thinking about it. What does a business expect from a product manager?

**中文翻译:**
这对我刚才说的话是一个非常好的补充，非常有道理。沿着产品经理职责这条线，你有一种很好的思考方式：企业对产品经理的期望是什么？

---

### [00:17:42] Matt LeMay

**English:**
Yeah. My favorite definition of product management comes from Melissa Perri's book Escaping the Build Trap, where she describes product management as facilitating a value exchange. You're facilitating a value exchange between a business and its customers. The actual shape and nature of that value exchange depends on so many things... B2B or B2C... publicly traded or privately held.

**中文翻译:**
是的。我最喜欢的产品管理定义来自 Melissa Perri 的书《走出构建陷阱》（Escaping the Build Trap），她将产品管理描述为“促进价值交换”。你在促进企业与其客户之间的价值交换。这种价值交换的具体形式和性质取决于很多因素……是 B2B 还是 B2C，是上市公司还是私有公司。

---

### [00:18:38] Matt LeMay

**English:**
So if that's a startup, how much runway do we have? What do we need to raise that next round? Are our investors looking for growth? Are they looking for profitability? ... If we're a publicly traded company, what are investors looking for? What have we told shareholders? ... This information usually exists somewhere, but it's really easy to get disconnected from it as we go about the day-to-day work of doing product management.

**中文翻译:**
如果是初创公司，我们的现金流还能撑多久？下一轮融资需要什么？投资者看重增长还是盈利？……如果是上市公司，投资者在看什么？我们对股东承诺了什么？……这些信息通常存在于某处，但在日常的产品管理工作中，我们很容易与这些信息脱节。

---

### [00:19:11] Matt LeMay

**English:**
I've been in a lot of rooms having workshops and sessions with teams I work with, where they're pulling up the last town hall meeting to look for slides from their CEO because they're so busy... But those top-level things, those promises that have been made to the market at large, to the board, to the shareholders, those are often a great place to start for understanding what exactly your business is looking for.

**中文翻译:**
我参加过很多团队研讨会，他们不得不翻出上次全员大会的视频来找 CEO 的幻灯片，因为他们太忙了……但那些顶层的东西，那些对市场、董事会、股东做出的承诺，通常是了解业务到底在追求什么的绝佳起点。

---

### [00:20:01] Lenny Rachitsky

**English:**
That's an amazing segue to exactly where I'd wanted to go, which is this quote that is exactly what you just said, the question you should be asking, it's kind of a different version of the one you shared earlier, which is what are we doing to contribute to the success of the business? So what is it that you think people are thinking instead most often?

**中文翻译:**
这是一个完美的过渡，正是我想要聊的。这句引用正是你刚才说的，你应该问的问题（也是你之前分享的那个问题的另一个版本）：我们正在做些什么来为业务的成功做出贡献？那么，你认为人们通常在想什么，而不是想这个问题？

---

### [00:20:21] Matt LeMay

**English:**
It's interesting. We live in a world where for the last 20 years of product development, we've been all about best practices. We love best practices. And I love best practices too... But I think the downside of this is that there are a lot of folks who are really, really fixated on doing things the right way. And a lot of the writing and thinking about doing things the right way exists in kind of this middle layer, between impact and day-to-day work.

**中文翻译:**
很有趣。在过去的 20 年里，产品开发领域一直崇尚“最佳实践”。我们热爱最佳实践，我也一样……但我认为其负面影响是，很多人过于执着于“以正确的方式做事”。而关于“正确做事”的大量文章和思考都存在于一个“中间层”，介于最终影响力和日常工作之间。

---

### [00:21:03] Matt LeMay

**English:**
So if you have impact, the overall success of the business, revenue, growth, profits. Then from there you set objectives and you do initiatives, and then you do bets, and then you make a strategy, and then you do your day-to-day work. I think the tendency among a lot of product teams is to key to those middle pieces, to say, "Okay, what we're doing is on strategy. What we're doing is part of objectives. We did OKRs, right? We spent three weeks coming up with our OKRs for three months."

**中文翻译:**
如果你有影响力，那就是业务的整体成功、收入、增长、利润。然后你设定目标、开展计划、进行押注、制定策略，最后才是日常工作。我认为很多产品团队的倾向是死磕那些中间环节，说：“好吧，我们做的事情符合策略，是目标的一部分。我们做了 OKR，对吧？我们花了三周时间来制定未来三个月的 OKR。”

---

### [00:21:41] Matt LeMay

**English:**
And at the end of the day, you've actually spent so much time and energy being really clever and cascading these things into these intermediate steps, that each step has incurred more and more risk that we might not achieve that impact we seek to drive. Each time we abstract things out... until we wind up with a checklist of features to build, we're assuming that if we then build that checklist of features... We will have a successful business.

**中文翻译:**
到头来，你花了大量时间和精力在这些中间步骤上玩弄聪明才智和层层分解，以至于每一步都增加了无法实现最终影响力的风险。每当我们把事情抽象化……直到最后变成一份要构建的功能清单时，我们就在假设：如果我们完成了这份功能清单，业务就会成功。

---

### [00:22:27] Matt LeMay

**English:**
But honestly, most of the companies and teams I work with, if I ask them how their lowest-level goals add up to their highest-level goals, they look at me like I just asked them the most impossible question in the world. Because by the time you get things down to that level, maybe it's going to work, maybe it's not going to work. There are assumptions baked into each of those levels.

**中文翻译:**
但老实说，我合作过的大多数公司和团队，如果我问他们最低层级的目标是如何累加到最高层级目标的，他们看我的眼神就像我问了一个世界上最不可能回答的问题。因为当你把事情分解到那个层级时，它可能奏效，也可能不奏效。每一层都掺杂了各种假设。

---

### [00:23:14] Matt LeMay

**English:**
But at the end of the day, I don't think I've ever worked for a company where these things add up to a perfect breadcrumb trail you can trace back from... It's just not how things work in the real world.

**中文翻译:**
但归根结底，我从未在任何一家公司见过这些东西能形成完美的路径，让你能一路追溯回去……现实世界根本不是这样运作的。

---

### [00:23:37] Lenny Rachitsky

**English:**
I feel like a lot of listeners are, like, "That sounds very familiar," exactly what you just described. Again, we're going to talk about what to change and how to make work better to actually align your teams with impact. But I want to first talk about something that follows this thread you're on, which is something you call the Low Impact PM Death Spiral. Talk about what that looks like.

**中文翻译:**
我觉得很多听众会觉得“这听起来非常熟悉”，就像你刚才描述的那样。同样，我们稍后会讨论如何改变，以及如何改进工作以使团队与影响力对齐。但我首先想谈谈顺着你刚才思路的一个概念，你称之为“低影响力产品经理死亡螺旋”。谈谈那是什么样子的。

---

### [00:23:59] Matt LeMay

**English:**
The Low Impact Death Spiral is the dynamic in which every medium to large company I've ever worked with finds itself in one way or another. And honestly, a lot of small product companies do as well, and it goes something like this. It starts with teams taking on low impact work. Adding little features here and there, making little cosmetic improvements because it's easier, it invites less scrutiny and you're less likely to mess up something important, right?

**中文翻译:**
“低影响力死亡螺旋”是我合作过的每一家中大型公司都会以某种方式陷入的动态。老实说，很多小型产品公司也是如此。过程大概是这样的：首先是团队承担低影响力的工作。到处添加小功能，做一些表面改进，因为这更容易，受到的审查更少，而且你不太可能搞砸重要的事情，对吧？

---

### [00:24:43] Matt LeMay

**English:**
The analogy I use sometimes is if you're working on a car, if you put your hands in the engine, you might make the car run really well or you might make it so that the car doesn't run at all. If you have the option of doing that or decking out the car with a paint job and rhinestones... what are you going to choose to do? I know for me, I would choose the rhinestones every time because then the car runs however it runs... but I'm going to do this thing which everyone can see.

**中文翻译:**
我有时用的比喻是修车。如果你动手修引擎，你可能让车跑得飞快，也可能让它彻底瘫痪。如果你可以选择修引擎，或者给车喷漆、贴满水钻……你会选哪个？我知道对我来说，我每次都会选贴水钻，因为那样车该怎么跑还怎么跑……但我做的这件事所有人都能看见。

---

### [00:25:15] Matt LeMay

**English:**
The problem is if you have 10 teams adding rhinestones to a car, eventually the hood of the car is going to be so heavy that you can't lift it to get to the engine anymore, and that's exactly what happens in most product organizations. As you have more and more teams adding in these little features... the product gets more and more complicated.

**中文翻译:**
问题是，如果你有 10 个团队在给车贴水钻，最终引擎盖会变得太重，以至于你再也无法掀开它去修引擎了。这正是大多数产品组织中发生的事情。随着越来越多的团队添加这些小功能……产品变得越来越复杂。

---

### [00:26:33] Matt LeMay

**English:**
The hood just gets heavier and heavier and heavier, which in turn sends teams deeper and deeper down the rabbit hole of low-impact work. Low-impact work begets low-impact work. The more low-impact work you do, the harder it is to do high-impact work... It goes and goes and goes until the next round of layoffs, and this is a real problem.

**中文翻译:**
引擎盖变得越来越重，这反过来又让团队在低影响力工作的泥潭里越陷越深。低影响力工作会催生更多的低影响力工作。你做的低影响力工作越多，就越难做高影响力的工作……这种情况一直持续到下一轮裁员。这是一个真实存在的问题。

---

### [00:27:01] Matt LeMay

**English:**
I've experienced this at again, pretty much every company I've worked with, and it's been really interesting to see how often the breaking of that cycle comes down to individual product teams being brave enough to look at their own work and look at what matters to the business and say, "You know what? We are not going to incur the risk of being a low-impact team anymore. We are going to proactively seek out high-impact work..."

**中文翻译:**
我在几乎每一家合作过的公司都经历过这种情况。非常有趣的是，打破这种循环往往取决于单个产品团队是否有足够的勇气审视自己的工作，审视对业务真正重要的事情，并说：“你知道吗？我们不再承担成为低影响力团队的风险了。我们要主动寻找高影响力的工作……”

---

### [00:27:47] Lenny Rachitsky

**English:**
As you just kind of alluded to, there's a big implication here of even if you are told to build a thing that the execs are really excited about, that is low impact in your opinion, that's no excuse. You're still going to get fired eventually, even though they're telling you to build it. It sucks, but that's how it goes.

**中文翻译:**
正如你刚才提到的，这里有一个重要的含义：即使你被要求构建一个高管们非常兴奋的东西，但如果你认为那是低影响力的，那也不能成为借口。即使是他们让你做的，你最终还是会被解雇。这很糟糕，但现实就是这样。

---

### [00:28:04] Matt LeMay

**English:**
It's funny, I worked with MailChimp for three years leading up to their acquisition by Intuit... They went into a domains model. They had different teams that were supposed to be experts on different parts of this marketing platform... and their VP product, Natalia Williams... she said, "This is great that we're doing this, but I'm worried that we're going to lose sight of the commercial fundamentals."

**中文翻译:**
很有趣，在 MailChimp 被 Intuit 收购前的三年里，我一直与他们合作……他们采用了领域模型（domains model）。不同的团队负责这个营销平台的不同部分……他们的产品副总裁 Natalia Williams（后来成为了 CPO）说：“我们这样做很好，但我担心我们会忽视商业基本面。”

---

### [00:29:31] Matt LeMay

**English:**
So she set a very clear goal for the product team. She wanted a specific change in the rate of users who successfully send their first email... And she set a really ambitious goal for the entire product organization. And she put it forth to the product teams and a lot of product teams were understandably hesitant to take this on... They said, "If we mess this up, that's the entire commercial heart of the business. That's really risky."

**中文翻译:**
于是她为产品团队设定了一个非常明确的目标。她希望成功发送第一封电子邮件的用户比例发生特定变化……她为整个产品组织设定了一个非常宏大的目标。她把这个目标交给产品团队，很多团队理所当然地犹豫是否要承担……他们说：“如果我们搞砸了，那可是业务的商业核心。这太冒险了。”

---

### [00:30:33] Matt LeMay

**English:**
There was one product manager I worked with who really understood how important this was... She came to me and she was like, "I want to make sure we do this because I'm worried about what'll happen if we don't do this, right? I don't want to be on the product team that failed to deliver what matters most to the business."

**中文翻译:**
我合作过的一位产品经理真正理解了这件事的重要性……她来找我说：“我想确保我们能做到这一点，因为我担心如果我们不做会发生什么。我不想待在一个未能交付对业务最重要成果的产品团队里。”

---

### [00:31:34] Matt LeMay

**English:**
She looks around the room and she says, "You know what? I'm going to haunt all of you in your dreams if you do not take this on. This is the most important thing for the business." And everyone laughed... She was like, "Look, this is really important and if we work together... we can get this done." And they did get it done, and they got it done through subtracting. They streamlined the experience. They took out steps that people were getting stuck on.

**中文翻译:**
她环视房间说：“听着，如果你们不承担这个任务，我会在梦里缠着你们。这是对业务最重要的事情。”大家都笑了……她说：“看，这真的很重要，如果我们齐心协力……我们就能完成。”他们确实做到了，而且是通过“减法”做到的。他们简化了体验，去掉了让用户卡住的步骤。

---

### [00:32:48] Lenny Rachitsky

**English:**
That was an awesome example. I love just how much of a hero's journey this example is. Along those lines, it's interesting how much courage it takes to do this. Because to your point, the easy thing is just, "Okay, everyone's just telling us to do this thing. We're going to build this feature. Great, easy. I don't have to put myself out there." And what you're pointing out there is it's up to you to recognize what you're doing is not high impact and to have courage to push back and suggest something else.

**中文翻译:**
这是一个很棒的例子。我喜欢这个例子中的“英雄之旅”色彩。顺着这个思路，做这件事需要多大的勇气，这很有趣。因为正如你所说，容易的做法是：“好吧，大家都让我们做这个，我们就构建这个功能。太棒了，简单，我不需要承担风险。”而你指出的是，认清你正在做的事情并非高影响力，并有勇气拒绝并提出其他建议，这取决于你自己。

---

### [00:33:15] Matt LeMay

**English:**
The funny thing is, it's courage, but it's also a kind of radical acceptance of reality. There's a very kind of emotional philosophical dimension to this conversation because I think it is in human nature to not want to be accountable for things outside of our control. Impact is not something we can just check off a list.

**中文翻译:**
有趣的是，这不仅是勇气，也是一种对现实的“彻底接纳”。这次对话有一种情感和哲学层面的意义，因为我认为不愿对无法控制的事情负责是人类的天性。影响力不是我们可以从清单上勾掉的东西。

---

### [00:34:26] Matt LeMay

**English:**
And you can follow all the best practices and have the highest velocity and do everything quote-unquote "right", but if your company goes out of business, they're not going to say, "Yeah, we're going out of business, but we're going to keep writing your paycheck for two years because all of your OKRs were a 0.6 or a 0.7." That's not how it works.

**中文翻译:**
你可以遵循所有的最佳实践，拥有最高的开发速度，做所有所谓“正确”的事情，但如果你的公司倒闭了，他们不会说：“是的，我们要倒闭了，但我们会继续给你发两年工资，因为你的 OKR 分数都是 0.6 或 0.7。”现实并非如此。

---

### [00:35:06] Matt LeMay

**English:**
The thing that surprised me most when I was researching this book is that the commercially minded PMs I interviewed were also the happiest, which I did not expect at all... They were just like, "Yeah, I work for a business and I do the best I can, and then I go home. When I'm at work, my job is to help the business succeed."

**中文翻译:**
我在调研这本书时最令我惊讶的是，我采访的那些具有商业头脑的 PM 也是最快乐的，这完全出乎我的意料……他们只是觉得：“是的，我为一家公司工作，我尽力而为，然后回家。在公司时，我的工作就是帮助业务成功。”

---

### [00:36:36] Matt LeMay

**English:**
I hope so. I'm always super, again, it's outside of my control. I can't say, if you do these things, then you will be looked upon favorably by the people who manage you because I don't know those people... What I will say is there's a story in the book... about somebody who worked for a dating app... they went to the finance team and said, "Hey, we have to adjust this down." And the finance team said, "Yeah, of course you do. That makes sense."

**中文翻译:**
我希望如此。同样，这超出了我的控制。我不能说如果你做了这些事，你的上司就一定会看重你，因为我不认识那些人……我想说的是书里的一个故事……关于一个在约会软件工作的人……他们去找财务团队说：“嘿，我们必须下调这个预期。”财务团队说：“是的，当然，这很合理。”

---

### [00:38:29] Lenny Rachitsky

**English:**
My sense is either you will be respected more highly because you are kind of solving problems for people, like higher ups that you're seeing, things that they should be seeing... Or you realize this is not the company for me. They don't value this. They just want me to ship this widget and that's all they want from me.

**中文翻译:**
我的感觉是，要么你会因为帮上司解决了他们应该看到的问题而获得更高的尊重……要么你会意识到这家公司不适合你。他们不看重这些，他们只想让你交付这个小组件，仅此而已。

---

### [00:39:28] Matt LeMay

**English:**
And I think the more you can understand how the business model works, what that value exchange is... that I think puts you in a better position to decide, if I were to help the company achieve success, do I feel good about that? Do I feel like this is a company that if it achieves its goals has made the world a better place or not?

**中文翻译:**
我认为你越了解商业模式是如何运作的，价值交换是什么……你就越能更好地决定：如果我帮助公司取得成功，我感觉好吗？我觉得这是一家实现了目标就能让世界变得更好的公司吗？

---

### [00:40:07] Lenny Rachitsky

**English:**
Today's episode is brought to you by Anthropic, the team behind Claude. I use Claude at least 10 times a day... Claude just becomes part of your workflow. If you want to try it out, get started at claude.ai/lenny and using this link, you get an incredible 50% off your first three months of the pro plan. That's claude.ai/lenny.

**中文翻译:**
今天的节目由 Anthropic 赞助，他们是 Claude 的开发团队。我每天至少使用 Claude 10 次……Claude 已经成为了我工作流的一部分。如果你想尝试，请访问 claude.ai/lenny，使用此链接，你可以享受前三个月专业版 50% 的惊人折扣。地址是 claude.ai/lenny。

---

### [00:41:24] Lenny Rachitsky

**English:**
Okay, so let's shift to talking about how to actually, what to do. This concept of actions you can take regardless of how your company operates. And that first part is really important. Something that I've seen you big on is you don't let people have an excuse for not pushing on this.

**中文翻译:**
好，那我们转入正题，谈谈具体该怎么做。即无论公司如何运作，你都可以采取的行动。第一部分非常重要。我发现你非常坚持的一点是：不让人们有借口不去推动这件事。

---

### [00:41:51] Matt LeMay

**English:**
Yeah, I mean, the reality is that most companies that product managers work at aren't big tech companies... the first thing they usually tell me is, "Well, we can't do product the right way because we're a regulated industry," or, "because we're B2B," or, "because we have these quarterly earnings targets we need to hit."

**中文翻译:**
是的，现实是大多数产品经理工作的公司并不是大型科技公司……他们通常告诉我的第一件事是：“好吧，我们无法以‘正确的方式’做产品，因为我们是受监管行业”，或者“因为我们是 B2B”，或者“因为我们有必须达成的季度盈利目标”。

---

### [00:42:49] Matt LeMay

**English:**
But the other way of looking at it is that those constraints are how you do product management. Those are what guides you to the commercial decisions you should be making. If you're regulated, your competitors are regulated too. If you can really understand those constraints, figure out how to work well within them, that's a huge commercial advantage for your business.

**中文翻译:**
但另一种看待方式是：这些约束正是你进行产品管理的方式。它们引导你做出应有的商业决策。如果你受监管，你的竞争对手也受监管。如果你能真正理解这些约束，并找出在其中高效工作的方法，那就是你业务巨大的商业优势。

---

### [00:44:23] Lenny Rachitsky

**English:**
Okay. So I think that's really empowering. You're not saying, "You need to change the way product is built at your company. It's up to you. You're an ICPM, it's up to you. No excuses." What's a simple way to describe what you're actually saying, which I think is going to make people feel a lot better?

**中文翻译:**
好的。我认为这非常鼓舞人心。你不是在说“你需要改变公司构建产品的方式”，而是说“这取决于你，你是一名 ICPM，这取决于你，没有借口”。有没有一种简单的方式来描述你真正想表达的意思？我觉得这会让人们感觉好很多。

---

### [00:44:38] Matt LeMay

**English:**
What I'm actually saying is that the things you think you're fighting against are usually the things that are giving your work shape, if you let them be.

**中文翻译:**
我真正想说的是：如果你愿意接受，那些你认为正在与之抗争的东西，通常正是赋予你工作形态的东西。

---

### [00:44:59] Matt LeMay

**English:**
Yeah, so the first step, and I think the most important and where a lot of my work plays out is in setting team goals, close to company goals. No more than one step away from company goals. This idea comes from Christina Wodtke's book Radical Focus.

**中文翻译:**
是的，第一步，也是我认为最重要的一步，同时也是我大部分工作的落脚点，就是设定团队目标，使其贴近公司目标。与公司目标的距离不要超过一个层级。这个想法源自 Christina Wodtke 的书《极简 OKR》（Radical Focus）。

---

### [00:45:24] Matt LeMay

**English:**
But in that book, she has this visual where she says that most companies approach cascading OKR as kind of this multi-level... She has a visual that she compares that to, which is the company goal as a center of gravity, and then every other team goal orbiting one level around it. And this blew my mind when I saw it for the first time.

**中文翻译:**
在那本书中，她展示了一个视觉图，她说大多数公司将 OKR 的层层分解看作是多层级的……她将其比作：公司目标是重心，而其他所有团队目标都围绕它在同一层级轨道上运行。我第一次看到这个图时感到非常震撼。

---

### [00:46:42] Matt LeMay

**English:**
And this was a really challenging conversation for this team because as much as people complain about being feature factories, again, it feels safer, right? There's more control over that. If you're told what to build, you have a lot more control over whether or not you build it than you do over whether or not it generates revenue.

**中文翻译:**
这对团队来说是一个非常具有挑战性的对话，因为尽管人们抱怨自己是“功能工厂”，但同样，这感觉更安全，对吧？对此有更多的控制权。如果你被告知要构建什么，你对是否构建它有很大的控制权，但你对它是否产生收入却没有控制权。

---

### [00:47:26] Matt LeMay

**English:**
And one of the team leaders said, "Oh, well actually, the customer lifetime value of a multi-product user is much higher than that of a single-product user." I was like, "Oh, do we know how much higher?" And they said, "Yeah, we actually have a number on that." And I was like, "Wow. So if we had a goal of converting a certain number of single-product users to multi-product users, we know exactly how much revenue is on the line."

**中文翻译:**
其中一位团队领导说：“哦，实际上，多产品用户的客户终身价值（CLV）比单一产品用户高得多。”我问：“哦，我们知道高出多少吗？”他们说：“是的，我们确实有具体数字。”我说：“哇。所以如果我们设定一个目标，将一定数量的单一产品用户转化为多产品用户，我们就确切知道这涉及多少收入。”

---

### [00:48:22] Matt LeMay

**English:**
And when they went and shared that goal with company leadership, they got it right away. They didn't have to say, "Well, why is this valuable?" ... And that process of arriving at that goal, that goal that is impactful and specific and one step away from what the company cares about the most, is probably the most valuable way I have spent my time with teams of late.

**中文翻译:**
当他们去向公司领导层分享这个目标时，领导层立刻就明白了。他们不需要解释“为什么这有价值”……这个达成目标的过程——那个具有影响力、具体且与公司最关心的目标仅一步之遥的目标——可能是我最近与团队合作中最有价值的方式。

---

### [00:49:11] Lenny Rachitsky

**English:**
So one extreme is... it probably doesn't make sense for your team to have exactly the same goal as the company... The other end is just some 10 level deep, we're going to improve conversion of this random step, which is going to grow this thing which grows that, and then that grows revenue.

**中文翻译:**
所以一个极端是……让你的团队拥有和公司完全一样的目标可能没意义……另一个极端则是深达 10 层的分解：我们要提高这个随机步骤的转化率，从而增长这个东西，进而增长那个东西，最后增加收入。

---

### [00:49:43] Matt LeMay

**English:**
I think, again, it depends. I know people have very strong opinions about teams should always or should never have revenue-based goals... I think that there are certainly situations where revenue goals would be too broad... but at the end of the day, money is how the impact of most teams is going to be measured.

**中文翻译:**
我认为这还是取决于具体情况。我知道人们对于团队是否应该拥有基于收入的目标有非常强烈的看法……我认为确实有些情况下收入目标会太宽泛……但归根结底，金钱是衡量大多数团队影响力的标准。

---

### [00:51:47] Matt LeMay

**English:**
So, I worked with a growth team at a tech company... They had read a lot of other books. They had printed out a lot of articles and they said, "We're going to make sure we get this right. We're going to put together a slide deck that has five to seven objectives with five to seven key results each..."

**中文翻译:**
我曾与一家科技公司的增长团队合作……他们读了很多其他的书，打印了很多文章，然后说：“我们要确保做对。我们要准备一份幻灯片，包含 5 到 7 个目标，每个目标有 5 到 7 个关键结果……”

---

### [00:52:39] Matt LeMay

**English:**
They spent a long time working on these OKRs, OKR season ends. They file away the OKR deck not to be seen until the next OKR season. We reconvene, and spend a whole day scoring all of the OKRs... And I'm like, "There's just one question I need to ask... how does this all add up to the company level growth goals?"

**中文翻译:**
他们花了很长时间制定这些 OKR，OKR 季结束了。他们把 OKR 幻灯片存档，直到下一个 OKR 季才会再看。我们再次集合，花了一整天给所有的 OKR 打分……我说：“我只需要问一个问题……这一切是如何累加到公司层级的增长目标上的？”

---

### [00:53:50] Matt LeMay

**English:**
And there's a moment of silence. And the leader of this team's a really, really good leader. She stands and she's like, "Okay, we're going to do things differently." She steps up to the whiteboard, puts 1 million on the right end of the whiteboard, draws a line, "This is the year... This is where we are now... If our conversation doesn't start with this, I don't want to have the conversation."

**中文翻译:**
现场陷入了沉默。这个团队的领导者非常优秀，她站起来说：“好吧，我们要换种做法。”她走到白板前，在右端写下 100 万，画了一条线，“这是今年……这是我们现在的进度……如果我们的对话不从这里开始，我就不想谈了。”

---

### [00:55:38] Lenny Rachitsky

**English:**
And it's so obvious if you come at it from the perspective you shared earlier. If you're the CEO, would you fund this team? If you see our goal is a million users, this team will drive us a hundred thousand users... The trick is a lot of people think they're doing that and they're not.

**中文翻译:**
如果你从之前分享的视角来看，这太显而易见了。如果你是 CEO，你会资助这个团队吗？如果你看到我们的目标是 100 万用户，而这个团队能带来 10 万用户……诀窍在于，很多人以为自己正在这样做，但实际上并没有。

---

### [00:56:26] Matt LeMay

**English:**
In some cases, like the story I told about that FinTech company, it's something like upgraded users. That's one step, right? You multiply that by the increased customer lifetime value. In some cases, it's a smaller unit of the same thing. So it's a subset of the revenue or growth that the company's trying to deliver.

**中文翻译:**
在某些情况下，就像我讲的那个金融科技公司的故事，目标是“升级用户”。这只有一步之遥，对吧？你用它乘以增加的客户终身价值。在某些情况下，它是同一事物的较小单元，即公司试图实现的收入或增长的一个子集。

---

### [00:57:06] Matt LeMay

**English:**
I worked with a company recently that had a team rebuilding their ad tech platform... I said, "Okay, what are your goals?" And they said, "Here's the deck with our goals." I said, "That's a lot of goals. I wouldn't be able to make decisions with those goals." They said, "Oh wait, wait, wait, no, we also have a Miro board..."

**中文翻译:**
我最近合作的一家公司有一个团队正在重建他们的广告技术平台……我问：“好吧，你们的目标是什么？”他们说：“这是我们的目标幻灯片。”我说：“目标太多了，我没法根据这些目标做决定。”他们说：“哦等等，不，我们还有一个 Miro 看板……”

---

### [00:57:56] Matt LeMay

**English:**
And we came up with two options. One was build a fantastic... platform to increase our team's profits by 20%. The other one was, build a stupendous... platform to increase our team's profits in the next financial year from 20 million pounds to a hundred million pounds.

**中文翻译:**
我们提出了两个选项。一个是构建一个极好的平台，将我们团队的利润提高 20%。另一个是构建一个了不起的平台，在下一个财年将我们团队的利润从 2000 万英镑提高到 1 亿英镑。

---

### [00:59:22] Matt LeMay

**English:**
So they have this number and they start to go like, "Oh gosh, that's a lot, but it's a whole financial year. It'll be fine." And we do, again, inspired by that leader I worked with, I just put this out on a whiteboard. I'm like, "All right, a hundred million in profits by the end of the next financial year right now we're here. What else should be on this timeline?"

**中文翻译:**
他们拿到了这个数字，开始想：“天哪，这很多，但那是整个财年的目标，会没事的。”受我合作过的那位领导者的启发，我把这个画在白板上。我说：“好吧，下财年结束前实现 1 亿利润，现在我们在这里。这条时间线上还应该有什么？”

---

### [01:00:06] Matt LeMay

**English:**
And this team, I was worried they were going to freak out... But they were like, "Okay, it's time to step up. It's time to do all these things that we need to do. We need to ship sooner. We need to do more validation. We need to do more testing. Can we commercialize things sooner?"

**中文翻译:**
我本来担心这个团队会吓坏……但他们说：“好吧，是时候行动了。是时候做所有我们需要做的事情了。我们需要更早交付，需要做更多验证，需要做更多测试。我们能更早实现商业化吗？”

---

### [01:01:29] Lenny Rachitsky

**English:**
These stories are awesome. So basically, so far, the two steps that you've illustrated here of doing this correctly, step one is set team goals that are close to company goals. And then step two is, do this at every step of the product building process. It's not just a one-time thing at the beginning.

**中文翻译:**
这些故事太棒了。所以基本上，到目前为止，你阐述的正确执行的两个步骤是：第一步，设定贴近公司目标的团队目标；第二步，在产品构建过程的每一步都这样做，而不仅仅是开始时的一次性工作。

---

### [01:02:18] Matt LeMay

**English:**
Step three is to connect every bit of work back to impact. So this is when we get to the prioritization piece, right. So impact estimation is something that is written about quite well... but it's something that it's easy to not do.

**中文翻译:**
第三步是将每一项工作都关联回影响力。这就是我们谈到优先级排序的地方。关于“影响力估算”已经有很多很好的论述……但这是一件很容易被忽略的事情。

---

### [01:03:13] Matt LeMay

**English:**
So that team I told you about that had the goal of converting single product users to multi-product users... one of the product managers... said, "Hey, Matt, I could really use your help figuring out how to do prioritization. Should we do ICE? Should we do RICE? Should we do MoSCoW?"

**中文翻译:**
我提到的那个要把单一产品用户转化为多产品用户的团队……其中一位产品经理说：“嘿，Matt，我真的需要你帮我弄清楚如何做优先级排序。我们应该用 ICE、RICE 还是 MoSCoW？”

---

### [01:04:18] Matt LeMay

**English:**
And understandably, they were kind of like, "Oh, you know what? I don't know exactly." I'm like, "Let's, just work through it. We don't have to be precise. It's called impact estimation, not impact getting perfect number."

**中文翻译:**
可以理解，他们会说：“哦，你知道吗？我也不太确定。”我说：“让我们试着推导一下。我们不需要精确。这叫‘影响力估算’，而不是‘获取影响力的完美数字’。”

---

### [01:05:08] Matt LeMay

**English:**
I'm like, "That sounds amazing." What's the most impact that could have? They were like, "It would get us all the way there if we did it right, but we'd have to work with these other teams and we'd have to work with marketing. And there are so many dependencies..."

**中文翻译:**
我说：“这听起来太棒了。”这能产生的最大影响力是多少？他们说：“如果我们做对了，它能让我们直接达成目标，但我们必须与其他团队合作，必须与市场部合作。而且有太多的依赖关系……”

---

### [01:06:11] Matt LeMay

**English:**
So the way that third step manifests itself the most frequently, tactically is are we estimating and measuring impact in the same unit of measure as our goals? Because if we're doing that, then we're keeping ourselves honest and we're saying, "Does this actually have a chance of contributing?"

**中文翻译:**
因此，第三步在战术上最常见的体现方式是：我们是否在以与目标相同的衡量单位来估算和衡量影响力？因为如果我们这样做，我们就是在对自己诚实，我们会问：“这真的有贡献的机会吗？”

---

### [01:06:51] Lenny Rachitsky

**English:**
Such an important and often easily overlooked point. This idea that when you're doing RICE or whatever version of ICE that you do, that impact should be based on impact to your goal, which is one level removed from the company goal.

**中文翻译:**
这是一个非常重要且经常被忽视的点。即当你做 RICE 或任何版本的 ICE 时，影响力应该基于对你目标的贡献，而你的目标与公司目标仅一层之隔。

---

### [01:07:58] Lenny Rachitsky

**English:**
Speaking of boundaries, a lot of the advice you share will involve people saying no, and pushing back, and convincing people they're wrong, which is very hard. That's not a natural happy place for most people.

**中文翻译:**
说到界限，你分享的很多建议都涉及拒绝、回绝以及说服别人他们错了，这非常困难。对大多数人来说，这并不是一个自然感到舒适的领域。

---

### [01:08:24] Matt LeMay

**English:**
So this is where I have the benefit, I suppose, of being a conflict-averse, people pleaser. So I've been through this, and I think the thing I am proudest of saying in product management and practice is that if you're doing product management really well, you never have to say yes and you never have to say no. You're giving people options and you're helping them understand the trade-offs.

**中文翻译:**
我想，在这方面我的优势在于我是一个回避冲突、讨好型人格的人。我经历过这些，我在《产品管理实践》中最自豪的一句话是：如果你产品管理做得非常好，你永远不需要说“是”，也永远不需要说“不”。你是在给人们提供选项，并帮助他们理解权衡（trade-offs）。

---

### [01:09:16] Matt LeMay

**English:**
Furthermore, I've found myself in situations where they just know things that I don't know... It is quite possible that the folks who are asking you to do things that don't make sense, have access to information that you don't. And that in trying to convince them otherwise, you are not only going to fail, but you are going to lose some of that trust...

**中文翻译:**
此外，我发现有些情况下，他们只是知道一些我不知道的事情……很有可能那些要求你做一些看起来没意义的事情的人，掌握着你没有的信息。如果你试图说服他们放弃，你不仅会失败，还会失去一部分信任……

---

### [01:10:48] Matt LeMay

**English:**
You're not saying no, you're not saying yes. You're helping someone who is in a position to make a decision, understand the trade-offs that go into that decision. And again, if you can do that, you're going to go home at the end of the day feeling better.

**中文翻译:**
你既没说不，也没说是。你是在帮助有决策权的人理解该决策背后的权衡。同样，如果你能做到这一点，你一天工作结束回家时感觉会更好。

---

### [01:11:33] Matt LeMay

**English:**
Absolutely. Options and a recommendation is kind of the magic formula. I did when I was working with MailChimp, we actually did a workshop... It was amazing how when you present a single option, people's instinct is just to, well, I don't know, you start poking holes in it.

**中文翻译:**
绝对正确。“选项加建议”就是那个神奇的公式。我在 MailChimp 工作时，我们做了一个研讨会……令人惊讶的是，当你只提供一个选项时，人们的本能就是，嗯，我不知道，然后开始挑刺。

---

### [01:12:35] Lenny Rachitsky

**English:**
I feel like people might miss that nuance, in the way we talked about it, so I think that a really important point to make there. Let me come back to the three steps... Step one is, set team goals close to company goals. Step two is keep impact first at every step... And then, step three is connect every bit of work back to impact.

**中文翻译:**
我觉得人们可能会忽略我们讨论中的那个细微差别，所以我认为那是一个非常重要的点。让我回顾一下这三个步骤：第一步，设定贴近公司目标的团队目标；第二步，在每一步都保持影响力优先；第三步，将每一项工作都关联回影响力。

---

### [01:13:56] Matt LeMay

**English:**
It's funny, the teams I've worked with, when things are going well, are sometimes just as anxious as the teams I've worked with, when things are going poorly, because they have a hard time attributing success to what they're doing, right? They'll look at it and they'll say, "Yeah, we're doing great. But I think that honestly has more to do with marketing than it does with us."

**中文翻译:**
很有趣，我合作过的一些团队在情况良好时，有时和情况糟糕时一样焦虑，因为他们很难将成功归功于自己正在做的事情，对吧？他们会看着数据说：“是的，我们做得很好。但老实说，我觉得这更多是市场部的功劳，而不是我们的。”

---

### [01:15:21] Matt LeMay

**English:**
One thing that makes me sad is when teams look upon each other with envy and disgust, right, when it's, "This team's doing, they're doing great work, but they're not held to the same standards that we are..." It's like, "Go talk to them, because there's probably something you can learn from them."

**中文翻译:**
让我感到难过的一件事是团队之间互相嫉妒和厌恶，比如：“那个团队做得很好，但他们没有像我们这样受到严格要求的约束……”其实你应该去和他们聊聊，因为很可能有些东西是你可以向他们学习的。

---

### [01:16:53] Matt LeMay

**English:**
I mean, I love the, "Would you fund this team, if you were the CEO question?" ... So, a gentler way of bringing that up is to say, "What's one sentence you'd want to be able to say at the end of this year, that would leave you feeling awesome about this team's work?"

**中文翻译:**
我非常喜欢“如果你是 CEO，你会资助这个团队吗？”这个问题。一种更温和的提问方式是：“在今年年底，你最想说的一句话是什么，能让你对这个团队的工作感到非常自豪？”

---

### [01:18:03] Lenny Rachitsky

**English:**
Bam. Matt, is there anything else that you wanted to cover or leave listeners with before we get to a very exciting lightning round?

**中文翻译:**
太棒了。Matt，在进入令人兴奋的闪电轮环节之前，还有什么你想涵盖或者留给听众的内容吗？

---

### [01:18:31] Lenny Rachitsky

**English:**
That's empowering stuff. With that, we've reached our very exciting lightning round. Are you ready?

**中文翻译:**
这些内容非常鼓舞人心。那么，我们进入了非常刺激的闪电轮环节。准备好了吗？

---

### [01:18:43] Matt LeMay

**English:**
Radical Focus, by Christina Wodtke, is obviously, I cite it a lot in my book, I think it's the best book about OKRs... The other book, this is a bit of a curveball, is by Alan Watts, the Buddhist philosopher. It's called The Wisdom of Insecurity.

**中文翻译:**
Christina Wodtke 的《极简 OKR》（Radical Focus），我在书里经常引用它，我认为它是关于 OKR 最好的书。另一本书可能有点出人意料，是佛教哲学家 Alan Watts 写的，书名叫《不安全感的智慧》（The Wisdom of Insecurity）。

---

### [01:20:41] Matt LeMay

**English:**
God. So especially, when I'm in work-y write-y mode, my brain shuts off to all things that are not trash. So I have been watching a lot of trash. I watched Temptation Island, the new season of Temptation Island on Netflix. I loved it so much.

**中文翻译:**
天哪。尤其是在我处于工作和写作模式时，我的大脑会屏蔽掉所有非“垃圾内容”的东西。所以我一直在看很多垃圾节目。我看了 Netflix 上的新一季《诱惑岛》（Temptation Island）。我太喜欢它了。

---

### [01:21:37] Matt LeMay

**English:**
Yeah, so I'm really glad you asked this question, because as a musician, I live in this world of niche products... the first thing that came to mind was this, which is made by an amplifier builder who goes by Milkman Sound... it fits into this handy, compact, lightweight form factor.

**中文翻译:**
我很乐意回答这个问题，因为作为一名音乐人，我生活在小众产品的世界里……我首先想到的是这个，由一位名叫 Milkman Sound 的放大器制造者制作……它采用了这种方便、紧凑且轻便的外形设计。

---

### [01:24:17] Matt LeMay

**English:**
I come back to something my mom told me... she said, "I really believe that no good work is wasted. Even if you don't see it right away, when you put good work out into the world, even if it only finds a few people, it's never wasted."

**中文翻译:**
我经常想起我妈妈告诉我的话……她说：“我坚信，没有任何一份好的工作会被浪费。即使你没有立即看到回报，当你把好的作品带到这个世界上，即使它只影响了少数人，它也从未被浪费。”

---

### [01:26:23] Matt LeMay

**English:**
I am a villain, in certain corners of the internet... for the review I wrote of Liz Phair's self-titled album. I wrote this review when I was 19, when my worldview was toxic... It was a really condescending, arrogant review... I apologized for that review in 2019.

**中文翻译:**
在互联网的某些角落，我被视为反派……因为我为 Liz Phair 的同名专辑写的乐评。我写那篇乐评时才 19 岁，当时的世界观很偏激……那是一篇非常居高临下、傲慢的评论。我在 2019 年为那篇评论道歉了。

---

### [01:30:22] Lenny Rachitsky

**English:**
Matt, this was awesome. We covered so much ground... Where can folks find you online, talk about the sort of work you do with companies, and how can listeners be useful to you?

**中文翻译:**
Matt，这太棒了。我们涵盖了这么多领域……大家可以在哪里找到你，了解你与公司合作的工作，以及听众可以如何帮助你？

---

### [01:30:29] Matt LeMay

**English:**
Yeah, so you can find me online at matlemay.com... I hope that I can be useful to you, and having these conversations in a way that's less scary, more accessible, and leads you down that road to doing impactful work.

**中文翻译:**
是的，你可以在 matlemay.com 找到我……我希望我能对你们有所帮助，以一种不那么可怕、更易于接受的方式进行这些对话，并引导你们走上从事影响力工作的道路。

---

### [01:31:15] Matt LeMay

**English:**
Impact-First Product Teams. You can find it at all the places where you find books, on Amazon. There's an author read audiobook... I did all the musical interludes myself.

**中文翻译:**
书名是《影响力优先的产品团队》（Impact-First Product Teams）。你可以在亚马逊等所有售书的地方找到它。还有一个作者亲自朗读的音频书……所有的音乐间奏都是我自己做的。

---

### [01:31:41] Lenny Rachitsky

**English:**
Thanks so much, Lenny. This was great. Bye, everyone.

**中文翻译:**
非常感谢，Lenny。这太棒了。大家再见。