# Matt MacInnis - 双语对照

This is the complete bilingual transcript for Lenny’s Podcast featuring Matt MacInnis (CPO of Rippling).

---

### [00:00:00] Matt MacInnis

**English:**
It is really important to me that we feel that we've deliberately understaffed every project at the company. If you overstaff, you get politics, you get people working on things that are further down the priority list than necessary. That is poison. It's wasteful. It slows you down. It creates cruft.

**中文翻译:**
对我来说非常重要的一点是，我们要感觉到公司里的每一个项目都是刻意保持人员不足的。如果你人员过剩，就会产生办公室政治，会导致人们去处理那些优先级并不高的琐事。那是毒药。它既浪费资源，又会拖慢速度，还会产生冗余（cruft）。

---

### [00:00:15] Lenny Rachitsky

**English:**
You've been a long time COO at Rippling. Recently, you moved into CPO, Chief Product Officer at Rippling. Something you talk a lot about is that extraordinary results require extraordinary efforts.

**中文翻译:**
你长期担任 Rippling 的首席运营官（COO）。最近，你转任 Rippling 的首席产品官（CPO）。你经常谈到的一点是：非凡的结果需要非凡的努力。

---

### [00:00:26] Matt MacInnis

**English:**
If you want to be in the 99th percentile in terms of outcomes, it's going to be really difficult. You got to sort of remind people that if they ever find themselves in the comfort zone at work, they are definitely making a mistake. It's supposed to be really fricking exhausting.

**中文翻译:**
如果你想在结果上达到前 1% 的顶尖水平，那过程会非常艰难。你必须提醒大家，如果他们在工作中感到处于“舒适区”，那他们绝对是犯了错误。这本来就应该是极其累人的。

---

### [00:00:40] Matt MacInnis

**English:**
Fundamentally, the most selfish thing you can do is withhold feedback from someone. When you think a thought that would help someone improve and you avoid giving it to them because it would make you uncomfortable. Well, you're optimizing for your own comfort, and it's fundamentally selfish. So many people have teams that are not functioning incredibly well. Teams will always optimize for local comfort over company outcomes. The purest form of ambition and most intense source of energy in the business is the founder CEO. Every next concentric circle of management beyond the founder CEO has the potential to be an order of magnitude drop off in intensity. That is fucking dangerous.
(00:01:17):
As an executive, as a leader, your job is to preserve that intensity at its highest possible level. You've had a couple really interesting experiences with your own startup. We talk in Silicon Valley about never quit, but that is complete absolute venture capital.

**中文翻译:**
从根本上说，你能做的最自私的事情就是对某人隐瞒反馈。当你有一个能帮助别人进步的想法，却因为怕自己尴尬而不告诉对方时，你其实是在优先考虑自己的舒适感，这本质上是自私的。很多人的团队运作得并不理想。团队总是倾向于优先考虑“局部舒适”，而不是公司的最终结果。企业中最纯粹的雄心和最强烈的能量来源是创始人兼 CEO。从创始人 CEO 向外扩展的每一层管理圈，其强度都有可能出现一个数量级的下降。这他妈的非常危险。
(00:01:17):
作为一名高管和领导者，你的职责就是将这种强度保持在最高水平。你在经营自己的初创公司时也有过几次非常有趣的经历。在硅谷，我们常说“永不言弃”，但这完全是风险投资（VC）灌输的鬼话。

---

### [00:01:33] Lenny Rachitsky

**English:**
Today, my guest is Matt MacInnis, Chief Product Officer and formerly longtime Chief Operating Officer at Rippling. If you don't know much about Rippling, it's a massively successful business last valued at over $16 billion. They have over 5,000 employees, and Matt has been instrumental to that success. He's also got a really rare combination of brutal honesty, a ton of experience building a very complex and very successful business, and being able to clearly articulate what he has learned really well. Matt shared a lot of insights and advice that I've not heard anyone else on this podcast share, and I left this conversation feeling that every leader needs to hear his advice.
(00:02:12):
A huge thank you to Albert Scrashim and Sunil Raman for suggesting topics and questions for this conversation. If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. It helps tremendously. And if you become an annual subscriber of my newsletter, you get a year free of 19 incredible products... Head on over to Lenny'snewsletter.com and click product pass. With that, I bring you Matt MacInnis after a short word from our sponsors.

**中文翻译:**
今天的嘉宾是 Matt MacInnis，他是 Rippling 的首席产品官，曾长期担任首席运营官。如果你不太了解 Rippling，它是一家非常成功的企业，最近一次估值超过 160 亿美元。他们拥有 5000 多名员工，Matt 对这一成功起到了关键作用。他身上有一种罕见的特质：极度的坦诚、构建复杂且成功业务的丰富经验，以及能将所学清晰表达出来的能力。Matt 分享了许多我在这个播客中从未听过的见解和建议，听完这次对话后，我觉得每一位领导者都需要听听他的建议。
(00:02:12):
非常感谢 Albert Scrashim 和 Sunil Raman 为本次对话提供的建议和问题。如果你喜欢这个播客，请记得在常用的播客应用或 YouTube 上订阅和关注。这对我们帮助很大。如果你成为我时事通讯的年度订阅者，你将免费获得 19 款不可思议的产品的一年使用权……请访问 Lenny'snewsletter.com 并点击“Product Pass”。在听完赞助商的简短介绍后，我们将请出 Matt MacInnis。

---

### [00:02:48] Amar (Sponsor)

**English:**
This podcast is sponsored by Google. Hey folks, I'm Amar, product and design lead at Google DeepMind. Have you ever wanted to build an app for yourself, your friends, or finally launch that side project you've been dreaming about? Now you can bring any idea to life, no coding background required with Gemini three in Google AI Studio. It's called vibe coding and we're making it dead simple. Just describe your app and Gemini will wire up the right models for you so you can focus on your creative vision. Head to ai.studio/build to create your first app.

**中文翻译:**
本期播客由 Google 赞助。大家好，我是 Amar，Google DeepMind 的产品与设计负责人。你是否曾想为自己或朋友开发一款应用，或者终于启动那个梦寐以求的业余项目？现在，通过 Google AI Studio 中的 Gemini 3，无需任何编程背景，你就能将任何创意变为现实。这被称为“氛围编程”（vibe coding），我们让它变得极其简单。只需描述你的应用，Gemini 就会为你连接合适的模型，让你专注于创意愿景。访问 ai.studio/build 创建你的第一个应用。

---

### [00:03:18] Lenny Rachitsky (Sponsor)

**English:**
This episode is brought to you by Datadog, now home to Eppo, the leading experimentation and feature flagging platform. Product managers at the world's best companies use Datadog... It starts with product analytics where PMs can watch replays, review funnels, dive into retention and explore their growth metrics. Where other tools stop, Datadog goes even further. It helps you actually diagnose the impact of funnel drop-offs and bugs and UX friction... Datadog is more than engineering metrics. It's where great product teams learn faster, fix smarter, and ship with confidence. Request a demo at datadoghq.com/lenny.

**中文翻译:**
本集节目由 Datadog 为您呈现，它现在是领先的实验和功能开关（feature flagging）平台 Eppo 的所在地。全球顶尖公司的产品经理都在使用 Datadog……它从产品分析开始，PM 可以观看回放、查看漏斗、深入研究留存并探索增长指标。在其他工具止步的地方，Datadog 走得更远。它能帮你诊断漏斗流失、Bug 和用户体验摩擦（UX friction）带来的实际影响……Datadog 不仅仅是工程指标。它是优秀产品团队学得更快、修得更准、发布更有信心的地方。请访问 datadoghq.com/lenny 申请演示。

---

### [00:04:43] Lenny Rachitsky

**English:**
Matt, thank you so much for being here and welcome to the podcast. Thank you for having me. I want to start with something that I know is really important to you, something you talk a lot about that I don't think people hear enough on podcasts like this, which is that extraordinary results require extraordinary efforts. Talk about why this is so important, what you think people need to hear.

**中文翻译:**
Matt，非常感谢你能来，欢迎来到本播客。谢谢你的邀请。我想从一个我知道对你非常重要的话题开始，你经常谈到这一点，但我认为人们在类似的播客中听得还不够多，那就是：非凡的结果需要非凡的努力。谈谈为什么这如此重要，以及你认为人们需要听到什么。

---

### [00:05:04] Matt MacInnis

**English:**
This is a term, that phrasing I actually attribute to a friend of mine, Dan Gill, who's the chief product officer at Carvana... And I think as a general framework for me... the product function is an instantiation of the general concept of management. Being a chief product officer is not that different from being a chief whatever officer. You have to apply the same frameworks and concepts to get people to achieve goals together. But one thing that is absolutely universal that I think we, honestly, I think we forget it in Silicon Valley or a lot of people don't sort of internalize it, is that if you want to accomplish something truly extraordinary, if you want to be in the 99th percentile in terms of outcomes, it's going to be really difficult.
(00:05:56):
It's going to be really uncomfortable. And you got to sort of remind people of that, that if they ever find themselves in the comfort zone at work, they are definitely making a mistake. They have definitely screwed up somehow. It's not that an extraordinary effort is sufficient to an extraordinary outcome, but it is 100% true that it is necessary. And so I do use that framework as a sort of guiding principle in my own leadership.

**中文翻译:**
这个说法其实源于我的一个朋友 Dan Gill，他是 Carvana 的首席产品官……对我来说，这是一个通用框架……产品职能其实是通用管理概念的一个实例化（instantiation）。担任首席产品官与担任其他任何首席官并没有太大区别。你必须应用相同的框架和概念来让人们共同实现目标。但有一件事是绝对普遍的，老实说，我认为我们在硅谷忘记了这一点，或者很多人没有内化它，那就是：如果你想成就真正非凡的事业，如果你想在结果上达到前 1% 的水平，那过程会非常艰难。
(00:05:56):
这会让人非常不舒服。你必须提醒人们，如果他们在工作中感到舒适，那他们肯定犯了错，肯定在某些地方搞砸了。并不是说非凡的努力就足以产生非凡的结果，但非凡的努力绝对是必要条件。因此，我将这一框架作为我自己领导力的指导原则。

---

### [00:06:23] Lenny Rachitsky

**English:**
To make this even more real for people, what are examples of moments that were extraordinarily hard?

**中文翻译:**
为了让大家更有实感，能不能举几个特别艰难时刻的例子？

---

### [00:06:29] Matt MacInnis

**English:**
It is not about any sort of grand single story. I think the story is actually told through a thousand little things. And so for me, the story is told through a thousand Jira tickets, not through a thousand grand events. The extraordinary effort thing is a reminder that it's supposed to be really fricking exhausting. It's supposed to be. So on Friday night, when you get hit with an escalation on Friday night, when you get sort of hit with a bunch of new bugs from someone in the engineering team that you've got a triage, those are the moments where great players and great teams are separated from good players and good teams. And it's so easy to say this at a company like Rippling because we're winning.
(00:07:33):
As a company, for all of our foibles... the growth rate of the company on the revenue foundation that we have is extraordinary, really, really compelling. And it gives you, as a leader, the air cover to get up in front of your team and say, "Hey guys, I need the last ounce of oil that you've got left." And if your company's not growing very quickly... it doesn't feel as good as a contributor in that business to lean in and give everything you've got on Friday or Saturday or Sunday because you don't know that it's going to yield much. And so extraordinary results, outcomes demand extraordinary efforts, but if there's no chance at an extraordinary outcome, it's very hard to get the extraordinary effort.

**中文翻译:**
这并不是关于某个宏大的单一故事。我认为故事实际上是由一千件小事组成的。对我来说，故事体现在一千个 Jira 工单里，而不是一千个宏大事件里。“非凡努力”是在提醒你，这本来就该是极其累人的。本来就该如此。所以，当你在周五晚上遇到问题升级（escalation），或者周五晚上从工程团队那里收到一堆需要处理的新 Bug 时，这些时刻就是伟大球员和伟大团队与普通球员和普通团队拉开差距的时候。在 Rippling 这样的公司说这些很容易，因为我们在赢。
(00:07:33):
作为一家公司，尽管我们有各种缺点……但在现有的收入基础上，公司的增长率是非凡的，非常有吸引力。这作为领导者给了你“空中掩护”，让你能站在团队面前说：“嘿伙计们，我需要你们榨干最后一滴油。”如果你的公司增长不快……作为贡献者，在周五、周六或周日全力以赴的感觉就不会那么好，因为你不知道这是否会有所产出。所以，非凡的结果需要非凡的努力，但如果没有机会获得非凡的结果，就很难激发非凡的努力。

---

### [00:08:27] Lenny Rachitsky

**English:**
I saw the same thing actually at Airbnb with Brian Chesky. It always felt like things were going great and maybe we could take a break after something we shipped was killing it. And it always felt like the opposite. It always felt like, how do we press the gas pedal further? How do we go faster? How do we go bigger? There's never a moment to take a break.

**中文翻译:**
我在 Airbnb 的 Brian Chesky 身上也看到了同样的情况。总感觉事情进展顺利，也许在发布了某个爆款产品后可以休息一下。但事实总是相反。总是在想：我们如何进一步踩下油门？如何跑得更快？如何做得更大？永远没有休息的时候。

---

### [00:08:57] Matt MacInnis

**English:**
I spent seven years at Apple and learned under Steve Jobs when he was the CEO, learned what we called the death march, which is what we did to the engineers. It was like as soon as you shipped one version of the iPhone, you were just immediately thrown into the pit of building the next one and there was no break. It was just relentless and talk about an extraordinary outcome at the end of the day. There is no relief. In a competitive market, and if the market is valuable, it's competitive, no question. If you leave anything on the field, if you sort of leave a crack for your competitor, 100% chance they're going to go fill that crack. And so you have to be relentless. There can be no relaxation of the organization.

**中文翻译:**
我在 Apple 待了七年，在史蒂夫·乔布斯担任 CEO 期间向他学习，学到了我们所谓的“死亡行军”（death march），也就是我们对工程师所做的事情。就像你刚发布了一个版本的 iPhone，紧接着就被扔进开发下一个版本的深坑里，完全没有喘息的机会。那是无情的，但最终的结果确实是非凡的。没有解脱。在一个竞争激烈的市场中，如果市场有价值，那竞争必然激烈。如果你在场上留下了任何余地，如果你给竞争对手留下了一丝裂缝，他们 100% 会钻进来。所以你必须冷酷无情。组织内部不能有任何松懈。

---

### [00:10:12] Lenny Rachitsky

**English:**
Also, very counterintuitively, and maybe the more optimistic perspective here is when you do give your team space to just twiddle their thumbs, bad things start to happen. Morale actually dips in my experience. People get distracted. They're like, "Oh, what are we even doing? It's not interesting." I find that keeping people busy and motivated and fired up... I find they get more, the more I actually goes down in those moments.

**中文翻译:**
而且，非常违反直觉的一点是（也许这是一种更乐观的视角）：当你给团队空间让他们无所事事时，坏事就会开始发生。根据我的经验，士气反而会下降。人们会分心，会想：“我们到底在干什么？这没意思。”我发现，让人们保持忙碌、有动力、充满激情……如果节奏慢下来，士气反而会低落。

---

### [00:10:44] Matt MacInnis

**English:**
So here's a management framework that I use fairly often. As an executive, you don't know how to get any decision exactly right. It's not knowable... But of course, you have to set some default so you make your best guess and then you manage to that best guess and you learn as you go because in software development and in business in general, everything's emergent. These are not things that are knowable top down or a priority. And so you take a best guess and knowing that you're not going to get the right answer, you need to decide whether over-steering or under-steering relative to your perceived midpoint is better.
(00:11:30):
And so let's talk about staffing. When you staff a project, is it better to overstaff or is it better to under-staff knowing that you can't get it right? Well, it's better to under-staff. If you overstaff, you get everything that you just said. You get politics, you get people working, I think most importantly on things that are further down the priority list than necessary... That is poison. It's wasteful, it slows you down, it creates crust. And so it's very clear that under-staffing is less evil than over-staffing. In this particular framework, the advice is under-staff deliberately, always. And then the wisdom, the wisdom element is to know not to under-under-staff and sort of knowing the difference between those two things.

**中文翻译:**
这是我经常使用的一个管理框架。作为一名高管，你无法确切知道如何把每一个决定都做对。这是不可预知的……但你当然必须设定一些默认值，所以你做出最好的猜测，然后根据这个猜测进行管理，边做边学。因为在软件开发和一般的商业活动中，一切都是涌现（emergent）出来的。这些事情不是自上而下或预先就能知道的。所以你做一个最好的猜测，并且知道你不会得到完美答案，你需要决定相对于你感知的“中点”，是“过度转向”好还是“转向不足”好。
(00:11:30):
我们来谈谈人员配置。当你为一个项目配置人员时，在明知无法做到完美的情况下，是人员过剩好还是人员不足好？答案是人员不足更好。如果你人员过剩，就会出现你刚才提到的所有问题：办公室政治，以及最重要的一点——人们会去处理那些优先级并不高的琐事……那是毒药。它浪费资源，拖慢速度，产生冗余。所以很明显，人员不足的危害比人员过剩要小。在这个特定的框架中，建议是：永远刻意保持人员不足。而其中的智慧在于，知道不要“过度的人员不足”，并能分辨这两者之间的区别。

---

### [00:12:39] Lenny Rachitsky

**English:**
There's a previous guest... They used this metaphor if they want their team to be dehydrated to always be wanting more water. And then eventually they're too dehydrated and okay, we needed someone to help. Interesting. Yeah. There's a line along the lines of extraordinary efforts I want to make sure I read because I think this is really good. This may be a way to summarize what you're saying, that good teams get tired and that's when great teams kick the good team's asses.

**中文翻译:**
之前有一位嘉宾……他们用了一个比喻，说他们希望团队处于“脱水”状态，总是想要更多的水。直到最后他们实在太渴了，我们才说“好吧，我们需要人来帮忙”。很有趣。关于“非凡努力”，有一句话我想读一下，因为我觉得写得很好。这也许可以总结你所说的：平庸的团队会感到疲倦，而这正是伟大的团队痛击平庸团队的时候。

---

### [00:13:04] Matt MacInnis

**English:**
Yes. This was a quote actually from Sunil, and he found it from a women's basketball team coach. And it is, to my point earlier about you got to run the engine at the red line at all times because the minute you let your guard down, the minute you slow down, the minute you relax, the minute you leave a crack for your competition, the great teams are going to come in and kick the good team's. And it's like sports... business is a game and none of this matters. We're not going to carry it to the grave... I love the sport of business and I find that sports... military, those are very ripe sources of parallel concepts to apply in leadership.

**中文翻译:**
没错。这句话其实是 Sunil 引用的一位女篮教练的话。这正印证了我之前的观点：你必须让引擎始终在红线区运行，因为一旦你放松警惕，一旦你慢下来，一旦你松懈，一旦你给竞争对手留下裂缝，伟大的团队就会冲进来痛击平庸的团队。这就像体育运动……商业也是一场游戏，这些其实都没那么重要，我们又带不进坟墓……但我热爱商业这项运动，我发现体育和军事是领导力平行概念的极佳来源。

---

### [00:13:56] Lenny Rachitsky

**English:**
I find also those most intense, stressful, long nights are the moments you remember most and remember most fondly back to when you're building something. The key though is that it has to go well. As you said, if you are succeeding and winning, all of this is romantic in the end and nostalgic. Remember that time we built this thing and worked late nights and shipped this thing? If it doesn't go anywhere, you don't feel that.

**中文翻译:**
我也发现，那些最紧张、压力最大、熬夜最久的时刻，往往是你构建产品时记忆最深、回想起来最美好的时刻。但关键在于，结果必须是好的。正如你所说，如果你正在成功和获胜，这一切最终都会变得浪漫且值得怀念。“记得那次我们熬夜做这个东西并发布了吗？”如果项目失败了，你就不会有那种感觉。

---

### [00:14:23] Matt MacInnis

**English:**
One thing that I've learned from Parker, Parker's our CEO at Rippling, he said, "You don't really learn from your mistakes, you learn from your successes." And it's like you do, of course, and he would admit you learn a bit from mistakes, but I do think that this is sort of feel good that it's like, "Well, you didn't succeed, but at least you learned something." I've had failures... but in now what I think is six or seven years... at Rippling, I've learned so much more because I've seen success.
(00:15:13):
I've seen rapid, wild, crazy off the charts success of the business and it's more informative. There's more to glean from seeing how it's done right than there is to glean from seeing how it's done wrong. If I tell you you're going to get on an airplane and one maintenance technician has seen it done right a hundred times and the other maintenance technician has seen it done wrong a hundred times, but he learned from his mistakes... I mean, give me a break. There's not even a comparison which plane you're going to feel more comfortable on. And so I do think that learning from your mistakes thing is a bit of a feel good trope that actually has very little substance in reality.

**中文翻译:**
我从 Rippling 的 CEO Parker 那里学到了一件事，他说：“你并不是真的从错误中学习，你是从成功中学习。”当然，他也会承认你能从错误中学到一点东西，但我认为“虽然没成功，但至少学到了东西”这种说法只是一种自我安慰。我也经历过失败……但在 Rippling 的这六七年里，我学到了更多，因为我见证了成功。
(00:15:13):
我见证了业务快速、疯狂、破纪录的成功，这更具启发性。从“如何做对”中能学到的东西，远比从“如何做错”中能学到的多。如果我告诉你你要上一架飞机，一名维修技师看过一百次正确的维修，另一名维修技师看过一百次错误的维修但“从错误中吸取了教训”……得了吧，你觉得坐哪架飞机更安心？根本没法比。所以我认为“从错误中学习”在很大程度上是一个没什么实际意义的自我安慰套话。

---

### [00:15:57] Lenny Rachitsky

**English:**
It's why as an early career product manager... you should join a winning team... the folks who, when I look at a resume and I see that someone's joined, they were at really good companies when those companies were super exciting and in crazy growth mode. I'm like, "I instantly want to interview that candidate because I want to hear what they learned from being part of a winning team." And that's sort of one of my go to heuristics when I'm looking at candidate profiles and I think it's an under-told trope. Sorry, not an under-told trope. It's a piece of advice that I don't think people embrace enough in the valley that success begets success and you should chase success.

**中文翻译:**
这就是为什么作为职业生涯早期的产品经理……你应该加入一个获胜的团队。当我看简历时，如果看到某人加入过那些正处于令人兴奋、疯狂增长阶段的优秀公司，我会想：“我立刻想面试这个候选人，因为我想听听他们从获胜团队中学到了什么。”这是我查看候选人资料时常用的启发式方法（heuristics）之一。我认为这是一个被低估的建议，硅谷的人们对此接受度还不够：成功孕育成功，你应该追求成功。

---

### [00:16:35] Lenny Rachitsky

**English:**
Speaking of success and learning, you've been a long time COO at Rippling and the reason you're here recently you moved into CPO, chief product officer at Rippling, which is very exciting and very rare. I don't see a lot of COOs moving into product. Let me ask you why did you move into that role? I feel like you've been killing it at COO. Maybe that's the reason. Be careful what you're good at. And also just what are some surprises about this, about moving into product?

**中文翻译:**
说到成功和学习，你长期担任 Rippling 的 COO，而你最近转任 CPO（首席产品官），这非常令人兴奋且罕见。我没见过多少 COO 转去做产品的。我想问你，为什么要转到这个职位？我觉得你做 COO 做得非常出色。也许这就是原因——要小心你擅长的事情。另外，转做产品后有什么让你感到惊讶的事情吗？

---

### [00:17:08] Matt MacInnis

**English:**
The story at Rippling is pretty interesting... In general, your best executives are the ones that you can mostly toss into any challenge and they will bring order to chaos. They will fix the thing. And I do appreciate the terms that people have used at Rippling for me, talking about MacInnis's injured birds, where at any given moment some function is in disarray or in jeopardy and I go and focus very carefully on that function to get it back in order... I did that everywhere except R&D.
(00:18:23):
And so I would have my feet up on the table looking out across the floor at this dumpster fire off in the distance, just sort of emitting smoke and wondering if someone was going to go in and deal with that... From the outside, I actually had quite a few criticisms that I could lob in. And what happened at Rippling was we made some hiring mistakes... Parker and I sort of stared at each other through two years of this kind of disarray or this chaos or this agony of things and just never really having good executive leadership over both engineering and product at the same time. And I remember Parker sort of slumped down in his seat and said, "Oh, I have to run another search." And I said, "No, the gig's up. I'm going to go do it."

**中文翻译:**
Rippling 的故事很有趣……通常情况下，最好的高管是那些你可以把他们扔进任何挑战中，他们都能化混乱为秩序的人。他们能解决问题。我很喜欢 Rippling 员工给我起的一个外号，叫“MacInnis 的受伤小鸟”，意思是在任何时刻，如果某个职能部门陷入混乱或危机，我就会去专注于那个部门，让它恢复秩序……除了研发（R&D）部门，我在所有部门都这么干过。
(00:18:23):
所以以前我常把脚翘在桌子上，看着远处那个冒烟的“烂摊子”（dumpster fire），心想会不会有人去处理一下……从外部看，我其实有很多可以投射进去的批评意见。Rippling 后来在招聘上犯了一些错误……Parker 和我在这种混乱和痛苦中对视了两年，工程和产品部门始终没有同时拥有优秀的高管领导。我记得 Parker 瘫坐在椅子上说：“噢，我得再启动一次招聘了。”我说：“不，别找了，我去干。”

---

### [00:19:51] Matt MacInnis

**English:**
And so it's been 11 months of learning. Jumping into the product role when the product function itself, although staffed with really talented people, wildly under understaffed, and without a single spiritual leader on top of it to drive consistency and process excellence had become locally optimized but globally incoherent. And if you know Conway's law, you are destined to ship your org chart. And so with a locally optimized, globally incoherent team, you had a locally optimized, globally incoherent product experience that needed to be resolved.
(00:20:52):
Jumping into the product role has been quite eye-opening. I feel a little bashful about the naivety of my view from the outside a year ago. Product teams have a hierarchy of needs... When I jumped in, I was like, "Man, we need to establish some basic standards for test coverage. We need to establish some basic standards for how we do what I call a factory inspection on a product once it's ready to roll off the assembly line." Do we have a checklist for what we call product quality and what does product quality mean? Those basic things weren't there.

**中文翻译:**
所以这 11 个月我一直在学习。跳进产品角色时，虽然产品部门有很多天才，但人员严重不足，而且缺乏一个统一的灵魂人物来推动一致性和卓越流程，导致它变成了“局部优化但全局不协调”。如果你知道康威定律（Conway's law），你就知道你注定会交付出你的组织架构图。因此，一个局部优化、全局不协调的团队，必然会产生一个局部优化、全局不协调的产品体验，这需要被解决。
(00:20:52):
进入产品角色让我大开眼界。想到一年前我从外部看时的那种天真，我感到有点羞愧。产品团队也有“需求层次结构”……当我加入时，我想：“天哪，我们需要建立一些基本的测试覆盖率标准。我们需要建立一些基本的标准，来执行我所谓的‘出厂检验’（factory inspection），即产品准备下线时的检查。”我们是否有关于“产品质量”的清单？产品质量到底意味着什么？这些基础的东西当时都不存在。

---

### [00:22:08] Matt MacInnis

**English:**
And so the idea that we should be spending time measuring adoption metrics is absolute insanity. You're skipping a lot of steps between here and there. And so we have made great strides and I think it's translating to product quality improvements for our customers, but I feel, as I said, a little dumb for the way I was thinking about it before I jumped into the deep end. There is just no excuse as an executive for sitting outside of the mess and thinking you know the answers. It's a cardinal sin as an executive to do that. You need to go and see. You'd be in the boiler room, you need to study the system, bottom up and develop hypotheses for how to amend the system.

**中文翻译:**
所以，在那种情况下还花时间去衡量“采用率指标”（adoption metrics）简直是疯了。你跳过了中间太多的步骤。我们现在取得了很大进步，我认为这已经转化为客户能感受到的产品质量提升。但正如我所说，想到我跳进深水区之前的想法，我觉得自己有点蠢。作为一名高管，坐在混乱之外并自以为知道答案是没有任何借口的。那是高管的大忌。你需要亲自去看，去锅炉房，自下而上地研究系统，并提出如何修正系统的假设。

---

### [00:22:46] Lenny Rachitsky

**English:**
I love hearing this because so many people have teams that are not functioning incredibly well and hearing from someone that is not a longtime product person come in and try to fix these problems, I think is really useful and interesting for people to hear. To dig into this a little bit more, was the big lesson and kind of eye-opening moment that there's a lot of foundational work that needs to happen to achieve this outcome that you're trying to achieve, which is measure engagement and adoption well?

**中文翻译:**
我很喜欢听这些，因为很多人的团队运作得并不好，听一个非资深产品人如何进来解决这些问题，对大家非常有用且有趣。再深入探讨一下，那个让你大开眼界的重大教训是不是：为了实现你想要的目标（比如衡量参与度和采用率），其实需要先做大量的底层基础工作？

---

### [00:23:18] Matt MacInnis

**English:**
The lesson is that everything must be done in its time and order, and you can move really, really quickly. There's no sort of excuse not to move with urgency on all of these things, but you got to do them in order and you have to lead bottom up. You got to lead from the specific circumstances you observe. And I think for me, one of the best things that's happened over the last 11 months is that I've gained a greater trust in my own instincts, that sort of patterns I've matched across other functions do indeed apply in product... I don't actually give a shit about adoption metrics as a matter of principle. I care about adoption metrics when I care about adoption metrics.

**中文翻译:**
教训是，凡事必须按部就班，虽然你可以行动得非常快。没有任何借口不在这些事情上保持紧迫感，但你必须按顺序来，而且必须自下而上地领导。你必须根据你观察到的具体情况来领导。对我来说，过去 11 个月最棒的事情之一是我更加信任自己的直觉，我在其他职能部门总结的模式确实也适用于产品……原则上，我其实并不在乎采用率指标。我只在“我需要关心它”的时候才关心它。

---

### [00:25:00] Matt MacInnis

**English:**
It's got an awesome growth profile. So we should be really focused on the adoption metrics because I think that's going to be an important ingredient to low churn over time, removing friction from the implementation process as an example. There are other parts of our product where I would say I don't care at all about adoption and am much more focused on foundational things like I said earlier, test coverage or whatever, just to make sure that the thing is stable and good and delivering exactly what it's supposed to deliver once it's adopted.

**中文翻译:**
它有极佳的增长曲线。所以我们应该非常关注采用率指标，因为我认为这是长期保持低流失率的关键因素，比如消除实施过程中的摩擦。但在我们产品的其他部分，我会说我一点也不在乎采用率，而是更关注我之前提到的基础工作，比如测试覆盖率之类的，只是为了确保这个东西是稳定且优秀的，一旦被采用，就能准确交付它应有的价值。

---

### [00:25:28] Lenny Rachitsky

**English:**
Now that you're on the inside of the product team, what's something that you think people outside of product, say Matt two years ago or other, I don't know, go to market leads, other execs should hear, need to understand about product that they don't until they're on the inside?

**中文翻译:**
既然你现在已经进入了产品团队内部，你认为产品之外的人（比如两年前的 Matt，或者其他市场负责人、高管）应该听到什么？有哪些关于产品的真相是只有进入内部后才能理解的？

---

### [00:25:44] Matt MacInnis

**English:**
I'll give you another framework that I like to use. In the financial world, there's this concept of alpha. Alpha is outperformance relative to the index... And then you have the concept of beta. Beta is just volatility. Beta's not good. A high beta stock jerks around for no particular reason... So your ideal stock is a very high alpha, very low beta stock. They don't really come in that shape because alpha and beta tend to be correlated, but that's what you want when you buy a financial asset.
(00:26:40):
So what's the analogy? I think you have high alpha people who are very valuable. I think you also have low beta people who are also very valuable people. Dennis Rodman, basketball player, nut job, very high alpha. And there's room on every team for one Dennis Rodman... This alpha beta thing, I use it pretty often when contemplating what kind of person I want and also what kind of process I want.

**中文翻译:**
我再给你分享一个我喜欢的框架。在金融界，有一个概念叫 Alpha（阿尔法）。Alpha 是相对于指数的超额收益……然后是 Beta（贝塔）的概念。Beta 就是波动性。Beta 高并不好，高 Beta 的股票会无缘无故地剧烈波动……所以你理想的股票是高 Alpha、极低 Beta 的。虽然这种股票很少见，因为 Alpha 和 Beta 往往正相关，但这是你购买金融资产时的追求。
(00:26:40):
类比到人身上呢？我认为有“高 Alpha”的人，他们非常有价值。也有“低 Beta”的人，他们同样非常有价值。丹尼斯·罗德曼，那个篮球运动员，疯子一个，但他就是高 Alpha。每个团队都有容纳一个罗德曼的空间……在考虑我需要什么样的人以及什么样的流程时，我经常使用这个 Alpha/Beta 框架。

---

### [00:27:44] Matt MacInnis

**English:**
Our payroll product, we badly want the payroll product to be very low beta. We really don't want the payroll product to have any unpredictability or aberration, and so we're willing to accept more process. And here's a fundamental principle of design in an organization, which is that processes... exist for the sole purpose of lowering beta. Processes are for decreasing volatility in the output of the system. The downside of a process is that it suppresses alpha. And you have to be super, super careful and judicious in the application of process and the product team to know that you're lowering beta in the places where you want to do that without suppressing alpha in the places where you need it.

**中文翻译:**
我们的工资发放（payroll）产品，我们极度希望它是“低 Beta”的。我们绝对不希望工资产品有任何不可预测性或异常，所以我们愿意接受更多的流程。这里有一个组织设计的根本原则：流程存在的唯一目的就是降低 Beta。流程是为了减少系统输出的波动性。流程的副作用是它会抑制 Alpha。在产品团队中应用流程时，你必须极其小心和审慎，要确保你在想要降低 Beta 的地方降低它，而不在需要 Alpha 的地方抑制它。

---

### [00:28:35] Matt MacInnis

**English:**
So as we've gone through the last year of reforming the way that we build product at Rippling, it's been a game of recognizing those places where I need to implement a touch of process, just a touch. Other places where I need to implement a very clear, rigid process where I don't want alpha, I just want low beta. So examples of this are let's say our product quality list, which we lovingly at Rippling call the PQL.

**中文翻译:**
在过去一年改革 Rippling 产品构建方式的过程中，这就像一场博弈：识别哪些地方我只需要加入一点点流程，真的就一点点；而哪些地方我需要执行非常明确、僵化的流程，因为我不需要 Alpha，我只要低 Beta。一个例子就是我们的产品质量清单，在 Rippling 我们亲切地称之为 PQL。

---

### [00:29:00] Lenny Rachitsky

**English:**
Why PQL?

**中文翻译:**
为什么叫 PQL？

---

### [00:29:01] Matt MacInnis

**English:**
Yeah, so it's actually a really important thing. I think if you want to bring about cultural change in a team... Look, we have 1,300 people in our R&D organization. It's a big ship that we have to steer. If you want to create a moment that sticks in people's brains and sort of becomes a zeitgeist or something that they latch onto, you got to create an entity, a vessel for meaning, and then you got to fill that vessel with your meaning.

**中文翻译:**
这其实非常重要。如果你想在团队中带来文化变革……听着，我们的研发组织有 1300 人，这是一艘需要掌舵的大船。如果你想创造一个能印在人们脑海中、成为某种时代精神（zeitgeist）或大家能依附的东西，你必须创造一个实体，一个“意义的载体”，然后用你的意义去填充这个载体。

---

### [00:29:23] Lenny Rachitsky

**English:**
A meme, you might say.

**中文翻译:**
你是指一个“梗”（meme）吧。

---

### [00:29:24] Matt MacInnis

**English:**
Yeah, well, sure, a meme. A meme is actually a good example of this in common culture... I think it's why, when people come to the table with ideas from the outside, I welcome those outside ideas. But the first thing I ask the person to do is to tell me what they mean without using those words. So when someone comes in and says, "Hey, I want to do this thing on strategy." I'm like, "Cool. Tell me what you mean without using the word strategy." And it forces them to break it down into its constituent parts.

**中文翻译:**
没错，当然，一个梗。梗是大众文化中一个很好的例子……这也是为什么当人们带着外部想法来找我时，我表示欢迎，但我要求他们做的第一件事是：不用那些术语来告诉我你的意思。比如有人说：“嘿，我想做一个关于‘战略’（strategy）的东西。”我会说：“太好了，请在不使用‘战略’这个词的情况下告诉我你想做什么。”这会迫使他们将想法拆解成基本组成部分。

---

### [00:30:32] Matt MacInnis

**English:**
So PQL, as cheeky or silly as it sounds, was deliberately sort of angular or stood out as a vessel I could fill with a particular meaning... And the product quality list is lightweight in the sense that it just articulates in the simplest ways the standards we want you to meet when you ship a product... Just yesterday, we shipped the product to Parker... Parker is the sole payroll administrator for Rippling for all 5,200 employees. He personally runs payroll always... Yesterday, he goes to install this new application... and it dumps them onto an empty screen. And he's like, "What the fuck is this? What is this? What's going on? Hey, wow, talk about fail."

**中文翻译:**
所以 PQL 这个词，虽然听起来有点俏皮或傻气，但它是刻意设计得具有辨识度的，作为一个我可以填充特定意义的载体……产品质量清单是轻量级的，它只是用最简单的方式阐述了我们希望你在发布产品时达到的标准……就在昨天，我们向 Parker 交付了一个产品。Parker 是 Rippling 全部 5200 名员工唯一的工资管理员。他总是亲自运行工资发放，没有例外。昨天，他去安装这个新应用……结果跳出了一个空白屏幕。他大喊：“这他妈的是什么？这是什么情况？哇，真是大失败。”

---

### [00:31:48] Matt MacInnis

**English:**
So I chop another one of my fingers off, I'm down to nine. And I'm like, "Well, what did we miss?" What we missed was there was a fucking feature flag, a fucking feature flag. And I'm not allowed to say feature flag without fucking in front of it because feature flags are the bane of my existence and the worst things in the world that constantly cause problems... Anyway, we had one. Parker installs it, they forgot to disable the feature flag. He gets a blank screen when he installs the application. What did I do? My reaction was, "Ugh." Go back to the team, give them direct feedback... But also ask the question, "How do we miss this in the factory inspection process?"

**中文翻译:**
所以我又切掉了一根手指，现在只剩九根了（比喻犯错受罚）。我想：“我们漏掉了什么？”结果发现是因为一个该死的功能开关（feature flag）。我不加个脏话就没法说“功能开关”这个词，因为它们是我生存的克星，是世界上最糟糕、不断制造麻烦的东西……总之，当时有一个开关。Parker 安装时，他们忘了关掉那个功能开关，导致他看到的是空白屏幕。我做了什么？我的反应是“呃”，然后回到团队，给他们直接的反馈……但也提出了问题：“我们在‘出厂检验’过程中是怎么漏掉这一项的？”

---

### [00:32:37] Matt MacInnis

**English:**
And the answer is we didn't have any line item in the PQL for feature flags. So I added a line to the fucking PQL that said, "You are allowed to have one feature flag that governs your entire product at ship." It's an extreme standard that might not be achievable, but it's the standard we aspire to. This framework, the PQL, given these lightweight checklists, iterated on consistently in response to everything we learn as we go, constitutes a very nice lightweight way to lower the beta of the system with hopefully only a modicum of negative impact on the alpha for how we build product.

**中文翻译:**
答案是我们的 PQL 里没有关于功能开关的检查项。所以我往那该死的 PQL 里加了一行：“发布时，整个产品只允许有一个控制全局的功能开关。”这是一个极端的标准，可能无法完全实现，但这是我们追求的目标。PQL 这个框架，通过这些轻量级的清单，并根据我们学到的教训不断迭代，构成了一种非常好的轻量级方法，用来降低系统的 Beta（波动性），同时希望对我们构建产品的 Alpha（超额价值）只产生微小的负面影响。

---

### [00:33:34] Lenny Rachitsky

**English:**
Wow. Okay. By the way, PQL, is that like an acronym or it's just like, I like this word we're going to call it PQL?

**中文翻译:**
哇，好吧。顺便问一下，PQL 是缩写吗？还是你只是单纯喜欢这个词？

---

### [00:33:40] Matt MacInnis

**English:**
Product quality list.

**中文翻译:**
Product Quality List（产品质量清单）。

---

### [00:33:46] Matt MacInnis

**English:**
PQL, which how could you pronounce it other than pickle?

**中文翻译:**
PQL，除了读成“Pickle”（腌黄瓜）还能怎么读？

---

### [00:33:49] Lenny Rachitsky

**English:**
I'm imagining all your decks have little PQL emojis and the-

**中文翻译:**
我能想象你所有的 PPT 里都有小腌黄瓜的表情符号……

---

### [00:33:53] Matt MacInnis

**English:**
The pickle emoji thing, the dancing pickle in Slack, there's a lot of-

**中文翻译:**
腌黄瓜表情包，Slack 里的跳舞腌黄瓜，有很多这种东西……

---

### [00:34:04] Lenny Rachitsky

**English:**
Okay. So this high alpha, low beta, I love this concept. So the idea is depending on the team, depending on the problem, we need a high alpha, low beta person or actually okay with a lot of variants for this specific project...

**中文翻译:**
好。这个“高 Alpha、低 Beta”的概念我很喜欢。所以核心思想是，根据团队和问题的不同，我们需要一个高 Alpha、低 Beta 的人，或者在某些特定项目中，我们其实可以接受较大的波动……

---

### [00:34:16] Matt MacInnis

**English:**
Yeah, we're willing to accept a bunch of volatility in this area in exchange for the upside we get from the creativity and risk taking of these people or the lack of process that sort of gives them the latitude to do what they want to do.

**中文翻译:**
是的，我们愿意在某些领域接受大量的波动性，以换取这些人的创造力和冒险精神带来的收益，或者是通过减少流程给他们提供做自己想做的事情的自由度。

---

### [00:34:30] Matt MacInnis

**English:**
For sure. It's really quite a useful way... I rely a lot of my intuition, which of course HR people say you're not supposed to do. That's complete bullshit. If you have a good intuition, you should absolutely rely on your intuition. And what you have to do after you have a reaction to a candidate... is you need to decode your intuition so that it can be expressed to other people productively. One of the frameworks that I use for this is SPOTAC... people are smart, passionate, optimistic, tenacious, adaptable, and kind.

**中文翻译:**
确实。这是一个非常有用的方法……我非常依赖我的直觉，当然 HR 会说你不应该这样做。那完全是胡扯。如果你有敏锐的直觉，你绝对应该依赖它。但在你对候选人产生反应后，你需要做的是“解码”你的直觉，以便能高效地向他人表达。我使用的一个框架是 SPOTAC：人们应该是聪明（Smart）、热情（Passionate）、乐观（Optimistic）、坚韧（Tenacious）、适应力强（Adaptable）和善良（Kind）。

---

### [00:36:24] Matt MacInnis

**English:**
The framework is super useful to evaluating people. And I think the alpha beta framework is also super useful when you come away from a conversation and you're like, "I like that guy. I think he'd be really, really good. Why is it that I don't think he would do a good job on this product in particular?" And the answer is like, "This is a high alpha product area and he's a low beta person." Valuable, but definitely not the right fit for this.

**中文翻译:**
这个框架在评估人时超级有用。而且我认为 Alpha/Beta 框架在面试结束后也很有用，比如你会想：“我喜欢那个人，我觉得他非常优秀。但为什么我觉得他在这个特定产品上做不好呢？”答案可能是：“这是一个需要高 Alpha 的产品领域，而他是一个低 Beta 型的人。”他很有价值，但绝对不适合这个岗位。

---

### [00:37:03] Matt MacInnis

**English:**
When I first started working in the product organization, I was introduced to an interview framework... which is that every product person at every seniority level is given the same case study. And the case study is extraordinarily difficult. It requires you to think about many, many dimensions simultaneously, to think about data propagation issues. It gets quite technical. And the rubric that we use... gives you guidance on what for us, like an entry level PM looks like, what a junior, mid-career, senior executive PM might look like.

**中文翻译:**
当我刚开始在产品部门工作时，我接触到了一种面试框架……即每个级别的产品人员都会拿到同一个案例分析（case study）。这个案例极其困难，要求你同时考虑许多维度，考虑数据传播问题，技术性很强。我们使用的评分标准会指导我们：一个初级 PM 的表现应该是怎样的，中级、高级或高管级别的 PM 表现又应该是怎样的。

---

### [00:38:25] Matt MacInnis

**English:**
You never think that giving someone an impossible task and even including the L5 person versus the VP on the same thing would be productive... But I've found the wisdom in it and think it's actually quite useful to give everyone the same simple, complicated prompt and just see. Hand them a drill bit, give them the concrete wall and see if they can get a millimeter or an inch into the concrete. They're never going to get all the way through the wall. It doesn't matter. You're going to learn a lot.

**中文翻译:**
你可能永远不会想到，给一个 L5 级别的员工和一名副总裁（VP）布置同样的“不可能完成的任务”会是卓有成效的……但我发现了其中的智慧。给每个人同样的、既简单又复杂的题目，然后观察。给他们一个钻头和一面混凝土墙，看他们能钻进一毫米还是一英寸。他们永远钻不透这面墙，但这没关系，你能从中观察到很多东西。

---

### [00:39:28] Matt MacInnis

**English:**
But the magic of product management is that you kind of have to... We talk about the mini CEO. I think it's kind of a stupid misnomer, but there's some wisdom there. And I think the wisdom is that you have to be a polymath. You've got to be really good at working with other people. You got to be good at communications and articulation. You got to be good at project management. You got to be good at the science and the math and the engineering. And it's really fucking cool.

**中文翻译:**
产品管理的魔力在于……我们常说 PM 是“小 CEO”。我觉得这个称呼有点蠢且误导，但其中确实包含了一些智慧。我认为那智慧在于你必须是一个博学者（polymath）。你必须非常擅长与人合作，擅长沟通和表达，擅长项目管理，还要精通科学、数学和工程。这真的他妈的太酷了。

---

### [00:40:01] Matt MacInnis

**English:**
I'll say one other thing about what I love about leading product... as a COO, my job was to accept the product as it was and optimize everything around that... And now that I lead product, I'm like, "Oh, wow. This is the high order bit." Not that I didn't sort of understand that, but now I really get that product is the high order bit. If you get the product right, it fits in the market, everything else gets easier. Finance is easier, sales is easier, marketing is easier, recruiting is easier, everything gets fucking easier.

**中文翻译:**
关于领导产品，我还想说一点我热爱的地方……作为 COO，我的工作是接受既有的产品，并围绕它优化一切……而现在我领导产品，我发现：“噢，哇。这才是‘高位比特’（high order bit，指最关键的因素）。”并不是说我以前不懂，而是现在我真正理解了产品才是核心。如果你的产品做对了，契合市场，其他一切都会变得容易。财务更容易，销售更容易，营销更容易，招聘更容易，他妈的一切都会变得更容易。

---

### [00:41:22] Lenny Rachitsky

**English:**
This is really great to hear... As you know, a lot of people are a very anti-product manager. "Why do we need product managers? We don't need them. Slow everything down, all this process."

**中文翻译:**
听你这么说真好……如你所知，很多人非常排斥产品经理。“为什么我们需要产品经理？我们不需要他们。他们只会拖慢进度，搞一堆流程。”

---

### [00:41:51] Matt MacInnis

**English:**
Yeah. I have a distinction there, which is that I'm anti-shitty product managers.

**中文翻译:**
是的。我对此有一个区分：我反对的是“烂”产品经理。

---

### [00:41:53] Lenny Rachitsky

**English:**
That's exactly how I put it. If you hate product managers, you just haven't worked with a great product manager.

**中文翻译:**
我正是这么说的。如果你讨厌产品经理，那只是因为你还没和优秀的产品经理合作过。

---

### [00:41:58] Matt MacInnis

**English:**
Well, it's like, look, I love wine... And one of my favorite lines is like, "I don't like Chardonnay." And I'm like, "No, no, no, no, no. Chardonnay's are the most fucking amazing varieties of wine in the world. You just haven't had good Chardonnay. And there's a Chardonnay out there for you." Product management, it's like you don't like product management, you think product managers suck. It's like, well, you just haven't had a good Chardonnay yet.

**中文翻译:**
这就像，你看，我热爱葡萄酒……我最常听到的一句话是：“我不喜欢霞多丽（Chardonnay）。”我会说：“不不不，霞多丽是世界上他妈的最神奇的葡萄品种。你只是还没喝过好的霞多丽，总有一款霞多丽适合你。”产品管理也是一样，如果你觉得产品经理很烂，那只是因为你还没遇到你的那款“霞多丽”。

---

### [00:42:47] Lenny Rachitsky

**English:**
You touched on this product market fit point... You've had a couple really interesting experiences of struggling to find product market fit with your own startup. You said you worked on it for nine years, you said?

**中文翻译:**
你提到了产品市场契合点（PMF）……你在经营自己的初创公司时，曾经历过寻找 PMF 的艰难过程。你说你做了九年，是吗？

---

### [00:42:59] Matt MacInnis

**English:**
Mm-hmm... There's a line that this venture capitalist... said, which was that product market fit is a sort of thing where you absolutely know it when you see it, and therefore if you don't absolutely know it, you don't have it. And this kind of gets back to my point about learning from mistakes versus successes... over the course of the many years that I spent at Inkling, we thought we had it. We thought we had product market fit, maybe, maybe. And in hindsight... it was so, so obvious that we didn't.

**中文翻译:**
嗯……有一位风险投资家说过一句话：产品市场契合（PMF）这种东西，当你看到它时你绝对会知道；所以如果你不确定自己有没有，那你就是没有。这又回到了我关于从成功而非错误中学习的观点……在我在 Inkling 的那些年里，我们总以为自己找到了 PMF，也许吧，可能吧。但现在回想起来……非常明显，我们当时根本没有。

---

### [00:44:29] Matt MacInnis

**English:**
We talk in Silicon Valley about never quit, but that is complete absolute venture capital bullshit. The incentive of venture capitalist is to put money into your company and milk you dry. They never get their money back. There is no way for them to take that investment back. So the only logical desire that they would have is for you to keep trying against all odds because there is the occasional example where someone pivoted from A to X and it was wildly different and it worked... but man, is that rare. Just so exceedingly rare.

**中文翻译:**
在硅谷，我们总说“永不放弃”，但这完全是风险投资人的鬼话。风投的动力是把钱投进你的公司，然后榨干你。他们没法把投资撤回来。所以他们唯一的逻辑愿望就是让你排除万难继续尝试，因为偶尔会有从 A 转型到 X 最终大获成功的例子……但天哪，那太罕见了，极其罕见。

---

### [00:45:56] Matt MacInnis

**English:**
The Silicon Valley try until you die mindset is not pro-entrepreneur, it's pro-venture capitalist... I think it's important to say out loud that you should fucking quit. You should reset the clock, you should reset the cap table because trust me, product market fit when it arrives is insane and it's exciting and you should pursue it. And never delude yourself into believing you have it when you don't. It is dangerous and regrettable.

**中文翻译:**
硅谷那种“尝试到死”的心态不是为了创业者好，而是为了风投好……我认为有必要大声说出来：你他妈的应该放弃。你应该重置时钟，重置股权结构表（cap table），因为相信我，当真正的 PMF 到来时，那是疯狂且令人兴奋的，那才是你应该追求的。永远不要在没有 PMF 的时候自欺欺人地以为自己有。那是危险且令人遗憾的。

---

### [00:47:12] Matt MacInnis

**English:**
Trust me, the 45-year-old entrepreneur or the 50-year-old venture capitalist who've been in the game for a while, they get it... The system is there to take advantage of the people who don't... It's just that the incentive structures lead to some real harm, I think, in certain cases.

**中文翻译:**
相信我，那些在圈子里混了很久的 45 岁创业者或 50 岁风投家，他们都懂……这个系统就是为了利用那些不懂的人……只是在某些情况下，这种激励结构会导致真正的伤害。

---

### [00:48:28] Lenny Rachitsky (Sponsor)

**English:**
This episode is brought to you by GoFundMe Giving Funds, the zero-fee donor-advised fund... Join the GoFundMe community of over 200 million people and start saving money on your tax bill, all while helping the causes that you care about most. Start your giving fund today at gofundme.com/lenny.

**中文翻译:**
本集节目由 GoFundMe Giving Funds 为您呈现，这是一家零费用的捐赠者建议基金（DAF）……加入拥有超过 2 亿人的 GoFundMe 社区，开始节省税单，同时帮助您最关心的事业。今天就在 gofundme.com/lenny 启动您的捐赠基金。

---

### [00:49:38] Matt MacInnis

**English:**
Here, look, history provides us with a clear guide. When you look at companies having hit it big, they hit big pretty quick. It's very, very dangerous to be late to the party, it's very, very dangerous to be early to the party... don't ask people for advice, ask people for relevant experience. If you ask them for advice, they will always give it, but if you ask them for relevant experience, they rarely have any to offer, and if they don't have any to offer, then don't ask for their advice.

**中文翻译:**
看，历史给了我们清晰的指引。当你观察那些做大的公司时，它们通常很快就爆发了。赴约太晚非常危险，赴约太早也同样危险……不要向人征求建议，要向人询问“相关经验”。如果你征求建议，人们总会给；但如果你询问相关经验，他们往往拿不出来。如果他们没有相关经验，那就别听他们的建议。

---

### [00:50:41] Matt MacInnis

**English:**
My relevant experience on this topic of when to quit is like, I think we could have called it after the second or third pivot, which was somewhere around year four... if you're year four, year five in your entrepreneurship journey, and it's not just obviously a screaming rip-roaring growth story, it's extraordinarily difficult... it can be really liberating when you're like, "Fuck it, I'm going to do this. I have the energy. I'm going to do it again. I'm just going to do it with a clean sheet."

**中文翻译:**
关于“何时放弃”这个话题，我的相关经验是：我认为在第二次或第三次转型（pivot）后就可以收手了，大约是在第四年左右……如果你创业到了第四、第五年，业务还没有表现出明显的、势如破竹的增长，那之后会极其艰难……当你决定“去他的，我有精力，我要重头再来，我要在一张白纸上重新开始”时，那种感觉其实是非常解脱的。

---

### [00:51:54] Matt MacInnis

**English:**
I think this is a really fundamentally misunderstood dynamic. When founders message me and they're like, "Hey, like my LinkedIn post and my tweet for this launch," I do it... But I think to myself, this is not what this is about... because nobody cares about your company. Your launch doesn't matter. Big, fat, pull the slingshot back, launches amount to the teeniest thimble of water in the ocean of noise about startups and companies...

**中文翻译:**
我认为这是一个被根本性误解的动态。当创始人发消息给我说：“嘿，帮我的发布推文点个赞”时，我会照做……但我心里想，这不是关键……因为没人关心你的公司。你的发布活动并不重要。那种大张旗鼓、蓄势待发的发布会，在关于初创公司的嘈杂海洋中，不过是极其微小的一滴水而已……

---

### [00:52:56] Matt MacInnis

**English:**
Well, if you recognize that the market is immutable, no amount of tweeting, LinkedIn posting, advertising is going to change whether the market wants your product... You have to view your startup as running an experiment in the universe to see what you get in return for that, and this analogy of drug discovery and binding receptors is like nobody at Genentech thinks they can market their way to better performance inside your body. The binding receptors for that drug, they exist or they don't... Fate has already decided the outcome.

**中文翻译:**
如果你意识到市场是不可改变的，那么再多的推文、领英帖子或广告，都无法改变市场是否需要你的产品……你必须把你的初创公司看作是在宇宙中进行的一场实验，看看能得到什么回报。这就像药物研发和“结合受体”（binding receptors）的类比：Genentech 的人不会认为他们可以通过营销让药物在人体内表现更好。那种药物的结合受体要么存在，要么不存在……命运早已决定了结果。

---

### [00:54:32] Matt MacInnis

**English:**
As an investor, you might build a checklist... Does it have this kind of founder? Is it a C Corp in Delaware? ... And these checklists are all about what? They're all about suppressing beta. They're about avoiding avoidable mistakes... Jeff Lewis is an investor who has many angular views on things, and I think one of his most enduring phrases is narrative violations. This idea that the common wisdom must be violated in some way by every company that has an outsized success.

**中文翻译:**
作为投资者，你可能会列一个清单……创始人是哪种类型？是在特拉华州注册的 C Corp 吗？……这些清单是为了什么？都是为了降低 Beta（风险）。为了避免可以避免的错误……投资者 Jeff Lewis 对事物有很多独特的见解，他最经典的一个词叫“叙事违背”（narrative violations）。意思是，每一家获得巨大成功的公司，在某种程度上都必须违背常识。

---

### [00:55:37] Matt MacInnis

**English:**
So Notion, you can't replicate Notion's success as an entrepreneur... because you're not Ivan. You can't replicate it because you're not Notion. You can't replicate it because it's not 2010 when they started the company... These guys stuck with it. They went through hell. They pivoted. They went to Japan and sat in kimonos and meditated on what they were going to build... I look at Notion as having succeeded by virtue of the narrative violation of persistence...

**中文翻译:**
所以 Notion 的成功是无法复制的……因为你不是 Ivan（Notion 创始人）。你无法复制它，因为你不是 Notion。你无法复制它，因为现在不是 2010 年……那些家伙坚持了下来，经历了地狱般的磨练。他们转型，去日本穿着和服冥想他们要构建什么……我认为 Notion 的成功归功于对“坚持”这一叙事的违背（在大多数情况下坚持是错的，但对他们是对的）……

---

### [00:56:55] Matt MacInnis

**English:**
The takeaway lesson is that every company succeeds on the foundations of the idiosyncrasies of the founder. The idiosyncrasies of the founder. Rippling succeeds for almost the polar opposite reasons that Notion succeeds, but in both cases, the companies succeed on the idiosyncrasies of the founder.

**中文翻译:**
核心教训是：每家公司的成功都建立在创始人的特质（idiosyncrasies）之上。创始人的特质。Rippling 成功的原因几乎与 Notion 截然相反，但在两种情况下，公司都成于创始人的独特个性。

---

### [00:58:27] Matt MacInnis

**English:**
I was one of the first investors in Notion... I was one of the first investors in Zenefits, if you've heard of it... I was, before I joined, one of the first investors in Rippling, and then more recently invested in... Here's a funny one. I was one of the first investors in Deal, if you've heard of them. I was able to exit that position, and then hopefully that company's going to zero with their criminal behavior, but whatever...

**中文翻译:**
我是 Notion 的早期投资者之一……我是 Zenefits 的早期投资者之一，如果你听说过的话……在我加入之前，我就是 Rippling 的早期投资者。最近还投了……这有一个有趣的，我是 Deel 的早期投资者之一。我已经退出了那个头寸，希望那家公司会因为他们的犯罪行为而归零，不过随便吧……

---

### [00:59:00] Matt MacInnis

**English:**
I'm in LangChain. Great. So those are some companies that you maybe have heard of, but how about I invested in Macro... out of business. I invested in Debrief... out of business. I invested in Verb Data... out of business. I'm reading from a list. I invested in... 70 companies according to this list where I track things and most of them went to zero and all those founders were awesome... I love to give you names of companies that don't exist anymore because it's self-serving and a horrible survivorship bias to just list the good ones.

**中文翻译:**
我还投了 LangChain。太棒了。这些是你可能听说过的公司，但我也投过 Macro……倒闭了。投过 Debrief……倒闭了。投过 Verb Data……倒闭了。我正对着清单读呢。根据我的记录，我投了大约 70 家公司，其中大部分都归零了，尽管那些创始人也非常出色……我喜欢列举那些已经不存在的公司名字，因为只列出成功的公司是自私的，而且会产生严重的幸存者偏差。

---

### [01:00:42] Lenny Rachitsky

**English:**
There's a topic around this area... this idea you talk about of compounding plus power law plus entropy and how that's a really useful frame to think about business.

**中文翻译:**
这方面有一个话题……你谈到的关于复利、幂律（power law）加上熵（entropy）的想法，以及为什么这是思考商业的一个非常有效的框架。

---

### [01:01:47] Matt MacInnis

**English:**
People tend to think that the world plays on a more linear relationship... but that is absolutely not the case... if you build something to 80 or 90%, the Y axis is barely budged yet. You haven't hit the inflection point in terms of reward, and so the implication of the power law more broadly is that people who are in the top 10%, the top 5%, don't just get 10 or 20% more reward. They get 10X the reward or 100X the reward. It's really dramatic.

**中文翻译:**
人们倾向于认为世界是线性关系的……但事实绝对不是这样……如果你把某件事做到了 80% 或 90%，Y 轴（回报）可能几乎还没动。你还没达到回报的拐点。幂律的更广泛含义是：处于前 10% 或前 5% 的人，得到的不仅仅是多出 10% 或 20% 的回报，而是 10 倍甚至 100 倍的回报。这非常剧烈。

---

### [01:02:20] Matt MacInnis

**English:**
Entropy, the second law of thermodynamics is a very simple concept. It's the reason your sock drawer becomes messy... shit tends toward disorder. The universe, I mean, life itself is a temporary victory against entropy... The only antidote to entropy, the only antidote to decay in a system is energy. You got to inject energy.

**中文翻译:**
熵，热力学第二定律，是一个非常简单的概念。它是你袜子抽屉变乱的原因……事物总是趋向于无序。宇宙，甚至生命本身，都是对抗熵的暂时胜利……系统中对抗熵、对抗衰败的唯一解药就是能量。你必须注入能量。

---

### [01:03:17] Matt MacInnis

**English:**
So if you have a code base, every line of code that you add to that code base increases the entropy of that system and demands ever more energy from human beings to go and intend to it to make sure it doesn't break... Teams will, sadly, but because we are all human, teams will always optimize for local comfort over company outcomes. Your job as an executive, as a leader, is to fight that entropy tooth and nail every single day.

**中文翻译:**
所以如果你有一个代码库，你增加的每一行代码都会增加系统的熵，需要人类投入更多的能量去维护它，确保它不会崩溃……遗憾的是，因为我们都是人，团队总是会优先考虑“局部舒适”而不是公司的结果。作为一名高管和领导者，你的职责就是每天拼命地与这种熵作斗争。

---

### [01:05:19] Matt MacInnis

**English:**
The purest form of ambition and the purest and most intense source of energy in the business is the founder CEO... every next concentric circle of management beyond the founder CEO has the potential to be an order of magnitude drop off in intensity... it's not that you need to buffer people from the intensity of the CEO, it's that you need to absolutely mirror that intensity. Your job is to preserve that intensity at its highest possible level and let the buffering happen somewhere else.

**中文翻译:**
企业中最纯粹的雄心、最纯粹且最强烈的能量来源是创始人 CEO……从创始人 CEO 向外扩展的每一层管理圈，其强度都有可能下降一个数量级……你不需要充当员工与 CEO 强度之间的“缓冲垫”，你反而需要绝对地镜像（mirror）那种强度。你的职责是将这种强度保持在最高水平，让缓冲发生在其他地方。

---

### [01:07:03] Lenny Rachitsky

**English:**
What does that look like to pass along that intensity? What does that feel like? What does that look like? So say Parker comes to you, "This bug sucks. I got this broken screen." You cut off your finger. Maybe that's the example.

**中文翻译:**
传递这种强度具体是什么样的？感觉如何？看起来又是怎样的？比如 Parker 跑来找你：“这个 Bug 太烂了，屏幕坏了。”然后你切掉了一根手指，也许这就是例子。

---

### [01:07:21] Matt MacInnis

**English:**
I'll give you concrete examples... Parker's icon in Slack is just, he uses the generic yellow... egg... Parker Conrad is inviting you to a huddle... Parker Conrad is modeling personal intensity... "I want to talk about this fucking problem right now and whatever you're doing, unless it's an interview, I want you to come and have a conversation with me." That intensity is one place where it plays out.

**中文翻译:**
我给你举个具体的例子……Parker 在 Slack 上的头像只是一个通用的黄色……鸡蛋……当显示“Parker Conrad 邀请你加入 Huddle（语音会话）”时，他就是在展示个人强度……“我现在就要谈这个该死的问题，不管你在做什么，除非你在面试，否则立刻过来跟我谈。”这种强度就是这样体现的。

---

### [01:08:13] Matt MacInnis

**English:**
Every product team at Rippling... have public feedback channels. I am in there upside down on everything I find when I use those products... It's about modeling the intensity publicly so that other people can say, "Okay, this is how we do things around here," ... The reaction universally is like, "Ugh, what a relief that I get to go be intense," because nobody in a position of leadership wants to be chill... Chill doesn't accomplish shit. Be intense. Be good, be respectful, be intense. Don't be chill.

**中文翻译:**
Rippling 的每个产品团队都有公开的反馈频道。当我使用这些产品发现问题时，我会毫不留情地在里面指出来……这是为了公开展示这种强度，让其他人明白：“好吧，这就是我们这里的做事方式。”……大家的反应通常是：“噢，太解脱了，我终于可以表现得很有强度了。”因为没有一个处于领导地位的人想变得“佛系”（chill）……佛系成不了大事。要保持强度。要做个好人，要尊重他人，但要保持强度。不要佛系。

---

### [01:11:04] Matt MacInnis

**English:**
Well, man, there's a whole other podcast episode on the concept of leverage. If you sell your time, you've only got 24 hours a day to give, but if you can create a product that scales, the marginal cost of a unit of that product is zero like software, it's going to be competitive, man. Sell your time, it's not going to be super competitive, but achieve that level of leverage and it's a pretty efficient market.

**中文翻译:**
伙计，关于“杠杆”（leverage）的概念完全可以再录一集播客。如果你出卖时间，你一天只有 24 小时；但如果你能创造一个可扩展的产品，其边际成本为零（比如软件），那竞争会非常激烈。出卖时间不会有超强竞争，但一旦达到那种杠杆水平，市场就会变得非常高效。

---

### [01:11:49] Matt MacInnis

**English:**
Fundamentally, the most selfish thing you can do is withhold feedback from someone. Who are you optimizing for when you do that? ... you're optimizing for your own comfort and it's fundamentally selfish... I demand feedback, and I give it... The part of this that has been interesting to me is that people withhold, escalate... Customers don't want to escalate to me as an executive... but it's literally my job... to find things, problems, and make them better.

**中文翻译:**
从根本上说，你能做的最自私的事情就是对某人隐瞒反馈。你这样做是在为谁优化？……你是在为自己的舒适度优化，这本质上是自私的……我要求反馈，我也给予反馈……让我觉得有趣的是，人们往往不愿向上升级问题。客户也不想向我这个高管投诉……但寻找问题并改进它们，这正是我的工作。

---

### [01:13:09] Matt MacInnis

**English:**
There's no greater gift to me as a product executive than receiving an escalation from a customer. We have an escalations team at Rippling... people who are just particularly skilled at pistol whipping other people in the company to get to real root causes... Escalations are a gift... the fact that I might already know it is not a reason for you to withhold the gift of your feedback.

**中文翻译:**
作为一名产品高管，没有什么比收到客户的问题升级更好的礼物了。Rippling 有一个专门的问题升级团队……这些人特别擅长督促（pistol whipping）公司里的其他人去寻找真正的根本原因（root causes）……问题升级是一份礼物……即便我可能已经知道了，这也不是你保留反馈意见的理由。

---

### [01:14:53] Matt MacInnis

**English:**
People look at Rippling from the outside, I think they think of us as payroll and HR... We see ourselves as building the most successful business software platform in history... to free smart people to work on hard problems... we really do believe that the core of every workflow... is who's doing stuff, who owns it, who's accountable? And so the people record is a really important component of that.

**中文翻译:**
外界看 Rippling，可能觉得我们只是做工资发放和 HR 的……但我们认为自己是在构建历史上最成功的商业软件平台……目标是“让聪明人从琐事中解脱，去解决难题”。我们坚信每个工作流的核心都是：谁在做事？谁负责？谁承担责任？因此，“人员记录”（people record）是其中非常关键的组成部分。

---

### [01:16:03] Matt MacInnis

**English:**
Workday is terrible software. Everybody agrees on that. I think Workday agrees on that... So we're going to do that. And we're successful because we deliver on that promise at the scale we're at today... We do payroll, we do HCM, we do IT, we do spend. We are about to launch a new product in the category of business intelligence and data management... And then you layer in AI on top of this... The AI can work magic.

**中文翻译:**
Workday 是很烂的软件，大家都同意这一点，我想 Workday 自己也同意……所以我们要取而代之。我们之所以成功，是因为我们在目前的规模下兑现了那个承诺……我们做工资、人力资本管理（HCM）、IT、支出管理。我们即将发布商业智能和数据管理类别的新产品……然后你在这些基础上叠加 AI……AI 就能创造奇迹。

---

### [01:17:55] Matt MacInnis

**English:**
Yeah. People are going to vibe code their way to their payroll system, which I ... good luck to the employees of those companies.

**中文翻译:**
是的。人们想通过“氛围编程”（vibe coding）搞定他们的工资系统，我只能祝那些公司的员工好运了。

---

### [01:18:18] Matt MacInnis

**English:**
There's a really good quote... "There's two ways to make money in software, bundling and unbundling." And you just got to get the timing right. So this is a period of bundling. So here's the problem; point solutions don't have enough data in the age of AI to be useful. You got to be able to provide the AI with a lot of context about a lot of data so it can do things. It can do joins. It can do correlations.

**中文翻译:**
有一句名言：“在软件行业赚钱有两种方式：捆绑（bundling）和拆解（unbundling）。”你只需要把握好时机。现在是捆绑的时期。问题在于：在 AI 时代，单点解决方案（point solutions）没有足够的数据来发挥作用。你必须能为 AI 提供关于大量数据的丰富上下文，它才能做事，才能进行关联和分析。

---

### [01:19:39] Matt MacInnis

**English:**
The other thing that I would say about the world of... AI software is that point solutions in the AI world are also in a rough spot for the same reason. It's like if you're selling the shovels like OpenAI and Google with Gemini, you can make money. And if you own the mine, like Rippling, with the data, you can make money. If you're somewhere in the middle... you're in a very difficult place from an economic standpoint.

**中文翻译:**
关于 AI 软件世界我想说的另一件事是，AI 领域的单点解决方案也处于同样的困境。如果你是卖铲子的（比如 OpenAI 或 Google 的 Gemini），你能赚钱；如果你拥有矿井（比如 Rippling 拥有数据），你也能赚钱。如果你处于中间地带……从经济角度来看，你的处境会非常艰难。

---

### [01:21:09] Matt MacInnis

**English:**
SaaS software is a bit flipping. All SaaS software applications are bit flippers... Changing values in your database, that's what it does... One of Rippling's superpowers is we're a coin sorter. You dump $20,000 for an employee in the top... and it figures out what goes to the government, what goes to health insurance... AI is a new way to flip bits. Hopefully a way that abstracts us a little bit further from having to think because our future is Wall-E. It's going to be great.

**中文翻译:**
SaaS 软件本质上就是“翻转比特”（bit flipping）。所有的 SaaS 应用都是比特翻转器……改变数据库里的数值，这就是它的全部工作……Rippling 的超能力之一是我们是一个“硬币分拣机”。你把一个员工的 2 万美元投进去……它会自动算出多少给政府，多少给医保……AI 只是翻转比特的一种新方式。希望能让我们进一步从思考中抽离出来，因为我们的未来就是《机器人总动员》（Wall-E）里的样子。那会很棒的。

---

### [01:24:37] Matt MacInnis

**English:**
One of the most important functions that I perform as an executive is the synthesis of ideas... I do turn to AI, ChatGPT and Gemini... I write the essay for the AI and I'm like, "Look, this is the crisp idea I want to communicate. Help me come up with pithy ways to articulate these things." And 80% of what it outputs is trash... But it is a thought partner... They are not useful in coming up with the ideas themselves.

**中文翻译:**
作为高管，我最重要的职能之一就是“思想的合成”……我会求助于 AI，比如 ChatGPT 和 Gemini……我会为 AI 写好初稿，然后说：“看，这是我想传达的核心思想。帮我找一些精炼的方式来表达这些内容。”它输出的 80% 都是垃圾……但它是一个思考伙伴……它们在产生创意本身方面没什么用，但在润色表达方面很有帮助。

---

### [01:26:34] Matt MacInnis

**English:**
We've spent a lot of time talking about intensity and the grind... And I think if you listen to that in a vacuum, it's very easy to believe that that intensity is soul crushing... which is that life is amazing. That the fact that we all exist on this blue marble drifting through space and time... if you remember how insignificant we are and all of this is, it brings this levity to what we do and to the work we put into building this.

**中文翻译:**
我们花了很多时间谈论强度和磨练……如果你孤立地听这些，很容易觉得这种强度会摧残灵魂……但事实是生命是奇妙的。我们都存在于这颗漂浮在时空中的蓝色大理石上……如果你记得我们和这一切是多么微不足道，它就会为你所做的事情和构建的事业带来一种轻松感。

---

### [01:27:47] Matt MacInnis

**English:**
Because Silicon Valley in 2025 is Florence and the Renaissance. It's crazy. The amount of creativity and insane invention and progress that's happening for our species right now in this place is absolutely unparalleled in all human history... Play the sport, play it with everything you've got, but never forget that it's just a sport and that none of it matters.

**中文翻译:**
因为 2025 年的硅谷就像文艺复兴时期的佛罗伦萨。这太疯狂了。此时此地正在发生的创造力、疯狂发明和人类进步，在整个人类历史上绝对是无与伦比的……去参与这项运动，全力以赴，但永远不要忘记这只是一场运动，这一切其实都没那么重要。

---

### [01:29:11] Lenny Rachitsky

**English:**
What are two or three books that you find yourself recommending most to other people?

**中文翻译:**
有哪两三本书是你向别人推荐最多的？

---

### [01:29:16] Matt MacInnis

**English:**
One book is Conscious Business... Fred Kofman... effectively, it's a user manual for human beings... Number two, Thinking in Systems, Donella Meadows... It is the best generic framework for thinking about how systems work. And then the third is classic 1960s, The Effective Executive... The good shit is the stuff that's been in print for 70 years, and that's one of them.

**中文翻译:**
第一本是《清醒企业》（Conscious Business），作者 Fred Kofman……实际上，它是人类的使用说明书。第二本是《系统之美》（Thinking in Systems），作者 Donella Meadows……它是思考系统运作方式的最佳通用框架。第三本是 60 年代的经典《卓有成效的管理者》（The Effective Executive）……真正的好东西是那些出版了 70 年还在印的书，这就是其中之一。

---

### [01:31:03] Matt MacInnis

**English:**
There's a new series called Heated Rivalry... It's about two hockey players. In Canada, rivals... who are just heated rivals on the ice... but actually they're secretly in love with each other and they start hooking up. And it's been labeled by the media as smutty but delightful.

**中文翻译:**
有一部新剧叫《激烈的竞争》（Heated Rivalry）……讲的是两个冰球运动员。在加拿大，他们是冰场上的死对头……但实际上他们暗地里爱着对方并开始约会。媒体评价它“有点色气但很令人愉悦”。

---

### [01:32:06] Matt MacInnis

**English:**
My Fellow coffee maker. I love my Fellow coffee maker. It's got an interface that lets you set light, medium, dark roast... Fellow is also a Rippling customer and that's a nice side effect...

**中文翻译:**
我的 Fellow 咖啡机。我爱死我的 Fellow 咖啡机了。它的界面可以让你设置浅、中、深烘焙……Fellow 也是 Rippling 的客户，这是一个很棒的副作用……

---

### [01:32:51] Matt MacInnis

**English:**
The motto comes from my dad who said, "Matt, nothing's ever so bad in life that it couldn't get worse." And it's like we were going through some shit yesterday at work... And we had a good laugh and continued to brace for whatever might come next.

**中文翻译:**
座右铭来自我父亲，他说：“Matt，生活中没有什么事情糟糕到不会变得更糟。”就像昨天我们在工作中遇到一些烂事……我们大笑一场，然后继续准备迎接接下来的挑战。

---

### [01:33:52] Matt MacInnis

**English:**
Well, so first of all, it's not DJ, Lenny. It's radio personality. And yeah, I used to do the greatest hits of all time with hits from the '60s, the '70s, the '80s, and a little bit of the '90s, 101.5 The Hawk. Yeah. You can turn it on. It's very inauthentic, but it sounds good on the radio.

**中文翻译:**
首先，Lenny，那不叫 DJ，那叫“电台主持人”。是的，我以前在 101.5 The Hawk 电台主持节目，播放 60、70、80 甚至 90 年代的金曲。你可以打开收音机听听。那种声音听起来很假，但在广播里效果很好。

---

### [01:34:55] Lenny Rachitsky

**English:**
Is there something you want to plug, point people to, and how can listeners be useful to you?

**中文翻译:**
有什么你想宣传或引导大家关注的吗？听众可以如何帮到你？

---

### [01:35:13] Matt MacInnis

**English:**
Look, my life is Rippling. I point people there... And the way that you can help me is that if you're a customer, you got to tell me when you have problems, because that's how we get better. DM me on Twitter @stanine. You can email me my last name at rippling.com.

**中文翻译:**
听着，我的生活就是 Rippling。我引导大家关注那里……你能帮到我的方式是：如果你是客户，有问题一定要告诉我，因为那是我们进步的方式。在 Twitter 上私信我 @stanine，或者发邮件到我的姓氏 @rippling.com。

---

### [01:35:27] Lenny Rachitsky

**English:**
Matt, thank you so much for being here. It's my pleasure. Thank you for having me, Lenny, and congrats on all the success with this podcast. It's been great.

**中文翻译:**
Matt，非常感谢你能来。这是我的荣幸。谢谢你的邀请，Lenny，祝贺你的播客取得如此大的成功，这真的很棒。