# Matt Mochary - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Matt Mochary.

---

### [00:00:00] Matt Mochary

**English:**
The biggest marker that I've seen between a botched layoff and a successful layoff is at the moment someone hears that they no longer have a job, did they hear it from their manager in a one-on-one? If that's when they heard it, it'll be okay. But if they heard it in an email, in a group chat, in any kind of thing where they were sitting next to or they're hearing it along with other people, it wasn't personalized, it wasn't one-on-one, that is terrible. That's when people get really angry and that's when they start going on to Twitter and going to newspapers and et cetera, because it feels dehumanizing. It feels like you didn't give a shit about me. You don't even have the courtesy to tell me to my face. And of course, there's no way to allow that person to express their emotions because they're in a group. So, that's the most important thing.

**中文翻译:**
我所见过的失败裁员与成功裁员之间最大的区别在于：当员工得知自己失去工作的那一刻，他们是从经理那里通过一对一的面谈听到的吗？如果是这样，那结果通常还好。但如果他们是通过邮件、群聊，或者在任何一种与他人坐在一起、同时听到消息的场合得知的，这种非个性化、非一对一的方式简直糟糕透顶。这正是人们感到愤怒的时候，也是他们开始在 Twitter 上发泄、找报纸曝光等等的时候，因为这让人感觉被非人化对待了。感觉就像你根本不在乎我，甚至连当面告诉我的基本礼貌都没有。而且，在群体环境中，那个人根本无法表达自己的情绪。所以，这是最重要的一点。

---

### [00:01:08] Lenny

**English:**
Welcome to Lenny's Podcast. I'm Lenny and my aim here is to help you get better at the craft of building and growing products. Today, my guest is Matt Mochary. Matt is a full-time executive coach, but not just any coach. He's worked with folks like Naval, the CEOs of OpenAI, Coinbase, Reddit, Rippling, Fair, Front, Notion, the list goes on. He's also coached partners at VCs like Sequoia, YC, Benchmark, many others.

**中文翻译:**
欢迎来到 Lenny 的播客。我是 Lenny，我的目标是帮助你提升构建和增长产品的能力。今天，我的嘉宾是 Matt Mochary。Matt 是一位全职高管教练，但他绝非普通的教练。他曾与 Naval 以及 OpenAI、Coinbase、Reddit、Rippling、Fair、Front、Notion 等公司的 CEO 合作，名单还在不断增加。他还指导过红杉资本 (Sequoia)、YC、Benchmark 等许多风投机构的合伙人。

---

### [00:01:34] Lenny

**English:**
We are so fortunate that Matt agreed to join me on this podcast and in our conversation we cover a lot of ground. We talk about why learning to fire people is one of the most important skills as a leader and how to do it well, why anger and fear often point you in the exact opposite direction you should be going, how to innovate within a larger company, how his coaching has evolved over the years, where the most successful founders still struggle, and so much more. This may be my new favorite episode and I bet it will be years, too. So much real talk with tactics, templates, all kind of goodness. Enjoy this conversation with Matt Mochary.

**中文翻译:**
我们非常荣幸 Matt 同意参加本期播客。在对话中，我们涵盖了广泛的话题。我们讨论了为什么学会解雇员工是领导者最重要的技能之一以及如何做好它；为什么愤怒和恐惧往往会指引你走向错误的方向；如何在大型公司内部进行创新；他的教练方式多年来是如何演变的；最成功的创始人依然在哪些方面感到挣扎，等等。这可能是我最喜欢的一集，我敢打赌也会成为你们的最爱。这里有很多实战经验、策略、模板和各种干货。请享受与 Matt Mochary 的这段对话。

---

### [00:02:12] Lenny

**English:**
This episode is brought to you by AssemblyAI. If you're looking to build powerful AI-powered features in your audio or video products, then you need to know about AssemblyAI. AssemblyAI is the API platform for state-of-the-art AI models the thousands of product-led growth companies like Spotify, Loom and CallRail are using to infuse AI into their products. With simple APIs, developers and PMs can get access to powerful AI models for transcription, summarization, and dozens of other tasks that are fast, secure, and production ready. All of their models are researched and trained in-house and continuously updated by their team of AI experts, which for a PM make it easy to build and ship new AI-powered features. Product teams with startups and enterprises are using AssemblyAI to automatically transcribe and summarize phone calls and virtual meetings, detect topics and podcasts, pinpoint when sensitive content is spoken, redact PII from audio videos, and way more. Visit AssemblyAI.com to try AssemblyAI's API for free and start testing their models in their no-code playground. That's AssemblyAI.com.

**中文翻译:**
本集节目由 AssemblyAI 赞助。如果你想在音频或视频产品中构建强大的 AI 功能，那么你需要了解 AssemblyAI。AssemblyAI 是一个提供顶尖 AI 模型的 API 平台，数千家产品驱动增长 (PLG) 的公司（如 Spotify、Loom 和 CallRail）都在使用它将 AI 注入产品中。通过简单的 API，开发人员和产品经理可以获取用于转录、摘要以及数十种其他任务的强大 AI 模型，这些模型速度快、安全且具备生产就绪性。他们所有的模型都是内部研发和训练的，并由 AI 专家团队持续更新，这让产品经理能够轻松构建并发布新的 AI 功能。初创公司和企业的团队正在使用 AssemblyAI 自动转录和总结电话及虚拟会议、检测播客主题、精准定位敏感内容、从音视频中脱敏个人隐私信息 (PII) 等等。访问 AssemblyAI.com 免费试用 API，并在其无代码游乐场中测试模型。

---

### [00:03:26] Lenny

**English:**
This episode is brought to you by Lemon.io. You've achieved product market fit, you're able to activate, engage, and retain your customers, but you don't have the engineers that you need to move as fast as you want to because it's hard to find great engineers quickly, especially if you're trying to protect your burn rate. Meet Lemon.io. Lemon.io will quickly match you with skilled senior developers who are all vetted, results-oriented, and ready to help you grow. And all that at competitive rates. Startups choose Lemon.io because they offer only handpicked developers with three or more years of experience and strong proven portfolios. Only 1% of candidates who apply get in, so you can be sure that they offer you only high quality talent. And if something ever goes wrong, Lemon.io offers you a swift replacement so that you're kind of hiring with a warranty.

**中文翻译:**
本集节目由 Lemon.io 赞助。你已经实现了产品与市场匹配 (PMF)，能够激活、留住客户，但你却没有足够的工程师来达到预期的速度，因为很难快速找到优秀的工程师，尤其是当你还要控制资金消耗率 (burn rate) 时。试试 Lemon.io 吧。Lemon.io 会为你快速匹配经过审核、以结果为导向且随时准备助你增长的资深开发人员，而且价格极具竞争力。初创公司选择 Lemon.io 是因为他们只提供经过挑选、拥有三年以上经验且有强大作品集的开发人员。只有 1% 的申请者能入选，因此你可以确信他们提供的是高质量人才。如果出现任何问题，Lemon.io 还会提供快速更换服务，让你招聘时更有保障。

---

### [00:04:15] Lenny

**English:**
To learn more, just go to lemon.io/lenny and find your perfect developer or tech team in 48 hours or less. And if you start the process now, you can claim a special discount exclusively for Lenny's Podcast listeners, 15% off your first four weeks of working with your new software developer. Grow faster with an extra pair of hands, visit lemon.io/lenny.

**中文翻译:**
欲了解更多信息，请访问 lemon.io/lenny，在 48 小时内找到理想的开发人员或技术团队。如果你现在开始申请，还可以享受 Lenny 播客听众专属的特别折扣：前四周合作费用减免 15%。借助额外的帮手实现更快增长，请访问 lemon.io/lenny。

---

### [00:04:43] Lenny

**English:**
Matt, thank you so much for being here. Welcome to the podcast.

**中文翻译:**
Matt，非常感谢你能来。欢迎来到本播客。

---

### [00:04:47] Matt Mochary

**English:**
Thanks for having me. I'm looking forward to it.

**中文翻译:**
谢谢邀请。我很期待这次对话。

---

### [00:04:49] Lenny

**English:**
I am looking forward to it even more. The way I learned about you is back in the day I read this book called The Great CEO Within, which I have right here, and I was like, holy moly, this is the most tactical, practical, useful book I've seen for leaders. I need to tell everyone about it, and I did. Then a few weeks ago, someone shared a link in my newsletter Slack community to this document that is called the Mochary Method Curriculum Document. I was like, oh my god, this is the most practical, tactical, useful document I've seen in a long time. I got to share this with everyone, and I did. Then I realized it's the same person that wrote these two things, and so I reached out to you and you kindly agreed to join me on this podcast. And so again, really appreciate you being here.

**中文翻译:**
我比你更期待。我了解你的契机是早些时候读了《伟大的 CEO 是如何炼成的》(The Great CEO Within) 这本书，我就在手边。当时我觉得，天哪，这是我见过的对领导者来说最具实操性、最实用的书。我必须告诉所有人，我也确实这么做了。几周前，有人在我的 Slack 社区分享了一个名为“Mochary Method 课程文档”的链接。我当时想，天哪，这是我很久以来见过的最实用、最硬核的文档。我必须分享给所有人，我也分享了。然后我意识到这两样东西是同一个人写的，于是我联系了你，你也很爽快地答应了。再次感谢你的到来。

---

### [00:05:30] Matt Mochary

**English:**
Thank you for having me.

**中文翻译:**
谢谢你的邀请。

---

### [00:05:32] Lenny

**English:**
Give folks a little bit of background on you who aren't so familiar with you, and just to help understand a little bit of a how you got so wise. Can you give folks just kind of a brief overview of some of the wonderful things you've done in your career, maybe some of the folks you've worked with and how you got to what you do now?

**中文翻译:**
给那些不太熟悉你的听众介绍一下你的背景吧，帮助大家理解你是如何变得如此睿智的。你能简要概述一下你职业生涯中做过的一些精彩事情吗？比如你合作过的人，以及你是如何走到今天这一步的？

---

### [00:05:47] Matt Mochary

**English:**
Right on. I've had a very varied career. I started a company back in internet 1.0 called Totality, which was a good financial outcome. Then I went and just had fun for a long time and then I went and did social good and helped ex-convicts get and keep a job by becoming truck drivers. All that was super fun, but I realized I missed my peers and I wanted to get back into the tech world, but I didn't want to start a company because a company is a lot of work and the end result is you make a lot of money, but I didn't need money.

**中文翻译:**
没问题。我的职业生涯非常多元。我在互联网 1.0 时代创办了一家名为 Totality 的公司，财务回报很不错。之后我玩了很长一段时间，然后去做公益，帮助刑满释放人员通过成为卡车司机来获得并保住工作。这些都非常有趣，但我意识到我怀念我的同行，想回到科技界。但我不想再开公司了，因为开公司太累了，最终结果虽然是赚很多钱，但我并不缺钱。

---

### [00:06:15] Matt Mochary

**English:**
And so I thought, how could I get in the tech world and not actually have to do the hard work? Oh, I could be a coach. I could coach people and then I just get to do the fun stuff and advise them and then they have to do the hard work. And so I looked around and thought, well how could I do that because I'm not a coach and so why would anyone listen to me? Then someone told me that there were students at Stanford that had started companies but no one would coach them. They couldn't get into YC because YC doesn't accept students. So, I went and started coaching them and it was super fun and very successful and then they started recommending me up the food chain and eventually, I met folks like Naval Ravikant and Sam Altman and Brian Armstrong and they recommended me around to the rest of the tech community, and ended up coaching some of the CEOs and the leaders of the biggest tech companies and biggest tech investment firms.

**中文翻译:**
于是我思考，怎样才能既进入科技界又不用干那些苦差事呢？哦，我可以当教练。我可以指导别人，这样我只需做有趣的部分——给建议，而苦活累活由他们干。我环顾四周，心想：我不是专业教练，凭什么有人听我的？后来有人告诉我，斯坦福有些学生创业了，但没人愿意指导他们，他们也进不了 YC，因为 YC 不收在校生。于是我开始指导他们，过程非常有趣且成功。接着他们开始向更高层级的人推荐我，最终我结识了 Naval Ravikant、Sam Altman 和 Brian Armstrong 等人。他们把我推荐给了整个科技圈，最后我开始指导一些顶级科技公司和顶级投资机构的 CEO 和领导者。

---

### [00:07:07] Matt Mochary

**English:**
It's been a ton of fun and for me, I do things for joy and each and every one of these interactions has been massively joyful for me and the people I coach become my really close friends, so it's all very selfish on my part.

**中文翻译:**
这非常有意思。对我来说，我做事是为了快乐，每一次互动都带给我巨大的喜悦，我指导的人也成了我的挚友，所以从我的角度来看，这其实是很“自私”的行为（因为我收获了快乐和友谊）。

---

### [00:07:21] Lenny

**English:**
I feel you on a lot of that. I also tried to explore starting a company again and similarly decided this is way too much stress and work, what else can I do instead? And that's what led to the work I do now, which I love.

**中文翻译:**
我深有同感。我也曾尝试再次创业，但同样觉得压力和工作量太大了，于是想还能做点什么？这就是我现在这份工作的由来，我非常热爱它。

---

### [00:07:34] Matt Mochary

**English:**
Right on.

**中文翻译:**
没错。

---

### [00:07:36] Matt Mochary

**English:**
That whole process started about 10 years ago, so about 10 years.

**中文翻译:**
整个过程大约是从 10 年前开始的，所以大概做了 10 年。

---

### [00:07:40] Lenny

**English:**
Awesome. You have a lot of fans on Twitter and the internet and ahead of this chat I polled folks on Twitter and asked them what they would ask you if they were chatting with you, so I thought I'd start off with asking you a few those questions and then we'll dig into a few very specific topics that I'm excited to talk about. The first question comes from Leo Polovets who's a GP at Susa Ventures, and he asked, "Matt has coached some incredible founders, what are some of the most common areas where even the most successful founders still struggle?"

**中文翻译:**
太棒了。你在 Twitter 和互联网上有很多粉丝。在这次对话之前，我在 Twitter 上征集了大家想问你的问题。我想先问几个，然后再深入探讨我感兴趣的特定话题。第一个问题来自 Susa Ventures 的合伙人 Leo Polovets，他问：“Matt 指导过很多了不起的创始人，那么即使是最成功的创始人，在哪些领域依然会感到挣扎？”

---

### [00:08:11] Matt Mochary

**English:**
Great question. To me, the bar is fear and how strongly do people feel fear? There are few people that I coach that just don't feel fear at all. And frankly with them, we have very tactical conversations, but they're the minority. The most feel fear to some degree, some feel it a lot, some feel it less, but when they feel it grips their mind and it prevents them from seeing... It prevents them from doing the thing that is difficult but necessary, so that's a lot of what our coaching is, me pointing out to them, hey, I think you're in fear.

**中文翻译:**
好问题。对我来说，关键在于“恐惧”以及人们感受恐惧的强烈程度。我指导的人中，极少数人完全感觉不到恐惧。坦白说，和他们交流时，我们只谈非常具体的战术问题，但他们是少数。大多数人在某种程度上都会感到恐惧，有的强烈，有的轻微，但当恐惧占据头脑时，它会阻碍人们看清现实……阻碍他们去做那些困难但必要的事情。所以我们的教练工作很大一部分就是我向他们指出：“嘿，我觉得你现在正处于恐惧之中。”

---

### [00:08:55] Matt Mochary

**English:**
What happens is very early on in coaching they'll go, yeah, okay, I'm in fear. So what? I go, great. I believe that fear is actually giving you bad advice and I think you're predicting that if you do this A will happen. Well, I'm predicting that if you do that, the exact opposite will happen. So, I'll tell you what, why don't we make a bet? This is very high stakes, why don't we pick something that's lower stakes? You make a prediction, we'll see if I make the opposite and then let's bet on it. So we pick something and then we make a bet on it, and whoever wins the bet in the future gets to determine what the actions are.

**中文翻译:**
在指导初期，他们通常会说：“是的，好吧，我确实在害怕。那又怎样？”我会说：“太好了。我相信恐惧实际上在给你提供错误的建议。你预测如果你做了某事，A 就会发生。而我预测如果你做了那件事，结果会截然相反。这样吧，我们打个赌。这件事风险很高，我们选个风险低点的事。你做一个预测，我做相反的预测，然后我们打赌。谁赢了，以后就由谁来决定行动方案。”

---

### [00:09:31] Matt Mochary

**English:**
I've made this bet hundreds of times and so far, I've never lost. It's not because I'm magician or a genius, it's because when someone's in fear, they're gripped. They can't see reality, their brain is making very exaggerated predictions. Whereas when someone is not in fear, and I'm not because it's not my situation, I am not gripped and therefore, my brain isn't making exaggerated predictions. And so, we make this bet once I win, then all of a sudden the CEO realizes, oh my God, there's something to this, fear gives bad advice. Then after that, all I need to do is remind the person that I perceive them to be in fear. That's all it takes, and they're like, oh, okay, and then they go ahead and do the thing that they feel fear about. Then of course, later they come back to me and say, Matt, that was magical. It works so well.

**中文翻译:**
我打过几百次这种赌，到目前为止还没输过。这不是因为我是魔术师或天才，而是因为当一个人处于恐惧中时，他被困住了。他看不清现实，大脑会做出非常夸张的预测。而当一个人不处于恐惧中时（比如我，因为那不是我的处境），我没有被困住，大脑也就不会做出夸张的预测。一旦我赢了赌约，CEO 就会突然意识到：“天哪，这真的有道理，恐惧确实会给出坏建议。”之后，我只需要提醒他们：“我察觉到你正处于恐惧中。”这就足够了，他们会说：“哦，好吧，”然后去执行那些让他们感到恐惧的事情。当然，后来他们会回来跟我说：“Matt，这太神奇了，效果非常好。”

---

### [00:10:23] Matt Mochary

**English:**
I mean, I'll give you examples. The most extreme is when a CEO realizes that there's a problem in the business and they haven't told their board yet and their board doesn't know, and remember, their board is their investors, and they have another round coming up, they know they're going to have to raise money in another six to 12 months. They need their current investors to participate in the upcoming round, otherwise outside investors won't. Then they say, well, what the hell do I do? I've got this problem. Do I tell my investors? And most often, the knee jerk reaction is, no, I'm not going to tell them.

**中文翻译:**
我给你举个例子。最极端的情况是，CEO 意识到业务出了问题，但还没告诉董事会，董事会也还不知情。记住，董事会就是他们的投资者，而他们即将进行下一轮融资，知道在未来 6 到 12 个月内必须筹钱。他们需要现有投资者参与下一轮，否则外部投资者也不会投。于是他们纠结：“我该怎么办？我有这个麻烦，要告诉投资者吗？”通常，他们的下意识反应是：“不，我不能告诉他们。”

---

### [00:11:01] Matt Mochary

**English:**
Then I say, "Well, I think that's fear. I think if you actually tell them, tell your investors, the exact opposite of what we think is going to happen is going to happen. You think you're going to lose their trust. I think you're going to gain their trust." And so, if we've done this fear exercise before, they do it, they share transparently with their board all the problems and say, and I'm excited to tackle these problems. Every single time that's happened, the board members have said, "This is fantastic. I love this honesty. Thank you so much. This is one of the only companies that I'm on the board of that actually is transparent and honest," and they gain trust.

**中文翻译:**
然后我会说：“我觉得这是恐惧在作祟。我认为如果你真的告诉投资者，结果会和你预想的截然相反。你以为会失去信任，我认为你会赢得信任。”如果我们之前做过这种恐惧练习，他们就会照做，透明地向董事会分享所有问题，并表示：“我很兴奋能去解决这些问题。”每一次这样做，董事会成员都会说：“太棒了，我喜欢这种诚实。非常感谢。这是我担任董事的公司中，极少数真正做到透明和诚实的公司之一。”于是，他们赢得了信任。

---

### [00:11:42] Lenny

**English:**
I'm glad that you brought this topic up. I wanted to spend time on it. Just to double click a little bit into it, just kind of to summarize your advice here, if you feel fear, which you may not recognize you feel, the advice is: do the opposite of what your brain is telling you to do, right?

**中文翻译:**
很高兴你提到这个话题，我正想聊聊这个。为了深入探讨一下，总结你的建议：如果你感到恐惧（尽管你可能没意识到），建议就是：去做你大脑告诉你的相反的事情，对吗？

---

### [00:11:57] Matt Mochary

**English:**
Generally, I mean, check with someone. Don't just randomly, I feel fear crossing the street crossing a crowded highway and then go, oh, that's fear talking. I should cross the highway anyway and then get hit by a cop. No, that's not what I mean. I don't mean physical danger, I mean things that we perceive to be danger to our egos, but that the easiest thing is just to check with somebody else who's not in fear because they will be able to see clearly when you can't.

**中文翻译:**
通常是这样，但我的意思是，要找人核实。不要盲目行事，比如我过拥挤的高速公路时感到恐惧，然后说：“哦，那是恐惧在说话，我应该直接冲过去，”结果被车撞了。不，我不是那个意思。我指的不是物理上的危险，而是那些我们认为会威胁到“自我/面子”的事情。最简单的方法就是去问一个不处于恐惧中的人，因为当你看不到真相时，他们能看得很清楚。

---

### [00:12:24] Lenny

**English:**
I was working through your curriculum and you pointed out that you found a way to express to somebody that they are in fear. I think it was your wife that kind of iterated on how to give you feedback that you're in fear where you didn't get defensive, you got more fearful and angry and can you talk a bit about that?

**中文翻译:**
我在研究你的课程时，你提到你找到了一种向别人表达他们正处于恐惧中的方式。我记得是你妻子不断尝试，寻找如何反馈你正处于恐惧中，而不会让你产生防御心理、变得更恐惧或愤怒的方式。你能聊聊这个吗？

---

### [00:12:40] Matt Mochary

**English:**
Yeah, so we iterated, I at times feel anger and I act on that anger and I don't even realize I'm in anger, so I wanted her to let me know, and so she would say, at first she said, "You're in anger," and that just made me feel accused and made me go into more anger. And then she said, "Are you in anger?" And that felt passive aggressive or indirect and that also made me go into more anger. Then finally she said, "I perceive you to be an anger." So it's an I statement and it's simply what she's perceiving. There's no judgment. That was able to punch through my anger and then I woke up and went, oh, and then I stopped and just didn't act until I was able to shift out of anger.

**中文翻译:**
是的，我们反复尝试过。我有时会感到愤怒并随之采取行动，而我甚至没意识到自己在生气。所以我希望她能提醒我。起初她说：“你在生气，”这让我觉得被指责，反而更生气。后来她问：“你在生气吗？”这听起来像是消极抵抗或转弯抹角，也让我更生气。最后她说：“我察觉到你正处于愤怒中。”这是一个“我”字开头的陈述句，仅仅表达她的感受，没有任何评判。这句话成功击穿了我的愤怒，让我清醒过来：“哦。”然后我停了下来，直到情绪平复才继续行动。

---

### [00:13:25] Lenny

**English:**
Awesome. And anger and fear, I think there's different pieces of advice for if you feel angry versus fear. Is that right?

**中文翻译:**
太棒了。关于愤怒和恐惧，我觉得应对建议是不同的，对吗？

---

### [00:13:32] Matt Mochary

**English:**
Yes. I mean, anger, you're just destroying and what you're doing is you're destroying relationships and so you just got to stop because you're breaking glass. Of course, you're breaking it with the people who are closest to you. They're the people who are nearest to you, which are the people you love and care about the most. They're not only people you work with, but they're the people you live with and you don't want to do that. You don't want to hurt them.

**中文翻译:**
是的。愤怒是在破坏，你在破坏人际关系，所以你必须停下来，因为你正在“砸碎玻璃”。而且，你砸碎的是与最亲近的人之间的关系。他们是你身边的人，是你最爱、最在乎的人。他们不仅是你的同事，还是你的家人，你并不想伤害他们。

---

### [00:13:59] Lenny

**English:**
Yeah. Maybe one last question along these lines, why do we do this? Is this just we're trying to protect our ego and ourselves and we just want to do the safe thing?

**中文翻译:**
是的。关于这一点最后一个问题：我们为什么要这样做？仅仅是为了保护我们的自尊和自我，只想做安全的事情吗？

---

### [00:14:06] Matt Mochary

**English:**
That's it. I mean, I just learned very recently, and this isn't written anywhere because I just learned it, someone shared with me that anger is not a base emotion. Anger is actually a cover. It's a cover for when we feel pain, and so our brain doesn't want to feel the pain, so instead it externalizes it. But the problem is it shoves that pain onto everybody else around us. The real answer here is not to have people let us know that we're in anger and then stop. The real answer is just to allow ourselves to feel the pain and it sucks by the way, it actually hurts. But then we're not... Sorry, I'm getting emotional. We're not pushing that out onto other people and I only learned this very recently and I'm just starting to practice this and I'm still not good at it, but I'm now at least sometimes not going to anger.

**中文翻译:**
就是这样。我最近刚学到一点，这还没写在任何地方，因为我刚知道：有人告诉我，愤怒不是一种基本情绪，它其实是一种掩护。它是当我们感到痛苦时的掩护，我们的大脑不想感受痛苦，所以将其外化。但问题是，它把痛苦推给了周围的每个人。真正的答案不是让别人提醒我们处于愤怒中然后停下来，真正的答案是允许自己去感受那份痛苦——顺便说一下，那感觉糟透了，真的很疼。但这样我们就不会……抱歉，我有点激动。我们就不会把痛苦推给别人。我最近才学到这一点，刚开始练习，还做得不好，但至少现在有时我不会直接陷入愤怒了。

---

### [00:15:02] Lenny

**English:**
It's interesting how personal this advice is that it sounds like something that you deal with. It's not just like you're this coach that's just like, hey guys, here's all these problems you have. Here's how you fix stuff that you help yourself with.

**中文翻译:**
很有意思，这些建议非常个人化，听起来是你自己也在面对的事情。你不仅仅是一个高高在上的教练说“嘿伙计们，这是你们的问题，这是解决方法”，你也在用这些方法帮助你自己。

---

### [00:15:15] Matt Mochary

**English:**
I'm human. Yes, and that's why I try to figure it out with me and if I can figure something out with me, then I can share it with others.

**中文翻译:**
我也是人。是的，这就是为什么我先尝试解决自己的问题，如果我能搞定自己的问题，我就能分享给别人。

---

### [00:15:24] Lenny

**English:**
Amazing. That was a fruitful question from Leo, and we might come back to this topic.

**中文翻译:**
太棒了。Leo 的这个问题很有收获，我们待会儿可能还会回到这个话题。

---

### [00:15:30] Matt Mochary

**English:**
By the way, this also applies to organizations. I mean, the way that I used to get all this information about how to run organizations is I started a company, Totality, and my co-founder and I, we did a terrible job running that company. What happened was I didn't have any learnings from that which I could share with people because it was just worst practices, not best practices. But then 10 years later, I thought to myself, well, how could I have done that better? How could we have done that better?

**中文翻译:**
顺便说一下，这也适用于组织。我过去获取管理组织信息的方式是：我创办了 Totality 公司，我和合伙人管理得一塌糊涂。结果就是，我当时没有任何可以分享的经验，因为那全是“最差实践”，而非“最佳实践”。但 10 年后，我开始反思：我本可以怎样做得更好？我们本可以怎样做得更好？

---

### [00:15:55] Matt Mochary

**English:**
So, I picked up a book, a business book, it was High Output Management by Andy Grove. I read it and I was like, "Oh my God, here are all the answers." And then I read another book, The Hard Thing About Hard Things by Ben Horowitz was like, "Oh my God, there are even more answers." I just kept reading more and more business books, and every one I read, they were just chock full of answers. But then I needed to test whether or not these really worked, so that's when I started coaching and I started testing them in companies, but I had to let the people know here, do this, but they weren't going to read a 350 page book. I had to summarize it in two pages and then share it with them, and then they did, and then they implemented it and it worked.

**中文翻译:**
于是我拿起一本商业书，是安迪·格鲁夫的《高产出管理》(High Output Management)。读完后我想：“天哪，答案都在这儿。”接着我读了本·霍罗威茨的《创业维艰》(The Hard Thing About Hard Things)，心想：“天哪，还有更多答案。”我不断阅读更多的商业书籍，每一本都充满了答案。但我需要测试这些方法是否真的有效，于是我开始做教练，在公司里测试它们。但我得告诉人们该怎么做，而他们不会去读 350 页的书。我必须把它总结成两页纸分享给他们，然后他们照做了，执行了，而且奏效了。

---

### [00:16:29] Matt Mochary

**English:**
Then I had all these summaries, and then I started to create my own summaries of little niche cases that weren't in any book that I'd read. That's where all these writings came from. Then one day, someone that I was coaching said, "Matt, you got to take all these writings. They're a book, you got to publish them." And I said, "No, I don't." My friend said, "Well, how about I do all the work? How about I take care of the editing and the publishing?" And I was like, "Okay, if you want to do that, great." That was Alex MacCaw. Others had offered before, but he was the one that actually followed through all the way to the end. That was it. That's how the book was born.

**中文翻译:**
于是我有了这些总结，接着我开始针对书中没提到的细分案例撰写自己的总结。这就是这些文字的由来。有一天，我指导的一位客户说：“Matt，你得把这些东西集结成书出版。”我说：“不，我不想。”我的朋友说：“那我来干所有的活儿怎么样？我负责编辑和出版。”我说：“行，如果你想做的话，太好了。”那个人就是 Alex MacCaw。之前也有人提议过，但他是唯一一个真正坚持到底的人。就这样，那本书诞生了。

---

### [00:17:06] Matt Mochary

**English:**
But I realized also, recently, that many of my most radical ideas, I can't get anyone to test them because I'll say, "Hey, I think you should do blank." And the CEO will say, "That sounds crazy. Matt, can you point me to other examples of other people that have done this and it's worked?" And I say, "No, this is an original thought that came out of my head. No one's done it before that I know of." They're like, "Okay, well I'm not going to be the first."

**中文翻译:**
但我最近也意识到，我有很多激进的想法没人愿意测试。我会说：“嘿，我觉得你应该做某某事。”CEO 会说：“这听起来太疯狂了。Matt，你能给我举几个别人做过且成功的例子吗？”我会说：“不，这是我脑子里蹦出来的原创想法，据我所知还没人做过。”他们就会说：“好吧，那我也不想当第一个吃螃蟹的人。”

---

### [00:17:33] Matt Mochary

**English:**
Then I realized I needed an organization to test my most radical ideas, and also all of my CEOs had been asking me to create software because I have a methodology and it's step one, step two, step three, and you do it in one-on-ones and then a methodology for a team meeting and then a methodology for feedback and then a methodology for every different motion in the company. It's all in Google Docs. And they said to me, "Matt, this is amazing. I love this one-on-one process. I love your team process, but I don't want to have to teach each of my reports the way you've taught me. I'd like it just being softer. I just hit a button and boom, it happens automatically." At first, I said, "No, that's not interesting to me. I'm not a developer. You, Brian Armstrong, you're a developer and you have a thousand engineers that work for you. Why don't you go create it?"

**中文翻译:**
于是我意识到我需要一个组织来测试我最激进的想法。而且，我所有的 CEO 客户都一直要求我开发软件，因为我有一套方法论：第一步、第二步、第三步，包括一对一、团队会议、反馈以及公司各种运作流程的方法。这些目前都在 Google 文档里。他们对我说：“Matt，这太棒了。我喜欢你的一对一流程和团队流程，但我不想像你教我那样去教我的每一个下属。我希望它能软件化，我点个按钮，砰，它就自动运行了。”起初我说：“不，我对那没兴趣。我不是开发人员。你，Brian Armstrong，你是开发人员，你手下有一千个工程师，你为什么不去开发呢？”

---

### [00:18:21] Matt Mochary

**English:**
But in the end, I said, "Okay, this could be fun." So, I hired a team of developers and we started to create the software, and one, the product is working. But two more importantly, I now have a team of humans that we work together that I can start testing my more radical ideas out with. I would say about half of them are wildly successful and the other half complete duds. It almost seems like one are the other. But now I have my own basically laboratory to test things. Of course, when I see radical things that other people are doing, I try them in our organization, and it's phenomenal.

**中文翻译:**
但最后我想：“好吧，这可能挺有意思。”于是我雇了一个开发团队开始做软件。第一，产品确实有效；第二，更重要的是，我现在有了一个共同工作的团队，我可以开始在他们身上测试我那些更激进的想法。我得说，大约一半的想法大获成功，另一半则彻底失败。似乎总是非此即彼。但现在我有了自己的“实验室”来测试。当然，当我看到别人在做的激进尝试时，我也会在我们的组织里试一下，效果非常惊人。

---

### [00:18:59] Matt Mochary

**English:**
I'll tell you the most radical one. I was asking one CEO, I said, "Have you ever let someone go and regretted it?" He said, "No." And I said, "Well, then you don't know what the bar is because the bar of where you should be letting people go is here, and the bar that you've let people go is here. So until you get close to that line, you don't know what that line is." He said, "Wow, that's true." Then I thought about it and I thought to myself, uh-oh, I have never let anyone go that I regret it, so I don't know where the line is.

**中文翻译:**
我给你讲个最激进的。我曾问一位 CEO：“你有没有解雇过某人后感到后悔的？”他说：“没有。”我说：“那你就不知道标准在哪里。因为你应该解雇人的标准线在这里，而你实际解雇人的标准线在那里。在你接近那条线之前，你永远不知道它在哪。”他说：“哇，有道理。”然后我反思了一下，心想：糟糕，我也从来没有解雇过让我后悔的人，所以我也不知道那条线在哪。

---

### [00:19:34] Matt Mochary

**English:**
Then I thought, oh no, I've got to go into my team and let someone go, and here's the problem. We've already done talent density, we've already done the Netflix thing. If someone is meeting expectation, we let them go. We've already let all those folks go. So on our team, it's only outperformers. So, I thought there was one guy, he's an outperformer, no question about it, and super positive, an amazing guy and can do anything and is happy to do everything. But there wasn't much left for him to do because everything else was being covered. I talked to my number two and said, "Can you do what you're doing and what he's doing?" And she said, "Give me two weeks," and she did. She came back and said, "Yeah, I can." So, we let him go.

**中文翻译:**
于是我想：不行，我得在我的团队里解雇一个人。问题是，我们已经实行了“人才密度”策略，就是 Netflix 那一套：如果有人只是“符合预期”，我们就请他走。那些人都已经走了。所以我们团队里全是“表现卓越者”。我想到一个家伙，他绝对是表现卓越，非常积极，是个了不起的人，什么都能干，也乐意干任何事。但当时已经没什么活儿给他干了，因为其他事情都有人负责。我问我的二把手：“你能同时做你现在的工作和他正在做的工作吗？”她说：“给我两周时间。”两周后她回来告诉我：“是的，我可以。”于是，我们解雇了他。

---

### [00:20:19] Matt Mochary

**English:**
Now, when I let someone go, I try to do it with a massive amount of compassion because I know it's brutal. I mean, losing your spouse, your home, and your job, these are the three most traumatic things that can happen to you. When that happens, of course you go into massive fear and the brain shuts down, so I want to be there and help them through that process and actively help them find their dream job because there is a place that absolutely needs them. So, what I do is I become their agent and I say, "I want to help you discover what it is that your ideal role is, and I want to help you create it or land it." I did that with him. Turns out, what he wanted to do was go start a company and create a new product so he could just start that day one. But, the litmus for me is that everybody I've let go, I believe anyway, that I continue to be friends with. That shows me that the process by which I let people go is a humane one.

**中文翻译:**
现在，当我解雇某人时，我会带着极大的同情心去做，因为我知道这很残酷。失去配偶、失去家园、失去工作，这是人生中最痛苦的三件事。当这种事发生时，人当然会陷入巨大的恐惧，大脑会宕机。所以我想陪在他们身边，帮他们度过这个过程，并主动帮他们找到理想的工作，因为一定有某个地方绝对需要他们。所以，我会成为他们的“经纪人”，我说：“我想帮你发现你的理想职位是什么，并帮你创造或获得它。”我对他也这么做了。结果发现，他想去创业，开发一个新产品，所以他第一天就可以开始。对我来说，检验标准是：我解雇过的每一个人，至少我相信是这样，我们依然是朋友。这向我证明，我解雇人的过程是人性化的。

---

### [00:21:17] Matt Mochary

**English:**
Here's the crazy thing, after letting this guy go, after about 30 days, I was like, ugh, did I do the wrong thing? Was that too much? But then after about two to three months, I realized, no, that actually was the right thing because my number two was able to absorb the things that he was doing and here's the crazy part, with fewer people in the organization, things work better. That's the big realization that most people never discover. they hit product market fit, they get tons of money from investors, just higher, higher, higher, higher, but every additional human you have in your organization causes extra overhead and geometrically so, because now you have to keep all those people informed, give them all context, make them all feel heard, because unless they feel like they're contributing and you understand what they're saying, then they feel ignored and they feel passed over and they feel disrespected and grumpy.

**中文翻译:**
疯狂的事情发生了：解雇他大约 30 天后，我还在想：“呃，我是不是做错了？是不是太过分了？”但两三个月后，我意识到：不，那绝对是正确的决定。因为我的二把手能够吸收他之前做的工作。而且最疯狂的部分是：组织里的人越少，运作效率反而越高。这是大多数人从未发现的重大感悟。他们实现了 PMF，从投资者那里拿到了巨额资金，然后就不停地招人、招人、招人。但组织中每增加一个人，都会带来额外的管理成本，而且是呈几何级数增长的。因为现在你必须让所有人知情，给他们背景信息，让他们感到被倾听。除非他们觉得自己在做贡献且你理解他们的想法，否则他们会感到被忽视、被冷落、不被尊重，从而变得脾气暴躁。

---

### [00:22:11] Matt Mochary

**English:**
There's this morale problem that exists. There's this friction of information flow and a morale problem that grows and grows and grows. Really, the only answer is, I mean, that's why people bring me in because they're growing, growing, growing, and things are breaking. I have a system that keeps things together, but it doesn't make it perfect. It just makes it so that the company doesn't fall apart. But really the ideal is just to keep the team super small. That's what WhatsApp did, that's what Instagram did, that's what Linear is doing right now. That's what Notion has been doing for a while. Those, to me, are the real success stories.

**中文翻译:**
这就产生了一个士气问题。信息流动的摩擦和士气问题会不断增长。唯一的答案是——这也是为什么人们请我去做教练，因为他们一直在扩张，然后系统开始崩溃。我有一套系统能维持局面，但它并不完美，只是让公司不至于散架。但真正的理想状态是保持团队极度精简。WhatsApp 是这么做的，Instagram 是这么做的，Linear 现在也是这么做的，Notion 已经坚持这么做很久了。对我来说，这些才是真正的成功案例。

---

### [00:22:53] Lenny

**English:**
This reminds me of a story I just listened to on Lex Fridman's podcast. They were interviewing the head of AI at Tesla, or former head of AI, and Lex was asking him, "Why did you get rid of LiDAR on your cars? Like aren't more sensors good so that you can be better at self-driving?" And he's like, "If you have LiDAR, you got to think about the supply chain and getting all those parts. You got to think about all the additional data that it brings and adds more chaos to your data, and you have to think about that. Think about if that one part is gone, everything slows down, and in theory it is better, but then all these other factors end up making it worse." Talking about how Elon's philosophy is the best part is no part. It feels like that's exactly what you're saying.

**中文翻译:**
这让我想起我在 Lex Fridman 播客上听到的一个故事。他们采访了特斯拉的前 AI 主管，Lex 问他：“为什么你们去掉了车上的激光雷达 (LiDAR)？传感器不是越多越好吗，这样自动驾驶不是更强吗？”他回答说：“如果你有激光雷达，你就得考虑供应链和零件获取。你得考虑它带来的额外数据，这会增加数据的混乱度。如果那个零件缺货，整个进度都会慢下来。理论上它更好，但所有这些其他因素最终让结果变得更糟。”这谈到了马斯克的哲学：最好的零件就是没有零件。感觉这正是你所表达的意思。

---

### [00:23:36] Matt Mochary

**English:**
That's right.

**中文翻译:**
没错。

---

### [00:23:37] Lenny

**English:**
You're getting to all the stuff I want to talk about, which is awesome. So firing people, this is good. We were chatting earlier and you mentioned that this is a skill that most managers are really bad at and maybe is the most important skill to develop as a leader and as a manager. People are just bad at it. You shared a few pieces of advice there, but is there anything else that you could share about just how to get better at firing people and that skill?

**中文翻译:**
你正聊到我所有想谈的话题，太棒了。关于解雇员工，这很好。我们之前聊过，你提到这是大多数经理都非常不擅长的技能，但也许是作为领导者和经理需要培养的最重要的技能。人们就是不擅长这个。你分享了一些建议，关于如何提高解雇员工的技能，还有什么可以分享的吗？

---

### [00:24:03] Matt Mochary

**English:**
Yeah, the reason people are bad at this is because they think that they're hurting the person who they're letting go. I mean, how many times have I heard from someone, "Yeah, this person's not performing, but gosh, they really need this job and their mother has cancer," and whatever personal situation they're in. Wei Deng, who is the CEO of Clipboard Health, who's one of my favorite CEOs, who frankly I learn more from her than she learns from me, she shared with me her framework for making decisions, which is she separates the decision from the implementation, meaning she thinks about who is the stakeholder here that I'm solving for? And almost always in a company, you're solving for the customer. So, what would the customer want to see happen? That's the decision. Of course, the customer would want to see only the best employees and anyone who isn't a great employee, don't be there.

**中文翻译:**
是的，人们不擅长这个是因为他们觉得自己是在伤害被解雇的人。我听过无数次这样的话：“是的，这个人表现不好，但天哪，他们真的很需要这份工作，他母亲还患了癌症，”诸如此类的个人处境。Clipboard Health 的 CEO 魏登 (Wei Deng) 是我最喜欢的 CEO 之一，坦白说我从她身上学到的比她从我这儿学到的还多。她向我分享了她的决策框架：将“决策”与“执行”分开。这意味着她会思考：我是在为哪个利益相关者解决问题？在公司里，几乎总是为了客户。那么，客户希望看到什么发生？这就是决策。当然，客户只希望看到最优秀的员工，任何不优秀的员工都不该在那儿。

---

### [00:24:52] Matt Mochary

**English:**
Now the implementation is, if I do this, if I let this person go, who gets hurt? Well, the employee gets hurt. Maybe I get hurt because it's a painful conversation. Maybe the rest of the team gets hurt because they're sad that their friend is leaving. Then you look at, well, what can we do? Each person who gets hurt, what is it that they really want? Let's see if we can help them get what they really want. Well, the person let go, what do they want? They want a great job where they're actually needed and they feel fulfilled, so they enjoy what they're doing and they're actually critical to the company or organization that they're with. Right now they're not, by the way, they're not critical, clearly. So you're actually holding them back from what it is that they really want.

**中文翻译:**
而执行则是：如果我这么做，如果我解雇这个人，谁会受到伤害？员工会受伤。我也许会受伤，因为这是一场痛苦的对话。团队其他人也许会受伤，因为他们为朋友的离开感到难过。然后你看，我们能做什么？每个受伤害的人，他们真正想要的是什么？看看我们能否帮他们得到想要的。被解雇的人想要什么？他们想要一份真正需要他们、让他们有成就感的好工作，让他们享受所做的事，并成为公司或组织中不可或缺的一员。顺便说一下，他们现在显然不是不可或缺的。所以你实际上是在阻碍他们获得真正想要的东西。

---

### [00:25:36] Matt Mochary

**English:**
What you do is you help them find that place that really needs the skill or the passion that they have. Yourself, what do you really want? You want to not have a difficult conversation? Well, cognitive behavior therapy, the best way to get over that is to actually have one and realize it's not that bad. Then the rest of the team, they feel sad because their teammate left. Well, here's how you solve what they really want is they want to know that... They want to release their emotions. Okay, great. Listen to them, let them share their emotions, let them share the sadness that they feel, and then it's released out of their body.

**中文翻译:**
你要做的是帮他们找到那个真正需要他们的技能或热情的地方。至于你自己，你真正想要的是什么？你是不想进行艰难的对话吗？根据认知行为疗法，克服恐惧最好的办法就是去进行一次对话，然后发现其实没那么糟。至于团队其他人，他们因为队友离开而难过。解决办法是满足他们真正的需求：他们需要释放情绪。好，那就倾听他们，让他们分享情绪，分享悲伤，然后这些情绪就会从他们身体里释放出来。

---

### [00:26:12] Matt Mochary

**English:**
Decision is one thing, implementation is completely and utterly separate. That's the same thing here in letting someone go. But if you let them go kindly and humanely, the key is, in my opinion, you become their agent, like Michael Ovitz, the CAA agent. You help them find their next job actively. Michael Ovitz is the one who reaches out to employers for his clients and says, "Hey, do you have work for my client?" That's what I mean by being agent, not by, if you need a reference from me, I'll be happy to give you reference. That's bullshit, that's passive.

**中文翻译:**
决策是一回事，执行完全是另一回事。解雇员工也是如此。如果你能友善且人性化地解雇他们，关键在于——在我看来——你要成为他们的“经纪人”，就像 CAA 的经纪人 Michael Ovitz 那样。你要主动帮他们找下一份工作。Michael Ovitz 会主动联系雇主说：“嘿，你有适合我客户的工作吗？”这就是我说的“经纪人”，而不是说“如果你需要推荐信，我很乐意提供”。那是废话，那是被动的。

---

### [00:26:50] Matt Mochary

**English:**
I'm talking about active, and it doesn't take long. Maybe one to two hours of my time reaching out to people I know saying, "Hey, I've got this great person." Oh my God, of course they're going to pay attention. Of course, they're going to react. Now you might say, well, wait a second, what if the person isn't great? What if they're a bad performer and my posit is that they're good at something. You have to find out what it is they're good at. And really what they're good at is what they're passionate about, so find out what they're passionate about and that you can recommend them for. That's what I do.

**中文翻译:**
我说的是主动出击，这花不了多少时间。也许花我一两个小时联系熟人说：“嘿，我这儿有个很棒的人。”天哪，他们当然会关注，当然会有所反应。你可能会说：“等等，如果那个人不优秀怎么办？如果他表现很差呢？”我的观点是，每个人都有擅长的事。你必须找出他们擅长什么。而他们真正擅长的通常是他们热爱的事，所以找出他们的热情所在，并以此推荐他们。这就是我做的。

---

### [00:27:25] Matt Mochary

**English:**
I think for almost all managers that aren't good at letting go, it's because A, they've never done it, or B, they've done it badly. They didn't help the person, and that person then went off and had a very painful time and now hates that manager. But if you actively help that person, they will appreciate it. Now, there are situations when a person says, "Screw you, I don't want your help." Okay, but they still recognize that you offered.

**中文翻译:**
我认为几乎所有不擅长解雇员工的经理，要么是因为 A：从未做过；要么是因为 B：做得太烂。他们没有帮助那个人，导致那个人离开后过得很痛苦，从此痛恨那个经理。但如果你主动帮助那个人，他们会感激的。当然，也有人会说：“去你的，我不需要你的帮助。”没关系，但他们仍然会意识到你曾提供过帮助。

---

### [00:27:56] Lenny

**English:**
Who's the best person at firing that comes to mind when you think of this person's really good at this?

**中文翻译:**
当你想到“谁非常擅长解雇员工”时，脑海中浮现的第一个人是谁？

---

### [00:28:01] Matt Mochary

**English:**
Wei Deng from Clipboard Health. She's the most compassionate.

**中文翻译:**
Clipboard Health 的魏登。她是最有同情心的。

---

### [00:28:07] Lenny

**English:**
Awesome. The framework you shared reminds me of something my manager once taught me similarly. They missed the final piece of actually being their agent and finding their next gig, but just the idea of separate the emotion and doing the thing from, if there were no feelings involved, what would you do? And then you should do that, and that might be hard.

**中文翻译:**
太棒了。你分享的框架让我想起我的一位经理曾教过我的类似方法。他们漏掉了最后一步——也就是成为经纪人帮他们找下家，但“剥离情感”这个理念是一样的：如果没有情感因素，你会怎么做？那就去做，尽管这可能很难。

---

### [00:28:26] Matt Mochary

**English:**
That's exactly right. By the way, this whole thing about no feelings, I do have probably two CEOs that don't feel emotions. They don't feel fear, they don't feel anger. One, in particular, feels zero emotions. I have to say, he's a machine, he's an operating machine and there's zero time between ah, this is the right thing to do and doing it. It's amazing. It's an incredibly well run company and an incredibly valuable company. So yeah, emotions typically, again, typically fear and anger are the ones that derail our brains.

**中文翻译:**
完全正确。顺便说一下，关于“没有情感”这一点，我确实有大概两个 CEO 客户几乎没有情绪。他们感觉不到恐惧，也感觉不到愤怒。其中一个特别典型，完全没有情绪。我不得不说，他就像一台机器，一台高效运转的机器，从意识到“这是正确的事”到“去执行它”之间的时间差几乎为零。这太惊人了。那是一家管理极好、价值极高的公司。所以是的，情绪——通常是恐惧和愤怒——会干扰我们的大脑。

---

### [00:29:08] Lenny

**English:**
It makes me think of Alex Honnold, I think is his name, the free climber, the solo dude. His amygdala doesn't quite function so he doesn't-

**中文翻译:**
这让我想起了 Alex Honnold（我想是这个名字），就是那个徒手攀岩的大神。他的杏仁核（大脑中处理恐惧的部分）功能不太一样，所以他不会——

---

### [00:29:19] Matt Mochary

**English:**
That's right.

**中文翻译:**
没错。

---

### [00:29:21] Lenny

**English:**
That's interesting. He could be a free solo climber, he could be a CEO.

**中文翻译:**
很有意思。他可以去徒手攀岩，也可以当 CEO。

---

### [00:29:25] Matt Mochary

**English:**
That's right. CEO's a little safer. The prediction for Alex is that he will at some point, unfortunately die.

**中文翻译:**
没错。当 CEO 稍微安全点。对 Alex 的预测是，他不幸在某个时刻可能会……（摔死）。

---

### [00:29:33] Lenny

**English:**
Yeah. Did you see The Alpinist? Not to spoil anything.

**中文翻译:**
是的。你看过《阿尔卑斯人》(The Alpinist) 吗？就不剧透了。

---

### [00:29:36] Matt Mochary

**English:**
Yes.

**中文翻译:**
看过。

---

### [00:29:38] Lenny

**English:**
Okay, moving on from that, I'm curious, in a remote world, does your advice change in terms of firing? It seems like everything you shared you could do easily in person or remote, but does something change when you're doing it over Zoom?

**中文翻译:**
好，换个话题。我很好奇，在远程办公的世界里，你关于解雇员工的建议会有变化吗？看起来你分享的所有内容在面对面或远程时都很容易做到，但通过 Zoom 进行时会有什么不同吗？

---

### [00:29:51] Matt Mochary

**English:**
No, it doesn't change at all. There is one point I didn't include, which I'll include now, is there's helping the person be their agent, but there's also allowing the person, whenever I have a difficult conversation, I start it off, "Hey, this is going to be a difficult conversation. I want you to take a few seconds and prepare yourself. You are not going to enjoy this." What I found is that the way the amygdala gets triggered is often because of surprise. So, if you give someone just a few seconds to mentally prepare, then the amygdala often doesn't get triggered nearly as hard because if they're aware that they're going to go into fear, they're going to go into anger, they're going to go into sadness, then they can see it coming and they go, oh, that's what it is. But if they don't see it coming, just a surprise and all of a sudden it grips their whole brain and now they're in it and they don't even know they're in it.

**中文翻译:**
不，完全没有变化。有一点我刚才没提到，现在补充一下：除了帮他们当经纪人，还要给对方心理准备。每当我进行艰难对话时，我都会开头说：“嘿，这将是一场艰难的对话。我希望你花几秒钟准备一下，你不会喜欢接下来的内容的。”我发现，杏仁核被触发通常是因为“意外”。所以，如果你给对方几秒钟心理准备，杏仁核的反应通常不会那么剧烈。因为如果他们意识到自己即将陷入恐惧、愤怒或悲伤，他们就能预见到它的到来，并想：“哦，就是这种感觉。”但如果毫无预兆，突如其来的意外会瞬间占据整个大脑，他们陷入其中甚至不自知。

---

### [00:30:43] Matt Mochary

**English:**
That's the first thing I do. This is going to be a difficult conversation. Are you ready? Then I share the news. I'm letting you go, here's why. Then second, I deliver the message. The third thing is now they're feeling emotions, strong ones. Even though I warned them, they're still feeling them. Now you want them to be able to release those emotions, and so I say to them, "My guess is you're feeling a lot of anger right now, fear, sadness. Is that true? And if so, would you be willing to share with me what you're feeling and what you're thinking?" Sometimes they don't answer, but many times they do and they share with me and they let it out. That's important to allow them to let it out. Then I make them feel heard and I actively listen. That makes them realize that I'm not trying to run away from the pain that they're feeling. I'm not trying to leave them alone with it. I sit with them as they have it and then I try to help them get through it.

**中文翻译:**
这是我做的第一件事：“这将是一场艰难的对话，你准备好了吗？”然后我分享消息：“我要解雇你，原因是……”这是第二步，传达信息。第三步是，现在他们会产生强烈的情绪。即使我预警了，他们还是会难受。这时你要让他们释放情绪，我会说：“我猜你现在感到很愤怒、恐惧或悲伤。是这样吗？如果是的话，你愿意和我分享你的感受和想法吗？”有时他们不说话，但很多时候他们会分享并宣泄出来。允许他们宣泄非常重要。然后我让他们感到被倾听，并积极倾听。这让他们意识到我并没有试图逃避他们正在经历的痛苦，也没有把他们丢在一边不管。我陪着他们经历痛苦，然后帮他们度过难关。

---

### [00:31:47] Lenny

**English:**
That's something else I wanted to chat about is the feeling heard lesson that you have for people. I'd love to just get your advice on just how to help people feel heard. It's like, oh yeah, I know that's important. I want people to feel heard. I will listen and it'll go great. But you have some very tactical advice on how to actually make people feel heard.

**中文翻译:**
这也是我想聊的另一个话题：关于“让人感到被倾听”的课程。我很想听听你的建议，如何真正让人感到被倾听。大家通常会想：“哦，我知道这很重要，我会听的，没问题。”但你有一些非常具体的战术建议，关于如何真正做到这一点。

---

### [00:32:05] Matt Mochary

**English:**
Yeah, there's sort of a few different levels of it. One way to make people feel heard is, let's assume you're talking to them because there's another way, there's an even more surface way is verbal. Sometimes what I do is I ask, if I'm in a group of people, and there's a question or a problem that we're trying to solve, instead of going around the room and hearing people's verbal opinions, which takes forever, I ask everyone at the same time to take five minutes to write down their solution. Then we all drop it in a doc and then I just read it. When I read it I say, "Thank you, Lenny." And that makes you know that I at least read it, so that's a little bit of feeling heard.

**中文翻译:**
是的，这有几个不同的层次。一种方式是——假设你在和他们交谈，因为还有另一种更表层的方式，就是口头交流。有时我会这样做：如果我在一个群体中，我们要解决一个问题，我不会轮流听取每个人的口头意见（那太慢了），我会要求所有人同时花五分钟写下他们的解决方案。然后大家把方案放进文档里，我直接阅读。读完后我会说：“谢谢你，Lenny。”这让你知道我至少读过了，这算是一点点“被倾听”的感觉。

---

### [00:32:40] Matt Mochary

**English:**
Second, if I want to make you feel more heard, I ask you to say it verbally and then I repeat it back to you. "Lenny, I think what I heard you say is... Is that right?" And you're like, "Yes." Or you're like, "No, not quite a little bit different." Then if it's a little bit different, I repeat it again until you say, "Yes, that's it." Now you know that I understood you.

**中文翻译:**
第二层，如果我想让你感到更充分地被倾听，我会请你口头表达，然后我复述给你听：“Lenny，我想我听到你说的是……对吗？”你会说“是的”，或者“不，不完全是，有点区别”。如果有区别，我会再次复述，直到你说“没错，就是这样”。现在你知道我理解你了。

---

### [00:33:00] Matt Mochary

**English:**
Then there's a third way which is even deeper, which is especially if you're giving me feedback, you likely don't want to hurt my feelings. So what you're doing is you're giving me the feedback, but you're couching it, you're polishing it, you're rounding the edges, you're making it softer. It's not really what you're thinking, but it's what you're willing to say. If I want to make you really feel heard, I reflect back what I imagine are the thoughts in your head. If I think you're feeling anger, I sort of think to myself, well, what would anger feel like? I cause myself to feel that anger, then what are the thoughts that appear to me? I say something to you like, "Lenny, I think what I'm hearing you say is you're off and you're thinking, screw you, Matt. How dare you walk into the office and not even say hello to me? Is that close?" And you're like, "No, Matt."

**中文翻译:**
还有第三种更深层次的方式，特别是当你给我反馈时。你可能不想伤害我的感情，所以你在给反馈时会委婉一些，修饰一下，磨平棱角，说得很温和。那不是你真正的想法，只是你愿意说出口的话。如果我想让你真正感到被倾听，我会把你脑子里可能在想的话反射回去。如果我觉得你在生气，我会想：愤怒是什么感觉？我让自己也感受到那份愤怒，然后看脑子里会出现什么想法。我会对你说：“Lenny，我想我听到的是，你心里在想：‘去你的，Matt。你怎么敢走进办公室连个招呼都不跟我打？’接近吗？”你可能会说：“不，Matt……”

---

### [00:33:49] Matt Mochary

**English:**
People either say one of two things, they say, "Yeah, that is it." Or they say "No, that's stronger than what I was thinking, but directionally that's right." What that really means is, yeah, that's what I was thinking. Almost always their thoughts are bigger than their words, but they really feel heard when I share their thoughts. Now, that's not the end of the process. I mean you actually have to then do something. Once you made them feel heard, you have to say, okay, well either I accept or don't accept this feedback and if I accept, here's what I'm going to do about it. If I don't accept, I need to explain to you why. Here's what's going on. You shared with me what's going on in your world, now let me share with you what's going on in my world. Hopefully, you can see why this thing that's going on in my world doesn't allow me to accept what it is that you shared, and hopefully now that you see what's going on in my world, your feedback changes and that's it. That's the whole process.

**中文翻译:**
人们通常会说两件事之一，要么是：“没错，就是这样。”要么是：“不，那比我想的要强烈，但方向是对的。”这其实意味着：“是的，我就是那么想的。”几乎所有人的想法都比说出来的话更激烈，但当我分享出他们的真实想法时，他们会感到真正被倾听了。当然，这还没完，你还得采取行动。一旦你让他们感到被倾听，你必须说：“好，我接受（或不接受）这个反馈。如果接受，我会这样做；如果不接受，我需要向你解释原因。”你可以说：“这是目前的情况。你分享了你世界里的情况，现在让我分享我世界里的情况。希望你能理解为什么我这边的情况让我无法接受你的建议。希望当你看到我这边的情况后，你的反馈也会随之改变。”这就是整个过程。

---

### [00:35:09] Lenny

**English:**
I'm listening to this advice and I'm like, yes, I will do this next time I'm talking to someone. I imagine people don't and they forget, and it takes time to actually learn these things. Like the firing advice you just shared, how do you actually get good at this and practice these things is like I have to work with a coach who will continue to reinforce these things? Is it follow these steps next time? Have them written down? What advice do you have for folks that are like, I want to get better at this. I want to start doing this stuff.

**中文翻译:**
我听着这些建议，心想：“是的，下次和人聊天我一定要试试。”但我猜人们往往记不住或者会忘掉，真正学会这些需要时间。就像你刚才分享的解雇建议，如何才能真正擅长并练习这些？是必须找个教练不断强化吗？还是下次照着步骤做？写下来？对于那些想变得更好、想开始实践的人，你有什么建议？

---

### [00:35:42] Matt Mochary

**English:**
Well, these docs are all free to the public in the curriculum. You can post them here, you can post them on Twitter, you can post the whole curriculum on Twitter, frankly, other people have. It has a step-by-step. There's a doc in there that is a step-by-step script. All you do is you read it and you follow the script in letting someone go or in making someone feel heard. My posit is once you do it one time, you're like, oh my god, that worked so well. That's the only motivation you need. And you've got the script, so you can just keep doing it. I don't think you need a coach.

**中文翻译:**
嗯，这些文档在课程里都是对公众免费开放的。你可以发在这里，发在 Twitter 上，坦白说别人已经发过了。里面有分步指南，甚至有一份分步脚本。你只需要在解雇员工或让人感到被倾听时，照着脚本读就行了。我的观点是，只要你做过一次，你就会感叹：“天哪，效果太好了。”这就是你需要的全部动力。既然有了脚本，你就可以一直做下去。我不认为你一定需要教练。

---

### [00:35:42] Matt Mochary

**English:**
In fact, I remember one time I asked an investor who their best up and coming CEO was. The investor gave me a name. I was like, "Great, can I please get introduced to him? I want coach him." I reached out, the guy responded immediately. He's like, "Matt, I've read your book. I love your book. I read it three years ago. I've been implementing all the elements in our company. It's fantastic." When someone says that they know my work, they've already implemented it and it's worked, 10 out of 10 times, that person wants me to coach them. Then I said, "Great, that's fantastic. I'd love to coach you." And the guy said to me, "No, thanks." I was shocked. I was like, "Why?" He said, "Well, because it's all working. I don't have any problems. I don't think I need to be coached by you." I couldn't have heard a better answer. That, to me, is the ultimate answer. And he is right. He doesn't need me, doesn't need anyone.

**中文翻译:**
事实上，我记得有一次我问一位投资者，谁是他们手下最有前途的 CEO。投资者给了我一个名字。我说：“太好了，能引荐一下吗？我想指导他。”我联系了他，他立即回复：“Matt，我读过你的书，非常喜欢。三年前读的，我一直在公司里推行书里的所有要素，效果极佳。”通常当有人说了解我的工作、已经实施且见效时，十有八九是想让我当教练。于是我说：“太棒了，我很乐意指导你。”结果那家伙对我说：“不，谢谢。”我惊呆了，问：“为什么？”他说：“因为一切运转良好，我没有任何问题，我觉得不需要你的指导。”我听不到比这更好的回答了。对我来说，这就是终极答案。他是对的，他不需要我，也不需要任何人。

---

### [00:36:39] Lenny

**English:**
I was going to ask if that's the goal of all of this writing down and systemizing is just to make yourself unnecessary.

**中文翻译:**
我正想问，把这些东西写下来并系统化的目标，是不是就是为了让你自己变得不再被需要？

---

### [00:36:45] Matt Mochary

**English:**
Totally.

**中文翻译:**
完全正确。

---

### [00:38:05] Lenny

**English:**
That actually reminds me of another question a reader asked on Twitter who happened to be the one on only Ryan Hoover. He asked, "How has your approach changed in your coaching since you started?"

**中文翻译:**
这让我想起另一位读者在 Twitter 上问的问题，他就是大名鼎鼎的 Ryan Hoover。他问：“自你开始做教练以来，你的方法发生了哪些变化？”

---

### [00:38:16] Matt Mochary

**English:**
Ryan obviously started Product Hunt and then he sold the company to AngelList, so he was part of AngelList when I went there because I was coaching Naval. What we realized coaching Naval is that Naval did not want to be CEO and he just didn't know how to get out. So, I said there's a way and I can show you, and so I did and made Naval's life 10 times better. Frankly, made AngelList 10 times better because Naval wasn't enjoying being CEO, therefore he wasn't good at it. We ended up putting someone in who did a fine job, then put someone else in who's doing an insanely good job. Now, of course, AngelList is massively valuable.

**中文翻译:**
Ryan 创办了 Product Hunt，后来卖给了 AngelList。我去 AngelList 指导 Naval 时，他也在那儿。在指导 Naval 的过程中，我们意识到 Naval 其实不想当 CEO，只是不知道如何抽身。我说有办法，我可以教你。我这么做了，让 Naval 的生活质量提升了 10 倍。坦白说，也让 AngelList 变好了 10 倍，因为 Naval 并不享受当 CEO，所以他做得并不好。我们后来换了一个人，做得不错，再后来又换了一个人，做得简直完美。现在 AngelList 的价值巨大。

---

### [00:38:53] Matt Mochary

**English:**
Ryan was there at the time, Ryan Hoover, great guy, I love Ryan. So, what has changed since then? I think what's changed is I don't think back then I had any of this fear and anger give bad advice. I think back then it was all very tactical. It was all very high up management type stuff, which is you need to have goals and at the company level, at the department level, at the individual level, you then need to track those goals. You need to track all the agreements that people make, all the actions they say they'll do. You have to put it all in Asana. Everyone has to be able to see each other's Asana board so they can see what each other is doing. I still do that, but now I've added on this piece of oh, you're in the moment and you're feeling fear? Okay, you still got to go forward. That's sort of the big change.

**中文翻译:**
Ryan 当时就在那儿，Ryan Hoover 是个很棒的人，我很喜欢他。那么，从那时起发生了什么变化？我想变化在于，当时我还没有“恐惧和愤怒会给出坏建议”这套理论。那时全是战术性的，非常像《高产出管理》那一套：你得有目标，公司级、部门级、个人级，然后跟踪这些目标。你得跟踪人们达成的所有协议、承诺的所有行动。你得把这些全放进 Asana（任务管理工具）。每个人都得能看到别人的 Asana 看板，知道大家在做什么。我现在依然这么做，但我增加了心理层面的内容：哦，你现在感到恐惧？没关系，你还是得前进。这就是重大的变化。

---

### [00:39:42] Lenny

**English:**
I noticed that's at the top of the curriculum. Do you find that's where a lot of the biggest transformations happen, that curriculum component?

**中文翻译:**
我注意到这部分在课程的最顶端。你是否发现，课程中的这一部分是发生最大转变的地方？

---

### [00:39:49] Matt Mochary

**English:**
Absolutely. I cause people when they first start coaching, they have to read that first. There's sort of three seminal documents: on time, top goal, and fear and anger give bad advice. On time just says, hey, we're going to start our meetings on time and you're going to show up and if you don't show up on time, you're going to let me know first. That's just because I don't want to... And by the way, I showed up two minutes late for us. That's because I was on the Google Hangout for 10 minutes. I didn't realize, I thought you were-

**中文翻译:**
绝对是。我让人们在开始接受指导时先读这个。有三份核心文档：“准时”(On Time)、“首要目标”(Top Goal) 以及“恐惧和愤怒会给出坏建议”。“准时”就是说：我们要准时开会，你得准时出现，如果不能准时，要提前告诉我。这只是因为我不想……顺便说一下，我今天迟到了两分钟，那是因为我在 Google Hangout 里等了 10 分钟，我没意识到，我以为你在——

---

### [00:40:21] Lenny

**English:**
I'm trying to fix that bug. Every time we send an invite, there's a Google meet button there. I think I cracked it finally. Yeah, that would've been a funny podcast where I'm just sitting here starting on time and for two minutes. Hello, we're just waiting.

**中文翻译:**
我一直在尝试修复那个 Bug。每次发邀请函，都会自动出现一个 Google Meet 按钮。我想我终于搞定了。是的，那会是一个有趣的播客：我准时开始，然后坐那儿等两分钟说：“哈喽，我们还在等。”

---

### [00:41:25] Matt Mochary

**English:**
The second one is top goal, which is this concept from McKeown, who wrote Essentialism, which is everyone is making requests of you, but if all you do is spend all day is responding to other people's requests, you never actually march towards your own priorities. You need to A, create priorities and then set aside some amount of time each day, 30 minutes, an hour, two hours that you just work on your own priority. If you do that, you'll make massive gains. And that's true. I mean, in five minutes I can change someone's life just by having them follow that practice. Then the third one is, if you're in anger, give that advice and that's what I have people read and say, "Does this resonate with you?" If it does, we can work together and if it doesn't, we shouldn't work together. So yeah, that's kind of like the crux document of whether or not people philosophically are going to resonate with what I have to share.

**中文翻译:**
第二个是“首要目标”，这是《精要主义》(Essentialism) 作者 McKeown 的观点：每个人都在向你提要求，但如果你整天都在回应别人的要求，你永远无法朝着自己的优先级迈进。你需要 A：建立优先级；然后每天留出一段时间（30 分钟、一小时或两小时），专门处理你自己的优先级任务。如果你这样做，会有巨大的收获。这是真的，我只需五分钟就能通过让某人遵循这一习惯来改变他的生活。第三个就是“恐惧和愤怒会给出坏建议”，我会让人们读这个并问：“这能引起你的共鸣吗？”如果能，我们就可以合作；如果不能，我们就不该合作。所以，这是判断人们在哲学层面上是否认同我分享内容的基石文档。

---

### [00:41:25] Lenny

**English:**
The top goal piece, I'm reading a book called Make Time right now and that's a big part of it. I actually just added top goal to my calendar every day. It's not working yet. Every time I get to it, I'm like no, I'm going to just check Twitter right now. But I'm working on it.

**中文翻译:**
关于“首要目标”，我正在读一本叫《设计时间》(Make Time) 的书，里面很大一部分在讲这个。我其实刚把“首要目标”加进每天的日程表。目前还没奏效。每次到那个时间点，我都会想：“不，我现在只想刷刷 Twitter。”但我正在努力。

---

### [00:41:38] Matt Mochary

**English:**
That is the hardest part. Now, what I've done is I'm similar. During my top goal time, I have somebody sit with me and they prevent me from doing anything but my top goal.

**中文翻译:**
那是最高难度的部分。我现在采取的方法是——我也和你一样——在我的“首要目标”时间里，我会找个人陪我坐着，他们会阻止我做除了首要目标以外的任何事。

---

### [00:41:51] Lenny

**English:**
Wait, can you talk a bit more about that? Is this like a coworker? Are you just like, "I need you here for this hour every day?"

**中文翻译:**
等等，能多聊聊这个吗？是同事吗？你会说“我需要你每天这个小时待在这儿”吗？

---

### [00:41:56] Matt Mochary

**English:**
Yeah, I mean it's like the same idea as a trainer in a gym. A trainer in a gym, maybe they're teaching you a little bit, but more often than not they're just forcing you to do the thing that you know need to do. But if they weren't there, you would kind of go eh and not do it. That's all this is. It's what I call an accountability partner.

**中文翻译:**
是的，这就像健身房的教练。教练可能会教你一点动作，但更多时候他们只是强迫你去做那些你明知该做的事。如果他们不在，你可能就会偷懒不做。这就是我所说的“问责伙伴”(accountability partner)。

---

### [00:42:15] Matt Mochary

**English:**
There's even an app now where you can go online and you can sign up and I think it costs like $5 a month and you can sign up to meet someone else and you become accountability partners to each other. It's insanely effective. I'm not the only one that has a problem focusing on tasks that I don't love that are necessary, but I don't love. Like a meeting, I could take a meeting, I could take 20 meetings, I could take 10 hours of meetings, no problem. Especially when I'm the presenter, when I'm the active one. But doing asynchronous tasks for me because so people-oriented that when there isn't another human with me, it's painful, so I just have another human with me.

**中文翻译:**
现在甚至有一个 App，你可以花大概 5 美元一个月在上面注册，匹配另一个人，互为问责伙伴。这非常有效。我不是唯一一个在处理那些必要但不喜欢的任务时难以集中注意力的人。比如开会，我可以开 20 个会，连开 10 小时都没问题，尤其是我作为主讲人或活跃分子时。但处理异步任务（独自工作）对我来说很痛苦，因为我是个极度社交导向的人，如果没有人在身边，我会很难受。所以我干脆找个人陪着我。

---

### [00:43:04] Lenny

**English:**
I love that. And that person is doing other work, I imagine they're not just watching you full-time.

**中文翻译:**
我喜欢这个主意。那个人也在做别的工作吧，我猜他们不是全职盯着你看。

---

### [00:43:09] Matt Mochary

**English:**
No, they can do whatever they want.

**中文翻译:**
不，他们想干什么都行。

---

### [00:43:12] Lenny

**English:**
Is this what you recommend to leaders and CEOs? Just have someone there for an hour. Wow.

**中文翻译:**
这就是你给领导者和 CEO 的建议吗？就找个人在那儿待一小时。哇。

---

### [00:43:18] Matt Mochary

**English:**
If your personality is like mine, yes, have someone there. It can be remote, it can be in person, it doesn't matter. In person's a little bit more effective.

**中文翻译:**
如果你的性格像我一样，是的，找个人在那儿。远程也行，面对面也行，没关系。面对面效果会稍微好一点。

---

### [00:43:58] Lenny

**English:**
To close a loop on the firing piece, something I was thinking about while you were talking is there's a lot of layoffs happening right now. When you're letting go of like a thousand people, you can't really be their agent unless you've seen that happen. Do you have any advice for just like there's a large layoff how you could do this?

**中文翻译:**
回到解雇的话题，你说话时我在想，现在有很多大裁员。当你一次解雇一千人时，你很难真的成为每个人的经纪人，除非你见过这种操作。对于大规模裁员，你有什么建议吗？

---

### [00:44:38] Matt Mochary

**English:**
Absolutely you can be their agent, not you personally, but they each have a manager and the manager usually has 12 reports and they're rarely letting go more than 50% at a time. That means six people that they've got to be the agent of maximum. Yes, each manager can be the agent for six people. My companies have done a lot of layoffs and here's why. Back in March of 2020, there was a chance that the world economy was imploding. Now of course, by April and May we realized that wasn't the case, that the tech world kept going, in fact, it was even flourishing.

**中文翻译:**
绝对可以成为他们的经纪人。不是你个人，而是每个员工都有经理，经理通常有 12 个下属，很少会一次裁掉超过 50%。这意味着每个经理最多只需要担任 6 个人的经纪人。是的，每个经理都可以负责 6 个人。我指导的公司做过很多裁员，原因如下：2020 年 3 月，全球经济有崩溃的风险。当然，到了 4 月和 5 月，我们意识到情况并非如此，科技界依然在运转，甚至更加繁荣。

---

### [00:44:38] Matt Mochary

**English:**
But in March of 2020, we didn't know that. And so you needed, if you were being fiscally responsible, you needed to prepare for that eventuality, so you needed pare costs. 80% of costs in any tech company is payroll, is humans. If you're going to pare costs, you actually have to let go of humans. Almost every one of my companies did. Some on the low side of 5%, some on the high side. One company that is a hotel company let go of 40% because it looked like their business was about to get obliterated and the results were crazy. Within 60 days of each layoff, the CEO reported back to me: It's insane. I don't know how this happened, but the company's now operating better. I'm not talking on a relative scale, I'm talking on an absolute scale. We're putting out more features, more code. Our NPS is up, whatever it is, whatever department is performing better. The only answer for it was we've got less people, so this coordination issue is reduced.

**中文翻译:**
但在 2020 年 3 月，我们并不知道。所以如果你想在财务上负责任，就必须为那种可能性做准备，也就是削减成本。任何科技公司 80% 的成本都是工资，也就是人。如果你要削减成本，就必须裁员。我指导的几乎每家公司都这么做了。有的裁了 5%，有的更多。有一家酒店相关公司裁了 40%，因为当时看起来他们的业务快完蛋了。结果非常惊人：在每次裁员后的 60 天内，CEO 都会向我反馈：“太疯狂了，我不知道是怎么回事，但公司现在的运作更好了。”我指的不是相对规模，而是绝对规模。我们发布了更多功能、更多代码，NPS（净推荐值）上升了，无论哪个部门表现都更好了。唯一的解释是：人少了，协作问题减少了。

---

### [00:46:33] Matt Mochary

**English:**
Then now in May, June of this year, we had this huge reset of valuations where growth tech stocks dropped by 50 to 90% value and all of a sudden, which we're still in and we don't know how long this can last, it's all based on interest rates so it's likely that growth stocks will be at these valuations until interest rates come back down again, which could be two to three years. These companies now they can go raise money, but it's going to be at a big down round and down rounds are very painful. So now these companies have to make sure that they don't need to raise money in the next three years. They've got to conserve cash once again.

**中文翻译:**
到了今年（2022年）5、6 月，估值发生了巨大的重置，成长型科技股贬值了 50% 到 90%。我们现在仍处于这个阶段，不知道会持续多久。这完全取决于利率，所以成长股的估值可能会维持现状，直到利率再次下降，这可能需要两到三年。这些公司现在可以去融资，但会是大幅折价融资 (down round)，而折价融资非常痛苦。所以现在这些公司必须确保未来三年不需要融资，必须再次节省现金。

---

### [00:47:02] Matt Mochary

**English:**
Here we are, we're in the land of layoffs again, but this time it's different. This time these CEOs know that the company actually gets better. And the CEOs that have never done this before, I simply connect them with the CEOs who have done this before and then they get convinced like, oh man, my company will be better. And now this time, people have been even more aggressive. We've had companies that have laid off 50% of the company and the results have been frankly, phenomenal.

**中文翻译:**
于是，我们又进入了裁员潮。但这次不同，这次 CEO 们知道裁员实际上会让公司变得更好。对于那些从未经历过裁员的 CEO，我只需把他们介绍给经历过的 CEO，他们就会被说服：“天哪，我的公司会变得更好。”这一次，人们变得更加果断。有些公司裁掉了 50% 的员工，坦白说，结果非常出色。

---

### [00:47:02] Matt Mochary

**English:**
But the key to doing it well is there has to be a humane delivery. The biggest marker that I've seen between a botched layoff and a successful layoff is at the moment someone hears that they no longer have a job, did they hear it from their manager in a one-on-one? If that's when they heard it, it'll be okay. But if they heard it in an email, in a group chat, in any kind of thing where they were sitting next to or they're hearing it along with other people, it wasn't personalized, it wasn't one-on-one, that is terrible. That's when people get really angry and that's when they start going on Twitter and going to newspapers and et cetera because it feels dehumanizing. It feels like you didn't give a shit about me. You didn't even have the courtesy to tell me to my face. Of course, there's no way to allow that person to express their emotions because they're in a group. That's the most important thing.

**中文翻译:**
但做好的关键在于人性化的传达。我见过的失败裁员与成功裁员之间最大的区别在于：当员工得知自己失去工作的那一刻，他们是从经理那里通过一对一的面谈听到的吗？如果是这样，那结果通常还好。但如果他们是通过邮件、群聊，或者在任何一种与他人坐在一起、同时听到消息的场合得知的，这种非个性化、非一对一的方式简直糟糕透顶。这正是人们感到愤怒的时候，也是他们开始在 Twitter 上发泄、找报纸曝光等等的时候，因为这让人感觉被非人化对待了。感觉就像你根本不在乎我，甚至连当面告诉我的基本礼貌都没有。而且，在群体环境中，那个人根本无法表达自己的情绪。这是最重要的一点。

---

### [00:48:17] Matt Mochary

**English:**
The second thing is then later, so tactically, this is how it happens. You have an inner circle. I think that inner circle should include all managers in the company and you say, this is how much we need to let go. Here's how much each of you needs to let go. First of all, you don't say to each department head or team leader, manager, tell me who you can let go because they'll all say nobody. You actually have to give them numbers. You have to let this dollar amount go or this many people go, dollar amount is better because if you say people, then they'll just let go of the cheapest people, the most junior, and often the most junior are the ones that are actually doing the most work. You want it to be dollars because that's actually really what you're trying to save. You're trying to save dollars.

**中文翻译:**
第二点是后续操作。在战术上，流程是这样的：你有一个核心圈子，我认为应该包括公司所有的经理。你说：“我们需要裁掉这么多，这是你们每个人需要分担的额度。”首先，你不要问部门主管或经理“你能裁掉谁”，因为他们都会说“一个都不能裁”。你必须给他们具体的数字：必须削减多少金额或多少人。按金额（美元）计算更好，因为如果你按人数算，他们会裁掉最便宜、最资深的员工，而往往最资深的员工才是干活最多的人。你应该按金额算，因为这才是你真正想节省的东西——钱。

---

### [00:49:07] Matt Mochary

**English:**
So, you say you have to save this many dollars, come up with a number, they quickly come back with a number. You don't want to have department heads choose for managers because if you have a team lead and all of a sudden they're told to let go these three people, the team lead will go, that was crazy. Those are my three best people. So you want to let each manager choose and that doesn't need to take long. That could take 48 hours.

**中文翻译:**
所以，你说必须节省这么多钱，给个数字，他们很快就会带着名单回来。你不要让部门主管替经理做决定，因为如果一个团队组长突然被告知要裁掉这三个人，他会疯掉：“这太疯狂了，那是我最优秀的三个员工。”所以你要让每个经理自己选，这不需要很长时间，48 小时就够了。

---

### [00:49:29] Matt Mochary

**English:**
Then you move to implementation. At implementation, you spend the morning and have each manager reach out to people and just Slack them say, "Hey, can I talk to you for 15 minutes?" And then they have these meetings back-to-back-to-back or as close as they can and they deliver the news, the difficult conversation that we talked about before. "It's going to be a difficult conversation. I'm letting you go. I imagine this feels crappy or feels like worse than that. This is horrible. If you're willing to share your feelings and I want to be your agent now. I don't have time to do it now, but I'd like to schedule with you another hour tomorrow, the next day whenever, so that we can go and dig in and I can help be your agent."

**中文翻译:**
然后进入执行阶段。在执行当天，经理们利用上午的时间通过 Slack 联系相关员工说：“嘿，能和你聊 15 分钟吗？”然后他们进行背靠背的会议，传达消息，也就是我们之前说的艰难对话：“这将是一场艰难的对话。我要解雇你。我能想象这感觉很糟，甚至比那更糟，这太可怕了。如果你愿意分享感受，我想现在开始担任你的经纪人。我现在没时间细聊，但我希望能和你约明天或后天的一个小时，我们可以深入探讨，我来帮你找下家。”

---

### [00:50:12] Matt Mochary

**English:**
Then, that takes the morning. By the afternoon, you've scheduled an all hands for the stay team. With the stay team, you'd tell them what had just occurred and you answer their questions. The questions are almost always around fear. Like, "Holy shit, is this going to happen to me? Did these people even get feedback that they weren't performing? Does this mean that we're dying as a company and that we're going to implode?" You have to address each one of these questions and hopefully the answer is: no, to the first one, is this going to happen to me? No, this isn't. We cut deep so that we only cut once. The people to your left and right and you, you are the state team. This is the team that we're going to building the company with going forward. It's important to be able to say that. You actually want to cut deep because cutting two times or three times creates PTSD in an organization. It's trauma one, trauma two, trauma three. Now they're like, ah, it's just going to keep happening.

**中文翻译:**
上午就这样过去了。到了下午，你会为留下的员工安排一场全员大会。你会告诉他们发生了什么，并回答他们的问题。问题几乎总是围绕着恐惧，比如：“天哪，这会发生在我身上吗？这些人之前收到过表现不佳的反馈吗？这是否意味着公司快完蛋了？”你必须回答每一个问题。希望第一个问题的答案是：“不，这不会发生在你身上。我们裁得很彻底，就是为了只裁这一次。你身边的人和你，就是我们的核心团队，我们将一起建设公司的未来。”能说出这句话非常重要。你确实需要裁得深一点，因为裁两次或三次会在组织中造成创伤后应激障碍 (PTSD)。一次创伤、两次创伤、三次创伤，员工会觉得：“啊，这事儿没完没了了。”

---

### [00:51:10] Matt Mochary

**English:**
Then, the third piece is, and this not everybody does, if you don't do this, your company within 60 days will be performing better. If you do this, your company within two weeks will be performing better because people now, the stay team, they feel sadness, they feel anger, they feel fear. Yes, you addressed their questions in the all hands, but not fully because some people didn't even talk in the all hands.

**中文翻译:**
第三部分是——并不是所有人都会做——如果你不做这一步，你的公司在 60 天内会表现得更好；但如果你做了这一步，你的公司在两周内就会表现得更好。因为留下的团队现在感到悲伤、愤怒和恐惧。是的，你在全员大会上回答了问题，但并不充分，因为有些人甚至没在会上发言。

---

### [00:51:34] Matt Mochary

**English:**
So, what you do is with each and every person on the stay team, you have a one-on-one with their manager for one hour and all the manager does is say, "I'd like to know your thoughts and feelings," and the person shares and then all the manager does is make them feel heard. I think what you're telling me is you feel sad because your three buddies are now no longer here and you feel anger because you think this is bullshit and you think why did we hire this many people if we're going to fire them? That was just irresponsible. You feel fear because you're not sure if the company's going to implode or if your job is safe. Is that right? And they're like, "Yes."

**中文翻译:**
所以，你要做的是让留下的每一位员工都与他们的经理进行一小时的一对一谈话。经理只需说：“我想听听你的想法和感受。”员工分享后，经理只需让他们感到被倾听：“我想你告诉我的是，你感到悲伤，因为你的三个好哥们儿不在这儿了；你感到愤怒，因为你觉得这太扯了，觉得既然要裁员当初为什么要招这么多人，这太不负责任了；你感到恐惧，因为你不确定公司是否会倒闭，或者你的工作是否安全。对吗？”他们会说：“是的。”

---

### [00:52:11] Matt Mochary

**English:**
It doesn't take away the emotion entirely, but it knocks it down by a good 25%, which is enough that the person won't do something rash, they won't quit, they won't stop working, they won't say bad shit to other people, and it allows them to accelerates their recovery. Within two weeks, they're now seeing how the company's operating better and morale then comes up and the company's now performing better than it was before. So, three elements.

**中文翻译:**
这不能完全消除情绪，但能降低大约 25%，这足以让员工不至于做出鲁莽的举动，比如辞职、罢工或到处说公司坏话，并能加速他们的恢复。两周内，他们会看到公司运作得更好了，士气随之回升，公司的表现也会超过以往。这就是三个要素。

---

### [00:52:44] Lenny

**English:**
That was thousands of dollars of advice I think, in just five to 10 minutes.

**中文翻译:**
我觉得这短短五到十分钟的建议价值数千美元。

---

### [00:52:50] Matt Mochary

**English:**
That's after having probably gone through this with CEOs maybe 40 times and iterating AB testing, and what's the difference, and what works well, and what didn't work well. Yeah, I can't imagine there's somewhat out there who has advised more people through a layoff process, certainly in the tech world, than I have. I'm not saying I'm proud of that, but it just is.

**中文翻译:**
这是在陪 CEO 们经历了大概 40 次裁员，不断迭代、AB 测试，观察区别、总结经验教训后的成果。是的，我无法想象在科技界还有谁比我指导过更多的人经历裁员流程。我不是说我以此为荣，但事实就是如此。

---

### [00:53:17] Lenny

**English:**
What a fun place to be. As you were talking, I was thinking a little bit about Twitter and Elon and the experience that's going through right now. It feels like on the one hand, he's letting go of a lot of people, which matches kind of your advice. On the other hand, not being handled too well. I think it's emails and just a lot of random quick things. What's your perspective on this whole thing?

**中文翻译:**
真有意思。你说话时，我在想 Twitter 和马斯克现在的经历。感觉一方面他裁了很多人，这符合你的建议；但另一方面，处理得似乎不太好，比如通过邮件和各种随意的快速操作。你对这件事怎么看？

---

### [00:53:39] Matt Mochary

**English:**
I haven't been following it directly, so I don't know how he's implementing the layoffs or how much he's doing. Frankly, just haven't been following it at all. But here's the sad reality, even if it's handled incredibly poorly, the company ends up performing better. It just takes a little longer for people to recover, for the stay team to recover emotionally. But the worst case scenario, it's handled terribly, within two months, the company will be performing better.

**中文翻译:**
我没有直接关注，所以我不知道他是如何执行裁员的，也不知道裁了多少。坦白说，我完全没关注。但残酷的现实是：即使处理得极其糟糕，公司最终的表现也会变好。只是人们需要更长的时间来恢复，留下的团队需要更久来平复情绪。但最坏的情况——处理得一团糟——两个月内，公司的表现也会变好。

---

### [00:54:09] Lenny

**English:**
Fascinating. That's actually a good segue to this last topic I wanted to touch on, which something that I think you have a lot of thoughts on is building new products within a larger company and innovating inside of a larger kind of scaled company, and especially the challenges around that. What are your thoughts on just how to do this well, how to innovate within a larger company?

**中文翻译:**
太有意思了。这正好引出了我想谈的最后一个话题，我觉得你对此有很多见解：如何在大型公司内部构建新产品，以及如何在已经规模化的公司内部进行创新，尤其是其中的挑战。关于如何做好这一点，你有什么想法？

---

### [00:54:30] Matt Mochary

**English:**
I can tell you the short version, but I'll tell you the long version. The long version is that this was a real problem for everyone I was coaching and I didn't know the answer. But it was obvious that YC startups were crushing and just iterating so much faster. And then I had the thought, well, why not just create your own YC startup and have it crush you but you own it? It, of course, has to really look like a YC startup. It has to have a founder mentality person as the head of the team, someone who's willing to just break glass and just won't stop until they run through the brick wall. It's actually pretty easy to find founder mentality folks. You just literally go to the YC alumni list and the ones whose startups failed, perfect, they're available and they are founder types and now they want to join a company that's actually succeeding because they realize how hard it is to create something on their own, but they still have the mentality.

**中文翻译:**
我可以给你讲简短版，但我还是讲详细版吧。详细版是：这对我指导的所有人来说都是个难题，而我起初也不知道答案。但显而易见的是，YC 的初创公司势如破竹，迭代速度快得多。于是我产生了一个念头：为什么不在公司内部创建一个“YC 初创公司”，让它来“打败”你，但所有权归你？当然，它必须看起来真的像一家 YC 初创公司。团队负责人必须具备“创始人心态”，愿意打破常规，不撞南墙不回头。找具备创始人心态的人其实挺容易的：你直接去看 YC 校友名单，那些创业失败的人最合适，他们有空，是创始人类型，而且现在想加入一家成功的公司，因为他们意识到白手起家有多难，但他们的心态还在。

---

### [00:55:24] Matt Mochary

**English:**
Then you want to keep the team really small because then they can, again, there's no buy-in required, like everyone's on the same page with the same information. We started testing that and it worked, and then I thought, well wait a second. The reason that a big company has a hard time innovating, it's because once a product is scaled, it's now got millions of users. So you have two things that you need to make sure stay true every day: the site is up and running and there's no security breach. Every time you add code, you've got to test it thoroughly to make sure it doesn't take down either one of those. The review process is insane.

**中文翻译:**
然后你要保持团队极度精简，因为这样就不需要层层审批，每个人都掌握同样的信息。我们开始测试这个方法，结果奏效了。然后我想到：等等，大公司难以创新的原因是，一旦产品规模化，拥有数百万用户，你就必须确保两件事：网站正常运行且没有安全漏洞。每次添加代码，你都必须彻底测试，确保不会破坏这两点。审核流程简直疯了。

---

### [00:56:06] Matt Mochary

**English:**
So now you're innovating, you're writing prototype code on new features. You can't get it approved it takes so long. That's what you're trying to decouple and you're trying to create an entity that isn't touching the core code, but you also don't want to have to go through the approval process of the product team or the head of product. That takes way too long, as well. That's why it has to be a small team that reports to outside of EPD. It can't report to the head of engineering, head of product, head of design, it can't. It's got to go outside, usually directly to the CEO. That's the only other place to report that's outside.

**中文翻译:**
所以当你创新、为新功能编写原型代码时，审批太慢了。这就是你需要解耦的地方：你要创建一个不触碰核心代码的实体，而且你不想经过产品团队或产品负责人的审批流程，那也太慢了。这就是为什么它必须是一个小团队，且向 EPD（工程、产品、设计）部门之外的人汇报。它不能向工程主管、产品主管或设计主管汇报。它必须跳出来，通常直接向 CEO 汇报。那是唯一的外部汇报路径。

---

### [00:56:48] Matt Mochary

**English:**
Then I had this idea, well wait a second, there's also a brand question and so why don't you create an entirely new name for this product that isn't the core, the base business? Why don't you actually just create its own C corp? Why don't you make it so clear that this is its own entity? So I wrote this whole thing up and created its own C corp. I shared this with a few people and one CEO said to me, "Matt, this sounds radical and sounds like it could work, but is anyone actually doing this?" I thought to myself, oh shit, no, nobody's actually doing this. Nobody that I know has created new C Corps for the entities, the new products they're developing.

**中文翻译:**
然后我想到：等等，还有一个品牌问题。为什么不给这个产品起个全新的名字，不和核心业务挂钩？为什么不干脆为它注册一个独立的 C 类公司 (C corp)？为什么不明确它就是一个独立的实体？于是我写下了这套方案，建议成立独立的 C 类公司。我分享给了一些人，一位 CEO 对我说：“Matt，这听起来很激进，也可能有效，但真的有人在这么做吗？”我心想：“糟糕，没有，还没人这么做。据我所知，还没人为了开发新产品而成立新的 C 类公司。”

---

### [00:57:34] Matt Mochary

**English:**
Then 30 days later, I got in a call with Wei Deng. I told you before, I'm a huge fan, and we talked about product and I shared with her this write up. She's like, "Oh yeah, that's what I do." She said, "I created five C Corps in the last two months." I was like, "What? Someone's actually doing it." I was like, "Well, what are the results?" She's like, "They're fantastic." She goes, "The team doesn't worry about trying shit because they know that it doesn't hurt our core brand, and so they're iterating fast." And she said, "Not only do I do that, I actually have two teams, independent, working on each new product. One I have is more engineering focused, they build custom code. The other is more sort of customer relationship-focused and maybe they don't even have engineers and they build a manual solution or they use off the shelf products to build a solution, and just see which one makes more progress faster." Wow, insane. That's why, again, I have so much respect for Wei.

**中文翻译:**
结果 30 天后，我和魏登通了电话。我之前说过我是她的超级粉丝。我们聊到了产品，我向她分享了这份方案。她说：“哦，是的，我就是这么做的。”她说：“过去两个月我成立了五个 C 类公司。”我惊呼：“什么？真的有人在做！”我问：“结果如何？”她说：“棒极了。团队不再担心尝试新东西，因为他们知道这不会伤害核心品牌，所以迭代非常快。”她还说：“我不止这么做，我实际上为每个新产品安排了两个独立的团队。一个更偏向工程，编写自定义代码；另一个更偏向客户关系，甚至可能没有工程师，他们用手动方案或现成产品来构建方案。然后看哪一个进展更快。”哇，太疯狂了。这就是为什么我再次表达对魏登的敬意。

---

### [00:58:36] Lenny

**English:**
When I think about these ideas, I think of the NPE team at Facebook and I think it's called Area 21 at Google, which works on new ideas and I don't know if anything amazing has come out of those groups maybe, I don't know. But it feels like the missing piece, and you didn't mention this piece, is feeling like there's a huge upside if you get something. Like founders having equity of their company feels like such a motivator. I could become a billionaire if this works out, versus I'm helping my startup in some small incremental way. Is that an important piece or do you think it's not critical?

**中文翻译:**
当我想到这些主意时，我会想到 Facebook 的 NPE 团队，或者 Google 的 Area 21（注：应为 Area 120），他们专门研究新想法。我不知道这些小组是否产出了什么惊人的成果。但感觉缺失的一环——你刚才没提到——是巨大的收益预期。创始人拥有公司股权是巨大的动力：“如果成功了，我就能成为亿万富翁”，这和“我只是在帮公司做一点微小的增量改进”完全不同。你觉得这一环重要吗，还是说它并不关键？

---

### [00:59:09] Matt Mochary

**English:**
I'm going to be radical here. I don't think it matters at all. I think that what really motivates people is building shit that gets used in the world. I think people will say, and they'll fight for equity and money, but in the end, that's not what actually motivates them. Because I've seen this work in companies where they don't have big equity, but they have autonomy, they have ownership, not equity ownership, ownership over decision making, ownership over creation. That's what I think people want. Amazon does this. They're not giving their people... Amazon's famous for being cheap bastards, but someone has a great idea, okay, here's 5 million bucks, go do. Amazon is definitely innovating successfully.

**中文翻译:**
我要发表一个激进的观点：我觉得这完全不重要。我认为真正激励人们的是亲手做出被世界使用的东西。人们嘴上会说、也会去争取股权和金钱，但最终，那并不是真正的动力。因为我见过在一些公司里，员工没有多少股权，但他们拥有自主权，拥有“所有权”——不是股权意义上的所有权，而是对决策和创造的所有权。这才是人们想要的。亚马逊就是这么做的。他们不怎么给员工……亚马逊以抠门著称，但如果有人有个好主意，公司会说：“好，给你 500 万美元，去做吧。”亚马逊的创新无疑是成功的。

---

### [01:00:21] Lenny

**English:**
What about the flip side of that of not necessarily the huge upside, but the I'm staking everything on this startup, I need this to work, this is my thing, my name's on the line. I feel like that's a big motivator also for founders, like I'm not going to give up this feeling of grit. Is that important?

**中文翻译:**
那反过来呢？不一定是巨大的收益，而是“我把一切都押在了这个项目上，我必须让它成功，这是我的事业，我的名声押在上面”。我觉得这也是创始人的巨大动力，那种“绝不放弃”的坚韧感。这重要吗？

---

### [01:00:21] Matt Mochary

**English:**
Yeah, it's also fear. It's fear, which is like if this doesn't work, I'm screwed. Fear, frankly, is an excellent motivator. It gets people to move fast and move hard. The only problem with fear is it's also corrosive, so it eats out my insides as I go along. It makes it that I don't enjoy life, but it's highly motivated. Now, I think joy is actually even more motivating or they say it's as motivating, but it's noncorrosive, so I can last much longer if I'm doing something for joy. Fear is short term, extreme motivation. It's adrenaline. Joy is long term, consistent motivation that also allows me to look back on my life and go, wow, that was a great life. So yes, that is effective motivation, but I don't recommend putting oneself in that position to get motivated.

**中文翻译:**
是的，那本质上也是恐惧。恐惧就是：“如果这事不成，我就完蛋了。”坦白说，恐惧是一种极好的动力，它能让人跑得快、拼得狠。恐惧唯一的缺点是它具有腐蚀性，它会随着时间的推移侵蚀我的内心，让我无法享受生活，尽管它动力十足。而我认为“快乐”实际上是更强的动力，或者说同样强，但它没有腐蚀性。如果为了快乐而做某事，我可以坚持得久得多。恐惧是短期的、极端的动力，是肾上腺素；快乐是长期的、持续的动力，它还能让我回首往事时感叹：“哇，这一生过得真精彩。”所以，恐惧确实有效，但我并不建议为了获得动力而把自己置于那种境地。

---

### [01:01:29] Matt Mochary

**English:**
In my portfolio, I know Scale and Attentive Mobile are both doing this well. More and more companies that I coach are starting to do this because I have more and more examples of it working well, so more and more companies are then copying. I don't have other names offhand that I can share though.

**中文翻译:**
在我的客户中，我知道 Scale AI 和 Attentive Mobile 都做得很好。越来越多我指导的公司开始尝试这种方法，因为我有了越来越多成功的案例，所以大家都在效仿。目前我手头没有更多可以分享的名字了。

---

### [01:02:06] Lenny

**English:**
Energy audit. This is something that you advise folks to understand what gives them energy, what zaps their energy, can you talk a bit about that?

**中文翻译:**
能量审计 (Energy Audit)。这是你建议大家去做的一件事，用来了解什么能带给你能量，什么会消耗你的能量。你能聊聊这个吗？

---

### [01:02:06] Matt Mochary

**English:**
Sure. It turns out that what we're really good at is what we love and what we love is often space and time disappear when we do it. Therefore, we actually probably don't even value it because it comes so easily to us that we don't ascribe value. Whereas things that we don't love but we're good at, we often ascribe value there and other people want us to do those things because they're often creating value for the whole team or the family or the group.

**中文翻译:**
当然。事实证明，我们真正擅长的事情就是我们热爱的事情。当我们做热爱的事情时，时空感往往会消失。因此，我们可能根本不重视它，因为它对我们来说太容易了，以至于我们不觉得它有价值。相反，对于那些我们不喜欢但擅长的事情，我们往往会赋予很高的价值，别人也希望我们去做，因为这些事通常能为团队、家庭或集体创造价值。

---

### [01:02:58] Matt Mochary

**English:**
There are four zones I posit and I learned this from Diana Chapman at Conscious Leadership Group. I don't know where she learned it from, but almost everything that I have, I poached from somebody, but at least I tell you where I poached it from. The concept is you have four zones. Zone one is your incompetence, you're not good at it, someone's better at it than you. That's like fixing a car. You should let someone else do that. Second is your zone of competence, you're fine, you can do it fine. But so can somebody else do it fine. Like cleaning your house. Yes, you could do it, but it would take a lot of time and you're not creating that much value. You should let someone else do that.

**中文翻译:**
我提出了四个“领域”，这是我从 Conscious Leadership Group 的 Diana Chapman 那里学来的。我不知道她是从哪学来的，但我几乎所有的东西都是从别人那里“偷”来的，至少我会告诉你我是从哪偷的。这个概念是你有四个领域：第一是“无能区”，你不擅长，别人比你做得好。比如修车，你应该让别人去做。第二是“胜任区”，你能做好，但别人也能做好。比如打扫房间，你能做，但会花很多时间且创造的价值不高，你应该让别人去做。

---

### [01:03:22] Matt Mochary

**English:**
Third zone, your zone of excellence. This is something that you're uniquely good at, but you don't love it. This is the danger zone. This is likely what you're getting paid for and you're likely to getting paid a lot of money for it. Other people want you to do it. You are creating value, but it's also sucking the life force out of you and it doesn't allow you to become amazing and create massive value.

**中文翻译:**
第三个是“优秀区”。这是你非常擅长但并不热爱的事情。这是危险区。这很可能是你目前赖以生存的工作，甚至能让你赚很多钱。别人都希望你去做，你也在创造价值，但它正在吸干你的生命力，它无法让你变得卓越并创造巨大的价值。

---

### [01:03:45] Matt Mochary

**English:**
Then there's your zone of genius. This is the thing you do that's uniquely good in the world and you don't even notice that you're doing it because you love it so much. The key is to go and look at your day. How do you move into the zone of genius? It's not that you figure out what it is and do more of that, it's that you figure out what it isn't and eliminate that and then naturally, you'll be drawn toward what it is that you love.

**中文翻译:**
最后是“天才区”。这是你在世界上独一无二擅长的事情，而且因为你太热爱它了，你甚至意识不到自己在做这件事。关键在于审视你的一天。如何进入天才区？不是找出它是什并多做，而是找出它“不是”什么并将其剔除，然后你自然而然地就会被吸引到你热爱的事情上。

---

### [01:04:10] Matt Mochary

**English:**
What I do with the energy audit is you go through a calendar, two weeks of a calendar, a representative two weeks and you first look at all the meetings you have, but then you fill in there's time in between meetings. What were you actually doing? Take your best guess, write it in and then hour by hour, take a green marker and a red marker and each hour from Monday, 8:00 AM to 6:00 PM and the same thing each day for two weeks, each hour ask yourself at the end of that hour, did I have more energy or less energy?

**中文翻译:**
我做能量审计的方法是：拿出一份日历，选出具有代表性的两周。首先看你所有的会议，然后填补会议之间的空隙——你实际上在做什么？凭直觉写下来。然后逐小时记录，拿一支绿笔和一支红笔。从周一早上 8 点到下午 6 点，连续两周，每小时结束时问自己：这一个小时让我能量增加了还是减少了？

---

### [01:04:41] Matt Mochary

**English:**
If it's more energy, you mark it green. If it's neutral or negative, you mark it red. Then, once you've done that for two weeks, you look at all the reds and say what's with the themes here? Oh, one on ones with people who are no longer by direct reports, team meetings where nothing was prepared in advance and everything was verbal. Recruiting meetings, interviews with people that we didn't end up hiring. Informational interviews from people that wanted to meet me and just know me but provide no value to me. These are all things that are energy draining.

**中文翻译:**
如果能量增加了，标为绿色；如果是中性或负面的，标为红色。两周后，看看所有的红色项，总结一下主题。哦，原来是和不再直接汇报的人做一对一；是那些毫无准备、全靠口头交流的团队会议；是招聘面试，尤其是那些最终没录用的人；是那些只想见见我、认识我但对我毫无价值的咨询面谈。这些都是消耗能量的事情。

---

### [01:05:14] Matt Mochary

**English:**
Great. Now what you do is you go through each one of them and say, one, do I need to do this at all? Does it need to be done? If the answer is no, just cancel it. Two, it needs to be done, but someone else can do it. Great, delegate it to them. Three, and this is the most common, it needs to be done and only I can do it. Great, then the question is, what would make it exquisite? Well, it's the exec team meeting. I'm the CEO, I have to be in it. Well, what would make it exquisite?

**中文翻译:**
太好了。现在你逐一审视这些红色项：第一，这件事根本需要做吗？如果不需要，直接取消。第二，需要做，但别人能做吗？如果能，授权给他们。第三，也是最常见的，必须做且只能我做。好，那问题就是：如何让它变得“精妙绝伦”？比如高管会议，我是 CEO，我必须参加。那么，怎样才能让它变得不那么消耗能量，甚至变得很棒？

---

### [01:05:41] Matt Mochary

**English:**
You know what would be exquisite? It would be exquisite if everyone pre-prepared their update, which said how they're doing against their priorities, regular green, what they did last week, what they're going to do this week, and then they pre-route any problems they saw in the company and any proposed solution they had for those problems. If everyone did that, then we could spend the first 15 minutes of the meeting just reading, processing the decisions and we could take a three hour meeting down to a 45 minute meeting. Great, go write that up, share it with a group and say, hey gang, this is what would make this meaning exquisite for me. What do you guys think?

**中文翻译:**
你知道什么样才叫精妙吗？如果每个人都提前准备好更新，说明优先级任务的进展（红黄绿灯）、上周做了什么、这周要做什么，并提前列出发现的问题及建议方案。如果大家都这么做，我们会议的前 15 分钟只需阅读和处理决策，就能把 3 小时的会议缩短到 45 分钟。太棒了，把这个方案写下来发给团队说：“嘿伙计们，这样做会让这个会议对我来说变得非常高效。你们觉得呢？”

---

### [01:06:18] Matt Mochary

**English:**
Nine out of 10 times people look at it and go, yeah, that would be amazing because they're feeling the same way. Then you go with a new methodology and it turns out to be great. That's how you take what you do each day from a lot of energy draining things into open space or energy raising things which will then allow you to start doing more and more of the things that you love. You keep doing this energy audit repeatedly, 1, 2, 3 times until your calendar is 80% green. Once that happens, magic will occur. All of a sudden, your life will become phenomenal and you will start to create massive value. I did it. That's what happened to me.

**中文翻译:**
十有八九，大家会说：“太好了，那太棒了，”因为他们也有同感。然后你采用新的方法，结果会非常出色。这就是你如何将每天消耗能量的事情转化为留白或增加能量的事情，从而让你有精力去做更多热爱的事。你不断重复这个能量审计，一次、两次、三次，直到你的日历 80% 都是绿色的。一旦做到这一点，奇迹就会发生。突然间，你的生活会变得非凡，你会开始创造巨大的价值。我就是这么做的，这就是发生在我身上的改变。

---

### [01:07:05] Lenny

**English:**
I did that too actually, a simpler version where I just paid attention to what gave me energy and what didn't give me energy when I was on this journey post Airbnb and I thought I was wanted to start a company, I thought I wanted to do some advising and consulting and I realized none of that gives me energy, but writing interesting things that people like, that was fun. So I just kind of doubled down on that path and had no idea was going to make any money and it ended up making money and that's what I do now. So yeah, two thumbs up for this method and it's a more sophisticated version, which I like.

**中文翻译:**
其实我也做过，不过是简化版。在我离开 Airbnb 后的那段日子里，我留意什么能给我能量，什么不能。我曾以为我想创业，想做顾问和咨询，后来发现这些都不能给我能量。但写一些人们喜欢的有趣内容很有趣。于是我加倍投入到这条路上，当时完全不知道能不能赚钱，结果最后真的赚钱了，这就是我现在的工作。所以，我非常推崇这个方法，而且你这个版本更系统，我很喜欢。

---

### [01:07:36] Matt Mochary

**English:**
Right on. That's also trusting that there will be, if you need to monetize, eventually you will be able to monetize, but you got to start with doing the thing you love first.

**中文翻译:**
没错。这也是一种信任：如果你需要变现，最终你总能找到变现的方法，但你必须先从做你热爱的事情开始。

---

### [01:08:38] Matt Mochary

**English:**
That's exactly right. I remember one time we did this energy audit process, I did it with Henrique and Pedro from Brex and it was revolutionary for them. It caused them to change how the two of them operated together. They realized one really enjoyed the internal meetings and the other really enjoyed the external meetings, so well great, let's just do that. It changed the trajectory of the company so much so that they said, "Matt, would you please come in and do this energy audit with all of our managers?" And we did. We did a big group thing and what they found was that process also changes the trajectory of the company because for everything that you don't enjoy but needs to get done, there's someone out there that loves to do it. You just got to find out who it is, and that's what happened.

**中文翻译:**
完全正确。我记得有一次我和 Brex 的 Henrique 和 Pedro 一起做能量审计，这对他们来说是革命性的。这改变了他们两人的合作方式。他们意识到一个人非常享受内部会议，而另一个非常享受外部会议，于是他们说：“太好了，那就这么分工吧。”这极大地改变了公司的发展轨迹，以至于他们说：“Matt，能不能请你来给我们的所有经理也做一次能量审计？”我们照做了，搞了一次大型集体活动。他们发现，这个过程改变了公司的轨迹，因为任何你不喜欢但必须做的事，世界上总有人热爱去做它。你只需要找出那个人是谁，事实也确实如此。

---

### [01:09:49] Matt Mochary

**English:**
This was fun. Thanks, Lenny. I appreciate this.

**中文翻译:**
这很有趣。谢谢，Lenny。我很感激这次机会。

---

### [01:09:52] Lenny

**English:**
Super fun. I feel like a sign of a great conversation is it feels like we've been talking for maybe five minutes, but also a lifetime. Maybe we'll do this again. There's like a million other questions I'd love to get into, but until then, where can folks find you online if they want to reach out and learn more and how can listeners be useful to you?

**中文翻译:**
超级有趣。我觉得一场精彩对话的标志就是：感觉才聊了五分钟，又感觉聊了一辈子。也许我们以后还会再聊。我还有无数个问题想问，但在那之前，如果大家想联系你或了解更多，可以在哪里找到你？听众们能为你做些什么？

---

### [01:10:07] Matt Mochary

**English:**
Where can people find me? I don't know. Don't find me. I won't be able to respond. I get too many inbounds and I can't respond to them. In terms of people helpful to me, just read the content and use it and don't pay me to coach you. Just do it on your own because you don't need to pay me to coach you.

**中文翻译:**
在哪里能找到我？我不知道。别找我。我没法回复。我收到的信息太多了，根本回不过来。至于大家怎么帮我：只要阅读这些内容并付诸实践就行了。别付钱请我当教练，你自己就能做到，你不需要付钱给我。

---

### [01:10:28] Lenny

**English:**
I love that. It's the first time someone's like, "Do not reach out. I got it all for you online." We'll link to the show notes of the doc and everything. Matt, thank you. This was incredible.

**中文翻译:**
我太喜欢这个回答了。这是第一次有人说“别联系我，东西都在网上给你准备好了”。我们会把文档链接放在节目介绍里。Matt，谢谢你，这太精彩了。

---

### [01:10:43] Lenny

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
非常感谢您的收听。如果您觉得本期节目有价值，可以在 Apple Podcasts、Spotify 或您喜欢的播客应用中订阅。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现本播客。您可以在 lennyspodcast.com 找到往期所有节目或了解更多信息。下期节目再见。