# Matt Mullenweg - 双语对照

This is the complete bilingual (English-Chinese) transcript for Lenny’s Podcast featuring Matt Mullenweg.

---

### [00:00:00] Lenny Rachitsky

**English:**
If you're really open and open source, sometimes you have to stand up to the bullies and you have to fight to protect your open source ideals.

**中文翻译:**
如果你真的拥护开放和开源，有时你必须挺身而出对抗霸凌者，你必须为了保护你的开源理想而战斗。

---

### [00:00:05] Speaker 1

**English:**
Please put your hands together for Matt Mullenweg.

**中文翻译:**
请大家鼓掌欢迎马特·穆伦维格（Matt Mullenweg）。

---

### [00:00:08] Lenny Rachitsky

**English:**
Matt Mullenweg has been making some questionable moves recently. There's a lot going on with Matt and WordPress these days. 20+ years of good sentiment burned in days. You are like a 100% beloved hero of open source and internet and now you're in this, a lot of people don't like you.

**中文翻译:**
马特·穆伦维格最近做出了一些令人质疑的举动。最近关于马特和 WordPress 发生了很多事情。20 多年积累的好感在几天内付诸一炬。你曾是开源界和互联网界百分之百受人爱戴的英雄，而现在你深陷其中，很多人都不喜欢你。

---

### [00:00:23] Matt Mullenweg

**English:**
If you were kind of inside baseball with WordPress, it's actually a lot of people who have been unhappy with me over the years. Previously, 1% of the world thought I was terrible and now I feel like it's up to four or 5%.

**中文翻译:**
如果你是 WordPress 的圈内人（inside baseball，指知情人士），其实这些年来一直有很多人对我感到不满。以前，世界上可能有 1% 的人觉得我很糟糕，现在我觉得这个比例上升到了 4% 或 5%。

---

### [00:00:35] Lenny Rachitsky

**English:**
People that don't know what the hell's going on, what's just like the high level overview of what's going on?

**中文翻译:**
对于那些根本不知道发生了什么的人来说，目前情况的高层级概览（high level overview）是什么？

---

### [00:00:39] Matt Mullenweg

**English:**
There's a company called WP Engine. By 2018, they got bought out by a private equity firm called Silver Lake. Since 2019, WP Engine has kind of changed a bit. They started using the trademark, they're offering something called WordPress. They're referred to it as like a bastardized hacked up version of it. It's diluting our brand.

**中文翻译:**
有一家公司叫 WP Engine。到 2018 年，他们被一家名为银湖（Silver Lake）的私募股权公司收购。自 2019 年以来，WP Engine 发生了一些变化。他们开始使用商标，提供一种所谓的“WordPress”服务。我将其称为一种被杂交且乱改的版本。这正在稀释我们的品牌。

---

### [00:00:56] Lenny Rachitsky

**English:**
Why do you think so many people are looking at you as the bad guy?

**中文翻译:**
你认为为什么会有这么多人把你当成坏人？

---

### [00:00:58] Matt Mullenweg

**English:**
A lie gets around the world seven times before the truth has time to get out of bed.

**中文翻译:**
谎言绕世界跑了七圈时，真相才刚刚起床。

---

### [00:01:07] Lenny Rachitsky

**English:**
Today my guest is Matt Mullenweg. Matt is the co-creator of WordPress, which powers 40% of websites on the internet today, including whitehouse.gov. He's also the CEO of Automattic, which is valued at over $7 billion and owns products like WordPress.com, Tumblr, WooCommerce, Gravatar, and Pocket Casts. There is a lot of drama these days around Matt and WordPress and within the open source community, so I thought I'd have Matt on to address many of the criticisms head-on that he hasn't addressed in other places and also just get the full story on what's going on. We also chat about what incepted him to spend over half his life at this point on open source and creating WordPress. Also, why products like Llama are what he calls 'fake open source' and his perspective on AI and open source. Also, how AI is actually trained on open source code and what that means for the future and his approach for deciding what companies to acquire within Automattic.

**中文翻译:**
今天的嘉宾是马特·穆伦维格。马特是 WordPress 的联合创始人，目前互联网上 40% 的网站都由 WordPress 驱动，包括白宫官网（whitehouse.gov）。他还是 Automattic 的首席执行官，该公司估值超过 70 亿美元，旗下拥有 WordPress.com、Tumblr、WooCommerce、Gravatar 和 Pocket Casts 等产品。最近围绕马特、WordPress 以及开源社区有很多争议，所以我邀请马特来正面回应一些他在其他地方尚未回应的批评，并了解事情的全貌。我们还聊到了是什么促使他将半生精力投入到开源和创建 WordPress 中。此外，他还谈到了为什么像 Llama 这样的产品被他称为“伪开源”，以及他对人工智能与开源的看法。我们还讨论了 AI 实际上是如何在开源代码上训练的，以及这对未来的意义，还有他在 Automattic 内部决定收购哪些公司的策略。

---

### [00:02:03] Lenny Rachitsky

**English:**
If you enjoy this episode, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. Also, if you become an annual subscriber of my newsletter, you now get a year free of Notion and Superhuman and Perplexity Pro and Linear and Granola. Check it out at lennysnewsletter.com. With that, I bring you Matt Mullenweg.

**中文翻译:**
如果你喜欢这一集，别忘了在你不常用的播客应用或 YouTube 上订阅和关注。此外，如果你成为我时事通讯（newsletter）的年度订阅者，你现在可以免费获得一年的 Notion、Superhuman、Perplexity Pro、Linear 和 Granola。请访问 lennysnewsletter.com 查看。下面，让我们欢迎马特·穆伦维格。

---

### [00:02:24] Lenny Rachitsky (Ad Segment)

**English:**
This episode is brought to you by WorkOS. If you're building a SaaS app, at some point your customers will start asking for enterprise features like SAML authentication and SCIM provisioning. That's where WorkOS comes in, making it fast and painless to add enterprise features to your app. Their APIs are easy to understand so that you can ship quickly and get back to building other features. Today, hundreds of companies are already powered by WorkOS, including ones you probably know like Vercel, Webflow and Loom. WorkOS also recently acquired Warrant, the fine grain authorization service. Warrant's product is based on a groundbreaking authorization system called Zanzibar, which was originally designed for Google to power Google Docs and YouTube. This enables fast authorization checks at enormous scale while maintaining a flexible model that can be adapted to even the most complex use cases. If you're currently looking to build role-based access control or other enterprise features like single sign-on, SCIM or user management, you should consider WorkOS. It's a drop-in replacement for Auth0 and supports up to 1 million monthly active users for free. Check it out at workos.com to learn more, that's workos.com.

**中文翻译:**
本集节目由 WorkOS 赞助。如果你正在构建 SaaS 应用，你的客户迟早会开始要求企业级功能，如 SAML 身份验证和 SCIM 配置。这就是 WorkOS 的用武之地，它能让你快速且无痛地为应用添加企业功能。他们的 API 易于理解，让你能快速发布并专注于开发其他功能。如今，数百家公司已由 WorkOS 提供支持，包括你可能熟悉的 Vercel、Webflow 和 Loom。WorkOS 最近还收购了细粒度授权服务 Warrant。Warrant 的产品基于名为 Zanzibar 的突破性授权系统，该系统最初是为 Google 设计的，用于支持 Google Docs 和 YouTube。这使得在大规模情况下进行快速授权检查成为可能，同时保持了能适应最复杂用例的灵活模型。如果你目前正寻求构建基于角色的访问控制（RBAC）或其他企业功能（如单点登录 SSO、SCIM 或用户管理），你应该考虑 WorkOS。它是 Auth0 的即插即用替代方案，并免费支持多达 100 万月活跃用户。访问 workos.com 了解更多信息。

---

### [00:03:42] Lenny Rachitsky (Ad Segment)

**English:**
This episode is brought to you by Vanta and I am very excited to have Christina Cacioppo, CEO and co-founder Vanta joining me for this very short conversation.

**中文翻译:**
本集节目由 Vanta 赞助，我非常高兴邀请到 Vanta 的首席执行官兼联合创始人克里斯蒂娜·卡乔波（Christina Cacioppo）加入这段简短的对话。

---

### [00:03:51] Christina Cacioppo

**English:**
Great to be here, big fan of the podcast and the newsletter.

**中文翻译:**
很高兴来到这里，我是这个播客和时事通讯的忠实粉丝。

---

### [00:03:54] Lenny Rachitsky

**English:**
Vanta is a longtime sponsor of the show, but for some of our newer listeners, what does Vanta do and who is it for?

**中文翻译:**
Vanta 是本节目的长期赞助商，但对于一些新听众来说，Vanta 是做什么的，它是为谁服务的？

---

### [00:04:01] Christina Cacioppo

**English:**
Sure. So we started Vanta in 2018 focused on founders helping them start to build out their security programs and get credit for all of that hard security work with compliance certifications like SOC 2 or ISO 27001. Today we currently help over 9,000 companies including some startup household names like Atlassian, Ramp and LangChain start and scale their security programs and ultimately build trust by automating compliance, centralizing GRC, and accelerating security reviews.

**中文翻译:**
好的。我们在 2018 年创立了 Vanta，专注于帮助创始人开始建立他们的安全计划，并通过 SOC 2 或 ISO 27001 等合规认证，让他们辛苦的安全工作获得认可。今天，我们帮助超过 9,000 家公司，包括 Atlassian、Ramp 和 LangChain 等知名初创公司，启动并扩展其安全计划，最终通过自动化合规、集中化 GRC（治理、风险与合规）以及加速安全审查来建立信任。

---

### [00:04:31] Lenny Rachitsky

**English:**
That is awesome. I know from experience that these things take a lot of time and a lot of resources and nobody wants to spend time doing this.

**中文翻译:**
太棒了。我从经验中知道，这些事情需要耗费大量时间和资源，而且没人想把时间花在这上面。

---

### [00:04:39] Christina Cacioppo

**English:**
That is very much our experience before the company and to some extent during it. But the idea is with automation, with AI, with software, we are helping customers build trust with prospects and customers in an efficient way. And our joke, we started this compliance company so you don't have to.

**中文翻译:**
这正是我们在公司成立前，甚至在某种程度上在公司成立期间的经历。但我们的理念是利用自动化、AI 和软件，帮助客户以高效的方式与潜在客户和现有客户建立信任。我们常开玩笑说：我们创办了这家合规公司，这样你就不用自己动手了。

---

### [00:04:55] Lenny Rachitsky

**English:**
We appreciate you for doing that and you have a special discount for listeners, they can get $1000 off Vanta at vanta.com/lenny, that's V-A-N-T-A .com/lenny for $1,000 off Vanta. Thanks for that, Christina.

**中文翻译:**
感谢你们所做的工作。你们为听众提供了特别优惠，在 vanta.com/lenny 可以获得 1,000 美元的优惠。谢谢你，克里斯蒂娜。

---

### [00:05:10] Christina Cacioppo

**English:**
Thank you.

**中文翻译:**
谢谢。

---

### [00:05:14] Lenny Rachitsky

**English:**
Matt, thank you so much for being here. Welcome to the podcast.

**中文翻译:**
马特，非常感谢你能来。欢迎来到本播客。

---

### [00:05:17] Matt Mullenweg

**English:**
Thanks, big fan and long time listener, so happy to be on.

**中文翻译:**
谢谢，我是你的忠实粉丝和长期听众，很高兴能参加节目。

---

### [00:05:21] Lenny Rachitsky

**English:**
I'm a long time fan. I've been wanting to get you on this podcast for so long and this is such an interesting time to be chatting with you, there's a lot going on with Matt and WordPress these days, so it's really interesting, almost good that we waited a little bit to talk so we're going to get into a lot of that stuff. But I want to start with just what is it that you do, Matt? What are all the things you're involved in? Give people a sense of just the things you're working on.

**中文翻译:**
我也是你的长期粉丝。我一直想邀请你来参加这个播客，现在和你聊天正是一个非常有趣的时刻，最近关于你和 WordPress 发生了很多事。所以很有趣，甚至可以说等了一段时间再聊反而是好事，因为我们可以深入探讨这些话题。但我想先从你具体做什么开始，马特？你参与了哪些事情？让大家了解一下你正在处理的工作。

---

### [00:05:44] Matt Mullenweg

**English:**
So first, when I was 19, I co-founded an open source project called WordPress with Mike Little and we started just blogging software, then became sort of a full site thing and then became a platform that really tons of stuff is built on and now it's kind of transitioning into this cool WASM can be embedded anywhere or run locally or make mobile apps. It's really interesting seeing WordPress used as an engine for powering things I would say don't even look like a website, which is kind of wild to me, but that's kind of the beauty of the open source people do things with that you don't expect. End up dropping out of college, moving to San Francisco and then worked at CNET for a year as project manager actually, that's how they hired me.

**中文翻译:**
首先，在我 19 岁时，我和迈克·利特尔（Mike Little）共同创立了一个名为 WordPress 的开源项目。起初它只是博客软件，后来演变成全站构建工具，再后来变成了一个承载海量内容的平台。现在它正转型为一种很酷的 WASM（WebAssembly）架构，可以嵌入任何地方、本地运行或制作移动应用。看到 WordPress 被用作驱动那些看起来甚至不像网站的东西的引擎，这对我来说挺疯狂的，但这就是开源的魅力——人们会用它做出你意想不到的东西。后来我从大学退学，搬到了旧金山，在 CNET 工作了一年，职位其实是项目经理，那是他们录用我的初衷。

---

### [00:06:27] Lenny Rachitsky

**English:**
I want to talk about that, but go on.

**中文翻译:**
我想聊聊那段经历，不过请继续。

---

### [00:06:30] Matt Mullenweg

**English:**
And then had this vision where instead of downloading the software and setting up a database and everything, we made a SaaS version of WordPress. I pitched it at CNET, they didn't want to do it, so I was like, "Okay, I got to do this," so I left and started a company called Automattic. And the idea was to essentially compliment the core WordPress software with some commercial services, things that run in the cloud, like Akismet which is our machine learning AI, I guess you'd call it AI now, but anti-spam system, or Jetpack, which is iCloud for WordPress. It does the backups and the real time sync and everything like that.

**中文翻译:**
然后我产生了一个愿景：与其让用户下载软件、设置数据库等繁琐操作，不如做一个 SaaS 版的 WordPress。我在 CNET 提了这个方案，但他们不想做，于是我想：“好吧，我得自己来。”所以我离开了，创办了一家叫 Automattic 的公司。核心理念是用一些商业服务来补充 WordPress 核心软件，这些服务运行在云端，比如 Akismet（我们的机器学习反垃圾系统，现在大概会被称为 AI），或者是 Jetpack（相当于 WordPress 的 iCloud），负责备份和实时同步等功能。

---

### [00:07:04] Matt Mullenweg

**English:**
So that was 19 years ago, so that's now grown to be over 1700 people in actually 90 countries so we've actually been fully distributed and remote and asynchronous from the start, which I think is one of our superpowers. I actually wasn't the CEO in the beginning, but in 2014, so I guess 11 years ago, I became CEO. The original CEO was... Well, I guess I wasn't the very beginning, but then I hired Tony Schneider from BCL, probably four or five months in.

**中文翻译:**
那是 19 年前的事了。现在公司已经发展到 1,700 多人，分布在 90 个国家。我们从一开始就是完全分布式、远程和异步协作的，我认为这是我们的“超能力”之一。起初我并不是 CEO，直到 2014 年（大约 11 年前）我才接任。最初的 CEO 是……好吧，我一开始不是，大约四五个月后我聘请了来自 BCL 的托尼·施耐德（Tony Schneider）。

---

### [00:07:35] Matt Mullenweg

**English:**
And yeah, so that is a very full-time thing and Automattic does a lot of products, WooCommerce, which is open source Shopify, which is now half our revenue. And then we have some really cool apps so like Beeper, DayOne, Simplenote, Rocket Casts or trying to fill up your home screens with open web, open source things that are very privacy and user-centric. So running that company is definitely a full-time job. I still run WordPress.org and the WordPress project, so I'm the lead developer there and so sort of manage all those releases in the community and the directories and all the sort of things we do on WordPress.org and this cool thing called Openverse we took over Creative Commons, which is a way you can find sort open licensed images and audio and video. Basically if you notice a throughput through all these things, it's open source.

**中文翻译:**
是的，所以这是一份非常全职的工作。Automattic 有很多产品，比如 WooCommerce（开源版的 Shopify），它现在贡献了我们一半的收入。我们还有一些很酷的应用，比如 Beeper、DayOne、Simplenote、Pocket Casts，目标是用开放网络、开源、隐私至上且以用户为中心的东西填满你的手机主屏幕。经营这家公司绝对是全职工作。我仍然管理着 WordPress.org 和 WordPress 项目，我是那里的首席开发人员，负责管理社区发布、目录以及我们在 WordPress.org 上做的所有事情。还有我们从 Creative Commons 接手的 Openverse，这是一个寻找开源许可图像、音频和视频的工具。基本上，如果你观察这些事情的共性，那就是“开源”。

---

### [00:08:31] Matt Mullenweg

**English:**
On the nights and weekends or side, a few hours a week I do some angel investing. So I've done over 100 angel investments through an entity called Audrey Capital, which is sort of, if anything's in the sort of WordPress space, I invest in it through Automattic, but if anything's a little more further afield I do it through Audrey Capital and have done some really exciting investments there, everything from name brands like Stripe and SpaceX, but also it was in the seed of Calm or a lot of home automation stuff like Ring, August, smart things. Yeah, just check out Audrey Capital, it's got some fun stuff in there. Daylight Computer, which is one I'm very excited about right now.

**中文翻译:**
在晚上、周末或业余时间，我每周会花几个小时做天使投资。我通过一个名为 Audrey Capital 的实体进行了 100 多项天使投资。如果是 WordPress 领域的东西，我会通过 Automattic 投资；如果是更广泛领域的东西，我会通过 Audrey Capital。我在那里做了一些非常令人兴奋的投资，从 Stripe 和 SpaceX 这样的大品牌，到 Calm 的种子轮，还有很多家庭自动化产品如 Ring、August 等。你可以去看看 Audrey Capital，里面有很多有趣的东西。目前我非常看好 Daylight Computer。

---

### [00:09:11] Matt Mullenweg

**English:**
And I guess finally I love San Francisco, so I an a co-owner of a cool grungy jazz club in North Beach called Keys with Simon Rowe. So if Wednesday through Saturday night, you want to see some awesome live jazz, check out Keys.

**中文翻译:**
最后，我非常热爱旧金山，所以我和西蒙·罗（Simon Rowe）在北滩（North Beach）共同拥有一家很酷、很有格调的爵士俱乐部，叫 Keys。所以如果周三到周六晚上你想看精彩的现场爵士乐，去 Keys 看看吧。

---

### [00:09:28] Lenny Rachitsky

**English:**
Wow, okay. You said too much, I get it now. Jazz club I was not aware of, I got to check this out. It's called Keys?

**中文翻译:**
哇，好吧。你做了太多事了，我现在理解了。我以前不知道爵士俱乐部的事，我得去看看。它叫 Keys？

---

### [00:09:36] Matt Mullenweg

**English:**
Yeah, Keys Jazz Bistro.

**中文翻译:**
是的，Keys Jazz Bistro。

---

### [00:09:38] Lenny Rachitsky

**English:**
Okay, cool.

**中文翻译:**
好的，酷。

---

### [00:09:39] Matt Mullenweg

**English:**
It's over on Broadway in Columbus, kind of right around there.

**中文翻译:**
在百老汇和哥伦布大道交汇处附近。

---

### [00:09:42] Lenny Rachitsky

**English:**
Amazing. That was news to me. Going back to Automattic, I think people don't get the scale of this thing, so just to mirror back, if you think that even add to what you've said, 1700 people work there, 90 different countries. Also, you didn't share this stat, it was something like 43% of internet websites are built on WordPress, run on WordPress.

**中文翻译:**
太神奇了。这对我来说是新闻。回到 Automattic，我认为人们可能没意识到它的规模。补充一下你说的：1,700 名员工，分布在 90 个国家。而且，你没提到这个数据：互联网上大约 43% 的网站是基于 WordPress 构建或运行的。

---

### [00:10:02] Matt Mullenweg

**English:**
Yeah, so when we started, a lot of websites were built on custom CMSs and there's a lot of fragmentation in the space, but now WordPress has grown to be over 40% of all websites in the world, which is 10x the number two, which right now is Shopify.

**中文翻译:**
是的。我们刚开始时，很多网站是基于自定义 CMS（内容管理系统）构建的，领域非常碎片化。但现在 WordPress 已经增长到占据全球所有网站的 40% 以上，是第二名（目前是 Shopify）的 10 倍。

---

### [00:10:17] Lenny Rachitsky

**English:**
Right, they're like at 4%. I was looking at that list.

**中文翻译:**
对，他们大约占 4%。我刚才看了那个列表。

---

### [00:10:20] Matt Mullenweg

**English:**
They're around 4%, yeah.

**中文翻译:**
是的，大约 4%。

---

### [00:10:21] Lenny Rachitsky

**English:**
That's unreal.

**中文翻译:**
这简直不可思议。

---

### [00:10:22] Matt Mullenweg

**English:**
It used to be open source was the top three. Unfortunately, Joomla and Drupal have fallen behind, and so now it's like Shopify, Wix, Squarespace are the top ones but WordPress is still, because we have this flywheel of open source community, its movements, any open source like Linux or Apache or Wikipedia, it has some positive flywheel effects when it takes off.

**中文翻译:**
以前前三名都是开源软件。不幸的是，Joomla 和 Drupal 掉队了，所以现在前几名是 Shopify、Wix、Squarespace，但 WordPress 依然遥遥领先。因为我们拥有开源社区的飞轮效应，就像 Linux、Apache 或维基百科一样，任何开源项目一旦起飞，都会产生积极的飞轮效应。

---

### [00:10:48] Lenny Rachitsky

**English:**
Awesome, okay. And then there's a few other things you didn't mention, I want to get to this later, but I'll just mention now, you guys own Tumblr, you bought Tumblr, which I don't think a lot of people necessarily know.

**中文翻译:**
太棒了。还有一些你没提到的事，我稍后会详细谈，但现在先提一下：你们拥有 Tumblr，你们收购了 Tumblr，我觉得很多人不一定知道这一点。

---

### [00:10:56] Matt Mullenweg

**English:**
I'm sorry, I forgot to mention that, Tumblr.

**中文翻译:**
抱歉，我忘了提 Tumblr 了。

---

### [00:10:58] Lenny Rachitsky

**English:**
We're going to get into that, yeah.

**中文翻译:**
我们会深入聊聊这个，是的。

---

### [00:11:00] Matt Mullenweg

**English:**
Yeah, running a social network is definitely the hardest thing I've ever attempted. I thought we knew what we were doing because WordPress ran so much of the web, we dealt with, I thought, every content moderation thing you could ever deal with, but social networks are a whole other ballgame.

**中文翻译:**
是的，经营社交网络绝对是我尝试过最困难的事情。我原以为我们很专业，因为 WordPress 驱动了这么多网页，我们处理过我认为所有可能遇到的内容审核问题，但社交网络完全是另一回事。

---

### [00:11:15] Lenny Rachitsky

**English:**
Okay, a couple more fun facts before we get into some other stuff I want to chat about. Fun fact number one is you were super involved in the Bay Lights project. I didn't know this. For people that don't know what the Bay Lights, if you're in San Francisco you definitely know what the Bay Lights project is and I'm sure you love it, for people that don't know what this is about, what is this project and how have you been involved? Why have you been instrumental in to make this a thing?

**中文翻译:**
好，在聊其他话题前，再说几个有趣的细节。第一个是：你深度参与了“海湾之光”（Bay Lights）项目。我以前不知道这个。如果你在旧金山，你肯定知道这个项目而且肯定很喜欢它。对于不知道的人，这个项目是什么？你是如何参与其中的？为什么说你是促成这件事的关键人物？

---

### [00:11:37] Matt Mullenweg

**English:**
Bay Lights, there's two famous bridges in San Francisco, the Golden Gate Bridge, which is kind of the iconic one, there's actually the Bay Bridge, which is the workhorse of San Francisco. It's one of the busiest bridges in the country. And it's really beautiful from an engineering point of view. And so kind of a vision between Ben Davis and artist Leo Villarreal, who's an amazing light artist, actually who started Burning Man was to put, gosh, I forget the number, I think 18,000 LEDs on the side of the bridge on all the cables and create this really beautiful, gentle kind of algorithmic light piece, light art piece.

**中文翻译:**
“海湾之光”——旧金山有两座著名的桥：金门大桥是标志性的，而海湾大桥（Bay Bridge）则是旧金山的“劳模”，它是全美最繁忙的桥梁之一。从工程角度看它非常美。本·戴维斯（Ben Davis）和艺术家里奥·比利亚雷亚尔（Leo Villarreal，一位了不起的灯光艺术家，也是火人节的发起人之一）有一个愿景：在桥侧面的所有钢缆上安装——天哪，我忘了具体数字了，好像是 18,000 个 LED 灯，创造出一个非常美丽、柔和的算法灯光艺术作品。

---

### [00:12:18] Matt Mullenweg

**English:**
And yeah, Ben Davis was dating an artist friend of mine and we were over and having drinks on my patio and we were looking at the Bay Bridge and I had this kind of thing where there's some lights at the top of the Bay Bridge and I was like, "Oh, wouldn't it be cool if those lights were Christmas lights and they could do patterns or something?" It's the lights to keep planes from hitting it. And I was like, "Oh, you could program that." He was like, "Yeah." It was almost like the Social Network thing where a million's cool, but a billion would be really cool. He was like, "Yeah, that would be cool, but what if we put the whole side of it?" And so I was like, "Oh, cool," and sort of made an angel investment in that thing. They hadn't raised anything or had, I don't even think an entity at that point, but I was like to get you started, I forget what it was, 100 or 150k so I gave them that first bit and then it kind of blossomed into a thing.

**中文翻译:**
当时本·戴维斯正和我的一位艺术家朋友约会，我们在我家的露台上喝酒，看着海湾大桥。我当时注意到桥顶有一些防撞灯（防止飞机撞上），我说：“如果那些灯是圣诞灯，能显示图案什么的，不是挺酷吗？”他说：“是的，你可以给它编程。”这有点像《社交网络》里的台词：一百万很酷，但十亿才叫真的酷。他说：“是的，那很酷，但如果我们把整个侧面都装上灯呢？”我说：“哇，太酷了。”于是我给这个项目投了一笔天使资金。当时他们还没筹到钱，甚至可能还没注册实体，我给了他们第一笔启动资金，大概是 10 或 15 万美元，然后这个项目就开始萌芽了。

---

### [00:13:07] Matt Mullenweg

**English:**
And then sort of fast-forward, I don't remember the exact timeline, but they were kind of at a final bit of fundraise and they weren't able to close that last bit and I actually mortgaged my condos and donated the last million, million and a half to finish out that project. The Bay Lights were online for 10 years. The technology degraded, and so the environment's very harsh. So actually we just completed a fundraise and are reinstalling the Bay Lights. They're calling it Bay Lights 360. So now it'll be both sides of the bridge, it'll be visible from also Oakland and the Treasure Island because the first version, the city was very worried about the drivers seeing the lights and it might distract them so we had to angle them so that you could only see it from San Francisco, which was a compromise we didn't love because we love the East Bay and everything else like that too. So new version is coming online hopefully later this year in the fall.

**中文翻译:**
快进一下，我不记得确切的时间线了，但当时他们处于最后阶段的筹款，却无法完成最后那一块缺口。我实际上抵押了我的公寓，捐出了最后的 100 万到 150 万美元来完成这个项目。“海湾之光”亮了 10 年。后来技术老化了，毕竟环境非常恶劣。所以实际上我们刚刚完成了一轮筹款，正在重新安装灯光。他们称之为“海湾之光 360”。现在桥的两侧都会装灯，从奥克兰和金银岛也能看到。第一版时，市政府非常担心司机会被灯光分心，所以我们不得不调整角度，让灯光只能从旧金山一侧看到。那是一个我们并不喜欢的妥协，因为我们也热爱东湾。新版本有望在今年秋天上线。

---

### [00:14:40] Matt Mullenweg

**English:**
And also that turned into a nonprofit called Illuminate, which I'm on the board of run by Ben Davis, who I mentioned previously, that does cool public art stuff around the city. So they're responsible for the Grace Lights, all the JFK Boulevard stuff where that has some murals and the beer garden and all the chairs, that's all Illuminate. So their thing is radical public art. So it's like art that needs to be free and accessible. And I think that so important for San Francisco. We have great institutions know the SF, MoMA, the Opera, etc, that have huge budgets like 100 million a year and Illuminate literally one 10th of that has created something that millions of people can enjoy.

**中文翻译:**
这也演变成了一个名为 Illuminate 的非营利组织，我是董事会成员，由我之前提到的本·戴维斯运营。他们在城市各处做很酷的公共艺术，比如 Grace 大教堂的灯光、JFK 大道的壁画、啤酒花园和那些椅子，都是 Illuminate 做的。他们的宗旨是“激进的公共艺术”，即艺术应该是免费且人人可及的。我认为这对旧金山非常重要。我们有像 SF MoMA、歌剧院这样的大型机构，年预算上亿，而 Illuminate 用不到十分之一的预算，创造了让数百万人享受的作品。

---

### [00:15:13] Matt Mullenweg

**English:**
And I like to think that anyone along the Embarcadero, you might be going through a tough time, obviously we have people who are struggling with mental health and homelessness and everything like that, but maybe seeing a little bit of art can help raise your soul a little bit. And that's how I think about philanthropy as well. You need to work on the base issues, the fundamentals at the bottom of Maslow's Hierarchy of Needs, and then you also have to work on the things that raise your soul a little bit, so arts. So I like that barbell approach to philanthropy.

**中文翻译:**
我常想，在内河码头（Embarcadero）散步的人，也许正经历艰难时刻——显然我们有很多在心理健康和无家可归中挣扎的人——但也许看到一点艺术能让你的灵魂得到一点升华。这也是我对慈善的看法：你既要解决马斯洛需求层次底层的基本问题，也要关注那些能提升灵魂的东西，比如艺术。我喜欢这种慈善的“杠铃策略”。

---

### [00:15:13] Lenny Rachitsky

**English:**
Elon has a great quote along those lines, "You can't just work on solving problems all day, you need something inspiring to think about and to work towards." First of all, thank you for doing this. If you live in SF, you're like, this makes the city better, just having this around. I didn't realize you were involved in helping come up with the idea itself. I know that you did mortgaged your house to make it possible.

**中文翻译:**
埃隆（马斯克）有一句名言：“你不能整天只忙着解决问题，你需要一些鼓舞人心的东西去思考和奋斗。”首先，感谢你做这些。如果你住在旧金山，你会觉得有这些东西让城市变得更好。我之前没意识到你还参与了构思。我只知道你抵押了房子来促成这件事。

---

### [00:15:32] Matt Mullenweg

**English:**
I can't take any credit for the idea, I was exposed to it. I had an adjacent idea and they had a way cooler one with a real artist and everything like that. So I was just happy to be there. It's like being an angel investor, you can support the entrepreneurs and the people who truly do it.

**中文翻译:**
我不能把这个点子归功于自己，我只是接触到了它。我有一个类似的念头，而他们有一个更酷的、有真正艺术家参与的方案。所以我只是很高兴能在场。这就像做天使投资人，你可以支持那些真正动手实现的创业者。

---

### [00:15:49] Lenny Rachitsky

**English:**
Yeah, okay. And the other funny thing you said is about they were worried about the angle of the lights distracting people. What's funny is when I drive across the bridge, you can only see it when you're driving towards San Francisco looking backwards. So I'm looking in my rearview mirror or in the mirror turning around to the kind and it feels more dangerous, the lights shining in my face.

**中文翻译:**
是的，好吧。你提到的另一件趣事是他们担心灯光角度会让人分心。有趣的是，当我开车过桥时，只有在开往旧金山并向后看时才能看到它。所以我得盯着后视镜或者转头看，这反而感觉更危险，灯光直接晃在脸上。

---

### [00:16:07] Matt Mullenweg

**English:**
They call it impossible works of art. There were like 13 agencies that had to sign off, they were worried the lights would distract birds or seals or environmental reviews, and it was really a lot of public bureaucrats and to make that happen, there was 20 places where someone could have said no and it never would happen. So it's very inspiring to see the city come together.

**中文翻译:**
他们称之为“不可能的艺术品”。当时有大约 13 个机构需要签字批准，他们担心灯光会干扰鸟类、海豹，还有环境评估，真的涉及很多政府官僚。为了促成这件事，只要有 20 个环节中任何一个人说“不”，它就永远不会发生。所以看到整座城市团结起来是非常令人振奋的。

---

### [00:16:31] Matt Mullenweg

**English:**
Also in San Francisco, I feel like is entering new chapter right now, going from the doom loop to the boom loop. I'm a big believer in the city. So much innovation has come here from food, the burrito, fortune cookies, all these sorts of things are from San Francisco to obviously all the tech innovation that we're all familiar with. It's kind of the city of the future and I don't know what it is in the water from the '60s until now, cultural innovations, things that happen and influenced the whole world, Burning Man, Grateful Dead, et cetera. That all starts in San Francisco. So it's exciting to be here.

**中文翻译:**
此外，我觉得旧金山正进入一个新篇章，从“末日循环”（doom loop）转向“繁荣循环”（boom loop）。我是这座城市的坚定信徒。这里诞生了太多创新，从食物（如卷饼、幸运饼干）到我们熟悉的科技创新。它有点像未来之城，我不知道这里的“水”里有什么，从 60 年代到现在，那些影响全世界的文化创新——火人节、感恩而死乐队（Grateful Dead）等等——都始于旧金山。所以能在这里很令人兴奋。

---

### [00:17:03] Lenny Rachitsky

**English:**
Let's set the so back, as they say on Twitter. Okay, someone very close to you told me that you're an excellent rapper. I'm not going to ask you to rap, but if you ever want to answer any questions in rap form, feel free.

**中文翻译:**
让我们“拨乱反正”，就像推特上说的那样。好吧，有个和你很亲近的人告诉我，你是个优秀的饶舌歌手（rapper）。我不会要求你现场表演，但如果你想用饶舌形式回答问题，请随意。

---

### [00:17:17] Matt Mullenweg

**English:**
Oh man, that would be fun. I've dreamed about being able to do a Q&A and rhyme, but I don't think I'm that talented.

**中文翻译:**
噢天哪，那会很有趣。我曾梦想过能一边做问答一边押韵，但我觉得我没那么有才华。

---

### [00:17:26] Lenny Rachitsky

**English:**
Planting the seed, I'm planting the seed. So I want to get into all the drama there in this world and right now, but I want to first lay the foundation of how you got into this and where this all came from. So let's talk about just the origin story of you and open source. More than half of your life, you've been working on open source, you've been working on WordPress, specifically WordPress is such a core community within the open source. What was kind of the origin story of you becoming obsessed and, I don't know, open source-pilled?

**中文翻译:**
我只是先埋个种子。我想聊聊现在的这些争议，但我想先打个基础，聊聊你是如何进入这个领域的。你超过一半的人生都在做开源，特别是 WordPress，它是开源界的核心社区。你最初是如何变得痴迷于开源，或者说“被开源洗脑”的？

---

### [00:17:56] Matt Mullenweg

**English:**
I was a broke kid in Houston, Texas, and my passions were jazz. Houston has actually amazing music programs in the public schools, and so I was very fortunate to go to some of the best civil arts programs, including my high school called the High School for Performing and Visual Arts, where Beyoncé went, Robert Glasper, amazing folks went there. And so music was a big part of my life, and actually economics. So I had this fun teacher, Scott Roman, who participated in our school in the Federal Reserve Challenge, which was run by the Federal Reserve that sets the interest rates and backs the national banking system and everything like that, has this competition for high school students. It ended up being the first academic competition this art school ever won. And yeah, first year we kind of didn't get that far, second year we went all the way to nationals so I got to meet Alan Greenspan, Ben Bernanke was our judge, went to DC. So that was very, very exciting.

**中文翻译:**
我曾是德克萨斯州休斯顿的一个穷孩子，我的热情在于爵士乐。休斯顿的公立学校有很棒的音乐项目，我很幸运能参加一些顶尖的艺术课程，包括我的高中——表演与视觉艺术高中（HSPVA），碧昂丝（Beyoncé）和罗伯特·格拉斯帕（Robert Glasper）都曾就读于此。音乐是我生活的重要部分，经济学也是。我有一位有趣的老师斯科特·罗曼（Scott Roman），他带领我们学校参加了美联储挑战赛。这是由美联储举办的高中生竞赛。最终，这成了这所艺术学校赢得的第一个学术竞赛奖项。第一年我们没走太远，第二年我们打进了全国赛，我见到了格林斯潘（Alan Greenspan），伯南克（Ben Bernanke）是我们的评委，我们还去了华盛顿特区。那非常令人兴奋。

---

### [00:19:01] Matt Mullenweg

**English:**
And so being exposed to us having a great liberal arts education, the ideas of Frederick Hayek, Agnes Smith, Alexander Hamilton, Ben Franklin, Thucydides, all these sorts of things, that philosophy really influenced me. And combine that with that, music lessons were expensive, so we couldn't really afford them, so I would barter and trade. I'd build websites for local musicians and exchange for lessons. So these websites, I would start to put software on forums or different things and that kind of exposed me to open source. So my father was also an engineer, he worked for oil companies and things, but his world was all Microsoft, it was all proprietary. And I always kind of grew up in early days of the internet, so was Slashdots and Jeffrey Zeldman talked about web standards and all these things are really kind of the social milieu and zeitgeist that I grew up in.

**中文翻译:**
由于接受了良好的博雅教育，哈耶克（Frederick Hayek）、亚当·斯密（Adam Smith）、汉密尔顿、富兰克林、修昔底德等人的思想深深影响了我。与此同时，音乐课很贵，我们负担不起，所以我学会了“以物易物”。我会为当地音乐家建立网站来换取课程。在建站过程中，我开始在论坛上使用各种软件，这让我接触到了开源。我父亲也是一名工程师，他在石油公司工作，但他的世界全是微软，全是专有软件（proprietary software）。而我成长于互联网早期，Slashdot 论坛、杰弗里·泽尔德曼（Jeffrey Zeldman）谈论的网页标准，这些都是我成长过程中的社会环境和时代精神。

---

### [00:20:24] Matt Mullenweg

**English:**
So combining all this philosophy I studied, it felt that open source was actually the most important idea of our generation. If the founding fathers were around today, I think they would be open source advocates. If you think about it as more and more of our lives are influenced and actually controlled by the software we use, if we don't have fundamental freedoms attached to that software, we're not truly free.

**中文翻译:**
结合我学到的所有哲学，我觉得开源实际上是我们这一代最重要的思想。如果美国的国父们活在今天，我认为他们会是开源的倡导者。如果你思考一下，我们的生活越来越多地受到所用软件的影响甚至控制，如果这些软件不具备基本自由，我们就不是真正的自由。

---

### [00:20:24] Matt Mullenweg

**English:**
So WordPress is under license called the GPL, which has four freedoms, the freedom to use the software for any purpose, so we can use it for anything, whether I agree with you or not, the terms of service is you could do whatever you want with it. The freedom to see how the software works, open up the hood, see how it works, see every line of code, you can audit it. The freedom to change it is the third freedom. And then finally the freedom to redistribute those changes so you can share them. And the GPL has a fun little hack where if you share them, you have to provide those same freedoms to who you share it with. So it's called a viral open source license as opposed to the MIT license or some of the others that aren't.

**中文翻译:**
所以 WordPress 采用的是 GPL 许可证，它包含四项自由：为任何目的使用软件的自由（无论我是否同意你的观点，你都可以随心所欲地使用它）；查看软件如何运行的自由（打开引擎盖，查看每一行代码，进行审计）；修改软件的自由；以及重新分发这些修改的自由。GPL 有一个有趣的“黑客手段”：如果你分享了修改后的版本，你必须向接收者提供同样的自由。所以它被称为“病毒式”开源许可证，这与 MIT 许可证等非强制性许可证不同。

---

### [00:21:36] Matt Mullenweg

**English:**
So yeah, just kind of decided that this was what I was going to devote my life to. And so that became getting involved with some early open source projects, WordPress was actually a fork of abandoned open source project called B2. So the code base actually started was something that was already out there that I was a user and contributor to kind of volunteer on the forums and contribute code. And then when it was abandoned, myself and Mike were one of four or five different forks that started that, picked it up and tried to continue it for our own use and then later for our larger community.

**中文翻译:**
所以，我决定将一生奉献给这件事。我开始参与一些早期的开源项目。WordPress 实际上是一个被遗弃的开源项目 B2 的分叉（fork）。代码库最初是现成的，我曾是它的用户和贡献者，在论坛上当志愿者并贡献代码。当它被遗弃时，我和迈克是四五个不同分叉中的一个，我们接手了它，起初是为了自用，后来是为了更大的社区。

---

### [00:21:36] Lenny Rachitsky

**English:**
It feels like a lot of people are coming around to exactly your worldview in, say, I was just watching a video of Jack Dorsey talking about how we're just controlled by algorithms and we don't know how they work and we are not in control of our lives. Have you seen that video?

**中文翻译:**
感觉现在很多人都开始认同你的世界观了。比如，我刚看了一个杰克·多西（Jack Dorsey）的视频，他在谈论我们如何被算法控制，而我们既不知道算法如何运作，也无法掌控自己的生活。你看过那个视频吗？

---

### [00:21:52] Matt Mullenweg

**English:**
No, but I actually love that. Also, some people who maybe made their first billion or whatever from proprietary software then come back and it's so cool to see folks like Marc Andreessen or Bill Gurley be huge advocates for open source. I actually remember one of my early meetings with Andreessen Horowitz, Marc Andreessen. I didn't realize that at the time, Tony Schneider and I were sort fundraising and Marc really grilled us, he's like, "How can you build a business on open source? How can you be remote and distributed? Look around Silicon Valley, Google, Microsoft, Oracle, Sun, every great company has had an office. How are you going to build something that can change the internet with people all around the world?" And just had this long hour long debate and we walked out of that, I was like, "Wow, that was the worst meeting ever. They just hate everything we're doing."

**中文翻译:**
没看过，但我很喜欢这个观点。而且，看到一些通过专有软件赚到第一桶金的人转而支持开源，这真的很酷，比如马克·安德森（Marc Andreessen）或比尔·格利（Bill Gurley）。我记得早期和 Andreessen Horowitz 见面时，马克·安德森对我进行了严厉的质询。当时我和托尼·施耐德正在融资，马克问：“你怎么能靠开源建立商业模式？你怎么能搞远程和分布式？看看硅谷，谷歌、微软、甲骨文、Sun，每家伟大的公司都有办公室。你怎么能靠分布在世界各地的人做出改变互联网的东西？”我们辩论了一个小时，走出来时我想：“哇，那是有史以来最糟糕的会议，他们讨厌我们做的一切。”

---

### [00:22:48] Matt Mullenweg

**English:**
And then the next day they were like, "Hey, we're interested." I was like, "What happened?" I didn't realize that he had this idea where he wanted to attack the ideas and see how we defended it was how they battle tested things. I guess kind of like a Microsoft culture or whatever where you really grill the idea, I just wasn't familiar with that. But it's so cool now that some of these folks that I've learned so much from are such good advocates for open source.

**中文翻译:**
结果第二天他们说：“嘿，我们感兴趣。”我当时心想：“发生了什么？”我后来才意识到，他的策略是攻击你的想法，看你如何辩护，以此来测试想法的韧性。我想这可能有点像微软文化，对想法进行严酷考验，我当时只是不熟悉这种风格。但现在看到这些我曾学习过的前辈成为开源的坚定倡导者，真的很棒。

---

### [00:23:15] Lenny Rachitsky

**English:**
Yeah, it's so interesting. I just had the Community Notes team on the podcast, and that's an amazing example of open source, Meta is adopting it from Twitter/X. Speaking of open source, one of the interesting, maybe most common ways people hear about open source these days is AI and AI models, and there's a couple areas here, one is you wrote this really interesting post where you talk about how Meta talks about Llama as an open source project, but you called it a false prophet. What is it about Llama that isn't open source? What are people missing when they see Llama and they're like, "Oh, Meta is amazing open sourcing everything."

**中文翻译:**
是的，很有趣。我刚邀请了 Community Notes 团队来播客，那是开源的一个绝佳例子，Meta 正在从 Twitter/X 借鉴它。说到开源，现在人们最常听到开源的地方可能是 AI 和 AI 模型。你写过一篇非常有趣的文章，谈到 Meta 如何宣称 Llama 是开源项目，但你称之为“伪先知”（false prophet）。Llama 到底哪一点不符合开源定义？当人们看到 Llama 并感叹“Meta 太棒了，把一切都开源了”时，他们漏掉了什么？

---

### [00:23:52] Matt Mullenweg

**English:**
Llama, you can obviously download and run locally and all these sorts of things, right? You don't have to use their SaaS service. However, there's a clause in it that says if you're above a certain threshold of monthly active users... as if you're above a certain threshold of monthly active users. I forget what it is. It's big. It's like 750 million, so it's pretty high. You need a license from them. And so that does not give you the freedom to use the software for any purpose. If at some point you have to ask for permission, you're kind of at the whims of this company who you might be aligned with or you might be an enemy with. And also, how do you define that? So, for example, on WordPress, our products don't have 750 million monthly active registered users, but we reach billions of people per month in terms of visitors. So, is that defined? So, there's just ambiguity there.

**中文翻译:**
Llama 确实可以下载并在本地运行，你不需要使用他们的 SaaS 服务。然而，它的条款中有一个条款规定，如果你的月活跃用户（MAU）超过一定阈值——我忘了具体数字，但很大，好像是 7.5 亿——你就需要获得他们的许可。这意味着它没有赋予你“为任何目的使用软件”的自由。如果你在某个点必须请求许可，你就受制于这家公司的反复无常，而你可能与他们是盟友，也可能是敌人。而且，如何定义这个阈值？例如在 WordPress，我们的产品没有 7.5 亿注册月活用户，但我们的月访问量达到数十亿。这该如何定义？这里存在模糊地带。

---

### [00:24:54] Matt Mullenweg

**English:**
Actually, Meta has been a huge open source contributor. React. They've had incredible improvements to the PHP engine, which we benefit from a lot. So, they're actually a big open source contributor. I think Mark Zuckerberg really understands and loves open source too. My best guess now, I don't have any inside information here, but I think they're calling it open source because there's some European regulation about open source versus proprietary AI models. So, I think it might be a weird regulatory thing because clearly they understand this isn't open source. When I wrote the blog post, I was just kind of confused, and thought, "Oh, maybe if I get this message out there, they'll change." And then when they didn't, I was like, "Oh, there must be something else going on. I think it might be this regulatory thing." We were actually a big part of, actually many, many years ago, I think it was React that they were doing something with a licensing or a patent restriction on, and the WordPress community actually got Meta to change that and reverse something they were doing to lock it down.

**中文翻译:**
事实上，Meta 一直是巨大的开源贡献者。比如 React，还有他们对 PHP 引擎做出的惊人改进，我们从中受益匪浅。所以我认为马克·扎克伯格确实理解并热爱开源。我现在的猜测是（我没有内部消息），他们之所以坚持称其为开源，是因为欧洲有一些针对开源与专有 AI 模型的监管规定。所以这可能是一个奇怪的监管策略，因为他们显然明白这不符合开源定义。我写那篇博文时只是感到困惑，觉得“也许我发声了，他们会改”。当他们没改时，我想：“哦，肯定有别的原因，可能是监管问题。”多年前，在 React 的许可或专利限制问题上，WordPress 社区曾促使 Meta 改变立场，撤销了他们原本用来限制软件的条款。

---

### [00:25:53] Matt Mullenweg

**English:**
So, I consider my role as an open source advocate to actually be my primary thing. And it's very much my life mission. I hope to work on WordPress the rest of my life, but also just open source in general. I also support Drupal and Joomla. Anything else that's open source, I'm going to be a supporter of because I think when people choose that versus proprietary software, we're increasing the freedom and liberty in the world. It's incumbent on us to make open source, to make a better user experience, to make a better product so that people choose it, and then the world becomes more free, not less free.

**中文翻译:**
所以我认为我作为开源倡导者的角色其实是我的首要任务。这在很大程度上是我的生命使命。我希望余生都能致力于 WordPress，以及广义上的开源。我也支持 Drupal 和 Joomla。任何开源的东西我都会支持，因为我认为当人们选择开源而非专有软件时，我们就在增加世界的自由。我们有责任让开源拥有更好的用户体验和产品质量，让人们主动选择它，从而让世界变得更自由，而不是更封闭。

---

### [00:26:36] Lenny Rachitsky

**English:**
It also feels it's important to you to, I don't know, white open source washing, like avoid people using the term when it's not true. And it's interesting in this case, that the thing that makes it not truly open source is the limit. There's a limit where you can no longer use it the way you want. Is that the issue?

**中文翻译:**
感觉对你来说，防止“开源洗白”（open source washing）也很重要，即避免人们在不符合事实的情况下使用这个词。在这个案例中，有趣的是，导致它不是真正开源的原因是那个“限制”——达到某个限制后你就不能随心所欲地使用它了。是这个问题吗？

---

### [00:26:53] Matt Mullenweg

**English:**
Yeah. And there's actually an open source OSI. There's a formal definition for what makes an open source license. And there's actually many dozens of open source licenses, and sort of public domain licenses and other things. So, it's also their stance that this is not an open source license.

**中文翻译:**
是的。实际上有一个开源倡议组织（OSI），它对什么是开源许可证有正式定义。目前有几十种开源许可证，还有公共领域许可证等。OSI 的立场也是：Llama 的许可证不是开源许可证。

---

### [00:27:15] Lenny Rachitsky

**English:**
Something else that I think is really interesting when it comes to AI and open source, you wrote about this and it blew my mind, such a good point, that the code that these models were trained on was open source code because that's all they have access to. They don't have Windows code, they don't have Shopify code. And what a cool, I don't know, another success story slash... I don't know. I guess, how do you feel about that, that all these AI models are trained on code you wrote in open source community?

**中文翻译:**
关于 AI 和开源，还有一点我觉得非常有趣，你曾写过这一点，让我大开眼界：这些模型训练所用的代码大多是开源代码，因为那是它们唯一能接触到的。它们没有 Windows 的代码，也没有 Shopify 的代码。这真是一个酷炫的成功案例……你怎么看这件事？所有的 AI 模型都在用你和开源社区编写的代码进行训练。

---

### [00:27:43] Matt Mullenweg

**English:**
That's beautiful. It's one of the safest things to train on, right, because the license of open source very explicitly allows that. I also like to think about I have some window where my creative output is useful to society. And if you fast forward like 50 or 100, I do believe that the utility for proprietary software eventually approaches zero. When we're sending people to Mars, the operating system of the rockets and the devices and everything like that is not going to be built on the Windows NT kernel, as amazing feat of engineering that that proprietary kernel is. It's going to be built on an open source kernel, Linux or BSD or something like that. And so if you want to be part of something that sort of becomes the fabric of humanity's foundation, like things that allows a Cambrian explosion of things built on top of it, a renaissance of ideas, you want to be involved with open source.

**中文翻译:**
这很美好。这是最安全的训练素材之一，因为开源许可证明确允许这样做。我也常想，我的创造性产出在某个时间窗口内对社会是有用的。如果快进 50 或 100 年，我相信专有软件的效用最终会趋于零。当我们把人类送上火星时，火箭和设备的操作系统不会基于 Windows NT 内核构建（尽管那个专有内核是工程学上的奇迹），它一定会基于 Linux 或 BSD 这样的开源内核。所以，如果你想成为人类文明基石的一部分，成为那种能引发“寒武纪大爆发”式创新和思想复兴的东西，你就应该参与开源。

---

### [00:28:38] Matt Mullenweg

**English:**
And so I really hope that more and more people... I'm a little bit of an evangelist here. I'm a missionary, where I really want to encourage more and more people to consider at least making part of their time, even if just a few hours a week, contributing to open source because you could be part of something that is a huge impact. And it's fun, especially if you're a younger developer or designer or PM or whatever, you can't walk up to Facebook and change your home page or say, "I'd like to change this feature," but you could come to an open source project, some of which have hundreds of millions of users. You could go to WordPress or, gosh, Bitcoin. Or there's all these things are open source, Chromium, Firefox, and you could actually change a feature or project management things or change the design or improve it. And that's I think really, really special.

**中文翻译:**
所以我真的希望越来越多的人……我在这里有点像个布道者或传教士，我真的想鼓励更多人考虑至少花一部分时间（哪怕每周几小时）贡献开源。因为你可以成为具有巨大影响力事业的一部分。而且这很有趣，特别是如果你是年轻的开发、设计或产品经理，你不能直接跑到 Facebook 去改他们的首页或功能，但你可以参与一个拥有数亿用户的开源项目。你可以去 WordPress，或者比特币，还有 Chromium、火狐浏览器，你可以实际改变一个功能、改进设计或项目管理。我认为这非常特别。

---

### [00:29:53] Lenny Rachitsky

**English:**
Say someone wants to actually do this, where do they go? How do they do this? Do they just pick up a project, go to WordPress. org and here's how you contribute? What's a next step there?

**中文翻译:**
如果有人真的想这么做，他们该去哪？怎么开始？是直接找个项目，去 WordPress.org 找贡献指南吗？下一步是什么？

---

### [00:30:03] Matt Mullenweg

**English:**
Yeah, pick a project that you use or like. That's obviously a nice one. For WordPress, we have this... It's called make.WordPress.org. That's where we make WordPress. And there's different groups, there's accessibility, there's design, there's the core code, there's plugins, there's all sorts of ways. So, really whatever your talent is, there's people who translate, there's people who do support, there's people who write documentation, there's people who organize events, so whatever you feel like your talent in the world is either that you have or that you want to cultivate. I learned how to code while building WordPress basically. I didn't have too much formal training there. So, it's a great way to [inaudible 00:30:48] your skills as well, and work with some of the best developers and others in the world.

**中文翻译:**
是的，选一个你正在使用或喜欢的项目。对于 WordPress，我们有一个网站叫 make.WordPress.org，那是我们“制造”WordPress 的地方。那里有不同的小组：无障碍、设计、核心代码、插件等等。无论你的才华是什么，都有适合你的位置——有人做翻译，有人做支持，有人写文档，有人组织活动。无论你拥有什么才华，或者想培养什么技能，都可以参与。我基本上是在构建 WordPress 的过程中学会写代码的，我没受过太多正式培训。所以，这也是提升技能、与世界顶尖开发者共事的好方法。

---

### [00:31:10] Matt Mullenweg

**English:**
I think Google talked about 25% of their code or characters committed are now sort of AI-assisted, and they're probably on the bleeding edge. I don't know how much of WordPress's code right now is AI-assisted or something like that. But I think over the next five years it definitely approaches maybe a majority. And I'm actually very, very excited, so one of the big challenges that we have as a very open platform is we have this open plugin and theme architecture, so the 60,000 plugins and themes and the way WordPress works is these plugins and themes can modify every single part of the code, so you can really customize everything. However, many of these plugins and themes don't have the same sort of robust security and review process that core has. So, that's where when you hear about security issues with WordPress, it's very rarely in core anymore.

**中文翻译:**
谷歌曾提到他们 25% 的代码或提交字符现在是 AI 辅助的，他们可能处于最前沿。我不知道目前 WordPress 有多少代码是 AI 辅助的，但我认为在未来五年内，这个比例肯定会接近甚至超过一半。我其实非常兴奋。作为开放平台，我们面临的一大挑战是开放的插件和主题架构——目前有 6 万个插件和主题。WordPress 的运作方式允许这些插件修改代码的任何部分，实现高度定制。然而，许多插件和主题没有核心代码那样稳健的安全审查流程。所以当你听到 WordPress 的安全问题时，现在极少发生在核心代码中。

---

### [00:32:03] Matt Mullenweg

**English:**
We haven't had a remote exploit, knock on wood, it's like I think five or six years or something, but in the plugins it can be somewhat more frequent. And so one thing I'm very, very excited about the next year or two is actually more automated scanning because obviously that code basis is so many tens of millions, maybe over 100 million lines of code at this point. It's impossible for humans to review that, so we kind of rely on developers to review that and manage. And of course, we have bug bounties and everything do that, so when things get reported, we fix it quickly. But I can't wait for more automated scanning there, and I think that could vastly upgrade the security of open source.

**中文翻译:**
敲木头保佑（knock on wood），核心代码已经大概五六年没出现过远程漏洞了，但在插件中这种情况会频繁一些。所以我对未来一两年非常期待的一件事是更多的自动化扫描。因为代码库已经有数千万甚至上亿行，靠人工审查是不可能的。我们依赖开发者自审，也有漏洞赏金计划，一旦发现问题就迅速修复。但我迫不及待想看到更强大的自动化扫描，我认为这能极大地提升开源软件的安全性。

---

### [00:32:54] Matt Mullenweg

**English:**
As everyone knows, just writing the code is just one part of it. It's maintaining it that really becomes the life cycle of it. And Stewart Brand's new book is all about maintenance, which I'm very excited about. He's publishing, I think, with Stripe. And it's actually kind of open source. He's open sourcing the book, so you can see it being written online. But anyway, to go back, I think that if... And they're starting to do that, is when the open source models you say like, "Hey, build me a website." It actually installs WordPress, and then builds on top of that, and then customizes on top of that. Then you get for free that core engine that's always being audited and updated and getting passkey support or whatever the new things are sort of continuously. And then your custom stuff can be on top of that, which I think is actually a lot more powerful than building something proprietary or custom from the ground up.

**中文翻译:**
众所周知，写代码只是第一步，维护才是软件生命周期的核心。斯图尔特·布兰德（Stewart Brand）的新书就是关于“维护”的，我非常期待。这本书好像是由 Stripe 出版的，而且它有点像开源的——他在网上公开写作过程。回到正题，我认为如果……现在已经有人开始这么做了，当你对开源模型说“帮我建个网站”时，它实际上会安装 WordPress，然后在上面构建和定制。这样你就免费获得了一个不断被审计、更新、支持 Passkey 等新特性的核心引擎，而你的自定义内容则构建其上。我认为这比从零开始构建专有或自定义系统要强大得多。

---

### [00:33:43] Lenny Rachitsky

**English:**
I love this book concept about maintenance. My sister's partner has this quote that I've always come back to, "Life is maintenance." You basically... Everything you acquire and deal with... You get a generator for your house, you have to maintain that forever now. You get this backpack, okay, now you have to maintain this thing, keep it nice, nice jacket. Everything is maintenance. Everything in your life is just maintenance. And I wonder if that's what the book's about.

**中文翻译:**
我喜欢关于“维护”的这个概念。我姐姐的伴侣有一句话我一直铭记在心：“生活就是维护。”你获得和处理的每一件事……你给家里买个发电机，你现在就得永远维护它。你买个背包，好，你得维护它，保持整洁。一件好夹克也是。生活中的一切都是维护。我在想那本书是不是就在讲这个。

---

### [00:34:09] Matt Mullenweg

**English:**
Well, that's why I think technical debt is one of the most interesting concepts. There's so many companies as well that maybe have big market caps, but I feel like they might have billions or tens of billions of dollars of technical debt. You can see in the interface or how their products integrate with themselves through things. And I think about that a lot in our own company. We definitely have some products, almost a little embarrassed coming on because you have such great product people. And we have some variable quality around some of our things right now. If you check out Gravatar right now, I'm actually really proud of it. It's I think a really great user experience, very slick. But there's parts of... Well, I always say, "I'm the unhappiest WordPress user in the world," so there's parts of WordPress and WordPress.com that I'm a little embarrassed and ashamed of.

**中文翻译:**
这就是为什么我认为“技术债”是最有趣的概念之一。有很多市值巨大的公司，我觉得他们背负着数十亿甚至数百亿美元的技术债。你可以从界面或产品内部的集成方式中看出来。我也经常思考我们公司的情况。我们确实有一些产品——在你面前说这个有点尴尬，因为你接触的都是顶尖的产品人——我们目前有些产品的质量参差不齐。如果你现在去用 Gravatar，我真的很自豪，它的用户体验非常棒，很流畅。但有些部分……我常说“我是世界上最不快乐的 WordPress 用户”，WordPress 和 WordPress.com 的某些部分让我感到有点尴尬和羞愧。

---

### [00:34:52] Matt Mullenweg

**English:**
We have a really large surface area that we cover with relatively few people, and so there's some parts we haven't looked at in a little while that we need to get around to. And it's a big focus for us this year, is actually kind of going back to basics, back to core, and improving all of those kind of nooks and crannies of the user experience, and also ruthlessly editing and cutting as much as possible, because we just launched a lot of stuff over the past 21 years that maybe is not as relevant today or it doesn't need to be there.

**中文翻译:**
我们用相对较少的人手覆盖了巨大的业务面，所以有些部分我们已经有一段时间没顾及到了，现在需要去处理。今年我们的一个重点是“回归基础，回归核心”，改进用户体验中所有的细枝末节，并无情地进行删减，因为在过去的 21 年里我们发布了很多东西，有些在今天可能已经不再相关，或者根本没必要存在。

---

### [00:35:21] Lenny Rachitsky

**English:**
That sounds like excellent work for this AI agent of the future that's coming soon. There's one other area I want to mine and that's community, community building, building this ecosystem that you've created around WordPress. It might be one of the most successful, biggest communities on the internet. I'm curious just what lessons you've learned about what it takes to build a successful community, online especially.

**中文翻译:**
这听起来像是未来 AI 智能体（AI agent）非常适合做的工作。我想挖掘的另一个领域是社区——社区建设，以及你围绕 WordPress 建立的这个生态系统。它可能是互联网上最成功、最大的社区之一。我很想知道，在建立成功的社区（尤其是线上社区）方面，你学到了哪些经验？

---

### [00:35:48] Matt Mullenweg

**English:**
This is probably influenced by economics and jazz. And economics is all about systems thinking. And what are the incentive structures of how you set something up? And then in jazz is all about collaboration. So, if there's something unique I have for your audience, I would say it's don't just build a product, build a movement. And to the extent that we've been successful, I think it's that we give people something to believe in, a philosophy, a worldview. Even silly things, like we had this tagline in the footer of the WordPress.org when we started, it's still there, it says, "Code is poetry." This idea that we're not just writing code, we're trying to create something that can have elements. We name every WordPress release after a jazz musician for the past 60 releases or so. So, those sorts of things bring a little art and soul and some fun into it as well.

**中文翻译:**
这可能受到了经济学和爵士乐的影响。经济学关乎系统思维和激励结构；而爵士乐关乎协作。如果说我有什么独特的经验分享给你的听众，那就是：不要只做一个产品，要发起一场运动。我们之所以成功，是因为我们给了人们一种信仰、一种哲学、一种世界观。甚至是一些看似微不足道的小事，比如 WordPress.org 成立之初页脚的那句口号——现在还在——“代码即诗”（Code is Poetry）。这种理念意味着我们不只是在写代码，我们是在创造具有美感的东西。过去 60 多个版本的 WordPress 都是以爵士乐手的名字命名的。这些细节为产品注入了艺术、灵魂和乐趣。

---

### [00:36:44] Matt Mullenweg

**English:**
It doesn't have to be serious all the time. I think they can give something to believe in and work on and aim towards that's more than just a paycheck or more than just the utility, the base utility of the software. So, it's not just the software, it's also like: how are the meetups? How are people getting together? What events are you running? Are there forums? How do people contribute? Is there office hours or town halls? I do a lot of Q&A. So, what are the things you're doing around the software that's allowing people to get involved, that's inviting contributions, that's allowing people to build on top of it? I've studied platforms quite a bit like Microsoft and others, so our whole ecosystem of plugins and themes is part of what's made WordPress so successful, and the moat that we have.

**中文翻译:**
事情不一定非要时刻保持严肃。我认为可以给人们一些值得相信、值得为之奋斗的目标，而不仅仅是为了薪水或软件的基本功能。所以，这不仅仅关乎软件，还关乎：线下聚会（meetups）怎么样？人们如何聚在一起？你举办什么活动？有论坛吗？人们如何贡献？有答疑时间或市政厅会议（town halls）吗？我经常做问答。你在软件之外做了哪些事来让人们参与进来、邀请贡献、并允许人们在其上构建？我研究过微软等平台，我们整个插件和主题生态系统是 WordPress 如此成功的原因，也是我们的护城河。

---

### [00:37:33] Matt Mullenweg

**English:**
The core features of a CMS, you can kind of write with a few developers in a few weeks or something. It's basically CRUD operations, but to replicate those 60,000 plugins and themes, gosh, no one's done it. That's a huge moat. And proprietary services can create platforms. Shopify has a third-party ecosystem and things like that, but it's never a true platform. And a true platform, it's when your ecosystem makes more money than the core does. And so many times, whether it was the Facebook platform, I'm putting that in air quotes, or the Shopify platform, companies build on it and then they get the rug pulled out from under them because they're too successful.

**中文翻译:**
一个 CMS 的核心功能，几个开发人员几周就能写出来，基本上就是增删改查（CRUD）。但要复制那 6 万个插件和主题，天哪，没人能做到。那是巨大的护城河。专有服务也可以创建平台，比如 Shopify 有第三方生态，但它永远不是真正的平台。真正的平台是指你的生态系统赚的钱比核心公司赚的还多。很多时候，无论是 Facebook 平台（我打个引号）还是 Shopify 平台，公司在上面构建业务，然后因为太成功了，就被平台“抽走了地毯”（rug pulled，指平台改变规则导致开发者倒闭）。

---

### [00:38:15] Matt Mullenweg

**English:**
And then the sort of thing you're building on decides, "Oh, we want that money or we want that growth." And they sort of change the API or remove your access. There's so many examples of this, especially on, I think, Facebook and Shopify and others, where people got too successful and all of a sudden they knock on the door and they say, "Oh, that's a mighty nice app you have there. I'd love to offer you some warrants where we own a bunch of your company or we're going to shut it off," or those sorts of things.

**中文翻译:**
然后你所依赖的平台会决定：“哦，我们想要那笔钱或那份增长。”于是他们更改 API 或取消你的访问权限。这种例子太多了，尤其是在 Facebook 和 Shopify 等平台上。当开发者变得太成功时，平台会突然敲门说：“哦，你这个应用真不错，我想让你给我们一些认股权证，让我们占有你公司的一大部分，否则我们就关掉它。”诸如此类。

---

### [00:38:42] Matt Mullenweg

**English:**
And again, you don't have freedom unless you're building on open source. That's why more and more companies and people are choosing... If they're going to build a business on top of something else, if you build it on an open source, you have that guarantee. Even if I grew devil horns and became evil and Automattic decided to know whatever, WordPress would still belong just as much to you as it would to me. People can fork the code. They can still own it. They can still build on top of it. So, those things I think are really important.

**中文翻译:**
再说一次，除非你构建在开源之上，否则你没有自由。这就是为什么越来越多的公司和个人选择……如果你要基于别人的东西建立业务，如果你基于开源构建，你就有了保障。即使我长出了恶魔角，变得邪恶，或者 Automattic 决定做坏事，WordPress 依然既属于你，也属于我。人们可以分叉代码，依然可以拥有它，依然可以在其上构建。我认为这些非常重要。

---

### [00:39:13] Lenny Rachitsky

**English:**
What a segue to all of this drama that's swirling around you these days. I think a lot of people do feel like there's devil horns that have appeared, and so I'm excited to dig into this stuff. I find that every time you go on a podcast these days, if we don't get into this, everyone's just like, "Why is Matt not answering these questions?" Let's get into the hard stuff. So, I'm going to ask you some hard questions. For people that don't know what the hell's going on, they're like, "What are you even talking about?" or just have a sense something is swirling with WordPress and, Matt, I don't know what's going on, what's just like the high level overview of what's going on?

**中文翻译:**
这真是聊到最近围绕你的那些争议的完美过渡。我想很多人确实觉得你已经长出了“恶魔角”，所以我很期待深入探讨这些事。我发现最近你每次上播客，如果我们不聊这个，大家就会说：“为什么马特不回答这些问题？”让我们进入硬核环节。我会问你一些尖锐的问题。对于那些完全不知道发生了什么，只觉得 WordPress 和马特之间出了大事的人，你能给出一个高层级的概览吗？

---

### [00:39:48] Matt Mullenweg

**English:**
So ,to set it, you can get WordPress from WordPress.com or us, but also you can get WordPress from dozens of other hosts. The biggest in the world are like GoDaddy, Hostinger, Newfold. It's not the biggest, but it is in the top 10 or something. It has about 700,000 WordPress installs. There's a company called WP Engine. In 2019, WP Engine started as very WordPress oriented and they contributed a lot to the community and everything like that. They were very respectful about distinguishing themselves from core, so people really realized it wasn't officially associated and everything. But in 2019 they got bought out by a private equity firm called Silver Lake.

**中文翻译:**
背景是这样的：你可以从 WordPress.com 或我们这里获得 WordPress，也可以从几十家其他托管商那里获得。全球最大的托管商包括 GoDaddy、Hostinger、Newfold 等。WP Engine 虽然不是最大的，但也排在前十左右，拥有约 70 万个 WordPress 安装量。WP Engine 最初非常以 WordPress 为导向，对社区贡献很大。他们以前很尊重品牌区分，让人们意识到他们不是官方关联机构。但在 2019 年，他们被私募股权公司银湖（Silver Lake）收购了。

---

### [00:40:45] Matt Mullenweg

**English:**
And anyone who follows business, when private equity buys something, there's some the good ones, but there's also many, many stories about how they can really hollow things out, really optimize our profits, become user hostile. Actually recently read a story where one of the reasons there was a shortage of firetrucks these LA fires was that the fire truck manufacturers have been rolled up by a private equity firm, and they've been raising prices and their supply constraint and things like that. So, there's literally a shortage in firetrucks right now because of private equity. And of course, if you look at healthcare or other things, there's so many examples of where private equity can really, I think, be one of the darker parts of capitalism.

**中文翻译:**
任何关注商业的人都知道，当私募股权（PE）收购一家公司时，虽然有好的案例，但也有很多关于他们如何“掏空”公司、过度优化利润、变得对用户不友好的故事。最近我读到一个故事，洛杉矶火灾中消防车短缺的原因之一是消防车制造商被一家 PE 公司整合了，他们提高价格并限制供应。所以现在因为 PE 的原因，消防车竟然短缺了。当然，看看医疗保健或其他领域，有很多例子表明 PE 可能是资本主义最阴暗的部分之一。

---

### [00:41:36] Matt Mullenweg

**English:**
So, since 2019, WP Engine has kind of changed a bit, and they really stopped contributing to core and they started using the trademark in a way that was very confusing in the marketplace. And particularly in the past year, year and a half or so, we're just getting lot... I get a lot of support for requests for WP Engine. And when we do surveys, we'd find that 20, 30, 40% of people thought they were officially associated because how they were using our logo and presenting the brand and everything like that was very confusing to people. And as you know, if you don't protect a trademark, you lose it.

**中文翻译:**
所以，自 2019 年以来，WP Engine 发生了一些变化。他们停止了对核心代码的贡献，并开始以一种在市场上非常令人困惑的方式使用商标。特别是在过去的一年到一年半里，我收到了大量本该发给 WP Engine 的支持请求。我们的调查发现，20%、30% 甚至 40% 的人认为他们与官方有关联，因为他们使用 Logo 和展示品牌的方式极具误导性。如你所知，如果你不保护商标，你就会失去它。

---

### [00:42:19] Matt Mullenweg

**English:**
And also the version of WordPress that they were offering actually wasn't our core vision of the functionality of WordPress. So to save money, they were actually turning off features like revisions. So, a cool part about WordPress that... actually one of my favorite features, is every change to every single post or page is saved forever, just like Wikipedia. So, if you make a mistake, you can always undo it. And of course, as building a great product, that sort of user safety of an undo is so critical. Now, obviously you have to store these revisions, so it takes up more database space. Now, it's trivial, it's megabytes, so on modern databases is not that big a deal. But to save money, they actually turned us off, so they broke the undo feature in WordPress to essentially save money.

**中文翻译:**
而且，他们提供的 WordPress 版本实际上并不符合我们对 WordPress 功能的核心愿景。为了省钱，他们关闭了“修订版本”（revisions）等功能。WordPress 一个很酷的部分——也是我最喜欢的功能之一——是每一篇文章或页面的每一次修改都会像维基百科一样永久保存。如果你犯了错，总能撤销。对于打造优秀产品来说，这种“撤销”带来的用户安全感至关重要。显然，存储这些修订版本会占用更多数据库空间。虽然现在这只是几兆字节的事，在现代数据库中微不足道，但为了省钱，他们关掉了这个功能，本质上是为了省钱而破坏了 WordPress 的撤销功能。

---

### [00:42:49] Matt Mullenweg

**English:**
And so you have this thing where they're offering something called WordPress. I think I refer to it as a bastardized hacked up version of it. It's diluting our brand, and then also people think it's official. So, even close friends of mine were like, "Oh yeah, I signed up for this thing. I thought I was supporting you." And it's came to a head. So, past 18 months they've also... We contacted them and said, "Hey, you need a trademark license or something if you're going to use this or change how you're doing things," and tried to negotiate something and had many different term sheets over the months offered and different things, and they just kept stretching it out.

**中文翻译:**
所以情况变成了：他们提供一种所谓的 WordPress，我称之为“杂交乱改版”。这在稀释我们的品牌，而且人们认为它是官方的。甚至我的好朋友都会说：“哦，我注册了这个，我以为是在支持你。”事情最终爆发了。在过去的 18 个月里，我们联系了他们，说：“如果你要这样使用商标或改变运作方式，你需要获得商标授权。”我们尝试进行谈判，几个月来提供了许多不同的条款清单，但他们一直在拖延。

---

### [00:43:25] Matt Mullenweg

**English:**
And I was like, "What's going on here?" And I think part of what was going on is last year they tried to sell the company. So, private equity usually holds things for five to seven years, so they were kind of five years into this. They tried to shop it around and sell it. They weren't able to find a buyer. They said, "Well, they don't have any IP, and it feels like they're using your trademark, so they're going to have trouble with you. They don't have a license and things like that." So, while they were negotiating with us, it appears they were also preparing this lawsuit against us.

**中文翻译:**
我想：“这是怎么回事？”我认为部分原因是去年他们试图卖掉公司。PE 通常持有公司 5 到 7 年，他们当时已经持有了 5 年。他们尝试寻找买家，但没找到。买家可能会说：“他们没有任何知识产权，而且看起来在滥用你们的商标，所以他们会和你们产生纠纷，他们没有授权。”所以，当他们和我们谈判时，看起来他们同时也在准备对我们的诉讼。

---

### [00:44:17] Matt Mullenweg

**English:**
And so I also just wasn't prepared for it. I was thinking I was a little naive and kind of didn't realize what was going on for a while. So, it came to a head, and at WordCamp US in September, I was like, "Okay, well, if you're still not going to even agree to negotiate, I'm going to give this presentation about how I think both private equity has messed up a lot of open source projects in the past, and how in particular, [inaudible 00:44:46] has done some very bad or evil things." And they were like, "Okay, go for it." So, I did the presentation. I think it was on a Thursday or a Friday. Kind of spicy. People were like, "Oh, can't believe he did that."

**中文翻译:**
我对此完全没有准备。我当时有点天真，有一段时间没意识到发生了什么。所以事情爆发了，在 9 月份的 WordCamp US 上，我想：“好吧，如果你连谈判都不愿意，那我就要做个演讲，谈谈 PE 过去是如何搞砸很多开源项目的，特别是 WP Engine 做了一些非常糟糕甚至邪恶的事情。”他们说：“好啊，随你便。”于是我做了那个演讲。我记得是在周四或周五。内容挺火爆的，人们都说：“噢，不敢相信他竟然这么做了。”

---

### [00:45:00] Matt Mullenweg

**English:**
And then on Monday they launched this with Quinn Emanuel, which is kind of the baddest, nastiest law firm, it's like who Elon uses when he sues people, launched this big multimillion dollar lawsuit against both me personally and WordPress.org, so the WordPress community and Automattic. And also they're spending millions of dollars a month on both lawyers and PR. So, they're doing... If you read... Oh gosh, who was the celebrity that they were recently talking about this, like dark PR stuff where they're boosting things on social networks? Blake Lively, yeah, yeah.

**中文翻译:**
然后到了周一，他们找了 Quinn Emanuel 律师事务所——那是业内最强悍、最难缠的律所，埃隆·马斯克起诉别人时就用他们——对我个人、WordPress.org（即 WordPress 社区）和 Automattic 发起了耗资数百万美元的大规模诉讼。而且他们每月在律师和公关（PR）上花费数百万美元。他们正在做……就像最近大家讨论的那个名人——布莱克·莱弗利（Blake Lively）——那种在社交网络上推波助澜的“黑公关”（dark PR）。

---

### [00:45:38] Matt Mullenweg

**English:**
So, all that stuff is happening, so there's... And I warned people. I think in the presentation I say, "Hey, there's going to be a smear campaign against me." And internally in the company, I was like, "Hey, they're going to dig up everything that's ever happens. Anything bad anyone's ever said to me is going to all of a sudden become a news item." And that has happened. It's been true. So, right now there is a portion of the internet that does think I have devil horns and everything. Fortunately, this is not my first rodeo. I know a lot of people think like, "Oh, Matt was nice for 20 years, and then got mean." But one thing, if you're really open and open source, sometimes you have to stand up the bullies, and you have to fight to protect your open source ideals.

**中文翻译:**
所有这些都在发生。我曾警告过大家，在演讲中我说：“嘿，将会有一场针对我的抹黑行动。”在公司内部我也说：“他们会挖出过去发生的一切。任何对我评价不好的话都会突然变成新闻。”事实确实如此。所以现在互联网上确实有一部分人认为我长了恶魔角。幸运的是，这并非我第一次经历这种场面。我知道很多人觉得“马特做了 20 年好人，然后变坏了”。但有一点：如果你真的拥护开放和开源，有时你必须挺身对抗霸凌者，必须为了保护开源理想而战斗。

---

### [00:46:19] Matt Mullenweg

**English:**
Otherwise people could take advantage of it in a way that ultimately can destroy everything you've created. So, this is probably the fourth time the internet has decided I'm the main character or really evil. And the previous ones we don't remember anymore. It's Hot Nacho or the Easter Massacre of Themes or these are the things that aren't even on my Wikipedia page anymore, but those seemed like really big deals at the time.

**中文翻译:**
否则，人们会利用开源，最终摧毁你创造的一切。这大概是互联网第四次认定我是“主角”或大反派了。之前的几次大家已经不记得了，比如“Hot Nacho”事件或“主题复活节大屠杀”，这些甚至都没出现在我的维基百科页面上了，但在当时看起来都是天大的事。

---

### [00:46:43] Lenny Rachitsky

**English:**
Those are your incidents. Those weren't like historical battles.

**中文翻译:**
那是你经历的事件，而不是什么历史战役。

---

### [00:46:46] Matt Mullenweg

**English:**
No, no, these are things that, yeah, I was involved in.

**中文翻译:**
不不，这些是我参与其中的事。

---

### [00:46:48] Lenny Rachitsky

**English:**
Cool names at least.

**中文翻译:**
至少名字挺酷的。

---

### [00:46:49] Matt Mullenweg

**English:**
Including some things I had screwed up, like Hot Nacho was definitely a screw-up on my end very early in the WordPress side, but...

**中文翻译:**
包括一些我搞砸了的事，比如 Hot Nacho 绝对是我在 WordPress 早期的一个失误，但是……

---

### [00:46:55] Lenny Rachitsky

**English:**
Wow. Okay, I'm not going to follow those threads, but those are great names. (Ad Segment for Loom)

**中文翻译:**
哇，好吧。我不打算深挖那些事，但名字确实起得好。（此处为 Loom 广告段落，略）

---

### [00:48:00] Lenny Rachitsky

**English:**
So, you mentioned this talk you gave at WordCamp, and you said at the beginning of the talk... oh no, afterwards you were like, "I was really nervous to give this talk," and obviously you can see why. Just what finally convinced you this was time? Was it just to go, as you described, scorched earth nuclear? Was it like WordCamp is coming up and this is the moment to go public with this? Was there something else that kind of crossed the line?

**中文翻译:**
你提到了在 WordCamp 的那个演讲，演讲结束后你说：“做这个演讲我真的很紧张。”显而易见。是什么最终让你确信时机已到？是决定像你描述的那样采取“焦土政策”或“核打击”吗？是因为 WordCamp 刚好要开了，觉得这是公开此事的时机？还是有什么其他事情越过了底线？

---

### [00:48:24] Matt Mullenweg

**English:**
It was a unique opportunity because we were essentially saying that, hey, WP Engine isn't going to be allowed to sponsor WordCamps anymore. They're not going to be a... Because we had, again, up to that point really done everything to bring them in and have to be part of the community. So I really had to also explain to our community, hey, why we're going to be excluding this company that a lot of people saw as doing good. If you go to the WP Engine website, they have whole pages about how much they contribute and give back and how they... they do kind of greenwash or open source wash a lot of what they do. So all their marketing branding was around this positive stuff, and so I was like, "Hey, we need to just explain this case."

**中文翻译:**
这是一个独特的机会，因为我们本质上是在宣布：WP Engine 将不再被允许赞助 WordCamp。因为在那之前，我们真的尽了一切努力让他们融入社区。所以我必须向社区解释，为什么我们要排除这家很多人认为在做贡献的公司。如果你去 WP Engine 官网，他们有整页整页的内容介绍他们贡献了多少、回馈了多少，他们在很大程度上是在进行“开源洗白”。他们所有的营销品牌都围绕着这些正面形象，所以我觉得：“嘿，我们需要解释一下实际情况。”

---

### [00:49:03] Matt Mullenweg

**English:**
But yeah, again, my defaults and how we've worked with, by the way, every other company in the WordPress space, many of which are much, much larger and make sometimes billions more in revenue than WP Engine, is collaborative. So if there's a trademark violation, usually it's not even lawyers get involved. It's just like there's a email, we have a conversation, we do a call, we talk about it. That's how things get resolved and that's my default. I'm a lover, not a fighter, and that's why this thing doesn't happen very often. I like to say that, yes, if WordPress community or whatever was doing this like every year or every couple months, yeah, you should worry about it, but it kind of happens every like 10 years.

**中文翻译:**
但是，我对待 WordPress 领域其他所有公司（其中很多规模比 WP Engine 大得多，收入多出数十亿）的默认方式是协作。如果有商标侵权，通常甚至不需要律师介入。发封邮件，聊一聊，打个电话，事情就解决了。这是我的默认处理方式。我是一个和平主义者，不是好斗之徒，这就是为什么这种事不常发生。我想说，如果 WordPress 社区每年或每几个月就搞这么一出，那你确实该担心；但这种事大概每 10 年才发生一次。

---

### [00:49:46] Lenny Rachitsky

**English:**
So if I could mirror back the issues that you ran into, and I want to go through this a little bit more, the problems you had with WP Engine in this case. One is they were using the trademark both WordPress and WooCommerce without license, and they're just abusing it, confusing people. A lot of people thought WP Engine was actually Automattic and WordPress official. They weren't contributing to the project. They were just making basically a bunch of money and not doing the work off this company they bought and they're just kind of hollowing it out as you described. And then they're also cutting corners, making the product worse, and that kind of reflects on the whole brand of WordPress.

**中文翻译:**
如果我总结一下你遇到的问题（我想再深入探讨一下）：你对 WP Engine 的不满主要有几点。第一，他们在没有授权的情况下使用 WordPress 和 WooCommerce 商标，滥用商标并误导大众，让很多人以为 WP Engine 就是 Automattic 或 WordPress 官方。第二，他们不回馈社区，只是利用买来的公司赚大钱却不干活，正如你所说的“掏空”公司。第三，他们偷工减料，让产品变差，这影响了 WordPress 的整体品牌形象。

---

### [00:50:22] Matt Mullenweg

**English:**
That's a great summary, yeah.

**中文翻译:**
总结得很到位，是的。

---

### [00:50:24] Lenny Rachitsky

**English:**
Awesome. I'm curious just which of those three, or is it something even else that most bothered you about this? What's just like, "This is the thing that's eating me"? If I had to guess, it'd be damaging the legacy potentially of this thing you've worked on for most of your life. Maybe it's that, maybe it's just taking advantage of the community. What's the thing that you think is the root of this, just like, "Just this needs to stop"?

**中文翻译:**
太好了。我很好奇这三点中，或者是否有其他原因，哪一点最让你困扰？哪件事让你觉得“这真的让我寝食难安”？如果让我猜，可能是担心这会破坏你倾注了大半辈子心血的事业。或者是觉得他们在占社区的便宜。你认为这件事的根源是什么，让你觉得“必须停止这一切”？

---

### [00:50:50] Matt Mullenweg

**English:**
Well, I guess the one thing I'd add to your list was as this was happening they were pretending to good faith negotiate. And in fact, at one point the executive, we were talking about her joining Automattic and running WordPress out of Oregon and when she thought... the VP and she going to sell, she was thinking about what was next. So yeah, a lot of this stuff was, I think that duplicitous behavior also kind of forced us to an edge more than even those other things that you mentioned. There's lots of companies that don't contribute back and it's not as big a deal. But yeah, the legal issue was definitely the trademark thing.

**中文翻译:**
我想在你的清单上加一点：在这一切发生时，他们假装在进行诚意谈判。事实上，我们甚至一度在谈论让他们的某位高管加入 Automattic。我认为这种“两面派”的行为比你提到的其他事情更让我们感到被逼到了边缘。有很多公司不回馈社区，那其实没那么严重。但法律层面的核心问题绝对是商标。

---

### [00:51:46] Matt Mullenweg

**English:**
So what pushed it to the edge? I think just the magnitude of the issue. They would refer to themselves as WordPress Engine in client meetings and other things. They were very cavalier about how they would imply their association with the project.

**中文翻译:**
所以是什么把事情推向了边缘？我认为是问题的严重程度。他们在客户会议和其他场合自称“WordPress Engine”。他们对于暗示自己与项目的关联表现得非常随意且不负责任。

---

### [00:51:46] Lenny Rachitsky

**English:**
Obviously, as you can tell on socials, a lot of people are just really upset and a lot of people blame you. There's just, like I said, every time you're on a podcast or on Twitter, people are just like, "Matt, what about this? Why this sucks? Why are you doing this?" And I want to go through some of those things, but just not many people go through... I think you were like a hundred percent beloved hero of open source and internet and now you're in this... a lot of people don't like you. Just as a human, just what is that? How do you work through that? How do you deal with that? What's that been like?

**中文翻译:**
显然，正如你在社交媒体上看到的，很多人非常生气，很多人在指责你。就像我说的，每次你上播客或在推特上，人们都会问：“马特，这件事怎么说？为什么这事这么烂？你为什么要这么做？”我想过一下这些问题。但很少有人经历过这种转变——你曾是开源界百分之百受人爱戴的英雄，而现在深陷泥潭，很多人不喜欢你。作为一个人，你感觉如何？你是如何度过这段时间的？你是如何应对的？那是什么感觉？

---

### [00:52:17] Matt Mullenweg

**English:**
If you were kind of inside baseball with WordPress, it's actually a lot of people who have been unhappy with me over the years, and when we introduced something like Gutenberg, people hated it. Actually when we introduced a visual editor, people hated it.

**中文翻译:**
如果你是 WordPress 的圈内人，其实这些年来一直有很多人对我感到不满。当我们推出 Gutenberg（古腾堡编辑器）时，人们讨厌它。实际上，当我们推出可视化编辑器时，人们也讨厌它。

---

### [00:52:29] Lenny Rachitsky

**English:**
You've had practice.

**中文翻译:**
你已经练出来了。

---

### [00:52:30] Matt Mullenweg

**English:**
These are huge controversies in the WordPress history. There actually hasn't been a fork or WordPress around all this latest stuff, but there was when we introduced Gutenberg. It's one called ClassicPress where people actually forked the software. So how I would describe it is previously like 1% of the world thought I was terrible, and now I feel like it's up to like 4 or 5%. So it's still not the majority, but as you know, something negative you feel seven times more than something positive. And when people are angry with you, it's kind of like restaurant reviews or whatever, they're more likely to leave a bad review than a good review.

**中文翻译:**
这些都是 WordPress 历史上的巨大争议。针对最近这些事，目前还没有出现 WordPress 的分叉，但当我们推出 Gutenberg 时确实出现了，有一个叫 ClassicPress 的项目就是人们分叉出来的。所以我这样描述：以前世界上有 1% 的人觉得我很糟糕，现在我觉得上升到了 4% 或 5%。虽然还不是大多数，但如你所知，负面情绪的影响力是正面的七倍。当人们对你生气时，就像餐厅评论一样，他们更有可能留下差评而不是好评。

---

### [00:53:14] Matt Mullenweg

**English:**
The people who WordPress, 98% of all the core developers have stayed and contribute and are working on the next version and are supportive and all these sorts of things. And part of the reason these folks are so good is they don't spend all their time on Twitter and Reddit arguing with folks, and also the arguments could be... they're very frustrating because people don't engage in good faith. They don't really change their mind when new facts are introduced.

**中文翻译:**
在 WordPress 内部，98% 的核心开发人员都留下来继续贡献，致力于下一个版本，并且非常支持我。这些优秀的人之所以优秀，部分原因在于他们不会整天泡在 Twitter 和 Reddit 上和人争论。而且那些争论非常令人沮丧，因为人们并不是带着诚意参与的，即使有了新事实，他们也不会改变主意。

---

### [00:53:43] Matt Mullenweg

**English:**
And so I've done my best actually because from the open source side I'm really used to engaging with things, and I think that's been one thing I've learned from this is in some forums it doesn't matter how you engage and especially if you have bots or other things running there. I'd leave comments on Reddit and immediately get like 40 downvotes. I'm like, "Hey, this is a article about me and I'm adding a fact to the thing. Why is it getting downvoted? This is very relevant to the discussion." But it's literally hidden. So when you see that thread, you'd have to click like three or four times to see the comment I had left, and so it can really change the perception.

**中文翻译:**
我已经尽力了。因为在开源界，我非常习惯于参与讨论。但我学到的一点是，在某些论坛上，无论你如何参与都没用，特别是当那里有机器人或其他势力在运作时。我在 Reddit 上留言，立刻就会收到 40 个踩（downvotes）。我想：“嘿，这是一篇关于我的文章，我只是在陈述事实，为什么要踩我？这与讨论高度相关。”但我的留言会被直接隐藏。所以当你看到那个帖子时，你得点开三四次才能看到我的评论，这真的会改变人们的认知。

---

### [00:54:36] Lenny Rachitsky

**English:**
100%.

**中文翻译:**
百分之百同意。

---

### [00:54:37] Matt Mullenweg

**English:**
Now the good news is I've had lots of credibility weighted support from people like Marc Benioff or other open source leaders or the core people in WordPress, Matias, Mary Hubbard, all the core committers. The international community actually, like just in Japan, they don't care about this stuff. So these are actually, if you look by number of commits and lines of code and everything like that, the folks who actually are most crucial in WordPress. So I feel like that's been a good balance as well for me because there are days where I'm like, "Gosh, am I an idiot?" or it could be really down reading all these things. So that is part of what allows me to balance and get back to that sort of positive, optimistic space that I think you need to be in to do great software and great work.

**中文翻译:**
好消息是，我得到了很多有分量的支持，比如马克·贝尼奥夫（Marc Benioff）或其他开源领袖，还有 WordPress 的核心成员，如 Matias、Mary Hubbard 以及所有的核心提交者。国际社区其实——比如在日本——他们根本不在乎这些争议。如果你看提交数量和代码行数，这些人才是 WordPress 最关键的人。所以我觉得这对我来说也是一种平衡，因为有些日子我会想：“天哪，我是个白痴吗？”或者读到那些评论会感到很沮丧。这种支持让我能够保持平衡，回到那种积极乐观的状态，我认为这是开发优秀软件和完成伟大工作所必需的。

---

### [00:55:27] Lenny Rachitsky

**English:**
Yeah. The internet can be brutal. Let me go through a couple of specific things that people pointed out because I think you've been on a lot of podcasts and people haven't asked you these questions and I think a lot of people are just like, "But, Matt, what about this? This is really bad." So let me just ask you a couple of things here. One is there's just like a frustration in the community around the instability that this has just caused in the WordPress community. I'll read you a couple quotes. "Real people are receiving fewer projects on WordPress because C-suite are seeing WordPress as unstable because of this feud, and I work at Enterprise and we're very concerned about the stability of this platform and our projects." Just thoughts on that and the impact that it's had on the community.

**中文翻译:**
是的，互联网可能非常残酷。让我过一下人们指出的一些具体问题，因为你上过很多播客，但人们没问过这些，而很多人会想：“但是马特，这件事怎么解释？这真的很糟糕。”首先，社区里有一种挫败感，认为这场争斗导致了 WordPress 社区的不稳定。我读几段话给你听：“现实中，人们接到的 WordPress 项目变少了，因为高管们觉得这场争斗让 WordPress 显得不稳定。”还有：“我在大企业工作，我们非常担心这个平台和我们项目的稳定性。”你对这些看法以及这对社区的影响有什么想法？

---

### [00:56:05] Matt Mullenweg

**English:**
Yeah, I think this is until this gets resolved... which by the way I hope it is soon. I think there's no business reason for this to continue. I really hope that they come to a settlement or something. We're ready. They could end this tomorrow if they wanted to. WP Engine could. We can't. We're just defending right now. So it's really incumbent on them. All of our competitors, by the way, are like, "Great. WordPress, the king on the hill, all of a sudden we can use this." And so there's also not just from WP Engine, but also from all the competitors to WordPress, and all the people who would love to capture some market share, they're really leaning into this.

**中文翻译:**
是的，我认为在问题解决之前……顺便说一下，我希望很快能解决。我认为没有商业理由让这种情况继续下去。我真心希望他们能达成和解。我们已经准备好了。如果 WP Engine 愿意，他们明天就能结束这一切。我们结束不了，我们现在只是在防御。所以这取决于他们。顺便说一下，我们所有的竞争对手都在想：“太好了，WordPress 这个山头之王出事了，我们可以利用这一点。”所以，不仅是 WP Engine，所有的竞争对手和想抢占市场份额的人都在推波助澜。

---

### [00:56:49] Matt Mullenweg

**English:**
We're actually in the next couple of days going to publish something really cool on the WordPress.org blog though that shows if you actually look at the numbers, like the activity, number of commits, plugin updates, downloads, installs of WordPress since September 20th when this all started, it's quite healthy. And so I'm not saying that there isn't examples of where someone lost a project or something like that. I'm sure it's happened. It's the internet's big. WordPress has so many millions of users and developers and everything that you're going to get some example. But by the numbers things are actually quite healthy, and in some ways it's not that there's no press is bad press, it's raised the awareness of WordPress quite a bit. So people who haven't talked about WordPress in years are now like, "Oh, Let's talk about it." And so a little bit of drama I think, I wouldn't do this all the time, but a little bit can be a good thing.

**中文翻译:**
实际上，未来几天我们将在 WordPress.org 博客上发布一些很酷的数据。如果你看实际数字，比如自 9 月 20 日这一切开始以来的活跃度、提交数、插件更新、下载量和安装量，其实非常健康。我不是说没有“某人丢了项目”之类的例子，肯定有，互联网很大，WordPress 有数百万用户和开发者，总能找到例子。但从数据来看，情况非常健康。在某种程度上，这印证了“没有负面新闻就是好新闻”，它极大地提高了 WordPress 的知名度。多年没谈论过 WordPress 的人现在都在说：“噢，让我们聊聊它。”所以我觉得，虽然不能一直这样，但一点点“抓马”（drama）有时是好事。

---

### [00:57:39] Lenny Rachitsky

**English:**
Okay, so one of the most common frustrations I've seen on the internet, people complaining is around the trademark. I don't know all the details, but my understanding is there's kind of a... you moved the trademark to be owned by the foundation and Automattic is exclusive rights to use the trademark. And I think people are like, "Oh, I thought it was the foundation owned it, but maybe Matt still owns it and then you're trying to monetize it through this agreement with WP Engine." Is there anything you can share there that'll make people feel and see your side of the story?

**中文翻译:**
好，我在网上看到最普遍的挫败感之一是关于商标的。我不了解所有细节，但我的理解是：你把商标转让给了基金会，而 Automattic 拥有商标的独家商业使用权。人们会觉得：“哦，我以为是基金会拥有的，但也许马特仍然控制着它，然后你想通过与 WP Engine 的协议来变现。”关于这一点，你有什么可以分享的，让人们看到你那一侧的事实吗？

---

### [00:58:10] Matt Mullenweg

**English:**
Yeah, this is totally fair because it's complicated, but people are saying this has been private. This has all been very public and documented on the internet from the beginning. So WordPress.org has always been me personally, and I think because it's... part of the reason we started there is .com was not available when we started. So that's why we started on the .org and things like that. But I think people also assume .org means nonprofit or something, and that's sometimes true but it's not always. It's not a requirement of the .org domain.

**中文翻译:**
是的，这完全公平，因为确实很复杂。但人们说这是“私下的”，其实这一切从一开始就在互联网上公开记录着。WordPress.org 一直是我个人的。部分原因是我们开始时 .com 域名还不可用，所以我们用了 .org。但人们总假设 .org 就意味着非营利组织，这有时是对的，但并非总是如此，这不是 .org 域名的强制要求。

---

### [00:59:06] Matt Mullenweg

**English:**
Then when I founded Automattic and when we did register the trademark that actually was registered under Automattic. So it used to be, for the first five years of the project or whatever, that Automattic just owned everything outright. And again, I had investors and the board and that was under the control of that. Now, as Automattic became more successful I was able to consolidate some voting rights and other things and at least later advocate. Also remember, I was like 21 when all this was happening, so I was not maybe the most savvy about legal stuff or didn't always have the best advice.

**中文翻译:**
当我创立 Automattic 并注册商标时，它确实是注册在 Automattic 名下的。所以在项目的前五年左右，Automattic 拥有所有权。当时我有投资者和董事会，一切都在他们的控制下。后来随着 Automattic 变得成功，我得以巩固投票权并进行倡导。请记住，这一切发生时我才 21 岁，我对法律事务并不精通，也不总能得到最好的建议。

---

### [00:59:47] Matt Mullenweg

**English:**
So later as I learned more, I was like, "Oh, I want to actually take this out of the company and create a nonprofit." And so we ended up creating a nonprofit. Now the rules around 501(c)(3) nonprofits run the IRS are actually very strict. So that's also something as people assume, it's like, oh, doesn't the nonprofit run the software, and we applied for that originally and it was denied by the IRS. So we actually weren't able to put WordPress.org or the software itself under the nonprofit, but we were able to have sort of an educational purview.

**中文翻译:**
后来随着我了解更多，我想：“我想把商标从公司拿出来，创建一个非营利组织。”于是我们创建了一个。但美国国税局（IRS）关于 501(c)(3) 非营利组织的规定非常严格。人们常假设非营利组织应该运行软件，我们最初也这样申请了，但被 IRS 拒绝了。所以我们实际上无法将 WordPress.org 或软件本身置于非营利组织之下，但我们可以拥有某种“教育职能”。

---

### [01:00:31] Matt Mullenweg

**English:**
So what was eventually approved was sort of running the meetups and other things for WordPress, doing educational stuff. We sponsor a lot of learn to code or running workshops in other countries. We have this cool thing called do_action where we'll do a weekend where we take a bunch of nonprofits and build websites for them and stuff like that. So the nonprofit does a lot of exciting things there and then also negotiated with the investors and everyone at Automattic to actually put the trademark under the foundation.

**中文翻译:**
最终获批的是运行 WordPress 的线下聚会、开展教育活动等。我们赞助了很多编程学习项目或在其他国家举办工作坊。我们还有一个叫 do_action 的活动，利用周末为一群非营利组织建立网站。所以非营利组织做了很多令人兴奋的事。随后，我与 Automattic 的投资者和所有人协商，将商标正式置于基金会名下。

---

### [01:00:31] Matt Mullenweg

**English:**
Now the compromise there was that Automattic at this point is running WordPress.com. So to continue running that, which at the time had already tens of millions of users and everything, it needed a commercial license. And so the compromise is that the foundation would kind of own the trademark and license it out for non-commercial purposes. I had a license to run WordPress.org because obviously I need that. And then Automattic would retain the commercial license and the ability to sub-license that, so to sell that to others. So this was kind of the grand compromise and create this tripartite structure. I was very inspired by the three branches of government. So there's sort of power in each of those that I think sort of checks and balances each side of it which is on purpose.

**中文翻译:**
当时的妥协是：Automattic 正在运行 WordPress.com，为了继续运行这个已经拥有数千万用户的业务，它需要商业许可。所以妥协方案是：基金会拥有商标，并将其授权用于非商业目的；我拥有运行 WordPress.org 的许可（因为我显然需要它）；而 Automattic 保留商业许可及转授权（sub-license）给他人的权利。这就是那个“大妥协”，并创造了这个三方结构。我深受政府“三权分立”的启发，每一方都有权力，从而实现相互制衡，这是有意为之的。

---

### [01:01:23] Lenny Rachitsky

**English:**
Wow. Okay, I get why it's complicated. I get why people would be confused. This makes me think about OpenAI had a really strange structure and that got them in a lot of trouble, and it feels like when you're 21 you're like, "Oh, this makes a lot of sense. What a great concept we've come up here," and then all this complexity just adds to a lot of confusion around what's going on. So thank you for addressing that. Another, there's a kind of related question I've seen a couple of times is just why don't you let that .org be run by a community. Why not just give that up to someone else and not just you that's there?

**中文翻译:**
哇，好吧。我明白为什么这很复杂了，也明白为什么人们会困惑。这让我想起 OpenAI 也有一个非常奇怪的结构，这给他们带来了很多麻烦。感觉当你 21 岁时，你会觉得：“哦，这太有道理了，我们想出了一个多么伟大的概念。”但这些复杂性只会增加人们对现状的困惑。谢谢你的解释。还有一个相关的问题我见过几次：为什么不让 .org 由社区运行？为什么不把它交给别人，而不仅仅是你一个人在那里？

---

### [01:01:53] Matt Mullenweg

**English:**
Yeah, and the frame of that question is kind of interesting because it implies I'm the only person making WordPress which is obviously not true. If you look at the daily commits and activity and everything, it is run by the community. So it's hundreds of volunteers every day that are actually doing the day-to-day work and making the daily decisions and everything happens. So there has been a radical delegation. However, there's ultimately a hierarchy, and I'm the CEO, so I'm like the final final decision-maker.

**中文翻译:**
是的，这个问题的框架很有趣，因为它暗示我是唯一一个在做 WordPress 的人，这显然不是事实。如果你看每天的提交（commits）和活跃度，它确实是由社区运行的。每天有数百名志愿者在做日常工作，做日常决策。所以已经有了彻底的授权。然而，最终还是存在层级结构，我是 CEO，所以我相当于最终的决策者。

---

### [01:02:24] Matt Mullenweg

**English:**
And so I think what people advocate for around this governance point of view is like, okay, well, install a board on top of you that ultimately makes decisions for the product or things like that. And there are other open source projects that have this structure. None of them have been successful as WordPress. So I think your audience in particular, is great software ever created by committee or does it more often reflects a vision of a leader or something that can allow us to... and I think particularly WordPress not just remaining relevant but actually accelerating growth over huge technological shifts over the past two decades.

**中文翻译:**
我认为人们倡导的治理观点是：好吧，在你上面设一个董事会，由他们最终决定产品方向。确实有其他开源项目采用这种结构，但没有一个像 WordPress 这样成功。我想问你的听众：伟大的软件是由委员会创造出来的吗？还是它更多地反映了一个领导者的愿景？正是这种愿景让我们在过去二十年的巨大技术变革中，不仅保持了相关性，还加速了增长。

---

### [01:03:12] Matt Mullenweg

**English:**
When we started there was dynamic web apps or DHTML or JavaScript wasn't really a thing, and then the social web and then iPhones and then all this sort of stuff that's changed over time, and we've surfed a lot of these technological changes which is very, very hard to do. Most products do not remain relevant over multiple generational changes like that, and that's been because sometimes we've had to make very unpopular decisions. Gutenberg is a huge part of why WordPress is relevant today, and it's actually an open source project we do. It's the block editor. It's actually bigger than WordPress because it's not just used on WordPress, it's used on every WordPress site, but also like Tumblr, other people. I would actually love if Squarespace or Wix adopted Gutenberg. It's meant to be like a really open source framework.

**中文翻译:**
我们刚开始时，动态网页应用、DHTML 或 JavaScript 还不是主流，后来经历了社交网络、iPhone 兴起等一系列变革。我们成功冲过了这些技术浪潮，这非常难。大多数产品无法在多代技术更迭中保持地位，而我们做到了，是因为有时我们必须做出非常不受欢迎的决定。Gutenberg 是 WordPress 至今仍保持领先的重要原因。它其实是我们做的一个开源项目，即块编辑器（block editor）。它的影响力甚至超过了 WordPress 本身，因为它不仅用于 WordPress 站点，还用于 Tumblr 等。我甚至希望 Squarespace 或 Wix 也能采用 Gutenberg，它本就该是一个真正的开源框架。

---

### [01:03:56] Matt Mullenweg

**English:**
But anyway, if we had voted for whether we should do that or not, everyone would've voted against it or the majority would have. It was really a few core people of us in the community, Matias, myself, other core contributors, Ella, Andrew Ozz, that said, "Hey, this is the future and it's going to take 10 years to do and it's going to be a long bet. It's going to suck for the first three or four years, and so everyone's going to hate it in the beginning."

**中文翻译:**
但无论如何，如果我们当时投票决定是否要做 Gutenberg，绝大多数人都会投反对票。当时只有社区里的几个核心成员——Matias、我、Ella、Andrew Ozz 等人——说：“嘿，这就是未来，这需要 10 年时间，这是一场长线赌博。前三四年会很糟糕，所以一开始大家都会讨厌它。”

---

### [01:04:20] Matt Mullenweg

**English:**
But then later with iteration, we've had I think now 200 releases of Gutenberg. We do sort of a very strict every two weeks release schedule since it started. It's going to get pretty good, and it's at that point now where it's actually getting pretty darn good. And the next phase of it, actually I'm so excited about, it's going to be collaboration. So all the real time co-editing like Google Docs and Notion has, it's coming out to this open source thing, and with the technological changes, we're actually able to do it peer-to-peer. So we don't need a centralized server. We can use WebRTC and other cool technologies.

**中文翻译:**
但后来经过迭代——我想 Gutenberg 现在已经发布了 200 个版本，我们从一开始就坚持每两周发布一次的严格进度——它变得越来越好，现在已经非常出色了。下一阶段我非常兴奋，那就是“协作”。像 Google Docs 和 Notion 那样的实时共同编辑功能将引入这个开源项目。而且由于技术进步，我们实际上可以实现点对点（P2P）协作，不需要中心化服务器，我们可以使用 WebRTC 等酷炫技术。

---

### [01:05:34] Matt Mullenweg

**English:**
I mean, anyway, I'm going sidelining, but I think that sort of more... and if you look at a lot of great companies, there's a board or whatever but ultimately there's an executive, and some of the most iconic companies of our generations are ones where the executive retains some majority of voting control or other things like that which I've been able to do with Automattic and with WordPress. And I definitely think about succession planning and everything like that, but if or when I'm gone I don't want to pass it to a committee. I want to pass it to someone else who can have a role similar to mine and really sort of try to be a steward.

**中文翻译:**
总之，我有点扯远了，但我想说……如果你看很多伟大的公司，虽然有董事会，但最终还是由一名高管掌舵。我们这一代一些最具标志性的公司，都是高管保留了大部分投票控制权的公司，我在 Automattic 和 WordPress 也是这么做的。我当然会考虑继任计划，但如果有一天我不在了，我不想把它交给一个委员会。我想把它交给另一个能扮演类似角色、真正努力成为一名“管家”的人。

---

### [01:05:34] Matt Mullenweg

**English:**
There ultimately is a check and balance on that because, again, the community could leave. They could fork the software. People could change. And so you're "in charge" quote, unquote, but you're also at surface. So it's a lot more being like a mayor than a CEO and that you ultimately are accountable to the folks who are contributing and new users and everything like that. So I do feel like there is a balance there. Some of this as well is that there's some people who aren't part of leadership who feel like they should be. So if you look at the Yoast or Korean things, these are folks who actually don't have commit status. They haven't contributed WordPress over the years and serve our normal hierarchy of the meritocracy of how you get the ability to commit code or things like that. They're like, "Hey, I want to lead a release." That's cool, dude, but there's a process. We have different people lead releases over the years, but they kind of worked their way up to it.

**中文翻译:**
最终还是有制衡的，因为社区可以离开，可以分叉软件，人们可以改变选择。所以你虽然是所谓的“掌权者”，但你也是在服务。这更像是一个市长而不是 CEO，你最终要对贡献者、新用户等所有人负责。所以我确实觉得这里有一种平衡。此外，有些不在领导层的人觉得自己应该在。比如 Yoast 或其他一些人，他们其实没有提交权限（commit status），多年来没有按照我们的技术官僚（meritocracy）层级进行贡献。他们会说：“嘿，我想领导一个版本的发布。”这很酷，伙计，但得按流程来。多年来我们有不同的人领导发布，但他们都是一步步做上来的。

---

### [01:06:28] Lenny Rachitsky

**English:**
This makes so much sense to me. That's one of the themes of the podcast, just the power of a singular visionary and leader, founder mode as we've all heard is trending these days.

**中文翻译:**
这对我来说非常有道理。这也是本播客的主题之一，即单一愿景领导者的力量，也就是最近很流行的“创始人模式”（founder mode）。

---

### [01:06:38] Matt Mullenweg

**English:**
You made famous, yeah.

**中文翻译:**
是你把它带火的，没错。

---

### [01:06:40] Lenny Rachitsky

**English:**
I wouldn't say that it was. Yeah, Brian shared it, but then Paul Graham pointed afterwards and then I renamed the title of that episode Founder Mode to [inaudible 01:06:49]

**中文翻译:**
我不敢居功。是布莱恩（切斯基）分享的，然后保罗·格雷厄姆写了文章，接着我把那一集的名字改成了“创始人模式”。

---

### [01:06:50] Lenny Rachitsky

**English:**
If I zoom out, what I'm sensing here is there's people that have this ideal of how something like this should run, but they've never actually worked at a place where a nonprofit board runs it, runs a thing, and have seen what that actually looks like. And so I think there's a big disconnect between the ideal in theory and how does great stuff get built.

**中文翻译:**
如果我跳出来看，我感觉到有些人对这类事情的运作方式有一种理想化的期待，但他们从未真正在一个由非营利董事会管理的地方工作过，没见过那到底是什么样子的。所以我认为，理论上的理想与“伟大的东西是如何被制造出来的”之间存在巨大的脱节。

---

### [01:07:11] Matt Mullenweg

**English:**
And one of the things I think we've tried to demonstrate with WordPress is actually it's kind of like a open source side and a nonprofit side and a for-profit working in concert. And one of the things people don't necessarily appreciate as much about why WordPress has been so successful is because of Automattic and things like Akismet doing anti-spam or WordPress.com having a free version of WordPress that is introduced over a hundred million people to the software in a way that you could just sign up for free. You don't have to pay for hosting or download it yourself or things like that.

**中文翻译:**
我们试图通过 WordPress 证明的是，开源端、非营利端和营利端是可以协同工作的。人们可能没有充分意识到 WordPress 如此成功的原因之一是 Automattic 的存在——比如 Akismet 处理垃圾邮件，或者 WordPress.com 提供免费版，让超过一亿人通过简单的免费注册就能接触到这个软件，而不需要支付托管费或自己下载安装。

---

### [01:07:43] Matt Mullenweg

**English:**
So that kind of for-profit, nonprofit, open source, working in concert I think is a really interesting model that we're starting to see a lot more companies do. It's actually very exciting to me that some of the things that were controversial when we started open source or distributed work are now the default for so many exciting new startups, and this whole ecosystems of really, really cool open source, like Cal.com for open source Calendly. There's so much cool stuff out there that actually there's a whole generation of younger entrepreneurs that I find very, very inspiring because they're also bringing modern design and web development and everything to open source which is very neat.

**中文翻译:**
这种营利、非营利和开源协同工作的模式是一个非常有趣的模型，我们现在看到越来越多的公司在效仿。让我非常兴奋的是，我们刚开始做开源或分布式工作时那些备受争议的做法，现在成了许多初创公司的默认选择。还有整个酷炫的开源生态系统，比如开源版 Calendly 的 Cal.com。现在有这么多酷东西，新一代年轻创业者让我深受启发，因为他们把现代设计和网页开发带入了开源领域，这非常棒。

---

### [01:08:21] Lenny Rachitsky

**English:**
I anticipate a blog post one day, "I told you so, guys." Open source, remote work, I imagine there's a few more things there. There's one other thing I want to address. I haven't seen you talk about this. It comes up a bunch. It's around, this is very the weeds, but I think it's really important to people, and there's something here for a lot of people, the way you guys forked Advanced Custom Fields. So I think what happened here is you guys forked an existing plugin, I think somebody else's plugin, and then kind of pushed people to this plugin versus the original plugin. What can you share there?

**中文翻译:**
我预感到有一天你会发篇博文说：“伙计们，我早就告诉过你们了。”开源、远程办公，估计还有不少。还有一件事我想提一下，我没见你谈过，但它经常被提起。这非常细节（very the weeds），但我觉得对人们很重要：关于你们分叉 Advanced Custom Fields（ACF）插件的方式。据我所知，你们分叉了一个现有的插件（别人的插件），然后引导用户使用这个分叉版本而不是原版。关于这一点你能分享些什么吗？

---

### [01:08:55] Matt Mullenweg

**English:**
Yeah, this is very complex. So WordPress.org has kind of like a app store. After WP Engine started suing us, creating millions of dollars of legal fees and things, we blocked their access to WordPress.org. So this plugin they had, Advanced Custom Fields, wasn't able to be updated. At the same time a number of security issues were found in it, including some we reported, and so there had to be an update to it. So we're like, "Okay, we'll ship the update for you essentially." And then we were like, "Okay, I think we need to call it something different because it actually isn't theirs anymore."

**中文翻译:**
是的，这非常复杂。WordPress.org 有点像应用商店。在 WP Engine 开始起诉我们、产生数百万美元法律费用后，我们阻止了他们访问 WordPress.org。因此，他们拥有的这个插件 ACF 无法更新。与此同时，该插件被发现了一些安全问题（包括我们报告的一些），所以必须进行更新。于是我们想：“好吧，我们来帮你们发布这个更新。”接着我们觉得：“好吧，我们需要给它起个不同的名字，因为它实际上不再属于他们了。”

---

### [01:10:04] Matt Mullenweg

**English:**
And they still offer Advanced Custom Fields on their own and people can download it from them, et cetera. So we made Secure Custom Fields which was originally under the same directory listing, so again, because we want all the users of it to get the security updates. This is controversial, and actually they actually got a preliminary injunction, so the judge said "Reverse this." So this has all been reversed by the way. There now is a separate fork under separate listing of Secure Custom Fields which actually we have a team on it, developers, designers, and we're creating... just like WordPress was a fork, we've actually forged this. Actually WooCommerce was a forge. A lot of things are forks. So we forked it and now have a new name, new everything that we're doing a lot of product innovation and improving it.

**中文翻译:**
他们仍然在自己的渠道提供 ACF，人们可以从他们那里下载。所以我们制作了 Secure Custom Fields（SCF），最初放在同一个目录列表下，因为我们希望所有用户都能获得安全更新。这很有争议，实际上他们获得了一个初步禁令，法官说“撤销这个操作”。顺便说一下，现在这一切都已撤销。现在 SCF 是一个独立列表下的独立分叉，我们有一个专门的团队（开发、设计）在负责。就像 WordPress 本身是一个分叉一样，我们也分叉了它。实际上 WooCommerce 也是分叉出来的。很多东西都是分叉。所以我们分叉了它，现在有了新名字和新的一切，我们正在进行大量产品创新和改进。

---

### [01:10:46] Lenny Rachitsky

**English:**
So I'm hearing essentially you blocked WP Engine as a part of this, we're just going to simplify WordPress, reduce confusion. They're being bad actors in the space, so we're going to block them, and in that block, there's like a dependency where people couldn't do a thing that they needed to do. So you're like, "And the one that exists, there's a problem with it, so we're going to make that dependence... release a version that you can actually use and fix the security issues."

**中文翻译:**
所以我听到的本质是：作为简化 WordPress、减少困惑行动的一部分，你们屏蔽了 WP Engine。因为他们是这个领域的“坏人”，所以你们屏蔽了他们。但在屏蔽过程中产生了一个依赖问题，导致用户无法完成必要的操作。于是你想：“现有的那个有问题，所以我们要发布一个你可以实际使用并修复了安全问题的版本。”

---

### [01:11:09] Matt Mullenweg

**English:**
That was the intention. I think that there was a lot of perceptions around it that were different, but yeah, that was the goal.

**中文翻译:**
那是初衷。虽然外界对此有很多不同的看法，但那确实是目标。

---

### [01:11:14] Lenny Rachitsky

**English:**
Okay. Okay. Great. So maybe just the last question. We talked about just a lot of people see you with devil horns these days. They think you're doing bad things and they don't like the approach you're taking. You talked about there's this WP Engine spending a lot of money on PR and hiring this agency. I guess is there anything else that... why do you think so many people are looking at you as the bad guy? Is it mostly that you think... just where do you think it's coming from? Why are comments always so negative? And we talked a bit about it, but anything more there?

**中文翻译:**
好的。最后一个问题。我们谈到很多人现在觉得你长了恶魔角，认为你在做坏事，不喜欢你的做法。你提到 WP Engine 花了很多钱请公关公司。你认为为什么会有这么多人把你当成坏人？你觉得这种情绪主要源自哪里？为什么评论总是那么负面？我们聊过一点，还有什么补充吗？

---

### [01:11:46] Matt Mullenweg

**English:**
I don't know if I can say why. I do think one thing I've learned is that a lot of these things we've talked about are nuanced. So one essentially thing I've learned in this process is that it's hard to explain this stuff in 240 characters or the... 240 characters. Some mediums do not lend themselves well to discussing this. And so I tried, but I'm participating less in Reddit or Twitter and trying to do more long form things like this, where you can actually have the context and things can't be taken out of context.

**中文翻译:**
我不知道该怎么解释原因。但我学到的一点是，我们讨论的很多事情都非常微妙（nuanced）。在这个过程中我学到的核心一点是：很难用 240 个字符（推特字数限制）来解释这些事。有些媒介根本不适合讨论这种话题。所以我尝试减少在 Reddit 或 Twitter 上的参与，转而做更多像这样长形式的内容，在这里你可以拥有完整的上下文，事情不会被断章取义。

---

### [01:12:53] Matt Mullenweg

**English:**
Also, I think there's something where social networks sometimes are tuned to promote outrage. And it was very interesting. We ran a sentiment analysis recently. We were kind of looking at different social networks, analyzing all the comments, and we found, actually, that the negative, the sort of devil horn fraction on, what was it, like LinkedIn, Facebook, Instagram was like 8%. It's actually pretty small. On Reddit, it was bigger, I forget the exact number, but on Twitter it was 52%. You're like, whoa, what's going on there?

**中文翻译:**
此外，我认为社交网络有时被调整为专门推广“愤怒”。这很有趣，我们最近做了一个情感分析，分析了不同社交网络上的评论。我们发现，在 LinkedIn、Facebook 和 Instagram 上，负面或“恶魔角”言论的比例只有 8% 左右，其实很小。在 Reddit 上比例更高（我忘了具体数字），但在 Twitter 上竟然高达 52%。你会觉得：“哇，那里到底发生了什么？”

---

### [01:13:30] Matt Mullenweg

**English:**
And so there's something in the algorithm, and again, we can't see how the algorithm works or what the incentives are, but it can promote the most controversial things. I think that's not a novel perception. There's a lot of discussion around how social media might be creating more fragmentation in society, and I think this is just an example of that, where when you have networks, when people are getting the majority of the information from social networks, and those networks are not designed to provide nuance or balance, or even promote truth necessarily, misinformation can get spread far more than... What's the saying? Like a lie gets around the world seven times before truth has time to... Get out of bed, yeah.

**中文翻译:**
所以算法里肯定有些东西——虽然我们看不见算法如何运作或其激励机制是什么——但它会推广最具争议的内容。这并非什么新颖的见解，关于社交媒体如何导致社会碎片化的讨论已经很多了。我认为这就是一个例子：当人们从社交网络获取大部分信息，而这些网络并非为了提供微妙平衡的观点、甚至不一定是为了推广真相而设计时，误报的传播速度会快得多。就像那句话说的：谎言绕世界跑了七圈时，真相才刚刚……起床，是的。

---

### [01:14:15] Matt Mullenweg

**English:**
There's actually been a lot of misinformation, untrue things that go viral, and then the untrue thing gets like 700,000 views, and the correction gets like 20,000 views. So there's been some of that happening. When mainstream media has covered this, it's actually been a lot better. So there's been some actually really good articles in some business publications and other things that sort of look at a more nuanced and balanced view. And I think the podcast have been pretty good, but definitely on Twitter, I think you can get a version of all of this that is both, I think, not entirely true and also pretty more negative.

**中文翻译:**
实际上有很多误导信息和不实之词在疯传，不实消息可能有 70 万次观看，而澄清声明只有 2 万次。这种情况一直在发生。当主流媒体报道此事时，情况其实好得多。一些商业刊物发表了非常不错的文章，提供了更微妙、更平衡的视角。我认为播客的表现也不错。但在 Twitter 上，你看到的版本既不完全真实，又极其负面。

---

### [01:15:15] Matt Mullenweg

**English:**
Well, if people have more questions, they can come to WordCamp Asia. We're going to do an open Q&A there. We do town halls in the WordPress.org Community. There's a Slack people can get on and ask questions. So there is kind of a lot of open ways to engage, and I'm definitely happy to do that. I'm probably not going to do it on Twitter as much, but when there's longer form opportunities to have a discussion here, particularly if it's more like real time, like this, I'm very happy to.

**中文翻译:**
如果人们还有更多问题，可以来参加 WordCamp Asia，我们会在那里进行公开问答。我们在 WordPress.org 社区也有市政厅会议。还有一个 Slack 频道，人们可以加入并提问。所以有很多公开的参与方式，我非常乐意这样做。我可能不会在 Twitter 上说太多，但如果有像这样长篇讨论的机会，特别是像这种实时的交流，我非常乐意。

---

### [01:15:43] Matt Mullenweg

**English:**
And that's why if you look at it, there's actually a big difference. WP Engine has not done any podcasts and no press. They don't respond to journalists, they don't talk about this. And I've done the opposite, where I'm really trying to be out there and engaged. And everyone's like, "Why don't you just let the lawyers do the talking?" And it's like, well, but we have community, and also I feel like we're in the right. So when you're in the wrong, you probably say only have the lawyers talk. When you're in the right, I think you should be out there and telling the story.

**中文翻译:**
这就是为什么如果你观察一下，会发现巨大的差异。WP Engine 没有参加任何播客，也没有接受媒体采访。他们不回应记者，也不谈论这件事。而我恰恰相反，我努力站出来参与其中。大家都说：“你为什么不让律师去说？”我想说，因为我们有社区，而且我觉得我们占理。当你理亏时，你可能只想让律师说话；当你占理时，我认为你应该站出来讲述真相。

---

### [01:16:10] Lenny Rachitsky

**English:**
I remember at the end of your WordCamp talk, you were like, "Any questions?" after this big controversial talk, and I'm curious how it felt. All the questions initially were nothing to do with this. It's what it felt like. You're just like, oh, they already had these questions. They didn't even know what you said maybe, and I bet you're just like, wait, did anyone hear what I just said? Did it feel like that?

**中文翻译:**
我记得在 WordCamp 演讲结束时，在那个极具争议的演讲之后，你问：“有什么问题吗？”我很好奇当时的感觉。最初的所有问题都与此无关。感觉就像是，哦，他们早就准备好了这些问题，甚至可能根本没听你刚才说了什么。我打赌你当时一定在想：等等，有人听到我刚才说的话了吗？是那种感觉吗？

---

### [01:16:28] Matt Mullenweg

**English:**
Well, also, that's really like a WordPress community event, so it's a lot of the core developers and things, so they have WordPress questions, so that is something. I've now done hundreds and hundreds of these town halls and QAs, and I really enjoy it because you never know what's going to come up.

**中文翻译:**
嗯，毕竟那是 WordPress 社区活动，现场有很多核心开发者，所以他们有关于 WordPress 的技术问题，这很正常。我已经做过成百上千次这样的市政厅会议和问答了，我真的很享受，因为你永远不知道会冒出什么问题。

---

### [01:16:42] Lenny Rachitsky

**English:**
Yeah, okay. I want to talk about all the companies that you bought and will buy in the future. It's kind of like you're building a little Berkshire Hathaway. I think you've described it that way. It's kind of what it's feeling like. And Tumblr is really interesting. Until I started prepping for this, I didn't even know you guys own Tumblr. I haven't heard this story. Why did you guys buy Tumblr? What is going on with Tumblr? It was like a big deal back in the day. What is the current state of Tumblr? What is the story there?

**中文翻译:**
好，我想聊聊你已经收购以及未来将要收购的公司。感觉你正在建立一个“小伯克希尔·哈撒韦”。我想你也曾这样描述过。Tumblr 真的很有趣。在我准备这次采访前，我甚至不知道你们拥有 Tumblr。我没听过这段故事。你们为什么要买 Tumblr？Tumblr 现在怎么样了？它当年可是件大事。Tumblr 的现状如何？背后的故事是什么？

---

### [01:17:10] Matt Mullenweg

**English:**
Oh, Tumblr is so interesting. At the time, I think it was one of our best competitors. They created this really amazing sort of hybrid of blogging and social networking. And if you kind of zoom back, a lot of things that are now standard on other social networks, even the ability to embed an image with a post, again, it was not supported originally on Twitter and other things. Remember they used to have, what was it, like tweet image, or you have to linked out to other things to post an image to Twitter. It wasn't native functionality, and Tumblr had these multiple post types. You could post a chat, an image. They were, I think, one of the first to support video, so they did a lot of, I think, product innovation under the leadership of David Karp, who's a really amazing entrepreneur and product leader.

**中文翻译:**
噢，Tumblr 太有趣了。当时我认为它是我们最强的竞争对手之一。他们创造了这种博客和社交网络的奇妙混合体。如果你回过头看，现在其他社交网络上的很多标准功能——甚至是在帖子中嵌入图片——最初在 Twitter 等平台上是不支持的。记得以前在 Twitter 发图得用第三方链接吗？那不是原生功能。而 Tumblr 有多种帖子类型：聊天、图片，他们还是最早支持视频的平台之一。在创始人大卫·卡普（David Karp，一位了不起的创业者和产品领袖）的领导下，他们做了很多产品创新。

---

### [01:17:54] Matt Mullenweg

**English:**
Funny story, both David and I were at CNET at the same time. They had hired both of us.

**中文翻译:**
有趣的是，大卫和我曾同时在 CNET 工作，他们当时把我们两个都招进去了。

---

### [01:17:59] Lenny Rachitsky

**English:**
What an alumni group at CNET.

**中文翻译:**
CNET 的校友录真是星光熠熠。

---

### [01:18:02] Matt Mullenweg

**English:**
They could have kept both of us probably. But anyway, the Tumblr, I forget the year, but they sold, I think the same time that Instagram did, for a similar amount, $1.1 billion. Instagram bought by Facebook, obviously. And Tumblr bought by Yahoo. Who was at the time, again, Yahoo, we don't think about it now, but I feel a little old. But at the time, Yahoo was one of the internet giants and had recently Marissa Mayer, who was one of the big early people at Google, I think part of creating the API program and everything like that, was the CEO of Yahoo. This was, I think, one of her first big acquisitions.

**中文翻译:**
他们本来可以把我们两个都留下的。总之，Tumblr 在我忘了哪一年卖掉了，大概和 Instagram 卖掉的时间差不多，价格也相似，11 亿美元。Instagram 被 Facebook 买了，而 Tumblr 被雅虎买了。当时的雅虎还是互联网巨头（现在提起来感觉我老了）。当时雅虎的 CEO 是玛丽莎·梅耶尔（Marissa Mayer），她是谷歌早期的核心人物。我想这是她上任后的第一笔重大收购。

---

### [01:18:46] Matt Mullenweg

**English:**
Now subsequently, obviously ,we know how Instagram went. I think people were like, "I can't believe you bought this for a billion dollars." And obviously now it's worth hundreds of billions. So that's had a really good trajectory. At Yahoo, things became more challenged. So again, this is a little bit of history, but Yahoo then had this thing where they owned part of Alibaba, which then became more valuable than the rest of the company. They had activist investors. I think they had some CEO switches. I think Marissa Mayer leaves or gets fired at some point. There's all this turnover, and I think Tumblr really languished under their ownership.

**中文翻译:**
随后，我们都知道 Instagram 发展得如何。当时人们说：“不敢相信你花 10 亿买这个。”现在它值几千亿。所以它的轨迹非常好。但在雅虎，情况变得困难。雅虎当时持有阿里巴巴的股份，结果那部分股份比公司其他部分加起来还值钱。他们面临激进投资者，CEO 频繁更替，玛丽莎·梅耶尔后来也离开了。在频繁的人事变动中，Tumblr 在他们手里逐渐凋零。

---

### [01:19:43] Lenny Rachitsky

**English:**
Tumbling along.

**中文翻译:**
跌跌撞撞（Tumbling along，双关语）。

---

### [01:19:45] Matt Mullenweg

**English:**
Tumbling along. And then that gets bought by Verizon. So fast-forward to 2019. Verizon wants to get rid of Tumblr. And so they're kind of putting it up for sale and had a number of bidders. Automattic ended up buying it for a de minimis amount. I think it's been reported we bought it for $3 million.

**中文翻译:**
跌跌撞撞。然后它被 Verizon 收购了。快进到 2019 年，Verizon 想甩掉 Tumblr。他们把它挂牌出售，有很多竞标者。Automattic 最终以极低的价格买下了它。据报道，我们只花了 300 万美元。

---

### [01:20:10] Lenny Rachitsky

**English:**
What a deal. 3 million.

**中文翻译:**
真划算，300 万。

---

### [01:20:14] Matt Mullenweg

**English:**
But obviously, that represented a lot of value destruction over the years. Tumblr had had some tough times. They actually were banned from the App Store at one point for not moderating things well enough and having maybe a little too much porn. Obviously, Twitter [inaudible 01:20:31] porn. They maybe were a little too out there with it, and we're doing a good job filtering it and keeping away from App Store reviewers or whatever. And so Verizon, to their credit though, there were people bidding more. Actually I think a porn company was bidding on Tumblr that would've paid a lot more money. They really were looking for an acquirer that they felt like would be a good steward.

**中文翻译:**
但显然，这代表了多年来巨大的价值流失。Tumblr 经历过艰难时期。他们曾因为内容审核不力、色情内容过多而被应用商店下架。显然 Twitter 也有色情内容，但 Tumblr 可能表现得太露骨了，而且没能做好过滤。Verizon 值得称赞的一点是，当时有人出价更高——我想是一家色情公司，他们愿意付更多钱。但 Verizon 真的在寻找一个他们认为能成为“好管家”的收购者。

---

### [01:21:14] Matt Mullenweg

**English:**
From my point of view, I had such incredible respect for Tumblr as a product. And the community, still, despite all of this sort of stuff that had happened, I think at that point still was like, I forget the exact number, but call it 15, 20 million monthly active users. So really, sort of active core. And one of the things that's so fascinating is over half of that user base was under the age of 25. And actually had a huge, I think, it was like 25 or 30% LGBT+. I think a very unique place on the internet, where people could have a social network where they could be anonymous, they could put on different identities, they could be someplace their parents weren't, like Facebook or Instagram, really still could take a special spot.

**中文翻译:**
在我看来，我对 Tumblr 作为一个产品有着极大的尊重。尽管发生了这么多事，当时的社区依然拥有——我忘了确切数字，大概 1,500 万到 2,000 万月活跃用户。这是一个非常活跃的核心群体。最迷人的一点是，超过一半的用户年龄在 25 岁以下，而且有很大比例（约 25-30%）是 LGBT+ 群体。我认为它是互联网上一个非常独特的地方，人们可以匿名，可以拥有不同的身份，可以待在一个父母不在的地方（不像 Facebook 或 Instagram）。它依然占据着一个特殊的位置。

---

### [01:22:01] Matt Mullenweg

**English:**
So we ended up buying it. Now, people are like, "Oh, you bought it for $3 million." But we bought it sort of taking on all liabilities, including, I think they were under investigation by the FTC, there were lawsuits. There was all this sort of stuff. So it was free like a puppy, not free like... free like beer. Had a pretty big team, I think 185 people. We were taking a lot of burners, burning a ton of cash, and that was 2019. And so, it's been, I think, a humbling experience running a social network. It was very, very different from all the other products that we've done.

**中文翻译:**
所以我们买下了它。人们说：“哦，你只花了 300 万。”但我们买下它时承担了所有债务和责任，包括 FTC 的调查、各种诉讼等等。所以它是“像领养小狗一样的免费”（需要后续投入），而不是“像免费啤酒一样的免费”。当时有一个 185 人的大团队，一直在烧钱。那是 2019 年。经营社交网络是一次让人保持谦卑的经历，它与我们做过的所有其他产品都截然不同。

---

### [01:22:58] Matt Mullenweg

**English:**
And I think there's some incredible things about Tumblr and that I'm still very excited about. So where WordPress has primarily a desktop and web user base, Tumblr is obviously like 85% app-based, has a younger demographic. And so part of the vision that now we're executing on is actually we wanted to create a path for people using Tumblr to actually it being powered by WordPress on the back end. So Tumblr users could unlock themes, customization, plugins, et cetera. Actually, we're in the process right now of migrating the half a billion Tumblr sites to WordPress, probably one of the largest data migrations that's happened in a while.

**中文翻译:**
我认为 Tumblr 依然有一些令人惊叹的特质，我对此仍感到兴奋。WordPress 主要面向桌面和网页用户，而 Tumblr 85% 是基于 App 的，用户群更年轻。我们现在的愿景是：让 Tumblr 的后端由 WordPress 驱动。这样 Tumblr 用户就能解锁主题、自定义功能、插件等。实际上，我们目前正在将 5 亿个 Tumblr 站点迁移到 WordPress，这可能是近年来规模最大的数据迁移之一。

---

### [01:23:46] Matt Mullenweg

**English:**
So we're kind of trying to do this in a way that's invisible to users on the front end, so changing at the back end while maintaining the APIs and the interface and everything. So it's a fun engineering project. I kind of posted this kind of call to arms, got a lot of fun people applying for Automattic, and we hired a lot of great folks around this sort of audacious project, this big hairy audacious goal. And so that's where it's at now. I've sort ran it personally for a few years while we're doing turnarounds, but there's a great team there, but still challenged, still not profitable, so we're still subsidizing it from the rest of Automattic's businesses.

**中文翻译:**
我们正努力以一种对前端用户透明的方式来完成这件事，即在保持 API 和界面不变的情况下更换后端。这是一个有趣的工程项目。我发布了一个“召集令”，吸引了很多有趣的人申请 Automattic，我们为这个大胆的项目（这个“宏大、艰难且大胆的目标”）聘请了很多优秀人才。这就是现状。在转型期间我亲自管理了几年，现在那里有一个很棒的团队，但依然面临挑战，依然没有盈利，所以我们仍在用 Automattic 的其他业务来补贴它。

---

### [01:24:21] Matt Mullenweg

**English:**
And one of the things we're also experimenting with is can Tumblr have not just an advertising-driven model? I think ultimately the incentives of advertising social networks can lead to the kind of dynamics that you see on the more negative side of Twitter, Instagram, Facebook, et cetera. And so really trying to create a subscription model or a sort of first-party user-driven advertising, where you promote your blog posts or something like that, or you promote a WooCommerce product or something, where it's not a third-party ad ecosystem, which I think has a lot of weird code and malware and lots of stuff I don't love.

**中文翻译:**
我们还在尝试：Tumblr 能否不只靠广告驱动？我认为广告驱动的社交网络最终会导致你在 Twitter、Instagram、Facebook 负面新闻中看到的那种动态。所以我们正努力创建订阅模式，或者一种“第一方用户驱动”的广告——比如你推广自己的博文或 WooCommerce 产品，而不是依赖第三方广告生态系统，因为后者往往包含很多奇怪的代码、恶意软件和我不喜欢的东西。

---

### [01:24:58] Lenny Rachitsky

**English:**
Wow, sounds like a lot you took on with this acquisition, and I love that you said you ran it initially. So this is a good segue to maybe my last question. I'm curious where this goes. Just how do you... Well, let me zoom out. There's a lot of people these days that are excited about roll of businesses. I'm going to buy a bunch of companies, make them better, make them awesome, save money, and then just keep building this holding company sort of thing. You guys are doing that, and it's working well. What do you look for? How do you decide a company's right for Automattic? What are the factors that are like, we should buy this, we can turn this around and turn it into a big success?

**中文翻译:**
哇，听起来这笔收购让你承担了很多，我很喜欢你提到的最初亲自管理它的经历。这引出了我的最后一个问题：我很好奇未来的走向。现在有很多人对“业务整合”（roll-up businesses）很感兴趣——买一堆公司，改进它们，节省开支，然后建立一个控股公司。你们正在这么做，而且效果不错。你寻找的标准是什么？你如何决定一家公司是否适合 Automattic？哪些因素让你觉得“我们应该买下它，我们可以扭转局面并取得巨大成功”？

---

### [01:25:40] Matt Mullenweg

**English:**
I don't know if I would do another turnaround like Tumblr again, or at least not for many, many years. It's definitely a different thing. The vast majority of things we acquire, it's simply something that's done well, and we want to accelerate it, or sometimes acqui-hires, where we're plugging it into one of our existing projects, or we're taking the team and putting them on something we're already doing. So it's a really talented team. Tumblr, I think we ended up ultimately replacing 85, 90% of the team as well. So that's just very different.

**中文翻译:**
我不知道我是否还会再做一次像 Tumblr 这样的“扭亏为盈”（turnaround），至少很多年内不会了。这完全是另一回事。我们收购的绝大多数项目，本身就运行良好，我们只是想加速它的发展；或者是“人才收购”（acqui-hires），将团队整合进我们现有的项目。Tumblr 的情况是，我们最终更换了 85% 到 90% 的团队成员，这非常不同。

---

### [01:26:06] Matt Mullenweg

**English:**
So I do think there are different ways of doing it, but if you look at our other acquisitions like Day One, et cetera, founder's still here, many years later, we're accelerating stuff like that. We brought it to Android, we're bringing it to it to web. It's more of taking something good and making it better. And probably our best example there is WooCommerce, which was a small company, I think 35, 40 people, based out of South Africa, and has obviously grown to... Again, I said Automattic makes about half a billion dollars a year now, and WooCommerce is a majority of that.

**中文翻译:**
我认为有很多种做法。看看我们的其他收购，比如 Day One，创始人多年后依然在公司，我们正在加速它的发展——把它带到 Android 平台，带到网页端。这更多是“锦上添花”。我们最成功的例子可能是 WooCommerce，它最初是南非的一家只有 35 到 40 人的小公司，现在已经成长为……正如我所说，Automattic 现在年收入约 5 亿美元，而 WooCommerce 贡献了其中的大部分。

---

### [01:26:06] Lenny Rachitsky

**English:**
Speaking of that, actually, you haven't shared the revenue number. I know it's public. Just give people a sense of Automattic's revenue. Can you just share those numbers? Because I think it might blow people's minds.

**中文翻译:**
说到这个，你刚才还没正式分享收入数据。我知道那是公开的。能给听众一个关于 Automattic 收入的概念吗？我觉得这可能会让大家大吃一惊。

---

### [01:26:15] Matt Mullenweg

**English:**
Yeah, I think we say publicly it's about a half a billion dollars in sort of ARR revenue right now.

**中文翻译:**
是的，我们公开的年度经常性收入（ARR）目前大约是 5 亿美元。

---

### [01:26:20] Lenny Rachitsky

**English:**
Incredible. Okay. I have a question for you. It's kind of a hot seat question. As you talked, I wonder, I feel like people are thinking of this. So you've been talking about PE companies being often bad. You're buying Tumblr. You've talked about laying off a bunch of people, turning it all around. How's that different from a PE company, Matt?

**中文翻译:**
不可思议。好，我有一个“火药味”有点重的问题。当你谈话时，我在想，听众可能也会想到这一点：你一直在说 PE 公司通常很糟糕，但你买了 Tumblr，裁掉了一大批人，试图扭转局面。马特，这和 PE 公司的做法有什么区别？

---

### [01:26:39] Matt Mullenweg

**English:**
Yeah, and I agree with you that just because it's private equity doesn't mean it's bad. And also, something people say is like, "Hey, wait, don't you have private equity investors as well at Automattic?" And we do. Now, they own usually a small percentage, sometimes under 1%, and they don't have control of the company. So I think there's a distinguish. Is it a minority investment or a control investment? And with WP Engine, Silver Lake controls the company. And when they control the company, I think there's a spectrum of actions.

**中文翻译:**
是的，我同意你的观点，私募股权并不天然就是坏的。而且人们会说：“嘿，等等，Automattic 不也有私募股权投资者吗？”确实有。但他们通常只持有很小的比例，有时甚至不到 1%，而且他们没有公司的控制权。所以我认为这里有一个区别：是少数股权投资还是控股投资？在 WP Engine 的案例中，银湖资本控制着公司。当他们拥有控制权时，行为模式就会完全不同。

---

### [01:27:30] Matt Mullenweg

**English:**
Obviously, being more efficient is great, and we should all strive for that. And I think every business does, whether it's private equity or our business or things that are founder controlled. You always want to be more efficient. Now, there's some spectrum there where you over-optimize, or you could have dark patterns. Right now on WP Engine, it's very difficult to cancel your accounts. Actually, I think as of today, 45,000 sites have left, so they're, I think, down to 600. Yeah, well, because their customers have realized like, "Hey, this isn't WordPress, this isn't..." or, "They're suing the guy who started WordPress, so maybe we should not support this commercially."

**中文翻译:**
显然，提高效率是好事，我们都应该为此努力。无论是 PE、我们的公司还是创始人控制的公司，都想提高效率。但这里有一个度，你可能会“过度优化”，或者使用“黑暗模式”（dark patterns）。现在在 WP Engine 上注销账号非常困难。实际上，截至今天，已有 4.5 万个站点离开了他们。因为客户意识到：“嘿，这不是真正的 WordPress”，或者“他们在起诉 WordPress 的创始人，也许我们不该在商业上支持他们。”

---

### [01:28:07] Matt Mullenweg

**English:**
So we have the site wordpressenginetracker.com that sort of shows in real time the sites that are leaving. It's kind of an exciting thing to see that number tick up. Actually, maybe a good example as well, even though there's a lot of negativity, you actually look at how people are voting with their wallets. They're leaving. So I think you have to judge as well, just look at the track record. So one of the things I'm very proud of with Automattic is we are an acquirer of first resort, and we have founders that have sold to us. Paul Mayne at Day One is a great example that didn't need to sell. They're wildly profitable, could have run it himself for a long, long time, but people choose to join because they feel like we'll be good stewards of it in the future, and ultimately just have to look at the track record.

**中文翻译:**
我们建了一个网站 wordpressenginetracker.com，实时显示离开他们的站点数量。看到那个数字上升挺让人兴奋的。这其实是一个很好的例子：尽管网上有很多负面言论，但你看人们如何用钱包投票——他们在离开。所以我认为你必须根据过往记录来判断。我为 Automattic 感到自豪的一点是，我们是“首选收购者”，很多创始人愿意卖给我们。Day One 的保罗·梅恩就是一个例子，他本不需要卖掉公司，他们利润丰厚，他可以自己经营很久。但人们选择加入我们，是因为他们觉得我们会是未来的好管家。最终，你只需要看我们的过往记录。

---

### [01:28:52] Lenny Rachitsky

**English:**
Matt, we covered so much. I asked you all the hard questions and more. Before we wrap up, is there anything else that you want to leave listeners with? Any last thoughts, comments, insights, stories?

**中文翻译:**
马特，我们聊了很多。我问了你所有尖锐的问题，甚至更多。在结束前，你还有什么想留给听众的吗？最后的想法、评论、见解或故事？

---

### [01:29:04] Matt Mullenweg

**English:**
Yeah, follow me. I'm at photomatt, P-H-O-T-O-M-A-T-T, on Tumblr, Twitter, Instagram, everything like that. I post a lot about other stuff. I post a lot about AI and open source and other things. Some WordPress things in there as well. I have these life missions to democratize publishing and commerce. We added a new one last year, which is messaging, so it's in beta mode right now, but relaunching in a few months as a product called Beeper, which takes all your Telegram, Instagram DMs, Signal, everything, brings it all into one app.

**中文翻译:**
是的，关注我。我的账号是 photomatt，在 Tumblr、Twitter、Instagram 上都是这个。我会发很多关于 AI、开源和其他事情的内容，当然也有 WordPress。我的生命使命是让出版和商业民主化。去年我们增加了一个新使命：通讯。目前处于测试阶段，几个月后将以 Beeper 的名义重新发布。它能把你所有的 Telegram、Instagram 私信、Signal 等整合到一个应用中。

---

### [01:29:50] Matt Mullenweg

**English:**
So yeah, I'm very excited about that. It's kind of fun to be working on something that's at the stage where WordPress was in 2003, 2004. So WordPress is quite mature at this point. WooCommerce is kind of where WordPress was in 2010. And then the Beeper stuff, the messaging stuff is where we were in 2003. So one thing that keeps me excited is working at different stages of this.

**中文翻译:**
我对此非常兴奋。能在一个处于 WordPress 2003、2004 年阶段的项目上工作很有趣。WordPress 现在已经非常成熟了，WooCommerce 大约处于 WordPress 2010 年的阶段，而 Beeper 这种通讯工具则处于我们 2003 年的阶段。让我保持兴奋的一点就是同时处理这些处于不同阶段的项目。

---

### [01:30:12] Lenny Rachitsky

**English:**
This feels like a reason to be doing your approach to Berkshire Hathaway is just stay active in early stage stuff and not just optimize established things. So it's beeper.com, by the way, awesome domain name. Photomatt, what's the story of photomatt? You're into photography, I imagine, is the story?

**中文翻译:**
这感觉就是你采用“伯克希尔·哈撒韦”模式的原因——保持在早期项目中的活跃度，而不仅仅是优化成熟业务。顺便说一下，beeper.com 是个很棒的域名。Photomatt，这个名字背后有什么故事？我猜你很喜欢摄影？

---

### [01:30:32] Matt Mullenweg

**English:**
Yeah, it's a little bit of a pun. So a fotomatt is also, F-O-T-O-M-A-T-T, is a place that you would go to develop your photos back when you would have film and develop things. So originally my username was Saxmatt because I played the saxophone. Sometimes people mishear that. And also, I started traveling so much. There's been years I do like 400,000 miles of air travel, because I go around the world to go to WordPress events and meet the community. And as a distributed company, we do lots of meetups. And so, it became hard to carry my saxophone around.

**中文翻译:**
是的，这有点像个双关语。Fotomatt（F-O-T-O-M-A-T-T）是以前胶片时代洗照片的地方。最初我的用户名是 Saxmatt，因为我吹萨克斯风（saxophone）。但有时人们会听错。而且，我开始频繁旅行，有些年份我的飞行里程达到 40 万英里，因为我要去世界各地参加 WordPress 活动并见社区成员。作为一家分布式公司，我们有很多聚会。带着萨克斯风到处跑变得很困难。

---

### [01:31:25] Matt Mullenweg

**English:**
So my method of artistic expression became photography, and that's actually kind of how WordPress started, was actually originally a site where I could share my photos before Flickr, before Facebook and everything like that, sort of use this gallery software, actually open source gallery software, PHP software, to sort of share all the photos I was taking. Actually now on my website, I think I have over 38,000 photos I posted. And yeah, it's still one of the things I really love.

**中文翻译:**
所以我的艺术表达方式变成了摄影。实际上 WordPress 的起源也是如此——它最初是一个让我分享照片的网站，在 Flickr 和 Facebook 出现之前，我用一种开源的 PHP 相册软件来分享我拍的照片。现在我的网站上已经发布了超过 38,000 张照片。是的，这依然是我最热爱的事情之一。

---

### [01:31:56] Lenny Rachitsky

**English:**
You forgot to mention your website and your blog, your WordPress site itself, where you blog. Ma.tt, is the domain, which is amazing. I will point people to one of my favorite ritual you have on your blog, which is you share what's in your bag, you talk about how you travel all this, and I think every year you're like, here's the gadgets I use most and bring with me everywhere.

**中文翻译:**
你忘了提到你的个人网站和博客，也就是你写博文的那个 WordPress 站点。域名是 Ma.tt，太绝了。我会向大家推荐你博客上我最喜欢的一个固定栏目：分享“包里有什么”。你谈到你如何旅行，每年你都会发一篇：“这是我最常用的、随身携带的电子产品。”

---

### [01:32:18] Matt Mullenweg

**English:**
It's my most popular post of the year by far.

**中文翻译:**
那绝对是我每年最受欢迎的文章。

---

### [01:32:20] Lenny Rachitsky

**English:**
I'm not surprised. You need an Amazon, just buy everything button. Yeah, because basically you're just trying to optimize for the least weight and most utility, right, out of all these gadgets that you're bringing with the on trips.

**中文翻译:**
我不意外。你需要一个亚马逊“一键购买全部”按钮。因为你基本上是在为这些旅行装备优化“最低重量”和“最高效用”，对吧？

---

### [01:32:33] Matt Mullenweg

**English:**
Yeah, actually weighing it is something I just started doing this year because my bag actually got really heavy, got like 35 pounds or something. And so, some friends were like, "Hey, why don't we weigh everything and just go through." So now I'm posting the weights.

**中文翻译:**
是的，实际上我今年才开始称重，因为我的包变得非常沉，大概有 35 磅。一些朋友建议：“嘿，我们为什么不把每样东西都称一下呢？”所以现在我把重量也发出来了。

---

### [01:32:45] Lenny Rachitsky

**English:**
Oh my god. Okay. Anyway, we'll point people to that. Matt, thank you so much for doing this. This was awesome.

**中文翻译:**
天哪，好吧。我们会引导大家去看的。马特，非常感谢你参加节目，这太棒了。

---

### [01:32:50] Matt Mullenweg

**English:**
Lenny, thank you so much. And I really appreciate the ability to discuss these things in a longer form. And also just your audience. Oh, I guess final thing I'll say is we're hiring a ton. So you have one of the most incredible audiences in the world. I recommend your podcast and newsletter to a lot of my colleagues. And so, if you're someone who loves this kind of stuff, I think there's a big opportunity at Automattic to have an impact on these things.

**中文翻译:**
伦尼，非常感谢。我非常感激能有这样一个长篇讨论的机会。还有你的听众——最后我想说的是，我们正在大量招聘。你拥有世界上最优秀的听众群体之一，我经常向同事推荐你的播客和时事通讯。所以，如果你是热爱这些东西的人，我认为在 Automattic 有很大的机会去产生影响力。

---

### [01:33:11] Lenny Rachitsky

**English:**
What roles are you hiring for most and where do people find these roles?

**中文翻译:**
你们目前招聘最多的职位是什么？人们在哪里可以找到这些职位？

---

### [01:33:15] Matt Mullenweg

**English:**
Automattic.com, A-U-T-O-M-A-T-T-I-C. There's a Work with Us page. You can kind of see how we work. We're fully distributed and can manage that forever. We sort of started that. Another interesting thing is we actually pay the same salaries globally. So whether you're in California or Italy or Nigeria or wherever, we pay global salaries. So yeah, a lot of opportunities, and we're hiring for kind of everything, I would say, but particularly people with great design or product skills is probably one of the areas that you can have the biggest impact at Automattic right now.

**中文翻译:**
Automattic.com。那里有一个“与我们共事”（Work with Us）页面。你可以看到我们的工作方式。我们是完全分布式的，并且会永远保持下去。我们是这种模式的先驱。另一件有趣的事是，我们全球同薪。无论你在加州、意大利还是尼日利亚，我们都支付全球统一标准的薪水。所以机会很多，我们在招几乎所有职位，但目前在 Automattic 最能发挥影响力的是拥有出色设计或产品技能的人才。

---

### [01:33:53] Lenny Rachitsky

**English:**
All right. If you made it this far into the podcast, you should definitely apply. Matt, thank you. Thank you for being here. Bye, everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or a leaving a review as that really helps other listeners find the podcast. You could find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
好的。如果你听到了这里，你绝对应该去申请。马特，谢谢你，谢谢你的到来。再见，各位。非常感谢大家的收听。如果你觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用上订阅。此外，请考虑给我们评分或留下评论，这能帮助其他听众找到我们。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期见。