# Matthew Dicks - 双语对照

# Lenny's Podcast: Matthew Dicks - The Art of Storytelling
## 播客：Lenny's Podcast —— 嘉宾 Matthew Dicks：叙事的艺术

---

### [00:00:00] Matthew Dicks

**English:**
Everyone loves the word storytelling in business. It's a huge buzzword. They love to think of themselves as storytellers, but when they come to me, they don't really want to be storytellers. Because to be a storyteller means you have to separate yourself from the herd, and in their mind, that risks them getting picked off, right? Getting picked off by some predator. But the alternative is you're in the herd, which means you're forgettable. I mean, how many times have you gone to a conference, listened to someone speak, and by the time you're pulling into the driveway, you really can't remember anything that they said? Because that's what happens if we don't speak in story. Our minds are not designed to remember a pie chart or facts or statistics or platitudes or ideas that are not attached to imagery. So the risk you take if you're not telling stories is that you will be forgotten. 100%. You will be forgotten.

**中文翻译:**
在商界，人人都爱“讲故事（storytelling）”这个词。它是一个超级热门的流行语。大家都喜欢把自己想象成讲故事的人，但当他们来找我时，其实并不是真的想成为讲故事的人。因为成为讲故事的人意味着你必须脱离羊群（与众不同），而在他们的潜意识里，这冒着被“猎杀”的风险，对吧？就像被某种捕食者盯上一样。但另一种选择是留在羊群里，这意味着你平庸且易被遗忘。我的意思是，有多少次你去参加会议，听某人演讲，结果当你开车回到家门口时，你已经完全不记得他们说了什么？因为如果我们不用故事来表达，结果就是这样。人类的大脑并非为了记忆饼图、事实、统计数据、陈词滥调或没有画面感的想法而设计的。所以，如果你不讲故事，你承担的风险就是会被遗忘。百分之百，你会被彻底遗忘。

---

### [00:00:54] Lenny

**English:**
Today my guest is Matthew Dicks. Matthew is the author of my All-Time favorite book on storytelling Storyworthy, which a previous guest of the podcast recommended to me and I couldn't put it down. So I reached out to Matthew and got him on the podcast. Matthew is a 59-time Moth Story Slam winner, and nine-time Grand Slam champ. He's also the author of nine other books, including fictions, rock operas, even a comic book. In his day job, he is an elementary school teacher and on the side teaches both individuals and teams at companies like Slack, Amazon, Lego, and Salesforce. The skill of storytelling and public speaking through his company speak up. In our conversation, we get very tactical about how to tell better stories both in life and in work, how to feel more comfortable speaking on stage, how to come up with story ideas that you can deploy when the need arises. Why every good story is centered around one five-second moment of transformation and so much more.

**中文翻译:**
今天的嘉宾是 Matthew Dicks。Matthew 是我心目中关于叙事技巧的最佳书籍《Storyworthy》（讲好故事）的作者。之前的一位播客嘉宾向我推荐了这本书，我读后爱不释手。于是我联系了 Matthew，邀请他来到节目中。Matthew 曾 59 次获得 Moth Story Slam（飞蛾讲故事大赛）冠军，并 9 次获得大满贯冠军。他还是另外九本书的作者，作品涵盖小说、摇滚歌剧，甚至还有漫画书。他的本职工作是一名小学教师，业余时间则通过他的公司 Speak Up 为 Slack、亚马逊、乐高和 Salesforce 等公司的个人和团队教授叙事和演讲技巧。在我们的对话中，我们将深入探讨如何在生活和工作中讲出更好的故事，这些方法非常具有实操性（tactical）。我们还会聊到如何在舞台上更从容地演讲，如何在需要时随时调取故事素材，以及为什么每个好故事都围绕着一个“五秒钟的蜕变时刻”展开，还有更多精彩内容。

---

### [00:05:12] Matthew Dicks

**English:**
Essentially every story is about a singular moment. I call it five seconds. It can be one second honestly. It's a moment of either transformation, meaning I'm telling you a story about how I once used to be one kind of person and now I'm a new kind of person. Or more common is realization. Which is I used to think something and then some stuff happened and now I think a new thing. And those changes they take place overtime. Or really what happens is it's an accumulation of events and feelings and thoughts that ultimately result in a singular moment where that flip actually happens. And I think that's true for almost everyone. It feels like it took a long time, but there really was one second when you thought one thing and then the next second when you thought the new thing. And the purpose of a story is essentially to bring that moment to the greatest clarity possible to the audience.

**中文翻译:**
本质上，每个故事都关乎一个单一的时刻。我称之为“五秒钟时刻”，老实说，它甚至可以只有一秒钟。这要么是一个“蜕变（transformation）”时刻，意味着我告诉你一个关于我曾经是某种人，而现在变成了另一种人的故事；或者更常见的是“领悟（realization）”时刻，即我过去是怎么想的，然后发生了一些事，现在我有了新的想法。这些变化虽然是随着时间推移而发生的，但实际上它是事件、情感和思想的累积，最终导致了那个“反转”发生的单一瞬间。我觉得对几乎所有人来说都是如此：感觉上好像花了很长时间，但确实存在那么一秒钟，前一秒你还在想一件事，后一秒你就有了全新的认知。故事的目的，本质上就是将那个时刻尽可能清晰地呈现给观众。

---

### [00:07:10] Matthew Dicks (The Eileen Example)

**English:**
I'm teaching math today... and I have a student in my class, her name is Eileen, and she's one of those kids that I worry about a little bit because she's got some anxiety. So today we're doing some math and I'm calling kids to the board... I just wasn't sure. So I didn't call her to the board. And so at the end of the math lesson, I wandered over to her desk and I said, "So Eileen, I was thinking about calling you to the board today, but I just wasn't sure if you're there yet. What do you think?" And she said to me, "First of all, I don't like that cheeky smile of yours." And that is all I needed to hear. That was my five-second moment. That was the moment of realization where I understood that Eileen trusted me, felt confident enough in my classroom that she could be herself, that she could fire off a quip at a teacher.

**中文翻译:**
今天我在教数学……班里有个学生叫 Eileen，她是我有点担心的那种孩子，因为她有些焦虑。今天做数学题时，我叫孩子们上黑板演示……但我当时不确定她行不行，所以没叫她。下课后，我走到她课桌旁说：“Eileen，我今天本想叫你上黑板的，但我不太确定你准备好没有。你怎么想？”她对我说：“首先，我不喜欢你那种坏坏的笑（cheeky smile）。” 这就是我需要听到的全部。那就是我的“五秒钟时刻”。在那一刻我突然领悟到，Eileen 信任我，她在我的课堂上感到足够自信，可以做真实的自己，甚至可以对老师开个玩笑反唇相讥。

---

### [00:10:53] Matthew Dicks (Starting at the End)

**English:**
So we start as storytellers at the end. Well, we start at the end if we are telling true stories about ourselves or our companies or our products, things that we know... you have to know the end because you've lived the moment, and the end forms everything. So you know what you're going to say. You found a moment worth speaking to, that five-second moment. And then whatever that moment is... What's the opposite of me realizing Eileen has confidence? It is, Eileen does not have confidence. So that's the opposites that will work in a story. Essentially, a story is about these two moments in time, a beginning and an end, and they're operating in opposition to each other.

**中文翻译:**
作为讲故事的人，我们要从结尾开始。如果我们讲的是关于自己、公司或产品的真实故事，也就是我们熟悉的事情，我们就得从结尾开始。你必须知道结尾，因为你亲历了那个时刻，而结尾决定了一切。这样你就知道自己要说什么了。你找到了一个值得讲述的时刻，即那个“五秒钟时刻”。无论那个时刻是什么……比如我意识到 Eileen 有了自信，那么它的对立面是什么？就是 Eileen 缺乏自信。这就是故事中起作用的对立面。本质上，一个故事就是关于时间轴上的这两个点：开头和结尾，且它们处于对立状态。

---

### [00:16:20] Matthew Dicks (The Dinner Test)

**English:**
The dinner test is the idea that when you're telling a story in a formal way, if you're performing on a stage or delivering a keynote or even delivering a pitch to entrepreneurs... essentially the story that you're telling should be very closely related to the story you would tell someone if you were having dinner. So there should be no performance art included within your story... Like opening a story with unattributed dialogue. So you're standing on stage and you open your story with, "Jim, it's time to come in for dinner." My wife said, that's just weird. We don't talk like that as regular people... If you and I were having dinner and you said, "Hey, how was your day, Matt?" And I said, "Well, let me tell you Lenny. Bang, the door opened." You would not have dinner with me again.

**中文翻译:**
“晚餐测试”是指当你以正式方式讲故事时——无论是在舞台上表演、发表主题演讲，还是向创业者做提案（pitch）——本质上，你讲的故事应该非常接近你在吃晚饭时会告诉别人的样子。所以，故事中不应该包含任何“行为艺术”……比如用一段没头没脑的对话开头。你站在台上，开口就是：“吉姆，该进来吃晚饭了。” 我妻子说，这太奇怪了。正常人不会这么聊天。如果咱俩在吃晚饭，你问：“嘿，Matt，今天过得怎么样？” 我回答说：“听好了 Lenny。砰！门开了。” 你绝对不会想再跟我吃第二次饭。

---

### [00:18:25] Matthew Dicks (Vulnerability and Ownership)

**English:**
If you're telling a story about someone else, essentially, you might as well be telling fiction. Because that person's not in the room, and to the audience, they don't really exist... And because of that, you are almost unable to express any vulnerability in your story. You can't reveal anything about yourself. And one of the key parts of storytelling is to be vulnerable with your audience. Meaning I'm going to say stuff in a meaningful way. I might say stuff that most people are unwilling to share in a public way, but I'm at least going to offer up a little bit of my heart and mind. If I offer up the heart and mind of someone else that doesn't really require any vulnerability.

**中文翻译:**
如果你在讲别人的故事，本质上，你还不如去讲小说。因为那个人不在现场，对观众来说，他们并非真实存在。正因如此，你几乎无法在故事中表达任何“脆弱感（vulnerability）”。你无法揭示关于你自己的任何事情。而叙事的核心要素之一，就是向观众展示你的脆弱。这意味着我要以一种有意义的方式说话，我可能会说一些大多数人不愿意在公开场合分享的事情，但至少我奉献了一点点我的内心想法。如果我奉献的是别人的内心想法，那根本不需要任何勇气去展示脆弱。