# Maya Prohovnik - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Maya Prohovnik.

---

### (00:00:00) Maya Prohovnik

**English:**
We were obsessed with reducing friction, this was our constant battle. And so we hired a couple of college interns and we brought them in and we were like, people are going to push this magical one button in the Anchor app and they're going to say, I want to distribute my podcast, and your job is going to be to do all that same manual stuff manually, but to them it's going to feel magical and it happened automatically. I still don't know how many people know this. I think people think that we had some secret backdoor deal with Apple for distribution, but we just had college students making Apple podcast accounts and then submitting hundreds of thousands of podcasts through these accounts, and I think that was a really big part of why we got so much hosting market share so quickly because it was such an insane benefit over the other platforms which otherwise had been commoditized at that point.

**中文翻译:**
我们当时痴迷于减少摩擦（减少用户阻力），这是我们持久的战斗。于是我们雇了几个大学生实习生，把他们招进来后说：用户只需在 Anchor 应用里按下那个神奇的按钮，说“我想分发我的播客”，而你们的工作就是手动完成所有那些繁琐的手动操作。但对用户来说，这感觉就像魔法一样，是自动完成的。我至今不知道有多少人知道这件事。我想人们可能以为我们和苹果在分发上有某种秘密的后门协议，但实际上我们只是让大学生们不停地创建苹果播客账号，然后通过这些账号提交了成千上万个播客。我认为这是我们能如此迅速获得巨大托管市场份额的一个重要原因，因为相比于当时已经同质化的其他平台，这简直是一个疯狂的优势。

---

### (00:00:48) Lenny

**English:**
Welcome to Lenny's Podcast, where I interview world-class product leaders and growth experts to learn from their hard win experiences building and growing today's most successful products. Today my guest is Maya Prohovnik. Maya is Spotify's head of product for podcasting where she oversees product design and engineering teams responsible for building the tools and experiences for podcasters and their listeners. Maya was also employee number one at Anchor, which Spotify acquired five years ago, which became the core of Spotify's podcasting hosting platform, which now powers over 75% of all new podcasts created in the world. In our conversation, we dig into why Maya is obsessed with dogfooding and why she encourages everyone on her team to create their own podcast. She's got four podcasts of her own, which are all very highly rated and people love. We dig into how she stays productive and organized in a very hectic senior leadership role, what she's done to allow for Anchor to continue to operate like a startup within a larger organization.

**中文翻译:**
欢迎来到 Lenny 的播客。在这里，我采访世界级的产品领导者和增长专家，学习他们在构建和发展当今最成功产品过程中辛苦换来的经验。今天的嘉宾是 Maya Prohovnik。Maya 是 Spotify 的播客产品负责人，她负责管理产品设计和工程团队，致力于为播客创作者及其听众构建工具和体验。Maya 也是 Anchor 的一号员工，Spotify 在五年前收购了 Anchor，它随后成为了 Spotify 播客托管平台的核心，目前全球超过 75% 的新播客都是由该平台支持的。在我们的对话中，我们将深入探讨为什么 Maya 痴迷于“吃自家狗粮”（Dogfooding，指亲自试用自家产品），以及为什么她鼓励团队中的每个人都创建自己的播客。她自己就有四个播客，评分都很高且深受喜爱。我们还会探讨她在繁忙的高级领导岗位上如何保持高效和有条理，以及她做了哪些努力让 Anchor 在大型组织内部能继续像初创公司一样运作。

---

### (00:01:44) Lenny

**English:**
Also, a bunch of really fun early Anchor stories, including how interns uploaded podcasts to Apple and Spotify manually before they could automate that. Plus, how to find a balance between using your gut and using data to make decisions. Also, public speaking tips, so much more. Maya is amazing and I'm really excited for you to hear this episode. With that, I bring you Maya Prohovnik after a short word from our sponsors. This episode is brought to you by Sidebar. Are you looking to land your next big career move or start your own thing? One of the most effective ways to create a big leap in your career and something that worked really well for me a few years ago is to create a personal board of directors. A trusted peer group where you can discuss challenges you're having, get career advice, and just gut check how you're thinking about your work, your career, and your life.

**中文翻译:**
此外，还有一堆非常有趣的 Anchor 早期故事，包括在实现自动化之前，实习生是如何手动将播客上传到苹果和 Spotify 的。另外，还有如何在凭直觉决策和利用数据决策之间找到平衡。还有公开演讲的技巧等等。Maya 非常出色，我非常期待大家听到这一集。在听众朋友们听完赞助商的简短介绍后，我将为您带来 Maya Prohovnik 的访谈。本集节目由 Sidebar 赞助。你是否正在寻求职业生涯的下一次重大飞跃，或者准备创业？实现职业跨越最有效的方法之一，也是几年前对我非常有用的方法，就是建立一个“个人董事会”。这是一个值得信赖的同行群体，你可以在这里讨论遇到的挑战，获取职业建议，并对你的工作、职业和生活想法进行直觉检查。

---

### (00:02:33) Lenny

**English:**
This has been a big trajectory changer for me, but it's hard to build this trusted group. With Sidebar, senior leaders are matched with highly vetted private supportive peer groups to lean on for unbiased opinions, diverse perspectives, and raw feedback. Everyone has their own zone of genius, so together we're better prepared to navigate professional pitfalls leading to more responsibility, faster promotions, and bigger impact. Guided by world-class programming and facilitation Sidebar enables you to get focused tactical feedback at every step of your journey. If you're a listener of this podcast, you're likely already driven and committed to growth. A Sidebar personal board of directors is the missing piece to catalyze that journey. Why spend a decade finding your people when you can meet them at Sidebar today, jump the growing wait list of thousands of leaders from top tech companies by visiting sidebar.com/lenny to learn more. That's sidebar.com/lenny.

**中文翻译:**
这对我来说是职业轨迹的重大改变，但建立这样一个值得信赖的群体很难。通过 Sidebar，高级领导者可以与经过严格筛选的私人支持性同行小组匹配，从而获得公正的意见、多元的视角和原始的反馈。每个人都有自己的天才领域，因此聚在一起，我们能更好地应对职业陷阱，从而承担更多责任、获得更快晋升并产生更大影响。在世界级项目和引导的指导下，Sidebar 让你在旅程的每一步都能获得专注的战术反馈。如果你是本播客的听众，你可能已经非常有动力并致力于成长。Sidebar 的个人董事会就是催化这一旅程的最后一块拼图。为什么要花十年时间去寻找志同道合的人，而今天就可以在 Sidebar 遇到他们呢？访问 sidebar.com/lenny 了解更多信息，跳过数千名来自顶尖科技公司领导者的等待名单。网址是 sidebar.com/lenny。

---

### (00:03:29) Lenny

**English:**
This episode is brought to you by Wix Studio. Your agency has just landed a dream client. You already have big ideas for the website, but you have the tools to bring your ambitious vision to life. Let me tell you about Wix Studio, the new platform that lets agencies deliver exceptional client sites with maximum efficiency. How? First, let's talk about advanced design capabilities. With Wix Studio, you can build unique layouts with a revolutionary grid experience and watches elements scale proportionally by default. No-code animations at Sparks of delight while adding custom CSS gives total design control. Bring ambitious client projects to life with any industry with a fully integrated suite of business solutions from e-commerce to events, bookings and more, and extend the capabilities even further with hundreds of APIs and integrations. You know what else? The workflows just make sense. There's the built-in AI tools, the on canvas collaborating, a centralized workspace, the reuse of assets across sites, the seamless client handover, and that's not all. Find out more at wix.com/studio. Maya, thank you so much for being here, and welcome to the podcast.

**中文翻译:**
本集节目由 Wix Studio 赞助。你的代理公司刚刚签下了一个梦寐以求的客户。你对网站已经有了宏大的构思，但你是否有工具将这一雄心勃勃的愿景变为现实？让我向你介绍 Wix Studio，这个新平台能让代理公司以最高效率交付卓越的客户网站。怎么做到的？首先，让我们谈谈先进的设计能力。通过 Wix Studio，你可以利用革命性的网格体验构建独特的布局，并观察元素默认按比例缩放。无代码动画增添了惊喜感，而添加自定义 CSS 则提供了完全的设计控制。通过从电子商务到活动、预订等全套集成的业务解决方案，为任何行业的雄心勃勃的客户项目注入生命，并通过数百个 API 和集成进一步扩展功能。还有什么？工作流程非常合理。它有内置的 AI 工具、画布上的协作、集中式工作区、跨站点的资产重用、无缝的客户移交，而且还不止这些。欲了解更多信息，请访问 wix.com/studio。Maya，非常感谢你能来到这里，欢迎来到本播客。

---

### (00:04:38) Maya Prohovnik

**English:**
Thank you so much for having me. You and I have been trying to get together for almost a year now.

**中文翻译:**
非常感谢邀请我。你和我为了这次碰面已经尝试了快一年了。

---

### (00:04:42) Lenny

**English:**
Oh, man. But it all worked out and it's going to be very worth it.

**中文翻译:**
噢，天哪。但最终还是成功了，这绝对是非常值得的。

---

### (00:04:45) Maya Prohovnik

**English:**
You had a kid. I took parental leave.

**中文翻译:**
你有了孩子，我也休了育儿假。

---

### (00:04:47) Lenny

**English:**
Oh, right. That is true. Man, overlapping kid journeys. I also have been just really looking forward to this chat partly because you're amazing and partly because it just feels very meta to have the head of product of Spotify podcasting on the podcast, and I imagine many people are listening to this on Spotify, so there's this, I don't know, turtles all the way down situation happening.

**中文翻译:**
噢，对。确实如此。伙计，育儿之路重叠了。我也一直非常期待这次聊天，部分原因是你很出色，另一部分原因是，让 Spotify 播客的产品负责人出现在播客里感觉非常“元”（meta），而且我猜很多人正在 Spotify 上听这段对话，所以有一种……我不知道，那种“乌龟背乌龟”（指层层嵌套）的感觉。

---

### (00:05:08) Maya Prohovnik

**English:**
I totally agree. I was thinking the same thing when I was preparing for it where it's like so much of what we have to talk about is so meta, and then we also have you and I know each other because you've been sending me feedback about the podcast experience on Spotify, so lots of circular stuff there.

**中文翻译:**
我完全同意。我在准备的时候也在想同样的事情，我们要聊的很多东西都非常“元”。而且我们认识也是因为你一直在给我发关于 Spotify 播客体验的反馈，所以这里面有很多循环往复的东西。

---

### (00:05:22) Lenny

**English:**
Speaking of Spotify and podcasting, clearly you've done an incredible job building podcasting on Spotify. From what I've read, it's the number one podcasting platform now. Is there a stat you could share by just the percentage of the market share essentially of Spotify podcasting?

**中文翻译:**
说到 Spotify 和播客，显然你在 Spotify 构建播客业务方面做得非常出色。根据我读到的资料，它现在是排名第一的播客平台。你能不能分享一个数据，比如 Spotify 播客的市场份额百分比？

---

### (00:05:37) Maya Prohovnik

**English:**
I think we are now officially over a third of global market share of podcast listening, which is pretty insane.

**中文翻译:**
我想我们现在正式占据了全球播客收听市场份额的三分之一以上，这相当疯狂。

---

### (00:05:43) Lenny

**English:**
That is insane.

**中文翻译:**
确实疯狂。

---

### (00:05:44) Maya Prohovnik

**English:**
Yeah.

**中文翻译:**
是的。

---

### (00:05:44) Lenny

**English:**
Also, I think on the hosting side, it's an even bigger number. Is there a stat you can share by just maybe new podcasts that are launched and how many are hosted on Spotify?

**中文翻译:**
而且，我认为在托管（hosting）方面，数字甚至更大。有没有关于新发布的播客中，有多少是托管在 Spotify 上的数据可以分享？

---

### (00:05:53) Maya Prohovnik

**English:**
Yeah, I think at this point it's more than 75% of all new shows on Spotify are hosted with Spotify for podcasters, which used to be Anchor. When we were acquired by Spotify, I think Anchor had already gotten to 40% of all new podcasts or something crazy. So, yeah.

**中文翻译:**
是的，我想目前 Spotify 上超过 75% 的新节目都是通过 Spotify for Podcasters（以前的 Anchor）托管的。当我们被 Spotify 收购时，我想 Anchor 已经占据了所有新播客的 40% 左右，非常惊人。

---

### (00:06:09) Lenny

**English:**
Insane. Okay, so for these reasons, I want to spend the time that we have together unpacking how you operate as a product leader and essentially what you've learned about product org leadership growth and all those things. How's that sound?

**中文翻译:**
太惊人了。好，基于这些原因，我想利用我们在一起的时间，拆解你作为产品领导者是如何运作的，以及你学到的关于产品组织领导力、增长等方面的经验。听起来怎么样？

---

### (00:06:22) Maya Prohovnik

**English:**
That sounds perfect. My favorite topics.

**中文翻译:**
听起来很完美。这些是我最喜欢的话题。

---

### (00:06:24) Lenny

**English:**
Okay, let's do it. So as the first question I asked a PM who actually works for you, Wilma Chu, what to ask you, and the first thing that came to mind for her was this idea of dogfooding and how important dogfooding is to your way of operating as a product leader. As an example, you have three of your own podcasts on Spotify and I checked them out and they're all very highly rated, so they're not just like bullshit podcasts, they're real people actually listen and enjoy them. So my question to you is just why is dogfooding so important to you? How do you actually operationalize it? And then also maybe just talk about these podcasts that you have.

**中文翻译:**
好，那我们开始吧。第一个问题，我问了你手下的一位产品经理 Wilma Chu 该问你什么，她首先想到的是“吃自家狗粮”（dogfooding）这个概念，以及这对你作为产品领导者的运作方式有多重要。举个例子，你在 Spotify 上有三个自己的播客，我查了一下，评分都很高，所以它们不是那种敷衍了事的播客，而是真的有人在听并且喜欢的。所以我的问题是，为什么“吃自家狗粮”对你如此重要？你具体是如何将其制度化的？另外，也许可以聊聊你做的这些播客。

---

### (00:06:58) Maya Prohovnik

**English:**
Sure. Well, I can talk about them forever, so be careful because I'll take up the whole hour with that. But I actually have four podcasts. There's two that I don't update as much anymore. So my first ever podcast was about Stephen King books. I'm a big Stephen King super fan. So, when I joined Anchor, and we weren't even fully podcasts yet, if you recall, we were something else audio, we were trying to avoid being podcasts for a while and then we decided to just be podcasts. But when I got into audio and trying to help audio creators, the first thing I did was make my own podcast because I was like, I know nothing about production or what it feels to even be a creator in that way.

**中文翻译:**
当然可以。我可以聊这些聊上一整天，所以小心点，不然我会占满整个小时。实际上我有四个播客，其中两个现在更新不那么频繁了。我的第一个播客是关于史蒂芬·金（Stephen King）的书。我是史蒂芬·金的超级粉丝。当我加入 Anchor 时，我们甚至还没完全做播客，如果你还记得的话，我们当时是做另一种音频产品的，我们曾试图避开播客这个领域一段时间，后来才决定全力做播客。但当我进入音频领域并试图帮助音频创作者时，我做的第一件事就是制作自己的播客，因为我觉得我对制作流程或者作为创作者的感受一无所知。

---

### (00:07:35) Maya Prohovnik

**English:**
And so I started my Stephen King podcast because that is the number one thing that I just love to talk about every day, which is one of my tips for podcasters. If you're trying to figure out what to make a show about, it's what can you talk about for? So I did that one for a while actually. I spent a ton of time editing it. I spent a ton of time on SEO and marketing it, and it got to the point, I think at its peak I was getting 5,000 listeners in a episode, which now seems small for a podcast, I know.

**中文翻译:**
所以我开始了我的史蒂芬·金播客，因为那是我每天最喜欢聊的话题，这也是我给播客创作者的建议之一：如果你在纠结该做什么节目，就想想你能持续聊下去的话题是什么。那个播客我做了挺久。我花了大量时间剪辑，花了大量时间做 SEO 和营销。在巅峰时期，每集大约有 5000 名听众，我知道这在现在的播客界看起来不算多。

---

### (00:07:59) Lenny

**English:**
No, that's very legit.

**中文翻译:**
不，这已经非常厉害了。

---

### (00:08:01) Maya Prohovnik

**English:**
Yeah, for a test podcast that I was just doing to learn how to do my job, I was so excited to get that audience and I fell off because, well, mostly I had a kid, I joined Spotify. My life's really busy and that level of production is so hard to do if it's not your full-time job, but I still get emails all the time from people who are like, please bring it back. I never found another great Stephen King because I really got deep into the books and the connection between the books. So that was one of them. The second one I did, still going today. So my husband and I have this Big Brother podcast, the show Big Brother, it's terrible.

**中文翻译:**
是的，对于一个只是为了学习如何工作而做的测试播客，能有这么多听众我非常兴奋。后来我没坚持下去，主要是因为有了孩子，又加入了 Spotify。我的生活变得非常忙碌，如果不是全职做，那种程度的制作水平很难维持。但我现在仍然经常收到邮件，人们说“请把它带回来吧”。我再也没找到另一个这么棒的史蒂芬·金播客，因为我当时真的深入研究了那些书以及书与书之间的联系。那是其中一个。第二个播客至今还在更新，是我和我丈夫做的关于《老大哥》（Big Brother）真人秀的播客，它很糟糕。

---

### (00:08:33) Maya Prohovnik

**English:**
I would not recommend listening to my podcast unless you are a Big Brother super fan, and I actually started that one because I wanted to get the other end of the spectrum where something we were really focused on with Anchor at the time was first time creators really growing the pie of podcasters and specifically we had this theory that podcast creation of the future would be mobile first and we had this really high-powered mobile app, and so I was like, I'm going to make a podcast that's fully mobile, not highly edited, not worry about making something that sounds like a traditional podcast. And I really leaned into all the Anchor features. So it's fully recorded on my phone. I do almost no editing, but I think the thing that's kept us going, because it's been six or seven years now we've been doing the show, it's really the community, the people who call in.

**中文翻译:**
除非你是《老大哥》的超级粉丝，否则我不建议你听。我开始做这个是因为我想尝试光谱的另一端。当时我们在 Anchor 非常关注初级创作者，想把播客市场的蛋糕做大。具体来说，我们有一个理论，认为未来的播客创作将是“移动优先”的，而我们当时有一个功能非常强大的移动应用。所以我决定做一个完全基于移动端的播客，不进行深度剪辑，也不担心它听起来是否像传统的播客。我充分利用了 Anchor 的所有功能：完全用手机录制，几乎不剪辑。但我想让我们坚持下去的原因——我们已经做了六七年了——是社区，是那些打电话进来的人。

---

### (00:09:15) Maya Prohovnik

**English:**
I have no idea who these people are. I have no idea how they found this terrible show, but they love it. They call in every week. And that I think is one of the many things I've learned from dogfooding, a podcast creation app is that community piece is so important. If you don't know if anyone's listening, if you don't know what they like about it, if you don't know if they're coming back, it's so hard to keep investing the time. And then I made a show, my least known podcast, because it only got like 25 listeners for episode, it's about my favorite book of all time called Children of Time. It's actually a trilogy. And the reason it got almost no listeners is because there were tons of spoilers in the podcast and the book is like 800 pages long. So we were like, do not listen if you haven't read the book.

**中文翻译:**
我完全不知道这些人是谁，也不知道他们是怎么找到这个糟糕的节目的，但他们就是喜欢，每周都打电话进来。我想这就是我从“吃自家狗粮”——使用播客创作应用——中学到的众多事情之一：社区感非常重要。如果你不知道是否有人在听，不知道他们喜欢什么，不知道他们是否会回来，你就很难继续投入时间。然后我还做了一个节目，是我知名度最低的播客，每集只有大约 25 个听众，是关于我最喜欢的一本书《时间之子》（Children of Time），它其实是一个三部曲。几乎没人听的原因是播客里有大量的剧透，而那本书有 800 多页长。所以我们说“没读过书的千万别听”。

---

### (00:09:53) Maya Prohovnik

**English:**
So, it was very niche, but I think it's a really good podcast if you've read Children of Time. And then my last one I just started doing a couple of years ago is about parenting. So I have a son who's two and a half now and we have been documenting our journey as parents all the way from, we went through IVF, so starting with sort of fertility, I have a really fun episode about childbirth if people are interested in that sort of thing. And then ever since then it's just been episodes about the transition to parenthood, which has not been particularly easy for us, and now my son's a toddler, so lots of fun things happening there. You're not there yet, but you will be and then you can listen to my toddler episodes.

**中文翻译:**
所以它非常小众，但如果你读过《时间之子》，我觉得它是个很棒的播客。最后一个是我几年前开始做的，关于育儿。我儿子现在两岁半了，我们一直在记录我们的为人父母之旅，从我们经历 IVF（试管婴儿）开始，所以是从生育话题开始的。如果有人感兴趣，我有一集关于分娩的非常有趣的节目。从那以后，就是关于向父母身份转变的节目，这对我们来说并不容易。现在我儿子进入了幼儿期，发生了很多有趣的事。你还没到那个阶段，但你迟早会的，到时候你可以听听我的幼儿期剧集。

---

### (00:10:27) Lenny

**English:**
Yeah. I got to listen to the next... A few months ahead to learn from what you've learned.

**中文翻译:**
是的，我得提前几个月听听，向你学习经验。

---

### (00:10:31) Maya Prohovnik

**English:**
Yes, I think that's a good tactic.

**中文翻译:**
是的，我觉得这是个好策略。

---

### (00:10:33) Lenny

**English:**
Before we talk about dogfooding, have you ever considered going full-time on this stuff? This is always an option for people and clearly you've done great. At least two podcasts are killing it.

**中文翻译:**
在聊“吃狗粮”之前，你有没有考虑过全职做这些？这对很多人来说都是一个选择，而且显然你做得很好，至少有两个播客非常成功。

---

### (00:10:44) Maya Prohovnik

**English:**
I have not. And I think it's so funny because with my parenting podcast too, and even my terrible Big Brother podcast, I get compliments all the time and people are like, "I love listening to this." And my husband also is a really funny and a really good podcaster, but I don't know why I don't think of myself as a creator. I think to me it still feels like this exercise where it's like I'm making my podcast, but I'm really doing it so that I can learn about our product and get in the mindset of a creator. So I think the problem is I'm just too much of a product person. It's a means to an end for me instead of the end itself. But that is an interesting question because I know most people who podcasts, their ultimate goal is obviously to be able to do it full-time and that is interesting that I haven't thought about it.

**中文翻译:**
我没有。我觉得很有趣，因为我的育儿播客，甚至我那个糟糕的《老大哥》播客，经常收到赞美，人们说“我喜欢听这个”。我丈夫也是个非常幽默且优秀的播客主。但我不知道为什么，我并不把自己看作一个“创作者”。对我来说，这更像是一种练习，我制作播客是为了了解我们的产品，并进入创作者的思维模式。所以我想问题在于我太像一个“产品人”了。对我来说，这只是达到目的的手段，而不是目的本身。但这是一个有趣的问题，因为我知道大多数做播客的人，最终目标显然是能够全职去做，而我竟然没想过这一点，这很有意思。

---

### (00:11:31) Lenny

**English:**
You have a good backup plan of things if anything goes off the rails.

**中文翻译:**
如果万一出了什么差错，你有一个很好的备选方案。

---

### (00:11:34) Maya Prohovnik

**English:**
I guess so, yeah.

**中文翻译:**
我想是的。

---

### (00:11:35) Lenny

**English:**
Awesome. Okay. Just coming back to this idea of dogfooding, where does that come from for you? What have you learned about just how to execute that?

**中文翻译:**
太棒了。好，回到“吃狗粮”这个话题，这种理念对你来说源自哪里？关于如何执行它，你学到了什么？

---

### (00:11:40) Maya Prohovnik

**English:**
It's just always been my natural state. I've had a handful of different product jobs and I guess they've all been tangentially related to helping creators or creative people. And so I think for me it's like I don't know how you can build those tools if you don't understand that mindset. I'm not surprised that it came to Wilma's mind when you asked her what to ask me because I am constantly yelling at my product team who do not have podcasts and being like, I really don't think that you can build the right things. If they talk to users all the time, they see the data, but all of them, once they finally start doing their podcast, they're like, I get it. Something clicked and now I feel like I really understand what they need. And I guess building tools for creators is similar to building a B2B product where you really have to understand business, it's their livelihood.

**中文翻译:**
这一直是我的一种自然状态。我做过几份不同的产品工作，我想它们都或多或少与帮助创作者或有创意的人有关。所以对我来说，如果你不理解那种思维模式，我不知道你怎么能构建出那些工具。我不惊讶 Wilma 在你问她该问我什么时会想到这一点，因为我经常对那些没做播客的产品团队成员大喊大叫：“我真的不认为你们能做出正确的东西。”即使他们经常和用户交流，看数据，但只有当他们真正开始做自己的播客时，他们才会恍然大悟：“我懂了。”那种感觉就像突然通了，现在我感觉我真的理解用户需要什么了。我想为创作者构建工具类似于构建 B2B 产品，你必须真正理解业务，因为那是他们的生计。

---

### (00:12:25) Maya Prohovnik

**English:**
And so I think if you're just looking at a list of feature requests, you're not necessarily going to prioritize it in the same way as if you deeply feel those problems. And I think for me, I don't know if I mentioned this to you, but when I first got into tech, I started in customer support, that was how I got into product, and so I think I just am a very user focused product person. I think there's different schools of thought for product and for me it's always been about making people happy, making their experience better, solving real problems in their lives. And so for me, becoming one of the users, I think it's made it so much easier for me to advocate for that being a pretty big chunk of the roadmap.

**中文翻译:**
所以我觉得，如果你只是盯着一份功能需求列表，你对优先级的判断，绝对不如你切身感受到这些痛点时那么准确。对我来说，我不知道是否跟你提过，我刚进入科技行业时是从客户支持做起的，那是进入产品领域的途径。所以我是一个非常以用户为中心的产品人。产品领域有不同的流派，对我来说，核心始终是让人们开心，改善他们的体验，解决他们生活中的实际问题。因此，成为用户之一，让我更容易去倡导将这些需求作为产品路线图中相当大的一部分。

---

### (00:13:04) Maya Prohovnik

**English:**
I think if you don't have that, especially coming from someone in leadership, it's so easy to just fall into that trap of like, well, we're working on the next big strategic thing, which is two years away, and then in the meantime your users are getting no value and then they're just going somewhere else. So I don't know. I think it's really important to me. It makes sense to me and also, I'm not sure how else I would do product. I've never really not done it that way.

**中文翻译:**
我认为如果你没有这种意识，尤其是作为领导层，很容易掉进这样的陷阱：我们正在忙于下一个重大的战略项目，那是两年后的事，而与此同时，你的用户没有获得任何价值，于是他们就流失到别处去了。所以我不知道，这对我来说真的很重要。这对我来说很合逻辑，而且我不确定如果不这么做，我还能怎么做产品。我从来没有不按这种方式做过。

---

### (00:13:25) Lenny

**English:**
It reminds me of Airbnb Brian was a huge advocate on the host side of the product is like, you need to be a host, but many people couldn't because they didn't have a place that could be hosted. Is there anything you've learned about just how to make this a thing that actually works effectively, a way to operationalize this for people listening, they're like, "Oh, I should start encouraging my team to do?"

**中文翻译:**
这让我想起 Airbnb 的 Brian Chesky，他非常倡导在房东端也要“吃狗粮”，比如“你需要成为一名房东”，但很多人做不到，因为他们没有可以出租的房子。关于如何让这件事真正有效地运作，你有没有学到什么？有没有一种方法可以将其制度化，让听众觉得“哦，我也应该开始鼓励我的团队这么做”？

---

### (00:13:42) Maya Prohovnik

**English:**
I'm constantly reminding our team to do this. And then I think that also comes from the other people who are doing it. So we really elevate the people on our team who have their own podcasts, we help them tell their stories internally. Whenever we do an offsite or any team activity, we'll always incorporate podcast creation or some way of making sure everyone on the team is using the tools. I don't know, I think a lot of it just comes from, I'm so vocal about this stuff. The other night I was recording a podcast and I DMed one of the engineers on our team and told him about this tiny little iOS bug and he was like, why are you DMing me about this at nine o'clock at night? I think I was also supposed to be on vacation, I can't remember.

**中文翻译:**
我一直在提醒我们的团队这样做。而且我认为这也要靠那些已经在做的人。所以我们真的会提拔团队中拥有自己播客的人，帮助他们在内部讲述自己的故事。每当我们进行团建（offsite）或任何团队活动时，我们总会加入播客创作环节，或者通过某种方式确保团队中的每个人都在使用这些工具。我不知道，我想很大程度上是因为我对此非常直言不讳。前几天晚上我在录播客，我给团队里的一位工程师发私信，告诉他一个微小的 iOS bug，他说：“你为什么在晚上九点给我发这个？”我记得当时我好像还在休假，记不清了。

---

### (00:14:20) Maya Prohovnik

**English:**
But then he got the bug fix the next day. And so I do think making that something that's really top of mind for the team that we do need to fix problems, that these things matter, I don't know. I always listen to the podcast that my team makes, so it's like I know they're going to get at least one listener. And then I think also I try, I think because I understand a big part of building tools for podcasters is understanding all the barriers to entry. It's actually a really difficult thing trying to get someone to put their voice out there, share their story, it's a really emotional journey. And so I feel like I've tried to turn some of the things that I've learned about podcasting into, I've never written it down, maybe I should, but I have a playbook that I'll tell people when they're considering making their own podcast.

**中文翻译:**
但他第二天就修复了那个 bug。所以我确实认为，要让团队时刻记住我们需要解决问题，这些事情很重要。我总是听我团队做的播客，所以他们知道至少会有一个听众。此外，我也在尝试，因为我明白为播客主构建工具的一个重要部分是理解所有的准入门槛。让一个人把自己的声音发出来，分享自己的故事，其实是一件非常困难的事，这是一个充满情感的旅程。所以我尝试把我学到的一些关于播客的知识转化成……我还没写下来，也许我应该写，但我有一套“剧本”，当人们考虑制作自己的播客时，我会告诉他们。

---

### (00:15:02) Maya Prohovnik

**English:**
So it's just things like don't try and record by yourself, find a friend. That's a much easier way to get into it or don't follow a script because then you're going to feel really awkward and uncomfortable and not feel good about it afterwards. Or don't just record a test thing for 30 seconds and publish it because you have to make yourself feel the pain that we're trying to understand in our users.

**中文翻译:**
比如：不要尝试一个人录音，找个朋友，这是入门最简单的方式；或者不要照本宣科，因为那样你会感到非常尴尬和不舒服，事后感觉也不好；或者不要只录一个 30 秒的测试音频就发布，因为你必须让自己感受到我们试图在用户身上理解的那种“痛苦”。

---

### (00:15:24) Lenny

**English:**
What's cool about that that could turn into just onboarding education, basically your experience of making a podcast informs how to help new podcasters become successful.

**中文翻译:**
这很酷，它可以转化为入驻教育（onboarding education），基本上你制作播客的经验可以指导如何帮助新播客主获得成功。

---

### (00:15:31) Maya Prohovnik

**English:**
Totally, yeah. And also this is less about dogfooding, but one of my favorite things is I'm always just trying to convince everyone I meet to start a podcast, that's just become my annoying thing. And so if I'm interviewing someone for a job or if I'm at a party and mingling with people, it's like somehow the conversation always turns to their passions and then I'm like, you should make a podcast about it. And then they're like, well, I can't. And then I work my way through all the reasons they say they can't do it, and then they go start a podcast. So I'm like one person at a time.

**中文翻译:**
完全正确。而且这虽然不完全属于“吃狗粮”，但我最喜欢做的一件事就是试图说服我遇到的每一个人去开个播客，这已经成了我招人烦的一个特点。所以如果我在面试某人，或者在派对上社交，不知怎么的，话题总会转到他们的热情所在，然后我就会说：“你应该为此做一个播客。”他们会说：“噢，我做不到。”然后我会逐一化解他们说做不到的所有理由，最后他们真的去开了播客。我就是这样，一次搞定一个人。

---

### (00:16:00) Lenny

**English:**
I see how you're growing the platform now.

**中文翻译:**
我现在明白你是怎么让平台增长的了。

---

### (00:16:02) Maya Prohovnik

**English:**
Yes, exactly.

**中文翻译:**
是的，没错。

---

### (00:16:04) Lenny

**English:**
Very unscalable, hands to hand combat at parties. I get it. Okay. One thing you mentioned about being maybe the only listen of your coworkers podcast reminds me there's this platform where you could find Spotify music that has never ever been played once and you could be their first play and just go through.

**中文翻译:**
非常不可扩展（unscalable）的方式，在派对上短兵相接。我懂了。好。你提到你可能是同事播客的唯一听众，这让我想起有一个平台，你可以在上面找到 Spotify 上从未被播放过一次的音乐，你可以成为他们的第一个听众，然后一首接一首地听。

---

### (00:16:22) Maya Prohovnik

**English:**
That is so cool.

**中文翻译:**
那太酷了。

---

### (00:16:24) Lenny

**English:**
It's very touching, right?

**中文翻译:**
非常感人，对吧？

---

### (00:16:25) Maya Prohovnik

**English:**
Yes. I haven't seen that and now I'm like, how can we productize that for podcasters? That's such a cool thing.

**中文翻译:**
是的。我还没见过那个，现在我在想，我们怎么能为播客主把这个功能产品化？这真是件很酷的事情。

---

### (00:16:31) Lenny

**English:**
Anyway, another area that I've heard you're really strong at and came up with Wilma and a few other people I talked to is you find a really good balance between being very data-driven and also very gut driven, and this is something a lot of product leaders try to get better at. And so I'm curious just what have you learned about try to find that balance and also is there an example of something where you went against the data and went with your gut and it worked out.

**中文翻译:**
言归正传，我听 Wilma 和其他几个我聊过的人说，你非常擅长的另一个领域是：在“数据驱动”和“直觉驱动”之间找到了很好的平衡。这是很多产品领导者都想提高的能力。所以我很好奇，关于寻找这种平衡你学到了什么？有没有什么例子是你违背了数据，凭直觉行事，结果却成功了的？

---

### (00:16:58) Maya Prohovnik

**English:**
If you remember the old days of the internet, I feel like there was really this different way of thinking about product development where it was so much more about what felt good and what made you feel something as a user in that product. And so it's like we used to be a lot more playful I think with software. I think we used to put a lot more emphasis on things like delightful animations or fun little Easter eggs, and I am not sure when or where that got lost, but it feels like product management as a role has gotten formalized and become a little bit more scientific, I'm generalizing, but I think a lot of product managers can be so focused on using the right frameworks and making sure that they have the right roadmap and all of this stuff.

**中文翻译:**
如果你还记得早期的互联网，我觉得那时候的产品开发思维真的很不一样，更多的是关于什么感觉好，以及作为用户在产品中感受到了什么。所以我觉得我们以前对软件的态度要有趣得多。我想我们以前更强调令人愉悦的动画或有趣的小彩蛋之类的东西。我不确定这些东西是什么时候、在哪里丢失的，但感觉产品经理这个角色已经变得正式化，甚至有点过于科学化了。我是在泛指，但我认为很多产品经理太专注于使用正确的框架，确保拥有正确的路线图等等。

---

### (00:17:37) Maya Prohovnik

**English:**
And then it's like you find yourself in this cycle where you're just building things to build them and not really thinking about the connection to the end user. I think data is amazing and I'm like, we have such an incredible insights team at Spotify, both my insights team and then the broader one. I think we are so lucky and we have so much knowledge about our users and different cohorts and what people need and what they're missing, and so I think that's extremely valuable. I think where people get into trouble is when they think that they can rely solely on the data. And so what I spend a lot of time talking to my team about is how we can balance that. So thinking about, I guess a couple general things I would say are there are right and wrong times I think for both for your gut and for data. And then there are lots of different kinds of data and different ways to use that data.

**中文翻译:**
然后你就会发现自己陷入了一个循环：为了构建而构建，而没有真正思考与最终用户的联系。我认为数据非常棒，我们在 Spotify 有非常出色的洞察（insights）团队，包括我的团队和整个公司的团队。我觉得我们很幸运，拥有关于用户、不同群体、用户需求以及他们缺失什么的丰富知识，我认为这非常有价值。我认为人们陷入麻烦的地方在于，他们认为可以完全依赖数据。所以我花很多时间与团队讨论如何平衡这一点。我想我会说几点通用的：我认为直觉和数据都有各自适用和不适用的时机。而且数据有很多种，使用数据的方法也多种多样。

---

### (00:18:21) Maya Prohovnik

**English:**
So I think when you're in the trap of just being like, well, this is the process we always have with insights and we're just going to run this every time we have a feature, I don't think you're going to have a great time. I think if you think of it as part of the creative process as a PM where you're like, I have a hypothesis, I have some data that is helping me understand that hypothesis in the first place or form it in the first place, then I'm going to do some user research and try a couple of things and see what works for people. Then I'm going to make sure that we have success metrics and that we know what we're looking for when we launch, then we're going to follow, et cetera. So I think there's different times and places for all the different types of data collection that you can do.

**中文翻译:**
所以我觉得，如果你陷入了“这就是我们处理洞察的固定流程，每次有新功能我们就跑一遍流程”的陷阱，那你不会过得很愉快。我认为，如果你把它看作产品经理创意过程的一部分，比如：“我有一个假设，我有一些数据在最初帮助我理解或形成了这个假设，然后我要做一些用户研究，尝试几件事，看看什么对人们有效。接着我要确保我们有成功指标，知道发布时我们要看什么，然后我们会跟进等等。”所以，我认为各种不同类型的数据收集都有其适用的时间和场合。

---

### (00:18:58) Maya Prohovnik

**English:**
The other thing I would say is something that I have had to learn as a leader, especially as part of a larger organization, when we were a startup Anchor was like 20 people when we got acquired by Spotify. And by the way, Spotify is my first big tech company, so I've always been at startups, so I've learned a lot about that. But when I was leading product at a startup, it's like we're a small team, we're really focused on moving quickly. There isn't a whole lot of stopping to ask what data is supporting this or it's just like we talked to some users and we're like, great, that's a problem. We're just going to go and fix it. And I think at Spotify there's obviously at places like Spotify, I mean, large organizations, there's obviously a lot more people that you need to coordinate.

**中文翻译:**
我想说的另一件事是，作为一名领导者，尤其是在大型组织中，我必须学习的一些东西。当我们还是初创公司 Anchor 时，被 Spotify 收购时大约只有 20 人。顺便说一下，Spotify 是我待过的第一家大科技公司，我以前一直在初创公司，所以我学到了很多。但在初创公司领导产品时，团队很小，我们非常专注于快速行动。不会停下来问“有什么数据支持这个”，通常就是我们和一些用户聊了聊，觉得“太好了，这是个问题，我们去修好它”。而在 Spotify 这样的大型组织中，显然有更多的人需要协调。

---

### (00:19:38) Maya Prohovnik

**English:**
There's a lot of people you have to influence that aren't on your immediate team. And so I think something that I've had to learn is that being gut driven isn't the same as just saying to people, I told you or I believe this, so you have to do it. There really is an art I think to balancing that. And I think that what I try to do is always still as objectively as possible explain why my gut is feeling that way. So it's like you can refer back to your years of experience or other things that you've done that have been similar. You can talk about your experience as a user testing this stuff. You can bring in stories and anecdotes from users to help back it up. And so I have found that that works obviously a lot better.

**中文翻译:**
你必须影响很多不在你直接团队中的人。所以我必须学到的一点是，“直觉驱动”并不等同于直接对人说“我告诉过你”或者“我相信这个，所以你必须这么做”。我认为平衡这一点确实是一门艺术。我尝试做的是，始终尽可能客观地解释为什么我的直觉会有那种感觉。比如，你可以回顾你多年的经验，或者你做过的类似事情；你可以谈谈作为用户测试这些东西的体验；你可以引入用户的故事和轶事来支持它。我发现这种做法显然效果好得多。

---

### (00:20:18) Maya Prohovnik

**English:**
And I think that in the times that either I have done this or I've seen other leaders do it, where they're just like, well, we're just going to do it this way even if you guys don't agree or if the data says something different, those projects are always immediately doomed from the beginning. They're never going to work. You can't drag all these people through something that they don't believe in. So I think I would think of your gut actually as a type of data and I think it's a totally valid one and it's just I think you need to be clear that that's what you're working with, but then it should be taken as seriously as any other data point. So I try and think of it that way where it's like this should all ideally work together. And obviously the more data you have and the more types of data you have, the more convincing you're going to be and the more right you're going to be.

**中文翻译:**
我认为，无论是我自己还是我看到的其他领导者，如果只是说“不管你们同不同意，或者数据怎么说，我们就是要这么做”，那些项目从一开始就注定失败。它们永远不会成功。你不能强迫所有人去做一件他们不相信的事情。所以我认为，你应该把直觉看作一种数据类型，而且我认为它是完全有效的。只是你需要明确你正在使用的是直觉，但它应该像任何其他数据点一样被认真对待。所以我尝试这样去思考：理想情况下，所有这些都应该协同工作。显然，你拥有的数据越多、类型越丰富，你就越有说服力，也就越可能是正确的。

---

### (00:20:56) Maya Prohovnik

**English:**
So I think it all helps. There were so many of these in the early days of Anchor because I don't even know, I don't think we had a data scientist until we were part of Spotify, so I think it was just engineers running queries. But there were a couple times where we had to move Anchor from 1.0 to 2.0 and then from 2.0 to 3.0, we did these big, I don't like to call them pivots, but sort of evolutions let's say, of our product or our strategy terminology also very important when you're trying to convince people of things. So when I was thinking about those big transitions for us as a team, I think both times we had these big moments with our teams where we had to get everyone on board with making these big changes. So with Anchor 1.0, I don't know if you remember, but it was actually similar to what Clubhouse I think just rebranded to more voice messaging and short form and more about connections between people.

**中文翻译:**
所以我觉得这些都有帮助。在 Anchor 早期有很多这样的例子，因为我甚至不确定我们在加入 Spotify 之前是否有数据科学家，我想当时只是工程师在跑查询语句。但有几次我们不得不将 Anchor 从 1.0 升级到 2.0，然后从 2.0 升级到 3.0。我们做了这些重大的——我不喜欢称之为“转型”（pivots），姑且称之为产品或战略的“演进”吧，当你试图说服别人时，术语也非常重要。所以当我思考团队的这些重大转型时，我想两次我们都经历了与团队沟通的重大时刻，必须让每个人都同意进行这些大改动。对于 Anchor 1.0，我不知道你是否记得，它其实类似于 Clubhouse 最近品牌重塑后的样子，更多是语音消息、短音频，以及人与人之间的连接。

---

### (00:21:50) Maya Prohovnik

**English:**
And that was the first thing we ever launched and people loved it. People were very excited about it, the data was all good. We had extremely retained users. We anecdotally, we were hearing all this stuff from users all the time that they were staying up all night to use the app, people were meeting each other and falling in love and getting married on our platform, all of these really kind of magical things and we were seeing the user base was growing consistently. But I think we had this feeling, and when I say, I mean, mostly Mike and I at the time, Mike was our CEO, that it just wasn't ever going to be big enough. And so we had this really interesting moment where the users were all telling us, there's no problem. We love this product. They were using it every day, they were coming back. It was slowly growing and we were just like, this just isn't going to get us to where we need to be, our original goal had been we wanted to democratize audio.

**中文翻译:**
那是我们推出的第一个产品，人们非常喜欢。大家都很兴奋，数据也很好。我们的用户留存率极高。我们经常听到用户说他们整晚不睡在用这个 App，人们在我们的平台上相识、相爱甚至结婚，各种神奇的事情都在发生，用户群也在持续增长。但我想我们有一种感觉——我指的是当时的 Mike 和我，Mike 是我们的 CEO——那就是这个产品永远做不大。所以我们经历了一个非常有趣的时刻：用户都在告诉我们“没问题，我们爱死这个产品了”。他们每天都在用，不断回来，用户数在缓慢增长，而我们却觉得：“这无法带我们去到想去的地方。”我们最初的目标是想让音频大众化。

---

### (00:22:42) Maya Prohovnik

**English:**
We wanted to make it something where anyone could easily tell their story, and we were like, if we keep digging ourselves into this niche that a small number of people really, really love, that's great, but that's not really the mission that we sent out set out to solve. And so the 1.0 to 2.0 transition was I think actually pretty painful because for all of those people who had been invested in 1.0, 2.0 didn't work for them. 2.0 was much more about content creation and making more of a radio station, and it was less about telling your personal story and close relationships and more about projecting and using different tools. Anyway, so we made that call I think pretty much just on gut and it was like, this is a business decision. This is where we think the next phase needs to be.

**中文翻译:**
我们想让任何人都能轻松讲述自己的故事。我们觉得，如果我们继续深挖这个只有少数人非常非常喜欢的小众市场，那固然很好，但那并不是我们出发时想要解决的使命。所以从 1.0 到 2.0 的转变其实相当痛苦，因为对于所有投入到 1.0 的人来说，2.0 对他们没用。2.0 更多是关于内容创作，更像是一个广播站，它不再侧重于讲述个人故事和亲密关系，而是更多关于传播和使用不同的工具。总之，我们当时基本上是凭直觉做的决定，觉得这是一个商业决策，是下一阶段必须走的路。

---

### (00:23:25) Maya Prohovnik

**English:**
When we built Anchor 2.0, it was a lot more like the tools that we wanted to use, even though it wasn't what the user base was asking for. So I think that's one example of sometimes it's that whole users don't always know what to ask for, they don't always know what problems they need you to solve for them. And so I think you really have to be able to hear what's behind it or really even if the data is looking okay, think about if it's heading to where you need it to go.

**中文翻译:**
当我们构建 Anchor 2.0 时，它更像是我们自己想用的工具，尽管那并不是用户群所要求的。所以这是一个例子，说明有时候用户并不总是知道该要求什么，他们并不总是知道需要你为他们解决什么问题。因此，你必须能够听出背后的深意，或者即使数据看起来还不错，也要思考它是否正朝着你预期的方向发展。

---

### (00:23:51) Lenny

**English:**
Before you move on, that's actually such an interesting story because it's so hard to have a product that's working that people love and decide to change it completely. Many founders are probably stuck in this where they're just like, hey, this is working and we're feeling some fit. Is there anything else you learned from that? Because that's a really interesting insight and it worked out in your case clearly.

**中文翻译:**
在你继续之前，这真的是个非常有趣的故事，因为拥有一款运行良好且深受用户喜爱的产品，却决定彻底改变它，这太难了。很多创始人可能都困在其中，觉得“嘿，这行得通，我们感觉到了产品市场契合度（PMF）”。关于这一点你还学到了什么吗？因为这是一个非常深刻的见解，而且在你的案例中显然成功了。

---

### (00:24:15) Maya Prohovnik

**English:**
It absolutely worked out. I mean, I think it was a terrifying transition. Us at the time, it took us a few months to build a whole new app, it takes longer now, but the whole time we were building it, we were like, we weren't sure if it was a mistake and we would go back and forth and we would feel guilty when we were talking to our users about what they wanted us to be working on. But I think it was one of those things where as soon as we launched 2.0, our numbers started shooting up and we started seeing more kinds of people were using it and people were suddenly using it in the way that we had always imagined as a replacement for the old school, very difficult to make traditional podcasts.

**中文翻译:**
绝对成功了。我的意思是，那次转型非常恐怖。当时我们花了几个月时间构建了一个全新的 App，现在可能需要更久。但在构建的过程中，我们一直不确定这是否是个错误，心情起伏不定，而且在和用户交流他们希望我们做什么时，我们会感到愧疚。但事实证明，一旦我们推出了 2.0，我们的数据就开始飙升，我们看到更多类型的人在使用它，人们突然开始以我们一直想象的方式使用它——作为那些制作难度极大的传统播客的替代品。

---

### (00:24:50) Maya Prohovnik

**English:**
I don't know. I guess the lesson is you have to be able to tell the signal through the noise, and even if you've got lots of vocal users asking for something, we used to have this rule, the 80/20 rule, where it's like you can't just build for that 20, I don't think we made this up by the way. I think this is a common thing, but we'd always refer to it and say, we want to be building for the 80%, and even though the 20% are going to be more vocal, that's just going to get you deeper into that hole of that problem of you're not really building for everyone. And I think particularly when you're trying to build a creative platform, you're trying to democratize something and your target user is everyone on the planet. I think you really have to be willing to kill your darlings and let things go when they're not getting where you need them to be.

**中文翻译:**
我不知道。我想教训是，你必须能够从噪音中辨别信号。即使有很多活跃用户在要求某些东西，我们以前有一个规则，即 80/20 规则，意思是你不能只为那 20% 的人构建产品。顺便说一下，我不认为这是我们发明的，这很常见，但我们总是引用它并说，我们要为那 80% 的人构建。尽管那 20% 的人声音更大，但如果只听他们的，你就会陷入“没有真正为所有人构建”的泥潭。我认为，特别是当你试图构建一个创意平台、试图让某样东西大众化，且你的目标用户是地球上的每一个人时，你必须愿意“忍痛割爱”（kill your darlings），当某些东西无法带你去到目的地时，果断放弃它们。

---

### (00:25:35) Lenny

**English:**
That's probably the most common cases. Something is working, but it's not working incredibly well. What do we do? And so that's really interesting. I feel like the first thing you said there is really important of just we had a much bigger mission and vision, and even though this is working, this is never going to get there. There's no path to building a massive business.

**中文翻译:**
这可能是最常见的情况：某样东西在运作，但运作得不够好。我们该怎么办？这真的很有趣。我觉得你刚才说的第一点非常重要：我们有一个更宏大的使命和愿景，即使目前这个行得通，它也永远无法达到那个高度，没有通往建立庞大业务的路径。

---

### (00:25:52) Maya Prohovnik

**English:**
I do think that's so important, and I give a lot of credit to Mike and our co-founders. I think they really knew what they wanted to do when they started the company and they were very firm on that and never varied that throughout the years throughout the acquisition. And so I do think not everyone's goal is to build a massive multi-billion dollar world changing business, that's okay if that's not your goal, but if that is your goal, you have to stick to it and it's really hard, but you have to keep pivoting to get to where you want to be.

**中文翻译:**
我确实认为这非常重要，这要归功于 Mike 和我们的联合创始人。我想他们在创立公司时就非常清楚自己想做什么，并且多年来，甚至在整个收购过程中，都非常坚定，从未动摇。所以我认为，并不是每个人的目标都是建立一个价值数十亿美元、改变世界的庞大业务，如果那不是你的目标也没关系。但如果那是你的目标，你就必须坚持下去，这很难，但你必须不断调整方向（pivoting）以达到你想去的地方。

---

### (00:26:21) Lenny

**English:**
Kill your darlings. I love that phrase, I use it all the time. I think you had a second example. I have a couple other questions of Anchor, but did you want to share another example?

**中文翻译:**
“忍痛割爱”。我喜欢这个词，我经常用。我想你还有第二个例子。关于 Anchor 我还有几个其他问题，但你想再分享一个例子吗？

---

### (00:26:28) Maya Prohovnik

**English:**
Sure, I can just quickly, my second example was, so we actually had to do it again. So we went from Anchor 1.0 to 2.0, we were like, that was totally the right call. And then Anchor 2.0, we were still in this phase where we would always joke about it because people would be like, "Oh, it's kind of like making a podcast." And we would be like, it's not a podcast because we're trying to be bigger than podcasts. Because we were at the time, 2015, there were still so few people podcasting, it was still so hard to do. And so we originally were really stuck on this idea that podcasting was going to be limiting and that we wanted to be the next thing. In the early days of Anchor, we had all this nautical terminology, so we would call them waves and I don't remember what else, but we had cute nautical terms for everything we were trying to resist podcast and podcaster and those things.

**中文翻译:**
当然，我可以快速说一下。我的第二个例子是，我们实际上不得不又做了一次。我们从 Anchor 1.0 升级到 2.0，当时觉得这绝对是正确的决定。但在 Anchor 2.0 阶段，我们仍然处于一种状态，我们总是开玩笑，因为人们会说：“噢，这有点像做播客。”而我们会反驳说：“这不是播客，因为我们想做得比播客更大。”因为在 2015 年那个时候，做播客的人还很少，而且很难做。所以我们最初固执地认为播客会有局限性，我们想成为“下一代产品”。在 Anchor 早期，我们使用了大量的航海术语，比如我们把音频叫作“浪潮”（waves），还有其他的，我记不清了，但我们给所有东西都起了可爱的航海术语，试图抵制“播客”（podcast）和“播客主”（podcaster）这些词。

---

### (00:27:11) Maya Prohovnik

**English:**
And when we launched Anchor 2.0, we started getting all of this really great traction and the number one feature requests that we got from people is they were like, great, I love using these tools and then I want to export it as a podcast and publish it and get people listening that way. And we resisted it for probably, I don't know, six months or something and we were like, absolutely not, that's not what we're doing. And I think that one was such an interesting lesson because we had just learned that we did the right thing by not listening to our users. So for a while we dug in and we were like, that's not the direction we're going in, they don't know what they actually want. And then when we decided, I think we started with like, oh, we'll do a little test and let people export us podcasts and see what happens.

**中文翻译:**
当我们推出 Anchor 2.0 时，我们开始获得非常好的反响，而人们排在第一位的功能需求是：“太棒了，我喜欢用这些工具，然后我想把它导出为播客并发布，让人们通过那种方式收听。”我们抵制了这个需求大概六个月左右，我们说：“绝对不行，那不是我们要做的。”我认为那是一个非常有趣的教训，因为我们刚刚学到“不听用户的意见是正确的”。所以有一段时间我们固执己见，觉得“那不是我们要走的方向，他们不知道自己真正想要什么”。后来我们决定，我想是从一个小测试开始的，比如“好吧，我们做一个小测试，让人们导出为播客，看看会发生什么”。

---

### (00:27:48) Maya Prohovnik

**English:**
And when we look back at our data, that's the moment when we saw the beginning of that hockey stick growth where it's like we had been growing, we had been doing well, and then you zoom out and you're like, okay, that was very clearly the thing we were missing. Yet again, we had to stop what we were doing, we rebuilt the entire app, we built it around RSS and podcasting and being able to export. And we actually did some really cool things to make it really easy for people to publish their podcast everywhere. So I think that was really the moment that it took off. And I think it's so interesting putting those two things together because it was the opposite thing the second time that we had to give up on a piece of what we had thought was so inherently true about our business.

**中文翻译:**
当我们回顾数据时，发现那正是“曲棍球棒式增长”开始的时刻。在那之前我们一直在增长，表现不错，但当你放大看时，你会发现：好吧，那显然就是我们缺失的东西。于是，我们再次停下手中的工作，重新构建了整个 App，围绕 RSS、播客和导出功能进行构建。我们还做了一些非常酷的事情，让人们能非常容易地将播客发布到任何地方。我想那才是真正腾飞的时刻。把这两件事放在一起看非常有趣，因为第二次我们不得不放弃的，正是我们认为对业务而言“天经地义”的真理，这与第一次的情况恰恰相反。

---

### (00:28:28) Maya Prohovnik

**English:**
And so I don't know what lesson to tell people to take away from that other than I think you have to just stay, especially in a startup mentality, you have to stay willing to be flexible and take in new information and new data points as your product matures and as your user base changes, there's going to be new things that you learn that are going to change how you think about it. And I think again, the one thing that was unwavering for us was our mission and everything else was mutable for us where we were like, whatever we need to do to get there will work. And I do think looking back, it's astonishing how brave we were that we kept finding some product market fit and being like, nope, that's not enough. And then moving to the next thing. And I think that obviously worked out really well for us and meant that we were able to do what we set out to do and really democratize the medium and make things a lot easier for a lot more people.

**中文翻译:**
所以我不知道该让人们从中吸取什么教训，除了我认为你必须保持——特别是在初创公司心态下——保持灵活的意愿，随着产品的成熟和用户群的变化，不断吸收新的信息和数据点。你会学到新的东西，从而改变你的看法。我想再次强调，对我们来说唯一动摇不了的是使命，其他一切都是可以改变的，只要能达到目标，做什么都行。回过头来看，我觉得我们当时非常勇敢，不断找到一些产品市场契合度，然后说“不，这还不够”，接着转向下一件事。显然，这最终对我们非常有效，意味着我们能够实现初衷，真正让这种媒介大众化，让更多人的创作变得更容易。

---

### (00:29:15) Lenny

**English:**
I think another lesson there is just try stuff. Like you said, you tried this export thing, let's just see what happens. No, we don't think this is where we need to go, but let's just try it and maybe it'll work. And clearly that became the core of the product and platform.

**中文翻译:**
我想另一个教训就是“去尝试”。就像你说的，你们尝试了导出功能，心想“看看会发生什么”。虽然我们不认为这是我们要走的方向，但试试看，也许行得通。显然，那后来成了产品和平台的核心。

---

### (00:29:27) Maya Prohovnik

**English:**
Totally. And also, you never know which of those tiny product changes are going to end up being this existential moment for your business. You really have to keep your eyes open and be ready for that to happen anytime, especially when you're still trying to figure out where your place is going to be.

**中文翻译:**
完全正确。而且，你永远不知道哪些微小的产品改动最终会成为业务的生死存亡时刻。你必须保持警觉，随时准备好迎接这种情况的发生，尤其是当你还在摸索自己的定位时。

---

### (00:29:42) Lenny

**English:**
You mentioned there was this feature that made it easy to distribute your podcast, and this touches on a question that actually asked Mike Mignano, the CEO of anchor what to ask you. And he's like, ask her about the story of how you made that actually possible to distribute the podcast to platforms, and it ended up being a very unscalable solution.

**中文翻译:**
你提到有一个功能让分发播客变得很容易，这涉及到一个问题，我其实问过 Anchor 的 CEO Mike Mignano 该问你什么。他说：问问她关于你们是如何真正实现将播客分发到各个平台的，以及那个方案最终是如何变成一个非常“不可扩展”的方案的。

---

### (00:30:00) Maya Prohovnik

**English:**
One of our principles from the very early days of Anchor was build things that don't scale, where we were like, we're a ridiculously tiny team. We're trying to do this really big thing. We had raised very little money, and so we were always just trying to figure out how can we hack into whatever growth we're trying to make happen. So when it turned out that people wanted to distribute their podcasts everywhere, it's gotten a little bit easier. But at the time, I'm sure you remember what podcast distribution was like, where it's like there's all of these different podcast platforms you have to manually distribute to all of them. Apple Podcasts in particular can be really difficult for people who aren't tech-savvy because there's this whole, you have to prove that you own your RSS feed, you have to know what an RSS feed is.

**中文翻译:**
Anchor 早期的一个原则就是“做那些不可扩展的事情”（build things that don't scale）。当时我们是一个极小的团队，却试图做一件大事。我们筹到的钱很少，所以我们总是在想如何通过“黑客手段”实现我们想要的增长。当发现人们想把播客分发到各个地方时，虽然现在容易了一些，但当时，我敢肯定你记得播客分发是什么样子的：有这么多不同的播客平台，你必须手动分发到每一个平台。特别是 Apple Podcasts，对于不懂技术的人来说非常困难，因为你必须证明你拥有自己的 RSS 提送（RSS feed），你还得知道什么是 RSS 提送。

---

### (00:30:44) Maya Prohovnik

**English:**
You have to sometimes deal with 301 redirects. There's just all this stuff that's deeply technical in a way that we were just like it doesn't need to be. And so one of the steps there was to submit your podcast to Apple Podcasts, you had to have an Apple ID, and there are a lot of people in the world who don't have iPhones, and so we're building for everybody. So we were like, how can we reduce that friction? We were obsessed with reducing friction, this was our constant battle. And so we had this idea, we hired a couple of college interns and we brought them in and we were like, people are going to push this magical one button in the Anchor app and they're going to say, I want to distribute my podcast, and your job is going to be to do all that same manual stuff manually, but to them it's going to feel magical and it happened automatically. I still don't know how many people know this.

**中文翻译:**
有时你还得处理 301 重定向。所有这些东西都非常技术化，而我们觉得没必要这么复杂。其中一个步骤是，要将播客提交到 Apple Podcasts，你必须有一个 Apple ID。世界上有很多人没有 iPhone，而我们要为所有人构建产品。所以我们想：如何减少这种摩擦？我们痴迷于减少摩擦，这是我们持久的战斗。于是我们有了个主意，雇了几个大学生实习生，把他们招进来后说：用户在 Anchor 应用里按下一个神奇的按钮，说“我想分发我的播客”，而你们的工作就是手动完成所有那些繁琐的手动操作。但对用户来说，这感觉就像魔法一样，是自动完成的。我至今不知道有多少人知道这件事。

---

### (00:31:27) Maya Prohovnik

**English:**
I think people think that we had some secret backdoor deal with Apple for distribution, but we just had college students making Apple podcast accounts and then submitting hundreds of thousands of podcasts through these accounts. And that resulted in lots of interesting technical and relationship situations. It was a really interesting thing, and eventually that didn't scale, eventually we stopped doing that, obviously, but I think that is such a cool example of the importance of how you're packaging what you're offering to people where if we had said you request distribution and we'll have one of our team members get back to you in three days and let you know when you're on Apple Podcasts, that doesn't feel very magical or it's really saving you any time. If all you see as a user is you're hitting a button and then 24 hours later you're somehow magically on Apple Podcasts, that was so much easier than manual distribution was at the time.

**中文翻译:**
我想人们可能以为我们和苹果在分发上有某种秘密的后门协议，但实际上我们只是让大学生们不停地创建苹果播客账号，然后通过这些账号提交了成千上万个播客。这导致了很多有趣的技术和关系问题。这是一件非常有趣的事情，最终它确实无法扩展，显然我们后来停止了这种做法。但我认为这是一个极好的例子，说明了如何包装你提供给用户的东西的重要性。如果我们说“你申请分发，我们的团队成员会在三天内回复你，并告知你何时上线 Apple Podcasts”，那感觉一点也不神奇，也没有真正为你节省时间。但如果作为用户，你看到的只是按下一个按钮，24 小时后你就神奇地出现在 Apple Podcasts 上了，那比当时的手动分发要容易得多。

---

### (00:32:20) Maya Prohovnik

**English:**
And I think that was a really big part of why we got so much hosting market share so quickly because it was such an insane benefit over the other platforms which otherwise had been commoditized at that point. So, it's funny now to think back on that, but I think it's also related to we were so good at being willing to humor what seemed like stupid ideas and try them. And so that is something that I definitely recommend to product people is let yourself have the silly ideas we always talked about yes and when someone has an idea, how can you build on it and think about how it might work instead of saying, no, that can't work because, and so we had a number of those things where it was like nobody understood how we were doing things so differently, and it was just because we weren't afraid to do the silly unscalable thing for a while.

**中文翻译:**
我认为这是我们能如此迅速获得巨大托管市场份额的一个重要原因，因为相比于当时已经同质化的其他平台，这简直是一个疯狂的优势。现在回想起来很有趣，但我觉得这也与我们善于接纳那些看起来很蠢的想法并去尝试有关。所以我绝对向产品人推荐这一点：允许自己产生愚蠢的想法。我们总是谈论“Yes, and”（即兴表演术语，指接受并延伸），当有人提出一个想法时，想想如何在此基础上构建，思考它可能如何运作，而不是说“不，那行不通，因为……”。我们做过很多这样的事，当时没人理解为什么我们做得如此不同，其实只是因为我们不害怕在一段时间内去做那些愚蠢且不可扩展的事情。

---

### (00:33:08) Lenny

**English:**
I love that story. Touches on two things, one is I was just doing an interview around how to drive word to mouth growth and make that a big driver of your growth. And the main message there is just make something remarkable and knock people's socks off that they're just like, oh wow, this is crazy, I'm going to share it with my friend. And that's such a good example of that where everyone's like, wow, that was easy, I'm going to tell all my other friends that are launching podcasts. The other is, I wonder just how much of tech is built off of college interns, the beginnings of companies or how important college interns are to technology and innovation. It feels like there's always an intern story.

**中文翻译:**
我喜欢这个故事。它涉及两点：一是，我最近刚做了一个关于如何驱动口碑增长并使其成为增长主要动力的采访。核心信息就是：做一些非凡的事情，让人们惊掉下巴，让他们觉得“哇，这太疯狂了，我要分享给我的朋友”。这就是一个很好的例子，每个人都会觉得“哇，太简单了，我要告诉所有其他准备做播客的朋友”。另一点是，我在想科技行业有多少东西是靠大学生实习生建立起来的，无论是公司的初创阶段，还是实习生对技术和创新的重要性。感觉总会有一个关于实习生的故事。

---

### (00:33:42) Maya Prohovnik

**English:**
Yeah, I know. I think they must be. And for the record, we paid them very well, these were not unpaid interns, just to be clear. But no, I think it is amazing, and I think it was also such a cool opportunity. One of those interns actually is still a PM on my team today. She ended up converting a full-time after she graduated. And I remember I had a lot of cool college internships and it's such a cool way to get exposure to industries that you otherwise wouldn't get to. So I would definitely recommend that college kids start with, it's okay if your first job is like a repetitive, not very exciting thing. If you do a good job, it will lead to something very exciting maybe.

**中文翻译:**
是的，我知道。我想肯定是的。顺便说一下，我们给他们的报酬非常丰厚，他们不是无薪实习生，澄清一下。但不，我觉得这很神奇，而且这也是一个非常酷的机会。其中一名实习生现在仍然是我团队里的产品经理，她毕业后转成了全职。我记得我大学时也有很多很酷的实习经历，这是接触那些你原本无法接触到的行业的绝佳方式。所以我绝对建议大学生们从基层做起，即使你的第一份工作是重复性的、不太令人兴奋的事情也没关系。如果你做得好，它可能会带你走向非常令人兴奋的事情。

---

### (00:34:15) Lenny

**English:**
I love that. Imagine a place where you can find all your potential customers and get your message in front of them in a cost-efficient way. If you're a B2B business, that place exists, and it's called LinkedIn. LinkedIn ads allows you to build the right relationships, drive results, and reach your customers in a respectful environment. Two of my portfolio companies, Webflow and Census, are LinkedIn success stories. Census had a 10x increase in pipeline with a LinkedIn startup team for Webflow after ramping up on LinkedIn and Q4, they had the highest marketing source revenue quarter to date. With LinkedIn ads you'll have direct access to and can build relationships with decision makers including 950 million members, 180 million senior execs and over 10 million C-level executives. You'll be able to drive results with targeting and measurement tools built specifically for B2B. In tech, LinkedIn generated two to 5x higher return on ad spend than any other social media platforms.

**中文翻译:**
我喜欢这个。想象一下，有一个地方你可以找到所有潜在客户，并以极具成本效益的方式将你的信息呈现在他们面前。如果你是一家 B2B 企业，那个地方确实存在，它就是 LinkedIn。LinkedIn 广告让你能够建立正确的关系、驱动结果，并在一个相互尊重的环境中触达客户。我的两家投资组合公司 Webflow 和 Census 都是 LinkedIn 的成功案例。Census 通过 LinkedIn 创业团队实现了销售线索（pipeline）10 倍的增长；Webflow 在第四季度加大 LinkedIn 投入后，实现了迄今为止最高的营销来源收入季度。通过 LinkedIn 广告，你可以直接接触并与决策者建立关系，包括 9.5 亿会员、1.8 亿高级管理人员和超过 1000 万 C 级高管。你将能够利用专门为 B2B 构建的定位和衡量工具来驱动结果。在科技领域，LinkedIn 产生的广告支出回报率（ROAS）比任何其他社交媒体平台高出 2 到 5 倍。

---

### (00:35:14) Lenny

**English:**
Audiences on LinkedIn have two times the buying power of the average web audience, and you'll work with a partner who respects the B2B world you operate in make B2B marketing everything it can be and get $100 credit on your next campaign. Just go to linkedin.com/podlenny to claim your credit. That's linkedin.com/podlenny. Terms and conditions apply. So we've been talking about Anchor and I think what's really interesting about Anchor is it's one of the very rare success stories of an acquisition working out incredibly well. It was a small startup now powering two thirds of all new podcasts. It's pretty insane. So I want to spend a little time on just what worked in making that possible. So let me ask first around the integration piece, just how you integrated successfully, and then I want to talk about just operationalizing and making it continue running successfully.

**中文翻译:**
LinkedIn 上的受众购买力是普通网络受众的两倍，你将与一个尊重你所处 B2B 世界的伙伴合作，让 B2B 营销发挥最大潜力，并在下一次活动中获得 100 美元的抵用金。只需访问 linkedin.com/podlenny 即可领取。网址是 linkedin.com/podlenny。受条款和条件约束。我们一直在聊 Anchor，我觉得 Anchor 非常有趣的一点是，它是极少数收购非常成功的案例之一。它曾是一家小型初创公司，现在支持着全球三分之二的新播客。这相当疯狂。所以我想花点时间探讨一下是什么促成了这种成功。首先我想问关于整合的部分，你们是如何成功整合的，然后我想聊聊如何将其制度化并使其持续成功运行。

---

### (00:36:03) Maya Prohovnik

**English:**
Totally.

**中文翻译:**
完全同意。

---

### (00:36:04) Maya Prohovnik

**English:**
I think it's a combination of luck and hard work because Spotify is genuinely an amazing company. I mean, you've met now a bunch of people who I work with at Spotify, including my boss, Gustav. It's an incredible company. They're Swedish. So just their mindset about everything in the first place is amazing. But also, I have been so impressed that they are the type of company that can still move quickly and make really big strategic decisions and strategic shifts. It never feels like they're slowing down. And so I think our way of working worked with them. And then I think the other thing that we had to our benefit was they really saw the same vision that we had. So it was like they also wanted to change podcasting and make it more democratized and make it more two-way and bring it into the future.

**中文翻译:**
我认为这是运气和努力的结合，因为 Spotify 真的是一家了不起的公司。我的意思是，你现在已经见过很多我在 Spotify 的同事了，包括我的老板 Gustav。这是一家令人难以置信的公司。他们是瑞典公司，所以他们看待一切事物的思维方式本身就很棒。而且，让我印象深刻的是，他们是那种仍然能够快速行动、做出重大战略决策和战略转型的公司。感觉他们从未慢下来。所以我觉得我们的工作方式与他们很契合。另一件对我们有利的事情是，他们确实看到了与我们相同的愿景。他们也想改变播客，让它更大众化、更具互动性，并带向未来。

---

### (00:36:53) Maya Prohovnik

**English:**
And it was so interesting because when we started talking to them, both of us had this chicken or egg marketplace problem where we had this critical mass of creators. They had a critical mass at that point of consumers, but if you don't have both on the same place, then you're still stuck with the limitations of RSS feeds. And so I think we were both coming at the acquisition with the same frustration just from two different angles. And so both of us really saw that benefit in joining up. And so I think one of the big ways we were lucky is that what I've seen happen in a lot of acquisitions is you have an idea of what you're getting acquired for and you get excited and really attached to that vision, and then when that vision doesn't end up fitting into the company strategy, there's nowhere else to go.

**中文翻译:**
这非常有趣，因为当我们开始与他们交谈时，我们双方都面临着这种“鸡生蛋蛋生鸡”的市场问题：我们拥有大量的创作者，而他们当时拥有大量的消费者，但如果你不把两者放在同一个地方，你仍然会受限于 RSS 提送的局限性。所以我觉得我们双方都是带着同样的挫败感来看待这次收购的，只是角度不同。因此，我们双方都看到了合并的好处。我认为我们幸运的一个重要方面是，我在很多收购中看到的情况是：你对被收购后的愿景有一个想法，你对此感到兴奋并深信不疑，但当这个愿景最终与公司的整体战略不匹配时，你就无路可走了。

---

### (00:37:34) Maya Prohovnik

**English:**
And I think in a lot of ways Anchor did really well fit into Spotify's culture and their roadmap, but there were many things that changed around that initial vision. And I think we were really good at making sure that we stayed valuable to Spotify. That was one of our goals when we got acquired where we were like, we're tiny startup people, and we're like, we're not going to get lost in this big sea. When we came in, it was like we were very vocal about everything that we were doing, we did lots of internal marketing and made sure people were excited. We built a lot of really strong relationships. We made sure that every team at Spotify knew about us and what we were doing. We were constantly asking how we could help other teams. And when the strategy shifted, which it has dozens of times since we've gotten acquired almost five years ago, not like we just blindly followed, but we were always willing to get excited about whatever the next thing was and willing to be helpful and figure out how to make that work.

**中文翻译:**
我认为在很多方面，Anchor 非常契合 Spotify 的文化和路线图，但围绕最初愿景的很多事情都发生了变化。我认为我们非常擅长确保自己对 Spotify 持续产生价值。这是我们被收购时的目标之一，我们当时想：我们是微小的初创公司员工，我们不能迷失在这片汪洋大海中。当我们加入时，我们对所做的一切都非常直言不讳，我们做了大量的内部营销，确保大家感到兴奋。我们建立了许多非常牢固的关系。我们确保 Spotify 的每个团队都知道我们以及我们在做什么。我们不断询问如何帮助其他团队。当战略发生转变时——自从我们五年前被收购以来，战略已经转变了几十次——我们并不是盲目跟随，而是始终愿意对下一件事感到兴奋，愿意提供帮助并弄清楚如何让它奏效。

---

### (00:38:30) Maya Prohovnik

**English:**
And I think it actually goes back to the sticking to the mission in the first place where Spotify and we want podcasting to be able to be a huge business for the industry. We think it's been held back by a lot of things for a long time. And so we've had various hypotheses about how we can get there and we try things and if something doesn't work, we go onto the next thing. But that goal hasn't really changed.

**中文翻译:**
我认为这实际上又回到了最初坚持使命的问题上：Spotify 和我们都希望播客能成为该行业的一项巨大业务。我们认为它长期以来受到很多因素的阻碍。因此，我们对于如何实现这一目标有各种假设，我们会去尝试，如果行不通，就转向下一件事。但那个目标从未真正改变。

---

### (00:38:55) Lenny

**English:**
That makes a lot of sense. And I love the idea of just staying excited about what is happening. I think a lot of founders join and they're like, "Oh, it's so annoying to work in this big company." "Oh man, we have this original plan, it's just not happening." And I think even if you're probably not, even if you're not excited, I think it's effective to communicate that you're excited and be on board and then shift things in what direction you think maybe needs to go instead.

**中文翻译:**
这很有道理。我喜欢“对正在发生的事情保持兴奋”这个想法。我想很多创始人加入大公司后会觉得：“噢，在大公司工作太烦了。”“噢，天哪，我们原本有计划，但现在没法实现了。”我认为即使你内心可能并不兴奋，传达出你很兴奋并全力支持的态度也是有效的，然后再把你认为需要调整的方向慢慢引导过去。

---

### (00:39:19) Maya Prohovnik

**English:**
Totally, yeah.

**中文翻译:**
完全正确。

---

### (00:39:20) Lenny

**English:**
Okay. And then in terms of operating within Spotify, from what I understand, your team is still very startupy and there's this really fast moving mentality. What have you learned and how do you do that? How do you make that happen within a larger company?

**中文翻译:**
好。那么关于在 Spotify 内部运作，据我了解，你的团队仍然非常有初创公司的感觉，有一种快速行动的心态。关于这一点你学到了什么？你是怎么做到的？你如何在一家大公司内部实现这一点？

---

### (00:39:34) Maya Prohovnik

**English:**
We've definitely slowed down a little, I will say. I'm always joking about when we first got acquired, I remember we had to do this spreadsheet outlining our roadmap and estimate are things like small, extra large, whatever, and Spotify's definition of small with something like a quarter. And I was like, we've never built anything that took more than three months. And now it's like now we build lots of things to take more than three months. But the first thing that comes to mind, so when we were a startup, one of the first things we did when we were only a few people, we decided what our core values were going to be. And I think they maybe very trivially have changed over the years, but we essentially still have the same four core values that we decided on seven or eight years ago now. And when we got acquired, we had a conversation with our team where we said, we're going to of course embrace Spotify's culture and Spotify's core values, but we're not going to forget who we are as a team.

**中文翻译:**
我得说，我们确实慢下来了一点。我总是开玩笑说，刚被收购时，我记得我们要做一个电子表格来概述路线图，并估算任务大小，比如“小”、“特大”之类的。Spotify 对“小”的定义大约是一个季度。我当时想：“我们从来没做过任何超过三个月的东西。”而现在，我们做的很多东西都要超过三个月。但我想到的第一件事是，当我们还是初创公司、只有几个人的时候，我们决定了我们的核心价值观。我想这些年来它们可能只有微小的变化，但本质上我们仍然持有七八年前确定的那四个核心价值观。被收购时，我们和团队进行了一次谈话，我们说：“我们当然会拥抱 Spotify 的文化和核心价值观，但我们不会忘记我们作为一个团队是谁。”

---

### (00:40:28) Maya Prohovnik

**English:**
And I think part of what really... And one of our core values by the way, is move fast. So that's something that's very deep within our DNA. But I think one of the things that helped with that is Daniel Eck, when we got acquired, came and talked to our team, which was so cool and so motivational. And one of the things he said to us was, we had a reputation at the time for moving very quickly, even compared to other startups. We were shipping a new feature every two weeks, it was insane. And Daniel said to us, not only do I want you to not move slower, that's part of why we're acquiring you so that you can move quickly. But he said, I also want you to help me teach the rest of Spotify how to move more quickly, and I found that so motivating.

**中文翻译:**
我认为其中真正起作用的部分是……顺便说一下，我们的核心价值观之一就是“快速行动”。这是深植于我们 DNA 中的东西。但我觉得对此有帮助的一件事是，当我们被收购时，Daniel Ek（Spotify CEO）来和我们的团队谈话，那非常酷且极具动力。他当时对我们说，我们当时以行动极快著称，甚至比其他初创公司还快。我们每两周发布一个新功能，简直疯了。Daniel 对我们说：“我不仅不希望你们慢下来，这正是我们收购你们的原因之一，这样你们可以继续快速行动。”他还说：“我还希望你们帮我教会 Spotify 的其他部门如何更快速地行动。”我觉得这非常有激励作用。

---

### (00:41:04) Maya Prohovnik

**English:**
Because I think I definitely had that feeling going from startup to larger organization where I had this fear that it was just going to be bureaucracy and things moving so slowly. And I really loved that. That was one of his goals was that he was like, I want to make sure Spotify also grew really quickly and he was trying to figure out how to help them keep moving as quickly as they used to. And so I think that's something that I really took to heart and that I've continued to remind my team of even to this day where I think of that as part of my job here to help people think about how we can move quickly and what really matters. And I think at any large organization, there's obviously a lot more complexities, there's a lot more stakeholders.

**中文翻译:**
因为从初创公司进入大型组织，我确实有过那种恐惧，担心到处都是官僚主义，事情进展缓慢。我真的很喜欢他的那个目标，他说他想确保 Spotify 也能快速增长，他正在想办法帮助公司保持以前那样的速度。所以我真的把这话记在了心里，直到今天我还在不断提醒我的团队。我认为我的工作之一就是帮助大家思考如何快速行动以及什么才是真正重要的。我认为在任何大型组织中，显然会有更多的复杂性，有更多的利益相关者。

---

### (00:41:42) Maya Prohovnik

**English:**
So to some extent it's necessary to slow down and be thoughtful. But I think the things that I always try to push people on is the unnecessary things that slow you down. So I think that's what we spend a lot of time on, both within our team and when we're collaborating with other teams at Spotify because we work with basically everyone at this point. So I think that was really cool that he gave us that mission when we joined.

**中文翻译:**
所以在某种程度上，慢下来并深思熟虑是必要的。但我总是试图推动大家去解决那些“不必要的”拖慢速度的事情。这就是我们花很多时间去做的事，无论是在我们团队内部，还是在与 Spotify 其他团队协作时，因为目前我们基本上和所有团队都有合作。所以我觉得他加入时给我们的那个使命真的很酷。

---

### (00:42:03) Lenny

**English:**
On that note, is there anything that has been a real challenge or become really annoying? Just real talk about the flip side of that. Everyone's always like, "Oh, it's all working out great." Is there anything you could share that's just like, "Oh wow, that was really hard and we overcame it, or a real challenge that we didn't expect?"

**中文翻译:**
说到这，有没有什么是真正的挑战，或者变得非常烦人的？咱们实话实说，聊聊另一面。大家总是说“噢，一切都进展顺利”。你能不能分享一些类似“噢，哇，那真的很难，但我们克服了”，或者“一个我们没预料到的真正挑战”？

---

### (00:42:19) Maya Prohovnik

**English:**
I think that the downside of Daniel's advice, so one of the things he said to us, he was literally say no to all the meetings. You're going to get invited to all these off sites and meetings and everyone's going to want to meet you guys and they're going to want you to come to all of these events and whatever. And he was like, just keep being Anchor. Just keep doing what you're doing for at least the next year. Don't worry about what Spotify's doing. And on the one hand, of course, we loved that as startup people we're like, cool, we're going to get to stay us within this larger organization. But the downside that we didn't really realize until a year later was that we weren't really able to build relationships. We had some culture problems where our team started to feel like because they weren't part of Spotify, they had some existential, they didn't feel attached to the work that we were doing.

**中文翻译:**
我认为 Daniel 的建议也有负面影响。他当时对我们说的一件事是：拒绝所有的会议。你会收到各种团建和会议的邀请，每个人都想见见你们，想让你们参加各种活动。他说：“就继续做 Anchor，至少在接下来的一年里继续做你们正在做的事，别担心 Spotify 在做什么。”一方面，作为初创公司的人，我们当然喜欢这样，觉得“太酷了，我们可以在这个大组织里保持自我”。但直到一年后我们才意识到负面影响：我们没能真正建立起人际关系。我们出现了一些文化问题，团队成员开始觉得因为他们不属于 Spotify，产生了一些存在主义的困惑，他们觉得与我们所做的工作没有归属感。

---

### (00:43:03) Maya Prohovnik

**English:**
And so for a year we operated on our own. We moved really quickly, we were able to get a lot done, but then I think our next phase had to be really deeply incorporating into Spotify. And so we stopped calling our team Anchor internally, we started collaborating more with other teams. And I think that is the necessary trade-off is the more deeply you're embedded, the slower things are going to go. But I think that has been really amazing for making sure that our team actually felt like a part of the larger mission that Spotify was doing. And the one other thing I'll say that I found pretty striking. So, Spotify, as you know, did a lot of podcast acquisitions soon after the Anchor one. And so I got to know a lot of the other founders and early employees who have been acquired by Spotify and something that I've found with them and just with other acquired founders who I've talked to since, I don't know, I feel like people don't talk about this enough publicly.

**中文翻译:**
所以有一年的时间我们是独立运作的。我们行动非常快，完成了很多工作，但随后我认为我们的下一个阶段必须是深度融入 Spotify。于是我们在内部不再称呼自己的团队为 Anchor，开始更多地与其他团队协作。我认为这是必要的权衡：嵌入得越深，事情进展就越慢。但我认为这对于确保我们的团队真正感觉到自己是 Spotify 宏大使命的一部分是非常棒的。还有一件事让我觉得挺震撼的。如你所知，Spotify 在收购 Anchor 之后不久又进行了很多播客相关的收购。所以我认识了很多其他被 Spotify 收购的创始人及早期员工。我从他们身上，以及后来聊过的其他被收购创始人身上发现了一件事——我不知道，我觉得大家在公开场合聊得不够多。

---

### (00:43:59) Maya Prohovnik

**English:**
Maybe people are somewhere and I just haven't seen it. I think that people who get acquired, especially founders, actually go through a relatively deep depression and existential crisis after getting acquired. And I never would've thought, when you're talking to people about getting acquired, it sounds like such an obvious positive. Like you said, it's like this amazing positive exit and it was objectively so good for our team and for us and for our users, and I think for the industry. And I personally did not expect to go through that. Because I was like of course you want an exit, that's what you're working towards that whole time that you're a startup. And I've talked to a lot of these founders and I think it is a process I think that everyone has to go through because either you decide I'm going to stay here and I'm going to do this for a long time and I can make this work for me.

**中文翻译:**
也许有人在别处聊过，只是我没看到。我认为被收购的人，尤其是创始人，在被收购后实际上会经历一段相当深重的抑郁期和存在主义危机。我以前从未想过这一点，当你和别人谈论被收购时，听起来这显然是一件好事。就像你说的，这是一个了不起的成功退出（exit），客观上对我们的团队、我们自己、我们的用户，以及整个行业都非常有好处。但我个人并没预料到会经历那个阶段。因为我觉得你当然想要一个退出，那是你作为初创公司一直努力的目标。我和很多这类创始人聊过，我认为这是一个每个人都必须经历的过程，因为你要么决定“我要留在这里，长期做下去，让它为我所用”。

---

### (00:44:44) Maya Prohovnik

**English:**
Or you're like, I'm just a startup founder and this doesn't really work for me and I'm going to go do my next thing. And so I think to some extent some of the things we were talking about, I think do help shake out whether people actually want to make those investments and figure out how to make things work at a big company. But I think the other thing that I've found is just I think there isn't enough support for that transition. And I think that for me, I've definitely landed on the side of, I love working at Spotify. I now am so excited to be part of a large organization and building things at this scale, but I really would've loved to been able to talk to someone about it or understand that there were other people going through that kind of thing.

**中文翻译:**
要么你会觉得“我只是个初创公司创始人，大公司这套不适合我，我要去做下一件事”。所以我觉得在某种程度上，我们讨论的一些事情确实有助于筛选出人们是否真的想投入精力去弄清楚如何在大公司里把事情做好。但我发现的另一件事是，我认为对于这种转型缺乏足够的支持。对我来说，我最终选择了留下来，我喜欢在 Spotify 工作。我现在非常兴奋能成为大型组织的一部分，并在这种规模上构建产品，但我真的很希望当时能有人聊聊这件事，或者让我知道也有其他人正在经历类似的事情。

---

### (00:45:25) Maya Prohovnik

**English:**
So I don't know if you want an example of how it's not all rainbows and sunshine, I definitely think there were some dark times there and I've since learned everyone goes through that just because I think just by definition, all the reasons that you start a company, that means your personality is someone who wants to be having that direct impact and having your own ownership and being able to make things move quickly, and that is just so different once you join a large organization.

**中文翻译:**
所以如果你想要一个“并非全是彩虹和阳光”的例子，我肯定认为那段时间有一些黑暗时刻。我后来了解到每个人都会经历这些，因为从定义上讲，你创业的所有原因都意味着你的性格是那种想要产生直接影响、拥有自主权并能快速行动的人，而一旦加入大型组织，情况就完全不同了。

---

### (00:45:54) Lenny

**English:**
Yeah, and those are amazing examples. I think what's interesting with startup life is eventually if things work out well, you'll either end up working for a larger company, that's a likely scenario if things tip go great or you're running a public company, which is also extremely painful and stressful.

**中文翻译:**
是的，这些例子很棒。我认为初创公司生活有趣的地方在于，如果事情进展顺利，你最终要么会为一家更大的公司工作（如果发展得非常好，这是一个很可能的场景），要么你就在经营一家上市公司，而那同样极其痛苦且压力巨大。

---

### (00:46:11) Maya Prohovnik

**English:**
Yes, exactly.

**中文翻译:**
是的，没错。

---

### (00:46:12) Lenny

**English:**
Yeah. So, the paths are hard no matter what you end up doing, as much as you love that startup time. I actually went through the same thing when we sold our company to Airbnb. I was just like, man, I had this life goal of starting a company and now I've done it and now what do I do? And it was just like, huh, okay, I guess I got to figure it out.

**中文翻译:**
是的。所以无论你最终做什么，道路都是艰难的，尽管你可能很怀念初创公司那段时光。当我们把公司卖给 Airbnb 时，我也经历过同样的事情。我当时想：伙计，我的人生目标是创办一家公司，现在我做到了，接下来我该做什么？那种感觉就是“呃，好吧，我想我得弄清楚下一步”。

---

### (00:46:29) Maya Prohovnik

**English:**
Right? It's like, who am I? And I think the thing that I think for me, and it sounds similar to you, I think I didn't realize how much value I put in the actual day-to-day of survival that comes with being part of a startup. That becomes almost your reason for being is like, I got to make this work and I got to keep the team motivated. And you're just going, going, going, and then when everything is suddenly stable, you're like, wait, what is my job now?

**中文翻译:**
对吧？就像在问“我是谁？”。我觉得对我来说——听起来和你很像——我以前没意识到我有多么看重初创公司那种每天为了生存而战的状态。那几乎成了你存在的理由：我必须让这事成，我必须让团队保持动力。你一直在冲、冲、冲，然后当一切突然稳定下来时，你会想：“等等，我现在的工作是什么？”

---

### (00:46:57) Lenny

**English:**
I saw a tweet actually recently, I forget who tweeted this, that CEOs that exit and go on vacation end up being more stressed and less healthy than running a really high stress, high growth company.

**中文翻译:**
我最近看到一条推特，忘了是谁发的了，说那些成功退出并去度假的 CEO，最终比经营一家高压力、高增长公司时压力更大、身体更不健康。

---

### (00:47:08) Maya Prohovnik

**English:**
That is wild. I get it though.

**中文翻译:**
那太疯狂了。不过我能理解。

---

### (00:47:10) Lenny

**English:**
Yeah. Although I will say when I joined Airbnb and was just the PM of our team working on one thing, it was like, this is really cool. I don't have to worry about everything all the time, there's a really nice relief to that. But yeah, there's a life existential question of just like, wow, we did the thing. What am I? What else? There's usually not a goal beyond that.

**中文翻译:**
是的。虽然我得说，当我加入 Airbnb 只是作为团队的产品经理负责一件事时，感觉“这真的很酷”。我不需要时刻担心所有事情，这确实是一种很好的解脱。但是，确实会有一个人生的存在主义问题：哇，我们做到了。我是什么？还有什么？通常在那之后就没有目标了。

---

### (00:47:31) Maya Prohovnik

**English:**
Totally.

**中文翻译:**
完全正确。

---

### (00:47:32) Lenny

**English:**
What was it for you? Was it that, was it the feeling of I had this thing that I was running and now I don't?

**中文翻译:**
对你来说是什么感觉？是那种“我曾经经营着这个东西，而现在不归我管了”的感觉吗？

---

### (00:47:37) Maya Prohovnik

**English:**
I think it was a little bit the fear of being like a cog in a wheel, which is not actually how I feel now that I work at Spotify. And I think the other was like we were doing great, we already were killing it at podcast hosting. And also it was just so fun. I really valued that small company, everyone knows each other. We're doing really hard work, but we're also having so much fun. And I think it felt like I couldn't translate that to a large organization where I was like, okay, now I have to do things how they do. And then I think what actually ended up happening is I actually love how Spotify runs their company and I'm still able to run my team the way that works for me. And so I think it just goes back to knowing what you care about, being really solidly attached to your own core values and being able to take that with you.

**中文翻译:**
我想有一点是害怕成为“大机器里的一个齿轮”，不过现在在 Spotify 工作，我其实并没有这种感觉。另一点是，我们当时做得很好，在播客托管领域已经非常成功了。而且那真的很有趣。我非常看重小公司那种每个人都互相认识的氛围。我们做着非常辛苦的工作，但也玩得非常开心。我觉得我无法将这种氛围带入大型组织，我会觉得“好吧，现在我必须按他们的规矩办事”。但最终发生的是，我其实很喜欢 Spotify 经营公司的方式，而且我仍然能够以适合我的方式管理我的团队。所以我觉得这又回到了：了解你所看重的东西，坚定地坚守自己的核心价值观，并带着它们前行。

---

### (00:48:25) Lenny

**English:**
I think we're both examples of people that were startup people and then realized it's not so bad working at a big company. I stayed at Airbnb for seven years. I was like, no, no way, I'm going to be here for more than a year and a half or a year or two. How long have you been at Spotify? At this point?

**中文翻译:**
我想我们都是那种“初创公司出身，然后发现大公司工作也不赖”的例子。我在 Airbnb 待了七年。我当时想：“不，绝不可能，我在这儿待不了一年半或一两年。”你现在在 Spotify 待了多久了？

---

### (00:48:37) Maya Prohovnik

**English:**
I'm going on five years. Yeah.

**中文翻译:**
快五年了。是的。

---

### (00:48:41) Lenny

**English:**
No, I think this is just a example of it's you think you're not going to enjoy working at a larger company, but oftentimes it's actually pretty great for a lot of different reasons.

**中文翻译:**
是的，我觉得这只是一个例子：你以为你不会喜欢在大型公司工作，但通常情况下，出于各种不同的原因，它其实非常棒。

---

### (00:48:48) Maya Prohovnik

**English:**
Yes.

**中文翻译:**
是的。

---

### (00:48:49) Lenny

**English:**
Shifting in a slightly different direction, just thinking about leadership and what you've learned to lead teams, lead large orgs, build products, is there any just, I don't know, frameworks or tools that you found to be effective?

**中文翻译:**
换个话题，考虑到领导力以及你在领导团队、领导大型组织、构建产品方面学到的东西，有没有什么你觉得有效的框架或工具？

---

### (00:49:05) Maya Prohovnik

**English:**
The big one for me is Radical Candor. And I know my team watching this is going to laugh at me because I talk about this every day. They're tired of hearing it, but have you read it?

**中文翻译:**
对我来说最重要的一本是《彻底坦诚》（Radical Candor）。我知道我的团队看到这段会笑话我，因为我每天都在聊这个。他们都听腻了，但你读过吗？

---

### (00:49:15) Lenny

**English:**
I have. I love it.

**中文翻译:**
读过。我很喜欢。

---

### (00:49:17) Maya Prohovnik

**English:**
Yeah. It's my all time favorite book. And I think it really shifted for me, honestly how I relate to people in general. But I think especially with managing, giving feedback, being able to collaborate and push back in a direct way, direct and constructive way on peers and that sort of thing. So I make all of my managers on my team read it. We talk about it constantly in our team, and I think that the general concepts for anyone who's not familiar is you need to care personally and challenge directly. And if you're only doing one of those things, you're not giving feedback in an effective way. And the book just talks so much about the importance of feedback and how feedback is a gift, which I have now come to completely agree with. It's like anytime I've given someone effective feedback, it's always well received, even if it's tough to hear, people want to get better and they want to know how they can improve.

**中文翻译:**
是的。这是我最喜欢的书。老实说，它真的改变了我与人相处的方式。但我认为特别是在管理、提供反馈、能够以直接且建设性的方式与同事协作和提出异议等方面。所以我让我团队里的所有经理都读这本书。我们在团队里经常讨论它。对于不熟悉的人来说，它的核心概念是：你需要“个人关怀”（care personally）和“直接挑战”（challenge directly）。如果你只做其中之一，你就没有在有效地提供反馈。书中谈到了很多关于反馈的重要性，以及“反馈是一份礼物”，我现在完全同意这一点。每当我给别人有效的反馈时，即使听起来很刺耳，通常也会被很好地接受，因为人们想要变得更好，想要知道如何改进。

---

### (00:50:07) Maya Prohovnik

**English:**
And so I think anytime that you can give them specific feedback in a way that makes it clear that you care about them and want them to be able to reach their goals, I think it makes them stronger, it makes your relationship stronger. And I also think the one other big thing I took away from Radical Candor was when it comes to people not underperforming, it really reframed how I think about that because people are not generally inherently bad or lazy or ineffective, it's almost always because the role they're in is the wrong fit. And so being able to approach the conversation in that way means that you can come at it and in a caring way that lets them know you actually want them to be successful.

**中文翻译:**
所以我认为，任何时候只要你能以一种明确表达你关心他们、希望他们实现目标的方式提供具体反馈，都会让他们变得更强大，也会让你们的关系更牢固。我还从《彻底坦诚》中学到的另一件大事是关于表现不佳的人。它真的重塑了我对此的看法，因为人们通常并非天生糟糕、懒惰或低效，几乎总是因为他们所处的角色不合适。所以，能够以这种方式进行对话，意味着你可以带着关怀去沟通，让他们知道你其实是希望他们成功的。

---

### (00:50:47) Maya Prohovnik

**English:**
And what I found is when you have the conversation in that way, they're much more receptive to it. And then you're able to either actually resolve the issues or you're able to help them figure out what the right fit is for them, which I think as a manager, it's so inspiring to me because that means that you get to keep mentoring them beyond. You're not just saying, this isn't working, I'm giving up on you, see you later. You're saying, I'm committed to helping you throughout your whole career and let's help you find the next step, even if that isn't on my team or at this company.

**中文翻译:**
我发现，当你以这种方式对话时，他们会更容易接受。然后你就能真正解决问题，或者帮助他们弄清楚什么才是适合他们的。我认为作为一名经理，这非常鼓舞人心，因为这意味着你可以继续指导他们。你不是在说“这行不通，我放弃你了，再见”，而是在说“我致力于在你的整个职业生涯中帮助你，让我们帮你找到下一步，即使那不在我的团队或这家公司”。

---

### (00:51:16) Lenny

**English:**
Awesome. Yeah, I love that book. And you talked about the two. There's this grid that-

**中文翻译:**
太棒了。是的，我喜欢那本书。你提到了那两个维度，有一个象限图……

---

### (00:51:21) Maya Prohovnik

**English:**
The quadrants?

**中文翻译:**
那些象限？

---

### (00:51:22) Lenny

**English:**
Yeah, it talks about. And just to reinforce what you just said, the core is that when you want to give people direct feedback, but you want to make it clear you care deeply about them. And I love that she talks about if you do one of these wrong, here's what happens. If you challenge directly, but it doesn't feel like you care deeply, you're just an asshole and they're just like, yeah, God, you get really defensive. I should get her on this podcast. How cool would that be?

**中文翻译:**
是的。为了强化你刚才说的，核心是当你想要给人们直接的反馈时，你要明确表达你深切地关心他们。我喜欢她提到的如果你做错了一项会发生什么：如果你直接挑战，但感觉不到你深切关心，你就是一个“混蛋”（asshole），对方会变得非常有防御性。我应该请她来这个播客，那该多酷啊！

---

### (00:51:43) Maya Prohovnik

**English:**
Oh my God, that would be my, she's my... If I could meet one tech celebrity, it would be her.

**中文翻译:**
噢，天哪，那会是我的……她是我的……如果我能见一位科技界的明星，那一定是她。

---

### (00:51:48) Lenny

**English:**
Okay. I'm going to work on it. If you're listening and you're Kim Scott, let me know, I will try to get to her. Anything else in that bucket of frameworks or tools, things that you find really helpful leadership?

**中文翻译:**
好，我会努力的。如果你正在听，如果你是 Kim Scott，请告诉我，我会试着联系她。在框架或工具这个范畴里，还有什么你觉得对领导力非常有帮助的东西吗？

---

### (00:51:58) Maya Prohovnik

**English:**
The only other one, I'm not a huge framework person. I think this goes back to my gut thing, but the one other thing that I refer to often is I love the Eisenhower Matrix, which is also known as the four Ds. So it's do, defer, delegate, delete, you have also quadrants. Maybe my brain just works in quadrants. I don't know. But I totally subscribe to that and that's how I do everything, where I write everything down at the end of every day, I go through and I either do delegate, defer, delete, and it really helps you clear a lot of stuff out of your brain.

**中文翻译:**
唯一另一个，我不是一个特别迷信框架的人。我想这又回到了我的直觉论。但我经常参考的另一件事是，我喜欢“艾森豪威尔矩阵”（Eisenhower Matrix），也被称为 4D 原则：去做（Do）、推迟（Defer）、委派（Delegate）、删除（Delete）。它也有四个象限。也许我的大脑就是按象限运作的，我不知道。但我完全认同这个方法，这就是我处理所有事情的方式：每天结束时我把所有事情写下来，然后逐一决定是去做、委派、推迟还是删除。这真的能帮你清空大脑里的很多杂事。

---

### (00:52:27) Lenny

**English:**
Interesting. So you don't even use it as a grid necessarily, it's more make a decision on all the things on your plate?

**中文翻译:**
有趣。所以你甚至不一定把它当作一个网格图来用，更多是为你手头的所有事情做一个决定？

---

### (00:52:34) Maya Prohovnik

**English:**
I do. I just tried using the grid view and it didn't work for me for some reason. So I just use a to-do list, and then I don't let myself finish working until I've gone through anything I didn't get through that day, and then I know what I have to do the next day.

**中文翻译:**
是的。我试过用网格视图，但不知为什么对我不起作用。所以我只用待办事项列表，在处理完当天没完成的所有事情之前，我不让自己结束工作。这样我就知道第二天要做什么了。

---

### (00:52:46) Lenny

**English:**
So that touches on another area I wanted to touch on, which is productivity. I hear you're very good at being productive and making the use of your time. I guess one, where do you think that comes from? And then two, just any other tips, tactics, tools you find to be really effective in staying productive?

**中文翻译:**
这涉及到了我想谈的另一个领域：生产力。我听说你非常擅长保持高效并利用时间。我想问，第一，你觉得这种能力源自哪里？第二，有没有其他你觉得在保持高效方面非常有效的技巧、策略或工具？

---

### (00:53:01) Maya Prohovnik

**English:**
Yeah, where does that come from? I think I am OCD. I think I'm an overachiever. I don't know, it's really important to me. I think when my team says that I'm very productive, the feedback I hear from them is they're impressed that they send me a doc and then I always read it. I think that's more about prioritizing my team and making sure that they're unblocked, which I take very seriously. I don't know other tips that I would give people. I write everything down because I think I'm one of those people I remember things best when they're written down and then I obsessively put things on my to-do list. Anything that anyone asks me to do goes on there, and then I have that method for organizing it later in the day.

**中文翻译:**
是的，这源自哪里呢？我想我有强迫症（OCD），而且我是一个追求卓越的人。我不知道，这对我很重要。当我的团队说我很高效时，我听到的反馈是，他们对我总是能读完他们发给我的文档感到印象深刻。我认为这更多是关于把团队放在首位，确保他们不被卡住（unblocked），我对此非常认真。我不知道还能给别人什么建议。我会把所有事情都写下来，因为我是那种写下来才能记得最牢的人，然后我会强迫性地把事情放进待办事项列表。任何人要求我做的任何事都会出现在上面，然后我在当天晚些时候用那个方法来整理。

---

### (00:53:38) Lenny

**English:**
Do you have an app for this or do you write it on paper?

**中文翻译:**
你用 App 还是写在纸上？

---

### (00:53:40) Maya Prohovnik

**English:**
I use Todoist. I think you can use any, but it's the one that works best for me. I love using paper, but then if I don't have it with me, then I can't remember anything I have to do, so I've had to go digital.

**中文翻译:**
我用 Todoist。我想任何 App 都可以，但这个最适合我。我喜欢用纸，但如果我没带在身上，我就记不起要做什么了，所以我不得不转向数字化。

---

### (00:53:51) Lenny

**English:**
So it sounds like a big part of your process is just getting things out of your head and writing it down somewhere.

**中文翻译:**
所以听起来你流程中的一个重要部分就是把事情从脑子里拿出来，写在某个地方。

---

### (00:53:56) Maya Prohovnik

**English:**
Yes. I think that's huge. And I also think if you're in any sort of job, I think most PMs have this where it's so much of your job is actually deep thinking and problem solving. I just cannot get that done if I'm running through my to-do list in my head. So I think that was a big unlock for me when I realized that I just needed to, anytime I'm stressed, honestly, if I just sit and make a list of all the things I have to do, I'm like, oh, it's four things, I can get those done, it's okay.

**中文翻译:**
是的。我认为这非常关键。而且我认为无论你从事什么工作——我想大多数产品经理都有这种体会——你工作的很大一部分其实是深度思考和解决问题。如果我脑子里一直在过待办事项列表，我就无法完成深度思考。所以当我意识到我只需要……老实说，每当我感到压力大时，如果我坐下来列出所有要做的事情，我会发现：“噢，只有四件事，我可以搞定，没问题。”这对我来说是一个重大的突破。

---

### (00:54:18) Lenny

**English:**
Man, that tool of just making a list when you're stressed about, all the things you got to do, just making a list of it on paper, I find it so helpful.

**中文翻译:**
伙计，当你为要做的事情感到压力时，仅仅是把它们列出来，哪怕是写在纸上，我都觉得非常有帮助。

---

### (00:54:27) Maya Prohovnik

**English:**
It works every time.

**中文翻译:**
每次都奏效。

---

### (00:54:28) Lenny

**English:**
Have you read Getting Things Done by David Allen?

**中文翻译:**
你读过 David Allen 的《搞定》（Getting Things Done）吗？

---

### (00:54:31) Maya Prohovnik

**English:**
It's on my list. I haven't read it.

**中文翻译:**
在我的书单上，还没读。

---

### (00:54:32) Lenny

**English:**
Okay. That book totally transformed how I think about productivity, and you already doing a lot of what he recommends. It's like this very old book. And now he's just, I don't know, he's a public speaker dude that just goes around consulting. But this one, it has very simple approaches to being productive and it really changed the way I operate. And you're already doing a lot of it, so I don't know how much value you get out of it.

**中文翻译:**
好。那本书完全改变了我对生产力的看法，而你已经在做很多他推荐的事情了。那是一本很老的书。现在他只是……我不知道，一个到处做咨询的公开演讲者。但那本书里有非常简单的提高效率的方法，它真的改变了我的运作方式。既然你已经在做了，我不知道你还能从中获得多少价值。

---

### (00:54:53) Maya Prohovnik

**English:**
I'll read it. I love this stuff.

**中文翻译:**
我会读的。我喜欢这些东西。

---

### (00:54:55) Lenny

**English:**
A core concept is this idea of mind like water where you don't want to have anything in your head, you want to get it all out. And then there's these systems for how to process all the things you're getting out.

**中文翻译:**
一个核心概念是“心如止水”（mind like water），意思是你不想在脑子里装任何东西，你想把它们全部清空。然后有一套系统来处理你清空出来的所有事情。

---

### (00:55:04) Maya Prohovnik

**English:**
Totally.

**中文翻译:**
完全正确。

---

### (00:55:05) Lenny

**English:**
Maybe we'll get David Allen this. We got a whole list.

**中文翻译:**
也许我们会请到 David Allen。我们已经有一份长长的名单了。

---

### (00:55:07) Maya Prohovnik

**English:**
I know we have a whole hit list.

**中文翻译:**
我知道，我们有一份“必请名单”。

---

### (00:55:10) Lenny

**English:**
Maybe it's just a final question. You're good at so many things, another thing you're really good at is public speaking. I was watching the last Spotify launch event and I was just like, holy moly, she's incredibly good at speaking and it's something I want to get better at and something I think a 100% of people want to get better at. So, I'm just curious, what have you learned about being an effective public speaker? Anything that you could recommend to people if they're trying to get better at this?

**中文翻译:**
也许这是最后一个问题。你擅长这么多事情，另一件你非常擅长的是公开演讲。我看了上一次 Spotify 的发布活动，我当时想：天哪，她演讲得太棒了。这是我想提高的能力，也是我认为 100% 的人都想提高的能力。所以我很好奇，关于成为一名高效的公开演讲者，你学到了什么？对于想要提高这项能力的人，你有什么建议吗？

---

### (00:55:32) Maya Prohovnik

**English:**
Well, first of all, thank you for saying I'm awesome at so many things. This is my favorite podcast I've ever been on, you're just complimenting me the whole time, so I'll take it.

**中文翻译:**
首先，谢谢你夸我擅长这么多事。这是我参加过的最喜欢的播客，你一直在夸我，我就收下了。

---

### (00:55:39) Lenny

**English:**
True.

**中文翻译:**
实话实说。

---

### (00:55:41) Maya Prohovnik

**English:**
I think with public speaking, for me, the first thing that I had to do was decide that I didn't hate public speaking because I think it's human nature. It makes sense that we do not want to be in front of a crowd and we don't want to be performing. And it's just an unnatural thing that humans, I think make ourselves do. I remember actually when I was in high school, I had to give a presentation and I had so much anxiety I couldn't sleep the night before. And I remember I was getting ready for school that morning and I was like, I'm just not going to hate public speaking. I just can't get through my life feeling this way. And so I just got up there and I had fun with it, and it felt so much better to not feel worried about it.

**中文翻译:**
我认为对于公开演讲，对我来说，我必须做的第一件事就是决定“我不讨厌公开演讲”。因为我认为这是人类的天性，我们不想站在人群面前，不想表演，这很正常。这是一种不自然的事情，是我们强迫自己去做的。我记得高中时我必须做一次演讲，我非常焦虑，前一天晚上都睡不着。我记得那天早上准备去学校时，我想：“我就是不要讨厌公开演讲。我不能一辈子都带着这种感觉生活。”于是我走上台，享受其中，不再感到担心，感觉好多了。

---

### (00:56:18) Maya Prohovnik

**English:**
So I think ever since then I've been okay at it. And then I have gotten lots of opportunities to do big scary public speaking things for Spotify, and so I think I've had to get even better. I think my tips would be my biggest one is probably reframing. Everyone has this anxiety before they have to perform or they go on stage. Reframing that anxiety to understand that the thing your body is doing is surging you with adrenaline to help you. And so letting that feeling wash over you instead of fighting it, I think has been so effective for me because otherwise, it can feel like a panic attack. And so I think you have to be like, cool, my body's getting ready. We're excited, we're going to go do this on stage. That has been really helpful. I practice a million times anytime I have to do public speaking.

**中文翻译:**
所以我想从那以后我就做得还可以。后来我有很多机会为 Spotify 做一些大型且令人畏惧的公开演讲，所以我必须变得更好。我的建议中最重要的可能是“重构”（reframing）。每个人在表演或上台前都会感到焦虑。重构这种焦虑，去理解你的身体正在分泌肾上腺素来帮助你。所以，让那种感觉席卷全身而不是去对抗它，我认为这对我非常有效，否则它感觉就像恐慌发作。所以你必须想：“酷，我的身体准备好了。我们很兴奋，我们要上台大干一场。”这非常有帮助。每当我需要公开演讲时，我都会练习无数次。

---

### (00:57:03) Maya Prohovnik

**English:**
So I think everybody has different memorization tactics, different ways of doing speaker notes that work for them. And so I think part of it is you have to do a bunch of public speaking to see what works for you. So some people work best with no notes. I almost read complete sentences a good, I can enunciate things while I'm reading, so that works best for me. Some people like bullets and then they go a little bit off the script. But I think once you figure out what method of speaker notes works for you, I rehearse probably at least 10 times all the way through once the speaker notes are final. And you can practice your exact delivery. You can practice where you're going to put jokes in. You can figure out what doesn't feel natural or where you're going to trip it up, and then you can change the words that you're using.

**中文翻译:**
我认为每个人都有不同的记忆策略和适合自己的演讲笔记方式。所以部分原因是你必须做大量的公开演讲，才能发现什么适合你。有些人不带笔记效果最好。我几乎是读完整的句子，我可以在读的时候发音清晰，所以这最适合我。有些人喜欢列要点，然后稍微脱稿发挥。但我想一旦你弄清楚哪种笔记方式适合你，在演讲稿定稿后，我至少会完整排练 10 遍。你可以练习精确的表达，练习在哪里加入笑话，找出哪里感觉不自然或哪里容易卡壳，然后修改你使用的词汇。

---

### (00:57:42) Maya Prohovnik

**English:**
And so I like to get to the point where I can remember ad-lib at least half of the notes that I have in there, and that way I know I'm going to feel confident coming off script. I make a lot of eye contact with the audience, which I think makes them think that I'm not reading speaker notes. So I think that's really important. If you can stand it, which I can't, record yourself or watch yourself in a mirror, it messes me up more. But I think for a lot of people, that can be really helpful to figure out where your issues are. I think the biggest thing for me honestly, is that the unfair advantage I have is if you really give a shit about what you're talking about, you are going to be such a better presenter because people are going to be able to tell that you care.

**中文翻译:**
我喜欢练到能即兴发挥（ad-lib）至少一半笔记内容的程度，这样我知道脱稿时我会感到自信。我会与观众进行大量的眼神交流，我想这会让他们觉得我没有在读笔记。所以我认为这非常重要。如果你能忍受的话（我受不了），录下自己的演讲或对着镜子看，那会让我更乱。但对很多人来说，这对于找出问题非常有帮助。老实说，对我来说最重要的一点，也是我的“不公平竞争优势”，就是如果你真的非常在意你所谈论的内容，你会成为一个更好的演讲者，因为人们能感觉到你的投入。

---

### (00:58:20) Maya Prohovnik

**English:**
And so I think leaning into that, so when you can, telling personal stories, letting the audience get to know you, I like to work some humor into my presentations. I think that can really help as well.

**中文翻译:**
所以我认为要利用这一点，尽可能讲述个人故事，让观众了解你。我喜欢在演讲中加入一些幽默感，我认为这也会很有帮助。

---

### (00:58:55) Lenny

**English:**
That is awesome advice. I especially love letting the stress wash over you, because most of has this challenge. Your body's just doing all this shit that's just going to stress the shit out of you. And so the idea of just embracing it, just flowing with it.

**中文翻译:**
这是非常棒的建议。我特别喜欢“让压力席卷全身”这一点，因为大多数人都有这个挑战。你的身体会产生各种反应让你压力倍增。所以，拥抱它、顺应它的想法很棒。

---

### (00:59:10) Maya Prohovnik

**English:**
Yes, it's a superpower. It's like, that's so cool, that adrenaline works that way.

**中文翻译:**
是的，这是一种超能力。就像是：“太酷了，肾上腺素竟然是这样起作用的。”

---

### (00:59:14) Lenny

**English:**
Yeah. I'm going to try that one.

**中文翻译:**
是的，我要试试那个。

---

### (00:59:16) Maya Prohovnik

**English:**
Also, if you're nervous, you can put your hands above your head that'll help the blood, I don't know, it helps it go into your head or something. I don't remember.

**中文翻译:**
另外，如果你紧张，可以把手举过头顶，这会有助于血液……我不知道，有助于血液流向大脑之类的，我不记得了。

---

### (00:59:23) Lenny

**English:**
There's this whole power post thing that apparently has-

**中文翻译:**
有那种“权力姿势”（power pose）的理论，显然……

---

### (00:59:26) Maya Prohovnik

**English:**
Yes, exactly.

**中文翻译:**
是的，没错。

---

### (00:59:26) Lenny

**English:**
I think it's been disproven. People are like, no, there's no data that shows that. But the blood thing that's really interesting versus psychological benefits.

**中文翻译:**
我想它已经被证伪了。人们说：“不，没有数据支持这一点。”但血液流向那个说法很有趣，相比于心理上的好处。

---

### (00:59:34) Maya Prohovnik

**English:**
I think there is a real physiological thing that happens.

**中文翻译:**
我认为确实发生了一些生理上的变化。

---

### (00:59:36) Lenny

**English:**
That's cool. Okay. Amazing. Okay. Maybe as an actual last question, what's happening in the future of the Spotify podcasting platform? Anything you want to share about where things are going?

**中文翻译:**
很酷。好，太棒了。也许这才是真正的最后一个问题：Spotify 播客平台的未来会发生什么？关于未来的走向，有什么想分享的吗？

---

### (00:59:45) Maya Prohovnik

**English:**
A lot of the things that I talked about at Stream on for anyone who saw that this year, I think are still very much our strategy. So I think for us in general, Spotify is really focused on making sure that we can... We have a massive audience, we have more than 500 million monthly active listeners. We want to help podcast creators reach that global audience, and so it's really important to us. I always tell my team the biggest problem that I want to solve for podcasters is discovery and audience growth, and I really think we can be the ones to do it, so I'm really excited about that. So discovery, monetization. We're really focused on making sure that creators of all shapes and sizes can make a living off of their work.

**中文翻译:**
我在今年的 Stream On 活动上谈到的很多内容，我认为仍然是我们的核心战略。总的来说，Spotify 非常专注于确保我们能够……我们拥有庞大的受众，月活跃听众超过 5 亿。我们希望帮助播客创作者触达全球受众，这对我们非常重要。我总是告诉我的团队，我想为播客主解决的最大问题是“发现”和“受众增长”，我真的认为我们可以做到这一点，所以我对此非常兴奋。所以，发现、变现。我们非常专注于确保各种规模的创作者都能靠自己的作品维持生计。

---

### (01:00:24) Maya Prohovnik

**English:**
And then I think in general, we're working on so many cool things at Spotify to make podcasts a more interactive format, something that allows you to get to know your audience and connect with your fan base. We talked about a couple features this past year. I definitely can't say anything specific, but what I can say is there is lots of really cool stuff coming next year that I'm very excited about. And I would say for anyone who wants to learn more, definitely sign up for Spotify for podcasters. It works whether you're hosted with Spotify or not, and you can start to get a sense of some of those features that we're opening up to everybody, but there's lots more cool stuff to come.

**中文翻译:**
此外，总的来说，我们在 Spotify 正在开发许多很酷的功能，让播客成为一种更具互动性的形式，让你能够了解你的受众并与粉丝群建立联系。去年我们讨论了几个功能。我肯定不能透露具体细节，但我可以透露的是，明年会有很多非常酷的东西推出，我非常期待。我想对任何想了解更多的人说，一定要注册 Spotify for Podcasters。无论你的播客是否托管在 Spotify 上，它都适用。你可以开始体验我们向所有人开放的一些功能，未来还会有更多精彩内容。

---

### (01:00:58) Lenny

**English:**
Amazing, mysterious, and exciting. With that, we've reached our very exciting lightning round. Are you ready?

**中文翻译:**
太棒了，既神秘又令人兴奋。至此，我们进入了非常刺激的闪电轮环节。准备好了吗？

---

### (01:01:05) Maya Prohovnik

**English:**
Yes.

**中文翻译:**
准备好了。

---

### (01:01:06) Lenny

**English:**
What are two or three books that you recommend most to other people?

**中文翻译:**
你向别人推荐最多的两三本书是什么？

---

### (01:01:09) Maya Prohovnik

**English:**
Children of Time, and I guess I would say It by Stephen King. I recommend a lot of Stephen King books, but that's my all time favorite.

**中文翻译:**
《时间之子》，我想还有史蒂芬·金的《它》（It）。我推荐过很多史蒂芬·金的书，但那是我的最爱。

---

### (01:01:16) Lenny

**English:**
Very on brand with your podcasts. Makes sense. What is a recent movie or TV show that you've really enjoyed?

**中文翻译:**
和你的播客风格非常一致，合情合理。最近有没有什么你非常喜欢的电影或电视剧？

---

### (01:01:23) Maya Prohovnik

**English:**
TV show, I'll just say, I guess Pokerface was the last one that really blew my mind. Movies, I mean, Barbie was so good, and then I'll just give you a lesser known one. I just watched this crazy movie from the '80s that was made the same year Home Alone was, this just got featured on a podcast, so I think everybody's talking about it now, but it's a horror movie about a kid who's home alone, and then he has to fight Santa Claus in a home invasion situation. It is so good, it has a bunch of different names, but if you look up either Game Over or it's like Code Père Noël or something, it's an old French horror movie, so good.

**中文翻译:**
电视剧的话，我想《扑克脸》（Poker Face）是最近最让我惊艳的一部。电影方面，《芭比》（Barbie）非常棒。然后再给你推荐一个冷门的：我刚看了一部 80 年代的疯狂电影，和《小鬼当家》（Home Alone）是同年制作的。这部电影刚在某个播客里被提到，所以我想现在大家都在讨论它。这是一部恐怖片，讲的是一个小孩独自在家，然后他必须在入室抢劫的情况下对抗“圣诞老人”。它非常精彩，有很多不同的名字，但如果你搜《游戏结束》（Game Over）或者《圣诞老人法典》（Code Père Noël）之类的，这是一部古老的法国恐怖片，非常棒。

---

### (01:01:59) Lenny

**English:**
Interesting that the other Home Alone is the one that did well in this one.

**中文翻译:**
有趣的是，另一部《小鬼当家》大获成功，而这一部……

---

### (01:02:02) Maya Prohovnik

**English:**
Well, there was apparently a whole legal thing over it.

**中文翻译:**
额，显然这中间还有一堆法律纠纷。

---

### (01:02:05) Lenny

**English:**
Oh, wow. They didn't have Macaulay Culkin. That's their missing piece. What is a favorite interview question that you'd like to ask candidates when you're interviewing?

**中文翻译:**
噢，哇。他们没有麦考利·卡尔金，那是他们缺失的关键。你在面试候选人时最喜欢问的问题是什么？

---

### (01:02:14) Maya Prohovnik

**English:**
I have one. It is, if you could make a podcast about anything, what would it be? And it is the best. Honestly, you should ask people that even if you don't work in work in podcasting, because it tells you so much about candidates, and one thing that I feel very strongly is that the most important thing is that you're hiring passionate people, not people who are passionate necessarily about the thing that you're doing, but about anything. If they can't think of anything, that's a red flag for me.

**中文翻译:**
我有一个：“如果你可以就任何主题做一个播客，你会做什么？”这是最棒的问题。老实说，即使你不在播客行业工作，你也应该问这个问题，因为它能让你了解候选人的很多信息。我强烈感觉到，最重要的事情是雇佣有激情的人，不一定是由于对你正在做的事情有激情，而是对任何事情有激情。如果他们什么都想不出来，那对我来说就是一个危险信号。

---

### (01:02:33) Lenny

**English:**
That's awesome. It's like a variation of the question of Teach me something or tell me about something that you've learned recently. Really interesting tweak on that question and very appropriate. What is a favorite product or something awesome you've discovered recently that you really like digital or physical?

**中文翻译:**
太棒了。这就像是“教我一点东西”或者“告诉我你最近学到了什么”这类问题的变体。对那个问题的一个非常有趣的调整，而且非常贴切。你最近发现的、非常喜欢的数字或实物产品是什么？

---

### (01:02:49) Maya Prohovnik

**English:**
Okay. Very unsexy answer, but I love 1-800-CONTACTS.

**中文翻译:**
好吧，一个非常不“性感”的答案，但我爱 1-800-CONTACTS（隐形眼镜电商）。

---

### (01:02:53) Lenny

**English:**
Okay.

**中文翻译:**
好的。

---

### (01:02:54) Maya Prohovnik

**English:**
I'm so impressed with their product team. If you need new contacts, even if you need a new prescription, you can do the whole thing online in five minutes, and it's so well-thought-out and so thoughtful. I love them. And then the one other one I'll give a shout-out to, since becoming a parent, Love Every, do you subscribe to them?

**中文翻译:**
他们的产品团队让我印象深刻。如果你需要新的隐形眼镜，甚至需要新的验光单，你可以在五分钟内在线完成整个流程，设计得非常周到。我爱死他们了。另一个我想点名表扬的是 Lovevery（早教玩具品牌），自从为人父母后，你订阅了他们吗？

---

### (01:03:09) Lenny

**English:**
Absolutely. I don't know anyone that doesn't have them.

**中文翻译:**
当然。我不认识哪个家长没买过他们的东西。

---

### (01:03:12) Maya Prohovnik

**English:**
I know. It's so good.

**中文翻译:**
我知道，太棒了。

---

### (01:03:12) Lenny

**English:**
They've cracked it.

**中文翻译:**
他们掌握了秘诀。

---

### (01:03:14) Maya Prohovnik

**English:**
Yes.

**中文翻译:**
是的。

---

### (01:03:15) Lenny

**English:**
Yeah. We are missing some of the toys, and so we're trying to find where they went because he's ready for the rattle.

**中文翻译:**
是的。我们弄丢了一些玩具，现在正试着找回来，因为他已经准备好玩那个拨浪鼓了。

---

### (01:03:25) Maya Prohovnik

**English:**
Yes. Awesome.

**中文翻译:**
是的，太棒了。

---

### (01:03:25) Lenny

**English:**
Yeah. I love everybody's amazing and their ads are really great. Oh, man.

**中文翻译:**
是的。Lovevery 真的很神奇，他们的广告也做得很好。噢，伙计。

---

### (01:03:27) Maya Prohovnik

**English:**
Yes. They're so good.

**中文翻译:**
是的，他们太出色了。

---

### (01:03:29) Lenny

**English:**
What is a favorite life motto that you come back to often share with folks? Anything there?

**中文翻译:**
你经常回想起或与人分享的人生格言是什么？

---

### (01:03:36) Maya Prohovnik

**English:**
"Only a fool wishes time away." Even if you're having a bad day, even if you're doing something boring or you're stressed, you have to do public speaking, that's still your life and you should enjoy it.

**中文翻译:**
“只有傻瓜才会希望时间快点过去。”即使你度过了糟糕的一天，即使你在做无聊的事，或者你压力很大、必须去做公开演讲，那仍然是你生命的一部分，你应该享受它。

---

### (01:03:47) Lenny

**English:**
I love that. There's this phrase of just like, I'm just killing time right now, and I always think about that, just like, oh, but you don't have that much time. Maybe you shouldn't try to kill yourself.

**中文翻译:**
我喜欢这个。有一种说法叫“我正在消磨时间”，我总是在想：噢，但你并没有那么多时间，也许你不该试图“杀掉”它。

---

### (01:03:57) Maya Prohovnik

**English:**
Yeah.

**中文翻译:**
是的。

---

### (01:03:58) Lenny

**English:**
Even though sometimes things are boring, it reminds me of another quote of just, "Most of the world's problems are caused by our inability to sit in a room for 10 minutes quietly."

**中文翻译:**
尽管有时事情很无聊，这让我想起另一句话：“世界上大多数问题都是由于我们无法在一个房间里安静地坐上 10 分钟造成的。”

---

### (01:04:07) Maya Prohovnik

**English:**
Yes. Also, if you're bored, have a baby because you'll never be bored again.

**中文翻译:**
是的。另外，如果你觉得无聊，生个孩子吧，因为你再也不会感到无聊了。

---

### (01:04:11) Lenny

**English:**
Yeah. Yep, indeed. Speaking of parenting, what is a valuable lesson that your mom or your dad taught you?

**中文翻译:**
是的。确实如此。说到育儿，你父母教给你的最有价值的一课是什么？

---

### (01:04:18) Maya Prohovnik

**English:**
My mom always told me that my generosity would be rewarded, so anytime that I was nice or thought of someone else before me, she always made sure that I got some little reward or got to go out for ice cream or something, I think that really worked on me.

**中文翻译:**
我妈妈总是告诉我，我的慷慨会得到回报。所以每当我表现得友善，或者先为别人着想时，她总是确保我能得到一些小奖励，或者带我去吃冰淇淋之类的。我想这对我真的很管用。

---

### (01:04:34) Lenny

**English:**
I love that. Final question, I saw somewhere that you raised bait backyard chickens. Is that true?

**中文翻译:**
我喜欢这个。最后一个问题，我在哪里看到你在后院养鸡？是真的吗？

---

### (01:04:40) Maya Prohovnik

**English:**
I'm so happy you asked about my chickens'.

**中文翻译:**
我太高兴你问起我的鸡了。

---

### (01:04:43) Lenny

**English:**
I love that reaction. So maybe just why did you decide to do that and any tips for someone that may want to explore it?

**中文翻译:**
我喜欢这个反应。那么，你为什么决定养鸡？对于想尝试的人有什么建议吗？

---

### (01:04:48) Maya Prohovnik

**English:**
Oh my God. Well, we should have started with this because I can talk about this for an hour and a half, but I love my chickens. I have eight of them, we've got one rooster and seven hens. I think that all of us should be a little bit closer to nature, to the, I was going to say, the food that we're eating, I'm not going to eat my chickens, but they make eggs for me. But I just think there is something very lacking in our modern lives, that connection to nature. When I feel stressed at work and I go outside and I hang out with my chickens, I pet them, and I give them treats and we talk to each other. It's like nothing makes me happier and feel more grounded than hanging out with my chickens. So I think everyone should have chickens. I would say they're pretty low maintenance, so if you're thinking about it, I would recommend it. And if you get chickens, my favorite thing that I did for them, I got this monthly subscription box for chickens I think it's called Coop Crate.

**中文翻译:**
噢，天哪。好吧，我们本该从这个话题开始的，因为我可以聊一个半小时。我爱我的鸡。我有八只，一只公鸡和七只母鸡。我认为我们所有人都应该离大自然更近一点，离……我本想说离我们吃的食物更近一点，但我不会吃我的鸡，它们只是为我下蛋。我只是觉得现代生活中非常缺乏与大自然的联系。当我在工作中感到压力时，我走到户外和我的鸡待在一起，抚摸它们，给它们零食，我们互相“交谈”。没有什么比和我的鸡待在一起更让我感到快乐和踏实（grounded）的了。所以我认为每个人都应该养鸡。我想说它们其实很好养，所以如果你在考虑，我非常推荐。如果你养了鸡，我为它们做的最棒的一件事就是订了一个每月的鸡用订阅盒，我想叫 Coop Crate。

---

### (01:05:40) Lenny

**English:**
Love Every for Chickens.

**中文翻译:**
给鸡用的 Lovevery。

---

### (01:05:41) Maya Prohovnik

**English:**
Yes, it's Love Every for Chickens and every month they send me chicken treats, but also fun little things for crazy chicken people, so it's clothes or a sticker, something funny.I'm very into the whole chicken thing, so, yeah.

**中文翻译:**
是的，就是给鸡用的 Lovevery。每个月他们会给我寄鸡零食，还有一些给“疯狂养鸡人”准备的有趣小玩意，比如衣服、贴纸之类好玩的东西。我非常沉迷于养鸡，所以，是的。

---

### (01:05:55) Lenny

**English:**
Oh my God. Maybe just a tactical question, how much space do you need in your yard for chickens?

**中文翻译:**
噢，天哪。问个战术性的问题：你的院子里需要多大空间来养鸡？

---

### (01:06:00) Maya Prohovnik

**English:**
Not that much, so we let them free-range. We have a pretty big yard, but I think their actual, so there's their little coop, and then they've got a run that's fenced in. The run is maybe like, I don't know, five feet by eight feet or something, but you can go a lot smaller. If you go to Home Depot, they actually sell pre-made coops and runs. I think if you have a decent sized backyard, they'll be fine. I've known people with pretty small yards, and you just let your chickens out and they're happy and they'll find worms in a few yards.

**中文翻译:**
不需要很大。我们让它们自由放养。我们有一个相当大的院子，但它们实际居住的地方——有一个小鸡舍，然后有一个带围栏的跑道。跑道大约是 5 英尺乘 8 英尺左右，但你也可以弄得更小。如果你去 Home Depot，他们其实卖预制的鸡舍和跑道。我想如果你有一个大小适中的后院，它们就会过得很好。我认识一些院子很小的人也养鸡，你只要把鸡放出来，它们就会很开心，在几码见方的地方就能找到虫子。

---

### (01:06:27) Lenny

**English:**
Oh man. All right. A new project to look into.

**中文翻译:**
噢，伙计。好吧，这是一个值得研究的新项目。

---

### (01:06:29) Maya Prohovnik

**English:**
Please get chickens, do it.

**中文翻译:**
请去养鸡吧，行动起来。

---

### (01:06:31) Lenny

**English:**
Okay. Maya, we've talked about chickens, dogfooding, gut level decisions, Radical Candor, so many things. Thank you so much for being here. Two final questions. Where can folks find you online if they want to reach out, and how can listeners be useful to you?

**中文翻译:**
好的。Maya，我们聊了养鸡、“吃狗粮”、直觉决策、《彻底坦诚》等等这么多事情。非常感谢你能来。最后两个问题：如果大家想联系你，可以在哪里找到你？以及听众可以如何帮助你？

---

### (01:06:43) Maya Prohovnik

**English:**
I'm on threads, I guess, and I'm on LinkedIn. I'm Maya Fish on most social media, and then I'm on LinkedIn, and then, what was the second one? How can people be useful to me?

**中文翻译:**
我在 Threads 上，也在 LinkedIn 上。在大多数社交媒体上我的 ID 是 Maya Fish。然后，第二个问题是什么来着？人们可以如何帮助我？

---

### (01:06:53) Lenny

**English:**
Exactly.

**中文翻译:**
没错。

---

### (01:06:55) Maya Prohovnik

**English:**
Listen to your podcast on Spotify, and then send me your feedback. I would love to know either as a podcast creator or as a podcast listener. Always happy to hear what Spotify can be doing more of or better to help you out.

**中文翻译:**
在 Spotify 上听播客，然后给我发反馈。我很想知道——无论你是作为播客创作者还是听众。我总是很乐意听到 Spotify 还能多做些什么或在哪些方面做得更好来帮助大家。

---

### (01:07:06) Lenny

**English:**
Amazing. Maya, thank you so much for being here.

**中文翻译:**
太棒了。Maya，非常感谢你能来。

---

### (01:07:08) Maya Prohovnik

**English:**
Thank you so much.

**中文翻译:**
非常感谢。

---

### (01:07:09) Lenny

**English:**
Bye, everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
再见，各位。非常感谢收听。如果你觉得本期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅本节目。此外，请考虑给我们评分或留下评论，这能真正帮助其他听众找到这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目再见。