# Mayur Kamat - 双语对照

This is the complete bilingual transcript for Lenny’s Podcast featuring Mayur Kamat.

---

### [00:00:00] Mayur Kamat

**English:**
My, probably, most spectacular failure was, I was the first PM on Hangouts. We had thousands of people working for me. We had entire power of Google. We had Larry literally sitting with us saying we can do anything we want Chrome to do and we still didn't manage to build a great messaging product. The main learnings from that is, don't take on projects that are going to be six months, a year, because you just generally don't have control over the macro. The challenge with being a product manager is, everybody thinks they can do the job. Anybody who uses the product thinks they have ideas, so at some point in time, you're like, "What is my discipline? What is my science?" The moment you build experimentation, you've now made it scientific.

**中文翻译:**
我最惨痛的失败大概是，我是 Hangouts 的第一任产品经理（PM）。当时我有数千名员工，背靠谷歌的全部力量。拉里·佩奇（Larry Page）当时就坐在我们身边，说我们可以让 Chrome 做任何我们想做的事，但我们还是没能打造出一款伟大的即时通讯产品。从中得到的主要教训是：不要接手那些周期长达半年或一年的项目，因为你通常无法控制宏观环境。做产品经理的挑战在于，每个人都觉得自己能胜任这份工作。任何使用产品的人都觉得自己有想法，所以有时你会想：“我的专业性在哪里？我的科学依据是什么？”而当你建立起实验机制（Experimentation）的那一刻，你就让它变得科学了。

---

### [00:00:41] Lenny Rachitsky

**English:**
A lot of new people in their career are like, "Oh, I just want to think about strategy. I'm going to think about the big picture."

**中文翻译:**
很多职场新人会说：“噢，我只想思考战略。我要思考大局。”

---

### [00:00:45] Mayur Kamat

**English:**
Strategy is a little bit overrated for product. For most product managers, your strategy should be, "How fast can I go from hypothesis to data?"

**中文翻译:**
对于产品来说，战略有点被高估了。对于大多数产品经理来说，你的战略应该是：“我从假设到获取数据的速度能有多快？”

---

### [00:00:54] Lenny Rachitsky

**English:**
Today, my guest is Mayur Kamat. Mayur is Chief Product Officer at N26, one of the most successful fintech startups in the world and which, in my research, came in amongst the top five companies in the world who are hiring and producing the best product managers. Prior to N26, Mayur was Global Head of Product at Binance, VP of product at Agoda, which is over a $100 billion dollar company based in Thailand, and a PM at Google and Microsoft. In our wide-ranging conversation, Mayur shares what he's learned about hiring and developing great product managers, what he learned from his time working at Binance, which, as you'll soon hear, was one of the wildest and most unique ways of working, what he learned from the failure of Google's early attempts at Hangouts, where he was the first PM. Also, the pros and cons of working in Asia versus Europe versus the US, and why you should be starting your career on the West Coast of the US. Also, why comp early in your career does not matter and so much more.

**中文翻译:**
今天的嘉宾是 Mayur Kamat。Mayur 是 N26 的首席产品官（CPO），N26 是全球最成功的金融科技（Fintech）初创公司之一。在我的研究中，它是全球招聘和培养最优秀产品经理的前五名公司之一。在加入 N26 之前，Mayur 曾担任币安（Binance）的全球产品负责人、Agoda（一家总部位于泰国、市值超过 1000 亿美元的公司）的产品副总裁，以及谷歌和微软的产品经理。在我们广泛的对话中，Mayur 分享了他在招聘和培养优秀产品经理方面的经验；他在币安工作期间的所见所闻（正如你即将听到的，那是最新奇、最独特的工作方式之一）；他在谷歌早期尝试 Hangouts 失败中学到的教训（他是那里的首位 PM）。此外，我们还讨论了在亚洲、欧洲和美国工作的优缺点，为什么你应该在美国西海岸开启职业生涯，为什么职业早期的薪酬（Comp）并不重要，以及更多精彩内容。

---

### [00:01:47] Lenny Rachitsky

**English:**
This episode is so full of golden nuggets and advice for product people throughout every stage of their career. If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. Also, if you become an annual subscriber of my newsletter, you get a year free of a bunch of amazing products, including Superhuman, Notion, Linear Perplexity, Granola and more. Check it out at lennysnewsletter.com and click Bundle. With that, I bring you Mayur Kamat.

**中文翻译:**
本集内容充满了干货，为处于职业生涯各个阶段的产品人提供了宝贵建议。如果你喜欢这个播客，别忘了在常用的播客应用或 YouTube 上订阅和关注。此外，如果你成为我时事通讯（Newsletter）的年度订阅者，你可以免费获得一年的一系列优秀产品，包括 Superhuman、Notion、Linear、Perplexity、Granola 等。请访问 lennysnewsletter.com 并点击 Bundle 查看。现在，让我们欢迎 Mayur Kamat。

---

### [00:02:14] Lenny Rachitsky (Ad)

**English:**
This episode is brought to you by WorkOS. If you're building a SaaS app, at some point, your customers will start asking for enterprise features like SAML authentication and SCIM provisioning. That's where WorkOS comes in, making it fast and painless to add enterprise features to your app. Their APIs are easy to understand, so that you can ship quickly and get back to building other features. Today, hundreds of companies are already powered by WorkOS, including ones you probably know like Vercel, Webflow and Loom.

**中文翻译:**
本集节目由 WorkOS 赞助。如果你正在构建 SaaS 应用，迟早你的客户会开始要求企业级功能，如 SAML 身份验证和 SCIM 配置。这就是 WorkOS 的用武之地，它能让你快速且无痛地为应用添加企业功能。他们的 API 易于理解，让你能快速交付并重新投入到其他功能的开发中。如今，数百家公司已由 WorkOS 提供支持，包括你可能熟悉的 Vercel、Webflow 和 Loom。

---

### [00:02:45] Lenny Rachitsky (Ad)

**English:**
WorkOS also recently acquired Warrant, the fine-grained authorization service. Warrant's product is based on a groundbreaking authorization system called Zanzibar, which was originally designed for Google to power Google Docs and YouTube. This enables fast authorization checks at enormous scale while maintaining a flexible model that can be adapted to even the most complex use cases. If you're currently looking to build role-based access control or other enterprise features like single sign-on, SCIM or user management, you should consider WorkOS. It's a drop-in replacement for Auth Zero and supports up to one million monthly active users for free. Check it out at workOS.com to learn more. That's workOS. com.

**中文翻译:**
WorkOS 最近还收购了细粒度授权服务 Warrant。Warrant 的产品基于名为 Zanzibar 的突破性授权系统，该系统最初是为谷歌设计的，用于支持 Google Docs 和 YouTube。这使得在大规模环境下进行快速授权检查成为可能，同时保持了能够适应最复杂用例的灵活模型。如果你目前正寻求构建基于角色的访问控制（RBAC）或其他企业功能（如单点登录 SSO、SCIM 或用户管理），你应该考虑 WorkOS。它是 Auth0 的即插即用替代方案，并免费支持多达 100 万月活跃用户。访问 workOS.com 了解更多信息。

---

### [00:03:33] Lenny Rachitsky (Ad)

**English:**
Many of you are building AI products, which is why I am very excited to chat with Brandon Foo, Founder and CEO of Paragon. Hey, Brandon.

**中文翻译:**
你们中的许多人正在构建 AI 产品，这就是为什么我非常高兴能与 Paragon 的创始人兼 CEO Brandon Foo 交谈。嘿，Brandon。

---

### [00:03:41] Brandon Foo

**English:**
Hey, Lenny. Thanks for having me.

**中文翻译:**
嘿，Lenny。谢谢邀请我。

---

### [00:03:43] Lenny Rachitsky

**English:**
Integrations have become a big deal for AI products. Why is that?

**中文翻译:**
集成（Integrations）对于 AI 产品来说已经变得非常重要。这是为什么？

---

### [00:03:48] Brandon Foo

**English:**
Integrations are mission-critical for AI for two reasons. First, AI products need contacts from their customer's business data such as Google Drive files, Slack messages or CRM records. Second, for AI products to automate work on behalf of users, AI agents need to be able to take action across these different third-party tools.

**中文翻译:**
集成对 AI 至关重要，原因有二。首先，AI 产品需要来自客户业务数据的上下文，例如 Google Drive 文件、Slack 消息或 CRM 记录。其次，为了让 AI 产品代表用户自动执行工作，AI 智能体（Agents）需要能够在这些不同的第三方工具中采取行动。

---

### [00:04:07] Lenny Rachitsky

**English:**
Where does Paragon fit into all this?

**中文翻译:**
Paragon 在这其中扮演什么角色？

---

### [00:04:09] Brandon Foo

**English:**
These integrations are a pain to build. That's why Paragon provides an embedded platform that enables engineers to ship these product integrations in just days instead of months across every use case from rag data ingestion to agentic actions.

**中文翻译:**
构建这些集成非常痛苦。这就是为什么 Paragon 提供了一个嵌入式平台，使工程师能够在几天内（而不是几个月）交付这些产品集成，涵盖从 RAG 数据摄取到智能体行动的每一个用例。

---

### [00:04:23] Lenny Rachitsky

**English:**
I know from firsthand experience that maintenance is even harder than just building it for the first time.

**中文翻译:**
我从第一手经验中知道，维护甚至比第一次构建还要难。

---

### [00:04:27] Brandon Foo

**English:**
Exactly. We believe product teams should focus engineering efforts on competitive advantages, not integrations. That's why companies like You.com, AI21 and hundreds of others use Paragon to accelerate their integration strategy.

**中文翻译:**
没错。我们认为产品团队应该将工程力量集中在竞争优势上，而不是集成上。这就是为什么像 You.com、AI21 和数百家其他公司使用 Paragon 来加速他们的集成战略。

---

### [00:04:41] Lenny Rachitsky

**English:**
If you want to avoid wasting months of engineering on integrations that your customers need, check out Paragon at useparagon.com/Lenny.
(00:04:49):
Mayur, thank you so much for being here, and welcome to the podcast.

**中文翻译:**
如果你想避免在客户需要的集成上浪费数月的工程时间，请访问 useparagon.com/Lenny 查看 Paragon。
Mayur，非常感谢你能来到这里，欢迎来到播客。

---

### [00:04:56] Mayur Kamat

**English:**
Thank you. This is super exciting. Thank you for having me.

**中文翻译:**
谢谢。这非常令人兴奋。谢谢你邀请我。

---

### [00:05:00] Lenny Rachitsky

**English:**
I want to start with your time at Binance. You've worked at Google, you worked at Microsoft, you worked at a company called Agoda. Now, you're at N26. I imagine Binance was the most unique place that you've worked at, and I've also never heard much about what it's like to work at a company like Binance. I was just looking them up on Wikipedia. I saw they started in China, they moved to Japan, they moved to Malta. Now, they have no official headquarters. What was it just like working at Binance? How was it most unique from other places you've worked?

**中文翻译:**
我想从你在币安（Binance）的时光聊起。你曾在谷歌、微软、Agoda 工作过，现在在 N26。我猜币安是你工作过最独特的地方，而且我也没怎么听说过在币安这样的公司工作是什么感觉。我刚在维基百科上查了一下，他们在中国起步，搬到了日本，又搬到了马耳他，现在没有正式的总部。在币安工作到底是什么感觉？它与你工作过的其他地方相比，最独特的地方在哪里？

---

### [00:05:31] Mayur Kamat

**English:**
Yeah. Maybe just a background for Binance, because I think a lot of people have heard it, some in positive connotations, some not so much. The scale of Binance is pretty mind-boggling. Just to give the history, they started in 2017 as a crypto exchange, when there were other crypto exchange on the market for years, like Coinbase. Within six months, they became number one. That's unprecedented. That's like launching a search engine today, and then, six months later, beating Google. Then they went within five years to at a peak valuation of somewhere like $400 billion or so with 2000 employees. That's zero to $400 billion in five years. It's at a scale that's never been done before. Google couldn't do it, Facebook, none of the names that you hear. It's remarkable. When I was there as the head of product, my top line KPI was the trading volume, and my monthly KPI was in trillions of dollars.

**中文翻译:**
是的。也许先介绍一下币安的背景，因为我想很多人都听说过它，有些是正面的，有些则不然。币安的规模相当惊人。回顾一下历史，他们在 2017 年作为加密货币交易所起步，当时市场上已经有像 Coinbase 这样存在多年的交易所了。但在六个月内，他们就成了行业第一。这是史无前例的。这就像今天发布一个搜索引擎，六个月后就打败了谷歌。然后他们在五年内达到了约 4000 亿美元的峰值估值，当时只有 2000 名员工。五年内从零增长到 4000 亿。这种规模是前所未有的，谷歌做不到，脸书也做不到，你听过的任何名字都做不到。这非常了不起。当我在那里担任产品负责人时，我的核心 KPI 是交易量，而我的月度 KPI 是以万亿美元计的。

---

### [00:06:35] Mayur Kamat

**English:**
Just the scale was mind-boggling. We had teams of 10, 20 people running multi-billion dollar profit businesses. That brings in with it, first, how did they do that to that scale, and two, what kind of culture requires to keep that running? Both are very fascinating. I think we could spend a lot of time talking about it, but the truly interesting thing, the first one is, you can't do this by having a traditional log structure. CZ, the founder and CEO at one point had 55 direct reports, and his direct reports had about the similar ones. For a large portion of the history of the company, there was just one level between the individual employees and the CEO. That leads to an extreme level of decision-making and execution. You cannot have one-on-ones when you have 55 direct reports, so there's a culture of one-to-many and doing that as often as possible.

**中文翻译:**
那种规模简直令人难以置信。我们有 10 到 20 人的团队，经营着利润数十亿美元的业务。这引出了两个问题：首先，他们是如何做到这种规模的？其次，维持这种运转需要什么样的文化？这两点都非常迷人。我想我们可以花很多时间讨论这个，但真正有趣的第一点是，你不能通过传统的组织架构来做到这一点。创始人兼 CEO CZ 曾一度有 55 个直接下属，而他的下属也有类似数量的下属。在公司历史的大部分时间里，普通员工和 CEO 之间只有一层。这导致了极高水平的决策和执行。当你拥有 55 个直接下属时，你无法进行一对一谈话（One-on-ones），所以形成了一种“一对多”的文化，并尽可能频繁地进行。

---

### [00:07:33] Mayur Kamat

**English:**
The leadership team, for example, met every day, and because the leadership team was spread across the world, we met at 11:00 PM when I was in Singapore every day. That includes the weekends, holidays. The leadership team was there, 11:00 PM every single day, which meant that none of the decisions were blocked for more than 24 hours. Most of them, we made it on chat even within those 24 hours, but if there was something big, it was escalated, decided. We executed largely based on this concept that I now take with me. I call it running products via daily meeting. We would pick a owner for something really urgent at the nightly leadership call. Then that owner would be expected to have all hands on deck for however long that problem is every single day and then report the updates on the daily call. Some of these were really massive topics, like how do we get 15 financial licenses in 15 countries in the next three months? It wouldn't be at a scale that was-

**中文翻译:**
例如，领导团队每天都会开会。由于领导团队遍布全球，当我在新加坡时，我们每天晚上 11 点开会。这包括周末和节假日。领导团队每天晚上 11 点准时出现，这意味着任何决策都不会被搁置超过 24 小时。大多数决策我们在 24 小时内通过聊天软件就搞定了，但如果有大事，就会升级并拍板。我们的执行很大程度上基于一个我现在一直沿用的概念，我称之为“通过每日会议运行产品”。我们会在每晚的领导层电话会议上为紧急事项挑选一名负责人。然后，该负责人被要求在问题解决期间每天全力以赴（All hands on deck），并在每日电话会议上汇报进展。其中一些是非常宏大的课题，比如“我们如何在未来三个月内获得 15 个国家的 15 张金融牌照？”这规模简直——

---

### [00:08:43] Lenny Rachitsky

**English:**
You've got 24 hours.

**中文翻译:**
你只有 24 小时。

---

### [00:08:45] Mayur Kamat

**English:**
Yes, and people did it. It's extremely interesting to see that when you have really smart people, you give them really hard problems, you have no constraints on what can you need to solve them, whether it's money, people, except time. Time is always at a premium. People can move mountains in a small amount of time. That extreme ownership culture, I think, probably was the most fascinating part of working at Binance that I've now tried to take. There's some good parts of it in terms of attention to detail, being able to pick certain areas and own it, irrespective of what your title is and how many people report to you. There are certain downsides in terms of the amount of randomization that it can cost teams, especially if it's not super well-thought through. I'm trying to see what are the great parts of that that I can bring to different roles, but that concept of daily meeting, if there's something super urgent, how can you own it directly and run it yourself, where you are in the details so your team knows that they need to be in the details, and then be able to execute that. That's probably the most fascinating. There's several war stories. I was there for two years and the amount of interesting stories that happened during that time is a lot, but then, maybe I can follow up later if you have specific questions there.

**中文翻译:**
是的，而且人们做到了。看到这一点非常有趣：当你拥有极其聪明的人，给他们极其困难的问题，并且除了时间之外，不给他们任何解决问题的限制（无论是金钱还是人力），人们可以在极短的时间内移山填海。这种“极致主人翁意识”（Extreme Ownership）文化，我认为可能是在币安工作最迷人的部分，我现在也试图借鉴它。它在关注细节、能够认领并负责特定领域（无论你的头衔是什么或有多少下属）方面有很多优点。当然也有缺点，比如可能给团队带来随机性和干扰，特别是如果考虑不周的话。我正在尝试将其中优秀的部分带到不同的角色中，比如“每日会议”的概念：如果有紧急情况，你如何直接负责并亲自运行，让你深入细节，从而让你的团队知道他们也需要深入细节，然后去执行。这可能是最令人着迷的。那里有很多“战争故事”。我在那里待了两年，那段时间发生的趣事太多了，如果你有具体问题，我稍后可以跟进。

---

### [00:10:13] Lenny Rachitsky

**English:**
I would love to hear a war story. This is definitely as interesting as I was expecting it to be. Just what I'm hearing so far is just things that worked well for them to operate at this insane pace and scale is the entire leadership team meeting every single day, 11:00 PM your time. Hopefully, at better times for other folks around the world.

**中文翻译:**
我很想听听“战争故事”。这确实和我预期的一样有趣。到目前为止我听到的是，他们之所以能以这种疯狂的速度和规模运作，是因为整个领导团队每天都在开会，你那边是晚上 11 点。希望对世界其他地方的人来说时间能好一点。

---

### [00:10:31] Mayur Kamat

**English:**
There's some people in Sydney, Australia, so it was 1:00 AM for them.

**中文翻译:**
有些人在澳大利亚悉尼，所以对他们来说是凌晨 1 点。

---

### [00:10:34] Lenny Rachitsky

**English:**
Good grief. This idea of a flat structure, yeah, it's interesting, because I imagine that's not necessarily great for other reasons and then this idea of being in the details. Let me ask about that, actually. What does that actually look like? I think a lot of people, a lot of leaders are like, "Oh, yeah. I'm in the details, we should be in the details." What does that actually look like in real life at Binance?

**中文翻译:**
天哪。这种扁平化结构的想法很有趣，因为我猜出于其他原因这不一定总是好事。还有“深入细节”的想法，我想问问这个。这在实际中是什么样的？我想很多领导者都会说：“噢，是的，我深入细节，我们也应该深入细节。”但在币安的现实生活中，这到底意味着什么？

---

### [00:10:55] Mayur Kamat

**English:**
Let me give an example. One of the areas, when I joined, one of the biggest product problem we had was, crypto before was fairly unregulated, so you could just sign up with an email address or even just a wallet and start trading. There was almost zero friction. Then it suddenly became regulated, where you would almost have a full KYC flow like a bank. That just meant that the conversion rate dropped from, let's say, 100% to 2%. Now we had to solve this problem. This was the daily meeting level problem. It's okay if you're operating in one country. You can do it easily. If you're operating in 200 countries where there's not even a standard for what a document acceptance criteria might look like, now you have a significantly larger problem. You cannot say, "Let's work with the KYC vendor and do the onboarding."

**中文翻译:**
让我举个例子。当我加入时，我们面临的最大产品问题之一是：以前加密货币几乎不受监管，所以你只需一个邮箱地址甚至一个钱包就能注册并开始交易，几乎零摩擦。然后突然之间它受到了监管，你必须像银行一样拥有完整的 KYC（身份验证）流程。这意味着转化率从 100% 掉到了 2%。现在我们必须解决这个问题。这就是“每日会议”级别的问题。如果你只在一个国家运营，这很容易解决。但如果你在 200 个国家运营，而这些国家甚至连证件受理标准都没有统一，那么问题就大得多了。你不能只是说：“让我们找个 KYC 供应商来做入职流程吧。”

---

### [00:11:49] Mayur Kamat

**English:**
We had to, literally have this, the top 50 countries, the top 10 document types, this spreadsheet of basically 500 cells, the conversion rate at each level. Then we are looking at, okay, a passport in Kazakhstan has very low level of conversion. What can we do about that? Do we need a new vendor? Do we need better imaging technology? Do we need a new SDK from a vendor? Then we go cell by cell based on, let's say if I was running a typical product team, I would say, okay, let's just look at maybe the top 90 percentile of our users, but this was Binance and then CZ is like, "No user left behind. Even that one user in Congo is important because this is financial inclusion for them." Then all of those 500 sales matter, no matter how low their impact to the conversion rate is.

**中文翻译:**
我们必须建立一个包含前 50 个国家、前 10 种证件类型的电子表格，基本上有 500 个单元格，记录每个环节的转化率。然后我们会看，比如哈萨克斯坦的护照转化率非常低，我们能做些什么？我们需要新供应商吗？我们需要更好的图像识别技术吗？我们需要供应商提供新的 SDK 吗？然后我们逐个单元格进行分析。如果我管理的是一个典型的产品团队，我会说，好吧，我们只看前 90% 的用户。但这是币安，CZ 的态度是：“不让任何一个用户掉队。即使是刚果的那一个用户也很重要，因为这对他们来说是金融普惠。”所以，无论那 500 个单元格对整体转化率的影响有多小，它们都至关重要。

---

### [00:12:45] Mayur Kamat

**English:**
That's a little bit of Binance flavor there. It's extreme customer focus and it doesn't really matter. Customers are not a number. It's a person at the end of the screen and we care about them, so you would need to know, you would get questions like, why is the driver's license acceptance rate in Kenya falling suddenly? When you have, and that's just one piece of the problem in a large product with 80 different products. You, of course, cannot do it for every single product, but the concept of, what is the most leveraged decision you could be working on right now? If it is for your growth, it's the onboarding, then you'd better know exact every single screen of the flow, why is there a drop-off and what are your teams doing for it? That level of detail, and you just do it on different products at different parts of your journey.

**中文翻译:**
这就是一点“币安味儿”。那是极度的客户导向，而且真的不计代价。客户不是一个数字，屏幕另一端是一个活生生的人，我们关心他们。所以你需要知道，你会遇到这样的问题：为什么肯尼亚的驾照受理率突然下降了？而这只是一个拥有 80 种不同产品的大型产品中的一小部分问题。当然，你不可能对每个产品都做到这种程度，但核心概念是：你现在能做的杠杆率最高的决策是什么？如果为了增长，那就是入职流程，那么你最好了解流程中的每一个屏幕，为什么会有流失，以及你的团队正在为此做什么。就是这种程度的细节，你在职业生涯的不同阶段对不同的产品应用这种方法。

---

### [00:13:43] Lenny Rachitsky

**English:**
I imagine there's people listening where they're like, there's the team responsible for the onboarding flow and the KYC flow of their product and it's so hard. They're like, oh, there's all these problems with our flow. Imagine that for 100 different versions of the flow across 100 different countries. Good God.

**中文翻译:**
我想听众里肯定有人在想，他们负责自己产品的入职和 KYC 流程就已经够难了，到处都是问题。想象一下，在 100 个不同的国家有 100 个不同版本的流程。天哪。

---

### [00:14:01] Mayur Kamat

**English:**
And documents. It gets very tricky. It gets very tricky, but we also had resources. At one point in time we said, we had a team of 20 people working on KYC and we said, "For the next three months, we want 500."

**中文翻译:**
还有各种证件。这变得非常棘手。非常棘手，但我们也有资源。有一次我们说，我们有一个 20 人的团队在做 KYC，然后我们说：“接下来的三个月，我们要 500 人。”

---

### [00:14:16] Lenny Rachitsky

**English:**
Which has its own downsides, too.

**中文翻译:**
这也有它自身的弊端。

---

### [00:14:18] Mayur Kamat

**English:**
Has its downside, but if you're running in this extreme mode and you're less, not as worried about just the team's stress and personal development aspects of it, you're just purely looking at the execution of the product, there's a surprising amount of power that comes with it. This was probably the second time in my career where I had that, wow, you can do this because in other companies it would take years to do it. The first one was, this is going back at Google. I remember I joined Google. It was my first day at onboarding and I was the product manager for Gmail for mobile, for sync. I was in my onboarding meeting when they pulled me out and said, "Hey, we have an issue. The service is down and Wall Street Journal is writing an article that Google, Microsoft, Apple not working together causing the service to go down, so we need you in this war room right now."

**中文翻译:**
确实有弊端。但如果你在这种极端模式下运行，不太担心团队压力和个人发展，而只是纯粹关注产品执行，那么它会产生惊人的力量。这可能是我职业生涯中第二次感到“哇，竟然可以这样”，因为在其他公司这需要数年时间。第一次是在谷歌。我记得我刚加入谷歌，第一天入职培训，我是 Gmail 移动端同步的产品经理。我还在开入职会，他们就把我拉出来说：“嘿，出事了。服务挂了，《华尔街日报》正在写文章说谷歌、微软、苹果互不配合导致服务中断，所以我们需要你立刻进作战室。”

---

### [00:15:17] Mayur Kamat

**English:**
It was a bug in iOS 4. This is a long time ago, which caused every single user to pull their entire Gmail inbox, re-sync the whole inbox. A bug on the Apple side is going to take two, three weeks to fix, and it was causing 1000x load to our servers. I remember Connie Wurz, who was the Head of Infrastructure at Google, and he's like, "Sure." He flipped a button and there were 1000x servers that showed up for the next two weeks. I was like, "Wow, that is scale," right? This was my second time feeling that wow moment where like, oh, we just put 500 people in and solve the problem. It's less about having the 500 people and being able to maneuver them that quickly. I don't think I've been able to do that at any other company.

**中文翻译:**
那是 iOS 4 的一个 Bug，很久以前的事了。它导致每个用户都拉取整个 Gmail 收件箱，重新同步。苹果那边的 Bug 需要两三周才能修复，这给我们的服务器带来了 1000 倍的负载。我记得当时的谷歌基础设施负责人 Connie Wurz 说：“没问题。”他按下一个按钮，接下来的两周里出现了 1000 倍的服务器。我当时想：“哇，这就是规模。”这是我第二次感到那种震撼时刻，就像“噢，我们直接投入 500 人就把问题解决了”。重点不在于拥有 500 人，而在于能够如此迅速地调动他们。我想在其他任何公司我都做不到这一点。

---

### [00:16:06] Lenny Rachitsky

**English:**
To close the loop on some of these radical ways of working, this idea of 50 reports per person and this idea of caring about a person in Congo not being able to sign up, do you think that's a good idea? Do you take those in the way you work now or is it just, in this particular situation it's important? Other places, maybe not.

**中文翻译:**
为了总结这些激进的工作方式，比如每人 50 个下属，以及关心刚果的一个人能否注册，你认为这是个好主意吗？你现在的工作方式中会采用这些吗？还是说这只是在特定情况下才重要，其他地方可能不适用？

---

### [00:16:26] Mayur Kamat

**English:**
There are several preconditions. One is you're growing really fast. The growth for the employees comes just from seeing problems at scale that are growing every day that it needs less of a manager's attention to figure out what you need to grow. The best way to grow in general is that you work at a very fast-growing company. If that's true, two, your people are extremely well compensated, so they care about the KPIs more than they care about what's the next stage in my career and how do I get promoted? Our bonus structure went from 0% to 500%, so a lot of people didn't really care getting a 10%, 20% pay. They just want to do incredible work because they know they would be taken care of. Three, it's a mission driven company, still believe at the end of the day that you're doing this just beyond the KPI.

**中文翻译:**
这有几个前提条件。第一，你增长得非常快。员工的成长来自于每天面对不断增长的大规模问题，这不需要经理花太多心思去告诉他们该如何成长。通常最好的成长方式就是去一家高速增长的公司。第二，如果前提成立，你的员工薪酬极高，所以他们更关心 KPI，而不是职业生涯的下一阶段或如何晋升。我们的奖金结构从 0% 到 500% 不等，所以很多人并不在乎 10% 或 20% 的加薪，他们只想做出惊人的工作，因为他们知道自己会得到丰厚的回报。第三，这是一家使命驱动的公司，大家打心底里相信做这件事不仅仅是为了 KPI。

---

### [00:17:24] Mayur Kamat

**English:**
At Binance, there was a very strong belief that 80% of the world doesn't have access to financial tools. They don't even have an access to currency that they can trust. When we look at, live in Europe or in US and we think about crypto, it's largely about speculation or bitcoin. For most of the world, they just need access to a US dollar, stable coin and just knowing that my currency is not getting deinflated because of things beyond my control. Everyone having come from these, a lot of our employees were across all these countries, they had a very strong mission belief that what we are doing will truly empower billions of people. There's a power in that. A lot of people go through, "Hey, I'm going to move mountains because it's not just about the money, it's just not about my career. It's about doing something that will change the world."

**中文翻译:**
在币安，有一种非常强烈的信念：世界上 80% 的人无法获得金融工具，他们甚至无法获得可以信任的货币。当我们住在欧洲或美国看加密货币时，很大程度上是关于投机或比特币。但对于世界上大多数人来说，他们只需要获得美元稳定币，并知道自己的货币不会因为无法控制的因素而贬值。我们的许多员工来自这些国家，他们有着强烈的使命感，相信我们所做的事情将真正赋能数十亿人。这其中蕴含着力量。很多人会想：“嘿，我要移山填海，因为这不仅仅是为了钱，也不仅仅是为了我的职业生涯，而是为了做一些能改变世界的事情。”

---

### [00:18:19] Lenny Rachitsky

**English:**
Let's follow this thread on accelerating your career, and talk about where you're at today, N26. As you know, I've been doing a bunch of research on which companies hire and produce the best product managers. I've done a couple passes at this, and N26 has come up in the top five of both ways of approaching this, essentially which companies alumnis go on to do the best in their career. N26 is way up there. I want to come at this from a couple directions. One is what N26 as a company does to hire and incubate the best people, but also just you personally, what your advice is to people and how you help them become great PMs. Let's actually start in that second bucket. What is the most common and most impactful career advice that you share with product managers that you manage, that you find most helps them move ahead in their career and get unstuck in their career?

**中文翻译:**
让我们顺着加速职业生涯这个话题，聊聊你现在所在的 N26。如你所知，我一直在研究哪些公司招聘和培养了最优秀的产品经理。我做了几次调研，N26 在两种评估方式中都进入了前五名，即哪些公司的校友在职业生涯中表现最出色。N26 名列前茅。我想从两个方向来探讨：一是 N26 作为一个公司在招聘和孵化人才方面做了什么；二是就你个人而言，你对人们有什么建议，以及你如何帮助他们成为优秀的 PM。让我们从第二个方面开始。你对你管理的产品经理分享的最常见、最有影响力的职业建议是什么？你发现哪些建议最能帮助他们在职业生涯中前进并摆脱困境？

---

### [00:19:12] Mayur Kamat

**English:**
I think the number one thing I shared before, the best thing you can do is find companies that are growing fast because it compounds your learning at a much faster interval. Just the basic compound interest formula, even if your interest rate is low, if you're compounding daily versus compounding yearly, after two years, you will be at a whole different stage at the end point. Companies that are growing fast just lets you get that learning much, much quicker. I remember joining Microsoft first in my career. Some of the products I worked on during my internship had not shipped till I left Microsoft three, four years later. That's a very, very low rate of compounding. Microsoft's a whole different company now 20 years later, thankfully. Then you contrast that something like Binance where every day or every hour, every minute you're shipping something and then learning from it.

**中文翻译:**
我想第一点就是我之前分享过的：你能做的最好的事情就是找那些快速增长的公司，因为这会让你的学习以更快的频率产生复利。就像基础的复利公式一样，即使利率较低，如果每天计息与每年计息相比，两年后你所处的位置将完全不同。快速增长的公司能让你更快地获得学习。我记得职业生涯第一站是微软。我在实习期间参与的一些产品，直到我三四年后离开微软时还没发布。那是极低的复利增长率。幸好 20 年后的微软已经完全不同了。相比之下，像币安这样的公司，每一天、每一小时、每一分钟你都在发布东西并从中学习。

---

### [00:20:04] Mayur Kamat

**English:**
The faster you can compound your learning, the faster you will grow. The second piece generally is, you need to optimize for what you're great at. Now having two kids, I'm fairly in the fact that your strengths get defined very, very early, right? I'm looking at my nine-year-old and twelve-year-old, and they have a whole different set of strengths. If you're 25 years old early in your career, it's very hard at that point to say, "Oh, here are all my weaknesses and I need to improve on those." A lot of the career feedback typically tends to be around, "Hey, here are the things you need to be better at. Why don't you do more of that stuff, right?" Formally in the camp that you need to know what you're great at, what are your superpowers, and you need to find jobs where success is determined by how much of that superpowers you get to use.

**中文翻译:**
你学习复利的速度越快，成长就越快。第二点通常是，你需要优化你的强项。现在有了两个孩子，我深信人的优势在很小的时候就定义好了。看着我 9 岁和 12 岁的孩子，他们有着完全不同的优势。如果你 25 岁，处于职业生涯早期，那时很难说“噢，这些是我的弱点，我需要改进它们”。很多职业反馈通常倾向于说：“嘿，这些是你需要做得更好的地方，你为什么不多做点这些呢？”我坚定地认为，你需要知道自己擅长什么，你的“超能力”是什么，并且你需要找那些成功取决于你能发挥多少超能力的工作。

---

### [00:20:58] Mayur Kamat

**English:**
Early in your career, you can't get away with the fact that there's some stuff you're not going to be great at and you just have to manage around it. If you get higher up in your career, then it gets easier because you can build a team that complements your strengths, but again, if you're early in your career, find places that, if you're a great creative person, if you can look at a product and think of 100 things you can do better, you are always about what's the next best thing and how quickly can I implement it, you need to be working in teams that have a high experimentation culture. You need to be working in growth teams in large companies. If you work in a FinTech company on a compliance side project or launching a new business vertical, you're going to struggle, right?

**中文翻译:**
在职业生涯早期，你无法回避有些事情你就是不擅长的事实，你只能绕过它。随着职位的提升，这会变得容易些，因为你可以组建一个互补优势的团队。但如果你还在早期，找那些适合你的地方：如果你是一个极具创意的人，能看到产品并想到 100 个改进点，总是关注下一个好点子以及如何快速实现，那么你需要去有高度实验文化（Experimentation Culture）的团队，或者大公司的增长团队。如果你去金融科技公司的合规项目或启动新的业务垂直领域，你会很痛苦，对吧？

---

### [00:21:46] Mayur Kamat

**English:**
On the same time, if you have extreme management structured thinking, you have great stakeholder management, you have high EQ, you should work in teams where there is a large amount of complex people management and process management. You would struggle in a growth team where the expectation is you're doing things really quickly. I would look at first very introspectively, what are my true strengths? What do I, and then look at jobs where that has a much higher profile of winning. Thirdly, largely I would say do not optimize for compensation, especially early in your career. If you're truly on a track to become an executive someday or found your own company and make it successful, you will find that the compensation is so much backloaded that you would make 90% of your compensation in the last five years of your career, so optimizing for 10%, 20% early in your career.

**中文翻译:**
与此同时，如果你有极强的管理结构化思维、优秀的利益相关者管理能力和高情商，你应该去那些涉及大量复杂人员管理和流程管理的团队。如果你去一个要求快速行动的增长团队，你会很挣扎。我会建议先进行深刻的内省：我真正的优势是什么？然后找那些能让这些优势大放异彩的工作。第三，总的来说，不要为了薪酬而优化，尤其是在职业生涯早期。如果你真的打算有一天成为高管或创办自己的公司并取得成功，你会发现薪酬是高度“后置”的，你 90% 的收入可能来自于职业生涯的最后五年。所以，在早期为了 10% 或 20% 的薪差去优化是没有意义的。

---

### [00:22:48] Mayur Kamat

**English:**
If you have two jobs, I would rank in your first 15 years of your career, I would say do not look at the compensation. Then the last one, this was strange. I never thought about this longer, but now I think this is probably the most interesting advice I can give people is determine very early in your career if you truly want to be a C-level someday, you want to be an executive someday, because it's almost like if you're ambitious and successful, you enter product management. You are in top of your, it's almost an expectation of you that you would become that and you'd never really challenge or question yourself, is this the thing that needs me, that I need to do to get there? Is there something I'm going to truly enjoy? Not just the destination but the process to get there.

**中文翻译:**
如果你有两份工作，在职业生涯的前 15 年，我会说不要看薪酬。最后一点，这可能听起来有点奇怪，我以前没想过，但现在我觉得这可能是我能给出的最有趣的建议：在职业生涯早期就确定你是否真的想有一天成为 C 级高管。因为如果你有野心且成功，你进入了产品管理领域，大家几乎默认你会朝着那个方向走，而你可能从未真正挑战或质疑过自己：这是我需要的吗？这是我为了达到目标必须做的吗？我会真正享受这个过程吗？不仅仅是终点，还有通往终点的过程。

---

### [00:23:38] Mayur Kamat

**English:**
A lot of people think that and they make suboptimal decisions based on that. There's incredible careers you can build and incredible lives that you can live by just being great at what you do, doing more of that stuff. You end your career maybe as a director, maybe as a group product manager, but throughout the stuff, you have built a holistic life that doesn't revolve around your work and gives incredible meaning to you, or you can be saying, you know what? Work is a huge part of my identity. Somebody asks me what wakes me up in the morning and what gives me that energy? It's my work. I can't separate my identity from your work. Then maybe you should pursue that C-level path because it'll truly be fulfilling and you would be able to make those challenges and sacrifices that are going to be asked of you to make that.

**中文翻译:**
很多人没想清楚这一点，从而做出了次优的决策。你可以通过擅长自己的工作、多做自己喜欢的事，来建立精彩的职业生涯和生活。你退休时可能是一个总监，或者是一个组产品经理（GPM），但在整个过程中，你建立了一个不完全围绕工作转的、对你极具意义的完整生活。或者你可以说：你知道吗？工作是我身份的重要组成部分。如果有人问我每天早上起床的动力是什么？是我的工作。我无法将我的身份与工作分开。那么，也许你应该追求 C 级高管之路，因为那会让你真正感到充实，并且你能够应对那些为了达到那个位置而必须做出的挑战和牺牲。

---

### [00:24:30] Mayur Kamat

**English:**
If you can calibrate that early and have that true conversation with yourself like, "Yes, I want to go down that path and I want to do," you would make different career choices. In that path, I would definitely say don't look at compensation. There are two jobs. Look at the three things. Is it going to give me high compounding of learning? Is it high overlap with my strengths, and am I going to have a lot of fun doing it? If you have fun doing it, then it becomes a virtuous cycle and you do more of it and you're great at it.

**中文翻译:**
如果你能尽早校准这一点，并与自己进行真实的对话，比如“是的，我想走那条路”，你就会做出不同的职业选择。在那条路上，我绝对会说不要看薪酬。如果有两份工作，看这三点：它能给我带来高复利学习吗？它与我的优势高度重合吗？我会从中获得很多乐趣吗？如果你乐在其中，它就会变成一个良性循环，你会做得更多，也会做得更出色。

---

### [00:24:59] Lenny Rachitsky

**English:**
For folks that are PMs today, there's almost an implication their career is heading towards CPO eventually. That's kind of the ladder they're on. What are the, say, top three most common other options you've seen, other paths you've seen of folks that you manage, so that people can think about, "Okay, I don't need to maybe just keep climbing this ladder. There's these other directions I can go."

**中文翻译:**
对于现在的 PM 们来说，似乎默认职业生涯最终会走向 CPO。这是他们所处的阶梯。那么，在你管理的人中，你见过的最常见的三种其他选择或路径是什么？这样人们可以思考：“好吧，也许我不需要一直爬这个阶梯，还有其他方向可以走。”

---

### [00:25:00] Mayur Kamat

**English:**
I mean the number one, and that's I think back to your original question on N26, if you work in incredibly high growth companies, especially FinTech where there's a higher, people end up being founders because it's probably a whole different kind of track we can go down on, the founding your own company is probably the most kind of obvious/exciting alternate path. The only thing I ask there is, again, the same question, what you're good at and what you love doing. The challenges with founding a company is a large portion of running a company has nothing to do with building a great product, especially as the company gets bigger. I've worked for founders now for 17 of my 20-year career, right. So, even at Google and stuff, Nikhil was my boss at Google, used to be a founder, and the CEOs now, the thing they tell me when they hire me is, "I wish I had your job," because that's what I used to do. That's what I have loved doing, and now I spend 90% of my time doing stuff that is not the stuff that I truly enjoy.

**中文翻译:**
我想第一点，回到你最初关于 N26 的问题，如果你在极高增长的公司工作，尤其是金融科技领域，很多人最终会成为创始人。这可能是一条完全不同的赛道，创办自己的公司可能是最显而易见且令人兴奋的替代路径。我唯一要问的还是那个问题：你擅长什么，你热爱做什么？创办公司的挑战在于，经营公司的大部分工作与打造优秀产品无关，尤其是当公司变大时。在我 20 年的职业生涯中，有 17 年是在为创始人工作。即使在谷歌，我的老板 Nikhil 以前也是创始人。现在的 CEO 们在雇佣我时会对我说：“我真希望我有你的工作，”因为那才是他们以前做的事，是他们热爱的事，而现在他们 90% 的时间都在做那些并不真正享受的事情。

---

### [00:28:37] Mayur Kamat

**English:**
But folks enjoy building stuff as a PM, there's a lot of things you don't have control over, and you feel like, "Hey, that's stopping me from growing. That's what's topping me from truly enjoying." Founding is a great path. You have that control now, you own the decision-making. There's rarely times you can say, "Hey, this did not work because of that person." Right? If you're constantly hitting that, then founding is a great path for you because then you have the ball control for better or worse.

**中文翻译:**
但作为 PM，人们喜欢构建东西，只是有很多事情你无法控制，你会觉得：“嘿，这阻碍了我的成长，这让我无法真正享受工作。”创业是一条伟大的路径。你现在拥有了控制权，拥有了决策权。你很少能说“嘿，这没成是因为那个人”。如果你经常遇到这种情况，那么创业对你来说是一条很好的路，因为无论好坏，球都在你手里。

---

### [00:29:08] Mayur Kamat

**English:**
The other is just, I mean, it's less about being a CPO and just growing your breadth and your depth instead of just the ladder, right? So you are incredibly, either getting specialized in a specific domain where there is now enough value for you to separate yourself from the pack, whether it's, like in FinTech, now we have folks who are onboarding experts with KYC. We have people who are fraud experts, who have really great understanding of how card schemes work and how MasterCards work and where can we get the right incentives for the user. The folks who are experts on customer loyalty and retention. You build that domain expertise and then you realize that everyone needs that, right? And that could be an incredible way to specialize. So, you may lead growth at certain team even though you're not a CPO, right? So, that's kind of the second way of doing it.

**中文翻译:**
另一种方式是，不一定要当 CPO，而是增加你的广度和深度，而不是仅仅爬梯子。你可以选择在特定领域深耕，直到你产生的价值足以让你脱颖而出。比如在金融科技领域，我们有专门负责 KYC 入职的专家，有反欺诈专家，有对卡组织运作、万事达卡机制以及如何为用户提供正确激励有深刻理解的人，还有客户忠诚度和留存专家。你建立了这种领域专长，然后你会发现每个人都需要它。这是一种极好的专业化方式。所以，你可能会在某个团队领导增长，即使你不是 CPO。这是第二种方式。

---

### [00:30:05] Mayur Kamat

**English:**
And the third one, again, just not to knock it out, is you realize that work is not going to be my big part of my identity. My identity is, who am I as a parent? Who am I as a community member? Who am I as a son to my parents? Who am I as an artist or a contributor? And that's what my death is going to be, a well-rounded person. And a job is great, I'm great at it, but I'm going to do it as much as it's needed. And the value and meaning, the top part of the Maslow's pyramid comes from everything but work. And then you just lead kind of a balanced life because then work is a certain portion of it and the rest kind of fills the picture.

**中文翻译:**
第三种，再次强调，这并不是贬低它，就是你意识到工作不会成为我身份的主要部分。我的身份是：我作为父母是谁？我作为社区成员是谁？我作为父母的儿子是谁？我作为艺术家或贡献者是谁？我希望我最终是一个全面发展的人。工作很棒，我也很擅长，但我只会投入必要的精力。马斯洛需求金字塔顶端的价值和意义来自于工作之外的一切。然后你过上一种平衡的生活，工作只是其中的一部分，其余部分填满了整幅画面。

---

### [00:30:51] Lenny Rachitsky

**English:**
So, just to summarize these four really good pieces of advice for how to essentially keep your career going and get unstuck and accelerated, is work at companies that are really high growth because your learnings will compound, and also the network you build, you didn't even mention that, that becomes really valuable because especially if the company does well, sometimes companies grow really well and there's extra benefits there, but even if they aren't, you still earn a lot.

**中文翻译:**
所以，总结一下这四个关于如何保持职业生涯前进、摆脱困境并加速的极好建议：去高速增长的公司工作，因为你的学习会产生复利；还有你建立的人脉网络（你甚至还没提到这一点），这变得非常有价值，尤其是如果公司表现出色，有时会有额外的收益，但即使没有，你仍然收获颇丰。

---

### [00:31:16] Mayur Kamat

**English:**
Absolutely. Well, let's say N26, one of the reasons why they have so many founders is the fact that it was a category defining, like we were the first kind of mobile bank, right? So, a lot of the problems we saw in early days, nobody else saw them, right? So, every product manager had to solve it for the very first time in history. And that kind of is a whole different level of kind of trial by fire. Same thing with Revolut. They both started about the same time. Those are the companies that show up in the top rankings because you did this before anybody could do it, and you learn by literally moving mountains. I think two is also the fact that you see, we have this whole PayPal mafia. When you see this early success, everyone sees it together. So, when they go, they have that network, as you said, built-in.

**中文翻译:**
绝对是。以 N26 为例，它之所以诞生了这么多创始人，是因为它是“品类定义者”，我们是第一家移动银行。所以，我们在早期看到的很多问题，别人都没见过。每个产品经理都必须在历史上第一次去解决这些问题。这是一种完全不同级别的“战火洗礼”。Revolut 也是一样，它们几乎同时起步。这些公司之所以名列前茅，是因为你在任何人之前就做到了这一点，你是通过真正的移山填海来学习的。第二点是，就像“PayPal 黑手党”一样，当你见证了早期的成功，大家是共同见证的。所以当他们离开时，正如你所说，他们拥有了内置的人脉网络。

---

### [00:32:10] Mayur Kamat

**English:**
These are, maybe it's a product manager who starts a company, but maybe there is a business development manager who has also started this company and now you can collaborate and have partnerships. So, that success, a mutual success, which a lot of early startup see, that creates kind of a more denser network than you working at a large company where not all of you see the success at the same time. And 3Ls comes down to the founders as well. They're incredibly mission-driven founders. I always find it super admiring now when I look back at Valentin and Max here at N26, or I look at CZ. They have reached from a whatever metric you can define of success, whether it's the size of the company, whether it's the personal network, beyond whatever anybody would think success means, right? And then, to wake up every day and to do this hours and hours single day, every single day, you are driven by a whole.

**中文翻译:**
这些人中，可能是一个产品经理创办了公司，但也可能有一个业务发展经理也创办了公司，现在你们可以协作并建立伙伴关系。这种共同的成功（很多早期初创公司都会经历）创造了一个比在大公司工作更稠密的人脉网络，在大公司里，并不是所有人都能同时见证成功。第三点归结为创始人。他们是极具使命感的创始人。当我回看 N26 的 Valentin 和 Max，或者看 CZ 时，我总是充满敬意。无论你用什么指标来定义成功——公司规模、个人人脉——他们都早已超越了常人对成功的定义。然而，他们每天醒来，日复一日地投入大量时间，这背后一定有更深层的驱动力。

---

### [00:33:14] Mayur Kamat

**English:**
These are the voyagers of, these are the folks who would go explore new planets in the future or the folks who sailed out on the seas in 1600s to discover new land. That being access to these people directly is extremely, extremely empowering. You not just learn from it, but you get inspired by it. If you have an X definition of success, now your definition of success is 10x, you automatically push the boundaries more. So, I think those two things are, or those three things, early start, category defining companies, mutual success and creation of dense networks, and just being inspired by incredibly, incredibly successful and talented people.

**中文翻译:**
这些人是航海家，是未来会去探索新星球的人，或者是 17 世纪出海寻找新大陆的人。能够直接接触到这些人是非常非常有力量的。你不仅能学到东西，还能受到启发。如果你以前对成功的定义是 X，现在变成了 10X，你就会自动地去突破更多的边界。所以，我认为这三点很重要：早期加入品类定义型公司、共同成功并建立稠密网络、以及受到极其成功和有才华的人的启发。

---

### [00:33:59] Lenny Rachitsky

**English:**
You pointed out this really interesting insight that I forgot to mention with the list of companies that seem to hire and create the strongest PMs. There's a lot of FinTech representation there, and I think you touched on why that might be the case because all these problems are extremely complicated and never been solved and they're solving at scale.

**中文翻译:**
你指出了一个非常有趣的见解，我在列举那些培养最强 PM 的公司名单时忘了提。名单里有很多金融科技（FinTech）公司的代表，我想你已经触及了原因：因为这些问题极其复杂，从未被解决过，而且他们是在大规模环境下解决这些问题的。

---

### [00:34:17] Mayur Kamat

**English:**
Here's the thing about FinTech, which is probably the most interesting is, FinTech, you have two customers. You have your usual customers and you have your regulator, and you need to keep both of them happy. And usually, what makes one happy, it makes the other one less happy, right? So, you are constantly dealing with trade-offs. In most PMs, in most companies you have some trade-offs, but they're not existential. Whereas in FinTech, every trade-off is existential. When you found a company, every trade-off is existential. You may not exist as a business if you make a wrong decision. In FinTech, a lot of the PMs see that day in day out, and that probably kind of conditions them to a whole different level of juggling balls than you would be a PM at other company.

**中文翻译:**
关于金融科技，最有趣的一点是：你有两个客户。一个是普通用户，另一个是监管机构。你需要让双方都满意。通常情况下，让一方满意的事会让另一方不那么开心。所以，你一直在处理权衡（Trade-offs）。在大多数公司的 PM 工作中，你也有权衡，但它们不是生死攸关的。而在金融科技领域，每一个权衡都是生死攸关的。当你创办一家公司时，每一个权衡也是生死攸关的。如果你做错了一个决定，你的业务可能就不复存在了。在金融科技领域，很多 PM 每天都在经历这些，这可能让他们在处理多重任务和复杂局面时，达到了其他公司 PM 无法企及的水平。

---

### [00:35:00] Lenny Rachitsky

**English:**
Yeah, that's such a good point. Just really good stakeholder management influence dealing with all these trade-offs. I think that's a really good point. I'm going to come back to the strength stuff because that's really important and I've been meaning to come back to it. So, just to reflect back, the four things you pointed out are really what you want to look for to accelerate your career. Companies that are growing really fast, working on things that you're good at, and finding a role that leverages your strengths versus things that you're not good at. Not optimizing for comp really is such a good point there. Your point essentially is you'll make most of your comp later, probably the 50%. The second half of your career, you probably make, I don't know, 10 times more than you make the first part of your career.

**中文翻译:**
是的，这一点说得太好了。处理这些权衡需要极强的利益相关者管理和影响力。我想回到关于“优势”的话题，因为这非常重要。回顾一下，你指出的加速职业生涯的四点是：去高速增长的公司、做你擅长的事、找能发挥你优势而非暴露短处的角色。不为了薪酬而优化也是极好的一点。你的核心观点是，你大部分的收入会在后期产生，可能占到 50% 以上。在职业生涯的后半段，你的收入可能是前半段的 10 倍。

---

### [00:35:37] Lenny Rachitsky

**English:**
And so, optimize for the future comp, not today's comp. And then this idea of making sure, ask yourself, do you want to be CPO? Do you want to go down the C-suite route or do you want to maybe probably plan to start a company, something else? And that informs the role you're in. Coming back to the strength stuff, how do people figure out their strengths? Do you have any advice for someone sitting around, they're like, "What am I actually good at? I don't know."

**中文翻译:**
所以，要为未来的薪酬而优化，而不是眼前的。还有就是要问自己：你想当 CPO 吗？你想走高管路线，还是计划创业或做点别的？这决定了你选择的角色。回到优势的话题，人们如何发现自己的优势？对于那些坐在那里心想“我到底擅长什么？我不知道”的人，你有什么建议吗？

---

### [00:36:00] Mayur Kamat

**English:**
So, there's several ways to do it. I remember I read this book, this was, I don't think it shaped my understanding of it because I was already operating in that mode, but it used to be called Now Discover Your Strengths. I think now it's called Strength Finder 2.0. It's still 20 years old now, but there's a lot more newer ways to do it. There are two things I have done and they're both kind of, I'm not sure how accessible they are, but I'll give you the examples. So, at a Agoda, we used to pay a psychologist $5,000 for every single PM we interview, right? So, after you finish your PM rounds, we would send you to this psych assessment. It would be a six-hour psych assessment and they would tell me what your strengths are, not just that it would be an IQ component.

**中文翻译:**
有很多方法。我记得读过一本书，虽然它没有重塑我的理解，因为我已经在那种模式下运作了，那本书叫《现在，发现你的优势》（Now Discover Your Strengths），现在好像叫《优势识别器 2.0》（Strength Finder 2.0）。虽然是 20 年前的书了，但现在有很多新方法。我做过两件事，我不确定它们的普及程度，但我可以举例说明。在 Agoda，我们过去会为面试的每一个 PM 支付 5000 美元请心理学家评估。在你完成 PM 面试轮次后，我们会送你去参加一个 6 小时的心理评估。他们会告诉我你的优势是什么，不仅如此，还有一个智商（IQ）测试部分。

---

### [00:36:51] Mayur Kamat

**English:**
So, we would know what percentile you are, and not just like an IQ score like Einstein or not, but IQ score across different, across pattern recognition or structured thinking, across numerical ability, verbal ability, right? So, a lot of people say they hire the smartest people. At Agoda, we literally hired the smartest people because we paid the psychologist a lot of money to tell whether they're smart or not. But other than that, they also give you your strengths and weaknesses. It used to be called, I know the company still around, it's called Q4, and it's called Q4 because they had this four quadrants on two axes, one is on dominance and one is on warmth, right? So, you want people who are high dominance, high warmth in the 4 quadrant, and that as you can realize, if you also want smart people, to find those who land in that quadrant is literally looking through a needle through a haystack.

**中文翻译:**
所以我们会知道你处于什么百分位，不只是像爱因斯坦那样的总分，而是涵盖模式识别、结构化思维、数学能力、语言能力等不同维度的智商得分。很多人说他们雇佣最聪明的人，在 Agoda，我们是真的雇佣最聪明的人，因为我们花了大钱请心理学家来判断他们是否聪明。除此之外，他们还会给出你的优缺点。那个评估以前叫 Q4（我知道那家公司还在），之所以叫 Q4 是因为他们有两个轴形成的四个象限：一个是支配力（Dominance），一个是亲和力（Warmth）。你想要的是第四象限中高支配力、高亲和力的人。你可以想象，如果你还要求聪明，那么在那个象限里找人简直是大海捞针。

---

### [00:37:43] Mayur Kamat

**English:**
But when I, I almost didn't do it. I was like, this is like I've been doing products for 15 years, this is insulting that I need to go do a six hour... The only reason I did it at that time was my son was four and a half years old and I was teaching him, because you're going to go to kindergarten, I was starting do some math with him, and then in six months he knew all the math that I knew. He was solving quadratic equations and stuff. And we thought, oh, we have a genius in the house. We got to get him tested. So, we were testing him, and that's the only reason I took this test because I thought it would be interesting to understand what this process looks like. But then when I got the results, I was like, it was so spot on.

**中文翻译:**
但我当时差点没做。我想，我都做了 15 年产品了，让我去做 6 小时的测试简直是种侮辱。我当时做的唯一原因是，我儿子那时四岁半，我正在教他数学准备上幼儿园，结果六个月后他学会了我掌握的所有数学，甚至能解二次方程。我们觉得家里出了个天才，得带他去测试。所以我参加那个测试纯粹是因为我想了解这个过程是什么样的。但当我拿到结果时，我惊呆了，太准了。

---

### [00:38:26] Mayur Kamat

**English:**
It was incredibly spot on in saying areas where I would do well, areas where I would struggle and need help. So, that's one way to do it. It's super extreme. A little bit a year, two years ago, we had the [inaudible 00:38:40]. CZ is good friends with Ray Dalio. So, we had Ray Dalio come to our executive offsite, and he walked us through how he and his company does strengths assessment. So he has a, that one is lot more accessible. I think it costs like $50. You can go to, I think you search for Ray Dalio's strengths, there's a website that you can go and... The way it works, slightly differently for executives because you do it, so those are your components, tells you how good you think you are, and then it has your leadership team vote you on certain different aspects. So, there's a two layer assessment, how good you think you are and how good everybody else think you are.

**中文翻译:**
它极其准确地指出了我表现出色的领域，以及我会挣扎并需要帮助的领域。所以这是一种方法，虽然很极端。大约一两年前，CZ 和瑞·达利欧（Ray Dalio）是好朋友，所以我们请达利欧来参加我们的高管团建，他向我们展示了他和他的公司如何进行优势评估。那个方法更容易获得，大概只要 50 美元。你可以搜“Ray Dalio's strengths”，有个网站可以做。它的运作方式对高管来说略有不同：你先自评，看你觉得自己有多好；然后让你的领导团队在不同维度上对你进行投票。所以这是一个双层评估：你认为自己有多好，以及别人认为你有多好。

---

### [00:39:19] Mayur Kamat

**English:**
And then, the overlap is where your true strengths are. And as a CEO, I can say, "Oh, Mayur is great at design. Everybody else knows that Mayur is great at design. We should give design problems to Mayur." Right? So, that's another way of kind of... So, there's a scientific way of doing this and it's gotten a lot better since I read that book long time ago. Again, if you're truly, truly curious, it doesn't take that long and now it's a lot more accessible. That's one way to do it. And it kind of separates in terms of execution, in terms of structured thinking, innovation and design, creativity, stakeholder management, EQ. You get a little bit of a more scientific picture on what your strengths are. But this is also a simpler way.

**中文翻译:**
重合的部分就是你真正的优势所在。作为一个 CEO，我可以发现：“噢，Mayur 擅长设计，其他人也都认为 Mayur 擅长设计，那我们就把设计问题交给 Mayur。”对吧？所以这是另一种方式。现在这种科学的方法比我很久以前读那本书时要先进得多。如果你真的好奇，这并不会花太长时间，而且现在很容易接触到。这是一种方法，它会从执行力、结构化思维、创新与设计、创造力、利益相关者管理、情商等方面进行拆解。你会得到一个关于你优势的更科学的画像。但也有更简单的方法。

---

### [00:40:06] Mayur Kamat

**English:**
As a PM, you do pretty much a large portion. Everybody does the same few things, right? You think you're designing the roadmap, you are coming up with what you think is the product strategy. There's a lot of time around just managing engineers, making sure they do stuff. There's stakeholder management, marketing, compliance, whatever. There's launch and just tracking data analytics. So, this part is true for most PMs. Some jobs require more of one versus the other. And you just know when you do these things, which ones one you're truly great at and you have a lot of fun doing, right? Maybe you just don't like Jira and the ticket tracking and just following people on that, and that's the worst part of your job. Stay away from more structured complex stakeholder management jobs. Or you find that, hey, you do really well at that and somebody ask you, "Hey, what are the 15 things we're going to do next week to improve a conversion?"

**中文翻译:**
作为 PM，你做的工作大部分是重合的。每个人都在做那几件事，对吧？设计路线图（Roadmap），构思产品战略。花大量时间管理工程师，确保他们干活。还有利益相关者管理、市场营销、合规等等。还有发布和追踪数据分析。这对大多数 PM 来说都是一样的。有些工作侧重于某一方面。当你做这些事时，你自然会知道哪些是你真正擅长且乐在其中的。也许你就是讨厌 Jira、讨厌追踪工单、讨厌催人进度，那是你工作中表现最差的部分，那就远离那些需要高度结构化、复杂利益相关者管理的工作。或者你发现自己在那方面做得很好，但当有人问你“嘿，下周我们要做的能提高转化率的 15 件事是什么？”时，你感到很吃力。

---

### [00:41:06] Mayur Kamat

**English:**
That's where you kind of have a hard time, you just sit down, spend hours thinking about it, then maybe that's not your strength. And so over time, you kind of build this self calibration on areas that you have fun doing and areas where you don't have. And then, when you look at the next job, just try and gauge, are they hiring me because I did really well at some of the stuff that I didn't love doing? And if that's what they're hiring you for, probably you're not going to have a lot of fun or high acceleration if you go there.

**中文翻译:**
如果你坐在那里花好几个小时思考却毫无头绪，那也许就不是你的强项。随着时间的推移，你会建立起这种自我校准，知道哪些领域让你快乐，哪些不能。当你寻找下一份工作时，试着评估一下：他们雇佣我是因为我在某些我不喜欢的事情上表现出色吗？如果是这样，你去了之后可能不会开心，也不会有很高的加速度。

---

### [00:41:41] Lenny Rachitsky

**English:**
There's so much there. There's I think an important point that I'll add, and I'm curious if you agree. A lot of new people or new people in their career, like, "Oh, I just want to think about strategy. I'm going to think about the big picture. I don't want to just sit there and optimize the roadmap and be in Jira." But it's actually, that's your job when you're just starting out. You need to earn the right to contribute to the vision, to the strategy.

**中文翻译:**
这里面信息量很大。我想补充一个重要的点，我想看看你是否同意。很多职场新人会说：“噢，我只想思考战略，思考大局。我不想整天坐在那里优化路线图或盯着 Jira。”但事实上，当你刚起步时，那就是你的工作。你需要通过表现来赢得参与愿景和战略讨论的权利。

---

### [00:42:04] Mayur Kamat

**English:**
There's one of the, and as a pre-conversation we talk about contrary and view, product strategy by definition seems like a... This is going to be controversial. Not really... Those two words feel very at odds with each other for me. A product, you have hypotheses and if you can test it, you don't need a strategy. Right? If I say, "Hey, if I build this and I know this will add this much users and this time with this conversion rate, this customer acquisition cost and this LTV," that's your hypothesis and you could test it in the market very quickly. And if it works, you have your strategy. Keep doing more of it. Strategy is always keep doing more of it or don't do it, right? That's all that is to strategy. The key part is just figuring out which one goes in which bucket. And if you're really executing fast enough in a kind of structured, experimentation-driven manner, your strategy becomes a largely solved problem. So, for most, and that's a challenge.

**中文翻译:**
关于这一点，我们在开场前聊过一些反直觉的观点。从定义上讲，“产品战略”这两个词对我来说似乎有点……这可能会引起争议。这两个词对我来说非常矛盾。对于产品，你有假设，如果你能测试它，你就不需要战略。对吧？如果我说：“嘿，如果我构建这个功能，我知道它会增加这么多用户，转化率是多少，获客成本（CAC）是多少，终身价值（LTV）是多少，”这就是你的假设，你可以很快在市场上测试。如果奏效了，你就有了战略：继续加大投入。战略无非就是“继续做”或“停止做”，对吧？战略的全部意义就在于此。关键在于弄清楚哪件事该放进哪个桶里。如果你能以结构化、实验驱动的方式执行得足够快，你的战略在很大程度上就是一个已经解决的问题。所以，对大多数人来说，这是一个挑战。

---

### [00:43:14] Mayur Kamat

**English:**
A lot of people think strategy is about looking at Porter's five forces, a lot of slides, we're looking at some data and slicing it and saying, "We need to go here or there." All of it is largely in some sort of package intuition. And the challenge with that is, usually you go with the loudest voice in the room. And if you're a junior in your career, it's a very frustrating exercise because you think you know the strategy better. But it's all it is. It's a sense of package intuition, and then the guy with the loudest, biggest title or the loudest voice is going to go do it. It was very early in my career, Jonathan Rosenberg, he was the head of, he was the CPO at Google.

**中文翻译:**
很多人认为战略就是看波特五力模型，做一大堆幻灯片，切分数据然后说：“我们需要往这边走或往那边走。”这在很大程度上其实是某种“包装过的直觉”。这种做法的挑战在于，通常最后听谁的取决于谁在房间里嗓门最大。如果你处于职业生涯早期，这是一个非常令人沮丧的过程，因为你觉得自己更懂战略。但事实就是这样，它只是一种包装过的直觉，然后那个职级最高或嗓门最大的人会拍板。在我职业生涯早期，Jonathan Rosenberg 是谷歌的产品负责人（当时还不叫 CPO）。

---

### [00:43:59] Mayur Kamat

**English:**
All the PMs reported to him. He was not called the CPO back then. And he had this one thing he would say all the time that, "Come to me with data. If you come to me with ideas, we'll go with mine." Right? That was the saying. You can come with any ideas, we're just going to do what I think, but unless you come with strong sense of proof to override me. So again, strategy is a little bit overrated for product. For market expansions, for investments, for licenses, compliance, there's several areas where it makes sense and it's kind of useful. But for most product managers, your strategy should be, how fast can I go from hypothesis to data, right? The faster you can go there, the easier your strategy gets.

**中文翻译:**
当时所有的 PM 都向他汇报。他总是说一句话：“带着数据来见我。如果你只带着想法来，那我们就按我的想法办。”对吧？就是这句名言。你可以有任何想法，但除非你有强有力的证据来推翻我，否则我们就按我的来。所以再次强调，战略在产品领域有点被高估了。对于市场扩张、投资、牌照申请、合规等领域，战略是有意义且有用的。但对于大多数产品经理来说，你的战略应该是：我从假设到获取数据的速度能有多快？你跑得越快，你的战略就越简单。

---

### [00:44:48] Lenny Rachitsky

**English:**
That is certainly a hot take. So the idea here, I'm curious how you operationalize this with folks at N26. Is it just like, "I don't need to see a whole strategy for the year. Just give me, here's the plan, here's what we're going to test, here's our hypothesis?" Are you actually, what do you tell your PM team?

**中文翻译:**
这确实是个犀利的观点。我很好奇你在 N26 是如何具体执行这一点的。是像这样吗：“我不需要看全年的战略，只要给我计划，告诉我要测试什么，假设是什么？”你实际上是怎么跟你的 PM 团队说的？

---

### [00:45:05] Mayur Kamat

**English:**
We use this tool. I'm going to give a shout-out to Statsig because they're awesome. Vijay used to run the experimentation at Facebook and has this tool. There's several of those. But if you're running proper experiments, I just look at the Statsig dashboards, right? And I'm looking at experiments, I'm looking at what metrics they're moving, I'm looking at the P-value, I'm looking at how quickly can they get to statistical significance. And I'm like, "Oh, this is working. Let's do more of these." Right? So, now there's some areas where you can't do it, like in compliance, in legal aspects, in Europe, especially pricing. In US, you can run pricing tests. In Europe, it's a little bit different. So, those areas, you would need to have a lot more kind of deeper thinking, understanding of your cohorts. You're coming up with more structured reason for why you should do it, but you can't really test and know within a couple of days or a couple of weeks at max whether this was a good idea or not.

**中文翻译:**
我们使用一个工具，我要给 Statsig 点个赞，他们很棒。Vijay 以前在 Facebook 负责实验平台，现在做了这个工具。类似的工具还有很多。如果你在运行正规的实验，我只需要看 Statsig 的仪表盘。我看实验，看它们影响了哪些指标，看 P 值，看它们多快能达到统计学显著性。然后我会说：“噢，这个有效，多做点这个。”当然，有些领域你没法这么做，比如合规、法律方面，在欧洲尤其是定价。在美国你可以做定价测试，在欧洲则不同。所以那些领域你需要更深层的思考，理解你的客群（Cohorts），提出更结构化的理由说明为什么要这么做，因为你无法在几天或几周内通过测试知道这是否是个好主意。

---

### [00:46:10] Mayur Kamat

**English:**
Those, if there are either irreversible decisions or they're just extremely time-consuming to find out, then do some pre-work. We look at largely, find a lot of companies that really look at data without looking at cohorts that make completely bad decisions, right, because if you look at your dashboard as a mixture of users over 10 years, 20 years, even six months, and they all behave differently. If you look at a cohort level development of certain users, you generally end up making better decisions. But even over there, it's still lot more, there's a lot of noise between the moment you start tracking it than moment you start making decisions based on it. The world has changed in that meantime. By now, this was kind of a very foreign concept when I brought this in. I'm like, oh, the conversions down now, even though the product's done really well because Bitcoin has crashed, right?

**中文翻译:**
对于那些不可逆的决策，或者需要极长时间才能验证的决策，那就需要做一些前期工作。我们发现很多公司只看数据而不看客群，从而做出了完全错误的决策。因为如果你把 10 年、20 年甚至 6 个月前的用户混在一起看，他们的行为是完全不同的。如果你从客群维度观察特定用户的演变，你通常会做出更好的决策。但即便如此，从你开始追踪到你开始基于此做决策之间，仍然存在很多噪音。期间世界已经发生了变化。当我把这个概念引入币安时，它还很新鲜。我会说，噢，现在转化率下降了，尽管产品做得很好，但那是因为比特币崩盘了，对吧？

---

### [00:47:06] Mayur Kamat

**English:**
Nobody wants to go sign up for an Exchange account. So, if you just measure pre and post, you would think that you have done something wrong in the product. If you measure it as an experiment, you would know that, yeah, between the variant and control, it's still doing great, even though overall conversion is down. So largely, the more you kind of, one of the first thing kind of doing when I take on a role, the company already doesn't have an experimentation culture. That's largely why they hire me in the first place, right?

**中文翻译:**
没人想在那种时候注册交易所账号。所以，如果你只是对比“之前”和“之后”，你会以为产品出了问题。但如果你把它作为一个实验来衡量，你会发现，实验组和对照组之间，产品依然表现出色，尽管整体转化率下降了。所以，当我接手一个角色时，第一件事通常是看公司是否缺乏实验文化。这很大程度上也是他们雇佣我的原因，对吧？

---

### [00:47:35] Mayur Kamat

**English:**
So, for now, the first thing is to say, how can we bring it in? First, the kind of right culture, the right incentives and the right tools. And then, once it's set up, it gets a lot of fun. Get a lot of fun for the PMs because you have democratized performance for the product managers. And the second thing, which I tell my PMs now, which is truly kind of empowering if you think about it, the challenge with being a product manager is everybody thinks they can do their job, right? You go to... The CFO might have an idea, the head of kind of accounting has an idea. Anybody who uses the product thinks they have ideas, right?

**中文翻译:**
所以，目前第一件事是思考如何引入这种文化。首先是正确的文化、正确的激励机制和正确的工具。一旦建立起来，就会变得非常有趣。对 PM 来说尤其有趣，因为你让产品经理的绩效变得“民主化”了。第二件事，我经常告诉我的 PM 们，如果你仔细想想，这其实非常有力量：做产品经理的挑战在于每个人都觉得自己能干这活。CFO 可能有想法，会计主管可能有想法，任何用过产品的人都觉得自己有想法，对吧？

---

### [00:48:17] Mayur Kamat

**English:**
So, at some point in time, you're like, what is my discipline? What is my science? Nobody goes to the accounting guy and says, "Hey, I have a great idea for how to cook our books." Nobody does that because there's a science behind it. There's a science for financial forecasting. Even in technology, a lot of the times people just don't go and say, "Hey, just dump this thing and let's use this code that the AI code generator has used." Right? There's a little bit of science there.

**中文翻译:**
所以，有时候你会想：我的专业性在哪里？我的科学依据是什么？没人会跑去跟会计说：“嘿，我有个做假账的好主意。”没人会这么做，因为那背后有专业科学。财务预测有科学依据。即使在技术领域，人们通常也不会跑去说：“嘿，把这代码删了，用 AI 生成的代码吧。”那里也有一点科学。

---

### [00:48:43] Mayur Kamat

**English:**
Whereas in product, you largely find that it's a combination of data and ideas and stuff, and anybody thinks they can... The moment you build experimentation, you'll now make it scientific, right? Now, somebody comes up with an idea, say, that's a bad idea. Here, this is why it's a bad idea, because we have done this experiment six times and it has failed across this user groups at this exact level of impact created. So, it kind of gives the PMs the kind of, hey, I'm not just a general purpose technician, I'm a specialist now. And it's extremely empowering once we can, it takes a long time to move the team in that direction. But once you get it there, the PMs just, it's a natural kind of dopamine hit every time you run an experiment and see more metrics.

**中文翻译:**
而在产品领域，你会发现它很大程度上是数据、想法和各种东西的结合，每个人都觉得自己行。但当你建立起实验机制，你就让它变得科学了。现在，如果有人提出一个想法，你可以说：“那是个坏主意。这就是为什么它是坏主意，因为我们已经做过六次实验了，在这些用户群中都失败了，产生的影响就是这么多。”这给了 PM 一种底气：嘿，我不再只是一个通用的技术员，我现在是一个专家。一旦我们能做到这一点（虽然把团队带向那个方向需要很长时间），PM 们就会感到非常有力量。每当你运行一个实验并看到更多指标时，那都是一种天然的多巴胺冲击。

---

### [00:49:33] Lenny Rachitsky

**English:**
I'm a huge fan of experimentation. I think most guests on this podcast are on your side of the debate. I feel like we could do a whole podcast episode on just how to create a culture of experimentation, how to change culture. This episode is brought to you by Vanta, and I am very excited to have Christina Cacioppo, CEO and co founder of Vanta joining me for this very short conversation.

**中文翻译:**
我是实验机制的坚定拥护者。我想这个播客的大多数嘉宾都站在你这一边。我觉得我们可以专门做一集播客，讨论如何建立实验文化，如何改变文化。本集节目由 Vanta 赞助，我非常高兴邀请到 Vanta 的创始人兼 CEO Christina Cacioppo 加入这段简短的对话。

---

### [00:49:55] Christina Cacioppo

**English:**
Great to be here. Big fan of the podcast and the newsletter.

**中文翻译:**
很高兴来到这里。我是播客和时事通讯的忠实粉丝。

---

### [00:49:57] Lenny Rachitsky

**English:**
Vanta is a longtime sponsor of the show, but for some of our newer listeners, what does Vanta do and who is it for?

**中文翻译:**
Vanta 是节目的长期赞助商，但对于一些新听众来说，Vanta 是做什么的，它是为谁服务的？

---

### [00:50:05] Christina Cacioppo

**English:**
Sure. So we started Vanta in 2018, focused on founders, helping them start to build out their security programs and get credit for all of that hard security work with compliance certifications like SOC 2 or ISO 27001. Today, we currently help over 9,000 companies, including some startup household names like Atlassian, Ramp, and LangChain start and scale their security programs and ultimately build trust by automating compliance, centralizing GRC, and accelerating security reviews.

**中文翻译:**
好的。我们在 2018 年创立了 Vanta，专注于创始人，帮助他们开始建立安全计划，并通过 SOC 2 或 ISO 27001 等合规认证，让他们辛勤的安全工作得到认可。如今，我们帮助超过 9000 家公司，包括 Atlassian、Ramp 和 LangChain 等知名初创公司，启动并扩展其安全计划，最终通过自动化合规、集中化 GRC（治理、风险与合规）和加速安全审查来建立信任。

---

### [00:50:35] Lenny Rachitsky

**English:**
That is awesome. I know from experience that these things take a lot of time and a lot of resources and nobody wants to spend time doing this.

**中文翻译:**
太棒了。我从经验中知道，这些事情需要花费大量的时间和资源，而且没人想把时间花在这上面。

---

### [00:50:43] Christina Cacioppo

**English:**
That is very much our experience, but before the company. And to some extent during it, but the idea is with automation with AI, with software, we are helping customers build trust with prospects and customers in an efficient way. And our joke, we started this compliance company, so you don't have to.

**中文翻译:**
这正是我们的体会，尤其是在公司成立之前。在某种程度上，成立之后也是如此。但我们的理念是利用自动化、AI 和软件，帮助客户以高效的方式与潜在客户和现有客户建立信任。我们常开玩笑说：我们创办了这家合规公司，这样你就不用自己去搞合规了。

---

### [00:50:59] Lenny Rachitsky

**English:**
We appreciate you for doing that and you have a special discount for listeners, they can get a thousand dollars off Vanta at vanta.com/lenny. That's V-A-N-T-A .com/lenny for $1,000 off Vanta. Thanks for that, Christina.

**中文翻译:**
感谢你们所做的一切。你们为听众提供了特别优惠，在 vanta.com/lenny 可以获得 1000 美元的折扣。谢谢你，Christina。

---

### [00:51:13] Christina Cacioppo

**English:**
Thank you.

**中文翻译:**
谢谢。

---

### [00:51:14] Lenny Rachitsky

**English:**
I want to come back to the question of what N26 has done well to create and hire great PMs. So you've spent a bunch of time on here's career advice that I often give and what has helps people most in their career. Just to kind of close this thread, is there anything N26 did or is doing that either from the hiring perspective or from training? I know you haven't been there from the beginning, just like as a business, as a company that they've done really well that other companies may want to copy.

**中文翻译:**
我想回到 N26 在培养和招聘优秀 PM 方面做得好的地方。你刚才花了很多时间分享你常给出的职业建议。为了结束这个话题，N26 在招聘或培训方面有没有什么特别的做法？我知道你不是从一开始就在那里的，但作为一个企业，他们有哪些做得非常出色、值得其他公司效仿的地方？

---

### [00:51:44] Mayur Kamat

**English:**
Some of it is just the hiring philosophy. One of the advantages you get for being a big fish in a small pond is you get to have your pick of the cream of the crop. So in Europe here where we don't have the same level of unicorn or decacorn density you have in the Bay Area being one of the first ones or the few ones, you do get a little bit of that branding working in your favor. So some portion of that is just the input. If you're taking really smart people, very chance at N26 they will stay smart. Two is again, the level of problems that they work on are harder. Just the print tech angle we mentioned and now with this whole experimentation driven kind of change that we made in the last year or so, there's also a new kind of tool kit that they get, especially if they're going for larger big growth company as the next step of the career.

**中文翻译:**
其中一部分仅仅是招聘哲学。作为“小池塘里的大鱼”，优势之一是你可以挑选最顶尖的人才。在欧洲，我们没有湾区那种密度的独角兽或超级独角兽公司，作为最早或为数不多的几家之一，品牌效应确实对我们有利。所以一部分原因是“输入”：如果你招募的是极其聪明的人，他们在 N26 保持聪明的概率很大。第二，他们处理的问题难度更高。除了我们提到的金融科技角度，加上我们去年进行的实验驱动型变革，他们获得了一套全新的工具包，尤其是当他们职业生涯的下一步是去更大的高速增长公司时。

---

### [00:52:48] Mayur Kamat

**English:**
All the people companies I talk to, the amount of companies that are truly world-class at experimentation is so low that if you work in one of these companies and you build this tool set, you can build a whole career on this. You can go to any other company and say, "This is what I'm going to bring to the table." Because there's no growth without, as I said, without compounding wins faster. Nothing compounds wins faster than experiments and there's no company out in the world that says we don't want to grow. So that is an incredible kind of brand that you can build alongside with it. Then the third piece is just the scale. One of the other interesting aspects of banking is what I call a hundred percent product. It's actually more than a hundred percent, they're more bank accounts than human beings because a lot of people have more than one bank account.

**中文翻译:**
在我接触过的所有公司中，真正拥有世界级实验能力的公司寥寥无几。如果你在这样的公司工作并建立了这套技能，你完全可以以此为基础建立整个职业生涯。你可以去任何其他公司说：“这就是我能带来的价值。”因为正如我所说，没有快速复利的胜利就没有增长，而没有什么比实验更能让胜利产生复利。世界上没有哪家公司会说自己不想增长。所以这是一种你可以随之建立的强大个人品牌。第三点是规模。银行的一个有趣之处在于我称之为“100% 产品”。实际上超过了 100%，因为银行账户的数量比人还多，很多人拥有不止一个账户。

---

### [00:53:38] Mayur Kamat

**English:**
So you never run out of target addressable market. It's as big as it can get, which means that there's no upper bound on how much... Because at some point if you're, I don't know, building in kind of an AI code generator, your market is capped that maybe developers or people want to be developers. Or you're building, I don't know, AWS, it's a massive market, but it's still like all the company that need online hosting. They look at banking everybody needs and the fact that it's oldest or the second oldest, depending on how risky you are or not... Or profession known to man. It is a self-hedged product. When things get tough on one side of our business, the interest rates, let's say, go high, spending goes down, but we make money on deposits. When interest rates go down, spending increases, so we make more your money on interchange, investments.

**中文翻译:**
所以你永远不会耗尽目标市场（TAM）。它大到极致，这意味着增长没有上限。因为在某些时候，如果你在做一个 AI 代码生成器，你的市场受限于开发者或想成为开发者的人。或者你在做 AWS，市场很大，但仍局限于需要在线托管的公司。而银行是每个人都需要的，它是人类最古老（或第二古老，取决于你如何定义风险）的职业。它是一个“自我对冲”的产品。当业务的一端遇到困难，比如利率上升，消费下降，但我们可以通过存款赚取利息。当利率下降，消费增加，我们就可以通过刷卡手续费（Interchange）和投资赚更多钱。

---

### [00:54:45] Mayur Kamat

**English:**
And that understanding that how do you build naturally hedged products is probably another kind of reason why... It just influences how you make decisions and how do you kind of scale your core product portfolio. Just one example, for about a year and a half ago, we were largely year bank with a card and we were the first mobile bank and that was a big enough market. But in the last year or so, we have just fleshed out that product portfolio. We have a big lending portfolio now. We launched savings last year. We invested heavily in savings because the interest rates were high, was a super amazing tool to attract new users by offering high interest rates.

**中文翻译:**
理解如何构建天然对冲的产品，可能是另一个原因……它影响了你如何做决策以及如何扩展核心产品组合。举个例子，大约一年半前，我们主要是一家提供银行卡服务的移动银行，那已经是一个足够大的市场了。但在过去一年左右，我们充实了产品组合。我们现在有庞大的贷款业务。去年我们推出了储蓄业务，并在储蓄上投入巨资，因为当时利率很高，通过提供高利率来吸引新用户是一个超级有效的工具。

---

### [00:55:28] Mayur Kamat

**English:**
But as the interest rates are going down now, which is investing heavily in lending because now you can get loans for lower prices, which was super hard to get last year. So being able to build products that complement the macro also gives you that kind of additional balancing act that you don't get in typical single focus companies. So I think it's a combination of few of those things, being able to get great talent, being able to train them now more so especially around experimentation and just see how we can build a product portfolio that complements each other but also naturally hedges against each other, just gives you a better, well-balanced way to operate.

**中文翻译:**
但随着现在利率下降，我们开始重金投入贷款业务，因为现在人们可以以更低的价格获得贷款，而这在去年是非常困难的。所以，能够构建与宏观环境互补的产品，给了你一种在典型的单一焦点公司中得不到的平衡能力。我认为这是几方面的结合：能够获得优秀人才，能够培训他们（尤其是围绕实验机制），以及构建一个既互补又天然对冲的产品组合，这让你拥有更稳健的运营方式。

---

### [00:56:13] Lenny Rachitsky

**English:**
I think this explains something really interesting. As you were talking, I realized that a lot of these companies that produce the best PMs are to your point, non-US based, but incredibly successful in their location. And so it draws in the most talented people in that region. So I know Intercom I think technically is... So Intercom was number one on this list of companies that produce the best PMs. Intercom, Palantir, Revolut, and then N26, Chime, Stripe, Dropbox were kind of at the top. And four of those essentially, or three of those are non... Intercom I think was Ireland for a lot of their team is based in Ireland. Then Revolut is the UK and then you guys. So it's interesting, that explains some really interesting insights of just be the best, be the big fish in a small pond, draw in the best talent and then work on really hard problems and be really successful. There you go. There's a formula.

**中文翻译:**
我觉得这解释了一些非常有趣的事情。当你说话时，我意识到很多培养出最优秀 PM 的公司，正如你所说，并非总部设在美国，但在其所在地却极其成功。因此，它吸引了该地区最优秀的人才。我知道 Intercom 排名第一，然后是 Palantir、Revolut，接着是 N26、Chime、Stripe、Dropbox。其中有三四家是非美国的……Intercom 的很多团队在爱尔兰，Revolut 在英国，然后是你们。这解释了一些有趣的见解：成为最好的，做小池塘里的大鱼，吸引最顶尖的人才，解决极其困难的问题，并取得巨大的成功。瞧，这就是公式。

---

### [00:57:03] Mayur Kamat

**English:**
Yes, yes. It's very simple when you put it that way.

**中文翻译:**
是的，是的。你这么一说，听起来确实很简单。

---

### [00:57:08] Lenny Rachitsky

**English:**
Oh, man. Okay. You interestingly have worked in a lot of different places. I want to spend a little time here. So you've worked in Europe, you've worked in Asia, you worked in the US obviously. For someone that is maybe thinking about moving out of the US or maybe moving to the US, what have you found are the big trade-offs?

**中文翻译:**
天哪。好吧。有趣的是，你在很多不同的地方工作过。我想在这里多花点时间。你在欧洲、亚洲工作过，显然也在美国工作过。对于那些可能正在考虑搬出美国或搬进美国的人，你发现主要的权衡是什么？

---

### [00:57:26] Mayur Kamat

**English:**
Yeah, so I would say early career you want to be in intensely talents dense areas for all the reasons that we mentioned before. Finding the high growth companies, finding the networks that will make you successful. For general tech, there's no better place than West coast of the US. Everybody doesn't have the option, especially now with the immigration policies and so forth. I mean things were always hard. They seem extremely harder now. So you may not have that option, but if you do have that option, I would encourage everyone, there's no better place than West Coast to start your career. There's some exceptions, like for crypto, I would say Dubai is very strong, very great, has a really high density there. But again, it's a very industry specific. Bangalore, if you're Indian, has managed to recreate some of the magic of Silicon Valley, not at the same scale, but getting better. If you're in finance, maybe there is London, Singapore, and Asia has now at least not as much new innovation, but each of the big companies has a presence there.

**中文翻译:**
是的，我会说在职业生涯早期，出于我们之前提到的所有原因，你希望待在人才极度密集的地区。寻找高速增长的公司，寻找能让你成功的人脉网络。对于通用技术领域，没有比美国西海岸更好的地方了。并不是每个人都有这个选择，尤其是现在的移民政策等等。我的意思是，事情一直很难，现在似乎更难了。所以你可能没有那个选择，但如果你有，我鼓励每个人：西海岸是开启职业生涯的最佳地点。也有一些例外，比如加密货币领域，我会说迪拜非常强大，人才密度很高。但那是非常特定于行业的。班加罗尔（如果你是印度人）已经成功地重现了硅谷的一些魔力，虽然规模不同，但正在变好。如果你在金融领域，也许是伦敦、新加坡。亚洲现在的原始创新可能没那么多，但每家大公司在那里都有分支机构。

---

### [00:58:40] Mayur Kamat

**English:**
So at least secondary talent densities there, those would be our options if US is not available early in your career. And in some ways it helps define you, right? If you work at Microsoft or Google or OpenAI or some of these companies that become brands later, it's something you can take with you when going... The second part of your question is if you decide to move, having that experience and that brand and that kind of achievements there can help you find great opportunities elsewhere. I mean, I've been a little bit privileged that some of these opportunities I found me like N26 here in Europe or Binance before in Asia where I wasn't really in that super talent dense area in the first place. But luck's not a great strategy. So if you're planning for it, I would say build your early career in the US. Honestly, when we moved to Thailand 2018, at that point, I didn't think I was making a great professional decision.

**中文翻译:**
所以，如果职业生涯早期无法去美国，这些次级人才密集区就是选择。在某种程度上，这有助于定义你。如果你在微软、谷歌、OpenAI 或这些后来成为大品牌的公司工作，这是你可以带走的东西。你问题的第二部分是，如果你决定搬家，拥有那样的经验、品牌和成就，可以帮助你在其他地方找到极好的机会。我一直有点特权，有些机会主动找到了我，比如欧洲的 N26 或之前的亚洲币安，而我最初并不在那些超级人才密集的地区。但运气不是一个好的战略。所以如果你在规划，我会说在美国开启早期职业生涯。坦白说，当我们 2018 年搬到泰国时，我当时并不觉得自己在做一个伟大的职业决策。

---

### [00:59:51] Mayur Kamat

**English:**
We were just struggling in the US with both me and my wife working. Both our kids in Seattle were tiny. My daughter had asthma at that time and she was just constantly sick. And it was a struggle for us to kind of manage both work and life. And when I talked to Agoda, I had never heard of the company and the only reason I ended up taking the job was like, hey, Bangkok's a hot place. My daughter might not have asthma there and we might have some help in the house. So we could probably balance some of the things that are really not adding value to our life right now. And that was the hypothesis there that I can do a lot more on work because I was literally not able to focus as much on it, everything else that was happening. And as I said, everything on an experimentation that we just hit a home run on all the hypothesis. My daughter, the heat cured her asthma.

**中文翻译:**
当时我和妻子都在美国工作，非常辛苦。我们在西雅图的两个孩子还很小。我女儿当时有哮喘，经常生病。对我们来说，平衡工作和生活非常困难。当我与 Agoda 谈时，我从未听说过这家公司，我最终接受这份工作的唯一原因是：嘿，曼谷是个暖和的地方，我女儿在那儿可能就不会哮喘了，而且我们家里可能会有帮手。这样我们也许能平衡一些目前并没有为生活增加价值的事情。当时的假设是，我可以把更多精力投入到工作中，因为之前我真的无法集中精力。正如我所说，一切都是实验，而我们在所有假设上都打出了全垒打。我女儿那边的热天气治好了她的哮喘。

---

### [01:00:52] Mayur Kamat

**English:**
Just having a support structure allowed us just as a family to spend a lot more time with each other and allowed me a lot more time to work and be on my career when I'm not doing dishes and not doing laundry and not throwing out the trash and not mowing the lawn. There's just so much hours that show up in the day that you could be doing things that you're great at and add to your career. And then Agoda just turned out to be almost like a bootcamp for understanding how an experimentation based product culture might work. Because before that I worked at Google, I worked at startups. My claim to fame was building big stuff and Agoda just taught me a lot of the growth comes with incredibly small things done faster. So it's part of Booking Holdings. So if you heard of Booking.com, it's a $170 billion company. And what's interesting is that 10 years ago it was a $10 billion company which sold flights, hotels, and cars. 10 years later it still sells flights, hotels, and cars, it's a $ 170 billion company.

**中文翻译:**
拥有支持系统让我们全家能有更多时间在一起，也让我有更多时间投入工作和事业，因为我不用洗碗、不用洗衣服、不用倒垃圾、不用修剪草坪。一天中突然多出了这么多小时，你可以用来做你擅长且对事业有益的事。Agoda 后来证明几乎就像是一个理解“实验驱动型产品文化”的训练营。因为在那之前我在谷歌工作，在初创公司工作，我出名是因为构建了庞大的系统，而 Agoda 教会了我：很多增长来自于以更快的速度完成极其微小的事情。它是 Booking Holdings 的一部分。如果你听说过 Booking.com，那是一家市值 1700 亿美元的公司。有趣的是，10 年前它是一家市值 100 亿美元的公司，卖机票、酒店和租车；10 年后它依然卖机票、酒店和租车，但市值变成了 1700 亿美元。

---

### [01:02:01] Lenny Rachitsky

**English:**
Oh, wow.

**中文翻译:**
噢，哇。

---

### [01:02:02] Mayur Kamat

**English:**
It's an incredible growth story. And that tells you you really don't need from a strategy perspective to do something completely different if you can truly compound your growth by optimizing every single thing really, really well. So there are the pros that come with, as I said, when you move, most of the time you're building products that are global, especially if you're based in the US. Very few times you're building product that just work in the US. Now, that's not true for a lot of the countries. Like in India, a lot of products are only designed for Indian market, a lot of products in China only designed for Chinese market, but from the US you're designing product for the world and a lot of the times you don't experience the same constraints or you don't empathize with the user at the same level because you just haven't lived that user's life.

**中文翻译:**
这是一个令人难以置信的增长故事。它告诉你，从战略角度来看，如果你能通过把每一件小事都优化得非常好来真正实现增长复利，你并不需要去做完全不同的事情。所以，搬家也有好处。正如我所说，当你搬家时，大多数时候你是在构建全球化的产品，尤其是如果你以前在美国。很少有产品只在美国运行。当然，这对很多国家来说并非如此，比如在印度，很多产品只为印度市场设计；在中国，很多产品只为中国市场设计。但在美国，你是为世界设计产品，而很多时候你并没有经历过同样的限制，或者你无法在同一水平上与用户共情，因为你没有过过那种用户的生活。

---

### [01:02:57] Mayur Kamat

**English:**
So in terms of just being able to calibrate yourself on what a global product might look like, being able to live in different places and understanding some of these constraints first hand, definitely a pro. As I said, especially if you have built that early reputation, you get to work at some of the best companies when you go abroad. And so there's a hit to compensation, at least initially for sure. Nobody pays anywhere close, especially here in Europe. But as I said before, don't optimize for compensation early in your career or even middle part of your career. So if you follow that advice, it'll not matter because you will have kind of something unique to offer. Even if you come back to the US later having worked in different... Having understanding, especially if you're in FinTech where the actual laws are different in different countries and that one you truly do not appreciate working in the US. Even at Google and stuff, when we would launch products, I would be like, oh, the lawyers, they're just making life difficult.

**中文翻译:**
所以，就能够校准自己对全球化产品的认知、能够住在不同的地方并亲身体验这些限制而言，这绝对是一个优势。正如我所说，特别是如果你已经建立了早期的声誉，当你出国时，你可以去一些最好的公司工作。当然，薪酬肯定会受到打击，至少最初是这样。没人能给到接近美国的薪水，尤其是在欧洲。但正如我之前所说，不要在职业生涯早期甚至中期为了薪酬而优化。如果你遵循这个建议，那就没关系，因为你会拥有一些独特的东西。即使你以后回到美国，拥有在不同地方工作的经历，拥有对不同国家法律差异的理解（尤其是在金融科技领域），这是你在美国工作时无法真正体会的。即使在谷歌，当我们发布产品时，我也会觉得：噢，律师们又在找麻烦了。

---

### [01:04:07] Mayur Kamat

**English:**
But the many of now have a true appreciation of how different the world truly is. It just makes you a better stakeholder when you talk to the legal team, when you talk to compliance team, when you talk to marketing. So I think those are all the pros. The compensation could be the con. The other big con is that today, if you're in Silicon Valley, I spent 15 years in Seattle, I worked at four companies, I could change jobs and stay in Seattle because there's enough companies there. You're not going to run a ceiling at some point, in Bay Area, there's no ceiling, right? You can keep growing. The challenge now is that if I'm in Bangkok and I'm working at Agoda, at some point I need to find a new job or because let's say I'm at the CPO level, I want to be CEO now. Agoda already has a CEO, so I need to find, be a CEO somewhere else. Guess what? That company is not going to be in Bangkok. Now I have to move and move my whole family to Singapore, which I did. Then you hit somewhere over there or then you hit another ceiling, now you need to move back or go somewhere else with Thailand, which I did. And then you're like, oh, maybe there's a great opportunity in Europe which would give you a whole different scale. Then you need to move to Spain, which I did. So at some point your family's like, what's happening? It turned out to be what turned out to be one step to go from A to B is now just a every year journey.

**中文翻译:**
但现在很多人真正体会到了世界是多么的不同。当你与法律团队、合规团队或营销团队交谈时，这会让你成为一个更好的利益相关者。所以我觉得这些都是优点。薪酬可能是缺点。另一个大缺点是，如果你在硅谷（我在西雅图待了 15 年，在四家公司工作过），我可以换工作但留在西雅图，因为那里有足够多的公司。你不会碰到天花板，在湾区没有天花板，对吧？你可以一直成长。现在的挑战是，如果我在曼谷，在 Agoda 工作，到某个阶段我需要找新工作，或者因为我是 CPO 级别，现在想当 CEO。Agoda 已经有 CEO 了，所以我得去别处当 CEO。猜猜看？那家公司不会在曼谷。现在我必须搬家，带着全家搬到新加坡，我确实这么做了。然后你在那里又碰到了天花板，现在你需要搬回来或者去泰国的其他地方，我也这么做了。然后你会想，噢，也许欧洲有个好机会，能给你完全不同的规模。然后你需要搬到西班牙，我也这么做了。所以到某个阶段，你的家人会问：到底发生了什么？原本从 A 到 B 的一步，现在变成了一年一度的旅程。

---

### [01:05:34] Mayur Kamat

**English:**
So that's something to calibrate, especially later in your career that it's extremely hard if you like the job and don't like the location or vice versa, 'cause they usually come as a package deal now. We see this in Bangkok now where there's not that many great tech companies, and if you're at Agoda and you're doing really well, but it's just one company, you just don't have options. And especially if you love Bangkok, which is a great city, probably my vote for the best place to live in the world, that's a struggle. You love the city, but if you need to move your career ahead, you need to go somewhere else.

**中文翻译:**
所以这是需要校准的，尤其是职业生涯后期。如果你喜欢工作但不喜欢地点，或者反之，这会非常困难，因为现在它们通常是捆绑在一起的。我们在曼谷就看到了这种情况，那里没有那么多伟大的科技公司。如果你在 Agoda 做得很好，但那只有一家公司，你没有其他选择。特别是如果你热爱曼谷（那是个伟大的城市，可能是我心目中世界上最适合居住的地方），这会是一种挣扎。你爱这个城市，但如果你想让事业更进一步，你就得去别的地方。

---

### [01:06:16] Lenny Rachitsky

**English:**
So interesting. I feel like Thailand is very popular right now with White Lotus. I think White Lotus had the most views of any show or some crazy... It was very popular. I feel like there's a lot of tourism coming to Thailand more than they've had.

**中文翻译:**
很有趣。我觉得泰国现在因为《白莲花度假村》（White Lotus）变得非常火。我想《白莲花》的收视率是所有剧集里最高的，或者非常惊人……它非常受欢迎。我觉得去泰国的游客比以前多得多。

---

### [01:06:31] Mayur Kamat

**English:**
Yes, yes.

**中文翻译:**
是的，是的。

---

### [01:06:32] Lenny Rachitsky

**English:**
Yeah. I want to come back to one piece of advice that we were chatting about before we started recording that I think might be helpful to people, which is, and this is kind in a different direction, but I want to make sure we touch on it, is Shreyas Doshi's point about leverage. I know this is something that you think a lot about. He has this really good advice and we'll point to the episode if people want to dig deeper around finding the highest leverage opportunities for you to work on as a PM. Can you just share that advice for folks that haven't heard this before?

**中文翻译:**
是的。我想回到我们录音前聊过的一个建议，我觉得这对人们很有帮助。虽然方向有点不同，但我一定要提到它，那就是 Shreyas Doshi 关于“杠杆率”（Leverage）的观点。我知道这是你经常思考的问题。他有非常好的建议，如果人们想深入了解如何作为 PM 找到最高杠杆的机会，我们会提供那一集的链接。你能为还没听过的人分享一下那个建议吗？

---

### [01:07:00] Mayur Kamat

**English:**
This is true for no matter what level of career you are in, but you have a finite amount of time and largely you have more problems than you have time to solve them. The question is which ones you work on. And this becomes even harder, let's say you're a CPO now because all of them are important, otherwise they will not come to you in the first place. The question is, which one do you work on? And the principle is simple. You work on problems that have a 10X positive or a negative impact. I mean the number can be 10, 5, 300, depending on finance it would be a hundred, some companies might be three. And in most FinTech companies one of two problems, it's a growth problem or a compliance problem because both of them can have a negative or positive 10X impact and that's what you focus on. That's what you spend bulk of your time. What was interesting for me, my first executive roles, that was Google, I was a product manager.

**中文翻译:**
无论你处于职业生涯的哪个阶段，这都是成立的：你的时间是有限的，而问题总是比解决问题的时间多。问题在于你处理哪一个。当你成为 CPO 时，这变得更难，因为所有问题看起来都很重要，否则它们最初就不会被送到你面前。问题是，你处理哪一个？原则很简单：处理那些具有 10 倍正面或负面影响的问题。这个数字可以是 10、5、300，在金融领域可能是 100，有些公司可能是 3。在大多数金融科技公司，问题通常是增长问题或合规问题，因为这两者都能产生 10 倍的正向或负向影响。这就是你应该关注的，是你应该投入大部分时间的地方。对我来说有趣的是，我的第一个高管角色是在 Google 之后，当时我还是个产品经理。

---

### [01:08:01] Mayur Kamat

**English:**
I joined what was White Pages back then as a VP of product. I was my first kind of... And White Pages, Alex Allgood, Seattle, founding legend, three companies, all unicorns now. Incredible, very good personal friend and mentor. What was truly interesting when I joined it, they're like, "Okay, this is your desk, this is the product area. So we had two offices, this is when everybody worked in office five days a week." And I'm like, "Okay, where does Alex sit?" And he's like, "Oh, he's sitting with accounting." And I'm like, I didn't think about it because I thought his office is near accounting. Then I find out he doesn't have office, he has a floating desk. So all the other desks were fixed, but he had a movable desk and he would move his desk to one of the departments, which I think had the highest leverage opportunity. And he would sit there at that desk when that department till that either problem was solved or the opportunity was realized, and then he would literally move his desk and then go to product or tech or finance.

**中文翻译:**
我加入了当时的 White Pages 担任产品副总裁。那是我的第一个……White Pages 的 Alex Allgood 是西雅图的创业传奇，创办了三家公司，现在全是独角兽。他是我非常好的私人朋友和导师。我加入时最有趣的是，他们说：“好的，这是你的办公桌，这是产品区。”当时大家还是一周五天在办公室工作。我问：“好的，Alex 坐在哪儿？”他们说：“噢，他坐在会计部。”我当时没多想，以为他的办公室在会计部附近。后来我发现他根本没有办公室，他有一个“流动办公桌”。其他人的桌子都是固定的，但他有一个可移动的桌子，他会把桌子搬到他认为具有最高杠杆机会的部门。他会一直坐在那个部门，直到问题解决或机会实现，然后他会真的搬起桌子，去产品部、技术部或财务部。

---

### [01:09:08] Mayur Kamat

**English:**
And that was his way of... You could literally visualize him working on the highest leverage problem by his desk moving. And then that combines that with what we talked before about details and a little bit, I think I didn't mention it about the humility that you need to have to be working in the detail. A lot of the times, especially later in your career, you're like, hey, this is beyond me. This is below me. Why do I need to do that? I have so many PMs or data analysts or somebody should do it. Why would I do it? And that was kind of again, just a quick story there. I remember we were trying to figure out our growth channels and we found out that, hey, we are kind of really tapping out on paid, on social, on referrals, but SEO was something we just hadn't worked on for a while. We're building a caller ID app and what we wanted to do was when somebody types a phone number in Google, we want to be the first link to say, hey, is this a spam call or not?

**中文翻译:**
那是他的方式……你可以通过他桌子的移动，直观地看到他正在处理最高杠杆的问题。这结合了我们之前谈到的细节，还有一点我没提到的，就是深入细节所需的谦逊。很多时候，尤其是职业生涯后期，你会觉得：“嘿，这超出了我的职责，这太琐碎了。我为什么要干这个？我有那么多 PM、数据分析师，应该由别人来做。”这里又有一个小故事。我记得当时我们在寻找增长渠道，发现付费广告、社交媒体和推荐都已经遇到瓶颈了，但 SEO 是我们很久没碰的领域。我们当时在做一个来电显示应用，我们想做的是：当有人在谷歌搜索一个电话号码时，我们希望排在第一条，告诉他这是不是骚扰电话。

---

### [01:10:10] Mayur Kamat

**English:**
Or whose number it is. And if we could then we could get them to download our app. That was the hypothesis. So I present at the executive team meeting to Alex, like, "Hey, I have a team. I want to hire a product manager focused purely on SEO and because I think that's one of our highest leverage areas right now." And Alex is like, "Hey, the whole White Pages, I built based on SEO. People who type people's name and the first thing used to be a White Pages link. I'm one of the best people in the world to work on SEO." I'm like, "Yeah. So?" He's like, "Let me run this product." I'm like, "Okay, what do you mean?" He's like, "No, no, I will be the product manager for this for however long you need it." I'm like, "How's [inaudible 01:10:54]?"

**中文翻译:**
或者那是谁的号码。如果我们能做到这一点，我们就能让他们下载我们的应用。这就是假设。于是在高管会议上，我对 Alex 说：“嘿，我有个团队，我想招一个专门负责 SEO 的产品经理，因为我觉得那是我们目前杠杆率最高的领域之一。”Alex 说：“嘿，整个 White Pages 都是我靠 SEO 做起来的。以前人们搜人名，第一条就是 White Pages 的链接。我是世界上最擅长 SEO 的人之一。”我说：“是的，所以呢？”他说：“让我来负责这个产品。”我说：“好的，你什么意思？”他说：“不不，我会担任这个项目的产品经理，直到你需要为止。”我说：“那[公司事务]怎么办？”

---

### [01:10:54] Mayur Kamat

**English:**
"They don't worry about it. Just tell me about the engineers." So again, he moved his desk to where that product team sat, and for the next three months he was the product manager on that scrum. So he would come to my product team meetings, give us update on what's happening with the SEO scrum, and then an hour later I would be in the leadership meeting giving my update to him, and truly he was operating it saying, this is high leverage area for the company, high leverage for my yards. It should be high leverage for me. I'm the best person to do it. I'm going to be in the details and do it. CZ, same at Binance, there were a lot of products that he would just sit on himself. There were very few people at Binance who would say no to CZ, but one of my lead PMs who worked on the products that CZ worked on, he would tell them no all the time.

**中文翻译:**
“别担心那个，告诉我工程师在哪儿就行。”于是，他又搬起桌子坐到了那个产品团队旁边。在接下来的三个月里，他就是那个敏捷小组（Scrum）的产品经理。他会来参加我的产品团队会议，向我们汇报 SEO 小组的进展；一小时后，我会在领导层会议上向他汇报我的工作。他真实地在践行：这是公司的高杠杆领域，也是 Mayur 的高杠杆领域，那它也应该是我的高杠杆领域。我是最适合做这件事的人，我会深入细节去完成它。CZ 在币安也是一样，有很多产品他会亲自盯着。在币安很少有人敢对 CZ 说“不”，但我手下的一个首席 PM 负责 CZ 亲自参与的产品，他经常对 CZ 说“不”。

---

### [01:11:41] Mayur Kamat

**English:**
They would just baffle all the other executives, how is he saying no to CZ and none of us are doing it? Hey, that was his product area that CZ was working on, and there was that mutual respect there that, hey, we know this thing and he is going to say no to me because probably not a good idea. So that humility and attention to detail is required to work on the high leverage problems. A lot of the high leverage problems are not, as I said, not strategy decisions. They're not language markets to go after and stuff. A lot of them are like, why is this thing not working as well as it needs to be? And a lot of time the devil is in the details and you need to be over there. I think combining that, knowing what is high leverage or not, and two, both having the humility and the patience to be able to go dig deeper and solve that.

**中文翻译:**
这让其他高管感到困惑：他怎么敢对 CZ 说“不”，而我们都不敢？嘿，那是他的产品领域，CZ 只是在参与，那里有一种相互尊重：我们懂这个东西，他对我拒绝是因为这可能不是个好主意。所以，处理高杠杆问题需要谦逊和对细节的关注。很多高杠杆问题，正如我所说，并不是战略决策，不是要去开拓哪个语言市场之类的大事。很多时候是：为什么这个东西没达到预期的效果？很多时候魔鬼就在细节中，你需要亲自去那里。我认为要结合两点：一是知道什么是高杠杆，二是要有谦逊和耐心去深入挖掘并解决它。

---

### [01:12:34] Mayur Kamat

**English:**
Some of them are quick ones. Like if I'm looking today at, let's say how many of our signed up users convert into a long-term monthly daily active user, that could be something I focus on for a month. Because we're running a lot of experiments on early onboarding screens, early rewards, early incentives, early loyalty program, and at some point it might be like, oh, the team's got it. I've given all my... What I could do there. It's functioning. We have great PMs. I trust their execution on this. Let me just go focus on some of the compliance challenges that we have or fraud issues that we have in France.

**中文翻译:**
有些是见效快的。比如如果我今天看有多少注册用户转化成了长期的月活或日活用户，这可能是我一个月关注的重点。因为我们在早期的入职屏幕、奖励、激励、忠诚度计划上做了很多实验。到某个阶段，可能会觉得：噢，团队已经掌握了，我已经贡献了我能做的。它现在运转良好，我们有优秀的 PM，我信任他们的执行。那我就去关注我们在法国面临的一些合规挑战或欺诈问题。

---

### [01:13:13] Mayur Kamat

**English:**
Those kind of being able to kind of... The only way that works for me is I keep a very three calendar because you cannot do this without that. If you have hundreds of meetings, hundreds of one-on-ones daily standards, a lot of recurring meetings, you just can't find time to go work on high leverage problems. So that would be my kind of other stuff is you should have plenty of open spaces on your calendar. A full calendar is a badge of shame, not a badge of honor.

**中文翻译:**
这种灵活切换的能力……对我来说唯一奏效的方法是保持一个非常空闲的日程表，因为没有这个你做不到。如果你有成百上千的会议、无数的一对一、每日站会和各种重复性会议，你根本找不到时间去处理高杠杆问题。所以我的另一个建议是：你的日程表上应该有大量的空白。日程表排满是耻辱的标志，而不是荣誉的勋章。

---

### [01:13:47] Lenny Rachitsky

**English:**
These are awesome stories. Just the metaphor of the moving desk is so good. That's the epitome of a... Like what you're describing is what people now call founder mode, where the founder just goes in the details working on the problem. Brian Chesky actually did this at Airbnb while I was there. He took on a new product and was like mini CEO, essentially. I don't know if he'd called himself the product manager 'cause I don't think he loved product managers. He kind of famously got rid of product managers, which he didn't actually... But yeah, he did that very much and he sat with the team, kind of created a whole space for the team that he was in. These are awesome stories and really good example of a founder using their power to unblock and finding the highest leverage opportunities.

**中文翻译:**
这些故事太棒了。“移动办公桌”的比喻非常形象。这就是……你所描述的正是现在人们所说的“创始人模式”（Founder Mode），即创始人亲自深入细节解决问题。我在 Airbnb 时，Brian Chesky 也这么做过。他接手了一个新产品，本质上就像个“迷你 CEO”。我不知道他是否会自称产品经理，因为我觉得他并不怎么喜欢产品经理。他曾因“取消产品经理”而闻名（虽然他实际上并没这么做）……但是的，他确实深入一线，和团队坐在一起，为他所在的团队创造了一个完整的空间。这些故事非常精彩，是创始人利用权力扫清障碍并寻找最高杠杆机会的极好例子。

---

### [01:14:29] Lenny Rachitsky

**English:**
To kind of start to close off our conversation, I'm going to take you to a couple recurring themes on this podcast, recurring segments on this podcast. First, we're going to visit AI Corner and in AI Corner I ask, what's a way that you have found to use AI in AI tool, a bunch of AI tools in your work to work more efficiently to work to create better quality work?

**中文翻译:**
在结束我们的对话之前，我将带你进入本播客的几个固定环节。首先是“AI 角落”，在这里我会问：你发现了哪些在工作中使用 AI 或 AI 工具的方法，来提高效率或创造更高质量的工作？

---

### [01:14:55] Mayur Kamat

**English:**
I still haven't found a game changer for me personally. Something that I use right now and I'm a little bit not sure that am I not doing something right, what the other people are, or I'm a little bit too jaded for it.

**中文翻译:**
就我个人而言，我还没发现什么能彻底改变游戏规则的东西。我现在用的一些东西，我有点不确定是我做得不对，还是别人有更好的方法，或者是我对此有点审美疲劳了。

---

### [01:15:10] Mayur Kamat

**English:**
So we have Gemini across the work. So for meeting notes and stuff, works great, especially for folks who don't make it. We use a tool called Writer for our copywriting and UX teams, especially because we are operating in Europe across several languages. So being able to generate that very quickly, especially for illustrations and in-app messages and stuff that's been a, several tools now. But Writer just has, the copywriting market is really well done over there.

**中文翻译:**
我们在工作中使用 Gemini。对于会议记录之类的东西，它效果很好，尤其是对那些没能参会的人。我们的文案和 UX 团队使用一个叫 Writer 的工具，特别是因为我们在欧洲跨多种语言运营。能够非常快速地生成文案，尤其是插图说明和应用内消息等，现在有很多工具，但 Writer 在文案市场做得非常好。

---

### [01:15:43] Mayur Kamat

**English:**
If you ask me across N26. But even when we did this at Binance or at Agoda, there are three areas where AI is complete game changer. One is on coding. Again, you can use whatever latest tool for prototyping or not most value, especially for the companies I have worked at, which are fairly large companies, very large code bases. Having some sort of co-pilot that's integrated with your repositories. Rough data, maybe somewhere between 18 to 25% productivity boost for a developer, which is fairly massive, right?

**中文翻译:**
如果你问我 N26 的情况，或者即使是在币安或 Agoda 时，AI 在三个领域是彻底的规则改变者。第一是编程。你可以使用任何最新的原型设计工具，但最有价值的（尤其是对于我工作过的那些拥有庞大代码库的大型公司）是与代码仓库集成的某种 Copilot。粗略数据来看，它能为开发者带来 18% 到 25% 的生产力提升，这相当惊人，对吧？

---

### [01:16:09] Mayur Kamat

**English:**
So that's one category, game changer. Customer support, game changer. Whether we should do it at scale or not, that's a different kind of more ethical/human question to ask there. But for solving the bottom 70 percentile problems, "Why is my card declined? Why is there a hold on my account? What happened to the replacement card I shipped? Why is it not arrived?" Basic questions, AI automating now almost 60, 70% of that. Customers getting that real feedback. Game changer.

**中文翻译:**
所以那是第一类，规则改变者。第二是客户支持，也是规则改变者。至于我们是否应该大规模推行，那是另一个涉及伦理和人文的问题。但对于解决那底层 70% 的问题，比如“为什么我的卡被拒了？”“为什么我的账户被冻结了？”“我补办的卡到哪儿了？”这些基础问题，AI 现在能自动化处理 60% 到 70%。客户能得到实时反馈，这是规则改变者。

---

### [01:16:58] Mayur Kamat

**English:**
And the last one is just on fraud and being able to just understand patterns better on real customers versus not. At Binance, we had this product where users could exchange crypto with each other. I could pay you Bitcoin and get Thai bath in return, huge amount of fraud. And they're using AI just to understand language patterns of fraudsters versus not fraudsters. Massive. So again, as a company level, there is an incredible set of advancements across these three areas: developer productivity, customer support, and fraud.

**中文翻译:**
最后一点是反欺诈，能够更好地理解真实客户与非真实客户的模式。在币安，我们有一个用户可以互相交换加密货币的产品。我可以付给你比特币，换取泰铢，这其中有大量的欺诈。他们利用 AI 来识别诈骗者与非诈骗者的语言模式。非常有效。所以再次强调，在公司层面，这三个领域有着惊人的进步：开发者生产力、客户支持和反欺诈。

---

### [01:17:58] Mayur Kamat

**English:**
But for me personally, I'm like, what would I use that suddenly makes me a better CPO? I'm still struggling a little bit over there, but I don't think we need something at that level because largely what still remains the domain of humans is decision making and taking the brunt of the impact of what decisions you make because I would love to blame AI for some of my bad decisions. That's not why [inaudible 01:18:10].

**中文翻译:**
但对我个人而言，我在想：我能用什么来突然让我成为一个更好的 CPO？我还在为此挣扎。但我不认为我们需要那个级别的工具，因为决策以及承担决策带来的后果，在很大程度上仍然是人类的领域。虽然我很想把一些错误的决策归咎于 AI，但那不是[原因]。

---

### [01:18:10] Lenny Rachitsky

**English:**
You can still do that. You can still do that even if it's not.

**中文翻译:**
你还是可以那么做的，即使不是它的错。

---

### [01:18:13] Mayur Kamat

**English:**
Yes, yes. But again, hopeful to, generally not a big fan of ... The thing I call a little bit jaded. You have tools now that you write few things and they make a long essay for it. And then you have tools that compress long essays into few words. You could have just said few words in the first place and save the whole round trip. It's like a reverse zip. I remember when we had zip and it was a game changer, but there was a big file you needed to send over a slow network, so you compressed it and sent it and then expanded it. We're doing the reverse now. We have a small thing, we make it big and then send it over and somebody's making it small. But on these three areas, if you're at all skilled companies, if you don't have a great tool for developing productivity, you're not looking at essential basic LLM bots for deflecting customer service and you're not looking at patterns on user transactions or user communications or detect fraud, that's the first area I would focus on.

**中文翻译:**
是的，是的。但我还是抱有希望。总的来说，我不太喜欢……我称之为有点“审美疲劳”的东西。你现在有一些工具，你写几个字，它给你生成一篇长文章；然后你又有工具把长文章压缩成几个字。你本来可以直接说那几个字的，省去了整个往返过程。这就像是“反向压缩”。我记得以前有 Zip 压缩包时是革命性的，因为你需要通过慢速网络发送大文件，所以你压缩它，发送，然后解压。我们现在在做相反的事：我们把一个小东西变大，发过去，然后别人再把它变小。但在那三个领域——如果你是一家有实力的公司，如果你还没有提升开发生产力的好工具，没有使用基础的 LLM 机器人来分流客户服务，没有通过分析用户交易或沟通模式来检测欺诈，那是我会首先关注的领域。

---

### [01:19:14] Lenny Rachitsky

**English:**
Okay, I'm going to take us to another recurring segment on the podcast. It's called Fail Corner. And the idea here is folks like you come on this podcast, there's all these wins, killing it, CPO, this and that, and just moving into Thailand, it worked out incredibly, what a win all the time. In reality, that's not how things go. So the question to you here is just what's the story of a failure in your career when things didn't go well and it was a big deal for you, and then what you learned from that experience, how that actually impacted you?

**中文翻译:**
好的，我带你进入播客的另一个固定环节，叫“失败角落”。这个环节的初衷是，像你这样的人来到播客，听起来全是胜利：当上 CPO、搬到泰国大获全胜，总是在赢。但现实并非如此。所以我想问你：你职业生涯中有什么失败的故事？当时进展不顺，对你打击很大，你从中学到了什么，它又是如何影响你的？

---

### [01:19:44] Mayur Kamat

**English:**
Yeah, so from the product side, my probably most spectacular failure was I was the first PM on Hangouts. And if you ask Nikhil, he'll probably say he was my boss then. It was an effort the size I've never seen before or after in my career. We had thousands of people working for me. We had entire power of Google. We had Larry literally sitting with us saying we can do anything we want Chrome to do. And we still didn't manage to build a great messaging product.

**中文翻译:**
是的，从产品角度来看，我最惨痛的失败大概是我担任 Hangouts 的第一任 PM。如果你问 Nikhil，他可能会说他当时是我的老板。那是一个我职业生涯中前所未见的大项目。我有数千名员工，背靠谷歌的全部力量。拉里·佩奇真的就坐在我们身边，说我们可以让 Chrome 做任何我们想做的事。但我们最终还是没能打造出一款伟大的即时通讯产品。

---

### [01:20:18] Mayur Kamat

**English:**
So when I look at pure product-sense, product decision-making was, there's several reasons now I'd had luxury of 15 years to analyze that on solving for the wrong audience, solving for the wrong DNA of the company. I have this premise that certain companies can never succeed at certain type of products like Microsoft with mobile or Google with social or Facebook with enterprise, it is just the DNA of the founder actively acts against you succeeding there.

**中文翻译:**
所以当我回顾纯粹的产品感和产品决策时，现在我有 15 年的时间来分析原因：针对了错误的受众，或者挑战了公司错误的基因。我有一个前提假设：某些公司永远无法在某些类型的产品上取得成功，比如微软做移动端、谷歌做社交、脸书做企业服务。创始人的基因会主动阻碍你在这些领域取得成功。

---

### [01:20:54] Mayur Kamat

**English:**
I would've said Google with enterprise as well. But then Sundar came and Larry was no longer the CEO and that's when the enterprise took off. They literally had to change the CEO to win in certain segments, but more, and then again, I worked in Agoda during COVID, so travel company during COVID, Binance during its probably most tumultuous area of compliance and government scrutiny. There's a lot of missteps there around externalities. I think one of the main kind of learnings from that is just don't take on projects that are going to be six months, a year, because you just generally don't have control over the macro.

**中文翻译:**
我以前也会说谷歌做不好企业服务。但后来 Sundar 上任了，拉里不再担任 CEO，那时企业服务才真正起飞。他们实际上必须更换 CEO 才能在某些细分市场获胜。此外，我在疫情期间在 Agoda 工作（疫情期间的旅游公司），在币安最动荡的合规和政府审查时期工作。在应对外部因素方面有很多失误。我想从中得到的一个主要教训是：不要接手那些周期长达半年或一年的项目，因为你通常无法控制宏观环境。

---

### [01:21:46] Mayur Kamat

**English:**
Things just move way more faster. And that's probably cemented my kind of now product philosophy of just doing small things very quickly, spending most of the times doing that. You still launch big products, but even over there we try and get early signals as soon as possible. But because in Agoda, like one of the big projects we launched was we wanted to control the payments infrastructure for all the hotels and we thought if we had that device in the hotel's desk, so not only for bookings made online, but for everything that happens at the hotel, if we control that infrastructure, not only would we make money, but we had a touch point with the users that went beyond booking the travel.

**中文翻译:**
事情变化得太快了。这可能巩固了我现在的产品哲学：非常快速地做小事，并把大部分时间花在上面。你仍然会发布大产品，但即使是那样，我们也尝试尽快获得早期信号。在 Agoda，我们启动的一个大项目是想控制所有酒店的支付基础设施。我们认为，如果我们在酒店前台放置那个设备，不仅是为了在线预订，而是为了酒店发生的一切交易，如果我们控制了那个基础设施，我们不仅能赚钱，还能在预订之外与用户建立触点。

---

### [01:22:29] Mayur Kamat

**English:**
Travel as you know, is not a high frequency activity. You book once, then you book six months later and most of the time people would not come to Agoda, they would just go to Google and go to some other website. So we wanted that touch point that stayed with them and thought payments would be a great avenue to do that because that's something you do every day. And again, we did it in the Agoda style.

**中文翻译:**
如你所知，旅游不是高频活动。你预订一次，六个月后再预订，而且大多数时候人们不会直接来 Agoda，他们会去谷歌或别的网站。所以我们想要一个能留住他们的触点，并认为支付是一个很好的途径，因为那是你每天都会做的事。同样，我们是用 Agoda 风格来做的。

---

### [01:22:51] Mayur Kamat

**English:**
So we did an experiment. We started very small and literally went to the mall and bought these $50 Android devices where we ran our software that people could just scan the credit card by a camera and charge it. It was incredible. We had thousands of hotels use it. And then COVID hits and then there's literally nobody going to hotels anymore. But it took us like six, nine months because of the licenses, and so to launch it. And in hindsight probably, I mean you couldn't have thought about COVID with that sense, but still the amount of time it took to launch the product was something we could have done better. So learnings for most of it is don't take too long to launch, don't take too long to validate your hypothesis.

**中文翻译:**
我们做了一个实验。我们从小处着手，真的去商场买了那些 50 美元的安卓设备，运行我们的软件，让人们可以通过摄像头扫描信用卡并扣款。这太棒了，有数千家酒店在使用。然后疫情爆发了，字面意义上没人再去酒店了。但因为牌照等原因，我们花了六到九个月才发布。事后看来，虽然你无法预料到疫情，但发布产品所花费的时间确实是我们本可以做得更好的地方。所以大部分教训是：不要花太长时间发布，不要花太长时间验证你的假设。

---

### [01:23:40] Lenny Rachitsky

**English:**
The Hangout story is amazing. It's like a classic product. People now make fun of just Google, why can't you get this right? And it's been changed. Names have changed a hundred times. Interestingly, Meet ended up being really good, Google Meet.

**中文翻译:**
Hangouts 的故事很精彩。它是一个经典产品。现在人们常拿谷歌开玩笑：为什么你们就是搞不定这个？名字改了一百次。有趣的是，Google Meet 最终做得非常好。

---

### [01:23:52] Mayur Kamat

**English:**
That's the last thing I did when I left Google.

**中文翻译:**
那是我离开谷歌前做的最后一件事。

---

### [01:23:54] Lenny Rachitsky

**English:**
Oh, Okay.

**中文翻译:**
噢，好吧。

---

### [01:23:57] Mayur Kamat

**English:**
After we built the Hangouts, they're like, "Okay, this is not going anywhere. We are going to start this new product called Allo." Which also didn't work.

**中文翻译:**
在我们构建完 Hangouts 之后，他们说：“好吧，这玩意儿没前途，我们要启动一个叫 Allo 的新产品。”那个也没成。

---

### [01:24:05] Lenny Rachitsky

**English:**
One of the many names.

**中文翻译:**
众多名字中的一个。

---

### [01:24:08] Mayur Kamat

**English:**
But then I said, you know what? We should still, because I used to work for Android Enterprise team before, I'm like, what if we just made it an enterprise product? Let me at least write the spec for it on, hey, what would we do differently for, I still called it Hangouts by Enterprise. They rebranded it later. But that was my salvaging moment for, but from the sense, I mean the Hangouts team invented WebRTC. Now every single communication in the world happens on WebRTC. So if you think from the cultural and technological impact that the Hangouts team had is insane. Like this tool we are using every single meeting product, every single WhatsApp, voice calling, video calling, every Zoom, everything runs on WebRTC. From a technology side, I think that was a pretty massive win that the team came up with that.

**中文翻译:**
但后来我说，你知道吗？我们还是应该……因为我以前在安卓企业团队工作过，我想：如果我们把它做成企业产品呢？让我至少为它写份规格说明书（Spec），看看针对企业我们会做哪些不同的尝试。我当时还叫它“Hangouts 企业版”，后来他们改名了。那是我的“救赎时刻”。但从某种意义上说，Hangouts 团队发明了 WebRTC。现在世界上几乎所有的即时通讯都基于 WebRTC。如果你想想 Hangouts 团队产生的文化和技术影响，那是疯狂的。就像我们现在用的这个工具，每一个会议产品，每一个 WhatsApp 语音通话、视频通话，每一个 Zoom，全都运行在 WebRTC 上。从技术角度看，我认为团队能研发出这个是一个巨大的胜利。

---

### [01:25:04] Lenny Rachitsky

**English:**
That's the power of having Chrome having a browser, also, just introducing technologies.

**中文翻译:**
这就是拥有 Chrome 浏览器并引入新技术的威力。

---

### [01:25:09] Mayur Kamat

**English:**
Yeah. Yes, absolutely.

**中文翻译:**
是的，绝对是。

---

### [01:25:12] Lenny Rachitsky

**English:**
Final question before we get to a very exciting lightning round, is there anything else that you want to leave listeners with or maybe a point you want to double down on just to kind of leave a little last little nugget before we get to the lightning round?

**中文翻译:**
在进入非常令人兴奋的闪电轮之前，最后一个问题：你还有什么想留给听众的吗？或者有什么你想再次强调的观点，作为闪电轮前的最后一个锦囊？

---

### [01:25:24] Mayur Kamat

**English:**
I mean, just summarize, it depends on the audience. A lot of the folks who probably listen to it or coming it from a perspective of like, "Hey, how does this help me be better at my job tomorrow than I was today?" And for them I would say, again, if you're truly working in areas where you think you're optimizing your strengths and having fun, just keep doing it and just keep that as your kind of north star, as you look at new pieces. When you talk to new companies, try and evaluate the overlap of superpowers. What is your superpower? What is the company's superpower? Will they feed each other?

**中文翻译:**
我想总结一下，这取决于受众。很多听众可能是从这个角度出发：“嘿，这如何能让我明天的工作做得比今天更好？”对于他们，我会再次说：如果你真的在那些能优化你优势并让你感到快乐的领域工作，那就坚持下去，并将其作为你的北极星。当你与新公司交谈时，试着评估“超能力”的重合度。你的超能力是什么？公司的超能力是什么？它们能互相促进吗？

---

### [01:26:01] Mayur Kamat

**English:**
If you get a very strong resonance there, I think that would be a great career step irrespective of whether it's in Bangkok or Spain or however the compensation is going to be, because truly you'll find that you grow much faster because it's a kind of self-fulfilling prophecy at that point. But just keep looking for overlapping superpowers all the time and not just in professional life, even the concepts beyond maybe even for relationships and stuff like folks who are extremely complementing strengths and whose superpowers feed each other make for great life partners. So there's maybe that analogy can be extended beyond your career.

**中文翻译:**
如果你在那里感受到了强烈的共鸣，我认为那将是一个伟大的职业步骤，无论是在曼谷还是西班牙，无论薪酬如何。因为你会发现自己成长得更快，在那一刻它变成了一种自我实现的预言。要一直寻找重合的超能力，不仅是在职业生活中，甚至在人际关系中也是如此：那些优势互补、超能力互相促进的人会成为伟大的伴侣。所以这个类比也许可以延伸到职业生涯之外。

---

### [01:26:51] Lenny Rachitsky

**English:**
Wow, that's a powerful point right there. Well, what a cool way to end that. Well, with that Mayur, we've reached our very exciting lightning round. I've got five questions for you. Are you ready?

**中文翻译:**
哇，这真是一个有力的观点。多么酷的结尾。那么 Mayur，我们进入了非常令人兴奋的闪电轮。我有五个问题要问你。准备好了吗？

---

### [01:27:01] Mayur Kamat

**English:**
Yeah, let's do it.

**中文翻译:**
准备好了，开始吧。

---

### [01:27:02] Lenny Rachitsky

**English:**
What are two or three books that you find yourself recommending most to other people?

**中文翻译:**
你最常向别人推荐的两三本书是什么？

---

### [01:27:06] Mayur Kamat

**English:**
The one that I read most recently, so I generally don't read a lot of books because I read a lot of content like, small content. Tweets. And tweets and then Substacks and Discords and WhatsApp messages, and so book takes a mind share shift for me to go read a book. The one I read most recently, which I thought was pretty amazing and a lot of overlap with what I said today, The Five Kinds Of Wealth. That one was very well articulated, especially the last point I made very early. One of the potential paths is you just do well on your job and then you find meaning elsewhere. This book is probably an incredible structured way of thinking around it. What is your wealth in terms of your health, your physical health, your mental health, your relationship health, your community and your wealth that you're generating financial wealth is and how do you think holistically? Because at the end of the day, you are what you optimize for. If you optimize for financial wealth, you'll become wealthy, but you might not be wealthy in a full spectrum manner.

**中文翻译:**
我最近读的一本——我通常不读很多书，因为我读很多碎片化内容，比如推特、Substack、Discord 和 WhatsApp 消息，所以读书需要我进行思维转换。我最近读的一本我觉得非常棒，和我今天说的很多内容都有重合，叫《五种财富》（The Five Kinds Of Wealth）。它阐述得非常好，尤其是关于我之前提到的：一种可能的路径是你在工作中表现出色，然后在别处寻找意义。这本书提供了一个极好的结构化思考方式。你的财富包括：健康（身体和心理）、人际关系、社区，以及你创造的财务财富。你如何全面地思考？因为归根结底，你优化什么，你就会得到什么。如果你只优化财务财富，你会变得有钱，但你可能在其他维度上并不富有。

---

### [01:28:16] Mayur Kamat

**English:**
The Strengths Finder 2.0, I said very early on. It's still an interesting book to just think about how you would think about your strengths, but again, if you don't want to read the book, I would just do one of these kind of online quizzes for it. But The Five Kinds of Wealth then Strength Finder 2.0 would be maybe what I would suggest.

**中文翻译:**
还有我之前提到的《优势识别器 2.0》（Strength Finder 2.0）。它仍然是一本思考优势的有趣书籍，但如果你不想看书，直接做个在线测试也行。所以《五种财富》和《优势识别器 2.0》是我会推荐的。

---

### [01:28:35] Lenny Rachitsky

**English:**
The first book by Sahil Bloom friend of the podcast willing to tell this stuff. I forgot to mention the story briefly about the Strength Finder stuff. So I actually, when I was leaving Airbnb and looking for my next thing and even thinking about leaving, I took a strengths test and I was working with executive coach and I saw the results and she's like, "What do you see in these results? What are these results telling you?" I'm like, I don't know. She's like, this tells me you should start your own company and work on your own. All the strengths that are popping up here are things that you as a founder need and that really helped me.

**中文翻译:**
第一本书是 Sahil Bloom 写的，他是本播客的朋友。我忘了简短提一下关于《优势识别器》的故事。当我离开 Airbnb 寻找下一站，甚至还在考虑离开时，我做了一个优势测试。我当时在和一位高管教练合作，她看了结果问我：“你从这些结果中看到了什么？它们告诉你什么？”我说不知道。她说：“这告诉我你应该创办自己的公司，独立工作。这里显示的所有优势都是一个创始人所需要的。”这真的帮了我大忙。

---

### [01:29:07] Mayur Kamat

**English:**
What's your one person data point on that? Was it a good one?

**中文翻译:**
作为唯一的样本，那是一个好的决定吗？

---

### [01:29:11] Lenny Rachitsky

**English:**
Was it is a good decision, you mean?

**中文翻译:**
你是说那是不是个好决定？

---

### [01:29:13] Mayur Kamat

**English:**
Yes, relying on that strength test to make a career.

**中文翻译:**
是的，依靠那个优势测试来做职业决策。

---

### [01:29:17] Lenny Rachitsky

**English:**
The best. So great. I am such a huge fan of Strengths Finder and any kind of strengths test and interestingly, people may be afraid of taking them because they'd be like, here's what I suck at. It always makes you feel good. It's like, here's the stuff you're good at and it's not like, here's what you're bad at. It's just, here's the stuff you're best at and it's always positive. It's never like you suck at this stuff. It's just not your strength. So it was a huge win for me. I highly recommend it.

**中文翻译:**
最好的决定。太棒了。我是《优势识别器》和各类优势测试的忠实粉丝。有趣的是，人们可能会害怕做测试，因为他们觉得会看到自己哪里不行。但它总是让你感觉良好，它告诉你你擅长什么，而不是你哪里差。它总是积极的，从不会说“你这方面很烂”，只会说“这不属于你的优势”。所以对我来说那是巨大的胜利，我强烈推荐。

---

### [01:29:40] Mayur Kamat

**English:**
Awesome.

**中文翻译:**
太棒了。

---

### [01:29:40] Lenny Rachitsky

**English:**
Especially if you're trying to make a career move. So yeah, fully aligned. Okay, next question. Do you have a favorite recent movie or TV show you've really enjoyed?

**中文翻译:**
尤其是如果你正打算转换职业。所以，完全赞同。好的，下一个问题：你最近有没有特别喜欢的电影或电视剧？

---

### [01:29:48] Mayur Kamat

**English:**
The one I saw that kind of TV shows usually I watch to kind of give it down time, so usually I watch just periodic shows, the House or Big Bang Theory and stuff. The one that I saw recently that kind of shook me a little bit was Adolescence. Again, it's a tough topic around teenage mental health and violence in schools and just the way it was shot. I would see the first episode, even if it's not your genre because it's shot in a single camera motion and the whole episode for an hour, there's no cut. Camera just keeps moving and it just makes bizarre, you feel a little different than watching it. Irrespective of this topic, which is also pretty intense. Just visually you feel different, and if you're motion sick like me, you really feel different.

**中文翻译:**
我平时看电视剧主要是为了放松，所以通常看一些情景剧，比如《豪斯医生》或《生活大爆炸》之类的。最近看了一部让我有点震撼的叫《Adolescence》（青少年）。这是一个关于青少年心理健康和校园暴力的沉重话题，但它的拍摄方式很特别。即使这不是你喜欢的类型，我也建议你看第一集，因为它采用了“一镜到底”的拍摄方式，整整一个小时没有剪辑。镜头一直在移动，这让你感觉很奇妙，和看普通剧完全不同。抛开沉重的话题不谈，仅仅是视觉上就很不一样。如果你像我一样晕车，你真的会感觉很不一样。

---

### [01:30:41] Lenny Rachitsky

**English:**
That's wonderful. It sounds like what a ...

**中文翻译:**
太棒了。听起来像是一个……

---

### [01:30:45] Mayur Kamat

**English:**
I would watch that. I need to watch The White Lotus because everybody keeps bringing it every time I tell them I'm from Thailand and I haven't seen it yet, so I'm behind on my mean culture a little bit.

**中文翻译:**
我会去看的。我得看《白莲花度假村》，因为每次我告诉别人我来自泰国，他们都会提到它，而我还没看过，我在流行文化上有点落后了。

---

### [01:30:58] Lenny Rachitsky

**English:**
Yeah, you are. It's like you, no one else has not seen it. I think you're the only person left.

**中文翻译:**
是的，你确实落后了。好像除了你，没谁没看过了。我觉得你是最后一个没看的人。

---

### [01:31:01] Mayur Kamat

**English:**
Yes, I'm the only one.

**中文翻译:**
是的，我是唯一一个。

---

### [01:31:04] Lenny Rachitsky

**English:**
Okay. Do you have a favorite product you've recently discovered that you really love?

**中文翻译:**
好的。你最近有没有发现什么特别喜欢的产品？

---

### [01:31:08] Mayur Kamat

**English:**
So products, so I spend most of my time using banking and trading products, and I would give a plug here. If you're in Europe, try N26 or even Revolut, incredible product. If you're in the US, Robinhood, just the motion design they have done and the onboarding is just a joy to use, whether you use it for banking or trading or just for their card. I just find the product design and motion, especially as you touch and swipe and try to be done. Anything that Nikita Bier launches. So I just downloaded Bible study or Bible chat yesterday.

**中文翻译:**
关于产品，我大部分时间都在用银行和交易类产品，这里我要安利一下。如果你在欧洲，试试 N26 甚至 Revolut，非常棒的产品。如果你在美国，Robinhood 的动效设计和入职流程用起来简直是一种享受，无论你是用它存钱、交易还是用它的卡。我非常喜欢它的产品设计和动效，尤其是触摸和滑动时的反馈。还有 Nikita Bier 发布的任何东西。我昨天刚下载了 Bible Chat。

---

### [01:31:46] Lenny Rachitsky

**English:**
I saw a tweet about that. It's like in the top 10 of all social apps and it's like bible study.

**中文翻译:**
我看到关于那个的推特了。它在所有社交应用中排名前十，居然是个圣经学习应用。

---

### [01:31:52] Mayur Kamat

**English:**
Yeah, it's top ten. And I can tell why I have got three messages right now to treat my anxiety by reading Bible today, and one of the time I was feeling slightly anxious, so maybe there's some magic there.
(01:32:03):
But the one app that I would just for personal, I used to write in Hindi. I used to write poems growing up as a kid, and that was just now this app Suno.com. I can make songs from them and they're incredible songs, at least I think so. Nobody else thinks it so far, but just the fact that you can write something and now you have a song is just magical. The first time that AI, I saw a use case, I said, it's nothing so far that makes me a better CPO right now, but as an artist or at least the bathroom artist, it's just incredible that you can think of something, put it down there and you can actually see what would a professional singer and a band and a musician if they were to compose it, what it would look like. So that's probably the most wild I have been by technology, the recent times, the Suno.com. They're onboarding flow sucks and their growth product is, if I were the PM on Suno, I would do things a lot differently, but their core tech is magical.

**中文翻译:**
是的，前十名。我能理解为什么，我刚刚收到了三条消息，建议我今天读圣经来缓解焦虑，而我当时确实感到有点焦虑，所以也许它真的有魔力。
但就个人而言，我小时候常用印地语写诗。现在有了 Suno.com 这个应用，我可以把诗变成歌，而且是非常棒的歌，至少我是这么认为的。虽然目前还没人这么觉得，但仅仅是“写点东西就能变成一首歌”这件事就很神奇。这是我第一次看到 AI 的实际用例，虽然它目前没法让我成为更好的 CPO，但作为一个艺术家（或者至少是浴室歌手），你能把想法写下来，然后看到如果由专业歌手、乐队和音乐家来创作会是什么样子，这太不可思议了。这可能是我近期被技术震撼得最厉害的一次。Suno.com 的入职流程很烂，如果我是他们的 PM，我会做得完全不同，但他们的核心技术是神奇的。

---

### [01:33:15] Lenny Rachitsky

**English:**
I'm a huge fan. One of my favorite things to do at Suno, I think it's Suno.ai also, is just ask it to make a song in the style of a sea shanty. It's so fun. And they give you a few options, so you could be like, here's this version, that version.

**中文翻译:**
我也是它的超级粉丝。我在 Suno（好像也是 Suno.ai）最喜欢做的事就是让它做一首“海员号子”（Sea Shanty）风格的歌。太好玩了。它会给你几个选项，你可以选这个版本或那个版本。

---

### [01:33:29] Lenny Rachitsky

**English:**
Okay, two more questions. Do you have a favorite life motto that you often come back to find useful in work or in life?

**中文翻译:**
好的，还有两个问题。你有没有什么喜欢的座右铭，觉得在工作或生活中很有用？

---

### [01:33:35] Mayur Kamat

**English:**
One, I kind of relates to the things we talked about is there's no right or wrong decision. There's just low and fast decisions. Now, there are some extreme caveats to that around you're doing something that might kill your user like healthcare or military or even compliance, which can kill your company. Don't use it. But everywhere else in generally goes back to the strategy thing we talked about as well. A lot of the times if it's you make a wrong decision, if you make it fast enough, you would know it was wrong and you would correct it and you would still do it faster than thinking months for the right decision. So for anything that's reversible, anything that's not going to get you in jail or kill your company, no right or wrong decisions, just slow or fast decisions.

**中文翻译:**
有一个和我之前谈到的相关的：没有对或错的决定，只有慢和快的决定。当然，这有一些极端的例外，比如你在做医疗、军事或合规等可能导致用户死亡或公司倒闭的事情，那就不能这么干。但在其他地方，这通常会回到我们谈到的战略问题。很多时候，如果你做了一个错误的决定，但你做得足够快，你很快就会知道它错了并加以纠正，这仍然比花几个月思考一个“正确”的决定要快。所以，对于任何可逆的、不会让你坐牢或让公司倒闭的事情，没有对错之分，只有快慢之别。

---

### [01:34:19] Lenny Rachitsky

**English:**
Final question. You've lived in a bunch of places. You've lived in Spain, Thailand, Mumbai, Seattle, I think Texas, even for some period for school?

**中文翻译:**
最后一个问题。你在很多地方住过：西班牙、泰国、孟买、西雅图，我想还有德克萨斯（在那儿上过学）？

---

### [01:34:29] Mayur Kamat

**English:**
Yeah. College, yes.

**中文翻译:**
是的，大学在那儿。

---

### [01:34:30] Lenny Rachitsky

**English:**
Okay. There's probably other places. Which has the best food?

**中文翻译:**
好的，可能还有别的地方。哪里东西最好吃？

---

### [01:34:34] Mayur Kamat

**English:**
Bangkok, no question. Barcelona comes closer for some, but Bangkok, you can have a three Michelin star, one of the top five restaurants in the world, spend $500 a meal or you can have a $1 street food, stir-fried pork and rice with basil. Incredible. Just the spectrum of entire, from the cheapest food you can think of, the most expensive food you can think of in that same one kilometer walkable area, having thousands of these, literally there's the density of food. No one comes closer. Barcelona has incredible restaurant. The best restaurant in the world is like a block away from here. It's called Disfrutar. Takes like two years to get on the wait list there, but that's on one end of the spectrum, Barcelona, that probably comes close second. But that cheap, get down 2:00 A.M. walk down and have an incredible meal for a dollar. nothing comes closer to it than Bangkok.

**中文翻译:**
曼谷，毫无疑问。巴塞罗那在某些方面很接近，但在曼谷，你可以去吃米其林三星、全球前五的餐厅，一顿饭花 500 美元；也可以花 1 美元在街头吃一份罗勒叶炒猪肉饭。太不可思议了。在方圆一公里的步行范围内，涵盖了你能想象到的最便宜到最昂贵的食物，而且有成千上万家，那种食物密度无与伦比。没人能比得上。巴塞罗那也有很棒的餐厅，世界上最好的餐厅 Disfrutar 就在离这儿一个街区的地方，排队要等两年。那是巴塞罗那的一端，它可能排第二。但那种凌晨两点下楼花一美元就能吃到人间美味的体验，只有曼谷。

---

### [01:35:40] Lenny Rachitsky

**English:**
This episode's a great ad for Thailand. Let's go. You definitely got to watch White Lotus. Mayur, this was awesome. We covered so much ground. I feel like I got to know you so well. We covered so many perspectives in all this. Yeah, we're not done yet. Two final questions. Where can folks find you online if they want to reach out, maybe check out if there's roles at N26 and then how can listeners be useful to you?

**中文翻译:**
这一集简直是泰国的绝佳广告。走起。你一定要看《白莲花度假村》。Mayur，这太棒了。我们聊了这么多内容，我觉得我很了解你了，我们探讨了这么多视角。还没完，最后两个问题：如果人们想联系你，或者想看看 N26 有没有职位，在哪里可以找到你？听众可以为你做些什么？

---

### [01:36:02] Mayur Kamat

**English:**
Find me, this is one of the things being old is I was one of the first users of LinkedIn, so linkedin.com/mayur. Facebook, so facebook.com/kamat or N26.com. mk@N26.com. If you're especially curious about how we do stuff here, we are hiring, we are growing really fast. As I said, banking's a great business to be in. We're not going to go out of flavor for the next few thousand years. So if you're thinking of a career, you're thinking about Spain or was thinking about Berlin, just a whole different interesting lifestyle and different kind of product thinking, please reach out on any of those channels.

**中文翻译:**
找我的话，作为“老人”的好处之一是我最早的一批 LinkedIn 用户，所以是 linkedin.com/mayur。Facebook 是 facebook.com/kamat，或者通过 N26.com。我的邮箱是 mk@N26.com。如果你对我们做事的方式感兴趣，我们正在招聘，增长非常快。正如我所说，银行是一门极好的生意，未来几千年都不会过时。所以如果你在考虑职业发展，考虑西班牙或柏林，想要一种完全不同的有趣生活方式和产品思维，请通过这些渠道联系我。

---

### [01:36:46] Mayur Kamat

**English:**
If you're in Europe, download or try N26. Like we go by the motto, love your bank. Our founders say that people would rather go to a dentist than to a bank branch, and that's why we build this. We truly feel like for an everyday banking, it's just use the app and you feel like, I want to use my banking app every day. There's some bit of magic, which I didn't have that much contribution yet. I made it a little bit simple and seamless, but magic was there before and so if you're in Europe, you're looking for a new bank account, N26.com.

**中文翻译:**
如果你在欧洲，下载或尝试一下 N26。我们的座右铭是“爱上你的银行”。我们的创始人说，人们宁愿去看牙医也不愿去银行网点，这就是我们构建 N26 的原因。我们真心觉得，对于日常银行业务，只要你用了这个 App，你就会觉得每天都想用它。这其中有一点魔力，虽然我目前的贡献还不多（我只是让它变得更简单、更无缝），但那种魔力一直都在。所以如果你在欧洲寻找新账户，请访问 N26.com。

---

### [01:37:22] Lenny Rachitsky

**English:**
There we go. Mayur, thank you so much for being here.

**中文翻译:**
太好了。Mayur，非常感谢你能来。

---

### [01:37:26] Mayur Kamat

**English:**
Thank you. Thank you, Lenny, and thank you everyone.

**中文翻译:**
谢谢。谢谢 Lenny，谢谢大家。

---

### [01:37:28] Lenny Rachitsky

**English:**
Bye, everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at LennysPodcast.com. See you in the next episode.

**中文翻译:**
再见，各位。非常感谢收听。如果你觉得本集内容有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现这个播客。你可以在 LennysPodcast.com 找到所有往期节目或了解更多信息。下期节目见。