# Megan Cook - 双语对照

This is the complete bilingual (English-Chinese) transcript for Lenny's Podcast featuring Megan Cook, Head of Product for Jira at Atlassian.

---

### [00:00:00] Megan Cook

**English:**
What we put into place is something we call Fight Club. I'll probably get in trouble for talking about Fight Club. The first rule is you don't talk about Fight Club. But it's 30 minutes every week, and it's just for myself, my engineering, and my design leader; and we get together, and we know that we're going there to have a conflict.

**中文翻译:**
我们建立了一个名为“搏击俱乐部”（Fight Club）的机制。聊这个可能会让我惹上麻烦，毕竟第一条规则就是“不许谈论搏击俱乐部”。但实际上，这是每周一次、时长 30 分钟的会议，参加者只有我、我的工程负责人和设计负责人。我们聚在一起，心里很清楚这次会议的目的就是为了产生冲突。

---

### [00:00:18] Megan Cook

**English:**
I think often when there's difficult conversations, or those conflicts come up, you can put them off until they become much bigger. Or if somebody is conflict adverse, they can try to avoid having it at all. But by having a specific slot of time in your week for something like that, then you're sort of in that mindset. You know you're going in there to solve a hard problem. You know that there's going to be a disagreement. And it makes it much better. I think the relationship we all have is so much better because we get on top of these things early.

**中文翻译:**
我认为，当出现艰难的对话或冲突时，人们往往会拖延，直到问题变得更大。或者，如果有人回避冲突，他们可能会试图完全避免讨论。但通过在每周专门安排一个时间段来处理这类事情，你就会进入那种心态。你知道你是去解决难题的，你知道会有分歧。这让情况变得好多了。我觉得我们之间的关系之所以这么好，正是因为我们能及早处理这些问题。

---

### [00:00:51] Lenny

**English:**
Today, my guest is Megan Cook. Megan is head of product for Jira, which is used by 75% of Fortune 500 companies, 125,000 customers globally, and is by far the most popular project management tool in the world.

**中文翻译:**
今天的嘉宾是 Megan Cook。Megan 是 Jira 的产品负责人。全球 75% 的财富 500 强公司都在使用 Jira，它在全球拥有 12.5 万名客户，是迄今为止世界上最受欢迎的项目管理工具。

---

### [00:01:06] Lenny

**English:**
Megan has been at Atlassian for just under 11 years. Prior to Atlassian, Megan was an analyst, a developer, and an agile coach.

**中文翻译:**
Megan 在 Atlassian 工作了近 11 年。在加入 Atlassian 之前，她曾担任过分析师、开发人员和敏捷教练（Agile Coach）。

---

### [00:01:15] Lenny

**English:**
In our conversation, we discuss what Atlassian has done so right in being able to offer 15 different product lines, which many companies dream of, how they continue to stay ahead of the market in spite of the many competitors in the space, why Megan considers play so essential to building great teams and great products, a bunch of tactical advice for getting buy-in for your ideas, tips for being a successful PM in a remote environment. Also, a great story of failure, and so much more; including surfing tips. With that, I bring you Megan Cook after a short word from our sponsors.

**中文翻译:**
在我们的对话中，我们讨论了 Atlassian 究竟做对了什么，从而能够提供 15 条不同的产品线（这是许多公司的梦想）；尽管竞争激烈，他们如何持续保持市场领先地位；为什么 Megan 认为“玩乐”（Play）对于构建优秀团队和产品至关重要；以及一系列关于如何让你的想法获得认可（Buy-in）的战术建议，和在远程办公环境下成为成功产品经理（PM）的技巧。此外，还有一个精彩的失败故事，以及更多内容，甚至包括冲浪建议。在听完赞助商的简短介绍后，让我们欢迎 Megan Cook。

---

### [00:01:49] Lenny (Sponsor: Teal)

**English:**
This time of year is prime for career reflection and setting goals for professional growth. I always like to spend this time reflecting on what I accomplished the previous year, what I hope to accomplish the next year, and whether this is the year I look for a new opportunity. That's where today's sponsor, Teal, comes in. Teal provides you with the tools to run an amazing job search. With an AI-powered resume builder, job tracker, cover letter generator, and Chrome extension that integrates with over 40 job boards, Teal is the all-in-one platform you need to run a more streamlined and efficient job search and stand out in this competitive market. There's a reason nearly 1 million people have trusted Teal to run their job search. If you're thinking of making a change in the new year, leverage Teal to grow your career on your own terms. Get started for free at tealhq.com/lenny. That's tealhq.com/lenny.

**中文翻译:**
每年的这个时候都是职业反思和设定成长目标的黄金时期。我总是喜欢花时间回顾过去一年的成就，展望下一年的目标，并思考今年是否是寻找新机会的好时机。这就是今天的赞助商 Teal 大显身手的地方。Teal 为你提供了一套出色的求职工具。凭借 AI 驱动的简历生成器、职位追踪器、求职信生成器，以及集成了 40 多个招聘网站的 Chrome 浏览器扩展，Teal 是你进行更精简、更高效求职并在竞争激烈的市场中脱颖而出所需的一站式平台。近 100 万人信任 Teal 来管理他们的求职过程是有原因的。如果你正考虑在新年做出改变，请利用 Teal 按照你自己的方式发展职业生涯。在 tealhq.com/lenny 免费开始使用。

---

### [00:02:39] Lenny (Sponsor: Sprig)

**English:**
Let me tell you about a product called Sprig. NextGen product teams like Figma and Notion rely on Sprig to build products that people love. Sprig is an AI-powered platform that enables you to collect relevant product experience insights from the right users so you can make product decisions quickly and confidently. Here's how it works: it all starts with Sprig's precise targeting, which allows you to trigger in-app studies based on users' characteristics and actions taken in product. Then, Sprig's AI is layered on top of all studies to instantly surface your product's biggest learnings. Sprig's surveys enables you to target specific users to get relevant and timely feedback. Sprig replays enables you to capture targeted session clips to see your product experience firsthand. Sprig's AI is a game changer for product teams. They're the only platform with product level AI, meaning it analyzes data across all of your studies to centralize the most important product opportunities, trends, and correlations, in one realtime feed. Visit sprig.com/lenny to learn more and get 10% off. That's S-P-R-I-G.com/lenny.

**中文翻译:**
让我向你介绍一款名为 Sprig 的产品。像 Figma 和 Notion 这样的下一代产品团队都依赖 Sprig 来打造深受人们喜爱的产品。Sprig 是一个 AI 驱动的平台，它能让你从目标用户那里收集相关的产品体验洞察，从而快速、自信地做出产品决策。它的工作原理是：首先通过 Sprig 的精准定位，根据用户特征和产品内行为触发应用内研究。然后，Sprig 的 AI 会对所有研究进行分析，即时呈现最重要的产品心得。Sprig 的调查功能让你能针对特定用户获取相关且及时的反馈。Sprig 的回放功能（Replays）让你能捕捉特定的会话片段，亲身体验产品。Sprig 的 AI 是产品团队的“游戏规则改变者”。他们是唯一拥有产品级 AI 的平台，这意味着它能分析所有研究中的数据，并在一个实时信息流中汇总最重要的产品机会、趋势和关联性。访问 sprig.com/lenny 了解更多并享受 10% 的折扣。

---

### [00:03:53] Lenny

**English:**
Megan, thank you so much for being here, and welcome to the podcast.

**中文翻译:**
Megan，非常感谢你能来，欢迎来到播客。

---

### [00:03:57] Megan Cook

**English:**
Thanks so much, Lenny. I am a big fan of your podcast, and I am excited to be here.

**中文翻译:**
非常感谢，Lenny。我是你播客的忠实粉丝，很高兴能来到这里。

---

### [00:04:02] Lenny

**English:**
I have a lot of things I want to chat about. I've heard about many things that you're extremely good at as a leader, as a product leader, and so I'm just going to poke around a bunch of different areas. I wanted to start with something that I hear you're just a big advocate of and really good at, which is creating space for play on teams and also just creating a lot of psychological safety, something that you find really important that helps your teams be as successful as they are.
(00:04:29):
Can you just talk about why this is important to you, why creating play and psychological safety are so important to you, and then just how you do this, maybe an example or two of how you actually apply this on your teams?

**中文翻译:**
我有很多想聊的话题。我听说你在作为领导者、尤其是产品领导者方面有很多擅长的领域，所以我打算在不同领域都探索一下。我想从一个我听说你非常推崇且擅长的事情开始，那就是在团队中创造“玩乐”的空间，以及营造高度的心理安全感（Psychological Safety）。你认为这非常重要，能帮助你的团队取得成功。你能谈谈为什么这对比你如此重要，以及你是如何做到的吗？能不能举一两个在团队中实际应用的例子？

---

### [00:04:40] Megan Cook

**English:**
Yeah, absolutely. I think especially recently in the tech industry, it almost feels like we're going through a bit of a wake-up call at the moment. We were in this time of plenty, and everyone was hiring like crazy, and then COVID hit and suddenly people's behaviors had to really change. People couldn't travel; they had to work from home. There's a whole bunch of industries that got highly impacted by that, and it created this time of high ambiguity.
(00:05:08):
Before that, or to the start of that, I was noticing within my team just some little indicators where people weren't all comfortable to speak up when we'd had really open discussions with the most junior person, where the most senior person were happy to talk about anything. There was more anonymity in feedback. Every time things were coming to leadership to give feedback on, it was just sort of painfully polished. And I think once it gets to that level, that's a really bad time to give feedback, because it probably means that a whole ton of work has gone into it, and you might waste a whole bunch of work if you have to correct direction or make significant changes.

**中文翻译:**
好的，没问题。我认为，尤其是最近的科技行业，感觉我们正经历一个“觉醒时刻”。我们曾处于资源丰富的时代，每个人都在疯狂招聘，然后新冠疫情来袭，人们的行为不得不发生巨大改变。人们无法旅行，必须在家工作。许多行业受到了严重影响，这创造了一个高度不确定的时期。
在疫情之前或刚开始时，我注意到团队中出现了一些小迹象：人们不再像以前那样敢于直言了。以前我们会有非常开放的讨论，从最资浅的员工到最资深的领导都乐于谈论任何事情。但后来反馈变得越来越匿名。每当有东西提交给领导层寻求反馈时，它们都被修饰得过于完美。我认为一旦到了那个程度，就是给出反馈的最糟糕时机，因为这意味着已经投入了大量工作，如果你必须纠正方向或做出重大改变，可能会浪费掉大量心血。

---

### [00:05:53] Megan Cook

**English:**
And so, I was looking at my team and thinking, "Yeah, something doesn't feel quite right here." And then I went to this leadership outside, and one of the speakers there was Ben Crowe. He's an expert in having the right mindset. So he works with Olympic gold medalists, and Ash Barty is another one, who's a tennis player. She's the number one tennis player in the entire world. So these athletes who have to really perform under a lot of pressure, in front of a lot of people. And he talked about how to be in that state of flow, where everything is going really well and new ideas are coming and you're making progress, you've got great momentum. And he talked about how to be in that flow state. There needs to be this sense of play and that things are fun. Your mind's open to new ideas, you feel really present. You're not stressing out and thinking about a ton of other different things.
(00:06:52):
It's funny because when I thought about play where my mind went to the opposite of play is work. We often hear work and play as opposites together, but his point was actually that the opposite of play is fear. And I realized I think that's what I was seeing a lot of in my team and that's why the ideas were getting more incremental. So took that decision and went, okay, we need to look at psychological safety in that team or we're never going to get to some of these bigger, bolder, more innovative ideas. And so brought my group, product managers together, and we sat around and discussed it and all together came up with some ideas that we've implemented since then, which has had a really good impact. So I'll give you a couple.

**中文翻译:**
所以，我看着我的团队心想：“嗯，有些地方感觉不太对劲。”后来我参加了一个领导力研讨会，演讲者之一是 Ben Crowe。他是心态管理方面的专家，曾与奥运金牌得主合作，还有世界排名第一的网球运动员 Ash Barty。这些运动员必须在巨大的压力和众目睽睽之下表现。他谈到了如何进入“心流”（Flow）状态——在那时一切都进展顺利，新想法层出不穷，你正在取得进展，动力十足。他说要进入这种心流状态，需要有一种“玩乐感”，觉得事情很有趣。你的思想对新想法开放，你感到活在当下，而不是压力山大、胡思乱想。
有趣的是，当我想到“玩乐”时，我脑海中它的反义词是“工作”。我们经常把工作和玩乐看作对立面，但他的观点是：玩乐的反义词其实是“恐惧”。我意识到，这正是我在团队中看到的现象，这也是为什么我们的想法变得越来越保守、缺乏突破。于是我决定，我们必须关注团队的心理安全感，否则我们永远无法产生那些更大胆、更具创新性的想法。所以我召集了我的产品经理团队，大家坐在一起讨论，共同想出了一些点子并付诸实施，效果非常好。我给你举几个例子。

---

### [00:07:40] Lenny

**English:**
Yeah, please.

**中文翻译:**
好的，请讲。

---

### [00:07:40] Megan Cook

**English:**
One of the first ones was my team of PMs is big enough now where not everyone necessarily gets to know everyone else, and when you don't have that relationship, it can feel a little scary. You don't have that trust that you understand how people are going to respond to you and you're not sure about reaching out. So we divided the team into these smaller groups for peer feedback groups and the idea is that they meet every two weeks or so, somebody brings something that's in a pretty rough draft that they want to get reviewed and then everyone's expected to give feedback. And because we've got people in there who are different leadership levels, it's a really good opportunity to model the kind of feedback that's helpful and the culture there is one of everyone lifting that person up to make their work stronger.
(00:08:28):
So people can get in there, they can show that you can show work that's really in the early stages and feel comfortable with that. They can see that getting feedback can actually be really positive and they can see how all of these people together, they can rely on them and forge those relationships so they can rely on more people to help them out.

**中文翻译:**
第一个例子是，我的 PM 团队现在已经足够大了，以至于不是每个人都互相认识。当你没有那种关系基础时，沟通会让人感到有点害怕。你没有那种信任感，不知道别人会如何回应你，也不敢主动联系。所以我们将团队分成了更小的“同行反馈小组”（Peer Feedback Groups）。想法是他们大约每两周见一次面，有人带一份非常粗略的草案来寻求评审，然后每个人都要给出反馈。因为小组里有不同职级的人，这是一个很好的机会来示范什么样的反馈是有帮助的。那里的文化是每个人都在帮助那个人提升，让他们的工作变得更出色。
这样人们就可以在非常早期的阶段展示工作，并感到很自在。他们能看到获取反馈实际上是非常积极的，并且能意识到他们可以依靠这些人，建立起可以互相帮助的关系。

---

### [00:08:47] Lenny

**English:**
This is so interesting and it's such a good idea and it's such a simple and good idea and I'm surprised I haven't heard of people doing this before. Basically you pair up PMs, IC PMs and maybe managers too, to give each other feedback. And is the feedback on one-pagers and PRDs and strategy docs and things like that? What sort of documents are they giving feedback on?

**中文翻译:**
这太有趣了，真是个好主意，简单又高效，我很惊讶以前没听说过有人这么做。基本上就是把 PM、个人贡献者（IC）PM，可能还有经理们配对，互相给反馈。反馈的内容是关于一页纸计划书（One-pagers）、产品需求文档（PRDs）和战略文档之类的吗？他们通常对什么样的文档给出反馈？

---

### [00:09:11] Megan Cook

**English:**
So really, it can be anything. It can be here's a new experience, [inaudible 00:09:15] launching, here's a new strategy. I've taken my own strategies in there and gotten excellent feedback, surprising feedback from the team. Can be a new experiment that people think of running and anything to do with the craft.

**中文翻译:**
实际上，任何东西都可以。可以是一个即将发布的新体验，可以是一个新战略。我曾把自己的战略带到小组里，得到了团队非常出色且令人惊喜的反馈。也可以是人们想尝试的新实验，或者任何与专业技能（Craft）相关的东西。

---

### [00:09:29] Lenny

**English:**
And I think as you kind of implied, one of the powers of this approach is it's a small team, so it's less stressful and there's no... You're not in the room often too. I guess you are sometimes as you just said, but usually it's like peers and they could be a little more open and less worried about looking back.

**中文翻译:**
我想正如你所暗示的，这种方法的力量之一在于它是一个小团队，所以压力较小，而且没有……你通常也不在场。我猜你有时会在场，就像你刚才说的，但通常都是同行，他们可以更开放一些，不用担心表现不好。

---

### [00:09:46] Megan Cook

**English:**
Yeah, absolutely. And I think a lot of it is just building that muscle. You might go through an experience once every quarter or once every six months and that can feel really stressful, but if you're doing it again and again, you get used to it. You get used to what to expect, you get a bit more practice, it can feel much more comfortable.

**中文翻译:**
是的，没错。我认为很大程度上这只是在“锻炼肌肉”。如果你每季度或每半年才经历一次评审，那会感到压力巨大；但如果你反复练习，你就会习惯它。你会习惯预期的反馈，得到更多练习，感觉也会更舒服。

---

### [00:10:04] Lenny

**English:**
That's awesome. So it's just simple and powerful idea. It's kind of like everyone's always suggesting getting a mentor, getting a coach as a PM and those are hard to find. And this is just a little informal. It's almost like a little peer group board of directors for your work. We talk about that on the podcast sometimes. So anyway, that's awesome. Really good idea and something anyone can do.

**中文翻译:**
太棒了。这真是个简单而强大的想法。就像人们总建议 PM 找个导师或教练，但那些很难找到。而这更像是一种非正式的形式，几乎就像是你工作的“同行董事会”。我们在播客中偶尔也会提到这个。总之，这主意太棒了，任何人都可以尝试。

---

### [00:10:24] Megan Cook

**English:**
Yeah, thank you.

**中文翻译:**
是的，谢谢。

---

### [00:10:26] Lenny

**English:**
Great. Okay, you have a second idea?

**中文翻译:**
太好了。那么，你有第二个点子吗？

---

### [00:10:29] Megan Cook

**English:**
Yeah. One of the other things we do is we get everyone together just like every six months. So all of the product managers get together in the same place and the idea is to have a bit of an onsite. Now we start off with just doing something fun because everybody... As you might know, Atlassian is a remote organization, so everybody works remote all the time. They can work from anywhere. And so people often, they're not used to necessarily being all together in the same place. It can take a little while to warm up. And then after that we talk about strategy. We do workshops on different elements of craft boosting that craft together. And so a similar kind of thing. People get to build relationships together. They get to see all these different ideas bouncing around which can help uplift their own ideas and help them be more innovative.
(00:11:23):
In this last one, I actually had some senior leaders from all over the organization come and share their stories of failure. So just to get everyone used to that idea that it's okay to fail and actually if the learnings are really good, maybe it should even be celebrated and it's not something to be scared of. And taking the big swing isn't a bad thing. It can be a really powerful way to learn as well.

**中文翻译:**
有的。我们做的另一件事是大约每六个月把大家聚在一起。所有的产品经理都会在同一个地方集合，进行一次实地会议（Onsite）。我们通常先从一些有趣的活动开始，因为正如你所知，Atlassian 是一个远程办公组织，大家一直都是远程工作，可以从任何地方办公。所以人们往往不习惯聚在同一个地方，需要一点时间来热身。之后我们会讨论战略，举办关于提升专业技能不同要素的工作坊。这也有类似的效果：人们可以建立关系，看到各种想法碰撞，这有助于提升他们自己的想法并变得更具创新性。
在最近的一次聚会中，我邀请了来自公司各地的资深领导来分享他们的失败故事。这是为了让大家习惯“失败是可以接受的”这一理念。事实上，如果能从中获得很好的教训，失败甚至值得庆祝，而不是让人恐惧。大胆尝试并不是坏事，它也是一种非常强大的学习方式。

---

### [00:11:50] Lenny

**English:**
I love that. We've been talking about failure a lot on this podcast, so we're super aligned with the power of that. And so just to be clear, so what you do there, is it the entire product team of Atlassian or is it just your team in this every six month?

**中文翻译:**
我喜欢这个。我们在播客里经常谈论失败，所以我们非常认同失败的力量。为了明确一下，你说的每六个月一次的聚会，是 Atlassian 的整个产品团队，还是仅仅是你的团队？

---

### [00:12:04] Megan Cook

**English:**
It's just my team and then we pull in other product managers that we work closely with as well.

**中文翻译:**
只是我的团队，然后我们也会邀请一些与我们密切合作的其他产品经理。

---

### [00:12:09] Lenny

**English:**
And then you fly them all to Australia, I imagine?

**中文翻译:**
我猜你是把他们都空运到澳大利亚？

---

### [00:12:13] Megan Cook

**English:**
Yeah, all to Sydney

**中文翻译:**
是的，都去悉尼。

---

### [00:12:15] Lenny

**English:**
To Sydney. Amazing. Okay. And I think, so the key there is it's not just like go meet each other, it's training almost on different skill sets, helping people level up in say craft or I don't know, communication or writing or something like that. And then who teaches these things? Is it like individual team members or you bring someone in?

**中文翻译:**
去悉尼，太棒了。我认为关键在于这不仅仅是见面，几乎是对不同技能组合的培训，帮助人们在专业技能、沟通或写作等方面提升。那么谁来教这些内容呢？是团队成员自己，还是请外援？

---

### [00:12:36] Megan Cook

**English:**
We have a real mix actually. So yeah, we'll bring in outside experts or we'll get... There's a lot of knowledge and a lot of skill within the team itself. So you'll have different product managers who have different strengths. We have totally different teams. So someone on a growth team, for example, might want to teach everyone about how to create great hypotheses or we'll get someone external from the team, but internal to Atlassian who has those skills who can come in.

**中文翻译:**
实际上是混合式的。我们会请外部专家，或者利用团队内部丰富的知识和技能。不同的产品经理有不同的强项。我们有完全不同的团队，比如增长团队的人可能会教大家如何创建优秀的假设，或者我们会请团队之外、但属于 Atlassian 内部的有相关技能的人来分享。

---

### [00:13:04] Lenny

**English:**
I love that also gives those PMs a chance to, one, learn the skill better themselves because they're teaching it, and also just teach and present in public speaking and all that stuff. There's all these other benefits to doing that sort of thing.

**中文翻译:**
我喜欢这种方式，因为它也给了那些 PM 机会：第一，通过教学自己能更好地掌握技能；第二，练习教学、演讲和公开表达。这样做有很多额外的好处。

---

### [00:13:16] Megan Cook

**English:**
Yeah, absolutely. And I think as a product leader, it's really important to model the behavior you want to see from your teams, whether that's getting out there teaching, presenting, explaining different concepts, explaining the business or just being vulnerable and talking about when things haven't worked out.

**中文翻译:**
是的，绝对如此。我认为作为产品领导者，以身作则非常重要，展示你希望在团队中看到的行为——无论是教学、演讲、解释概念、解释业务，还是展现脆弱的一面，谈论事情进展不顺的时候。

---

### [00:13:34] Lenny

**English:**
When we started this question, you talked about how there was kind of the shift at Atlassian where things started to feel more formal and people started to feel less open to sharing, being criticized in meetings. Just in case people might feel that might be happening in their company, do you remember roughly what size that started to happen at or signs of like, "I'm noticing people are sharing less or being more worried about talking in big meetings"?

**中文翻译:**
当我们开始这个话题时，你提到 Atlassian 曾经历过一种转变，事情开始变得更加正式，人们变得不那么愿意分享或在会议中接受批评。为了给可能在自己公司遇到类似情况的人提供参考，你还记得这种现象大概是在公司达到什么规模时开始出现的吗？或者有哪些迹象，比如“我注意到人们分享变少了，或者更担心在大规模会议上发言”？

---

### [00:14:00] Megan Cook

**English:**
Probably when we got into really different streams of work that were happening where people didn't have as much of a reason to interact with each other. So I think that was probably around, even around 15 we started to see a little bit of that.

**中文翻译:**
大概是当我们进入完全不同的工作流时，人们不再有那么多理由互相交流。我想大概是在团队规模达到 15 人左右时，我们就开始察觉到一点这种迹象了。

---

### [00:14:19] Lenny

**English:**
15 product managers?

**中文翻译:**
15 个产品经理？

---

### [00:14:20] Megan Cook

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:14:21] Lenny

**English:**
Got it. Cool. That's a good stat.

**中文翻译:**
明白了。很有参考价值的数据。

---

### [00:14:24] Megan Cook

**English:**
Yeah, you know what, I'll give one more thing that we do. So we've just started trying something new called the $10 game for priorities. And so that's where I think people might have played the $10 game for your priorities when it comes to a strategy or something like that. We started trying it out with your individual priorities. So you and your manager might come in and you can list out all of your priorities and then show you through just dividing up $10 where you're spending all of your time. And I've done this with people and we've sort of gotten down to like, "I'm putting 10 cents here this week." And I'm like, "Oh, what is that? 20 minutes, 30 minutes spending. I didn't think that's actually moving right." And so it's been great to see where people are overloaded and alignment on do my priorities stack up, but also am I spending the time on the most important things that could be moving the business forward?

**中文翻译:**
对了，我再说一件我们正在做的事。我们刚开始尝试一种新方法，叫“10 美元优先级游戏”。我想人们可能在制定战略时玩过这种分配 10 美元权重的游戏。我们开始把它应用到个人优先级上。你和你的经理坐下来，列出你所有的优先级，然后通过分配这 10 美元来展示你把时间都花在了哪里。我曾和一些人做过这个练习，结果发现有人说“这周我在这里只投了 10 美分”。我就会问：“哦，那大概只有 20 或 30 分钟？我觉得这其实没法推动进度吧。”所以，这对于发现人们是否超负荷、对齐优先级是否合理，以及观察我是否把时间花在了能推动业务发展的最重要事情上，非常有帮助。

---

### [00:15:24] Lenny

**English:**
Awesome. Okay. So you mentioned that y'all are remote. Has it been remote from the beginning?

**中文翻译:**
太棒了。你提到你们是远程办公，是从一开始就这样的吗？

---

### [00:15:31] Megan Cook

**English:**
No, not from the beginning. Actually when COVID hit, I think that was the big one.

**中文翻译:**
不，不是从一开始。实际上是新冠疫情爆发时，那是一个重大的转折点。

---

### [00:15:35] Lenny

**English:**
Okay, okay, got it. That makes sense. So a lot of companies are moving to remote work, trying to figure out how to work remotely. It seems like it's working really well for Atlassian, at least from what I can see. Is there any advice or any big lessons or tips or tricks you've learned that you could share for how to be effective working remotely, especially as a product manager? It feels like as a PM, the job has gotten so much harder having to be remote, and so yeah, I'm curious if you just have any advice you could share for people trying to make this work for their company or for themselves?

**中文翻译:**
明白了，这很合理。现在很多公司都在转向远程办公，试图摸索如何高效协作。据我所知，Atlassian 在这方面做得非常好。对于如何高效地进行远程工作，特别是作为一名产品经理，你有什么建议、教训或技巧可以分享吗？感觉作为 PM，远程办公让工作变得困难了许多。我很想知道你对那些试图在公司或个人层面实现远程办公的人有什么建议？

---

### [00:16:04] Megan Cook

**English:**
Yeah, absolutely. It's a really good question because it's not easy and we definitely went through a whole bunch of pitfalls at the beginning, but we're really firm believers that you don't need to be in the office to build world-class products. So we call our product team anywhere, and this means that anyone Atlassian can choose where they want to work every day. We think it's a bit more human, that flexibility shouldn't be a perk, that it fundamentally can change people's lives depending on what else they have on outside of work. And so we think less about where do you work and we think more about how to be productive and effective in your work.
(00:16:44):
To your point, we started doing this right when COVID hit, so it's been about three years and actually we just released a guide with our key learnings from that. It's all about a thousand days of remote work, which folks can go and find on our Work Life blog under research@atlassian.com if they want to dive in there more. But I can give you a couple of tips from that and what we found from some of our research.

**中文翻译:**
是的，绝对如此。这是一个非常好的问题，因为这确实不容易，我们一开始也踩了不少坑。但我们坚信，你不需要待在办公室里也能打造出世界级的产品。我们将我们的政策称为“随处办公”（Team Anywhere），这意味着 Atlassian 的任何员工每天都可以选择自己想在哪里工作。我们认为这更人性化，灵活性不应只是一项福利，它能从根本上改变人们的生活，取决于他们在工作之外还有什么安排。因此，我们较少关注“你在哪里工作”，而更多关注“如何让你的工作更高效、更有产出”。
正如你所说，我们从疫情开始就这样做了，至今已有大约三年。实际上，我们刚刚发布了一份指南，总结了我们的核心经验，名为《远程办公的一千天》。大家可以在我们的 Work Life 博客（research@atlassian.com）中找到。我可以先分享几个其中的技巧和我们的研究发现。

---

### [00:17:10] Lenny

**English:**
Yeah. And we'll link to that doc in the show notes.

**中文翻译:**
好的，我们会在节目介绍里附上那个文档的链接。

---

### [00:17:12] Megan Cook

**English:**
Okay, great. The first one is just making time for connection. So that human connection is definitely built in person, but what we found is that it doesn't have to be something that happens every single day. So we found the connection and productivity, they both get boosted by about 30% when you bring people together but intentionally, and it lasts them months. So we found that you can do it on average like three times a year. And so that's why my PM team are getting together every six months. But in addition to that, we get the entire team together every other six months. So we end up all getting together every four times a year.
(00:17:53):
Every other six months, what we do is we get all of the engineers, designers, everybody who's working together. We book out entire floors in the office and then for an entire week we're just there. And for some of it we're just working together as you normally would, but at desks and just having those little water cooler type conversations. It builds the relationships again. Other times we're doing workshops, an important piece of work where it's easier to do when you're all in person and sometimes we're just having fun together. We call that a bit of a festival.

**中文翻译:**
太好了。第一个建议是专门留出时间进行“连接”。人与人之间的联系确实是在面对面时建立得最牢固，但我们发现，这并不需要每天都发生。我们的研究显示，当你“有目的地”把大家聚在一起时，连接感和生产力都会提升约 30%，而且这种效果可以持续数月。我们发现平均每年聚三次就够了。这就是为什么我的 PM 团队每六个月聚一次。此外，我们每隔六个月还会让整个大团队聚一次。所以算下来，大家每年大约会见面四次。
在每隔六个月的大聚会中，我们会召集所有的工程师、设计师和所有协作人员。我们会包下办公室的整层楼，在那待上一整周。有时我们只是像往常一样坐在一起办公，进行一些“饮水机旁”的闲聊，这能重建人际关系。其他时间我们会举办工作坊，处理一些面对面更容易开展的重要工作，有时则纯粹是为了找乐子。我们称之为“节日”。

---

### [00:18:27] Lenny

**English:**
You mentioned that you measured some kind of productivity improvement. Do you happen to know how they measure that because that is really interesting?

**中文翻译:**
你提到你们衡量了某种生产力的提升。你碰巧知道他们是怎么衡量的吗？因为这真的很有趣。

---

### [00:18:35] Megan Cook

**English:**
Oh, that's a good question. I don't, but I can get that for you.

**中文翻译:**
噢，好问题。我目前不知道具体细节，但我可以帮你查一下。

---

### [00:18:40] Lenny

**English:**
That'd be cool to know. So I think we'll keep this in the podcast episode and then if there's anything in the show notes that we link to that talks about how they measure that, that'd be really interesting because that's just a cool stat to have anyway, for all kinds of other things. I'm curious how they measure that.

**中文翻译:**
那太酷了。我们会把这段保留在播客里，如果节目介绍里有相关链接解释他们是如何衡量的，那就太有意思了，因为无论如何这都是一个很酷的数据。我很想知道衡量标准。

---

### [00:18:54] Megan Cook

**English:**
Yeah, absolutely.

**中文翻译:**
是的，没问题。

---

### [00:18:56] Lenny

**English:**
Okay, cool. Any other tips?

**中文翻译:**
好的，还有其他技巧吗？

---

### [00:18:58] Megan Cook

**English:**
I think the second one is to be really intentional. I mentioned that we went through a few stumbling blocks at the start. One of those was immediately, everyone sort of filled up everybody's calendar with all of these meetings straight away. It was almost as if Lenny, if you and I were working together, I used to be able to just poke my head around my monitor and ask you something. And people were afraid that now that I can't do that, how do I get those answers? So I need more time with everybody and that definitely does not help productivity at all.
(00:19:33):
And so as PMs, we need time for creative work. We need that deep work time, and that doesn't happen when you've got all of these meetings with 30 minutes in between each of them. You need three to four hours to get that going, to get into that flow state. So my leadership team and I, we actually sync up our calendars, so we end up having these long stretches twice a week all at the same time. And so we all get a chance to do this deep work. It means we get less time for meetings, but it also means that if something comes up that's unexpected that we all need to work on together, then we've got that time there so we can be a bit more relaxed about it. We know we can get to it.

**中文翻译:**
第二个技巧是要非常有“目的性”。我提到过我们刚开始遇到了一些障碍，其中之一就是每个人都立刻把别人的日历塞满了会议。这就好像，Lenny，如果我们在一起工作，我以前只需探头绕过显示器就能问你个问题。现在大家担心做不到这一点了，于是想：“我该怎么得到答案呢？我需要更多时间开会。”但这绝对无助于提高生产力。
作为 PM，我们需要时间进行创造性工作，需要“深度工作”时间。如果你每两个会议之间只有 30 分钟空隙，你是无法进入深度工作的。你需要三到四个小时才能进入那种心流状态。所以我和我的领导团队会同步我们的日历，确保每周有两次长时间的空白段是重合的。这样我们都有机会进行深度工作。虽然这意味着开会的时间变少了，但也意味着如果出现突发状况需要大家协作，我们有预留的时间段，心态可以更放松，因为知道有时间处理。

---

### [00:20:14] Lenny

**English:**
What time of the day is that meeting?

**中文翻译:**
那个时间段通常是在一天的什么时候？

---

### [00:20:16] Megan Cook

**English:**
They're both at different times. So the first one's taking up one afternoon and the second one's taking up all of the time in the morning. Depending on what kind of person you are, one is going to see you better than the others. So we just went for one each.

**中文翻译:**
两次的时间不同。第一次占了一个下午，第二次占了整个上午。取决于你是什么类型的人，总有一个时间段会更适合你。所以我们两种都安排了。

---

### [00:20:28] Lenny

**English:**
I actually had the same thing just personally where I had these deep worked blocked times on Monday, Wednesday, and Friday. The title of the invite was, "If you book time during this, I'll slap you." And it really worked well. But I think you're talking about this other missing piece of remote work for PMs where you can't just walk by and ask an engineer, "Hey, how's it going?" Or ask a designer, "Oh, where are you at? Let me just take a peek at what you're working on." That stuff I think is really hard to replicate. And if your suggestion is block out this time for your leadership team to be able to check in with each other, is the idea there it's deep work time and don't bother anyone on the team or is it you can also just ping your end manager and like, "Hey, how's it going?"

**中文翻译:**
我个人也有类似的习惯，我会在周一、周三和周五锁定深度工作时间。邀请的标题是：“如果你在这段时间约我，我就扇你。”效果非常好。但我觉得你谈到了远程办公中 PM 缺失的另一块拼图：你不能直接走过去问工程师“嘿，进展如何？”，或者问设计师“哦，你画到哪了？让我看一眼”。这些东西很难复制。如果你的建议是为领导团队锁定这段时间以便互相沟通，那么初衷是这段时间是深度工作、不许打扰任何人，还是说你也可以随时发消息问经理“进展如何”？

---

### [00:21:09] Megan Cook

**English:**
The idea is that it's deep work time and it's your time to be protected to do that work. What I found that works really well, I think in the manager and report kind of relationship, so I have these really quick punchy one-on-ones with my reports every week. And then I make sure that I've got space in my calendar because something will come up where even if we had a longer one-on-one that might not cover it. They might just need an hour to run through something, there might be a really difficult strategy problem they've run into. And so they'll know that they can ping me for more time and I'll have that flex in my calendar for that.

**中文翻译:**
初衷是这是深度工作时间，是受保护的、让你完成工作的时间。我发现对于经理和下属的关系，非常有效的方法是：我每周会和下属进行非常简短、高效的 1 对 1 会议。然后我会确保日历中有余量，因为总会有突发情况，即使是长时间的 1 对 1 也未必能覆盖。他们可能需要一个小时来梳理某件事，或者遇到了棘手的战略问题。他们知道可以随时找我多要点时间，而我的日历里有这种灵活性。

---

### [00:21:49] Lenny

**English:**
Awesome. Any other tips along those lines?

**中文翻译:**
太棒了。还有其他类似的建议吗？

---

### [00:21:52] Megan Cook

**English:**
Well, you probably noticed about blocking a bunch of deep work time is that you don't have as much time for meetings. So that meeting time becomes really precious. And what we do there is... I personally hate having status updates as a meeting. So I make it really clear that if we're having a meeting, this is to solve a problem. And if it's just a status update, that's fine, then I can read that asynchronously at a time that works for me. And so can everybody else in the team if they want to do that. Actually we use our own tool for this, which makes it really easy. So it's called Atlas and it lets you or the team put in status updates for a goal or a project regularly and then it'll bundle it all up into an email so you can quickly get across everything that you're interested in, which has been really helpful.
(00:22:40):
And then that just makes the documentation rigorous as well. So you document things and we use Confluence, but all of our decisions, strategies, kickoffs for projects, that's all really well documented piny starters. Or even if you're a year down the line and you're thinking, "Why didn't we come to that decision in the first place? What were our assumptions? What were our hypotheses?" It's easy to go back and take a look at that and be able to reflect.
(00:23:11):
I think the last thing is I work with people who are in the US, they're in Europe, they're all over the world. It's really hard to find a time that works for an Aussie, an American and a European to get together. Someone's waking up at 3:00 AM or something. So what's become a big part of how we work is actually audio and video recordings. I actually had someone reporting to me for a while who was in France and what we would do was record videos back and forth and they're quick. You can just use colloquial language, they're really casual, you don't have to wonder about someone's tone that comes across. So that's becoming almost like a completely new document type for us and it's been really important in remote work. You can put at the top of a document and explain the document, which is really nice. It's a big part of why we bought Loom.

**中文翻译:**
你可能注意到了，锁定大量深度工作时间意味着开会的时间变少了。所以会议时间变得非常珍贵。我们的做法是……我个人非常讨厌把“进度更新”当作会议。我会明确规定，如果我们开会，那是为了解决问题。如果只是进度更新，没问题，我可以异步阅读，在适合我的时间看。团队里的其他人也可以这样做。实际上我们使用自家的工具 Atlas 来做这件事，它非常方便，让团队定期输入目标或项目的进度，然后汇总成一封邮件，让你快速掌握感兴趣的所有内容，这非常有帮助。
这也让文档记录变得更加严谨。我们使用 Confluence 记录所有决策、战略和项目启动。即使一年后你回想：“当初为什么做那个决定？我们的假设是什么？”你也可以轻松回溯并反思。
最后一点是，我的同事遍布美国、欧洲和世界各地。很难找到一个让澳大利亚人、美国人和欧洲人都方便的时间，总有人要在凌晨 3 点起床。所以，音视频录制成了我们工作的重要组成部分。我曾有一个下属在法国，我们会互相录视频沟通，非常快。你可以使用口语化的语言，很随意，也不用揣摩对方的语气。这几乎成了我们的一种新文档类型，在远程办公中至关重要。你可以在文档顶部放个视频解释文档内容，这非常棒。这也是我们收购 Loom 的重要原因。

---

### [00:24:06] Lenny

**English:**
I was just going to say that. It all makes sense.

**中文翻译:**
我正想说这个。这完全说得通。

---

### [00:24:09] Megan Cook

**English:**
Yeah, because it was just becoming such a big part of our life and it's just massively helpful.

**中文翻译:**
是的，因为它已经成为我们生活的重要组成部分，而且非常有帮助。

---

### [00:24:16] Lenny

**English:**
Kind of along the same lines, being fully remote, it is harder to get buy-in on things you're working on I imagine. And something I hear you're great at is getting buy-in, especially getting buy-in on ideas and projects from executives. So I think things that make it extra challenging at Atlassian, there's two CEOs which I didn't know until recently. You're also all very remote and so maybe those two reasons make it extra hard. Plus it's just generally hard to get buy-in on projects that you're working on. What advice do you share with product leaders, PMs that come to you asking for advice on how to get better at getting buy-in for your ideas?

**中文翻译:**
顺着这个思路，我猜在完全远程的环境下，让你正在做的事情获得认可（Buy-in）会更难。我听说你非常擅长获得认可，尤其是从高管那里获得对想法和项目的支持。在 Atlassian，这可能更具挑战性，因为你们有两个 CEO（我最近才知道），而且你们又是全远程办公。除了这些，获得项目认可本身就很难。对于那些向你请教如何更好地获得想法认可的产品领导者和 PM，你会分享什么建议？

---

### [00:24:56] Megan Cook

**English:**
Yeah, this can be really hard to get right. I watch a lot of people struggle with this, and you're right, being fully remote can make it a bit more challenging. And then I think also you've got your cross-functional partners that you're working with as this tight-knit team and how do you form that relationship? But I'll start with just general buy-in.
(00:25:17):
Most of the time when people come to me and they want to ask how to get by-in, they've got a date in mind, they've got a particular meeting and they have this idea where they're going to crop this perfect proposal, they're going to present it, everyone's going to give them thumbs up and they win. And that's the wrong attitude I think even to start with to getting buy-in. It's more of a journey.
(00:25:40):
I'll give you an example where I was looking at how do people start their day in Jira and how do people get started in Jira? And we had this idea of we could craft more templates so that we could give people a better way to start with very different use cases when they came into the product. And this could change everything from even just the front homepage where they started all the way to what's happening in product. It would create this really nice flow.
(00:26:12):
Jira is also a platform as well as just Jira software the product. There's actually four different products built on top of it. So when you want to go and change something like that, you're actually changing it for all of these different products. It's not just the one. And so what was really important there was partnering with a whole bunch of different stakeholders. So every product that this could potentially negatively or positively impact, we went to very early with the idea and the proposal and we got their feedback and then we came to them and again and again as we developed it further. So as we got designs, as we got more data, as we tested things out with users, we kept coming back and we take their feedback on board.
(00:26:54):
And so I think creating those partnerships is really important. And also the same can be true at the executive level. So often you go into these meetings where you're giving a proposal and you're trying to get that final yes on the decision. You've got a lot of people in there with a lot of different angles that they can look at that problem and so much good experience to draw on. So your CTO is going to have a totally different way of looking at something and different concerns from your chief marketing officer to your head of design. They're all going to look at things differently and be thinking about it differently. And so if you know that you're going to be having a big impact in someone's space and you want to hear from them, it's good to set that meeting up early when you've got some clarity but it's not fully fleshed out and so that you can fold in some of their concerns because they'll have this much broader view. And that also creates people who will be an advocate for you once you get into that room, that final meeting.
(00:27:50):
So I think all of those in the lead up, there's a lot of lead up work to getting buy-in that makes sure that you have a good time in that meeting.

**中文翻译:**
是的，这确实很难做对。我看到很多人为此挣扎。你说的没错，全远程确实增加了难度。此外，你还有跨职能的合作伙伴，你们是一个紧密的团队，如何建立这种关系也很关键。但我先从通用的“认可”谈起。
大多数时候，当人们来问我如何获得认可时，他们心里想的是某个特定的日期、某场特定的会议。他们觉得只要准备一份完美的提案，当众演示，然后每个人都竖起大拇指，他们就赢了。我认为这种心态从一开始就错了。获得认可更像是一场“旅程”。
举个例子，我曾研究人们如何开始使用 Jira。我们当时想，可以制作更多模板，让用户在进入产品时能根据不同的使用场景有更好的起始体验。这会改变从首页到产品内部的一切，创造出非常顺滑的流程。
但 Jira 不仅仅是 Jira Software 这个产品，它还是一个平台，上面构建了四个不同的产品。所以当你想要改变这类东西时，你实际上是在改变所有这些不同的产品。因此，与大量不同的利益相关者合作至关重要。对于每一个可能受到正面或负面影响的产品，我们都在非常早期就带着想法和提案去找他们，获取反馈。随着开发的深入，我们一次又一次地去找他们——有了设计稿、有了更多数据、有了用户测试结果，我们不断回来听取并采纳他们的意见。
我认为建立这种伙伴关系非常重要。在高管层面也是如此。通常你参加会议提交提案是为了获得最终决策。会议室里有很多人，他们会从不同的角度看待问题，并且有丰富的经验。CTO 的看法和担忧会与首席营销官或设计负责人完全不同。如果你知道你的方案会对某个人的领域产生重大影响，最好在方案还没完全成型、但已有初步轮廓时就早点约他们开会，听取他们的意见，把他们的担忧融入方案中。这样，当你进入最终决策会议时，这些人就会成为你的支持者。
所以，获得认可需要大量的铺垫工作，这能确保你在最终会议上进展顺利。

---

### [00:28:00] Lenny

**English:**
Just to maybe summarize so far, which you've shared, one is just... Basically it's lieu people in early, especially the person that it's going to impact most.

**中文翻译:**
总结一下你目前分享的内容，第一点就是……基本上是尽早让相关人员参与进来，尤其是那些受影响最大的人。

---

### [00:28:08] Megan Cook

**English:**
I think in addition to that is having that mindset of being open to not necessarily coming up with the right solution, it's more about solving for the problem or the opportunity. So you want to be clear about your hypotheses and what are your facts and what are the principles you're using to make a decision and just be open to not necessarily ending up with the solution you thought would be best.

**中文翻译:**
除此之外，还要保持开放的心态，不一定非要一开始就拿出“正确”的解决方案，更多的是为了解决问题或抓住机会。所以你要明确你的假设是什么，事实是什么，以及你做决策的原则是什么。要保持开放，接受最终方案可能不是你最初认为最好的那个。

---

### [00:28:34] Lenny

**English:**
I imagine most people think they are always in that state, "I am very open to feedback. I am totally open-minded, but really they're not." Is there anything that you think would either convince someone you're actually not as open-minded as you seem or any advice for how to come across as more open-minded? Or is there anything that you see... I see this all the time. People think they're listening, but they're not. You should change.

**中文翻译:**
我猜大多数人都觉得自己一直处于这种状态：“我非常乐意听取反馈，我心态完全开放。”但实际上并非如此。你觉得有什么办法能让某人意识到自己其实没那么开放吗？或者有什么建议能让人表现得更开放？我经常看到这种情况：人们以为自己在听，其实根本没听进去。

---

### [00:28:56] Megan Cook

**English:**
I think one way to force yourself into that situation is to be clear about the hypotheses you have and the facts. So I think often people can present as, "This is absolutely the case. This is what I know, and this is obviously the correct response to the situation." Where most of the time you've got a good set of data, you've got a good understanding with your knowledge of the space, but what is actually going to happen is a hypothesis. There's always going to be something you don't know and oftentimes you don't know until you ship it. That is absolutely the best test of whether or not what you thought was going to happen will actually happen.
(00:29:41):
And so I think when you come to the meeting going, okay, here's the top-back so we actually know, and here's the hypotheses and here's my plan to prove or disprove them, then you're exposing your idea for people to go, oh, here's more that I know about that hypotheses, or here's some data that you don't have or here's another way to think about it. I think people can feel like they're not going to be credible. That you have to come in, you have to come in confident, you have to come in knowing exactly what that solution is going to be. But I usually find that if you come in there open and you're exposed, you're thinking and where you could use some help on perspectives, that actually that builds more credibility because everyone knows that you are not going to have all the answers and you're not going to be able to see the future. And so that can really help in building people's trust in you and that you know what you're doing.

**中文翻译:**
我认为强迫自己进入这种状态的一个方法是：明确区分你的“假设”和“事实”。人们经常表现得像是：“情况绝对是这样的，这是我所知道的，这显然是正确的应对方案。”但大多数时候，虽然你有数据，有对领域的理解，但“实际会发生什么”仍然只是一个假设。总会有你不知道的事情，而且通常只有在产品上线后你才会知道。上线才是检验你预想是否成真的终极测试。
所以，如果你在会议上说：“好的，这是我们确切知道的事实，这是我们的假设，这是我证明或证伪这些假设的计划。”那么你就是在把你的想法摊开，让别人参与进来：“哦，关于那个假设，我还知道更多信息”，或者“这里有一些你没有的数据”，或者“还有另一种思考方式”。人们有时觉得必须表现得非常自信、必须确切知道解决方案才有公信力。但我发现，如果你表现得开放，展示你的思考过程，并说明你在哪些视角上需要帮助，反而能建立更多公信力。因为大家都知道你不可能拥有所有答案，也不可能预见未来。这能帮助人们建立对你的信任，相信你确实知道自己在做什么。

---

### [00:30:34] Lenny

**English:**
Is there an example of that that comes to mind to make it even more real of either someone on your team doing that or you doing that? Because I think it's still going to be hard for people to realize, "Hey, I'm not actually paying attention to anyone and I just want to convince them this idea is right. This is what we're doing. Just come on, get out of my way. Give me the okay."

**中文翻译:**
你能想到一个具体的例子吗？无论是你团队的人还是你自己。因为我觉得人们还是很难意识到：“嘿，我其实根本没在听别人的，我只是想说服他们我的想法是对的。我们就这么干，别挡我的路，快给我通过。”

---

### [00:30:51] Megan Cook

**English:**
An example from my past is there was this potential acquisition that we could have made, and I was really, really keen on it because it would mean adding a whole bunch of much needed capability really quickly to the product. And I just loved that momentum and I didn't see any other way that we could do this. I'd looked at a bunch of other options about building it in-house and it just didn't seem possible. And there were a few people that I needed to convince, my boss, but also the head of engineering for the area. And when I took it to them, what I learned was the head of engineering was able to pull a bunch of people from other areas within the company to come and bolster this effort and who had all of the knowledge that we needed. So what seemed like the impossible task, he actually had this extra knowledge to make possible.
(00:31:45):
And in the end, acquisition or not, that doesn't really matter. It's more about being able to get that value back to our customers. That's what we're solving for. And so it was really about coming back, not falling in love with that solution and that other company, it was just taking a step back and going, "Okay, well, really it's just what are we here to do? What's the real goal at the end of the day?"

**中文翻译:**
我过去的一个例子是关于一次潜在的收购。我当时非常想促成它，因为这意味着能快速为产品增加大量急需的功能。我非常喜欢那种势头，觉得没有别的办法能做到这一点。我研究过内部开发的方案，但看起来根本不可能。我需要说服几个人，包括我的老板和该领域的工程负责人。当我去找他们时，我发现工程负责人能够从公司其他部门抽调一批拥有所需知识的人来支持这项工作。所以，那个看起来不可能完成的任务，他其实有办法让它变得可能。
最终，是否收购并不重要，重要的是能为客户提供价值。这才是我们要解决的问题。所以关键在于回归初心，不要爱上某个特定的解决方案或那家公司，而是退后一步想：“好吧，我们在这里到底是要做什么？最终的真实目标是什么？”

---

### [00:32:11] Lenny

**English:**
Awesome. Okay. Is there anything else you wanted to share along these lines before I move on to a different topic?

**中文翻译:**
太棒了。在我转入下一个话题之前，关于这方面你还有什么想分享的吗？

---

### [00:32:16] Megan Cook

**English:**
The other thing I would say is that setting up the meeting when you finally get there can be really important as well. I often see people go in there and they've got a big document or a presentation or something and they just launch into it. They're really excited. But actually you want to take a step back and you want to be really clear on what are you looking for from that group. You can ask for the decision, you can ask for feedback, you can ask for... You can expose where you're not quite sure about something and you want them to be thinking about that angle in particular and helping test that hypothesis with what they know. And so setting that early, you can put that in people's heads as they read through your document or listen to the rest of the proposal.
(00:33:02):
Then I find it's really useful to have a narrative that just encompasses everything that you're going to talk about. So just really brief, what's the current situation, what has changed and what are the implications that you now want to... We mean we have a problem to solve and an opportunity that we can go after.
(00:33:21):
And the last thing is just making sure you've got your data. There's executives, there's people in the meeting. They're usually across a whole ton of stuff just hearing about... Maybe they've got 10 proposals a day and they're across all different areas in the business, and so they're not going to have the detail that you do. So being really thoughtful about what you bring, what are the key points that are going to help them understand the situation as clearly as possible. But then really knowing your data so that you can dive in more detail where they need it. And that also helps build your credibility and builds people's confidence in the plan to go ahead.

**中文翻译:**
我想说的另一件事是，当你最终进入会议时，如何开场也非常重要。我经常看到人们带着厚厚的文档或 PPT 冲进去，非常兴奋地开始讲解。但实际上，你应该退后一步，明确告诉大家你希望从这个群体中得到什么。你是想要一个决策？还是想要反馈？或者你可以坦白你对某些地方不确定，希望他们特别关注那个角度，并用他们的知识来测试那个假设。尽早设定目标，这样当他们阅读文档或听提案时，心里就会有数。
此外，我发现建立一个涵盖所有内容的“叙事框架”非常有用。简要说明：现状是什么，发生了什么变化，以及这意味着什么——即我们要解决的问题和可以追求的机会。
最后一点是确保你有数据支持。参加会议的高管们通常要处理海量事务，一天可能要听 10 个提案，涉及业务的各个领域，所以他们不会像你一样了解细节。因此，要仔细挑选你展示的内容，突出能帮助他们最清晰理解情况的关键点。同时，你要对数据了如指掌，以便在他们需要时深入细节。这也有助于建立你的公信力，增强大家对计划可行性的信心。

---

### [00:34:05] Lenny

**English:**
Would you mind just quickly summarizing these pieces of advice and then I was going to move on to another area of strength of yours that I hear?

**中文翻译:**
你介意快速总结一下这些建议吗？然后我打算转向我听说的你的另一个强项。

---

### [00:34:13] Megan Cook

**English:**
Yeah, sure. So the first one is to find people who are affected negatively or positively or might have a really good point of view and partner with them as you develop the solution or the response to the current situation. And the second one is to come at it with this mindset of being open, of being really key on what is the core problem or the value that you want to deliver, and just being open to how you get there and things that you don't know which might adjust along the way. And the last one is just setting up the meeting walls. So coming in, making sure that it's very clear what you need. Do you need a decision or something like that? And making sure that you've got very good supporting data to build that credibility with your audience.

**中文翻译:**
好的。第一，找到那些会受到正面或负面影响、或者有独到见解的人，在开发方案或应对现状的过程中与他们建立伙伴关系。第二，保持开放的心态，专注于核心问题或你想交付的价值，对于实现路径和未知因素保持灵活，允许在过程中进行调整。最后，开好会议：明确你的诉求（比如是否需要决策），并准备好强有力的数据支持，以建立听众对你的信任。

---

### [00:35:03] Lenny

**English:**
Love it. This is where the term or the cliche of product managers asking, "But what problem are we trying to solve," comes from. But it comes from a really important place of always focusing on let's all align on here's the problem we're solving. Because oftentimes as you chatted about, the biggest disagreements come from people just thinking they're solving different problems. And on that note, I have a Swag Store now, lennyswag.com, and we have stickers on there, a bunch of cliche PM terms including, "But what problem are we trying to solve?" And so I think that's... But it's rooted in, that's actually a really important question to ask. Sometimes you get annoying.

**中文翻译:**
太棒了。这就是产品经理那个老掉牙的口头禅——“但我们要解决的问题到底是什么？”的由来。它源于一个非常重要的出发点：确保大家对要解决的问题达成共识。因为正如你所说，最大的分歧往往源于大家以为在解决不同的问题。顺便提一下，我现在有个周边商店 lennyswag.com，上面有各种 PM 口头禅贴纸，其中就有“但我们要解决的问题到底是什么？”。虽然有时这问法挺烦人的，但它确实根植于一个非常重要的问题。

---

### [00:35:38] Megan Cook

**English:**
Yeah, that's such a good sticker to have front and center.

**中文翻译:**
是的，那张贴纸确实应该贴在最显眼的地方。

---

### [00:35:42] Lenny

**English:**
Just need that as a big sign. Maybe the sticker needs to be bigger.

**中文翻译:**
需要把它做成一个大招牌。也许贴纸应该再大一点。

---

### [00:35:44] Megan Cook

**English:**
Exactly.

**中文翻译:**
没错。

---

### [00:35:48] Lenny (Sponsor: Vanta)

**English:**
This episode is brought to you by Vanta, helping you streamline your security compliance to accelerate your growth. Thousands of fast-growing companies like Gusto, Qom, Quora, and Modern Treasury trust Vanta to help build, scale, manage, and demonstrate their security and compliance programs and get ready for audits in weeks, not months. By offering the most in-demand security and privacy frameworks such as SOC 2, ISO 27001, GDPR, HIPAA, and many more, Vanta helps companies obtain the reports they need to accelerate growth, build efficient compliance processes, mitigate risks to their businesses, and build trust with external stakeholders.
(00:36:24):
Over 5,000 fast-growing companies use Vanta to automate up to 90% of the work involved with SOC 2 and these other frameworks. For a limited time, Lenny's Podcast listeners get $1,000 off Vanta. Go to vanta.com/lenny, that's V-A-N-T-A.com/lenny, to learn more and to claim your discounts. Get started today.

**中文翻译:**
本期节目由 Vanta 赞助。Vanta 帮助你简化安全合规流程，加速业务增长。数千家快速成长的公司，如 Gusto、Qom、Quora 和 Modern Treasury，都信任 Vanta 来帮助构建、扩展、管理和展示其安全合规计划，并在数周而非数月内准备好审计。通过提供最热门的安全和隐私框架，如 SOC 2、ISO 27001、GDPR、HIPAA 等，Vanta 帮助公司获得加速增长所需的报告，建立高效的合规流程，降低业务风险，并与外部利益相关者建立信任。超过 5000 家快速成长的公司使用 Vanta 自动化处理 SOC 2 等框架中高达 90% 的工作。限时优惠，Lenny's Podcast 的听众可享受 Vanta 1000 美元的折扣。访问 vanta.com/lenny 了解更多并领取折扣。今天就开始吧。

---

### [00:36:45] Lenny

**English:**
Okay, something else that I hear you're incredibly good at, and it's actually related to all of these things we've been talking about, is the way someone described you is you're really good at fighting the good fight, which essentially is just doing the things that need to be done that aren't necessarily popular or that people are prioritizing right now. I hear that you led to a big investment in CSAT at Atlassian because you just felt like this was the right way of doing it. And there's a few other projects that came out of just like, "I'm just going to do the thing that needs to be done." Can you just talk about why that's important to you, what impact that sort of had, and then just how you actually successfully do that? Obviously it ties into this skill of getting buy-in on stuff.

**中文翻译:**
好的，我还听说你非常擅长另一件事，这实际上与我们刚才谈论的所有内容都有关。有人形容你非常擅长“打一场漂亮的仗”（Fighting the good fight），本质上就是去做那些虽然不一定受欢迎、或者目前大家没放在优先级上、但确实需要做的事情。我听说你促成了 Atlassian 在 CSAT（客户满意度）上的巨大投入，因为你觉得这是正确的事。还有其他几个项目也是源于这种“我就是要去做该做的事”的态度。你能谈谈为什么这对你很重要，产生了什么影响，以及你具体是如何成功做到的吗？显然，这与获得认可的技巧有关。

---

### [00:37:24] Megan Cook

**English:**
I think that's a really good example actually, the CSAT example, because sometimes you can get caught up in let's add value, add value, add value to the product, but if the customer aren't satisfied with what you built, or in our case we found that one of the core reasons was the usability, it wasn't where it needed to be. Then we can't access that value anyway. It doesn't matter. And sometimes it can be hard to get investment for things like that because it's not like the shiny, exciting new thing. It's no, I want to work on the features we already have and improve those. So it was about two years ago, our chief experience officer, he cared really deeply about improving our CSAT scores and asked me to look into it. And this-

**中文翻译:**
我认为 CSAT 的例子确实很典型。因为有时你会陷入“不断为产品增加价值、增加价值”的怪圈，但如果客户对你构建的东西不满意，或者像我们发现的那样，核心原因之一是易用性（Usability）达不到要求，那么客户根本无法获得那些价值。这很重要。但有时很难为这类事情争取到投资，因为它不像那些闪亮、令人兴奋的新功能。它更像是：“不，我想优化现有的功能。”大约两年前，我们的首席体验官非常关注提升 CSAT 分数，并让我去研究一下。

---

### [00:38:12] Lenny

**English:**
Briefly explain CSAT real quick. Some people may not be familiar with that term.

**中文翻译:**
快速解释一下 CSAT，有些人可能不熟悉这个词。

---

### [00:38:17] Megan Cook

**English:**
Oh yeah, yeah, absolutely. Of course. CSAT means customer satisfaction. So for us, we actually have a survey so that we can measure CSAT and it just asks customers to rate how satisfied they are with the product and then different aspects so we can see for different tasks that they need to perform or different aspects of it, like the reliability or the speed or the usability. How do customers feel about that?

**中文翻译:**
噢，好的。CSAT 代表客户满意度（Customer Satisfaction）。我们通过调查来衡量它，让客户对产品的满意度以及不同维度进行评分，比如他们需要执行的任务、可靠性、速度或易用性。看看客户对这些方面的真实感受。

---

### [00:38:48] Lenny

**English:**
We actually had a podcast episode recently Judd, where we talking about NPS and how much there's data showing it's not actually a great predictor of anything, and he's a big fan of CSAT instead. So you could almost think of it as little replacement for NPS in a lot of cases. And I'm sorry, pushed you off track. Keep going.

**中文翻译:**
我们最近的一期播客里，Judd 谈到了 NPS（净推荐值），并指出数据表明它其实不能很好地预测任何事情，他更推崇 CSAT。所以在很多情况下，你可以把它看作是 NPS 的替代品。抱歉打断你了，请继续。

---

### [00:39:05] Megan Cook

**English:**
Yeah, no worries. So he cared really deeply about this, asked me to look into it. Even though this request was coming from the top, that doesn't mean that it gets any sort of funding. So we went through a couple of different steps to see what was worth investing in here. First of all, I mentioned we had that survey and so we had really rich feedback. So it's not just a rating, what we get, we get people talking about why they gave that rating and that can really help us zero in on what are the key aspects that's bringing this down. And we also had great conversations with our customers. It was the kinds of conversations that are really rich and really helpful, but so painful to listen to and go through because you're seeing somebody really struggle with something that you thought was going to bring them so much value.
(00:39:58):
And then we had a look at, well, what is this going to impact? And so logically it's what we found was that usability was one of the key reasons, like I said. And logically, if your product is hard to use in places, if some of the core actions are hard for people to do, then a new user to that product or a new customer is going to have a longer ramp up time. You've got a harder time showing them that there's value. And even for an existing customer that's using your product really well, when they bring on a new user, that user might have a really hard time getting up to speed and using it and it just completely slows them down. So from a business point of view, it can impact your new customer acquisition as well as your ability to expand. So there was some good revenue connections in there as well.
(00:40:52):
What I also found was that we have a lot of dependencies. So we've got all of these platform teams and a lot of the improvements that would be really good to make to sort out this problem depended on many, many teams around Atlassian. And they all had different goals and other products that they had to serve too. I don't know if you've ever tried to align three or four different roadmaps so that the timing is just right to get some improvement through, but it's basically impossible. There was no way that was going to happen. But we did find that they were really passionate about this area and improving usability. So we worked together to find a low cost way for those teams to help us make the changes that we need to, but they didn't have to bear the brunt of all the development costs.
(00:41:39):
So each of those teams flipped forward, we call them a shepherd, so that as our developers came in and made changes in the code base that this shepherd would make sure that they weren't causing any issues and we're doing reviews and reviews of designs and things like that. And so getting that buy-in, finding the data to support the reason why this was important. And then we constructed the roadmap so that we found this sort of a low cost, very cheap way to have some impactful change early on. I think that was really, really important. And so we put together just some of the designs for what the experiences were going to look like.
(00:42:24):
So our head of design, Charlie Sutton at the moment has this great mantra of show don't tell. And in this case, it was just at the core of getting people excited because you could show the initial experience, you could show the pain, you could bring in a video of the customer trying to use it and what they thought of it. And that just really brought that emotional aspect to it. It helped get people on board on the issue, the new experience, which is just far and away molds better, might cut out like 20 clicks or whatever. And so all that worked together to get the investment that we needed.
(00:43:04):
I think the last thing that was useful there actually is that we started pretty small too. So I think if you have a hypothesis and you can start small, you can get that investment more easily, you can show success, you can always build on that in the future to get more and more. But in this case, we got about 40 people to come and join onto this. And then as we shipped things, we just made sure that it kept being quite small. And so we got that momentum really quickly. We kept with regular updates, we kept up the excitement about what the team was doing.
(00:43:38):
At one stage, the team picked out something that was pretty impactful throughout the whole thing. So that was dark mode. That took a lot of coordination around the whole company to make that thing happen. But it was well overdue, we loved it. And then the feedback that we got as well really helps with that. Actually just yesterday, I saw some feedback on one of the changes we'd made recently, and this customer said it was the best quality of life improvement they've seen in a long time, which just the way that's phrased even, that gets you excited about the impact that you're having on that person.

**中文翻译:**
没关系。所以他非常看重这件事，让我去研究。即使这个请求来自高层，也不意味着它能自动获得资金。所以我们分几步来看这里是否值得投资。首先，我提到过我们有调查，所以有非常丰富的反馈。不仅仅是评分，我们还能看到人们解释为什么给这个分，这能帮我们锁定导致分数下降的关键因素。我们还与客户进行了深入交流。这些对话内容丰富且有帮助，但听起来却很痛苦，因为你看到有人在你认为能带来巨大价值的功能上苦苦挣扎。
然后我们分析了这会产生什么影响。逻辑上，我们发现易用性是关键原因。如果你的产品在某些地方很难用，核心操作很难完成，那么新用户的上手时间（Ramp-up time）就会变长，你很难向他们展示价值。即使是使用得很好的老客户，当他们引入新成员时，新成员可能很难上手，这会拖慢整个团队。所以从业务角度看，这会影响新客户获取和业务扩张能力。这里面有很强的营收关联。
我还发现我们有很多依赖项。Atlassian 有很多平台团队，解决这个问题所需的许多改进都依赖于公司内部的许多团队。而这些团队都有自己的目标和要服务的其他产品。如果你尝试过对齐三四个不同的路线图（Roadmap）以确保时机刚好能推行某项改进，你就会知道这基本上是不可能的。但我们发现他们对提升易用性其实很有热情。于是我们合作找到了一种低成本的方式：让这些团队协助我们做出改变，但他们不必承担所有的开发成本。
每个团队都派出一名“守护者”（Shepherd）。当我们的开发人员进入他们的代码库进行修改时，这位“守护者”会确保没有引发问题，并进行设计评审等。通过这种方式，我们获得了认可，找到了支持理由的数据，并构建了一个路线图，以一种非常廉价、低成本的方式在早期实现了有影响力的改变。我认为这非常重要。我们展示了一些新体验的设计稿。
我们当时的设计负责人 Charlie Sutton 有句名言：“展示，不要只说”（Show don't tell）。在这种情况下，这是让大家兴奋的核心。你可以展示最初的体验，展示那种痛苦，放一段客户挣扎使用的视频。这带来了情感上的冲击，让大家意识到问题的严重性。而新体验明显好得多，可能减少了 20 次点击。所有这些努力共同促成了我们所需的投资。
最后一点很有用的是，我们是从小规模开始的。如果你有一个假设，从小处着手更容易获得投资，展示成功后，未来可以不断扩大规模。在这个案例中，我们召集了大约 40 人加入。随着产品的发布，我们确保规模保持精简，从而快速获得了动力。我们保持定期更新，让大家对团队的工作保持兴奋。
中途，团队挑选了一个非常有影响力的点：深色模式（Dark Mode）。这需要全公司的协调才能实现，但它早就该出了，大家都很喜欢。我们收到的反馈也很有帮助。就在昨天，我看到一条关于我们最近改进的反馈，客户说这是他们很长时间以来见过的“最好的生活质量提升”（Quality of life improvement）。这种表达方式让你对给用户带来的影响感到非常兴奋。

---

### [00:44:20] Lenny

**English:**
And this was the CSAT work or the dark mode?

**中文翻译:**
这是 CSAT 的工作还是深色模式的工作？

---

### [00:44:24] Megan Cook

**English:**
This was CSAT work. This was improving one of the processes.

**中文翻译:**
是 CSAT 的工作，是改进其中一个流程。

---

### [00:44:28] Lenny

**English:**
Okay, cool. That's amazing. There's a lot of stuff I love about this story. One is just the power of just empowering yourself to do things that you believe need to be done. There's a lot of PMs and just people in general that just assume they don't have any power and the square peg they're in is just all they're going to be able to do and nobody's going to allow them to do things that they believe are important and no one else agrees with. So I think there's just a lot of power in just understanding that you have more power and leverage and agency than you probably think you do, but then you also have to do it well. So I took a bunch of notes as you were talking of the things that I think are core to getting stuff like this done, just a scrappy project that you're kind of doing on your own without a lot of buy-in from the top initially.
(00:45:14):
So I want to stay small. Two is make it visual and visceral so you can like, "Oh wow, I could see this being amazing," and getting people excited as you go. Making it really easy for people I think is a really interesting takeaway there. Just like, "We did all the work for you already for these other teams, it's going to be so easy. It's not going to be a lot of work for you." And then showed the data like, "Here's what we've gotten from CSAT so far, here's the impact you'll probably get from it. Here's how much work it'll take." Show actual data. And then keep it scrappy. It feels like a lot of this is just like stay small, keep it scrappy, don't ask for a lot of resources initially and just kind of show momentum.

**中文翻译:**
太棒了。这个故事里有很多我喜欢的地方。首先是赋予自己权力的力量，去做你认为该做的事。很多 PM 或职场人总觉得自己没权力，只能在既定的框框里打转，认为没人会允许他们做那些虽然重要但别人不认同的事。所以，意识到你拥有的权力、杠杆和自主权比你想象的要多，这本身就很有力量，当然你还得把它做好。在你说话时我记了一些笔记，我认为这些是完成这类“草根项目”（最初没有高层支持、靠自己推动的项目）的核心要素：
第一，保持小规模。第二，使其视觉化、直观化，让人感叹“哇，这看起来太棒了”，从而调动大家的积极性。第三，让别人的参与变得极其简单，这是一个很有趣的切入点，比如告诉其他团队：“我们已经帮你们把活儿都干了，对你们来说非常简单，不会增加负担。”第四，展示数据，比如：“这是目前的 CSAT 情况，这是预期的影响，这是所需的工作量。”用真实数据说话。最后，保持“草根”本色。感觉很多时候就是要从小处着手，保持灵活，最初不要索要太多资源，重点是展示势头。

---

### [00:45:50] Megan Cook

**English:**
I think that's really important. When you keep it scrappy and small in the beginning, it doesn't feel like it's as big of a bet, but that gives you the opportunity to really prove that the direction that you're going in could pay off. And so it's sort of like this little inroad to getting more investment.

**中文翻译:**
我认为这非常重要。当你开始时保持灵活和小规模，这看起来就不像是一场豪赌，但这给了你机会去证明你的方向是能带来回报的。这就像是通往获得更多投资的一条小径。

---

### [00:46:07] Lenny

**English:**
Awesome. Okay. I want to move to a different topic around Atlassian as a company, but is there anything else you wanted to share along these lines before we do that?

**中文翻译:**
太棒了。我想转向关于 Atlassian 公司的另一个话题，但在那之前，关于这方面你还有什么想分享的吗？

---

### [00:46:15] Megan Cook

**English:**
No, let's go for it.

**中文翻译:**
没有了，开始吧。

---

### [00:46:17] Lenny

**English:**
Okay. One of the most interesting things about Atlassian to me is it's a great example of a company that's been able to launch new product lines. This is the dream of every software company business in general is you start with one product that gets to a certain point and then you hit some kind of plateau, and then you add an additional business product line, and then you add more and more. Somewhere around Atlassian's 15 products. Is that an accurate number?

**中文翻译:**
好的。对我来说，Atlassian 最有趣的一点是，它是成功推出新产品线的典范。这是每家软件公司甚至所有企业的梦想：从一个产品开始，达到一定规模后遇到瓶颈，然后增加第二个产品线，接着越来越多。Atlassian 现在大约有 15 个产品，这个数字准确吗？

---

### [00:46:43] Megan Cook

**English:**
Yeah, that's right. Yeah, we are up to 15. Yes.

**中文翻译:**
是的，没错。我们现在有 15 个产品。

---

### [00:46:45] Lenny

**English:**
Jesus Christ. Amazing. So this is very rare and the dream of many companies. And so I'm just curious what it is you think Atlassian has done so right to have so many successful individual products?

**中文翻译:**
天哪，太惊人了。这非常罕见，是许多公司的梦想。我很想知道，你认为 Atlassian 究竟做对了什么，才能拥有这么多成功的独立产品？

---

### [00:46:59] Megan Cook

**English:**
You know what, it's not like we added the first product and got it just right way off the bat. So yeah, 15, we've had a lot of shots at this, so I might talk about two examples. I think the first one, if I think about Jira software, it started just as a really humble bug tracker. That was it. There wasn't as much to it, and then it sort of weathered these massive changes in how people build software. So it launched in 2003. And if I remember correctly, just to date this, the mobile phone that was most popular at the time was the Nokia 6100. I don't know if you ever had one of those.

**中文翻译:**
其实，并不是说我们推出第一个产品时就一炮而红。既然有 15 个产品，说明我们尝试了很多次。我可以举两个例子。第一个是 Jira Software，它最初只是一个非常简陋的 Bug 追踪工具，仅此而已。然后它经历了软件构建方式的巨大变革。它是在 2003 年推出的。如果我没记错的话，当时最流行的手机还是诺基亚 6100。不知道你有没有用过。

---

### [00:47:41] Lenny

**English:**
I don't remember what that specific one was, but I'm picturing a Nokia phone. It's like a little small brick.

**中文翻译:**
我不记得具体型号了，但我能想象出诺基亚手机的样子，就像一块小砖头。

---

### [00:47:47] Megan Cook

**English:**
Yeah, it was my mother-in-law's favorite phone. It took us forever to get her off that onto something better. But there's a lot that's changed since that time. There's been agile, there's been cloud. And what we saw recently was more in the expansion of software teams. So they used to be extremely developer centric. And I think most people when they think about Jira software, they think, oh, that must be, well, 80% developers that are using it. But actually it's more like 50% or maybe just shy of 50% are developers. And the rest is this huge mix of support in operations, in sales and marketing, finance, design, HR, legal, just this massive mix of everybody, all the roles you could think of in a company basically that get in there and make work happen.
(00:48:36):
And so what we saw years ago was, well, software teams aren't just developers anymore. And we saw this in our teams as well, but we saw that these other teams, the finance, the marketing teams, even design teams were sort of cobbling together their own solutions. So Jira software is incredibly flexible, which is a massive pro of it. That these teams were seeing software teams get more effective at the way they were getting work done and collaborating better. And they wanted that same benefit and they started using Jira, but we hadn't set it up well for them at all. So it was quite difficult for them to do that. But the positive was that there was this really good signal from our users that they were looking for more from us, and we knew that your marketing team is going to work differently from your developer team. That's how it should be. And so we started Jira work management to be more focused on all of these other use cases outside of the software team that our users were asking us to go ahead and solve.
(00:49:36):
So that was a really great way to discover the need for a new product. Were these really strong signals from within our customers in that same area of business that we're really well set up to help them learn.

**中文翻译:**
是的，那是我婆婆最喜欢的手机，我们花了很久才让她换掉。但从那时起，世界发生了巨大变化，出现了敏捷开发、云计算。我们最近观察到的是软件团队的扩张。以前软件团队完全以开发人员为中心。我想大多数人想到 Jira Software 时，会觉得 80% 的用户都是开发人员。但实际上，开发人员只占大约 50%，甚至不到 50%。剩下的用户是支持、运营、销售、营销、财务、设计、人力资源、法务等各种角色的混合体——基本上公司里你能想到的所有角色都在用它来协作。
所以几年前我们意识到，软件团队不再仅仅由开发人员组成。我们在自己公司也看到了这一点：财务、营销甚至设计团队都在拼凑自己的解决方案。Jira Software 非常灵活，这是它的巨大优势。这些非开发团队看到软件团队的工作效率和协作能力在提升，他们也想要同样的收益，于是开始使用 Jira。但我们当时根本没为他们做好配置，所以他们用起来很吃力。但积极的一面是，这向我们发出了强烈的信号：用户对我们有更多期待。我们知道营销团队的工作方式与开发团队不同，理应如此。于是我们推出了 Jira Work Management，专门针对软件团队之外的这些用例。
这正是发现新产品需求的一种绝佳方式：从现有客户群中捕捉强烈的信号，利用我们在该业务领域的积累去帮助他们。

---

### [00:49:50] Lenny

**English:**
What was that process like from noticing, "Hey, designers are using Jira and they're not having a good time. PMs are using Jira, researchers, and here's the issues they're running." So just that insight of like, "Oh, interesting. There might be an opportunity here to launching." I don't know the first version. I don't know if you're actually involved in this, but whatever you can share would be awesome. Where there design partners they all chose and like let's work with Salesforce and Microsoft and make sure they love it? How long was that process? Because I think that's the prop people are so curious about just how do we validate and discover and then actually launch something that's going to work.

**中文翻译:**
从注意到“嘿，设计师在用 Jira 但体验不好，PM、研究员也在用，他们遇到了这些问题”到最终发布，这个过程是怎样的？这种“哦，有趣，这里可能有机会”的洞察是如何转化为产品的？我不了解第一个版本，也不确定你是否直接参与了，但你能分享的任何细节都会很棒。你们是否选择了设计合作伙伴，比如“让我们和 Salesforce 或微软合作，确保他们喜欢它”？这个过程持续了多久？因为大家非常好奇：我们如何验证、发现并最终发布一个真正有效的产品？

---

### [00:50:28] Megan Cook

**English:**
Yeah, I was just as close to that one, but I can give you a second example.

**中文翻译:**
那个项目我参与得没那么深，但我可以给你举第二个例子。

---

### [00:50:33] Lenny

**English:**
Oh, great.

**中文翻译:**
噢，太好了。

---

### [00:50:35] Megan Cook

**English:**
Yeah, for sure. The second example actually came from our product internal innovation program and that we let anyone pitch an idea for new product in the company if they want to. So we had this wonderful product manager, Tammy Carson, who saw a demand for a solution for product managers to build their roadmaps a bit better before ideas get committed. So as you know, this is fuzzy area before you actually start building something as a product manager where you're looking at lots of opportunities and ideas and you're prioritizing them. And it's not really confirmed real work yet. And nobody wanted to put that in Jira because once it was in Jira, then everyone just expected it to happen. And so this is where Jira product discovery came from.
(00:51:24):
And in the past we'd tried things like this before in new products at Atlassian and they've been successful, but it'd been really hard because large parts of the company process and those checks were optimizing for the success of the bigger products like Jira software. And so we changed that to create really small groups with stage gates that we call wonder, explore, make, impact, and then getting to scale. And that meant to assess those bets at every stage. And the idea was to iterate really quickly, either to it not working out and proving that it couldn't be a business or iterate really quickly to yes it could and we should invest more in this. And so with each stage there would be a little bit of investment.
(00:52:12):
So you say that for a stage of wonder might just be the person with the idea. And then explore, you might add on a couple more people, like three people to go and really have a look at, here's a prototype, here are some customers that'd be interested in it and could help us think about this some more and put together what the roadmap looks like. And then when you get to make that's when you get a full team, but a full team is going to be 12 people or so, it's still not huge. And I think that's really important because at each stage you're getting validation, you're getting more customers who are interested and invested in helping you develop what that solution looks like.
(00:52:56):
You asked about whether we went and partnered with a partner company like Salesforce for something like this, for a new product. In this case it was just really partnering heavily with our customers where we saw that interest coming through in our other products like Jira software and building something that really works for them before expanding it to more and more customers and finding that product market fit and then upping the investment. And so we've had a couple of new products recently that have gone through that sort of stage rollout. So there's Jira Product Discovery, there's Atlas that I mentioned before, and I think Compass is the latest one.

**中文翻译:**
没问题。第二个例子来自我们的内部创新计划，我们允许公司里的任何人提交新产品的想法。我们有一位非常优秀的产品经理 Tammy Carson，她发现 PM 需要一种更好的方式在想法正式提交开发之前构建路线图。如你所知，在真正开始构建之前，PM 处于一个模糊地带：你要看很多机会和想法，并对它们进行优先级排序，但这些还不是确定的工作。没人想把这些放进 Jira，因为一旦进了 Jira，大家就觉得它肯定会发生。这就是 Jira Product Discovery 的由来。
过去我们在 Atlassian 尝试过类似的新产品，虽然有些成功了，但过程很艰难。因为公司的大部分流程和考核都是为了优化像 Jira Software 这样的大型产品的成功。于是我们改变了策略，创建了非常小的小组，并设置了阶段性关卡（Stage gates），我们称之为：好奇（Wonder）、探索（Explore）、制作（Make）、影响（Impact），最后是规模化（Scale）。这意味着在每个阶段都要评估这些“赌注”。核心理念是快速迭代：要么证明它行不通、无法成为一门生意；要么快速证明它可行，我们应该加大投入。每个阶段都会伴随少量的投资。
比如在“好奇”阶段，可能只有那个有想法的人。到了“探索”阶段，可能会增加两三个人，去弄个原型，找一些感兴趣的客户聊聊，完善路线图。到了“制作”阶段，才会有一个完整的团队，但大约也只有 12 人左右，规模依然不大。我认为这很重要，因为在每个阶段你都在获得验证，有更多客户愿意投入时间帮你完善方案。
你问到我们是否会找像 Salesforce 这样的伙伴公司合作。在这个案例中，我们主要是与在 Jira Software 等现有产品中表现出兴趣的客户进行深度合作，在扩大规模和寻找产品市场契合度（Product-market fit）之前，先为他们打造真正好用的东西，然后再加大投入。最近我们有几个新产品都经历了这种阶段性发布，比如 Jira Product Discovery、我之前提到的 Atlas，还有最近的 Compass。

---

### [00:53:36] Lenny

**English:**
So what I'm hearing here is essentially there's this step-by-step gated process that you put new product ideas through and they make it one step at a time. And I imagine there's a leader that can decide, "No, this one's not working out. Let's end it at the explorer phase and invest in other ideas." I imagine

**中文翻译:**
所以我听到的是，本质上有一个循序渐进的关卡流程，新产品想法需要一步步通过。我猜会有一个领导者来决定：“不，这个行不通，我们在探索阶段就停止它，把资源投到别的想法上。”

---

### [00:53:56] Megan Cook

**English:**
Yeah, that's right. It might be someone who's looking after that particular market. At each one of those stages, there's that check on whether or not we continue to go ahead.

**中文翻译:**
是的，没错。可能是负责该特定市场的负责人。在每一个阶段，都会检查是否继续推进。

---

### [00:54:08] Lenny

**English:**
And the stages are wonder. I like that a lot. That's a great name. Explore, make, and then what were the other ones?

**中文翻译:**
阶段名称是“好奇”（Wonder），我很喜欢这个名字。然后是探索（Explore）、制作（Make），剩下的两个是什么？

---

### [00:54:16] Megan Cook

**English:**
Impact and scale.

**中文翻译:**
影响（Impact）和规模化（Scale）。

---

### [00:54:18] Lenny

**English:**
Got it. So impact is like is it showing any impact? We made it, is it working? And then scale. Got it. That makes sense. Just like let's go for it.

**中文翻译:**
明白了。影响阶段就是看它是否产生了效果？我们做出来了，它有用吗？然后是规模化。明白了，这很合理，就是“全力以赴”。

---

### [00:54:25] Megan Cook

**English:**
Yeah. Impact could be I can be self-sufficient in the revenue that I'm generating, and scale is just really launching it to take off.

**中文翻译:**
是的。“影响”可能意味着产生的营收可以自给自足，“规模化”则是真正发布并让它腾飞。

---

### [00:54:35] Lenny

**English:**
Launch it. Yeah, it goes on the website. Okay. So wonder is like a PM and an engineer maybe at Hackathon where we have an idea. Explore is they maybe get a little bit of resourcing and they start exploring the idea, build the prototype, maybe find a design partner too, to think about this. Is that roughly right?

**中文翻译:**
发布它，放上官网。好的。所以“好奇”阶段就像是一个 PM 和一个工程师在黑客马拉松上产生了一个想法。“探索”阶段是他们获得了一点资源，开始探索想法、构建原型，可能还会找个设计合作伙伴一起思考。大概是这样吗？

---

### [00:54:52] Megan Cook

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:54:52] Lenny

**English:**
Okay.

**中文翻译:**
好的。

---

### [00:54:52] Megan Cook

**English:**
Make sure you've got a clear roadmap. Yeah.

**中文翻译:**
确保你有一个清晰的路线图。是的。

---

### [00:54:54] Lenny

**English:**
Okay, got it. And then make, is that where they expand it to a few more customers and make it more fully featured?

**中文翻译:**
明白了。那么“制作”阶段，就是把它推广给更多客户，并完善功能吗？

---

### [00:55:04] Megan Cook

**English:**
Yeah. Make is where you'd actually build it. So the prototype-

**中文翻译:**
是的。“制作”就是真正构建它。因为原型——

---

### [00:55:09] Lenny

**English:**
Okay, got it.

**中文翻译:**
好的，明白了。

---

### [00:55:10] Megan Cook

**English:**
... could be pretty simple, could be a bit cobbled together, make is actually building the product and see if you can get more and more customers.

**中文翻译:**
……原型可能非常简单，甚至是拼凑出来的。“制作”则是真正打造产品，看看能否吸引越来越多的客户。

---

### [00:55:14] Lenny

**English:**
Got it.

**中文翻译:**
明白。

---

### [00:55:15] Megan Cook

**English:**
That's where you'd start to make it with those customers.

**中文翻译:**
那是你开始与那些客户共同打磨产品的阶段。

---

### [00:55:19] Lenny

**English:**
This is really interesting because again, I think Atlassian is one of the very few companies that has done this so well. And I don't know, this number is absurd. I've never heard of another company that's 15 successful products. I don't know how successful they're, but they're out there and people seem to be... They're being promoted. I guess is there any other advice to share along the lines of if someone is thinking about launching a second product, anything you would suggest they do or think about they may not be thinking about?

**中文翻译:**
这真的很有趣，因为我再次认为 Atlassian 是极少数能把这件事做得这么好的公司之一。15 个成功产品这个数字简直不可思议，我没听说过其他公司能做到。我不知道它们具体有多成功，但它们确实存在并被推广。如果你要给那些考虑推出第二个产品的人一些建议，有什么是他们可能没考虑到、但你建议他们去做或去思考的吗？

---

### [00:55:42] Megan Cook

**English:**
I think my advice is skied towards the Atlassian case, which is where you're in a 12,000 strong employee company and how do you seed something that you want to run as more with more of a startup kind of mindset. So when you get to this size, you've got quarterly planning and business reviews and all of these different process and you don't necessarily want to put your seed startup through that. It's not quite ready for that kind of thing. So I think the key things here that make it really successful is starting really small with the idea and the solution to be proved and don't add too many people, don't feel pressured to add too many people. I think it's easy to get really excited about the potential and just want to throw four or five teams at it, but that can... We were talking about this stat. That can make things run slower and so you want to protect them.
(00:56:39):
And the second thing is just give them freedom to move really fast and solve those problems in a different way. So there are different expectations. They don't necessarily need to be a part of that process that I was talking about before. This team should just be running hard to prove whether or not the idea's going to work and whether there's product market fit.
(00:56:59):
And for different approaches. If I want to add something to Jira software, but we're talking millions and millions of users there, that thing has to be resilient. It's got to scale. There are all these things that users inherently expect from something like that. But for something small like this, we are proving product market fit. You don't need to think about that initially. So you've got to hold this to a different standard, otherwise you're just going to slow them down way too much.
(00:57:25):
And actually we found that by letting them tackle problems a little differently, we found innovative way of looking at things that we can pull back into our other products. So for example, if you look at Jira Product Discovery, and just the way that it gives more of a spreadsheet kind of view of a list of ideas and things like that, some of the experience there is definitely something that we'll be pulling into Jira software.

**中文翻译:**
我的建议更倾向于 Atlassian 这种案例：当你身处一家拥有 1.2 万名员工的大公司时，如何培育一个你想以“创业心态”运行的项目。当你达到这种规模，会有季度计划、业务评审和各种流程，你肯定不想让你的初创种子项目去经历这些，它还没准备好。所以成功的关键在于：从小处着手，验证想法和方案，不要增加太多人，不要感到加人的压力。人们很容易对潜力感到兴奋，然后想投入四五个团队，但这反而会让进度变慢。你需要保护他们。
第二点是给他们自由，让他们快速行动，用不同的方式解决问题。要有不同的预期，他们不需要参与我之前提到的那些大公司流程。这个团队应该全力奔跑，去证明想法是否可行，是否有产品市场契合度。
采用不同的标准也很重要。如果我要给 Jira Software 增加功能，面对的是数千万用户，那它必须非常稳健、可扩展，因为用户对此有天然的预期。但对于这种小规模的验证项目，你最初不需要考虑这些。你必须用不同的标准来衡量它，否则你会把他们拖慢。
实际上我们发现，通过让他们以不同的方式处理问题，我们发现了一些创新的视角，可以反哺到我们的其他产品中。例如，Jira Product Discovery 提供了一种类似电子表格的想法列表视图，其中的一些体验设计我们肯定会引入到 Jira Software 中。

---

### [00:58:00] Lenny

**English:**
You mentioned that over the years, Jira has weathered many storms. From my perspective, it feels like it continues to weather many storms incredibly well. One, because there's just endless startups always coming at Jira trying to become the new project management tool that everyone uses. And two, it just feels like people are always dissing on Jira like, "Jira sucks, I want to use something else." On the other hand, it continues to dominate. Many people love it. I'm curious what you believe Atlassian generally has done and your team has done to keep Jira ahead of everyone. And I know you're probably going to say, "We listen to customers better than anyone." So if that's a big part of the answer, definitely share that. But I'm curious, is there anything else people may not be recognizing of just why Jira has been so successful for so long?

**中文翻译:**
你提到多年来 Jira 经历了许多风暴。在我看来，它应对得非常好。一方面，总有层出不穷的初创公司试图挑战 Jira，想成为大家都在用的新工具；另一方面，总有人在吐槽 Jira，说“Jira 太烂了，我想用别的”。但与此同时，它依然占据统治地位，很多人也深爱着它。我很想知道，你认为 Atlassian 和你的团队做了什么，让 Jira 始终领先？我知道你可能会说“我们比任何人都更听取客户意见”，如果这是核心答案，请详细说说。但我很好奇，是否还有其他人们没意识到的原因，解释了为什么 Jira 能长盛不衰？

---

### [00:58:46] Megan Cook

**English:**
Yeah. I think the number of startups that enter this space, just so it shows how important the problem is that we solve and that problem of teamwork and collaboration. We've got more than 125,000 customers around the world who start their day in Jira, millions of users and the kinds of companies that use it. I just love hearing about what they do with it. They really blow me away. Like NASA landing the Mars rover or Canva building this design platform for 40 million people, it's just massive.

**中文翻译:**
是的。我认为进入这个领域的初创公司数量之多，恰恰说明了我们所解决的问题——团队合作和协作——是多么重要。全球有超过 12.5 万名客户每天在 Jira 中开启工作，拥有数百万用户。我非常喜欢听客户如何使用它，那些故事让我大受震撼。比如 NASA 用它来辅助火星车着陆，或者 Canva 用它构建服务 4000 万人的设计平台，这太宏大了。

---

### [00:59:23] Lenny

**English:**
I don't think you can beat that Mars rover story array. That's a good one. I think when you follow it up with the Canvas story, that one's less interesting now, but it's also amazing. Okay. Sorry. Keep going.

**中文翻译:**
我觉得火星车的故事简直无敌了，太精彩了。相比之下，Canva 的故事虽然也很棒，但就显得没那么“酷”了。抱歉，请继续。

---

### [00:59:33] Megan Cook

**English:**
So like you said, they are integral to our success. We do obsess over them. We think if we do right by them, then we're going to be going in the right direction. I don't think we've ever had this sense of arrogance of just... No matter how big we are, we've always got this healthy dose of paranoia that we need to keep working on improving things and being better. So to your point about customer feedback, that is a big part of it. We bake in these rituals just to make it super easy for everyone to do that. So the whole company gets an email every week and it's just got a random selection of feedback from our customers. It's got how they rate us and just a quote as well. And so everyone's sort of getting this dose of feedback all the time.
(01:00:24):
We have regular share outs of all of the research that everyone gets. We get in-product feedback. We make it super easy to talk to our customers through social media or LinkedIn or X now. And then we also have a whole community space where customers can have longer conversations with us about different ideas that we're coming up with or feedback that they have for us. So I think that is all massively important for keeping Jira ahead of the pack.
(01:00:58):
I think how we stay ahead in other areas is just that the culture is super, super open to innovation, kind of invites innovation. So we have these hackathons, we call them shepherd. The whole company stops and everyone can play with new ideas or technologies. It's a competition. So the best ideas get visibility. It can get people working with other people that they wouldn't normally. And also the visibility of the ideas helps generate more ideas all over the place.
(01:01:31):
Like I said before, innovation can come from anywhere. So anyone can pitch new ideas or products. And when we see new technologies emerging that we think are going to be really foundational and interesting, we'll carve off a team to go and look at that. So I think we've had an AI team central to Atlassian for a long time, but with the advent of ChatGPT, there's sort of this huge move forward. There's this leak that's happening. And so in my team, I just carved off a small team to go and explore that and see what interesting things that we could do there.
(01:02:09):
I think we don't shy away from tackling subsets of the market that we're seeing that need a bit more love, like the Jira Product Discovery story that we were just talking about a second ago. And we also use our products a lot and that helps us find all of those little problems and makes it really real. We get really excited about the different things that the whole team is working on. We send lots of feedback to each other. I think that's also a really important part of it.
(01:02:42):
Another area is when we look at how we're investing, there's always this pressure to invest in the core business, of course, but we also make sure that we invest in seeding future businesses. And like we're talking about, they might not always work out. So we had then the Compass and the Atlas example of ones that have worked out, but we also see things through Atlassian inventions. So if there are interesting ideas or technologies, these might support the products later on, that's something that we'll go and seed out there in the market. And that's led to a few acquisitions there as well, which has been really useful.
(01:03:21):
And the last thing is I think I am just really impressed at the way that we stay agile to move towards these different shifts that come up. It always surprises me just how agile we can be. For example, in 2020 we decided to double down on our mission to deliver a world-class cloud experience. And it was like hundreds of people just moved around in Atlassian to make that happen, which was in a very short period of time, which was impressive. And we're not shy about killing things off with their [inaudible 01:03:55]. So I'll give you another example of one of those products that was going through that we ended up killing off. So we had a whiteboard product that we thought would be its own product, sort of like a Jira Product Discovery. And when we came to one of those gates with the team, we realized actually this is more a really useful document type. And so now you'll see that it's a feature in Confluence. It was very quick to make that decision.

**中文翻译:**
正如你所说，客户是我们成功的基石。我们对他们非常痴迷。我们认为只要服务好他们，方向就不会错。无论我们规模多大，我们从未有过傲慢感，反而始终保持着一种“健康的偏执”，觉得必须不断改进。关于客户反馈，我们建立了一些机制让这件事变得极其简单。全公司每周都会收到一封邮件，随机选取客户反馈，包括评分和引言。这样每个人都能不断接触到真实的声音。
我们会定期分享研究成果，收集产品内反馈。我们让客户通过社交媒体、LinkedIn 或 X 轻松联系到我们。我们还有一个社区空间，客户可以在那里就我们的想法或他们的反馈与我们进行深入交流。这些对于保持 Jira 的领先地位至关重要。
在其他方面，我们的文化非常鼓励创新。我们有黑客马拉松（我们称之为 ShipIt），全公司都会停下工作去尝试新想法或新技术。这是一种竞赛，优秀的点子能获得曝光，让平时不合作的人聚在一起，这种可见性也能激发更多灵感。
正如我之前说的，创新可以来自任何地方。当出现基础性的、有趣的新技术时，我们会专门抽调团队去研究。Atlassian 很久以前就有核心 AI 团队了，但随着 ChatGPT 的出现，行业发生了巨大飞跃。于是我在我的团队里抽调了一小部分人去探索我们能做哪些有趣的事。
我们也不避讳去解决那些需要更多关注的细分市场，比如刚才提到的 Jira Product Discovery。此外，我们自己也大量使用自家的产品（Dogfooding），这能帮我们发现细微的问题，让体验变得真实。我们对团队的工作感到兴奋，并互相发送大量反馈。
在投资方面，虽然有投资核心业务的压力，但我们也确保投资于未来的种子业务。虽然不一定都能成功，但 Compass 和 Atlas 就是成功的例子。我们还通过 Atlassian Ventures 投资外部的有趣想法或技术，这后来也促成了一些非常有用的收购。
最后一点是，我们保持敏捷以应对各种变化的能力让我印象深刻。例如在 2020 年，我们决定全力投入云端体验，数百人在短时间内调整了岗位来实现这一目标。我们也不怕砍掉不合适的项目。比如我们曾开发过一个白板产品，原本想让它独立，像 Jira Product Discovery 一样。但在评审关卡中，我们意识到它其实更适合作为一种文档类型。于是它现在成了 Confluence 的一个功能。我们很快就做出了这个决定。

---

### [01:04:28] Lenny

**English:**
I have this new segment, not that new anymore, called Failure Corner. I'm curious if you have any interesting story of a big failure in your career. And if you do, what you learned from that experience?

**中文翻译:**
我有一个环节叫“失败角落”。我很想知道你在职业生涯中是否有过什么重大的失败故事？如果有，你从中学到了什么？

---

### [01:04:41] Megan Cook

**English:**
I think I'll give you a bit of a different one because I think this one is harder to spot and I think that's really interesting. It's something that I think about all the time though. So I missed a really big opportunity to move Atlassian forward back in the day. And I, like I said, think about it every time I review a new idea or look at an opportunity that we're thinking about.
(01:05:06):
So I was on this team and I was improving the way that our products help developers get their work done. And so typically we saw them start in Jira software. They'd pick up a piece of work and then they'd switch tools. They'd create a brand, they'd start writing code. And we noticed that they would forget to come back and update the status of their work and this could create a lot of confusion in the team. Another developer could pick up that work thinking it wasn't started and then there was a lot of wasted time. Or if you're trying to track metrics like how long does it take for a piece of work to get started through to done? That'll totally ski things. So this was causing a lot of problems.
(01:05:42):
But we didn't want to make developers come back into the tool that was obviously something that was getting in the way of their work. So we decided to build automation so they didn't have to leave their ID or the command line to do that. They can just keep working. So an example is Jira would detect that a new command had been created and then it could automatically move your piece of work to in progress because there's code being written against it. And there were a whole bunch of these examples that parties integrated into it and I made the decision to put into Jira as a user was editing their workflow and we shipped it and it performed just fine. People discovered it, they used it, and seemed to give a lot of value. People liked it, which doesn't really sound like a fail. I don't think that...
(01:06:33):
Where I dropped the ball was more about what I should have realized about that feature. So automation, it's super useful. It can be used by a whole slew of people who aren't just developers. It could be used in every single product. It's more than just moving things to a new status. And so I should have realized that we could have built this amazing service that every product could have moved themselves forward with. And years later, Atlassian actually acquired a company that did exactly that, this advanced automation. And it's in every product now. And so you can imagine how much it costs to acquire a company. That was a really extensive mistake on my part. So when I see a new idea, I'm always asking myself, "How do we push this further? Is there something there that we can 10X? Can we apply it more broadly to more types of users, more products? Is there some bigger opportunity that we can really take advantage of?"

**中文翻译:**
我给你讲一个不太一样的例子，因为这个失败很难被察觉，我觉得这很有趣。但我一直在反思它。多年前，我错过了一个推动 Atlassian 跨越式发展的重大机会。现在每当我评审新想法或机会时，我都会想到它。
当时我在一个团队，负责改进产品如何帮助开发人员完成工作。通常我们看到他们从 Jira Software 开始，领取任务，然后切换工具，创建分支，开始写代码。我们注意到他们经常忘记回到 Jira 更新任务状态，这导致了团队混乱。另一个开发人员可能会以为任务还没开始而重复领取，浪费时间。或者当你尝试追踪“从开始到完成需要多久”这类指标时，数据会完全失真。
但我们不想强迫开发人员回到 Jira，因为那会干扰他们的工作。于是我们决定构建自动化功能，让他们无需离开 IDE（集成开发环境）或命令行就能更新状态。例如，Jira 会检测到新的提交，然后自动将任务移至“进行中”。我们做了一系列这样的集成，我决定把这个功能放在用户编辑工作流的界面里。产品发布后表现很好，用户发现了它，也很喜欢，提供了很多价值。这听起来不像失败，对吧？
但我搞砸的地方在于：我没意识到这个功能的潜力。自动化是非常通用的，不仅开发人员需要，所有人、所有产品都需要。它不仅仅是移动状态。我本该意识到我们可以构建一个通用的自动化服务，让公司里的每个产品都能受益。几年后，Atlassian 收购了一家专门做这种高级自动化的公司，现在它应用在每个产品中。你可以想象收购一家公司要花多少钱。那是我犯下的一个代价高昂的错误。所以现在看到新想法，我总会问自己：“我们如何把它推得更远？有没有什么能做大 10 倍的地方？它能否更广泛地应用于更多用户和产品？是否有一个我们能真正利用的更大的机会？”

---

### [01:07:31] Lenny

**English:**
That's an awesome story. So the lesson there is just think bigger with the products. You almost need to wait for it to first be successful for you just to be like, "Oh, but can we do something more with this?" Do you think you should have been thinking about that as you were building it or would that have been too early?

**中文翻译:**
这个故事太棒了。所以教训就是：对产品要有更宏大的思考。你是否觉得在构建它的时候就该想到这一点，还是说那时候想太早了？

---

### [01:07:47] Megan Cook

**English:**
No, I think I should have caught that as we were building it, because even when I think about the experience, so it was a really good proving ground for it for sure. But even when I think about the experience, just where that experience was designed and product limited its functionality, which is a real shame.

**中文翻译:**
不，我觉得在构建时就该意识到。虽然它确实是一个很好的试验场，但从体验设计的角度看，当时的设计和产品定义限制了它的功能，这真的很可惜。

---

### [01:08:07] Lenny

**English:**
I guess the takeaway there is just if you're committing to some idea, ask yourself what would it look like if this was 10 times bigger? If this was a bigger deal, can this apply to other things we're doing? Is that right?

**中文翻译:**
我想核心收获是：当你致力于某个想法时，问问自己，如果它大 10 倍会是什么样子？如果它是一个更重要的项目，它能否应用到我们正在做的其他事情上？对吗？

---

### [01:08:21] Megan Cook

**English:**
Yeah. Where could this go in three years, five years? And should that change the way that you think about it now?

**中文翻译:**
是的。三五年后它会发展成什么样？这是否应该改变你现在的思考方式？

---

### [01:08:29] Lenny

**English:**
Great advice. Megan, is there anything else that you wanted to share or is there anything you wanted to leave listeners with before we get to our very exciting lightning round?

**中文翻译:**
很棒的建议。Megan，在进入激动人心的闪电轮问答之前，你还有什么想分享或留给听众的吗？

---

### [01:08:39] Megan Cook

**English:**
I'll leave you with something. And it's just this practice that I've found really useful for my squad that we've implemented pretty recently, and especially with remote work and all of that. So like I said, we have limited time together, but what we put into place is something we called Fight Club. I'll probably get in trouble for talking about Fight Club. The first rule is you don't talk about fight club.

**中文翻译:**
我再分享一个。这是我发现对我的团队非常有用的一个实践，我们最近刚开始实施，特别是在远程办公的背景下。正如我所说，我们在一起的时间有限，所以我们建立了一个叫“搏击俱乐部”的机制。聊这个我可能会惹麻烦，毕竟第一条规则就是“不许谈论搏击俱乐部”。

---

### [01:09:05] Lenny

**English:**
Everyone knows that.

**中文翻译:**
大家都知道。

---

### [01:09:08] Megan Cook

**English:**
It's 30 minutes every week. And it's just for myself, my engineering and my design leader, and we get together and we know that we're going in there to have a conflict. I think often when there's difficult conversations or those conflicts come up, you can put them off until they become much bigger. Or if somebody is conflict adverse, they can try to avoid having it at all. But by having a specific sort of time in your week for something like that, then you're sort of in that mindset. You know you're going in there to solve a hard problem. You know that there's going to be a disagreement and it makes it much better. And I think the relationship we all have is so much better because we get on top of these things early.

**中文翻译:**
每周 30 分钟，只有我、工程负责人和设计负责人参加。我们聚在一起，明确知道这次会议就是为了产生冲突。通常当出现艰难对话或冲突时，人们会拖延，直到问题爆发；或者回避冲突的人会试图完全避免讨论。但通过每周专门留出这段时间，你就会进入那种心态。你知道你是去解决难题的，知道会有分歧，这反而让事情变得简单。我认为我们之间的关系之所以这么好，正是因为我们能及早处理这些矛盾。

---

### [01:09:53] Lenny

**English:**
This is super cool. It's like couples therapy or something where you're just like, "What issues do we have? Let's work through them right now." I love that. I love that. And it makes it okay to bring up things that are bothering you and things that you think need to change. And with that, we've reached our very exciting lightning round. Are you ready?

**中文翻译:**
这太酷了。有点像“伴侣治疗”，大家坐下来谈：“我们之间有什么问题？现在就解决它。”我喜欢这个点子。它让提出困扰你的事或你认为需要改变的事变得理所应当。那么，现在进入激动人心的闪电轮问答。准备好了吗？

---

### [01:10:12] Megan Cook

**English:**
Yes, can't wait. Let's do it.

**中文翻译:**
准备好了，迫不及待，开始吧。

---

### [01:10:14] Lenny

**English:**
First question, what are two or three books that you've recommended most to other people?

**中文翻译:**
第一个问题，你向别人推荐最多的两三本书是什么？

---

### [01:10:19] Megan Cook

**English:**
Look, I have a habit of sending books to everyone who reports to me every year just on a skill they're working on. So I've got a huge list that I actually send out, but the one that I send out the most to new PMs especially is just inspired by Marty Cagan. It holds up really well. It was recommended to me by my first boss, and it's just got a bunch of great tips in there, just great foundational knowledge.
(01:10:49):
More recently, what I've been sending out for my managers is Scaling People by Claire Hughes Johnson. I think that just came out within the last year actually, but it's just got an incredible amount of really useful tactical things, templates, all sorts of things that you can put into practice.

**中文翻译:**
我有个习惯，每年会根据下属正在提升的技能给他们送书。我有一份很长的书单。但我推荐给新 PM 最多的是 Marty Cagan 的《启示录》（Inspired）。这本书经久不衰，是我第一任老板推荐给我的，里面有很多非常棒的基础知识。
最近，我经常送给经理们的是 Claire Hughes Johnson 的《Scaling People》。这本书应该是去年才出的，里面有大量非常实用的战术建议、模板和各种可以付诸实践的东西。

---

### [01:11:11] Lenny

**English:**
Great choices. We have both in the bookshelf behind me. Both of them have been on the podcast. I wish I could see the whole list of books that you recommend to people. If you don't have this written out anywhere, you should publish some kind of blog or newsletter post of here's the skill and here's the book you recommend.

**中文翻译:**
很棒的选择。我身后的书架上就有这两本，两位作者也都上过我的播客。我真希望能看到你推荐的完整书单。如果你还没写下来，你应该发个博客或简报，列出“什么技能对应什么书”。

---

### [01:11:26] Megan Cook

**English:**
Oh, that's a great idea. Yeah, I'm going to do that. Thanks.

**中文翻译:**
噢，好主意。我会去做的，谢谢。

---

### [01:11:29] Lenny

**English:**
Right, you have a homework assignment. Okay, next question. What is the favorite recent movie or TV show you've really enjoyed?

**中文翻译:**
好的，这是你的作业。下一个问题，最近你非常喜欢的电影或电视剧是什么？

---

### [01:11:35] Megan Cook

**English:**
I am so late to TV, but Foundation is the one that I've been binging lately, and I think it's just this huge world. And I'm not usually one that gets super into sci-fi, but the way that it brings forward some of these ideas for what new technologies could mean... If you haven't seen it, and this is really spoiling it, one of the main characters or three of the main characters are actually clones of this emperor who rules the universe and decided to clone himself at three different stages of his life so that those people could continue rolling. And I think even that idea just invites the idea of what if we stretched out human life? What are the impact? How do things advance when you've got that same mindset and same people continue on? It's super compelling.

**中文翻译:**
我很少看电视，但最近在追《基地》（Foundation）。它的世界观非常宏大。我通常不太迷科幻片，但它展示新技术意义的方式很吸引人。如果你没看过（这里有剧透），其中三个主角实际上是统治宇宙的皇帝的克隆体，他在生命的不同阶段克隆了自己，以便统治能延续。这个想法引发了思考：如果我们延长了人类寿命会怎样？当同样的心态和同样的人持续存在时，事物会如何演变？这非常引人入胜。

---

### [01:12:28] Lenny

**English:**
Foundation, the show got ruined for me by reading the books many, many years ago, is one of my favorite sci-fi trilogy of all time. And then I was so excited for the show and has nothing to do with the books, basically. It's like the storyline is completely different, the core idea is the same as the only real. So I just got tired of it and stopped. But if you haven't read the books, I think you would love it. It's beautiful.

**中文翻译:**
《基地》这部剧对我来说有点被毁了，因为我多年前读过原著，那是我最喜欢的科幻三部曲之一。我对剧集充满期待，但它基本上和书没关系，故事情节完全不同，只有核心概念是一样的。所以我看累了就停了。但如果你没读过书，我想你会喜欢它的，画面很美。

---

### [01:12:50] Megan Cook

**English:**
Are the books better?

**中文翻译:**
书更好看吗？

---

### [01:12:53] Lenny

**English:**
Yeah, the books are better. The books are always better, I think is a good rule of thumb.

**中文翻译:**
是的，书更好。我觉得“书总是比剧好”是一个通用的准则。

---

### [01:13:00] Megan Cook

**English:**
Yeah, that is a good rule. I'll probably pick that up.

**中文翻译:**
没错，好准则。我可能会去读读看。

---

### [01:13:00] Lenny

**English:**
Yeah. I was like a teenager when I read them, so I don't know. Maybe they suck, but I think people love them. Highly recommend the books if you liked the show especially. Next question, do you have a favorite interview question that you'd like to ask candidates?

**中文翻译:**
我读的时候还是个青少年，所以不确定现在看怎么样，但我想大家都很喜欢。如果你喜欢这部剧，我强烈推荐去读原著。下一个问题，你最喜欢的面试问题是什么？

---

### [01:13:12] Megan Cook

**English:**
I think it's an old one, but a great one on the subject of failure. I love to ask people about their biggest failure and I think it's a good way to get to know somebody because you can see how introspective they are, how much they think about what's happened and what they learned from it. It shows whether or not they can be vulnerable with you. You can see what they consider to be a big failure. Some people will list something that's not really a failure. And also you can see about whether they've got that growth mindset. So have they learned something from that? Have they applied it moving forward?
(01:13:51):
Weird rule that I've found is that a lot of the best hires that I've had has had big failure stories that they've worked through and learned from. And so I think that's great to see what they consider there, what the learnings are, but also in the solution you can also see how they tackle something like that. So are they the type of person who wants to go and forge something all by themselves? Are they the type of person who will pull together a community to figure something out? So you get that insight into their values and their approach from that question too, which is hugely useful.

**中文翻译:**
虽然是个老问题，但关于失败的问题依然很棒。我喜欢问候选人“你最大的失败是什么”。这是了解一个人的好方法，因为你可以看到他们的反思能力，他们如何思考发生的事情以及学到了什么。这能展示他们是否愿意在你面前展现脆弱。你还能看到他们对“重大失败”的定义——有些人列举的事情根本算不上失败。此外，你还能看出他们是否有成长型思维：他们学到了什么？是否应用到了之后的工作中？
我发现一个奇怪的规律：我招到的很多最优秀的员工都有过重大的失败经历，并且从中走了出来。通过这个问题，你不仅能看到他们的教训，还能看到他们解决问题的方式：他们是那种想靠自己搞定一切的人，还是那种会集结大家共同解决问题的人？这能让你深入了解他们的价值观和做事方法，非常有用。

---

### [01:14:30] Lenny

**English:**
Is there a favorite product you've recently discovered that you really love?

**中文翻译:**
最近有没有发现什么让你非常喜爱的产品？

---

### [01:14:34] Megan Cook

**English:**
Yeah. You might have to stop me from going on and on about this, but I recently got a smoker, a Traeger smoker for smoking meat. And just the unboxing experience was incredible. So you get this huge box, cardboard box, you open it up. If you reverse the cardboard box, it becomes like a play saloon that your kid can jump into and just mess around in which-

**中文翻译:**
有的。你可能得阻止我一直说下去，但我最近买了一个 Traeger 熏肉炉。它的开箱体验简直绝了。你收到一个巨大的纸箱，打开后，如果你把纸箱反过来，它就变成了一个玩具小木屋，孩子可以钻进去玩。

---

### [01:15:02] Lenny

**English:**
Wow, that's cool.

**中文翻译:**
哇，太酷了。

---

### [01:15:03] Megan Cook

**English:**
... rather than just throwing it out, it becomes something really cool and useful. The set of instructions has a six-pack of beer at the top, just helps you understand how far through you should be through your six-pack as you're constructing it. You get some tools with it. And they're really good actually. They're not the usual kind of throwaway tools that you get in something to put together something like this. In addition to that sort of playful delightfulness in there, as you build it, you discover things along the way. So I opened up the hopper where you put in your wood pellets and there was a baseball cap, a tray of baseball cap in there, which was unexpected and really cool. And then the whole experience of actually using it once you've set it up is amazing. So it's all connected to my phone. I can just head to the beach and have some brisket going and come home and it's beautifully done. It just works. It's integrated. It's got integrated recipes. Yeah, I love that. I like that one.

**中文翻译:**
……与其直接扔掉，它变成了一个非常酷且有用的东西。说明书顶部画了六瓶啤酒，帮你衡量组装进度——组装到哪一步该喝第几瓶酒。附带的工具质量也非常好，不是那种组装完就扔的一次性工具。除了这种趣味性，在组装过程中你还会不断发现惊喜。我打开放木屑颗粒的料斗，发现里面竟然有一顶棒球帽，太意外、太酷了。组装好后的使用体验也棒极了。它连接到我的手机，我可以去海滩玩，同时熏着牛胸肉，回家时肉就完美熏好了。它非常智能，内置了各种食谱。我真的很喜欢这个产品。

---

### [01:16:12] Lenny

**English:**
And salt. That sounds so delightful. Such a great product experience. I'm going to have to get one I think. I think we're going to sell some Traeger smokers.

**中文翻译:**
听起来太愉悦了，真是伟大的产品体验。我想我也得买一个。我觉得我们要帮 Traeger 卖掉不少熏肉炉了。

---

### [01:16:17] Megan Cook

**English:**
Sure.

**中文翻译:**
当然。

---

### [01:16:22] Lenny

**English:**
Next question. Do you have a favorite life motto that you often come back to share with friends, either in work or in life?

**中文翻译:**
下一个问题。你有没有什么经常分享给朋友的人生格言，无论是在工作还是生活中？

---

### [01:16:28] Megan Cook

**English:**
It's around maximizing joy. And what I mean by that is it's about finding what's important and leaning into it or finding what's annoying and turning it into something I enjoy. To give you a super small example is I'm terrible with keys. I will leave that thing all over the place. You'll find it in my cutlery drawer or whatever, and I'll never find it again. And I think an obvious solution to that could be to put a hook on the wall or something where you can just leave them and you go back to that and it's easy to find. But what gives me joy is not actually having to have keys at all. And so now I have a fingerprint reader on my front door and I feel a little bit like James Bond every time I enter my house and I can let people in if somebody needs to leave a package or something that's easy to do. So it was turning something annoying into something more joyful.
(01:17:24):
And I think the other thing there is just I really value keeping great relationships and increasing those relationships. And so I always make time for these amazing friends that I have that live in London, and we have this pact where every time either one of us goes to the others' continent, we'll go meet them there. So every time I go to Europe, which last year I was in Berlin, at one point in Amsterdam, and on the plane, they came over and we just hung out and had a great time. And so it's making sure that you make time for those important things.

**中文翻译:**
是关于“最大化快乐”。我的意思是，找到重要的事情并全身心投入，或者找到烦人的事情并把它变成我喜欢的事情。举个极小的例子：我非常不擅长保管钥匙，经常随手乱放，可能在餐具抽屉里才能找到。一个显而易见的解决方案是在墙上装个挂钩。但真正让我快乐的是“根本不需要钥匙”。所以现在我给大门装了指纹锁，每次进屋都觉得自己像詹姆斯·邦德，而且如果有人要送快递，我也能轻松远程开门。这就是把烦心事变成乐事。
另一件事是我非常看重维护和增进人际关系。我总会为住在伦敦的好友留出时间。我们有个约定：只要有人去了对方所在的大洲，我们就一定要见面。去年我去欧洲，在柏林和阿姆斯特丹时，他们专门飞过来找我，我们一起度过了愉快的时光。确保为这些重要的事情留出时间。

---

### [01:18:00] Lenny

**English:**
Along the same lines, final question related to creating more joy. I noticed a beautiful surfboard behind you. For somebody that's trying to surf and maybe not being successful, what's one tip you could share with listeners to improve their success with surfing?

**中文翻译:**
顺着这个思路，最后一个关于创造快乐的问题。我注意到你身后有一块漂亮的冲浪板。对于那些尝试冲浪但不太成功的人，你能分享一个提高成功率的技巧吗？

---

### [01:18:18] Megan Cook

**English:**
Isn't surfing the most humbling sport that you've ever tried?

**中文翻译:**
冲浪难道不是你尝试过的最让人感到挫败（Humbling）的运动吗？

---

### [01:18:22] Lenny

**English:**
Yeah, I've tried a few times and yeah, I would say so.

**中文翻译:**
是的，我试过几次，确实如此。

---

### [01:18:29] Megan Cook

**English:**
I think surfing's really interesting. I've never done a sport like it in that it's something that you have to really feel. So I find every time you learn and you think about surfing, you sort of feel it before you know how to do it. So even just being able to catch a wave, a green pace wave, you're paddling, you're paddling, you don't quite know where to be, you don't quite know how much to paddle for that wave, and you just have to sort of be successful a couple times before you get the feel for it. And it's the same with trying to find the right wave. When I looked at the ocean the first time to try and pick the wave and pick where to be, I couldn't even see the shape of it to find that right place. It took me just seeing a hundred waves to be able to do that.
(01:19:15):
So my best tip for surfing is get out there, keep doing it, do it over and over and over again. You will get better. You'll start to see all of these things that you've never noticed before. And get some friends. Get some friends out there, get surfing accountability buddy to make sure that you're getting out there often.

**中文翻译:**
我觉得冲浪非常有趣。我从未见过类似的运动，它是一种你必须去“感受”的东西。我发现每次学习冲浪，你都是在学会动作之前先感受到了它。比如抓浪，你不断划水，不知道该站在哪，不知道该划多用力，你必须成功几次后才能找到那种感觉。找浪也是一样。我第一次看大海尝试选浪时，甚至看不出浪的形状。我看了上百个浪之后才学会。
所以我最好的建议是：去冲浪吧，不断尝试，反复练习。你会变好的，你会开始注意到以前从未发现的细节。还有，找几个朋友一起，找个“冲浪监督伙伴”，确保你能经常下水。

---

### [01:19:37] Lenny

**English:**
He's the best buddy. Amazing. Megan, we've talked about play and safety and buy-in and fighting the good fight and adding new product lines, also surfing. Two final questions. Where can folks find you online if they want to reach out and maybe follow up on some stuff? And how can listeners be useful to you?

**中文翻译:**
找个伴儿最好了。太棒了。Megan，我们聊了玩乐、安全感、认可、坚持正确的事、增加新产品线，还有冲浪。最后两个问题：如果大家想联系你或跟进一些内容，可以在哪里找到你？听众们能为你做些什么？

---

### [01:19:55] Megan Cook

**English:**
The best place to find me is on LinkedIn. I'm Megan Cook on LinkedIn. You can also find me if you're a customer in the Atlassian community, if you want to have a chat. And I'm also on social media, so on X, you can find me there as well. And be useful to me. Look, any feedback, absolutely any feedback on Jira software, always hungry for that. Also, really keen, if you want to just chat about how people's ways of working are evolving and shifting and changing, and how do you think that's going to turn out and how you see your goals for your team changing. I would love to talk about that. Please get in touch.

**中文翻译:**
找我最好的地方是 LinkedIn，搜索 Megan Cook。如果你是客户，也可以在 Atlassian 社区找到我。我也在 X（原 Twitter）上。至于如何帮到我：任何关于 Jira Software 的反馈，我永远都渴求反馈。另外，如果你想聊聊人们的工作方式是如何演变和变化的，以及你认为未来会怎样，或者你团队的目标是如何变化的，我也非常乐意交流。请随时联系我。

---

### [01:20:37] Lenny

**English:**
Awesome. Megan, thank you so much for being here.

**中文翻译:**
太棒了。Megan，非常感谢你能来。

---

### [01:20:40] Megan Cook

**English:**
Thank you, Lenny. It's been fun.

**中文翻译:**
谢谢你，Lenny。聊得很开心。

---

### [01:20:42] Lenny

**English:**
Same. Bye everyone.
(01:20:44):
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
我也是。大家再见。感谢收听。如果你觉得本期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅。此外，请考虑给我们评分或留下评论，这能帮助其他听众发现这个播客。你可以在 lennyspodcast.com 找到往期所有节目或了解更多信息。下期见。