# Melissa Perri + Denise Tilles - 双语对照

This is the complete bilingual transcript for Lenny’s Podcast featuring Melissa Perri and Denise Tilles.

这是 Lenny 访谈录（Lenny's Podcast）关于 Melissa Perri 和 Denise Tilles 访谈的完整双语对照文稿。

---

### [00:00:00] Melissa Perri

**English:**
Do you want to hire 10,000 product managers and let them all do these things off the side of their desk and then concentrate on strategic work 30% of the time or do you want them concentrating on strategic work majority of the time and then help build a product operations team around them that can create these shared systems and this infrastructure to allow them to work better?

**中文翻译:**
你是想雇佣 1 万名产品经理，让他们把这些杂事当作“案头工作”顺便处理，然后只花 30% 的时间专注于战略工作？还是希望他们大部分时间都专注于战略，并围绕他们建立一个产品运营（Product Ops）团队，创建共享系统和基础设施，让他们工作得更出色？

---

### [00:00:25] Lenny

**English:**
Today, my guests are Melissa Perri and Denise Tilles. This is a rare two-guest episode. Melissa and Denise are authors of an awesome new book called *Product Operations: How Successful Companies Build Better Products at Scale*. Melissa is a legend in the product management community. She's the author of the foundational handbook, *Escaping the Build Trap*. She runs a product management training organization called Produx Labs, teaches product management at Harvard, and has worked with hundreds of companies on their product management function. Denise is a product leader, coach, and consultant helping companies with their product vision, strategy, and execution, and works with Melissa at Produx Labs.

**中文翻译:**
今天，我的嘉宾是 Melissa Perri 和 Denise Tilles。这是一个罕见的双嘉宾集。Melissa 和 Denise 是一本超棒新书的作者，书名是《产品运营：成功公司如何规模化构建更好的产品》（*Product Operations: How Successful Companies Build Better Products at Scale*）。Melissa 是产品管理界的传奇人物。她是基础手册《走出构建陷阱》（*Escaping the Build Trap*）的作者。她经营着一家名为 Produx Labs 的产品管理培训机构，在哈佛大学教授产品管理，并曾为数百家公司的产品管理职能提供咨询。Denise 是一位产品领导者、教练和顾问，帮助公司制定产品愿景、战略和执行，并与 Melissa 一起在 Produx Labs 工作。

**(00:01:02):**
In our conversation, we get super deep into the emerging role of product ops. As you'll hear in our conversation, over the past few years, this role has gone from almost non-existent to something like half of scaling tech companies with at least one product ops person. This new role is probably the thing that's most changing in the role of product management. After this conversation, I'm convinced it's a great thing.

**中文翻译:**
在我们的对话中，我们将深入探讨“产品运营”（Product Ops）这一新兴角色。正如你将在对话中听到的，在过去几年里，这个角色从几乎不存在，发展到大约一半的规模化科技公司都至少拥有一名产品运营人员。这个新角色可能是产品管理领域中变化最大的部分。在这次谈话之后，我确信这是一件好事。

**(00:01:24):**
We chat about what the role concretely is, how it differs from product management and project management, what to look for in your first product ops hire, how to roll out a product ops function, why product managers shouldn't be afraid of this role and how your life gets significantly better, plus, a case study on how they rolled out product ops function at a large company, and so much more. With that, I bring you Melissa Perri and Denise Tilles after a short word from our sponsor.

**中文翻译:**
我们聊到了这个角色的具体定义，它与产品管理（PM）和项目管理（Project Management）的区别，在招聘第一个产品运营人员时应该看重什么，如何推行产品运营职能，为什么产品经理不应该害怕这个角色以及它如何让你的生活变得更好。此外，还有一个关于他们如何在大型公司推行产品运营职能的案例研究，以及更多精彩内容。在听完赞助商的简短介绍后，我将为你带来 Melissa Perri 和 Denise Tilles 的访谈。

---

### [00:01:50] Lenny (Sponsor: Jira Product Discovery)

**English:**
You fell in love with building products for a reason, but sometimes the day-to-day reality is a little different than you imagined. Instead of dreaming up big ideas, talking to customers, and crafting a strategy, you're drowning in spreadsheets and roadmap updates and you're spending your days basically putting out fires. A better way is possible. Introducing Jira Product Discovery, the new prioritization and road mapping tool built for product teams by Atlassian. With Jira Product Discovery, you can gather all your product ideas and insights in one place and prioritize confidently, finally replacing those endless spreadsheets. Create and share custom product roadmaps with any stakeholder in seconds, and it's all built on Jira, where your engineering team's already working so true collaboration is finally possible.

**中文翻译:**
你爱上构建产品是有原因的，但有时日常现实与你的想象略有不同。你没有在构思伟大的创意、与客户交谈和制定战略，而是淹没在电子表格和路线图更新中，整天基本上都在“救火”。现在有一种更好的方式。向你介绍 Jira Product Discovery，这是由 Atlassian 为产品团队打造的新型优先级排序和路线图工具。通过 Jira Product Discovery，你可以将所有的产品创意和洞察集中在一处，并自信地进行优先级排序，最终取代那些没完没了的电子表格。在几秒钟内创建并与任何利益相关者分享定制的产品路线图，而且它完全构建在 Jira 之上，你的工程团队已经在那里工作了，因此真正的协作终于成为可能。

**(00:02:36):**
Great products are built by great teams, not just engineers, sales, support, leadership, even Greg from finance. Anyone that you want can contribute ideas, feedback, and insights in Jira Product Discovery for free, no catch, and it's only $10 a month for you. Say goodbye to your spreadsheets and the never ending alignment efforts. The old way of doing product management is over. Rediscover what's possible with Jira Product Discovery. Try it for free at atlassian.com/lenny. That's atlassian.com/lenny.

**中文翻译:**
伟大的产品是由伟大的团队构建的，不仅仅是工程师，还包括销售、支持、领导层，甚至是财务部的 Greg。你想要的任何人都可以免费在 Jira Product Discovery 中贡献创意、反馈和洞察，没有任何限制，而你每月只需支付 10 美元。告别你的电子表格和永无止境的对齐工作吧。旧的产品管理方式已经结束。通过 Jira Product Discovery 重新发现无限可能。在 atlassian.com/lenny 免费试用。网址是 atlassian.com/lenny。

---

### [00:03:13] Lenny

**English:**
Melissa and Denise, thank you so much for being here. Welcome to the podcast.

**中文翻译:**
Melissa 和 Denise，非常感谢你们来到这里。欢迎来到本播客。

---

### [00:03:17] Denise Tilles

**English:**
Thank you.

**中文翻译:**
谢谢。

---

### [00:03:18] Melissa Perri

**English:**
Thanks for having us.

**中文翻译:**
谢谢邀请我们。

---

### [00:03:19] Lenny

**English:**
You are the second ever guest duo I've had on the podcast. Melissa, this is your second appearance on the podcast, and you two have a new book out, which I have right here. It's called *Product Operations: How Successful Companies Build Better Products at Scale*. What I want to do with our time today is to help people fully understand the role of product operations from every direction as much as we can get through in an hour. How does that sound?

**中文翻译:**
你们是我播客历史上第二对嘉宾组合。Melissa，这是你第二次参加这个播客。你们两位出了一本新书，就在我手里。书名是《产品运营：成功公司如何规模化构建更好的产品》。我今天想做的是，在这一小时内尽可能从各个角度帮助大家全面了解“产品运营”这个角色。听起来怎么样？

---

### [00:03:44] Melissa Perri / Denise Tilles

**English:**
Sounds great. / Great. / Let's do it.

**中文翻译:**
听起来很棒。/ 太好了。/ 开始吧。

---

### [00:03:45] Lenny

**English:**
Awesome. So first question, just to set a little context on this role, how popular and how common is the role at this point? I did a quick skim of just awesome companies and really successful companies, and every single one of them seems to have a product ops role at this point. OpenAI, Uber, Stripe, Ramp, Deel, those are just the few that I looked at. Is that what you're seeing? How should people think about how popular and how common this role has become?

**中文翻译:**
太棒了。第一个问题，为了给这个角色设定一些背景：目前这个角色有多流行、多普遍？我快速浏览了一些非常棒且成功的公司，似乎每一家现在都有产品运营（Product Ops）岗位。OpenAI、Uber、Stripe、Ramp、Deel，这些只是我看到的几家。这也是你们观察到的情况吗？人们应该如何看待这个角色的普及程度？

---

### [00:04:12] Melissa Perri

**English:**
I think over the last few years, we definitely have seen product operations start booming. It did originate in a lot of big companies that you mentioned too like Uber. The head of product operations at Uber and the person who started it, Blake Samic, is a case study in our book and he also did it at Stripe and he does it at OpenAI. So it's pretty funny that you mentioned those three because that's Blake right there who did that. We have seen a very good transition from people whispering about product operations, and I know when I wrote my first book, *Escaping the Build Trap*, in 2018 I mentioned it in there because we had just started doing it at Athenahealth.

**中文翻译:**
我认为在过去的几年里，我们确实看到了产品运营开始蓬勃发展。它确实起源于你提到的一些大公司，比如 Uber。Uber 的产品运营负责人、也是该职能的创始人 Blake Samic，是我们书中的一个案例研究对象，他后来在 Stripe 也做了同样的事，现在他在 OpenAI 负责这个。所以你提到这三家公司很有趣，因为那正是 Blake 的手笔。我们看到了一个很好的转变：从人们私下议论产品运营，到现在的广泛接受。我记得 2018 年写第一本书《走出构建陷阱》时就提到了它，因为当时我们刚开始在 Athenahealth 实践。

**(00:04:49):**
I saw this as a really big issue in trying to make a complete product management function there and especially at scale. We had 365 product teams. We were trying to figure out how does this all come together, and product operations for me was a key part of it. So when I had first written it into that book, a lot of people were like, "Oh, what is this thing? I think we need it. Do we need more?" and that's what got us to start writing this book. Since then, I've seen a lot more companies coming out and either making more mature product operations teams that started probably before that or actually introducing them now.

**中文翻译:**
我当时意识到，在建立完整的产品管理职能时，尤其是在规模化的情况下，这是一个非常大的问题。我们当时有 365 个产品团队。我们试图弄清楚如何将这一切整合在一起，而产品运营对我来说是其中的关键部分。所以当我第一次把它写进那本书时，很多人都在问：“哦，这是什么东西？我想我们需要它。我们需要更多信息吗？”这就是促使我们开始写这本书的原因。从那时起，我看到越来越多的公司出现，要么是让之前成立的产品运营团队变得更成熟，要么是现在开始引入这个职能。

---

### [00:05:21] Lenny

**English:**
I guess maybe thinking about just tech companies, if you had to put a number on some rough percentage of interesting fast-growing, hyper growth, these startups, is there a percentage you'd put on how many of them have a product ops person at this point?

**中文翻译:**
如果只考虑科技公司，如果你必须给出一个大致的百分比，在那些有趣的、快速增长的、超高速增长的初创公司中，目前有多少比例拥有产品运营人员？

---

### [00:05:34] Melissa Perri

**English:**
We don't have a hard and fast number, I'll say that on this, but we have seen that. Let's take a sampling of maybe something that I know better. When I teach CPO accelerator, when I teach people in these cohorts, out of the 20, 25 people that we'll have in a cohort, I'd say at least half of them have somebody doing something product ops related. It might not be a mature function, it might just be one person on it, but at least half of them have somebody doing something.

**中文翻译:**
关于这一点，我必须说我们没有一个确切的数字，但我们确实观察到了这种趋势。拿我比较熟悉的例子来说吧。当我教授“CPO 加速器”课程时，在每期 20 到 25 人的学员中，我敢说至少有一半的人所在的公司已经有人在做与产品运营相关的工作了。这可能还不是一个成熟的职能部门，可能只有一个人在负责，但至少一半的公司已经有人在行动了。

---

### [00:06:06] Denise Tilles

**English:**
That's a good yardstick because I teach a product operations masterclass for Produx Labs with Melissa, and it's been interesting. I do some pre-work and try to understand where folks are in the products journey. When we started offering this class in 2020, about 60% were products curious. As time has gone on, it's really gone down and people have started to add it. They just want to understand what's the best way to optimize it. So I would say it's gone from that level to, say, probably 60% of them do have it now and then want to understand how to optimize it.

**中文翻译:**
这是一个很好的衡量标准。我和 Melissa 一起在 Produx Labs 教授产品运营大师课，过程非常有趣。我会做一些前期工作，了解大家在产品历程中所处的位置。2020 年我们刚开始开这门课时，大约 60% 的人只是对产品运营“感到好奇”。随着时间的推移，好奇的比例下降了，因为人们已经开始落地了。他们现在只想知道优化它的最佳方法。所以我会说，情况已经从那个阶段发展到：大概 60% 的人现在已经拥有了这个职能，并希望了解如何去优化它。

---

### [00:06:41] Lenny

**English:**
Do you have a sense of when this started to inflect and become such a common thing? When I was a product manager, I had no product ops person. So it's really fascinating to me to learn about this emergence. I know there's probably not a date, but just it sounds like maybe after your last book was published. Is there a timeframe of this became a thing? Is it this guy you mentioned that's now at OpenAI that started spreading it?

**中文翻译:**
你有没有感觉到这个趋势是从什么时候开始出现拐点并变得如此普遍的？当我还是产品经理时，根本没有产品运营人员。所以了解这种新兴事物对我来说非常迷人。我知道可能没有一个确切的日期，但听起来像是在你上一本书出版之后。有没有一个大致的时间框架？是那个你提到的现在在 OpenAI 的人开始推广它的吗？

---

### [00:07:01] Melissa Perri

**English:**
Blake, I think, was one of the people at the beginning who was talking about it the most and he's done a lot of work, I think, to push product operations and tell people about it. So that was great. I know Pendo has been speaking about product ops a little bit more and that's where I started to notice that it was picking up steam. I think around 2019 is when Pendo started talking about product operations. So it was roughly right after my book came out that I saw more people speaking about it and now they're trying to figure out, "Do we standardize it? What do we need? How does this actually look like in organizations?" but I think it's been probably a good five years of now hearing people doing it in realtime.

**中文翻译:**
我认为 Blake 是早期谈论这个话题最多的人之一，他在推动产品运营和向大众普及方面做了很多工作。这非常棒。我知道 Pendo 也一直在谈论产品运营，那是我开始注意到它势头渐猛的时候。我想大概是在 2019 年左右，Pendo 开始讨论产品运营。所以大致是在我的书出版后不久，我看到更多人开始谈论它。现在大家都在试图弄清楚：“我们要标准化它吗？我们需要什么？它在组织中到底长什么样？”但我认为，听到人们实时地在实践它，大概已经有五年时间了。

---

### [00:07:41] Lenny

**English:**
Awesome, and it sounds like maybe just in the last few years it started to really take off. We actually had Christine from Pendo on the podcast talking about product ops about a year ago at this point. So this is a great followup to a lot of that. Before we talk about what is product ops and what are the functions, what would you say are the biggest benefits to a company having a product ops role and also just what's a sign that you should probably seriously consider bringing on a product ops person and starting to invest in that area?

**中文翻译:**
太棒了，听起来可能就在过去几年里它才真正开始腾飞。大约一年前，我们邀请过 Pendo 的 Christine 在播客上谈论产品运营。所以这次访谈是对那次内容的极好后续。在我们讨论什么是产品运营及其具体职能之前，你认为公司拥有产品运营角色的最大好处是什么？另外，什么样的信号表明公司应该认真考虑引入产品运营人员并开始在该领域投资？

---

### [00:08:08] Denise Tilles

**English:**
It's really about helping the product managers focus on what they were actually hired for, the strategic work. In my role on the operating side and managing teams and Melissa as well, more and more product managers are taking on the data, harvesting the data, implementation and just to get data to work with, they're spending 20%, 30% of their time. So what would that look like if they were enabled and had all of those great inputs to actually focus on company growth, achieving the value, achieving the scaling goals that the company had? So it's really about helping them focus on what they were hired for.

**中文翻译:**
这实际上是为了帮助产品经理专注于他们被雇佣的初衷：战略性工作。在我的运营角色和团队管理经验中，Melissa 也是如此，我们发现越来越多的产品经理在承担数据处理、数据采集和实施工作。仅仅为了获得可用的数据，他们就花费了 20% 到 30% 的时间。那么，如果他们能获得赋能，拥有所有这些优质的输入，从而真正专注于公司增长、实现价值和达成公司的规模化目标，那会是什么样子？所以，这核心在于帮助他们专注于本职工作。

---

### [00:08:48] Lenny

**English:**
Again, when I was a PM, I had no product ops person, and having read your book, basically all the things product ops does is stuff PMs historically have done. To me, it's scary to give up all those things and put them on someone else's plate. There's the ideal of, "Oh, amazing, I don't have to do all these things. I'll focus on things I really get excited about," but there's also this new fear of, "Oh, someone else is going to take these things and maybe they won't do as well. There's this new process I have to think about. There's new lines of communication." So what's your biggest pitch to a product manager starting to hear about product ops and this fear of like, "Oh, man, my job is going to be weird. This new person I have to deal with all the time. I used to do all these things." How do you help a PM get excited about this?

**中文翻译:**
再说一次，当我还是 PM 时，没有产品运营。读了你们的书后，我发现产品运营做的基本上都是 PM 历来在做的事情。对我来说，放弃所有这些事情并把它们交给别人处理是有点令人害怕的。理想的情况是：“噢，太棒了，我不用做这些杂事了，我可以专注于让我兴奋的事情。”但也会有新的恐惧：“噢，别人会接手这些事，万一他们做得不好怎么办？我还要考虑新的流程，还有新的沟通渠道。”所以，对于那些刚听说产品运营并感到恐惧（比如“天哪，我的工作会变得很奇怪，我得一直和这个新人打交道，以前这些都是我做的”）的产品经理，你们最大的说辞是什么？你们如何帮助 PM 对此感到兴奋？

---

### [00:09:30] Melissa Perri

**English:**
Product operations does not take away decision making rights from the product manager. It's there to inform them. So if you're judging your success as a product manager of, "Hey, I do the SQL queries and I have to spend the 50 hours to set up all these customer interviews and calls," that to me is very operational process type work, but it's not work that's going to help you make a decision about your product. That's why we're looking at the product operations team because what I've seen is product managers doing this off the side of their desk like me too. I got excited about this because when I was at OpenSky in early days of my product management career, I had to go learn MongoDB to get data out of a database. I was sitting through a MongoDB class learning how to do this. I knew SQL, but we did not use the SQL database then. I had to go learn MongoDB so I would stop bothering the engineers to be able to actually just measure if my products and my features were doing anything correct.

**中文翻译:**
产品运营并不会剥夺产品经理的决策权。它的存在是为了给决策提供信息。如果你衡量产品经理成功的标准是“嘿，我会写 SQL 查询，我花了 50 个小时安排所有的客户访谈和电话”，那在我看来是非常事务性的流程工作，而不是能帮你对产品做出决策的工作。这就是为什么我们需要产品运营团队。我看到很多产品经理像我以前一样，在处理本职工作之余兼顾这些杂事。我之所以对这个话题感兴趣，是因为在我职业生涯早期的 OpenSky 工作时，我不得不去学习 MongoDB 才能从数据库中提取数据。我当时坐在 MongoDB 的课堂上学习。我懂 SQL，但我们当时不用 SQL 数据库。我必须学 MongoDB，这样我就不用一直去烦工程师，才能衡量我的产品和功能是否运行正确。

**(00:10:27):**
That was a lot of time that I spent doing that instead of spending it on good feature work and on understanding my customers and working with my developers and figuring out what we were actually going to build, instead I'm out here learning this programming language, which I never used again, by the way. Never used it again after that. That to me is the stuff that product ops takes away from the product managers.

**中文翻译:**
我花了大量时间在那上面，而不是花在打磨功能、了解客户、与开发人员合作以及思考我们到底要构建什么。相反，我在这里学习这种编程语言——顺便说一下，我后来再也没用过它。那对我来说，就是产品运营应该从产品经理手中接管的事情。

**(00:10:51):**
What I constantly hear from product managers though is, "I am so busy, I don't have time to do the things that I need to do correctly. I'm so busy trying to line up customer interviews," or, "I'm so busy just trying to get data out of systems. I'm fighting these fights to get the things that I need to do my job correctly that I don't have time to do my job correctly," and that's what we're trying to help them with. So I wouldn't be afraid that product ops is coming in here. It's not supposed to be something that's providing more overhead. It's supposed to be something that's a little more liberating and helps free you up from all the busy work.

**中文翻译:**
但我经常从产品经理那里听到的是：“我太忙了，我没时间正确地做我该做的事。我忙着安排客户访谈，”或者“我忙着从系统里导数据。为了获得正确开展工作所需的东西，我一直在‘战斗’，以至于我没有时间去正确地开展工作。”这正是我们想要帮助他们解决的问题。所以，不要害怕产品运营的介入。它不应该是增加额外负担的东西，而应该是让你解脱、帮你从繁杂事务中抽身的东西。

---

### [00:11:26] Lenny

**English:**
That's a great pitch. I always thought product management is an insane role with way too much going on, and that's why everyone's always burnt out and stressed. There's just so many things you have to do. So I totally get how this is happening and why this is happening. I love that you're helping people figure out how to actually do it well. Let's actually get into what the role actually is. I think it's a really confusing role. A lot of people hear product ops and everyone know what it is. There's maybe research synthesis, there's some data stuff. What's the simplest way to think about what is the general consistent roles of a product ops person and what they can do for your company?

**中文翻译:**
这是一个非常棒的说辞。我一直觉得产品经理是一个疯狂的角色，事情太多了，这就是为什么大家总是精疲力竭、压力山大。要做的事情实在太多了。所以我完全理解为什么会发生这种变化。我很喜欢你们在帮助人们弄清楚如何真正做好这件事。让我们深入探讨一下这个角色到底是什么。我认为这是一个非常令人困惑的角色。很多人听到“产品运营”，每个人都有不同的理解。可能包括研究综述，可能包括一些数据工作。关于产品运营人员的一般性、持续性的职责，以及他们能为公司做些什么，最简单的思考方式是什么？

---

### [00:12:03] Denise Tilles

**English:**
The way we think about it is structured around the three pillars that we talk about in the book, so business and data insights, more of the quantitative side, making sure that the product manager has all of these engagement and revenue inputs to make smart decisions, the customer market insights, so the qualitative. We talked about this a little bit earlier in terms of finding folks to speak to, making sure you're speaking to more than one just customer. Finally, the third pillar is process and practices. So it's really around those areas and it depends on what your company needs and where the biggest opportunities and challenges might be.

**中文翻译:**
我们的思考方式是围绕书中所说的“三大支柱”展开的。第一是**业务与数据洞察**，更多偏向定量方面，确保产品经理拥有所有这些参与度和收入数据，从而做出明智的决策。第二是**客户与市场洞察**，即定性方面。我们之前提到过，比如寻找访谈对象，确保你不只是在听一个客户的意见。最后，第三大支柱是**流程与实践**。所以，它主要围绕这些领域展开，具体取决于你公司的需求以及最大的机会和挑战在哪里。

---

### [00:12:43] Lenny

**English:**
Awesome. So the three, just to reshare what you just said, the three pillars of product ops, business, data and insights, customer and market insights and the process of how you build product and helping the business operate more effectively in the way they build product.

**中文翻译:**
太棒了。所以这三个支柱，重复一下你刚才说的：产品运营的三大支柱是业务、数据与洞察；客户与市场洞察；以及构建产品的流程，即帮助企业在构建产品的方式上更有效地运作。

---

### [00:13:00] Denise Tilles

**English:**
Sounds great when you say it. Yes.

**中文翻译:**
你这么一说听起来很棒。是的。

---

### [00:13:03] Lenny

**English:**
I have the notes and this is exactly described in your book, so well-described. Is there one of these three that you find most important, impactful? Is it really dependent on the business and their needs or what the PM wants to do? How do you think about, I don't know, which of these three is maybe most important or is it a super dependent?

**中文翻译:**
我有笔记，这在你们书里描述得非常清楚。在这三者中，你觉得哪一个最重要、最有影响力？它是完全取决于业务及其需求，还是取决于 PM 想做什么？你如何看待这三者中哪一个可能最重要，还是说这完全取决于具体情况？

---

### [00:13:20] Melissa Perri

**English:**
So we usually see that high growth companies start with business data and insights and make sure that they can actually monitor what they're doing and get the strategic inputs. We see larger companies and enterprises go more towards the process and governance, especially if they're in, let's say, a transformation because they don't have the infrastructure to run good product. Let's say it's that way. They're usually just starting out, they're just forming their teams. Let's say they just trained product managers and now they're like, "What else do we need to do besides just training product managers to make this work?" So they need an operating model and they typically don't have a product operating model.

**中文翻译:**
我们通常看到，高增长公司会从“业务数据与洞察”开始，确保他们能够实际监控自己的行为并获得战略输入。而大型公司和企业则更多地转向“流程与治理”，特别是如果他们正处于转型期，因为他们缺乏运行优秀产品的基础设施。通常他们才刚刚起步，正在组建团队。假设他们刚刚培训完产品经理，现在在想：“除了培训产品经理，我们还需要做什么才能让这一切运转起来？”所以他们需要一个运营模型，而他们通常没有“产品运营模型”。

**(00:13:58):**
In that case, they're looking at even just, "How do we do roadmaps across the organization so that I as a chief product officer or VP of product can actually just have transparency into what my teams are doing?" Jira does not work for that. You need a portfolio tool to be able to roll that up into something that makes sense. Again, that helps me as a VP now or a CPO make strategic decisions and it helps me monitor my teams and understand, "Are we actually spending money on the right things? Are we doing the right work?" So they tend to do it more on the process and governance side, but it's all in service of being able to make rapid strategic decisions and get good products out there to the world.

**中文翻译:**
在这种情况下，他们甚至只是在考虑：“我们如何在整个组织中制定路线图，以便我作为首席产品官（CPO）或产品副总裁能够透明地了解我的团队在做什么？”Jira 无法实现这一点。你需要一个投资组合工具（Portfolio Tool）来将这些内容汇总成有意义的东西。同样，这能帮助现在的副总裁或 CPO 做出战略决策，帮助我监控团队并了解：“我们是否真的把钱花在了正确的事情上？我们做的工作对吗？”所以，他们倾向于在流程和治理方面做得更多，但这一切都是为了能够做出快速的战略决策，并将优秀的产品推向世界。

---

### [00:14:40] Lenny

**English:**
That's a really handy way of thinking about it. So just to say what you said again, for high growth companies, you're finding of these three pillars generally where product ops can help most is the business and data insights, helping them understand what's happening and make decisions more quickly, which makes a lot of sense. For more established older companies going through a digital transformation, oftentimes it's helping them with their process and making them more efficient in how they operate. Is there also a bucket for the middle pillar of customer and market insights or is that spread across?

**中文翻译:**
这是一个非常实用的思考方式。重复一下你的话：对于高增长公司，你发现产品运营在“业务和数据洞察”支柱上帮助最大，帮助他们了解现状并更快做出决策，这非常有道理。对于正在进行数字化转型的老牌成熟公司，通常是帮助他们优化流程，提高运营效率。那么，中间那个“客户与市场洞察”的支柱是否也有专门的归类，还是说它分散在各处？

---

### [00:15:11] Denise Tilles

**English:**
That's the squishy middle. When I do teach this class, I ask people what their perception is of product ops and people never think that. So that's an area definitely for growth I think at a lot of companies.

**中文翻译:**
那是“模糊的中间地带”。当我教这门课时，我会问大家对产品运营的看法，人们从来不会想到这一点。所以我认为，对很多公司来说，这绝对是一个有待增长的领域。

---

### [00:15:26] Lenny

**English:**
How does that piece work with user research and that team?

**中文翻译:**
那部分工作如何与用户研究（User Research）团队协作？

---

### [00:15:30] Melissa Perri

**English:**
So we've seen a lot of the work that is done in that team. They work with user research. Now, in organizations where let's say, this happens in a lot of organizations but not all of them, where product oversees design as well and user research and it oversees UX, this becomes seamless because you are going to have, let's say, a product ops person usually with a user research background who's going to be helping to do the stuff we talk about and the customer market insights piece, which is pulling all the research that's been done, like the customer interviews, all those things together into things like a findings database. So there's great tools out there like Dovetail, but you can also roll your own, and it's about aggregating all the interviews or customer research that's been done so people can query it and start to see what do we already know so we're not going out there and duplicating a bunch of research.

**中文翻译:**
我们已经看到了那个团队所做的很多工作。他们与用户研究部门合作。在一些组织中（很多但不是全部），产品部门同时也监管设计、用户研究和 UX，这时协作就会变得无缝。比如，你会有一个通常具有用户研究背景的产品运营人员，他会帮助处理我们提到的“客户市场洞察”部分，即把所有已完成的研究（如客户访谈等）整合到“发现数据库”中。现在有很多好工具，比如 Dovetail，你也可以自己开发。核心在于汇总所有的访谈或客户研究，以便人们可以查询并了解“我们已经知道了什么”，这样我们就不会盲目地去做重复的研究。

**(00:16:22):**
It's also about finding participants who want to opt into research. So making sure that you have customers aware that, "Hey, we might contact you to do customer interviews. This is why. Do you want to participate in alphas and betas? If so, this is what it entails." If we can build a database of people and customers that we have who opt into those types of things, it makes it easier for product managers to go out and contact them and say, "Hey, by the way, we got a beta. Do you want to do it?" They know what it is, they're expecting it. They know what the cadence is that people will reach out to them on to do research, and the user researchers can use that as well.

**中文翻译:**
这还涉及到寻找愿意参与研究的受访者。确保客户知晓：“嘿，我们可能会联系你进行客户访谈。原因是这样的。你想参加 Alpha 或 Beta 测试吗？如果想，具体流程如下。”如果我们能建立一个由愿意参与此类活动的客户组成的数据库，产品经理就更容易联系他们并说：“嘿，顺便说一下，我们有一个 Beta 版，你想试试吗？”客户知道这是怎么回事，也有心理预期。他们知道人们联系他们做研究的频率，用户研究员也可以利用这个资源。

**(00:16:58):**
Now, the thing about the customer and market insights piece is that that person who's streamlining those activities and building those systems, they're not usually the same person who's doing the user research. So this is not about taking user research away from product managers or from user researchers, it's about enabling them to do it more effectively, enabling the insights to be put out across the company more effectively, and also helping them get in touch with users and get that feedback.

**中文翻译:**
关于“客户与市场洞察”这一点，需要明确的是：负责简化这些活动和构建这些系统的人，通常不是实际去做用户研究的人。所以，这并不是要从产品经理或用户研究员手中夺走研究工作，而是赋能他们更有效地开展研究，让洞察在公司内部更有效地传播，并帮助他们联系用户以获取反馈。

**(00:17:30):**
Another piece of this too that we talk about is getting qualitative insights from sales and support. So we always hear from sales teams, and this is the classic product management tension, "The product managers aren't listening to me" or, "I've told them five months ago that I had this problem with these customers that were going to churn." We didn't build those features. What this function does with the customer and market insights here is that it helps get a lot of that information back to the product team in an effective way.

**中文翻译:**
我们讨论的另一个部分是从销售和支持部门获取定性洞察。我们总能听到销售团队的抱怨，这是经典的产品管理张力：“产品经理不听我的”或者“我五个月前就告诉过他们，这些客户有流失风险。”但我们没做那些功能。产品运营在“客户与市场洞察”方面的作用，就是帮助将大量此类信息以有效的方式反馈给产品团队。

**(00:18:00):**
Then it also helps communicate back to sales, "Hey, let's be a little transparent about how we're using that feedback." So that's how we can communicate it back in strategy. Let them know where we stand with working on those ideas or solving those problems for customers, but usually, there's a wealth of qualitative information stuck somewhere in our organization systems, whether it's in Salesforce, whether it's in support tickets, in somebody's Google doc of their customer interviews that they've been doing, and what we're trying to do is get that out of these individual systems and into somewhere where a lot of people can take those qualitative insights and start to learn from them.

**中文翻译:**
然后它还有助于向销售部门反馈：“嘿，让我们透明地说明我们是如何使用这些反馈的。”这就是我们如何在战略中进行回传。让他们知道我们在处理这些创意或解决客户问题方面的进展。通常，组织系统中到处都堆积着丰富的定性信息，无论是在 Salesforce、支持工单，还是某人记录客户访谈的 Google 文档里。我们尝试做的就是将这些信息从孤立的系统中提取出来，放入一个大家都能获取这些定性洞察并从中学习的地方。

---

### [00:18:36] Lenny

**English:**
People always ask me, "What's changing in product management? What's the future of product management?" I'm always like, "Nothing. It's going to be basically the same. It's just never going to be fully defined. It's going to keep doing this weird role," but I feel like this is actually the answer. What's changing in product management is this product ops role is emerging, taking a lot of these things that PMs don't necessarily want to be doing or aren't amazing at and giving you more space to do the things they really want to do. So I think that's pretty amazing. I think if you think about the timeline, you said five years ago there was no real product ops. Today, half of companies essentially have a product ops role and I'm guessing in another few years it'll be much higher. So this is really interesting.

**中文翻译:**
人们总问我：“产品管理正在发生什么变化？产品管理的未来是什么？”我总是回答：“没什么变化。基本上还是一样。它永远不会被完全定义，会一直扮演这个奇怪的角色。”但我现在觉得，这（产品运营）其实就是答案。产品管理的变化在于产品运营角色的兴起，它接手了许多 PM 不一定想做或不擅长做的事情，从而为你腾出更多空间去做真正想做的事。我觉得这太神奇了。如果你回想一下时间线，你说五年前还没有真正的产品运营。今天，基本上有一半的公司都有了产品运营岗位，我猜再过几年，这个比例会更高。这真的很有趣。

---

### [00:19:12] Melissa Perri

**English:**
I'm excited about it too. I think what we saw before was that, like you were saying, product management was this squishy role for a long time, but now we're standardizing what do product managers do. What's happening, I think, though is product managers become more prevalent, and as people realize that this is a critical role for companies, whether you're a software company or a bank or something else. We build businesses off of software in today's world and if you're not building software, you are behind. With more and more software that we're putting out there, product managers don't have time to go do all these things off the side of their desk and it's fine when you're a small startup. I was doing it too. Like I said, I had to go learn MongoDB when I was in a smaller company, and then we start to scale and I've got more and more product responsibility and I'm like, "I don't have time to go learn MongoDB now," and that's where people start to burn out and where they get frustrated, like you said.

**中文翻译:**
我也对此感到兴奋。我认为我们以前看到的是，正如你所说，产品管理长期以来一直是一个模糊的角色，但现在我们正在标准化产品经理的工作内容。我认为正在发生的是，产品经理变得越来越普遍，人们意识到这对于公司来说是一个关键角色，无论你是软件公司、银行还是其他行业。在当今世界，我们依靠软件建立业务，如果你不构建软件，你就落后了。随着我们推出的软件越来越多，产品经理没有时间去处理那些琐碎的杂事。当你是一家小型初创公司时，这没问题。我也做过这些事。就像我说的，我在小公司时不得不去学 MongoDB，但当我们开始规模化，我的产品职责越来越多，我就想：“我现在没时间去学 MongoDB 了。”这就是人们开始职业倦怠和感到沮丧的原因，正如你所说。

**(00:20:09):**
We've got more and more systems, we've got more software tools out there that product managers are using, and it becomes a lot to track. So it's either, for companies, do you want to hire 10,000 product managers and let them all do these things off the side of their desk and then concentrate on strategic work 30% of the time or do you want them concentrating on strategic work majority of the time and then help build a product operations team around them that can create these shared systems and this infrastructure to allow them to work better?

**中文翻译:**
我们拥有的系统越来越多，产品经理使用的软件工具也越来越多，需要追踪的东西变得非常多。所以对于公司来说，要么你雇佣 1 万名产品经理，让他们在处理杂事之余只花 30% 的时间专注于战略工作；要么你让他们大部分时间专注于战略，并围绕他们建立一个产品运营团队，创建共享系统和基础设施，让他们工作得更好。

---

### [00:20:39] Lenny

**English:**
I think that's such a powerful way of thinking about this. I imagine PMs listening to you saying, "I don't have to learn MongoDB and SQL anymore," would think. Actually, no, I think that's good. They should learn to do SQL and run their own data, but I think the important pieces here, yes, it would be great, but as you scale, it becomes harder and harder to have time to do all that because things ... You end up with other work that you need to be doing. So in theory, it would be awesome if your PMs could run their own queries and do their own research and create the whole process, but it just becomes harder and harder.

**中文翻译:**
我认为这是一种非常有力的思考方式。我能想象 PM 们听你这么说会想：“我再也不用学 MongoDB 和 SQL 了。”其实，不，我觉得学这些是好事。他们应该学会 SQL 并运行自己的数据。但这里的重点是，虽然这很棒，但随着规模扩大，腾出时间做这些事变得越来越难，因为你最终会有其他必须完成的工作。所以理论上，如果 PM 能自己运行查询、自己做研究并创建整个流程，那当然太棒了，但这只会变得越来越难实现。

**(00:21:12):**
It reminds me of a lot of companies that are trying to delay hiring a product manager in general and instead giving the role to engineers and designers. My feedback is always like, "That's great as long as they want to be doing all these things that are not generally what they enjoy doing," like an engineer doesn't necessarily love running meetings and writing one pagers and strategy docs and taking notes. So I think it's a similar thing where, sure, it's great until you don't really want to be doing that or you don't have time for that and you have your actual job you need to be doing.

**中文翻译:**
这让我想起很多公司试图推迟招聘产品经理，而是把这个角色交给工程师和设计师。我的反馈总是：“这很好，只要他们愿意做那些通常不是他们喜欢做的事情。”比如，工程师不一定喜欢主持会议、写单页文档（one-pagers）、写战略文档和做笔记。所以我觉得这是类似的情况：当然，这在一段时间内很棒，直到你真的不想再做那些事，或者你没时间做，因为你有自己的本职工作要完成。

---

### [00:21:41] Denise Tilles

**English:**
That's your full-time job and your OKRs and your goals are really around the outcomes for the company, you're like, "But I wrote 20 scripts this year." So we need to help them focus on the things that they're being expected to deliver in terms of value.

**中文翻译:**
那是你的全职工作，你的 OKR 和目标实际上是围绕公司的成果展开的，你可能会说：“但我今年写了 20 个脚本。”所以我们需要帮助他们专注于那些被期望交付的价值。

---

### [00:21:56] Melissa Perri

**English:**
I also think it's funny how many people want to be a product manager until they realize what product management entails. This happens a lot and I saw it with my MBA students at Harvard too. We do a whole class, they play a product manager. I had a lot of people opt out of being a product manager at the end of it. They were like, "I did not realize it was like that. I did not realize I had to do so many things." I think a lot of what gets them as well is the type of context switching that's required as a product manager. So you already, just with the basis of what we have to do, do so many different things of user research, working with the designers, working with the developers, working with executives, working with different stakeholders. You got to context switch to be able to relate to all them. You got to empathize with all these different people. You have to do all these different tasks to do this type of work.

**中文翻译:**
我也觉得很有趣，有那么多人想当产品经理，直到他们意识到产品管理到底意味着什么。这种情况经常发生，我在哈佛的 MBA 学生身上也看到了。我们上了一整节课，让他们扮演产品经理。最后很多人选择了放弃。他们说：“我没意识到是这样的。我没意识到我得做这么多事。”我认为让他们受不了的还有产品经理所要求的“上下文切换”（context switching）。仅仅是基础工作，你就得做这么多不同的事：用户研究、与设计师合作、与开发人员合作、与高管合作、与不同的利益相关者合作。你必须切换思维模式才能与所有人沟通。你必须与所有这些不同的人产生共鸣。你必须完成所有这些不同的任务才能开展这类工作。

**(00:22:46):**
Then you got to go figure out what template to put your roadmap in, which is going to be different template than the other 80 product managers on your team because somebody didn't come in and just say, "Hey, we're going to use this." That type of work to me is just distracting from it. Is it hard for a product leader to just be like, "Hey, this is a template we're using"? No, but then if that product leader has to go out and train 80 other people on that template, make sure it's consistently updated all the time, make sure it's in the right formats, make sure it's in the right software, that is where the overhead comes in, and a lot of product leaders are doing this right now and what we're trying to do is free up individual product managers, but also those product leaders.

**中文翻译:**
然后你还得去琢磨用什么模板来写路线图，而这个模板可能和你团队中其他 80 个产品经理用的都不一样，因为没人站出来说：“嘿，我们就用这个。”这种工作在我看来纯粹是分心。产品领导者说一句“嘿，这就是我们要用的模板”很难吗？不难，但如果那个领导者必须去培训其他 80 个人使用那个模板，确保它一直保持更新，确保格式正确，确保在正确的软件里运行，这就是额外开销产生的地方。现在很多产品领导者都在做这些事，而我们想做的是解放每一位产品经理，同时也解放那些产品领导者。

**(00:23:33):**
So I work with all these CPOs, these VPs of product and they're like ... I see them just not working on strategy. I'm like, "Why are you not working on strategy?" and they're like, "I don't have time to do that. I'm in here stopping all these fires. I'm figuring out what template I should put my roadmap in." Like I said, it's not hard. They know what template it should be in, but think about if you now can delegate that to somebody else and say, "I want it in this template. Go roll it out. Go roll it out, go train everybody on it, find the right software for it, do it." It frees those people up, the leaders, to go work on strategy. That's why you're spending so much money for a product leader, anyway. That's why you spend so much money for a product manager, anyway. So to me, these things are not impossible to do. It's just do we have the right people doing them?

**中文翻译:**
我与这些 CPO、产品副总裁合作，我发现他们根本没在研究战略。我问：“你为什么不研究战略？”他们回答：“我没时间。我忙着到处救火。我正忙着琢磨路线图该用什么模板。”就像我说的，这并不难，他们知道该用什么模板，但想想看，如果你现在可以把它委托给别人并说：“我想要这个模板。去推行它吧。去培训所有人，找到合适的软件，把它搞定。”这就能让领导者腾出时间去研究战略。反正你花那么多钱雇产品领导者就是为了这个。你花那么多钱雇产品经理也是为了这个。所以对我来说，这些事情并非不可能完成，只是我们是否安排了合适的人去做？

---

### [00:24:23] Lenny

**English:**
For PMs that are trying to figure out what remains on their plate, what are the the pieces that a PM should keep and not offload on a product ops person?

**中文翻译:**
对于那些试图弄清楚自己还剩下什么工作的 PM 来说，有哪些部分是 PM 应该保留、而不应该卸载给产品运营人员的？

---

### [00:24:33] Melissa Perri

**English:**
They don't want to offload decision rights. You should never be outsourcing your decision making to a product ops person. That's not the point. They're the product manager for the product managers. That's how I think about it. So their decision should be around, "How do I operationalize great product management here?" but as a product manager, you shouldn't be delegating to them to make any decisions about their product, and that's not their job. If they are coming to you and saying, "You should build this," that's not their job either. That's not the right thing.

**中文翻译:**
他们不应该卸载决策权。你永远不应该把决策权外包给产品运营人员。那不是重点。产品运营是“产品经理的产品经理”。我是这么看的。所以他们的决策应该是围绕“我如何在这里实现卓越的产品管理运营？”但作为产品经理，你不应该授权他们对你的产品做出任何决策，那不是他们的工作。如果他们跑来对你说“你应该构建这个”，那也不是他们的职责。那是不对的。

**(00:25:03):**
So making the actual decision and then putting that decision into play with your teams, that's the type of work that you want to hold onto for a product manager. So while a product ops person can help you point you in the right direction, let's say, to find customers, maybe even help you get in touch with the customers, send out the email to invite them to a meeting or operationalize that, hopefully that's automated. I would love a product ops person to automate that type of stuff. You are going to be doing the user research. The product ops person you can go to and maybe say, "Hey, this is the type of problems that we're understanding," and maybe they help you find other pieces of information around the organization on those topics and bring it to you, but they're not going to be the ones reading through all this information and being like, "You should build this."

**中文翻译:**
所以，做出实际决策并将其在团队中付诸实施，这是产品经理需要保留的工作。虽然产品运营人员可以帮你指明方向，比如寻找客户，甚至帮你联系客户、发送会议邀请邮件或将其流程化（希望是自动化的，我希望产品运营能把这些事自动化），但用户研究还是得由你来做。你可以去找产品运营人员说：“嘿，这是我们正在了解的问题类型，”也许他们会帮你寻找组织内部关于这些主题的其他信息并提供给你，但他们不会是那个阅读所有信息然后告诉你“你应该构建这个”的人。

**(00:25:49):**
They're also not going to be the ones who you say, "Hey, I made this decision about what to build, told the team about it, the team got together. Can you go monitor the developers and make sure they're building it on time?" No, they're not project managers, they're not the people who are going to be on top of your developers watching them build things, making sure that everything's out on time. That's not their role either. They're not going to handle hard stakeholder conversations about trade-offs for you, all of those things that you are going to want to keep ownership of because at the end of the day as a product manager, your job is to produce outcomes and you do need to make sure that you're monitoring those outcomes and moving towards them. You don't want to offload their responsibility.

**中文翻译:**
他们也不是那种你会对他说“嘿，我已经决定要建什么了，也告诉团队了。你能去盯着开发人员，确保他们按时完成吗？”的人。不，他们不是项目经理，他们不会盯着你的开发人员看他们写代码，确保一切按时发布。那也不是他们的角色。他们也不会替你处理关于权衡（trade-offs）的艰难的利益相关者对话。所有这些事情你都想保留所有权，因为归根结底，作为产品经理，你的工作是产生结果，你确实需要确保自己在监控这些结果并朝着目标迈进。你不想卸下这些责任。

---

### [00:26:31] Lenny

**English:**
So I took a couple notes of just things that the PM continues to own, whatever, in quotes, no one owns anything, strategy, vision, prioritizing, resource allocation, trade-off decisions, hard conversations around trade-offs and stakeholder input and things like that. Is there anything else in that bucket of just stuff a PM, a product manager continues to be responsible for?

**中文翻译:**
所以我记了几条 PM 继续“拥有”（引号里的，毕竟没人真正拥有一切）的东西：战略、愿景、优先级排序、资源分配、权衡决策、围绕权衡和利益相关者输入的艰难对话等等。在 PM 继续负责的事情清单里，还有其他的吗？

---

### [00:26:55] Denise Tilles

**English:**
Well, there's a big piece that we're missing, go-to-market, and that's where product ops could really make a difference in terms of connecting those teams, but also being the first point of contact for sales, first point of contact for product, and enabling just some efficiencies if we want to call it process or method, but just trying to help break down the silos.

**中文翻译:**
嗯，我们漏掉了一个重要的部分：进入市场（Go-to-market）。产品运营在连接这些团队方面确实可以发挥作用，同时也可以作为销售的第一联系点、产品的第一联系点，并提高效率（如果我们想称之为流程或方法的话），核心是尝试打破部门墙（silos）。

**(00:27:19):**
A company I'm working with right now, there's big challenge with that and it's a large enterprise level company. So how do we break down all of the different silos between departments and team leads and whatnot? So it's really talking about, "Here's how we're going to do it. Here's some simple templates we will use at training sales, training product," and then getting that into play. Doing the book and doing our research, that was a consistent story point from a lot of people that we interviewed that go-to-market was a really big pain point.

**中文翻译:**
我目前合作的一家公司就面临着巨大的挑战，那是一家大型企业级公司。我们如何打破部门、团队负责人等之间所有不同的隔阂？所以这实际上是在讨论：“我们将这样做。这是我们在培训销售和产品部门时会用到的一些简单模板，”然后将其付诸实践。在写书和做研究的过程中，我们采访的很多人都一致认为，进入市场（GTM）是一个非常大的痛点。

---

### [00:27:50] Melissa Perri

**English:**
So I think too what Denise was saying is product ops will take on a lot of the coordination of those types of things and making the standardized templates, but as a product manager, your role in informing what the go-to-market is doesn't change. You're still putting the inputs in there. So maybe product ops will provide, for example, templates and help say, "Hey, here's the different pieces that we need to make a go-to-market plan," for example, "Here's the templates. Here's what I gathered from people," but you as a product manager still have to fill out your parts.

**中文翻译:**
所以我认为，正如 Denise 所说，产品运营将承担大量此类事务的协调工作并制作标准化模板，但作为产品经理，你在提供进入市场方案信息方面的角色并没有改变。你仍然需要提供输入。例如，产品运营可能会提供模板并说：“嘿，这是我们制定进入市场计划所需的各个部分，这是模板，这是我从大家那里收集到的信息，”但你作为产品经理仍然必须填写属于你的部分。

**(00:28:21):**
You still have to go talk to the salespeople. You still have to work with the marketing people to make sure it's positioned correctly, but the product ops person can help with the program management around it of getting those people together, having consistent templates, creating the cadence for when you review those things, making sure that they all align and they're all in one place so you're not going to find them everywhere, and then making sure that go-to-market process is consistent across the organization so that it's not like, as Denise said, it's not like everybody's reinventing the wheel and somebody on a go-to-market team has to figure out how to go-to-market differently with a different product team.

**中文翻译:**
你仍然需要去和销售人员交谈。你仍然需要与营销人员合作，确保定位正确。但产品运营人员可以提供项目管理方面的帮助：把这些人召集在一起，提供一致的模板，制定审查这些事项的节奏，确保它们都对齐并集中在一个地方（这样你就不用到处找了），然后确保整个组织的进入市场流程是一致的。这样就不会像 Denise 说的，每个人都在重复造轮子，或者进入市场团队的人必须针对不同的产品团队琢磨不同的进入市场方式。

---

### [00:28:57] Lenny

**English:**
Awesome. That's a really handy and important addition. You mentioned project management. I imagine many people think product ops also takes on project management. What's a good way to think about project management versus product ops? There's also program management. Do you have a way of thinking about those roles?

**中文翻译:**
太棒了。这是一个非常实用且重要的补充。你提到了项目管理（Project Management）。我想很多人认为产品运营也承担了项目管理的工作。区分项目管理和产品运营的好方法是什么？还有项目群管理（Program Management）。你对这些角色有自己的思考方式吗？

---

### [00:29:15] Denise Tilles

**English:**
The way I like to think about it is, however, whatever they're doing in terms of the three pillars of product ops is really thinking about, as I mentioned earlier, increasing the speed and quality of decision making and all of the pillars of play into that. Program manager, I think, is really thinking about larger company initiatives and the duration of their work is ongoing versus a project manager, they're responsible for certain project that's at a time box and an end date, but it does get a little wiffy, for sure.

**中文翻译:**
我的思考方式是：无论他们在产品运营的三大支柱方面做什么，核心都是我之前提到的——提高决策的速度和质量，所有的支柱都为此服务。我认为项目群经理（Program Manager）实际上是在考虑更大的公司级倡议，他们的工作持续时间是长期的；而项目经理（Project Manager）则负责特定的、有时间限制和截止日期的项目。当然，这两者之间确实会有一些模糊地带。

---

### [00:29:43] Lenny

**English:**
I want to go back to the three pillars real quick and go one level deeper to help people understand what they actually entail and what are the jobs of a product ops person. So just we could even keep this brief, but just let's say with business data and insights, what are the functions and jobs and things that a product ops person would be doing for your company?

**中文翻译:**
我想快速回到那三大支柱，并深入探讨一层，以帮助大家理解它们具体包含什么，以及产品运营人员的工作内容。我们可以简短一点，比如对于“业务数据与洞察”，产品运营人员会为公司承担哪些职能和工作？

---

### [00:30:02] Denise Tilles

**English:**
A lot of companies will have a data science team or a business intelligence team and you don't have to reinvent the wheel, you don't have to have your internal product ops type of intelligence team, but it's about connecting those and making sure you're putting that with a product lens, and especially, say, with finance too. You don't want all the product managers hitting up the CFO for that month's revenue or having questions. So it's about accessing all of these inputs and putting it through a product lens and then making sure that product managers actually know what to do with it, can action it.

**中文翻译:**
很多公司都有数据科学团队或商业智能（BI）团队，你不需要重复造轮子，不需要建立内部的产品运营专属智能团队。关键在于连接这些团队，并确保你用“产品视角”来审视数据，特别是与财务部门的对接。你不希望所有的产品经理都跑去问 CFO 当月的收入是多少或者提各种问题。所以，这关乎获取所有这些输入，通过产品视角进行处理，然后确保产品经理真正知道如何利用这些数据，并能将其转化为行动。

---

### [00:30:36] Lenny

**English:**
So it's essentially running queries for you, generating charts and graphs and recommendations based on what the data's telling you. Basically, it's doing all the data stuff that a PM would be doing. Is there anything else there?

**中文翻译:**
所以本质上是为你运行查询，根据数据告诉你的信息生成图表和建议。基本上，它承担了 PM 本来要做的大部分数据工作。还有其他的吗？

---

### [00:30:51] Melissa Perri

**English:**
Also helping the leaders too. So we're talking about it from a product management perspective, but I think this one especially becomes really critical for leaders and executives. A lot of times, and I sit through board meetings where we talk about ARR, we talk about retention, we talk about net retention, and we talk about all of these business metrics, and they're great for monitoring the health of our business, but where product ops comes into play in business data and insights is how do we monitor the health of our product.

**中文翻译:**
还要帮助领导者。我们是从产品管理的角度在谈论它，但我认为这一点对领导者和高管来说尤为关键。很多时候，我参加董事会会议，大家讨论 ARR（年度经常性收入）、留存率、净留存率以及所有这些业务指标。这些指标对于监控业务健康状况非常有用，但产品运营在“业务数据与洞察”中发挥作用的地方在于：我们如何监控产品的健康状况。

**(00:31:22):**
So as a chief product officer, ARR is interesting to me, but it's not as interesting to me as ARR by customer segment. It's not as interesting as ARR by product line. It's not as interesting if I take that and then look at it by retention or adoption by product or feature set or adoption by customer segment by product. When we start to put those lenses on it, they now become a really powerful strategy insight.

**中文翻译:**
作为首席产品官，ARR 对我有吸引力，但不如“按客户细分划分的 ARR”那么有吸引力。它不如“按产品线划分的 ARR”有吸引力。如果我把这些数据拿过来，再结合产品或功能集的留存率或采用率，或者按产品划分的客户细分采用率来看，那就更有趣了。当我们开始用这些视角去观察时，它们就变成了非常强大的战略洞察。

**(00:31:49):**
So what I think these people do and do really well is even at the executive level, they help you ... You as a product leader are like, "I need these types of insights. This helps me. This is how our business runs and this is how I want to set the strategy." These people make those dashboards, make those repeatable insights for you. Then ideally, they know the data so well and they know your business so well that they can surface up other opportunities for you as well to look at data that you didn't know was there or can find these interesting trends.

**中文翻译:**
所以我认为这些人做得非常出色的一点是，即使在执行层面，他们也能帮助你……你作为产品领导者会说：“我需要这类洞察。这能帮到我。这是我们业务运作的方式，也是我想制定战略的方式。”这些人会为你制作仪表板，提供可重复的洞察。理想情况下，他们非常了解数据和业务，甚至能为你挖掘出其他机会，让你看到以前没注意到的数据，或者发现有趣的趋势。

**(00:32:18):**
So they are very much like the people digging into the data, they're just doing it with more of a product lens instead of, like Denise said, an overall company metric lens. It's not just in service of the product managers. I just wanted to point that out because I think this becomes so powerful for leaders because if leaders don't understand those types of metrics, they can't actually monitor their strategies. They can't go back and say, "Oh, we decided to go upmarket into the enterprise." Look, we've got enterprise revenue, but are you actually looking at where the enterprises are adopting different product lines? Are you looking at how the enterprise uses different features, and if certain enterprises are using these types of features, are they less likely to churn? It's those types of insights that I think are really important on this lens.

**中文翻译:**
所以他们非常像是在挖掘数据的人，只是他们更多地带有产品视角，而不是像 Denise 说的，只看公司整体指标。这不仅仅是为产品经理服务。我想指出这一点，因为我认为这对领导者来说非常强大。如果领导者不理解这些类型的指标，他们就无法真正监控自己的战略。他们不能只是回头说：“噢，我们决定进军高端企业市场。”看，我们有了企业收入，但你真的观察过这些企业在哪些地方采用了不同的产品线吗？你观察过企业如何使用不同的功能吗？如果某些企业使用了这些功能，他们流失的可能性是否更小？我认为从这个视角来看，这类洞察非常重要。

---

### [00:33:09] Lenny

**English:**
As a PM hearing that somebody else will be doing this, it feels really weird. This feels like such a core job of a PM is to spend a lot of time with data, try to find opportunities, try to find things going well, not going well, but I think the message, again, is not you shouldn't be doing that as a PM and it's not bad if you are really good at it, it's you probably just don't have a lot of time to do it well. If you can find someone that's really good at this and has time, that doesn't have all the other thousands of things on their plate, you'll actually end up finding more interesting results, finding more interesting insights. You're probably missing a bunch of stuff because you don't actually have a lot of time. Is that generally the way you think about it?

**中文翻译:**
作为一个 PM，听说别人会做这些事，感觉真的很奇怪。这感觉像是 PM 的核心工作：花大量时间研究数据，寻找机会，寻找进展顺利或不顺利的地方。但我认为，你们传达的信息并不是说 PM 不应该做这些，或者你擅长做这些是坏事，而是你可能根本没有足够的时间把它做好。如果你能找到一个擅长此道且有时间的人，他没有成千上万的其他杂事缠身，你最终实际上会发现更有趣的结果和洞察。你可能漏掉了很多东西，因为你确实没时间。这通常就是你们的思考方式吗？

---

### [00:33:45] Melissa Perri

**English:**
Yeah, and I think too, the business and data insights people, they're not going to be experts on product. They're almost always not. We had a couple analysts at Produx Labs and they were ex-McKinsey, ex-Deloitte. They didn't know anything about product. So we taught them the product piece and we were the ones who were like, "Here's the interesting data I know I'm going to need to see," and they were able to pull those things together in views where we could actually dig into it, but that was a jumping off point on the quantitative research where we're like, "Okay. Now we need to go do the qualitative."

**中文翻译:**
是的。而且我认为，负责业务和数据洞察的人通常不会是产品专家。他们几乎从来都不是。我们在 Produx Labs 有几个分析师，他们以前在麦肯锡或德勤工作。他们对产品一窍不通。所以我们教他们产品方面的知识，而我们则是提出要求的人：“这是我知道我需要看到的有趣数据。”他们能够将这些数据整合到视图中，让我们深入研究。但这只是定量研究的起点，之后我们会说：“好了，现在我们需要去做定性研究了。”

**(00:34:18):**
I think for product managers, you still need to be super comfortable with data. If you can't read these charts, if you can't see or understand trends, and a lot of times too, if you're putting this stuff in Looker or a BI tool, ideally, you can pull ad hoc reports yourself. It's just that you don't have to craft a SQL query to do it. You still need to understand the relationship between data and product and you still need to understand what good data looks like. You need to understand too things like causation and correlation. You need to understand that, "If I put out this crazy marketing launch on Thursday, that's why all of a sudden we got a million signups on Thursday and we didn't get a million signups on Wednesday." They still need to understand all those things, and I don't think that becomes any less important. I don't think understanding and interpreting trends becomes any less important as a product manager's job. I just think it's about putting data into the hands of product faster so that it's not about you having to fight your way through bureaucratic processes at your company to get that data.

**中文翻译:**
我认为对于产品经理来说，你仍然需要对数据非常熟悉。如果你看不懂这些图表，看不出或理解不了趋势，那就不行。而且很多时候，如果你把这些东西放在 Looker 或 BI 工具中，理想情况下，你应该能自己提取临时报告。只是你不需要亲自编写 SQL 查询来完成。你仍然需要理解数据与产品之间的关系，仍然需要理解什么是好的数据。你还需要理解因果关系和相关性。你需要明白：“如果我在周四发布了一个疯狂的营销活动，这就是为什么周四突然有 100 万人注册，而周三没有。”他们仍然需要理解所有这些事情，我不认为这变得不重要了。我不认为理解和解释趋势作为产品经理的工作变得不重要了。我只是认为，这是为了更快地将数据交到产品人员手中，这样你就不用为了获取数据而在公司的官僚流程中苦苦挣扎。

**(00:35:21):**
So product ops can help streamline things that we know we're going to look at repeatedly. There's a bunch of stuff that we know we should look at. So put them in a dashboard like, "Why should I have to go pull that report ad hoc every single time?" Put them in a dashboard, put them in a report. Same for board slides. We had one of my friends who's the chief product officer of Forsta, Brian Bhuta, and he said, "I love product ops because when we prepare for board meetings, I know there's a certain set of information that I'm going to have to put together for this board meeting, and then when we go do it manually, it becomes obsolete by the time the board meeting's over and then I got to start again and prepare for the next three months and do the board meeting again." So it's like you don't want your data to be obsolete. You want this to be in a repeatable fashion for things that you know are repeatable, but it doesn't get you off the hook of still looking for trends and looking for insights.

**中文翻译:**
所以产品运营可以帮助简化那些我们知道会反复查看的内容。有很多东西是我们知道应该关注的。那就把它们放进仪表板里，比如：“为什么我每次都要临时去拉那份报告？”把它们放进仪表板，放进报告里。董事会幻灯片也是如此。我的一位朋友 Brian Bhuta 是 Forsta 的首席产品官，他说：“我喜欢产品运营，因为当我们准备董事会会议时，我知道有一组特定的信息是必须准备的。如果我们手动去做，等会议结束时数据就过时了，然后我得重新开始，为接下来的三个月做准备，再次开会。”所以，你不希望你的数据过时。你希望对于那些可重复的事情，能以可重复的方式呈现，但这并不意味着你可以不用再去寻找趋势和洞察了。

---

### [00:36:17] Lenny (Sponsor: Jira Product Discovery - Repeat)

*(Note: This is a repeat of the previous sponsor segment. Translation omitted for brevity as it is identical to the 00:01:50 segment.)*

---

### [00:37:38] Lenny

**English:**
We had a guest on, Casey Winters, and he has this perspective that when you have ops, operational people, that's generally a sign that something is not efficient and it could be made more efficient with software and product. Not everything can be productized, but do you have a perspective on that, that ops is often a sign where software, hopefully someday, could do itself?

**中文翻译:**
我们曾请过一位嘉宾 Casey Winters，他的观点是：当你有了“运营”（Ops）或运营人员时，这通常意味着某些环节效率低下，可以通过软件和产品变得更高效。虽然并非所有事情都能产品化，但你对此有什么看法吗？即“运营”往往是一个信号，表明软件（希望有一天）可以自动完成这些工作？

---

### [00:38:02] Melissa Perri

**English:**
You still need people to oversee those programs. So I don't think they would fully be obsolete. It wouldn't be like this whole role goes away completely, but they're the people who should be looking at, "What can we do to optimize and streamline this?" and not do it with human components. I think that's why a product management mindset lands so well to a product ops function too because you're like, "How do I use software or tools or processes or frameworks to help fill in some of these gaps and standardize it and then let it run?" That what I was meaning by the shared services model.

**中文翻译:**
你仍然需要人来监督这些项目。所以我不认为他们会完全过时。这并不意味着整个角色会彻底消失，但他们应该是那些思考“我们能做些什么来优化和简化这个流程，而不是靠人力完成”的人。我认为这就是为什么产品管理思维也非常适合产品运营职能，因为你会想：“我如何利用软件、工具、流程或框架来填补这些空白并将其标准化，然后让它自动运行？”这就是我所说的“共享服务模型”的意思。

**(00:38:32):**
If you really think in that format, it's not like, "Hey, I need a team of 10,000 product ops people." I think you're doing it wrong if you're doing that right. It should be a well-run lean team who thinks about how to leverage tools for this or building your own or whatever and your products for the product team, and that's how it should be seen. So what I mean it shouldn't be obsolete one day, if you are building, let's say, products for the product team, you still need somebody to look over that product and make sure it's relevant. At the pace of everything changing like it does today, so many things are so different than they were five years ago, you want somebody to be looking over that and making sure they're still up-to-date, it's still relevant, it still works for our company and stuff like that, but you're going to have a smaller subset of people doing that. It's not going to be like, "Oh, I need a product ops team for every product manager that's on here." That's not how it should work at all.

**中文翻译:**
如果你真的以这种形式思考，就不会觉得“嘿，我需要一个 1 万人的产品运营团队”。如果你真的那么做了，那你就做错了。它应该是一个运作良好的精益团队，思考如何利用工具、或者自己构建工具来为产品团队服务。所以我说它不会过时，是因为如果你在为产品团队构建“产品”，你仍然需要有人来照看这个产品并确保它的相关性。在当今这种变化速度下，很多事情与五年前大不相同，你需要有人盯着它，确保它仍然是最新的、相关的、适合公司的。但你只需要一小部分人来做这件事。绝不会是“哦，我需要为这里的每个产品经理都配备一个产品运营团队”。完全不应该是那样的。

---

### [00:39:27] Lenny

**English:**
I think that is going to make a lot of people feel better hearing that. Do you have any rule of thumb or way of thinking about just how many product ops people you want per product manager, per team? What's a simple heuristic for just how many people you may need?

**中文翻译:**
我想听到这些会让很多人感到宽慰。关于每个产品经理或每个团队需要多少名产品运营人员，你有什么经验法则或思考方式吗？有没有一个简单的启发式方法来判断可能需要多少人？

---

### [00:39:43] Melissa Perri

**English:**
I don't have a hard and fast rule on that one, but I would say if you are at a one-to-one ratio, you're doing it wrong. Absolutely.

**中文翻译:**
我没有一个硬性的规定，但我想说，如果你是 1:1 的比例，那你绝对做错了。

---

### [00:39:47] Denise Tilles

**English:**
If you're at one-to-hundred, you're doing it wrong.

**中文翻译:**
如果你是 1:100，你也做错了。

---

### [00:39:54] Melissa Perri

**English:**
Yeah, too. I also think it's like ... So when we talked about it too with this hybrid versus shared services model, if you have a hybrid model, let's say, and typically, this is a symptom that your data is not well-instrumented. Let me put it that way as well. Sometimes you need a stopgap holdover until you can well-instrument your data or something, and that could be as long as it takes for certain companies. In this case, like we said, you might have a business data and insights person aligned to every director of product who oversees multiple Scrum teams. You might have one aligned to every VP of product, depending on how much help you need to get the product data out of things.

**中文翻译:**
没错。我也认为……当我们讨论混合模型与共享服务模型时，如果你采用混合模型，通常这说明你的数据埋点（instrumented）做得不好。让我换个说法：有时你需要一个临时方案，直到你能做好数据埋点，对某些公司来说，这可能需要很长时间。在这种情况下，就像我们说的，你可能会为每位负责多个 Scrum 团队的产品总监配备一名业务数据与洞察人员。或者为每位产品副总裁配备一名，这取决于你在提取产品数据方面需要多少帮助。

**(00:40:37):**
Now, if you have a very well-instrumented dataset like we were talking about at Doodle or something like that, you're probably going to have way less people because the product managers are armed and capable of going in there and being able to pull the queries themselves, do their ad hoc research themselves because they made it accessible and you made it possible for them to go do that.

**中文翻译:**
现在，如果你有一个埋点非常完善的数据集，就像我们讨论的 Doodle 那样，你可能需要的人手会少得多。因为产品经理已经全副武装，有能力自己进去运行查询、自己做临时研究，因为你让数据变得易于获取，并让他们能够做到这一点。

**(00:40:59):**
So I do think there's a balance there between how good your company is instrumented both for everything, for all three of these pieces that we're talking about relative to the size of your product ops team. It might take some more manpower at the beginning to get it going, but, ideally, you streamline this team and it becomes pretty lean and pretty small and they're overseeing multiple programs or software systems that run themselves.

**中文翻译:**
所以我确实认为，在公司的埋点完善程度（针对我们讨论的所有三个部分）与产品运营团队的规模之间存在一种平衡。起步阶段可能需要更多人力，但理想情况下，你会精简这个团队，使其变得非常精干和小型，他们负责监督多个自动运行的项目或软件系统。

---

### [00:41:25] Lenny

**English:**
Well, it gives me a lot of hope that this isn't going to become just another massive org within a company. It is looking at companies that are incredibly efficient like Ramp and Deel that have very few employees, very few product managers, and they have product ops people. So that tells me there's a lot of leverage that you can find from just maybe, I don't know, one or two that's probably not a large team of product ops people there.

**中文翻译:**
这让我感到很有希望，它不会变成公司内部另一个庞大的部门。看看像 Ramp 和 Deel 这样效率极高的公司，他们的员工很少，产品经理也很少，但他们有产品运营人员。这告诉我，你可能只需要一两个产品运营人员就能获得巨大的杠杆作用，而不是一个庞大的团队。

---

### [00:41:48] Melissa Perri

**English:**
We say too, get started with one person. We described these three pillars and repeatedly through the book we're like, "Hone in on what's the most important part for you that's going to help you right now," that we talk through, and then just take one person and throw that out there. Usually, you can get so much leverage from that that it frees you up to do a lot of the stuff that you need to get done. Then when you're ready and you see the next hurdle and it's not something that first person can take on, then you might add one more person.

**中文翻译:**
我们也建议，从一个人开始。我们描述了这三大支柱，并在书中反复强调：“专注于对你现在最有帮助、最重要的部分。”然后只安排一个人去尝试。通常，你可以从中获得巨大的杠杆作用，让你从繁琐事务中解脱出来。然后当你准备好了，看到了下一个障碍，而第一个人无法胜任时，你再考虑增加一个人。

**(00:42:18):**
There are different expertise, I think, between the three different pillars and the people who would oversee it, and that's something to take into account as well. So like we said, in business data and insights, that person typically is not an expert on product. Hopefully they get ramped up on it working with you, but they're typically not an expert on product. A lot of times these people are not coming from a product management background. That's going to be actually a different person than I would look at to help with the governance and product pieces. That person needs to be a product background person because they're usually helping roll out the roadmap stuff, coach people on how to do it, helping to define the different systems and processes that you need on your product operating model, and if they have no experience with product management at all, that's going to be really hard for them to do and it's probably not going to be great.

**中文翻译:**
我认为这三大支柱以及负责它们的人员之间存在不同的专业知识要求，这也是需要考虑的。就像我们说的，在“业务数据与洞察”方面，那个人通常不是产品专家。希望他们能在与你合作的过程中逐渐熟悉，但他们通常没有产品背景。这与我寻找的负责“治理和产品”部分的人实际上是不同的。后者需要有产品背景，因为他们通常要帮助推行路线图、指导大家如何操作、帮助定义产品运营模型所需的各种系统和流程。如果他们完全没有产品管理经验，那对他们来说会非常困难，效果可能也不好。

**(00:43:05):**
We do see this trend of people throwing agile coaches at this, and agile coaches who have never been a product manager before in a well-run company are going to struggle there because they're going to revert back to agile processes and optimizing for things like Scrum, but they're not going to do what that role is designed for, which is to help product management processes. We don't usually need another agile coach telling us how to run a standup. We need people to come in and help us figure out who's invited to these cross-functional roadmap reviews, what inputs do we need on there, and what decisions do we need to make coming out of it, and how do we communicate it at the correct level to executives as well so we're not digging into Jira at these meetings in front of A CEO. CEOs don't care about what's in Jira. Well, they shouldn't. Let's put it that way.

**中文翻译:**
我们确实看到一种趋势，人们把敏捷教练（Agile Coaches）推到这个岗位上。如果敏捷教练以前从未在运作良好的公司担任过产品经理，他们会感到很挣扎，因为他们会退回到敏捷流程，优化 Scrum 之类的事情，而不会去做这个角色真正设计的初衷——即辅助产品管理流程。我们通常不需要另一个敏捷教练来告诉我们如何开站会。我们需要有人来帮我们弄清楚：谁该被邀请参加跨职能路线图评审？我们需要哪些输入？我们需要做出哪些决策？以及如何以正确的层级向高管汇报，这样我们就不会在 CEO 面前开会时还在翻 Jira。CEO 并不关心 Jira 里写了什么。或者说，他们不应该关心。

---

### [00:43:57] Denise Tilles

**English:**
Shouldn't.

**中文翻译:**
不应该。

---

### [00:43:59] Melissa Perri

**English:**
They want to know like, "What are the big pushes that we're doing to help us reach our strategic objectives?" So it's helping that they know a little more about the right size of communication, the different cross-functional teams, what product managers do on a daily basis and what's important to them, and that's really critical in that role. So that's where, I think, your teams might just be slightly bigger from a perspective of more than one person. I'm not saying hundreds of people, but you might need a couple different people in this organization because the roles are slightly different. For the market research and the customer research thing too, you might need somebody with a user research background for that. Somebody who did research ops is a great person for that.

**中文翻译:**
他们想知道的是：“我们正在做哪些重大推进来帮助我们实现战略目标？”所以，产品运营需要更了解沟通的尺度、不同的跨职能团队、产品经理的日常工作以及对他们来说什么是重要的，这在这个角色中至关重要。因此，我认为从多于一人的角度来看，你的团队可能会稍微大一点。我不是说几百人，但你可能在这个组织中需要几个不同的人，因为角色略有不同。对于市场研究和客户研究，你可能需要一个有用户研究背景的人。做过研究运营（Research Ops）的人会非常合适。

---

### [00:44:41] Denise Tilles

**English:**
It's pretty unusual, I think, to see companies start out with an entire team. I worked with Sam's Club and they were planning to do it that way, but mostly we see it starting organically. I think the way [inaudible] mentioned in her story of being a PM and feeling the pain and having the empathy of wanting to make it better, and that's typically the generation of these roles, that it might be someone being allocated part-time from their PM role and finding out that they really do enjoy this enablement aspect of it and that's where it grows.

**中文翻译:**
我认为公司一开始就组建一整个团队是很不寻常的。我曾与山姆会员店（Sam's Club）合作，他们当时计划那样做，但大多数情况下我们看到它是自然生长的。就像某人在故事里提到的，作为一名 PM，感受到了痛苦，并产生了想要改进它的同理心，这通常是这些角色的产生方式。可能有人从 PM 角色中被分配出一部分时间，然后发现自己真的很喜欢这种“赋能”工作，于是这个角色就成长起来了。

---

### [00:45:12] Lenny

**English:**
Awesome. So let's just lean into this topic of just how to start rolling it out at your company, and you've already talked about a bunch of tips there. By the way, if you buy your book at the end there, there's this really beautiful little guy, there you go, I think, on the camera of just a little yellow brick road of all the steps that it takes to roll it out.

**中文翻译:**
太棒了。让我们深入探讨一下如何在公司开始推行这个职能，你已经谈到了很多建议。顺便说一下，如果你买了你们的书，在书的末尾，有一个非常漂亮的小图表——就在镜头前，我想——那是一条通往推行步骤的“黄色砖路”。

---

### [00:45:12] Denise Tilles

**English:**
Yes, Candyland.

**中文翻译:**
是的，糖果乐园（Candyland）。

---

### [00:45:32] Lenny

**English:**
Candyland. So on this topic of just who to start with, sounds like you recommend start with one person, and what I'm hearing is pick one of these three pillars that you think is most highest leverage potentially to take off your product management plate. Is that right?

**中文翻译:**
糖果乐园。关于从谁开始，听起来你建议从一个人开始。我听到的是：选择你认为最有杠杆作用的三大支柱之一，把这部分工作从产品经理的盘子里拿走。对吗？

---

### [00:45:46] Denise Tilles

**English:**
Yup.

**中文翻译:**
没错。

---

### [00:45:49] Lenny

**English:**
So what else should people be thinking about in starting to roll this role out, starting to build this team?

**中文翻译:**
那么，在开始推行这个角色、开始组建这个团队时，人们还应该考虑什么？

---

### [00:45:56] Denise Tilles

**English:**
That's a great question. So one of our case studies is Shintaro Matsui at Amplitude, and he created the role at Amplitude. When you think about, it's Meta. So they're creating a tool that helps in terms of product operations, but they're enabling it there as well. So he's done a really great job of getting that set up and really being a thought leader there. So the case study that we chatted with him about was introducing it and how do you get it going and how do you build the momentum and show the quick wins. That was his top tip was making sure that you set, understand, first of all, you may have a perception of what the biggest needs are, but doing your listening tour and doing your user research, some research sprints, understanding there may be a huge opportunity, but it also sounds massive in your team of one, where can you make the most difference quickly? Where can you have the most impact?

**中文翻译:**
这是一个好问题。我们的案例研究之一是 Amplitude 的 Shintaro Matsui，他在 Amplitude 创建了这个角色。想想看，那是元数据（Meta）级别的。他们正在创建一个有助于产品运营的工具，但他们也在内部启用它。他在建立这个职能并成为该领域的思想领袖方面做得非常出色。我们与他讨论的案例研究是关于如何引入它、如何启动、如何建立势头并展示“快速获胜”（quick wins）。他的首要建议是：确保你设定并理解——首先，你可能对最大的需求是什么有自己的看法，但要进行“倾听之旅”，做用户研究，进行一些研究冲刺。要明白虽然机会巨大，但对于一个人的团队来说可能听起来太宏大了，所以要找准：哪里能最快产生不同？哪里能产生最大的影响？

**(00:46:46):**
So identifying those, celebrating those wins, making sure everybody understands that, and then showing what's above the line with a person of one the capabilities you'll have, and then below the line, things that you may not get but you could if we did think about building the team and setting the expectations as well.

**中文翻译:**
识别这些机会，庆祝这些胜利，确保每个人都理解这一点。然后展示在只有一个人的情况下你能拥有的能力（线上部分），以及那些你目前无法得到、但如果考虑组建团队就能实现的事情（线下部分），以此来设定预期。

---

### [00:47:04] Lenny

**English:**
Do you suggest they try to hire someone that has already been a product ops person? Is it okay to hire someone that hasn't then they just become a product ops person? How important is that experience?

**中文翻译:**
你建议他们尝试招聘已经做过产品运营的人吗？招聘一个没做过的人，然后让他们转变为产品运营人员可以吗？经验有多重要？

---

### [00:47:14] Denise Tilles

**English:**
I think if you find someone that's done the role of product management, awesome. If someone's set it up somewhere ... Look at Blake Samic, started from Uber to Stripe to AI. Clearly, he's got a model going that's really successful. So if somebody could get a Blake Samic, I would say definitely do that.

**中文翻译:**
我认为如果你能找到做过产品管理的人，那太棒了。如果有人在某处建立过这个职能……看看 Blake Samic，从 Uber 到 Stripe 再到 OpenAI。显然，他有一套非常成功的模型。所以如果有人能请到 Blake Samic 这样的人，我肯定会说：一定要这么做。

---

### [00:47:32] Lenny

**English:**
It'd be hard to pull him away from OpenAI.

**中文翻译:**
要把他从 OpenAI 挖走可不容易。

---

### [00:47:37] Melissa Perri

**English:**
I don't think he's leaving there right now. Just started, got a lot of work ahead of him.

**中文翻译:**
我觉得他现在不会离开那里。刚开始，还有很多工作要做。

---

### [00:47:42] Lenny

**English:**
We have a lot of LinkedIn requests right now. Here they come.

**中文翻译:**
我们现在有很多 LinkedIn 请求。它们来了。

---

### [00:47:46] Melissa Perri

**English:**
Poor Blake. Sorry, sorry for your inbox. I think too it's about if you're going all in. If you're just trying to get buy-in for this and let's say it's originating from a CPO or a product leader who's like, "Hey, let's start this out," but the company's not ready to invest all the way, you might pull somebody from a different function, let's say, have them be the product ops person and try to rapidly demonstrate value. If you're a CPO or a leader and you're like, "I got budget. I know this is important. I'm totally bought in. Let's go," you're probably better off hiring, let's say, somebody who's done this before, somebody who's experienced, but also somebody who could be more of a VP or director of product ops and then they can go do the hiring and figuring out, "Do we pull people from other functions and streamline it?" That helps free up the leader as well from not having to go find 8,000. It's never going to be 8,000 people, but eight people to do that function.

**中文翻译:**
可怜的 Blake。抱歉，抱歉塞满了你的收件箱。我认为这也取决于你是否打算“全力以赴”。如果你只是想获得支持，比如是由 CPO 或产品领导者发起的，说“嘿，让我们开始吧”，但公司还没准备好全面投入，你可能会从其他职能部门抽调一个人，让他们担任产品运营，并尝试快速展示价值。如果你是 CPO 或领导者，并且说“我有预算，我知道这很重要，我完全支持，开始吧”，那你最好招聘一个以前做过这件事、有经验的人，或者是一个可以担任产品运营副总裁或总监的人。然后由他们去负责招聘，并弄清楚：“我们是否要从其他职能部门抽调人员并简化流程？”这也能把领导者解放出来，不用亲自去找那 8 个人（当然不会是 8000 人，但可能是 8 个人）来履行这个职能。

---

### [00:49:00] Lenny

**English:**
It feels like that first hire is so important because if they don't do great, the whole role of product ops starts to get a bad tinge within the company. There's a lot of pressure on making sure that first person succeeds. I guess more reason to buy your book and make sure that they do it right.

**中文翻译:**
感觉第一次招聘非常重要，因为如果他们做得不好，整个产品运营角色在公司内部就会开始蒙上阴影。确保第一个人成功的压力很大。我想这也是买你们的书并确保他们做对的另一个理由。

---

### [00:49:17] Melissa Perri

**English:**
If you feel like you as a leader can coach the product ops person and you have time to coach the product ops person, let's say, through being a good product ops person and getting started with it and directing them, you're probably good at taking somebody who does not have experience but has the right skillset and then you can teach them. If you have absolutely no time to coach this person and they're not super self-directed, let's say, so they're not going out taking classes, reading the books, doing that type of thing, probably going to want to hire somebody who's done it before, at least that portion of it, and then that person can help coach other people grow the function.

**中文翻译:**
如果你觉得作为领导者你可以指导产品运营人员，并且你有时间指导他们如何成为一名优秀的产品运营、如何起步并引导他们，那么你可能适合找一个没有经验但具备正确技能组合的人，然后你可以教他们。如果你完全没有时间指导这个人，而且他们也不是那种超级自觉的人（比如不会自己去上课、看书之类的），那你可能想雇一个以前做过的人，至少做过那部分工作的人，然后那个人可以帮助指导其他人来扩展这个职能。

**(00:49:55):**
It's the same thing with product management. We look at these teams especially in a lot of transformation companies. We have a lot of product managers who've never been product managers before, and a lot of leaders who've never been product managers before, and they ask me, "Do I hire in experienced leaders or what?" and I'm like, "Well, if those product leaders need to go coach other product managers, then you need somebody who's experienced in there. You need somebody who knows how to get that work done. If they don't have time to learn, if you're not on a timeline to actually teach these people these things and get them up to speed, then you need somebody to hit the ground running."

**中文翻译:**
产品管理也是一样。我们看到很多转型公司的团队，有很多以前从未当过产品经理的产品经理，以及从未当过产品经理的领导者。他们问我：“我是该雇有经验的领导者还是别的？”我说：“如果这些产品领导者需要去指导其他产品经理，那么你需要有经验的人。你需要知道如何完成工作的人。如果他们没时间学习，如果你没有时间表去教这些人并让他们跟上进度，那么你需要一个能立即上手的人。”

**(00:50:29):**
So I'd look at it for how much time do we have to demonstrate value, how much coaching is available to get this person into the right mindset and the right skillset to do this and execute. I think that that's needed in almost every role, not just this one.

**中文翻译:**
所以我会考虑：我们有多少时间来展示价值？有多少指导资源可以帮助这个人建立正确的思维模式和技能组合来执行？我认为几乎每个角色都需要这样考虑，不仅仅是这一个。

---

### [00:50:43] Denise Tilles

**English:**
One thing I wanted to mention was whether to hire products or product manager person for the role with the background of product ops or product management, there's not a ton of folks out there that have a products title, but as you're looking, dig in because this person may have been doing a lot of the work as a product manager or within that title. So there's a lot of people out there that probably would fit that profile, but not with a proper product ops title.

**中文翻译:**
我想提的一点是，关于是招聘具有产品运营背景还是产品管理背景的人，目前市面上拥有“产品运营”头衔的人并不多。但在你寻找时，要深入挖掘，因为这个人可能在担任产品经理期间已经做了很多这类工作。所以有很多可能符合这一特征的人，只是没有正式的“产品运营”头衔。

---

### [00:51:10] Lenny

**English:**
What are the key skills that you find are really important for finding this person, especially if they don't have this role? My guess is dependent on the pillar, if they're data-focused, research-focused or process-focused. What do you suggest to make sure you're looking for when you're hiring this person?

**中文翻译:**
你发现寻找这个人的关键技能是什么，特别是如果他们以前没做过这个角色？我猜这取决于支柱——是侧重数据、研究还是流程。你建议在招聘时确保看重哪些方面？

---

### [00:51:25] Melissa Perri

**English:**
With the business data and insights, you're looking for somebody who's really good at interpreting data, telling stories with data, somebody who's good at communicating to many different types of stakeholders about the data and putting it into useful ways. What I wouldn't hire for that role as a first person is it's not a database engineer. That's not what we're doing. We're not SQL-ing, turning things into the right SQL tables. We're instead trying to get the information out of the SQL tables and make sense out of it.

**中文翻译:**
对于“业务数据与洞察”，你要找的是擅长解释数据、用数据讲故事的人，擅长向许多不同类型的利益相关者沟通数据并将其转化为有用方式的人。我不会招聘数据库工程师作为这个角色的第一人选。那不是我们要做的。我们不是在写 SQL 把东西变成正确的 SQL 表。相反，我们是在尝试从 SQL 表中提取信息并理解其意义。

**(00:51:59):**
So we actually find people with consultant backgrounds who are really good at this because they're usually churning out these types of reports and stuff for PE firms, VC firms, and whoever were their clients to begin with. What would be ideal is if that person has a lot of experience with a BI tool like Looker or Tableau as well and they could use it. That's not always the case. Sometimes those people are really good at Excel and PowerPoint, but they're not great at the Looker and BI. If you could find that two things together though, home run right there.

**中文翻译:**
所以我们实际上发现具有顾问背景的人非常擅长这个，因为他们通常在为私募股权（PE）公司、风投（VC）公司或他们的客户制作这类报告。理想情况是，如果那个人在 Looker 或 Tableau 等 BI 工具方面也有丰富经验并能熟练使用。但情况并非总是如此。有时这些人非常擅长 Excel 和 PowerPoint，但不擅长 Looker 和 BI。如果你能找到两者兼备的人，那就是“全垒打”了。

**(00:52:31):**
So this person's probably a data analyst background. We did have a business intelligence background like you were talking about as well, something like that for the business and data and insights role. It does not have to be a product manager. I think you can help them, steer them in the right directions for what questions you need to answer. They shouldn't be the ones coming up with all the questions you need to answer. It'd be great if they surface some insights, but you ask them the questions, they can go get the answers.

**中文翻译:**
所以这个人可能有数据分析师背景。就像你提到的，商业智能背景也可以。对于业务数据与洞察角色，不一定非要是产品经理。我认为你可以帮助他们，引导他们朝着你需要回答的问题方向前进。他们不应该是那个提出所有问题的人。如果他们能挖掘出一些洞察当然很好，但通常是你问问题，他们去寻找答案。

---

### [00:53:01] Lenny

**English:**
What about for the other two pillars?

**中文翻译:**
另外两个支柱呢？

---

### [00:53:02] Denise Tilles

**English:**
Well, in terms of the process and practices, I think this person really needs a super high EQ, understanding what the needs are, but also has a good spidey sense of how much methods do we need to think about bringing to the team and thinking about how those things get introduced that it's not a mandate, but it's a suggestion of how we can work. Typically, product managers will be pretty open to that because if they're like, "I don't know what the roadmap template is. I don't know what the roadmap cadence is." "Here's some guidance." "Awesome. Now I don't have to think about how to do it, I'm just going to do it."

**中文翻译:**
嗯，在“流程与实践”方面，我认为这个人真的需要极高的情商（EQ），理解需求是什么，同时还要有敏锐的直觉：我们需要为团队引入多少方法论？以及如何引入这些东西，使其看起来不是一项强制命令，而是一个关于如何工作的建议。通常，产品经理对此会非常开放，因为如果他们说“我不知道路线图模板是什么，不知道节奏是什么”，而你提供“这里有一些指导”，他们会觉得“太棒了，现在我不用去想怎么做了，直接做就行了”。

**(00:53:38):**
So I think someone who has a lot of experience understanding the underlying tensions and opportunities, and then feels good and understands how to implement the systems thinking and also understands it's not a set it and forget it, that they're constantly reevaluating the processes, the tools, "Are these working for us?" Then understands, I think, in more broadly, "As my CPO is getting ready for a board meeting, what are the inputs they're going to need? As we're getting ready for the QBR, are the PMs ready? Do we have a cohesive stories? Anybody taking the time to look at all of the different presentations to make sure that we're giving the same perspective or building towards a certain strategy that everybody's focused on?" So that would be my advice.

**中文翻译:**
所以我认为需要一个有丰富经验、能理解潜在张力和机会的人。他要擅长并理解如何实施系统思维，并且明白这不是“一劳永逸”的，需要不断重新评估流程和工具：“这些对我们有用吗？”此外，还要从更广泛的角度理解：“当我的 CPO 准备董事会会议时，他们需要哪些输入？当我们准备季度业务回顾（QBR）时，PM 们准备好了吗？我们的故事是否统一？是否有人花时间查看所有不同的演示文稿，以确保我们提供的是相同的视角，或者正朝着每个人都关注的某个战略迈进？”这就是我的建议。

---

### [00:54:30] Melissa Perri

**English:**
I think for customer and market research part, you're looking for somebody with more of a user research background here, but process-oriented. So I'd look for somebody who knows user research code, knows really good tactics for that because it can help create the toolkits, get the right type of prototyping and usability software in there. They know what good interviewing looks like, that type of stuff, but they also got this need to make things better. So they're like, "I need to create a system to do this." They're good at operationalizing stuff. I think that's a skill for everybody. They're like, "I can build a system to fix this." That's actually a really good interview guild that I would ask a product ops person and I never came up with it. I never thought about that before, but it's like, "Tell me about some process or something that you had to do in your job that you really hated and that you ended up just trying to automate a way or build a system around it to make it better." That would be a great interview question for anybody in those roles, I think.

**中文翻译:**
我认为对于“客户与市场研究”部分，你要找的是具有用户研究背景但偏向流程导向的人。我会找一个懂用户研究规范、懂优秀策略的人，因为这有助于创建工具包，引入正确的原型设计和可用性软件。他们知道什么是好的访谈，诸如此类。但他们也必须有“让事情变得更好”的渴望。他们会想：“我需要建立一个系统来做这件事。”他们擅长将事物流程化。我认为这是每个人的必备技能。他们会说：“我可以建立一个系统来解决这个问题。”这实际上是一个非常好的面试切入点，我会问产品运营人员（我以前没想过这个）：“告诉我你在工作中必须做的某个你非常讨厌的流程或事情，以及你最终如何尝试将其自动化或围绕它建立一个系统来改进它。”我认为这对于这些角色的任何人来说都是一个很棒的面试问题。

**(00:55:27):**
With the user and market insights person too, there's not a ton of people out there doing this, but there is a little research ops movement out there that I think could be really valuable here. So Jen Cardello, who is our case study on Fidelity, she runs their user insights team there and she's our VP of, I think it's user insights and she does oversee all the user researchers as well, but she also oversees a research ops team, and the research ops team is responsible for building their participant database. They also help build toolkits for people to do user research. They oversee any of the user research tools. They also go out and train other people in doing good user research.

**中文翻译:**
对于用户和市场洞察人员，目前做这个的人也不多，但现在有一个“研究运营”（Research Ops）运动，我认为在这里非常有价值。比如 Jen Cardello，她是我们在富达投资（Fidelity）的案例研究对象，她在那负责用户洞察团队。她是用户洞察副总裁，监管所有的用户研究员，同时也监管一个研究运营团队。研究运营团队负责建立受访者数据库，帮助建立用户研究工具包，监管所有的用户研究工具，还负责培训其他人如何进行优秀的用户研究。

**(00:56:07):**
So with them, that looks like not everybody's allowed to go talk to customers and financial firms like this because of compliance reasons. They make sure they certify people to be able to go do good research up to certain points and they get levels for how far they can go so that they can democratize the research and help put it into their hands. Then if there's compliant issues around different research studies, they come back to Jen's team and the user researchers will help them complete it.

**中文翻译:**
在他们那里，由于合规原因，并不是每个人都被允许去和客户或金融机构交谈。他们确保对人员进行认证，使其能够在一定程度上进行优秀的研究，并设定了他们可以参与的深度级别，从而使研究民主化，并将其交到大家手中。如果不同的研究项目存在合规问题，他们会回到 Jen 的团队，由用户研究员协助完成。

**(00:56:33):**
So it's about how we ... There's a lot of legal things about what you can say and what you can't say to customers and stuff like that, what you can ask them, and they're navigating those complexities around there. So Jen comes from a research ops background. She comes from a whole UX background, but research ops is her thing and she's fantastic at setting up that stuff. She and I worked together at Athenahealth and she did that there. So I watched her put that into place and it was amazing and now she does it at Fidelity.

**中文翻译:**
所以这关乎我们如何……关于你能对客户说什么、不能说什么，以及你能问什么，有很多法律规定，他们正在处理这些复杂性。Jen 具有研究运营背景。她有完整的 UX 背景，但研究运营是她的专长，她非常擅长建立这些东西。我和她曾在 Athenahealth 共事，她在那里就做了这些。我看着她把这些付诸实践，非常了不起，现在她在富达投资也这么做。

**(00:57:00):**
So if you find somebody with that background, golden, but if you find somebody who ... If you can't find somebody like Jen because there's only one Jen, you should look for somebody who has at least a user research background, probably some UX background. They're really good at doing that and they want to operationalize it.

**中文翻译:**
所以如果你能找到有这种背景的人，那就太完美了。但如果你找不到像 Jen 这样的人（因为 Jen 只有一个），你应该找一个至少有用户研究背景、可能还有一些 UX 背景的人。他们非常擅长做这些，并且想要将其流程化。

---

### [00:57:18] Lenny

**English:**
Jen's about to get a bunch of LinkedIn requests too.

**中文翻译:**
Jen 也要收到一堆 LinkedIn 请求了。

---

### [00:57:22] Melissa Perri

**English:**
Sorry for your inbox, Jen.

**中文翻译:**
抱歉了，Jen，塞满了你的收件箱。

---

### [00:57:23] Lenny

**English:**
I feel like the research team is going to hate people now for pulling you into product ops. Who would you suggest product ops report to generally at least to start?

**中文翻译:**
我觉得研究团队现在会讨厌那些把你拉进产品运营的人。你建议产品运营通常应该向谁汇报，至少在开始阶段？

---

### [00:57:35] Melissa Perri / Denise Tilles

**English:**
Head of product. / CPO.

**中文翻译:**
产品负责人。/ 首席产品官（CPO）。

---

### [00:57:38] Lenny

**English:**
Such a clear, quick answer. I love it. How do they find time to train and work with this person? Are they the right-hand person that helps them just make everything more efficient? What's a way? What's that relationship like?

**中文翻译:**
如此清晰、快速的回答。我喜欢。他们如何腾出时间来培训和与这个人合作？他们是帮助领导者提高一切效率的得力助手吗？这种关系是怎样的？

---

### [00:57:50] Melissa Perri

**English:**
I think definitely their right-hand person, and we say to a lot of CPOs, especially high growth companies, "Make your first hire just a product ops person to help you get this data out and start looking at it," because that helps them with board meetings, it helps them set strategy. Usually when you walk into a growth stage company, that's the first thing that you need to do is make sure that it's working, that you need to set it. Typically, when you're getting hired, there's usually a strategy problem and that person, they're like your right-hand man trying to operationalize that. So I definitely think that you're going to be guiding them there.

**中文翻译:**
我认为绝对是得力助手。我们对很多 CPO（尤其是高增长公司的 CPO）说：“你的第一个招聘名额就给产品运营，帮你好把数据导出来并开始研究。”因为这能帮他们应对董事会会议，帮他们制定战略。通常当你进入一家成长阶段的公司时，你需要做的第一件事就是确保一切运转正常，你需要设定它。通常当你被录用时，往往存在战略问题，而那个人就像你的副手，试图将其流程化。所以我绝对认为你会引导他们。

**(00:58:23):**
I think this comes back to our question though about, do you hire somebody with experience or do you hire somebody who's new to it? If you as a CPO don't have a lot of time to train up somebody on product ops because you've got 8,000 fires to fight, then hire somebody with experience who knows how to do it and operationalize it. If you are like, "My biggest issue is business data and insights," for example, "and I just need to get my data so that I can do the strategy pieces and then I need to think through and work through what I want product ops to look like," maybe then you just hire the data analyst. If they're confident in the data analysis piece, it's pretty easy, I haven't done this myself, to teach them about what types of information you need to see as a product person. They're going to need a lot more handholding at the beginning because they're not going to know all the different cuts of data, but it's not an investment of an inordinate amount of time to be able to get something valuable back.

**中文翻译:**
但这又回到了我们的问题：是雇有经验的人还是新人？如果你作为 CPO 没有太多时间培训产品运营人员，因为你有 8000 场火要救，那就雇一个有经验、知道如何操作和流程化的人。如果你觉得“我最大的问题是业务数据与洞察，我只需要拿到数据以便制定战略，然后我再慢慢思考产品运营该长什么样”，那么也许你只需要雇一个数据分析师。如果他们对数据分析很有信心，教他们作为产品人需要看哪些类型的信息其实相当容易（虽然我没亲自教过）。刚开始他们需要更多的指导，因为他们不懂数据的各种切分方式，但这并不是一项需要投入过量时间才能获得回报的投资。

**(00:59:20):**
It's not like training for 40 hours a week and then waiting six months to see results. It's more about, "I need you to go pull these types of cuts. Here's why. Let me explain to you this so that you learn it and then you can think about it next time," but that's going to help you there too. So I think it really depends. So how fast you need product ops fully rolled out and then how much time you have to train people, and then where you're starting from there and how big and how much buy-in you have to grow this thing from the get-go.

**中文翻译:**
这不像每周培训 40 小时然后等六个月才看结果。更多是：“我需要你去拉这些维度的数据。原因是这样的。让我向你解释一下，这样你就能学会，下次就能自己想到了。”这也会对你有所帮助。所以我觉得这真的取决于：你多快需要产品运营全面推行？你有多少时间培训人员？你从哪里开始？以及从一开始你拥有多大的支持力度来发展这个职能？

---

### [00:59:49] Lenny

**English:**
Amazing. Maybe as a last question, I'd love to go through a quick case study of a company you worked with and just share maybe how you rolled it out, what you ran into, challenges you had to overcome, and maybe the benefits and impact that adding this role had.

**中文翻译:**
太棒了。作为最后一个问题，我很想听听你们合作过的一家公司的快速案例研究。分享一下你们是如何推行的，遇到了什么，必须克服哪些挑战，以及增加这个角色带来的好处和影响。

---

### [01:00:06] Melissa Perri

**English:**
When I was at Athenahealth, we were doing a ... Athenahealth has always been a software company, so let me put it that way, but they didn't have a formal product management role and they had just implemented it when I came in. So the chief product officer brought me in. He did not have an extensive product background, so he said, "I need to train all these product people and figure out what to do with this organization." So I came in to help him do that. We had over 360 product managers. We had 5,000 software developers there and it was a massive platform, $8 billion in market cap, I think, electronic health record system.

**中文翻译:**
当我在 Athenahealth 时，我们正在做一个……Athenahealth 一直是一家软件公司，可以这么说，但他们没有正式的产品管理角色，我进去时他们才刚刚开始推行。首席产品官把我请了过去。他没有深厚的产品背景，所以他说：“我需要培训所有这些产品人员，并弄清楚这个组织该怎么办。”于是我进去帮他。我们当时有 360 多名产品经理，5000 名软件开发人员，那是一个巨大的平台，市值大概 80 亿美元，是一个电子健康记录系统。

**(01:00:42):**
So this is where I started to realize we needed product ops. This was me discovering this. So I'll tell you how we rolled it out and probably what we would do differently next time, but we had trained all the product managers. People were starting to use a lot of the things that we were teaching, and we saw that the maturity was getting a lot better in the organization, which was fantastic, but then we started to run into these problems, and these problems that we found could not be solved by just training product managers, and that's where the concept for product ops came up.

**中文翻译:**
这就是我开始意识到我们需要产品运营的地方。这是我的新发现。我会告诉你我们是如何推行的，以及下次可能会有什么不同的做法。我们培训了所有的产品经理，大家开始使用我们教授的很多方法，组织的成熟度也大大提高了，这非常棒。但随后我们开始遇到一些问题，这些问题我们发现仅仅通过培训产品经理是无法解决的，这就是产品运营概念产生的原因。

**(01:01:11):**
We also realized we had way too many product managers, just way too many product managers. There was one person reporting into one person all the way down, and we were like, "This is not helpful." So we ended up training everybody, teaching people about what the role was, and then thinking through as we encounter these other problems, "What else do we need besides product managers?" Product ops became one of the things. We also had people actually move out of product management into other roles. We had people become data analysts, we had people become user researchers, we had people go into other parts of the organization, but a lot of people after we trained them actually just self-selected out of product management and some of them did come to us and say, "What else is there?"

**中文翻译:**
我们还意识到我们的产品经理太多了，实在是太多了。层层汇报都是一对一，我们觉得这毫无帮助。所以我们最终培训了所有人，教大家这个角色是什么，然后在遇到其他问题时思考：“除了产品经理，我们还需要什么？”产品运营成了其中之一。我们还让一些人从产品管理岗位转到了其他岗位。有人成了数据分析师，有人成了用户研究员，有人去了组织的其他部门。但在我们培训之后，很多人实际上主动选择了退出产品管理，其中一些人来问我们：“还有什么其他岗位吗？”

**(01:01:53):**
When we looked at the product ops role, we said, "Okay. What are the big fires that we have to fight that's just not from a lack of skills perspective?" That's a big part about product ops. It's not a replacement for product managers or product leaders not having product management skills. It's to help skilled product managers and product leaders do their job better. So this will never replace the fact that people don't have the skills to do their job.

**中文翻译:**
当我们审视产品运营角色时，我们说：“好吧，除了技能缺乏之外，我们还必须扑灭哪些大火？”这是产品运营的一个重要部分。它不是为了替代那些缺乏产品管理技能的产品经理或领导者。它是为了帮助有技能的产品经理和领导者做得更好。所以，它永远无法弥补人们没有能力胜任工作这一事实。

**(01:02:19):**
So where we ran into issues was, one, getting insights back to the executives on what the teams were actually doing. So the CEO and I were sitting there trying to set strategy and set the vision for the company and I was helping him formulate it into written form and help him deploy it and think through where we want it to go. He was in Jira, digging around in Jira trying to find information on what people were working on, and I was like, "You're not going to find that in Jira, especially when we've got hundreds of thousands of tickets for 5,000 people. You're not going to find this in there."

**中文翻译:**
我们遇到的问题之一是：如何向高管反馈团队实际在做什么。当时 CEO 和我坐在一起，试图制定公司的战略和愿景，我帮他将其转化为文字，帮他部署并思考未来的方向。他当时在翻 Jira，试图在 Jira 里找大家都在忙什么。我说：“你在 Jira 里找不到的，尤其是当我们有 5000 个人、几十万个工单的时候。你根本找不到。”

**(01:02:57):**
That started to show me, "Hey, he's looking for this. What do you want to see?" He's looking for a portfolio roadmap of what everybody's doing and he wanted to see what are the big pushes we're making from a feature perspective and how do they tie back to our overall strategy and our goals. What's going to help our retention? What's going to help us get new customers? What's going to help us move into the enterprise, which was a big thing we were doing going upmarket into hospitals? We had no transparency into the allocation of R&D on that and also the roadmaps on that.

**中文翻译:**
这让我意识到：“嘿，他在找这个。你想看什么？”他在找一个关于所有人工作的“投资组合路线图”（portfolio roadmap），他想看我们从功能角度做的重大推进是什么，以及它们如何与我们的整体战略和目标挂钩。什么能帮助留存？什么能帮我们获取新客户？什么能帮我们进军企业市场（当时我们正努力进入医院市场）？我们对研发资源的分配以及相关的路线图完全没有透明度。

**(01:03:29):**
So one of the things that we were trying to do in product ops was build that view, try to figure out how we get people to put the right information into Jira at the right level. So we actually had to train people on how to write ... At the time, we only had Jira, so epics in Jira that were not just build a button, they were more substantial than that. They actually had to meet behind it so we could look at it. Then we had to go out and find the right software to roll that up into a portfolio view so the executives could get the insights they were looking for.

**中文翻译:**
所以我们在产品运营中尝试做的一件事就是构建那个视图，弄清楚如何让大家在 Jira 中以正确的层级输入正确的信息。我们实际上不得不培训大家如何写……当时我们只有 Jira，所以是 Jira 里的 Epic（史诗级任务），不能只是“做一个按钮”，必须比那更充实。它们背后必须有实质内容，这样我们才能查看。然后我们必须去寻找合适的软件，将这些内容汇总成投资组合视图，以便高管获得他们想要的洞察。

**(01:04:00):**
We also had to build a way to track the OKRs that were deployed and actually see where it was. So we had to build the dashboards for that. So we started there and that became really important because that was a big issue was just the executive visibility, how do we make consistent roadmaps across the organizations, how do we get visibility into what's going on. As we started to identify more and more things, we said, "We're a huge team. We should actually have somebody overseeing this."

**中文翻译:**
我们还必须建立一种跟踪已部署 OKR 的方法，并实际查看进度。所以我们必须为此建立仪表板。我们从那里开始，这变得非常重要，因为高管的可见性是一个大问题：我们如何在整个组织中制定一致的路线图？我们如何获得对现状的可见性？随着我们发现的事情越来越多，我们说：“我们是一个庞大的团队，我们确实应该有人来监督这件事。”

**(01:04:27):**
Data and insights was a really big issue in the company in general, and we knew we had to instrument things better, and at the time, they brought in Amplitude and they were starting to put an Amplitude everywhere in the organization, but it wasn't fully rolled out yet. So we had these people who were going around trying to help the individual product teams get the information out of Amplitude and we said, "We need this to be more of a consistent thing, a consistent program."

**中文翻译:**
数据和洞察在公司整体上也是一个大问题，我们知道必须做好埋点。当时他们引入了 Amplitude，并开始在整个组织中推广，但还没有完全铺开。所以我们安排了一些人到处跑，帮助各个产品团队从 Amplitude 中提取信息。我们说：“我们需要让这成为一个更一致的事情，一个一致的项目。”

**(01:04:52):**
So that sparked the need for having our first product operations leader. So we ended up creating a VP of product operations and somebody moved from the product management role into that. She was much more of a process type person. She wanted to really help arm the teams into being able to get good data out there, but she understood product management well enough where she knew how all this stuff worked and she wanted to create the systems internally.

**中文翻译:**
这激发了对第一位产品运营领导者的需求。于是我们最终设立了产品运营副总裁一职，有人从产品管理岗位转到了这个岗位。她是一个非常注重流程的人。她真心想帮助武装团队，让他们能获得优质数据，但她也足够了解产品管理，知道这一切是如何运作的，她想在内部建立这些系统。

**(01:05:17):**
So reporting into her, we had a business data and insights team that was overseeing Amplitude rollout and they were also putting people around the director level overseeing usually five to let's say eight Scrum teams on the director level, sometimes smaller just depending on the product. We had a business data and insights person embedded at that level to help get the ad hoc reports out now because we weren't well-instrumented. We said, "We're still making the programs and the shared services at the top level, but these people need to make decisions today. So how do we get them to do that?" So she oversaw that team. She had somebody directed there.

**中文翻译:**
向她汇报的有业务数据与洞察团队，负责监督 Amplitude 的推行。他们还在总监级别安排了人员，通常一个总监负责 5 到 8 个 Scrum 团队。由于当时埋点还不完善，我们在那个级别嵌入了一名业务数据与洞察人员，帮助提取临时报告。我们说：“我们仍在顶层制定项目和共享服务，但这些人今天就需要做决策。我们怎么帮他们？”所以她负责管理那个团队，并在那里安排了专人。

**(01:05:55):**
then we also had the people looking at the portfolio views and the governance and the rollout and the rollout of that getting put into that as well. So that helped us get going with that. On the other side, so this didn't fall under product operations at the time, but like I said, Jen Cardello was doing research ops there and leading this team around the user insights. She got the participant database out. That was fantastic. She got out a bunch of different user research tools. They made a design systems database too that helped us be able to do prototyping a lot faster and have consistent design processes, which was amazing.

**中文翻译:**
然后我们还有人负责投资组合视图、治理和推行工作。这帮助我们启动了。另一方面（当时这还不属于产品运营），就像我说的，Jen Cardello 在那里负责研究运营，领导用户洞察团队。她建立了受访者数据库，这太棒了。她引入了一系列不同的用户研究工具。他们还建立了一个设计系统数据库，帮助我们更快地制作原型并拥有一致的设计流程，这非常了不起。

**(01:06:32):**
The head of UX reported into the chief product officer. So it still fell under the CPO, but it reported into the head of UX on that side and that was totally fine because we just collaborated with them pretty much all the time. So that's how we started to roll it out and get going and that's where that need was and it became so much better to get the insights that we needed out there.

**中文翻译:**
UX 负责人向首席产品官汇报。所以它仍然属于 CPO 管辖，但在那一边是向 UX 负责人汇报，这完全没问题，因为我们几乎一直在与他们协作。这就是我们开始推行并启动的过程，需求就在那里，之后获取所需的洞察变得容易多了。

**(01:06:53):**
Then what happened was, actually, Athenahealth at this time, it was really wild and private. So this is where I left and a lot of leaders left at the same time, but they ended up restructuring it and they actually kept the product ops team. So now, Tim Davenport oversees product ops team. He was the chief of staff for the chief product officer at the time and he's been building it, again, taking the stuff that worked and then building onto it, and they're actually one of our key studies in the book as well about what Tim's doing now and how he's orchestrated as well to help with opex and capex and accounting type issues that they were having too.

**中文翻译:**
后来发生的是，当时的 Athenahealth 经历了一些剧变并私有化了。那是我离开的时候，很多领导也同时离开了。但他们最终进行了重组，并且实际上保留了产品运营团队。现在，Tim Davenport 负责产品运营团队。他当时是首席产品官的幕僚长（Chief of Staff），他一直在建设这个团队，保留了有效的部分并在此基础上继续发展。他们也是我们书中的关键案例研究之一，介绍了 Tim 现在的做法，以及他如何协调处理他们面临的运营支出（opex）、资本支出（capex）和会计类问题。

**(01:07:28):**
So Athenahealth has been through many different restructurings since I've been there, but they have always kept product ops and their current chief product officer said that he will never go anywhere else that doesn't have product ops. That's how much he believes in it.

**中文翻译:**
自从我在那里工作以来，Athenahealth 经历了许多次重组，但他们始终保留了产品运营。他们现任的首席产品官说，他再也不会去任何没有产品运营的公司了。这就是他对此的坚信程度。

---

### [01:07:43] Lenny

**English:**
Wow. What a testament to the value of product ops, 100% retention on the role through all these transitions. One of the interesting things you said is within this VP of product ops managed a bunch of different people and teams, which is really interesting because I always imagine product ops VP would manage product ops people. Is that common where they lead, say, there's a data team you mentioned and a few other team?

**中文翻译:**
哇。这真是产品运营价值的有力证明，在所有这些转型中，这个角色被 100% 保留了下来。你提到的一件有趣的事是，这位产品运营副总裁管理着一群不同的人和团队。这很有趣，因为我一直以为产品运营副总裁只管理产品运营人员。他们领导数据团队（如你提到的）和其他几个团队，这种情况常见吗？

---

### [01:08:06] Melissa Perri

**English:**
Yeah. In this case, we did have her managing the business data and insights people and they were data analysts. I wouldn't say they were data engineers or anything like that, but there were people who were really good at pulling SQL and analyzing data from a product perspective. We actually moved. I should say this as well. We moved a lot of people who didn't want to be product managers but were good at that out of the role and into that role. So they had some product background, they had been trained in product, they were really good at the data pieces, but they were more suited for that than they were suited for product management.

**中文翻译:**
是的。在这种情况下，我们确实让她管理业务数据与洞察人员，他们是数据分析师。我不会说他们是数据工程师之类的，但他们是非常擅长编写 SQL 并从产品角度分析数据的人。我也应该提到这一点：我们将很多不想当产品经理但擅长数据的人从 PM 岗位调到了这个岗位。所以他们有一定的产品背景，接受过产品培训，非常擅长数据部分，但他们比产品管理更适合这个岗位。

**(01:09:00):**
Like I said, a lot of people opted out. They were like, "Get me out of this role. I don't want to do this." They wanted more of a transactional type role or diving into data, and a lot of it came down to I think people under anticipate how much they're going to have to deal with stakeholders, and once they have to, they're like, "Oh, God, I don't want to do this," and I see that over and over again when it happens with product management.

**中文翻译:**
就像我说的，很多人选择了退出。他们说：“让我离开这个岗位，我不想做这个。”他们想要更偏向事务性的角色或钻研数据。我认为很大程度上是因为人们低估了他们必须处理利益相关者的程度，一旦他们必须面对，他们就会说：“噢天哪，我不想做这个。”在产品管理领域，我一次又一次地看到这种情况发生。

**(01:09:33):**
So she oversaw them, but they did work closely with the data people on the CTO side. There was a whole data team on the CTO side who were doing more of the database administration and the instrumentation of things. They were also helping to roll out Amplitude, instrument it correctly, and building the right views and things like Amplitudes or the other product analytics or other tools that they were using. We did not have Tableau at the time. That was something that was added later, but they were in charge of utilizing the data and trying to build those insights.

**中文翻译:**
所以她监管他们，但他们确实与 CTO 那边的数据人员密切合作。CTO 那边有一个完整的数据团队，负责更多的数据库管理和埋点工作。他们还帮助推行 Amplitude，正确埋点，并构建正确的视图。当时我们还没有 Tableau，那是后来加上的。但他们负责利用数据并尝试建立那些洞察。

---

### [01:09:33] Lenny (Lightning Round)

**English:**
Amazing. With that, we've reached our very exciting lightning round. I've never done this with two people. We'll see how it goes. So you can pick the question you want to take or both answer. Here we go. What are two or three books you've recommended most to other people?

**中文翻译:**
太棒了。至此，我们进入了非常令人兴奋的闪电轮环节。我从未同时对两个人做过这个，看看效果如何。你们可以选择想回答的问题，或者两个人都回答。开始吧。你们向别人推荐最多的两三本书是什么？

---

### [01:10:15] Denise Tilles / Melissa Perri

**Denise:**
I'll take that. Of course, *Escaping the Build Trap*. It's true. Another one that I recommend is called *Traffic*. It came out this year by Ben Smith, around the invention and growth of HuffPo and Gawker and whatnot.

**Melissa:**
*The Art of Action* I think is a fantastic book on strategy. It's a sleeper hit in the product management community. It's a fantastic description of deploying strategy. I love Theresa Torres' *Continuous Discovery Habits* as well.

**中文翻译:**
**Denise:** 我来回答。当然是《走出构建陷阱》。这是真的。另一本我推荐的是 Ben Smith 今年出的《流量》（*Traffic*），关于赫芬顿邮报（HuffPo）和 Gawker 等媒体的创立和成长。

**Melissa:** 我认为《行动的艺术》（*The Art of Action*）是一本非常棒的战略书。它是产品管理界的一个“冷门佳作”。它对战略部署的描述非常精彩。我也很喜欢 Theresa Torres 的《持续发现习惯》（*Continuous Discovery Habits*）。

---

### [01:10:57] Lenny

**English:**
Next question, favorite recent movie or TV show that you've really enjoyed?

**中文翻译:**
下一个问题，最近非常喜欢的电影或电视剧？

---

### [01:11:01] Denise Tilles / Melissa Perri

**Denise:**
*Deutschland 82, 86, 89*. It's on Hulu. Highly recommend it, about East Germany.

**Melissa:**
I just watched the *House of Usher* on Netflix. I love the scary movies.

**Lenny:**
My wife and I have been stuck on *Love is Blind*. Classic.

**中文翻译:**
**Denise:** 《德国 82, 86, 89》。在 Hulu 上。强烈推荐，关于东德的。

**Melissa:** 我刚看了 Netflix 上的《亚瑟府的没落》（*House of Usher*）。我喜欢恐怖片。

**Lenny:** 我和我妻子最近沉迷于《盲婚试爱》（*Love is Blind*）。经典。

---

### [01:11:45] Lenny

**English:**
Next question, do you have a favorite interview question that you'd like to ask when you're hiring people?

**中文翻译:**
下一个问题，招聘时最喜欢问的面试问题是什么？

---

### [01:11:49] Denise Tilles / Melissa Perri

**Denise:**
When was the last time you changed your mind about something really important and why? Do they have a learning mindset?

**Melissa:**
Tell me about a time that you failed and what happened. I'm looking for did you fail and did you learn something from it.

**中文翻译:**
**Denise:** 你上一次改变对某件非常重要的事情的看法是什么时候，为什么？我想看他们是否有学习心态。

**Melissa:** 告诉我一次你失败的经历以及发生了什么。我想看你是否失败过，以及你是否从中吸取了教训。

---

### [01:12:43] Lenny

**English:**
Do you have a favorite product you've recently discovered that you really like?

**中文翻译:**
最近有没有发现什么特别喜欢的、让你眼前一亮的产品？

---

### [01:12:47] Melissa Perri / Denise Tilles

**Melissa:**
I discovered Dragonboat and I'm now on their advisory board. It helped me solve that portfolio management problem. Another one is Dovetail, a research repository.

**Denise:**
I guess the one I would mention is Vistaly. It's an interesting tool that's a single workspace that you can connect your strategy and discovery and delivery visually.

**中文翻译:**
**Melissa:** 我发现了 Dragonboat，现在我是他们的顾问。它帮我解决了投资组合管理的问题。另一个是 Dovetail，一个研究知识库。

**Denise:** 我想提的是 Vistaly。这是一个有趣的工具，它是一个单一工作区，可以让你以可视化方式连接战略、发现和交付。

---

### [01:14:05] Lenny

**English:**
Do you have a favorite life motto that you often repeat to yourself, often share with someone, come back to often to help either with work or with life?

**中文翻译:**
你有没有最喜欢的人生格言，经常对自己说，或者分享给别人，用来指导工作或生活？

---

### [01:14:15] Denise Tilles / Melissa Perri

**Denise:**
If you try to serve everybody, you serve no one.

**Melissa:**
What's the worst that can happen? It helps me manage my anxiety around difficult situations.

**中文翻译:**
**Denise:** 如果你试图服务所有人，你谁也服务不了。

**Melissa:** 最坏的情况会是什么？这能帮我缓解面对困难情况时的焦虑。

---

### [01:15:27] Lenny

**English:**
I love that. Final question, since there's two of you, we'll end in a really sweet way. What's one thing you really admire about each other?

**中文翻译:**
我喜欢这个。最后一个问题，既然你们有两个人，我们就以一种非常温馨的方式结束。你们最钦佩对方的一点是什么？

---

### [01:15:36] Denise Tilles / Melissa Perri

**Denise:**
Melissa is a legend, but she's just a really great collaborative person. She truly wants to help people.

**Melissa:**
Denise is this calming, patient presence. She approaches everything with so much professionalism and can really get to the meat of the problem.

**中文翻译:**
**Denise:** Melissa 是个传奇，但她也是一个非常棒的合作伙伴。她真心想帮助别人。

**Melissa:** Denise 给人一种冷静、耐心的感觉。她处理任何事情都非常专业，并且能直击问题的核心。

---

### [01:17:17] Lenny

**English:**
Amazing. You two are awesome. For folks listening, make sure to grab their book, *Product Operations*. You can find it on Amazon, I imagine. Share where else people can find it, but two final questions. Where can folks find you online if they want to reach out and how can listeners be useful to you?

**中文翻译:**
太棒了。你们两位太出色了。各位听众，一定要去买她们的书《产品运营》（*Product Operations*）。我想在亚马逊上就能找到。请分享一下大家还能在哪里找到它。最后两个问题：如果大家想联系你们，可以在哪里找到你们？听众可以为你们做些什么？

---

### [01:17:32] Denise Tilles / Melissa Perri

**Denise:**
Productoperations.com. Tell us your stories about product operations. We want to hear how people are implementing it.

**Melissa:**
Buy the book and leave us an Amazon review! You can find us on LinkedIn as well.

**中文翻译:**
**Denise:** 访问 Productoperations.com。告诉我们你们关于产品运营的故事。我们想听听大家是如何实施的。

**Melissa:** 买书并在亚马逊上给我们留个好评！你也可以在 LinkedIn 上找到我们。

---

### [01:19:00] Lenny

**English:**
Amazing. Thank you two for being here. My pleasure. Bye, everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify or your favorite podcast app. See you in the next episode.

**中文翻译:**
太棒了。谢谢两位来到这里。我的荣幸。大家再见。非常感谢收听。如果你觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用上订阅。下期节目见。