# Melissa Tan - 双语对照

# Lenny's Podcast: Melissa Tan (Bilingual Transcript)

---

### [00:00:00] Melissa Tan

**English:**
My aha moment of the value of first principles thinking was when I was at Dropbox. We would hire a ton of really smart people that had never done sales and had them do sales. There are a lot of disadvantages to that, but I do think it led to a ton of innovation. That's how we got our very innovative go-to market motions because a lot of those people then moved into different functions at the company. They had all this context on who the user was. They had talked to so many different users at that point. If you take people that are just super smart, they've never done it before, one advantage of that is they can innovate because I think they come in with, I don't know anything. Let me just figure this out.

**中文翻译:**
我对“第一性原理思维”价值的顿悟时刻发生在我还在 Dropbox 的时候。我们当时雇佣了一大批非常聪明但从未做过销售的人，并让他们去跑销售。这样做有很多弊端，但我认为它也带来了大量的创新。这正是我们获得那些极具创新的“进入市场”（GTM）动作的原因，因为这些人后来转到了公司的不同职能部门。他们对用户是谁拥有极其完整的背景信息，因为在那之前他们已经和太多不同的用户交流过了。如果你录用那些极其聪明但从未涉足过该领域的人，一个优势就是他们能够创新，因为他们进来时会想：“我什么都不知道，让我来把这事儿搞清楚。”

---

### [00:00:38] Lenny

**English:**
Welcome to Lenny's podcast, where I interview world-class product leaders and growth experts to learn from their hard one experiences building and growing today's most successful products. Today my guest is Melissa Tan. Melissa was the longtime head of growth for Dropbox's B2B business. She's also their first growth product manager. Then she went on to do full-time advising for companies like Canva, Grammarly, Miro, and Ro, helping them with their growth strategy and helping them build their growth teams.

**中文翻译:**
欢迎来到 Lenny 的播客。在这里，我会采访世界级的跨国产品领导者和增长专家，学习他们在构建和发展当今最成功产品过程中积累的宝贵经验。今天的嘉宾是 Melissa Tan。Melissa 曾长期担任 Dropbox B2B 业务的增长负责人，她也是该公司的第一位增长产品经理。随后，她开始全职担任 Canva、Grammarly、Miro 和 Ro 等公司的顾问，帮助他们制定增长策略并组建增长团队。

---

### [00:01:03] Lenny

**English:**
For the past two and a half years, she's been leading growth at Webflow. But hot off the presses as Melissa shares at the top of this podcast, she's going back to full-time advising life. So if you're looking for help with go-to market plans, growth strategy, building your growth team, aligning your sales, marketing and growth efforts, she's about to become available, so definitely reach out. In our conversation, we get deep into what it takes to build a high performing team and also how to build a high performing growth team, specifically.

**中文翻译:**
在过去的两年半里，她一直在 Webflow 领导增长工作。但正如 Melissa 在本期播客开头分享的最新消息，她将回归全职顾问生活。所以，如果你在寻求进入市场计划、增长策略、组建增长团队，或者协调销售、营销和增长工作方面的帮助，她即将有档期，一定要联系她。在我们的对话中，我们将深入探讨如何打造一支高效团队，特别是如何打造一支高效的增长团队。

---

### [00:01:30] Lenny

**English:**
Melissa shares advice for becoming a leader that people will follow from company to company, how to best develop your people to become the best versions of themselves. She talks about the most common ingredients of a high performing team and what she's learned from working with companies like Canva, Grammarly, Miro, Ro, Webflow and Dropbox. We also get into how to interview product managers and she shares her actual interview process, plus who your first growth hire should probably be, the most common mistakes people make when they first start to invest in growth and a real talk story of what Dropbox did right and what they did wrong in their shift to B2B. There are so many golden nuggets of lessons in this episode and I'm excited to bring it to you. With that, I bring you Melissa Tan after a short word from our sponsors.

**中文翻译:**
Melissa 分享了如何成为一名让下属愿意追随你到不同公司的领导者，以及如何最好地培养员工，让他们成就最好的自己。她谈到了高效团队最常见的要素，以及她从 Canva、Grammarly、Miro、Ro、Webflow 和 Dropbox 等公司的工作中学到的经验。我们还讨论了如何面试产品经理，她分享了自己实际的面试流程，此外还包括：谁应该是你的第一个增长职位的雇员、人们在开始投入增长时最常犯的错误，以及关于 Dropbox 在向 B2B 转型过程中哪些做得对、哪些做得错的真实案例。这一集里有很多金句和教训，我很高兴能把它带给大家。在听完赞助商的简短介绍后，我们将请出 Melissa Tan。

---

### [00:02:14] Lenny

**English:**
Today's episode is brought to you by AssemblyAI. If you're looking to build AI powered features in your audio and video products, then you need to know about AssemblyAI, which makes it easy to transcribe and understand speech at scale. What I love about AssemblyAI is you can use their simple API to access the latest AI breakthroughs from top tier research labs, product team that startups and enterprises are using AssemblyAI to automatically transcribe and summarize phone calls and virtual meetings, detect topics in podcasts, pinpoint when sensitive content is spoken and lots more.

**中文翻译:**
本期节目由 AssemblyAI 赞助。如果你想在音视频产品中构建 AI 驱动的功能，那么你需要了解 AssemblyAI，它可以轻松实现大规模的语音转录和理解。我喜欢 AssemblyAI 的一点是，你可以通过他们简单的 API 访问来自顶级研究实验室的最新 AI 突破。初创公司和企业的开发团队正在使用 AssemblyAI 自动转录和总结电话及虚拟会议、检测播客主题、精准定位敏感内容等等。

---

### [00:02:47] Lenny

**English:**
All of AssemblyAI's models, which are accessed through their API are production ready. So many PMs I know are considering or already building with AI and AssemblyAI is the fastest way to build with AI for audio use cases. Now's the time to check out AssemblyAI, which makes it easy to bring the highest accuracy transcription plus valuable insights to your customers. Just like Spotify, CallRail and writer do for theirs. Visit AssemblyAI.com/lenny to try their API for free and start testing their models with their no code playground. That's AssemblyAI.com/lenny.

**中文翻译:**
AssemblyAI 所有通过 API 访问的模型都是生产级别的。我认识的很多 PM 都在考虑或已经在使用 AI 进行构建，而 AssemblyAI 是在音频场景中应用 AI 的最快方式。现在是了解 AssemblyAI 的最佳时机，它可以轻松为你的客户提供最高准确度的转录和有价值的洞察，就像 Spotify、CallRail 和 Writer 所做的那样。访问 AssemblyAI.com/lenny 免费试用他们的 API，并在他们的无代码游乐场（playground）中测试模型。网址是 AssemblyAI.com/lenny。

---

### [00:03:23] Lenny

**English:**
This episode is brought to you by Mixpanel. Get deep insights into what your users are doing at every stage of the funnel at a fair price that scales as you grow. Mixpanel gives you quick answers about your users from awareness to acquisition through retention, and by capturing website activity, ad data, and multi-touch attribution right in Mixpanel, you can improve every aspect of the full user funnel. Powered by first party behavioral data instead of third party cookies, Mixpanel's built to be more powerful and easier to use than Google Analytics. Explore plans for teams of every size and see what Mixpanel can do for you at mixpanel.com/friends/lenny. And while you're at it, they're also hiring. So check it out at mixpanel.com/friends/lenny.

**中文翻译:**
本期节目由 Mixpanel 赞助。以公平且随业务增长而扩展的价格，深入洞察用户在漏斗每个阶段的行为。Mixpanel 能为你提供从认知、获取到留存的快速答案。通过在 Mixpanel 中直接捕获网站活动、广告数据和多触点归因，你可以优化整个用户漏斗的方方面面。Mixpanel 由第一方行为数据而非第三方 Cookie 驱动，其功能比 Google Analytics 更强大且更易用。在 mixpanel.com/friends/lenny 探索适合各种规模团队的方案。顺便提一下，他们也在招聘，请访问 mixpanel.com/friends/lenny 查看。

---

### [00:04:12] Lenny

**English:**
Melissa, welcome to the podcast.

**中文翻译:**
Melissa，欢迎来到播客。

---

### [00:04:14] Melissa Tan

**English:**
Thanks, Lenny. It's great to be here.

**中文翻译:**
谢谢，Lenny。很高兴来到这里。

---

### [00:04:16] Lenny

**English:**
I'm excited to have you on. I hear there's a big development in your career that is going to be out by the time this podcast comes out where you're embarking on a new adventure. I'd love to hear more about it and for folks to understand what you're doing next.

**中文翻译:**
我也很兴奋能邀请到你。我听说你的职业生涯有一个重大进展，在本期播客发布时应该已经公开了，你正开启一段新的冒险。我很想听听更多细节，让大家了解你接下来的打算。

---

### [00:04:30] Melissa Tan

**English:**
Over the last couple years I've been at Webflow building out the growth team there. I'm actually transitioning right now and I'm out right now and I'm going to go back into advising, which is something I was doing a lot of before Webflow working, having been fortunate enough to work with great companies like Canva, Grammarly, Miro, et cetera. And so that's one of my biggest passions is working with earlier stage companies once they found product market fit and helping them scale growth. And I'll be going back into advising.

**中文翻译:**
过去几年我一直在 Webflow 组建增长团队。实际上我目前正在转型期，已经离职了，准备回到顾问工作中去。在加入 Webflow 之前，我做过很多顾问工作，有幸与 Canva、Grammarly、Miro 等优秀公司合作。我最大的热情之一就是与那些已经找到“产品市场匹配”（PMF）的早期公司合作，帮助他们扩大增长规模。所以我将回归顾问生涯。

---

### [00:04:59] Lenny

**English:**
Amazing. That's a huge news because I, there's like a small number of people like Melissa that is available at certain times to work with and this is going to be this window and I just want people to understand what kinds of areas do you think you're going to focus on for folks that may need help and may want to reach out?

**中文翻译:**
太棒了。这是个大新闻，因为像 Melissa 这样级别的专家，只有在特定时间窗口才会有空合作。我想让大家了解一下，对于那些可能需要帮助并想联系你的人，你打算重点关注哪些领域？

---

### [00:05:17] Melissa Tan

**English:**
I've worked with companies across many different stages, so even in the early stage as companies are thinking about their go-to market strategy. Previously at Dropbox, I worked across sales. I also helped start their initial product growth and self-serve team for Dropbox business. I've also overseen pricing and packaging at Webflow. So a lot of companies initially as they're thinking about their go-to market strategy, should they be product led? Should they lean more into sales motion? What should the pricing and packaging look like? I've worked with earlier stage companies and then also post product market fit as companies are building out growth and they want to make sure to optimize the funnel across activation, monetization, engagement retention. I've also advised and helped growth teams, so kind of across stages focus on growth and go-to market.

**中文翻译:**
我曾与处于不同阶段的公司合作过，包括正在思考进入市场（GTM）策略的早期公司。之前在 Dropbox，我负责过销售工作，还帮助建立了 Dropbox Business 最初的产品增长和自助服务（self-serve）团队。在 Webflow，我还负责过定价和包装（pricing and packaging）。很多公司在初期思考 GTM 策略时，会纠结：应该是产品驱动（PLG）吗？还是应该更侧重销售驱动？定价和包装应该是什么样的？我与早期公司合作，也与那些已经过 PMF 阶段、正在构建增长体系并希望优化激活、变现、参与和留存漏斗的公司合作。我也为增长团队提供建议和帮助，所以基本上是跨阶段关注增长和进入市场。

---

### [00:06:03] Lenny

**English:**
I guess while we're on it, what's the best way to reach out as people are listening to this and they're like, "Oh my God, I want to get some help on this stuff."

**中文翻译:**
既然聊到这儿了，如果有人听了之后觉得“天哪，我正需要这方面的帮助”，联系你的最佳方式是什么？

---

### [00:06:09] Melissa Tan

**English:**
Definitely LinkedIn is a good place. I check my LinkedIn, so feel free to reach out there.

**中文翻译:**
LinkedIn 绝对是个好地方。我会看我的 LinkedIn 消息，所以欢迎在那里联系我。

---

### [00:06:15] Lenny

**English:**
Great. So usually we got that covered at the end, but I think that was going to be helpful in case people were like, "Oh, I see what you can help us with." So building on that, I want to focus our conversation on two specific topics that I know that you're specially strong at. One is building high performance teams broadly, and then two is building high performance growth teams specifically. How does that sound as a focus of our conversation?

**中文翻译:**
太好了。通常我们会在结尾才说这些，但我觉得现在说很有帮助，万一有人想：“哦，我知道你能帮我们解决什么了。” 那么基于此，我想把我们的对话集中在你特别擅长的两个特定话题上：一是广义上的打造高效团队，二是具体如何打造高效的增长团队。你觉得这个重点怎么样？

---

### [00:06:41] Melissa Tan

**English:**
Yeah, let's do it. Two topics I'm very passionate about. Let's do it.

**中文翻译:**
没问题，开始吧。这两个话题我非常有热情。

---

### [00:06:45] Lenny

**English:**
So before we get into it too deeply, I want to first talk about Dropbox. So you're at Dropbox for four-ish years, something like that, doing a lot of their growth work and it was in the middle of a lot of their growth spurts and things like that. And when I think Dropbox and growth, there's kind of this dichotomy I think about. On the one hand, there's just these incredible growth loops that work, this referral program, this crazy word of mouth. There's just this explosive growth story of a product.

**中文翻译:**
在深入探讨之前，我想先聊聊 Dropbox。你在 Dropbox 待了大约四年，负责了很多增长工作，当时正值公司增长爆发期。当我想到 Dropbox 和增长时，脑海中会出现一种“二分法”。一方面，它有那些极其成功的增长循环（growth loops），比如推荐计划、疯狂的口碑传播，这是一个典型的产品爆发式增长的故事。

---

### [00:07:11] Lenny

**English:**
And then on the other hand, there's this B2B side that from an outsider just feels like that's something that didn't work for a long time. And then Box came around and did that really well, and I think Dropbox has done better since then, but it feels like this combination of really successful growth and then maybe less successful. So I'm curious, just looking back from your experience and from what you've heard, what do you think Dropbox did and what do you think they did wrong? And then just what are some learnings from that experience and watching Dropbox go through that?

**中文翻译:**
但另一方面，它的 B2B 业务在局外人看来，似乎很长一段时间都没起色。后来 Box 出现并在这方面做得很好。虽然我认为 Dropbox 后来追上来了，但感觉它像是极其成功的增长与不太成功的尝试的结合体。所以我很好奇，回顾你的经历和你所听到的，你认为 Dropbox 哪些做对了，哪些做错了？从观察 Dropbox 的这段历程中，你学到了什么？

---

### [00:07:40] Melissa Tan

**English:**
Yeah, it's a great question. And having been at Dropbox for close to five years, I did a lot of reflection while I was there. So I was there from 2013 to 2017, around 200 people. I think about a billion dollar valuation to essentially ... I think when I left we were 1,500 people and we're valued at 10 billion at the IPO. I think the things that Dropbox got right, one of them was definitely hiring. So when I think about 2013, Dropbox was actually known in the tech circles as a place that was very selective, very difficult to get into. You could have an amazing resume, and Dropbox was really selective about the type of people they brought in. So I think they looked for two main things. They looked for first principles thinkers, so not necessarily your experience, but how do you approach problems, how do you know the right questions to ask? And then create your own framework around that.

**中文翻译:**
这是个好问题。在 Dropbox 待了近五年，我确实做了很多反思。我是 2013 年加入的，2017 年离开，当时公司从 200 人左右增长到我离开时的 1500 人，估值也从约 10 亿美元增长到 IPO 时的 100 亿美元。我认为 Dropbox 做对的事情之一绝对是招聘。回想 2013 年，Dropbox 在技术圈以门槛极高、极难进入而闻名。即使你有一份惊艳的简历，Dropbox 对人才的筛选依然非常严格。我认为他们主要看重两点：一是“第一性原理”思考者，即不一定看你的经验，而是看你如何处理问题，是否知道该问什么样的问题，并围绕这些问题建立自己的框架。

---

### [00:08:32] Melissa Tan

**English:**
Dropbox also hired for people that were just really humble, collaborative and team oriented. And the combination of those two things, people that were just first principle thinkers also just really collaborative to tons of innovation. And so when you think about freemium product led growth, even we created a high velocity sales motion there, there was just so much innovation because you had these folks that just knew how to solve problems and worked really well cross-functionally across product growth, sales, et cetera.

**中文翻译:**
Dropbox 招聘的另一类人是那些非常谦逊、具有协作精神且以团队为导向的人。这两者的结合——既是第一性原理思考者又极具协作精神——带来了大量的创新。所以当你想到免费增值（freemium）和产品驱动增长（PLG）时，甚至我们在那里创建的高速销售模式，都有如此多的创新，因为你拥有一群知道如何解决问题，并且在产品、增长、销售等部门之间跨职能协作得非常好的人。

---

### [00:09:04] Melissa Tan

**English:**
And also, broadly speaking, the company just infused the topic of hiring and recruiting into the culture. It was something that as I was there, everyone knew we were all going to be spending a ton of time interviewing. We all were trained on how to sell Dropbox and how to sell the roles we were recruiting for too so that we could close top talent. So I think that's something we definitely got and I learned a ton about. The other thing was the importance of execution.

**中文翻译:**
此外，从广义上讲，公司将招聘和人才搜寻融入了文化。我在那里的时候，每个人都知道我们要花大量时间进行面试。我们都接受过培训，学习如何“推销” Dropbox，以及如何推销我们正在招聘的职位，以便能够签下顶尖人才。我认为这是我们做得非常出色的一点，我也从中受益匪浅。另一件事是执行的重要性。

---

### [00:09:28] Melissa Tan

**English:**
So a lot of times at Dropbox we would try something and it didn't work the first time around and it was easy to be maybe say that just doesn't work for us, like growth. We actually had tried to do some growth experiments back in 2013 and they didn't find much traction, but what we found is the devil, I like to say the devils and the details and the devils and how you execute. And so coming back to how do we execute just a little bit differently and some of the learnings there where I think the first time we started growth, we could have been more user-centric and been a lot more hypothesis driven. We were following a lot of best practices that just didn't really apply to Dropbox.

**中文翻译:**
在 Dropbox，很多时候我们尝试了一些东西，第一次没成功，这时很容易会说“这玩意儿对我们没用”，比如增长实验。实际上我们在 2013 年就尝试过一些增长实验，但没看到什么起色。但我们发现，正如那句话所说，“魔鬼隐藏在细节中”，也隐藏在你的执行方式中。所以我们反思如何以稍微不同的方式执行。其中的教训是，我认为我们第一次开始做增长时，本可以更以用户为中心，更多地由假设驱动。当时我们遵循了很多所谓的“最佳实践”，但那些其实并不适用于 Dropbox。

---

### [00:10:04] Melissa Tan

**English:**
And so the way that you execute ends up really mattering. That was the second learning. The third is just focus. I think you alluded to this, I think the blessing and the curse of early success is that you can get pulled in so many different directions and Dropbox had a consumer business, a B2B business, and I think we could have clarified what is our point of view on what the overall motion should look like, how do we blend and think about the journey from consumer to B2B really early on, and I think a learning was that we just started our sales motion and our enterprise a little bit later than we should have and a lot of competition caught up to us.

**中文翻译:**
所以，执行的方式最终至关重要。这是第二个教训。第三个是专注。我想你刚才也提到了，早期成功的“既是福也是祸”在于你会被拉向太多不同的方向。Dropbox 当时有消费者业务和 B2B 业务，我认为我们本可以更早地明确整体运作模式的观点：我们该如何融合并思考从消费者到 B2B 的用户路径？我认为一个教训是，我们启动销售模式和企业级业务的时间比应有的晚了一点，导致很多竞争对手赶了上来。

---

### [00:10:44] Melissa Tan

**English:**
And then finally, I think the fourth one that I really believe in is how do you engage the whole company in thinking about go-to-market growth and revenue. Back in 2013, in tech growth was kind of like this dirty word and revenue was a dirty word, and so we were like, "Oh, a good product should sell itself. And it wasn't until our self-serve business started to slow down that we started our team because we realized there's a ton of opportunity in just optimizing the experience.

**中文翻译:**
最后，我深信的第四点是：如何让全公司都参与到对进入市场、增长和收入的思考中。早在 2013 年，在技术圈，“增长”有点像个贬义词，“收入”也是。我们当时觉得：“哦，好的产品应该能自己卖出去。” 直到我们的自助服务业务开始放缓，我们才组建了团队，因为我们意识到仅仅通过优化体验就有巨大的机会。

---

### [00:11:10] Melissa Tan

**English:**
And because we started a bit later, it always felt like growth was a layer on top of product. I think the best way to execute is just to have that be front and center from the start. What is our go-to market strategy? How are we thinking about monetization and having that infused into how you think about product development? And that's something both JZ who leads product at Webflow and myself been really intentional as we've thought of the collaboration across product and growth. So that was definitely a learning. So I guess the four things there are just the importance of hiring, execution. Think about your go-to market early on and then how do you engage the whole company on thinking about go-to market and growth.

**中文翻译:**
因为我们起步较晚，增长总让人感觉像是叠加在产品之上的一个层级。我认为最好的执行方式是让它从一开始就处于核心地位。我们的 GTM 策略是什么？我们如何考虑变现？并将这些融入到你思考产品开发的过程中。这是 Webflow 的产品负责人 JZ 和我在思考产品与增长协作时非常刻意去做的。所以这绝对是一个教训。总结一下，这四点就是：招聘的重要性、执行力、尽早思考 GTM，以及如何让全公司都关注 GTM 和增长。

---

### [00:11:50] Lenny

**English:**
You said Dropbox essentially there was a late investment in sales and there's a sense maybe product led growth's going to take us really far. And I imagine look at Jira and Atlassian, they're just all product led and that's amazing. I guess what's your current framework for when it makes sense to start leaning into sales and hiring a sales team for say a product led product that is working?

**中文翻译:**
你提到 Dropbox 基本上在销售上的投入太晚了，当时可能觉得产品驱动增长（PLG）能带我们走很远。我想到了 Jira 和 Atlassian，他们完全是产品驱动的，这很了不起。那么，对于一个运作良好的 PLG 产品，你现在的框架是什么？什么时候开始转向销售并组建销售团队才合理？

---

### [00:12:12] Melissa Tan

**English:**
It really comes down to the product because initially I think most companies are leaning heavier into sales or heavier into product-led. You're usually not doing both at the same time. And so a trend I've seen is starting product-led first and the signal is that is a good motion for you is if the product is really intuitive to onboard onto. There's a low learning curve so you don't need a human to onboard the user. Also, if there's a viral component to it, that is really what can take.

**中文翻译:**
这最终取决于产品。最初，大多数公司要么侧重销售，要么侧重产品驱动，通常不会同时进行。我看到的一个趋势是先从产品驱动开始，而判断这是否适合你的信号是：产品的新手引导（onboarding）是否非常直观？学习曲线是否很低，以至于不需要人工干预？此外，如果产品具有病毒式传播的组件，那才是真正能起飞的关键。

---

### [00:12:43] Melissa Tan

**English:**
Dropbox is massively viral. When I think also about Miro or Figma, those also are very viral products. Those have a kind of the DNA of product led. And initially I think when you have scale, you're getting a lot of signal on what is resonating with the user. Initially, you also don't have ... It takes a while to build out the features for enterprise. And so as you're building out the product-led motion, you have probably larger companies in your self-serve base and they are often knocking on your door.

**中文翻译:**
Dropbox 具有极强的病毒性。当我想到 Miro 或 Figma 时，它们也是非常具有病毒性的产品，拥有 PLG 的基因。最初，当你有了规模，你会收到很多关于用户共鸣点的信号。起初，你还没有……毕竟构建企业级功能需要时间。所以当你构建 PLG 模式时，你的自助服务用户群中可能会出现大公司，他们经常会主动找上门来。

---

### [00:13:15] Melissa Tan

**English:**
This happened at Dropbox being like, "I need you to build SSO for me. I need you to build all these enterprise grade features. It's not secure enough." And so you are also collecting the list of things you need to build on the enterprise side. And so I think it's typically looking like you might start product-led, then go enterprise. And then the other direction I've seen is some companies initially are just more conducive to an enterprise in sales motion. Potentially, you need to build custom things for these users. It's also not a bottom-up motion. Maybe the way you sell the product starts with the legal team or the finance team or some important stakeholder, but then a lot of companies now are trying to make that shift to make the product more accessible and go product led.

**中文翻译:**
这在 Dropbox 就发生过，用户会说：“我需要你们为我构建 SSO（单点登录），我需要这些企业级功能，现在的安全性不够。” 于是你开始收集企业端需要构建的功能清单。所以通常的路径是先 PLG，再进军企业级。我也见过另一种方向：有些公司最初更适合企业销售模式，可能需要为这些用户构建定制化功能。这也不是一种“自下而上”的模式，销售可能从法务、财务或某些重要利益相关者开始。但现在很多公司都在尝试转型，让产品更易获得，走 PLG 路线。

---

### [00:13:56] Melissa Tan

**English:**
And so then you're thinking about, okay, how do I make this product simpler to onboard onto? How do I think about reaching the end user at scale? And so I think it's basically first figuring out where do you start and then starting to invest in the area. And I guess maybe lastly, knowing how the whole picture fits together. There's a lot of companies that do consumer and B2B and I think the earlier you can figure out how they go together and what the paths and journeys look like, it just ends up being more seamless to the user and, yeah.

**中文翻译:**
所以你会思考：如何让产品的新手引导更简单？如何大规模触达终端用户？我认为基本上是先弄清楚从哪里开始，然后开始在该领域投资。最后一点可能是，要了解整体图景是如何拼凑在一起的。很多公司同时做消费者和 B2B 业务，我认为越早弄清楚它们如何结合、用户路径和旅程是什么样的，对用户来说体验就越无缝。

---

### [00:14:30] Lenny

**English:**
Awesome. Okay, so let me start to transition into talking about building awesome teams and high performing teams. And something that I know about you that I've heard from other people is that you have this reputation for being a person that people follow from company to company, which is the ultimate sign of, I don't know, retention and NPS and product market fit as a leader and a manager. So I'm just curious, what is it that you think you do that gets people to follow you from company to company?

**中文翻译:**
太棒了。好，让我们开始转向讨论如何打造优秀的团队和高效团队。我从别人那里听说，你有一个名声：人们愿意追随你从一家公司到另一家公司。这简直是作为领导者和管理者的留存率、NPS（净推荐值）和“产品市场匹配”的终极体现。所以我很好奇，你觉得你做了什么，能让人们愿意这样追随你？

---

### [00:14:57] Melissa Tan

**English:**
I've been really fortunate. I've worked with a few folks from my early Dropbox team that I've known for 10 years now, like a couple of times. In some case, three times. And I always feel so privileged that I get the opportunity to work with them again and they have that trust and confidence in me. I think what it is, and it took me time to develop this, is I have a very people focused approach to how I lead and manage. I really think the core of it is deeply caring about people, building that trust, investing in their career development, helping them figure out where they want to go in their career. I think for me it's very personal. I have been really fortunate to have great mentors and managers that helped me in those respects. And so it really started from just paying it forward and wanting to do the same thing for other people that were on my team. I think it just comes down to deeply caring and everything, all your actions follow through from there. So that's how I would describe that.

**中文翻译:**
我一直很幸运。我曾与早期 Dropbox 团队的几位同事合作过，我们认识 10 年了，期间合作过好几次，有的甚至合作了三次。我总觉得能再次与他们共事是一种荣幸，他们对我充满信任。我想其中的关键在于——我也花了一些时间才形成这种风格——我有一种非常“以人为本”的领导和管理方式。核心是深切地关心员工，建立信任，投资于他们的职业发展，帮助他们弄清楚职业生涯的走向。对我来说，这非常个人化。我很幸运遇到过优秀的导师和经理在这些方面帮助过我。所以这其实源于一种“回馈”的心态，想对团队成员做同样的事。归根结底就是深切的关怀，你所有的行动都会由此而生。这就是我的理解。

---

### [00:15:55] Lenny

**English:**
Some people may be hearing that and feel like there's this choice you have to make as a leader deeply care about the person or drive impact, focus on getting the work done. Do you find that those can coexist or is it this kind of two ends of a spectrum and maybe the question's just like how do you do both? How do you help people yes, achieve and drive impact while also feeling like you really care about them?

**中文翻译:**
有些人听了可能会觉得，作为领导者必须在“深切关心员工”和“推动影响力/专注于完成工作”之间做选择。你觉得这两者可以共存吗？还是说它们是光谱的两端？或者问题应该是：你如何兼顾两者？你如何既帮助人们取得成就、产生影响，又让他们感受到你真的关心他们？

---

### [00:16:15] Melissa Tan

**English:**
I don't think that they're mutually exclusive of each other because I think the other thing that I really emphasize on my team is being very results oriented. So as a growth leader, for better or for worse, everything you do is very measurable. And so I actually think this is why a lot of folks on my team, something that they actually appreciate is knowing what success looks like and knowing how they'll be measured. And I actually create a very results-oriented culture on the team where it's clear what our goals are, we break it down into the individual levers, it's clear how success is measured for each individual.

**中文翻译:**
我不认为它们是互斥的。因为我在团队中强调的另一件事是“结果导向”。作为增长负责人，无论好坏，你所做的一切都是高度可衡量的。所以我认为这正是团队成员所感激的地方：他们知道成功是什么样子的，也知道自己将如何被考核。我在团队中建立了一种非常结果导向的文化，目标明确，并将其分解为具体的杠杆，每个人的成功衡量标准都清晰可见。

---

### [00:16:54] Melissa Tan

**English:**
And so I don't think they are mutually exclusive. And then my role as a leader is also supporting their career growth, helping them meet those goals and giving them feedback along the way. So even though they might sound like two different things, I actually think they can coexist and for me, I actually really lean into both.

**中文翻译:**
所以我不认为它们互斥。而我作为领导者的角色，就是支持他们的职业成长，帮助他们达成目标，并在过程中提供反馈。虽然听起来像是两回事，但我认为它们可以共存，而且我个人会同时侧重这两方面。

---

### [00:17:15] Lenny

**English:**
What's an example of caring deeply about someone and being that kind of leader? People may be listening and are like, "Oh yeah, I care a lot about my reports." But what are some examples of what that means to you that maybe would surprise people?

**中文翻译:**
能不能举个例子，说明什么是“深切关心某人”以及做那样的领导者？人们听了可能会想：“哦，我也很关心我的下属啊。” 但对你来说，这意味着什么？有没有什么例子可能会让大家感到意外？

---

### [00:17:27] Melissa Tan

**English:**
I think an example from someone that they joined my team and I just early on thought that they weren't maybe moving quickly enough and they needed some more direction. And so really early into them joining the company, that was about two or three weeks in, I actually pulled them aside and I said, "Hey, we need to move a lot faster. This is where we need to get to by X. We're a growth team. We need to prove wins out early. This is how I think we should do it. Let's try to create a roadmap, a list of problems to solve, et cetera, hypotheses." And they don't have to be right, but just getting something out there, starting to line the whole team on what those are and then defining how we're going to measure success and know we're in the right path. We just need to get there as quickly as we can.

**中文翻译:**
我想起一个例子。有人加入我的团队后，我早期觉得他们的行动不够快，需要更多的指导。所以在他们入职两三周左右，我把他们拉到一边说：“嘿，我们需要行动得更快。到某某时间点我们需要达到这个目标。我们是增长团队，需要尽早证明我们的成绩。我认为应该这样做：尝试制定一个路线图，列出要解决的问题清单和假设。” 这些假设不一定要全对，但要先拿出来，让全团队达成共识，然后定义如何衡量成功，确保我们在正确的轨道上。我们只需要尽快到达那里。

---

### [00:18:14] Melissa Tan

**English:**
And so I gave them that feedback and afterwards, ever since then they have been just on a tear and they actually have mentioned that in later conversations a year into working together that they were so grateful that I had that conversation with them and that I took the time to tell them those things. I think sometimes as a manager it can maybe, you want to avoid the uncomfortable conversations, but I actually think the more direct you can be but also saying this is my intention. My intention is to set you up for success. That goes really far and I think that's a great example of how do you deeply care about somebody and give them direct feedback and you're giving them direct feedback because you deeply care and you also believe that they can do things differently. I think the only reason you would give that feedback is because they can do things differently and you just want to help support them.

**中文翻译:**
我给了他们那个反馈，从那以后，他们的表现突飞猛进。在合作一年后的谈话中，他们提到非常感激我当时找他们谈话，并花时间告诉他们这些。我认为作为经理，有时你可能想避开不舒服的谈话，但我认为你越直接越好，同时要说明：“这是我的初衷，我的初衷是让你获得成功。” 这非常有效。我认为这是一个很好的例子，说明如何通过直接反馈来体现深切关怀——你之所以给直接反馈，是因为你深切关心他们，并且相信他们可以做得更好。给反馈的唯一原因就是他们有能力改变，而你想支持他们。

---

### [00:19:10] Lenny

**English:**
In that conversation. What is it that you did that made them feel like you really cared about them? Because when I hear you describe it's like you're just telling them, you're giving them feedback just like, "Hey, you need to do a lot better at this. We need to actually hit our goals." What was it that made them feel like, "Oh, she really wants me to succeed?"

**中文翻译:**
在那次谈话中，你做了什么让他们觉得你真的关心他们？因为听你的描述，感觉就像是在给反馈：“嘿，你这方面需要做得更好，我们需要达成目标。” 是什么让他们觉得“哦，她是真的想让我成功”？

---

### [00:19:22] Melissa Tan

**English:**
I think in that conversation what's important is also saying, "I believe you can do all these things and I'm doing this to support you." Or, "I'm sharing this feedback because I believe in you." Also saying that I'm here as support, as you are building that out, let me know what I can do to support you. We can jam on it together if it's helpful. Basically, I guess boil it down to one, restating your intention and why you are having that conversation to sharing that you are there to support them and offering your own help as well.

**中文翻译:**
我认为在那次谈话中，很重要的一点是说：“我相信你能做到这些，我这么做是为了支持你。” 或者说：“我分享这些反馈是因为我相信你。” 还要说：“我会在这里支持你，在你构建这些东西时，告诉我我能帮你做什么。如果需要，我们可以一起讨论（jam）。” 基本上可以归结为两点：第一，重申你的初衷以及为什么要进行这次谈话；第二，表明你会支持他们，并提供具体的帮助。

---

### [00:19:59] Melissa Tan

**English:**
Those I think are the things that go along well. And I think the third thing is as you give someone feedback, it should never sound like finger pointing or criticizing. It's really just, "Hey, this is what I observed, this is the impact that it had and here is a different way." And so keeping the feedback really about the work itself and the specific things that you think can be improved.

**中文翻译:**
我认为这些都很有效。第三点是，当你给某人反馈时，绝不能听起来像是指责或批评。而应该是：“嘿，这是我观察到的情况，它产生了这样的影响，这里有一种不同的方式。” 这样反馈就始终围绕着工作本身以及你认为可以改进的具体事项。

---

### [00:20:28] Lenny

**English:**
I know you're also a big fan of developing talent internally versus hiring experts from the outside and it's always this decision I think as a leader and as a company. How much do you invest in developing people knowing they can leave anytime, knowing that that's going to take all this time and work? What have you found from and just learned about the advantages maybe of spending time in developing people and helping them progress and just why is that something you find really important?

**中文翻译:**
我知道你非常推崇内部培养人才，而不是直接从外部聘请专家。作为领导者和公司，这总是一个艰难的抉择：明知道员工随时可能离开，明知道培养需要花费大量时间和精力，你还要投入多少？关于花时间培养人才并帮助他们进步的优势，你学到了什么？为什么你觉得这非常重要？

---

### [00:20:55] Melissa Tan

**English:**
I'll start with the why behind developing people. For me personally, it comes from like I'm personally passionate about it just because I feel that a lot of folks invested in me personally when I started out in the working world, I actually struggled quite a lot. I think making the transition from school where it's really clear what success looks like, you're just studying, getting good grades. To work where things are much more ambiguous was a really big transition for me and I really benefited from so many mentors that invested in me that I kept in touch with over the years that have also just helped me with my careers.

**中文翻译:**
我先说说为什么要培养人。对我个人而言，这源于一种热情，因为当我刚步入职场时，很多人在我身上倾注了心血。我刚开始工作时其实挺挣扎的。从学校（成功标准非常明确，就是学习、拿高分）转型到工作（一切都充满模糊性），对我来说是一个巨大的转变。我受益于许多投资于我的导师，多年来我一直与他们保持联系，他们也在职业生涯中给了我很大帮助。

---

### [00:21:30] Melissa Tan

**English:**
Two that really stand out are from Dropbox, Oliver Jay who goes by OJ and GC Lionetti. So it really has come from a very personal place for me. Secondly, I think it's just makes a lot of sense as you're scaling a company that as you are growing, it just is a smoother transition that the folks on your team can grow with you. People will build institutional knowledge and people talk a lot about founder intuition and that intuition that founders just have. I actually think that extends to early employees too, that have built a ton of context on the user on how to get things done at the company. So the more that you develop talent within the company, the smoother transition is versus bringing someone from the outside where there's just a lot of different factors and there's risk there. And so it really comes from a personal place, but also it makes a lot of sense from just like de-risking the situation as you're scaling.

**中文翻译:**
其中两位对我影响很大的是 Dropbox 的 Oliver Jay（大家都叫他 OJ）和 GC Lionetti。所以这对我来说非常个人化。其次，我认为在公司扩张过程中，这非常有意义：随着公司的成长，让团队成员与你一起成长，过渡会更平滑。员工会建立“机构知识”（institutional knowledge）。人们常谈论创始人的直觉，我认为这种直觉也延伸到了早期员工身上，他们对用户以及公司内部的办事流程积累了大量的背景信息。因此，内部培养人才越多，转型就越顺畅，而从外部引进人才则面临更多不确定因素和风险。所以这既是出于个人情怀，也是为了在规模化过程中降低风险。

---

### [00:22:27] Lenny

**English:**
In my personal career I had the biggest inflection point and the most progress I made as a product manager was one manager who just did exactly what you're describing, where you invested really deeply in helping me become a better PM and it was not easy. It was just very critical of all the things I wasn't doing perfectly. And I always think about people don't sometimes have someone like that in their career. They don't have a manager like Melissa. Do you have any advice for people that are looking for someone like that or they're just like, "Man, I have no one around me that's really helping me develop?" What do you suggest they do?

**中文翻译:**
在我个人的职业生涯中，最大的转折点和我作为产品经理取得的最大进步，都归功于一位经理。他就像你描述的那样，深切地投入精力帮我成为更好的 PM，过程并不轻松。他对我不完美的地方非常严厉。我常想，有些人职业生涯中可能遇不到这样的人，遇不到像 Melissa 这样的经理。对于那些正在寻找这样的人，或者觉得“天哪，我身边根本没人帮我发展”的人，你有什么建议？

---

### [00:22:58] Melissa Tan

**English:**
As you are looking for a job, I actually do think you should look to work with people that have that reputation and that you can see that interest that they enjoy mentoring people. They have a track record of developing people. Maybe they have brought other people they've worked with at the company from other companies. Those are good signals that that's something that that person cares about. And even in the interview process, kind of interviewing your manager too and understanding what is their management philosophy, how do they think about your career path in that role? Those are things I would look for.

**中文翻译:**
当你找工作时，我认为你应该寻找那些有这种名声的人，你能看出他们乐于指导他人。他们有培养人才的过往记录。也许他们把以前合作过的同事也带到了现在的公司，这些都是该领导者看重人才培养的良好信号。甚至在面试过程中，你也要“面试”你的经理，了解他们的管理哲学，以及他们如何看待你在这个职位上的职业路径。这些都是我会寻找的特质。

---

### [00:23:32] Melissa Tan

**English:**
The second thing too is as you're interviewing, looking for a manager who especially your success will be tied to their success, this is actually what happened. I mean it's not like you need to be super strategic about that, but when I reflect back at times when I got closest to people was when I was one of the most critical people on their team and they really needed me to be successful and so they also just would spend a ton more time with me.

**中文翻译:**
第二点是，在面试时，寻找一位你的成功与他们的成功紧密相连的经理。这其实就是我经历过的。我的意思是，你不需要表现得非常有心计，但回想起来，我与某些人关系最亲近的时候，往往是我作为团队中最关键的一员，他们非常需要我取得成功，因此他们也会花更多时间在我身上。

---

### [00:23:58] Melissa Tan

**English:**
So really looking for those opportunities and being really selective in the types of roles you're taking. I also think there have been times for me personally where I've built relationships with someone that wasn't my direct manager that worked at the same company. And this actually has happened a lot at other companies I've worked with where someone knows that it's a passion of mine to mentor people. And so they proactively reach out to me, ask me for advice, ask me, "Hey, can we set up a monthly recurring sync?"

**中文翻译:**
所以要寻找这些机会，并对你选择的职位保持挑剔。我也认为，有时我可以与公司里非直属经理的人建立关系。在我工作过的其他公司里经常发生这种情况：有人知道我热衷于指导别人，于是他们主动联系我，向我寻求建议，甚至问：“嘿，我们能每个月定期沟通一次吗？”

---

### [00:24:25] Melissa Tan

**English:**
And so I also think you can look for other people at the company that you work with. And then finally the other thing is looking for external advisors. I actually, in my advising end up mentoring a lot of the people that I work with too. It just organically ends up happening. And so I would say summarize that as just look for the people that you think have this passion, build that relationship with them. And ideally I think you actually build the strongest when you are working together. You just learn so much about each other, but if you don't have that set up, I think there's other ways to just proactively look for mentorship and guidance.

**中文翻译:**
所以你也可以在公司里寻找其他同事。最后一点是寻找外部顾问。实际上，在我的顾问工作中，最终也指导了很多合作的人。这通常是自然而然发生的。总结一下：寻找那些有这种热情的人，与他们建立关系。理想情况下，共同工作时建立的关系最牢固，因为你们能深入了解彼此。但如果没有这种环境，也可以通过其他方式主动寻求指导和建议。

---

### [00:25:00] Lenny

**English:**
Any tips on the questions? Maybe to ask a manager to help them get to this, if any come to mind and also when you're looking for someone to help you, anything specific you think that people should look for that maybe they may not be thinking about?

**中文翻译:**
关于面试经理的问题，你有什么建议吗？有没有什么问题能帮你识别出这类经理？另外，当寻找导师时，有没有什么大家可能没想到的特质是值得关注的？

---

### [00:25:13] Melissa Tan

**English:**
On the questions to ask when you're interviewing for a role, I would actually ask things like I'd love to get a sense for how you think about ... I mean I think you can flat out ask, I'd like to get a sense of how you think about managing folks on your team, how you think about developing talent on your team and seeing what their responses to that. I would also ask how are you thinking about the career path for this role? And if the person has not thought about it at all or doesn't ask you, "Well, what is important to you?" I think those are some signals that it's maybe not where this person tends to spend their time thinking. And then I would also ask other people on the panel that are not going to be your manager but that work with this person, especially if you happen to talk to people that they manage, how is this person as a manager? And that ends up being also very insightful.

**中文翻译:**
关于面试职位时要问的问题，你可以直截了当地问：“我想了解一下你是如何考虑管理团队成员的，以及你如何看待团队人才的培养？” 观察他们的反应。我还会问：“你对这个职位的职业路径有什么设想？” 如果对方完全没想过，或者没有反问你“对你来说什么最重要？”，那么这可能是一个信号，说明此人并不在这方面花心思。此外，我还会询问面试小组中非经理但与此人共事的人，特别是如果能接触到他们的下属，问问：“作为经理，这个人怎么样？” 这通常非常有启发性。

---

### [00:26:08] Melissa Tan

**English:**
The questions I would ask if you're looking for someone external, I always find that that relationship is best the more organic it could be. I think Cheryl Sandberg had wrote this in her book Lean She basically writes about how some people will go, "Will you be my mentor?" And I've got that question too, and it's just a lot of pressure to get asked that question really early in and you don't really know the person. And so the more it can be organic where you talk to somebody, you have actual advice that you want, some people will just reach out to me that I haven't worked with in a long time and like, "Hey, I'm thinking about a career decision or I'm in this tricky situation at work, can we talk?" And I just give them advice and they will reach out to me for advice occasionally.

**中文翻译:**
如果你在寻找外部导师，我认为关系越自然越好。谢丽尔·桑德伯格在《向前一步》（Lean In）中写过，有些人会直接问：“你能当我的导师吗？” 我也遇到过这种问题，但在还不了解对方的情况下，这种请求压力很大。所以最好是自然发生的：你找某人聊聊，带着具体的建议请求。有些人很久没和我共事了，会突然联系我：“嘿，我正在做一个职业决定，或者我在工作中遇到了棘手的情况，能聊聊吗？” 我会给他们建议，他们偶尔也会再来找我。

---

### [00:26:57] Melissa Tan

**English:**
It doesn't have to be a recurring thing that you have to just nurture that relationship. I think that is a way to do it. Or if you are working with somebody and you want to set up some type of monthly thing, I think you asked for that as well. The only thing is I would just be respectful of the time. So if you don't have anything to talk about that month or anything like that, I'm just always willing to help people. It doesn't mean we have to be frequently in touch. And so I think it's also less about being frequently in touch and it's just going and reaching out when you actually have a problem. People that want to help others are just going to, if they have the time, they'll say yes.

**中文翻译:**
这种关系不一定要是周期性的，你只需要维护它。或者如果你正和某人共事，想建立某种月度沟通机制，也可以提出来。唯一要注意的是要尊重对方的时间。如果你那个月没什么可聊的，那就不用强求。我总是愿意帮助别人，但这并不意味着我们必须频繁联系。我认为关键不在于联系的频率，而在于当你真正遇到问题时去寻求帮助。乐于助人的人只要有时间，通常都会答应。

---

### [00:27:30] Lenny

**English:**
Tim Ferriss talks about that too. He is like, "Never ask someone to be your mentor." As you said, that's a scary proposition. You're committing to something, it's pressure versus just like, "Hey, can we just meet and can I just get some advice? And then maybe after you do that, can we meet next month also?" And just help it grow organically.

**中文翻译:**
Tim Ferriss 也谈过这一点。他说：“永远不要请求别人做你的导师。” 正如你所说，这是一个吓人的提议，意味着一种承诺和压力。相反，应该说：“嘿，我们能见个面吗？我想听听你的建议。” 然后也许下次再说：“下个月我们能再见一面吗？” 让它自然生长。

---

### [00:27:48] Melissa Tan

**English:**
Yeah, definitely.

**中文翻译:**
没错，绝对是这样。

---

### [00:27:50] Lenny

**English:**
I want to talk about how you develop talent and what you've learned there. But before that, I wanted to zoom out maybe first and talk about ingredients of high performance teams. So before I ask that question, can you just list the companies you work with, some of the companies you've worked with?

**中文翻译:**
我想聊聊你是如何培养人才的，以及你学到了什么。但在那之前，我想先放大视角，谈谈高效团队的要素。在提问之前，你能列举一下你合作过的一些公司吗？

---

### [00:28:03] Melissa Tan

**English:**
I guess I've mentioned Dropbox. So Dropbox was my first high growth tech startup. And then after Dropbox I did a lot of advising. So I got to work with Typeform in Barcelona and then someone at Typeform introduced me to Canva. So I met Canva when they were still about 200 people in their early growth journey. Have worked with Grammarly, Miro and then I joined Webflow. And so have been fortunate to be part of a ton of, I guess what I would think are high performing teams.

**中文翻译:**
我提到了 Dropbox，那是我第一家经历高速增长的技术初创公司。离开 Dropbox 后，我做了很多顾问工作。我曾与巴塞罗那的 Typeform 合作，后来 Typeform 的人把我介绍给了 Canva。我遇到 Canva 时，他们只有 200 人左右，正处于早期增长阶段。我还与 Grammarly、Miro 合作过，后来加入了 Webflow。我很幸运能成为这么多高效团队的一员。

---

### [00:28:46] Melissa Tan

**English:**
I think it first starts with the team having a really clear goals. They need to know what success looks like. And often I think that's for growth teams in particular, it's always really clear, "Hey, we need to hit certain metrics. We have certain goals for the quarter and for the year." And then also having a mission. So the mission's all about the why, right? So an example at Webflow is we have our growth team gold on ultimately the North Star is ARR, Annual Recurring Revenue. And then we break it down into the levers that drive ARR, the leading indicator, so that could be activation rates, the number of customers you bring in, et cetera. And so each team has really clear goals. And then we have our mission. The why. Our mission, the why we do it is we want to build these delightful experiences for our users. We want to support them on their journey on the product.

**中文翻译:**
我认为首先要从团队拥有非常明确的目标开始。他们需要知道成功是什么样子的。对于增长团队来说，这通常非常明确：“嘿，我们需要达到某些指标，我们有季度和年度目标。” 其次是要有使命。使命关乎“为什么”（the why）。以 Webflow 为例，我们增长团队的终极北极星指标是 ARR（年度经常性收入）。然后我们将其分解为驱动 ARR 的各个杠杆（领先指标），比如激活率、获取的客户数量等。每个团队都有明确的目标。然后是使命，即我们为什么这么做：我们想为用户打造愉悦的体验，支持他们的产品旅程。

---

### [00:29:35] Melissa Tan

**English:**
And the reason why the what is monetization is that's just a good signal that people find your product valuable, especially if they're consistently paying you and they're retaining. And then the other thing that I think is important is culture. So how are you going to do these things? When thinking about culture, obviously it depends on the function and the culture you want to set there. For me personally, the type of culture I try to set for the team is one around being really results oriented.

**中文翻译:**
至于为什么目标是“变现”，因为那是人们发现你产品价值的一个良好信号，特别是如果他们持续付费并留存下来。我认为另一件重要的事情是文化。也就是说，你打算如何实现这些目标？谈到文化，显然取决于职能部门和你想要设定的基调。对我个人而言，我努力为团队设定的是一种“结果导向”的文化。

---

### [00:30:03] Melissa Tan

**English:**
So something that someone on my team was saying the other day is you always make it really clear that we're going to be measured on impact and that's like how we are ultimately measured as a team. And so really creating that results oriented team. Also, a team that's very team first and collaborative. I think when you have very clear goals, when it's very results-oriented, you could potentially be in a situation where people feel they're competing against each other and you just don't want that. You actually want folks on the team to help each other out to share learnings.

**中文翻译:**
我团队里有人前几天说，我总是非常明确地表示我们将根据“影响力”（impact）来衡量，这就是我们作为团队的最终衡量标准。所以要打造一支结果导向的团队。同时，这支团队必须是“团队第一”且极具协作精神的。我认为当你有了非常明确的目标且高度结果导向时，可能会出现成员之间互相竞争的情况，你肯定不希望看到那样。你实际上希望团队成员互相帮助、分享经验。

---

### [00:30:33] Melissa Tan

**English:**
I think that's what ends up being like a situation where one plus one equals three. You're not locally optimizing but you're thinking broader about the team and thinking beyond yourself. The third thing is really this ownership mentality. Something I directly saw at Dropbox is when we were a smaller company, everyone just felt a lot more ownership in accountability because there's just nobody else. You're wearing five different hats. You have to do it.

**中文翻译:**
我认为这才是实现“1+1=3”的情况。你不是在做局部优化，而是在更广泛地思考团队，超越自我。第三件事是“主人翁心态”（ownership mentality）。我在 Dropbox 亲眼看到，当公司规模较小时，每个人都感到更强的主人翁感和责任感，因为没别人了。你身兼数职，必须得干。

---

### [00:30:57] Melissa Tan

**English:**
As you scale, it's really easy to suddenly feel like that ownership is diluted. And so something I always try to keep in the team, it's a feeling that we're owners and that really proactive mindset of how am I going to solve this problem? I'm blocked by this team, what am I going to do about it? And just being people that have strong sense of agency. And then lastly having fun. I think that especially in high pressured environments, easy to get stressed and all that stuff. And at the end of the day, this is very personal me, but the more fun you can have, the better everything is. And so just making sure you're infusing fun along the way and you're not taking things too seriously.

**中文翻译:**
随着规模扩大，这种主人翁感很容易被稀释。所以我总是努力在团队中保持一种“我们是主人”的感觉，以及一种积极主动的心态：我该如何解决这个问题？我被那个团队卡住了，我该怎么办？就是要拥有一群具有强烈“能动性”（agency）的人。最后是乐趣。我认为特别是在高压环境下，人很容易感到压力。归根结底，这是我个人的看法：你拥有的乐趣越多，一切就越好。所以要确保在过程中注入乐趣，不要把事情看得太严肃。

---

### [00:31:38] Lenny

**English:**
So I was taking notes as you were talking and there's kind of these four items just to summarize. One is creating a culture of impact and performance. Two is being team first and making about the team versus the person. Three is creating a sense of ownership and making people feel like they're owners and then having fun, which I love. A question I have there is say within the ownership bucket of creating a sense of ownership, what do you actually do to create that sense amongst the team?

**中文翻译:**
你说话时我一直在做笔记，总结起来有四点：第一，建立影响力和绩效文化；第二，团队第一，关注团队而非个人；第三，建立主人翁感，让大家觉得自己是主人；第四，享受乐趣，我非常喜欢这一点。我的问题是，在“建立主人翁感”这一项中，你具体做了什么来让团队产生这种感觉？

---

### [00:32:04] Melissa Tan

**English:**
I think it first starts with defining the scope that everyone is going to own and drive. So as you are setting up the team, it's important that each person on the team has scope that they can run independently and that they are excited to own and drive. So one example here is as I was leaving Dropbox, the finance team looked at our metrics and saw that each growth PM was bringing over a million in AR per year just from all the experiments.

**中文翻译:**
我认为首先要定义每个人负责和推动的范围（scope）。在组建团队时，重要的是让每个人都有可以独立运作的范围，并且他们对负责和推动这一领域感到兴奋。举个例子：当我离开 Dropbox 时，财务团队查看了我们的指标，发现每个增长 PM 仅通过实验每年就能带来超过 100 万美元的 ARR。

---

### [00:32:31] Lenny

**English:**
Holy moly.

**中文翻译:**
天哪。

---

### [00:32:31] Melissa Tan

**English:**
Yeah. And so that's quite a lot of impact. And being a finance team, they said logically we should just double the team. If each person brings in more than a million, if we want to double the AR, let's just double the team. And so I actually pushed back significantly though. I thought to myself, "If we double the team, what is everyone on the team going to own and drive? Is it like we split up different parts of the website, different parts of the product 1:00 PM owns just like the checkout flow.

**中文翻译:**
是的，那是相当大的影响力。作为财务团队，他们的逻辑是：既然每个人能带来 100 万，如果我们想让 ARR 翻倍，那就把团队规模扩大一倍。但我当时强烈反对。我心想：“如果我们把团队扩大一倍，团队里的每个人负责什么？难道我们要把网站或产品的不同部分拆得更细，让一个 PM 只负责结账流程吗？”

---

### [00:32:57] Melissa Tan

**English:**
I didn't think that was going to be interesting enough for the team and going to help us recruit people that were excited to solve such small parts of the growth problem. And so really thinking about how do you carve out scope and if you are a growth team, maybe thinking about splitting up by problems to solve that are really meaty by areas of the funnel like activation, monetization, et cetera. So first starting out with carving out good scope. And then the second thing is just infusing a culture of thinking like an owner. This infusing of the culture, I think it comes out in a few ways. One is, and this is really common in growth. Growth is so cross-functional that you often will end up feeling like you're blocked by other teams.

**中文翻译:**
我不认为这能让团队感到有趣，也不利于招聘那些渴望解决重大增长问题的人。所以要思考如何划分范围。如果你是增长团队，也许可以按要解决的重大问题来划分，或者按漏斗区域（如激活、变现等）来划分。所以第一步是划分好的范围。第二步是注入“像主人一样思考”的文化。这种文化的注入体现在几个方面：一是——这在增长领域很常见——增长是跨职能的，你经常会觉得被其他团队卡住了。

---

### [00:33:38] Melissa Tan

**English:**
Let's say we want to run an experiment on this part of the product, maybe it's a core PM that kind of owns that service area that doesn't want to drive that thing or let's say or blocked by a bottleneck on designer engineering. It's something where I think if you're thinking an owner, you are not feeling easily disempowered because you can't do something and instead you're thinking, "What is everything I can do and did I exhaust all the options?"

**中文翻译:**
假设我们想在产品的某个部分运行实验，但负责该核心业务的 PM 不想推动，或者设计师、工程师成了瓶颈。如果你有主人翁心态，你不会因为做不成某事就轻易感到丧失动力，相反，你会想：“我还能做些什么？我是否已经尝试了所有选项？”

---

### [00:34:05] Melissa Tan

**English:**
And then finally it's leading by example. I try to also show to my team that I'm always thinking like an owner and then I'm always trying to do everything I can. And finally as a leader, thinking like an owner also means taking responsibility for your team. And so if things don't go right in my team, I'm the first one to say that ultimately I'm responsible and it's a failure or oversight on my side. And so that is what I think an ownership mentality is. It's just really thinking about the scope, creating that culture and then as a leader it's just seeing yourself as ultimately being accountable.

**中文翻译:**
最后是以身作则。我努力向团队展示我总是在像主人一样思考，总是竭尽所能。最后，作为领导者，像主人一样思考也意味着为团队承担责任。如果团队出了问题，我会第一个站出来说，最终责任在我，是我的失败或疏忽。这就是我理解的主人翁心态：思考范围、建立文化，并作为领导者承担最终责任。

---

### [00:34:37] Lenny

**English:**
Awesome. And this connects to something else I wanted to pull the thread on, which is the team first bucket. I think about Meta, not to throw them under the bus or anything, but I feel like everyone I know at Meta their performance review is very tied to their impact. It's very impact driven and that leads to people needing to drive impact themselves. I drove this impact and they look at how much did you contribute to that impact versus other people on your team. And it creates some challenges I think for people. How do you create that feeling of team first, even though your performance as you talked about is so tied to here's your success metric, here's what success means for you, for the team, how do you make it feel team first versus like, I need to do this myself?

**中文翻译:**
太棒了。这引出了我想探讨的另一个话题，即“团队第一”。我想到了 Meta（不是要针对他们），但我感觉我认识的每个在 Meta 工作的人，他们的绩效评估都与个人影响力紧密挂钩。这导致人们必须亲自推动影响力——“这是我推动的影响力”——公司会看你对该影响力的贡献比例。我认为这会带来一些挑战。既然绩效与成功指标挂钩，你如何营造“团队第一”的氛围，而不是让大家觉得“我得自己单干”？

---

### [00:35:17] Melissa Tan

**English:**
There's definitely a delicate balance here. It comes down to the way that I think the manager leads the team and sets the tone. And so for me, I always make it clear that even though results are important, it's a team sport. And so I often find that I am encouraging the team to work together. So again, as a leader, you have context in everything happening. So sometimes I know 1:00 PM is working on something or even a PM outside our team is working on something and I try to actually fill in context if I think someone on my team could contribute. And I encourage that action even though it doesn't maybe feed into impact on the thing they're driving. So it really comes down to the culture that you set and what you encourage the team to do. I also think the more that you can see that you actually benefit from helping each other out, the better it is.

**中文翻译:**
这确实需要微妙的平衡。归根结底在于经理如何领导团队并定下基调。对我来说，我总是明确表示，虽然结果很重要，但这是一项团队运动。我经常鼓励团队成员协作。作为领导者，你掌握全局背景。有时我知道某个 PM 正在做某事，甚至是我们团队之外的 PM，如果我觉得我团队的人能帮上忙，我会提供背景信息并鼓励他们参与，即使这可能不会直接计入他们自己负责项目的影响力。所以这取决于你设定的文化和鼓励的行为。我也认为，大家越能意识到互相帮助能让自己受益，效果就越好。

---

### [00:36:15] Melissa Tan

**English:**
And finally, I think again, leading by example, because I actually am very team first, I'm often actually helping other teams and doing things that might not ultimately benefit or be part of my scope. A good example here is I was actually driving pricing and packaging at Webflow for a very long time just because no one at the company was driving it and it was a huge opportunity area and I actually was doing it for enterprise pricing too. And so even though I am overseeing self-serve, I was actually supporting enterprise pricing and packaging. And so I also showed to my team, "Hey, I'm also doing all these things to help the company." And I think that is what helps set that tone and that culture.

**中文翻译:**
最后，还是以身作则。因为我本人非常看重团队第一，我经常帮助其他团队，做一些最终可能不会直接让我受益或不在我职责范围内的事。一个很好的例子是：我在 Webflow 负责了很长时间的定价和包装工作，仅仅是因为公司里没人管这块，而它又是一个巨大的机会点。我甚至还负责了企业级定价。所以，尽管我监管的是自助服务业务，但我实际上也在支持企业级的定价和包装。我向团队展示：“嘿，我也在做这些事情来帮助公司。” 我认为这有助于设定那种基调和文化。

---

### [00:36:55] Lenny

**English:**
How do you then avoid doing too much work? I think there's also this challenge of people being too good at too many things and then they end up doing so many things and then they burn out. Do you have any rules of thumb or lessons there?

**中文翻译:**
那你如何避免工作量过载呢？有些人擅长太多事情，结果揽了太多活儿，最后精疲力竭。在这方面你有什么准则或教训吗？

---

### [00:37:06] Melissa Tan

**English:**
I think for me it's been a learning journey too. I've actually gotten feedback on that very thing for my team that Melissa sometimes taking on too much or trying to do too much. And so I think it's a delicate balance. If we're talking about that person individually, you have to know what your limits are and you also can do things in spurts, but it's important to know ultimately what you can take on. Also I find that putting a specific timeline like, "Hey, I'm going to do this thing for a quarter, but after that we really need to find somebody else to do it." Or hand it off is really helpful. It's definitely a delicate balance. I do think it's a great question because I think that's a common thing people early in their careers struggle with, which is they could lose focus because they're trying to help everybody.

**中文翻译:**
对我来说，这也是一个学习的过程。我确实收到过团队的反馈，说 Melissa 有时承担得太多或尝试做得太多。所以这是一个微妙的平衡。对于个人来说，你必须知道自己的极限在哪里。你可以短时间内冲刺，但必须清楚最终能承担多少。此外，我发现设定一个明确的时间表很有帮助，比如：“嘿，这事儿我干一个季度，但之后我们真的需要找别人来接手。” 这确实很难平衡。我觉得这是一个非常棒的问题，因为很多职场新人都会遇到这种困扰：因为想帮助所有人而失去了焦点。

---

### [00:37:49] Melissa Tan

**English:**
That was actually a problem I had when I first joined Dropbox is I was the only sales ops person, so I was just helping every sales leader with their metrics and very focused. And so it is a little bit of trial and error. I think the most important thing is to not be so overly focused on just what you're doing and try to help others, but then knowing that there are certain things that just can't drop. And if you start to see things that are starting to drop that you're ultimately responsible for, that's a signal that you're taking on too much.

**中文翻译:**
我刚加入 Dropbox 时就遇到过这个问题，当时我是唯一的销售运营（sales ops）人员，所以我帮每一位销售主管处理指标，非常专注。所以这需要一点试错。我认为最重要的一点是：不要只盯着自己那点事，要尝试帮助别人，但同时要清楚哪些事情是绝对不能搞砸的。如果你发现自己最终负责的事情开始出问题，那就是你承担过多的信号。

---

### [00:38:18] Lenny

**English:**
This episode is brought to you by Eppo is a next generation AB testing platform built by Airbnb alums for modern growth teams. Companies like DraftKings, Zapier, ClickUp, Twitch and Cameo rely on Eppo to power their experiments. Wherever you work, running experiments is increasingly essential, but there are no commercial tools that integrate with a modern grow team stack. This leads to waste of time building internal tools or trying to run your own experiments through a clunky marketing tool.

**中文翻译:**
本期节目由 Eppo 赞助。Eppo 是由 Airbnb 校友为现代增长团队打造的下一代 AB 测试平台。DraftKings、Zapier、ClickUp、Twitch 和 Cameo 等公司都依赖 Eppo 来驱动他们的实验。无论你在哪里工作，运行实验都变得越来越重要，但目前还没有能与现代增长团队技术栈无缝集成的商业工具。这导致人们要么浪费时间构建内部工具，要么试图通过笨重的营销工具来运行实验。

---

### [00:38:45] Lenny

**English:**
When I was at Airbnb, one of the things that I loved most about working there was our experimentation platform where I was able to slice and dice data by device types, country, user stage, Eppo does all that and more delivering results quickly, avoiding annoying prolonged analytic cycles and helping you easily get to the root cause of any issue you discover. Eppo lets you go beyond basic click-through metrics and instead use your North Star metrics like activation, retention, subscription and payments. Eppo supports test on the front end, on the back end, email marketing, even machine learning claims. Check out Eppo at geteppo.com, that's geteppo.com and 10x your experiment velocity.

**中文翻译:**
我在 Airbnb 工作时，最喜欢的功能之一就是我们的实验平台，我可以按设备类型、国家、用户阶段对数据进行切片分析。Eppo 也能做到这些，甚至更多：它能快速交付结果，避免烦人的漫长分析周期，并帮你轻松找到问题的根本原因。Eppo 让你超越基础的点击率指标，转而使用激活、留存、订阅和支付等北极星指标。Eppo 支持前端、后端、邮件营销甚至机器学习方案的测试。访问 geteppo.com 了解 Eppo，让你的实验速度提升 10 倍。

---

### [00:39:25] Lenny

**English:**
Let's come back to the developing talent bucket. I would kind of went on a tangent, but I want to come back to that. So we talked about why you're excited about developing talent, the benefits you've experienced. I'm curious what you actually do to help people become better product managers, leaders of all kinds. What actually have you seen works?

**中文翻译:**
让我们回到“培养人才”这个话题。我刚才扯远了，现在想绕回来。我们谈到了你为什么热衷于培养人才，以及你体会到的好处。我很好奇你具体做了什么来帮助人们成为更好的产品经理或各种类型的领导者？你发现哪些方法真正奏效？

---

### [00:39:42] Melissa Tan

**English:**
In terms of developing talent, I think of this as stages of the life cycle of your relationship, right? So I think at first actually starts is a very meta as a growth person starts with when you hire somebody, really making sure you're finding somebody that is a good fit for the role. It's a good mutual fit. I also tend to look for folks that have a growth mindset.

**中文翻译:**
关于培养人才，我将其视为一段关系的生命周期阶段。首先——作为一个增长人，这很“元”（meta）——从招聘开始，确保你找到的人与职位匹配，这是一种双向的匹配。我也倾向于寻找具有“增长心态”（growth mindset）的人。

---

### [00:40:06] Melissa Tan

**English:**
There're people that are wanting to learn. They're looking for feedback. They take feedback well. And then after that they join the company, and as a manager, my job is to help set them up for success. So how do I ramp them up as quickly as possible, connect them to the right people, the company? How do I also make sure it's clear what success looks like in their first 90 days? And then how do I help them secure early wins essentially?

**中文翻译:**
他们渴望学习，寻求反馈，并且能很好地接受反馈。入职后，作为经理，我的工作是为他们的成功铺路。如何让他们尽快上手（ramp up）？如何将他们引荐给公司里正确的人？如何确保他们清楚入职前 90 天的成功标准？以及如何帮助他们获得“早期胜利”（early wins）？

---

### [00:40:32] Melissa Tan

**English:**
So I often will suggest, "Hey, you should do this presentation. It's a great way to get visibility early in your journey here." Here are some things where there's low hanging fruit or even rotting fruit that you should take on into secure early wins. Then in your journey, I think it's a lot about just giving feedback along the way, making sure you give visibility. One recent hack I have is having folks on the team create looms that they can share with different leaders at Webflow. It's hard to sometimes get visibility and get live meeting calendars, but if you create a five or 10 minute-loom on something you did. That's just a great way to get visibility.

**中文翻译:**
所以我经常会建议：“嘿，你应该做这个演示，这是在早期获得曝光度（visibility）的好方法。” 或者指出一些“低垂的果实”甚至“掉在地上的果实”让他们去处理，以确保早期胜利。在随后的旅程中，主要是不断提供反馈，确保给他们曝光机会。我最近的一个小技巧是让团队成员制作 Loom 视频，分享给 Webflow 的不同领导。有时很难约到领导的时间，但如果你做一个 5 到 10 分钟的 Loom 视频展示你的成果，那是获得曝光的绝佳方式。

---

### [00:41:10] Melissa Tan

**English:**
And then finally, I think it's that lifelong relationship actually. So I'm still in touch with a lot of people that I've managed and I've helped them. Whether it's looking for their new job or they have career advice, I always make myself available. And so it's actually that lifelong journey of just developing that person. And at some point it's not even developing that person, but it's having a friendship with somebody. And I feel like I've learned a ton from people that I have managed. And so it ends up being this really great thing where you initially started working together but you now know each other so well. And I think that's even how I've developed as a manager is just getting feedback from my team.

**中文翻译:**
最后，我认为这实际上是一种终身的关系。我仍然与许多我管理过的人保持联系并帮助他们。无论是找新工作还是寻求职业建议，我总是随叫随到。所以这其实是一个持续终身的培养过程。到了一定阶段，这甚至不再是“培养”，而是建立友谊。我觉得我从下属身上学到了很多。最终这变成了一件很棒的事：你们最初因为工作聚在一起，现在却如此了解彼此。我认为我作为经理的成长，很大程度上也源于团队给我的反馈。

---

### [00:41:51] Lenny

**English:**
This all comes back to something you mentioned a couple of times earlier, just caring a lot about the person that you work with. Your approach also reminds me of this book, Radical Candor. I imagine you're a fan and that's kind of the way you think about it.

**中文翻译:**
这又回到了你之前多次提到的：深切关心与你共事的人。你的方法让我想起了《彻底坦率》（Radical Candor）这本书。我猜你是这本书的粉丝，你的思维方式也与之契合。

---

### [00:42:03] Melissa Tan

**English:**
Yeah, definitely. Interestingly enough, Kim Scott was at Dropbox for a short period of time, so when I joined Dropbox, she was actually on my interview panel and we overlapped for three months and she actually workshopped that book with our team before she published it. And that always resonated with me. And I remember her saying you have to ... I forget the exact words, but it's essentially be direct but deeply care.

**中文翻译:**
是的，没错。有趣的是，Kim Scott 曾在 Dropbox 待过一小段时间。我加入 Dropbox 时，她就在我的面试小组里，我们共事了三个月。她在出书之前，实际上在我们的团队里对书中的内容进行了工作坊式的演练。这对我影响很深。我记得她说你必须……我忘了原话，但核心就是“直接沟通，但深切关怀”。

---

### [00:42:30] Lenny

**English:**
Yeah. Care deeply, but something directly challenged directly. Something like that.

**中文翻译:**
是的，“深切关怀，直接挑战”。大概是这样。

---

### [00:42:36] Melissa Tan

**English:**
Yeah, care deeply but challenge directly and that has always been something that is something I try to infuse and has really inspired me as leader.

**中文翻译:**
对，“深切关怀，直接挑战”。这一直是我努力融入管理风格的东西，也一直激励着我成为一名领导者。

---

### [00:42:43] Lenny

**English:**
Awesome. We're going to link to that book if folks don't know about it. I love it. You talked about hiring PMs and how that is important in building high performing teams. So let's spend a little time there, maybe just two questions all throughout and you can approach them however you want. One is just what do you look for when you're hiring product managers? You've hired a lot of PMs. You've managed a lot of PMs over the years. What do you look for, especially things that maybe other people don't focus on enough, and then just what is your interview process? What do you find is most helpful for interviewing process-wise?

**中文翻译:**
太棒了。如果大家还不知道这本书，我们会附上链接。你谈到了招聘 PM 以及它对打造高效团队的重要性。让我们聊聊这个，我有两个问题：第一，你招聘产品经理时看重什么？你这些年招过也带过很多 PM，有哪些特质是别人可能关注不够的？第二，你的面试流程是怎样的？你觉得在流程上什么最有效？

---

### [00:43:13] Melissa Tan

**English:**
In terms of what I look for, I think there's this kind of known list of things that you probably want to look for, for a PM that I probably are not going to ... I'm say anything groundbreaking here, but obviously communication skills, the ability to manage stakeholders and work well cross-functionally. The things that I lean especially heavy on in my interview process is this concept of first principles thinking or strong critical thinking. So usually there's some live problem solving component to my interview process where I really lean more heavily into how would you approach X problem? And then I dig into the Y and try to understand why would they approach it this way, see what questions they're asking and just see how they approach problem solving.

**中文翻译:**
关于我看重的特质，PM 的通用要求我就不多说了，比如沟通能力、利益相关者管理能力和跨职能协作能力。我在面试中特别看重的是“第一性原理思维”或强大的批判性思维。所以我的面试通常包含“现场解决问题”的环节，我会重点考察“你会如何处理 X 问题？”。然后我会深挖原因，试图理解他们为什么要这样处理，看他们会问什么问题，观察他们解决问题的思路。

---

### [00:43:55] Melissa Tan

**English:**
And then the other thing that I look for that I mentioned is that growth mindset. So really seeing how does this person take feedback. And so I'll actually sometimes give feedback to candidates through the process. Something that I do that I learned a few years ago that was super helpful, so I always have a presentation component to the interview process that checks for prepared thinking communication. And I recommend a prep call between the two of us before that presentation. And I actually will give feedback on the presentation.

**中文翻译:**
另一件我看重的事就是刚才提到的“增长心态”。我会观察这个人如何接受反馈。实际上，我有时会在面试过程中直接给候选人反馈。我几年前学到一个超级有用的招数：面试流程中总会有一个演示环节，考察候选人的思考和沟通能力。我建议在正式演示前，我们俩先打个预备电话（prep call），我会对他的演示内容给出反馈。

---

### [00:44:26] Melissa Tan

**English:**
And what this gives me signal is what is it actually going to be like to work together? And then I see how they incorporate it into the final product and that is always really interesting and sometimes it's the biggest signal to what it's going to be like to work with this person.

**中文翻译:**
这给我的信号是：实际共事会是什么样子？我会观察他们如何将反馈融入最终的演示中。这总是非常有趣，有时这才是判断未来共事体验的最强信号。

---

### [00:44:39] Lenny

**English:**
Okay, this is great. I want to spend a little time here. So what is the actual sequence that you recommend or you use for interviewing? There's a presentation, there's a rep call but also is kind of involved in that.

**中文翻译:**
太棒了，我想在这里多停留一会儿。你推荐或使用的实际面试顺序是怎样的？包括演示、预备电话，还有其他环节吗？

---

### [00:44:49] Melissa Tan

**English:**
Usually hiring manager screen, and I actually do the live problem solving at this screen. I actually think it weeds out the most people. And there's actually two things I do here. One is a live problem solving. How would you approach X? So let's say I'm hiring for pricing at Webflow, I would ask, "How would you approach pricing?" I sometimes would say, "Hey, do you have your laptop? Can you pull up our pricing page? Curious to get your thoughts, what would you want to change?" That was a trick I learned at Dropbox where we would actually pull up the Dropbox website and be like, "Hey, what'd you want to test here? Why?" And you get a ton of signal on how they approach the problem, how they think.

**中文翻译:**
通常先是招聘经理初筛，我会在这一轮就进行现场问题解决。我认为这能筛掉最多的人。我在这里会做两件事：一是现场解决问题，“你会如何处理 X？”。比如我在为 Webflow 招聘负责定价的人，我会问：“你会如何处理定价？” 有时我会说：“嘿，你带电脑了吗？能打开我们的定价页面吗？我想听听你的想法，你想改动哪里？” 这是我在 Dropbox 学到的技巧：直接打开网站问，“你想在这里测试什么？为什么？” 这样你能获得大量关于他们思路和思维方式的信号。

---

### [00:45:25] Melissa Tan

**English:**
I ask why a bunch. And then the next screen is talking to more folks at the team that test for different competencies. And depending on what you're hiring for, we just have each person focused on a different competency. And it also depends on the roles. So some roles are more technical, some require working more closely with different stakeholders, so you want to make sure you can test those things. And then the final round is the presentation and then also maybe a conversation on other areas.

**中文翻译:**
我会不停地问“为什么”。下一轮是与团队更多成员交谈，测试不同的胜任力（competencies）。根据职位的不同，我们会让每个人专注于不同的维度。这也取决于角色：有些角色更偏技术，有些需要与利益相关者紧密合作，所以要确保测试到这些方面。最后一轮是演示，可能还会就其他领域进行交流。

---

### [00:45:52] Melissa Tan

**English:**
We want that kind of come through the interview process. We want to dig in further. The presentation is usually thinking through how you'd approach, your collecting all this information on the company or the problem throughout the interview process. And so it culminates in what do you think this should look like or maybe what would you want to do in your first 90 days? It depends on the role, but it's usually some type of presentation about the problem you would be working on at the company.

**中文翻译:**
我们希望通过面试流程深入挖掘。演示通常是思考你将如何处理问题——你在整个面试过程中收集了关于公司或问题的各种信息，最后汇总成：“你认为这应该是什么样子的？” 或者“你入职前 90 天想做什么？” 这取决于职位，但通常是关于你入职后要解决的具体问题的演示。

---

### [00:46:18] Melissa Tan

**English:**
Before that, we have that preparation call with me where often candidates will have questions like, "Oh, I need to know this data," or "I'm curious about X." And so it's really just a call to help them. And then at this stage too, they'll often have the actual draft of the presentation and so we'll go through it together and I'll actually be like, "Hey, I think you should lean in heavier here. How would you think about this?" I'll even say for example, at Webflow I'll be like, "We're thinking about X, Y, Z thing just so you know. And maybe incorporating that into your presentation would be really helpful.

**中文翻译:**
在那之前，候选人会和我打个预备电话。他们通常会有疑问，比如“我需要知道这个数据”或“我对 X 感到好奇”。所以这纯粹是一个帮助他们的电话。在这个阶段，他们通常已经有了演示草稿，我们会一起过一遍，我会说：“嘿，我觉得你应该在这里多花点笔墨。你觉得这个怎么样？” 我甚至会说，比如在 Webflow，“顺便告诉你，我们正在考虑 X、Y、Z，把这些加入你的演示可能会很有帮助。”

---

### [00:46:50] Melissa Tan

**English:**
And so that's where I get a lot of signal of what is it going to be like to work with this person on a presentation? And then I'll see in the presentation whether they incorporate it or not or how they did. And sometimes I've seen candidates that didn't incorporate any of it and I kind of am like, "Okay, this is probably not a fit." And actually I think that other thing about that call is it helps just set the candidate up for success. It's actually quite a lot of work to create a presentation. The more we can help them by giving them information, making sure they can be successful, it's helpful. And I think guess lastly, it gives them a taste of what it's like to work with me.

**中文翻译:**
这就是我获得信号的地方：和这个人一起准备演示会是什么感觉？然后我会看他们在正式演示中是否采纳了建议，以及做得如何。有时我看到候选人完全没采纳，我就会觉得“好吧，这可能不合适”。实际上，我认为这个电话的另一个作用是帮助候选人获得成功。制作演示文稿工作量很大，我们通过提供信息来确保他们能表现出色，这很有帮助。最后，这也能让他们体验一下和我共事的感觉。

---

### [00:47:26] Lenny

**English:**
I've never heard of that step before. That is really interesting. They actually give them feedback before they present. I imagine they're like, "What the hell is going on here?" I thought I was trying to show them what I can do, not like they're going to help me do a great job. That is really interesting. Maybe two very logistical questions there. How much time do you give them to work on this presentation? And then two, you said that you asked some questions related to the actual problem solving versus a theoretical problem. Those are the two questions, I guess.

**中文翻译:**
我以前从未听说过这个环节，太有意思了。在演示前给他们反馈，我能想象候选人的反应：“这到底是怎么回事？” 我以为我是来展示能力的，没想到面试官会帮我把活儿干好。这很有趣。有两个细节问题：第一，你给他们多少时间准备演示？第二，你提到问的是实际问题解决，而不是理论问题。

---

### [00:47:52] Melissa Tan

**English:**
Typically we will schedule it about a week in advance. They have a week. The tricky thing here is obviously it's a big ask to ask someone to create a presentation. And so if it's one week that's long enough to create it, but it's short enough that you don't spend tons of time. The other thing is just making it clear, don't exceed more than X number of slides. In Webflow's case we've done, don't exceed more than 30 slides. And that's like quite a lot. We do not expect you to do 30 slides. And then the other thing I make sure to emphasize is it's really about wanting to know how you'd approach it. So don't worry about the slides, be able to talk to it and have what you need to talk to it because we're actually just looking for the substance. And so that's how much time we give them and it's usually a 30-minute presentation with 15-minute Q&A.

**中文翻译:**
通常我们会提前一周安排，他们有一周时间。棘手的地方在于，要求别人做演示确实是个不小的负担。一周时间足够做出来，但也不至于让你陷进去太久。另一件事是明确规定：不要超过 X 张幻灯片。在 Webflow，我们规定不超过 30 张——其实这已经很多了，我们并不指望你真做 30 张。我还会强调：重点是了解你的思路。所以别太在意幻灯片美观，只要能讲清楚就行，因为我们看重的是实质内容。通常是 30 分钟演示加 15 分钟问答。

---

### [00:48:42] Melissa Tan

**English:**
The second part of your question was, so in terms of picking the topic, so there's a few ways to think about it. I know some folks will be like, "Oh, we have candidates present on something they've worked with in the past." I've tried that form and it's really difficult because I found that candidates even sometimes spend tons of time sharing the context of that company. And then also it doesn't really give a sense of, because as you're interviewing from a role, you're getting a ton of context on the actual company and the problem. And so it also is testing for how much did they pick up along the way. Also, would they like working on this area once they join? So there are some candidates that sometimes are concerned about the amount of time they would spend on it or say, "This is going to be a big lift."

**中文翻译:**
关于你问题的第二部分，即如何选题。我知道有些人会让候选人演示过去做过的项目。我试过那种形式，但很难，因为候选人有时会花大量时间解释那家公司的背景。而且那不能体现出他们对当前职位的理解。在面试过程中，你会获得大量关于本公司和具体问题的背景信息，所以演示也是在测试他们吸收了多少信息。此外，这也能测试他们入职后是否真的喜欢这个领域。有些候选人会担心花费的时间太多，或者觉得“这任务太重了”。

---

### [00:49:30] Melissa Tan

**English:**
And definitely mindful of that. I think the main thing though is it is actually in the candidate's best interest to kind of understand what they're going to work on and start to understand, for example, there are some candidates that have gone through the far through process and haven't worked in the Webflow product very much. And I always think that is an interesting flag because if you aren't in the product a lot, you're not going to get good context on whether you like it or not. And so I actually think it's almost even in the best interest of the candidate to go much deeper.

**中文翻译:**
我确实会考虑到这一点。但我认为最重要的一点是，了解自己将要从事的工作内容其实符合候选人的最佳利益。例如，有些候选人面试流程走得很远，却没怎么用过 Webflow 的产品。我总觉得这是一个有趣的信号（flag），因为如果你不深入使用产品，你就无法判断自己是否真的喜欢它。所以我认为深入研究对候选人来说也是好事。

---

### [00:49:59] Lenny

**English:**
I could spend another hour talking about interview strategy, but I want to make sure we have time for the growth team stuff. So let's transition to that. And my first question here is you've worked with a lot of different teams, a lot of different companies on helping them figure out their growth strategy, hiring their growth teams, just kind of figuring out growth. I'm curious what the most common pitfalls and mistakes you've seen across companies trying to figure out growth and build growth teams.

**中文翻译:**
关于面试策略我还能再聊一小时，但我得确保有时间聊聊增长团队的事。让我们转到那个话题。我的第一个问题是：你曾与许多不同的团队和公司合作，帮他们制定增长策略、招聘增长团队。我很好奇，在公司尝试摸索增长和组建增长团队的过程中，你见过的最常见的陷阱和错误是什么？

---

### [00:50:26] Melissa Tan

**English:**
One of the most common pitfalls I'd say is not having, and I've alluded to this, not having a sense of the big picture from the start and not being strategic about what your go-to market strategy is going to be. Also, what is your pricing and packaging going to look like? So I wrote actually an article for the YC blog a few years ago with Abby [inaudible 00:50:48] who was on my team at Dropbox about this because I felt like even at Dropbox, I mean it's a great thing. We were haphazardly finding amazing things. We had a freemium consumer product. Then we realized people wanted a Teams product, so we built a Teams product, but we never created that whole blueprint of what should it look like and what are the different connection points across consumer business? What should our model look like? I've also seen companies that maybe weren't intentional enough about pricing from the start, and so thinking about what is the value metric?

**中文翻译:**
最常见的陷阱之一是——我之前提到过——从一开始就没有全局观，对进入市场（GTM）策略缺乏战略思考。此外，还有定价和包装。几年前我和 Dropbox 团队的 Abby 一起为 YC 博客写过一篇关于这方面的文章。因为我觉得即使在 Dropbox，虽然我们偶然发现了一些很棒的东西，但这其实是把双刃剑。我们有免费增值的消费者产品，后来发现人们需要团队版，于是做了团队版，但我们从未建立过完整的蓝图：它应该长什么样？消费者业务和企业业务之间的连接点在哪里？我们的模型应该是怎样的？我还见过一些公司在初期对定价不够深思熟虑，没有想清楚什么是“价值指标”（value metric）。

---

### [00:51:20] Melissa Tan

**English:**
And then they've already have massive scale and then they're rethinking their pricing. That's actually quite a big headache to actually think about, okay, how do we grandfather users? How do we bring the legacy customers onto our new pricing? And so thinking about your pricing from the start is important thing might go to market from the start is important. The other thing I have seen a lot is just like, again, this goes back to learning from Dropbox is the execution folks taking a class or reading a lot about growth and trying to do the same thing and not really actually starting from first let's look at our data. Let's talk to our customers. What do we think are the biggest hypotheses? And starting your experiments based on your own data and right-sizing the experiment.

**中文翻译:**
等到规模已经很大了才去重新思考定价，这真的很让人头疼：如何处理老用户（grandfathering）？如何让老客户接受新定价？所以从一开始就思考定价和 GTM 非常重要。另一件我经常见到的事——这又要回到 Dropbox 的教训——就是执行层的人上了一些课或读了很多关于增长的东西，然后试图照搬，而不是先看自己的数据、和自己的客户聊聊。我们最大的假设是什么？基于你自己的数据开始实验，并确保实验的规模合适。

---

### [00:52:10] Melissa Tan

**English:**
I think sometimes teams are experimenting on things that are too small, that aren't going to move the needle because they heard it was really successful company X, but that company X might be a Dropbox where every 0.5% improvement in conversion makes a difference, but if you're early stage doesn't matter and you need to actually think bigger. The other thing is the opposite problem, redoing a whole thing but not having a hypothesis, this was an early mistake I made at Dropbox where I redid the checkout page to something that I thought was better UX, but then I changed so many different components that even when it failed, it was unclear why it failed. So really distilling it to hypotheses.

**中文翻译:**
我认为有时团队实验的东西太小了，根本无法改变大局，仅仅是因为他们听说某某公司做这个很成功。但那家公司可能是 Dropbox，在那种规模下，转化率提高 0.5% 就意义重大；但如果你处于早期阶段，那根本不重要，你需要想得更大。另一个极端是：在没有假设的情况下重做整个东西。这是我在 Dropbox 犯过的一个早期错误：我重做了结账页面，自认为 UX 更好，但我改动了太多组件，以至于失败时根本搞不清楚为什么失败。所以，一定要将其提炼为具体的假设。

---

### [00:52:48] Melissa Tan

**English:**
And then the last thing I would say is figuring out what I call the flying formation of how the different growth teams will work with other companies. And again, I alluded to this, but growth shouldn't feel like it's a layer on top. And a lot of the things that are tricky early on is figuring out how you work with other teams. I think the best or the ideal way to work is to have growth infuse in the company. And so an example here is often the growth team is going to be potentially the closest to the user.

**中文翻译:**
最后一点是弄清楚我所谓的“飞行编队”（flying formation），即增长团队如何与其他部门协作。我之前提过，增长不应该感觉像是叠加在上面的一个层级。早期最棘手的事情之一就是理顺与其他团队的关系。我认为最理想的方式是让增长渗透到公司中。举个例子：增长团队往往是离用户最近的。

---

### [00:53:21] Melissa Tan

**English:**
They're going to get a lot of feedback. They're going to hear directly from the user. As a growth team, I think one of the big values that we can have is actually giving that feedback back to other teams at the company. And so even as a growth team, can we help inform the product roadmap? Also on the reverse, thinking about as PMs, how can PMs be more growth oriented as well?

**中文翻译:**
他们会收到很多反馈，直接听到用户的声音。作为增长团队，我认为我们能提供的巨大价值之一就是将这些反馈传达给公司的其他团队。所以，增长团队能否帮助完善产品路线图？反过来，PM 们又该如何变得更具增长导向？

---

### [00:53:44] Lenny

**English:**
I like this term flying formation. I've never heard of this before. What is that exactly again? Is that just how growth is integrated within the company?

**中文翻译:**
我喜欢“飞行编队”这个词，以前没听过。这具体是指什么？就是增长如何融入公司吗？

---

### [00:53:51] Melissa Tan

**English:**
Yeah, I guess flying formation essentially, I don't know where it comes from. I guess maybe it's a military term or something. Your finger.

**中文翻译:**
是的，我想“飞行编队”本质上……我不知道出处，可能是军事术语之类的。就像你的手指。

---

### [00:53:59] Lenny

**English:**
I can say that. Yeah, like the Blue Angels

**中文翻译:**
我明白，就像“蓝天使”飞行表演队。

---

### [00:54:00] Melissa Tan

**English:**
Work together?

**中文翻译:**
协同工作？

---

### [00:54:01] Lenny

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:54:02] Melissa Tan

**English:**
Yeah. I think of flying formation as how do we work together across teams. You also can think of it as a DACI too, driver accountable, contribute informed. I think sometimes when you don't know how you're going to work together, you end up stepping over each other's toes. You're unclear. Who was the decision maker here? Who did we need to work with? At what point in the journey? And so the flying formation, what I think it is, is part of it is a DACI of what are the different roles?

**中文翻译:**
是的。我把“飞行编队”看作是跨团队协作的方式。你也可以把它看作 DACI 模型（负责人、问责人、贡献者、知情人）。我认为有时如果你不知道如何协作，最终会互相踩脚。谁是决策者？我们需要和谁合作？在旅程的哪个阶段合作？这些都不明确。所以“飞行编队”的一部分就是明确不同角色的 DACI。

---

### [00:54:32] Lenny

**English:**
Can you define that actually? Because a lot of people probably won't know that term.

**中文翻译:**
你能定义一下那个词吗？因为很多人可能不知道。

---

### [00:54:36] Melissa Tan

**English:**
A DACI is a framework to think about the different roles on the team on a project or an area. So D stands for Driver. This is the person driving the project. A is Accountable, this is the person that's ultimately accountable and is often the final decision maker if there's any open questions. C is Contributor, these are all the different teams that are going to contribute. And then I is informed. These are the people that need to be informed, but they're not directly contributing. They're not a decision maker and part of the project.

**中文翻译:**
DACI 是一个思考团队在项目或领域中不同角色的框架。D 代表 Driver（执行者），即推动项目的人；A 代表 Accountable（责任人），即承担最终责任的人，通常也是有疑问时的最终决策者；C 代表 Contributor（贡献者），即参与贡献的不同团队；I 代表 Informed（知情者），即需要被告知进展但并不直接参与或决策的人。

---

### [00:55:08] Melissa Tan

**English:**
And so it's a nice simple framework for when you are working across teams and it needs to be clear who is in what role. And the area that tends to be the most confusing can be the accountable and who the decision maker is. It can be easy to have lots of teams and then it's unclear how do we get to a decision ultimately and who should make that decision. And that person should often be the person that has the most context or is ultimately responsible.

**中文翻译:**
这是一个非常简洁的框架，适用于跨团队协作，能明确每个人的角色。最容易混淆的地方往往是“责任人”和“决策者”。团队多了之后，很容易搞不清楚最终如何达成决策以及谁该做决策。而那个人通常应该是掌握最多背景信息或承担最终责任的人。

---

### [00:55:33] Melissa Tan

**English:**
And so I think the flying formation has this DACI. I often also put operating rhythms in it, so it's clear what is happening at what point. And so we created a flying formation when we were first starting the growth team at Webflow and we were trying to figure out how does product growth work with product, how does product growth work with growth marketing? What are the different cadences that each team has? And so very tactically we put a doc together to say, okay, product growth is accountable for all the metrics downstream of signups. Growth marketing is accountable for signups. They're also driving or have goals around CAC, their customer acquisition costs, and these are the different metrics everyone owns.

**中文翻译:**
所以我认为“飞行编队”包含了 DACI。我通常还会加入“运作节奏”（operating rhythms），明确什么时间点发生什么事。我们在 Webflow 刚组建增长团队时就创建了一个飞行编队，试图理顺：产品增长如何与产品团队协作？产品增长如何与增长营销协作？每个团队的节奏是怎样的？非常务实地，我们写了一份文档：产品增长负责注册（signup）之后的所有下游指标；增长营销负责注册，并对 CAC（客户获取成本）负责。每个人拥有的指标都清清楚楚。

---

### [00:56:14] Melissa Tan

**English:**
We have a weekly meeting where we look at the metrics together. We also will do updates around the room to talk about initiatives and identify areas we want to work with. And then we also think through quarterly planning where we're each identifying projects that we're driving. There's some projects that we might also work on together. And so it's essentially that meeting cadence that you're going to have the operating rhythms. That's essentially how I think about a flying formation.

**中文翻译:**
我们每周开会一起看指标，轮流更新各自的项目，并确定需要协作的领域。我们还会进行季度规划，明确各自推动的项目，以及需要共同完成的项目。本质上，这就是会议节奏和运作节奏的结合。这就是我理解的“飞行编队”。

---

### [00:56:40] Lenny

**English:**
I love it. That would make a great blog post. By the way, if you're looking for something to write an example of your actual client formation Webflow, I think people would love that.

**中文翻译:**
太棒了。这能写成一篇很棒的博客文章。顺便说一下，如果你想写点什么，分享一下 Webflow 实际的编队案例，大家一定会喜欢的。

---

### [00:56:48] Melissa Tan

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:56:48] Lenny

**English:**
One kind of tangent that I wanted to touch on is there's this trend of product teams owning revenue. Elena talked about this on a recent podcast. You have a perspective on should product growth teams own revenue and have revenue numbers as their goals or not?

**中文翻译:**
我想聊一个题外话：现在有一种趋势是产品团队负责收入。Elena 在最近的一期播客中也谈到了这一点。你对“产品增长团队是否应该负责收入并以收入数字为目标”有什么看法？

---

### [00:57:04] Melissa Tan

**English:**
Yeah, really it depends on the company and what product growth is driving. I've always, in the companies I was at and actually even the companies I advise, the product growth team owns revenue, so it's not always the case. I've actually seen revenue owned by marketing. So marketing makes sense if it's more top of funnel growth. I've also seen it, this is an interesting one, by finance actually. This is usually early in the company.

**中文翻译:**
这取决于公司以及产品增长所驱动的内容。在我待过的公司以及我咨询过的公司里，产品增长团队通常都负责收入，但并非总是如此。我也见过由营销部门负责收入的情况，如果增长主要集中在漏斗顶端，这很合理。我还见过由财务部门负责收入的，这很有趣，通常发生在公司早期。

---

### [00:57:31] Melissa Tan

**English:**
So early at Canva, it was owned by finance and that's because finance had a view on everything happening in the business and would actually be maybe advising other teams on, "Hey, our conversion rates could improve, we need to do X." Or we're not driving signups and customers efficiently, but over time it doesn't really sit in finance. That has evolved and then now sits under the person that is driving product growth in product. So I have seen it more often than not being owned by product. Our team at Dropbox moved a ton actually. We started marketing. We actually then report into the revenue org with sales, and then we finally moved into product because we realized so much of our revenue was that product growth motion happening in the product that we felt it was important that that product team owned revenue.

**中文翻译:**
在 Canva 早期，收入由财务部负责，因为财务部对业务全局有清晰的认识，会建议其他团队：“嘿，我们的转化率可以提高，我们需要做 X。” 或者“我们获取注册和客户的效率不够高。” 但随着时间推移，这通常不会留在财务部。它会演变，现在通常归属于产品部门中推动产品增长的人。所以我见到的更多是由产品部门负责。我们在 Dropbox 的团队变动很大：起初在营销部，后来向销售部门的收入组织汇报，最后转到了产品部，因为我们意识到大部分收入源于产品内部的增长动作，所以让产品团队负责收入至关重要。

---

### [00:58:20] Lenny

**English:**
A lot of the things you're talking about are based in how growth starts at a company. I imagine one of the most common questions you get is, how do I start to invest in growth? How do I hire my first growth person? How do I build a team around them? It's one of the most common questions I get. So let's spend a little time here. What is your advice to founders that are just starting to think about building their initial growth team and how to approach that to look for initially and kind of think about that longer term?

**中文翻译:**
你谈到的很多内容都基于增长在公司是如何起步的。我猜你被问到最多的问题之一就是：我该如何开始投入增长？如何招聘第一个增长人员？如何围绕他们组建团队？这也是我常被问到的。让我们聊聊这个：对于刚开始考虑组建初始增长团队的创始人，你有什么建议？初期该找什么样的人？长期又该如何考虑？

---

### [00:58:44] Melissa Tan

**English:**
I get this question a lot as well. I'd say initially when a company's starting out, the goal is getting to product market fit and figuring out who their ideal customer profile is, like their ICP. And at this point, I think everyone at the company should be thinking about growth. They're finding their first few design partners that they will co-create the product with. They're figuring out who is their product resonating with, who is maybe also the decision maker in purchasing the product. And they're figuring out, do we want kind of a bottom up product led motion? Are we going to lean more heavily into sales? Are we going to do both?

**中文翻译:**
我也经常被问到。我会说，在公司起步阶段，目标是达到 PMF 并确定理想客户画像（ICP）。在这个阶段，我认为公司里的每个人都应该思考增长。他们正在寻找最初的几个设计合作伙伴共同打造产品，弄清楚产品与谁产生了共鸣，谁是购买决策者。他们还在摸索：我们要走自下而上的 PLG 模式吗？还是要侧重销售？还是两者兼顾？

---

### [00:59:18] Melissa Tan

**English:**
After you reach product market fit and you're starting to get your first few customers, the first growth per person I see more often than not isn't someone driving acquisition. You need to find your first a thousand or thousands of customers and you need to do it at scale. And so if that is the focus of the company, typically what I would recommend is somebody that they don't need to be an expert, but ideally they understand maybe one or two channels well and that they're the channels that you have hypothesis, you will find traction in.

**中文翻译:**
当你达到 PMF 并开始获得最初的一批客户后，我见到的第一个增长人员往往不是负责获客（acquisition）的人。你需要找到最初的一千个或几千个客户，并且需要规模化地去做。如果这是公司的重点，我通常推荐的人选不需要是全才专家，但理想情况下，他们应该精通一两个渠道，且这些渠道正是你假设能产生吸引力的渠道。

---

### [00:59:50] Melissa Tan

**English:**
And I see this person a little bit like a portfolio manager, right? Because you're trying to figure out ... Usually companies don't have many channels that are split evenly. They find one or two that really work and make up like it's 80/20 rule. It makes us up 80% of where the signups are coming from and this portfolio manager is testing different things out. Even you could leverage agencies. There are a lot of agencies out there for SEO, for paid marketing, et cetera, but they are smart enough to define, is this working? How do I do it at scale? You also want to make sure it's quality signups that are actually monetizable.

**中文翻译:**
我把这个人看作有点像“投资组合经理”。因为通常公司不会有很多平摊的渠道，而是会发现一两个真正有效的渠道（遵循 80/20 法则），贡献了 80% 的注册量。这位经理的任务就是测试不同的东西。你甚至可以利用代理商（SEO、付费营销等），但这个人必须足够聪明，能判断：“这有效吗？如何规模化？” 你还要确保这些注册是高质量的、可变现的。

---

### [01:00:24] Melissa Tan

**English:**
And so that is a role typically if you're hiring an acquisition of that first growth person. And then the other two areas to focus early on, but I don't think you need a dedicated person for are activation. You want to make sure as you're pouring leads into the top of funnel, you're activating users. And here I don't think you actually need to do AB testing. Your volume isn't probably going to be strong enough. I think even just finding five individuals that are part of your target audience, just doing user testing, set up a Zoom, watch them onboard onto the product and have them talk out loud. You'll fight a lot and you can also just take best practices of onboarding checklists, et cetera. So activation and then I've said this a lot, but pricing and packaging, really thinking about pricing, but I don't think that needs to be a dedicated person.

**中文翻译:**
这就是第一个增长人员（如果是负责获客的话）的典型角色。早期需要关注的另外两个领域（虽然不需要专人负责）是激活和定价。当你向漏斗顶端注入线索时，必须确保用户被激活。在这里，我认为不需要做 AB 测试，因为你的流量可能不够大。哪怕只是找 5 个目标受众做用户测试，开个 Zoom 看着他们使用产品并让他们大声说出想法，你就能发现很多问题。你也可以直接采用新手引导清单等最佳实践。所以是激活，还有我多次提到的定价和包装，但这些早期不需要专人负责。

---

### [01:01:06] Lenny

**English:**
What kind of profile have you found to be most successful for this sort of person? Some people will look for like, I want to hire Melissa and let's just go big. The best person I can find and have them own this versus someone that's just new from school that's going to figure it out and I guess they're somewhere in the middle. What do you find that's best for that first hire?

**中文翻译:**
你发现哪种背景的人最适合这个职位？有些人想：“我要招个像 Melissa 这样的大牛，一步到位。” 也有人想招个刚毕业的学生来摸索。我想答案可能在中间。你觉得第一个增长雇员的最佳人选是什么样的？

---

### [01:01:26] Melissa Tan

**English:**
It really depends on the current makeup of the team. How much do the founders themselves or the current team, how much of an interest do they have in growth? If they have an interest in growth and it's more about finding someone to execute, I think it's finding someone that's a bit earlier in their career potentially that is just a strong first principles thinker. I think there's hit or miss on, I'm a former consultant, so I used to always say find a former consultant. I do think there can be hit or miss and there is some value in folks that actually understand acquisition and have done it before and so maybe have figured out certain channels.

**中文翻译:**
这取决于团队目前的构成。创始人或现有团队对增长有多大兴趣？如果他们有兴趣，只是需要人来执行，那么找一个职业生涯早期、具有强大第一性原理思维的人可能合适。我以前是做咨询的，所以过去总说找个前咨询顾问，但这种做法其实不一定稳。我认为找那些真正懂获客、以前做过并搞定过某些渠道的人是有价值的。

---

### [01:02:04] Melissa Tan

**English:**
So I think you either go for someone that's done acquisition before, maybe they're a little bit early in their career, so they have this great growth mindset, but make sure they're a first principles thinker. The other option is find just a really smart person early in their career, have them take up Reforge class, have them soak up everything, and then the other option of hiring someone more experienced. I think it really depends on if you want that person to take on a lot more and be almost part of your founding team. And do you want to find someone that is going to join your leadership team?

**中文翻译:**
所以，要么找一个做过获客、处于职业早期、有增长心态但必须是第一性原理思考者的人。另一种选择是找一个极其聪明的职场新人，让他们去上 Reforge 的课，吸收一切知识。当然也可以招更有经验的人，这取决于你是否希望此人承担更多责任，甚至成为创始团队的一员，或者加入领导层。

---

### [01:02:38] Melissa Tan

**English:**
The other option I guess is you could also just bring on an advisor and that advisor is someone that's not full time. It can even guide if you hire someone that's a bit earlier, guide that person and that is a really good combination. And so it really depends on the context, who's also on the current team and who you want to bring into. Are you looking for an actual leader that's going to scale with the company or are you not ready quite yet for that?

**中文翻译:**
还有一种选择是请一位兼职顾问。如果你招了一个比较资浅的人，顾问可以指导他，这是一个非常好的组合。所以这取决于背景：现有团队是谁？你想引进谁？你是想要一个能随公司一起成长的真正领导者，还是还没准备好到那一步？

---

### [01:03:03] Lenny

**English:**
What about in terms of their skillset? I imagine if you're kind of feeling like paid growth is going to be your main acquisition channel, you probably want to find someone that's really good at that versus it might be a virality, product led growth stuff, then you want to find maybe a product range of person. How much weight do you put into that skillset in that first hire?

**中文翻译:**
那技能组合呢？我想如果你觉得付费增长将是主要的获客渠道，你可能想找个精通此道的人；如果是靠病毒式传播或 PLG，你可能想找个懂产品的人。在招第一个人时，你对特定技能的权重放多少？

---

### [01:03:24] Melissa Tan

**English:**
I actually think it's less about expertise in skillset, if that makes sense. And more there a ability to, again, I think of it like a portfolio manager. So this is more on the growth marketing side and bringing in acquisition. They are managing a portfolio and they're trying to figure out what works. I actually think you need to find someone that's analytical for this role, but that also understands things like who is the user? They're really creative in finding the user. And so it's actually looking for attributes but not expertise.

**中文翻译:**
我其实认为，重点不在于特定技能的专业知识。更多的是一种能力——再说一遍，就像投资组合经理。在增长营销和获客方面，他们管理着一个组合并试图找出有效的方法。我认为你需要找一个有分析能力的人，但同时也要理解“用户是谁”。他们在寻找用户方面非常有创意。所以，寻找的是“特质”而非“专业经验”。

---

### [01:03:58] Melissa Tan

**English:**
I actually think the more expertise someone has, the more it actually can lead to a false precision and then thinking they know what they're going to do. And especially, I don't think you actually need paid marketing expertise until much later when you're starting to think about incrementality or you're managing all these campaigns. I actually think the expertise is more important later. And then similarly on product growth, I actually think product growth is not higher till much later. A lot of early stage companies don't even have a product manager until later. And so I find that a growth product person isn't until much later down the road.

**中文翻译:**
我认为一个人越专业，有时反而会导致“虚假精准”，让他们自以为知道该怎么做。特别是付费营销，直到你需要考虑增量（incrementality）或管理大量广告系列时，才真正需要专业知识。我认为专业性在后期更重要。同样，产品增长通常也不会在很早期就招聘。很多早期公司甚至连 PM 都没有，所以增长产品经理通常是很晚才会出现的角色。

---

### [01:04:36] Lenny

**English:**
Just a couple more questions. One is, you mentioned that it sometimes makes sense to bring on an advisor. I know sometimes companies have a bad time with advisors that just don't provide much value and they're giving equity. Other times it's transformative. Some of the stories you've shared, when is it appropriate to hire an advisor and is there any, I guess advice for what to look for in a growth advisor at this early stage, especially?

**中文翻译:**
还有几个问题。第一，你提到有时请顾问很有意义。我知道有些公司和顾问的合作体验很差——给了股份却没拿到什么价值。但有时又是脱胎换骨的。根据你分享的故事，什么时候适合请顾问？对于早期阶段寻找增长顾问，你有什么建议？

---

### [01:05:00] Melissa Tan

**English:**
I would add an advisor if there is probably a knowledge gap on the team is I would say. And their advisors come in so many different forms too, and everyone does it slightly differently. For some folks, it's a monthly call for other times, especially when I'm full-time advising, I'll have weekly calls. I'll even join some team meetings. I'll look at mocks. And so everyone does it slightly differently. And so I think it depends on what you're looking for. I would definitely say that even getting to know the individual and making sure you're on the same page on what you're looking for and what the goals are. And then what I've done in the past too is initially set up a shorter engagement, like a quarter long engagement and then decide if you want to go longer.

**中文翻译:**
我会说，如果团队存在知识缺口，就该请顾问。顾问的形式多种多样，每个人的做法也不同。有些人是每月通个电话；而我全职做顾问时，会有每周例会，甚至参加团队会议、查看原型图（mocks）。所以这取决于你的需求。我建议先深入了解对方，确保双方在需求和目标上达成一致。我过去的做法是先设定一个短期的合作（比如一个季度），然后再决定是否长期合作。

---

### [01:05:47] Melissa Tan

**English:**
I also think it's fine to, let's say you have an advisor agreement, you're not getting value to basically part ways. If it's not, you're not finding value. I think every advisor wants to make sure they're adding value. So I definitely think to summarize, being really explicit on what advice you're looking for and making sure you're on the same page of what you want. And then also set up a try before you buy if you want to do a quarter long engagement first. And knowing you can always part ways if it's not a fit even before that period of time.

**中文翻译:**
我也认为，如果你签了顾问协议却没看到价值，分道扬镳也没关系。我认为每个顾问都希望确保自己能提供价值。总结一下：明确你需要什么样的建议，确保双方步调一致。此外，可以尝试“先试后买”，先签一个季度的合同。如果发现不合适，即使在合同期满前也可以随时终止。

---

### [01:06:20] Lenny

**English:**
Last question before we get to a very exciting lightning round. You've brought up this concept of first principles thinking. I'm curious how you measure that and how you get a sense of, is this person strong at first principles thinking?

**中文翻译:**
在进入精彩的闪电轮提问之前，最后一个问题。你提到了“第一性原理思维”。我很好奇你如何衡量这一点？你如何判断一个人是否具备强大的第一性原理思维？

---

### [01:06:34] Melissa Tan

**English:**
It's definitely a word I use a lot. First principles thinking, I think of it as you are not using a set framework and set formula, but you're creating your own based on the context that you're getting. And so when I think about first principles thinking often it is knowing what questions to ask so that you can start forming a mental model. And then it is actually starting to form that mental model and then knowing to evolve it and knowing when it's not working and really coming from a place of curiosity of is this really working? This is something that I'm known for on my team as well, which is I ask tons of questions, but it doesn't come from a place of wanting to show that I'm asking good questions or anything that comes from a place of trying to solve the problem and making sure that we're always solving the problem at hand, making sure we're doing the right things.

**中文翻译:**
这确实是我常挂在嘴边的词。我认为第一性原理思维就是不套用现成的框架和公式，而是根据你获得的背景信息创建自己的框架。它通常意味着知道该问什么问题，以便开始构建心智模型（mental model），然后不断演进这个模型，在它失效时果断察觉。这源于一种好奇心：“这真的有效吗？” 我在团队中也以此闻名：我会问大量问题，但这并非为了显摆，而是为了解决问题，确保我们始终在处理核心矛盾，确保我们在做正确的事。

---

### [01:07:28] Melissa Tan

**English:**
If there's new information, do we actually still want to do it this way? And so I think first principles thinking is often about asking questions and then creating your own framework. That's how I would define it. And it's maybe another way to describe it is critical thinking. It's like you're able to think very critically, and I think it's important to, at least for me, create a culture where that's okay. I think the moment you have a culture where people aren't asking questions aren't constantly revisiting their work, that's when you're not maybe pushing yourself to do your best work. And I think it also just creates a fun environment where we're like, "Oh yeah, why are we doing this?" And really leading with your curiosity.

**中文翻译:**
如果有新信息，我们还要按原计划进行吗？所以我认为第一性原理思维的核心是提问并建立自己的框架。另一种说法是批判性思维。对我来说，建立一种“允许提问”的文化非常重要。如果一个文化中人们不再提问、不再审视自己的工作，那就无法逼出最好的成果。而且这也能营造一种有趣的氛围，大家会想：“哦对啊，我们为什么要这么做？” 真正由好奇心驱动。

---

### [01:08:06] Lenny

**English:**
Is there an example of a person or moment or question that comes to mind of this is an epitome of a first principles thinker moment or question or a way of approaching something?

**中文翻译:**
有没有哪个人、哪个时刻或哪个问题让你觉得是“第一性原理思维”的典范？

---

### [01:08:17] Melissa Tan

**English:**
My aha moment of the value of first principles thinking was when I was at Dropbox and we had the most unconventional people on our initial sales team. Dropbox was known for this. We would hire a ton of really smart people that had never done sales and had them do sales. There were a lot of disadvantages to that, I think. We were figuring a lot of things out. Maybe we should have split, had a few people that knew sales better and a combo of both. But I do think it led to a ton of innovation. Even I actually started on the sales team, this is a fun fact. I used to answer the 1-800 number at Dropbox, and if you go to Dropbox's website, you see a chat level. I used to also do that role, and so I think that what we got from that was that's how we got our very innovative go-to-market motions.

**中文翻译:**
我顿悟到第一性原理价值的时刻是在 Dropbox。我们最初的销售团队由一群最“不走寻常路”的人组成。Dropbox 以此闻名：雇佣一大批聪明但从未做过销售的人去跑销售。虽然有很多弊端，我们当时也在摸索，也许本该找几个懂销售的人搭配一下。但我认为这带来了巨大的创新。有趣的是，我最初也是销售团队的。我以前负责接听 Dropbox 的 1-800 电话，如果你去 Dropbox 网站看那个在线聊天窗口，我也干过那个活儿。我认为正是这种背景让我们产生了很多创新的 GTM 动作。

---

### [01:09:03] Melissa Tan

**English:**
That also gave a ton of people, 'cause a lot of those people then moved into different functions at the company. They had all this context on who the user was. They had talked to so many different users at that point, and that's actually what helped me a lot when I moved into growth is I had all that context and I learned from that going back to first principles thinking that if you take people that are just super smart, they've never done it before, one advantage of that is they can innovate because I think they come in with, "I don't know anything. Let me just figure this out." Versus someone that think they know all the answers, limits you into what you are going to do. And so my aha moment was really at Dropbox seeing so many times people that had never done these things and then seeing so much innovation come as a result of that.

**中文翻译:**
这让很多人受益匪浅，因为他们后来转到了公司的不同职能部门。他们对用户有极深的了解，因为他们和太多用户聊过了。这在我转到增长部门时帮了大忙。我学到的是：如果你录用极其聪明但没有相关经验的人，优势在于他们能创新，因为他们抱着“我什么都不知道，让我搞清楚”的心态。相比之下，那些自以为知道所有答案的人反而会限制你的行动。所以我的顿悟时刻就是在 Dropbox 看到那些从未做过这些事的人带来了如此多的创新。

---

### [01:09:51] Lenny

**English:**
That is an awesome story. Is there anything else you wanted to share or touch on before we get to or very exciting lightning round?

**中文翻译:**
真是个精彩的故事。在进入闪电轮之前，你还有什么想分享或提到的吗？

---

### [01:09:58] Melissa Tan

**English:**
I think that's it. I wanted to make sure, I know I talked a lot about developing people, so thank all the people that have helped develop me in my career and then especially thank all the folks that I've worked with and my team, especially the team at Webflow and particularly wanted to make sure to thank [Xing Lin 01:10:14], Rory Davidson and [Jo Wang01:10:16] who joined me from previous companies to Webflow.

**中文翻译:**
差不多了。我想说，既然聊了这么多关于培养人才的话题，我要感谢职业生涯中帮助过我的所有人，特别要感谢与我共事过的同事和我的团队，尤其是 Webflow 的团队。特别想感谢 Xing Lin、Rory Davidson 和 Jo Wang，他们跟随我从之前的公司来到了 Webflow。

---

### [01:10:20] Lenny

**English:**
Shoutouts. Well, with that, Melissa, we have reached our very exciting lightning ground. I've got six questions for you. Are you ready?

**中文翻译:**
致敬！那么 Melissa，我们进入了激动人心的闪电轮。我有六个问题，准备好了吗？

---

### [01:10:27] Melissa Tan

**English:**
Yes.

**中文翻译:**
准备好了。

---

### [01:10:28] Lenny

**English:**
What are two or three books that you've recommended most to other people?

**中文翻译:**
你向别人推荐最多的两三本书是什么？

---

### [01:10:32] Melissa Tan

**English:**
The first one is Leaders Eat Last. I really like that leadership book by Simon Sinek. Also two non-career related books is The Untethered Soul. It really has taught me a lot about being present and then also the Four Agreements, which is a very short and easy read, but good principles to live by.

**中文翻译:**
第一本是 Simon Sinek 的《领导者最后用餐》（Leaders Eat Last），我很喜欢这本关于领导力的书。还有两本与职业无关的书：一本是《不羁的灵魂》（The Untethered Soul），它教会了我很多关于“活在当下”的道理；另一本是《四个约定》（The Four Agreements），非常简短易读，但包含了很多优秀的人生准则。

---

### [01:10:52] Lenny

**English:**
What is a favorite recent movie or TV show?

**中文翻译:**
最近最喜欢的电影或电视节目是什么？

---

### [01:10:55] Melissa Tan

**English:**
This one isn't super recent, but Winning Time on HBO. It's about the LA Lakers during the '80s and the Showtime era. I'm originally from LA and grew up a Lakers fan, so it's a fun watch for me and a nice escape.

**中文翻译:**
不算特别新，但 HBO 的《胜利时刻》（Winning Time）很棒。讲的是 80 年代洛杉矶湖人队的“表演时刻”（Showtime era）。我来自洛杉矶，从小就是湖人球迷，所以看这部剧对我来说很有趣，也是一种很好的放松。

---

### [01:11:09] Lenny

**English:**
You'll love a new movie I just watched last night called Air, which is about how Nike got Michael Jordan signed. And it's similar vibes to that show.

**中文翻译:**
那你一定会喜欢我昨晚刚看的电影《气垫传奇》（Air），讲的是耐克如何签下迈克尔·乔丹的。氛围和那部剧很像。

---

### [01:11:18] Melissa Tan

**English:**
Yes, yes. I actually just watched that recently too.

**中文翻译:**
是的，我最近也看了。

---

### [01:11:20] Lenny

**English:**
Okay. Great.

**中文翻译:**
太好了。

---

### [01:11:20] Melissa Tan

**English:**
That's a good one too. Yeah, I've watched all those basketball.

**中文翻译:**
那部也很棒。是的，我看了所有关于篮球的片子。

---

### [01:11:23] Lenny

**English:**
Oh man. I also grew up in LA. Also a huge Laker fan from-

**中文翻译:**
天哪，我也在洛杉矶长大，也是铁杆湖人迷。

---

### [01:11:26] Melissa Tan

**English:**
Oh, nice.

**中文翻译:**
噢，太棒了。

---

### [01:11:27] Lenny

**English:**
From before. Next question, what's a favorite interview question you like to ask?

**中文翻译:**
言归正传。下一个问题：你最喜欢问的面试问题是什么？

---

### [01:11:33] Melissa Tan

**English:**
For me, it's not a question, but it's that stage of preparing before the presentation and getting a sense for what it's like to work with each other. I think that has been one of the best ways for me to get signal.

**中文翻译:**
对我来说，不是一个具体的问题，而是演示前的准备阶段，以此了解彼此共事的感觉。我认为这是我获取信号的最佳方式之一。

---

### [01:11:45] Lenny

**English:**
Can you say more on that?

**中文翻译:**
能再多说一点吗？

---

### [01:11:46] Melissa Tan

**English:**
Yes. So it's essentially that prep call before I ask them to do a presentation and going through the presentation together and working together on refining it.

**中文翻译:**
是的。本质上就是正式演示前的那个预备电话，我们一起过一遍内容，共同完善它。

---

### [01:11:57] Lenny

**English:**
Awesome. We already talked about that, so we'll move on. What is a favorite product you've recently discovered that you love?

**中文翻译:**
太棒了，我们之前聊过这个，那就继续。你最近发现并喜爱的产品是什么？

---

### [01:12:04] Melissa Tan

**English:**
I feel like everyone's saying this, but ChatGPT. I feel like it has really changed everything. There's so many interesting ways to use it. My team at Webflow right now is also starting to think about incorporating AI into the product, and so yeah, I just think that is ... Yeah, so many things you can do with it.

**中文翻译:**
我觉得大家都在说这个，但确实是 ChatGPT。我觉得它改变了一切。有很多有趣的用法。我们在 Webflow 的团队现在也开始考虑将 AI 融入产品。它能做的事情太多了。

---

### [01:12:22] Lenny

**English:**
What is something relatively minor that you've changed in your product development process that has had a big impact on the way that your team executes?

**中文翻译:**
在产品开发流程中，你做了哪些相对较小但对团队执行方式产生重大影响的改动？

---

### [01:12:30] Melissa Tan

**English:**
This one here is what I also spoke about for earlier, which is, I mean, thinking through your DACI. It sounds so simple, but I do think a lot of times teams are thinking through how do they work with other teams? Who is driving? Who is the decision maker? And so having a DACI, I have found is really helpful.

**中文翻译:**
还是我之前提到的：理顺你的 DACI。听起来很简单，但我认为很多时候团队都在纠结如何与其他团队协作、谁负责推动、谁做决策。我发现建立 DACI 机制非常有帮助。

---

### [01:12:52] Lenny

**English:**
Final question, you've been at Webflow for a number of years. What is a favorite pro tip for using Webflow?

**中文翻译:**
最后一个问题：你在 Webflow 待了好几年，使用 Webflow 有什么“专业小贴士”吗？

---

### [01:12:57] Melissa Tan

**English:**
Yeah, I actually have two if that's okay.

**中文翻译:**
我有两个，可以吗？

---

### [01:12:59] Lenny

**English:**
That's good. Even better [inaudible 01:13:01].

**中文翻译:**
当然，越多越好。

---

### [01:13:01] Melissa Tan

**English:**
Yeah, yeah. So one is thing that I've often heard from folks is it's hard to learn Webflow. And so basically watching our university videos, which is where we teach Webflow while also building the designer, and we actually now enable to have the videos in the product, so you can do them side by side. And then the other one is our Figma to Webflow plugin, which is you can take a Figma design and then convert it to Webflow, which is a great hack if you already have a design in Figma.

**中文翻译:**
好。第一点：我常听人说 Webflow 很难学。其实可以看我们的 Webflow University 视频，我们在教你使用 Webflow 的同时也在构建设计器。现在我们支持在产品内部直接观看视频，你可以边看边做。第二点是我们的 Figma to Webflow 插件，你可以直接把 Figma 设计稿转换成 Webflow 页面。如果你已经有了 Figma 设计，这绝对是个神器。

---

### [01:13:32] Lenny

**English:**
Wow, I did not know that existed. That is a really smart idea and feature. Melissa, I could see why people follow you from company to company. I feel like the companies that are going to get to work with you in this new stage of your life are also very lucky. Thank you for being here. Two final questions. Where can folks find you online if they want to reach out? And how can listeners be useful to you?

**中文翻译:**
哇，我竟然不知道有这个插件。这功能太聪明了。Melissa，我明白为什么人们愿意追随你了。我觉得在你人生新阶段能与你合作的公司会非常幸运。谢谢你的到来。最后两个问题：如果大家想联系你，在哪里可以找到你？听众们能为你做些什么？

---

### [01:13:51] Melissa Tan

**English:**
Folks can find me on LinkedIn, also on Twitter, Melissamtan, and then how can listeners be helpful to me? I mean, I love jamming on things, growth, thinking about leadership and managing, so if any of this resonates, reach out. I'd love to have a discussion and yeah.

**中文翻译:**
大家可以在 LinkedIn 找到我，也可以在 Twitter 上关注 Melissamtan。至于听众能帮我什么？我喜欢讨论增长、领导力和管理。如果这些内容引起了你的共鸣，欢迎联系我。我很乐意进行探讨。

---

### [01:14:08] Lenny

**English:**
Amazing. Melissa, again, thank you for being here.

**中文翻译:**
太棒了。Melissa，再次感谢你的到来。

---

### [01:14:11] Melissa Tan

**English:**
Yes, thanks so much, Lenny. This was fun.

**中文翻译:**
谢谢，Lenny。聊得很开心。

---

### [01:14:14] Lenny

**English:**
Bye everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
大家再见。非常感谢收听。如果你觉得本期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅。此外，请考虑给我们评分或留下评论，这能帮助更多听众发现这个播客。你可以在 lennyspodcast.com 找到往期所有节目或了解更多信息。下期节目见。