# Meltem Kuran - 双语对照

# Lenny's Podcast: Meltem Kuran (Deel) - Bilingual Transcript
# Lenny's Podcast：对话 Meltem Kuran (Deel) - 中英双语全记录

---

### (00:00:00) Meltem Kuran Berkowitz

**English:**
... early days, it's very important to just go back to the basics, build the skeleton before you put on the makeup. So the first question I would ask is, do you have a website? Is it fast? Do the search engine knows that it exists? Okay, great. The next step would be, can people find it? If they can't find it, do you need to write content to make sure that people can find it? Only after all of those questions are answered, should you then consider, do I have money? Can I put it behind some paid ads to make sure people come to my website? You can't run a successful paid ads program if you have a website that's loading in four plus seconds. So really going back to the basics and starting from a good experience at the core and then expanding step-by-step from there.

**中文翻译:**
……在早期阶段，回归基础非常重要，要在“化妆”之前先“搭建骨架”。所以我问的第一个问题会是：你有网站吗？它运行快吗？搜索引擎知道它的存在吗？好，太棒了。下一步就是：人们能找到它吗？如果找不到，你是否需要撰写内容来确保人们能搜到它？只有在回答了所有这些问题之后，你才应该考虑：我有钱吗？我能把钱投到付费广告上以确保人们访问我的网站吗？如果你的网站加载时间超过四秒，你是不可能运行一个成功的付费广告项目的。所以，真的要回归基础，从核心的良好体验开始，然后从那里一步步扩展。

---

### (00:00:47) Lenny

**English:**
Welcome to Lenny's Podcast where I interview world-class product leaders and growth experts to learn from their hard won experiences building and growing today's most successful products. Today my guest is Meltem Kuran Berkowitz. Meltem is head of growth at Deel, which is arguably the fastest growing SaaS business of all time, possibly even faster than Ramp, which we delved into in a previous episode. They went from $0 in revenue to a mind-boggling $300 million in revenue in three years, while also staying EBITDA positive.

**中文翻译:**
欢迎来到 Lenny 的播客。在这里，我会采访世界级的产品领导者和增长专家，学习他们在构建和增长当今最成功产品过程中获得的宝贵经验。今天的嘉宾是 Meltem Kuran Berkowitz。Meltem 是 Deel 的增长负责人。Deel 可以说是史上增长最快的 SaaS（软件即服务）企业，甚至可能比我们在前几集深入探讨过的 Ramp 还要快。他们在三年内从零收入增长到了令人咋舌的 3 亿美元年收入，同时还保持了 EBITDA（税息折旧及摊销前利润）为正。

---

### (00:01:15) Lenny

**English:**
Meltem has led their growth team from the early days. And today leads all their growth efforts, including paid ads, product marketing, content, community, brand and more. Before joining Deel, she was leading marketing efforts at Bench Accounting. In our conversation, Meltem shares how Deel kick started growth through low-cost growth channels like tapping into communities like Reddit and also content and SEO. She also talks about how she evolved her thinking on growth investments as the company grew. She shares a bunch of tactical advice for how to do SEO well, how to do paid ads well, and how to structure your early growth team and prioritize your early investments. She also shares her experience building a culture of speed and optimism and so much more. Enjoy this episode with Meltem Kuran Berkowitz after a short word from our sponsors.

**中文翻译:**
Meltem 从早期就开始领导他们的增长团队，如今负责所有的增长工作，包括付费广告、产品营销、内容、社区、品牌等等。在加入 Deel 之前，她在 Bench Accounting 领导营销工作。在我们的对话中，Meltem 分享了 Deel 如何通过低成本渠道启动增长，比如挖掘 Reddit 等社区，以及内容营销和 SEO（搜索引擎优化）。她还谈到了随着公司的成长，她对增长投资的思考是如何演变的。她分享了一系列实战建议，包括如何做好 SEO、如何做好付费广告，以及如何组建早期增长团队并确定早期投资的优先级。她还分享了建立速度与乐观文化等方面的经验。在听完赞助商的简短介绍后，请欣赏本期与 Meltem Kuran Berkowitz 的对话。

---

### (00:02:01) Lenny

**English:**
Today's episode is brought to you by Miro, an online collaborative whiteboard that's designed specifically for teams like yours. The best way to see what Miro is all about and how it can help your team collaborate better is not to listen to me talk about it, but to go check it out for yourself, go to miro.com/lenny. With the help of the Miro team, I created a super cool Miro board with two of my own favorite templates, my one pager template and my managing up template that you can plug and play and start using immediately with your team. I've also embedded a handful of my favorite templates that other people have published in the Miro-verse. When you get to the board, you can also leave suggestions for the podcast, answer a question that I have for you, and generally just play around to get a sense of how it all works.

**中文翻译:**
本期节目由 Miro 赞助播出。Miro 是一款专为团队设计的在线协作白板。了解 Miro 及其如何帮助团队更好协作的最佳方式不是听我在这说，而是亲自去体验一下，请访问 miro.com/lenny。在 Miro 团队的帮助下，我创建了一个非常酷的 Miro 画板，其中包含两个我最喜欢的模板：我的“一页纸计划书”模板和“向上管理”模板，你可以直接套用并立即与团队开始使用。我还嵌入了一些其他人在 Miro-verse 中发布的我最喜欢的模板。当你进入画板时，你还可以为播客留下建议，回答我提出的问题，或者只是随便玩玩，感受一下它的运作方式。

---

### (00:02:44) Lenny

**English:**
Miro is a killer tool for brainstorming with your team, laying out your strategy, sharing user research findings, capturing ideas, giving feedback on wireframes, and generally just collaborating with your colleagues. I actually used Miro to collaborate with the Miro team on creating my own board, and it was super fun and super easy. Go check it out at miro.com/lenny. That's M-I-R-O.com/lenny.

**中文翻译:**
Miro 是一个非常棒的工具，适用于团队头脑风暴、制定战略、分享用户研究结果、捕捉创意、对线框图提供反馈，以及与同事进行各种协作。实际上，我就是用 Miro 与 Miro 团队协作创建了我自己的画板，过程非常有趣且简单。快去 miro.com/lenny 看看吧。

---

### (00:03:10) Lenny

**English:**
Today's episode is brought to you by LMNT. I just recently discovered this stuff actually from another podcast, and it is such sweet, salty goodness. LMNT is a tasty electrolyte drink mix with a science-backed electrolyte ratio. And unlike most electrolyte drinks, there's no sugar, coloring, artificial ingredients, gluten or any other BS. Getting enough electrolytes helps prevent and eliminate headaches, muscle cramps, fatigue, sleeplessness, and other common symptoms of electrolyte deficiency. LMNT is the exclusive hydration partner to Team USA Weightlifting and many other Olympic athletes. Also dozens of NBA and NFL teams and players rely on LMNT to stay hydrated along with Navy SEAL teams, FBI sniper teams and the Marines.

**中文翻译:**
本期节目由 LMNT 赞助。我最近刚从另一个播客中发现了这个东西，它真是那种又甜又咸的美味。LMNT 是一款美味的电解质饮料冲剂，具有科学支持的电解质配比。与大多数电解质饮料不同，它不含糖、色素、人工成分、麸质或其他任何乱七八糟的东西。摄入足够的电解质有助于预防和消除头痛、肌肉抽搐、疲劳、失眠以及其他常见的电解质缺乏症状。LMNT 是美国举重队和许多其他奥运选手的独家补水合作伙伴。此外，数十支 NBA 和 NFL 球队及球员，以及海豹突击队、FBI 狙击小组和海军陆战队都依靠 LMNT 来保持水分。

---

### (00:03:52) Lenny

**English:**
You can try LMNT totally risk-free. If you don't like it, you can share it with a salty friend and they'll give you your money back no questions asked. To give it a shot, go to drinklmnt.com/lenny and you'll get a free sample pack with any purchase, which includes one packet of every flavor. My favorite is Watermelon Salt. You won't find this offer publicly available, so you have to head to drinklmnt.com/lenny to take advantage of this offer. Stay salty.

**中文翻译:**
你可以完全无风险地尝试 LMNT。如果你不喜欢，可以把它分享给一个“重口味”的朋友，他们会无条件退款。想要尝试的话，请访问 drinklmnt.com/lenny，任何购买都会附赠一个免费样品包，包含每种口味的一小袋。我最喜欢的是西瓜盐味。这个优惠在公开渠道是找不到的，所以你必须去 drinklmnt.com/lenny 才能享受。保持活力（Stay salty）。

---

### (00:04:22) Lenny

**English:**
Meltem, thank you so much for being here, welcome to the podcast.

**中文翻译:**
Meltem，非常感谢你能来，欢迎来到我们的播客。

---

### (00:04:26) Meltem Kuran Berkowitz

**English:**
Thank you for having me, I'm very excited to be here.

**中文翻译:**
谢谢你的邀请，很高兴能来到这里。

---

### (00:04:28) Lenny

**English:**
I'm more excited that you're here. So you're head of growth at Deel. For people that aren't familiar with Deel, can you just give us a sense of what does Deel do briefly? And then also can you just share some stats around the trajectory of Deel? It feels like it's been this extraordinary journey, and I'm curious just to hear some of the stats of just how extraordinary.

**中文翻译:**
你来我更兴奋。你是 Deel 的增长负责人。对于那些不熟悉 Deel 的人，你能简要介绍一下 Deel 是做什么的吗？另外，能否分享一些关于 Deel 发展轨迹的数据？感觉这是一段非凡的旅程，我很想听听到底有多么惊人。

---

### (00:04:46) Meltem Kuran Berkowitz

**English:**
Yeah, so Deel is payroll, HR, and compliance platform for global teams. So essentially we help companies expand globally with tools like Deel HR, immigration, employer record hiring, independent contractor hiring, payroll, both global and US. So whether you're trying to hire someone as a full-time employee in Japan or you're trying to make sure your contractor in Germany has everything they need on day one, our platform allows you to take care of everything all in one place.

**中文翻译:**
好的。Deel 是一个面向全球团队的薪酬、人力资源和合规平台。本质上，我们通过 Deel HR、移民支持、名义雇主（EOR）招聘、独立合同工招聘以及全球和美国薪酬管理等工具，帮助公司进行全球扩张。所以，无论你是想在日本招聘一名全职员工，还是想确保你在德国的合同工在入职第一天就拥有一切所需，我们的平台都能让你在一个地方处理好所有事情。

---

### (00:05:13) Meltem Kuran Berkowitz

**English:**
And when I joined Deel, actually that was around July, 2020, we were less than a million dollars in ARR. And then over time, within the first year on January, 2021, we were at $4 million ARR. We finished 2021 with 57 million. April '22, we were looking at a hundred million. And then we started off this year with $295 million in ARR. And what we're particularly proud of is that we've been EBITDA positive. So that's something that we are very, very proud of on top of the ARR growth.

**中文翻译:**
我是在 2020 年 7 月左右加入 Deel 的，当时我们的 ARR（年度经常性收入）还不到 100 万美元。随着时间的推移，到第一年结束时的 2021 年 1 月，我们的 ARR 达到了 400 万美元。2021 年结束时达到了 5700 万美元。2022 年 4 月，我们达到了 1 亿。而今年年初，我们的 ARR 已经达到了 2.95 亿美元。我们特别自豪的是，我们已经实现了 EBITDA 转正。在 ARR 增长之外，这是我们非常、非常自豪的一点。

---

### (00:05:48) Lenny

**English:**
Amazing. And you said that you were super early at Deel. Can you give us a sense of just how early and what that was like?

**中文翻译:**
太神奇了。你说你很早就加入了 Deel。你能让我们感受一下到底有多早，当时是什么样子的吗？

---

### (00:05:54) Meltem Kuran Berkowitz

**English:**
I was the second hire to the marketing team, and I was I believe either employee 19 or 20 on the overall Deel team.

**中文翻译:**
我是营销团队的第二名员工，在整个 Deel 团队中，我应该是第 19 或第 20 名员工。

---

### (00:06:02) Lenny

**English:**
We had the head of product from Ramp on this podcast, and it feels like there's this little bit of which company grew faster early on in the trajectory of the two, but we don't have to debate it. It feels like these are maybe the two fastest growing SaaS businesses in history. Does that sound about right?

**中文翻译:**
我们之前请过 Ramp 的产品负责人来这个播客，感觉这两家公司在早期发展轨迹上谁增长得更快还有点小争议，不过我们不需要争论这个。感觉这两家可能是历史上增长最快的两家 SaaS 企业。听起来对吗？

---

### (00:06:16) Meltem Kuran Berkowitz

**English:**
That's true, yeah. So Ramp was the first one to be crowned the fastest growing, and then we took that crown from them. So I think we're both right, in that at a certain point in time we've each been the fastest growing. But they're amazing.

**中文翻译:**
没错。Ramp 是第一个被冠以“增长最快”称号的公司，然后我们从他们手中夺走了这个桂冠。所以我觉得我们都对，在某个特定的时间点，我们各自都是增长最快的。但他们确实很棒。

---

### (00:06:34) Lenny

**English:**
What I want to start with is something that I heard about you, which is that you specialize in cheaper growth channels, and that's actually the reason that Deel ended up hiring you, is they wanted to find ways to grow cheaply. And so a couple of questions. One is just, what did you find worked really well from that perspective at Deel? And then two, what are today's maybe cheaper growth channels that you think people are under investing in? Whatever you're willing to share there, I don't know if you want to give away all your secrets.

**中文翻译:**
我想先从我听到的关于你的一件事开始：你擅长低成本增长渠道，这实际上也是 Deel 最终聘用你的原因，因为他们想找到廉价增长的方法。所以我有两个问题。第一，从这个角度来看，你发现 Deel 有哪些方法非常奏效？第二，你认为当今有哪些人们投资不足的廉价增长渠道？无论你愿意分享什么都可以，我不知道你是否想保留你的秘密。

---

### (00:06:56) Meltem Kuran Berkowitz

**English:**
I'm happy to give away all and everything. So I think before we dive into the list of cheap channels, which I will get to, it's very important to notice, especially in the B2B world, most of the businesses are started because there's an active problem. And so when you go out to the market and try to answer people's questions, people don't want to be sold to, they want their problem solved. So those cheaper channels are often places where people are just trying to get an answer to their question. So whether that be search engine optimization through the articles that you write for people, looking onto Reddit where people are asking these questions in communities, forming partnerships with other groups that are trying to answer these questions, existing communities where other business leaders are connecting with each other and looking at their peers to find answers to shared problems that they're having, or places like Quora. That's, when you think about cheap channels, that's a really good place to start, is just add value to people, answer their questions.

**中文翻译:**
我很乐意分享一切。在深入探讨廉价渠道列表之前，有一点非常重要，特别是在 B2B 领域：大多数业务的启动是因为存在一个亟待解决的问题。所以当你进入市场并试图回答人们的问题时，人们不想被推销，他们想解决问题。因此，那些廉价渠道通常是人们试图寻找答案的地方。无论是通过你为人们撰写的文章进行 SEO（搜索引擎优化），还是在 Reddit 社区里观察人们提出的问题，或者与同样试图回答这些问题的其他团体建立合作伙伴关系，亦或是现有的商业领袖互相联系、向同行寻求共同问题答案的社区，或者是像 Quora 这样的地方。当你考虑廉价渠道时，这些都是很好的起点：只需为人们提供价值，回答他们的问题。

---

### (00:07:54) Meltem Kuran Berkowitz

**English:**
And when you answer their questions and present your solution, if it's a fit to what they're looking for, that ends up being a cheap channel for you. You don't necessarily have to advertise, when you go to Reddit and you set up those keywords to be tracking when people ask certain questions, you're not paying any money to do that. You're just seeing, oh, someone has this question, I have the answer to that, here you go. And connecting with them, it takes time. But early on, those were a lot of the things that we invested in.

**中文翻译:**
当你回答了他们的问题并展示了你的解决方案，如果这正好符合他们的需求，那对你来说就是一个廉价渠道。你不一定非要打广告。当你去 Reddit 设置关键词追踪，观察人们什么时候问特定问题时，你不需要付钱。你只是看到：“哦，有人有这个问题，我有答案，给你。”与他们建立联系需要时间，但在早期，这些正是我们大量投入的地方。

---

### (00:08:21) Meltem Kuran Berkowitz

**English:**
And I think a lot of people jump that because they think, "Oh, it's one person here, two people there." But when you start helping people, that combined with word of mouth, and guess what, these are digital places, you provide one answer and your answer lives out there for other people to repeatedly refine. As long as we're not talking about a closed Slack community, maybe a conversation happening in DMs. So when I think about cheap channels, I think about where are people asking the questions, that might be Google or that might be Reddit or any other channel, and providing them the answers, so they know that your solution exists.

**中文翻译:**
我觉得很多人会跳过这一步，因为他们觉得：“哦，这儿才一个人，那儿才两个人。”但当你开始帮助别人，再加上口碑传播，而且别忘了，这些是数字空间，你提供一个答案，这个答案就会一直存在，供其他人反复参考。只要不是封闭的 Slack 社区或私信对话。所以当我想到廉价渠道时，我会想人们在哪里提问——可能是 Google，可能是 Reddit 或任何其他渠道——然后为他们提供答案，让他们知道你的解决方案存在。

---

### (00:08:59) Lenny

**English:**
Okay, this is awesome. So this Reddit example is that, which you actually did, you set alerts for when people have questions about HR hiring internationally I imagine, and then had someone go in there and give them some advice?

**中文翻译:**
太棒了。所以那个 Reddit 的例子就是你实际做的：你设置了提醒，当有人问关于国际 HR 招聘的问题时，你就派人进去给他们一些建议？

---

### (00:09:10) Meltem Kuran Berkowitz

**English:**
Yes, exactly that's what we did.

**中文翻译:**
是的，这正是我们所做的。

---

### (00:09:12) Lenny

**English:**
Wow, I love that.

**中文翻译:**
哇，我喜欢这个。

---

### (00:09:12) Meltem Kuran Berkowitz

**English:**
It's important to notice that if you're looking at a subreddit of about a thousand people, recognize the upper size of this audience, you're not going to win 5,000 businesses through that Reddit community, but you're maybe going to win 10% of the people there that are having this problem. So it's very important when investing in these cheap channels to focus on what's the upper limit of the audience size.

**中文翻译:**
需要注意的是，如果你关注的是一个大约有 1000 人的子版块（subreddit），要意识到这个受众的上限。你不可能通过那个 Reddit 社区赢得 5000 家企业，但你可能会赢得那里 10% 有这个问题的人。所以，在投资这些廉价渠道时，关注受众规模的上限非常重要。

---

### (00:09:36) Meltem Kuran Berkowitz

**English:**
And also I see a lot of people sometimes go blindly into SEO. They're like, "We're just going to write content," which I'm a huge fan of SEO, happy to discuss that later, but if people aren't asking this question to Google, you can write all the content you want, it doesn't matter, nobody's going to find it.

**中文翻译:**
而且我也看到很多人盲目地去做 SEO。他们会说：“我们只要写内容就行了。”我是 SEO 的忠实粉丝，稍后很乐意讨论这个，但如果人们根本不在 Google 上问这个问题，你写再多内容也没用，没人会找到它。

---

### (00:09:52) Lenny

**English:**
I love this so much, because it connects with something I find again and again, is one of the more effective early growth channels is tapping into an existing community and piggybacking off of what they've already built. Airbnb is a little bit of an example where they went to Craigslist. Actually most people pull people off Craigslist, Uber pull people off Craigslist, Lyft, so many companies just piggybacked off Craigslist and built up their own company.

**中文翻译:**
我非常喜欢这一点，因为它契合了我反复发现的一个规律：最有效的早期增长渠道之一就是挖掘现有社区，并利用（piggybacking）他们已经建立好的基础。Airbnb 就是一个例子，他们利用了 Craigslist。实际上大多数公司都从 Craigslist 拉人，Uber、Lyft，这么多公司都是借势 Craigslist 建立起自己的公司的。

---

### (00:10:13) Lenny

**English:**
But what you said is so important, which is you can't just go into a community and be like, "Hey, everyone, check out what I've got." You need to add value to people and add value to the community, otherwise no one's going to pay attention to you, they're going to kick you out.

**中文翻译:**
但你说的非常重要：你不能直接冲进一个社区说：“嘿，大家快看我有什么。”你需要为人们提供价值，为社区提供价值，否则没人会理你，他们会把你踢出去。

---

### (00:10:25) Meltem Kuran Berkowitz

**English:**
Exactly.

**中文翻译:**
没错。

---

### (00:10:25) Lenny

**English:**
And so I think that is a really important insight is if you're trying to say piggyback off of a community, the most important thing is you need to add value to the community.

**中文翻译:**
所以我认为这是一个非常重要的洞察：如果你想借势一个社区，最重要的事情是你必须为该社区创造价值。

---

### (00:10:34) Meltem Kuran Berkowitz

**English:**
Yeah, be someone people actually want to talk to.

**中文翻译:**
是的，要做一个人们真正想与之交谈的人。

---

### (00:10:37) Lenny

**English:**
I love that. Is there a tool that you found for that Reddit strategy of just how to know if someone's talking about hiring say internationally?

**中文翻译:**
太棒了。关于那个 Reddit 策略，有没有什么工具可以让你知道是否有人在讨论比如国际招聘？

---

### (00:10:45) Meltem Kuran Berkowitz

**English:**
I did a very janky assistant setup, I'm not proud of it, but it works. Someone else out there built it and I just plugged in the keywords we were looking for into it.

**中文翻译:**
我搞了一个非常简陋的助手设置，虽然不怎么高大上，但挺管用。是别人开发的，我只是把我们要找的关键词填了进去。

---

### (00:10:57) Lenny

**English:**
I know it wasn't just Reddit, and I'm curious what else you found was worth your time, but how did you figure out that's where your potential community and potential users were spending time?

**中文翻译:**
我知道不只是 Reddit，我很想知道你还发现哪些地方值得投入时间，但你是如何确定那是你的潜在社区和潜在用户聚集的地方的？

---

### (00:11:06) Meltem Kuran Berkowitz

**English:**
Well, I think over time Reddit became the place that you go to when you want peer answers, whether that peer is someone right next to you or someone halfway across the world. So it was a very obvious place for me to go to understand, what's top of mind for my audience? But also there are so many subreddits, whether it's founders or HR managers, that people are just asking their community. Because oftentimes they have very specific questions. You can't just ask that to Google because they have one thing that means that they might not be able to qualify for the exact solution that is what's most used out there. So Reddit just became the place over the years for people to ask their specific questions semi-anonymously and get answers from their community, and multiple answers to be able to judge which works better versus didn't. So it was one of the first places that myself and my team went to.

**中文翻译:**
嗯，我认为随着时间的推移，Reddit 成了你想寻求同行答案时的首选之地，无论那个同行就在你身边还是在半个地球之外。所以对我来说，去那里了解受众最关心什么是非常显而易见的。此外，还有很多子版块，无论是创始人还是 HR 经理，人们都在向他们的社区提问。因为通常他们的问题非常具体。你不能直接问 Google，因为他们可能有一个特殊情况，导致他们无法适用市面上最通用的解决方案。所以多年来，Reddit 成了人们半匿名地提出具体问题并从社区获得答案的地方，而且能得到多个答案，从而判断哪个更有效。所以那是我和我的团队最早去的地方之一。

---

### (00:11:58) Lenny

**English:**
And is this something that worked really well, mostly at the beginning to kickstart growth or how early was this? And then how much of your growth would you say came from this sort of strategy early on?

**中文翻译:**
这种方法是主要在初期启动增长时非常有效吗？那是多早的时候？你觉得早期有多少增长是来自于这种策略？

---

### (00:12:07) Meltem Kuran Berkowitz

**English:**
I believe I set up that little keyword tracking within the first day of me starting my role at Deel. So it was very, very early. And we still do this by the way. We still provide answers across Reddit, Quora communities. We're still out there connecting with people. Over time, of course, it went from maybe being 15% of our funnel to less than 5% of our funnel because the rest of our funnel has grown a lot. But the next number of people that we get to share our solution with through those channels have continued to grow over time.

**中文翻译:**
我记得在我入职 Deel 的第一天就设置了那个关键词追踪。所以是非常、非常早的。顺便说一下，我们现在还在做这件事。我们仍然在 Reddit、Quora 社区提供答案。我们仍然在外面与人们建立联系。当然，随着时间的推移，它从占我们漏斗的 15% 降到了不到 5%，因为我们漏斗的其他部分增长了很多。但通过这些渠道分享我们解决方案的人数绝对值一直在增长。

---

### (00:12:43) Lenny

**English:**
Coming back to something I asked that I want to touch on is, in today's world are there any cheaper growth channels that you are excited about? Or is it essentially the same idea? Look for where your potential users are and ideally asking questions that you could help answer? Is that roughly how you think about it still?

**中文翻译:**
回到我之前想探讨的一个问题：在当今世界，有没有哪些让你感到兴奋的廉价增长渠道？还是说本质上还是同样的思路：寻找潜在用户聚集的地方，最好是他们在提问而你可以帮忙回答的地方？你现在大致还是这么想的吗？

---

### (00:12:58) Meltem Kuran Berkowitz

**English:**
That is still roughly how I think about it. I would add social channels to that as well. I think Twitter's a great place, people ask questions oftentimes, so there are communities. And when someone has answered that question, other people piggyback off of that. But anywhere where someone is asking a question, I would consider to fall into this category of a cheap channel.

**中文翻译:**
大致还是这样。我还会把社交渠道也加进去。我认为 Twitter 是个好地方，人们经常提问，那里有很多社区。当有人回答了那个问题，其他人也会借此关注。总之，任何有人提问的地方，我都认为属于廉价渠道这一类。

---

### (00:13:17) Lenny

**English:**
What's an example of answering a question in a value-add way versus a maybe less effective way in your experience?

**中文翻译:**
根据你的经验，以“增加价值”的方式回答问题和以“不太有效”的方式回答问题，分别是什么样的例子？

---

### (00:13:25) Meltem Kuran Berkowitz

**English:**
I would say the least effective way would be, "Hey, we've solved that problem, check out our website." Okay, cool, if you have five seconds, do that. But the value-add way would be explaining what the solution to that problem is. Because the reality is there are a lot of people out there who can probably solve this, and then providing your solution, but answer their question first, and then let them decide if they want to come with you or go with someone else. But the whole point of someone asking a question isn't to be sold a solution. It's like, "I just need an answer." So genuinely treat this person like a friend of yours, answer their question, be like, "Yes, it's doable. No, it's not doable. Yes, you can do it, but you need to consider X, Y, Z. If you want to learn more about it, you can chat with us."

**中文翻译:**
我会说最无效的方式是：“嘿，我们解决了那个问题，去看看我们的网站吧。”好吧，如果你只有五秒钟，那就这么干。但增加价值的方式是解释那个问题的解决方案是什么。因为现实中可能有很多其他人也能解决这个问题。先回答他们的问题，然后提供你的方案，让他们自己决定是选你还是选别人。别人提问的初衷不是为了被推销方案，而是“我只需要一个答案”。所以，真心实意地把这个人当成你的朋友，回答他们的问题，比如：“是的，这可行。不，这不可行。是的，你可以做，但你需要考虑 X、Y、Z。如果你想了解更多，可以和我们聊聊。”

---

### (00:14:04) Lenny

**English:**
And these were people on the team or you answering these questions, it wasn't some automated system?

**中文翻译:**
这些是团队成员或你本人在回答问题，而不是某种自动化系统？

---

### (00:14:09) Meltem Kuran Berkowitz

**English:**
It was never automated. It still isn't today. We would never automate our interactions with people. So early days, it was myself, the other people on my team, our co-founders, which to this day they still do by the way. So it's a lot of people on the team. Every single person on the team has access to these. And whoever is the first person to jump in will flag it. And sometimes you'll see on a Twitter, someone will write a question, there's three people from Deel team has answered. We're like, "Okay, I think enough of us have provided value here."

**中文翻译:**
从来不是自动化的。今天也不是。我们永远不会自动化与人的互动。早期是我自己、团队里的其他人，还有我们的联合创始人——顺便说一下，他们至今还在做这件事。所以团队里有很多人参与。团队里的每一个人都有权限访问这些。谁第一个跳进去回答就会标记一下。有时你会看到在 Twitter 上，有人发了个问题，Deel 团队有三个人都回答了。我们会说：“好吧，我觉得我们提供的价值已经够多了。”

---

### (00:14:41) Lenny

**English:**
That's amazing. And I'm spending a lot of time on this, but this is such an interesting and important tactic that clearly worked to help you all start and it's cheap. And most, at least B2B, companies could probably leverage this. So when people are thinking about where to go, maybe do this, you mentioned Twitter, maybe Reddit, maybe Quora. Is there anything else, just like the sphere of potential places founders can go think about whether maybe people are asking questions they could answer there?

**中文翻译:**
太棒了。虽然我在这上面花了不少时间，但这是一个非常有趣且重要的战术，显然它帮助你们启动了增长，而且成本很低。大多数公司，至少是 B2B 公司，可能都可以利用这一点。所以当人们思考去哪里做这件事时，你提到了 Twitter、Reddit、Quora。还有其他潜在的地方吗？创始人可以去思考人们是否在那里提问？

---

### (00:15:06) Meltem Kuran Berkowitz

**English:**
Yeah, there are a lot of closed communities, so there are still ... they could be Slack communities, Discord, places that founders choose to connect with other founders. Or we have partnerships with places like the Y Combinator, where once you go through a certain program or you qualify to be in the club, whatever that club may be, you get to get access to this community where you can talk to other people. So those are considered closed communities. It's not as easy to gain access to. But if you can find a way to gain access to those communities, they're also great places to be.

**中文翻译:**
是的，有很多封闭社区，比如 Slack 社区、Discord，这些是创始人选择与其他创始人联系的地方。或者我们与 Y Combinator 等机构有合作，一旦你通过了某个项目或有资格进入某个“俱乐部”，你就能进入这个社区与其他人交流。这些被认为是封闭社区，进入门槛较高。但如果你能找到进入这些社区的方法，它们也是非常棒的地方。

---

### (00:15:37) Lenny

**English:**
And then step number one is add value, right?

**中文翻译:**
然后第一步就是增加价值，对吧？

---

### (00:15:40) Meltem Kuran Berkowitz

**English:**
Yes.

**中文翻译:**
是的。

---

### (00:15:40) Lenny

**English:**
You can't just get in the community, "Hey, check out Deel everyone."

**中文翻译:**
你不能一进社区就喊：“嘿，大家快来看看 Deel。”

---

### (00:15:42) Meltem Kuran Berkowitz

**English:**
Otherwise you'll just get kicked out. You can try not adding value, you're not going to last very long.

**中文翻译:**
否则你会被踢出去的。你可以尝试不提供价值，但你待不了多久。

---

### (00:15:47) Lenny

**English:**
Yeah. If you think about the pie chart of how growth happened at Deel early on and then today, what would that roughly look like? What percentage of early growth came through this versus SEO or whatever else worked, and then today? Whatever you can share of where growth comes from.

**中文翻译:**
是的。如果你回想一下 Deel 早期和现在的增长构成饼图，大致会是什么样子？早期增长有多少比例来自这种方式，对比 SEO 或其他有效手段？现在又是怎样的？只要是你愿意分享的增长来源都可以。

---

### (00:16:03) Meltem Kuran Berkowitz

**English:**
Today, roughly about I would say 50% of our growth continues to come from what we would consider non-paid channels, through whether it be partnerships, SEO, these kinds of moderations. So early on that was more close to 80% to 90%. But that number has grown. Again, the net number has grown, but the percentage of the overall value has shrunk because other channels have also grown significantly.

**中文翻译:**
今天，我想说大约 50% 的增长仍然来自我们认为的非付费渠道，包括合作伙伴关系、SEO 以及这类社区互动。早期这个比例更接近 80% 到 90%。但这个数字（绝对值）是在增长的。再次强调，净增长人数增加了，但占总价值的百分比缩小了，因为其他渠道也增长得非常显著。

---

### (00:16:29) Lenny

**English:**
Awesome. Okay. So let's talk about SEO. First of all, how important has that been to the success and growth of Deel? And then also just what have you learned about what is important to get SEO right?

**中文翻译:**
太棒了。好，那我们聊聊 SEO。首先，SEO 对 Deel 的成功和增长有多重要？其次，关于如何做好 SEO，你学到了哪些关键点？

---

### (00:16:40) Meltem Kuran Berkowitz

**English:**
Yeah. So I would say for SEO, the biggest mistake people make is they will just shove keywords. They're like, "Okay, these are the keywords people are searching for, I need to make sure I mention it five times." Obviously do that, make sure that the content that you wrote answers the question. But the main thing to think about it is, is the Google search over? If someone reads your content, if they typed in something to Google, and then they read the article that you've published, are they going back to Google to continue reading more or is the Google search over? Because ultimately that's what the search engines care about is, I want to make sure this person gets their answer quickest way possible.

**中文翻译:**
好的。对于 SEO，我认为人们犯的最大错误就是堆砌关键词。他们会想：“好吧，这些是人们正在搜索的关键词，我得确保提到五次。”当然要提到关键词，但要确保你写的内容回答了问题。最核心的一点是：Google 搜索结束了吗？如果有人在 Google 输入了内容，然后读了你发布的文章，他们是会回到 Google 继续搜索，还是搜索就此结束了？因为最终搜索引擎关心的是：我要确保这个人以最快的方式得到答案。

---

### (00:17:16) Meltem Kuran Berkowitz

**English:**
So when you think from that perspective, it's much easier to actually write things that people want to read, and you're not just meandering and going on and on, shoving a bunch of keywords that people are just like, "I'm bored, I'm bouncing, I'm going somewhere else."

**中文翻译:**
所以当你从这个角度思考时，就更容易写出人们真正想读的东西，而不是漫无边际地闲扯，堆砌一堆让人们觉得“好无聊，我要关掉页面去别处”的关键词。

---

### (00:17:30) Meltem Kuran Berkowitz

**English:**
So asking that question of, is the search over is a really good place to start, instead of just shoving keywords. And our content team is amazing. I would say they're more of an operational team than they are a creative team. The way they run things, the way they publish the articles, there's a very clear framework that is used to decide what gets published when and what doesn't get published by the same token. So all of those things are very important to consider, instead of just being like, "Oh, this keyword has 10,000 monthly visitors, I'm just going to write a bunch of things about that."

**中文翻译:**
所以，问出“搜索结束了吗”这个问题是一个很好的起点，而不是仅仅堆砌关键词。我们的内容团队非常出色。我想说他们更像是一个运营团队，而不是创意团队。他们运作的方式、发布文章的方式，都有一个非常清晰的框架，用来决定什么时候发布什么，以及同样重要的——不发布什么。所有这些因素都非常重要，而不是仅仅想：“哦，这个关键词每月有 1 万访客，我就随便写点相关的。”

---

### (00:18:02) Lenny

**English:**
What's an example of a page that you wrote that ends people search and gives them what they need?

**中文翻译:**
能不能举个例子，哪一页内容是你们写的，能够终结人们的搜索并提供他们所需的东西？

---

### (00:18:07) Meltem Kuran Berkowitz

**English:**
A lot of people wonder what an EOR is because that's an employer of record. They tend to be confused about exactly what that is. So we do very well in explaining to people what EOR is and isn't and what its limitations are. Because the first question that you will have after the EOR question's answered is, okay, what's the downside? When do I need to not use it? So for us, that's one of the content pieces that does very well.

**中文翻译:**
很多人想知道什么是 EOR（Employer of Record，名义雇主）。他们往往对这到底是什么感到困惑。所以我们在向人们解释什么是 EOR、什么不是 EOR 以及它的局限性方面做得非常好。因为在 EOR 的问题得到回答后，你紧接着会问：好吧，缺点是什么？什么时候我不应该使用它？所以对我们来说，这是表现非常出色的内容之一。

---

### (00:18:32) Lenny

**English:**
I'd love to spend more time on this operational element of the SEO team. Maybe one question is just what is that bar that tells you that it's ready to publish and worth going out versus it's not ready?

**中文翻译:**
我很想多花点时间聊聊 SEO 团队的这个运营要素。也许一个问题是：判断内容“准备好发布且值得发布”与“还没准备好”的标准是什么？

---

### (00:18:42) Meltem Kuran Berkowitz

**English:**
Yes. So I can't take credit to this, this is all of our team's work. But we have this framework that we call the traffic light system. Essentially we go, whenever the team is going to do a content series, they will go and find up to 700 keywords. These are keywords that are related to what we do. So they might be closely related, they might be distant related. And then those set of keywords get ranked by highest volume to the lowest volume. So then you have an Excel sheet, keywords on the left, volume on the right. And then you go one by one. This does take time. And then say, what is the intent of someone searching this keyword?

**中文翻译:**
是的。我不能把功劳归于自己，这都是我们团队的工作。我们有一个框架，称之为“红绿灯系统”。基本上，每当团队要做一个内容系列时，他们会去找多达 700 个关键词。这些是与我们业务相关的关键词，可能是紧密相关的，也可能是间接相关的。然后，这些关键词会按搜索量从高到低排序。这样你就得到了一个 Excel 表格，左边是关键词，右边是搜索量。然后你一个一个去分析。这确实需要时间。然后问：某人搜索这个关键词的意图（intent）是什么？

---

### (00:19:22) Meltem Kuran Berkowitz

**English:**
Is this a university student looking to write an article and they're never going to become our customer? Or is this someone that is actually looking to solve their existing solution and they are going to become our customer? So with that, you get the green light ones, which is the intent is very high, this person wants our solution. The yellow light is intent, could be they are a 50:50, maybe they're looking to buy our solution, maybe it's not soon enough. And then the red is, this person is not looking to buy our solution, they're just doing this search for any other reason. So when you do that, then you go from the greens, highest volume to the lowest volume, yellows, highest volume to the lowest volume, and oftentimes you never get to the reds.

**中文翻译:**
这是一个想写论文、永远不会成为我们客户的大学生吗？还是一个真正想解决现有问题、即将成为我们客户的人？基于此，你会得到“绿灯”关键词，即意图非常高，这个人想要我们的解决方案。“黄灯”是意图一半一半，也许他们想买，但还没到时候。而“红灯”则是，这个人根本不想买我们的方案，他们搜索只是出于其他原因。当你完成这些后，你就从绿灯中搜索量最高的开始写，一直到最低，然后是黄灯，通常你根本不需要去写红灯关键词。

---

### (00:20:03) Lenny

**English:**
I love that. And then once you have say a keyword, say a green, I guess, it's a green keyword where it's high intent and high volume, what is the process to actually put together an article that works for SEO?

**中文翻译:**
我喜欢这个。一旦你确定了一个关键词，比如一个“绿灯”关键词，意图高且搜索量大，那么实际撰写一篇符合 SEO 要求的文章的过程是怎样的？

---

### (00:20:16) Meltem Kuran Berkowitz

**English:**
So step one is understanding the search intent. Why is someone typing that? What are they trying to understand? And a part of that is going to Google and figuring out, what is Google servicing today? So one of the examples that I always give people of when you type EOR into Google, it doesn't give you employer of record, it gives you enhanced oil recovery, because most of the people typing EOR to Google is looking for that solution.

**中文翻译:**
第一步是理解搜索意图。为什么有人输入这个词？他们想了解什么？其中一部分工作是去 Google 看看，Google 目前提供的是什么结果？我经常举的一个例子是，当你在 Google 输入 EOR 时，它给你的不是“名义雇主”（Employer of Record），而是“提高石油采收率”（Enhanced Oil Recovery），因为大多数在 Google 上搜 EOR 的人找的是那个方案。

---

### (00:20:43) Meltem Kuran Berkowitz

**English:**
Now, if my team blindly went in and said, "We're going to rank for EOR," we're never going to rank for that because that's not what Google gives people because that's not what people have been looking for. So first is understanding, what are people looking for? And creating a content piece that answers those questions. Oftentimes the bottom part of Google where it says, the next questions that you should be asking is a really good place to go to understand, okay, after someone's done with this search, what's the next question that they ask? And the next one and the next one.

**中文翻译:**
如果我的团队盲目冲进去说“我们要争夺 EOR 的排名”，我们永远排不上去，因为那不是 Google 给人们的结果，也不是人们一直在找的东西。所以首先要理解：人们在找什么？然后创作一篇回答这些问题的文章。通常 Google 底部显示的“相关搜索”或“人们还会问”是了解后续问题的好地方：在某人完成这次搜索后，他们下一个会问什么？再下一个呢？

---

### (00:21:11) Meltem Kuran Berkowitz

**English:**
So figuring out what do people want to get out of this? And then there are a myriad of SEO solutions tools that you can use out there to ensure that the content you've written is in a simple enough language that someone with a fifth grade reading level can understand. That you actually did the right things, you put the right keywords in the right places. I almost think of keywords as like, that's your address, that's how you give Google, please send people my way. So you can use many tools.

**中文翻译:**
所以要弄清楚人们想从中得到什么。然后，市面上有很多 SEO 工具可以确保你写的内容语言足够简单，让具有五年级阅读水平的人也能理解。确保你做对了，把正确的关键词放在了正确的位置。我几乎把关键词看作是你的“地址”，你通过它告诉 Google：“请把人引到我这里来。”你可以使用很多工具。

---

### (00:21:38) Meltem Kuran Berkowitz

**English:**
We use Clearscope, we love it. So those are the tools that you use. And then it gets published. And oftentimes those tools will give you a score to say you're an A plus or you're a C minus, you need to make your language less sophisticated, currently it's at university level and we need it to be at fourth grade reading level.

**中文翻译:**
我们使用 Clearscope，非常喜欢它。这些就是你使用的工具。然后内容发布。通常这些工具会给你一个评分，说你是 A+ 还是 C-，你是否需要让语言不那么深奥——比如目前是大学水平，而我们需要它达到四年级阅读水平。

---

### (00:21:55) Lenny

**English:**
What is the structure of the content team at this point, how many people is it, and what are their rough focuses?

**中文翻译:**
目前内容团队的结构是怎样的？有多少人？他们的大致重点是什么？

---

### (00:22:00) Meltem Kuran Berkowitz

**English:**
Fun fact about our content team, the person that leads it was one of the earliest employees at Deel, I want to say number two or three. So the person there is just so special to our entire company. And so the structure of the content team for us is, it is led by our director of content. We have one person that is in charge of all of the operations. So that is working with our freelancers, making sure that the briefs are sent out, making sure that the fact checking is done on time, that the articles are published on the website, and tracking and everything, they run the machinery on the backend.

**中文翻译:**
关于我们内容团队的一个趣闻：领导这个团队的人是 Deel 最早的员工之一，我想说是第 2 或第 3 号员工。所以那个人对我们整个公司来说非常特别。我们内容团队的结构是：由内容总监领导。我们有一名负责所有运营的人员，负责与自由职业者合作，确保发出写作简报，确保按时完成事实核查，确保文章发布在网站上，并负责追踪等所有工作——他们运行着后端的机器。

---

### (00:22:33) Meltem Kuran Berkowitz

**English:**
And then we have different people focused on different areas of content because you need to have expertise that you build over time to write properly. So we have one person looking after certain product lines, another person would be focusing on [inaudible 00:22:46] behind different product lines. And very recently we've set out a team for different types of content because content isn't just written article, it's also video, it's also education. There's a lot of different types of content that we want to tap into. So now there's a team that is focused on those new mediums for us.

**中文翻译:**
然后我们有不同的人专注于不同的内容领域，因为你需要随着时间的推移建立专业知识才能写得专业。所以我们有一名人员负责某些产品线，另一名人员专注于不同产品线背后的内容。最近，我们还成立了一个针对不同类型内容的团队，因为内容不仅仅是文章，还有视频、教育内容。有很多不同类型的内容我们想要挖掘。所以现在有一个团队专门负责这些新媒介。

---

### (00:23:04) Lenny

**English:**
How many people total full-time that run this operation?

**中文翻译:**
总共有多少全职人员在运行这个体系？

---

### (00:23:08) Meltem Kuran Berkowitz

**English:**
Right now the team is about eight people total.

**中文翻译:**
目前整个团队大约有八个人。

---

### (00:23:11) Lenny

**English:**
And it's like, I don't know if it's exactly 50% of it, something like half of your growth essentially is coming from this team?

**中文翻译:**
所以，我不确定是否正好是 50%，但基本上你们增长的一半左右是来自这个团队？

---

### (00:23:17) Meltem Kuran Berkowitz

**English:**
Yes.

**中文翻译:**
是的。

---

### (00:23:18) Lenny

**English:**
Is there anything else you found that it's really important or effective for thinking about making SEO work?

**中文翻译:**
关于如何让 SEO 奏效，你还发现有哪些非常重要或有效的思考点吗？

---

### (00:23:23) Meltem Kuran Berkowitz

**English:**
The biggest mistake people make is SEO is one of those things that, you can try and automate it, you can do a lot of things that save you time, but it never stops being time-consuming. And to do it well, it is going to be time-consuming. So oftentimes people just get over it or they think it's below them to be going over and doing keyword research and doing all of those things one by one. And that's oftentimes where people lose out is they try to cut corners. And when you cut corners, you just don't create a good quality resource. That's what it comes down to. It's like, is your resource good quality? Yes or no?

**中文翻译:**
人们犯的最大错误是：SEO 这种事，你可以尝试自动化，可以做很多节省时间的事，但它永远都是耗时的。要做好它，必然要花时间。所以通常人们会觉得厌烦，或者觉得亲自去做关键词研究、一个一个处理这些事情“掉价”。这往往就是人们失败的地方——他们试图走捷径。而当你走捷径时，你就无法创造出高质量的资源。归根结底就是：你的资源质量好吗？是还是不是？

---

### (00:23:55) Meltem Kuran Berkowitz

**English:**
So when you try to just be like, I want to rank and cut all those corners, your content is not going to be great. Nobody's going to want to read it. And your program is not going to go anywhere. So I think it's one of those things that people as they become more senior think it's below them. And I think that's the biggest mistake.

**中文翻译:**
所以当你只想“我要排名”并走所有捷径时，你的内容不会太好。没人想读它。你的项目也不会有任何进展。我认为这是那种随着人们资历变深，会觉得“不屑于做”的事情。我认为那是最大的错误。

---

### (00:24:11) Lenny

**English:**
It's interesting, and that's exactly the same advice for writing a newsletter, the thing I do. Where if a newsletter isn't working, it usually means the content isn't valuable enough to people. It's such a clear meritocracy of, if it's useful, people will read it, subscribe, share. And if they're not, they won't subscribe. And then Google basically figures that out based on people's behavior.

**中文翻译:**
很有趣，这和我写 newsletter（时事通讯）的建议完全一样。如果一份 newsletter 不起作用，通常意味着内容对人们来说不够有价值。这是一个非常清晰的精英管理模式：如果它有用，人们就会阅读、订阅、分享。如果没用，他们就不会订阅。而 Google 基本上就是根据人们的行为来判断这一点的。

---

### (00:24:30) Meltem Kuran Berkowitz

**English:**
Yes, exactly.

**中文翻译:**
是的，没错。

---

### (00:24:31) Lenny

**English:**
To give people a sense of the operation, how many articles are you putting out a month, a day, a week, whatever you can share there?

**中文翻译:**
为了让大家对这个运营规模有个概念，你们一个月、一天或一周发布多少篇文章？

---

### (00:24:38) Meltem Kuran Berkowitz

**English:**
We used to put out about 10 articles a week, that's net new. Whereas now we are doing more of five new articles and five article updates. Because the type of content we write, regulations change, things change all the time, so we need to make sure that even if something was published two years ago, it's up-to-date. So we have a team that is responsible for continuously fact checking. So we do about five article updates and five net new articles written. And of course we do it across many different languages. So what started off as English only operations is now in other languages as well. So there's no shortage of work to go around.

**中文翻译:**
我们过去每周发布大约 10 篇纯原创文章。而现在我们更多是做 5 篇新文章和 5 篇旧文更新。因为我们写的内容涉及法规变化，情况一直在变，所以我们需要确保即使是两年前发布的文章也是最新的。我们有一个团队专门负责持续的事实核查。所以我们大约做 5 篇更新和 5 篇纯新文章。当然，我们是以多种语言进行的。最初只有英语运营，现在也涵盖了其他语言。所以工作量非常大。

---

### (00:25:15) Lenny

**English:**
Something that I go back and forth on a bit is, if SEO is something every company should be doing and will work for them? And in my experience, there's certain products that are really good for SEO, especially if there's user generated content or there's just a bunch of data like say Yelp or Glassdoor, where they can generate tons of pages in all these different ways. Do you have an opinion on what sort of business and company is best suited for SEO? Or is your feeling everyone should probably be doing SEO in some form? And even if it's not a huge part of your growth strategy, it'll help.

**中文翻译:**
我一直在思考一个问题：SEO 是否是每家公司都应该做且都会奏效的事情？根据我的经验，某些产品非常适合 SEO，特别是如果有用户生成内容（UGC）或者有大量数据，比如 Yelp 或 Glassdoor，它们可以通过各种方式生成海量页面。你对什么样的业务和公司最适合做 SEO 有什么看法吗？还是你觉得每个人都应该以某种形式做 SEO？即使它不是增长战略的重要组成部分，也会有所帮助。

---

### (00:25:47) Meltem Kuran Berkowitz

**English:**
I don't think everybody should be doing SEO. I think if you are in a space where people are looking for a solution, you should be doing SEO. But if you are a direct to consumer company selling people lipstick, which I'm a huge buyer of, you probably shouldn't invest in SEO all that much because people don't go to Google for that. They go to Instagram, they go to influencers. And even if someone types in the best lipstick of 2023, chances of your website ranking, because you're not a third party objective comparing to other people, is very low. So it really depends on the solution. But if you are in a space which most B2B products tend to be, that you're solving an active problem very specifically, then I would say SEO is a good idea. If you're a consumer good, maybe a little bit less effort should be put towards it.

**中文翻译:**
我不认为每个人都应该做 SEO。我认为如果你处于一个人们正在寻找解决方案的领域，你应该做 SEO。但如果你是一家直接面向消费者（DTC）的公司，卖的是口红（我是口红的大买家），你可能不应该在 SEO 上投入太多，因为人们不会为了买口红去搜 Google。他们会去 Instagram，看网红推荐。即使有人输入“2023 年最佳口红”，你的网站排在前面的机会也很小，因为你不是一个客观对比各家的第三方。所以这取决于解决方案。但如果你处于大多数 B2B 产品所在的领域，即你正在非常具体地解决一个现实问题，那么我会说 SEO 是个好主意。如果你是消费品，投入的精力也许可以少一点。

---

### (00:26:39) Lenny

**English:**
Makes a lot of sense. Going back to the early days, you were hired as head of growth at Deel, there's a lot of things you could do. I'm curious how you decided where to prioritize your resources and what to do in the early days? Versus what you started doing down the road and what you could almost not worry about early on? What have you learned about that early prioritization exercise?

**中文翻译:**
很有道理。回到早期，你被聘为 Deel 的增长负责人，当时有很多事情可以做。我很想知道你是如何决定资源优先级的？早期做了什么？后来又开始做什么？早期有哪些事是可以几乎不用担心的？关于早期的优先级排序，你学到了什么？

---

### (00:26:59) Meltem Kuran Berkowitz

**English:**
Yes. So I would say early days, it's very important to just go back to the basics, build the skeleton before you put on the makeup. So the first question I would ask is, do you have a website? Is it fast? Do the search engine knows that it exists? Okay, great. The next step would be, can people find it? If they can't find it, you need to write content to make sure that people can find it.

**中文翻译:**
是的。我会说在早期，回归基础非常重要，要在化妆前先搭好骨架。所以我问的第一个问题是：你有网站吗？快吗？搜索引擎知道它吗？好，太棒了。下一步是：人们能找到它吗？如果找不到，你需要写内容来确保人们能找到它。

---

### (00:27:24) Meltem Kuran Berkowitz

**English:**
Only after all of those questions are answered, should you then consider, do I have money? Can I put it behind some paid ads to make sure people come to my website? So going step-by-step. But you can't run a successful paid ads program if you have a website that's loading in four plus seconds. So really going back to the basics and starting from a good experience at the core. And then expanding step-by-step from there is how I would suggest everybody starts. And that's what I would do if I was to get hired all over again.

**中文翻译:**
只有在所有这些问题都得到回答后，你才应该考虑：我有钱吗？我能投付费广告让人们来我的网站吗？要循序渐进。如果你的网站加载需要四秒以上，你无法运行成功的付费广告项目。所以，真的要回归基础，从核心的良好体验开始，然后一步步扩展。这就是我建议每个人的开始方式。如果我重新被录用，我还是会这么做。

---

### (00:27:54) Lenny

**English:**
I love that. So what are some of the steps? So step one is, do you have a website? Step two is make sure the website performs and people can actually have a good time when they're experiencing it. I imagine part of it is also, do people understand what you do, like tweaking maybe the pitch and the [inaudible 00:28:07]

**中文翻译:**
我喜欢这个。那具体的步骤有哪些？第一步是有网站，第二步是确保网站性能良好，人们体验愉快。我猜其中一部分还包括：人们理解你是做什么的吗？比如调整你的推介语（pitch）……

---

### (00:28:06) Meltem Kuran Berkowitz

**English:**
Yes, exactly. And speaking of the pitch, our copy team does an amazing job at this. In the B2B world, it's very easy to come up with statements that could so easily be applied to another business and it would work just as well on their website. And it sounds good and you and your team feel really good about it. But then if your one-liner can also work for another business, please don't let that be your one-liner. Make it so that people actually understand what you do. Because right now there's a lot of statements out there like, 'we do the complex things so you can focus on what you do best', what does that mean? And you can give that to 90% of the B2B businesses out there and it would apply to them, which means it's not good enough.

**中文翻译:**
是的，没错。说到推介语，我们的文案团队做得非常棒。在 B2B 世界里，很容易想出一些陈词滥调，这些话放在另一家公司的网站上也同样适用。听起来不错，你和团队感觉也很好。但如果你的核心口号（one-liner）也能用在别的公司身上，请不要用它。要让人们真正理解你是做什么的。因为现在有很多类似“我们处理复杂事务，让你专注于你最擅长的事”这种话，这到底是什么意思？你可以把这句话给 90% 的 B2B 公司，都适用，这意味着它不够好。

---

### (00:28:51) Lenny

**English:**
Is there anything that you remember you changed in those early days in terms of the website or the positioning or anything along those lines that was a big improvement?

**中文翻译:**
你还记得早期在网站、定位或类似方面做了哪些改动，带来了巨大的提升吗？

---

### (00:28:57) Meltem Kuran Berkowitz

**English:**
Our website was hard coded, so the first thing we did with the help of the dev team was to move it to a platform that it was easy for me to access and edit, so that we could continuously A/B test things. And outside of that, we worked really hard on testing a lot of value propositions to explain to people exactly what we do, explain problem first, solution first, and time savings, cost savings, putting a lot of those against each other and rapidly A/B testing.

**中文翻译:**
我们的网站最初是硬编码的，所以我们在开发团队的帮助下做的第一件事就是把它迁移到一个我容易访问和编辑的平台，这样我们就可以持续进行 A/B 测试。除此之外，我们非常努力地测试了很多价值主张，向人们解释我们到底是做什么的——解释“问题优先”还是“方案优先”，或者是“节省时间”、“节省成本”，把这些点互相博弈，并进行快速的 A/B 测试。

---

### (00:29:24) Lenny

**English:**
Once you got past that phase, where maybe you started doing some paid ads and other things, where did you find you could invest more resources?

**中文翻译:**
一旦你过了那个阶段，开始做付费广告之类的，你发现可以在哪里投入更多资源？

---

### (00:29:32) Meltem Kuran Berkowitz

**English:**
Once we covered the basics of your big four or five ad platforms, we started looking into the long tail places. So those are the platforms that individually never contribute a significant enough chunk for you to individually care about it. But if you add them up, it diversifies your lead flow such that it ends up being about 30% of your overall lead flow that's coming in. Those could be things like review sites or much smaller outlets that could also run ads, newsletter ads, podcast ads, all of those things.

**中文翻译:**
一旦我们覆盖了四大或五大主流广告平台的基础，我们就开始研究“长尾”渠道。这些平台单独看可能贡献不大，不值得单独关注。但如果把它们加起来，它们会让你的线索流（lead flow）多样化，最终可能占到总线索量的 30% 左右。这些可能是评论网站，或者是可以投放广告的小型媒体、newsletter 广告、播客广告等等。

---

### (00:30:06) Meltem Kuran Berkowitz

**English:**
When you run an individual podcast ad, yeah, you're probably not going to get 2000 customers from one podcast. But you run 10 of those and then it starts adding up. So really long tail is where we focused on. And we started going very niche with websites that have maybe 50,000, a hundred thousand visitors a month, which isn't all that much when you're thinking about your paid ad strategy. But all of those places add up and they're oftentimes overlooked because they're not as easy, you have to take the time to set up from scratch to run it on everything. Our paid ads team, they spent just as much time running Facebook and Google ads as they do running those third party, much smaller platform ads. It takes the same effort, but you need to have a diversified source of your leads.

**中文翻译:**
当你投放一个单独的播客广告时，是的，你可能不会从一个播客获得 2000 个客户。但你投 10 个，数字就开始累加了。所以长尾渠道是我们关注的重点。我们开始进入非常垂直的领域，比如每月只有 5 万或 10 万访客的网站，这在考虑付费广告策略时可能不算多。但所有这些地方加起来就很可观，而且它们经常被忽视，因为它们不容易操作——你必须花时间从头开始设置。我们的付费广告团队在运行 Facebook 和 Google 广告上花的时间，和在这些第三方小型平台上花的时间一样多。付出的努力是一样的，但你需要多元化的线索来源。

---

### (00:30:54) Lenny

**English:**
Huge fan of podcast ads over here, and maybe this would be a good time to cue the mid-roll ad, maybe, I don't know, it happens.

**中文翻译:**
我可是播客广告的超级粉丝，也许现在是插入插播广告的好时机，也许吧，谁知道呢，顺其自然。

---

### (00:30:59) Meltem Kuran Berkowitz

**English:**
Sounds perfect.

**中文翻译:**
听起来很完美。

---

### (00:31:01) Lenny

**English:**
Here we go. Today's episode is brought to you by AssemblyAI. If you're looking to build AI powered features in your audio and video products, then you need to know about AssemblyAI, which makes it easy to transcribe and understand speech at scale. What I love about AssemblyAI is you can use their simple API to access the latest AI breakthroughs from top tier research labs. Product teams and startups and enterprises are using AssemblyAI to automatically transcribe and summarize phone calls and virtual meetings, detect topics in podcasts, pinpoint when sensitive content is spoken and lots more.

**中文翻译:**
来了。本期节目由 AssemblyAI 赞助。如果你想在音频和视频产品中构建 AI 驱动的功能，那么你需要了解 AssemblyAI，它能让你轻松地大规模转录和理解语音。我喜欢 AssemblyAI 的一点是，你可以通过他们简单的 API 访问顶级研究实验室的最新 AI 突破。产品团队、初创公司和企业都在使用 AssemblyAI 自动转录和总结电话及虚拟会议、检测播客主题、精准定位敏感内容等等。

---

### (00:31:36) Lenny

**English:**
All of AssemblyAI's models, which are accessed through their API, are production ready. So many PMs I know are considering or already building with AI and AssemblyAI is the fastest way to build with AI for audio use cases. Now is the time to check out AssemblyAI, which makes it easy to bring the highest accuracy transcription plus valuable insights to your customers, just like Spotify, CallRail and Writer do for theirs. Visit assemblyai.com/lenny to try their API for free and start testing their models with their no-code playground. That's assemblyai.com/lenny.

**中文翻译:**
AssemblyAI 所有通过 API 访问的模型都是生产就绪的。我认识的很多产品经理都在考虑或已经在使用 AI 进行构建，而 AssemblyAI 是在音频用例中构建 AI 的最快方式。现在是了解 AssemblyAI 的好时机，它能轻松为你的客户提供最高准确度的转录和有价值的洞察，就像 Spotify、CallRail 和 Writer 为他们的客户所做的那样。访问 assemblyai.com/lenny 免费试用他们的 API，并在他们的无代码游乐场中开始测试模型。

---

### (00:32:12) Lenny

**English:**
And welcome back. Speaking of podcast ads, something that I find is with that sort of advertising, there's a direct response component of like, we will drive leads as running an ad like this, and there's also a awareness, brand building component. I know you're not a big fan of awareness campaigns and marketing campaigns, especially early on, and so I'd love to get your perspective on why that is and how you think about that sort of investment?

**中文翻译:**
欢迎回来。说到播客广告，我发现这类广告既有直接响应的部分（比如投放广告带来线索），也有知名度和品牌建设的部分。我知道你不太喜欢知名度活动（awareness campaigns）和营销活动，特别是在早期，我很想听听你的看法，为什么会这样？你是如何看待这类投资的？

---

### (00:32:36) Meltem Kuran Berkowitz

**English:**
I'm not a huge fan of early awareness campaigns for B2B businesses specifically. So if you are a consumer goods founder, you can skip this part. But the reason I don't like awareness early on is because to do a proper awareness campaign, it takes time. You need to have teams that are doing the strategy, doing the creative work, and they don't always hit. You don't know if they're always going to resonate or not. And then you look back, and you've worked on this thing for a whole month and it hasn't resonated and you've wasted a full month.

**中文翻译:**
我确实不太喜欢 B2B 业务早期的知名度活动。如果你是消费品创始人，可以跳过这一段。我不喜欢早期做知名度的原因是，要做一个像样的知名度活动需要时间。你需要团队做战略、做创意，而且它们并不总是奏效。你不知道它们是否总能引起共鸣。然后你回过头看，你花了一个月时间做这件事，结果没引起共鸣，你就浪费了整整一个月。

---

### (00:33:07) Meltem Kuran Berkowitz

**English:**
Because B2B businesses uniquely are started because there's a very real need and there's a lot of people that are ready to convert, first tap into the bottom of the funnel, and then go out and start speaking to the masses. But I promise you it'll probably take you six to eight months minimum to tap into that bottom of the funnel of people that are ready to convert today before you have to start doing awareness ads out there. That's not to say never do awareness ads, but it's oftentimes the shiny, cool thing that you want to do and it just ends up being a waste of time early on. Because people don't really even understand what you're doing, you haven't really even figured out what's the messaging that resonates, but you've done this creative campaign and people are like, "This looks cool, but I'm just going to go ahead and continue looking for a solution for my problem."

**中文翻译:**
因为 B2B 业务的独特之处在于，它们的启动是因为存在真实的刚需，有很多人已经准备好转化了。你应该先挖掘漏斗底部（准备好转化的人），然后再去向大众喊话。我向你保证，在你需要开始做知名度广告之前，至少需要六到八个月的时间来挖掘那些今天就准备转化的漏斗底部人群。这并不是说永远不做知名度广告，但它通常是那种你想做的“闪闪发光、很酷”的事，结果在早期往往只是浪费时间。因为人们甚至还不理解你是做什么的，你甚至还没弄清楚什么样的信息能引起共鸣，你就做了一个创意活动，人们会觉得：“这看起来很酷，但我还是继续去找能解决我问题的方案吧。”

---

### (00:33:53) Lenny

**English:**
Is there an example of a marketing campaign or an awareness campaign that comes to mind that you thought was like, "Okay, this is ... if you do it this way, maybe it's worth doing"?

**中文翻译:**
有没有哪个营销活动或知名度活动让你觉得：“好吧，如果按这种方式做，也许是值得的”？

---

### (00:34:01) Meltem Kuran Berkowitz

**English:**
I've seen Notion do a great job with their out-of-home ads. They didn't do it early on, they started doing it much later in their journey by the time when everybody that was working in tech knew what it was, and it was really to drive home the message continuously rather than to introduce themselves to the world. So by then when you saw that layout on a billboard, it made sense, you're like, "Oh, I know what they're talking about."

**中文翻译:**
我看到 Notion 的户外广告（OOH）做得非常好。他们不是在早期做的，而是在发展的后期才开始做，那时候科技圈的每个人都知道 Notion 是什么了。那次活动更多是为了持续强化信息，而不是向世界介绍自己。所以到那时，当你在广告牌上看到那个布局时，它是合理的，你会想：“哦，我知道他们在说什么。”

---

### (00:34:23) Lenny

**English:**
So what is it about Notion that you think was great, it was timing and then also the actual ad itself you thought was great?

**中文翻译:**
所以你觉得 Notion 做得好的地方在于时机，还有广告本身也很棒？

---

### (00:34:30) Meltem Kuran Berkowitz

**English:**
Yeah, the ads that I'm recalling right now were showcasing their product interface. So they needed enough time, and this is my obviously hypothesis, if someone from Notion wants to jump in and say that wasn't the reason why we did this, go ahead, but I think they needed enough time for people to get familiar with the interface. Because Notion has a very specific interface that when you see it, you recognize it, it's not like any other product. So unless people built that awareness and recognition, doing an out-of-home ad with that layout wouldn't have made much sense because just with that layout they were able to communicate what product they're talking about. If they did that day one, people would be like, "What is this thing that I'm looking at?"

**中文翻译:**
是的，我记得那些广告展示的是他们的产品界面。他们需要足够的时间——这显然是我的假设，如果 Notion 的人想反驳说这不是原因，请便——但我认为他们需要足够的时间让人们熟悉界面。因为 Notion 有一个非常独特的界面，你一看就能认出来，它不像任何其他产品。所以，除非人们已经建立了这种认知和识别度，否则做一个展示那种布局的户外广告就没有太大意义。因为仅凭那个布局，他们就能传达出在谈论哪个产品。如果他们在第一天就这么做，人们会问：“我看到的这是个什么玩意儿？”

---

### (00:35:07) Lenny

**English:**
So we've been working through all the ways that Deel has grown, we've talked about SEO, community, you mentioned partnerships. Is there anything interesting there to mention around just what partnerships have done?

**中文翻译:**
我们已经梳理了 Deel 增长的所有方式，谈到了 SEO、社区，你还提到了合作伙伴关系。关于合作伙伴关系的作用，有什么有趣的可以分享吗？

---

### (00:35:18) Meltem Kuran Berkowitz

**English:**
Yeah, I would say it is very important to know who you should partner with. So there's two groups of partners. People oftentimes end up partnering with any company that has a shared audience. Decent place to start. But just because you share an audience doesn't mean your audience goes to your partner for guidance when they have this problem.

**中文翻译:**
是的，我想说知道该与谁合作非常重要。合作伙伴通常分为两类。人们往往最终会与任何拥有共同受众的公司合作。这是一个不错的起点。但仅仅因为你们拥有共同受众，并不意味着受众在遇到这个问题时会去向你的合作伙伴寻求指导。

---

### (00:35:35) Meltem Kuran Berkowitz

**English:**
So in our case, venture capital partners was a huge one because when you get money from a new VC, they ask, they're like, "Okay, thank you for giving us this money, now we want to expand our team with the money you gave us. What are your other portfolio companies using? What is a platform that you trust that you would recommend?" So people go to their VCs for that kind of question. But there might be another tech company out there that is tapping into the exact audience that we are, but people never go to them to ask that question. So our partnership with them will likely not work just as well. So it's important to not only recognize the importance of an audience overlap as well as whether or not those people are seen as a trusted resource for the solution you are putting out there.

**中文翻译:**
在我们的案例中，风险投资（VC）合作伙伴是一个巨大的渠道。因为当你从一家新 VC 那里拿到钱时，你会问：“好，谢谢你们给钱，现在我们要用这笔钱扩建团队。你们其他的被投公司都在用什么？你们信任并推荐哪个平台？”人们会去问 VC 这种问题。但可能还有另一家科技公司，虽然触达的受众和我们完全一样，但人们永远不会去问他们这个问题。所以我们与他们的合作可能效果不佳。因此，不仅要认识到受众重叠的重要性，还要看这些人是否被视为你所提供的解决方案的“可信资源”。

---

### (00:36:16) Lenny

**English:**
I really love this idea you keep coming back to, which is where are people asking this question that you can help them answer. And to make that even more concrete for people, what are some other examples maybe of questions people ask that Deel can help them with? So that it could help people think about, okay, maybe our product can help them answer these other sorts of questions

**中文翻译:**
我非常喜欢你一直强调的这个观点：人们在哪里提问，而你可以帮助回答。为了让大家更具体地理解，还有哪些人们会问、而 Deel 可以帮忙解决的问题例子？这可以帮助大家思考：也许我们的产品可以帮助回答其他类型的问题。

---

### (00:36:35) Meltem Kuran Berkowitz

**English:**
Since the early days, and it continues to happen, compliance is a huge question that gets asked. So when you are an HR leader or a finance leader or a legal leader in a company that works let's say in America, but you want to hire someone in another country, you don't know what you don't know. So it's very important to have people that know what they're talking about in context of your country of origin as well as the country that you're trying to hire from. So compliance has always been a huge part of what we did and what we've always answered for people. That's why we have in-house experts that answer those questions, that constantly provide updates if the answer to that question has changed over time, which regulations constantly change. An answer we provided a week ago may change, and you need to be very proactive in communicating that.

**中文翻译:**
从早期开始，并且现在依然如此，“合规性”是一个被问得最多的问题。当你是一家美国公司的 HR 负责人、财务负责人或法律负责人，但你想在另一个国家招人时，你“不知道自己不知道什么”。所以，拥有既懂你母国情况又懂目标招聘国情况的专家非常重要。合规性一直是我们工作的核心，也是我们一直在为人们解答的问题。这就是为什么我们有内部专家来回答这些问题，并且如果答案随时间发生了变化（法规经常变动），他们会不断提供更新。我们一周前提供的答案可能现在就变了，你需要非常主动地进行沟通。

---

### (00:37:18) Meltem Kuran Berkowitz

**English:**
Taxes is another one, especially in the space that we're in, payroll, hiring. Taxes change from country to country. You need to know when you need to pay what taxes, when you need to not pay them, and what types of work people do. So those are some of the types of questions that get asked.

**中文翻译:**
税务是另一个大问题，特别是在我们所处的薪酬和招聘领域。税收因国家而异。你需要知道什么时候该交什么税，什么时候不需要交，以及不同工作类型对应的税务。这些都是经常被问到的问题。

---

### (00:37:34) Meltem Kuran Berkowitz

**English:**
So for us, they're very nitty-gritty and use case specific. The taxes you need to pay for someone who is an engineer that's a full-time employee might be very different than who is a designer who is a contractor. So those are the kinds of specifics that we get into with people.

**中文翻译:**
所以对我们来说，这些问题非常琐碎且因具体情况而异。为一个全职工程师缴纳的税款，可能与为一个合同工设计师缴纳的税款完全不同。这些就是我们与人们深入探讨的细节。

---

### (00:37:50) Lenny

**English:**
Got it. So it's like, how do I pay taxes for an engineer I'm hiring in Turkey? And then you give them, "Here's the answer," and then it's like, "If you just want us to take care of it for you, then go check out Deel."

**中文翻译:**
明白了。所以就像是：“我如何在土耳其招聘一名工程师并交税？”然后你们给出答案，接着说：“如果你想让我们帮你搞定这一切，那就来看看 Deel 吧。”

---

### (00:37:59) Meltem Kuran Berkowitz

**English:**
Exactly. Rarely the question is what's the best payroll solution? It's like, okay, that's good to make sure what you're leaning towards isn't shit and that other people agree with you. But ultimately it was like you need the best payroll solution because you need to make sure that things aren't going to go wrong.

**中文翻译:**
没错。很少有人会直接问“什么是最好的薪酬解决方案？”问这个问题通常只是为了确认你倾向的选择不是垃圾，并且其他人也同意你的看法。但归根结底，你需要最好的薪酬方案是因为你需要确保事情不会出错。

---

### (00:38:15) Lenny

**English:**
Speaking of answering questions in content, something that you told me is that you wrote a blog post that the IRS ended up linking to as the definitive answer to a question. And I don't think this was at Deel, but can you share that story?

**中文翻译:**
说到在内容中回答问题，你曾告诉我你写过一篇博客文章，最后连美国国税局（IRS）都把它作为某个问题的权威答案进行了链接。我想这应该不是在 Deel 做的，你能分享一下那个故事吗？

---

### (00:38:28) Meltem Kuran Berkowitz

**English:**
Yes, actually it was at my previous role. And the person who wrote that article is today at Deel. So he came over to join us there too. But yes, it was right around when Covid happened and the US government rolled out the PPP program. And there was a lot of questions about, do I qualify? If I qualify, how do I apply for this?

**中文翻译:**
是的，那是在我上一份工作中。写那篇文章的人现在也在 Deel，他后来也加入我们了。那是新冠疫情刚爆发的时候，美国政府推出了 PPP（薪资保护计划）。当时有很多关于“我有资格吗？”、“如果有，我该如何申请？”的问题。

---

### (00:38:51) Meltem Kuran Berkowitz

**English:**
And at the time the company that I was working for had a lot of customers that were like, "What do I do? I need to gain access to this, but I don't know what to do." So the team there took the time to truly understand how the system works, whether you qualify, what to do. And created this resource for our own customers because we just wanted to help them. And then it ended up being such a good resource that it was linked from the IRS's website being like, "If you have questions, check out this article," which was a great moment of pride. And it just went to show that when you do your best to answer questions and other people don't have the time to do it, no matter who it is, they're going to send people back your way. And it was at the time, it happened to be a big moment of growth.

**中文翻译:**
当时我工作的公司有很多客户在问：“我该怎么办？我需要获得这个资助，但我不知道该怎么做。”于是团队花时间深入研究了系统如何运作、是否符合资格以及该做什么。我们为自己的客户创建了这个资源，初衷只是想帮助他们。结果它成了一个非常棒的资源，以至于 IRS 官网都链接了它，并写道：“如果你有疑问，请查看这篇文章。”那是一个非常自豪的时刻。这说明当你尽力回答问题，而其他人（无论那是谁）没时间去做时，他们就会把人引向你。在当时，那也成了一个巨大的增长契机。

---

### (00:39:33) Meltem Kuran Berkowitz

**English:**
It was a very unfortunate instance, we wish we never had to write that, that it never happened. But yeah, that was the story around IRS linking to the company's resource.

**中文翻译:**
那是一个非常不幸的时期，我们宁愿从未写过那篇文章，宁愿疫情从未发生。但没错，这就是 IRS 链接公司资源背后的故事。

---

### (00:39:44) Lenny

**English:**
That's the ultimate sign of the question is answered and you're done with it, the IRS decides to link to it. So you're saying that was actually a big driver of growth, IRS traffic. I'm curious how many people actually go read that?

**中文翻译:**
这是“问题已解决”的终极标志——IRS 决定链接它。所以你是说 IRS 的流量实际上是增长的一大驱动力。我很想知道到底有多少人去读了那篇文章？

---

### (00:39:57) Meltem Kuran Berkowitz

**English:**
So that was huge for that short duration of a few week time when people were trying to apply for PPP. And then it died out, as did PPP.

**中文翻译:**
在人们尝试申请 PPP 的那短短几周内，流量非常巨大。然后它就平息了，就像 PPP 计划本身一样。

---

### (00:40:05) Lenny

**English:**
Makes sense. One last question around paid, and then I want to move on to a different topic. Is there anything you've learned about what it takes to be successful at paid growth from your experience at Deel?

**中文翻译:**
明白了。关于付费广告最后一个问题，然后我想换个话题。根据你在 Deel 的经验，关于如何成功实现付费增长，你学到了什么？

---

### (00:40:15) Meltem Kuran Berkowitz

**English:**
Yeah, so a few things. Our paid team spends a lot of time on both the messaging aspect of things as well as the optimization. So optimization is the technical way in which you set your bids, make sure that you don't go over budget, whether or not you can afford that.

**中文翻译:**
好的，有几点。我们的付费团队在“信息传达”和“优化”两个方面都投入了大量时间。优化是指设置出价、确保不超预算、评估负担能力等技术手段。

---

### (00:40:31) Meltem Kuran Berkowitz

**English:**
And then messaging is making sure that if someone sees your ad, whether it's on Instagram, Twitter, Google, that it makes sense for them. So creative fatigue is a real thing. When you put an ad out there that works for three weeks, people get tired of seeing that, you need to constantly update that. So our paid team is actually updating the ads we put out there on a monthly basis with the exception of a few Google ads, which need to be straight to the point. So staying ahead of creative fatigue. Making sure that your messaging also keeps up with your product, even if the ad is working really well, you need to make sure that as your product has evolved, so has the messaging alongside that.

**中文翻译:**
而信息传达是确保当有人在 Instagram、Twitter 或 Google 上看到你的广告时，内容对他们是有意义的。此外，“创意疲劳”（creative fatigue）是真实存在的。当你投放一个广告，前三周效果很好，之后人们就会看腻，你需要不断更新。所以我们的付费团队实际上每月都会更新广告，除了少数需要直奔主题的 Google 搜索广告。所以要跑在创意疲劳前面。还要确保你的信息与产品同步，即使广告效果很好，如果产品进化了，信息也必须随之进化。

---

### (00:41:07) Meltem Kuran Berkowitz

**English:**
And also recognizing, not just looking at the amount of leads that you generated from a campaign, but how many of them actually became a client, and how much money did you actually make from those clients to understand things around payback. Because oftentimes marketers just tend to think about, "Oh, this is a great lead channel and I get so many leads from it." But then you ask that question to sales teams and they're like, "Yeah, I'm busy, but none of these are converting." So it's really important to look at not just the volume that you bring in, but what is the journey of that volume with your business one year out. How much money do you actually make from them to be able to properly decide how much can I spend to win this customer?

**中文翻译:**
还有一点是，不要只看一个活动产生了多少线索（leads），要看其中有多少真正成了客户，以及你从这些客户身上赚了多少钱，从而理解“回本周期”（payback）。因为营销人员往往只倾向于想：“哦，这是一个很棒的线索渠道，我得到了这么多线索。”但当你去问销售团队时，他们会说：“是的，我很忙，但这些都没转化。”所以，不仅要看带来的量，还要看这些量在一年后与你业务的关系。你到底从他们身上赚了多少钱，这样才能正确决定为了赢得这个客户我可以花多少钱。

---

### (00:41:44) Meltem Kuran Berkowitz

**English:**
The way that we've done it is we've worked with our data team to set up a dashboard that tracks that in real time. We know an average customer that comes from a Facebook ad, at what rate do they converge from a lead to a qualified opportunity to a closed on.? And then on average, how much money do we make from that customer one year out. So that we can decide, is this a worthy channel for us, do we not want to invest there or are we reaching that peak and we can't continue to invest there.

**中文翻译:**
我们的做法是与数据团队合作建立一个实时追踪仪表盘。我们知道一个来自 Facebook 广告的平均客户，从线索到合格机会再到成交的转化率是多少。以及平均而言，一年后我们能从该客户身上赚多少钱。这样我们就能决定：这是否是一个值得投入的渠道？我们是否不想在那里投资？或者我们是否已经达到了峰值，无法继续追加投资？

---

### (00:42:11) Lenny

**English:**
Something that I should mention as we talk through this is we're talking about all these ways to grow the product, but at the core is a great product that people actually find valuable and want to keep using. And maybe a question there is just how that plays into this whole growth strategy, actually making the product something people want versus all these acquisition channels?

**中文翻译:**
在讨论这些增长方式时，我应该提到一点：核心必须是一个人们真正觉得有价值并想持续使用的好产品。也许问题在于，在整个增长战略中，让产品成为人们想要的东西，与所有这些获客渠道之间是如何配合的？

---

### (00:42:29) Meltem Kuran Berkowitz

**English:**
Acquisition channels just straight up don't work if you have a product that doesn't live up to the expectation. I think I personally have been very spoiled and lucky because from the day I joined Deel, the product was top-notch. As I was joining an early stage company, I joined right after series A, I was expecting certain things to be duct taped in the back, it happens. And I was like, "Oh no, the engineers and the product team are, if they say a product can do something, it can do that and more."

**中文翻译:**
如果你的产品达不到预期，获客渠道根本不起作用。我觉得我个人一直被宠坏了，也很幸运，因为从我加入 Deel 的那天起，产品就是顶级的。当我加入这家早期公司时（我是 A 轮后加入的），我本以为后台会有很多“胶带粘补”的临时方案，这很常见。但我发现：“噢不，工程师和产品团队非常给力，如果他们说产品能做某事，它不仅能做，还能做得更多。”

---

### (00:42:59) Meltem Kuran Berkowitz

**English:**
So early days of my team pitching Deel was people were like, "I don't think you guys can do all of that. I don't believe you." And it was almost like we had to tamper down our messaging so that people would believe us. But you can be the best marketer in the world, if when people come to your product, even if your sales team does a good job at convincing them to become a customer, because you can do that, if the product doesn't live up to the expectations, especially in the B2B world where people aren't going to put up with crappy products, they're going to leave. That's going to get out and people are going to know it's not a worthy product. So that really sits at the core of everything that we do.

**中文翻译:**
早期我的团队推介 Deel 时，人们会说：“我不觉得你们能做到所有这些，我不信。”我们甚至不得不稍微收敛一下我们的宣传，好让人们相信我们。但你可以是世界上最好的营销人员，如果人们来到你的产品面前，即使销售团队成功说服他们成为客户，如果产品达不到预期，特别是在 B2B 领域，人们是不会忍受烂产品的，他们会离开。消息会传开，人们会知道这不是一个值得买的产品。所以产品真的是我们所做一切的核心。

---

### (00:43:35) Meltem Kuran Berkowitz

**English:**
I think it's very easy to take it for granted when you're at a company that has an awesome product, you're like, "It is like this all the time." But one of the things I would encourage anybody looking to join a young company is, ask them what their team breakdown looks like. When I joined Deel, most of the team was product and engineers. So that told me that the core of this business was going to be solid. And then we built out those supporting things like marketing, like sales, like data to surround the product. But if you are talking to an early stage company that's a B2B product and they have six salespeople and two engineers, their product probably isn't going to be great for that much longer.

**中文翻译:**
当你身处一家拥有出色产品的公司时，很容易觉得理所当然，认为“一直都是这样”。但我会建议任何想加入初创公司的人：问问他们的团队构成。当我加入 Deel 时，大部分团队成员是产品和工程师。这告诉我业务的核心会很稳固。然后我们建立了营销、销售、数据等支持性环节来围绕产品。但如果你在谈一家 B2B 初创公司，他们有 6 个销售和 2 个工程师，他们的产品可能撑不了多久。

---

### (00:44:12) Lenny

**English:**
Especially if it's an outsourced dev shop doing the product, they're like, "Oh, they'll take care of the product, we'll just sell it." Something else that I think is important to talk about is Covid was an important element of your growth. And so I guess, one, is that true? And then two, just what did you lean into and lean out of in terms of growth during Covid to help people discover Deel when they needed it most, which is basically people going remote in a lot of ways in a lot of companies?

**中文翻译:**
特别是如果产品是外包开发的，他们会觉得：“噢，他们会搞定产品，我们只管卖。”另一件我觉得很重要的事情是，新冠疫情是你们增长的一个重要因素。我想问，第一，这是真的吗？第二，在疫情期间，为了帮助人们在最需要的时候（即许多公司转向远程办公时）发现 Deel，你们在增长方面重点投入了什么，又避开了什么？

---

### (00:44:39) Meltem Kuran Berkowitz

**English:**
So Covid, actually a lot of people think Deel was started as a response to the pandemic, we actually got started before the pandemic and then the pandemic happened. So as sad as it was, it did force people into a pilot program of the vision that we had for the world. It forced people to work remotely, whether that means you're working remotely from someone who lives a block away from you or you are working remotely from someone in Germany. So we did benefit from the fact that everybody was at least forced to test out this hypothesis of, does it work to not be in the same room as the people that you're working with?

**中文翻译:**
关于疫情，实际上很多人认为 Deel 是为了应对大流行而成立的，但我们其实是在疫情之前就开始了，然后疫情才爆发。虽然疫情很令人悲伤，但它确实迫使人们进入了我们对世界愿景的“试点计划”。它迫使人们远程办公，无论这意味着你与住在一个街区外的人远程协作，还是与德国的人远程协作。所以我们确实受益于这样一个事实：每个人都至少被迫测试了这个假设——不与同事在同一个房间工作行得通吗？

---

### (00:45:17) Meltem Kuran Berkowitz

**English:**
And one of the questions that we were getting early on as the Covid was coming to an end was, "Are you worried, Covid is coming to an end, that people aren't going to use Deel anymore?" And our response to that has always been, we are not a remote work platform, we're a global work platform. So a lot of these businesses have gone back into offices. We have a lot of customers that asked people to go back to their offices, but now they have offices in Germany and in Canada and in the US and in France. So we were never a remote work company, we were just a global work company.

**中文翻译:**
在疫情接近尾声时，我们早期常被问到的一个问题是：“你们担心吗？疫情结束了，人们会不会不再使用 Deel 了？”我们的回答始终是：我们不是一个远程办公平台，我们是一个全球办公平台。所以很多企业已经回到了办公室。我们有很多客户要求员工回办公室，但现在他们在德国、加拿大、美国和法国都有办公室。所以我们从来不是一家远程办公公司，我们只是一家全球办公公司。

---

### (00:45:49) Meltem Kuran Berkowitz

**English:**
And remote work, because there was a lot of news coverage happening around it, we just became synonymous with that. So I do think early on we did benefit from being able to provide that solution. And a lot of people saw the reality of like, "Hey, I work just as well with this person as I did when I was in an office with them. Well, the best person that I'm looking for, the job may not be within my region, so let me go ahead and hire them regardless of where they are." People got comfortable with that and more and more companies started moving in that direction.

**中文翻译:**
由于当时有很多关于远程办公的新闻报道，我们成了它的代名词。所以我确实认为早期我们受益于能够提供那个解决方案。很多人看到了现实：“嘿，我和这个人协作得很好，就像以前在办公室一样。既然我找的最佳人选可能不在我所在的地区，那我就不管他在哪都雇了他吧。”人们对此感到习惯了，越来越多的公司开始朝这个方向发展。

---

### (00:46:20) Lenny

**English:**
And is there anything that ended up being really important in terms of helping Deel grow through that? Like a channel that's just like, "Let's go big on this channel because it seems to be working really well"? Or is it just word of mouth basically and people are just like, "Oh shit, I really need to solve this problem, my hair's on fire, what's out there? Let me go find an answer"?

**中文翻译:**
在那期间，有没有什么对帮助 Deel 增长至关重要的东西？比如某个渠道让你觉得“我们要在这个渠道上大干一场，因为它看起来效果非常好”？还是说基本上就是靠口碑，人们觉得“噢天哪，我真的需要解决这个问题，火烧眉毛了，外面有什么方案？让我去找找答案”？

---

### (00:46:36) Meltem Kuran Berkowitz

**English:**
I wouldn't say it was word of mouth, maybe very, very early on it was word of mouth, but within the first few months of our operation that stopped being true. Or at least the word of mouth stopped being a smaller percentage of the way in which people discover us. But it's always that people needed a payroll solution, they needed a way to hire independent contractors overseas, and we just were the answer to that. So we consistently put ourselves in front of them and said, "Hey, if you're trying to do this, or if you're already doing it and you're not doing it legally, we can help you do that legally."

**中文翻译:**
我不会说那是靠口碑，也许极早期是，但在运营的头几个月后就不是这样了。或者至少口碑不再是人们发现我们的主要方式。核心始终是人们需要薪酬方案，需要一种在海外招聘独立合同工的方式，而我们正好就是那个答案。所以我们持续出现在他们面前说：“嘿，如果你想做这件事，或者你已经在做了但做得不合规，我们可以帮你合规地完成。”

---

### (00:47:10) Lenny

**English:**
I want to chat about team building, something that I've heard you're exceptional at. And my first question is, early on when you were building the team, the growth team specifically, at Deel, what skills did you find were most important to look for? And what skills and experiences did you find wasn't as important early on that you could sacrifice and wait until later to get?

**中文翻译:**
我想聊聊团队建设，听说你在这方面非常出色。我的第一个问题是，早期在 Deel 组建增长团队时，你发现哪些技能是最重要的？哪些技能和经验在早期并不那么重要，可以先牺牲掉，等以后再补？

---

### (00:47:30) Meltem Kuran Berkowitz

**English:**
Early on one of the first questions I would ask people is, what are the KPIs that you're willing to commit to? So if someone's only willing to commit to lead numbers, that's not good enough. They need to be able to commit to closed one revenue KPRs to really show that they care about the business's bottom line. So it was those people that were willing to commit to the full funnel.

**中文翻译:**
早期我问人的第一个问题通常是：“你愿意承诺什么样的 KPI？”如果有人只愿意承诺线索数量（lead numbers），那是不够的。他们需要能够承诺“成交收入”（closed won revenue）的 KPI，以真正表明他们关心业务的底线。所以，我们需要的是那些愿意对全漏斗负责的人。

---

### (00:47:53) Meltem Kuran Berkowitz

**English:**
And also oftentimes people tend to hire from the big companies that they want to become like because the brand name is appealing. But if you're a team of 35 people, and you're trying to hire the director of whatever from a huge company, you need to ask the question of, when did this person join that huge company? Did they join when the company was already 5,000 people and from day one they had all the resources at their disposal? Or were they actually one of the earlier employees who helped that growth? Because oftentimes the mistake I see people make is they'll hire someone from an amazing company that have accomplished amazing things, but they're not used to operating with 10% of the resources that they had. So they're not willing to get down and do the dirty work.

**中文翻译:**
此外，人们往往倾向于从他们向往的大公司挖人，因为品牌名很好听。但如果你是一个 35 人的团队，你想从大公司挖一个什么总监，你需要问：这个人是什么时候加入那家大公司的？是公司已经 5000 人、他从第一天起就有各种资源可用时加入的吗？还是他实际上是帮助公司增长的早期员工之一？因为我经常看到人们犯的错误是，他们雇了一个来自牛逼公司、做过牛逼事情的人，但那个人不习惯在只有以前 10% 资源的情况下运作。所以他们不愿意俯下身子去做那些“脏活累活”。

---

### (00:48:35) Meltem Kuran Berkowitz

**English:**
And at Deel we have this concept called 'little hands'. I think it's loosely translated from French, someone can correct me on that. But it basically means that no matter who you are, where you sit within the organization, you need to be willing to get into the little things and do the nitty-gritty work and not shy away from it. And it's very important too, whoever we hire at any level, it's like, "Are you willing to do the tiniest of jobs?" And if the answer is yes, that's great. And some people are like, "I would build a team for that." And of course in the future, maybe you should, but that shouldn't be your first answer. Your first answer should be, "Yes, of course I'll do that." And if someone's not excited about that, then they're not a good fit for at least a company at our stage right now.

**中文翻译:**
在 Deel，我们有一个概念叫“小手”（little hands）。我想这大概是从法语翻译过来的，如果不对请纠正我。它的基本意思是，无论你是谁，在组织中处于什么位置，你都必须愿意参与琐碎的事情，做那些最基础的工作，而不回避它。这非常重要，无论我们招聘什么级别的员工，都会问：“你愿意做最微小的工作吗？”如果答案是肯定的，那就太棒了。有些人会说：“我会组建一个团队来做那个。”当然，未来也许你应该这么做，但这不应该是你的第一个回答。你的第一个回答应该是：“是的，我当然会做。”如果有人对此不感兴趣，那他们至少不适合我们目前这个阶段的公司。

---

### (00:49:18) Lenny

**English:**
That is an amazing expression, little hands. You talked about how you check that people are willing to commit to revenue goals. Is that in the interview or is that ... how do you ... because won't everyone just say, "Yeah, yeah, I can commit to anything you need me to commit to, I'm going to go make this work"? How do you get a sense if they're the kind of person that would do that?

**中文翻译:**
“小手”，这个表达太棒了。你提到你如何检查人们是否愿意承诺收入目标。是在面试中吗？还是……你怎么判断？因为每个人都会说：“行行行，你需要我承诺什么我就承诺什么，我会搞定的。”你如何感觉到他们就是那种会付诸行动的人？

---

### (00:49:38) Meltem Kuran Berkowitz

**English:**
It happens within the interview process. So one ways to find out is what are the KPIs that they have committed to in the past in their roles. So if they've never committed to a revenue goal or a bottom funnel goal and they're saying they're willing to commit to it, that's probably not correct. And I always say, if they haven't, I say, "What are the KPIs that you have today and what are the KPIs that you think you should have?" Because sometimes they're just not given those, but they still think they should have been given the more bottom funnel. So that's something that I would look for in the interview process.

**中文翻译:**
这发生在面试过程中。一种方法是看他们过去在岗位上承诺过什么样的 KPI。如果他们从未承诺过收入目标或漏斗底部目标，却说现在愿意承诺，那大概率不靠谱。我总是会问，如果他们没做过，我会问：“你现在的 KPI 是什么？你认为你应该拥有什么样的 KPI？”因为有时他们只是没被赋予这些指标，但他们内心认为自己应该对漏斗底部负责。这是我在面试中会寻找的东西。

---

### (00:50:06) Meltem Kuran Berkowitz

**English:**
A really good way to also test for that is, this is more on the case study process, but asking someone to come up with a strategy with $0, with $10,000 and maybe a hundred thousand dollars to see if they're going to be able to scale with you. And to see how are they thinking about with different levels of spend and what are they willing to commit to at different levels of spend. Because if someone's throwing up their hands and saying, "At $0, I can only do social media monitoring, we're not going to get much because that's what makes sense." Well, you probably know that they're not going to be comfortable committing to those bottom of funnel metrics until you give them all the resources that they need.

**中文翻译:**
另一个很好的测试方法是在案例分析环节：让某人分别制定 0 美元预算、1 万美元预算和 10 万美元预算的策略，看看他们是否能随你一起扩展。看看他们在不同支出水平下的思考方式，以及在不同支出水平下愿意承诺什么。如果有人摊摊手说：“在 0 预算下，我只能做社交媒体监控，我们不会得到太多，因为这才是合理的。”那么你大概就知道，在给足资源之前，他们是不会放心承诺漏斗底部指标的。

---

### (00:50:46) Lenny

**English:**
And it sounds like the way you goal teams within Deel also is revenue, growth teams basically have revenue goals. It's not, like you said, leads or traffic or anything like that.

**中文翻译:**
听起来你在 Deel 内部给团队设定的目标也是收入，增长团队基本上都有收入目标。不像你说的，只是线索或流量之类的。

---

### (00:50:55) Meltem Kuran Berkowitz

**English:**
Yes. That's why we're called growth instead of marketing, we care about the revenue growth. And of course we track leads and SQLs. Those are leading indicators to know whether or not we're going to hit the ultimate number that we all care about. But at the end of the day, that's not what we consider success.

**中文翻译:**
是的。这就是为什么我们叫“增长”而不是“营销”，我们关心收入增长。当然，我们会追踪线索（leads）和销售合格线索（SQLs）。这些是领先指标，让我们知道是否能达到大家最终关心的那个数字。但归根结底，那并不是我们定义的成功。

---

### (00:51:12) Lenny

**English:**
In terms of team structure, how you thought about structuring the early growth team, what did that look like and what was the reporting lines and buckets of investment?

**中文翻译:**
在团队结构方面，你是如何考虑组建早期增长团队的？当时是什么样子的？汇报关系和投资板块是如何划分的？

---

### (00:51:21) Meltem Kuran Berkowitz

**English:**
Yeah, so very early on, we always seek to bring in one leader to manage a part of the organization and then let them grow their teams. We don't love the idea of hiring people based off of a hypothesis that something is going to work. That's a really good way to have to do layoffs because the plans you thought were going to work didn't work. So we always hired one person, prove out a theory, and then let them grow their team.

**中文翻译:**
好的。在非常早期，我们总是寻求引入一名领导者来管理组织的一部分，然后让他们去壮大自己的团队。我们不喜欢基于“某个假设可能奏效”就去招一堆人。那是导致裁员的绝佳方式，因为你以为会奏效的计划没奏效。所以我们总是先雇一个人，证明一个理论可行，然后让他们去组建团队。

---

### (00:51:43) Meltem Kuran Berkowitz

**English:**
So the first hire we made to the team was actually a product marketing person. To this day they lead our product marketing team, and they were the ones who sit between the product team and the go-to-market teams and really set the messaging. And quickly we realized this person needs more help in setting the messaging, the tone. So then the second person we hired was a very talented copywriter. And that person today leads our creative teams.

**中文翻译:**
所以我们团队招的第一个人其实是产品营销（PMM）。直到今天，他依然领导着我们的产品营销团队。他们是介于产品团队和进入市场（GTM）团队之间的人，负责设定核心信息。很快我们意识到这个人需要更多帮助来设定信息和基调，所以我们招的第二个人是一位非常有才华的文案。那个人现在领导着我们的创意团队。

---

### (00:52:08) Meltem Kuran Berkowitz

**English:**
And then the third person we actually hired onto the growth team was a data analyst because the sentiment was we're not willing to spend a dollar if we don't know where that money's going and what it's doing for us. Which a lot of people would assume that's a very early hire for ... data is too early to hire as number three. But I still think that we did the right thing there. Now we have a whole data team, but back then we didn't.

**中文翻译:**
增长团队招的第三个人其实是数据分析师。因为我们的态度是：如果我们不知道钱花在哪了、起到了什么作用，我们一分钱也不愿意花。很多人可能会觉得作为第三号员工，招数据分析师太早了。但我依然认为我们做对了。现在我们有整个数据团队，但当时没有。

---

### (00:52:32) Meltem Kuran Berkowitz

**English:**
So those were the three teams that we started with on top. And then the content person was already at Deel by the time that I joined, so that was the person I mentioned that was early employee. So that's how we originally set it.

**中文翻译:**
所以这就是我们最初开始的三个板块。内容负责人是在我加入之前就已经在 Deel 了，就是我提到的那位早期员工。这就是我们最初的设定。

---

### (00:52:45) Meltem Kuran Berkowitz

**English:**
Now the teams have changed. So now we have a different structure, slightly different structure, which is we have regional teams and functional teams. The functional teams are basically subject matter experts. They're good at what they do and we don't care where they are based in the world. So those are teams like product marketing, content, community, events, paid advertisements, brand. If we are looking for the best graphic designer in the world, I don't care where they are, they can sit wherever in the world. They are basically functional teams.

**中文翻译:**
现在团队已经变了。我们现在有一个不同的结构，稍微有点不同：我们有区域团队和职能团队。职能团队基本上是领域专家。他们擅长自己的工作，我们不在乎他们在世界哪个角落。这些团队包括产品营销、内容、社区、活动、付费广告、品牌。如果我们想找世界上最好的平面设计师，我不在乎他在哪，他可以坐在世界任何地方。他们基本上是职能团队。

---

### (00:53:16) Meltem Kuran Berkowitz

**English:**
And then we have regional teams. Because we are selling into a lot of different regions, we need to make sure that we have local expertise as well. So we have marketing managers for different key regions for us that then work with our functional teams to bring the strategy to life. So that's how we've set it.

**中文翻译:**
然后我们有区域团队。因为我们要销往很多不同的地区，我们需要确保拥有本地专业知识。所以我们有针对不同关键地区的营销经理，他们与职能团队合作，将战略落地。这就是我们的设定。

---

### (00:53:33) Meltem Kuran Berkowitz

**English:**
I've seen businesses who build out a regional team that has their own paid ads team and their own content team. But what we have found is when you take people away from their group of expertise, so if you take a paid ads person, and if you have a team of paid ads people and you separate those five people and give them to different regions, instead of letting them sit together and be a tight team, the best practice is learning and the leveling up of the skills doesn't happen as fast as they would if all of the technical roles are sitting together. So we are continuing down the road of functional and regional setup.

**中文翻译:**
我见过有些公司建立区域团队，每个区域都有自己的付费广告团队和内容团队。但我们发现，当你把人从他们的专业群体中抽离出来——比如你有一个 5 人的付费广告团队，你把他们拆开分给不同的区域，而不是让他们坐在一起组成一个紧密的团队——那么最佳实践的学习和技能的提升速度，就不如所有技术角色坐在一起时那么快。所以我们坚持走职能与区域相结合的道路。

---

### (00:54:09) Lenny

**English:**
So say someone in Turkey wants to run paid ads, they convince the paid growth team to invest in resources in growing Turkey?

**中文翻译:**
所以假设土耳其的某人想投放付费广告，他们需要说服付费增长团队在土耳其的增长资源上进行投入？

---

### (00:54:16) Meltem Kuran Berkowitz

**English:**
Exactly. So they would work with our central paid ads team to say I would like to run paid ads in Turkey, this is the audience I want to go after. And then they work together to execute on that strategy.

**中文翻译:**
没错。他们会与我们的中央付费广告团队合作，说：“我想在土耳其投放广告，这是我想触达的受众。”然后他们共同执行该战略。

---

### (00:54:28) Lenny

**English:**
How does that team decide who's going to get their time, is there a rough approach to that?

**中文翻译:**
那个团队如何决定把时间花在谁身上？有没有什么大致的方法？

---

### (00:54:32) Meltem Kuran Berkowitz

**English:**
So it depends on the total addressable market in a region, what are the opportunities we're seeing, what's the competitive landscape like. So chances are if a market is what we consider to be tier one, and it's a place that we have seen good growth, we will invest our resources into it. And then along the way we learn and we decide if we're going to double down or pull back a little bit.

**中文翻译:**
这取决于该地区的总潜在市场（TAM）、我们看到的机遇以及竞争格局。如果一个市场被我们认为是第一梯队（Tier 1），且我们已经看到了良好的增长，我们就会投入资源。在这个过程中，我们会不断学习，并决定是加倍投入还是稍微收缩。

---

### (00:54:53) Lenny

**English:**
Awesome. I want to chat a bit about culture, culture at Deel. We had Jeff from Ramp on, and their culture is described by one word, velocity. Also one of you being the fastest growing business of all time, I'm curious how you'd contrast your culture and broadly how you think about culture at a startup and how you help create the culture at Deel?

**中文翻译:**
太棒了。我想聊聊文化，Deel 的文化。我们请过 Ramp 的 Jeff，他们的文化可以用一个词概括：速度（velocity）。既然你们也是史上增长最快的公司之一，我很想知道你会如何对比你们的文化？广义上你如何看待初创公司的文化？你是如何帮助塑造 Deel 的文化的？

---

### (00:55:12) Meltem Kuran Berkowitz

**English:**
Yeah, so I would say culture is made up of two components. One is, what do you bring to the company as a team member, and what does the company give back to you? So what we expect the team members to bring to us is, our version of velocity is something that we call 'Deel speed', is that we want to make sure that we act with urgency. It doesn't matter how big the team has grown, we want to act with urgency on behalf of our customers. If a customer has a problem, they're not going to wait two weeks to get an answer for that. They're going to get that answer within 24 hours. If we need to build out a product because many customers are asking for it, that product is going to get built in one-tenth the time that any of our competitors will likely build it in.

**中文翻译:**
好的。我认为文化由两个部分组成。一是作为团队成员你为公司带来了什么，二是公司回馈了你什么。我们期望团队成员带来的是我们版本的“速度”，我们称之为“Deel 速度”（Deel speed），即我们要确保带着紧迫感行动。无论团队变得多大，我们都要代表客户以紧迫感行事。如果客户有问题，他们不会等两周才得到答案，他们会在 24 小时内得到。如果因为很多客户要求而需要开发一个产品，那个产品的开发时间将只有竞争对手的十分之一。

---

### (00:55:51) Meltem Kuran Berkowitz

**English:**
So 'Deel speed' is very, very important for us. And that's something we expect from our team members who are committing to it. To say, what's the quickest way I can solve this problem properly? And to repeatedly push themselves to act with urgency.

**中文翻译:**
所以“Deel 速度”对我们非常、非常重要。这是我们对承诺加入的成员的期望：思考什么是妥善解决这个问题的最快方式？并不断推动自己带着紧迫感行动。

---

### (00:56:06) Meltem Kuran Berkowitz

**English:**
We also care that we remain positive. We have default optimism because we are in a new space, so if someone's going to come into Deel and they're going to be pessimistic and they're like, "I don't think that's going to work for X, Y, Z reasons," they're going to just slow things down. We need people to ask the question of, "I think it's going to work for these four reasons, now let's see what are the risks associated with it and let's seek to solve those risks." That's again something we expect from our team members.

**中文翻译:**
我们也看重保持积极。我们拥有“默认乐观”（default optimism），因为我们处于一个新领域。如果有人来到 Deel 却很悲观，说“我觉得因为 X、Y、Z 原因这行不通”，他们只会拖慢进度。我们需要人们问：“我认为因为这四个原因它会奏效，现在让我们看看相关的风险是什么，并寻求解决这些风险。”这同样是我们对成员的期望。

---

### (00:56:31) Meltem Kuran Berkowitz

**English:**
And then the last one, well, not the last one, but one of the third important ones is, fully giving a shit about your customer. At the end of the day, the product that we have, we are dealing with humans, we're dealing with their livelihood, the way they get paid, we're dealing with the way companies hire. It's so incredibly personal if someone doesn't get their paycheck on time or if someone gets into legal trouble because their contract wasn't set up the proper way.

**中文翻译:**
最后一点，或者说第三个重要的点是：完全在意（giving a shit）你的客户。归根结底，我们的产品打交道的是人，是他们的生计，是他们领工资的方式，是公司招聘的方式。如果有人没按时领到薪水，或者因为合同没写好而陷入法律麻烦，这是非常私人且严重的事情。

---

### (00:56:57) Meltem Kuran Berkowitz

**English:**
So recognizing that it's not a software and a platform that we're trying to make it the best, but it's like, no, it's a business trying to pay a human so they can live their lives and the business can continue growing. So that care is something that we need people to bring to the table.

**中文翻译:**
所以要意识到，我们不仅仅是在做一个最好的软件或平台，而是在帮助一家企业付钱给一个人，让他能过好生活，让企业能继续增长。这种关怀是我们需要人们带到工作中的。

---

### (00:57:14) Meltem Kuran Berkowitz

**English:**
Now in return of those things coming, what we give back as a company is, outside of obviously your pay, your benefits package, et cetera, is we offer people the flexibility to choose how and when they do their job, they get to decide on where they work from, what hours they work. So we basically give people all the freedom to set up their life how they want to as long as they come to the table giving us what they need. So I would say we do have an intense culture, and that's expected, we share that openly with people. But at the end of the day, that's also what sets us apart.

**中文翻译:**
作为这些付出的回报，公司提供的是——除了薪水、福利包等显而易见的东西外——我们为人们提供选择工作方式和时间的灵活性。他们可以决定在哪里工作、什么时间工作。基本上，只要他们能提供公司所需的东西，我们就给他们设定生活的全部自由。所以我想说，我们确实有一种高强度的文化，这是预料之中的，我们也公开分享这一点。但归根结底，这也是让我们脱颖而出的原因。

---

### (00:57:48) Lenny

**English:**
I love this 'Deel speed'. Are these core values basically within Deel, these are values that you come back to?

**中文翻译:**
我喜欢这个“Deel 速度”。这些是 Deel 内部的核心价值观吗？是你们经常回顾的准则吗？

---

### (00:57:54) Meltem Kuran Berkowitz

**English:**
Yes, exactly. And these are values that we publicly share as well.

**中文翻译:**
是的，没错。这些也是我们公开分享的价值观。

---

### (00:57:58) Lenny

**English:**
How early in the lifecycle of the company did you all come up with these values? That's something that a lot of startups think about is, when should we actually crystallize these values?

**中文翻译:**
在公司的生命周期中，你们多早提出了这些价值观？这是很多初创公司都在思考的问题：我们什么时候应该真正把这些价值观具体化？

---

### (00:58:06) Meltem Kuran Berkowitz

**English:**
So we came up with them, I believe it was about a year in, but we didn't sit around the table and say, "What should we call our values?" 'Deel speed' was something that our CEO would tell people. He'd be like, "Okay, I want you to do this, but I want you to do it at 'Deel speed'." And one of the early jokes was, let's have company swag that's Deel speedo and things like that. It's just like, it was already used so frequently with people that we were just like, "Okay, we keep saying this, let's also define what it actually is for us and set it in stone and share it with people." So we did go through that exercise probably about a year in into the company existing, but the culture happened well before we established that.

**中文翻译:**
我想是在公司成立大约一年后。但我们并没有围坐在桌子旁说：“我们的价值观该叫什么？”“Deel 速度”是我们的 CEO 经常对大家说的话。他会说：“好，我想让你做这件事，但我希望你以‘Deel 速度’来做。”早期的一个笑话是，我们要出一种叫“Deel Speedo”（Deel 泳裤，谐音速度）的公司周边。因为它在大家口中出现的频率太高了，所以我们就想：“好吧，既然我们一直在说这个，那就定义一下它对我们到底意味着什么，把它固定下来并分享给大家。”所以我们在公司成立大约一年时做了这件事，但文化在确立价值观之前就已经存在了。

---

### (00:58:49) Lenny

**English:**
Reminds me, at Airbnb, there was a team that came up with the core values, I think it was four years in probably, and there were six of them. And then a few years later they realized two of them aren't actually true, they were aspirational. And there was this recognition that values should be who you are not who you hope to be because it just doesn't click. And so they actually cut those values and they ended up having just four values. And maybe one day they'll bring them back. And so I think that's a really good lesson is you want to see who you already are and then just represent them in a really interesting, creative way.

**中文翻译:**
这让我想起在 Airbnb，有一个团队在成立大概四年后提出了核心价值观，当时有六条。几年后他们意识到其中两条其实并不真实，只是美好的愿景。他们意识到价值观应该是“你是谁”，而不是“你希望成为谁”，因为后者无法引起共鸣。所以他们删掉了那两条，最后只剩下四条。也许有一天他们会把它们带回来。所以我认为这是一个很好的教训：你要看清自己已经是什么样的人，然后用一种有趣、有创意的方式表达出来。

---

### (00:59:22) Meltem Kuran Berkowitz

**English:**
Yes, exactly.

**中文翻译:**
是的，没错。

---

### (00:59:23) Lenny

**English:**
There's a version of, what did you call it, default optimism. Airbnb's version of that was 'embrace the adventure', which is just like, this is going to be crazy, just go for it, embrace it, this is what it's going to be like.

**中文翻译:**
还有一种版本，你叫它什么来着？“默认乐观”。Airbnb 的版本是“拥抱冒险”（embrace the adventure），意思就是：这会很疯狂，尽管去做吧，拥抱它，这就是它本来的样子。

---

### (00:59:38) Meltem Kuran Berkowitz

**English:**
Exactly. And try and see how can I solve this, how can this be done instead of why it won't work.

**中文翻译:**
没错。试着去看“我该如何解决这个”、“这该如何实现”，而不是去想“为什么它行不通”。

---

### (00:59:43) Lenny

**English:**
Yeah, I love that. And this urgency piece comes up again and again in these interviews I'm doing. What I think of is Frank Slootman, I think is his name, the founder of Snowflake, has this book called Amp It Up. All about just how they made Snowflake work. And something he comes back to is just you need to constantly have a sense of urgency because when you don't, people get bored and they actually end up liking their job less because it's just like, I don't really know what I'm doing, things are moving along. And there's actually a lot of value in moving fast. Jeff talked about this as just like, you have less burnout when people feel like things are getting done and out the door.

**中文翻译:**
是的，我喜欢这个。这种“紧迫感”在我做的这些采访中反复出现。我想到了 Frank Slootman（Snowflake 的创始人），他写了一本书叫《Amp It Up》，讲的是他们如何让 Snowflake 成功的。他强调的一点是，你需要不断保持紧迫感，因为如果没有紧迫感，人们会感到无聊，最终反而会更不喜欢自己的工作，因为感觉只是在混日子。快速行动其实很有价值。Jeff 也谈过这一点：当人们觉得事情正在被完成并交付时，职业倦怠感反而会减少。

---

### (01:00:18) Meltem Kuran Berkowitz

**English:**
Yeah, it's incredibly fulfilling. I look back and sometimes things when, for example, when the SVB was going through the issues they were going through, the entire team had to work on a Sunday to communicate with our customers of like, "No, we're good, don't worry about it." But I remember that Sunday I had to miss out on a theater I was so excited to see, but it just felt like, oh my God, we're in this, it was like a war room, we're doing it. And that felt good. I didn't necessarily show up on Monday feeling already burned out, but it was more like, yes, I felt alive. And I think the right people will feel that way.

**中文翻译:**
是的，这非常有成就感。回想起来，比如当硅谷银行（SVB）出事时，整个团队必须在周日加班与客户沟通：“不，我们没问题，别担心。”我记得那个周日我不得不错过一场我很想看的戏，但那种感觉就像是：“天哪，我们正身处其中。”那就像一个作战室，我们在战斗。那种感觉很好。周一上班时我并没有感到精疲力竭，反而觉得“我还活着”。我认为合适的人会有这种感觉。

---

### (01:00:52) Lenny

**English:**
Yeah, and as long as it's not constantly for years just endless late nights and weekends.

**中文翻译:**
是的，只要不是常年累月无休止的熬夜和周末加班就行。

---

### (01:01:01) Meltem Kuran Berkowitz

**English:**
It can't always be war time.

**中文翻译:**
不可能永远都是战时状态。

---

### (01:01:01) Lenny

**English:**
I find that those end up being the most memorable, meaningful moments is when you're working really, really hard on something that you're excited about. And it has to be something you're excited about and are proud of.

**中文翻译:**
我发现那些最难忘、最有意义的时刻，往往是你为你兴奋的事情拼命工作的时候。而且那必须是你感到兴奋并引以为豪的事情。

---

### (01:01:10) Lenny

**English:**
Last question. I saw on Twitter, you shared this photo of your home office, and it was this incredible view out the window, and then you took a photo facing your desk and it was an ironing board. And two questions there. One is just how did that all happen? And then two, I think you mentioned somewhere that you didn't even meet a lot of your coworkers for a year and a half after joining Deel, it was very remote forward. So, I'm curious also just how you made remote work work for you in that environment?

**中文翻译:**
最后一个问题。我在 Twitter 上看到你分享了一张家庭办公室的照片，窗外的景色美极了，但当你拍向你的办公桌时，那竟然是一个烫衣板。我有两个问题：第一，那是怎么回事？第二，你好像在某处提到过，加入 Deel 之后的一年半里你甚至没见过很多同事，这是一家非常推崇远程办公的公司。所以我很好奇，在那样的环境下，你是如何让远程办公奏效的？

---

### (01:01:36) Meltem Kuran Berkowitz

**English:**
Yeah, so I'll explain the ironing board first. So that was because I was actually visiting my family in Istanbul, and in the setup that we have, there's one desk. So my husband and I go rock, paper, scissors, and we'll see who gets the desk and who gets to come up with a secondary solution. And he won the desk, so I had to come up with a creative solution. And because the view behind me was stunning, of the Bosporus, every meeting I joined, people were like, "Wow, I love your view, this is amazing." And I was like, "Oh, no, no, you guys, I'm sitting on an ironing board right now." And to me that was both funny, and I wanted to do a reality check with people to be like, "Come on, this is not as glorious as it looks." But at the same time, it really in that moment I was like, "This is awesome, I work at Deel."

**中文翻译:**
哈哈，我先解释一下烫衣板。那是因为我当时在伊斯坦布尔探亲，我们住的地方只有一张书桌。所以我丈夫和我玩石头剪刀布，看谁能用桌子，谁得想备选方案。他赢了桌子，所以我得想个创意方案。因为我身后的博斯普鲁斯海峡景色太美了，每次开会大家都会说：“哇，我太喜欢你的窗景了，太棒了。”我会说：“噢，不不不，各位，我现在正坐在一块烫衣板前面呢。”对我来说这很有趣，我也想给大家一个“现实核查”：别被骗了，这没看起来那么光鲜。但同时，那一刻我也觉得：“这太棒了，我在 Deel 工作。”

---

### (01:02:22) Meltem Kuran Berkowitz

**English:**
Previously when I wanted to go visit my family in Istanbul, and I live in Canada, I would have to use my days off to go. And for me it just meant a lot to be able to do my work regardless of where I am. I had a full day of work and meetings and everything. And my work just continued and I was also be able to be with my family. So it was a moment of Deel's promise coming true in a very real way in my life. And I thought it was hilarious. My dad thought it was so unprofessional that I shared that with the public then. He hasn't fully wrapped his head around the startup world. So it was just one of those moments of sharing that, yeah, work can be remote and it can be whatever you want it to be. So that's the the story behind it. In this moment as we're recording this, I am in a proper home office with a desk and a back supported chair. It changes all the time.

**中文翻译:**
以前我想回伊斯坦布尔看家人（我住在加拿大），我必须用掉年假。对我来说，无论身在何处都能工作意义重大。我有一整天的工作和会议，工作照常进行，同时我也能和家人在一起。那是 Deel 的承诺在我生活中以非常真实的方式实现的时刻。我觉得这很滑稽。我爸爸当时觉得我把这个发到网上太不专业了，他还没完全理解初创公司的世界。所以那只是一个分享的时刻：是的，工作可以是远程的，可以是任何你想要的样子。这就是背后的故事。现在我们录音时，我在一个正经的家庭办公室里，有桌子和护脊椅。情况一直在变。

---

### (01:03:16) Meltem Kuran Berkowitz

**English:**
And in terms of, going back to your second question of, early days not meeting the team members. As I said, I joined Deel in July, 2020, pandemic was at its peak, me being based in Canada, Canada had very strict restrictions of, you can't leave the country, we won't let you back in. So I had to stay put. And I worked for a year and a half at Deel before for the first time where I met our team members was at a conference in Lisbon. And I showed up and it was this surreal moment because I've worked with them for a year and a half, we'd accomplished so much. Our revenue was already way past $50 million and I was seeing these people for the first time. So that was very funny.

**中文翻译:**
关于你的第二个问题，早期没见过团队成员。正如我所说，我是在 2020 年 7 月加入 Deel 的，当时疫情正处于高峰。我住在加拿大，加拿大当时有非常严格的限制：你不能出国，否则不让你回来。所以我只能待在原地。我在 Deel 工作了一年半之后，才第一次在里斯本的一个会议上见到了同事。我出现在那里，感觉非常超现实，因为我已经和他们共事了一年半，取得了这么多成就，收入已经远超 5000 万美元，而我却是第一次见到这些人。这非常有趣。

---

### (01:03:58) Meltem Kuran Berkowitz

**English:**
But if I look at the early days of Deel, there's a lot of little stories like that, where we forgot to create swag until we reached a billion dollars. And it was actually when our photo was going to be on the NASDAQ and we wanted to take a team picture that we were like, "Guys, we need to have t-shirts. Can someone please run to a store in New York and print our logo on something?" So a lot of those things just by the nature of being a pandemic business came a little bit later.

**中文翻译:**
回看 Deel 的早期，有很多这样的小故事。比如我们直到估值达到 10 亿美元才想起做公司周边（swag）。实际上是当我们的照片要登上纳斯达克大屏、我们想拍合影时，才反应过来：“伙计们，我们需要 T 恤。谁能跑去纽约的一家店，把我们的 Logo 印在衣服上？”所以很多事情因为我们是一家“疫情期间诞生的企业”，都来得晚了一些。

---

### (01:04:25) Meltem Kuran Berkowitz

**English:**
But the thing that allowed I think for me in Deel to build the culture early on was, because we all work from home, we've been like that from day one. We have the option to go into WeWorks and co-working spaces if that's something that you choose. But we all get to show up as our very authentic selves. So people have met my pets and my partner well before they would have if I was showing up to an office. So there's that sincerity that comes with being in someone's home that we really relied on early on.

**中文翻译:**
但我认为让我能在 Deel 早期建立文化的原因是，因为我们都在家工作，从第一天起就是这样。如果你愿意，可以选择去 WeWork 或共享办公空间。但我们都能以最真实的自我出现。大家在见到我本人之前，就已经见过我的宠物和伴侣了。这种身处某人家中带来的真诚感，是我们早期非常依赖的东西。

---

### (01:04:56) Meltem Kuran Berkowitz

**English:**
And as a company, I never felt the pressure to show up in a certain way or dress up for meetings or anything. So just being able to show up as yourself, and whether you're an introverted person who never likes to turn on their camera or you're someone who's going to be like, "Here, meet my dog." That just naturally built a team culture and comradery well before we could be together in person.

**中文翻译:**
作为一家公司，我从未感到有压力要以某种特定方式出现，或者为了开会而刻意打扮。你只需要做你自己。无论你是一个不喜欢开摄像头的内向者，还是一个会说“嘿，见见我的狗”的人。这在我们可以线下见面之前，就自然而然地建立起了团队文化和战友情谊。

---

### (01:05:20) Lenny

**English:**
Clearly it has worked out. Meltem, is there anything else that you want to share before we get to our very exciting lightning round?

**中文翻译:**
显然这奏效了。Meltem，在进入我们非常精彩的闪电轮问答之前，你还有什么想分享的吗？

---

### (01:05:26) Meltem Kuran Berkowitz

**English:**
We had a really good conversation. The one thing I would tell people is, most of growth, people assume is very difficult. I'm not necessarily saying it's easy, but it's relatively straightforward when you go back to the first principles of just figuring out where are the people at? How can I add value? As long as your product is there to actually bring them value. So I would say people should just recognize that it's much simpler than they think it is, it just takes a lot of discipline to execute on it, it's not rocket science.

**中文翻译:**
我们的谈话非常愉快。我想告诉大家的一件事是：大多数人认为增长非常困难。我不是说它很容易，但当你回到第一性原理——弄清楚人在哪里？我如何增加价值？只要你的产品确实能带来价值——它其实相对简单。所以我想说，大家应该意识到它比想象中简单，只是需要极强的纪律性去执行，它不是什么高深莫测的尖端科学。

---

### (01:06:01) Lenny

**English:**
Quite an empowering statement, I love it. With that, we've reached our very exciting lightning round. Are you ready?

**中文翻译:**
非常有力量的总结，我喜欢。那么，我们进入精彩的闪电轮。准备好了吗？

---

### (01:06:07) Meltem Kuran Berkowitz

**English:**
I am ready, let's do this.

**中文翻译:**
准备好了，开始吧。

---

### (01:06:09) Lenny

**English:**
What are two or three books that you've recommended most to other people?

**中文翻译:**
你向别人推荐最多的两三本书是什么？

---

### (01:06:13) Meltem Kuran Berkowitz

**English:**
From the nonfiction world, How Will You Measure Your Life by Clay Christensen, that's one I recommend. He takes the business learnings that he's had and applies it to your life. It's a very short and easy to get through book. Outside of that, I constantly recommend fiction. I think at one point it became uncool to read fiction that every moment you have needs to be productive and you need to learn something. I don't care what fiction it is you read, you can read Judy Blume for all I care, but just read fiction, be creative, do something with your brain other than reading nonfiction and learning things all the time.

**中文翻译:**
非虚构类的话，克莱顿·克里斯坦森的《你要如何衡量你的人生》（How Will You Measure Your Life），这是我推荐的一本。他把他获得的商业教训应用到了生活中。这是一本非常短且易读的书。除此之外，我经常推荐虚构类小说。我觉得曾几何时，读小说变得“不酷”了，好像每一刻都必须有产出、必须学到东西。我不在乎你读什么小说，哪怕是读 Judy Blume 也可以，但请读读小说，保持创造力，让你的大脑做点除了读非虚构和一直学习之外的事情。

---

### (01:06:48) Lenny

**English:**
I've had to make that shift myself, and it's been great, but I still get drawn to nonfiction. But good reminder. What are some favorite recent movie or TV shows you've loved?

**中文翻译:**
我自己也得做这种转变，感觉很棒，但我还是会被非虚构吸引。不过这是个很好的提醒。最近有什么喜欢的电影或电视剧吗？

---

### (01:06:58) Meltem Kuran Berkowitz

**English:**
Favorite recent movie, I think along with everybody else, was Oppenheimer. I thought it was great. I do wish they explored a little bit more of why he was the person that drove everybody to excellence. But overall loved the movie. Did not think I could sit through three hours without peeing, but I did. And favorite recent TV show was The Summer I Turned Pretty. I absolutely love it. I don't care that it's actually designed for teenagers, I enjoyed every second of it.

**中文翻译:**
最近喜欢的电影，我想和大家一样，是《奥本海默》。我觉得很棒。我确实希望他们能多探讨一下为什么是他能驱动所有人追求卓越。但总的来说很喜欢。我本以为我坐不住三小时不去厕所，但我做到了。最近喜欢的电视剧是《我变美的那夏天》（The Summer I Turned Pretty）。我超级喜欢。我不在乎它其实是给青少年看的，我享受其中的每一秒。

---

### (01:07:28) Lenny

**English:**
What is a favorite interview question that you like to ask candidates when you're interviewing them?

**中文翻译:**
在面试候选人时，你最喜欢问的问题是什么？

---

### (01:07:28) Meltem Kuran Berkowitz

**English:**
What would your siblings say about you? It's very telling. If they have siblings, if they don't, I will say, what will your parents say about you? But it's very telling what you think other people think of you.

**中文翻译:**
“你的兄弟姐妹会怎么评价你？”这非常能说明问题。如果他们没有兄弟姐妹，我会问父母怎么评价。你认为别人怎么看你，这能反映出很多东西。

---

### (01:07:41) Lenny

**English:**
What do you look for in their answer that gives you a sign that they're a good candidate or not?

**中文翻译:**
你从他们的回答中寻找什么信号来判断他们是否是合适的候选人？

---

### (01:07:45) Meltem Kuran Berkowitz

**English:**
I look for sincerity and self-awareness. Your siblings are never ... I mean, I love my sister, but she'll probably shit talk me a lot. And being aware of that is very important. If someone was like, "My siblings will say I'm very organized and that I'm the one that brings our family together." That's probably a bullshit answer. But if they're like, "Oh yeah, they'll say these weird things about me," that shows a little bit of self-awareness and humbleness that I want to see in a person.

**中文翻译:**
我寻找的是真诚和自我意识。你的兄弟姐妹永远不会……我是说，我爱我姐姐，但她可能会说我很多坏话。意识到这一点非常重要。如果有人说：“我的兄弟姐妹会说我非常有条理，我是维系家庭的人。”那大概是个扯淡的答案。但如果他们说：“噢，他们会说我的一些怪癖，”这表现出了一点自我意识和谦逊，这是我想在一个人身上看到的。

---

### (01:08:11) Lenny

**English:**
What is a favorite product you've recently discovered that you really like?

**中文翻译:**
你最近发现了什么非常喜欢的产吗？

---

### (01:08:14) Meltem Kuran Berkowitz

**English:**
Oh, this is a dangerous one. So two, one was NuStrips, they're caffeine strips. I find caffeine pills and everything or when I drink coffee is like, accidentally I'll have 300 milligrams and then I'm buzzing. But these are 50 milligrams each, so it's very easy to stop yourself. And they don't taste bad. So those I like for when I just need a little boost.

**中文翻译:**
噢，这题有点危险。有两个，一个是 NuStrips，它们是咖啡因贴片（薄片）。我发现吃咖啡因药片或喝咖啡时，不小心就会摄入 300 毫克，然后整个人就亢奋过头了。但这些每片只有 50 毫克，很容易控制。而且味道不差。当我只需要一点点提神时，我很喜欢用它。

---

### (01:08:32) Lenny

**English:**
So they're just strips that you put in your mouth and they give you caffeine?

**中文翻译:**
所以它们就是放进嘴里的薄片，然后给你提供咖啡因？

---

### (01:08:32) Meltem Kuran Berkowitz

**English:**
Like LISTERINE strips.

**中文翻译:**
就像李施德林的口腔清新片一样。

---

### (01:08:36) Lenny

**English:**
What?

**中文翻译:**
什么？

---

### (01:08:37) Meltem Kuran Berkowitz

**English:**
And you put it on your tongue and then it also doesn't give you the jitters and it's just 50 milligrams, which is a very mild cup of coffee.

**中文翻译:**
你把它放在舌头上，它不会让你感到焦虑不安，而且只有 50 毫克，相当于一杯非常淡的咖啡。

---

### (01:08:45) Lenny

**English:**
Microdosing caffeine.

**中文翻译:**
微量摄入咖啡因。

---

### (01:08:46) Meltem Kuran Berkowitz

**English:**
Exactly.

**中文翻译:**
没错。

---

### (01:08:47) Lenny

**English:**
Beautiful.

**中文翻译:**
太妙了。

---

### (01:08:48) Meltem Kuran Berkowitz

**English:**
And the second one is, I recently was gifted a personalized library stamp, which I love. Because I love to give books away, so I stamp them with my library stamp. And I like to think that one day in a secondhand bookshop I'm going to run into it.

**中文翻译:**
第二个是，我最近收到一个定制的个人图书馆印章，我很喜欢。因为我喜欢把书送人，所以我会在书上盖上我的图书馆章。我常想，也许有一天我会在某家二手书店里偶遇它。

---

### (01:09:03) Lenny

**English:**
That's amazing. There's a camp at Burning Man that's a library, and you can borrow books and you have to return it in a year, the next year when you come back to Burning Man. Which is amazing. And then there's a guy that has a megaphone, he is just like, "A book has been returned." Makes a whole scene about it. What is a favorite life motto that you often come back to or share with other people, either at work or in life?

**中文翻译:**
太棒了。火人节（Burning Man）上有一个营地就是图书馆，你可以借书，但必须在一年后，也就是明年回到火人节时归还。这很神奇。还有一个拿着扩音器的家伙，他会大喊：“有一本书归还了！”搞得很有仪式感。你有没有什么经常回顾或分享给别人的座右铭，无论是在工作还是生活中？

---

### (01:09:27) Meltem Kuran Berkowitz

**English:**
The world is run by insecure overachievers. I used to think my insecurity was a downfall and I would just hide it and try to pretend it's not there. And then someone that I really look up to told that to. I'm like, "Okay, so I'm not the only one." And it's just, I do think world is run by a bunch of people that have something to prove for a good reason or not, but it's better to embrace it than to pretend you're all confident and you're just doing this because you're brilliant.

**中文翻译:**
“世界是由缺乏安全感的高成就者（insecure overachievers）统治的。”我以前觉得我的不安全感是一个缺点，我会隐藏它，假装它不存在。后来一个我很崇拜的人告诉了我这句话。我想：“好吧，原来我不是唯一的一个。”我确实认为世界是由一群想要证明自己的人运行的，无论出于什么原因。拥抱这一点，比假装自己充满自信、只是因为聪明才做这些事要好得多。

---

### (01:09:54) Lenny

**English:**
Oh my God, so good. Final question, what is your favorite Canadian food? You live in Canada and thus the question.

**中文翻译:**
天哪，太棒了。最后一个问题，你最喜欢的加拿大食物是什么？因为你住在加拿大，所以有此一问。

---

### (01:10:02) Meltem Kuran Berkowitz

**English:**
Okay, it's not particularly food, but Caesars, they're basically Bloody Mary's with clam juice.

**中文翻译:**
好吧，它不完全是食物，而是“凯撒鸡尾酒”（Caesars），基本上就是加了蛤蜊汁的血腥玛丽。

---

### (01:10:08) Lenny

**English:**
Oh, Bloody Caesar, is that what they're called? Or just Caesar?

**中文翻译:**
噢，血腥凯撒？是这么叫吗？还是就叫凯撒？

---

### (01:10:10) Meltem Kuran Berkowitz

**English:**
They're called Caesars.

**中文翻译:**
就叫凯撒。

---

### (01:10:11) Lenny

**English:**
Just Caesar.

**中文翻译:**
就叫凯撒。

---

### (01:10:12) Meltem Kuran Berkowitz

**English:**
But the American equivalent would be a Bloody Mary. It's so much better than a Bloody Mary. It's not vegan. And then the reason I qualify it as food is when you order it in Canada, it comes with pepperoni strips and pickled asparagus, and they'll shove a whole meal in there. And it's just amazing and something that America should definitely adapt too.

**中文翻译:**
在美国对应的就是血腥玛丽。但它比血腥玛丽好喝得多。它不是素食。我之所以把它归为食物，是因为在加拿大点它时，杯子里会插着意大利腊肠条和腌芦笋，他们简直是把一整顿饭都塞进去了。这太棒了，美国绝对应该引进。

---

### (01:10:28) Lenny

**English:**
I think I've had one, I think I prefer Bloody Marys, but a good pitch for the Caesars. Meltem, thank you so much for being here. We talked about growth strategy, team building, 'Deel speed', default optimism, so many things. Really appreciate you making the time. Two final questions, where can folks find you online if they want to reach out? And how can listeners be useful to you?

**中文翻译:**
我想我喝过，我可能还是更喜欢血腥玛丽，但你对凯撒的推销很到位。Meltem，非常感谢你能来。我们聊了增长战略、团队建设、“Deel 速度”、默认乐观等等很多事情。非常感谢你抽时间。最后两个问题：如果大家想联系你，可以在哪里找到你？听众们能为你做些什么？

---

### (01:10:49) Meltem Kuran Berkowitz

**English:**
So they can reach out to me on Twitter at MeltemK, I'm the fastest to respond there. Please don't reach out to me on LinkedIn, I never respond there. And the way readers can be useful to me is if they, one, we're always looking for feedback on Deel. If you see something out there that you think could be better, let me know, and I'll make sure to communicate it to the team, whatever that may be. And also, if anybody has tips that they think I would benefit from or any good fiction book recommendations, I'm always open to them.

**中文翻译:**
大家可以在 Twitter 上找我，账号是 @MeltemK，我在那儿回复最快。请不要在 LinkedIn 上找我，我从不回复。听众可以帮到我的是：第一，我们一直在寻求关于 Deel 的反馈。如果你觉得有什么地方可以做得更好，请告诉我，我会确保传达给团队。第二，如果有人觉得有什么建议对我会有帮助，或者有好的虚构类书籍推荐，我随时欢迎。

---

### (01:11:19) Lenny

**English:**
Amazing. Meltem, thank you again so much for being here.

**中文翻译:**
太棒了。Meltem，再次感谢你的到来。

---

### (01:11:23) Meltem Kuran Berkowitz

**English:**
Thank you so much for having me.

**中文翻译:**
非常感谢你的邀请。

---

### (01:11:25) Lenny

**English:**
Bye everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
大家再见。非常感谢收听。如果你觉得本期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用上订阅。此外，请考虑给我们评分或留下评论，这能帮助其他听众发现这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。