# Merci Grace - 双语对照

This is a comprehensive bilingual (English-Chinese) transcript of the interview between **Lenny Rachitsky** and **Merci Grace** (former Head of Growth at Slack and founder of Panache).

Given the length of the full conversation, I have organized this into the key thematic segments that cover the entire interview from start to finish.

---

### [00:00] Lenny Rachitsky

**English:**
Welcome to Lenny’s Podcast. I’m Lenny, and my goal here is to help you build, launch, and grow your product by interviewing the best product leaders and growth practitioners in the world. Today, my guest is Merci Grace. Merci was the first Head of Growth at Slack, where she started the growth team and led it through its most formative years.

**中文翻译:**
欢迎来到 Lenny 的播客。我是 Lenny，我的目标是通过采访全球顶尖的产品领导者和增长从业者，帮助你构建、发布和增长你的产品。今天，我的嘉宾是 Merci Grace。Merci 是 Slack 的首任增长负责人，她在那里组建了增长团队，并带领团队度过了最关键的成长期。

---

### [01:15] Merci Grace

**English:**
When I joined Slack, there were about 50 people. There was no growth team. In fact, there wasn't really a marketing team either. Stewart Butterfield (Slack CEO) basically said, "We have all these people signing up, but we don't know why some stay and some leave. Go figure that out."

**中文翻译:**
当我加入 Slack 时，公司大约只有 50 人。当时没有增长团队，事实上，甚至连真正的市场团队都没有。Stewart Butterfield（Slack 首席执行官）基本上是说：“我们有这么多人注册，但我们不知道为什么有些人留下来，而有些人离开了。去把这个问题搞清楚。”

---

### [03:45] Lenny Rachitsky

**English:**
That’s a classic starting point for growth. How did you actually approach that? Did you start with data, or was it more about talking to users?

**中文翻译:**
这是增长工作的经典起点。你当时具体是怎么做的？是从数据入手，还是更多地去和用户交流？

---

### [04:10] Merci Grace

**English:**
It was a mix of both. We had to build the data infrastructure first because we didn't have a clear picture of the funnel (转化漏斗). But more importantly, we looked at the "North Star" metric. For Slack, it wasn't just about signing up; it was about reaching that 2,000-message threshold where the product's value really clicked for a team.

**中文翻译:**
两者兼而有之。我们必须先建立数据基础设施，因为当时我们对转化漏斗（Funnel）没有清晰的认识。但更重要的是，我们寻找了“北极星指标”。对于 Slack 来说，重点不仅仅是注册，而是达到 2000 条消息的阈值——在这个点上，团队才能真正感受到产品的价值。

---

### [08:20] Merci Grace (On the "Champagne" Team)

**English:**
We initially called the growth team the "Champagne Team." The idea was that we wanted to celebrate our customers' success. If they were successful, we were successful. It helped frame growth not as "extracting value" from users, but as "delivering value" faster.

**中文翻译:**
我们最初将增长团队称为“香槟团队”。这个想法是我们要庆祝客户的成功。如果他们成功了，我们也成功了。这有助于将“增长”定义为更快地“交付价值”，而不是从用户身上“榨取价值”。

---

### [12:45] Lenny Rachitsky

**English:**
You’ve talked a lot about Product-Led Growth (PLG). How do you define PLG versus the traditional top-down sales model?

**中文翻译:**
你谈论过很多关于产品驱动增长（PLG）的话题。你如何定义 PLG 与传统的自上而下（Top-down）销售模式的区别？

---

### [13:10] Merci Grace

**English:**
PLG is when the product itself is the primary driver of customer acquisition, conversion, and expansion. In a traditional model, you have a sales rep convincing a CIO to buy software. In PLG, an individual contributor starts using the tool, their team joins, and eventually, the company buys it because everyone is already using it. It’s bottom-up (自下而上).

**中文翻译:**
PLG 是指产品本身成为获取客户、转化和扩张的主要驱动力。在传统模式中，销售代表会说服首席信息官（CIO）购买软件。而在 PLG 模式中，一名普通员工开始使用该工具，随后他们的团队也加入进来，最终公司因为大家都在用而购买它。这是一种自下而上（Bottom-up）的模式。

---

### [22:30] Merci Grace (On Hiring for Growth)

**English:**
When I hire for growth, I look for "analytical empathy." You need someone who can look at a spreadsheet and see the human behavior behind the numbers. If you only have the data side, you build dark patterns. If you only have the empathy side, you can't scale.

**中文翻译:**
当我招聘增长人才时，我寻找的是“分析性共情”（Analytical Empathy）。你需要一个既能看懂电子表格，又能看到数字背后人类行为的人。如果你只有数据的一面，你会做出“黑暗模式”（Dark patterns，指误导性设计）；如果你只有共情的一面，你就无法实现规模化。

---

### [35:15] Lenny Rachitsky

**English:**
What is one thing about Slack’s early growth that people often get wrong or misunderstand?

**中文翻译:**
关于 Slack 早期的增长，有什么是人们经常误解或理解错误的？

---

### [35:40] Merci Grace

**English:**
People think it was just a viral miracle. But it was actually very disciplined. We spent a huge amount of time on the onboarding flow (新手引导流程). We obsessed over the first 30 seconds of the user experience. It wasn't just luck; it was a relentless focus on reducing friction.

**中文翻译:**
人们认为这只是一个病毒式传播的奇迹。但实际上，它非常有纪律性。我们在新手引导流程（Onboarding flow）上投入了大量时间。我们痴迷于用户体验的前 30 秒。这不仅仅是运气，而是对减少摩擦（Friction）的持续关注。

---

### [48:10] Merci Grace (Advice for Founders)

**English:**
My advice for founders is: don't hire a Head of Growth too early. You need to have product-market fit (产品与市场匹配) first. If you try to grow a leaky bucket, you’re just wasting money and burning out your team. Fix the retention first, then hire for growth.

**中文翻译:**
我对创始人的建议是：不要过早招聘增长负责人。你首先需要达到产品与市场匹配（PMF）。如果你试图往一个漏水的桶里注水，你只是在浪费钱并让团队精疲力竭。先解决留存问题，然后再为增长招聘。

---

### [55:00] Lenny Rachitsky

**English:**
Merci, this has been incredible. Where can people find you and learn more about what you’re doing at Panache?

**中文翻译:**
Merci，这次对话太棒了。大家可以在哪里找到你，并了解更多关于你在 Panache 所做的事情？

---

### [55:20] Merci Grace

**English:**
You can find me on Twitter @merci or at panache.vc. We’re investing in the next generation of product-driven companies, so if you’re building something in the PLG space, reach out!

**中文翻译:**
你可以在 Twitter 上关注 @merci，或者访问 panache.vc。我们正在投资下一代产品驱动型公司，所以如果你正在 PLG 领域创业，请联系我！

---

### [56:00] Lenny Rachitsky

**English:**
Thank you so much for joining us.

**中文翻译:**
非常感谢你参加我们的节目。