# Mike Maples Jr - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Mike Maples Jr.

---

### (00:00:00) Lenny Rachitsky

**English:**
You found that there's basically three elements of most breakthrough startup ideas.

**中文翻译:**
你发现大多数突破性的创业想法基本上都包含三个要素。

---

### (00:00:04) Mike Maples, Jr.

**English:**
The three are inflections, insights and then the founder future fit. Business is never a fair fight. What inflections let the founder do is wage asymmetric warfare on the present.

**中文翻译:**
这三个要素是：拐点（Inflections）、洞察（Insights）以及创始人与未来的契合度（Founder Future Fit）。商业从来不是一场公平的较量。拐点能让创始人对现状发起一场“不对称战争”。

---

### (00:00:15) Lenny Rachitsky

**English:**
You reference this term that you use occasionally, the term secret.

**中文翻译:**
你提到了一个你偶尔会用的词，即“秘密”（Secret）。

---

### (00:00:18) Mike Maples, Jr.

**English:**
The way inventions happen is people get their hands dirty, being awake to the possibility that secrets are there. If you're living in the future and you notice what's missing, your intuition about what to build is far more likely to be right.

**中文翻译:**
发明创造的方式是人们亲手去实践，并时刻觉察到秘密存在的可能性。如果你生活在未来，并注意到那里缺少了什么，那么你对于该构建什么的直觉就更有可能是正确的。

---

### (00:00:30) Lenny Rachitsky

**English:**
This connects with that stat that you shared, that 80% of your biggest returning investments came from a pivot.

**中文翻译:**
这和你分享过的一项统计数据相吻合：你回报最高的投资中，有 80% 都来自于转型（Pivot）。

---

### (00:00:35) Mike Maples, Jr.

**English:**
So startup never beats a big company by executing better. The way startups win is because it proposes a radically different future. Disorients the incumbent and chaotically moves people to that different future. The rock is the inflection, the slingshot is the insight that David shoots at Goliath. We're looking to create the conditions where we're going to get to play an unfair game by unfair rules that favor us.

**中文翻译:**
所以，初创公司永远无法通过比大公司执行得更好来取胜。初创公司获胜的方式是提出一个截然不同的未来。这会让现有的巨头失去方向，并在一片混乱中将人们带向那个不同的未来。拐点就是那块“石头”，而洞察就是大卫射向歌利亚的“弹弓”。我们寻求创造这样一种条件：让我们能够按照有利于我们的不公平规则，去玩一场不公平的游戏。

---

### (00:01:00) Lenny Rachitsky

**English:**
Today, my guest is Mike Maples Jr. Mike is a legendary early stage startup investor and with his firm, Floodgate, which was founded over 20 years ago, was one of the earliest pioneers of seed stage investing as a category. He's made early bets on transformative companies like Twitter, Lyft, Twitch, Okta, Rappi and Applied Intuition and has been on the Forbes Midas list eight times. More recently, he's been spending a lot of his time researching where great startup ideas come from and what separates the startups and founders that break through and change the world from those that don't go anywhere. After spending years reviewing his notes and decks from the thousands of startups that he's met with over the past two decades, he's uncovered three ways that breakthrough founders think differently and act differently. In our conversation, Mike shares what he's uncovered along with the pitfalls that he's seen many founders and startups fall into, how to apply these pattern breaking principles to large companies and so much more.

**中文翻译:**
今天的嘉宾是 Mike Maples Jr.。Mike 是一位传奇的早期创业投资人。他于 20 多年前创立了 Floodgate 公司，是种子轮投资这一类别的最早先驱之一。他曾对 Twitter、Lyft、Twitch、Okta、Rappi 和 Applied Intuition 等变革性公司进行过早期投资，并八次入选福布斯“迈达斯榜单”（Midas list，全球创投人榜）。最近，他投入了大量时间研究伟大的创业想法从何而来，以及那些取得突破并改变世界的初创公司和创始人，与那些毫无进展的公司之间究竟有什么区别。在查阅了过去二十年里他见过的数千家初创公司的笔记和融资演示文稿（Decks）后，他发现了突破性创始人思维和行为方式不同的三个方面。在我们的对话中，Mike 分享了他的发现，以及他看到的许多创始人和初创公司容易掉入的陷阱，还有如何将这些“打破模式”的原则应用到大公司中，以及更多精彩内容。

---

### (00:01:58) Lenny Rachitsky

**English:**
I've never seen anything like this sort of research done before on early stage investing and startups. And if you're a founder, a product builder or an investor, this will change the way that you think about building successful products. Also, as an added bonus, Mike has offered listeners of this podcast a very cool offer. If you pre-order the book at patternbreakers.com/lenny, you'll receive a second signed copy of the book for free. There are limited number of copies available of this offer, so if you're interested, I'd encourage you to place your order ASAP. The book is coming out July 9th. To take advantage of this offer, go to patternbreakers.com/lenny. With that, I bring you Mike Maples Jr. Mike, thank you so much for being here and welcome to the podcast.

**中文翻译:**
我以前从未见过针对早期投资和初创公司进行过此类研究。如果你是创始人、产品开发者或投资者，这将改变你对构建成功产品的看法。此外，作为一个额外福利，Mike 为本节目的听众提供了一个非常棒的优惠。如果你在 patternbreakers.com/lenny 预订他的新书，你将免费获得第二本签名版。此优惠名额有限，如果你感兴趣，我建议你尽快下单。这本书将于 7 月 9 日出版。要享受此优惠，请访问 patternbreakers.com/lenny。现在，让我们欢迎 Mike Maples Jr.。Mike，非常感谢你能来到这里，欢迎来到本播客。

---

### (00:02:47) Mike Maples, Jr.

**English:**
Lenny, thanks for having me. It is absolutely an honor.

**中文翻译:**
Lenny，谢谢你的邀请。这绝对是我的荣幸。

---

### (00:02:50) Lenny Rachitsky

**English:**
It's my honor. What we're going to be talking about in our conversation today is how to come up with a startup idea and how to take the first few steps to make that idea real. You have a book coming out that is exactly this, helping people understand how to do this. It's called Pattern Breakers: Why Some Start-Ups Change the Future. Let me just ask a broad question. You're very busy, very successful investor, why did you decide to write a book?

**中文翻译:**
这是我的荣幸。我们今天的谈话将围绕如何产生创业想法，以及如何迈出最初的几步让想法变成现实。你即将出版的新书正是关于这个主题，帮助人们理解如何做到这一点。书名是《模式打破者：为什么有些初创公司能改变未来》（Pattern Breakers: Why Some Start-Ups Change the Future）。我想先问一个宽泛的问题。你是一位非常忙碌且成功的投资者，为什么决定写一本书呢？

---

### (00:03:19) Mike Maples, Jr.

**English:**
Yeah, a lot of things in life. It was kind of an outgrowth of an accident and a outgrowth of being down a certain rabbit hole. So about 10 years ago, Twitch was acquired by Amazon for 970 million and we made something like 85 times our money. And normally, you'd think that's a really good thing, it was a good thing, but I had forgotten that I was even a shareholder of Twitch. So I had to go to my LPs and I had to explain to them, "Hey, I'm sorry I don't have this in my financial statements, but do you want me to restate them?" And they were all like, "Nope, we're good. Just send us the money." And some of them even sent me bottles of champagne and stuff and the good kind. Then I started to kind of feel a little bit unsettled.
(00:04:05):
So how was I shareholder and Twitch? I'd invested in a company called Justin.tv that had morphed into two companies, Socialcam and Twitch, and then Socialcam got bought. And so I just thought that was the company. I'd been investing for about 10 years and I noticed that 80% of my exit profits had gone from pivot. And I also noticed that all the ones that had seemed to do well didn't necessarily follow the best practices that everybody talked about. I didn't see the Twitter guys doing the business model canvas, for example. And I didn't see the Justin.tv Team even as they morphed into Twitch being who I would hold up as the most functioning management team I ever saw. A lot of it was pretty crazy and wild and random. And at the same time, I was helping founders shut down their companies and they had seemed to do all the right things.
(00:05:01):
They'd done the business model canvas, they'd done customer development, they'd done all the things you're supposed to do, hired well, they would've been a Harvard Business School case study except for the fact that they failed. And so the genesis of this project was really like, "Okay, should I just retire before I get exposed? Is this just all random? Am I just lucky or is there something else worth understanding?" And as I started to develop conviction about what those things were, I started to talk to people about it. A lot of people said, "Oh, you should write a book. Founders ought to see this. It'd be really valuable for their thought process in coming up with their startup ideas."

**中文翻译:**
是的，生活中的很多事情都是如此。这算是一个意外的产物，也是钻进某个“兔子洞”深入研究后的结果。大约 10 年前，Twitch 被亚马逊以 9.7 亿美元收购，我们赚了大约 85 倍。通常你会觉得这是一件大好事，确实也是好事，但我当时甚至忘了自己是 Twitch 的股东。所以我不得不去找我的有限合伙人（LPs）解释说：“嘿，抱歉我的财务报表里没这一项，你们需要我重报吗？”他们都说：“不用，没关系，把钱寄给我们就行。”有些人甚至给我寄了香槟，还是高档的那种。然后我开始感到有些不安。
(00:04:05):
我是怎么成为 Twitch 股东的呢？我投资了一家叫 Justin.tv 的公司，它后来演变成了两家公司：Socialcam 和 Twitch，然后 Socialcam 被收购了。我当时以为那就是全部了。我投资了大约 10 年，我注意到我 80% 的退出利润都来自于转型。我还注意到，所有那些看起来做得很好的公司，并不一定遵循大家都在谈论的“最佳实践”。例如，我没看到 Twitter 的创始人们画过商业模式画布（Business Model Canvas）。我也没看到 Justin.tv 团队（即使在他们演变成 Twitch 时）表现得像是我见过最职能健全的管理团队。很多情况都非常疯狂、野蛮且随机。与此同时，我还在帮助一些创始人关闭他们的公司，而他们似乎做了所有正确的事情。
(00:05:01):
他们画了商业模式画布，做了客户开发，做了所有你应该做的事情，招聘也很到位，如果不是因为失败了，他们本可以成为哈佛商学院的案例研究。所以这个项目的起源其实是：“好吧，我是不是该在被揭穿之前退休？这一切难道只是随机的吗？我只是运气好，还是有什么别的东西值得去理解？”当我开始对这些因素产生坚定的信念时，我开始和人们谈论它。很多人说：“噢，你应该写本书。创始人们应该看看这个。这对他们构思创业想法的思维过程非常有价值。”

---

### (00:05:39) Lenny Rachitsky

**English:**
[Ad for Enterpret]

**中文翻译:**
[Enterpret 广告]

---

### (00:06:22) Lenny Rachitsky

**English:**
[Ad for Anvil]

**中文翻译:**
[Anvil 广告]

---

### (00:08:10) Lenny Rachitsky

**English:**
Amazing. I'm even more excited to get into the meat of this. I was already excited. Before we get into that, just can you share a bit about the work that you did to uncover these insights? I know you have hundreds of decks of all these early-stage companies you've looked at, what is the work that went into this?

**中文翻译:**
太棒了。我对进入正题感到更加兴奋了。在深入探讨之前，你能分享一下你为了发现这些洞察所做的工作吗？我知道你手里有数百份你研究过的早期公司的演示文稿（Decks），具体做了哪些工作？

---

### (00:08:24) Mike Maples, Jr.

**English:**
Yeah, so there's a movie that came out a few years ago called Trainspotting, right? And there's these guys, these dorky old British guys in anorak coats who chart the comings and goings of trains like it's the most interesting thing in the world. They'd put it in their journals and everything. I'm that way when it comes to startups. I have a database of any startup where you would've made more than a hundred acts on your first check. And what I want to do is I want to get a time capsule for those startups. I want to understand what did it look like not after it succeeded, but what did it look like at precisely the time you would've needed to decide whether it was an interesting opportunity. So I have the original pitch deck for what was at the time called Air Bed and Breakfast, which I foolishly passed on, and you seem to have made a good career decision in joining.

**中文翻译:**
是的，几年前有一部电影叫《猜火车》（Trainspotting），对吧？里面有一些穿着派克大衣、呆头呆脑的英国老头，他们记录火车的来往，仿佛那是世界上最有趣的事情。他们会把这些记在日记里。在创业公司方面，我就是那样的人。我有一个数据库，记录了所有第一笔投资就能获得百倍以上回报的初创公司。我想做的是为这些初创公司建立一个“时间胶囊”。我想了解它们在成功之前是什么样子的，确切地说，是在你需要决定它是否是一个有趣机会的那个时刻，它是什么样子的。所以我保留了当时名为“Air Bed and Breakfast”的原始融资文稿，我当时愚蠢地错过了它，而你加入它似乎是一个明智的职业决定。

---

### (00:09:17) Lenny Rachitsky

**English:**
Later, but yeah.

**中文翻译:**
虽然是后来才加入的，但确实如此。

---

### (00:09:18) Mike Maples, Jr.

**English:**
I have the pitch deck for Pinterest. I have the pitch deck for all of these that we either passed on or said yes to. And the reason I want to do that is it's easy to misremember how things really happened. And what I find is even the founders themselves, we have a tendency to remember knowing more than we really did at the time. And so I really wanted to do the best job I could of understanding exactly what it was like, what was the origin story of this idea? How did they come up with it? If they pivoted, what caused them to pivot? When did they first start to encounter success? What was the reason for that? All those things.
(00:10:00):
And I had to be really careful in the questions that I asked because for example, you don't ask, "Why were you successful?" Because then they'll offer their reasons they thought they were successful. What you want to do is you want to say, "Okay, I noticed here's the seed pitch deck and you called the product X, but now the product's called Y. When did you make that change? Why did that happen?" And so you're trying to do the very best you can of asking a very non-judgmental set of questions that are going to give you a non-judgmental set of answers so that you can kind of be like a detective and kind of get to the root cause of why these things took off.

**中文翻译:**
我有 Pinterest 的融资文稿。我有所有这些我们要么错过、要么投了的公司的文稿。我之所以这样做，是因为人们很容易记错事情发生的真实经过。我发现即使是创始人自己，也往往倾向于认为自己当时知道的比实际知道的要多。所以我真的想尽力去理解当时到底是什么样子的：这个想法的起源故事是什么？他们是怎么想出来的？如果他们转型了，是什么导致了转型？他们什么时候开始遇到成功的？原因是什么？所有这些细节。
(00:10:00):
我在提问时必须非常小心，例如，你不能问“你为什么成功？”，因为那样他们会给出他们认为自己成功的原因。你想做的是说：“好吧，我注意到这是种子轮的融资文稿，你当时把产品叫做 X，但现在产品叫 Y。你什么时候做的这个改变？为什么会发生这个改变？”所以你要尽力提出一套非常中立的问题，从而得到一套中立的答案，这样你就能像侦探一样，找到这些事情起飞的根本原因。

---

### (00:10:46) Mike Maples, Jr.

**English:**
Yeah, I think the other thing is I just have a pretty simpatico relationship with founders usually, and so I can kind of push for the real, and they're not... I'm like, "Look, I won't share anything you don't want me to share. I'm just trying to understand." And so when you have these informal relationships... that's the other thing I learned is you try not to show up in a conference room interviewing them like a normal interview. You try to glean these facts over time with informal discussions and in the midst of talking about other things as well. And so I think that that was part of what was really valuable about the exercise was sort of the opportunity to get the unvarnished wild story of what really happened.

**中文翻译:**
是的，我觉得另一件事是，我通常和创始人的关系非常融洽，所以我可以挖掘真实的情况，而他们不会……我会说：“听着，我不会分享任何你不想让我分享的东西。我只是想理解。”所以当你拥有这些非正式关系时……这是我学到的另一件事：尽量不要出现在会议室里像普通面试一样采访他们。你要尝试通过非正式的讨论，在谈论其他事情的过程中，随着时间的推移收集这些事实。所以我认为这个过程真正有价值的部分在于，有机会获得关于真实发生的事情的、未加修饰的、狂野的故事。

---

### (00:11:33) Lenny Rachitsky

**English:**
Amazing. Okay, so let's get into it. Your book's basically broken up into two parts, how to come up with an idea and then the actions you need to get right to move forward an idea, and you have a really cool way of framing how to do this and then we'll get into it. But maybe frame these two parts real quick.

**中文翻译:**
太棒了。那我们开始吧。你的书基本上分为两个部分：如何产生想法，以及为了推进想法你需要做对哪些行动。你有一种非常酷的方式来构建如何做到这一点。也许可以快速介绍一下这两个部分。

---

### (00:11:52) Mike Maples, Jr.

**English:**
So I'll give it my best shot. I mean, the main thing is that business is never a fair fight. So the incumbents start out with an advantage, and the default is they will maintain their advantage. And so the startup has to decide that it wants to fight unfair. And so how does a startup fight unfair? It has to harness a different set of powers than are obvious to most people. For example, better doesn't matter when you're a startup, because better is an extension of the present. Better is when you think the future will resemble the present, but only be slightly different. The way startups win is by being radically different. A startup wins by avoiding the comparison trap entirely. So like when Lyft launched ride-sharing and then Uber closely followed with UberX, nobody after riding a ride-share said, "Oh, how's that different from taxis?"
(00:12:53):
It was just self-evident how different it was. And so that's what we mean by forcing a choice and not a comparison. So the startup capitalist, it turns out, is a different type of capitalist. A corporate capitalist makes money by persistently compounding, makes money by extending their advantage, makes money by having a moat, makes money by doing things well over and over again in a compounding way. Startup has none of those things. There's nothing to compound. And so the way a startup wins is they just change the subject. They deny the premise of the rules and propose something completely different. And that was the original notion behind pattern breaking was you want to have an idea that just radically breaks the pattern that can't be compared to anything that's come before, and that's when the startup has a chance to play offense.

**中文翻译:**
我尽力而为。我的意思是，核心在于商业从来不是一场公平的战斗。现有的巨头（Incumbents）一开始就拥有优势，默认情况下他们会维持这种优势。因此，初创公司必须决定它要进行一场“不公平”的战斗。那么初创公司如何进行不公平的战斗呢？它必须利用一套对大多数人来说并不明显的不同力量。例如，当你是一家初创公司时，“更好”并不重要，因为“更好”只是现状的延伸。“更好”是指你认为未来会像现在一样，只是略有不同。初创公司获胜的方式是变得“截然不同”。初创公司通过完全避开“比较陷阱”来获胜。就像 Lyft 推出共享出行，随后 Uber 紧跟着推出 UberX 时，没有人坐完共享车后会问：“噢，这和出租车有什么区别？”
(00:12:53):
它的不同之处是不言而喻的。这就是我们所说的“迫使对方做选择，而不是做比较”。事实证明，创业资本家是另一种类型的资本家。企业资本家通过持续复利赚钱，通过扩大优势赚钱，通过拥有护城河赚钱，通过一遍又一遍地把事情做好来赚钱。初创公司没有这些东西，没有什么可以复利的。所以初创公司获胜的方式就是直接“转换话题”。他们否定规则的前提，并提出完全不同的东西。这就是“模式打破”背后的初衷：你想要一个能彻底打破模式的想法，它无法与之前出现的任何东西相比，只有这样初创公司才有机会发起进攻。

---

### (00:13:48) Lenny Rachitsky

**English:**
So coming back to the two parts are coming up with the idea and the actions that you got to take. So let's dive into coming up with an idea, and this is where I want to spend most of the time because I think this is where most people get it wrong or everything starts with the idea. So I think there's a lot of meat here. And what I love about your book is you have a very succinct limited number of things that you've uncovered that are elements across successful companies, pattern breaking companies. So within the idea bucket, you found that there's basically three elements of most breakthrough startup ideas. Can you share the three and then let's talk about each one.

**中文翻译:**
回到这两个部分：产生想法和必须采取的行动。让我们深入探讨产生想法的部分，这也是我想花大部分时间的地方，因为我认为这是大多数人出错的地方，或者说一切都始于想法。我觉得这里有很多干货。我喜欢你书中的一点是，你总结出了成功公司、模式打破型公司所具备的极少数且简洁的要素。在想法这个范畴内，你发现大多数突破性创业想法基本上有三个要素。你能分享一下这三个要素吗？然后我们逐一讨论。

---

### (00:14:24) Mike Maples, Jr.

**English:**
Yeah. The three are inflections, insights and then what I call founder future fit. Or another way I phrase it is, "Is this from the future." But those are the main three things that I've observed tend to suggest breakthrough potential. And here's an important thing. You'll notice I didn't say the implementation. So one of the things that I learned is that if you have the right insight, and we'll get to some of this, you have a first mover advantage into the future. And so a lot of times your first implementation won't be right, but if your insight is correct, you can navigate the implementation to the right implementation to get product market fit. But what we need to understand is there need to be these underlying forces underneath the idea to give it the power to escape the gravitational pull of the present. That's what we want. We want a set of powers that we could observe that make it worth pursuing and make it worth navigating the product to the ultimate place.

**中文翻译:**
好的。这三个要素是：拐点（Inflections）、洞察（Insights）以及我所说的“创始人与未来的契合度”（Founder Future Fit）。或者我换种说法，就是“这是否来自未来”。这些是我观察到的往往暗示具有突破潜力的三个主要方面。这里有一点很重要：你会注意到我没提到“执行”（Implementation）。我学到的一件事是，如果你有正确的洞察（我们稍后会谈到），你就拥有了进入未来的先发优势。所以很多时候你的第一次执行可能并不正确，但如果你的洞察是正确的，你可以调整执行路径，直到找到正确的执行方式以实现产品与市场匹配（Product Market Fit）。但我们需要理解的是，想法之下必须有这些潜在的力量，赋予它逃离“现状引力”的力量。这就是我们想要的。我们想要一套可以观察到的力量，使这个想法值得追求，并值得引导产品到达最终的目标。

---

### (00:15:25) Lenny Rachitsky

**English:**
So let's talk about the first power. You call it inflections. What is an inflection? Why does it matter? What does an inflection look like?

**中文翻译:**
那我们来谈谈第一种力量。你称之为“拐点”。什么是拐点？它为什么重要？拐点看起来是什么样的？

---

### (00:15:32) Mike Maples, Jr.

**English:**
An inflection is an external event that creates the potential for radical change in how people think, feel, and act. Inflections happen external to any startup or any company for that matter. So we've brought up Lyft a little bit ago, so maybe we'll use them as an example. So the inflection that enabled Lyft was the iPhone 4s shipped with a GPS locator chip. And one of the things that that illustrates is, for example, Moore's law is not an inflection, an improvement curve is not an inflection. An inflection, I'm a little persnickety about, it's a turning point. And so in math, it's a turning point on a curve where the slope changes.
(00:16:16):
But in tech startups, it's a point in time where something new gets introduced that creates new empowerment for the first time possible. And so people talk about timing and why now? Inflections for me were the unlock. You could have had the idea for ride-sharing before the iPhone 4s, but it wouldn't have mattered because the riders and the drivers wouldn't have been able to locate each other well enough. If you'd waited too long after the iPhone 4s, it would've been obvious. And so there was this window of time, this magical moment when a new type of empowerment was possible for the first time ever. And the companies that the founders who understood that were in a position to offer that kind of empowerment in the form of a radical product that changed the future.

**中文翻译:**
拐点是一个外部事件，它创造了让人们的思维、感受和行为发生根本性改变的潜力。拐点发生在任何初创公司或任何公司之外。我们刚才提到了 Lyft，也许我们可以用它做例子。促成 Lyft 的拐点是 iPhone 4s 配备了 GPS 定位芯片。这说明了一件事，例如，摩尔定律不是拐点，改进曲线也不是拐点。我对“拐点”这个词有点挑剔，它是一个转折点。在数学中，它是曲线上斜率发生变化的转折点。
(00:16:16):
但在科技创业中，它是一个时间点，在这个时间点上，新事物的引入使得某种新的赋能（Empowerment）首次成为可能。人们常谈论时机（Timing）和“为什么是现在？”。对我来说，拐点就是那个解锁的关键。在 iPhone 4s 出现之前，你也可以有共享出行的想法，但这没用，因为乘客和司机无法足够精准地定位彼此。如果你在 iPhone 4s 出现后等太久，这个机会就变得显而易见了。所以存在这样一个时间窗口，一个神奇的时刻，一种新型的赋能有史以来第一次成为可能。那些理解这一点的创始人和公司，就能够以一种改变未来的激进产品的形式，提供这种赋能。

---

### (00:17:04) Lenny Rachitsky

**English:**
To make it even more real for people. What are some other examples of inflections either in the past, in the present?

**中文翻译:**
为了让大家更有实感，过去或现在还有哪些拐点的例子？

---

### (00:17:10) Mike Maples, Jr.

**English:**
Another example would be the cameras getting better on the smartphones, which enabled Instagram. So Instagram was at the convergence of a few inflections. First of all, there were smartphone adoptions. There were just more of them. And so they crossed like 10 million smartphones, but then you had the cameras getting a lot better. You had more of them connected on Wi-Fi. You had the networks having better upload speed for smartphones. So all those factors converged and made it possible for Instagram to offer a product that was good enough to take most of your photos with. You didn't start to think, "Oh, I need a digital camera separate from my smartphone. Now I can just use my smartphone everywhere I go." But Instagram could have come out in 2008.
(00:17:59):
It probably wouldn't have worked it probably, or it wouldn't have worked to the extent that it did. Its window of timing was just right. What are some other examples? The locator chips in the smartphones powered other companies as well, it powered DoorDash, Instacart. They had different insights which we'll get to, but there were lots of different ways to harness that power. One thing I love about inflections, and this kind of goes really old school, is just because you have a power doesn't mean you know how to use it, right? So the wheel was mounted horizontally for 500 years before somebody mounted it vertically. So originally people used the wheel to make pots, and that was a good innovation because it accelerated making pots, but then somebody decides to mount it vertically, and now you're propelling wagons and you just change transportation entirely.
(00:18:58):
And so most people don't realize that the thing that's underneath us or the thing that's in our hands or the thing that's in our pocket might have a power that when unleashed could change the future. And it's one of the very special things about founders that are great is they recognize, they notice things that we don't know. All of us tend to just follow the patterns we've always followed because most of us tend to assume that tomorrow will be similar to yesterday, but sometimes the founder will notice an inflection. And I find that kind of inspiring because inflections are all around us all the time, but most of us just don't bother to look. Most of us are so busy going about our day to day that we don't notice the emergence of a new empowering thing right under our nose or right in our pockets, but some founders do.

**中文翻译:**
另一个例子是智能手机摄像头的改进，这促成了 Instagram。Instagram 处于几个拐点的交汇处。首先是智能手机的普及，数量变多了，突破了 1000 万部大关。接着是摄像头变得好得多，更多的手机连接了 Wi-Fi，网络对智能手机的上行速度也变快了。所有这些因素汇聚在一起，使得 Instagram 能够提供一个足够好的产品，让你用它拍摄大部分照片。你不再觉得“噢，我需要一部独立于手机的数码相机”，现在你可以走到哪都只用手机。但如果 Instagram 在 2008 年推出，它可能不会成功，或者至少不会达到后来的成功程度。它的时机窗口恰到好处。
还有什么例子？智能手机中的定位芯片也助力了其他公司，比如 DoorDash 和 Instacart。他们有不同的洞察（我们稍后会谈到），但有很多不同的方式来利用这种力量。我喜欢拐点的一点是（这有点怀旧）：仅仅因为你拥有某种力量，并不意味着你知道如何使用它，对吧？轮子被水平安装了 500 年，才有人把它垂直安装。最初人们用轮子来制作陶器，这是一个很好的创新，因为它加速了陶器的制作，但后来有人决定垂直安装它，现在你可以驱动马车，彻底改变了交通运输。
所以大多数人没有意识到，我们脚下的东西、手里的东西或口袋里的东西，可能拥有一种一旦释放就能改变未来的力量。伟大创始人的特别之处在于，他们能识别并注意到我们没察觉到的事情。我们所有人都倾向于遵循一直以来的模式，因为大多数人倾向于假设明天会和昨天相似。但有时创始人会注意到一个拐点。我觉得这很令人振奋，因为拐点时刻都在我们身边，但大多数人根本不屑于去看。我们大多数人都忙于日常生活，以至于没有注意到就在我们眼皮底下或口袋里出现的新赋能事物，但有些创始人注意到了。

---

### (00:19:49) Lenny Rachitsky

**English:**
It makes me think about ChatGPT when it came out, it was sitting on top of an existing model and it just gave people a new interface to use it, and all of a sudden, everyone crazy, they're like, "Oh my God, that's the future." But it was already there. You couldn't chat with it the way that people wanted to chat.

**中文翻译:**
这让我想到了 ChatGPT 刚出来的时候，它建立在现有模型之上，只是给人们提供了一个新的交互界面，突然间所有人都疯狂了，觉得“天哪，这就是未来”。但技术其实已经在那里了，只是以前你无法以人们想要的方式与之聊天。

---

### (00:20:55) Mike Maples, Jr.

**English:**
Like Michael Saylor, once I was talking to him and he said, the Romans could have invented the printing press a lot earlier. They had sandals that would make marks in the mud. You could have, in theory, drawn the connection between those marks in the mud and the ability to have movable type and letterpress, but nobody did. And so quite often these inflections, they'll just go unrecognized for a while, but they're always there. They're always there. They're there right now. In the ambient atmosphere, there's somebody about to harness an inflection that most of us would just walk right by and never see.

**中文翻译:**
就像 Michael Saylor 曾经跟我说的，罗马人本可以更早发明印刷机。他们的凉鞋会在泥地上留下印记。理论上，你可以把泥地上的印记与活字印刷联系起来，但没人这么做。所以这些拐点经常会在一段时间内不被察觉，但它们一直都在。它们现在就在这里。在周围的环境中，正有人准备利用一个我们大多数人都会视而不见、直接走过的拐点。

---

### (00:20:55) Lenny Rachitsky

**English:**
Wow, my mind is racing, what's out there right now. Obviously AI is top of mind for a lot of people. I know you're stickler for what is an inflection, what does not? Do you consider AI an inflection?

**中文翻译:**
哇，我的脑子在飞速运转，现在外面有什么机会。显然，AI 是很多人关注的焦点。我知道你对什么是拐点、什么不是拐点非常严谨。你认为 AI 是一个拐点吗？

---

### (00:21:32) Mike Maples, Jr.

**English:**
I would say that I would probably be a little more specific about it. So I might say that certain large language models are an inflection because when I think about an inflection, and one of the things I emphasize in the book is stress tests. So it's funny, founders never really come to me and say, "Hey, can you help me come up with a good idea?" They would think they're weak sauce if they had to do that, right? So usually what's the more common occurrence is they'll say, "I've got this idea, what do you think about it?" And so what I can say to them is, "It's not my place to have an opinion, but let me just ask you, does it embody one or more inflections?"
(00:21:32):
And if it does, there's a few we could stress test that we can say, "What is the specific new thing that was just introduced? How does it empower people? How does it specifically empower specific people in specific ways? And under what conditions might that empowerment be realized? And under what conditions might it not be?" Because nuclear power has existed for a long, long time, but we haven't built any new nuclear power plants in 50 years. And so just because you have a power doesn't mean it's going to get used. It could get regulated out of existence. Customers could decide they don't want it. And so we want to answer all three things. What's the specific new thing? What is the specific form of empowerment it offers and to who?
(00:22:17):
And under what are the empowerment conditions? So like with the selection for Lyft, the inflection was the new thing was the iPhone 4s with the GPS chip, the empowerment was you can locate anyone within one meter accuracy with an algorithm, and that's going to be pretty much anybody with a smartphone. And that's a lot of people. And in order for this to be met, people are going to have to want to share their location information with applications. The government's going to have to not outlaw GPS chips and phones. Apple's going to have to keep wanting to ship GPS chips and phones. And we felt like those were pretty reasonable bets. We felt like it's pretty likely those empowerment condition will be met.

**中文翻译:**
我会说我可能会表达得更具体一些。我可能会说某些大语言模型是一个拐点，因为当我思考拐点时，我在书中强调的一点是“压力测试”。很有趣，创始人从来不会跑来跟我说：“嘿，你能帮我想个好主意吗？”如果他们需要这么做，他们会觉得自己太逊了，对吧？所以通常更常见的情况是他们会说：“我有这个想法，你觉得怎么样？”我会对他们说：“我没有资格发表意见，但让我问你，它是否体现了一个或多个拐点？”
(00:21:32):
如果是，我们可以进行几项压力测试，我们可以问：“刚刚引入的具体新事物是什么？它如何赋能人们？它如何具体地以特定方式赋能特定的人？在什么条件下这种赋能可以实现？在什么条件下不能实现？”因为核能已经存在很长时间了，但我们 50 年来都没有建造新的核电站。所以仅仅拥有某种力量并不意味着它会被使用。它可能因为监管而消失，客户可能决定他们不想要它。所以我们要回答这三件事：具体的新事物是什么？它提供什么样的具体赋能形式，以及针对谁？
(00:22:17):
赋能条件是什么？比如 Lyft 的选择，拐点是带有 GPS 芯片的 iPhone 4s 这一新事物，赋能是你可以通过算法以一米内的精度定位任何人，而这几乎涵盖了所有拥有智能手机的人，那是很多人。为了满足这一点，人们必须愿意与应用程序共享位置信息，政府必须不取缔手机中的 GPS 芯片，苹果必须继续愿意在手机中配备 GPS 芯片。我们觉得这些都是相当合理的赌注，觉得这些赋能条件很有可能被满足。

---

### (00:23:05) Mike Maples, Jr.

**English:**
I think there were a couple. The first was the shift towards user generated content and sort of internet celebrities. Justin Kan wanted to be an influencer before there was a term to describe it, right? He was really building the product that he wanted for himself. But right before Twitch or right before Justin.tv, which was the original company, Time's person of the year had been you, and they had YouTube on the cover of the magazine. And so you had, that was a major turning point in how entertainment was happening. But simultaneously, broadband penetration had reached critical mass. The CDNs were getting really good, we thought that they would get better. And so you were in a situation where the conditions to live stream video for the first time broadly over the internet were being met. Whereas you could have done that even two years before. In fact, Kyle Vought had to invent some pretty miraculous stuff to even make it work when they did. But you could see how, okay, once video starts streaming on the internet in real time, that could be a thing. You could just see how that would be a thing if it worked. And so I'd say those are the inflections. Airbnb, company close to both of our hearts for different reasons. They benefited, I think from a couple things. One was the proliferation of customer reviews online and people's trust of reviews as a substitute for trusting the brand of a hotel. But then also Facebook Connect made it possible to pass people's profile information. And so the guest and the host didn't quite seem like as much of a stranger as they might've. And so there were a few things that happened at the same time, and then the great financial crisis. And so you had people upside down on their houses needing to find some way to generate income. So all of those things came together at the same time to help Airbnb.

**中文翻译:**
我认为（Twitch）有几个拐点。第一个是向用户生成内容（UGC）和互联网名人的转变。Justin Kan 在这个词出现之前就想成为一名“网红”，对吧？他其实是在为自己打造想要的产品。但在 Twitch 或 Justin.tv（原公司）出现之前，《时代》周刊的年度人物是“你”，封面上印着 YouTube。那是娱乐方式的一个重大转折点。但与此同时，宽带普及率达到了临界质量。CDN（内容分发网络）变得非常好，我们认为它们还会变得更好。所以你处于这样一个环境中：在互联网上首次大规模直播视频的条件已经成熟。而就在两年前，这还做不到。事实上，Kyle Vogt 当时必须发明一些非常神奇的东西才能让它运转起来。但你可以预见到，一旦视频开始在互联网上实时流式传输，这可能会成为一件大事。如果它能成功，你就能预见到它的潜力。所以我说这些就是拐点。
Airbnb，这家公司因为不同的原因对我们俩都很亲近。我认为他们受益于几件事。一是网上客户评价的激增，以及人们对评价的信任取代了对酒店品牌的信任。其次，Facebook Connect 使得传递个人资料信息成为可能，这样房客和房东看起来就不再像以前那样完全是陌生人。所以几件事同时发生了，接着是全球金融危机，人们的房子资不抵债，需要寻找某种方式来产生收入。所有这些因素在同一时间汇聚在一起，成就了 Airbnb。

---

### (00:25:08) Mike Maples, Jr.

**English:**
I love that question, and I'm glad you reminded me because here's a really recent example. When the laws were changed because of shelter-in-place for telemedicine visits, it used to be illegal to do a telemedicine visit across state lines. But now all of a sudden with COVID and shelter-at-place, not only was it made legal, but it could even be reimbursed by the healthcare system. And so that's an inflection because it empowers patients to access more doctors, and it empowers doctors to access more patients, and it also changes the delivery mechanism in an empowering way.
(00:25:47):
In no event was that a technology change, that was a regulatory change that allowed technology to be empowering in new ways, but it was a specific new thing that meets that condition. It empowered specific people in specific ways, and there was a new set of empowerment conditions that ended up being made. And one of the things that we would ask at the time was, once COVID and shelter-at-place goes away, are they going to revert back to the old laws? And if they did, that would've been a problem. And so that would be the empowerment condition, but it's a fairly robust way of stress testing any inflection, right? Is to ask those three or four questions.

**中文翻译:**
我喜欢这个问题，很高兴你提醒了我，因为这里有一个非常近期的例子。当法律因为“居家令”而改变远程医疗访问时，以前跨州进行远程医疗访问是非法的。但突然间，随着新冠疫情和居家令的出现，这不仅变得合法，甚至可以由医疗保健系统报销。这就是一个拐点，因为它赋能患者接触更多医生，赋能医生接触更多患者，并以一种赋能的方式改变了交付机制。
(00:25:47):
这在任何情况下都不是技术变革，而是监管变革，它允许技术以新的方式发挥赋能作用，但它是一个满足该条件的具体新事物。它以特定方式赋能了特定人群，并且产生了一套新的赋能条件。我们当时会问的一件事是：一旦疫情和居家令结束，他们会恢复旧法律吗？如果恢复了，那就会是个问题。所以这就是赋能条件。这是对任何拐点进行压力测试的一种相当稳健的方法，对吧？就是问那三四个问题。

---

### (00:26:36) Mike Maples, Jr.

**English:**
So for example, during COVID, the amount of telemedicine visits exploded. And so as a result, there was a permanent change in people's belief about whether they would want to do a telemedicine visit. Before that, the technology was there, but a lot of people just didn't do it. The doctors didn't want to or decide to, or the patients didn't want to decide to. But now all of a sudden people were doing it, they're like, "This is much better. I'd much rather do it this way than go visit the doctor and wait in line and all that stuff." And the doctor's like, "I'd much rather do this than have these people backed up in my office." I would argue that here we are doing a podcast on a video platform, even though it's not Zoom, I would say that Zoom was another example. The idea of people working from home a reasonable number of days a week is a permanent condition, I think is another inflection that happened with COVID.

**中文翻译:**
例如，在疫情期间，远程医疗访问的数量激增。结果，人们对于是否愿意进行远程医疗访问的观念发生了永久性的改变。在那之前，技术已经存在，但很多人就是不去尝试。医生不想做，或者患者不想做。但突然间人们开始尝试了，他们觉得：“这好多了。我宁愿这样，也不愿去诊所排队。”医生也觉得：“我宁愿这样，也不愿让这些人塞满我的办公室。”我想说，我们现在正在视频平台上录制播客，虽然不是 Zoom，但我认为 Zoom 是另一个例子。人们每周在家工作合理天数的想法已经成为一种永久状态，我认为这是疫情带来的另一个拐点。

---

### (00:28:11) Mike Maples, Jr.

**English:**
Yeah, so unlike an inflection, an insight does come from the founders. An insight, I like to say, is a non-obvious truth about how one or more inflections can be harnessed to change people's behavior. So in the example that we gave earlier with Lyft, the inflection was the iPhone 4S, insight was, oh, that means you could do Airbnb for cars. And so, you had to have some type of a creative insight to see that. Now, what was non-obvious about it, or non-consensus about it, who's going to want to get in a stranger's car? That's crazy, right? And thank God ... I mean, if there's one piece of goodness about us passing on air bed and breakfast design, Anne and I were like, man, nobody's going to want to stay in a stranger's house, that's crazy. And at the time, air bed and breakfast, the host of the guest stayed in the house at the same time, and the host would feed Pop-Tarts or something like that to the guest the next morning.
(00:29:15):
This is right around the time of the Craigslist killings and stuff, where this is just scary and kind of crazy, couchsurfing as a service. But by the time we saw what was Zimride at the time, what became Lyft, Anne and I were much more prepared to believe that insight than we would've been because we'd foolishly passed on Airbnb. So that's a really important aspect of insights. So the insight needs to leverage inflections, but this is the subtle part, it needs to be non-consensus and right, not just right. So in the world of opportunities, if you're right and consensus, you still don't do that well. And an idea that is right but consensus has a couple problems to it. One is, if it's consensus, it's probably not radical enough.
(00:30:09):
Because when you think about it, human beings are conditioned to like things, and so, if everybody likes your startup idea, it means it's too similar to what they already know, what they're familiar with, which means it's probably too similar to the consensus, it's too similar to the incumbents, and so, the best startup ideas have this trait where most people don't like it or are even hostile to it, or just kind of meh about it. But some subset of people are just like, where have you been all my life? This is amazing, I love this. They fall irrationally in love with the idea.
(00:30:45):
And so, most of the great startups that I've seen have that attribute to them, and the reason is that a great startup, unlike a conventional company that proposes the future as an extension of the present, so that ... Normal companies forecast, they say, I'm going to look forward from the present and forward project what the future will be. Great founders, pattern breakers back cast, they say, it's a given that the future has to be radically different for me to be a big winner, and so, I'm going to look for radically different futures and work backwards from those radically different futures.
(00:31:23):
And so, the radically different future comes from that thinking different, thinking non-consensus. And then, it's the different actions that get you to say, okay, now I'm out in this different future, but right now, I'm all alone in this different future. I have to get people to come join me in that different future, and I have to find people who are ready to move with me to that different future. And that's where the pattern breaking actions come in.
(00:31:47):
And not everybody's going to move at first, and so, I can't waste my time with people who won't move, I can't waste any URGs of energy on anybody other than those ready to move or are about to move. And then, I need to co-create the future with those early believers. And so, great startups happen when a subset of people in this world buy into the founder's insight, and then move with them to co-create that future. And then, eventually, what was a heresy becomes the conventional wisdom as more and more people start to realize the advantage of it.

**中文翻译:**
是的，与拐点不同，洞察确实来自创始人。我喜欢说，洞察是一个关于如何利用一个或多个拐点来改变人们行为的“非显而易见的真理”。在之前 Lyft 的例子中，拐点是 iPhone 4S，洞察是：“噢，这意味着你可以做汽车版的 Airbnb”。你需要某种创造性的洞察力才能看到这一点。那么，它有什么非显而易见或非共识的地方呢？谁会想进陌生人的车？这太疯狂了，对吧？谢天谢地……我的意思是，如果说我们错过 Airbnb 有什么好处的话，那就是当时 Anne 和我觉得，天哪，没人会想住在陌生人家里，这太疯狂了。当时 Airbnb 的模式是房东和房客同时住在房子里，房东第二天早上会给房客喂 Pop-Tarts 饼干之类的东西。
(00:29:15):
那正好是 Craigslist 谋杀案频发的时候，这种“沙发客”服务听起来既吓人又疯狂。但当我们看到当时的 Zimride（后来的 Lyft）时，Anne 和我已经比以前更愿意相信那个洞察了，因为我们曾愚蠢地错过了 Airbnb。所以这是洞察的一个非常重要的方面：洞察需要杠杆化拐点，但微妙之处在于，它必须是“非共识且正确”的，而不仅仅是正确。在机会的世界里，如果你是“正确且符合共识”的，你仍然不会做得那么好。一个正确但符合共识的想法有两个问题：第一，如果它是共识，它可能不够激进。
(00:30:09):
因为仔细想想，人类天生喜欢熟悉的事物。如果每个人都喜欢你的创业想法，这意味着它与他们已经知道、熟悉的东西太相似了，这意味着它可能与共识太相似，与现有巨头太相似。因此，最好的创业想法都有这样一个特点：大多数人不喜欢它，甚至对它怀有敌意，或者只是觉得平平无奇。但有一小部分人会觉得：“你这辈子都去哪了？这太神奇了，我太喜欢了。”他们会非理性地爱上这个想法。
(00:30:45):
我见过的大多数伟大初创公司都具备这一属性。原因是，伟大的初创公司不像传统公司那样将未来视为现状的延伸。普通公司进行“预测”（Forecast），他们说：“我要从现在向后看，预测未来会是什么样子。”伟大的创始人、模式打破者进行“回溯”（Backcast），他们说：“作为一个大赢家，未来必须截然不同，这是一个前提。所以我要寻找截然不同的未来，并从那些截然不同的未来反向推导。”
(00:31:23):
这种截然不同的未来源于那种“差异化思考”和“非共识思考”。然后，是不同的行动让你能够说：“好吧，我现在身处这个不同的未来，但目前我孤身一人。我必须让人们加入我，我必须找到那些准备好和我一起搬到这个不同未来的人。”这就是“模式打破行动”发挥作用的地方。
(00:31:47):
并不是每个人一开始都会行动，所以我不能把时间浪费在那些不愿行动的人身上，我不能在除了那些准备好行动或即将行动的人之外的任何人身上浪费精力。然后，我需要与这些早期信徒共同创造未来。所以，当世界上的一小部分人认同创始人的洞察，并与他们一起行动去共同创造未来时，伟大的初创公司就诞生了。最终，曾经的“异端邪说”变成了“普遍共识”，因为越来越多的人开始意识到它的优势。

---

### (00:32:35) Mike Maples, Jr.

**English:**
So I was introduced to the guys by Michael Seibel, who was one of the co-founders of Justin.tv Twitch, and Michael introduced me to Brian Chesky before they applied to Y Combinator. So Michael's like, they're not even close to ready to apply to YC, but he thought that I maybe would think that it was the right kind of crazy. I get pitched by a lot of ... I'm not very off put by crazy ideas.
(00:33:03):
And the meeting was totally discombobulated, so room full of cereal boxes, I'm like, what's up with this? Why is there cereal here? And then, he can't get the product to work, and I'm like, okay, that's okay, let's just look at the slides. And he goes, well, Michael Seibel told me that you don't slides, you like demos. And I was like, that's true, but it's not working. So we're like, 20 minutes into this meeting in a room full of cereal boxes just looking at each other. And you can't win them all, right? You win some, you lose some.

**中文翻译:**
我是通过 Michael Seibel 认识那几个家伙的，他是 Justin.tv 和 Twitch 的联合创始人之一。Michael 在他们申请 Y Combinator 之前就把 Brian Chesky 介绍给了我。Michael 当时觉得他们还没准备好申请 YC，但他觉得我可能会认为这是一种“正确的疯狂”。我听过很多融资演讲……我并不会被疯狂的想法吓跑。
(00:33:03):
那次会议完全是一团糟，房间里堆满了麦片盒，我想：“这是怎么回事？为什么这里有麦片？”然后，他没法让产品运行起来，我说：“好吧，没关系，我们看幻灯片吧。”他说：“额，Michael Seibel 告诉我你不看幻灯片，你喜欢看演示（Demo）。”我说：“那是真的，但现在演示不了啊。”于是，在那个堆满麦片盒的房间里，我们面面相觑了 20 分钟。你不可能赢下每一场，对吧？有得必有失。

---

### (00:34:21) Mike Maples, Jr.

**English:**
Oh, I very agree. And the other great lesson is, you don't want your initial startup bets to be too big to fail. You want ideas that are small enough to fail a lot because you don't want to be attached to success, you want to be able to just try things and play with stuff and tinker with things because you don't really know where the fractal of new insight is going to reveal itself. And so, there is a little bit of play to this that I think is pretty important.

**中文翻译:**
噢，我非常同意。另一个伟大的教训是，你不要让最初的创业赌注变得“大到不能倒”。你想要那些足够小、可以多次失败的想法，因为你不想被“成功”束缚住。你希望能够尝试各种事物、摆弄各种东西、修修补补，因为你真的不知道新的洞察会在哪个分形点显现出来。所以，我认为这种“玩”的心态非常重要。

---

### (00:35:10) Mike Maples, Jr.

**English:**
And to make it even more painful, I'm in the book. Somebody called my wife Julie the other day and said, is that your husband in the Airbnb story? And we get the book, and there's a chapter, and it talks about how hard it was to raise money. And they weren't dissing on me as a dumb VC, they were like, look how bad we were at presenting this at first. It was just a complete catastrophe presentation. But that's another good lesson for me, too, I learned a very permanent lesson from that, which is, just because the presentation's good or bad, it has nothing to do with whether you should necessarily invest or not. Sometimes you have to be awake to the possibility of what it's going to be regardless of how messed up the presentation is.

**中文翻译:**
更扎心的是，我也在那本书（《Airbnb 故事》）里。前几天有人给我妻子 Julie 打电话问：“那是你丈夫在 Airbnb 的故事里吗？”我们拿到书一看，里面有一章讲融资有多难。他们并不是在嘲笑我是个愚蠢的风险投资人，他们是在说：“看我们最初展示这个项目时有多糟糕。”那简直是一场灾难级的演示。但那对我来说也是一个很好的教训，我从中得到了一个永久的启示：演示的好坏与你是否应该投资没有必然联系。有时，无论演示多么糟糕，你都必须对它未来的可能性保持清醒。

---

### (00:35:57) Mike Maples, Jr.

**English:**
Oh, this hurts to ... I think he offered me a chance to invest it at $1.5 million valuation.

**中文翻译:**
噢，这说起来真疼……我想他当时给了我一个以 150 万美元估值投资的机会。

---

### (00:36:56) Mike Maples, Jr.

**English:**
Yeah, so there's a couple of things about insights that I think are really important, and this is one of them. I believe that there can't be a recipe for breakthrough. And why is that? Well, recipes exist for things that have already been discovered, so if I give you a recipe for making a cake, somebody has probably made that cake before, the exact way they're defining it. And so, breakthroughs, though, by definition, haven't happened yet, they haven't been discovered. The general theory of relativity had to be discovered by Einstein, and the idea for ride-sharing had to be discovered by the ride-sharing companies, or Airbnb, by Chesky and Nate and those guys. And so, what you want to adopt is the right mindset. And how do you adopt the right mindset? You interact with new technologies at the cutting edge, but you actively savor surprises.
(00:37:52):
And when you think about it through the lens of a breakthrough and what we just said, it makes sense, because if you want to find a breakthrough, you want to be surprised, you want to discover the undiscovered, you want to know something you didn't know before. Because if all you do is an experiment that proves, that validates what you think, you didn't really learn anything, when you think about it, you just doubled down on your existing understanding or opinion. I learned this lesson from Scott Cook, who was the founder of Intuit. Whenever he would be presented a new product, people would present the idea to him, and he would say, what were your three biggest surprises as you were coming up with this plan? And what he would find is, quite often, they couldn't name any. And he felt like when people can't name the surprises they came up with, they're too brain locked on what they want. They have the agenda they have, they want validation, rather than truth seeking.
(00:38:51):
And so, if you're an authentic truth seeker, you're always hoping to be surprised, and you think of surprise as a gift, because you think, wow, maybe I encountered that surprise before anybody ever has. And so, that's kind of what we mean. And you want to construct your experiments so that you're in a position to be surprised. So a good example would've been what the guys at Chegg did. So Chegg was wanting to see if people would do textbook rentals, so they created a fake site called Textbook [inaudible 00:39:21]. But here's where Osman and Aayush were very savvy. Rather than just test whether people would rent a $100 dollar textbook for $35, they tested an arbitrary set of prices, all the way up to $75. And so, they had the demand preference curve at different prices. And Textbook [inaudible 00:39:42] wasn't a real site, so you'd get to the shopping cart and it would give you a 404 error.
(00:39:46):
But we could tell that people wanted to rent textbooks, and the surprise was that they would rent them for more than we thought. We thought we need to get at least 35, but some students were willing to pay 75. And so, that understanding was huge, if we'd only done an experiment to validate the hypothesis of, yes, will they rent it for 35, our pricing model would've been totally different from, oh, wow. And when you think about it, it makes sense, the student didn't want to keep the textbook. Econ 101, I'm going to give it back anyway, so 75 bucks is less than 100, I can buy beer with the extra money. So that would be an example of the surprise.

**中文翻译:**
关于洞察，我认为有几点非常重要，这就是其中之一。我相信突破是没有“配方”的。为什么呢？因为配方是为已经发现的事物准备的。如果我给你一个做蛋糕的配方，说明已经有人按这个定义做过那个蛋糕了。而突破，根据定义，是尚未发生、尚未被发现的。爱因斯坦必须发现广义相对论，共享出行的想法必须由共享出行公司发现，Airbnb 必须由 Chesky 和 Nate 他们发现。所以，你需要采取的是正确的“心态”。如何采取正确的心态？你要在最前沿与新技术互动，但要积极地“品味惊喜”。
(00:37:52):
从突破的角度来看，这很有道理。因为如果你想寻找突破，你就希望被惊喜到，你希望发现未被发现的事物，知道以前不知道的事情。因为如果你做的实验只是为了证明、验证你的想法，那你其实什么也没学到，你只是加倍强化了你现有的理解或观点。我从 Intuit 的创始人 Scott Cook 那里学到了这一课。每当有人向他展示新产品或想法时，他都会问：“在制定这个计划的过程中，你最大的三个惊喜是什么？”他发现，人们往往一个也说不出来。他觉得当人们说不出惊喜时，说明他们的思维被自己想要的东西锁死了。他们有自己的议程，他们想要的是验证，而不是寻求真理。
(00:38:51):
所以，如果你是一个真正的真理寻求者，你总是希望被惊喜到，并把惊喜视为一份礼物，因为你会想：“哇，也许我比任何人都先遇到了这个惊喜。”这就是我们的意思。你要设计你的实验，让自己处于能够遇到惊喜的位置。一个很好的例子是 Chegg 的创始人所做的。Chegg 当时想看看人们是否会租教科书，所以他们建立了一个名为 Textbook [听不清] 的虚假网站。Osman 和 Aayush 非常精明，他们不只是测试人们是否会花 35 美元租一本 100 美元的书，而是测试了一系列任意的价格，一直到 75 美元。这样他们就得到了不同价格下的需求偏好曲线。那个网站不是真的，所以当你点击购物车时，它会显示 404 错误。
(00:39:46):
但我们可以看出人们想租教科书，而惊喜在于，他们愿意支付比我们想象中更高的租金。我们以为至少要 35 美元，但有些学生愿意付 75 美元。这种理解至关重要。如果我们只做实验来验证“他们会花 35 美元租吗”这个假设，我们的定价模型就会完全不同。仔细想想，这很有道理：学生不想保留教科书，反正《经济学原理》学完也要还回去，75 美元比 100 美元便宜，省下的钱可以买啤酒。这就是“惊喜”的一个例子。

---

### (00:41:15) Mike Maples, Jr.

**English:**
So to me, secrets are earned. A lot of people, I think, have the wrong idea of what vision is. A lot of people tend to think visionaries as like, they have a special pair of binoculars, and they can look out farther than the rest of us can. But in my experience, that's not how inventions really happen, the way inventions happen is, people get their hands dirty and they learn about what's missing in the future because they're getting their hands dirty with what's new about it. And so, they earn the secret by going down this rabbit hole of exploring something at the cutting edge for its own sake.
(00:41:57):
And just like I'm a trained spotter for startups, they become a trained spotter for this new thing that they're excited about. And they frustrate the people around them, they'll be at a party, and everybody's talking about the basketball game, the Celtics against the Mavs, and somehow that reminds them of the fact that they want to test prices for textbook [inaudible 00:42:17]. But they're that interested, it's the last thing they think about when they go to bed, the first thing they think about when they wake up. And so, that's where I find most of the really great earned secrets come from, they're earned in the sense that you earn them by getting your hands dirty, and you earn them by being awake to the possibility that secrets are there or that just most people aren't looking.

**中文翻译:**
对我来说，秘密是“赢来”的（Earned）。我认为很多人对“愿景”有错误的理解。很多人倾向于认为远见卓识的人就像拥有一副特殊的望远镜，能比我们看得更远。但在我的经验中，发明并不是那样发生的。发明发生的方式是，人们亲自动手实践，通过钻研新事物来了解未来缺少了什么。因此，他们通过深入探索最前沿的事物，从而“赢得了”这个秘密。
(00:41:57):
就像我是创业公司的“火车观察员”一样，他们成了自己兴奋的新事物的“观察员”。他们会让周围的人感到挫败：在派对上，大家都在聊凯尔特人对独行侠的篮球赛，而这不知怎么地就让他们想起了要测试教科书租金价格的事。他们就是那么感兴趣，那是他们睡觉前想的最后一件事，也是醒来后想的第一件事。这就是我发现大多数伟大的“赢来的秘密”的来源：它们之所以是赢来的，是因为你通过亲身实践获得了它们，你通过觉察到秘密的存在（而大多数人根本没在看）获得了它们。

---

### (00:42:49) Mike Maples, Jr.

**English:**
That's right, and in the early days of product market fit, I like to say we want to answer a very simple but profound question. What can we uniquely offer that people are desperate for? And if we have an insight, that makes us unique. Now, if a customer doesn't like your idea, a couple of things could be true. One is, your insight could be wrong. If your insight's wrong, you don't have a startup, you should just stop. The other thing, though, that could be true is, your implementation is wrong. So you had the right insight. So like Okta, at first, they wanted to do cloud systems management, they thought that they needed to do problem resolution, but when they showed it to customers, they were kind of meh about it. And they said, well, why are you meh about this? And they said, well, it's not a top priority. And they said, what is your top priority? And they said, identity management.
(00:43:40):
So they had the right insight, which was, customers would struggle to manage cloud services, but they had the wrong implementation of the insight, so then they came back with identity management, and it worked. So if somebody doesn't like your idea, if they're not desperate for it, either the insight's wrong, the implementation's wrong, or you could be talking to the wrong customer. Some people that Okta talked to wanted to integrate it with on-prem software. And in that case, their opinion's irrelevant because they're not an innovative customer, they're not living in the future, they're not going to give you product requirement ideas that are additive to your strategy. And so, you want to be, right insight, right inflections, right implementation, right early believers that you're talking to, as you iterate towards product market fit. And if you're not succeeding at product market fit, then one or more of those variables isn't working yet.

**中文翻译:**
没错。在产品与市场匹配（PMF）的早期阶段，我喜欢说我们要回答一个非常简单但深刻的问题：我们能独特地提供什么让人们“极度渴望”的东西？如果我们有洞察，那我们就具备了独特性。现在，如果客户不喜欢你的想法，可能有几种情况。一是你的洞察可能是错的。如果洞察错了，你就没有创业项目，应该直接停止。另一种情况是，你的执行（Implementation）错了。也就是说你有正确的洞察，但做错了。比如 Okta，最初他们想做云系统管理，认为需要做问题解决，但当他们展示给客户时，客户反应平平。他们问：“为什么你们不感兴趣？”客户说：“这不是首要任务。”他们问：“那你们的首要任务是什么？”客户说：“身份管理（Identity Management）。”
(00:43:40):
所以他们有正确的洞察，即客户在管理云服务方面会遇到困难，但他们对洞察的执行方式错了。于是他们带着身份管理方案回来，结果成功了。所以如果有人不喜欢你的想法，如果他们不渴望它，要么是洞察错了，要么是执行错了，或者你找错了客户。Okta 接触的一些人想把它与本地部署（On-prem）软件集成。在这种情况下，他们的意见是无关紧要的，因为他们不是创新型客户，他们没有生活在未来，他们不会给你提供对你的战略有益的产品需求建议。所以，在向 PMF 迭代的过程中，你需要：正确的洞察、正确的拐点、正确的执行，以及正确的早期信徒。如果你还没实现 PMF，那么这些变量中至少有一个还没到位。

---

### (00:45:32) Mike Maples, Jr.

**English:**
That's right, and I would bet that this company ... I don't know enough about it, I don't know what it is, but it wouldn't surprise me if they harnessed inflections in some way that was disorienting to the incumbent. It wouldn't surprise me if they found a way to use inflections to fight an unfair fight. What I try to do with the insights is, I realized there was a theory behind it. A theory is not a recipe, it's an explanation. And what inflections let the founder do is wage asymmetric warfare on [inaudible 00:47:11]. And the insight is the vessel that they use, right? It's kind of like, the rock is the inflection, the slingshot is the insight that David shoots at Goliath. And so, that's what we're looking for, we're looking to create the conditions where we're going to get to play an unfair game by unfair rule to favor us.

**中文翻译:**
没错。我敢打赌这家公司……虽然我不够了解它，不知道它是哪家，但如果他们以某种让现有巨头失去方向的方式利用了拐点，我一点也不会感到惊讶。如果他们找到了利用拐点进行不公平战斗的方法，我也不会惊讶。我试图对洞察做的是，我意识到这背后有一个理论。理论不是配方，而是一种解释。拐点让创始人能够对现状发起不对称战争。而洞察就是他们使用的载体，对吧？这有点像：拐点是那块石头，洞察就是大卫射向歌利亚的弹弓。这就是我们所追求的：创造条件，让我们能够按照有利于我们的不公平规则去玩一场不公平的游戏。

---

### (00:47:39) Mike Maples, Jr.

**English:**
Yeah, so this is one of my favorites. So a lot of times, people will say, what makes a great founder? And there are some common traits, passion for the idea, persistence, resilience, all these things that people talk about, passion for the users. But what I find is that there's no canonical best founder. So Marc Andreessen started Netscape as a programmer making minimum wage at the University of Illinois. And everybody thought the digital highway at the time was going to come from Time Warner or from Microsoft Network or from the US government, nobody thought that some kid was going to do it from the bottoms up. But it turns out that Marc was tinkering with a set of inflections around the World Wide Web. And right around that time, Microsoft introduced a better version of Windows, and right around that time, the Pentium processor came out, so there were more and more people [inaudible 00:48:36] graphical user interface computers at the very time that browsing started to happen.
(00:48:41):
But let's take another company more recent, Applied Intuition, makes simulation software for autonomous vehicles. If you're going to sell a giant contract to the CEO of a car company, he needs to look at you across the table and think, these guys can do the job. So Qasar and Peter, they'd grown up in Detroit in Michigan, they had worked at car companies in the past, in the big three, and then, they worked inside of Google at Waymo and Google Maps. And they'd had a successful startup before, and so if you looked, what is a team from Central Casting to do this, it would be them.
(00:49:22):
And so, what I mean by Founder-Future Fit is, there's a set of traits that a founder can have that make them ideally suited to a certain type of future. Sometimes they're really young first-time founders, Mark Zuckerberg, Bill Gates, Paul Allen, we just gave the example of Marc Andreessen. In that case, usually they're at the cutting edge of a new technology and they have a beginner's mind, and they aren't even encumbered by the old way of looking things. It's like, the entire world lives in Cartesian coordinates and they discover polar coordinates, and they don't even have to translate between the two because they never understood Cartesian coordinates.
(00:50:01):
And so, in that case, their knowledge about the future is more valuable to success than their knowledge as business people. But in the case of Applied Intuition, if you're selling very large contracts to enterprise customers, they need to believe that you could do the job. If you're Okta and you're doing identity management for cloud customers, they're going to trust Todd McKinnon from Salesforce way before they're going to trust a college dropout to do that job. And so, I like to say Founder-Future Fit is, who knows the most about this future? Who has the most intrinsic motivation to pursue it? Who has the best network and keeps the best company in that ecosystem of the future? Those are the types of things that ... Founders that show up differently on those dimensions usually do better because they're more likely to understand what to build in the first place, and they're more likely to convince early believers to believe in their ideas in the first place.

**中文翻译:**
是的，这是我最喜欢的话题之一。很多时候人们会问，什么是伟大的创始人？有一些共同的特质，比如对想法的热情、坚持、韧性，以及对用户的热爱。但我发现，并没有一个标准的“最佳创始人”模板。Marc Andreessen 创立 Netscape 时，只是伊利诺伊大学一名拿最低工资的程序员。当时大家都认为“信息高速公路”会由时代华纳、微软网络或美国政府建立，没人想到一个孩子会自下而上地完成它。但事实证明，Marc 当时正在钻研万维网周围的一系列拐点。就在那时，微软推出了更好的 Windows 版本，奔腾处理器也问世了，所以在浏览器开始兴起的时候，拥有图形用户界面电脑的人越来越多。
(00:48:41):
再看一家更近的公司，Applied Intuition，它为自动驾驶汽车制作仿真软件。如果你要向一家汽车公司的 CEO 销售一份巨额合同，他需要坐在桌子对面看着你，并认为“这些家伙能胜任这项工作”。Qasar 和 Peter 在密歇根州的底特律长大，曾在“三大”汽车公司工作过，后来又在 Google 的 Waymo 和 Google 地图工作。他们之前还有过成功的创业经历。所以如果你要找一个“完美人选”团队来做这件事，那就是他们。
(00:49:22):
所以，我所说的“创始人与未来的契合度”是指，创始人具备的一系列特质使他们理想地适合某种特定的未来。有时他们是非常年轻的首次创业者，比如扎克伯格、比尔·盖茨、保罗·艾伦，还有刚才提到的 Marc Andreessen。在这种情况下，他们通常处于新技术的前沿，拥有“初学者心态”，甚至不受旧思维方式的束缚。就像全世界都生活在笛卡尔坐标系中，而他们发现了极坐标系，他们甚至不需要在两者之间进行转换，因为他们从未理解过笛卡尔坐标系。
(00:50:01):
在这种情况下，他们对未来的了解比他们的商业知识对成功更有价值。但在 Applied Intuition 的案例中，如果你向企业客户销售巨额合同，他们需要相信你能胜任。如果你是 Okta，为云客户提供身份管理，他们会信任来自 Salesforce 的 Todd McKinnon，而远非信任一个大学辍学生。所以我喜欢说，“创始人与未来的契合度”是：谁对这个未来了解最多？谁有最内在的动力去追求它？谁在未来的生态系统中拥有最好的网络和人脉？在这些维度上表现突出的创始人通常做得更好，因为他们更有可能从一开始就理解该构建什么，也更有可能说服早期信徒相信他们的想法。

---

### (00:51:05) Mike Maples, Jr.

**English:**
Yeah, Louis Pasteur once said, chance favors the prepared mind. And when I started working on this book, for the first time, I really understood what he meant. Chance favors the prepared mind because a prepared mind attracts luck. A prepared mind is better positioned to notice a breakthrough than other minds. And a prepared mind sees the breakthrough, sees around the corner, because they're thinking about the subject all the time. And so, most people think that the way you come up with good startup ideas is to try to think of a startup. And I like to say, no, that's exactly wrong, what you do to come up with great startup ideas is, you live in the future, and you notice what's missing in the future. And it's axiomatic, if you're living in the future, there will be unbuilt, missing things, because if it was all built, you'd be living in the present. And so, if you're living in the future and you notice what's missing, your intuition about what to build is far more likely to be right.
(00:52:32):
So Andreessen didn't do the Mosaic browser because he thought there was a market for browsers. He didn't even know about a digital highway, he was trying to make the internet immediately more useful for him and his team. And his intuition about what to build was very good because he was building the thing he wanted that was missing in the world. In the case of Okta, they knew all the early Salesforce customers, but the principle still applies, those customers weren't equal, they were lighthouse customers. It was kind of like when I was at Silicon Graphics, I didn't spend time with normal movie studios, I spent time with industrial Light & Magic, because I thought, if we solve their problem, they're going to take us to the Promised Land. All the stuff we build for Industrial Light & Magic will be the stuff that everybody wants someday. And so, not all customers are equal, you want to find customers that live in the future.

**中文翻译:**
是的，路易·巴斯德曾说过：“机会青睐有准备的头脑。”当我开始写这本书时，我才第一次真正理解他的意思。机会青睐有准备的头脑，因为有准备的头脑会吸引好运。有准备的头脑比其他头脑更能察觉到突破。有准备的头脑能预见突破，能看到“转角处”的情况，因为他们一直在思考这个主题。所以，大多数人认为产生好的创业想法的方法是“努力去想一个创业项目”。我想说，不，那完全错了。产生伟大创业想法的方法是：你生活在未来，并注意到未来缺少了什么。这是一个公理：如果你生活在未来，一定会有尚未建成、缺失的东西，因为如果一切都建好了，你就生活在现在了。所以，如果你生活在未来并注意到缺失了什么，你关于该构建什么的直觉就更有可能是正确的。
(00:52:32):
Andreessen 做 Mosaic 浏览器并不是因为他认为浏览器有市场。他甚至不知道什么“信息高速公路”，他只是想让互联网对他和他的团队立即变得更有用。他关于该构建什么的直觉非常好，因为他正在构建他想要但世界上缺失的东西。在 Okta 的案例中，他们认识所有早期的 Salesforce 客户，但原则仍然适用：这些客户并不平等，他们是“灯塔客户”（Lighthouse customers）。就像我在 Silicon Graphics 工作时，我不花时间在普通的电影制片厂身上，我花时间在工业光魔（Industrial Light & Magic）身上，因为我认为如果我们解决了他们的问题，他们就会带我们走向“应许之地”。我们为工业光魔构建的所有东西，总有一天会成为每个人都想要的东西。所以，并非所有客户都是平等的，你要寻找那些生活在未来的客户。

---

### (00:53:34) Mike Maples, Jr.

**English:**
Yeah, and the Justin.tv example is a great one, too, because in Justin.tv, he built the thing that he wished he had, even though it was a terrible idea. But it embodied attributes, it embodied these inflections of these insights that led them ultimately to Twitch. Ironically, Justin's second company, Atrium, most people thought that that made sense, automating legal tasks. And Justin's a great founder, but Justin just didn't like the legal field, he had no passion for it. When he started Atrium, his passion was to be a higher status founder. And I've got a podcast with him recently where he talks about this, where he's like, I wanted to be as big as Patrick Collison and Brian Chesky and Drew Houston. But it turns out, that's not a very good reason to start a company. Founder-Future Fit is ultimately about authenticity, and it's about, who is the most authentically matched for that different radical future? And whoever that team is has a really big head start at getting product market fit. And product market fit is the game, whoever gets it first wins.

**中文翻译:**
是的，Justin.tv 也是一个很好的例子。在 Justin.tv 中，他构建了他希望拥有的东西，尽管那（在当时看来）是个糟糕的主意。但它体现了一些属性，体现了那些最终引导他们走向 Twitch 的拐点和洞察。讽刺的是，杰斯汀的第二家公司 Atrium，大多数人都认为很有道理——自动化法律任务。杰斯汀是一个伟大的创始人，但他就是不喜欢法律领域，对此毫无热情。当他创办 Atrium 时，他的动力是想成为一个地位更高的创始人。我最近和他录了一期播客，他在里面谈到了这一点，他说：“我想变得像 Patrick Collison、Brian Chesky 和 Drew Houston 那样伟大。”但事实证明，这并不是创办公司的充分理由。“创始人与未来的契合度”最终关乎“真实性”（Authenticity），关乎谁与那个不同的、激进的未来最真实地匹配。无论那个团队是谁，他们在实现产品与市场匹配方面都有巨大的领先优势。而产品与市场匹配就是这场游戏的全部，谁先达到谁就赢。

---

### (00:55:28) Lenny Rachitsky

**English:**
[Ad for Webflow]

**中文翻译:**
[Webflow 广告]

---

### (00:55:52) Mike Maples, Jr.

**English:**
The number one thing I like to say is, get out of the present. And so, people talk about getting out of the building, and of course, we should, but getting out of the present is a little bit more subtle than that, right? So William Gibson was right when he said, "The future is already here. It's just not evenly distributed." So most great startup ideas come from a future that exists right now today. And so what I like to say to people, and this is a question that I always ask when I'm pitched, "Is this from the future?" And then some people will say to me like, "Hey, I have a mental health startup. Mental health is a huge problem. It needs to be solved." And I'll say, "Why is your idea from the future?" "Well in the future I believe mental health needs to be solved." I'm like, "That's not what I'm asking. I'm asking what part of the future have you been living in that gives you the right to have an opinion about the future?"
(00:56:52):
So I like to say, "If you're not living in the future, your opinion about it isn't valid." It's like saying, "I think a customer will do X." And you've never talked to a customer. I'm like, "Okay, your opinion's interesting but irrelevant." And so the only relevant opinions about the future come from people who are living in it and coming from people who understand what's new about it in a very visceral way. And there are people who do a good job of this, like Maddie Hall who started Living Carbon. She was working at Zenefit and at first she tried to think of a startup and she had ideas that weren't that good. She had a laser tag idea and a few other things. But then she decided to go follow Sam Altman for a year to be his chief of staff.
(00:57:36):
And Sam Altman visits the future multiple times a day with people. And so that's what led her to this idea that for Living Carbon, which does genetically modified trees. I mean, it couldn't be farther away from Zenefit, right? But she saw Microsoft was about to spend a lot of money, a bunch of other companies about to spend a lot of money on carbon takeout. She saw that the genetic engineering technology was getting good enough that you could engineer these trees. She married the inflections with the need and then off she went. But she was basically sampling a lot of different futures until she found one that she liked.

**中文翻译:**
我最想说的一点是：逃离现在。人们常说要“走出办公室”，这当然是对的，但“逃离现在”要微妙得多，对吧？威廉·吉布森说得对：“未来已经到来，只是分布不均。”所以大多数伟大的创业想法都源于今天已经存在的未来。我喜欢对人们说——这也是我在听融资演讲时必问的问题——“这来自未来吗？”有些人会跟我说：“嘿，我有一个心理健康创业项目。心理健康是个大问题，需要解决。”我会问：“为什么你的想法来自未来？”他们说：“因为我相信在未来，心理健康问题必须得到解决。”我会说：“我问的不是这个。我问的是，你一直生活在未来的哪个部分，让你有权对未来发表意见？”
(00:56:52):
所以我喜欢说：“如果你不生活在未来，你对未来的看法就是无效的。”这就像说“我认为客户会做 X”，但你从未和客户谈过话。我会觉得：“好吧，你的意见很有趣，但无关紧要。”关于未来的唯一相关意见来自那些生活在未来的人，来自那些以非常直观的方式理解未来新事物的人。有些人在这方面做得很好，比如创办 Living Carbon 的 Maddie Hall。她曾在 Zenefits 工作，起初她尝试构思创业项目，但想法并不好，比如激光标签游戏之类的。但后来她决定追随 Sam Altman 一年，担任他的幕僚长。
(00:57:36):
Sam Altman 每天都会和人们一起多次“造访未来”。这引导她产生了 Living Carbon 的想法，即做转基因树木。这和 Zenefits 简直天差地别，对吧？但她看到微软和许多其他公司正准备在碳移除上投入巨资。她看到基因工程技术已经成熟到可以改造这些树木。她将拐点与需求结合起来，然后就开始行动了。她基本上是在采样许多不同的未来，直到找到一个她喜欢的。

---

### (00:58:35) Mike Maples, Jr.

**English:**
Yeah. So McCracken had a term for it that I've always liked lighthouse customers. And so the lighthouse has this light that shines out and obscures the fog. And not all customers are equal and some customers are living in the future and those customers are gold. And those customers will, if you solve their needs, take you to the promise land. So yeah, you can build what's missing for yourself like Andreessen did or Zuckerberg or Steve Wozniak or Bill Gates, or you can build something for lighthouse customers you have a good relationship with. Or if you can do neither of those things, the number one question I get asked is, "Hey, that's great if you live in a supercomputer lab or if you were selling to Industrial Light or Magic or all the Salesforce customer. I'm not one of those. I'm a second year student at Stanford Business School. I'm a product manager at company X, I'm whatever the case may be. That's where the Maddie Hall example is really powerful. Because Maddie proactively got out of the present in a very intentional way. So I love her example as a case study.

**中文翻译:**
是的。McCracken 有个词我一直很喜欢，叫“灯塔客户”。灯塔发出的光芒能穿透迷雾。并非所有客户都是平等的，有些客户生活在未来，这些客户就是金矿。如果你解决了他们的需求，他们就会带你走向应许之地。所以，你可以像 Andreessen、扎克伯格、沃兹尼亚克或比尔·盖茨那样，为自己构建缺失的东西；或者你可以为你关系良好的灯塔客户构建东西。如果你这两样都做不到，我被问到最多的问题就是：“嘿，如果你住在超级计算机实验室，或者你向工业光魔或 Salesforce 的客户销售产品，那当然很好。但我不是那样的人。我是斯坦福商学院的二年级学生，或者我是 X 公司的产品经理。在这种情况下，Maddie Hall 的例子就非常有说服力。因为 Maddie 以一种非常有意识的方式主动逃离了现在。所以我非常喜欢把她的例子当作案例研究。

---

### (01:00:48) Mike Maples, Jr.

**English:**
The number one thing about the ideas goes back to the not playing the comparison game. So the thing that I see people underestimate when they come up with ideas is the threshold of desperation required in the customer. So we want to solve problems for desperate people and it's like if we have powerful inflections that really empower and we have something unique, there should be somebody who is irresistibly drawn to that empowerment. They should say, "Oh my God, this is incredible. This is a game changer. I can't unsee that." Why is that important? I like to say that if a customer has the ability to do something other than what you do to solve their problem, they won't be crazy enough to do business with a startup. So customer has to be so desperate that when they see what you have, they're like, "I've got to have it."
(01:01:47):
And so I like to say, "You want to force a choice and not a comparison." If everybody's selling apples, I can't be a 10 times better Apple. I want to be the world's first banana. And I want to say to people, " You may not want bananas, you may not like them, you may not value the advantage of bananas, but if you value banana-ness, I'm the only person that's got it." It's like, "Come to papa." And so that's like an insight feels like that. And in the early days, don't spend any of your time with people who love apples because you're not going to convince them and they're going to waste your time. What you want to do is find everybody in the world that values the advantages of bananas as soon as possible, not wasting any time on the people who don't. And so I'd say that that kind of wraps up the idea of insights is it like we want to force a choice and not a comparison. Nobody looks at the Tesla cyber truck and says, oh yeah, well how does that compare to Ford F-150? And you may hate the cyber truck, you may think it's stupid, but nobody's neutral about the cyber truck. You want to have a product that people can't be neutral about, but that the people who magnetize positively to it just can't imagine a world without.

**中文翻译:**
关于想法，最重要的一点还是要回到“不玩比较游戏”。我看到人们在构思想法时低估的一点是客户所需的“绝望阈值”。我们要为那些处于绝望中的人解决问题。如果我们有强大的、真正能赋能的拐点，并且我们有独特的东西，那么就应该有人被这种赋能不可抗拒地吸引。他们应该说：“天哪，这太不可思议了。这改变了游戏规则。我再也无法忍受没有它的日子了。”为什么这很重要？我常说，如果客户有能力通过除了你之外的其他方式解决问题，他们就不会疯狂到去和一家初创公司做生意。所以客户必须非常绝望，以至于当他们看到你的东西时，会觉得“我必须拥有它”。
(01:01:47):
所以我喜欢说：“你要迫使对方做选择，而不是做比较。”如果大家都在卖苹果，我不能做一个好 10 倍的苹果。我想成为世界上第一根香蕉。我要对人们说：“你可能不想要香蕉，你可能不喜欢香蕉，你可能不看重香蕉的优点，但如果你看重‘香蕉性’，我是唯一拥有它的人。”这就像是“快到碗里来”。洞察给人的感觉就是这样。在早期，不要把时间花在那些喜欢苹果的人身上，因为你无法说服他们，他们只会浪费你的时间。你要做的是尽快找到世界上所有看重香蕉优点的人，不要在不看重的人身上浪费任何时间。所以我想说，关于洞察的想法可以总结为：我们要迫使对方做选择，而不是做比较。没有人看着特斯拉 Cybertruck 会说：“噢，它和福特 F-150 相比怎么样？”你可能讨厌 Cybertruck，可能觉得它很蠢，但没有人对 Cybertruck 持中立态度。你想要一个让人们无法保持中立的产品，让那些被它积极吸引的人无法想象没有它的世界。

---

### (01:04:04) Mike Maples, Jr.

**English:**
Yeah, so we've talked about thinking different, but it's like the problem though is that asking people to abandon the familiar for an uncertain tomorrow is a provocative act. All startups are fundamentally disagreeable. There are disagreement with how things are done, there are disagreement with the pattern of what is. And so we need as founders to persuade others to change their habits with our pattern breaking actions. And so what the pattern breaking founder does is they create a stark dichotomy between the world that is and the world that could be. And they create an irresistible desire on the part of early believers to move to that different future with them. And so I like to say there are three aspects to acting different, right? One is the other storytelling and the other is disagreeableness.
(01:04:59):
And so the movement piece is the front and centerpiece because most people when they think of movements, they think of it as more like social movements like Civil Rights Movement and Martin Luther King, or they think of there's artistic movements like Cubism and Picasso. But fundamentally, a movement is a different way of developing a market than how most marketing people think about developing the market. Most people when they think about marketing, they think, "I've got a set of targets, I've got a set of programs. I've got inbound and outbound. I've got these things I need to do." What a movement does is it leverages a grievance of a minority against the tyranny of a majority. And it takes that and animates it in a way that those early believers are emotionally committed to moving.
(01:05:50):
So early customers are not animated by pragmatism, they're animated by belief. Early customers, early employees, early investors don't decide to go into business with you because of the practical reasons that you unlock. They do it for aesthetic reasons. They do it because they believe what you believe. And so a movement is basically a set of people with the same belief moving together to a different future. And when you think about it's equally the same, right, for the civil rights movement. And a movement is a way to crystallize the choice. If you believe in civil rights, you can't be half in on that. You either believe that it should be about the content of people's character, not their skin color. You can't be sort of not racist. You either believe or you don't believe.
(01:06:46):
The people who followed Martin Luther King bought into the aesthetically better future that his movement promised. And it turns out, and I don't mean to equate, that was a pretty important movement, right? It's like some movements are more frivolous. I say an artistic movement. But the notion is similar in that there's a set of early believers who believe they've been enlightened about something that the rest of the world doesn't get yet. And they think that the startup founder is sort of like the prime mover of that movement. And then what happens is that startup markets happen because the movements accumulate and accelerate and more and more people join them. And what was once heresy becomes the accepted conventional wisdom and now the company's no longer a startup, it's a company, and now all of a sudden it is a valid market and all of a sudden they're the status quo and they got to watch out for the next set of disruptor. So the movement is the first key thing I think in all of this.

**中文翻译:**
是的，我们谈到了“差异化思考”，但问题在于，要求人们放弃熟悉的事物去追求不确定的明天，这是一种挑衅行为。所有的初创公司从根本上说都是“不合群”的（Disagreeable）。它们不同意现有的做事方式，不同意现状的模式。因此，作为创始人，我们需要通过“模式打破行动”来说服他人改变习惯。模式打破型创始人所做的是在“现状世界”和“可能的未来世界”之间建立鲜明的对立。他们让早期信徒产生一种不可抗拒的渴望，想和他们一起搬到那个不同的未来。所以我喜欢说，“差异化行动”有三个方面：一是运动（Movement），二是讲故事（Storytelling），三是不合群/异议（Disagreeableness）。
(01:04:59):
“运动”是核心，因为大多数人想到运动时，会想到民权运动和马丁·路德·金，或者想到立体主义和毕加索等艺术运动。但从根本上说，运动是一种与大多数营销人员所想的完全不同的市场开发方式。大多数营销人员想的是：“我有一组目标，有一组程序，有入站和出站营销，有这些必须做的事。”而运动利用的是少数人对多数人暴政的不满。它将这种不满转化为动力，让那些早期信徒在情感上致力于这种迁移。
(01:05:50):
所以，早期客户不是被实用主义驱动的，而是被信仰驱动的。早期客户、早期员工、早期投资者决定与你合作，并不是因为你解锁了什么实际原因，而是因为审美原因，因为他们相信你所相信的东西。所以，运动基本上是一群拥有相同信仰的人共同迈向不同的未来。民权运动也是如此。运动是一种让选择变得清晰的方式。如果你相信民权，你不能只参与一半。你要么相信评价人应该看性格而非肤色，你要么相信，要么不信，没有“有点不种族歧视”这种说法。
(01:06:46):
追随马丁·路德·金的人认同了他的运动所承诺的那个在审美上更美好的未来。事实证明（我无意等同，那是一个非常重要的运动），有些运动可能更轻快一些，比如艺术运动。但概念是相似的：有一群早期信徒，他们相信自己洞察到了世界上其他人尚未理解的东西。他们认为创业创始人就像是那场运动的发起者。接着，初创市场就形成了，因为运动在积累和加速，越来越多的人加入。曾经的“异端邪说”变成了公认的“传统智慧”，公司不再是初创公司，而是一家成熟公司，突然间它成了一个有效的市场，成了现状，然后他们就得提防下一批颠覆者了。所以，我认为“运动”是这一切中的第一个关键点。

---

### (01:08:40) Mike Maples, Jr.

**English:**
One of my favorite examples is actually an old one, Clarence Bird's eye. So you go into the supermarket and there's frozen food aisle. Well, Clarence Bird's eye discovered how to flash freeze food when he was up in the Arctic looking at Eskimos, and they were flash freezing their fish and he wondered, could you do it for other things? And he found out you could fruit and vegetables, but it wasn't enough to just flash freeze the fish or the fruits or the vegetables. You had to convince the trains to have a refrigerated car. You had to convince the supermarket to have a refrigerated aisle. And so he had to start a movement where a whole lot of people simultaneously believed in this idea of being able to eat food in a more convenient way, not always in season, not always grown locally from where you were. And so all movements have that characteristic where you kind of start with a higher purpose and then you move people to that different future.

**中文翻译:**
我最喜欢的例子之一其实是个老例子：克拉伦斯·伯德赛（Clarence Birdseye）。你走进超市，那里有冷冻食品区。克拉伦斯·伯德赛在北极观察爱斯基摩人时发现了如何速冻食品，他们会速冻鱼，他想知道是否也可以速冻其他东西。他发现水果和蔬菜也可以，但仅仅速冻鱼或果蔬是不够的。你必须说服铁路公司配备冷藏车厢，必须说服超市设立冷藏柜台。所以他必须发起一场运动，让一大群人同时相信这个想法：能够以更方便的方式吃到食物，而不必受季节限制，也不必非得是当地种植的。所以所有的运动都有这个特点：你从一个更高的目标开始，然后把人们带向那个不同的未来。

---

### (01:10:32) Mike Maples, Jr.

**English:**
Another one that I really like is Tesla. So Tesla's mission says, "Accelerate the world's transition to sustainable energy." They don't even say they're a car company. So Tesla doesn't say, "Here's why we're better than Ford and Toyota." And this is really important, right? Because the great movements do appeal to a higher purpose. They don't say, "I'm better than company X. I'm Avis, I try harder than her." They appeal to a more aesthetically higher purpose future. And then they show that this startup is the vehicle for that movement to be actualized, which is kind of a good segue to storytelling.

**中文翻译:**
另一个我非常喜欢的是特斯拉。特斯拉的使命是“加速世界向可持续能源的转变”。他们甚至不说自己是一家汽车公司。特斯拉不会说：“这就是为什么我们比福特和丰田更好。”这非常重要，对吧？因为伟大的运动确实诉诸于更高的目标。他们不会说：“我比 X 公司更好。我是 Avis，我比她更努力。”他们诉诸于一个在审美上更高目标的未来。然后他们展示这家初创公司是实现那场运动的载体，这正好可以过渡到“讲故事”。

---

### (01:12:18) Mike Maples, Jr.

**English:**
A hundred percent. In fact, Nancy Duarte is the person who helped me understand this better than any single person. So Nancy would show me how Steve Jobs's iPhone launch speech. She'd be like, "Okay, well now notice what he does. He shows how bad phone suck now. They have styluses, they have keyboards." And then he talks about what could be, you could combine an internet communicator, you could combine an iPod, and he goes back and forth between how bad the current state of things is, how it should be, how bad it is, how it should be. Introducing the iPhone, how bad it was, how awesome it's going to be, how awesome it is. When you look at his speech, he's masterful at toggling. And by the way, the same is true. Abe Lincoln with the Gettysburg Address, "Four score and seven years ago, new nation, now we're in a civil war. We need to preserve what we stand for as a country. We need to go win this war." But he kind of goes back and forth drawing a tension between what has happened in the world that was, and the world that could be.

**中文翻译:**
百分之百正确。事实上，Nancy Duarte 是帮助我理解这一点最透彻的人。Nancy 会向我展示史蒂夫·乔布斯的 iPhone 发布会演讲。她会说：“好，现在注意他做了什么。他展示了现在的手机有多烂：它们有手写笔，有键盘。”然后他谈论“可能的样子”：你可以把互联网通讯器和 iPod 结合起来。他在“现状有多糟”和“应该是什么样”之间来回切换。介绍 iPhone 时，他说过去有多糟，未来会有多棒，现在有多棒。当你观察他的演讲时，他非常擅长这种切换。顺便说一下，林肯的《葛底斯堡演说》也是如此：“八十七年前，一个新的国家诞生；现在我们陷入内战。我们需要维护国家的立场，我们需要赢得这场战争。”他也在“过去的世界”和“可能的世界”之间来回拉扯，制造张力。

---

### (01:14:28) Mike Maples, Jr.

**English:**
Logan and John would engage in a call to adventure, "Try this ride-sharing app. It shows cars on map, you know where they're all the time, they come within five minutes, fist bumped the driver." Now, this was where the genius of the pink mustache came in. So the pink mustache honored the fact that a lot of times people resist the call. It's scary to get into stranger's car. So the pink mustache made it seem a little bit less scary. When you see these cars driving around in San Francisco, you're like, "Hmm, what's up with that pink mustache?" And you're talking to your friend and they say, "Oh, it's this new thing called Lyft. It's pretty cool. It's an app if you've seen it." And so Logan and John did, among the best I've ever seen at honoring the fact that people might resist the call.
(01:15:13):
But then part of the story is languaging. This was the genius of Twitter. They didn't call it Microblogs, Inc., right? They created a metaphor around tweeting birds. The Tesla was this way, right? It wouldn't have survived a comparison with a Porsche of 9/11. The seats weren't as good, the radio wasn't as good, but Elon was telling a story about a different future. And when you bought the Tesla Roadster, you weren't buying it for practical reasons. You were buying it for aesthetic reasons. You were buying it because you thought that that future was something you wanted to be part of. So the storytelling primitive ends up working spectacularly well for startups, right? We need to describe the world that is, we need to describe the world that could be, which is that different future. We need to understand, and this is important that your job as the founder is to be Obi-Wan, not Luke.
(01:16:04):
So the founders sometimes make the mistake of thinking that they're the hero, but they're not. The early believers are the heroes, and it's the job of the founder to tell a story that emotes early believers to want to move with them and co-create the future with them. And the story you tell an employee is different from the story you tell an investor is different from the story you tell a customer because all of them have a different idea of what their hero's journey. If you're an investor, maybe your idea of being a hero is to make a hundred times your money and be on some fancy list and make money for your LPs. If you're an early customer, maybe you're a hero by solving an important business problem and getting recognized for it in your company. If you're an early employee, maybe it's you want to work on something you're excited about with really awesome people that don't waste your time with politics and bureaucracy, all of those are different journeys. All of those are different transformational ways to self-actualize. And we have to meet those people where they are and give them a reason to want to come with us to the world to be.

**中文翻译:**
Logan 和 John（Lyft 创始人）会发起一个“冒险的召唤”：“试试这个共享出行应用。它在地图上显示车辆，你随时知道它们在哪，五分钟内就到，还能和司机碰拳。”这就是“粉色胡子”的天才之处。粉色胡子尊重了一个事实：很多时候人们会拒绝召唤。坐进陌生人的车是很可怕的。所以粉色胡子让这件事看起来没那么可怕。当你看到这些车在旧金山到处跑时，你会想：“嗯，那粉色胡子是怎么回事？”你问朋友，他们会说：“噢，这是个叫 Lyft 的新玩意。挺酷的，是个应用。”Logan 和 John 在处理“人们可能拒绝召唤”这一点上，做得比我见过的任何人都好。
(01:15:13):
故事的另一部分是语言。这就是 Twitter 的天才之处。他们没把它叫做“微博公司”（Microblogs, Inc.），对吧？他们围绕着小鸟鸣叫（Tweeting）建立了一个隐喻。特斯拉也是如此，对吧？如果和保时捷 911 相比，它根本活不下来：座椅没那么好，收音机没那么好。但马斯克在讲一个关于不同未来的故事。当你买特斯拉 Roadster 时，你不是为了实用原因买它，而是为了审美原因。你买它是因为你觉得那个未来是你想要参与其中的。所以“讲故事”这一原始动力对初创公司非常有效。我们需要描述“现状世界”，描述“可能的未来世界”。我们需要理解——这一点很重要——作为创始人，你的角色是奥比旺（Obi-Wan，导师），而不是卢克（Luke，英雄）。
(01:16:04):
创始人有时会犯错，认为自己是英雄，但其实不是。早期信徒才是英雄。创始人的工作是讲一个故事，激发早期信徒的情感，让他们愿意与你同行并共同创造未来。你对员工讲的故事、对投资者讲的故事、对客户讲的故事都是不同的，因为他们每个人对自己的“英雄之旅”都有不同的想法。如果你是投资者，你的英雄梦可能是赚 100 倍，登上某个厉害的榜单，为 LP 赚钱。如果你是早期客户，你的英雄梦可能是解决一个重要的业务问题并在公司获得认可。如果你是早期员工，你的英雄梦可能是与一群超棒的人一起做让你兴奋的事，不把时间浪费在政治和官僚主义上。这些都是不同的旅程，都是不同的自我实现方式。我们必须在他们所处的位置与他们相遇，给他们一个理由，让他们愿意和我们一起走向那个“未来的世界”。

---

### (01:18:55) Mike Maples, Jr.

**English:**
So many startups I see the first slide is like, "We're Acme AI software. We're located in San Francisco, we're funded by X and Y VCs." That's not storytelling because you're talking about yourself, right? And if you're trying to make the person in the audience the hero, they don't care about you yet. They care about how you're going to make them a hero. And so when you kind of say, 'Okay, if I'm pitching VCs, what I really need to do is help them understand why they'll be a hero if they invest in my company according to what makes them feel heroic." What you present is different, but what a lot of startup presentations do is they take their sales pitch and they rehost it for every other audience. They rehost it for the press, for investors and for employees and all that. And that's wrong because what you're doing is you're talking about yourself to different people, but what you want to do is describe the world that could be, the stakes that are involved, and then each of those individual audiences, you want to meet them where they live in the world that is, and show them how they can engage in a transformational journey to the world it could be.

**中文翻译:**
我看到很多初创公司的第一张幻灯片是：“我们是 Acme AI 软件公司，总部在旧金山，由 X 和 Y 风险投资公司投资。”这不叫讲故事，因为你是在谈论你自己，对吧？如果你想让观众成为英雄，他们现在根本不在乎你。他们在乎的是你将如何让他们成为英雄。所以当你融资时，你真正需要做的是帮助投资者理解，如果他们投资你的公司，根据他们对英雄主义的定义，他们为什么会成为英雄。你展示的内容应该是不同的。但很多初创公司的做法是把销售话术直接套用到所有受众身上：媒体、投资者、员工等等。那是错的，因为你只是在对不同的人谈论你自己。你应该做的是描述那个可能的未来世界，描述其中的利害关系，然后针对每一类受众，在他们所处的现状世界中与他们交汇，并向他们展示如何参与到通往未来世界的变革之旅中。

---

### (01:21:43) Mike Maples, Jr.

**English:**
Okay, here would be my succinct advice. And other than that, there's about a million details. Slide one, you say what you do as if I literally know nothing. So it's not, "We're Airbnb, we're a marketplace for unused residential housing space." Bad. But you'll get advice that says to do that because VCs think marketplaces are hot, residential real estate's big. What you should instead say is something like, "We're Airbnb, we let you rent an extra room in your house." Because now as the VC, I'm like, ah, I know what you do. And there are a lot of pitches, I'm 10, 15 minutes in and I'm trying to understand what they do, but I don't know. So you just say, "Here's what we do."
(01:22:26):
And the second thing that I say to people is, I think your second slide ought to be, here's the thing we know that's not obvious. So when I was raising fund one for Floodgate, I would go to an LP and say, "We believe that there's a gap between Angels and VCs. VCs are writing $5 million checks. Angels $250,000 checks. We believe that 500,000 is the new 5 million because of Lean Startups. We believe that there will be a new type of category funds called seed funds. Now, if you don't believe that, nothing else I'm about to say is going to make any sense to you, I can just give you your time back." [inaudible 01:23:06]. But then once, if they did believe that or they were in a position to lean forward, now when they start mentioning my competitors, I say, "Okay, well, recall Peter Fenton works at Benchmark, he's not going to compete with me because why would Peter Fenton leave Benchmark to start Seed Fund doesn't make sense. The only people who are going to try to compete with me from the big funds are the people who aren't performing."
(01:23:26):
But if you set the context of what your insight is, you can always come back to it. When they bring up competitors, you can always come back to it when they bring up objections and you can say, "Hey, remember I'm just telling you we need to agree on this insight for this to have a chance of being great." So what do we do? What's our insight? And then slide three is what, if any, proof points do we have? We have any customers? Do we have great founders? Is there something happened already that should cause you to believe that my insight is vowed?

**中文翻译:**
好，这是我的简洁建议。除此之外还有无数细节。第一张幻灯片：说清楚你是做什么的，假设我完全一无所知。所以不要说：“我们是 Airbnb，我们是一个闲置住宅空间市场。”这很糟糕。但你会得到建议让你这么说，因为 VC 觉得“市场”很火，“住宅房地产”很大。你应该说：“我们是 Airbnb，我们让你出租家里多余的房间。”因为作为 VC，我会想：“啊，我知道你是干什么的了。”有很多融资演讲，我听了 10 到 15 分钟还在努力理解他们到底是干什么的，但我还是不知道。所以你就直说：“这就是我们做的。”
(01:22:26):
我建议的第二件事是，第二张幻灯片应该是：这是我们知道的非显而易见的事。当我为 Floodgate 募集第一期基金时，我会去找 LP 说：“我们相信天使投资和 VC 之间存在鸿沟。VC 签 500 万美元的支票，天使签 25 万美元。由于精益创业，我们相信 50 万美元就是新的 500 万美元。我们相信会出现一种叫‘种子基金’的新类别。如果你不相信这一点，那我接下来要说的任何话对你都没有意义，我可以把时间还给你。”但一旦他们相信了，或者表现出兴趣，当他们提到我的竞争对手时，我会说：“好，请记住 Peter Fenton 在 Benchmark 工作，他不会和我竞争，因为他为什么要离开 Benchmark 去做种子基金？这没道理。大基金里唯一想和我竞争的人是那些业绩不好的人。”
(01:23:26):
如果你设定了洞察的背景，你就可以随时回到它。当他们提到竞争对手或提出异议时，你可以说：“嘿，记得吗，我只是在告诉你，我们需要在这个洞察上达成一致，这个项目才有机会变得伟大。”所以：我们是做什么的？我们的洞察是什么？然后第三张幻灯片是：我们有什么证据（如果有的话）？我们有客户吗？我们有优秀的创始人吗？是否已经发生了什么事，让你相信我的洞察是有效的？

---

### (01:24:19) Mike Maples, Jr.

**English:**
Earlier, I'd mentioned that you want to escape the comparison trap when you have your insight and when you have your idea, in creating movements and telling stories, you want to break free from the conformity trap. We always are under pressure to conform in this world, and people use the pressure of conformity to prevent us from exploring things outside of our limits. There's a book that I love called Jonathan Livingston Seagull, where there's a seagull who wants to fly at infinite speed, and all the other seagulls are like, "Look, we're just destined to eat crap off the surface of the ocean. That's just what we are. We're seagulls." He ends up getting banished from the flock because everybody thinks he's crazy. To me, the great founders are kind of like Jonathan Livingston Seagull. They're willing to pursue something that they're obsessed with, that they think has to happen in this world, and they're willing to sacrifice their status in the socioeconomic sometimes dominance hierarchy because fulfilling the mission is ultimately more important to them than fitting in.
(01:25:31):
You can't stand out if you always fit in. The only people who are different can really make a difference. That's kind of the mindset. I like to say a startup is a fundamentally disagreeable act in the first place, and there's going to be times you need to be disagreeable. I've seen this time and again. I hear people say to me, "I want to work with a founder who's coachable." I'm like, "I'm not really sure." Sometimes I used to joke that when I would meet with Ev Williams, my whole job was to give him advice that he ignored. I would say to him, "Hey, Ev. I don't think you should raise that much money, because I think you'll spend whatever you raise in 18 months, no matter how much you raise." He said, "Man, so you mean that startups almost always spend their money in 18 months regardless of the amount?" I said, "Yeah. I call it Mike's Law. It almost always happens, because once you have the money, all the pressure is on you to spend it."
(01:26:26):
He is like, "Man, that is a really good advice. I'd never thought of it that way before. That sounds right to me." Well, he proceeds to go raise a shitload of money, but he did stuff that I didn't think he should do, but it worked. I liked that in him. A lot of people would say, "Well, doesn't it bother you that he didn't listen to you that much?" No, because he was disagreeable, and he was the right kind of disagreeable. He didn't say, "Pound the sand. I'm not listening to you. La-la-la, I'm covering my ears." He listened and he understood what I thought the truth was. He just believed a different truth than I did, and that's fine. My job as the investor is to just help them see what my perception of the truth is, honestly. If they decide to go in a different direction, that's great. They're the founder, they're the genius.

**中文翻译:**
早些时候我提到，当你有了洞察和想法时，你希望逃离“比较陷阱”；而在发起运动和讲故事时，你希望摆脱“从众陷阱”。在这个世界上，我们总是面临从众的压力，人们利用这种压力来阻止我们探索极限之外的事物。我喜欢一本书叫《海鸥乔纳森》（Jonathan Livingston Seagull），里面有一只海鸥想要以无限的速度飞行，而其他海鸥都说：“听着，我们注定只能在海面上吃垃圾。这就是我们的命，我们是海鸥。”他最终被逐出了鸥群，因为大家都觉得他疯了。对我来说，伟大的创始人就像海鸥乔纳森。他们愿意追求自己痴迷的东西，追求他们认为在这个世界上必须发生的事情，他们愿意牺牲自己在社会经济地位（有时是统治阶层）中的地位，因为完成使命对他们来说最终比“合群”更重要。
(01:25:31):
如果你总是想合群，你就无法脱颖而出。只有那些不同的人才能真正改变世界。这就是那种心态。我常说，创业本身就是一种从根本上“不合群”的行为，有时候你需要表现得不合群。我一次又一次地看到这种情况。我听人们对我说：“我想找一个‘受教’（Coachable）的创始人。”我会想：“我不确定。”有时我会开玩笑说，当我见到 Ev Williams（Twitter 联合创始人）时，我的全部工作就是给他一些他会忽略的建议。我会对他说：“嘿，Ev，我觉得你不应该融那么多钱，因为我觉得无论你融多少，你都会在 18 个月内花光。”他说：“天哪，你是说初创公司无论融多少钱，几乎总是在 18 个月内花光？”我说：“是的，我称之为‘迈克定律’。这几乎总会发生，因为一旦你有了钱，所有的压力都会逼你把它花掉。”
(01:26:26):
他说：“伙计，这建议真棒。我以前从未这样想过。听起来很有道理。”结果，他还是去融了一大笔钱。他做了很多我认为他不该做的事，但成功了。我喜欢他这一点。很多人会问：“他不怎么听你的，你不介意吗？”不介意，因为他是不合群的，而且是那种“正确的不合群”。他没有说：“滚一边去，我不听你的，啦啦啦，我捂住耳朵。”他听了，也理解了我认为的真理是什么。他只是相信一个与我不同的真理，这没关系。作为投资人，我的工作只是诚实地帮助他们看到我对真理的看法。如果他们决定走向不同的方向，那太好了。他们是创始人，他们才是天才。

---

### (01:28:43) Mike Maples, Jr.

**English:**
Here's the other thing, and by the way, I listened to that episode from beginning to the end, and I thought it was fantastic, because the next thing I want to do is go to Professor Pfeffer and say, "Can we cast these seven principles through a pattern breaking lens?" Let's assume you're a startup capitalist, you're not at a company, because changing the future requires you to acquire a different form of power than you would, say, in an organization. But as I was listening to it, I was like, "These principles all apply to pattern breakers, all of them, every single one." The other one is that I think that he said, "Not everybody's going to like you. If you want to be liked, get a dog. But if you want power, there's certain things you're going to have to do and reconcile yourself with."
(01:29:36):
Acquisition of power has this notion of you've got to wield the carrot and the stick. If all you do is wield the carrot, you won't create enough activation energy for people to move to that different future. Sometimes you do have to use the stick, and sometimes you have to realize that people are going to use your desire to fit in against you. They're going to say, "Oh, you can't do that. That's illegal," or, "You can't do that, that's unethical," or, "You can't do that. You're being some tech bro, bad guy." A lot of what I find with the founders I work with, ironically, before they win, they have to have the courage to be disliked because people don't like their idea. They think it's stupid, lonely.
(01:30:20):
But then after they win, it's even worse, because everybody says you cheated or you're a bad guy or you broke the rules or you're too powerful, or, "Who gave you the right to decide what the future should be?" They get criticized unfairly in the other direction after they succeed, but in the end, it comes with the territory. It's part of the job description, unfortunately.

**中文翻译:**
还有一件事，顺便说一下，我从头到尾听了那一集（Jeffrey Pfeffer 谈权力），我觉得太棒了。我接下来想做的是去找 Pfeffer 教授说：“我们能不能通过‘模式打破’的视角来看待这七条原则？”假设你是一个创业资本家，而不是在公司里，因为改变未来需要你获得一种与在组织中不同的权力形式。但我听的时候就在想：“这些原则都适用于模式打破者，每一条都适用。”另一条是他说的：“不是每个人都会喜欢你。如果你想被喜欢，去养条狗。但如果你想要权力，有些事情你必须去做，并且必须与自己达成和解。”
(01:29:36):
权力的获取包含这样一个概念：你必须同时挥舞胡萝卜和大棒。如果你只用胡萝卜，你就无法为人们迁移到那个不同的未来创造足够的“活化能”。有时你确实得用大棒，有时你必须意识到人们会利用你“想要合群”的欲望来对付你。他们会说：“噢，你不能那样做，那是违法的，”或者“你不能那样做，那是不道德的，”或者“你不能那样做，你表现得像个科技圈的坏蛋。”讽刺的是，我发现我合作的创始人在获胜之前，必须有“被讨厌的勇气”，因为人们不喜欢他们的想法，觉得那很愚蠢、很孤单。
(01:30:20):
但当他们获胜后，情况甚至更糟，因为每个人都会说你作弊了，或者你是个坏人，或者你破坏了规则，或者你权力太大了，或者“谁给了你决定未来应该是什么样的权利？”成功后，他们会受到来自另一个方向的不公平批评。但归根结底，这是必然的结果。不幸的是，这是工作职责的一部分。

---

### (01:31:00) Mike Maples, Jr.

**English:**
Especially in startups. There have been times when I've said things like, "Execution doesn't matter," and people can misinterpret that. When I mean execution doesn't matter, I don't mean people shouldn't get things done or people shouldn't say, "What did you do this week?" But when I think of execution in a corporate sense, corporations in theory should always win. They have big management team, they have more experienced people, they have customers, suppliers, partners, brand, so a startup never beats a big company by executing better than the big company. Startup wins over the big company because it proposes a radically different future, disorients the incumbent, and sort of chaotically moves people to that different future.
(01:31:46):
But like every startup I've ever seen, on the inside was wild. It was like a capitalist mutation. It was trying to find a beaked finch in the Galapagos Islands that's never been discovered before, and it's all ambiguous all the time, and people are arguing about what the right direction is all the time. It's just messy, but movements are messy. That's what comes with the territory. A friend of mine, Robin Roberts, once said, "Make your mess your message." It's so true.

**中文翻译:**
特别是在初创公司。有时我会说“执行并不重要”之类的话，人们可能会误解。我说执行不重要，并不是说人们不应该把事情做完，或者不应该问“你这周做了什么？”但当我从企业层面思考执行时，理论上大公司应该总是赢家。他们有庞大的管理团队，有更有经验的人才，有客户、供应商、合作伙伴和品牌。所以，初创公司永远无法通过比大公司执行得更好来击败它。初创公司之所以能战胜大公司，是因为它提出了一个截然不同的未来，让现有巨头失去方向，并以一种混乱的方式将人们带向那个不同的未来。
(01:31:46):
但我见过的每一家初创公司，内部都是疯狂的。它就像一种资本主义的突变。就像在加拉帕戈斯群岛寻找一只从未被发现过的喙雀，一切始终是模糊的，人们一直在为正确的方向争论不休。这很混乱，但“运动”本身就是混乱的。这是必然的。我的一个朋友 Robin Roberts 曾说过：“把你的混乱变成你的信息（Make your mess your message）。”这太对了。

---

### (01:33:26) Mike Maples, Jr.

**English:**
But your movement is not just about the stories you tell or the guests you have or the podcasts or the write-ups you have. You have a point of view about the centrality of a product manager in companies and in businesses and in the future, and honoring that the way Nike honors athletes. The point of view is the movement, just like the point of view is the company when it's a startup. This point of view is the story. It's the place that people want to go that got animated by the beliefs that you share.

**中文翻译:**
但你的“运动”（指 Lenny 的播客和社区）不仅仅关乎你讲的故事、你邀请的嘉宾、播客或文章。你对于产品经理在公司、商业和未来中的核心地位有一种观点，并且像耐克致敬运动员一样致敬产品经理。这种观点本身就是一场运动，就像初创公司的观点就是公司本身一样。这个观点就是故事。它是人们想要去的地方，是由你分享的信念所激发的。

---

### (01:34:58) Mike Maples, Jr.

**English:**
The first thing I think is important to understand is that everything about a value delivery system when you're doing a pattern-breaking idea is different from a normal idea. The mistake that most companies make is they say, "I've got this new pattern-breaking idea. It needs to be a third of my business in 24 months or three years or whatever." Bad strategy. Let's take a company like, say, Apple, when they did the iPhone. The iPhone was a whole new thing. It was driven by, in this case, Steve Jobs the founder. You couldn't reconcile it with the original business of the Mac and not really even the iPod. You had to treat it as a totally different thing, and that's really hard for companies. Companies make the mistake of engaging in a pattern-breaking product, but they make it too visible or it's a career-limiting move if it fails. Pattern-breaking products have different types of leadership, different types of go-to-market motion as we've described, different types of ideas, different risk profiles. Instead of saying this company or this business is too big to fail, I need to make small bets that can fail a lot. The same is true with mergers and acquisitions. If I buy a company, I need to ask, am I buying a pattern-breaking company to break the pattern of my business and go in a radically new direction, or am I buying a company that's an extension of my current business? Neither is wrong per se, but the way you think about risk varies enormously.
(01:36:43):
Some examples that I have in the book of good examples are the iPhone, Steve Jobs, AWS, but some people objected. They said, "Okay, that's easy for the founders to do because they're founders of the company, and that's Steve Jobs and Jeff Bezos." The other example I like is Skunkworks with Lockheed. When they created a fighter plane in a very short amount of time, and that's how they did it, they had an organization totally separate from the main organization, somebody with absolute power, and tried to make it not visible, tried to make it be separate. Because when you make it visible, you start to drift it back into the tractor beam of acting like a pattern-matching corporation. Another good example back in the day was Don Estridge at IBM when they did the IBM PC, but it's almost always an autonomous business headed by a maverick, and you're trying to do something discreetly different rather than a better version of what you've already.

**中文翻译:**
我认为首先要理解的是，当你做一个模式打破型想法时，价值交付系统的方方面面都与普通想法不同。大多数公司犯的错误是，他们说：“我有一个新的模式打破型想法，它需要在 24 个月或三年内占到我业务的三分之一。”这是糟糕的战略。以苹果做 iPhone 为例，iPhone 是一个全新的东西，它由创始人史蒂夫·乔布斯驱动。你无法将它与 Mac 的原始业务调和，甚至与 iPod 也不行。你必须把它当作一个完全不同的东西来对待，这对公司来说非常困难。公司常犯的错误是参与模式打破型产品，但把它搞得太显眼，或者如果失败了就会限制职业发展。模式打破型产品需要不同类型的领导力、不同类型的进入市场（GTM）动作、不同类型的想法和不同的风险特征。不要说这个公司或业务“大到不能倒”，而应该进行可以多次失败的小额赌注。并购也是如此。如果我买一家公司，我需要问：我是为了打破现有业务模式并走向全新方向而买一家模式打破型公司，还是买一家现有业务的延伸公司？两者本身都没有错，但你思考风险的方式会有巨大差异。
(01:36:43):
我在书中举了一些正面例子，比如 iPhone、史蒂夫·乔布斯、AWS，但有些人反对说：“好吧，那对创始人来说很容易，因为他们是公司的创始人，那是乔布斯和贝佐斯。”我喜欢的另一个例子是洛克希德公司的“臭鼬工厂”（Skunkworks）。当他们在极短时间内研制出一架战斗机时，他们就是这么做的：建立一个完全独立于主组织的机构，由拥有绝对权力的人领导，并尽量保持低调、保持独立。因为一旦你让它变得显眼，它就会开始被吸回“模式匹配型公司”的行为轨道中。另一个老例子是 IBM 的 Don Estridge 负责 IBM PC 时。它几乎总是一个由特立独行的人领导的自治业务，你试图做一些截然不同的事情，而不是现有产品的更好版本。

---

### (01:38:49) Mike Maples, Jr.

**English:**
Any coin that says can't lose bad on one side of it might as well say, can't win big on the other side. It's your willingness to fail that lets you have breakthrough success.
(01:38:49):
Every time you depart from the consensus, there's a chance you'll be wrong, you'll underperform the consensus, but it's your willingness to do that that lets you outperform it. But there's no shortcuts, right? The coin that says can't lose, says can't win on the other side, and lose big says, win big on the other side.

**中文翻译:**
任何一面写着“不会输得很惨”的硬币，另一面必然写着“不会赢得很漂亮”。正是你对失败的容忍度，让你获得了突破性的成功。
(01:38:49):
每当你背离共识时，你都有可能出错，有可能表现不如共识，但正是你愿意这样做的态度，让你有机会超越共识。这没有捷径，对吧？写着“不能输”的硬币，另一面写着“不能赢”；而写着“可能大输”的硬币，另一面才写着“可能大赢”。

---

### (01:40:34) Mike Maples, Jr.

**English:**
A book called The Five Regrets of the Dying, Top Five Regrets of the Dying by Bronnie Ware. She was a hospice nurse, and she would talk to people in the last 90 days of their lives, and she would find out the things that they'd wish that they had done in their lives that they hadn't. I always thought that that was a good book, because it reminds you about what's important, and it reminds you that it isn't going to last forever. Someday, it'll be the last day.
(01:41:20):
There's another book that I really like called Chase, Chance, and Creativity by a guy named James Austin, and I think that it's a good book because it talks about how certain people tend to attract luck more than others and actually that luck is created, you do make luck. I am just fascinated by this idea of luck and how it can be harnessed. I'd say those two. There's a whole bunch of them. I've always liked all of Clay Christensen's books. The other one that I kind of liked that I read recently is by Robert Greene, The Laws of Human Nature. I liked that one a lot as well. Then Nancy Duarte's book, Resonate, we talked about Nancy earlier, I like that book a lot.

**中文翻译:**
一本叫《临终前最遗憾的五件事》（The Five Regrets of the Dying），作者是 Bronnie Ware。她曾是一名临终关怀护士，她会与生命最后 90 天的人交谈，了解他们一生中想做却没做的事。我一直觉得这是一本好书，因为它提醒你什么是重要的，提醒你生命不会永恒。总有一天，会是最后一天。
(01:41:20):
另一本我非常喜欢的书是 James Austin 写的《追逐、机会与创造力》（Chase, Chance, and Creativity）。我觉得这是一本好书，因为它讲述了为什么某些人比其他人更能吸引好运，以及好运实际上是可以创造的，你可以“制造”运气。我对比运气以及如何利用运气这个想法非常着迷。我就说这两本吧。其实还有很多，我一直喜欢克莱·克里斯坦森（Clay Christensen）所有的书。最近读的一本比较喜欢的是罗伯特·格林（Robert Greene）的《人性法则》（The Laws of Human Nature）。还有 Nancy Duarte 的书《共鸣》（Resonate），我们之前提到过 Nancy，我很喜欢那本书。

---

### (01:43:08) Mike Maples, Jr.

**English:**
When I was young, before I got into computers, I had a job as a professional calligrapher, and so I really like using calligraphy pens. Not long ago I sort of discovered the world, it had been a long time since I'd reconnected with that hobby, I discovered the world of vintage fountain pens. My favorite product of recent times, everybody will be like that sounds esoteric, but it's a Mont Blanc 149 first generation celluloid pen. It was right after World War II, and it was the Germans coming back saying, "We've still got it." It was just a product for the ages. It has a flexible nib. Fountain pens don't work the way they used to. They used make flexible nibs so that you could write the way scribes wrote in the 1800s and stuff. But then people in the modern world break those nibs, and they use ballpoint pens anyway. But when I use these old flexible pens from 1900 to the 1940s, they're just magical. There's just nothing like it. Nobody's ever been able to equal that experience in modern times.

**中文翻译:**
我年轻的时候，在进入计算机领域之前，我曾是一名职业书法家，所以我非常喜欢使用书法笔。不久前，我重新发现了这个领域（我已经很久没接触这个爱好了），我发现了古董钢笔的世界。我最近最喜欢的产品——大家可能会觉得这听起来很深奥——是万宝龙 149 第一代赛璐珞钢笔。那是二战刚结束后的产品，德国人通过它宣告“我们依然宝刀未老”。那是一个跨时代的产品。它有一个弹性笔尖（Flexible nib）。现在的钢笔和以前不一样了，以前会做弹性笔尖，这样你写字就能像 1800 年代的抄写员那样有粗细变化。但现代人会弄断那些笔尖，而且大家反正都用圆珠笔。但当我使用这些 1900 年代到 1940 年代的旧式弹性笔尖钢笔时，感觉非常神奇。那种体验是无可比拟的，现代没有任何产品能达到那种水平。

---

### (01:44:47) Mike Maples, Jr.

**English:**
I learned it from my dad. It sounds simple, but it's kind of profound, "Do your best." What he meant by that is he didn't mean be the best, he meant that life is a gift. You don't know how much time you're going to have. Every day is the gift of your time, and the best way to honor the gift of your time is to do your best. There'll be times you won't be the best, but if all you did was the best, that's all you could do. I remember one time, so I was a senior in high school, I'd already gotten into Stanford, I'm totally psyched, I'm going to go. Last week of the semester of senior year, and I have a test the next day in English.
(01:45:29):
My dad's like, "Hey, how are you feeling about the test?" I said, "It doesn't really matter. I get to drop it, and I'm going to get an A in the class, because I've got the goods, so I don't need to do well on it." He looked so disappointed at me, and he was like, "It doesn't sound like you're doing your best." What he was kind of getting at was that the people who achieve greatness, they think everything counts. I always got a lot from that with him. There'd be other times where I wouldn't do so well on something, and he would say, "Well, sometimes you make a careless mistake, but you did your best. That's all you could have done."
(01:46:15):
The idea of doing your best I find to be very profound, and it causes you to realize that the best way to show up in the world is to be your best self. There's only one you in this world, and the more that you can show up as your best self, you'll be impossible to compete with, you won't feel the need to copy other folks, you won't feel the need to compare yourself to other people. You'll compare yourself instead to the idea of perfection itself and whatever that means in terms of your own ability to do your best. To me, that's probably the most important life lesson I've learned.

**中文翻译:**
我是从我父亲那里学到的。听起来很简单，但很深刻：“尽力而为”（Do your best）。他的意思不是说要成为“最好的”，而是说生命是一份礼物。你不知道自己会有多少时间。每一天都是时间的馈赠，而回报这份馈赠最好的方式就是尽力而为。有时候你不会是最好的，但如果你已经尽了全力，那就是你能做的全部了。我记得有一次，我当时是高三学生，已经拿到了斯坦福的录取通知书，非常兴奋。高三最后一学期的最后一周，第二天有一场英语考试。
(01:45:29):
我爸问：“嘿，你觉得明天的考试怎么样？”我说：“没关系，我可以不计入成绩，我这门课肯定能拿 A，因为我之前的成绩够了，所以我不需要考好。”他看着我，显得非常失望，他说：“这听起来不像是你在尽力而为。”他的意思是，那些成就伟大的人，认为每一件事都很重要。我从他那里学到了很多。还有些时候我某件事没做好，他会说：“嗯，有时你会犯粗心的错误，但你已经尽力了。这就是你能做的全部。”
(01:46:15):
我觉得“尽力而为”这个想法非常深刻，它让你意识到，在这个世界上展现自我的最好方式就是成为“最好的自己”。这个世界上只有一个你，你越是能以最好的自己出现，你就越是无法被竞争，你就不需要模仿别人，不需要和别人比较。你会转而将自己与“完美”本身进行比较，无论这意味着你尽力而为的能力达到什么程度。对我来说，这可能是我学到的最重要的生活教训。

---

### (01:47:36) Mike Maples, Jr.

**English:**
I guess there's two main ways, right? Well, we've got a Substack. Not everybody's got to buy books, right, so there's patternbreakers.substack.com. Then I have a site, patternbreakers.com, but you can also get the book on Amazon or anywhere. It's already available for pre-order, I think.

**中文翻译:**
我想主要有两种方式。我们有一个 Substack 专栏，不是每个人都非得买书，所以可以关注 patternbreakers.substack.com。然后我有一个网站 patternbreakers.com，当然你也可以在亚马逊或任何地方买到这本书。我想现在已经可以预订了。

---

### (01:48:37) Lenny Rachitsky

**English:**
Thanks, Mike. It's an honor to have you on the show. Again, the book is called Pattern Breakers: Why Some Start-Ups Change the Future. Mike, thank you so much for being here.

**中文翻译:**
谢谢 Mike。很荣幸你能参加节目。再次推荐，这本书叫《模式打破者：为什么有些初创公司能改变未来》。Mike，非常感谢你的到来。