# Molly Graham - 双语对照

This is the complete bilingual transcript for Lenny’s Podcast featuring Molly Graham.

---

### [00:00:00] Lenny Rachitsky

**English:**
You've worked with many very high performing founder CEOs. Zuck, Cheryl Sandberg. Larry and Sergei at Google. Brett Taylor.

**中文翻译:**
你曾与许多表现卓越的创始人 CEO 共事过。比如扎克伯格、谢丽尔·桑德伯格，谷歌的拉里·佩奇和谢尔盖·布林，还有布雷特·泰勒。

---

### [00:00:07] Molly Graham

**English:**
Google, when I was there, felt like two PhD students paradise. Facebook felt like 19-year-old hacker's dorm room. 80% of the culture of a company is literally defined by the personality of the founder. Our job as operators or as leaders is to help articulate the culture that they're creating.

**中文翻译:**
我在谷歌的时候，那里感觉像是两个博士生的天堂。而 Facebook 感觉就像是 19 岁黑客的大学宿舍。一家公司 80% 的文化实际上是由创始人的个性定义的。我们作为运营者或领导者的职责，是帮助阐明他们正在创造的这种文化。

---

### [00:00:25] Lenny Rachitsky

**English:**
When a lot of people think Molly Graham, a lot of people think of giving away your Legos.

**中文翻译:**
当很多人想到莫莉·格雷厄姆（Molly Graham）时，就会想到“分掉你的乐高”（Giving away your Legos）这个理论。

---

### [00:00:28] Molly Graham

**English:**
You have to grow as fast as your company is growing if you really want to take advantage, both learning to give away what you've gotten good at and move on to the next shiny pile of Legos.

**中文翻译:**
如果你真的想抓住机会，你的成长速度必须和公司的发展速度一样快，既要学会把你已经擅长的事情交给别人，又要投身于下一堆闪闪发光的“新乐高”中。

---

### [00:00:39] Lenny Rachitsky

**English:**
Sarah Caldwell. She told me that the framework that helped her most in her career is something that you call the J-curve versus stairs.

**中文翻译:**
莎拉·考德威尔（Sarah Caldwell）告诉我，在她的职业生涯中对她帮助最大的框架，就是你所说的“J 型曲线 vs 阶梯型增长”。

---

### [00:00:46] Molly Graham

**English:**
So Chamath, when he pitched me on this job, actually drew me a picture on a whiteboard. He said, the way a lot of people do careers is a set of stairs. Just walk up the stairs and you'll get promoted every two years. But that is boring. The much more fun careers are like jumping off cliffs and you do fall, but then you climb out way beyond where the stairs could ever get you.

**中文翻译:**
查马斯（Chamath）在说服我接受这份工作时，真的在白板上给我画了一幅图。他说，很多人的职业生涯就像一叠阶梯，只需拾级而上，每两年升职一次。但那很无聊。更有趣的职业生涯就像跳下悬崖——你确实会下坠，但随后你会攀爬到阶梯永远无法触及的高度。

---

### [00:01:08] Lenny Rachitsky

**English:**
Today, my guest is Molly Graham. Molly was an early employee at Google, also at Facebook, where she worked closely with Zuck on building the Chan Zuckerberg initiative. She also worked with Brett Taylor on scaling Quip, which he sold to Salesforce. She's also worked with hundreds of companies and founders helping them grow into the leaders that they want to become. Today, she leads Glue Club, which is a community for leaders operating in changing, growing environments who want to develop themselves as quickly as their companies. Molly is maybe most known for her advice to give away your Legos, which we chat about. Along with basically all of her favorite frameworks and mindsets and pieces of advice that she's developed and collected over time. For leaders who are going through rapid scale and growth and are just struggling to keep up. I think of this episode as a high growth handbook for leaders who are experiencing rapid scale.

**中文翻译:**
今天的嘉宾是莫莉·格雷厄姆。莫莉曾是谷歌和 Facebook 的早期员工，在 Facebook 期间，她与扎克伯格密切合作创建了“陈-扎克伯格倡议”（CZI）。她还曾与布雷特·泰勒（Brett Taylor）合作扩张 Quip，该公司后来卖给了 Salesforce。她还与数百家公司和创始人合作，帮助他们成长为理想的领导者。如今，她领导着 Glue Club，这是一个为在多变、增长的环境中工作的领导者建立的社区，旨在帮助他们像公司一样快速提升自我。莫莉最出名的建议或许就是“分掉你的乐高”，我们今天会聊到这个。此外，我们还会探讨她多年来开发和收集的所有核心框架、心态和建议。对于那些正经历快速扩张、努力跟上节奏的领导者来说，我认为这一集就是一份为处于高速增长期的领导者准备的“高增长手册”。

---

### [00:01:58] Lenny Rachitsky

**English:**
We cover the J curves versus stairs approach to career growth, the waterline model, and why you want to snorkel before you scuba. Her six rules for creating goals and building alignment, her rules of thumb for dealing with rapid scale and lots of change. The biggest lessons she's learned from Zuck and Sergei and Larry and Cheryl and Brett Taylor and so much more. Molly is incredible and you will be a better leader after listening to this episode. A huge thank you to Eric Antonow, Ashley Murphy and Sarah Caldwell for suggesting topics and questions for this conversation. If you enjoy this podcast, don't forget to subscribe and follow it on your favorite podcasting app or YouTube. It helps tremendously. And if you become an annual subscriber of my newsletter, you get 19 incredible products for free for an entire year. Including, Lovable, Replit, Bold, gamma, Innate and Linear, Devon, Posttalk, Superhuman descript, Whisper Flow, Perplexity. Warp, Granola, Magic Patterns, Raycast, ChapiRD, Mobbit, and Stripe Atlas. Head on over to lennysnewsletter.com and click product pass. With that, I bring you Molly Graham after a short word from our sponsors.

**中文翻译:**
我们讨论了职业成长的“J 型曲线 vs 阶梯”法、“水位线模型”（Waterline Model），以及为什么在深潜（Scuba）之前要先浮潜（Snorkel）。还有她制定目标和达成共识的六条规则，以及应对快速扩张和剧烈变化的经验法则。她从扎克伯格、谢尔盖、拉里、谢丽尔和布雷特·泰勒那里学到的最深刻教训等等。莫莉非常出色，听完这一集后，你一定会成为更好的领导者。非常感谢 Eric Antonow、Ashley Murphy 和 Sarah Caldwell 为本次对话提供的建议和问题。如果你喜欢这个播客，别忘了在播客应用或 YouTube 上订阅和关注，这对我们帮助很大。如果你成为我时事通讯的年度订阅者，你将免费获得 19 款不可思议的产品一年，包括 Lovable, Replit, Perplexity, Stripe Atlas 等。请访问 lennysnewsletter.com 并点击“Product Pass”。在听完赞助商的简短介绍后，我们将正式开始与莫莉·格雷厄姆的对话。

---

### [00:03:01] Lenny Rachitsky

**English:**
Today's episode is brought to you by DX, the developer intelligence platform designed by leading researchers. To thrive in the AI era, organizations need to adapt quickly. But many organization leaders struggle to answer pressing questions like, which tools are working? How are they being used? What's actually driving value? DX provides the data and insights that leaders need to navigate this shift. With DX, companies like Dropbox, booking.com, Addien, and Intercom get a deep understanding of how AI is providing value to their developers. And what impact AI is having on engineering productivity. To learn more, visit DX's website at getdx.com/lenny. That's getdx.com/lenny.
If you're a founder, the hardest part of starting a company isn't having the idea. It's scaling the business without getting buried in back office work. That's where Brex comes in. Brex is the intelligent finance platform for founders. With Brex, you get high limit corporate cards, easy banking, high yield treasury, plus a team of AI agents that handle manual finance tasks for you. They'll do all the stuff that you don't want to do, like file your expenses, scour transactions for waste, and run reports all according to your rules. With Brex's AI agents, you can move faster while staying in full control. One in three startups in the United States already runs on Brex. You can too at brex.com. Molly, thank you so much for being here and welcome to the podcast.

**中文翻译:**
本期节目由 DX 赞助，这是由顶尖研究人员设计的开发者情报平台。为了在 AI 时代蓬勃发展，组织需要快速适应。但许多领导者难以回答紧迫的问题，例如：哪些工具奏效了？它们是如何被使用的？什么才是真正的价值驱动力？DX 为领导者提供了应对这一转变所需的数据和见解。通过 DX，Dropbox、booking.com 等公司可以深入了解 AI 如何为开发者提供价值，以及 AI 对工程生产力的影响。欲了解更多信息，请访问 getdx.com/lenny。
如果你是创始人，创业最难的部分不是构思，而是在不被后台琐事淹没的情况下扩张业务。这就是 Brex 的用武之地。Brex 是为创始人打造的智能财务平台。通过 Brex，你可以获得高额度企业卡、便捷的银行业务、高收益国库管理，以及一组为你处理手动财务任务的 AI 代理。它们会处理你不愿做的所有事情，如报销、清理浪费的交易、运行报告等。借助 Brex 的 AI 代理，你可以在保持完全控制的同时跑得更快。美国三分之一的初创公司已经在使用 Brex。你也可以在 brex.com 加入他们。莫莉，非常感谢你能来，欢迎来到播客。

---

### [00:04:36] Molly Graham

**English:**
Thanks, Lenny. I'm excited to be here.

**中文翻译:**
谢谢，兰尼。很高兴能来到这里。

---

### [00:04:38] Lenny Rachitsky

**English:**
I feel like this conversation was in an inevitability. I feel like you're the kind of guest where it's like, we will do this someday. I'm such a fan of your stuff. I've read all the stuff you've put out there over the years. We're going to be talking about the best frameworks and mindsets that you've developed over the years that have been really helpful to you, to founders, to companies that you've worked with to help them with growth and scale and change and all the stuff that comes with success. The way I think about this, I want to make this the greatest hits of Molly Graham.

**中文翻译:**
我觉得这次对话是必然会发生的。你就是那种“总有一天我们会聊聊”的嘉宾。我是你的忠实粉丝，读过你多年来发表的所有内容。今天我们将讨论你多年来开发的、对你、对创始人以及你合作过的公司非常有帮助的最佳框架和心态，帮助他们应对增长、扩张、变革以及成功带来的一切。我的想法是，把这一集做成“莫莉·格雷厄姆的作品精选集”。

---

### [00:05:06] Molly Graham

**English:**
Love it.

**中文翻译:**
太棒了。

---

### [00:05:08] Lenny Rachitsky

**English:**
And so I sourced what I think are the greatest hits from a lot of colleagues that you've worked with, a lot of people you've worked with. We've chatted about the stuff that you find other people find most helpful. So we're going to be going through all that stuff. But let's help people understand why they should listen to this advice. What's kind of the backstory on these frameworks? Where did they come from? Where did you develop them? Tell us that story.

**中文翻译:**
所以我从很多与你共事过的同事和伙伴那里搜集了这些“精选作品”。我们也聊过你觉得别人认为最有用的东西。所以我们会一一过一遍。但首先，让我们帮听众理解为什么要听这些建议。这些框架背后的故事是什么？它们从何而来？你是如何开发出它们的？给我们讲讲那个故事吧。

---

### [00:05:29] Molly Graham

**English:**
So first of all, Ami Vora, who you have had on your podcast, once said to me that all advice is just someone telling you what they did. And I always think about that. Because I really think that basically what I tell people is I've made every single mistake in the book. And then I got to the end of the book and I started inventing new mistakes. So mostly what I feel is that I like sharing my stories because I want to help people. I want to help people not make the same mistakes I did. And I also want to help people make sense of what they're experiencing. But I started in tech in 2007. I actually started at Google the week the iPhone launched and a lot of my scaling battle scars come from a couple of experiences. They come from a year and a half at Google, which is not very long.

**中文翻译:**
首先，你播客请过的嘉宾 Ami Vora 曾对我说过，所有的建议其实都只是某人在告诉你他们做了什么。我经常思考这句话。因为我真的觉得，我告诉别人的基本上就是：我犯过书上写过的每一个错误，等我把那本书翻完了，我又开始发明新的错误。所以我分享故事主要是想帮助别人，帮他们避免重蹈我的覆辙，也帮他们理清自己正在经历的事情。我 2007 年进入科技行业，在 iPhone 发布的那一周入职谷歌。我关于业务扩张的许多“战伤”都源于几段经历。首先是在谷歌的一年半，时间不算长。

---

### [00:06:17] Molly Graham

**English:**
(00:06:17):
And Google was pretty big when I was there. It has thousands of employees. But my department, which was the communications department, was 25 people when I joined and it grew in nine months to 125 people. And that was really my first experience with just all the sort of things that I still talk about today. In terms of what it feels like to grow really, really fast and sort of all the tools that I started developing from there. After Google, I left and followed Cheryl Sandberg and Elliot Schrage to Facebook. And I spent five years at Facebook. And I joined Facebook in 2008, and it's important context because it was 80 million users at the time. We were smaller than MySpace. It was 270 million in revenue, 500 employees. It did not feel inevitable. Most people thought we were going to sell it to Microsoft. When I told people I was going there, they were like, isn't that place just like a site for college kids? And so I was there for five years and it was a crazy five years.

**中文翻译:**
我在谷歌时，它已经很大了，有数千名员工。但我所在的公关部门（Communications Department）在我加入时只有 25 人，九个月内就增长到了 125 人。那是我第一次真正体验到我今天仍在谈论的那些事情——关于极速增长是什么感觉，以及我从那时起开始开发的各种工具。离开谷歌后，我跟随谢丽尔·桑德伯格和埃利奥特·施拉格去了 Facebook。我在 Facebook 待了五年。我是 2008 年加入的，当时的背景很重要：那时只有 8000 万用户，规模比 MySpace 还小，年收入 2.7 亿美元，500 名员工。当时并不觉得成功是必然的，大多数人认为我们会把它卖给微软。当我告诉别人我要去那里时，他们会说：“那不就是个给大学生玩的网站吗？”我在那里待了五年，那是疯狂的五年。

---

### [00:07:22] Molly Graham

**English:**
When I left, it was 5,500 employees, five billion in revenue, over a billion users. So a huge amount of what I experienced, what I write about, what I talk about in Glue Club, which is the community that I run, comes from that rapid scale at Google and Facebook. But I also, I left Facebook right after we went public, about six months after we went public. And I only like doing jobs that I'm highly unqualified for. I like being on learning curves so steep that I'm scared I'm going to fall off. And so I left and I wanted to learn what it took to build something from nothing. And so I joined this little startup founded by Brett Taylor, a startup called Quip. I joined a couple of months before we launched and ran everything that wasn't product and engineering there for him. And that was such a valuable experience to me because the experience of building something from nothing is actually quite different than the experience of holding on for dear life while things are scaling so fast around you.

**中文翻译:**
当我离开时，Facebook 已经有 5500 名员工，50 亿收入，超过 10 亿用户。所以我经历的、写的、以及在我运营的 Glue Club 社区里谈论的大部分内容，都源于在谷歌和 Facebook 的那段快速扩张期。我在 Facebook 上市大约六个月后离开了。我只喜欢做那些我“完全不胜任”的工作，我喜欢处于那种陡峭到让我担心会掉下来的学习曲线上。所以我离开了，想学习如何从无到有地建立一些东西。于是我加入了布雷特·泰勒创办的一家小初创公司 Quip。我在产品发布前几个月加入，负责除了产品和工程以外的所有事务。那对我来说是一次极其宝贵的经历，因为“从零到一”的经验与那种“在周围事物飞速扩张时拼命坚持”的经验是完全不同的。

---

### [00:08:27] Molly Graham

**English:**
And it really taught me about all the tools and skills you need to go from zero to one and then from one to two and how lonely it can be to build something. And we eventually sold that company to Salesforce. And then again, only take jobs I'm highly unqualified for. But the last really chaotic scaling experience I had was actually helping Mark Zuckerberg and Priscilla Chan start their philanthropy, the Chan Zuckerberg Initiative. And I basically helped them for the first two years of its existence or its sort of like first full existence. And philanthropy sounds calm. You know what I mean? We're like, oh, giving money away. Must be so peaceful over there. And CZI grew from, I think the week I joined, it was 30 people and we bought two companies that week and it grew to 250 people that year. And it was like using every single tool in my toolkit that I had taken from every other job that I'd had.

**中文翻译:**
它教会了我从 0 到 1 再到 2 所需的所有工具和技能，以及创造过程是多么孤独。最终我们将公司卖给了 Salesforce。接着，我再次选择了我不胜任的工作。我最后一次经历的混乱扩张期，是帮助马克·扎克伯格和普莉希拉·陈创办他们的慈善机构——陈-扎克伯格倡议（CZI）。我在它成立的前两年里协助他们。慈善事业听起来很平静，对吧？大家会觉得“哦，捐钱嘛，那里一定很安详”。但我加入的那周，CZI 只有 30 人，那周我们收购了两家公司，一年内就增长到了 250 人。那感觉就像是在动用我从之前每一份工作中积累的所有工具。

---

### [00:09:22] Molly Graham

**English:**
So my advice and frameworks, like I said, come from having made a lot of mistakes. But I've also sort of made a personal study over the last 18 years, believe it or not. Essentially what does it take to thrive inside growing and changing companies, not just to hang on for dear life. What does it take to lead in the face of constant change? And really the other piece that I find truly fascinating is what genuinely makes the difference between a business that grows but then plateaus versus these generational businesses. The ones that go on forever. Sort of the difference between a Twitter or MySpace and a Facebook. Billions in revenue versus hundreds of billions in revenue. So what I like to do is take my experience and use it to help other leaders. I want to give people tools that work. And I also want to be honest about how hard all of this stuff really is.

**中文翻译:**
所以我的建议和框架，正如我所说，源于犯过的许多错误。但在过去的 18 年里，信不信由你，我也做了一些个人研究。本质上，在不断成长和变化的公司中，不仅是“拼命坚持”，还需要什么才能“蓬勃发展”？面对不断的变革，领导力意味着什么？另一个让我着迷的点是，那些增长后陷入停滞的企业与那些“代际企业”（能长盛不衰的企业）之间真正的区别是什么？就像 Twitter 或 MySpace 与 Facebook 之间的区别——是数十亿收入与数千亿收入的区别。所以我喜欢利用我的经验来帮助其他领导者。我想给人们提供有效的工具，也想诚实地告诉大家，这些事情到底有多难。

---

### [00:10:24] Lenny Rachitsky

**English:**
Amazing. I say this a lot in this podcast. I just love the ROI that listeners of the podcast get. You spent 20 years toiling, struggling, working so hard, learning so much. And you're just here, here's all the answers that I've learned. And obviously not all the answers, but so many things that will help people avoid the pain and suffering that you've gone through.

**中文翻译:**
太棒了。我在播客里经常说，我非常喜欢听众获得的这种投资回报率（ROI）。你花了 20 年辛勤耕耘、奋斗、努力工作并学到了这么多。现在你坐在这里说：“这就是我学到的所有答案。”显然不是全部答案，但有很多东西能帮助人们避免你曾经历过的痛苦和折磨。

---

### [00:10:43] Molly Graham

**English:**
That's the goal.

**中文翻译:**
这就是我的目标。

---

### [00:10:45] Lenny Rachitsky

**English:**
Also, a couple quick threads I want to follow here. One is Ami Vora, who you mentioned. She's now, I think, head of product at Anthropic.
**Molly Graham:** Yes.
**Lenny Rachitsky:** Amazing. Former podcast guest, also speaker at Lenny and Friends Summit two years ago. This other point you just made about how you've always gone to places that have been way beyond your... I forget how you phrased it, but just beyond your current capabilities almost. And were very difficult. I just had Matt McGinnis on the podcast. He's CEO at Rippling, now CPO at Rippling, and just recorded an episode with him. And he had this really powerful quote that if you're ever comfortable at work and feel like, oh, I got this, you're making a huge mistake. Something's going terribly wrong. That's not where you want to be.

**中文翻译:**
另外，我想跟进几个点。一个是提到过的 Ami Vora，她现在应该是 Anthropic 的产品负责人。
**莫莉·格雷厄姆：** 是的。
**兰尼·拉奇茨基：** 太棒了。她以前也是播客嘉宾，两年前还在“Lenny and Friends”峰会上演讲过。另一个点是你刚才提到的，你总是去那些远超你……我忘了你怎么形容的，几乎是超出你当前能力范围的地方，而且非常困难。我刚请过 Matt McGinnis 上播客，他是 Rippling 的 CEO，现在是 CPO。他有一句非常有力量的话：如果你在工作中感到舒适，觉得“哦，我搞定了”，那你就在犯一个巨大的错误。肯定有什么地方出了大问题。那不是你应该待的地方。

---

### [00:11:23] Molly Graham

**English:**
Yeah. I always say I get bored really easily, which is both a strength and probably my greatest weakness. So I like being scared.

**中文翻译:**
是的。我总说我很容易感到无聊，这既是优点，也可能是我最大的弱点。所以我喜欢那种“害怕”的感觉。

---

### [00:11:30] Lenny Rachitsky

**English:**
Okay. So let's actually dive into some of your greatest hits of frameworks. And the greatest of all greats, when a lot of people think Molly Graham, a lot of people think of giving away your Legos. Some people haven't heard of this, many people have, so let's cover this. What is this advice of giving away your Legos?

**中文翻译:**
好，那我们深入探讨一下你那些“精选框架”。其中最经典的一个，很多人一想到莫莉·格雷厄姆，就会想到“分掉你的乐高”。有些人还没听过，但很多人听过，所以我们来聊聊。这个建议到底是什么意思？

---

### [00:11:47] Molly Graham

**English:**
So this definitely started in my experience at Google. And then Facebook was a masterclass in giving away the Legos. But the way I like to talk about it is basically when I watch leaders and employees go through rapid scale, I like to think of somebody putting down a giant pile of Legos in front of a bunch of kindergartners and then just being like, build something. And that's sort of what it feels like when you start. It's like, well, there's so many Legos and it's so fun. There's a lot of opportunity, but it's also kind of scary and overwhelming. And you're like, there's so many Legos. What do I do? Isn't there an instruction manual hidden under this pile somewhere? But then you start building and you're like, oh, okay. You build something and then you take it apart and then you put it back together.

**中文翻译:**
这肯定始于我在谷歌的经历，而 Facebook 则是“分掉乐高”的高级课程。我喜欢这样描述：当我观察领导者和员工经历快速扩张时，我喜欢想象有人在一群幼儿园小朋友面前放了一大堆乐高积木，然后说：“建点什么吧。”刚开始的感觉就是这样。乐高这么多，太好玩了，机会也很多，但同时也让人害怕和不知所措。你会想：“这么多乐高，我该怎么办？这堆积木下面是不是藏着说明书？”但接着你开始搭建，你会觉得：“哦，好吧。”你搭好一个东西，拆掉，再重新组装。

---

### [00:12:33] Molly Graham

**English:**
And then eventually you start to get momentum and you're like, okay, it's like I'm building a house. I got this. It's a house. All right, great. And then you're like, I'm good at building houses. I was put on earth to build houses. And almost assuredly inside of scaling companies, as soon as you're like, I feel good at this and I should do this forever. Somebody's going to show up and be like, okay, it's not a house. It's a neighborhood. And you need to take this house that's kind of half built and you're going to pass it off to this other person that we just hired. And you are going to go build dog parks and streets and other things that are entirely unhouse-like. And what happens when someone does that to you is you're like, wait a minute. First of all, I'm not done with this house. And I'm worried that this person's going to screw it up.

**中文翻译:**
最终你开始有了势头，你会想：“好的，就像我在盖房子。我搞定了，这是一座房子。太棒了。”然后你会觉得：“我擅长盖房子，我生来就是为了盖房子的。”而在扩张中的公司里，几乎可以肯定的是，一旦你觉得“我擅长这个，我要永远做下去”，就会有人出现说：“好的，现在不是盖一座房子，而是要建一个社区。你需要把这座盖了一半的房子交给这个刚入职的新人，而你去负责建造狗公园、街道和其他完全不像房子的东西。”当别人对你这么做时，你会想：“等一下。首先，我这房子还没盖完呢。而且我担心这家伙会把它搞砸。”

---

### [00:13:18] Molly Graham

**English:**
I'm also worried that building houses is actually the most fun thing and that I'm going to give the Legos to that person and they're going to have all the fun work and I'm going to hate building dog parks. Or that dog parks are irrelevant eventually and it's going to turn out we're in the house building business. So there's this incredible set of emotions that come territorialistic, paired with excitement. Fear paired with joy. But eventually you pass the house off and then you go work on neighborhoods and you're sort of like, okay, dog parks, I'm good at dog parks. I got this. And then again, you get to the like, I'm great. I was put on earth to build neighborhoods. And immediately someone shows up and says, it's not a neighborhood. It's a country or a city or a world. And it just goes on and on and on.

**中文翻译:**
我还会担心盖房子其实才是最有趣的事，如果我把乐高给了那个人，他们就会接手所有有趣的工作，而我会讨厌建狗公园。或者担心狗公园最终根本不重要，结果证明我们其实是做盖房子生意的。所以会产生一系列复杂的情绪：领地意识伴随着兴奋，恐惧伴随着喜悦。但最终你还是把房子交出去了，开始负责社区，你会觉得：“好吧，狗公园，我擅长建狗公园。我搞定了。”接着你又到了那个阶段：“我太棒了，我生来就是为了建社区的。”紧接着又有人出现说：“这不是社区，这是一个国家、一座城市或一个世界。”这种循环会一直持续下去。

---

### [00:14:03] Molly Graham

**English:**
And for me, learning this muscle of both learning to give away what you've gotten good at and move on to the next shiny pile of Legos. And learning that the emotions associated with that are inevitable. I've been doing this for 18, 20 years, I still get attacked by these emotions all the time, but that doesn't mean that you shouldn't give them away and move on to the next thing. That is both the torment of scaling companies, which is that the ground is moving under your feet. And as soon as you're comfortable, someone will make sure that you are uncomfortable, but it's also the opportunity, which is that you can go from being someone that's good at building houses to someone that knows how to build entire worlds. And that is where the Legos metaphor came from.

**中文翻译:**
对我来说，锻炼这种“肌肉”——既要学会舍弃你已经擅长的事，又要投向下一堆闪亮的乐高——并意识到与之相关的情绪是不可避免的，这至关重要。我做这行 18、20 年了，依然经常被这些情绪侵袭，但这并不意味着你不该把乐高分出去并继续前进。这就是扩张型公司的折磨所在：脚下的土地一直在变动，一旦你感到舒适，就会有人让你变得不舒服。但这也是机会所在：你可以从一个擅长盖房子的人，变成一个懂得如何构建整个世界的人。这就是乐高隐喻的由来。

---

### [00:14:55] Lenny Rachitsky

**English:**
That is such a good metaphor. And if you've gone through this, you so understand what this is like and what... And also just the Legos is metaphor is so good for the different things you build.

**中文翻译:**
这个比喻太棒了。如果你经历过这些，你就会非常理解那种感觉……而且乐高这个比喻对于描述你构建的不同事物来说非常贴切。

---

### [00:15:06] Molly Graham

**English:**
I have a very weird brain that for some odd reason just always thinks in metaphors.

**中文翻译:**
我的大脑很奇怪，出于某种奇特的原因，我总是用隐喻来思考。

---

### [00:15:11] Lenny Rachitsky

**English:**
[inaudible 00:15:11].
**Molly Graham:** So it showed up when I was... At Facebook in particular, I would find that every so often I would have to have what I called a Legos talk with someone where I would just see them start to ask these questions like, why are we hiring that person? Or what's that team even do? And I was like, okay, we need to have the chat about the Legos. And then eventually it turned into an article and a whole thing.

**中文翻译:**
**莫莉·格雷厄姆：** 所以当我……特别是在 Facebook 的时候，我发现每隔一段时间我就得和某人进行一次我所谓的“乐高谈话”。当我看到他们开始问诸如“为什么要雇那个人？”或者“那个团队到底是干嘛的？”之类的问题时，我就知道，我们需要聊聊乐高了。最终，这演变成了一篇文章，成了一个完整的理论。

---

### [00:15:33] Lenny Rachitsky

**English:**
A whole thing. And just to be clear, the advice is give away your Legos, this is actually the path to a successful career.

**中文翻译:**
成了一个体系。明确一下，你的建议是“分掉你的乐高”，这实际上是通往成功职业生涯的路径。

---

### [00:15:40] Molly Graham

**English:**
I have watched a lot of people over many years struggle with feeling like they should hang on to the thing that they've been good at. And it almost always... Because, you know, essentially the nature of a scaling company is that the Lego pile is just getting bigger and bigger and bigger however fast that graph is going up into the right. I always say that's the graph of how fast your business is growing. It's the graph of how fast your company is expanding. And it's the graph of how fast your job is getting bigger. That means that if you actually just stay and build houses, eventually you're literally buried under a pile of Legos. Do you know what I mean? You held onto something that's down here and the opportunity is actually to stay on top of that pile and to learn to just give away your job every so often.

**中文翻译:**
多年来，我看到很多人都在纠结，觉得应该死守自己擅长的事情。但这几乎总是……因为，本质上扩张型公司的特点就是乐高堆会变得越来越大，就像那条向右上方延伸的增长曲线。我常说，那是业务增长的速度，是公司扩张的速度，也是你工作内容变大的速度。这意味着如果你只是停留在原地盖房子，最终你会被乐高堆彻底埋掉。你明白我的意思吗？你死守着底层的某些东西，而真正的机会是站在那堆积木的最顶端，学会每隔一段时间就把自己的工作“分出去”。

---

### [00:16:27] Molly Graham

**English:**
At Facebook, I got to a place where I was literally giving away my job every three weeks. I was constantly rehiring myself essentially because you have to sort of grow as fast as your company is growing if you really want to take advantage of the opportunity that comes with companies that are growing and changing quickly.

**中文翻译:**
在 Facebook，我甚至到了每三周就把自己的工作分出去一次的程度。本质上我是在不断地“重新雇佣”自己，因为如果你真的想利用快速成长和变化的公司所带来的机会，你的成长速度必须跟上公司的步伐。

---

### [00:16:45] Lenny Rachitsky

**English:**
So people are hearing this, they're like, okay, my rational brain's like, I should give away my Legos. It'll help me. It'll be good for my career. In real life, it's very hard to actually do. To give away this empire that you've built, this team that you've built. This project that you're like, oh, this is going to be my thing. I know you have a really fun, useful tool to help people deal with that kind of irrational part of their brain. Talk about that.

**中文翻译:**
人们听到这里可能会想：好吧，我的理性大脑告诉我应该分掉乐高，这对我的职业生涯有好处。但在现实生活中，这很难做到。要交出你建立的“帝国”、你带出的团队，或者那个你觉得“这就是我的心血”的项目。我知道你有一个非常有趣且实用的工具，可以帮助人们应对大脑中感性、不理智的那部分。聊聊那个吧。

---

### [00:17:07] Molly Graham

**English:**
So like I said, my brain works in weird metaphors. It's a weird brain. I was raised on The Muppets, and I like to think that this one came from, I guess, growing up watching weird animals. But basically, at some point I realized that this emotional rollercoaster that comes with scaling, with growing. With going through change, any kind of change. People feel that. Was never going to go away. And that no matter how good I got... Sometimes I think it gets worse the more senior you get, actually. Because you sort of feel like you're supposed to know what you're doing, and then you just get attacked by this monster that's like, who even gave you this job in the first place? So basically I externalized all these emotions that come with change into this little tiny monster. I named my monster, Bob. Your monster can be named whatever you want him to be named or her or them.

**中文翻译:**
就像我说的，我的大脑喜欢用奇怪的隐喻。我是看着《芝麻街》长大的，我觉得这个灵感可能来自那些奇怪的小动物。基本上，在某个时刻我意识到，伴随着扩张、增长和任何形式的变革而来的这种情绪过山车是永远不会消失的。无论我变得多么优秀……事实上，我觉得职位越高，这种情况反而越严重。因为你会觉得你应该知道自己在做什么，然后你就会被一个怪物袭击，它会说：“到底是谁当初把这份工作给你的？”所以我把所有这些随变革而来的情绪具象化为一个微小的怪物。我给我的怪物起名叫鲍勃（Bob）。你的怪物可以叫任何你喜欢的名字。

---

### [00:17:56] Molly Graham

**English:**
And Bob's job... I like to think his job is basically to make me the worst version of myself. He's the one that's like, oh, that person took all the fun Legos and you should go push them over and grab them back. Bob's job is... Bob's the one that wants to send the rage emails at 9:00PM and burn the house down. And the thing to learn about Bob is that, like I said, Bob never goes away. Bob is someone that you have to learn to deal with. But Bob's job is to make you the worst version of yourself. So your job is to let Bob do his thing, but not act on the emotions. Basically, all these emotions are normal and they are not useful. They are not the compass that should be telling you what to do.

**中文翻译:**
鲍勃的工作……我认为他的工作基本上就是让我变成最糟糕的自己。他就是那个会说“哦，那个人抢走了所有有趣的乐高，你应该去把他推倒然后抢回来”的家伙。鲍勃就是那个想在晚上 9 点发愤怒邮件、想把房子烧掉的人。关于鲍勃，你需要了解的是：他永远不会消失。鲍勃是你必须学会共处的人。但鲍勃的任务是让你变差，所以你的任务是让鲍勃闹他的，但不要根据那些情绪采取行动。基本上，所有这些情绪都是正常的，但它们没有用。它们不应该成为指引你该做什么的指南针。

---

### [00:18:46] Molly Graham

**English:**
But the other rule I have for managing Bob is a lot of people are like, oh, you're feeling off or tired or whatever. Go to bed and wake up tomorrow morning and you'll feel better. And the truth is that you're like, I want to send the rage email at 9:00PM. You still want to send it at 8:00AM. And a lot of these emotions just do not go away in 24 hours. So my rule of thumb from Facebook was give it two weeks. And the emotional, the sort of Bob... Bob is like these waves and they just roll through. So you made a new hire or somebody came in or you got layered or whatever. You'll have a set of reactions. And those reactions, again, they're normal, but they're not useful. They're not the ones that you should listen to. They are Bob.

**中文翻译:**
我管理鲍勃的另一个规则是：很多人会说，“哦，你感觉不对劲或累了，去睡觉吧，明天早上醒来就会好点。”但事实是，如果你晚上 9 点想发愤怒邮件，第二天早上 8 点你还是想发。很多情绪不会在 24 小时内消失。所以我在 Facebook 总结的经验法则是：给它两周时间。这种情绪，这种“鲍勃”状态，就像海浪一样一波波袭来。比如你招了新人，或者有人空降成了你的上司（Layered）。你会有一系列反应。再次强调，这些反应是正常的，但没用。你不该听从它们，它们只是鲍勃在作怪。

---

### [00:19:29] Molly Graham

**English:**
And typically they go away in a couple of days, you get something new. Some new wave. But anything that lasts longer than two weeks is actually something you should pay attention to. It's something that if it's been around for two weeks, it's something you should go talk to someone about. Whether it's a manager or a friend or a coach or someone like that. That's the real stuff. Everything else is just Bob.

**中文翻译:**
通常它们会在几天内消失，然后会有新的浪潮袭来。但任何持续超过两周的情绪，才是你真正需要关注的。如果一件事困扰了你两周，你就该找人聊聊了，无论是经理、朋友还是教练。那是真实存在的问题，除此之外的一切都只是鲍勃。

---

### [00:19:50] Lenny Rachitsky

**English:**
Is there a rule of thumb for when it actually, when you shouldn't give away your Legos? When it's like, okay, maybe you should fight back on this layering or whatever.

**中文翻译:**
有没有什么经验法则可以判断什么时候*不该*分掉乐高？比如，什么时候应该反击这种“被架层”或者类似的情况？

---

### [00:20:00] Molly Graham

**English:**
No rule of thumb. In general, I would actually say embracing change is far better than fighting it. And almost invariably, you cannot see what is around the corner, but it is almost always the thing to focus on. A lot of times I think inside of change, we get focused on the past, and one of the most valuable things you can do as a manager and a leader is help people focus on the future. I think... I'm sure there are times when people have done it and regretted it and it has led them somewhere.

**中文翻译:**
没有固定的经验法则。总的来说，我认为拥抱变化远比抵制变化要好。几乎在所有情况下，你都看不见拐角处有什么，但那几乎总是你应该关注的重点。很多时候在变革中，我们会纠结于过去，而作为经理和领导者，你能做的最有价值的事情之一就是帮助人们关注未来。我相信肯定有人反抗过并后悔了，或者因此走向了别处。

---

### [00:20:42] Molly Graham

**English:**
I think being layered, for example, is one of the hardest things for people inside these experiences where someone brings in a manager above you. And I've also seen so many stories of that ending up being a great thing for someone. Even though they couldn't see it at the time. So in general, I would just say, step into the future and let the past go and see what you're going to learn. And sometimes you'll learn that it's time to leave or that this isn't the right pile of Legos for you. But it'll end up taking you somewhere that's worth exploring. Holding onto things almost always leads us to the worst version of ourselves.

**中文翻译:**
例如，“被架层”（Layered，即上面空降了一个老板）是这种经历中最难受的事情之一。但我也见过很多故事，最终证明这对当事人是一件好事，尽管他们当时看不出来。所以总的来说，我会说：迈向未来，放下过去，看看你能学到什么。有时你会发现是时候离开了，或者这堆乐高不适合你。但它最终会带你去一个值得探索的地方。死守着东西几乎总是会让我们变成最糟糕的自己。

---

### [00:21:24] Lenny Rachitsky

**English:**
It's a very Buddhist way of thinking too. Just don't cling.
**Molly Graham:** There you go.
**Lenny Rachitsky:** Yeah. And I think another part of this metaphor, I don't know if you think of it this way. Is the Legos aren't even your Legos, right? They're like the CEO's Legos, the shareholders' Legos. So you think they're your Legos, but no, you're not in charge.

**中文翻译:**
**兰尼·拉奇茨基：** 这也是一种非常佛系的思维方式：不要执着。
**莫莉·格雷厄姆：** 没错。
**兰尼·拉奇茨基：** 是的。而且我觉得这个比喻的另一部分是——我不知道你是否也这样想——那些乐高甚至都不是你的，对吧？它们是 CEO 的乐高，是股东的乐高。你以为那是你的乐高，但其实你并不拥有最终决定权。

---

### [00:21:42] Molly Graham

**English:**
Well, it is... I will say one of the hard-earned things is it can feel very emotional and it can feel very personal. It can feel like your work... I don't know, it can feel like your life is on the line sometimes. Just your work life. Oh, gosh, this matters so much. And one of the things that you learn as you get more senior and just have seen stuff is it's going to be okay. A friend of mine says, careers are long and nobody tells you that. But they're long. And this moment feels so dire and it feels so hard and it feels scary and it's going to be okay. So yeah, it is hard to know in the moment. And I think the story is going to be long and this is going to be one chapter or maybe even a part of a chapter, not a whole chapter. So embrace the length.

**中文翻译:**
确实……我得说，一个辛苦学到的教训是：这会让你觉得非常感性，非常私人化。你会觉得你的工作……有时甚至觉得你的命都悬在上面，至少是职业生命。你会觉得“天哪，这太重要了”。但随着你资历加深，见识增多，你会学到一件事：一切都会好起来的。我的一位朋友说，职业生涯很长，但没人告诉你这一点。它真的很长。这一刻可能感觉很惨、很累、很可怕，但最终会没事的。所以，身处其中时很难看透。我认为故事还很长，这只是其中一个章节，甚至只是章节的一部分。所以，拥抱这种长期性吧。

---

### [00:22:37] Lenny Rachitsky

**English:**
To build on that point, I've realized this is my fourth career doing what I do now. Whatever the hell this is. I was a engineer and then I was a founder. Then I was a product manager, and then what the hell I do now. Whatever this is, that's a whole different path.

**中文翻译:**
补充一点，我意识到我现在做的事情已经是我的第四份职业了。管它到底是什么。我当过工程师，当过创始人，当过产品经理，然后就是我现在做的这些。无论这叫什么，这都是一条完全不同的道路。

---

### [00:22:52] Molly Graham

**English:**
You don't have a name for it yet, Lenny?
**Lenny Rachitsky:** I don't. I hate all the terms people use for this world.
**Molly Graham:** Somebody called me an influencer and I almost ripped their face off.
**Lenny Rachitsky:** Yeah.
**Molly Graham:** Yeah, man. The most interesting careers are winding and they have starts and stops and failures and successes and control. Anybody that's been through a lot of this stuff, control is usually not the name of the game. It's usually just like, "Let's see what happens. We're going to try this and we're going to see what happens next."

**中文翻译:**
**莫莉·格雷厄姆：** 你还没给它起个名字吗，兰尼？
**兰尼·拉奇茨基：** 没有。我讨厌人们用来形容这个领域的各种术语。
**莫莉·格雷厄姆：** 有人叫我“网红”（Influencer），我差点没跟他翻脸。
**兰尼·拉奇茨基：** 哈哈，是的。
**莫莉·格雷厄姆：** 是啊。最有趣的职业生涯都是曲折的，有开始、有停滞、有失败、有成功。经历过这些的人都知道，“掌控感”通常不是游戏的主题。通常只是：“让我们看看会发生什么。我们要尝试这个，然后看看接下来会发生什么。”

---

### [00:23:26] Lenny Rachitsky

**English:**
This a great segue to another framework that I've heard from folks you've worked with that have been really impactful on them. So, Sarah Caldwell, who's a big deal at OpenAI, she told me that the framework that helped her most in her career is something that you call the J-Curve versus Stairs career growth framework. Talk about what that's about.

**中文翻译:**
这正好引出了另一个框架。我从与你共事过的人那里听说，这个框架对他们影响巨大。在 OpenAI 担任要职的莎拉·考德威尔告诉我，职业生涯中对她帮助最大的框架就是你所说的“J 型曲线 vs 阶梯”职业成长框架。聊聊那是怎么回事。

---

### [00:23:46] Molly Graham

**English:**
I actually gave a TED Talk about this one a couple of years ago because I am so passionate about it, but you can listen to the very packaged eight-minute version of this, but I will tell you the real story because it's very relevant to a lot of folks that listen to your podcast. I was at Facebook for five years. Like I said, the first two years I was in HR and I was doing employment branding and culture work and I was ready to stay there. I think I had in my head I was going to stay there until we went public, that was my plan just because I wanted to help the company through that moment, again, in my head.

**中文翻译:**
几年前我专门为此做过一次 TED 演讲，因为我对此非常有激情。你可以去听那个 8 分钟的精简版，但我会告诉你真实的故事，因为这与你播客的很多听众息息相关。我在 Facebook 待了五年。就像我说的，前两年我在 HR 部门，做雇主品牌和文化工作。我当时打算一直待在那儿直到公司上市，那是我的计划，因为我想帮助公司度过那个时刻——至少我当时是这么想的。

---

### [00:24:21] Molly Graham

**English:**
This guy that many people know, Chamath Palihapitiya, came to me and Chamath ran growth and mobile at the time. And he came to me and we had lunch and he said in his very Chamath way, "You're useless. What are you doing in HR? This is stupid. You should come work for me." And anybody that knows Chamath is like, "Yes, that is actually what he said." He managed to insult you and compliment you in one sentence.

**中文翻译:**
后来，很多人都认识的查马斯·帕里哈皮蒂亚（Chamath Palihapitiya）找到了我，他当时负责增长和移动业务。我们一起吃了午饭，他用那种典型的“查马斯方式”对我说：“你现在毫无用处。你在 HR 干嘛？太蠢了。你应该来为我工作。”认识查马斯的人都会说：“没错，他确实会这么说。”他能在一句话里同时羞辱你又赞美你。

---

### [00:24:47] Molly Graham

**English:**
He gave me all these options on his team. And then the last one he said to me was like, "I'm going to go build a mobile phone. Do you want to come do that with me?" And I had four simultaneous reactions. The first was like, " That is incredibly stupid. Why are we doing that?" And then it was like, "Is that actually a thing that we're doing?" And then it was like, "Whoa, I think that sounds kind of fun." And so I left the conversation at Chamath and I went and asked my boss, Lori Goler, who's the head of people at Facebook for a very long time, like, "Is this actually something we're doing?" And she was like, "I can't believe he offered you that, whatever."

**中文翻译:**
他给了我他团队里的好几个选择。最后一个他说：“我要去造手机了，你想跟我一起干吗？”我当时同时产生了四种反应。第一反应是：“这简直蠢透了，我们为什么要干这个？”接着是：“我们真的要干这个吗？”然后是：“哇，我觉得这听起来挺好玩的。”于是我结束了与查马斯的谈话，跑去问我的老板 Lori Goler（Facebook 长期的人力资源负责人）：“我们真的要做这个吗？”她说：“我简直不敢相信他居然邀请你去做那个，随他便吧。”

---

### [00:25:21] Molly Graham

**English:**
And I basically just could not get it out of my head, but it didn't make any sense, A, that Chamath had asked me because I was in HR. Like, "What am I doing? I don't absolutely jack shit about mobile." But I had worked on a project with him and I guess he thought I was smart. And I talked to Cheryl and she was like, "Well, that project will be dead in two months, but you can do it because you'll still have a job here." My dad was like, "Well, don't do that. " And anyway, a lot of very wise people being like, "Don't do that."

**中文翻译:**
我脑子里一直挥之不去这件事，但这根本不合逻辑。首先，查马斯为什么要找我？我在 HR 部门啊。我想：“我在干嘛？我对移动领域一窍不通。”但我曾和他合作过一个项目，我猜他觉得我挺聪明。我找谢丽尔聊了聊，她说：“嗯，那个项目两个月内就会黄掉，但你可以去做，因为你在这儿总会有份工作的。”我爸说：“别去干那个。”总之，很多聪明人都说：“别去。”

---

### [00:25:51] Molly Graham

**English:**
But I kind of couldn't get out of my head. And my friend said to me, "You've proven you're really good at this sort of company-wide project management and HR. Why don't you go show yourself how actually good you are? Is this transferable?" So, I took the job and I spent the next six months feeling like an absolute idiot. I basically felt like a total jackass all the time. I was sitting in rooms with these brilliant people asking the dumbest questions of my life and at the end of the six months, Chamath, I think, took a lot of pride in giving me the lowest performance rating I've ever gotten in my life, and it just felt like falling off a cliff.

**中文翻译:**
但我就是忘不掉。我的朋友对我说：“你已经证明了你非常擅长这种全公司范围的项目管理和 HR 工作。为什么不去向自己证明你到底有多优秀？这些能力是可以迁移的吗？”于是，我接受了那份工作。接下来的六个月里，我觉得自己像个彻头彻尾的白痴。我整天都觉得自己像个笨蛋。我和那些天才坐在一起，问出我这辈子最愚蠢的问题。六个月结束时，查马斯似乎很自豪地给了我职业生涯中最低的绩效评分，那感觉就像掉下了悬崖。

---

### [00:26:17] Molly Graham

**English:**
Then, slowly, I remember I had been doing all these trips to Taiwan because we were actually working on hardware and I, at some point, came back from Taiwan and I drew on a whiteboard for him the layout of a mobile phone and trying to explain to him why something he wanted to do was not possible. I so vividly remember walking out of that meeting being like, "Oh, I actually know things." And slowly then, over the following three years, I became an expert in mobile. And I basically... The phone itself was a giant failure, massive, costly failure for Facebook, but it was not a failure for me. It was a huge job that taught me that I was capable of things that I never could have dreamed of if I had stayed in HR. It set me up to be capable of taking on things that I didn't know about.

**中文翻译:**
然后，慢慢地，我记得我当时一直在跑台湾，因为我们在做硬件。某次从台湾回来后，我在白板上给他画出了手机的布局，并试图向他解释为什么他想做的某些事情是行不通的。我清晰地记得走出那间会议室时的感觉：“噢，我居然真的懂这些东西了。”在接下来的三年里，我慢慢成了移动领域的专家。虽然那款手机本身是一个巨大的失败，对 Facebook 来说是惨重且昂贵的失败，但对我来说不是。那份工作教会了我，我能做到那些如果留在 HR 部门做梦都想不到的事情。它让我具备了挑战未知领域的能力。

---

### [00:27:28] Molly Graham

**English:**
Chamath, when he pitched me on this job, actually drew me a picture on a whiteboard. He said, "Look, you can stay..." The way a lot of people do careers is a set of stairs. "You can be boring." To use Chamath, "And stay on these stairs. Just walk up the stairs and you'll get promoted every two years and your title will change from manager to senior manager to director to senior director, whatever." And he was like, "But that is boring." And he's like, "The much more fun careers are like jumping off cliffs." Basically, that you jump off this thing and you do fall for a period of time. I always like to say it's about six to nine months, but then this thing happens where you climb out.

**中文翻译:**
查马斯在向我推销这份工作时，真的在白板上画了一幅画。他说：“看，你可以留下……”很多人规划职业生涯的方式是阶梯式的。“你可以选择无聊，”用查马斯的话说，“留在这些阶梯上。顺着楼梯走，每两年升职一次，头衔从经理变成高级经理，再到总监、高级总监等等。”他说：“但那太无聊了。”他说：“更有趣的职业生涯就像跳下悬崖。”基本上，你跳下去，会坠落一段时间——我常说是六到九个月——但接着，奇迹发生了，你会爬出来。

---

### [00:28:05] Molly Graham

**English:**
And the picture he drew had this J-curve sort of basically leading you to places that are way beyond where the stairs could ever get you. And to be totally honest, that has been my experience. That taking risks, accepting the sort of terrible fall and that experience of falling has been more than worth it. Part of the reason why Sarah mentions it is that I do give this sort of talk to people that are inside of really fast-growing companies, because it's such an important place to let go of Legos and jump off cliffs because there's so much opportunity. And it is a place where if you prove to people that you're actually good, if they believe that you are the kind of person that they can use to do lots of things, you can get these opportunities that you are just so deeply unqualified for, but they can take you to places that you could never have imagined.

**中文翻译:**
他画的那张图上有一条 J 型曲线，它会带你去往阶梯永远无法到达的地方。坦白说，这就是我的亲身经历。冒险、接受那种可怕的坠落感，这种经历是非常值得的。莎拉之所以提到它，是因为我经常对那些身处高速增长公司的人做这类演讲。在那种环境下，舍弃乐高、跳下悬崖至关重要，因为机会太多了。在那里，如果你向人们证明了你确实优秀，如果他们相信你是那种可以胜任多种任务的人，你就能获得那些你“完全不具备资格”的机会，而这些机会能带你去往超乎想象的地方。

---

### [00:29:01] Molly Graham

**English:**
You can come out of those companies with skills that no one would ever have reasonably hired you to do. But I ended my time at Facebook in product and did business development and hardware and a whole bunch of the stuff along the way. And again, nobody would've hired me to do that at the beginning, but it's just because I kept saying yes to things.

**中文翻译:**
从这些公司出来时，你会掌握一些别人根本不会合理地雇你去做的技能。我在 Facebook 的最后阶段是在产品部门，期间还做了业务开发、硬件以及一堆其他事情。再说一次，起初没人会雇我去做那些，只是因为我不断地对新事物说“好”。

---

### [00:29:22] Lenny Rachitsky

**English:**
Molly, I got tingles listening to this story. Wow.
**Molly Graham:** Does it sound familiar, Lenny?
**Lenny Rachitsky:** It does. I want to ask, jumping off a cliff, sometimes you fall, really fall and you keep falling. Are there any kind of traits of like, "Okay, this is one that might be a J-Curve and worth the risk of falling, and this is when you should probably just not, let's not do this".

**中文翻译:**
**兰尼·拉奇茨基：** 莫莉，听这个故事我起了一身鸡皮疙瘩。哇。
**莫莉·格雷厄姆：** 听起来耳熟吗，兰尼？
**兰尼·拉奇茨基：** 确实耳熟。我想问，跳下悬崖时，有时你会坠落，真的坠落而且一直掉下去。有没有什么特征可以判断：“好吧，这可能是一个 J 型曲线，值得冒险一跳”，以及“这可能不行，我们还是别跳了”？

---

### [00:29:46] Molly Graham

**English:**
Yeah. I just think there are different kinds of fear. We talk a lot about this in Glue Club because one of the thing, there is a financial fear, right? Leaving a job and taking a job that has financial risk associated with it, or leaving a job and taking time off, which is something that I spend a lot of time talking to people about, you got to do the math and you got to... Sometimes there is a type of fear that is telling you like, "This is not the right time." Or, "I don't want to be financially anxious for months and months and months."

**中文翻译:**
是的。我觉得恐惧有很多种。我们在 Glue Club 经常讨论这个。其中一种是财务恐惧，对吧？辞职去接一份有财务风险的工作，或者辞职休息一段时间——这是我经常和别人聊的话题。你得算算账……有时某种恐惧是在告诉你：“现在不是时候”，或者“我不想连续好几个月处于财务焦虑中”。

---

### [00:30:21] Molly Graham

**English:**
I use finances because it's the most concrete example of a type of fear that you should actually listen to. And sometimes you can do the math. I always counsel people through that. I'm like, "What is the number that you need to hit so that you're not constantly terrified financially?" And that number is wildly different for people based on their background and their life. "Can you do that? Can you consult, can you whatever in order to take this leap?" But a lot of times fear is just you saying, "I'm scared I can't do this. I'm scared I'm not capable of it. Yeah, I'm scared I'll fail."

**中文翻译:**
我拿财务举例，因为它是你应该真正听从的最具体的恐惧类型。有时你可以算算账。我总是建议人们这样做：“你需要达到多少存款，才不会在财务上感到持续恐慌？”根据背景和生活状况，每个人的这个数字大不相同。“你能做到吗？你能通过咨询或其他方式来支撑这次飞跃吗？”但很多时候，恐惧只是在说：“我怕我做不到。我怕我没那个能力。我怕我会失败。”

---

### [00:30:56] Molly Graham

**English:**
And that's the kind of fear that I think of as a flashing green light because... And it sounds like Matt McGinnis said this too, where it's like, "That's the kind of fear that's saying, 'Why don't you go prove to yourself that you are actually capable of this?'" Or if you fail, like, "You'll have learned something, too." You know what I mean? You'll have learned, like, "I took this job in product at Facebook as my last chapter there, and let me tell you things that people should never fucking hire me to do." I was like, "I am not a good product manager." But I've got a great product mindset. I can sit in a bunch of chairs and hang with the product folks, but I'm not the person that cares about the button. Do you know what I mean?

**中文翻译:**
这种恐惧在我看来就像是闪烁的绿灯。听起来 Matt McGinnis 也说过类似的话：“这种恐惧其实是在说，‘你为什么不去向自己证明你确实有这个能力呢？’”或者即使失败了，你也会学到东西。你明白我的意思吗？你会学到，比如：“我在 Facebook 的最后一章接了产品经理的工作，让我告诉你，有些事人们绝对不该雇我去干。”我发现：“我不是一个好的产品经理。”但我有很好的产品思维。我可以和产品团队混在一起讨论，但我不是那个会去纠结按钮细节的人。你懂吗？

---

### [00:31:38] Molly Graham

**English:**
And I would never have learned that. I wouldn't have known who I was if I hadn't taken that risk and failed or at least learned that it's not something I wanted to do again. So, there's many different lessons that come from facing down those fears and jumping off the cliff, but mostly what it is is knowing yourself better and knowing where you go next from there.

**中文翻译:**
如果我不去冒那个险，不去经历失败，或者至少不去发现那不是我想再做的事，我永远不会学到这些，也不会了解真正的自己。直面恐惧、跳下悬崖会带来很多不同的教训，但最核心的是更了解自己，并知道下一步该往哪里走。

---

### [00:32:03] Lenny Rachitsky

**English:**
That is such helpful advice. I also love how you frame this of, "Prove it to yourself that you can do this." It's not, "I'm going to show them that I can do this." Because the way you describe this, usually it's an opportunity given to you. "Hey, can you do this thing? We want you to lead this new thing." And the fear is like, "I don't think I can do that." And what you're saying here is, "Prove it to yourself that you can." Or, I guess, it's also, "Okay, maybe I can't and then I'll learn that and then I'll know more about myself."

**中文翻译:**
这建议太有用了。我也很喜欢你对这件事的定性：“向你自己证明你能做到。”而不是“我要向他们证明我能行”。因为按照你的描述，这通常是别人给你的机会：“嘿，你能做这个吗？我们想让你领导这个新项目。”而你的恐惧是：“我觉得我做不到。”你在这里说的是：“向你自己证明你可以。”或者，“好吧，也许我真的不行，那我也能学到这一点，从而更了解自己。”

---

### [00:32:27] Molly Graham

**English:**
Yeah, exactly. I mean, one of the greatest gifts in a career is knowing yourself. And that's a lifelong journey because who you are and what you want changes, but that knowledge and that gift, nothing accelerates your self-knowledge faster than trying to do something that you don't know how to do and that you're scared of.

**中文翻译:**
没错。职业生涯中最好的礼物之一就是了解自己。这是一个终身的旅程，因为你的身份和需求在变。但这种认知和天赋——没有什么比尝试做一件你不会做且感到害怕的事情，更能加速你对自我的了解了。

---

### [00:32:50] Lenny Rachitsky

**English:**
Probably the quote I use most on this podcast comes up again in my mind as you talk about this, this line that, "The cave you fear contains the treasure you seek."
**Molly Graham:** Hell yes, exactly. Well said.
**Lenny Rachitsky:** There it is.
**Molly Graham:** I haven't heard that one from you, so clearly I need to listen more.

**中文翻译:**
**兰尼·拉奇茨基：** 当你谈到这个时，我脑海中又浮现出我在这个播客中用得最多的一句话：“你所恐惧的山洞里，藏着你寻找的宝藏。”
**莫莉·格雷厄姆：** 太对了，没错。说得好。
**兰尼·拉奇茨基：** 就是这句。
**莫莉·格雷厄姆：** 我还没听你说过这句，看来我得更经常听你的节目了。

---

### [00:33:04] Lenny Rachitsky

**English:**
Okay, that's great. I'm glad I don't overuse it. It just feels like it comes up again and again, and I think your point about the runway and the finances is such an important one because that's a very real practical question. One thing I did when I took time off, I took a year off after I left my job. What helped me was I just created a runway goal for myself. I'm just like, "Okay, here's what it's going to cost me for six months or a year to live without any income. Am I comfortable just burning through these tens of thousands of dollars to explore and see something new emerge?" And so you just have to feel good. "Okay, yes, I'm going to burn all that money and that's part of it."

**中文翻译:**
太好了，很高兴我没用滥。只是感觉它总是一再出现。我觉得你关于“跑道”（Runway）和财务的观点非常重要，因为这是一个非常现实的问题。我辞职后休息了一年，当时对我帮助很大的一点是，我为自己设定了一个“跑道目标”。我想：“好吧，在没有任何收入的情况下生活六个月或一年需要花多少钱。我是否愿意为了探索和等待新事物的出现，而烧掉这几万美元？”你必须对此感到释然：“好的，是的，我要烧掉这些钱，这是过程的一部分。”

---

### [00:33:37] Molly Graham

**English:**
Yeah, that's exactly the exercise. You're saying "runway" I say "burn rate", so we both were raised inside of companies, incentive tech, but I think it is do the math, right? What can you afford? And it's both what can you afford and still feel safe? Because sometimes, I mean, again, I think that is different for everyone, but it is such an important set of math to do because, A, a lot of times that number is smaller than you think it is, then your brain makes it out to be if you have this sort of existential financial anxiety versus, I always say, "Specific financial anxiety is much more useful than existential financial anxiety."

**中文翻译:**
没错，就是这个练习。你用“跑道”，我用“烧钱率”（Burn rate），看来我们都是在科技公司里熏陶出来的。但核心就是算账，对吧？你能负担得起什么？而且既是你能负担得起，又要能感到安全。因为有时——再次强调，每个人情况不同——但这笔账非常重要。首先，很多时候那个数字比你想象的要小，比你大脑在那种“存在主义财务焦虑”下产生的幻觉要小。我常说：“具体的财务焦虑比存在主义的财务焦虑有用得多。”

---

### [00:34:29] Molly Graham

**English:**
And some friends are leaving jobs and I'll be like, "Hey, your number is 5K or 10K a month. You have to believe that you can get a consulting gig that will pay you that. Do you believe that?" And it's like, "Either yes or no." And then, "Okay, either we're doing it or we're not.

**中文翻译:**
有些朋友要辞职，我会说：“嘿，你的数字是每月 5000 或 1 万美元。你必须相信你能找到一份能付你这么多钱的咨询工作。你相信吗？”答案要么是“是”，要么是“否”。然后，“好吧，要么我们干，要么不干。”

---

### [00:34:49] Lenny Rachitsky

**English:**
The other part of this J- Curve that I think is really important to touch on is this idea of for the first six or nine months, you're going to be at the bottom of the J curve falling, still falling. And some projects don't last that long and then you're like, "Okay, total failure. I never emerged from this fall." So, is there any advice there? Just, how do you create that enough space to give you a chance to start to un-fall?

**中文翻译:**
关于 J 型曲线，我觉得还有一点很重要，就是前六到九个月你处于曲线底部，一直在坠落。有些项目持续不了那么久，然后你会觉得：“好吧，彻底失败了。我再也没能从这次坠落中爬出来。”对此有什么建议吗？如何创造足够的空间，让自己有机会开始“止跌回升”？

---

### [00:35:06] Molly Graham

**English:**
I mean, the most valuable thing that happens as you fall is learning. And even on the other side of failure, you've learned a shit ton. I always say, "The most important thing to do in the falling phase and the risk taking land is to learn to embrace being a professional idiot." Basically, being the one that shows up at the meeting and is like, "What are we talking about? What does that word mean?"

**中文翻译:**
我的意思是，坠落过程中发生的最有价值的事情就是学习。即使最终失败了，你也学到了极多东西。我常说：“在坠落阶段和冒险领域，最重要的事情是学会拥抱‘职业白痴’（Professional idiot）的身份。”基本上，就是那个出现在会议上问“我们在聊什么？那个词是什么意思？”的人。

---

### [00:35:18] Molly Graham

**English:**
For a bunch of reasons. Number one, you can learn so much. And again, even in the face of failure, no one can take away your learning. Do you know what I mean? But the other thing is that it turns out that a lot of the questions in the world that, you're sitting in the meeting and you're like, "This is a dumb question. Everyone's going to think I'm an idiot." But then you get brave and you ask it and it turns out it wasn't a dumb question. Do you know what I mean? Turns out that everyone had that question in their mind, but no one was brave enough to ask it.

**中文翻译:**
这有很多原因。第一，你能学到很多。再说一次，即使面对失败，也没人能夺走你的所学。你懂吗？第二，事实证明，世界上很多问题——当你坐在会议室里想，“这是个蠢问题，大家都会觉得我是个白痴”——但当你鼓起勇气问出来时，结果发现那根本不是个蠢问题。事实证明，每个人脑子里都有这个疑问，只是没人敢问。

---

### [00:35:48] Molly Graham

**English:**
So, from a skills' perspective, again, regardless of outcome, being the person that sort of takes their learning in their own hands, learning no matter what and learning to ask those dumb questions, it's a superpower. I always say that, "Actually, my superpower is being a professional moron." Because I'm the one that shows up in a room and is like, "Do we have goals? What are we doing? Why are we talking about this? Why are we having this meeting?" And most of the time it's actually what I was hired to do, which is bring clarity.

**中文翻译:**
所以，从技能的角度来看，无论结果如何，做一个掌握学习主动权、无论如何都要学习、并学会问那些“蠢问题”的人，这是一种超能力。我常说：“实际上，我的超能力就是做一个‘职业笨蛋’。”因为我就是那个出现在房间里问“我们有目标吗？我们在干嘛？为什么要聊这个？为什么要开这个会？”的人。而大多数时候，这正是我被雇佣的原因——带来清晰度。

---

### [00:36:19] Lenny Rachitsky

**English:**
It's so funny. I just recorded a podcast episode with a PM named Zevi who joined Wix and he had this thought, he's like a very young PM, just getting started and he's like, "Okay, I need to be a 10X PM because that's what they expect of me, that's what everyone that is really good, that's how I think of a 10X PM." And then he went into his first meeting and he just failed and he just felt so bad. He's like, "I guess I'm not that 10X PM. They're all going to see that. They think I'm terrible." And then he did another presentation a little bit later and people were so impressed with how he learned and evolved and improved. And he realized that he needs to be not a 10X PM, but a 10X learner, and that's what people actually expect from someone, especially a junior person.

**中文翻译:**
太有意思了。我刚和一位叫 Zevi 的产品经理录了一集，他刚加入 Wix。他是个非常年轻的 PM，刚起步，他想：“好吧，我得成为一个 10 倍速 PM，因为那是大家对我的期望，也是我认为优秀 PM 该有的样子。”结果他在第一次会议上搞砸了，感觉糟透了。他想：“看来我不是那个 10 倍速 PM，大家都会看穿我，觉得我很烂。”但不久后他做了另一次演示，大家对他学习、演变和进步的速度印象极其深刻。他意识到，他不需要成为一个 10 倍速 PM，而需要成为一个 10 倍速学习者，这才是人们对新人（尤其是初级人员）的真正期望。

---

### [00:37:05] Molly Graham

**English:**
Yeah. Well, I was having a conversation last night with a friend of mine who has a senior in high school and I was like, "What is the plan? What are we telling this senior in high school to think about relative to their career given everything that's going on with AI?" And we talked about it a bunch, but what we both circled back to was this idea of soft skills and that actually the only thing you can really anchor on right now is that teaching kids grit, teaching them hard work, teaching them learning, right? Learning how to learn, loving learning, being able to fall, in a world that's changing this fast.

**中文翻译:**
是的。昨晚我和一个朋友聊天，他的孩子上高三。我问：“计划是什么？考虑到 AI 领域发生的一切，我们要告诉这个高三学生如何思考职业生涯？”我们聊了很多，但最终都回到了“软技能”这个概念上。实际上，现在唯一能真正依靠的就是教孩子坚毅（Grit）、教他们努力工作、教他们学习，对吧？在这个变化如此之快的世界里，学会如何学习、热爱学习、能够承受坠落。

---

### [00:37:52] Molly Graham

**English:**
And I say this inside of companies too, right? I always say, like, "What you know today is way less valuable than what you can learn by tomorrow." If you're inside of a company where the growth curve is like this, what you know today is irrelevant. Somebody once told... I'm sure this is faster now, but they rewrote the entire code base at Google every eight years, which means that if you're not learning, if you're not evolving, then you become irrelevant and extinct. It's actually the whole underlying point of the Legos stuff is that evolution is the way you stay on top, and I think that's more true today than it's ever been.

**中文翻译:**
我在公司内部也这么说。我常说：“你今天知道的东西，远不如你明天能学到的东西有价值。”如果你身处一家增长曲线如此陡峭的公司，你今天掌握的知识很快就会过时。有人曾告诉我——我确信现在速度更快了——谷歌每八年就会重写整个代码库。这意味着如果你不学习、不进化，你就会变得无关紧要并被淘汰。这其实也是“乐高理论”的核心：进化是保持领先的唯一途径。我觉得这一点在今天比以往任何时候都更正确。

---

### [00:38:14] Lenny Rachitsky

**English:**
And luckily, AI is really good at helping us learn.
**Molly Graham:** Totally.
**Lenny Rachitsky:** So, that's good. Thank you, AI. And this actually comes up a bunch in the podcast. I ask a lot of AI-forward people what they're teaching their kids and curiosity is one of the main things people talk a lot about. Just like, "Help them develop curiosity about the world."
**Molly Graham:** Yeah.

**中文翻译:**
**兰尼·拉奇茨基：** 幸运的是，AI 非常擅长帮助我们学习。
**莫莉·格雷厄姆：** 完全正确。
**兰尼·拉奇茨基：** 所以挺好的，谢谢 AI。这在播客里经常被提起。我问过很多走在 AI 前沿的人他们在教孩子什么，“好奇心”是人们谈论最多的核心内容之一。就是“帮助他们培养对世界的好奇心”。
**莫莉·格雷厄姆：** 没错。

---

### [00:38:50] Lenny Rachitsky

**English:**
Okay. I feel like I could be talking about this specific topic for a whole podcast episode, but I want to move on to a couple other frameworks that you've developed. One is something called a Waterline Model and another former colleague of here said, "This is the most impactful thing that they've learned from you on their career." So, talk about the Waterline Model.

**中文翻译:**
好。我觉得这个话题我能聊上一整集，但我得继续讨论你开发的另外几个框架。一个是所谓的“水位线模型”（Waterline Model），你的一位前同事说，这是他们在职业生涯中从你那里学到的最有影响力的东西。聊聊这个模型吧。

---

### [00:39:15] Molly Graham

**English:**
Okay. Yeah. Well, first of all, the Waterline Model is not mine. It's from some business book somewhere, but I actually learned it. My first job out of college was leading wilderness trips. I led 75-day wilderness trips in Patagonia and Alaska for a school called NOLS, the National Outdoor Leadership School. NOLS basically teaches essentially leadership and communication skills to students. I was mostly leading college age kids through wilderness expeditions. So, by having to lead a group of your peers that you don't know. Anyway, the Waterline Model is something that we taught on NOLS. It's a really, really helpful model for understanding how to diagnose when something is not working on a team, so I teach it inside of Glue Club and I'll just quickly explain it.

**中文翻译:**
好的。首先，水位线模型不是我发明的，是出自某本商业书。但我学到它是在我大学毕业后的第一份工作——带领野外探险。我曾为一所名为 NOLS（国家户外领导力学校）的学校在巴塔哥尼亚和阿拉斯加带领为期 75 天的野外探险。NOLS 基本上是向学生传授领导力和沟通技巧。我当时主要带领大学生进行野外考察，必须领导一群你不认识的同龄人。总之，水位线模型是我们 NOLS 教授的内容。它是一个非常有用的模型，可以帮助你诊断团队何时出了问题。我在 Glue Club 也会教这个，我简单解释一下。

---

### [00:40:02] Molly Graham

**English:**
Basically, the way to think about the Waterline Model is that a team is a boat and it's a boat on an ocean trying to get somewhere, getting somewhere is goals, right? What is going on under the water? What is going on that's making it harder or easier to get to your goals?" And there's essentially four things underneath the water and they are in a descending order. The surface level is what's called structural things. Basically, structural things are like goal setting, vision, roles, expectations, kind of the structures you put in place to make a team and a company and a business make sense, that touch every single member of the team.

**中文翻译:**
基本上，你可以把水位线模型想象成一艘在海上航行的船，船要驶向某个目的地，目的地就是“目标”。水位线以下发生了什么？是什么让达成目标变得更难或更容易？水位线以下基本上有四层东西，按由浅入深的顺序排列。最表面的一层是“结构性因素”（Structural things）。基本上包括目标设定、愿景、角色分配、预期管理，也就是你为了让团队和业务运转而建立的那些触及每个成员的结构。

---

### [00:40:37] Molly Graham

**English:**
Right below that is something called dynamics, which is essentially how the team works together. It's culture, it's decision making, it's how we resolve conflict, all the sort of like interwoven pieces of how teams work together. And then below that is interpersonal, so basically relationships between two people and all the things that come with us being humans. And then the bottom is intrapersonal, meaning within one person, challenges and issues there.

**中文翻译:**
紧接着下面一层是“动态因素”（Dynamics），本质上是团队如何协作。包括文化、决策机制、冲突解决方式，以及所有关于团队如何运作的交织在一起的部分。再往下是“人际因素”（Interpersonal），基本上是两个人之间的关系，以及作为人类所带来的一切复杂性。最底层是“个人内在因素”（Intrapersonal），即个人内部的挑战和问题。

---

### [00:41:08] Molly Graham

**English:**
The interesting thing about this model is that most people, when something's going wrong on a team, a lot of times we always go to the bottom. We go to the people. We're like, "The people aren't getting along, that person's having a rough moment." We go to the humans, but the rule with the Waterline Model, which is very memorable, is you snorkel before you scuba. So, 80% of problems on teams actually happen because of structural issues or dynamics issues. So, when there are problems on your team, where you start is at the top, you start structural issues.

**中文翻译:**
这个模型有趣的地方在于，当团队出问题时，大多数人总是习惯从最底层找原因。我们归结为人的问题：“大家相处得不好”，“那个人状态不对”。我们盯着人看。但水位线模型有一个非常易记的规则：先浮潜（Snorkel），再深潜（Scuba）。团队中 80% 的问题实际上是由结构性或动态性问题引起的。所以，当团队出现问题时，你应该从最顶层开始——从结构性问题开始排查。

---

### [00:41:44] Molly Graham

**English:**
And one of my biggest things that I say all the time over and over again inside of Glue Club is, "Your only goal as a manager, if you do nothing else, is clear roles and clear expectations. That's it." Because honestly, I've taken over a lot of teams in my life and almost always I show up and it turns out that no one knows what their job is and no one knows what success looks like. And if you can make those two things clear, which again is at the snorkel level, it will fix a huge percentage of other issues on a team. But the main thing is where you start and just always sort of starting at that structural level or the dynamics level and not sort of immediately going to the people and all that. Because yes, people cause all sorts of problems, but a lot of times the problems are happening because they're existing inside of a structure that's confusing.

**中文翻译:**
我在 Glue Club 反复强调的一点是：“作为经理，如果你什么都不做，你唯一的目标也应该是明确角色和明确预期。仅此而已。”坦白说，我职业生涯中接手过很多团队，几乎每次我到场时都发现，没人知道自己的具体职责，也没人知道成功的标准是什么。如果你能把这两点理清楚（这属于“浮潜”层面的工作），就能解决团队中绝大部分的其他问题。关键在于你从哪里开始——始终先从结构或动态层面入手，而不是立刻归咎于人。因为虽然人会制造各种麻烦，但很多时候麻烦之所以产生，是因为他们处于一个混乱的结构中。

---

### [00:42:32] Lenny Rachitsky

**English:**
Another very vivid metaphor and just, I love how it builds on it with the snorkeling. Okay. So, just to be super clear about this, the takeaway here is, you have a problem with your team, with the company, many people think it's, they jump to the people are the problem. "They're not good enough, they're not working hard enough." Really, what you're saying is, most often, the issue is not the person, it's the situation, whether it's the structure of how they're set up to work or the dynamics amongst the people. And specifically what you're saying is that the role maybe isn't clear or what success means for that role is not clear.

**中文翻译:**
又一个非常生动的比喻，我特别喜欢关于“浮潜”的延伸。所以，为了明确起见，这里的核心观点是：当团队或公司出问题时，很多人会跳到“人有问题”的结论上——“他们不够优秀，不够努力”。而你真正想说的是，问题往往不在于人，而在于情境，无论是工作结构的设置，还是人与人之间的互动动态。具体来说，可能是角色不明确，或者该角色的成功标准不清晰。

---

### [00:43:08] Molly Graham

**English:**
Every company I've worked with or advise, I often start with like, "What are the goals?" And usually what you get the hack is, "Uh, not clear." And that in and of itself is a structural issue, right? How can someone show up and decide what they're going to do with their day all day if the goals aren't clear, if they don't actually know what the priorities are? And then it goes to, okay, role, right? "Do I know what my job is? Do I know what number I was hired to own and drive?" And then, "Do I know what success looks like? How does my role tie to that overall goal that the company has?" Just literally right there. You got probably 80% of problems inside of companies because this is the hard work of company building. It's the stuff that's not intuitive. "How do you organize a group of people to know which direction to row?"

**中文翻译:**
我合作过或咨询过的每一家公司，我通常都会先问：“目标是什么？”得到的回答通常是：“呃，不清楚。”这本身就是一个结构性问题。如果目标不明确，如果大家不知道优先级，他们怎么能每天一上班就决定该做什么呢？接着是角色：“我知道我的工作是什么吗？我知道我被雇来负责并推动哪个指标吗？”然后是：“我知道成功是什么样吗？我的角色如何与公司的总体目标挂钩？”就在这几点上，你就能找到公司 80% 的问题。因为这是公司建设中最难的部分，也是最不直观的部分：“你如何组织一群人，让他们知道该往哪个方向划船？”

---

### [00:43:52] Molly Graham

**English:**
And that equation, again, I would say 80% of problems that I see, performance issues. I always start with, "Does this person actually know what you expect of them?" If not, go back to step one. Do you know what I mean? Clarify expectations, so the Waterline Model is just helpful for reminding us, like, "Start at the top."

**中文翻译:**
再说一次，我看到的 80% 的问题，包括绩效问题，我都会先问：“这个人真的知道你对他的期望吗？”如果不知道，那就回到第一步。你懂吗？明确预期。所以水位线模型就是为了提醒我们：“从最顶层开始”。

---

### [00:44:11] Lenny Rachitsky

**English:**
So what would you do there? Say you're a manager, you're having an issue with a team member, would you go and ask, "Hey, let's just make sure we're aligned on goals and roles." Is that how'd you approach it or is there a different approach?

**中文翻译:**
那你具体会怎么做？假设你是一名经理，与一名团队成员出现了问题，你会去问：“嘿，让我们确保我们在目标和角色上达成了一致”吗？这是你的处理方式，还是有其他方法？

---

### [00:44:24] Molly Graham

**English:**
So a lot of times what I do is two-sided, right? So it's like, "Hey, here's what I'm seeing and tell me what's going on for you. Do you know X, Y, Z?" When I take over a team, when I'm doing my listening tour, part of what I'm asking is, "What do you think your job is? What number were you hired to drive?" Because what you'll find is often their picture is different than your picture. You think you've been clear, you described an elephant and they spat out a tiger and that coming back to like, "Okay, no, we're building an elephant. You're in charge of the trunk." Will, in some percentage of cases, actually make a huge difference to the person's work and time and performance. In plenty of cases it doesn't, but that's always where I would start because it so often is just a more fundamental problem that then would lead you to look at other things across the team.

**中文翻译:**
很多时候我做的是双向沟通。我会说：“嘿，这是我观察到的情况，告诉我你那边是怎么回事。你知道某某事吗？”当我接手一个团队进行“倾听之旅”时，我必问的一个问题是：“你认为你的工作是什么？你被雇来推动哪个数字？”因为你会发现，他们的理解往往与你的不同。你以为你表达得很清楚，你描述的是一头大象，结果他们画出来的是一只老虎。回到“不，我们要造的是大象，你负责象鼻”这种共识上，在很大一部分情况下，会极大地改善一个人的工作、时间和绩效。虽然在很多情况下也没用，但我总是从这里开始，因为这通常是一个更根本的问题，解决了它，你才能去看团队中的其他事情。

---

### [00:45:20] Molly Graham

**English:**
But yeah, I would say two-way dialogue, but re-clarifying roles and expectations, re-describing the elephant over and over and over again, is one of the hardest parts about being a leader because you feel like a broken record, right? You feel like an idiot. You're like, "I've said this 45 times." Turns out no one heard you the first 43 and you have to. You have to re-describe it in order for people to hear you and to re-understand their sort of role in what they're doing.

**中文翻译:**
是的，我会说是双向对话。但不断地重新明确角色和预期，一遍又一遍地重新描述那只“大象”，是作为领导者最难的部分之一，因为你会觉得自己像个复读机。你会觉得自己像个白痴，心想：“我已经说了 45 遍了。”结果发现前 43 遍根本没人听进去。但你必须这么做。你必须不断重申，人们才能真正听进去，并重新理解他们在所做事情中的角色。

---

### [00:45:45] Lenny Rachitsky

**English:**
I love how you reframed the way I approached it by starting with, "Here's what I'm seeing. What are you seeing? What do you think your role is? " The very non-violent communication oriented, which is a clear pattern on this podcast, just the power of that specific framework.
**Molly Graham:** Yeah, totally. Well, like I said, work is about humans and it's...

**中文翻译:**
**兰尼·拉奇茨基：** 我很喜欢你重构我提问方式的做法，先从“这是我看到的，你看到了什么？你认为你的角色是什么？”开始。这非常有“非暴力沟通”的色彩，这也是本播客中经常出现的一个模式，体现了这种特定框架的力量。
**莫莉·格雷厄姆：** 是的，完全正确。就像我说的，工作关乎于人，它是……

---

### [00:46:01] Molly Graham

**English:**
Like I said, work is about humans and it's the art of organizing humans to get something done and build something that's greater than the sum of its parts and that is an art of the humanness in all of us, how do we get people to hear us, how do we get people aligned.
**Lenny Rachitsky:** Work for a lifetime.
**Molly Graham:** Totally.

**中文翻译:**
正如我所说，工作关乎于人，它是组织人类去完成某件事、去创造大于部分之和的事物的艺术。这是关于我们每个人人性中的艺术：我们如何让别人听见我们的声音，如何让大家达成一致。
**兰尼·拉奇茨基：** 这是一辈子的功课。
**莫莉·格雷厄姆：** 完全正确。

---

### [00:46:20] Lenny Rachitsky

**English:**
Today's episode is brought to you by GoFundMe Giving Funds, the zero fee donor advised fund. Did you make it New Year's resolution to give more? I want to tell you about a new product that GoFundMe has launched called Giving Funds which is a smarter and easier way to give. GoFundMe Giving Funds is a DAF or donor-advised fund from the world's number one giving platform trusted by over 200 million people, it's basically your own mini foundation without the lawyers or admin costs. You contribute money or stock, get the tax deduction right away and then decide later where you want to donate. There are zero admin or asset fees and, while the money sits there, you can invest and grow a tax-free so that you can give more later. GoFundMe is a FinTech unicorn working for good. Make a better world in 2026 and start your Giving Fund today at gofundme.com/lenny. They'll even cover your DAF pay fees if you transfer your existing DAF over. That's gofundme.com/lenny to start your giving fund.

**中文翻译:**
本期节目由 GoFundMe Giving Funds 赞助，这是一家零费用的捐赠者建议基金（DAF）。你是否制定了多做慈善的新年计划？我想向你介绍 GoFundMe 推出的一款名为 Giving Funds 的新产品，这是一种更智能、更简单的捐赠方式。GoFundMe Giving Funds 是来自全球第一大捐赠平台的 DAF，受到超过 2 亿人的信任。它基本上是你自己的微型基金会，无需律师或管理费用。你捐赠现金或股票，立即获得税收抵免，然后稍后决定捐给哪里。这里没有管理费或资产费，资金存放期间可以免税投资增长，让你以后能捐得更多。GoFundMe 是一家为善而生的金融科技独角兽。在 2026 年创造一个更美好的世界，今天就在 gofundme.com/lenny 开始你的 Giving Fund。如果你转入现有的 DAF，他们甚至会承担你的转账费用。

---

### [00:47:17] Lenny Rachitsky

**English:**
Okay, so let me actually follow this thread of the importance of goals and just being clear around this stuff. You have these six rules for creating clear goals and alignment on teams, talk about these six roles.

**中文翻译:**
好，让我们继续探讨目标的重要性以及明确目标的话题。你有一套关于在团队中建立清晰目标和共识的“六条规则”，聊聊这六条规则吧。

---

### [00:47:30] Molly Graham

**English:**
Yeah, totally. I feel like there should be less than six but it's where we're at. I would say, at a high level, two things before I get to the six. One is that I definitely have a bone to pick with OKRs, I feel like it's obviously been a really helpful framework for Google and others and, a lot of times, when I show up inside a company or I'm talking to a leader and I'm like, "What are your goals?" what I get back is this spreadsheet that has 100 lines and feels like it's written in Greek and, when I look at it, I'm like, " This doesn't create clarity for anyone." And it brings me back to what is the point of goals, why do we have them and, at the end of the day, goals are a communication tool, that's what they are. They're a communication tool designed to create clarity, to help people know I'm going to show up at my desk, what should I work on, what's the most important thing and your 100-line spreadsheet doesn't help anybody.

**中文翻译:**
好。我觉得应该少于六条，但目前就是这六条。在讲这六条之前，我想先说两点。第一，我对 OKR（目标与关键结果）确实有些微词。虽然它对谷歌等公司很有帮助，但很多时候当我走进一家公司问领导者“你们的目标是什么”时，我得到的是一份有 100 行、读起来像希腊语一样的电子表格。我一看就觉得：“这根本没法给任何人带来清晰感。”这让我回到了目标的本质：我们为什么要设定目标？归根结底，目标是一种“沟通工具”。它们旨在创造清晰度，帮助人们知道：当我坐在办公桌前，我该做什么？什么才是最重要的？而你那 100 行的表格帮不了任何人。

---

### [00:48:23] Molly Graham

**English:**
And the second thing I would just say is you really have to ask the question what is right for me at this company and this stage, what is right for a seed stage company is not what is right for a company that's got an established business and a clear go-to-market machine. So, when I'm building in seed stage, I'm setting goals every two months in a very iterative way. When I have an established business, I can actually set annual goals but annual goals for early stage companies is just a waste of time. So, anyway, a lot of my goal setting stuff actually comes from Facebook which I think was very, very good at this.

**中文翻译:**
第二点是，你必须问自己：对于这家公司和这个阶段，什么才是合适的？种子期公司合适的目标，对于一家拥有成熟业务和清晰市场推广机制的公司来说是不合适的。当我在种子期公司时，我会以迭代的方式每两个月设定一次目标。而当我拥有成熟业务时，我可以设定年度目标。但对早期公司来说，设定年度目标纯属浪费时间。总之，我的很多目标设定方法其实源于 Facebook，我认为 Facebook 在这方面做得非常好。

---

### [00:48:58] Molly Graham

**English:**
So, the first role is that no company needs more than three company goals and the point of company goals is to help people know what the most important things are to success. So, Facebook basically had three goals for the entire time I was there, it was five years and we did six-month goal setting, I think we did annual goal setting that ended up getting reset every six months but whatever. So, the three goals were this, there was growth which was measured as monthly active users, that was the externally reported number eventually, MAUs. The second goal was engagement meaning how often do people come back and use the site and the third was revenue and we literally had three goals for the five years that I was there. If you can govern that business with three goals, you can govern literally any business with three goals. So, no company needs more than three goals.

**中文翻译:**
第一条规则是：任何公司都不需要超过三个公司级目标。公司目标的意义在于帮助人们了解成功的关键因素。我在 Facebook 的五年里，公司基本上只有三个目标。我们每六个月设定一次目标（虽然也有年度目标，但每半年就会重设）。这三个目标分别是：第一，增长（Growth），以月活跃用户数（MAU）衡量，这是最终对外公布的数字；第二，参与度（Engagement），即用户回访和使用网站的频率；第三，收入（Revenue）。我在那里的五年里，真的就只有这三个目标。如果你能用三个目标管理那样的业务，你就能用三个目标管理任何业务。所以，任何公司都不需要超过三个目标。

---

### [00:49:52] Molly Graham

**English:**
The second thing is that one goal needs to win in a fight. So, if I'm sitting down and asking how do I prioritize my time on a given day I need to know what is the most important thing. At Facebook, we had growth and there's a lot of different ways you can add monthly active users to a social media site including you can go buy a whole bunch of bots in Indonesia and that would add to your MAU number but it would not add to your engagement number and it was very clear for the entire time that I was there that engagement was the most important thing. Acquiring users that were going to use the site all the time, that's what drives revenue, it's also what drove the heart of that site. So, if you had to prioritize something, you prioritized engagement, that goal won in the fight.

**中文翻译:**
第二条是：必须有一个目标能在“打架”时胜出。也就是说，当我坐下来思考今天如何分配时间时，我需要知道哪件事最重要。在 Facebook，我们有增长目标，增加月活用户有很多方法，比如去印尼买一堆机器人账号，这能增加 MAU，但不会增加参与度。在我待在那里的整个时间里，大家都非常明确：参与度是最重要的。获取那些会一直使用网站的用户，这才是驱动收入的动力，也是网站的核心。所以，如果你必须做优先级排序，参与度永远排在第一位。这个目标在竞争中胜出。

---

### [00:51:03] Molly Graham

**English:**
The third I'll say is, I call it the explain it to me like I'm five goal, but an intern that started on Monday should be able to look at your goals and understand them and, if they can't, then you are failing because they are not a communication tool that's effective. You have to be able to understand the goals, you have to explain the acronyms, you have to have numbers that make sense to average people, otherwise, again, it fails as a communication tool.

**中文翻译:**
第三条，我称之为“像对五岁小孩解释一样”的目标。一个周一刚入职的实习生应该能看懂你的目标。如果他们看不懂，那你就失败了，因为目标没有起到有效的沟通作用。你必须让目标易于理解，解释清楚缩写词，使用普通人能听懂的数字，否则，它就失去了沟通工具的意义。

---

### [00:51:30] Molly Graham

**English:**
The fourth one is ... Actually, I stole a phrase from Claire Hughes Johnson who you've had on your podcast but wrote a book called Scaling People and in it she says this sentence that I love which is strategy should hurt. And my role used to be set non-goals, basically, make it as clear what you're not going to do as what you are going to do but strategy should hurt is a much better way to explain it to people which is, if you're not making trade-offs that are painful, you are not actually helping people prioritize their time. Because the nature of work is that people will show up every day and do something and either you are very clear with them about what the priorities are or they're going together to prioritize for you because they're going to choose what they work on every day. And we see this so much with founders where they can't cut things off the list, they just have to have the 10 goals and I'm like, "Cool. Six of these goals are not going to get done so either you pick which four it is or other people are going to pick for you." So, strategy should hurt. If your goal setting process is not painful, then you're not prioritizing heavily enough.

**中文翻译:**
第四条是……实际上，我借用了 Claire Hughes Johnson 的一句话（她也上过你的播客，写过一本《Scaling People》），她说了一句我非常喜欢的话：战略应该是痛苦的（Strategy should hurt）。我以前的规则是“设定非目标”（Set non-goals），即明确哪些事是不做的。但“战略应该是痛苦的”是更好的解释方式：如果你没有做出痛苦的权衡，你就没有真正帮助人们排列优先级。因为工作的本质是人们每天都会来上班做点什么，如果你不明确优先级，他们就会替你做决定，因为他们每天都会选择自己想做的事。我们经常看到创始人无法从清单上删减任务，非要设定 10 个目标。我会说：“好极了，这 10 个里有 6 个肯定完不成，要么你选出哪 4 个最重要，要么让别人替你选。”所以，战略应该是痛苦的。如果你的目标设定过程不痛苦，说明你的优先级排得不够狠。

---

### [00:52:09] Molly Graham

**English:**
Okay, ready? We're on number five. This is more of an organizational point but it's really important for the waterline model too which is that one goal has one owner. You have a number, that number has a name next to it. If you cannot do that work, you haven't done the most important work to actually make sure that these goals get accomplished. And it's organizational work and it's very painful because sometimes it feels like, oh, this person can own it or this, maybe they'll just own it together, two people owning a goal is no one owning a goal. One person owns the goal, who is it? It's not you as the CEO, it's someone that works for you so one goal, one owner.

**中文翻译:**
准备好听第五条了吗？这是一个组织层面的观点，对水位线模型也至关重要：一个目标，一个负责人。你有一个数字，那个数字旁边必须有一个名字。如果你做不到这一点，你就没有完成确保目标达成的最重要工作。这是组织工作，而且非常痛苦，因为有时你会觉得“哦，这个人可以负责，或者那个人也可以，干脆让他们共同负责吧”。但两个人负责等于没人负责。必须有一个人负责，那是谁？不能是你这个 CEO，必须是为你工作的人。所以，一个目标，一个负责人。

---

### [00:53:10] Molly Graham

**English:**
And then the last, which is the hardest, is that goals by themselves are not enough. I've spent a lot of time with founders that are like, "I did it. I set the goals. Why not working? I don't understand." And I'm like, "What did you do after you set the goals?" And they're like, "I don't know, I set the goals." Goals ... James Clear who wrote Atomic Habits has this really lovely sentence which is winners and losers have the same goal. Goals by themself are not enough, you have to have a process by which you follow up on the goals and you hold people accountable to the goals and you learn from the goals because so much of goal setting, particularly if you're earlier in building your company, is about learning from trying to do something. You set a goal, can we do it, how hard is it to move this number, that is the ... You might be wrong all the time but you're learning what it takes to move the number. So, setting the goal by itself, not enough, you have to build a process in the system to actually learn from the goal.

**中文翻译:**
最后一条，也是最难的一条：目标本身是不够的。我花了很多时间与创始人交流，他们会说：“我做了啊，我设定了目标。为什么没用？我不明白。”我会问：“设定目标后你做了什么？”他们说：“我不知道，我就设定了目标啊。”《原子习惯》的作者詹姆斯·克利尔有一句非常棒的话：赢家和输家拥有相同的目标。目标本身是不够的，你必须有一套流程来跟进目标，让人们对目标负责，并从目标中学习。因为目标设定的很大一部分意义（尤其是对于早期公司）在于通过尝试来学习。你设定一个目标，看我们能否做到，移动这个数字有多难……你可能一直都是错的，但你在学习如何移动那个数字。所以，光设定目标是不够的，你必须建立一套系统流程来从目标中学习。

---

### [00:53:53] Lenny Rachitsky

**English:**
Wow. This list is ... There's so much power in this list, it's such a succinct-
**Molly Graham:** It's too long.
**Lenny Rachitsky:** No, I don't think it is because each of these has so much depth and power to them that saves you so much headache and just wasted time and resources. Just the idea of one owner, one goal, something I've personally discovered to have such power because, and correct me if I'm missing something here but just, if you feel like someone else may be doing the thing or feels like it's not just fully your responsibility, there's so much less energy and just mental ... I don't know. You just don't care as much about hitting that goal. And if it's you-

**中文翻译:**
**兰尼·拉奇茨基：** 哇。这份清单……非常有力量，而且非常简洁……
**莫莉·格雷厄姆：** 太长了。
**兰尼·拉奇茨基：** 不，我不觉得长，因为每一条都有很深的内涵和力量，能省去很多麻烦，避免浪费时间和资源。就说“一个负责人，一个目标”这个想法，我个人发现它非常有威力。如果我觉得别人可能也在做这件事，或者觉得这不完全是我的责任，投入的精力和心理关注度就会少很多。你对达成目标的渴望就没那么强烈。但如果是你——

---

### [00:54:29] Molly Graham

**English:**
Yeah, accountability.
**Lenny Rachitsky:** Yeah. If it's like, "Lenny, this goal is your goal and, if you hit it, you've done it. If you don't, you've done a bad job," that'd be a such motivating, so motivating. If it's me and Molly, okay, well, we'll figure it out.
**Molly Graham:** It creates a flood of clarity that seeps down from the person too. And to go back to the waterline model, I would say, so often you'll actually find companies that have set goals but no one owns the goals, everyone owns the goals, multiple people own the goal and you didn't actually get all the way to the answer. And I will say that the ownership thing is hard, it can feel painful but it's really important. There's only one owner and that means that that person, come hell or high water, owns that number.

**中文翻译:**
**莫莉·格雷厄姆：** 是的，这就是问责制。
**兰尼·拉奇茨基：** 没错。如果说：“兰尼，这个目标就是你的，达成了就是你的功劳，没达成就是你没干好。”那会非常有动力。如果是“我和莫莉”，那好吧，我们一起看着办吧。
**莫莉·格雷厄姆：** 这也会产生一种自上而下的清晰感。回到水位线模型，你会发现很多公司设定了目标，但没人负责，或者每个人都负责，或者多个人负责，这其实并没有真正解决问题。我得说，明确责任归属很难，甚至会让人感到痛苦，但它非常重要。只能有一个负责人，这意味着那个人无论如何都要对那个数字负责。

---

### [00:55:16] Lenny Rachitsky

**English:**
Yeah. The way I described it [inaudible 00:55:18] was just someone's ass has to be on the line for this and that just works. That's such a powerful lever to drive things to have one person responsible.
**Molly Graham:** Yeah.
**Lenny Rachitsky:** The other's just this idea of strategy hurting, I love that. I love that phrase, I forgot Claire had that. So true.
**Molly Graham:** So good.
**Lenny Rachitsky:** Because the whole idea is you need to not do things, you need to decide what you're not ... The whole strategy, a big part of it is what we are not doing.
**Molly Graham:** Yeah, absolutely. And if you're not making painful choices, then you're not actually doing it.

**中文翻译:**
**兰尼·拉奇茨基：** 是的。我之前的描述是，必须有人为此“担责任”（Ass on the line），这很奏效。让一个人负责是推动事情发展的强大杠杆。
**莫莉·格雷厄姆：** 没错。
**兰尼·拉奇茨基：** 另一个就是“战略应该是痛苦的”，我太喜欢这句话了。我都忘了 Claire 说过这个。太对了。
**莫莉·格雷厄姆：** 讲得太好了。
**兰尼·拉奇茨基：** 因为核心在于你必须“不做”某些事，你必须决定哪些是不做的……整个战略的一大部分就是“我们不做什么”。
**莫莉·格雷厄姆：** 绝对正确。如果你没有做出痛苦的选择，那你其实并没有在制定战略。

---

### [00:55:49] Lenny Rachitsky

**English:**
And this idea of three goals, so is it just ... So, do you go into a company and just go through a checklist essentially of here's the six things I look at to tell me where there's opportunity to improve?

**中文翻译:**
关于“三个目标”的想法，所以……当你进入一家公司时，你基本上就是按照一个清单来检查这六件事，以此判断哪里有改进的机会吗？

---

### [00:55:58] Molly Graham

**English:**
When I work with founders and I see their goals, I use it as a way to get to know the business and I'm just going to be literally like, "What is this? What are you trying to explain?" And I can usually, through asking a lot of really dumb questions which, like I said, one of my superpowers, get them to explain to me the one sentence and the one number that they're actually trying to get across but it takes work and that's part of ... It's almost easier to write the 100-line spreadsheet than it is to say, "Wait, what are the three drivers of this business genuinely? What are they and how do they relate to each other?" And there can be things underneath them but there's three at the top that matter. So, yeah, I'm not a scientific person about it but a lot of it is just by asking people to explain their businesses to me, you can basically find the drivers.

**中文翻译:**
当我与创始人合作并查看他们的目标时，我会以此为契机去了解业务。我会直截了当地问：“这是什么？你想表达什么？”通过问很多“蠢问题”（正如我所说，这是我的超能力之一），我通常能让他们用一句话和一个数字解释清楚他们真正想传达的东西。但这需要功夫。写 100 行的电子表格其实更容易，难的是说清楚：“等等，这家业务真正的三个驱动因素是什么？它们是什么，彼此之间有什么关系？”在它们之下可以有其他东西，但顶层只有三个最重要的。所以，我并不是用科学的方法，很大程度上只是通过让人们向我解释他们的业务，从而找到核心驱动因素。

---

### [00:56:51] Lenny Rachitsky

**English:**
And the story about Facebook having these same three goals for five years, considering their success, you may think they're not as complicated as your business but I am confident they're just as, if not, more complicated. They're a marketplace, a social network, they're a ad business, just they're ... There's a lot going on and, if they can work with three goals, you can do that too. And to your point, if it's not hurting, then you're doing something wrong.
**Molly Graham:** Yeah, exactly.

**中文翻译:**
**兰尼·拉奇茨基：** 考虑到 Facebook 的成功，他们五年里一直坚持同样的三个目标。你可能觉得你的业务比他们复杂，但我敢肯定，他们的业务即便不比你的更复杂，也至少旗鼓相当。他们既是平台、社交网络，又是广告业务……涉及面非常广。如果他们能用三个目标运作，你也可以。而且正如你所说，如果不感到痛苦，那说明你做错了。
**莫莉·格雷厄姆：** 没错。

---

### [00:57:18] Lenny Rachitsky

**English:**
I love how ... This is very much what I wanted this chat to be. It feels like every little segment is its own, could be its own podcast where we could talk about this for hours so I'm really excited how this is going. Moving on to another topic, you have not necessarily rules but rules of thumb that you find really helpful for people to have in their head as they're dealing with change and scale and growth and all that kind of stuff so let's just walk through that.

**中文翻译:**
我太喜欢这种节奏了……这正是我希望这次对话呈现的样子。感觉每一个小片段都可以单独做成一集播客，我们可以聊上好几个小时。我对现在的进展感到非常兴奋。换个话题，你有一些“经验法则”（Rules of thumb），你觉得人们在应对变革、扩张和增长时，脑子里记住这些会非常有帮助。让我们来过一遍。

---

### [00:57:45] Molly Graham

**English:**
Yeah. So, for leaders that are leading through change and growth, the list is probably long but I always say to people don't come to me for management 101, I'm not the person to ask on how to run the most effective one-on-one with your people. What I think is not talked about enough is what it takes to manage and lead through change and that is a very particular set of feelings. And the first thing I learned, when someone makes you a manager or when you take a job as a leader inside a company, you really do feel like, "Oh, who gave me this job?" and you feel like you're supposed to know the answer to things. People come to you and ask questions and you're like, "I'm supposed to know. I'm a leader, I am supposed to have answers."

**中文翻译:**
好的。对于那些带领团队经历变革和增长的领导者来说，清单可能很长。但我总对人说，别来找我学“管理 101”，我不是那个教你如何进行最有效的一对一谈话的人。我认为被讨论得不够多的是，在变革中进行管理和领导需要什么，那是一套非常特殊的感觉。我学到的第一件事是：当有人提拔你当经理，或者你在公司担任领导职务时，你真的会觉得“噢，是谁把这份工作给我的？”，并且觉得你应该知道所有答案。人们来问你问题，你会想：“我应该知道，我是领导，我应该有答案。”

---

### [00:58:35] Molly Graham

**English:**
And I think, particularly inside of rapid change and scale and growth, it's really important to understand that your job as manager and a leader is not to have all the answers. It is not to have all the answers, it is to get good at finding them, it is to get good at bringing people together to find the answers. And that is hard because it requires saying, "I don't know, let's go figure it out," a whole bunch and it's scary as a leader to say I don't know because you think, "Oh, gosh, people are going to see through me." But again, the more you travel in life, the more you realize that the most experienced leaders are the ones that say, "No, no, no," all the time.

**中文翻译:**
我认为，特别是在快速变革、扩张和增长的过程中，理解这一点至关重要：作为经理和领导者，你的工作不是拥有所有答案。绝对不是。你的工作是擅长“寻找”答案，擅长召集大家一起找到答案。这很难，因为这需要你经常说“我不知道，让我们一起去弄清楚”。作为领导者，说“我不知道”是很可怕的，因为你会觉得“天哪，大家会看穿我的”。但随着阅历增加，你会发现最有经验的领导者反而是那些经常说“不，不，不（我不知道）”的人。

---

### [00:59:13] Lenny Rachitsky

**English:**
I think this is a good reminder of this Bob the monster concept because, hearing this, okay, I don't need to have all the answers as a leader. In real life, being in a meeting, people are like, "Hey, Molly, what do you think of this?" You're like, "Oh, I should have a good answer." And so, I think that's a good reminder of this idea of this Bob the monster is going to tell you, "Oh, you don't know anything, you're not ready for this. You suck at this, you're going to fail everyone that's [inaudible 00:59:34]."
**Molly Graham:** They're regretting hiring you.
**Lenny Rachitsky:** Yeah, exactly.
**Molly Graham:** Everyone's going to see through you. Imposter, imposter, imposter.
**Lenny Rachitsky:** Yeah, 100%.

**中文翻译:**
**兰尼·拉奇茨基：** 我觉得这很好地呼应了“怪物鲍勃”的概念。听起来，“作为领导者我不需要知道所有答案”很容易，但在现实生活中，在会议上，人们问：“嘿，莫莉，你怎么看？”你会觉得：“噢，我得给个像样的回答。”所以，这提醒了我们，那个“怪物鲍勃”会跳出来说：“噢，你什么都不懂，你还没准备好。你太差劲了，你会让所有人失望……”
**莫莉·格雷厄姆：** “他们后悔雇了你。”
**兰尼·拉奇茨基：** 没错。
**莫莉·格雷厄姆：** “大家都会看穿你。冒牌货，冒牌货，冒牌货。”
**兰尼·拉奇茨基：** 是的，百分之百。

---

### [00:59:44] Molly Graham

**English:**
Absolutely. And these things are muscles. Dealing with Bob as a muscle, learning to not react to all those things that attack you but also learning, oh, in this moment when someone asks me a question and I'm like, "Oh," actually I should be like, "I don't actually know, let's go ... Who should we ask? How can we learn this? How can we explore this together? What do you think?" Those are all actually very powerful questions and they're terrifying to, particularly earlier in your career, as a leader and a manager.

**中文翻译:**
绝对是这样。这些都是需要锻炼的“肌肉”。对付鲍勃是一种肌肉记忆，学会不对那些攻击你的念头做出反应，同时学会：当有人问我问题而我感到局促时，我其实应该说：“我其实不知道，让我们……我们该问谁？我们怎么能学到这个？我们如何一起探索？你怎么看？”这些其实都是非常有力量的问题，但对于职业生涯早期的领导者和经理来说，问出这些问题是令人生畏的。

---

### [01:00:11] Lenny Rachitsky

**English:**
Awesome. So, yeah, so the lesson there is no one expects you to have all the answers as a leader.
**Molly Graham:** No.
**Lenny Rachitsky:** Awesome.
**Molly Graham:** And particularly in this world, the one that's changing as fast as it is, nobody knows. Nobody knows what the answers are in a lot of cases, the war will be won by the people that are good exploring and figuring it out.

**中文翻译:**
**兰尼·拉奇茨基：** 太棒了。所以，教训就是：作为领导者，没人指望你知道所有答案。
**莫莉·格雷厄姆：** 没错。
**兰尼·拉奇茨基：** 很好。
**莫莉·格雷厄姆：** 尤其是在这个变化如此之快的世界里，没人知道。在很多情况下，没人知道答案。最终的胜利将属于那些擅长探索和解决问题的人。

---

### [01:00:29] Lenny Rachitsky

**English:**
I love that phrase.
**Molly Graham:** So, the second one is, and everyone that has learned this has learned it the hard way, do not promise things that you can't control. It's so tempting particularly when you're hiring people to be like, "Oh, yeah, your onboarding will be smooth and calm and everything's clear and we've figured it ... Let us tell you our vision and how obvious and clear and smart and blah, blah, blah." And then they show up and it's like, "Oh, shit," you know what I mean? There's no manual, no one knows what they're doing, it's all ambiguity and chaos.

**中文翻译:**
**兰尼·拉奇茨基：** 我喜欢这句话。
**莫莉·格雷厄姆：** 第二条，每个学到这一条的人都是通过惨痛教训学到的：不要承诺你无法控制的事情。这非常有诱惑力，尤其是在招人时，你会说：“噢，是的，你的入职过程会非常顺利、平静，一切都很清晰，我们都搞定了……让我们告诉你我们的愿景，它是多么显而易见、清晰且聪明，等等等等。”结果他们一入职，发现：“噢，该死。”你懂我意思吗？没有手册，没人知道自己在干嘛，到处都是模糊和混乱。

---

### [01:01:20] Molly Graham

**English:**
It's so easy when someone says I want to know that I'm going to be your CMO forever to be like, "Sure, you can be my CMO," you don't know that. Do you know what I mean? So, being really careful with promises of things that are out of your control like stability or titles or never hiring over someone is a flashing red light because there is literally no faster way to demoralize high performers than going back on a promise. Everyone that has been through it knows that feeling of like, "They told me this when I joined," and then they don't do it and you're like, "Well, fuck this place." So, no faster way to demoralize people or to hire the wrong people than promising things that are actually out of your control. Being honest and upfront about who you are as a company, about what you're able to promise, all of that is actually ... It's very hard work but it's so important because so much is out of your control and you need to hire people that are cool with that.

**中文翻译:**
当有人说“我想知道我会永远担任你的 CMO”时，你很容易随口答应：“当然，你可以一直当我的 CMO。”但你根本无法预知未来。你懂吗？所以，对于那些你无法控制的事情，比如稳定性、头衔，或者承诺永远不会在某人头上空降老板，必须非常小心。这些都是“闪烁的红灯”，因为没有什么比违背承诺更能打击高绩效人才的士气了。经历过的人都知道那种感觉：“我入职时他们是这么跟我说的”，结果他们没做到，你会想：“去他的吧。”所以，承诺那些你无法控制的事，是打击士气或招错人的最快方式。诚实、坦率地说明公司的现状以及你能承诺什么，这其实是非常艰巨的工作，但至关重要，因为有太多事情是你无法控制的，你需要招募那些能接受这种不确定性的人。

---

### [01:02:01] Lenny Rachitsky

**English:**
Love that. I learned this the hard way once, I had a ... One of my early projects, we were late and the head of product was just so pissed he's like, "Because I've been telling the CEO it's going to be on time because you've been telling me it's going to be on time and then it wasn't and why didn't you tell me that?" And I was just like, "Okay, it'll never happen again," and he's like, "You can't ... Don't tell me that because that's not true, that nay not ... You can't guarantee that." And so, that taught me that lesson of just, yeah, you're right, you want to say that, it feels so good. Okay, this will never happen again but you can't and they know you can't promise things like that.

**中文翻译:**
太棒了。我也曾有过惨痛教训。在我早期的一个项目中，我们进度落后了，产品负责人非常生气，他说：“因为我一直告诉 CEO 会按时完成，因为你一直告诉我能按时完成，结果没做到，你为什么不早告诉我？”我当时说：“好吧，这种事再也不会发生了。”他回答：“你不能……别跟我说那个，因为那不是真的，你无法保证这一点。”这给我上了一课：是的，你是对的，你想那么说，那听起来很好——“好的，这再也不会发生了”——但你做不到，而且他们也知道你无法承诺这种事。

---

### [01:02:38] Molly Graham

**English:**
Yeah. And sorry, I'm going to quote Claire Hughes Johnson again but she has this really fun phrase that she said in a talk at Glue Club that I've now latched onto and stolen from her which is, she was like, "Promises like that are like letter bombs that you mail yourself that are going to explode in your face in a year," and I was like, "That is the perfect metaphor." Because it's short-term pain, you want to make this person feel good right now so you promise them something but, in one year, you're going to make them feel terrible so don't do it.

**中文翻译:**
没错。抱歉，我要再次引用 Claire Hughes Johnson 的话。她在 Glue Club 的一次演讲中说了一个非常有趣的短语，我一直记着并“偷”了过来。她说：“那样的承诺就像是你寄给自己的一封‘挂号信炸弹’，一年后会在你脸上爆炸。”我觉得这个比喻太完美了。因为那是为了逃避短期的痛苦，你想让这个人现在感觉良好，所以你承诺了某事，但一年后，你会让他们感觉糟透了。所以，别这么做。

---

### [01:03:10] Lenny Rachitsky

**English:**
Great advice. All right, keep going.
**Molly Graham:** Yeah. So, again, could probably go on the topic of what it takes to manage and lead forever inside this stuff but I'll give you two more that I yell about a lot in Glue Club. The first is that we spend huge amounts of time talking about hiring. How do you get good at hiring? What's the right interview? How do I find the right people? Firing people is as important as hiring people. Getting good at identifying when someone does not belong or someone is not going to work out is actually a skill and being good at it as a company and as a leader is as important as identifying the right talent because, eventually, if you're not good at firing people, what you have is essentially barnacles on a ship. Really going forward with the ship metaphor, anyway.

**中文翻译:**
**兰尼·拉奇茨基：** 极好的建议。好，继续。
**莫莉·格雷厄姆：** 好的。关于在这些环境下如何管理和领导，我可以永远聊下去，但我再给你两个我在 Glue Club 经常强调的点。第一，我们花了大量时间讨论招聘：如何擅长招聘？正确的面试流程是什么？如何找到对的人？但“解雇”和“招聘”一样重要。学会识别某人不合适或某人无法胜任，实际上是一项技能。作为公司和领导者，擅长解雇与识别优秀人才同样重要。因为最终，如果你不擅长解雇，你的船上就会长满“藤壶”（Barnacles）。我真是要把这个“船”的比喻用到底了。

---

### [01:04:00] Molly Graham

**English:**
It's true.
**Molly Graham:** It's drag people that are sitting around not pushing the team forward. So, it's painful and it's horrible because it is humans but, when someone doesn't fit, you ... No one is right all the time when it comes to hiring, I actually say most people are wrong half the time. The best people in the world in hiring will tell you they have about a 50% average in terms of being right. That means half the hires don't work out. That means, half the time, you're going to need to fire the person. So, it's such an important skill to get good at particularly when you're going through a lot of change.

**中文翻译:**
**兰尼·拉奇茨基：** 确实如此。
**莫莉·格雷厄姆：** 那些坐在那里却不推动团队前进的人就是阻力。这很痛苦，也很糟糕，因为涉及的是人。但当某人不合适时……在招聘方面没人能永远正确。我常说大多数人有一半时间是错的。世界上最擅长招聘的人也会告诉你，他们的准确率大约只有 50%。这意味着一半的招聘是不成功的。这意味着，有一半的时间你需要解雇那个人。所以，这是一项非常重要的技能，尤其是在经历剧烈变革时。

---

### [01:04:40] Molly Graham

**English:**
And the last one is humans are messy and it's very emotional. And when you're a leader, particularly if you have any kind of anagram too or just if you like to make people happy and you want to be liked, it can be so hard to lead teams because you get tangled in the people. Firing people is a painful experience, reorganizing things, layering people, all these things are emotionally painful for the people and they're emotionally painful for you as a manager. But my mantra that almost always leads in the best direction is serve the business, not the people meaning everyone is better off if this company is wildly successful. Everyone looks smart and makes lots of money or whatever if this company grows and does what we all dream it can.

**中文翻译:**
最后一点是，人是复杂的，而且非常感性。当你是一名领导者，特别是如果你有某种性格倾向（比如九型人格中的某种），或者你只是喜欢让别人开心、想被大家喜欢，那么领导团队会变得非常困难，因为你会陷入人际关系的纠缠中。解雇人是痛苦的经历，重组架构、架层管理，所有这些对员工来说在情感上是痛苦的，对你这个经理来说也是如此。但我的座右铭（几乎总能指引正确的方向）是：“服务于业务，而非个人”。这意味着，如果公司大获成功，每个人的处境都会变好。如果公司成长并实现了大家的梦想，每个人都会显得很聪明，赚很多钱，等等。

---

### [01:05:30] Molly Graham

**English:**
So, at the end of the day, the best decisions, the ones that are always going to be right are the ones that are like, "How do we do the right thing for this business?" And it also helps in political situations. Someone's acting weird or their Bob is raging all over the company, technically, everyone has the same goal. The goal is to build the biggest business possible, that's the answer. The answer is always what's the right thing for the business. And the people stuff can fall away when you actually focus on what's the right thing for the business.

**中文翻译:**
所以，归根结底，最好的决策、那些永远正确的决策，都是基于“我们如何做对业务正确的事？”这在处理政治局势时也很有帮助。如果有人表现怪异，或者他们的“鲍勃”在公司里到处发飙，从技术上讲，大家的目标是一致的：建立尽可能大的业务。这就是答案。答案永远是“什么对业务最有利”。当你真正专注于业务时，那些人际纠纷就会消散。

---

### [01:05:55] Lenny Rachitsky

**English:**
A really useful tool to do that that I learned from my manager is to think about, when you're trying to decide whether to fire someone or change a project even though it's going to upset someone, is to say, "Okay, if there were no emotions involved, if this person had no negative reaction to this, what would I do?" And then that's the thing you should do and then you just do it. And then the question is how do I communicate this to them where their pain is lowest essentially.
**Molly Graham:** In the kindest way possible.
**Lenny Rachitsky:** In the kindest way possible. And because, to your point, if you optimize for the other thing of making people feel good, everything just falls apart, they're going to suffer even more down the road.

**中文翻译:**
**兰尼·拉奇茨基：** 我从我的经理那里学到了一个非常有用的工具。当你纠结于是否解雇某人或更改项目（即使这会让某人不爽）时，试着想：“好吧，如果不涉及情感，如果这个人对此没有任何负面反应，我会怎么做？”那就是你应该做的事，然后就去做。接下来的问题是：我该如何沟通，才能将他们的痛苦降到最低。
**莫莉·格雷厄姆：** 用最友善的方式。
**兰尼·拉奇茨基：** 用最友善的方式。因为正如你所说，如果你为了让人们感觉良好而优化决策，一切都会分崩离析，他们以后会遭受更多的痛苦。

---

### [01:06:38] Molly Graham

**English:**
Yeah, absolutely. Direct is kind. And it feels kind or, really, honestly, easy to avoid these things or to work around them or to not but, at the end of the day, it's basically just a drag, the barnacle thing. It drags on your company, on your time, on your energy, et cetera.

**中文翻译:**
是的，绝对正确。直接就是一种友善。虽然避开这些问题、绕道而行或者干脆不做，看起来很“友善”或者说更容易，但归根结底，这只是一种拖累，就像藤壶一样。它会拖累你的公司、你的时间、你的精力等等。

---

### [01:06:58] Lenny Rachitsky

**English:**
Yeah. But again, very hard to do in real life to do the thing that's hard and cause someone to be sad and upset and frustrated and maybe leave.
**Molly Graham:** It is so hard and all these things are muscles, you get better at ... They don't become easy, it's not like anybody who's like, "Oh, it's so ... I enjoy firing people," no, but you recognize it faster and you are like, "Oh, I need to go do this." And that is actually ... It's a practice and something that you need to practice to become the kind of leader that leads these long-enduring companies.

**中文翻译:**
**兰尼·拉奇茨基：** 是的。但在现实生活中，做那些艰难的决定，导致某人悲伤、难过、沮丧甚至离开，依然非常困难。
**莫莉·格雷厄姆：** 确实很难。所有这些都是“肌肉”，你会变得更擅长……它们不会变得容易，没人会说“噢，我喜欢解雇人”。不，但你会更快地意识到问题，并想：“噢，我得去处理这件事。”这实际上是一种修行，是你为了成为那种能领导长青企业的领导者而必须进行的练习。

---

### [01:07:32] Lenny Rachitsky

**English:**
Yeah. And this tool of thinking, asking what would I do if there were no emotions involved and this person wouldn't be upset, it helps you realize, okay, I see, this actually doesn't make sense to just do it the easy way right now because it doesn't make sense.
**Molly Graham:** Yeah, it strips away. It strips away the emotions.

**中文翻译:**
**兰尼·拉奇茨基：** 是的。这种思考工具——问自己“如果没有情感因素，如果这个人不会生气，我会怎么做”——能帮你意识到：好吧，我明白了，现在只图省事其实是不合理的，因为那不符合逻辑。
**莫莉·格雷厄姆：** 没错，它剥离了情感。

---

### [01:08:02] Lenny Rachitsky

**English:**
Something else I wanted to make sure we spent a little time on is you have another tidbit along these lines which is around putting most of your energy into high performers versus spending all your time people that need help, talk about that.

**中文翻译:**
我还想确保我们花点时间讨论另一个相关的细节，那就是：将大部分精力投入到高绩效人才身上，而不是把所有时间都花在那些需要帮助的人身上。聊聊这个。

---

### [01:08:15] Molly Graham

**English:**
As a leader, as a manager, you're running these teams and someone's struggling and it's very easy to get dragged into that and to end up spending a huge amount of energy on it but high performers are actually the future of your company. And if you think about it and if you've spent time on it, those are the folks where, if you invest your time and energy in them, you're going to get the 10x return that people talk about all the time in Silicon Valley. But what I've witnessed is that most people have a high performer and they just leave them alone, they're like, "That person's doing well so I'm just going to let them do their thing."

**中文翻译:**
作为领导者或经理，当你管理团队时，如果有人陷入困境，你很容易被卷进去，并最终在那上面耗费巨大精力。但高绩效人才才是公司的未来。如果你仔细想想并付诸实践，你会发现，如果你把时间和精力投资在这些人身上，你就会获得硅谷常说的那种 10 倍回报。但我观察到的是，大多数人对待高绩效人才的方式是“随他们去”，他们觉得：“那个人做得很好，我就让他自己干吧。”

---

### [01:08:45] Molly Graham

**English:**
And what I do when I have a high performer that's my favorite thing in the world is invest time and energy in them and basically build a whole system of working with them that is designed to draw out potential. And I would say there's two things here, one is it's really important to realize that our tendency is to actually spend time on low performers and it is not a good use of your time. See the point about firing people. But the other thing is that actively investing in and developing high performers is something that's important to get good at as a leader because that is how you create these little rocket ships that end up... You'll manage someone who's just like a project manager and all of a sudden they're running a whole function inside the company eventually, but it's because you took time and energy to invest in them.

**中文翻译:**
而当我遇到高绩效人才时，我最喜欢做的事就是把时间和精力投在他们身上，建立一套协作系统来挖掘他们的潜力。这里有两点：第一，意识到我们的本能倾向是把时间花在低绩效者身上，这非常重要，因为那不是对时间的有效利用（参见关于解雇的观点）。第二，作为领导者，学会主动投资和培养高绩效人才是非常重要的，因为这就是你创造“小火箭”的方式。你可能管理着一个普通的项目经理，结果突然间他们最终负责了公司的整个职能部门，这正是因为你投入了时间和精力去培养他们。

---

### [01:09:52] Molly Graham

**English:**
And my basic way of doing that, not to... I could spend a long time on this, but I would just say is I run experiments. I basically develop a theory about someone, "I think this person is capable of this kind of thing." And then piece by piece, it doesn't have to be a whole job or whole project. It can just be an incremental experiment, "I'm going to see if they can do this with less guidance or support from me." I'm going to give them a bigger project. I'm going to give them something with more visibility. I'm going to manage them less, oversee them less, whatever. All of those are experiments to basically test your theory and deepen your theory in terms of this person's potential and their ability to help the company.

**中文翻译:**
我做这件事的基本方法是——我不细说了，这能讲很久——就是“做实验”。我先对某人建立一个假设：“我认为这个人有能力做这类事情。”然后一点一点地尝试，不需要是一份完整的工作或项目。可以只是一个增量实验：“我要看看他们在减少我的指导或支持的情况下，能否完成这件事。”我会给他们一个更大的项目，给他们更有曝光度的工作，或者减少对他们的管理和监督。所有这些都是实验，旨在测试并深化你对这个人潜力的假设，以及他们帮助公司的能力。

---

### [01:10:27] Molly Graham

**English:**
And you're basically, for me, what I'm doing is deeply getting to know that person and then trying to pair them with company needs. What do we need? This person is great at zebra farming. Where do we need zebra farming? So how do I get them working on bigger and bigger and more and more critical things? And to be honest, this is what people have done for me. At Facebook in particular, I've benefited from people being like, "Ooh, come help me with this thing." They saw potential in me and they asked me to help with something and it unlocked a huge amount for me. And so, it is such a powerful tool for getting more out of people that might be a little bit stuck if you leave them in this box. But if you start to expand the box, you can really unlock people.

**中文翻译:**
对我来说，我所做的本质上是深入了解那个人，然后尝试将他们与公司的需求匹配。我们需要什么？这个人擅长“养斑马”，哪里需要养斑马？我如何让他们参与到越来越大、越来越关键的事情中？坦白说，别人也是这样对我的。特别是在 Facebook，我受益于那些对我说“嘿，来帮我处理这件事”的人。他们看到了我的潜力，让我参与了一些事情，这为我开启了巨大的空间。所以，这是一个非常强大的工具，可以从那些如果被关在“盒子里”可能会停滞不前的人身上挖掘出更多价值。一旦你开始扩大那个盒子，你就能真正释放人才。

---

### [01:10:55] Lenny Rachitsky

**English:**
You've worked with many very high performing founder CEOs. Zuck, Cheryl Sandberg. Larry and Sergei at Google. Brett Taylor. I just want to spend a little time on what are some things you've learned, maybe a few things you've learned from them, that group that you find yourself sharing with other people most.

**中文翻译:**
你曾与许多表现卓越的创始人 CEO 共事过。扎克伯格、谢丽尔·桑德伯格，谷歌的拉里和谢尔盖，还有布雷特·泰勒——读他的简历都要花三行。我想花点时间聊聊你从他们身上学到了什么，或者说，你最常与别人分享的关于那个群体的几点教训。

---

### [01:11:26] Molly Graham

**English:**
That list is very long, but I'll give you a couple. The first one that I think is kind of counterintuitive is... So I said I worked at Facebook. I worked on culture, which is one of those words that doesn't really mean anything. So I define it as the way we do things around here. And I thought my job was to shape the culture. I thought it was to push the culture. And the most humbling lesson I learned is 80% of the culture of a company is literally defined by the personality of the founder. Facebook is Mark. Google is Larry and Sergei. Google, when I was there, it felt like a university. It's where ideas are more important in a lot of ways than what's shipped. And there's a campus and they basically wanted people to live there when I was there. It was designed to basically be a two PhD students' paradise.

**中文翻译:**
那个清单很长，但我给你举几个例子。第一个我认为有点反直觉的是……我说过我在 Facebook 负责文化工作，“文化”是那种其实没什么具体含义的词之一。所以我把它定义为“我们在这里做事的方式”。我曾以为我的工作是塑造文化、推动文化。但我学到的最让人谦卑的教训是：一家公司 80% 的文化实际上是由创始人的个性定义的。Facebook 就是马克。谷歌就是拉里和谢尔盖。我在谷歌时，那里感觉像一所大学。在很多方面，想法比发布的产品更重要。那里有校园，我当时在的时候，他们基本上希望员工住在那里。它被设计成两个博士生的天堂。

---

### [01:12:33] Molly Graham

**English:**
Facebook felt like a 19-year-old hacker's dorm room when I was there. And it was shipping above all and all else. And it seeped with Mark's DNA. And I spent ages trying to create various changes inside the company or trying to push a point. And Mark would say literally one thing in an all hands, and it was like somebody threw a boulder into the pond. So our job as operators or as leaders around founders is to help articulate the culture that they're creating and to help extend it. My version of founder mode, which I know you've spent some time on on this podcast is your job is to build a company that would make a decision the way the founder would when they're not in the room. That is the work of building a company around a founder, but your job is not to shape culture.

**中文翻译:**
我在 Facebook 时，那里感觉就像一个 19 岁黑客的宿舍。发布产品高于一切。它渗透着马克的 DNA。我曾花很长时间试图在公司内部创造各种变革或推动某个观点，但马克只要在全员大会上说一句话，就像往池塘里扔了一块巨石。所以，我们作为创始人身边的运营者或领导者，职责是帮助阐明他们正在创造的文化，并帮助延伸它。我对“创始人模式”（Founder mode）的理解——我知道你在播客里聊过这个——是：你的工作是建立一家公司，让它在创始人不在场时，也能做出和创始人一样的决策。这就是围绕创始人建立公司的工作，但你的工作不是去“塑造”文化。

---

### [01:13:24] Molly Graham

**English:**
That is mostly defined by the literal personality strengths and weaknesses of the person at the top. And that's been true of Mark and it's been true of Brett. Everywhere I go, that's who it is. You don't need a consulting firm to tell you, just go do a personality diagnosis on your founder. And the weaknesses thing is real. I've seen and watched friends try to shape a set of values at a company and it just doesn't match who the founder is. You say, "Move fast and break things," or whatever your version of that is. And your founder loves ambiguity and is perfectly happy with not making decisions. All that leads to is cultural dissonance. It leads to people being like, "Wait, what? I thought we said we care about moving fast and making aggressive decisions and it turns out..." So being really careful about what you say, because what people actually feel when it comes to culture is what you do and how you act every day.

**中文翻译:**
文化主要由最高层那个人的性格优点和缺点定义。马克是这样，布雷特也是这样。我所到之处皆是如此。你不需要咨询公司来告诉你，去给你的创始人做个性格诊断就行了。而且“缺点”这一点非常真实。我见过朋友试图在公司塑造一套价值观，但那套价值观与创始人的为人完全不符。你说“快速行动，打破常规”，或者类似的口号，但你的创始人却喜欢模糊性，并且对不做决定感到心安理得。这只会导致“文化失调”。这会让员工觉得：“等等，什么？我以为我们说要快速行动、果断决策，结果却是……”所以，要非常小心你所说的话，因为在文化方面，人们真正感受到的是你每天的所作所为。

---

### [01:14:18] Molly Graham

**English:**
You can never write anything down and you will still have a culture. It will be created through the actions and the decisions that you make and that your founder makes. So that would be a huge one.

**中文翻译:**
即使你什么都不写下来，你依然会有文化。它是通过你和你的创始人所做的行动和决策创造出来的。所以这是一个非常重要的教训。

---

### [01:14:28] Lenny Rachitsky

**English:**
Let me spend a little more time on this because this is so good. So all this advice on culture and it feels so true based on everything I've seen. So tip one there is just you can't really change the culture. Maybe there's a little bit on the edges you could adjust. It will come down and trickle down from the founder, CEO probably mostly, but just the founders in general.
**Molly Graham:** And founder-CEO is probably the single biggest.
**Lenny Rachitsky:** Founder-CEO.
**Molly Graham:** Co-founders, it depends a lot on the company. I think Stripe is probably very much like Patrick and John, but it's not every co-founder that has that level of power [inaudible 01:15:03].

**中文翻译:**
**兰尼·拉奇茨基：** 让我再多聊聊这个，因为这太棒了。关于文化的所有这些建议，根据我的所见所闻，感觉非常真实。所以第一点就是：你无法真正改变文化。也许你可以在边缘做一点微调，但它主要是从创始人、CEO 那里向下渗透的。
**莫莉·格雷厄姆：** 创始人兼 CEO 可能是影响最大的单一因素。
**兰尼·拉奇茨基：** 创始人兼 CEO。
**莫莉·格雷厄姆：** 至于联合创始人，这很大程度上取决于公司。我觉得 Stripe 可能非常像 Patrick 和 John，但并不是每个联合创始人都有那种程度的影响力。

---

### [01:15:03] Lenny Rachitsky

**English:**
Awesome. And then the way you describe culture, I think it's the way Seth Godin talks about it too, who's also been on the podcast. He said, "Culture is..." And what you said, "Culture is the way we do things around here. That's what culture is, is how we..." That's how people describe your culture is, "The way we do things around here."
**Molly Graham:** I ran culture, whatever the hell that means, at Facebook for a hot second. I literally haven't done a values exercise since. And it sounds crazy, right? Because in theory, I know how to do this stuff. I don't really know how to do this stuff. But for me, the point is process and systems and how do we make decisions? That's where culture actually lives. It is what you do. It's how you hire. It's how you fire. It's who you don't hire. It's all of those decisions. That is culture. So whenever I'm working with a company or building a company, that's what I'm focused on, not on what's the shiny word that we're putting on the wall. You know what I mean?

**中文翻译:**
**兰尼·拉奇茨基：** 太棒了。你描述文化的方式，让我想起了 Seth Godin（他也上过这个播客）的说法。他说：“文化就是……”正如你所说，“文化就是我们在这里做事的方式”。人们就是这样描述文化的。
**莫莉·格雷厄姆：** 我在 Facebook 负责过一小段时间的文化工作（管它到底是什么意思）。从那以后，我真的再也没做过“价值观练习”了。这听起来很疯狂，对吧？因为理论上我知道怎么做。但我其实并不真正相信那一套。对我来说，重点是流程、系统以及我们如何做决策。那才是文化真正存在的地方。它是你的所作所为：你如何招聘，如何解雇，你不雇佣谁。所有这些决策，就是文化。所以每当我与公司合作或建立公司时，我关注的是这些，而不是贴在墙上的那些漂亮词汇。你懂我意思吗？

---

### [01:15:54] Lenny Rachitsky

**English:**
Yeah. So the way you're describing is, as you said, it's what you do. It's not what you say?
**Molly Graham:** Yeah.
**Lenny Rachitsky:** Awesome. Keep going.
**Molly Graham:** I'll give you two more that are helpful. This one is a Mark Zuckerberg classic, but he has this very strong feeling that people don't escalate enough. And he was very adamant about it at Facebook. And he brought it to CZI too where he was like, "Escalation is a tool." And he's like, "People get stuck. They get stuck with two people with equal power trying to solve a problem. You can spend so much time bashing heads, going back and forth. And actually what you just need to do is go up. You need to go."

**中文翻译:**
**兰尼·拉奇茨基：** 所以你描述的方式是：文化是你的所作所为，而不是你的所言？
**莫莉·格雷厄姆：** 没错。
**兰尼·拉奇茨基：** 太棒了，继续。
**莫莉·格雷厄姆：** 我再给你两个有用的。这一个是马克·扎克伯格的经典观点：他强烈地感觉到人们“越级上报”（Escalate）得不够多。他在 Facebook 时对此非常坚持，后来在 CZI 也是如此。他说：“上报是一种工具。”他说：“人们会陷入僵局。两个权力相等的人试图解决一个问题，结果陷入僵局。你们会花大量时间争论不休。其实你只需要向上反映，你需要去找上级。”

---

### [01:16:59] Molly Graham

**English:**
The problem is that we think of escalation as, "I'm A and B and I are disagreeing. And so, I'm going to go up to C and tell on B. I'm going to go tattle to the teacher." That is not what escalation is. What escalation is, "We disagree. Neither one of us has enough power to make this decision. Let's go to someone who does." My boss, my boss's boss, whoever it is. As soon as you are stuck, escalate. Go together, go make your case to whoever it is, go together up. That is unlocking. It's saving you a whole bunch of time. And it's something that I've found as I've worked with companies and leaders in Glue Club. It's not a muscle that's very comfortable for people, but it's so smart. And Mark has a lot of these, but that one I really took away because again, I think so many people think of escalation as bad, a failure, like, "I failed, so I had to escalate." No, it's a tool. It's what management is for. They're there to unblock you. Let them unblock you. Stop arguing over something you can't decide.

**中文翻译:**
问题在于，我们把“上报”想成了：“我是 A，我和 B 有分歧，所以我要去找 C 告 B 的状，就像向老师打小报告一样。”那不是上报。真正的上报是：“我们有分歧，我们两个都没有足够的权力来做这个决定。让我们去找那个有权力的人吧。”找我的老板，或者老板的老板，不管是准。一旦你卡住了，就上报。一起去，向相关人员陈述你们的理由，一起向上反映。这能打破僵局，为你节省大量时间。这是我在 Glue Club 与公司和领导者合作时发现的一点。这对人们来说不是一种很舒服的“肌肉记忆”，但它非常聪明。马克有很多这类观点，但我对这一条印象最深。因为很多人觉得上报是件坏事，是一种失败，觉得“我失败了，所以我不得不上报”。不，它是一个工具。这就是管理层的用途：他们是来为你扫清障碍的。让他们为你扫清障碍，别再为你们无法决定的事情争论不休了。

---

### [01:17:36] Lenny Rachitsky

**English:**
And they'll be so happy knowing you did not waste a week debating this and then just arguing and just looking at data. It's like, "Okay, I can just tell you exactly what we should do. Let's go do that."
**Molly Graham:** Exactly. You lack context or you lack power. And then the last one actually is from Cheryl Sandberg, who I learned an enormous amount from, huge, was like going to business school without going to business school working with her. But I say it a lot right now, so I'm going to say it on your podcast so maybe some people will hear me. Growing more than 100% every year is a bad idea. The happiest growth rate is 50%, 100% is manageable. Anything more than doubling and you are signing yourself up for a world of pain.

**中文翻译:**
**兰尼·拉奇茨基：** 而且他们会很高兴知道你没有浪费一周时间去争论、吵架或死盯着数据。他们会觉得：“好吧，我可以明确告诉你们该怎么做，去干吧。”
**莫莉·格雷厄姆：** 没错。你要么缺乏背景信息，要么缺乏决策权。最后一个教训其实来自谢丽尔·桑德伯格。我从她身上学到了极多东西，和她共事就像没上商学院却读了个 MBA。我现在经常说这句话，所以我也要在你的播客上说，希望能让更多人听到：每年增长超过 100% 是个坏主意。最理想的增长率是 50%，100% 是可以应付的。任何超过翻倍的增长，都是在给自己找麻烦。

---

### [01:18:47] Molly Graham

**English:**
And I have seen this over and over and over again. I had to scream way louder about it five years ago than I do now because we've been through collectively a lot of pain and a lot of layoffs. And obviously the combination of 2021 and then AI has led us to talk about unit economics and scaling with tools, not people. But I still see companies and I'm still talking to founders that are like, "Yeah, we're 50 people and we're going to be 150 people next year." And I'm like, "Could you possibly do that with 100 people?" But here's what basically happens if you grow at more than 100%, which is you're growing too fast to de-dupe all the issues.

**中文翻译:**
我一遍又一遍地看到这种情况。五年前我得比现在更大声地疾呼这一点，因为我们集体经历了许多痛苦和裁员。显然，2021 年的狂热加上现在的 AI，让我们开始讨论单位经济效益，以及用工具而非人力来扩张。但我仍然看到一些公司，仍然在和一些创始人交流，他们说：“是的，我们现在有 50 人，明年我们要增加到 150 人。”我会问：“你能不能用 100 人做到同样的事？”因为如果你增长超过 100%，基本会发生这种情况：你增长得太快，以至于无法处理所有重复和冗余的问题。

---

### [01:19:32] Molly Graham

**English:**
So somebody posts this role, it actually turns out that that role is also being hired for on this other team. So you're hiring two people who more or less have the same job description and are assigned to the same number or the same problem, but nobody talked to each other. And those two people both show up and they're like, "I am doing this." And the person's like, "Wait, I thought I was doing that." Anyway, so then you've got all this... And think about all the time and all the energy and all the money that goes into de-duping that. If you slow down, if you hire for quality and for real need versus the panic hiring, whatever your sales model spits out or whatever, you'll actually find leverage. You find, "Oh, I didn't need that person," or, "I didn't need this whole team," or, "I didn't need this whole function," or, "I can wait for that." So slow down.

**中文翻译:**
比如有人发布了一个职位，结果发现另一个团队也在招同样的职位。于是你雇了两个职位描述差不多的人，负责同一个指标或同一个问题，但彼此从未沟通过。当这两个人都入职后，他们会说：“我在做这个。”另一个会说：“等等，我以为是我在做那个。”总之，你会遇到所有这些问题……想想为了消除这些重复而投入的时间、精力和金钱吧。如果你慢下来，为了质量和真实需求而招聘，而不是根据销售模型算出的数字进行“恐慌性招聘”，你实际上会找到杠杆。你会发现：“噢，我不需要那个人”，或者“我不需要整个团队”，或者“我不需要这个职能部门”，或者“这件事可以等等”。所以，慢下来。

---

### [01:20:16] Molly Graham

**English:**
And again, these are all just guidelines in terms of the 50% is happy and 100% is manageable. But having seen enough of this, I can tell you these are good rules and you should pay attention to them. And sometimes you're like, "I have to double or I have to more than double or I have to triple," or whatever. I'm like, "Okay, just ask a whole lot of questions as you open roles. Ask a whole lot of questions as you hire because you will find duplication, you will find chaos coming in the front door." More people does not actually make you faster. Do you know what I mean? We think it does. It does not. It makes it harder. It makes it harder to get work done. It makes it slower. So you should be scared of adding people, not like, "Oh, this is the answer to all my problems."

**中文翻译:**
再次强调，这些只是指导方针：50% 是快乐的，100% 是可控的。但见多了这些，我可以告诉你，这些是很好的规则，你应该关注它们。有时你会说：“我必须翻倍，或者翻两倍、三倍。”我会说：“好吧，那你在开放职位时多问问为什么。在招聘时多问问，因为你会发现重复，你会发现混乱正从前门溜进来。”人多并不会让你跑得更快。你懂我意思吗？我们以为会，但其实不会。它会让事情变得更难，让工作更难开展，让速度变慢。所以你应该对增加人手感到“恐惧”，而不是觉得“噢，这是解决我所有问题的答案”。

---

### [01:20:27] Lenny Rachitsky

**English:**
Amazing. And just to be clear, you're talking about the growth of the company. So doubling in a year, bad idea. It's possible, but you're saying it's going to be very hard and painful and probably a really bad idea.
**Molly Graham:** More than doubling head count growth.
**Lenny Rachitsky:** More than doubling.
**Molly Graham:** Yes, exactly.
**Lenny Rachitsky:** Awesome. It's-
**Molly Graham:** Please feel free to do whatever you want with your business.

**中文翻译:**
**兰尼·拉奇茨基：** 太棒了。明确一下，你指的是公司的增长。所以一年内翻倍是个坏主意。虽然可行，但你认为这会非常困难、痛苦，而且可能真的是个坏主意。
**莫莉·格雷厄姆：** 是指员工人数（Headcount）增长超过一倍。
**兰尼·拉奇茨基：** 超过一倍。
**莫莉·格雷厄姆：** 是的，没错。
**兰尼·拉奇茨基：** 明白了。
**莫莉·格雷厄姆：** 当然，你的业务你想怎么搞都行。

---

### [01:20:47] Lenny Rachitsky

**English:**
Just advice. This is top of mind because I just had the interview with Matt McGinnis, but so much of what he talked about is this resonates with what you're talking about. He talked a lot about under-resourcing your team leads to much better outcomes because people don't work on the low priority stuff. They focus on only high priority stuff. And the other is this idea of escalating. He talked a lot about that. Just like, "Escalation is good. Tell me when there's something I can help with, please. I'm here waiting constantly to help."
**Molly Graham:** There you go.

**中文翻译:**
**兰尼·拉奇茨基：** 只是建议。我想到这个是因为我刚采访了 Matt McGinnis，他说的很多内容都与你所说的产生了共鸣。他谈到了“资源不足”反而能带来更好的结果，因为人们不会去做低优先级的事，他们只专注于高优先级的事。另一个就是“上报”的想法，他也聊了很多。就像：“上报是好事。请告诉我有什么我可以帮忙的，我一直在这里等着帮忙。”
**莫莉·格雷厄姆：** 没错。

---

### [01:21:16] Lenny Rachitsky

**English:**
Amazing. So maybe for a final question, one of your former colleagues, Eric Antonow, who's just this epic dude that few people know about that I've chatted with over the last few months because he knows so many people that come on this podcast. He's a former Facebook person, now at OpenAI. I asked him what I should ask you about and he told me something really insightful about you. He said that you had this really massive growth spurt at Facebook, which you shared and talked about. And then after you leaving, you had this huge ambition to become COO, CEO, become this huge big deal boss person, just take over the world. And then he noticed your ambitions significantly pivot to working on community building and helping people with their careers. And you turned down really big C-level role opportunities. And the way he described it is you were a dog that once thought you were cat. And the other metaphor he used is you change from AC current to DC current, which I don't know exactly what that means. So does this resonate? And if so, just what happened there?

**中文翻译:**
太棒了。最后一个问题，你的一位前同事 Eric Antonow（一个非常厉害但很少人知道的大神，我过去几个月常和他聊天，因为他认识很多上我播客的人。他以前在 Facebook，现在在 OpenAI）。我问他我该问你什么，他告诉了我一些关于你的非常有见地的事情。他说你在 Facebook 经历了一段巨大的成长期，你也分享过了。离开后，你曾有巨大的野心想成为 COO、CEO，成为那种叱咤风云的大老板，接管世界。但后来他注意到你的野心发生了重大转向，转而致力于社区建设和帮助人们规划职业生涯。你拒绝了一些非常诱人的 C-level（首席级）职位的机会。他形容你就像“一只曾以为自己是猫的狗”。他用的另一个比喻是你从交流电（AC）变成了直流电（DC），我不太明白那是什么意思。这能引起你的共鸣吗？如果能，当时发生了什么？

---

### [01:22:22] Molly Graham

**English:**
Eric is actually better at metaphors than I am, and I regularly rip his metaphors. But yes, Eric Antonow, the least well-known, but most brilliant person in my life. So I gave a talk at a company recently and somebody asked the question, "What's something you've changed your mind about?" And I was like, "Woof." But I actually talked about this because... So my brain is developing this model that is not done yet, but it's basically this idea that everybody has a proving phase to their career where you're proving to yourself and probably to your parents and some other people that you're good at stuff. You're like, "I'm going to prove." And it's an important phase because you need to learn. All the stuff we talked about. You need to learn what you're good at. You need to learn that you are good at things and that people should hire you for things and what are those things?

**中文翻译:**
Eric 其实比我更擅长用隐喻，我经常“剽窃”他的隐喻。是的，Eric Antonow 是我生命中知名度最低但最聪明的人。我最近在一家公司演讲，有人问：“你对什么事情改变了看法？”我当时想：“哇哦。”但我确实谈到了这一点。我的大脑正在开发一个尚未完成的模型，核心观点是：每个人的职业生涯都有一个“证明阶段”（Proving phase），在这个阶段，你要向自己、向父母、向其他人证明你很擅长某些事。你会想：“我要证明自己。”这是一个重要的阶段，因为你需要学习——就像我们聊过的所有内容。你需要了解你擅长什么，需要证明你确实优秀，证明人们应该雇你去做某些事，以及那些事具体是什么。

---

### [01:23:22] Molly Graham

**English:**
But part of that phase is also doing what you think matters, what you think you should do. Family programming or career books tell you this is what you should do, titles and all that stuff. And then, I think everybody has a moment and I think this moment varies wildly in terms of when it hits people, where you hit some sort of wall or I don't know what it is, speed bump, something, and the world forces you to say, "Okay, I've proven myself and I'm good at this thing. What do I want to do with it?" And for me, I spent 10 or 15 years proving to myself and to others that I was really good at this thing, basically working with brilliant founders to help bring their vision to life, "That's what you should hire me to do." That's what I was known for.

**中文翻译:**
但这个阶段的一部分也是在做那些你“认为”重要、你“认为”应该做的事。家庭的期望或职业书籍会告诉你应该追求什么，比如头衔之类的。然后，我认为每个人都会遇到一个时刻——每个人遇到的时间点大不相同——你会撞上一堵墙，或者一个减速带，或者别的什么，世界强迫你说：“好吧，我已经证明了自己，我擅长这件事。但我到底想用它来做什么？”对我来说，我花了 10 到 15 年向自己和他人证明我非常擅长一件事：与天才创始人合作，帮助他们实现愿景。“这就是你们应该雇我做的事。”这就是我的名声所在。

---

### [01:24:20] Molly Graham

**English:**
And it turned out that that wasn't what I love doing anymore. And it was really, really hard to walk away from because there was a lot of shoulds. It was like, "You should take this job with this fancy title. People are going to think you're so cool." And you get to... I call it a LinkedIn crush where you're really excited to post the job on LinkedIn, but you're deeply unexcited about doing the job. So you have all these LinkedIn crushes and you're like... And I vividly remember this one job that I turned down where I had to go for many walks. And what I was repeating over and over again to myself was, "What does this get you that you don't already have? What does this get you that you don't already have?"

**中文翻译:**
结果证明，那不再是我热爱的事情了。要离开那条路真的非常、非常难，因为有很多“应该”。比如：“你应该接受这个头衔很酷的工作，大家会觉得你很牛。”你会陷入一种我称之为“LinkedIn 迷恋”（LinkedIn crush）的状态——你非常兴奋地想把新工作发到 LinkedIn 上，但你对实际去做那份工作却毫无兴致。你会有很多这种“LinkedIn 迷恋”。我清晰地记得我拒绝的一份工作，当时我不得不出去散了很多次步。我一遍又一遍地对自己重复：“这能给你带来什么你现在还没有的东西吗？这能给你带来什么你现在还没有的东西吗？”

---

### [01:25:20] Molly Graham

**English:**
And I think, for me, it was this realization that these things that fed me early in my career just didn't feed me anymore, that I didn't get joy and excitement out of doing these jobs anymore, and I wasn't scared. So it led me actually on a very long, windy journey, a founder journey, even though I have trouble with that title, just like the influencer title, to figure out what I wanted to build. And what I would've told you I wanted to build three years ago is actually not what I'm doing today, but through a lot of really fun experiments and a journey that never ends, what I've discovered is that what I love doing is building safe spaces for leaders to learn and grow, but also to find sanity and connection in a world that's kind of insane, whether it's working in a startup or some other kind of insanity, but that feeds me and there's nothing I love more than that, and I could not have told you that three years ago, but, to Eric's point, it really took a lot of work to switch currents or switch myself from a dog to a cat or whatever his metaphor is. And I think it's the work of it's ongoing work, but it's that thing of what do I want versus what do I think people expect of me?

**中文翻译:**
我想，对我来说，那是意识到职业生涯早期滋养我的那些东西，现在已经无法再滋养我了。我不再从这些工作中获得快乐和兴奋，我也不再感到害怕。所以这引导我开启了一段漫长而曲折的旅程，一段“创始人”的旅程（尽管我也很难接受这个头衔，就像“网红”那个头衔一样），去弄清楚我到底想创造什么。三年前我告诉你想创造的东西，其实并不是我今天正在做的。但通过许多有趣的实验和一段永无止境的旅程，我发现我热爱的是为领导者建立一个学习和成长的安全空间，让他们在这个疯狂的世界里（无论是初创公司的疯狂还是其他的疯狂）找到理智和连接。这能滋养我，没有什么比这更让我热爱的了。三年前我无法告诉你这些。但正如 Eric 所说，要把自己从“狗”变成“猫”，或者切换“电流”，确实需要做很多功课。我认为这是一项持续的工作，核心在于：我想要什么，而不是我认为别人期望我做什么？

---

### [01:26:32] Lenny Rachitsky

**English:**
There's so much depth there. This could be another entire podcast conversation talking through this journey, but I'm going to close with a note from your partner, Sarah. She told me that she has this sticker on her notebook with three pieces of advice that you gave her when she started at OpenAI. Get to know your customer, they have the answer; be patient because everything is going to change; and just keep trying. So just as a final question, is there anything along those lines that you think might be helpful for people to hear or is there anything else you want to share or leave listeners with?

**中文翻译:**
这里面有很深的内涵。这段旅程完全可以再做一集播客。但我打算用你的合伙人莎拉的一段话来结束。她告诉我，她的笔记本上贴着一张贴纸，上面写着你她在加入 OpenAI 时给她的三条建议：了解你的客户，他们有答案；保持耐心，因为一切都会改变；以及，不断尝试。作为最后一个问题，关于这些建议，你觉得还有什么对听众有帮助的吗？或者你还有什么想分享或留给听众的？

---

### [01:27:07] Molly Graham

**English:**
Part of what I think is so important to realize inside of scaling and changing companies and the world is some things will always be true. And part of what I was saying to Sarah in the "get to know the customer, they have the answer" is, whatever bullshit is going on around you and whatever walls and ceiling are being rearranged this week, the customer is never going to change. That's a thing that will never change. And I think finding those immovable objects, those compasses in the face of a storm, which being inside of a scaling company in a startup feels like a tornado.

**中文翻译:**
我认为在扩张、变革的公司以及这个世界中，意识到“有些事情永远是正确的”非常重要。我告诉莎拉“了解客户，他们有答案”，部分原因是：无论你周围发生了什么破事，无论这周公司的墙壁和天花板如何重新排列，客户是永远不会变的。那是永远不会改变的事情。我认为在风暴中找到那些“不动产”、那些指南针至关重要，因为身处扩张期的初创公司感觉就像身处龙卷风之中。

---

### [01:28:09] Molly Graham

**English:**
And I think it's sort of the same thing as "Serve the business, not the people." What are the things that will always be true? We are here to do this. We are here to serve the customer. And then the other piece of the three things that she wrote down is, I think that we, as humans, we seek stability. Our brains would like things to stop changing. We would like things to stay the same. And that is just not a reality inside of companies that are growing and changing as fast as OpenAI or a lot of the companies today that are being built. So actually, you need to start to expect instability. You need to start to just assume things are going to change. Assume you're going to have a new boss in six months. I talk about this a lot when I talk to folks at OpenAI, "You need to stop expecting that anything's going to be the same in six months or a year. You will have a different job. You will have a different boss."

**中文翻译:**
我觉得这和“服务于业务，而非个人”是一个道理。哪些事情是永远正确的？我们在这里是为了做这件事。我们在这里是为了服务客户。她记下的另外两点是：我认为作为人类，我们追求稳定。我们的大脑希望事情停止改变，希望一切保持原样。但在像 OpenAI 这样快速成长和变化的公司，或者当今许多正在建立的公司中，这根本不是现实。所以实际上，你需要开始“期待不稳定”。你需要开始假设事情会发生变化。假设六个月后你会有一个新老板。我经常和 OpenAI 的人聊这个：“你需要停止期待六个月或一年后一切还会保持原样。你会有不同的工作，会有不同的老板。”

---

### [01:28:55] Molly Graham

**English:**
How do you prepare for that? Do you know what I mean? How do you almost see the instability as stability because it's the only thing that is definitely going to be true. And part of that is to just keep going. You know what I mean? To just find these lights and these compasses or whatever metaphor sticks with you and focus on those because whatever is happening around you, you just got to keep moving forward and keep learning as much as you can because that's the real opportunity. Whatever happens to the company, however successful it is, all that you take away from it... I always say all that you take away from it is people that like working with you and want to work with you again and what you learned. That's it. You might hopefully take a bunch of money, but you might not. So people and what you learned, that's it. Focus on that.

**中文翻译:**
你如何为此做准备？你懂我意思吗？你如何几乎把“不稳定”看作是“稳定”，因为它是唯一肯定会发生的事。其中一部分就是“继续前进”。找到这些光亮、这些指南针，或者任何让你印象深刻的比喻，并专注于它们。因为无论周围发生什么，你只需继续前进，尽可能多地学习，因为那才是真正的机会。无论公司发生什么，无论它多么成功，你从中带走的……我总说，你带走的只有那些喜欢与你共事并想再次与你共事的人，以及你学到的东西。仅此而已。你可能会带走一大笔钱，也可能不会。所以，人脉和所学，就是全部。专注于此。

---

### [01:29:41] Lenny Rachitsky

**English:**
It's all about the friends you made along the way. That old line is true. Oh, man. Molly, I feel like we've gone for so long and we've just scratched the surface. I'd love to have you back to go deeper on a lot of this stuff. I'm going to skip the lightning round because we've gone long and I want to keep people from having to listen to more. So I'm just going to end with, what should people know about what you're working on? Where can people go find you online? And how can listeners be useful to you?

**中文翻译:**
**兰尼·拉奇茨基：** 归根结底是这一路上结交的朋友。那句老话是真的。噢，天哪。莫莉，我觉得我们聊了这么久，也只是触及了皮毛。我很想再请你回来，深入探讨其中的很多内容。我要跳过闪电问答环节了，因为我们聊得太久了，我不想让听众听太累。所以最后，大家应该了解一下你正在做的事情吗？人们可以在哪里找到你？听众可以为你提供什么帮助？

---

### [01:30:07] Molly Graham

**English:**
You can find me on LinkedIn and you can find me on Substack. I have a Substack called Lessons that I'm slowly trying to turn into a community where we can talk about things, the real stuff. And you can find me at Glue Club, which, if you're a leader inside of one of these crazy companies that's changing all the time, we can be a great home for you.
**Lenny Rachitsky:** What's the URL there just for folks to check out?
**Molly Graham:** It's glueclub.com.
**Lenny Rachitsky:** Glue, G-L-U-E?
**Molly Graham:** G-L-U-E.
**Lenny Rachitsky:** C-L-U-B.com. Great.
**Molly Graham:** Yeah, exactly.

**中文翻译:**
**莫莉·格雷厄姆：** 你可以在 LinkedIn 上找到我，也可以在 Substack 上找到我。我有一个名为“Lessons”的 Substack，我正慢慢尝试把它变成一个社区，让我们讨论那些真实的事情。你也可以在 Glue Club 找到我，如果你是那些疯狂、多变的公司里的领导者，我们可以成为你的港湾。
**兰尼·拉奇茨基：** 网址是什么，方便大家查看？
**莫莉·格雷厄姆：** 是 glueclub.com。
**兰尼·拉奇茨基：** Glue，G-L-U-E？
**莫莉·格雷厄姆：** G-L-U-E。
**兰尼·拉奇茨基：** C-L-U-B.com。太好了。
**莫莉·格雷厄姆：** 没错。

---

### [01:30:34] Molly Graham

**English:**
And in terms of people, what people can do to be useful to me, I love helping leaders with problems. I really get a lot of energy out of unsticking people and helping people feel supported and seen and helping them grow. I do that through Glue Club. So if you're a leader that feels like you want some sanity and some support in the face of whatever tornado you're in, that's a great place to come. But the same is true of Substack. So if Glue Club isn't for you, come on over to Substack. I've opened up a bunch of channels to just talk about stuff, listen to people's problems, answer questions because I love helping people. And I think it's a complicated moment right now to be a leader and to figure out which way is up. So come on over.

**中文翻译:**
至于大家能为我做什么，我喜欢帮助领导者解决问题。帮助人们摆脱困境、让他们感到被支持和被看见、帮助他们成长，这能给我带来巨大的能量。我通过 Glue Club 来做这些。所以如果你是一名领导者，在面对龙卷风般的处境时想要保持理智并获得支持，那里是一个好去处。Substack 也是如此。如果 Glue Club 不适合你，那就来 Substack。我开辟了很多频道来讨论事情、倾听大家的问题、回答疑问，因为我热爱助人。我认为现在做一个领导者并理清方向是一个非常复杂的时刻。所以，欢迎过来。

---

### [01:31:24] Lenny Rachitsky

**English:**
Amazing. Molly, thank you so much for being here.
**Molly Graham:** Thank you, Lenny. This was really fun.
**Lenny Rachitsky:** Bye everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
**兰尼·拉奇茨基：** 太棒了。莫莉，非常感谢你能来。
**莫莉·格雷厄姆：** 谢谢，兰尼。这真的很有趣。
**兰尼·拉奇茨基：** 各位再见。非常感谢收听。如果你觉得内容有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用上订阅本节目。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众找到这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。