# Nabeel S. Qureshi - 双语对照

This is the complete bilingual (English-Chinese) transcript for Lenny’s Podcast featuring Nabeel S. Qureshi.

---

### (00:00:00) Lenny Rachitsky

**English:**
30% of PMs that leave Palantir start a company. Just give us a picture of what the people are like.

**中文翻译:**
从 Palantir 离职的产品经理（PM）中有 30% 都去创业了。请给我们描述一下，那里的人都是什么样的？

---

### (00:00:05) Nabeel S. Qureshi

**English:**
I feel like they screened really hard for a few traits in particular. One is like very independent-minded people who weren't afraid to push back. Two is people with broader intellectual interests.

**中文翻译:**
我觉得他们非常严格地筛选了几种特定的特质。第一是思想非常独立、不害怕反驳的人。第二是拥有广泛知识兴趣的人。

---

### (00:00:15) Lenny Rachitsky

**English:**
What's the difference between, say, a PM at Palantir versus a traditional PM?

**中文翻译:**
那么，Palantir 的 PM 与传统意义上的 PM 之间有什么区别呢？

---

### (00:00:18) Nabeel S. Qureshi

**English:**
They were extremely careful about only making people PMs who had first proven themselves out as forward deployed engineers. You basically could not become a PM any other way. There's two types of engineer at Palantir. So, there's one that works on the core product and they're a traditional software engineer. There was a different type of engineer which you sent into the field. You would spend maybe Monday to Thursday and you would actually go into the building where the customer worked and you would work alongside them. You would literally get a desk there and so, that engineer became known as a forward deployed engineer.

**中文翻译:**
他们非常谨慎，只有那些先作为“前线部署工程师”（Forward Deployed Engineer，简称 FDE）证明了自己的人，才能成为 PM。基本上没有其他途径可以成为 PM。在 Palantir 有两种类型的工程师：一种负责核心产品，是传统的软件工程师；另一种是被派往现场的工程师。你可能周一到周四都在客户办公的大楼里，和他们并肩工作。你甚至在那里有一个专属办公桌，这种工程师就被称为“前线部署工程师”。

---

### (00:00:51) Lenny Rachitsky

**English:**
What's something that you believe that most other people don't?

**中文翻译:**
有什么是你相信，但大多数人都不认同的事情吗？

---

### (00:00:54) Nabeel S. Qureshi

**English:**
I think this is a somewhat contrarian view within tech.

**中文翻译:**
我认为这在科技界是一个有点“非主流”的观点。

---

### (00:00:58) Lenny Rachitsky

**English:**
Today, my guest is Nabeel Qureshi. Nabeel is a founder, a writer, a researcher, and an engineer. He was recently a visiting scholar researching AI policy at the Mercatus Center alongside Tyler Cowen. At one point, he worked with the National Institute of Health and major clinical centers to create the largest medical data set in the world. He worked at the Bank of England for a bit. He was founding member and VP of Business Development at GoCardless, one of Europe's biggest financial technology unicorns.

**中文翻译:**
今天的嘉宾是 Nabeel Qureshi。Nabeel 是一位创始人、作家、研究员和工程师。他最近在 Mercatus 中心与 Tyler Cowen 一起担任访问学者，研究 AI 政策。他曾与美国国家卫生研究院（NIH）及各大临床中心合作，创建了全球最大的医疗数据集。他还在英格兰银行工作过一段时间。他是欧洲最大的金融科技独角兽之一 GoCardless 的创始成员兼业务发展副总裁。

---

### (00:01:23) Lenny Rachitsky

**English:**
And most related to the topic of this conversation, Nabeel spent almost eight years at Palantir as a forward deployed engineer working on public health projects with US federal agencies, including public health services during the COVID-19 response and applied AI in drug discovery. Whether you are a fan of Palantir or hate everything that they do, they are an important and fast-growing company that is pumping out incredible product leaders, as you'll hear more than any other company in the world. So, it is worth studying and understanding.

**中文翻译:**
与本次对话主题最相关的是，Nabeel 在 Palantir 工作了近八年，担任前线部署工程师，负责与美国联邦机构合作的公共卫生项目，包括新冠疫情期间的公共卫生服务以及药物研发中的 AI 应用。无论你是 Palantir 的粉丝，还是讨厌他们所做的一切，他们都是一家重要且快速发展的公司。正如你将听到的，他们培养出的优秀产品领袖比世界上任何其他公司都多。因此，这家公司非常值得研究和了解。

---

### (00:01:52) Lenny Rachitsky

**English:**
I've never heard an in-depth conversation digging into how they operate, build product, hire, and were able to scale from a primarily services business to a software business. So, I am very excited to bring you this inside look. In our conversation, we go deep into what the heck does Palantir even do, why getting good at managing lots of data is an underappreciated secret to their success, a look at the unique forward deployed engineer role that they innovated, and what other companies can borrow from their insights here. Also, how they hire and how they build amazing product leaders, plus a ton of advice on talking to customers, building products, and starting companies.

**中文翻译:**
我从未听过关于他们如何运作、构建产品、招聘，以及如何从以服务为主的业务转型为软件业务的深度对话。所以，我非常激动能带大家深入了解。在我们的对话中，我们将深入探讨 Palantir 到底是做什么的；为什么擅长管理海量数据是他们成功的秘诀（虽然这一点常被低估）；研究他们创新的独特“前线部署工程师”角色，以及其他公司可以借鉴的经验。此外，还有他们如何招聘、如何培养出色的产品领袖，以及大量关于与客户沟通、构建产品和创业的建议。

---

### (00:02:26) Lenny Rachitsky

**English:**
If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. Also, if you become an annual subscriber of my newsletter, you get a bunch of amazing products for free for a year, including Superhuman, Notion, Linear, Perplexity, Granola and more. Check it out at lennysnewsletter.com and click Bundle. With that, I bring you Nabeel Qureshi.

**中文翻译:**
如果你喜欢这个播客，别忘了在你的播客应用或 YouTube 上订阅和关注。此外，如果你成为我时事通讯（Newsletter）的年度订阅者，你将免费获得一年的多款优秀产品，包括 Superhuman、Notion、Linear、Perplexity、Granola 等。请访问 lennysnewsletter.com 并点击 Bundle 查看。下面，让我们欢迎 Nabeel Qureshi。

---

### (00:02:47) Lenny Rachitsky (Sponsor Break - WorkOS)

**English:**
This episode is brought to you by WorkOS. If you're building a SaaS app, at some point, your customers will start asking for enterprise features like SAML authentication and SCIM provisioning. That's where WorkOS comes in... [Ad content omitted for brevity in translation, focusing on transcript content]

**中文翻译:**
本集节目由 WorkOS 赞助。如果你正在构建 SaaS 应用，你的客户迟早会要求 SAML 身份验证和 SCIM 配置等企业级功能。这就是 WorkOS 的用武之地……（赞助商广告内容略）

---

### (00:04:05) Lenny Rachitsky (Sponsor Break - Attio)

**English:**
This episode is brought to you by Attio, the AI native CRM. Attio is built to scale with your business from day one... [Ad content omitted for brevity]

**中文翻译:**
本集节目由 AI 原生 CRM 系统 Attio 赞助。Attio 旨在从第一天起就随你的业务规模共同成长……（赞助商广告内容略）

---

### (00:05:08) Lenny Rachitsky

**English:**
Nabeel, thank you so much for being here. Welcome to the podcast.

**中文翻译:**
Nabeel，非常感谢你能来。欢迎来到我们的播客。

---

### (00:05:12) Nabeel S. Qureshi

**English:**
Thanks, Lenny. Glad to be here.

**中文翻译:**
谢谢，Lenny。很高兴来到这里。

---

### (00:05:14) Lenny Rachitsky

**English:**
In our chat today, I want to zero in on a post that you recently wrote where you shared your reflections on your time at Palantir. You spent something, maybe just under eight years there. The reason I'm really interested in Palantir is I've been doing a bunch of research recently looking into which companies hire the best product managers and create the best product managers, and Palantir just keeps coming up over and over in the work that I'm doing.

**中文翻译:**
在今天的聊天中，我想重点讨论你最近写的一篇文章，你在文中分享了对 Palantir 时光的反思。你在那里待了将近八年。我之所以对 Palantir 感兴趣，是因为我最近在研究哪些公司招聘和培养了最优秀的产品经理，而在我的研究中，Palantir 的名字反复出现。

---

### (00:05:37) Lenny Rachitsky

**English:**
So, I'll share a few stats real quick. I looked at which companies produce the most founders, especially out of their PM team, and Palantir is, by far, number one. 30% of PMs that leave Palantir start a company. And number two is 18% and that's Intercom. So, that stat, I looked at which companies PMs that leave get immediately promoted in their next role, Palantir is number one of all companies in the world.

**中文翻译:**
我快速分享几个数据。我调查了哪些公司培养了最多的创始人，特别是从 PM 团队中出来的，Palantir 遥遥领先，排名第一。从 Palantir 离职的 PM 中有 30% 选择了创业。排名第二的是 Intercom，比例为 18%。此外，我还调查了哪些公司的 PM 在离职后的下一份工作中能立即获得晋升，Palantir 在全球所有公司中排名第一。

---

### (00:06:02) Lenny Rachitsky

**English:**
I looked at which companies' PMs become the first PM at another startup that they join, Palantir is number two in the world. And then I looked at which companies alumni PMs become heads of Product down later in their career, Palantir is number three in the world. Also, just the company is doing extremely well. It's worth, I think, something like $200 billion these days. So, there's a lot to learn from Palantir. I actually want to start a question that I imagine every employee at Palantir constantly gets that, and I still don't think people totally have an answer in their head. What does Palantir do?

**中文翻译:**
我还调查了哪些公司的 PM 离职后会成为另一家初创公司的首位 PM，Palantir 全球排名第二。而在哪些公司的 PM 校友在职业生涯后期成为产品负责人的调查中，Palantir 排名第三。此外，这家公司本身表现也极其出色，目前的市值大约在 2000 亿美元左右。所以，Palantir 有很多值得学习的地方。我想从一个问题开始，我猜每个 Palantir 的员工都会被问到这个问题，而且我觉得大家脑子里可能还没有一个完全清晰的答案：Palantir 到底是做什么的？

---

### (00:06:38) Nabeel S. Qureshi

**English:**
That's a great question. You started off with an easy one, Lenny. So, Palantir is, the way I describe it, is they achieve outcomes for their customers very tactically. The way they do that tends to be through a data platform. So, they have what I consider to be the world's best data platform, and I can go into what that means in a second. And then there's a couple of different versions of this. So, there's one that's optimized for intelligence and defense use cases that one is called Gotham. And then there's one that's more optimized for commercial use cases and that one's called Foundry.

**中文翻译:**
这是个好问题。你一上来就问了个“简单”的，Lenny。我对 Palantir 的描述是：他们以非常务实的方式为客户达成目标。他们通常通过一个数据平台来实现这一点。他们拥有我认为是世界上最好的数据平台，稍后我可以详细解释这意味着什么。这个平台有几个不同的版本：一个针对情报和国防用例进行了优化，叫做 Gotham；另一个更针对商业用例，叫做 Foundry。

---

### (00:07:12) Nabeel S. Qureshi

**English:**
And that's the classic explanation of what they do. So, they sell a data platform. They typically work with very large customers is the other thing. So, it's going to be Fortune 50. It's going to be governments around the world. It's going to be those kinds of customers. So, that's the capsule answer, but there's lots to unpack in there.

**中文翻译:**
这就是对他们业务的经典解释：他们销售数据平台。另一件事是，他们通常与非常大的客户合作，比如财富 50 强企业、世界各地的政府。这就是简短的回答，但其中有很多值得深入探讨的内容。

---

### (00:07:32) Lenny Rachitsky

**English:**
Awesome. Okay, and we're going to touch on a lot of this stuff, including the data piece. I want to start with talking about just the people and the culture of Palantir. You shared a bunch of really funny stories of what it's like to come to work and even interview at Palantir. There's a story you shared where because maybe the co-founder, you're walking by and he's chewing ice, and that's some benefits to cognition. Just give us a picture of what the people are like, especially early days Palantir and the culture and how unique it might seem.

**中文翻译:**
太棒了。我们会谈到很多内容，包括数据部分。我想先从 Palantir 的人和文化谈起。你分享过很多关于在 Palantir 工作甚至面试的趣事。你讲过一个故事，当你走过联合创始人身边时，他正在嚼冰块，据说这有助于认知。请给我们描述一下那里的人是什么样的，尤其是早期的 Palantir，以及那种文化看起来有多独特。

---

### (00:07:58) Nabeel S. Qureshi

**English:**
Yeah, it's definitely, it's an add-a-one company. I don't know how else you would start this company if you were not somebody like Peter Thiel. And so far as, it seems like there was a point at which they owned a silly fraction of the office space in Palo Alto. So, you'd walk around Palo Alto and there would just be Palantir hoodies, Palantir buildings everywhere and so on.

**中文翻译:**
是的，这绝对是一家独一无二的公司。如果你不是像 Peter Thiel 这样的人，我不知道还能怎么创办这样一家公司。在某种程度上，曾经有一段时间，他们占据了帕罗奥图（Palo Alto）很大比例的办公空间。你在帕罗奥图走动，到处都能看到穿着 Palantir 连帽衫的人和 Palantir 的大楼。

---

### (00:08:21) Nabeel S. Qureshi

**English:**
And so, I feel like what happened at some point is they raised a lot of money and they resorted to all these really interesting ways of just getting top talent out of places like Stanford and other top schools and just people who knew the founders who tended to be very interesting intellectual people. And I feel like they screened really hard for a few traits in particular. So, I would say one is very independent-minded people, people who weren't afraid to push back, who questioned the frame of everything and thought for themselves and had strong convictions.

**中文翻译:**
我觉得在某个阶段，他们筹集了大量资金，并采取了各种有趣的方式从斯坦福等名校挖掘顶尖人才，或者是那些认识创始人的、非常有趣的知识分子。我觉得他们非常严格地筛选了几种特质。第一，思想非常独立的人，那些不怕反驳、敢于质疑一切框架、独立思考并有坚定信念的人。

---

### (00:08:55) Nabeel S. Qureshi

**English:**
Two is just people with broader intellectual interests. Karp just released a new book and he's quoting Habermas and all these European intellectuals and just things you don't typically see a tech CEO do. And so, I think there's that intellectual strand in the company. And then yeah, I think three is just people who are very intensely competitive. There's a sort of win at all costs mentality to the company. And so, I think those were the set of traits that were this gravity while in California at a certain time. And so, you just had a lot of really fascinating people joining the company at that time.

**中文翻译:**
第二，拥有广泛知识兴趣的人。CEO Alex Karp 最近出了一本新书，他在书里引用了哈贝马斯（Habermas）和各种欧洲知识分子的观点，这在科技公司 CEO 身上并不常见。所以公司里有一种知识分子气息。第三，极具竞争意识的人。公司有一种“不惜一切代价取胜”的心态。我认为正是这些特质在当时的加州形成了一种引力，吸引了大量迷人的人才加入。

---

### (00:09:33) Nabeel S. Qureshi

**English:**
The way they screened for this was interesting too. So, for the longest time, they had... Everyone does this now, I think, but at the time, it was a little bit rarer, is a founder had to interview you in order for you to receive an offer. And so, a founder, it could have been Alex Karp, it could have been Stephen Cohen. Earlier on, it might have been somebody like Joe Lonsdale, but it was always one of these people.

**中文翻译:**
他们的筛选方式也很有趣。在很长一段时间里，他们坚持——虽然现在大家可能都这么做，但在当时还比较少见——必须由一位创始人亲自面试你，你才能拿到录用通知（Offer）。这位创始人可能是 Alex Karp，也可能是 Stephen Cohen。更早的时候可能是 Joe Lonsdale，但总之一定是他们中的一员。

---

### (01:09:54) Nabeel S. Qureshi

**English:**
And the interviews were pretty strange. With Stephen, it would be, you'd be chatting about philosophy for an hour and a half and it would very much just be like he would pick a topic out of thin air. It was impossible to prepare for, and then he would just go very, very deep and try and test the limits of your understanding. But it would really just be a fun conversation and then if you pass the vibe check, you'd be in. And so, there was that strong selection mechanism.

**中文翻译:**
面试过程非常奇怪。如果是 Stephen 面试，你可能会和他聊一个半小时的哲学，他会随口抛出一个话题。你根本无法准备，然后他会聊得非常深，试图测试你理解能力的极限。但这其实是一场有趣的对话，如果你通过了这种“氛围测试”（Vibe check），你就进去了。所以，那是一种非常强大的筛选机制。

---

### (00:10:20) Nabeel S. Qureshi

**English:**
There was also the question of, I think it might have been Thiel who mentioned this, but he thinks that a lot of the best recruiters in the world or the companies that attract talent, they put out this distinctive bad signal and it has to turn some people off. That's the key of a good, bad signal. So, I think in the present day, OpenAI and Anthropic, they're both sucking up some of the best talent that you and I know. And I think one way they do do that, and they are sincere in this, but they do really attract people who are almost messianic about the potential of artificial super intelligence and who really believe this is the only thing that matters and it is going to be the biggest thing in the world.

**中文翻译:**
还有一个问题，我想可能是 Thiel 提到过，他认为世界上很多最好的招聘人员或吸引人才的公司，都会发出一种独特的“负面信号”，这种信号必须能劝退一部分人。这就是一个好的“负面信号”的关键。比如现在，OpenAI 和 Anthropic 都在吸纳我们所知的最顶尖人才。他们之所以能做到这一点，是因为他们吸引了那些对通用人工智能（AGI）潜力近乎狂热的人，这些人真心相信这是唯一重要的事情，将成为世界上最伟大的事业。

---

### (00:10:56) Nabeel S. Qureshi

**English:**
I think Palantir's version of that was that they were quite focused on things like preserving the West. There was a slogan of Save the Shire, right? So, they were talking about military and defense and intelligence and the importance of that well before everybody else. And bear in mind, this was during the era when it was social, mobile, local apps. You had, social media was on the rise. You had, the hot companies were Facebook and Pinterest and things like that. And so, this was, at the time, a very strange thing.

**中文翻译:**
Palantir 的版本则是专注于“保卫西方”之类的事情。他们有一个口号叫“拯救夏尔”（Save the Shire），对吧？他们在所有人之前就开始谈论军事、国防、情报及其重要性。请记住，那是“社交、移动、本地化”应用的时代，社交媒体正在兴起，最火的公司是 Facebook 和 Pinterest 之类的。所以，在当时看来，Palantir 的关注点非常奇怪。

---

### (00:11:26) Nabeel S. Qureshi

**English:**
And so, I think to be drawn to that, you had to look at the other options and say, "Well, this is fine, but what am I really doing in life?" Whereas you had this other place that was like, "Hey, come solve the hardest, messiest problems in the world with us." And I think just at that time, that really drew some really good people.

**中文翻译:**
所以，要被这种理念吸引，你必须审视其他选择并问自己：“那些公司也不错，但我的人生到底在追求什么？”而 Palantir 会说：“嘿，来和我们一起解决世界上最困难、最混乱的问题吧。”我认为在那个时代，这确实吸引了一批非常优秀的人。

---

### (00:11:43) Lenny Rachitsky

**English:**
We're going to talk about the reasons people don't necessarily like Palantir and the moral question of what they do, but when people look at a company that is like... I guess OpenAI, to your point, is a good example where they're just so turned off by maybe their approach. What you're missing is that's potentially intentional because it actually draws in the people they really want.

**中文翻译:**
我们稍后会讨论人们为什么不喜欢 Palantir 以及关于他们业务的道德问题。但当人们看到一家公司，比如 OpenAI，可能会因为他们的某些做法而感到反感。但你可能忽略了，这或许是故意的，因为这反而能吸引他们真正想要的人才。

---

### (00:12:03) Lenny Rachitsky

**English:**
It makes me think about, I was involved in creating the core values at Airbnb and something that we learned at going through that process is, when you define the values for your company, it's really important to clarify who this is not for, exactly as you described, which feels unnatural. Like, "Oh, we want to be inclusive, we don't want to make people feel like they don't belong." But the whole idea is to be clear on here's who will thrive here and here's who's aligned with our mission. And what I'm hearing is Palantir and these companies take it to the extreme.

**中文翻译:**
这让我想起我曾参与制定 Airbnb 的核心价值观。在那个过程中我们学到，当你定义公司价值观时，明确“谁不适合这里”非常重要，正如你所描述的那样。这听起来可能有点违背直觉，比如我们会想：“哦，我们要包容，不要让人觉得格格不入。”但核心理念是要明确谁能在这里获得成功，谁与我们的使命一致。听起来 Palantir 和这类公司把这一点做到了极致。

---

### (00:12:30) Nabeel S. Qureshi

**English:**
A hundred percent, yeah. On my team at Palantir, one process that we followed, I could talk about this more if it's interesting, is when you started a new project, you basically had to organize what they called a murder board for it. I think this is originally an army type. So, the idea is, basically, you write up a two-page plan for the project. You invite three or four smart folks who don't know anything about the project and their job is just to tear apart your plan.

**中文翻译:**
百分之百正确。在 Palantir 我的团队里，我们遵循的一个流程是（如果感兴趣我可以多聊聊）：当你启动一个新项目时，你必须为此组织一个所谓的“谋杀委员会”（Murder Board）。我想这最初源于军队。基本思路是，你写一份两页的项目计划，邀请三四个对该项目一无所知的聪明人，他们的任务就是把你的计划撕得粉碎。

---

### (00:12:56) Nabeel S. Qureshi

**English:**
And so, you have to write, here's the vision for this, here are the goals, here are the tactics over the next three months. And one section was principles that you're following for this project. And I remember giving this advice a lot was just like when people joined, they would write principles such as move fast and I would always be, "Everyone likes to move fast." It is not a good principle actually because nobody can really disagree with this reasonably. You need something that actually a lot of people are going to go, "Why are you taking this principle? This seems wrong to me." So, you need something that people can disagree with.

**中文翻译:**
你必须写下愿景、目标和未来三个月的战术。其中一个部分是你在这个项目中遵循的原则。我记得我经常给新人的建议是：当他们写下诸如“快速行动”之类的原则时，我会说：“每个人都喜欢快速行动。”这其实不是一个好的原则，因为没有人能合理地反对它。你需要的是那种会让很多人说“你为什么要遵循这个原则？我觉得这不对”的东西。也就是说，你需要一个人们可以产生分歧的原则。

---

### (00:13:29) Lenny Rachitsky

**English:**
I want to come back to the beginning of what you described of what they look for, what Palantir looks for in people. You talked about independent-minded, a lot of interests, broad interests, and competitive. First of all, I think a lot of people hearing that, especially the last part, be like, "I don't want to work there." Why does this work? Because this isn't naturally what you would think of as how you build the most amazing, productive team.

**中文翻译:**
我想回到你开头描述的 Palantir 选人的标准：思想独立、兴趣广泛且极具竞争意识。首先，我觉得很多人听到这些，尤其是最后一点，会觉得“我不想在那儿工作”。为什么这种模式行得通？因为这通常不是人们认为构建一支高效团队的常规方式。

---

### (00:13:52) Nabeel S. Qureshi

**English:**
I think it just draws people who want to win. I think that's what was really important. The other piece of it, I think, is that there's actually, and this was much truer 10 years ago, is there was a lot of talent that was a little bit outside of the tech ecosystem but could easily have been very successful within it. So, people who got out of the military or one of the intelligence agencies and they were doing, let's say, an MBA somewhere to transition into the corporate world. And I think, typically, they would have taken a position at a classic Fortune 500 corporation. And actually, Palantir managed to get a bunch of that talent. And at the time, that was very undervalued.

**中文翻译:**
我认为它吸引的是那些渴望胜利的人。这是非常关键的一点。另一部分原因是（十年前更是如此），当时有很多处于科技生态系统边缘的人才，他们其实可以在科技圈非常成功。比如那些从军队或情报机构退役，正在读 MBA 准备转型进入企业界的人。通常他们会去传统的财富 500 强公司，但 Palantir 成功吸引了这批人才。在当时，这批人是被严重低估的。

---

### (00:14:32) Nabeel S. Qureshi

**English:**
The people who succeed the most in the Marines or the Special Forces or whatever it is, tend to be pretty smart people. They tend to have accomplished very difficult goals in very hostile environments. And it turns out that when you're starting a somewhat chaotic tech company, that's actually a very useful skill to have. Again, I think more companies are doing this now, so Scale AI and et cetera. But at the time, that was a very differentiated talent pool.

**中文翻译:**
那些在海军陆战队或特种部队中表现最出色的人，往往非常聪明。他们习惯于在极其恶劣的环境中完成艰巨的任务。事实证明，当你创办一家有点混乱的科技公司时，这其实是一项非常有用的技能。虽然现在像 Scale AI 等公司也在这么做，但在当时，这是一个非常差异化的人才库。

---

### (00:14:57) Nabeel S. Qureshi

**English:**
And so, I think having those values as opposed to maybe the values that were more in fashion then, so talking about how inclusive you are, or the sushi that you serve at lunch, or whatever it is, it just drew a very different crowd. And I think the game that was being played there was, one, it's mission alignment. You're doing a defense company, that's the kind of person you want to attract. But I think there's also, two, which is just what is the talent that maybe is a little bit undervalued now and how do you actually draw those people to you? And I think that game is always shifting.

**中文翻译:**
所以，我认为坚持这些价值观，而不是当时流行的那些——比如谈论公司有多包容、午餐供应什么寿司之类的——吸引了一群完全不同的人。我认为当时的策略是：第一，使命一致性。既然是做国防公司，你就得吸引那种类型的人。第二，寻找当前被低估的人才并吸引他们。我认为这种人才博弈一直在变化。

---

### (00:15:31) Lenny Rachitsky

**English:**
This is definitely starting to explain why so many Palantir alumni go on to start companies and become leaders at other companies. These are leaders that you're hiring. So, it feels like a lot of it is just the talent you hire are people that are naturally leaders.

**中文翻译:**
这确实开始解释了为什么这么多 Palantir 的校友后来去创业或在其他公司担任领导者。因为你们招聘的本身就是领导者。感觉很大程度上是因为你们招的人天生就具备领导素质。

---

### (00:15:45) Nabeel S. Qureshi

**English:**
I think you're right, and we can get more into it, but I think there was also a very concrete set of ways where that place was a training ground for founders. I even think it turned a lot of people who might not have become founders into good founders because of the way it works. So, I think there was a selection effect there, but there is also some training effect too, but it's unique to the way the company works.

**中文翻译:**
你说得对，我们可以深入聊聊。但我认为 Palantir 还有一套非常具体的机制，使其成为创始人的“训练场”。我甚至认为，由于其运作方式，它把很多原本可能不会创业的人变成了优秀的创始人。所以，这既有筛选效应，也有培训效应，但这与公司的运作方式息息相关。

---

### (00:16:08) Lenny Rachitsky

**English:**
And is that along the lines of the forward deployed engineer stuff or is that something else?

**中文翻译:**
这和“前线部署工程师”有关吗？还是别的什么？

---

### (00:16:11) Nabeel S. Qureshi

**English:**
It is that, yes.

**中文翻译:**
没错，就是那个。

---

### (00:16:12) Lenny Rachitsky

**English:**
Okay, cool. We're going to get to that. I love it. Okay, amazing. Before we do that, one last thing is something I've seen is that you guys at Palantir don't really have titles. Everyone's the same level and just generic titles for everyone. Talk about that. Why do you think that was important? Why was that useful?

**中文翻译:**
好，太棒了，我们待会儿聊那个。在那之前，还有最后一件事：我注意到 Palantir 内部其实没有真正的头衔。每个人的级别似乎都一样，头衔也很通用。能聊聊这个吗？为什么你认为这很重要？它有什么用？

---

### (00:16:29) Nabeel S. Qureshi

**English:**
I don't know this for sure, but I do know that Thiel writes about this in Zero to One and his take is just that as soon as we have these title, you have a thing that people are competing for and then you get these very unproductive conflicts. You get people optimizing to game the system. You get Goodhart's law everywhere. So, it's like you have a metric and then people basically manage to the metrics.

**中文翻译:**
我不完全确定，但我知道 Thiel 在《从 0 到 1》里写过这个。他的观点是，一旦有了头衔，人们就会为了头衔而竞争，从而产生很多无谓的冲突。人们会为了钻系统的空子而优化自己的行为，导致“古德哈特定律”（Goodhart's law，即当一个指标变成目标时，它就不再是一个好指标了）随处可见。人们会为了指标而工作，而不是为了真正的目标。

---

### (00:16:50) Nabeel S. Qureshi

**English:**
I don't want to pick on any one company, but if you take Google, for example, there's a lot of interesting posts by people who left Google and they cite this as a reason why they got a little bit disgruntled, is that there's a way to get promoted. Rather than, let's say, improving an existing product, what you do is you start a completely new product and that has your name attached to it. And then when it comes to promotion season, you could say, "Hey, I did this new thing." And then boom, you have a new Google product, but it's maybe confusing to the end user.

**中文翻译:**
我不想针对任何一家公司，但以 Google 为例，很多离职员工在文章中提到，他们感到不满的原因之一就是晋升机制。与其改进现有产品，不如启动一个全新的产品，这样你的名字就能与之挂钩。到了晋升季，你可以说：“嘿，我做了这个新东西。”于是，Google 又多了一个新产品，但对最终用户来说可能非常困惑。

---

### (00:17:15) Nabeel S. Qureshi

**English:**
So, I think they wanted to avoid all these kinds of dynamics. And so, the way that they did that was they said, "Well, titles are not going to be this memetic totem that everybody competes for. Instead, everyone is just going to have the same slightly meaningless title, which is forward deployed engineer." And the only people who did have titles were the CEO and then there were six directors and that was it. And now, I think it's a little bit more nuanced. There are different teams. There are some people with titles, but honestly, it was almost like...

**中文翻译:**
所以，我认为 Palantir 想要避免这种动态。他们的方法是：头衔不应该成为每个人竞争的图腾。相反，每个人都拥有一个略显模糊的头衔，即“前线部署工程师”。当时唯一有头衔的人是 CEO 和六位总监，仅此而已。现在可能稍微复杂一点，有了不同的团队和一些带头衔的人，但说实话，当时的情况几乎是……

---

### (00:17:45) Nabeel S. Qureshi

**English:**
We used to joke about it. It's like people would leave the company and then you'd see them update their LinkedIn and they would be like, "Oh yeah, I was totally the SVP of XYZ." And it's like, "No, you weren't. You're just..." But then it's like I totally understand it too because when you leave the company, you have to make your experience legible to the next person. And so, guess what? Things like SVP actually do matter.

**中文翻译:**
我们以前常开玩笑说，有人离职后更新 LinkedIn，会写上“我是某某部门的高级副总裁（SVP）”。其实并不是，你只是……但我完全理解，因为当你离开公司时，你必须让你的经历对下一个人来说是清晰易懂的。所以，像 SVP 这样的头衔确实有它的作用。

---

### (00:18:08) Nabeel S. Qureshi

**English:**
And so, yeah, I think they wanted to avoid this intel competition. There are downsides to doing this. So, maybe the competition isn't as explicit around a specific title, but instead, what it becomes about is there's a particular exact or something and you want to gain that favor. And so, it becomes more about who can get in the inner circle of this person or whatever. And there were those dynamics too.

**中文翻译:**
所以，他们想避免这种内部竞争。当然，这样做也有弊端。竞争可能不再围绕具体的头衔展开，而是变成了争取某个高管的青睐，变成了谁能进入某个人的“核心圈子”。这种动态也是存在的。

---

### (00:18:32) Nabeel S. Qureshi

**English:**
I actually am a big fan of this philosophy though, the no titles one. I think what it did do is that it basically said if you are in, let's say you're in a role of you're leading a very important project, which could happen, what it said was... This is always fluid. So, you are in this role because you're very good and so, it's a meritocratic thing. But if you start performing well, it's actually very easy to shift that because there is no explicit " I am the GM of this project title." And so, you always had to earn your place in the company. You always had to earn the right to work on what you were working on, and I think that was a good side effect.

**中文翻译:**
但我其实非常推崇这种“无头衔”哲学。它的核心意义在于：如果你正在领导一个非常重要的项目，那是因为你足够优秀，这是一种精英管理。但如果你表现不好，调整起来也很容易，因为没有明确的“我是这个项目的总经理”之类的头衔。因此，你必须始终通过表现来赢得你在公司的位置，赢得负责某个项目的权利。我认为这是一个很好的副作用。

---

### (00:19:12) Lenny Rachitsky

**English:**
Let's start talking about forward deployed engineers. What is a forward deployed engineer?

**中文翻译:**
让我们开始聊聊“前线部署工程师”吧。到底什么是前线部署工程师？

---

### (00:19:17) Nabeel S. Qureshi

**English:**
So, the way this originated was, basically, you can think of it as there's two types of engineer at Palantir. So, there's one that works on the core products. So, they don't necessarily leave the building in Palo Alto or New York or the offices. They're very much working on the core products and they're a traditional software engineer.

**中文翻译:**
这个角色的起源是这样的：你可以认为 Palantir 有两类工程师。一类负责核心产品，他们通常不需要离开帕罗奥图或纽约的办公室，专注于核心产品的开发，是传统的软件工程师。

---

### (00:19:35) Nabeel S. Qureshi

**English:**
Because of the way the company works where you had these very large engagements with these large entities, there was a different type of engineer which you sent into the field. So, what that meant was you would spend maybe Monday to Thursday and you would actually go into the building where the customer worked and you would work alongside them. You would literally get a desk there. And so, that engineer became known as a forward deployed engineer.

**中文翻译:**
由于公司的运作方式涉及与大型机构的大规模合作，于是就有了另一类被派往现场的工程师。这意味着你可能周一到周四都在客户的办公楼里，和他们一起工作。你真的会在那里有一个工位。这类工程师就被称为“前线部署工程师”。

---

### (00:19:55) Nabeel S. Qureshi

**English:**
So, within the company, that function is known as business development or BD. And then PD is product development. So, it's where the product is made. And so, within BD, you had forward deployed engineers. There are actually two types. So, there is one that it's a more technical software engineer. So, you have to pass a software engineering interview and prove your chops there and you would typically have a CS degree, but there was actually a type of forward deployed engineer that didn't have that.

**中文翻译:**
在公司内部，这个职能被称为业务发展（Business Development，简称 BD），而 PD 则是产品开发（Product Development）。在 BD 部门下，就有前线部署工程师。实际上有两种类型：一种是更偏技术的软件工程师，你必须通过软件工程面试证明自己的实力，通常拥有计算机科学（CS）学位；但实际上还有一种前线部署工程师并不需要这些。

---

### (00:20:30) Nabeel S. Qureshi

**English:**
So, you would still get a technical interview, but it would be less about, do you know the specifics of this C++ algorithm? And it would be more about just like can you reason about data? We didn't have that division originally, but it turns out that there's a lot of people who are technical adjacent, shall we say, who you really need in the room when you're working with these large organizations or these large companies, because translating what you're doing into language that would resonate with an executive or being able to navigate the social dynamics in a room, all these are very valuable skills. And so, the hiring criteria there were a little different. It was a bit more about, are you savvy as a human? But all of that was given the title of forward deployed engineer, and it's just an engineer who works with customers.

**中文翻译:**
你仍然需要参加技术面试，但重点不在于你是否了解某个 C++ 算法的细节，而在于你是否具备数据推理能力。我们最初没有这种划分，但后来发现，在与大型组织或公司合作时，你确实需要一些“技术相邻”的人才。因为将技术工作转化为能引起高管共鸣的语言，或者处理复杂的社交动态，都是非常宝贵的技能。所以那里的招聘标准略有不同，更看重你作为一个人的洞察力和交际能力。但所有这些人的头衔统一都是“前线部署工程师”，本质上就是与客户直接对接的工程师。

---

### (00:21:10) Lenny Rachitsky

**English:**
Okay, so just to make this crystal clear for people, a lot of people hear this idea of Palantir having forward deployed engineers. A few other companies have done this. It's pretty radical. So, as you described, you basically have a desk at a company. So, you worked with Airbus and we'll talk about that. So, let's just make it real. So, you have a desk and a computer and login access and all these things at Airbus. You go to their office four times a week. You're sitting there with their employees working side by side, building a product for them, versus what most people do where "they just talk to customers," where they do an interview once in a while, they do a Zoom, they share mocks, things like that. This is like that on steroids. Is that roughly the way to think about it?

**中文翻译:**
好，为了让大家听得更明白：很多人听说过 Palantir 有前线部署工程师，其他一些公司也效仿过，这非常激进。正如你所描述的，你基本上在客户公司有个办公桌。比如你曾为空客（Airbus）工作，我们在空客有办公桌、电脑和登录权限。你每周去他们的办公室四次，和他们的员工并肩作战，为他们构建产品。这与大多数人所谓的“与客户交流”（偶尔访谈、开 Zoom 会议、分享原型图）完全不同。这简直是“加强版”的客户沟通。可以这样理解吗？

---

### (00:21:51) Nabeel S. Qureshi

**English:**
It is, yeah. And so, we would really be there a lot of the time. And so, the side effect of that was, one, you learn to live and breathe the customer's problems and you learn to speak their language. And eventually, they saw you as one of them and so, you develop these really close bonds with the customers. So, at Airbus, I would be at the factory where the planes were produced, or I'd be sitting next to people diagnosing issues with aircraft or whatever it was. Similarly, later on, I worked with the NIH, which was part of the US government, and I actually had a badge there and I would work with civil servants and biologists and clinicians and people who were working there.

**中文翻译:**
没错。我们大部分时间都在那里。这种方式的副作用是：第一，你学会了与客户的问题同呼吸共命运，学会了他们的语言。最终，他们会把你当成自己人，从而建立起非常紧密的联系。在空客，我会出现在飞机制造厂，或者坐在诊断飞机故障的人员旁边。后来在 NIH（美国国家卫生研究院）工作时，我甚至有那里的工牌，和公务员、生物学家、临床医生一起工作。

---

### (00:22:31) Nabeel S. Qureshi

**English:**
And so, it's this pretty radical thing as you suggest. I think the key thing there from a business point of view is the average deal that Palantir had was very large in the many, many millions of dollars, which means that you could pay for this as part of the thing that the customer got. And then it was priced according to the value that the customer got.

**中文翻译:**
所以正如你所说，这非常激进。从商业角度来看，关键在于 Palantir 的平均订单金额非常大，通常是数千万美元，这意味着这种服务可以作为客户获得的产品价值的一部分。而定价则是根据客户获得的价值来定的。

---

### (00:22:51) Nabeel S. Qureshi

**English:**
So, as a simple example, if you're Airbus and let's say that you have an issue with one of your planes and you need to fix it, and fixing that is worth a $100 million or something to you, that's how it would be priced. It would not be priced as, "Hey, you're buying data infrastructure and it's similar to Snowflake or Databricks or one of these other providers. It's much more anchored to, here is the outcome.

**中文翻译:**
举个简单的例子，如果你是空客，假设你的一架飞机出了问题需要修理，而修好它对你来说价值 1 亿美元，那么定价就会以此为基准。它不会被定价为“你在购买数据基础设施，价格参考 Snowflake 或 Databricks”。它更多是锚定在“这是最终结果”上。

---

### (00:23:15) Nabeel S. Qureshi

**English:**
But then the job of the forward deployed engineer is not just to deploy software. It is not just to sell software. It is to actually solve the problem. And so, you would have to be there. You would have to meet the key stakeholders who are actually in charge of reporting to the CEO about the specific issue. You would have to become their friend. You would have to gain their trust. And you would have to, in some cases, create new software such that it could actually solve the novel problem that was in front of you.

**中文翻译:**
而前线部署工程师的工作不仅仅是部署软件，也不仅仅是销售软件，而是真正解决问题。所以你必须在现场，必须会见那些负责向 CEO 汇报特定问题的关键利益相关者。你必须成为他们的朋友，赢得他们的信任。在某些情况下，你甚至需要开发全新的软件来解决眼前的各种新问题。

---

### (00:23:41) Nabeel S. Qureshi

**English:**
So, I would have friends who worked with one of our energy company customers and they would have to learn the ins and outs of how oil wells work. And then out of that, it turns out that having streaming data is actually very valuable for this use case. And so, boom, suddenly, there's a product that can handle streaming data that becomes part of the core platform. But that would be the motion, is you learn about the problem. You figure out what software would best address it. You build that software. You use it to accomplish the goal. And then eventually, that gets folded into the broader product suite.

**中文翻译:**
我有些朋友在为一家能源公司客户服务，他们必须学习油井运作的所有细节。结果发现，流数据（Streaming data）对这个用例非常有价值。于是，砰的一声，一个能处理流数据的产品应运而生，并成为了核心平台的一部分。这就是运作流程：了解问题，确定最适合的软件方案，构建软件，用它达成目标，最后将其整合进更广泛的产品套件中。

---

### (00:24:13) Nabeel S. Qureshi

**English:**
And so, you can start to see why this would be a good forge for founders. And this was actually part of my thesis going in and joining, was I said, "Well, say, I got five reps of this," which I got more than that. But say, you got five reps of doing this in five disparate contexts, you actually become very good at this cycle of, okay, go into the building, gain the trust of the person, meet the people that are going to become your users, talk to them about their problems, make sure you're building something that actually solves them, and it's just a boondoggle.

**中文翻译:**
所以你可以看出为什么这里是创始人的“熔炉”。这也是我加入时的初衷之一，我想：“如果我能经历五次这样的循环（实际上我经历得更多）”，在五个完全不同的背景下重复这个过程，你就会变得非常擅长这个循环：进入大楼、赢得信任、会见未来的用户、讨论他们的问题、确保构建的东西能真正解决问题。

---

### (00:24:43) Nabeel S. Qureshi

**English:**
Get really fast feedback and iteration loops. So, every week, you would have a cadence where it's like Monday, you go in. You do your meetings. Monday night, you build something. Tuesday, you show it to somebody. Tuesday, you get the feedback. Tuesday night, you iterate on it. Wednesday, you show it to somebody. Wednesday night, you iterate on it. So, you get four of these, five of these cycles every single week.

**中文翻译:**
获得极快的反馈和迭代循环。每周你都有一个节奏：周一进场开会，周一晚上写代码；周二展示给别人看并获取反馈，周二晚上进行迭代；周三再展示，周三晚上再迭代。这样你每周都能完成四五个这样的循环。

---

### (00:25:00) Nabeel S. Qureshi

**English:**
So you get four of these, five of these cycles every single week, and you're moving incredibly fast. So 6 weeks in, you've suddenly gotten to, wow, this is really valuable, and somebody's willing to pay you whatever, $20 million for it, and boom. I think this is why you get so many founders coming out of this same process.

**中文翻译:**
你每周都在以惊人的速度推进。六周之后，你突然发现：“哇，这真的很有价值”，而且有人愿意为此支付 2000 万美元。砰！我认为这就是为什么这个过程中走出了这么多创始人的原因。

---

### (00:25:20) Lenny Rachitsky

**English:**
It's becoming very clear why so many founders emerged out of Palantir. Okay. So an important element of this as you described, is that the idea here is build this as a one- off solution to solve a real problem at say Airbus or some government organization. And then the idea as you create something out of that, that then Palantir can sell to other companies. What's extra cool about that is they pay you to solve this problem for them and then that is funding this other product that Palantir can now sell to everyone. What a cool business.

**中文翻译:**
现在非常清楚为什么 Palantir 出了这么多创始人了。好，正如你所描述的，这里的一个重要元素是：先构建一个一次性的解决方案来解决空客或政府机构的实际问题，然后从中提炼出 Palantir 可以卖给其他公司的产品。最酷的地方在于，他们付钱让你帮他们解决问题，而这笔钱实际上资助了 Palantir 随后可以卖给所有人的产品。多么棒的商业模式。

---

### (00:25:51) Lenny Rachitsky

**English:**
However, early days Palantir, everyone thought it was just this services business or just consultants building software for companies like Airbus, there's no way they can make this a platform that works for a lot of people. Clearly, that's what's happening and it worked out. This is like the holy grail. Solve one customer's problem and then sell it to everyone else. Every SaaS business basically would love to do this. What do you think allowed them to actually achieve this and be good at this? What are some principles that worked?

**中文翻译:**
然而，在 Palantir 早期，大家都认为这只是一家服务型企业，或者只是为像空客这样的公司开发软件的咨询公司，觉得他们不可能把它做成一个通用的平台。显然，他们做到了。这简直是“圣杯”：解决一个客户的问题，然后卖给所有人。每个 SaaS 企业都梦寐以求。你认为是什么让他们真正实现了这一点并做得这么好？有哪些行之有效的原则？

---

### (00:26:22) Nabeel S. Qureshi

**English:**
Yeah. That's a great question and it's true. I think that from when I joined until maybe until IPO and a little bit after, I was told, "Hey, isn't this basically a sparkling extension? Isn't it a consulting business lopping as a product company?" And eventually it became undeniable. One, because I always laugh when people are like, "What does Palantir do?" It's like you can go onto YouTube and just search Palantir demo and you'll get plenty of demos of how the software looks. Not many people know about this, but you can go and sign up with a credit card right now and start using it.

**中文翻译:**
是的，这是个好问题。确实如此。从我加入到 IPO 甚至之后的一段时间，一直有人跟我说：“嘿，这不就是一个高级外包吗？不就是披着产品公司外衣的咨询公司吗？”但最终事实变得不可否认。首先，当人们问“Palantir 是做什么的”时我总想笑，因为你只要去 YouTube 搜一下“Palantir demo”，就能看到大量软件演示。而且没多少人知道，你现在就可以用信用卡注册并开始使用它。

---

### (00:26:22) Lenny Rachitsky

**English:**
I can have a Palantir account?

**中文翻译:**
我能拥有一个 Palantir 账号？

---

### (00:26:22) Nabeel S. Qureshi

**English:**
You actually can. Yeah.

**中文翻译:**
你真的可以。是的。

---

### (00:26:22) Lenny Rachitsky

**English:**
I did not know that. That's cool.

**中文翻译:**
我还真不知道。太酷了。

---

### (00:26:57) Nabeel S. Qureshi

**English:**
Yeah. I think it's called AIP now. So it's not actually that mystical and there is a product, and if you look at the margins, they show that. So they have 80% plus margins, which is not really what you would get if you were actually a consulting company. It would be closer to 20 or 30%. So then your question was, well, how did they actually achieve this? I think there was just incredible talent in the product development organization, really top tier, incredible talent.

**中文翻译:**
是的，我想现在叫 AIP。所以它其实没那么神秘，它确实有产品。如果你看利润率，就能说明问题。他们的利润率在 80% 以上，如果你真的是一家咨询公司，利润率通常只有 20% 到 30%。回到你的问题：他们是如何实现的？我认为产品开发部门拥有令人难以置信的顶尖人才。

---

### (00:27:30) Nabeel S. Qureshi

**English:**
And it took some really, really smart people to take the set of internal tools that we were using at the time to create value of customers and then go, what is the unified version of this? Would this look like if this were a product? And out of that process that I saw came Foundry assume there was a similar process with Gotham a while back. But basically it's like, the motion was that you would go in and early on you were basically armed with Jupyter Notebooks and some data integration stuff, but it was very primitive and you had to create value that way.

**中文翻译:**
需要非常聪明的人，把我们当时用来为客户创造价值的一套内部工具拿出来，然后思考：它的统一版本是什么？如果它是一个产品，会是什么样子？我见证了 Foundry 的诞生过程，我想早期的 Gotham 也有类似的过程。基本上，最初你进场时只带着 Jupyter Notebooks 和一些数据集成工具，非常原始，你必须以此创造价值。

---

### (00:28:03) Nabeel S. Qureshi

**English:**
But we kept building tooling that was useful for forward deployed engineers. So we were our own first customers and at some point there was this concept of, "Wait, what if we take our internal tools and we let our customers use them?" And I remember at the time, this is a really radical idea. And then Shyam Sankar, I think he's the CTO, maybe he's the president now, he just mandated like, "Okay. Every customer deployment you have to have a customer using this within three months or whatever."

**中文翻译:**
但我们一直在构建对前线部署工程师有用的工具。所以我们自己就是第一批客户。在某个时刻，出现了一个想法：“等等，如果我们把内部工具直接给客户用呢？”我记得当时这被认为是一个非常激进的想法。然后 Shyam Sankar（我想他现在是 CTO 或总裁）下达了命令：“好，每个客户部署，必须在三个月内让客户亲自使用这些工具。”

---

### (00:28:52) Nabeel S. Qureshi

**English:**
So it was horrible at the time because these had been built for these nerdy Silicon Valley engineers, and so they weren't particularly usable. They would crash all the time. You'd have to debug spark errors or whatever it was. But basically that process brought a lot more rigor to our thinking about the product. And out of that kind of, I would say three or four year process came the Foundry product. And then there was a lot of focus around things like performance and reliability and so on. That was all really painful.

**中文翻译:**
当时情况很糟糕，因为这些工具是为硅谷的技术宅工程师设计的，并不好用。它们经常崩溃，你得去调试 Spark 错误之类的。但基本上，那个过程让我们的产品思维变得更加严谨。经过大约三四年的过程，Foundry 产品诞生了。随后我们投入了大量精力在性能、可靠性等方面。那段经历非常痛苦。

---

### (00:29:25) Nabeel S. Qureshi

**English:**
So yeah, I think the answer was just talent. And then there was this recognition that we do. We do know things that most people do not know about how data works in large organizations. That was the other thing. We discovered a lot of "secrets" in this process of living with customers for so long. The basic one was just data integration is massively painful inside organizations. This is very hard to understand unless you've worked in a large organization, but it's actually impossible to even now to get access to a lot of your own internal data that you need to do your job.

**中文翻译:**
所以，答案就是人才。此外，我们意识到我们确实掌握了一些大多数人不知道的关于大型组织数据运作的“秘密”。在与客户长期共处的过程中，我们发现了很多秘密。最基本的一个就是：在组织内部，数据集成极其痛苦。除非你在大公司待过，否则很难理解这一点。即使是现在，想要获取开展工作所需的内部数据，实际上也是非常困难的。

---

### (00:30:00) Lenny Rachitsky

**English:**
Okay. There's a lot here. First of all, you talk about Gotham and Foundry. I know that we'll link to videos of people checking these out, but just what's the simplest way to understand what these two products do?

**中文翻译:**
好，信息量很大。首先，你提到了 Gotham 和 Foundry。我知道我们会提供视频链接供大家查看，但能不能用最简单的方式解释一下这两个产品到底是做什么的？

---

### (00:30:10) Nabeel S. Qureshi

**English:**
So Gotham is optimized for military and defense use cases and intel as well. I would say they both have some things in common. So they both have, I would describe this almost as a pyramid where the bottom layer is data ingestion, the middle layer is data mapping, and then the top layer is anything that's user facing. So any UI component. And then if you think of Foundry for a second, there's different tools that allow you to ingest data to it. There's different tools that allow you to easily build data pipelines and clean up data, which everybody has to do. And then there's a bunch of tooling that allows you to build compelling UIs on top, do point and click analytics, do notebook style workflows, however technical you are.

**中文翻译:**
Gotham 针对军事、国防和情报用例进行了优化。它们有一些共同点。我把它们描述为一个金字塔：底层是数据摄取（Data ingestion），中间层是数据映射（Data mapping），顶层是任何面向用户的 UI 组件。以 Foundry 为例，它有不同的工具让你摄取数据，有工具让你轻松构建数据管道并清理数据（这是每个人的刚需），还有一系列工具让你在上面构建引人入胜的 UI、进行点击式分析、进行笔记本式的流程操作，无论你的技术水平如何都能上手。

---

### (00:31:08) Nabeel S. Qureshi

**English:**
So that's, I mean, when it's a platform, it's a suite of things that has a common data backing but contains a bunch of different applications. So I think that is somewhat true of Gotham as well. But when you log in, you see this unified interface. So what is the actual difference then? I would say with Gotham, you're looking much more at workflows like that involve maps, for example. So when you're doing a military operation, a lot of the time you are going to be looking at a map and you are going to be monitoring the movement of troops or tanks or whatever it is.

**中文翻译:**
所以，作为一个平台，它是一套拥有共同数据后端但包含许多不同应用的套件。Gotham 也是如此。当你登录时，你会看到一个统一的界面。那么实际区别是什么呢？我会说，在 Gotham 中，你更多看到的是涉及地图的工作流。比如在进行军事行动时，你大部分时间都在看地图，监控部队、坦克或任何目标的移动。

---

### (00:31:56) Nabeel S. Qureshi

**English:**
Another big difference is the idea of graph-based analysis. So Gotham, one of the use cases was finding combing through networks of terrorists and basically finding the bad guys. So being able to do queries that are graph-based was important. So it's like, "Who is everybody that Lenny called in the last week?" Imagine all the nodes fanning out from there. And then it's like, "Okay. Well, this one looks interesting. Let's zoom in on that. What is this person's location?"

**中文翻译:**
另一个大区别是基于图（Graph-based）的分析理念。Gotham 的一个用例是梳理恐怖分子网络并找出坏人。因此，进行基于图的查询非常重要。比如：“Lenny 上周给谁打过电话？”想象一下从那里散发出的所有节点。然后，“好，这个看起来很有趣，让我们放大看看，这个人的位置在哪？”

---

### (00:32:20) Nabeel S. Qureshi

**English:**
So it's this very graph-based way of thinking that also applies to things like fraud. So Gotham has been deployed against fraud, but if you look at Foundry, it doesn't actually emphasize that component so much because it turns out, let's say you're a B2B SaaS company, you're probably not doing that much graph-based analysis. You're doing things that look a lot more like classic SQL queries, tables, that kind of stuff. So Foundry is a lot more traditional in that way.

**中文翻译:**
这种基于图的思维方式也适用于反欺诈。Gotham 曾被用于打击欺诈。但如果你看 Foundry，它并不那么强调这一组件，因为如果你是一家 B2B SaaS 公司，你可能不需要做那么多图分析，你做的更多是经典的 SQL 查询、表格之类的事情。所以 Foundry 在这方面更传统一些。

---

### (00:32:36) Lenny Rachitsky

**English:**
That was an amazing explanation. For the first time, I am starting to understand what these products do. Basically, it's just sucks in a bunch of data, cleans it up so you can actually trust it and then helps you interact with it in various use cases, maps, graphs, tables.

**中文翻译:**
这个解释太棒了。我第一次开始理解这些产品是做什么的了。基本上，它就是吸纳大量数据，进行清理以便你可以信任它，然后帮助你在各种用例（地图、图表、表格）中与之交互。

---

### (00:32:36) Nabeel S. Qureshi

**English:**
Yes.

**中文翻译:**
是的。

---

### (00:32:36) Lenny Rachitsky

**English:**
Okay. Amazing. The example you gave of what you worked on at Airbus, you described it as basically a sauna for making planes. Is that right?

**中文翻译:**
好，太棒了。你举的在空客工作的例子，你把它描述为“制造飞机的 Asana”（注：Asana 是一款项目管理工具）。是这样吗？

---

### (00:32:44) Nabeel S. Qureshi

**English:**
Yes.

**中文翻译:**
是的。

---

### (00:32:45) Lenny Rachitsky

**English:**
So how much of that does becomes a part of this core product versus stays this one-off thing? Is it elements, that's a cool innovation, let's put that into Foundry. How does that work?

**中文翻译:**
那么，其中有多少变成了核心产品的一部分，又有多少保持为一次性的东西？是某些元素被认为是“很酷的创新，放进 Foundry 吧”？这个过程是怎么运作的？

---

### (00:32:55) Nabeel S. Qureshi

**English:**
This was a really interesting story actually. So the initial problem that we came into with Airbus was that they had a new aircraft called the A350 beautiful aircraft. By the way, if you get to, I think if you fly New York to Singapore, it's often in that A350. Really nice. So it was a relatively new aircraft at the time, and their mandate to us was, "Okay. We need to ramp up production of this really fast," much faster than we've ever done it before.

**中文翻译:**
这其实是一个非常有趣的故事。我们最初在空客遇到的问题是，他们有一款名为 A350 的新飞机，非常漂亮。顺便说一下，如果你飞纽约到新加坡，通常坐的就是 A350。当时这是一款相对较新的机型，他们给我们的任务是：“好，我们需要快速提高这款飞机的产量”，比我们以前做过的任何时候都要快。

---

### (00:33:42) Nabeel S. Qureshi

**English:**
So we went in, scoped out the problem. There were a bunch of different things that we could build that helped accelerate this, but one of the basic problems that we figured out was that without getting too much into the weeds, the way the factory would work, is that there's a bunch of stations and you can think of the plane as literally moving between each station and then each station would do a certain set of work on it.

**中文翻译:**
于是我们进场调研。我们可以构建很多不同的东西来加速这个过程，但我们发现的一个基本问题是（不谈太细的技术细节）：工厂的运作方式是有一系列工作站，你可以想象飞机在各个工作站之间移动，每个工作站负责一组特定的工作。

---

### (00:34:23) Nabeel S. Qureshi

**English:**
So in order for the next station to do its work properly, they need to know, one, what work was done at the previous station and what work is remaining? Two is just like, if you think about this problem, not all work is going to get done on time. So things carry over to the next team, and the next team then has to... So when I'm describing this problem to you can start to visualize, okay, maybe I need some Gantt chart to this, and I need the ability to click in and say, "Okay. What did Station 30 do and what work orders remained undone?"

**中文翻译:**
为了让下一个工作站正常开展工作，他们需要知道：第一，上一个工作站完成了什么工作，还剩什么工作？第二，并非所有工作都能按时完成，所以有些工作会顺延到下一个团队。当我向你描述这个问题时，你可以开始想象：好，也许我需要一个甘特图，需要点击进去查看“30 号站做了什么，还有哪些工单没完成”的能力。

---

### (00:35:20) Nabeel S. Qureshi

**English:**
All that data was stored in SAP and SAP is like established software. It's good at what it does, but it's not the most user-friendly necessarily, especially if you're not an expert in how it stores data. The table names are very hard to understand and read. So one of the things we figured out was just if you can pull in these tables that may as well be written in completely alien language, the table name would just be like S3, F1_Z or something like that. And you'd have to know, okay, this is the table where the part ID is stored or something.

**中文翻译:**
所有这些数据都存储在 SAP 中。SAP 是一款成熟的软件，它在自己的领域表现出色，但并不一定用户友好，特别是如果你不是数据存储专家的话。表名非常难懂。我们发现的一件事是：如果你能把这些读起来像外星语言的表（表名可能只是 S3, F1_Z 之类的）拉进来，你必须知道这是存储零件 ID 的表。

---

### (00:35:51) Nabeel S. Qureshi

**English:**
If you could pull in those tables and join them in the right ways, and then just map them to human concepts that humans can understand, so things like a part a work order, an aircraft, et cetera, and basically build a hierarchy or mapping between them, then what you can do is, a user can just log in and say, "Okay. Aircraft 79, where is that? Okay. It's at Station 31. All right. These are the work orders, et cetera." So you've translated it into a more human-legible thing.

**中文翻译:**
如果你能拉进这些表并以正确的方式连接它们，然后将它们映射到人类可以理解的概念（如零件、工单、飞机等），并在它们之间建立层级或映射关系，那么用户就可以登录并说：“好，79 号飞机在哪？在 31 号站。这些是工单……”这样你就把它转化成了人类可读的东西。

---

### (00:36:16) Nabeel S. Qureshi

**English:**
So the thing we built, I slightly flippantly described it as Asana. It's a little different. But basically that's what it did, was it gave you a unified view of, okay, this is what's going on inside the factory. This is the work that needs to be done on this particular plane. And then me today going to my job at Station 31, what work orders do I need to fulfill and where are the parts that I need to do that? So did this directly become a part of Foundry? Not exactly, because the way that other companies work is not going to be using this same set of concepts, but the overall idea of taking a bunch of tables, and then mapping them to human understandable concepts was a very powerful one.

**中文翻译:**
所以我刚才有点轻率地把它描述为 Asana，其实有点不同。但基本上它做的就是给你一个统一的视图：工厂内部发生了什么，这架飞机需要完成什么工作。作为今天在 31 号站工作的我，需要完成哪些工单，所需的零件在哪里？这是否直接成为了 Foundry 的一部分？不完全是，因为其他公司的运作方式不会使用这套相同的概念。但将一堆表映射到人类可理解概念的整体思路是非常强大的。

---

### (00:36:58) Nabeel S. Qureshi

**English:**
So this actually resulted in a big piece of Foundry now, which they call Ontology. You've probably heard this term as you've seen... If you see Palantir presentations, they always talk about Ontology. This is what they actually mean by that, is it is a set of concepts that is understandable to you as a human and you are not having to go and dig around and do. You're just able to say, "Where is the aircraft now and where is it going next?" So the ontology became a huge piece of Foundry. It was directly informed by the learnings that we had from building that application inside that factory. And I would say it's still a very big differentiator today. I don't think too many other companies ship this kind of stuff yet.

**中文翻译:**
这实际上促成了现在 Foundry 的一个核心部分，他们称之为“本体论”（Ontology）。如果你看过 Palantir 的演示，他们总会提到 Ontology。这其实就是指一套人类可理解的概念，让你不必四处挖掘数据，只需问：“飞机现在在哪，下一步去哪？”Ontology 成为了 Foundry 的重要组成部分，它直接源于我们在工厂构建应用时的经验。我认为这在今天仍然是一个巨大的差异化优势，目前还没有太多其他公司提供这类东西。

---

### (00:37:41) Lenny Rachitsky

**English:**
Wow. I love how excited you still are about this. I could see it being so fulfilling to solve this big problem. I saw a stat that I think, 4X their productivity. What was the number there?

**中文翻译:**
哇。我喜欢你现在谈起这个还这么兴奋的样子。我能想象解决这么大的问题是多么有成就感。我看到一个数据，好像是生产力提高了 4 倍？具体数字是多少？

---

### (00:37:52) Nabeel S. Qureshi

**English:**
Yeah. I don't recall the exact stat, but we did ramp up production, I think at least 4X that 1 year, which I mean obviously, they did this and we just helped with it. But that CEO said that we played a critical part.

**中文翻译:**
是的，我不记得确切数字了，但那一年我们的确将产量提高了至少 4 倍。当然，是他们做到了这一点，我们只是提供了帮助。但那位 CEO 说我们发挥了关键作用。

---

### (00:38:05) Lenny Rachitsky

**English:**
Also, you moved to France, I think for this. That was how forward deployed you were. You lived in France for how long?

**中文翻译:**
而且，你为了这个项目搬到了法国。这就是所谓的“前线部署”。你在法国住了多久？

---

### (00:38:09) Nabeel S. Qureshi

**English:**
Yeah. I lived in France for about a year and a half. The way they built their planes is they manufacture different components around Europe. So they build the tail in Spain and the fuselage in part of the UK and Germany and so forth. So they basically ship everything to France to be assembled at the end, which you can imagine this is a very messy process. So I was mostly in France, but there would be weeks where I'd have to fly between all these countries just to figure out where things were.

**中文翻译:**
是的，我在法国住了大约一年半。他们制造飞机的方式是在欧洲各地生产不同的部件：在西班牙造机尾，在英国和德国造机身等等。最后把所有东西运到法国进行总装。你可以想象这是一个非常混乱的过程。所以我大部分时间在法国，但有时几周内我得在这些国家之间飞来飞去，只为了搞清楚东西都在哪。

---

### (00:38:39) Lenny Rachitsky

**English:**
In your post you wrote about how just the life of forward deployed engineers is pretty crazy. You just get a call sometimes like, "Hey, you're flying to this random country tomorrow. Get ready." Is that just life as a forward deployed engineer?

**中文翻译:**
你在文章中写道，前线部署工程师的生活相当疯狂。有时你会接到电话说：“嘿，你明天要飞去某个国家，准备一下。”这就是前线部署工程师的常态吗？

---

### (00:38:50) Nabeel S. Qureshi

**English:**
It is. Yeah. The company had a very, I would say, aggressive attitude towards travel in the sense of when you join, you were basically told, "Look, you have to be okay with travel. Are you okay with that?" And the attitude, which again I think is a very founder friendly one is you need to be willing to just jump on a plane that night if that's the best thing to do for this customer and if it's going to get us to where it needs to be to win. So there were many times when it would be like, "I need to take this cross continental flight tomorrow for this particular thing because it will be useful."

**中文翻译:**
是的。公司对出差的态度非常“激进”。当你入职时，基本上会被告知：“听着，你必须接受出差。你没问题吧？”这种态度我认为对创始人非常友好：如果为了客户、为了赢，你必须当晚就跳上飞机，那你就要愿意这么做。所以有很多次，我会因为某件有用的事，第二天就得飞越洲际。

---

### (00:39:26) Nabeel S. Qureshi

**English:**
So I think that's one of the takeaways for me was just being in person is so valuable when you are working with some external party, just going there for a few days and spending time with them, maybe going out for dinner. You build so much more trust than if you're trying to close a customer over Zoom or do an engagement over Zoom. It's just the vibe is completely different. So yeah, getting on a plane was a really cool part of our job for a very long time. This obviously changed around 2020 because COVID happened, the company IPO, and so there needed to be a bit more internal controls around this. But I would say pre-2020, this was a very big part of the culture.

**中文翻译:**
所以我的感悟之一是，当你与外部方合作时，面对面交流太有价值了。去那里待几天，和他们相处，一起吃个晚饭。这比通过 Zoom 谈客户或合作建立的信任要多得多。氛围完全不同。所以，在很长一段时间里，坐飞机是我们工作中非常酷的一部分。当然，2020 年左右情况发生了变化，因为疫情爆发，公司也上市了，内部控制变得更严格了。但在 2020 年之前，这是文化中非常重要的一部分。

---

### (00:40:03) Lenny Rachitsky (Sponsor Break - OneSchema)

**English:**
I'm excited to have Andrew Luo joining us today. Andrew is CEO of OneSchema... [Ad content omitted]

**中文翻译:**
很高兴今天邀请到 Andrew Luo。Andrew 是 OneSchema 的 CEO……（赞助商广告内容略）

---

### (00:41:37) Lenny Rachitsky

**English:**
There's a lot of founders listening to this and a question that I'm thinking and they're probably thinking, and there's two questions here. One is how hardcore to go potentially with their own forward deployed operation. And then two is just how and a company I know is actually doing this, how far to go with one company's problem and invest in just like we are going to nail solving this one customer's problem with the hope that this is something we can abstract and sell as a big platform.

**中文翻译:**
有很多创始人在听这期节目，我正在思考，他们可能也在思考两个问题：第一，自己的“前线部署”业务要做到多硬核？第二，我认识的一家公司正在这样做——在解决一个公司的问题上要投入多深？是否应该全力以赴解决这一个客户的问题，并寄希望于将来能将其抽象化并作为一个大平台出售？

---

### (00:42:05) Lenny Rachitsky

**English:**
So let me start there. And you're building a company, any I guess insights or advice on just how far to go down this road of we'll solve customer one's problem and we bet that this is going to be a big opportunity for a lot of other companies?

**中文翻译:**
让我们从这里开始。你也在创业，对于“解决第一个客户的问题，并赌它会成为其他很多公司的巨大机会”这条路，你有什么见解或建议吗？

---

### (00:42:20) Nabeel S. Qureshi

**English:**
So I would say on the forward deployed piece, my friend Barry McCardel, the CEO of Hex, the analytics company, he wrote a really good post about this actually, and his take was just like, "You probably don't need forward deployed engineers." It's very specific. But I think basically the thing there is you have to be willing to be quite almost wasteful. You have to be willing to invest a lot in finding the thing. And for that you just need a certain ticket size. So you need each customer's revenue to be probably in the billions of dollars. If it's below that, you're probably not looking at a traditional forward deployed engineer motion. It's something a little bit different.

**中文翻译:**
关于前线部署，我的朋友、分析公司 Hex 的 CEO Barry McCardel 写过一篇很好的文章。他的观点是：“你可能并不需要前线部署工程师。”这非常具体。但我认为核心在于，你必须愿意承受某种程度的“浪费”，愿意投入大量精力去寻找那个切入点。而这需要一定的订单规模。每个客户的营收规模可能需要达到数十亿美元。如果低于这个水平，你可能就不适合传统的前线部署模式，而需要一些不同的东西。

---

### (00:43:15) Nabeel S. Qureshi

**English:**
So I think one thesis that a lot of people left Palantir with and started companies around was there's a lot of customers that Palantir won't serve because maybe they're too small a ticket size. So actually you could go and do something like Palantir for those companies, but instead of charging them $5 million, you're charging them 250K. So in a scenario like that, you might still have forward deployed engineers, but they're not going to France and spending five days a week in a factory. It's more like you'll have one person and they're looking after five different customer accounts. It's more of that ratio in order to make the numbers work. So I think a lot of the principles can be abstracted from that experience, but it is a really specific sales motion that depends on a specific way of doing business.

**中文翻译:**
很多离开 Palantir 创业的人都有一个论点：有很多客户 Palantir 不会服务，因为订单太小。所以你可以为这些公司做类似 Palantir 的事情，但不是收 500 万美元，而是收 25 万美元。在这种情况下，你可能仍然有前线部署工程师，但他们不会去法国工厂一周待五天。更可能是由一个人负责五个不同的客户账户。为了让财务模型跑通，必须是这种比例。所以很多原则可以从那段经历中抽象出来，但它是一种非常具体的销售动作，取决于具体的业务方式。

---

### (00:43:49) Nabeel S. Qureshi

**English:**
I think to your other question, yeah, I think it's obviously something that is very hard to give a general answer to. My main thing here is just that you can definitely tell when you are just doing consulting and when you are closer to building a product. And I think the error that people make more often than not is they are actually too stuck on their own product vision. That's the mistake I've seen a little bit more actually than the other way around.

**中文翻译:**
至于你的另一个问题，显然很难给出一个通用的答案。我的核心观点是，你一定能分辨出自己是在做咨询还是在构建产品。我认为人们常犯的错误往往是过于执着于自己的产品愿景。实际上，我看到的这种错误比相反的情况更多。

---

### (00:44:15) Nabeel S. Qureshi

**English:**
If you go to an enterprise customer, and let's say you think you're doing analytics software and it turns out they don't actually care about internal analytics this much, they actually have this other massive burning problem and they don't have a good solution to it yet. I think a lot of people are unwilling to go and pivot to the big problem because they're like, "Well, we're analytics software and so maybe this customer is a fit for our thing," and maybe that's the right call. In some scenarios, that is the right call. You should go find a different customer where your thing resonates more.

**中文翻译:**
如果你去找一个企业客户，你以为自己在做分析软件，结果发现他们其实并不那么在乎内部分析，他们其实有另一个迫在眉睫的大问题，而且还没有好的解决方案。我觉得很多人不愿意转向那个大问题，因为他们觉得：“我们是做分析软件的，也许这个客户适合我们的产品。”在某些情况下，这可能是正确的决定，你应该去找一个更能产生共鸣的客户。

---

### (00:44:48) Nabeel S. Qureshi

**English:**
In other scenarios, it's actually the right call to pivot and just put everything on that big problem instead and then go and find other customers for that thing. There's no hard and fast rule. I remember reading a really interesting post by, I think it was David Hsu from Retool who had this exact thing. I think he worked at Palantir for a while too. He said that they had the Retool product and it wasn't getting any traction at all. And then he tried an outbound email campaign where he literally just changed the subject line to build internal tools easily. And then suddenly they started getting all these replies from CTOs who were just like, "Yeah. This is actually a huge pain point for me."

**中文翻译:**
但在其他情况下，正确的做法其实是转型，全力以赴解决那个大问题，然后再为那个解决方案寻找其他客户。这没有死理。我记得读过 Retool 的 David Hsu 写的一篇很有趣的文章，他也有过类似的经历（他好像也在 Palantir 工作过）。他说 Retool 最初完全没有起色，后来他尝试发邮件，只是把主题改成了“轻松构建内部工具”，结果突然收到了大量 CTO 的回复，说：“没错，这确实是我的一个巨大痛点。”

---

### (00:45:28) Nabeel S. Qureshi

**English:**
But the exact same solution, they were previously framing it as, I think it was supercharged Excel or something like that, and nobody was biting. So they just changed the way they framed it and found a different set of buyers and succeeded that way. So yeah, no hard and fast rule, but I think it's always you need to have this matrix of options in your mind and be very deliberate about which one you are going with and why.

**中文翻译:**
同样的解决方案，他们之前把它描述为“加强版 Excel”之类的东西，结果没人理。于是他们改变了描述方式，找到了一群不同的买家，就这样成功了。所以，没有硬性规定，但你脑子里需要有一个选项矩阵，并非常慎重地决定选择哪一个以及为什么。

---

### (00:45:53) Lenny Rachitsky

**English:**
I think your piece of advice is really important there. Usually in your experience, you're saying people index too far too? Like now, what they're asking me to do is not what I think they need or what customers will need. You're saying it's actually more likely they're right, and that's maybe where you should be focusing more versus this abstract vision and original idea you had?

**中文翻译:**
我认为你的建议非常重要。根据你的经验，你是说人们通常过于固执吗？比如觉得“他们要求我做的事情不是我认为他们需要的，也不是其他客户需要的”。你是说，实际上更有可能客户是对的，也许你应该更多地关注那里，而不是你那个抽象的愿景和最初的想法？

---

### (00:46:14) Nabeel S. Qureshi

**English:**
I think so, yeah. I think it's very hard to not be anchored to your own experience and your conceptions as a problem. And one thing I've seen in really strong founders is they're able to drop a bunch of those assumptions and almost treat a new opportunity as a completely blank slate. And then just figure out how to reshape things so that you're taking advantage of that, and that's how you don't get stuck at a local maximum.

**中文翻译:**
我想是的。很难不被自己的经验和对问题的固有观念所束缚。我在非常强大的创始人身上看到的一点是，他们能够抛弃这些假设，几乎把每一个新机会都当作一张白纸。然后思考如何重塑事物以利用这个机会，这样你就不会被困在局部最优解中。

---

### (00:46:37) Lenny Rachitsky

**English:**
Your other piece of advice is also really great. So people hear this and they're like, "We don't afford an engineer to sit at one customer prospects office and build stuff for them." But your point is you can have one for five different customers. They're not there full time. They bounce around, but they're... It's almost like sales engineering, just like what you call it sparkling sales where they help make it successful. I know Looker is a famous example. They think they called them forward deployed engineers. Do you know any other companies by the way, that some version of forward deployed engineers?

**中文翻译:**
你的另一个建议也很棒。人们听到这个可能会想：“我们雇不起一个工程师整天坐在客户办公室里为他们开发东西。”但你的观点是，你可以让一个人负责五个不同的客户。他们不是全职在那儿，而是来回跑。这有点像销售工程（Sales Engineering），或者你所谓的“高级销售”，他们帮助项目获得成功。我知道 Looker 是一个著名的例子，他们好像也叫这个职位为前线部署工程师。顺便问一下，你还知道其他公司有类似的版本吗？

---

### (00:47:07) Nabeel S. Qureshi

**English:**
There's a lot. I mean, I know that the AI Labs are hiring forward deployed engineers now, they're building forward deployed engineering teams and they could make it work, but I think there's going to be key differences. I don't see Anthropic going into an enterprise customer and building some entirely from scratch solution for them. It's going to be something that leverages the Anthropic set of products. So there's a lot of companies that have this label now, but I think what's really confusing about, it's just that it means a few different things. There's another post by Ted Mabrey who's I think the head of commercial at Palantir, and that's a very good one too, to point with those too.

**中文翻译:**
有很多。我知道现在的 AI 实验室（AI Labs）正在招聘前线部署工程师，他们正在组建这种团队，这可能会奏效。但我认为会有关键区别：我不认为 Anthropic 会进入一个企业客户那里，为他们从零开始构建一个全新的解决方案。它更多会是利用 Anthropic 的产品系列。所以现在很多公司都有这个标签，但令人困惑的是，它在不同语境下含义不同。Palantir 的商业负责人 Ted Mabrey 也写过一篇关于这个的文章，非常值得参考。

---

### (00:47:46) Lenny Rachitsky

**English:**
So say someone was, "I want to try this sort of thing in my company," what would be a few bullet points if things they should get right? You're describing the spectrum of what people describe as forward deployed engineers, if they were to try to do this, what do you think they need to most do correctly for it to be successful?

**中文翻译:**
如果有人说“我想在我的公司尝试这种模式”，那么为了成功，他们最需要做对哪几点？你描述了人们对前线部署工程师定义的光谱，如果他们要尝试，你认为成功的关键是什么？

---

### (00:48:04) Nabeel S. Qureshi

**English:**
The key things that made our model work well, one, they were actually real engineers who could build product themselves. That's a very big difference. I think a lot of the time companies will say, "This person's a forward deployed engineer," but actually they're mostly there to be more of a solutions architect, or they're not necessarily building anything to know, but they're just listening and trying to find a way of deploying the existing product. They're not empowered to do new product. So the really radical thing Palantir said was, "No. Go in and if you need a completely new product to do this, you can go ahead and build it." And I think that's really the key difference.

**中文翻译:**
让我们的模式行之有效的关键点：第一，他们必须是真正的工程师，能够亲自动手构建产品。这是一个巨大的区别。很多时候公司说“这个人是前线部署工程师”，但实际上他们更像是解决方案架构师，并不一定亲自动手构建新东西，只是倾听并尝试部署现有产品。他们没有被授权开发新产品。而 Palantir 最激进的一点是：“去吧，如果为了解决问题需要一个全新的产品，你就去把它造出来。”我认为这才是核心区别。

---

### (00:48:44) Nabeel S. Qureshi

**English:**
The other stuff I've already mentioned, the value of being in person, and I think building close personal bonds with your customers. I do think the better founders do this anyway. They're on texting terms with their buyers, they become friends with them outside of work, and they see them as humans who they're trying to help. I think this is very motivating, gaining a really deep understanding of the business that your customers are in and knowing how those dynamics work.

**中文翻译:**
其他我已经提到的点包括：面对面的价值，以及与客户建立紧密的个人联系。我认为优秀的创始人本来就会这么做。他们和买家互发短信，在工作之外成为朋友，把他们看作是自己想要帮助的人。我认为这非常能激励人心——深入了解客户所在的行业，了解其中的运作逻辑。

---

### (00:49:15) Nabeel S. Qureshi

**English:**
So a simple example might be, say hospitals in America. It's very counterintuitive to think of a hospital as a business. People think of it as it's a place where you get healthcare, but actually if you view it the way a COO or CMO views it, it's going to look very, very different too. As a very simple example, sorry, this is a little bit dark, but how restaurants want to turn over tables as fast as possible in order to maximize for the day? Hospitals actually want to do the same with patients. They would like to treat you and then get you out of a bed so they can free up the bed to get a new person in there. So that's not super intuitive, unless you think hard about how the revenue for that hospital works. But then once you think about it, you're like, "This has a bunch of problems associated with it." And you start to go into really interesting...

**中文翻译:**
举个简单的例子，比如美国的医院。把医院看作一家企业是非常反直觉的。人们认为它是提供医疗服务的地方，但如果你从 COO 或 CMO 的角度来看，情况会完全不同。举个有点阴暗的例子：就像餐厅希望尽可能快地翻台以实现利润最大化一样，医院其实也希望对病人做同样的事。他们希望治好你，然后让你腾出床位，以便让新病人进来。除非你深入思考医院的收入模式，否则这并不直观。但一旦你开始思考，你就会发现：“这带来了一系列相关问题。”然后你就会进入非常有趣的领域……

---

### (00:50:00) Lenny Rachitsky

**English:**
... problems associated with it, and you start to go in really interesting directions. There's just like the words and memes, and take you a long way working and understanding it.

**中文翻译:**
……相关的问题，然后你开始走向非常有趣的方向。仅仅是理解这些行业术语和潜规则，就能让你在工作和理解上走得很远。

---

### (00:50:05) Nabeel S. Qureshi

**English:**
Yes.

**中文翻译:**
是的。

---

### (00:50:10) Lenny Rachitsky

**English:**
Okay, so essentially the things you want to get right, make sure it's in person, make sure the person is technical, make sure they have a deep understanding of the business and the problems they're having. The technical piece is interesting with AI tools these days, making everyone technical in some sense. You could argue this is going to become more common, people can just open up Cursor, Windsurf and just start adding features.

**中文翻译:**
好，所以本质上你要做对的事情是：确保面对面，确保人员懂技术，确保他们对业务和面临的问题有深刻理解。技术部分很有趣，现在的 AI 工具在某种意义上让每个人都变得“懂技术”了。你可以说这会变得越来越普遍，人们可以直接打开 Cursor 或 Windsurf 开始添加功能。

---

### (00:50:30) Nabeel S. Qureshi

**English:**
I think this is a really interesting thesis you've just hit on, and I expect to see a lot more startups that take advantage of that insight.

**中文翻译:**
我认为你刚才提到的这个论点非常有趣，我期待看到更多利用这一洞察力的初创公司。

---

### (00:50:38) Lenny Rachitsky

**English:**
Basically it makes forward deploying engineers cheaper.

**中文翻译:**
基本上，这让前线部署工程师的成本降低了。

---

### (00:50:40) Nabeel S. Qureshi

**English:**
Exactly.

**中文翻译:**
没错。

---

### (00:50:42) Lenny Rachitsky

**English:**
What is the current state of forward deploying engineers at Palantir? How much has it changed over the past few years? If you join now, is this still something you can do?

**中文翻译:**
Palantir 的前线部署工程师现状如何？过去几年发生了多大变化？如果现在加入，还能做这个吗？

---

### (00:50:49) Nabeel S. Qureshi

**English:**
Yeah, of course. I should obviously emphasize that one, I left the company in 2023, and so this is just my personal view, I don't speak for them. I think that if you think about it, one of the metrics that the company had to measure its own success was essentially revenue per engineer, and so the more "product leverage" you had, the higher that number was.

**中文翻译:**
当然可以。我必须强调，我是在 2023 年离开公司的，所以这只是我的个人观点，不代表公司。如果你仔细想想，公司衡量自身成功的一个指标本质上是“人均工程师营收”。你的“产品杠杆”越高，这个数字就越高。

---

### (00:51:15) Nabeel S. Qureshi

**English:**
So if you had to throw a lot of people at every marginal problem, then you weren't doing so well at that because you're basically building a new thing every single time, and you are in effect a consulting business. If on the other hand, every time you encounter a new customer, the product turns out to be relevant to them, then great, and so this product leverage metric was actually a very unique thing and kind of a North Star for the company for the whole time I was there.

**中文翻译:**
如果你必须为每一个细小的问题投入大量人力，那么你的表现就不够好，因为你每次都在构建新东西，实际上成了咨询公司。反之，如果每次遇到新客户，产品都被证明对他们有用，那就太棒了。这种“产品杠杆”指标在我在职期间一直是公司非常独特且重要的北极星指标。

---

### (00:51:37) Nabeel S. Qureshi

**English:**
If you reason that out, what that means is that in the early stage of the company, you will have a customer and then you might have five to 10 engineers working at that customer. And so over time you want that ratio to change. So you want it to be each customer, because the product is so powerful, maybe AI coding's gotten a lot better, each customer you only need two people, and then maybe you actually get to a point where you can have one person looking after multiple customers.

**中文翻译:**
推导一下这意味着：在公司早期，一个客户可能需要 5 到 10 名工程师。随着时间的推移，你希望这个比例发生变化。你希望因为产品足够强大，或者 AI 编程变得更好，每个客户只需要两个人，甚至最终达到一个人可以负责多个客户的程度。

---

### (00:52:05) Nabeel S. Qureshi

**English:**
And I think that's how the job has changed, is now it's a little bit more about you have multiple customers, maybe you're spending less deep time with each individual one of them, but it's a lot clearer what problem you're solving across multiple customers and you have more of a kind of defined offering. And so I do think that has been a bit of a change, but the company remains a very interesting and dynamic place to be.

**中文翻译:**
我认为这就是工作的变化：现在更多是一个人负责多个客户，也许在每个客户身上投入的深度时间变少了，但你在多个客户之间解决的问题变得更加清晰，产品也更加标准化。所以我认为确实有一些变化，但公司仍然是一个非常有趣且充满活力的地方。

---

### (00:52:21) Nabeel S. Qureshi

**English:**
In some sense the story's only starting, because one lens through which you can view this company is they spent 20 years basically building the mother of all data foundations for every important institution in the world, and I guess what's very valuable now that AI models are out is proprietary data that isn't public. Suddenly you have access to that and you are in a very privileged position to help your customers deploy AI in a way that makes them successful, and that solves real business problems. That is essentially the bull thesis for this company and why it's probably going to 100X again. And so it's still a really interesting time to join but I do think the nature of the ratio of people to a customer, for example, is one big difference now.

**中文翻译:**
从某种意义上说，故事才刚刚开始。你可以这样看这家公司：他们花了 20 年时间，为世界上每一个重要机构构建了最强大的数据基础。在 AI 模型问世的今天，最宝贵的是非公开的私有数据。突然之间，你拥有了这些数据的访问权限，并处于一个非常有利的位置，可以帮助客户以成功的方式部署 AI，解决实际业务问题。这本质上是这家公司的看涨逻辑，也是它可能再次增长 100 倍的原因。所以现在加入仍然是一个非常有趣的时刻，但我认为现在人与客户的比例确实是一个很大的不同点。

---

### (00:53:16) Lenny Rachitsky

**English:**
Not investment advice, but it might 100X. I totally understand why that might happen. So let's talk about the data piece, you said that this was one of the secrets of Palantir's success, this early insight into the power of ingesting data, cleaning data, being able to analyze and work with it. What a marketing share there, just what they figured out about why this is so valuable, why it's so hard and how they achieved it?

**中文翻译:**
这不是投资建议，但它确实可能再涨 100 倍。我完全理解为什么会这样。让我们聊聊数据部分，你说这是 Palantir 成功的秘诀之一——早期就洞察到摄取数据、清理数据、分析和处理数据的力量。他们到底发现了什么？为什么这如此有价值、如此困难，以及他们是如何实现的？

---

### (00:53:40) Nabeel S. Qureshi

**English:**
I think it's just very obvious as soon as you step into a corporation and spend a couple of days there really, is you're like, all right, let's suppose your job is to increase sales, so the first thing you want to do is get a clear picture of what's going on. All right, so let me go and query the sales database. Oh wait, where's the sales database? I can't get access to this. Okay, I need to file an access ticket. All right, now I have to wait one week. And so everywhere we went, this was the big pain point, was we have to wait six to eight weeks just to get data access, and then when you do get data access, it's not like the data's in an easily queryable format, you actually really have to know what you're doing in order to get the right metrics out, and so on and so forth.

**中文翻译:**
我觉得只要你进入一家大公司待上几天，这就变得显而易见了。假设你的工作是增加销售额，你首先想看清楚现状。好，我去查询销售数据库。哦等等，销售数据库在哪？我没权限。好，我得提交权限申请。好，现在得等一周。我们所到之处，这都是巨大的痛点：为了获得数据访问权限，我们得等六到八周。即使拿到了权限，数据也不是那种容易查询的格式，你必须非常专业才能提取出正确的指标，诸如此类。

---

### (00:54:21) Nabeel S. Qureshi

**English:**
And so it turned out like, okay, it's this iceberg analogy where the actual analysis is actually just the tip of the iceberg, it's kind of the last five or 10%, and the 95% before that is, I am gaining access to the data, I am cleaning the data, I'm joining the data, I'm normalizing it, putting it all in the same format. And so once we spotted that, then it's like, okay, there's actually a lot of product to be built there just to make that process easier.

**中文翻译:**
所以结果就像冰山比喻：实际的分析只是冰山一角，大约只占最后 5% 到 10%。而之前的 95% 都是：获取数据访问权限、清理数据、连接数据、标准化数据、将它们统一格式。一旦我们发现了这一点，我们就意识到：为了让这个过程变得更简单，其实有很多产品可以做。

---

### (00:55:00) Nabeel S. Qureshi

**English:**
People don't think of Palantir as this place where innovative new product and UX ideas come out, but I actually think it's been one of the most generative companies for that specifically in the last 20 years, it's just that most of that didn't see the light of day and so people don't know. But if you look at the product primitives that they developed in order to make the things I just mentioned a lot easier, they're actually really valuable and interesting and could probably form the basis of independent companies themselves.

**中文翻译:**
人们通常不认为 Palantir 是一个产生创新产品和 UX 创意的地方，但我认为在过去 20 年里，它其实是这方面产出最丰硕的公司之一。只是大部分成果没有公开，所以人们不知道。但如果你看看他们为了简化我刚才提到的那些事情而开发的“产品原语”（Product primitives），它们其实非常有价值且有趣，甚至可以作为独立公司的基础。

---

### (00:55:21) Nabeel S. Qureshi

**English:**
And so, yeah, it just took every single step of that process became much, much easier once there was a software solution around it. So if you talk about data ingestion, there's essentially a universal data adapter that's part of Foundry. It can read anything, so JDBC, S3 buckets, whatever you want. It allows us to look into the data, maybe preview the first 20 rows, and then it allows you when you're ready to set up a schedule and just pull it in on some cadence. That process alone for an engineer used to take a long time, especially pre-AI coding, and managing all those cron jobs and doing this analytics, VM somewhere inside the customer's tenant was a huge pain.

**中文翻译:**
是的，一旦有了软件解决方案，过程中的每一步都变得简单得多。谈到数据摄取，Foundry 中有一个通用的数据适配器。它可以读取任何内容：JDBC、S3 存储桶等等。它允许我们查看数据，预览前 20 行，然后设置计划按节奏拉取。仅这一过程，以前对工程师来说就要花很长时间，特别是在 AI 编程出现之前，管理那些定时任务（Cron jobs）并在客户租户内的虚拟机上进行分析是非常痛苦的。

---

### (00:56:04) Nabeel S. Qureshi

**English:**
And so you productize that piece, then it's like, okay, once you have the data, it's like how do you actually join it? What if you're non-technical? Is there a way for a non-technical user to be able to join tables and see what the result is? And so there's all these very fascinating business problems that, because I think the access was very difficult to get, and people hadn't really solved before, and so there was a lot of white space to do some product innovation.

**中文翻译:**
当你把那部分产品化后，接下来的问题是：有了数据，如何连接它们？如果你不懂技术怎么办？有没有一种方法让非技术用户也能连接表格并查看结果？因为以前获取权限很难，没人真正解决过这些迷人的业务问题，所以有很多产品创新的空白地带。

---

### (00:56:30) Nabeel S. Qureshi

**English:**
So now I would say Foundry's definitely the best data platform in the world just because it has all these different applications within it that solve these discrete parts. And it came out of this, years of painful experience, watching people have to clean data and join it and figure out what this table name meant and so on and so forth.

**中文翻译:**
所以现在我会说 Foundry 绝对是世界上最好的数据平台，因为它内部拥有解决这些离散环节的所有不同应用。它源于多年痛苦的经验——看着人们不得不清理数据、连接数据、弄清楚表名的含义等等。

---

### (00:56:50) Lenny Rachitsky

**English:**
You shared in your post this kind of evocative story of some people's jobs is just to gate keep the data. They're there to give you access to this very valuable data within the organization, and how hard it is to get. That was a lot of this work, is just breaking through those political battles of like, "Okay, we need this data for the good of the company and took a lot of work." I guess anything there you want to add?

**中文翻译:**
你在文章中分享了一个发人深省的故事：有些人的工作就是“把守数据”。他们的存在就是为了控制对组织内极具价值的数据的访问，而获取这些数据非常困难。这项工作很大一部分就是突破这些政治斗争，比如：“为了公司的利益，我们需要这些数据”，这需要做大量工作。关于这一点你还有什么想补充的吗？

---

### (00:57:12) Nabeel S. Qureshi

**English:**
It is, yeah. It's a huge pain, and there are good reasons for it. It's not like folks are malicious here. If you're IT or if you're an InfoSec type person, then your goal is to prevent data breaches and to make sure that sensitive information doesn't spread too wide. And so what's the easiest way to do that? It's to lock the data down, basically be a gatekeeper for access. I think where it got a little bit more interesting was where your skills are valuable and depend on you being the gatekeeper.

**中文翻译:**
是的，这非常痛苦，但也有其合理的原因。并不是说这些人怀有恶意。如果你是 IT 或信息安全人员，你的目标是防止数据泄露，确保敏感信息不会扩散。那么最简单的方法是什么？就是锁死数据，做访问权限的守门人。我认为更有趣的地方在于，当你的价值取决于你作为“守门人”的身份时。

---

### (00:58:05) Nabeel S. Qureshi

**English:**
So what I mean by that is let's say I'm the only guy who understands the way the sales calculation pipeline works and I write the SQL for it. All the requests from business SMEs come to me, I have a big queue of them, it takes me weeks to get through this queue. I have a great job, I have great job security, and people depend on me. And so now along comes this company and they're like, "Hey, actually we want to make sales data available to everyone and we want to make it point and click." Suddenly you're like, "Hey, hang on, what am I going to do?"

**中文翻译:**
我的意思是，假设我是唯一理解销售计算管道运作方式并编写 SQL 的人。所有业务专家的请求都发给我，我手头有一大堆任务，需要几周才能处理完。我有一份很好的工作，职业保障很高，大家都依赖我。现在突然来了一家公司说：“嘿，其实我们想让每个人都能访问销售数据，而且是点击式的。”突然间你会想：“嘿，等等，那我该怎么办？”

---

### (00:58:35) Nabeel S. Qureshi

**English:**
And so that's where I think there was a lot of difficulty and I always say people are like, what accounts as competitors? I don't think it's the ones that you would think of necessarily. Palantir's biggest competitor is a company rolling its own solution, and so the biggest difference would just be a CIO saying, "I'm going to build my own data infrastructure, I'm going to own it, it's going to be on top of one of the hyperscalers, and we're all just going to do our own analytics ourselves." And what we came along with, which was quite disruptive to this model, was saying, "No, actually all your data is going to get ingested into this one platform and everybody in your company is going to use it." The trade-off is it's going to be really, really easy for everyone to do things. But as you can imagine, some people weren't a huge fan of that model.

**中文翻译:**
这就是困难所在。我常说，人们问谁是竞争对手，我觉得不一定是你想到的那些。Palantir 最大的竞争对手是那些“自研解决方案”的公司。最大的区别在于，一位 CIO 可能会说：“我要构建自己的数据基础设施，我要拥有它，它将建立在某个云巨头之上，我们自己做分析。”而我们带来的模式对这种想法极具颠覆性，我们说：“不，实际上你所有的数据都将摄取到这一个平台中，公司里的每个人都会使用它。”代价是每个人做起事来都会变得非常非常容易。但你可以想象，有些人并不喜欢这种模式。

---

### (00:59:01) Lenny Rachitsky

**English:**
It feels like Glean is the biggest competitor to Palantir after I hear this, do you know about that company?

**中文翻译:**
听完这些，我觉得 Glean 似乎是 Palantir 最大的竞争对手，你知道那家公司吗？

---

### (00:59:06) Nabeel S. Qureshi

**English:**
I do, yeah, Glean looks amazing from the outside. So many differences there, I can totally see why you would say this, but-

**中文翻译:**
我知道，Glean 从外部看非常出色。虽然有很多不同，但我完全理解你为什么这么说，但是——

---

### (00:59:15) Lenny Rachitsky

**English:**
Clearly a different use case but it feels like the reason they've been successful is they figured out a lot of this data ingestion, permissions, search stuff. I never thought of it that way.

**中文翻译:**
显然用例不同，但感觉他们成功的原因是解决了大量数据摄取、权限和搜索方面的问题。我以前从未从这个角度思考过。

---

### (00:59:24) Nabeel S. Qureshi

**English:**
Yeah.

**中文翻译:**
是的。

---

### (00:59:24) Lenny Rachitsky

**English:**
Interesting. Okay, I want to talk about hiring, you talked a bit about this. You're starting a company again, what are some of the key lessons you've learned from your time at Palantir when you are hiring people for your company? I don't know if you're actually hiring people yet, maybe when you may start hiring.

**中文翻译:**
很有趣。好，我想聊聊招聘，你刚才提到了一点。你又要创业了，在为公司招人时，你从 Palantir 的经历中学到了哪些关键教训？我不知道你现在是否已经开始招人了，或者什么时候开始。

---

### (00:59:42) Nabeel S. Qureshi

**English:**
Yeah, we have six people at the moment, so a really reasonably small team. I think with hiring, it's funny, man, there's so much hiring advice online and you read it and you're like, "Yeah, this is super obvious." And then when you live it, you're suddenly like, "Aah, this is why people say this." So a few simple examples are I think the thing that is really hard to find is somebody who really, really has a lot about doing the thing and will go that kind of extra 20%.

**中文翻译:**
是的，我们目前有六个人，是一个非常小的团队。关于招聘，很有意思，网上有太多的招聘建议，你读的时候觉得“这太显而易见了”。但当你亲历其中，你会突然感叹：“啊，原来这就是为什么大家这么说。”举几个简单的例子：我认为最难找到的是那种真正热爱这件事，并且愿意多付出 20% 努力的人。

---

### (01:00:17) Nabeel S. Qureshi

**English:**
I think when you hire out, especially not to pick on them, but I think if you hired a [inaudible 01:00:17] right, it's like people want a 400K a year job, they would like to work a certain number of hours, they would like to ship some code and then go home, that's basically the model that you get accustomed to even if you don't intend to when you work at a big company. And so if you hire out of that for a really small startup, it can be really challenging because a lot of your success as a startup depends on each individual person being like, "No, I'm really going to, I'm work this evening if that's what it takes to get this thing working, and I'm not just going to check my boxes, I'm actually going to look towards what is the real outcome that this business is trying to achieve."

**中文翻译:**
当你从大公司招人时（不是针对他们），人们往往想要一份年薪 40 万美元的工作，想工作固定的时长，写完代码就回家。即使你不是故意的，在大公司工作久了也会习惯这种模式。如果你为一家极小的初创公司招这样的人，挑战会很大。因为初创公司的成功取决于每个人都能想：“不，如果为了让这个东西跑通，我今晚真的要加班”，而不是仅仅完成任务，而是关注业务真正想要达成的结果。

---

### (01:01:18) Nabeel S. Qureshi

**English:**
And everything I'm saying feels kind of obvious, but when you actually feel that difference between somebody who's just checking the boxes and somebody who's kind of an animal in this way, they'll actually go and pursue and accomplish the end outcome, that difference is very, very big and it matters so much for your first 20 people. And there's no science to finding these people. It's not like you can just put somebody who cares about outcomes in your JD and then suddenly you'll get all these people applying.

**中文翻译:**
我说的这些听起来很显而易见，但当你真正感受到“按部就班的人”和“像野兽一样追求结果的人”之间的区别时，你会发现这种差异巨大，对于前 20 名员工来说至关重要。寻找这样的人并没有什么科学方法。你不能只是在职位描述（JD）里写上“关注结果的人”，然后就指望这种人会来应聘。

---

### (01:01:45) Nabeel S. Qureshi

**English:**
So then it's like, okay, well how do you screen for that and how do you find those types of people? And so that's where it gets really interesting. I think that's where the mission alignment comes in, and so you do have to find people who, for what you are doing, have this extra maybe private reason to care about it a little bit more than the average person. So I think for Palantir, they did hire a lot of vets, for example, or maybe people who were a little bit more patriotic or pro-America than the average tech employee, and those people had an extra reason to Palantir and an extra reason to try that little bit harder.

**中文翻译:**
所以问题变成了：你如何筛选并找到这样的人？这就是有趣的地方。我认为这就是“使命一致性”发挥作用的地方。你必须找到那些因为某些私人原因，比普通人更在乎你所做事业的人。比如 Palantir 招了很多退伍军人，或者比普通科技员工更爱国、更支持美国的人，这些人有额外的理由留在 Palantir，也有额外的动力去加倍努力。

---

### (01:02:15) Nabeel S. Qureshi

**English:**
And so what I'm doing is a little bit more in the kind of medical and health space, and so I think people who have themselves had experiences with this system have maybe had relatives go through difficult experiences with things like cancer or whatever it is. They're just that extra bit motivated to really care about the thing you're trying to do and then work that little bit harder, and so I think aggressively filtering early on to things like mission fit, how much have you cared about stuff in the past, and what's an example. You ask questions like, what's the hardest you've ever worked to get something done and why? And that does differentiate a lot of people, a lot of people don't actually have a great answer to that.

**中文翻译:**
我现在做的事情更偏向医疗和健康领域。我认为那些亲自体验过这个系统，或者亲属经历过癌症等痛苦折磨的人，会更有动力去关注我们正在做的事，并愿意为此付出更多。所以我认为早期要严格筛选使命契合度，看他们过去对事物的投入程度。你可以问：“为了完成某件事，你付出的最大努力是什么？为什么？”这能区分很多人，因为很多人其实给不出一个好的答案。

---

### (01:02:47) Lenny Rachitsky

**English:**
That is really interesting, everything you've shared is essentially around motivation, and drive, and passion, and kind of just commitment to working on this intently, and it's almost like a second thought of just like, oh, also they're really smart and skilled at stuff. It feels like that's just table stakes and this is actually what makes the difference in your experience.

**中文翻译:**
这非常有趣。你分享的一切本质上都围绕着动机、驱动力、激情以及对工作的专注投入。至于“他们是否聪明、是否有技能”，似乎成了次要的考虑。感觉在你的经验中，技能只是入场券，而这些特质才是决定性的差异。

---

### (01:03:08) Nabeel S. Qureshi

**English:**
Yeah, I totally agree, and I think it's different for every business. So I think if you're in a space like B2B SaaS where maybe it's a little harder to tell the story of like, oh, this is so mission-critical, whatever, there are other ways of getting at this thing. So for example, I know a lot of people, again, it's a little played out now, but I know a lot of people who for sales teams, they will explicitly go for people who were professional athletes or played sports in college, and it's like, okay, what does that test for? It's like you are very, very disciplined, you're very, very goals and numbers oriented and you're willing to just work really, really hard.

**中文翻译:**
是的，我完全同意。而且我认为每个行业都不同。如果你在 B2B SaaS 领域，可能很难讲出“这关乎使命”的故事，但有其他方法可以挖掘这种特质。例如，我知道很多人（虽然现在有点陈词滥调了）在招销售团队时，会专门找职业运动员或大学校队成员。这测试的是什么？是极强的纪律性、极强的目标和数字导向，以及愿意付出极大的努力。

---

### (01:03:45) Nabeel S. Qureshi

**English:**
And so there's all these kind of lateral ways of getting at these qualities that I think you just have to be intentional about as a founder. As a personal example, I'm a runner and so I actually love meeting fellow runners and I kind of joke like, "Oh, maybe I'll go higher from run clubs or something like that." But it's just same with I play a lot of chess, I love meeting chess players. I'm not necessarily saying that's the right kind of hire for me, but I think having this thing of here are some traits that seem uncorrelated, but which actually give you good signal to this person's personality, those are actually really important.

**中文翻译:**
所以有很多侧面的方法可以挖掘这些品质，作为创始人你必须有意识地去做。举个个人例子，我是一名跑者，所以我喜欢结识跑友，我甚至开玩笑说：“也许我会去跑团招人。”同样，我下很多象棋，我喜欢结识棋友。我不是说这一定是正确的招聘方式，但寻找一些看似不相关但能反映性格信号的特质是非常重要的。

---

### (01:04:25) Nabeel S. Qureshi

**English:**
The last thing I'll say just as a funny illustration of that concept is I think Max Levchin tells the story of somebody interviewing at PayPal early on and he passed all the skill interviews and then it just got to the final round and he said something about liking to shoot hoops, like he liked to play basketball, and they were like instant reject. The vibe here was like if you're not a mega Linux nerd, hardcore computer person, then we don't want you here, even if you actually passed all the tests just because you like to shoot hoops. Now whether that was the right call or the wrong call, don't know, but that's an example of what I'm talking about.

**中文翻译:**
最后说一个有趣的例子：Max Levchin 讲过一个 PayPal 早期的面试故事。那个人通过了所有的技术面试，到了最后一轮，他提到自己喜欢打篮球，结果被秒拒。当时的氛围是：如果你不是一个超级 Linux 宅、硬核计算机狂人，我们就不想要你，哪怕你通过了所有测试，仅仅因为你喜欢打篮球。虽然不知道这决定对不对，但这就是我所说的例子。

---

### (01:04:54) Lenny Rachitsky

**English:**
I think that's a great echo back. People hearing this may be like, "What the hell? How dare they do that?" But this is exactly what you said at the beginning of our conversation, that like an approach to building a generational business is to be very clear about who this is not for, and that's okay, it's your company, not everyone needs to work there. And it's almost saving them time because they might realize this isn't for me, this isn't the people I want to be around necessarily. So I think it's important to see that side of it, is it's your business, it's important to be clear about who is a good fit for the company and who's not.

**中文翻译:**
我觉得这是一个很好的呼应。听众可能会想：“搞什么？他们怎么敢这么做？”但这正是你对话开始时说的：建立一家跨时代企业的途径之一，就是非常明确“谁不适合这里”。这没问题，这是你的公司，不是每个人都必须在那儿工作。这甚至是在节省大家的时间，因为他们可能会意识到“这不适合我，这些人不是我想相处的”。所以看清这一面很重要：这是你的事业，明确谁适合、谁不适合是非常重要的。

---

### (01:05:30) Lenny Rachitsky

**English:**
Speaking of that, let's talk about product management for a bit. I know Palantir PMs are not traditional product managers. I imagine people have the title, Product Manager at Palantir, okay, so if so, as far as you understand what's the difference between say a PM at Palantir versus a traditional PM say at a FANG company?

**中文翻译:**
说到这，让我们聊聊产品管理。我知道 Palantir 的 PM 不是传统意义上的产品经理。我猜 Palantir 内部确实有人挂着“产品经理”的头衔，那么据你了解，Palantir 的 PM 与 FANG（大厂）公司的传统 PM 有什么区别？

---

### (01:05:51) Nabeel S. Qureshi

**English:**
Palantir was, as far as I remember, quite anti-PM for a while and eventually we did need them because we just got more serious about product testing.

**中文翻译:**
据我所知，Palantir 在很长一段时间里是非常“反 PM”的，但最终我们确实需要他们，因为我们开始更认真地对待产品测试。

---

### (01:05:57) Lenny Rachitsky

**English:**
Classic story, classic story.

**中文翻译:**
经典的故事，经典的发展。

---

### (01:05:59) Nabeel S. Qureshi

**English:**
A classic story.

**中文翻译:**
确实经典。

---

### (01:06:00) Lenny Rachitsky

**English:**
In many companies,

**中文翻译:**
在很多公司都发生过。

---

### (01:06:01) Nabeel S. Qureshi

**English:**
The big difference or one big difference I noticed was that they were extremely careful about only making people PMs who had first proven themselves out as forward deploying engineers. You basically could not become a PM any other way. So as an example, when I mentioned earlier the thing that we built for the plane factory, the person who was managing that deployment, she later became the PM for ontology, and it was just because she'd kind of proven her method in the field.

**中文翻译:**
我注意到的一个巨大区别是，他们非常谨慎，只让那些先作为前线部署工程师证明了自己的人担任 PM。基本上没有其他途径可以成为 PM。举个例子，我之前提到的为飞机工厂构建系统的项目，当时负责那个部署的人，后来成为了 Ontology 的 PM，就是因为她在现场证明了自己的方法论。

---

### (01:06:35) Nabeel S. Qureshi

**English:**
And the reason for that's pretty simple, it's going to be someone who understand how customers work and has that customer empathy, and it's going to be someone who has this drive to get things done because that's what BD selected for. I think the failure mode that they were very, very averse to in traditional PMs was this kind of Google Docs syndrome of like, okay, I'm going to write my product requirement documents, and I'm going to manage it in this very sort of sane, rational way I think, so the company was really rigorous about that.

**中文翻译:**
原因很简单：这样的人理解客户如何运作，具备客户同理心，并且有把事情办成的驱动力，因为这正是 BD 部门选人的标准。我认为他们非常反感传统 PM 的一种失败模式，即所谓的“Google Docs 综合征”：写一堆产品需求文档（PRD），然后以一种自认为非常理智、合理的方式进行管理。公司对此非常严苛。

---

### (01:07:04) Nabeel S. Qureshi

**English:**
And so basically PMs were almost always internal promotions and they always came from BD. I am not aware of a single case where we took somebody who was a PM at a place like Google, which produces many excellent PMs and hired them successfully into Palantir, it's just a very different vibe. So I think that was one thing. This is maybe more of a classic PM trait, but you just had to be either an engineer yourself or extremely good at working with engineers, and the ones I saw who succeeded the most were just best friends with their engineering team.

**中文翻译:**
所以基本上 PM 几乎都是内部晋升，且都来自 BD 部门。我不知道有任何一个案例是从 Google 这种培养了许多优秀 PM 的地方挖人并成功融入 Palantir 的，氛围完全不同。这是其一。其二，这可能更像传统 PM 的特质，但你必须要么自己是工程师，要么极其擅长与工程师合作。我看到的最成功的 PM 都是工程团队最好的朋友。

---

### (01:07:40) Nabeel S. Qureshi

**English:**
And the team would always just be like one, it was called the group pm and then it would be a lot of very, very good engineers. And basically the success or failure mode was just do the engineers and trust you? I mentioned before Palantir how is very almost disagreeable personalities, and so if you didn't gain the trust of engineering team pretty fast, you didn't last very long.

**中文翻译:**
团队通常由一名 Group PM 和许多非常优秀的工程师组成。成功的关键在于：工程师信任你吗？我之前提到过 Palantir 的人性格往往比较“不讨喜”（disagreeable），所以如果你不能迅速赢得工程团队的信任，你就待不长。

---

### (01:07:58) Lenny Rachitsky

**English:**
I think we've cracked the question of why are Palantir PM's so successful? First of all, the hiring bar is just basically hiring for leaders in a lot of different ways, to this, I don't know, forge for founders where they're working with a company solving a real problem, building a real product that makes money, and then those are the people that become the PMs at Palantir and then they go on to leave and that's why 30% of them end up starting companies, I'm surprised it's not higher, or become first PMs at other companies or heads of product.

**中文翻译:**
我想我们已经解开了“为什么 Palantir 的 PM 如此成功”的谜题。首先，招聘门槛本质上是在招募各方面的领导者；其次，这里是一个创始人的“熔炉”，他们在现场解决实际问题，构建能赚钱的真实产品。这些人随后成为 Palantir 的 PM，离职后，30% 的人选择了创业（我甚至惊讶于这个比例没更高），或者成为其他公司的首位 PM 或产品负责人。

---

### (01:08:29) Nabeel S. Qureshi

**English:**
Yeah, absolutely, it's crazy. I was part of a pretty small team within Palantir, I think it was 20 to 25 people when I joined, and I think at least six of them now are either unicorn or just pre-unicorn founders from that group of 25 people, which is actually a crazy ratio. And then a bunch more have become founders recently at an earlier stage, so yeah, there's all these little pockets of excellence and it's been really interesting to see.

**中文翻译:**
是的，绝对如此，这很疯狂。我加入 Palantir 时所在的团队很小，大约 20 到 25 人。在那 25 人中，现在至少有 6 人是独角兽或准独角兽公司的创始人，这个比例简直惊人。还有更多人最近开始了早期创业。所以，那里有很多卓越的小圈子，观察这些非常有趣。

---

### (01:08:55) Nabeel S. Qureshi

**English:**
I think the other thing that's driving that a little bit is when you leave, it's just such an interesting company to work at that I think the retention numbers were actually very high for that company. People would often stay a lot longer than maybe the average Valley tenure. And so when you left, it was really this decision of just something very specific is pulling you and you want to kind of play the next level of the game, and so it was very unusual for someone to leave and then join maybe a more traditional tech company. It's sort of like you're either going to go become a founder or why would you leave when there's so many interesting different things to work on? And I know that sounds a little culty, but that's what everyone thinks.

**中文翻译:**
我认为另一个驱动因素是，Palantir 是一家非常有意思的公司，员工留存率其实很高。人们待的时间通常比硅谷平均水平长得多。所以当你离开时，通常是因为有非常具体的事情在吸引你，你想去玩更高阶的游戏。因此，很少有人离职后去一家传统的科技公司。要么去创业，要么就留下来，因为这里有那么多有趣的事情可以做，为什么要走呢？我知道这听起来有点像“邪教”，但大家确实是这么想的。

---

### (01:09:35) Lenny Rachitsky

**English:**
I could totally see that. A lot of people that left Airbnb have never found something more meaningful, it's just hard, especially if you're early. There's a stat that I didn't share that I think is really interesting, and when you look at YC founders and where they've come from, I think you maybe shared in your post that there's more YC ex-Palantir founders than there are ex-Google founders in spite of Google being something like 50 times bigger sample size.

**中文翻译:**
我完全能理解。很多离开 Airbnb 的人也觉得很难再找到更有意义的工作，特别是如果你是早期员工。我还有一个没分享的数据很有趣：看看 YC 的创始人来源，你在文章里也提过，YC 中来自 Palantir 的创始人比来自 Google 的还要多，尽管 Google 的人员基数大约是 Palantir 的 50 倍。

---

### (01:10:00) Nabeel S. Qureshi

**English:**
Yeah, yeah.

**中文翻译:**
是的，没错。

---

### (01:10:02) Lenny Rachitsky

**English:**
Let's talk about the moral question of Palantir. A lot of people probably seeing the title of this episode, hearing this, will not be excited about Palantir being highlighted and promoted, a lot of people kind of disagree with what Palantir's doing. Builds products that kill people in some ways, they work with governments they don't agree with. I know you wrote a really insightful way of how you approach this question when you decided to work at Palantir and how you see people tackle with this, can you just talk about the framework that you landed on and how you thought about this yourself?

**中文翻译:**
让我们聊聊 Palantir 的道德问题。很多人看到这集标题或听到这些内容，可能并不高兴看到 Palantir 被推崇，很多人不认同 Palantir 的所作所为。他们在某种程度上制造了杀人的产品，与人们不认同的政府合作。我知道你在决定去 Palantir 工作时，对这个问题有一套深刻的见解，也观察了别人是如何应对的。你能聊聊你最终确定的框架以及你个人是如何思考的吗？

---

### (01:10:34) Nabeel S. Qureshi

**English:**
Yeah, it's a really interesting topic, it's definitely very nuanced. I think what I was trying to say in that post was a couple of things. One was that there was a lot of upside there. So I worked on the US Covid response, I have friends who worked on Operation Warp Speed, and these are all things that I think saved a lot of lives, and I was pretty focused while I was working at NIH on cancer research. And so to me, these were just obviously good things and you couldn't do them anywhere else, and so that was alone a reason to stay.

**中文翻译:**
是的，这是一个非常有趣且微妙的话题。我在那篇文章中想表达几点。第一，它有很多积极的一面。我参与了美国的新冠疫情应对工作，我的朋友参与了“曲速行动”（Operation Warp Speed），我认为这些都挽救了许多生命。我在 NIH 工作时专注于癌症研究。对我来说，这些显然是好事，而且在其他地方做不了。单凭这一点就足以让我留下来。

---

### (01:11:15) Nabeel S. Qureshi

**English:**
The question I had in that post was, well, okay, there are definitely going to be other pieces of this that people object to. So during the 2016 to 2020 era, it became a pretty common thing to go into work in New York and you'd have people protesting outside your office or doing all kinds of things. And so there was this question of, well, is this okay? And I think the point I was trying to make was it's rare that disengagement is the correct answer, and I think it's more recognized now, but especially then it went a bit too far.

**中文翻译:**
我在文章中提出的问题是：好吧，肯定会有一些部分是人们反对的。在 2016 到 2020 年间，在纽约办公室上班时，经常会看到有人在外面抗议。于是就有了“这是否正确”的问题。我想表达的是，逃避或不参与很少是正确的答案。我认为现在人们更认同这一点，但在当时，这种反对情绪有点过头了。

---

### (01:11:41) Nabeel S. Qureshi

**English:**
The famous example here is Google kind of disengaging with a Pentagon AI project just because some people felt that working with the Pentagon was itself morally bad. I think that's a way to sort of the left of what the median American would say, I think the median American would say it's fine to work on defense stuff within reason and assuming you're doing largely good things, and so there was just this kind of almost arbitrage there at some point of just hang on, it's not like working on defense is inherently evil, it's actually a pretty interesting thing.

**中文翻译:**
著名的例子是 Google 退出五角大楼的一个 AI 项目，仅仅因为一些人觉得与五角大楼合作本身在道德上是错误的。我认为这种观点比普通美国人的看法要激进得多。普通美国人会觉得，在合理范围内且主要做的是好事的前提下，从事国防工作是可以接受的。所以当时存在一种认知偏差：等一下，从事国防工作并非天生邪恶，它实际上是一件非常有意义的事情。

---

### (01:12:15) Nabeel S. Qureshi

**English:**
And then there's this question of, well, would you rather be in the room and making this better or not? And so I'm struggling with how much I can share here, but as a simple example, if you're doing even a workflow, which I think many people would not be super comfortable with, let's say you're targeting somebody for some kind of strike. If you compare the way it's done now to maybe the way it was done in 2010, it's going to be a lot more targeted, it's going to be a lot more accurate, and so you've actually improved that process and reduced the chance of error. Maybe you should feel good about that, right? Now, that is a bullet many people are not willing to bite.

**中文翻译:**
接下来的问题是：你愿意在现场让事情变得更好，还是袖手旁观？我不确定能分享多少，但举个简单的例子：即使是一个让很多人感到不适的工作流，比如针对某人的打击行动。如果你把现在的做法与 2010 年相比，现在的行动要精准得多、准确得多。你实际上改进了这个过程，减少了出错的概率。也许你应该为此感到自豪，对吧？当然，这是很多人不愿意接受的观点。

---

### (01:12:52) Nabeel S. Qureshi

**English:**
I didn't work on the defense side of the company myself, but I think you have to be okay with these kinds of grade zones and actually actively thinking about what you are doing. And that doesn't mean that it's always the right thing to do to work in a defense company. Maybe we go into a very dark future and we start being the bad guys in some ways, and then it's probably not a great idea to work at a defense company. So it's a shifting landscape but I kind of felt pretty strongly that a lot of people in tech just didn't want to think about this at all.

**中文翻译:**
我本人并没有在公司的国防部门工作，但我认为你必须能够接受这种灰色地带，并积极思考你正在做的事情。这并不意味着在国防公司工作永远是正确的。也许未来变得非常黑暗，我们在某些方面成了“坏人”，那可能就不适合在国防公司工作了。这是一个不断变化的过程，但我强烈感觉到，科技界的很多人根本不想思考这些问题。

---

### (01:13:29) Nabeel S. Qureshi

**English:**
So you have engineers now who are working on optimizing short form videos for higher engagement, and you sort of want to say to them like, "Hey, are you thinking about what this is doing to the brains of young children?" Or "Have you seen an 11-year-old kind of scrolling something for five hours and do you think this is a good thing?" And I think people don't want to think about this stuff too much. I'm not saying I know the answer, but there was almost this refusal to look at what tech was doing from a political lens for a very long time. It was just like, "Hey, let us play with our toys, let us sit in our little park, and don't bother us, and we're just going to build cool stuff and launch it."

**中文翻译:**
现在有些工程师在优化短视频的参与度，你可能会想问他们：“嘿，你有没有想过这对小孩子的脑部发育有什么影响？”或者“你见过一个 11 岁的孩子连续刷 5 个小时视频吗？你觉得这是好事吗？”我觉得人们不想深思这些。我不是说我知道答案，但在很长一段时间里，科技界几乎拒绝从政治角度审视自己的所作所为。大家只想说：“嘿，让我们玩自己的玩具，待在自己的小乐园里，别打扰我们，我们只想造出酷炫的东西并发布它。”

---

### (01:14:08) Nabeel S. Qureshi

**English:**
And 2025, we're in a very, very different state of the world, tech is involved in politics now, and politics basically came to tech. There's this famous image of Mark Zuckerberg, he's sitting in Congress and he kind of looks very pale, and he's like, "Why have they dragged me in here again?" But I think tech went through this journey of, oh, we're suddenly becoming important now, oh, we're really, really important now, oh, we better stop playing this game of politics. And so I think what I'm saying now is a lot more consensus than it was 10 years ago, but at the time, the feeling was just like, "Look what we are doing is political, so you better engage with that."

**中文翻译:**
到了 2025 年，世界已经完全不同了。科技已经卷入了政治，政治也找上了科技。有一张著名的照片，马克·扎克伯格坐在国会听证席上，脸色苍白，仿佛在想：“为什么又把我拽到这儿来？”科技界经历了一个过程：从“我们突然变得重要了”到“我们真的非常重要”，再到“我们最好别再玩政治游戏了”。我认为我现在说的这些比 10 年前更容易达成共识，但在当时，大家的态度是：“看，我们所做的一切都是政治性的，所以你最好积极参与其中。”

---

### (01:14:44) Lenny Rachitsky

**English:**
I think when this became really real for a lot of people is with the Ukraine War, the government's running out of certain vehicles and ammunition, we're just not able to produce it, and then we're like, "Oh, thank God for a company like Anduril and all these other tech companies that are actually ahead and keeping us ahead." I think the only reason the US is ahead of China and the space race is because SpaceX just is one company that just has been doing this for a long time. So I think a lot of people have kind of realized, okay, maybe we need these things.

**中文翻译:**
我认为对很多人来说，转折点是乌克兰战争。当政府发现某些车辆和弹药告急，而我们无法快速生产时，大家会想：“哦，谢天谢地，还有像 Anduril 这样的公司以及其他科技公司，他们走在前面并让我们保持领先。”我认为美国在太空竞赛中领先中国的唯一原因，就是 SpaceX 这家公司长期以来的坚持。所以我觉得很多人已经意识到：好吧，也许我们确实需要这些东西。

---

### (01:15:13) Nabeel S. Qureshi

**English:**
Right. And I would make this argument as well, it's like people are like, well, how can you feel good about working in defense? And it's like, well, you're not going to feel great if China invades Taiwan, actually, you're not going to. I think you are probably also not going to like that outcome. So we do just live in this world where you do need to build up deterrents to these things and they better be good. So to me, it didn't feel that difficult of a question. I think when you zoom into particular things, they can be very difficult questions and there have been a bunch of those in the last couple of years. But yeah, again, disengagement isn't the answer.

**中文翻译:**
没错。我也会这样辩论：人们问你怎么能心安理得地从事国防工作？如果中国真的攻打台湾，你也不会觉得好受。我想你大概率也不会喜欢那个结果。所以我们生活在这样一个世界：你确实需要建立威慑力量，而且这些力量最好足够强大。所以对我来说，这并不是一个很难回答的问题。当然，当你深入到具体细节时，问题会变得非常复杂，过去几年确实出现过很多这样的难题。但还是那句话，逃避不是办法。

---

### (01:15:46) Lenny Rachitsky

**English:**
Yeah. And again, it's not for everyone. I think that's an important kind of theme through this conversation is some companies ... like, to build ... sometimes to build a generational, really successful company, you need to turn some people off because that's what brings in the best talent oftentimes. Okay. Just a few more questions. Kind of like stepping back a little bit. You're building a company again. What are a few core pieces of advice that you're bringing to your new startup that will inform how you build this company, from your experience at Palantir?

**中文翻译:**
是的。而且，这并不适合所有人。我认为这次对话的一个重要主题是：有时为了建立一家跨时代的、真正成功的公司，你需要“劝退”一部分人，因为这往往才是吸引最顶尖人才的方式。好，最后还有几个问题。稍微退一步看，你又要创业了。根据你在 Palantir 的经验，有哪些核心建议会影响你构建这家新公司的方式？

---

### (01:16:27) Nabeel S. Qureshi

**English:**
One thing is probably just really fast iteration cycles. So placing a lot of bets and then being really rigorous about just going through that cycle very soon. I have this [inaudible 01:16:40]principles, and one of the things on there is basically saying EOP successes goes up the more bets you make, and it's sort of a function of how many bets you make and the probability of success of those individual bets, right? And so one easy way to almost guarantee that you'll hit something is just to make a lot of bets and then just kind of cycle through them very quickly.

**中文翻译:**
一件事可能是极快的迭代周期。下很多赌注，然后非常严谨地快速完成循环。在我的原则中有一条：成功的概率随着下注次数的增加而增加，它是下注数量和单次成功概率的函数。所以，几乎保证能中奖的一个简单方法就是多下注，然后快速筛选。

---

### (01:17:15) Nabeel S. Qureshi

**English:**
Now, obviously this is difficult, often this question of, well, is this bet actually failing or are we quitting too soon, kind of thing. But that's kind of one principle I take, is just test this thing very early. You know, like the classic "why feed, why see" thing is just when you take something to a customer, ask them to pay you a lot of money and [inaudible 01:17:22] then find a new problem. Don't wait three weeks, which is what every founding team typically does because you don't have that kind of time.

**中文翻译:**
当然这很难，经常会纠结：“这个赌注是真的失败了，还是我们放弃得太早了？”但我秉持的一个原则是：尽早测试。就像经典的 YC 建议：当你把东西拿给客户看时，要求他们付一大笔钱，如果不行就赶紧找新问题。不要等三周，那是大多数创始团队常犯的错，因为你没有那么多时间。

---

### (01:17:29) Nabeel S. Qureshi

**English:**
I do think the importance of just having a really tight, distinctive internal culture and building a strong feeling of trust within a team is really important. And kind of like you mentioned with Airbnb, and people definitely felt this at Palantir, there was this feeling of like, well, you worked here, you must be good. I trust you, and all of that. And I think it's so important to create that and you kind of know that feeling. That's what ... like, people ask me, should I go work at place X or should I just go be a founder straightaway? I don't know the answer for everyone, but I will say one of the benefits of working at a place like that is you just have all these internal benchmarks now for, okay, this is what this should feel like, and if it doesn't feel like that, we're off.

**中文翻译:**
我认为拥有紧密且独特的内部文化、在团队内建立强大的信任感非常重要。就像你提到的 Airbnb，在 Palantir 大家也有这种感觉：“既然你在这儿工作，你一定很优秀，我信任你。”建立这种氛围至关重要。当人们问我“我是该去某大厂工作还是直接创业”时，我没有标准答案，但我会说：在那种地方工作的益处之一是，你拥有了内部基准——你知道“优秀”应该是什么样子的。如果感觉不对，你就知道出问题了。

---

### (01:18:21) Nabeel S. Qureshi

**English:**
So yeah, I think that thing, too, is just distinctive, internal, strong team culture. And then I think for me, think three is just working with a really messy part of the real world. So I kind of joked when I left, like, I am excited to just do pure software. I'm excited to, I don't know, I want to build an ID or something and just not have a support email even and all of that. But it turned out, look, my comparative advantage in a lot of ways was the networks I'd built and the experience I'd had in engaging with the messy parts of the world. And they do need technology a lot, right?

**中文翻译:**
所以，独特的内部团队文化是第二点。第三点对我来说，就是去处理现实世界中真正混乱的部分。我离职时曾开玩笑说，我很兴奋终于可以只做纯软件了，比如造个 IDE 之类的，甚至连支持邮箱都不想要。但事实证明，我的竞争优势在很大程度上在于我建立的人脉和处理现实世界混乱问题的经验。而这些领域确实非常需要技术。

---

### (01:19:00) Nabeel S. Qureshi

**English:**
There's this horrifying thought I have sometimes of just like, maybe we'll get AGI in the next two years and the healthcare sector will still be broken and it will still be impossible to afford rent in New York City and build houses and all these things. And that may well become true. And so I think it's important to engage with those parts of the world too, even though they're really, really challenging. And I think the really nice thing about LLMs is that actually, there's so many workflows now that are accessible to you as a tech founder and people are somehow more open to working with tech companies than they ever were before.

**中文翻译:**
我有时会有一个可怕的想法：也许未来两年我们实现了 AGI，但医疗系统依然支离破碎，纽约的房租依然贵得离谱，房子依然盖不起来。这很可能成为现实。所以我觉得参与这些极具挑战性的现实问题很重要。而大语言模型（LLM）最棒的一点是，作为科技创始人，现在有太多的工作流是可以触达的，而且人们现在比以往任何时候都更愿意与科技公司合作。

---

### (01:20:01) Lenny Rachitsky

**English:**
Wow, that is some alpha right there that you're finding, that some of these very large organizations are more open to working with startups, because classically, investors don't want to invest in companies that are going after healthcare companies and governments and things like that. So it is really interesting actually to hear. I'm going to mirror back the tips you just shared... [Summary of tips omitted for brevity]

**中文翻译:**
哇，这真是一个重要的发现：大型组织现在更愿意与初创公司合作。因为传统上，投资者并不愿意投资那些针对医疗机构或政府的公司。听到这个真的很有趣。我来总结一下你刚才分享的建议……（总结内容略）

---

### (01:21:13) Lenny Rachitsky

**English:**
I'm going to take us to a recurring theme on this podcast called AI Corner. And what we do in AI Corner is we share some way that .. and this is you sharing ... some way that you've found AI to be useful in your day- to-day, either in life or in work. Is there any way you found some tool ... some AI tool useful that you can share?

**中文翻译:**
现在进入我们播客的一个固定环节：AI 角（AI Corner）。在这个环节，请你分享一下你在日常生活或工作中发现 AI 有用的方式。有没有什么 AI 工具是你觉得特别好用可以分享的？

---

### (01:21:38) Nabeel S. Qureshi

**English:**
Oh my gosh, there are so many. I'll give you a few examples. So I use Wispr Flow quite a bit. So this is the talk to your keyboard and it will transcribe for you app. Very good. It's just great when you are iterating very quickly with an LLM and sometimes you have to do these paragraph-long prompts and it's just easier to speak into them. So Wispr Flow, I like.

**中文翻译:**
天哪，太多了。我举几个例子。我经常用 Wispr Flow。这是一个语音转文字的应用，非常棒。当你需要快速与 LLM 迭代，有时需要输入长达一段话的提示词（Prompt）时，直接说出来要容易得多。所以我很喜欢 Wispr Flow。

---

### (01:22:05) Lenny Rachitsky

**English:**
Just to double down on that, you press a button and you start talking and it's writing out what you're saying. Cool. And there have been these products for a long time, Dragon Dictate and all these guys. Is the difference now these are just very, very good now at actually transcribing what you're saying?

**中文翻译:**
确认一下，就是按下一个键开始说话，它就会把你说的写出来。酷。这类产品很久以前就有了，比如 Dragon Dictate。现在的区别是它们在转录准确度上已经做得非常非常好了吗？

---

### (01:22:18) Nabeel S. Qureshi

**English:**
I think that's right. Yeah, they use a really good model and so it rarely makes mistakes even when I think it's quite challenging. And then, yeah, the UX I think they just nailed. So that's really good one. I love Claude Code for developing. Even though I have my complaints about it, there's something just very addictive about just telling it what to do. And it's basically something that you run within the terminal of your computer, and so you just type Claude, it opens up the Claude interface. It's very cute, it's very beautifully designed, and you just tell it what to do. And it actually operates on the file system directly.

**中文翻译:**
我想是的。它们使用了非常好的模型，所以即使在很有挑战的情况下也很少出错。而且它们的 UX 做得非常棒。另一个是 Claude Code，我非常喜欢用它来开发。虽然我也有吐槽的地方，但直接告诉它该做什么真的让人上瘾。它基本上是在电脑终端运行的，你输入 `claude`，它就会打开界面。设计非常精美，你只需告诉它做什么，它会直接操作文件系统。

---

### (01:23:03) Lenny Rachitsky

**English:**
That's what I was going to ask. So this is essentially an AI agent engineer. I didn't know that's what Claude Code did. Very cool.

**中文翻译:**
这正是我要问的。所以这本质上是一个 AI 代理工程师。我以前不知道 Claude Code 是干这个的。非常酷。

---

### (01:23:10) Nabeel S. Qureshi

**English:**
Yeah. It's sort of a guided agent, but yeah, it is really sweet. And then yeah, I'm just enjoying ... you know, every week there's a new, wonderful new thing to play with. Last seven days, I've been testing Gemini Pro 2.5. Excellent model. I don't love Google's UX sometimes, but I was playing with that. And I use LLMs every day for all kinds of things. The other day I was doing taxes and I needed to classify a bunch of transactions based on some metadata, and so I just wrote a script up really quickly and it did that. So.

**中文翻译:**
是的，它算是一个受引导的代理，非常贴心。而且每周都有新奇好玩的东西。过去七天我一直在测试 Gemini Pro 2.5，模型非常出色。虽然我有时不喜欢 Google 的 UX，但我一直在玩它。我每天都会用 LLM 做各种事。前几天我报税时，需要根据元数据对一堆交易进行分类，我很快写了个脚本，它就帮我搞定了。

---

### (01:24:01) Lenny Rachitsky

**English:**
I love just the vibe of just like, this is incredible and so fun. We need more of that. Okay. I'm going to take us to another recurring segment on the podcast. Contrarian Corner. So here's the question. What's something that you believe that most other people don't?

**中文翻译:**
我喜欢这种“这太不可思议、太有趣了”的氛围。我们需要更多这样的能量。好，现在进入另一个固定环节：非主流观点角（Contrarian Corner）。问题是：有什么是你相信，但大多数人都不认同的事情吗？

---

### (01:24:12) Nabeel S. Qureshi

**English:**
I think going to college is great. I think this is a somewhat contrarian view within tech, maybe not in the broader economy, but I often see people saying just like, oh, if you can just drop out when you're 18 and just start working, why would you go to college? And I think this is completely wrong, but maybe it's good advice for 5% of the population who probably would've been to your fellows anyway.

**中文翻译:**
我认为上大学非常棒。这在科技圈可能是一个有点非主流的观点，虽然在整个社会可能不是。我经常看到有人说：“如果你 18 岁就能辍学去工作，干嘛还要上大学？”我觉得这完全错了。也许这对 5% 的天才（比如 Thiel Fellows）是好建议，但对大多数人不是。

---

### (01:24:49) Nabeel S. Qureshi

**English:**
But college is one of the few times when you can just make really, really deep friendships. You are in typically a nice campus. If you're in North America, you get to spend all of your time just thinking and writing papers and reading books and hanging out with your friends. And it's actually very precious and it's very hard to find that kind of time after you turn 21 because you got to pay your rent, you've got to work, you've got to do all this stuff.

**中文翻译:**
大学是人生中少数能建立极深友谊的时光。你通常待在一个美丽的校园里。在北美，你可以把所有时间花在思考、写论文、读书和与朋友闲逛上。这其实非常珍贵，因为一旦你过了 21 岁，你就得付房租、工作，处理各种琐事，很难再找到这样的时间。

---

### (01:25:35) Lenny Rachitsky

**English:**
It's so funny that that is contrarian and it does sound contrarian. I had a great time in college here. Okay. Is there anything else, Nabeel, that you wanted to share or leave listeners with before we get to our very exciting lightning round?

**中文翻译:**
很有意思，这听起来确实像个非主流观点。我在大学也过得很开心。好，在进入激动人心的闪电轮问答之前，Nabeel，你还有什么想和听众分享或留给他们的吗？

---

### (01:25:48) Nabeel S. Qureshi

**English:**
No, I think it's a really exciting time in the world. I think AI can be exhausting, but it does really just open up the possibility of building a better world in all these ways. And so I think just reassess what you're doing every couple of months and make sure that it's aligned with where I think AI is going and make sure that you are working on something that you feel has very high potential if it succeeds.

**中文翻译:**
没有了，我觉得现在是一个非常令人兴奋的时代。虽然 AI 让人疲于奔命，但它确实开启了构建更美好世界的各种可能性。所以，每隔几个月就重新评估一下你正在做的事情，确保它与 AI 的发展方向一致，并确保你正在做的事情如果成功了，将具有巨大的潜力。

---

### (01:26:22) Lenny Rachitsky

**English:**
Let me double click on that real quick. For people that want to do what you're describing, what helps you understand where AI is heading and just kind of align with it, are there places of information and news you find useful? Is it just play with it kind of thing? What would you recommend?

**中文翻译:**
我再追问一下。对于想做到你所说的那样的人，什么能帮助他们理解 AI 的走向并与之保持一致？有没有你觉得有用的信息源或新闻渠道？还是说只是“多玩玩”就行？你有什么建议？

---

### (01:26:39) Nabeel S. Qureshi

**English:**
This is the big question. I use X a lot to keep on top of AI, so I would just recommend finding a good Twitter list and maybe following people off of that. There's some good newsletters. I really like Latent Space, I know his X handle, it's Swyx, S-W-Y-X. I can't remember his actual name, but that one is very good and it's pretty technical. I would recommend trying to stick to the more technical newsletters if possible.

**中文翻译:**
这是个大问题。我经常用 X (Twitter) 来关注 AI 动态，我建议找一个好的 Twitter 列表并关注相关的人。还有一些不错的时事通讯（Newsletter），我很喜欢 Latent Space，作者的 X 账号是 Swyx。那个 Newsletter 非常棒，而且很硬核。我建议尽可能关注那些更偏技术的 Newsletter。

---

### (01:27:16) Nabeel S. Qureshi

**English:**
But I think it's just important to know what's going on and make sure you are revisiting your own workflows as often as possible. And just making sure that the people who went here are going to be the kind of hybrid cyborgs who fuse with the AIs. This actually played out in chess... [Chess analogy omitted] And so I think just becoming a cyborg to the extent that you can. And then I think there's this barbell thing of, it's also important to just leave everything at go touch grass just for your own mental sanity.

**中文翻译:**
我认为重要的是了解现状，并尽可能频繁地审视自己的工作流。确保自己成为那种与 AI 融合的“混合赛博格”。这在国际象棋中已经上演过了……所以，尽你所能成为一个“赛博格”。同时，也要保持“杠铃策略”：为了心理健康，偶尔放下一切去“接触大自然”（touch grass）。

---

### (01:28:18) Lenny Rachitsky

**English:**
Excellent advice. And with that, Nabeel, we've reached our very exciting lightning round. Are you ready?

**中文翻译:**
极好的建议。那么 Nabeel，我们进入激动人心的闪电轮问答。准备好了吗？

---

### (01:28:24) Nabeel S. Qureshi

**English:**
Yes.

**中文翻译:**
准备好了。

---

### (01:28:25) Lenny Rachitsky

**English:**
What are two or three books that you find yourself recommending most to other people?

**中文翻译:**
有哪两三本书是你向别人推荐最多的？

---

### (01:28:29) Nabeel S. Qureshi

**English:**
The first one that comes to mind is Impro by Keith Johnstone. This is actually ... I wrote about it in that essay. It's one of the books that [Palantir] used to send to people. I just think it's a really interesting book. So nominally speaking, it's about improvisational theater... [Description of Impro omitted]

**中文翻译:**
我首先想到的是 Keith Johnstone 的《即兴》（Impro）。我在文章里写过，这是 Palantir 以前常送给别人的书之一。它名义上是关于即兴剧场的，但其实充满了关于创造力和社交行为的奇思妙想。它能帮你更好地观察和与人互动。

---

### (01:29:56) Nabeel S. Qureshi

**English:**
Yeah, so Impro is number one. I think just to go a little more highbrow, maybe Shakespeare's history plays, there's a set of them called the Henriad, so like Henry IV, Henry V, Henry VI. I find most people don't read these... [Description of Henriad omitted]

**中文翻译:**
《即兴》是第一本。第二本我想推荐莎士比亚的历史剧，特别是被称为“亨利四部曲”（Henriad）的那几部。它们是关于权力和政治运作最深刻的著作。

---

### (01:31:05) Nabeel S. Qureshi

**English:**
I love High Output Management by Andy Grove. I just think that's a great business book, and people tend to read summaries of it on the internet more than they actually read the book. But the actual book has a lot of really interesting stories and explanations...

**中文翻译:**
我还喜欢安迪·格鲁夫的《高产出管理》（High Output Management）。这是一本伟大的商业书，很多人只看摘要，但原书中的故事和思考过程才是最精华的。

---

### (01:32:04) Nabeel S. Qureshi (Lightning Round continues)

**English:**
[Movie recommendation: Decision to Leave]

**中文翻译:**
（电影推荐：朴赞郁的《分手的决心》）

---

### (01:33:15) Nabeel S. Qureshi (Lightning Round continues)

**English:**
[Life motto: "Aim for Chartres" - aiming for the very best ever done]

**中文翻译:**
（人生格言：“以沙特尔大教堂为目标”——即追求人类历史上曾达到的最高标准）

---

### (01:34:27) Nabeel S. Qureshi (Lightning Round continues)

**English:**
[Novel recommendation: Anna Karenina by Leo Tolstoy - for developing empathy and perspective-taking]

**中文翻译:**
（小说推荐：托尔斯泰的《安娜·卡列尼娜》——用于培养同理心和多视角思考能力）

---

### (01:36:16) Lenny Rachitsky

**English:**
Where can they find you online and how can listeners be useful to you?

**中文翻译:**
大家可以在哪里找到你？听众可以如何帮到你？

---

### (01:36:16) Nabeel S. Qureshi

**English:**
Find me online, my website is nabeelqu.co and my X handle is Nabeel QU. How can you help me? I would say send me an email. Introduce yourself, say hi. I love meeting people.

**中文翻译:**
我的网站是 nabeelqu.co，X 账号是 Nabeel QU。至于如何帮我，给我发邮件吧，打个招呼，介绍一下你自己。我喜欢结识新朋友。

---

### (01:37:00) Lenny Rachitsky

**English:**
Nabeel, thank you so much for being here. Bye everyone.

**中文翻译:**
Nabeel，非常感谢你能来。各位，再见。