# Nan Yu - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Nan Yu (Head of Product at Linear).

---

### [00:00:00] Lenny Rachitsky

**English:**
I think you see in the team at Linear that a lot of people don't see, which is that there's not actually a trade-off between speed and quality.

**中文翻译:**
我认为你在 Linear 团队中看到了一些很多人没看到的东西，那就是在速度和质量之间其实并不存在权衡（trade-off）。

---

### [00:00:06] Nan Yu

**English:**
People talk about this as if there were a trade-off because when they think about speed, the thing they over-index on is rushing or being sloppy. What they should be indexing on is being really competent. If you look at people who are at the pinnacle of their craft, you can basically tell how good the output is going to be of their work product by how fast they're going.

**中文翻译:**
人们谈论权衡，是因为当他们想到速度时，往往过度关注“匆忙”或“草率”。他们真正应该关注的是“胜任力”。如果你观察那些处于手艺巅峰的人，你基本上可以通过他们工作的速度，判断出其产出的质量会有多高。

---

### [00:00:26] Lenny Rachitsky

**English:**
What does speed look like when you say it can be done quickly and high quality?

**中文翻译:**
当你所说既能快速完成又能保证高质量时，这种“速度”具体是什么样的？

---

### [00:00:30] Nan Yu

**English:**
What it really looks like is you have some rough time budget for how long you think something's going to take. By the time 10% of it has passed, after week one, you have something that works that tests some kind of key hypothesis internally.

**中文翻译:**
它真正的样子是：你对某件事需要多长时间有一个大致的时间预算。当时间过去 10% 时，比如第一周结束后，你就已经有了一个可以运行的东西，能在内部测试某种关键假设。

---

### [00:00:42] Lenny Rachitsky

**English:**
I imagine a criticism you all get. Over time, you'll probably become a bloated piece of software as well.

**中文翻译:**
我能想象你们会收到的一种批评：随着时间的推移，你们可能也会变成一个臃肿的软件。

---

### [00:00:47] Nan Yu

**English:**
When we examine this problem, we look at, "Well, what feature requests can we debate and what kind of feature requests do we absolutely have to say no to?" The stuff that we absolutely have to say no to is the exact kind of thing that leads to this bloatedness that makes ICs (Individual Contributors) hate their lives.

**中文翻译:**
当我们审视这个问题时，我们会看：“哪些功能请求是可以讨论的，而哪些功能请求是我们必须坚决拒绝的？”我们必须拒绝的那些东西，正是导致软件臃肿、让个人贡献者（IC）痛苦不堪的根源。

---

### [00:01:02] Lenny Rachitsky

**English:**
Something that your head of sales shared with me is how impressed he is with the way you ask questions on customer calls and just keep digging and digging until you get to something.

**中文翻译:**
你们的销售主管跟我分享过一件事，他非常佩服你在客户电话中提问的方式，你会不断地挖掘，直到发现核心问题。

---

### [00:01:10] Nan Yu

**English:**
My goal is to feel bad in the same way that customers feel bad.

**中文翻译:**
我的目标是像客户那样感到难受。

---

### [00:01:17] Lenny Rachitsky

**English:**
Today, my guest is Nan Yu. Nan is Head of Product at Linear, which is one of the most beloved, most beautifully designed, and also the fastest growing B2B SaaS product out there today. You rarely see the kind of love that people have for Linear for any enterprise B2B SaaS product. So, there is a lot that we can learn from how Linear operates and how they build product. In my conversation with Nan, he shares a system that he uses for being creative and coming up with non-obvious solutions to customer problems, why it's a red flag to him when PMs tell him there's a trade-off between speed and quality, how he talks to customers in order to figure out the emotion that they want to avoid and then figure out the solution to avoiding that emotion, plus some killer advice on how to land a job, including how he landed his job at Linear and his previous role at Mode, and so much more.

**中文翻译:**
今天的嘉宾是 Nan Yu。Nan 是 Linear 的产品负责人。Linear 是当今最受喜爱、设计最精美、增长最快的 B2B SaaS 产品之一。你很难在其他企业级 B2B SaaS 产品上看到人们对 Linear 这种程度的热爱。因此，关于 Linear 如何运作以及如何构建产品，有很多值得我们学习的地方。在与 Nan 的交谈中，他分享了他用于激发创意并为客户问题提供非显而易见解决方案的系统；为什么当产品经理告诉他速度和质量之间存在权衡时，他会觉得这是个危险信号；他如何通过与客户交谈来找出他们想要避免的情绪，进而找到消除这种情绪的方案；此外还有关于如何获得工作的绝佳建议，包括他如何获得 Linear 的职位以及之前在 Mode 的角色，等等。

---

### [00:02:06] Lenny Rachitsky

**English:**
If you have a desire to build a company or a product that's as beloved as Linear, this episode will give you a ton of tactics and ways to change how you and your team operate. If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. It's the best way to avoid missing feature episodes, and it helps the podcast tremendously. With that, I bring you Nan Yu.

**中文翻译:**
如果你渴望建立一家像 Linear 一样受人喜爱的公司或产品，这一集将为你提供大量的策略和方法，来改变你和团队的运作方式。如果你喜欢这个播客，别忘了在常用的播客应用或 YouTube 上订阅和关注。这是避免错过精彩剧集的最好方式，也对播客有巨大的帮助。下面，让我们欢迎 Nan Yu。

---

### [00:02:30] Lenny Rachitsky

**English:**
This episode is brought to you by Sinch, the Customer Communications Cloud. Here's the thing about digital customer communications. Whether you're sending marketing campaigns, verification codes or account alerts, you need them to reach users reliably. That's where Sinch comes in. Over 150,000 businesses, including 8 of the top 10 largest tech companies globally use Sinch's API to build messaging, email, and calling into their products, and there's something big happening in messaging that product teams to know about, Rich Communication Services, or RCS. Think of RCS as SMS 2.0. Instead of getting texts from a random number, your users will see your verified company name and logo without needing to download anything new. It's a more secure and branded experience. Plus you get features like interactive carousels and suggested replies, and here's why this matters. US carriers are starting to adopt RCS. Sinch is already helping major brands send RCS messages around the world, and they're helping Lenny's Podcast listeners get registered first before the rush hits the US market. Learn more and get started at sinch.com/lenny. That's S-I-N-C-H.com/lenny.

**中文翻译:**
本集由客户沟通云 Sinch 赞助。关于数字客户沟通：无论你是发送营销活动、验证码还是账户警报，你都需要它们可靠地送达用户。这就是 Sinch 的用武之地。超过 15 万家企业，包括全球前 10 大科技公司中的 8 家，都在使用 Sinch 的 API 将短信、邮件和通话功能集成到他们的产品中。目前消息领域正在发生一件产品团队需要了解的大事：富通信服务（RCS）。你可以把 RCS 看作是短信 2.0。用户不再收到来自随机号码的文本，而是会看到经过验证的公司名称和徽标，且无需下载任何新应用。这是一种更安全、更具品牌感的体验。此外，你还可以获得交互式轮播图和建议回复等功能。这之所以重要，是因为美国运营商正开始采用 RCS。Sinch 已经在帮助全球各大品牌发送 RCS 消息，并正在帮助 Lenny's Podcast 的听众在美国市场热潮来临前优先注册。了解更多并开始使用，请访问 sinch.com/lenny。

---

### [00:03:45] Lenny Rachitsky

**English:**
This episode is brought to you by Paragon, the integration infrastructure for B2B SaaS companies. Is AI on your 2025 product roadmap? Whether you need to enable RAG (Retrieval-Augmented Generation) with your users' external data like Google Drive files, Gong transcripts or Jira tickets, or build AI agents that can automate work across your users' other tools. Integrations are the foundation, but building all these integrations in-house will cost you years of engineering, time you don't have given the fast pace of AI. That's where Paragon's all-in-one integration platform comes in. Build scalable workflows to ingest all of your users' external data into your RAG pipelines and leverage ActionKit, their latest product, to instantly give your AI agents access to over 100 integrations and thousands of third party actions with a single API call. Leading AI companies like AI21, You.com, 11x, and coffee.ai are already shipping new integrations seven times faster with Paragon, keeping their engineers focused on core product development. Ready to accelerate your AI roadmap this year? Visit useparagon.com/lenny to get a free MVP of your next product integration.

**中文翻译:**
本集由 B2B SaaS 公司的集成基础设施 Paragon 赞助。AI 是否在你的 2025 年产品路线图中？无论你是需要通过用户的外部数据（如 Google Drive 文件、Gong 转录文本或 Jira 工单）启用 RAG（检索增强生成），还是构建能够跨用户其他工具自动执行任务的 AI 代理，集成都是基础。但在内部构建所有这些集成将耗费数年的工程时间，考虑到 AI 的快速发展，你并没有那么多时间。这就是 Paragon 全方位集成平台的用武之地。构建可扩展的工作流，将用户的所有外部数据摄取到你的 RAG 管道中，并利用他们最新的产品 ActionKit，通过单个 API 调用立即让你的 AI 代理访问 100 多个集成和数千个第三方操作。AI21、You.com、11x 和 coffee.ai 等领先的 AI 公司已经通过 Paragon 以 7 倍的速度交付新集成，让工程师专注于核心产品开发。准备好加速今年的 AI 路线图了吗？访问 useparagon.com/lenny 获取你下一个产品集成的免费 MVP。

---

### [00:04:56] Lenny Rachitsky

**English:**
Nan, thank you so much for being here and welcome to the podcast.

**中文翻译:**
Nan，非常感谢你能来，欢迎来到本播客。

---

### [00:04:59] Nan Yu

**English:**
Thanks for having me. I'm a long-time listener and reader, so it's really a treat to be here.

**中文翻译:**
谢谢邀请。我是你的长期听众和读者，所以能来到这里真的很荣幸。

---

### [00:05:05] Lenny Rachitsky

**English:**
I want to share something with you to kick off that I haven't shared with you yet, that I haven't shared with anyone. These results might have come out by the time this podcast comes out, but I'm running a survey right now that I'm calling, "What's in your stack?" Where all my subscribers are asked, "What tools do you use most day to day? What tools do you love most? What tools do you hate?" And one of the questions asked was, what tool do you wish you could switch to if your IT department allowed you to? The number one answer by far is people want to switch from Jira to Linear.

**中文翻译:**
在开始之前，我想和你分享一些我还没跟任何人说过的事情。当这期播客发布时，结果可能已经出来了，但我现在正在进行一项名为“你的工具栈里有什么？”的调查。我问所有的订阅者：“你日常最常用的工具是什么？你最喜欢的工具是什么？你最讨厌的工具是什么？”其中一个问题是：如果你的 IT 部门允许，你最希望切换到哪个工具？到目前为止，排名第一的答案是人们想从 Jira 切换到 Linear。

---

### [00:05:38] Nan Yu

**English:**
Wow. I mean, hopefully, that means we're doing a good job.

**中文翻译:**
哇。我的意思是，希望这代表我们做得还不错。

---

### [00:05:41] Lenny Rachitsky

**English:**
I think that's exactly what that means. I'll read a couple quotes to give you a sense of what people are saying about Linear. I doubt these are surprising to you, but this gives people a sense of why you're here and why I'm excited to extract as much wisdom as I can from you. So, a couple quotes here. "Linear is a joy to use as I interact with my engineering teams, and I find inspiration in its design." "Linear is simple to use, yet powerful." "Linear's design is obviously an industry benchmark, but moreover, the performance and speed is a massive productivity boost."

**中文翻译:**
我觉得正是这个意思。我读几段引言，让你感受一下人们是怎么评价 Linear 的。我想这些对你来说并不意外，但这能让大家明白你为什么会在这里，以及为什么我这么兴奋想从你身上挖掘智慧。这里有几段话：“在与工程团队互动时，使用 Linear 是一种享受，我从它的设计中获得了灵感。”“Linear 使用简单，但功能强大。”“Linear 的设计显然是行业标杆，而且其性能和速度极大地提升了生产力。”

---

### [00:06:12] Nan Yu

**English:**
I mean, it's really good to hear that because in a lot of ways, that's what we're trying to do. If you think about the entire impetus behind why Linear was started, it's because Karri was sitting at Coinbase and Airbnb and these places and just watching everyone around him struggle using the tools that they had available and always incumbent tools and just seeing that it made people hate their day-to-day a little bit, and we all got into technology and design and engineering, all this kind of stuff because it was fun. All of us started off building stupid MySpace pages and all of these side projects when we were young, and it started off as this fun thing that we do, and we're like, "Wow, we get to do this for a career," and then to have all of this kind of stuff put these big speed bumps into our day-to-day workflow, it just was really sad. So, that's why we started Linear. This really bust through all of that.

**中文翻译:**
听到这些真的很开心，因为在很多方面，这正是我们努力的目标。如果你回想一下 Linear 创立的初衷，是因为 Karri 当时在 Coinbase 和 Airbnb 等地方，看着身边的每个人都在费劲地使用现有的、老牌的工具，看到这些工具让人们对日常工作产生了一丝厌恶。我们进入技术、设计和工程领域，都是因为觉得这很有趣。我们年轻时都从搭建简陋的 MySpace 页面和各种业余项目开始，这原本是一件乐事，我们当时想：“哇，我们可以把这当作职业。”结果这些工具却在我们的日常工作流中设置了巨大的障碍，这真的很令人沮丧。所以我们创立了 Linear，就是为了打破这一切。

---

### [00:07:11] Lenny Rachitsky

**English:**
What I love about Linear, I feel like it's an inspirational business because many people want to, "I'm going to build just a much better version of something," and often that doesn't actually work out. Often nobody cares enough. There's all these barriers and reasons. People don't switch to something that's better, and Linear is an amazing example of building an excellent product and actually succeeding, and there's a lot more to it maybe than just building an awesome product. So, that's what I'm excited to dig into and understand how you all operate, and I guess just based on these results, to me, this is the ultimate sign of product market fit. People being sad they can't use a product in B2B enterprise software especially, so let's get into it. First question I want to get into is something that I think you see and the team at Linear sees that a lot of people don't see, which is that there's not actually a trade-off between speed and quality. I think a lot of people think this is just an innate fact and something I've heard you talk about is that's not actually true. I actually saw Patrick Collison tweet this exact point that I'll read after you... I want to hear your thoughts, but talk about what you've learned about how there's maybe not actually this trade-off between speed and quality.

**中文翻译:**
我喜欢 Linear 的地方在于，我觉得它是一个鼓舞人心的商业案例。因为很多人都想“我要做一个更好的版本”，但通常这行不通。往往没人真正在乎，存在各种障碍和理由让人们不愿切换到更好的产品。而 Linear 是一个打造卓越产品并真正取得成功的绝佳例子，这背后可能不仅仅是做一个好产品那么简单。所以，我很兴奋能深入探讨并了解你们是如何运作的。基于这些调查结果，对我来说，这就是产品市场契合度（PMF）的终极标志：人们因为无法使用某个 B2B 企业软件而感到难过。那么，让我们开始吧。我想探讨的第一个问题是，你和 Linear 团队看到了一些很多人没看到的东西，即速度和质量之间其实并没有权衡。我想很多人认为这是一个天经地义的事实，但我听你谈过这其实并非事实。我甚至看到 Patrick Collison（Stripe 创始人）发推特也提到了这一点。我想先听听你的想法，谈谈你所学到的关于速度和质量之间为何可能并不存在这种权衡。

---

### [00:08:20] Nan Yu

**English:**
People talk about this as if there were a trade-off almost in a naive way because when they think about speed, the thing they over index on is rushing or being sloppy, and what they should be indexing on is being really competent or being like an expert. So, if you look at people who are at the pinnacle of their craft, it could be anything. It could be like a chef or a programmer or someone building houses or something. You can basically tell how good the output is going to be of their work product by how fast they're going. If they're going really fast, and they're obviously not being sloppy and then leaving a mess all over the place, it's like, "Yeah. Well, they got there because this is just second nature to them," and they're able to go at a really rapid pace and try stuff. And when we're building software, that's such a big component of how good the product is on the other side of it, which is like, "How many iterations were you able to do?" So, the only way you're going to get a bunch of iterations done and try different things and really feel out these different variations is by just going very fast.

**中文翻译:**
人们谈论这个话题时，几乎是以一种天真的方式认为存在权衡，因为当他们想到速度时，他们过度关注的是“匆忙”或“草率”，而他们真正应该关注的是“胜任力”或“专家水平”。如果你观察那些处于手艺巅峰的人——无论是厨师、程序员还是建筑工——你基本上可以通过他们工作的速度来判断产出的质量。如果他们动作极快，且显然没有敷衍了事或弄得一团糟，那是因为这已经成了他们的本能，他们能够以极快的速度尝试各种方案。在构建软件时，产品最终质量的一个重要组成部分就是：“你进行了多少次迭代？”要完成大量迭代、尝试不同方案并真正摸索出各种变化，唯一的办法就是跑得非常快。

---

### [00:09:25] Lenny Rachitsky

**English:**
In terms of speed, is the speed there moving quickly on each of iterations? Like what does speed look like when you say, "It can be done quickly and high quality"? What does speed look like?

**中文翻译:**
就速度而言，是指在每次迭代中都快速移动吗？当你所说“可以快速且高质量地完成”时，速度具体表现为什么样？

---

### [00:09:36] Nan Yu

**English:**
Speed... What it really looks like is you have some rough time budget for how long you think something's going to take, and by the time 10% of it has passed, you have a workable solution. It's not like, "Oh, at the halfway point, we have something that is maybe a candidate that we can play around with." It's like, no, no, no. After week one you have something that works that tests some kind of key hypothesis internally so that you can feel like is this thing actually panning out the way we expect it to or did we have some crazy incorrect assumption? And you don't want to wait until you're 80% done to be able to make that kind of judgment because then it's just too late. Then you're pushing deadlines out, and you're making your marketing team very sad.

**中文翻译:**
速度……它真正的样子是：你对某件事需要多长时间有一个大致的时间预算，而当时间过去 10% 时，你就已经有了一个可行的解决方案。不是说“哦，到一半的时候，我们可能有一个可以拿来玩玩的候选方案”。而是，不不不，第一周结束后，你就得有一个能用的东西，能在内部测试某种关键假设，这样你就能感觉到：这东西是否真的如我们预期的那样发展？还是我们有一个极其错误的假设？你不想等到完成了 80% 才去做这种判断，因为那时已经太晚了。那时你只能推迟截止日期，让你的营销团队非常难过。

---

### [00:10:18] Lenny Rachitsky

**English:**
Amazing. Okay, so the way you think is, "We're going to spend a month on this feature. Let's get something workable. We can start testing with potential users even internally in the first few days, essentially in the first week"?

**中文翻译:**
太棒了。所以你的思路是：“我们要花一个月做这个功能。那就在前几天，基本上是第一周，先做出一个能用的东西，甚至可以开始在内部或与潜在用户进行测试”？

---

### [00:10:30] Nan Yu

**English:**
Yes. Yeah.

**中文翻译:**
是的，没错。

---

### [00:10:32] Lenny Rachitsky

**English:**
Yeah. I guess how can you do that? Because most teams can't do that. Most teams need to research, design, build. "Okay, cool. We have something," and once a month later, what allows you to do that?

**中文翻译:**
我想知道你们是怎么做到的？因为大多数团队做不到。大多数团队需要调研、设计、构建。“好，搞定，我们有东西了”，而那已经是一个月后了。是什么让你们能做到这一点？

---

### [00:10:43] Nan Yu

**English:**
Yeah, I mean, there's a lot of components of it. I think having really good talent really helps. Having engineers who don't get blocked by every single little design choice, they're happy to just make something workable. Even if they don't feel comfortable with that particular solution, they'll just bust through it and make something happen there. Part of it is intent. We don't have any expectation that the first version of it is going to be great. That is not in the cards. Look, the first version of it is our best guess in the general direction of what we want to actually ship in the end, and sometimes it works out. Sometimes, it's like, "Wow, this first version was pretty good. Let's make some minor adjustments, and we're good to go," but there's no expectation there. So, no one feels like they have to be a perfectionist and get everything, like all sanded down and really in tip-top shape. It just has to work and get the job done and validate or invalidate our major assumptions.

**中文翻译:**
这包含很多因素。我认为拥有顶尖的人才非常有帮助。拥有那些不会被每一个细小的设计选择卡住的工程师，他们乐于先做出一个能用的东西。即使他们对那个特定的解决方案不太满意，他们也会冲过去，先让它跑起来。部分原因是“意图”。我们并不指望第一版就很棒，那根本不在计划内。听着，第一版只是我们对最终想要交付的大方向的最佳猜测。有时效果不错，我们会觉得：“哇，第一版挺好的，微调一下就能发了。”但我们对此没有预设期望。所以，没人觉得自己必须是个完美主义者，要把所有细节都打磨得尽善尽美。它只需要能运行、能完成任务，并验证或推翻我们的重大假设。

---

### [00:11:57] Lenny Rachitsky

**English:**
I'll read this quote from Patrick Collison. He tweeted this today as I was preparing for this interview, and he's the CEO and founder of Stripe, if you're not familiar. His tweet is, "I increasingly believe that 'good, cheap, fast -- choose two' maxim is devious misinformation spread by the slow. In my experience, slow and expensive usually go together."

**中文翻译:**
我读一下 Patrick Collison 的这段话。他在我准备这次采访的今天发了这条推特。如果你不熟悉他，他是 Stripe 的 CEO 兼创始人。他的推特写道：“我越来越相信‘好、便宜、快——三选二’的格言是那些动作慢的人散布的误导性信息。根据我的经验，‘慢’和‘贵’通常是并存的。”

---

### [00:11:57] Nan Yu

**English:**
Yeah, exactly. I mean, use the contractor kind of example. Like If someone's making modifications to their house, and it's taking forever, one, you're in a hotel and also the bills are adding up.

**中文翻译:**
没错。就像装修承包商的例子。如果有人在装修房子，而且拖了很久，首先你得一直住酒店，其次账单也会不断增加。

---

### [00:12:09] Lenny Rachitsky

**English:**
The other example you used when we were chatting about this earlier is chess players. I'm thinking of Magnus Carlsen, watching him. I think he was number one in speed chess in addition to just regular chess and what a microcosm of this point.

**中文翻译:**
我们之前聊天时你用的另一个例子是棋手。我想到了 Magnus Carlsen，看他下棋。除了常规赛，他好像也是快棋赛的第一名，这正是这个观点的缩影。

---

### [00:12:22] Nan Yu

**English:**
Yeah, I think that's the case and Magnus and Hikaru and all those guys who are at the top of their game, they can go unbelievably fast. In fact, that's the usual... I mean, I don't want to get too out of my depth with chess, but the usual way you try to make the game fair is you give them much, much less time than someone who's not quite as strong of a player, and they'll still win a lot of time, too.

**中文翻译:**
是的，确实如此。Magnus、Hikaru 以及所有那些顶尖高手，他们的速度快得令人难以置信。事实上，通常……我不想在象棋方面说得太外行，但通常为了让比赛公平，你会给他们比普通选手少得多的时间，而他们往往还是能赢。

---

### [00:12:43] Lenny Rachitsky

**English:**
So, maybe just to close out this point and give someone something concrete they can do with this information, say they want to start moving faster while not cutting quality, what do you think they can do? What's one thing they can start trying to work on and improving in the way they operate?

**中文翻译:**
为了结束这个话题并给听众一些具体的建议，如果他们想在不降低质量的前提下开始加快速度，你认为他们可以做什么？在运作方式上，他们可以开始尝试改进的一件事是什么？

---

### [00:12:58] Nan Yu

**English:**
I think it's really that sort of attitude and point of view question to understand and take the almost controlled risk that the first version of this is not going to be perfect. So, it actually makes it a lot cheaper in many ways. It means you don't need a pixel perfect design. It means you don't need to make sure that all of the little UI bugs and stuff like that are solved because none of that really matters. What matters is you have working software that you can interact with, and you can see if it feels good. Does it actually solve the core problem that is facing our users? You can take it back to users. You can even let them into an early beta or something like that and get real validation there and to really focus on getting the smallest, shippable element, like not shippable in the sense of, "I can actually put on the production," but in the sense of like, "I can start learning from here."

**中文翻译:**
我认为这实际上是一个态度和视角的问题：去理解并承担一种“受控风险”，即第一版不会是完美的。这在很多方面反而降低了成本。这意味着你不需要像素级完美的设计，不需要确保解决所有细小的 UI bug，因为这些都不重要。重要的是你有一个可以交互的运行软件，你可以看看它感觉如何。它是否真的解决了用户面临的核心问题？你可以把它拿给用户看，甚至让他们进入早期测试版，获得真实的验证。要真正专注于获得“最小可交付元素”——这里的“可交付”不是指“我可以正式上线”，而是指“我可以开始从中学习”。

---

### [00:14:04] Nan Yu

**English:**
We have a gradually increasing sort of circle of users that use every single feature. So, by the time it hits GA (General Availability), by the time it gets released, it's been used by a lot of different users up to that point. So, the first circle is just internal users. We use Linear every single day to write software and do our own work, so we have that kind of advantage and then once we feel like it's good enough, we'll put it into some beta customer group, and again, as early as we can in the process. We have to make sure that we don't end up corrupting people's data, and it doesn't look hideous and that kind of stuff, but as long as it reaches that level of quality, we can release it to early access customers who can give us good feedback and also just try to solve their problems with it. If no one engages with it, if no one's using it, then that's a good signal that we didn't really hit the mark, and then we have a couple of different beta audiences that we grow and then the ultimate release obviously is for GA where everyone gets it.

**中文翻译:**
我们有一个逐渐扩大的用户圈子来测试每一个功能。所以，当它达到 GA（正式发布）阶段时，已经有很多不同的用户使用过它了。第一个圈子是内部用户。我们每天都用 Linear 来写软件和处理自己的工作，所以我们有这种优势。一旦我们觉得它足够好了，我们就会把它放入某些测试客户群中，同样，越早越好。我们要确保不会损坏用户的数据，外观不要太难看之类的，但只要达到那个质量水平，我们就可以发布给早期访问客户，他们能给我们很好的反馈，并尝试用它解决问题。如果没有人参与，没有人使用，那就是一个很好的信号，说明我们没找准方向。然后我们会扩大几个不同的测试群体，最后当然是 GA 发布，让所有人都能用到。

---

### [00:15:30] Lenny Rachitsky

**English:**
That's an amazing answer. Okay, so secret number one to Linear success, I'm going to take some notes here, is get new feature, product ideas out to people as early as possible, say, in the first 10% of the amount of time you've allotted, and then release it increasingly to more and more people to get feedback. I think the implication here is just most wasted time is on building things nobody actually ends up wanting or using. So, the sooner you at least get directional sense of are you heading in a good direction, the faster it all go?

**中文翻译:**
这个回答太棒了。好，Linear 成功的第一个秘诀（我记一下笔记）：尽可能早地将新功能或产品想法展示给人们，比如在分配时间的最初 10% 内，然后逐渐发布给更多人以获取反馈。我想这里的含义是，大部分浪费的时间都花在了构建没人真正想要或使用的东西上。所以，越早获得方向感，确定是否走在正确的道路上，整体进度就会越快。

---

### [00:15:30] Nan Yu

**English:**
Yeah, totally.

**中文翻译:**
是的，完全正确。

---

### [00:15:31] Lenny Rachitsky

**English:**
I imagine a criticism you all get. People are like, "Yes, Linear is so great, so beautiful, so much better than what's been out there for decades," but over time you'll probably become a bloated piece of software as well. That's just the fate of enterprise software. You have to check all these checkboxes. IT teams need all these features. So, there's always this like, "Oh, yeah, sure, you guys can operate this way for now. You have an amazing product for now, but it'll get ugly and bloated." How do you think about avoiding that? I know it's something you spent a lot of time thinking about. Maybe give us a glimpse into some of the conversations you have internally when there's these feature requests like, "Oh, I need single sign-on with this thing and this button here." How do you think about what to add, what not to add, and how to add these features to not make it bloated?

**中文翻译:**
我能想象你们会受到的批评。人们会说：“是的，Linear 很好，很漂亮，比过去几十年的工具好得多，但随着时间的推移，你们可能也会变成一个臃肿的软件。”这就是企业软件的宿命。你必须满足各种勾选框，IT 团队需要各种功能。所以总会有人说：“哦，当然，你们现在可以这样运作，你们现在有一个很棒的产品，但它最终会变得丑陋且臃肿。”你是如何考虑避免这种情况的？我知道这是你花了很多时间思考的问题。也许可以让我们窥见一下你们内部的讨论，当出现类似“哦，我需要这个东西的单点登录，这里需要这个按钮”之类的功能请求时，你们如何决定加什么、不加什么，以及如何添加这些功能而不使其变得臃肿？

---

### [00:16:14] Nan Yu

**English:**
This question actually comes to us a lot from candidates that are interviewing with us. When you go like, "Hey, do you have any questions for us?" This is the question that we're going to get. So, we hear it quite a lot, and it's very sensible for them to ask it because they see history being littered with the corpses of startups trying to compete in this space and not making it, and I think when we examine this problem, we look at, "Well, what kind of feature requests can we debate and what kind of feature requests do we absolutely have to say no to?" And the stuff that we absolutely have to say no to is also the exact kind of thing that leads to this bloatedness that makes ICs hate their lives, and it's very specific. It's customization features requested by middle managers in order to make reporting a little bit easier at the cost of making IC workflows worse.

**中文翻译:**
这个问题实际上很多面试候选人都会问。当你问“嘿，你有什么问题想问我们吗？”时，这通常就是我们会听到的问题。所以我们听过很多次，他们问这个问题很合理，因为他们看到历史上到处都是试图在这个领域竞争却最终失败的初创公司的尸体。我认为当我们审视这个问题时，我们会看：“哪些功能请求是可以讨论的，而哪些是我们必须坚决拒绝的？”我们必须拒绝的那些东西，正是导致臃肿、让个人贡献者（IC）讨厌生活的元凶。这非常具体：就是那些由中层管理人员要求的、为了让报告稍微容易一点，却以牺牲 IC 工作流为代价的定制化功能。

---

### [00:17:16] Nan Yu

**English:**
It's like if it fits that description, we're just saying, "No." There's no debate because we've already thought about it and this is the thing that we can't take a single step down this path. So, I think that's honestly one of the core promises of Linear is that we will not make this particular trade-off. So, when you see people saying like, "Wow, Linear is so much faster. It's so much easier to use and it makes my work so much more enjoyable." This is the reason because we have not taken a single step in this direction. It's very easy for a PM to say yes to this kind of request because often they're talking with buyers. Any kind of B2B type of space, they're talking with whoever the gatekeeper is and sales is putting pressure on them, and they're saying like, "Hey, we really want this one feature. It's going to make our reporting nicer."

**中文翻译:**
如果符合这个描述，我们就直接说“不”。这没什么好讨论的，因为我们已经考虑过了，这条路我们一步也不能走。我认为这正是 Linear 的核心承诺之一：我们不会做这种特定的权衡。所以，当你看到人们说“哇，Linear 快得多，好用得多，让我的工作更愉快”时，原因就在于我们从未朝那个方向迈出过一步。对于产品经理来说，答应这类请求很容易，因为他们经常在和买家沟通。在任何 B2B 领域，他们都在和决策者交谈，销售也会给他们压力，说：“嘿，我们真的很想要这个功能，它会让我们的报告更好看。”

---

### [00:18:02] Nan Yu

**English:**
So, the director's going to be really excited by this, and we'll definitely make a buying decision based off of this, and we have to convince them that this is a false trade-off. The whole premise is wrong because the moment you start going down this path, and you make the IC user experience worse, they're just going to disengage. No one has to do this. If I'm an engineer, I get paid to write code. My performance review is based on my code contribution. It's not based on like, "Did I fill in all the tickets right?" So, I'm just not going to do that part, or I'm going to do it very sporadically, and then I'm going to just focus on my actual job.

**中文翻译:**
“总监会对这个功能非常兴奋，我们肯定会根据这个做购买决定。”而我们必须说服他们，这是一个虚假的权衡。整个前提都是错的，因为一旦你开始走这条路，让 IC 的用户体验变差，他们就会放弃使用。没人非得用这个。如果我是一名工程师，我的工资是用来写代码的，我的绩效评估是基于代码贡献，而不是基于“我是否正确填写了所有工单”。所以我干脆就不做那部分，或者偶尔敷衍一下，然后专注于我的实际工作。

---

### [00:18:38] Nan Yu

**English:**
And then all your reporting is wrong because all the data is wrong, and it's sparse, and you get situations where people will... They'll say like, "Well, here's a dropdown field that someone put in here that's required." There's nine choices. I don't know what any of them meet, so I'm just going to pick one at random. I'm still going to pick the first one. Also, I'm going to pray that my boss is not actually using this data to do any kind of reporting and that has consequence because the data can't possibly be correct. So, I think for us, it's a very easy decision when it comes to that particular category of feature request.

**中文翻译:**
结果就是你所有的报告都是错的，因为数据全是错的，而且很稀疏。你会遇到这样的情况：人们会说，“好吧，这里有一个别人加的必填下拉字段，有九个选项，我根本不知道它们是什么意思，所以我随便选一个，通常选第一个。”而且我会祈祷老板不要真的用这些数据做报告。这会产生后果，因为数据不可能是正确的。所以对我们来说，涉及到这类特定的功能请求时，决定非常简单。

---

### [00:19:12] Lenny Rachitsky

**English:**
I love how simple and clear that is. Basically, you all have a policy. We'll prioritize ICs over middle managers. Especially, like I love that it's around reporting. Almost always it sounds like, "I want to track what's happening."

**中文翻译:**
我喜欢这种简单明了的方式。基本上，你们有一个原则：我们会优先考虑 IC 而不是中层管理人员。特别是关于报告这一点，听起来几乎总是“我想追踪发生了什么”。

---

### [00:19:23] Nan Yu

**English:**
Yeah, exactly. It's always, "I want to track what's happening." Well, what do you want to track? Well, I want to track which version of the product this thing's tied to based on some field information. It's like, okay, how is the person working on this supposed to even know that information? Well, it takes like a five-minute scavenger hunt every single time. It's like, "I don't think they're going to do that, man."

**中文翻译:**
是的，没错。总是“我想追踪发生了什么”。好吧，你想追踪什么？“我想根据某些字段信息追踪这个东西绑定的是哪个产品版本。”好吧，负责这项工作的人怎么可能知道这些信息？“哦，每次都要花五分钟去到处找。”我想说：“伙计，我觉得他们不会去做的。”

---

### [00:19:43] Lenny Rachitsky

**English:**
What I imagine happens, and I think why this is hard for most companies is there's an implication that you're turning down deals. You're not adding that one feature that will close a massive million-dollar sale, very difficult to do. I imagine it helps a lot that... I imagine the COO is very bought into this and there's this, "We will win long-term holding the line on this." Is that right?

**中文翻译:**
我能想象发生的情况，也是为什么这对大多数公司来说很难的原因：这意味着你在拒绝订单。你没有添加那个能促成百万美元大单的功能，这很难做到。我想这很有帮助……我猜 COO 非常认同这一点，并且有一种“坚持这个底线，我们长期会赢”的信念。对吗？

---

### [00:20:05] Nan Yu

**English:**
So, it is, but I also think that there's not as much pressure as you would expect to do these kinds of things. There are basic scaling things, like we had to make SAML and SCIM and that kind of stuff. It's like, "Yeah, sure, we're going to do those sorts of, like keep the lights on type of work," but when it comes to work that's related to the actual business logic of the app's value proposition, what buyers care about is, is this going to make their team more effective? That's the reason that they're making this buying decision in the first place is that they're like, "Well, the current situation we're in... " And especially with large companies, right? The current situation we're in is a mess, and if we can convince them that these types of things are actually the reason that it's a mess, then we can really navigate them out of wanting them in the first place.

**中文翻译:**
确实如此，但我也认为做这些事情的压力并没有你想象的那么大。有一些基础的扩展性工作，比如我们必须做 SAML 和 SCIM（身份管理协议）之类的。这些是“维持运营”类的工作，我们肯定会做。但当涉及到与应用价值主张的实际业务逻辑相关的工作时，买家真正关心的是：这是否会让他们的团队更高效？这才是他们做出购买决定的初衷，因为他们觉得：“我们现在的状况……”特别是大公司，“我们现在的状况一团糟。”如果我们能说服他们，正是这些（管理导向的）功能导致了混乱，那么我们就能引导他们从一开始就不再想要这些功能。

---

### [00:21:04] Lenny Rachitsky

**English:**
Got it. So, there's an element of you think you need this, but it turns out you'll be more successful and get everything you want, not getting this?

**中文翻译:**
明白了。所以这里面有一种成分是：你以为你需要这个，但事实证明，如果不加这个，你会更成功，并得到你真正想要的一切？

---

### [00:21:04] Nan Yu

**English:**
Yeah, and the thing is, it's not everything you want, right? Because people come with a laundry list, and it's like laundry list. Here's 10 things I want. You're like, "Do you want all of those 10 things equally?" They're like, "No, actually I don't." The first three are the things that really matter to us. If we solve the first three, then the other stuff, we can negotiate on. So, our job is to solve the first three-way better than anybody else that if they got through the first three through some kind of visual programming, customization type of thing, that it's never going to get to the quality level and the depth that we're able to offer by offering those as native features.

**中文翻译:**
是的，而且问题在于，那并不是你想要的“全部”，对吧？因为人们会带着一长串清单过来。比如有 10 件事。你会问：“这 10 件事对你来说同等重要吗？”他们会说：“不，其实不是。前三件才是真正对我们至关重要的。”如果我们解决了前三件，其他事情就可以商量。所以我们的工作就是把前三件事做得比任何人都好，好到即使他们通过某种可视化编程或定制化手段实现了那三件事，也永远无法达到我们作为原生功能所能提供的质量水平和深度。

---

### [00:21:37] Lenny Rachitsky

**English:**
It's interesting thinking back to that survey I shared where the tool people want to switch to if IT allowed them was Linear, and on the one hand you could argue, "Well, okay, IT is not letting them use Linear for all these reasons. On the other hand, you guys are growing really quickly within enterprise, like you're a new business. You started, I think, mid-market startups, and now you're working way up. So, I think it's not fair to say it's not going to work in enterprise. It's clearly working really well. I don't know if there's any stats you can share anything of that, but it seems to be going well, expanding up market.

**中文翻译:**
回想我分享的那个调查很有意思，如果 IT 允许，人们最想换的工具是 Linear。一方面你可以辩称：“好吧，IT 因为各种原因不让他们用 Linear。”但另一方面，你们在企业市场的增长非常快，就像一个新业务。我记得你们是从中型市场初创公司开始的，现在正向高端市场进军。所以我觉得说它在企业级市场行不通是不公平的，显然它运作得非常好。我不知道你是否有数据可以分享，但看起来向高端市场扩张进展顺利。

---

### [00:22:11] Nan Yu

**English:**
Yeah, I mean, growth has been good. Growth in enterprise has been leading the other segments because I think this year, especially we reached a tipping point where I think with software, so much of the buying decision is based on almost like a brand thing, like is this for us? A lot of times people pick "enterprise software." It's like, "Why? You know everyone doesn't want this," and they're like, "Yeah, but it's for us."

**中文翻译:**
是的，增长一直不错。企业级的增长一直领先于其他细分市场，因为我认为今年我们达到了一个转折点。对于软件来说，很多购买决定几乎是基于一种品牌认同，比如“这是为我们设计的吗？”很多时候人们选择“企业级软件”，你会问：“为什么？你知道大家都不喜欢这个。”他们会说：“是的，但它是为我们这种规模设计的。”

---

### [00:22:36] Lenny Rachitsky

**English:**
You won't get fired for buying Microsoft or whatever.

**中文翻译:**
买微软的东西不会被开除，诸如此类。

---

### [00:22:39] Nan Yu

**English:**
Yeah, exactly, and I think that we're starting to have enough brand penetration amongst enterprises where people can have that feeling, right? They're like, "Hey, Linear is for us. Who are we? Well, we are a large company that wants to act like a startup." It's like, "Who doesn't want that? Who doesn't want to go fast?"

**中文翻译:**
没错。我认为我们在企业中的品牌渗透率已经开始让人们产生这种感觉了，对吧？他们会觉得：“嘿，Linear 是为我们设计的。我们是谁？我们是一家想要像初创公司一样行动的大公司。”谁不想这样呢？谁不想跑得快呢？

---

### [00:22:58] Lenny Rachitsky

**English:**
Yeah. I had Jeffrey Moore on the podcast, and this is exactly what crossing the chasm looks like. He talked about basically you need someone that's across the chasm like a later adopter that isn't the person that's, "I love new stuff, and I'm an early adopter kind of evangelist." You need someone that's like traditional old school, takes their time to start to adopt it for you to be like, "Oh, okay. Now, maybe I should really take it seriously."

**中文翻译:**
是的。我曾邀请 Jeffrey Moore 来过播客，这正是“跨越鸿沟”的样子。他谈到，你基本上需要一个已经跨越鸿沟的人，比如一个后期采用者，而不是那种“我喜欢新鲜事物，我是早期采用者布道师”的人。你需要一个传统守旧、花很长时间才开始采用的人，这样你才会觉得：“哦，好吧，现在也许我真的该认真对待它了。”

---

### [00:23:21] Nan Yu

**English:**
I also think that with this particular category of tool, and with a lot of other B2B software, not... Like no means not now, right? Not right now because it doesn't fit our budget. It doesn't fit our change management situation. "Oh, we have this exec that's really wedded to this other tool," but those things change, right? So, we keep in contact with them. They're in our CRM where we make sure we follow up, and we've had a lot of these where we've been said no to, like two years ago, and now we have some new features, and then go like, "Oh, yeah, it seems like you're ready for our scale," or whatever.

**中文翻译:**
我还认为，对于这类特定的工具以及许多其他 B2B 软件，“不”并不代表永远不行，而是“现在不行”，对吧？现在不行是因为不符合预算，或者不符合我们的变更管理现状。“哦，我们有个高管非常迷恋另一个工具。”但这些情况是会改变的。所以我们与他们保持联系，他们在我们的 CRM 系统中，我们会确保跟进。我们遇到过很多两年前拒绝我们，现在因为我们有了新功能而回来说：“哦，是的，看来你们已经准备好应对我们的规模了”之类的情况。

---

### [00:24:22] Lenny Rachitsky

**English:**
You mentioned that when you have these debates and questions that come out, you have features that a big company wants. There's this category of, "We know we will not build things for middle managers that want reporting and custom stuff just to track what's happening," versus something an IC wants to be more productive and successful, Linear. Give us a little sense of some of the more complicated debates that aren't necessarily in that bucket.

**中文翻译:**
你提到当出现这些辩论和问题时，大公司会有想要的功能。有一类是“我们知道我们不会为想要报告和定制化功能的中层管理人员构建东西，仅仅为了追踪发生了什么”，而另一类是 IC 为了提高生产力和成功而想要的东西。给我们讲讲那些不一定属于这两个范畴的、更复杂的辩论。

---

### [00:24:22] Nan Yu

**English:**
I think the complicated debates are often when we do add a new native feature, do we extend an existing feature and make it more powerful or do we add a new sort of service? And a big part of that is trying to figure out exactly who's going to use it, what are the actual real life use cases that we know about? Like that I know that Bob from Company X has this workflow and this is how it would work for him. Here are the different variations where it would work. So, tying it all the way back to real people is-

**中文翻译:**
我认为复杂的辩论通常在于：当我们添加一个新的原生功能时，是扩展现有功能使其更强大，还是添加一种新的服务？其中很大一部分工作是弄清楚到底谁会使用它，我们知道的实际生活中的用例是什么？比如我知道 X 公司的 Bob 有这样的工作流，这就是它对他起作用的方式。这里有它能起作用的不同变体。所以，将其一直追溯到真实的人是——

---

### [00:24:52] Lenny Rachitsky

**English:**
Like a specific person?

**中文翻译:**
比如一个具体的人？

---

### [00:24:53] Nan Yu

**English:**
Yeah, specific person. Yeah. Yeah, exactly. Not a hypothetical person. Not one that you made up like Alice, Bob, or whatever. It's like, "No, here's the first name, last name. Here's their email. You can ask them," and I think that being able to tie it all the way back to reality in that way is a big part of how we really think about and discuss these things.

**中文翻译:**
是的，具体的人。没错。不是假设的人，不是你编造的 Alice 或 Bob 之类的。而是：“不，这是名和姓，这是他们的电子邮件，你可以去问他们。”我认为能够以这种方式将其一直追溯到现实，是我们思考和讨论这些问题的核心。

---

### [00:25:13] Lenny Rachitsky

**English:**
This connects the way I think about my newsletter is I always try to answer the question a very specific, like a person actually asked, not a general sense of something people may be interested in, and that very specific question, like it implies there's a need. Like not implies, it proves there's at least one person who needs this thing versus you have this idea of somebody that may want this thing.

**中文翻译:**
这和我写新闻通讯的方式很像：我总是试图回答一个非常具体的问题，比如某个人真实问过的问题，而不是人们可能感兴趣的某种普遍感觉。那个非常具体的问题证明了至少有一个人需要这个东西，而不是你凭空想象有人可能想要它。

---

### [00:25:36] Nan Yu

**English:**
Yeah. I think a trap that a lot of times PMs will fall into is they'll make something, and they'll make some choices in it because maybe it's beautiful or it's elegant, but they don't go the step of like, "Is reality also beautiful and elegant?" Because reality is ugly sometimes, and if you have a beautiful and elegant solution that doesn't match with reality, it doesn't really matter. People can look at it, and they can ooh and ah, but if they don't use it to get their work done, it's never going to have long-term staying power.

**中文翻译:**
是的。我认为产品经理经常会掉进一个陷阱：他们做了一些东西，并在其中做了一些选择，也许是因为它很美或很优雅，但他们没有进一步思考：“现实也是这么美、这么优雅吗？”因为现实有时是很丑陋的。如果你有一个精美优雅的解决方案，却与现实不符，那也没用。人们可能会看着它发出赞叹，但如果他们不用它来完成工作，它就永远不会有长期的生命力。

---

### [00:26:17] Nan Yu

**English:**
Part of it is you hear something, and you're like, "Gosh, that actually is... " Not only is that true. It means that the way we thought about this was a little bit wrong, and I call this process... I don't know if it's the right way to describe it. I call it annealing where you have a thing, and it's not quite the right shape, and you put it out into the wild. So, this happens way in the first bit of the life of a particular feature. You release a thing, and then you start getting feedback about it, about hey, it doesn't quite fit reality, and then you ask yourself like, "Did we test that aspect of it? Did we actually match that part to reality?" And if you didn't, then it's like that's the part where you don't actually need that many pieces of feedback against it. It's not really a volume thing. It's like, "Did we think about this right or wrong?" That's one sort of category.

**中文翻译:**
一部分情况是，你听到了一些反馈，然后心想：“天哪，这居然是真的……”这不仅是真的，还意味着我们之前的想法有点偏差。我把这个过程称为……我不知道这么描述是否准确，我称之为“退火”（annealing）：你有一个东西，它的形状不太对，你把它放到实际环境中。这发生在某个功能的早期阶段。你发布了一个东西，然后开始收到反馈，说它不太符合现实，然后你问自己：“我们测试过那一面吗？我们真的把那部分与现实匹配了吗？”如果你没做，那么在那一部分你其实不需要太多的反馈。这不关乎反馈的数量，而是关乎“我们想得对还是错”。这是其中一类。

---

### [00:27:01] Nan Yu

**English:**
Another category is just you're getting a request for maybe a very big feature or a feature set from a lot of different people, but then you dig in, and you try to say like, "Okay. Well, tell me about how you're trying to use this," and there's 100 different use cases. So, you have choices here. You can either build the big feature that covers all the long tail of use cases or you can try to see if there's really concentrated pools of use cases for this that really make a lot of sense to adopt as a first order type of feature. So, I think those are the two sort of strategies that we employ the most. It's like, "Did we think about this wrong? And now we're just learning something about how it matches reality or for this big general feature that people are asking for, are there actually more specific use cases that we should be solving, and we should be solving really, really well?"

**中文翻译:**
另一类是，你收到了很多不同的人对一个非常大的功能或功能集的请求，但当你深入挖掘并尝试问：“好吧，告诉我你打算怎么用它”时，你会发现有 100 个不同的用例。这时你有两个选择：要么构建一个覆盖所有长尾用例的大功能，要么尝试看看是否存在非常集中的用例池，非常适合作为一等公民功能来采用。我认为这是我们最常用的两种策略。要么是“我们想错了吗？现在我们正在学习它如何匹配现实”；要么是“对于人们要求的这个庞大的通用功能，是否其实有更具体的用例是我们应该解决的，并且应该解决得非常出色？”

---

### [00:28:18] Nan Yu

**English:**
I'll give you an example of all of these things, which we just launched a feature called Customer Requests, and basically what this does, it adds a new concept of Linear, which is a customer. For B2B companies, this is very relevant, and the reason we did this is because we kept getting this request for fully customized fields, and we would be like, "Well, what is it that you want with your custom fields?" Because the problem is you add 100 custom fields and all your ICs start hating it. So, we don't want to go down that path, but what is it actually you're trying to do? And 40% of them were because, "Well, I have a customer," like Walmart or whatever, right? Like, "Walmart asked for this feature, and it's really important. I need everyone to know that Walmart needs this. I need to track it. I need to see how have we report... "

**中文翻译:**
我给你举个例子，我们刚刚发布了一个叫“客户请求”（Customer Requests）的功能。基本上，它在 Linear 中增加了一个新概念，即“客户”。对于 B2B 公司来说，这非常相关。我们做这个的原因是，我们一直收到关于完全自定义字段的请求，我们会问：“你想要自定义字段做什么？”因为问题在于，你加了 100 个自定义字段，所有的 IC 都会开始讨厌它。所以我们不想走那条路，但你到底想做什么？结果发现 40% 的请求是因为：“我有一个客户”，比如沃尔玛之类的，“沃尔玛要求这个功能，这很重要。我需要让每个人都知道沃尔玛需要这个。我需要追踪它，我需要看报告……”

---

### [00:29:09] Nan Yu

**English:**
We can report on what have we done for Walmart over the past year so that when my CSM (Customer Success Manager) has a one-on-one conversation with a rep, they can have some kind of evidence that we've been doing stuff for them, like all this kind of stuff. We're like, "Okay. Cool." That sounds like a very useful and powerful thing you want to do. How do you expect people to tag these things? Well, manually, because that's how we did it in our spreadsheets. It's like, "Okay, instead of that, we're going to hook up with your customer support tools. We're going to hook up with your CRMs. We're going to automatically bring in feedback from these companies. We're going to analyze the emails where they're from, and then if someone requests a feature that gets escalated into engineering, it'll just be tagged with whoever asked for it. You don't have to do anything, but you will know, and you can still report on this stuff, but there's nothing about this that makes ICs lives harder.

**中文翻译:**
“我们可以报告过去一年为沃尔玛做了什么，这样当我的 CSM（客户成功经理）与对方代表进行一对一会谈时，他们就有证据表明我们一直在为他们做事。”我们觉得：“好，很酷。这听起来是你想要做的非常有用且强大的事情。但你打算让人们怎么打标签呢？”“哦，手动打，因为我们在电子表格里就是这么干的。”我们说：“好吧，与其那样，不如我们连接你的客户支持工具，连接你的 CRM。我们会自动引入这些公司的反馈，分析邮件来源，如果有人请求的功能被升级到工程部门，它就会自动打上请求者的标签。你什么都不用做，但你会知道，而且你仍然可以做报告。最重要的是，这完全不会让 IC 的生活变得更难。”

---

### [00:29:54] Nan Yu

**English:**
In fact, it makes them feel more confident because when they're building the thing, they actually understand who's asking for it and exactly what the email said. So, when they're doing the design or the details, they can actually see the real-life use cases that are present and solve for those directly.

**中文翻译:**
事实上，这让他们感到更有信心，因为当他们在构建这个东西时，他们能真正理解是谁在请求它，以及邮件里到底是怎么说的。所以，当他们在做设计或处理细节时，他们可以看到真实的用例，并直接针对这些用例进行解决。

---

### [00:30:09] Lenny Rachitsky

**English:**
As I'm hearing this, it's like, "Okay, obviously, this seems like an obvious solution. Of course, 40% of people telling me they have customers." In reality, most of the time, if you hear from a bunch of your customers, "Hey, I need this custom field," and sometimes you hear one thing, sometimes you hear another. Most of the time you're going to build this custom field. Something that your head of sales shared with me is how impressed he is with the way you ask questions on customer calls and just keep digging and digging until you get to something that is an insight for you, and then you start to try to solve the problem for them and think about what the product might be, and I think this is such an important and underappreciated skill for PMs. Is there any advice you could share of just how you approach this, how you ask questions, how you think about these customer calls to get to, "Okay, now, I see what we need to build versus let's just build what they're asking for"?

**中文翻译:**
听你这么说，感觉“好吧，这显然是一个显而易见的解决方案。当然，40% 的人告诉我他们有客户”。但在现实中，大多数时候，如果你听到一堆客户说“嘿，我需要这个自定义字段”，有时你听到这个，有时你听到那个，大多数时候你最终会直接构建那个自定义字段。你们的销售主管跟我分享过，他非常佩服你在客户电话中提问的方式，你会不断挖掘，直到获得某种洞察，然后你开始尝试为他们解决问题，并思考产品可能是什么样子。我认为这对产品经理来说是一项非常重要且被低估的技能。你有什么建议可以分享吗？关于你如何处理这些、如何提问、如何思考这些客户电话，从而达到“好，现在我知道我们需要构建什么，而不是仅仅构建他们要求的东西”？

---

### [00:31:10] Nan Yu

**English:**
My goal is to feel bad in the same way that customers feel bad. They come to us with a request, "Hey, we want X," and it's like there's something motivating it and you can do the normal analytical thing and be like, "Ask five whys," and try to figure out like, "Well, what are your goals?" "And as a persona X, I want to achieve this outcome." You can do it that way, but you might miss the reason that they actually feel bad for not having this thing like, "I can't accomplish this goal. So what?" "So, I'm not going to get promoted at work." Okay, great. I understand the severity of your problem at this point. What is the actual emotional valence that is motivating whatever you're telling me? And it takes a little while to get there. You can ask people directly like, "How do you feel?" And they're not necessarily going to tell you, but if you have a long enough and deep enough conversation with them, you start to level with them, and you're starting to see stuff from their perspective, and the more you see it from their perspective and the more they know that, the more they're willing to open up to you and tell you like, "Okay, honestly, I had this thing happen where I marked the ship date of this project as December 30th because it's a Q4 project, and I wanted to put it at the very end, and then my marketing team lost their mind because they're like, 'We can't ship something on December 30th. Everyone's on vacation,'" and you're like... And then they're like, "Yeah, this has made me feel really bad." So, I don't ever want to put dates on things ever again. So, like, "Okay, cool. We can help you deal with that. If that's what you're feeling, then I can start building stuff to make sure that you never have to have that bad feeling again."

**中文翻译:**
我的目标是像客户那样感到难受。他们带着请求来找我们，“嘿，我们想要 X”，这背后肯定有某种动机。你可以做常规的分析，比如“问五个为什么”，试图弄清楚“你的目标是什么？”“作为角色 X，我想实现这个结果。”你可以这样做，但你可能会错过他们因为没有这个东西而真正感到难受的原因。比如，“我无法完成这个目标。那又怎样？”“那样我就没法升职了。”好，太棒了，到这一步我理解了你问题的严重性。到底是什么样的情绪在驱动你告诉我的这些事情？达到这一步需要一点时间。你可以直接问人“你感觉如何？”，他们不一定会告诉你。但如果你和他们进行足够长、足够深入的交谈，你开始和他们平起平坐，开始从他们的角度看问题，你越是从他们的角度看，他们越能感受到这一点，就越愿意向你敞开心扉。他们会说：“好吧，老实说，我遇到过这种事：我把这个项目的交付日期定在 12 月 30 日，因为它是个第四季度项目，我想把它放在最后。结果我的营销团队疯了，因为他们说‘我们不能在 12 月 30 日发东西，大家都在休假’。”然后他们说：“是的，这让我感觉非常糟糕。所以我再也不想给任何东西定日期了。”于是我会想：“好，没问题，我们可以帮你解决。既然那是你的感受，那我可以开始构建一些东西，确保你再也不会有那种糟糕的感觉。”

---

### [00:32:50] Lenny Rachitsky

**English:**
People talk about empathy like, "You need to have empathy as a PM. You need to build empathy the best product leaders, have empathy in this." I think it's such a succinct and powerful way of describing what empathy actually looks like as a product leader, which is I want to feel as bad as they feel in hearing the story they tell, and it sounds like the way you do that is you keep asking questions to understand the moment they felt bad about something. In this case, the deadline.

**中文翻译:**
人们谈论共情（empathy）时总说：“作为产品经理，你需要有共情能力。你需要建立共情，最好的产品领导者都有共情能力。”我认为这是一种非常简洁且有力的方式来描述产品领导者的共情到底是什么样子的，即：我想在听他们讲故事时，感受到和他们一样强烈的挫败感。听起来你实现这一点的方法就是不断提问，去理解他们对某件事感到难受的那个瞬间。在这个例子中，就是截止日期。

---

### [00:33:17] Nan Yu

**English:**
And if you ask somebody in that last story, like what kind of issue do you have? You're like, "Oh, marketing and I would just never align on anything." It's like that doesn't really tell you what's going on. What it tells you is you had this terrible moment of communication that it's all miscommunicated, and you're like, "It's just going to keep happening over and over again." So, the thing that we did specifically to solve this was on projects in Linear, you can just specify a target date at whatever level of granularity you want. You can say it's a December project. You can say it's a Q4 project. You can say it's a second half of 2024 project. Like whatever you're happy promising, you can just put it on there and that way you never feel like you have to give this sense of false precision so that it ends up with a whole bunch of miscommunication down the line.

**中文翻译:**
如果你问上一个故事里的那个人，你遇到了什么问题？你可能会听到：“哦，营销部门和我永远无法达成一致。”这并不能真正告诉你发生了什么。它告诉你的其实是：你经历了一个糟糕的沟通时刻，全是误解，而且你觉得“这种事会一遍又一遍地发生”。所以，我们专门为了解决这个问题，在 Linear 的项目中，你可以指定任何粒度的目标日期。你可以说这是一个 12 月的项目，也可以说是一个第四季度的项目，或者 2024 年下半年的项目。只要是你乐于承诺的，你就可以放上去。这样你就永远不会觉得必须给出一个“虚假的精确度”，从而避免后续产生一堆误解。

---

### [00:34:04] Lenny Rachitsky

**English:**
I could see why people love Linear is it just makes them feel less bad less often. There's a lot of connection here. I know this idea of emotions and feeling bad is a core part of how you think about building product, looking for moments. People feel bad. Is there anything more you could share there to share how you think about this idea of emotional hooks, emotional moments, and how you decide what to build?

**中文翻译:**
我能理解为什么人们喜欢 Linear 了，因为它就是让人们感到难受的次数变少了。这其中有很多关联。我知道这种关于情绪和“感到难受”的想法是你构建产品、寻找切入点的核心部分。关于这种“情绪钩子”、情绪时刻以及你如何决定构建什么，还有什么可以分享的吗？

---

### [00:35:21] Nan Yu

**English:**
So, to set the background of this, I've worked in very, very competitive industries. I worked at Everlane, which was a direct-to-consumer clothing brand. I worked in Mode, which is like BI tools and there's so many BI tools out there, and then obviously, Linear. We're project management. There's a lot of project management tools, and I think the more competitive your industry is, the more the low-hanging goal-oriented stuff is already picked because every PM from every one of these companies has been asking like, "Well, what's your goal? What is your job to be done," and all this kind of stuff. So, you have to look at things from an angle that other people might not have seen and for me, and for us, it's the angle of where are the emotional hooks that you're experiencing as you go through your work day, as you use our product, as you use competitors' products?

**中文翻译:**
为了说明背景，我曾在竞争非常激烈的行业工作过。我曾在 Everlane 工作，那是一个直接面向消费者的服装品牌；我在 Mode 工作过，那是 BI（商业智能）工具领域，市面上有无数的 BI 工具；然后当然是 Linear，我们做项目管理，项目管理工具也多如牛毛。我认为，你的行业竞争越激烈，那些显而易见的、以目标为导向的东西就越早被挑光，因为这些公司的每个产品经理都在问：“你的目标是什么？你的待办任务（Job to be done）是什么？”之类的问题。所以，你必须从别人可能没看过的角度来看待事物。对我、对我们来说，这个角度就是：在你的一天工作中，在使用我们的产品或竞争对手的产品时，你所经历的“情绪钩子”在哪里？

---

### [00:35:21] Nan Yu

**English:**
I think it's probably underexplored because... I don't know. I feel like PMs and engineers, we're like very thinky people. We avoid the touchy-feely stuff. So, I think that's the opportunity. You can see where are you feeling bad throughout your day where you don't even know? You might think, "I hate Mondays." "Why do you hate Mondays?" "Well, on Mondays, I have to go out and gather a whole bunch of stuff to write this report that it's really annoying." "Oh, so if I gave you a button that made the report, would that help?" It's like, "Oh, yeah, then I might not hate Monday so much." So, I think Paul Graham has a word for this. He calls it schlep blindness, right? It's like I'm schlepping through life, and I'm just completely blind to it, and it's true. You have to have an outsider come in and see what the rhythm of your feelings are throughout the day, throughout the week, and you note the spots where you could really use a lot of improvement.

**中文翻译:**
我认为这可能是一个尚未被充分探索的领域，因为……我不知道，我觉得产品经理和工程师都是非常理性的人，我们倾向于避开那些感性的东西。所以，我认为这就是机会。你可以观察你在一天中哪些地方感到难受，而你甚至自己都没意识到。你可能会想：“我讨厌周一。”“为什么讨厌周一？”“因为周一我得去收集一堆东西来写这份烦人的报告。”“哦，那如果我给你一个按钮能自动生成报告，会有帮助吗？”“噢，是的，那样我可能就没那么讨厌周一了。”保罗·格雷厄姆（Paul Graham）对此有一个词，叫“苦差事盲点”（schlep blindness），对吧？就像我一直在生活中做着各种苦差事，但我对此完全视而不见。确实如此。你必须让一个局外人进来，观察你一天、一周的情绪节奏，并记录下那些真正需要改进的地方。

---

### [00:36:26] Lenny Rachitsky

**English:**
Is there an example? I've shared a couple, but just where you've noticed this in someone using maybe a competitor or even Linear that you solved. I know you gave an example of the dates. I guess is there anything else?

**中文翻译:**
有没有什么例子？我已经分享了几个，但有没有你在别人使用竞争对手产品甚至 Linear 时注意到的、并最终解决的问题？我知道你举了日期的例子，还有别的吗？

---

### [00:36:26] Nan Yu

**English:**
A big feature that people love about Linear is we have this thing called Triage Management, and what it does is it systemizes this thing where if I put an issue into a different team, if I'm asking them to do something or I'm reporting a bug to them, it sticks in a special zone where it'll notify the right people. They're on a rotation and people will be able to respond to it in an organized manner, and I think this kind of automation, this feature, it came out of two different fields people were having. One, people were trying to implement this stuff by hand, and it was just a lot of touches, and they were doing it, but they felt like, "Oh, I'm totally underwater." "Why are you under water?" "Well, I have to throw all these tickets around and route them correctly and stuff like that," and they didn't see this as an opportunity to have a tool specialize in managing their triage queue.

**中文翻译:**
人们非常喜欢 Linear 的一个大功能叫“分流管理”（Triage Management）。它的作用是将这种流程系统化：如果我向另一个团队提交一个问题，或者请求他们做某事，或者向他们报告一个 bug，它会停留在一个特殊区域并通知相关人员。他们有轮班制度，人们可以有条不紊地做出回应。我认为这种自动化功能源于人们的两种不同感受。第一，人们尝试手动处理这些事情，需要大量的操作，虽然他们在做，但感觉“哦，我完全忙不过来了”。“为什么忙不过来？”“因为我得把所有这些工单到处扔，并正确地路由它们之类的。”他们没意识到这是一个让工具专门管理分流队列的机会。

---

### [00:37:23] Nan Yu

**English:**
Because they were managing by hand.... They were on top of it, but it just felt really bad because they just had to spend so much attention doing this and then there's the folks who didn't do that. The feeling was just like, "Well, it's totally out of control. People are just throwing tickets over the wall, and I don't know what to do with them. I don't know where they are. They end up in all these holes and then the people on the other side are like, "I throw tickets over the wall. I have no idea what happens to them. I have no expectation that people are ever going to respond to them." So, there's all of these bad feelings that people are having. They all have the same root cause, which is like there wasn't a very automated organized way to deal with your triage queue.

**中文翻译:**
因为他们是手动管理的……虽然他们能应付，但感觉很糟，因为他们必须投入大量精力。还有一类人根本不处理。那种感觉就是：“好吧，完全失控了。人们只是把工单‘扔过墙’，我不知道该拿它们怎么办，不知道它们在哪，它们最后都掉进了各种坑里。”而另一边的人则觉得：“我把工单扔过墙，完全不知道后续发生了什么，我也不指望有人会回应。”所以，人们会有所有这些糟糕的感觉。它们的根源都一样：没有一种自动化的、有组织的方式来处理分流队列。

---

### [00:38:18] Lenny Rachitsky

**English:**
Marketers, I know that you love TLDRs. So, let me get right to the point. Wix Studio gives you everything you need to cater to any client at any scale, all in one place. Here's how your workflow could look. Scale content with dynamic pages and reusable assets effortlessly. Fast-track projects with built-in marketing integrations like Meta, CAPI, Zapier, Google Ads, and more. A-B test landing pages in days, not weeks with intuitive design tools. Connect to tracking and analytics tools like Google Analytics and Semrush, and capture key business events without the hassle of manual setup. Manage all your client's social media and communications from a unified dashboard, then create schedule and post content across all their channels. If you're on content-rich sites, Wix Studio's no-code CMS lets you build and manage without touching the design. And when you're ready for more, Wix Studio grows with you. Add your own code, create custom integrations with Wix-made APIs, or leverage robust native business solutions. Drive real client growth with Wix Studio. Go to wixstudio.com.

**中文翻译:**
营销人员们，我知道你们喜欢 TLDR（太长不看版）。所以让我直奔主题。Wix Studio 为你提供了一站式服务，满足任何规模、任何客户的需求。以下是你的工作流可能的样子：通过动态页面和可重用资产轻松扩展内容；利用内置的营销集成（如 Meta、CAPI、Zapier、Google Ads 等）加速项目；使用直观的设计工具在几天而非几周内完成落地页的 A/B 测试；连接 Google Analytics 和 Semrush 等追踪分析工具，无需手动设置即可捕捉关键业务事件；从统一的仪表盘管理客户的所有社交媒体和沟通，然后跨渠道创建、排期和发布内容。如果你在做内容丰富的网站，Wix Studio 的无代码 CMS 让你无需触碰设计即可构建和管理。当你准备好迎接更多挑战时，Wix Studio 会随你一同成长。添加你自己的代码，使用 Wix 提供的 API 创建自定义集成，或利用强大的原生业务解决方案。通过 Wix Studio 推动客户的真实增长。请访问 wixstudio.com。

---

### [00:38:55] Lenny Rachitsky

**English:**
I'm going to try to summarize some of the secrets of Linear's success so far. So, the first is get something out as quickly as possible, say, in the first 10% of the time that you have to build this thing and get it out to internal users and then maybe a growing list of beta users and people that are aware of they're using early stuff. Two is prioritize the IC and the user, basically, versus the buyer or the middle manager that wants reporting and all these custom features. So, it's basically focused on the user, which I think you hear a lot, but I love this very specific example. Three is when you hear asks for features and requests, get to the specific person using the thing, not just general, "Okay, cool. I've heard it 100 times." Find the person that actually needs this thing and understand what's going on, and then four is look for people feeling bad in a moment working in the product. Is there anything else that I'm missing that's important or any nuance you want to add?

**中文翻译:**
我来尝试总结一下到目前为止 Linear 成功的秘诀。第一，尽可能快地推出东西，比如在构建时间的最初 10% 内，先发给内部用户，然后是逐渐增加的测试用户群。第二，优先考虑 IC 和用户，而不是买家或想要报告和各种定制功能的中层管理人员。这基本上就是“以用户为中心”，虽然常听到，但我喜欢这个非常具体的例子。第三，当你听到功能请求时，追溯到使用该功能的具体个人，而不仅仅是笼统的“好吧，我已经听过 100 次了”。找到那个真正需要这个东西的人，了解发生了什么。第四，寻找人们在产品中工作时感到难受的时刻。还有什么我遗漏的重要点或你想补充的细节吗？

---

### [00:39:54] Nan Yu

**English:**
The part where you said, like focus on the user, I think it's maybe a little bit more subtle than that. There's a nuance which is find where the incentives are really misaligned amongst your user base. There's a middle manager that wants really detailed reporting and there's a IC who just really doesn't want to go through all those extra steps, and the incentives for what they want are just very... They're just very misaligned, and you have to find those situations and be pretty judicious about how you make those trade-offs and where you can really find win-win outcomes there.

**中文翻译:**
关于你说的“以用户为中心”，我认为可能比这更微妙一点。有一个细节是：找出用户群中利益动机（incentives）严重错位的地方。比如中层管理人员想要非常详细的报告，而 IC 根本不想经历那些额外的步骤。他们想要的东西在动机上是非常……非常不一致的。你必须找到这些情况，并对如何进行权衡保持审慎，看看哪里能真正找到双赢的结果。

---

### [00:40:30] Lenny Rachitsky

**English:**
That's a really important nuance. Something else that's come through a couple of times as you've been talking is also something Patrick Collison tweeted once that has stuck with me, which is this idea of having a mental model in your head of the user. So, the way he described it and the way you've described it is oftentimes people are like, "Cool. We're going to figure out what to build. We're going to do a bunch of research, talk to users. That'll inform what we build, and we build it, versus what you've been saying and what he said is you do a bunch of research, look at data, talk to people. That informs your mental model of what the customer needs in their life, and then that informs what you build. So, that anytime you do more research, talk to customers, it's informing your view of the person, and then you're like, "Oh, this was different from what I imagined," or, "Oh wow. This is exactly what we've been thinking and let's build that." Anything along those lines that you might want to share?

**中文翻译:**
这是一个非常重要的细节。在你谈话中多次出现的另一点，也是 Patrick Collison 曾经发过的一条让我印象深刻的推特，就是关于在脑海中建立用户的“心理模型”。他和你描述的方式是：通常人们会想，“好，我们要决定建什么。我们去做一堆调研，和用户聊聊。这会告诉我们建什么，然后我们就去建。”而你和他所说的是：你做调研、看数据、和人聊天，这些是为了完善你对客户生活中真实需求的心理模型，然后由这个模型来指导你构建什么。这样，每当你做更多调研、和客户聊天时，它都在完善你对那个人的看法，然后你会觉得，“哦，这和我预想的不一样，”或者，“哇，这正是我们一直在想的，那就建这个吧。”关于这一点，你有什么想分享的吗？

---

### [00:41:19] Nan Yu

**English:**
Yeah, I mean, I can tell you a little bit about how we manage our backlog, which I think actually ties directly into this. At any given moment, we have probably 20 or 30 opportunities that we could possibly explore, just product opportunities, like problems to solve, areas to improve for our users, but they're not ready yet. We don't have enough conviction around how we might approach it. So, we just accumulate understanding of this stuff and periodically, we accumulate some more stuff, and then we reevaluate, "Okay, what is our current understanding of how we might best approach this thing?" And I think something that people struggle with is that they might have this model in their head. Like a PM might have this model in their head about how a user behaves, but it's just very hard to share that with someone else. You have to telepathically throw it into their brain, which is hard. So, what we try to do is identify areas that we might attack with a product, but also keep an up-to-date analysis of each of those areas so that everyone can engage with it and also contribute.

**中文翻译:**
是的，我可以告诉你一点我们如何管理积压工作（backlog）的情况，我认为这与此直接相关。在任何特定时刻，我们可能有 20 或 30 个可以探索的机会——仅仅是产品机会，比如要解决的问题、为用户改进的领域——但它们还没准备好。我们对如何处理它还没有足够的信心。所以我们只是不断积累对这些事情的理解，定期再积累一些，然后重新评估：“好，我们目前对如何最好地处理这件事的理解是什么？”我认为人们挣扎的一点是，他们脑子里可能有这个模型。比如一个产品经理脑子里有用户行为的模型，但很难分享给别人。你必须像心灵感应一样把它扔进别人的大脑，这很难。所以我们尝试做的是，确定我们可能用产品攻克的领域，同时也对每个领域保持最新的分析，这样每个人都能参与进来并做出贡献。

---

### [00:42:22] Lenny Rachitsky

**English:**
Is there an example of something that's sitting in your roadmap? I don't know if you could share these sort of things that's just sitting in the backlog of just like, "We're not quite ready to tackle this yet, but here's something we're inkling on."

**中文翻译:**
在你们的路线图中有什么例子吗？我不知道你是否能分享这类东西，就是那种躺在积压工作中，“我们还没准备好处理，但我们已经有了一些苗头”的东西。

---

### [00:42:31] Nan Yu

**English:**
Yeah, sure. Capacity planning is a thing that's been sitting in our backlog, and it's something that we see managers struggle with all the time, which is like I have a limited amount of personnel and resources, and I need to deploy them in such a way where we can theoretically accomplish our roadmap, but also we don't get blocked by some bottleneck that we don't end up blocking all of the projects because this one engineer is stuck on some info thing, and that's a thing people struggle with all the time. All the solutions out there are bad. The best solution is a very, very custom spreadsheet that someone would make, and it's a lot of upkeep. So, we have some ideas about how we might automate this, how we might use existing data within Linear to really help out with this problem, but I don't think we've quite cracked it yet. I think there's some nuances that we have to really explore a little bit further. So, we're continuously developing this, and as we hear from hear from users that are struggling with this problem, we will get on a call with them and sit down with them and talk through it.

**中文翻译:**
有的。比如“产能规划”（Capacity planning）就一直躺在我们的积压工作中。我们看到管理者一直在为此挣扎：我的人员和资源有限，我需要以某种方式部署他们，以便理论上能完成路线图，同时又不会被某些瓶颈卡住，不会因为某一个工程师卡在某个信息点上而导致所有项目停滞。这是人们经常遇到的问题。目前市面上的所有解决方案都很糟糕。最好的方案通常是某人做的一个非常复杂的自定义电子表格，而且维护成本极高。所以我们有一些想法，关于如何自动化这个过程，如何利用 Linear 内部现有的数据来真正帮助解决这个问题，但我认为我们还没完全攻克它。我认为还有一些细节需要进一步探索。所以我们一直在持续开发这个想法，每当我们听到有用户在为此挣扎时，我们就会和他们通个电话，坐下来一起讨论。

---

### [00:43:31] Lenny Rachitsky

**English:**
And the idea there is keep informing this mental model, keep informing what this could be until you get to a place of like, "Okay. Cool. I think we figured out what will really solve this problem in an elegant way"?

**中文翻译:**
所以思路就是不断完善这个心理模型，不断完善它可能的样子，直到你达到一个境界：“好，太棒了。我想我们已经找到了能以优雅方式真正解决这个问题的方法”？

---

### [00:43:42] Nan Yu

**English:**
Yeah, and I want to really stress a nuance here, which is it's not that we want to solve the entire problem. The entire problem is quite big, but there's something that's really right for Linear to do that would help people have a good starting point for them to reason about it. So, I think a lot of building conviction around stuff is not even like do we have a workable solution? It's like how much of the problem should we actually take on? Because if we take on too much of the problem, then we'll end up overpromising and not being able to deliver on it.

**中文翻译:**
是的，我想强调一个细节：并不是说我们要解决“整个”问题。整个问题非常庞大，但有些部分非常适合 Linear 来做，能帮助人们有一个好的起点去思考它。所以，我认为建立信心的很大一部分甚至不在于“我们是否有可行的方案”，而在于“我们到底应该承担多少问题？”因为如果我们承担得太多，最终就会变成过度承诺却无法交付。

---

### [00:44:13] Lenny Rachitsky

**English:**
I think what's also useful here is you all keep your team very small intentionally and being constrained keeps you from taking on these things too early because you don't have the engineers to build their designers.

**中文翻译:**
我认为这里很有用的一点是，你们一直有意保持团队规模非常小。这种约束让你们不会过早地承担这些事情，因为你们没有多余的工程师或设计师去构建它们。

---

### [00:44:24] Nan Yu

**English:**
Yeah, that's true. I actually hadn't really put that part together, but I think some of the reason we've done it this way is because we don't have the bandwidth to action everything. So, we have this backlog that we maintain to make sure that when we do take it on, we're pretty set up for success.

**中文翻译:**
是的，确实如此。我之前还没把这两点联系起来，但我认为我们这样做的一部分原因确实是因为我们没有带宽去处理所有事情。所以我们维护这个积压工作，以确保当我们真正开始做某件事时，我们已经为成功做好了充分准备。

---

### [00:44:41] Lenny Rachitsky

**English:**
Yeah, it's interesting. I think a lot of companies are starting to realize that they can build better products and move faster with fewer teams. I want to move in a different direction and talk a bit about how you actually think about building new products. Something that I've heard from you is that you have a systemized way of being creative, which I think is a dream for a lot of people's. It's like how do I be more creative? How do I think of new innovative concepts? You have a really interesting process for how you do this. Can you talk about it?

**中文翻译:**
是的，很有意思。我认为很多公司开始意识到，用更少的团队可以构建更好的产品并跑得更快。我想换个方向，谈谈你究竟是如何思考构建新产品的。我听你说过，你有一套系统化的创意方法，我觉得这是很多人的梦想：我该如何变得更有创意？我该如何构思新的创新概念？你有一套非常有趣的流程，能谈谈吗？

---

### [00:45:09] Nan Yu

**English:**
Yeah, totally. I think when people talk about being creative, a lot of times what they have a problem with is extrapolating. They can see the stuff that's right in front of them, but what about two or three steps down the line? And then it's just like, "Well, there's just so much possibility. I don't know what direction to go." So, the way that we try to do it is we ask a question which is like, "Okay, how extreme can you take it? You're designing a product. You're trying to come up with a solution. What's the most outrageous version of this along some trait?" I don't know if you guys did this at Airbnb, but I think Brian Chesky talks about like, "What's the 11-star experience?" Is that a thing you guys did?

**中文翻译:**
当然可以。我认为当人们谈论创意时，很多时候他们的问题在于“推断”。他们能看到眼前的东西，但两三步之后呢？然后就会觉得，“好吧，可能性太多了，我不知道该往哪个方向走。”所以，我们尝试的方法是问一个问题：“好吧，你能把它推向多大的极端？你在设计一个产品，你在尝试想出一个解决方案。沿着某个特性，最离谱的版本是什么样的？”我不知道你们在 Airbnb 是否这样做过，但我记得 Brian Chesky 谈过“什么是 11 星级体验？”，你们做过这个吗？

---

### [00:45:51] Lenny Rachitsky

**English:**
It was a thing he talked about. Yeah, there's always a push of what's the 10X version of some idea.

**中文翻译:**
他确实谈过这个。是的，总会有一种推力去思考某个想法的 10 倍版本是什么样的。

---

### [00:45:57] Nan Yu

**English:**
When you think in that way, when you're asking is like, "Hey, what's the 11-star experience?" What you're really asking is like, "Hey, what's the most luxurious version of this hotel stay? Or what's the most unforgettable kind of experience we can give people?" And you throw away things, I don't know, like cost. You throw away things like practicality because that's not what's interesting. What's interesting is I want to actually explore the possibility space, and I think this is really important to do because the goal is to get you to see beyond your defaults. We have all of these constraints that we're operating under that we psychically have in the back of our heads that we just don't even realize we have them. So, just break past all of them, and then you can really see what your options are because we talk about product decisions. It's like, "Oh, yeah, you have these choices. What are you going to decide?" There's all this decision-making kind of theory.

**中文翻译:**
当你那样思考时，当你问“什么是 11 星级体验？”时，你真正问的是：“这次酒店住宿最豪华的版本是什么？或者我们能给人们带来的最难忘的体验是什么？”你会抛开成本，抛开实用性，因为那些现在还不重要。重要的是我想真正探索可能性的空间。我认为这样做非常重要，因为目标是让你看到“默认设置”之外的东西。我们在各种约束下运作，这些约束潜伏在我们的脑海深处，我们甚至没有意识到它们的存在。所以，打破所有这些约束，然后你才能真正看到你的选择。因为我们谈论产品决策时，总是说，“哦，你有这些选择，你会决定哪一个？”这有一整套决策理论。

---

### [00:46:52] Nan Yu

**English:**
But the biggest risk is you didn't see the right choice to begin with. You have these three choices and none of them were right. It's this fourth one that was over in this corner, but you didn't look in that corner, so you never found it. So, I think the whole goal of this is to try to expand the search space of what you're trying to do.

**中文翻译:**
但最大的风险是你从一开始就没看到那个正确的选择。你有这三个选择，但没一个是对的。正确的其实是角落里的第四个，但你没往那个角落看，所以你永远找不到它。所以，我认为整个目标就是尝试扩大你正在做的事情的搜索空间。

---

### [00:47:09] Lenny Rachitsky

**English:**
So, what you're saying is people often don't think out of the box enough by not thinking too radically enough. So, the choices they're deciding between are just meh options and there's this process of breaking out of that, and I think you could hear this and be like, "Yeah, sure." I could spend 10 minutes being like, "Oh, hey, what's the craziest..." but you're saying that actually is what you do and that actually works really well?

**中文翻译:**
所以你的意思是，人们通常因为想得不够激进而导致想得不够开阔。所以他们在做选择时，面对的只是一些平庸的选项。而打破这种局面的过程就是……我想听众可能会觉得，“好吧，当然可以。”我可以花 10 分钟想“哦，最疯狂的是什么……”，但你是说你们真的会这么做，而且效果非常好？

---

### [00:47:39] Nan Yu

**English:**
Yeah, and you actually build it. You can think of a very extreme version of a product and you can say, "Hey, let's actually... " For the first version, we talked about, like the first version, you know it's not really the right answer. Sometimes, you know it's so hard because you know this is the most extreme version of the answer. So, let's build that as fast as we can and see how it feels, and then we're going to learn so much about what the right actual answer is because we have seen this area of the product space and really felt it.

**中文翻译:**
是的，而且你真的会去构建它。你可以构思一个非常极端的产品版本，然后说，“嘿，让我们真的……”对于第一版，我们说过，你知道它不一定是正确答案。有时这很难，因为你知道这是答案的最极端版本。但让我们尽可能快地构建它，看看感觉如何。然后我们会学到很多关于真正正确答案的知识，因为我们已经见识过并真正感受过产品空间的那个领域。

---

### [00:48:05] Lenny Rachitsky

**English:**
Awesome. Let's talk about an example of this because this feels awesome.

**中文翻译:**
太棒了。让我们聊聊这方面的例子，因为这听起来很酷。

---

### [00:48:09] Nan Yu

**English:**
Yeah, I can talk to an example. Actually, is it okay if I demo something?

**中文翻译:**
好，我可以举个例子。实际上，我可以演示一下吗？

---

### [00:48:13] Lenny Rachitsky

**English:**
Absolutely. Let's do it. Show and tell.

**中文翻译:**
当然可以。来吧，边看边说。

---

### [00:48:18] Nan Yu

**English:**
All right. So, this is just like a demo space instead of Linear. So, the feature where we did this that I remember very clearly, because it was recent, is we built this feature to save drafts for your issues. So, Linear, as hard as an issue tracker, if I make a new issue and let's say I'm trying to report a bug or something, so it's like I make a bug report, then I might start thinking through like, "Okay, what are the repro steps?" And then I start typing them, and this happens all the time. When you're at work, you're doing this and someone distracts you. If someone pings you on Slack or you have to go to a meeting or something like that, you're like, "I got to put this away for a second. I'll come back to it later." Note to self, figure out the actual repro steps and do it.

**中文翻译:**
好的。这只是 Linear 里的一个演示空间。我记忆非常清晰的一个应用了这个方法的例子（因为是最近做的），就是我们构建的“工单草稿保存”功能。Linear 核心是一个工单追踪器。如果我新建一个工单，假设我要报告一个 bug，我会写个 bug 报告，然后开始思考：“好吧，复现步骤是什么？”然后我开始打字。这种情况经常发生：你在工作时做这件事，突然有人打断你。如果有人在 Slack 上找你，或者你得去开会，你会想：“我得先把它放一边，待会儿再回来。”提醒自己，弄清楚实际的复现步骤再做。

---

### [00:48:56] Nan Yu

**English:**
So, what can you do? Well, you want to save it as a draft. So, we're like, "Okay, this is the problem," and the first version of this, we're like, "What do we want to do? Linear is about being fast." So, we don't want to get in your way. We want to say like, "What is the fastest draft saving experience possible?" So, if you save it as draft, you can save it as draft. If you decide to not... you want to throw it away, you don't want it, just hit the X button, and it'll just throw it away. We're not going to interrupt you with a popup that says like, "Do you want to save your changes," or any of that kind of stuff. We'll just absolutely get out of your way fast as possible. So, we're like, "What's the risk here?" Well, it might feel really unsafe.

**中文翻译:**
那么你能做什么呢？你想把它存为草稿。所以我们想，“好，这就是问题所在。”第一版时我们想，“我们要怎么做？Linear 的核心是快。”所以我们不想挡你的路。我们想，“最快的草稿保存体验是什么样的？”所以，如果你想存草稿，就存。如果你决定不要了，想扔掉，直接点 X 按钮，它就消失了。我们不会弹出一个窗口问你“你想保存更改吗？”之类的话。我们会尽可能快地避开你。但我们想，“这里的风险是什么？”好吧，这可能会让人觉得非常不安全。

---

### [00:49:31] Nan Yu

**English:**
If you close this, and we don't ask you if you want to save change, you might feel like, "Oh, I just lost my changes on accident." We knew that going in. We built this anyway, and it felt super unsafe. It turns out that sort of inkling that we had was true, and we really felt exactly how unsafe it was. So, then we were like, "Okay, well, what's the safest thing we could possibly do?" The safest thing is just auto save everything. So, you start a new issue, and then you start typing some stuff, and it's just like auto saving as soon as you type a single character and that did feel quite safe. So, cool, but it also ended up leaving behind a whole bunch of like a paper trail of things you change your mind about. You've probably had this happen in document tools where you have a whole bunch of things in your space called like Untitled Document or New Document and stuff like that. It's just like-

**中文翻译:**
如果你关闭它，而我们不问你是否要保存，你可能会觉得，“哦，我不小心弄丢了我的更改。”我们预见到了这一点，但我们还是这么做了，结果感觉确实超级不安全。事实证明我们的直觉是对的，我们真切地感受到了那种不安全感。于是我们想，“好吧，那我们能做的最安全的事情是什么？”最安全的就是自动保存一切。你开始新建工单，打一些字，只要你打一个字符，它就自动保存。这确实感觉很安全。很好，但它也导致留下了一大堆你改变主意后的“纸面痕迹”。你可能在文档工具里遇到过这种情况：你的空间里有一堆叫“无标题文档”或“新建文档”之类的东西。就像——

---

### [00:50:24] Lenny Rachitsky

**English:**
So many untitled folders.

**中文翻译:**
超多无标题文件夹。

---

### [00:50:25] Nan Yu

**English:**
Yeah, so many untitled folders because the moment you say new folder, it starts saving it, and then you don't actually mean for that to happen. So, we had those two sorts of variations that we built, and we fell through and where we ended up was a balance between those two. So, what happens is if I'm creating a new issue, like I am here, and I close it out, it'll interrupt me, like we have to interrupt you, otherwise it feels too unsafe. So, I can save the draft, I can go to my drafts, and then if I'm in this draft I've already made, and I go in there, and I start to say, "Okay, I'm going to keep working on it," but then I get interrupted again, then I'm just going to auto-save it for you. There's no point. I'm not going to ask you again.

**中文翻译:**
是的，超多无标题文件夹，因为你一点“新建文件夹”，它就开始保存，而你其实并不想让它发生。所以我们构建了这两类变体，并进行了尝试，最后我们找到了两者的平衡点。现在的做法是：如果我正在创建一个新工单（就像我现在这样），然后我关闭它，它会中断我——我们必须中断你，否则感觉太不安全了。我可以保存草稿，去查看我的草稿。而如果我已经在处理一个现有的草稿，我进去继续写，然后又被打断了，这时我就直接为你自动保存。没必要再问你一次了。

---

### [00:51:06] Nan Yu

**English:**
I'm always going to auto save it because I'm not going to create a new object. I'm just making modifications in place. So, we made this very specific choice of on a brand new issue, we will interrupt you, and then on an existing draft that you're messing around with, we're just going to auto save everything and someone doing a analysis. If they did a detailed teardown of these decisions, they might say like, "Wow, they made very specific choices here," but the path to get there is to do something totally extreme in one direction and then totally extreme in another direction and then find where they really meet up.

**中文翻译:**
我会一直自动保存它，因为我没有创建一个新对象，我只是在原处进行修改。所以我们做了一个非常具体的选择：对于全新的工单，我们会中断你询问；而对于你正在处理的现有草稿，我们就直接自动保存一切。如果有人对这些决策进行详细拆解，他们可能会说：“哇，他们在这里做了非常具体的选择。”但通往这里的路径是：先向一个方向做到极致，再向另一个方向做到极致，然后找到它们真正的交汇点。

---

### [00:51:39] Lenny Rachitsky

**English:**
Such a good example, the way that you described it is you went like here's the safest route. Here's the fastest version. Where did you come up with these list of options? And for folks that are trying to do this for their company, are these like... Because these are Linear principles, we're going to be very fast. Is this the way you think most companies should operate these sorts of attributes? Do you think it's specific to what makes their product different? How do you think about that?

**中文翻译:**
真是个好例子。你描述的方式是：这是最安全的路径，这是最快的版本。你是从哪里想到这些选项列表的？对于那些想在自己公司尝试这种方法的人来说，这些属性是……因为这些是 Linear 的原则（我们要非常快）。你认为大多数公司都应该围绕这类属性运作吗？还是你认为这取决于让他们的产品与众不同的特质？你怎么看？

---

### [00:52:04] Nan Yu

**English:**
I think for a lot of companies, you have to ask, "What is the promise that your product or your business is making people?" It might be you always have a car available if you need it, and if you do that, then maybe we're going to have to implement search pricing to make that happen. It's always going to be available. So, here's the trade-off that we have to make. It's a very extreme point of view to do that. Or you might say the price is always predictable, but sometimes you can't have a car in the first place. Those are all choices that you get to make, and you have to sort decide, like where in that spectrum does it make sense based on the promise of your company?

**中文翻译:**
我认为对于很多公司来说，你必须问：“你的产品或业务对人们的承诺是什么？”可能是“只要你需要，随时都有车可用”。如果你承诺这个，那么也许我们必须实施动态调价来实现它。车永远可用，这就是我们必须做的权衡。这是一个非常极端的观点。或者你可能会说“价格永远是可预测的”，但代价是有时你根本打不到车。这些都是你可以做的选择，你必须决定，基于你公司的承诺，在这个光谱的哪个位置最有意义？

---

### [00:52:40] Lenny Rachitsky

**English:**
A lot of people talk about this idea of working backwards. Brian Chesky in Airbnb has a big concept of working backwards from the ideal. Let's design the best possible scenario and work backwards. I love that this is even more tactical, which is just pick the extreme version of very specific attributes. Probably not that ideal, but it'll give us insight into a version of the ideal and an element that works well and then what doesn't. Yeah, exactly. I did this a lot actually at Airbnb, just like testing the extreme. So, it super resonates, this idea, and when you say test, so was it like you build it and play with it? Do you roll it out to some of these circles of users or is it often just internal, and then you learn and then iterate?

**中文翻译:**
很多人谈论“逆向工作”（working backwards）的想法。Airbnb 的 Brian Chesky 有一个核心概念，就是从理想状态逆向推导：设计出最完美的场景，然后往回推。我喜欢你这个更具战术性的方法，即：挑选非常具体属性的极端版本。虽然可能不理想，但它能让我们洞察理想版本的一个侧面，以及哪些元素运作良好，哪些不行。没错。我在 Airbnb 时也经常这么做，就是测试极端情况。所以这个想法非常有共鸣。当你所说“测试”时，是指你们构建出来并试用吗？你们会把它发布给某些用户圈子吗？还是通常只是内部测试，然后学习并迭代？

---

### [00:53:23] Nan Yu

**English:**
Yeah, we rolled out some of these versions to people.

**中文翻译:**
是的，我们确实把其中一些版本发布给了一些人。

---

### [00:53:25] Lenny Rachitsky

**English:**
Oh, wow. Okay.

**中文翻译:**
噢，哇。好的。

---

### [00:53:27] Nan Yu

**English:**
So, the super-fast version that was unsafe, that only went interna, and everyone felt it was too unsafe, but then we thought, "Okay, let's go to the super-safe version," and then we rolled that out and everyone started having a whole bunch of... Like how many drafts are people making? I'm like, "This is too many." The people are leaving behind this crazy paper trail. Okay, we got to figure out some difference here.

**中文翻译:**
那个不安全的超快版本只在内部发布，大家都觉得太不安全了。然后我们想，“好，试试超安全版本”，我们发布了那个版本，结果每个人都开始产生一大堆……“人们到底建了多少草稿？”我想，“这太多了。”人们留下了疯狂的纸面痕迹。好吧，我们得找出其中的差异。

---

### [00:53:46] Lenny Rachitsky

**English:**
Awesome. So, this very much connects to your first point of get things out really quick, and in this case, it's like extreme versions. You're probably not going to work long term, but it will teach you.

**中文翻译:**
太棒了。所以这非常契合你的第一点：快速推出东西。在这种情况下，就是极端版本。虽然长期来看可能行不通，但它能教会你很多。

---

### [00:53:56] Nan Yu

**English:**
Yeah, exactly.

**中文翻译:**
是的，没错。

---

### [00:53:58] Lenny Rachitsky

**English:**
Amazing. Okay, and seeing it in action, I'm like, "Okay, obviously, this is the solution," and that's how the way this should feel, and to your point, it was not an obvious solution when you started thinking about it.

**中文翻译:**
太神奇了。看到它实际运行，我会觉得，“好吧，这显然就是解决方案”，这就是它该有的感觉。正如你所说，当你刚开始思考时，这并不是一个显而易见的方案。

---

### [00:54:08] Nan Yu

**English:**
Yeah. I mean, the best solutions are always obvious in hindsight, and it's just like you have to develop a process internally that to eventually find your way there.

**中文翻译:**
是的。我的意思是，最好的解决方案在事后看来总是显而易见的，你只需要在内部建立一套流程，最终找到通往那里的路。

---

### [00:54:16] Lenny Rachitsky

**English:**
Something else that you've mentioned when we were chatting that connects to some of the things we've been talking about is you have this perspective that B2B software isn't just solving people's problems, it's also teaching them how to work, and it's this accumulation of information. Can you talk about that? Because I thought that was really fascinating.

**中文翻译:**
我们聊天时你提到的另一件事，也与我们讨论的内容有关：你认为 B2B 软件不仅仅是在解决人们的问题，它还在教人们如何工作，这是一种信息的积累。你能谈谈这个吗？因为我觉得这非常迷人。

---

### [00:54:38] Nan Yu

**English:**
If you think about how a lot of B2B software gets created, it's because there was some person in the middle of some giant company who implemented some kind of process, and they're like, "Wow, this process is really working for us. Maybe we should make it easier," and they build a little tool internally and then all of their colleagues can now press on buttons and good things happen, and then they turn that process and that tool. They spin it off into a startup, and they make a startup. This process repeats thousands of times. So, when you adopt that tool, you're not just adopting the actual software, you're adopting the idea that this is a practice that you ought to be doing in the first place. So, if you're a marketing person, and you adopt some marketing software, you're not just saying, "Okay, now, I can write emails and send them to people."

**中文翻译:**
如果你思考一下很多 B2B 软件是如何诞生的，通常是因为某家大公司里的某个人实施了某种流程，他们觉得，“哇，这个流程对我们非常有效，也许我们应该让它变得更容易。”于是他们在内部做了一个小工具，然后所有的同事都可以通过点点按钮来完成工作。接着，他们把这个流程和工具剥离出来，成立了一家初创公司。这个过程重复了成千上万次。所以，当你采用那个工具时，你不仅仅是在采用软件本身，你是在采用一种理念，即“这是一种你本来就应该做的实践”。所以，如果你是一名营销人员，你采用了一些营销软件，你不仅仅是在说，“好吧，现在我可以写邮件并发送给人们了。”

---

### [00:55:24] Nan Yu

**English:**
There's all sorts of process around that. You're organizing stuff into campaigns. You're measuring click-through rates. You're calculating cost of acquisition and all that stuff probably comes equipped with a tool because those are the right practices to do when you're doing this sort of marketing exercise. And whether you knew about it before or you learned it from the tool, like as a buyer for this kind of product, what I'm doing is I'm saying like, "Hey, I'm going to bring in this baseline level of marketing competency into my organization, that this is the worst we can do is whatever the tool defaults are."

**中文翻译:**
这背后有一整套流程。你正在将内容组织成营销活动，你在衡量点击率，你在计算获客成本，所有这些东西通常都配备在工具里，因为这些是进行此类营销活动时的正确实践。无论你以前是否知道，或者你是从工具中学到的，作为这类产品的买家，我实际上是在说：“嘿，我要为我的组织引入这种营销能力的基准线，我们能做的最差程度就是工具的默认设置。”

---

### [00:55:58] Lenny Rachitsky

**English:**
Interesting. So, you're basically buying into a way of working when you're adopting a piece of software, not just have this problem I need solved.

**中文翻译:**
很有意思。所以当你采用一个软件时，你基本上是在认同一种工作方式，而不仅仅是有一个需要解决的问题。

---

### [00:56:06] Nan Yu

**English:**
Yeah, exactly, and I think the most salient example of this is if you've ever seen like a company adopt an ERP (Enterprise Resource Planning) product, it's the most painful thing you can imagine. It's doing deep surgery. They have to redo all of their internal processes and the way they manage inventory and all this kind of stuff, but they're willing to do it because they know that this is a battle-tested way of making sure that you're actually doing good management of resources. So, they're like, "We're growing up now. It's time for us to adopt these best practices. In order to do that, we have to adopt this tool, and we will conform to whatever the tool is best is to do."

**中文翻译:**
是的，没错。我认为最显著的例子就是如果你见过一家公司采用 ERP（企业资源计划）产品，那是你能想象到的最痛苦的事情。这就像在做深层手术。他们必须重做所有的内部流程、库存管理方式等等。但他们愿意这样做，因为他们知道这是一种经过实战检验的方式，能确保你真正做好了资源管理。所以他们会想，“我们现在长大了，是时候采用这些最佳实践了。为了做到这一点，我们必须采用这个工具，我们将顺应这个工具认为最好的做法。”

---

### [00:56:44] Lenny Rachitsky

**English:**
This connects to a couple things I know about Linear, one is what you've shared of just avoiding these customizations requests from people. Do you have a very opinionated way of here's how you should operate in order to build a great functioning product, org, and company in general? I'm just connecting threads here. One is like we're going to avoid letting people customize too much because we know they'll have a bad time, and then two is just this idea of we are opinionated about the way you should work in Linear, and it's like you have a Linear method, I think it's called, of just like here's how product team should operate based on everything we've seen be successful.

**中文翻译:**
这与我了解的关于 Linear 的几件事有关。一是你分享的关于拒绝人们的定制化请求。你们是否有一套非常“固执己见”（opinionated）的方法，认为为了建立一个运作良好的产品、组织和公司，你应该这样操作？我正在把这些线索串起来：一是我们避免让人们过度定制，因为我们知道那会让他们体验变差；二是关于“我们在 Linear 中对你应该如何工作是有立场的”，就像你们有一个叫“Linear Method”的东西，基于你们所见过的所有成功案例，规定了产品团队应该如何运作。

---

### [00:57:19] Nan Yu

**English:**
Yeah. Yeah. It's definitely connected in a way, and I think sometimes when people talk about... You mentioned like being opinionated, and I think sometimes when people talk about being opinionated, it can feel like they're almost saying like, "Hey, this is arbitrary," like your opinion and my opinion, they're just too opinions, man. Neither is right or wrong. What we try to do is find where there's actual consensus amongst a lot of different high performing teams, and then we can take those practices and say like, "Okay, for a team that isn't already practicing this, can we give them a button so that they can start practicing this?"

**中文翻译:**
是的，这确实是有联系的。我认为有时当人们谈论……你提到“固执己见”，我觉得有时当人们谈论这个词时，感觉就像在说“嘿，这是随意的”，就像你的意见和我的意见，只是两种不同的看法，伙计，没谁对谁错。而我们尝试做的是，在许多不同的高效团队中寻找真正的“共识”，然后我们将这些实践拿过来并说：“好吧，对于一个还没有这样做的团队，我们能不能给他们一个按钮，让他们可以开始这样实践？”

---

### [00:57:56] Nan Yu

**English:**
When we see companies doing a really good job of managing their triage queue, but it's very manual, we're like, "Okay, can we automate this? And then for this other company that really needs it that they don't know this is what they need, can we just give them a button to activate this?" And now they have the practice within their org, too.

**中文翻译:**
当我们看到有些公司在管理分流队列方面做得很好，但全是手动的，我们会想：“好，我们能把它自动化吗？然后对于另一家真正需要它但还不知道自己需要的公司，我们能不能直接给他们一个按钮来激活它？”这样，他们的组织内部也就拥有了这种实践。

---

### [00:58:10] Lenny Rachitsky

**English:**
So, I think the takeaway here is when you choose a tool, recognize it's going to change the way you operate and be thoughtful about is this the way we want to work versus just we just have a problem we want solved?

**中文翻译:**
所以我想这里的启示是：当你选择一个工具时，要意识到它会改变你的运作方式，并深思熟虑“这是我们想要的工作方式吗？”，而不仅仅是“我们有一个问题需要解决”。

---

### [00:58:21] Nan Yu

**English:**
Yeah, exactly.

**中文翻译:**
是的，没错。

---

### [00:58:22] Lenny Rachitsky

**English:**
I want to come back to something, a thread that's come up a couple of times in our chat is the way you collaborate internally. It feels like there's a pretty unique way. You said you were on all the sales calls. Is there anything that you can share about how you collaborate internally, how the different functions collaborate that may be unlike how other companies operate that might be helpful for them to learn from?

**中文翻译:**
我想回到一个话题，在我们的聊天中出现过几次的线索，就是你们内部协作的方式。感觉有一种非常独特的方式。你说你参加了所有的销售电话。关于你们内部如何协作、不同职能部门如何协作，有没有什么与众不同的地方，是值得其他公司学习的？

---

### [00:58:44] Nan Yu

**English:**
Yes. Something that's worked really, really well for us is we think of product management as partially like a go-to-market discipline in the same way that sales and marketing are, right? When you talk to people and like, "Hey, tell me how product management works in your company," they'll probably say something about like, "Well, there's engineering product and design. They work in this triad, and here's how they interact and collaborate," and we all understand why that's useful, why that's helpful, but this other form of collaboration between product management, sales and marketing, I think it's something that's probably really underexamined and often I feel like in organizations, you actually see some antagonism between product and sales and marketing, and I think that's a shame because when we come together, the way we think about the way that we think about selling is a matter of like... especially because we sell to very expert practitioners, and they have a very sensitive BS detector.

**中文翻译:**
是的。对我们非常有效的一点是，我们将产品管理部分视为一种“转到市场”（go-to-market）的学科，就像销售和营销一样。当你问别人，“嘿，告诉我你们公司的产品管理是怎么运作的，”他们可能会说，“哦，有工程、产品和设计，他们以‘三位一体’的方式工作，这是他们互动和协作的方式。”我们都理解为什么这很有用。但产品管理、销售和营销之间的另一种协作形式，我认为是被严重低估的。通常在组织中，你实际上会看到产品部门与销售、营销部门之间存在某种对立，我觉得这很可惜。因为当我们聚在一起时，我们思考销售的方式是……特别是由于我们卖给的是非常专业的从业者，他们有非常灵敏的“胡扯探测器”。

---

### [00:59:51] Nan Yu

**English:**
So, a big part of what we try to do is we try to help our marketing team pick exactly the right word and the right phrasing to make us sound native to the language that our customers speak and also-

**中文翻译:**
所以我们努力做的很大一部分工作是，帮助我们的营销团队挑选完全正确的词汇和措辞，让我们听起来像是使用客户母语的人，而且——

---

### [00:59:51] Lenny Rachitsky

**English:**
You're talking about engineers is my sense, right?

**中文翻译:**
我感觉你指的是工程师，对吧？

---

### [01:00:07] Nan Yu

**English:**
Yeah. Engineers is a big one, but even product managers, right? Like product managers know when... They know what the job is like. So, when you come in, you say the wrong words, people give you stink eye.

**中文翻译:**
是的，工程师是很大一部分，但甚至包括产品经理，对吧？产品经理知道……他们知道这份工作是什么样的。所以当你进来，说了错误的词，人们会给你白眼。

---

### [01:00:17] Lenny Rachitsky

**English:**
Don't call them project managers.

**中文翻译:**
别把他们叫成项目经理。

---

### [01:00:19] Nan Yu

**English:**
Yeah, exactly, for example. So, I think that's a big part of what we have to do. So, on our PM team, we actually have a full-time product marketer, and her job is to... Tactically, it's like all the change logs come from her, all the release notes, and also she's always crafting the language for whatever upcoming release that we're building and working directly with the teams and trying to figure out how to talk about it, and then once we go out and build the campaigns, build assets and things like that, that's where a lot of the language is coming from. It's coming from the work that she's doing and then with sales, they're validating all that message in the field. They're saying the words to customers directly and telling you if it's sticking or not, and then you can have a really good feedback cycle between those three disciplines.

**中文翻译:**
是的，没错，这就是个例子。所以我认为这是我们必须做的重要部分。在我们的产品经理团队中，实际上有一名全职的产品营销人员（PMM），她的工作是……从战术上讲，所有的更新日志（change logs）、所有的发布说明都出自她手。此外，她一直在为我们正在构建的任何即将发布的版本设计语言，直接与团队合作，尝试找出如何描述它。一旦我们开始建立营销活动、构建素材等，很多语言都源于她的工作。然后通过销售，他们在实战中验证这些信息。他们直接对客户说出这些话，并告诉你是否奏效。这样，你就在这三个学科之间建立了一个非常好的反馈循环。

---

### [01:01:18] Nan Yu

**English:**
Yeah, I think PMs, like product managers, we often have a tough time trying to explain like, "What is your job?" It's a little bit of everything. I think the job that I do that we see it as is you're taking the building side of the organization and the selling side of the organization and bringing it together. You're taking all of the commercial motivations and goals of the company and making sure that what you build actually solves for those goals, and you're tempering that with what's possible and where the opportunities are to actually build stuff. So, to me, it's the PM in the middle, and then you have engineering, product design, and then sales, marketing, product management on the other side.

**中文翻译:**
是的，我认为产品经理通常很难解释“你的工作是什么？”它什么都沾一点。我认为我所做的工作，或者说我们看待它的方式是：你把组织的“建设端”和“销售端”结合在一起。你把公司所有的商业动机和目标拿过来，确保你构建的东西真正能实现这些目标，并根据可能性和实际构建机会来调节这些目标。所以对我来说，PM 在中间，一边是工程、产品设计，另一边是销售、营销和产品管理。

---

### [01:02:03] Lenny Rachitsky

**English:**
PM is always in the middle-

**中文翻译:**
PM 总是处于中间位置——

---

### [01:02:05] Nan Yu

**English:**
Indeed.

**中文翻译:**
确实。

---

### [01:02:06] Lenny Rachitsky

**English:**
... but I think that's true from the perspective of PM, and I love this visual of just the PM is connecting the builders to the sellers, and you're involved in both worlds. This connects very directly to Brian Chesky's whole thing about how PMs should be doing marketing. So, the way they changed it, every PM is also PMM, and there's no more... They're product marketers now. That's their title and that's like the extreme version of what you're describing.

**中文翻译:**
……但我认为从 PM 的角度来看确实如此。我喜欢这个视觉形象：PM 连接着建设者和销售者，你同时参与这两个世界。这直接联系到 Brian Chesky 的观点，即 PM 应该做营销。所以他们改变了做法，每个 PM 也是 PMM，不再有……他们现在的头衔是产品营销经理。那是你所描述的极端版本。

---

### [01:02:33] Nan Yu

**English:**
Yeah. Yeah, and I think Apple's been doing that way for forever, too.

**中文翻译:**
是的，我想苹果公司也一直都是这么做的。

---

### [01:02:37] Lenny Rachitsky

**English:**
Got it. So, the advice here is if you're a PM at a B2B business, lean into the sales and marketing side of it, lean into the go-to-market.

**中文翻译:**
明白了。所以这里的建议是：如果你是 B2B 业务的产品经理，要向销售和营销端倾斜，向“转到市场”端倾斜。

---

### [01:02:45] Nan Yu

**English:**
Yeah, and in fact, if you're leaving something on the table in terms of the kind of impact that you are having at your job, that's probably the thing that you're leaving on the table. You're probably already doing a good job of collaborating with engineering and design. It's probably the sort of sell side that there's an opportunity for you to have more impact.

**中文翻译:**
是的，事实上，如果你觉得自己在工作中还有未发挥的影响力，那很可能就在这一块。你可能已经在与工程和设计协作方面做得很好，但在“销售端”，你可能有机会产生更大的影响。

---

### [01:03:05] Lenny Rachitsky

**English:**
Just to make it even more concrete for PMs that are like, "Okay, I want to do this. I want to do what Linear's doing. I'm going to get more salesy." What does it look like when someone is more is in this double triangle working more closely with sales? You talked about being on sales calls. What else there can you share of just like, "Here, try these things"?

**中文翻译:**
为了让那些想“好，我也想这么做，我想像 Linear 那样，变得更具销售思维”的产品经理们有更具体的参考：当一个人处于这个“双三角形”中，与销售更紧密地合作时，具体是什么样的？你谈到了参加销售电话，还有什么可以分享的吗？比如“试试这些事”？

---

### [01:03:20] Nan Yu

**English:**
I think originate the message that you send to your audience. There's a lot of things that marketing does, which you are never going to necessarily touch. There's always demand gen and figuring out channel strategy and all this kind of stuff, like sure. That's a peer marketing concern, but actually picking the words and where the emphasis is, like you should understand the customer at a pretty deep level, probably deeper than any other group at the company because of the kinds of requirements gathering, discovery that you're doing. So, you're going to know the native language that your customers speak a lot better and help your marketing team originate those words.

**中文翻译:**
我认为是“发起”你发送给受众的信息。营销部门做的很多事情你未必会碰，比如需求挖掘、确定渠道策略等等，当然，那是纯营销范畴。但实际挑选词汇和确定重点，你应该在相当深的层面上了解客户，可能比公司任何其他团队都深，因为你一直在做需求收集和调研。所以，你会比别人更了解客户的“母语”，并帮助营销团队构思这些词汇。

---

### [01:03:58] Lenny Rachitsky

**English:**
Got it. So, basically be really involved in the product marketing, the writing, the emails, the headlines, the website?

**中文翻译:**
明白了。所以基本上是深入参与产品营销、文案写作、邮件、标题和网站内容？

---

### [01:04:06] Nan Yu

**English:**
Yeah, yeah, exactly. I know the word product marketing is also so overloaded. They do so many different things, but it's that sort of content creation piece that you really have an opportunity to contributes to.

**中文翻译:**
是的，没错。我知道“产品营销”这个词承载了太多含义，他们做很多不同的事情，但正是那种“内容创作”部分，是你真正有机会做出贡献的地方。

---

### [01:04:16] Lenny Rachitsky

**English:**
Yeah, I love how concrete that is. It's like don't think about this concept, product marketing. Just think about the words that your potential customers and customers see. Okay, final area I want to spend a lot of time on is totally different. It's around getting a job.

**中文翻译:**
是的，我喜欢这种具体感。就像不要去想“产品营销”这个抽象概念，就去想潜在客户和现有客户看到的那些文字。好，最后一个我想花点时间讨论的领域完全不同：关于找工作。

---

### [01:04:31] Nan Yu

**English:**
Oh, yeah. Okay.

**中文翻译:**
噢，好的。

---

### [01:04:32] Lenny Rachitsky

**English:**
You have a pretty unique approach to finding a gig. I heard from the founder of Mode about the very unique way you approached getting a job there. I imagine Linear is a similar boat. What advice can you share with folks that are looking for a job, maybe struggling, that work for you when you were looking for your next gig?

**中文翻译:**
你找工作的方法相当独特。我从 Mode 的创始人那里听说过你当时入职时的独特方式。我猜 Linear 的情况也差不多。对于那些正在找工作、甚至可能遇到困难的人，你能分享一些你在寻找下一份工作时对你有效的建议吗？

---

### [01:04:51] Nan Yu

**English:**
Project management is a unique role. Because we do just about everything, you don't really get pigeonholed into being compared along a single dimension with everyone else, and everyone who's hiring PMs, just like when they're hiring execs, they're hoping that they bring them on to solve some burning problem that they have. So, it's your job when you're in the interview process to figure out what that burning problem is. So, put on your discovery hat and go figure out what is the actual job to be done of the hiring manager when they're bringing on a new PM onto their team? And if you can do that and then make a good case that you are the person to solve that problem, then hiring you becomes a binary choice between do I hire the solution to my problem or do I hire someone else?

**中文翻译:**
产品管理是一个独特的角色。因为我们几乎什么都做，所以你不会像其他人一样被局限在单一维度上进行比较。每个招聘产品经理的人，就像招聘高管一样，都希望招来的人能解决他们面临的某个燃眉之急。所以，在面试过程中，你的任务就是找出那个燃眉之急是什么。戴上你的“调研帽”，去弄清楚招聘经理在团队中引入一名新产品经理时，真正的“待办任务”（Job to be done）是什么？如果你能做到这一点，并有力地证明你就是解决那个问题的人，那么雇佣你就变成了一个二选一的抉择：我是雇佣这个问题的解决方案，还是雇佣其他人？

---

### [01:05:48] Nan Yu

**English:**
And I think what ends up happening a lot is when you're in a interview process, you're just trying to put your best foot forward, trying to say that you're great at everything. You have very few weaknesses. Maybe you tried too hard, like whatever, but everyone's going to say that. So, you're just one of end people, and you want to make yourself a little bit of just you versus the field. You're the solution to a problem and then everyone else is like a roll of the dice.

**中文翻译:**
我认为通常发生的情况是，当你在面试过程中，你只是在努力展示自己最好的一面，试图说你擅长一切，几乎没有弱点，或者说你太努力了之类的。但每个人都会这么说。所以你只是众多候选人中的一个。而你想把自己变成“你 vs. 其他所有人”。你是问题的解决方案，而其他人就像是在掷骰子。

---

### [01:06:15] Lenny Rachitsky

**English:**
So, the way you're describing it is the company has a job to be done, say it's drive growth of some feature. In this case, it's like for Linear, just build a killer or successful B2B product. I don't know. That's a broad one. Usually, you're not interviewing for head of product role, so that's maybe too broad. So, it's like what is this PM role's job to be done at the company and then help convince them you are the best person to do that job and solve this problem for them.

**中文翻译:**
所以你描述的方式是：公司有一个待办任务，比如推动某个功能的增长。在 Linear 的例子中，可能是构建一个杀手级的或成功的 B2B 产品。我不知道，这太宽泛了。通常你面试的不是产品负责人职位，所以那可能太宽泛。所以应该是：这个产品经理职位在公司的待办任务是什么，然后说服他们你是完成这项任务并为他们解决问题的最佳人选。

---

### [01:06:42] Nan Yu

**English:**
Yeah, and a lot of times when you take that approach, it'll feel like you already work there, and the way that I did this, like I got advice from a friend. He said like, "I was interviewing for this job at Mode that you referenced." I'm like, "How should I approach it?" He's like, "Just act like you already worked there. What would you do?" And then it's like, "Okay, I could do that." So, then when you're in this interview process and someone's asking you questions. He goes, "Do you have any questions for me?" You can ask them like, "What are your OKRs this quarter? How can someone help you achieve those?" You can be that specific about it, and they're like, "Oh, yeah, sure. I can tell you about the exact thing that I'm doing this quarter, and then you'll have some level of intelligence about what people are actually trying to solve because I think often we just get stuck in these very high level general types of questions like, "What's the company goals sand all that kind of stuff, and it's like, no, you can get really specific. If you were collaborating with that person in your job, what would you say to them?

**中文翻译:**
是的，很多时候当你采取这种方法时，感觉就像你已经在那里工作了。我当时是这么做的（我得到了一个朋友的建议）：当我面试你提到的 Mode 的职位时，我问“我该怎么做？”，他说，“就表现得像你已经在那里工作了一样。你会怎么做？”我想，“好，我可以做到。”所以，当你在面试过程中，有人问你“你有什么问题想问我吗？”时，你可以问：“你们这季度的 OKR 是什么？别人怎么能帮你实现这些目标？”你可以问得这么具体。他们会说：“噢，当然，我可以告诉你我这季度具体在做什么。”这样你就能掌握人们真正想解决的问题。因为我认为通常我们只是停留在非常高层、通用的问题上，比如“公司的目标是什么”之类的。不，你可以非常具体。如果你在工作中与那个人协作，你会对他们说什么？

---

### [01:07:39] Lenny Rachitsky

**English:**
I love how actionable this advice is. There's obviously an element of this takes work and time. A lot of people are interviewing at a lot of companies, trying to find a job, is part of your advice. Pick the ones you're most excited about and invest a lot of time in this way of interviewing.

**中文翻译:**
我喜欢这个建议的可操作性。显然，这需要投入精力和时间。很多人在很多公司面试找工作，你的建议是否包括：挑选那些你最兴奋的公司，并在这种面试方式上投入大量时间？

---

### [01:07:58] Nan Yu

**English:**
You can invest a lot in the ones where you know that you're going to be able to over deliver on. If you understand what they're actually trying to solve, then you know where you're going to have both the highest chance of success of getting hired, but also doing a really great job on the other end of it.

**中文翻译:**
你可以在那些你确信自己能超预期交付的公司上投入大量精力。如果你了解他们真正想解决的问题，那么你不仅获得聘用的机会最高，而且入职后也能做得非常出色。

---

### [01:08:13] Lenny Rachitsky

**English:**
And you talk about how you're like pretending you have the job, pretending you actually have this job as part of the interview process. Oftentimes, as an outsider, you don't have enough information to have a really good thought on what the solution is, and maybe part of it is going to be so wrong because you're like, "I don't actually know. I don't have the data." Do you actually try to reach out to the engineers and designers on the team to try to understand things? How far do you go to try to solve these problems and show them what you can do?

**中文翻译:**
你谈到在面试过程中表现得像已经得到了这份工作。通常作为局外人，你没有足够的信息对解决方案有很好的想法，甚至可能有些想法是完全错误的，因为你没有数据。你会尝试联系团队中的工程师和设计师来了解情况吗？为了解决这些问题并展示你的能力，你会做到什么程度？

---

### [01:08:37] Nan Yu

**English:**
Yeah, I mean, you're in the interview loop. These are people that you're going to be working closely with. So, start there. Do your discovery questions, and if there's an area that you think you want to dig, you can ask. There's no harm asking, "Hey, can you put me in touch with an engineering manager who's working on the same problem?" And if no one else is asking, again, you're going to have an extra piece of feedback from that eng manager. So, yeah, like this guy asks really good questions, and it seems like they're really with it. No one else is going to have that piece of feedback. So, during the debrief process.

**中文翻译:**
是的，毕竟你已经在面试流程中了，这些人就是你未来要紧密合作的人。所以从那里开始。提出你的调研问题，如果你想挖掘某个领域，你可以直接问。问一句“嘿，你能让我和负责这个问题的工程经理聊聊吗？”并没有坏处。如果没有其他人这么问，你就会从那位工程经理那里得到额外的正面反馈。他们会觉得：“这家伙问的问题很专业，看来他真的很懂。”在面试评估过程中，没人能得到这样的反馈。

---

### [01:09:08] Lenny Rachitsky

**English:**
And just asking that question alone will show them how deeply you're thinking about this already?

**中文翻译:**
仅仅是问出那个问题，就能让他们看到你已经在进行多么深入的思考了？

---

### [01:09:14] Nan Yu

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:09:15] Lenny Rachitsky

**English:**
Amazing. Nan, is there anything else that we have not covered that you want to touch on or share or you think might be helpful to listeners before we get to a very exciting lightning round?

**中文翻译:**
太棒了。Nan，在进入非常精彩的闪电轮问答之前，还有什么我们没涵盖、你想谈谈或分享的，或者你认为对听众有帮助的内容吗？

---

### [01:09:30] Nan Yu

**English:**
I have a very specific point of view on deadlines. I don't know if that's something you care.

**中文翻译:**
我对截止日期（deadlines）有一个非常具体的观点。不知道你是否感兴趣。

---

### [01:09:34] Lenny Rachitsky

**English:**
Let's do it. Fire away.

**中文翻译:**
来吧，请讲。

---

### [01:09:38] Nan Yu

**English:**
I think what often happens is people get depressed about deadlines. It's like, "Hey, here's the ship date," and then you never make it. I don't know if you've had this feeling before.

**中文翻译:**
我认为经常发生的情况是，人们对截止日期感到沮丧。就像，“嘿，这是交付日期，”然后你永远赶不上。不知道你以前是否有过这种感觉。

---

### [01:09:47] Lenny Rachitsky

**English:**
Absolutely, with some deadlines.

**中文翻译:**
当然，有些截止日期确实如此。

---

### [01:09:49] Nan Yu

**English:**
You were an engineer before too, right? So, it's just like engineers is basically like, "Oh, yeah. Yeah, deadlines, they're complete fabrications," and the only way to make deadlines real is to take them so seriously that they are basically like a P0 problem, and everything else has to not matter in comparison to the deadline because that's the only way you're going to be able to signal to the team and also to all the stakeholders that you're actually taking it seriously. So, my feeling on deadlines is don't have too many of them, and when you do, it's a P0. So, the engineer is working on it. They don't get to work on anything else.

**中文翻译:**
你以前也是工程师，对吧？所以工程师基本上会觉得，“哦，是的，截止日期，那完全是编造出来的。”而让截止日期变得真实的唯一方法，就是极其严肃地对待它们，把它们当作 P0 级（最高优先级）问题。相比之下，其他任何事情在截止日期面前都不重要。因为这是向团队和所有利益相关者发出信号的唯一方式，表明你真的在认真对待它。所以，我对截止日期的看法是：不要有太多的截止日期，一旦有了，它就是 P0。负责它的工程师不能再做任何其他事情。

---

### [01:10:28] Nan Yu

**English:**
It's like, "Oh, I need them for this," like nope. Nope. You're not pulling them off of anything. We're doing this. As a PM, your job is to just cut as much scope as possible to make it possible to hit that deadline. Like what are the things actually blocking us from doing it? Because what you want to do is at the moment where you have to make the go, no-go call on whether to ship, you want to be able to actually have a product that you can say yes to. It might not have all the features you had wanted or whatever, and you can say no. You can make that choice, but you want to set yourself up to be in a position where you can actually say yes or no to something, because what often happens is like we want this thing. Well, it's not even close to being done yet, so there's no possible way we can say yes. I can't ship it. It's half broken. It's like, "No, no, no. You want to get to a point where it works. It might not be the product that you want, but it is an actual real product that you can conceivably ship."

**中文翻译:**
如果有人说，“哦，我需要他们处理这个，”回答是：不行。不行。你不能把他们从这个任务中抽走。我们必须完成这个。作为产品经理，你的工作就是尽可能地削减范围（scope），以确保能赶上截止日期。到底是什么在阻碍我们完成？因为你想要的是，在必须决定“发还是不发”的那一刻，你手里真的有一个你可以说“发”的产品。它可能没有你想要的所有功能，你可以选择不发，但你要让自己处于一个“真的有东西可选”的位置。因为通常发生的情况是：我们想要这个东西，但它甚至还没接近完工，所以根本没法说“发”。我不能发一个半成品。不不不，你要达到一个它能运行的状态。它可能不是你最理想的产品，但它是一个你可以想象交付的、真实的、完整的产品。

---

### [01:11:19] Lenny Rachitsky

**English:**
So, you said that don't have too many deadlines, but when you do, make sure you... Everyone understands these are actual deadlines. When do you decide it's worth having a deadline? Is it like a marketing launch sort of thing? What's worthy of a deadline in your experience?

**中文翻译:**
所以你说不要有太多截止日期，但一旦有了，要确保每个人都明白那是真正的截止日期。你什么时候决定值得设定一个截止日期？是像营销发布之类的事情吗？根据你的经验，什么样的事情值得设定截止日期？

---

### [01:11:32] Nan Yu

**English:**
Yeah, it's usually having to do with some kind of external marketing type of exercise that you're try to hit.

**中文翻译:**
是的，通常与你试图达成的某种外部营销活动有关。

---

### [01:11:39] Nan Yu

**English:**
And I think that that's the other thing that I think. As builders, we can often look at launch dates and stuff like that. It's like, "Oh, who cares if it's a little bit later or we skip this change log," or whatever it is, and I think that that's really a... I don't know. It makes me go crazy when I hear people say that in all honesty. With marketing and communication with customers, you basically have a limited amount of opportunities to do so. A year is 365 days. There are 12 months. Each of those months has about four weeks. There's some rhythm where you get to have 50-ish weeks to say something to your audience once a week, or you get to have 12 months to say something really big or four quarters to say something huge. If you miss one of those opportunities, you don't get it back again. You can't time travel back and say like, "Okay, actually, let's redo first quarter and say this message that we wish we could have gotten into the field."

**中文翻译:**
这是我想说的另一件事。作为建设者，我们经常会看发布日期之类的事情，然后觉得，“哦，晚一点有什么关系，或者跳过这次更新日志又怎样。”老实说，当我听到人们这么说时，我会抓狂。在营销和与客户沟通方面，你拥有的机会其实是有限的。一年 365 天，12 个月，每个月大约 4 周。有一种节奏：你大约有 50 周的时间每周对受众说点什么，或者有 12 个月的时间说点大事，或者有 4 个季度说点惊天动地的事。如果你错过了其中一个机会，你就再也找不回来了。你不能穿越回过去说，“好吧，其实让我们重来一次第一季度，把我们希望传达的信息发出去。”

---

### [01:12:35] Lenny Rachitsky

**English:**
That is such a powerful point. I could see the sales marketing, go-to-market element of your job coming out there. I imagine everyone that's in that field's like, "Yes, this is exactly right." Maybe just the last question along this line. So, I love this idea of taking deadlines very seriously when you commit to a deadline. At the same time, as you pointed out, it creates a lot of stress knowing there's a deadline we have to hit. So, one lever you've mentioned is cutting scope. Another is just people spending more time estimating to have more accurate deadlines. You invest in that. How do you think about just for an engineering team to come into a deadline, how much to spend on de-risking and estimating versus just, "Let's just do our best and then we'll cut and adjust"?

**中文翻译:**
这是一个非常有力的观点。我能看到你工作中销售、营销和“转到市场”的基因在闪光。我想那个领域的人都会说，“是的，完全正确。”关于这一点最后一个问题：我喜欢“一旦承诺就极其严肃对待截止日期”的想法。但正如你指出的，知道必须赶上截止日期会带来很大压力。你提到的一种手段是削减范围。另一种是让人们花更多时间进行估算，以获得更准确的截止日期。你会在这方面投入吗？对于一个要迎接截止日期的工程团队，你认为应该花多少精力在“降低风险和估算”上，还是仅仅“尽力而为，然后根据情况削减和调整”？

---

### [01:13:18] Nan Yu

**English:**
This might be my hot take, but we do almost no estimating in order to hit deadlines. What we do is we ship as early as we can. The thing we talked about earlier where if by the time that 10% of the time has elapsed, you have a working thing, you can now spend the rest of the time deciding whether or not you want to do another iteration or you want to polish that thing and get it to be a shippable state. So, you're setting up your future self to be able to make that decision. So, none of this is... You can't go into this at the very last moment and say like, "Okay, now, we have to take the deadline seriously." You have to do it from the beginning and commit to the process of going very fast, iterating early, and then putting yourself in a position where you can say yes or no to a product.

**中文翻译:**
这可能是我的一个“暴论”：为了赶上截止日期，我们几乎不做任何估算。我们做的是尽可能早地交付。就像我们之前谈到的，如果时间过去 10% 时你已经有了一个能用的东西，你就可以用剩下的时间来决定：是再进行一次迭代，还是打磨这个东西使其达到可交付状态。你是在为未来的自己创造做决定的空间。所以，这绝不是……你不能在最后一刻才说，“好吧，现在我们要认真对待截止日期了。”你必须从一开始就这么做，致力于快速行动、早期迭代，让自己处于一个可以对产品说“发”或“不发”的位置。

---

### [01:14:03] Lenny Rachitsky

**English:**
So interesting and so different from the way most companies operate. Nan, this was everything I was hoping it'd be. I think this is going to help a lot of people build much better product, which would be good for the world if more products are like Linear. With that, we reached our very exciting lightning round. Are you ready?

**中文翻译:**
太有意思了，这和大多数公司的运作方式完全不同。Nan，这正是我所期待的。我认为这会帮助很多人构建更好的产品，如果世界上有更多像 Linear 这样的产品，那将是一件好事。那么，我们进入了非常令人兴奋的闪电轮问答。准备好了吗？

---

### [01:14:20] Nan Yu

**English:**
Yeah, let's do it.

**中文翻译:**
准备好了，开始吧。

---

### [01:14:20] Lenny Rachitsky

**English:**
Okay, let's do it. Okay, first question. What are two or three books that you have recommended most to other people?

**中文翻译:**
好，开始。第一个问题：你向别人推荐最多的两三本书是什么？

---

### [01:14:29] Nan Yu

**English:**
I think the one book that I recommend the most is The Design of Everyday Things by Don Norman. I read it originally in college for an HCI (Human-Computer Interaction) class I was taking, and I think of everything I've ever read, it's the thing that caused me to see the world from the perspective of everything you interact with as a product. Every pencil that you use, every door that you open is a product that somebody designed.

**中文翻译:**
我想我推荐最多的一本书是唐·诺曼的《设计心理学》（The Design of Everyday Things）。我最初是在大学的人机交互（HCI）课上读到它的。在我读过的所有书中，它让我开始从“你互动的每样东西都是产品”的角度来看待世界。你使用的每支铅笔，你打开的每扇门，都是某人设计的产品。

---

### [01:14:55] Lenny Rachitsky

**English:**
And is that the big takeaway from that book? Because it comes up a lot, and it's such an old book. So, I guess for someone that hasn't read or maybe doesn't have time to read, it is the big takeaway for you. Someone designed everything and there's a reason things aren't great, and they can be improved.

**中文翻译:**
这就是那本书的核心启示吗？因为它经常被提及，而且是一本很老的书了。对于没读过或没时间读的人来说，这就是你最大的收获吗：每样东西都是被设计的，东西不好用是有原因的，而且它们可以被改进。

---

### [01:15:10] Nan Yu

**English:**
Yeah. I mean, I saw this the other day. I was at a café in my neighborhood, and I saw a kid rip a handle off a door, like of the café. He pulled it so hard, it came right off because it was a push door, but it had a handle that looked like you could pull it, and that's one of the canonical examples of the book because [inaudible 01:15:25] are just mysteries. Yeah.

**中文翻译:**
是的。我前几天还见过这种情况：我在家附近的咖啡馆，看到一个孩子把门把手拽了下来。他用力太猛，把手直接掉了，因为那其实是个推门，但它装了一个看起来可以拉的把手。这就是书中的经典例子之一，有些设计简直是谜团。

---

### [01:15:28] Lenny Rachitsky

**English:**
Awesome. Next question. Do you have a favorite recent movie or TV show you've really enjoyed?

**中文翻译:**
太棒了。下一个问题：你最近有没有特别喜欢的电影或电视剧？

---

### [01:15:33] Nan Yu

**English:**
I watched The Diplomat on Netflix. I think it was terrific. It's really fun, easy watch. It has some West Wing vibes if you were into that back in the day.

**中文翻译:**
我看了 Netflix 上的《外交官》（The Diplomat）。我觉得非常棒。很有趣，看起来很轻松。如果你以前喜欢《白宫风云》（West Wing），它有点那种感觉。

---

### [01:15:44] Lenny Rachitsky

**English:**
Yeah, have you seen the second season?

**中文翻译:**
是的，你看第二季了吗？

---

### [01:15:46] Nan Yu

**English:**
Yeah, I finished the second season. Yeah.

**中文翻译:**
看了，我刚看完第二季。

---

### [01:15:48] Lenny Rachitsky

**English:**
I wasn't as excited about the second season, just to put that out there. The first season was really good and then just went off a little like, "Okay. I guess it's cool," but stuff like that.

**中文翻译:**
说实话，我对第二季没那么兴奋。第一季非常好，然后第二季就有点……“好吧，还行吧”那种感觉。

---

### [01:15:55] Nan Yu

**English:**
Yeah, it got a little like spy thrillery, I think.

**中文翻译:**
是的，我觉得它变得有点像间谍惊悚片了。

---

### [01:16:00] Lenny Rachitsky

**English:**
Okay, cool, but still really good and on Netflix. Okay, cool. Do you have a favorite product you recently discovered that you really like?

**中文翻译:**
好，但还是很不错，而且在 Netflix 上。好。你最近有没有发现什么特别喜欢的电子产品或实物产品？

---

### [01:16:06] Nan Yu

**English:**
I didn't discover it, but I discovered a version of it that was really interesting. There's a pen. Actually, I have one on my desk. It's called the Sakura Micron. I don't know if you use these. It's like a felt tip pen. It's really great. It was originally invented in Japan for artists to draw comic books and stuff, and you can use it for anything. I use it for journaling or whatever, but I was on Amazon. I was trying to buy more, and I found a package that said like, "Bible Study Kit." I was like, "Why is this labeled Bible Study Kit?" And it was literally just the pen in four different colors, and it was because the thing doesn't bleed through pages. So, if you have a Bible, which they often have these really flimsy newsprint pages. It's not going to bleed through.

**中文翻译:**
不是新发现的产品，但我发现了一个非常有趣的版本。有一种笔，我桌上就有一支，叫樱花（Sakura）Micron。不知道你用不用，它是一种针管笔，非常好用。它最初是在日本发明的，供艺术家画漫画之类的，但你可以用它做任何事。我用它写日记。我在亚马逊上想多买点，结果发现一个包装上写着“圣经学习套装”。我心想，“为什么这被贴上圣经学习套装的标签？”结果发现里面就是四种不同颜色的这种笔，原因是因为这种笔不会洇透纸张。如果你读圣经，那种纸通常非常薄，像新闻纸一样，这种笔不会洇过去。

---

### [01:16:51] Nan Yu

**English:**
And it's just really interesting to me that someone marketed a normal package of these pens as a Bible study kit and for people who were looking for that keyword, and it was official, too. It was not something hacked together. It was actually an official packaging of this.

**中文翻译:**
我觉得非常有意思的是，有人把一包普通的笔作为“圣经学习套装”来营销，针对搜索那个关键词的人。而且这是官方的，不是别人胡乱拼凑的，是官方出的包装。

---

### [01:17:04] Lenny Rachitsky

**English:**
Amazing. What a unique pen choice. Two more questions. Do you have a favorite life motto that you often come back to and find useful in work or in life?

**中文翻译:**
太神奇了，真是个独特的选笔视角。最后两个问题：你有没有什么常用的人生座右铭，觉得在工作或生活中很有用？

---

### [01:17:15] Nan Yu

**English:**
The correct amount is too much minus one, and I think this ties into the try the extreme version of it of a thing where... I don't know, like a stupid example, like how much pizza do you want to eat? It's like, well, five slices was too many. I feel bad. Then four was probably the right number, and then if you want to find the right number, sometimes you just have to really shoot for the edge and then find out what's too much, and then you'll find out exactly what the right amount is.

**中文翻译:**
“正确的量是‘太多’减去一”。我认为这与尝试事物的极端版本有关。举个简单的例子：你想吃多少披萨？好吧，吃五块太多了，我觉得难受。那么四块可能就是正确的数量。如果你想找到正确的量，有时你必须真正冲向边缘，找出什么是“太多”，然后你就会确切地知道什么是“合适”。

---

### [01:17:41] Lenny Rachitsky

**English:**
I love how tactical that is, makes me think about Elon Musk's thing about cutting things. Like one of his formulas for just getting stuff done, one of them is just cut stuff before trying to optimize it and automate it, and his advice is if you don't bring back 10% of things, you cut, you're not cutting enough.

**中文翻译:**
我喜欢这种战术性的思考。这让我想起埃隆·马斯克关于削减东西的理论。在他完成任务的公式中，其中之一就是在尝试优化和自动化之前先削减。他的建议是：如果你没有把你削减掉的东西再拿回来 10%，说明你削减得还不够。

---

### [01:17:59] Nan Yu

**English:**
Yeah, exactly.

**中文翻译:**
是的，没错。

---

### [01:18:01] Lenny Rachitsky

**English:**
Final question. You worked at Everlane for a number of years, and you shared the rough idea of a story around a shirt, maybe a bestseller that they have now, and how you helped create a bestselling women's shirt. Can you share that story?

**中文翻译:**
最后一个问题。你在 Everlane 工作了很多年，你曾分享过一个关于一件衬衫的故事，那可能是他们现在的畅销品，以及你如何帮助创造了一款畅销的女式衬衫。你能分享那个故事吗？

---

### [01:18:19] Nan Yu

**English:**
Yeah. So, I mean, to be clear, I witnessed the creation. I don't think I had a direct hand in it, but yeah. So, I saw this advertisement the other day on Instagram for... It's called the Women's Box-Cut Tee, and it's a wide and short for women, and I looked, and it had 20 colors of it, and it sells super well, and I remember when we created this thing, and it was because there was a batch of defective men's t-shirts. They all came in an inch and a half too short. So, we couldn't sell them. You would have your belly button sticking out. No one wants to wear of that. So, what we did was like, well, we have to salvage the inventory because we were a very small company, and we had to make cash flow, and we couldn't just damage it out.

**中文翻译:**
好的。首先声明，我是见证了它的诞生，我不认为我直接参与了设计。前几天我在 Instagram 上看到了一个广告，叫“女式方型 T 恤”（Women's Box-Cut Tee），对女性来说它又宽又短。我看了看，它有 20 种颜色，卖得超级好。我记得我们创造这个东西的时候，是因为有一批有缺陷的男式 T 恤。它们都短了一英寸半。所以我们没法卖，穿上会露肚脐眼，没人想穿那样的。所以我们当时想，好吧，我们必须挽救这批库存，因为我们当时是一家非常小的公司，我们需要现金流，不能直接报废。

---

### [01:19:06] Nan Yu

**English:**
So, the design team and the marketing team came together, and they said, "Okay. Here's what we're going to do. We're going to cut another two inches off of this and make it really cropped and market it towards women as like a cropped boxed-tee silhouette, and we did that. We're like, "Okay, hopefully, we can salvage this inventory and not have to take a write-down." It sold out in a week, and we're like, "Oh, okay. I guess we just made a hit product," and it's one of these things where it's very hard to know what this was. Was this a marketing thing? Was this a design thing? I don't know, but you just come together, and you find the right product market fit in the weirdest way.

**中文翻译:**
于是设计团队和营销团队聚在一起说：“好吧，我们这样做：我们再剪掉两英寸，把它做成真正的短款（cropped），然后作为‘短款方型 T 恤’推向女性市场。”我们这么做了。我们当时想，“好吧，希望我们能挽救这批库存，不用计提减值。”结果它在一周内就卖光了。我们想，“噢，好吧，看来我们刚做出了一个爆款。”这就是那种很难说清的事情：这是营销的功劳？还是设计的功劳？我不知道，但大家聚在一起，以最奇特的方式找到了产品市场契合点。

---

### [01:19:43] Lenny Rachitsky

**English:**
I love that it's still going.

**中文翻译:**
我喜欢它现在还在卖。

---

### [01:19:43] Nan Yu

**English:**
Yeah, it's still going. Originally, it was just white. Now, there's like 20 colors.

**中文翻译:**
是的，还在卖。最初只有白色，现在有 20 种颜色。

---

### [01:19:48] Lenny Rachitsky

**English:**
Oh, man. I love how many industries you have worked in: fashion, data analytics, project management. I don't know what's next. There's more, I imagine. Nan, this was incredible. I really appreciate making time for this. Like I said, I think we're going to have helped a lot of people build better products. Two final questions, where can folks find you online if they want to reach out and learn more? And how can listeners be useful to you?

**中文翻译:**
天哪。我喜欢你跨越了这么多行业：时尚、数据分析、项目管理。我不知道下一个会是什么，我猜还有更多。Nan，这太精彩了。非常感谢你抽时间参加。就像我说的，我认为我们会帮助很多人构建更好的产品。最后两个问题：如果大家想联系你或了解更多，可以在哪里找到你？听众们能为你做些什么？

---

### [01:20:08] Nan Yu

**English:**
Yeah, I'm on X/Twitter as the thenanyu. It's T-H-E and then my name, and if they have any feedback about Linear, we're very happy to take it, especially for people who use it in their day-to-day. We really want to hear from users.

**中文翻译:**
好的，我在 X/Twitter 上的账号是 @thenanyu。如果大家对 Linear 有任何反馈，我们非常乐意听取，特别是那些日常使用它的人。我们真的很想听听用户的声音。

---

### [01:20:26] Lenny Rachitsky

**English:**
What's the best way for them to share that? Is it tweet at you? Is it go to the website? What do you recommend?

**中文翻译:**
他们分享反馈的最佳方式是什么？是发推特给你？还是去网站？你推荐什么？

---

### [01:20:31] Nan Yu

**English:**
Oh, yeah. You can tweet at us. You can DM me on Twitter. My DMs are open, so it's all good.

**中文翻译:**
噢，是的。你可以发推特给我们，也可以在 Twitter 上私信我。我的私信是开放的，没问题。

---

### [01:20:36] Lenny Rachitsky

**English:**
Amazing. Nan, thank you so much for being here.

**中文翻译:**
太棒了。Nan，非常感谢你能来。

---

### [01:20:39] Nan Yu

**English:**
Yeah, of course. Thanks, Lenny.

**中文翻译:**
当然，谢谢 Lenny。

---

### [01:20:40] Lenny Rachitsky

**English:**
Bye, everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
大家再见。非常感谢收听。如果你觉得内容有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅本节目。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目再见。