# Nancy Duarte - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Nancy Duarte.

---

### [00:00:00] Nancy Duarte

**English:**
A lot of people think that the only time you really need to present well is when you have a big stage talk and you make the big investment in the script. The big investment in the contrasting story. I'll tell you a dirty little secret. I can get my husband to do chores for me on the weekends with a real quick, what is, what could be new bliss. So, the ability to just have that contrast as a framework in your brain during a meeting, on a phone call, any moment of influence, like literally it works. It works in any format.

**中文翻译:**
很多人认为，只有在需要进行大型舞台演讲、投入大量精力写脚本、构思充满反差的故事时，才需要好好表现。但我告诉你一个“公开的秘密”：在周末，我只需要用一套简单的“现状、愿景、新蓝图”框架，就能让我丈夫帮我做家务。所以，在会议中、电话里，或者任何需要发挥影响力的时刻，只要你脑子里有这种“反差”框架，它就真的有效。它适用于任何形式。

---

### [00:00:29] Lenny

**English:**
Welcome to Lenny's Podcast where I interview world class product leaders and growth experts to learn from their hard-won experiences building and growing today's most successful products. Today my guest is Nancy Duarte. Nancy is the type of guest that I never imagined being able to get on this podcast, but I'm so happy that it happened. Nancy is a bestselling author, speaker, and CEO of Duarte Incorporated, which has helped create over 250,000 presentations for the world's most influential business leaders, brands and institutions including Apple, TED, Google, the World Bank, and famously Al Gore on his Inconvenient Truth presentation. In our conversation, Nancy shares a ton of tactical advice for how to improve your own presentations, how to tell better stories, how to lay out convincing arguments, how to reduce your nerves when you present, and even a simple communication framework to improve your relationship dynamics. I had such a good time chatting with Nancy and I'm sure you'll love this episode. With that, I bring you Nancy Duarte after a short word from our sponsors.

**中文翻译:**
欢迎来到 Lenny 的播客。在这里，我会采访世界级的产品领导者和增长专家，学习他们在打造和发展当今最成功产品过程中积累的宝贵经验。今天的嘉宾是 Nancy Duarte。Nancy 是那种我从未想过能请到节目里的嘉宾，但我非常高兴这实现了。Nancy 是一位畅销书作家、演讲家，也是 Duarte 公司的 CEO。该公司已协助全球最具影响力的商业领袖、品牌和机构制作了超过 25 万份演示文稿，客户包括苹果、TED、谷歌、世界银行，以及著名的阿尔·戈尔（Al Gore）及其《难以忽视的真相》（Inconvenient Truth）演示文稿。在我们的对话中，Nancy 分享了大量关于如何改进演示、讲好故事、陈述有力论据、缓解演讲紧张情绪的实用建议，甚至还分享了一个能改善人际关系的简单沟通框架。我与 Nancy 聊得非常愉快，相信你们也会喜欢这一集。在听完赞助商的简短介绍后，让我们欢迎 Nancy Duarte。

---

### [00:01:29] Lenny (Sponsorship Segment)

**English:**
This episode is brought to you by Microsoft Clarity, a free easy to use tool that captures how real people are actually using your site... [Sponsorship details omitted for brevity as per standard practice, but the full transcript continues below].

**中文翻译:**
本集节目由 Microsoft Clarity 赞助，这是一款免费且易于使用的工具，可以捕捉真实用户使用您网站的情况……（此处为赞助商广告内容）。

---

### [00:02:37] Lenny

**English:**
Are you hiring or on the flip side, are you looking for a new opportunity? Well, either way, check out lennysjobs.com/talent... [Sponsorship details omitted]. Nancy, welcome to the podcast.

**中文翻译:**
你是在招聘，还是在寻找新的机会？无论哪种情况，请查看 lennysjobs.com/talent……（此处为招聘平台广告内容）。Nancy，欢迎来到本播客。

---

### [00:03:31] Nancy Duarte

**English:**
Thank you for having me, Lenny.

**中文翻译:**
谢谢你邀请我，Lenny。

---

### [00:03:33] Lenny

**English:**
How many presentations have you helped craft at this point, both directly and indirectly?

**中文翻译:**
到目前为止，你直接或间接参与制作了多少份演示文稿？

---

### [00:03:38] Nancy Duarte

**English:**
That's a great question. People know I'll like take a swag at data and pretend it's real. So, I had a president who took us a whack at that number in, it was 2014, and he said at that time it was 225,000, and that was almost 10 years ago, so I can't even tell you, I mean we stopped tracking, but it's a lot. I mean, in 35 years we have thousands of projects we open and each sometimes has two to a hundred presentations in it, so it'd be hard to tell.

**中文翻译:**
这是一个好问题。大家都知道我喜欢估算数据并说得跟真的一样。2014 年，我们公司的一位总裁曾估算过这个数字，当时是 22.5 万份。那已经是快 10 年前的事了，所以我现在也说不准，我们后来停止追踪了，但数量非常惊人。在 35 年里，我们开启了数千个项目，每个项目有时包含 2 到 100 份演示文稿，所以很难给出一个确切数字。

---

### [00:04:13] Lenny

**English:**
200,000.

**中文翻译:**
20 万份。

---

### [00:04:15] Nancy Duarte

**English:**
He said 250,000, but that was 10 years ago and I didn't do the math. So, when my team questioned it, I'm like, oh, Dan did the math. They're like, "Oh, then it's accurate." Because they thought I was just making up this number. I'm like, no, no, we actually went in and looked.

**中文翻译:**
他说的是 25 万份，但那是 10 年前的事了，而且不是我算的。所以当我的团队质疑时，我说：“哦，是 Dan 算的。”他们就说：“哦，那肯定准确。”因为他们以为是我随口编的。我说：“不，不，我们真的去查过数据。”

---

### [00:04:31] Lenny

**English:**
Okay. I was not expecting it to be that large. That's insane.

**中文翻译:**
好吧，我没想到数字会这么大。太疯狂了。

---

### [00:04:34] Nancy Duarte

**English:**
It's so funny because I have the whole history of the Silicon Valley in a way. It's like every little startup and then they grew to massive brands like Cisco and you could actually look at the rise and fall of all these companies. And then I actually have all the decks. I still have a lot of these archives, so I could actually verify that number exactly.

**中文翻译:**
这很有趣，因为在某种程度上，我见证了整个硅谷的历史。从每一家小初创公司到它们成长为思科（Cisco）这样的大品牌，你甚至可以通过演示文稿看到这些公司的兴衰。而且我手里还有所有的幻灯片，我保留了很多档案，所以我其实可以精确地核实那个数字。

---

### [00:04:52] Lenny

**English:**
Okay, well this next question's going to be extra hard then. Of all the presentations you've worked on, which one stands out to you as the most memorable or most impactful?

**中文翻译:**
好，那接下来的问题就更难了。在你参与过的所有演示文稿中，哪一个让你觉得最难忘或最具影响力？

---

### [00:05:02] Nancy Duarte

**English:**
I mean, it has to be Al Gore's Inconvenient Truth. It kind of hit the world in a season where nobody really knew or had an example of a really well done presentation. So, it came out before TED Talks were even out on the web, and so people had never seen someone tell a data story and stand in front of data and the scale in 90 foot screen, but we had worked with him for five years before an Inconvenient Truth. People think he went from vice president to this presenter and I didn't work with him. I let my team work with him. So, they were the ones jetting around jumping backstage at Oprah. They loved it. It was a real peak season.

**中文翻译:**
那一定是阿尔·戈尔的《难以忽视的真相》。它问世时，世界上还没有人真正见过一份制作精良的演示文稿范例。它甚至比 TED 演讲在网上流行还要早。人们从未见过有人能站在 90 英尺宽的屏幕前，结合数据讲故事。但在《难以忽视的真相》成名之前，我们已经和他合作了五年。人们以为他直接从副总统变成了演讲家，其实我当时没直接参与，是让我的团队去做的。他们当时跟着他到处飞，在奥普拉秀的后台忙碌。他们很喜欢那段时光，那是真正的巅峰时期。

---

### [00:05:40] Nancy Duarte (Continued)

**English:**
But the thing actually that was most memorable is we work with these 20 some year old CEOs here in the Valley and they tend to show up and act like they know better than someone who's been doing this for so long. And what was so interesting about this large figure politician communicator is the team would sit in a room and say, "Hey, we think you need to do this way. We think you needed to convey it this way. We think it should be visualized this way." Or whatever it was we were proposing. And he would literally pause and touch his chin and really think, and really consider that we might actually be experts.

**中文翻译:**
但最令我难忘的是，我们经常和硅谷那些 20 出头的 CEO 们合作，他们往往表现得好像比我们这些做了几十年的人还懂。而这位重量级政治家、沟通者的有趣之处在于，当团队坐在房间里对他说：“嘿，我们认为你应该这样做，我们认为你应该这样表达，或者这样视觉化呈现”，无论我们提议什么，他都会停下来，摸摸下巴，认真思考，真正把我们当成专家来对待。

---

### [00:06:18] Nancy Duarte (Continued)

**English:**
And more times than not he would adopt the way we said it should be done. And so I think as the customer who actually probably had some of the most power in the whole world to thoughtfully defer to us as experts was delightful customer and consulting experience. I mean, I remember when they called me to say it was going to become a movie and that it had gotten funded and I started to get the information. They wanted us to do a lot of work to get it movie ready. And I'll never forget, I said, "Wow, that's going to be a lot of work we'd have to do for free, and who's going to go see a movie about a slideshow anyway?" That's literally what I said. So, yeah, I just didn't believe it would become what it became. So, the whole process was amazing.

**中文翻译:**
而且大多数情况下，他都会采纳我们的建议。作为一个当时可能拥有世界上最大权力的人之一，他能如此周到地听取专家的意见，这真是一段令人愉悦的客户和咨询体验。我记得当时他们打电话告诉我这要拍成电影，而且已经拿到了资金。他们希望我们做大量工作让它达到电影级别。我永远忘不了我当时说的话：“哇，那我们要免费做很多工作，而且谁会去看一部关于幻灯片的电影呢？”我当时真的是这么说的。所以，我当时完全没预料到它会产生后来的影响。整个过程非常奇妙。

---

### [00:07:05] Lenny

**English:**
Did you expect the impact of what happened after that presentation or was it just like, oh, we got this one job we got to do, let's just get through it and then move on?

**中文翻译:**
你预料到那次演示之后产生的巨大影响了吗？还是当时觉得“哦，这只是我们要完成的一项工作，做完就结束了”？

---

### [00:07:14] Nancy Duarte

**English:**
Well, we've been doing it for five years. I think the strategy, whether it was intentional or not, I don't know. So, he would go city to city to city, because he was traveling for five years seeding, like planting seeds for a groundswell, and he went into, he would go to the Stanford campus invite the Bay Area Elite, and it was always private and it was always VIP. And so he did a really good job for five years, traveling, traveling, traveling, traveling and really delivering that talk. And I think that created a desire. I don't know that it would've gotten that much traction. I don't know if people already didn't know about the presentation and hadn't already seen the presentation and they brought their friends to the movie, is how I kind of picture at least that part happening.

**中文翻译:**
其实我们已经做了五年了。我不确定那个策略是否是有意为之，但他当时连续五年奔波于各个城市，就像在播种一样，为后来的爆发做铺垫。他会去斯坦福校园，邀请湾区的精英，那些活动通常是私密的、VIP 级别的。整整五年，他不停地旅行、演讲，把那个内容讲得非常透彻。我认为这创造了一种需求。如果人们之前不知道这个演示，或者没看过这个演示并带朋友去看电影，我不确定它是否会有那么大的影响力。

---

### [00:07:59] Nancy Duarte (Continued)

**English:**
And he was generous, Lenny. I mean, at the end, when he traveled around for those five years at the end, he always had a slide with our name on it and would thank us if you're in the audience. I mean, super, and paid, mostly paid for what we did that we did give a lot of our own time. But yeah, super generous and yeah, movie became what it was. It was a bit of a surprise. It was good. The movie was good.

**中文翻译:**
而且他非常慷慨，Lenny。在那五年的巡回演讲中，他最后总会放一张印有我们名字的幻灯片，如果我们在现场，他还会表示感谢。他支付了大部分费用，虽然我们也投入了很多私人时间。他非常慷慨，电影也大获成功。这确实有点出乎意料，电影拍得很棒。

---

### [00:08:24] Lenny

**English:**
It was good. It also makes me think about a pattern that I often see of it wasn't just one presentation that changed everything. It was, you said five years of prep ahead of that, and you always see these wow overnight success stories and you always find, okay, it wasn't actually that.

**中文翻译:**
确实很棒。这也让我想起了一个常见的模式：并不是某一次演示突然改变了一切。正如你所说，在那之前有五年的准备。人们总看到那些“一夜成名”的故事，但深入了解后会发现，事实并非如此。

---

### [00:08:42] Nancy Duarte

**English:**
Yeah, and he did a good job after, once it got traction, we built a whole training program where he could fly people out to his place in Tennessee and start to train people. So, it almost became a train the trainer and he could sanction you as a ambassador for it. So, it was just the way the whole thing kind of unfolded and scaled and then got traction was lovely.

**中文翻译:**
是的，在产生影响力之后，他也做得很好。我们建立了一套完整的培训计划，他会把人们接到他在田纳西州的住处进行培训。这几乎变成了一个“培训培训师”的项目，他可以授权你作为该项目的形象大使。整个事情展开、规模化并获得关注的过程非常完美。

---

### [00:09:03] Lenny

**English:**
Speaking of impressive clients, I only learned this recently, but Apple has been a client of yours since the day you were founded as an organization. Is that right?

**中文翻译:**
说到令人印象深刻的客户，我最近才了解到，苹果公司从你们成立之初就是你们的客户。是这样吗？

---

### [00:09:12] Nancy Duarte

**English:**
Yeah, it was. Yeah.

**中文翻译:**
是的，没错。

---

### [00:09:12] Lenny

**English:**
Okay. How did you land that initially? And then also just what have you learned from that experience that's informed your approach to presentation, design, communication, and how you work with clients?

**中文翻译:**
好。最初你是怎么拿下这个客户的？此外，你从那段经历中学到了什么，从而影响了你现在的演示、设计、沟通方式以及与客户合作的方式？

---

### [00:09:22] Nancy Duarte

**English:**
I love that question. So, yeah, I had a real job. I was working my real job and my husband had bought a Mac and he's like, "I think this is a business. I think it could be a real business." And he was an illustrator, wasn't a designer, but he had been a fine artist. And he's like, "Look, I can draw." Of course it's all pixelated and bit mappy. He goes, "Look, I could draw lines in here." And if I could show you his art studio, his work is just gorgeous. So, he's definitely a fine artist. And he's like, "I think this is a business. I think this could be a business." And I'm very pregnant. We were talking about that earlier. I am very pregnant with my son and I'm like, "Dude, you're going to go get yourself a real job. I don't want you playing around with this little Mac thing."

**中文翻译:**
我喜欢这个问题。当时我有一份正经工作。我丈夫买了一台 Mac 电脑，他说：“我觉得这可以做成一门生意，一门真正的生意。”他当时是个插画师，不是设计师，但他学过纯艺术。他说：“看，我能画画。”当然，当时画出来的全是像素点和位图。他说：“看，我能在里面画线。”如果你能看到他的画室，你会发现他的作品非常华丽，他绝对是个纯艺术家。他说：“我觉得这能成生意。”而我当时正怀着孕，就是我之前提到的我儿子。我说：“老兄，你去给自己找份正经工作吧，我不想让你整天捣鼓这台小 Mac。”

---

### [00:10:02] Nancy Duarte (Continued)

**English:**
And he begged me twice in our marriage. He literally has gotten on his knees and to try to get me to see his perspective begged me. He's like, "Just read a Mac World magazine, just read it through once, and if you still don't think this could become a thing ..." Because I was working on a mainframe, I'm like, I work on a real computer. So, what happened was I made some phone calls. I called NASA and I called Tandem, which is now HP, and I called Apple and we won contracts at all three brands at the same time. And back then our company was called Duarte Desktop Publishing and Graphic Design.

**中文翻译:**
在我们结婚期间，他求过我两次。他真的跪下来求我，想让我理解他的观点。他说：“就读一本《Mac World》杂志，从头到尾读一遍，如果你还是觉得这成不了气候……”因为我当时在操作大型机，我觉得我用的才是真正的电脑。结果是，我打了一些电话。我给 NASA、Tandem（现在的惠普）和苹果打了电话，我们同时赢得了这三个品牌的合同。当时我们的公司名叫“Duarte 桌面出版与平面设计”。

---

### [00:10:36] Lenny

**English:**
Oh, wow.

**中文翻译:**
噢，哇。

---

### [00:10:37] Nancy Duarte

**English:**
I know, I know. And we slipped in. When you talk about a product lifecycle, very early, everything was still bit mappy, was not attractive. Most people as users didn't know how to typeset, didn't know how to do columns, didn't know how to make in this tool at all. And there's about an 18 month window in the life cycle of the Macintosh where graphic designers refused to use it, refused. It's a toy, it's ugly, it's bit mapped. Nobody would do it, a font like that. We use Linotype. It was very, the snobby kind of, we won't touch it. And that's right when we entered right then went and checked out books at the library on type setting, we tried to figure out what we could do, what could we do with this tool, and then the rest was kind of history. And so that's how it started and the timing and just kind of pushing the tool that nobody was that interested in that we're in the design community. It was small adoption.

**中文翻译:**
我知道，我知道。我们切入的时机非常早。在产品生命周期的早期，一切都还是位图，并不美观。大多数用户不知道如何排版、分栏，完全不知道怎么用这个工具。在麦金塔（Macintosh）的生命周期中，大约有 18 个月的时间，平面设计师们拒绝使用它。他们觉得那是玩具，很丑，全是像素点。没人愿意用那种字体，大家都用 Linotype 排版机。那是一种很傲慢的态度，“我们才不碰那玩意儿”。而我们恰恰在那时进入了市场，去图书馆借书学排版，研究能用这个工具做点什么。剩下的就是历史了。这就是开始，时机很重要，我们推动了一个当时设计界没人感兴趣的工具，那时它的采用率还很低。

---

### [00:11:45] Lenny

**English:**
What did you take away from that experience that kind of informed what works and doesn't work in presentations?

**中文翻译:**
你从那段经历中总结出了什么？关于演示文稿中哪些有效、哪些无效？

---

### [00:11:51] Nancy Duarte

**English:**
Presentations used to be 35 millimeter slides in an old carousel. In fact, that's what Al Gore had when he showed, he was like, here's my slide carousel from the seventies. It was just how it was done. But Apple was the first company to hook up the computer to a projector at scale. Now the projectors at these big venues like San Jose Convention Center, I mean it was huge and it was risky. So, because we were first in, they pushed us to start to do the presentations in this tool and it was black and white. Everything was black and white when we first started. And then we started to push and push and push from how we illustrated things in the tool, how we would colorize clip art. I mean, I'm talking like clip art packages just came out and they're like, "Hey, grab these, colorize them."

**中文翻译:**
以前的演示文稿是放在旧式旋转幻灯机里的 35 毫米幻灯片。事实上，阿尔·戈尔展示时用的就是那个，他说：“这是我 70 年代的幻灯机。”当时就是这么做的。但苹果是第一家大规模将电脑连接到投影仪的公司。当时在圣何塞会议中心这样的大型场馆，投影仪非常巨大，而且风险很高。因为我们进入得早，他们推动我们开始用这个工具做演示。刚开始全是黑白的。然后我们不断尝试，研究如何在工具里画插图，如何给剪贴画上色。我指的是当时刚出的剪贴画包，他们说：“嘿，把这些拿去上色。”

---

### [00:12:32] Nancy Duarte (Continued)

**English:**
And so it was a really momentous moment to win them as an account. And I remember the tool had started to really take off and it was ugly. You can call it fugly, I don't know what you want to call it, but everyone who made slides did it so poorly, just so poorly. And we were kind of pushing the boundaries of it to make it look attractive. And there was a sales conference in 1992 in San Francisco and the leader of sales at the time was kind of a creative savant of sorts. And I remember he's like, "I don't know how you're going to do it, but I want you to take the whole slide." This is when slides were basically teleprompted covered in text. If you could stick a piece of clip art on it, you were lucky. And he said, "I want you to just make the whole slide, it's just covered with the word big in hot pink. And I want the background black, because when this slide pops up in all pink big, I want it to actually light the faces of the people in the audience."

**中文翻译:**
所以赢得他们这个客户是一个重大时刻。我记得那个工具开始流行时非常丑。你可以说它丑得离谱，当时每个人做的幻灯片都很糟糕。我们试图突破限制，让它看起来更美观。1992 年在旧金山举行了一次销售会议，当时的销售负责人是个创意天才。我记得他说：“我不管你们怎么做，我要你们占满整个幻灯片。”当时幻灯片基本就是写满文字的提词器，能放张剪贴画就算走运了。他说：“我要整张幻灯片只写一个大大的‘BIG’，用亮粉色，背景要黑色。因为当这张粉色的‘BIG’弹出来时，我要它照亮台下观众的脸。”

---

### [00:13:26] Nancy Duarte (Continued)

**English:**
And it was like I didn't know how to, we couldn't do that. We had to go into free hand, convert it to this, do these six steps, and then we came up with a small JPEG at the time or png or something and we scaled it up. So, it was still kind of pixelated. And I remember I was in that hall during the rehearsal and the production team gasped. Couple people squealed. They're like, "Who did this? I mean, it was just the word big in magenta pink." And I just remember thinking, this is how it's supposed to be done. Putting the tool in the hands of the masses kind of destroyed the medium itself.

**中文翻译:**
我当时都不知道该怎么做，我们做不到。我们必须先在 FreeHand 软件里画，转换格式，经过六个步骤，最后弄出一个很小的 JPEG 或 PNG 文件，然后再把它放大。所以当时还是有点像素感的。我记得彩排时我在大厅里，制作团队都惊呆了，有人甚至尖叫起来。他们问：“这是谁做的？”其实就是洋红色的“BIG”一个词。我当时就想：演示文稿就该这么做。把工具交给大众，反而某种程度上毁了这个媒介本身。

---

### [00:13:58] Nancy Duarte (Continued)

**English:**
And I feel like the first 10 or so years I was in business, it was reshaping this medium that ran amuck when it got into the hands of the users, it just went completely the opposite way that it was supposed to. So, it's weird to say that was a real defining moment for me to say, wait, we can do this different and we can return to how they used to be done when they were 35 millimeter slides. So, that's one story. And then I think we're very good at mapping to the brand requirements. So, we take this tool, whatever the tool, we have all our brands use different ones. They use Slides, Keynote, they use PowerPoint. We use whatever tool the brand wants and we push it in each medium. But we take their brand guidelines and really push it into the spoken word medium where when they stand up on a stage, it's cinematic. The visuals can become an experience in itself.

**中文翻译:**
我觉得我创业的前十年，就是在重塑这个被用户玩坏了的媒介。它完全背离了初衷。所以说，那是一个真正的转折点，让我意识到：等等，我们可以做得不一样，我们可以回归到 35 毫米幻灯片时代的那种质感。这是其中一个故事。另外，我认为我们非常擅长匹配品牌需求。无论客户用什么工具——谷歌 Slides、Keynote 还是 PowerPoint——我们都会根据品牌的要求，在每种媒介中发挥到极致。我们会遵循他们的品牌指南，并将其推向口头表达的媒介，让他们站在舞台上时，视觉效果具有电影感，本身就能成为一种体验。

---

### [00:14:57] Nancy Duarte (Continued)

**English:**
And I remember when Apple came up with the Think Different campaign. Steve Jobs was just back and my designer, everyone Photoshop was new. And everyone's doing these beveled backgrounds with tons of crap on the background. And I walked by, I'm like, "No, oh, we can't have a blue frame looking photo frame to for the Think Different campaign. This is not going to work." And so I remember looking at all the posters and remembering the Alfred Hitchcock ones. It had these particulates like these particulates, and it was just shadows.

**中文翻译:**
我记得苹果推出“不同凡想”（Think Different）活动时，乔布斯刚回归。当时 Photoshop 还是新鲜事物，我的设计师和所有人都在做那种带斜面效果、背景堆满杂物的图。我走过去说：“不行，‘不同凡想’活动不能用这种蓝框相框的效果，这行不通。”我看着所有的海报，想起了阿尔弗雷德·希区柯克（Alfred Hitchcock）的风格，那种带有微粒感、光影交错的感觉。

---

### [00:15:34] Nancy Duarte (Continued)

**English:**
And I found a stock video that Adobe had made at the time, and it was just particulates floating through the air at the angle and we stuck the six color apple on top of it. That was so revolutionary back there to push the brand and get out of the way every, the whole world was making these hideous templates. So, there are these moments that pushed the company forward because of an idea that I knew would not be okay for the Apple brand, therefore it shouldn't be okay for any brand. And I think those are just a couple stories of how to really push the medium in a way that is more pleasing to the audience. The audience just likes it better when it's really clear what you're supposed to focus on. We love that brand. We love it.

**中文翻译:**
我找到了 Adobe 当时制作的一段素材视频，里面是空气中飘浮的微粒，我们把六彩苹果标志放在上面。在那个全世界都在做丑陋模板的年代，这种做法非常具有革命性。正是这些时刻推动了公司的发展，因为我知道某些想法不适合苹果品牌，那么它们也不应该适合任何品牌。这些故事说明了如何以一种让观众更愉悦的方式去推动媒介的发展。当观众能清晰地知道该关注什么时，他们会更喜欢。我们非常热爱那个品牌。

---

### [00:16:22] Lenny

**English:**
Okay, so let's get a little tactical, because you're talking about some very specific things that you've found to be working. So, everyone listening to this podcast has probably heard many times it's really important to be great at presentations that there's so much power in storytelling and communication, all these things. And they probably read a bunch of books and blog posts and watch videos of how to give a great presentation. But myself, and I feel like most people sit down at a deck when they're about to present to an all hand, say a week later or are going to do a meeting. And I'm always just like, okay, what do I do? Okay, there's like a beginning, middle end, they should have some kind of problem. And it's always like, I don't know what I'm doing. So, if someone were to just be listening to this podcast and they're like, I'm going to write a post-it to myself of three bullet points of things that I should remember when I'm starting a deck, what are those three bullet points?

**中文翻译:**
好，让我们聊聊实操。你提到了一些非常具体的成功经验。听众们可能听过无数次“演示能力很重要”、“故事和沟通很有力量”之类的话，也读过很多书和博客。但我和大多数人一样，当要为一周后的全员大会或会议准备幻灯片时，坐下来还是会想：“我该怎么办？要有开头、中间、结尾，要有个问题……”但最后还是觉得无从下手。如果有人听这个播客，想在便利贴上写下三个开始制作幻灯片时必须记住的要点，那会是什么？

---

### [00:17:11] Nancy Duarte

**English:**
Your audience is the hero. That was in my TED talk from 2011. I would say it's infuse your talk with story. And I would say it is asking yourself, can they see what I'm saying? Those would be the three tips other than starting with empathy. I mean that that's, well, audience is the hero, is the empathy centric approach.

**中文翻译:**
第一，观众才是英雄。这是我在 2011 年 TED 演讲中提到的。第二，为你的演讲注入故事。第三，问问自己：他们能“看见”我所说的吗？除了以同理心开始之外，这就是那三个建议。其实，“观众是英雄”本身就是一种以同理心为中心的方法。

---

### [00:17:33] Lenny

**English:**
Let's dive into these then. And I was actually going to ask around empathy, and it feels like that comes up a lot in your recommendations to people's empathy is kind of the heart of your methodology of telling great stories, telling great presentations. So, let's spend a little time there. Why is that so important and what does that actually look like in practice?

**中文翻译:**
那我们深入探讨一下。我正想问关于同理心的问题，这似乎是你给出的建议中的核心——同理心是你讲好故事、做好演示的方法论灵魂。我们聊聊这个，为什么它如此重要？在实践中它又是怎样的？

---

### [00:17:50] Nancy Duarte

**English:**
Empathy is important to Duarte, everything we do is empathy first. And some of it comes from my own childhood story a little bit. I was raised by a clinically narcissistic mom and narcissist are missing the empathy gene. So, I feel like that void of not having it modeled for me is why I keep clawing at empathy as being important. And I think a lot of people listening might work for a boss that does not have empathy, that isn't other centric, that doesn't think before they talk and all of those things. And I was raised by someone like that. And so every single book and every single model that I ever make has empathy at the core because you have to have to think about who am I speaking with, especially in communication, who am I speaking with?

**中文翻译:**
同理心对 Duarte 公司至关重要，我们做任何事都是同理心优先。这部分源于我的童年。我是在一个临床诊断为自恋狂的母亲身边长大的，自恋者缺乏同理心基因。我觉得正是因为成长过程中缺乏这种榜样，我才一直执着于同理心的重要性。我想很多听众可能也在为缺乏同理心、不以他人为中心、说话不经大脑的老板工作。我就是被这样的人养大的。所以我写的每一本书、建立的每一个模型都以同理心为核心，因为你必须思考：我在和谁说话？尤其是在沟通中，受众是谁？

---

### [00:18:48] Nancy Duarte (Continued)

**English:**
So, when I went on my journey through storytelling, I figured out that I thought, okay, the presenter's the hero, for sure the presenter's the hero, they're the central figure. They're talking the most. They're well lit, they're up on a stage. So, when I started to look at all the archetypes, that's where I landed. And then I was like, oh my god. When I got to really digging into the mentor, I realized it's really the mentor in myths and movies that's the presenter and who really holds the power in the room of a presentation is the audience, the audience gets to make a choice if they accept or reject your idea. So, the balance of power is with them and not you. So, it really is the role of the presenter to be the mentor. And in myths and movies, the mentor comes alongside the hero. In other words, the presenter should come alongside the audience and help them get unstuck or bring a magical tool. So, I think Obi Won Kenobi's a great example.

**中文翻译:**
当我开始研究故事创作时，我起初以为演讲者是英雄，毕竟他们是中心人物，话最多，灯光打在他们身上，站在舞台上。但当我研究所有的原型时，我惊觉：天哪，在神话和电影中，演讲者其实应该是“导师”（Mentor）。在演示现场，真正掌握权力的是观众，因为他们可以选择接受或拒绝你的想法。所以权力平衡在他们手中，而不是你。演讲者的角色应该是导师。在神话和电影中，导师是陪伴在英雄身边的。换句话说，演讲者应该站在观众身边，帮助他们摆脱困境，或者带给他们一件“魔法道具”。我觉得欧比旺·肯诺比（Obi-Wan Kenobi）就是一个完美的例子。

---

### [00:19:32] Nancy Duarte (Continued)

**English:**
He did two things for Luke Skywalker. He gave him a light saber, which was for his outer journey, the physical journey he was doing, and then an inner tool, which was the resolve, which came to him through the force. So, when you're speaking to an audience, they're going to have an internal conflict that you have to give them something to soothe. And then you're asking them to therefore go and do this thing, take this action, do this call to action. That's asking them to physically do something or physically change in some way. So, they're not going to do that for you if you haven't empathetically thought about how hard what you're asking them is going to be for them to do. And so you have to change your mindset when you're starting to build your deck to think about who am I talking to? How am I going to help them get unstuck? And that's just a super foundational principle in everything we do.

**中文翻译:**
他为卢克·天行者做了两件事：给了他一把光剑，用于他的外部征程（物理上的旅程）；还给了他一个内部工具，即通过原力获得的决心。所以，当你面对观众演讲时，他们会有内心冲突，你需要提供一些东西来抚慰。然后你要求他们去做某事，采取行动。这是在要求他们做出物理上的改变。如果你没有设身处地地想到你所要求的任务对他们来说有多难，他们是不会为你去做的。所以，当你开始制作幻灯片时，必须转变心态：我在和谁说话？我该如何帮助他们摆脱困境？这是我们所有工作的核心基础原则。

---

### [00:20:29] Lenny

**English:**
What is an example of that in practice as we go through these? Because this is really great of that implemented the deck that we know about maybe?

**中文翻译:**
在实践中有什么例子吗？这听起来很棒，有没有哪个我们熟知的幻灯片案例应用了这个原则？

---

### [00:20:38] Nancy Duarte

**English:**
Oh, that we know about. So, I could talk about our own internal ones. Most of what we do is under MSAs because they're fantastical brands. So, in my own company, before I do a presentation that's going to require goals or them reaching goals or we do an annual vision talk, we do a listening tour first. So, some of it's based in survey, some of it's based in interviews. And we feed that information up and then we compare it to what we're going to ask them to do. And we do some gap analysis. We literally, there's some actual questions you can ask yourself, which are somewhat classic design thinking kind of questions about where they're at. And then what we do is I create a real rough cut or the exec team creates a real rough cut and then we invite the next level of leaders in and we do a fake, I mean the slides are ugly, we don't spend time on the slides.

**中文翻译:**
哦，大家熟知的。我可以聊聊我们公司内部的例子。因为我们的大多数工作都受保密协议（MSA）保护，毕竟都是些大品牌。在我自己公司，在进行涉及目标设定或年度愿景演讲之前，我们会先进行“倾听之旅”。部分基于问卷调查，部分基于访谈。我们将这些信息汇总，然后与我们准备要求员工做的事情进行对比，做“差距分析”。我们会问一些经典的“设计思维”式问题，了解他们的现状。接着，我会或高管团队会制作一个粗略的版本，邀请下一级领导进来，做一个模拟演示。幻灯片很丑，我们不在幻灯片上花时间。

---

### [00:21:31] Nancy Duarte (Continued)

**English:**
This is about the message and maybe a model or two or three that we're going to go through to feel like it may amplify or make the message more concrete. And then they get feedback and that's when it's hard. It's hard to go from rough cut, here's what we're going to say to making it absolutely resonate. And then we deliver it after all of that work has been done, then we share it to the company. So, we go through that knowing that's the hardest presentation I deliver all year. I used to travel and speak and be a public speaker, but it's my own internal ones I have to take more time with.

**中文翻译:**
重点在于信息本身，以及一两个能强化或具体化信息的模型。然后听取反馈，这才是最难的部分。从“我们要说什么”的草稿到让它产生共鸣，这个过程很艰难。只有在完成所有这些工作后，我们才会向全公司发布。这是我一年中最难做的演讲。我以前经常到处旅行做公开演讲，但对我来说，公司内部的演讲反而需要投入更多精力。

---

### [00:22:05] Nancy Duarte (Continued)

**English:**
So, when I travel and speak, they're like, oh my God, I love your models. Oh my gosh, can I get a picture with you? But when I'm standing in front of my own team, they're like, I wonder what she's going to say, because she's about to either make my job harder or she's going to change my priorities. They come in more skeptical. And we definitely have nailed the annual kickoff meeting. Definitely have nailed that. And then we do quarterly updates to that annual kickoff meeting. And it's a cadence and people get enthused and we're kind of killing it right now.

**中文翻译:**
当我外出演讲时，人们会说：“天哪，我太喜欢你的模型了，能合个影吗？”但当我站在自己团队面前时，他们想的是：“我想知道她要说什么，因为她要么会让我的工作变难，要么会改变我的优先级。”他们更持怀疑态度。我们现在已经完全掌握了年度启动会的门道，效果非常好。然后我们会进行季度更新。这种节奏让大家充满热情，我们现在的状态非常棒。

---

### [00:22:40] Lenny

**English:**
Yeah, that's what it feels like from the outside. I'm just thinking about the pressure to create presentations within Duarte Design. If you think about your job as hard, creating a deck for your company, imagine that.

**中文翻译:**
是的，从外部看确实如此。我只是在想，在 Duarte Design 内部制作演示文稿压力得有多大。如果你觉得自己的工作难，想象一下为你的公司做幻灯片得有多难。

---

### [00:22:52] Nancy Duarte

**English:**
Presentations in front of presentation experts is like-

**中文翻译:**
在演示专家面前做演示就像是……

---

### [00:22:55] Lenny

**English:**
Oh my god.

**中文翻译:**
天哪。

---

### [00:22:56] Nancy Duarte

**English:**
And I get nervous. I get really nervous because I have one slide that's kind of flawed or I say um or I pace too much. You lose a third of your team each time. They're such experts. So, it's hard.

**中文翻译:**
我会紧张，真的非常紧张。因为如果我有一张幻灯片有瑕疵，或者我说了“嗯”，或者走动太多，你每次都会失去三分之一团队的支持。他们太专业了，所以这很难。

---

### [00:23:10] Lenny

**English:**
I want to walk through these three bullet points. So, the first is make the listener the hero of your story. And that comes from being empathetic and understanding their challenge. So, if you're trying to do that, what are signs that you're doing it well or not well? Is there the way the flow of the story start? Is it the here's the way it starts? Or what should people identify of I'm doing this well or I'm not doing this well?

**中文翻译:**
我想梳理一下这三个要点。第一是让听众成为故事的英雄，这源于同理心和对他们挑战的理解。如果你尝试这样做，哪些迹象表明你做得好或不好？是故事的流程吗？人们该如何判断自己做得好不好？

---

### [00:23:31] Nancy Duarte

**English:**
If the audience is the hero, you would see visible signs that they get it. People would come before I did a really good talk and people were tweeting saying, "Hey, come to this talk. It's really good." So, you'd see a reaction. You know you've done it well if you're infusing your talk with story, which is the second bullet by utilizing story structures. So, when I say storytelling, I'm talking about an anecdote. When I say story structures, I'm talking about this format of a three act structure of storytelling that goes back tens of thousands of years, which is fused into the brain like FMRI machines now you can see them while a story's being told and the science is beautiful, if you're telling me a story and I'm listening, our brains are firing in the exact same order, in the exact same place. So, it has power to align our brains.

**中文翻译:**
如果观众是英雄，你会看到明显的迹象表明他们听懂了。在我做一场精彩演讲之前，人们会发推特说：“嘿，来听这个演讲，非常棒。”你会看到反馈。如果你在演讲中注入了故事（这是第二个要点），利用了故事结构，你就知道自己做得很好。当我提到“讲故事”时，我指的不只是轶事，而是那种可以追溯到几万年前的“三幕式结构”。这种结构已经融入了人类的大脑。现在的核磁共振（fMRI）研究表明，当你讲故事而我倾听时，我们的大脑会在相同的位置以相同的顺序产生反应。所以，故事具有让大脑同步的力量。

---

### [00:24:26] Nancy Duarte (Continued)

**English:**
And so by implementing attributes of story like a beginning, a middle, and an end, and we have method for that. And in also incorporating the rise and fall story kind of builds tension and releases it. And that's why we love it so much is we escape through someone else's messy middle and conflict and problems like it's messy and then it resolves. You build the tension and resolve it. And that's what a really well structured presentation can do. It can pull on that rise and fall in a way that creates longing.

**中文翻译:**
通过实施故事的属性——开头、中间和结尾（我们有一套方法），并结合起伏，故事可以建立并释放张力。这就是为什么我们如此热爱故事：我们通过别人的“混乱中期”、冲突和问题来获得情感宣泄，看着事情从混乱到解决。建立张力并解决它，这就是一个结构良好的演示文稿能做到的。它能利用这种起伏来创造一种渴望。

---

### [00:24:58] Nancy Duarte (Continued)

**English:**
So, story creates longing. It helps people long for something they'd never wanted before because if the future is told in the shape of a story and they see this alternate future, so many people escape through sci-fi. They escape through movie making into these future worlds. And so picture that you could verbally paint a picture of this future state and then you could bring your whole audience to this future state in an amazing way using this cadence of rise and fall. That's how you can incorporate story into a presentation where you need to influence others, actually really can be beautiful when it's done well.

**中文翻译:**
故事创造渴望。它帮助人们渴望以前从未想过的事物。如果未来是以故事的形式呈现的，人们看到了另一种未来，就像很多人通过科幻小说或电影逃往未来世界一样。想象一下，你可以用语言描绘出未来的状态，然后利用这种起伏的节奏，以一种奇妙的方式带领观众进入那个未来。这就是在需要影响他人时，如何将故事融入演示的方法。做得好的话，真的会非常动人。

---

### [00:25:38] Lenny

**English:**
And so you gave a TEDx Talk on this exact topic. And so I want to go deeper here. And you kind of shared this very visual way of thinking about a great story where it kind of goes up and down and up and down these teeth almost. Can you actually talk about-

**中文翻译:**
你曾就这个话题做过一次 TEDx 演讲。我想深入探讨一下。你分享过一种非常直观的思考好故事的方法，它就像锯齿一样上下起伏。你能聊聊……

---

### [00:25:51] Nancy Duarte

**English:**
[inaudible 00:25:51] pumpkin teeth. Yeah, it does.

**中文翻译:**
（笑）像南瓜灯的牙齿。是的，确实如此。

---

### [00:25:54] Lenny

**English:**
Can you share what that structure visually looks like? And we'll share a link in the show notes of what that actually looks like and then just why that is so impactful and important.

**中文翻译:**
你能描述一下那个结构在视觉上是什么样的吗？我们会在节目介绍里分享链接，但请解释一下为什么它如此有影响力且重要。

---

### [00:26:02] Nancy Duarte

**English:**
Yeah, I love that. So, I went on a three year journey through story and I knew that the greatest speeches overall time did have that rise and fall and rise and fall. But it wasn't one single story. It had a whole lot of other very important information, but it still did this rise and fall and risen fall. So, I am not a digital native. I took a quarter inch graph paper and I would listen to all kinds and map out, took the words. When I analyzed Steve Jobs's iPhone launch speech, I did it all by hand. I wrote every word I did quarter inch graph paper. I needed to know, I needed to see it the way I work, which was analog. And so at first it was zigzaggy and I realized, wait, you can't map something over time and have it be a zigzag.

**中文翻译:**
我很乐意。我曾花了三年时间研究故事，我发现古往今来最伟大的演讲都有这种起伏。它不只是一个单一的故事，它包含很多重要信息，但依然保持着这种起伏。我不是“数字原住民”，我拿了一张四分之一英寸的方格纸，听各种演讲并把它们画出来。当我分析史蒂夫·乔布斯的 iPhone 发布会演讲时，我是手写的，记下了每一个词。我需要以我习惯的模拟方式来看待它。起初它是锯齿状的，但我意识到，你不能在时间轴上把东西画成简单的锯齿。

---

### [00:26:49] Nancy Duarte (Continued)

**English:**
There was too much data lost. So, to verbally describe it, you could picture a line at the bottom of your screen and that line going left to is what is. And you need to set up every talk by stating what is. And then it moves straight up and you move to what could be come back down to the bottom line again say what is, back up, what could be, what is, what could be, what is, what could be? And then at the last what could be you state the last horizontal line is what we call the new bliss. So, this motion of traversing between what is, what could be, what's is, what could be, what is, what could be, that sense of longing for the future, it makes people leave their current state or the status quo or our current reality and makes them long for this future state by using contrast.

**中文翻译:**
那样会丢失太多数据。用语言描述的话，你可以想象屏幕底部有一条线，从左往右代表“现状”（What is）。每次演讲你都需要先陈述现状。然后线条向上移动，进入“愿景”（What could be），接着再回到基准线说“现状”，再上去说“愿景”……如此反复。最后一次“愿景”之后，最后一条水平线就是我们所说的“新蓝图”（New bliss）。这种在“现状”与“愿景”之间来回穿梭的运动，利用反差让人们脱离现状或现实，转而渴望未来的状态。

---

### [00:27:37] Nancy Duarte (Continued)

**English:**
So, that rise and fall of hey, here's our current problem, here's a solution, or here's the state of the union. But we imagine it could look like this. There's so many different ways to build that cadence of contrast that's so lovely. I mean it really works. I think the talk came out in 2011 and the amounts of notes and emails of things people have accomplished by changing the structure of their presentation has been really astounding.

**中文翻译:**
这种起伏就像是：“嘿，这是我们目前的问题，这是解决方案”，或者“这是现状，但我们想象它可以变成这样”。建立这种反差节奏的方法有很多，非常美妙。它真的很有效。我的那次演讲是 2011 年发布的，后来我收到的感谢信和邮件数量惊人，人们通过改变演示结构取得了很多成就。

---

### [00:28:09] Lenny

**English:**
The State of the Union is a really interesting example because I'm trying to imagine this and presentations I've seen and that totally resonates of just like, here's the problem we're having and here's where we're going to go. Here's another problem we're having. Here's what I'm going to change.

**中文翻译:**
“国情咨文”是一个很有趣的例子。我试着回想看过的演示文稿，这种模式确实能引起共鸣：“这是我们遇到的问题，这是我们要去的地方。这是另一个问题，这是我要做出的改变。”

---

### [00:28:20] Nancy Duarte

**English:**
Steve Jobs was great at that. When he launched the iPhone speech, he always did, here's the state of the company, here's how we're doing. Oh my God, our stores are more full than 10 Mac world expos. He always did a setup of what was going on. And then he did a really rapid what is, what could be when he started to compare the iPhone to the Blackberry. It's like, look how much it sucks now that you've seen what we're doing. It's just what is, what could be, what is, what could be. And so I took all the classic speeches, historical speeches, everything, presidential speeches and knew that if I could find a pattern in Dr. King and Steve Jobs's iPhone launch speech that was the same, that had the same type of nature of cadence and pulsing to it, for lack of a better word, that I knew I had solved it using story. It was a really great moment to finally draw that out on my quarter inch graph paper.

**中文翻译:**
史蒂夫·乔布斯非常擅长这个。在 iPhone 发布会上，他总是先说：“这是公司的现状，这是我们的表现。天哪，我们的零售店比 10 个 Macworld 博览会还要拥挤。”他总是先铺垫现状。然后当他开始把 iPhone 和黑莓手机对比时，他进行了一连串快速的“现状与愿景”对比：“看，既然你已经看到了我们在做什么，现在的产品是多么糟糕。”我研究了所有经典演讲、历史演说、总统演说，我发现如果我能在马丁·路德·金和乔布斯的演讲中找到相同的模式——那种相同的节奏和“脉动感”——我就知道我用故事结构解开了谜题。在方格纸上画出那个图时，真的是一个伟大的时刻。

---

### [00:29:19] Lenny

**English:**
I love that.

**中文翻译:**
我太喜欢这个了。

---

### [00:29:19] Nancy Duarte

**English:**
It was awesome.

**中文翻译:**
那感觉太棒了。

---

### [00:29:22] Lenny

**English:**
I feel like there's just so much opportunity for primary research that still I feel like that's why my newsletter does well is I just spent the time doing that work that you're describing of watching a thousand interviews and then just distilling, here's a takeaway here.

**中文翻译:**
我觉得原始研究中蕴含着巨大的机会。我想这也是为什么我的时事通讯做得不错的原因——我花时间做了你描述的那种工作：观看一千次采访，然后提炼出核心要点。

---

### [00:29:34] Nancy Duarte

**English:**
Pattern finding, that's an interesting point. I worry sometimes with the emergence of new technologies and stuff, the ability to be able to sit and think, synthesize and all of that is because a human's going to come up with different insights and synthesis than any future machine can do. So, I think it's fascinating that you do that so well and it really shows that.

**中文翻译:**
寻找模式，这是一个有趣的观点。我有时担心，随着新技术的出现，人们静坐思考、综合分析的能力会下降。人类能产生与未来机器完全不同的洞察和综合思考。我觉得你做得这么好，这非常了不起。

---

### [00:29:34] Lenny

**English:**
Wow, I appreciate that.

**中文翻译:**
哇，谢谢你的夸奖。

---

### [00:29:59] Nancy Duarte

**English:**
Yeah, you're really putting your mind and heart into it all.

**中文翻译:**
是的，你确实全身心地投入其中。

---

### [00:30:02] Lenny

**English:**
Enough about me, I'm thinking about, but I appreciate it, I'm thinking about product managers and founders maybe listening to this and they're like, oh man, every time I do a deck, I need to create this whole story and this up and down thing. In your experience, when do you go that far to create? Is this when you have an epic important presentation, you think about a story structure like this, or is there always a way you should put this into your presentations of some kind of story with this contrast?

**中文翻译:**
不说我了。我在想，听这个节目的产品经理和创始人可能会想：“天哪，难道我每次做幻灯片都要构思整个故事和这种起伏吗？”根据你的经验，什么时候需要做到这种程度？是只有在极其重要的演讲时才考虑这种故事结构，还是说所有的演示都应该加入这种带有反差的故事元素？

---

### [00:30:31] Nancy Duarte

**English:**
It's interesting question. I think a lot of people think that the only time you really need to present well is when you have a big stage talk and you make the big investment in the script, the big investment in the contrasting story. But I'll tell you a dirty little secret. I can get my husband to do chores for me on the weekends with a real quick, what is, what could be new bliss, kind of just that first bit, what is, what could be new bliss. It's like even the very, very short talk that Abraham Lincoln gave in the Gettysburg address, it was basically a funeral, it was a eulogy. And back then eulogies used to be two hours long. It was an Aristotelian structure and he only had a couple hundred words, so there's no pictures of him giving it because it was so short, so tight and done.

**中文翻译:**
这是一个很有趣的问题。很多人认为只有在大型舞台演讲、投入大量精力写脚本和构思反差故事时才需要好好表现。但我告诉你一个秘密：在周末，我只需要用一个简短的“现状、愿景、新蓝图”就能让我丈夫帮我做家务。就像亚伯拉罕·林肯在葛底斯堡演说中那样，那本质上是一场葬礼上的悼词。当时的悼词通常长达两小时，遵循亚里士多德式的结构，而他只用了几百个字。因为演讲太短、太精炼，甚至都没留下他演讲时的照片。

---

### [00:31:16] Nancy Duarte (Continued)

**English:**
They were setting up the cameras, still thinking they had tons of time. So, the ability to just have that contrast as a framework in your brain during a meeting, on a phone call, any moment of influence, getting the husband to do some chores for me, literally it works. It works in any format. And I think the investment that you make in the longer form or when it's a huge audience, you add the visuals, you really hire the speaker coaches, you really make that moment. And there's these moments that breach above all other moments where you really have to nail it just in basic conversations, in a moment of influence. If you practice it enough, it'll live in your head as a mental model for when you're in a situation where there's influence in the air that you could do.

**中文翻译:**
当时摄影师还在架相机，以为还有大把时间。所以，在会议中、电话里，或者任何需要发挥影响力的时刻（比如让丈夫做家务），脑子里有这种“反差”框架是非常有用的。它适用于任何形式。当然，对于大型活动或面对大量观众，你会投入更多，增加视觉效果，聘请演讲教练。但在日常对话或需要发挥影响力的时刻，如果你练习得足够多，它就会成为你脑中的心智模型，随时随地发挥作用。

---

### [00:32:07] Lenny

**English:**
How do you actually do it with your husband if you could share for helping you do the dishes?

**中文翻译:**
你能分享一下你是怎么对你丈夫用这一招的吗？比如让他洗碗？

---

### [00:32:11] Nancy Duarte

**English:**
Well, I won't get graphic about what the new bliss might be, but early in our marriage we figured out that, not early, I actually spent almost in the only the last 10 years we've been married for 40. And we realized that when we tangle it's usually only about process. So, the gaps are if I ask or he asks me to do something or we start to kind of pick on each other, it's because the way I'm executing something is different than the way he chose to execute it. And so it'll be anything from like, "Why are you chopping onions like that?" He'll say to me. And now I'm like, oh, we have a process gap. "Do you want to chop the onions or do you want me to chop them my way?" So, for the what is, what could be new bliss, it happens all the time.

**中文翻译:**
关于“新蓝图”具体是什么，我就不细说了（笑）。我们结婚 40 年了，直到最近 10 年我们才意识到，我们的争吵通常只是关于“流程”。如果我们互相挑剔，通常是因为我做事的方式和他不一样。比如他会问：“你为什么那样切洋葱？”现在我会意识到：哦，这是流程差异。我会问：“你是想切洋葱，还是想让我按我的方式切？”至于“现状、愿景、新蓝图”，这随时都在发生。

---

### [00:32:59] Nancy Duarte (Continued)

**English:**
So, he needs a lot of context. He's a detail-oriented person and I've started to learn with him that my what is needs to be quite a bit longer than sometimes I have patience for as I start to frame, "Oh hey baby, I need you to take the dog over to the dog care." I don't start there. I start with, "Oh my gosh, tomorrow I've got back to back meetings, in fact, I'm going to be on Lenny's Podcast right about here. And that's when she's whiny. And what's going to happen is if that doesn't happen, I'm going to have to reschedule next week and next week it's just loaded up. And you know how it is when I'm stressed out at the end of the day and I'm kind of hard to deal with and I say, well, what could be, the doggy place, she was loved it last time she was spooning with a red cavalier king spaniel and loved it."

**中文翻译:**
他需要很多背景信息。他是个注重细节的人，我学会了对他的“现状”描述要比我平时的耐心长一点。我不会直接说：“嘿亲爱的，我需要你把狗送到宠物店。”我会先说：“天哪，我明天会议排满了，实际上我还要参加 Lenny 的播客。那时候狗狗会很闹。如果不送走，我下周就得重新安排时间，而下周已经排满了。你知道我压力大时到傍晚会很难相处。但是，如果送去宠物店，她上次在那儿和一只骑士查理王小猎犬玩得可开心了。”

---

### [00:33:46] Nancy Duarte (Continued)

**English:**
It's like that, I have to unpack it a little bit more for him. And then the new bliss could be any sort of marital promise you want it to be, but I just have to unpack the current state a little bit of the process, and then I state what could be. And it's funny because acts of service like that, like him taking the dog to the doggy daycare for me or is I feel loved. So, when someone does something generous with their time for me, it's how I feel loved. And so there's a whole lot there in shaping how you communicate with someone. Empathetically at my company, everyone knows each other's love language. They know that this person feels more appreciated when they get a written note. This person feels more appreciated when they get a gift and everyone knows that. So, that's just baked into our, I don't know, our marriage, our company, just how it rolls.

**中文翻译:**
就像这样，我得为他多铺垫一点。然后“新蓝图”可以是任何你想要的婚姻承诺。我只需要先解释一下现状和流程，然后陈述愿景。有趣的是，像他帮我把狗送到托管中心这种“服务行动”，会让我感到被爱。当有人慷慨地为我付出时间时，这就是我感受爱的方式。所以，在与人沟通时，同理心非常重要。在我们公司，每个人都知道彼此的“爱之语”（Love Language）。他们知道某人更喜欢手写便条，某人更喜欢礼物。这已经融入了我们的婚姻和公司文化。

---

### [00:34:43] Lenny

**English:**
I imagine people listening to this podcast were not expecting marriage advice. And so I love that. I'm going to try.

**中文翻译:**
我想听众们肯定没预料到会听到婚姻建议。我太喜欢这个了，我也要试试。

---

### [00:34:50] Nancy Duarte

**English:**
You can scrap that if it doesn't work the process tip though is good.

**中文翻译:**
如果没用你可以把它删掉，不过那个关于“流程”的建议确实不错。

---

### [00:34:52] Lenny

**English:**
This is going to be the best part. This is going to be the whole podcast is just the segment. Just joking. But this is really good advice. I'm going to try to use it myself. So, the structure, I think it's even easier to think about this less as story, infused story. For me it's more this, what is, what could be, what is the ideal bliss, that's almost the simpler way to think about it. The story is this like, oh my God, I got to think of a story.

**中文翻译:**
这会是整集最精彩的部分，甚至可以单独拿出来。开个玩笑，但这确实是很好的建议。我也打算试试。关于这个结构，我觉得把它想成“现状、愿景、理想蓝图”比想成“注入故事”更容易理解。对我来说，这更简单。一提到“故事”，人们总会想：“天哪，我得编个故事。”

---

### [00:35:17] Nancy Duarte

**English:**
It has a beginning, middle, and an end. So, the first, what is is the beginning. The middle is the messy middle. That's where you're trying to contrast and show them that it's messy. It might be hard, it's worth it. And then the new bliss, you end with what in western cultures, where's like a happy ending. So, the new bliss is just imagine a world with your idea adopted, and then you paint a picture of that world poetically or pragmatically, and it works. It definitely works.

**中文翻译:**
它有开头、中间和结尾。第一个“现状”是开头。中间是“混乱的中期”，你要通过反差展示现状的混乱，虽然过程可能很难，但值得。最后是“新蓝图”，在西方文化中这就像是一个大团圆结局。新蓝图就是：想象一下你的想法被采纳后的世界。你可以用诗意或务实的方式描绘那个世界。它非常有效。

---

### [00:35:41] Lenny

**English:**
Okay, this is really great. So, just to recap, point one is to make your listener the hero of the story and come at it with empathy. And I was actually thinking the Think Different campaign is an excellent example of that because it's about you thinking differently and being this incredible creative. And then item two is infuse your presentation with story and this what is, what could be new bliss. And then, okay, and number three, what was number three again?

**中文翻译:**
太棒了。总结一下：第一点是让听众成为故事的英雄，并带着同理心。我刚才在想，“不同凡想”活动就是一个绝佳的例子，因为它关乎“你”如何不同凡想，如何成为一个了不起的创意人。第二点是为演示注入故事，即“现状、愿景、新蓝图”。那么第三点是什么来着？

---

### [00:36:09] Nancy Duarte

**English:**
Oh, it was ask yourself if they can see what you're saying. Can they see what I'm saying would be written on the note?

**中文翻译:**
哦，是问问自己：他们能“看见”我所说的吗？在便利贴上写下：“他们能看见我说的吗？”

---

### [00:36:16] Lenny

**English:**
I love this. Okay, let's talk about that. What does that mean and how do you do that?

**中文翻译:**
我喜欢这个。好，我们聊聊这个。这意味着什么？该怎么做？

---

### [00:36:20] Nancy Duarte

**English:**
Yeah, so for people to see what you're saying, that you have an opportunity to use visual tools like the presentation software, you have opportunities to have live sketchers sketch it while you're talking. There's so many ways you can help people see what you're saying. I would contend that you can use something in your talk that gives people something they'll always remember. We call that a star moment. And it could be a piece of dramatic data where the big numbers put up there. It could be an evocative story, it could be a beautiful picture. And one of the things that happens really well, especially with tech companies, is demonstrating through a picture so you can get alignment.

**中文翻译:**
为了让人们“看见”你所说的，你可以利用演示软件等视觉工具，也可以请速写师在你演讲时现场作画。有很多方法可以帮助人们视觉化你的信息。我认为你可以在演讲中加入一些让人永远记住的东西，我们称之为“明星时刻”（STAR moment）。它可以是一个震撼的数据，一个感人的故事，或者一张美丽的图片。特别是在科技公司，通过图片进行演示非常有效，因为这能让大家达成共识。

---

### [00:37:20] Nancy Duarte (Continued)

**English:**
So, the concept of a diagram when you describe your product that you're working on, is this thing inside of it, outside of it attached to it, is it on it is above it, especially architecture slides or just how technology works as something flows through a complex system. When people can see that and it accompanies your verbal narrative, they can actually understand what you're conveying and move on. If you only had a verbal narrative, it wouldn't work as well. There's a lot of times though, where you don't have the support of a presentation or slides. You could be at a dinner table. If you're in a interesting conversation and you want someone to see what you're saying, that's where you pull out the napkin and you draw it.

**中文翻译:**
比如当你描述正在开发的产品时，用图表展示：这个部件是在内部、外部还是连接在上面？是在上方还是下方？特别是在架构图或展示技术如何在复杂系统中流动时。当人们能看到图表并配合你的口头叙述时，他们才能真正理解并继续听下去。如果只有口头叙述，效果没那么好。但很多时候你没有幻灯片支持，比如在餐桌上。如果你在进行有趣的对话并希望对方“看见”你的想法，那就拿出餐巾纸画出来。

---

### [00:38:03] Nancy Duarte (Continued)

**English:**
So, you could both see it, in meetings sometimes someone will just walk right up to the board and draw something. And my team, especially my design team is so good at this because they'll just stand up and say, I want to draw for you what I see, because we're about to prepare them to present to an audience. When you verbally said that, I saw this, was that your intent? And then the room will stand up and we'll start all co-creating a graphic so that everyone sees the exact same thing, the exact same steps, the exact same insights in the order. So, nobody leaves with a question in their mind. And that's just so important for there to be an alignment around what is this? What are we all fighting for? What are we all living for? What are we all working for?

**中文翻译:**
这样你们都能看到。在会议中，有时有人会直接走到白板前画图。我的团队，尤其是设计团队非常擅长这个。他们会站起来说：“我想画出我脑海中看到的画面。”因为我们要准备向观众演示。他们会问：“当你口头说出那个想法时，我看到的是这样，这是你的本意吗？”然后全屋的人都会站起来共同创作一个图形，确保每个人看到的都是相同的东西、相同的步骤和相同的洞察顺序。这样没人会带着疑问离开。达成共识至关重要：这是什么？我们为什么而奋斗？为什么而活？为什么而工作？

---

### [00:38:53] Nancy Duarte (Continued)

**English:**
And those moments of alignment are so, so important. And I'm a leader who sees things in the air. I just see it. And to me, my pattern finding nature, which you're like that too. I could see these patterns and to me, I see a whole scene and I could see it all clearly, but when my team's trying to look at the same thing, they might see 22 mosaic tiles out of a massive mosaic beautiful picture. I see the final beautiful picture, but I've only served up a little tiny mosaic tile in a few places. And so I even have to be better about really bringing it to earth and saying, oh, here's the seven steps to get to this amazing outcome.

**中文翻译:**
这些达成共识的时刻非常重要。作为一个领导者，我能看到“空气中”的东西，我能直接看到愿景。我有寻找模式的天赋，你也是。我能清晰地看到整个场景，但当我的团队看同样的东西时，他们可能只看到了宏大马赛克画作中的 22 块瓷砖。我看到了最终的美丽画面，但我只在几个地方展示了微小的瓷砖。所以我必须做得更好，把它落到实处，说：“哦，这是达到这个惊人结果的七个步骤。”

---

### [00:39:31] Nancy Duarte (Continued)

**English:**
Sometimes we see things so plainly in our mind's eye, and I was working with a really famous, powerful CEO and as she was talking, it's like, yeah, I could see her. I was watching her hand motions too, and she was like in this thing and she's moving her arms around in a distinct way and I said, I can tell you you have a picture in your mind's eye. Let me draw for what I, and I did the same thing, walked up, drew had this, had this, had this. And she's like, "Exactly." And we were brought in because nobody could articulate at all what she saw in her mind's eye. And so that was a massive program to be rolled out to the entire retail. It was like a hundred thousand retail workers needed to understand this graphic and the whole process she was trying to roll out wasn't getting traction. So, the minute people could see what she was saying, then it had all the breakthroughs that needed to happen around that program.

**中文翻译:**
有时我们在脑海中看得很清楚。我曾与一位非常有名、有权势的 CEO 合作，当她说话时，我观察她的手势，她以一种独特的方式挥动手臂。我说：“我能感觉到你脑海中有一幅画。让我画出我看到的。”我走上前，画出了几个关键点。她说：“完全正确！”我们被请去是因为没人能表达出她脑海中的愿景。那是一个要推广到整个零售部门的大型项目，十万名零售员工需要理解这个图表。她之前推行的流程一直没有进展，但当人们能“看见”她所说的话时，项目立刻取得了突破。

---

### [00:40:04] Lenny

**English:**
That reminds me of when I was working on the super host program at Airbnb. I don't know if the story will be of any interest to anyone, but I just remember I had this very clear handset of motions that described the strategy of the super host program. And then my friend's like, you should draw this on a slide-

**中文翻译:**
这让我想起我在 Airbnb 负责超赞房东（Superhost）项目的时候。我不知道大家是否感兴趣，但我记得我有一套非常清晰的手势来描述该项目的策略。然后我的朋友说：“你应该把它画在幻灯片上……”

---

### [00:40:19] Nancy Duarte

**English:**
You should draw it. Unless it's such a powerful hand gesture, right? Yeah, you could do that because your body is visual. And the other thing we try to get our customers to do is, if Dr. King had slides that day of the I Have a Dream speech, it just wouldn't been as beautiful. His words painted the pictures in our mind's eye. And so when we can have the slides off so people are focused on the verbal stream and what's coming out of your mouth that is such a powerful moment is to not have any visuals supporting you. So, they're a hundred percent focused on your body, how you're showing up and on the words coming out of your mouth and they're verbally seeing what you're saying versus actually pictorially seeing what you're saying. It's good.

**中文翻译:**
你应该画出来。除非那个手势本身非常有力量。是的，你可以这样做，因为你的身体也是视觉化的。我们还尝试让客户明白：如果马丁·路德·金在发表《我有一个梦想》演讲那天用了幻灯片，效果就不会那么美妙了。他的语言在我们的脑海中勾勒出了画面。所以，有时关掉幻灯片，让人们专注于你的言语和表达，是一个非常强大的时刻。他们会百分之百地关注你的身体语言和言辞，他们在语言中“看见”你所说的，而不是通过图片。这很好。

---

### [00:41:03] Lenny

**English:**
I like the idea that people are not staring at me and I prefer them distracted with a slide and I want to talk about nerves and stuff presenting in a bit. But that's interesting. So, you were talking about very kind of some concrete tips for slides and something I've heard a lot is when you're sharing a deck internally or talking an internal meeting, it's really powerful to just have obviously just a quick image thing, but then also the title of the slide is the point you want them to get from that slide. Is that something you recommend? And then generally any just very tactical advice on how to make a slide effective?

**中文翻译:**
我其实挺喜欢观众不盯着我看，我宁愿他们被幻灯片分散注意力（笑），稍后我想聊聊演讲时的紧张问题。但这很有趣。你刚才提到了一些具体的幻灯片技巧。我常听说，在内部会议分享幻灯片时，除了图片，幻灯片的标题应该是你希望观众从中获取的核心观点。你推荐这种做法吗？此外，关于如何让幻灯片更有效，还有什么实操建议吗？

---

### [00:41:35] Nancy Duarte

**English:**
Yeah, the concept that each slide should make one point. So, your whole presentation should be grounded in what we call the audience journey, which is the big idea where you're trying to move them from where you're trying to move them to. Then a big idea is what is your point of view and what's at stake if they do or do not adopt it? That's the organizing mechanism for your whole deck. And then each slide itself that supports that one big, big idea, each slide itself should make one point in support of that big idea. People can't process too many things at one time, so depending on where you work, some people want something that's not the key insight at the top of the slide, some people do. So, some might want the action to be taken or some might want the dreamy future state to be clear.

**中文翻译:**
是的，每张幻灯片应该只表达一个观点。你的整个演示应该基于我们所说的“观众旅程”，即你想把他们从哪里带到哪里。你的“核心大创意”（Big Idea）是你的观点，以及如果他们采纳或不采纳会有什么后果。这是整个幻灯片的组织机制。而支持这个大创意的每张幻灯片，本身也应该只表达一个支持该大创意的观点。人们无法同时处理太多信息。根据工作环境的不同，有些人希望在幻灯片顶部放核心洞察，有些人则不。有些人希望明确要采取的行动，有些人则希望展示美好的未来状态。

---

### [00:42:22] Nancy Duarte (Continued)

**English:**
Some consulting firms where the slides are much denser because they were paid millions of dollars to make a big old deck. Some of them are like, "Oh, it always belongs in the lower right corner." So, it's kind of a little bit up to the brand and everyone believes it belongs somewhere else. If you're making what we call a slide doc, which I think your listenership would be interested in, presentations go from big staged event to in a meeting where you're trying to persuade your peers too. Can I make a presentation I can just circulate on email and everyone gets it? Well, that's called a slide doc. You put more words, you put stronger picture. You could have a hundred page appendix and maybe the front of it's only five slides, but everything they need to see your thinking, it follows behind it.

**中文翻译:**
在一些咨询公司，幻灯片非常密集，因为他们收了数百万美元来制作厚厚的幻灯片。有些人觉得核心信息应该在右下角。这取决于品牌，每个人对位置的看法都不一样。如果你在制作我们所说的“演示文档”（Slide Doc）——我想你的听众会对这个感兴趣——演示的形式可以从大型舞台活动延伸到说服同事的会议。我能不能做一份可以直接通过邮件传阅且大家都能看懂的演示？这就是“演示文档”。你会放入更多文字和更有力的图片。你可能有 100 页的附录，而正文只有 5 页，但所有能体现你思考的内容都在后面。

---

### [00:43:08] Nancy Duarte (Continued)

**English:**
And you could circulate those and people read it. You write full sentences, you write full pros. It's kind of like the six page memo that's so popular to Amazon, but we contend that the F words and pictures, the six page memo is better. So, how do you send a memo around without the help of a presenter? And that's on one extreme. And those are called slide docs that you build in presentation software. And then the other extreme is I'm on a massive stage somewhere and there's all kinds of usage in between. And so I think the one idea per slide is important. And then this guiding principle, don't make a single slide unless it supports the one big idea of your whole talk. That's another principle for slide making, because most people go back to some sort of repository in some data store somewhere and they dig through old crappy slides and see if they can assemble something super quickly.

**中文翻译:**
你可以传阅这些文档，人们会去阅读。你会写完整的句子和段落。这有点像亚马逊流行的六页备忘录，但我们认为结合了文字和图片的版本比单纯的六页备忘录更好。那么，如何在没有演讲者的情况下传达备忘录？这就是一个极端，即在演示软件中制作的“演示文档”。另一个极端是站在宏大的舞台上。在这两者之间还有各种用途。我认为“每张幻灯片一个观点”很重要。还有一个指导原则：除非能支持整个演讲的核心大创意，否则不要制作任何一张幻灯片。这是另一个原则，因为大多数人习惯去旧幻灯片库里翻找，试图快速拼凑出一份东西。

---

### [00:44:01] Nancy Duarte (Continued)

**English:**
And that's a cop out. Most of the time if you really think empathetically about your audience, going to the repository might get you halfway there, but you should be modifying and mapping all of the content based on who you're talking to and especially if it's high stakes. And sometimes you're speaking to an audience that wants high density slides, because that's how they communicate in their culture. And if you showed up with cinematic stage ready slides, they'd laugh you out of the room. And so you really got to, I mean, you got to know your audience, you got to know how they communicate, who they talk to and map to that.

**中文翻译:**
那是偷懒。大多数时候，如果你真的设身处地为观众着想，翻找旧幻灯片可能只能帮你完成一半，你应该根据受众修改和匹配所有内容，尤其是在关键时刻。有时你的观众可能就喜欢高密度的幻灯片，因为那是他们的沟通文化。如果你拿着电影感十足的幻灯片去，他们可能会把你哄出来。所以你必须了解你的观众，了解他们的沟通方式，并以此进行匹配。

---

### [00:44:39] Lenny (Sponsorship Segment)

**English:**
This episode is brought to you by Eppo. Eppo is a next generation A/B testing platform... [Sponsorship details omitted].

**中文翻译:**
本集节目由 Eppo 赞助，这是一款下一代 A/B 测试平台……（此处为赞助商广告内容）。

---

### [00:45:59] Lenny

**English:**
What's your take on the Minto Pyramid principle? I don't know if you think about that. Yeah, because there's a recommendation of just start with the conclusion and then explain why. And you're saying sometimes that's effective, sometimes not. Maybe in [inaudible 00:46:00]-

**中文翻译:**
你对“金字塔原理”（Minto Pyramid Principle）怎么看？我不知道你是否考虑过这个。它建议先说结论，然后再解释原因。你刚才说这有时有效，有时无效。

---

### [00:45:59] Nancy Duarte

**English:**
Sometimes it's effective. So, the Minto principle is amazing. She's got the, was it horizontal and vertical thinking? So, your main segues or your main section head should add up and then all the slides should support it. And then also how the construct of it is and when you state the conclusion first, that's a great thing to do with execs. It's a great thing to do when you are fundraising. There's a certain type of an audience that works for, and there's other audiences where they really need to be taught to long for this future state and you need longer to unpack it. So, one of the reasons you would start with the conclusion is especially in a funding round, now my version of a conclusion or result or is different than how she describes it. Because I would say you start with the new bliss.

**中文翻译:**
有时确实有效。金字塔原理很棒。她提出了水平思考和垂直思考。你的主要过渡或章节标题应该能逻辑自洽，所有幻灯片都要支持它。先说结论的做法非常适合高管，也非常适合融资。它适用于特定类型的观众。但对于其他观众，他们需要被引导去渴望未来的状态，你需要更长的时间来展开。在融资轮中先说结论的一个原因是——不过我对“结论”或“结果”的理解与她不同。我会说，你应该从“新蓝图”开始。

---

### [00:47:02] Nancy Duarte (Continued)

**English:**
So, if you're trying to raise funds, you would say, I am going to share with you something today and you share how your solution increases human flourishing. It needs to be tied to the humanness and the big problem you're going to solve and how humankind will benefit. Well, that's different than just a consultant would show up and say, hi, I have this 800 page deck and the results of it are this. Let's unpack it. It's just a completely different motion and we use a three act story structure that's quite a bit different too. But that work is solid and it was based kind of like my work, her work was based in going super deep in McKinsey's thinking over time, whereas my work is going laterally across the 35 highest performing brands in the world that have been our customers. So, I went laterally across all those brands and then come up with solutions that are based, foreign story and are based in a bit of a broader application across companies that I have tons of respect for that body of work.

**中文翻译:**
如果你在融资，你会说：“今天我要和大家分享一些东西”，然后分享你的解决方案如何促进人类的繁荣。它需要与人性、你要解决的大问题以及人类如何受益联系起来。这与一个顾问拿着 800 页幻灯片说“结果如下，让我们展开聊聊”完全不同。这是完全不同的运作方式，我们使用的是三幕式故事结构，也有很大不同。但她的研究非常扎实，她是深入研究麦肯锡的思维方式，而我是横向研究全球 35 个最顶尖品牌的案例。我从这些品牌中总结出基于故事、应用范围更广的解决方案。我对她的研究成果充满敬意。

---

### [00:47:57] Lenny

**English:**
Awesome. And willing to, I wrote a post about this whole concept for folks that want to dig deeper. Maybe one more question around tactical slide stuff, and I know this is, people ask you about this stuff all the time, but I can't help it. I guess just any other tips for just like you're sitting there trying to create a couple slides. What else maybe people should keep in mind to make it effective and let's say this is for a small meeting kind of thing.

**中文翻译:**
太棒了。我也写过一篇关于这个概念的文章，供想深入了解的人参考。关于幻灯片的实操，可能还有一个问题——我知道人们总是问你这些，但我忍不住想问。当你坐下来准备做几张幻灯片时，还有什么建议能让它更有效？假设这只是一个小型的会议。

---

### [00:48:18] Nancy Duarte

**English:**
Yeah, that's a good question. I think that if do some thinking first, if it's important, if it's an important point of the meeting, my team is taught to just kind of sketch, change your environment up a little bit. A lot of people will fire up the deck, which is very linear. It's like make one slide, second slide, third slide. So, just think and plan for a minute. And we tend to draw up storyboards. It's like, okay, the first point, the second point, the third point or the just think first. It can be analog or digital. Put a page in front of all your decks. It's just boxes. Just get the narrative right. And then when you actually open up the software, that's where you have to think about, what's the slide type that will convey this the most? Is it a table? Put a table. Especially for program managers, you have to convey dense project information, program information, product information, and that comes with density.

**中文翻译:**
好问题。我认为首先要思考。如果这是会议的一个重点，我会教我的团队先打草稿，换个环境思考。很多人一上来就打开软件，那是线性的思维：第一张、第二张、第三张。你应该先思考和规划。我们倾向于画故事板：第一点、第二点、第三点。无论是模拟还是数字方式，在开始做幻灯片前先理清叙事。当你真正打开软件时，再考虑：哪种幻灯片类型最能表达这个观点？是表格吗？那就用表格。特别是对于项目经理，你需要传达密集的项目、计划或产品信息，这必然涉及高密度。

---

### [00:49:12] Nancy Duarte (Continued)

**English:**
So, if you're in a room with your peers and everyone in the room is a team and everyone has their own shorthanded and way of working, put that common slide up there. That common slide for that team might be dense to the outside world, but everyone's used to using it so there's no harm in using a commonly known, commonly acceptable framework or slide or table or Excel spreadsheet because you're aligning around a process. And so don't feel like every needs like cinematic pictures of kittens because that's not going to get you anywhere. You're trying to move an objective along, and that does mean that your slides might be more dense and sometimes internal slides have a lot more important information that needs to be on it to kick a product along or kick a process along.

**中文翻译:**
如果你和同事在一起，大家是一个团队，有共同的工作语言，那就用大家熟悉的幻灯片。对外界来说那可能太密集，但团队成员都习惯了，所以使用通用的框架、表格或 Excel 并没有坏处，因为你们是在围绕流程达成共识。不要觉得每张幻灯片都需要电影感的小猫图片，那没用。你的目标是推动项目进展，这意味着幻灯片可能会很密集。内部幻灯片通常需要包含大量重要信息，以推动产品或流程的进行。

---

### [00:50:00] Lenny

**English:**
You were just talking about process and that is a great segue to a question I wanted to ask is just what does your process look like when you're working with a company to help them craft an awesome presentation?

**中文翻译:**
你刚才提到了流程，这正好引出了我想问的问题：当你帮助一家公司制作出色的演示文稿时，你们的流程是怎样的？

---

### [00:50:10] Nancy Duarte

**English:**
Yeah. Yeah. It's funny because I don't have to do this much anymore. I haven't done it for about 15 years, which is nice. I have a gorgeous team of strategist, writers, conceptual thinkers, beautiful design.

**中文翻译:**
是的。很有趣，因为我已经大约 15 年没亲自做这些了，这挺好的。我有一支由策略师、撰稿人、概念思考者和优秀设计师组成的强大团队。

---

### [00:50:22] Lenny

**English:**
I was curious.

**中文翻译:**
我很好奇。

---

### [00:50:24] Nancy Duarte

**English:**
Coaches. Yeah, I know. I get coached. It's fun. I definitely, my books look awesome, not because of me, but because I'm followed around by people that do really gorgeous work. But the phrase that we use internally and sometimes with customers is we make presentations the way Pixar makes movies. And that's very similar to the way we get somebody that has this high stakes moment where it's a big deal in this moment. You have to win in the moment to push things along. And so we do, we literally craft a narrative, craft the big idea, craft the script and visualize certain moments. We start to map it out, we start to chunk it out.

**中文翻译:**
还有教练。是的，我也接受教练指导，这很有趣。我的书看起来很棒，不是因为我，而是因为我身边有一群做出华丽作品的人。我们内部以及有时对客户说的一句话是：“我们像皮克斯制作电影一样制作演示文稿。”这非常类似于我们处理关键时刻的方式。在那些必须赢下的时刻，我们精心构思叙事、核心大创意、脚本，并将特定时刻视觉化。我们开始规划，分块处理。

---

### [00:51:05] Nancy Duarte (Continued)

**English:**
And then big models sometimes when you're really making a revolutionary model, one that could drive all the web assets, a lot of that stuff people don't realize actually happens in the presentation first as an idea. So, sometimes we'll start working on some of the key models right away too, and we start to circulate that around the company, because everyone has to build consensus around it. So, sometimes there's multiple motions happening at the same time. Let's sketch this. You go away, you work with this department, you try to get this settled, you get that set, you get this.

**中文翻译:**
有时当你制作一个革命性的模型（比如能驱动所有网络资产的模型）时，人们没意识到很多想法其实最先出现在演示文稿中。所以有时我们会立即开始制作一些关键模型，并在公司内部传阅，因为每个人都需要达成共识。所以有时会有多个动作同时进行：画草图、与某个部门沟通、敲定某个细节等等。

---

### [00:51:36] Nancy Duarte (Continued)

**English:**
And then it gets reassembled at the end. And then the narrative is where you work all the kinks out and then when they stand and deliver, it's like, yes, it's the voice track that all the process supported. And then other times we're building a report in a slide doc, or there was a time where we had a head of a multinational company that will remain nameless and the guy that was head of all of India was going to come over here and petition the CEO for a hundred million dollar budget.

**中文翻译:**
最后再重新组装。叙事是解决所有问题的关键。当演讲者上台时，所有的流程都支撑着他的表达。还有些时候，我们是在制作“演示文档”报告。有一次，一家跨国公司的印度区负责人要来向 CEO 申请 1 亿美元的预算。

---

### [00:52:09] Nancy Duarte (Continued)

**English:**
It's not trivial. And he comes, is like, "Okay, I need your help with these five slides." And he just sends us the five slides and we're like, "Well yeah, a hundred million. That's kind of a lot. You really want to put technology between you and the CEO. Do you really want to sit side by side and both be looking at a computer in this moment where it's like you're petitioning him for, that's a lot of money." And he's like, "Yeah, you're right." So, what we did is we made a mental model he could hold up in his head and the structure was so simple and clear. And then there was three moments where we're like just, I don't know, just grab a piece of paper or go to a whiteboard and just start to draw in front of him. Let him see your eyes, let him have eye contact.

**中文翻译:**
这可不是小事。他找过来说：“我需要你们帮我处理这五张幻灯片。”他把幻灯片发给我们，我们说：“1 亿美元，这可是一大笔钱。你真的想在自己和 CEO 之间放一个电脑屏幕吗？在申请这么多钱的关键时刻，你真的想和他并排坐着盯着电脑看吗？”他说：“是的，你说得对。”于是，我们为他建立了一个心智模型，结构非常简单清晰。我们建议他在三个关键时刻直接拿张纸或去白板前画图。让他看到你的眼睛，保持眼神交流。

---

### [00:52:46] Nancy Duarte (Continued)

**English:**
Let him see your passion. Don't be dispassionately looking at this computer. And he did it and he called us and he's like, "I got a hundred million bucks." So, it's just those moments where you have to realize, wait, wait, wait, wait. Do I need a deck? Who am I talking to? And should is this a cookie cutter thing? And does the same process work every time? No. So, every time we solve something it's very different and we try to make it unique to the presenter and the audience that they're speaking to.

**中文翻译:**
让他看到你的激情，而不是冷冰冰地盯着电脑。他照做了，后来打电话告诉我们：“我拿到了那 1 亿美金。”所以，在这些时刻你必须意识到：等等，我真的需要幻灯片吗？我在和谁说话？这不应该是千篇一律的。同样的流程并不适用于每一次。我们每次解决问题的方式都不同，力求让它对演讲者和观众来说都是独一无二的。

---

### [00:53:18] Lenny

**English:**
Along the same lines, a lot of presentations now are actually remote and on Zoom and virtual. What do you recommend to people in terms of how they present and put presentations together being remote?

**中文翻译:**
顺着这个话题，现在很多演示都是远程的，通过 Zoom 或虚拟会议。对于远程演示和制作幻灯片，你有什么建议？

---

### [00:53:28] Nancy Duarte

**English:**
Yeah, it's funny, we spent a lot of time coaching people to look in the camera. So, while I've been talking to you, I'm not actually looking at your face. I'm looking at the little dot at the top of my screen and my camera. And not a lot of people can do that. So, it's gotten to where I can see that little white glowing dot and my heart warms, I know you're there, I feel you. I can get sensations in my skin when I know I'm talking to someone that I adore or admire. And that took a long time to get there. And I was presenting remotely pre COVID. So, a lot of our coaching was about eye contact and doing that. The other thing that happens is people don't see our hands anymore. They're under the table. They can't see how much space in a room we're taking up.

**中文翻译:**
很有趣，我们花了很多时间教人们盯着摄像头看。所以，当我跟你说话时，我其实没在看你的脸，而是在看屏幕上方摄像头那个小点。很多人做不到这一点。现在我已经习惯了，看到那个发光的小白点，我心里就暖暖的，我知道你在那儿，我能感觉到你。当我面对我钦佩的人说话时，我甚至能感觉到皮肤的触感。这需要很长时间练习。在疫情前我就开始远程演示了。所以我们的很多辅导都是关于眼神交流。另一件事是人们看不到我们的手了，手都在桌子下面，他们看不到我们在房间里占据了多少空间。

---

### [00:54:15] Nancy Duarte (Continued)

**English:**
They can't see a lot of the characteristics that are common in communicating. And so there's a lot of coaching around presence and how do you have presence in a room? How do you even get the microphone away from someone that's remote and all those kinds of things. And a new study just came out, I just came across my desk today and it said that soft skills really suffered. And the people who did it right say and looked at the camera, they don't have good eye contact skills anymore. When they are looking face-to-face in someone's eyes, it's like, oh, they're not used to it. It's been so long.

**中文翻译:**
他们看不到很多沟通中常见的特征。所以有很多关于“存在感”的辅导：如何在房间里建立存在感？如何从远程参与者手中拿回话语权？今天我刚看到一项新研究，说人们的软技能确实退步了。那些习惯盯着摄像头看的人，在现实中反而失去了眼神交流的能力。当他们面对面看着别人的眼睛时，会觉得不习惯，因为太久没这么做了。

---

### [00:54:50] Nancy Duarte (Continued)

**English:**
And then the other thing is, where do I sit in a room who's got the position of authority? Just kind of some classic things that convey information in real life. So, it's interesting, it peaked and now people are going back to the office some. A percent are back in the office. And now we have this weird place where it's, oh, it's half in the office and half people are remote. And the people that are remote are having a hard time getting their voices heard because the people in the room consume most of the air. So, it's kind of going through this undulating life cycle of new communication skills people need while they're remote. It's all changing.

**中文翻译:**
还有就是，在房间里我该坐哪儿？谁拥有权威地位？这些都是现实生活中传达信息的经典要素。有趣的是，远程办公达到顶峰后，现在人们开始回归办公室。现在处于一种尴尬的状态：一半人在办公室，一半人远程。远程的人很难发出声音，因为办公室里的人占据了大部分“空气”。人们在远程办公时需要学习全新的沟通技巧，一切都在变化。

---

### [00:55:34] Lenny

**English:**
I'm glad that I was not a PM in this remote world to be honest. I never experienced it, but I have a lot of empathy for being a product manager in this remote work world. Feels like the job got a lot harder.

**中文翻译:**
老实说，我很庆幸自己没在远程办公时代当产品经理。我没经历过，但我非常同情远程办公环境下的产品经理。感觉这份工作变得难多了。

---

### [00:55:44] Nancy Duarte

**English:**
It did. I think it did.

**中文翻译:**
确实如此，我也这么认为。

---

### [00:55:46] Lenny

**English:**
Yeah. So, let's talk about nerves and stage fright. So, I hate public speaking. I get extremely nervous people. They may not feel this when they watch me, but it's not my natural state. You work with a lot of people that I imagine are like, oh my god, I'm so scared to give this presentation. What advice do you give them to help them through that and feel more comfortable?

**中文翻译:**
好，那我们聊聊紧张和怯场。我讨厌公开演讲，我会非常紧张。人们看我演讲时可能感觉不到，但这绝不是我的自然状态。你接触过很多人，我猜他们也会说：“天哪，我太害怕做这个演示了。”你会给他们什么建议来帮助他们度过难关并感到更自在？

---

### [00:56:06] Nancy Duarte

**English:**
Yeah, I think people who are more thoughtful and contemplative about speaking have better content. They tend to really think through stuff than someone who's like, I got this. I'll just wing it. I'll just walk on the stage. Anyone who's like, tells me I am a nervous presenter, I'm like, you have probably got gorgeous content in your heart that the world needs to hear, because usually they are really deep and thoughtful. Like you already mentioned, you're a pattern finder and you like to do thoughtful work. And so it's hard. My husband is actually a brilliant communicator, just getting him to feel like he wants to take up the space. He's a better communicator than I am. And so what happens is the reason you get scared, it's a fight or flight instinct. For some reason stepping out on that stage, you feel your body and your mind and your psyche is feeling threatened like you would be attacked by an animal.

**中文翻译:**
我认为，那些对演讲持审慎和沉思态度的人，往往有更好的内容。他们会深思熟虑，而不是像某些人那样说：“没问题，我即兴发挥就行。”每当有人告诉我他演讲时很紧张，我会说：“你内心一定有非常精彩的内容想分享给世界。”因为紧张的人通常思考得更深。就像你提到的，你是个寻找模式的人，喜欢做有深度的工作。这很难。我丈夫其实是个出色的沟通者，但他很难让自己去占据那个舞台空间。他其实比我更擅长沟通。你感到害怕的原因是“战斗或逃跑”的本能。出于某种原因，踏上舞台时，你的身体和心理会感到受威胁，就像要被野兽攻击一样。

---

### [00:56:56] Nancy Duarte (Continued)

**English:**
That's literally what's happening. And so you couple things you could do. You can actually sit in one of the seats of the auditorium and just sit there and look at the stage, look at the setting so you can imagine yourself on it. But then picture yourself as that friendly face, the one that's happy to see you, the one that's delighted that you're speaking. And then as you're standing up, remember that you saw yourself sitting there smiling and very happy. You have to change your visual model that people's faces will be scowling, they'll be judging you, they'll be doubting you. All of those things are only in your head because getting you out on the stage to be able to start to expose people to this amazing content you have, the biggest battle is to get you out on this stage and delivering it.

**中文翻译:**
事实就是这样。你可以做几件事：你可以先坐在礼堂的一个座位上，看着舞台，想象自己站在上面。然后，把自己想象成台下那张友善的面孔——那个很高兴见到你、很期待你演讲的人。当你站上台时，记住你曾看到自己坐在那里微笑。你必须改变脑海中的视觉模型，不要觉得人们会皱眉、评判或怀疑你。那些都只是你的想象。为了让你把精彩的内容呈现给观众，最大的挑战就是让你走上台并把它讲出来。

---

### [00:57:47] Nancy Duarte (Continued)

**English:**
And I asked a bunch of people once, I did a survey of all these public speakers and was like, how do you prepare? How do you prepare? What's your pre-talk ritual? And some of them were like, "I play heavy metal music and I skip around the entire convention center, just get all fired up." I'm like, "Wow, I have to calm myself down because I already have over to the top energy." So, I literally find the dark. I don't go to the green room, that stuff. I don't like to hear gibber jabber. I have to be focused on my content. And so I find the darkest corner of the backstage and calmly sit and just breathe. I just breathe. Sometimes if I'm nervous, if there's someone real famous in the audience, I have a little list playlist of funny things that people sent me, but I never watch. And that way right before I walk on stage, I chemically, my whole body chemically shifts from nervous to laughter. And that really helps me too, because it's chemical and you have to train your chemistry a bit.

**中文翻译:**
我曾调查过很多公开演讲者，问他们如何准备，有什么演讲前的仪式。有人说：“我会放重金属音乐，在整个会议中心跳来跳去，让自己兴奋起来。”我说：“哇，我得让自己冷静下来，因为我本来就精力过剩。”所以我通常会找个黑暗的地方。我不去休息室，我不喜欢听闲聊，我需要专注于内容。我会躲在后台最暗的角落，静静坐着呼吸。有时如果我很紧张（比如台下坐着名人），我会看一段搞笑视频列表。这样在登台前，我身体的化学反应会从紧张转为大笑。这很有帮助，因为这涉及生理化学，你需要训练自己的化学反应。

---

### [00:58:46] Lenny

**English:**
I really like that tip. What are these funny things you watch if you-

**中文翻译:**
我非常喜欢这个建议。你通常看什么搞笑的东西？

---

### [00:58:50] Nancy Duarte

**English:**
It's like YouTube things, TikTok things. Just things that I tag and I try not to watch them or things that make me laugh. There's this dorky low watched video of a guy with tin cans wrapped around his waist and he plays them. And my husband walks around the house like him and making the noise and I could probably sing the beat if I had to. And so sometimes I just play that, because it just transports me home, because a lot of times I'm presenting away from home and it just makes me laugh at my husband who's hysterical. So, it's just random things, but if you laugh and somehow can transport yourself outside of the fear of walking out there, it helps reset you before you walk out on stage.

**中文翻译:**
就是 YouTube 或 TikTok 上的东西。我会标记一些让我发笑的内容，平时尽量不看。有一个点击量很低的搞怪视频，一个男人腰上缠着锡罐并敲打它们。我丈夫常在家里学他，发出那种声音，我甚至能唱出那个节奏。有时我会放那个视频，因为它能让我感觉回到了家。因为我经常在外地演讲，这能让我想起我那滑稽的丈夫并开怀大笑。就是些随机的东西，但如果你能笑出来，就能把自己从恐惧中抽离，在登台前完成心理重置。

---

### [00:59:39] Lenny

**English:**
I really like that. Is there anything else just off the top of your head that just like right before you go on stage that you find to be really effective? So, watching funny videos, I love that. [inaudible 00:59:47] use it. Anything else?

**中文翻译:**
我真的很喜欢这个。还有什么你觉得在登台前非常有效的招数吗？看搞笑视频这招太棒了，我打算用。还有别的吗？

---

### [00:59:48] Nancy Duarte

**English:**
I breathe. I think I've learned a breathing pattern. I take a deep, deep breath and then I take that one while my lungs are full, I take another gulp of breath and I have to let it out real slow. But when I got the feedback that my friend and some people get over their fear by headbanging to heavy metal, so I'm not saying that's not the wrong thing. So, I thought, well, maybe I should try that before I do a talk. And so I literally didn't do that. But I stretched, I jumped a little, just low jumps, put my arms real big up in the air. And then I walked on stage and I happened to be speaking at a massive medical company, like big brand. And I finished my talk and my assistant got a call and they were like, "We're little worried about Nancy. We think she might need to see a doctor. She could never control her breathing and we're really concerned."

**中文翻译:**
呼吸。我学会了一种呼吸模式：深吸一口气，在肺部充满时再补吸一小口，然后慢慢呼出。我听说有些朋友通过听重金属音乐摇头晃脑来克服恐惧，我觉得这也没错。所以我曾想，也许我也该试试。我没真的摇头，但我做了拉伸，跳了几下，把手臂高举。然后我上台了，那次是在一家大型医疗公司演讲。演讲结束后，我的助手接到电话说：“我们有点担心 Nancy，觉得她可能需要看医生。她好像一直无法控制呼吸，我们很担心。”

---

### [01:00:38] Nancy Duarte (Continued)

**English:**
And it was just because I just pumped myself up a little bit. So, I don't do that whatsoever anymore. I went back to my calming, contemplative, meditative pre-talk ritual. So, for some people, literally I do encourage people to try headbanging to heavy metal. It might work. It's just a matter of what you need. And nobody would guess that I'm not one to dance around or pump myself up, but I am not, I have to calm myself down. It's the opposite.

**中文翻译:**
那只是因为我当时把自己搞得太兴奋了。所以从那以后我再也不那么做了。我回到了冷静、沉思、冥想式的演讲前仪式。对某些人来说，我确实鼓励尝试重金属摇头，可能有效。这取决于你需要什么。没人能猜到我不是那种会跳舞或自我激励的人，我必须让自己冷静下来，这完全相反。

---

### [01:01:09] Lenny

**English:**
Awesome. Just a few more questions.

**中文翻译:**
太棒了。最后还有几个问题。

---

### [01:01:12] Nancy Duarte

**English:**
Sure.

**中文翻译:**
好的。

---

### [01:01:12] Lenny

**English:**
So, you wrote a book called Illuminate and something that stood out to me from that book is this idea of a torch bearer and torch bearer leader. Can you just talk about what that is and why that is important in power?

**中文翻译:**
你写过一本书叫《点亮》（Illuminate），书中令我印象深刻的是“火炬手”（Torchbearer）和“火炬手领导者”的概念。你能聊聊那是什么，以及为什么它在发挥影响力时很重要吗？

---

### [01:01:22] Nancy Duarte

**English:**
Yeah, I loved writing that book. Co-author Patty Sanchez, a hat tip to her. So, to come up with this book, we knew that there's one presentation, there's a single presentation, could be on a stage, could be in a meeting, just updating people on a project status. And we knew though that every presentation usually is part of a larger movement where you're trying to move people in mass to this alternate future. So, we studied movements, we deconstructed the largest movements. We met with Marshall Ganz at Harvard to say, "Hey, could this be true?" Because he studies movements. It was so fun. And then movements have a five act structure. So, picture, there's this moment where you have to verbalize the dream like, hey, we're going to head to this new place and this is what I have to do at my kickoff meetings. It's like imagine this place in the future that we're headed to.

**中文翻译:**
我很喜欢写那本书，也要向合著者 Patty Sanchez 致敬。在写这本书时，我们意识到，虽然演示文稿可能只是一次舞台演讲或一次项目进度汇报，但通常它是更大规模运动的一部分，你试图带领大众走向另一种未来。所以我们研究了各种运动，解构了那些伟大的运动。我们还咨询了哈佛大学研究运动的 Marshall Ganz。这非常有趣。运动有一个“五幕结构”：梦想（Dream）、跳跃（Leap）、战斗（Fight）、攀登（Climb）、到达（Arrive）。想象一下，你必须用语言表达梦想，就像我在启动会上做的那样：“想象一下我们要去的那个未来。”

---

### [01:02:15] Nancy Duarte (Continued)

**English:**
So, it's five steps, it's a five act story structure, if you want to call it five acts. It's dream, leap, fight, climb, arrive. So, the torch bearer, the reason we called that is the leaders know where they're headed, but they might not ever see it super, super clearly. And we chose a torch because a torch, if you're in a cave and you have a torch, you only see about five, eight feet around you, but it's enough to dissipate the fear of the people following you in. And so nobody sees the future clearly. Nobody has that kind of level skill. All we know is I need to traverse this direction to be at the right place in the future so all my staff is safe, all are, we stay a leader in the industry. That's all I know.

**中文翻译:**
这就是那五个步骤。之所以叫“火炬手”，是因为领导者知道要去哪里，但可能看得不是特别清楚。我们选择“火炬”这个意象，是因为如果你在山洞里拿着火炬，你只能看到周围五到八英尺的地方，但这足以消除跟随者的恐惧。没人能看清未来，没人有那种超能力。我们只知道需要朝这个方向走，才能在未来处于正确的位置，确保员工安全，保持行业领先。我只知道这些。

---

### [01:03:09] Nancy Duarte (Continued)

**English:**
And as we start to head there, there's these moments of communication you need to do, which is, hey everyone, here's the dream. Here's where we're headed. That's the dream phase. Then there's this moment where they either choose to jump in and go with you or they choose not to. You could talk about Frodo like Sam and only a few hobbits followed him. And so it's like people select to commit this journey. That's the beginning of your movement. But then the middle is the messy middle of a story. We call it the fight and climb phase. So, what happens is they commit to your idea, they commit to your program, your project, and they're like enthused at first. And then they go into the state of, oh my God, this is harder than I thought. It's a long slog. This climb is getting exhausted.

**中文翻译:**
当我们出发时，需要进行沟通。首先是“梦想”阶段：“嘿大家，这是我们的梦想，我们要去的地方。”然后是一个时刻，人们选择是否加入。就像佛罗多一样，只有山姆和几个哈比人跟随他。人们选择投身这段旅程，这就是运动的开始。中间部分是故事中“混乱的中期”，我们称之为“战斗与攀登”阶段。人们起初对你的想法或项目充满热情，但随后会进入一种状态：“天哪，这比我想象的难多了。这是一场持久战，攀登过程让人精疲力竭。”

---

### [01:03:53] Nancy Duarte (Continued)

**English:**
I don't know if I have this much fight in me to make this all work, not fight with each other, but like, oh my God, I'm having to overcome this roadblock and that roadblock and we have to go get that budget. So, it's just, it's like a fight, climb, fight, climb, fight, climb. And then ultimately you arrive. Each one of those five phases you need to use speeches, stories, ceremonies and symbols at each phase to give the people traveling with you the emotional fuel they need to keep going, to keep seeing that idea become realized. And it literally is about fueling the right emotions with speeches, stories, ceremonies, and symbols while you're moving people toward a bigger initiative. So, it's bigger than just one presentation, it's multiple presentations, multiple stories, multiple ceremonies. So, I loved that book. People are really feeding off of it right now because leading change has been nonstop. It's just been change, change, change the last especially few years.

**中文翻译:**
“我不知道我是否还有斗志去完成它。”这不是指互相争斗，而是指克服一个又一个障碍，去争取预算。这就是战斗、攀登、再战斗、再攀登。最后，你到达了。在这五个阶段的每一个阶段，你都需要利用演讲、故事、仪式和象征，为同行者提供继续前进的情感动力，让他们看到想法变成现实。这本质上是在推动大型倡议时，通过这些手段注入正确的情感。所以它不只是一次演示，而是多次演示、多个故事和多次仪式。我很喜欢那本书，现在人们非常需要它，因为变革从未停止，尤其是过去几年，一直在变。

---

### [01:04:40] Lenny

**English:**
Change is the only constant like they say.

**中文翻译:**
正如人们所说，唯有变化是永恒的。

---

### [01:04:42] Nancy Duarte

**English:**
Exactly.

**中文翻译:**
没错。

---

### [01:04:43] Lenny

**English:**
I really like this metaphor of the torch giving you a sense of, as a leader, you can see some portion around you, but you're not going to see the entire cave necessarily. That is really interesting. Maybe a final question very tactically is I give an interview where you shared that you had kind of two videos, one where it's very informal, you're just standing in front of whiteboard in jeans or something, just talking about some about data, I think in presentations. And then you had a similar video where it was very well constructed, high production value, and the informal video did a lot better. Is that something you're seeing? Just that kind of content ends up being more successful and why do you think that is?

**中文翻译:**
我很喜欢火炬这个比喻：作为领导者，你能看到周围的一部分，但不一定能看到整个山洞。这很有趣。最后一个实操性的问题：我听过你的一次采访，你提到你有两个视频，一个是穿着牛仔裤站在白板前非常随意地聊数据，另一个是制作精良、高成本的视频，结果那个随意的视频效果好得多。这是你观察到的趋势吗？为什么这种内容反而更成功？

---

### [01:05:21] Nancy Duarte

**English:**
I think video content, production quality now isn't the expectation for it being high quality. It's just completely shifted over the last five, eight years or so as everyone's an expert and can show up as an expert. There's a big difference to me about showing up as a keynoter, which is like, I'm going to stand, I'm going to look right. I'm going to have this eye contact, I'm going to nail it. My slides are gorgeous, I'm driving the industry. And for people to think that our explanations of things needs to be done as a stand and deliver keynote, that's just not true. So, I experimented with that and I had some videos I had done, and one of them, like you said, was me looking in the camera. I even had HD makeup, a film crew. I was well lit, I looked amazing. I mean, I did look amazing and it was polished.

**中文翻译:**
我认为现在人们对视频制作质量的期待已经改变了。在过去五到八年里，随着每个人都能以专家身份出现，情况完全变了。对我来说，作为主旨演讲者出现（站姿端正、眼神交流、幻灯片华丽、引领行业）与日常解释事物是不同的。人们认为所有的解释都必须像正式演讲一样，这其实不对。我做过实验：一个视频里我盯着摄像头，画了高清妆容，有摄制组，灯光完美，我看起来棒极了，非常精致。

---

### [01:06:09] Nancy Duarte (Continued)

**English:**
I delivered it really well. And then I thought, because on LinkedIn I post a lot, that's where my primary channel is, and I thought what would happen if I just posted a rando shot of me? And I'm maybe airing on a little bit like orange, I look a little Trumpian, a little bit orange. It's not color corrected, but it's super informative, really full of information. And that was my highest viewed video so far. And I realized that it's like people want the content and we do as a presentation company, I have to nail it maybe more than others, but it doesn't have to be fully video edited, infographics spinning, swooshing things forward and swooshing things back.

**中文翻译:**
我讲得也很好。然后我想，我在 LinkedIn 上发了很多内容，那是我的主要渠道。如果我发一段随手拍的视频会怎样？视频里我肤色偏橘，没经过调色，看起来有点像特朗普。但内容非常充实，干货满满。结果那是我目前播放量最高的视频。我意识到人们想要的是内容。作为一家演示公司，我确实比别人更需要把内容讲好，但并不一定需要完美的剪辑、旋转的信息图或各种花哨的特效。

---

### [01:06:50] Nancy Duarte (Continued)

**English:**
That kind of nature of it is not necessary to get the message across. And so we actually have a whole process and program we're rolling out where you're going to see a lot more video from us, partially from that insight, but partially because my team, I have a team of experts, they have a lot of great things to share, and so I'm trying to give them, I'm trying to make it be like Duarte does not equal Nancy Duarte. I'm trying to make it so it's like so many experts work at Duarte, you got to watch any video from any of them is where we're moving at Duarte. They're freaks of brilliance and just experts. They're world class experts. So, that's what we're trying to do.

**中文翻译:**
那些东西对于传达信息并不是必需的。所以我们正在推出一个新计划，你会看到我们更多的视频。部分源于这个洞察，部分是因为我的团队里有很多专家，他们有很多好东西要分享。我试图让大家明白：Duarte 公司不等于 Nancy Duarte。Duarte 有很多专家，看他们任何人的视频都会有收获。他们都是天才，是世界级的专家。这就是我们努力的方向。

---

### [01:07:27] Lenny

**English:**
I feel like you have a similar challenge to me where I named my newsletter, Lenny's Newsletter.

**中文翻译:**
我觉得你面临的挑战和我类似，我把我的时事通讯命名为“Lenny 的时事通讯”。

---

### [01:07:32] Nancy Duarte

**English:**
Yeah, same thing.

**中文翻译:**
是的，一回事。

---

### [01:07:33] Lenny

**English:**
[inaudible 01:07:33] talk about that.

**中文翻译:**
（笑）确实如此。

---

### [01:07:33] Nancy Duarte

**English:**
Same thing.

**中文翻译:**
一模一样。

---

### [01:07:33] Lenny

**English:**
Yeah, can never be anyone else. It's a challenge, but yeah, don't know, it worked out. Okay. Actually, real final question before we get to a very exciting lightning round. Have you seen examples of product managers specifically telling really good stories?

**中文翻译:**
是的，永远没法变成别人。这确实是个挑战，但目前运行得还行。好，在进入激动人心的闪电轮之前，最后一个真正的问题：你见过产品经理讲出非常精彩的故事的例子吗？

---

### [01:07:46] Nancy Duarte

**English:**
The product management process has multiple phase. There's the creative explorative process all the way through to getting it produced. And I think story can take you along in each phase. So, there's example, which I read about, I wasn't actually even part of, but Brian Chesky at Airbnb, there was a whole article where he unpacked this moment in their product development cycle where they decided they would take a walk in the shoes of their customer and they hired a Pixar illustrator to illustrate each scene as the team's like, okay, okay, they said this is her name. And they were like, okay, what happens? Her alarm goes off. Okay, what happens next? What happens next? Okay, now she's decided she needs to book something. What does she do? She wants to do that. They realized from this little walk in the shoes of their customer just this day in the life, which is a classic storytelling method for any product, they realized that they had their strategy wrong, that they needed to move as soon as possible to a mobile first strategy.

**中文翻译:**
产品管理流程有多个阶段，从创意探索到最终产出。我认为故事可以贯穿每个阶段。有一个例子我读到过，虽然我没参与，但 Airbnb 的 Brian Chesky 在一篇文章中分享了他们产品开发周期中的一个时刻：他们决定设身处地为客户着想。他们聘请了一位皮克斯插画师，为每个场景画插图。团队会说：“好，这是她的名字。接下来发生了什么？闹钟响了。然后呢？现在她决定订房，她会怎么做？”通过这种“客户的一天”的经典故事方法，他们意识到之前的策略错了，他们需要尽快转向“移动优先”策略。

---

### [01:08:46] Nancy Duarte (Continued)

**English:**
And it was just because they actually thought about, okay. She goes, brushes their teeth, they do this. They were just literally walking through the life of their ideal customer and that was when they realized they had it all messed up. But the other phases, after all this work people put into product and the making of the product and the managing of pushing it through. We have a large client that makes shoes or athletic things. I love telling stories, but I can't say this. And there's this moment where we get brought in and could you please train our product people in story? We're like, "What's the big problem?" They're like, "They'll spend a year or two on a shoe and be like, chunk, put it on the table. And they're like, what do you have to say about it?" They're like, "It's red." And it's like all these years of investment, all these years, they couldn't unpack any sort of story or any sort of reason or even their passion for why they chose red.

**中文翻译:**
仅仅是因为他们思考了：她起床刷牙，然后做这个。他们是在体验理想客户的生活，那时他们才发现原来的方案一团糟。在产品的其他阶段也是如此。我们有一个做运动鞋的大客户。我喜欢讲故事，但不能透露名字。有一次我们被请去培训他们的产品人员讲故事。我们问：“大问题是什么？”他们说：“他们花一两年研发一双鞋，然后‘砰’地往桌上一放。问他们有什么想说的，他们说：‘它是红色的。’”投入了这么多年的心血，他们却讲不出任何故事，说不出理由，甚至表达不出选择红色的激情。

---

### [01:09:41] Nancy Duarte (Continued)

**English:**
And it was like, here's my shoe, it's red. And so this ability to move things along by adding meaning or why and then wrapping it in a story actually can get a product chosen or rejected or there's just so many examples of different spaces in the product cycle that could benefit from a really well told story from, like I said, how the products innovate in the roadmap all the way through to what gets accepted. And then the big reveal, you think about even all the big Apple launches, it's about a big product reveal. It's about revealing this thing that had been hidden for so long and it's another moment to tell amazing stories. So, that's kind of a little bit of an insight on the product side of how to use story.

**中文翻译:**
他们只会说：“这是我的鞋，红色的。”所以，通过赋予意义或解释“为什么”，并将其包装在故事中，这种推动事情进展的能力决定了产品是被选中还是被拒绝。在产品周期的不同阶段，讲好故事都能带来好处：从路线图中的创新到最终方案的通过。还有最后的发布会，想想苹果的所有发布会，那都是关于产品的揭晓，揭开隐藏已久的神秘面纱，那是讲故事的绝佳时刻。这就是在产品端如何使用故事的一些见解。

---

### [01:10:27] Lenny

**English:**
The Airbnb example is an awesome example. It's all true. When I joined Airbnb is actually right there in the process of doing that.

**中文翻译:**
Airbnb 的例子太棒了。那是真的，我加入 Airbnb 时，他们正处于那个过程中。

---

### [01:10:34] Nancy Duarte

**English:**
I love that.

**中文翻译:**
我喜欢这个。

---

### [01:10:36] Lenny

**English:**
And they ended up drawing these key frames of the journey as you described, and they put it right in the center of the office. Here's the journey of a host and a guest that's like 12 frames of that journey. And that actually became the strategy of the company is let's pick six of these frames and make them awesome. And that's what we're going to do.

**中文翻译:**
他们最后画出了你描述的那些旅程关键帧，并把它们放在办公室正中央。那是房东和房客旅程的 12 个画面。这后来成了公司的策略：让我们选出其中 6 个画面，把它们做到极致。这就是我们要做的。

---

### [01:10:36] Nancy Duarte

**English:**
That's awesome.

**中文翻译:**
太棒了。

---

### [01:10:54] Lenny

**English:**
Make booking experience awesome. Make the arrival experience awesome. So, there's a lot of truth to that.

**中文翻译:**
让预订体验变得棒极了，让到达体验变得棒极了。所以你说的非常对。

---

### [01:11:00] Nancy Duarte

**English:**
And it was visualized, right? The vision was visualized like what you're saying we're headed in the future. And it was super clear. I love that story. So cool you were there.

**中文翻译:**
而且它是视觉化的，对吧？愿景被视觉化了，就像你说的，我们要走向未来。它非常清晰。我喜欢这个故事，你能亲历其中真是太酷了。

---

### [01:11:09] Lenny

**English:**
Yeah, it was very cool. And they actually were very mobile. You could grab one of these drawings and bring it to your desk and how are we going to make this moment better this week?

**中文翻译:**
是的，非常酷。那些画是可移动的，你可以拿一张放在桌上，思考：“这周我们要如何让这个时刻变得更好？”

---

### [01:11:17] Nancy Duarte

**English:**
That's awesome.

**中文翻译:**
太赞了。

---

### [01:11:19] Lenny

**English:**
And it was actually indeed, Pixar storyboard artist that they hired for a year. That was his job. Draw these key frames.

**中文翻译:**
而且确实是他们聘请了一位皮克斯故事板艺术家，聘期一年。他的工作就是画这些关键帧。

---

### [01:11:25] Nancy Duarte

**English:**
Oh, that's amazing.

**中文翻译:**
噢，太神奇了。

---

### [01:11:27] Lenny

**English:**
And it connects so directly with your point about empathy. That was the epitome of empathy. Here's what the guest and hosts are going through, and here's where we can do better.

**中文翻译:**
这直接联系到了你关于同理心的观点。那是同理心的缩影：了解房客和房东正在经历什么，以及我们哪里可以做得更好。

---

### [01:11:37] Nancy Duarte

**English:**
Yeah, it's amazing. Yeah, it does tie together.

**中文翻译:**
是的，太棒了，确实联系在一起了。

---

### [01:11:40] Lenny

**English:**
If folks want to look this up, by the way, we'll link in the show notes. If you just Google Snow White Airbnb, you can watch a video of how they all kind of came about this. Well, with that, we've reached our very exciting lightning round. I've got six questions for you if you're ready.

**中文翻译:**
顺便说一下，如果大家想查阅，我们会在节目介绍里放链接。只要搜索“Snow White Airbnb”，就能看到他们是如何实现这一切的视频。好了，现在进入激动人心的闪电轮。如果你准备好了，我有六个问题。

---

### [01:11:54] Nancy Duarte

**English:**
Yep, I'm ready.

**中文翻译:**
是的，准备好了。

---

### [01:11:56] Lenny

**English:**
What are two or three books that you recommended most to other people?

**中文翻译:**
你向别人推荐最多的两三本书是什么？

---

### [01:12:00] Nancy Duarte

**English:**
I think I always classically recommend the gospels because there's just so much love and groundbreaking thinking there. And then for people who do wind up taking an interest in story, I think one of the best books, if you want to pick that up, is Chris Vogler's, The Writer's Journey, where he took Joseph Campbell's Hero's Journey, made it 12 Steps, and he was a Disney story analyst. So, it's just really classic body of work that had really helped people get their minds around story and the archetypes.

**中文翻译:**
我总是经典地推荐《福音书》，因为那里有太多的爱和开创性的思考。对于那些对故事感兴趣的人，我认为最好的书之一是克里斯·沃格勒（Chris Vogler）的《作家之旅》（The Writer's Journey）。他借鉴了约瑟夫·坎贝尔的“英雄之旅”，将其简化为 12 个步骤。他曾是迪士尼的故事分析师。这是一部非常经典的作品，能帮助人们理解故事和原型。

---

### [01:12:30] Lenny

**English:**
What is a favorite recent movie or TV show?

**中文翻译:**
最近最喜欢的电影或电视剧是什么？

---

### [01:12:33] Nancy Duarte

**English:**
It's my little sinful pleasure. It's way into K drama, Korean drama. Don't even ask me how, but I'm way into that. I've seen almost all of them now. I'm at the bottom of the barrel of them.

**中文翻译:**
这是我的一点小嗜好：我非常迷韩剧。别问我为什么，但我真的很入迷。我现在几乎看遍了所有的韩剧，已经快没得看了。

---

### [01:12:44] Lenny

**English:**
Is there a favorite?

**中文翻译:**
有最喜欢的吗？

---

### [01:12:45] Nancy Duarte

**English:**
No, my husband just watched one. It's called Business Proposal, and he watched it with me and he's like, oh no, now I'm going to be hooked too. They're just real. They're just cute as a button. And they have a longer arc. They're like an epic length tail. They drop in 12 part seasons or one season 12. Anyway, don't even get me started. It sounds dumb, because I like the epic tales and the dramas, but they're cute.

**中文翻译:**
我丈夫刚看了一部叫《社内相亲》（Business Proposal），他陪我一起看的，然后他说：“噢不，我也要入坑了。”它们很真实，非常可爱。它们的叙事弧线很长，像史诗一样。通常一季 12 集。总之，别让我聊这个，听起来有点傻，因为我本来喜欢史诗故事和正剧，但韩剧真的很可爱。

---

### [01:13:08] Lenny

**English:**
What is a favorite interview question that you like to ask people that you're hiring?

**中文翻译:**
在招聘时，你最喜欢问的面试问题是什么？

---

### [01:13:14] Nancy Duarte

**English:**
Oh, favorite interview question. We ask a lot about who they are. So, we use psychometrics a lot here, and we really understand who they are, and we actually ask people to tell a story. And if that's uncomfortable or those psychometrics are uncomfortable, they're not really a fit, because we are a systemic story culture, and we define empathy at the company as know yourself, accept yourself, kind of work on yourself, and then adapt to others. So, if people aren't open to really understanding how they show up then and then adapt and change under our care, then we don't hire them.

**中文翻译:**
哦，最喜欢的面试问题。我们会问很多关于“他们是谁”的问题。我们经常使用心理测量学工具来了解应聘者，并且会让他们讲一个故事。如果他们觉得这不舒服，或者对心理测评感到抵触，那他们就不太合适。因为我们有一种系统性的故事文化。我们公司对同理心的定义是：了解自己、接纳自己、提升自己，然后适应他人。如果人们不愿真正了解自己的表现并做出改变，我们就不聘用。

---

### [01:13:51] Lenny

**English:**
What is a favorite product you've recently discovered that you love?

**中文翻译:**
最近发现并喜爱的产品是什么？

---

### [01:13:55] Nancy Duarte

**English:**
I'm excited about a tool I just paid for last week. It's called writer.com. So, it's built on multiple language models and including, it's going to be trained on our own, all my IP, all my books, every blog post, it'll learn the voice and it'll use my own kind of language model to help us write faster. So, we put really good prompts in and we get a really good product out. So, I'm super excited about that.

**中文翻译:**
我对上周刚付费的一个工具感到很兴奋，叫 writer.com。它基于多种语言模型，并且将使用我们自己的知识产权（IP）、我所有的书和博客文章进行训练。它会学习我的语调，并使用我自己的语言模型来帮助我们更快地写作。我们输入好的提示词，就能得到很好的产出。我对此非常期待。

---

### [01:14:17] Lenny

**English:**
I'm actually an investor in that company, so this is great to hear.

**中文翻译:**
我其实是那家公司的投资者，听到这个太好了。

---

### [01:14:20] Nancy Duarte

**English:**
Oh yeah. That's awesome.

**中文翻译:**
噢，是吗？太棒了。

---

### [01:14:21] Lenny

**English:**
Writer.com. What is something relatively minor you've changed in your approach to developing presentations that has had a big impact on your ability to execute and get them out?

**中文翻译:**
Writer.com。在制作演示文稿的过程中，你做过什么微小但对执行和产出产生巨大影响的改变？

---

### [01:14:33] Nancy Duarte

**English:**
Yeah. I think there's the biggest roadblock for so long that made things painful was the edit cycles. How do we do a round with a client? Then you have multiple version, then you have version control. So, we've come up with this annotation system, so everyone on a project knows exactly the status of that slide, and there's no way really to check slides in and out. And so we've come up with this amazing, beautiful, very visual process where everyone knows the exact status of the slide, and it's really easy. You could put it in thumbnail mode and be like, hmm, we're 80% complete. Everyone's going to focus on just these two things. So, that part of the process, especially enterprise at scale where 20 or 30 people are contributors to a deck. That process we made is the clients are really liking it.

**中文翻译:**
是的。长期以来最大的障碍是修改周期，这让人很痛苦。如何与客户进行一轮沟通？然后会有多个版本和版本控制问题。于是我们发明了一套标注系统，让项目中的每个人都能确切知道每张幻灯片的状态。由于无法真正实现幻灯片的“签入签出”，我们设计了这个美观且视觉化的流程。你可以切换到缩略图模式，一眼看出：“嗯，完成了 80%，大家现在集中处理这两点。”对于有 20 到 30 人参与的大型项目，这个流程非常管用，客户也非常喜欢。

---

### [01:15:14] Lenny

**English:**
To leave people with one final tip to give better presentations. What would that be?

**中文翻译:**
最后给想做好演示的人一个建议，那会是什么？

---

### [01:15:18] Nancy Duarte

**English:**
To become a better presenter, pick a topic you are passionate about, something where you're like, oh my gosh, I've got to see this happen. And pick that topic and be so passionate about it. Work on that talk or stand up at a volunteer thing and really work on something that makes you feel passionate. And then in the future when you're presenting something that you're not passionate about, everything you learned will apply to a business presentation, but you're going to have that feeling. You're going to know what it's like to present from your soul and from a place of passion and the great presenters tap into that passion point and pull from that, and that's what makes them a great presenter on other topics, that they might not be as passionate about.

**中文翻译:**
要成为更好的演讲者，请选择一个你充满热情的课题，一个你迫切希望看到它实现的东西。选择那个课题并投入全部热情。去练习那个演讲，或者在志愿者活动中站出来，真正去做一些让你感到热血沸腾的事情。这样在未来，当你需要演示一些你并不那么感兴趣的内容时，你学到的所有技巧都能应用到商业演示中，而且你会保留那种感觉。你会知道从灵魂深处、带着激情演讲是什么感觉。伟大的演讲者懂得挖掘那个激情点并从中汲取力量，这让他们在面对其他不那么感兴趣的话题时，依然能表现出色。

---

### [01:15:58] Lenny

**English:**
Nancy, I so appreciate you making time for this. It's been an honor.

**中文翻译:**
Nancy，非常感谢你抽时间参加节目。这是我的荣幸。

---

### [01:16:01] Nancy Duarte

**English:**
You're amazing.

**中文翻译:**
你很棒。

---

### [01:16:02] Lenny

**English:**
Everything. You're amazing.

**中文翻译:**
一切都很棒。你也很棒。

---

### [01:16:03] Nancy Duarte

**English:**
You're amazing.

**中文翻译:**
你很棒。

---

### [01:16:05] Lenny

**English:**
You're amazing. Two final questions. Where can folks find you if they'd like to reach out, and how can listeners be useful to you?

**中文翻译:**
你也很棒。最后两个问题：如果大家想联系你，可以在哪里找到你？听众可以为你做些什么？

---

### [01:16:12] Nancy Duarte

**English:**
Oh, they can find me at duarte.com. There's also a duarte.com/nancy where I've got a ton of free stuff where you could find a lot of the things I've talked about. I'm on Twitter @NancyDuarte, and I do connect to everyone who connects to me on LinkedIn, which is kind of fun. So, I think, how could they be useful to me? I think it will cure so many problems if everyone became a really good communicator, so you can help me by working hard on your communication skills, working hard on your clarity, and making everyone around you much happier people.

**中文翻译:**
大家可以在 duarte.com 找到我。还有一个地址 duarte.com/nancy，那里有很多免费资源，包括我今天提到的大部分内容。我的 Twitter 是 @NancyDuarte，我也会在 LinkedIn 上通过每个人的好友申请，这挺有意思的。至于大家能为我做什么：我认为如果每个人都能成为优秀的沟通者，很多问题都会迎刃而解。所以，你可以通过努力提升沟通技巧、提高表达的清晰度来帮助我，这也会让你周围的人更快乐。

---

### [01:16:47] Lenny

**English:**
What a beautiful way to end it. Nancy, again, thank you so much for being here.

**中文翻译:**
多么完美的结尾。Nancy，再次感谢你的到来。

---

### [01:16:50] Nancy Duarte

**English:**
Oh, you're amazing. Thanks for having me.

**中文翻译:**
噢，你很棒。谢谢你邀请我。

---

### [01:16:52] Lenny

**English:**
We're amazing. Let's end it.

**中文翻译:**
我们都很棒。就聊到这里吧。

---

### [01:16:52] Nancy Duarte

**English:**
We are. Let's just say it.

**中文翻译:**
是的，就这么说。

---

### [01:16:56] Lenny

**English:**
All right. Bye everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
好的。大家再见。非常感谢收听。如果你觉得本集有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅。另外，请考虑给我们评分或留下评论，这能帮助更多听众发现本播客。你可以在 lennyspodcast.com 找到往期所有节目或了解更多信息。下期节目见。