# Naomi Gleit - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Naomi Gleit, Head of Product at Meta.

---

### [00:00:00] Naomi Gleit

**English:**
I really believe in frameworks for things that helps drive extreme clarity. I work on a lot of different projects. A lot of times I'm ramping up a new project, I'm like, "Where can I learn what I need to learn about this project?" I ask five different people, get five different answers. That is unacceptable. Of course, I'm sure there's hundreds of docs associated with the project, but there needs to be one canonical doc. Everyone should know exactly where the canonical doc is. That's the one place I can go to get all the information I need about a project and it will link to all the other docs, things on the canonical doc are.

**中文翻译:**
我非常相信框架的作用，它能帮助实现极致的清晰度。我负责很多不同的项目。很多时候当我启动一个新项目时，我会问：“我从哪里可以学到我需要了解的关于这个项目的信息？”如果我问五个不同的人，得到五个不同的答案，那是不可接受的。当然，我确信与项目相关的文档有成百上千份，但必须有一份“权威文档”（Canonical Doc）。每个人都应该确切地知道这份权威文档在哪里。那是我可以获取项目所需所有信息的唯一地方，它会链接到所有其他相关文档，权威文档上就该放这些东西。

---

### [00:00:33] Lenny Rachitsky

**English:**
Today my guest is Naomi Gleit. Naomi is head of product at Meta. Other than Mark Zuckerberg, she's the longest-serving executive at Meta. She joined what was then called Facebook as employee number 29 and has been at Meta for almost 20 years. She's seen the company scale from 30 employees to the one and a half trillion dollar business that it is today. Naomi does very few podcasts and interviews and so I was really excited to chat with her and have her on this podcast. In our conversation, we dig into the many lessons that she learned from Facebook's early and legendary growth team, her superpower of taking really complex and gnarly problems and projects, simplifying them and delivering results. We also get into leadership lessons she's learned from Zuck, including his recent transformation into possibly the coolest CEO in tech. Also, why PMs are the conductor of product teams, some very tactical tips for running meetings, writing docs, working out, getting better sleep, and even how to get more protein in your diet. This was such a fun conversation and such a wide-ranging conversation and whether you are in product or growth or any other tech function, you will get something useful out of this conversation. If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. It's the best way to avoid missing future episodes and helps the podcast tremendously. With that, I bring you Naomi Gleit. Naomi, thank you so much for being here. Welcome to the podcast.

**中文翻译:**
今天的嘉宾是 Naomi Gleit。Naomi 是 Meta 的产品负责人。除了马克·扎克伯格，她是 Meta 任职时间最长的高管。她作为第 29 号员工加入了当时的 Facebook，在 Meta 工作了近 20 年。她见证了公司从 30 名员工成长为今天价值 1.5 万亿美元的巨头。Naomi 很少参加播客或接受采访，所以我非常兴奋能与她交谈并邀请她来到节目中。在我们的对话中，我们深入探讨了她从 Facebook 早期传奇增长团队中学到的许多经验，以及她将极其复杂和棘手的问题与项目简化并交付成果的“超能力”。我们还聊到了她从扎克伯格身上学到的领导力课程，包括他最近转型为科技界最酷 CEO 的过程。此外，我们还讨论了为什么产品经理（PM）是产品团队的“指挥家”，以及一些关于开会、写文档、健身、改善睡眠、甚至如何在饮食中摄入更多蛋白质的实用技巧。这是一次非常有趣且涵盖广泛的对话，无论你是在产品、增长还是任何其他技术职能部门，你都能从中获益。如果你喜欢这个播客，别忘了在常用的播客应用或 YouTube 上订阅和关注。这是避免错过未来节目的最佳方式，也对我们帮助巨大。下面，让我们欢迎 Naomi Gleit。Naomi，非常感谢你能来，欢迎来到播客。

---

### [00:01:56] Naomi Gleit

**English:**
Thanks so much for having me. As I told you earlier, I refer your podcast all the time and so I can't believe I have the opportunity to actually talk on it.

**中文翻译:**
非常感谢邀请我。正如我之前告诉你的，我经常向别人推荐你的播客，所以我简直不敢相信自己真的有机会来这里做客。

---

### [00:02:08] Lenny Rachitsky

**English:**
Wow, I'm so flattered. I never get tired of hearing that. Appreciate you sharing that. I want to share a couple of tidbits about you because it's pretty crazy when you see this list. Okay, so you are Meta's longest serving executive other than Mark Zuckerberg. You're employee number 29 at Facebook. You've been there for over 19 years. Sorry, at Meta, formerly Facebook.

**中文翻译:**
哇，我受宠若惊。我永远听不腻这样的话，感谢你的分享。我想分享一些关于你的趣闻，因为看到这个清单真的很疯狂。好的，你是 Meta 除马克·扎克伯格之外任职时间最长的高管。你是 Facebook 的第 29 号员工。你在那里工作了超过 19 年。抱歉，是在 Meta，也就是以前的 Facebook。

---

### [00:02:35] Naomi Gleit

**English:**
I do that all the time. That's what happens when you've been at Meta for 19 years is you can't get the name right.

**中文翻译:**
我也经常改不过口。在 Meta 待了 19 年的结果就是，你总是记不住新名字。

---

### [00:02:42] Lenny Rachitsky

**English:**
Okay, good. I won't feel bad about that Then and then the last thing is just you've been at the center of some of the most foundational products that Meta and Facebook have worked on, including working on the early growth team and thinking about the early growth strategy. Basically you've been there from employee number 30 to today, a one and a half trillion dollars company, one of the largest companies in the world today. Very few people have ever seen this sort of growth and scale from the inside. First of all, I guess let me just ask this, do you ever reflect on this and just realize like, "Holy shit, what a journey I've been on. How wild."?

**中文翻译:**
好吧，那我就不觉得尴尬了。最后一点是，你一直处于 Meta 和 Facebook 一些最基础产品的核心位置，包括在早期增长团队工作并思考早期增长策略。基本上，你见证了公司从 30 人发展到今天的 1.5 万亿美元规模，成为当今世界最大的公司之一。极少有人能从内部见证这种增长和规模。首先，我想问，你是否曾回首往事并感叹：“天哪，我经历了一段多么疯狂的旅程”？

---

### [00:03:16] Naomi Gleit

**English:**
It is a great question. I would love to say that I reflect on it. The truth is I think I barely have time to reflect right now. I'm thinking about all the things that I need to do on my to-do list, so I'm pretty in it still. Even after 19 years, I am really focused on the work that I need to do. I do honestly have moments where I get to reflect. For example, on this podcast. Sometimes people do ask me and I think especially as I approach the twenty-year milestone, my twenty-year Faceversary, I'm sure that will give ample opportunity for me to look back.

**中文翻译:**
这是一个好问题。我很想说我有在反思。但事实是，我现在几乎没有时间去感慨。我满脑子都是待办事项清单上的事情，所以我仍然全身心投入其中。即使过了 19 年，我依然非常专注于我需要做的工作。老实说，我确实会有一些反思的时刻，比如现在参加这个播客。有时人们会问我，我想特别是当我接近 20 年这个里程碑，也就是我的 20 周年“Faceversary”（入职纪念日）时，我相信那会有充足的机会让我回顾过去。

---

### [00:03:55] Lenny Rachitsky

**English:**
Such a classic product manager answer. I have too much to do-

**中文翻译:**
典型的产品经理式回答。我有太多事要做了——

---

### [00:03:55] Naomi Gleit

**English:**
Too busy.

**中文翻译:**
太忙了。

---

### [00:03:59] Lenny Rachitsky

**English:**
I have to think about this. Yeah, I got to hit some goals here.

**中文翻译:**
我得考虑一下。是的，我得先达成一些目标。

---

### [00:04:04] Lenny Rachitsky (Ad Segment - Pendo)

**English:**
This episode is brought to you by Pendo, the only all-in-one product experience platform for any type of application... [Ad content omitted for brevity in translation, but can be provided if needed]

**中文翻译:**
本期节目由 Pendo 赞助，它是适用于任何类型应用程序的唯一全方位产品体验平台……（广告内容略）

---

### [00:05:28] Lenny Rachitsky (Ad Segment - Vanta)

**English:**
This episode is brought to you by Vanta. When it comes to ensuring your company has top-notch security practices, things get complicated fast... [Ad content omitted]

**中文翻译:**
本期节目由 Vanta 赞助。当涉及到确保公司拥有顶级的安全实践时，事情会迅速变得复杂……（广告内容略）

---

### [00:06:20] Lenny Rachitsky

**English:**
Let me start. I want to start by just how you actually landed at Meta as employee number 29, which is a life-changing decision and a life-changing role and I want to learn if there's something folks can see about what you did that might be helpful to them when they're trying to find a place to work and your story, I was reading about the story and it's super interesting. You basically wrote your senior thesis at Stanford about why Facebook was going to win and why it was going to beat its competitors and the competitors cited I've never even heard of, so it's interesting that that was the competitor at the time. Could you just share the story of how you landed as employee number 29 at Facebook, now Meta?

**中文翻译:**
让我们开始吧。我想从你如何成为 Meta 第 29 号员工开始聊起，这是一个改变人生的决定和角色。我想看看你的经历中是否有值得大家借鉴的地方，尤其是当他们在寻找工作机会时。我读过你的故事，非常有趣。你当时在斯坦福大学的毕业论文基本上就是关于为什么 Facebook 会赢，以及为什么它会击败竞争对手——而你提到的那些竞争对手我甚至都没听说过，所以那时的竞争格局很有意思。你能分享一下你是如何成为 Facebook（现 Meta）第 29 号员工的故事吗？

---

### [00:06:54] Naomi Gleit

**English:**
Facebook as part of being an academic, researching Facebook, also being a Stanford student using Facebook. I was like, "I really want to work here." Facebook had just moved to Palo Alto. Mark had driven across country I guess, and arrived in Palo. Alto opened up an office at 443 Emerson Avenue or Emerson Street. It was right above the Jing Jing's Chinese restaurant in downtown Palo Alto and I just went to the office sort of cold called the equivalent of just walking into the office and seeing if there were any available jobs. There were not. I think I did that maybe five to 10 more times. Eventually, there was an opening to interview for Sean Parker's personal assistant. He was at the time I think the president. I did interview and I did not get the job. A few months later I found out about a marketing role that was available. And one interesting thing I haven't really talked about was I got an offer from Facebook. I also got a competing offer from LinkedIn, and so at that time I made the choice to go to Facebook because I was interested in the social networking aspect of it. Why was I so bullish on this website at the time it was www.thefacebook.com. Why was I so excited about this thing? I think it's because I definitely saw that there was product market fit. I saw that students at Stanford were obsessed with it, but it also had a long list of colleges that were really excited and on the waiting list to be accepted onto Facebook, and so there was this product market fit piece and also a huge demand from other audiences, other colleges, but our younger brothers and sisters were also sort of interested about Facebook and it seemed like it had this much broader appeal. So that's what happened. I got the marketing job. Cheryl also talks about when you are on getting a rocket ship, don't ask what seat. That was my foot in the door and here we are 19 years later.

**中文翻译:**
作为一名研究 Facebook 的学生，同时也是一名使用 Facebook 的斯坦福学生，我当时想：“我真的很想在这里工作。” Facebook 当时刚搬到帕罗奥图（Palo Alto）。我想马克当时是开车横跨美国到达那里的。他们在帕罗奥图市中心爱默生街 443 号开了一个办公室，就在“京京”中餐馆的正上方。我就直接去了办公室，相当于“冷敲门”，直接走进去问有没有空缺职位。结果没有。我想我大概又去了 5 到 10 次。最终，有一个面试肖恩·帕克（Sean Parker）私人助理的机会，他当时应该是总裁。我参加了面试，但没拿到那份工作。几个月后，我听说有一个营销职位空缺。有一件我没怎么提过的趣事是，我当时拿到了 Facebook 的录用通知，同时也拿到了 LinkedIn 的竞争性录用通知。那时我选择了 Facebook，因为我对社交网络方面很感兴趣。为什么我当时那么看好这个网站（当时还是 www.thefacebook.com）？为什么我对它如此兴奋？我想是因为我确信它已经达到了“产品市场契合点”（Product Market Fit）。我看到斯坦福的学生对它着迷，而且还有一长串大学正兴奋地排队等待加入 Facebook。所以既有 PMF，又有来自其他群体、其他大学的巨大需求，甚至我们的弟弟妹妹也对 Facebook 感兴趣，它似乎具有更广泛的吸引力。这就是当时的情况。我得到了那份营销工作。谢丽尔（桑德伯格）也说过，如果你能登上火箭，不要问是什么座位。那就是我进入公司的敲门砖，一晃 19 年过去了。

---

### [00:09:18] Lenny Rachitsky

**English:**
I was just going to say that that's such a good example of what she recommends of if you can get a seat on a rocket ship, don't ask which seat. And I love the Sean Parker piece. I did not know that. That's hilarious. What a different life would've been if you got that job and went down that track. So a couple of takeaways here for people that are trying to pick where to work, what I love about your story is one is you just had so much. You just had confidence that this business would work and you just knew that you wanted to get on this rocket ship. You saw attraction. So that told you I guess that added to this confidence that this was going to work out. And then you said that you walked into the office kind of cold, not even cold emailing or calling, but cold arriving. Five to 10 times you said?

**中文翻译:**
我正想说，这正是她建议的绝佳例子：如果你能登上火箭，别问座位在哪。我也很喜欢关于肖恩·帕克的那段，我以前不知道。太搞笑了，如果你当时拿到了那份工作并走上那条路，人生会多么不同。对于那些正在选择工作地点的人来说，这里有几个启发：首先是你非常有信心，你确信这项业务会成功，你明确知道自己想登上这艘火箭。你看到了吸引力（traction），我想这增强了你对成功的信心。然后你说你直接走进了办公室，甚至不是发邮件或打电话，而是直接上门。你说了有 5 到 10 次？

---

### [00:09:45] Naomi Gleit

**English:**
Yeah, it was pure just refusing to quit. I think I just walked into the office, I talked to the person at the front desk, "Is there anything that I can do?" They weren't hiring non-technical people. I didn't have a computer science degree. I wasn't technical. I had this bachelor of arts degree and that's why the personal assistant in the marketing role eventually did open and was something that I thought I could be qualified for.

**中文翻译:**
是的，纯粹就是拒绝放弃。我直接走进办公室，问前台的人：“有什么我能做的吗？”他们当时不招非技术人员。我没有计算机学位，我不懂技术，我拿的是文学学士学位。这就是为什么当私人助理和营销职位最终开放时，我觉得自己能够胜任。

---

### [00:10:12] Lenny Rachitsky

**English:**
Cool. I think that's such an empowering lesson of if you look at someone like you and they're like, "Oh, she was so early at Facebook, how lucky," clearly wasn't luck. You knew you wanted to work at this company. You put a lot of effort into making it happen no matter the job. I think that's a really good takeaway and lesson. So if there's a company today that you are excited about that you're just like, "This is going to be a massive success," what I'm hearing is just do everything you can to try to land a job there and eventually you'll be in a role you actually want. It doesn't have to start there.

**中文翻译:**
太酷了。我觉得这是一个非常有力量的启示。如果有人看着你感叹：“哦，她那么早就进了 Facebook，真幸运”，显然那不是运气。你明确知道自己想在这家公司工作，无论什么职位，你都付出了巨大的努力去实现它。这是一个非常好的经验。所以，如果今天有一家公司让你感到兴奋，让你觉得“这一定会大获成功”，我听到的建议就是：竭尽全力进入那家公司，最终你会得到你真正想要的角色，不一定非要从那个角色开始。

---

### [00:10:41] Naomi Gleit

**English:**
When I got to Facebook, I knew I wanted to build. As someone who wasn't really technical, I wasn't going to be an engineer or a coder. I wanted to work with the engineers and the coders to build products. I thought product management was the right function for me, and so my dream was always to be a PM and it wasn't luck as to how I ended up becoming a PM. I sort of took the same approach showing up at the office asking if there were any roles. By then, we had moved to 156 University and all of the PMs and engineers worked on the second floor, and I was working in marketing, like I mentioned, and I worked on the third floor and all the business functions worked on the third floor, and my goal was to be a PM. I ended up going, sort of the analogy, I went to the second floor most days after work, asked if there were any projects that I could help out with. It was very early days. There was always more to do than people to do it. And so eventually I picked up a few projects, helping with program management, giving my product feedback, and by the time that I actually applied formally to be a product manager, I had been doing the job voluntarily, almost informally for a few months. And I remember this because I had a seat on the third floor. I picked up all the stuff on my desk, put it in a box, walked down to the second floor once I got the job to become a PM. And when I got to the second floor, I distinctly remember everyone on the second floor standing and clapping. And so it was a big standing ovation. I'll never forget, Boz was there, by the way. I know Boz has been on your podcast, but even Boz was there sort of standing and clapping. And so I guess to the lesson that you were trying to extract from my story, I do think I sort of tried to create the luck by not giving up and just repeatedly cold calling or cold showing up or cold volunteering until I sort of was able to make it happen.

**中文翻译:**
当我加入 Facebook 时，我知道我想参与创造。作为一个不太懂技术的人，我不会成为工程师或程序员。我想与工程师和程序员合作开发产品。我觉得产品管理（PM）是最适合我的职能，所以我的梦想一直是成为一名 PM。我最终成为 PM 也不是靠运气。我采取了同样的方法：出现在办公室询问是否有职位。那时我们已经搬到了大学路 156 号，所有的 PM 和工程师都在二楼工作，而我在三楼的营销部门工作，所有的业务职能都在三楼。我的目标是成为 PM。于是我每天下班后都会去二楼，问有没有我可以帮忙的项目。那是很早期的阶段，总是有做不完的事，但人手不够。所以最终我接手了几个项目，帮忙做项目管理，提供产品反馈。到我正式申请成为产品经理时，我已经自愿、非正式地做了几个月的工作了。我记得很清楚，因为我在三楼有个座位。当我拿到 PM 职位后，我把桌上的东西都装进箱子，走下二楼。当我到达二楼时，我清晰地记得二楼的每个人都站起来鼓掌。那是一次盛大的起立鼓掌。顺便说一下，我永远不会忘记 Boz（Andrew Bosworth）也在那里。我知道 Boz 上过你的播客，当时连他也在那里站着鼓掌。所以，关于你想从我的故事中总结的经验，我认为我是通过不放弃、反复地“冷拜访”或主动请缨来“创造”运气的，直到我最终促成了这件事。

---

### [00:12:51] Lenny Rachitsky

**English:**
Amazing. Again, very empowering. It's not just like, "Oh, there's these people that just get lucky they land this PM job." It's like you landed at the company. I want to be a product manager, which is interesting. Most people don't grow up in I want to be a product manager. That's like a rare thing people even want, especially that early on. So it's interesting that you already knew that, but you basically did the job. You did the job of PM before you had the job, and by the time you actually asked for it, you've been doing it for a long time and you could show, "Hey, look, I'm actually good at this. I can do this job." Amazing. By the way, I love the Boz connection. I'm finding that Boz is connected to the most guests of this podcast in so many different ways.

**中文翻译:**
太棒了。再次强调，这非常有启发性。这不仅仅是“哦，有些人就是运气好拿到了 PM 职位”。而是你先进入了公司，然后明确目标。我想成为产品经理，这很有意思，因为大多数人成长过程中并不会想“我要当产品经理”。这在当时是很罕见的愿望。所以你当时就明确了这一点很有趣，但你基本上是先做了这份工作。在正式获得职位之前，你已经在履行 PM 的职责了，当你最终提出申请时，你已经做了很久，可以证明：“嘿，看，我真的很擅长这个，我能胜任。” 太棒了。顺便说一下，我很喜欢你提到的 Boz。我发现 Boz 以各种方式与这个播客的大多数嘉宾都有联系。

---

### [00:13:29] Naomi Gleit

**English:**
Really?

**中文翻译:**
真的吗？

---

### [00:13:29] Lenny Rachitsky

**English:**
Curious. Yeah, like Ami and-

**中文翻译:**
很有趣。是的，比如 Ami 还有……

---

### [00:13:32] Naomi Gleit

**English:**
Oh yeah.

**中文翻译:**
噢，是的。

---

### [00:13:33] Lenny Rachitsky

**English:**
And a few other people. It's just interesting. There's a Boz spiderweb of connections throughout this podcast so far. Okay, so I'm going to fast-forward to today. So your role today is head of product at Meta?

**中文翻译:**
还有其他几个人。这很有趣，到目前为止，这个播客中似乎有一张以 Boz 为中心的联系网。好了，让我们快进到今天。你现在的角色是 Meta 的产品负责人？

---

### [00:13:46] Naomi Gleit

**English:**
Yes.

**中文翻译:**
是的。

---

### [00:13:46] Lenny Rachitsky

**English:**
What does that mean? What do you do at Meta today? How would you describe your role?

**中文翻译:**
那意味着什么？你现在在 Meta 具体做些什么？你会如何描述你的角色？

---

### [00:13:52] Naomi Gleit

**English:**
There are a few thousand PMs at Meta. They do not all report to me. I would say a few hundred of them report to me on the teams that I directly manage, but I feel responsible for the entire PM community at Meta. There are things that we do centrally, things like PM performance, PM culture PM onboarding and training, and that's the kind of thing that I look out for. Obviously I wanted to be a PM. Head of product is my dream job. I am deeply supportive of the PM function, and so I really care and I think PMs are a huge point of leverage in a company for how we can actually get stuff done and help accomplish the company's goals. And so I sort of focus on PM as a really important exponential lever for doing that.

**中文翻译:**
Meta 有几千名 PM。他们并不都向我汇报。我会说，在我直接管理的团队中，有几百人向我汇报，但我对 Meta 的整个 PM 群体负有责任。我们有一些集中的工作，比如 PM 绩效评估、PM 文化、PM 入职培训等，这些都是我关注的事情。显然，我一直想当 PM，产品负责人是我的梦想工作。我深切支持 PM 职能，我非常在意并认为 PM 是公司中一个巨大的杠杆点，决定了我们如何实际完成任务并帮助实现公司目标。所以我把 PM 视为实现这些目标的一个非常重要的指数级杠杆。

---

### [00:14:45] Lenny Rachitsky

**English:**
I love that. Okay. I'm going to come back to what you've learned about what makes super successful PMs, what makes you really successful. I want to take a tangent to Zuck.

**中文翻译:**
我喜欢这个说法。好的，稍后我会回到关于“什么造就了超级成功的 PM”以及“是什么让你如此成功”的话题。现在我想先聊聊扎克伯格。

---

### [00:14:54] Naomi Gleit

**English:**
Please. Yes.

**中文翻译:**
请讲，没问题。

---

### [00:14:56] Lenny Rachitsky

**English:**
So you've known Zuck for over 20 years at this point, and I just have to ask a few Zuck questions because people are always curious to learn from what has worked so well for him. The first question is just there's been a pretty profound transformation in Mark over the past few years, both in terms of how he leads and also just in his coolness and vibe factor. What are your thoughts on just this transformation and how he's been able to pull it off?

**中文翻译:**
你认识扎克伯格已经超过 20 年了，我必须问几个关于他的问题，因为人们总是好奇他成功的秘诀。第一个问题是，过去几年马克发生了非常深刻的转变，无论是他的领导方式，还是他的“酷”劲和整体氛围。你对这种转变以及他是如何做到的有什么看法？

---

### [00:15:22] Naomi Gleit

**English:**
So I've always said that there is the biggest gap of anybody I know between what people think of Mark and who Mark really is. And so I think this is the Mark that I've known for the past 20 years and the world is finally getting to see what I've been lucky enough to see. And that gap that we've talked about is really starting to close. How did we get here? I always say Mark is a learn it all, not a know-it-all. He is the fastest person at upskilling of anyone I've ever met. He used to do these annual challenges. One year I did them with him, it was learning Chinese, and within a year he was able to basically achieve an eighth grade fluency in Chinese. And that's just one example. Obviously, he's gotten incredibly great at guitar, MMA, a lot of his passions, but he's also gotten a lot better at some of the professional skills. And I think negotiation, public speaking is one of those. I think before in the early days, it just wasn't something that he was very comfortable with. He's talked himself about coming across as a little scripted. I think he was not confident and pretty careful about how he showed up and he's upskilled here. He's just gotten a lot more comfortable, and so people are able to see who he really is.

**中文翻译:**
我一直说，在我认识的所有人中，马克是那种“人们眼中的他”与“真实的他”之间差距最大的人。我认为这就是我过去 20 年所认识的那个马克，而世界终于开始看到我有幸见到的那一面了。我们谈论的那个差距正在真正缩小。我们是怎么走到这一步的？我常说马克是一个“终身学习者”（learn-it-all），而不是“无所不知者”（know-it-all）。他是我见过的提升技能最快的人。他以前常做年度挑战。有一年我和他一起做，那是学习中文，在一年之内，他基本上达到了中文八年级的流利程度。这只是一个例子。显然，他在吉他、综合格斗（MMA）等许多爱好上都变得非常出色，但他在一些专业技能上也进步神速。我认为谈判和公开演讲就是其中之一。在早期，这些并不是他感到很自在的事情。他自己也说过，以前表现得有点像在背台词。我想他当时不够自信，对自己的形象非常谨慎，而现在他在这方面提升了技能。他变得更加从容，所以人们能够看到真实的他。

---

### [00:16:44] Lenny Rachitsky

**English:**
He was also like, I don't know, 20 something when he started Facebook and now he's running a 80,000 person org. I could see the emotion habits.

**中文翻译:**
他创办 Facebook 时大概才 20 岁出头，现在他管理着一个 8 万人的组织。我能理解这种成长。

---

### [00:16:52] Naomi Gleit

**English:**
Yes. I think he might've been 19 or 20 when I came.

**中文翻译:**
是的。我想我加入时他可能才 19 或 20 岁。

---

### [00:16:56] Lenny Rachitsky

**English:**
Oh God, that's insane. So yeah, I could see why someone would change. I was at the Acquired podcast Chase event with him being interviewed, and he's just such a cool dude now. He just has these big shirts with his own letters on it, his own phrases, his chain. What a cool dude.

**中文翻译:**
天哪，那太疯狂了。所以我能理解一个人为什么会改变。我参加了 Acquired 播客在 Chase Center 的活动，当时他接受了采访，他现在真的是个很酷的人。他穿着印有自己设计的字母和短语的大 T 恤，戴着项链。真是个酷家伙。

---

### [00:17:16] Naomi Gleit

**English:**
His long hair.

**中文翻译:**
还有他的长发。

---

### [00:17:17] Lenny Rachitsky

**English:**
His long hair.

**中文翻译:**
对，他的长发。

---

### [00:17:18] Naomi Gleit

**English:**
His watch. Yeah, I was at that event too. I thought it was great. I think, yeah, that's the no gap between who Mark is and what the world sees.

**中文翻译:**
还有他的手表。是的，我也在那场活动。我觉得很棒。我想，是的，那就是马克真实的一面与世界所见的一面之间不再有差距。

---

### [00:17:30] Lenny Rachitsky

**English:**
I love that. Is there something about Zuck that you know that most people don't know? Something that would surprise us?

**中文翻译:**
我喜欢这个说法。关于扎克伯格，有没有什么是你知道但大多数人不知道的？或者会让我们感到惊讶的事情？

---

### [00:17:37] Naomi Gleit

**English:**
The one thing I would say about Mark is I think people know he's married. He has three daughters. He's a really great dad, he's a really great husband. I would say he's also a really good friend. Maybe that's something that I can sort of speak to from experience. He's just an incredibly thoughtful friend. There was a period in my life, I think it was 10 years ago when I was going through just sort of a really hard time. I had come out of a breakup, but Mark saw that I was having a hard time. He asked me if I wanted to volunteer to teach a class in East Palo Alto after their school day. And in retrospect, it's pretty funny, but Mark and I taught a class about how to build a business. So you had the CEO of Meta teaching this class to a bunch of middle school students, and we got really close to them through that process. We made some really important mentorship connections. For years, we met with them. I think we still continue to, even though they've now at this point graduated from college and have real jobs. But one of the lessons that we taught during that class that I remember Mark distinctly writing on the whiteboard, or not the whiteboard, there actually was chalk, it was with chalk on a chalkboard with the four life lessons. That was one, and I kept these for myself as well, love yourself. Two, only then can you truly serve others. Three, focus on what you can control. And four, for those things never give up. And that was sort of his life lessons, four steps to how to approach life. And we actually made stickers for these four steps that the students could actually put on their composition notebooks as a reminder. And I think obviously that has really helped me over time, but I think that in that you can see some of what I think we all see in Mark, for example, for those things never give up. He has that aspect of him and it makes sense. For me number three is really the hardest, which is focus on what you can control. I think I probably think I can control more things than I actually can.

**中文翻译:**
关于马克，我想说的一点是，人们知道他结婚了，有三个女儿。他是个伟大的父亲，也是个伟大的丈夫。我想说他还是个非常好的朋友。也许这是我可以根据经验谈论的一点。他是一个极其体贴的朋友。我生命中有一段时期，大概是 10 年前，我正经历一段非常艰难的时光。我刚分手，马克看出我状态不好。他问我是否愿意去东帕罗奥图（East Palo Alto）做志愿者，在放学后教一门课。回想起来挺有意思的，马克和我教的是一门关于“如何创业”的课。想象一下，Meta 的 CEO 在给一群中学生上课。通过那个过程，我们和那些孩子变得非常亲近。我们建立了一些非常重要的导师关系。多年来我们一直和他们见面，我想现在还在继续，尽管他们现在已经大学毕业并有了正式工作。在那节课上，我记得马克在黑板上（真的是用粉笔在黑板上）写下了四条人生教训。我也为自己保留了这些教训：第一，爱你自己。第二，只有这样你才能真正服务他人。第三，专注于你能控制的事情。第四，对于这些事情，永不放弃。这就是他的人生教训，也是对待生活的四个步骤。我们甚至为这四个步骤制作了贴纸，让学生们贴在笔记本上作为提醒。显然，这些年来这对我帮助很大，但我认为从中你可以看到我们大家在马克身上看到的一些特质，比如“永不放弃”。他确实有那一面，这很合理。对我来说，第三条是最难的，即“专注于你能控制的事情”。我可能总觉得自己能控制的事情比实际要多。

---

### [00:19:53] Lenny Rachitsky

**English:**
So do we all. I love that he was sharing that in a class on how to start a business, this life advice.

**中文翻译:**
我们都一样。我喜欢他在创业课上分享这些人生建议。

---

### [00:20:00] Naomi Gleit

**English:**
Totally.

**中文翻译:**
完全正确。

---

### [00:20:02] Lenny Rachitsky

**English:**
Oh man, that's amazing. I want to chat a bit about, so at this point is 86,000 employees, something like that. That's what I found online. So he has to run this massive org as this CEO, one person. I know that one way that he does this, he has something called a small group. Is that the term?

**中文翻译:**
噢，太棒了。我想聊聊，现在公司大概有 8.6 万名员工，这是我在网上查到的。作为 CEO，他必须一个人管理这个庞大的组织。我知道他有一种管理方式，叫做“小团体”（Small Group）。是这个词吗？

---

### [00:20:24] Naomi Gleit

**English:**
Yes, small group.

**中文翻译:**
是的，Small Group。

---

### [00:20:25] Lenny Rachitsky

**English:**
Okay, cool. So he's got the small group that he calls it and it's essentially is like core execs and this group meets regularly, and that's kind of how he's able to manage the entire org through this small group. For people that are struggling to run an increasingly larger org, are there any tidbits from how Mark and the small group operate that might be helpful to folks?

**中文翻译:**
好的。他有这个所谓的“小团体”，基本上由核心高管组成，这个小组定期开会，这就是他通过这个小组管理整个组织的方式。对于那些在管理日益庞大的组织中挣扎的人来说，马克和这个“小团体”的运作方式有什么值得借鉴的吗？

---

### [00:20:47] Naomi Gleit

**English:**
Sure. So I think the first thing is small group is sort of the leadership team. It's the leaders working on the most important projects at the company, sort of independent of reporting structure and stuff. It's like who are the leaders on the big most important projects or functions? They will be represented in small group. What makes this group unique? A lot of them are people like me, people that have been there for a very long time. So I think the tenure of small group is really rare. Why I think that's important is you have a lot of people that are motivated by mission rather than climbing the corporate ladder at this point. And so there are a lot of what I call disagreeable givers. So just to back up, I don't know if you've heard this framework, but I think I learned this from Adam Grant during an executive learning and development session, and he was saying that if you think of a two-by-two, there's people who are agreeable and disagreeable, and then there's people who are givers and takers. And the most dangerous kind of person to have in an organization is an agreeable taker. And what that means is an agreeable person, super nice, everyone likes them, really easy to get along with, but they're a taker and maybe their motivation is more self-interested rather than what's best for the company, which is how I would define a giver. And the most precious person in an organization is the disagreeable giver. Those are the people who are really motivated to do what's best for the company, but they can be a little bit disagreeable in the sense that they may not say what you want to hear. They may push back on things, they may fight for things. And so I think small group is characterized by a lot of disagreeable givers and I think that's really important for an organization. One thing I think Mark has done really well in general is just have a culture, including on his leadership team, of people who give him feedback. I think a lot of times as you get more successful or as you have more fame or if you have more wealth, you lose having an accurate feedback loop. And people may not want to be a hundred percent honest with you for various reasons. And Mark has tried to ensure that he himself has an accurate feedback loop, or we as a company have more of an accurate feedback loop by surrounding himself and our leadership team and creating a culture of giving direct and honest feedback. So that's some of the unique properties of small group. From a process perspective, we have one weekly sort of strategic meeting. It's more open-ended, there is time for discussion. It's longer and it's sort of more unstructured. We also have one weekly operational meeting, which is highly structured where we go through all of the priority projects. The person who owns each of the projects will actually speak to the weekly updates for that project. And it's very operational and tactical.

**中文翻译:**
当然。首先，“小团体”基本上就是领导团队。它是负责公司最重要项目的领导者，某种程度上独立于汇报结构。也就是那些负责重大项目或职能的领导者，他们会出现在“小团体”中。是什么让这个小组如此独特？很多人像我一样，在公司待了很久。所以我觉得这个小组的平均资历非常罕见。为什么这很重要？因为到这个阶段，很多人是被使命感驱动的，而不是为了爬公司阶梯。所以这里有很多我称之为“敢于表达异议的付出者”（Disagreeable Givers）。解释一下，我不知道你是否听过这个框架，我是从亚当·格兰特（Adam Grant）的一次高管培训中学到的。如果你想一个 2x2 矩阵，横轴是随和（Agreeable）与不随和（Disagreeable），纵轴是付出者（Giver）与索取者（Taker）。组织中最危险的人是“随和的索取者”。这意味着他们人超级好，大家都喜欢，很容易相处，但他们是索取者，动机更多是出于自私，而不是为了公司利益。而组织中最宝贵的人是“不随和的付出者”。这些人非常有动力去做对公司最有利的事，但他们可能有点“不随和”，因为他们不会只说你想听的话。他们会推翻某些决定，会据理力争。我认为“小团体”的特点就是有很多这种“不随和的付出者”，这对组织非常重要。马克做得很好的一点是，他在领导团队中建立了一种反馈文化。通常当你变得更成功、更有声望或更有钱时，你会失去准确的反馈回路。人们可能因为各种原因不想对你百分之百诚实。马克通过让自己和领导团队被这种文化包围，确保他自己和公司拥有准确的反馈回路。这就是“小团体”的一些独特属性。从流程角度看，我们每周有一次战略会议，比较开放，有讨论时间，时间较长且结构较松散。我们每周还有一次运营会议，结构非常严谨，我们会过一遍所有优先级项目。每个项目的负责人会汇报该项目的每周进展。这非常具有运营性和战术性。

---

### [00:23:55] Lenny Rachitsky

**English:**
Awesome. I just love this name, small group. It's just like a cozy name. It's not like executive staff or ESA after all these terms people always use. And that's just our small group.

**中文翻译:**
太棒了。我很喜欢“小团体”这个名字，听起来很亲切。不像人们常说的“执行参谋”或“ESA”之类的术语。这就是我们的“小团体”。

---

### [00:24:07] Naomi Gleit

**English:**
Totally.

**中文翻译:**
完全正确。

---

### [00:24:09] Lenny Rachitsky

**English:**
And then this framework you described, it sounds a lot like radical candor of challenging directly, but caring deeply. Where being disagreeable, but being constructive and additive. Is that the term? What was it? Disagreeable, but?

**中文翻译:**
你描述的这个框架听起来很像“彻底坦率”（Radical Candor），即直接挑战但深切关心。也就是虽然不随和，但是建设性的、有增益的。是那个词吗？是什么来着？不随和，但是？

---

### [00:24:23] Naomi Gleit

**English:**
A giver.

**中文翻译:**
付出者。

---

### [00:24:24] Lenny Rachitsky

**English:**
Giver? Yeah.

**中文翻译:**
付出者？是的。

---

### [00:24:25] Naomi Gleit

**English:**
Yes.

**中文翻译:**
是的。

---

### [00:24:26] Lenny Rachitsky

**English:**
Okay. That's great. If there's nothing here, totally cool. But is there something that you changed Mark's mind about? You've talked about he's good at seeing new data and being like, "Oh, okay, I see, I see." Or is there anything that you were successful there that is an interesting story?

**中文翻译:**
好的，太棒了。如果没有也没关系，但有没有什么事情是你改变了马克的想法的？你提到他很擅长观察新数据并说：“哦，好吧，我明白了。” 有没有这方面的成功案例或有趣的故事？

---

### [00:24:42] Naomi Gleit

**English:**
One of the things that we did in the early days on the growth team, because I'm not sure that necessarily when we talk about this sort of legacy or the history or the lore around the growth team, and this may not be a direct answer to the question, but it didn't really necessarily come from Mark. Mark wasn't like, "You guys should create a growth team. Here's how you should operate." And so I think in some ways we established and grew a growth team and Mark got on board or saw the value in it and was a huge proponent of it, but I'm not sure it necessarily originated with him. And indeed, I think sometimes the focus on being so data- driven might've been something that myself, Alex Schultz, Javier Olavon, these are some of the original people that were on the growth team and that my closest coworkers now may have really pushed on and highlighted the value of for Mark. I'm happy to talk about the growth team, which is something I get asked a lot of questions about, if you want.

**中文翻译:**
我们在增长团队早期做的一件事——我不确定当我们谈论增长团队的遗产、历史或传说时，这是否是对你问题的直接回答——但增长团队并不一定源自马克。马克并没有说：“你们应该建立一个增长团队，这是你们应该运作的方式。” 我认为在某种程度上，是我们建立并发展了增长团队，而马克随后加入并看到了它的价值，并成为了它的巨大支持者，但我不确定这是否起源于他。事实上，我认为有时对数据驱动的极度关注，可能是我、亚历克斯·舒尔茨（Alex Schultz）、哈维尔·奥利文（Javier Olivan）——这些增长团队的元老，也是我现在最亲密的同事——所推动的，并向马克强调了其价值。如果你愿意，我很乐意聊聊增长团队，这是很多人问我的话题。

---

### [00:25:53] Lenny Rachitsky

**English:**
Yeah, I'd love to. That's exactly where I was about to segue since you brought that up. So the Facebook growth team, it's a legendary team. I think it was probably the first real growth team in tech. The team developed some of the most core growth levers and techniques that companies use today, and so I'm really excited to chat a bit about this and what you learned from that time. One thing I wanted to start with is there's this legendary activation metric that you all had, the goal was to get, I think it was seven friends in 10 days or something like that. Is that a real thing? Is that what you guys actually did? Anything more there for folks that are like, "Oh, we got to come up with something like this"?

**中文翻译:**
是的，我很想聊。既然你提到了，这正是我准备切入的话题。Facebook 增长团队是一个传奇团队。我认为它可能是科技界第一个真正的增长团队。该团队开发了一些当今公司仍在使用的最核心的增长杠杆和技术，所以我非常兴奋能聊聊这段经历以及你从中学到了什么。我想从一个传说开始：你们有一个传奇的激活指标（activation metric），目标是让用户在 10 天内交到 7 个朋友，或者是类似的指标。这是真的吗？你们真的是这么做的吗？对于那些想要制定类似指标的人，还有什么可以分享的吗？

---

### [00:26:30] Naomi Gleit

**English:**
Sure. So yes, seven friends in 10 days was a thing. 10 friends in 14 days was also a thing. They're the same thing, they're just different points on a retention curve. I would say the key insight here is when we started the growth team, I think we were pretty focused on acquisition. We had a notion though of growth accounting, which looks at what's our net growth every day? And that would look at the number of new users that registered minus the number of users that actually went stale. So after a 30-day period, that's how we define it, they no longer logged in. And then plus the number of users that resurrected, which is after 30 days they came back. And what we found was the churn in resurrection lines were actually much larger than the new user line, which implied to us that retention and driving those two lines was actually our biggest lever to drive net growth. And so while we were focused on acquisition, a lot of our focus shifted to be around engagement and retention. How do we drive engagement and retention? We look at the variables that correlate most with that outcome. What we found was friending. And so those two magic moments, having seven friends in 10 days or 10 friends in 14 days really just map to when we feel like your likelihood of being a retained user goes up because you've seen the value in Facebook. And it makes sense, Facebook is much more compelling if you have 14 friends. And the other thing around 10 or 14 days is we wanted it to happen quickly, we wanted to have you experience the magic moment soon after you had registered on the site to prevent you from churning and then us having to resurrect you again.

**中文翻译:**
当然。是的，“10 天 7 个朋友”确实存在，“14 天 10 个朋友”也存在。它们本质上是一回事，只是留存曲线上的不同点。我想说，这里的核心洞察是：当我们成立增长团队时，我们非常关注获客（acquisition）。但我们有一个“增长核算”（growth accounting）的概念，即每天的净增长是多少？这等于：新注册用户数 - 流失用户数（定义为 30 天内未登录）+ 召回用户数（30 天后重新登录）。我们发现，流失和召回的曲线实际上比新用户曲线大得多，这意味着留存（retention）和驱动这两条曲线才是我们推动净增长的最大杠杆。因此，虽然我们关注获客，但大量精力转向了参与度（engagement）和留存。如何驱动留存？我们寻找与该结果最相关的变量。我们发现是“交友”。所以那两个“魔法时刻”——10 天 7 个朋友或 14 天 10 个朋友——实际上对应的是：当你达到这个点时，你留在平台上的可能性会大幅增加，因为你看到了 Facebook 的价值。这很合理，如果你有 14 个朋友，Facebook 会有趣得多。至于 10 天或 14 天的时间限制，是因为我们希望这能迅速发生，让你在注册后不久就体验到魔法时刻，防止你流失，从而避免我们以后还得费劲去召回你。

---

### [00:28:17] Lenny Rachitsky

**English:**
One of the most interesting lessons from this activation metric that people talk about, because right now everyone's like, "Yeah, of course retention is what you need to focus on. That's what product-market fit is." I think right now that's what everyone knows. I love that you guys basically figured that out, was one of the first times of, "Here's how we understand if our product will last and how to grow retention because it matters most." And retention cohort curves I think was one of the innovations y'all thought about early of just like, "Here's how we track retention, people joining at a certain time, how long do they stick around?"

**中文翻译:**
关于这个激活指标，人们谈论的最有趣的教训之一是——虽然现在每个人都会说：“当然，留存才是你需要关注的，那就是产品市场契合点。” 我想现在这是常识了。但我很喜欢你们当时就弄清楚了这一点，那是最早有人提出：“这就是我们如何理解产品是否能持久，以及如何增加留存，因为这最重要。” 我认为留存同类群组曲线（retention cohort curves）也是你们早期想出的创新之一，比如：“这就是我们如何追踪留存，在特定时间加入的人，他们会留存多久？”

---

### [00:28:48] Naomi Gleit

**English:**
Totally. And that was Danny Ferrante who really came up with the growth accounting framework, which I guess is quite obvious, but the plus new minus stale plus resurrected. The thing that I feel like may be valuable for PMs and is one of my Naomi-isms is I think what the growth team really pioneered was being data-driven and product-driven, especially in an area that was historically more of a business function. So I think at that time a lot of the growth in new users was expected to come from marketing or comms, whereas the insight that we had is actually the product is the biggest lever to drive growth, and that means we should have a product and engineering team working on optimizing things like the registration flow, the invite flow, the new user onboarding, getting you seven friends in 10 days. One of my Naomi-isms is really understand, identify, and execute. That framework came from 2009 where the growth team at the time, it was fledgling and it just started, was focused on only instrumenting data. And Alex often wears a shirt that says, "I guess when you can know." We just didn't have the data that we needed to make informed decisions to know really what were the biggest levers to drive growth. And so in 2009 in January, we basically stopped doing anything on our roadmap except data instrumentation. And that's when we instrumented every step of the registration flow, instrumented every step of the news or onboarding experience. We knew where there was drop off. And so we understood, which allowed us to identify what were the key opportunities to drive growth and maybe, hey, it's increasing friending in the user experience or 20% drop off on registered users at the email confirmation step, how can we address that? These are the opportunities that we identified and then we would execute by building products. So having this data-driven product-driven approach to what I think historically was more of a business responsibility at a company was sort of the special sauce of the growth team. We eventually extended that approach. I think that approach started with the growth team, but we extended to other areas. So for example, one of the projects that I took on after growth was social impact. And instead of what I think a normal company might do, which is start a corporate social responsibility wing, we decided, no, we're going to take a data-driven product-driven approach to driving social impact. Instead of having a foundation that's distributing money, we're going to build a product that actually raises money from our community. And many years later we've raised billions of dollars from the community for charity. So that's sort of the approach that I think is unique about the growth team that expanded to other areas and that I think that the company in many ways has taken to most of the problems that we face.

**中文翻译:**
完全正确。那是丹尼·费兰特（Danny Ferrante）真正提出了增长核算框架，虽然现在看来很明显：+新用户 -流失用户 +召回用户。我觉得对 PM 很有价值的一点，也是我的“Naomi 主义”（Naomi-isms）之一，就是增长团队真正开创了“数据驱动”和“产品驱动”的先河，尤其是在一个历史上更多被视为业务职能的领域。当时，人们预期新用户的增长应该来自营销或公关，而我们的洞察是：产品才是驱动增长的最大杠杆。这意味着我们应该让产品和工程团队去优化注册流程、邀请流程、新用户引导（onboarding），让你在 10 天内交到 7 个朋友。我的一个 Naomi 主义是：理解（Understand）、识别（Identify）和执行（Execute）。这个框架源于 2009 年，当时增长团队刚起步，专注于数据埋点（instrumenting data）。亚历克斯经常穿一件印有“当你能知道时，何必去猜”的 T 恤。我们当时就是没有足够的数据来做出明智的决定，不知道增长的最大杠杆是什么。所以在 2009 年 1 月，我们基本上停止了路线图上的所有工作，只做数据埋点。我们对注册流程的每一步、新用户引导体验的每一步都做了埋点。我们知道了哪里有流失。通过“理解”，我们得以“识别”出驱动增长的关键机会——比如，嘿，是在用户体验中增加交友机会，或者是解决注册用户在邮件确认步骤有 20% 流失的问题。识别出这些机会后，我们就通过构建产品来“执行”。这种将数据驱动和产品驱动的方法应用于传统业务职责的做法，就是增长团队的“秘方”。我们最终将这种方法扩展到了其他领域。例如，我在增长团队之后负责的一个项目是“社会影响”（Social Impact）。我们没有像普通公司那样成立一个企业社会责任部门，而是决定采取数据驱动、产品驱动的方法。我们没有成立分发资金的基金会，而是构建了一个能从社区筹款的产品。多年后，我们已经为慈善事业筹集了数十亿美元。这就是增长团队独特的方法论，它扩展到了其他领域，我认为公司在很多方面都用这种方法处理我们面临的大多数问题。

---

### [00:31:55] Lenny Rachitsky

**English:**
That's such a good point. And I almost took that for granted, but there was such a huge shift that y'all started from moving from marketing being the driver of growth to product and data and experiments and all that stuff. And so I think that's such a good reminder that, fun fact on the social good team, I'm really close friends with the designer that was on my team, his name's Mickey. He was on that team for a while and really enjoyed and yeah, really enjoyed working with you. Fun fact.

**中文翻译:**
这真是一个很好的观点。我几乎把它当成理所当然了，但你们确实开启了一个巨大的转变：从营销驱动增长转向产品、数据和实验驱动。这是一个很好的提醒。关于社会公益团队，有个趣闻：我团队里的一位设计师 Mickey 是我的好朋友，他在那个团队待过一段时间，非常喜欢，而且他非常享受和你一起工作。

---

### [00:32:22] Naomi Gleit

**English:**
Oh, that's so great. I remember Mickey, what is his last name?

**中文翻译:**
噢，那太好了。我记得 Mickey，他姓什么？

---

### [00:32:26] Lenny Rachitsky

**English:**
Settler.

**中文翻译:**
Settler。

---

### [00:32:27] Naomi Gleit

**English:**
Okay. Yes, I definitely remember this, yes. And social impact is just one thing that I think I'm really proud of. And again, remember social impact used to be a business thing. You would create this corporate social responsibility part of the company that was very separate from the product and engineering team. Another thing that we did in the early days was there was a juncture where it was like, "How are we going to translate this site?" And I think we could have taken more of a non-technical traditional approach and had professional translators translate the entire site into the different languages, and instead sort of what the growth team suggested was why don't we build a version of Facebook that allows you to make translations in line? And so the community of people using Facebook at the time who actually knew the product the best could actually insert translations and there was a whole system that we built around how to up-rank the best translations and down-rank, sort of like Wikipedia. And to this day, we have over 100 languages supported. So we're always trying to find these product technology solutions to these sort of traditional problems.

**中文翻译:**
好的，我肯定记得他。社会影响是我非常自豪的一件事。再次强调，社会影响以前是一项业务工作，你会创建一个与产品和工程团队完全分离的企业社会责任部门。我们在早期做的另一件事是关于网站翻译。当时我们面临一个抉择：如何翻译这个网站？我们本可以采取非技术的传统方法，请专业翻译人员将整个网站翻译成不同语言。但增长团队建议：为什么不构建一个允许用户在线翻译的 Facebook 版本呢？这样，当时最了解产品的 Facebook 用户社区就可以直接插入翻译。我们构建了一套系统来对最佳翻译进行排名，类似于维基百科。直到今天，我们支持超过 100 种语言。所以我们总是试图为这些传统问题寻找产品技术解决方案。

---

### [00:33:39] Lenny Rachitsky

**English:**
I totally remember that, where it's like you ask your users to help translate the site.

**中文翻译:**
我完全记得那个，就是让用户帮忙翻译网站。

---

### [00:33:43] Naomi Gleit

**English:**
Yes, yes.

**中文翻译:**
是的，没错。

---

### [00:33:46] Lenny Rachitsky

**English:**
I want to come back real quick to the activation metric because it's something that a lot of people somewhat misuse and think maybe incorrectly about. So to come up with an activation, as you described, you basically figure out what's the regression of if someone does X, retention increases, and so let's focus on getting them there. And a lot of people struggle with coming up with that metric. Do you have any thoughts on just how important it was to have that very specific activation milestone of seven exact friends in exactly 10 days versus the value of just having anything that is a rallying point for everyone to focus on and drive?

**中文翻译:**
我想快速回到激活指标的话题，因为很多人在某种程度上误用了它，或者理解有误。正如你所描述的，为了制定激活指标，你基本上是找出“如果某人做了 X，留存就会增加”的回归关系，然后专注于让用户达到那个点。很多人在制定这个指标时感到困难。你认为拥有一个非常具体的激活里程碑（比如 10 天 7 个朋友）有多重要？相比之下，仅仅拥有一个能让所有人团结一致去关注和推动的“集结号”指标，其价值又在哪里？

---

### [00:34:19] Naomi Gleit

**English:**
I think the majority of the value is in the latter, is just having extreme clarity around the goal and that allowed everybody to work towards optimizing the same goal. You're right, we did sort of just pick a point on the curve. I think it could have been any of those. And indeed, as part of preparing for this, I was like, "Was it seven friends in 10 days?" I had to go back and I asked a few people that I worked with back in the day and they were like, "Well, I thought it was 10 in 14." I mean, I think it doesn't matter, it's just that we picked one of them and what mattered there was we had the same goal, what mattered was that it was a retention goal or an activation metric. And one of the most important things that actually came out of having that goal was building a new user experience. Believe it or not, when we first launched Facebook, I wasn't around then, but in the early days of when it was just a college site, we didn't need a news or onboarding. We didn't need to explain to people that they had to find their friends. They were sort of automagically connected to everyone on the college campus and sort of knew how to use this product, it felt very intuitive. Again, we were college students building a product for other college students. They were sitting next to each other in libraries or at desks and sort of through osmosis understanding how the product worked. It was more when we launched the ability for teens to register and then work networks, and then in 2006 open registration where we started getting all kinds of people with any email address, before it was .edu or a microsoft.com email address that was required in order to sign up for Facebook and then anyone with any email just could register including people like my dad and my grandma that we realized, wow, in order to get people to this magic moment, how are we going to do that? What's the most effective way that insight resulted in building a new user experience? I remember it was just like step one, upload your profile picture. That was really important so people could find you and know who you were. Step two, find your friends. That's where a lot of the contact importing and people you may know and, "Here are other people at your school and here are mutual friends." That step in the news or experience ultimately became one of the most important drivers of that activation metric that we talked about.

**中文翻译:**
我认为大部分价值在于后者，即对目标拥有“极致的清晰度”（extreme clarity），这让每个人都能朝着优化同一个目标而努力。你说得对，我们只是在曲线上选了一个点。我觉得选哪一个都可以。事实上，在准备这次采访时，我还在想：“是 10 天 7 个朋友吗？” 我回去问了几个当年的同事，他们说：“呃，我以为是 14 天 10 个。” 我的意思是，这不重要，重要的是我们选了其中一个，重要的是我们有共同的目标，而且它是一个留存目标或激活指标。设定这个目标带来的最重要的成果之一就是构建了“新用户体验”（new user experience）。信不信由你，Facebook 刚推出时（我当时还没加入），在它还只是校园网站的早期，我们不需要新用户引导。我们不需要向人们解释他们必须找朋友。他们几乎是自动地与校园里的每个人建立了联系，而且直觉上就知道怎么用。毕竟，我们是大学生在为其他大学生开发产品。他们在图书馆或课桌旁并肩而坐，通过“渗透作用”就理解了产品如何运作。直到我们允许青少年注册，然后是工作网络，再到 2006 年开放注册（任何邮箱都可以注册，而以前需要 .edu 或微软邮箱），当包括我爸爸和奶奶在内的所有人都能注册时，我们才意识到：哇，为了让人们达到这个“魔法时刻”，我们该怎么做？最有效的方法是什么？这个洞察导致了新用户引导流程的建立。我记得当时就是：第一步，上传头像。这很重要，这样别人才能找到你并知道你是谁。第二步，找朋友。这就是联系人导入、“你可能认识的人”、“这是你学校的其他人”以及“共同好友”等功能的由来。新用户体验中的这一步最终成为了我们讨论的那个激活指标最重要的驱动力之一。

---

### [00:36:40] Lenny Rachitsky

**English:**
I love that you shared that, such a recurring theme on this podcast, the power of onboarding, the value of investing in onboarding and the ripple effects of opportunities there. I love that you also were kind of like the first like, "Onboarding, that's a thing, we need onboarding."

**中文翻译:**
我很喜欢你分享的这一点，这是本播客反复出现的主题：引导流程（onboarding）的力量，投资引导流程的价值，以及它带来的连锁反应。我也很喜欢你当时就像是第一个意识到“引导流程是个正经事，我们需要它”的人。

---

### [00:36:55] Naomi Gleit

**English:**
I know. I mean, I remember the day where I was like, "Do we need to explain to people how to use this? Is it not obvious?" And it's like my dad's like, "I don't understand this whatsoever." My dad would go on to become Facebook's biggest power user because I always beta tested everything with him. But that was not obvious to us at the time in 2006 that we had to explain to people how to use Facebook. And again, remember that it's fun talking about this because obviously the product has evolved so much, but the principles are relatively the same. It was thefacebook.com, eventually it became facebook.com, but eventually we built a mobile app and then it was mobile first product, and then it was about mobile photos, and then it was about mobile videos. So over time, the technology has really changed, but the core use case that we really need to educate people on, which is how to connect with their friends on Facebook and whatever iteration or product is the same. And so obviously we still have an onboarding today and it's relatively the same principles, like get a profile picture and find your friends.

**中文翻译:**
我知道。我记得那天我在想：“我们需要向人们解释怎么用吗？这不是显而易见的吗？” 结果我爸说：“我完全看不懂这玩意儿。” 我爸后来成了 Facebook 最大的重度用户，因为我总是拿他做 Beta 测试。但在 2006 年，我们需要向人们解释如何使用 Facebook 这一点对我们来说并不显而易见。再次强调，聊这些很有趣，因为产品显然已经进化了很多，但原则基本没变。从 thefacebook.com 到 facebook.com，再到构建移动应用、移动优先、移动照片、移动视频。随着时间的推移，技术发生了巨大变化，但我们需要教育用户的核心用例——即如何在 Facebook 上与朋友建立联系——无论产品如何迭代都是一样的。所以显然我们今天仍然有引导流程，而且原则基本相同：上传头像，找到朋友。

---

### [00:38:12] Lenny Rachitsky

**English:**
Along those same lines, just maybe a last question around the growth stuff that you worked on for folks that are thinking of driving growth, working on onboarding maybe specifically just are there any lessons from things that worked super well when you were looking to accelerate growth of the Facebook early on that you think people are maybe sleeping on as lepers and tactics that worked back then that might still be really powerful today?

**中文翻译:**
沿着这个思路，关于增长的最后一个问题：对于那些正在考虑驱动增长、特别是优化引导流程的人来说，在 Facebook 早期加速增长的过程中，有没有什么效果极好、但你觉得现在的人可能忽视了的经验或战术，而这些在今天依然可能非常强大？

---

### [00:38:36] Naomi Gleit

**English:**
Well, definitely the understand, identify, execute. I would just ask yourselves, do you have the data that you need to know what you need to do on growth? And if not, definitely take the time to instrument that data. The thing that, I think we were relatively lucky, I talked about why I was bullish on Facebook in 2005 even was because there was product-market fit. And so for us growth, as much credit as we give to the growth team, I'm actually not sure how much credit we deserve and how much incremental growth we drove above and beyond the fact that this was a product that had product-market fit and we benefited in a huge amount from having high demand for the product. So at every step, and I talked about the growth team, the projects that we were working on were really at a high level around removing barriers. There were macro barriers, like the first project I worked on was high school students on Facebook, which is an interesting story in and of itself because at that time we almost created a separate website called Facebook High just to keep them separate from the college students. But at that time we were like, "No, this is one graph. This is one community. College students have friends and people they're connected to of all different ages. Why bifurcate the graph?" And obviously we've maintained that principle ever since. But it was about removing barriers. So you had to be a college student, then you had to be a high school student, then you had to be in a work network, then you had to have any email address. One of the next projects I worked on was not everyone has access to a smartphone, how can we remove the barrier of having access to a smartphone and building more of a rich Facebook experience for someone that was using a feature phone or a lower-end device? Internet.org, what about removing the barrier of having access to the internet or being able to afford a data plan? And so those are the macro barriers that thematically the growth team has worked on. What I would say is maybe applicable is really the micro barriers. All of the work that we did on growth around optimizing the flows were really about removing micro barriers. One of the things that I thought was just so elegant was after we did that 2009 instrumentation of all the flows, the product flows relevant to growth, what we found is 20% of people aren't actually confirming their email. We tried sending them an SMS, so maybe they would confirm the SMS instead. What we found was a lot of people are actually still clicking on notifications that they're getting, but because it wasn't the specific confirmation email, we weren't able to confirm the account. And so what we did was allow people to get notifications even as an unconfirmed account, and then if they clicked on any of those notifications, that would count as an account confirmation as well because they proved ownership of the email. It's just removing a micro barrier of having to go find the confirmation email, click it before you can do anything on the site. So I do think we've been relatively lucky in having a lot of high demand That meant that we could focus on just removing micro barriers. And then on the growth team, a lot of the iterations and optimizations were about removing just sort of friction.

**中文翻译:**
首先，绝对是“理解、识别、执行”。我会问你们：你们是否有足够的数据来知道在增长方面该做什么？如果没有，一定要花时间去做数据埋点。我认为我们相对幸运，我提到过为什么我在 2005 年就看好 Facebook，是因为它有 PMF。所以对于增长，尽管我们给了增长团队很多功劳，但我其实不确定我们到底应得多少，以及在产品本身就有 PMF 且需求巨大的情况下，我们到底驱动了多少增量增长。在每一步中，增长团队的项目在高层面上都是围绕“消除障碍”展开的。有宏观障碍，比如我负责的第一个项目是让高中生加入 Facebook。这本身就是个有趣的故事，因为当时我们几乎要创建一个名为“Facebook High”的独立网站，把他们和大学生分开。但当时我们想：“不，这是一个社交图谱，一个社区。大学生的朋友和联系人涵盖各个年龄段，为什么要拆分图谱？” 显然，我们自那以后一直坚持这个原则。所以增长就是消除障碍：从必须是大学生，到高中生，到工作网络，再到任何邮箱。我负责的下一个项目是：并非所有人都有智能手机，我们如何消除智能手机的障碍，为使用功能机或低端设备的人提供丰富的 Facebook 体验？还有 Internet.org，如何消除无法上网或付不起流量费的障碍？这些是增长团队在主题上处理的宏观障碍。我觉得对大家更有参考价值的是“微观障碍”。我们在优化流程方面所做的所有增长工作，本质上都是在消除微观障碍。我发现一个非常优雅的例子：在 2009 年对所有增长相关流程进行埋点后，我们发现 20% 的人没有确认邮件。我们尝试给他们发短信确认。后来我们发现，很多人其实一直在点击收到的通知，但因为那不是专门的确认邮件，我们无法确认账号。于是我们做了一个改动：允许未确认账号接收通知，如果他们点击了任何通知，这也算作账号确认，因为他们证明了对该邮箱的所有权。这只是消除了一个微观障碍——即必须先找到确认邮件并点击它才能使用网站。所以我认为我们很幸运，因为需求巨大，这意味着我们可以专注于消除微观障碍。增长团队的大量迭代和优化都是为了消除摩擦。

---

### [00:41:56] Lenny Rachitsky

**English:**
I love that framework of micro barriers and macro barriers, just thinking about ways to make this accessible to more people and also just helping them get through the flow faster. I also love your point about how a lot of growth teams get a lot of credit for growing a business when really in many ways it could have done really well even without that team potentially because product-market fit was so strong. I think about this with Airbnb honestly as just such after it gets to a certain point, such good product-market fit that who knows what would've happen if there was no one working on growth? It probably would've been okay for a long time.

**中文翻译:**
我喜欢“微观障碍”和“宏观障碍”这个框架，思考如何让更多人接触到产品，并帮助他们更快地完成流程。我也很喜欢你提到的：很多增长团队因为业务增长而获得了很多赞誉，但实际上在很多情况下，即使没有那个团队，业务可能也会发展得很好，因为 PMF 太强了。老实说，我也在想 Airbnb，在达到某个点之后，它的 PMF 如此之好，以至于谁知道如果没有人专门做增长会发生什么？它可能在很长一段时间内依然表现良好。

---

### [00:42:27] Naomi Gleit

**English:**
Totally. And then maybe where we do sort of see the impact is maybe something like the translations thing that we talked about. With the macro barrier, removing the language barrier, and so maybe the approach we took meant that we supported 100 plus languages instead of whatever the professional translators, we have the long tail of languages so that last person who's still speaking a near extinct language can still use Facebook. But yeah, I think that's right. I sometimes think that maybe some of our efforts were really more on the margin of a bigger trend around product-market fit.

**中文翻译:**
完全正确。也许我们真正看到影响的地方是像我们谈到的翻译项目。通过消除语言这一宏观障碍，我们采取的方法意味着我们支持了 100 多种语言，而不仅仅是专业翻译能覆盖的那些。我们覆盖了长尾语言，让那些说着濒危语言的人也能使用 Facebook。但你说得对，我有时觉得我们的一些努力其实只是在 PMF 这一大趋势的边缘做了一些贡献。

---

### [00:43:06] Lenny Rachitsky

**English:**
Final little thing I would just want to highlight again that you said that I think is so important, and I've always thought is true and I love that you confirmed it, is that the activation metric that you all rallied around the biggest value of it wasn't this is exactly the right regression connection to retention, it's more that we have something we are all going to focus on, and that is where most of the impact comes from is let's get more people to that point, whether it's perfectly right or not, it doesn't really matter.

**中文翻译:**
最后我想再次强调你刚才说的一点，我认为这非常重要，我一直觉得这是真的，很高兴你证实了它：你们所有人团结一致去追求的那个激活指标，其最大的价值并不在于它与留存之间的回归关系有多精确，而在于我们有了一个大家共同关注的目标。大部分影响来自于“让我们把更多人带到那个点”，至于那个点选得是否完美，其实并不重要。

---

### [00:43:32] Naomi Gleit

**English:**
Yes.

**中文翻译:**
是的。

---

### [00:43:32] Lenny Rachitsky

**English:**
Love that. And I think that's really freeing to a lot of people because they're like, "Oh, we don't know if we're going to be as perfect about this versus let's just drive some growth and get people who are good enough thinking on that." Okay, great. You mentioned Naomi-isms, I want to segue to that. So let me first read a quote. So I asked Adam Mosseri, who is Head of Instagram, what to ask you. I know you guys work together on a bunch of stuff. Here's how he described you, "Naomi is called the conductor here at Meta. She has an incredible ability to handle the most complex projects and problems and bring the right people together to simplify and solve them. She is very firm yet kind. Her standards are extremely high, and she sets the bar." Also many other people that I messaged said very similar things about you, about how you're incredibly good at taking very complex problems and getting shit done, getting them done, simplifying them and getting them done. So I want to spend some time understanding what you've learned about how to do this well. What are the skills you've collected that allow you to take really complex problems and get to a solution, stay kind but firm and take on these really hard challenges? So maybe just broadly, I'm curious, what are some of these skills that you have built that allow you to do this?

**中文翻译:**
太棒了。我觉得这对很多人来说是一种解脱，因为他们常担心：“噢，我们不知道这个指标是否完美。” 实际上，只要能驱动增长，让大家朝着一个足够好的方向思考就行了。好的，太棒了。你提到了“Naomi 主义”，我想以此为切入点。首先让我读一段话。我问了 Instagram 的负责人亚当·莫塞里（Adam Mosseri）该问你什么，我知道你们在很多事情上都有合作。他是这样描述你的：“Naomi 在 Meta 被称为‘指挥家’。她拥有一种不可思议的能力，能够处理最复杂的项目和问题，并将合适的人聚集在一起，将其简化并解决。她非常坚定但又很友善。她的标准极高，她设定了标杆。” 我发消息询问的其他许多人也对你有类似的评价，说你非常擅长处理极其复杂的问题并把事情办成，简化它们并交付结果。所以我想花点时间了解一下，关于如何做好这些事情，你学到了什么？你积累了哪些技能，让你能够处理极其复杂的问题并找到解决方案，同时保持友善但坚定的态度去迎接这些艰巨的挑战？所以，从广义上讲，我很想知道你培养了哪些技能让你能做到这一点？

---

### [00:44:51] Naomi Gleit

**English:**
Yeah, well also that's very kind of Adam. I adore Adam obviously, he is one of the tenured people in small group and I've actually gotten the opportunity to work even more closely with him than usual. We recently launched something called Teen Accounts and Adam and I worked very closely on that. In terms of how I do the things people say that I can do, I really rely on Naomi-isms. Like I said, and actually I refer your podcast out a lot because there isn't just a PM university that I can send people to, there isn't a formal training that people can get to become a product manager, and that's where Naomi-isms came from. It was stuff that I learned on the job from other people, including from Adam, that I found myself repeating over and over again. "A good PM looks for a way to make that more efficient," for me, that was writing them down, people started calling them Naomi-isms. I started sharing them internally. And then I think two years ago, I also started sharing them externally. Adam referred to me as a conductor, that's one of the Naomi-isms, in my role as Head of Product, I want to educate the PM community about what is PM? It's the most common question I get from PMs and non-PMs, "What do PMs do? What makes a great PM?" And what I say is a PM is a conductor. It's as though the team that you are a PM on is an orchestra. There are many different functions in your team that includes legal policy, comms, data analytics, engineering, design, much like there are many different instruments in an orchestra. And as a PM, your job is to make sure everyone's playing their part correctly, every section in the orchestra is playing their part, but at the same time, they're playing together, they're unified in the music that they're producing and that they're playing at the right tempo. And a lot of times I think people use music analogies or vocabulary to describe the work, and that includes things like people being in harmony, like a good team, a good PM, a good orchestra is in harmony, they're in sync, they're at the right tempo, they have the right cadence. That's sort of how I imagine what a PM does at work. Important characteristics are the PM is not the star of the show. Indeed, conductors don't even say anything during the performance. And also, I would at the same time give PMs little metronomes and conductor wands. This was something that I used to do when we were smaller., Just to sort of take the analogy way too far.

**中文翻译:**
亚当太客气了。我显然很崇拜亚当，他是“小团体”中的资深成员之一，最近我有机会比平时更紧密地与他合作。我们最近推出了“青少年账户”（Teen Accounts），亚当和我在这方面合作非常紧密。至于我是如何做到别人所说的那些事的，我确实非常依赖“Naomi 主义”。正如我所说的，我经常推荐你的播客，因为并没有一所“PM 大学”可以送人去进修，也没有正式的培训能让人成为产品经理。这就是“Naomi 主义”的由来。这些是我在工作中从别人（包括亚当）那里学到的东西，我发现自己一遍又一遍地重复它们。“一个好的 PM 会寻找让事情更高效的方法”，对我来说，那就是把它们写下来。人们开始称之为“Naomi 主义”，我开始在内部分享。大约两年前，我也开始在外部分享。亚当称我为“指挥家”，这也是“Naomi 主义”之一。作为产品负责人，我想教育 PM 群体：什么是 PM？这是我从 PM 和非 PM 那里收到的最常见的问题：“PM 是做什么的？什么造就了伟大的 PM？” 我的回答是：PM 就是指挥家。就好像你所在的 PM 团队是一个管弦乐队。你的团队中有许多不同的职能，包括法务、政策、公关、数据分析、工程、设计，就像管弦乐队中有许多不同的乐器一样。作为 PM，你的职责是确保每个人都正确地履行自己的职责，乐队的每个部分都在演奏自己的部分，但同时，他们是在一起演奏，他们创作的音乐是统一的，并且节奏正确。很多时候，人们会用音乐的比喻或词汇来描述工作，包括“和谐”（harmony）——一个好的团队、好的 PM、好的管弦乐队是和谐的，他们是同步的，节奏正确，步调一致。这就是我构思 PM 工作的方式。重要的特征是：PM 不是演出的明星。事实上，指挥家在演出期间甚至一言不发。而且，我以前还会给 PM 发小节拍器和指挥棒。那是公司规模还小时我常做的事，只是为了把这个比喻发挥到极致。

---

### [00:47:29] Lenny Rachitsky

**English:**
That's so funny. You actually gave him conductor wands and metronomes?

**中文翻译:**
太搞笑了。你真的给他们发指挥棒和节拍器？

---

### [00:47:32] Naomi Gleit

**English:**
Oh yeah, just to wave around. Yeah, I love that.

**中文翻译:**
噢是的，就是让他们挥着玩。是的，我很喜欢那个。

---

### [00:47:35] Lenny Rachitsky

**English:**
I would love a conductor wand. (Ad Segment - Eppo) This episode is brought to you by Eppo... [Ad content omitted]

**中文翻译:**
我也想要一根指挥棒。（广告内容略：Eppo 赞助）

---

### [00:48:57] Naomi Gleit

**English:**
So PM as conductor is sort of how I describe the product management function, but one of the key Naomi-isms that I think is really critical to getting stuff done is what I call extreme clarity. I think our jobs are super hard. Extreme clarity means everyone's on the same page. It definitely doesn't mean that they all agree with each other, but they just have the same understanding of the facts. So we can disagree, but we all believe in the facts, which is that there's A, B, C, our options are X, Y, Z and here are the trade-offs 1, 2, 3. That kind of shared understanding is what extreme clarity is. That came from a place of just being in many meetings, on many emails, in many situations where I felt like we actually agree on something, the nature of this conflict is a result of misunderstanding. And that seems like an incredible waste of time. And so we want to have extreme clarity so we can just focus our conversations on things when we actually agree, not when we are misunderstanding each other. There are a lot of tactics that I use to drive extreme clarity.

**中文翻译:**
“PM 即指挥家”是我描述产品管理职能的方式，但我认为对于把事情办成至关重要的一个核心“Naomi 主义”是我所说的“极致的清晰度”（Extreme Clarity）。我认为我们的工作超级难。极致的清晰度意味着每个人都在同一频道上。这绝对不意味着他们都互相认同，而是说他们对事实有相同的理解。所以我们可以有分歧，但我们都认同事实，即：有 A、B、C 现状，我们的选项是 X、Y、Z，权衡利弊是 1、2、3。这种共同的理解就是极致的清晰度。这源于我参加过太多的会议、处理过太多的邮件和情况，在这些情况下我觉得我们其实在某件事上达成了一致，但冲突的本质是误解。这简直是极大的时间浪费。所以我们要有极致的清晰度，这样我们就可以把对话集中在真正的分歧点上，而不是互相误解。我有很多策略来驱动这种极致的清晰度。

---

### [00:50:03] Lenny Rachitsky

**English:**
Yeah, I was going to ask how you do that, that sounds great. How does one get to extreme clarity?

**中文翻译:**
是的，我正想问你是怎么做到的，听起来很棒。一个人如何达到极致的清晰度？

---

### [00:50:07] Naomi Gleit

**English:**
So another name I'm using is canonical everything, so that includes canonical nomenclature, I often talk about canonical nomenclature. One way to ensure extreme clarity is we have the shared vocabulary. I've been in a lot of situations where people are using the same or different words to describe the same or different things, which results in talking past each other. One of the most egregious examples of this is when I was working, I was in a conversation around how our reviewers and global operations were performing, and we were using consistency and accuracy interchangeably. Consistency refers to how often different reviewers agree on the decision. Accuracy refers to how often the decision is correct according to ground truth. Those are very different things. We don't want to optimize for consistency because you could be consistently wrong. We want to optimize for accuracy. And so that is what canonical nomenclature is literally writing out all the words in their definitions, so when we communicate, we are using the same vocabulary. I really believe in visuals. I think sometimes just having a conversation or a big meeting where people are talking, I'm just not very auditory, I'm a very visual person, it's hard for me to follow along just by listening. I will often have a visual in a meeting. I will leverage that visual to literally real time edit what is being decided. For example, if we have multiple options, I will edit the slide that's being projected to say, "We decided on option one, here are the next steps, 1, 2, 3." A lot of times people are saying, "That's not what I heard. I heard this as a next step, or I heard that as a next step." I love that because that avoids leaving the meeting and being like, "I don't know what we agreed to. I heard this, you heard that." No, actually we haven't agreed upon set of decisions and next steps that we all real time edited and looked at together.

**中文翻译:**
我用的另一个术语是“万物皆有权威版本”（Canonical Everything），这包括“权威命名法”（Canonical Nomenclature）。我经常谈论权威命名法。确保极致清晰度的一种方法是拥有共同的词汇表。我遇到过很多情况，人们用相同或不同的词来描述相同或不同的事物，导致各说各话。最严重的例子之一是，有一次我在讨论审核员和全球运营的表现，我们交替使用“一致性”（consistency）和“准确性”（accuracy）。一致性是指不同审核员对同一决定的认同频率；准确性是指根据事实真相（ground truth），该决定正确的频率。这是完全不同的两回事。我们不想优化一致性，因为你可能“一致地犯错”。我们要优化的是准确性。所以权威命名法就是字面上写下所有的词及其定义，这样当我们交流时，我们使用的是同一套词汇。我非常相信视觉化的力量。我认为有时只是开个大组会大家在那说，我不是那种听觉型的人，我是视觉型的人，光靠听很难跟上。我经常在会议中展示视觉材料。我会利用这些视觉材料实时编辑正在决定的内容。例如，如果我们有多个选项，我会编辑投影的幻灯片说：“我们决定选选项一，接下来的步骤是 1、2、3。” 很多时候人们会说：“那不是我听到的，我听到的下一步是那个。” 我喜欢这种反馈，因为这避免了开完会走人后觉得：“我不知道我们达成了什么共识，我听到的是这个，你听到的是那个。” 不，实际上我们有一套共同编辑、共同审阅过的决定和后续步骤。

---

### [00:51:54] Lenny Rachitsky

**English:**
Just to double click on that one real quick, so what you're describing for the visual is you're presenting here's our options, here's our three options on a slide. You all decide we're going to go with option two, you edit the slide with a star, here's what we chose, and then maybe change some stuff. And this is exactly to your point of extreme clarity, people can see clearly this is what we're choosing. If they disagree and don't realize that's what's happening, it'll be really clear.

**中文翻译:**
快速深入探讨一下：你描述的视觉化过程是，你在幻灯片上展示三个选项。大家决定选选项二，你就直接在幻灯片上打个星号，标明“这是我们的选择”，然后可能修改一些内容。这正符合你说的极致清晰度，人们能清楚地看到这就是我们的选择。如果他们不同意或者没意识到发生了什么，这会变得非常清晰。

---

### [00:52:17] Naomi Gleit

**English:**
Totally.

**中文翻译:**
完全正确。

---

### [00:52:18] Lenny Rachitsky

**English:**
Awesome.

**中文翻译:**
太棒了。

---

### [00:52:19] Naomi Gleit

**English:**
And one thing people make fun of me a lot for that I think is just a great example of extreme clarity is I never use bulleted lists because you can never refer to a bullet. I always use numbered lists because you can always in the visual in a meeting as referenced in number two, I have feedback on that, versus the third bullet, two up from the second, whatever, that is not extreme clarity. So it's very, very small tactical things to bigger things like canonical everything. But I can be a little bit strict.

**中文翻译:**
还有一件事人们经常取笑我，但我认为这是极致清晰度的绝佳例子：我从不使用圆点列表（bulleted lists），因为你永远无法准确引用一个圆点。我总是使用编号列表（numbered lists），因为在会议的视觉展示中，你可以说“关于第二项，我有反馈”，而不是说“第三个圆点，第二个上面的那个”，那不是极致的清晰度。所以从非常微小的战术细节到像“万物皆有权威版本”这样的大事，我可能都有点严格。

---

### [00:52:54] Lenny Rachitsky

**English:**
I love that very tactical tip and that is awesome, that's exactly the stuff I look for. Is there any other very nuanced tip along those lines that is helpful in extreme clarity or canonical everything?

**中文翻译:**
我喜欢这个非常实用的战术技巧，太棒了，这正是我想要的东西。还有其他类似的、有助于实现极致清晰度或“万物皆有权威版本”的微妙技巧吗？

---

### [00:53:09] Naomi Gleit

**English:**
Canonical everything... And stop me if I'm getting too wonky, I can really get into this.

**中文翻译:**
万物皆有权威版本……如果我讲得太细太枯燥了就叫停我，我真的能聊很久。

---

### [00:53:16] Lenny Rachitsky

**English:**
We got a ways to go.

**中文翻译:**
我们还有时间，继续。

---

### [00:53:18] Naomi Gleit

**English:**
When I had a face bursary, along the years people have given me posters and the posters say these Naomi-ism, so extreme clarity is one, canonical everything is another. I think people really associate me with canonical, canonical, canonical. I always want a canonical doc. This came from a place of me I work on a lot of different projects, a lot of times I'm ramping up mid-project, I'm like, "Where can I learn what I need to learn about this project?" I ask five different people, get five different answers, that is unacceptable. Everyone should know exactly where the canonical doc is. That's the one place I can go to get all the information I need about a project and it will link to all the other docs. Of course, I'm sure there's hundreds of docs associated with the project, but there needs to be one canonical doc, and that canonical doc really has to have the basic information that you need to know. For any project, the basic information that you need to know is what are the discrete areas of work, I call those work streams, this is pretty obvious. Who are the owners on those work streams? So for every work stream there's an owner. Again, it seems pretty obvious. Sometimes I'm like, "Who's owning this?" And it's like people don't know. That's why I think it's very important to have a single-threaded owner. We used to call this a directly responsible individual or a throat to choke. We obviously don't say that anymore. Single-threaded owner, every work stream has a single-threaded owner. Sometimes work streams are really big. You have sub work streams underneath them. Everything canonical needs to recurse, so you should have an owner or an STO for the sub work stream. The other things on the canonical doc are what is the process by which the people on this team work together. I hate pairwise conversations. I feel like they're a waste of time. I feel like you could have four conversations with four different people or one conversation with all four people. Everyone has the same context. Ideally there's a visual in that meeting and you real time edited it, there is extreme clarity. The canonical doc will have what is the canonical meetings that people have, what is the canonical email list that you're going to use, what is the canonical workplace chat. Let's not reinvent the same audience 10 different times with different permutations of the people on the working team. Let's just have one canonical chat. And then often the canonical doc will have the canonical nomenclature. I really believe in frameworks for things that helps drive extreme clarity. A framework is best understood when there's a visual representation of the framework in my mind, and so we'll have canonical visuals and that's what I mean by canonical everything. So anytime I start on a new project, everyone knows to send me the canonical doc.

**中文翻译:**
在我入职周年纪念时，这些年来人们送给我一些海报，上面写着这些“Naomi 主义”：极致清晰度是一个，万物皆有权威版本是另一个。我想人们真的把我和“权威版本”（canonical）联系在一起了。我总是想要一份“权威文档”。这源于我负责很多不同项目，很多时候我是中途加入，我会问：“我从哪里可以学到我需要了解的信息？” 如果我问五个人得到五个答案，那是不可接受的。每个人都应该确切知道权威文档在哪里。那是我获取项目所需所有信息的唯一地方，它会链接到所有其他文档。当然，项目肯定有成百上千份文档，但必须有一份权威文档，它必须包含你需要知道的基本信息。对于任何项目，基本信息包括：有哪些独立的工作领域（我称之为“工作流”work streams），这很显而易见。这些工作流的负责人是谁？每个工作流都要有一个负责人。这听起来也很显而易见，但有时我问“谁负责这个？”，大家竟然不知道。这就是为什么我认为拥有“专职负责人”（Single-threaded owner，简称 STO）非常重要。我们以前称之为“直接责任人”（DRI）或“出了事找谁算账的人”。现在我们显然不这么说了。专职负责人——每个工作流都有一个。有时工作流很大，下面还有子工作流。所有“权威”的东西都需要递归，所以子工作流也应该有负责人或 STO。权威文档上的其他内容还包括：团队成员合作的流程。我讨厌“一对一”的重复对话，我觉得那是浪费时间。你可以和四个人分别谈四次，也可以和四个人一起谈一次，让每个人都有相同的背景信息。理想情况下，会议中会有视觉展示并实时编辑，实现极致清晰度。权威文档还会列出：有哪些权威会议、权威邮件列表、权威工作聊天群。不要为同一群人创建 10 个不同的聊天群组合，就用一个权威聊天群。通常权威文档还会有权威命名法。我非常相信框架的作用，框架在有视觉呈现时最容易被理解，所以我们会有“权威视觉图”。这就是我说的“万物皆有权威版本”。所以每当我开始一个新项目，大家都知道要发给我那份权威文档。

---

### [00:55:52] Lenny Rachitsky

**English:**
I love this. If you come into a that you've given that's really gnarly and complex, what do you find are the first couple things you do that make a big dent on helping everyone align and understand what happens, what they should be doing and what they should be prioritizing?

**中文翻译:**
我喜欢这个。如果你接手了一个非常棘手且复杂的项目，你发现最先做的哪几件事能对帮助大家达成一致、理解现状、明确职责和优先级产生重大影响？

---

### [00:56:12] Naomi Gleit

**English:**
A lot of times I'm simplifying. A lot of times there isn't a canonical doc and so I'll go through the process of creating that, but I think that really falls under the simplification thing. I often go into a project, everyone's operating at a PhD level, I'm coming in at a kindergarten level, and so I need to understand... It's almost like all of this complexity we're at a PhD level, I need to create the curriculum, go back to basic building blocks for the kindergarten level, how do I explain that and understand this project at a kindergarten level. It doesn't mean I want to oversimplify, that's not what a simplifier does. They're not oversimplifying, but what they are doing is identifying the most basic building blocks of a complex problem and then unfolding, or revealing or building on top of them additional complexity and details as you go along. And so sometimes I talk about a school pyramid, but I need to establish the kindergarten curriculum and then the elementary school curriculum and then the high school curriculum and then the college curriculum, and then we can operate at the PhD level. But oftentimes people on the project are at really different levels of understanding or complexity. And until we have what we call the school pyramid, the curriculums for every level of the project, it's really hard to make progress. A lot of times that process of simplification will often identify what are the most important things to deal with on the project.

**中文翻译:**
很多时候我是在做“简化”。很多时候并没有权威文档，所以我会在创建文档的过程中进行简化。我进入一个项目时，大家往往都在“博士水平”运作，而我是以“幼儿园水平”进入的。我需要理解……就像所有的复杂性都在博士水平，我需要创建一套课程，回到幼儿园水平的基础构建块，思考如何用幼儿园水平来解释和理解这个项目。这并不意味着我要“过度简化”，一个简化者（simplifier）不会过度简化，他们做的是识别复杂问题最基础的构建块，然后随着进展逐步展开、揭示或在其上构建额外的复杂性和细节。所以我有时会谈论“学校金字塔”：我需要先建立幼儿园课程，然后是小学、中学、大学课程，最后我们才能在博士水平上运作。但通常项目中的人处于完全不同的理解或复杂程度。在我们建立所谓的“学校金字塔”（即项目每个阶段的课程体系）之前，很难取得进展。很多时候，这种简化的过程本身就能识别出项目中最重要的待办事项。

---

### [00:57:48] Lenny Rachitsky

**English:**
And so what I'm hearing is when you come into a project and the way you simplify is you start putting together a doc that describes these things you're talking about, here's the work streams, here's the owners, here's the process, here's our canonical meeting style, and that reveals here's what matters most and where there's confusion.

**中文翻译:**
所以我听到的是，当你进入一个项目时，你简化的方式是开始编写一份文档，描述你提到的这些内容：工作流、负责人、流程、权威会议风格，这揭示了什么最重要以及哪里存在困惑。

---

### [00:58:07] Naomi Gleit

**English:**
Yes, yes. Yeah, that is. And a lot of times what needs to happen in the project is sometimes there's a strategy or an execution issue and sometimes there's a people or a process issue. I would say 80% of the time I think it's a people or process issue. And that refers to not having the right people on the project, or having the right people but not having the right process by which they work together, a strategy or execution issue. When we get to that, I first try to tackle those or in general I think it's really important to have perfect execution. I want to make sure a project is perfectly executing, because only then can we really reevaluate whether or not this strategy is right or wrong. We're in the worst of all worlds where we are imperfectly executing and therefore, at the end of the day, the project might fail, but we don't know why. Is it because the strategy was right or wrong or is it because the execution was poor? The ideal case is the strategy was right and you perfectly executed on it. The next best case scenario is the strategy was wrong, but you perfectly executed on it, because then you learned the strategy was wrong. Revamp the strategy and try again.

**中文翻译:**
是的，没错。很多时候项目中发生的情况是，有时是战略或执行问题，有时是人员或流程问题。我会说 80% 的时间我认为是人员或流程问题。这指的是项目中没有合适的人，或者有合适的人但没有正确的协作流程。当我们谈到战略或执行问题时，我首先尝试解决这些问题，或者总的来说，我认为“完美的执行”非常重要。我要确保项目正在完美执行，因为只有这样，我们才能真正重新评估战略是对是错。最糟糕的情况是我们执行得不完美，因此到头来项目失败了，但我们不知道原因：是因为战略错了，还是因为执行太差？理想情况是战略正确且执行完美。次优情况是战略错误但执行完美，因为这样你就知道战略错了，可以重新调整战略再试一次。

---

### [00:59:22] Lenny Rachitsky

**English:**
You're really in the PM part of my brain. I feel like most PMs listening are like it has clean documents, really simple processes, there's one person to charge, it links to everything. It just feels good.

**中文翻译:**
你真的触及了我大脑中 PM 的那部分。我觉得大多数听众 PM 都会觉得：整洁的文档、简单的流程、明确的负责人、链接到一切，这种感觉真好。

---

### [00:59:34] Naomi Gleit

**English:**
Totally. And, again, sometimes I feel the need to defend that the process is not for process' sake, it's ultimately to help us all move faster and work better. So hopefully that comes through. But I deeply believe that it is through this approach that we can move faster. And you have to prove that nobody wants more process and more meetings and more, but my goal is that with this we're actually simplifying process and getting less meetings and just making things clearer and ultimately moving faster.

**中文翻译:**
完全正确。而且，我有时觉得有必要辩解一下：流程不是为了流程本身，它最终是为了帮助我们所有人跑得更快、工作得更好。希望大家能理解这一点。但我深信，通过这种方法我们可以跑得更快。你必须证明这一点，因为没人想要更多的流程和会议，但我的目标是通过这些手段简化流程、减少会议、让事情更清晰，最终跑得更快。

---

### [01:00:08] Lenny Rachitsky

**English:**
I'm going to read another quote from another one of your co-workers, Charles Porch, he's vice president of global partnerships at Instagram and he basically said what we've been talking about, some of the biggest strategic bets and biggest swings Meta has made have had Naomi at the helm. No one can hurt cats, drive clarity, and get to outcomes more seamlessly than she can. She's legendary within Meta for her canonical documents.

**中文翻译:**
我要读另一段你同事的评价，查尔斯·波奇（Charles Porch），他是 Instagram 全球合作伙伴副总裁。他基本上说了我们一直在聊的内容：Meta 做出的一些最大的战略赌注和重大举措都有 Naomi 掌舵。没人能比她更无缝地“赶猫”（指管理一群难以驾驭的人）、驱动清晰度并达成结果。她在 Meta 内部因其“权威文档”而极具传奇色彩。

---

### [01:00:33] Naomi Gleit

**English:**
Great.

**中文翻译:**
太棒了。

---

### [01:00:34] Lenny Rachitsky

**English:**
Maybe just following this thread a little bit further, what's the gnarliest project that you've worked on that would be a good example of you coming in and helping simplify and get it over the finish line?

**中文翻译:**
沿着这个思路再深入一点，你参与过的最棘手的项目是什么？能作为一个你介入并帮助简化、最终推向终点的绝佳例子吗？

---

### [01:00:47] Naomi Gleit

**English:**
Well, Charles may be thinking of the most recent project that we worked on. I don't know if it's necessarily the gnarliest, but it's definitely one of the most cross-functional projects that I've worked on before. Basically every team at the company in some way works on youth. And last week we actually launched teen accounts, which was a very complex project. Again, it involved the Instagram team, the central youth team, the different teams working on various aspects of this, every function, legal policy, comms, marketing product. And I think we definitely leveraged a lot of these Naomi-isms. And just to give you a sense of what teen accounts is, it was basically putting all teens into the safest settings by default on Instagram. And the reason I'm working on this, I work across multiple teams at Facebook, so obviously Adam is the head of Instagram and I work closely with him on this, like I was referring to yesterday. But this is something, these teen accounts, is something that we are thinking about how we expand to the other apps that we have, including Facebook and WhatsApp and Threads. And I tend to work on projects that are across our family of apps and future platforms, and that's why I was involved in this. But basically what teen accounts does is put teens in these safest settings. It's super focused on trying to address parents' biggest concerns around their teens on social media. This has obviously been a really big topic. We've had a lot of these features and tools. What this launch did is simplify things, standardize things, and add a lot more functionality that gives parents control. I think the thing you really need to know is that for under 16-year-olds, if they want to change any of these defaults, they're going to have to get their parents' permission. And so it's interesting that we're really going to create an incentive for teens to get their parents involved and to actually set up parental supervision, especially because one of the default settings is a private account. So there's tens of millions of teens that currently have public accounts today that we are going to automatically transition to private accounts unless they get their parents' permission to stay public. And so it's a relatively big shift, fundamental change for how Instagram works for teens, and I would say one of the more complicated projects that I've worked.

**中文翻译:**
查尔斯可能想的是我们最近合作的项目。我不确定它是否是最棘手的，但它绝对是我参与过的跨职能程度最高的项目之一。基本上公司里的每个团队都在某种程度上涉及青少年业务。上周我们刚刚推出了“青少年账户”，这是一个非常复杂的项目。它涉及 Instagram 团队、中央青少年团队、负责各个方面的不同团队，以及每个职能部门：法务、政策、公关、营销、产品。我想我们确实利用了很多“Naomi 主义”。简单介绍一下青少年账户：它基本上是将 Instagram 上的所有青少年默认置于最安全的设置中。我参与这个项目的原因是，我在 Facebook 负责跨多个团队的工作。亚当是 Instagram 的负责人，我在这方面与他紧密合作。青少年账户是我们正在考虑如何扩展到其他应用（包括 Facebook、WhatsApp 和 Threads）的功能。我倾向于负责跨应用家族和未来平台的项目，这就是我参与其中的原因。青少年账户的核心是将青少年置于最安全的设置中，专注于解决父母对青少年使用社交媒体的最大担忧。这显然是一个重大话题。我们以前有很多这类功能和工具，而这次发布的作用是简化、标准化，并增加了更多让父母拥有控制权的功能。你需要知道的是，对于 16 岁以下的用户，如果他们想更改任何默认设置，必须获得父母的许可。有趣的是，我们实际上在激励青少年让父母参与进来并设置家长监督，尤其是因为默认设置之一是私密账户。目前有数千万青少年拥有公开账户，我们将自动把他们转为私密账户，除非他们获得父母许可保持公开。这是一个相当大的转变，是 Instagram 对青少年运作方式的根本性改变，也是我参与过的最复杂的项目之一。

---

### [01:03:28] Lenny Rachitsky

**English:**
Yeah, and it just launched, right?

**中文翻译:**
是的，而且刚刚发布，对吧？

---

### [01:03:30] Naomi Gleit

**English:**
Yes.

**中文翻译:**
是的。

---

### [01:03:31] Lenny Rachitsky

**English:**
As a new father, I'm excited for you all to be working on these sorts of things. I don't need it yet, but I'm glad it's going to be there. And it's funny how Meta and Facebook is in this world where people complain about teens using social media and then you work on making the product better for teens and kids using social media, and then it's like, "Facebook's getting teens on social media." There's no way to make it feel good to people. No matter what you do, people are going to complain.

**中文翻译:**
作为一个新手父亲，我很高兴你们在做这类工作。我现在还用不上，但我很高兴它会在那里。有趣的是，Meta 和 Facebook 处在这样一个世界：人们抱怨青少年使用社交媒体，然后你们努力让产品对青少年更安全，接着又有人说“Facebook 在诱导青少年使用社交媒体”。无论你们做什么，总有人会抱怨，没法让所有人满意。

---

### [01:04:00] Naomi Gleit

**English:**
Totally. And I think the goal of this launch was to orient ourselves and really there's a lot of complaints, there's a lot of different voices. I think we just are focused on parents. We think parents know best. Every kid is different and parents know their own kid the best. So that has been our north star in terms of the approach here. When I talk about teen accounts, as product people I think one thing that you would appreciate is the thing that I think is really important when it comes to teens on the internet is really having an understanding of how old someone is when they're using our apps. And it's important that we know how old they are because then we can put them in an age-appropriate experience. So now we have teen accounts, we want to put all teens into teen accounts. We all know sometimes teens lie. That's been the biggest feedback that we've been getting is teens are really smart, they're going to find workarounds, they're going to be creative, they're going to lie about their age. And as a product person, the way that I think this should really work is that instead of everyone entering... Teens use, on average, 40 apps, instead of Instagram and the other 39 apps that teens use trying to verify the age of the person using their app is for two companies to do this, which is Apple and Google, they do collect the age, they should make that available to developers. And we ask for information from the device all the time with user consent, can Instagram have access to your camera, can Instagram have access to your location information? Apps should be able to ask, can Instagram have access to your birthday? And that would, I think, elegantly from a product perspective, from a simplification perspective, from a privacy preserving perspective and what's easiest for parents, that would be the right product solution to solve this problem around age that we're all trying to grapple with right now. And there's a lot of stuff that we're doing. Part of the reason that this project was so complicated, and I mentioned the age team, is we're building classifiers to try to predict how old people are based on not just the age that they've stated, but based on who they're talking to, what kind of content they're looking at, what the age of the people they're connected to is, do we think that this is actually an adult like they say, or is it really a teen. And so we're doing a lot to try to predict age or prevent people from lying about their age, but I think this would be a really big win for the industry.

**中文翻译:**
完全正确。我认为这次发布的目的是找准定位。虽然有很多抱怨和不同的声音，但我们专注于父母。我们认为父母最了解情况，每个孩子都不同，父母最了解自己的孩子。这就是我们处理这件事的“北极星”。当我谈到青少年账户时，作为产品人，我想你会认同的一点是：在互联网青少年保护方面，真正重要的是了解用户在使用应用时的真实年龄。知道他们的年龄很重要，因为这样我们才能提供适合其年龄的体验。现在我们有了青少年账户，我们想把所有青少年都放进去。但我们都知道青少年有时会撒谎。我们收到的最大反馈是：青少年很聪明，他们会找漏洞，会很有创意地谎报年龄。作为产品人，我认为真正的解决方案应该是：青少年平均使用 40 个应用，与其让 Instagram 和其他 39 个应用各自尝试验证用户年龄，不如让掌握年龄信息的两家公司——苹果和谷歌——向开发者开放这一信息。我们经常在征得用户同意的情况下请求设备信息，比如“Instagram 能访问你的摄像头吗？”、“能访问你的位置吗？”。应用也应该能问：“Instagram 能访问你的生日吗？” 从产品、简化、隐私保护以及对父母最便利的角度来看，这才是解决我们目前都在努力应对的年龄验证问题的优雅方案。我们目前也在做很多工作，这个项目之所以复杂（我提到了年龄团队），是因为我们在构建分类器，不仅根据用户自称的年龄，还根据他们的聊天对象、查看的内容、联系人的年龄来预测他们的真实年龄——判断这到底是一个自称成年的成年人，还是一个青少年。我们在预测年龄和防止谎报方面做了很多努力，但我认为（由系统级厂商提供年龄信息）对整个行业来说将是一个巨大的胜利。

---

### [01:06:31] Lenny Rachitsky

**English:**
Makes sense to me.

**中文翻译:**
对我来说很有道理。

---

### [01:06:33] Naomi Gleit

**English:**
Okay. Thank you, Lenny.

**中文翻译:**
好的，谢谢你，Lenny。

---

### [01:06:38] Lenny Rachitsky

**English:**
So to close out this portion in this chapter of our conversation on Naomi-isms, I know something else that you're really good at that I've heard from a few people is running meetings, something that a lot of people always want to get better at. Any tips? What have you learned about running a great meeting?

**中文翻译:**
为了结束关于“Naomi 主义”的这一章节，我知道你还非常擅长另一件事，那就是开会。这是很多人都想提高的技能。有什么建议吗？关于如何开好会，你学到了什么？

---

### [01:06:54] Naomi Gleit

**English:**
A meeting is a high value and it's high cost amount of time, and then I want to make sure it's as productive as possible. What I will do is send an agenda 24 hours prior to the meeting. That agenda will include a pre-read. I've talked to people who if the pre-read is not attached to the calendar invite or associated with a meeting at least 24 hours in advance, they will cancel the meeting. That just goes to show we want everybody in the meeting to have full context, have read the pre-read. Often what will happen in the previous 24 hours is because we're all sending pre-reads on Google Slides, there will be a lot of conversation and questions that get hashed out leading up to the meeting. During the meeting, like I said, I think it's really important for a group of people to be looking at something and anchoring people on something. If somebody joins the meeting, say, five minutes late, they should know exactly where in the agenda you are in the meeting and what is being discussed based on catching up from the visual that's being projected. Usually a meeting can be and hopefully a meeting is really either is a decision meeting. So if there is a decision, I need three options and I need a recommendation that should hopefully help focus the meeting. And then, like I said, I will real-time edit the visual such that we document and have extreme clarity on what is the option that we agreed on and any next steps that we also agreed to. After the meeting, anyone who wasn't in the meeting, that's fine because within 24 hours post-meeting I will send the notes, reply all to the meeting invite and send the notes. So just tactically, I use the calendar invite as the canonical unit by which to handle all of this communication because a lot of times meetings are one-offs, there isn't an existing email or chat thread that maps perfectly to the audience of the meeting, so for me that is the meeting or the calendar invite. So I'll click on the calendar invite, reply all, include the pre-read, pre-meeting, and then do this reply all again post-meeting 24 hours with the notes and the decisions and the next steps.

**中文翻译:**
会议具有高价值，但也耗费高昂的时间成本，所以我要确保它尽可能高效。我会做的是在会前 24 小时发送议程。议程中会包含“预读材料”（pre-read）。我认识一些人，如果预读材料没有在会前至少 24 小时附在日历邀请中，他们就会取消会议。这说明我们希望会上的每个人都有完整的背景信息，并读过预读材料。通常在会前的 24 小时内，因为我们用 Google Slides 发送预读材料，很多讨论和问题在开会前就已经解决了。在会议期间，正如我所说的，让一群人看着某个东西并以此为锚点非常重要。如果有人迟到 5 分钟，他们应该能通过投影的视觉画面立刻知道议程进行到了哪里，正在讨论什么。通常会议应该（也希望）是一个决策会议。如果有决策要做，我需要三个选项和一个建议，这有助于会议集中精力。然后，我会实时编辑视觉画面，记录并清晰地展示我们达成一致的选项以及后续步骤。会后，对于没参会的人，也没关系，因为在会后 24 小时内，我会点击日历邀请的“回复所有人”，发送会议纪要。从战术上讲，我把“日历邀请”作为处理所有这些沟通的“权威单元”，因为很多会议是临时性的，没有现成的邮件组或聊天群能完美匹配参会人员。所以我会在日历邀请中回复所有人，会前发预读，会后 24 小时内发纪要、决策和后续步骤。

---

### [01:09:11] Lenny Rachitsky

**English:**
I love this. So many very specific tactics here. I love it. This is food for my brain. I love the always have three options and a recommendation, that's such a simple thing to recommend, but such a powerful way of operating as a PM, just like, "Here are the options, here's what I recommend, here's why."

**中文翻译:**
我太喜欢这些了。这么多具体的战术。这是我大脑的养料。我喜欢“永远提供三个选项和一个建议”，这听起来很简单，但作为 PM，这是一种非常强大的运作方式：“这是选项，这是我的建议，这是原因。”

---

### [01:09:29] Naomi Gleit

**English:**
Oh, one thing I forgot that I learned from Guy Rosen, he is our chief security officer, is when you have three options and a recommendation, in terms of evaluating the options, I don't love pros and cons. It's a flat list of text. It's hard to just get the big picture from that. Oftentimes we'll use a traffic light. That means that the three options are three rows. The columns in the table will be criteria by which to evaluate the options. Those could either be functions. So for example, if I have three options as the rows, column one could be the legal perspective, column two could be the policy perspective, column three could be the privacy or product perspective. Alternatively, the columns could map to different criteria like what we're optimizing for. So it could be the user experience, it could be the engineering feasibility, it could be the internal complexity, whatever are the criteria should be laid out in the columns. And then obviously it should be color-coded, red, yellow, green based on how it stacks up against those criteria. And what this allows is to get back to the point of the visual is you can quickly look at the three options, see where's the most red, and rule that out. Ideally, the recommendation has some combination of the more green or yellow than the other options. And then obviously within these cells you can spell out the specific rationale for the coloring. But I think this is a really good way to run a meeting and just create extreme clarity around how you're evaluating the options in a way that a flat list of pros and cons just doesn't.

**中文翻译:**
噢，我忘了一件从我们的首席安全官盖伊·罗森（Guy Rosen）那里学到的事：当你提供三个选项和一个建议时，在评估选项方面，我不喜欢列“优缺点”（pros and cons）。那只是平铺的文字列表，很难从中获得全局观。通常我们会使用“红绿灯”表格。这意味着三个选项是三行，表格的列是评估选项的标准。这些标准可以是职能部门，比如：第一列是法务视角，第二列是政策视角，第三列是隐私或产品视角。或者，列可以对应不同的优化目标，比如：用户体验、工程可行性、内部复杂度。无论标准是什么，都列在列上。然后，根据选项在这些标准下的表现，用红、黄、绿进行颜色编码。这又回到了视觉化的好处：你可以快速扫一眼三个选项，看到哪里红最多，然后排除它。理想情况下，推荐的选项应该是绿或黄比其他选项多。显然，你可以在单元格内写下具体的着色理由。我认为这是开会并对评估过程建立极致清晰度的好方法，这是简单的优缺点列表做不到的。

---

### [01:11:12] Lenny Rachitsky

**English:**
What other podcasts would have this level of detail of how to run a discussion on a decision? And this is exactly what people want to hear, so I love it. So product market fit for listeners of this podcast. I love it. I love it. And obviously the reason this is more effective is it's not just like, "Here's a quick sentence on the pro and con." It's like, "Here's what I actually think this is good or bad for the things that matter to the business."

**中文翻译:**
还有哪个播客会有这种关于如何主持决策讨论的细节水平？这正是大家想听的，我太喜欢了。这简直是本播客听众的“产品市场契合点”。显然，这种方法更有效的原因在于，它不只是简单的一句优缺点，而是“这就是我认为它对业务关键事项的好坏影响”。

---

### [01:11:39] Naomi Gleit

**English:**
That's exactly right. It also gives people a framework to plug into. A lot of times the creation of a pre-read for these discussions involves many different people from many different teams and functions. If you have a traffic light, they can own filling out their cell, they can own the rationale behind the legal position on option one, two, and three. And, in general, I'm super into frameworks that allow people to plug into and clearly represent their point of view.

**中文翻译:**
完全正确。它还为人们提供了一个可以嵌入的框架。通常，准备这些讨论的预读材料涉及来自不同团队和职能的许多人。如果你有一个红绿灯表格，他们可以负责填写自己的单元格，负责解释法务对选项一、二、三的立场。总的来说，我非常喜欢那种能让人们嵌入并清晰表达观点的框架。

---

### [01:12:08] Lenny Rachitsky

**English:**
I love it. Final question, completely different topic. I saw a Wall Street Journal story about how you exercise and your exercise regimen, and how important that is to your life and career. Now, most people don't have a Wall Street Journal story about their exercise regimen, especially a tech worker. And I know this is just important to your work, and they wrote that this basically helps you become better at your job. Any advice there for folks that want to lean into exercise, exercise more for how to actually do that? Because your advice is this actually makes you better at work and life.

**中文翻译:**
太棒了。最后一个问题，换个完全不同的转题。我看到《华尔街日报》报道了你的健身方式和健身计划，以及它对你的生活和事业有多重要。大多数人，尤其是科技工作者，不会因为健身计划上《华尔街日报》。我知道这对你的工作很重要，报道说这基本上能帮你把工作做得更好。对于那些想加强锻炼、多运动的人，你有什么建议吗？因为你的观点是，这实际上能让你在工作和生活中表现得更好。

---

### [01:12:44] Naomi Gleit

**English:**
People are always like, "What are you training for?" And I'm like, "I'm training for life." I have four musties, it is eat, sleep a long time, and exercise. Those are the things that I need in order to perform. And the other areas of my life seems pretty obvious, but until recently I actually did not prioritize sleep. My boyfriend is actually super into sleep and we have the Eight Sleep, we have eye masks, we have blackout shades, we have good sleep hygiene, and so I'm getting much better at that. But exercise is something that I've always been on top of. Alone time is also a musty for me because I'm an introvert, I need that time to recharge, otherwise I think I get weird around people. In terms of how I prioritize it, it's a non-negotiable or table stakes, every morning I have to work out. I am also lucky enough to work in an environment where I can wear workout clothes to work, which I often do. I think working out is sure the hour of the day that I'm doing my exercise, but I also view, like I said, life is a workout, performing at work is a workout. I need to be able to move. I need to feel comfortable. It's very physical, I think, especially if you're trying really hard to be a conductor, and I'm running around with a metaphorical conductor wand, I need to be able to move. A while ago, and that's what the Wall Street Journal article was about, I set a goal of doing five pull-ups. I'd read somewhere in an article that less than 1% of women can actually do. I think having a goal is really helpful. That's something that I worked on, and anyone can do this truly if you train for it. I think it's potentially more technique for me than strength per se, and I worked up towards that goal. I think exercise, in addition to all of the physical benefits, primarily has a mental health benefit I think for me. And also there are just a lot of lessons that I think I take from exercise. For example, I think being able to do five pull-ups taught me I can do hard things in this really narrow, measurable way, which gave me confidence in other aspects of my life.

**中文翻译:**
人们总是问：“你在为什么而训练？” 我回答：“我在为生活而训练。” 我有四个“必须项”（musties）：饮食、充足的睡眠、独处时间和锻炼。这些是我保持状态所需的。生活中的其他领域似乎很显而易见，但直到最近我才真正开始重视睡眠。我男朋友非常注重睡眠，我们有 Eight Sleep（智能床垫）、眼罩、遮光帘，我们有良好的睡眠卫生习惯，所以我现在做得好多了。但锻炼是我一直坚持的。独处时间对我来说也是必须的，因为我是个内向的人，我需要时间充电，否则我觉得我在人群中会变得很奇怪。至于我如何安排优先级，那是不可商量的“入场券”：每天早上我必须锻炼。我也很幸运能在可以穿运动服上班的环境中工作，我经常这么穿。我认为锻炼不仅是每天那一小时的运动，我也把生活看作一场锻炼，在工作中表现也是一场锻炼。我需要能够活动，需要感到舒适。我认为这非常具有体力挑战，尤其是当你努力想成为一名“指挥家”，挥舞着隐形的指挥棒跑来跑去时，你需要能动起来。不久前（这也是《华尔街日报》报道的内容），我设定了一个做 5 个引体向上的目标。我在某篇文章中读到，只有不到 1% 的女性能做到。我认为设定目标非常有帮助。我为此付出了努力，只要经过训练，任何人都能做到。对我来说，这可能更多是技巧而非纯粹的力量，我朝着那个目标努力。我认为锻炼除了身体上的好处，对我来说主要是心理健康方面的益处。此外，我从锻炼中学到了很多。例如，能做 5 个引体向上教会了我：我可以用这种非常具体、可衡量的方式去完成艰巨的任务，这增强了我处理生活其他方面的信心。

---

### [01:15:01] Lenny Rachitsky

**English:**
I had a friend who her goal was do one push-up. She's like, "I want to be able to do one push-up" and that was really motivating to her. And then she finally got there and then she could do more.

**中文翻译:**
我有一个朋友，她的目标是做一个俯卧撑。她说：“我想能做一个俯卧撑”，这非常激励她。最终她做到了，然后她就能做更多了。

---

### [01:15:12] Naomi Gleit

**English:**
That's awesome.

**中文翻译:**
太棒了。

---

### [01:15:13] Lenny Rachitsky

**English:**
Yeah, similar. I have so many notes here as that you were talking. The other is sleep advice. So eye mask. I have an awesome eye mask that I'll recommend in the show notes. It's funny. What is that? Of all the things I've recommended in all the various places I get the most comments about, "Thank you for this very specific eye mask. It changed my life." It's like WAOAW, it's one Tim Ferriss has often recommended.

**中文翻译:**
是的，很类似。你说话时我记了很多笔记。另一个是睡眠建议。关于眼罩，我有一个超赞的眼罩，我会放在节目介绍里。很有趣，在我推荐过的所有东西中，收到反馈最多的是：“谢谢你推荐这个具体的眼罩，它改变了我的生活。” 它的牌子叫 WAOAW，是蒂姆·费里斯（Tim Ferriss）经常推荐的那款。

---

### [01:15:36] Naomi Gleit

**English:**
Okay.

**中文翻译:**
好的。

---

### [01:15:37] Lenny Rachitsky

**English:**
W-A-O... I'll link to it in the show notes, but it's WAOAW, let me look it up real quick 'cause people are going to be like, "Oh, I got to get it." WAOAW eye mask.

**中文翻译:**
W-A-O……我会链接在介绍里，叫 WAOAW。我查一下，因为大家肯定会想：“噢，我也得买一个。” WAOAW 眼罩。

---

### [01:15:46] Naomi Gleit

**English:**
The one that we have has cushions around the eyes such that it's not flush against your eyes.

**中文翻译:**
我们用的那种在眼睛周围有垫子，所以它不会紧贴着眼球。

---

### [01:15:54] Lenny Rachitsky

**English:**
Yeah, this is the same. Okay.

**中文翻译:**
是的，这款也是。好的。

---

### [01:15:55] Naomi Gleit

**English:**
Oh great.

**中文翻译:**
噢，太好了。

---

### [01:15:58] Lenny Rachitsky

**English:**
W-A-O-A-W sleep mask on Amazon. It's 13 bucks and amazing. My wife and I both sleep with these eye masks. It's ridiculous until you're like, "I can't sleep without one now."

**中文翻译:**
亚马逊上的 W-A-O-A-W 睡眠眼罩。13 美元，效果惊人。我和我妻子都戴这个眼罩睡觉。这听起来很滑稽，直到你发现：“我现在没它睡不着了。”

---

### [01:16:10] Naomi Gleit

**English:**
Totally. Well there's a lot of research that even ambient lighting results in lower quality sleep. So I think that's why the blackout shades and the eye mask just help ensure it's truly dark.

**中文翻译:**
完全正确。有很多研究表明，即使是微弱的环境光也会降低睡眠质量。所以遮光帘和眼罩能确保环境真正黑暗。

---

### [01:16:20] Lenny Rachitsky

**English:**
Yeah, I was just watching a podcast and the advice there is even your smoke alarm with a little light is too much light. You need to cover that up to create real darkness and why not just wear an eye mask? You don't have to worry about any of that.

**中文翻译:**
是的，我刚看了一个播客，建议说甚至烟雾报警器上的小灯都太亮了。你需要把它盖住来创造真正的黑暗。那为什么不直接戴个眼罩呢？这样你就不用担心那些了。

---

### [01:16:35] Naomi Gleit

**English:**
Totally.

**中文翻译:**
完全正确。

---

### [01:16:36] Lenny Rachitsky

**English:**
Okay, and then one thing I didn't mention when you're talking about the conductor, the PM as a conductor, that's exactly the metaphor I've always used my entire career when people ask me about what is product manager? So we're alike.

**中文翻译:**
好的。还有一件事我刚才没提，当你谈到“指挥家”——PM 即指挥家时，那正是我整个职业生涯中，当人们问我“什么是产品经理”时一直使用的比喻。所以我们志同道合。

---

### [01:16:46] Naomi Gleit

**English:**
Really?

**中文翻译:**
真的吗？

---

### [01:16:47] Lenny Rachitsky

**English:**
Yeah, I have all these slides of here's the PM and it's like a symphony and the conductor standing there.

**中文翻译:**
是的，我有很多幻灯片，上面写着“这就是 PM”，画面是一个交响乐团，指挥家站在那里。

---

### [01:16:52] Naomi Gleit

**English:**
Lenny, do you know how happy that makes me? Because I feel like sometimes people are like, "That sounds crazy," but the fact that you actually came to that same conclusion makes me... Why did you come to that conclusion? I'm just curious.

**中文翻译:**
Lenny，你知道这让我多开心吗？因为我觉得有时人们会说：“这听起来太疯狂了。” 但你居然得出了同样的结论，这让我……我很想知道，你为什么会得出这个结论？

---

### [01:17:09] Lenny Rachitsky

**English:**
Because as you said, the PM's not making the thing. They're just helping each of the people who are the most talented at their very specific skill do the best possible work and their back is to the audience. They're trying to stay out of the way even though they come in, everyone claps for them, the outstanding event, and then in theory they could step in a little bit to help out when they can pinch it on design here and there and research here and there, probably not engineering. So those are the reasons and they're not in charge. The chair wind violinist is the actual person that's making the music and the best at this thing.

**中文翻译:**
因为正如你所说的，PM 并不直接制造产品。他们只是在帮助那些在特定技能上最有才华的人发挥出最佳水平。他们的背对着观众。他们努力不挡路，尽管他们入场时大家会为他们鼓掌。理论上，他们可以在需要时介入帮忙，比如在设计或研究上搭把手，但工程方面可能不行。所以这就是原因，而且他们并不是“长官”。首席小提琴手才是真正演奏音乐、且在该领域最顶尖的人。

---

### [01:17:48] Naomi Gleit

**English:**
It's so great to hear somebody else talk about this too. Thank you. And I think that that is really how I view my role and what I do and I think maybe just hearing you talk about it reminded me why I think I put so much emphasis on just elevating the people on my team and the people around me and candidly, one of the development areas for me, and it could be downstream because I do have this analogy of how to be a PM, is that the growth feedback or the constructive feedback for me is really learning when to lead from the front more. Maybe when to be less of a quiet conductor that's really elevating the first chair violinist and be more front facing. I think a lot of my approach and my leadership style is really leading through the people on my team and helping grow them. And a lot of times I think that they're dedicated, they're experts, they know particular areas. Obviously as a head of product, I manage a portfolio of different projects of which each of them has the incredible leader on it. And so oftentimes I'm just really trying to lead from behind and help them be as successful as possible. But there is a time and a place when maybe that silent conductor needs to take more of a vocal and front facing role.

**中文翻译:**
听到别人也这么说真是太好了。谢谢。这确实是我看待自己角色和工作的方式。听你这么说提醒了我，为什么我如此强调提升团队成员和周围的人。坦率地说，我的一个发展领域（这可能是因为我一直秉持这个 PM 比喻）是：我收到的建设性反馈是，要学会何时更多地从“前线”领导。也许有时不该做一个只顾着提升首席小提琴手的安静指挥家，而应该更具前瞻性。我认为我的很多方法和领导风格是通过团队成员来领导并帮助他们成长。很多时候，他们非常敬业，是专家，了解特定领域。作为产品负责人，我管理着一系列不同的项目，每个项目都有出色的领导者。所以我经常尝试“从后方领导”，帮助他们尽可能成功。但在某些时间和场合，这位沉默的指挥家可能需要扮演更具发声性和前瞻性的角色。

---

### [01:19:16] Lenny Rachitsky

**English:**
I know exactly what you mean. I had the same problem when I was a PM because there's always this fear that PMs in charge and telling everyone to do. And so I had the opposite of like, "Okay, and that's not me. I'm going to just let you do the things you think are best and I'll just make sure the best ideas come to the surface," and I have to learn exactly the same thing. Sometimes people just want you to point them in the right direction and make the decision in the end. And the best PMs are people that have the best opinions about what is going to work, how intuition of what users need, have strong product sense and all that stuff. I've had this post that I'm trying to work on along these lines where there's this reaction to PMs aren't the CEO of the product. They're just like... No, don't call yourselves that. I think it's the opposite. I think PMs actually should think of themselves as the CEO of the product, not in terms of they are in charge and can fire people and manage people, but they're the closest heuristic for what the CEO and the founder wants. They think of what does the business need, what is going to help the customers, what's going to help us grow? And I think the PM is the closest to that role and so I think it's important to think of that role as that even though you're not technically in charge.

**中文翻译:**
我完全明白你的意思。我当 PM 时也有同样的问题，因为总担心 PM 会被看作是发号施令的人。所以我走向了反面：“好吧，那不是我。我会让你们做你们认为最好的事，我只负责确保最好的想法浮出水面。” 我也必须学习同样的事情：有时人们只是希望你指明方向并在最后做出决定。最好的 PM 是那些对什么行之有效有独到见解、对用户需求有直觉、有强大产品感的人。我一直在写一篇相关的文章，讨论“PM 不是产品的 CEO”这种观点。很多人说：“不，别这么称呼自己。” 我觉得恰恰相反。我认为 PM 确实应该把自己看作产品的 CEO——不是说他们有权开除人或管理行政，而是说他们是 CEO 和创始人意图的最接近的启发式代表。他们思考业务需要什么、什么能帮助客户、什么能帮助我们增长。我认为 PM 是最接近那个角色的人，所以即使你技术上并不管人，把自己看作那个角色也很重要。

---

### [01:20:25] Naomi Gleit

**English:**
And maybe you could call it something different, but I totally agree with that sentiment. I think we were trying to push against the criticism that PMs were bossing everybody around, but actually I think you- There's baggage there. I call it, there's something called the great non-technical. There was a period of time at Facebook where I think the PMs really had to prove their value to the engineers and show that we were not slowing things down with all this extra process. You can imagine an engineer hearing me talk about how to run a meeting and all the canonical docs and just be like, "What? This sounds terrible." So yeah, we had to prove that, but I actually do think the PM is the closest to really channeling what the CEO or the founder wants. Another thing that I've worked on and that I'm working on is really developing a much stronger first-party perspective. It's not enough for the PM to run this people in process that we talked about. Obviously I love that stuff. I lean that way, but at the end of the day, a PM cannot outsource their perspective or delegate their thinking through people and process. And so for me that has been a learning curve and I am trying to, as someone who's very consensus driven, I want to hear all the different opinions from all the different people. I can still do that. I can still through people in process talk to all the different folks working on a project, hear their first party perspectives and then use all of that to synthesize my own because it will be unique given my role on the team and just what I'm trying to optimize for and really make sure that I both develop that first-party opinion and communicate it clearly. And like you said, the best PMs I think can do it all.

**中文翻译:**
也许可以换个称呼，但我完全同意这种观点。我想我们之前是想反驳“PM 对每个人颐指气使”的批评，但实际上……这其中有历史包袱。我称之为“伟大的非技术挑战”。在 Facebook 有一段时间，PM 必须向工程师证明自己的价值，证明我们没有用这些额外的流程拖慢进度。你可以想象一个工程师听到我谈论如何开会和权威文档时，会想：“什么？这听起来太糟糕了。” 所以我们必须证明自己。但我确实认为 PM 是最能传达 CEO 或创始人意图的人。我一直在努力的另一件事是培养更强大的“第一方视角”（first-party perspective）。PM 仅仅管理我们谈到的人员和流程是不够的。显然我喜欢那些东西，我也倾向于那样做，但归根结底，PM 不能把自己的观点“外包”出去，也不能通过人员和流程来委托思考。对我来说，这是一个学习曲线。作为一个非常注重共识的人，我想听取所有人的不同意见。我仍然可以这样做，通过人员和流程与项目中的所有人交谈，听取他们的第一方视角，然后利用所有这些信息来综合我自己的观点——因为考虑到我在团队中的角色和我的优化目标，我的观点将是独特的。我要确保自己既能形成这种第一方见解，又能清晰地传达它。正如你所说的，我认为最好的 PM 能兼顾这一切。

---

### [01:22:27] Lenny Rachitsky

**English:**
Just to follow this thread, one thread further, because this is something I think a lot of product managers work on and are told to work on, is there anything you've found to be helpful in building this skill in yourself that might be helpful to folks that are working on it?

**中文翻译:**
沿着这个思路再深入一点，因为这是很多产品经理都在努力、也被告知要努力的方向。你发现有什么方法能帮助自己建立这种技能，且对其他人也有参考价值吗？

---

### [01:22:39] Naomi Gleit

**English:**
I'm lucky enough because I have a big team. I have someone who helps me schedule my time and I used to goal that person and goal our work together on just being as efficient as possible. But now what I am goaling that person and what we're trying to accomplish here is giving me as much time to develop a first-party point of view. And so what is the most effective way to do that? And for me it is having two to three hour blocks of time where I can actually sit, think, have space, but maybe something that's different about me than other people is its very, very helpful for me to talk to maybe one or two people, not be in a big meeting with 40 people, trusted people. I have an incredible person on my team that I talk to that I think really helps me clarify my thinking. And so to go back to the beginning, just I'm trying to find blocks in my day that I can spend time thinking and also within those blocks, they don't have to be alone time. They can also be scheduling my chief of staff and my head of data to bounce ideas off of as a sounding board because that is the process that I know best for me in terms of really developing a first party perspective.

**中文翻译:**
我很幸运，因为我有一个庞大的团队。有人帮我安排时间，我以前给那个人的目标是让我们尽可能高效。但现在我给那个人的目标是：给我留出尽可能多的时间来形成“第一方观点”。那么最有效的方法是什么？对我来说，是拥有 2 到 3 小时的整块时间，让我能坐下来思考，拥有空间。但也许我与别人不同的一点是，与一两个信任的人交谈对我非常有帮助，而不是参加 40 人的大组会。我团队中有一个非常出色的人，我经常和他交流，这能帮我理清思路。所以回到最初，我正努力在日程中寻找可以用来思考的时间块，而且在这些时间块里，不一定非得是独处，也可以是安排我的幕僚长（Chief of Staff）或数据负责人作为“传声筒”来碰撞想法，因为这是我形成第一方视角最有效的方式。

---

### [01:23:59] Lenny Rachitsky

**English:**
Such a good tip. It makes sense if you're just spending all your day coordinating in meetings, checking things, reviewing things, you have no time to actually think about what you think is the right move and answer and strategy and next step. And so that's a really good tip. If you're finding that you don't have time to think about what you think is the right solution and the right strategy and the right product decision, fine, just block time to think about this stuff. I have these deep work slots in my calendar. I've written about this a few times where it's three hours and the invite, I don't know if you can do this these days, but it was just, if you book time during the slot, I will slap you. Nobody did.

**中文翻译:**
非常好的建议。如果你整天都在会议中协调、检查、评审，你确实没有时间去思考你认为正确的举措、答案、战略和下一步。所以这是一个很好的技巧。如果你发现自己没时间思考正确的解决方案和产品决策，那就强行留出时间。我的日历上有“深度工作”时段。我写过几次，那是 3 小时的时段，邀请函上写着（不知道现在还能不能这么干）：“如果你在这个时段约我，我会扇你。” 结果没人敢约。

---

### [01:24:42] Naomi Gleit

**English:**
That's amazing. And I think for me, some people might need three hours on their own. I think for me, and I don't know about you, talking things through with one or two people really helps me as well. So sometimes it was almost quite challenging for me to think of going into a room by myself for three hours and then I was just going to figure it out on my own. This is like, and I don't know how people help people think strategically the best, but it doesn't have to necessarily be alone.

**中文翻译:**
太棒了。对我来说，有些人可能需要独自待 3 小时，但我（不知道你是不是也这样）发现与一两个人把事情谈透也很有帮助。所以有时让我一个人进房间待 3 小时自己想出办法，反而挺有挑战性的。我不知道别人是怎么进行战略思考的，但不一定非得独自一人。

---

### [01:25:16] Lenny Rachitsky

**English:**
That's a great tip. Just have a sparring partner.

**中文翻译:**
好建议，找个“陪练伙伴”。

---

### [01:25:17] Naomi Gleit

**English:**
Yes.

**中文翻译:**
是的。

---

### [01:25:17] Lenny Rachitsky

**English:**
Someone who is just interested in exploring ideas and not just have a clear agenda. I love that. Okay, Naomi, I love this tangent we went on as we were wrapping up. That was amazing. There was a lot of good stuff that we covered there, but I know you have to run. So before we get to our very exciting lightning round, is there anything else that we haven't covered that you wanted to cover or share?

**中文翻译:**
找一个对探索想法感兴趣、而不仅仅是执行议程的人。我喜欢这个。好了，Naomi，我很喜欢我们在收尾阶段进行的这段题外话。非常精彩。我们涵盖了很多好东西，但我知道你得走了。在进入令人兴奋的闪电轮环节之前，还有什么我们没聊到、但你想分享的吗？

---

### [01:25:42] Naomi Gleit

**English:**
Honestly, I think I just did it. I didn't even realize I wanted to talk about that, but it just all came out.

**中文翻译:**
老实说，我觉得我刚才已经分享完了。我甚至没意识到我想聊那个，但它就这么自然而然地流露出来了。

---

### [01:25:47] Lenny Rachitsky

**English:**
I love it. I love that. Those are the best nuggets. With that, we've reached our very exciting lightning round. Are you ready?

**中文翻译:**
我喜欢这种感觉，这些是最珍贵的干货。那么，我们进入闪电轮环节。准备好了吗？

---

### [01:25:54] Naomi Gleit

**English:**
I'm ready.

**中文翻译:**
准备好了。

---

### [01:25:55] Lenny Rachitsky

**English:**
First question, what are two or three books that you've recommended most to other people?

**中文翻译:**
第一个问题：你向别人推荐最多的两三本书是什么？

---

### [01:25:59] Naomi Gleit

**English:**
I really love narrative nonfiction, so I like the Eric Larson books. They're a very compelling and page turning way to learn about history. I recently read Devil in the White City and there was also one about Churchill's first year by Eric Larson. Another book that just the canonical book that I often recommend is Sapiens. I think he's a great example of what we talk about when we talk about simplifiers. He took a very complex subject, which is all of human history and tried to pull out the nuggets. I think his thesis that what differentiates humans from other forms of life is really our ability to tell and believe in myths or stories, and he cites money and religion as examples, but also there's a graphic novel version of Sapiens and so he almost has the PhD level and then he literally has the high school level, which is a graphic novel version. He also has Unstoppable Us, which I think is a kid's version, and so clearly here is someone who is a master. There's a James Clear thing that a friend, Shirley, told me about where it's like if you're a beginner, you have ignorant simplicity and intermediate has functional complexity, and then a master of a topic has profound simplicity. And that's what I feel like Noah Yuval Harari really has because he can go all the way up and down this cool pyramid in terms of explaining this really complex topic.

**中文翻译:**
我非常喜欢叙事类非虚构作品，所以我喜欢埃里克·拉森（Erik Larson）的书。它们是以一种非常引人入胜、让人欲罢不能的方式学习历史。我最近读了《白城恶魔》（Devil in the White City），还有一本拉森写的关于丘吉尔第一年的书。另一本我经常推荐的“权威”书籍是《人类简史》（Sapiens）。我认为作者是“简化者”的绝佳例子。他把人类历史这个极其复杂的主题提炼出了核心。他认为人类区别于其他生命形式的能力在于讲述并相信神话或故事，他以金钱和宗教为例。而且《人类简史》还有漫画版，所以他既有“博士水平”的版本，也有“高中水平”的漫画版。他还有《永不停止的我们》（Unstoppable Us），那是儿童版。显然他是一位大师。我朋友 Shirley 告诉我詹姆斯·克利尔（James Clear）的一段话：初学者拥有“无知的简单”，中级者拥有“功能性的复杂”，而大师则拥有“深刻的简单”。我觉得尤瓦尔·赫拉利就拥有这种深刻的简单，因为他在解释复杂主题时能贯穿整个“学校金字塔”。

---

### [01:27:31] Lenny Rachitsky

**English:**
What I heard about him is that he goes on a one-month meditation retreat every year where it's just him silent meditation retreat, and people ask him, "How do you have time to do that when you have so much work to do?" He's like, "The only way I'm able to achieve these books where I synthesize all of human history into a story is because I do that. Because I can clear my mind and just be."

**中文翻译:**
我听说他每年都会进行为期一个月的冥想静修，只有他一个人。人们问他：“你工作那么多，哪来的时间？” 他回答：“我之所以能写出这些将人类历史综合成故事的书，唯一的原因就是我做了这件事。因为我可以清空大脑，只是存在着。”

---

### [01:27:53] Naomi Gleit

**English:**
And Lenny, to our previous conversation, that is how he himself is best. That's what he needs to do. I might need two to three hours a day and a sparring partner, Noah Yuval Harari needs a month in silent meditation.

**中文翻译:**
Lenny，回到我们之前的对话，这就是他发挥最佳状态的方式。那是他需要的。我可能每天需要 2 到 3 小时和一个陪练伙伴，而尤瓦尔·赫拉利需要一个月的静默冥想。

---

### [01:28:07] Lenny Rachitsky

**English:**
Great point. Everyone has their own way of unlocking their brain. On Devil in the White City, a fun fact. When I read that, I was like, "I need to go to Chicago and see the stuff that they wrote about in this book about the World's Fair." And so I went to Chicago and-

**中文翻译:**
好观点。每个人都有开启大脑的不同方式。关于《白城恶魔》，有个趣闻：我读完后觉得“我必须去芝加哥看看书里写的世博会遗址”。于是我真的去了芝加哥……

---

### [01:28:21] Naomi Gleit

**English:**
You did?

**中文翻译:**
你真的去了？

---

### [01:28:22] Lenny Rachitsky

**English:**
Because of that book, yes.

**中文翻译:**
是的，就因为那本书。

---

### [01:28:25] Naomi Gleit

**English:**
Wow. Have you read the Splendid in the Vile?

**中文翻译:**
哇。你读过《辉煌与邪恶》（The Splendid and the Vile）吗？

---

### [01:28:28] Lenny Rachitsky

**English:**
Yes. That was the-

**中文翻译:**
读过，那是……

---

### [01:28:29] Naomi Gleit

**English:**
Churchill.

**中文翻译:**
关于丘吉尔的。

---

### [01:28:29] Lenny Rachitsky

**English:**
About the Telegram, right? Yeah. Right?

**中文翻译:**
关于电报的，对吧？

---

### [01:28:32] Naomi Gleit

**English:**
Oh, no, it was was Churchill's first year, but he has like six books. I haven't read all of them.

**中文翻译:**
噢不，是关于丘吉尔的第一年。拉森大概写了六本书，我没全部读完。

---

### [01:28:37] Lenny Rachitsky

**English:**
Okay. I think it was either that one or it was something about a telegram. I did read... It was less good though, is was what I find. I found the Devil in White City was-

**中文翻译:**
好吧。我读过……但我觉得没那么好。我觉得《白城恶魔》是……

---

### [01:28:43] Naomi Gleit

**English:**
The best.

**中文翻译:**
最棒的。

---

### [01:28:44] Lenny Rachitsky

**English:**
Was the best. Amazing. Okay, we'll keep going. Second question, do you have a favorite movie or TV show you've recently watched that you really enjoyed?

**中文翻译:**
是最棒的。太赞了。好的，继续。第二个问题：你最近看过的非常喜欢的电影或电视节目是什么？

---

### [01:28:52] Naomi Gleit

**English:**
We just watched Shogun. I thought it was really good. Have you seen it?

**中文翻译:**
我们刚看了《幕府将军》（Shogun）。我觉得非常棒。你看过吗？

---

### [01:28:57] Lenny Rachitsky

**English:**
I have, yes. I loved it. Very gruesome but amazing.

**中文翻译:**
看过，我很喜欢。虽然很血腥，但非常精彩。

---

### [01:29:01] Naomi Gleit

**English:**
Yeah. I was. I had to cover my eyes for some of it. And then we also, the movie that we just watched was Dune Two. Chris Cox, who's our chief product officer, actually recommended that as one of the best films that he's seen recently, and I really trust his opinion on that. So we caught up by watching Dune One and then watched Dune Two, and it was really good.

**中文翻译:**
是的，有些镜头我不得不捂住眼睛。我们最近还看了《沙丘 2》。我们的首席产品官克里斯·考克斯（Chris Cox）推荐说这是他最近看过的最好的电影之一，我非常信任他的眼光。所以我们补了《沙丘 1》，然后看了《沙丘 2》，真的很棒。

---

### [01:29:21] Lenny Rachitsky

**English:**
I watched that in IMAX Theater in San Francisco, this insanely large screen and highly would recommend that. I don't think it's still out there. Yeah. [inaudible 01:29:30] ridiculous. Amazing. I think there's another one coming someday.

**中文翻译:**
我是在旧金山的 IMAX 影院看的，那个超大屏幕，强烈推荐。我想现在应该下映了。太震撼了。我想以后还会有第三部。

---

### [01:29:34] Naomi Gleit

**English:**
Oh yeah, yeah. Dune Three.

**中文翻译:**
噢是的，《沙丘 3》。

---

### [01:29:36] Lenny Rachitsky

**English:**
Dune Three. Just keep them coming. Next question. Do you have a favorite product you recently discovered that you really love?

**中文翻译:**
《沙丘 3》，拍下去就对了。下一个问题：你最近发现并非常喜欢的某个产品是什么？

---

### [01:29:46] Naomi Gleit

**English:**
Well, I'm going to check out that eye mask thing that you recommended, the WAOAW thing.

**中文翻译:**
嗯，我会去试试你推荐的那个 WAOAW 眼罩。

---

### [01:29:49] Lenny Rachitsky

**English:**
That's it.

**中文翻译:**
就是那个。

---

### [01:29:51] Naomi Gleit

**English:**
I know it's super expensive, but have you tried the Eight Sleep?

**中文翻译:**
我知道它超级贵，但你试过 Eight Sleep 吗？

---

### [01:29:56] Lenny Rachitsky

**English:**
I have. My wife doesn't love it. She doesn't like the noise. It's like a very slight noise when it starts up, but it wakes her up, so we don't have it anymore.

**中文翻译:**
试过。我妻子不喜欢，她受不了那个噪音。启动时有一点点声音，但会吵醒她，所以我们现在不用了。

---

### [01:30:07] Naomi Gleit

**English:**
And I noticed that too. I think maybe they just released the latest edition. One of the features that is the killer feature for me is that it does a vibrating alarm so that when I wake up at 6:00 A.M., I do not wake up everyone in the house at 6:00 A.M., and so it's a thermal alarm. It makes the bed on my side hotter and it also slightly vibrates underneath my ear to wake me up.

**中文翻译:**
我也注意到了。我想他们可能刚出了最新版。对我来说，它的“杀手级功能”是震动闹钟。这样当我早上 6 点起床时，不会吵醒全家。它是一个热感闹钟，会让我的那一侧床垫变热，并在我耳下轻微震动来唤醒我。

---

### [01:30:32] Lenny Rachitsky

**English:**
It's under your ear. I remember vibrating my whole part of the bed. I wonder if that's a new feature.

**中文翻译:**
在耳朵下面？我记得以前是震动整个半边床。不知道是不是新功能。

---

### [01:30:37] Naomi Gleit

**English:**
Maybe this is like... I'm on version three, maybe there's a version four. I don't know. Maybe that was version one.

**中文翻译:**
也许吧……我用的是第三版，可能有第四版了。也许你用的是第一版。

---

### [01:30:43] Lenny Rachitsky

**English:**
Yeah, that's so funny. A nice thing about my life right now is that because I have no meetings or boss, I don't need an alarm.

**中文翻译:**
哈哈，太逗了。我现在生活的一大乐事是，因为没有会议也没有老板，我不需要闹钟。

---

### [01:30:52] Naomi Gleit

**English:**
That's awesome.

**中文翻译:**
那太棒了。

---

### [01:30:53] Lenny Rachitsky

**English:**
However, it's amazing. However, we have a young kid and he wakes up at 6:00 to 6:30, so that's my alarm usually.

**中文翻译:**
不过，虽然很棒，但我们有个小孩，他通常 6 点到 6 点半醒，所以他就是我的闹钟。

---

### [01:30:58] Naomi Gleit

**English:**
Oh, and then the other thing I wanted to mention, I don't know if you have this problem, but I'm trying to get a hundred grams of protein every day. I think a lot of my friends and I are focused on protein consumption right now, and so my trainer who helped me actually do the pull-ups and the push-ups started a protein products company called Promix that I really love, and he has this Rice Krispie treat thing that I usually eat every morning and gives me 15 grams of protein.

**中文翻译:**
噢，还有一件事我想提。我不知道你有没有这个问题，但我正努力每天摄入 100 克蛋白质。我和很多朋友现在都非常关注蛋白质摄入。帮我练引体向上和俯卧撑的教练开了一家叫 Promix 的蛋白质产品公司，我非常喜欢。他有一种类似“脆米饼”（Rice Krispie treat）的东西，我每天早上都吃，能提供 15 克蛋白质。

---

### [01:31:30] Lenny Rachitsky

**English:**
I just bought that.

**中文翻译:**
我刚买了那个。

---

### [01:31:32] Naomi Gleit

**English:**
What?

**中文翻译:**
什么？

---

### [01:31:33] Lenny Rachitsky

**English:**
Yes, I was reading, Kevin Rose had his favorite, his health stack, and I don't know if that's the brand, but it's exactly a Rice Krispie thing with 15 grams of protein. So I'm pretty sure that's it.

**中文翻译:**
是的，我读到凯文·罗斯（Kevin Rose）分享他的健康清单，我不确定是不是那个牌子，但确实是含 15 克蛋白质的脆米饼。所以我敢肯定就是它。

---

### [01:31:45] Naomi Gleit

**English:**
I'm pretty sure that's it, because the Rice Krispie part of it is very unique, so let me know what you think. I really like the chocolate chip flavor.

**中文翻译:**
我敢肯定就是它，因为脆米饼这种形式很独特。告诉我你的评价，我很喜欢巧克力片口味。

---

### [01:31:52] Lenny Rachitsky

**English:**
I hate them and I love them, so that's a really good tip. I just saw a funny TikTok where it's like I never thought when I'd grow up in be an adult, I'd be thinking so often about protein and how much protein I should be eating.

**中文翻译:**
我对它们又爱又恨。这是一个很好的建议。我刚看了一个有趣的 TikTok，大意是：“我从未想过长大成人后，我会如此频繁地思考蛋白质以及我该吃多少蛋白质。”

---

### [01:32:05] Naomi Gleit

**English:**
Maybe this is 40, I don't know. I'm not sure for me, but yes, I've been thinking a lot about protein. The other thing I really like is canned seafood, which has a lot of protein. So something called Fish Wife has, it's just Hipster, like Chicken of the Sea.

**中文翻译:**
也许这就是 40 岁后的生活吧，我不知道。但我确实在思考蛋白质。另一件我喜欢的东西是海鲜罐头，蛋白质含量很高。有一个叫 Fish Wife 的牌子，很时髦，就像是“文青版”的 Chicken of the Sea。

---

### [01:32:23] Lenny Rachitsky

**English:**
Oh yeah, they're very cute. Yes. My wife gets those. Another protein tip, they were a former sponsor, but no longer, but it's an amazing protein tip. Maui Nui venison beef sticks. It's 10 grams of protein and it's a delicious venison beef stick.

**中文翻译:**
噢是的，包装很可爱。我妻子也买。另一个蛋白质建议（他们曾是赞助商，现在不是了，但产品真的很棒）：Maui Nui 鹿肉棒。10 克蛋白质，而且非常好吃。

---

### [01:32:39] Naomi Gleit

**English:**
Thank you.

**中文翻译:**
谢谢。

---

### [01:32:40] Lenny Rachitsky

**English:**
There we go.

**中文翻译:**
这就对了。

---

### [01:32:40] Naomi Gleit

**English:**
Look at what we've become Lenny.

**中文翻译:**
看看我们变成什么样了，Lenny。

---

### [01:32:45] Lenny Rachitsky

**English:**
Just protein obsessed. It's just going to be so protein rich. Amazing. Okay, what else we got here? Okay, two more questions. Do you have a favorite life motto that you often come back to and find helpful in working life?

**中文翻译:**
满脑子都是蛋白质。这期节目蛋白质含量超标。太棒了。好了，还有什么？最后两个问题。你有没有什么经常回想、并觉得对工作生活很有帮助的人生格言？

---

### [01:32:56] Naomi Gleit

**English:**
Last month we were watching, or I guess two weeks ago, we were watching the US Open and we discovered that as people come through the hallway to come onto the court to play, the players all passed the Billie Jean King sign that says Pressure is Privilege. And I really loved that because I think just with the Teen Accounts launch and just a lot of the more public facing stuff that I have done recently, I do, like we talked about, get nervous, and I think Pressure is Privilege just reminds me that a lot of this stuff is a really incredible opportunity that I have and to be grateful for it. I can still be nervous, but also recognize and be grateful for it.

**中文翻译:**
上个月，或者说是两周前，我们在看美网公开赛。我们发现当球员穿过走廊进入球场时，都会经过比利·简·金（Billie Jean King）的一块牌子，上面写着：“压力即荣幸”（Pressure is Privilege）。我非常喜欢这句话。因为随着青少年账户的发布，以及我最近做的很多面向公众的工作，我确实会感到紧张。而“压力即荣幸”提醒我，这些事情其实是我拥有的不可思议的机会，我应该心存感激。我可以感到紧张，但同时也要意识到并感激这种压力。

---

### [01:33:48] Lenny Rachitsky

**English:**
I love that. Just to remind yourself that you're lucky to be feeling this pressure because that means something is important. Slightly different version of that is Zuck at the event in the Chase Center that you were also at had the shirt that said in Latin-

**中文翻译:**
我喜欢这个。提醒自己，能感受到压力是幸运的，因为这意味着事情很重要。另一个略有不同的版本是，扎克伯格在 Chase Center 的活动上（你也在场）穿的那件印有拉丁语的 T 恤……

---

### [01:34:02] Naomi Gleit

**English:**
Learning through suffering.

**中文翻译:**
“在苦难中学习”。

---

### [01:34:04] Lenny Rachitsky

**English:**
Learning through suffering. Perfect.

**中文翻译:**
在苦难中学习。完美。

---

### [01:34:09] Naomi Gleit

**English:**
Learning through suffering. I like that one too. I mean, I think he spoke a little bit about this being an entrepreneur is really, really hard.

**中文翻译:**
在苦难中学习。我也喜欢那个。我的意思是，他也谈到了创业真的非常、非常艰辛。

---

### [01:34:23] Lenny Rachitsky

**English:**
They had the Jensen line about people asked him if he'd start Nvidia again, and his answer was like, "If I knew how insanely hard and stressful this was, I would not." Very, very honest. Okay. Last question. So Charles, your former colleague, told me that you're an incredible surfer-

**中文翻译:**
还有黄仁勋的那句话，人们问他是否会再次创办英伟达，他的回答是：“如果我知道这有多么疯狂地困难和压力巨大，我不会再来一次。” 非常诚实。好了，最后一个问题。你的前同事查尔斯告诉我，你是一个非常厉害的冲浪者……

---

### [01:34:42] Naomi Gleit

**English:**
Oh.

**中文翻译:**
噢。

---

### [01:34:43] Lenny Rachitsky

**English:**
And that you design your life almost around where and when you can go surf.

**中文翻译:**
而且你几乎是围绕着何时何地能去冲浪来规划生活的。

---

### [01:34:47] Naomi Gleit

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:34:48] Lenny Rachitsky

**English:**
Any story or lesson or I don't know, takeaway from surfing and the impact that's had on you? Lessons about surfing?

**中文翻译:**
关于冲浪对你的影响，有什么故事、教训或感悟吗？

---

### [01:34:58] Naomi Gleit

**English:**
So I think surfing and life have a lot of parallels. It is an incredibly mental sport for me. The biggest thing that I can do to improve my surfing is to improve my confidence. And so when I'm going for a wave, a lot of times I will hesitate or pull back or. Instead, the best thing that you can actually do in that situation is stand up into your fear, is to ride the wave. That is the safest thing you can do. That is the thing that you're actually supposed to do, but on every dimension, that's the right thing. And so it's almost, I guess the motto there is stand up into the fear when you're going, you're about to catch a wave and actually the things that you can do when you're afraid, for example, like I said, pull back or throw your board are actually quite counterproductive and actually unsafe and could lead to more injury. And so it's just another reminder that you really need to commit. Stand up into your fear.

**中文翻译:**
我认为冲浪和生活有很多相似之处。对我来说，这在很大程度上是一项心理运动。提高冲浪水平最重要的一点就是增强信心。当我冲向一个浪头时，很多时候我会犹豫或退缩。但实际上，在那这种情况下你能做的最好的事情就是“迎着恐惧站起来”（stand up into your fear），去驾驭那个浪。那是你能做的最安全的事，也是你本该做的事，从任何维度来看，那都是正确的选择。所以，格言就是：当你准备抓浪时，迎着恐惧站起来。当你害怕时所做的动作——比如退缩或扔掉冲浪板——实际上是适得其反的，而且不安全，可能导致更多伤害。所以这再次提醒你：你必须全身心投入。迎着恐惧站起来。

---

### [01:36:04] Lenny Rachitsky

**English:**
I love it. Stand up into your fear and pressure is a privilege and learning through suffering. Naomi, this was so much fun. I'm so happy that you agreed to do this. Two final questions. Where can folks find you a line? Where they find Naomi-isms, and anything else you want to point folks to and how can listeners be useful to you?

**中文翻译:**
我太喜欢这个了。“迎着恐惧站起来”、“压力即荣幸”以及“在苦难中学习”。Naomi，这真的很有趣。我很高兴你同意参加节目。最后两个问题：大家在哪里可以找到你？在哪里可以找到“Naomi 主义”？还有什么你想向大家推荐的？听众能为你做些什么？

---

### [01:36:21] Naomi Gleit

**English:**
So believe it or not, I have Naomi.com. I know Boz has Boz.com. I bought that URL, I think maybe 20 years ago, 15 to 20 years ago from a farmer actually whose wife's name was Naomi rather, and his wife was not using it. And so I got it for quite a steal. And I'll just say that I've had other famous Naomis, much more famous and much more well known than I, who would like to have Naomi.com make offers for this URL. But I really like having just a home on the internet where I can put my Naomi-isms. They're also available on Instagram, Naomi Gleit. How can listeners be useful to you? I think Lenny, I mentioned this before we got on the call, I don't tend to do that much public speaking or talking about Naomi-isms. I did some of it two years ago when we first launched but I, as a result of being on the podcast and stuff, would love to do more of this. And so I think any feedback on what listeners would like to see or hear from me, questions that would give me a reason where I felt like it would be useful for me to do more on Naomi-isms would be super helpful.

**中文翻译:**
信不信由你，我拥有 Naomi.com。我知道 Boz 有 Boz.com。我大概在 15 到 20 年前从一个农民那里买了这个域名，他妻子的名字叫 Naomi，但她不用这个域名。所以我捡了个大便宜。我得说，有很多比我有名得多的 Naomi 都想买这个域名，并报了价。但我真的很喜欢在互联网上有一个属于自己的家，可以放我的“Naomi 主义”。你也可以在 Instagram 上关注 Naomi Gleit。至于听众能帮我什么？Lenny，我之前提到过，我不常进行公开演讲或谈论“Naomi 主义”。两年前刚推出时我做过一些，但通过参加这个播客，我想多做一些尝试。所以，任何关于听众想从我这里看到或听到什么的反馈，或者能让我觉得分享“Naomi 主义”对大家有用的问题，都会对我非常有帮助。

---

### [01:37:37] Lenny Rachitsky

**English:**
Sweet. So if you have any of those, leave them in the YouTube comments is usually the easiest place for folks to leave that. Naomi, thank you so much for being here. This was so much fun.

**中文翻译:**
太棒了。如果大家有反馈，请留在 YouTube 评论区，那是大家最方便留言的地方。Naomi，非常感谢你能来，这真的很有趣。

---

### [01:37:45] Naomi Gleit

**English:**
Thank you, Lenny.

**中文翻译:**
谢谢你，Lenny。

---

### [01:37:47] Lenny Rachitsky

**English:**
Bye everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
大家再见。非常感谢收听。如果你觉得有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅本节目。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现本播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。