# Nick Turley - 双语对照

This is the complete bilingual (English-Chinese) transcript for Lenny's Podcast featuring Nick Turley, Head of ChatGPT at OpenAI.

---

### [00:00:00] Lenny Rachitsky

**English:**
You were a product leader at Dropbox, then Instacart. Now, you're the PM of the most consequential product in history.

**中文翻译:**
你曾是 Dropbox 和 Instacart 的产品负责人。而现在，你是历史上最具影响力的产品的产品经理。

---

### [00:00:05] Nick Turley

**English:**
I didn't know what I would do here because it was a research lab. My first task was I fix the blinds, or something like that.

**中文翻译:**
我当时不知道来这儿能干什么，因为这里以前是个研究实验室。我的第一个任务好像是修百叶窗之类的。

---

### [00:00:11] Lenny Rachitsky

**English:**
When someone offers you a rocket ship, don't ask which seat.

**中文翻译:**
当有人邀请你上火箭时，别问位置在哪。

---

### [00:00:13] Nick Turley

**English:**
We set out to build a super assistant. It was supposed to be a hackathon code base.

**中文翻译:**
我们最初的目标是建立一个“超级助手”。它原本只是一个黑客松（Hackathon）的项目代码库。

---

### [00:00:16] Lenny Rachitsky

**English:**
What was it called before?

**中文翻译:**
它以前叫什么名字？

---

### [00:00:17] Nick Turley

**English:**
It was going to be Chat with GPT-3.5 because we really didn't think it was going to be a successful product.

**中文翻译:**
本来打算叫“与 GPT-3.5 聊天”，因为我们当时真的没觉得它会成为一个成功的产品。

---

### [00:00:21] Lenny Rachitsky

**English:**
And then Sam Altman is just like, "Hey, let me tweet about it."

**中文翻译:**
然后萨姆·奥特曼（Sam Altman）就说：“嘿，让我发个推特说说这事。”

---

### [00:00:23] Nick Turley

**English:**
This is a pattern with AI, you won't know what to polish until after you ship. My dream is that we ship daily.

**中文翻译:**
这是 AI 领域的一个模式：在发布之前，你根本不知道该打磨哪里。我的梦想是我们可以每天发布新版本。

---

### [00:00:28] Lenny Rachitsky

**English:**
By the time people hear this, they're going to have their hands on GPT-5.

**中文翻译:**
当人们听到这段播客时，他们应该已经用上 GPT-5 了。

---

### [00:00:31] Nick Turley

**English:**
About 10% of the world population uses every week. With scale comes responsibility. It just feels a little bit more alive, a bit more human. This model has taste.

**中文翻译:**
全球约 10% 的人口每周都在使用它。规模越大，责任越大。它感觉更有生命力，更像人类。这个模型是有“品味”的。

---

### [00:00:38] Lenny Rachitsky

**English:**
Kevin Weil, your CPO, said to ask you about this principle of, "Is it maximally accelerated?"

**中文翻译:**
你们的首席产品官（CPO）凯文·威尔（Kevin Weil）让我问问你关于“是否已最大限度加速？”这个原则。

---

### [00:00:43] Nick Turley

**English:**
I just really want to jump to the punchline, "Why can't we do this now?" I always felt like part of my role here is to just set the pace and the resting heartbeat.

**中文翻译:**
我总是想直接跳到结果：“为什么我们现在不能做这个？”我一直觉得我在这里的部分职责就是设定节奏和团队的“静息心率”。

---

### [00:00:49] Lenny Rachitsky

**English:**
Everyone is always wondering, "Is Chat the future of all of this stuff?"

**中文翻译:**
每个人都在好奇：“对话（Chat）真的是这一切的未来吗？”

---

### [00:00:52] Nick Turley

**English:**
Chat was the simplest way to ship at that time. I'm baffled by how much it took off, even more baffled by how many people have copied.

**中文翻译:**
对话是当时最简单的发布方式。我对它的火爆程度感到困惑，更对有这么多人在模仿这种范式感到不解。

---

### [00:01:58] Lenny Rachitsky

**English:**
ChatGPT is now driving more traffic to my newsletter than Twitter.

**中文翻译:**
ChatGPT 现在为我的时事通讯（Newsletter）带来的流量已经超过了 Twitter。

---

### [00:01:02] Nick Turley

**English:**
That is the type of capability that has been incredibly retentive. I've been really excited about what we've been doing in search.

**中文翻译:**
这种能力具有极强的用户留存力。我对我们在搜索领域所做的事情感到非常兴奋。

---

### [00:01:06] Lenny Rachitsky

**English:**
Can you give us a peek into where this goes long-term?

**中文翻译:**
你能让我们窥探一下这玩意的长期走向吗？

---

### [00:01:09] Nick Turley

**English:**
ChatGPT feels a little bit like MS-DOS. We haven't built Windows yet, and it will be obvious once we do.

**中文翻译:**
ChatGPT 感觉有点像 MS-DOS。我们还没做出“Windows”，但一旦做出来，一切都会变得显而易见。

---

### [00:01:15] Lenny Rachitsky

**English:**
Today, my guest is Nick Turley. Nick is Head of ChatGPT at OpenAI. He joined the company three years ago, when it was still primarily a research lab. He helped come up with the idea of ChatGPT and took it from 0 to over 700 million weekly active users, billions in revenue, and arguably the most successful and impactful consumer software product in human history. Nick is incredible. He's been very much under the radar. This is the first major podcast interview that he has ever done, and you are in for a treat. We talk about all the things, including the just launched GPT-5.

**中文翻译:**
今天的嘉宾是尼克·特利（Nick Turley）。尼克是 OpenAI 的 ChatGPT 负责人。他在三年前加入公司，当时那里主要还是个研究实验室。他参与构思了 ChatGPT，并带领它从 0 增长到超过 7 亿周活跃用户、数十亿美元营收，且可以说是人类历史上最成功、最具影响力的消费级软件产品。尼克非常厉害，但他一直很低调。这是他做的第一次重大播客采访，大家有福了。我们会聊到方方面面，包括刚刚发布的 GPT-5。

---

### [00:01:50] Lenny Rachitsky

**English:**
A huge thank you to Kevin Weil, Claire Vo, George O'Brien, Joanne Jang, and Peter Deng for suggesting topics for this conversation. If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app, or YouTube. And if you become an annual subscriber of my newsletter, you get a year free of a bunch of incredible products, including Lovable, Replit, Bolt, n8n, Linear, Superhuman, Descript, Wispr Flow, Gamma, Perplexity, Warp, Granola, Magic Patterns, Raycast, ChatPRD, and Mobbin. Check it out lennysnewsletter.com and click, "bundle". With that, I bring you Nick Turley.

**中文翻译:**
非常感谢 Kevin Weil, Claire Vo, George O'Brien, Joanne Jang 和 Peter Deng 为本次对话建议的话题。如果你喜欢这个播客，别忘了在应用或 YouTube 上订阅。如果你成为我 Newsletter 的年度订阅者，你可以免费获得一年的一系列优秀产品，包括 Lovable, Replit, Bolt 等等。请访问 lennysnewsletter.com 并点击 "bundle"。下面，让我们欢迎尼克·特利。

---

### [00:02:21] Lenny Rachitsky

**English:**
This episode is brought to you by Orkes, the company behind open source Conductor, the orchestration platform powering modern enterprise apps and agentic workflows. Legacy automation tools can't keep pace. Siloed, low-code platforms, outdated process management, and disconnected API tooling falls short in today's event-driven, AI-powered agentic landscape. Orkes changes this. With Orkes Conductor, you gain an agentic orchestration layer that seamlessly connects humans, AI agents, APIs, microservices, and data pipelines in real time at enterprise scale, visual and code-first development, built-in compliance, observability, and rock-solid reliability, ensure workflows evolve dynamically with your needs. It's not just about automating tasks, it's orchestrating autonomous agents and complex workflows to deliver smarter outcomes faster. Whether modernizing legacy systems or scaling next-gen, AI-driven apps, Orkes accelerates your journey from idea to production. Learn more and start building at orkes.io/lenny, that's orkes.io/lenny.

**中文翻译:**
本集节目由 Orkes 赞助。Orkes 是开源项目 Conductor 背后的公司，这是一款为现代企业应用和智能体工作流（agentic workflows）提供动力的编排平台。传统的自动化工具已无法跟上步伐。在当今事件驱动、AI 驱动的智能体格局中，孤立的低代码平台和过时的流程管理已捉襟见肘。Orkes 改变了这一点。通过 Orkes Conductor，你可以获得一个智能体编排层，在企业规模下实时无缝连接人类、AI 智能体、API、微服务和数据管道。它支持可视化和代码优先开发，内置合规性、可观测性和极高的可靠性。这不仅仅是任务自动化，更是编排自主智能体和复杂工作流。访问 orkes.io/lenny 了解更多。

---

### [00:03:22] Lenny Rachitsky

**English:**
This episode is brought to you by Vanta, and I am very excited to have Christina Cacioppo, CEO and co-founder of Vanta, joining me for this very short conversation.

**中文翻译:**
本集节目由 Vanta 赞助。我非常高兴邀请到 Vanta 的首席执行官兼联合创始人克里斯蒂娜·卡乔波（Christina Cacioppo）加入这段简短的对话。

---

### [00:03:31] Christina Cacioppo

**English:**
Great to be here. Big fan of the podcast and the newsletter.

**中文翻译:**
很高兴来到这里。我是这个播客和 Newsletter 的忠实粉丝。

---

### [00:03:34] Lenny Rachitsky

**English:**
Vanta is a longtime sponsor of the show, but for some of our newer listeners, what does Vanta do and who is it for?

**中文翻译:**
Vanta 是我们的长期赞助商，但对于新听众来说，Vanta 是做什么的，受众是谁？

---

### [00:03:41] Christina Cacioppo

**English:**
Sure. So we started Vanta in 2018, focused on founders, helping them start to build out their security programs and get credit for all of that hard security work with compliance certifications, like SOC 2 or ISO 27001. Today, we currently help over 9,000 companies, including some startup household names, like Atlassian, Ramp, and LangChain, start and scale their security programs, and ultimately build trust by automating compliance, centralizing GRC, and accelerating security reviews.

**中文翻译:**
好的。我们在 2018 年创立了 Vanta，专注于创始人，帮助他们建立安全计划，并通过 SOC 2 或 ISO 27001 等合规认证，让他们辛苦的安全工作获得认可。今天，我们帮助超过 9000 家公司（包括 Atlassian, Ramp 和 LangChain 等知名初创公司）启动和扩展安全计划，通过自动化合规、集中化 GRC（治理、风险与合规）和加速安全审查来建立信任。

---

### [00:04:12] Lenny Rachitsky

**English:**
That is awesome. I know from experience that these things take a lot of time and a lot of resources, and nobody wants to spend time doing this.

**中文翻译:**
太棒了。我从经验中知道，这些事情耗费大量时间和资源，而且没人愿意花时间做这些。

---

### [00:04:20] Christina Cacioppo

**English:**
That is very much our experience, but before the company, and some extent, during it, but the idea is, with automation, with AI, with software, we are helping customers build trust with prospects and customers in an efficient way. And our joke, we started this compliance company so you don't have to.

**中文翻译:**
这确实是我们的体会。我们的理念是利用自动化、AI 和软件，帮助客户高效地与潜在客户建立信任。我们常开玩笑说：我们开了这家合规公司，这样你们就不用自己操心合规了。

---

### [00:04:36] Lenny Rachitsky

**English:**
We appreciate you for doing that, and you have a special discount for listeners. They can get $1,000 off Vanta at vanta.com/lenny, that's vanta.com/lenny for $1,000 off Vanta. Thanks for that, Christina.

**中文翻译:**
感谢你们所做的一切。我们为听众准备了特别优惠：在 vanta.com/lenny 可以享受 1000 美元的折扣。谢谢你，克里斯蒂娜。

---

### [00:04:50] Christina Cacioppo

**English:**
Thank you!

**中文翻译:**
谢谢！

---

### [00:04:55] Lenny Rachitsky

**English:**
Nick, thank you so much for joining me, and welcome to the podcast.

**中文翻译:**
尼克，非常感谢你加入我们，欢迎来到播客。

---

### [00:04:59] Nick Turley

**English:**
Thanks for having me, Lenny.

**中文翻译:**
谢谢邀请我，莱尼。

---

### [00:05:00] Lenny Rachitsky

**English:**
I already had a billion questions I wanted to ask you, and then you guys decided to launch GPT-5 the week that we're recording this. So, now, I have at least 2 billion questions for you. I hope you have a lot of time. First of all, just congrats on the launch. It's coming tomorrow, the day after recording this. Just congrats. How are you feeling? I imagine this is an ungodly amount of work and stress. How are you doing?

**中文翻译:**
我本来就有十亿个问题想问你，结果你们决定在我们录音的这一周发布 GPT-5。所以现在我有至少二十亿个问题。希望你时间充裕。首先，祝贺发布。就在录音后的明天发布，恭喜。你感觉如何？我能想象这背后是多么惊人的工作量和压力。你还好吗？

---

### [00:05:22] Nick Turley

**English:**
It's a busy week, but we've been working on this for a while, so it also feels really good to get it out.

**中文翻译:**
这是忙碌的一周，但我们已经为此准备了很久，所以能把它发布出来感觉非常好。

---

### [00:05:27] Lenny Rachitsky

**English:**
So, by the time people hear this, they're going to have their hands on GPT-5, the newest ChatGPT. What's the simplest way to just understand what this is, what it unlocks, what people can do with it? Give us the pitch.

**中文翻译:**
当人们听到这段音频时，他们已经用上 GPT-5，也就是最新的 ChatGPT 了。理解这是什么、它开启了什么、人们能用它做什么的最简单方式是什么？给我们介绍一下。

---

### [00:05:39] Nick Turley

**English:**
I'm so excited about GPT-5. I think for most people, it's going to feel like a real step change. If you're the average ChatGPT user, and we have 700 million of them this week, you've probably been on GPT-4o for a while. You probably don't even think about the model that powers the product. And GPT-5, it just feels categorically different. I'll talk about a lot of the specifics, but at the end of the day, the vibes are good, at least we feel that way. We hope that users feel the same. And increasingly, that is the thing that I think most people notice, right? They don't look at the academic benchmarks. They don't look at evaluations. They try the model and see what it feels like. And just on that dimension alone, I'm so excited. I've been using it for a while, but it is also the smartest, most useful, and fastest frontier model that we've ever launched.

**中文翻译:**
我对 GPT-5 非常兴奋。我认为对大多数人来说，这会是一次真正的阶跃式变化。如果你是普通的 ChatGPT 用户（本周我们有 7 亿用户），你可能已经用了一段时间 GPT-4o，甚至不会去想背后的模型。但 GPT-5 感觉完全不同。我会谈很多细节，但归根结底，它的“调性”（vibes）很好，至少我们是这么觉得的。我们希望用户也有同感。现在人们越来越关注这一点：他们不看学术基准测试，不看评估报告，他们直接试用模型看感觉如何。仅就这一维度而言，我就非常兴奋。我已经用了一段时间，它是我们发布过的最聪明、最有用、最快的前沿模型。

---

### [00:06:33] Nick Turley

**English:**
On pure SMARTs, one way to look at that is academic benchmarks on many of the standard ones, whether or not it's math, or reasoning, or just raw intelligence. This model is state of the art. I'm especially excited about its performance on coding, whether or not that's SWE-bench, which is a common benchmark, or actually front-end coding is really, really good as well, and that's an area where I feel like there's the true step change improvement in GPT-5. But really, no matter how you measure the SMARTs, it's quite remarkable, and I think people are going to feel the upgrade, especially if they weren't using o3 already.

**中文翻译:**
在纯粹的“聪明程度”上，可以看标准学术基准，无论是数学、推理还是原始智力，这个模型都是世界顶尖的（state of the art）。我特别兴奋的是它在编程方面的表现，无论是 SWE-bench（通用基准），还是前端编程，都非常出色。我觉得这是 GPT-5 真正实现阶跃式进步的领域。无论你怎么衡量它的智力，它都非常卓越，人们会感受到这种升级，尤其是如果他们还没用过 o3 的话。

---

### [00:07:13] Nick Turley

**English:**
And the second thing beyond SMARTs is it's just really useful. Coding is one axis of utility, whether or not you have coding questions or you're vibe coding an app, but it's also a really good writer. I write for a living, internally, externally. I just wrote a big blog post that we published Monday, and this thing is such an incredible editor. And compared to some of the older models, it's got taste, which I think is really exciting. And to me, that's something that is truly useful in my day-to-day. And there's a bunch of other areas, like it's state of the art on health, which is useful when you need it, but again, the thing you can't really express in use cases or data is the vibe of the model. And it just feels a little bit more alive, a bit more human in a way that is hard to articulate until you try it. So, feel good about that.

**中文翻译:**
除了聪明，第二点是它非常有用。编程是实用性的一个维度，无论你是问编程问题还是“凭感觉”（vibe coding）写个 App。它也是个非常棒的写作者。我平时也写很多东西，内部的、外部的。我刚写了一篇周一发布的博文，这家伙简直是个不可思议的编辑。与旧模型相比，它有“品味”，这非常令人兴奋。对我来说，这是日常工作中真正有用的东西。还有其他领域，比如它在健康咨询方面也是顶尖的。但再次强调，那些无法用用例或数据表达的是模型的“调性”。它感觉更鲜活、更像人，这种感觉很难描述，直到你亲自尝试。

---

### [00:08:06] Nick Turley

**English:**
And yeah, as mentioned, it's faster. It thinks, too, just like o3 did, but you don't have to manually tell it to do that. It'll just dynamically decide to think when it needs to. And when it doesn't need to think, it just responds instantly, and that ends up feeling quite a bit faster than using o3 did. And then maybe the thing that's most exciting is that we're making it available for free, and that's one of those things that I feel like we can uniquely do at OpenAI. Because many companies, I think, if they have a subscription model like us, they would gate it behind their paid plan. And for us, if we can scale it, we will, and that just feels awesome. We did that with 4o as well. So, everyone is going to be able to try GPT-5 tomorrow, hopefully.

**中文翻译:**
而且，如前所述，它更快。它也会像 o3 那样“思考”，但你不需要手动告诉它。它会根据需要动态决定是否思考。当不需要思考时，它会立即响应，这让它用起来比 o3 快得多。最令人兴奋的可能是我们将免费提供它，我觉得这是 OpenAI 独有的做法。很多有订阅模式的公司会把它锁在付费墙后面。但对我们来说，只要能扩展规模，我们就会开放，这种感觉很棒。我们对 4o 也是这么做的。所以，希望明天每个人都能试用 GPT-5。

---

### [00:08:46] Lenny Rachitsky

**English:**
How long does something like this take? I don't know if there's a simple answer to this, but just how long have you guys been working on GPT-5?

**中文翻译:**
做这样一个东西需要多久？我不知道是否有简单的答案，但你们研发 GPT-5 多久了？

---

### [00:08:51] Nick Turley

**English:**
We've been working on it for a while. You can view GPT-5 as a culmination of a bunch of different efforts. We had a reasoning tech, we had a more classic post-screening methodologies, and therefore, it's really hard to put a beginning on it, but it really is the end point of a bunch of different techniques that we began for a while.

**中文翻译:**
我们已经做了一段时间了。你可以把 GPT-5 看作是多项努力的结晶。我们有推理技术，有更经典的后训练（post-training）方法论，因此很难确定一个具体的开始时间，但它确实是我们研究了一阵子的多种技术的终点。

---

### [00:09:14] Lenny Rachitsky

**English:**
Can you give us a peek into the vision for where ChatGPT is going, GPT in general is going? If you look at on the surface, it's been the same idea with a much smarter brain for a long time. I'm curious where this goes long-term.

**中文翻译:**
你能让我们窥探一下 ChatGPT 乃至整个 GPT 的愿景吗？从表面上看，很长一段时间以来，它一直是“同样的创意配上更聪明的大脑”。我很好奇它的长期走向。

---

### [00:09:28] Nick Turley

**English:**
So, to maybe back up a bit, now, you think of ChatGPT as, "Is this going to be ubiquitous product?" Again, about 10% of the world population uses every week.

**中文翻译:**
退一步说，现在你会想 ChatGPT 是否会成为一个无处不在的产品。再说一次，全球约 10% 的人口每周都在用它。

---

### [00:09:37] Lenny Rachitsky

**English:**
Holy shit.

**中文翻译:**
我的天。

---

### [00:09:39] Nick Turley

**English:**
I think we have 5 million business customers now. It's an established category in its own right. But really, when we started, we set out to build a super assistant, that's how we talked about it at the time. In fact, the code base that we use is called SA Server. It was supposed to be a hackathon code base, but things always turn out a little bit differently. So, yeah, in some ways, that is still the vision. The reason I don't talk about it more than I do is because I think assistant is a bit limiting in terms of the mental model we're trying to create. You think of this very personified human thing, maybe utilitarian, maybe a... And frankly, having an assistant is not particularly relatable to most people, unless they're in Silicon Valley and they're a manager, or something like that. So it's imperfect.

**中文翻译:**
我想我们现在有 500 万企业客户。它本身已经成为一个成熟的品类。但实际上，刚开始时，我们的目标是建立一个“超级助手”（super assistant），当时我们就是这么称呼它的。事实上，我们使用的代码库叫 SA Server（超级助手服务器）。它本该是个黑客松代码库，但事情的发展总是不太一样。所以，某种程度上，这仍是愿景。我之所以不常挂在嘴边，是因为我觉得“助手”这个词在我们试图构建的心智模型中有点局限。你会想到一个非常人格化的东西，也许是功利性的……坦白说，大多数人对“拥有助手”并没有什么共鸣，除非他们在硅谷当经理之类的。所以这个词并不完美。

---

### [00:10:24] Nick Turley

**English:**
But really, what we envision is this entity that can help you with any task, whether or not that's at home, or at work, or at school, really any context, and it's an entity that knows what you're trying to achieve. So, unlike ChatGPT today, you don't have to describe your problem in menu to detail because it already stands your overarching goals and has context on your life, et cetera. So, that's one thing that we're really excited about. The inverse of giving it more inputs on your life is giving it more action space. So, we're really excited to allow it to do, over time, what a smart, empathetic human with a computer could do for you. And I think the limit of the types of problems that you can solve for people, once you give it access to tools like that, is very, very different than what you might be able to do in a chatbot today. So, that's more outputs.

**中文翻译:**
但实际上，我们设想的是一个能帮你完成任何任务的实体，无论是在家、在公司还是在学校，任何场景下。它知道你想达成什么目标。所以，不像今天的 ChatGPT，你不需要事无巨细地描述问题，因为它已经理解了你的总体目标，并拥有关于你生活的上下文。这是我们非常兴奋的一点。与给它更多生活输入相对应的是给它更多的“行动空间”。我们非常期待让它随着时间的推移，能像一个带着电脑的聪明、有同理心的人一样为你做事。一旦你让它能够访问这类工具，你能为人们解决的问题边界将与今天的聊天机器人完全不同。这就是更多的输出能力。

---

### [00:11:19] Nick Turley

**English:**
And I often think, "Okay, I'm a general intelligence. What happened if I became Lenny's intern, or something?" And I wouldn't be particularly effective despite having both of those attributes that I just mentioned, and it's because I think this idea of building a relationship with this technology is also incredibly important. So, that's maybe the third piece that I'm excited about is building a product that can truly get to know you over time. And you saw us launch some of those things with improved memory earlier this year, and that's just the beginning of what we're hoping to do so that it really feels like this is your AI. So, I don't know if supersystem is still the right exact analogy, but I think people just think of it as their AI. And I think we can put one in everyone's pocket and help them solve real problems, whether or not that's becoming healthy, whether or not that's starting a business, whether or not that's just having a second opinion on anything. There's so many different problems that you can help with people in their daily life, and that's what motivates me.

**中文翻译:**
我经常想：“好吧，我是一个通用智能。如果我成了莱尼的实习生会怎样？”尽管拥有我刚才提到的那些属性，我可能也不会特别高效，因为我认为与这项技术建立“关系”也至关重要。所以，这可能是我兴奋的第三点：打造一个能随着时间推移真正了解你的产品。今年早些时候你看到我们推出了改进的记忆功能，这只是开始，我们希望让它感觉真正是“你的 AI”。我不确定“超级系统”是否仍是准确的类比，但我认为人们会把它看作自己的 AI。我们可以把 AI 放进每个人的口袋，帮他们解决现实问题，无论是变健康、创业，还是对任何事情寻求第二意见。日常生活中有很多问题可以提供帮助，这就是我的动力。

---

### [00:12:16] Lenny Rachitsky

**English:**
So an interesting between the lines that I'm reading here is the vision is for it to be an assistant for people not to replace people. It feels like a really important piece of the puzzle. Maybe just talk about that.

**中文翻译:**
我从你的话中读出的一个有趣的潜台词是：愿景是让它成为人的助手，而不是取代人。这似乎是拼图中非常重要的一块。聊聊这个吧。

---

### [00:12:29] Nick Turley

**English:**
AI is really scary to people, and I understand there's decades of movies on AI that have a certain mental model baked in. And even if you just look at the technology today, everyone, I think, has this moment where the AI does something that was really deeply personal to them and you're thought, "Hey, AI can never do that." For me, it was weird music theory things where I was like, "Wow, this thing actually understands music better than I do," and that's something I'm passionate about. And so it's naturally scary. And I think the thing that's been really important to us for a long time is to build something that feels like it's helpful to you, but you're in the driver's seat, and that's even more important as the stuff becomes agentic, the feeling of being in control, and that can be small things.

**中文翻译:**
AI 对人们来说确实很可怕，我理解，几十年的 AI 电影已经在人们脑中植入了一种特定的心智模型。即使看今天的技术，我想每个人都有过这样的时刻：AI 做了某些非常私人的事情，让你觉得“嘿，AI 永远做不到那个”。对我来说，是一些奇怪的乐理知识，我心想：“哇，这家伙居然比我更懂音乐”，而那是我热衷的领域。所以这自然令人恐惧。长期以来对我们非常重要的一点是，要构建一个让你觉得有帮助，但你始终掌握主动权（in the driver's seat）的东西。随着东西变得越来越“代理化”（agentic），这种掌控感变得更加重要，哪怕是小事。

---

### [00:13:15] Nick Turley

**English:**
We built this way of watching what the AI is doing when it's in agent mode. And it's not that you actually are going to watch it the whole time, but it gives you a mental model and makes you feel in control in the same way that, when you're in a Waymo, you get that screen, for those of you who've tried Waymo. You can see the other cars. It's not like you're going to actually watch, but it gives you the sense that you know how this thing works and what's happening, or we always check with you to confirm things. It's a little bit annoying, but it puts you in the driver's seat, which is important. And for that reason, we always view technology and the technology that we build as something that amplifies what you're capable of, rather than replacing it, and that becomes important as the deck gets more powerful.

**中文翻译:**
我们开发了一种方式，让你在 AI 处于代理模式时观察它在做什么。并不是说你真的会一直盯着看，但它给了你一个心智模型，让你感到一切尽在掌握。就像坐 Waymo 自动驾驶车时，你会看到那个屏幕，能看到周围的车辆。你不会真的盯着看，但它让你感觉到你知道这玩意是怎么运作的，或者我们会总是向你确认。虽然有点烦人，但它让你处于主导地位，这很重要。因此，我们始终将技术视为放大你能力的东西，而不是取代你，随着技术变得越来越强大，这一点愈发重要。

---

### [00:13:53] Lenny Rachitsky

**English:**
Okay. So you mentioned the beginnings of ChatGPT. I was reading in a different interview. So you joined OpenAI. ChatGPT was just this internal experimental project that was basically a way to test GPT-3.5, and then Sam Altman is just like, "Hey, let me tweet about it, maybe see if people find this interesting," yada yada, yada. It's the most successful consumer product in history, I think both in growth rate in users and revenue, and just absurd. Can you give us a glimpse into that early period before it became something everyone is obsessed with?

**中文翻译:**
好的。你提到了 ChatGPT 的起源。我在另一个采访里读到过：你加入 OpenAI 时，ChatGPT 只是一个内部实验项目，基本上是测试 GPT-3.5 的一种方式。然后萨姆·奥特曼就说：“嘿，让我发个推特，看看大家感不感兴趣”，云云。它是历史上最成功的消费级产品，无论是用户增长率还是营收都非常荒谬。你能让我们了解一下在它成为全民痴迷的对象之前的早期情况吗？

---

### [00:14:24] Nick Turley

**English:**
Yeah. So we had decided that we wanted to do something consumer-facing, I think, right around the time that GPT-4 finished training, and it was actually mainly for a couple of reasons. We already had a product out there, which was our developer product. That's actually what I came in to help with initially, and that has been amazing for the mission. In fact, it's grown up. And now, it's the OpenAI platform with, I don't know, 4 million developers, I think. But at that time, it was early stage, and we were running into some constraints with it because there was two problems. One, you couldn't iterate very quickly because, every time you would change the model, you'd break everyone's app. So, it was really hard to try things.

**中文翻译:**
是的。我想大约是在 GPT-4 完成训练的时候，我们决定做一些面向消费者的东西。这主要有两个原因。我们当时已经有一个产品了，就是开发者产品。那是我最初进来帮忙负责的，它对公司的使命非常有帮助。事实上它已经壮大了，现在是 OpenAI 平台，大概有 400 万开发者。但当时它还处于早期阶段，我们遇到了一些限制，主要有两个问题：第一，你无法快速迭代，因为每次更改模型，都会破坏所有人的 App。所以很难尝试新东西。

---

### [00:15:03] Nick Turley

**English:**
And then the other thing was that it was really hard to learn because the feedback we would get was the feedback from the end user to the developer to us. So it was very disintermediated, and we were excited to make fast progress towards AGI and it just felt like we needed a more direct relationship with consumers. So we were trying to figure out where to start. And in classic OpenAI fashion, especially back then, we put together a hackathon of enthusiasts of just hacking on GPT-4 to see what awesome stuff we could create and maybe ship to users, and everyone's idea was some flavor of a super assistant. They were more specific ideas, like we had a meeting bot that would call into meetings, and the vision was maybe it would help you run the meeting over time. We had a coding tool, which full circle now, probably ahead of its time. And the challenge was that we tested those things, but every time we tested these more bespoke ideas, people wanted to use it for all this other stuff because it's just a very, very generically powerful technology.

**中文翻译:**
另一个原因是很难学习，因为我们收到的反馈是经过“终端用户到开发者再到我们”的传递。这种反馈是非常间接的（disintermediated），而我们渴望在通往 AGI 的道路上取得快速进展，觉得需要与消费者建立更直接的关系。所以我们试图弄清楚从哪里开始。按照 OpenAI 的传统方式，特别是当时，我们组织了一场爱好者黑客松，专门折腾 GPT-4，看看能做出什么酷炫的东西发给用户。每个人的想法都是某种形式的“超级助手”。有一些具体的点子，比如一个能加入会议的机器人，愿景是它最终能帮你主持会议。我们还有一个编程工具，现在看来是领先于时代的。挑战在于，每当我们测试这些定制化的点子时，人们总是想用它做各种其他事情，因为它本身就是一种非常通用的强大技术。

---

### [00:16:04] Nick Turley

**English:**
So, after a couple of months of prototyping, we took that same crew of volunteers, and it was truly a volunteer group, right? We had someone from the supercomputing team who had built an iOS app before. We had someone on the research team who had written some backend code in their life. They were all part of this initial ChatGPT team, and we decided to ship something open-ended because we just wanted a real use case distribution. And this is a pattern with AI, I think, where you really have to ship to understand what is even possible and what people want, rather than being able to reason about that a priori. So, ChatGPT came together at the end because we just wanted the learnings as soon as we could, and we shipped it right before the holiday thinking we would come back and get the data and then wind it down. And obviously, that part turned out super differently because people really liked the product as is.

**中文翻译:**
所以，在经过几个月的原型设计后，我们召集了那群志愿者——真的是志愿者团队。我们有超级计算团队的人，他以前开发过 iOS App；还有研究团队的人，写过后端代码。他们都成了最初 ChatGPT 团队的一员。我们决定发布一个开放式的产品，因为我们想看到真实的用例分布。我认为这是 AI 的一个模式：你必须发布产品才能理解什么是可能的，以及人们想要什么，而不是靠先验推理。所以，ChatGPT 最终成型是因为我们想尽快学习。我们在假期前发布了它，心想回来拿完数据就把它关掉。显然，结果完全不同，因为人们非常喜欢这个产品。

---

### [00:16:56] Nick Turley

**English:**
So I remember going through the motions of like, "Oh, man, dashboard is broken. Oh, wait, people are liking it. I'm sure it's just going viral and stuff is going to die down," to like, "Oh, wow, people are retaining, but I don't understand why." And then eventually, we fell into product development mode, but it was a little bit by accident.

**中文翻译:**
我记得当时的心路历程：“天哪，仪表盘挂了。噢等等，大家很喜欢它。我敢肯定这只是病毒式传播，热度很快会降下来。”到后来变成：“哇，用户留存率很高，但我不知道为什么。”最后，我们进入了正式的产品开发模式，但这确实有点意外。

---

### [00:17:14] Lenny Rachitsky

**English:**
Wow. I did not know that ChatGPT emerged out of a hackathon project. Definitely the most successful hackathon project.

**中文翻译:**
哇。我以前不知道 ChatGPT 是从黑客松项目里诞生的。绝对是史上最成功的黑客松项目。

---

### [00:17:21] Nick Turley

**English:**
I like to tell this story when we do our hackathons because I really do want people to feel like they can ship their idea, and it's certainly been true in the past, and we'll continue to make it true.

**中文翻译:**
我们在办黑客松时喜欢讲这个故事，因为我真的希望大家觉得他们可以发布自己的想法。过去确实如此，未来我们也会继续保持。

---

### [00:17:32] Lenny Rachitsky

**English:**
If you don't want to share these things, but I wonder who that team was.

**中文翻译:**
如果你不想分享也没关系，但我很好奇那个团队都有谁。

---

### [00:17:34] Nick Turley

**English:**
The team is largely still around. Some of the researchers working on GPT-5, actually, were always part of the ChatGPT team. Engineers are still around. Designers are still around. I'm still here, I guess. So, yeah, you've got the team still running things, but obviously, we've grown up tremendously, and we've had to because with scale comes responsibility. And we're going to hit a billion users soon and you have to begin acting in a way that is appropriate to that scale.

**中文翻译:**
那个团队的大部分人还在。一些正在研发 GPT-5 的研究员其实一直都是 ChatGPT 团队的成员。工程师还在，设计师也在。我也还在。所以，原班人马还在运作，但显然我们已经壮大了很多。我们必须壮大，因为规模越大责任越大。我们很快就要达到 10 亿用户了，你必须开始以符合这种规模的方式行事。

---

### [00:18:06] Lenny Rachitsky

**English:**
Okay. So let me spend a little time there. So, I don't know if this is 100% true, but I believe it is that ChatGPT is the fastest growing, most successful consumer product in history. Also, the most impactful on people's lives. It feels like it's just part of the ether of society now. It's just my wife talks to it. Every question I have, I go to it, voice mode. My wife is just like, "Let me check with ChatGPT." It's just such a part of our life now, and I think it's still early. So many people don't even know what the hell is going on. Just as someone leading this, do you ever just take a moment to reflect and think about just like, "Holy shit"?

**中文翻译:**
好，让我们聊聊这个。我不确定这是否 100% 准确，但我相信 ChatGPT 是历史上增长最快、最成功的消费级产品。同时也是对人们生活影响最大的。感觉它现在已经成了社会空气的一部分。我妻子会跟它聊天。我有任何问题都会用语音模式找它。我妻子会说：“让我问问 ChatGPT。”它已经成了生活的一部分，而且我觉得现在还处于早期。很多人甚至还不知道发生了什么。作为领导者，你有没有停下来反思过，然后心想：“我的天呐”？

---

### [00:18:45] Nick Turley

**English:**
I have to. It's quite humbling to get to run a product like that, and I have to pinch myself very frequently, and I also have to sometimes sit back and just think, which is really hard when things are moving so quickly. I love setting a fast pace at the company, but in order to do that with confidence, I need at least one day every week that I'm entirely unplugged and I'm just thinking about what to do and process the week, et cetera.

**中文翻译:**
我必须反思。能运营这样一个产品让人感到非常谦卑，我经常得掐自己一下看是不是在做梦。我也必须偶尔坐下来思考，这在节奏如此之快的时候很难。我喜欢在公司设定快节奏，但为了能有信心地做到这一点，我每周至少需要一天完全“断网”，只是思考该做什么并复盘这一周。

---

### [00:19:14] Nick Turley

**English:**
And the other thing is I've never ever worked on a product that is so empirical in its nature where, if you don't stop, and watch, and listen to what people are doing, you're going to miss so much, both on the utility and on the risks, actually. Because normally, by the time you ship a product, you know what it's going to do. You don't know if people are going to like it, that's always empirical, but you know what it can do. And with AI, because I think so much of it is emergent, you actually really need to stop and listen after you launch something and then iterate on the things people are trying to do and on the things that aren't quite working yet. So, for that reason alone, I think it's very important to take a break and just watch what's going on.

**中文翻译:**
另一件事是，我从未做过一个如此具有“经验主义”（empirical）特质的产品。如果你不停下来观察、倾听人们在做什么，你会错过太多——无论是实用性还是风险。通常当你发布一个产品时，你知道它能做什么，只是不知道人们喜不喜欢。但在 AI 领域，因为很多能力是“涌现”（emergent）出来的，你真的需要在发布后停下来倾听，然后针对人们尝试做的事情和那些还没做好的事情进行迭代。仅凭这一点，我认为休息一下并观察发生了什么是至关重要的。

---

### [00:20:03] Lenny Rachitsky

**English:**
Okay. So you take a day off every week... not off. Okay, that's not the right way to put it. You take a day of thinking time, deep work.

**中文翻译:**
所以你每周休一天假……不是休假。好吧，说法不对。你花一天时间思考，进行深度工作。

---

### [00:20:12] Nick Turley

**English:**
I need it. Yeah, yeah, yeah. And I need to hard unplug on a Saturday, or something like that. Obviously-

**中文翻译:**
我需要这一天。是的。我需要在周六之类的日子彻底断开联系。显然——

---

### [00:20:16] Lenny Rachitsky

**English:**
On a Saturday [inaudible 00:20:16].

**中文翻译:**
在周六（听不清）。

---

### [00:20:16] Nick Turley

**English:**
But it's just not possible otherwise. This has been a giant marathon for three years now. Yeah.

**中文翻译:**
否则根本撑不下去。这三年来就像一场巨大的马拉松。是的。

---

### [00:20:25] Lenny Rachitsky

**English:**
Like a sprint marathon.

**中文翻译:**
像是一场冲刺型的马拉松。

---

### [00:20:26] Nick Turley

**English:**
Sprint marathon, that's right, or interval training, or something. I don't know how to exactly describe the OpenAI launch cadence, but you've got to set yourself up in a way that is sustainable. Even if this wasn't AI and it didn't have the interesting attributes that I just mentioned, I think you would need to do that. But especially with AI, it's important to go watch.

**中文翻译:**
冲刺马拉松，没错，或者是间歇训练之类的。我不知道该如何准确描述 OpenAI 的发布节奏，但你必须以一种可持续的方式安排自己。即使这不是 AI，没有我刚才提到的那些特性，你也需要这样做。但在 AI 领域，去观察尤为重要。

---

### [00:20:45] Lenny Rachitsky

**English:**
So, along those lines, I talked to a bunch of people that work with you, that work at OpenAI. Joanne specifically said that urgency and pace are a big part of how you operate, that that's just something you find really important, to create urgency within the team constantly, even when you are the fastest growing product in history, growing like crazy. Talk about just your philosophy on the importance of pace and urgency on teams.

**中文翻译:**
说到这，我采访过一些在 OpenAI 跟你共事的人。Joanne 特别提到，“紧迫感”和“节奏”是你运作方式的重要组成部分。即使你们拥有历史上增长最快的产品，你依然觉得在团队内部不断创造紧迫感非常重要。谈谈你关于团队节奏和紧迫感重要性的哲学吧。

---

### [00:21:08] Nick Turley

**English:**
Well, it's nice of her to say that. Two things, with ChatGPT, when we decided to do it, we had been prototyping for so long and I was just like, "In 10 days, we're going to ship this thing," and we did. So, that was maybe a moment in time thing where I just really wanted to make sure that we go learn something. Ever since then, I spent so much time thinking about why ChatGPT became successful in the first place, and I think there was some element of just doing things where there was many other companies that had technology in the LLM space that just never got shipped. And I just felt like, of all the things we could optimize for, learning as fast as possible is incredibly important. So I just started rallying people around that, and that took different forms.

**中文翻译:**
她能这么说真好。有两点：关于 ChatGPT，当我们决定要做它时，我们已经做原型很久了，我当时就说：“10 天内，我们要发布这玩意”，我们确实做到了。那可能只是当时的一个瞬间，我只想确保我们能学到点什么。从那以后，我花了很多时间思考 ChatGPT 为什么会成功，我觉得其中一个因素就是“去做”。当时很多其他公司也有大模型（LLM）技术，但就是没发布。我觉得在所有可以优化的目标中，“尽可能快地学习”是极其重要的。所以我开始号召大家围绕这一点行动，形式各异。

---

### [00:21:55] Nick Turley

**English:**
For a while, when we were of that size, I just ran this daily release sync and had everyone who was required to make a decision in it, and we would just talk about what to do and to pivot from yesterday, et cetera. Obviously, at some point, that doesn't scale, but I always felt like part of my role here, obviously, was to think about the direction of the product, but also to just set the pace and the resting heartbeat for our teams. And again, this is important anywhere, but it's especially important when the only way to find out what people like and what's valuable is to bring it into the external world. So, for that reason, I think it's become a superpower of OpenAI, and I'm glad that Joanne thinks that I had some part in that, but it really has taken a village.

**中文翻译:**
有一段时间，当我们规模还小时，我每天主持发布同步会，让所有决策者都参加，讨论该做什么、如何根据昨天的情况进行调整。显然，到了一定规模这就不再适用，但我一直觉得我的角色除了思考产品方向，还要为团队设定节奏和“静息心率”。这在任何地方都很重要，但当发现用户喜好和价值的唯一途径是把产品推向外部世界时，这就尤为重要。因此，我认为这已成为 OpenAI 的超能力。我很高兴 Joanne 觉得我出了一份力，但这确实是大家共同努力的结果。

---

### [00:22:38] Lenny Rachitsky

**English:**
I love this phrase, "the resting heart rate of your team". That's such a perfect metaphor of just the pace of being equivalent to your resting heart rate.

**中文翻译:**
我喜欢“团队的静息心率”这个说法。这是一个完美的比喻，将节奏等同于静息心率。

---

### [00:22:46] Nick Turley

**English:**
I actually learned that at Instacart, when I showed up there, because we were in the pandemic and it was all hands on deck. For a while, there was this... I think there was a company-wide stand-up because we disbanded all teams. We were just trying to keep the site up. And for me, I had been used to taking my sweet time and just thinking really hard about things, and that's important, but I really learned to hustle over there, and I think that's come in handy at OpenAI.

**中文翻译:**
我其实是在 Instacart 学到这一点的。我刚去那儿时正值疫情，全员待命。有一段时间，全公司每天一起开站会，因为我们解散了所有团队，只想保住网站不崩溃。在那之前，我习惯于慢条斯理地深入思考，那固然重要，但在那里我学会了“拼命干”（hustle），这在 OpenAI 派上了大用场。

---

### [00:23:12] Lenny Rachitsky

**English:**
Okay. So, along these same lines, I asked Kevin Weil, your CPO, what to ask you, and he said to ask you about this principle of, "Is it maximally accelerated?" Talk about that.

**中文翻译:**
好，顺着这个思路，我问你们的 CPO 凯文·威尔该问你什么，他说让我问问你关于“是否已最大限度加速？”这个原则。聊聊这个。

---

### [00:23:22] Nick Turley

**English:**
That's funny, we have a Slack emoji, apparently, for this now because I used to say that. Now, I try to paraphrase. Sometimes, I just really want to jump to the punchline of like, "Okay, why can't we do this now?" or, "Why can't we do it tomorrow?" And I think that it's a good way to cut through a huge number of blockers with the team and just instill... especially if you come from a larger company. At some point, we started hiring people from larger tech companies. I think they're used to, "Let's check in on this in a week," or, "Let's circle back next quarter to see if we can go on the plan." And I just, as a-

**中文翻译:**
真有意思，显然我们现在甚至有个专门的 Slack 表情包，因为我以前总说这话。现在我试着换个说法。有时我只想直接问重点：“好吧，为什么我们现在不能做？”或者“为什么明天不能做？”我觉得这是消除团队大量阻碍的好方法，并灌输……特别是如果你来自大公司。我们开始从大科技公司招人，他们习惯了“我们下周再看”或者“下个季度再看看能不能排进计划”。而我只是——

---

### [00:24:00] Nick Turley

**English:**
... on the plan and I just kind of as a thought exercise, always like people asking, "Okay, if this was the most important thing and you wanted to truly maximally accelerate it, what would you do?" That doesn't mean that you go do that, but it's really a good forcing function for understanding what's critical path versus what can happen later. And I've just always felt like execution is incredibly important. These ideas, they're everywhere. Everyone's talking about a personal AI, you might've seen news on that and I really think that execution is one of the most important things in the space and this is a tool. So, it's funny that that became a meme. It's like a little pink Slack emoji that people just put on whatever they're trying to force the question.

**中文翻译:**
……作为一个思维练习，我总是喜欢问：“好吧，如果这是最重要的事，而且你真的想最大限度地加速它，你会怎么做？”这并不意味着你真的要去那样做，但它是一个很好的“强制函数”（forcing function），能帮你理解什么是关键路径，什么是可以稍后做的。我一直觉得执行力极其重要。点子到处都是，每个人都在谈论个人 AI。我真的认为执行力是这个领域最重要的东西之一。所以很有趣，这成了一个梗。它是一个粉红色的 Slack 小表情，人们把它贴在任何想强推进度的事情上。

---

### [00:24:45] Lenny Rachitsky

**English:**
I was going to ask, what theme [inaudible 00:24:47]. So, it's a little pink, is there something in there like-

**中文翻译:**
我正想问是什么主题（听不清）。所以它是粉红色的，上面写了什么吗？

---

### [00:24:48] Nick Turley

**English:**
It's a Comic Sans emoji that says, is this maximally accelerated?

**中文翻译:**
它是一个用 Comic Sans 字体写的表情包，写着：“这是否已最大限度加速？”

---

### [00:24:53] Lenny Rachitsky

**English:**
Okay. And so, the kind of the culture there is when someone is working on something, the push is, is this maximally accelerated? Is there a way we can do this faster? Is there anything we can unblock?

**中文翻译:**
好。所以那里的文化是，当有人在做某件事时，压力点在于：这是否已最大限度加速？有没有更快的方法？有什么我们可以疏通的障碍吗？

---

### [00:25:02] Nick Turley

**English:**
Yeah. And we use that sparingly, right? Because it needs to be appropriate to the context. There's some things where you don't want to accelerate as quickly as possible because you kind of want process. And we're very, very deliberate on that where your process is a tool. And one of the areas where we have an immense amount of process is safety. Because A, the stakes are already really high, especially with these models, GPT-5 which is a frontier in so many different ways. But B, if you believe in the exponential, which I do and most people who work on this stuff do, you have to play practice for a time where you really, really need the process for sure, sure, sure. And that's why I think it's been really important to separate out the product development velocity, which has to be super high from, for things like frontier models, there actually needs to be a rigorous process where you red team, you work on the system card, you get external input, and then you put things out with confidence that it's gone through the right safeguards.

**中文翻译:**
是的。但我们会谨慎使用，因为它需要符合语境。有些事情你并不想尽可能快地加速，因为你需要流程。我们对此非常谨慎，流程是一种工具。我们拥有大量流程的领域之一是“安全”。因为第一，赌注已经很高了，特别是像 GPT-5 这样在多方面都是前沿的模型。第二，如果你相信指数增长（我信，大多数做这个的人也信），你就必须为那个“绝对、绝对、绝对需要流程”的时刻做练习。这就是为什么我认为将“产品开发速度”（必须极高）与“前沿模型发布”（需要严格流程，如红队测试、编写系统卡、获取外部输入）分开是非常重要的，这样发布时才有信心它已经过了正确的安全保障。

---

### [00:26:02] Nick Turley

**English:**
So, again, it's a nuanced concept, but I found it very, very useful when we needed and for everything product development, you're a dead on arrival, so it's important to get stuff out.

**中文翻译:**
所以，这是一个微妙的概念，但在需要时非常有用。对于产品开发来说，不发布就等于死亡，所以把东西推出去很重要。

---

### [00:26:11] Lenny Rachitsky

**English:**
We got to open source those memes so that other teams can build on this approach.

**中文翻译:**
我们得把这些表情包开源，这样其他团队也能借鉴这种方法。

---

### [00:26:16] Nick Turley

**English:**
Absolutely.

**中文翻译:**
当然。

---

### [00:26:17] Lenny Rachitsky

**English:**
So, interestingly with ChatGPT, and it's not a surprise, but not only is it the fastest-growing, most successful consumer product ever, retention is also incredibly high. People have shared these stats that one month retention is something like 90%, six month retention is something like 80%. First of all, are these numbers accurate? What can you share there?

**中文翻译:**
有趣的是，ChatGPT 不仅是史上增长最快、最成功的消费级产品，其留存率也高得惊人。有人分享过数据，说一个月留存率约为 90%，六个月留存率约为 80%。首先，这些数字准确吗？你能分享些什么？

---

### [00:26:39] Nick Turley

**English:**
I'm obviously limited on what exactly I can share, but it is true that our retention numbers are really exciting and that is actually the thing we look at. We don't care at all how much time you spend in the product. In fact, our incentive is just to solve your problem and if you really like the product, you'll subscribe, but there's no incentive to keep you in the product for long. But we are obviously really, really happy if over the long run, three month period, et cetera, you're still using this thing. And for me, this was always the elephant in the room early on. It's like, "Hey, this may be a really cool product, but is this really the type of thing that you come back to?" And it's been incredible to not just see strong retention numbers, but just see an improvement in retention over time even as our cohorts become less of an early adopter and more the average person, so.

**中文翻译:**
我能分享的具体内容显然有限，但我们的留存数据确实非常令人兴奋，这也是我们真正关注的指标。我们完全不在乎你在产品里花了多少时间。事实上，我们的动力只是帮你解决问题，如果你真的喜欢，你就会订阅，我们没有动力把你长久地困在产品里。但如果长期来看（比如三个月后）你还在用，我们当然非常高兴。对我来说，早期这一直是大家避而不谈的问题（elephant in the room）：“嘿，这可能是一个很酷的产品，但它真的是那种你会反复使用的东西吗？”令人难以置信的是，不仅留存数据强劲，而且随着用户群从早期采用者转向普通大众，留存率甚至还在随时间提高。

---

### [00:27:29] Lenny Rachitsky

**English:**
Yeah. So, that note is something that I don't think people truly understand how rare this is when a product... The cohort of users comes, tries it out and then retention over time goes down and then it comes back up, people come back to it a few months later and use it more. It's called a smiling curve, a smile curve, and that's extremely rare.

**中文翻译:**
是的。我觉得人们并没有真正意识到这有多罕见。通常用户群进来试用，留存率随时间下降，但你们的情况是它又回升了，人们几个月后回来用得更多。这被称为“微笑曲线”，极其罕见。

---

### [00:27:48] Nick Turley

**English:**
Yeah, yeah. Yeah. There's some smiling going on that's just on the team and I feel like have technology, some of it is not the product. I think people are actually just getting used to this technology in a really interesting way, where I find, and this is why the product needs to evolve too, that this idea of delegating to an AI, it's not natural to most people. It's not like you're going through life and figuring out what can I delegate? Certain sphere of Silicon Valley does that because they're in a self-optimization mode and they're trying to delegate everything they can. But I think for most people in the world it's actually quite unnatural. And you really have to learn, "Okay, what are my goals actually and what could another intelligence help me with?"

**中文翻译:**
是的。团队里也有人在微笑。我觉得这部分归功于技术，而不全是产品。人们实际上正在以一种非常有趣的方式适应这项技术。我发现（这也是产品需要进化的原因）“向 AI 委派任务”这个想法对大多数人来说并不自然。普通人不会在生活中时刻想着“我能委派什么？”硅谷的某些圈子会这么做，因为他们处于自我优化模式，试图委派一切。但对世界上大多数人来说，这其实挺不自然的。你必须学习：“好吧，我的目标到底是什么，另一个智能体能帮我做什么？”

---

### [00:28:26] Nick Turley

**English:**
And I think that just takes time and people do figure it out once they've had enough time with the product. But then of course there's been tons of things that we've done in the product too, whether or not it's making the core models better, whether or not it's new capabilities like search and personalization and all that kind of stuff, or just standard growth work too, which we're starting to do. That stuff matters too, of course.

**中文翻译:**
我认为这需要时间，人们在接触产品足够久之后确实能摸索出来。当然，我们在产品上也做了大量工作，无论是改进核心模型，还是推出搜索、个性化等新功能，或者是我们刚开始做的标准增长实验。这些当然也很重要。

---

### [00:28:49] Lenny Rachitsky

**English:**
So, you might be answering this question already, but let me just ask it directly. People may look at this and be like, "Okay, they're building this kind of layer on top of this God-like intelligence. Of course it will grow incredibly fast and retention will be incredible. What do you guys actually doing that sits on top of the model that makes it grow so fast and retain so much?" Is there something that has worked incredibly well that has moved metrics significantly that you can share?

**中文翻译:**
你可能已经在回答这个问题了，但我还是直接问吧。人们可能会觉得：“好吧，他们只是在‘上帝般的智能’之上建了一层皮。它当然会增长飞快，留存惊人。”但你们在模型之上到底做了什么，才让它增长这么快、留存这么高？有没有什么特别奏效、显著提升了指标的方法可以分享？

---

### [00:29:18] Nick Turley

**English:**
One thing we've learned, I'll answer that question in a minute, but one thing we've learned with ChatGPT is that there really is no distinction between the model and the product. The model is the product and therefore you need to iterate on it like a product. And by that I mean obviously you typically start by shipping something very open-ended, at least if you're OpenAI [inaudible 00:29:38] that's kind of a playbook. But then you really have to look at what are people trying to do? Okay, they're trying to write, they're trying to code, they're trying to get advice, they're trying to get recommendations and you need to systematically improve on those use cases. And that is pretty similar to product development work. Obviously the methodology is a bit different, but discovery is the same. You got to talk to people, you got to do data science and you got to try stuff and get feedback.

**中文翻译:**
我们学到的一件事是（我马上回答你的问题）：在 ChatGPT 中，模型和产品之间其实没有界限。模型就是产品，因此你需要像对待产品一样对其进行迭代。我的意思是，通常你会先发布一个非常开放的东西（至少 OpenAI 是这么做的，这成了我们的套路）。但接着你必须观察人们在尝试做什么。好吧，他们在尝试写作、编程、寻求建议、获取推荐，你需要系统地改进这些用例。这与传统的产品开发工作非常相似。显然方法论略有不同，但“发现”过程是一样的：你得和人聊天，做数据科学分析，尝试新东西并获取反馈。

---

### [00:30:04] Nick Turley

**English:**
So, that's one chunk of work that we've been very consciously doing is improving the model on the use cases people care about. And there's also such thing as vibes because I'm sure you know and that's one of the things that I'm excited about in GPT-5 is that the vibes are really good. So, that too is, we have a model behavior team and they really focus on what is the personality of this model and how does it speak and talk. So, there's that kind of work. I would say that's maybe a third of the retention improvements that we see or so just roughly. And then I think another third is what I would call product research capabilities. They're research driven for sure. They have a research component, but they're really new product features or capabilities. And search is one example of that where if you remember in the olden days, maybe 20 months ago or something, you would talk to ChatGPT and it'd be like, "As of my knowledge cut off..." Or, "I can't answer that because that happened to recently," or something like that.

**中文翻译:**
所以，我们一直有意识地在做的一块工作就是针对用户关心的用例改进模型。还有所谓的“调性”（vibes），这也是我对 GPT-5 感到兴奋的原因之一，它的调性非常好。我们有一个“模型行为团队”，他们专门研究模型的个性，以及它是如何说话和交流的。这类工作大概贡献了我们看到的留存率提升的三分之一。另外三分之一我称之为“产品研究能力”。它们确实是研究驱动的，有研究成分，但本质上是新的产品功能。搜索就是一个例子。如果你记得“很久以前”（大概 20 个月前），你跟 ChatGPT 说话，它会说：“根据我的知识截止日期……”或者“我无法回答，因为那是最近发生的”。

---

### [00:31:00] Nick Turley

**English:**
And that is the type of capability that has been incredibly retentive and for good reason. It just allows you to do more with the product personalization, like this idea of advanced memory where it can really get to know you over time is another example of a capability like that. I think that's another good chunk. And then the third stuff is the stuff you would do in any product and those things exist too. Not having to log in was a huge hit because it removed a ton of the friction. I think we had this intuition from the beginning, but we never got to it because we didn't have enough GPU or other constraint to really go do that. So, there's the traditional product work too. So, I often think about it as roughly a third, a third, a third, but really we're still learning and we're planning to evolve the product a ton, which is why I'm sure there's going to be new levers.

**中文翻译:**
这种能力的加入极大地提高了留存率，原因很明显：它让你能用产品做更多事。个性化也是如此，比如“高级记忆”功能，让它能随着时间真正了解你。我认为这是另一大块。最后三分之一是你在任何产品中都会做的常规工作。比如“无需登录即可使用”大受欢迎，因为它消除了大量摩擦。我们从一开始就有这种直觉，但因为 GPU 不够或其他限制一直没做。所以，传统的开发工作也占一部分。我常把它想成“三个三分之一”，但实际上我们仍在学习，并计划对产品进行大量演进，所以我确信未来会有新的增长杠杆。

---

### [00:31:52] Lenny Rachitsky

**English:**
You mentioned something that I want to come back to real quick. You said that it was something like 10 days from Hackathon to Sam tweeting about ChatGPT being live?

**中文翻译:**
你提到了一件事，我想快速确认下。你说从黑客松到萨姆发推说 ChatGPT 上线，只用了大概 10 天？

---

### [00:32:01] Nick Turley

**English:**
The Hackathon happened much earlier and we were prototyping for a long time, but at some point we basically ran out of patience on trying to build something more bespoke. And again, that was mostly because people always wanted to do all this other stuff whenever we tested it. So, it was 10 days from when we decided we were going to ship to when we shipped. And the research we'd been testing for a long time, it was kind of an evolution of what we'd called instruction following, which was the idea that instead of just completing the sentence, these models could actually follow you instructions. So, if you said summarize this, it would actually do so. And the research had evolved from that into a chat format where we could do it multi-turn. So, that research took way longer than 10 days and that kind of baking in the background, but the productization of this thing was very, very fast and lots of things didn't make it in.

**中文翻译:**
黑客松发生得更早，我们原型设计了很久。但在某个时间点，我们对尝试构建更定制化的东西失去了耐心。再次强调，主要是因为每次测试时，人们总想用它做别的事。所以，从我们决定发布到正式发布，确实是 10 天。而我们一直在测试的研究其实是“指令遵循”（instruction following）的一种演进——即模型不再只是补全句子，而是能听从指令。如果你说“总结这个”，它真的会去做。研究从那里演进到了可以进行多轮对话的聊天格式。那项研究花了远不止 10 天，一直在后台酝酿，但这个东西的“产品化”过程非常快，很多东西都没来得及放进去。

---

### [00:32:50] Nick Turley

**English:**
I remember we didn't have history, which of course was the first user feedback we got. The model had a bunch of shortcomings and it was so cool to be able to iterate on the model. The thing I just talked about, treating the model as a product was not a thing before ChatGPT because we would ship in more hardware where there'd be a release GPT-3 and then we would start working on GPT-4 and these weird giant big spend R&D projects that would take a really long time and the spec was whatever the spec was and then you'd have to wait another year. And ChatGPT really broke that down because we were able to make iterative improvements to it just like software. And really, my dream is that it would be amazing if we could just ship daily or even hourly like in software land because you could just fix stuff, et cetera. But there's of course all kinds of challenges in how you do that while keeping the personality intact while not regressing other capabilities. So, it's an open field to get there.

**中文翻译:**
我记得当时甚至没有“历史记录”，这当然是我们收到的第一个用户反馈。模型有很多缺点，但能对模型进行迭代真的很酷。我刚才提到的“把模型当作产品”在 ChatGPT 之前是不存在的，因为以前我们更像发硬件：发布 GPT-3，然后开始研发 GPT-4，这些耗资巨大的研发项目周期极长，规格定死后你就得等上一年。ChatGPT 打破了这种模式，因为我们可以像软件一样对它进行迭代改进。我的梦想是能像软件界那样每天甚至每小时发布一次，因为这样你可以随时修复问题。当然，如何在保持个性的同时不让其他能力退化，这其中有很多挑战。

---

### [00:33:42] Lenny Rachitsky

**English:**
That is such a good example of is it maximally accelerated? Okay, we're going to ship ChatGPT 10 days.

**中文翻译:**
这真是“是否已最大限度加速”的绝佳例子。好吧，我们要用 10 天发布 ChatGPT。

---

### [00:33:48] Nick Turley

**English:**
[inaudible 00:33:48]-

**中文翻译:**
（听不清）

---

### [00:33:48] Lenny Rachitsky

**English:**
Holy moly. We've been talking about ChatGPT. Clearly it's kind of a chat interface. Everyone's always wondering is chat the future of all of this stuff? Interestingly, Kevin Weil made this really profound point that has always stuck with me when he was on the podcast that chat is actually a genius interface for building on a super intelligence because it's how we interact with humans of all variety of intelligence. It scales from someone at the lower end to a super smart person. And so, it's really valuable as a way to scale this spectrum. Maybe just talk about that and is chat the long-term interface for ChatGPT, I guess it's called ChatGPT.

**中文翻译:**
我的天。我们一直在聊 ChatGPT，显然它是一个对话界面。大家总在想：对话真的是这一切的未来吗？有趣的是，凯文·威尔在播客里提过一个让我印象深刻的深刻观点：对话实际上是构建超级智能的天才界面，因为这就是我们与各种智力水平的人类互动的方式。它能适应从智力较低的人到超级聪明的人。所以，作为衡量这个光谱的一种方式，它非常有价值。聊聊这个吧，对话会是 ChatGPT 的长期界面吗？毕竟它就叫 ChatGPT。

---

### [00:34:27] Nick Turley

**English:**
I feel like we should either drop the chat or drop the GPT at some point because it is a mouthful. We're stuck with the name, but no matter what we do, the product will evolve. I think that I agree that there's something profound about natural language. It just really is the most natural form of communicating to humans and therefore it feels important that you should be communicating with your software in natural language. I think that's different from chat though. I think chat was the simplest way to ship at the time. I'm baffled by how much it took off as a concept. Even more baffled by how many people have copied the paradigm rather than trying out a different way of interacting with AI. I'm still hoping that will happen. So, I think natural language is here to stay, but this idea that it has to be a turn-by-turn chat interaction I think is really limiting.

**中文翻译:**
我觉得我们迟早得把“Chat”或者“GPT”给去掉一个，因为这名字太绕口了。虽然名字改不了，但产品会进化。我同意自然语言有其深刻之处。它确实是人类交流最自然的形式，因此用自然语言与软件交流显得至关重要。但我认为这与“对话”（Chat）不同。对话只是当时最简单的发布方式。我对这个概念如此火爆感到困惑，更对这么多人只是模仿这种范式而不是尝试不同的 AI 交互方式感到不解。我仍希望看到新的交互方式出现。所以，我认为自然语言会留下来，但“必须是轮流发言的对话交互”这个想法是很局限的。

---

### [00:35:24] Nick Turley

**English:**
And this is one of the reasons I don't love the super system analogy, even though we used to always use it is because if you think that way, then you kind of feel like you're talking to a person and GPT-5 it's amazing at making great front-end applications. So, I don't see a reason why you wouldn't have AIs that can render their own UI in some way. And you obviously want to make that predictable and feel good. But it feels limiting to me to think of the end-all-be-all interface as a chatbot. It actually kind of feels dystopian almost where I don't want to use all my software through the proxy of some interface. I love being in Figma, I love being in Google Docs. Those are all great products to me and they're not chatbots.

**中文翻译:**
这也是我不喜欢“超级系统”类比的原因之一（尽管我们以前总用）。因为如果你那样想，你就会觉得是在跟一个人说话。而 GPT-5 在制作前端应用方面非常出色，所以我看不出有什么理由不让 AI 以某种方式渲染自己的 UI。你当然希望它是可预测且体验良好的。但如果认为聊天机器人就是终极界面，我觉得太局限了。这甚至让我感到有点反乌托邦——我不想通过某个界面的代理来使用我所有的软件。我喜欢用 Figma，喜欢用 Google Docs，它们都是伟大的产品，而且它们不是聊天机器人。

---

### [00:36:07] Nick Turley

**English:**
So, yes on natural language, but no on chat is where I would describe my point of view. And I'm just hoping in general that we see more consumer innovation on how people interact with AI because there's so many possibilities and you just got to try stuff. That's why chat stuck is we just did it and people liked it. So, I'm hoping that we see more there and we'll try to do our part.

**中文翻译:**
所以，我的观点是：支持自然语言，但不支持局限于对话。我希望看到更多关于人类如何与 AI 互动的消费级创新，因为有太多可能性了，你必须去尝试。对话之所以流行，是因为我们做了，而人们喜欢。我希望看到更多突破，我们也会尽一份力。

---

### [00:36:31] Lenny Rachitsky

**English:**
So, you mentioned that you kind of got stuck with this name ChatGPT. Maybe this is part of the answer, but I'm curious just are there any accidental decisions you guys made early on that have stuck and have essentially become history changing?

**中文翻译:**
你提到你们有点被 ChatGPT 这个名字困住了。也许这就是答案的一部分，但我很好奇，你们早期有没有做过什么偶然的决定，结果却一直沿用至今，甚至改变了历史？

---

### [00:36:45] Nick Turley

**English:**
There's so many and it is funny, because you have no time to think about them and then they end up being super consequential. The day was one, we went from chat with GPT-3.5 to ChatGPT the night before, slightly better but still really bad.

**中文翻译:**
太多了。很有趣，因为你当时根本没时间思考，结果它们变得影响深远。名字就是一个，我们在发布前一晚才把“与 GPT-3.5 聊天”改为 ChatGPT，稍微好点，但还是很烂。

---

### [00:36:58] Lenny Rachitsky

**English:**
What was it called before?

**中文翻译:**
它以前叫什么？

---

### [00:36:59] Nick Turley

**English:**
It was going to be Chat with GPT-3.5 because we really didn't think it was going to be successful product. We were trying to actually be as nerdy as we could about it because that's really what it was. It was a research demo, not a product. So, we didn't think that was bad. But I think that in the original release, making it free was a big deal. I don't think we appreciate that because the GPT-3.5 model was in our API for at least six months prior to that. I think anyone could have built something like this. It might not have been quite as good on the modeling side, but I think it would've taken off. So, making it free and putting a nice UI on it, very consequential in the way that you take for granted now. And this is why I think that A, distribution and the interface are continuously important even in 2025.

**中文翻译:**
本来叫“与 GPT-3.5 聊天”，因为我们真的没觉得它会成为一个成功的产品。我们当时想尽量表现得“极客”一点，因为它本质上就是一个研究演示（demo），而不是产品。所以我们没觉得那名字不好。但我认为在最初发布时，将其“免费开放”是一件大事。我们可能没意识到这一点，因为 GPT-3.5 模型在那之前已经在我们的 API 里放了至少六个月。我觉得任何人都能做出类似的东西，模型端可能没那么好，但肯定也能火。所以，免费并配上一个漂亮的 UI，其影响之深远是你现在觉得理所当然的。这就是为什么我认为，即使到了 2025 年，分发和界面依然至关重要。

---

### [00:37:48] Nick Turley

**English:**
The paid business, which now it's a giant business both in the consumer space and in the enterprise space. The birth of that was just to turn away demand originally. It was not like we brainstormed, "Oh, what is the best monetization model for AI?" It was really what monetization model or what mechanism would allow us to turn away people who are less serious than the people who are really trying to use it? And subscriptions just happened to have that property and it grew into a large business. I think shipping really funky capabilities before they were polished is another thing where that feels like a tactical decision, but it became a playbook because we would learn so much. Remember when we shipped Code Interpreter, we learned so much after we shipped it. Now it's known as I think data analysis in ChatGPT or something like that just because we actually got real world use cases back that we could then optimize. So, I think there's been a lot of decisions over time that proved pretty consequential, but we made them very, very quickly as we have to, so.

**中文翻译:**
付费业务现在在消费端和企业端都是巨大的生意。但它的诞生最初只是为了“挡住需求”。我们并不是在头脑风暴“AI 最好的变现模式是什么”，而是想“什么样的机制能让我们挡住那些不那么认真的用户，把资源留给真正想用的人？”订阅制恰好有这个属性，结果它长成了一门大生意。还有就是在功能尚未打磨好时就发布一些“古怪”的能力，这听起来像战术决定，但后来成了我们的套路，因为我们能学到太多。记得发布 Code Interpreter（代码解释器）时，发布后我们学到了很多。现在它叫“数据分析”，就是因为我们拿到了真实的用例并进行了优化。所以，很多决定事后看来影响巨大，但当时我们必须飞快地做决定。

---

### [00:38:53] Lenny Rachitsky

**English:**
The $20 a month feels like an important part of this. Feels like everybody's just doing that now and-

**中文翻译:**
每月 20 美元似乎是重要的一部分。感觉现在所有人都在效仿这个定价……

---

### [00:38:57] Nick Turley

**English:**
On that one actually, I remember I had this kind of panic attack because we really needed to launch subscriptions because at the time we were taking the product down every time. It was, I don't know if you remember, we had this fail whale, there's a little [inaudible 00:39:09] generated poem on it. So, they were like, "We had to get this out." And I remember calling up someone I greatly respect who's incredible at pricing and I was like, "What should I do?" And we talked a bunch and I just ran out of time to incorporate most of that feedback. So, what I did do is ship a Google Form to Discord with, I think the four questions you're supposed to ask on how to price something-

**中文翻译:**
关于定价，我记得当时我有点恐慌，因为我们急需推出订阅服务。当时产品经常宕机，不知道你还记不记得那个“宕机小鲸鱼”（fail whale），上面还有一段 AI 生成的小诗。所以大家觉得必须把订阅推出来。我记得打电话给一个我非常尊敬的定价专家，问他该怎么办。我们聊了很多，但我根本没时间消化那些反馈。所以我做的是：在 Discord 上发了一个 Google 表单，里面包含了关于如何定价的四个标准问题——

---

### [00:39:32] Lenny Rachitsky

**English:**
[inaudible 00:39:32]?

**中文翻译:**
（听不清）？

---

### [00:39:33] Nick Turley

**English:**
Yeah, exactly. It literally had those four questions and I remember distinctly A, you [inaudible 00:39:38] a price back and that's kind of how we got to $20. But B, the next morning, there was a press article on you won't believe the four genius questions the ChatGPT team asked to price their... It was like if only you knew. So, there's something about building in this extreme public where people interpret so much more intentionality into what you're doing than might've actually existed at the time. But we got with the $20. We're debating something slightly higher at the time. I often wonder what would've happened because so many other companies ended up copying the $20 price point. So, I'm like, "Did we erase a bunch of market cap by pressing it this way?" But ultimately I don't care because the more accessible we can make this stuff, the better. And I think this is the price point that in Western countries has been reasonable to a lot of people in terms of the value that they get back.

**中文翻译:**
没错。就是那四个问题。我清楚地记得，根据反馈我们定下了 20 美元。但更有趣的是，第二天早上就有一篇新闻报道说：“你绝对不敢相信 ChatGPT 团队为了定价问出的那四个天才问题……”我心想：要是你们知道真相就好了。在极度公开的环境下构建产品就是这样，人们会过度解读你的意图。我们最后定了 20 美元，当时还在讨论要不要定高一点。我经常想，如果定别的价会怎样，因为后来那么多公司都抄了 20 美元这个价位。我在想：“我们是不是因为这个定价抹掉了一大块市值？”但最终我不在乎，因为东西越容易获得越好。我认为在西方国家，就用户获得的价值而言，这个价位对很多人来说是合理的。

---

### [00:40:35] Nick Turley

**English:**
And most importantly, we were able to push things down to the free tier semi-regularly and we always do that when we can [inaudible 00:40:35], but-

**中文翻译:**
最重要的是，我们能够定期将功能下放到免费层级，只要有能力我们就会这么做。

---

### [00:40:35] Lenny Rachitsky

**English:**
So, the survey, just to give the official name, the Van Westendorp survey is how you guys ended up pricing ChatGPT?

**中文翻译:**
所以，那个调查（正式名称叫“范威斯腾多普价格敏感度分析”）就是你们最终给 ChatGPT 定价的方式？

---

### [00:40:42] Nick Turley

**English:**
It was the top Google result. This was before ChatGPT has real-time information. Otherwise, it could have maybe price itself, but it was Discord plus Google Form plus a blog post on that methodology that got us there.

**中文翻译:**
那是 Google 搜索结果的第一条。当时 ChatGPT 还没有实时信息，否则它可能就给自己定价了。总之，是 Discord 加上 Google 表单，再加上一篇关于该方法论的博文，让我们得出了这个结果。

---

### [00:40:54] Lenny Rachitsky

**English:**
That is incredible. What a fun story. This is the survey that Rahul Vohra at Superhuman popularized in his first- round article-

**中文翻译:**
太不可思议了。真是有趣的故事。这就是 Superhuman 的 Rahul Vohra 在他那篇著名的文章里推广的那个调查。

---

### [00:41:00] Nick Turley

**English:**
Yeah. Yeah, yeah, that's right. That's right. Definitely don't bring me on here as a pricing expert, I think you have got better people for that.

**中文翻译:**
没错，就是那个。千万别把我当成定价专家请来，我觉得你有更好的人选。

---

### [00:41:08] Lenny Rachitsky

**English:**
Whether it was right or wrong, it is now the fastest-growing, insane revenue generating business in the world. So, I wouldn't feel too bad.

**中文翻译:**
不管对错，它现在都是世界上增长最快、营收最疯狂的业务。所以你不用觉得难受。

---

### [00:41:16] Nick Turley

**English:**
No, it worked out. Yeah.

**中文翻译:**
不，结果挺好的。是的。

---

### [00:41:17] Lenny Rachitsky

**English:**
It worked out. And by the way, I'm on the $200 a month tier, so there's clearly a room-

**中文翻译:**
结果很好。顺便说一下，我订阅的是每月 200 美元的档位，所以显然还有空间……

---

### [00:41:22] Nick Turley

**English:**
Thank you. Thank you.

**中文翻译:**
谢谢，谢谢。

---

### [00:41:25] Lenny Rachitsky

**English:**
... [inaudible 00:41:25]-

**中文翻译:**
（听不清）

---

### [00:41:25] Nick Turley

**English:**
The story of that one is interesting too because originally the purpose of the Plus plan was to be able to ship first uptime and then be able to ship capabilities that we couldn't scale to everyone. And at some point it got so many people in the Plus tier that had just lost that property. So, the main reason we came up with the $200 tier is just we had so much incredible research that's actually really, really powerful. Like o3 Pro or tomorrow GPT-5 Pro and just having a vehicle of shipping that to people who really, really care is exciting even though it kind of violates the standard way a SaaS page should look, it's a little jarring to see the 10X jump. So, thank you for being a subscriber on that and thank you everyone else who's watching you subscribed to any tier, it's great.

**中文翻译:**
那个档位的故事也很有趣。最初 Plus 计划的目的是保证在线率，并发布一些无法向所有人开放的功能。但后来 Plus 用户太多了，它失去了这种特性。所以我们推出 200 美元档位的主要原因是，我们有很多极其强大、不可思议的研究成果，比如 o3 Pro 或明天的 GPT-5 Pro。能有一个渠道把这些东西发给那些真正关心的人是很令人兴奋的，尽管这违反了标准 SaaS 页面该有的样子——看到 10 倍的价格跳跃确实有点吓人。所以，感谢你订阅那个档位，也感谢所有订阅了任何档位的听众。

---

### [00:42:10] Lenny Rachitsky

**English:**
I'm just going to throw a fishing line into this pond of are there any other stories like this? You shared this incredible story of Chat with GPT-3.5 being the original name, how you came up with pricing. Is there anything else?

**中文翻译:**
我想再挖挖看，还有类似的故事吗？你分享了原名是“与 GPT-3.5 聊天”以及定价是怎么来的。还有别的吗？

---

### [00:42:22] Nick Turley

**English:**
Enterprise is interesting one too because we've seen so much incredible adoption in the Enterprise and it's sort of objectively crazy to try to take on building a developer business and a consumer business and an enterprise business and all at once. But the story there is in like month one or two, it was very clear that most of the usage was work usage, actually much more than today where you've got so many consumers on the product and it's kind of sort of transcended into pop culture. But at the time it was writing, coding, analysis, that kind of stuff. And we were pretty quickly in organically in 90% of Fortune 500 companies in a way that I had seen maybe at Dropbox back when that was my two jobs ago where we had a similar story. And since then there's been more PLG companies. But the real reason we did Enterprise, remember we were debating should we do enterprise or should we launch an iOS app because that's how small the team was.

**中文翻译:**
企业版（Enterprise）也很有趣。我们在企业端看到了惊人的采用率。客观来说，同时做开发者业务、消费者业务和企业业务简直是疯了。但故事是这样的：在第一两个月里，很明显大部分使用场景都是工作用途，比例远高于今天（今天有很多普通消费者，它已经成了流行文化的一部分）。但当时主要是写作、编程、分析之类的。我们很快就自然而然地进入了 90% 的财富 500 强公司，这种场景我在两份工作前的 Dropbox 见过类似的。但我们做企业版的真正原因是——记得当时我们还在争论是该做企业版还是该发 iOS App，因为团队就那么点人。

---

### [00:43:22] Nick Turley

**English:**
The reason we did is we were starting to get banned in companies because they all felt rightfully or wrongfully that the privacy and deployment story, et cetera wasn't there. So, I was just like, "Man, we have to do something. We're going to miss out on a generational opportunity to build a work product." And we've literally defined AGI as outperforming most humans at economically valuable work or I'd probably [inaudible 00:43:45] that, but I think that's the way we put it. And so, I feel like we had to be present there and it was a fairly quick decision at the time, but it's grown into an immense business. We just hit 5 million business subscribers up from 3 million, I think a month or two ago. So, it is kind of the spinoff that it's taking a life of its own that I'm really, really excited about for [inaudible 00:44:11]-

**中文翻译:**
我们之所以做企业版，是因为当时很多公司开始禁用我们，因为他们觉得（无论对错）隐私和部署方案还不成熟。我当时想：“天哪，我们必须做点什么，否则会错过一个构建办公产品的代际机会。”我们对 AGI 的定义就是在具有经济价值的工作中超越大多数人类。所以我觉得我们必须出现在那里。当时这是一个很快的决定，但它已经长成了一门巨大的生意。我们的企业订阅用户刚从一两个月前的 300 万增长到了 500 万。它就像一个有了自己生命的衍生品，我对此非常兴奋。

---

### [00:44:11] Lenny Rachitsky

**English:**
That is a lot to be handling the platform essentially the API, the consumer product, the fastest-growing, most successful product in history and also the B2B side, which is clearly a massive business. Do you have any kind of heuristics for how to make these trade-offs do all this at once and stay sane and be successful?

**中文翻译:**
要同时处理平台（API）、历史上增长最快的消费级产品，还有显然规模巨大的 B2B 业务，这确实太多了。你有什么启发式的方法（heuristics）来做权衡，同时处理这么多事还能保持理智并取得成功吗？

---

### [00:44:30] Nick Turley

**English:**
That a good question. And first off, I don't run the developer stuff anymore. We found someone way more competent to do that and he's amazing. So, I still look after the various forms of chat, but luckily you don't have to make that trade-off OpenAI does. And I can get into that too, but it keeps me a little bit more sane. I will say that you kind of have to practice in two different ways when you're building on this AI stuff. One is sort of working backwards from the model capabilities and that is much more art than science, where I think you really need to look at what tech do we have available and what is the most awesome way to productize it? And if you applied to some sort of PM framework to that, I think you would do something horrible wrong. Because if you have tech that's, for example, GPT-5 is really, really good at front-end coding now, I think that means you've got to reprioritize it.

**中文翻译:**
好问题。首先，我不再负责开发者业务了，我们找到了更胜任的人。所以我现在主要负责各种形式的“对话”。幸运的是，这种权衡是 OpenAI 整体在做的，而不是我个人。这让我保持了理智。我想说，在构建 AI 产品时，你必须以两种不同的方式进行实践：一种是根据模型能力进行“逆向推导”，这更多是艺术而非科学。你需要看我们现有的技术，以及如何以最酷的方式将其产品化。如果你套用某种 PM 框架，可能会错得离谱。因为如果你有了新技术，比如 GPT-5 现在非常擅长前端编程，这意味着你必须重新调整优先级。

---

### [00:45:27] Nick Turley

**English:**
You got to actually bring that capability to life. Maybe that's making ChatGPT better at vibe coding and rendering applications. Maybe that's more like leveraging the taste of the model to make the UI more expressive. There's a number of things we could do, but you kind of have to replan and reprioritize and that is more important than any particular audience segmentation. It's really just looking at what is the magic thing we have and how do you make it shine. Voice is a similar thing. It wasn't like our customers need voice, they're begging for it or something like that. It was like, "Wow, we figured out a way how to make these things anything in, anything out." What is a creative awesome way to productize that and then we can see what people do. So, I think that's one chunk of it. But then the other chunk of it really is more like classic product management where you need to listen to customers and then when your customers are really different, that can be confusing because ChatGPT is a very general purpose product.

**中文翻译:**
你必须让这种能力落地。也许是让 ChatGPT 更擅长“凭感觉编程”和渲染应用，也许是利用模型的品味让 UI 更有表现力。我们可以做很多事，但你必须重新规划优先级，这比任何特定的受众细分都重要。本质上就是看我们手里有什么“魔法”，以及如何让它发光。语音功能也是如此，并不是客户求着我们要语音，而是我们发现：“哇，我们找到了一种方法让这些东西实现‘全能输入、全能输出’。”那么，如何以创意的方式将其产品化？然后看用户怎么用。这是其中一块。另一块更像经典的产品管理：倾听客户。当你的客户群非常多元时，这可能会让人困惑，因为 ChatGPT 是一个非常通用的产品。

---

### [00:46:23] Nick Turley

**English:**
We see when you look at end users, there's actually an immense amount of overlap in terms of what they want. Primitives like projects or history search or sharing and collaboration, all those kinds of things. They are actually very, very present. Whether or not you're talking to people at work or you're talking to people at home, at school, there's slightly different mechanics sometimes, but they're largely similar investments that I think we can get a lot of mileage out of. And then there's Enterprise-specific work that we just have to do. You've got to do HIPAA, you got to do SOC 2, you've got to do all those things if you want to be a serious player. And those are just non-negotiable. So, it's complex as you correctly identified, but it's kind of the curse of working on a very open-ended and powerful technology.

**中文翻译:**
我们发现，不同终端用户想要的东西其实有大量重叠。像“项目”（projects）、历史搜索、分享与协作等基础功能，需求非常普遍。无论是在工作、家里还是学校，虽然机制略有不同，但投入的方向大同小异。当然，还有一些企业版特有的工作必须做，比如 HIPAA 医疗合规、SOC 2 认证，如果你想成为严肃的玩家，这些是不可逾越的。所以，正如你所说，这很复杂，但这也是开发一种极其开放且强大的技术的“代价”。

---

### [00:47:11] Nick Turley

**English:**
One analogy that someone at OpenAI who I really respect, he's like, "We're kind of like Disney, where Disney has this one kind of creative IP, which is their content, and they have cruises and they have theme parks and they have comics and they have all these different things." And I think we have amazing models, but there's all these different ways that you can productize them and we kind of just have to maximize the impact in all these different ways.

**中文翻译:**
OpenAI 一位我非常尊敬的同事打过一个比方：“我们有点像迪士尼。迪士尼有一种核心创意 IP，就是他们的内容，然后他们有邮轮、主题公园、漫画等等。”我认为我们拥有惊人的模型，但有各种不同的方式可以将其产品化，我们必须在所有这些方向上最大限度地发挥影响力。

---

### [00:47:38] Lenny Rachitsky

**English:**
As you were talking, I was thinking about how usually horizontal platforms that are just so general and can do so much take a long time to take off because people don't know what to do with them. They're not amazing at anything. And this is an amazing counter example where it took off immediately and everyone figured it out and then over time they figured it out more and more.

**中文翻译:**
听你说话时我在想，通常那些非常通用、无所不能的水平平台（horizontal platforms）需要很长时间才能起步，因为人们不知道拿它们做什么，它们在任何特定领域都不出众。而这是一个惊人的反例：它立即爆发，每个人都搞清楚了怎么用，而且随着时间推移，大家用得越来越溜。

---

### [00:47:54] Nick Turley

**English:**
But I think the reason why is because it just went live. Talk about another consequential decision actually. We were debating waitlist, no waitlist because we-

**中文翻译:**
我觉得原因在于它直接上线了。说起另一个影响深远的决定：我们当时在争论要不要搞“候补名单”（waitlist），因为我们——

---

### [00:48:00] Nick Turley

**English:**
Actually we were debating waitlist/no waitlist because we really knew we couldn't scale the engineering systems. And the fact that there was no waitlist, which no open AI release had worked like that before, ended up being consequential because you were able to watch what everyone else was doing live. So I think when you launch these things all at once for everyone, there really is a special moment where you can see what other people are doing and learn from that.

**中文翻译:**
实际上我们当时在纠结要不要搞候补名单，因为我们知道工程系统无法承受大规模扩展。但最终决定不搞候补名单（这在 OpenAI 以前的发布中从未有过），结果证明这影响巨大，因为你可以实时看到其他人在做什么。我认为当你一次性向所有人发布这些东西时，会产生一个特殊的时刻，你可以观察并学习他人的用法。

---

### [00:48:25] Nick Turley

**English:**
And a lot of that is actually out of product. There's these crazy TikTok posts that go viral and they have like 2, 000 use cases in the comments. And I go through those in detail because it's not like I knew about those use cases either. They're very, very emergent and I just go through the comments and process because there's so much to learn. And for that reason, I think we get to skip the empty box problem a little bit because so much learning is happening out of product as people are watching each other either in IRL or online.

**中文翻译:**
很多学习其实发生在产品之外。TikTok 上有很多疯传的帖子，评论区里有 2000 多个用例。我会仔细看这些评论，因为我以前也不知道这些用法。它们是非常“涌现”的，我通过阅读评论来吸收，因为有太多可以学习的东西。因此，我认为我们稍微避开了“空盒子问题”（empty box problem），因为当人们在现实或网上互相观察时，大量的学习已经在产品之外发生了。

---

### [00:48:55] Lenny Rachitsky

**English:**
That is so interesting because you think about Airtable, you think about Notion, all these companies, they took years to just build and craft and think and go deep on what it could be.

**中文翻译:**
这很有趣，因为你想想 Airtable、Notion 这些公司，他们花了数年时间去构建、打磨、思考，深入挖掘产品的可能性。

---

### [00:49:04] Nick Turley

**English:**
It's like they compare Airtable, which they had to do templates, they had to do all these kind of things of taking the horizontal product and making it use case driven. They compare it to the Instant Pot, which there's recipes being shared everywhere online. There's this whole ecosystem around it. I think we were really lucky with ChatGPT that that happened where there's just users sharing use cases with other users everywhere. And therefore I think we got very lucky by jumping ahead on that journey.

**中文翻译:**
有人把 Airtable 比作需要做模板、做各种引导才能把水平产品变成用例驱动的产品。而把我们比作“多功能压力锅”（Instant Pot），网上到处都在分享食谱，围绕它有一个完整的生态系统。我觉得 ChatGPT 非常幸运，到处都有用户在互相分享用例。因此，我们很幸运地在那段旅程中实现了跳跃式前进。

---

### [00:49:40] Lenny Rachitsky

**English:**
And it feels like a quarter there is Sam had big following and everyone would pay attention to something you launch. So that's a really interesting new strategy for launching horizontal product. With a huge distribution channel, just launch it and see what comes up.

**中文翻译:**
感觉部分原因也是萨姆有很多粉丝，每个人都会关注你们发布的东西。所以这是一种很有趣的发布水平产品的新策略：利用巨大的分发渠道，直接发布，然后看会发生什么。

---

### [00:49:51] Nick Turley

**English:**
Yeah. And of course I'm actually really excited to take some of that into the product. I think we shouldn't rest on the fact that there's so much out product discovery happening. I actually think for the average consumer, it would be amazing if the product did a little bit more work on really exposing to you what is possible.

**中文翻译:**
是的。当然，我也很兴奋能把这些发现带回产品中。我认为我们不该止步于“产品外有很多发现”这一事实。我其实觉得，对于普通消费者来说，如果产品能多做一点工作，真正向你展示它的可能性，那就太棒了。

---

### [00:50:07] Nick Turley

**English:**
I still feel like ChatGPT feels a little bit like MS-DOS, like we haven't built Windows yet. And it'll be obvious once we do, but there's something that feels a little bit like... Imagine MS-DOS had gone viral and you were just trying to hack little conversation starters onto it. That might've missed sort of the big picture in terms of how to really communicate affordances and value to people. And so I think there's actually a ton more product work to do in addition to just seeing use cases spread.

**中文翻译:**
我仍然觉得 ChatGPT 有点像 MS-DOS，我们还没做出 Windows。一旦做出来，一切都会变得显而易见。想象一下如果 MS-DOS 走红了，你只是在上面打补丁加一些对话引导。这可能会错过大局——即如何真正向人们传达产品的“可供性”（affordances）和价值。所以我觉得除了观察用例传播，还有大量的业务工作要做。

---

### [00:50:33] Nick Turley

**English:**
Are you able to share just what you think that might look like? This Windows version of ChatGPT?

**中文翻译:**
你能分享一下你认为那会是什么样子吗？那个“Windows 版”的 ChatGPT？

---

### [00:50:37] Nick Turley

**English:**
I'll let you know when we figure it out. We're hiring. I think there's so many interesting product problems here.

**中文翻译:**
等我们搞清楚了再告诉你。我们在招人。这里有很多有趣的产品问题。

---

### [00:50:42] Lenny Rachitsky

**English:**
Okay, got it. By the way, I also love that TikTok was like your feedback channel.

**中文翻译:**
好，明白了。顺便说一句，我也很喜欢 TikTok 成了你们的反馈渠道这一点。

---

### [00:50:49] Nick Turley

**English:**
Those common threads, they're just so wild. And also the love that people have for it, the excitement with which you're sharing their product, I feel like it's special that people are so excited to share what they're doing with your product. And I don't take that for granted either.

**中文翻译:**
那些评论串真的很疯狂。还有人们对它的喜爱，以及分享产品时的兴奋感。我觉得人们如此热衷于分享他们用你的产品做了什么，这很特别。我不会觉得这是理所当然的。

---

### [00:51:06] Lenny Rachitsky

**English:**
This episode is brought to you by PostHog, the product platform your engineers actually want to use. PostHog has all the tools that founders, developers, and product teams need, like product analytics, web analytics, session replays, heat maps, experimentation, surveys, LLM observability, air tracking and more. Everything PostHog offers comes with a generous free tier that resets every month. More than 90% of customers use PostHog for free. You are going to love working with a team this transparent and technical. You'll see engineers landing pull requests for your issues and their support team provides code level assistance when things get tricky. PostHog lets you have all your data in one place. Beyond analytics events, their data warehouse enables you to sync data from your Postgres database, Stripe, HubSpot, S3, and many more sources. Finally, their new AI product analyst, Max AI, helps you get further faster, get help building complex queries and setting up your account with an expert who's always standing by. Sign up today for free at PostHog.com/lenny and make sure to tell them Lenny sent you. That's posthog.com/lenny.

**中文翻译:**
本集节目由 PostHog 赞助。PostHog 是工程师真正想用的产品平台。它拥有创始人、开发者和产品团队所需的所有工具，如产品分析、Web 分析、会话重放、热力图、实验、调查、LLM 可观测性、错误追踪等。PostHog 提供丰厚的每月重置免费额度，超过 90% 的客户免费使用。你会喜欢与这样一个透明且技术导向的团队合作。PostHog 让你将所有数据集中在一处，其数据仓库支持同步来自 Postgres、Stripe、HubSpot、S3 等来源的数据。最后，他们新的 AI 产品分析师 Max AI 能帮你更快完成复杂查询。立即在 PostHog.com/lenny 免费注册。

---

### [00:52:13] Lenny Rachitsky

**English:**
How do you find emerging use cases these days? I imagine the volume is very high. Do you have kind of a trick for figuring out, "Oh, here's a new thing we should really think about?"

**中文翻译:**
你现在是如何发现新兴用例的？我猜量一定很大。你有什么诀窍来发现“噢，这是一个我们该认真考虑的新东西”吗？

---

### [00:52:22] Nick Turley

**English:**
Before I built the product team, I actually built the data science team because I was getting frustrated. I was talking to as many users as I could. And my calendar the weeks after ChatGPT, it was just 15 minute user interview the whole week through. It was usually I stopped doing interviews when I can predict what the next person's going to say. That's how I know I've talked to enough users, but it just wasn't happening. I just kept getting new stuff.

**中文翻译:**
在组建产品团队之前，我其实先组建了数据科学团队，因为我当时很沮丧。我尽可能多地与用户交谈。ChatGPT 发布后的几周，我的日程表全是 15 分钟一轮的用户访谈。通常当我能预判下一个人要说什么时，我就会停止访谈，因为那意味着聊够了。但当时这种情况一直没发生，我总能听到新东西。

---

### [00:52:46] Nick Turley

**English:**
So data is one way out where I think we have conversation classifiers that without us having to look at the conversations, allow us to figure out what are people talking about, what use cases are taking off, et cetera. And I think that's very, very helpful. The quality of the stuff is important for empathy. Even though you're never going to get a rap on all the use cases people have, I still spend a huge amount of my time doing that. And then yeah, things like those TikToks, collections of threads, I think they're really, really useful. It's just fun to watch people talk to each other about the various use cases that they have.

**中文翻译:**
所以数据是一个出路。我们有对话分类器，无需查看具体对话内容，就能帮我们弄清楚人们在聊什么、哪些用例正在兴起。这非常有帮助。内容的质量对于建立同理心很重要。虽然你永远无法掌握所有用例，但我仍花大量时间去做这件事。还有那些 TikTok 视频、评论串，它们真的非常有用。看人们互相讨论各种用例很有趣。

---

### [00:53:22] Lenny Rachitsky

**English:**
Is there kind of a new margin use case that you're excited about or is there a really unusual use of ChatGPT that you think about that'd be fun to share?

**中文翻译:**
有没有什么让你兴奋的新兴边缘用例，或者有什么非常不寻常的 ChatGPT 用法值得分享？

---

### [00:53:30] Nick Turley

**English:**
I mentioned this earlier, but I had always conceptualized ChatGPT as a worky product, whether or not you're at home or you at work. I feel like getting help with your taxes is very similar to the types of things you do at work where planning a trip is actually very similar to planning an event for work. So I always felt like, "Okay, this thing is going to kind of be a productivity tool."

**中文翻译:**
我之前提到过，我一直把 ChatGPT 构想为一个“偏工作”（worky）的产品，无论你是在家还是在公司。我觉得找它帮处理税务，或者计划旅行，其实跟在公司策划活动非常相似。所以我一直觉得：“好吧，这东西会是一种生产力工具。”

---

### [00:53:51] Nick Turley

**English:**
And I think something has happened, I realized, a few months where that has begun to change and I really do think the fact that you have consumers turning to this thing for day-to-day advice, helping them have better relationships... People talk about how this thing saved their marriage is really exciting to me because they use it to process their own emotions, get feedback on their communication style. They just have a buddy to talk to about really difficult things. And that comes with a ton of responsibility and work that we have to do to make those things like life advice great, but it also is really, really important to me because you can't run away from those use cases. You have to run towards them and make them awesome. And that's part of what we're trying to do. So that emergent behavior is really, really cool.

**中文翻译:**
但我意识到，几个月前情况开始发生变化。我发现消费者开始转向它寻求日常建议，甚至帮他们改善人际关系……有人说这东西挽救了他们的婚姻，这让我非常兴奋。他们用它来处理自己的情绪，获取关于沟通风格的反馈。他们就像有了一个可以倾诉困难之事的伙伴。这伴随着巨大的责任，我们需要做很多工作来让“生活建议”这类功能变得出色。但对我来说这非常重要，因为你不能逃避这些用例，你必须迎难而上把它们做好。这种涌现出的行为真的很酷。

---

### [00:54:41] Nick Turley

**English:**
And more broadly, I'm so excited about education. I'm so excited about health. I think it would really be a waste if we didn't take the opportunity of using ChatGPT to really, really help people. And I think we've just begun to scratch the surface on that. So there's many aspirational use cases that I want to make happen.

**中文翻译:**
更广泛地说，我对教育和健康领域感到非常兴奋。如果我们不利用 ChatGPT 去真正帮助人们，那真的是一种浪费。我觉得我们才刚刚触及皮毛。有很多令人向往的用例我想去实现。

---

### [00:55:05] Lenny Rachitsky

**English:**
Along those lines, an interesting use case I've recently had, I feel like it's going to be really helpful for couples that are disagreeing about something when they need a third opinion. I just had this recently where my wife's like, "You can't heat a whole thing that you're going to only eat part of in the microwave and then put it back in the fridge." It's like, "What's the problem? I'll heat it up, I'll put it back in the fridge." And she's like, "No, that's really dangerous." I'm like, "Let's ask ChatGPT." And that fact that she so trusts ChatGPT now and relies on it throughout the day, it's such a valuable third independent party that we can go to.

**中文翻译:**
顺着这个思路，我最近有一个有趣的用例：当夫妻对某事有分歧需要第三方意见时，它非常有用。最近我妻子说：“你不能把一整份东西放进微波炉加热，只吃一部分，然后又放回冰箱。”我说：“有什么问题？我热一下，再放回去。”她说：“不，那很危险。”我说：“咱们问问 ChatGPT 吧。”事实是她现在非常信任 ChatGPT，整天依赖它，它成了一个非常有价值的、我们可以求助的独立第三方。

---

### [00:55:35] Nick Turley

**English:**
Yeah, yeah, totally. And a lot of those micro-interactions talk about interesting product work, right? Those are micro-interactions that are important. Did it definitively weigh in or did it help you guys think through that disagreement and solve it on your own? I think those details actually matter a lot and it's where we're spending a bunch of time.

**中文翻译:**
没错。很多这类微交互（micro-interactions）涉及有趣的产品工作。它是给出了定论，还是帮你们理清分歧并自行解决？我认为这些细节非常重要，也是我们投入大量时间的地方。

---

### [00:55:54] Lenny Rachitsky

**English:**
Along those lines, there was this whole launch of the very sycophantic version of ChatGPT where it was just, " You are the best person in the world. Everything you tell me is amazingly correct." Are you able to tell us just what happened there?

**中文翻译:**
说到这，之前发布过一个非常“谄媚”（sycophantic）版本的 ChatGPT，它只会说：“你是世界上最好的人，你说的每句话都对极了。”你能告诉我们当时发生了什么吗？

---

### [00:56:08] Nick Turley

**English:**
Yeah, we have all kinds of collateral online because we really felt like we should over-communicate on how we discovered it, what we did about it, et cetera. So I encourage people to check that out. We have a whole retro on that model release.

**中文翻译:**
是的，我们在网上发布了各种资料，因为我们觉得应该就如何发现它、如何处理它等进行过度沟通。我鼓励大家去看看，我们对那个版本的发布做了一个完整的复盘。

---

### [00:56:24] Nick Turley

**English:**
But basically what happened is that we pushed out an update that made the model more likely to tell you things that sound good in the moment, "You're totally right. You should break up with your boyfriend" or something like that. That's just really dangerous. We took it more seriously than you even might expect because again, at current technology levels, you can kind of laugh about it. Maybe it's like, "Ha-ha. This thing's always complimenting me. I thought it was just me. I saw all those comments online." But it actually is really important to make sure that these models are optimized for the right things.

**中文翻译:**
基本上发生的情况是，我们推送了一个更新，让模型更倾向于说一些当下听起来好听的话，比如“你完全正确，你应该跟男朋友分手”之类的。这非常危险。我们对此的重视程度可能超出你的想象。虽然在目前的技术水平下，你可能会一笑了之，觉得“哈哈，这家伙总是在夸我”。但确保这些模型针对正确的目标进行优化其实非常重要。

---

### [00:57:01] Nick Turley

**English:**
And we have an immense, I think, luxury to have a mission that affords us to really help people, a business model that does not incentivize maximizing engagement or time spent in the product, right? So it's really important to us that you feel like this product is helping you with your goals, whether not that's your current goals or even your long-term goals.

**中文翻译:**
我认为我们拥有一种巨大的奢侈：我们的使命是真正帮助人们，而我们的商业模式并不鼓励最大化用户参与度或在产品中停留的时间。所以对我们来说，让你觉得这个产品在帮你实现目标（无论是短期还是长期目标）至关重要。

---

### [00:57:25] Nick Turley

**English:**
And oftentimes being extremely complimentary with the user isn't actually in service of that. So we instilled new measurement techniques. Whenever we put these models in contact with reality and we learn about a problem, we actually go back and make sure we have good metrics for this stuff. So we measure sick efficiency now with every release to make sure we don't regress and actually improve on that metric. GPT-5 is an improvement, which is really exciting for me, but we have more work from there.

**中文翻译:**
通常，对用户极度奉承并不能服务于那个目标。所以我们引入了新的衡量技术。每当我们让模型接触现实并发现问题，我们都会回头确保有好的指标来衡量。现在我们每次发布都会衡量“谄媚度”（sycophancy），确保不会退步。GPT-5 在这方面有所改进，这让我很兴奋，但我们还有更多工作要做。

---

### [00:57:54] Nick Turley

**English:**
And more broadly, it caused us to articulate our point of view. I actually spent a bunch of time on a blog post that we just published on Monday on what we're optimizing ChatGPT for. And it really is to help you thrive and achieve your goals, not to keep you in the product. And so there was a bunch of good outcomes from that incident. It's a good example of how contact for reality is not just important for the use cases, but also for learning what to avoid because you would've never discovered this issue purely in a lab unless you actually heard from physicians.

**中文翻译:**
更广泛地说，这促使我们阐明了自己的观点。我花了很多时间写了一篇周一发布的博文，关于我们正在优化 ChatGPT 的目标。目标是帮助你成长并实现目标，而不是把你留在产品里。所以那次事件带来了一些好的结果。这是一个很好的例子，说明接触现实不仅对发现用例很重要，对学习该避免什么也很重要——除非你听到用户的反馈，否则你永远无法在实验室里发现这种问题。

---

### [00:58:26] Lenny Rachitsky

**English:**
I am excited to read that blog post then. I was going to ask you this. Just like how you-

**中文翻译:**
我很期待读那篇博文。我正想问你这个。就像你——

---

### [00:58:29] Nick Turley

**English:**
Yeah, have your feedback on it.

**中文翻译:**
是的，期待你的反馈。

---

### [00:58:31] Lenny Rachitsky

**English:**
Yeah. I guess is there anything more there of just how you... Because this tension is so difficult, helping people feel supported, but not just letting them believe everything they want to believe. Is there anything more you can share there? Just trying to find that middle ground.

**中文翻译:**
是的。我想知道关于你如何处理这种张力是否还有更多可分享的？因为这很难：既要让人们感到被支持，又不能让他们只相信自己想相信的一切。在寻找中间地带方面，还有什么可以分享的吗？

---

### [00:58:43] Nick Turley

**English:**
Incentives are important. There is a famous saying, "Show me the incentive and I'll show you the outcome."

**中文翻译:**
激励机制很重要。有一句名言：“告诉我激励机制是什么，我就能告诉你结果是什么。”

---

### [00:58:48] Lenny Rachitsky

**English:**
Charlie Munger maybe?

**中文翻译:**
查理·芒格（Charlie Munger）说的？

---

### [00:58:49] Nick Turley

**English:**
Yeah, I think that's where it came from, right?

**中文翻译:**
是的，我想是出自他那里。

---

### [00:58:52] Nick Turley

**English:**
Yeah, I think that's very, very important. So I would take a good look at our mission, our business model, the type of product we're trying to build. And I really think that ChatGPT is a very special product because I think in vast majority of cases, it makes you leave it feeling better or not worse and feeling like you're achieving something you're trying to do. So I think that those incentives really matter because it helps you reason about, "Okay, when there isn't behavior in the wild, that's not good. Was that a bug or was that by design? And with [inaudible 00:59:29] I can very much say that to us that's a bug.

**中文翻译:**
是的，我认为这非常重要。看看我们的使命、商业模式和我们试图构建的产品类型。我真的认为 ChatGPT 是一个非常特殊的产品，因为在绝大多数情况下，它让你在离开时感觉更好（或者至少不更糟），并觉得你正在实现你想做的事。所以这些激励机制很重要，它能帮你推断：“好吧，当现实中出现不好的行为时，那是 Bug 还是设计使然？”我可以明确地说，对我们来说，那是 Bug。

---

### [00:59:31] Nick Turley

**English:**
And then on the forward-looking work, there's so many kind of challenging scenarios to get right. And you could easily run away from these use cases. Like you and your wife going to this thing for input on a relationship, a question or a dispute, you could very easily run away if you were totally risk avoidant and say, " Sorry, I can't help you with that." I think that's what most tech companies do when they hit a certain scale, they run away from these use cases. And I think it's a lost opportunity to help people.

**中文翻译:**
在展望未来的工作中，有很多具有挑战性的场景需要处理好。你很容易逃避这些用例。比如你和你妻子就关系问题或争执寻求建议，如果你完全规避风险，你可以轻易地说：“抱歉，我帮不了你。”我觉得大多数科技公司在达到一定规模后都会这么做，他们会逃避这些用例。我认为那是帮助人们的一个错失的机会。

---

### [01:00:08] Nick Turley

**English:**
So we want to run towards these use cases by making the model behavior really, really great. That can mean connecting you with external resources when you're struggling. That can mean not directly answering your question, but instead of giving you a helpful framework in the case of like, "Should I break up with my boyfriend?" ChatGPT should probably not answer that question for you, but it should help you think through that question in the way that a thoughtful companion would. So I think it's really important to do the work because I think the upside is immense.

**中文翻译:**
所以我们想通过让模型行为变得非常出色来迎接这些用例。这可能意味着当你挣扎时为你连接外部资源。这可能意味着不直接回答你的问题，而是给你一个有用的框架。比如“我该跟男朋友分手吗？”，ChatGPT 可能不该替你回答，但它应该像一个体贴的伙伴一样帮你思考。我认为做这些工作非常重要，因为潜在的好处是巨大的。

---

### [01:00:37] Lenny Rachitsky

**English:**
That is a really profound point you're making there, that if most companies, if their users want to ask them something risky like getting medical advice or, "Should I break up with my partner?" or, "what should I do with this big problem I have?"

**中文翻译:**
你提出了一个非常深刻的观点。大多数公司如果遇到用户问医疗建议、分手建议或重大难题等风险问题，都会退缩。

---

### [01:00:51] Nick Turley

**English:**
I feel like we would have immense regret if you had a model that was state-of-the-art on health bench, which is, GPT-5 is a state of the art on a bunch of these medical benchmarks, and you didn't use that to help people, you just disabled that use case because you wanted to avoid all possible downside. I think the duty is to make it awesome and to do the work, talk to experts, figure out how good it really is, where it breaks down, communicate that. And I think this technology is too important and has too much potential positive impact on people to run away from these high stakes excuses.

**中文翻译:**
我觉得如果我们有一个在健康基准测试中达到顶尖水平的模型（GPT-5 在多项医疗基准测试中都是顶尖的），却因为想规避所有潜在风险而禁用这个用例，不让它去帮助人们，我们会感到巨大的遗憾。我认为职责在于把它做好，去做研究，咨询专家，弄清楚它到底有多好，哪里会出错，并沟通清楚。这项技术太重要了，对人类有太多潜在的积极影响，不能因为风险高就逃避。

---

### [01:01:27] Lenny Rachitsky

**English:**
And fast-forward to today, it's saving lives regularly. It's probably saving relationships regularly. Such a consequential decision, which I imagine was made early on.

**中文翻译:**
快进到今天，它经常在救人命，可能也经常在挽救人际关系。这是一个影响深远的决定，我猜是很早就做出的。

---

### [01:01:36] Nick Turley

**English:**
Yeah. We're just at the beginning of watching how this stuff can transform people. It's incredibly democratizing. If you compare, you roll out of this with the roll out of the personal computer, computers were so scarce when they first came out. And this stuff is ubiquitous in a way where you have access to a second opinion on medical stuff, you have access to a relationship buddy, you have access to a personal tutor on literally any topic that makes you curious. It's really, really special that we get to do that. Unique point in history.

**中文翻译:**
是的。我们才刚刚开始观察这些东西如何改变人类。它具有惊人的民主化作用。如果把这与个人电脑的普及相比，电脑刚出来时非常稀缺。而现在这些东西无处不在，你可以获得医疗方面的第二意见，可以有一个情感伙伴，可以有任何领域的私人导师。能做这些事真的很特别。这是历史上的一个独特时刻。

---

### [01:02:15] Lenny Rachitsky

**English:**
Let me zoom out a bit and talk about OpenAI and just product in general. So you've worked at traditional, let's say traditional product companies, Dropbox, Instacart. Now you're at OpenAI. What's maybe the most counterintuitive lesson you've learned by building products from your time at OpenAI?

**中文翻译:**
让我们放大一点，聊聊 OpenAI 和一般意义上的产品。你曾在传统的产品公司工作过，比如 Dropbox 和 Instacart。现在你在 OpenAI。在 OpenAI 构建产品的过程中，你学到的最反直觉的教训是什么？

---

### [01:02:33] Nick Turley

**English:**
Each time I always tried to pick the maximally different job whenever I made a job change. So after Dropbox, I was craving a real world product because it was just so different than working on SaaS, et cetera. And after Instacart, I was craving on working on something that intellectually was interesting and had this kind of invoked the nerd in me. And so I've always looked for things that are really different.

**中文翻译:**
每次换工作，我都会尽量选择一个完全不同的职位。在 Dropbox 之后，我渴望做现实世界的产品，因为那与 SaaS 完全不同。在 Instacart 之后，我渴望做一些在智力上有趣、能激发我内心“极客”属性的东西。所以我一直在寻找差异巨大的事物。

---

### [01:02:59] Nick Turley

**English:**
And then once I showed up at these places, I tried to understand what makes that place successful, what is truly the thing that they cracked and how we can lean in that into that even more. I think I spent a lot of time thinking about this with OpenAI, especially after ChatGPT. Before that it was kind of a moot point because we didn't really have much revenue or products or anything like that. There's a few things that come to mind that have driven many decisions. One is the empiricism. We talked about that a bit. The fact that you can only find out by shipping, which is why maximally lean into that. And that's a huge part of why we ship so much.

**中文翻译:**
一旦我进入这些地方，我会试着理解是什么让这里成功，他们到底攻克了什么，以及我们如何进一步发扬光大。在 OpenAI，我花了很多时间思考这个问题，特别是在 ChatGPT 之后。在那之前这没什么意义，因为我们没啥营收或产品。有几件事驱动了许多决定。一是“经验主义”（empiricism）。我们聊过这个：你只有通过发布才能发现真相，这就是为什么我们要最大限度地倾向于发布。这是我们发布如此频繁的重要原因。

---

### [01:03:46] Nick Turley

**English:**
One of them is that amazing ideas come from anywhere. The thing about running a research lab is you really don't tell people what to research. That's not what you do. And we inherited that culture even as we become a research and product company. So just letting people do things who have amazing ideas rather than being the gatekeeper or prioritizer of everything or something like that has been proven immensely valuable to us. And that's where much of the innovation comes from, is empowered smart people on any function really. So that was a good inheritance from what I think made OpenAI successful and makes us successful.

**中文翻译:**
另一个是“伟大的点子可以来自任何地方”。运营研究实验室的特点是你不会告诉人们去研究什么。即使我们现在成了研究加产品的公司，我们也继承了这种文化。让有伟大点子的人去做事，而不是充当守门人或优先级掌控者，这对我们非常有价值。大部分创新都来自任何职能部门中被赋能的聪明人。这是 OpenAI 成功基因的一个很好的继承。

---

### [01:04:23] Nick Turley

**English:**
The interdisciplinariness of really making sure that you put research and engineering and design and product together rather than treating them as silos. I think that's the thing that has made us successful and that you see come through in every product we ship. Like if we're shipping a feature and it doesn't get 2X better as the model gets 2X smarter, it's probably not a feature we should be shipping. Not always true. SOC 2 doesn't get better with [inaudible 01:04:48] models, but I think for many of the core capabilities, that's a good litmus test.

**中文翻译:**
还有“跨学科性”，确保将研究、工程、设计和产品结合在一起，而不是把它们当成孤岛。我认为这是让我们成功的关键，你在我们发布的每个产品中都能看到这一点。比如，如果我们发布一个功能，但它没有随着模型变聪明 2 倍而变得好用 2 倍，那它可能就不值得发布。当然不绝对，SOC 2 合规不会随模型变强而变好，但对于核心能力，这是一个很好的试金石。

---

### [01:04:52] Nick Turley

**English:**
So I've always found you really have to lean into why is this place successful and then maximally accelerate that, so to speak, because it's what allows you to turn something that feels like an accident into something that is a repeatable label.

**中文翻译:**
所以我发现你必须深入挖掘一个地方成功的原因，然后“最大限度地加速”它，因为这能让你把某种感觉像是偶然的成功变成可重复的标签。

---

### [01:05:07] Lenny Rachitsky

**English:**
So you talked about this kind of collaboration between researchers and product people. And you've been at the beginning of ChatGPT from day one to today, from zero to 700 million weekly active users. Not just registered users, weekly active users. How have you approached building out that team over time?

**中文翻译:**
你谈到了研究人员和产品人员之间的这种协作。你从第一天起就参与了 ChatGPT，见证了它从零增长到 7 亿周活跃用户（不只是注册用户，是周活）。随着时间的推移，你是如何组建这个团队的？

---

### [01:05:24] Nick Turley

**English:**
One of the other inheritances of being in a research lab is that you take recruiting really seriously. That's something that AI labs know every person matters. But many tech companies that go through hyper growth and they kind of lose their identity, they lose their talent bars, they just have chaos. So we've always had this tendency to run relatively lean.

**中文翻译:**
作为研究实验室的另一个继承是，你会非常严肃地对待招聘。AI 实验室知道每一个人都至关重要。许多经历超速增长的科技公司会迷失自我，降低人才标准，陷入混乱。所以我们一直倾向于保持相对精简的团队。

---

### [01:05:51] Nick Turley

**English:**
So it is a small team that is running ChatGPT. I take co inspiration from WhatsApp where it was a very small team running a very global-scale product. And then more importantly, you have to treat hiring a little bit more like executive recruiting and less like just pure pipeline recruiting where you really need to understand what is the gap you're trying to fill on each team, what is the specific skill set and how do you fill it.

**中文翻译:**
所以运营 ChatGPT 的是一个小团队。我从 WhatsApp 那里获得了灵感，他们用极小的团队运营着全球规模的产品。更重要的是，你必须把招聘看作是“高管猎头”式的，而不是纯粹的“流水线招聘”。你需要真正理解每个团队需要填补什么空白，具体的技能要求是什么，以及如何填补。

---

### [01:06:17] Nick Turley

**English:**
To give you an example, I'm a product person at heart, but sometimes a team doesn't need a product person because there's already someone doing that role. In many cases, we have a really talented engineering leader who has amazing product sense, or we have a researcher who has product ideas. And in my mind they can play that role. And maybe we have something else missing instead. Maybe we need a little bit more front-end or something like that.

**中文翻译:**
举个例子，我骨子里是个产品人，但有时一个团队不需要专门的产品经理，因为已经有人在承担那个角色了。很多情况下，我们有非常有才华的工程主管，他有极佳的产品感；或者我们有很有产品想法的研究员。在我看来，他们就能扮演那个角色。也许我们缺的是别的，比如多一点前端开发之类的。

---

### [01:06:41] Nick Turley

**English:**
In other cases, maybe what you're missing is incredible data scientists. So I really like to go through every single team and figure out what is the skill sets that that team needs and how do you put it together from principles rather than just assuming, "Hey, we're going to do a bunch of pipeline recruiting for all these different roles" and then people will find a team later. So I think that's always felt really important to me. And it's the way that you keep your team really small, yet super high throughput.

**中文翻译:**
在其他情况下，也许你缺的是顶尖的数据科学家。所以我喜欢梳理每一个团队，弄清楚他们需要的技能组合，并从基本原则出发进行组建，而不是假设“嘿，我们要为这些职位招一堆人，然后让他们以后自己找团队”。我觉得这对我来说一直很重要。这也是保持团队精简且高产出的方法。

---

### [01:07:08] Nick Turley

**English:**
It also allows you to hire people who I think Keith Rabois calls us like barrels, I think. [inaudible 01:07:15] barrel's an ammunition where he thinks... I think this comes from him, but the idea being that sort of the throughput of your org depends on how many barrels you have, which is people who can make stuff happen. And then you can add ammunition around them, which is people helping those people. I think that's been really true for our recruiting too where we try to maximize the number of empowered people who can ship because that's how you have a small team and still get the ton done.

**中文翻译:**
这也能让你招到 Keith Rabois 所说的“枪管”（barrels）型人才。这个理论大概是：组织的产出取决于你有多少个“枪管”——即那些能让事情发生的人。然后你可以在他们周围增加“弹药”，即协助他们的人。这对我们的招聘非常适用：我们努力最大化那些被赋能且能发布产品的人的数量，因为这就是小团队能干大事的秘诀。

---

### [01:07:43] Nick Turley

**English:**
So there's a couple of things, and I spent a lot of time on vibes too with each team because I think one of the things that is challenging when you try to do research and product together is that the cultures are different. People have different backgrounds. And I think to make that go super well, you need to spend time team building and making sure that people have a huge amount of trust for each other's skill sets, feel like they can think across their boundaries. I really believe that product is everyone's job, for example. And for that reason, the recruiting doesn't stop when the people are on the door. It actually starts because you have to start making the teams awesome.

**中文翻译:**
还有几件事，我花了很多时间在每个团队的“氛围”上。因为当你试图把研究和产品结合在一起时，挑战在于文化不同，背景不同。为了让合作顺畅，你需要花时间进行团队建设，确保大家对彼此的技能有极大的信任，并能跨越边界思考。例如，我坚信“产品是每个人的工作”。因此，招聘并不在人进门那一刻结束，而是刚刚开始，因为你必须开始打造卓越的团队。

---

### [01:08:24] Lenny Rachitsky

**English:**
Is there something you do with team building that would be fun to share? Just like something you do to create [inaudible 01:08:28]?

**中文翻译:**
在团队建设方面，有什么有趣的事情可以分享吗？比如你如何创造（听不清）？

---

### [01:08:28] Nick Turley

**English:**
I just love whiteboarding with teams. I just love getting into a generative mindset. It breaks down everything. So that's the thing that I try. It's not particularly creative, but I found it to be a universal tool where the minute you can get people to stop thinking about what's my job versus the other person's job and more like we're all in a room trying to crack something together, that is incredible.

**中文翻译:**
我就是喜欢和团队一起画白板。我喜欢进入一种“生成式”的思维模式，这能打破一切隔阂。这就是我尝试的方法。虽然没什么特别的创意，但我发现它是一个通用工具：一旦你能让大家不再想“这是我的活还是他的活”，而是“我们都在这间屋子里试图一起攻克某个难题”，那种感觉太棒了。

---

### [01:08:50] Lenny Rachitsky

**English:**
You mentioned this idea of first principles. This came up actually when I talk to a bunch of people about you, is this something you're really big on. A lot of people talk about first principles, most people are like, " I don't really understand," or they think they're amazing at thinking from first principles. Is there something you can share of just what it actually looks like to think from first principles as maybe an example that comes to mind where you really went to first principles and came up with something unexpected?

**中文翻译:**
你提到了“第一性原理”（first principles）。我跟别人聊起你时，他们都说你非常看重这个。很多人都在谈第一性原理，但大多数人其实并不理解，或者自以为很擅长。你能分享一下从第一性原理出发思考到底是什么样子的吗？有没有什么例子，是你通过第一性原理得出了意想不到的结果？

---

### [01:09:15] Nick Turley

**English:**
Yeah, this is not something I'd ever say about myself. It's nice that someone else would say it, but it's a mysterious thing. Yeah, I think you just really got to get to ground truth on what you're really trying to solve. For example, as I mentioned with the recruiting thing, I'm not dogmatic that you have to have a product manager and an engineering manager and a designer or whatever. We're just trying to make an awesome team that can ship. So in that case, first principles means just really understanding what we actually need and what we're missing rather than applying a previously learned process or behavior. So I think that's a good example.

**中文翻译:**
是的，我从没这么评价过自己。别人这么说很好，但这确实是个挺玄乎的东西。我认为你必须触及你真正想解决的问题的“底层真相”。例如，我提到的招聘，我并不教条地认为你必须有一个 PM、一个工程经理和一个设计师。我们只是想打造一个能发布产品的优秀团队。在这种情况下，第一性原理意味着真正理解我们实际需要什么、缺什么，而不是套用以前学过的流程或行为。这是一个好例子。

---

### [01:09:54] Nick Turley

**English:**
Another good example of I think being first principles in this environment is, does this feature need to be polished? We get a lot of crap for the model chooser, and I own it. I've tried to say that to everyone who will listen. For those who don't know model chooser, it's this giant drop down in the product that is literally the anti-pattern of any good product traditionally.

**中文翻译:**
另一个在当前环境下的第一性原理例子是：这个功能需要打磨吗？我们因为那个“模型选择器”（model chooser）被骂得很惨，我承认那是我的锅。对于不知道的人来说，模型选择器就是产品里那个巨大的下拉菜单，从传统角度看，它简直是任何优秀产品的反面教材（anti-pattern）。

---

### [01:10:16] Nick Turley

**English:**
But if you are actually recent from scratch, is it better to wait until you got a polished product or to ship out something raw even if it makes less sense and start learning and getting into people's hands? I think a company with a lot of process or a lot of just learned behaviors will make one call, which is, we have a quality bar when we ship, and that's what we do. If your first principle is about it, I think you're like, "You know what? We should ship. It's embarrassing, but that's strictly less bad than not getting the feedback you wanted."

**中文翻译:**
但如果你从零开始思考：是等到产品打磨完美再发好，还是先发一个粗糙的东西（哪怕它看起来不太合理）并开始学习、让用户上手更好？我认为一个有很多流程或习惯性行为的公司会做出一种选择：我们有发布质量标准，必须达标。但如果你从第一性原理出发，你会觉得：“你知道吗？我们该发布。虽然很尴尬，但总比拿不到想要的反馈要好。”

---

### [01:10:51] Nick Turley

**English:**
So I think just approaching each scenario from scratch is so important in this space because there is no analogy for what we're building. You can't copy an existing thing. There is no, "Are we an Instagram or are we a Google or a productivity tool or something like that?" I don't know. But you can learn from everywhere, but you have to do it from scratch. And I think that's why that trait tends to make someone effective at OpenAI, and it's something we test for in our interviews too.

**中文翻译:**
所以我认为在这个领域，从零开始审视每个场景非常重要，因为我们正在构建的东西没有先例可循。你无法抄袭现有的东西。没有“我们是 Instagram 还是 Google 还是生产力工具”这种定论。你可以向任何地方学习，但你必须从头开始思考。我认为这就是为什么这种特质能让人在 OpenAI 变得高效，这也是我们在面试中会测试的一点。

---

### [01:11:23] Lenny Rachitsky

**English:**
So this theme keeps coming up, and I think it's just important to highlight something that you keep coming back to, which is this trade-off of speed and polish and how in this space, speed is more important, not just to stay ahead, but to learn what the hell people actually want to do with this thing. Is there anything more that you think people just may be missing about why they need to move so fast in the space of AI?

**中文翻译:**
这个主题一直在出现，我觉得有必要强调一下你反复提到的东西：速度与打磨之间的权衡。在这个领域，速度更重要，不仅是为了保持领先，更是为了搞清楚人们到底想拿这玩意做什么。关于为什么在 AI 领域必须跑得这么快，你觉得人们还忽略了什么吗？

---

### [01:11:46] Nick Turley

**English:**
Yeah. I mean, the boring answer would be, oh, it's competitive and everyone's in AI and they're trying to compete each other. I think that's maybe true, but that's not the reason that I believe this. The reason really is that you're going to be polishing the wrong things in the space. You absolutely should polish-

**中文翻译:**
是的。乏味的答案会是：竞争太激烈了，每个人都在做 AI，大家在互相竞争。这也许是对的，但这不是我坚信这一点的原因。真正的核心原因是：在这个领域，你可能会打磨错误的东西。你绝对应该打磨——

---

### [01:12:00] Nick Turley

**English:**
You're going to be polishing the wrong things in this space. You absolutely should polish things like the model output, et cetera, but you won't know what to polish until after you ship. And I think that is uniquely true in an environment where the properties of your product are emergent and not knowable in advance. And I think that many people get that wrong because they think the best product people tend to be craftspeople and they have a traditional definition of craft. I also think it would be easy to use all what I just said as an excuse not to eventually build a great product. So I often tell my teams that shipping is just one point on the journey towards awesomeness, and you should pick that point intentionally where it doesn't have to be the end of your iteration at all. It can be the beginning, but you better follow through.

**中文翻译:**
你绝对应该打磨模型输出之类的东西，但在发布之前，你根本不知道该打磨哪里。在产品属性是“涌现”的、无法预知的情况下，这一点尤为正确。很多人搞错了，因为他们认为最好的产品人应该是“手艺人”，并对“手艺”有传统的定义。我也认为，很容易把我刚才说的话当成“最终不做出好产品”的借口。所以我常告诉团队，发布只是通往卓越旅程中的一个点，你应该有意识地选择那个点，它完全不需要是迭代的终点。它可以是起点，但你最好能贯彻到底。

---

### [01:12:50] Nick Turley

**English:**
So we've been doing a bunch of work, especially over the last quarter of really cleaning up the UI of ChatGPT. I'm really excited to do the same for the sort of the response layouts and formats next. Simply because once you know what people are doing, there's no excuse to not polish your product. It's just really, in a world where you don't know yet, you might get very distracted.

**中文翻译:**
所以我们一直在做大量工作，特别是在上个季度，我们对 ChatGPT 的 UI 进行了大清理。我也很兴奋接下来能对回复的布局和格式做同样的事情。原因很简单：一旦你知道了用户在做什么，就没有理由不去打磨产品。只是在一个你还未知的世界里，你可能会非常分心。

---

### [01:13:09] Nick Turley

**English:**
So it's situational. Again, you kind of have to be first principles about it. But I do think using velocity, especially early on, as a tool... Actually this has been said about consumer social for example. It is not the first space where people have said, "Hey, you just got to try 10 things because you're probably going to be wrong." So I don't think this has never existed before as a dynamic either, but I do think with AI, it's important to internalize.

**中文翻译:**
所以这取决于具体情况。再次强调，你必须对此保持第一性原理。但我确实认为，特别是在早期，将速度作为一种工具……其实这在消费级社交领域也常被提起。这并不是第一个有人说“嘿，你得尝试 10 件事，因为你很可能会错”的领域。所以我不认为这种动态以前从未存在过，但我确实认为在 AI 领域，内化这一点至关重要。

---

### [01:13:32] Lenny Rachitsky

**English:**
And there's also an element of the models are changing constantly and so you may not even realize what they're capable of, I imagine.

**中文翻译:**
而且模型也在不断变化，我猜你甚至可能都没意识到它们到底能做什么。

---

### [01:13:38] Nick Turley

**English:**
Totally. The models are changing and the best way to improve them, whether or not you're a lab or actually just someone who's doing context engineering or fine-tuning a model maybe, you need failure cases, real failure cases, to make these things better. The benchmarks are increasingly saturated. So really you need real-world scenarios where your product or model is not actually doing the thing it was supposed to do, and the only way you get that is by shipping, because you get back to use case distribution and you can make those things good. And therefore, it's actually the best way to then go articulate to your team, especially your ML teams, what [inaudible 01:14:17] climb on? It's like, "Oh, people are trying to do X and the model's failing in ways. Why? Now let's make those things really good."

**中文翻译:**
完全正确。模型在变，而改进它们最好的方式（无论你是实验室还是做上下文工程或微调的人）是需要“失败案例”——真实的失败案例。基准测试正变得越来越饱和。所以你真的需要现实场景，在这些场景中你的产品或模型没有达到预期。获得这些案例的唯一方法就是发布，因为这样你能看到用例分布并改进它们。这也是向你的团队（特别是机器学习团队）阐明方向的最佳方式：“噢，人们在尝试做 X，但模型在某些方面失败了。为什么？现在让我们把这些做好。”

---

### [01:14:23] Lenny Rachitsky

**English:**
This point about failure cases makes me think about something that both Kevin Weil and Mike Krieger shared, which is that evals are becoming a huge new skill that product people need to get good at because so much of product building is now writing evals. Is there something there you want to share?

**中文翻译:**
关于失败案例这一点让我想起了凯文·威尔和迈克·克里格（Mike Krieger）分享过的事情：编写“评估测试”（evals）正在成为产品经理需要掌握的一项巨大的新技能，因为现在的产品构建很大程度上就是在写评估。关于这一点你有什么想分享的吗？

---

### [01:14:41] Nick Turley

**English:**
My entire OpenAI journey has been this journey of rediscovering eternal product wisdom and principles in like slightly new contexts. So I remember I started writing evals before I knew what an eval was because I was just outlining very clearly specified ideal behavior for various use cases until someone told me, "Hey, you should make an eval." And I realized there was this entire world of research evaluation benchmarks that had nothing to do with the product that I was trying to make. And I was like, "Wow, this might be the lingua franca of how to communicate what the product should be doing to people who do AI research." And that really clicked for me.

**中文翻译:**
我在 OpenAI 的整个旅程就是一个在略微不同的语境下重新发现永恒的产品智慧和原则的过程。我记得在我知道什么是“评估”（eval）之前，我就开始写评估了，因为我只是在为各种用例勾勒非常明确的理想行为。直到有人告诉我：“嘿，你应该做一个评估。”我意识到存在一个完整的、与我正试图做的产品毫无关系的科研评估基准世界。我心想：“哇，这可能就是向 AI 研究人员传达产品该做什么的‘通用语言’（lingua franca）。”那一刻我豁然开朗。

---

### [01:15:23] Nick Turley

**English:**
And at the end of the day, it's not that different from the wisdom of, you ought to articulate success before you do anything else. It's just a new mechanism for doing that. But you can do it in a spreadsheet, you do it anywhere, and I really wanted to mystify it for people who hear that term. It's not some technical magic that you have to understand. It's really just about articulating success in a way that is maximally useful for training bots.

**中文翻译:**
归根结底，这与“在做任何事之前先明确成功标准”的智慧并无二致。只是实现这一目标的新机制。你可以在电子表格里做，可以在任何地方做。我真的很想为听到这个词的人揭开它的神秘面纱：它不是什么必须理解的技术魔法，它只是以一种对训练机器人最有用的方式来阐述什么是成功。

---

### [01:15:50] Lenny Rachitsky

**English:**
Awesome. I have a post coming out soon that gives you a very good how-to for PMs have how to write evals.

**中文翻译:**
太棒了。我很快会发一篇帖子，专门教 PM 如何编写评估。

---

### [01:15:56] Nick Turley

**English:**
I would love to read it. And I hope you agree with what I just said because maybe there's [inaudible 01:16:02] to it.

**中文翻译:**
我很想读读。希望你同意我刚才说的，也许里面还有（听不清）。

---

### [01:16:02] Lenny Rachitsky

**English:**
Absolutely. Absolutely. And now there's all these tools that make this easier for you.

**中文翻译:**
当然。绝对同意。而且现在有很多工具能让这件事变得更简单。

---

### [01:16:04] Nick Turley

**English:**
Totally.

**中文翻译:**
没错。

---

### [01:16:04] Lenny Rachitsky

**English:**
Okay, so this basically backs up this point that this is just a very important skill that product teams and builders need to get good at.

**中文翻译:**
好，所以这基本上印证了这一点：这是产品团队和构建者必须擅长的一项非常重要的技能。

---

### [01:16:12] Nick Turley

**English:**
Yeah. Yeah.

**中文翻译:**
是的。

---

### [01:16:13] Lenny Rachitsky

**English:**
Okay. Just a few more questions. I know you have a lot going on today. One is that this trend of ChatGPT being a big driver of growth for traffic to sites, for products. For example, ChatGPT is now driving more traffic to my newsletter than Twitter, which completely shocked me. I just was looking at my stats, I'm like, "What the hell? This is not something I knew was coming." So just I guess thoughts on the future of this, how you think about just ChatGPT driving growth and traffic to products and sites?

**中文翻译:**
好，最后几个问题。我知道你今天很忙。一个是 ChatGPT 正在成为网站和产品流量增长的重要驱动力。例如，ChatGPT 现在为我的 Newsletter 带来的流量比 Twitter 还多，这让我非常震惊。我看着统计数据心想：“搞什么？我完全没预料到这一点。”所以我想听听你对未来的看法，你如何看待 ChatGPT 为产品和网站驱动增长和流量？

---

### [01:16:48] Nick Turley

**English:**
I'm really excited about it because in the same way that I find it dystopian to talk to everything through a chat bot, I also find it dystopian to not have amazing new high quality content out there. And for that reason, I talked a little bit earlier about search and have that solved a really important user problem early on because you had this knowledge cutoff thing and you suddenly could talk about anything. Very obvious in retrospect. A, it wasn't just a user problem, it was an ecosystem problem where the original ChatGPT, it didn't have outlinks, it would just answer your question, it would keep you in the product. And even if you wanted to keep reading or go deeper, there was no way for us to drive traffic back to the content ecosystem. And I've been really excited about what we've been doing in search, not just because it gives people more accurate answers, but because it allows us to surface really high quality content, like this podcast, to people who want to see it.

**中文翻译:**
我对此非常兴奋。因为就像我觉得“通过聊天机器人与一切交流”很反乌托邦一样，我也觉得“如果没有优秀的高质量新内容出现”也很反乌托邦。因此，我之前提到了搜索，它早期解决了一个非常重要的用户问题，因为以前有知识截止日期，而现在你突然可以聊任何事。回想起来这很明显：第一，这不仅是用户问题，也是生态系统问题。最初的 ChatGPT 没有外部链接，它只是回答问题，把你留在产品里。即使你想深入阅读，我们也无法将流量导回内容生态系统。我对我们在搜索领域所做的工作感到兴奋，不仅因为它给出了更准确的答案，还因为它让我们能向想看的人展示高质量内容，比如这个播客。

---

### [01:17:47] Nick Turley

**English:**
And of course there's so many interesting questions about, well in the Google era, there was the search engine optimization and there was clearly understood mechanisms of how to show up and get more traffic. So I get a lot of questions from people, like, "What is the equivalent of that? The AI era, if I'm Lenny and I want to 10X the traffic to my podcast, what do I actually need to do?" And the truth is we don't have amazing answers there simply because the way to appeal to an AI model ideally is the same way that you would appeal to a real user, because the model's supposed to proxy the interest of the user and nothing else. At least that's how I want our product to work. And for that reason, my advice is super lame, which is make really high quality content, which is not as actionable as I think people making content would ideally like. And I think this is why we have more work to do because maybe there's a better mechanism or protocol that we could come up with.

**中文翻译:**
当然，这里有很多有趣的问题。在 Google 时代，有搜索引擎优化（SEO），有明确的机制教你如何出现并获得更多流量。所以我收到很多人的提问：“AI 时代的等价物是什么？如果我是莱尼，我想让播客流量翻 10 倍，我到底该怎么做？”事实是，我们还没有完美的答案，因为理想情况下，吸引 AI 模型的方式应该与吸引真实用户的方式一致，因为模型应该是用户兴趣的代理。至少我希望我们的产品是这样运作的。因此，我的建议听起来很平庸：制作真正高质量的内容。这可能不像内容创作者希望的那样具有可操作性。这也是为什么我们还有更多工作要做，也许我们可以想出更好的机制或协议。

---

### [01:18:42] Nick Turley

**English:**
But I'm excited this is driving meaningful traffic for you, and I hope that other people making great content start to feel this way because, again, it's a very new scenario.

**中文翻译:**
但我很高兴这为你带来了可观的流量，我希望其他制作优秀内容的人也能开始感受到这一点，因为这确实是一个非常新的场景。

---

### [01:18:52] Lenny Rachitsky

**English:**
There's two acronyms people have been using for this specific skill of AI driven SEO. I think one is AEO, which is answer engine optimization. The other is GEO. I forget the G one.

**中文翻译:**
人们为这种 AI 驱动的 SEO 技能起了两个缩写。一个是 AEO（答案引擎优化），另一个是 GEO，我忘了 G 代表什么了。

---

### [01:19:04] Nick Turley

**English:**
Generative... Yeah, I don't know.

**中文翻译:**
生成式（Generative）……是的，我也不确定。

---

### [01:19:06] Lenny Rachitsky

**English:**
Generative, yeah, AI optimization.

**中文翻译:**
生成式 AI 优化（Generative AI Optimization）。

---

### [01:19:08] Nick Turley

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:19:08] Lenny Rachitsky

**English:**
Do you have a favorite of those two? [inaudible 01:19:10]-

**中文翻译:**
这两个里你有更喜欢的吗？

---

### [01:19:10] Nick Turley

**English:**
No, no. I try to shy away from these terms unless they become inevitable just because I'm not entirely sure yet if that should be a concept or not. Again, I think ideally, ChatGPT understands your goals and therefore understands what content would be interesting to you. And the content creator's job is to share enough information and metadata about that content such that the AI model can make a user-aligned decision. And therefore, I'm not sure if giving this thing a name and making a thing is what we should be doing or not. I'm very eager to learn from folks making content about what this could look like because. Again, we're still working through.

**中文翻译:**
不，没有。我尽量避开这些术语，除非它们变得不可避免。因为我不确定这是否应该成为一个独立的概念。再次强调，理想情况下，ChatGPT 理解你的目标，从而理解什么内容对你有吸引力。内容创作者的工作是分享足够的信息和元数据，以便 AI 模型做出符合用户利益的决策。因此，我不确定给这事起个名字并把它做成一个产业是否正确。我很渴望从内容创作者那里学习这可能是什么样子，因为我们仍在摸索中。

---

### [01:19:59] Lenny Rachitsky

**English:**
Along these lines, another question people think about is you have GPTs, which are kind of these custom GPT apps that you can build to answer very specific use cases. There's always this question of, you're going to build an app store where I can plug in my product into ChatGPT, monetize that. Is there stuff there that you could talk about that might be coming someday?

**中文翻译:**
顺着这个思路，人们想到的另一个问题是 GPTs，即你可以构建的用于回答特定用例的自定义 GPT 应用。大家总在问：你们会建立一个应用商店吗？让我可以把我的产品接入 ChatGPT 并实现变现。关于未来可能出现的相关功能，有什么可以透露的吗？

---

### [01:20:19] Nick Turley

**English:**
GPTs are cool. They're kind of ahead of their time in the sense that we built that kind of concept before you could really build very differentiated things. At least in the consumer space, your learning GPT is going to be pretty similar to what the model could already do out of the box. So it's mainly a way of articulating a use case to people, but it doesn't have enough tools yet to make something that feels like an app, so to speak.

**中文翻译:**
GPTs 很酷。某种程度上它们领先于时代，因为我们在人们真正能构建出差异化很大的东西之前就提出了这个概念。至少在消费端，你训练的 GPT 可能与模型开箱即用的能力非常相似。所以它主要是一种向人们展示用例的方式，但目前还没有足够的工具来做出真正感觉像“App”的东西。

---

### [01:20:47] Nick Turley

**English:**
Different in the enterprise by the way. We're seeing a ton of adoption of GPTs there because just every single company has very bespoke business processes and problems, etc. And it's a really, really useful tool there. They also have unique data that they can hook up to these things that it can retrieve over. So we've seen a lot of success there.

**中文翻译:**
顺便说一下，在企业端情况完全不同。我们看到 GPTs 在那里被大量采用，因为每家公司都有非常定制化的业务流程和问题。它在那里是一个非常有用的工具。他们还有独特的数据可以接入，供模型检索。所以我们在那方面看到了很多成功。

---

### [01:21:05] Nick Turley

**English:**
I think the idea is the right one, and I think we're going to figure out a good mechanism for it. Because when you have so much capability packed into AI, it feels really powerful to allow people to package that up in ways that have a clear affordance, a clear use case, and are differentiated from each other. I also would love it if you could start a business on ChatGPT. I think there really is a world where, as this thing hits a billion user scale, it can get you distribution, it can get you started on making something in the same way that people built on the internet and there was entirely new businesses to be built.

**中文翻译:**
我认为这个方向是对的，我们会想出一个好的机制。因为当 AI 蕴含如此强大的能力时，允许人们将其打包成具有明确功能、明确用例且彼此差异化的形式，是非常强大的。我也希望你能在 ChatGPT 上创业。我相信真的存在这样一个世界：当这个东西达到 10 亿用户规模时，它可以为你提供分发渠道，让你开始创造一些东西，就像人们在互联网上创业并诞生了全新的商业模式一样。

---

### [01:21:41] Nick Turley

**English:**
So I think we'll have more to share there in the future. GPT's was an early stab. And I'm just excited to evolve the thinking there as the models get good and our reach increases as well.

**中文翻译:**
所以未来我们会有更多分享。GPTs 只是一个早期的尝试。随着模型变强和我们的覆盖范围扩大，我很兴奋能进一步演进这方面的思考。

---

### [01:21:51] Lenny Rachitsky

**English:**
Amazing. That is really cool. I'm really excited to see what you guys do there. Okay. Completely different direction. Something that I know about you is you studied philosophy in college.

**中文翻译:**
太棒了。这真的很酷。我很期待看到你们在那方面的动作。好，换个完全不同的方向。我知道你大学学的是哲学。

---

### [01:22:02] Lenny Rachitsky

**English:**
Computer science and philosophy, right? A combo.

**中文翻译:**
计算机科学和哲学，对吧？一个组合。

---

### [01:22:05] Nick Turley

**English:**
Yeah. I started as a philosophy major and took one coding class because I really liked logic, and programming was most similar to that. And then I fell in love with coding and then eventually computer science, and I just kept doing more and more of it. But until then, I'd never really thought of myself as a technical person, so it was kind of a late discovery in my life that I'm very grateful for.

**中文翻译:**
是的。我最初是哲学专业的，因为非常喜欢逻辑学，所以选了一门编程课，因为编程与逻辑最相似。然后我爱上了编程，最终转向了计算机科学，并一直钻研下去。在那之前，我从未觉得自己是个技术型人才，所以这是我生命中一个较晚的发现，但我对此非常感激。

---

### [01:22:27] Lenny Rachitsky

**English:**
What an incredible combination for someone leading this product [inaudible 01:22:30].

**中文翻译:**
对于领导这个产品的人来说，这真是一个不可思议的组合。

---

### [01:22:30] Nick Turley

**English:**
It's true. It is really coming in full circle in a way that I couldn't have predicted. The amount of questions you have to grapple with are truly super interesting. And philosophy, it's not a traditionally practical skill, but it does really teach you to think things through from scratch and to articulate a point of view, and I think that has come in handy numerous times.

**中文翻译:**
确实。这真的以一种我无法预料的方式回到了原点。你需要处理的问题量真的非常有趣。哲学虽然不是传统的实用技能，但它确实教会你从头开始思考问题并阐明观点，我认为这在很多场合都派上了用场。

---

### [01:22:51] Lenny Rachitsky

**English:**
Is there a specific philosopher or school that has been most handy to you, or is there more just the general [inaudible 01:22:57]?

**中文翻译:**
有没有哪位特定的哲学家或流派对你最有帮助？

---

### [01:22:56] Nick Turley

**English:**
Oh, there's so many.

**中文翻译:**
噢，太多了。

---

### [01:22:56] Lenny Rachitsky

**English:**
okay.

**中文翻译:**
好吧。

---

### [01:22:57] Nick Turley

**English:**
I wrote my senior thesis on whether and why rational people can disagree, which also comes in handy when a lot of people with very different values have opinions on your model behavior or on how things should work. So I really like 20th century analytical philosophers. It's kind of dirty stuff, but I don't know if I have a favorite. It's too many to count. But that's the kind of stuff I like. And some of it ends up being quite analytical. You have let P be this theory of love and let Q be this other theory of love, and then you do some sort of symbolic manipulation. So it is just as much a brain thought exercise as it is... Or it's much more that than practical, but it taught me how to think in a way that continues to be pretty valuable.

**中文翻译:**
我的毕业论文写的是“理性的人是否以及为何会产生分歧”，当许多价值观迥异的人对你的模型行为或运作方式发表意见时，这非常有用。我非常喜欢 20 世纪的分析哲学家。虽然有点枯燥，但我没有最喜欢的，太多了。我喜欢那种风格，有些内容非常分析化：假设 P 是这种爱情理论，Q 是另一种，然后进行某种符号推演。这既是一种大脑思维练习，也比实用技能更有价值，它教会了我一种持续受益的思考方式。

---

### [01:23:48] Lenny Rachitsky

**English:**
Incredible. What a cool combo of skills and background. Last question before we get to very exciting lightning round. So you were a product leader at Dropbox, then Instacart, now you're the PM of arguably the most consequential product in history. How did you land in this role? What was the story of joining OpenAI and taking on this work?

**中文翻译:**
太棒了。真是酷炫的技能和背景组合。在进入令人兴奋的闪电轮提问之前，最后一个问题：你曾是 Dropbox 和 Instacart 的产品负责人，现在你是历史上最具影响力的产品的 PM。你是如何得到这个职位的？加入 OpenAI 并承担这项工作的背后故事是什么？

---

### [01:24:10] Nick Turley

**English:**
Every single career decisions I ever made, including my first one out of college, was just figuring out who are the smartest people I know that I want to hang out with and learn from, and can I work with them? And I don't know how to vet companies, I don't know how to really logically think through what space is going to take off or something like that, but I just do feel like I have a sense on people. And for Dropbox, I followed the head teaching assistant for a class that I was TA-ing. And for Instacart, I followed some of the smartest product people I knew. And for OpenAI, the person who recruited me, Joanne, I had messaged her about getting off the DALL·E waitlist and she said, "Only if you interview here." So she turned it into a reverse recruiting thing.

**中文翻译:**
我做过的每一个职业决定（包括大学毕业后的第一个）都只是在想：我认识的最聪明的人是谁？我想和谁一起共事并向其学习？我不知道如何审查公司，也不知道如何逻辑严密地推断哪个领域会爆发，但我对“人”有一种直觉。去 Dropbox 是因为我追随了我当助教时那门课的首席助教；去 Instacart 是因为我追随了一些我认识的最聪明的产品人。至于 OpenAI，招聘我的 Joanne，我当时发信息问她怎么才能从 DALL·E 的候补名单里出来，她说：“除非你来这儿面试。”所以她把它变成了一场“反向招聘”。

---

### [01:25:02] Nick Turley

**English:**
And initially, honestly, I didn't know what I would do here because it was a research lab and I was a product person and they said, "Don't worry, we'll figure it out." And they were sort of being cagey. And I thought they were being cagey because it's OpenAI and they can't share anything, but they were being cagey because we actually just didn't know yet at the time. So I showed up and I did everything under the sun and it definitely wasn't product. It was like, I think my first task was fix the blinds or something like that. And then I started sending out NDAs for people because they needed some operational help. And then I started asking, "Wait, why am I sending out NDAs? Oh, so we could talk to users." And I was like, "Talking to users, that sounds like the thing I know how to do." And I quickly stumbled into doing product work, and then eventually leading a bunch of product work. But it was organic by just showing up and doing what had to be done because, again, the company I joined was not a product company by any.

**中文翻译:**
坦白说，最初我不知道来这儿能干嘛，因为那是研究实验室，而我是个产品人。他们说：“别担心，我们会搞清楚的。”他们当时表现得有点神神秘秘（cagey）。我以为是因为 OpenAI 保密级别高，但其实是因为当时我们真的还不知道。所以我来了之后什么都干，绝对不是产品工作。我的第一个任务好像是修百叶窗之类的。然后我开始帮大家发保密协议（NDA），因为他们需要运营方面的帮助。接着我问：“等等，我为什么要发 NDA？噢，是为了能跟用户交流。”我心想：“跟用户交流，这事我熟啊。”于是我很快就误打误撞开始做产品工作，最后领导了一系列产品工作。这一切都是自然发生的，就是通过“出现”并做那些必须做的事，因为我加入时，这根本不是一家产品公司。

---

### [01:26:00] Lenny Rachitsky

**English:**
Wow. This is such a good example of, I don't know if you think of it this way, but when someone offers you a seat on a rocket ship, don't ask which seat. [inaudible 01:26:07].

**中文翻译:**
哇。这真是一个绝佳的例子：当有人邀请你上火箭时，别问位置在哪。

---

### [01:26:08] Nick Turley

**English:**
Yeah, so I didn't know it was a rocket ship. I kind of got nerd sniped is what I would describe it as. Where as I prepared for the conversation to get off the DALL·E waitlist really, I just started reading about the space and that piqued the philosophy brain and then also actually the computer science brain. I was like, "Wait, this is cool." Then I started reading all the academic papers of that era. So it was intellectual itch and the people, but then I stayed for the product opportunity, obviously. Post ChatGPT, when that took off, realized that we'd built a rocket ship where we'd launched it while building it, maybe is the analogy. But I can't say that it felt like a hyped job or anything like that when I applied.

**中文翻译:**
是的，但我当时不知道那是火箭。我更愿意形容为“被技术难题吸引了”（nerd sniped）。为了那次关于 DALL·E 候补名单的谈话，我开始阅读相关领域的资料，这激发了我的哲学大脑，接着也激发了我的计算机科学大脑。我心想：“等等，这太酷了。”然后我开始读那个时代所有的学术论文。所以是智力上的渴望和对人的认可吸引了我，当然，后来我为了产品机会留了下来。ChatGPT 爆发后，我意识到我们造了一枚火箭，而且是边飞边造。但我申请时，完全没觉得这是一份被过度炒作的工作。

---

### [01:27:00] Lenny Rachitsky

**English:**
So a lesson there is, as you said, follow the smartest people you know. There's also just this thread of follow things that are interesting to you. Just you playing with DALL·E led to this opportunity.

**中文翻译:**
所以教训就是：如你所说，追随你认识的最聪明的人。还有就是追随你感兴趣的事物。仅仅是因为你想玩 DALL·E，就引出了这个机会。

---

### [01:27:10] Nick Turley

**English:**
Yeah, yeah. And actually that's something we still test for is curiosity is an attribute that we think matters so much more than your ML knowledge. I'm not making a comment on research hiring. I think you do need some ML knowledge, I'm afraid. But for product and engineering and design people, and those kinds of functions, I actually think that if you are just curious about the stuff works, it doesn't matter at all if you've never done it before. In fact, if you were to filter for people who've done it before, you would have a very narrow filter of very lucky people rather than necessarily the best people you can get. So I think we've scaled that. Certainly what got me here, but I think it's actually, just generically, been a good predictor of success at OpenAI.

**中文翻译:**
没错。实际上我们现在面试依然会测试这一点：好奇心。我们认为好奇心比你的机器学习（ML）知识重要得多。我不是在评价研究岗位的招聘，做研究恐怕确实需要 ML 知识。但对于产品、工程和设计等职能，我认为如果你对这些东西的运作方式充满好奇，即使以前没做过也完全没关系。事实上，如果你只筛选做过的人，你的漏斗会非常窄，只能招到一小群幸运儿，而不一定是最好的人才。所以我们推广了这种理念。这确实是让我来到这里的原因，而且我认为这通常也是在 OpenAI 取得成功的良好预测指标。

---

### [01:27:50] Lenny Rachitsky

**English:**
Nick, I told you I had a billion... I said I had 2 billion questions to ask you. I feel like I've asked a lot. I feel like I still have a billion left. But I know, you told me right after this you, have a big GPT- 5 check-in that you got to get to. So-

**中文翻译:**
尼克，我说过我有 20 亿个问题。我觉得我已经问了很多，但感觉还剩 10 亿个。但我知道，你待会儿还有一个重大的 GPT-5 进度检查要参加。所以——

---

### [01:28:01] Nick Turley

**English:**
We got to ship.

**中文翻译:**
我们得发布。

---

### [01:28:03] Lenny Rachitsky

**English:**
We got to ship. Better ship now that this is recorded and we're putting this out.

**中文翻译:**
必须发布。既然这段已经录下来了，我们也要发布播客了，你们最好赶紧发布。

---

### [01:28:08] Nick Turley

**English:**
This is true. [inaudible 01:28:08].

**中文翻译:**
确实如此。

---

### [01:28:09] Lenny Rachitsky

**English:**
This is the forcing function. Okay, so before we get to a very exciting lightning round, is there anything else that you want to share, leave listeners with, think is important to share?

**中文翻译:**
这就是“强制函数”。好，在进入闪电轮提问之前，还有什么想分享给听众的吗？

---

### [01:28:20] Nick Turley

**English:**
I try to share a little bit about how I made decisions because I hope to... I'm not that far out of school. I relate a lot to people who are coming in the job market, who are trying to figure out what to do with their life right now. And I feel very confident that if you surround yourself with people that give you energy and if you follow the things you're actually curious about, that you're going to be successful in this era. So my parting advice to folks really is put yourself around good people and do the things you're actually passionate about. Because in a world where this thing can answer any question, asking the right question is very, very important. And the only way to learn how to do that is to nurture your own curiosity. So it worked for me and it's the one repeatable thing that I can share. Everything else is luck.

**中文翻译:**
我试着分享一些我做决定的方式，因为我毕业也没多久。我很能理解那些刚进入职场、正试图弄清楚人生方向的人。我非常有信心，如果你身边围绕着能给你能量的人，如果你追随你真正好奇的事物，你在这个时代就会成功。所以我给大家的临别建议是：与优秀的人为伍，做你真正热爱的事。因为在一个 AI 能回答任何问题的世界里，提出正确的问题非常重要。而学会提问的唯一方法就是培养你的好奇心。这对我奏效了，也是我能分享的唯一可重复的经验。其他一切都是运气。

---

### [01:29:15] Lenny Rachitsky

**English:**
This is counter to what a lot of people are doing right now, which is follow the money. Where can I make the most? How do I grow this thing and make $100 million? All these people that are getting these crazy offers were not planning to make a lot of money doing this.

**中文翻译:**
这与现在很多人的做法相反，很多人是“向钱看”：哪里赚得最多？我怎么能把这玩意做大赚一亿美金？而那些现在拿到疯狂 Offer 的人，最初并没打算靠这个赚大钱。

---

### [01:29:27] Nick Turley

**English:**
It's quite interesting to see that stuff play out because I think all these people entered school for genuine reasons. They were excited about the space, they were researching it, they were pursuing knowledge, and I'm happy that that's being rewarded. And I don't know what the rewards will look like in the future, especially in a post-AGI world. But I just a feeling that if you follow that advice, you'll end up okay.

**中文翻译:**
看到这些事情的发展很有趣，因为我认为这些人当初进入这个领域都是出于纯粹的原因：他们对这个领域感到兴奋，他们在研究它，他们在追求知识。我很高兴这种追求得到了回报。我不知道未来的回报会是什么样子，特别是在后 AGI 时代。但我有一种直觉，如果你遵循那个建议，你最终会过得很好。

---

### [01:29:54] Lenny Rachitsky

**English:**
With that, Nick, we've reached our very exciting lightning round. I've got five questions for you. Are you ready?

**中文翻译:**
那么尼克，我们进入了令人兴奋的闪电轮。我有五个问题。准备好了吗？

---

### [01:29:59] Nick Turley

**English:**
Sure, yeah.

**中文翻译:**
当然。

---

### [01:30:00] Lenny Rachitsky

**English:**
What are two or three books that you find yourself recommending most to other people?

**中文翻译:**
你最常向别人推荐的两三本书是什么？

---

### [01:30:04] Nick Turley

**English:**
In the product space, probably things like High Output Management or The Design of Everyday Things, or those kind of classic type things because I think they're extremely applicable in AI.

**中文翻译:**
在产品领域，可能是《高产出管理》（High Output Management）或《设计心理学》（The Design of Everyday Things）之类的经典，因为我认为它们在 AI 领域极其适用。

---

### [01:30:13] Lenny Rachitsky

**English:**
We talked about philosophy. I don't know, is there a philosophy book you're like, "Here's the one to read if you're getting into this."

**中文翻译:**
我们聊到了哲学。有没有哪本哲学书是你觉得“入门必读”的？

---

### [01:30:17] Nick Turley

**English:**
Oh man. Anything by Rawls and Nozick. I like the political stuff. I think it's really fun. That is a type of thing I recommend. I don't think there's a practical reason to read that stuff, but I will nerd out about it with you. So at your own peril.

**中文翻译:**
噢天哪。罗尔斯（Rawls）和诺齐克（Nozick）的任何书。我喜欢政治哲学，觉得很有趣。这是我会推荐的东西。我不觉得读这些有什么实用的理由，但我会很乐意跟你深入探讨。所以，后果自负。

---

### [01:30:32] Lenny Rachitsky

**English:**
Do you have a favorite recent movie or TV show you've really enjoyed? If you've had time to watch anything.

**中文翻译:**
你最近有什么非常喜欢的电影或电视剧吗？如果你有时间看的话。

---

### [01:30:36] Nick Turley

**English:**
I think you've got to do a little bit of sci-fi to be in this space. You shouldn't copy any of it, but I think you learn from it. So regularly re-watch Her and Westworld. Severance was great. I think that's the stuff that, when I have time, I'll meddle with.

**中文翻译:**
我觉得在这个领域工作，你得看点科幻片。你不该照抄里面的内容，但你可以从中学习。我会定期重温《她》（Her）和《西部世界》（Westworld）。《人生切割术》（Severance）也很棒。这些是我有空时会看的东西。

---

### [01:30:56] Lenny Rachitsky

**English:**
That is awesome. I love that those are the two. Of all the sci-fi movies, those are the ones you resonate most with and find most interesting and valuable.

**中文翻译:**
太棒了。我喜欢这两部。在所有科幻作品中，这两部是你最有共鸣、觉得最有趣且最有价值的。

---

### [01:31:03] Nick Turley

**English:**
Yes, but that's probably my own limitation, so I'm sure there's more to discover.

**中文翻译:**
是的，但这可能是我个人的局限，我相信还有更多值得发掘的作品。

---

### [01:31:08] Lenny Rachitsky

**English:**
By the way, have you read Fire Upon the Deep, that sci-fi book?

**中文翻译:**
顺便问下，你读过《深渊上的火》（Fire Upon the Deep）那本小说吗？

---

### [01:31:08] Nick Turley

**English:**
No.

**中文翻译:**
没有。

---

### [01:31:13] Lenny Rachitsky

**English:**
Okay. I don't know if you have time to read this book, but I think you would love it. It's such a good-

**中文翻译:**
好。我不知道你有没有时间读，但我认为你会喜欢的。它是一本非常棒的——

---

### [01:31:16] Nick Turley

**English:**
Oh, man. Okay.

**中文翻译:**
噢，好的。

---

### [01:31:17] Lenny Rachitsky

**English:**
... AI oriented sci-fi space opera sort of book.

**中文翻译:**
……以 AI 为导向的科幻太空歌剧类书籍。

---

### [01:31:20] Nick Turley

**English:**
Great.

**中文翻译:**
太好了。

---

### [01:31:21] Lenny Rachitsky

**English:**
I'll check it out, thank you.

**中文翻译:**
我会去看看的，谢谢。

---

### [01:31:22] Nick Turley

**English:**
Yeah.

**中文翻译:**
好的。

---

### [01:31:22] Lenny Rachitsky

**English:**
Okay. Off tangent.

**中文翻译:**
好，扯远了。

---

### [01:31:22] Nick Turley

**English:**
Yeah, yeah, yeah. For sure.

**中文翻译:**
是的。

---

### [01:31:26] Lenny Rachitsky

**English:**
Okay. Do you have a favorite product you've recently discovered that you really love?

**中文翻译:**
你最近有没有发现什么非常喜欢的、让你爱不释手的产品？

---

### [01:31:29] Nick Turley

**English:**
I actually don't. I am at extreme capacity. It's kind of interesting. API developers ask me like, "Hey, are you going to copy all of our products?" It's like, I actually just do not have time to follow up what's going on outside of OpenAI because the pace here is so, so intense. So don't have good recs for you, I'm afraid.

**中文翻译:**
其实没有。我的精力已经达到极限了。挺有意思的，API 开发者会问我：“嘿，你们会抄袭我们所有的产品吗？”事实是，我根本没时间关注 OpenAI 之外发生了什么，因为这里的节奏太紧张了。所以恐怕我没什么好的推荐。

---

### [01:31:54] Lenny Rachitsky

**English:**
That's a comforting answer, I think, to a lot of product companies. Go figure. Nick has no time to even listen to our stuff. Oh man. Okay. Do you have a favorite life motto that you find yourself using when things are tough, sharing with friends or family that other people find useful?

**中文翻译:**
我想这对很多产品公司来说是个令人欣慰的答案。想想看，尼克甚至没时间听我们的东西。好。你有没有什么人生格言，是在困难时期会用到，或者会分享给亲友且别人觉得有用的？

---

### [01:32:10] Nick Turley

**English:**
Being the average of the five people you spend the most time with is a thing that I really internalize, both in my personal life, where there's people who give me energy and who lift me up and make me a better person. My fiance is one of those people, but there's many people in my life. But then there's also just, at work, there's the equivalent. And again, that's how I've made all the career decisions. It's like who do I want to learn from? So I apply that principle constantly.

**中文翻译:**
“你的水平是你花时间最多的五个人的平均值”，这是我真正内化的一句话。在个人生活中，我身边有能给我能量、激励我并让我变得更好的人。我的未婚妻就是其中之一，我生命中还有很多人也是如此。在工作中也是一样。再次强调，这就是我做所有职业决定的依据：我想向谁学习？我一直在践行这个原则。

---

### [01:32:36] Lenny Rachitsky

**English:**
Final question, everybody I talked to told me that you are a very good jazz pianist. You have won competitions. I think you were planning to do this as your main thing and then you somehow took the side quest.

**中文翻译:**
最后一个问题：我聊过的每个人都告诉我你是一个非常出色的爵士钢琴家。你还得过奖。我想你原本打算把它当成主业，结果不知怎么的走上了这条“支线任务”。

---

### [01:32:47] Nick Turley

**English:**
Yeah, I chickened out that at the very last minute, but I was going to go to school for music. And that's still my, hopefully, chapter two.

**中文翻译:**
是的，我在最后一刻退缩了，但我本来打算去读音乐学院的。希望那仍会是我人生的第二篇章。

---

### [01:32:55] Lenny Rachitsky

**English:**
Wow. I love that that might still happen.

**中文翻译:**
哇。我喜欢“那仍可能发生”这个想法。

---

### [01:32:58] Nick Turley

**English:**
Might still happen. Now I'm in some for fun bands and we will kick from time to time. It's like the one thing I can do when I'm otherwise super tired and can't think anymore because it balances me out in good ways. But yeah, hopefully I'll get to do more of it in the future.

**中文翻译:**
可能会发生。现在我参加了一些业余乐队，偶尔会演出。这是我在极度疲惫、无法思考时唯一能做的事，因为它能很好地平衡我的状态。希望未来能有更多机会做这件事。

---

### [01:33:16] Lenny Rachitsky

**English:**
Is there any analogs between music and your job? Anything that you find-

**中文翻译:**
音乐和你的工作之间有什么类比吗？

---

### [01:33:20] Nick Turley

**English:**
Yeah, actually. I feel like you could think of software development as, or being a product person, as you could be a conductor of an orchestra or you could be in a jazz band. And I think of it as a jazz band where I don't believe in the idea of everyone having this set part that they have to play and me kind of telling people when to play. I love how in jazz, or other forms of improvised music, you're kind of riffing off of each other and you listen to what one person played and then you play something back. And I think that great product development is like that, in the sense that ideas could come from anywhere. It shouldn't be a scripted process. You should be trying stuff out, having fun, having play in what you do. So I use that analogy a lot. For those who like music, it tends to resonate.

**中文翻译:**
有的。我觉得你可以把软件开发或做产品经理看作是管弦乐队的指挥，或者是爵士乐队的一员。我更倾向于爵士乐队：我不相信每个人都有固定的乐谱必须照着演，也不相信由我来告诉大家什么时候该演奏。我喜欢爵士乐或其他即兴音乐中的那种状态——大家互相激发（riffing off），你听别人弹了什么，然后你回敬一段。我认为优秀的产品开发也是如此：点子可以来自任何地方，它不该是一个照本宣科的过程。你应该去尝试、去寻找乐趣、在工作中保持“玩”的心态。我经常用这个类比，对于喜欢音乐的人来说，这很有共鸣。

---

### [01:34:13] Lenny Rachitsky

**English:**
Nick, I am so thankful that you made time for this. I know today is insane. Tomorrow's going to be even more insane for the entire world. They have no idea what's coming. Thank you so much for doing this. Two final questions. Where can folks find you if you want them to find you online? Where can folks find GPT-5 potentially. And then just how can listeners be useful to you?

**中文翻译:**
尼克，非常感谢你抽时间参加。我知道今天很疯狂，明天对全世界来说会更疯狂，大家还不知道即将发生什么。非常感谢。最后两个问题：如果大家想在网上找到你，去哪里找？大家去哪里找 GPT-5？以及，听众能为你做点什么？

---

### [01:34:31] Nick Turley

**English:**
Just use the product. You don't even have to pay. Should be your default model starting tomorrow and just use it and don't think about models anymore. Unless you want to and you're a Pro user, in which case you get all the old models. So rest assured. And useful, honestly, I learned so much from people at large and ChatGPT users, et cetera, so just keep doing your thing. I am watching and learning, and I appreciate all the feedback. So I'm sure after we fix the model chooser, you guys will roast me for something else and I'll take it. So keep it coming.

**中文翻译:**
去用产品就行。你甚至不需要付费。从明天起它应该是你的默认模型，尽管用它，别再去想模型的事了。除非你是 Pro 用户且想用旧模型，那也没问题。至于对我有什么用，说实话，我从广大用户和 ChatGPT 使用者身上学到了太多，所以请继续做你们在做的事。我在观察和学习，并感谢所有的反馈。我确信在我们修好模型选择器后，你们会因为别的事来吐槽我，我会接受的。所以，尽管提意见吧。

---

### [01:35:05] Lenny Rachitsky

**English:**
Amazing. Nick, thank you so much for being here.

**中文翻译:**
太棒了。尼克，非常感谢你来到这里。

---

### [01:35:08] Nick Turley

**English:**
Thanks for having me, Lenny.

**中文翻译:**
谢谢邀请，莱尼。

---

### [01:35:09] Lenny Rachitsky

**English:**
And good luck tomorrow.

**中文翻译:**
祝明天好运。

---

### [01:35:10] Nick Turley

**English:**
Thanks.

**中文翻译:**
谢谢。

---

### [01:35:11] Lenny Rachitsky

**English:**
Bye everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at Lennyspodcast.com. See you in the next episode.

**中文翻译:**
大家再见。非常感谢收听。如果你觉得有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用上订阅。此外，请考虑给我们评分或留下评论，这能帮助其他听众找到我们。你可以在 Lennyspodcast.com 找到往期节目。下期再见。