# Nickey Skarstad - 双语对照

This is the complete bilingual transcript of Lenny's Podcast with Nickey Skarstad.

---

### (00:00:04) Lenny

**English:**
When I asked in my newsletter Slack community who I should have on the podcast who's a bit under the radar, but amazing, Nickey Skarstad was the first name that I heard. And I was not surprised. I actually overlapped with Nickey at Airbnb, where she had a legendary reputation as a PM who everyone loved, but got shit done. Before Airbnb, Nickey worked at Etsy for over seven years where she went from being a forum moderator to director of product management. Then she went on to work at Airbnb for a couple years. After leaving, she went on to be VP product at The Wing, and is currently a director of product management at Duolingo. In our conversation, we cover how to set vision, translate that into goals, and then how to execute on it, making your strategy actionable, and keeping your teams aligned and focused, designing your product review sessions, how to maintain product quality, and what skills have most contributed to her success in her career. I hope that you enjoy this conversation with Nickey Skarstad.

**中文翻译:**
当我在我的通讯（newsletter）Slack 社区询问，谁是那种虽然低调但非常出色、值得请上播客的人时，Nickey Skarstad 是我听到的第一个名字。我并不感到意外。我实际上和 Nickey 在 Airbnb 共事过，她在那里有着传奇般的声誉：一个深受大家喜爱，且执行力极强（got shit done）的产品经理。在加入 Airbnb 之前，Nickey 在 Etsy 工作了七年多，从论坛版主一路晋升为产品管理总监。随后她在 Airbnb 工作了几年。离开后，她担任了 The Wing 的产品副总裁，目前是 Duolingo 的产品管理总监。在我们的对话中，我们讨论了如何设定愿景、将其转化为目标并执行，如何让策略具备可操作性，如何保持团队的一致性和专注，如何设计产品评审会议，如何维持产品质量，以及哪些技能对她的职业成功贡献最大。希望你们喜欢这次与 Nickey Skarstad 的对话。

---

### (00:01:02) Lenny

**English:**
This episode is brought to you by Mixpanel, offering powerful self-serve product analytics. Something we talk a lot about on the show is how startups can build successful and amazing products. And relying on gut feeling is a really expensive way to find out if you're heading in the right direction, especially when you're raising money. Because VCs don't want to pay the price for these kinds of mistakes. That's why Mixpanel will give you $50,000 in credits when you join their startup program. With Mixpanel, startups find product market fit faster, helping you take your company from minimal viable product to the next unicorn. Access realtime insights with the help of their pre-built templates, and know that at every stage Mixpanel is helping you build with confidence and curiosity for free. Apply for the startup program today to claim you're $50,000 in credits at mixpanel.com/startups, with an S. And even if you're not a startup, Mixpanel has pricing plans for teams of every size. Grow your business like you've always imagined with Mixpanel.

**中文翻译:**
本期节目由 Mixpanel 赞助播出，Mixpanel 提供强大的自助式产品分析服务。我们在节目中经常讨论初创公司如何打造成功且令人惊叹的产品。而依靠直觉来判断方向是否正确是一种代价极其昂贵的方式，尤其是在融资阶段。因为风险投资人（VC）不想为这类错误买单。这就是为什么 Mixpanel 在你加入其初创公司计划时会提供 5 万美元的抵扣额度。通过 Mixpanel，初创公司能更快找到产品市场契合点（PMF），帮助你的公司从最小可行性产品（MVP）成长为下一个独角兽。借助其预设模板获取实时洞察，Mixpanel 在每个阶段都能免费帮助你带着信心和好奇心进行构建。立即申请初创公司计划，在 mixpanel.com/startups 领取你的 5 万美元额度。即使你不是初创公司，Mixpanel 也有适合各种规模团队的价格方案。用 Mixpanel 像你想象的那样发展你的业务。

---

### (00:02:02) Lenny

**English:**
So many product managers are basically treated like project managers. They get hired thinking they'll be deep in product strategy, vision, and getting to know their customers, only to wind up organizing other people's work and refining backlogs and organizing tiny, tiny features. If that sounds familiar, you need Dovetail. Because Dovetail gets that the true heart of product management is understanding what customers want, why they want it, and how to give it to them. That's why Dovetail builds a suite of user research products that help you get to the core of what your customers really want and why they want it. Dovetail offers powerful analysis tools to help you identify themes, patterns, and insights in your customer interviews, allowing you to make better data informed decisions about what solutions you should build next. Organizations the world over like Atlassian, Canva, DataDoc, GitLab, Nielsen Norman Group, Sketch, Deloitte, all use Dovetail to get a better understanding of their customers and build better products. Try Dovetail's products for free for as long as you need. You can sign up and dive straight in at dovetailapp.com/lenny. Nickey, thank you so much for joining me today. I am really excited for our chat and to get to learn from you. So welcome.

**中文翻译:**
很多产品经理基本上被当成了项目经理。他们入职时以为自己会深耕产品策略、愿景并深入了解客户，结果却只是在协调他人的工作、整理待办事项（backlogs）以及组织一些微小的功能。如果这听起来很耳熟，那么你需要 Dovetail。因为 Dovetail 明白，产品管理的真正核心是理解客户想要什么、为什么想要，以及如何满足他们。这就是为什么 Dovetail 构建了一套用户研究产品，帮助你触及客户真实需求及其背后原因的核心。Dovetail 提供强大的分析工具，帮助你在客户访谈中识别主题、模式和洞察，让你能根据数据做出更好的决策，确定下一步该构建什么解决方案。全球各地的组织，如 Atlassian、Canva、DataDoc、GitLab、Nielsen Norman Group、Sketch、Deloitte，都在使用 Dovetail 来更好地了解客户并打造更好的产品。你可以根据需要免费试用 Dovetail 的产品。你可以直接在 dovetailapp.com/lenny 注册并开始使用。Nickey，非常感谢你今天加入。我非常期待我们的聊天并向你学习。欢迎你。

---

### (00:03:28) Nickey Skarstad

**English:**
Thank you. Thanks for having me.

**中文翻译:**
谢谢。感谢邀请我。

---

### (00:03:30) Lenny

**English:**
My pleasure. Today, you are director of product at Duolingo, which is an awesome product, and something that I used to use. I'm not learning a language currently, but I know where to go if I were to. Can you just talk about how you got into product, and then a bit about just your journey from that point to where you are today?

**中文翻译:**
我的荣幸。今天，你是 Duolingo 的产品总监，那是一个非常棒的产品，我以前也用过。虽然我现在没在学外语，但我知道如果我要学该去哪儿。你能谈谈你是如何进入产品领域的，以及从那时起到现在的职业历程吗？

---

### (00:03:48) Nickey Skarstad

**English:**
Yeah, so it's been a long, meandering journey, which is fun. And so I've been in technology roles now for 12 years. I've been in PM roles, actually product roles, for 10. I'm starting to be the person with experience in the room, which is really fun and kind of daunting at times. But how I got my first role in product was I was at Etsy in 2010 is when I joined. And I joined them, I'd say it was post-product market fit, but before they truly started to really grow and scale. And I actually joined them on their community team. So I worked as a forums moderator, and then as a seller education specialist. Yeah. Spent a couple years doing that. And then through that process became sort of one of the internal voices that had a really good understanding of how their customer, one of their core customers, their sellers, were actually using their product.

**中文翻译:**
好的，这是一个漫长且曲折的过程，挺有趣的。我在技术岗位工作了 12 年，其中担任 PM（产品经理）角色，或者说产品相关角色已经 10 年了。我开始成为房间里那个“有经验的人”了，这很有趣，有时也挺让人畏缩的。我第一份产品工作是在 Etsy。我是 2010 年加入的，当时 Etsy 已经过了产品市场契合点（PMF），但在真正开始大规模增长和扩张之前。我最初加入的是他们的社区团队，担任论坛版主，后来成为卖家教育专家。在那儿干了几年，通过那个过程，我成了内部最了解核心客户（卖家）如何实际使用产品的人之一。

---

### (00:04:38) Nickey Skarstad

**English:**
And the VP product at the time, his name's Mark Headland. Hey Mark, if you're listening. Was like, "Hey, Nickey, you're in all these product meetings. Have you thought about being a product manager?" And at the time I was like, "Oh God, no. Never." I was like, "No. Technology what? Engineering? I'd have to work with engineers? I know nothing about engineering." And so I was very imposter syndrome-y about it. And he gave me a little nudge, and was like, "I think you'd be really good at it." And so I tried it. And I started as an APM. And I was at Etsy for around, I think, it was seven years total, and spent the majority of time actually in PM product roles. So I left as a director of product. And for most of my time there, I worked on the seller side. So it was all seller tooling, working with sellers to figure out how they could grow and scale their businesses. And it was an awesome, wild ride. But that was my first role in product. And then I went on after that into several other product roles as well.

**中文翻译:**
当时的产品副总裁叫 Mark Headland（嘿 Mark，如果你在听的话）。他说：“嘿，Nickey，你参加了所有这些产品会议。你有没有想过当一名产品经理？”当时我的反应是：“噢天哪，不，绝不。”我说：“不，技术什么？工程？我得和工程师一起工作？我对工程一窍不通。”所以我当时有很强的“冒充者综合征”（imposter syndrome）。他推了我一把，说：“我觉得你会做得很好。”于是我尝试了，从 APM（助理产品经理）做起。我在 Etsy 总共待了大约七年，大部分时间都在做 PM 产品角色。离开时我是产品总监。在那里的绝大部分时间，我都在负责卖家端，也就是所有的卖家工具，研究如何帮助卖家增长和扩大业务规模。那是一段非常棒、非常疯狂的经历。那是我的第一个产品角色，之后我又担任了几个其他的产品职位。

---

### (00:05:27) Lenny

**English:**
Yeah, let's get into it. Where'd you go next?

**中文翻译:**
好，我们继续。你接下来去了哪儿？

---

### (00:05:29) Nickey Skarstad

**English:**
So after seven years at Etsy, I was kind of getting the itch to try something new. When I took a step back and was like, all right, what do I want to do next? I really loved the marketplace component at Etsy. And I don't know if this is just says something about my personality, or actually probably your personality too, is marketplace product is really hard, right? You have this constant balancing of both buyer and seller sides or both sides of the marketplace. And I really liked that. And it was something that I was good at. And so I was like, all right, where else could I go that's interesting or having a moment? And I was like, Airbnb. Has to be Airbnb. I was a huge fan of their product. They were also post-product market fit. But sniffed around, ended up basically getting an opportunity to join the experiences team. And I joined that team when the product had just launched. So they had done sort of their early thinking, the existential thinking. Had a brand new product in market, and then I joined the team.

**中文翻译:**
在 Etsy 待了七年后，我开始心痒痒想尝试新事物。当我退后一步思考“下一步我想做什么”时，我发现我非常喜欢 Etsy 的平台/市场（marketplace）属性。我不知道这是否说明了我的性格，或者可能也是你的性格——双边市场产品非常难做，对吧？你必须不断平衡买家和卖家两端，或者说市场的两端。我非常喜欢这一点，而且我也擅长这个。所以我当时想，还有哪里是有趣的或者正处于高光时刻的？我想到了 Airbnb。必须是 Airbnb。我是他们产品的超级粉丝。他们当时也已经过了 PMF 阶段。我四处打听，最后得到了加入“体验”（Experiences）团队的机会。我加入时，那个产品才刚刚发布。也就是说，他们已经完成了早期的思考和本质性的探索，产品刚推向市场，我就加入了。

---

### (00:06:18) Nickey Skarstad

**English:**
And so I was the first boots on the ground product manager, and really helped that team figure out how do we get product market fit? And then how do we start to think about how to scale it, which was, you can imagine, experiences is interesting because it is a very nuanced product in that, and this is similar to Airbnb if you work on homes as well, but part of it is building the digital experience that someone will interact with when they're booking an Airbnb experience. And the other part is actually influencing the live event experience that you will experience when you actually join an event or an experience. And I think that layer of abstraction for me was really fascinating, and something I've learned a ton about is it's not just influencing the digital product, but it's actually the consumer experience when their boots around the ground. And that is another layer of complexity. And so that was super fun. I was there for about, I think, a little over two and a half years. Started as a PM. I think I got promoted a couple times. Left as senior product lead, I believe was my title. And forever grateful for that experience because I learned a ton about product market fit and also product quality.

**中文翻译:**
我是那个团队第一位在一线实干（boots on the ground）的产品经理，真正帮助团队弄清楚如何达到产品市场契合点，以及如何开始考虑规模化。你可以想象，“体验”产品非常有趣，因为它非常微妙——这和 Airbnb 的房源业务类似——一部分是构建用户预订体验时的数字体验，另一部分则是实际影响用户参加活动时的现场体验。这种抽象层级对我来说非常迷人，我学到了很多：这不仅仅是影响数字产品，而是影响消费者在实地参与时的体验。这是另一层复杂性。所以那段经历非常有趣。我在那里待了大约两年半多一点。从 PM 做起，期间晋升了几次，离开时的头衔应该是高级产品主管（Senior Product Lead）。我永远感激那段经历，因为我学到了大量关于 PMF 和产品质量的知识。

---

### (00:07:23) Lenny

**English:**
Is there anything else you took away from that experience? Because I was at Airbnb at the same time. We never really got to work together. But I just heard amazing things about you on the experiences team. And experiences was a wild ride, from what I understand. Is there anything that you took away from that experience that kind of has stuck with you as a PM?

**中文翻译:**
那段经历还有什么让你受益匪浅的吗？因为我当时也在 Airbnb，虽然我们没怎么合作过，但我听到了很多关于你在“体验”团队的出色评价。据我所知，“体验”业务是一段疯狂的历程。作为一名 PM，那段经历中有没有什么东西一直影响着你？

---

### (00:07:39) Nickey Skarstad

**English:**
Yeah. So part of it is more of just the way Airbnb works is something that I think I use every day in my job, which is just truly thinking about product quality and the end consumer experience. And Airbnb does not ship product if it is not good. And even if they're trying new things, they are obsessed with the end consumer experience. And I learned so much from that line of thinking because just, if it shipped, it was really high quality. All the edge cases had been thought through. And the experience I had before that was definitely we were shipping things more quickly, things weren't always perfect. And it's not to say that everything Airbnb ships is perfect, but I think that obsession with the end consumer experience really influences the quality of their product suite and is something I try to bring to my job today because no one does it better, in my personal opinion.

**中文翻译:**
有的。其中一部分是 Airbnb 的工作方式，我至今在日常工作中仍在使用，那就是真正思考产品质量和最终消费者的体验。Airbnb 如果觉得产品不够好，是不会发布的。即使是在尝试新事物，他们也对最终消费者体验有着近乎偏执的追求。我从这种思维方式中学到了很多，因为只要是发布出来的东西，质量都非常高，所有的边缘情况（edge cases）都考虑到了。而在那之前的经历中，我们发布东西的速度更快，产品并不总是完美的。并不是说 Airbnb 发布的所有东西都完美，但那种对最终消费者体验的执着确实影响了他们整个产品套件的质量。这也是我今天努力带入工作中的东西，因为在我看来，没有人比他们做得更好。

---

### (00:08:28) Lenny

**English:**
I'd love to unpack that a little bit. There's kind of two questions in my mind. Is there an example of that at Airbnb where it's just like, okay, here's how they keep quality so high? And then do you have any advice for just how to do that as a company?

**中文翻译:**
我想深入探讨一下。我脑子里有两个问题。Airbnb 有没有具体的例子能说明他们是如何保持如此高质量的？另外，对于一家公司如何做到这一点，你有什么建议吗？

---

### (00:08:40) Nickey Skarstad

**English:**
Yeah. So I don't think that's easy for sure. One of the things Airbnb did for experiences is we had this balancing metric, which was basically using the review rate as sort our end all, be all top line goal. So you can imagine a business like that. Obviously we needed to have revenue kind of moving through the platform, and we cared about high level bookings. But really at the end of the day in the beginning, we were obsessed with making sure every person who booked actually had a good experience when they showed up to experiences. And so especially if you are building early product, really thinking about how can you pick some good quality metrics that might actually balance or conflate with growth metrics, and use that as sort of your north star because it really helped the whole team to understand what they were actually trying to do at the end of the day. Growth was important, sure. Obviously we needed to grow for a lot of reasons. But the most important thing was that the actual customer experience was great. And I know Airbnb does that in other places too, but that really was experience's top line goal was our review rate and quality and it trickled down for sure.

**中文翻译:**
好的。这肯定不容易。Airbnb 在“体验”业务上做的一件事是，我们有一个平衡指标，基本上是把“评价率”（review rate）作为我们的终极核心目标。你可以想象那样的业务，显然我们需要平台上有收入流水，我们也关心高层级的预订量。但在初期，我们真正执着的是确保每一个预订的人在实际参加体验时都有良好的感受。所以，特别是如果你在构建早期产品，认真思考如何选择一些好的质量指标，这些指标可能与增长指标相互平衡或结合，并将其作为你的“北极星指标”。这能帮助整个团队理解他们最终到底在追求什么。增长固然重要，显然我们需要增长。但最重要的事情是实际的客户体验必须很棒。我知道 Airbnb 在其他地方也这么做，但“体验”业务的核心目标确实就是评价率和质量，这确实自上而下地影响了所有人。

---

### (00:09:53) Nickey Skarstad

**English:**
How did they operationalize that? Because it sounds great. Cool, let's make sure everything, all the reviews are five star. How do you build that into the way the team operates and tracks their success? Yeah. So a big part of that was actually operational, which was just making sure that hosts who weren't meeting those specific rigorous standards. There was a lot of coaching and education that was happening. Some of that was in the product and some of it wasn't. It was something that was discussed at all of the meetings that we had across everyone's teams, right? Everyone understood that it was important. And so I think that really impacted both the ops team as well as the product team who are literally building the product that would bring that to life. And I think just thinking from, especially if you're a founder and you're thinking about building your sort of early metrics, there's a lot of ways to really make sure your team really understands what that means. Another thing we did a lot on the experiences team is we just dogfooded all the time. And so we were lucky in that it's a really fun product to dogfood. We were taking experiences all over the world all the time. But it really helped because you would know right away when you showed up to an event, if you were going to have a five star experience or if it was not going to be great. I mean that really helped us too because then we would go back to the teams and be like, "All right, we were just in San Francisco. We were on an experience last night, and it did not go well. What do we do about it?" So there's lots of ways to do it. But dogfooding is a good one.

**中文翻译:**
他们是如何将其付诸实践的？因为听起来很棒——“确保所有评价都是五星”。但你如何将其融入团队的运作方式并追踪成功呢？
是的，很大一部分其实是运营层面的，就是确保那些没达到严格标准的房东得到改进。当时有很多辅导和教育工作，有些是在产品内完成的，有些则不是。这是我们在所有跨团队会议上都会讨论的事情，对吧？每个人都明白这很重要。我认为这深刻影响了运营团队以及负责构建产品的产品团队。特别是如果你是一名创始人，正在考虑建立早期指标，有很多方法可以确保团队真正理解其含义。我们在“体验”团队做的另一件事就是不断地进行“内部试用”（dogfooding）。我们很幸运，因为这是一个非常有趣的试用产品。我们经常在世界各地参加各种体验。这真的很有帮助，因为当你到达现场时，你立刻就能知道这是否会是一个五星级的体验。这对我们也很有帮助，因为我们会回到团队说：“好吧，我们昨晚在旧金山参加了一个体验，效果不好。我们该怎么办？”所以有很多方法，但“内部试用”是一个很好的方法。

---

### (00:11:02) Lenny

**English:**
I know Brian is infamous for texting the team anytime anything isn't working right in the product. And I know he was very intimately involved in experiences. Is that something you've learned to do just to kind of like, "Hey team, I found a big problem. Let's fix it." Or do you try to avoid that and not create that stress?

**中文翻译:**
我知道 Brian（Airbnb CEO）以随时给团队发短信指出产品问题而“闻名”。我也知道他非常深入地参与了“体验”业务。你是否也学会了这种做法，比如“嘿团队，我发现了一个大问题，快修好它”？还是说你会尽量避免这样做，以免造成压力？

---

### (00:11:20) Nickey Skarstad

**English:**
I mean I think sometimes that can be a healthy stress if you do it in the right way. The nice thing I think is just making autonomous teams that feel like it is their goal to bring that quality experience to life can help you avoid some of that. But I do think that pushing teams to use the product so they firsthand experience when it is not great is a really good way to give teams sort of the motivation to act on fixing things like that. But I don't know that I text people, but I'm on Slack all the time. So if anything, I'm going to Slack you.

**中文翻译:**
我觉得如果方式得当，有时这是一种健康的压力。我认为比较好的做法是建立自主的团队，让他们觉得创造高质量体验就是他们自己的目标，这可以帮你避免一些压力。但我确实认为，推动团队去使用产品，让他们亲身体验到产品不好的地方，是激励团队去修复问题的好方法。我不确定我是否会给人发短信，但我一直都在 Slack 上。所以如果有事，我会发 Slack 给你。

---

### (00:11:49) Lenny

**English:**
Great. Okay. Maybe one more question on this topic because it's so interesting. So on experiences you measured, I imagine, percentage of trips that were five star. Are there other quality metrics that you've used at other companies that you found helpful for keeping track of product quality and maintaining product quality?

**中文翻译:**
太好了。关于这个话题再问一个问题，因为它太有趣了。在“体验”业务中，我猜你们衡量的是五星订单的百分比。在其他公司，你还用过哪些你认为对追踪和维持产品质量有帮助的质量指标吗？

---

### (00:12:03) Nickey Skarstad

**English:**
Yeah. So another one that we used at Etsy, which was an interesting one, is we realized that, so one of the pieces of product that I owned was the onboarding flow. So it was onboarding new sellers specifically. And you can imagine if you're owning that flow, you're just going to be like, all right, we just need a ton of sellers, and we need them to open their shops right away. So we started and we went down that path. And then we realized we actually tanked a couple of downstream metrics that we didn't really understand at first. And those metrics were basically getting sellers to a first sale. So we opened up a lot of shops, but they actually weren't successful when they were on the platform, and they weren't successful in a certain amount of time.

**中文翻译:**
有的。我们在 Etsy 使用过一个很有趣的指标。我当时负责的产品之一是入驻流程（onboarding flow），特别是新卖家的入驻。你可以想象，如果你负责这个流程，你肯定会想：“好吧，我们需要大量卖家，我们需要他们立刻开店。”于是我们开始朝这个方向努力。但后来我们发现，我们实际上拉低了几个起初没太理解的下游指标。这些指标主要是关于“让卖家完成首单销售”。我们开了成千上万家店，但他们在平台上其实并不成功，或者在一定时间内没能成功。

---

### (00:12:37) Nickey Skarstad

**English:**
So we did a lot of unpacking of what happened there, why did we do that, and actually does that matter? And the end answer was, yes, it matters greatly. When Etsy sellers are opening their shop, it's really important that you get them a sale right away because it's a huge motivator, right? If you make a sale in your first day, you're like, "Oh wow. Okay, this is a thing. I could make money doing this. This is exciting. I get to ship something to my buyer." If it takes you seven days, you start to be like, "Oh no. I'm not good enough. I'm terrible at this." 10 days, into 30 days, it really impacts people. And so we actually put more friction in the onboarding flow to help to start to solve for that. So we actually slowed you down. We made you be more thoughtful about what you were listing. And by doing that, we actually helped you get to a first sale faster. And so that was another good example of a quality metric that we used, which was, I think it was first sale in seven days. I might be wrong. But something along those lines. And it actually conflated with the high level growth metrics, but it was a huge quality predictor, and it was really important for long term seller success.

**中文翻译:**
所以我们深入分析了发生了什么，为什么会这样，以及这是否真的重要。最终答案是：是的，非常重要。当 Etsy 卖家开店时，让他们立刻完成一笔销售非常重要，因为这是巨大的动力，对吧？如果你在第一天就卖出了东西，你会觉得：“噢哇，这行得通。我能靠这个赚钱。这太让人兴奋了。我可以给买家发货了。”如果花了 7 天，你会开始想：“噢不，我不够好，我做这个很差劲。”如果拖到 10 天甚至 30 天，真的会打击到人。所以我们实际上在入驻流程中增加了更多“摩擦”（friction）来解决这个问题。我们让你慢下来，让你更深思熟虑地去发布商品。通过这样做，我们反而帮助卖家更快地达成了首单。这就是我们使用的另一个很好的质量指标例子，我记得是“7 天内首单率”。可能记错具体天数，但大概就是这样。它实际上与高层级的增长指标结合在一起，但它是一个巨大的质量预测指标，对卖家的长期成功至关重要。

---

### (00:13:32) Lenny

**English:**
So interesting. That's such a good topic. And I feel like we could explore that for an hour, but maybe for a little bit longer. Was that metric the metric that you used to measure supply growth at that point? Or was it alongside just general growth?

**中文翻译:**
太有意思了。这是一个非常好的话题。我觉得我们可以聊上一小时，不过先稍微深入一点。那个指标是你当时衡量供应增长的主要指标吗？还是它只是作为一般增长指标的补充？

---

### (00:13:45) Nickey Skarstad

**English:**
Yeah, it was alongside general growth. It wasn't our top, top OKR. But it mattered because, again, it's sort of like you think about these things a bit as a seesaw, right? We basically were balancing our growth with making sure people were successful. And the more equilibrium you had there, the better it was for their overarching marketplace. And it's similar if you think about experiences too, right? Where, all right, you could just be growing, but people are having a terrible experience. So how do you balance those two things? And if you can get those two things in balance, you're going to cruise, and you're going to be more successful longer term.

**中文翻译:**
是的，它是与一般增长并行的。它不是我们最核心的 OKR，但它很重要。因为，这就像是一个跷跷板，对吧？我们基本上是在平衡增长和确保用户成功。你越能达到这种平衡，对整个市场就越有利。如果你想想“体验”业务也是一样的，对吧？你可以只追求增长，但如果人们的体验很糟糕，那就不行。所以你如何平衡这两者？如果你能让这两者达到平衡，你就会顺风顺水，长期来看会更成功。

---

### (00:14:14) Lenny

**English:**
Got it. At Airbnb when I was working on supply growth, our main goal for the supply growth team was similar. And that was actually the goal we had, which is new listings that got their first booking. We only counted listings that had one booking as new supply. Everything else didn't really count. Because we knew that if it got booked at least once, at least it's got some level of quality and people want that place, and it's valuable to the marketplace. Okay. So you were at Airbnb, and where'd you go next?

**中文翻译:**
明白了。我在 Airbnb 负责供应增长时，我们团队的主要目标也很类似。我们当时的目标就是“获得首单预订的新房源”。我们只把获得过一次预订的房源计为新供应，其他的都不算。因为我们知道，如果它被预订过至少一次，说明它至少有一定的质量，有人想要那个地方，它对市场是有价值的。好，你在 Airbnb 之后去了哪儿？

---

### (00:14:40) Nickey Skarstad

**English:**
Yeah. So I went to a startup. And for lack of a better way to describe this, they were basically kind of building a marketplace as well, but it was more of a marketplace of ideas. And I hate when people say that, because I think it's cheesy, but it's true. They had physical co-working spaces, and they were trying to take some of the magic that was happening in their spaces. So people meeting each other, networking, people getting funding for their startups, et cetera. And they wanted to bring it online and they wanted to try to scale it so it wasn't constrained inside of their four walls. So I helped them basically come up with a longer term strategy, start to figure out how to unpack that, and get product market fit. And then also just build a technology team around trying to solve that.

**中文翻译:**
是的。我后来去了一家初创公司。由于没有更好的描述方式，他们基本上也是在构建一个平台（marketplace），但更多是“思想的平台”。我讨厌人们这么说，因为我觉得这很俗气，但事实确实如此。他们有实体的联合办公空间，并试图捕捉空间里发生的那些神奇时刻——比如人们互相结识、建立人脉、初创公司获得融资等等。他们想把这些带到线上并尝试规模化，使其不再受限于四面墙之内。所以我帮助他们制定了长期战略，开始研究如何拆解这个问题并找到 PMF，同时也建立了一个技术团队来尝试解决这个问题。

---

### (00:15:16) Nickey Skarstad

**English:**
And so that started late 2019. And then I was out for a bit, had a baby. And came back and then COVID happened. And they were a physical co-working business. That was where their majority revenue came from. And so COVID was pretty horrible for what they were trying to do. They also had some other cultural issues, and so the whole thing kind of paused/fell over. So I actually spent a year hiring a team and then had to lay them off, which was a great lesson in leadership. I'm not going to lie. I learned a lot about how to lead in that experience.

**中文翻译:**
那是 2019 年底开始的。后来我离开了一阵子去生孩子。回来后，新冠疫情爆发了。他们是一家实体联合办公企业，那是他们大部分收入的来源。所以疫情对他们想做的事情来说简直是灾难。他们还有一些其他的文化问题，所以整个项目基本上停滞或垮掉了。我花了一年时间招募团队，结果却不得不解雇他们，这对我来说是一堂深刻的领导力课。我不撒谎，在那段经历中我学到了很多关于如何领导的知识。

---

### (00:15:49) Nickey Skarstad

**English:**
But after that, and it was COVID, I had a eight month old, and so I spent time actually just vibing with my kids, which was kind of fun. And then ended up going to Shopify after that. And so I was looking for a more bigger scaled, not startup, and was trying to find something a little bit more something where I could be longer term and was more excited about, and took a platform role at Shopify. And so that was really interesting in that I had, honestly, for the most part spent the majority of my career in super consumer facing roles. And the role that I took was more platform.

**中文翻译:**
在那之后，正值疫情期间，我有一个八个月大的孩子，所以我花时间陪孩子，挺开心的。之后我去了 Shopify。当时我想找一家规模更大、不是初创公司的企业，希望能找个可以长期发展且让我更兴奋的地方，于是我在 Shopify 担任了一个平台型角色。这非常有趣，因为老实说，我职业生涯的大部分时间都在做超级面向消费者的角色，而我接手的这个职位更偏向平台。

---

### (00:16:20) Nickey Skarstad

**English:**
And I realized that, honestly, pretty quickly after I took the role, I was like, oh, good to know. I didn't really understand what this job was and now I know what it is, but it does not give me energy. And so I felt like I had a lot of red energy every day. And so I made a call pretty quickly to bounce, which was actually another good learning experience. I think I've gotten a lot. As I've advanced through my career, have learned a lot about what gives me Nickey Skarstad energy and have been really prioritizing that, especially in a post-COVID world. And so left Shopify, and made my way to Duolingo. And so Duolingo has been super fun. I've been there since September of 2021. And in the process of helping them kind of think through a zero to one product challenge, something that's newer. Can't really talk about it unfortunately, but has been another sort of product market fit thinking exercise. It reminds me a little bit of some of the work that I did on experiences. And so it's been actually pretty challenging. It's super fun. So I'm also having a great time here as well.

**中文翻译:**
老实说，接手这个角色后很快我就意识到：“噢，了解了。”我之前并没真正理解这份工作是做什么的，现在我知道了，但它不能给我能量。我觉得每天都有很多“负能量”（red energy）。所以我很快决定离开，这其实又是另一段很好的学习经历。随着职业生涯的发展，我学到了很多关于什么能给我“Nickey Skarstad 能量”的东西，并开始真正优先考虑这些，尤其是在后疫情时代。于是我离开了 Shopify，来到了 Duolingo。在 Duolingo 的经历非常有趣，我从 2021 年 9 月就在这里了。目前正在帮助他们思考一个从 0 到 1 的产品挑战，是一些比较新的东西。遗憾的是不能细说，但这是另一个关于产品市场契合点的思考练习。它让我想起了我在“体验”业务上做的一些工作。所以这其实挺有挑战性的，也非常有趣。我在这里也过得很愉快。

---

### (00:17:12) Lenny

**English:**
Amazing. The companies you worked at is incredible and there's so much I want to explore there. Going back to Shopify briefly, a lot of PMs, I imagine, are trying to decide should they stay where they're at? Should they go explore other places? So you said the thing that kind of pulled you out there was just the platform role didn't feel like a fit for you. Do you have any advice for folks on just how to know if a role or a company isn't a fit for them?

**中文翻译:**
太棒了。你工作过的公司都非常了不起，我有很多想探讨的地方。简短回到 Shopify 的话题，我想很多 PM 都在纠结是该留守现状还是去探索其他地方。你提到让你离开的原因是平台型角色不适合你。对于如何判断一个职位或一家公司是否适合自己，你有什么建议吗？

---

### (00:17:37) Nickey Skarstad

**English:**
Yeah. So I think I really learned that while I was there, and also I want to make sure I actually had a great experience at Shopify and I think it is an awesome company. I would highly recommend people work there, especially if they like platform product work. One of the things I did when I was like, I don't know if I love this is I actually went through my calendar and I changed the colors of all of the meetings on my calendar to red, yellow, and green after I had the meeting. And I looked. And basically if it was yellow, I was like, okay. It was a fine meeting. My energy was baseline. If it was red, I was either bored or I was stressed, or I was not having a good time. And if it was green, it gave me energy and I felt excited and I wanted to keep working on that.

**中文翻译:**
是的。我在那里学到了很多。另外我想强调，我在 Shopify 的体验其实很好，我认为它是一家很棒的公司。我强烈推荐人们去那里工作，特别是如果你喜欢平台类产品工作的话。当我纠结自己是否喜欢这份工作时，我做了一件事：我翻看日历，在开完会后把所有会议的颜色改为红、黄、绿。如果会议是黄色的，我觉得还行，能量处于基准线。如果是红色的，说明我要么感到无聊，要么压力很大，或者过得不开心。如果是绿色的，它能给我能量，让我感到兴奋，想继续做下去。

---

### (00:18:17) Nickey Skarstad

**English:**
And when I looked back at the last few weeks, it was almost all red and yellow. And I was like, okay, this is really from an energy standpoint, I don't think I love this. And so I would say think about the work that you're doing and that lens. Get really good at figuring out what are the things that you love most about being a product person, and how can you optimize your next role for those things that you love? We should talk a little bit more about this, but each company has a very different product org. And the day to day of your job as a product manager, depending on where you go in the product that you're building, is very different. And so really thinking through what that work looks like, what their process is, who your end consumer is, what will the actual work you be doing every day, what will that be? And if you can get really clear on that, and then get clear on what gives you energy and what you love, it makes it a lot easier to figure out where you should go next.

**中文翻译:**
当我回顾过去几周时，发现几乎全是红色和黄色。我想：“好吧，从能量的角度来看，我不认为我喜欢这个。”所以我想说，请从这个视角去审视你的工作。要非常清楚作为产品人你最喜欢什么，以及如何在下一个职位中针对这些喜好进行优化。我们应该多聊聊这个，因为每家公司的产品组织架构都非常不同。作为产品经理，你的日常工作取决于你去哪家公司以及你构建什么产品，差异非常大。所以要深入思考那份工作看起来是什么样的，他们的流程是什么，最终消费者是谁，你每天实际要做的工作到底是什么？如果你能把这些想清楚，再弄清楚什么能给你能量、你热爱什么，那么决定下一步去哪儿就会容易得多。

---

### (00:19:04) Lenny

**English:**
Wow. I love that tactic. I've never heard of that. Just going back to the meetings that you have in measuring, just reflecting on how much energy that meeting gave you. Great tip. Thank you for sharing that. And I'll also double down on Shopify is an amazing place to work. Just to make that clear. It's probably one of the few places I recommend PMs go try to work at.

**中文翻译:**
哇，我太喜欢这个策略了。我以前从未听说过。回顾会议并衡量它给了你多少能量。非常棒的建议，谢谢分享。我也要再次强调，Shopify 是一个非常棒的工作场所。这是我为数不多的会推荐 PM 去尝试的地方之一。

---

### (00:19:23) Nickey Skarstad

**English:**
Yeah. I think especially if you're newer in your PM career, they just have a really great organization. And I think it's a great place to learn how to PM. Also their product, it's a huge scaled product. And so it's complicated to build in. So I think it's a great place to really understand second order systems and systems thinking. And especially if that type of work gives you energy, I would recommend that people look for jobs there. But again, get really good at what you love. And I think what I've realized longer term is I really like the zero to one early stage. How do we get product market fit? And how do we really think through the early experience? And Shopify is at a very different stage than that. They're doing that in a couple places for sure, but that's not their day to day. And so that was interesting.

**中文翻译:**
是的。我认为特别是如果你是 PM 职业生涯的新人，他们有一个非常棒的组织。那是学习如何做 PM 的好地方。此外，他们的产品规模巨大，构建起来非常复杂。所以我觉得那是真正理解“二阶系统”（second order systems）和系统思维的好地方。特别是如果这类工作能给你能量，我推荐大家去那里找工作。但再次强调，要弄清楚你热爱什么。从长远来看，我意识到我真正喜欢的是从 0 到 1 的早期阶段。如何获得 PMF？如何深入思考早期体验？Shopify 所处的阶段与此非常不同。当然他们在某些地方也在做这些，但那不是他们的日常。所以这很有趣。

---

### (00:20:06) Lenny

**English:**
Yeah. That makes a lot of sense. Going back to what you just touched on, the idea of product org and structure and how different companies build product, there's kind of two ways to approach this and take whichever direction you want. Which of the companies you've worked at did you enjoy most, and that's kind of stuck with you as a way you want to build product? Or just like, how would you approach building a product org in cross-functional teams versus not, and reporting lines, things like that? What do you recommend there?

**中文翻译:**
是的，非常有道理。回到你刚才提到的产品组织架构和不同公司构建产品的方式，有两种切入点，你可以选任何一个方向。在你工作过的公司中，你最喜欢哪一家的模式，并且这种模式一直影响着你构建产品的方式？或者说，你会如何处理构建产品组织中的跨职能团队、汇报线之类的问题？你有什么建议？

---

### (00:20:34) Nickey Skarstad

**English:**
Yeah. So I feel like you're asking me to pick a favorite child, which especially as a mother, that's hard to do. But no, I don't know. I feel like I've learned things from a lot of these different places and it's hard to choose. I think some of my early work at Etsy was very formative, and it was where I learned how to be a product manager. And so I feel very proud of that. I also think Etsy was out there building in public. I'm literally doing air quotes right now. I know you can't see me.

**中文翻译:**
好的。我觉得你是在让我选一个最喜欢的孩子，作为母亲这很难选。不过，我从很多不同的地方都学到了东西，很难抉择。我认为我在 Etsy 的早期工作非常有塑造性，那是我学习如何成为产品经理的地方，我为此感到自豪。我也认为 Etsy 当时是在“公开构建”（building in public）——我正在做“空气引号”的手势，我知道你看不见。

---

### (00:20:57) Lenny

**English:**
I can see them.

**中文翻译:**
我能看见。

---

### (00:20:58) Nickey Skarstad

**English:**
But they were doing that because they had such a passionate, involved, engaged early community that they could not just ship things and have them land well if they did not involve their community early. So they were doing prototyping, beta testing, and basically getting people to try things and give feedback on things. I honestly, I think before a lot of people were, and that was something at the time that was really interesting and has really stayed with me, it's how to work with community and how to build community around the product that you're building. Because at the end of the day, especially when it's early days, it really helps scale, get people to evangelize what you're building, help teach other people how to use it, things like that. And so I learned how to do that at Etsy. And I think that was super formative. And then also just Airbnb, what we talked about before, and just deeply baking in product quality and the end consumer experience into everything that you're building is also something I literally apply every day. So if I had to choose, it would be those two places, but I plan on continuing to learn.

**中文翻译:**
但他们之所以这么做，是因为他们拥有一个非常热情、深度参与的早期社区。如果不让社区尽早参与，他们就无法顺利发布产品并获得良好反响。所以他们当时就在做原型设计、Beta 测试，基本上是让人们尝试并提供反馈。老实说，我觉得他们在很多人之前就开始这么做了，这在当时非常有趣，也一直影响着我：如何与社区合作，以及如何围绕你正在构建的产品建立社区。因为归根结底，特别是在早期，这真的有助于规模化，让人们去宣传你构建的东西，帮助教别人如何使用等等。我在 Etsy 学会了这些，这对我影响深远。然后就是 Airbnb，就像我们之前聊过的，将产品质量和最终消费者体验深度融入到你构建的每一件事中，这也是我每天都在实践的东西。所以如果要选，就是这两个地方，但我打算继续学习。

---

### (00:21:54) Lenny

**English:**
Interesting. Both very community driven businesses.

**中文翻译:**
有趣。两家都是非常由社区驱动的企业。

---

### (00:21:57) Nickey Skarstad

**English:**
True.

**中文翻译:**
确实。

---

### (00:21:58) Lenny

**English:**
And then in terms of how they structured their org, is there anything there about just here's what I've learned works best for how to build product teams, structure product teams, that stuck with you?

**中文翻译:**
那么在组织架构方面，关于如何组建和构建产品团队，有没有什么你认为最有效的经验让你印象深刻？

---

### (00:22:07) Nickey Skarstad

**English:**
Yeah. So I think there's kind of two overarching popular organizational modes for product org specifically. There's either the functional organization where everyone in the product team will report up through either a VP product, or a chief product officer, or something along those lines. And I think that actually really works in certain circumstances and is great. And typically how that works is you'll have your product partners, your trifecta, if you will, you have your design partner and your engineering partner, they will typically also report up into functional leadership. I think in bigger organizations that really works well, especially when you have orgs that need a lot of development in the function. So you'll have a lot of either APMs or product managers who are newer in their career and need a lot of support in development. And I think those functional ways of building makes sense. When I was at Etsy, that was the way that the reporting structure was and it made a lot of sense.

**中文翻译:**
好的。我认为产品组织主要有两种流行的模式。一种是“职能型组织”（functional organization），产品团队的所有人都向产品副总裁或首席产品官（CPO）汇报。我认为这在某些情况下非常有效。通常情况下，你会有一个“三位一体”（trifecta）的合作伙伴：你的设计伙伴和工程伙伴，他们通常也向各自的职能领导汇报。我认为在大型组织中这很有效，特别是当组织需要在职能专业性上进行大量培养时。比如你有很多 APM 或职业生涯早期、需要大量支持和培养的产品经理。我认为这种职能化的构建方式是有道理的。我在 Etsy 时就是这种汇报结构，非常合理。

---

### (00:23:00) Nickey Skarstad

**English:**
And then on the flip side, actually, when I was at Airbnb, because experiences was this new pretty nascent business opportunity, it had a GM structure. And so basically the whole product org that worked on experiences laddered up into a business leader and that business leader managed all of the functions. So they were the manager of the operations team, the marketing folks, product, and whatever. And I actually think that really worked for team like experiences at a company like Airbnb because what it did is it gave the leader of that business a ton of autonomy to really figure out what does this business need to be successful? And they didn't have to rely on, I guess they did in some ways, but not 100% rely on the larger company's resources to get the work that they needed done.

**中文翻译:**
另一方面，我在 Airbnb 时，因为“体验”是一个全新的、尚处于萌芽阶段的业务机会，它采用了 GM（总经理/业务负责人）结构。基本上，负责“体验”的整个产品组织都向一位业务负责人汇报，而这位负责人管理所有职能部门——包括运营团队、市场营销、产品等等。我真的认为这对于像 Airbnb 内部的“体验”团队非常有效，因为它给了业务负责人极大的自主权，去弄清楚这个业务成功需要什么。他们不需要完全依赖（虽然在某些方面还是需要）大公司的资源来完成工作。

---

### (00:23:44) Nickey Skarstad

**English:**
And I actually think that had they launched experiences inside of the Etsy style of organizational structure, it never would've succeeded because it had such a unique business need, and it needed its own process and ways of building product, et cetera. And because they sort of, hate to say wall it off, because it wasn't fully walled off, but because they gave it its own space and its own structure, it allowed it to succeed because they were able to fund it in the right way, give it the resources that it needed, et cetera. So I've seen those two types of models work. And I think if I was a founder and I was building my initial product org, how I would think about it was basically what are we trying to build? What is the product? And then what type of process do we need to put in place for us to figure out how do we build it? And then what type of people do we need? And then really taking a step back to really figure out, all right, organizationally, how do we shape this so we can make sure that those people have autonomy and they have what they need to just be able to cruise? So I honestly don't think there's a right way. I know that's a non-answer. I think it really depends on what you're trying to build and the stage at which you're at.

**中文翻译:**
我甚至认为，如果他们是在 Etsy 那种职能型结构下发布“体验”业务，它永远不会成功。因为它有如此独特的业务需求，需要自己的流程和构建产品的方式。虽然我不想说“隔绝”（wall it off），因为它并没有完全隔绝，但因为公司给了它独立的空间和结构，才让它得以成功，因为他们能以正确的方式资助它，给它所需的资源。所以我见过这两种模式都奏效。如果我是一名创始人，正在组建最初的产品组织，我会思考：我们要构建什么？产品是什么？我们需要什么样的流程来弄清楚如何构建它？我们需要什么样的人？然后退后一步思考：在组织上，我们该如何塑造它，以确保这些人拥有自主权，并拥有顺畅运行所需的一切？所以我真的不认为有唯一的正确答案。我知道这听起来像没回答，但我认为这确实取决于你要构建什么以及你所处的阶段。

---

### (00:24:48) Lenny

**English:**
Is there a default approach you'd suggest, just like most often you should go to the GM model, or most often you should just go with this cross-functional team?

**中文翻译:**
有没有一个你建议的默认方案？比如大多数情况下应该采用 GM 模式，或者大多数情况下应该采用这种跨职能团队模式？

---

### (00:24:58) Nickey Skarstad

**English:**
Yeah. I mean, I think especially if your business is new, going functional makes sense because you don't necessarily have a lot of organizational complexity. Airbnb at the time we were there, Lenny, was a huge company, right? It had tons of different teams that were trying to tackle many different problems. So that GM model made a lot of sense because it again was able to take a specific business opportunity, give it the resources that it need, and give it space to run. When your company's smaller stage, I think that matters less. Typically, especially if you're working on solving similar problems as an organization, functional makes a ton of sense. Because then you're also thinking more holistically about, all right, how do we build the right product development process across different functions to make sure that we are, to use a bad metaphor, it's like the symphony metaphor. You have all these different instruments that need to figure out how do we play together at the right times? And I think that functional way of working actually allows you to do that really well.

**中文翻译:**
是的。我的意思是，特别是如果你的业务还很新，采用职能型模式是有道理的，因为你还没有太多的组织复杂性。Lenny，我们在 Airbnb 的时候，它已经是一家巨型公司了，对吧？它有无数不同的团队在尝试解决许多不同的问题。所以 GM 模式非常有意义，因为它能抓住一个特定的业务机会，给予所需资源并给它运行空间。当你的公司规模较小时，这就不那么重要了。通常情况下，特别是如果整个组织都在解决类似的问题，职能型模式非常有意义。因为这样你就能更全面地思考：我们如何在不同职能部门之间建立正确的产品开发流程，以确保我们——用一个不太恰当的比喻——就像交响乐团一样。你有所有这些不同的乐器，需要弄清楚如何在正确的时间协同演奏。我认为职能型的工作方式能让你很好地实现这一点。

---

### (00:25:52) Lenny

**English:**
This episode is brought to you by Unit. What did Gusto, Uber, Shopify, and AngelList all have in common? They've all decided to build banking into their product. According to AngelList's head of product, "Banking makes every single feature more interesting. With it, our platform functions as financial mission control for our customers. Without it, we're just another software tool in a big messy stack." Embedding banking into your product, not only adds differentiation, but also helps you acquire, retain and monetize your customers. Unit is the market leader in banking as a service, combining multiple bank partners with a developer friendly API to empower companies of all sizes to launch accounts, cards, payments, and lending in just a few weeks. Unit is trusted by leading brands, such as AngelList, ID, Invoice2go, and Roofstock. To hear more about how Unit enables companies like yours to build banking, visit unit.co/lenny to request a demo or to try their free sandbox. That's unit.co/lenny.

**中文翻译:**
本期节目由 Unit 赞助。Gusto、Uber、Shopify 和 AngelList 有什么共同点？他们都决定在产品中内置银行功能。根据 AngelList 的产品负责人所说：“银行功能让每一个功能都变得更有趣。有了它，我们的平台就像客户的金融任务控制中心；没有它，我们只是庞杂软件堆栈中的另一个工具。”在产品中嵌入银行功能不仅能增加差异化，还能帮助你获取、留住客户并实现变现。Unit 是“银行即服务”（BaaS）领域的市场领导者，它将多个银行合作伙伴与开发者友好的 API 相结合，赋能各种规模的公司在短短几周内推出账户、卡片、支付和贷款功能。Unit 深受 AngelList、ID、Invoice2go 和 Roofstock 等领先品牌的信赖。欲了解更多关于 Unit 如何赋能贵公司构建银行功能的信息，请访问 unit.co/lenny 申请演示或尝试他们的免费沙盒。网址是 unit.co/lenny。

---

### (00:26:54) Lenny

**English:**
Something I learned at Airbnb and from many other companies at this point is there's never going to be the one right way to structure, and companies bounce back and forth between them. Like Airbnb, for example, has moved from GM model to functional reporting lines back to GM. And so things change and you try some, see how it goes, adjust, optimize for the biggest opportunity. And then you'll probably change it six months later. I asked a few people that know you and that worked with you questions that they think I should ask you. And one of the questions that came up most often is around how you set vision, translate that into goals, and then execute on those goals. And I know that's something a lot of PMs want to get better at and something that a lot of PMs aren't great at. And so can you just share any thoughts, advice, stories around that and how you do that well?

**中文翻译:**
我在 Airbnb 以及许多其他公司学到的一点是，永远不会有一种“唯一正确”的架构方式，公司总是在不同模式之间跳来跳去。比如 Airbnb，它从 GM 模式转到职能汇报线，后来又转回了 GM 模式。所以情况在变，你尝试一些，看看效果，调整，针对最大的机会进行优化。然后可能六个月后你又改了。我问了几个认识你并和你共事过的人，请教他们觉得我该问你什么。出现频率最高的问题之一是：你如何设定愿景，将其转化为目标，然后执行这些目标。我知道这是很多 PM 想要提升、但很多人并不擅长的事情。你能分享一下关于这方面的想法、建议或故事，以及你是如何做好的吗？

---

### (00:27:43) Nickey Skarstad

**English:**
Yeah. Well one, I want to know who you talked to. That's terrifying. Hopefully they said good things. You don't have to out them.

**中文翻译:**
好的。首先，我想知道你跟谁聊了，这太吓人了。希望他们说的是好话。你不用说出他们的名字。

---

### (00:27:49) Lenny

**English:**
Unnamed sources. Unnamed sources.

**中文翻译:**
匿名消息源，匿名消息源。

---

### (00:27:51) Nickey Skarstad

**English:**
Yes. Well I'm glad to hear that because that actually is some of the work that I honestly love the most. And when I look at my calendar, those are moments where I am green energy. And so I have some first principles that I like to apply when I'm thinking about setting high level vision and strategy. And the first is make sure that you pull in your people and your team. I've seen a lot of director level people through my career who will try to work on strategy in a vacuum alone. They'll write a document and they'll be like, "Okay, team. Here's what we're doing. Here's our strategy." And it never goes well. And it doesn't go well. It might be the right strategy, but because you did not bring people along on that journey to come up with it, they did not feel like they had a hand in crafting it themselves. They are often not bought in, and getting people to buy in when they haven't been involved is very challenging and time consuming. We don't got time, right?

**中文翻译:**
好吧。我很高兴听到这个，因为那确实是我最喜欢的工作之一。当我查看日历时，那些时刻就是我的“绿色能量”时刻。在思考设定高层愿景和策略时，我喜欢应用一些第一性原理。第一点是：确保把你的成员和团队拉进来。在我的职业生涯中，我见过很多总监级别的人试图在真空中独自制定策略。他们写好一份文档，然后说：“好了团队，这就是我们要做的，这是我们的策略。”这从来都不会有好结果。即使策略本身是对的，但因为你没有带大家一起经历制定过程，他们不觉得自己参与了创作。他们通常不会买账，而让没参与的人买账是非常具有挑战性且耗时的。我们没那么多时间，对吧？

---

### (00:29:06) Nickey Skarstad

**English:**
And I think that's my first principle is just bring along the team. And I think there are ways to do that where you're not voting on strategy. You should not be voting. I think good product work is often not democratic, right? You need a clear leader who understands a lot of the signals and understands the larger competitive marketplace that can make decisions. And I think, especially when you're thinking about strategy, it's great to get input, but ultimately at the end of the day, you should have one person who is responsible for it. And the other thing is a lot of times people don't really talk to leadership or the larger business leaders to get organizational context that helps them come up with the right strategy. They'll sort of build something in a vacuum, and then they'll come up with it and they'll get a ton of feedback from people across the org that were like, "Oh, this conflates with our strategy. We're doing this, and it's very similar." Or, "Our structural platform actually does not have the capability for us to do that thing." Whatever. And so just make sure that you're talking to people. And also all the way up to the CEO, and making sure the founder and the CEO is very bought in because ultimately, at the end of the day, they're choosing to resource what you're working on and are going to help you meet what you need. Those are some of the foundations for good vision and strategy work.

**中文翻译:**
所以我认为第一条原则就是带上团队。我认为有一些方法可以做到这一点，而不是通过投票来决定策略。你不应该投票。我认为优秀的产品工作通常不是民主的，对吧？你需要一个清晰的领导者，他理解各种信号，了解更大的竞争市场，并能做出决定。我认为，特别是在思考策略时，获取输入是很好的，但最终应该由一个人负责。另一件事是，很多时候人们不怎么和领导层或更高级别的业务领导沟通，去获取能帮助他们制定正确策略的组织背景。他们会在真空中构建一些东西，然后拿出来，结果收到来自组织各处的大量反馈，比如：“噢，这和我们的策略冲突了，我们正在做非常类似的事情。”或者“我们的平台架构实际上不支持做那件事。”诸如此类。所以要确保你在和人沟通，一直沟通到 CEO，确保创始人和 CEO 非常认可，因为归根结底，是他们在决定为你正在做的事情分配资源，并帮助你获得所需。这些是做好愿景和策略工作的一些基础。

---

### (00:29:51) Nickey Skarstad

**English:**
And then kind of zooming down into the weeds, I really like the vision mission strategy pyramid. I think might be a little tired. I like to think it's wired. But yeah. So if you just think about a pyramid shape, at the top is vision. Below it is mission and strategy, and then objectives. And this is a very simple framework. You honestly just Google vision mission strategy objectives, and you'll see it in Google image results. And all it is really is thinking about hitting those specific notes and thinking about them top down. So where do you need to go long term? What is the long term vision of what you're trying to do? In 10 years, if you could zoom up and look at what an ideal path for you would be, what is that? Write it down.

**中文翻译:**
然后深入到细节，我非常喜欢“愿景-使命-策略金字塔”。我觉得这可能有点老生常谈，但我认为它非常有效。想象一个金字塔形状，最顶端是愿景（Vision），下面是使命（Mission）和策略（Strategy），再下面是目标（Objectives）。这是一个非常简单的框架。你直接在谷歌搜索“vision mission strategy objectives”，就能在图片结果里看到它。它的核心就是自上而下地思考并击中那些关键点。长期来看你需要去哪里？你正在做的事情的长期愿景是什么？如果 10 年后你俯瞰理想的路径，那是什么样的？把它写下来。

---

### (00:30:32) Nickey Skarstad

**English:**
And then you start, as you go down the pyramid, you get clearer and basically you bring things down to your moment in time more clearly. So if you're thinking about your mission, all right, it's another level of abstraction of how do we make our vision come to life. And then you get into strategy. All right, how do we actually pick apart what we think is going to need to happen for us to actually be able to execute on that vision? And then your objectives can be OKRs, or whatever sort of goal setting model that you use to really one level get clear on, all right, in the next three to six months, what are the actual notes that we need to hit to be able to sing that beautiful symphony, is a terrible metaphor. And now I'm open to say it. But whatever.

**中文翻译:**
然后，当你沿着金字塔向下走，你会变得越来越清晰，基本上是把事情更明确地带到当下的时间点。如果你在思考使命，那是关于“我们如何让愿景成真”的另一层抽象。接着进入策略：为了执行愿景，我们认为实际需要发生哪些事情？然后你的目标（Objectives）可以是 OKR，或者你使用的任何目标设定模型，在这一层级明确：在接下来的三到六个月里，我们需要击中哪些音符，才能演奏出那部美丽的交响乐——这是一个很烂的比喻，但我还是说出来了。管它呢。

---

### (00:31:15) Lenny

**English:**
I get it. I get it.

**中文翻译:**
我懂，我懂。

---

### (00:31:16) Nickey Skarstad

**English:**
Dang it. Love a bad metaphor.

**中文翻译:**
该死，我就爱烂比喻。

---

### (00:31:16) Lenny

**English:**
That's evocative. While we're on that topic, actually just to interrupt briefly, how are you very practically doing this for say vision and mission? Are you starting a Google doc and writing it out, are you using Miro or FigJam, or something like that?

**中文翻译:**
这很有启发性。既然聊到这个话题，我想插一句，在实际操作中，你是如何制定愿景和使命的？是开一个 Google 文档写下来，还是使用 Miro 或 FigJam 之类的工具？

---

### (00:31:30) Nickey Skarstad

**English:**
Yeah, so I think visioning exercise is a great moment to pull in your larger team. Because I'm remote now, I would use Miro or FigJam. Duolingo, we use FigJam typically because we are super embedded in Figma. In the past I've used MURAL. I actually personally like MURAL's whiteboarding product better. So I would open that up and I would walk through a number of things with the team and do a brainstorm literally. All right. Where do you all see us going in 10 years? What do we think what is the larger competitive landscape going to do in the next 10 years that could need to influence the work that we're doing? What are their ideas, and get everyone thinking.

**中文翻译:**
是的，我认为愿景构思练习是拉入大团队的好时机。因为我现在是远程办公，我会用 Miro 或 FigJam。在 Duolingo，我们通常用 FigJam，因为我们深度使用 Figma。过去我也用过 MURAL，个人其实更喜欢 MURAL 的白板产品。我会打开它，带团队过一遍各项内容，进行真正的头脑风暴。比如：“你们觉得 10 年后我们会走向何方？”“我们认为未来 10 年更大的竞争格局会发生什么变化，从而影响我们的工作？”听听他们的想法，让每个人都思考起来。

---

### (00:32:05) Nickey Skarstad

**English:**
Good brainstorm are often cross-functional. So go outside of your own team. Can you pull in somebody from marketing? Can somebody from the larger policy team sit in? How do you make it really cross-functional and really zoom up and give everyone the space and the freedom to think existential and to frame it that way,?we are going to be thinking in a five to 10 year timeline. Do not worry about what's happening today. And honestly, if you do that right, those are super fun exercises.

**中文翻译:**
好的头脑风暴通常是跨职能的。所以要跳出你自己的团队。你能拉个市场部的人进来吗？大政策团队的人能旁听吗？如何让它真正跨职能，真正拉高视角，给每个人空间和自由去进行本质性的思考，并设定好框架：我们要思考的是 5 到 10 年的时间线，不要担心今天发生了什么。老实说，如果做得好，这些练习非常有趣。

---

### (00:32:30) Lenny

**English:**
And you're doing this remotely, I imagine.

**中文翻译:**
我猜你是远程做这些的。

---

### (00:32:32) Nickey Skarstad

**English:**
Yep.

**中文翻译:**
是的。

---

### (00:32:33) Lenny

**English:**
And so do you just kind of schedule a meeting, kick it off, point everyone to this Miro doc, for example, with a bunch of prompts and sticky notes and things like that? How do you actually practically do that?

**中文翻译:**
所以你就是安排一个会议，启动它，然后把大家引向这个 Miro 文档，文档里有一堆提示语、便签纸之类的？实际操作中你是怎么做的？

---

### (00:32:44) Nickey Skarstad

**English:**
So I would pre-fill out the Miro beforehand. So figure out what are the things you want to discuss with your team, create them as headers in the Miro document. So when everyone lands in there, you have a very clear here's what we're talking about today. You can put that into the agenda on your calendar invite. I've actually been to some really good strategic brainstorms that will attach some kind of competitive thinking landscape in advance. So people could have a little bit of a pre-read.

**中文翻译:**
我会事先预填好 Miro。弄清楚你想和团队讨论哪些事情，把它们作为 Miro 文档的标题。这样当大家进入文档时，就能非常清楚今天我们要谈什么。你可以把这些写进日历邀请的议程里。我参加过一些非常棒的战略头脑风暴，他们会提前附上某种竞争格局分析，让大家可以提前阅读。

---

### (00:33:06) Nickey Skarstad

**English:**
And then when you get into the actual session, you already have the time allotments scheduled and thought through. And both Miro and FigJam have really awesome timer, and it'll play music while everyone is working. It's pretty cute. FigJam's sounds are really well done. Whoever their sound architect is, bravo. And it'll ding after, give them 10 minutes and it'll give you a nice chime, and then you can review them together and you can go through each touchpoint that you want to talk about. After it's done, I like to do some synthesis together in the meeting. So basically grab ideas that are similar, bucket things into concepts that are alike. And then I will take it later and spend more time thinking about it. I think a lot of people think you have to actually come away with a vision together in a meeting that's very clear, and you don't. You can just come up with ideas, take a stab at drafting it, and get some more feedback before it's final.

**中文翻译:**
然后进入实际环节时，你已经安排好了时间分配。Miro 和 FigJam 都有很棒的计时器，大家工作时还会播放音乐，挺可爱的。FigJam 的声音做得非常好，向他们的声音架构师致敬。计时结束时它会叮一声，给他们 10 分钟，然后发出悦耳的铃声。接着你们可以一起回顾，过一遍你想讨论的每个要点。结束后，我喜欢在会议中一起做一些综合归纳（synthesis）。基本上就是把相似的想法抓出来，把类似的概念归类。之后我会再花时间深入思考。我觉得很多人认为必须在一次会议中共同得出一个非常清晰的愿景，其实不必。你可以先收集想法，尝试起草，在定稿前再获取更多反馈。

---

### (00:33:56) Lenny

**English:**
One last question on this thread, which also could be an entire hour of discussion, are there any examples of prompts or things you ideated that you could share? I know you can't talk about what you're doing at Duolingo, but just to make it a little more concrete for people, what are some examples of things that you brainstormed?

**中文翻译:**
关于这个话题最后一个问题（虽然这也能聊上一小时）：有没有什么提示语或构思的例子可以分享？我知道你不能谈 Duolingo 的事，但为了让大家更有实感，能举几个你头脑风暴过的例子吗？

---

### (00:34:11) Nickey Skarstad

**English:**
Yeah. I mean, so to take it back to experiences, because we've talked about that a lot, so people have some baseline context. Some of the early experiences visioning was really interesting because it was all about what type of experience can we create. And really thinking through when you've traveled in the past, what has brought you joy? Or what were the moments in your travel journey that have been really interesting, provocative, basically you remember the most, and why? And thinking through some of those things as a group. And those are good group exercises, because you're like, wow, I got to know a lot about Lenny by that crazy travel experience that he had. And so really kind of thinking through about how you craft really meaningful prompts that, again, connect to your strategy. So how does that ladder up into strategy? Obviously thinking through the experience that you're creating is going to help you come up with the right vision and fill out your pyramid in the right way, right?

**中文翻译:**
好的。回到“体验”业务，因为我们聊了很多，大家有背景信息。早期的一些愿景构思非常有趣，因为全是关于“我们可以创造什么样的体验”。我们会深入思考：当你过去旅行时，什么带给你快乐？或者你旅途中哪些时刻非常有趣、有启发性，或者让你记忆最深，为什么？大家一起思考这些。这些是很好的团队练习，因为你会觉得：“哇，通过 Lenny 那次疯狂的旅行经历，我对他了解了很多。”所以要思考如何设计真正有意义的提示语，这些提示语要能再次连接到你的策略。这如何向上支撑策略？显然，思考你正在创造的体验会帮助你得出正确的愿景，并以正确的方式填满你的金字塔，对吧？

---

### (00:34:57) Lenny

**English:**
Okay. So we went on kind of on a tangent around brainstorming. Did you want to share more around just going from vision to goals to execution?

**中文翻译:**
好，我们在头脑风暴上扯得有点远了。关于从愿景到目标再到执行的过程，你还想分享更多吗？

---

### (00:35:04) Nickey Skarstad

**English:**
Yeah. So I think just generally, as you walk down that strategy pyramid, really getting down into the OKRs. And I think it's important because sometimes strategy is too abstract and too high level. And it's hard for people to take the step on how do I walk up that pyramid? And that to me is where having good strategy and having good OKRs help your team do that. And so good OKRs to me are just clear articulations of your strategy, whatever it is that are important to you, and it boils it down into the next three months, here's what we're working on. And I think that is just really good for teams because, again, if you're always in the clouds, it starts to get hard to really bring things down to the feature level of we're going to create a Jira ticket for this specific thing that we need to build. It needs to connect up to a strategy and back down.

**中文翻译:**
是的。我认为总的来说，当你沿着策略金字塔向下走，最终会落实到 OKR。这很重要，因为有时策略太抽象、太高层级了。人们很难迈出那一步——我该如何向上攀登那个金字塔？对我来说，拥有好的策略和好的 OKR 能帮助团队做到这一点。对我而言，好的 OKR 就是对你策略的清晰表达，无论对你来说什么是重要的，把它浓缩成：接下来的三个月，这就是我们要做的。我认为这对团队非常有好处，因为如果你总是飘在云端，就很难真正落实到功能层面，比如“我们要为这个具体要构建的东西创建一个 Jira 任务单”。它需要向上连接到策略，再向下延伸。

---

### (00:35:53) Lenny

**English:**
Got it. Where do you put, say, these OKRs? Do you just brainstorm, come up with vision and rough strategy, that translates into goals? Where do you do this? And then also just how long do you usually spend on this overall process?

**中文翻译:**
明白了。你会把这些 OKR 放在哪儿？是先头脑风暴，得出愿景和粗略策略，再转化为目标吗？你在哪里做这些？通常整个过程要花多长时间？

---

### (00:36:06) Nickey Skarstad

**English:**
Yeah. So the way that we do it at Duolingo now is we work on quarterly OKRs. And so that process will kick off usually the third month in the quarter. Really thinking through, all right, how are we trending on our OKRs this quarter? Did we commit to the right number of things? How are we doing? And then it is going, all right, so what do we need to do next quarter? And ideally, again, that's going to plug into a longer term plan. Otherwise it feels a little messy, and it feels not grounded in a long term plan or strategy in any way, shape, or form.

**中文翻译:**
好的。我们在 Duolingo 现在的做法是制定季度 OKR。这个过程通常在每个季度的第三个月启动。我们会深入思考：这季度我们的 OKR 进展如何？我们承诺的事情数量对吗？进展怎么样？然后开始想：下个季度我们需要做什么？理想情况下，这又要接入一个长期计划。否则会感觉有点乱，感觉完全没有立足于长期计划或策略。

---

### (00:36:36) Nickey Skarstad

**English:**
And then, so what we'll do is spend a few weeks as a team coming up with, all right, what could the next quarter look like? What is going to add the most impact and help us execute on that long term strategy? And then how do we make sure that we're setting the right objectives and KRs below them? And then usually there's some sort of leadership review. I actually forget, Lenny, how did goal setting go at Airbnb? I honestly don't remember. It sounds terrible, but it was a while ago. I can't even remember if Airbnb used OKRs.

**中文翻译:**
然后，我们会花几周时间作为一个团队来构思：下个季度会是什么样子？什么能产生最大的影响力并帮助我们执行长期策略？我们如何确保设定了正确的目标（Objectives）和其下的关键结果（KRs）？通常之后会有某种领导层评审。Lenny，我其实忘了 Airbnb 当时是怎么设定目标的了。老实说我不记得了，听起来挺糟糕的，但那是很久以前的事了。我甚至不记得 Airbnb 是否用过 OKR。

---

### (00:37:03) Lenny

**English:**
There was a long period where OKRs were a very big deal. Our head of product was really gungho on OKRs. And I think for a couple years, we were very strict OKR culture. And then it kind of evolved into just rough- (00:37:15): Goals. (00:37:16): ... interpretation of OKRs. Yeah, goals and strategy and mission and vision. And so it's kind of this morphed version at this point, as far as I know.

**中文翻译:**
有一段很长的时间，OKR 是件大事。我们的产品负责人对 OKR 非常狂热。我想有那么几年，我们是非常严格的 OKR 文化。后来它演变成了一种粗略的……（Nickey：目标）……对 OKR 的解读。是的，目标、策略、使命和愿景。据我所知，现在它已经变成了一种演化后的版本。

---

### (00:37:23) Nickey Skarstad

**English:**
Gotcha. Yeah. And I will say OKR frameworks might not be the best for every single team, but having some sort of goal framework that is shared across functions is useful no matter the size or the scale of your business. I think a lot of times people get hung up and they want to nitpick OKRs specifically. And I think some of those criticisms are very fair. But you should have some sort of framework that's shared from a process standpoint across your team that everyone can use and work on together. Because again, it takes your strategy and it brings it down into the now. So you can act on, in the next three months, you can bring something to life, and you're very clear on what that looks like.

**中文翻译:**
明白了。我想说，OKR 框架可能并不适合每一个团队，但拥有某种跨职能共享的目标框架，无论你的业务规模如何，都是有用的。我认为很多时候人们太纠结于对 OKR 本身的吹毛求疵，有些批评确实很中肯。但你应该在流程层面上拥有某种团队共享的框架，让大家能一起使用和协作。因为再次强调，它能把你的策略带入当下。这样你就能在接下来的三个月里采取行动，让某些东西成真，并且你非常清楚那是什么样子的。

---

### (00:37:57) Lenny

**English:**
I'm going to pull out a thread of something you mentioned earlier of how to finally make decisions. And how in your experience the PM kind of is often sort of a final decision maker. I'd love to hear any advice you have of how to set that up on a team where it's either clear the PMs have a little bit more say and/or just bring people along to a final conclusion. Is there any advice on tips and tactics used to help with that?

**中文翻译:**
我想引申一下你之前提到的关于如何最终做决定的内容。根据你的经验，PM 通常是最终决策者。我很想听听你的建议：如何在团队中建立这种机制，既能明确 PM 有更多的发言权，又能带着大家达成最终结论？在这方面你有什么技巧或策略吗？

---

### (00:38:22) Nickey Skarstad

**English:**
Yeah. So I actually just read this really great book that is slightly tangential, but I thought it really applied to this type of basically getting people to align on decisions. It's by Chris Voss. He is this famous FBI negotiator. I think it's called Split the Difference: Negotiating As if Your Life Depends on It. Don't quote me on that.

**中文翻译:**
有的。我最近刚读了一本非常棒的书，虽然有点跑题，但我认为它非常适用于让人们在决策上达成一致。作者是 Chris Voss，他是著名的 FBI 谈判专家。书名好像叫《高难度谈判》（Never Split the Difference: Negotiating As if Your Life Depends on It）。别死扣我说的书名。

---

### (00:38:38) Lenny

**English:**
I think it's Never Split the Difference, right? And then I think he's also got a masterclass which I've watched, which is really good.

**中文翻译:**
我想是《Never Split the Difference》，对吧？而且他还有一个 Masterclass 课程，我看过，非常棒。

---

### (00:38:43) Nickey Skarstad

**English:**
I actually haven't watched the masterclass yet, but it's on my list after reading the book. And a lot of it, I think, especially because he's an FBI person, I thought it was going to be very much, "You're going to do this." And it's all basically his whole approach is empathy, and it's repeating things back to you, making people feel heard, making sure that you're hearing why they maybe don't like your strategy, or why they think that's a bad OKR. And I think if you can spend some time just listening to your team and really understanding why is this not resonating, you can help guide people on the right path. Or you realize you're wrong. Good PMs are humble people, right? You're not always right. Not always going to be right. So how do you know when you're right and wrong is another good podcast that you should do with somebody else cause I'm probably not very at it. Yeah.

**中文翻译:**
我还没看那个课程，读完书后它就在我的清单上了。书里的很多内容，我原以为因为他是 FBI 的，会是非常强硬的“你必须这么做”。但实际上他的整个方法核心是“同理心”，是重复对方的话，让人们感到被倾听，确保你听到了他们为什么不喜欢你的策略，或者为什么觉得那个 OKR 不好。我认为如果你能花时间倾听团队，真正理解为什么你的想法没能引起共鸣，你就能引导大家走上正确的道路。或者你会意识到自己错了。优秀的 PM 是谦逊的，对吧？你并不总是对的，也不可能总是对的。至于如何判断自己是对是错，那是另一个你应该找别人做的播客话题，因为我可能不太擅长这个。

---

### (00:39:28) Nickey Skarstad

**English:**
Yeah. But I think that helps. And the other thing is I love the concept of one way versus two way door decision making, right? If your team is making a really critical long-term decision that's going to be limiting to a lot of the future things that you could want or need to do, that is a one way door decision. And you should spend time really thinking about discussing it, getting feedback and buy-in from your larger community, from your leadership team, et cetera. If it is a two-way door decision, it's not going to make a huge impact, you can change it later if you need to, let your team cruise on those things. Because it gives people autonomy. It helps you move fast. And then it just makes sure that when it does come down to decisions that are harder to change longer term, then those are the moments you should spend time and really think about and discuss and debate, et cetera.

**中文翻译:**
是的。但我认为这很有帮助。另一件事是我非常喜欢的“单向门与双向门”决策概念。如果你的团队正在做一个非常关键的长期决策，它会限制你未来想做或需要做的很多事情，那就是“单向门”决策。你应该花时间深入思考、讨论，获取来自大社区、领导团队等的反馈和认可。如果是“双向门”决策，它不会产生巨大影响，以后需要时可以更改，那就让团队放手去做。因为这能给人们自主权，帮你快速行动。这能确保当遇到那些长期难以更改的决策时，你才会真正投入时间去思考、讨论和辩论。

---

### (00:40:09) Lenny

**English:**
Do you have any examples or stories that come to mind of those sorts of decisions that you kind of help people just go for it, even though I may not necessarily agree?

**中文翻译:**
你有没有想到什么例子或故事，关于这类决策，即使你未必完全同意，但还是帮助大家放手去做的？

---

### (00:40:17) Nickey Skarstad

**English:**
Let's see. Yeah. So one big one that we made at Airbnb that was pretty formative in early days was we came up with basically an articulation of what we thought a good experience was, and the standards that an experience needed to meet for it to be considered a good experience for us. And that was a many month long term project. And it was so important because we ended up building the product around it, building our policies around it, building how we educated our hosts around it. We had one moment in time to figure it out and get it right until it scaled everywhere. And so that was a true one way door decision where it was really hard to change later because we literally needed it to be relatively final.

**中文翻译:**
我想想。在 Airbnb 早期有一个非常具有塑造性的重大决策：我们制定了一套关于“什么是好的体验”的表达，以及一个体验必须满足哪些标准才能被我们认为是好的。那是一个长达数月的项目。它之所以如此重要，是因为我们最终围绕它构建了产品、制定了政策、确定了如何教育房东。我们只有那一次机会把它弄清楚并做对，然后它就会推广到全球。所以那是一个真正的“单向门”决策，以后很难更改，因为我们确实需要它相对定型。

---

### (00:40:53) Nickey Skarstad

**English:**
On Etsy, there was some big decisions that were made at certain points in time around what can be sold in the marketplace, and how to think through what constitutes something that is hand made. Those were one way door decisions, right? It's really hard to change that later because it's going to influence all of the listings that you have in your ecosystem. And so I think really thinking through those types of things are important and really setting teams up to be able to pause and spend some time to get it right because it will influence the end product in a very real way.

**中文翻译:**
在 Etsy，在某些时间点也做过一些重大决策，比如关于平台上可以卖什么，以及如何界定什么是“手工制作”。那些也是“单向门”决策，对吧？以后很难更改，因为它会影响你生态系统中所有的商品列表。所以我认为深入思考这类事情非常重要，要让团队能够停下来花时间做对，因为它会以非常真实的方式影响最终产品。

---

### (00:41:23) Lenny

**English:**
How do you know if it's a one way or a two way door decision? Do you find that it's generally pretty obvious when you're making the decision, or is it sometimes like, oh shit, we should have thought about that more?

**中文翻译:**
你如何判断一个决策是单向门还是双向门？你觉得在做决定时这通常很明显吗？还是有时会觉得“噢该死，我们当时应该多考虑一下”？

---

### (00:41:34) Nickey Skarstad

**English:**
Yeah. I would say I think I'm good at this 80% of the time these days, just because I've seen it done wrong in a lot of ways. But I think it's a muscle that you build honestly, and you get better over time about thinking about second order thinking. And so it's starting to understand, all right, if I make this decision today, it's going to impact this next level of decisions and the next level after that. And that will cascade through our larger system. A great book to read if you are a product person is Thinking in Systems by Donella Meadows. It's just about really thinking through how systems work, and then you can start to extrapolate what is the second order effect of the system. And if you think about that through your own ecosystem, it starts to help you understand, all right, this is a linchpin in our larger ecosystem that we got to be really careful about if we're going to touch it or change it longer term. But I do think some of that it's muscle, you build it over time. You make a couple of mistakes sometimes, and then you have to realize the true consequences of those mistakes and you don't make it again.

**中文翻译:**
是的。我想说我现在 80% 的时间都能判断准，只是因为我见过太多做错的情况。但我认为这确实是一种需要锻炼的肌肉，随着时间的推移，你会越来越擅长“二阶思维”（second order thinking）。也就是开始理解：如果我今天做了这个决定，它会影响下一层级的决定，以及再下一层级的决定，并会在我们的整个系统中产生连锁反应。如果你是产品人，非常推荐读 Donella Meadows 的《系统之美》（Thinking in Systems）。它讲的是如何深入思考系统运作，然后你可以开始推断系统的二阶效应。如果你通过自己的生态系统去思考，它会帮你理解：好吧，这是我们大生态系统中的一个关键环节（linchpin），如果要动它或长期更改它，我们必须非常小心。但我确实认为这是一种肌肉，需要时间建立。有时你会犯几个错误，然后你必须意识到这些错误的真实后果，之后就不会再犯了。

---

### (00:42:29) Lenny

**English:**
Can we talk a bit more about the second order decision framework? I know you have a awesome newsletter post about this, and it was something I wanted to chat about. Is this a framework that PMs can use to make better decisions? And I guess how could they do that? And then maybe just describe a little bit more about just this concept of second order decisions, because it sounds really important.

**中文翻译:**
我们能多聊聊“二阶决策框架”吗？我知道你有一篇关于这个的非常棒的通讯文章，这也是我想聊的话题。这是 PM 可以用来做更好决策的框架吗？他们该如何使用？能不能再多描述一下“二阶决策”这个概念，因为它听起来非常重要。

---

### (00:42:50) Nickey Skarstad

**English:**
Yeah. Basically what second order thinking is is you being able to think beyond the decisions that you're making today. The decisions you make today will affect tomorrow's decisions and your ability to build on your decisions that you made today. And this feels very existential and meta, but why it's important is that, especially when you're building product, is there a cost associated with your time of everything you build. Especially when you're building marketplaces or anything with UGC content. When you make a change today, and it impacts every single user in your ecosystem that then is going to act on that change, it's really hard to make those changes later.

**中文翻译:**
好的。基本上，二阶思维就是让你能够超越今天所做的决定去思考。你今天的决定会影响明天的决定，以及你在今天决定的基础上继续构建的能力。这听起来非常本质且形而上，但它之所以重要，是因为当你构建产品时，你构建的每一件事都有时间成本。特别是当你构建双边市场或任何带有用户生成内容（UGC）的东西时。当你今天做一个改动，它影响到生态系统中的每一个用户，而这些用户随后会根据这个改动采取行动，那么以后想要再改回来就非常难了。

---

### (00:43:23) Nickey Skarstad

**English:**
Let's talk about Airbnb home listing as an example. Really thinking through what are the pieces of data or all the pieces of data in the system that we need to actually list a home. And then how do we use those throughout our whole system in different ways? And then anytime you have to change those things. So that could be little simple things like truncating the length of the title of an Airbnb home when it's listed on the platform. You're going to have mad hosts, you're going to have design changes that need to be made to make sure that they can actually display something in a different way. It gets just inherently more complex the more complex your system is. So that is probably a terribly described way of describing second order thinking.

**中文翻译:**
以 Airbnb 的房源发布为例。深入思考我们在系统中实际发布一个房源需要哪些数据片段。然后，我们如何在整个系统中以不同方式使用这些数据？以及当你需要更改这些东西时会发生什么。这可能是一些简单的小事，比如缩短 Airbnb 房源标题的长度。你会遇到愤怒的房东，你需要进行设计更改以确保能以不同方式显示。系统越复杂，这种改动本身就越复杂。这可能是一个描述二阶思维的糟糕方式。

---

### (00:44:01) Lenny

**English:**
That makes total sense. And that's something we dealt with it, sorry to interrupt, but that's like on the host team, we dealt with this question often of just any change you make and the listing flow is going to impact so much of the experience of a host and a guest. And so that makes total sense. Sorry, keep going.

**中文翻译:**
这完全说得通。抱歉打断一下，我们在房东团队也经常处理这个问题：你在发布流程中做的任何改动都会极大地影响房东和房客的体验。所以这非常有道理。抱歉，请继续。

---

### (00:44:16) Nickey Skarstad

**English:**
Yeah. No, and I think that forcing yourself and your team to think in that way is just a really good thinking exercise because it will save you time and it will save you money, a lot of money later, if you don't constantly have to rebuild things when you want to make changes to your system later. And that ladders up again into having a very clear vision and a strategy. Because what you're doing is you're starting to think on the long horizon. And so the decisions that you're making today are in service of that long horizon. So you can actually build in that direction and you don't constantly have to rebuild every time you're trying to change something.

**中文翻译:**
是的。我认为强迫自己和团队以这种方式思考是一个非常好的思维练习，因为它会为你节省时间，以后也会为你节省大量的金钱，因为你不需要在以后想要更改系统时不断地推倒重来。这再次向上连接到拥有清晰的愿景和策略。因为你所做的是开始长远考虑。你今天的决定是为那个长远目标服务的。这样你就能真正朝着那个方向构建，而不需要每次尝试改变什么时都得重做。

---

### (00:44:50) Lenny

**English:**
On the second order thinking, sorry, I called it second order decision, but in this framework that you spoke of, how do you actually operationalize this concept? When you're planning, do you write out in the document second order impact that we should be thinking about, or do you do something else?

**中文翻译:**
关于二阶思维（抱歉我刚才叫它二阶决策），在你提到的这个框架中，你实际上是如何操作这个概念的？在规划时，你会在文档中写出“我们应该考虑的二阶影响”吗？还是做些别的？

---

### (00:45:05) Nickey Skarstad

**English:**
Yeah. So I think there's many ways to do this. If you have a spec-ed template or a piece of documentation that your team typically use when they're writing out product strategy or product requirements, et cetera, you can put a line in here to force people to think about it. I also think thinking about first principles and writing out first principles for the changes that you're making often are in service of second order thinking. Where it's like here are the things that we care about. Here's why these things are important. And we want to make sure these are baked into what we're building. Typically you'll write those through the lens of second order thinking.

**中文翻译:**
是的。我认为有很多方法可以做到。如果你有规格说明（spec）模板或团队在编写产品策略、产品需求文档（PRD）时常用的文档，你可以在里面加一行，强迫大家去思考它。我也认为思考第一性原理并为你所做的改动写下第一性原理，通常也是在为二阶思维服务。比如：“这是我们关心的事。这是为什么这些事很重要。我们要确保这些被融入到我们构建的东西中。”通常你会通过二阶思维的视角来编写这些内容。

---

### (00:45:36) Nickey Skarstad

**English:**
Shopify uses first principles a lot in everything that they build. And this is something I took away from that way of working because it's extremely effective. If you can get teams to align on first principles early on, it saves you a lot of heartache later because you've got people to align way early days before you even got into the design process, or before you had to start thinking about how do we actually technically implement this. And then the other way I would say is there's ways to structure or have thoughtful discussion around second order effects. That could be a brainstorm. You could use Miro to think about that. We're going to make these changes today. How do they cascade through our ecosystem? What are the gotchas or the things we need to worry about? And again, I think the more complex your ecosystem is, the more you are forced to do this. A lot of founders in early stage products don't think like this because they're so focused on the product market fit. We need to just get something that people are using. That then when they get product market fit, they realize when they get into scale mode, they didn't build something scalable, and they have to rebuild things which can actually really hurt them when they're trying to grow really quickly later on.

**中文翻译:**
Shopify 在构建每一件事时都大量使用第一性原理。这是我从那种工作方式中学到的，因为它极其有效。如果你能让团队尽早对第一性原理达成一致，就能避免以后的很多心痛，因为你在进入设计过程或思考如何技术实现之前，就已经让大家达成了一致。另一种方法是，可以通过结构化或深入讨论二阶效应。这可以是一次头脑风暴，你可以用 Miro 来思考：我们今天做这些改动，它们如何在我们的生态系统中产生连锁反应？有哪些陷阱或我们需要担心的事？再次强调，我认为生态系统越复杂，你就越被迫这样做。很多早期产品的创始人不这么想，因为他们太专注于 PMF 了——“我们只需要做出点有人用的东西”。结果当他们找到 PMF 进入规模化阶段时，才发现自己构建的东西不可扩展，不得不重做，这在他们后期想要快速增长时会造成很大伤害。

---

### (00:46:35) Lenny

**English:**
Yeah. Absolutely. Happens all the time. For principles, do you put those in to say the team strategy, like the quarterly strategy document? Like here's our principles for the quarter? Is that how you generally do that?

**中文翻译:**
是的，绝对是。这种情况一直在发生。关于原则，你会把它们放进团队策略里吗，比如季度策略文档？写上“这是我们本季度的原则”？你通常是这么做的吗？

---

### (00:46:47) Nickey Skarstad

**English:**
Yeah. I think that is a great place to put it. You can write them on the feature level too. So something that you're building, just getting clearer on here are the things that matter to us. Here's what we care about. We're going to design in service of these things. And here are the things that aren't that important. And again, those are the types of places in a product requirements doc where people will argue the most, which is a good thing because you're basically discussing and debating sort of foundations of what you're going to build before you get into the work of building it. And so those exercises are always a good idea.

**中文翻译:**
是的。我认为那是放原则的好地方。你也可以在功能层面上写。对于你正在构建的东西，明确：这些是对我们重要的事，这是我们关心的，我们将为这些目标而设计；而这些事没那么重要。再次强调，这些是 PRD 文档中人们争论最多的地方，这是好事，因为你基本上是在开始构建工作之前，讨论和辩论你要构建的东西的基础。所以这些练习总是个好主意。

---

### (00:47:16) Lenny

**English:**
Awesome. I love that. Okay. So going back, because I wanted to close this thread, you've come up with your vision, your mission, your strategy, your goals as a team. People start to align around it. What do you do to kick it off and get people on board and aware of the plan, and then to stay on plan with that strategy and not kind of be distracted by new priorities and shiny objects?

**中文翻译:**
太棒了，我喜欢这个。好，回到刚才的话题，我想结束这一部分：你已经得出了愿景、使命、策略和团队目标。大家开始达成一致。你如何启动它，让大家参与进来并了解计划，然后如何保持执行该策略而不被新的优先级或“闪亮的新事物”（shiny objects）分散注意力？

---

### (00:47:38) Nickey Skarstad

**English:**
Yes. Oh, the shiny object thing is very real. Good question. So for example, I just did this recently where I brought my team along through the OKR process for Q2 planning. They had a say in basically what we decided we were going to work on. It went up for leadership approval. We got approval. And my process was I used Loom, which is another one of my favorite products. It's just a really easy screen share and video recording tool that you can share with teams. And so I just recapped, "All right, here's what I presented to leadership. Here are the feedback that we got. Here's the strategic feedback that we got. And here are the changes we're going to make. Any questions, let me know." And I posted it in Slack.

**中文翻译:**
是的。噢，“闪亮新事物”的问题非常真实。好问题。举个例子，我最近刚做完这件事：我带着团队经历了第二季度的 OKR 规划过程。他们对我们要做的内容有发言权。然后提交给领导层审批，我们获得了批准。我的流程是使用 Loom（这也是我最喜欢的产品之一，它是一个非常简单的屏幕共享和视频录制工具）。我录了一个回顾：“好了，这是我向领导层展示的内容。这是我们收到的反馈，这是战略层面的反馈。这是我们要做的改动。有任何问题请告诉我。”然后我把它发到了 Slack 上。

---

### (00:48:10) Nickey Skarstad

**English:**
So I was just trying to keep the feedback loop really quick and tight with teams rather than wait till the next meeting you have with them a week later. I was like, all right, I'm going to just try to spend five minutes recording this and get it out ASAP. And that helps because then it gets people excited. Okay, cool. This thing that I worked on got really great feedback from leadership, and now we're working on it. I'm excited to get going. And then it depends. Usually depending on the project, I have some sort of kickoff. I don't usually do a quarterly kickoff or anything like that because I think there's usually disparate teams owning different parts of strategy. But usually having a good weekly team meeting where you're really thoughtful about cascading feedback down from leadership, constantly checking in on what are we trying to do here? What is our strategy? How are these goals that we set laddering up? Are we achieving it? Are we not? Whatever. Having a meeting like that where you're kind of constantly talking about it each week also helps people feel bought in and not get distracted.

**中文翻译:**
我只是想保持与团队之间非常快速且紧密的反馈循环，而不是等到一周后的下一次会议。我想：“好吧，我就花五分钟录一下，尽快发出去。”这很有帮助，因为它能让大家感到兴奋：“太酷了，我负责的东西得到了领导层非常棒的反馈，现在我们要开始做了，我很兴奋。”然后视情况而定，通常根据项目，我会有一个启动会。我通常不做季度启动会之类的，因为通常有不同的团队负责策略的不同部分。但通常会有一个高质量的每周团队会议，在会上你会非常用心地传达领导层的反馈，不断检查：我们在这里尝试做什么？我们的策略是什么？我们设定的这些目标是如何向上支撑的？我们达成了吗？没达成吗？诸如此类。每周不断讨论这些的会议也有助于让大家感到参与感，不被分心。

---

### (00:49:14) Nickey Skarstad

**English:**
And actually I found that teams who are very bought to your vision and strategy are less distractable. Where I usually have more trouble is with leadership that aren't necessarily in the weeds with your team every day. And I'll get an idea. "Have you thought about doing this one random obscure thing?" "Yes. However, it's not in service of this long term plan, so we don't want to do that right now because we don't think it's the best use of our time."

**中文翻译:**
实际上我发现，非常认同愿景和策略的团队更不容易分心。我通常遇到麻烦的地方是那些不一定每天和团队在一起处理细节的领导层。我会收到一个想法：“你有没有想过做这个随机的、模糊的小事？”我会回答：“想过。但是，它不符合我们的长期计划，所以我们现在不想做，因为我们认为这不是对时间的最佳利用。”

---

### (00:49:23) Lenny

**English:**
Got it. And the way you're describing it, this is as a manager of product managers- (00:49:27): Yep. (00:49:28): ... versus an ICPM? Cool. So as an ICPM, I imagine you would do a quarterly kickoff, or whatever your cycle length. You kick off with the team. Here's what we're doing. Any questions?

**中文翻译:**
明白了。你描述的方式是作为产品经理的经理（PM Manager）……（Nickey：是的）……而不是作为个人贡献者 PM（ICPM）？酷。所以作为 ICPM，我猜你会做一个季度启动会，或者根据你的周期长度。你和团队一起启动：“这就是我们要做的，有问题吗？”

---

### (00:49:38) Nickey Skarstad

**English:**
Totally.

**中文翻译:**
完全正确。

---

### (00:49:40) Lenny

**English:**
Okay. Another thing I wanted to make sure we have time to chat about is product review meetings and process. Just kind of like how do you, as a product leader, make sure that you're shipping great stuff that you're proud of and that your leaders aren't surprised by? How do you design just a product review and design process.

**中文翻译:**
好。另一件我想确保有时间聊聊的事是产品评审会议和流程。作为产品领导者，你如何确保发布的是让你自豪的优秀产品，且不会让你的领导感到意外？你如何设计产品评审和设计流程？

---

### (00:49:56) Nickey Skarstad

**English:**
Yeah. So I have a lot of strong feelings on product reviews. And it's because I've been in a lot of different organizations and I've seen a lot of bad ways of doing this honestly. And I think it also depends on the product that you're building and the team that you've created. So I don't think that there's one right or wrong way to do this. Where I've seen them fail is when they happen at the function level, and they're not done or shared as a team. Typically it's normal to have a design review or to have some sort of technical review. And the more you can try to bring those different review processes into one central moment to check in, the better it tends to go. Because what happens is you'll have feedback in a vacuum. The design leader will give the designer feedback, and then you don't hear about it. Or there'll be some technical flaw that happens in a very specific technical review that doesn't get back to the larger team.

**中文翻译:**
好的。我对产品评审有很多强烈的看法。这是因为我待过很多不同的组织，老实说见过很多糟糕的做法。我认为这也取决于你构建的产品和组建的团队。所以我不认为有唯一的对错之分。我见过失败的情况通常是评审发生在职能层级（function level），而不是作为一个团队共同完成或分享。通常有设计评审或某种技术评审是很正常的。但你越能尝试将这些不同的评审过程带入一个中心时刻进行检查，效果往往越好。因为如果分开做，反馈就会在真空中产生。设计领导给设计师反馈，然后你听不到；或者在某个非常具体的技术评审中发现了技术缺陷，但没有传达给大团队。

---

### (00:50:43) Nickey Skarstad

**English:**
So finding ways to make sure that those parts of your process are shared across each function, and you attend them and prepare for them as a team, I think really helps a lot of that. I'm not saying that you shouldn't have a design review. Of course you should. I mean, you should just be really thoughtful about having moments, especially if there are moments where you're blessing something to move forward, to making sure the whole team is there. And that there's a very strategic check-in process to get those things approved that everyone knows about and is a part of.

**中文翻译:**
所以，找到方法确保流程中的这些部分在各职能部门之间共享，并且你们作为一个团队去参加和准备，我认为这很有帮助。我不是说不该有设计评审，当然应该有。我的意思是，你应该非常用心地安排一些时刻，特别是当你批准某件事继续推进时，要确保整个团队都在场。并且要有一个非常战略性的检查流程来批准这些事情，让每个人都知道并参与其中。

---

### (00:51:11) Lenny

**English:**
Is that a meeting that you do weekly and you invite the designer and the engineer? Who do you invite, I guess, and what is the goal of that meeting? The goal of that meeting, I imagine, is approved the product to go launch and build.

**中文翻译:**
那是你每周都会开的会吗？你会邀请设计师和工程师吗？你会邀请谁？那个会议的目标是什么？我猜目标是批准产品进入发布和构建阶段。

---

### (00:51:23) Nickey Skarstad

**English:**
Yeah. And I think especially going back to the one way, two way door moment, giving teams autonomy to ship some things that you think are two way doors and aren't necessarily mission critical are important to your vision, but aren't going to conflate with the larger system, I think trying to keep things quick and not have too many barriers for people to ship is incredibly important. So you'll have to figure that out for your own org and it's nuances, but that is something that is important. But when there are moments where you think it is basically a feedback gate, where it's a gate you need to walk through and a specific moment in time where you've gotten feedback, I think having a cross-functional meeting where there's a clear pre-read or something that's sent before. It's like, here's what we're talking about today. And then aligning on, do we think this meets our goals and does this meet our quality bar? And doing that in a really thoughtful way just so the team gets feedback. So the leadership is plugged in, but also so you're not standing the way of people shipping their products.

**中文翻译:**
是的。我想特别是回到“单向门与双向门”的时刻，给予团队自主权去发布一些你认为是双向门的东西——这些东西对愿景重要但并非任务关键型，也不会与大系统冲突。我认为保持快速、不给发布设置太多障碍极其重要。你必须根据自己组织的细微差别来弄清楚这一点，但这很重要。但当你认为这是一个“反馈关卡”（feedback gate）时——即你需要跨过的一个关卡，一个获取反馈的特定时刻——我认为应该召开跨职能会议，并提前发送清晰的预读材料。比如：“这就是我们今天要谈的内容。”然后达成一致：我们认为这符合我们的目标吗？符合我们的质量标准吗？以一种非常周到的方式进行，这样团队能得到反馈，领导层能参与进来，同时你也不会阻碍大家发布产品。

---

### (00:52:17) Lenny

**English:**
And then do you check in throughout the process of the product being built, or do you kind of encourage teams to get to a point where it's basically ready for approval?

**中文翻译:**
那么在产品构建的过程中你会全程检查吗？还是说你会鼓励团队做到基本准备好审批的程度再找你？

---

### (00:52:26) Nickey Skarstad

**English:**
Yeah. Ideally in a perfect world, there's three check-in moments. There is the first principles check-in. What are you trying to build, or what are you trying to do? What are the sort of foundations that you're going to build on? What is the most important thing? What are you solving for? Getting approval on that, weirdly, is almost the most important thing. Because it saves a lot of teams a lot of time when they get later in their feedback review process and people are like, "You're not solving for the right thing." So that's important.

**中文翻译:**
是的。理想情况下，在完美的世界里，有三个检查时刻。第一是“第一性原理检查”：你尝试构建什么，或者你尝试做什么？你要建立在什么样的基础上？最重要的事情是什么？你在解决什么问题？奇怪的是，对这一步达成一致几乎是最重要的。因为它能为很多团队节省大量时间，避免他们在后期的反馈评审中听到：“你解决的问题不对。”所以这很重要。

---

### (00:52:49) Nickey Skarstad

**English:**
Once you've aligned on that, then it's like, all right, what approach are we going to use? What are we going to build? And that's sort of how we solve the problem. Making sure that there is a technical component there too so there's some sort of infrastructure review or architecture review, or whatever you want to call it. And then it's like, all right, this is ready to ship. Let's check in again. Do we think it's ready? And I think that, again, it depends on your organization. If you have a very small team, you might be very plugged in and these things might not need to happen. But in bigger organizations, especially where leadership isn't always able to be in the room, making sure that you have a clear checking in a few times to make sure that everyone is moving in the right direction and everyone feels good is, I think, a worthwhile exercise.

**中文翻译:**
一旦达成一致，接下来就是：我们要用什么方法？我们要构建什么？这就是我们如何解决问题。确保其中也有技术部分，比如某种基础设施评审或架构评审，随便你怎么称呼。最后就是：“好了，这准备好发布了。”让我们再检查一次：我们认为它准备好了吗？我认为这再次取决于你的组织。如果你有一个非常小的团队，你可能深度参与其中，这些步骤可能不需要。但在较大的组织中，特别是领导层并不总是在场的情况下，确保有几次清晰的检查，以确保每个人都朝着正确的方向前进且感觉良好，我认为这是一个值得的练习。

---

### (00:53:27) Lenny

**English:**
I love that. Such a simple framework. And then one last question along those lines, do you leave it up to the team to schedule these meetings, or are you pulling it out of them and making sure they schedule it?

**中文翻译:**
我喜欢这个，非常简单的框架。关于这个的最后一个问题：你是让团队自己决定什么时候安排这些会议，还是由你督促他们确保安排好？

---

### (00:53:36) Nickey Skarstad

**English:**
Today, because the team that I'm working on is pretty small, and we're pretty pre-product market fit, we're not doing a ton of very formal check-in moments because we don't need to be. Because it's a small team and we're all cruising together. But in bigger orgs that I've worked in, for Shopify, for example, there was a process around having these meetings and who would be there. And so those would kind of be scheduled through the larger processor system that they were working in, which really worked for them actually. And I think it allowed teams to be pretty autonomous on the day to day, but just making sure that there was feedback coming of from their users as well as from leadership.

**中文翻译:**
目前，因为我所在的团队非常小，而且我们还处于 PMF 之前的阶段，我们没有做很多非常正式的检查，因为不需要。因为团队小，大家都在一起推进。但在我待过的大型组织中，比如 Shopify，有一套关于召开这些会议以及谁该出席的流程。这些会议会通过他们运行的大型流程或系统来安排，这对他们其实非常有效。我认为这让团队在日常工作中保持了相当大的自主权，同时也确保了能收到来自用户和领导层的反馈。

---

### (00:54:08) Lenny

**English:**
Got it. One last question before we get to our exciting lightning round. And it's something that I've been thinking a lot about recently, which is around remote work as a product manager. I left Airbnb before COVID, and so I never lived in this world of everything is remote and product managing remotely. Is there anything you've picked up or learned that has been really helpful to being a product leader in a remote world?

**中文翻译:**
明白了。在进入精彩的闪电轮环节之前最后一个问题。这是我最近一直在思考的事情，即作为产品经理的远程办公。我在疫情前离开了 Airbnb，所以我从未经历过这种全员远程、远程进行产品管理的世界。作为远程环境下的产品领导者，你有没有学到什么非常有帮助的经验？

---

### (00:54:30) Nickey Skarstad

**English:**
Yeah. I would say last couple years have just been a huge shift in my ways of working. I sort of grew up as a PM in IRL environments where we did the majority of our work together in the same room. So that was whiteboarding, having a quick sync after you had an in person meeting to finalize some details or keep hashing out a problem. It's so cheesy and overhyped, but the proverbial water cooler moment where you see somebody, and you're like, "Hey, how are you doing, Hey, did you hear about this thing?" All of those things literally went away overnight.

**中文翻译:**
是的。我想说过去几年我的工作方式发生了巨大的转变。我作为 PM 的成长环境是 IRL（现实生活中）的环境，我们大部分工作都是在同一个房间里完成的。比如画白板，在面对面会议后进行快速同步以敲定细节或继续讨论问题。虽然这听起来很俗气且被过度炒作，但所谓的“饮水机时刻”——你见到某人说：“嘿，最近怎么样？嘿，你听说那件事了吗？”——所有这些真的在一夜之间消失了。

---

### (00:55:01) Nickey Skarstad

**English:**
And I think especially the job of a PM, it's hard under normal times because you are doing so much labor to make sure people are informed and give feedback, et cetera. And then overnight you took away a lot of the methods that they were using to do it. And so I think that has been a pretty profound shift for a lot of people working in product roles. The good news is there's a ton of new tools and new technology that's actually being built right now that's majorly helpful for this. So I use Slack in very new ways today than I did two years ago. Things like just making sure to post more asynchronous updates. Trying to actually take the burden off of an IRL or a Zoom meeting. Can we talk about this asynchronously and do it in Slack? Slack has this really great feature called huddles where you can just quickly get on. It's just audio. So there's no video. And you can just have a 30 second conversation. It's good for standups and things like that. Suggest you try it if you haven't yet.

**中文翻译:**
我认为特别是 PM 的工作，在正常时期就很辛苦，因为你需要付出大量劳动来确保大家知情、提供反馈等等。然后一夜之间，你失去了很多原本用来做这些事的方法。所以我认为这对很多从事产品工作的人来说是一个非常深刻的转变。好消息是，现在有很多正在构建的新工具和新技术对此非常有帮助。我今天使用 Slack 的方式与两年前截然不同。比如确保发布更多异步更新，尝试减轻面对面或 Zoom 会议的负担。我们能异步讨论并在 Slack 上完成吗？Slack 有一个非常棒的功能叫 Huddles（语音群聊），你可以快速加入，只有音频没有视频，可以进行 30 秒的简短对话。这对于站会之类的事情非常好。如果你还没试过，建议尝试一下。

---

### (00:55:56) Nickey Skarstad

**English:**
And then a lot of the old in person whiteboarding, things like that, you can do those now using awesome tools like Miro and FigJam. And I feel like, especially at Airbnb, we had such an international team that there was always somebody who was remote typically. And I think we never really got the remote experience right. And now that the majority of our teams are remote, I'm a fully remote person, I've been a lot more thoughtful about making sure we're creating a really good experience of how we're working for the larger team. And so I think you have to hack on this with your team. Different teams have different ways of working, but trying to be a synchronous, using Slack, making sure you're following up in very visible ways where people can see. Don't rely on Zoom meetings to fill all of your time. Otherwise people will literally hate you. And things like that really make a huge difference.

**中文翻译:**
以前那些面对面的白板协作，现在可以用 Miro 和 FigJam 这样出色的工具完成。我觉得，特别是在 Airbnb，我们有一个非常国际化的团队，通常总有人是远程的。我认为我们从未真正把远程体验做对。现在我们大部分团队都是远程的，我本人也是全职远程，我更加用心地确保我们为大团队创造了良好的工作体验。所以你必须和团队一起去“破解”这个问题。不同的团队有不同的工作方式，但尝试异步化、使用 Slack、确保以大家可见的方式进行跟进。不要依赖 Zoom 会议填满你所有的时间，否则大家真的会恨你。这些事情真的会产生巨大的影响。

---

### (00:56:43) Lenny

**English:**
Awesome. Super helpful. All right. Nickey, are you ready for the lightning round?

**中文翻译:**
太棒了，非常有帮助。好了，Nickey，准备好进入闪电轮环节了吗？

---

### (00:56:48) Nickey Skarstad

**English:**
I'm ready. Let's do this.

**中文翻译:**
准备好了，开始吧。

---

### (00:56:49) Lenny

**English:**
What's a book that you recommend most to other product managers?

**中文翻译:**
你最推荐给其他产品经理的一本书是什么？

---

### (00:56:53) Nickey Skarstad

**English:**
I love Thinking in Systems by Donella Meadows.

**中文翻译:**
我喜欢 Donella Meadows 的《系统之美》（Thinking in Systems）。

---

### (00:56:57) Lenny

**English:**
Awesome. Okay. We're going to link to that in the description. Other than Duolingo, what's another company that you recommend the PMs go work at or explore when they're looking for a new gig?

**中文翻译:**
太棒了。我们会把链接放在描述里。除了 Duolingo，你还推荐 PM 在找新工作时去哪家公司工作或探索？

---

### (00:57:07) Nickey Skarstad

**English:**
Yeah, I would say Etsy hands down.

**中文翻译:**
毫无疑问，我会说 Etsy。

---

### (00:57:09) Lenny

**English:**
And why is that?

**中文翻译:**
为什么呢？

---

### (00:57:10) Nickey Skarstad

**English:**
I think it's a great place to learn how to be a PM. Data driven, really supportive, product leadership, and a super fun product to build.

**中文翻译:**
我认为那是学习如何做 PM 的好地方。数据驱动，产品领导层非常支持，而且构建的产品非常有趣。

---

### (00:57:18) Lenny

**English:**
Awesome. Love that. What's the current favorite kind of app or piece of software that helps you do your work better?

**中文翻译:**
太棒了。目前你最喜欢的、能帮你更好工作的应用或软件是什么？

---

### (00:57:25) Nickey Skarstad

**English:**
I'm obsessed with Superhuman, which is a email productivity app, which once you start using it, you can't not use it. You basically have to use it for the rest of your days. I also am obsessed with Loom, which is a video recording tool that makes it really easy to share really quick video updates.

**中文翻译:**
我痴迷于 Superhuman，这是一个邮件效率应用，一旦开始用就停不下来，你下半辈子基本上都得用它。我也痴迷于 Loom，这是一个视频录制工具，分享快速视频更新非常方便。

---

### (00:57:41) Lenny

**English:**
Awesome, great choices. And then outside of work, what's a current favorite app or just piece of software that you love?

**中文翻译:**
很棒的选择。那么在工作之外，目前你最喜欢的应用或软件是什么？

---

### (00:57:47) Nickey Skarstad

**English:**
Definitely TikTok. Short form video is very fun and entertaining. Can't get enough of it, and have been creating some myself. So I'm definitely hooked.

**中文翻译:**
绝对是 TikTok。短视频非常有趣且有娱乐性。我百看不厌，自己也在创作一些。我确实上瘾了。

---

### (00:57:56) Lenny

**English:**
While we're on that topic, how do people find you on TikTok?

**中文翻译:**
既然聊到这个，大家怎么在 TikTok 上找到你？

---

### (00:57:58) Nickey Skarstad

**English:**
Yeah, it's just my name. It's Nickey Skarstad, and give me a follow.

**中文翻译:**
就是我的名字 Nickey Skarstad，欢迎关注。

---

### (00:58:03) Lenny

**English:**
I'm a very happy follower. And then I'll link to that in description too. Who's a favorite person that you like to follow on either Twitter, or Instagram, or even TikTok?

**中文翻译:**
我是你的忠实粉丝。我也会把链接放在描述里。在 Twitter、Instagram 甚至 TikTok 上，你最喜欢关注的人是谁？

---

### (00:58:12) Nickey Skarstad

**English:**
Yeah, so I love, she is a cultural journalist, her name is Anne Helen Petersen. And she's really plugged into sort of the larger cultural zeitgeist of the time. And I always give people, when people ask me my top advice for new PMs, it's just to be a consumer. To download new products, to try them out, to use all the things and try them because I think it actually makes you a better product builder. And follow people that are not just tech people on Twitter. You are doing yourself a disservice if your entire feed is tech people. So find people that are plugged into cultural zeitgeist because it helps you also understand the moment in which you are shipping, and it'll make sure that you're acing your product marketing and your messaging and you're building the right thing.

**中文翻译:**
我非常喜欢一位文化记者，她叫 Anne Helen Petersen。她对当下的文化时代精神（zeitgeist）非常有洞察力。当人们问我对新 PM 的首要建议时，我总是说：做一个消费者。去下载新产品，去尝试它们，去使用各种东西。因为我认为这能让你成为更好的产品构建者。在 Twitter 上不要只关注技术圈的人，如果你的整个信息流全是技术人，那是在亏待你自己。去关注那些洞察文化时代精神的人，因为这能帮你理解你发布产品时的社会背景，确保你的产品营销和信息传递是精准的，确保你在构建正确的东西。

---

### (00:58:53) Lenny

**English:**
What's her name again?

**中文翻译:**
她叫什么名字来着？

---

### (00:58:54) Nickey Skarstad

**English:**
Her name is Anne Helen Petersen.

**中文翻译:**
她叫 Anne Helen Petersen。

---

### (00:58:56) Lenny

**English:**
Anne Helen Petersen. Love it. Okay. And then final question. Who's been your favorite manager?

**中文翻译:**
Anne Helen Petersen，太棒了。最后一个问题：谁是你最喜欢的经理？

---

### (00:59:01) Nickey Skarstad

**English:**
Yeah, so I couldn't pick one person here, so don't be mad. But it's actually a lot of women that I worked for at Etsy. The majority of my entire reporting line the time that I was there was all women, which has never happened to me again. So shout out to Kruti Patel, who is their current chief product officer, a woman named Heather Jassy, who ran the community team at Etsy long ago, who was a true delight to work for. And then Linda Findley, who is now the CEO of Blue Apron, but she was the chief operating officer at my time at Etsy. And she was my boss for a bit. And she was wonderful.

**中文翻译:**
好的，我没法只选一个人，别生气。其实是我在 Etsy 工作时遇到的很多女性领导。我在那里的整个汇报线上大部分都是女性，这在我之后的职业生涯中再也没发生过。所以要向现任 CPO Kruti Patel 致敬；还有很久以前在 Etsy 负责社区团队的 Heather Jassy，为她工作真的很愉快；还有 Linda Findley，她现在是 Blue Apron 的 CEO，但在我待在 Etsy 期间她是首席运营官（COO），也当过我一阵子老板，她非常出色。

---

### (00:59:31) Lenny

**English:**
Amazing. Thank you for sharing all that. And thank you so much for joining me, Nickey, for doing this. Where can people find you online? And then just generally, how can people that are listening to this be helpful to you?

**中文翻译:**
太棒了，谢谢分享。Nickey，非常感谢你参加这次节目。大家可以在哪里找到你？听众们可以如何帮到你？

---

### (00:59:43) Nickey Skarstad

**English:**
Yeah, so I have newly become obsessed with TikTok, like I said before. I've been creating some fun, little short form videos. One of my regrets as a long time product builder is it's very time consuming to write down the stories of building products and to share them. But I found TikTok actually really easy to do that. So I'm going to try to experiment there a little bit more. So you can follow me, I'm @NickeySkarstad on TikTok. And then I have a newsletter. I call it Builders. It's nickey.substack.com. Nickey is spelled like Mickey Mouse, but with an N. N-I-C-K-E-Y, .substack.com. And I publish their occasionally. I need to get it going again. But again, trying to write down more of the stories of actually being a builder who's been doing this for a long time. Because a lot of us don't have a lot of time to actually talk about it, but it's really interesting work and I want to share it more.

**中文翻译:**
好的。正如我之前说的，我最近迷上了 TikTok。我一直在创作一些有趣的小短片。作为一名资深产品构建者，我的一大遗憾是写下并分享构建产品的故事非常耗时。但我发现 TikTok 让这件事变得非常容易。所以我打算在那儿多做些尝试。你可以关注我，TikTok 账号是 @NickeySkarstad。我还有一个通讯（newsletter），叫 Builders，网址是 nickey.substack.com。Nickey 的拼写像 Mickey Mouse，但开头是 N。我会偶尔在那儿发布内容，我得让它重新活跃起来。再次强调，我尝试写下更多作为一名长期实干者的故事，因为我们很多人其实没时间去谈论这些，但这些工作真的很有趣，我想更多地分享它。

---

### (01:00:29) Lenny

**English:**
Awesome. I'm a follower and a subscriber to both. So highly recommend that.

**中文翻译:**
太棒了。我两个都关注并订阅了，强烈推荐。

---

### (01:00:29) Nickey Skarstad

**English:**
I love it.

**中文翻译:**
太好了。

---

### (01:00:33) Lenny

**English:**
And thank you so much, Nickey.

**中文翻译:**
非常感谢，Nickey。

---

### (01:00:34) Nickey Skarstad

**English:**
Yeah. Thank you, Lenny.

**中文翻译:**
谢谢，Lenny。

---

### (01:00:35) Lenny

**English:**
That was awesome. Thank you for listening. If you enjoy the chat, don't forget to subscribe to the podcast. You could also learn more at lennyspodcast.com. I'll see you in the next episode.

**中文翻译:**
太棒了。感谢大家的收听。如果你喜欢这次聊天，别忘了订阅播客。你也可以在 lennyspodcast.com 了解更多。下期节目再见。